// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct Us_F_Us { unsigned short v1; float v2; unsigned short v3; };
struct Us_F_Vp { unsigned short v1; float v2; void * v3; };
struct Us_I { unsigned short v1; int v2; };
struct Us_I_BFu15i { unsigned short v1; int v2; unsigned int v3:15; };
struct Us_I_BFu15ll { unsigned short v1; int v2; unsigned long long v3:15; };
struct Us_I_BFu15s { unsigned short v1; int v2; unsigned short v3:15; };
struct Us_I_BFu16i { unsigned short v1; int v2; unsigned int v3:16; };
struct Us_I_BFu16ll { unsigned short v1; int v2; unsigned long long v3:16; };
struct Us_I_BFu16s { unsigned short v1; int v2; unsigned short v3:16; };
struct Us_I_BFu17i { unsigned short v1; int v2; unsigned int v3:17; };
struct Us_I_BFu17ll { unsigned short v1; int v2; unsigned long long v3:17; };
struct Us_I_BFu1c { unsigned short v1; int v2; unsigned char v3:1; };
struct Us_I_BFu1i { unsigned short v1; int v2; unsigned int v3:1; };
struct Us_I_BFu1ll { unsigned short v1; int v2; unsigned long long v3:1; };
struct Us_I_BFu1s { unsigned short v1; int v2; unsigned short v3:1; };
struct Us_I_BFu31i { unsigned short v1; int v2; unsigned int v3:31; };
struct Us_I_BFu31ll { unsigned short v1; int v2; unsigned long long v3:31; };
struct Us_I_BFu32i { unsigned short v1; int v2; unsigned int v3:32; };
struct Us_I_BFu32ll { unsigned short v1; int v2; unsigned long long v3:32; };
struct Us_I_BFu33 { unsigned short v1; int v2; unsigned long long v3:33; };
struct Us_I_BFu7c { unsigned short v1; int v2; unsigned char v3:7; };
struct Us_I_BFu7i { unsigned short v1; int v2; unsigned int v3:7; };
struct Us_I_BFu7ll { unsigned short v1; int v2; unsigned long long v3:7; };
struct Us_I_BFu7s { unsigned short v1; int v2; unsigned short v3:7; };
struct Us_I_BFu8c { unsigned short v1; int v2; unsigned char v3:8; };
struct Us_I_BFu8i { unsigned short v1; int v2; unsigned int v3:8; };
struct Us_I_BFu8ll { unsigned short v1; int v2; unsigned long long v3:8; };
struct Us_I_BFu8s { unsigned short v1; int v2; unsigned short v3:8; };
struct Us_I_BFu9i { unsigned short v1; int v2; unsigned int v3:9; };
struct Us_I_BFu9ll { unsigned short v1; int v2; unsigned long long v3:9; };
struct Us_I_BFu9s { unsigned short v1; int v2; unsigned short v3:9; };
struct Us_I_C { unsigned short v1; int v2; char v3; };
struct Us_I_D { unsigned short v1; int v2; double v3; };
struct Us_I_F { unsigned short v1; int v2; float v3; };
struct Us_I_I { unsigned short v1; int v2; int v3; };
struct Us_I_Ip { unsigned short v1; int v2; int * v3; };
struct Us_I_L { unsigned short v1; int v2; long long v3; };
struct Us_I_S { unsigned short v1; int v2; short v3; };
struct Us_I_Uc { unsigned short v1; int v2; unsigned char v3; };
struct Us_I_Ui { unsigned short v1; int v2; unsigned int v3; };
struct Us_I_Ul { unsigned short v1; int v2; unsigned long long v3; };
struct Us_I_Us { unsigned short v1; int v2; unsigned short v3; };
struct Us_I_Vp { unsigned short v1; int v2; void * v3; };
struct Us_Ip { unsigned short v1; int * v2; };
struct Us_Ip_BFu15i { unsigned short v1; int * v2; unsigned int v3:15; };
struct Us_Ip_BFu15ll { unsigned short v1; int * v2; unsigned long long v3:15; };
struct Us_Ip_BFu15s { unsigned short v1; int * v2; unsigned short v3:15; };
struct Us_Ip_BFu16i { unsigned short v1; int * v2; unsigned int v3:16; };
struct Us_Ip_BFu16ll { unsigned short v1; int * v2; unsigned long long v3:16; };
struct Us_Ip_BFu16s { unsigned short v1; int * v2; unsigned short v3:16; };
struct Us_Ip_BFu17i { unsigned short v1; int * v2; unsigned int v3:17; };
struct Us_Ip_BFu17ll { unsigned short v1; int * v2; unsigned long long v3:17; };
struct Us_Ip_BFu1c { unsigned short v1; int * v2; unsigned char v3:1; };
struct Us_Ip_BFu1i { unsigned short v1; int * v2; unsigned int v3:1; };
struct Us_Ip_BFu1ll { unsigned short v1; int * v2; unsigned long long v3:1; };
struct Us_Ip_BFu1s { unsigned short v1; int * v2; unsigned short v3:1; };
struct Us_Ip_BFu31i { unsigned short v1; int * v2; unsigned int v3:31; };
struct Us_Ip_BFu31ll { unsigned short v1; int * v2; unsigned long long v3:31; };
struct Us_Ip_BFu32i { unsigned short v1; int * v2; unsigned int v3:32; };
struct Us_Ip_BFu32ll { unsigned short v1; int * v2; unsigned long long v3:32; };
struct Us_Ip_BFu33 { unsigned short v1; int * v2; unsigned long long v3:33; };
struct Us_Ip_BFu7c { unsigned short v1; int * v2; unsigned char v3:7; };
struct Us_Ip_BFu7i { unsigned short v1; int * v2; unsigned int v3:7; };
struct Us_Ip_BFu7ll { unsigned short v1; int * v2; unsigned long long v3:7; };
struct Us_Ip_BFu7s { unsigned short v1; int * v2; unsigned short v3:7; };
struct Us_Ip_BFu8c { unsigned short v1; int * v2; unsigned char v3:8; };
struct Us_Ip_BFu8i { unsigned short v1; int * v2; unsigned int v3:8; };
struct Us_Ip_BFu8ll { unsigned short v1; int * v2; unsigned long long v3:8; };
struct Us_Ip_BFu8s { unsigned short v1; int * v2; unsigned short v3:8; };
struct Us_Ip_BFu9i { unsigned short v1; int * v2; unsigned int v3:9; };
struct Us_Ip_BFu9ll { unsigned short v1; int * v2; unsigned long long v3:9; };
struct Us_Ip_BFu9s { unsigned short v1; int * v2; unsigned short v3:9; };
struct Us_Ip_C { unsigned short v1; int * v2; char v3; };
struct Us_Ip_D { unsigned short v1; int * v2; double v3; };
struct Us_Ip_F { unsigned short v1; int * v2; float v3; };
struct Us_Ip_I { unsigned short v1; int * v2; int v3; };
struct Us_Ip_Ip { unsigned short v1; int * v2; int * v3; };
struct Us_Ip_L { unsigned short v1; int * v2; long long v3; };
struct Us_Ip_S { unsigned short v1; int * v2; short v3; };
struct Us_Ip_Uc { unsigned short v1; int * v2; unsigned char v3; };
struct Us_Ip_Ui { unsigned short v1; int * v2; unsigned int v3; };
struct Us_Ip_Ul { unsigned short v1; int * v2; unsigned long long v3; };
struct Us_Ip_Us { unsigned short v1; int * v2; unsigned short v3; };
struct Us_Ip_Vp { unsigned short v1; int * v2; void * v3; };
struct Us_L { unsigned short v1; long long v2; };
struct Us_L_BFu15i { unsigned short v1; long long v2; unsigned int v3:15; };
struct Us_L_BFu15ll { unsigned short v1; long long v2; unsigned long long v3:15; };
struct Us_L_BFu15s { unsigned short v1; long long v2; unsigned short v3:15; };
struct Us_L_BFu16i { unsigned short v1; long long v2; unsigned int v3:16; };
struct Us_L_BFu16ll { unsigned short v1; long long v2; unsigned long long v3:16; };
struct Us_L_BFu16s { unsigned short v1; long long v2; unsigned short v3:16; };
struct Us_L_BFu17i { unsigned short v1; long long v2; unsigned int v3:17; };
struct Us_L_BFu17ll { unsigned short v1; long long v2; unsigned long long v3:17; };
struct Us_L_BFu1c { unsigned short v1; long long v2; unsigned char v3:1; };
struct Us_L_BFu1i { unsigned short v1; long long v2; unsigned int v3:1; };
struct Us_L_BFu1ll { unsigned short v1; long long v2; unsigned long long v3:1; };
struct Us_L_BFu1s { unsigned short v1; long long v2; unsigned short v3:1; };
struct Us_L_BFu31i { unsigned short v1; long long v2; unsigned int v3:31; };
struct Us_L_BFu31ll { unsigned short v1; long long v2; unsigned long long v3:31; };
struct Us_L_BFu32i { unsigned short v1; long long v2; unsigned int v3:32; };
struct Us_L_BFu32ll { unsigned short v1; long long v2; unsigned long long v3:32; };
struct Us_L_BFu33 { unsigned short v1; long long v2; unsigned long long v3:33; };
struct Us_L_BFu7c { unsigned short v1; long long v2; unsigned char v3:7; };
struct Us_L_BFu7i { unsigned short v1; long long v2; unsigned int v3:7; };
struct Us_L_BFu7ll { unsigned short v1; long long v2; unsigned long long v3:7; };
struct Us_L_BFu7s { unsigned short v1; long long v2; unsigned short v3:7; };
struct Us_L_BFu8c { unsigned short v1; long long v2; unsigned char v3:8; };
struct Us_L_BFu8i { unsigned short v1; long long v2; unsigned int v3:8; };
struct Us_L_BFu8ll { unsigned short v1; long long v2; unsigned long long v3:8; };
struct Us_L_BFu8s { unsigned short v1; long long v2; unsigned short v3:8; };
struct Us_L_BFu9i { unsigned short v1; long long v2; unsigned int v3:9; };
struct Us_L_BFu9ll { unsigned short v1; long long v2; unsigned long long v3:9; };
struct Us_L_BFu9s { unsigned short v1; long long v2; unsigned short v3:9; };
struct Us_L_C { unsigned short v1; long long v2; char v3; };
struct Us_L_D { unsigned short v1; long long v2; double v3; };
struct Us_L_F { unsigned short v1; long long v2; float v3; };
struct Us_L_I { unsigned short v1; long long v2; int v3; };
struct Us_L_Ip { unsigned short v1; long long v2; int * v3; };
struct Us_L_L { unsigned short v1; long long v2; long long v3; };
struct Us_L_S { unsigned short v1; long long v2; short v3; };
struct Us_L_Uc { unsigned short v1; long long v2; unsigned char v3; };
struct Us_L_Ui { unsigned short v1; long long v2; unsigned int v3; };
struct Us_L_Ul { unsigned short v1; long long v2; unsigned long long v3; };
struct Us_L_Us { unsigned short v1; long long v2; unsigned short v3; };
struct Us_L_Vp { unsigned short v1; long long v2; void * v3; };
struct Us_S { unsigned short v1; short v2; };
struct Us_S_BFu15i { unsigned short v1; short v2; unsigned int v3:15; };
struct Us_S_BFu15ll { unsigned short v1; short v2; unsigned long long v3:15; };
struct Us_S_BFu15s { unsigned short v1; short v2; unsigned short v3:15; };
struct Us_S_BFu16i { unsigned short v1; short v2; unsigned int v3:16; };
struct Us_S_BFu16ll { unsigned short v1; short v2; unsigned long long v3:16; };
struct Us_S_BFu16s { unsigned short v1; short v2; unsigned short v3:16; };
struct Us_S_BFu17i { unsigned short v1; short v2; unsigned int v3:17; };
struct Us_S_BFu17ll { unsigned short v1; short v2; unsigned long long v3:17; };
struct Us_S_BFu1c { unsigned short v1; short v2; unsigned char v3:1; };
struct Us_S_BFu1i { unsigned short v1; short v2; unsigned int v3:1; };
struct Us_S_BFu1ll { unsigned short v1; short v2; unsigned long long v3:1; };
struct Us_S_BFu1s { unsigned short v1; short v2; unsigned short v3:1; };
struct Us_S_BFu31i { unsigned short v1; short v2; unsigned int v3:31; };
struct Us_S_BFu31ll { unsigned short v1; short v2; unsigned long long v3:31; };
struct Us_S_BFu32i { unsigned short v1; short v2; unsigned int v3:32; };
struct Us_S_BFu32ll { unsigned short v1; short v2; unsigned long long v3:32; };
struct Us_S_BFu33 { unsigned short v1; short v2; unsigned long long v3:33; };
struct Us_S_BFu7c { unsigned short v1; short v2; unsigned char v3:7; };
struct Us_S_BFu7i { unsigned short v1; short v2; unsigned int v3:7; };
struct Us_S_BFu7ll { unsigned short v1; short v2; unsigned long long v3:7; };
struct Us_S_BFu7s { unsigned short v1; short v2; unsigned short v3:7; };
struct Us_S_BFu8c { unsigned short v1; short v2; unsigned char v3:8; };
struct Us_S_BFu8i { unsigned short v1; short v2; unsigned int v3:8; };
struct Us_S_BFu8ll { unsigned short v1; short v2; unsigned long long v3:8; };
struct Us_S_BFu8s { unsigned short v1; short v2; unsigned short v3:8; };
struct Us_S_BFu9i { unsigned short v1; short v2; unsigned int v3:9; };
struct Us_S_BFu9ll { unsigned short v1; short v2; unsigned long long v3:9; };
struct Us_S_BFu9s { unsigned short v1; short v2; unsigned short v3:9; };
struct Us_S_C { unsigned short v1; short v2; char v3; };
struct Us_S_D { unsigned short v1; short v2; double v3; };
struct Us_S_F { unsigned short v1; short v2; float v3; };
struct Us_S_I { unsigned short v1; short v2; int v3; };
struct Us_S_Ip { unsigned short v1; short v2; int * v3; };
struct Us_S_L { unsigned short v1; short v2; long long v3; };
struct Us_S_S { unsigned short v1; short v2; short v3; };
struct Us_S_Uc { unsigned short v1; short v2; unsigned char v3; };
struct Us_S_Ui { unsigned short v1; short v2; unsigned int v3; };
struct Us_S_Ul { unsigned short v1; short v2; unsigned long long v3; };
struct Us_S_Us { unsigned short v1; short v2; unsigned short v3; };
struct Us_S_Vp { unsigned short v1; short v2; void * v3; };
struct Us_Uc { unsigned short v1; unsigned char v2; };
struct Us_Uc_BFu15i { unsigned short v1; unsigned char v2; unsigned int v3:15; };
struct Us_Uc_BFu15ll { unsigned short v1; unsigned char v2; unsigned long long v3:15; };
struct Us_Uc_BFu15s { unsigned short v1; unsigned char v2; unsigned short v3:15; };
struct Us_Uc_BFu16i { unsigned short v1; unsigned char v2; unsigned int v3:16; };
struct Us_Uc_BFu16ll { unsigned short v1; unsigned char v2; unsigned long long v3:16; };
struct Us_Uc_BFu16s { unsigned short v1; unsigned char v2; unsigned short v3:16; };
struct Us_Uc_BFu17i { unsigned short v1; unsigned char v2; unsigned int v3:17; };
struct Us_Uc_BFu17ll { unsigned short v1; unsigned char v2; unsigned long long v3:17; };
struct Us_Uc_BFu1c { unsigned short v1; unsigned char v2; unsigned char v3:1; };
struct Us_Uc_BFu1i { unsigned short v1; unsigned char v2; unsigned int v3:1; };
struct Us_Uc_BFu1ll { unsigned short v1; unsigned char v2; unsigned long long v3:1; };
struct Us_Uc_BFu1s { unsigned short v1; unsigned char v2; unsigned short v3:1; };
struct Us_Uc_BFu31i { unsigned short v1; unsigned char v2; unsigned int v3:31; };
struct Us_Uc_BFu31ll { unsigned short v1; unsigned char v2; unsigned long long v3:31; };
struct Us_Uc_BFu32i { unsigned short v1; unsigned char v2; unsigned int v3:32; };
struct Us_Uc_BFu32ll { unsigned short v1; unsigned char v2; unsigned long long v3:32; };
struct Us_Uc_BFu33 { unsigned short v1; unsigned char v2; unsigned long long v3:33; };
struct Us_Uc_BFu7c { unsigned short v1; unsigned char v2; unsigned char v3:7; };
struct Us_Uc_BFu7i { unsigned short v1; unsigned char v2; unsigned int v3:7; };
struct Us_Uc_BFu7ll { unsigned short v1; unsigned char v2; unsigned long long v3:7; };
struct Us_Uc_BFu7s { unsigned short v1; unsigned char v2; unsigned short v3:7; };
struct Us_Uc_BFu8c { unsigned short v1; unsigned char v2; unsigned char v3:8; };
struct Us_Uc_BFu8i { unsigned short v1; unsigned char v2; unsigned int v3:8; };
struct Us_Uc_BFu8ll { unsigned short v1; unsigned char v2; unsigned long long v3:8; };
struct Us_Uc_BFu8s { unsigned short v1; unsigned char v2; unsigned short v3:8; };
struct Us_Uc_BFu9i { unsigned short v1; unsigned char v2; unsigned int v3:9; };
struct Us_Uc_BFu9ll { unsigned short v1; unsigned char v2; unsigned long long v3:9; };
struct Us_Uc_BFu9s { unsigned short v1; unsigned char v2; unsigned short v3:9; };
struct Us_Uc_C { unsigned short v1; unsigned char v2; char v3; };
struct Us_Uc_D { unsigned short v1; unsigned char v2; double v3; };
struct Us_Uc_F { unsigned short v1; unsigned char v2; float v3; };
struct Us_Uc_I { unsigned short v1; unsigned char v2; int v3; };
struct Us_Uc_Ip { unsigned short v1; unsigned char v2; int * v3; };
struct Us_Uc_L { unsigned short v1; unsigned char v2; long long v3; };
struct Us_Uc_S { unsigned short v1; unsigned char v2; short v3; };
struct Us_Uc_Uc { unsigned short v1; unsigned char v2; unsigned char v3; };
struct Us_Uc_Ui { unsigned short v1; unsigned char v2; unsigned int v3; };
struct Us_Uc_Ul { unsigned short v1; unsigned char v2; unsigned long long v3; };
struct Us_Uc_Us { unsigned short v1; unsigned char v2; unsigned short v3; };
struct Us_Uc_Vp { unsigned short v1; unsigned char v2; void * v3; };
struct Us_Ui { unsigned short v1; unsigned int v2; };
struct Us_Ui_BFu15i { unsigned short v1; unsigned int v2; unsigned int v3:15; };
struct Us_Ui_BFu15ll { unsigned short v1; unsigned int v2; unsigned long long v3:15; };
struct Us_Ui_BFu15s { unsigned short v1; unsigned int v2; unsigned short v3:15; };
struct Us_Ui_BFu16i { unsigned short v1; unsigned int v2; unsigned int v3:16; };
struct Us_Ui_BFu16ll { unsigned short v1; unsigned int v2; unsigned long long v3:16; };
struct Us_Ui_BFu16s { unsigned short v1; unsigned int v2; unsigned short v3:16; };
struct Us_Ui_BFu17i { unsigned short v1; unsigned int v2; unsigned int v3:17; };
struct Us_Ui_BFu17ll { unsigned short v1; unsigned int v2; unsigned long long v3:17; };
struct Us_Ui_BFu1c { unsigned short v1; unsigned int v2; unsigned char v3:1; };
struct Us_Ui_BFu1i { unsigned short v1; unsigned int v2; unsigned int v3:1; };
struct Us_Ui_BFu1ll { unsigned short v1; unsigned int v2; unsigned long long v3:1; };
struct Us_Ui_BFu1s { unsigned short v1; unsigned int v2; unsigned short v3:1; };
struct Us_Ui_BFu31i { unsigned short v1; unsigned int v2; unsigned int v3:31; };
struct Us_Ui_BFu31ll { unsigned short v1; unsigned int v2; unsigned long long v3:31; };
struct Us_Ui_BFu32i { unsigned short v1; unsigned int v2; unsigned int v3:32; };
struct Us_Ui_BFu32ll { unsigned short v1; unsigned int v2; unsigned long long v3:32; };
struct Us_Ui_BFu33 { unsigned short v1; unsigned int v2; unsigned long long v3:33; };
struct Us_Ui_BFu7c { unsigned short v1; unsigned int v2; unsigned char v3:7; };
struct Us_Ui_BFu7i { unsigned short v1; unsigned int v2; unsigned int v3:7; };
struct Us_Ui_BFu7ll { unsigned short v1; unsigned int v2; unsigned long long v3:7; };
struct Us_Ui_BFu7s { unsigned short v1; unsigned int v2; unsigned short v3:7; };
struct Us_Ui_BFu8c { unsigned short v1; unsigned int v2; unsigned char v3:8; };
struct Us_Ui_BFu8i { unsigned short v1; unsigned int v2; unsigned int v3:8; };
struct Us_Ui_BFu8ll { unsigned short v1; unsigned int v2; unsigned long long v3:8; };
struct Us_Ui_BFu8s { unsigned short v1; unsigned int v2; unsigned short v3:8; };
struct Us_Ui_BFu9i { unsigned short v1; unsigned int v2; unsigned int v3:9; };
struct Us_Ui_BFu9ll { unsigned short v1; unsigned int v2; unsigned long long v3:9; };
struct Us_Ui_BFu9s { unsigned short v1; unsigned int v2; unsigned short v3:9; };
struct Us_Ui_C { unsigned short v1; unsigned int v2; char v3; };
struct Us_Ui_D { unsigned short v1; unsigned int v2; double v3; };
struct Us_Ui_F { unsigned short v1; unsigned int v2; float v3; };
struct Us_Ui_I { unsigned short v1; unsigned int v2; int v3; };
struct Us_Ui_Ip { unsigned short v1; unsigned int v2; int * v3; };
struct Us_Ui_L { unsigned short v1; unsigned int v2; long long v3; };
struct Us_Ui_S { unsigned short v1; unsigned int v2; short v3; };
struct Us_Ui_Uc { unsigned short v1; unsigned int v2; unsigned char v3; };
struct Us_Ui_Ui { unsigned short v1; unsigned int v2; unsigned int v3; };
struct Us_Ui_Ul { unsigned short v1; unsigned int v2; unsigned long long v3; };
struct Us_Ui_Us { unsigned short v1; unsigned int v2; unsigned short v3; };
struct Us_Ui_Vp { unsigned short v1; unsigned int v2; void * v3; };
struct Us_Ul { unsigned short v1; unsigned long long v2; };
struct Us_Ul_BFu15i { unsigned short v1; unsigned long long v2; unsigned int v3:15; };
struct Us_Ul_BFu15ll { unsigned short v1; unsigned long long v2; unsigned long long v3:15; };
struct Us_Ul_BFu15s { unsigned short v1; unsigned long long v2; unsigned short v3:15; };
struct Us_Ul_BFu16i { unsigned short v1; unsigned long long v2; unsigned int v3:16; };
struct Us_Ul_BFu16ll { unsigned short v1; unsigned long long v2; unsigned long long v3:16; };
struct Us_Ul_BFu16s { unsigned short v1; unsigned long long v2; unsigned short v3:16; };
struct Us_Ul_BFu17i { unsigned short v1; unsigned long long v2; unsigned int v3:17; };
struct Us_Ul_BFu17ll { unsigned short v1; unsigned long long v2; unsigned long long v3:17; };
struct Us_Ul_BFu1c { unsigned short v1; unsigned long long v2; unsigned char v3:1; };
struct Us_Ul_BFu1i { unsigned short v1; unsigned long long v2; unsigned int v3:1; };
struct Us_Ul_BFu1ll { unsigned short v1; unsigned long long v2; unsigned long long v3:1; };
struct Us_Ul_BFu1s { unsigned short v1; unsigned long long v2; unsigned short v3:1; };
struct Us_Ul_BFu31i { unsigned short v1; unsigned long long v2; unsigned int v3:31; };
struct Us_Ul_BFu31ll { unsigned short v1; unsigned long long v2; unsigned long long v3:31; };
struct Us_Ul_BFu32i { unsigned short v1; unsigned long long v2; unsigned int v3:32; };
struct Us_Ul_BFu32ll { unsigned short v1; unsigned long long v2; unsigned long long v3:32; };
struct Us_Ul_BFu33 { unsigned short v1; unsigned long long v2; unsigned long long v3:33; };
struct Us_Ul_BFu7c { unsigned short v1; unsigned long long v2; unsigned char v3:7; };
struct Us_Ul_BFu7i { unsigned short v1; unsigned long long v2; unsigned int v3:7; };
struct Us_Ul_BFu7ll { unsigned short v1; unsigned long long v2; unsigned long long v3:7; };
struct Us_Ul_BFu7s { unsigned short v1; unsigned long long v2; unsigned short v3:7; };
struct Us_Ul_BFu8c { unsigned short v1; unsigned long long v2; unsigned char v3:8; };
struct Us_Ul_BFu8i { unsigned short v1; unsigned long long v2; unsigned int v3:8; };
struct Us_Ul_BFu8ll { unsigned short v1; unsigned long long v2; unsigned long long v3:8; };
struct Us_Ul_BFu8s { unsigned short v1; unsigned long long v2; unsigned short v3:8; };
struct Us_Ul_BFu9i { unsigned short v1; unsigned long long v2; unsigned int v3:9; };
struct Us_Ul_BFu9ll { unsigned short v1; unsigned long long v2; unsigned long long v3:9; };
struct Us_Ul_BFu9s { unsigned short v1; unsigned long long v2; unsigned short v3:9; };
struct Us_Ul_C { unsigned short v1; unsigned long long v2; char v3; };
struct Us_Ul_D { unsigned short v1; unsigned long long v2; double v3; };
struct Us_Ul_F { unsigned short v1; unsigned long long v2; float v3; };
struct Us_Ul_I { unsigned short v1; unsigned long long v2; int v3; };
struct Us_Ul_Ip { unsigned short v1; unsigned long long v2; int * v3; };
struct Us_Ul_L { unsigned short v1; unsigned long long v2; long long v3; };
struct Us_Ul_S { unsigned short v1; unsigned long long v2; short v3; };
struct Us_Ul_Uc { unsigned short v1; unsigned long long v2; unsigned char v3; };
struct Us_Ul_Ui { unsigned short v1; unsigned long long v2; unsigned int v3; };
struct Us_Ul_Ul { unsigned short v1; unsigned long long v2; unsigned long long v3; };
struct Us_Ul_Us { unsigned short v1; unsigned long long v2; unsigned short v3; };
struct Us_Ul_Vp { unsigned short v1; unsigned long long v2; void * v3; };
struct Us_Us { unsigned short v1; unsigned short v2; };
struct Us_Us_BFu15i { unsigned short v1; unsigned short v2; unsigned int v3:15; };
struct Us_Us_BFu15ll { unsigned short v1; unsigned short v2; unsigned long long v3:15; };
struct Us_Us_BFu15s { unsigned short v1; unsigned short v2; unsigned short v3:15; };
struct Us_Us_BFu16i { unsigned short v1; unsigned short v2; unsigned int v3:16; };
struct Us_Us_BFu16ll { unsigned short v1; unsigned short v2; unsigned long long v3:16; };
struct Us_Us_BFu16s { unsigned short v1; unsigned short v2; unsigned short v3:16; };
struct Us_Us_BFu17i { unsigned short v1; unsigned short v2; unsigned int v3:17; };
struct Us_Us_BFu17ll { unsigned short v1; unsigned short v2; unsigned long long v3:17; };
struct Us_Us_BFu1c { unsigned short v1; unsigned short v2; unsigned char v3:1; };
struct Us_Us_BFu1i { unsigned short v1; unsigned short v2; unsigned int v3:1; };
struct Us_Us_BFu1ll { unsigned short v1; unsigned short v2; unsigned long long v3:1; };
struct Us_Us_BFu1s { unsigned short v1; unsigned short v2; unsigned short v3:1; };
struct Us_Us_BFu31i { unsigned short v1; unsigned short v2; unsigned int v3:31; };
struct Us_Us_BFu31ll { unsigned short v1; unsigned short v2; unsigned long long v3:31; };
struct Us_Us_BFu32i { unsigned short v1; unsigned short v2; unsigned int v3:32; };
struct Us_Us_BFu32ll { unsigned short v1; unsigned short v2; unsigned long long v3:32; };
struct Us_Us_BFu33 { unsigned short v1; unsigned short v2; unsigned long long v3:33; };
struct Us_Us_BFu7c { unsigned short v1; unsigned short v2; unsigned char v3:7; };
struct Us_Us_BFu7i { unsigned short v1; unsigned short v2; unsigned int v3:7; };
struct Us_Us_BFu7ll { unsigned short v1; unsigned short v2; unsigned long long v3:7; };
struct Us_Us_BFu7s { unsigned short v1; unsigned short v2; unsigned short v3:7; };
struct Us_Us_BFu8c { unsigned short v1; unsigned short v2; unsigned char v3:8; };
struct Us_Us_BFu8i { unsigned short v1; unsigned short v2; unsigned int v3:8; };
struct Us_Us_BFu8ll { unsigned short v1; unsigned short v2; unsigned long long v3:8; };
struct Us_Us_BFu8s { unsigned short v1; unsigned short v2; unsigned short v3:8; };
struct Us_Us_BFu9i { unsigned short v1; unsigned short v2; unsigned int v3:9; };
struct Us_Us_BFu9ll { unsigned short v1; unsigned short v2; unsigned long long v3:9; };
struct Us_Us_BFu9s { unsigned short v1; unsigned short v2; unsigned short v3:9; };
struct Us_Us_C { unsigned short v1; unsigned short v2; char v3; };
struct Us_Us_D { unsigned short v1; unsigned short v2; double v3; };
struct Us_Us_F { unsigned short v1; unsigned short v2; float v3; };
struct Us_Us_I { unsigned short v1; unsigned short v2; int v3; };
struct Us_Us_Ip { unsigned short v1; unsigned short v2; int * v3; };
struct Us_Us_L { unsigned short v1; unsigned short v2; long long v3; };
struct Us_Us_S { unsigned short v1; unsigned short v2; short v3; };
struct Us_Us_Uc { unsigned short v1; unsigned short v2; unsigned char v3; };
struct Us_Us_Ui { unsigned short v1; unsigned short v2; unsigned int v3; };
struct Us_Us_Ul { unsigned short v1; unsigned short v2; unsigned long long v3; };
struct Us_Us_Us { unsigned short v1; unsigned short v2; unsigned short v3; };
struct Us_Us_Vp { unsigned short v1; unsigned short v2; void * v3; };
struct Us_Vp { unsigned short v1; void * v2; };
struct Us_Vp_BFu15i { unsigned short v1; void * v2; unsigned int v3:15; };
struct Us_Vp_BFu15ll { unsigned short v1; void * v2; unsigned long long v3:15; };
struct Us_Vp_BFu15s { unsigned short v1; void * v2; unsigned short v3:15; };
struct Us_Vp_BFu16i { unsigned short v1; void * v2; unsigned int v3:16; };
struct Us_Vp_BFu16ll { unsigned short v1; void * v2; unsigned long long v3:16; };
struct Us_Vp_BFu16s { unsigned short v1; void * v2; unsigned short v3:16; };
struct Us_Vp_BFu17i { unsigned short v1; void * v2; unsigned int v3:17; };
struct Us_Vp_BFu17ll { unsigned short v1; void * v2; unsigned long long v3:17; };
struct Us_Vp_BFu1c { unsigned short v1; void * v2; unsigned char v3:1; };
struct Us_Vp_BFu1i { unsigned short v1; void * v2; unsigned int v3:1; };
struct Us_Vp_BFu1ll { unsigned short v1; void * v2; unsigned long long v3:1; };
struct Us_Vp_BFu1s { unsigned short v1; void * v2; unsigned short v3:1; };
struct Us_Vp_BFu31i { unsigned short v1; void * v2; unsigned int v3:31; };
struct Us_Vp_BFu31ll { unsigned short v1; void * v2; unsigned long long v3:31; };
struct Us_Vp_BFu32i { unsigned short v1; void * v2; unsigned int v3:32; };
struct Us_Vp_BFu32ll { unsigned short v1; void * v2; unsigned long long v3:32; };
struct Us_Vp_BFu33 { unsigned short v1; void * v2; unsigned long long v3:33; };
struct Us_Vp_BFu7c { unsigned short v1; void * v2; unsigned char v3:7; };
struct Us_Vp_BFu7i { unsigned short v1; void * v2; unsigned int v3:7; };
struct Us_Vp_BFu7ll { unsigned short v1; void * v2; unsigned long long v3:7; };
struct Us_Vp_BFu7s { unsigned short v1; void * v2; unsigned short v3:7; };
struct Us_Vp_BFu8c { unsigned short v1; void * v2; unsigned char v3:8; };
struct Us_Vp_BFu8i { unsigned short v1; void * v2; unsigned int v3:8; };
struct Us_Vp_BFu8ll { unsigned short v1; void * v2; unsigned long long v3:8; };
struct Us_Vp_BFu8s { unsigned short v1; void * v2; unsigned short v3:8; };
struct Us_Vp_BFu9i { unsigned short v1; void * v2; unsigned int v3:9; };
struct Us_Vp_BFu9ll { unsigned short v1; void * v2; unsigned long long v3:9; };
struct Us_Vp_BFu9s { unsigned short v1; void * v2; unsigned short v3:9; };
struct Us_Vp_C { unsigned short v1; void * v2; char v3; };
struct Us_Vp_D { unsigned short v1; void * v2; double v3; };
struct Us_Vp_F { unsigned short v1; void * v2; float v3; };
struct Us_Vp_I { unsigned short v1; void * v2; int v3; };
struct Us_Vp_Ip { unsigned short v1; void * v2; int * v3; };
struct Us_Vp_L { unsigned short v1; void * v2; long long v3; };
struct Us_Vp_S { unsigned short v1; void * v2; short v3; };
struct Us_Vp_Uc { unsigned short v1; void * v2; unsigned char v3; };
struct Us_Vp_Ui { unsigned short v1; void * v2; unsigned int v3; };
struct Us_Vp_Ul { unsigned short v1; void * v2; unsigned long long v3; };
struct Us_Vp_Us { unsigned short v1; void * v2; unsigned short v3; };
struct Us_Vp_Vp { unsigned short v1; void * v2; void * v3; };
struct Vp { void * v1; };
struct Vp_BFu15i { void * v1; unsigned int v2:15; };
struct Vp_BFu15i_BFu15i { void * v1; unsigned int v2:15; unsigned int v3:15; };
struct Vp_BFu15i_BFu15ll { void * v1; unsigned int v2:15; unsigned long long v3:15; };
struct Vp_BFu15i_BFu15s { void * v1; unsigned int v2:15; unsigned short v3:15; };
struct Vp_BFu15i_BFu16i { void * v1; unsigned int v2:15; unsigned int v3:16; };
struct Vp_BFu15i_BFu16ll { void * v1; unsigned int v2:15; unsigned long long v3:16; };
struct Vp_BFu15i_BFu16s { void * v1; unsigned int v2:15; unsigned short v3:16; };
struct Vp_BFu15i_BFu17i { void * v1; unsigned int v2:15; unsigned int v3:17; };
struct Vp_BFu15i_BFu17ll { void * v1; unsigned int v2:15; unsigned long long v3:17; };
struct Vp_BFu15i_BFu1c { void * v1; unsigned int v2:15; unsigned char v3:1; };
struct Vp_BFu15i_BFu1i { void * v1; unsigned int v2:15; unsigned int v3:1; };
struct Vp_BFu15i_BFu1ll { void * v1; unsigned int v2:15; unsigned long long v3:1; };
struct Vp_BFu15i_BFu1s { void * v1; unsigned int v2:15; unsigned short v3:1; };
struct Vp_BFu15i_BFu31i { void * v1; unsigned int v2:15; unsigned int v3:31; };
struct Vp_BFu15i_BFu31ll { void * v1; unsigned int v2:15; unsigned long long v3:31; };
struct Vp_BFu15i_BFu32i { void * v1; unsigned int v2:15; unsigned int v3:32; };
struct Vp_BFu15i_BFu32ll { void * v1; unsigned int v2:15; unsigned long long v3:32; };
struct Vp_BFu15i_BFu33 { void * v1; unsigned int v2:15; unsigned long long v3:33; };
struct Vp_BFu15i_BFu7c { void * v1; unsigned int v2:15; unsigned char v3:7; };
struct Vp_BFu15i_BFu7i { void * v1; unsigned int v2:15; unsigned int v3:7; };
struct Vp_BFu15i_BFu7ll { void * v1; unsigned int v2:15; unsigned long long v3:7; };
struct Vp_BFu15i_BFu7s { void * v1; unsigned int v2:15; unsigned short v3:7; };
struct Vp_BFu15i_BFu8c { void * v1; unsigned int v2:15; unsigned char v3:8; };
struct Vp_BFu15i_BFu8i { void * v1; unsigned int v2:15; unsigned int v3:8; };
struct Vp_BFu15i_BFu8ll { void * v1; unsigned int v2:15; unsigned long long v3:8; };
struct Vp_BFu15i_BFu8s { void * v1; unsigned int v2:15; unsigned short v3:8; };
struct Vp_BFu15i_BFu9i { void * v1; unsigned int v2:15; unsigned int v3:9; };
struct Vp_BFu15i_BFu9ll { void * v1; unsigned int v2:15; unsigned long long v3:9; };
struct Vp_BFu15i_BFu9s { void * v1; unsigned int v2:15; unsigned short v3:9; };
struct Vp_BFu15i_C { void * v1; unsigned int v2:15; char v3; };
struct Vp_BFu15i_D { void * v1; unsigned int v2:15; double v3; };
struct Vp_BFu15i_F { void * v1; unsigned int v2:15; float v3; };
struct Vp_BFu15i_I { void * v1; unsigned int v2:15; int v3; };
struct Vp_BFu15i_Ip { void * v1; unsigned int v2:15; int * v3; };
struct Vp_BFu15i_L { void * v1; unsigned int v2:15; long long v3; };
struct Vp_BFu15i_S { void * v1; unsigned int v2:15; short v3; };
struct Vp_BFu15i_Uc { void * v1; unsigned int v2:15; unsigned char v3; };
struct Vp_BFu15i_Ui { void * v1; unsigned int v2:15; unsigned int v3; };
struct Vp_BFu15i_Ul { void * v1; unsigned int v2:15; unsigned long long v3; };
struct Vp_BFu15i_Us { void * v1; unsigned int v2:15; unsigned short v3; };
struct Vp_BFu15i_Vp { void * v1; unsigned int v2:15; void * v3; };
struct Vp_BFu15ll { void * v1; unsigned long long v2:15; };
struct Vp_BFu15ll_BFu15i { void * v1; unsigned long long v2:15; unsigned int v3:15; };
struct Vp_BFu15ll_BFu15ll { void * v1; unsigned long long v2:15; unsigned long long v3:15; };
struct Vp_BFu15ll_BFu15s { void * v1; unsigned long long v2:15; unsigned short v3:15; };
struct Vp_BFu15ll_BFu16i { void * v1; unsigned long long v2:15; unsigned int v3:16; };
struct Vp_BFu15ll_BFu16ll { void * v1; unsigned long long v2:15; unsigned long long v3:16; };
struct Vp_BFu15ll_BFu16s { void * v1; unsigned long long v2:15; unsigned short v3:16; };
struct Vp_BFu15ll_BFu17i { void * v1; unsigned long long v2:15; unsigned int v3:17; };
struct Vp_BFu15ll_BFu17ll { void * v1; unsigned long long v2:15; unsigned long long v3:17; };
struct Vp_BFu15ll_BFu1c { void * v1; unsigned long long v2:15; unsigned char v3:1; };
struct Vp_BFu15ll_BFu1i { void * v1; unsigned long long v2:15; unsigned int v3:1; };
struct Vp_BFu15ll_BFu1ll { void * v1; unsigned long long v2:15; unsigned long long v3:1; };
struct Vp_BFu15ll_BFu1s { void * v1; unsigned long long v2:15; unsigned short v3:1; };
struct Vp_BFu15ll_BFu31i { void * v1; unsigned long long v2:15; unsigned int v3:31; };
struct Vp_BFu15ll_BFu31ll { void * v1; unsigned long long v2:15; unsigned long long v3:31; };
struct Vp_BFu15ll_BFu32i { void * v1; unsigned long long v2:15; unsigned int v3:32; };
struct Vp_BFu15ll_BFu32ll { void * v1; unsigned long long v2:15; unsigned long long v3:32; };
struct Vp_BFu15ll_BFu33 { void * v1; unsigned long long v2:15; unsigned long long v3:33; };
struct Vp_BFu15ll_BFu7c { void * v1; unsigned long long v2:15; unsigned char v3:7; };
struct Vp_BFu15ll_BFu7i { void * v1; unsigned long long v2:15; unsigned int v3:7; };
struct Vp_BFu15ll_BFu7ll { void * v1; unsigned long long v2:15; unsigned long long v3:7; };
struct Vp_BFu15ll_BFu7s { void * v1; unsigned long long v2:15; unsigned short v3:7; };
struct Vp_BFu15ll_BFu8c { void * v1; unsigned long long v2:15; unsigned char v3:8; };
struct Vp_BFu15ll_BFu8i { void * v1; unsigned long long v2:15; unsigned int v3:8; };
struct Vp_BFu15ll_BFu8ll { void * v1; unsigned long long v2:15; unsigned long long v3:8; };
struct Vp_BFu15ll_BFu8s { void * v1; unsigned long long v2:15; unsigned short v3:8; };
struct Vp_BFu15ll_BFu9i { void * v1; unsigned long long v2:15; unsigned int v3:9; };
struct Vp_BFu15ll_BFu9ll { void * v1; unsigned long long v2:15; unsigned long long v3:9; };
struct Vp_BFu15ll_BFu9s { void * v1; unsigned long long v2:15; unsigned short v3:9; };
struct Vp_BFu15ll_C { void * v1; unsigned long long v2:15; char v3; };
struct Vp_BFu15ll_D { void * v1; unsigned long long v2:15; double v3; };
struct Vp_BFu15ll_F { void * v1; unsigned long long v2:15; float v3; };
struct Vp_BFu15ll_I { void * v1; unsigned long long v2:15; int v3; };
struct Vp_BFu15ll_Ip { void * v1; unsigned long long v2:15; int * v3; };
struct Vp_BFu15ll_L { void * v1; unsigned long long v2:15; long long v3; };
struct Vp_BFu15ll_S { void * v1; unsigned long long v2:15; short v3; };
struct Vp_BFu15ll_Uc { void * v1; unsigned long long v2:15; unsigned char v3; };
struct Vp_BFu15ll_Ui { void * v1; unsigned long long v2:15; unsigned int v3; };
struct Vp_BFu15ll_Ul { void * v1; unsigned long long v2:15; unsigned long long v3; };
struct Vp_BFu15ll_Us { void * v1; unsigned long long v2:15; unsigned short v3; };
struct Vp_BFu15ll_Vp { void * v1; unsigned long long v2:15; void * v3; };
struct Vp_BFu15s { void * v1; unsigned short v2:15; };
struct Vp_BFu15s_BFu15i { void * v1; unsigned short v2:15; unsigned int v3:15; };
struct Vp_BFu15s_BFu15ll { void * v1; unsigned short v2:15; unsigned long long v3:15; };
struct Vp_BFu15s_BFu15s { void * v1; unsigned short v2:15; unsigned short v3:15; };
struct Vp_BFu15s_BFu16i { void * v1; unsigned short v2:15; unsigned int v3:16; };
struct Vp_BFu15s_BFu16ll { void * v1; unsigned short v2:15; unsigned long long v3:16; };
struct Vp_BFu15s_BFu16s { void * v1; unsigned short v2:15; unsigned short v3:16; };
struct Vp_BFu15s_BFu17i { void * v1; unsigned short v2:15; unsigned int v3:17; };
struct Vp_BFu15s_BFu17ll { void * v1; unsigned short v2:15; unsigned long long v3:17; };
struct Vp_BFu15s_BFu1c { void * v1; unsigned short v2:15; unsigned char v3:1; };
struct Vp_BFu15s_BFu1i { void * v1; unsigned short v2:15; unsigned int v3:1; };
struct Vp_BFu15s_BFu1ll { void * v1; unsigned short v2:15; unsigned long long v3:1; };
struct Vp_BFu15s_BFu1s { void * v1; unsigned short v2:15; unsigned short v3:1; };
struct Vp_BFu15s_BFu31i { void * v1; unsigned short v2:15; unsigned int v3:31; };
struct Vp_BFu15s_BFu31ll { void * v1; unsigned short v2:15; unsigned long long v3:31; };
struct Vp_BFu15s_BFu32i { void * v1; unsigned short v2:15; unsigned int v3:32; };
struct Vp_BFu15s_BFu32ll { void * v1; unsigned short v2:15; unsigned long long v3:32; };
struct Vp_BFu15s_BFu33 { void * v1; unsigned short v2:15; unsigned long long v3:33; };
struct Vp_BFu15s_BFu7c { void * v1; unsigned short v2:15; unsigned char v3:7; };
struct Vp_BFu15s_BFu7i { void * v1; unsigned short v2:15; unsigned int v3:7; };
struct Vp_BFu15s_BFu7ll { void * v1; unsigned short v2:15; unsigned long long v3:7; };
struct Vp_BFu15s_BFu7s { void * v1; unsigned short v2:15; unsigned short v3:7; };
struct Vp_BFu15s_BFu8c { void * v1; unsigned short v2:15; unsigned char v3:8; };
struct Vp_BFu15s_BFu8i { void * v1; unsigned short v2:15; unsigned int v3:8; };
struct Vp_BFu15s_BFu8ll { void * v1; unsigned short v2:15; unsigned long long v3:8; };
struct Vp_BFu15s_BFu8s { void * v1; unsigned short v2:15; unsigned short v3:8; };
struct Vp_BFu15s_BFu9i { void * v1; unsigned short v2:15; unsigned int v3:9; };
struct Vp_BFu15s_BFu9ll { void * v1; unsigned short v2:15; unsigned long long v3:9; };
struct Vp_BFu15s_BFu9s { void * v1; unsigned short v2:15; unsigned short v3:9; };
struct Vp_BFu15s_C { void * v1; unsigned short v2:15; char v3; };
struct Vp_BFu15s_D { void * v1; unsigned short v2:15; double v3; };
struct Vp_BFu15s_F { void * v1; unsigned short v2:15; float v3; };
struct Vp_BFu15s_I { void * v1; unsigned short v2:15; int v3; };
struct Vp_BFu15s_Ip { void * v1; unsigned short v2:15; int * v3; };
struct Vp_BFu15s_L { void * v1; unsigned short v2:15; long long v3; };
struct Vp_BFu15s_S { void * v1; unsigned short v2:15; short v3; };
struct Vp_BFu15s_Uc { void * v1; unsigned short v2:15; unsigned char v3; };
struct Vp_BFu15s_Ui { void * v1; unsigned short v2:15; unsigned int v3; };
struct Vp_BFu15s_Ul { void * v1; unsigned short v2:15; unsigned long long v3; };
struct Vp_BFu15s_Us { void * v1; unsigned short v2:15; unsigned short v3; };
struct Vp_BFu15s_Vp { void * v1; unsigned short v2:15; void * v3; };
struct Vp_BFu16i { void * v1; unsigned int v2:16; };
struct Vp_BFu16i_BFu15i { void * v1; unsigned int v2:16; unsigned int v3:15; };
struct Vp_BFu16i_BFu15ll { void * v1; unsigned int v2:16; unsigned long long v3:15; };
struct Vp_BFu16i_BFu15s { void * v1; unsigned int v2:16; unsigned short v3:15; };
struct Vp_BFu16i_BFu16i { void * v1; unsigned int v2:16; unsigned int v3:16; };
struct Vp_BFu16i_BFu16ll { void * v1; unsigned int v2:16; unsigned long long v3:16; };
struct Vp_BFu16i_BFu16s { void * v1; unsigned int v2:16; unsigned short v3:16; };
struct Vp_BFu16i_BFu17i { void * v1; unsigned int v2:16; unsigned int v3:17; };
struct Vp_BFu16i_BFu17ll { void * v1; unsigned int v2:16; unsigned long long v3:17; };
struct Vp_BFu16i_BFu1c { void * v1; unsigned int v2:16; unsigned char v3:1; };
struct Vp_BFu16i_BFu1i { void * v1; unsigned int v2:16; unsigned int v3:1; };
struct Vp_BFu16i_BFu1ll { void * v1; unsigned int v2:16; unsigned long long v3:1; };
struct Vp_BFu16i_BFu1s { void * v1; unsigned int v2:16; unsigned short v3:1; };
struct Vp_BFu16i_BFu31i { void * v1; unsigned int v2:16; unsigned int v3:31; };
struct Vp_BFu16i_BFu31ll { void * v1; unsigned int v2:16; unsigned long long v3:31; };
struct Vp_BFu16i_BFu32i { void * v1; unsigned int v2:16; unsigned int v3:32; };
struct Vp_BFu16i_BFu32ll { void * v1; unsigned int v2:16; unsigned long long v3:32; };
struct Vp_BFu16i_BFu33 { void * v1; unsigned int v2:16; unsigned long long v3:33; };
struct Vp_BFu16i_BFu7c { void * v1; unsigned int v2:16; unsigned char v3:7; };
struct Vp_BFu16i_BFu7i { void * v1; unsigned int v2:16; unsigned int v3:7; };
struct Vp_BFu16i_BFu7ll { void * v1; unsigned int v2:16; unsigned long long v3:7; };
struct Vp_BFu16i_BFu7s { void * v1; unsigned int v2:16; unsigned short v3:7; };
struct Vp_BFu16i_BFu8c { void * v1; unsigned int v2:16; unsigned char v3:8; };
struct Vp_BFu16i_BFu8i { void * v1; unsigned int v2:16; unsigned int v3:8; };
struct Vp_BFu16i_BFu8ll { void * v1; unsigned int v2:16; unsigned long long v3:8; };
struct Vp_BFu16i_BFu8s { void * v1; unsigned int v2:16; unsigned short v3:8; };
struct Vp_BFu16i_BFu9i { void * v1; unsigned int v2:16; unsigned int v3:9; };
struct Vp_BFu16i_BFu9ll { void * v1; unsigned int v2:16; unsigned long long v3:9; };
struct Vp_BFu16i_BFu9s { void * v1; unsigned int v2:16; unsigned short v3:9; };
struct Vp_BFu16i_C { void * v1; unsigned int v2:16; char v3; };
struct Vp_BFu16i_D { void * v1; unsigned int v2:16; double v3; };
struct Vp_BFu16i_F { void * v1; unsigned int v2:16; float v3; };
struct Vp_BFu16i_I { void * v1; unsigned int v2:16; int v3; };
struct Vp_BFu16i_Ip { void * v1; unsigned int v2:16; int * v3; };
struct Vp_BFu16i_L { void * v1; unsigned int v2:16; long long v3; };
struct Vp_BFu16i_S { void * v1; unsigned int v2:16; short v3; };
struct Vp_BFu16i_Uc { void * v1; unsigned int v2:16; unsigned char v3; };
struct Vp_BFu16i_Ui { void * v1; unsigned int v2:16; unsigned int v3; };
struct Vp_BFu16i_Ul { void * v1; unsigned int v2:16; unsigned long long v3; };
struct Vp_BFu16i_Us { void * v1; unsigned int v2:16; unsigned short v3; };
struct Vp_BFu16i_Vp { void * v1; unsigned int v2:16; void * v3; };
struct Vp_BFu16ll { void * v1; unsigned long long v2:16; };
struct Vp_BFu16ll_BFu15i { void * v1; unsigned long long v2:16; unsigned int v3:15; };
struct Vp_BFu16ll_BFu15ll { void * v1; unsigned long long v2:16; unsigned long long v3:15; };
struct Vp_BFu16ll_BFu15s { void * v1; unsigned long long v2:16; unsigned short v3:15; };
struct Vp_BFu16ll_BFu16i { void * v1; unsigned long long v2:16; unsigned int v3:16; };
struct Vp_BFu16ll_BFu16ll { void * v1; unsigned long long v2:16; unsigned long long v3:16; };
struct Vp_BFu16ll_BFu16s { void * v1; unsigned long long v2:16; unsigned short v3:16; };
struct Vp_BFu16ll_BFu17i { void * v1; unsigned long long v2:16; unsigned int v3:17; };
struct Vp_BFu16ll_BFu17ll { void * v1; unsigned long long v2:16; unsigned long long v3:17; };
struct Vp_BFu16ll_BFu1c { void * v1; unsigned long long v2:16; unsigned char v3:1; };
struct Vp_BFu16ll_BFu1i { void * v1; unsigned long long v2:16; unsigned int v3:1; };
struct Vp_BFu16ll_BFu1ll { void * v1; unsigned long long v2:16; unsigned long long v3:1; };
struct Vp_BFu16ll_BFu1s { void * v1; unsigned long long v2:16; unsigned short v3:1; };
struct Vp_BFu16ll_BFu31i { void * v1; unsigned long long v2:16; unsigned int v3:31; };
struct Vp_BFu16ll_BFu31ll { void * v1; unsigned long long v2:16; unsigned long long v3:31; };
struct Vp_BFu16ll_BFu32i { void * v1; unsigned long long v2:16; unsigned int v3:32; };
struct Vp_BFu16ll_BFu32ll { void * v1; unsigned long long v2:16; unsigned long long v3:32; };
struct Vp_BFu16ll_BFu33 { void * v1; unsigned long long v2:16; unsigned long long v3:33; };
struct Vp_BFu16ll_BFu7c { void * v1; unsigned long long v2:16; unsigned char v3:7; };
struct Vp_BFu16ll_BFu7i { void * v1; unsigned long long v2:16; unsigned int v3:7; };
struct Vp_BFu16ll_BFu7ll { void * v1; unsigned long long v2:16; unsigned long long v3:7; };
struct Vp_BFu16ll_BFu7s { void * v1; unsigned long long v2:16; unsigned short v3:7; };
struct Vp_BFu16ll_BFu8c { void * v1; unsigned long long v2:16; unsigned char v3:8; };
struct Vp_BFu16ll_BFu8i { void * v1; unsigned long long v2:16; unsigned int v3:8; };
struct Vp_BFu16ll_BFu8ll { void * v1; unsigned long long v2:16; unsigned long long v3:8; };
struct Vp_BFu16ll_BFu8s { void * v1; unsigned long long v2:16; unsigned short v3:8; };
struct Vp_BFu16ll_BFu9i { void * v1; unsigned long long v2:16; unsigned int v3:9; };
struct Vp_BFu16ll_BFu9ll { void * v1; unsigned long long v2:16; unsigned long long v3:9; };
struct Vp_BFu16ll_BFu9s { void * v1; unsigned long long v2:16; unsigned short v3:9; };
struct Vp_BFu16ll_C { void * v1; unsigned long long v2:16; char v3; };
struct Vp_BFu16ll_D { void * v1; unsigned long long v2:16; double v3; };
struct Vp_BFu16ll_F { void * v1; unsigned long long v2:16; float v3; };
struct Vp_BFu16ll_I { void * v1; unsigned long long v2:16; int v3; };
struct Vp_BFu16ll_Ip { void * v1; unsigned long long v2:16; int * v3; };
struct Vp_BFu16ll_L { void * v1; unsigned long long v2:16; long long v3; };
struct Vp_BFu16ll_S { void * v1; unsigned long long v2:16; short v3; };
struct Vp_BFu16ll_Uc { void * v1; unsigned long long v2:16; unsigned char v3; };
struct Vp_BFu16ll_Ui { void * v1; unsigned long long v2:16; unsigned int v3; };
struct Vp_BFu16ll_Ul { void * v1; unsigned long long v2:16; unsigned long long v3; };
struct Vp_BFu16ll_Us { void * v1; unsigned long long v2:16; unsigned short v3; };
struct Vp_BFu16ll_Vp { void * v1; unsigned long long v2:16; void * v3; };
struct Vp_BFu16s { void * v1; unsigned short v2:16; };
struct Vp_BFu16s_BFu15i { void * v1; unsigned short v2:16; unsigned int v3:15; };
struct Vp_BFu16s_BFu15ll { void * v1; unsigned short v2:16; unsigned long long v3:15; };
struct Vp_BFu16s_BFu15s { void * v1; unsigned short v2:16; unsigned short v3:15; };
struct Vp_BFu16s_BFu16i { void * v1; unsigned short v2:16; unsigned int v3:16; };
struct Vp_BFu16s_BFu16ll { void * v1; unsigned short v2:16; unsigned long long v3:16; };
struct Vp_BFu16s_BFu16s { void * v1; unsigned short v2:16; unsigned short v3:16; };
struct Vp_BFu16s_BFu17i { void * v1; unsigned short v2:16; unsigned int v3:17; };
struct Vp_BFu16s_BFu17ll { void * v1; unsigned short v2:16; unsigned long long v3:17; };
struct Vp_BFu16s_BFu1c { void * v1; unsigned short v2:16; unsigned char v3:1; };
struct Vp_BFu16s_BFu1i { void * v1; unsigned short v2:16; unsigned int v3:1; };
struct Vp_BFu16s_BFu1ll { void * v1; unsigned short v2:16; unsigned long long v3:1; };
struct Vp_BFu16s_BFu1s { void * v1; unsigned short v2:16; unsigned short v3:1; };
struct Vp_BFu16s_BFu31i { void * v1; unsigned short v2:16; unsigned int v3:31; };
struct Vp_BFu16s_BFu31ll { void * v1; unsigned short v2:16; unsigned long long v3:31; };
struct Vp_BFu16s_BFu32i { void * v1; unsigned short v2:16; unsigned int v3:32; };
struct Vp_BFu16s_BFu32ll { void * v1; unsigned short v2:16; unsigned long long v3:32; };
struct Vp_BFu16s_BFu33 { void * v1; unsigned short v2:16; unsigned long long v3:33; };
struct Vp_BFu16s_BFu7c { void * v1; unsigned short v2:16; unsigned char v3:7; };
struct Vp_BFu16s_BFu7i { void * v1; unsigned short v2:16; unsigned int v3:7; };
struct Vp_BFu16s_BFu7ll { void * v1; unsigned short v2:16; unsigned long long v3:7; };
struct Vp_BFu16s_BFu7s { void * v1; unsigned short v2:16; unsigned short v3:7; };
struct Vp_BFu16s_BFu8c { void * v1; unsigned short v2:16; unsigned char v3:8; };
struct Vp_BFu16s_BFu8i { void * v1; unsigned short v2:16; unsigned int v3:8; };
struct Vp_BFu16s_BFu8ll { void * v1; unsigned short v2:16; unsigned long long v3:8; };
struct Vp_BFu16s_BFu8s { void * v1; unsigned short v2:16; unsigned short v3:8; };
struct Vp_BFu16s_BFu9i { void * v1; unsigned short v2:16; unsigned int v3:9; };
struct Vp_BFu16s_BFu9ll { void * v1; unsigned short v2:16; unsigned long long v3:9; };
struct Vp_BFu16s_BFu9s { void * v1; unsigned short v2:16; unsigned short v3:9; };
struct Vp_BFu16s_C { void * v1; unsigned short v2:16; char v3; };
struct Vp_BFu16s_D { void * v1; unsigned short v2:16; double v3; };
struct Vp_BFu16s_F { void * v1; unsigned short v2:16; float v3; };
struct Vp_BFu16s_I { void * v1; unsigned short v2:16; int v3; };
struct Vp_BFu16s_Ip { void * v1; unsigned short v2:16; int * v3; };
struct Vp_BFu16s_L { void * v1; unsigned short v2:16; long long v3; };
struct Vp_BFu16s_S { void * v1; unsigned short v2:16; short v3; };
struct Vp_BFu16s_Uc { void * v1; unsigned short v2:16; unsigned char v3; };
struct Vp_BFu16s_Ui { void * v1; unsigned short v2:16; unsigned int v3; };
struct Vp_BFu16s_Ul { void * v1; unsigned short v2:16; unsigned long long v3; };
struct Vp_BFu16s_Us { void * v1; unsigned short v2:16; unsigned short v3; };
struct Vp_BFu16s_Vp { void * v1; unsigned short v2:16; void * v3; };
struct Vp_BFu17i { void * v1; unsigned int v2:17; };
struct Vp_BFu17i_BFu15i { void * v1; unsigned int v2:17; unsigned int v3:15; };
struct Vp_BFu17i_BFu15ll { void * v1; unsigned int v2:17; unsigned long long v3:15; };
struct Vp_BFu17i_BFu15s { void * v1; unsigned int v2:17; unsigned short v3:15; };
struct Vp_BFu17i_BFu16i { void * v1; unsigned int v2:17; unsigned int v3:16; };
struct Vp_BFu17i_BFu16ll { void * v1; unsigned int v2:17; unsigned long long v3:16; };
struct Vp_BFu17i_BFu16s { void * v1; unsigned int v2:17; unsigned short v3:16; };
struct Vp_BFu17i_BFu17i { void * v1; unsigned int v2:17; unsigned int v3:17; };
struct Vp_BFu17i_BFu17ll { void * v1; unsigned int v2:17; unsigned long long v3:17; };
struct Vp_BFu17i_BFu1c { void * v1; unsigned int v2:17; unsigned char v3:1; };
struct Vp_BFu17i_BFu1i { void * v1; unsigned int v2:17; unsigned int v3:1; };
struct Vp_BFu17i_BFu1ll { void * v1; unsigned int v2:17; unsigned long long v3:1; };
struct Vp_BFu17i_BFu1s { void * v1; unsigned int v2:17; unsigned short v3:1; };
struct Vp_BFu17i_BFu31i { void * v1; unsigned int v2:17; unsigned int v3:31; };
struct Vp_BFu17i_BFu31ll { void * v1; unsigned int v2:17; unsigned long long v3:31; };
struct Vp_BFu17i_BFu32i { void * v1; unsigned int v2:17; unsigned int v3:32; };
struct Vp_BFu17i_BFu32ll { void * v1; unsigned int v2:17; unsigned long long v3:32; };
struct Vp_BFu17i_BFu33 { void * v1; unsigned int v2:17; unsigned long long v3:33; };
struct Vp_BFu17i_BFu7c { void * v1; unsigned int v2:17; unsigned char v3:7; };
struct Vp_BFu17i_BFu7i { void * v1; unsigned int v2:17; unsigned int v3:7; };
struct Vp_BFu17i_BFu7ll { void * v1; unsigned int v2:17; unsigned long long v3:7; };
struct Vp_BFu17i_BFu7s { void * v1; unsigned int v2:17; unsigned short v3:7; };
struct Vp_BFu17i_BFu8c { void * v1; unsigned int v2:17; unsigned char v3:8; };
struct Vp_BFu17i_BFu8i { void * v1; unsigned int v2:17; unsigned int v3:8; };
struct Vp_BFu17i_BFu8ll { void * v1; unsigned int v2:17; unsigned long long v3:8; };
struct Vp_BFu17i_BFu8s { void * v1; unsigned int v2:17; unsigned short v3:8; };
struct Vp_BFu17i_BFu9i { void * v1; unsigned int v2:17; unsigned int v3:9; };
struct Vp_BFu17i_BFu9ll { void * v1; unsigned int v2:17; unsigned long long v3:9; };
struct Vp_BFu17i_BFu9s { void * v1; unsigned int v2:17; unsigned short v3:9; };
struct Vp_BFu17i_C { void * v1; unsigned int v2:17; char v3; };
struct Vp_BFu17i_D { void * v1; unsigned int v2:17; double v3; };
struct Vp_BFu17i_F { void * v1; unsigned int v2:17; float v3; };
struct Vp_BFu17i_I { void * v1; unsigned int v2:17; int v3; };
struct Vp_BFu17i_Ip { void * v1; unsigned int v2:17; int * v3; };
struct Vp_BFu17i_L { void * v1; unsigned int v2:17; long long v3; };
struct Vp_BFu17i_S { void * v1; unsigned int v2:17; short v3; };
struct Vp_BFu17i_Uc { void * v1; unsigned int v2:17; unsigned char v3; };
struct Vp_BFu17i_Ui { void * v1; unsigned int v2:17; unsigned int v3; };
struct Vp_BFu17i_Ul { void * v1; unsigned int v2:17; unsigned long long v3; };
struct Vp_BFu17i_Us { void * v1; unsigned int v2:17; unsigned short v3; };
struct Vp_BFu17i_Vp { void * v1; unsigned int v2:17; void * v3; };
struct Vp_BFu17ll { void * v1; unsigned long long v2:17; };
struct Vp_BFu17ll_BFu15i { void * v1; unsigned long long v2:17; unsigned int v3:15; };
struct Vp_BFu17ll_BFu15ll { void * v1; unsigned long long v2:17; unsigned long long v3:15; };
struct Vp_BFu17ll_BFu15s { void * v1; unsigned long long v2:17; unsigned short v3:15; };
struct Vp_BFu17ll_BFu16i { void * v1; unsigned long long v2:17; unsigned int v3:16; };
struct Vp_BFu17ll_BFu16ll { void * v1; unsigned long long v2:17; unsigned long long v3:16; };
struct Vp_BFu17ll_BFu16s { void * v1; unsigned long long v2:17; unsigned short v3:16; };
struct Vp_BFu17ll_BFu17i { void * v1; unsigned long long v2:17; unsigned int v3:17; };
struct Vp_BFu17ll_BFu17ll { void * v1; unsigned long long v2:17; unsigned long long v3:17; };
struct Vp_BFu17ll_BFu1c { void * v1; unsigned long long v2:17; unsigned char v3:1; };
struct Vp_BFu17ll_BFu1i { void * v1; unsigned long long v2:17; unsigned int v3:1; };
struct Vp_BFu17ll_BFu1ll { void * v1; unsigned long long v2:17; unsigned long long v3:1; };
struct Vp_BFu17ll_BFu1s { void * v1; unsigned long long v2:17; unsigned short v3:1; };
struct Vp_BFu17ll_BFu31i { void * v1; unsigned long long v2:17; unsigned int v3:31; };
struct Vp_BFu17ll_BFu31ll { void * v1; unsigned long long v2:17; unsigned long long v3:31; };
struct Vp_BFu17ll_BFu32i { void * v1; unsigned long long v2:17; unsigned int v3:32; };
struct Vp_BFu17ll_BFu32ll { void * v1; unsigned long long v2:17; unsigned long long v3:32; };
struct Vp_BFu17ll_BFu33 { void * v1; unsigned long long v2:17; unsigned long long v3:33; };
struct Vp_BFu17ll_BFu7c { void * v1; unsigned long long v2:17; unsigned char v3:7; };
struct Vp_BFu17ll_BFu7i { void * v1; unsigned long long v2:17; unsigned int v3:7; };
struct Vp_BFu17ll_BFu7ll { void * v1; unsigned long long v2:17; unsigned long long v3:7; };
struct Vp_BFu17ll_BFu7s { void * v1; unsigned long long v2:17; unsigned short v3:7; };
struct Vp_BFu17ll_BFu8c { void * v1; unsigned long long v2:17; unsigned char v3:8; };
struct Vp_BFu17ll_BFu8i { void * v1; unsigned long long v2:17; unsigned int v3:8; };
struct Vp_BFu17ll_BFu8ll { void * v1; unsigned long long v2:17; unsigned long long v3:8; };
struct Vp_BFu17ll_BFu8s { void * v1; unsigned long long v2:17; unsigned short v3:8; };
struct Vp_BFu17ll_BFu9i { void * v1; unsigned long long v2:17; unsigned int v3:9; };
struct Vp_BFu17ll_BFu9ll { void * v1; unsigned long long v2:17; unsigned long long v3:9; };
struct Vp_BFu17ll_BFu9s { void * v1; unsigned long long v2:17; unsigned short v3:9; };
struct Vp_BFu17ll_C { void * v1; unsigned long long v2:17; char v3; };
struct Vp_BFu17ll_D { void * v1; unsigned long long v2:17; double v3; };
struct Vp_BFu17ll_F { void * v1; unsigned long long v2:17; float v3; };
struct Vp_BFu17ll_I { void * v1; unsigned long long v2:17; int v3; };
struct Vp_BFu17ll_Ip { void * v1; unsigned long long v2:17; int * v3; };
struct Vp_BFu17ll_L { void * v1; unsigned long long v2:17; long long v3; };
struct Vp_BFu17ll_S { void * v1; unsigned long long v2:17; short v3; };
struct Vp_BFu17ll_Uc { void * v1; unsigned long long v2:17; unsigned char v3; };
struct Vp_BFu17ll_Ui { void * v1; unsigned long long v2:17; unsigned int v3; };
struct Vp_BFu17ll_Ul { void * v1; unsigned long long v2:17; unsigned long long v3; };
struct Vp_BFu17ll_Us { void * v1; unsigned long long v2:17; unsigned short v3; };
struct Vp_BFu17ll_Vp { void * v1; unsigned long long v2:17; void * v3; };
struct Vp_BFu1c { void * v1; unsigned char v2:1; };
struct Vp_BFu1c_BFu15i { void * v1; unsigned char v2:1; unsigned int v3:15; };
struct Vp_BFu1c_BFu15ll { void * v1; unsigned char v2:1; unsigned long long v3:15; };
struct Vp_BFu1c_BFu15s { void * v1; unsigned char v2:1; unsigned short v3:15; };
struct Vp_BFu1c_BFu16i { void * v1; unsigned char v2:1; unsigned int v3:16; };
struct Vp_BFu1c_BFu16ll { void * v1; unsigned char v2:1; unsigned long long v3:16; };
struct Vp_BFu1c_BFu16s { void * v1; unsigned char v2:1; unsigned short v3:16; };
struct Vp_BFu1c_BFu17i { void * v1; unsigned char v2:1; unsigned int v3:17; };
struct Vp_BFu1c_BFu17ll { void * v1; unsigned char v2:1; unsigned long long v3:17; };
struct Vp_BFu1c_BFu1c { void * v1; unsigned char v2:1; unsigned char v3:1; };
struct Vp_BFu1c_BFu1i { void * v1; unsigned char v2:1; unsigned int v3:1; };
struct Vp_BFu1c_BFu1ll { void * v1; unsigned char v2:1; unsigned long long v3:1; };
struct Vp_BFu1c_BFu1s { void * v1; unsigned char v2:1; unsigned short v3:1; };
struct Vp_BFu1c_BFu31i { void * v1; unsigned char v2:1; unsigned int v3:31; };
struct Vp_BFu1c_BFu31ll { void * v1; unsigned char v2:1; unsigned long long v3:31; };
struct Vp_BFu1c_BFu32i { void * v1; unsigned char v2:1; unsigned int v3:32; };
struct Vp_BFu1c_BFu32ll { void * v1; unsigned char v2:1; unsigned long long v3:32; };
struct Vp_BFu1c_BFu33 { void * v1; unsigned char v2:1; unsigned long long v3:33; };
struct Vp_BFu1c_BFu7c { void * v1; unsigned char v2:1; unsigned char v3:7; };
struct Vp_BFu1c_BFu7i { void * v1; unsigned char v2:1; unsigned int v3:7; };
struct Vp_BFu1c_BFu7ll { void * v1; unsigned char v2:1; unsigned long long v3:7; };
struct Vp_BFu1c_BFu7s { void * v1; unsigned char v2:1; unsigned short v3:7; };
struct Vp_BFu1c_BFu8c { void * v1; unsigned char v2:1; unsigned char v3:8; };
struct Vp_BFu1c_BFu8i { void * v1; unsigned char v2:1; unsigned int v3:8; };
struct Vp_BFu1c_BFu8ll { void * v1; unsigned char v2:1; unsigned long long v3:8; };
struct Vp_BFu1c_BFu8s { void * v1; unsigned char v2:1; unsigned short v3:8; };
struct Vp_BFu1c_BFu9i { void * v1; unsigned char v2:1; unsigned int v3:9; };
struct Vp_BFu1c_BFu9ll { void * v1; unsigned char v2:1; unsigned long long v3:9; };
struct Vp_BFu1c_BFu9s { void * v1; unsigned char v2:1; unsigned short v3:9; };
struct Vp_BFu1c_C { void * v1; unsigned char v2:1; char v3; };
struct Vp_BFu1c_D { void * v1; unsigned char v2:1; double v3; };
struct Vp_BFu1c_F { void * v1; unsigned char v2:1; float v3; };
struct Vp_BFu1c_I { void * v1; unsigned char v2:1; int v3; };
struct Vp_BFu1c_Ip { void * v1; unsigned char v2:1; int * v3; };
struct Vp_BFu1c_L { void * v1; unsigned char v2:1; long long v3; };
struct Vp_BFu1c_S { void * v1; unsigned char v2:1; short v3; };
struct Vp_BFu1c_Uc { void * v1; unsigned char v2:1; unsigned char v3; };
struct Vp_BFu1c_Ui { void * v1; unsigned char v2:1; unsigned int v3; };
struct Vp_BFu1c_Ul { void * v1; unsigned char v2:1; unsigned long long v3; };
struct Vp_BFu1c_Us { void * v1; unsigned char v2:1; unsigned short v3; };
struct Vp_BFu1c_Vp { void * v1; unsigned char v2:1; void * v3; };
struct Vp_BFu1i { void * v1; unsigned int v2:1; };
struct Vp_BFu1i_BFu15i { void * v1; unsigned int v2:1; unsigned int v3:15; };
struct Vp_BFu1i_BFu15ll { void * v1; unsigned int v2:1; unsigned long long v3:15; };
struct Vp_BFu1i_BFu15s { void * v1; unsigned int v2:1; unsigned short v3:15; };
struct Vp_BFu1i_BFu16i { void * v1; unsigned int v2:1; unsigned int v3:16; };
struct Vp_BFu1i_BFu16ll { void * v1; unsigned int v2:1; unsigned long long v3:16; };
struct Vp_BFu1i_BFu16s { void * v1; unsigned int v2:1; unsigned short v3:16; };
struct Vp_BFu1i_BFu17i { void * v1; unsigned int v2:1; unsigned int v3:17; };
struct Vp_BFu1i_BFu17ll { void * v1; unsigned int v2:1; unsigned long long v3:17; };
struct Vp_BFu1i_BFu1c { void * v1; unsigned int v2:1; unsigned char v3:1; };
struct Vp_BFu1i_BFu1i { void * v1; unsigned int v2:1; unsigned int v3:1; };
struct Vp_BFu1i_BFu1ll { void * v1; unsigned int v2:1; unsigned long long v3:1; };
struct Vp_BFu1i_BFu1s { void * v1; unsigned int v2:1; unsigned short v3:1; };
struct Vp_BFu1i_BFu31i { void * v1; unsigned int v2:1; unsigned int v3:31; };
struct Vp_BFu1i_BFu31ll { void * v1; unsigned int v2:1; unsigned long long v3:31; };
struct Vp_BFu1i_BFu32i { void * v1; unsigned int v2:1; unsigned int v3:32; };
struct Vp_BFu1i_BFu32ll { void * v1; unsigned int v2:1; unsigned long long v3:32; };
struct Vp_BFu1i_BFu33 { void * v1; unsigned int v2:1; unsigned long long v3:33; };
struct Vp_BFu1i_BFu7c { void * v1; unsigned int v2:1; unsigned char v3:7; };
struct Vp_BFu1i_BFu7i { void * v1; unsigned int v2:1; unsigned int v3:7; };
struct Vp_BFu1i_BFu7ll { void * v1; unsigned int v2:1; unsigned long long v3:7; };
struct Vp_BFu1i_BFu7s { void * v1; unsigned int v2:1; unsigned short v3:7; };
struct Vp_BFu1i_BFu8c { void * v1; unsigned int v2:1; unsigned char v3:8; };
struct Vp_BFu1i_BFu8i { void * v1; unsigned int v2:1; unsigned int v3:8; };
struct Vp_BFu1i_BFu8ll { void * v1; unsigned int v2:1; unsigned long long v3:8; };
struct Vp_BFu1i_BFu8s { void * v1; unsigned int v2:1; unsigned short v3:8; };
struct Vp_BFu1i_BFu9i { void * v1; unsigned int v2:1; unsigned int v3:9; };
struct Vp_BFu1i_BFu9ll { void * v1; unsigned int v2:1; unsigned long long v3:9; };
struct Vp_BFu1i_BFu9s { void * v1; unsigned int v2:1; unsigned short v3:9; };
struct Vp_BFu1i_C { void * v1; unsigned int v2:1; char v3; };
struct Vp_BFu1i_D { void * v1; unsigned int v2:1; double v3; };
struct Vp_BFu1i_F { void * v1; unsigned int v2:1; float v3; };
struct Vp_BFu1i_I { void * v1; unsigned int v2:1; int v3; };
struct Vp_BFu1i_Ip { void * v1; unsigned int v2:1; int * v3; };
struct Vp_BFu1i_L { void * v1; unsigned int v2:1; long long v3; };
struct Vp_BFu1i_S { void * v1; unsigned int v2:1; short v3; };
struct Vp_BFu1i_Uc { void * v1; unsigned int v2:1; unsigned char v3; };
struct Vp_BFu1i_Ui { void * v1; unsigned int v2:1; unsigned int v3; };
struct Vp_BFu1i_Ul { void * v1; unsigned int v2:1; unsigned long long v3; };
struct Vp_BFu1i_Us { void * v1; unsigned int v2:1; unsigned short v3; };
struct Vp_BFu1i_Vp { void * v1; unsigned int v2:1; void * v3; };
struct Vp_BFu1ll { void * v1; unsigned long long v2:1; };
struct Vp_BFu1ll_BFu15i { void * v1; unsigned long long v2:1; unsigned int v3:15; };
struct Vp_BFu1ll_BFu15ll { void * v1; unsigned long long v2:1; unsigned long long v3:15; };
struct Vp_BFu1ll_BFu15s { void * v1; unsigned long long v2:1; unsigned short v3:15; };
struct Vp_BFu1ll_BFu16i { void * v1; unsigned long long v2:1; unsigned int v3:16; };
struct Vp_BFu1ll_BFu16ll { void * v1; unsigned long long v2:1; unsigned long long v3:16; };
struct Vp_BFu1ll_BFu16s { void * v1; unsigned long long v2:1; unsigned short v3:16; };
struct Vp_BFu1ll_BFu17i { void * v1; unsigned long long v2:1; unsigned int v3:17; };
struct Vp_BFu1ll_BFu17ll { void * v1; unsigned long long v2:1; unsigned long long v3:17; };
struct Vp_BFu1ll_BFu1c { void * v1; unsigned long long v2:1; unsigned char v3:1; };
struct Vp_BFu1ll_BFu1i { void * v1; unsigned long long v2:1; unsigned int v3:1; };
struct Vp_BFu1ll_BFu1ll { void * v1; unsigned long long v2:1; unsigned long long v3:1; };
struct Vp_BFu1ll_BFu1s { void * v1; unsigned long long v2:1; unsigned short v3:1; };
struct Vp_BFu1ll_BFu31i { void * v1; unsigned long long v2:1; unsigned int v3:31; };
struct Vp_BFu1ll_BFu31ll { void * v1; unsigned long long v2:1; unsigned long long v3:31; };
struct Vp_BFu1ll_BFu32i { void * v1; unsigned long long v2:1; unsigned int v3:32; };
struct Vp_BFu1ll_BFu32ll { void * v1; unsigned long long v2:1; unsigned long long v3:32; };
struct Vp_BFu1ll_BFu33 { void * v1; unsigned long long v2:1; unsigned long long v3:33; };
struct Vp_BFu1ll_BFu7c { void * v1; unsigned long long v2:1; unsigned char v3:7; };
struct Vp_BFu1ll_BFu7i { void * v1; unsigned long long v2:1; unsigned int v3:7; };
struct Vp_BFu1ll_BFu7ll { void * v1; unsigned long long v2:1; unsigned long long v3:7; };
struct Vp_BFu1ll_BFu7s { void * v1; unsigned long long v2:1; unsigned short v3:7; };
struct Vp_BFu1ll_BFu8c { void * v1; unsigned long long v2:1; unsigned char v3:8; };
struct Vp_BFu1ll_BFu8i { void * v1; unsigned long long v2:1; unsigned int v3:8; };
struct Vp_BFu1ll_BFu8ll { void * v1; unsigned long long v2:1; unsigned long long v3:8; };
struct Vp_BFu1ll_BFu8s { void * v1; unsigned long long v2:1; unsigned short v3:8; };
struct Vp_BFu1ll_BFu9i { void * v1; unsigned long long v2:1; unsigned int v3:9; };
struct Vp_BFu1ll_BFu9ll { void * v1; unsigned long long v2:1; unsigned long long v3:9; };
struct Vp_BFu1ll_BFu9s { void * v1; unsigned long long v2:1; unsigned short v3:9; };
struct Vp_BFu1ll_C { void * v1; unsigned long long v2:1; char v3; };
struct Vp_BFu1ll_D { void * v1; unsigned long long v2:1; double v3; };
struct Vp_BFu1ll_F { void * v1; unsigned long long v2:1; float v3; };
struct Vp_BFu1ll_I { void * v1; unsigned long long v2:1; int v3; };
struct Vp_BFu1ll_Ip { void * v1; unsigned long long v2:1; int * v3; };
struct Vp_BFu1ll_L { void * v1; unsigned long long v2:1; long long v3; };
struct Vp_BFu1ll_S { void * v1; unsigned long long v2:1; short v3; };
struct Vp_BFu1ll_Uc { void * v1; unsigned long long v2:1; unsigned char v3; };
struct Vp_BFu1ll_Ui { void * v1; unsigned long long v2:1; unsigned int v3; };
struct Vp_BFu1ll_Ul { void * v1; unsigned long long v2:1; unsigned long long v3; };
struct Vp_BFu1ll_Us { void * v1; unsigned long long v2:1; unsigned short v3; };
struct Vp_BFu1ll_Vp { void * v1; unsigned long long v2:1; void * v3; };
struct Vp_BFu1s { void * v1; unsigned short v2:1; };
struct Vp_BFu1s_BFu15i { void * v1; unsigned short v2:1; unsigned int v3:15; };
struct Vp_BFu1s_BFu15ll { void * v1; unsigned short v2:1; unsigned long long v3:15; };
struct Vp_BFu1s_BFu15s { void * v1; unsigned short v2:1; unsigned short v3:15; };
struct Vp_BFu1s_BFu16i { void * v1; unsigned short v2:1; unsigned int v3:16; };
struct Vp_BFu1s_BFu16ll { void * v1; unsigned short v2:1; unsigned long long v3:16; };
struct Vp_BFu1s_BFu16s { void * v1; unsigned short v2:1; unsigned short v3:16; };
struct Vp_BFu1s_BFu17i { void * v1; unsigned short v2:1; unsigned int v3:17; };
struct Vp_BFu1s_BFu17ll { void * v1; unsigned short v2:1; unsigned long long v3:17; };
struct Vp_BFu1s_BFu1c { void * v1; unsigned short v2:1; unsigned char v3:1; };
struct Vp_BFu1s_BFu1i { void * v1; unsigned short v2:1; unsigned int v3:1; };
struct Vp_BFu1s_BFu1ll { void * v1; unsigned short v2:1; unsigned long long v3:1; };
struct Vp_BFu1s_BFu1s { void * v1; unsigned short v2:1; unsigned short v3:1; };
struct Vp_BFu1s_BFu31i { void * v1; unsigned short v2:1; unsigned int v3:31; };
struct Vp_BFu1s_BFu31ll { void * v1; unsigned short v2:1; unsigned long long v3:31; };
struct Vp_BFu1s_BFu32i { void * v1; unsigned short v2:1; unsigned int v3:32; };
struct Vp_BFu1s_BFu32ll { void * v1; unsigned short v2:1; unsigned long long v3:32; };
struct Vp_BFu1s_BFu33 { void * v1; unsigned short v2:1; unsigned long long v3:33; };
struct Vp_BFu1s_BFu7c { void * v1; unsigned short v2:1; unsigned char v3:7; };
struct Vp_BFu1s_BFu7i { void * v1; unsigned short v2:1; unsigned int v3:7; };
struct Vp_BFu1s_BFu7ll { void * v1; unsigned short v2:1; unsigned long long v3:7; };
struct Vp_BFu1s_BFu7s { void * v1; unsigned short v2:1; unsigned short v3:7; };
struct Vp_BFu1s_BFu8c { void * v1; unsigned short v2:1; unsigned char v3:8; };
struct Vp_BFu1s_BFu8i { void * v1; unsigned short v2:1; unsigned int v3:8; };
struct Vp_BFu1s_BFu8ll { void * v1; unsigned short v2:1; unsigned long long v3:8; };
struct Vp_BFu1s_BFu8s { void * v1; unsigned short v2:1; unsigned short v3:8; };
struct Vp_BFu1s_BFu9i { void * v1; unsigned short v2:1; unsigned int v3:9; };
struct Vp_BFu1s_BFu9ll { void * v1; unsigned short v2:1; unsigned long long v3:9; };
struct Vp_BFu1s_BFu9s { void * v1; unsigned short v2:1; unsigned short v3:9; };
struct Vp_BFu1s_C { void * v1; unsigned short v2:1; char v3; };
struct Vp_BFu1s_D { void * v1; unsigned short v2:1; double v3; };
struct Vp_BFu1s_F { void * v1; unsigned short v2:1; float v3; };
struct Vp_BFu1s_I { void * v1; unsigned short v2:1; int v3; };
struct Vp_BFu1s_Ip { void * v1; unsigned short v2:1; int * v3; };
struct Vp_BFu1s_L { void * v1; unsigned short v2:1; long long v3; };
struct Vp_BFu1s_S { void * v1; unsigned short v2:1; short v3; };
struct Vp_BFu1s_Uc { void * v1; unsigned short v2:1; unsigned char v3; };
struct Vp_BFu1s_Ui { void * v1; unsigned short v2:1; unsigned int v3; };
struct Vp_BFu1s_Ul { void * v1; unsigned short v2:1; unsigned long long v3; };
struct Vp_BFu1s_Us { void * v1; unsigned short v2:1; unsigned short v3; };
struct Vp_BFu1s_Vp { void * v1; unsigned short v2:1; void * v3; };
struct Vp_BFu31i { void * v1; unsigned int v2:31; };
struct Vp_BFu31i_BFu15i { void * v1; unsigned int v2:31; unsigned int v3:15; };
struct Vp_BFu31i_BFu15ll { void * v1; unsigned int v2:31; unsigned long long v3:15; };
struct Vp_BFu31i_BFu15s { void * v1; unsigned int v2:31; unsigned short v3:15; };
struct Vp_BFu31i_BFu16i { void * v1; unsigned int v2:31; unsigned int v3:16; };
struct Vp_BFu31i_BFu16ll { void * v1; unsigned int v2:31; unsigned long long v3:16; };
struct Vp_BFu31i_BFu16s { void * v1; unsigned int v2:31; unsigned short v3:16; };
struct Vp_BFu31i_BFu17i { void * v1; unsigned int v2:31; unsigned int v3:17; };
struct Vp_BFu31i_BFu17ll { void * v1; unsigned int v2:31; unsigned long long v3:17; };
struct Vp_BFu31i_BFu1c { void * v1; unsigned int v2:31; unsigned char v3:1; };
struct Vp_BFu31i_BFu1i { void * v1; unsigned int v2:31; unsigned int v3:1; };
struct Vp_BFu31i_BFu1ll { void * v1; unsigned int v2:31; unsigned long long v3:1; };
struct Vp_BFu31i_BFu1s { void * v1; unsigned int v2:31; unsigned short v3:1; };
struct Vp_BFu31i_BFu31i { void * v1; unsigned int v2:31; unsigned int v3:31; };
struct Vp_BFu31i_BFu31ll { void * v1; unsigned int v2:31; unsigned long long v3:31; };
struct Vp_BFu31i_BFu32i { void * v1; unsigned int v2:31; unsigned int v3:32; };
struct Vp_BFu31i_BFu32ll { void * v1; unsigned int v2:31; unsigned long long v3:32; };
struct Vp_BFu31i_BFu33 { void * v1; unsigned int v2:31; unsigned long long v3:33; };
struct Vp_BFu31i_BFu7c { void * v1; unsigned int v2:31; unsigned char v3:7; };
struct Vp_BFu31i_BFu7i { void * v1; unsigned int v2:31; unsigned int v3:7; };
struct Vp_BFu31i_BFu7ll { void * v1; unsigned int v2:31; unsigned long long v3:7; };
struct Vp_BFu31i_BFu7s { void * v1; unsigned int v2:31; unsigned short v3:7; };
struct Vp_BFu31i_BFu8c { void * v1; unsigned int v2:31; unsigned char v3:8; };
struct Vp_BFu31i_BFu8i { void * v1; unsigned int v2:31; unsigned int v3:8; };
struct Vp_BFu31i_BFu8ll { void * v1; unsigned int v2:31; unsigned long long v3:8; };
struct Vp_BFu31i_BFu8s { void * v1; unsigned int v2:31; unsigned short v3:8; };
struct Vp_BFu31i_BFu9i { void * v1; unsigned int v2:31; unsigned int v3:9; };
struct Vp_BFu31i_BFu9ll { void * v1; unsigned int v2:31; unsigned long long v3:9; };
struct Vp_BFu31i_BFu9s { void * v1; unsigned int v2:31; unsigned short v3:9; };
struct Vp_BFu31i_C { void * v1; unsigned int v2:31; char v3; };
struct Vp_BFu31i_D { void * v1; unsigned int v2:31; double v3; };
struct Vp_BFu31i_F { void * v1; unsigned int v2:31; float v3; };
struct Vp_BFu31i_I { void * v1; unsigned int v2:31; int v3; };
struct Vp_BFu31i_Ip { void * v1; unsigned int v2:31; int * v3; };
struct Vp_BFu31i_L { void * v1; unsigned int v2:31; long long v3; };
struct Vp_BFu31i_S { void * v1; unsigned int v2:31; short v3; };
struct Vp_BFu31i_Uc { void * v1; unsigned int v2:31; unsigned char v3; };
struct Vp_BFu31i_Ui { void * v1; unsigned int v2:31; unsigned int v3; };
struct Vp_BFu31i_Ul { void * v1; unsigned int v2:31; unsigned long long v3; };
struct Vp_BFu31i_Us { void * v1; unsigned int v2:31; unsigned short v3; };
struct Vp_BFu31i_Vp { void * v1; unsigned int v2:31; void * v3; };
struct Vp_BFu31ll { void * v1; unsigned long long v2:31; };
struct Vp_BFu31ll_BFu15i { void * v1; unsigned long long v2:31; unsigned int v3:15; };
struct Vp_BFu31ll_BFu15ll { void * v1; unsigned long long v2:31; unsigned long long v3:15; };
struct Vp_BFu31ll_BFu15s { void * v1; unsigned long long v2:31; unsigned short v3:15; };
struct Vp_BFu31ll_BFu16i { void * v1; unsigned long long v2:31; unsigned int v3:16; };
struct Vp_BFu31ll_BFu16ll { void * v1; unsigned long long v2:31; unsigned long long v3:16; };
struct Vp_BFu31ll_BFu16s { void * v1; unsigned long long v2:31; unsigned short v3:16; };
struct Vp_BFu31ll_BFu17i { void * v1; unsigned long long v2:31; unsigned int v3:17; };
struct Vp_BFu31ll_BFu17ll { void * v1; unsigned long long v2:31; unsigned long long v3:17; };
struct Vp_BFu31ll_BFu1c { void * v1; unsigned long long v2:31; unsigned char v3:1; };
struct Vp_BFu31ll_BFu1i { void * v1; unsigned long long v2:31; unsigned int v3:1; };
struct Vp_BFu31ll_BFu1ll { void * v1; unsigned long long v2:31; unsigned long long v3:1; };
struct Vp_BFu31ll_BFu1s { void * v1; unsigned long long v2:31; unsigned short v3:1; };
struct Vp_BFu31ll_BFu31i { void * v1; unsigned long long v2:31; unsigned int v3:31; };
struct Vp_BFu31ll_BFu31ll { void * v1; unsigned long long v2:31; unsigned long long v3:31; };
struct Vp_BFu31ll_BFu32i { void * v1; unsigned long long v2:31; unsigned int v3:32; };
struct Vp_BFu31ll_BFu32ll { void * v1; unsigned long long v2:31; unsigned long long v3:32; };
struct Vp_BFu31ll_BFu33 { void * v1; unsigned long long v2:31; unsigned long long v3:33; };
struct Vp_BFu31ll_BFu7c { void * v1; unsigned long long v2:31; unsigned char v3:7; };
struct Vp_BFu31ll_BFu7i { void * v1; unsigned long long v2:31; unsigned int v3:7; };
struct Vp_BFu31ll_BFu7ll { void * v1; unsigned long long v2:31; unsigned long long v3:7; };
struct Vp_BFu31ll_BFu7s { void * v1; unsigned long long v2:31; unsigned short v3:7; };
struct Vp_BFu31ll_BFu8c { void * v1; unsigned long long v2:31; unsigned char v3:8; };
struct Vp_BFu31ll_BFu8i { void * v1; unsigned long long v2:31; unsigned int v3:8; };
struct Vp_BFu31ll_BFu8ll { void * v1; unsigned long long v2:31; unsigned long long v3:8; };
struct Vp_BFu31ll_BFu8s { void * v1; unsigned long long v2:31; unsigned short v3:8; };
struct Vp_BFu31ll_BFu9i { void * v1; unsigned long long v2:31; unsigned int v3:9; };
struct Vp_BFu31ll_BFu9ll { void * v1; unsigned long long v2:31; unsigned long long v3:9; };
struct Vp_BFu31ll_BFu9s { void * v1; unsigned long long v2:31; unsigned short v3:9; };
struct Vp_BFu31ll_C { void * v1; unsigned long long v2:31; char v3; };
struct Vp_BFu31ll_D { void * v1; unsigned long long v2:31; double v3; };
struct Vp_BFu31ll_F { void * v1; unsigned long long v2:31; float v3; };
struct Vp_BFu31ll_I { void * v1; unsigned long long v2:31; int v3; };
struct Vp_BFu31ll_Ip { void * v1; unsigned long long v2:31; int * v3; };
struct Vp_BFu31ll_L { void * v1; unsigned long long v2:31; long long v3; };
struct Vp_BFu31ll_S { void * v1; unsigned long long v2:31; short v3; };
struct Vp_BFu31ll_Uc { void * v1; unsigned long long v2:31; unsigned char v3; };
struct Vp_BFu31ll_Ui { void * v1; unsigned long long v2:31; unsigned int v3; };
struct Vp_BFu31ll_Ul { void * v1; unsigned long long v2:31; unsigned long long v3; };
struct Vp_BFu31ll_Us { void * v1; unsigned long long v2:31; unsigned short v3; };
struct Vp_BFu31ll_Vp { void * v1; unsigned long long v2:31; void * v3; };
struct Vp_BFu32i { void * v1; unsigned int v2:32; };
struct Vp_BFu32i_BFu15i { void * v1; unsigned int v2:32; unsigned int v3:15; };
struct Vp_BFu32i_BFu15ll { void * v1; unsigned int v2:32; unsigned long long v3:15; };
struct Vp_BFu32i_BFu15s { void * v1; unsigned int v2:32; unsigned short v3:15; };
struct Vp_BFu32i_BFu16i { void * v1; unsigned int v2:32; unsigned int v3:16; };
struct Vp_BFu32i_BFu16ll { void * v1; unsigned int v2:32; unsigned long long v3:16; };
struct Vp_BFu32i_BFu16s { void * v1; unsigned int v2:32; unsigned short v3:16; };
struct Vp_BFu32i_BFu17i { void * v1; unsigned int v2:32; unsigned int v3:17; };
struct Vp_BFu32i_BFu17ll { void * v1; unsigned int v2:32; unsigned long long v3:17; };
struct Vp_BFu32i_BFu1c { void * v1; unsigned int v2:32; unsigned char v3:1; };
struct Vp_BFu32i_BFu1i { void * v1; unsigned int v2:32; unsigned int v3:1; };
struct Vp_BFu32i_BFu1ll { void * v1; unsigned int v2:32; unsigned long long v3:1; };
struct Vp_BFu32i_BFu1s { void * v1; unsigned int v2:32; unsigned short v3:1; };
struct Vp_BFu32i_BFu31i { void * v1; unsigned int v2:32; unsigned int v3:31; };
struct Vp_BFu32i_BFu31ll { void * v1; unsigned int v2:32; unsigned long long v3:31; };
struct Vp_BFu32i_BFu32i { void * v1; unsigned int v2:32; unsigned int v3:32; };
struct Vp_BFu32i_BFu32ll { void * v1; unsigned int v2:32; unsigned long long v3:32; };
struct Vp_BFu32i_BFu33 { void * v1; unsigned int v2:32; unsigned long long v3:33; };
struct Vp_BFu32i_BFu7c { void * v1; unsigned int v2:32; unsigned char v3:7; };
struct Vp_BFu32i_BFu7i { void * v1; unsigned int v2:32; unsigned int v3:7; };
struct Vp_BFu32i_BFu7ll { void * v1; unsigned int v2:32; unsigned long long v3:7; };
struct Vp_BFu32i_BFu7s { void * v1; unsigned int v2:32; unsigned short v3:7; };
struct Vp_BFu32i_BFu8c { void * v1; unsigned int v2:32; unsigned char v3:8; };
struct Vp_BFu32i_BFu8i { void * v1; unsigned int v2:32; unsigned int v3:8; };
struct Vp_BFu32i_BFu8ll { void * v1; unsigned int v2:32; unsigned long long v3:8; };
struct Vp_BFu32i_BFu8s { void * v1; unsigned int v2:32; unsigned short v3:8; };
struct Vp_BFu32i_BFu9i { void * v1; unsigned int v2:32; unsigned int v3:9; };
struct Vp_BFu32i_BFu9ll { void * v1; unsigned int v2:32; unsigned long long v3:9; };
struct Vp_BFu32i_BFu9s { void * v1; unsigned int v2:32; unsigned short v3:9; };
struct Vp_BFu32i_C { void * v1; unsigned int v2:32; char v3; };
struct Vp_BFu32i_D { void * v1; unsigned int v2:32; double v3; };
struct Vp_BFu32i_F { void * v1; unsigned int v2:32; float v3; };
struct Vp_BFu32i_I { void * v1; unsigned int v2:32; int v3; };
struct Vp_BFu32i_Ip { void * v1; unsigned int v2:32; int * v3; };
struct Vp_BFu32i_L { void * v1; unsigned int v2:32; long long v3; };
struct Vp_BFu32i_S { void * v1; unsigned int v2:32; short v3; };
struct Vp_BFu32i_Uc { void * v1; unsigned int v2:32; unsigned char v3; };
struct Vp_BFu32i_Ui { void * v1; unsigned int v2:32; unsigned int v3; };
struct Vp_BFu32i_Ul { void * v1; unsigned int v2:32; unsigned long long v3; };
struct Vp_BFu32i_Us { void * v1; unsigned int v2:32; unsigned short v3; };
struct Vp_BFu32i_Vp { void * v1; unsigned int v2:32; void * v3; };
struct Vp_BFu32ll { void * v1; unsigned long long v2:32; };
struct Vp_BFu32ll_BFu15i { void * v1; unsigned long long v2:32; unsigned int v3:15; };
struct Vp_BFu32ll_BFu15ll { void * v1; unsigned long long v2:32; unsigned long long v3:15; };
struct Vp_BFu32ll_BFu15s { void * v1; unsigned long long v2:32; unsigned short v3:15; };
struct Vp_BFu32ll_BFu16i { void * v1; unsigned long long v2:32; unsigned int v3:16; };
struct Vp_BFu32ll_BFu16ll { void * v1; unsigned long long v2:32; unsigned long long v3:16; };
struct Vp_BFu32ll_BFu16s { void * v1; unsigned long long v2:32; unsigned short v3:16; };
struct Vp_BFu32ll_BFu17i { void * v1; unsigned long long v2:32; unsigned int v3:17; };
struct Vp_BFu32ll_BFu17ll { void * v1; unsigned long long v2:32; unsigned long long v3:17; };
struct Vp_BFu32ll_BFu1c { void * v1; unsigned long long v2:32; unsigned char v3:1; };
struct Vp_BFu32ll_BFu1i { void * v1; unsigned long long v2:32; unsigned int v3:1; };
struct Vp_BFu32ll_BFu1ll { void * v1; unsigned long long v2:32; unsigned long long v3:1; };
struct Vp_BFu32ll_BFu1s { void * v1; unsigned long long v2:32; unsigned short v3:1; };
struct Vp_BFu32ll_BFu31i { void * v1; unsigned long long v2:32; unsigned int v3:31; };
struct Vp_BFu32ll_BFu31ll { void * v1; unsigned long long v2:32; unsigned long long v3:31; };
struct Vp_BFu32ll_BFu32i { void * v1; unsigned long long v2:32; unsigned int v3:32; };
struct Vp_BFu32ll_BFu32ll { void * v1; unsigned long long v2:32; unsigned long long v3:32; };
struct Vp_BFu32ll_BFu33 { void * v1; unsigned long long v2:32; unsigned long long v3:33; };
struct Vp_BFu32ll_BFu7c { void * v1; unsigned long long v2:32; unsigned char v3:7; };
struct Vp_BFu32ll_BFu7i { void * v1; unsigned long long v2:32; unsigned int v3:7; };
struct Vp_BFu32ll_BFu7ll { void * v1; unsigned long long v2:32; unsigned long long v3:7; };
struct Vp_BFu32ll_BFu7s { void * v1; unsigned long long v2:32; unsigned short v3:7; };
struct Vp_BFu32ll_BFu8c { void * v1; unsigned long long v2:32; unsigned char v3:8; };
struct Vp_BFu32ll_BFu8i { void * v1; unsigned long long v2:32; unsigned int v3:8; };
struct Vp_BFu32ll_BFu8ll { void * v1; unsigned long long v2:32; unsigned long long v3:8; };
struct Vp_BFu32ll_BFu8s { void * v1; unsigned long long v2:32; unsigned short v3:8; };
struct Vp_BFu32ll_BFu9i { void * v1; unsigned long long v2:32; unsigned int v3:9; };
struct Vp_BFu32ll_BFu9ll { void * v1; unsigned long long v2:32; unsigned long long v3:9; };
struct Vp_BFu32ll_BFu9s { void * v1; unsigned long long v2:32; unsigned short v3:9; };
struct Vp_BFu32ll_C { void * v1; unsigned long long v2:32; char v3; };
struct Vp_BFu32ll_D { void * v1; unsigned long long v2:32; double v3; };
struct Vp_BFu32ll_F { void * v1; unsigned long long v2:32; float v3; };
struct Vp_BFu32ll_I { void * v1; unsigned long long v2:32; int v3; };
struct Vp_BFu32ll_Ip { void * v1; unsigned long long v2:32; int * v3; };
struct Vp_BFu32ll_L { void * v1; unsigned long long v2:32; long long v3; };
struct Vp_BFu32ll_S { void * v1; unsigned long long v2:32; short v3; };
struct Vp_BFu32ll_Uc { void * v1; unsigned long long v2:32; unsigned char v3; };
struct Vp_BFu32ll_Ui { void * v1; unsigned long long v2:32; unsigned int v3; };
struct Vp_BFu32ll_Ul { void * v1; unsigned long long v2:32; unsigned long long v3; };
struct Vp_BFu32ll_Us { void * v1; unsigned long long v2:32; unsigned short v3; };
struct Vp_BFu32ll_Vp { void * v1; unsigned long long v2:32; void * v3; };
struct Vp_BFu33 { void * v1; unsigned long long v2:33; };
struct Vp_BFu33_BFu15i { void * v1; unsigned long long v2:33; unsigned int v3:15; };
struct Vp_BFu33_BFu15ll { void * v1; unsigned long long v2:33; unsigned long long v3:15; };
struct Vp_BFu33_BFu15s { void * v1; unsigned long long v2:33; unsigned short v3:15; };
struct Vp_BFu33_BFu16i { void * v1; unsigned long long v2:33; unsigned int v3:16; };
struct Vp_BFu33_BFu16ll { void * v1; unsigned long long v2:33; unsigned long long v3:16; };
struct Vp_BFu33_BFu16s { void * v1; unsigned long long v2:33; unsigned short v3:16; };
struct Vp_BFu33_BFu17i { void * v1; unsigned long long v2:33; unsigned int v3:17; };
struct Vp_BFu33_BFu17ll { void * v1; unsigned long long v2:33; unsigned long long v3:17; };
struct Vp_BFu33_BFu1c { void * v1; unsigned long long v2:33; unsigned char v3:1; };
struct Vp_BFu33_BFu1i { void * v1; unsigned long long v2:33; unsigned int v3:1; };
struct Vp_BFu33_BFu1ll { void * v1; unsigned long long v2:33; unsigned long long v3:1; };
struct Vp_BFu33_BFu1s { void * v1; unsigned long long v2:33; unsigned short v3:1; };
struct Vp_BFu33_BFu31i { void * v1; unsigned long long v2:33; unsigned int v3:31; };
struct Vp_BFu33_BFu31ll { void * v1; unsigned long long v2:33; unsigned long long v3:31; };
struct Vp_BFu33_BFu32i { void * v1; unsigned long long v2:33; unsigned int v3:32; };
struct Vp_BFu33_BFu32ll { void * v1; unsigned long long v2:33; unsigned long long v3:32; };
struct Vp_BFu33_BFu33 { void * v1; unsigned long long v2:33; unsigned long long v3:33; };
struct Vp_BFu33_BFu7c { void * v1; unsigned long long v2:33; unsigned char v3:7; };
struct Vp_BFu33_BFu7i { void * v1; unsigned long long v2:33; unsigned int v3:7; };
struct Vp_BFu33_BFu7ll { void * v1; unsigned long long v2:33; unsigned long long v3:7; };
struct Vp_BFu33_BFu7s { void * v1; unsigned long long v2:33; unsigned short v3:7; };
struct Vp_BFu33_BFu8c { void * v1; unsigned long long v2:33; unsigned char v3:8; };
struct Vp_BFu33_BFu8i { void * v1; unsigned long long v2:33; unsigned int v3:8; };
struct Vp_BFu33_BFu8ll { void * v1; unsigned long long v2:33; unsigned long long v3:8; };
struct Vp_BFu33_BFu8s { void * v1; unsigned long long v2:33; unsigned short v3:8; };
struct Vp_BFu33_BFu9i { void * v1; unsigned long long v2:33; unsigned int v3:9; };
struct Vp_BFu33_BFu9ll { void * v1; unsigned long long v2:33; unsigned long long v3:9; };
struct Vp_BFu33_BFu9s { void * v1; unsigned long long v2:33; unsigned short v3:9; };
struct Vp_BFu33_C { void * v1; unsigned long long v2:33; char v3; };
struct Vp_BFu33_D { void * v1; unsigned long long v2:33; double v3; };
struct Vp_BFu33_F { void * v1; unsigned long long v2:33; float v3; };
struct Vp_BFu33_I { void * v1; unsigned long long v2:33; int v3; };
struct Vp_BFu33_Ip { void * v1; unsigned long long v2:33; int * v3; };
struct Vp_BFu33_L { void * v1; unsigned long long v2:33; long long v3; };
struct Vp_BFu33_S { void * v1; unsigned long long v2:33; short v3; };
struct Vp_BFu33_Uc { void * v1; unsigned long long v2:33; unsigned char v3; };
struct Vp_BFu33_Ui { void * v1; unsigned long long v2:33; unsigned int v3; };
struct Vp_BFu33_Ul { void * v1; unsigned long long v2:33; unsigned long long v3; };
struct Vp_BFu33_Us { void * v1; unsigned long long v2:33; unsigned short v3; };
struct Vp_BFu33_Vp { void * v1; unsigned long long v2:33; void * v3; };
struct Vp_BFu7c { void * v1; unsigned char v2:7; };
struct Vp_BFu7c_BFu15i { void * v1; unsigned char v2:7; unsigned int v3:15; };
struct Vp_BFu7c_BFu15ll { void * v1; unsigned char v2:7; unsigned long long v3:15; };
struct Vp_BFu7c_BFu15s { void * v1; unsigned char v2:7; unsigned short v3:15; };
struct Vp_BFu7c_BFu16i { void * v1; unsigned char v2:7; unsigned int v3:16; };
struct Vp_BFu7c_BFu16ll { void * v1; unsigned char v2:7; unsigned long long v3:16; };
struct Vp_BFu7c_BFu16s { void * v1; unsigned char v2:7; unsigned short v3:16; };
struct Vp_BFu7c_BFu17i { void * v1; unsigned char v2:7; unsigned int v3:17; };
struct Vp_BFu7c_BFu17ll { void * v1; unsigned char v2:7; unsigned long long v3:17; };
struct Vp_BFu7c_BFu1c { void * v1; unsigned char v2:7; unsigned char v3:1; };
struct Vp_BFu7c_BFu1i { void * v1; unsigned char v2:7; unsigned int v3:1; };
struct Vp_BFu7c_BFu1ll { void * v1; unsigned char v2:7; unsigned long long v3:1; };
struct Vp_BFu7c_BFu1s { void * v1; unsigned char v2:7; unsigned short v3:1; };
struct Vp_BFu7c_BFu31i { void * v1; unsigned char v2:7; unsigned int v3:31; };
struct Vp_BFu7c_BFu31ll { void * v1; unsigned char v2:7; unsigned long long v3:31; };
struct Vp_BFu7c_BFu32i { void * v1; unsigned char v2:7; unsigned int v3:32; };
struct Vp_BFu7c_BFu32ll { void * v1; unsigned char v2:7; unsigned long long v3:32; };
struct Vp_BFu7c_BFu33 { void * v1; unsigned char v2:7; unsigned long long v3:33; };
struct Vp_BFu7c_BFu7c { void * v1; unsigned char v2:7; unsigned char v3:7; };
struct Vp_BFu7c_BFu7i { void * v1; unsigned char v2:7; unsigned int v3:7; };
struct Vp_BFu7c_BFu7ll { void * v1; unsigned char v2:7; unsigned long long v3:7; };
struct Vp_BFu7c_BFu7s { void * v1; unsigned char v2:7; unsigned short v3:7; };
struct Vp_BFu7c_BFu8c { void * v1; unsigned char v2:7; unsigned char v3:8; };
struct Vp_BFu7c_BFu8i { void * v1; unsigned char v2:7; unsigned int v3:8; };
struct Vp_BFu7c_BFu8ll { void * v1; unsigned char v2:7; unsigned long long v3:8; };
struct Vp_BFu7c_BFu8s { void * v1; unsigned char v2:7; unsigned short v3:8; };
struct Vp_BFu7c_BFu9i { void * v1; unsigned char v2:7; unsigned int v3:9; };
struct Vp_BFu7c_BFu9ll { void * v1; unsigned char v2:7; unsigned long long v3:9; };
struct Vp_BFu7c_BFu9s { void * v1; unsigned char v2:7; unsigned short v3:9; };
struct Vp_BFu7c_C { void * v1; unsigned char v2:7; char v3; };
struct Vp_BFu7c_D { void * v1; unsigned char v2:7; double v3; };
struct Vp_BFu7c_F { void * v1; unsigned char v2:7; float v3; };
struct Vp_BFu7c_I { void * v1; unsigned char v2:7; int v3; };
struct Vp_BFu7c_Ip { void * v1; unsigned char v2:7; int * v3; };
struct Vp_BFu7c_L { void * v1; unsigned char v2:7; long long v3; };
struct Vp_BFu7c_S { void * v1; unsigned char v2:7; short v3; };
struct Vp_BFu7c_Uc { void * v1; unsigned char v2:7; unsigned char v3; };
struct Vp_BFu7c_Ui { void * v1; unsigned char v2:7; unsigned int v3; };
struct Vp_BFu7c_Ul { void * v1; unsigned char v2:7; unsigned long long v3; };
struct Vp_BFu7c_Us { void * v1; unsigned char v2:7; unsigned short v3; };
struct Vp_BFu7c_Vp { void * v1; unsigned char v2:7; void * v3; };
struct Vp_BFu7i { void * v1; unsigned int v2:7; };
struct Vp_BFu7i_BFu15i { void * v1; unsigned int v2:7; unsigned int v3:15; };
struct Vp_BFu7i_BFu15ll { void * v1; unsigned int v2:7; unsigned long long v3:15; };
struct Vp_BFu7i_BFu15s { void * v1; unsigned int v2:7; unsigned short v3:15; };
struct Vp_BFu7i_BFu16i { void * v1; unsigned int v2:7; unsigned int v3:16; };
struct Vp_BFu7i_BFu16ll { void * v1; unsigned int v2:7; unsigned long long v3:16; };
struct Vp_BFu7i_BFu16s { void * v1; unsigned int v2:7; unsigned short v3:16; };
struct Vp_BFu7i_BFu17i { void * v1; unsigned int v2:7; unsigned int v3:17; };
struct Vp_BFu7i_BFu17ll { void * v1; unsigned int v2:7; unsigned long long v3:17; };
struct Vp_BFu7i_BFu1c { void * v1; unsigned int v2:7; unsigned char v3:1; };
struct Vp_BFu7i_BFu1i { void * v1; unsigned int v2:7; unsigned int v3:1; };
struct Vp_BFu7i_BFu1ll { void * v1; unsigned int v2:7; unsigned long long v3:1; };
struct Vp_BFu7i_BFu1s { void * v1; unsigned int v2:7; unsigned short v3:1; };
struct Vp_BFu7i_BFu31i { void * v1; unsigned int v2:7; unsigned int v3:31; };
struct Vp_BFu7i_BFu31ll { void * v1; unsigned int v2:7; unsigned long long v3:31; };
struct Vp_BFu7i_BFu32i { void * v1; unsigned int v2:7; unsigned int v3:32; };
struct Vp_BFu7i_BFu32ll { void * v1; unsigned int v2:7; unsigned long long v3:32; };
struct Vp_BFu7i_BFu33 { void * v1; unsigned int v2:7; unsigned long long v3:33; };
struct Vp_BFu7i_BFu7c { void * v1; unsigned int v2:7; unsigned char v3:7; };
struct Vp_BFu7i_BFu7i { void * v1; unsigned int v2:7; unsigned int v3:7; };
struct Vp_BFu7i_BFu7ll { void * v1; unsigned int v2:7; unsigned long long v3:7; };
struct Vp_BFu7i_BFu7s { void * v1; unsigned int v2:7; unsigned short v3:7; };
struct Vp_BFu7i_BFu8c { void * v1; unsigned int v2:7; unsigned char v3:8; };
struct Vp_BFu7i_BFu8i { void * v1; unsigned int v2:7; unsigned int v3:8; };
struct Vp_BFu7i_BFu8ll { void * v1; unsigned int v2:7; unsigned long long v3:8; };
struct Vp_BFu7i_BFu8s { void * v1; unsigned int v2:7; unsigned short v3:8; };
struct Vp_BFu7i_BFu9i { void * v1; unsigned int v2:7; unsigned int v3:9; };
struct Vp_BFu7i_BFu9ll { void * v1; unsigned int v2:7; unsigned long long v3:9; };
struct Vp_BFu7i_BFu9s { void * v1; unsigned int v2:7; unsigned short v3:9; };
struct Vp_BFu7i_C { void * v1; unsigned int v2:7; char v3; };
struct Vp_BFu7i_D { void * v1; unsigned int v2:7; double v3; };
struct Vp_BFu7i_F { void * v1; unsigned int v2:7; float v3; };
struct Vp_BFu7i_I { void * v1; unsigned int v2:7; int v3; };
struct Vp_BFu7i_Ip { void * v1; unsigned int v2:7; int * v3; };
struct Vp_BFu7i_L { void * v1; unsigned int v2:7; long long v3; };
struct Vp_BFu7i_S { void * v1; unsigned int v2:7; short v3; };
struct Vp_BFu7i_Uc { void * v1; unsigned int v2:7; unsigned char v3; };
struct Vp_BFu7i_Ui { void * v1; unsigned int v2:7; unsigned int v3; };
struct Vp_BFu7i_Ul { void * v1; unsigned int v2:7; unsigned long long v3; };
struct Vp_BFu7i_Us { void * v1; unsigned int v2:7; unsigned short v3; };
struct Vp_BFu7i_Vp { void * v1; unsigned int v2:7; void * v3; };
struct Vp_BFu7ll { void * v1; unsigned long long v2:7; };
struct Vp_BFu7ll_BFu15i { void * v1; unsigned long long v2:7; unsigned int v3:15; };
struct Vp_BFu7ll_BFu15ll { void * v1; unsigned long long v2:7; unsigned long long v3:15; };
struct Vp_BFu7ll_BFu15s { void * v1; unsigned long long v2:7; unsigned short v3:15; };
struct Vp_BFu7ll_BFu16i { void * v1; unsigned long long v2:7; unsigned int v3:16; };
struct Vp_BFu7ll_BFu16ll { void * v1; unsigned long long v2:7; unsigned long long v3:16; };
struct Vp_BFu7ll_BFu16s { void * v1; unsigned long long v2:7; unsigned short v3:16; };
struct Vp_BFu7ll_BFu17i { void * v1; unsigned long long v2:7; unsigned int v3:17; };
struct Vp_BFu7ll_BFu17ll { void * v1; unsigned long long v2:7; unsigned long long v3:17; };
struct Vp_BFu7ll_BFu1c { void * v1; unsigned long long v2:7; unsigned char v3:1; };
struct Vp_BFu7ll_BFu1i { void * v1; unsigned long long v2:7; unsigned int v3:1; };
struct Vp_BFu7ll_BFu1ll { void * v1; unsigned long long v2:7; unsigned long long v3:1; };
struct Vp_BFu7ll_BFu1s { void * v1; unsigned long long v2:7; unsigned short v3:1; };
struct Vp_BFu7ll_BFu31i { void * v1; unsigned long long v2:7; unsigned int v3:31; };
struct Vp_BFu7ll_BFu31ll { void * v1; unsigned long long v2:7; unsigned long long v3:31; };
struct Vp_BFu7ll_BFu32i { void * v1; unsigned long long v2:7; unsigned int v3:32; };
struct Vp_BFu7ll_BFu32ll { void * v1; unsigned long long v2:7; unsigned long long v3:32; };
struct Vp_BFu7ll_BFu33 { void * v1; unsigned long long v2:7; unsigned long long v3:33; };
struct Vp_BFu7ll_BFu7c { void * v1; unsigned long long v2:7; unsigned char v3:7; };
struct Vp_BFu7ll_BFu7i { void * v1; unsigned long long v2:7; unsigned int v3:7; };
struct Vp_BFu7ll_BFu7ll { void * v1; unsigned long long v2:7; unsigned long long v3:7; };
struct Vp_BFu7ll_BFu7s { void * v1; unsigned long long v2:7; unsigned short v3:7; };
struct Vp_BFu7ll_BFu8c { void * v1; unsigned long long v2:7; unsigned char v3:8; };
struct Vp_BFu7ll_BFu8i { void * v1; unsigned long long v2:7; unsigned int v3:8; };
struct Vp_BFu7ll_BFu8ll { void * v1; unsigned long long v2:7; unsigned long long v3:8; };
struct Vp_BFu7ll_BFu8s { void * v1; unsigned long long v2:7; unsigned short v3:8; };
struct Vp_BFu7ll_BFu9i { void * v1; unsigned long long v2:7; unsigned int v3:9; };
struct Vp_BFu7ll_BFu9ll { void * v1; unsigned long long v2:7; unsigned long long v3:9; };
struct Vp_BFu7ll_BFu9s { void * v1; unsigned long long v2:7; unsigned short v3:9; };
struct Vp_BFu7ll_C { void * v1; unsigned long long v2:7; char v3; };
struct Vp_BFu7ll_D { void * v1; unsigned long long v2:7; double v3; };
struct Vp_BFu7ll_F { void * v1; unsigned long long v2:7; float v3; };
struct Vp_BFu7ll_I { void * v1; unsigned long long v2:7; int v3; };
struct Vp_BFu7ll_Ip { void * v1; unsigned long long v2:7; int * v3; };
struct Vp_BFu7ll_L { void * v1; unsigned long long v2:7; long long v3; };
struct Vp_BFu7ll_S { void * v1; unsigned long long v2:7; short v3; };
struct Vp_BFu7ll_Uc { void * v1; unsigned long long v2:7; unsigned char v3; };
struct Vp_BFu7ll_Ui { void * v1; unsigned long long v2:7; unsigned int v3; };
struct Vp_BFu7ll_Ul { void * v1; unsigned long long v2:7; unsigned long long v3; };
struct Vp_BFu7ll_Us { void * v1; unsigned long long v2:7; unsigned short v3; };
struct Vp_BFu7ll_Vp { void * v1; unsigned long long v2:7; void * v3; };
struct Vp_BFu7s { void * v1; unsigned short v2:7; };
struct Vp_BFu7s_BFu15i { void * v1; unsigned short v2:7; unsigned int v3:15; };
struct Vp_BFu7s_BFu15ll { void * v1; unsigned short v2:7; unsigned long long v3:15; };
struct Vp_BFu7s_BFu15s { void * v1; unsigned short v2:7; unsigned short v3:15; };
struct Vp_BFu7s_BFu16i { void * v1; unsigned short v2:7; unsigned int v3:16; };
struct Vp_BFu7s_BFu16ll { void * v1; unsigned short v2:7; unsigned long long v3:16; };
struct Vp_BFu7s_BFu16s { void * v1; unsigned short v2:7; unsigned short v3:16; };
struct Vp_BFu7s_BFu17i { void * v1; unsigned short v2:7; unsigned int v3:17; };
struct Vp_BFu7s_BFu17ll { void * v1; unsigned short v2:7; unsigned long long v3:17; };
struct Vp_BFu7s_BFu1c { void * v1; unsigned short v2:7; unsigned char v3:1; };
struct Vp_BFu7s_BFu1i { void * v1; unsigned short v2:7; unsigned int v3:1; };
struct Vp_BFu7s_BFu1ll { void * v1; unsigned short v2:7; unsigned long long v3:1; };
struct Vp_BFu7s_BFu1s { void * v1; unsigned short v2:7; unsigned short v3:1; };
struct Vp_BFu7s_BFu31i { void * v1; unsigned short v2:7; unsigned int v3:31; };
struct Vp_BFu7s_BFu31ll { void * v1; unsigned short v2:7; unsigned long long v3:31; };
struct Vp_BFu7s_BFu32i { void * v1; unsigned short v2:7; unsigned int v3:32; };
struct Vp_BFu7s_BFu32ll { void * v1; unsigned short v2:7; unsigned long long v3:32; };
struct Vp_BFu7s_BFu33 { void * v1; unsigned short v2:7; unsigned long long v3:33; };
struct Vp_BFu7s_BFu7c { void * v1; unsigned short v2:7; unsigned char v3:7; };
struct Vp_BFu7s_BFu7i { void * v1; unsigned short v2:7; unsigned int v3:7; };
struct Vp_BFu7s_BFu7ll { void * v1; unsigned short v2:7; unsigned long long v3:7; };
struct Vp_BFu7s_BFu7s { void * v1; unsigned short v2:7; unsigned short v3:7; };
struct Vp_BFu7s_BFu8c { void * v1; unsigned short v2:7; unsigned char v3:8; };
struct Vp_BFu7s_BFu8i { void * v1; unsigned short v2:7; unsigned int v3:8; };
struct Vp_BFu7s_BFu8ll { void * v1; unsigned short v2:7; unsigned long long v3:8; };
struct Vp_BFu7s_BFu8s { void * v1; unsigned short v2:7; unsigned short v3:8; };
struct Vp_BFu7s_BFu9i { void * v1; unsigned short v2:7; unsigned int v3:9; };
struct Vp_BFu7s_BFu9ll { void * v1; unsigned short v2:7; unsigned long long v3:9; };
struct Vp_BFu7s_BFu9s { void * v1; unsigned short v2:7; unsigned short v3:9; };
struct Vp_BFu7s_C { void * v1; unsigned short v2:7; char v3; };
struct Vp_BFu7s_D { void * v1; unsigned short v2:7; double v3; };
struct Vp_BFu7s_F { void * v1; unsigned short v2:7; float v3; };
struct Vp_BFu7s_I { void * v1; unsigned short v2:7; int v3; };
struct Vp_BFu7s_Ip { void * v1; unsigned short v2:7; int * v3; };
struct Vp_BFu7s_L { void * v1; unsigned short v2:7; long long v3; };
struct Vp_BFu7s_S { void * v1; unsigned short v2:7; short v3; };
struct Vp_BFu7s_Uc { void * v1; unsigned short v2:7; unsigned char v3; };
struct Vp_BFu7s_Ui { void * v1; unsigned short v2:7; unsigned int v3; };
struct Vp_BFu7s_Ul { void * v1; unsigned short v2:7; unsigned long long v3; };
struct Vp_BFu7s_Us { void * v1; unsigned short v2:7; unsigned short v3; };
struct Vp_BFu7s_Vp { void * v1; unsigned short v2:7; void * v3; };
struct Vp_BFu8c { void * v1; unsigned char v2:8; };
struct Vp_BFu8c_BFu15i { void * v1; unsigned char v2:8; unsigned int v3:15; };
struct Vp_BFu8c_BFu15ll { void * v1; unsigned char v2:8; unsigned long long v3:15; };
struct Vp_BFu8c_BFu15s { void * v1; unsigned char v2:8; unsigned short v3:15; };
struct Vp_BFu8c_BFu16i { void * v1; unsigned char v2:8; unsigned int v3:16; };
struct Vp_BFu8c_BFu16ll { void * v1; unsigned char v2:8; unsigned long long v3:16; };
struct Vp_BFu8c_BFu16s { void * v1; unsigned char v2:8; unsigned short v3:16; };
struct Vp_BFu8c_BFu17i { void * v1; unsigned char v2:8; unsigned int v3:17; };
struct Vp_BFu8c_BFu17ll { void * v1; unsigned char v2:8; unsigned long long v3:17; };
struct Vp_BFu8c_BFu1c { void * v1; unsigned char v2:8; unsigned char v3:1; };
struct Vp_BFu8c_BFu1i { void * v1; unsigned char v2:8; unsigned int v3:1; };
struct Vp_BFu8c_BFu1ll { void * v1; unsigned char v2:8; unsigned long long v3:1; };
struct Vp_BFu8c_BFu1s { void * v1; unsigned char v2:8; unsigned short v3:1; };
struct Vp_BFu8c_BFu31i { void * v1; unsigned char v2:8; unsigned int v3:31; };
struct Vp_BFu8c_BFu31ll { void * v1; unsigned char v2:8; unsigned long long v3:31; };
struct Vp_BFu8c_BFu32i { void * v1; unsigned char v2:8; unsigned int v3:32; };
struct Vp_BFu8c_BFu32ll { void * v1; unsigned char v2:8; unsigned long long v3:32; };
struct Vp_BFu8c_BFu33 { void * v1; unsigned char v2:8; unsigned long long v3:33; };
struct Vp_BFu8c_BFu7c { void * v1; unsigned char v2:8; unsigned char v3:7; };
struct Vp_BFu8c_BFu7i { void * v1; unsigned char v2:8; unsigned int v3:7; };
struct Vp_BFu8c_BFu7ll { void * v1; unsigned char v2:8; unsigned long long v3:7; };
struct Vp_BFu8c_BFu7s { void * v1; unsigned char v2:8; unsigned short v3:7; };
struct Vp_BFu8c_BFu8c { void * v1; unsigned char v2:8; unsigned char v3:8; };
struct Vp_BFu8c_BFu8i { void * v1; unsigned char v2:8; unsigned int v3:8; };
struct Vp_BFu8c_BFu8ll { void * v1; unsigned char v2:8; unsigned long long v3:8; };
struct Vp_BFu8c_BFu8s { void * v1; unsigned char v2:8; unsigned short v3:8; };
struct Vp_BFu8c_BFu9i { void * v1; unsigned char v2:8; unsigned int v3:9; };
struct Vp_BFu8c_BFu9ll { void * v1; unsigned char v2:8; unsigned long long v3:9; };
struct Vp_BFu8c_BFu9s { void * v1; unsigned char v2:8; unsigned short v3:9; };
struct Vp_BFu8c_C { void * v1; unsigned char v2:8; char v3; };
struct Vp_BFu8c_D { void * v1; unsigned char v2:8; double v3; };
struct Vp_BFu8c_F { void * v1; unsigned char v2:8; float v3; };
struct Vp_BFu8c_I { void * v1; unsigned char v2:8; int v3; };
struct Vp_BFu8c_Ip { void * v1; unsigned char v2:8; int * v3; };
struct Vp_BFu8c_L { void * v1; unsigned char v2:8; long long v3; };
struct Vp_BFu8c_S { void * v1; unsigned char v2:8; short v3; };
struct Vp_BFu8c_Uc { void * v1; unsigned char v2:8; unsigned char v3; };
struct Vp_BFu8c_Ui { void * v1; unsigned char v2:8; unsigned int v3; };
struct Vp_BFu8c_Ul { void * v1; unsigned char v2:8; unsigned long long v3; };
struct Vp_BFu8c_Us { void * v1; unsigned char v2:8; unsigned short v3; };
struct Vp_BFu8c_Vp { void * v1; unsigned char v2:8; void * v3; };
struct Vp_BFu8i { void * v1; unsigned int v2:8; };
struct Vp_BFu8i_BFu15i { void * v1; unsigned int v2:8; unsigned int v3:15; };
struct Vp_BFu8i_BFu15ll { void * v1; unsigned int v2:8; unsigned long long v3:15; };
struct Vp_BFu8i_BFu15s { void * v1; unsigned int v2:8; unsigned short v3:15; };
struct Vp_BFu8i_BFu16i { void * v1; unsigned int v2:8; unsigned int v3:16; };
struct Vp_BFu8i_BFu16ll { void * v1; unsigned int v2:8; unsigned long long v3:16; };
struct Vp_BFu8i_BFu16s { void * v1; unsigned int v2:8; unsigned short v3:16; };
struct Vp_BFu8i_BFu17i { void * v1; unsigned int v2:8; unsigned int v3:17; };
struct Vp_BFu8i_BFu17ll { void * v1; unsigned int v2:8; unsigned long long v3:17; };
struct Vp_BFu8i_BFu1c { void * v1; unsigned int v2:8; unsigned char v3:1; };
struct Vp_BFu8i_BFu1i { void * v1; unsigned int v2:8; unsigned int v3:1; };
struct Vp_BFu8i_BFu1ll { void * v1; unsigned int v2:8; unsigned long long v3:1; };
struct Vp_BFu8i_BFu1s { void * v1; unsigned int v2:8; unsigned short v3:1; };
struct Vp_BFu8i_BFu31i { void * v1; unsigned int v2:8; unsigned int v3:31; };
struct Vp_BFu8i_BFu31ll { void * v1; unsigned int v2:8; unsigned long long v3:31; };
struct Vp_BFu8i_BFu32i { void * v1; unsigned int v2:8; unsigned int v3:32; };
struct Vp_BFu8i_BFu32ll { void * v1; unsigned int v2:8; unsigned long long v3:32; };
struct Vp_BFu8i_BFu33 { void * v1; unsigned int v2:8; unsigned long long v3:33; };
struct Vp_BFu8i_BFu7c { void * v1; unsigned int v2:8; unsigned char v3:7; };
struct Vp_BFu8i_BFu7i { void * v1; unsigned int v2:8; unsigned int v3:7; };
struct Vp_BFu8i_BFu7ll { void * v1; unsigned int v2:8; unsigned long long v3:7; };
struct Vp_BFu8i_BFu7s { void * v1; unsigned int v2:8; unsigned short v3:7; };
struct Vp_BFu8i_BFu8c { void * v1; unsigned int v2:8; unsigned char v3:8; };
struct Vp_BFu8i_BFu8i { void * v1; unsigned int v2:8; unsigned int v3:8; };
struct Vp_BFu8i_BFu8ll { void * v1; unsigned int v2:8; unsigned long long v3:8; };
struct Vp_BFu8i_BFu8s { void * v1; unsigned int v2:8; unsigned short v3:8; };
struct Vp_BFu8i_BFu9i { void * v1; unsigned int v2:8; unsigned int v3:9; };
struct Vp_BFu8i_BFu9ll { void * v1; unsigned int v2:8; unsigned long long v3:9; };
struct Vp_BFu8i_BFu9s { void * v1; unsigned int v2:8; unsigned short v3:9; };
struct Vp_BFu8i_C { void * v1; unsigned int v2:8; char v3; };
struct Vp_BFu8i_D { void * v1; unsigned int v2:8; double v3; };
struct Vp_BFu8i_F { void * v1; unsigned int v2:8; float v3; };
struct Vp_BFu8i_I { void * v1; unsigned int v2:8; int v3; };
struct Vp_BFu8i_Ip { void * v1; unsigned int v2:8; int * v3; };
struct Vp_BFu8i_L { void * v1; unsigned int v2:8; long long v3; };
struct Vp_BFu8i_S { void * v1; unsigned int v2:8; short v3; };
struct Vp_BFu8i_Uc { void * v1; unsigned int v2:8; unsigned char v3; };
struct Vp_BFu8i_Ui { void * v1; unsigned int v2:8; unsigned int v3; };
struct Vp_BFu8i_Ul { void * v1; unsigned int v2:8; unsigned long long v3; };
struct Vp_BFu8i_Us { void * v1; unsigned int v2:8; unsigned short v3; };
struct Vp_BFu8i_Vp { void * v1; unsigned int v2:8; void * v3; };
struct Vp_BFu8ll { void * v1; unsigned long long v2:8; };
struct Vp_BFu8ll_BFu15i { void * v1; unsigned long long v2:8; unsigned int v3:15; };
struct Vp_BFu8ll_BFu15ll { void * v1; unsigned long long v2:8; unsigned long long v3:15; };
struct Vp_BFu8ll_BFu15s { void * v1; unsigned long long v2:8; unsigned short v3:15; };
struct Vp_BFu8ll_BFu16i { void * v1; unsigned long long v2:8; unsigned int v3:16; };
struct Vp_BFu8ll_BFu16ll { void * v1; unsigned long long v2:8; unsigned long long v3:16; };
struct Vp_BFu8ll_BFu16s { void * v1; unsigned long long v2:8; unsigned short v3:16; };
struct Vp_BFu8ll_BFu17i { void * v1; unsigned long long v2:8; unsigned int v3:17; };
struct Vp_BFu8ll_BFu17ll { void * v1; unsigned long long v2:8; unsigned long long v3:17; };
struct Vp_BFu8ll_BFu1c { void * v1; unsigned long long v2:8; unsigned char v3:1; };
struct Vp_BFu8ll_BFu1i { void * v1; unsigned long long v2:8; unsigned int v3:1; };
struct Vp_BFu8ll_BFu1ll { void * v1; unsigned long long v2:8; unsigned long long v3:1; };
struct Vp_BFu8ll_BFu1s { void * v1; unsigned long long v2:8; unsigned short v3:1; };
struct Vp_BFu8ll_BFu31i { void * v1; unsigned long long v2:8; unsigned int v3:31; };
struct Vp_BFu8ll_BFu31ll { void * v1; unsigned long long v2:8; unsigned long long v3:31; };
struct Vp_BFu8ll_BFu32i { void * v1; unsigned long long v2:8; unsigned int v3:32; };
struct Vp_BFu8ll_BFu32ll { void * v1; unsigned long long v2:8; unsigned long long v3:32; };
struct Vp_BFu8ll_BFu33 { void * v1; unsigned long long v2:8; unsigned long long v3:33; };
struct Vp_BFu8ll_BFu7c { void * v1; unsigned long long v2:8; unsigned char v3:7; };
struct Vp_BFu8ll_BFu7i { void * v1; unsigned long long v2:8; unsigned int v3:7; };
struct Vp_BFu8ll_BFu7ll { void * v1; unsigned long long v2:8; unsigned long long v3:7; };
struct Vp_BFu8ll_BFu7s { void * v1; unsigned long long v2:8; unsigned short v3:7; };
struct Vp_BFu8ll_BFu8c { void * v1; unsigned long long v2:8; unsigned char v3:8; };
struct Vp_BFu8ll_BFu8i { void * v1; unsigned long long v2:8; unsigned int v3:8; };
struct Vp_BFu8ll_BFu8ll { void * v1; unsigned long long v2:8; unsigned long long v3:8; };
struct Vp_BFu8ll_BFu8s { void * v1; unsigned long long v2:8; unsigned short v3:8; };
struct Vp_BFu8ll_BFu9i { void * v1; unsigned long long v2:8; unsigned int v3:9; };
struct Vp_BFu8ll_BFu9ll { void * v1; unsigned long long v2:8; unsigned long long v3:9; };
struct Vp_BFu8ll_BFu9s { void * v1; unsigned long long v2:8; unsigned short v3:9; };
struct Vp_BFu8ll_C { void * v1; unsigned long long v2:8; char v3; };
struct Vp_BFu8ll_D { void * v1; unsigned long long v2:8; double v3; };
struct Vp_BFu8ll_F { void * v1; unsigned long long v2:8; float v3; };
struct Vp_BFu8ll_I { void * v1; unsigned long long v2:8; int v3; };
struct Vp_BFu8ll_Ip { void * v1; unsigned long long v2:8; int * v3; };
struct Vp_BFu8ll_L { void * v1; unsigned long long v2:8; long long v3; };
struct Vp_BFu8ll_S { void * v1; unsigned long long v2:8; short v3; };
struct Vp_BFu8ll_Uc { void * v1; unsigned long long v2:8; unsigned char v3; };
struct Vp_BFu8ll_Ui { void * v1; unsigned long long v2:8; unsigned int v3; };
struct Vp_BFu8ll_Ul { void * v1; unsigned long long v2:8; unsigned long long v3; };
struct Vp_BFu8ll_Us { void * v1; unsigned long long v2:8; unsigned short v3; };
struct Vp_BFu8ll_Vp { void * v1; unsigned long long v2:8; void * v3; };
struct Vp_BFu8s { void * v1; unsigned short v2:8; };
struct Vp_BFu8s_BFu15i { void * v1; unsigned short v2:8; unsigned int v3:15; };
struct Vp_BFu8s_BFu15ll { void * v1; unsigned short v2:8; unsigned long long v3:15; };
struct Vp_BFu8s_BFu15s { void * v1; unsigned short v2:8; unsigned short v3:15; };
struct Vp_BFu8s_BFu16i { void * v1; unsigned short v2:8; unsigned int v3:16; };
struct Vp_BFu8s_BFu16ll { void * v1; unsigned short v2:8; unsigned long long v3:16; };
struct Vp_BFu8s_BFu16s { void * v1; unsigned short v2:8; unsigned short v3:16; };
struct Vp_BFu8s_BFu17i { void * v1; unsigned short v2:8; unsigned int v3:17; };
struct Vp_BFu8s_BFu17ll { void * v1; unsigned short v2:8; unsigned long long v3:17; };
struct Vp_BFu8s_BFu1c { void * v1; unsigned short v2:8; unsigned char v3:1; };
struct Vp_BFu8s_BFu1i { void * v1; unsigned short v2:8; unsigned int v3:1; };
struct Vp_BFu8s_BFu1ll { void * v1; unsigned short v2:8; unsigned long long v3:1; };
struct Vp_BFu8s_BFu1s { void * v1; unsigned short v2:8; unsigned short v3:1; };
struct Vp_BFu8s_BFu31i { void * v1; unsigned short v2:8; unsigned int v3:31; };
struct Vp_BFu8s_BFu31ll { void * v1; unsigned short v2:8; unsigned long long v3:31; };
struct Vp_BFu8s_BFu32i { void * v1; unsigned short v2:8; unsigned int v3:32; };
struct Vp_BFu8s_BFu32ll { void * v1; unsigned short v2:8; unsigned long long v3:32; };
struct Vp_BFu8s_BFu33 { void * v1; unsigned short v2:8; unsigned long long v3:33; };
struct Vp_BFu8s_BFu7c { void * v1; unsigned short v2:8; unsigned char v3:7; };
struct Vp_BFu8s_BFu7i { void * v1; unsigned short v2:8; unsigned int v3:7; };
struct Vp_BFu8s_BFu7ll { void * v1; unsigned short v2:8; unsigned long long v3:7; };
struct Vp_BFu8s_BFu7s { void * v1; unsigned short v2:8; unsigned short v3:7; };
struct Vp_BFu8s_BFu8c { void * v1; unsigned short v2:8; unsigned char v3:8; };
struct Vp_BFu8s_BFu8i { void * v1; unsigned short v2:8; unsigned int v3:8; };
struct Vp_BFu8s_BFu8ll { void * v1; unsigned short v2:8; unsigned long long v3:8; };
struct Vp_BFu8s_BFu8s { void * v1; unsigned short v2:8; unsigned short v3:8; };
struct Vp_BFu8s_BFu9i { void * v1; unsigned short v2:8; unsigned int v3:9; };
struct Vp_BFu8s_BFu9ll { void * v1; unsigned short v2:8; unsigned long long v3:9; };
struct Vp_BFu8s_BFu9s { void * v1; unsigned short v2:8; unsigned short v3:9; };
struct Vp_BFu8s_C { void * v1; unsigned short v2:8; char v3; };
struct Vp_BFu8s_D { void * v1; unsigned short v2:8; double v3; };
struct Vp_BFu8s_F { void * v1; unsigned short v2:8; float v3; };
struct Vp_BFu8s_I { void * v1; unsigned short v2:8; int v3; };
struct Vp_BFu8s_Ip { void * v1; unsigned short v2:8; int * v3; };
struct Vp_BFu8s_L { void * v1; unsigned short v2:8; long long v3; };
struct Vp_BFu8s_S { void * v1; unsigned short v2:8; short v3; };
struct Vp_BFu8s_Uc { void * v1; unsigned short v2:8; unsigned char v3; };
struct Vp_BFu8s_Ui { void * v1; unsigned short v2:8; unsigned int v3; };
struct Vp_BFu8s_Ul { void * v1; unsigned short v2:8; unsigned long long v3; };
struct Vp_BFu8s_Us { void * v1; unsigned short v2:8; unsigned short v3; };
struct Vp_BFu8s_Vp { void * v1; unsigned short v2:8; void * v3; };
struct Vp_BFu9i { void * v1; unsigned int v2:9; };
struct Vp_BFu9i_BFu15i { void * v1; unsigned int v2:9; unsigned int v3:15; };
struct Vp_BFu9i_BFu15ll { void * v1; unsigned int v2:9; unsigned long long v3:15; };
struct Vp_BFu9i_BFu15s { void * v1; unsigned int v2:9; unsigned short v3:15; };
struct Vp_BFu9i_BFu16i { void * v1; unsigned int v2:9; unsigned int v3:16; };
struct Vp_BFu9i_BFu16ll { void * v1; unsigned int v2:9; unsigned long long v3:16; };
struct Vp_BFu9i_BFu16s { void * v1; unsigned int v2:9; unsigned short v3:16; };
struct Vp_BFu9i_BFu17i { void * v1; unsigned int v2:9; unsigned int v3:17; };
struct Vp_BFu9i_BFu17ll { void * v1; unsigned int v2:9; unsigned long long v3:17; };
struct Vp_BFu9i_BFu1c { void * v1; unsigned int v2:9; unsigned char v3:1; };
struct Vp_BFu9i_BFu1i { void * v1; unsigned int v2:9; unsigned int v3:1; };
struct Vp_BFu9i_BFu1ll { void * v1; unsigned int v2:9; unsigned long long v3:1; };
struct Vp_BFu9i_BFu1s { void * v1; unsigned int v2:9; unsigned short v3:1; };
struct Vp_BFu9i_BFu31i { void * v1; unsigned int v2:9; unsigned int v3:31; };
struct Vp_BFu9i_BFu31ll { void * v1; unsigned int v2:9; unsigned long long v3:31; };
struct Vp_BFu9i_BFu32i { void * v1; unsigned int v2:9; unsigned int v3:32; };
struct Vp_BFu9i_BFu32ll { void * v1; unsigned int v2:9; unsigned long long v3:32; };
struct Vp_BFu9i_BFu33 { void * v1; unsigned int v2:9; unsigned long long v3:33; };
struct Vp_BFu9i_BFu7c { void * v1; unsigned int v2:9; unsigned char v3:7; };
struct Vp_BFu9i_BFu7i { void * v1; unsigned int v2:9; unsigned int v3:7; };
struct Vp_BFu9i_BFu7ll { void * v1; unsigned int v2:9; unsigned long long v3:7; };
struct Vp_BFu9i_BFu7s { void * v1; unsigned int v2:9; unsigned short v3:7; };
struct Vp_BFu9i_BFu8c { void * v1; unsigned int v2:9; unsigned char v3:8; };
struct Vp_BFu9i_BFu8i { void * v1; unsigned int v2:9; unsigned int v3:8; };
struct Vp_BFu9i_BFu8ll { void * v1; unsigned int v2:9; unsigned long long v3:8; };
struct Vp_BFu9i_BFu8s { void * v1; unsigned int v2:9; unsigned short v3:8; };
struct Vp_BFu9i_BFu9i { void * v1; unsigned int v2:9; unsigned int v3:9; };
struct Vp_BFu9i_BFu9ll { void * v1; unsigned int v2:9; unsigned long long v3:9; };
struct Vp_BFu9i_BFu9s { void * v1; unsigned int v2:9; unsigned short v3:9; };
struct Vp_BFu9i_C { void * v1; unsigned int v2:9; char v3; };
struct Vp_BFu9i_D { void * v1; unsigned int v2:9; double v3; };
struct Vp_BFu9i_F { void * v1; unsigned int v2:9; float v3; };
struct Vp_BFu9i_I { void * v1; unsigned int v2:9; int v3; };
struct Vp_BFu9i_Ip { void * v1; unsigned int v2:9; int * v3; };
struct Vp_BFu9i_L { void * v1; unsigned int v2:9; long long v3; };
struct Vp_BFu9i_S { void * v1; unsigned int v2:9; short v3; };
struct Vp_BFu9i_Uc { void * v1; unsigned int v2:9; unsigned char v3; };
struct Vp_BFu9i_Ui { void * v1; unsigned int v2:9; unsigned int v3; };
struct Vp_BFu9i_Ul { void * v1; unsigned int v2:9; unsigned long long v3; };
struct Vp_BFu9i_Us { void * v1; unsigned int v2:9; unsigned short v3; };
struct Vp_BFu9i_Vp { void * v1; unsigned int v2:9; void * v3; };
struct Vp_BFu9ll { void * v1; unsigned long long v2:9; };
struct Vp_BFu9ll_BFu15i { void * v1; unsigned long long v2:9; unsigned int v3:15; };
struct Vp_BFu9ll_BFu15ll { void * v1; unsigned long long v2:9; unsigned long long v3:15; };
struct Vp_BFu9ll_BFu15s { void * v1; unsigned long long v2:9; unsigned short v3:15; };
struct Vp_BFu9ll_BFu16i { void * v1; unsigned long long v2:9; unsigned int v3:16; };
struct Vp_BFu9ll_BFu16ll { void * v1; unsigned long long v2:9; unsigned long long v3:16; };
struct Vp_BFu9ll_BFu16s { void * v1; unsigned long long v2:9; unsigned short v3:16; };
struct Vp_BFu9ll_BFu17i { void * v1; unsigned long long v2:9; unsigned int v3:17; };
struct Vp_BFu9ll_BFu17ll { void * v1; unsigned long long v2:9; unsigned long long v3:17; };
struct Vp_BFu9ll_BFu1c { void * v1; unsigned long long v2:9; unsigned char v3:1; };
struct Vp_BFu9ll_BFu1i { void * v1; unsigned long long v2:9; unsigned int v3:1; };
struct Vp_BFu9ll_BFu1ll { void * v1; unsigned long long v2:9; unsigned long long v3:1; };
struct Vp_BFu9ll_BFu1s { void * v1; unsigned long long v2:9; unsigned short v3:1; };
struct Vp_BFu9ll_BFu31i { void * v1; unsigned long long v2:9; unsigned int v3:31; };
struct Vp_BFu9ll_BFu31ll { void * v1; unsigned long long v2:9; unsigned long long v3:31; };
struct Vp_BFu9ll_BFu32i { void * v1; unsigned long long v2:9; unsigned int v3:32; };
struct Vp_BFu9ll_BFu32ll { void * v1; unsigned long long v2:9; unsigned long long v3:32; };
struct Vp_BFu9ll_BFu33 { void * v1; unsigned long long v2:9; unsigned long long v3:33; };
struct Vp_BFu9ll_BFu7c { void * v1; unsigned long long v2:9; unsigned char v3:7; };
struct Vp_BFu9ll_BFu7i { void * v1; unsigned long long v2:9; unsigned int v3:7; };
struct Vp_BFu9ll_BFu7ll { void * v1; unsigned long long v2:9; unsigned long long v3:7; };
struct Vp_BFu9ll_BFu7s { void * v1; unsigned long long v2:9; unsigned short v3:7; };
struct Vp_BFu9ll_BFu8c { void * v1; unsigned long long v2:9; unsigned char v3:8; };
struct Vp_BFu9ll_BFu8i { void * v1; unsigned long long v2:9; unsigned int v3:8; };
struct Vp_BFu9ll_BFu8ll { void * v1; unsigned long long v2:9; unsigned long long v3:8; };
struct Vp_BFu9ll_BFu8s { void * v1; unsigned long long v2:9; unsigned short v3:8; };
struct Vp_BFu9ll_BFu9i { void * v1; unsigned long long v2:9; unsigned int v3:9; };
struct Vp_BFu9ll_BFu9ll { void * v1; unsigned long long v2:9; unsigned long long v3:9; };
struct Vp_BFu9ll_BFu9s { void * v1; unsigned long long v2:9; unsigned short v3:9; };
struct Vp_BFu9ll_C { void * v1; unsigned long long v2:9; char v3; };
struct Vp_BFu9ll_D { void * v1; unsigned long long v2:9; double v3; };
struct Vp_BFu9ll_F { void * v1; unsigned long long v2:9; float v3; };
struct Vp_BFu9ll_I { void * v1; unsigned long long v2:9; int v3; };
struct Vp_BFu9ll_Ip { void * v1; unsigned long long v2:9; int * v3; };
struct Vp_BFu9ll_L { void * v1; unsigned long long v2:9; long long v3; };
struct Vp_BFu9ll_S { void * v1; unsigned long long v2:9; short v3; };
struct Vp_BFu9ll_Uc { void * v1; unsigned long long v2:9; unsigned char v3; };
struct Vp_BFu9ll_Ui { void * v1; unsigned long long v2:9; unsigned int v3; };
struct Vp_BFu9ll_Ul { void * v1; unsigned long long v2:9; unsigned long long v3; };
struct Vp_BFu9ll_Us { void * v1; unsigned long long v2:9; unsigned short v3; };
struct Vp_BFu9ll_Vp { void * v1; unsigned long long v2:9; void * v3; };
struct Vp_BFu9s { void * v1; unsigned short v2:9; };
struct Vp_BFu9s_BFu15i { void * v1; unsigned short v2:9; unsigned int v3:15; };
struct Vp_BFu9s_BFu15ll { void * v1; unsigned short v2:9; unsigned long long v3:15; };
struct Vp_BFu9s_BFu15s { void * v1; unsigned short v2:9; unsigned short v3:15; };
struct Vp_BFu9s_BFu16i { void * v1; unsigned short v2:9; unsigned int v3:16; };
struct Vp_BFu9s_BFu16ll { void * v1; unsigned short v2:9; unsigned long long v3:16; };
struct Vp_BFu9s_BFu16s { void * v1; unsigned short v2:9; unsigned short v3:16; };
struct Vp_BFu9s_BFu17i { void * v1; unsigned short v2:9; unsigned int v3:17; };
struct Vp_BFu9s_BFu17ll { void * v1; unsigned short v2:9; unsigned long long v3:17; };
struct Vp_BFu9s_BFu1c { void * v1; unsigned short v2:9; unsigned char v3:1; };
struct Vp_BFu9s_BFu1i { void * v1; unsigned short v2:9; unsigned int v3:1; };
struct Vp_BFu9s_BFu1ll { void * v1; unsigned short v2:9; unsigned long long v3:1; };
struct Vp_BFu9s_BFu1s { void * v1; unsigned short v2:9; unsigned short v3:1; };
struct Vp_BFu9s_BFu31i { void * v1; unsigned short v2:9; unsigned int v3:31; };
struct Vp_BFu9s_BFu31ll { void * v1; unsigned short v2:9; unsigned long long v3:31; };
struct Vp_BFu9s_BFu32i { void * v1; unsigned short v2:9; unsigned int v3:32; };
struct Vp_BFu9s_BFu32ll { void * v1; unsigned short v2:9; unsigned long long v3:32; };
struct Vp_BFu9s_BFu33 { void * v1; unsigned short v2:9; unsigned long long v3:33; };
struct Vp_BFu9s_BFu7c { void * v1; unsigned short v2:9; unsigned char v3:7; };
struct Vp_BFu9s_BFu7i { void * v1; unsigned short v2:9; unsigned int v3:7; };
struct Vp_BFu9s_BFu7ll { void * v1; unsigned short v2:9; unsigned long long v3:7; };
struct Vp_BFu9s_BFu7s { void * v1; unsigned short v2:9; unsigned short v3:7; };
struct Vp_BFu9s_BFu8c { void * v1; unsigned short v2:9; unsigned char v3:8; };
struct Vp_BFu9s_BFu8i { void * v1; unsigned short v2:9; unsigned int v3:8; };
struct Vp_BFu9s_BFu8ll { void * v1; unsigned short v2:9; unsigned long long v3:8; };
struct Vp_BFu9s_BFu8s { void * v1; unsigned short v2:9; unsigned short v3:8; };
struct Vp_BFu9s_BFu9i { void * v1; unsigned short v2:9; unsigned int v3:9; };
struct Vp_BFu9s_BFu9ll { void * v1; unsigned short v2:9; unsigned long long v3:9; };
struct Vp_BFu9s_BFu9s { void * v1; unsigned short v2:9; unsigned short v3:9; };
struct Vp_BFu9s_C { void * v1; unsigned short v2:9; char v3; };
struct Vp_BFu9s_D { void * v1; unsigned short v2:9; double v3; };
struct Vp_BFu9s_F { void * v1; unsigned short v2:9; float v3; };
struct Vp_BFu9s_I { void * v1; unsigned short v2:9; int v3; };
struct Vp_BFu9s_Ip { void * v1; unsigned short v2:9; int * v3; };
struct Vp_BFu9s_L { void * v1; unsigned short v2:9; long long v3; };
struct Vp_BFu9s_S { void * v1; unsigned short v2:9; short v3; };
struct Vp_BFu9s_Uc { void * v1; unsigned short v2:9; unsigned char v3; };
struct Vp_BFu9s_Ui { void * v1; unsigned short v2:9; unsigned int v3; };
struct Vp_BFu9s_Ul { void * v1; unsigned short v2:9; unsigned long long v3; };
struct Vp_BFu9s_Us { void * v1; unsigned short v2:9; unsigned short v3; };
struct Vp_BFu9s_Vp { void * v1; unsigned short v2:9; void * v3; };
struct Vp_C { void * v1; char v2; };
struct Vp_C_BFu15i { void * v1; char v2; unsigned int v3:15; };
struct Vp_C_BFu15ll { void * v1; char v2; unsigned long long v3:15; };
struct Vp_C_BFu15s { void * v1; char v2; unsigned short v3:15; };
struct Vp_C_BFu16i { void * v1; char v2; unsigned int v3:16; };
struct Vp_C_BFu16ll { void * v1; char v2; unsigned long long v3:16; };
struct Vp_C_BFu16s { void * v1; char v2; unsigned short v3:16; };
struct Vp_C_BFu17i { void * v1; char v2; unsigned int v3:17; };
struct Vp_C_BFu17ll { void * v1; char v2; unsigned long long v3:17; };
struct Vp_C_BFu1c { void * v1; char v2; unsigned char v3:1; };
struct Vp_C_BFu1i { void * v1; char v2; unsigned int v3:1; };
struct Vp_C_BFu1ll { void * v1; char v2; unsigned long long v3:1; };
struct Vp_C_BFu1s { void * v1; char v2; unsigned short v3:1; };
struct Vp_C_BFu31i { void * v1; char v2; unsigned int v3:31; };
struct Vp_C_BFu31ll { void * v1; char v2; unsigned long long v3:31; };
struct Vp_C_BFu32i { void * v1; char v2; unsigned int v3:32; };
struct Vp_C_BFu32ll { void * v1; char v2; unsigned long long v3:32; };
struct Vp_C_BFu33 { void * v1; char v2; unsigned long long v3:33; };
struct Vp_C_BFu7c { void * v1; char v2; unsigned char v3:7; };
struct Vp_C_BFu7i { void * v1; char v2; unsigned int v3:7; };
struct Vp_C_BFu7ll { void * v1; char v2; unsigned long long v3:7; };
struct Vp_C_BFu7s { void * v1; char v2; unsigned short v3:7; };
struct Vp_C_BFu8c { void * v1; char v2; unsigned char v3:8; };
struct Vp_C_BFu8i { void * v1; char v2; unsigned int v3:8; };
struct Vp_C_BFu8ll { void * v1; char v2; unsigned long long v3:8; };
struct Vp_C_BFu8s { void * v1; char v2; unsigned short v3:8; };
struct Vp_C_BFu9i { void * v1; char v2; unsigned int v3:9; };
struct Vp_C_BFu9ll { void * v1; char v2; unsigned long long v3:9; };
struct Vp_C_BFu9s { void * v1; char v2; unsigned short v3:9; };
struct Vp_C_C { void * v1; char v2; char v3; };
struct Vp_C_D { void * v1; char v2; double v3; };
struct Vp_C_F { void * v1; char v2; float v3; };
struct Vp_C_I { void * v1; char v2; int v3; };
struct Vp_C_Ip { void * v1; char v2; int * v3; };
struct Vp_C_L { void * v1; char v2; long long v3; };
struct Vp_C_S { void * v1; char v2; short v3; };
struct Vp_C_Uc { void * v1; char v2; unsigned char v3; };
struct Vp_C_Ui { void * v1; char v2; unsigned int v3; };
struct Vp_C_Ul { void * v1; char v2; unsigned long long v3; };
struct Vp_C_Us { void * v1; char v2; unsigned short v3; };
struct Vp_C_Vp { void * v1; char v2; void * v3; };
struct Vp_D { void * v1; double v2; };
struct Vp_D_BFu15i { void * v1; double v2; unsigned int v3:15; };
struct Vp_D_BFu15ll { void * v1; double v2; unsigned long long v3:15; };
struct Vp_D_BFu15s { void * v1; double v2; unsigned short v3:15; };
struct Vp_D_BFu16i { void * v1; double v2; unsigned int v3:16; };
struct Vp_D_BFu16ll { void * v1; double v2; unsigned long long v3:16; };
struct Vp_D_BFu16s { void * v1; double v2; unsigned short v3:16; };
struct Vp_D_BFu17i { void * v1; double v2; unsigned int v3:17; };
struct Vp_D_BFu17ll { void * v1; double v2; unsigned long long v3:17; };
struct Vp_D_BFu1c { void * v1; double v2; unsigned char v3:1; };
struct Vp_D_BFu1i { void * v1; double v2; unsigned int v3:1; };
struct Vp_D_BFu1ll { void * v1; double v2; unsigned long long v3:1; };
struct Vp_D_BFu1s { void * v1; double v2; unsigned short v3:1; };
struct Vp_D_BFu31i { void * v1; double v2; unsigned int v3:31; };
struct Vp_D_BFu31ll { void * v1; double v2; unsigned long long v3:31; };
struct Vp_D_BFu32i { void * v1; double v2; unsigned int v3:32; };
struct Vp_D_BFu32ll { void * v1; double v2; unsigned long long v3:32; };
struct Vp_D_BFu33 { void * v1; double v2; unsigned long long v3:33; };
struct Vp_D_BFu7c { void * v1; double v2; unsigned char v3:7; };
struct Vp_D_BFu7i { void * v1; double v2; unsigned int v3:7; };
struct Vp_D_BFu7ll { void * v1; double v2; unsigned long long v3:7; };
struct Vp_D_BFu7s { void * v1; double v2; unsigned short v3:7; };
struct Vp_D_BFu8c { void * v1; double v2; unsigned char v3:8; };
struct Vp_D_BFu8i { void * v1; double v2; unsigned int v3:8; };
struct Vp_D_BFu8ll { void * v1; double v2; unsigned long long v3:8; };
struct Vp_D_BFu8s { void * v1; double v2; unsigned short v3:8; };
struct Vp_D_BFu9i { void * v1; double v2; unsigned int v3:9; };
struct Vp_D_BFu9ll { void * v1; double v2; unsigned long long v3:9; };
struct Vp_D_BFu9s { void * v1; double v2; unsigned short v3:9; };
struct Vp_D_C { void * v1; double v2; char v3; };
struct Vp_D_D { void * v1; double v2; double v3; };
struct Vp_D_F { void * v1; double v2; float v3; };
struct Vp_D_I { void * v1; double v2; int v3; };
struct Vp_D_Ip { void * v1; double v2; int * v3; };
struct Vp_D_L { void * v1; double v2; long long v3; };
struct Vp_D_S { void * v1; double v2; short v3; };
struct Vp_D_Uc { void * v1; double v2; unsigned char v3; };
struct Vp_D_Ui { void * v1; double v2; unsigned int v3; };
struct Vp_D_Ul { void * v1; double v2; unsigned long long v3; };
struct Vp_D_Us { void * v1; double v2; unsigned short v3; };
struct Vp_D_Vp { void * v1; double v2; void * v3; };
struct Vp_F { void * v1; float v2; };
struct Vp_F_BFu15i { void * v1; float v2; unsigned int v3:15; };
struct Vp_F_BFu15ll { void * v1; float v2; unsigned long long v3:15; };
struct Vp_F_BFu15s { void * v1; float v2; unsigned short v3:15; };
struct Vp_F_BFu16i { void * v1; float v2; unsigned int v3:16; };
struct Vp_F_BFu16ll { void * v1; float v2; unsigned long long v3:16; };
struct Vp_F_BFu16s { void * v1; float v2; unsigned short v3:16; };
struct Vp_F_BFu17i { void * v1; float v2; unsigned int v3:17; };
struct Vp_F_BFu17ll { void * v1; float v2; unsigned long long v3:17; };
struct Vp_F_BFu1c { void * v1; float v2; unsigned char v3:1; };
struct Vp_F_BFu1i { void * v1; float v2; unsigned int v3:1; };
struct Vp_F_BFu1ll { void * v1; float v2; unsigned long long v3:1; };
struct Vp_F_BFu1s { void * v1; float v2; unsigned short v3:1; };
struct Vp_F_BFu31i { void * v1; float v2; unsigned int v3:31; };
struct Vp_F_BFu31ll { void * v1; float v2; unsigned long long v3:31; };
struct Vp_F_BFu32i { void * v1; float v2; unsigned int v3:32; };
struct Vp_F_BFu32ll { void * v1; float v2; unsigned long long v3:32; };
struct Vp_F_BFu33 { void * v1; float v2; unsigned long long v3:33; };
struct Vp_F_BFu7c { void * v1; float v2; unsigned char v3:7; };
struct Vp_F_BFu7i { void * v1; float v2; unsigned int v3:7; };
struct Vp_F_BFu7ll { void * v1; float v2; unsigned long long v3:7; };
struct Vp_F_BFu7s { void * v1; float v2; unsigned short v3:7; };
struct Vp_F_BFu8c { void * v1; float v2; unsigned char v3:8; };
struct Vp_F_BFu8i { void * v1; float v2; unsigned int v3:8; };
struct Vp_F_BFu8ll { void * v1; float v2; unsigned long long v3:8; };
struct Vp_F_BFu8s { void * v1; float v2; unsigned short v3:8; };
struct Vp_F_BFu9i { void * v1; float v2; unsigned int v3:9; };
struct Vp_F_BFu9ll { void * v1; float v2; unsigned long long v3:9; };
struct Vp_F_BFu9s { void * v1; float v2; unsigned short v3:9; };
struct Vp_F_C { void * v1; float v2; char v3; };
struct Vp_F_D { void * v1; float v2; double v3; };
struct Vp_F_F { void * v1; float v2; float v3; };
struct Vp_F_I { void * v1; float v2; int v3; };
struct Vp_F_Ip { void * v1; float v2; int * v3; };
struct Vp_F_L { void * v1; float v2; long long v3; };
struct Vp_F_S { void * v1; float v2; short v3; };
struct Vp_F_Uc { void * v1; float v2; unsigned char v3; };
struct Vp_F_Ui { void * v1; float v2; unsigned int v3; };
struct Vp_F_Ul { void * v1; float v2; unsigned long long v3; };
struct Vp_F_Us { void * v1; float v2; unsigned short v3; };
struct Vp_F_Vp { void * v1; float v2; void * v3; };
struct Vp_I { void * v1; int v2; };
struct Vp_I_BFu15i { void * v1; int v2; unsigned int v3:15; };
struct Vp_I_BFu15ll { void * v1; int v2; unsigned long long v3:15; };
struct Vp_I_BFu15s { void * v1; int v2; unsigned short v3:15; };
struct Vp_I_BFu16i { void * v1; int v2; unsigned int v3:16; };
struct Vp_I_BFu16ll { void * v1; int v2; unsigned long long v3:16; };
struct Vp_I_BFu16s { void * v1; int v2; unsigned short v3:16; };
struct Vp_I_BFu17i { void * v1; int v2; unsigned int v3:17; };
struct Vp_I_BFu17ll { void * v1; int v2; unsigned long long v3:17; };
struct Vp_I_BFu1c { void * v1; int v2; unsigned char v3:1; };
struct Vp_I_BFu1i { void * v1; int v2; unsigned int v3:1; };
struct Vp_I_BFu1ll { void * v1; int v2; unsigned long long v3:1; };
struct Vp_I_BFu1s { void * v1; int v2; unsigned short v3:1; };
struct Vp_I_BFu31i { void * v1; int v2; unsigned int v3:31; };
struct Vp_I_BFu31ll { void * v1; int v2; unsigned long long v3:31; };
struct Vp_I_BFu32i { void * v1; int v2; unsigned int v3:32; };
struct Vp_I_BFu32ll { void * v1; int v2; unsigned long long v3:32; };
struct Vp_I_BFu33 { void * v1; int v2; unsigned long long v3:33; };
struct Vp_I_BFu7c { void * v1; int v2; unsigned char v3:7; };
struct Vp_I_BFu7i { void * v1; int v2; unsigned int v3:7; };
struct Vp_I_BFu7ll { void * v1; int v2; unsigned long long v3:7; };
struct Vp_I_BFu7s { void * v1; int v2; unsigned short v3:7; };
struct Vp_I_BFu8c { void * v1; int v2; unsigned char v3:8; };
struct Vp_I_BFu8i { void * v1; int v2; unsigned int v3:8; };
struct Vp_I_BFu8ll { void * v1; int v2; unsigned long long v3:8; };
struct Vp_I_BFu8s { void * v1; int v2; unsigned short v3:8; };
struct Vp_I_BFu9i { void * v1; int v2; unsigned int v3:9; };
struct Vp_I_BFu9ll { void * v1; int v2; unsigned long long v3:9; };
struct Vp_I_BFu9s { void * v1; int v2; unsigned short v3:9; };
struct Vp_I_C { void * v1; int v2; char v3; };
struct Vp_I_D { void * v1; int v2; double v3; };
struct Vp_I_F { void * v1; int v2; float v3; };
struct Vp_I_I { void * v1; int v2; int v3; };
struct Vp_I_Ip { void * v1; int v2; int * v3; };
struct Vp_I_L { void * v1; int v2; long long v3; };
struct Vp_I_S { void * v1; int v2; short v3; };
struct Vp_I_Uc { void * v1; int v2; unsigned char v3; };
struct Vp_I_Ui { void * v1; int v2; unsigned int v3; };
struct Vp_I_Ul { void * v1; int v2; unsigned long long v3; };
struct Vp_I_Us { void * v1; int v2; unsigned short v3; };
struct Vp_I_Vp { void * v1; int v2; void * v3; };
struct Vp_Ip { void * v1; int * v2; };
struct Vp_Ip_BFu15i { void * v1; int * v2; unsigned int v3:15; };
struct Vp_Ip_BFu15ll { void * v1; int * v2; unsigned long long v3:15; };
struct Vp_Ip_BFu15s { void * v1; int * v2; unsigned short v3:15; };
struct Vp_Ip_BFu16i { void * v1; int * v2; unsigned int v3:16; };
struct Vp_Ip_BFu16ll { void * v1; int * v2; unsigned long long v3:16; };
struct Vp_Ip_BFu16s { void * v1; int * v2; unsigned short v3:16; };
struct Vp_Ip_BFu17i { void * v1; int * v2; unsigned int v3:17; };
struct Vp_Ip_BFu17ll { void * v1; int * v2; unsigned long long v3:17; };
struct Vp_Ip_BFu1c { void * v1; int * v2; unsigned char v3:1; };
struct Vp_Ip_BFu1i { void * v1; int * v2; unsigned int v3:1; };
struct Vp_Ip_BFu1ll { void * v1; int * v2; unsigned long long v3:1; };
struct Vp_Ip_BFu1s { void * v1; int * v2; unsigned short v3:1; };
struct Vp_Ip_BFu31i { void * v1; int * v2; unsigned int v3:31; };
struct Vp_Ip_BFu31ll { void * v1; int * v2; unsigned long long v3:31; };
struct Vp_Ip_BFu32i { void * v1; int * v2; unsigned int v3:32; };
struct Vp_Ip_BFu32ll { void * v1; int * v2; unsigned long long v3:32; };
struct Vp_Ip_BFu33 { void * v1; int * v2; unsigned long long v3:33; };
struct Vp_Ip_BFu7c { void * v1; int * v2; unsigned char v3:7; };
struct Vp_Ip_BFu7i { void * v1; int * v2; unsigned int v3:7; };
struct Vp_Ip_BFu7ll { void * v1; int * v2; unsigned long long v3:7; };
struct Vp_Ip_BFu7s { void * v1; int * v2; unsigned short v3:7; };
struct Vp_Ip_BFu8c { void * v1; int * v2; unsigned char v3:8; };
struct Vp_Ip_BFu8i { void * v1; int * v2; unsigned int v3:8; };
struct Vp_Ip_BFu8ll { void * v1; int * v2; unsigned long long v3:8; };
struct Vp_Ip_BFu8s { void * v1; int * v2; unsigned short v3:8; };
struct Vp_Ip_BFu9i { void * v1; int * v2; unsigned int v3:9; };
struct Vp_Ip_BFu9ll { void * v1; int * v2; unsigned long long v3:9; };
struct Vp_Ip_BFu9s { void * v1; int * v2; unsigned short v3:9; };
struct Vp_Ip_C { void * v1; int * v2; char v3; };
struct Vp_Ip_D { void * v1; int * v2; double v3; };
struct Vp_Ip_F { void * v1; int * v2; float v3; };
struct Vp_Ip_I { void * v1; int * v2; int v3; };
struct Vp_Ip_Ip { void * v1; int * v2; int * v3; };
struct Vp_Ip_L { void * v1; int * v2; long long v3; };
struct Vp_Ip_S { void * v1; int * v2; short v3; };
struct Vp_Ip_Uc { void * v1; int * v2; unsigned char v3; };
struct Vp_Ip_Ui { void * v1; int * v2; unsigned int v3; };
struct Vp_Ip_Ul { void * v1; int * v2; unsigned long long v3; };
struct Vp_Ip_Us { void * v1; int * v2; unsigned short v3; };
struct Vp_Ip_Vp { void * v1; int * v2; void * v3; };
struct Vp_L { void * v1; long long v2; };
struct Vp_L_BFu15i { void * v1; long long v2; unsigned int v3:15; };
struct Vp_L_BFu15ll { void * v1; long long v2; unsigned long long v3:15; };
struct Vp_L_BFu15s { void * v1; long long v2; unsigned short v3:15; };
struct Vp_L_BFu16i { void * v1; long long v2; unsigned int v3:16; };
struct Vp_L_BFu16ll { void * v1; long long v2; unsigned long long v3:16; };
struct Vp_L_BFu16s { void * v1; long long v2; unsigned short v3:16; };
struct Vp_L_BFu17i { void * v1; long long v2; unsigned int v3:17; };
struct Vp_L_BFu17ll { void * v1; long long v2; unsigned long long v3:17; };
struct Vp_L_BFu1c { void * v1; long long v2; unsigned char v3:1; };
struct Vp_L_BFu1i { void * v1; long long v2; unsigned int v3:1; };
struct Vp_L_BFu1ll { void * v1; long long v2; unsigned long long v3:1; };
struct Vp_L_BFu1s { void * v1; long long v2; unsigned short v3:1; };
struct Vp_L_BFu31i { void * v1; long long v2; unsigned int v3:31; };
struct Vp_L_BFu31ll { void * v1; long long v2; unsigned long long v3:31; };
struct Vp_L_BFu32i { void * v1; long long v2; unsigned int v3:32; };
struct Vp_L_BFu32ll { void * v1; long long v2; unsigned long long v3:32; };
struct Vp_L_BFu33 { void * v1; long long v2; unsigned long long v3:33; };
struct Vp_L_BFu7c { void * v1; long long v2; unsigned char v3:7; };
struct Vp_L_BFu7i { void * v1; long long v2; unsigned int v3:7; };
struct Vp_L_BFu7ll { void * v1; long long v2; unsigned long long v3:7; };
struct Vp_L_BFu7s { void * v1; long long v2; unsigned short v3:7; };
struct Vp_L_BFu8c { void * v1; long long v2; unsigned char v3:8; };
struct Vp_L_BFu8i { void * v1; long long v2; unsigned int v3:8; };
struct Vp_L_BFu8ll { void * v1; long long v2; unsigned long long v3:8; };
struct Vp_L_BFu8s { void * v1; long long v2; unsigned short v3:8; };
struct Vp_L_BFu9i { void * v1; long long v2; unsigned int v3:9; };
struct Vp_L_BFu9ll { void * v1; long long v2; unsigned long long v3:9; };
struct Vp_L_BFu9s { void * v1; long long v2; unsigned short v3:9; };
struct Vp_L_C { void * v1; long long v2; char v3; };
struct Vp_L_D { void * v1; long long v2; double v3; };
struct Vp_L_F { void * v1; long long v2; float v3; };
struct Vp_L_I { void * v1; long long v2; int v3; };
struct Vp_L_Ip { void * v1; long long v2; int * v3; };
struct Vp_L_L { void * v1; long long v2; long long v3; };
struct Vp_L_S { void * v1; long long v2; short v3; };
struct Vp_L_Uc { void * v1; long long v2; unsigned char v3; };
struct Vp_L_Ui { void * v1; long long v2; unsigned int v3; };
struct Vp_L_Ul { void * v1; long long v2; unsigned long long v3; };
struct Vp_L_Us { void * v1; long long v2; unsigned short v3; };
struct Vp_L_Vp { void * v1; long long v2; void * v3; };
struct Vp_S { void * v1; short v2; };
struct Vp_S_BFu15i { void * v1; short v2; unsigned int v3:15; };
struct Vp_S_BFu15ll { void * v1; short v2; unsigned long long v3:15; };
struct Vp_S_BFu15s { void * v1; short v2; unsigned short v3:15; };
struct Vp_S_BFu16i { void * v1; short v2; unsigned int v3:16; };
struct Vp_S_BFu16ll { void * v1; short v2; unsigned long long v3:16; };
struct Vp_S_BFu16s { void * v1; short v2; unsigned short v3:16; };
struct Vp_S_BFu17i { void * v1; short v2; unsigned int v3:17; };
struct Vp_S_BFu17ll { void * v1; short v2; unsigned long long v3:17; };
struct Vp_S_BFu1c { void * v1; short v2; unsigned char v3:1; };
struct Vp_S_BFu1i { void * v1; short v2; unsigned int v3:1; };
struct Vp_S_BFu1ll { void * v1; short v2; unsigned long long v3:1; };
struct Vp_S_BFu1s { void * v1; short v2; unsigned short v3:1; };
struct Vp_S_BFu31i { void * v1; short v2; unsigned int v3:31; };
struct Vp_S_BFu31ll { void * v1; short v2; unsigned long long v3:31; };
struct Vp_S_BFu32i { void * v1; short v2; unsigned int v3:32; };
struct Vp_S_BFu32ll { void * v1; short v2; unsigned long long v3:32; };
struct Vp_S_BFu33 { void * v1; short v2; unsigned long long v3:33; };
struct Vp_S_BFu7c { void * v1; short v2; unsigned char v3:7; };
struct Vp_S_BFu7i { void * v1; short v2; unsigned int v3:7; };
struct Vp_S_BFu7ll { void * v1; short v2; unsigned long long v3:7; };
struct Vp_S_BFu7s { void * v1; short v2; unsigned short v3:7; };
struct Vp_S_BFu8c { void * v1; short v2; unsigned char v3:8; };
struct Vp_S_BFu8i { void * v1; short v2; unsigned int v3:8; };
struct Vp_S_BFu8ll { void * v1; short v2; unsigned long long v3:8; };
struct Vp_S_BFu8s { void * v1; short v2; unsigned short v3:8; };
struct Vp_S_BFu9i { void * v1; short v2; unsigned int v3:9; };
struct Vp_S_BFu9ll { void * v1; short v2; unsigned long long v3:9; };
struct Vp_S_BFu9s { void * v1; short v2; unsigned short v3:9; };
struct Vp_S_C { void * v1; short v2; char v3; };
struct Vp_S_D { void * v1; short v2; double v3; };
struct Vp_S_F { void * v1; short v2; float v3; };
struct Vp_S_I { void * v1; short v2; int v3; };
struct Vp_S_Ip { void * v1; short v2; int * v3; };
struct Vp_S_L { void * v1; short v2; long long v3; };
struct Vp_S_S { void * v1; short v2; short v3; };
struct Vp_S_Uc { void * v1; short v2; unsigned char v3; };
struct Vp_S_Ui { void * v1; short v2; unsigned int v3; };
struct Vp_S_Ul { void * v1; short v2; unsigned long long v3; };
struct Vp_S_Us { void * v1; short v2; unsigned short v3; };
struct Vp_S_Vp { void * v1; short v2; void * v3; };
struct Vp_Uc { void * v1; unsigned char v2; };
struct Vp_Uc_BFu15i { void * v1; unsigned char v2; unsigned int v3:15; };
struct Vp_Uc_BFu15ll { void * v1; unsigned char v2; unsigned long long v3:15; };
struct Vp_Uc_BFu15s { void * v1; unsigned char v2; unsigned short v3:15; };
struct Vp_Uc_BFu16i { void * v1; unsigned char v2; unsigned int v3:16; };
struct Vp_Uc_BFu16ll { void * v1; unsigned char v2; unsigned long long v3:16; };
struct Vp_Uc_BFu16s { void * v1; unsigned char v2; unsigned short v3:16; };
struct Vp_Uc_BFu17i { void * v1; unsigned char v2; unsigned int v3:17; };
struct Vp_Uc_BFu17ll { void * v1; unsigned char v2; unsigned long long v3:17; };
struct Vp_Uc_BFu1c { void * v1; unsigned char v2; unsigned char v3:1; };
struct Vp_Uc_BFu1i { void * v1; unsigned char v2; unsigned int v3:1; };
struct Vp_Uc_BFu1ll { void * v1; unsigned char v2; unsigned long long v3:1; };
struct Vp_Uc_BFu1s { void * v1; unsigned char v2; unsigned short v3:1; };
struct Vp_Uc_BFu31i { void * v1; unsigned char v2; unsigned int v3:31; };
struct Vp_Uc_BFu31ll { void * v1; unsigned char v2; unsigned long long v3:31; };
struct Vp_Uc_BFu32i { void * v1; unsigned char v2; unsigned int v3:32; };
struct Vp_Uc_BFu32ll { void * v1; unsigned char v2; unsigned long long v3:32; };
struct Vp_Uc_BFu33 { void * v1; unsigned char v2; unsigned long long v3:33; };
struct Vp_Uc_BFu7c { void * v1; unsigned char v2; unsigned char v3:7; };
struct Vp_Uc_BFu7i { void * v1; unsigned char v2; unsigned int v3:7; };
struct Vp_Uc_BFu7ll { void * v1; unsigned char v2; unsigned long long v3:7; };
struct Vp_Uc_BFu7s { void * v1; unsigned char v2; unsigned short v3:7; };
struct Vp_Uc_BFu8c { void * v1; unsigned char v2; unsigned char v3:8; };
struct Vp_Uc_BFu8i { void * v1; unsigned char v2; unsigned int v3:8; };
struct Vp_Uc_BFu8ll { void * v1; unsigned char v2; unsigned long long v3:8; };
struct Vp_Uc_BFu8s { void * v1; unsigned char v2; unsigned short v3:8; };
struct Vp_Uc_BFu9i { void * v1; unsigned char v2; unsigned int v3:9; };
struct Vp_Uc_BFu9ll { void * v1; unsigned char v2; unsigned long long v3:9; };
struct Vp_Uc_BFu9s { void * v1; unsigned char v2; unsigned short v3:9; };
struct Vp_Uc_C { void * v1; unsigned char v2; char v3; };
struct Vp_Uc_D { void * v1; unsigned char v2; double v3; };
struct Vp_Uc_F { void * v1; unsigned char v2; float v3; };
struct Vp_Uc_I { void * v1; unsigned char v2; int v3; };
struct Vp_Uc_Ip { void * v1; unsigned char v2; int * v3; };
struct Vp_Uc_L { void * v1; unsigned char v2; long long v3; };
struct Vp_Uc_S { void * v1; unsigned char v2; short v3; };
struct Vp_Uc_Uc { void * v1; unsigned char v2; unsigned char v3; };
struct Vp_Uc_Ui { void * v1; unsigned char v2; unsigned int v3; };
struct Vp_Uc_Ul { void * v1; unsigned char v2; unsigned long long v3; };
struct Vp_Uc_Us { void * v1; unsigned char v2; unsigned short v3; };
struct Vp_Uc_Vp { void * v1; unsigned char v2; void * v3; };
struct Vp_Ui { void * v1; unsigned int v2; };
struct Vp_Ui_BFu15i { void * v1; unsigned int v2; unsigned int v3:15; };
struct Vp_Ui_BFu15ll { void * v1; unsigned int v2; unsigned long long v3:15; };
struct Vp_Ui_BFu15s { void * v1; unsigned int v2; unsigned short v3:15; };
struct Vp_Ui_BFu16i { void * v1; unsigned int v2; unsigned int v3:16; };
struct Vp_Ui_BFu16ll { void * v1; unsigned int v2; unsigned long long v3:16; };
struct Vp_Ui_BFu16s { void * v1; unsigned int v2; unsigned short v3:16; };
struct Vp_Ui_BFu17i { void * v1; unsigned int v2; unsigned int v3:17; };
struct Vp_Ui_BFu17ll { void * v1; unsigned int v2; unsigned long long v3:17; };
struct Vp_Ui_BFu1c { void * v1; unsigned int v2; unsigned char v3:1; };
struct Vp_Ui_BFu1i { void * v1; unsigned int v2; unsigned int v3:1; };
struct Vp_Ui_BFu1ll { void * v1; unsigned int v2; unsigned long long v3:1; };
struct Vp_Ui_BFu1s { void * v1; unsigned int v2; unsigned short v3:1; };
struct Vp_Ui_BFu31i { void * v1; unsigned int v2; unsigned int v3:31; };
struct Vp_Ui_BFu31ll { void * v1; unsigned int v2; unsigned long long v3:31; };
struct Vp_Ui_BFu32i { void * v1; unsigned int v2; unsigned int v3:32; };
struct Vp_Ui_BFu32ll { void * v1; unsigned int v2; unsigned long long v3:32; };
struct Vp_Ui_BFu33 { void * v1; unsigned int v2; unsigned long long v3:33; };
struct Vp_Ui_BFu7c { void * v1; unsigned int v2; unsigned char v3:7; };
struct Vp_Ui_BFu7i { void * v1; unsigned int v2; unsigned int v3:7; };
struct Vp_Ui_BFu7ll { void * v1; unsigned int v2; unsigned long long v3:7; };
struct Vp_Ui_BFu7s { void * v1; unsigned int v2; unsigned short v3:7; };
struct Vp_Ui_BFu8c { void * v1; unsigned int v2; unsigned char v3:8; };
struct Vp_Ui_BFu8i { void * v1; unsigned int v2; unsigned int v3:8; };
struct Vp_Ui_BFu8ll { void * v1; unsigned int v2; unsigned long long v3:8; };
struct Vp_Ui_BFu8s { void * v1; unsigned int v2; unsigned short v3:8; };
struct Vp_Ui_BFu9i { void * v1; unsigned int v2; unsigned int v3:9; };
struct Vp_Ui_BFu9ll { void * v1; unsigned int v2; unsigned long long v3:9; };
struct Vp_Ui_BFu9s { void * v1; unsigned int v2; unsigned short v3:9; };
struct Vp_Ui_C { void * v1; unsigned int v2; char v3; };
struct Vp_Ui_D { void * v1; unsigned int v2; double v3; };
struct Vp_Ui_F { void * v1; unsigned int v2; float v3; };
struct Vp_Ui_I { void * v1; unsigned int v2; int v3; };
struct Vp_Ui_Ip { void * v1; unsigned int v2; int * v3; };
struct Vp_Ui_L { void * v1; unsigned int v2; long long v3; };
struct Vp_Ui_S { void * v1; unsigned int v2; short v3; };
struct Vp_Ui_Uc { void * v1; unsigned int v2; unsigned char v3; };
struct Vp_Ui_Ui { void * v1; unsigned int v2; unsigned int v3; };
struct Vp_Ui_Ul { void * v1; unsigned int v2; unsigned long long v3; };
struct Vp_Ui_Us { void * v1; unsigned int v2; unsigned short v3; };
struct Vp_Ui_Vp { void * v1; unsigned int v2; void * v3; };
struct Vp_Ul { void * v1; unsigned long long v2; };
struct Vp_Ul_BFu15i { void * v1; unsigned long long v2; unsigned int v3:15; };
struct Vp_Ul_BFu15ll { void * v1; unsigned long long v2; unsigned long long v3:15; };
struct Vp_Ul_BFu15s { void * v1; unsigned long long v2; unsigned short v3:15; };
struct Vp_Ul_BFu16i { void * v1; unsigned long long v2; unsigned int v3:16; };
struct Vp_Ul_BFu16ll { void * v1; unsigned long long v2; unsigned long long v3:16; };
struct Vp_Ul_BFu16s { void * v1; unsigned long long v2; unsigned short v3:16; };
struct Vp_Ul_BFu17i { void * v1; unsigned long long v2; unsigned int v3:17; };
struct Vp_Ul_BFu17ll { void * v1; unsigned long long v2; unsigned long long v3:17; };
struct Vp_Ul_BFu1c { void * v1; unsigned long long v2; unsigned char v3:1; };
struct Vp_Ul_BFu1i { void * v1; unsigned long long v2; unsigned int v3:1; };
struct Vp_Ul_BFu1ll { void * v1; unsigned long long v2; unsigned long long v3:1; };
struct Vp_Ul_BFu1s { void * v1; unsigned long long v2; unsigned short v3:1; };
struct Vp_Ul_BFu31i { void * v1; unsigned long long v2; unsigned int v3:31; };
struct Vp_Ul_BFu31ll { void * v1; unsigned long long v2; unsigned long long v3:31; };
struct Vp_Ul_BFu32i { void * v1; unsigned long long v2; unsigned int v3:32; };
struct Vp_Ul_BFu32ll { void * v1; unsigned long long v2; unsigned long long v3:32; };
struct Vp_Ul_BFu33 { void * v1; unsigned long long v2; unsigned long long v3:33; };
struct Vp_Ul_BFu7c { void * v1; unsigned long long v2; unsigned char v3:7; };
struct Vp_Ul_BFu7i { void * v1; unsigned long long v2; unsigned int v3:7; };
struct Vp_Ul_BFu7ll { void * v1; unsigned long long v2; unsigned long long v3:7; };
struct Vp_Ul_BFu7s { void * v1; unsigned long long v2; unsigned short v3:7; };
struct Vp_Ul_BFu8c { void * v1; unsigned long long v2; unsigned char v3:8; };
struct Vp_Ul_BFu8i { void * v1; unsigned long long v2; unsigned int v3:8; };
struct Vp_Ul_BFu8ll { void * v1; unsigned long long v2; unsigned long long v3:8; };
struct Vp_Ul_BFu8s { void * v1; unsigned long long v2; unsigned short v3:8; };
struct Vp_Ul_BFu9i { void * v1; unsigned long long v2; unsigned int v3:9; };
struct Vp_Ul_BFu9ll { void * v1; unsigned long long v2; unsigned long long v3:9; };
struct Vp_Ul_BFu9s { void * v1; unsigned long long v2; unsigned short v3:9; };
struct Vp_Ul_C { void * v1; unsigned long long v2; char v3; };
struct Vp_Ul_D { void * v1; unsigned long long v2; double v3; };
struct Vp_Ul_F { void * v1; unsigned long long v2; float v3; };
struct Vp_Ul_I { void * v1; unsigned long long v2; int v3; };
struct Vp_Ul_Ip { void * v1; unsigned long long v2; int * v3; };
struct Vp_Ul_L { void * v1; unsigned long long v2; long long v3; };
struct Vp_Ul_S { void * v1; unsigned long long v2; short v3; };
struct Vp_Ul_Uc { void * v1; unsigned long long v2; unsigned char v3; };
struct Vp_Ul_Ui { void * v1; unsigned long long v2; unsigned int v3; };
struct Vp_Ul_Ul { void * v1; unsigned long long v2; unsigned long long v3; };
struct Vp_Ul_Us { void * v1; unsigned long long v2; unsigned short v3; };
struct Vp_Ul_Vp { void * v1; unsigned long long v2; void * v3; };
struct Vp_Us { void * v1; unsigned short v2; };
struct Vp_Us_BFu15i { void * v1; unsigned short v2; unsigned int v3:15; };
struct Vp_Us_BFu15ll { void * v1; unsigned short v2; unsigned long long v3:15; };
struct Vp_Us_BFu15s { void * v1; unsigned short v2; unsigned short v3:15; };
struct Vp_Us_BFu16i { void * v1; unsigned short v2; unsigned int v3:16; };
struct Vp_Us_BFu16ll { void * v1; unsigned short v2; unsigned long long v3:16; };
struct Vp_Us_BFu16s { void * v1; unsigned short v2; unsigned short v3:16; };
struct Vp_Us_BFu17i { void * v1; unsigned short v2; unsigned int v3:17; };
struct Vp_Us_BFu17ll { void * v1; unsigned short v2; unsigned long long v3:17; };
struct Vp_Us_BFu1c { void * v1; unsigned short v2; unsigned char v3:1; };
struct Vp_Us_BFu1i { void * v1; unsigned short v2; unsigned int v3:1; };
struct Vp_Us_BFu1ll { void * v1; unsigned short v2; unsigned long long v3:1; };
struct Vp_Us_BFu1s { void * v1; unsigned short v2; unsigned short v3:1; };
struct Vp_Us_BFu31i { void * v1; unsigned short v2; unsigned int v3:31; };
struct Vp_Us_BFu31ll { void * v1; unsigned short v2; unsigned long long v3:31; };
struct Vp_Us_BFu32i { void * v1; unsigned short v2; unsigned int v3:32; };
struct Vp_Us_BFu32ll { void * v1; unsigned short v2; unsigned long long v3:32; };
struct Vp_Us_BFu33 { void * v1; unsigned short v2; unsigned long long v3:33; };
struct Vp_Us_BFu7c { void * v1; unsigned short v2; unsigned char v3:7; };
struct Vp_Us_BFu7i { void * v1; unsigned short v2; unsigned int v3:7; };
struct Vp_Us_BFu7ll { void * v1; unsigned short v2; unsigned long long v3:7; };
struct Vp_Us_BFu7s { void * v1; unsigned short v2; unsigned short v3:7; };
struct Vp_Us_BFu8c { void * v1; unsigned short v2; unsigned char v3:8; };
struct Vp_Us_BFu8i { void * v1; unsigned short v2; unsigned int v3:8; };
struct Vp_Us_BFu8ll { void * v1; unsigned short v2; unsigned long long v3:8; };
struct Vp_Us_BFu8s { void * v1; unsigned short v2; unsigned short v3:8; };
struct Vp_Us_BFu9i { void * v1; unsigned short v2; unsigned int v3:9; };
struct Vp_Us_BFu9ll { void * v1; unsigned short v2; unsigned long long v3:9; };
struct Vp_Us_BFu9s { void * v1; unsigned short v2; unsigned short v3:9; };
struct Vp_Us_C { void * v1; unsigned short v2; char v3; };
struct Vp_Us_D { void * v1; unsigned short v2; double v3; };
struct Vp_Us_F { void * v1; unsigned short v2; float v3; };
struct Vp_Us_I { void * v1; unsigned short v2; int v3; };
struct Vp_Us_Ip { void * v1; unsigned short v2; int * v3; };
struct Vp_Us_L { void * v1; unsigned short v2; long long v3; };
struct Vp_Us_S { void * v1; unsigned short v2; short v3; };
struct Vp_Us_Uc { void * v1; unsigned short v2; unsigned char v3; };
struct Vp_Us_Ui { void * v1; unsigned short v2; unsigned int v3; };
struct Vp_Us_Ul { void * v1; unsigned short v2; unsigned long long v3; };
struct Vp_Us_Us { void * v1; unsigned short v2; unsigned short v3; };
struct Vp_Us_Vp { void * v1; unsigned short v2; void * v3; };
struct Vp_Vp { void * v1; void * v2; };
struct Vp_Vp_BFu15i { void * v1; void * v2; unsigned int v3:15; };
struct Vp_Vp_BFu15ll { void * v1; void * v2; unsigned long long v3:15; };
struct Vp_Vp_BFu15s { void * v1; void * v2; unsigned short v3:15; };
struct Vp_Vp_BFu16i { void * v1; void * v2; unsigned int v3:16; };
struct Vp_Vp_BFu16ll { void * v1; void * v2; unsigned long long v3:16; };
struct Vp_Vp_BFu16s { void * v1; void * v2; unsigned short v3:16; };
struct Vp_Vp_BFu17i { void * v1; void * v2; unsigned int v3:17; };
struct Vp_Vp_BFu17ll { void * v1; void * v2; unsigned long long v3:17; };
struct Vp_Vp_BFu1c { void * v1; void * v2; unsigned char v3:1; };
struct Vp_Vp_BFu1i { void * v1; void * v2; unsigned int v3:1; };
struct Vp_Vp_BFu1ll { void * v1; void * v2; unsigned long long v3:1; };
struct Vp_Vp_BFu1s { void * v1; void * v2; unsigned short v3:1; };
struct Vp_Vp_BFu31i { void * v1; void * v2; unsigned int v3:31; };
struct Vp_Vp_BFu31ll { void * v1; void * v2; unsigned long long v3:31; };
struct Vp_Vp_BFu32i { void * v1; void * v2; unsigned int v3:32; };
struct Vp_Vp_BFu32ll { void * v1; void * v2; unsigned long long v3:32; };
struct Vp_Vp_BFu33 { void * v1; void * v2; unsigned long long v3:33; };
struct Vp_Vp_BFu7c { void * v1; void * v2; unsigned char v3:7; };
struct Vp_Vp_BFu7i { void * v1; void * v2; unsigned int v3:7; };
struct Vp_Vp_BFu7ll { void * v1; void * v2; unsigned long long v3:7; };
struct Vp_Vp_BFu7s { void * v1; void * v2; unsigned short v3:7; };
struct Vp_Vp_BFu8c { void * v1; void * v2; unsigned char v3:8; };
struct Vp_Vp_BFu8i { void * v1; void * v2; unsigned int v3:8; };
struct Vp_Vp_BFu8ll { void * v1; void * v2; unsigned long long v3:8; };
struct Vp_Vp_BFu8s { void * v1; void * v2; unsigned short v3:8; };
struct Vp_Vp_BFu9i { void * v1; void * v2; unsigned int v3:9; };
struct Vp_Vp_BFu9ll { void * v1; void * v2; unsigned long long v3:9; };
struct Vp_Vp_BFu9s { void * v1; void * v2; unsigned short v3:9; };
struct Vp_Vp_C { void * v1; void * v2; char v3; };
struct Vp_Vp_D { void * v1; void * v2; double v3; };
struct Vp_Vp_F { void * v1; void * v2; float v3; };
struct Vp_Vp_I { void * v1; void * v2; int v3; };
struct Vp_Vp_Ip { void * v1; void * v2; int * v3; };
struct Vp_Vp_L { void * v1; void * v2; long long v3; };
struct Vp_Vp_S { void * v1; void * v2; short v3; };
struct Vp_Vp_Uc { void * v1; void * v2; unsigned char v3; };
struct Vp_Vp_Ui { void * v1; void * v2; unsigned int v3; };
struct Vp_Vp_Ul { void * v1; void * v2; unsigned long long v3; };
struct Vp_Vp_Us { void * v1; void * v2; unsigned short v3; };
struct Vp_Vp_Vp { void * v1; void * v2; void * v3; };


static void Test_Us_F_Us()
{
  {
    init_simple_test("Us_F_Us");
    STRUCT_IF_C Us_F_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_F_Us)");
    check_field_offset(lv, v1, 0, "Us_F_Us.v1");
    check_field_offset(lv, v2, 2, "Us_F_Us.v2");
    check_field_offset(lv, v3, 6, "Us_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_F_Us, Us_F_Us)
//============================================================================



static void Test_Us_F_Vp()
{
  {
    init_simple_test("Us_F_Vp");
    STRUCT_IF_C Us_F_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_F_Vp)");
    check_field_offset(lv, v1, 0, "Us_F_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_F_Vp.v2");
    check_field_offset(lv, v3, 6, "Us_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_F_Vp, Us_F_Vp)
//============================================================================



static void Test_Us_I()
{
  {
    init_simple_test("Us_I");
    STRUCT_IF_C Us_I lv;
    check2(sizeof(lv), 6, "sizeof(Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I)");
    check_field_offset(lv, v1, 0, "Us_I.v1");
    check_field_offset(lv, v2, 2, "Us_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I, Us_I)
//============================================================================



static void Test_Us_I_BFu15i()
{
  {
    init_simple_test("Us_I_BFu15i");
    static STRUCT_IF_C Us_I_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_I_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu15i, Us_I_BFu15i)
//============================================================================



static void Test_Us_I_BFu15ll()
{
  {
    init_simple_test("Us_I_BFu15ll");
    static STRUCT_IF_C Us_I_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_I_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu15ll, Us_I_BFu15ll)
//============================================================================



static void Test_Us_I_BFu15s()
{
  {
    init_simple_test("Us_I_BFu15s");
    static STRUCT_IF_C Us_I_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_I_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_I_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu15s, Us_I_BFu15s)
//============================================================================



static void Test_Us_I_BFu16i()
{
  {
    init_simple_test("Us_I_BFu16i");
    static STRUCT_IF_C Us_I_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_I_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu16i, Us_I_BFu16i)
//============================================================================



static void Test_Us_I_BFu16ll()
{
  {
    init_simple_test("Us_I_BFu16ll");
    static STRUCT_IF_C Us_I_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_I_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu16ll, Us_I_BFu16ll)
//============================================================================



static void Test_Us_I_BFu16s()
{
  {
    init_simple_test("Us_I_BFu16s");
    static STRUCT_IF_C Us_I_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_I_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_I_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu16s, Us_I_BFu16s)
//============================================================================



static void Test_Us_I_BFu17i()
{
  {
    init_simple_test("Us_I_BFu17i");
    static STRUCT_IF_C Us_I_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(Us_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "Us_I_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "Us_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu17i, Us_I_BFu17i)
//============================================================================



static void Test_Us_I_BFu17ll()
{
  {
    init_simple_test("Us_I_BFu17ll");
    static STRUCT_IF_C Us_I_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(Us_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "Us_I_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "Us_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu17ll, Us_I_BFu17ll)
//============================================================================



static void Test_Us_I_BFu1c()
{
  {
    init_simple_test("Us_I_BFu1c");
    static STRUCT_IF_C Us_I_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_I_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu1c, Us_I_BFu1c)
//============================================================================



static void Test_Us_I_BFu1i()
{
  {
    init_simple_test("Us_I_BFu1i");
    static STRUCT_IF_C Us_I_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu1i, Us_I_BFu1i)
//============================================================================



static void Test_Us_I_BFu1ll()
{
  {
    init_simple_test("Us_I_BFu1ll");
    static STRUCT_IF_C Us_I_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu1ll, Us_I_BFu1ll)
//============================================================================



static void Test_Us_I_BFu1s()
{
  {
    init_simple_test("Us_I_BFu1s");
    static STRUCT_IF_C Us_I_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_I_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu1s, Us_I_BFu1s)
//============================================================================



static void Test_Us_I_BFu31i()
{
  {
    init_simple_test("Us_I_BFu31i");
    static STRUCT_IF_C Us_I_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "Us_I_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "Us_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu31i, Us_I_BFu31i)
//============================================================================



static void Test_Us_I_BFu31ll()
{
  {
    init_simple_test("Us_I_BFu31ll");
    static STRUCT_IF_C Us_I_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "Us_I_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "Us_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu31ll, Us_I_BFu31ll)
//============================================================================



static void Test_Us_I_BFu32i()
{
  {
    init_simple_test("Us_I_BFu32i");
    static STRUCT_IF_C Us_I_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "Us_I_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "Us_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu32i, Us_I_BFu32i)
//============================================================================



static void Test_Us_I_BFu32ll()
{
  {
    init_simple_test("Us_I_BFu32ll");
    static STRUCT_IF_C Us_I_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "Us_I_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "Us_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu32ll, Us_I_BFu32ll)
//============================================================================



static void Test_Us_I_BFu33()
{
  {
    init_simple_test("Us_I_BFu33");
    static STRUCT_IF_C Us_I_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(Us_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu33)");
    check_field_offset(lv, v1, 0, "Us_I_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "Us_I_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "Us_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu33, Us_I_BFu33)
//============================================================================



static void Test_Us_I_BFu7c()
{
  {
    init_simple_test("Us_I_BFu7c");
    static STRUCT_IF_C Us_I_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_I_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_I_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu7c, Us_I_BFu7c)
//============================================================================



static void Test_Us_I_BFu7i()
{
  {
    init_simple_test("Us_I_BFu7i");
    static STRUCT_IF_C Us_I_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_I_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu7i, Us_I_BFu7i)
//============================================================================



static void Test_Us_I_BFu7ll()
{
  {
    init_simple_test("Us_I_BFu7ll");
    static STRUCT_IF_C Us_I_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_I_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu7ll, Us_I_BFu7ll)
//============================================================================



static void Test_Us_I_BFu7s()
{
  {
    init_simple_test("Us_I_BFu7s");
    static STRUCT_IF_C Us_I_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_I_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_I_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu7s, Us_I_BFu7s)
//============================================================================



static void Test_Us_I_BFu8c()
{
  {
    init_simple_test("Us_I_BFu8c");
    static STRUCT_IF_C Us_I_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_I_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_I_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu8c, Us_I_BFu8c)
//============================================================================



static void Test_Us_I_BFu8i()
{
  {
    init_simple_test("Us_I_BFu8i");
    static STRUCT_IF_C Us_I_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_I_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu8i, Us_I_BFu8i)
//============================================================================



static void Test_Us_I_BFu8ll()
{
  {
    init_simple_test("Us_I_BFu8ll");
    static STRUCT_IF_C Us_I_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_I_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu8ll, Us_I_BFu8ll)
//============================================================================



static void Test_Us_I_BFu8s()
{
  {
    init_simple_test("Us_I_BFu8s");
    static STRUCT_IF_C Us_I_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_I_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_I_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu8s, Us_I_BFu8s)
//============================================================================



static void Test_Us_I_BFu9i()
{
  {
    init_simple_test("Us_I_BFu9i");
    static STRUCT_IF_C Us_I_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_I_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_I_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu9i, Us_I_BFu9i)
//============================================================================



static void Test_Us_I_BFu9ll()
{
  {
    init_simple_test("Us_I_BFu9ll");
    static STRUCT_IF_C Us_I_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_I_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_I_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu9ll, Us_I_BFu9ll)
//============================================================================



static void Test_Us_I_BFu9s()
{
  {
    init_simple_test("Us_I_BFu9s");
    static STRUCT_IF_C Us_I_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_I_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_I_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_BFu9s, Us_I_BFu9s)
//============================================================================



static void Test_Us_I_C()
{
  {
    init_simple_test("Us_I_C");
    STRUCT_IF_C Us_I_C lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_C)");
    check_field_offset(lv, v1, 0, "Us_I_C.v1");
    check_field_offset(lv, v2, 2, "Us_I_C.v2");
    check_field_offset(lv, v3, 6, "Us_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_C, Us_I_C)
//============================================================================



static void Test_Us_I_D()
{
  {
    init_simple_test("Us_I_D");
    STRUCT_IF_C Us_I_D lv;
    check2(sizeof(lv), 14, "sizeof(Us_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_D)");
    check_field_offset(lv, v1, 0, "Us_I_D.v1");
    check_field_offset(lv, v2, 2, "Us_I_D.v2");
    check_field_offset(lv, v3, 6, "Us_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_D, Us_I_D)
//============================================================================



static void Test_Us_I_F()
{
  {
    init_simple_test("Us_I_F");
    STRUCT_IF_C Us_I_F lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_F)");
    check_field_offset(lv, v1, 0, "Us_I_F.v1");
    check_field_offset(lv, v2, 2, "Us_I_F.v2");
    check_field_offset(lv, v3, 6, "Us_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_F, Us_I_F)
//============================================================================



static void Test_Us_I_I()
{
  {
    init_simple_test("Us_I_I");
    STRUCT_IF_C Us_I_I lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_I)");
    check_field_offset(lv, v1, 0, "Us_I_I.v1");
    check_field_offset(lv, v2, 2, "Us_I_I.v2");
    check_field_offset(lv, v3, 6, "Us_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_I, Us_I_I)
//============================================================================



static void Test_Us_I_Ip()
{
  {
    init_simple_test("Us_I_Ip");
    STRUCT_IF_C Us_I_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_Ip)");
    check_field_offset(lv, v1, 0, "Us_I_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_I_Ip.v2");
    check_field_offset(lv, v3, 6, "Us_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_Ip, Us_I_Ip)
//============================================================================



static void Test_Us_I_L()
{
  {
    init_simple_test("Us_I_L");
    STRUCT_IF_C Us_I_L lv;
    check2(sizeof(lv), 14, "sizeof(Us_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_L)");
    check_field_offset(lv, v1, 0, "Us_I_L.v1");
    check_field_offset(lv, v2, 2, "Us_I_L.v2");
    check_field_offset(lv, v3, 6, "Us_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_L, Us_I_L)
//============================================================================



static void Test_Us_I_S()
{
  {
    init_simple_test("Us_I_S");
    STRUCT_IF_C Us_I_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_S)");
    check_field_offset(lv, v1, 0, "Us_I_S.v1");
    check_field_offset(lv, v2, 2, "Us_I_S.v2");
    check_field_offset(lv, v3, 6, "Us_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_S, Us_I_S)
//============================================================================



static void Test_Us_I_Uc()
{
  {
    init_simple_test("Us_I_Uc");
    STRUCT_IF_C Us_I_Uc lv;
    check2(sizeof(lv), 7, "sizeof(Us_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_Uc)");
    check_field_offset(lv, v1, 0, "Us_I_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_I_Uc.v2");
    check_field_offset(lv, v3, 6, "Us_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_Uc, Us_I_Uc)
//============================================================================



static void Test_Us_I_Ui()
{
  {
    init_simple_test("Us_I_Ui");
    STRUCT_IF_C Us_I_Ui lv;
    check2(sizeof(lv), 10, "sizeof(Us_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_Ui)");
    check_field_offset(lv, v1, 0, "Us_I_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_I_Ui.v2");
    check_field_offset(lv, v3, 6, "Us_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_Ui, Us_I_Ui)
//============================================================================



static void Test_Us_I_Ul()
{
  {
    init_simple_test("Us_I_Ul");
    STRUCT_IF_C Us_I_Ul lv;
    check2(sizeof(lv), 14, "sizeof(Us_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_Ul)");
    check_field_offset(lv, v1, 0, "Us_I_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_I_Ul.v2");
    check_field_offset(lv, v3, 6, "Us_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_Ul, Us_I_Ul)
//============================================================================



static void Test_Us_I_Us()
{
  {
    init_simple_test("Us_I_Us");
    STRUCT_IF_C Us_I_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_Us)");
    check_field_offset(lv, v1, 0, "Us_I_Us.v1");
    check_field_offset(lv, v2, 2, "Us_I_Us.v2");
    check_field_offset(lv, v3, 6, "Us_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_Us, Us_I_Us)
//============================================================================



static void Test_Us_I_Vp()
{
  {
    init_simple_test("Us_I_Vp");
    STRUCT_IF_C Us_I_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_I_Vp)");
    check_field_offset(lv, v1, 0, "Us_I_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_I_Vp.v2");
    check_field_offset(lv, v3, 6, "Us_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_I_Vp, Us_I_Vp)
//============================================================================



static void Test_Us_Ip()
{
  {
    init_simple_test("Us_Ip");
    STRUCT_IF_C Us_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip)");
    check_field_offset(lv, v1, 0, "Us_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip, Us_Ip)
//============================================================================



static void Test_Us_Ip_BFu15i()
{
  {
    init_simple_test("Us_Ip_BFu15i");
    static STRUCT_IF_C Us_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Us_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Us_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu15i, Us_Ip_BFu15i)
//============================================================================



static void Test_Us_Ip_BFu15ll()
{
  {
    init_simple_test("Us_Ip_BFu15ll");
    static STRUCT_IF_C Us_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Us_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Us_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu15ll, Us_Ip_BFu15ll)
//============================================================================



static void Test_Us_Ip_BFu15s()
{
  {
    init_simple_test("Us_Ip_BFu15s");
    static STRUCT_IF_C Us_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Us_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Us_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu15s, Us_Ip_BFu15s)
//============================================================================



static void Test_Us_Ip_BFu16i()
{
  {
    init_simple_test("Us_Ip_BFu16i");
    static STRUCT_IF_C Us_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Us_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Us_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu16i, Us_Ip_BFu16i)
//============================================================================



static void Test_Us_Ip_BFu16ll()
{
  {
    init_simple_test("Us_Ip_BFu16ll");
    static STRUCT_IF_C Us_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Us_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Us_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu16ll, Us_Ip_BFu16ll)
//============================================================================



static void Test_Us_Ip_BFu16s()
{
  {
    init_simple_test("Us_Ip_BFu16s");
    static STRUCT_IF_C Us_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Us_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Us_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu16s, Us_Ip_BFu16s)
//============================================================================



static void Test_Us_Ip_BFu17i()
{
  {
    init_simple_test("Us_Ip_BFu17i");
    static STRUCT_IF_C Us_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Us_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Us_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Us_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu17i, Us_Ip_BFu17i)
//============================================================================



static void Test_Us_Ip_BFu17ll()
{
  {
    init_simple_test("Us_Ip_BFu17ll");
    static STRUCT_IF_C Us_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Us_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Us_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Us_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu17ll, Us_Ip_BFu17ll)
//============================================================================



static void Test_Us_Ip_BFu1c()
{
  {
    init_simple_test("Us_Ip_BFu1c");
    static STRUCT_IF_C Us_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu1c, Us_Ip_BFu1c)
//============================================================================



static void Test_Us_Ip_BFu1i()
{
  {
    init_simple_test("Us_Ip_BFu1i");
    static STRUCT_IF_C Us_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu1i, Us_Ip_BFu1i)
//============================================================================



static void Test_Us_Ip_BFu1ll()
{
  {
    init_simple_test("Us_Ip_BFu1ll");
    static STRUCT_IF_C Us_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu1ll, Us_Ip_BFu1ll)
//============================================================================



static void Test_Us_Ip_BFu1s()
{
  {
    init_simple_test("Us_Ip_BFu1s");
    static STRUCT_IF_C Us_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu1s, Us_Ip_BFu1s)
//============================================================================



static void Test_Us_Ip_BFu31i()
{
  {
    init_simple_test("Us_Ip_BFu31i");
    static STRUCT_IF_C Us_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Us_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Us_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu31i, Us_Ip_BFu31i)
//============================================================================



static void Test_Us_Ip_BFu31ll()
{
  {
    init_simple_test("Us_Ip_BFu31ll");
    static STRUCT_IF_C Us_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Us_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Us_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu31ll, Us_Ip_BFu31ll)
//============================================================================



static void Test_Us_Ip_BFu32i()
{
  {
    init_simple_test("Us_Ip_BFu32i");
    static STRUCT_IF_C Us_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Us_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Us_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu32i, Us_Ip_BFu32i)
//============================================================================



static void Test_Us_Ip_BFu32ll()
{
  {
    init_simple_test("Us_Ip_BFu32ll");
    static STRUCT_IF_C Us_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Us_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Us_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu32ll, Us_Ip_BFu32ll)
//============================================================================



static void Test_Us_Ip_BFu33()
{
  {
    init_simple_test("Us_Ip_BFu33");
    static STRUCT_IF_C Us_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Us_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Us_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Us_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu33, Us_Ip_BFu33)
//============================================================================



static void Test_Us_Ip_BFu7c()
{
  {
    init_simple_test("Us_Ip_BFu7c");
    static STRUCT_IF_C Us_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu7c, Us_Ip_BFu7c)
//============================================================================



static void Test_Us_Ip_BFu7i()
{
  {
    init_simple_test("Us_Ip_BFu7i");
    static STRUCT_IF_C Us_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu7i, Us_Ip_BFu7i)
//============================================================================



static void Test_Us_Ip_BFu7ll()
{
  {
    init_simple_test("Us_Ip_BFu7ll");
    static STRUCT_IF_C Us_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu7ll, Us_Ip_BFu7ll)
//============================================================================



static void Test_Us_Ip_BFu7s()
{
  {
    init_simple_test("Us_Ip_BFu7s");
    static STRUCT_IF_C Us_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu7s, Us_Ip_BFu7s)
//============================================================================



static void Test_Us_Ip_BFu8c()
{
  {
    init_simple_test("Us_Ip_BFu8c");
    static STRUCT_IF_C Us_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu8c, Us_Ip_BFu8c)
//============================================================================



static void Test_Us_Ip_BFu8i()
{
  {
    init_simple_test("Us_Ip_BFu8i");
    static STRUCT_IF_C Us_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu8i, Us_Ip_BFu8i)
//============================================================================



static void Test_Us_Ip_BFu8ll()
{
  {
    init_simple_test("Us_Ip_BFu8ll");
    static STRUCT_IF_C Us_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu8ll, Us_Ip_BFu8ll)
//============================================================================



static void Test_Us_Ip_BFu8s()
{
  {
    init_simple_test("Us_Ip_BFu8s");
    static STRUCT_IF_C Us_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu8s, Us_Ip_BFu8s)
//============================================================================



static void Test_Us_Ip_BFu9i()
{
  {
    init_simple_test("Us_Ip_BFu9i");
    static STRUCT_IF_C Us_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Us_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Us_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu9i, Us_Ip_BFu9i)
//============================================================================



static void Test_Us_Ip_BFu9ll()
{
  {
    init_simple_test("Us_Ip_BFu9ll");
    static STRUCT_IF_C Us_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Us_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Us_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu9ll, Us_Ip_BFu9ll)
//============================================================================



static void Test_Us_Ip_BFu9s()
{
  {
    init_simple_test("Us_Ip_BFu9s");
    static STRUCT_IF_C Us_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Us_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Us_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_BFu9s, Us_Ip_BFu9s)
//============================================================================



static void Test_Us_Ip_C()
{
  {
    init_simple_test("Us_Ip_C");
    STRUCT_IF_C Us_Ip_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_C)");
    check_field_offset(lv, v1, 0, "Us_Ip_C.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_C, Us_Ip_C)
//============================================================================



static void Test_Us_Ip_D()
{
  {
    init_simple_test("Us_Ip_D");
    STRUCT_IF_C Us_Ip_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_D)");
    check_field_offset(lv, v1, 0, "Us_Ip_D.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_D, Us_Ip_D)
//============================================================================



static void Test_Us_Ip_F()
{
  {
    init_simple_test("Us_Ip_F");
    STRUCT_IF_C Us_Ip_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_F)");
    check_field_offset(lv, v1, 0, "Us_Ip_F.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_F, Us_Ip_F)
//============================================================================



static void Test_Us_Ip_I()
{
  {
    init_simple_test("Us_Ip_I");
    STRUCT_IF_C Us_Ip_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_I)");
    check_field_offset(lv, v1, 0, "Us_Ip_I.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_I, Us_Ip_I)
//============================================================================



static void Test_Us_Ip_Ip()
{
  {
    init_simple_test("Us_Ip_Ip");
    STRUCT_IF_C Us_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Us_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_Ip)");
    check_field_offset(lv, v1, 0, "Us_Ip_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_Ip, Us_Ip_Ip)
//============================================================================



static void Test_Us_Ip_L()
{
  {
    init_simple_test("Us_Ip_L");
    STRUCT_IF_C Us_Ip_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_L)");
    check_field_offset(lv, v1, 0, "Us_Ip_L.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_L, Us_Ip_L)
//============================================================================



static void Test_Us_Ip_S()
{
  {
    init_simple_test("Us_Ip_S");
    STRUCT_IF_C Us_Ip_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_S)");
    check_field_offset(lv, v1, 0, "Us_Ip_S.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_S, Us_Ip_S)
//============================================================================



static void Test_Us_Ip_Uc()
{
  {
    init_simple_test("Us_Ip_Uc");
    STRUCT_IF_C Us_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_Uc)");
    check_field_offset(lv, v1, 0, "Us_Ip_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_Uc, Us_Ip_Uc)
//============================================================================



static void Test_Us_Ip_Ui()
{
  {
    init_simple_test("Us_Ip_Ui");
    STRUCT_IF_C Us_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_Ui)");
    check_field_offset(lv, v1, 0, "Us_Ip_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_Ui, Us_Ip_Ui)
//============================================================================



static void Test_Us_Ip_Ul()
{
  {
    init_simple_test("Us_Ip_Ul");
    STRUCT_IF_C Us_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_Ul)");
    check_field_offset(lv, v1, 0, "Us_Ip_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_Ul, Us_Ip_Ul)
//============================================================================



static void Test_Us_Ip_Us()
{
  {
    init_simple_test("Us_Ip_Us");
    STRUCT_IF_C Us_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_Us)");
    check_field_offset(lv, v1, 0, "Us_Ip_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_Us, Us_Ip_Us)
//============================================================================



static void Test_Us_Ip_Vp()
{
  {
    init_simple_test("Us_Ip_Vp");
    STRUCT_IF_C Us_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Us_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ip_Vp)");
    check_field_offset(lv, v1, 0, "Us_Ip_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ip_Vp, Us_Ip_Vp)
//============================================================================



static void Test_Us_L()
{
  {
    init_simple_test("Us_L");
    STRUCT_IF_C Us_L lv;
    check2(sizeof(lv), 10, "sizeof(Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L)");
    check_field_offset(lv, v1, 0, "Us_L.v1");
    check_field_offset(lv, v2, 2, "Us_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L, Us_L)
//============================================================================



static void Test_Us_L_BFu15i()
{
  {
    init_simple_test("Us_L_BFu15i");
    static STRUCT_IF_C Us_L_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Us_L_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Us_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu15i, Us_L_BFu15i)
//============================================================================



static void Test_Us_L_BFu15ll()
{
  {
    init_simple_test("Us_L_BFu15ll");
    static STRUCT_IF_C Us_L_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Us_L_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Us_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu15ll, Us_L_BFu15ll)
//============================================================================



static void Test_Us_L_BFu15s()
{
  {
    init_simple_test("Us_L_BFu15s");
    static STRUCT_IF_C Us_L_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_L_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Us_L_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Us_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu15s, Us_L_BFu15s)
//============================================================================



static void Test_Us_L_BFu16i()
{
  {
    init_simple_test("Us_L_BFu16i");
    static STRUCT_IF_C Us_L_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Us_L_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Us_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu16i, Us_L_BFu16i)
//============================================================================



static void Test_Us_L_BFu16ll()
{
  {
    init_simple_test("Us_L_BFu16ll");
    static STRUCT_IF_C Us_L_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Us_L_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Us_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu16ll, Us_L_BFu16ll)
//============================================================================



static void Test_Us_L_BFu16s()
{
  {
    init_simple_test("Us_L_BFu16s");
    static STRUCT_IF_C Us_L_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_L_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Us_L_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Us_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu16s, Us_L_BFu16s)
//============================================================================



static void Test_Us_L_BFu17i()
{
  {
    init_simple_test("Us_L_BFu17i");
    static STRUCT_IF_C Us_L_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Us_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Us_L_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Us_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu17i, Us_L_BFu17i)
//============================================================================



static void Test_Us_L_BFu17ll()
{
  {
    init_simple_test("Us_L_BFu17ll");
    static STRUCT_IF_C Us_L_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Us_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Us_L_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Us_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu17ll, Us_L_BFu17ll)
//============================================================================



static void Test_Us_L_BFu1c()
{
  {
    init_simple_test("Us_L_BFu1c");
    static STRUCT_IF_C Us_L_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_L_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu1c, Us_L_BFu1c)
//============================================================================



static void Test_Us_L_BFu1i()
{
  {
    init_simple_test("Us_L_BFu1i");
    static STRUCT_IF_C Us_L_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu1i, Us_L_BFu1i)
//============================================================================



static void Test_Us_L_BFu1ll()
{
  {
    init_simple_test("Us_L_BFu1ll");
    static STRUCT_IF_C Us_L_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu1ll, Us_L_BFu1ll)
//============================================================================



static void Test_Us_L_BFu1s()
{
  {
    init_simple_test("Us_L_BFu1s");
    static STRUCT_IF_C Us_L_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_L_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu1s, Us_L_BFu1s)
//============================================================================



static void Test_Us_L_BFu31i()
{
  {
    init_simple_test("Us_L_BFu31i");
    static STRUCT_IF_C Us_L_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Us_L_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Us_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu31i, Us_L_BFu31i)
//============================================================================



static void Test_Us_L_BFu31ll()
{
  {
    init_simple_test("Us_L_BFu31ll");
    static STRUCT_IF_C Us_L_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Us_L_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Us_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu31ll, Us_L_BFu31ll)
//============================================================================



static void Test_Us_L_BFu32i()
{
  {
    init_simple_test("Us_L_BFu32i");
    static STRUCT_IF_C Us_L_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Us_L_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Us_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu32i, Us_L_BFu32i)
//============================================================================



static void Test_Us_L_BFu32ll()
{
  {
    init_simple_test("Us_L_BFu32ll");
    static STRUCT_IF_C Us_L_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Us_L_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Us_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu32ll, Us_L_BFu32ll)
//============================================================================



static void Test_Us_L_BFu33()
{
  {
    init_simple_test("Us_L_BFu33");
    static STRUCT_IF_C Us_L_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Us_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu33)");
    check_field_offset(lv, v1, 0, "Us_L_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Us_L_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Us_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu33, Us_L_BFu33)
//============================================================================



static void Test_Us_L_BFu7c()
{
  {
    init_simple_test("Us_L_BFu7c");
    static STRUCT_IF_C Us_L_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_L_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_L_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu7c, Us_L_BFu7c)
//============================================================================



static void Test_Us_L_BFu7i()
{
  {
    init_simple_test("Us_L_BFu7i");
    static STRUCT_IF_C Us_L_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_L_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu7i, Us_L_BFu7i)
//============================================================================



static void Test_Us_L_BFu7ll()
{
  {
    init_simple_test("Us_L_BFu7ll");
    static STRUCT_IF_C Us_L_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_L_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu7ll, Us_L_BFu7ll)
//============================================================================



static void Test_Us_L_BFu7s()
{
  {
    init_simple_test("Us_L_BFu7s");
    static STRUCT_IF_C Us_L_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_L_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_L_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu7s, Us_L_BFu7s)
//============================================================================



static void Test_Us_L_BFu8c()
{
  {
    init_simple_test("Us_L_BFu8c");
    static STRUCT_IF_C Us_L_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_L_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_L_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu8c, Us_L_BFu8c)
//============================================================================



static void Test_Us_L_BFu8i()
{
  {
    init_simple_test("Us_L_BFu8i");
    static STRUCT_IF_C Us_L_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_L_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu8i, Us_L_BFu8i)
//============================================================================



static void Test_Us_L_BFu8ll()
{
  {
    init_simple_test("Us_L_BFu8ll");
    static STRUCT_IF_C Us_L_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_L_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu8ll, Us_L_BFu8ll)
//============================================================================



static void Test_Us_L_BFu8s()
{
  {
    init_simple_test("Us_L_BFu8s");
    static STRUCT_IF_C Us_L_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_L_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_L_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu8s, Us_L_BFu8s)
//============================================================================



static void Test_Us_L_BFu9i()
{
  {
    init_simple_test("Us_L_BFu9i");
    static STRUCT_IF_C Us_L_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_L_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Us_L_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Us_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu9i, Us_L_BFu9i)
//============================================================================



static void Test_Us_L_BFu9ll()
{
  {
    init_simple_test("Us_L_BFu9ll");
    static STRUCT_IF_C Us_L_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_L_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Us_L_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Us_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu9ll, Us_L_BFu9ll)
//============================================================================



static void Test_Us_L_BFu9s()
{
  {
    init_simple_test("Us_L_BFu9s");
    static STRUCT_IF_C Us_L_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_L_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Us_L_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Us_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_BFu9s, Us_L_BFu9s)
//============================================================================



static void Test_Us_L_C()
{
  {
    init_simple_test("Us_L_C");
    STRUCT_IF_C Us_L_C lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_C)");
    check_field_offset(lv, v1, 0, "Us_L_C.v1");
    check_field_offset(lv, v2, 2, "Us_L_C.v2");
    check_field_offset(lv, v3, 10, "Us_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_C, Us_L_C)
//============================================================================



static void Test_Us_L_D()
{
  {
    init_simple_test("Us_L_D");
    STRUCT_IF_C Us_L_D lv;
    check2(sizeof(lv), 18, "sizeof(Us_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_D)");
    check_field_offset(lv, v1, 0, "Us_L_D.v1");
    check_field_offset(lv, v2, 2, "Us_L_D.v2");
    check_field_offset(lv, v3, 10, "Us_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_D, Us_L_D)
//============================================================================



static void Test_Us_L_F()
{
  {
    init_simple_test("Us_L_F");
    STRUCT_IF_C Us_L_F lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_F)");
    check_field_offset(lv, v1, 0, "Us_L_F.v1");
    check_field_offset(lv, v2, 2, "Us_L_F.v2");
    check_field_offset(lv, v3, 10, "Us_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_F, Us_L_F)
//============================================================================



static void Test_Us_L_I()
{
  {
    init_simple_test("Us_L_I");
    STRUCT_IF_C Us_L_I lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_I)");
    check_field_offset(lv, v1, 0, "Us_L_I.v1");
    check_field_offset(lv, v2, 2, "Us_L_I.v2");
    check_field_offset(lv, v3, 10, "Us_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_I, Us_L_I)
//============================================================================



static void Test_Us_L_Ip()
{
  {
    init_simple_test("Us_L_Ip");
    STRUCT_IF_C Us_L_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_Ip)");
    check_field_offset(lv, v1, 0, "Us_L_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_L_Ip.v2");
    check_field_offset(lv, v3, 10, "Us_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_Ip, Us_L_Ip)
//============================================================================



static void Test_Us_L_L()
{
  {
    init_simple_test("Us_L_L");
    STRUCT_IF_C Us_L_L lv;
    check2(sizeof(lv), 18, "sizeof(Us_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_L)");
    check_field_offset(lv, v1, 0, "Us_L_L.v1");
    check_field_offset(lv, v2, 2, "Us_L_L.v2");
    check_field_offset(lv, v3, 10, "Us_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_L, Us_L_L)
//============================================================================



static void Test_Us_L_S()
{
  {
    init_simple_test("Us_L_S");
    STRUCT_IF_C Us_L_S lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_S)");
    check_field_offset(lv, v1, 0, "Us_L_S.v1");
    check_field_offset(lv, v2, 2, "Us_L_S.v2");
    check_field_offset(lv, v3, 10, "Us_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_S, Us_L_S)
//============================================================================



static void Test_Us_L_Uc()
{
  {
    init_simple_test("Us_L_Uc");
    STRUCT_IF_C Us_L_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Us_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_Uc)");
    check_field_offset(lv, v1, 0, "Us_L_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_L_Uc.v2");
    check_field_offset(lv, v3, 10, "Us_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_Uc, Us_L_Uc)
//============================================================================



static void Test_Us_L_Ui()
{
  {
    init_simple_test("Us_L_Ui");
    STRUCT_IF_C Us_L_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Us_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_Ui)");
    check_field_offset(lv, v1, 0, "Us_L_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_L_Ui.v2");
    check_field_offset(lv, v3, 10, "Us_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_Ui, Us_L_Ui)
//============================================================================



static void Test_Us_L_Ul()
{
  {
    init_simple_test("Us_L_Ul");
    STRUCT_IF_C Us_L_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Us_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_Ul)");
    check_field_offset(lv, v1, 0, "Us_L_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_L_Ul.v2");
    check_field_offset(lv, v3, 10, "Us_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_Ul, Us_L_Ul)
//============================================================================



static void Test_Us_L_Us()
{
  {
    init_simple_test("Us_L_Us");
    STRUCT_IF_C Us_L_Us lv;
    check2(sizeof(lv), 12, "sizeof(Us_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_Us)");
    check_field_offset(lv, v1, 0, "Us_L_Us.v1");
    check_field_offset(lv, v2, 2, "Us_L_Us.v2");
    check_field_offset(lv, v3, 10, "Us_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_Us, Us_L_Us)
//============================================================================



static void Test_Us_L_Vp()
{
  {
    init_simple_test("Us_L_Vp");
    STRUCT_IF_C Us_L_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_L_Vp)");
    check_field_offset(lv, v1, 0, "Us_L_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_L_Vp.v2");
    check_field_offset(lv, v3, 10, "Us_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_L_Vp, Us_L_Vp)
//============================================================================



static void Test_Us_S()
{
  {
    init_simple_test("Us_S");
    STRUCT_IF_C Us_S lv;
    check2(sizeof(lv), 4, "sizeof(Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S)");
    check_field_offset(lv, v1, 0, "Us_S.v1");
    check_field_offset(lv, v2, 2, "Us_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S, Us_S)
//============================================================================



static void Test_Us_S_BFu15i()
{
  {
    init_simple_test("Us_S_BFu15i");
    static STRUCT_IF_C Us_S_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_S_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu15i, Us_S_BFu15i)
//============================================================================



static void Test_Us_S_BFu15ll()
{
  {
    init_simple_test("Us_S_BFu15ll");
    static STRUCT_IF_C Us_S_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_S_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu15ll, Us_S_BFu15ll)
//============================================================================



static void Test_Us_S_BFu15s()
{
  {
    init_simple_test("Us_S_BFu15s");
    static STRUCT_IF_C Us_S_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_S_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_S_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu15s, Us_S_BFu15s)
//============================================================================



static void Test_Us_S_BFu16i()
{
  {
    init_simple_test("Us_S_BFu16i");
    static STRUCT_IF_C Us_S_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_S_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu16i, Us_S_BFu16i)
//============================================================================



static void Test_Us_S_BFu16ll()
{
  {
    init_simple_test("Us_S_BFu16ll");
    static STRUCT_IF_C Us_S_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_S_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu16ll, Us_S_BFu16ll)
//============================================================================



static void Test_Us_S_BFu16s()
{
  {
    init_simple_test("Us_S_BFu16s");
    static STRUCT_IF_C Us_S_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_S_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_S_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu16s, Us_S_BFu16s)
//============================================================================



static void Test_Us_S_BFu17i()
{
  {
    init_simple_test("Us_S_BFu17i");
    static STRUCT_IF_C Us_S_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(Us_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_S_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu17i, Us_S_BFu17i)
//============================================================================



static void Test_Us_S_BFu17ll()
{
  {
    init_simple_test("Us_S_BFu17ll");
    static STRUCT_IF_C Us_S_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_S_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu17ll, Us_S_BFu17ll)
//============================================================================



static void Test_Us_S_BFu1c()
{
  {
    init_simple_test("Us_S_BFu1c");
    static STRUCT_IF_C Us_S_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_S_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu1c, Us_S_BFu1c)
//============================================================================



static void Test_Us_S_BFu1i()
{
  {
    init_simple_test("Us_S_BFu1i");
    static STRUCT_IF_C Us_S_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu1i, Us_S_BFu1i)
//============================================================================



static void Test_Us_S_BFu1ll()
{
  {
    init_simple_test("Us_S_BFu1ll");
    static STRUCT_IF_C Us_S_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu1ll, Us_S_BFu1ll)
//============================================================================



static void Test_Us_S_BFu1s()
{
  {
    init_simple_test("Us_S_BFu1s");
    static STRUCT_IF_C Us_S_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_S_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu1s, Us_S_BFu1s)
//============================================================================



static void Test_Us_S_BFu31i()
{
  {
    init_simple_test("Us_S_BFu31i");
    static STRUCT_IF_C Us_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_S_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu31i, Us_S_BFu31i)
//============================================================================



static void Test_Us_S_BFu31ll()
{
  {
    init_simple_test("Us_S_BFu31ll");
    static STRUCT_IF_C Us_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_S_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu31ll, Us_S_BFu31ll)
//============================================================================



static void Test_Us_S_BFu32i()
{
  {
    init_simple_test("Us_S_BFu32i");
    static STRUCT_IF_C Us_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_S_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu32i, Us_S_BFu32i)
//============================================================================



static void Test_Us_S_BFu32ll()
{
  {
    init_simple_test("Us_S_BFu32ll");
    static STRUCT_IF_C Us_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_S_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu32ll, Us_S_BFu32ll)
//============================================================================



static void Test_Us_S_BFu33()
{
  {
    init_simple_test("Us_S_BFu33");
    static STRUCT_IF_C Us_S_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(Us_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu33)");
    check_field_offset(lv, v1, 0, "Us_S_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "Us_S_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "Us_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu33, Us_S_BFu33)
//============================================================================



static void Test_Us_S_BFu7c()
{
  {
    init_simple_test("Us_S_BFu7c");
    static STRUCT_IF_C Us_S_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_S_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_S_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu7c, Us_S_BFu7c)
//============================================================================



static void Test_Us_S_BFu7i()
{
  {
    init_simple_test("Us_S_BFu7i");
    static STRUCT_IF_C Us_S_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_S_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu7i, Us_S_BFu7i)
//============================================================================



static void Test_Us_S_BFu7ll()
{
  {
    init_simple_test("Us_S_BFu7ll");
    static STRUCT_IF_C Us_S_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_S_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu7ll, Us_S_BFu7ll)
//============================================================================



static void Test_Us_S_BFu7s()
{
  {
    init_simple_test("Us_S_BFu7s");
    static STRUCT_IF_C Us_S_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_S_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_S_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu7s, Us_S_BFu7s)
//============================================================================



static void Test_Us_S_BFu8c()
{
  {
    init_simple_test("Us_S_BFu8c");
    static STRUCT_IF_C Us_S_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_S_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_S_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu8c, Us_S_BFu8c)
//============================================================================



static void Test_Us_S_BFu8i()
{
  {
    init_simple_test("Us_S_BFu8i");
    static STRUCT_IF_C Us_S_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_S_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu8i, Us_S_BFu8i)
//============================================================================



static void Test_Us_S_BFu8ll()
{
  {
    init_simple_test("Us_S_BFu8ll");
    static STRUCT_IF_C Us_S_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_S_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu8ll, Us_S_BFu8ll)
//============================================================================



static void Test_Us_S_BFu8s()
{
  {
    init_simple_test("Us_S_BFu8s");
    static STRUCT_IF_C Us_S_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_S_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_S_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu8s, Us_S_BFu8s)
//============================================================================



static void Test_Us_S_BFu9i()
{
  {
    init_simple_test("Us_S_BFu9i");
    static STRUCT_IF_C Us_S_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_S_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_S_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu9i, Us_S_BFu9i)
//============================================================================



static void Test_Us_S_BFu9ll()
{
  {
    init_simple_test("Us_S_BFu9ll");
    static STRUCT_IF_C Us_S_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_S_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_S_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu9ll, Us_S_BFu9ll)
//============================================================================



static void Test_Us_S_BFu9s()
{
  {
    init_simple_test("Us_S_BFu9s");
    static STRUCT_IF_C Us_S_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_S_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_S_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_BFu9s, Us_S_BFu9s)
//============================================================================



static void Test_Us_S_C()
{
  {
    init_simple_test("Us_S_C");
    STRUCT_IF_C Us_S_C lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_C)");
    check_field_offset(lv, v1, 0, "Us_S_C.v1");
    check_field_offset(lv, v2, 2, "Us_S_C.v2");
    check_field_offset(lv, v3, 4, "Us_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_C, Us_S_C)
//============================================================================



static void Test_Us_S_D()
{
  {
    init_simple_test("Us_S_D");
    STRUCT_IF_C Us_S_D lv;
    check2(sizeof(lv), 12, "sizeof(Us_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_D)");
    check_field_offset(lv, v1, 0, "Us_S_D.v1");
    check_field_offset(lv, v2, 2, "Us_S_D.v2");
    check_field_offset(lv, v3, 4, "Us_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_D, Us_S_D)
//============================================================================



static void Test_Us_S_F()
{
  {
    init_simple_test("Us_S_F");
    STRUCT_IF_C Us_S_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_F)");
    check_field_offset(lv, v1, 0, "Us_S_F.v1");
    check_field_offset(lv, v2, 2, "Us_S_F.v2");
    check_field_offset(lv, v3, 4, "Us_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_F, Us_S_F)
//============================================================================



static void Test_Us_S_I()
{
  {
    init_simple_test("Us_S_I");
    STRUCT_IF_C Us_S_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_I)");
    check_field_offset(lv, v1, 0, "Us_S_I.v1");
    check_field_offset(lv, v2, 2, "Us_S_I.v2");
    check_field_offset(lv, v3, 4, "Us_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_I, Us_S_I)
//============================================================================



static void Test_Us_S_Ip()
{
  {
    init_simple_test("Us_S_Ip");
    STRUCT_IF_C Us_S_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_Ip)");
    check_field_offset(lv, v1, 0, "Us_S_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_S_Ip.v2");
    check_field_offset(lv, v3, 4, "Us_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_Ip, Us_S_Ip)
//============================================================================



static void Test_Us_S_L()
{
  {
    init_simple_test("Us_S_L");
    STRUCT_IF_C Us_S_L lv;
    check2(sizeof(lv), 12, "sizeof(Us_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_L)");
    check_field_offset(lv, v1, 0, "Us_S_L.v1");
    check_field_offset(lv, v2, 2, "Us_S_L.v2");
    check_field_offset(lv, v3, 4, "Us_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_L, Us_S_L)
//============================================================================



static void Test_Us_S_S()
{
  {
    init_simple_test("Us_S_S");
    STRUCT_IF_C Us_S_S lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_S)");
    check_field_offset(lv, v1, 0, "Us_S_S.v1");
    check_field_offset(lv, v2, 2, "Us_S_S.v2");
    check_field_offset(lv, v3, 4, "Us_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_S, Us_S_S)
//============================================================================



static void Test_Us_S_Uc()
{
  {
    init_simple_test("Us_S_Uc");
    STRUCT_IF_C Us_S_Uc lv;
    check2(sizeof(lv), 5, "sizeof(Us_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_Uc)");
    check_field_offset(lv, v1, 0, "Us_S_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_S_Uc.v2");
    check_field_offset(lv, v3, 4, "Us_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_Uc, Us_S_Uc)
//============================================================================



static void Test_Us_S_Ui()
{
  {
    init_simple_test("Us_S_Ui");
    STRUCT_IF_C Us_S_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_Ui)");
    check_field_offset(lv, v1, 0, "Us_S_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_S_Ui.v2");
    check_field_offset(lv, v3, 4, "Us_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_Ui, Us_S_Ui)
//============================================================================



static void Test_Us_S_Ul()
{
  {
    init_simple_test("Us_S_Ul");
    STRUCT_IF_C Us_S_Ul lv;
    check2(sizeof(lv), 12, "sizeof(Us_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_Ul)");
    check_field_offset(lv, v1, 0, "Us_S_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_S_Ul.v2");
    check_field_offset(lv, v3, 4, "Us_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_Ul, Us_S_Ul)
//============================================================================



static void Test_Us_S_Us()
{
  {
    init_simple_test("Us_S_Us");
    STRUCT_IF_C Us_S_Us lv;
    check2(sizeof(lv), 6, "sizeof(Us_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_Us)");
    check_field_offset(lv, v1, 0, "Us_S_Us.v1");
    check_field_offset(lv, v2, 2, "Us_S_Us.v2");
    check_field_offset(lv, v3, 4, "Us_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_Us, Us_S_Us)
//============================================================================



static void Test_Us_S_Vp()
{
  {
    init_simple_test("Us_S_Vp");
    STRUCT_IF_C Us_S_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_S_Vp)");
    check_field_offset(lv, v1, 0, "Us_S_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_S_Vp.v2");
    check_field_offset(lv, v3, 4, "Us_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_S_Vp, Us_S_Vp)
//============================================================================



static void Test_Us_Uc()
{
  {
    init_simple_test("Us_Uc");
    STRUCT_IF_C Us_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc)");
    check_field_offset(lv, v1, 0, "Us_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc, Us_Uc)
//============================================================================



static void Test_Us_Uc_BFu15i()
{
  {
    init_simple_test("Us_Uc_BFu15i");
    static STRUCT_IF_C Us_Uc_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Us_Uc_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Us_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu15i, Us_Uc_BFu15i)
//============================================================================



static void Test_Us_Uc_BFu15ll()
{
  {
    init_simple_test("Us_Uc_BFu15ll");
    static STRUCT_IF_C Us_Uc_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Us_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Us_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu15ll, Us_Uc_BFu15ll)
//============================================================================



static void Test_Us_Uc_BFu15s()
{
  {
    init_simple_test("Us_Uc_BFu15s");
    static STRUCT_IF_C Us_Uc_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Us_Uc_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Us_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu15s, Us_Uc_BFu15s)
//============================================================================



static void Test_Us_Uc_BFu16i()
{
  {
    init_simple_test("Us_Uc_BFu16i");
    static STRUCT_IF_C Us_Uc_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Us_Uc_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Us_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu16i, Us_Uc_BFu16i)
//============================================================================



static void Test_Us_Uc_BFu16ll()
{
  {
    init_simple_test("Us_Uc_BFu16ll");
    static STRUCT_IF_C Us_Uc_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Us_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Us_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu16ll, Us_Uc_BFu16ll)
//============================================================================



static void Test_Us_Uc_BFu16s()
{
  {
    init_simple_test("Us_Uc_BFu16s");
    static STRUCT_IF_C Us_Uc_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Us_Uc_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Us_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu16s, Us_Uc_BFu16s)
//============================================================================



static void Test_Us_Uc_BFu17i()
{
  {
    init_simple_test("Us_Uc_BFu17i");
    static STRUCT_IF_C Us_Uc_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(Us_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "Us_Uc_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "Us_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu17i, Us_Uc_BFu17i)
//============================================================================



static void Test_Us_Uc_BFu17ll()
{
  {
    init_simple_test("Us_Uc_BFu17ll");
    static STRUCT_IF_C Us_Uc_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "Us_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "Us_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu17ll, Us_Uc_BFu17ll)
//============================================================================



static void Test_Us_Uc_BFu1c()
{
  {
    init_simple_test("Us_Uc_BFu1c");
    static STRUCT_IF_C Us_Uc_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Us_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu1c, Us_Uc_BFu1c)
//============================================================================



static void Test_Us_Uc_BFu1i()
{
  {
    init_simple_test("Us_Uc_BFu1i");
    static STRUCT_IF_C Us_Uc_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Us_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu1i, Us_Uc_BFu1i)
//============================================================================



static void Test_Us_Uc_BFu1ll()
{
  {
    init_simple_test("Us_Uc_BFu1ll");
    static STRUCT_IF_C Us_Uc_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Us_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu1ll, Us_Uc_BFu1ll)
//============================================================================



static void Test_Us_Uc_BFu1s()
{
  {
    init_simple_test("Us_Uc_BFu1s");
    static STRUCT_IF_C Us_Uc_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Us_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu1s, Us_Uc_BFu1s)
//============================================================================



static void Test_Us_Uc_BFu31i()
{
  {
    init_simple_test("Us_Uc_BFu31i");
    static STRUCT_IF_C Us_Uc_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "Us_Uc_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "Us_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu31i, Us_Uc_BFu31i)
//============================================================================



static void Test_Us_Uc_BFu31ll()
{
  {
    init_simple_test("Us_Uc_BFu31ll");
    static STRUCT_IF_C Us_Uc_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "Us_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "Us_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu31ll, Us_Uc_BFu31ll)
//============================================================================



static void Test_Us_Uc_BFu32i()
{
  {
    init_simple_test("Us_Uc_BFu32i");
    static STRUCT_IF_C Us_Uc_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "Us_Uc_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "Us_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu32i, Us_Uc_BFu32i)
//============================================================================



static void Test_Us_Uc_BFu32ll()
{
  {
    init_simple_test("Us_Uc_BFu32ll");
    static STRUCT_IF_C Us_Uc_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "Us_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "Us_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu32ll, Us_Uc_BFu32ll)
//============================================================================



static void Test_Us_Uc_BFu33()
{
  {
    init_simple_test("Us_Uc_BFu33");
    static STRUCT_IF_C Us_Uc_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "Us_Uc_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "Us_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu33, Us_Uc_BFu33)
//============================================================================



static void Test_Us_Uc_BFu7c()
{
  {
    init_simple_test("Us_Uc_BFu7c");
    static STRUCT_IF_C Us_Uc_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Us_Uc_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Us_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu7c, Us_Uc_BFu7c)
//============================================================================



static void Test_Us_Uc_BFu7i()
{
  {
    init_simple_test("Us_Uc_BFu7i");
    static STRUCT_IF_C Us_Uc_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Us_Uc_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Us_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu7i, Us_Uc_BFu7i)
//============================================================================



static void Test_Us_Uc_BFu7ll()
{
  {
    init_simple_test("Us_Uc_BFu7ll");
    static STRUCT_IF_C Us_Uc_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Us_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Us_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu7ll, Us_Uc_BFu7ll)
//============================================================================



static void Test_Us_Uc_BFu7s()
{
  {
    init_simple_test("Us_Uc_BFu7s");
    static STRUCT_IF_C Us_Uc_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Us_Uc_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Us_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu7s, Us_Uc_BFu7s)
//============================================================================



static void Test_Us_Uc_BFu8c()
{
  {
    init_simple_test("Us_Uc_BFu8c");
    static STRUCT_IF_C Us_Uc_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_Uc_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu8c, Us_Uc_BFu8c)
//============================================================================



static void Test_Us_Uc_BFu8i()
{
  {
    init_simple_test("Us_Uc_BFu8i");
    static STRUCT_IF_C Us_Uc_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_Uc_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu8i, Us_Uc_BFu8i)
//============================================================================



static void Test_Us_Uc_BFu8ll()
{
  {
    init_simple_test("Us_Uc_BFu8ll");
    static STRUCT_IF_C Us_Uc_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu8ll, Us_Uc_BFu8ll)
//============================================================================



static void Test_Us_Uc_BFu8s()
{
  {
    init_simple_test("Us_Uc_BFu8s");
    static STRUCT_IF_C Us_Uc_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_Uc_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu8s, Us_Uc_BFu8s)
//============================================================================



static void Test_Us_Uc_BFu9i()
{
  {
    init_simple_test("Us_Uc_BFu9i");
    static STRUCT_IF_C Us_Uc_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Us_Uc_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Us_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu9i, Us_Uc_BFu9i)
//============================================================================



static void Test_Us_Uc_BFu9ll()
{
  {
    init_simple_test("Us_Uc_BFu9ll");
    static STRUCT_IF_C Us_Uc_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Us_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Us_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu9ll, Us_Uc_BFu9ll)
//============================================================================



static void Test_Us_Uc_BFu9s()
{
  {
    init_simple_test("Us_Uc_BFu9s");
    static STRUCT_IF_C Us_Uc_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Us_Uc_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Us_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_BFu9s, Us_Uc_BFu9s)
//============================================================================



static void Test_Us_Uc_C()
{
  {
    init_simple_test("Us_Uc_C");
    STRUCT_IF_C Us_Uc_C lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_C)");
    check_field_offset(lv, v1, 0, "Us_Uc_C.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_C.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_C, Us_Uc_C)
//============================================================================



static void Test_Us_Uc_D()
{
  {
    init_simple_test("Us_Uc_D");
    STRUCT_IF_C Us_Uc_D lv;
    check2(sizeof(lv), 11, "sizeof(Us_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_D)");
    check_field_offset(lv, v1, 0, "Us_Uc_D.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_D.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_D, Us_Uc_D)
//============================================================================



static void Test_Us_Uc_F()
{
  {
    init_simple_test("Us_Uc_F");
    STRUCT_IF_C Us_Uc_F lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_F)");
    check_field_offset(lv, v1, 0, "Us_Uc_F.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_F.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_F, Us_Uc_F)
//============================================================================



static void Test_Us_Uc_I()
{
  {
    init_simple_test("Us_Uc_I");
    STRUCT_IF_C Us_Uc_I lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_I)");
    check_field_offset(lv, v1, 0, "Us_Uc_I.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_I.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_I, Us_Uc_I)
//============================================================================



static void Test_Us_Uc_Ip()
{
  {
    init_simple_test("Us_Uc_Ip");
    STRUCT_IF_C Us_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_Ip)");
    check_field_offset(lv, v1, 0, "Us_Uc_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_Ip.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_Ip, Us_Uc_Ip)
//============================================================================



static void Test_Us_Uc_L()
{
  {
    init_simple_test("Us_Uc_L");
    STRUCT_IF_C Us_Uc_L lv;
    check2(sizeof(lv), 11, "sizeof(Us_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_L)");
    check_field_offset(lv, v1, 0, "Us_Uc_L.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_L.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_L, Us_Uc_L)
//============================================================================



static void Test_Us_Uc_S()
{
  {
    init_simple_test("Us_Uc_S");
    STRUCT_IF_C Us_Uc_S lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_S)");
    check_field_offset(lv, v1, 0, "Us_Uc_S.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_S.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_S, Us_Uc_S)
//============================================================================



static void Test_Us_Uc_Uc()
{
  {
    init_simple_test("Us_Uc_Uc");
    STRUCT_IF_C Us_Uc_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Us_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_Uc)");
    check_field_offset(lv, v1, 0, "Us_Uc_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_Uc.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_Uc, Us_Uc_Uc)
//============================================================================



static void Test_Us_Uc_Ui()
{
  {
    init_simple_test("Us_Uc_Ui");
    STRUCT_IF_C Us_Uc_Ui lv;
    check2(sizeof(lv), 7, "sizeof(Us_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_Ui)");
    check_field_offset(lv, v1, 0, "Us_Uc_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_Ui.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_Ui, Us_Uc_Ui)
//============================================================================



static void Test_Us_Uc_Ul()
{
  {
    init_simple_test("Us_Uc_Ul");
    STRUCT_IF_C Us_Uc_Ul lv;
    check2(sizeof(lv), 11, "sizeof(Us_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_Ul)");
    check_field_offset(lv, v1, 0, "Us_Uc_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_Ul.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_Ul, Us_Uc_Ul)
//============================================================================



static void Test_Us_Uc_Us()
{
  {
    init_simple_test("Us_Uc_Us");
    STRUCT_IF_C Us_Uc_Us lv;
    check2(sizeof(lv), 5, "sizeof(Us_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_Us)");
    check_field_offset(lv, v1, 0, "Us_Uc_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_Us.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_Us, Us_Uc_Us)
//============================================================================



static void Test_Us_Uc_Vp()
{
  {
    init_simple_test("Us_Uc_Vp");
    STRUCT_IF_C Us_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Uc_Vp)");
    check_field_offset(lv, v1, 0, "Us_Uc_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Uc_Vp.v2");
    check_field_offset(lv, v3, 3, "Us_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Uc_Vp, Us_Uc_Vp)
//============================================================================



static void Test_Us_Ui()
{
  {
    init_simple_test("Us_Ui");
    STRUCT_IF_C Us_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui)");
    check_field_offset(lv, v1, 0, "Us_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui, Us_Ui)
//============================================================================



static void Test_Us_Ui_BFu15i()
{
  {
    init_simple_test("Us_Ui_BFu15i");
    static STRUCT_IF_C Us_Ui_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_Ui_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu15i, Us_Ui_BFu15i)
//============================================================================



static void Test_Us_Ui_BFu15ll()
{
  {
    init_simple_test("Us_Ui_BFu15ll");
    static STRUCT_IF_C Us_Ui_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu15ll, Us_Ui_BFu15ll)
//============================================================================



static void Test_Us_Ui_BFu15s()
{
  {
    init_simple_test("Us_Ui_BFu15s");
    static STRUCT_IF_C Us_Ui_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_Ui_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu15s, Us_Ui_BFu15s)
//============================================================================



static void Test_Us_Ui_BFu16i()
{
  {
    init_simple_test("Us_Ui_BFu16i");
    static STRUCT_IF_C Us_Ui_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_Ui_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu16i, Us_Ui_BFu16i)
//============================================================================



static void Test_Us_Ui_BFu16ll()
{
  {
    init_simple_test("Us_Ui_BFu16ll");
    static STRUCT_IF_C Us_Ui_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu16ll, Us_Ui_BFu16ll)
//============================================================================



static void Test_Us_Ui_BFu16s()
{
  {
    init_simple_test("Us_Ui_BFu16s");
    static STRUCT_IF_C Us_Ui_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_Ui_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu16s, Us_Ui_BFu16s)
//============================================================================



static void Test_Us_Ui_BFu17i()
{
  {
    init_simple_test("Us_Ui_BFu17i");
    static STRUCT_IF_C Us_Ui_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(Us_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "Us_Ui_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "Us_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu17i, Us_Ui_BFu17i)
//============================================================================



static void Test_Us_Ui_BFu17ll()
{
  {
    init_simple_test("Us_Ui_BFu17ll");
    static STRUCT_IF_C Us_Ui_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(Us_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "Us_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "Us_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu17ll, Us_Ui_BFu17ll)
//============================================================================



static void Test_Us_Ui_BFu1c()
{
  {
    init_simple_test("Us_Ui_BFu1c");
    static STRUCT_IF_C Us_Ui_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu1c, Us_Ui_BFu1c)
//============================================================================



static void Test_Us_Ui_BFu1i()
{
  {
    init_simple_test("Us_Ui_BFu1i");
    static STRUCT_IF_C Us_Ui_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu1i, Us_Ui_BFu1i)
//============================================================================



static void Test_Us_Ui_BFu1ll()
{
  {
    init_simple_test("Us_Ui_BFu1ll");
    static STRUCT_IF_C Us_Ui_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu1ll, Us_Ui_BFu1ll)
//============================================================================



static void Test_Us_Ui_BFu1s()
{
  {
    init_simple_test("Us_Ui_BFu1s");
    static STRUCT_IF_C Us_Ui_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Us_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu1s, Us_Ui_BFu1s)
//============================================================================



static void Test_Us_Ui_BFu31i()
{
  {
    init_simple_test("Us_Ui_BFu31i");
    static STRUCT_IF_C Us_Ui_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "Us_Ui_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "Us_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu31i, Us_Ui_BFu31i)
//============================================================================



static void Test_Us_Ui_BFu31ll()
{
  {
    init_simple_test("Us_Ui_BFu31ll");
    static STRUCT_IF_C Us_Ui_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "Us_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "Us_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu31ll, Us_Ui_BFu31ll)
//============================================================================



static void Test_Us_Ui_BFu32i()
{
  {
    init_simple_test("Us_Ui_BFu32i");
    static STRUCT_IF_C Us_Ui_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "Us_Ui_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "Us_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu32i, Us_Ui_BFu32i)
//============================================================================



static void Test_Us_Ui_BFu32ll()
{
  {
    init_simple_test("Us_Ui_BFu32ll");
    static STRUCT_IF_C Us_Ui_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "Us_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "Us_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu32ll, Us_Ui_BFu32ll)
//============================================================================



static void Test_Us_Ui_BFu33()
{
  {
    init_simple_test("Us_Ui_BFu33");
    static STRUCT_IF_C Us_Ui_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "Us_Ui_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "Us_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu33, Us_Ui_BFu33)
//============================================================================



static void Test_Us_Ui_BFu7c()
{
  {
    init_simple_test("Us_Ui_BFu7c");
    static STRUCT_IF_C Us_Ui_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_Ui_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu7c, Us_Ui_BFu7c)
//============================================================================



static void Test_Us_Ui_BFu7i()
{
  {
    init_simple_test("Us_Ui_BFu7i");
    static STRUCT_IF_C Us_Ui_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_Ui_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu7i, Us_Ui_BFu7i)
//============================================================================



static void Test_Us_Ui_BFu7ll()
{
  {
    init_simple_test("Us_Ui_BFu7ll");
    static STRUCT_IF_C Us_Ui_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu7ll, Us_Ui_BFu7ll)
//============================================================================



static void Test_Us_Ui_BFu7s()
{
  {
    init_simple_test("Us_Ui_BFu7s");
    static STRUCT_IF_C Us_Ui_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_Ui_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu7s, Us_Ui_BFu7s)
//============================================================================



static void Test_Us_Ui_BFu8c()
{
  {
    init_simple_test("Us_Ui_BFu8c");
    static STRUCT_IF_C Us_Ui_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_Ui_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu8c, Us_Ui_BFu8c)
//============================================================================



static void Test_Us_Ui_BFu8i()
{
  {
    init_simple_test("Us_Ui_BFu8i");
    static STRUCT_IF_C Us_Ui_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_Ui_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu8i, Us_Ui_BFu8i)
//============================================================================



static void Test_Us_Ui_BFu8ll()
{
  {
    init_simple_test("Us_Ui_BFu8ll");
    static STRUCT_IF_C Us_Ui_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu8ll, Us_Ui_BFu8ll)
//============================================================================



static void Test_Us_Ui_BFu8s()
{
  {
    init_simple_test("Us_Ui_BFu8s");
    static STRUCT_IF_C Us_Ui_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_Ui_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu8s, Us_Ui_BFu8s)
//============================================================================



static void Test_Us_Ui_BFu9i()
{
  {
    init_simple_test("Us_Ui_BFu9i");
    static STRUCT_IF_C Us_Ui_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_Ui_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu9i, Us_Ui_BFu9i)
//============================================================================



static void Test_Us_Ui_BFu9ll()
{
  {
    init_simple_test("Us_Ui_BFu9ll");
    static STRUCT_IF_C Us_Ui_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu9ll, Us_Ui_BFu9ll)
//============================================================================



static void Test_Us_Ui_BFu9s()
{
  {
    init_simple_test("Us_Ui_BFu9s");
    static STRUCT_IF_C Us_Ui_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_Ui_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_BFu9s, Us_Ui_BFu9s)
//============================================================================



static void Test_Us_Ui_C()
{
  {
    init_simple_test("Us_Ui_C");
    STRUCT_IF_C Us_Ui_C lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_C)");
    check_field_offset(lv, v1, 0, "Us_Ui_C.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_C.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_C, Us_Ui_C)
//============================================================================



static void Test_Us_Ui_D()
{
  {
    init_simple_test("Us_Ui_D");
    STRUCT_IF_C Us_Ui_D lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_D)");
    check_field_offset(lv, v1, 0, "Us_Ui_D.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_D.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_D, Us_Ui_D)
//============================================================================



static void Test_Us_Ui_F()
{
  {
    init_simple_test("Us_Ui_F");
    STRUCT_IF_C Us_Ui_F lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_F)");
    check_field_offset(lv, v1, 0, "Us_Ui_F.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_F.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_F, Us_Ui_F)
//============================================================================



static void Test_Us_Ui_I()
{
  {
    init_simple_test("Us_Ui_I");
    STRUCT_IF_C Us_Ui_I lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_I)");
    check_field_offset(lv, v1, 0, "Us_Ui_I.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_I.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_I, Us_Ui_I)
//============================================================================



static void Test_Us_Ui_Ip()
{
  {
    init_simple_test("Us_Ui_Ip");
    STRUCT_IF_C Us_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_Ip)");
    check_field_offset(lv, v1, 0, "Us_Ui_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_Ip.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_Ip, Us_Ui_Ip)
//============================================================================



static void Test_Us_Ui_L()
{
  {
    init_simple_test("Us_Ui_L");
    STRUCT_IF_C Us_Ui_L lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_L)");
    check_field_offset(lv, v1, 0, "Us_Ui_L.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_L.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_L, Us_Ui_L)
//============================================================================



static void Test_Us_Ui_S()
{
  {
    init_simple_test("Us_Ui_S");
    STRUCT_IF_C Us_Ui_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_S)");
    check_field_offset(lv, v1, 0, "Us_Ui_S.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_S.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_S, Us_Ui_S)
//============================================================================



static void Test_Us_Ui_Uc()
{
  {
    init_simple_test("Us_Ui_Uc");
    STRUCT_IF_C Us_Ui_Uc lv;
    check2(sizeof(lv), 7, "sizeof(Us_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_Uc)");
    check_field_offset(lv, v1, 0, "Us_Ui_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_Uc.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_Uc, Us_Ui_Uc)
//============================================================================



static void Test_Us_Ui_Ui()
{
  {
    init_simple_test("Us_Ui_Ui");
    STRUCT_IF_C Us_Ui_Ui lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_Ui)");
    check_field_offset(lv, v1, 0, "Us_Ui_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_Ui.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_Ui, Us_Ui_Ui)
//============================================================================



static void Test_Us_Ui_Ul()
{
  {
    init_simple_test("Us_Ui_Ul");
    STRUCT_IF_C Us_Ui_Ul lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_Ul)");
    check_field_offset(lv, v1, 0, "Us_Ui_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_Ul.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_Ul, Us_Ui_Ul)
//============================================================================



static void Test_Us_Ui_Us()
{
  {
    init_simple_test("Us_Ui_Us");
    STRUCT_IF_C Us_Ui_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_Us)");
    check_field_offset(lv, v1, 0, "Us_Ui_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_Us.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_Us, Us_Ui_Us)
//============================================================================



static void Test_Us_Ui_Vp()
{
  {
    init_simple_test("Us_Ui_Vp");
    STRUCT_IF_C Us_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ui_Vp)");
    check_field_offset(lv, v1, 0, "Us_Ui_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Ui_Vp.v2");
    check_field_offset(lv, v3, 6, "Us_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ui_Vp, Us_Ui_Vp)
//============================================================================



static void Test_Us_Ul()
{
  {
    init_simple_test("Us_Ul");
    STRUCT_IF_C Us_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul)");
    check_field_offset(lv, v1, 0, "Us_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul, Us_Ul)
//============================================================================



static void Test_Us_Ul_BFu15i()
{
  {
    init_simple_test("Us_Ul_BFu15i");
    static STRUCT_IF_C Us_Ul_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Us_Ul_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Us_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu15i, Us_Ul_BFu15i)
//============================================================================



static void Test_Us_Ul_BFu15ll()
{
  {
    init_simple_test("Us_Ul_BFu15ll");
    static STRUCT_IF_C Us_Ul_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Us_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Us_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu15ll, Us_Ul_BFu15ll)
//============================================================================



static void Test_Us_Ul_BFu15s()
{
  {
    init_simple_test("Us_Ul_BFu15s");
    static STRUCT_IF_C Us_Ul_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Us_Ul_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Us_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu15s, Us_Ul_BFu15s)
//============================================================================



static void Test_Us_Ul_BFu16i()
{
  {
    init_simple_test("Us_Ul_BFu16i");
    static STRUCT_IF_C Us_Ul_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Us_Ul_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Us_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu16i, Us_Ul_BFu16i)
//============================================================================



static void Test_Us_Ul_BFu16ll()
{
  {
    init_simple_test("Us_Ul_BFu16ll");
    static STRUCT_IF_C Us_Ul_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Us_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Us_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu16ll, Us_Ul_BFu16ll)
//============================================================================



static void Test_Us_Ul_BFu16s()
{
  {
    init_simple_test("Us_Ul_BFu16s");
    static STRUCT_IF_C Us_Ul_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Us_Ul_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Us_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu16s, Us_Ul_BFu16s)
//============================================================================



static void Test_Us_Ul_BFu17i()
{
  {
    init_simple_test("Us_Ul_BFu17i");
    static STRUCT_IF_C Us_Ul_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Us_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Us_Ul_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Us_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu17i, Us_Ul_BFu17i)
//============================================================================



static void Test_Us_Ul_BFu17ll()
{
  {
    init_simple_test("Us_Ul_BFu17ll");
    static STRUCT_IF_C Us_Ul_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Us_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Us_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Us_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu17ll, Us_Ul_BFu17ll)
//============================================================================



static void Test_Us_Ul_BFu1c()
{
  {
    init_simple_test("Us_Ul_BFu1c");
    static STRUCT_IF_C Us_Ul_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu1c, Us_Ul_BFu1c)
//============================================================================



static void Test_Us_Ul_BFu1i()
{
  {
    init_simple_test("Us_Ul_BFu1i");
    static STRUCT_IF_C Us_Ul_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu1i, Us_Ul_BFu1i)
//============================================================================



static void Test_Us_Ul_BFu1ll()
{
  {
    init_simple_test("Us_Ul_BFu1ll");
    static STRUCT_IF_C Us_Ul_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu1ll, Us_Ul_BFu1ll)
//============================================================================



static void Test_Us_Ul_BFu1s()
{
  {
    init_simple_test("Us_Ul_BFu1s");
    static STRUCT_IF_C Us_Ul_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Us_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu1s, Us_Ul_BFu1s)
//============================================================================



static void Test_Us_Ul_BFu31i()
{
  {
    init_simple_test("Us_Ul_BFu31i");
    static STRUCT_IF_C Us_Ul_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Us_Ul_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Us_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu31i, Us_Ul_BFu31i)
//============================================================================



static void Test_Us_Ul_BFu31ll()
{
  {
    init_simple_test("Us_Ul_BFu31ll");
    static STRUCT_IF_C Us_Ul_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Us_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Us_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu31ll, Us_Ul_BFu31ll)
//============================================================================



static void Test_Us_Ul_BFu32i()
{
  {
    init_simple_test("Us_Ul_BFu32i");
    static STRUCT_IF_C Us_Ul_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Us_Ul_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Us_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu32i, Us_Ul_BFu32i)
//============================================================================



static void Test_Us_Ul_BFu32ll()
{
  {
    init_simple_test("Us_Ul_BFu32ll");
    static STRUCT_IF_C Us_Ul_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Us_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Us_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu32ll, Us_Ul_BFu32ll)
//============================================================================



static void Test_Us_Ul_BFu33()
{
  {
    init_simple_test("Us_Ul_BFu33");
    static STRUCT_IF_C Us_Ul_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Us_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Us_Ul_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Us_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu33, Us_Ul_BFu33)
//============================================================================



static void Test_Us_Ul_BFu7c()
{
  {
    init_simple_test("Us_Ul_BFu7c");
    static STRUCT_IF_C Us_Ul_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_Ul_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu7c, Us_Ul_BFu7c)
//============================================================================



static void Test_Us_Ul_BFu7i()
{
  {
    init_simple_test("Us_Ul_BFu7i");
    static STRUCT_IF_C Us_Ul_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_Ul_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu7i, Us_Ul_BFu7i)
//============================================================================



static void Test_Us_Ul_BFu7ll()
{
  {
    init_simple_test("Us_Ul_BFu7ll");
    static STRUCT_IF_C Us_Ul_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu7ll, Us_Ul_BFu7ll)
//============================================================================



static void Test_Us_Ul_BFu7s()
{
  {
    init_simple_test("Us_Ul_BFu7s");
    static STRUCT_IF_C Us_Ul_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Us_Ul_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Us_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu7s, Us_Ul_BFu7s)
//============================================================================



static void Test_Us_Ul_BFu8c()
{
  {
    init_simple_test("Us_Ul_BFu8c");
    static STRUCT_IF_C Us_Ul_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_Ul_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu8c, Us_Ul_BFu8c)
//============================================================================



static void Test_Us_Ul_BFu8i()
{
  {
    init_simple_test("Us_Ul_BFu8i");
    static STRUCT_IF_C Us_Ul_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_Ul_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu8i, Us_Ul_BFu8i)
//============================================================================



static void Test_Us_Ul_BFu8ll()
{
  {
    init_simple_test("Us_Ul_BFu8ll");
    static STRUCT_IF_C Us_Ul_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu8ll, Us_Ul_BFu8ll)
//============================================================================



static void Test_Us_Ul_BFu8s()
{
  {
    init_simple_test("Us_Ul_BFu8s");
    static STRUCT_IF_C Us_Ul_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Us_Ul_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Us_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu8s, Us_Ul_BFu8s)
//============================================================================



static void Test_Us_Ul_BFu9i()
{
  {
    init_simple_test("Us_Ul_BFu9i");
    static STRUCT_IF_C Us_Ul_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Us_Ul_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Us_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu9i, Us_Ul_BFu9i)
//============================================================================



static void Test_Us_Ul_BFu9ll()
{
  {
    init_simple_test("Us_Ul_BFu9ll");
    static STRUCT_IF_C Us_Ul_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Us_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Us_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu9ll, Us_Ul_BFu9ll)
//============================================================================



static void Test_Us_Ul_BFu9s()
{
  {
    init_simple_test("Us_Ul_BFu9s");
    static STRUCT_IF_C Us_Ul_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Us_Ul_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Us_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_BFu9s, Us_Ul_BFu9s)
//============================================================================



static void Test_Us_Ul_C()
{
  {
    init_simple_test("Us_Ul_C");
    STRUCT_IF_C Us_Ul_C lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_C)");
    check_field_offset(lv, v1, 0, "Us_Ul_C.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_C.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_C, Us_Ul_C)
//============================================================================



static void Test_Us_Ul_D()
{
  {
    init_simple_test("Us_Ul_D");
    STRUCT_IF_C Us_Ul_D lv;
    check2(sizeof(lv), 18, "sizeof(Us_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_D)");
    check_field_offset(lv, v1, 0, "Us_Ul_D.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_D.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_D, Us_Ul_D)
//============================================================================



static void Test_Us_Ul_F()
{
  {
    init_simple_test("Us_Ul_F");
    STRUCT_IF_C Us_Ul_F lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_F)");
    check_field_offset(lv, v1, 0, "Us_Ul_F.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_F.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_F, Us_Ul_F)
//============================================================================



static void Test_Us_Ul_I()
{
  {
    init_simple_test("Us_Ul_I");
    STRUCT_IF_C Us_Ul_I lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_I)");
    check_field_offset(lv, v1, 0, "Us_Ul_I.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_I.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_I, Us_Ul_I)
//============================================================================



static void Test_Us_Ul_Ip()
{
  {
    init_simple_test("Us_Ul_Ip");
    STRUCT_IF_C Us_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_Ip)");
    check_field_offset(lv, v1, 0, "Us_Ul_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_Ip.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_Ip, Us_Ul_Ip)
//============================================================================



static void Test_Us_Ul_L()
{
  {
    init_simple_test("Us_Ul_L");
    STRUCT_IF_C Us_Ul_L lv;
    check2(sizeof(lv), 18, "sizeof(Us_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_L)");
    check_field_offset(lv, v1, 0, "Us_Ul_L.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_L.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_L, Us_Ul_L)
//============================================================================



static void Test_Us_Ul_S()
{
  {
    init_simple_test("Us_Ul_S");
    STRUCT_IF_C Us_Ul_S lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_S)");
    check_field_offset(lv, v1, 0, "Us_Ul_S.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_S.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_S, Us_Ul_S)
//============================================================================



static void Test_Us_Ul_Uc()
{
  {
    init_simple_test("Us_Ul_Uc");
    STRUCT_IF_C Us_Ul_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Us_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_Uc)");
    check_field_offset(lv, v1, 0, "Us_Ul_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_Uc.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_Uc, Us_Ul_Uc)
//============================================================================



static void Test_Us_Ul_Ui()
{
  {
    init_simple_test("Us_Ul_Ui");
    STRUCT_IF_C Us_Ul_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Us_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_Ui)");
    check_field_offset(lv, v1, 0, "Us_Ul_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_Ui.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_Ui, Us_Ul_Ui)
//============================================================================



static void Test_Us_Ul_Ul()
{
  {
    init_simple_test("Us_Ul_Ul");
    STRUCT_IF_C Us_Ul_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Us_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_Ul)");
    check_field_offset(lv, v1, 0, "Us_Ul_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_Ul.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_Ul, Us_Ul_Ul)
//============================================================================



static void Test_Us_Ul_Us()
{
  {
    init_simple_test("Us_Ul_Us");
    STRUCT_IF_C Us_Ul_Us lv;
    check2(sizeof(lv), 12, "sizeof(Us_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_Us)");
    check_field_offset(lv, v1, 0, "Us_Ul_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_Us.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_Us, Us_Ul_Us)
//============================================================================



static void Test_Us_Ul_Vp()
{
  {
    init_simple_test("Us_Ul_Vp");
    STRUCT_IF_C Us_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Ul_Vp)");
    check_field_offset(lv, v1, 0, "Us_Ul_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Ul_Vp.v2");
    check_field_offset(lv, v3, 10, "Us_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Ul_Vp, Us_Ul_Vp)
//============================================================================



static void Test_Us_Us()
{
  {
    init_simple_test("Us_Us");
    STRUCT_IF_C Us_Us lv;
    check2(sizeof(lv), 4, "sizeof(Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us)");
    check_field_offset(lv, v1, 0, "Us_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us, Us_Us)
//============================================================================



static void Test_Us_Us_BFu15i()
{
  {
    init_simple_test("Us_Us_BFu15i");
    static STRUCT_IF_C Us_Us_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_Us_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu15i, Us_Us_BFu15i)
//============================================================================



static void Test_Us_Us_BFu15ll()
{
  {
    init_simple_test("Us_Us_BFu15ll");
    static STRUCT_IF_C Us_Us_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_Us_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu15ll, Us_Us_BFu15ll)
//============================================================================



static void Test_Us_Us_BFu15s()
{
  {
    init_simple_test("Us_Us_BFu15s");
    static STRUCT_IF_C Us_Us_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_Us_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu15s, Us_Us_BFu15s)
//============================================================================



static void Test_Us_Us_BFu16i()
{
  {
    init_simple_test("Us_Us_BFu16i");
    static STRUCT_IF_C Us_Us_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_Us_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu16i, Us_Us_BFu16i)
//============================================================================



static void Test_Us_Us_BFu16ll()
{
  {
    init_simple_test("Us_Us_BFu16ll");
    static STRUCT_IF_C Us_Us_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_Us_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu16ll, Us_Us_BFu16ll)
//============================================================================



static void Test_Us_Us_BFu16s()
{
  {
    init_simple_test("Us_Us_BFu16s");
    static STRUCT_IF_C Us_Us_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_Us_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu16s, Us_Us_BFu16s)
//============================================================================



static void Test_Us_Us_BFu17i()
{
  {
    init_simple_test("Us_Us_BFu17i");
    static STRUCT_IF_C Us_Us_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(Us_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_Us_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu17i, Us_Us_BFu17i)
//============================================================================



static void Test_Us_Us_BFu17ll()
{
  {
    init_simple_test("Us_Us_BFu17ll");
    static STRUCT_IF_C Us_Us_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(Us_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_Us_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu17ll, Us_Us_BFu17ll)
//============================================================================



static void Test_Us_Us_BFu1c()
{
  {
    init_simple_test("Us_Us_BFu1c");
    static STRUCT_IF_C Us_Us_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu1c, Us_Us_BFu1c)
//============================================================================



static void Test_Us_Us_BFu1i()
{
  {
    init_simple_test("Us_Us_BFu1i");
    static STRUCT_IF_C Us_Us_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu1i, Us_Us_BFu1i)
//============================================================================



static void Test_Us_Us_BFu1ll()
{
  {
    init_simple_test("Us_Us_BFu1ll");
    static STRUCT_IF_C Us_Us_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu1ll, Us_Us_BFu1ll)
//============================================================================



static void Test_Us_Us_BFu1s()
{
  {
    init_simple_test("Us_Us_BFu1s");
    static STRUCT_IF_C Us_Us_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu1s, Us_Us_BFu1s)
//============================================================================



static void Test_Us_Us_BFu31i()
{
  {
    init_simple_test("Us_Us_BFu31i");
    static STRUCT_IF_C Us_Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_Us_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu31i, Us_Us_BFu31i)
//============================================================================



static void Test_Us_Us_BFu31ll()
{
  {
    init_simple_test("Us_Us_BFu31ll");
    static STRUCT_IF_C Us_Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_Us_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu31ll, Us_Us_BFu31ll)
//============================================================================



static void Test_Us_Us_BFu32i()
{
  {
    init_simple_test("Us_Us_BFu32i");
    static STRUCT_IF_C Us_Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_Us_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu32i, Us_Us_BFu32i)
//============================================================================



static void Test_Us_Us_BFu32ll()
{
  {
    init_simple_test("Us_Us_BFu32ll");
    static STRUCT_IF_C Us_Us_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_Us_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu32ll, Us_Us_BFu32ll)
//============================================================================



static void Test_Us_Us_BFu33()
{
  {
    init_simple_test("Us_Us_BFu33");
    static STRUCT_IF_C Us_Us_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(Us_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu33)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "Us_Us_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "Us_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu33, Us_Us_BFu33)
//============================================================================



static void Test_Us_Us_BFu7c()
{
  {
    init_simple_test("Us_Us_BFu7c");
    static STRUCT_IF_C Us_Us_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_Us_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu7c, Us_Us_BFu7c)
//============================================================================



static void Test_Us_Us_BFu7i()
{
  {
    init_simple_test("Us_Us_BFu7i");
    static STRUCT_IF_C Us_Us_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_Us_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu7i, Us_Us_BFu7i)
//============================================================================



static void Test_Us_Us_BFu7ll()
{
  {
    init_simple_test("Us_Us_BFu7ll");
    static STRUCT_IF_C Us_Us_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_Us_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu7ll, Us_Us_BFu7ll)
//============================================================================



static void Test_Us_Us_BFu7s()
{
  {
    init_simple_test("Us_Us_BFu7s");
    static STRUCT_IF_C Us_Us_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_Us_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu7s, Us_Us_BFu7s)
//============================================================================



static void Test_Us_Us_BFu8c()
{
  {
    init_simple_test("Us_Us_BFu8c");
    static STRUCT_IF_C Us_Us_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_Us_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu8c, Us_Us_BFu8c)
//============================================================================



static void Test_Us_Us_BFu8i()
{
  {
    init_simple_test("Us_Us_BFu8i");
    static STRUCT_IF_C Us_Us_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_Us_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu8i, Us_Us_BFu8i)
//============================================================================



static void Test_Us_Us_BFu8ll()
{
  {
    init_simple_test("Us_Us_BFu8ll");
    static STRUCT_IF_C Us_Us_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_Us_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu8ll, Us_Us_BFu8ll)
//============================================================================



static void Test_Us_Us_BFu8s()
{
  {
    init_simple_test("Us_Us_BFu8s");
    static STRUCT_IF_C Us_Us_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_Us_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu8s, Us_Us_BFu8s)
//============================================================================



static void Test_Us_Us_BFu9i()
{
  {
    init_simple_test("Us_Us_BFu9i");
    static STRUCT_IF_C Us_Us_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_Us_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu9i, Us_Us_BFu9i)
//============================================================================



static void Test_Us_Us_BFu9ll()
{
  {
    init_simple_test("Us_Us_BFu9ll");
    static STRUCT_IF_C Us_Us_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_Us_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu9ll, Us_Us_BFu9ll)
//============================================================================



static void Test_Us_Us_BFu9s()
{
  {
    init_simple_test("Us_Us_BFu9s");
    static STRUCT_IF_C Us_Us_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_Us_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_Us_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_BFu9s, Us_Us_BFu9s)
//============================================================================



static void Test_Us_Us_C()
{
  {
    init_simple_test("Us_Us_C");
    STRUCT_IF_C Us_Us_C lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_C)");
    check_field_offset(lv, v1, 0, "Us_Us_C.v1");
    check_field_offset(lv, v2, 2, "Us_Us_C.v2");
    check_field_offset(lv, v3, 4, "Us_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_C, Us_Us_C)
//============================================================================



static void Test_Us_Us_D()
{
  {
    init_simple_test("Us_Us_D");
    STRUCT_IF_C Us_Us_D lv;
    check2(sizeof(lv), 12, "sizeof(Us_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_D)");
    check_field_offset(lv, v1, 0, "Us_Us_D.v1");
    check_field_offset(lv, v2, 2, "Us_Us_D.v2");
    check_field_offset(lv, v3, 4, "Us_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_D, Us_Us_D)
//============================================================================



static void Test_Us_Us_F()
{
  {
    init_simple_test("Us_Us_F");
    STRUCT_IF_C Us_Us_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_F)");
    check_field_offset(lv, v1, 0, "Us_Us_F.v1");
    check_field_offset(lv, v2, 2, "Us_Us_F.v2");
    check_field_offset(lv, v3, 4, "Us_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_F, Us_Us_F)
//============================================================================



static void Test_Us_Us_I()
{
  {
    init_simple_test("Us_Us_I");
    STRUCT_IF_C Us_Us_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_I)");
    check_field_offset(lv, v1, 0, "Us_Us_I.v1");
    check_field_offset(lv, v2, 2, "Us_Us_I.v2");
    check_field_offset(lv, v3, 4, "Us_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_I, Us_Us_I)
//============================================================================



static void Test_Us_Us_Ip()
{
  {
    init_simple_test("Us_Us_Ip");
    STRUCT_IF_C Us_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_Ip)");
    check_field_offset(lv, v1, 0, "Us_Us_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Us_Ip.v2");
    check_field_offset(lv, v3, 4, "Us_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_Ip, Us_Us_Ip)
//============================================================================



static void Test_Us_Us_L()
{
  {
    init_simple_test("Us_Us_L");
    STRUCT_IF_C Us_Us_L lv;
    check2(sizeof(lv), 12, "sizeof(Us_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_L)");
    check_field_offset(lv, v1, 0, "Us_Us_L.v1");
    check_field_offset(lv, v2, 2, "Us_Us_L.v2");
    check_field_offset(lv, v3, 4, "Us_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_L, Us_Us_L)
//============================================================================



static void Test_Us_Us_S()
{
  {
    init_simple_test("Us_Us_S");
    STRUCT_IF_C Us_Us_S lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_S)");
    check_field_offset(lv, v1, 0, "Us_Us_S.v1");
    check_field_offset(lv, v2, 2, "Us_Us_S.v2");
    check_field_offset(lv, v3, 4, "Us_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_S, Us_Us_S)
//============================================================================



static void Test_Us_Us_Uc()
{
  {
    init_simple_test("Us_Us_Uc");
    STRUCT_IF_C Us_Us_Uc lv;
    check2(sizeof(lv), 5, "sizeof(Us_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_Uc)");
    check_field_offset(lv, v1, 0, "Us_Us_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Us_Uc.v2");
    check_field_offset(lv, v3, 4, "Us_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_Uc, Us_Us_Uc)
//============================================================================



static void Test_Us_Us_Ui()
{
  {
    init_simple_test("Us_Us_Ui");
    STRUCT_IF_C Us_Us_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_Ui)");
    check_field_offset(lv, v1, 0, "Us_Us_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Us_Ui.v2");
    check_field_offset(lv, v3, 4, "Us_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_Ui, Us_Us_Ui)
//============================================================================



static void Test_Us_Us_Ul()
{
  {
    init_simple_test("Us_Us_Ul");
    STRUCT_IF_C Us_Us_Ul lv;
    check2(sizeof(lv), 12, "sizeof(Us_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_Ul)");
    check_field_offset(lv, v1, 0, "Us_Us_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Us_Ul.v2");
    check_field_offset(lv, v3, 4, "Us_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_Ul, Us_Us_Ul)
//============================================================================



static void Test_Us_Us_Us()
{
  {
    init_simple_test("Us_Us_Us");
    STRUCT_IF_C Us_Us_Us lv;
    check2(sizeof(lv), 6, "sizeof(Us_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_Us)");
    check_field_offset(lv, v1, 0, "Us_Us_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Us_Us.v2");
    check_field_offset(lv, v3, 4, "Us_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_Us, Us_Us_Us)
//============================================================================



static void Test_Us_Us_Vp()
{
  {
    init_simple_test("Us_Us_Vp");
    STRUCT_IF_C Us_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Us_Vp)");
    check_field_offset(lv, v1, 0, "Us_Us_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Us_Vp.v2");
    check_field_offset(lv, v3, 4, "Us_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Us_Vp, Us_Us_Vp)
//============================================================================



static void Test_Us_Vp()
{
  {
    init_simple_test("Us_Vp");
    STRUCT_IF_C Us_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp)");
    check_field_offset(lv, v1, 0, "Us_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp, Us_Vp)
//============================================================================



static void Test_Us_Vp_BFu15i()
{
  {
    init_simple_test("Us_Vp_BFu15i");
    static STRUCT_IF_C Us_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Us_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Us_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu15i, Us_Vp_BFu15i)
//============================================================================



static void Test_Us_Vp_BFu15ll()
{
  {
    init_simple_test("Us_Vp_BFu15ll");
    static STRUCT_IF_C Us_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Us_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Us_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu15ll, Us_Vp_BFu15ll)
//============================================================================



static void Test_Us_Vp_BFu15s()
{
  {
    init_simple_test("Us_Vp_BFu15s");
    static STRUCT_IF_C Us_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Us_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Us_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu15s, Us_Vp_BFu15s)
//============================================================================



static void Test_Us_Vp_BFu16i()
{
  {
    init_simple_test("Us_Vp_BFu16i");
    static STRUCT_IF_C Us_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Us_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Us_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu16i, Us_Vp_BFu16i)
//============================================================================



static void Test_Us_Vp_BFu16ll()
{
  {
    init_simple_test("Us_Vp_BFu16ll");
    static STRUCT_IF_C Us_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Us_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Us_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu16ll, Us_Vp_BFu16ll)
//============================================================================



static void Test_Us_Vp_BFu16s()
{
  {
    init_simple_test("Us_Vp_BFu16s");
    static STRUCT_IF_C Us_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Us_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Us_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu16s, Us_Vp_BFu16s)
//============================================================================



static void Test_Us_Vp_BFu17i()
{
  {
    init_simple_test("Us_Vp_BFu17i");
    static STRUCT_IF_C Us_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Us_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Us_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Us_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu17i, Us_Vp_BFu17i)
//============================================================================



static void Test_Us_Vp_BFu17ll()
{
  {
    init_simple_test("Us_Vp_BFu17ll");
    static STRUCT_IF_C Us_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Us_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Us_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Us_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu17ll, Us_Vp_BFu17ll)
//============================================================================



static void Test_Us_Vp_BFu1c()
{
  {
    init_simple_test("Us_Vp_BFu1c");
    static STRUCT_IF_C Us_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu1c, Us_Vp_BFu1c)
//============================================================================



static void Test_Us_Vp_BFu1i()
{
  {
    init_simple_test("Us_Vp_BFu1i");
    static STRUCT_IF_C Us_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu1i, Us_Vp_BFu1i)
//============================================================================



static void Test_Us_Vp_BFu1ll()
{
  {
    init_simple_test("Us_Vp_BFu1ll");
    static STRUCT_IF_C Us_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu1ll, Us_Vp_BFu1ll)
//============================================================================



static void Test_Us_Vp_BFu1s()
{
  {
    init_simple_test("Us_Vp_BFu1s");
    static STRUCT_IF_C Us_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Us_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu1s, Us_Vp_BFu1s)
//============================================================================



static void Test_Us_Vp_BFu31i()
{
  {
    init_simple_test("Us_Vp_BFu31i");
    static STRUCT_IF_C Us_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Us_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Us_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu31i, Us_Vp_BFu31i)
//============================================================================



static void Test_Us_Vp_BFu31ll()
{
  {
    init_simple_test("Us_Vp_BFu31ll");
    static STRUCT_IF_C Us_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Us_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Us_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu31ll, Us_Vp_BFu31ll)
//============================================================================



static void Test_Us_Vp_BFu32i()
{
  {
    init_simple_test("Us_Vp_BFu32i");
    static STRUCT_IF_C Us_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Us_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Us_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu32i, Us_Vp_BFu32i)
//============================================================================



static void Test_Us_Vp_BFu32ll()
{
  {
    init_simple_test("Us_Vp_BFu32ll");
    static STRUCT_IF_C Us_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Us_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Us_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu32ll, Us_Vp_BFu32ll)
//============================================================================



static void Test_Us_Vp_BFu33()
{
  {
    init_simple_test("Us_Vp_BFu33");
    static STRUCT_IF_C Us_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Us_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu33.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Us_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Us_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu33, Us_Vp_BFu33)
//============================================================================



static void Test_Us_Vp_BFu7c()
{
  {
    init_simple_test("Us_Vp_BFu7c");
    static STRUCT_IF_C Us_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu7c, Us_Vp_BFu7c)
//============================================================================



static void Test_Us_Vp_BFu7i()
{
  {
    init_simple_test("Us_Vp_BFu7i");
    static STRUCT_IF_C Us_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu7i, Us_Vp_BFu7i)
//============================================================================



static void Test_Us_Vp_BFu7ll()
{
  {
    init_simple_test("Us_Vp_BFu7ll");
    static STRUCT_IF_C Us_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu7ll, Us_Vp_BFu7ll)
//============================================================================



static void Test_Us_Vp_BFu7s()
{
  {
    init_simple_test("Us_Vp_BFu7s");
    static STRUCT_IF_C Us_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Us_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Us_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu7s, Us_Vp_BFu7s)
//============================================================================



static void Test_Us_Vp_BFu8c()
{
  {
    init_simple_test("Us_Vp_BFu8c");
    static STRUCT_IF_C Us_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu8c, Us_Vp_BFu8c)
//============================================================================



static void Test_Us_Vp_BFu8i()
{
  {
    init_simple_test("Us_Vp_BFu8i");
    static STRUCT_IF_C Us_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu8i, Us_Vp_BFu8i)
//============================================================================



static void Test_Us_Vp_BFu8ll()
{
  {
    init_simple_test("Us_Vp_BFu8ll");
    static STRUCT_IF_C Us_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu8ll, Us_Vp_BFu8ll)
//============================================================================



static void Test_Us_Vp_BFu8s()
{
  {
    init_simple_test("Us_Vp_BFu8s");
    static STRUCT_IF_C Us_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Us_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Us_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu8s, Us_Vp_BFu8s)
//============================================================================



static void Test_Us_Vp_BFu9i()
{
  {
    init_simple_test("Us_Vp_BFu9i");
    static STRUCT_IF_C Us_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Us_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Us_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu9i, Us_Vp_BFu9i)
//============================================================================



static void Test_Us_Vp_BFu9ll()
{
  {
    init_simple_test("Us_Vp_BFu9ll");
    static STRUCT_IF_C Us_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Us_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Us_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu9ll, Us_Vp_BFu9ll)
//============================================================================



static void Test_Us_Vp_BFu9s()
{
  {
    init_simple_test("Us_Vp_BFu9s");
    static STRUCT_IF_C Us_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Us_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Us_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_BFu9s, Us_Vp_BFu9s)
//============================================================================



static void Test_Us_Vp_C()
{
  {
    init_simple_test("Us_Vp_C");
    STRUCT_IF_C Us_Vp_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_C)");
    check_field_offset(lv, v1, 0, "Us_Vp_C.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_C, Us_Vp_C)
//============================================================================



static void Test_Us_Vp_D()
{
  {
    init_simple_test("Us_Vp_D");
    STRUCT_IF_C Us_Vp_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_D)");
    check_field_offset(lv, v1, 0, "Us_Vp_D.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_D, Us_Vp_D)
//============================================================================



static void Test_Us_Vp_F()
{
  {
    init_simple_test("Us_Vp_F");
    STRUCT_IF_C Us_Vp_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_F)");
    check_field_offset(lv, v1, 0, "Us_Vp_F.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_F, Us_Vp_F)
//============================================================================



static void Test_Us_Vp_I()
{
  {
    init_simple_test("Us_Vp_I");
    STRUCT_IF_C Us_Vp_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_I)");
    check_field_offset(lv, v1, 0, "Us_Vp_I.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_I, Us_Vp_I)
//============================================================================



static void Test_Us_Vp_Ip()
{
  {
    init_simple_test("Us_Vp_Ip");
    STRUCT_IF_C Us_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Us_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_Ip)");
    check_field_offset(lv, v1, 0, "Us_Vp_Ip.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_Ip, Us_Vp_Ip)
//============================================================================



static void Test_Us_Vp_L()
{
  {
    init_simple_test("Us_Vp_L");
    STRUCT_IF_C Us_Vp_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_L)");
    check_field_offset(lv, v1, 0, "Us_Vp_L.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_L, Us_Vp_L)
//============================================================================



static void Test_Us_Vp_S()
{
  {
    init_simple_test("Us_Vp_S");
    STRUCT_IF_C Us_Vp_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_S)");
    check_field_offset(lv, v1, 0, "Us_Vp_S.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_S, Us_Vp_S)
//============================================================================



static void Test_Us_Vp_Uc()
{
  {
    init_simple_test("Us_Vp_Uc");
    STRUCT_IF_C Us_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Us_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_Uc)");
    check_field_offset(lv, v1, 0, "Us_Vp_Uc.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_Uc, Us_Vp_Uc)
//============================================================================



static void Test_Us_Vp_Ui()
{
  {
    init_simple_test("Us_Vp_Ui");
    STRUCT_IF_C Us_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Us_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_Ui)");
    check_field_offset(lv, v1, 0, "Us_Vp_Ui.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_Ui, Us_Vp_Ui)
//============================================================================



static void Test_Us_Vp_Ul()
{
  {
    init_simple_test("Us_Vp_Ul");
    STRUCT_IF_C Us_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Us_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_Ul)");
    check_field_offset(lv, v1, 0, "Us_Vp_Ul.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_Ul, Us_Vp_Ul)
//============================================================================



static void Test_Us_Vp_Us()
{
  {
    init_simple_test("Us_Vp_Us");
    STRUCT_IF_C Us_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Us_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_Us)");
    check_field_offset(lv, v1, 0, "Us_Vp_Us.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_Us, Us_Vp_Us)
//============================================================================



static void Test_Us_Vp_Vp()
{
  {
    init_simple_test("Us_Vp_Vp");
    STRUCT_IF_C Us_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Us_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Us_Vp_Vp)");
    check_field_offset(lv, v1, 0, "Us_Vp_Vp.v1");
    check_field_offset(lv, v2, 2, "Us_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "Us_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_Vp_Vp, Us_Vp_Vp)
//============================================================================



static void Test_Vp()
{
  {
    init_simple_test("Vp");
    STRUCT_IF_C Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp)");
    check_field_offset(lv, v1, 0, "Vp.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp, Vp)
//============================================================================



static void Test_Vp_BFu15i()
{
  {
    init_simple_test("Vp_BFu15i");
    static STRUCT_IF_C Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i, Vp_BFu15i)
//============================================================================



static void Test_Vp_BFu15i_BFu15i()
{
  {
    init_simple_test("Vp_BFu15i_BFu15i");
    static STRUCT_IF_C Vp_BFu15i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu15i, Vp_BFu15i_BFu15i)
//============================================================================



static void Test_Vp_BFu15i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu15ll");
    static STRUCT_IF_C Vp_BFu15i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu15ll, Vp_BFu15i_BFu15ll)
//============================================================================



static void Test_Vp_BFu15i_BFu15s()
{
  {
    init_simple_test("Vp_BFu15i_BFu15s");
    static STRUCT_IF_C Vp_BFu15i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu15s, Vp_BFu15i_BFu15s)
//============================================================================



static void Test_Vp_BFu15i_BFu16i()
{
  {
    init_simple_test("Vp_BFu15i_BFu16i");
    static STRUCT_IF_C Vp_BFu15i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu16i, Vp_BFu15i_BFu16i)
//============================================================================



static void Test_Vp_BFu15i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu16ll");
    static STRUCT_IF_C Vp_BFu15i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu16ll, Vp_BFu15i_BFu16ll)
//============================================================================



static void Test_Vp_BFu15i_BFu16s()
{
  {
    init_simple_test("Vp_BFu15i_BFu16s");
    static STRUCT_IF_C Vp_BFu15i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu16s, Vp_BFu15i_BFu16s)
//============================================================================



static void Test_Vp_BFu15i_BFu17i()
{
  {
    init_simple_test("Vp_BFu15i_BFu17i");
    static STRUCT_IF_C Vp_BFu15i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, 1, "Vp_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, hide_ull(1LL<<16), "Vp_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu17i, Vp_BFu15i_BFu17i)
//============================================================================



static void Test_Vp_BFu15i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu17ll");
    static STRUCT_IF_C Vp_BFu15i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, 1, "Vp_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, hide_ull(1LL<<16), "Vp_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu17ll, Vp_BFu15i_BFu17ll)
//============================================================================



static void Test_Vp_BFu15i_BFu1c()
{
  {
    init_simple_test("Vp_BFu15i_BFu1c");
    static STRUCT_IF_C Vp_BFu15i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu1c, Vp_BFu15i_BFu1c)
//============================================================================



static void Test_Vp_BFu15i_BFu1i()
{
  {
    init_simple_test("Vp_BFu15i_BFu1i");
    static STRUCT_IF_C Vp_BFu15i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu1i, Vp_BFu15i_BFu1i)
//============================================================================



static void Test_Vp_BFu15i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu1ll");
    static STRUCT_IF_C Vp_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu1ll, Vp_BFu15i_BFu1ll)
//============================================================================



static void Test_Vp_BFu15i_BFu1s()
{
  {
    init_simple_test("Vp_BFu15i_BFu1s");
    static STRUCT_IF_C Vp_BFu15i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu1s, Vp_BFu15i_BFu1s)
//============================================================================



static void Test_Vp_BFu15i_BFu31i()
{
  {
    init_simple_test("Vp_BFu15i_BFu31i");
    static STRUCT_IF_C Vp_BFu15i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, 1, "Vp_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, hide_ull(1LL<<30), "Vp_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu31i, Vp_BFu15i_BFu31i)
//============================================================================



static void Test_Vp_BFu15i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu31ll");
    static STRUCT_IF_C Vp_BFu15i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, 1, "Vp_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, hide_ull(1LL<<30), "Vp_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu31ll, Vp_BFu15i_BFu31ll)
//============================================================================



static void Test_Vp_BFu15i_BFu32i()
{
  {
    init_simple_test("Vp_BFu15i_BFu32i");
    static STRUCT_IF_C Vp_BFu15i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, 1, "Vp_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, hide_ull(1LL<<31), "Vp_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu32i, Vp_BFu15i_BFu32i)
//============================================================================



static void Test_Vp_BFu15i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu32ll");
    static STRUCT_IF_C Vp_BFu15i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, 1, "Vp_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, hide_ull(1LL<<31), "Vp_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu32ll, Vp_BFu15i_BFu32ll)
//============================================================================



static void Test_Vp_BFu15i_BFu33()
{
  {
    init_simple_test("Vp_BFu15i_BFu33");
    static STRUCT_IF_C Vp_BFu15i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 33, 1, "Vp_BFu15i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 33, hide_ull(1LL<<32), "Vp_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu33, Vp_BFu15i_BFu33)
//============================================================================



static void Test_Vp_BFu15i_BFu7c()
{
  {
    init_simple_test("Vp_BFu15i_BFu7c");
    static STRUCT_IF_C Vp_BFu15i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu7c, Vp_BFu15i_BFu7c)
//============================================================================



static void Test_Vp_BFu15i_BFu7i()
{
  {
    init_simple_test("Vp_BFu15i_BFu7i");
    static STRUCT_IF_C Vp_BFu15i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu7i, Vp_BFu15i_BFu7i)
//============================================================================



static void Test_Vp_BFu15i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu7ll");
    static STRUCT_IF_C Vp_BFu15i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu7ll, Vp_BFu15i_BFu7ll)
//============================================================================



static void Test_Vp_BFu15i_BFu7s()
{
  {
    init_simple_test("Vp_BFu15i_BFu7s");
    static STRUCT_IF_C Vp_BFu15i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu7s, Vp_BFu15i_BFu7s)
//============================================================================



static void Test_Vp_BFu15i_BFu8c()
{
  {
    init_simple_test("Vp_BFu15i_BFu8c");
    static STRUCT_IF_C Vp_BFu15i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu8c, Vp_BFu15i_BFu8c)
//============================================================================



static void Test_Vp_BFu15i_BFu8i()
{
  {
    init_simple_test("Vp_BFu15i_BFu8i");
    static STRUCT_IF_C Vp_BFu15i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu8i, Vp_BFu15i_BFu8i)
//============================================================================



static void Test_Vp_BFu15i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu8ll");
    static STRUCT_IF_C Vp_BFu15i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu8ll, Vp_BFu15i_BFu8ll)
//============================================================================



static void Test_Vp_BFu15i_BFu8s()
{
  {
    init_simple_test("Vp_BFu15i_BFu8s");
    static STRUCT_IF_C Vp_BFu15i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu8s, Vp_BFu15i_BFu8s)
//============================================================================



static void Test_Vp_BFu15i_BFu9i()
{
  {
    init_simple_test("Vp_BFu15i_BFu9i");
    static STRUCT_IF_C Vp_BFu15i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu9i, Vp_BFu15i_BFu9i)
//============================================================================



static void Test_Vp_BFu15i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu15i_BFu9ll");
    static STRUCT_IF_C Vp_BFu15i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu9ll, Vp_BFu15i_BFu9ll)
//============================================================================



static void Test_Vp_BFu15i_BFu9s()
{
  {
    init_simple_test("Vp_BFu15i_BFu9s");
    static STRUCT_IF_C Vp_BFu15i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_BFu9s, Vp_BFu15i_BFu9s)
//============================================================================



static void Test_Vp_BFu15i_C()
{
  {
    init_simple_test("Vp_BFu15i_C");
    static STRUCT_IF_C Vp_BFu15i_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_C, Vp_BFu15i_C)
//============================================================================



static void Test_Vp_BFu15i_D()
{
  {
    init_simple_test("Vp_BFu15i_D");
    static STRUCT_IF_C Vp_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_D, Vp_BFu15i_D)
//============================================================================



static void Test_Vp_BFu15i_F()
{
  {
    init_simple_test("Vp_BFu15i_F");
    static STRUCT_IF_C Vp_BFu15i_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_F, Vp_BFu15i_F)
//============================================================================



static void Test_Vp_BFu15i_I()
{
  {
    init_simple_test("Vp_BFu15i_I");
    static STRUCT_IF_C Vp_BFu15i_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_I, Vp_BFu15i_I)
//============================================================================



static void Test_Vp_BFu15i_Ip()
{
  {
    init_simple_test("Vp_BFu15i_Ip");
    static STRUCT_IF_C Vp_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_Ip, Vp_BFu15i_Ip)
//============================================================================



static void Test_Vp_BFu15i_L()
{
  {
    init_simple_test("Vp_BFu15i_L");
    static STRUCT_IF_C Vp_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_L, Vp_BFu15i_L)
//============================================================================



static void Test_Vp_BFu15i_S()
{
  {
    init_simple_test("Vp_BFu15i_S");
    static STRUCT_IF_C Vp_BFu15i_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_S, Vp_BFu15i_S)
//============================================================================



static void Test_Vp_BFu15i_Uc()
{
  {
    init_simple_test("Vp_BFu15i_Uc");
    static STRUCT_IF_C Vp_BFu15i_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_Uc, Vp_BFu15i_Uc)
//============================================================================



static void Test_Vp_BFu15i_Ui()
{
  {
    init_simple_test("Vp_BFu15i_Ui");
    static STRUCT_IF_C Vp_BFu15i_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_Ui, Vp_BFu15i_Ui)
//============================================================================



static void Test_Vp_BFu15i_Ul()
{
  {
    init_simple_test("Vp_BFu15i_Ul");
    static STRUCT_IF_C Vp_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_Ul, Vp_BFu15i_Ul)
//============================================================================



static void Test_Vp_BFu15i_Us()
{
  {
    init_simple_test("Vp_BFu15i_Us");
    static STRUCT_IF_C Vp_BFu15i_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_Us, Vp_BFu15i_Us)
//============================================================================



static void Test_Vp_BFu15i_Vp()
{
  {
    init_simple_test("Vp_BFu15i_Vp");
    static STRUCT_IF_C Vp_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15i_Vp, Vp_BFu15i_Vp)
//============================================================================



static void Test_Vp_BFu15ll()
{
  {
    init_simple_test("Vp_BFu15ll");
    static STRUCT_IF_C Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll, Vp_BFu15ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu15i");
    static STRUCT_IF_C Vp_BFu15ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu15i, Vp_BFu15ll_BFu15i)
//============================================================================



static void Test_Vp_BFu15ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu15ll, Vp_BFu15ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu15ll_BFu15s");
    static STRUCT_IF_C Vp_BFu15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu15s, Vp_BFu15ll_BFu15s)
//============================================================================



static void Test_Vp_BFu15ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu16i");
    static STRUCT_IF_C Vp_BFu15ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu16i, Vp_BFu15ll_BFu16i)
//============================================================================



static void Test_Vp_BFu15ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu16ll, Vp_BFu15ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu15ll_BFu16s");
    static STRUCT_IF_C Vp_BFu15ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu16s, Vp_BFu15ll_BFu16s)
//============================================================================



static void Test_Vp_BFu15ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu17i");
    static STRUCT_IF_C Vp_BFu15ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, 1, "Vp_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, hide_ull(1LL<<16), "Vp_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu17i, Vp_BFu15ll_BFu17i)
//============================================================================



static void Test_Vp_BFu15ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, 1, "Vp_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, hide_ull(1LL<<16), "Vp_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu17ll, Vp_BFu15ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu15ll_BFu1c");
    static STRUCT_IF_C Vp_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu1c, Vp_BFu15ll_BFu1c)
//============================================================================



static void Test_Vp_BFu15ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu1i");
    static STRUCT_IF_C Vp_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu1i, Vp_BFu15ll_BFu1i)
//============================================================================



static void Test_Vp_BFu15ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu1ll, Vp_BFu15ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu15ll_BFu1s");
    static STRUCT_IF_C Vp_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu1s, Vp_BFu15ll_BFu1s)
//============================================================================



static void Test_Vp_BFu15ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu31i");
    static STRUCT_IF_C Vp_BFu15ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, 1, "Vp_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, hide_ull(1LL<<30), "Vp_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu31i, Vp_BFu15ll_BFu31i)
//============================================================================



static void Test_Vp_BFu15ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, 1, "Vp_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, hide_ull(1LL<<30), "Vp_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu31ll, Vp_BFu15ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu32i");
    static STRUCT_IF_C Vp_BFu15ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, 1, "Vp_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, hide_ull(1LL<<31), "Vp_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu32i, Vp_BFu15ll_BFu32i)
//============================================================================



static void Test_Vp_BFu15ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, 1, "Vp_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, hide_ull(1LL<<31), "Vp_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu32ll, Vp_BFu15ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu33()
{
  {
    init_simple_test("Vp_BFu15ll_BFu33");
    static STRUCT_IF_C Vp_BFu15ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 33, 1, "Vp_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 33, hide_ull(1LL<<32), "Vp_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu33, Vp_BFu15ll_BFu33)
//============================================================================



static void Test_Vp_BFu15ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu15ll_BFu7c");
    static STRUCT_IF_C Vp_BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu7c, Vp_BFu15ll_BFu7c)
//============================================================================



static void Test_Vp_BFu15ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu7i");
    static STRUCT_IF_C Vp_BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu7i, Vp_BFu15ll_BFu7i)
//============================================================================



static void Test_Vp_BFu15ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu7ll, Vp_BFu15ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu15ll_BFu7s");
    static STRUCT_IF_C Vp_BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu7s, Vp_BFu15ll_BFu7s)
//============================================================================



static void Test_Vp_BFu15ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu15ll_BFu8c");
    static STRUCT_IF_C Vp_BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu8c, Vp_BFu15ll_BFu8c)
//============================================================================



static void Test_Vp_BFu15ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu8i");
    static STRUCT_IF_C Vp_BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu8i, Vp_BFu15ll_BFu8i)
//============================================================================



static void Test_Vp_BFu15ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu8ll, Vp_BFu15ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu15ll_BFu8s");
    static STRUCT_IF_C Vp_BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu8s, Vp_BFu15ll_BFu8s)
//============================================================================



static void Test_Vp_BFu15ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu15ll_BFu9i");
    static STRUCT_IF_C Vp_BFu15ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu9i, Vp_BFu15ll_BFu9i)
//============================================================================



static void Test_Vp_BFu15ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu15ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu9ll, Vp_BFu15ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu15ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu15ll_BFu9s");
    static STRUCT_IF_C Vp_BFu15ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_BFu9s, Vp_BFu15ll_BFu9s)
//============================================================================



static void Test_Vp_BFu15ll_C()
{
  {
    init_simple_test("Vp_BFu15ll_C");
    static STRUCT_IF_C Vp_BFu15ll_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_C, Vp_BFu15ll_C)
//============================================================================



static void Test_Vp_BFu15ll_D()
{
  {
    init_simple_test("Vp_BFu15ll_D");
    static STRUCT_IF_C Vp_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_D, Vp_BFu15ll_D)
//============================================================================



static void Test_Vp_BFu15ll_F()
{
  {
    init_simple_test("Vp_BFu15ll_F");
    static STRUCT_IF_C Vp_BFu15ll_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_F, Vp_BFu15ll_F)
//============================================================================



static void Test_Vp_BFu15ll_I()
{
  {
    init_simple_test("Vp_BFu15ll_I");
    static STRUCT_IF_C Vp_BFu15ll_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_I, Vp_BFu15ll_I)
//============================================================================



static void Test_Vp_BFu15ll_Ip()
{
  {
    init_simple_test("Vp_BFu15ll_Ip");
    static STRUCT_IF_C Vp_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_Ip, Vp_BFu15ll_Ip)
//============================================================================



static void Test_Vp_BFu15ll_L()
{
  {
    init_simple_test("Vp_BFu15ll_L");
    static STRUCT_IF_C Vp_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_L, Vp_BFu15ll_L)
//============================================================================



static void Test_Vp_BFu15ll_S()
{
  {
    init_simple_test("Vp_BFu15ll_S");
    static STRUCT_IF_C Vp_BFu15ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_S, Vp_BFu15ll_S)
//============================================================================



static void Test_Vp_BFu15ll_Uc()
{
  {
    init_simple_test("Vp_BFu15ll_Uc");
    static STRUCT_IF_C Vp_BFu15ll_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_Uc, Vp_BFu15ll_Uc)
//============================================================================



static void Test_Vp_BFu15ll_Ui()
{
  {
    init_simple_test("Vp_BFu15ll_Ui");
    static STRUCT_IF_C Vp_BFu15ll_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_Ui, Vp_BFu15ll_Ui)
//============================================================================



static void Test_Vp_BFu15ll_Ul()
{
  {
    init_simple_test("Vp_BFu15ll_Ul");
    static STRUCT_IF_C Vp_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_Ul, Vp_BFu15ll_Ul)
//============================================================================



static void Test_Vp_BFu15ll_Us()
{
  {
    init_simple_test("Vp_BFu15ll_Us");
    static STRUCT_IF_C Vp_BFu15ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_Us, Vp_BFu15ll_Us)
//============================================================================



static void Test_Vp_BFu15ll_Vp()
{
  {
    init_simple_test("Vp_BFu15ll_Vp");
    static STRUCT_IF_C Vp_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15ll_Vp, Vp_BFu15ll_Vp)
//============================================================================



static void Test_Vp_BFu15s()
{
  {
    init_simple_test("Vp_BFu15s");
    static STRUCT_IF_C Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s, Vp_BFu15s)
//============================================================================



static void Test_Vp_BFu15s_BFu15i()
{
  {
    init_simple_test("Vp_BFu15s_BFu15i");
    static STRUCT_IF_C Vp_BFu15s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu15i, Vp_BFu15s_BFu15i)
//============================================================================



static void Test_Vp_BFu15s_BFu15ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu15ll");
    static STRUCT_IF_C Vp_BFu15s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu15ll, Vp_BFu15s_BFu15ll)
//============================================================================



static void Test_Vp_BFu15s_BFu15s()
{
  {
    init_simple_test("Vp_BFu15s_BFu15s");
    static STRUCT_IF_C Vp_BFu15s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, 1, "Vp_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu15s, Vp_BFu15s_BFu15s)
//============================================================================



static void Test_Vp_BFu15s_BFu16i()
{
  {
    init_simple_test("Vp_BFu15s_BFu16i");
    static STRUCT_IF_C Vp_BFu15s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu16i, Vp_BFu15s_BFu16i)
//============================================================================



static void Test_Vp_BFu15s_BFu16ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu16ll");
    static STRUCT_IF_C Vp_BFu15s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu16ll, Vp_BFu15s_BFu16ll)
//============================================================================



static void Test_Vp_BFu15s_BFu16s()
{
  {
    init_simple_test("Vp_BFu15s_BFu16s");
    static STRUCT_IF_C Vp_BFu15s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, 1, "Vp_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 16, hide_ull(1LL<<15), "Vp_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu16s, Vp_BFu15s_BFu16s)
//============================================================================



static void Test_Vp_BFu15s_BFu17i()
{
  {
    init_simple_test("Vp_BFu15s_BFu17i");
    static STRUCT_IF_C Vp_BFu15s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, 1, "Vp_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, hide_ull(1LL<<16), "Vp_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu17i, Vp_BFu15s_BFu17i)
//============================================================================



static void Test_Vp_BFu15s_BFu17ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu17ll");
    static STRUCT_IF_C Vp_BFu15s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, 1, "Vp_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 17, hide_ull(1LL<<16), "Vp_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu17ll, Vp_BFu15s_BFu17ll)
//============================================================================



static void Test_Vp_BFu15s_BFu1c()
{
  {
    init_simple_test("Vp_BFu15s_BFu1c");
    static STRUCT_IF_C Vp_BFu15s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu1c, Vp_BFu15s_BFu1c)
//============================================================================



static void Test_Vp_BFu15s_BFu1i()
{
  {
    init_simple_test("Vp_BFu15s_BFu1i");
    static STRUCT_IF_C Vp_BFu15s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu1i, Vp_BFu15s_BFu1i)
//============================================================================



static void Test_Vp_BFu15s_BFu1ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu1ll");
    static STRUCT_IF_C Vp_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu1ll, Vp_BFu15s_BFu1ll)
//============================================================================



static void Test_Vp_BFu15s_BFu1s()
{
  {
    init_simple_test("Vp_BFu15s_BFu1s");
    static STRUCT_IF_C Vp_BFu15s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 1, 1, "Vp_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu1s, Vp_BFu15s_BFu1s)
//============================================================================



static void Test_Vp_BFu15s_BFu31i()
{
  {
    init_simple_test("Vp_BFu15s_BFu31i");
    static STRUCT_IF_C Vp_BFu15s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, 1, "Vp_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, hide_ull(1LL<<30), "Vp_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu31i, Vp_BFu15s_BFu31i)
//============================================================================



static void Test_Vp_BFu15s_BFu31ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu31ll");
    static STRUCT_IF_C Vp_BFu15s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, 1, "Vp_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 31, hide_ull(1LL<<30), "Vp_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu31ll, Vp_BFu15s_BFu31ll)
//============================================================================



static void Test_Vp_BFu15s_BFu32i()
{
  {
    init_simple_test("Vp_BFu15s_BFu32i");
    static STRUCT_IF_C Vp_BFu15s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, 1, "Vp_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, hide_ull(1LL<<31), "Vp_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu32i, Vp_BFu15s_BFu32i)
//============================================================================



static void Test_Vp_BFu15s_BFu32ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu32ll");
    static STRUCT_IF_C Vp_BFu15s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, 1, "Vp_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 32, hide_ull(1LL<<31), "Vp_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu32ll, Vp_BFu15s_BFu32ll)
//============================================================================



static void Test_Vp_BFu15s_BFu33()
{
  {
    init_simple_test("Vp_BFu15s_BFu33");
    static STRUCT_IF_C Vp_BFu15s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 33, 1, "Vp_BFu15s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 33, hide_ull(1LL<<32), "Vp_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu33, Vp_BFu15s_BFu33)
//============================================================================



static void Test_Vp_BFu15s_BFu7c()
{
  {
    init_simple_test("Vp_BFu15s_BFu7c");
    static STRUCT_IF_C Vp_BFu15s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu7c, Vp_BFu15s_BFu7c)
//============================================================================



static void Test_Vp_BFu15s_BFu7i()
{
  {
    init_simple_test("Vp_BFu15s_BFu7i");
    static STRUCT_IF_C Vp_BFu15s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu7i, Vp_BFu15s_BFu7i)
//============================================================================



static void Test_Vp_BFu15s_BFu7ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu7ll");
    static STRUCT_IF_C Vp_BFu15s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu7ll, Vp_BFu15s_BFu7ll)
//============================================================================



static void Test_Vp_BFu15s_BFu7s()
{
  {
    init_simple_test("Vp_BFu15s_BFu7s");
    static STRUCT_IF_C Vp_BFu15s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, 1, "Vp_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 7, hide_ull(1LL<<6), "Vp_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu7s, Vp_BFu15s_BFu7s)
//============================================================================



static void Test_Vp_BFu15s_BFu8c()
{
  {
    init_simple_test("Vp_BFu15s_BFu8c");
    static STRUCT_IF_C Vp_BFu15s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu8c, Vp_BFu15s_BFu8c)
//============================================================================



static void Test_Vp_BFu15s_BFu8i()
{
  {
    init_simple_test("Vp_BFu15s_BFu8i");
    static STRUCT_IF_C Vp_BFu15s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu8i, Vp_BFu15s_BFu8i)
//============================================================================



static void Test_Vp_BFu15s_BFu8ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu8ll");
    static STRUCT_IF_C Vp_BFu15s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu8ll, Vp_BFu15s_BFu8ll)
//============================================================================



static void Test_Vp_BFu15s_BFu8s()
{
  {
    init_simple_test("Vp_BFu15s_BFu8s");
    static STRUCT_IF_C Vp_BFu15s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, 1, "Vp_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 8, hide_ull(1LL<<7), "Vp_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu8s, Vp_BFu15s_BFu8s)
//============================================================================



static void Test_Vp_BFu15s_BFu9i()
{
  {
    init_simple_test("Vp_BFu15s_BFu9i");
    static STRUCT_IF_C Vp_BFu15s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu9i, Vp_BFu15s_BFu9i)
//============================================================================



static void Test_Vp_BFu15s_BFu9ll()
{
  {
    init_simple_test("Vp_BFu15s_BFu9ll");
    static STRUCT_IF_C Vp_BFu15s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu9ll, Vp_BFu15s_BFu9ll)
//============================================================================



static void Test_Vp_BFu15s_BFu9s()
{
  {
    init_simple_test("Vp_BFu15s_BFu9s");
    static STRUCT_IF_C Vp_BFu15s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, 1, "Vp_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 7, 9, hide_ull(1LL<<8), "Vp_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_BFu9s, Vp_BFu15s_BFu9s)
//============================================================================



static void Test_Vp_BFu15s_C()
{
  {
    init_simple_test("Vp_BFu15s_C");
    static STRUCT_IF_C Vp_BFu15s_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_C, Vp_BFu15s_C)
//============================================================================



static void Test_Vp_BFu15s_D()
{
  {
    init_simple_test("Vp_BFu15s_D");
    static STRUCT_IF_C Vp_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_D, Vp_BFu15s_D)
//============================================================================



static void Test_Vp_BFu15s_F()
{
  {
    init_simple_test("Vp_BFu15s_F");
    static STRUCT_IF_C Vp_BFu15s_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_F, Vp_BFu15s_F)
//============================================================================



static void Test_Vp_BFu15s_I()
{
  {
    init_simple_test("Vp_BFu15s_I");
    static STRUCT_IF_C Vp_BFu15s_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_I, Vp_BFu15s_I)
//============================================================================



static void Test_Vp_BFu15s_Ip()
{
  {
    init_simple_test("Vp_BFu15s_Ip");
    static STRUCT_IF_C Vp_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_Ip, Vp_BFu15s_Ip)
//============================================================================



static void Test_Vp_BFu15s_L()
{
  {
    init_simple_test("Vp_BFu15s_L");
    static STRUCT_IF_C Vp_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_L, Vp_BFu15s_L)
//============================================================================



static void Test_Vp_BFu15s_S()
{
  {
    init_simple_test("Vp_BFu15s_S");
    static STRUCT_IF_C Vp_BFu15s_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_S, Vp_BFu15s_S)
//============================================================================



static void Test_Vp_BFu15s_Uc()
{
  {
    init_simple_test("Vp_BFu15s_Uc");
    static STRUCT_IF_C Vp_BFu15s_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_Uc, Vp_BFu15s_Uc)
//============================================================================



static void Test_Vp_BFu15s_Ui()
{
  {
    init_simple_test("Vp_BFu15s_Ui");
    static STRUCT_IF_C Vp_BFu15s_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_Ui, Vp_BFu15s_Ui)
//============================================================================



static void Test_Vp_BFu15s_Ul()
{
  {
    init_simple_test("Vp_BFu15s_Ul");
    static STRUCT_IF_C Vp_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_Ul, Vp_BFu15s_Ul)
//============================================================================



static void Test_Vp_BFu15s_Us()
{
  {
    init_simple_test("Vp_BFu15s_Us");
    static STRUCT_IF_C Vp_BFu15s_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_Us, Vp_BFu15s_Us)
//============================================================================



static void Test_Vp_BFu15s_Vp()
{
  {
    init_simple_test("Vp_BFu15s_Vp");
    static STRUCT_IF_C Vp_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Vp_BFu15s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Vp_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu15s_Vp, Vp_BFu15s_Vp)
//============================================================================



static void Test_Vp_BFu16i()
{
  {
    init_simple_test("Vp_BFu16i");
    static STRUCT_IF_C Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i, Vp_BFu16i)
//============================================================================



static void Test_Vp_BFu16i_BFu15i()
{
  {
    init_simple_test("Vp_BFu16i_BFu15i");
    static STRUCT_IF_C Vp_BFu16i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu15i, Vp_BFu16i_BFu15i)
//============================================================================



static void Test_Vp_BFu16i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu15ll");
    static STRUCT_IF_C Vp_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu15ll, Vp_BFu16i_BFu15ll)
//============================================================================



static void Test_Vp_BFu16i_BFu15s()
{
  {
    init_simple_test("Vp_BFu16i_BFu15s");
    static STRUCT_IF_C Vp_BFu16i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu15s, Vp_BFu16i_BFu15s)
//============================================================================



static void Test_Vp_BFu16i_BFu16i()
{
  {
    init_simple_test("Vp_BFu16i_BFu16i");
    static STRUCT_IF_C Vp_BFu16i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu16i, Vp_BFu16i_BFu16i)
//============================================================================



static void Test_Vp_BFu16i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu16ll");
    static STRUCT_IF_C Vp_BFu16i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu16ll, Vp_BFu16i_BFu16ll)
//============================================================================



static void Test_Vp_BFu16i_BFu16s()
{
  {
    init_simple_test("Vp_BFu16i_BFu16s");
    static STRUCT_IF_C Vp_BFu16i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu16s, Vp_BFu16i_BFu16s)
//============================================================================



static void Test_Vp_BFu16i_BFu17i()
{
  {
    init_simple_test("Vp_BFu16i_BFu17i");
    static STRUCT_IF_C Vp_BFu16i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Vp_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Vp_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu17i, Vp_BFu16i_BFu17i)
//============================================================================



static void Test_Vp_BFu16i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu17ll");
    static STRUCT_IF_C Vp_BFu16i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Vp_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Vp_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu17ll, Vp_BFu16i_BFu17ll)
//============================================================================



static void Test_Vp_BFu16i_BFu1c()
{
  {
    init_simple_test("Vp_BFu16i_BFu1c");
    static STRUCT_IF_C Vp_BFu16i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu1c, Vp_BFu16i_BFu1c)
//============================================================================



static void Test_Vp_BFu16i_BFu1i()
{
  {
    init_simple_test("Vp_BFu16i_BFu1i");
    static STRUCT_IF_C Vp_BFu16i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu1i, Vp_BFu16i_BFu1i)
//============================================================================



static void Test_Vp_BFu16i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu1ll");
    static STRUCT_IF_C Vp_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu1ll, Vp_BFu16i_BFu1ll)
//============================================================================



static void Test_Vp_BFu16i_BFu1s()
{
  {
    init_simple_test("Vp_BFu16i_BFu1s");
    static STRUCT_IF_C Vp_BFu16i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu1s, Vp_BFu16i_BFu1s)
//============================================================================



static void Test_Vp_BFu16i_BFu31i()
{
  {
    init_simple_test("Vp_BFu16i_BFu31i");
    static STRUCT_IF_C Vp_BFu16i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Vp_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Vp_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu31i, Vp_BFu16i_BFu31i)
//============================================================================



static void Test_Vp_BFu16i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu31ll");
    static STRUCT_IF_C Vp_BFu16i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Vp_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Vp_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu31ll, Vp_BFu16i_BFu31ll)
//============================================================================



static void Test_Vp_BFu16i_BFu32i()
{
  {
    init_simple_test("Vp_BFu16i_BFu32i");
    static STRUCT_IF_C Vp_BFu16i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Vp_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Vp_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu32i, Vp_BFu16i_BFu32i)
//============================================================================



static void Test_Vp_BFu16i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu32ll");
    static STRUCT_IF_C Vp_BFu16i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Vp_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Vp_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu32ll, Vp_BFu16i_BFu32ll)
//============================================================================



static void Test_Vp_BFu16i_BFu33()
{
  {
    init_simple_test("Vp_BFu16i_BFu33");
    static STRUCT_IF_C Vp_BFu16i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Vp_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Vp_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu33, Vp_BFu16i_BFu33)
//============================================================================



static void Test_Vp_BFu16i_BFu7c()
{
  {
    init_simple_test("Vp_BFu16i_BFu7c");
    static STRUCT_IF_C Vp_BFu16i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu7c, Vp_BFu16i_BFu7c)
//============================================================================



static void Test_Vp_BFu16i_BFu7i()
{
  {
    init_simple_test("Vp_BFu16i_BFu7i");
    static STRUCT_IF_C Vp_BFu16i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu7i, Vp_BFu16i_BFu7i)
//============================================================================



static void Test_Vp_BFu16i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu7ll");
    static STRUCT_IF_C Vp_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu7ll, Vp_BFu16i_BFu7ll)
//============================================================================



static void Test_Vp_BFu16i_BFu7s()
{
  {
    init_simple_test("Vp_BFu16i_BFu7s");
    static STRUCT_IF_C Vp_BFu16i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu7s, Vp_BFu16i_BFu7s)
//============================================================================



static void Test_Vp_BFu16i_BFu8c()
{
  {
    init_simple_test("Vp_BFu16i_BFu8c");
    static STRUCT_IF_C Vp_BFu16i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu8c, Vp_BFu16i_BFu8c)
//============================================================================



static void Test_Vp_BFu16i_BFu8i()
{
  {
    init_simple_test("Vp_BFu16i_BFu8i");
    static STRUCT_IF_C Vp_BFu16i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu8i, Vp_BFu16i_BFu8i)
//============================================================================



static void Test_Vp_BFu16i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu8ll");
    static STRUCT_IF_C Vp_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu8ll, Vp_BFu16i_BFu8ll)
//============================================================================



static void Test_Vp_BFu16i_BFu8s()
{
  {
    init_simple_test("Vp_BFu16i_BFu8s");
    static STRUCT_IF_C Vp_BFu16i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu8s, Vp_BFu16i_BFu8s)
//============================================================================



static void Test_Vp_BFu16i_BFu9i()
{
  {
    init_simple_test("Vp_BFu16i_BFu9i");
    static STRUCT_IF_C Vp_BFu16i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu9i, Vp_BFu16i_BFu9i)
//============================================================================



static void Test_Vp_BFu16i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu16i_BFu9ll");
    static STRUCT_IF_C Vp_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu9ll, Vp_BFu16i_BFu9ll)
//============================================================================



static void Test_Vp_BFu16i_BFu9s()
{
  {
    init_simple_test("Vp_BFu16i_BFu9s");
    static STRUCT_IF_C Vp_BFu16i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_BFu9s, Vp_BFu16i_BFu9s)
//============================================================================



static void Test_Vp_BFu16i_C()
{
  {
    init_simple_test("Vp_BFu16i_C");
    static STRUCT_IF_C Vp_BFu16i_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_C, Vp_BFu16i_C)
//============================================================================



static void Test_Vp_BFu16i_D()
{
  {
    init_simple_test("Vp_BFu16i_D");
    static STRUCT_IF_C Vp_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_D, Vp_BFu16i_D)
//============================================================================



static void Test_Vp_BFu16i_F()
{
  {
    init_simple_test("Vp_BFu16i_F");
    static STRUCT_IF_C Vp_BFu16i_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_F, Vp_BFu16i_F)
//============================================================================



static void Test_Vp_BFu16i_I()
{
  {
    init_simple_test("Vp_BFu16i_I");
    static STRUCT_IF_C Vp_BFu16i_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_I, Vp_BFu16i_I)
//============================================================================



static void Test_Vp_BFu16i_Ip()
{
  {
    init_simple_test("Vp_BFu16i_Ip");
    static STRUCT_IF_C Vp_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_Ip, Vp_BFu16i_Ip)
//============================================================================



static void Test_Vp_BFu16i_L()
{
  {
    init_simple_test("Vp_BFu16i_L");
    static STRUCT_IF_C Vp_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_L, Vp_BFu16i_L)
//============================================================================



static void Test_Vp_BFu16i_S()
{
  {
    init_simple_test("Vp_BFu16i_S");
    static STRUCT_IF_C Vp_BFu16i_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_S, Vp_BFu16i_S)
//============================================================================



static void Test_Vp_BFu16i_Uc()
{
  {
    init_simple_test("Vp_BFu16i_Uc");
    static STRUCT_IF_C Vp_BFu16i_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_Uc, Vp_BFu16i_Uc)
//============================================================================



static void Test_Vp_BFu16i_Ui()
{
  {
    init_simple_test("Vp_BFu16i_Ui");
    static STRUCT_IF_C Vp_BFu16i_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_Ui, Vp_BFu16i_Ui)
//============================================================================



static void Test_Vp_BFu16i_Ul()
{
  {
    init_simple_test("Vp_BFu16i_Ul");
    static STRUCT_IF_C Vp_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_Ul, Vp_BFu16i_Ul)
//============================================================================



static void Test_Vp_BFu16i_Us()
{
  {
    init_simple_test("Vp_BFu16i_Us");
    static STRUCT_IF_C Vp_BFu16i_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_Us, Vp_BFu16i_Us)
//============================================================================



static void Test_Vp_BFu16i_Vp()
{
  {
    init_simple_test("Vp_BFu16i_Vp");
    static STRUCT_IF_C Vp_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16i_Vp, Vp_BFu16i_Vp)
//============================================================================



static void Test_Vp_BFu16ll()
{
  {
    init_simple_test("Vp_BFu16ll");
    static STRUCT_IF_C Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll, Vp_BFu16ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu15i");
    static STRUCT_IF_C Vp_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu15i, Vp_BFu16ll_BFu15i)
//============================================================================



static void Test_Vp_BFu16ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu15ll, Vp_BFu16ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu16ll_BFu15s");
    static STRUCT_IF_C Vp_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu15s, Vp_BFu16ll_BFu15s)
//============================================================================



static void Test_Vp_BFu16ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu16i");
    static STRUCT_IF_C Vp_BFu16ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu16i, Vp_BFu16ll_BFu16i)
//============================================================================



static void Test_Vp_BFu16ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu16ll, Vp_BFu16ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu16ll_BFu16s");
    static STRUCT_IF_C Vp_BFu16ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu16s, Vp_BFu16ll_BFu16s)
//============================================================================



static void Test_Vp_BFu16ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu17i");
    static STRUCT_IF_C Vp_BFu16ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Vp_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Vp_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu17i, Vp_BFu16ll_BFu17i)
//============================================================================



static void Test_Vp_BFu16ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Vp_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Vp_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu17ll, Vp_BFu16ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu16ll_BFu1c");
    static STRUCT_IF_C Vp_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu1c, Vp_BFu16ll_BFu1c)
//============================================================================



static void Test_Vp_BFu16ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu1i");
    static STRUCT_IF_C Vp_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu1i, Vp_BFu16ll_BFu1i)
//============================================================================



static void Test_Vp_BFu16ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu1ll, Vp_BFu16ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu16ll_BFu1s");
    static STRUCT_IF_C Vp_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu1s, Vp_BFu16ll_BFu1s)
//============================================================================



static void Test_Vp_BFu16ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu31i");
    static STRUCT_IF_C Vp_BFu16ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Vp_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Vp_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu31i, Vp_BFu16ll_BFu31i)
//============================================================================



static void Test_Vp_BFu16ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Vp_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Vp_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu31ll, Vp_BFu16ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu32i");
    static STRUCT_IF_C Vp_BFu16ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Vp_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Vp_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu32i, Vp_BFu16ll_BFu32i)
//============================================================================



static void Test_Vp_BFu16ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Vp_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Vp_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu32ll, Vp_BFu16ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu33()
{
  {
    init_simple_test("Vp_BFu16ll_BFu33");
    static STRUCT_IF_C Vp_BFu16ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Vp_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Vp_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu33, Vp_BFu16ll_BFu33)
//============================================================================



static void Test_Vp_BFu16ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu16ll_BFu7c");
    static STRUCT_IF_C Vp_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu7c, Vp_BFu16ll_BFu7c)
//============================================================================



static void Test_Vp_BFu16ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu7i");
    static STRUCT_IF_C Vp_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu7i, Vp_BFu16ll_BFu7i)
//============================================================================



static void Test_Vp_BFu16ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu7ll, Vp_BFu16ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu16ll_BFu7s");
    static STRUCT_IF_C Vp_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu7s, Vp_BFu16ll_BFu7s)
//============================================================================



static void Test_Vp_BFu16ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu16ll_BFu8c");
    static STRUCT_IF_C Vp_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu8c, Vp_BFu16ll_BFu8c)
//============================================================================



static void Test_Vp_BFu16ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu8i");
    static STRUCT_IF_C Vp_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu8i, Vp_BFu16ll_BFu8i)
//============================================================================



static void Test_Vp_BFu16ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu8ll, Vp_BFu16ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu16ll_BFu8s");
    static STRUCT_IF_C Vp_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu8s, Vp_BFu16ll_BFu8s)
//============================================================================



static void Test_Vp_BFu16ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu16ll_BFu9i");
    static STRUCT_IF_C Vp_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu9i, Vp_BFu16ll_BFu9i)
//============================================================================



static void Test_Vp_BFu16ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu16ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu9ll, Vp_BFu16ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu16ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu16ll_BFu9s");
    static STRUCT_IF_C Vp_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_BFu9s, Vp_BFu16ll_BFu9s)
//============================================================================



static void Test_Vp_BFu16ll_C()
{
  {
    init_simple_test("Vp_BFu16ll_C");
    static STRUCT_IF_C Vp_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_C, Vp_BFu16ll_C)
//============================================================================



static void Test_Vp_BFu16ll_D()
{
  {
    init_simple_test("Vp_BFu16ll_D");
    static STRUCT_IF_C Vp_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_D, Vp_BFu16ll_D)
//============================================================================



static void Test_Vp_BFu16ll_F()
{
  {
    init_simple_test("Vp_BFu16ll_F");
    static STRUCT_IF_C Vp_BFu16ll_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_F, Vp_BFu16ll_F)
//============================================================================



static void Test_Vp_BFu16ll_I()
{
  {
    init_simple_test("Vp_BFu16ll_I");
    static STRUCT_IF_C Vp_BFu16ll_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_I, Vp_BFu16ll_I)
//============================================================================



static void Test_Vp_BFu16ll_Ip()
{
  {
    init_simple_test("Vp_BFu16ll_Ip");
    static STRUCT_IF_C Vp_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_Ip, Vp_BFu16ll_Ip)
//============================================================================



static void Test_Vp_BFu16ll_L()
{
  {
    init_simple_test("Vp_BFu16ll_L");
    static STRUCT_IF_C Vp_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_L, Vp_BFu16ll_L)
//============================================================================



static void Test_Vp_BFu16ll_S()
{
  {
    init_simple_test("Vp_BFu16ll_S");
    static STRUCT_IF_C Vp_BFu16ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_S, Vp_BFu16ll_S)
//============================================================================



static void Test_Vp_BFu16ll_Uc()
{
  {
    init_simple_test("Vp_BFu16ll_Uc");
    static STRUCT_IF_C Vp_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_Uc, Vp_BFu16ll_Uc)
//============================================================================



static void Test_Vp_BFu16ll_Ui()
{
  {
    init_simple_test("Vp_BFu16ll_Ui");
    static STRUCT_IF_C Vp_BFu16ll_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_Ui, Vp_BFu16ll_Ui)
//============================================================================



static void Test_Vp_BFu16ll_Ul()
{
  {
    init_simple_test("Vp_BFu16ll_Ul");
    static STRUCT_IF_C Vp_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_Ul, Vp_BFu16ll_Ul)
//============================================================================



static void Test_Vp_BFu16ll_Us()
{
  {
    init_simple_test("Vp_BFu16ll_Us");
    static STRUCT_IF_C Vp_BFu16ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_Us, Vp_BFu16ll_Us)
//============================================================================



static void Test_Vp_BFu16ll_Vp()
{
  {
    init_simple_test("Vp_BFu16ll_Vp");
    static STRUCT_IF_C Vp_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16ll_Vp, Vp_BFu16ll_Vp)
//============================================================================



static void Test_Vp_BFu16s()
{
  {
    init_simple_test("Vp_BFu16s");
    static STRUCT_IF_C Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s, Vp_BFu16s)
//============================================================================



static void Test_Vp_BFu16s_BFu15i()
{
  {
    init_simple_test("Vp_BFu16s_BFu15i");
    static STRUCT_IF_C Vp_BFu16s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu15i, Vp_BFu16s_BFu15i)
//============================================================================



static void Test_Vp_BFu16s_BFu15ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu15ll");
    static STRUCT_IF_C Vp_BFu16s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu15ll, Vp_BFu16s_BFu15ll)
//============================================================================



static void Test_Vp_BFu16s_BFu15s()
{
  {
    init_simple_test("Vp_BFu16s_BFu15s");
    static STRUCT_IF_C Vp_BFu16s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "Vp_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "Vp_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu15s, Vp_BFu16s_BFu15s)
//============================================================================



static void Test_Vp_BFu16s_BFu16i()
{
  {
    init_simple_test("Vp_BFu16s_BFu16i");
    static STRUCT_IF_C Vp_BFu16s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu16i, Vp_BFu16s_BFu16i)
//============================================================================



static void Test_Vp_BFu16s_BFu16ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu16ll");
    static STRUCT_IF_C Vp_BFu16s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu16ll, Vp_BFu16s_BFu16ll)
//============================================================================



static void Test_Vp_BFu16s_BFu16s()
{
  {
    init_simple_test("Vp_BFu16s_BFu16s");
    static STRUCT_IF_C Vp_BFu16s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "Vp_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu16s, Vp_BFu16s_BFu16s)
//============================================================================



static void Test_Vp_BFu16s_BFu17i()
{
  {
    init_simple_test("Vp_BFu16s_BFu17i");
    static STRUCT_IF_C Vp_BFu16s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Vp_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Vp_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu17i, Vp_BFu16s_BFu17i)
//============================================================================



static void Test_Vp_BFu16s_BFu17ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu17ll");
    static STRUCT_IF_C Vp_BFu16s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "Vp_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "Vp_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu17ll, Vp_BFu16s_BFu17ll)
//============================================================================



static void Test_Vp_BFu16s_BFu1c()
{
  {
    init_simple_test("Vp_BFu16s_BFu1c");
    static STRUCT_IF_C Vp_BFu16s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu1c, Vp_BFu16s_BFu1c)
//============================================================================



static void Test_Vp_BFu16s_BFu1i()
{
  {
    init_simple_test("Vp_BFu16s_BFu1i");
    static STRUCT_IF_C Vp_BFu16s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu1i, Vp_BFu16s_BFu1i)
//============================================================================



static void Test_Vp_BFu16s_BFu1ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu1ll");
    static STRUCT_IF_C Vp_BFu16s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu1ll, Vp_BFu16s_BFu1ll)
//============================================================================



static void Test_Vp_BFu16s_BFu1s()
{
  {
    init_simple_test("Vp_BFu16s_BFu1s");
    static STRUCT_IF_C Vp_BFu16s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "Vp_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu1s, Vp_BFu16s_BFu1s)
//============================================================================



static void Test_Vp_BFu16s_BFu31i()
{
  {
    init_simple_test("Vp_BFu16s_BFu31i");
    static STRUCT_IF_C Vp_BFu16s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Vp_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Vp_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu31i, Vp_BFu16s_BFu31i)
//============================================================================



static void Test_Vp_BFu16s_BFu31ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu31ll");
    static STRUCT_IF_C Vp_BFu16s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "Vp_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "Vp_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu31ll, Vp_BFu16s_BFu31ll)
//============================================================================



static void Test_Vp_BFu16s_BFu32i()
{
  {
    init_simple_test("Vp_BFu16s_BFu32i");
    static STRUCT_IF_C Vp_BFu16s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Vp_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Vp_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu32i, Vp_BFu16s_BFu32i)
//============================================================================



static void Test_Vp_BFu16s_BFu32ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu32ll");
    static STRUCT_IF_C Vp_BFu16s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "Vp_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "Vp_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu32ll, Vp_BFu16s_BFu32ll)
//============================================================================



static void Test_Vp_BFu16s_BFu33()
{
  {
    init_simple_test("Vp_BFu16s_BFu33");
    static STRUCT_IF_C Vp_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "Vp_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "Vp_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu33, Vp_BFu16s_BFu33)
//============================================================================



static void Test_Vp_BFu16s_BFu7c()
{
  {
    init_simple_test("Vp_BFu16s_BFu7c");
    static STRUCT_IF_C Vp_BFu16s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu7c, Vp_BFu16s_BFu7c)
//============================================================================



static void Test_Vp_BFu16s_BFu7i()
{
  {
    init_simple_test("Vp_BFu16s_BFu7i");
    static STRUCT_IF_C Vp_BFu16s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu7i, Vp_BFu16s_BFu7i)
//============================================================================



static void Test_Vp_BFu16s_BFu7ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu7ll");
    static STRUCT_IF_C Vp_BFu16s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu7ll, Vp_BFu16s_BFu7ll)
//============================================================================



static void Test_Vp_BFu16s_BFu7s()
{
  {
    init_simple_test("Vp_BFu16s_BFu7s");
    static STRUCT_IF_C Vp_BFu16s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "Vp_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "Vp_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu7s, Vp_BFu16s_BFu7s)
//============================================================================



static void Test_Vp_BFu16s_BFu8c()
{
  {
    init_simple_test("Vp_BFu16s_BFu8c");
    static STRUCT_IF_C Vp_BFu16s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu8c, Vp_BFu16s_BFu8c)
//============================================================================



static void Test_Vp_BFu16s_BFu8i()
{
  {
    init_simple_test("Vp_BFu16s_BFu8i");
    static STRUCT_IF_C Vp_BFu16s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu8i, Vp_BFu16s_BFu8i)
//============================================================================



static void Test_Vp_BFu16s_BFu8ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu8ll");
    static STRUCT_IF_C Vp_BFu16s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu8ll, Vp_BFu16s_BFu8ll)
//============================================================================



static void Test_Vp_BFu16s_BFu8s()
{
  {
    init_simple_test("Vp_BFu16s_BFu8s");
    static STRUCT_IF_C Vp_BFu16s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "Vp_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "Vp_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu8s, Vp_BFu16s_BFu8s)
//============================================================================



static void Test_Vp_BFu16s_BFu9i()
{
  {
    init_simple_test("Vp_BFu16s_BFu9i");
    static STRUCT_IF_C Vp_BFu16s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu9i, Vp_BFu16s_BFu9i)
//============================================================================



static void Test_Vp_BFu16s_BFu9ll()
{
  {
    init_simple_test("Vp_BFu16s_BFu9ll");
    static STRUCT_IF_C Vp_BFu16s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu9ll, Vp_BFu16s_BFu9ll)
//============================================================================



static void Test_Vp_BFu16s_BFu9s()
{
  {
    init_simple_test("Vp_BFu16s_BFu9s");
    static STRUCT_IF_C Vp_BFu16s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "Vp_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "Vp_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_BFu9s, Vp_BFu16s_BFu9s)
//============================================================================



static void Test_Vp_BFu16s_C()
{
  {
    init_simple_test("Vp_BFu16s_C");
    static STRUCT_IF_C Vp_BFu16s_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_C, Vp_BFu16s_C)
//============================================================================



static void Test_Vp_BFu16s_D()
{
  {
    init_simple_test("Vp_BFu16s_D");
    static STRUCT_IF_C Vp_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_D, Vp_BFu16s_D)
//============================================================================



static void Test_Vp_BFu16s_F()
{
  {
    init_simple_test("Vp_BFu16s_F");
    static STRUCT_IF_C Vp_BFu16s_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_F, Vp_BFu16s_F)
//============================================================================



static void Test_Vp_BFu16s_I()
{
  {
    init_simple_test("Vp_BFu16s_I");
    static STRUCT_IF_C Vp_BFu16s_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_I, Vp_BFu16s_I)
//============================================================================



static void Test_Vp_BFu16s_Ip()
{
  {
    init_simple_test("Vp_BFu16s_Ip");
    static STRUCT_IF_C Vp_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_Ip, Vp_BFu16s_Ip)
//============================================================================



static void Test_Vp_BFu16s_L()
{
  {
    init_simple_test("Vp_BFu16s_L");
    static STRUCT_IF_C Vp_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_L, Vp_BFu16s_L)
//============================================================================



static void Test_Vp_BFu16s_S()
{
  {
    init_simple_test("Vp_BFu16s_S");
    static STRUCT_IF_C Vp_BFu16s_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_S, Vp_BFu16s_S)
//============================================================================



static void Test_Vp_BFu16s_Uc()
{
  {
    init_simple_test("Vp_BFu16s_Uc");
    static STRUCT_IF_C Vp_BFu16s_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_Uc, Vp_BFu16s_Uc)
//============================================================================



static void Test_Vp_BFu16s_Ui()
{
  {
    init_simple_test("Vp_BFu16s_Ui");
    static STRUCT_IF_C Vp_BFu16s_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_Ui, Vp_BFu16s_Ui)
//============================================================================



static void Test_Vp_BFu16s_Ul()
{
  {
    init_simple_test("Vp_BFu16s_Ul");
    static STRUCT_IF_C Vp_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Vp_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_Ul, Vp_BFu16s_Ul)
//============================================================================



static void Test_Vp_BFu16s_Us()
{
  {
    init_simple_test("Vp_BFu16s_Us");
    static STRUCT_IF_C Vp_BFu16s_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_Us, Vp_BFu16s_Us)
//============================================================================



static void Test_Vp_BFu16s_Vp()
{
  {
    init_simple_test("Vp_BFu16s_Vp");
    static STRUCT_IF_C Vp_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(Vp_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Vp_BFu16s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Vp_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "Vp_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu16s_Vp, Vp_BFu16s_Vp)
//============================================================================



static void Test_Vp_BFu17i()
{
  {
    init_simple_test("Vp_BFu17i");
    static STRUCT_IF_C Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i, Vp_BFu17i)
//============================================================================



static void Test_Vp_BFu17i_BFu15i()
{
  {
    init_simple_test("Vp_BFu17i_BFu15i");
    static STRUCT_IF_C Vp_BFu17i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Vp_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Vp_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu15i, Vp_BFu17i_BFu15i)
//============================================================================



static void Test_Vp_BFu17i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu15ll");
    static STRUCT_IF_C Vp_BFu17i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Vp_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Vp_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu15ll, Vp_BFu17i_BFu15ll)
//============================================================================



static void Test_Vp_BFu17i_BFu15s()
{
  {
    init_simple_test("Vp_BFu17i_BFu15s");
    static STRUCT_IF_C Vp_BFu17i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Vp_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Vp_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu15s, Vp_BFu17i_BFu15s)
//============================================================================



static void Test_Vp_BFu17i_BFu16i()
{
  {
    init_simple_test("Vp_BFu17i_BFu16i");
    static STRUCT_IF_C Vp_BFu17i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "Vp_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "Vp_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu16i, Vp_BFu17i_BFu16i)
//============================================================================



static void Test_Vp_BFu17i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu16ll");
    static STRUCT_IF_C Vp_BFu17i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "Vp_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "Vp_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu16ll, Vp_BFu17i_BFu16ll)
//============================================================================



static void Test_Vp_BFu17i_BFu16s()
{
  {
    init_simple_test("Vp_BFu17i_BFu16s");
    static STRUCT_IF_C Vp_BFu17i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "Vp_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "Vp_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu16s, Vp_BFu17i_BFu16s)
//============================================================================



static void Test_Vp_BFu17i_BFu17i()
{
  {
    init_simple_test("Vp_BFu17i_BFu17i");
    static STRUCT_IF_C Vp_BFu17i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "Vp_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu17i, Vp_BFu17i_BFu17i)
//============================================================================



static void Test_Vp_BFu17i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu17ll");
    static STRUCT_IF_C Vp_BFu17i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "Vp_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu17ll, Vp_BFu17i_BFu17ll)
//============================================================================



static void Test_Vp_BFu17i_BFu1c()
{
  {
    init_simple_test("Vp_BFu17i_BFu1c");
    static STRUCT_IF_C Vp_BFu17i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu1c, Vp_BFu17i_BFu1c)
//============================================================================



static void Test_Vp_BFu17i_BFu1i()
{
  {
    init_simple_test("Vp_BFu17i_BFu1i");
    static STRUCT_IF_C Vp_BFu17i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu1i, Vp_BFu17i_BFu1i)
//============================================================================



static void Test_Vp_BFu17i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu1ll");
    static STRUCT_IF_C Vp_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu1ll, Vp_BFu17i_BFu1ll)
//============================================================================



static void Test_Vp_BFu17i_BFu1s()
{
  {
    init_simple_test("Vp_BFu17i_BFu1s");
    static STRUCT_IF_C Vp_BFu17i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu1s, Vp_BFu17i_BFu1s)
//============================================================================



static void Test_Vp_BFu17i_BFu31i()
{
  {
    init_simple_test("Vp_BFu17i_BFu31i");
    static STRUCT_IF_C Vp_BFu17i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "Vp_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "Vp_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu31i, Vp_BFu17i_BFu31i)
//============================================================================



static void Test_Vp_BFu17i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu31ll");
    static STRUCT_IF_C Vp_BFu17i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "Vp_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "Vp_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu31ll, Vp_BFu17i_BFu31ll)
//============================================================================



static void Test_Vp_BFu17i_BFu32i()
{
  {
    init_simple_test("Vp_BFu17i_BFu32i");
    static STRUCT_IF_C Vp_BFu17i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "Vp_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "Vp_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu32i, Vp_BFu17i_BFu32i)
//============================================================================



static void Test_Vp_BFu17i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu32ll");
    static STRUCT_IF_C Vp_BFu17i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "Vp_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "Vp_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu32ll, Vp_BFu17i_BFu32ll)
//============================================================================



static void Test_Vp_BFu17i_BFu33()
{
  {
    init_simple_test("Vp_BFu17i_BFu33");
    static STRUCT_IF_C Vp_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, 1, "Vp_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, hide_ull(1LL<<32), "Vp_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu33, Vp_BFu17i_BFu33)
//============================================================================



static void Test_Vp_BFu17i_BFu7c()
{
  {
    init_simple_test("Vp_BFu17i_BFu7c");
    static STRUCT_IF_C Vp_BFu17i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu7c, Vp_BFu17i_BFu7c)
//============================================================================



static void Test_Vp_BFu17i_BFu7i()
{
  {
    init_simple_test("Vp_BFu17i_BFu7i");
    static STRUCT_IF_C Vp_BFu17i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu7i, Vp_BFu17i_BFu7i)
//============================================================================



static void Test_Vp_BFu17i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu7ll");
    static STRUCT_IF_C Vp_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu7ll, Vp_BFu17i_BFu7ll)
//============================================================================



static void Test_Vp_BFu17i_BFu7s()
{
  {
    init_simple_test("Vp_BFu17i_BFu7s");
    static STRUCT_IF_C Vp_BFu17i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu7s, Vp_BFu17i_BFu7s)
//============================================================================



static void Test_Vp_BFu17i_BFu8c()
{
  {
    init_simple_test("Vp_BFu17i_BFu8c");
    static STRUCT_IF_C Vp_BFu17i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu8c, Vp_BFu17i_BFu8c)
//============================================================================



static void Test_Vp_BFu17i_BFu8i()
{
  {
    init_simple_test("Vp_BFu17i_BFu8i");
    static STRUCT_IF_C Vp_BFu17i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu8i, Vp_BFu17i_BFu8i)
//============================================================================



static void Test_Vp_BFu17i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu8ll");
    static STRUCT_IF_C Vp_BFu17i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu8ll, Vp_BFu17i_BFu8ll)
//============================================================================



static void Test_Vp_BFu17i_BFu8s()
{
  {
    init_simple_test("Vp_BFu17i_BFu8s");
    static STRUCT_IF_C Vp_BFu17i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu8s, Vp_BFu17i_BFu8s)
//============================================================================



static void Test_Vp_BFu17i_BFu9i()
{
  {
    init_simple_test("Vp_BFu17i_BFu9i");
    static STRUCT_IF_C Vp_BFu17i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Vp_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Vp_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu9i, Vp_BFu17i_BFu9i)
//============================================================================



static void Test_Vp_BFu17i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu17i_BFu9ll");
    static STRUCT_IF_C Vp_BFu17i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Vp_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Vp_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu9ll, Vp_BFu17i_BFu9ll)
//============================================================================



static void Test_Vp_BFu17i_BFu9s()
{
  {
    init_simple_test("Vp_BFu17i_BFu9s");
    static STRUCT_IF_C Vp_BFu17i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Vp_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Vp_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_BFu9s, Vp_BFu17i_BFu9s)
//============================================================================



static void Test_Vp_BFu17i_C()
{
  {
    init_simple_test("Vp_BFu17i_C");
    static STRUCT_IF_C Vp_BFu17i_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_C");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_C, Vp_BFu17i_C)
//============================================================================



static void Test_Vp_BFu17i_D()
{
  {
    init_simple_test("Vp_BFu17i_D");
    static STRUCT_IF_C Vp_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Vp_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_D, Vp_BFu17i_D)
//============================================================================



static void Test_Vp_BFu17i_F()
{
  {
    init_simple_test("Vp_BFu17i_F");
    static STRUCT_IF_C Vp_BFu17i_F lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_F");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_F, Vp_BFu17i_F)
//============================================================================



static void Test_Vp_BFu17i_I()
{
  {
    init_simple_test("Vp_BFu17i_I");
    static STRUCT_IF_C Vp_BFu17i_I lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_I");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_I, Vp_BFu17i_I)
//============================================================================



static void Test_Vp_BFu17i_Ip()
{
  {
    init_simple_test("Vp_BFu17i_Ip");
    static STRUCT_IF_C Vp_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(Vp_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_Ip, Vp_BFu17i_Ip)
//============================================================================



static void Test_Vp_BFu17i_L()
{
  {
    init_simple_test("Vp_BFu17i_L");
    static STRUCT_IF_C Vp_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Vp_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_L, Vp_BFu17i_L)
//============================================================================



static void Test_Vp_BFu17i_S()
{
  {
    init_simple_test("Vp_BFu17i_S");
    static STRUCT_IF_C Vp_BFu17i_S lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_S");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_S, Vp_BFu17i_S)
//============================================================================



static void Test_Vp_BFu17i_Uc()
{
  {
    init_simple_test("Vp_BFu17i_Uc");
    static STRUCT_IF_C Vp_BFu17i_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_Uc");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_Uc, Vp_BFu17i_Uc)
//============================================================================



static void Test_Vp_BFu17i_Ui()
{
  {
    init_simple_test("Vp_BFu17i_Ui");
    static STRUCT_IF_C Vp_BFu17i_Ui lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_Ui");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_Ui, Vp_BFu17i_Ui)
//============================================================================



static void Test_Vp_BFu17i_Ul()
{
  {
    init_simple_test("Vp_BFu17i_Ul");
    static STRUCT_IF_C Vp_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Vp_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_Ul, Vp_BFu17i_Ul)
//============================================================================



static void Test_Vp_BFu17i_Us()
{
  {
    init_simple_test("Vp_BFu17i_Us");
    static STRUCT_IF_C Vp_BFu17i_Us lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_Us");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_Us, Vp_BFu17i_Us)
//============================================================================



static void Test_Vp_BFu17i_Vp()
{
  {
    init_simple_test("Vp_BFu17i_Vp");
    static STRUCT_IF_C Vp_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(Vp_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17i_Vp, Vp_BFu17i_Vp)
//============================================================================



static void Test_Vp_BFu17ll()
{
  {
    init_simple_test("Vp_BFu17ll");
    static STRUCT_IF_C Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll, Vp_BFu17ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu15i");
    static STRUCT_IF_C Vp_BFu17ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Vp_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Vp_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu15i, Vp_BFu17ll_BFu15i)
//============================================================================



static void Test_Vp_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Vp_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Vp_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu15ll, Vp_BFu17ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu17ll_BFu15s");
    static STRUCT_IF_C Vp_BFu17ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "Vp_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "Vp_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu15s, Vp_BFu17ll_BFu15s)
//============================================================================



static void Test_Vp_BFu17ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu16i");
    static STRUCT_IF_C Vp_BFu17ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "Vp_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "Vp_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu16i, Vp_BFu17ll_BFu16i)
//============================================================================



static void Test_Vp_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "Vp_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "Vp_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu16ll, Vp_BFu17ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu17ll_BFu16s");
    static STRUCT_IF_C Vp_BFu17ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "Vp_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "Vp_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu16s, Vp_BFu17ll_BFu16s)
//============================================================================



static void Test_Vp_BFu17ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu17i");
    static STRUCT_IF_C Vp_BFu17ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "Vp_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu17i, Vp_BFu17ll_BFu17i)
//============================================================================



static void Test_Vp_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "Vp_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu17ll, Vp_BFu17ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu17ll_BFu1c");
    static STRUCT_IF_C Vp_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu1c, Vp_BFu17ll_BFu1c)
//============================================================================



static void Test_Vp_BFu17ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu1i");
    static STRUCT_IF_C Vp_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu1i, Vp_BFu17ll_BFu1i)
//============================================================================



static void Test_Vp_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu1ll, Vp_BFu17ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu17ll_BFu1s");
    static STRUCT_IF_C Vp_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "Vp_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu1s, Vp_BFu17ll_BFu1s)
//============================================================================



static void Test_Vp_BFu17ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu31i");
    static STRUCT_IF_C Vp_BFu17ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "Vp_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "Vp_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu31i, Vp_BFu17ll_BFu31i)
//============================================================================



static void Test_Vp_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "Vp_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "Vp_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu31ll, Vp_BFu17ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu32i");
    static STRUCT_IF_C Vp_BFu17ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "Vp_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "Vp_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu32i, Vp_BFu17ll_BFu32i)
//============================================================================



static void Test_Vp_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "Vp_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "Vp_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu32ll, Vp_BFu17ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu33()
{
  {
    init_simple_test("Vp_BFu17ll_BFu33");
    static STRUCT_IF_C Vp_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, 1, "Vp_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, hide_ull(1LL<<32), "Vp_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu33, Vp_BFu17ll_BFu33)
//============================================================================



static void Test_Vp_BFu17ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu17ll_BFu7c");
    static STRUCT_IF_C Vp_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu7c, Vp_BFu17ll_BFu7c)
//============================================================================



static void Test_Vp_BFu17ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu7i");
    static STRUCT_IF_C Vp_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu7i, Vp_BFu17ll_BFu7i)
//============================================================================



static void Test_Vp_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu7ll, Vp_BFu17ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu17ll_BFu7s");
    static STRUCT_IF_C Vp_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "Vp_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "Vp_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu7s, Vp_BFu17ll_BFu7s)
//============================================================================



static void Test_Vp_BFu17ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu17ll_BFu8c");
    static STRUCT_IF_C Vp_BFu17ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu8c, Vp_BFu17ll_BFu8c)
//============================================================================



static void Test_Vp_BFu17ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu8i");
    static STRUCT_IF_C Vp_BFu17ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu8i, Vp_BFu17ll_BFu8i)
//============================================================================



static void Test_Vp_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu8ll, Vp_BFu17ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu17ll_BFu8s");
    static STRUCT_IF_C Vp_BFu17ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "Vp_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "Vp_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu8s, Vp_BFu17ll_BFu8s)
//============================================================================



static void Test_Vp_BFu17ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu17ll_BFu9i");
    static STRUCT_IF_C Vp_BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Vp_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Vp_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu9i, Vp_BFu17ll_BFu9i)
//============================================================================



static void Test_Vp_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu17ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Vp_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Vp_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu9ll, Vp_BFu17ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu17ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu17ll_BFu9s");
    static STRUCT_IF_C Vp_BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "Vp_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "Vp_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_BFu9s, Vp_BFu17ll_BFu9s)
//============================================================================



static void Test_Vp_BFu17ll_C()
{
  {
    init_simple_test("Vp_BFu17ll_C");
    static STRUCT_IF_C Vp_BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_C");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_C, Vp_BFu17ll_C)
//============================================================================



static void Test_Vp_BFu17ll_D()
{
  {
    init_simple_test("Vp_BFu17ll_D");
    static STRUCT_IF_C Vp_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Vp_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_D, Vp_BFu17ll_D)
//============================================================================



static void Test_Vp_BFu17ll_F()
{
  {
    init_simple_test("Vp_BFu17ll_F");
    static STRUCT_IF_C Vp_BFu17ll_F lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_F");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_F, Vp_BFu17ll_F)
//============================================================================



static void Test_Vp_BFu17ll_I()
{
  {
    init_simple_test("Vp_BFu17ll_I");
    static STRUCT_IF_C Vp_BFu17ll_I lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_I");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_I, Vp_BFu17ll_I)
//============================================================================



static void Test_Vp_BFu17ll_Ip()
{
  {
    init_simple_test("Vp_BFu17ll_Ip");
    static STRUCT_IF_C Vp_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(Vp_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_Ip, Vp_BFu17ll_Ip)
//============================================================================



static void Test_Vp_BFu17ll_L()
{
  {
    init_simple_test("Vp_BFu17ll_L");
    static STRUCT_IF_C Vp_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Vp_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_L, Vp_BFu17ll_L)
//============================================================================



static void Test_Vp_BFu17ll_S()
{
  {
    init_simple_test("Vp_BFu17ll_S");
    static STRUCT_IF_C Vp_BFu17ll_S lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_S");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_S, Vp_BFu17ll_S)
//============================================================================



static void Test_Vp_BFu17ll_Uc()
{
  {
    init_simple_test("Vp_BFu17ll_Uc");
    static STRUCT_IF_C Vp_BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_Uc");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_Uc, Vp_BFu17ll_Uc)
//============================================================================



static void Test_Vp_BFu17ll_Ui()
{
  {
    init_simple_test("Vp_BFu17ll_Ui");
    static STRUCT_IF_C Vp_BFu17ll_Ui lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_Ui");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_Ui, Vp_BFu17ll_Ui)
//============================================================================



static void Test_Vp_BFu17ll_Ul()
{
  {
    init_simple_test("Vp_BFu17ll_Ul");
    static STRUCT_IF_C Vp_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Vp_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_Ul, Vp_BFu17ll_Ul)
//============================================================================



static void Test_Vp_BFu17ll_Us()
{
  {
    init_simple_test("Vp_BFu17ll_Us");
    static STRUCT_IF_C Vp_BFu17ll_Us lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_Us");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_Us, Vp_BFu17ll_Us)
//============================================================================



static void Test_Vp_BFu17ll_Vp()
{
  {
    init_simple_test("Vp_BFu17ll_Vp");
    static STRUCT_IF_C Vp_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(Vp_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Vp_BFu17ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Vp_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(11,7), "Vp_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu17ll_Vp, Vp_BFu17ll_Vp)
//============================================================================



static void Test_Vp_BFu1c()
{
  {
    init_simple_test("Vp_BFu1c");
    static STRUCT_IF_C Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c, Vp_BFu1c)
//============================================================================



static void Test_Vp_BFu1c_BFu15i()
{
  {
    init_simple_test("Vp_BFu1c_BFu15i");
    static STRUCT_IF_C Vp_BFu1c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu15i, Vp_BFu1c_BFu15i)
//============================================================================



static void Test_Vp_BFu1c_BFu15ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu15ll");
    static STRUCT_IF_C Vp_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu15ll, Vp_BFu1c_BFu15ll)
//============================================================================



static void Test_Vp_BFu1c_BFu15s()
{
  {
    init_simple_test("Vp_BFu1c_BFu15s");
    static STRUCT_IF_C Vp_BFu1c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu15s, Vp_BFu1c_BFu15s)
//============================================================================



static void Test_Vp_BFu1c_BFu16i()
{
  {
    init_simple_test("Vp_BFu1c_BFu16i");
    static STRUCT_IF_C Vp_BFu1c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu16i, Vp_BFu1c_BFu16i)
//============================================================================



static void Test_Vp_BFu1c_BFu16ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu16ll");
    static STRUCT_IF_C Vp_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu16ll, Vp_BFu1c_BFu16ll)
//============================================================================



static void Test_Vp_BFu1c_BFu16s()
{
  {
    init_simple_test("Vp_BFu1c_BFu16s");
    static STRUCT_IF_C Vp_BFu1c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu16s, Vp_BFu1c_BFu16s)
//============================================================================



static void Test_Vp_BFu1c_BFu17i()
{
  {
    init_simple_test("Vp_BFu1c_BFu17i");
    static STRUCT_IF_C Vp_BFu1c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu17i, Vp_BFu1c_BFu17i)
//============================================================================



static void Test_Vp_BFu1c_BFu17ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu17ll");
    static STRUCT_IF_C Vp_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu17ll, Vp_BFu1c_BFu17ll)
//============================================================================



static void Test_Vp_BFu1c_BFu1c()
{
  {
    init_simple_test("Vp_BFu1c_BFu1c");
    static STRUCT_IF_C Vp_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu1c, Vp_BFu1c_BFu1c)
//============================================================================



static void Test_Vp_BFu1c_BFu1i()
{
  {
    init_simple_test("Vp_BFu1c_BFu1i");
    static STRUCT_IF_C Vp_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu1i, Vp_BFu1c_BFu1i)
//============================================================================



static void Test_Vp_BFu1c_BFu1ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu1ll");
    static STRUCT_IF_C Vp_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu1ll, Vp_BFu1c_BFu1ll)
//============================================================================



static void Test_Vp_BFu1c_BFu1s()
{
  {
    init_simple_test("Vp_BFu1c_BFu1s");
    static STRUCT_IF_C Vp_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu1s, Vp_BFu1c_BFu1s)
//============================================================================



static void Test_Vp_BFu1c_BFu31i()
{
  {
    init_simple_test("Vp_BFu1c_BFu31i");
    static STRUCT_IF_C Vp_BFu1c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu31i, Vp_BFu1c_BFu31i)
//============================================================================



static void Test_Vp_BFu1c_BFu31ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu31ll");
    static STRUCT_IF_C Vp_BFu1c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu31ll, Vp_BFu1c_BFu31ll)
//============================================================================



static void Test_Vp_BFu1c_BFu32i()
{
  {
    init_simple_test("Vp_BFu1c_BFu32i");
    static STRUCT_IF_C Vp_BFu1c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu32i, Vp_BFu1c_BFu32i)
//============================================================================



static void Test_Vp_BFu1c_BFu32ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu32ll");
    static STRUCT_IF_C Vp_BFu1c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu32ll, Vp_BFu1c_BFu32ll)
//============================================================================



static void Test_Vp_BFu1c_BFu33()
{
  {
    init_simple_test("Vp_BFu1c_BFu33");
    static STRUCT_IF_C Vp_BFu1c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "Vp_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "Vp_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu33, Vp_BFu1c_BFu33)
//============================================================================



static void Test_Vp_BFu1c_BFu7c()
{
  {
    init_simple_test("Vp_BFu1c_BFu7c");
    static STRUCT_IF_C Vp_BFu1c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu7c, Vp_BFu1c_BFu7c)
//============================================================================



static void Test_Vp_BFu1c_BFu7i()
{
  {
    init_simple_test("Vp_BFu1c_BFu7i");
    static STRUCT_IF_C Vp_BFu1c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu7i, Vp_BFu1c_BFu7i)
//============================================================================



static void Test_Vp_BFu1c_BFu7ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu7ll");
    static STRUCT_IF_C Vp_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu7ll, Vp_BFu1c_BFu7ll)
//============================================================================



static void Test_Vp_BFu1c_BFu7s()
{
  {
    init_simple_test("Vp_BFu1c_BFu7s");
    static STRUCT_IF_C Vp_BFu1c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu7s, Vp_BFu1c_BFu7s)
//============================================================================



static void Test_Vp_BFu1c_BFu8c()
{
  {
    init_simple_test("Vp_BFu1c_BFu8c");
    static STRUCT_IF_C Vp_BFu1c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu8c, Vp_BFu1c_BFu8c)
//============================================================================



static void Test_Vp_BFu1c_BFu8i()
{
  {
    init_simple_test("Vp_BFu1c_BFu8i");
    static STRUCT_IF_C Vp_BFu1c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu8i, Vp_BFu1c_BFu8i)
//============================================================================



static void Test_Vp_BFu1c_BFu8ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu8ll");
    static STRUCT_IF_C Vp_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu8ll, Vp_BFu1c_BFu8ll)
//============================================================================



static void Test_Vp_BFu1c_BFu8s()
{
  {
    init_simple_test("Vp_BFu1c_BFu8s");
    static STRUCT_IF_C Vp_BFu1c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu8s, Vp_BFu1c_BFu8s)
//============================================================================



static void Test_Vp_BFu1c_BFu9i()
{
  {
    init_simple_test("Vp_BFu1c_BFu9i");
    static STRUCT_IF_C Vp_BFu1c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu9i, Vp_BFu1c_BFu9i)
//============================================================================



static void Test_Vp_BFu1c_BFu9ll()
{
  {
    init_simple_test("Vp_BFu1c_BFu9ll");
    static STRUCT_IF_C Vp_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu9ll, Vp_BFu1c_BFu9ll)
//============================================================================



static void Test_Vp_BFu1c_BFu9s()
{
  {
    init_simple_test("Vp_BFu1c_BFu9s");
    static STRUCT_IF_C Vp_BFu1c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_BFu9s, Vp_BFu1c_BFu9s)
//============================================================================



static void Test_Vp_BFu1c_C()
{
  {
    init_simple_test("Vp_BFu1c_C");
    static STRUCT_IF_C Vp_BFu1c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_C, Vp_BFu1c_C)
//============================================================================



static void Test_Vp_BFu1c_D()
{
  {
    init_simple_test("Vp_BFu1c_D");
    static STRUCT_IF_C Vp_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_D, Vp_BFu1c_D)
//============================================================================



static void Test_Vp_BFu1c_F()
{
  {
    init_simple_test("Vp_BFu1c_F");
    static STRUCT_IF_C Vp_BFu1c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_F, Vp_BFu1c_F)
//============================================================================



static void Test_Vp_BFu1c_I()
{
  {
    init_simple_test("Vp_BFu1c_I");
    static STRUCT_IF_C Vp_BFu1c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_I, Vp_BFu1c_I)
//============================================================================



static void Test_Vp_BFu1c_Ip()
{
  {
    init_simple_test("Vp_BFu1c_Ip");
    static STRUCT_IF_C Vp_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_Ip, Vp_BFu1c_Ip)
//============================================================================



static void Test_Vp_BFu1c_L()
{
  {
    init_simple_test("Vp_BFu1c_L");
    static STRUCT_IF_C Vp_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_L, Vp_BFu1c_L)
//============================================================================



static void Test_Vp_BFu1c_S()
{
  {
    init_simple_test("Vp_BFu1c_S");
    static STRUCT_IF_C Vp_BFu1c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_S, Vp_BFu1c_S)
//============================================================================



static void Test_Vp_BFu1c_Uc()
{
  {
    init_simple_test("Vp_BFu1c_Uc");
    static STRUCT_IF_C Vp_BFu1c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_Uc, Vp_BFu1c_Uc)
//============================================================================



static void Test_Vp_BFu1c_Ui()
{
  {
    init_simple_test("Vp_BFu1c_Ui");
    static STRUCT_IF_C Vp_BFu1c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_Ui, Vp_BFu1c_Ui)
//============================================================================



static void Test_Vp_BFu1c_Ul()
{
  {
    init_simple_test("Vp_BFu1c_Ul");
    static STRUCT_IF_C Vp_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_Ul, Vp_BFu1c_Ul)
//============================================================================



static void Test_Vp_BFu1c_Us()
{
  {
    init_simple_test("Vp_BFu1c_Us");
    static STRUCT_IF_C Vp_BFu1c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_Us, Vp_BFu1c_Us)
//============================================================================



static void Test_Vp_BFu1c_Vp()
{
  {
    init_simple_test("Vp_BFu1c_Vp");
    static STRUCT_IF_C Vp_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1c_Vp, Vp_BFu1c_Vp)
//============================================================================



static void Test_Vp_BFu1i()
{
  {
    init_simple_test("Vp_BFu1i");
    static STRUCT_IF_C Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i, Vp_BFu1i)
//============================================================================



static void Test_Vp_BFu1i_BFu15i()
{
  {
    init_simple_test("Vp_BFu1i_BFu15i");
    static STRUCT_IF_C Vp_BFu1i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu15i, Vp_BFu1i_BFu15i)
//============================================================================



static void Test_Vp_BFu1i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu15ll");
    static STRUCT_IF_C Vp_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu15ll, Vp_BFu1i_BFu15ll)
//============================================================================



static void Test_Vp_BFu1i_BFu15s()
{
  {
    init_simple_test("Vp_BFu1i_BFu15s");
    static STRUCT_IF_C Vp_BFu1i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu15s, Vp_BFu1i_BFu15s)
//============================================================================



static void Test_Vp_BFu1i_BFu16i()
{
  {
    init_simple_test("Vp_BFu1i_BFu16i");
    static STRUCT_IF_C Vp_BFu1i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu16i, Vp_BFu1i_BFu16i)
//============================================================================



static void Test_Vp_BFu1i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu16ll");
    static STRUCT_IF_C Vp_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu16ll, Vp_BFu1i_BFu16ll)
//============================================================================



static void Test_Vp_BFu1i_BFu16s()
{
  {
    init_simple_test("Vp_BFu1i_BFu16s");
    static STRUCT_IF_C Vp_BFu1i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu16s, Vp_BFu1i_BFu16s)
//============================================================================



static void Test_Vp_BFu1i_BFu17i()
{
  {
    init_simple_test("Vp_BFu1i_BFu17i");
    static STRUCT_IF_C Vp_BFu1i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu17i, Vp_BFu1i_BFu17i)
//============================================================================



static void Test_Vp_BFu1i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu17ll");
    static STRUCT_IF_C Vp_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu17ll, Vp_BFu1i_BFu17ll)
//============================================================================



static void Test_Vp_BFu1i_BFu1c()
{
  {
    init_simple_test("Vp_BFu1i_BFu1c");
    static STRUCT_IF_C Vp_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu1c, Vp_BFu1i_BFu1c)
//============================================================================



static void Test_Vp_BFu1i_BFu1i()
{
  {
    init_simple_test("Vp_BFu1i_BFu1i");
    static STRUCT_IF_C Vp_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu1i, Vp_BFu1i_BFu1i)
//============================================================================



static void Test_Vp_BFu1i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu1ll");
    static STRUCT_IF_C Vp_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu1ll, Vp_BFu1i_BFu1ll)
//============================================================================



static void Test_Vp_BFu1i_BFu1s()
{
  {
    init_simple_test("Vp_BFu1i_BFu1s");
    static STRUCT_IF_C Vp_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu1s, Vp_BFu1i_BFu1s)
//============================================================================



static void Test_Vp_BFu1i_BFu31i()
{
  {
    init_simple_test("Vp_BFu1i_BFu31i");
    static STRUCT_IF_C Vp_BFu1i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu31i, Vp_BFu1i_BFu31i)
//============================================================================



static void Test_Vp_BFu1i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu31ll");
    static STRUCT_IF_C Vp_BFu1i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu31ll, Vp_BFu1i_BFu31ll)
//============================================================================



static void Test_Vp_BFu1i_BFu32i()
{
  {
    init_simple_test("Vp_BFu1i_BFu32i");
    static STRUCT_IF_C Vp_BFu1i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu32i, Vp_BFu1i_BFu32i)
//============================================================================



static void Test_Vp_BFu1i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu32ll");
    static STRUCT_IF_C Vp_BFu1i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu32ll, Vp_BFu1i_BFu32ll)
//============================================================================



static void Test_Vp_BFu1i_BFu33()
{
  {
    init_simple_test("Vp_BFu1i_BFu33");
    static STRUCT_IF_C Vp_BFu1i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "Vp_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "Vp_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu33, Vp_BFu1i_BFu33)
//============================================================================



static void Test_Vp_BFu1i_BFu7c()
{
  {
    init_simple_test("Vp_BFu1i_BFu7c");
    static STRUCT_IF_C Vp_BFu1i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu7c, Vp_BFu1i_BFu7c)
//============================================================================



static void Test_Vp_BFu1i_BFu7i()
{
  {
    init_simple_test("Vp_BFu1i_BFu7i");
    static STRUCT_IF_C Vp_BFu1i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu7i, Vp_BFu1i_BFu7i)
//============================================================================



static void Test_Vp_BFu1i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu7ll");
    static STRUCT_IF_C Vp_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu7ll, Vp_BFu1i_BFu7ll)
//============================================================================



static void Test_Vp_BFu1i_BFu7s()
{
  {
    init_simple_test("Vp_BFu1i_BFu7s");
    static STRUCT_IF_C Vp_BFu1i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu7s, Vp_BFu1i_BFu7s)
//============================================================================



static void Test_Vp_BFu1i_BFu8c()
{
  {
    init_simple_test("Vp_BFu1i_BFu8c");
    static STRUCT_IF_C Vp_BFu1i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu8c, Vp_BFu1i_BFu8c)
//============================================================================



static void Test_Vp_BFu1i_BFu8i()
{
  {
    init_simple_test("Vp_BFu1i_BFu8i");
    static STRUCT_IF_C Vp_BFu1i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu8i, Vp_BFu1i_BFu8i)
//============================================================================



static void Test_Vp_BFu1i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu8ll");
    static STRUCT_IF_C Vp_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu8ll, Vp_BFu1i_BFu8ll)
//============================================================================



static void Test_Vp_BFu1i_BFu8s()
{
  {
    init_simple_test("Vp_BFu1i_BFu8s");
    static STRUCT_IF_C Vp_BFu1i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu8s, Vp_BFu1i_BFu8s)
//============================================================================



static void Test_Vp_BFu1i_BFu9i()
{
  {
    init_simple_test("Vp_BFu1i_BFu9i");
    static STRUCT_IF_C Vp_BFu1i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu9i, Vp_BFu1i_BFu9i)
//============================================================================



static void Test_Vp_BFu1i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu1i_BFu9ll");
    static STRUCT_IF_C Vp_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu9ll, Vp_BFu1i_BFu9ll)
//============================================================================



static void Test_Vp_BFu1i_BFu9s()
{
  {
    init_simple_test("Vp_BFu1i_BFu9s");
    static STRUCT_IF_C Vp_BFu1i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_BFu9s, Vp_BFu1i_BFu9s)
//============================================================================



static void Test_Vp_BFu1i_C()
{
  {
    init_simple_test("Vp_BFu1i_C");
    static STRUCT_IF_C Vp_BFu1i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_C, Vp_BFu1i_C)
//============================================================================



static void Test_Vp_BFu1i_D()
{
  {
    init_simple_test("Vp_BFu1i_D");
    static STRUCT_IF_C Vp_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_D, Vp_BFu1i_D)
//============================================================================



static void Test_Vp_BFu1i_F()
{
  {
    init_simple_test("Vp_BFu1i_F");
    static STRUCT_IF_C Vp_BFu1i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_F, Vp_BFu1i_F)
//============================================================================



static void Test_Vp_BFu1i_I()
{
  {
    init_simple_test("Vp_BFu1i_I");
    static STRUCT_IF_C Vp_BFu1i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_I, Vp_BFu1i_I)
//============================================================================



static void Test_Vp_BFu1i_Ip()
{
  {
    init_simple_test("Vp_BFu1i_Ip");
    static STRUCT_IF_C Vp_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_Ip, Vp_BFu1i_Ip)
//============================================================================



static void Test_Vp_BFu1i_L()
{
  {
    init_simple_test("Vp_BFu1i_L");
    static STRUCT_IF_C Vp_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_L, Vp_BFu1i_L)
//============================================================================



static void Test_Vp_BFu1i_S()
{
  {
    init_simple_test("Vp_BFu1i_S");
    static STRUCT_IF_C Vp_BFu1i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_S, Vp_BFu1i_S)
//============================================================================



static void Test_Vp_BFu1i_Uc()
{
  {
    init_simple_test("Vp_BFu1i_Uc");
    static STRUCT_IF_C Vp_BFu1i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_Uc, Vp_BFu1i_Uc)
//============================================================================



static void Test_Vp_BFu1i_Ui()
{
  {
    init_simple_test("Vp_BFu1i_Ui");
    static STRUCT_IF_C Vp_BFu1i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_Ui, Vp_BFu1i_Ui)
//============================================================================



static void Test_Vp_BFu1i_Ul()
{
  {
    init_simple_test("Vp_BFu1i_Ul");
    static STRUCT_IF_C Vp_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_Ul, Vp_BFu1i_Ul)
//============================================================================



static void Test_Vp_BFu1i_Us()
{
  {
    init_simple_test("Vp_BFu1i_Us");
    static STRUCT_IF_C Vp_BFu1i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_Us, Vp_BFu1i_Us)
//============================================================================



static void Test_Vp_BFu1i_Vp()
{
  {
    init_simple_test("Vp_BFu1i_Vp");
    static STRUCT_IF_C Vp_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1i_Vp, Vp_BFu1i_Vp)
//============================================================================



static void Test_Vp_BFu1ll()
{
  {
    init_simple_test("Vp_BFu1ll");
    static STRUCT_IF_C Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll, Vp_BFu1ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu15i");
    static STRUCT_IF_C Vp_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu15i, Vp_BFu1ll_BFu15i)
//============================================================================



static void Test_Vp_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu15ll, Vp_BFu1ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu1ll_BFu15s");
    static STRUCT_IF_C Vp_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu15s, Vp_BFu1ll_BFu15s)
//============================================================================



static void Test_Vp_BFu1ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu16i");
    static STRUCT_IF_C Vp_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu16i, Vp_BFu1ll_BFu16i)
//============================================================================



static void Test_Vp_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu16ll, Vp_BFu1ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu1ll_BFu16s");
    static STRUCT_IF_C Vp_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu16s, Vp_BFu1ll_BFu16s)
//============================================================================



static void Test_Vp_BFu1ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu17i");
    static STRUCT_IF_C Vp_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu17i, Vp_BFu1ll_BFu17i)
//============================================================================



static void Test_Vp_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu17ll, Vp_BFu1ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu1ll_BFu1c");
    static STRUCT_IF_C Vp_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu1c, Vp_BFu1ll_BFu1c)
//============================================================================



static void Test_Vp_BFu1ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu1i");
    static STRUCT_IF_C Vp_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu1i, Vp_BFu1ll_BFu1i)
//============================================================================



static void Test_Vp_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu1ll, Vp_BFu1ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu1ll_BFu1s");
    static STRUCT_IF_C Vp_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu1s, Vp_BFu1ll_BFu1s)
//============================================================================



static void Test_Vp_BFu1ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu31i");
    static STRUCT_IF_C Vp_BFu1ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu31i, Vp_BFu1ll_BFu31i)
//============================================================================



static void Test_Vp_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu31ll, Vp_BFu1ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu32i");
    static STRUCT_IF_C Vp_BFu1ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu32i, Vp_BFu1ll_BFu32i)
//============================================================================



static void Test_Vp_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu32ll, Vp_BFu1ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu33()
{
  {
    init_simple_test("Vp_BFu1ll_BFu33");
    static STRUCT_IF_C Vp_BFu1ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "Vp_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "Vp_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu33, Vp_BFu1ll_BFu33)
//============================================================================



static void Test_Vp_BFu1ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu1ll_BFu7c");
    static STRUCT_IF_C Vp_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu7c, Vp_BFu1ll_BFu7c)
//============================================================================



static void Test_Vp_BFu1ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu7i");
    static STRUCT_IF_C Vp_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu7i, Vp_BFu1ll_BFu7i)
//============================================================================



static void Test_Vp_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu7ll, Vp_BFu1ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu1ll_BFu7s");
    static STRUCT_IF_C Vp_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu7s, Vp_BFu1ll_BFu7s)
//============================================================================



static void Test_Vp_BFu1ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu1ll_BFu8c");
    static STRUCT_IF_C Vp_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu8c, Vp_BFu1ll_BFu8c)
//============================================================================



static void Test_Vp_BFu1ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu8i");
    static STRUCT_IF_C Vp_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu8i, Vp_BFu1ll_BFu8i)
//============================================================================



static void Test_Vp_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu8ll, Vp_BFu1ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu1ll_BFu8s");
    static STRUCT_IF_C Vp_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu8s, Vp_BFu1ll_BFu8s)
//============================================================================



static void Test_Vp_BFu1ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu1ll_BFu9i");
    static STRUCT_IF_C Vp_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu9i, Vp_BFu1ll_BFu9i)
//============================================================================



static void Test_Vp_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu1ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu9ll, Vp_BFu1ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu1ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu1ll_BFu9s");
    static STRUCT_IF_C Vp_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_BFu9s, Vp_BFu1ll_BFu9s)
//============================================================================



static void Test_Vp_BFu1ll_C()
{
  {
    init_simple_test("Vp_BFu1ll_C");
    static STRUCT_IF_C Vp_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_C, Vp_BFu1ll_C)
//============================================================================



static void Test_Vp_BFu1ll_D()
{
  {
    init_simple_test("Vp_BFu1ll_D");
    static STRUCT_IF_C Vp_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_D, Vp_BFu1ll_D)
//============================================================================



static void Test_Vp_BFu1ll_F()
{
  {
    init_simple_test("Vp_BFu1ll_F");
    static STRUCT_IF_C Vp_BFu1ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_F, Vp_BFu1ll_F)
//============================================================================



static void Test_Vp_BFu1ll_I()
{
  {
    init_simple_test("Vp_BFu1ll_I");
    static STRUCT_IF_C Vp_BFu1ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_I, Vp_BFu1ll_I)
//============================================================================



static void Test_Vp_BFu1ll_Ip()
{
  {
    init_simple_test("Vp_BFu1ll_Ip");
    static STRUCT_IF_C Vp_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_Ip, Vp_BFu1ll_Ip)
//============================================================================



static void Test_Vp_BFu1ll_L()
{
  {
    init_simple_test("Vp_BFu1ll_L");
    static STRUCT_IF_C Vp_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_L, Vp_BFu1ll_L)
//============================================================================



static void Test_Vp_BFu1ll_S()
{
  {
    init_simple_test("Vp_BFu1ll_S");
    static STRUCT_IF_C Vp_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_S, Vp_BFu1ll_S)
//============================================================================



static void Test_Vp_BFu1ll_Uc()
{
  {
    init_simple_test("Vp_BFu1ll_Uc");
    static STRUCT_IF_C Vp_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_Uc, Vp_BFu1ll_Uc)
//============================================================================



static void Test_Vp_BFu1ll_Ui()
{
  {
    init_simple_test("Vp_BFu1ll_Ui");
    static STRUCT_IF_C Vp_BFu1ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_Ui, Vp_BFu1ll_Ui)
//============================================================================



static void Test_Vp_BFu1ll_Ul()
{
  {
    init_simple_test("Vp_BFu1ll_Ul");
    static STRUCT_IF_C Vp_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_Ul, Vp_BFu1ll_Ul)
//============================================================================



static void Test_Vp_BFu1ll_Us()
{
  {
    init_simple_test("Vp_BFu1ll_Us");
    static STRUCT_IF_C Vp_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_Us, Vp_BFu1ll_Us)
//============================================================================



static void Test_Vp_BFu1ll_Vp()
{
  {
    init_simple_test("Vp_BFu1ll_Vp");
    static STRUCT_IF_C Vp_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1ll_Vp, Vp_BFu1ll_Vp)
//============================================================================



static void Test_Vp_BFu1s()
{
  {
    init_simple_test("Vp_BFu1s");
    static STRUCT_IF_C Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s, Vp_BFu1s)
//============================================================================



static void Test_Vp_BFu1s_BFu15i()
{
  {
    init_simple_test("Vp_BFu1s_BFu15i");
    static STRUCT_IF_C Vp_BFu1s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu15i, Vp_BFu1s_BFu15i)
//============================================================================



static void Test_Vp_BFu1s_BFu15ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu15ll");
    static STRUCT_IF_C Vp_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu15ll, Vp_BFu1s_BFu15ll)
//============================================================================



static void Test_Vp_BFu1s_BFu15s()
{
  {
    init_simple_test("Vp_BFu1s_BFu15s");
    static STRUCT_IF_C Vp_BFu1s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "Vp_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "Vp_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu15s, Vp_BFu1s_BFu15s)
//============================================================================



static void Test_Vp_BFu1s_BFu16i()
{
  {
    init_simple_test("Vp_BFu1s_BFu16i");
    static STRUCT_IF_C Vp_BFu1s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu16i, Vp_BFu1s_BFu16i)
//============================================================================



static void Test_Vp_BFu1s_BFu16ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu16ll");
    static STRUCT_IF_C Vp_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu16ll, Vp_BFu1s_BFu16ll)
//============================================================================



static void Test_Vp_BFu1s_BFu16s()
{
  {
    init_simple_test("Vp_BFu1s_BFu16s");
    static STRUCT_IF_C Vp_BFu1s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "Vp_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "Vp_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu16s, Vp_BFu1s_BFu16s)
//============================================================================



static void Test_Vp_BFu1s_BFu17i()
{
  {
    init_simple_test("Vp_BFu1s_BFu17i");
    static STRUCT_IF_C Vp_BFu1s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu17i, Vp_BFu1s_BFu17i)
//============================================================================



static void Test_Vp_BFu1s_BFu17ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu17ll");
    static STRUCT_IF_C Vp_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "Vp_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "Vp_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu17ll, Vp_BFu1s_BFu17ll)
//============================================================================



static void Test_Vp_BFu1s_BFu1c()
{
  {
    init_simple_test("Vp_BFu1s_BFu1c");
    static STRUCT_IF_C Vp_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu1c, Vp_BFu1s_BFu1c)
//============================================================================



static void Test_Vp_BFu1s_BFu1i()
{
  {
    init_simple_test("Vp_BFu1s_BFu1i");
    static STRUCT_IF_C Vp_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu1i, Vp_BFu1s_BFu1i)
//============================================================================



static void Test_Vp_BFu1s_BFu1ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu1ll");
    static STRUCT_IF_C Vp_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu1ll, Vp_BFu1s_BFu1ll)
//============================================================================



static void Test_Vp_BFu1s_BFu1s()
{
  {
    init_simple_test("Vp_BFu1s_BFu1s");
    static STRUCT_IF_C Vp_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "Vp_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu1s, Vp_BFu1s_BFu1s)
//============================================================================



static void Test_Vp_BFu1s_BFu31i()
{
  {
    init_simple_test("Vp_BFu1s_BFu31i");
    static STRUCT_IF_C Vp_BFu1s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu31i, Vp_BFu1s_BFu31i)
//============================================================================



static void Test_Vp_BFu1s_BFu31ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu31ll");
    static STRUCT_IF_C Vp_BFu1s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "Vp_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "Vp_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu31ll, Vp_BFu1s_BFu31ll)
//============================================================================



static void Test_Vp_BFu1s_BFu32i()
{
  {
    init_simple_test("Vp_BFu1s_BFu32i");
    static STRUCT_IF_C Vp_BFu1s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu32i, Vp_BFu1s_BFu32i)
//============================================================================



static void Test_Vp_BFu1s_BFu32ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu32ll");
    static STRUCT_IF_C Vp_BFu1s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "Vp_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "Vp_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu32ll, Vp_BFu1s_BFu32ll)
//============================================================================



static void Test_Vp_BFu1s_BFu33()
{
  {
    init_simple_test("Vp_BFu1s_BFu33");
    static STRUCT_IF_C Vp_BFu1s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "Vp_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "Vp_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu33, Vp_BFu1s_BFu33)
//============================================================================



static void Test_Vp_BFu1s_BFu7c()
{
  {
    init_simple_test("Vp_BFu1s_BFu7c");
    static STRUCT_IF_C Vp_BFu1s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu7c, Vp_BFu1s_BFu7c)
//============================================================================



static void Test_Vp_BFu1s_BFu7i()
{
  {
    init_simple_test("Vp_BFu1s_BFu7i");
    static STRUCT_IF_C Vp_BFu1s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu7i, Vp_BFu1s_BFu7i)
//============================================================================



static void Test_Vp_BFu1s_BFu7ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu7ll");
    static STRUCT_IF_C Vp_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu7ll, Vp_BFu1s_BFu7ll)
//============================================================================



static void Test_Vp_BFu1s_BFu7s()
{
  {
    init_simple_test("Vp_BFu1s_BFu7s");
    static STRUCT_IF_C Vp_BFu1s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "Vp_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "Vp_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu7s, Vp_BFu1s_BFu7s)
//============================================================================



static void Test_Vp_BFu1s_BFu8c()
{
  {
    init_simple_test("Vp_BFu1s_BFu8c");
    static STRUCT_IF_C Vp_BFu1s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu8c, Vp_BFu1s_BFu8c)
//============================================================================



static void Test_Vp_BFu1s_BFu8i()
{
  {
    init_simple_test("Vp_BFu1s_BFu8i");
    static STRUCT_IF_C Vp_BFu1s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu8i, Vp_BFu1s_BFu8i)
//============================================================================



static void Test_Vp_BFu1s_BFu8ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu8ll");
    static STRUCT_IF_C Vp_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu8ll, Vp_BFu1s_BFu8ll)
//============================================================================



static void Test_Vp_BFu1s_BFu8s()
{
  {
    init_simple_test("Vp_BFu1s_BFu8s");
    static STRUCT_IF_C Vp_BFu1s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "Vp_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "Vp_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu8s, Vp_BFu1s_BFu8s)
//============================================================================



static void Test_Vp_BFu1s_BFu9i()
{
  {
    init_simple_test("Vp_BFu1s_BFu9i");
    static STRUCT_IF_C Vp_BFu1s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu9i, Vp_BFu1s_BFu9i)
//============================================================================



static void Test_Vp_BFu1s_BFu9ll()
{
  {
    init_simple_test("Vp_BFu1s_BFu9ll");
    static STRUCT_IF_C Vp_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu9ll, Vp_BFu1s_BFu9ll)
//============================================================================



static void Test_Vp_BFu1s_BFu9s()
{
  {
    init_simple_test("Vp_BFu1s_BFu9s");
    static STRUCT_IF_C Vp_BFu1s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "Vp_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "Vp_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_BFu9s, Vp_BFu1s_BFu9s)
//============================================================================



static void Test_Vp_BFu1s_C()
{
  {
    init_simple_test("Vp_BFu1s_C");
    static STRUCT_IF_C Vp_BFu1s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_C, Vp_BFu1s_C)
//============================================================================



static void Test_Vp_BFu1s_D()
{
  {
    init_simple_test("Vp_BFu1s_D");
    static STRUCT_IF_C Vp_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_D, Vp_BFu1s_D)
//============================================================================



static void Test_Vp_BFu1s_F()
{
  {
    init_simple_test("Vp_BFu1s_F");
    static STRUCT_IF_C Vp_BFu1s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_F, Vp_BFu1s_F)
//============================================================================



static void Test_Vp_BFu1s_I()
{
  {
    init_simple_test("Vp_BFu1s_I");
    static STRUCT_IF_C Vp_BFu1s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_I, Vp_BFu1s_I)
//============================================================================



static void Test_Vp_BFu1s_Ip()
{
  {
    init_simple_test("Vp_BFu1s_Ip");
    static STRUCT_IF_C Vp_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_Ip, Vp_BFu1s_Ip)
//============================================================================



static void Test_Vp_BFu1s_L()
{
  {
    init_simple_test("Vp_BFu1s_L");
    static STRUCT_IF_C Vp_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_L, Vp_BFu1s_L)
//============================================================================



static void Test_Vp_BFu1s_S()
{
  {
    init_simple_test("Vp_BFu1s_S");
    static STRUCT_IF_C Vp_BFu1s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_S, Vp_BFu1s_S)
//============================================================================



static void Test_Vp_BFu1s_Uc()
{
  {
    init_simple_test("Vp_BFu1s_Uc");
    static STRUCT_IF_C Vp_BFu1s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_Uc, Vp_BFu1s_Uc)
//============================================================================



static void Test_Vp_BFu1s_Ui()
{
  {
    init_simple_test("Vp_BFu1s_Ui");
    static STRUCT_IF_C Vp_BFu1s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_Ui, Vp_BFu1s_Ui)
//============================================================================



static void Test_Vp_BFu1s_Ul()
{
  {
    init_simple_test("Vp_BFu1s_Ul");
    static STRUCT_IF_C Vp_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_Ul, Vp_BFu1s_Ul)
//============================================================================



static void Test_Vp_BFu1s_Us()
{
  {
    init_simple_test("Vp_BFu1s_Us");
    static STRUCT_IF_C Vp_BFu1s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_Us, Vp_BFu1s_Us)
//============================================================================



static void Test_Vp_BFu1s_Vp()
{
  {
    init_simple_test("Vp_BFu1s_Vp");
    static STRUCT_IF_C Vp_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Vp_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu1s_Vp, Vp_BFu1s_Vp)
//============================================================================



static void Test_Vp_BFu31i()
{
  {
    init_simple_test("Vp_BFu31i");
    static STRUCT_IF_C Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i, Vp_BFu31i)
//============================================================================



static void Test_Vp_BFu31i_BFu15i()
{
  {
    init_simple_test("Vp_BFu31i_BFu15i");
    static STRUCT_IF_C Vp_BFu31i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "Vp_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "Vp_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu15i, Vp_BFu31i_BFu15i)
//============================================================================



static void Test_Vp_BFu31i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu15ll");
    static STRUCT_IF_C Vp_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "Vp_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "Vp_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu15ll, Vp_BFu31i_BFu15ll)
//============================================================================



static void Test_Vp_BFu31i_BFu15s()
{
  {
    init_simple_test("Vp_BFu31i_BFu15s");
    static STRUCT_IF_C Vp_BFu31i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "Vp_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "Vp_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu15s, Vp_BFu31i_BFu15s)
//============================================================================



static void Test_Vp_BFu31i_BFu16i()
{
  {
    init_simple_test("Vp_BFu31i_BFu16i");
    static STRUCT_IF_C Vp_BFu31i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "Vp_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "Vp_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu16i, Vp_BFu31i_BFu16i)
//============================================================================



static void Test_Vp_BFu31i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu16ll");
    static STRUCT_IF_C Vp_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "Vp_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "Vp_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu16ll, Vp_BFu31i_BFu16ll)
//============================================================================



static void Test_Vp_BFu31i_BFu16s()
{
  {
    init_simple_test("Vp_BFu31i_BFu16s");
    static STRUCT_IF_C Vp_BFu31i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "Vp_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "Vp_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu16s, Vp_BFu31i_BFu16s)
//============================================================================



static void Test_Vp_BFu31i_BFu17i()
{
  {
    init_simple_test("Vp_BFu31i_BFu17i");
    static STRUCT_IF_C Vp_BFu31i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "Vp_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "Vp_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu17i, Vp_BFu31i_BFu17i)
//============================================================================



static void Test_Vp_BFu31i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu17ll");
    static STRUCT_IF_C Vp_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "Vp_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "Vp_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu17ll, Vp_BFu31i_BFu17ll)
//============================================================================



static void Test_Vp_BFu31i_BFu1c()
{
  {
    init_simple_test("Vp_BFu31i_BFu1c");
    static STRUCT_IF_C Vp_BFu31i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu1c, Vp_BFu31i_BFu1c)
//============================================================================



static void Test_Vp_BFu31i_BFu1i()
{
  {
    init_simple_test("Vp_BFu31i_BFu1i");
    static STRUCT_IF_C Vp_BFu31i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu1i, Vp_BFu31i_BFu1i)
//============================================================================



static void Test_Vp_BFu31i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu1ll");
    static STRUCT_IF_C Vp_BFu31i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu1ll, Vp_BFu31i_BFu1ll)
//============================================================================



static void Test_Vp_BFu31i_BFu1s()
{
  {
    init_simple_test("Vp_BFu31i_BFu1s");
    static STRUCT_IF_C Vp_BFu31i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu1s, Vp_BFu31i_BFu1s)
//============================================================================



static void Test_Vp_BFu31i_BFu31i()
{
  {
    init_simple_test("Vp_BFu31i_BFu31i");
    static STRUCT_IF_C Vp_BFu31i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "Vp_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu31i, Vp_BFu31i_BFu31i)
//============================================================================



static void Test_Vp_BFu31i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu31ll");
    static STRUCT_IF_C Vp_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "Vp_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu31ll, Vp_BFu31i_BFu31ll)
//============================================================================



static void Test_Vp_BFu31i_BFu32i()
{
  {
    init_simple_test("Vp_BFu31i_BFu32i");
    static STRUCT_IF_C Vp_BFu31i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "Vp_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "Vp_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu32i, Vp_BFu31i_BFu32i)
//============================================================================



static void Test_Vp_BFu31i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu32ll");
    static STRUCT_IF_C Vp_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "Vp_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "Vp_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu32ll, Vp_BFu31i_BFu32ll)
//============================================================================



static void Test_Vp_BFu31i_BFu33()
{
  {
    init_simple_test("Vp_BFu31i_BFu33");
    static STRUCT_IF_C Vp_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, 1, "Vp_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, hide_ull(1LL<<32), "Vp_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu33, Vp_BFu31i_BFu33)
//============================================================================



static void Test_Vp_BFu31i_BFu7c()
{
  {
    init_simple_test("Vp_BFu31i_BFu7c");
    static STRUCT_IF_C Vp_BFu31i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu7c, Vp_BFu31i_BFu7c)
//============================================================================



static void Test_Vp_BFu31i_BFu7i()
{
  {
    init_simple_test("Vp_BFu31i_BFu7i");
    static STRUCT_IF_C Vp_BFu31i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu7i, Vp_BFu31i_BFu7i)
//============================================================================



static void Test_Vp_BFu31i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu7ll");
    static STRUCT_IF_C Vp_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu7ll, Vp_BFu31i_BFu7ll)
//============================================================================



static void Test_Vp_BFu31i_BFu7s()
{
  {
    init_simple_test("Vp_BFu31i_BFu7s");
    static STRUCT_IF_C Vp_BFu31i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu7s, Vp_BFu31i_BFu7s)
//============================================================================



static void Test_Vp_BFu31i_BFu8c()
{
  {
    init_simple_test("Vp_BFu31i_BFu8c");
    static STRUCT_IF_C Vp_BFu31i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu8c, Vp_BFu31i_BFu8c)
//============================================================================



static void Test_Vp_BFu31i_BFu8i()
{
  {
    init_simple_test("Vp_BFu31i_BFu8i");
    static STRUCT_IF_C Vp_BFu31i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu8i, Vp_BFu31i_BFu8i)
//============================================================================



static void Test_Vp_BFu31i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu8ll");
    static STRUCT_IF_C Vp_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu8ll, Vp_BFu31i_BFu8ll)
//============================================================================



static void Test_Vp_BFu31i_BFu8s()
{
  {
    init_simple_test("Vp_BFu31i_BFu8s");
    static STRUCT_IF_C Vp_BFu31i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu8s, Vp_BFu31i_BFu8s)
//============================================================================



static void Test_Vp_BFu31i_BFu9i()
{
  {
    init_simple_test("Vp_BFu31i_BFu9i");
    static STRUCT_IF_C Vp_BFu31i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "Vp_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "Vp_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu9i, Vp_BFu31i_BFu9i)
//============================================================================



static void Test_Vp_BFu31i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu31i_BFu9ll");
    static STRUCT_IF_C Vp_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "Vp_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "Vp_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu9ll, Vp_BFu31i_BFu9ll)
//============================================================================



static void Test_Vp_BFu31i_BFu9s()
{
  {
    init_simple_test("Vp_BFu31i_BFu9s");
    static STRUCT_IF_C Vp_BFu31i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "Vp_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "Vp_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_BFu9s, Vp_BFu31i_BFu9s)
//============================================================================



static void Test_Vp_BFu31i_C()
{
  {
    init_simple_test("Vp_BFu31i_C");
    static STRUCT_IF_C Vp_BFu31i_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_C, Vp_BFu31i_C)
//============================================================================



static void Test_Vp_BFu31i_D()
{
  {
    init_simple_test("Vp_BFu31i_D");
    static STRUCT_IF_C Vp_BFu31i_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_D, Vp_BFu31i_D)
//============================================================================



static void Test_Vp_BFu31i_F()
{
  {
    init_simple_test("Vp_BFu31i_F");
    static STRUCT_IF_C Vp_BFu31i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_F, Vp_BFu31i_F)
//============================================================================



static void Test_Vp_BFu31i_I()
{
  {
    init_simple_test("Vp_BFu31i_I");
    static STRUCT_IF_C Vp_BFu31i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_I, Vp_BFu31i_I)
//============================================================================



static void Test_Vp_BFu31i_Ip()
{
  {
    init_simple_test("Vp_BFu31i_Ip");
    static STRUCT_IF_C Vp_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_Ip, Vp_BFu31i_Ip)
//============================================================================



static void Test_Vp_BFu31i_L()
{
  {
    init_simple_test("Vp_BFu31i_L");
    static STRUCT_IF_C Vp_BFu31i_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_L, Vp_BFu31i_L)
//============================================================================



static void Test_Vp_BFu31i_S()
{
  {
    init_simple_test("Vp_BFu31i_S");
    static STRUCT_IF_C Vp_BFu31i_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_S, Vp_BFu31i_S)
//============================================================================



static void Test_Vp_BFu31i_Uc()
{
  {
    init_simple_test("Vp_BFu31i_Uc");
    static STRUCT_IF_C Vp_BFu31i_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_Uc, Vp_BFu31i_Uc)
//============================================================================



static void Test_Vp_BFu31i_Ui()
{
  {
    init_simple_test("Vp_BFu31i_Ui");
    static STRUCT_IF_C Vp_BFu31i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_Ui, Vp_BFu31i_Ui)
//============================================================================



static void Test_Vp_BFu31i_Ul()
{
  {
    init_simple_test("Vp_BFu31i_Ul");
    static STRUCT_IF_C Vp_BFu31i_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_Ul, Vp_BFu31i_Ul)
//============================================================================



static void Test_Vp_BFu31i_Us()
{
  {
    init_simple_test("Vp_BFu31i_Us");
    static STRUCT_IF_C Vp_BFu31i_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_Us, Vp_BFu31i_Us)
//============================================================================



static void Test_Vp_BFu31i_Vp()
{
  {
    init_simple_test("Vp_BFu31i_Vp");
    static STRUCT_IF_C Vp_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31i_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31i_Vp, Vp_BFu31i_Vp)
//============================================================================



static void Test_Vp_BFu31ll()
{
  {
    init_simple_test("Vp_BFu31ll");
    static STRUCT_IF_C Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll, Vp_BFu31ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu15i");
    static STRUCT_IF_C Vp_BFu31ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "Vp_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "Vp_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu15i, Vp_BFu31ll_BFu15i)
//============================================================================



static void Test_Vp_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "Vp_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "Vp_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu15ll, Vp_BFu31ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu31ll_BFu15s");
    static STRUCT_IF_C Vp_BFu31ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "Vp_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "Vp_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu15s, Vp_BFu31ll_BFu15s)
//============================================================================



static void Test_Vp_BFu31ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu16i");
    static STRUCT_IF_C Vp_BFu31ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "Vp_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "Vp_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu16i, Vp_BFu31ll_BFu16i)
//============================================================================



static void Test_Vp_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "Vp_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "Vp_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu16ll, Vp_BFu31ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu31ll_BFu16s");
    static STRUCT_IF_C Vp_BFu31ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "Vp_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "Vp_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu16s, Vp_BFu31ll_BFu16s)
//============================================================================



static void Test_Vp_BFu31ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu17i");
    static STRUCT_IF_C Vp_BFu31ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "Vp_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "Vp_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu17i, Vp_BFu31ll_BFu17i)
//============================================================================



static void Test_Vp_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "Vp_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "Vp_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu17ll, Vp_BFu31ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu31ll_BFu1c");
    static STRUCT_IF_C Vp_BFu31ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu1c, Vp_BFu31ll_BFu1c)
//============================================================================



static void Test_Vp_BFu31ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu1i");
    static STRUCT_IF_C Vp_BFu31ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu1i, Vp_BFu31ll_BFu1i)
//============================================================================



static void Test_Vp_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu1ll, Vp_BFu31ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu31ll_BFu1s");
    static STRUCT_IF_C Vp_BFu31ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "Vp_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu1s, Vp_BFu31ll_BFu1s)
//============================================================================



static void Test_Vp_BFu31ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu31i");
    static STRUCT_IF_C Vp_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "Vp_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu31i, Vp_BFu31ll_BFu31i)
//============================================================================



static void Test_Vp_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "Vp_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu31ll, Vp_BFu31ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu32i");
    static STRUCT_IF_C Vp_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "Vp_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "Vp_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu32i, Vp_BFu31ll_BFu32i)
//============================================================================



static void Test_Vp_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "Vp_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "Vp_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu32ll, Vp_BFu31ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu33()
{
  {
    init_simple_test("Vp_BFu31ll_BFu33");
    static STRUCT_IF_C Vp_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, 1, "Vp_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, hide_ull(1LL<<32), "Vp_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu33, Vp_BFu31ll_BFu33)
//============================================================================



static void Test_Vp_BFu31ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu31ll_BFu7c");
    static STRUCT_IF_C Vp_BFu31ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu7c, Vp_BFu31ll_BFu7c)
//============================================================================



static void Test_Vp_BFu31ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu7i");
    static STRUCT_IF_C Vp_BFu31ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu7i, Vp_BFu31ll_BFu7i)
//============================================================================



static void Test_Vp_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu7ll, Vp_BFu31ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu31ll_BFu7s");
    static STRUCT_IF_C Vp_BFu31ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "Vp_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "Vp_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu7s, Vp_BFu31ll_BFu7s)
//============================================================================



static void Test_Vp_BFu31ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu31ll_BFu8c");
    static STRUCT_IF_C Vp_BFu31ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu8c, Vp_BFu31ll_BFu8c)
//============================================================================



static void Test_Vp_BFu31ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu8i");
    static STRUCT_IF_C Vp_BFu31ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu8i, Vp_BFu31ll_BFu8i)
//============================================================================



static void Test_Vp_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu8ll, Vp_BFu31ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu31ll_BFu8s");
    static STRUCT_IF_C Vp_BFu31ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "Vp_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "Vp_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu8s, Vp_BFu31ll_BFu8s)
//============================================================================



static void Test_Vp_BFu31ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu31ll_BFu9i");
    static STRUCT_IF_C Vp_BFu31ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "Vp_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "Vp_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu9i, Vp_BFu31ll_BFu9i)
//============================================================================



static void Test_Vp_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu31ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "Vp_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "Vp_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu9ll, Vp_BFu31ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu31ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu31ll_BFu9s");
    static STRUCT_IF_C Vp_BFu31ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "Vp_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "Vp_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_BFu9s, Vp_BFu31ll_BFu9s)
//============================================================================



static void Test_Vp_BFu31ll_C()
{
  {
    init_simple_test("Vp_BFu31ll_C");
    static STRUCT_IF_C Vp_BFu31ll_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_C, Vp_BFu31ll_C)
//============================================================================



static void Test_Vp_BFu31ll_D()
{
  {
    init_simple_test("Vp_BFu31ll_D");
    static STRUCT_IF_C Vp_BFu31ll_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_D, Vp_BFu31ll_D)
//============================================================================



static void Test_Vp_BFu31ll_F()
{
  {
    init_simple_test("Vp_BFu31ll_F");
    static STRUCT_IF_C Vp_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_F, Vp_BFu31ll_F)
//============================================================================



static void Test_Vp_BFu31ll_I()
{
  {
    init_simple_test("Vp_BFu31ll_I");
    static STRUCT_IF_C Vp_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_I, Vp_BFu31ll_I)
//============================================================================



static void Test_Vp_BFu31ll_Ip()
{
  {
    init_simple_test("Vp_BFu31ll_Ip");
    static STRUCT_IF_C Vp_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_Ip, Vp_BFu31ll_Ip)
//============================================================================



static void Test_Vp_BFu31ll_L()
{
  {
    init_simple_test("Vp_BFu31ll_L");
    static STRUCT_IF_C Vp_BFu31ll_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_L, Vp_BFu31ll_L)
//============================================================================



static void Test_Vp_BFu31ll_S()
{
  {
    init_simple_test("Vp_BFu31ll_S");
    static STRUCT_IF_C Vp_BFu31ll_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_S, Vp_BFu31ll_S)
//============================================================================



static void Test_Vp_BFu31ll_Uc()
{
  {
    init_simple_test("Vp_BFu31ll_Uc");
    static STRUCT_IF_C Vp_BFu31ll_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_Uc, Vp_BFu31ll_Uc)
//============================================================================



static void Test_Vp_BFu31ll_Ui()
{
  {
    init_simple_test("Vp_BFu31ll_Ui");
    static STRUCT_IF_C Vp_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_Ui, Vp_BFu31ll_Ui)
//============================================================================



static void Test_Vp_BFu31ll_Ul()
{
  {
    init_simple_test("Vp_BFu31ll_Ul");
    static STRUCT_IF_C Vp_BFu31ll_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_Ul, Vp_BFu31ll_Ul)
//============================================================================



static void Test_Vp_BFu31ll_Us()
{
  {
    init_simple_test("Vp_BFu31ll_Us");
    static STRUCT_IF_C Vp_BFu31ll_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_Us, Vp_BFu31ll_Us)
//============================================================================



static void Test_Vp_BFu31ll_Vp()
{
  {
    init_simple_test("Vp_BFu31ll_Vp");
    static STRUCT_IF_C Vp_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Vp_BFu31ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Vp_BFu31ll_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu31ll_Vp, Vp_BFu31ll_Vp)
//============================================================================



static void Test_Vp_BFu32i()
{
  {
    init_simple_test("Vp_BFu32i");
    static STRUCT_IF_C Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i, Vp_BFu32i)
//============================================================================



static void Test_Vp_BFu32i_BFu15i()
{
  {
    init_simple_test("Vp_BFu32i_BFu15i");
    static STRUCT_IF_C Vp_BFu32i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Vp_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Vp_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu15i, Vp_BFu32i_BFu15i)
//============================================================================



static void Test_Vp_BFu32i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu15ll");
    static STRUCT_IF_C Vp_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Vp_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Vp_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu15ll, Vp_BFu32i_BFu15ll)
//============================================================================



static void Test_Vp_BFu32i_BFu15s()
{
  {
    init_simple_test("Vp_BFu32i_BFu15s");
    static STRUCT_IF_C Vp_BFu32i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Vp_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Vp_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu15s, Vp_BFu32i_BFu15s)
//============================================================================



static void Test_Vp_BFu32i_BFu16i()
{
  {
    init_simple_test("Vp_BFu32i_BFu16i");
    static STRUCT_IF_C Vp_BFu32i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Vp_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Vp_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu16i, Vp_BFu32i_BFu16i)
//============================================================================



static void Test_Vp_BFu32i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu16ll");
    static STRUCT_IF_C Vp_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Vp_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Vp_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu16ll, Vp_BFu32i_BFu16ll)
//============================================================================



static void Test_Vp_BFu32i_BFu16s()
{
  {
    init_simple_test("Vp_BFu32i_BFu16s");
    static STRUCT_IF_C Vp_BFu32i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Vp_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Vp_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu16s, Vp_BFu32i_BFu16s)
//============================================================================



static void Test_Vp_BFu32i_BFu17i()
{
  {
    init_simple_test("Vp_BFu32i_BFu17i");
    static STRUCT_IF_C Vp_BFu32i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Vp_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Vp_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu17i, Vp_BFu32i_BFu17i)
//============================================================================



static void Test_Vp_BFu32i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu17ll");
    static STRUCT_IF_C Vp_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Vp_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Vp_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu17ll, Vp_BFu32i_BFu17ll)
//============================================================================



static void Test_Vp_BFu32i_BFu1c()
{
  {
    init_simple_test("Vp_BFu32i_BFu1c");
    static STRUCT_IF_C Vp_BFu32i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu1c, Vp_BFu32i_BFu1c)
//============================================================================



static void Test_Vp_BFu32i_BFu1i()
{
  {
    init_simple_test("Vp_BFu32i_BFu1i");
    static STRUCT_IF_C Vp_BFu32i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu1i, Vp_BFu32i_BFu1i)
//============================================================================



static void Test_Vp_BFu32i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu1ll");
    static STRUCT_IF_C Vp_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu1ll, Vp_BFu32i_BFu1ll)
//============================================================================



static void Test_Vp_BFu32i_BFu1s()
{
  {
    init_simple_test("Vp_BFu32i_BFu1s");
    static STRUCT_IF_C Vp_BFu32i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu1s, Vp_BFu32i_BFu1s)
//============================================================================



static void Test_Vp_BFu32i_BFu31i()
{
  {
    init_simple_test("Vp_BFu32i_BFu31i");
    static STRUCT_IF_C Vp_BFu32i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Vp_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Vp_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu31i, Vp_BFu32i_BFu31i)
//============================================================================



static void Test_Vp_BFu32i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu31ll");
    static STRUCT_IF_C Vp_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Vp_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Vp_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu31ll, Vp_BFu32i_BFu31ll)
//============================================================================



static void Test_Vp_BFu32i_BFu32i()
{
  {
    init_simple_test("Vp_BFu32i_BFu32i");
    static STRUCT_IF_C Vp_BFu32i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Vp_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu32i, Vp_BFu32i_BFu32i)
//============================================================================



static void Test_Vp_BFu32i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu32ll");
    static STRUCT_IF_C Vp_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Vp_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu32ll, Vp_BFu32i_BFu32ll)
//============================================================================



static void Test_Vp_BFu32i_BFu33()
{
  {
    init_simple_test("Vp_BFu32i_BFu33");
    static STRUCT_IF_C Vp_BFu32i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "Vp_BFu32i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "Vp_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu33, Vp_BFu32i_BFu33)
//============================================================================



static void Test_Vp_BFu32i_BFu7c()
{
  {
    init_simple_test("Vp_BFu32i_BFu7c");
    static STRUCT_IF_C Vp_BFu32i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu7c, Vp_BFu32i_BFu7c)
//============================================================================



static void Test_Vp_BFu32i_BFu7i()
{
  {
    init_simple_test("Vp_BFu32i_BFu7i");
    static STRUCT_IF_C Vp_BFu32i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu7i, Vp_BFu32i_BFu7i)
//============================================================================



static void Test_Vp_BFu32i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu7ll");
    static STRUCT_IF_C Vp_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu7ll, Vp_BFu32i_BFu7ll)
//============================================================================



static void Test_Vp_BFu32i_BFu7s()
{
  {
    init_simple_test("Vp_BFu32i_BFu7s");
    static STRUCT_IF_C Vp_BFu32i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu7s, Vp_BFu32i_BFu7s)
//============================================================================



static void Test_Vp_BFu32i_BFu8c()
{
  {
    init_simple_test("Vp_BFu32i_BFu8c");
    static STRUCT_IF_C Vp_BFu32i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu8c, Vp_BFu32i_BFu8c)
//============================================================================



static void Test_Vp_BFu32i_BFu8i()
{
  {
    init_simple_test("Vp_BFu32i_BFu8i");
    static STRUCT_IF_C Vp_BFu32i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu8i, Vp_BFu32i_BFu8i)
//============================================================================



static void Test_Vp_BFu32i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu8ll");
    static STRUCT_IF_C Vp_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu8ll, Vp_BFu32i_BFu8ll)
//============================================================================



static void Test_Vp_BFu32i_BFu8s()
{
  {
    init_simple_test("Vp_BFu32i_BFu8s");
    static STRUCT_IF_C Vp_BFu32i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu8s, Vp_BFu32i_BFu8s)
//============================================================================



static void Test_Vp_BFu32i_BFu9i()
{
  {
    init_simple_test("Vp_BFu32i_BFu9i");
    static STRUCT_IF_C Vp_BFu32i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Vp_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Vp_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu9i, Vp_BFu32i_BFu9i)
//============================================================================



static void Test_Vp_BFu32i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu32i_BFu9ll");
    static STRUCT_IF_C Vp_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Vp_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Vp_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu9ll, Vp_BFu32i_BFu9ll)
//============================================================================



static void Test_Vp_BFu32i_BFu9s()
{
  {
    init_simple_test("Vp_BFu32i_BFu9s");
    static STRUCT_IF_C Vp_BFu32i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Vp_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Vp_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_BFu9s, Vp_BFu32i_BFu9s)
//============================================================================



static void Test_Vp_BFu32i_C()
{
  {
    init_simple_test("Vp_BFu32i_C");
    static STRUCT_IF_C Vp_BFu32i_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_C, Vp_BFu32i_C)
//============================================================================



static void Test_Vp_BFu32i_D()
{
  {
    init_simple_test("Vp_BFu32i_D");
    static STRUCT_IF_C Vp_BFu32i_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_D, Vp_BFu32i_D)
//============================================================================



static void Test_Vp_BFu32i_F()
{
  {
    init_simple_test("Vp_BFu32i_F");
    static STRUCT_IF_C Vp_BFu32i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_F, Vp_BFu32i_F)
//============================================================================



static void Test_Vp_BFu32i_I()
{
  {
    init_simple_test("Vp_BFu32i_I");
    static STRUCT_IF_C Vp_BFu32i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_I, Vp_BFu32i_I)
//============================================================================



static void Test_Vp_BFu32i_Ip()
{
  {
    init_simple_test("Vp_BFu32i_Ip");
    static STRUCT_IF_C Vp_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_Ip, Vp_BFu32i_Ip)
//============================================================================



static void Test_Vp_BFu32i_L()
{
  {
    init_simple_test("Vp_BFu32i_L");
    static STRUCT_IF_C Vp_BFu32i_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_L, Vp_BFu32i_L)
//============================================================================



static void Test_Vp_BFu32i_S()
{
  {
    init_simple_test("Vp_BFu32i_S");
    static STRUCT_IF_C Vp_BFu32i_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_S, Vp_BFu32i_S)
//============================================================================



static void Test_Vp_BFu32i_Uc()
{
  {
    init_simple_test("Vp_BFu32i_Uc");
    static STRUCT_IF_C Vp_BFu32i_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_Uc, Vp_BFu32i_Uc)
//============================================================================



static void Test_Vp_BFu32i_Ui()
{
  {
    init_simple_test("Vp_BFu32i_Ui");
    static STRUCT_IF_C Vp_BFu32i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_Ui, Vp_BFu32i_Ui)
//============================================================================



static void Test_Vp_BFu32i_Ul()
{
  {
    init_simple_test("Vp_BFu32i_Ul");
    static STRUCT_IF_C Vp_BFu32i_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_Ul, Vp_BFu32i_Ul)
//============================================================================



static void Test_Vp_BFu32i_Us()
{
  {
    init_simple_test("Vp_BFu32i_Us");
    static STRUCT_IF_C Vp_BFu32i_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_Us, Vp_BFu32i_Us)
//============================================================================



static void Test_Vp_BFu32i_Vp()
{
  {
    init_simple_test("Vp_BFu32i_Vp");
    static STRUCT_IF_C Vp_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32i_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32i_Vp, Vp_BFu32i_Vp)
//============================================================================



static void Test_Vp_BFu32ll()
{
  {
    init_simple_test("Vp_BFu32ll");
    static STRUCT_IF_C Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll, Vp_BFu32ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu15i");
    static STRUCT_IF_C Vp_BFu32ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Vp_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Vp_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu15i, Vp_BFu32ll_BFu15i)
//============================================================================



static void Test_Vp_BFu32ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Vp_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Vp_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu15ll, Vp_BFu32ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu32ll_BFu15s");
    static STRUCT_IF_C Vp_BFu32ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Vp_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Vp_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu15s, Vp_BFu32ll_BFu15s)
//============================================================================



static void Test_Vp_BFu32ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu16i");
    static STRUCT_IF_C Vp_BFu32ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Vp_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Vp_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu16i, Vp_BFu32ll_BFu16i)
//============================================================================



static void Test_Vp_BFu32ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Vp_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Vp_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu16ll, Vp_BFu32ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu32ll_BFu16s");
    static STRUCT_IF_C Vp_BFu32ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Vp_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Vp_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu16s, Vp_BFu32ll_BFu16s)
//============================================================================



static void Test_Vp_BFu32ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu17i");
    static STRUCT_IF_C Vp_BFu32ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Vp_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Vp_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu17i, Vp_BFu32ll_BFu17i)
//============================================================================



static void Test_Vp_BFu32ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Vp_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Vp_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu17ll, Vp_BFu32ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu32ll_BFu1c");
    static STRUCT_IF_C Vp_BFu32ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu1c, Vp_BFu32ll_BFu1c)
//============================================================================



static void Test_Vp_BFu32ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu1i");
    static STRUCT_IF_C Vp_BFu32ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu1i, Vp_BFu32ll_BFu1i)
//============================================================================



static void Test_Vp_BFu32ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu1ll, Vp_BFu32ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu32ll_BFu1s");
    static STRUCT_IF_C Vp_BFu32ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Vp_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu1s, Vp_BFu32ll_BFu1s)
//============================================================================



static void Test_Vp_BFu32ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu31i");
    static STRUCT_IF_C Vp_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Vp_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Vp_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu31i, Vp_BFu32ll_BFu31i)
//============================================================================



static void Test_Vp_BFu32ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Vp_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Vp_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu31ll, Vp_BFu32ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu32i");
    static STRUCT_IF_C Vp_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Vp_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu32i, Vp_BFu32ll_BFu32i)
//============================================================================



static void Test_Vp_BFu32ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Vp_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu32ll, Vp_BFu32ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu33()
{
  {
    init_simple_test("Vp_BFu32ll_BFu33");
    static STRUCT_IF_C Vp_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "Vp_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "Vp_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu33, Vp_BFu32ll_BFu33)
//============================================================================



static void Test_Vp_BFu32ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu32ll_BFu7c");
    static STRUCT_IF_C Vp_BFu32ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu7c, Vp_BFu32ll_BFu7c)
//============================================================================



static void Test_Vp_BFu32ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu7i");
    static STRUCT_IF_C Vp_BFu32ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu7i, Vp_BFu32ll_BFu7i)
//============================================================================



static void Test_Vp_BFu32ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu7ll, Vp_BFu32ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu32ll_BFu7s");
    static STRUCT_IF_C Vp_BFu32ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Vp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Vp_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu7s, Vp_BFu32ll_BFu7s)
//============================================================================



static void Test_Vp_BFu32ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu32ll_BFu8c");
    static STRUCT_IF_C Vp_BFu32ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu8c, Vp_BFu32ll_BFu8c)
//============================================================================



static void Test_Vp_BFu32ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu8i");
    static STRUCT_IF_C Vp_BFu32ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu8i, Vp_BFu32ll_BFu8i)
//============================================================================



static void Test_Vp_BFu32ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu8ll, Vp_BFu32ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu32ll_BFu8s");
    static STRUCT_IF_C Vp_BFu32ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Vp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Vp_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu8s, Vp_BFu32ll_BFu8s)
//============================================================================



static void Test_Vp_BFu32ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu32ll_BFu9i");
    static STRUCT_IF_C Vp_BFu32ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Vp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Vp_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu9i, Vp_BFu32ll_BFu9i)
//============================================================================



static void Test_Vp_BFu32ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu32ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Vp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Vp_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu9ll, Vp_BFu32ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu32ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu32ll_BFu9s");
    static STRUCT_IF_C Vp_BFu32ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Vp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Vp_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_BFu9s, Vp_BFu32ll_BFu9s)
//============================================================================



static void Test_Vp_BFu32ll_C()
{
  {
    init_simple_test("Vp_BFu32ll_C");
    static STRUCT_IF_C Vp_BFu32ll_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_C, Vp_BFu32ll_C)
//============================================================================



static void Test_Vp_BFu32ll_D()
{
  {
    init_simple_test("Vp_BFu32ll_D");
    static STRUCT_IF_C Vp_BFu32ll_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_D, Vp_BFu32ll_D)
//============================================================================



static void Test_Vp_BFu32ll_F()
{
  {
    init_simple_test("Vp_BFu32ll_F");
    static STRUCT_IF_C Vp_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_F, Vp_BFu32ll_F)
//============================================================================



static void Test_Vp_BFu32ll_I()
{
  {
    init_simple_test("Vp_BFu32ll_I");
    static STRUCT_IF_C Vp_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_I, Vp_BFu32ll_I)
//============================================================================



static void Test_Vp_BFu32ll_Ip()
{
  {
    init_simple_test("Vp_BFu32ll_Ip");
    static STRUCT_IF_C Vp_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_Ip, Vp_BFu32ll_Ip)
//============================================================================



static void Test_Vp_BFu32ll_L()
{
  {
    init_simple_test("Vp_BFu32ll_L");
    static STRUCT_IF_C Vp_BFu32ll_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_L, Vp_BFu32ll_L)
//============================================================================



static void Test_Vp_BFu32ll_S()
{
  {
    init_simple_test("Vp_BFu32ll_S");
    static STRUCT_IF_C Vp_BFu32ll_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_S, Vp_BFu32ll_S)
//============================================================================



static void Test_Vp_BFu32ll_Uc()
{
  {
    init_simple_test("Vp_BFu32ll_Uc");
    static STRUCT_IF_C Vp_BFu32ll_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_Uc, Vp_BFu32ll_Uc)
//============================================================================



static void Test_Vp_BFu32ll_Ui()
{
  {
    init_simple_test("Vp_BFu32ll_Ui");
    static STRUCT_IF_C Vp_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_Ui, Vp_BFu32ll_Ui)
//============================================================================



static void Test_Vp_BFu32ll_Ul()
{
  {
    init_simple_test("Vp_BFu32ll_Ul");
    static STRUCT_IF_C Vp_BFu32ll_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Vp_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_Ul, Vp_BFu32ll_Ul)
//============================================================================



static void Test_Vp_BFu32ll_Us()
{
  {
    init_simple_test("Vp_BFu32ll_Us");
    static STRUCT_IF_C Vp_BFu32ll_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_Us, Vp_BFu32ll_Us)
//============================================================================



static void Test_Vp_BFu32ll_Vp()
{
  {
    init_simple_test("Vp_BFu32ll_Vp");
    static STRUCT_IF_C Vp_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Vp_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Vp_BFu32ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Vp_BFu32ll_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "Vp_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu32ll_Vp, Vp_BFu32ll_Vp)
//============================================================================



static void Test_Vp_BFu33()
{
  {
    init_simple_test("Vp_BFu33");
    static STRUCT_IF_C Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33, Vp_BFu33)
//============================================================================



static void Test_Vp_BFu33_BFu15i()
{
  {
    init_simple_test("Vp_BFu33_BFu15i");
    static STRUCT_IF_C Vp_BFu33_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Vp_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Vp_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu15i, Vp_BFu33_BFu15i)
//============================================================================



static void Test_Vp_BFu33_BFu15ll()
{
  {
    init_simple_test("Vp_BFu33_BFu15ll");
    static STRUCT_IF_C Vp_BFu33_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Vp_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Vp_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu15ll, Vp_BFu33_BFu15ll)
//============================================================================



static void Test_Vp_BFu33_BFu15s()
{
  {
    init_simple_test("Vp_BFu33_BFu15s");
    static STRUCT_IF_C Vp_BFu33_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "Vp_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "Vp_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu15s, Vp_BFu33_BFu15s)
//============================================================================



static void Test_Vp_BFu33_BFu16i()
{
  {
    init_simple_test("Vp_BFu33_BFu16i");
    static STRUCT_IF_C Vp_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Vp_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Vp_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu16i, Vp_BFu33_BFu16i)
//============================================================================



static void Test_Vp_BFu33_BFu16ll()
{
  {
    init_simple_test("Vp_BFu33_BFu16ll");
    static STRUCT_IF_C Vp_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Vp_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Vp_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu16ll, Vp_BFu33_BFu16ll)
//============================================================================



static void Test_Vp_BFu33_BFu16s()
{
  {
    init_simple_test("Vp_BFu33_BFu16s");
    static STRUCT_IF_C Vp_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "Vp_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "Vp_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu16s, Vp_BFu33_BFu16s)
//============================================================================



static void Test_Vp_BFu33_BFu17i()
{
  {
    init_simple_test("Vp_BFu33_BFu17i");
    static STRUCT_IF_C Vp_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "Vp_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "Vp_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu17i, Vp_BFu33_BFu17i)
//============================================================================



static void Test_Vp_BFu33_BFu17ll()
{
  {
    init_simple_test("Vp_BFu33_BFu17ll");
    static STRUCT_IF_C Vp_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "Vp_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "Vp_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu17ll, Vp_BFu33_BFu17ll)
//============================================================================



static void Test_Vp_BFu33_BFu1c()
{
  {
    init_simple_test("Vp_BFu33_BFu1c");
    static STRUCT_IF_C Vp_BFu33_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Vp_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu1c, Vp_BFu33_BFu1c)
//============================================================================



static void Test_Vp_BFu33_BFu1i()
{
  {
    init_simple_test("Vp_BFu33_BFu1i");
    static STRUCT_IF_C Vp_BFu33_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Vp_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu1i, Vp_BFu33_BFu1i)
//============================================================================



static void Test_Vp_BFu33_BFu1ll()
{
  {
    init_simple_test("Vp_BFu33_BFu1ll");
    static STRUCT_IF_C Vp_BFu33_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Vp_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu1ll, Vp_BFu33_BFu1ll)
//============================================================================



static void Test_Vp_BFu33_BFu1s()
{
  {
    init_simple_test("Vp_BFu33_BFu1s");
    static STRUCT_IF_C Vp_BFu33_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "Vp_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu1s, Vp_BFu33_BFu1s)
//============================================================================



static void Test_Vp_BFu33_BFu31i()
{
  {
    init_simple_test("Vp_BFu33_BFu31i");
    static STRUCT_IF_C Vp_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "Vp_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "Vp_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu31i, Vp_BFu33_BFu31i)
//============================================================================



static void Test_Vp_BFu33_BFu31ll()
{
  {
    init_simple_test("Vp_BFu33_BFu31ll");
    static STRUCT_IF_C Vp_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Vp_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "Vp_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "Vp_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu31ll, Vp_BFu33_BFu31ll)
//============================================================================



static void Test_Vp_BFu33_BFu32i()
{
  {
    init_simple_test("Vp_BFu33_BFu32i");
    static STRUCT_IF_C Vp_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, 1, "Vp_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, hide_ull(1LL<<31), "Vp_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu32i, Vp_BFu33_BFu32i)
//============================================================================



static void Test_Vp_BFu33_BFu32ll()
{
  {
    init_simple_test("Vp_BFu33_BFu32ll");
    static STRUCT_IF_C Vp_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, 1, "Vp_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, hide_ull(1LL<<31), "Vp_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu32ll, Vp_BFu33_BFu32ll)
//============================================================================



static void Test_Vp_BFu33_BFu33()
{
  {
    init_simple_test("Vp_BFu33_BFu33");
    static STRUCT_IF_C Vp_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 33, 1, "Vp_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu33, Vp_BFu33_BFu33)
//============================================================================



static void Test_Vp_BFu33_BFu7c()
{
  {
    init_simple_test("Vp_BFu33_BFu7c");
    static STRUCT_IF_C Vp_BFu33_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Vp_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Vp_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu7c, Vp_BFu33_BFu7c)
//============================================================================



static void Test_Vp_BFu33_BFu7i()
{
  {
    init_simple_test("Vp_BFu33_BFu7i");
    static STRUCT_IF_C Vp_BFu33_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Vp_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Vp_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu7i, Vp_BFu33_BFu7i)
//============================================================================



static void Test_Vp_BFu33_BFu7ll()
{
  {
    init_simple_test("Vp_BFu33_BFu7ll");
    static STRUCT_IF_C Vp_BFu33_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Vp_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Vp_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu7ll, Vp_BFu33_BFu7ll)
//============================================================================



static void Test_Vp_BFu33_BFu7s()
{
  {
    init_simple_test("Vp_BFu33_BFu7s");
    static STRUCT_IF_C Vp_BFu33_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "Vp_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "Vp_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu7s, Vp_BFu33_BFu7s)
//============================================================================



static void Test_Vp_BFu33_BFu8c()
{
  {
    init_simple_test("Vp_BFu33_BFu8c");
    static STRUCT_IF_C Vp_BFu33_BFu8c lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Vp_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Vp_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu8c, Vp_BFu33_BFu8c)
//============================================================================



static void Test_Vp_BFu33_BFu8i()
{
  {
    init_simple_test("Vp_BFu33_BFu8i");
    static STRUCT_IF_C Vp_BFu33_BFu8i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Vp_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Vp_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu8i, Vp_BFu33_BFu8i)
//============================================================================



static void Test_Vp_BFu33_BFu8ll()
{
  {
    init_simple_test("Vp_BFu33_BFu8ll");
    static STRUCT_IF_C Vp_BFu33_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Vp_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Vp_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu8ll, Vp_BFu33_BFu8ll)
//============================================================================



static void Test_Vp_BFu33_BFu8s()
{
  {
    init_simple_test("Vp_BFu33_BFu8s");
    static STRUCT_IF_C Vp_BFu33_BFu8s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "Vp_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "Vp_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu8s, Vp_BFu33_BFu8s)
//============================================================================



static void Test_Vp_BFu33_BFu9i()
{
  {
    init_simple_test("Vp_BFu33_BFu9i");
    static STRUCT_IF_C Vp_BFu33_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Vp_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Vp_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu9i, Vp_BFu33_BFu9i)
//============================================================================



static void Test_Vp_BFu33_BFu9ll()
{
  {
    init_simple_test("Vp_BFu33_BFu9ll");
    static STRUCT_IF_C Vp_BFu33_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Vp_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Vp_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu9ll, Vp_BFu33_BFu9ll)
//============================================================================



static void Test_Vp_BFu33_BFu9s()
{
  {
    init_simple_test("Vp_BFu33_BFu9s");
    static STRUCT_IF_C Vp_BFu33_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "Vp_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "Vp_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_BFu9s, Vp_BFu33_BFu9s)
//============================================================================



static void Test_Vp_BFu33_C()
{
  {
    init_simple_test("Vp_BFu33_C");
    static STRUCT_IF_C Vp_BFu33_C lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_C");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_C, Vp_BFu33_C)
//============================================================================



static void Test_Vp_BFu33_D()
{
  {
    init_simple_test("Vp_BFu33_D");
    static STRUCT_IF_C Vp_BFu33_D lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(Vp_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_D");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_D, Vp_BFu33_D)
//============================================================================



static void Test_Vp_BFu33_F()
{
  {
    init_simple_test("Vp_BFu33_F");
    static STRUCT_IF_C Vp_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_F");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_F, Vp_BFu33_F)
//============================================================================



static void Test_Vp_BFu33_I()
{
  {
    init_simple_test("Vp_BFu33_I");
    static STRUCT_IF_C Vp_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_I");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_I, Vp_BFu33_I)
//============================================================================



static void Test_Vp_BFu33_Ip()
{
  {
    init_simple_test("Vp_BFu33_Ip");
    static STRUCT_IF_C Vp_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(Vp_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_Ip");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_Ip, Vp_BFu33_Ip)
//============================================================================



static void Test_Vp_BFu33_L()
{
  {
    init_simple_test("Vp_BFu33_L");
    static STRUCT_IF_C Vp_BFu33_L lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(Vp_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_L");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_L, Vp_BFu33_L)
//============================================================================



static void Test_Vp_BFu33_S()
{
  {
    init_simple_test("Vp_BFu33_S");
    static STRUCT_IF_C Vp_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_S");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_S, Vp_BFu33_S)
//============================================================================



static void Test_Vp_BFu33_Uc()
{
  {
    init_simple_test("Vp_BFu33_Uc");
    static STRUCT_IF_C Vp_BFu33_Uc lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_Uc");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_Uc, Vp_BFu33_Uc)
//============================================================================



static void Test_Vp_BFu33_Ui()
{
  {
    init_simple_test("Vp_BFu33_Ui");
    static STRUCT_IF_C Vp_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_Ui");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_Ui, Vp_BFu33_Ui)
//============================================================================



static void Test_Vp_BFu33_Ul()
{
  {
    init_simple_test("Vp_BFu33_Ul");
    static STRUCT_IF_C Vp_BFu33_Ul lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(Vp_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_Ul");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_Ul, Vp_BFu33_Ul)
//============================================================================



static void Test_Vp_BFu33_Us()
{
  {
    init_simple_test("Vp_BFu33_Us");
    static STRUCT_IF_C Vp_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Vp_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_Us");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_Us, Vp_BFu33_Us)
//============================================================================



static void Test_Vp_BFu33_Vp()
{
  {
    init_simple_test("Vp_BFu33_Vp");
    static STRUCT_IF_C Vp_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(Vp_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Vp_BFu33_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Vp_BFu33_Vp");
    check_field_offset(lv, v3, ABISELECT(13,9), "Vp_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu33_Vp, Vp_BFu33_Vp)
//============================================================================



static void Test_Vp_BFu7c()
{
  {
    init_simple_test("Vp_BFu7c");
    static STRUCT_IF_C Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c, Vp_BFu7c)
//============================================================================



static void Test_Vp_BFu7c_BFu15i()
{
  {
    init_simple_test("Vp_BFu7c_BFu15i");
    static STRUCT_IF_C Vp_BFu7c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu15i, Vp_BFu7c_BFu15i)
//============================================================================



static void Test_Vp_BFu7c_BFu15ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu15ll");
    static STRUCT_IF_C Vp_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu15ll, Vp_BFu7c_BFu15ll)
//============================================================================



static void Test_Vp_BFu7c_BFu15s()
{
  {
    init_simple_test("Vp_BFu7c_BFu15s");
    static STRUCT_IF_C Vp_BFu7c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu15s, Vp_BFu7c_BFu15s)
//============================================================================



static void Test_Vp_BFu7c_BFu16i()
{
  {
    init_simple_test("Vp_BFu7c_BFu16i");
    static STRUCT_IF_C Vp_BFu7c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu16i, Vp_BFu7c_BFu16i)
//============================================================================



static void Test_Vp_BFu7c_BFu16ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu16ll");
    static STRUCT_IF_C Vp_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu16ll, Vp_BFu7c_BFu16ll)
//============================================================================



static void Test_Vp_BFu7c_BFu16s()
{
  {
    init_simple_test("Vp_BFu7c_BFu16s");
    static STRUCT_IF_C Vp_BFu7c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu16s, Vp_BFu7c_BFu16s)
//============================================================================



static void Test_Vp_BFu7c_BFu17i()
{
  {
    init_simple_test("Vp_BFu7c_BFu17i");
    static STRUCT_IF_C Vp_BFu7c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu17i, Vp_BFu7c_BFu17i)
//============================================================================



static void Test_Vp_BFu7c_BFu17ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu17ll");
    static STRUCT_IF_C Vp_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu17ll, Vp_BFu7c_BFu17ll)
//============================================================================



static void Test_Vp_BFu7c_BFu1c()
{
  {
    init_simple_test("Vp_BFu7c_BFu1c");
    static STRUCT_IF_C Vp_BFu7c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu1c, Vp_BFu7c_BFu1c)
//============================================================================



static void Test_Vp_BFu7c_BFu1i()
{
  {
    init_simple_test("Vp_BFu7c_BFu1i");
    static STRUCT_IF_C Vp_BFu7c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu1i, Vp_BFu7c_BFu1i)
//============================================================================



static void Test_Vp_BFu7c_BFu1ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu1ll");
    static STRUCT_IF_C Vp_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu1ll, Vp_BFu7c_BFu1ll)
//============================================================================



static void Test_Vp_BFu7c_BFu1s()
{
  {
    init_simple_test("Vp_BFu7c_BFu1s");
    static STRUCT_IF_C Vp_BFu7c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu1s, Vp_BFu7c_BFu1s)
//============================================================================



static void Test_Vp_BFu7c_BFu31i()
{
  {
    init_simple_test("Vp_BFu7c_BFu31i");
    static STRUCT_IF_C Vp_BFu7c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu31i, Vp_BFu7c_BFu31i)
//============================================================================



static void Test_Vp_BFu7c_BFu31ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu31ll");
    static STRUCT_IF_C Vp_BFu7c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu31ll, Vp_BFu7c_BFu31ll)
//============================================================================



static void Test_Vp_BFu7c_BFu32i()
{
  {
    init_simple_test("Vp_BFu7c_BFu32i");
    static STRUCT_IF_C Vp_BFu7c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu32i, Vp_BFu7c_BFu32i)
//============================================================================



static void Test_Vp_BFu7c_BFu32ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu32ll");
    static STRUCT_IF_C Vp_BFu7c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu32ll, Vp_BFu7c_BFu32ll)
//============================================================================



static void Test_Vp_BFu7c_BFu33()
{
  {
    init_simple_test("Vp_BFu7c_BFu33");
    static STRUCT_IF_C Vp_BFu7c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "Vp_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "Vp_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu33, Vp_BFu7c_BFu33)
//============================================================================



static void Test_Vp_BFu7c_BFu7c()
{
  {
    init_simple_test("Vp_BFu7c_BFu7c");
    static STRUCT_IF_C Vp_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu7c, Vp_BFu7c_BFu7c)
//============================================================================



static void Test_Vp_BFu7c_BFu7i()
{
  {
    init_simple_test("Vp_BFu7c_BFu7i");
    static STRUCT_IF_C Vp_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu7i, Vp_BFu7c_BFu7i)
//============================================================================



static void Test_Vp_BFu7c_BFu7ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu7ll");
    static STRUCT_IF_C Vp_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu7ll, Vp_BFu7c_BFu7ll)
//============================================================================



static void Test_Vp_BFu7c_BFu7s()
{
  {
    init_simple_test("Vp_BFu7c_BFu7s");
    static STRUCT_IF_C Vp_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu7s, Vp_BFu7c_BFu7s)
//============================================================================



static void Test_Vp_BFu7c_BFu8c()
{
  {
    init_simple_test("Vp_BFu7c_BFu8c");
    static STRUCT_IF_C Vp_BFu7c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu8c, Vp_BFu7c_BFu8c)
//============================================================================



static void Test_Vp_BFu7c_BFu8i()
{
  {
    init_simple_test("Vp_BFu7c_BFu8i");
    static STRUCT_IF_C Vp_BFu7c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu8i, Vp_BFu7c_BFu8i)
//============================================================================



static void Test_Vp_BFu7c_BFu8ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu8ll");
    static STRUCT_IF_C Vp_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu8ll, Vp_BFu7c_BFu8ll)
//============================================================================



static void Test_Vp_BFu7c_BFu8s()
{
  {
    init_simple_test("Vp_BFu7c_BFu8s");
    static STRUCT_IF_C Vp_BFu7c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu8s, Vp_BFu7c_BFu8s)
//============================================================================



static void Test_Vp_BFu7c_BFu9i()
{
  {
    init_simple_test("Vp_BFu7c_BFu9i");
    static STRUCT_IF_C Vp_BFu7c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu9i, Vp_BFu7c_BFu9i)
//============================================================================



static void Test_Vp_BFu7c_BFu9ll()
{
  {
    init_simple_test("Vp_BFu7c_BFu9ll");
    static STRUCT_IF_C Vp_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu9ll, Vp_BFu7c_BFu9ll)
//============================================================================



static void Test_Vp_BFu7c_BFu9s()
{
  {
    init_simple_test("Vp_BFu7c_BFu9s");
    static STRUCT_IF_C Vp_BFu7c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_BFu9s, Vp_BFu7c_BFu9s)
//============================================================================



static void Test_Vp_BFu7c_C()
{
  {
    init_simple_test("Vp_BFu7c_C");
    static STRUCT_IF_C Vp_BFu7c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_C, Vp_BFu7c_C)
//============================================================================



static void Test_Vp_BFu7c_D()
{
  {
    init_simple_test("Vp_BFu7c_D");
    static STRUCT_IF_C Vp_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_D, Vp_BFu7c_D)
//============================================================================



static void Test_Vp_BFu7c_F()
{
  {
    init_simple_test("Vp_BFu7c_F");
    static STRUCT_IF_C Vp_BFu7c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_F, Vp_BFu7c_F)
//============================================================================



static void Test_Vp_BFu7c_I()
{
  {
    init_simple_test("Vp_BFu7c_I");
    static STRUCT_IF_C Vp_BFu7c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_I, Vp_BFu7c_I)
//============================================================================



static void Test_Vp_BFu7c_Ip()
{
  {
    init_simple_test("Vp_BFu7c_Ip");
    static STRUCT_IF_C Vp_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_Ip, Vp_BFu7c_Ip)
//============================================================================



static void Test_Vp_BFu7c_L()
{
  {
    init_simple_test("Vp_BFu7c_L");
    static STRUCT_IF_C Vp_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_L, Vp_BFu7c_L)
//============================================================================



static void Test_Vp_BFu7c_S()
{
  {
    init_simple_test("Vp_BFu7c_S");
    static STRUCT_IF_C Vp_BFu7c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_S, Vp_BFu7c_S)
//============================================================================



static void Test_Vp_BFu7c_Uc()
{
  {
    init_simple_test("Vp_BFu7c_Uc");
    static STRUCT_IF_C Vp_BFu7c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_Uc, Vp_BFu7c_Uc)
//============================================================================



static void Test_Vp_BFu7c_Ui()
{
  {
    init_simple_test("Vp_BFu7c_Ui");
    static STRUCT_IF_C Vp_BFu7c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_Ui, Vp_BFu7c_Ui)
//============================================================================



static void Test_Vp_BFu7c_Ul()
{
  {
    init_simple_test("Vp_BFu7c_Ul");
    static STRUCT_IF_C Vp_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_Ul, Vp_BFu7c_Ul)
//============================================================================



static void Test_Vp_BFu7c_Us()
{
  {
    init_simple_test("Vp_BFu7c_Us");
    static STRUCT_IF_C Vp_BFu7c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_Us, Vp_BFu7c_Us)
//============================================================================



static void Test_Vp_BFu7c_Vp()
{
  {
    init_simple_test("Vp_BFu7c_Vp");
    static STRUCT_IF_C Vp_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7c_Vp, Vp_BFu7c_Vp)
//============================================================================



static void Test_Vp_BFu7i()
{
  {
    init_simple_test("Vp_BFu7i");
    static STRUCT_IF_C Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i, Vp_BFu7i)
//============================================================================



static void Test_Vp_BFu7i_BFu15i()
{
  {
    init_simple_test("Vp_BFu7i_BFu15i");
    static STRUCT_IF_C Vp_BFu7i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu15i, Vp_BFu7i_BFu15i)
//============================================================================



static void Test_Vp_BFu7i_BFu15ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu15ll");
    static STRUCT_IF_C Vp_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu15ll, Vp_BFu7i_BFu15ll)
//============================================================================



static void Test_Vp_BFu7i_BFu15s()
{
  {
    init_simple_test("Vp_BFu7i_BFu15s");
    static STRUCT_IF_C Vp_BFu7i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu15s, Vp_BFu7i_BFu15s)
//============================================================================



static void Test_Vp_BFu7i_BFu16i()
{
  {
    init_simple_test("Vp_BFu7i_BFu16i");
    static STRUCT_IF_C Vp_BFu7i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu16i, Vp_BFu7i_BFu16i)
//============================================================================



static void Test_Vp_BFu7i_BFu16ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu16ll");
    static STRUCT_IF_C Vp_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu16ll, Vp_BFu7i_BFu16ll)
//============================================================================



static void Test_Vp_BFu7i_BFu16s()
{
  {
    init_simple_test("Vp_BFu7i_BFu16s");
    static STRUCT_IF_C Vp_BFu7i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu16s, Vp_BFu7i_BFu16s)
//============================================================================



static void Test_Vp_BFu7i_BFu17i()
{
  {
    init_simple_test("Vp_BFu7i_BFu17i");
    static STRUCT_IF_C Vp_BFu7i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu17i, Vp_BFu7i_BFu17i)
//============================================================================



static void Test_Vp_BFu7i_BFu17ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu17ll");
    static STRUCT_IF_C Vp_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu17ll, Vp_BFu7i_BFu17ll)
//============================================================================



static void Test_Vp_BFu7i_BFu1c()
{
  {
    init_simple_test("Vp_BFu7i_BFu1c");
    static STRUCT_IF_C Vp_BFu7i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu1c, Vp_BFu7i_BFu1c)
//============================================================================



static void Test_Vp_BFu7i_BFu1i()
{
  {
    init_simple_test("Vp_BFu7i_BFu1i");
    static STRUCT_IF_C Vp_BFu7i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu1i, Vp_BFu7i_BFu1i)
//============================================================================



static void Test_Vp_BFu7i_BFu1ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu1ll");
    static STRUCT_IF_C Vp_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu1ll, Vp_BFu7i_BFu1ll)
//============================================================================



static void Test_Vp_BFu7i_BFu1s()
{
  {
    init_simple_test("Vp_BFu7i_BFu1s");
    static STRUCT_IF_C Vp_BFu7i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu1s, Vp_BFu7i_BFu1s)
//============================================================================



static void Test_Vp_BFu7i_BFu31i()
{
  {
    init_simple_test("Vp_BFu7i_BFu31i");
    static STRUCT_IF_C Vp_BFu7i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu31i, Vp_BFu7i_BFu31i)
//============================================================================



static void Test_Vp_BFu7i_BFu31ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu31ll");
    static STRUCT_IF_C Vp_BFu7i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu31ll, Vp_BFu7i_BFu31ll)
//============================================================================



static void Test_Vp_BFu7i_BFu32i()
{
  {
    init_simple_test("Vp_BFu7i_BFu32i");
    static STRUCT_IF_C Vp_BFu7i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu32i, Vp_BFu7i_BFu32i)
//============================================================================



static void Test_Vp_BFu7i_BFu32ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu32ll");
    static STRUCT_IF_C Vp_BFu7i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu32ll, Vp_BFu7i_BFu32ll)
//============================================================================



static void Test_Vp_BFu7i_BFu33()
{
  {
    init_simple_test("Vp_BFu7i_BFu33");
    static STRUCT_IF_C Vp_BFu7i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "Vp_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "Vp_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu33, Vp_BFu7i_BFu33)
//============================================================================



static void Test_Vp_BFu7i_BFu7c()
{
  {
    init_simple_test("Vp_BFu7i_BFu7c");
    static STRUCT_IF_C Vp_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu7c, Vp_BFu7i_BFu7c)
//============================================================================



static void Test_Vp_BFu7i_BFu7i()
{
  {
    init_simple_test("Vp_BFu7i_BFu7i");
    static STRUCT_IF_C Vp_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu7i, Vp_BFu7i_BFu7i)
//============================================================================



static void Test_Vp_BFu7i_BFu7ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu7ll");
    static STRUCT_IF_C Vp_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu7ll, Vp_BFu7i_BFu7ll)
//============================================================================



static void Test_Vp_BFu7i_BFu7s()
{
  {
    init_simple_test("Vp_BFu7i_BFu7s");
    static STRUCT_IF_C Vp_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu7s, Vp_BFu7i_BFu7s)
//============================================================================



static void Test_Vp_BFu7i_BFu8c()
{
  {
    init_simple_test("Vp_BFu7i_BFu8c");
    static STRUCT_IF_C Vp_BFu7i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu8c, Vp_BFu7i_BFu8c)
//============================================================================



static void Test_Vp_BFu7i_BFu8i()
{
  {
    init_simple_test("Vp_BFu7i_BFu8i");
    static STRUCT_IF_C Vp_BFu7i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu8i, Vp_BFu7i_BFu8i)
//============================================================================



static void Test_Vp_BFu7i_BFu8ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu8ll");
    static STRUCT_IF_C Vp_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu8ll, Vp_BFu7i_BFu8ll)
//============================================================================



static void Test_Vp_BFu7i_BFu8s()
{
  {
    init_simple_test("Vp_BFu7i_BFu8s");
    static STRUCT_IF_C Vp_BFu7i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu8s, Vp_BFu7i_BFu8s)
//============================================================================



static void Test_Vp_BFu7i_BFu9i()
{
  {
    init_simple_test("Vp_BFu7i_BFu9i");
    static STRUCT_IF_C Vp_BFu7i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu9i, Vp_BFu7i_BFu9i)
//============================================================================



static void Test_Vp_BFu7i_BFu9ll()
{
  {
    init_simple_test("Vp_BFu7i_BFu9ll");
    static STRUCT_IF_C Vp_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu9ll, Vp_BFu7i_BFu9ll)
//============================================================================



static void Test_Vp_BFu7i_BFu9s()
{
  {
    init_simple_test("Vp_BFu7i_BFu9s");
    static STRUCT_IF_C Vp_BFu7i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_BFu9s, Vp_BFu7i_BFu9s)
//============================================================================



static void Test_Vp_BFu7i_C()
{
  {
    init_simple_test("Vp_BFu7i_C");
    static STRUCT_IF_C Vp_BFu7i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_C, Vp_BFu7i_C)
//============================================================================



static void Test_Vp_BFu7i_D()
{
  {
    init_simple_test("Vp_BFu7i_D");
    static STRUCT_IF_C Vp_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_D, Vp_BFu7i_D)
//============================================================================



static void Test_Vp_BFu7i_F()
{
  {
    init_simple_test("Vp_BFu7i_F");
    static STRUCT_IF_C Vp_BFu7i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_F, Vp_BFu7i_F)
//============================================================================



static void Test_Vp_BFu7i_I()
{
  {
    init_simple_test("Vp_BFu7i_I");
    static STRUCT_IF_C Vp_BFu7i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_I, Vp_BFu7i_I)
//============================================================================



static void Test_Vp_BFu7i_Ip()
{
  {
    init_simple_test("Vp_BFu7i_Ip");
    static STRUCT_IF_C Vp_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_Ip, Vp_BFu7i_Ip)
//============================================================================



static void Test_Vp_BFu7i_L()
{
  {
    init_simple_test("Vp_BFu7i_L");
    static STRUCT_IF_C Vp_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_L, Vp_BFu7i_L)
//============================================================================



static void Test_Vp_BFu7i_S()
{
  {
    init_simple_test("Vp_BFu7i_S");
    static STRUCT_IF_C Vp_BFu7i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_S, Vp_BFu7i_S)
//============================================================================



static void Test_Vp_BFu7i_Uc()
{
  {
    init_simple_test("Vp_BFu7i_Uc");
    static STRUCT_IF_C Vp_BFu7i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_Uc, Vp_BFu7i_Uc)
//============================================================================



static void Test_Vp_BFu7i_Ui()
{
  {
    init_simple_test("Vp_BFu7i_Ui");
    static STRUCT_IF_C Vp_BFu7i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_Ui, Vp_BFu7i_Ui)
//============================================================================



static void Test_Vp_BFu7i_Ul()
{
  {
    init_simple_test("Vp_BFu7i_Ul");
    static STRUCT_IF_C Vp_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_Ul, Vp_BFu7i_Ul)
//============================================================================



static void Test_Vp_BFu7i_Us()
{
  {
    init_simple_test("Vp_BFu7i_Us");
    static STRUCT_IF_C Vp_BFu7i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_Us, Vp_BFu7i_Us)
//============================================================================



static void Test_Vp_BFu7i_Vp()
{
  {
    init_simple_test("Vp_BFu7i_Vp");
    static STRUCT_IF_C Vp_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7i_Vp, Vp_BFu7i_Vp)
//============================================================================



static void Test_Vp_BFu7ll()
{
  {
    init_simple_test("Vp_BFu7ll");
    static STRUCT_IF_C Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll, Vp_BFu7ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu15i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu15i");
    static STRUCT_IF_C Vp_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu15i, Vp_BFu7ll_BFu15i)
//============================================================================



static void Test_Vp_BFu7ll_BFu15ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu15ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu15ll, Vp_BFu7ll_BFu15ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu15s()
{
  {
    init_simple_test("Vp_BFu7ll_BFu15s");
    static STRUCT_IF_C Vp_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu15s, Vp_BFu7ll_BFu15s)
//============================================================================



static void Test_Vp_BFu7ll_BFu16i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu16i");
    static STRUCT_IF_C Vp_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu16i, Vp_BFu7ll_BFu16i)
//============================================================================



static void Test_Vp_BFu7ll_BFu16ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu16ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu16ll, Vp_BFu7ll_BFu16ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu16s()
{
  {
    init_simple_test("Vp_BFu7ll_BFu16s");
    static STRUCT_IF_C Vp_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu16s, Vp_BFu7ll_BFu16s)
//============================================================================



static void Test_Vp_BFu7ll_BFu17i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu17i");
    static STRUCT_IF_C Vp_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu17i, Vp_BFu7ll_BFu17i)
//============================================================================



static void Test_Vp_BFu7ll_BFu17ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu17ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu17ll, Vp_BFu7ll_BFu17ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu1c()
{
  {
    init_simple_test("Vp_BFu7ll_BFu1c");
    static STRUCT_IF_C Vp_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu1c, Vp_BFu7ll_BFu1c)
//============================================================================



static void Test_Vp_BFu7ll_BFu1i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu1i");
    static STRUCT_IF_C Vp_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu1i, Vp_BFu7ll_BFu1i)
//============================================================================



static void Test_Vp_BFu7ll_BFu1ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu1ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu1ll, Vp_BFu7ll_BFu1ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu1s()
{
  {
    init_simple_test("Vp_BFu7ll_BFu1s");
    static STRUCT_IF_C Vp_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu1s, Vp_BFu7ll_BFu1s)
//============================================================================



static void Test_Vp_BFu7ll_BFu31i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu31i");
    static STRUCT_IF_C Vp_BFu7ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu31i, Vp_BFu7ll_BFu31i)
//============================================================================



static void Test_Vp_BFu7ll_BFu31ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu31ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu31ll, Vp_BFu7ll_BFu31ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu32i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu32i");
    static STRUCT_IF_C Vp_BFu7ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu32i, Vp_BFu7ll_BFu32i)
//============================================================================



static void Test_Vp_BFu7ll_BFu32ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu32ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu32ll, Vp_BFu7ll_BFu32ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu33()
{
  {
    init_simple_test("Vp_BFu7ll_BFu33");
    static STRUCT_IF_C Vp_BFu7ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "Vp_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "Vp_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu33, Vp_BFu7ll_BFu33)
//============================================================================



static void Test_Vp_BFu7ll_BFu7c()
{
  {
    init_simple_test("Vp_BFu7ll_BFu7c");
    static STRUCT_IF_C Vp_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu7c, Vp_BFu7ll_BFu7c)
//============================================================================



static void Test_Vp_BFu7ll_BFu7i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu7i");
    static STRUCT_IF_C Vp_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu7i, Vp_BFu7ll_BFu7i)
//============================================================================



static void Test_Vp_BFu7ll_BFu7ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu7ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu7ll, Vp_BFu7ll_BFu7ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu7s()
{
  {
    init_simple_test("Vp_BFu7ll_BFu7s");
    static STRUCT_IF_C Vp_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu7s, Vp_BFu7ll_BFu7s)
//============================================================================



static void Test_Vp_BFu7ll_BFu8c()
{
  {
    init_simple_test("Vp_BFu7ll_BFu8c");
    static STRUCT_IF_C Vp_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu8c, Vp_BFu7ll_BFu8c)
//============================================================================



static void Test_Vp_BFu7ll_BFu8i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu8i");
    static STRUCT_IF_C Vp_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu8i, Vp_BFu7ll_BFu8i)
//============================================================================



static void Test_Vp_BFu7ll_BFu8ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu8ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu8ll, Vp_BFu7ll_BFu8ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu8s()
{
  {
    init_simple_test("Vp_BFu7ll_BFu8s");
    static STRUCT_IF_C Vp_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu8s, Vp_BFu7ll_BFu8s)
//============================================================================



static void Test_Vp_BFu7ll_BFu9i()
{
  {
    init_simple_test("Vp_BFu7ll_BFu9i");
    static STRUCT_IF_C Vp_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu9i, Vp_BFu7ll_BFu9i)
//============================================================================



static void Test_Vp_BFu7ll_BFu9ll()
{
  {
    init_simple_test("Vp_BFu7ll_BFu9ll");
    static STRUCT_IF_C Vp_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu9ll, Vp_BFu7ll_BFu9ll)
//============================================================================



static void Test_Vp_BFu7ll_BFu9s()
{
  {
    init_simple_test("Vp_BFu7ll_BFu9s");
    static STRUCT_IF_C Vp_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_BFu9s, Vp_BFu7ll_BFu9s)
//============================================================================



static void Test_Vp_BFu7ll_C()
{
  {
    init_simple_test("Vp_BFu7ll_C");
    static STRUCT_IF_C Vp_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_C, Vp_BFu7ll_C)
//============================================================================



static void Test_Vp_BFu7ll_D()
{
  {
    init_simple_test("Vp_BFu7ll_D");
    static STRUCT_IF_C Vp_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_D, Vp_BFu7ll_D)
//============================================================================



static void Test_Vp_BFu7ll_F()
{
  {
    init_simple_test("Vp_BFu7ll_F");
    static STRUCT_IF_C Vp_BFu7ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_F, Vp_BFu7ll_F)
//============================================================================



static void Test_Vp_BFu7ll_I()
{
  {
    init_simple_test("Vp_BFu7ll_I");
    static STRUCT_IF_C Vp_BFu7ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_I, Vp_BFu7ll_I)
//============================================================================



static void Test_Vp_BFu7ll_Ip()
{
  {
    init_simple_test("Vp_BFu7ll_Ip");
    static STRUCT_IF_C Vp_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_Ip, Vp_BFu7ll_Ip)
//============================================================================



static void Test_Vp_BFu7ll_L()
{
  {
    init_simple_test("Vp_BFu7ll_L");
    static STRUCT_IF_C Vp_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_L, Vp_BFu7ll_L)
//============================================================================



static void Test_Vp_BFu7ll_S()
{
  {
    init_simple_test("Vp_BFu7ll_S");
    static STRUCT_IF_C Vp_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_S, Vp_BFu7ll_S)
//============================================================================



static void Test_Vp_BFu7ll_Uc()
{
  {
    init_simple_test("Vp_BFu7ll_Uc");
    static STRUCT_IF_C Vp_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_Uc, Vp_BFu7ll_Uc)
//============================================================================



static void Test_Vp_BFu7ll_Ui()
{
  {
    init_simple_test("Vp_BFu7ll_Ui");
    static STRUCT_IF_C Vp_BFu7ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_Ui, Vp_BFu7ll_Ui)
//============================================================================



static void Test_Vp_BFu7ll_Ul()
{
  {
    init_simple_test("Vp_BFu7ll_Ul");
    static STRUCT_IF_C Vp_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_Ul, Vp_BFu7ll_Ul)
//============================================================================



static void Test_Vp_BFu7ll_Us()
{
  {
    init_simple_test("Vp_BFu7ll_Us");
    static STRUCT_IF_C Vp_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_Us, Vp_BFu7ll_Us)
//============================================================================



static void Test_Vp_BFu7ll_Vp()
{
  {
    init_simple_test("Vp_BFu7ll_Vp");
    static STRUCT_IF_C Vp_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7ll_Vp, Vp_BFu7ll_Vp)
//============================================================================



static void Test_Vp_BFu7s()
{
  {
    init_simple_test("Vp_BFu7s");
    static STRUCT_IF_C Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s, Vp_BFu7s)
//============================================================================



static void Test_Vp_BFu7s_BFu15i()
{
  {
    init_simple_test("Vp_BFu7s_BFu15i");
    static STRUCT_IF_C Vp_BFu7s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu15i, Vp_BFu7s_BFu15i)
//============================================================================



static void Test_Vp_BFu7s_BFu15ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu15ll");
    static STRUCT_IF_C Vp_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu15ll, Vp_BFu7s_BFu15ll)
//============================================================================



static void Test_Vp_BFu7s_BFu15s()
{
  {
    init_simple_test("Vp_BFu7s_BFu15s");
    static STRUCT_IF_C Vp_BFu7s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "Vp_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "Vp_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu15s, Vp_BFu7s_BFu15s)
//============================================================================



static void Test_Vp_BFu7s_BFu16i()
{
  {
    init_simple_test("Vp_BFu7s_BFu16i");
    static STRUCT_IF_C Vp_BFu7s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu16i, Vp_BFu7s_BFu16i)
//============================================================================



static void Test_Vp_BFu7s_BFu16ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu16ll");
    static STRUCT_IF_C Vp_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu16ll, Vp_BFu7s_BFu16ll)
//============================================================================



static void Test_Vp_BFu7s_BFu16s()
{
  {
    init_simple_test("Vp_BFu7s_BFu16s");
    static STRUCT_IF_C Vp_BFu7s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "Vp_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "Vp_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu16s, Vp_BFu7s_BFu16s)
//============================================================================



static void Test_Vp_BFu7s_BFu17i()
{
  {
    init_simple_test("Vp_BFu7s_BFu17i");
    static STRUCT_IF_C Vp_BFu7s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu17i, Vp_BFu7s_BFu17i)
//============================================================================



static void Test_Vp_BFu7s_BFu17ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu17ll");
    static STRUCT_IF_C Vp_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "Vp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "Vp_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu17ll, Vp_BFu7s_BFu17ll)
//============================================================================



static void Test_Vp_BFu7s_BFu1c()
{
  {
    init_simple_test("Vp_BFu7s_BFu1c");
    static STRUCT_IF_C Vp_BFu7s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu1c, Vp_BFu7s_BFu1c)
//============================================================================



static void Test_Vp_BFu7s_BFu1i()
{
  {
    init_simple_test("Vp_BFu7s_BFu1i");
    static STRUCT_IF_C Vp_BFu7s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu1i, Vp_BFu7s_BFu1i)
//============================================================================



static void Test_Vp_BFu7s_BFu1ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu1ll");
    static STRUCT_IF_C Vp_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu1ll, Vp_BFu7s_BFu1ll)
//============================================================================



static void Test_Vp_BFu7s_BFu1s()
{
  {
    init_simple_test("Vp_BFu7s_BFu1s");
    static STRUCT_IF_C Vp_BFu7s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "Vp_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu1s, Vp_BFu7s_BFu1s)
//============================================================================



static void Test_Vp_BFu7s_BFu31i()
{
  {
    init_simple_test("Vp_BFu7s_BFu31i");
    static STRUCT_IF_C Vp_BFu7s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu31i, Vp_BFu7s_BFu31i)
//============================================================================



static void Test_Vp_BFu7s_BFu31ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu31ll");
    static STRUCT_IF_C Vp_BFu7s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "Vp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "Vp_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu31ll, Vp_BFu7s_BFu31ll)
//============================================================================



static void Test_Vp_BFu7s_BFu32i()
{
  {
    init_simple_test("Vp_BFu7s_BFu32i");
    static STRUCT_IF_C Vp_BFu7s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu32i, Vp_BFu7s_BFu32i)
//============================================================================



static void Test_Vp_BFu7s_BFu32ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu32ll");
    static STRUCT_IF_C Vp_BFu7s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "Vp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "Vp_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu32ll, Vp_BFu7s_BFu32ll)
//============================================================================



static void Test_Vp_BFu7s_BFu33()
{
  {
    init_simple_test("Vp_BFu7s_BFu33");
    static STRUCT_IF_C Vp_BFu7s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "Vp_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "Vp_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu33, Vp_BFu7s_BFu33)
//============================================================================



static void Test_Vp_BFu7s_BFu7c()
{
  {
    init_simple_test("Vp_BFu7s_BFu7c");
    static STRUCT_IF_C Vp_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu7c, Vp_BFu7s_BFu7c)
//============================================================================



static void Test_Vp_BFu7s_BFu7i()
{
  {
    init_simple_test("Vp_BFu7s_BFu7i");
    static STRUCT_IF_C Vp_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu7i, Vp_BFu7s_BFu7i)
//============================================================================



static void Test_Vp_BFu7s_BFu7ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu7ll");
    static STRUCT_IF_C Vp_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu7ll, Vp_BFu7s_BFu7ll)
//============================================================================



static void Test_Vp_BFu7s_BFu7s()
{
  {
    init_simple_test("Vp_BFu7s_BFu7s");
    static STRUCT_IF_C Vp_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "Vp_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu7s, Vp_BFu7s_BFu7s)
//============================================================================



static void Test_Vp_BFu7s_BFu8c()
{
  {
    init_simple_test("Vp_BFu7s_BFu8c");
    static STRUCT_IF_C Vp_BFu7s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu8c, Vp_BFu7s_BFu8c)
//============================================================================



static void Test_Vp_BFu7s_BFu8i()
{
  {
    init_simple_test("Vp_BFu7s_BFu8i");
    static STRUCT_IF_C Vp_BFu7s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu8i, Vp_BFu7s_BFu8i)
//============================================================================



static void Test_Vp_BFu7s_BFu8ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu8ll");
    static STRUCT_IF_C Vp_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu8ll, Vp_BFu7s_BFu8ll)
//============================================================================



static void Test_Vp_BFu7s_BFu8s()
{
  {
    init_simple_test("Vp_BFu7s_BFu8s");
    static STRUCT_IF_C Vp_BFu7s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "Vp_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "Vp_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu8s, Vp_BFu7s_BFu8s)
//============================================================================



static void Test_Vp_BFu7s_BFu9i()
{
  {
    init_simple_test("Vp_BFu7s_BFu9i");
    static STRUCT_IF_C Vp_BFu7s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu9i, Vp_BFu7s_BFu9i)
//============================================================================



static void Test_Vp_BFu7s_BFu9ll()
{
  {
    init_simple_test("Vp_BFu7s_BFu9ll");
    static STRUCT_IF_C Vp_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu9ll, Vp_BFu7s_BFu9ll)
//============================================================================



static void Test_Vp_BFu7s_BFu9s()
{
  {
    init_simple_test("Vp_BFu7s_BFu9s");
    static STRUCT_IF_C Vp_BFu7s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "Vp_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "Vp_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_BFu9s, Vp_BFu7s_BFu9s)
//============================================================================



static void Test_Vp_BFu7s_C()
{
  {
    init_simple_test("Vp_BFu7s_C");
    static STRUCT_IF_C Vp_BFu7s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_C)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_C, Vp_BFu7s_C)
//============================================================================



static void Test_Vp_BFu7s_D()
{
  {
    init_simple_test("Vp_BFu7s_D");
    static STRUCT_IF_C Vp_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_D)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_D, Vp_BFu7s_D)
//============================================================================



static void Test_Vp_BFu7s_F()
{
  {
    init_simple_test("Vp_BFu7s_F");
    static STRUCT_IF_C Vp_BFu7s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_F)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_F, Vp_BFu7s_F)
//============================================================================



static void Test_Vp_BFu7s_I()
{
  {
    init_simple_test("Vp_BFu7s_I");
    static STRUCT_IF_C Vp_BFu7s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_I)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_I, Vp_BFu7s_I)
//============================================================================



static void Test_Vp_BFu7s_Ip()
{
  {
    init_simple_test("Vp_BFu7s_Ip");
    static STRUCT_IF_C Vp_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_Ip, Vp_BFu7s_Ip)
//============================================================================



static void Test_Vp_BFu7s_L()
{
  {
    init_simple_test("Vp_BFu7s_L");
    static STRUCT_IF_C Vp_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_L)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_L, Vp_BFu7s_L)
//============================================================================



static void Test_Vp_BFu7s_S()
{
  {
    init_simple_test("Vp_BFu7s_S");
    static STRUCT_IF_C Vp_BFu7s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_S)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_S, Vp_BFu7s_S)
//============================================================================



static void Test_Vp_BFu7s_Uc()
{
  {
    init_simple_test("Vp_BFu7s_Uc");
    static STRUCT_IF_C Vp_BFu7s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_Uc, Vp_BFu7s_Uc)
//============================================================================



static void Test_Vp_BFu7s_Ui()
{
  {
    init_simple_test("Vp_BFu7s_Ui");
    static STRUCT_IF_C Vp_BFu7s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_Ui, Vp_BFu7s_Ui)
//============================================================================



static void Test_Vp_BFu7s_Ul()
{
  {
    init_simple_test("Vp_BFu7s_Ul");
    static STRUCT_IF_C Vp_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Vp_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_Ul, Vp_BFu7s_Ul)
//============================================================================



static void Test_Vp_BFu7s_Us()
{
  {
    init_simple_test("Vp_BFu7s_Us");
    static STRUCT_IF_C Vp_BFu7s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_Us, Vp_BFu7s_Us)
//============================================================================



static void Test_Vp_BFu7s_Vp()
{
  {
    init_simple_test("Vp_BFu7s_Vp");
    static STRUCT_IF_C Vp_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Vp_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "Vp_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Vp_BFu7s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Vp_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "Vp_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu7s_Vp, Vp_BFu7s_Vp)
//============================================================================



static void Test_Vp_BFu8c()
{
  {
    init_simple_test("Vp_BFu8c");
    static STRUCT_IF_C Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c, Vp_BFu8c)
//============================================================================



static void Test_Vp_BFu8c_BFu15i()
{
  {
    init_simple_test("Vp_BFu8c_BFu15i");
    static STRUCT_IF_C Vp_BFu8c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Vp_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Vp_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu15i, Vp_BFu8c_BFu15i)
//============================================================================



static void Test_Vp_BFu8c_BFu15ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu15ll");
    static STRUCT_IF_C Vp_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Vp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Vp_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu15ll, Vp_BFu8c_BFu15ll)
//============================================================================



static void Test_Vp_BFu8c_BFu15s()
{
  {
    init_simple_test("Vp_BFu8c_BFu15s");
    static STRUCT_IF_C Vp_BFu8c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Vp_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Vp_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu15s, Vp_BFu8c_BFu15s)
//============================================================================



static void Test_Vp_BFu8c_BFu16i()
{
  {
    init_simple_test("Vp_BFu8c_BFu16i");
    static STRUCT_IF_C Vp_BFu8c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Vp_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Vp_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu16i, Vp_BFu8c_BFu16i)
//============================================================================



static void Test_Vp_BFu8c_BFu16ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu16ll");
    static STRUCT_IF_C Vp_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Vp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Vp_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu16ll, Vp_BFu8c_BFu16ll)
//============================================================================



static void Test_Vp_BFu8c_BFu16s()
{
  {
    init_simple_test("Vp_BFu8c_BFu16s");
    static STRUCT_IF_C Vp_BFu8c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Vp_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Vp_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Vp_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu16s, Vp_BFu8c_BFu16s)
//============================================================================



static void Test_Vp_BFu8c_BFu17i()
{
  {
    init_simple_test("Vp_BFu8c_BFu17i");
    static STRUCT_IF_C Vp_BFu8c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Vp_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Vp_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu17i, Vp_BFu8c_BFu17i)
//============================================================================



static void Test_Vp_BFu8c_BFu17ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu17ll");
    static STRUCT_IF_C Vp_BFu8c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Vp_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Vp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Vp_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu17ll, Vp_BFu8c_BFu17ll)
//============================================================================



static void Test_Vp_BFu8c_BFu1c()
{
  {
    init_simple_test("Vp_BFu8c_BFu1c");
    static STRUCT_IF_C Vp_BFu8c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Vp_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu1c, Vp_BFu8c_BFu1c)
//============================================================================



static void Test_Vp_BFu8c_BFu1i()
{
  {
    init_simple_test("Vp_BFu8c_BFu1i");
    static STRUCT_IF_C Vp_BFu8c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Vp_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu1i, Vp_BFu8c_BFu1i)
//============================================================================



static void Test_Vp_BFu8c_BFu1ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu1ll");
    static STRUCT_IF_C Vp_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Vp_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu1ll, Vp_BFu8c_BFu1ll)
//============================================================================



static void Test_Vp_BFu8c_BFu1s()
{
  {
    init_simple_test("Vp_BFu8c_BFu1s");
    static STRUCT_IF_C Vp_BFu8c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Vp_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu1s, Vp_BFu8c_BFu1s)
//============================================================================



static void Test_Vp_BFu8c_BFu31i()
{
  {
    init_simple_test("Vp_BFu8c_BFu31i");
    static STRUCT_IF_C Vp_BFu8c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Vp_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Vp_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu31i, Vp_BFu8c_BFu31i)
//============================================================================



static void Test_Vp_BFu8c_BFu31ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu31ll");
    static STRUCT_IF_C Vp_BFu8c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Vp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Vp_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu31ll, Vp_BFu8c_BFu31ll)
//============================================================================



static void Test_Vp_BFu8c_BFu32i()
{
  {
    init_simple_test("Vp_BFu8c_BFu32i");
    static STRUCT_IF_C Vp_BFu8c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Vp_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Vp_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu32i, Vp_BFu8c_BFu32i)
//============================================================================



static void Test_Vp_BFu8c_BFu32ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu32ll");
    static STRUCT_IF_C Vp_BFu8c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Vp_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Vp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Vp_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu32ll, Vp_BFu8c_BFu32ll)
//============================================================================



static void Test_Vp_BFu8c_BFu33()
{
  {
    init_simple_test("Vp_BFu8c_BFu33");
    static STRUCT_IF_C Vp_BFu8c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Vp_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Vp_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Vp_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu33, Vp_BFu8c_BFu33)
//============================================================================



static void Test_Vp_BFu8c_BFu7c()
{
  {
    init_simple_test("Vp_BFu8c_BFu7c");
    static STRUCT_IF_C Vp_BFu8c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Vp_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Vp_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu7c, Vp_BFu8c_BFu7c)
//============================================================================



static void Test_Vp_BFu8c_BFu7i()
{
  {
    init_simple_test("Vp_BFu8c_BFu7i");
    static STRUCT_IF_C Vp_BFu8c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Vp_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Vp_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu7i, Vp_BFu8c_BFu7i)
//============================================================================



static void Test_Vp_BFu8c_BFu7ll()
{
  {
    init_simple_test("Vp_BFu8c_BFu7ll");
    static STRUCT_IF_C Vp_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Vp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Vp_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu7ll, Vp_BFu8c_BFu7ll)
//============================================================================



static void Test_Vp_BFu8c_BFu7s()
{
  {
    init_simple_test("Vp_BFu8c_BFu7s");
    static STRUCT_IF_C Vp_BFu8c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Vp_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Vp_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu7s, Vp_BFu8c_BFu7s)
//============================================================================



static void Test_Vp_BFu8c_BFu8c()
{
  {
    init_simple_test("Vp_BFu8c_BFu8c");
    static STRUCT_IF_C Vp_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Vp_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Vp_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "Vp_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Vp_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Vp_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Vp_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Vp_BFu8c_BFu8c, Vp_BFu8c_BFu8c)
//============================================================================



static void Test_Vp_BFu8c_BFu8i()
{
  {
    init_simple_test("Vp_BFu8c_BFu8i");
    static STRUCT_IF_C Vp_BFu8c_BFu8i lv;
    check