// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct Ui_Ul_L { unsigned int v1; unsigned long long v2; long long v3; };
struct Ui_Ul_S { unsigned int v1; unsigned long long v2; short v3; };
struct Ui_Ul_Uc { unsigned int v1; unsigned long long v2; unsigned char v3; };
struct Ui_Ul_Ui { unsigned int v1; unsigned long long v2; unsigned int v3; };
struct Ui_Ul_Ul { unsigned int v1; unsigned long long v2; unsigned long long v3; };
struct Ui_Ul_Us { unsigned int v1; unsigned long long v2; unsigned short v3; };
struct Ui_Ul_Vp { unsigned int v1; unsigned long long v2; void * v3; };
struct Ui_Us { unsigned int v1; unsigned short v2; };
struct Ui_Us_BFu15i { unsigned int v1; unsigned short v2; unsigned int v3:15; };
struct Ui_Us_BFu15ll { unsigned int v1; unsigned short v2; unsigned long long v3:15; };
struct Ui_Us_BFu15s { unsigned int v1; unsigned short v2; unsigned short v3:15; };
struct Ui_Us_BFu16i { unsigned int v1; unsigned short v2; unsigned int v3:16; };
struct Ui_Us_BFu16ll { unsigned int v1; unsigned short v2; unsigned long long v3:16; };
struct Ui_Us_BFu16s { unsigned int v1; unsigned short v2; unsigned short v3:16; };
struct Ui_Us_BFu17i { unsigned int v1; unsigned short v2; unsigned int v3:17; };
struct Ui_Us_BFu17ll { unsigned int v1; unsigned short v2; unsigned long long v3:17; };
struct Ui_Us_BFu1c { unsigned int v1; unsigned short v2; unsigned char v3:1; };
struct Ui_Us_BFu1i { unsigned int v1; unsigned short v2; unsigned int v3:1; };
struct Ui_Us_BFu1ll { unsigned int v1; unsigned short v2; unsigned long long v3:1; };
struct Ui_Us_BFu1s { unsigned int v1; unsigned short v2; unsigned short v3:1; };
struct Ui_Us_BFu31i { unsigned int v1; unsigned short v2; unsigned int v3:31; };
struct Ui_Us_BFu31ll { unsigned int v1; unsigned short v2; unsigned long long v3:31; };
struct Ui_Us_BFu32i { unsigned int v1; unsigned short v2; unsigned int v3:32; };
struct Ui_Us_BFu32ll { unsigned int v1; unsigned short v2; unsigned long long v3:32; };
struct Ui_Us_BFu33 { unsigned int v1; unsigned short v2; unsigned long long v3:33; };
struct Ui_Us_BFu7c { unsigned int v1; unsigned short v2; unsigned char v3:7; };
struct Ui_Us_BFu7i { unsigned int v1; unsigned short v2; unsigned int v3:7; };
struct Ui_Us_BFu7ll { unsigned int v1; unsigned short v2; unsigned long long v3:7; };
struct Ui_Us_BFu7s { unsigned int v1; unsigned short v2; unsigned short v3:7; };
struct Ui_Us_BFu8c { unsigned int v1; unsigned short v2; unsigned char v3:8; };
struct Ui_Us_BFu8i { unsigned int v1; unsigned short v2; unsigned int v3:8; };
struct Ui_Us_BFu8ll { unsigned int v1; unsigned short v2; unsigned long long v3:8; };
struct Ui_Us_BFu8s { unsigned int v1; unsigned short v2; unsigned short v3:8; };
struct Ui_Us_BFu9i { unsigned int v1; unsigned short v2; unsigned int v3:9; };
struct Ui_Us_BFu9ll { unsigned int v1; unsigned short v2; unsigned long long v3:9; };
struct Ui_Us_BFu9s { unsigned int v1; unsigned short v2; unsigned short v3:9; };
struct Ui_Us_C { unsigned int v1; unsigned short v2; char v3; };
struct Ui_Us_D { unsigned int v1; unsigned short v2; double v3; };
struct Ui_Us_F { unsigned int v1; unsigned short v2; float v3; };
struct Ui_Us_I { unsigned int v1; unsigned short v2; int v3; };
struct Ui_Us_Ip { unsigned int v1; unsigned short v2; int * v3; };
struct Ui_Us_L { unsigned int v1; unsigned short v2; long long v3; };
struct Ui_Us_S { unsigned int v1; unsigned short v2; short v3; };
struct Ui_Us_Uc { unsigned int v1; unsigned short v2; unsigned char v3; };
struct Ui_Us_Ui { unsigned int v1; unsigned short v2; unsigned int v3; };
struct Ui_Us_Ul { unsigned int v1; unsigned short v2; unsigned long long v3; };
struct Ui_Us_Us { unsigned int v1; unsigned short v2; unsigned short v3; };
struct Ui_Us_Vp { unsigned int v1; unsigned short v2; void * v3; };
struct Ui_Vp { unsigned int v1; void * v2; };
struct Ui_Vp_BFu15i { unsigned int v1; void * v2; unsigned int v3:15; };
struct Ui_Vp_BFu15ll { unsigned int v1; void * v2; unsigned long long v3:15; };
struct Ui_Vp_BFu15s { unsigned int v1; void * v2; unsigned short v3:15; };
struct Ui_Vp_BFu16i { unsigned int v1; void * v2; unsigned int v3:16; };
struct Ui_Vp_BFu16ll { unsigned int v1; void * v2; unsigned long long v3:16; };
struct Ui_Vp_BFu16s { unsigned int v1; void * v2; unsigned short v3:16; };
struct Ui_Vp_BFu17i { unsigned int v1; void * v2; unsigned int v3:17; };
struct Ui_Vp_BFu17ll { unsigned int v1; void * v2; unsigned long long v3:17; };
struct Ui_Vp_BFu1c { unsigned int v1; void * v2; unsigned char v3:1; };
struct Ui_Vp_BFu1i { unsigned int v1; void * v2; unsigned int v3:1; };
struct Ui_Vp_BFu1ll { unsigned int v1; void * v2; unsigned long long v3:1; };
struct Ui_Vp_BFu1s { unsigned int v1; void * v2; unsigned short v3:1; };
struct Ui_Vp_BFu31i { unsigned int v1; void * v2; unsigned int v3:31; };
struct Ui_Vp_BFu31ll { unsigned int v1; void * v2; unsigned long long v3:31; };
struct Ui_Vp_BFu32i { unsigned int v1; void * v2; unsigned int v3:32; };
struct Ui_Vp_BFu32ll { unsigned int v1; void * v2; unsigned long long v3:32; };
struct Ui_Vp_BFu33 { unsigned int v1; void * v2; unsigned long long v3:33; };
struct Ui_Vp_BFu7c { unsigned int v1; void * v2; unsigned char v3:7; };
struct Ui_Vp_BFu7i { unsigned int v1; void * v2; unsigned int v3:7; };
struct Ui_Vp_BFu7ll { unsigned int v1; void * v2; unsigned long long v3:7; };
struct Ui_Vp_BFu7s { unsigned int v1; void * v2; unsigned short v3:7; };
struct Ui_Vp_BFu8c { unsigned int v1; void * v2; unsigned char v3:8; };
struct Ui_Vp_BFu8i { unsigned int v1; void * v2; unsigned int v3:8; };
struct Ui_Vp_BFu8ll { unsigned int v1; void * v2; unsigned long long v3:8; };
struct Ui_Vp_BFu8s { unsigned int v1; void * v2; unsigned short v3:8; };
struct Ui_Vp_BFu9i { unsigned int v1; void * v2; unsigned int v3:9; };
struct Ui_Vp_BFu9ll { unsigned int v1; void * v2; unsigned long long v3:9; };
struct Ui_Vp_BFu9s { unsigned int v1; void * v2; unsigned short v3:9; };
struct Ui_Vp_C { unsigned int v1; void * v2; char v3; };
struct Ui_Vp_D { unsigned int v1; void * v2; double v3; };
struct Ui_Vp_F { unsigned int v1; void * v2; float v3; };
struct Ui_Vp_I { unsigned int v1; void * v2; int v3; };
struct Ui_Vp_Ip { unsigned int v1; void * v2; int * v3; };
struct Ui_Vp_L { unsigned int v1; void * v2; long long v3; };
struct Ui_Vp_S { unsigned int v1; void * v2; short v3; };
struct Ui_Vp_Uc { unsigned int v1; void * v2; unsigned char v3; };
struct Ui_Vp_Ui { unsigned int v1; void * v2; unsigned int v3; };
struct Ui_Vp_Ul { unsigned int v1; void * v2; unsigned long long v3; };
struct Ui_Vp_Us { unsigned int v1; void * v2; unsigned short v3; };
struct Ui_Vp_Vp { unsigned int v1; void * v2; void * v3; };
struct Ul { unsigned long long v1; };
struct Ul_BFu15i { unsigned long long v1; unsigned int v2:15; };
struct Ul_BFu15i_BFu15i { unsigned long long v1; unsigned int v2:15; unsigned int v3:15; };
struct Ul_BFu15i_BFu15ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:15; };
struct Ul_BFu15i_BFu15s { unsigned long long v1; unsigned int v2:15; unsigned short v3:15; };
struct Ul_BFu15i_BFu16i { unsigned long long v1; unsigned int v2:15; unsigned int v3:16; };
struct Ul_BFu15i_BFu16ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:16; };
struct Ul_BFu15i_BFu16s { unsigned long long v1; unsigned int v2:15; unsigned short v3:16; };
struct Ul_BFu15i_BFu17i { unsigned long long v1; unsigned int v2:15; unsigned int v3:17; };
struct Ul_BFu15i_BFu17ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:17; };
struct Ul_BFu15i_BFu1c { unsigned long long v1; unsigned int v2:15; unsigned char v3:1; };
struct Ul_BFu15i_BFu1i { unsigned long long v1; unsigned int v2:15; unsigned int v3:1; };
struct Ul_BFu15i_BFu1ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:1; };
struct Ul_BFu15i_BFu1s { unsigned long long v1; unsigned int v2:15; unsigned short v3:1; };
struct Ul_BFu15i_BFu31i { unsigned long long v1; unsigned int v2:15; unsigned int v3:31; };
struct Ul_BFu15i_BFu31ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:31; };
struct Ul_BFu15i_BFu32i { unsigned long long v1; unsigned int v2:15; unsigned int v3:32; };
struct Ul_BFu15i_BFu32ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:32; };
struct Ul_BFu15i_BFu33 { unsigned long long v1; unsigned int v2:15; unsigned long long v3:33; };
struct Ul_BFu15i_BFu7c { unsigned long long v1; unsigned int v2:15; unsigned char v3:7; };
struct Ul_BFu15i_BFu7i { unsigned long long v1; unsigned int v2:15; unsigned int v3:7; };
struct Ul_BFu15i_BFu7ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:7; };
struct Ul_BFu15i_BFu7s { unsigned long long v1; unsigned int v2:15; unsigned short v3:7; };
struct Ul_BFu15i_BFu8c { unsigned long long v1; unsigned int v2:15; unsigned char v3:8; };
struct Ul_BFu15i_BFu8i { unsigned long long v1; unsigned int v2:15; unsigned int v3:8; };
struct Ul_BFu15i_BFu8ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:8; };
struct Ul_BFu15i_BFu8s { unsigned long long v1; unsigned int v2:15; unsigned short v3:8; };
struct Ul_BFu15i_BFu9i { unsigned long long v1; unsigned int v2:15; unsigned int v3:9; };
struct Ul_BFu15i_BFu9ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:9; };
struct Ul_BFu15i_BFu9s { unsigned long long v1; unsigned int v2:15; unsigned short v3:9; };
struct Ul_BFu15i_C { unsigned long long v1; unsigned int v2:15; char v3; };
struct Ul_BFu15i_D { unsigned long long v1; unsigned int v2:15; double v3; };
struct Ul_BFu15i_F { unsigned long long v1; unsigned int v2:15; float v3; };
struct Ul_BFu15i_I { unsigned long long v1; unsigned int v2:15; int v3; };
struct Ul_BFu15i_Ip { unsigned long long v1; unsigned int v2:15; int * v3; };
struct Ul_BFu15i_L { unsigned long long v1; unsigned int v2:15; long long v3; };
struct Ul_BFu15i_S { unsigned long long v1; unsigned int v2:15; short v3; };
struct Ul_BFu15i_Uc { unsigned long long v1; unsigned int v2:15; unsigned char v3; };
struct Ul_BFu15i_Ui { unsigned long long v1; unsigned int v2:15; unsigned int v3; };
struct Ul_BFu15i_Ul { unsigned long long v1; unsigned int v2:15; unsigned long long v3; };
struct Ul_BFu15i_Us { unsigned long long v1; unsigned int v2:15; unsigned short v3; };
struct Ul_BFu15i_Vp { unsigned long long v1; unsigned int v2:15; void * v3; };
struct Ul_BFu15ll { unsigned long long v1; unsigned long long v2:15; };
struct Ul_BFu15ll_BFu15i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:15; };
struct Ul_BFu15ll_BFu15ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:15; };
struct Ul_BFu15ll_BFu15s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:15; };
struct Ul_BFu15ll_BFu16i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:16; };
struct Ul_BFu15ll_BFu16ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:16; };
struct Ul_BFu15ll_BFu16s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:16; };
struct Ul_BFu15ll_BFu17i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:17; };
struct Ul_BFu15ll_BFu17ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:17; };
struct Ul_BFu15ll_BFu1c { unsigned long long v1; unsigned long long v2:15; unsigned char v3:1; };
struct Ul_BFu15ll_BFu1i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:1; };
struct Ul_BFu15ll_BFu1ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:1; };
struct Ul_BFu15ll_BFu1s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:1; };
struct Ul_BFu15ll_BFu31i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:31; };
struct Ul_BFu15ll_BFu31ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:31; };
struct Ul_BFu15ll_BFu32i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:32; };
struct Ul_BFu15ll_BFu32ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:32; };
struct Ul_BFu15ll_BFu33 { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:33; };
struct Ul_BFu15ll_BFu7c { unsigned long long v1; unsigned long long v2:15; unsigned char v3:7; };
struct Ul_BFu15ll_BFu7i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:7; };
struct Ul_BFu15ll_BFu7ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:7; };
struct Ul_BFu15ll_BFu7s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:7; };
struct Ul_BFu15ll_BFu8c { unsigned long long v1; unsigned long long v2:15; unsigned char v3:8; };
struct Ul_BFu15ll_BFu8i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:8; };
struct Ul_BFu15ll_BFu8ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:8; };
struct Ul_BFu15ll_BFu8s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:8; };
struct Ul_BFu15ll_BFu9i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:9; };
struct Ul_BFu15ll_BFu9ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:9; };
struct Ul_BFu15ll_BFu9s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:9; };
struct Ul_BFu15ll_C { unsigned long long v1; unsigned long long v2:15; char v3; };
struct Ul_BFu15ll_D { unsigned long long v1; unsigned long long v2:15; double v3; };
struct Ul_BFu15ll_F { unsigned long long v1; unsigned long long v2:15; float v3; };
struct Ul_BFu15ll_I { unsigned long long v1; unsigned long long v2:15; int v3; };
struct Ul_BFu15ll_Ip { unsigned long long v1; unsigned long long v2:15; int * v3; };
struct Ul_BFu15ll_L { unsigned long long v1; unsigned long long v2:15; long long v3; };
struct Ul_BFu15ll_S { unsigned long long v1; unsigned long long v2:15; short v3; };
struct Ul_BFu15ll_Uc { unsigned long long v1; unsigned long long v2:15; unsigned char v3; };
struct Ul_BFu15ll_Ui { unsigned long long v1; unsigned long long v2:15; unsigned int v3; };
struct Ul_BFu15ll_Ul { unsigned long long v1; unsigned long long v2:15; unsigned long long v3; };
struct Ul_BFu15ll_Us { unsigned long long v1; unsigned long long v2:15; unsigned short v3; };
struct Ul_BFu15ll_Vp { unsigned long long v1; unsigned long long v2:15; void * v3; };
struct Ul_BFu15s { unsigned long long v1; unsigned short v2:15; };
struct Ul_BFu15s_BFu15i { unsigned long long v1; unsigned short v2:15; unsigned int v3:15; };
struct Ul_BFu15s_BFu15ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:15; };
struct Ul_BFu15s_BFu15s { unsigned long long v1; unsigned short v2:15; unsigned short v3:15; };
struct Ul_BFu15s_BFu16i { unsigned long long v1; unsigned short v2:15; unsigned int v3:16; };
struct Ul_BFu15s_BFu16ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:16; };
struct Ul_BFu15s_BFu16s { unsigned long long v1; unsigned short v2:15; unsigned short v3:16; };
struct Ul_BFu15s_BFu17i { unsigned long long v1; unsigned short v2:15; unsigned int v3:17; };
struct Ul_BFu15s_BFu17ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:17; };
struct Ul_BFu15s_BFu1c { unsigned long long v1; unsigned short v2:15; unsigned char v3:1; };
struct Ul_BFu15s_BFu1i { unsigned long long v1; unsigned short v2:15; unsigned int v3:1; };
struct Ul_BFu15s_BFu1ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:1; };
struct Ul_BFu15s_BFu1s { unsigned long long v1; unsigned short v2:15; unsigned short v3:1; };
struct Ul_BFu15s_BFu31i { unsigned long long v1; unsigned short v2:15; unsigned int v3:31; };
struct Ul_BFu15s_BFu31ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:31; };
struct Ul_BFu15s_BFu32i { unsigned long long v1; unsigned short v2:15; unsigned int v3:32; };
struct Ul_BFu15s_BFu32ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:32; };
struct Ul_BFu15s_BFu33 { unsigned long long v1; unsigned short v2:15; unsigned long long v3:33; };
struct Ul_BFu15s_BFu7c { unsigned long long v1; unsigned short v2:15; unsigned char v3:7; };
struct Ul_BFu15s_BFu7i { unsigned long long v1; unsigned short v2:15; unsigned int v3:7; };
struct Ul_BFu15s_BFu7ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:7; };
struct Ul_BFu15s_BFu7s { unsigned long long v1; unsigned short v2:15; unsigned short v3:7; };
struct Ul_BFu15s_BFu8c { unsigned long long v1; unsigned short v2:15; unsigned char v3:8; };
struct Ul_BFu15s_BFu8i { unsigned long long v1; unsigned short v2:15; unsigned int v3:8; };
struct Ul_BFu15s_BFu8ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:8; };
struct Ul_BFu15s_BFu8s { unsigned long long v1; unsigned short v2:15; unsigned short v3:8; };
struct Ul_BFu15s_BFu9i { unsigned long long v1; unsigned short v2:15; unsigned int v3:9; };
struct Ul_BFu15s_BFu9ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:9; };
struct Ul_BFu15s_BFu9s { unsigned long long v1; unsigned short v2:15; unsigned short v3:9; };
struct Ul_BFu15s_C { unsigned long long v1; unsigned short v2:15; char v3; };
struct Ul_BFu15s_D { unsigned long long v1; unsigned short v2:15; double v3; };
struct Ul_BFu15s_F { unsigned long long v1; unsigned short v2:15; float v3; };
struct Ul_BFu15s_I { unsigned long long v1; unsigned short v2:15; int v3; };
struct Ul_BFu15s_Ip { unsigned long long v1; unsigned short v2:15; int * v3; };
struct Ul_BFu15s_L { unsigned long long v1; unsigned short v2:15; long long v3; };
struct Ul_BFu15s_S { unsigned long long v1; unsigned short v2:15; short v3; };
struct Ul_BFu15s_Uc { unsigned long long v1; unsigned short v2:15; unsigned char v3; };
struct Ul_BFu15s_Ui { unsigned long long v1; unsigned short v2:15; unsigned int v3; };
struct Ul_BFu15s_Ul { unsigned long long v1; unsigned short v2:15; unsigned long long v3; };
struct Ul_BFu15s_Us { unsigned long long v1; unsigned short v2:15; unsigned short v3; };
struct Ul_BFu15s_Vp { unsigned long long v1; unsigned short v2:15; void * v3; };
struct Ul_BFu16i { unsigned long long v1; unsigned int v2:16; };
struct Ul_BFu16i_BFu15i { unsigned long long v1; unsigned int v2:16; unsigned int v3:15; };
struct Ul_BFu16i_BFu15ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:15; };
struct Ul_BFu16i_BFu15s { unsigned long long v1; unsigned int v2:16; unsigned short v3:15; };
struct Ul_BFu16i_BFu16i { unsigned long long v1; unsigned int v2:16; unsigned int v3:16; };
struct Ul_BFu16i_BFu16ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:16; };
struct Ul_BFu16i_BFu16s { unsigned long long v1; unsigned int v2:16; unsigned short v3:16; };
struct Ul_BFu16i_BFu17i { unsigned long long v1; unsigned int v2:16; unsigned int v3:17; };
struct Ul_BFu16i_BFu17ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:17; };
struct Ul_BFu16i_BFu1c { unsigned long long v1; unsigned int v2:16; unsigned char v3:1; };
struct Ul_BFu16i_BFu1i { unsigned long long v1; unsigned int v2:16; unsigned int v3:1; };
struct Ul_BFu16i_BFu1ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:1; };
struct Ul_BFu16i_BFu1s { unsigned long long v1; unsigned int v2:16; unsigned short v3:1; };
struct Ul_BFu16i_BFu31i { unsigned long long v1; unsigned int v2:16; unsigned int v3:31; };
struct Ul_BFu16i_BFu31ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:31; };
struct Ul_BFu16i_BFu32i { unsigned long long v1; unsigned int v2:16; unsigned int v3:32; };
struct Ul_BFu16i_BFu32ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:32; };
struct Ul_BFu16i_BFu33 { unsigned long long v1; unsigned int v2:16; unsigned long long v3:33; };
struct Ul_BFu16i_BFu7c { unsigned long long v1; unsigned int v2:16; unsigned char v3:7; };
struct Ul_BFu16i_BFu7i { unsigned long long v1; unsigned int v2:16; unsigned int v3:7; };
struct Ul_BFu16i_BFu7ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:7; };
struct Ul_BFu16i_BFu7s { unsigned long long v1; unsigned int v2:16; unsigned short v3:7; };
struct Ul_BFu16i_BFu8c { unsigned long long v1; unsigned int v2:16; unsigned char v3:8; };
struct Ul_BFu16i_BFu8i { unsigned long long v1; unsigned int v2:16; unsigned int v3:8; };
struct Ul_BFu16i_BFu8ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:8; };
struct Ul_BFu16i_BFu8s { unsigned long long v1; unsigned int v2:16; unsigned short v3:8; };
struct Ul_BFu16i_BFu9i { unsigned long long v1; unsigned int v2:16; unsigned int v3:9; };
struct Ul_BFu16i_BFu9ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:9; };
struct Ul_BFu16i_BFu9s { unsigned long long v1; unsigned int v2:16; unsigned short v3:9; };
struct Ul_BFu16i_C { unsigned long long v1; unsigned int v2:16; char v3; };
struct Ul_BFu16i_D { unsigned long long v1; unsigned int v2:16; double v3; };
struct Ul_BFu16i_F { unsigned long long v1; unsigned int v2:16; float v3; };
struct Ul_BFu16i_I { unsigned long long v1; unsigned int v2:16; int v3; };
struct Ul_BFu16i_Ip { unsigned long long v1; unsigned int v2:16; int * v3; };
struct Ul_BFu16i_L { unsigned long long v1; unsigned int v2:16; long long v3; };
struct Ul_BFu16i_S { unsigned long long v1; unsigned int v2:16; short v3; };
struct Ul_BFu16i_Uc { unsigned long long v1; unsigned int v2:16; unsigned char v3; };
struct Ul_BFu16i_Ui { unsigned long long v1; unsigned int v2:16; unsigned int v3; };
struct Ul_BFu16i_Ul { unsigned long long v1; unsigned int v2:16; unsigned long long v3; };
struct Ul_BFu16i_Us { unsigned long long v1; unsigned int v2:16; unsigned short v3; };
struct Ul_BFu16i_Vp { unsigned long long v1; unsigned int v2:16; void * v3; };
struct Ul_BFu16ll { unsigned long long v1; unsigned long long v2:16; };
struct Ul_BFu16ll_BFu15i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:15; };
struct Ul_BFu16ll_BFu15ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:15; };
struct Ul_BFu16ll_BFu15s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:15; };
struct Ul_BFu16ll_BFu16i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:16; };
struct Ul_BFu16ll_BFu16ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:16; };
struct Ul_BFu16ll_BFu16s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:16; };
struct Ul_BFu16ll_BFu17i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:17; };
struct Ul_BFu16ll_BFu17ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:17; };
struct Ul_BFu16ll_BFu1c { unsigned long long v1; unsigned long long v2:16; unsigned char v3:1; };
struct Ul_BFu16ll_BFu1i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:1; };
struct Ul_BFu16ll_BFu1ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:1; };
struct Ul_BFu16ll_BFu1s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:1; };
struct Ul_BFu16ll_BFu31i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:31; };
struct Ul_BFu16ll_BFu31ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:31; };
struct Ul_BFu16ll_BFu32i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:32; };
struct Ul_BFu16ll_BFu32ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:32; };
struct Ul_BFu16ll_BFu33 { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:33; };
struct Ul_BFu16ll_BFu7c { unsigned long long v1; unsigned long long v2:16; unsigned char v3:7; };
struct Ul_BFu16ll_BFu7i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:7; };
struct Ul_BFu16ll_BFu7ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:7; };
struct Ul_BFu16ll_BFu7s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:7; };
struct Ul_BFu16ll_BFu8c { unsigned long long v1; unsigned long long v2:16; unsigned char v3:8; };
struct Ul_BFu16ll_BFu8i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:8; };
struct Ul_BFu16ll_BFu8ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:8; };
struct Ul_BFu16ll_BFu8s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:8; };
struct Ul_BFu16ll_BFu9i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:9; };
struct Ul_BFu16ll_BFu9ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:9; };
struct Ul_BFu16ll_BFu9s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:9; };
struct Ul_BFu16ll_C { unsigned long long v1; unsigned long long v2:16; char v3; };
struct Ul_BFu16ll_D { unsigned long long v1; unsigned long long v2:16; double v3; };
struct Ul_BFu16ll_F { unsigned long long v1; unsigned long long v2:16; float v3; };
struct Ul_BFu16ll_I { unsigned long long v1; unsigned long long v2:16; int v3; };
struct Ul_BFu16ll_Ip { unsigned long long v1; unsigned long long v2:16; int * v3; };
struct Ul_BFu16ll_L { unsigned long long v1; unsigned long long v2:16; long long v3; };
struct Ul_BFu16ll_S { unsigned long long v1; unsigned long long v2:16; short v3; };
struct Ul_BFu16ll_Uc { unsigned long long v1; unsigned long long v2:16; unsigned char v3; };
struct Ul_BFu16ll_Ui { unsigned long long v1; unsigned long long v2:16; unsigned int v3; };
struct Ul_BFu16ll_Ul { unsigned long long v1; unsigned long long v2:16; unsigned long long v3; };
struct Ul_BFu16ll_Us { unsigned long long v1; unsigned long long v2:16; unsigned short v3; };
struct Ul_BFu16ll_Vp { unsigned long long v1; unsigned long long v2:16; void * v3; };
struct Ul_BFu16s { unsigned long long v1; unsigned short v2:16; };
struct Ul_BFu16s_BFu15i { unsigned long long v1; unsigned short v2:16; unsigned int v3:15; };
struct Ul_BFu16s_BFu15ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:15; };
struct Ul_BFu16s_BFu15s { unsigned long long v1; unsigned short v2:16; unsigned short v3:15; };
struct Ul_BFu16s_BFu16i { unsigned long long v1; unsigned short v2:16; unsigned int v3:16; };
struct Ul_BFu16s_BFu16ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:16; };
struct Ul_BFu16s_BFu16s { unsigned long long v1; unsigned short v2:16; unsigned short v3:16; };
struct Ul_BFu16s_BFu17i { unsigned long long v1; unsigned short v2:16; unsigned int v3:17; };
struct Ul_BFu16s_BFu17ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:17; };
struct Ul_BFu16s_BFu1c { unsigned long long v1; unsigned short v2:16; unsigned char v3:1; };
struct Ul_BFu16s_BFu1i { unsigned long long v1; unsigned short v2:16; unsigned int v3:1; };
struct Ul_BFu16s_BFu1ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:1; };
struct Ul_BFu16s_BFu1s { unsigned long long v1; unsigned short v2:16; unsigned short v3:1; };
struct Ul_BFu16s_BFu31i { unsigned long long v1; unsigned short v2:16; unsigned int v3:31; };
struct Ul_BFu16s_BFu31ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:31; };
struct Ul_BFu16s_BFu32i { unsigned long long v1; unsigned short v2:16; unsigned int v3:32; };
struct Ul_BFu16s_BFu32ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:32; };
struct Ul_BFu16s_BFu33 { unsigned long long v1; unsigned short v2:16; unsigned long long v3:33; };
struct Ul_BFu16s_BFu7c { unsigned long long v1; unsigned short v2:16; unsigned char v3:7; };
struct Ul_BFu16s_BFu7i { unsigned long long v1; unsigned short v2:16; unsigned int v3:7; };
struct Ul_BFu16s_BFu7ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:7; };
struct Ul_BFu16s_BFu7s { unsigned long long v1; unsigned short v2:16; unsigned short v3:7; };
struct Ul_BFu16s_BFu8c { unsigned long long v1; unsigned short v2:16; unsigned char v3:8; };
struct Ul_BFu16s_BFu8i { unsigned long long v1; unsigned short v2:16; unsigned int v3:8; };
struct Ul_BFu16s_BFu8ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:8; };
struct Ul_BFu16s_BFu8s { unsigned long long v1; unsigned short v2:16; unsigned short v3:8; };
struct Ul_BFu16s_BFu9i { unsigned long long v1; unsigned short v2:16; unsigned int v3:9; };
struct Ul_BFu16s_BFu9ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:9; };
struct Ul_BFu16s_BFu9s { unsigned long long v1; unsigned short v2:16; unsigned short v3:9; };
struct Ul_BFu16s_C { unsigned long long v1; unsigned short v2:16; char v3; };
struct Ul_BFu16s_D { unsigned long long v1; unsigned short v2:16; double v3; };
struct Ul_BFu16s_F { unsigned long long v1; unsigned short v2:16; float v3; };
struct Ul_BFu16s_I { unsigned long long v1; unsigned short v2:16; int v3; };
struct Ul_BFu16s_Ip { unsigned long long v1; unsigned short v2:16; int * v3; };
struct Ul_BFu16s_L { unsigned long long v1; unsigned short v2:16; long long v3; };
struct Ul_BFu16s_S { unsigned long long v1; unsigned short v2:16; short v3; };
struct Ul_BFu16s_Uc { unsigned long long v1; unsigned short v2:16; unsigned char v3; };
struct Ul_BFu16s_Ui { unsigned long long v1; unsigned short v2:16; unsigned int v3; };
struct Ul_BFu16s_Ul { unsigned long long v1; unsigned short v2:16; unsigned long long v3; };
struct Ul_BFu16s_Us { unsigned long long v1; unsigned short v2:16; unsigned short v3; };
struct Ul_BFu16s_Vp { unsigned long long v1; unsigned short v2:16; void * v3; };
struct Ul_BFu17i { unsigned long long v1; unsigned int v2:17; };
struct Ul_BFu17i_BFu15i { unsigned long long v1; unsigned int v2:17; unsigned int v3:15; };
struct Ul_BFu17i_BFu15ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:15; };
struct Ul_BFu17i_BFu15s { unsigned long long v1; unsigned int v2:17; unsigned short v3:15; };
struct Ul_BFu17i_BFu16i { unsigned long long v1; unsigned int v2:17; unsigned int v3:16; };
struct Ul_BFu17i_BFu16ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:16; };
struct Ul_BFu17i_BFu16s { unsigned long long v1; unsigned int v2:17; unsigned short v3:16; };
struct Ul_BFu17i_BFu17i { unsigned long long v1; unsigned int v2:17; unsigned int v3:17; };
struct Ul_BFu17i_BFu17ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:17; };
struct Ul_BFu17i_BFu1c { unsigned long long v1; unsigned int v2:17; unsigned char v3:1; };
struct Ul_BFu17i_BFu1i { unsigned long long v1; unsigned int v2:17; unsigned int v3:1; };
struct Ul_BFu17i_BFu1ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:1; };
struct Ul_BFu17i_BFu1s { unsigned long long v1; unsigned int v2:17; unsigned short v3:1; };
struct Ul_BFu17i_BFu31i { unsigned long long v1; unsigned int v2:17; unsigned int v3:31; };
struct Ul_BFu17i_BFu31ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:31; };
struct Ul_BFu17i_BFu32i { unsigned long long v1; unsigned int v2:17; unsigned int v3:32; };
struct Ul_BFu17i_BFu32ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:32; };
struct Ul_BFu17i_BFu33 { unsigned long long v1; unsigned int v2:17; unsigned long long v3:33; };
struct Ul_BFu17i_BFu7c { unsigned long long v1; unsigned int v2:17; unsigned char v3:7; };
struct Ul_BFu17i_BFu7i { unsigned long long v1; unsigned int v2:17; unsigned int v3:7; };
struct Ul_BFu17i_BFu7ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:7; };
struct Ul_BFu17i_BFu7s { unsigned long long v1; unsigned int v2:17; unsigned short v3:7; };
struct Ul_BFu17i_BFu8c { unsigned long long v1; unsigned int v2:17; unsigned char v3:8; };
struct Ul_BFu17i_BFu8i { unsigned long long v1; unsigned int v2:17; unsigned int v3:8; };
struct Ul_BFu17i_BFu8ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:8; };
struct Ul_BFu17i_BFu8s { unsigned long long v1; unsigned int v2:17; unsigned short v3:8; };
struct Ul_BFu17i_BFu9i { unsigned long long v1; unsigned int v2:17; unsigned int v3:9; };
struct Ul_BFu17i_BFu9ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:9; };
struct Ul_BFu17i_BFu9s { unsigned long long v1; unsigned int v2:17; unsigned short v3:9; };
struct Ul_BFu17i_C { unsigned long long v1; unsigned int v2:17; char v3; };
struct Ul_BFu17i_D { unsigned long long v1; unsigned int v2:17; double v3; };
struct Ul_BFu17i_F { unsigned long long v1; unsigned int v2:17; float v3; };
struct Ul_BFu17i_I { unsigned long long v1; unsigned int v2:17; int v3; };
struct Ul_BFu17i_Ip { unsigned long long v1; unsigned int v2:17; int * v3; };
struct Ul_BFu17i_L { unsigned long long v1; unsigned int v2:17; long long v3; };
struct Ul_BFu17i_S { unsigned long long v1; unsigned int v2:17; short v3; };
struct Ul_BFu17i_Uc { unsigned long long v1; unsigned int v2:17; unsigned char v3; };
struct Ul_BFu17i_Ui { unsigned long long v1; unsigned int v2:17; unsigned int v3; };
struct Ul_BFu17i_Ul { unsigned long long v1; unsigned int v2:17; unsigned long long v3; };
struct Ul_BFu17i_Us { unsigned long long v1; unsigned int v2:17; unsigned short v3; };
struct Ul_BFu17i_Vp { unsigned long long v1; unsigned int v2:17; void * v3; };
struct Ul_BFu17ll { unsigned long long v1; unsigned long long v2:17; };
struct Ul_BFu17ll_BFu15i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:15; };
struct Ul_BFu17ll_BFu15ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:15; };
struct Ul_BFu17ll_BFu15s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:15; };
struct Ul_BFu17ll_BFu16i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:16; };
struct Ul_BFu17ll_BFu16ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:16; };
struct Ul_BFu17ll_BFu16s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:16; };
struct Ul_BFu17ll_BFu17i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:17; };
struct Ul_BFu17ll_BFu17ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:17; };
struct Ul_BFu17ll_BFu1c { unsigned long long v1; unsigned long long v2:17; unsigned char v3:1; };
struct Ul_BFu17ll_BFu1i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:1; };
struct Ul_BFu17ll_BFu1ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:1; };
struct Ul_BFu17ll_BFu1s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:1; };
struct Ul_BFu17ll_BFu31i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:31; };
struct Ul_BFu17ll_BFu31ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:31; };
struct Ul_BFu17ll_BFu32i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:32; };
struct Ul_BFu17ll_BFu32ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:32; };
struct Ul_BFu17ll_BFu33 { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:33; };
struct Ul_BFu17ll_BFu7c { unsigned long long v1; unsigned long long v2:17; unsigned char v3:7; };
struct Ul_BFu17ll_BFu7i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:7; };
struct Ul_BFu17ll_BFu7ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:7; };
struct Ul_BFu17ll_BFu7s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:7; };
struct Ul_BFu17ll_BFu8c { unsigned long long v1; unsigned long long v2:17; unsigned char v3:8; };
struct Ul_BFu17ll_BFu8i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:8; };
struct Ul_BFu17ll_BFu8ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:8; };
struct Ul_BFu17ll_BFu8s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:8; };
struct Ul_BFu17ll_BFu9i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:9; };
struct Ul_BFu17ll_BFu9ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:9; };
struct Ul_BFu17ll_BFu9s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:9; };
struct Ul_BFu17ll_C { unsigned long long v1; unsigned long long v2:17; char v3; };
struct Ul_BFu17ll_D { unsigned long long v1; unsigned long long v2:17; double v3; };
struct Ul_BFu17ll_F { unsigned long long v1; unsigned long long v2:17; float v3; };
struct Ul_BFu17ll_I { unsigned long long v1; unsigned long long v2:17; int v3; };
struct Ul_BFu17ll_Ip { unsigned long long v1; unsigned long long v2:17; int * v3; };
struct Ul_BFu17ll_L { unsigned long long v1; unsigned long long v2:17; long long v3; };
struct Ul_BFu17ll_S { unsigned long long v1; unsigned long long v2:17; short v3; };
struct Ul_BFu17ll_Uc { unsigned long long v1; unsigned long long v2:17; unsigned char v3; };
struct Ul_BFu17ll_Ui { unsigned long long v1; unsigned long long v2:17; unsigned int v3; };
struct Ul_BFu17ll_Ul { unsigned long long v1; unsigned long long v2:17; unsigned long long v3; };
struct Ul_BFu17ll_Us { unsigned long long v1; unsigned long long v2:17; unsigned short v3; };
struct Ul_BFu17ll_Vp { unsigned long long v1; unsigned long long v2:17; void * v3; };
struct Ul_BFu1c { unsigned long long v1; unsigned char v2:1; };
struct Ul_BFu1c_BFu15i { unsigned long long v1; unsigned char v2:1; unsigned int v3:15; };
struct Ul_BFu1c_BFu15ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:15; };
struct Ul_BFu1c_BFu15s { unsigned long long v1; unsigned char v2:1; unsigned short v3:15; };
struct Ul_BFu1c_BFu16i { unsigned long long v1; unsigned char v2:1; unsigned int v3:16; };
struct Ul_BFu1c_BFu16ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:16; };
struct Ul_BFu1c_BFu16s { unsigned long long v1; unsigned char v2:1; unsigned short v3:16; };
struct Ul_BFu1c_BFu17i { unsigned long long v1; unsigned char v2:1; unsigned int v3:17; };
struct Ul_BFu1c_BFu17ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:17; };
struct Ul_BFu1c_BFu1c { unsigned long long v1; unsigned char v2:1; unsigned char v3:1; };
struct Ul_BFu1c_BFu1i { unsigned long long v1; unsigned char v2:1; unsigned int v3:1; };
struct Ul_BFu1c_BFu1ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:1; };
struct Ul_BFu1c_BFu1s { unsigned long long v1; unsigned char v2:1; unsigned short v3:1; };
struct Ul_BFu1c_BFu31i { unsigned long long v1; unsigned char v2:1; unsigned int v3:31; };
struct Ul_BFu1c_BFu31ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:31; };
struct Ul_BFu1c_BFu32i { unsigned long long v1; unsigned char v2:1; unsigned int v3:32; };
struct Ul_BFu1c_BFu32ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:32; };
struct Ul_BFu1c_BFu33 { unsigned long long v1; unsigned char v2:1; unsigned long long v3:33; };
struct Ul_BFu1c_BFu7c { unsigned long long v1; unsigned char v2:1; unsigned char v3:7; };
struct Ul_BFu1c_BFu7i { unsigned long long v1; unsigned char v2:1; unsigned int v3:7; };
struct Ul_BFu1c_BFu7ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:7; };
struct Ul_BFu1c_BFu7s { unsigned long long v1; unsigned char v2:1; unsigned short v3:7; };
struct Ul_BFu1c_BFu8c { unsigned long long v1; unsigned char v2:1; unsigned char v3:8; };
struct Ul_BFu1c_BFu8i { unsigned long long v1; unsigned char v2:1; unsigned int v3:8; };
struct Ul_BFu1c_BFu8ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:8; };
struct Ul_BFu1c_BFu8s { unsigned long long v1; unsigned char v2:1; unsigned short v3:8; };
struct Ul_BFu1c_BFu9i { unsigned long long v1; unsigned char v2:1; unsigned int v3:9; };
struct Ul_BFu1c_BFu9ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:9; };
struct Ul_BFu1c_BFu9s { unsigned long long v1; unsigned char v2:1; unsigned short v3:9; };
struct Ul_BFu1c_C { unsigned long long v1; unsigned char v2:1; char v3; };
struct Ul_BFu1c_D { unsigned long long v1; unsigned char v2:1; double v3; };
struct Ul_BFu1c_F { unsigned long long v1; unsigned char v2:1; float v3; };
struct Ul_BFu1c_I { unsigned long long v1; unsigned char v2:1; int v3; };
struct Ul_BFu1c_Ip { unsigned long long v1; unsigned char v2:1; int * v3; };
struct Ul_BFu1c_L { unsigned long long v1; unsigned char v2:1; long long v3; };
struct Ul_BFu1c_S { unsigned long long v1; unsigned char v2:1; short v3; };
struct Ul_BFu1c_Uc { unsigned long long v1; unsigned char v2:1; unsigned char v3; };
struct Ul_BFu1c_Ui { unsigned long long v1; unsigned char v2:1; unsigned int v3; };
struct Ul_BFu1c_Ul { unsigned long long v1; unsigned char v2:1; unsigned long long v3; };
struct Ul_BFu1c_Us { unsigned long long v1; unsigned char v2:1; unsigned short v3; };
struct Ul_BFu1c_Vp { unsigned long long v1; unsigned char v2:1; void * v3; };
struct Ul_BFu1i { unsigned long long v1; unsigned int v2:1; };
struct Ul_BFu1i_BFu15i { unsigned long long v1; unsigned int v2:1; unsigned int v3:15; };
struct Ul_BFu1i_BFu15ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:15; };
struct Ul_BFu1i_BFu15s { unsigned long long v1; unsigned int v2:1; unsigned short v3:15; };
struct Ul_BFu1i_BFu16i { unsigned long long v1; unsigned int v2:1; unsigned int v3:16; };
struct Ul_BFu1i_BFu16ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:16; };
struct Ul_BFu1i_BFu16s { unsigned long long v1; unsigned int v2:1; unsigned short v3:16; };
struct Ul_BFu1i_BFu17i { unsigned long long v1; unsigned int v2:1; unsigned int v3:17; };
struct Ul_BFu1i_BFu17ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:17; };
struct Ul_BFu1i_BFu1c { unsigned long long v1; unsigned int v2:1; unsigned char v3:1; };
struct Ul_BFu1i_BFu1i { unsigned long long v1; unsigned int v2:1; unsigned int v3:1; };
struct Ul_BFu1i_BFu1ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:1; };
struct Ul_BFu1i_BFu1s { unsigned long long v1; unsigned int v2:1; unsigned short v3:1; };
struct Ul_BFu1i_BFu31i { unsigned long long v1; unsigned int v2:1; unsigned int v3:31; };
struct Ul_BFu1i_BFu31ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:31; };
struct Ul_BFu1i_BFu32i { unsigned long long v1; unsigned int v2:1; unsigned int v3:32; };
struct Ul_BFu1i_BFu32ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:32; };
struct Ul_BFu1i_BFu33 { unsigned long long v1; unsigned int v2:1; unsigned long long v3:33; };
struct Ul_BFu1i_BFu7c { unsigned long long v1; unsigned int v2:1; unsigned char v3:7; };
struct Ul_BFu1i_BFu7i { unsigned long long v1; unsigned int v2:1; unsigned int v3:7; };
struct Ul_BFu1i_BFu7ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:7; };
struct Ul_BFu1i_BFu7s { unsigned long long v1; unsigned int v2:1; unsigned short v3:7; };
struct Ul_BFu1i_BFu8c { unsigned long long v1; unsigned int v2:1; unsigned char v3:8; };
struct Ul_BFu1i_BFu8i { unsigned long long v1; unsigned int v2:1; unsigned int v3:8; };
struct Ul_BFu1i_BFu8ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:8; };
struct Ul_BFu1i_BFu8s { unsigned long long v1; unsigned int v2:1; unsigned short v3:8; };
struct Ul_BFu1i_BFu9i { unsigned long long v1; unsigned int v2:1; unsigned int v3:9; };
struct Ul_BFu1i_BFu9ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:9; };
struct Ul_BFu1i_BFu9s { unsigned long long v1; unsigned int v2:1; unsigned short v3:9; };
struct Ul_BFu1i_C { unsigned long long v1; unsigned int v2:1; char v3; };
struct Ul_BFu1i_D { unsigned long long v1; unsigned int v2:1; double v3; };
struct Ul_BFu1i_F { unsigned long long v1; unsigned int v2:1; float v3; };
struct Ul_BFu1i_I { unsigned long long v1; unsigned int v2:1; int v3; };
struct Ul_BFu1i_Ip { unsigned long long v1; unsigned int v2:1; int * v3; };
struct Ul_BFu1i_L { unsigned long long v1; unsigned int v2:1; long long v3; };
struct Ul_BFu1i_S { unsigned long long v1; unsigned int v2:1; short v3; };
struct Ul_BFu1i_Uc { unsigned long long v1; unsigned int v2:1; unsigned char v3; };
struct Ul_BFu1i_Ui { unsigned long long v1; unsigned int v2:1; unsigned int v3; };
struct Ul_BFu1i_Ul { unsigned long long v1; unsigned int v2:1; unsigned long long v3; };
struct Ul_BFu1i_Us { unsigned long long v1; unsigned int v2:1; unsigned short v3; };
struct Ul_BFu1i_Vp { unsigned long long v1; unsigned int v2:1; void * v3; };
struct Ul_BFu1ll { unsigned long long v1; unsigned long long v2:1; };
struct Ul_BFu1ll_BFu15i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:15; };
struct Ul_BFu1ll_BFu15ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:15; };
struct Ul_BFu1ll_BFu15s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:15; };
struct Ul_BFu1ll_BFu16i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:16; };
struct Ul_BFu1ll_BFu16ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:16; };
struct Ul_BFu1ll_BFu16s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:16; };
struct Ul_BFu1ll_BFu17i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:17; };
struct Ul_BFu1ll_BFu17ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:17; };
struct Ul_BFu1ll_BFu1c { unsigned long long v1; unsigned long long v2:1; unsigned char v3:1; };
struct Ul_BFu1ll_BFu1i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:1; };
struct Ul_BFu1ll_BFu1ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:1; };
struct Ul_BFu1ll_BFu1s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:1; };
struct Ul_BFu1ll_BFu31i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:31; };
struct Ul_BFu1ll_BFu31ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:31; };
struct Ul_BFu1ll_BFu32i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:32; };
struct Ul_BFu1ll_BFu32ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:32; };
struct Ul_BFu1ll_BFu33 { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:33; };
struct Ul_BFu1ll_BFu7c { unsigned long long v1; unsigned long long v2:1; unsigned char v3:7; };
struct Ul_BFu1ll_BFu7i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:7; };
struct Ul_BFu1ll_BFu7ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:7; };
struct Ul_BFu1ll_BFu7s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:7; };
struct Ul_BFu1ll_BFu8c { unsigned long long v1; unsigned long long v2:1; unsigned char v3:8; };
struct Ul_BFu1ll_BFu8i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:8; };
struct Ul_BFu1ll_BFu8ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:8; };
struct Ul_BFu1ll_BFu8s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:8; };
struct Ul_BFu1ll_BFu9i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:9; };
struct Ul_BFu1ll_BFu9ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:9; };
struct Ul_BFu1ll_BFu9s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:9; };
struct Ul_BFu1ll_C { unsigned long long v1; unsigned long long v2:1; char v3; };
struct Ul_BFu1ll_D { unsigned long long v1; unsigned long long v2:1; double v3; };
struct Ul_BFu1ll_F { unsigned long long v1; unsigned long long v2:1; float v3; };
struct Ul_BFu1ll_I { unsigned long long v1; unsigned long long v2:1; int v3; };
struct Ul_BFu1ll_Ip { unsigned long long v1; unsigned long long v2:1; int * v3; };
struct Ul_BFu1ll_L { unsigned long long v1; unsigned long long v2:1; long long v3; };
struct Ul_BFu1ll_S { unsigned long long v1; unsigned long long v2:1; short v3; };
struct Ul_BFu1ll_Uc { unsigned long long v1; unsigned long long v2:1; unsigned char v3; };
struct Ul_BFu1ll_Ui { unsigned long long v1; unsigned long long v2:1; unsigned int v3; };
struct Ul_BFu1ll_Ul { unsigned long long v1; unsigned long long v2:1; unsigned long long v3; };
struct Ul_BFu1ll_Us { unsigned long long v1; unsigned long long v2:1; unsigned short v3; };
struct Ul_BFu1ll_Vp { unsigned long long v1; unsigned long long v2:1; void * v3; };
struct Ul_BFu1s { unsigned long long v1; unsigned short v2:1; };
struct Ul_BFu1s_BFu15i { unsigned long long v1; unsigned short v2:1; unsigned int v3:15; };
struct Ul_BFu1s_BFu15ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:15; };
struct Ul_BFu1s_BFu15s { unsigned long long v1; unsigned short v2:1; unsigned short v3:15; };
struct Ul_BFu1s_BFu16i { unsigned long long v1; unsigned short v2:1; unsigned int v3:16; };
struct Ul_BFu1s_BFu16ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:16; };
struct Ul_BFu1s_BFu16s { unsigned long long v1; unsigned short v2:1; unsigned short v3:16; };
struct Ul_BFu1s_BFu17i { unsigned long long v1; unsigned short v2:1; unsigned int v3:17; };
struct Ul_BFu1s_BFu17ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:17; };
struct Ul_BFu1s_BFu1c { unsigned long long v1; unsigned short v2:1; unsigned char v3:1; };
struct Ul_BFu1s_BFu1i { unsigned long long v1; unsigned short v2:1; unsigned int v3:1; };
struct Ul_BFu1s_BFu1ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:1; };
struct Ul_BFu1s_BFu1s { unsigned long long v1; unsigned short v2:1; unsigned short v3:1; };
struct Ul_BFu1s_BFu31i { unsigned long long v1; unsigned short v2:1; unsigned int v3:31; };
struct Ul_BFu1s_BFu31ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:31; };
struct Ul_BFu1s_BFu32i { unsigned long long v1; unsigned short v2:1; unsigned int v3:32; };
struct Ul_BFu1s_BFu32ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:32; };
struct Ul_BFu1s_BFu33 { unsigned long long v1; unsigned short v2:1; unsigned long long v3:33; };
struct Ul_BFu1s_BFu7c { unsigned long long v1; unsigned short v2:1; unsigned char v3:7; };
struct Ul_BFu1s_BFu7i { unsigned long long v1; unsigned short v2:1; unsigned int v3:7; };
struct Ul_BFu1s_BFu7ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:7; };
struct Ul_BFu1s_BFu7s { unsigned long long v1; unsigned short v2:1; unsigned short v3:7; };
struct Ul_BFu1s_BFu8c { unsigned long long v1; unsigned short v2:1; unsigned char v3:8; };
struct Ul_BFu1s_BFu8i { unsigned long long v1; unsigned short v2:1; unsigned int v3:8; };
struct Ul_BFu1s_BFu8ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:8; };
struct Ul_BFu1s_BFu8s { unsigned long long v1; unsigned short v2:1; unsigned short v3:8; };
struct Ul_BFu1s_BFu9i { unsigned long long v1; unsigned short v2:1; unsigned int v3:9; };
struct Ul_BFu1s_BFu9ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:9; };
struct Ul_BFu1s_BFu9s { unsigned long long v1; unsigned short v2:1; unsigned short v3:9; };
struct Ul_BFu1s_C { unsigned long long v1; unsigned short v2:1; char v3; };
struct Ul_BFu1s_D { unsigned long long v1; unsigned short v2:1; double v3; };
struct Ul_BFu1s_F { unsigned long long v1; unsigned short v2:1; float v3; };
struct Ul_BFu1s_I { unsigned long long v1; unsigned short v2:1; int v3; };
struct Ul_BFu1s_Ip { unsigned long long v1; unsigned short v2:1; int * v3; };
struct Ul_BFu1s_L { unsigned long long v1; unsigned short v2:1; long long v3; };
struct Ul_BFu1s_S { unsigned long long v1; unsigned short v2:1; short v3; };
struct Ul_BFu1s_Uc { unsigned long long v1; unsigned short v2:1; unsigned char v3; };
struct Ul_BFu1s_Ui { unsigned long long v1; unsigned short v2:1; unsigned int v3; };
struct Ul_BFu1s_Ul { unsigned long long v1; unsigned short v2:1; unsigned long long v3; };
struct Ul_BFu1s_Us { unsigned long long v1; unsigned short v2:1; unsigned short v3; };
struct Ul_BFu1s_Vp { unsigned long long v1; unsigned short v2:1; void * v3; };
struct Ul_BFu31i { unsigned long long v1; unsigned int v2:31; };
struct Ul_BFu31i_BFu15i { unsigned long long v1; unsigned int v2:31; unsigned int v3:15; };
struct Ul_BFu31i_BFu15ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:15; };
struct Ul_BFu31i_BFu15s { unsigned long long v1; unsigned int v2:31; unsigned short v3:15; };
struct Ul_BFu31i_BFu16i { unsigned long long v1; unsigned int v2:31; unsigned int v3:16; };
struct Ul_BFu31i_BFu16ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:16; };
struct Ul_BFu31i_BFu16s { unsigned long long v1; unsigned int v2:31; unsigned short v3:16; };
struct Ul_BFu31i_BFu17i { unsigned long long v1; unsigned int v2:31; unsigned int v3:17; };
struct Ul_BFu31i_BFu17ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:17; };
struct Ul_BFu31i_BFu1c { unsigned long long v1; unsigned int v2:31; unsigned char v3:1; };
struct Ul_BFu31i_BFu1i { unsigned long long v1; unsigned int v2:31; unsigned int v3:1; };
struct Ul_BFu31i_BFu1ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:1; };
struct Ul_BFu31i_BFu1s { unsigned long long v1; unsigned int v2:31; unsigned short v3:1; };
struct Ul_BFu31i_BFu31i { unsigned long long v1; unsigned int v2:31; unsigned int v3:31; };
struct Ul_BFu31i_BFu31ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:31; };
struct Ul_BFu31i_BFu32i { unsigned long long v1; unsigned int v2:31; unsigned int v3:32; };
struct Ul_BFu31i_BFu32ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:32; };
struct Ul_BFu31i_BFu33 { unsigned long long v1; unsigned int v2:31; unsigned long long v3:33; };
struct Ul_BFu31i_BFu7c { unsigned long long v1; unsigned int v2:31; unsigned char v3:7; };
struct Ul_BFu31i_BFu7i { unsigned long long v1; unsigned int v2:31; unsigned int v3:7; };
struct Ul_BFu31i_BFu7ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:7; };
struct Ul_BFu31i_BFu7s { unsigned long long v1; unsigned int v2:31; unsigned short v3:7; };
struct Ul_BFu31i_BFu8c { unsigned long long v1; unsigned int v2:31; unsigned char v3:8; };
struct Ul_BFu31i_BFu8i { unsigned long long v1; unsigned int v2:31; unsigned int v3:8; };
struct Ul_BFu31i_BFu8ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:8; };
struct Ul_BFu31i_BFu8s { unsigned long long v1; unsigned int v2:31; unsigned short v3:8; };
struct Ul_BFu31i_BFu9i { unsigned long long v1; unsigned int v2:31; unsigned int v3:9; };
struct Ul_BFu31i_BFu9ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:9; };
struct Ul_BFu31i_BFu9s { unsigned long long v1; unsigned int v2:31; unsigned short v3:9; };
struct Ul_BFu31i_C { unsigned long long v1; unsigned int v2:31; char v3; };
struct Ul_BFu31i_D { unsigned long long v1; unsigned int v2:31; double v3; };
struct Ul_BFu31i_F { unsigned long long v1; unsigned int v2:31; float v3; };
struct Ul_BFu31i_I { unsigned long long v1; unsigned int v2:31; int v3; };
struct Ul_BFu31i_Ip { unsigned long long v1; unsigned int v2:31; int * v3; };
struct Ul_BFu31i_L { unsigned long long v1; unsigned int v2:31; long long v3; };
struct Ul_BFu31i_S { unsigned long long v1; unsigned int v2:31; short v3; };
struct Ul_BFu31i_Uc { unsigned long long v1; unsigned int v2:31; unsigned char v3; };
struct Ul_BFu31i_Ui { unsigned long long v1; unsigned int v2:31; unsigned int v3; };
struct Ul_BFu31i_Ul { unsigned long long v1; unsigned int v2:31; unsigned long long v3; };
struct Ul_BFu31i_Us { unsigned long long v1; unsigned int v2:31; unsigned short v3; };
struct Ul_BFu31i_Vp { unsigned long long v1; unsigned int v2:31; void * v3; };
struct Ul_BFu31ll { unsigned long long v1; unsigned long long v2:31; };
struct Ul_BFu31ll_BFu15i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:15; };
struct Ul_BFu31ll_BFu15ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:15; };
struct Ul_BFu31ll_BFu15s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:15; };
struct Ul_BFu31ll_BFu16i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:16; };
struct Ul_BFu31ll_BFu16ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:16; };
struct Ul_BFu31ll_BFu16s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:16; };
struct Ul_BFu31ll_BFu17i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:17; };
struct Ul_BFu31ll_BFu17ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:17; };
struct Ul_BFu31ll_BFu1c { unsigned long long v1; unsigned long long v2:31; unsigned char v3:1; };
struct Ul_BFu31ll_BFu1i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:1; };
struct Ul_BFu31ll_BFu1ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:1; };
struct Ul_BFu31ll_BFu1s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:1; };
struct Ul_BFu31ll_BFu31i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:31; };
struct Ul_BFu31ll_BFu31ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:31; };
struct Ul_BFu31ll_BFu32i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:32; };
struct Ul_BFu31ll_BFu32ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:32; };
struct Ul_BFu31ll_BFu33 { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:33; };
struct Ul_BFu31ll_BFu7c { unsigned long long v1; unsigned long long v2:31; unsigned char v3:7; };
struct Ul_BFu31ll_BFu7i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:7; };
struct Ul_BFu31ll_BFu7ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:7; };
struct Ul_BFu31ll_BFu7s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:7; };
struct Ul_BFu31ll_BFu8c { unsigned long long v1; unsigned long long v2:31; unsigned char v3:8; };
struct Ul_BFu31ll_BFu8i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:8; };
struct Ul_BFu31ll_BFu8ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:8; };
struct Ul_BFu31ll_BFu8s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:8; };
struct Ul_BFu31ll_BFu9i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:9; };
struct Ul_BFu31ll_BFu9ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:9; };
struct Ul_BFu31ll_BFu9s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:9; };
struct Ul_BFu31ll_C { unsigned long long v1; unsigned long long v2:31; char v3; };
struct Ul_BFu31ll_D { unsigned long long v1; unsigned long long v2:31; double v3; };
struct Ul_BFu31ll_F { unsigned long long v1; unsigned long long v2:31; float v3; };
struct Ul_BFu31ll_I { unsigned long long v1; unsigned long long v2:31; int v3; };
struct Ul_BFu31ll_Ip { unsigned long long v1; unsigned long long v2:31; int * v3; };
struct Ul_BFu31ll_L { unsigned long long v1; unsigned long long v2:31; long long v3; };
struct Ul_BFu31ll_S { unsigned long long v1; unsigned long long v2:31; short v3; };
struct Ul_BFu31ll_Uc { unsigned long long v1; unsigned long long v2:31; unsigned char v3; };
struct Ul_BFu31ll_Ui { unsigned long long v1; unsigned long long v2:31; unsigned int v3; };
struct Ul_BFu31ll_Ul { unsigned long long v1; unsigned long long v2:31; unsigned long long v3; };
struct Ul_BFu31ll_Us { unsigned long long v1; unsigned long long v2:31; unsigned short v3; };
struct Ul_BFu31ll_Vp { unsigned long long v1; unsigned long long v2:31; void * v3; };
struct Ul_BFu32i { unsigned long long v1; unsigned int v2:32; };
struct Ul_BFu32i_BFu15i { unsigned long long v1; unsigned int v2:32; unsigned int v3:15; };
struct Ul_BFu32i_BFu15ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:15; };
struct Ul_BFu32i_BFu15s { unsigned long long v1; unsigned int v2:32; unsigned short v3:15; };
struct Ul_BFu32i_BFu16i { unsigned long long v1; unsigned int v2:32; unsigned int v3:16; };
struct Ul_BFu32i_BFu16ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:16; };
struct Ul_BFu32i_BFu16s { unsigned long long v1; unsigned int v2:32; unsigned short v3:16; };
struct Ul_BFu32i_BFu17i { unsigned long long v1; unsigned int v2:32; unsigned int v3:17; };
struct Ul_BFu32i_BFu17ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:17; };
struct Ul_BFu32i_BFu1c { unsigned long long v1; unsigned int v2:32; unsigned char v3:1; };
struct Ul_BFu32i_BFu1i { unsigned long long v1; unsigned int v2:32; unsigned int v3:1; };
struct Ul_BFu32i_BFu1ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:1; };
struct Ul_BFu32i_BFu1s { unsigned long long v1; unsigned int v2:32; unsigned short v3:1; };
struct Ul_BFu32i_BFu31i { unsigned long long v1; unsigned int v2:32; unsigned int v3:31; };
struct Ul_BFu32i_BFu31ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:31; };
struct Ul_BFu32i_BFu32i { unsigned long long v1; unsigned int v2:32; unsigned int v3:32; };
struct Ul_BFu32i_BFu32ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:32; };
struct Ul_BFu32i_BFu33 { unsigned long long v1; unsigned int v2:32; unsigned long long v3:33; };
struct Ul_BFu32i_BFu7c { unsigned long long v1; unsigned int v2:32; unsigned char v3:7; };
struct Ul_BFu32i_BFu7i { unsigned long long v1; unsigned int v2:32; unsigned int v3:7; };
struct Ul_BFu32i_BFu7ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:7; };
struct Ul_BFu32i_BFu7s { unsigned long long v1; unsigned int v2:32; unsigned short v3:7; };
struct Ul_BFu32i_BFu8c { unsigned long long v1; unsigned int v2:32; unsigned char v3:8; };
struct Ul_BFu32i_BFu8i { unsigned long long v1; unsigned int v2:32; unsigned int v3:8; };
struct Ul_BFu32i_BFu8ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:8; };
struct Ul_BFu32i_BFu8s { unsigned long long v1; unsigned int v2:32; unsigned short v3:8; };
struct Ul_BFu32i_BFu9i { unsigned long long v1; unsigned int v2:32; unsigned int v3:9; };
struct Ul_BFu32i_BFu9ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:9; };
struct Ul_BFu32i_BFu9s { unsigned long long v1; unsigned int v2:32; unsigned short v3:9; };
struct Ul_BFu32i_C { unsigned long long v1; unsigned int v2:32; char v3; };
struct Ul_BFu32i_D { unsigned long long v1; unsigned int v2:32; double v3; };
struct Ul_BFu32i_F { unsigned long long v1; unsigned int v2:32; float v3; };
struct Ul_BFu32i_I { unsigned long long v1; unsigned int v2:32; int v3; };
struct Ul_BFu32i_Ip { unsigned long long v1; unsigned int v2:32; int * v3; };
struct Ul_BFu32i_L { unsigned long long v1; unsigned int v2:32; long long v3; };
struct Ul_BFu32i_S { unsigned long long v1; unsigned int v2:32; short v3; };
struct Ul_BFu32i_Uc { unsigned long long v1; unsigned int v2:32; unsigned char v3; };
struct Ul_BFu32i_Ui { unsigned long long v1; unsigned int v2:32; unsigned int v3; };
struct Ul_BFu32i_Ul { unsigned long long v1; unsigned int v2:32; unsigned long long v3; };
struct Ul_BFu32i_Us { unsigned long long v1; unsigned int v2:32; unsigned short v3; };
struct Ul_BFu32i_Vp { unsigned long long v1; unsigned int v2:32; void * v3; };
struct Ul_BFu32ll { unsigned long long v1; unsigned long long v2:32; };
struct Ul_BFu32ll_BFu15i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:15; };
struct Ul_BFu32ll_BFu15ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:15; };
struct Ul_BFu32ll_BFu15s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:15; };
struct Ul_BFu32ll_BFu16i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:16; };
struct Ul_BFu32ll_BFu16ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:16; };
struct Ul_BFu32ll_BFu16s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:16; };
struct Ul_BFu32ll_BFu17i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:17; };
struct Ul_BFu32ll_BFu17ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:17; };
struct Ul_BFu32ll_BFu1c { unsigned long long v1; unsigned long long v2:32; unsigned char v3:1; };
struct Ul_BFu32ll_BFu1i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:1; };
struct Ul_BFu32ll_BFu1ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:1; };
struct Ul_BFu32ll_BFu1s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:1; };
struct Ul_BFu32ll_BFu31i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:31; };
struct Ul_BFu32ll_BFu31ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:31; };
struct Ul_BFu32ll_BFu32i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:32; };
struct Ul_BFu32ll_BFu32ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:32; };
struct Ul_BFu32ll_BFu33 { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:33; };
struct Ul_BFu32ll_BFu7c { unsigned long long v1; unsigned long long v2:32; unsigned char v3:7; };
struct Ul_BFu32ll_BFu7i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:7; };
struct Ul_BFu32ll_BFu7ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:7; };
struct Ul_BFu32ll_BFu7s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:7; };
struct Ul_BFu32ll_BFu8c { unsigned long long v1; unsigned long long v2:32; unsigned char v3:8; };
struct Ul_BFu32ll_BFu8i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:8; };
struct Ul_BFu32ll_BFu8ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:8; };
struct Ul_BFu32ll_BFu8s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:8; };
struct Ul_BFu32ll_BFu9i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:9; };
struct Ul_BFu32ll_BFu9ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:9; };
struct Ul_BFu32ll_BFu9s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:9; };
struct Ul_BFu32ll_C { unsigned long long v1; unsigned long long v2:32; char v3; };
struct Ul_BFu32ll_D { unsigned long long v1; unsigned long long v2:32; double v3; };
struct Ul_BFu32ll_F { unsigned long long v1; unsigned long long v2:32; float v3; };
struct Ul_BFu32ll_I { unsigned long long v1; unsigned long long v2:32; int v3; };
struct Ul_BFu32ll_Ip { unsigned long long v1; unsigned long long v2:32; int * v3; };
struct Ul_BFu32ll_L { unsigned long long v1; unsigned long long v2:32; long long v3; };
struct Ul_BFu32ll_S { unsigned long long v1; unsigned long long v2:32; short v3; };
struct Ul_BFu32ll_Uc { unsigned long long v1; unsigned long long v2:32; unsigned char v3; };
struct Ul_BFu32ll_Ui { unsigned long long v1; unsigned long long v2:32; unsigned int v3; };
struct Ul_BFu32ll_Ul { unsigned long long v1; unsigned long long v2:32; unsigned long long v3; };
struct Ul_BFu32ll_Us { unsigned long long v1; unsigned long long v2:32; unsigned short v3; };
struct Ul_BFu32ll_Vp { unsigned long long v1; unsigned long long v2:32; void * v3; };
struct Ul_BFu33 { unsigned long long v1; unsigned long long v2:33; };
struct Ul_BFu33_BFu15i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:15; };
struct Ul_BFu33_BFu15ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:15; };
struct Ul_BFu33_BFu15s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:15; };
struct Ul_BFu33_BFu16i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:16; };
struct Ul_BFu33_BFu16ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:16; };
struct Ul_BFu33_BFu16s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:16; };
struct Ul_BFu33_BFu17i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:17; };
struct Ul_BFu33_BFu17ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:17; };
struct Ul_BFu33_BFu1c { unsigned long long v1; unsigned long long v2:33; unsigned char v3:1; };
struct Ul_BFu33_BFu1i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:1; };
struct Ul_BFu33_BFu1ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:1; };
struct Ul_BFu33_BFu1s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:1; };
struct Ul_BFu33_BFu31i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:31; };
struct Ul_BFu33_BFu31ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:31; };
struct Ul_BFu33_BFu32i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:32; };
struct Ul_BFu33_BFu32ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:32; };
struct Ul_BFu33_BFu33 { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:33; };
struct Ul_BFu33_BFu7c { unsigned long long v1; unsigned long long v2:33; unsigned char v3:7; };
struct Ul_BFu33_BFu7i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:7; };
struct Ul_BFu33_BFu7ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:7; };
struct Ul_BFu33_BFu7s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:7; };
struct Ul_BFu33_BFu8c { unsigned long long v1; unsigned long long v2:33; unsigned char v3:8; };
struct Ul_BFu33_BFu8i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:8; };
struct Ul_BFu33_BFu8ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:8; };
struct Ul_BFu33_BFu8s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:8; };
struct Ul_BFu33_BFu9i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:9; };
struct Ul_BFu33_BFu9ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:9; };
struct Ul_BFu33_BFu9s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:9; };
struct Ul_BFu33_C { unsigned long long v1; unsigned long long v2:33; char v3; };
struct Ul_BFu33_D { unsigned long long v1; unsigned long long v2:33; double v3; };
struct Ul_BFu33_F { unsigned long long v1; unsigned long long v2:33; float v3; };
struct Ul_BFu33_I { unsigned long long v1; unsigned long long v2:33; int v3; };
struct Ul_BFu33_Ip { unsigned long long v1; unsigned long long v2:33; int * v3; };
struct Ul_BFu33_L { unsigned long long v1; unsigned long long v2:33; long long v3; };
struct Ul_BFu33_S { unsigned long long v1; unsigned long long v2:33; short v3; };
struct Ul_BFu33_Uc { unsigned long long v1; unsigned long long v2:33; unsigned char v3; };
struct Ul_BFu33_Ui { unsigned long long v1; unsigned long long v2:33; unsigned int v3; };
struct Ul_BFu33_Ul { unsigned long long v1; unsigned long long v2:33; unsigned long long v3; };
struct Ul_BFu33_Us { unsigned long long v1; unsigned long long v2:33; unsigned short v3; };
struct Ul_BFu33_Vp { unsigned long long v1; unsigned long long v2:33; void * v3; };
struct Ul_BFu7c { unsigned long long v1; unsigned char v2:7; };
struct Ul_BFu7c_BFu15i { unsigned long long v1; unsigned char v2:7; unsigned int v3:15; };
struct Ul_BFu7c_BFu15ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:15; };
struct Ul_BFu7c_BFu15s { unsigned long long v1; unsigned char v2:7; unsigned short v3:15; };
struct Ul_BFu7c_BFu16i { unsigned long long v1; unsigned char v2:7; unsigned int v3:16; };
struct Ul_BFu7c_BFu16ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:16; };
struct Ul_BFu7c_BFu16s { unsigned long long v1; unsigned char v2:7; unsigned short v3:16; };
struct Ul_BFu7c_BFu17i { unsigned long long v1; unsigned char v2:7; unsigned int v3:17; };
struct Ul_BFu7c_BFu17ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:17; };
struct Ul_BFu7c_BFu1c { unsigned long long v1; unsigned char v2:7; unsigned char v3:1; };
struct Ul_BFu7c_BFu1i { unsigned long long v1; unsigned char v2:7; unsigned int v3:1; };
struct Ul_BFu7c_BFu1ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:1; };
struct Ul_BFu7c_BFu1s { unsigned long long v1; unsigned char v2:7; unsigned short v3:1; };
struct Ul_BFu7c_BFu31i { unsigned long long v1; unsigned char v2:7; unsigned int v3:31; };
struct Ul_BFu7c_BFu31ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:31; };
struct Ul_BFu7c_BFu32i { unsigned long long v1; unsigned char v2:7; unsigned int v3:32; };
struct Ul_BFu7c_BFu32ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:32; };
struct Ul_BFu7c_BFu33 { unsigned long long v1; unsigned char v2:7; unsigned long long v3:33; };
struct Ul_BFu7c_BFu7c { unsigned long long v1; unsigned char v2:7; unsigned char v3:7; };
struct Ul_BFu7c_BFu7i { unsigned long long v1; unsigned char v2:7; unsigned int v3:7; };
struct Ul_BFu7c_BFu7ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:7; };
struct Ul_BFu7c_BFu7s { unsigned long long v1; unsigned char v2:7; unsigned short v3:7; };
struct Ul_BFu7c_BFu8c { unsigned long long v1; unsigned char v2:7; unsigned char v3:8; };
struct Ul_BFu7c_BFu8i { unsigned long long v1; unsigned char v2:7; unsigned int v3:8; };
struct Ul_BFu7c_BFu8ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:8; };
struct Ul_BFu7c_BFu8s { unsigned long long v1; unsigned char v2:7; unsigned short v3:8; };
struct Ul_BFu7c_BFu9i { unsigned long long v1; unsigned char v2:7; unsigned int v3:9; };
struct Ul_BFu7c_BFu9ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:9; };
struct Ul_BFu7c_BFu9s { unsigned long long v1; unsigned char v2:7; unsigned short v3:9; };
struct Ul_BFu7c_C { unsigned long long v1; unsigned char v2:7; char v3; };
struct Ul_BFu7c_D { unsigned long long v1; unsigned char v2:7; double v3; };
struct Ul_BFu7c_F { unsigned long long v1; unsigned char v2:7; float v3; };
struct Ul_BFu7c_I { unsigned long long v1; unsigned char v2:7; int v3; };
struct Ul_BFu7c_Ip { unsigned long long v1; unsigned char v2:7; int * v3; };
struct Ul_BFu7c_L { unsigned long long v1; unsigned char v2:7; long long v3; };
struct Ul_BFu7c_S { unsigned long long v1; unsigned char v2:7; short v3; };
struct Ul_BFu7c_Uc { unsigned long long v1; unsigned char v2:7; unsigned char v3; };
struct Ul_BFu7c_Ui { unsigned long long v1; unsigned char v2:7; unsigned int v3; };
struct Ul_BFu7c_Ul { unsigned long long v1; unsigned char v2:7; unsigned long long v3; };
struct Ul_BFu7c_Us { unsigned long long v1; unsigned char v2:7; unsigned short v3; };
struct Ul_BFu7c_Vp { unsigned long long v1; unsigned char v2:7; void * v3; };
struct Ul_BFu7i { unsigned long long v1; unsigned int v2:7; };
struct Ul_BFu7i_BFu15i { unsigned long long v1; unsigned int v2:7; unsigned int v3:15; };
struct Ul_BFu7i_BFu15ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:15; };
struct Ul_BFu7i_BFu15s { unsigned long long v1; unsigned int v2:7; unsigned short v3:15; };
struct Ul_BFu7i_BFu16i { unsigned long long v1; unsigned int v2:7; unsigned int v3:16; };
struct Ul_BFu7i_BFu16ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:16; };
struct Ul_BFu7i_BFu16s { unsigned long long v1; unsigned int v2:7; unsigned short v3:16; };
struct Ul_BFu7i_BFu17i { unsigned long long v1; unsigned int v2:7; unsigned int v3:17; };
struct Ul_BFu7i_BFu17ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:17; };
struct Ul_BFu7i_BFu1c { unsigned long long v1; unsigned int v2:7; unsigned char v3:1; };
struct Ul_BFu7i_BFu1i { unsigned long long v1; unsigned int v2:7; unsigned int v3:1; };
struct Ul_BFu7i_BFu1ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:1; };
struct Ul_BFu7i_BFu1s { unsigned long long v1; unsigned int v2:7; unsigned short v3:1; };
struct Ul_BFu7i_BFu31i { unsigned long long v1; unsigned int v2:7; unsigned int v3:31; };
struct Ul_BFu7i_BFu31ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:31; };
struct Ul_BFu7i_BFu32i { unsigned long long v1; unsigned int v2:7; unsigned int v3:32; };
struct Ul_BFu7i_BFu32ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:32; };
struct Ul_BFu7i_BFu33 { unsigned long long v1; unsigned int v2:7; unsigned long long v3:33; };
struct Ul_BFu7i_BFu7c { unsigned long long v1; unsigned int v2:7; unsigned char v3:7; };
struct Ul_BFu7i_BFu7i { unsigned long long v1; unsigned int v2:7; unsigned int v3:7; };
struct Ul_BFu7i_BFu7ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:7; };
struct Ul_BFu7i_BFu7s { unsigned long long v1; unsigned int v2:7; unsigned short v3:7; };
struct Ul_BFu7i_BFu8c { unsigned long long v1; unsigned int v2:7; unsigned char v3:8; };
struct Ul_BFu7i_BFu8i { unsigned long long v1; unsigned int v2:7; unsigned int v3:8; };
struct Ul_BFu7i_BFu8ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:8; };
struct Ul_BFu7i_BFu8s { unsigned long long v1; unsigned int v2:7; unsigned short v3:8; };
struct Ul_BFu7i_BFu9i { unsigned long long v1; unsigned int v2:7; unsigned int v3:9; };
struct Ul_BFu7i_BFu9ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:9; };
struct Ul_BFu7i_BFu9s { unsigned long long v1; unsigned int v2:7; unsigned short v3:9; };
struct Ul_BFu7i_C { unsigned long long v1; unsigned int v2:7; char v3; };
struct Ul_BFu7i_D { unsigned long long v1; unsigned int v2:7; double v3; };
struct Ul_BFu7i_F { unsigned long long v1; unsigned int v2:7; float v3; };
struct Ul_BFu7i_I { unsigned long long v1; unsigned int v2:7; int v3; };
struct Ul_BFu7i_Ip { unsigned long long v1; unsigned int v2:7; int * v3; };
struct Ul_BFu7i_L { unsigned long long v1; unsigned int v2:7; long long v3; };
struct Ul_BFu7i_S { unsigned long long v1; unsigned int v2:7; short v3; };
struct Ul_BFu7i_Uc { unsigned long long v1; unsigned int v2:7; unsigned char v3; };
struct Ul_BFu7i_Ui { unsigned long long v1; unsigned int v2:7; unsigned int v3; };
struct Ul_BFu7i_Ul { unsigned long long v1; unsigned int v2:7; unsigned long long v3; };
struct Ul_BFu7i_Us { unsigned long long v1; unsigned int v2:7; unsigned short v3; };
struct Ul_BFu7i_Vp { unsigned long long v1; unsigned int v2:7; void * v3; };
struct Ul_BFu7ll { unsigned long long v1; unsigned long long v2:7; };
struct Ul_BFu7ll_BFu15i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:15; };
struct Ul_BFu7ll_BFu15ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:15; };
struct Ul_BFu7ll_BFu15s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:15; };
struct Ul_BFu7ll_BFu16i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:16; };
struct Ul_BFu7ll_BFu16ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:16; };
struct Ul_BFu7ll_BFu16s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:16; };
struct Ul_BFu7ll_BFu17i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:17; };
struct Ul_BFu7ll_BFu17ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:17; };
struct Ul_BFu7ll_BFu1c { unsigned long long v1; unsigned long long v2:7; unsigned char v3:1; };
struct Ul_BFu7ll_BFu1i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:1; };
struct Ul_BFu7ll_BFu1ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:1; };
struct Ul_BFu7ll_BFu1s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:1; };
struct Ul_BFu7ll_BFu31i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:31; };
struct Ul_BFu7ll_BFu31ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:31; };
struct Ul_BFu7ll_BFu32i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:32; };
struct Ul_BFu7ll_BFu32ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:32; };
struct Ul_BFu7ll_BFu33 { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:33; };
struct Ul_BFu7ll_BFu7c { unsigned long long v1; unsigned long long v2:7; unsigned char v3:7; };
struct Ul_BFu7ll_BFu7i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:7; };
struct Ul_BFu7ll_BFu7ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:7; };
struct Ul_BFu7ll_BFu7s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:7; };
struct Ul_BFu7ll_BFu8c { unsigned long long v1; unsigned long long v2:7; unsigned char v3:8; };
struct Ul_BFu7ll_BFu8i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:8; };
struct Ul_BFu7ll_BFu8ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:8; };
struct Ul_BFu7ll_BFu8s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:8; };
struct Ul_BFu7ll_BFu9i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:9; };
struct Ul_BFu7ll_BFu9ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:9; };
struct Ul_BFu7ll_BFu9s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:9; };
struct Ul_BFu7ll_C { unsigned long long v1; unsigned long long v2:7; char v3; };
struct Ul_BFu7ll_D { unsigned long long v1; unsigned long long v2:7; double v3; };
struct Ul_BFu7ll_F { unsigned long long v1; unsigned long long v2:7; float v3; };
struct Ul_BFu7ll_I { unsigned long long v1; unsigned long long v2:7; int v3; };
struct Ul_BFu7ll_Ip { unsigned long long v1; unsigned long long v2:7; int * v3; };
struct Ul_BFu7ll_L { unsigned long long v1; unsigned long long v2:7; long long v3; };
struct Ul_BFu7ll_S { unsigned long long v1; unsigned long long v2:7; short v3; };
struct Ul_BFu7ll_Uc { unsigned long long v1; unsigned long long v2:7; unsigned char v3; };
struct Ul_BFu7ll_Ui { unsigned long long v1; unsigned long long v2:7; unsigned int v3; };
struct Ul_BFu7ll_Ul { unsigned long long v1; unsigned long long v2:7; unsigned long long v3; };
struct Ul_BFu7ll_Us { unsigned long long v1; unsigned long long v2:7; unsigned short v3; };
struct Ul_BFu7ll_Vp { unsigned long long v1; unsigned long long v2:7; void * v3; };
struct Ul_BFu7s { unsigned long long v1; unsigned short v2:7; };
struct Ul_BFu7s_BFu15i { unsigned long long v1; unsigned short v2:7; unsigned int v3:15; };
struct Ul_BFu7s_BFu15ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:15; };
struct Ul_BFu7s_BFu15s { unsigned long long v1; unsigned short v2:7; unsigned short v3:15; };
struct Ul_BFu7s_BFu16i { unsigned long long v1; unsigned short v2:7; unsigned int v3:16; };
struct Ul_BFu7s_BFu16ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:16; };
struct Ul_BFu7s_BFu16s { unsigned long long v1; unsigned short v2:7; unsigned short v3:16; };
struct Ul_BFu7s_BFu17i { unsigned long long v1; unsigned short v2:7; unsigned int v3:17; };
struct Ul_BFu7s_BFu17ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:17; };
struct Ul_BFu7s_BFu1c { unsigned long long v1; unsigned short v2:7; unsigned char v3:1; };
struct Ul_BFu7s_BFu1i { unsigned long long v1; unsigned short v2:7; unsigned int v3:1; };
struct Ul_BFu7s_BFu1ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:1; };
struct Ul_BFu7s_BFu1s { unsigned long long v1; unsigned short v2:7; unsigned short v3:1; };
struct Ul_BFu7s_BFu31i { unsigned long long v1; unsigned short v2:7; unsigned int v3:31; };
struct Ul_BFu7s_BFu31ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:31; };
struct Ul_BFu7s_BFu32i { unsigned long long v1; unsigned short v2:7; unsigned int v3:32; };
struct Ul_BFu7s_BFu32ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:32; };
struct Ul_BFu7s_BFu33 { unsigned long long v1; unsigned short v2:7; unsigned long long v3:33; };
struct Ul_BFu7s_BFu7c { unsigned long long v1; unsigned short v2:7; unsigned char v3:7; };
struct Ul_BFu7s_BFu7i { unsigned long long v1; unsigned short v2:7; unsigned int v3:7; };
struct Ul_BFu7s_BFu7ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:7; };
struct Ul_BFu7s_BFu7s { unsigned long long v1; unsigned short v2:7; unsigned short v3:7; };
struct Ul_BFu7s_BFu8c { unsigned long long v1; unsigned short v2:7; unsigned char v3:8; };
struct Ul_BFu7s_BFu8i { unsigned long long v1; unsigned short v2:7; unsigned int v3:8; };
struct Ul_BFu7s_BFu8ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:8; };
struct Ul_BFu7s_BFu8s { unsigned long long v1; unsigned short v2:7; unsigned short v3:8; };
struct Ul_BFu7s_BFu9i { unsigned long long v1; unsigned short v2:7; unsigned int v3:9; };
struct Ul_BFu7s_BFu9ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:9; };
struct Ul_BFu7s_BFu9s { unsigned long long v1; unsigned short v2:7; unsigned short v3:9; };
struct Ul_BFu7s_C { unsigned long long v1; unsigned short v2:7; char v3; };
struct Ul_BFu7s_D { unsigned long long v1; unsigned short v2:7; double v3; };
struct Ul_BFu7s_F { unsigned long long v1; unsigned short v2:7; float v3; };
struct Ul_BFu7s_I { unsigned long long v1; unsigned short v2:7; int v3; };
struct Ul_BFu7s_Ip { unsigned long long v1; unsigned short v2:7; int * v3; };
struct Ul_BFu7s_L { unsigned long long v1; unsigned short v2:7; long long v3; };
struct Ul_BFu7s_S { unsigned long long v1; unsigned short v2:7; short v3; };
struct Ul_BFu7s_Uc { unsigned long long v1; unsigned short v2:7; unsigned char v3; };
struct Ul_BFu7s_Ui { unsigned long long v1; unsigned short v2:7; unsigned int v3; };
struct Ul_BFu7s_Ul { unsigned long long v1; unsigned short v2:7; unsigned long long v3; };
struct Ul_BFu7s_Us { unsigned long long v1; unsigned short v2:7; unsigned short v3; };
struct Ul_BFu7s_Vp { unsigned long long v1; unsigned short v2:7; void * v3; };
struct Ul_BFu8c { unsigned long long v1; unsigned char v2:8; };
struct Ul_BFu8c_BFu15i { unsigned long long v1; unsigned char v2:8; unsigned int v3:15; };
struct Ul_BFu8c_BFu15ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:15; };
struct Ul_BFu8c_BFu15s { unsigned long long v1; unsigned char v2:8; unsigned short v3:15; };
struct Ul_BFu8c_BFu16i { unsigned long long v1; unsigned char v2:8; unsigned int v3:16; };
struct Ul_BFu8c_BFu16ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:16; };
struct Ul_BFu8c_BFu16s { unsigned long long v1; unsigned char v2:8; unsigned short v3:16; };
struct Ul_BFu8c_BFu17i { unsigned long long v1; unsigned char v2:8; unsigned int v3:17; };
struct Ul_BFu8c_BFu17ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:17; };
struct Ul_BFu8c_BFu1c { unsigned long long v1; unsigned char v2:8; unsigned char v3:1; };
struct Ul_BFu8c_BFu1i { unsigned long long v1; unsigned char v2:8; unsigned int v3:1; };
struct Ul_BFu8c_BFu1ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:1; };
struct Ul_BFu8c_BFu1s { unsigned long long v1; unsigned char v2:8; unsigned short v3:1; };
struct Ul_BFu8c_BFu31i { unsigned long long v1; unsigned char v2:8; unsigned int v3:31; };
struct Ul_BFu8c_BFu31ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:31; };
struct Ul_BFu8c_BFu32i { unsigned long long v1; unsigned char v2:8; unsigned int v3:32; };
struct Ul_BFu8c_BFu32ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:32; };
struct Ul_BFu8c_BFu33 { unsigned long long v1; unsigned char v2:8; unsigned long long v3:33; };
struct Ul_BFu8c_BFu7c { unsigned long long v1; unsigned char v2:8; unsigned char v3:7; };
struct Ul_BFu8c_BFu7i { unsigned long long v1; unsigned char v2:8; unsigned int v3:7; };
struct Ul_BFu8c_BFu7ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:7; };
struct Ul_BFu8c_BFu7s { unsigned long long v1; unsigned char v2:8; unsigned short v3:7; };
struct Ul_BFu8c_BFu8c { unsigned long long v1; unsigned char v2:8; unsigned char v3:8; };
struct Ul_BFu8c_BFu8i { unsigned long long v1; unsigned char v2:8; unsigned int v3:8; };
struct Ul_BFu8c_BFu8ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:8; };
struct Ul_BFu8c_BFu8s { unsigned long long v1; unsigned char v2:8; unsigned short v3:8; };
struct Ul_BFu8c_BFu9i { unsigned long long v1; unsigned char v2:8; unsigned int v3:9; };
struct Ul_BFu8c_BFu9ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:9; };
struct Ul_BFu8c_BFu9s { unsigned long long v1; unsigned char v2:8; unsigned short v3:9; };
struct Ul_BFu8c_C { unsigned long long v1; unsigned char v2:8; char v3; };
struct Ul_BFu8c_D { unsigned long long v1; unsigned char v2:8; double v3; };
struct Ul_BFu8c_F { unsigned long long v1; unsigned char v2:8; float v3; };
struct Ul_BFu8c_I { unsigned long long v1; unsigned char v2:8; int v3; };
struct Ul_BFu8c_Ip { unsigned long long v1; unsigned char v2:8; int * v3; };
struct Ul_BFu8c_L { unsigned long long v1; unsigned char v2:8; long long v3; };
struct Ul_BFu8c_S { unsigned long long v1; unsigned char v2:8; short v3; };
struct Ul_BFu8c_Uc { unsigned long long v1; unsigned char v2:8; unsigned char v3; };
struct Ul_BFu8c_Ui { unsigned long long v1; unsigned char v2:8; unsigned int v3; };
struct Ul_BFu8c_Ul { unsigned long long v1; unsigned char v2:8; unsigned long long v3; };
struct Ul_BFu8c_Us { unsigned long long v1; unsigned char v2:8; unsigned short v3; };
struct Ul_BFu8c_Vp { unsigned long long v1; unsigned char v2:8; void * v3; };
struct Ul_BFu8i { unsigned long long v1; unsigned int v2:8; };
struct Ul_BFu8i_BFu15i { unsigned long long v1; unsigned int v2:8; unsigned int v3:15; };
struct Ul_BFu8i_BFu15ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:15; };
struct Ul_BFu8i_BFu15s { unsigned long long v1; unsigned int v2:8; unsigned short v3:15; };
struct Ul_BFu8i_BFu16i { unsigned long long v1; unsigned int v2:8; unsigned int v3:16; };
struct Ul_BFu8i_BFu16ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:16; };
struct Ul_BFu8i_BFu16s { unsigned long long v1; unsigned int v2:8; unsigned short v3:16; };
struct Ul_BFu8i_BFu17i { unsigned long long v1; unsigned int v2:8; unsigned int v3:17; };
struct Ul_BFu8i_BFu17ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:17; };
struct Ul_BFu8i_BFu1c { unsigned long long v1; unsigned int v2:8; unsigned char v3:1; };
struct Ul_BFu8i_BFu1i { unsigned long long v1; unsigned int v2:8; unsigned int v3:1; };
struct Ul_BFu8i_BFu1ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:1; };
struct Ul_BFu8i_BFu1s { unsigned long long v1; unsigned int v2:8; unsigned short v3:1; };
struct Ul_BFu8i_BFu31i { unsigned long long v1; unsigned int v2:8; unsigned int v3:31; };
struct Ul_BFu8i_BFu31ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:31; };
struct Ul_BFu8i_BFu32i { unsigned long long v1; unsigned int v2:8; unsigned int v3:32; };
struct Ul_BFu8i_BFu32ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:32; };
struct Ul_BFu8i_BFu33 { unsigned long long v1; unsigned int v2:8; unsigned long long v3:33; };
struct Ul_BFu8i_BFu7c { unsigned long long v1; unsigned int v2:8; unsigned char v3:7; };
struct Ul_BFu8i_BFu7i { unsigned long long v1; unsigned int v2:8; unsigned int v3:7; };
struct Ul_BFu8i_BFu7ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:7; };
struct Ul_BFu8i_BFu7s { unsigned long long v1; unsigned int v2:8; unsigned short v3:7; };
struct Ul_BFu8i_BFu8c { unsigned long long v1; unsigned int v2:8; unsigned char v3:8; };
struct Ul_BFu8i_BFu8i { unsigned long long v1; unsigned int v2:8; unsigned int v3:8; };
struct Ul_BFu8i_BFu8ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:8; };
struct Ul_BFu8i_BFu8s { unsigned long long v1; unsigned int v2:8; unsigned short v3:8; };
struct Ul_BFu8i_BFu9i { unsigned long long v1; unsigned int v2:8; unsigned int v3:9; };
struct Ul_BFu8i_BFu9ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:9; };
struct Ul_BFu8i_BFu9s { unsigned long long v1; unsigned int v2:8; unsigned short v3:9; };
struct Ul_BFu8i_C { unsigned long long v1; unsigned int v2:8; char v3; };
struct Ul_BFu8i_D { unsigned long long v1; unsigned int v2:8; double v3; };
struct Ul_BFu8i_F { unsigned long long v1; unsigned int v2:8; float v3; };
struct Ul_BFu8i_I { unsigned long long v1; unsigned int v2:8; int v3; };
struct Ul_BFu8i_Ip { unsigned long long v1; unsigned int v2:8; int * v3; };
struct Ul_BFu8i_L { unsigned long long v1; unsigned int v2:8; long long v3; };
struct Ul_BFu8i_S { unsigned long long v1; unsigned int v2:8; short v3; };
struct Ul_BFu8i_Uc { unsigned long long v1; unsigned int v2:8; unsigned char v3; };
struct Ul_BFu8i_Ui { unsigned long long v1; unsigned int v2:8; unsigned int v3; };
struct Ul_BFu8i_Ul { unsigned long long v1; unsigned int v2:8; unsigned long long v3; };
struct Ul_BFu8i_Us { unsigned long long v1; unsigned int v2:8; unsigned short v3; };
struct Ul_BFu8i_Vp { unsigned long long v1; unsigned int v2:8; void * v3; };
struct Ul_BFu8ll { unsigned long long v1; unsigned long long v2:8; };
struct Ul_BFu8ll_BFu15i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:15; };
struct Ul_BFu8ll_BFu15ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:15; };
struct Ul_BFu8ll_BFu15s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:15; };
struct Ul_BFu8ll_BFu16i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:16; };
struct Ul_BFu8ll_BFu16ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:16; };
struct Ul_BFu8ll_BFu16s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:16; };
struct Ul_BFu8ll_BFu17i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:17; };
struct Ul_BFu8ll_BFu17ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:17; };
struct Ul_BFu8ll_BFu1c { unsigned long long v1; unsigned long long v2:8; unsigned char v3:1; };
struct Ul_BFu8ll_BFu1i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:1; };
struct Ul_BFu8ll_BFu1ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:1; };
struct Ul_BFu8ll_BFu1s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:1; };
struct Ul_BFu8ll_BFu31i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:31; };
struct Ul_BFu8ll_BFu31ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:31; };
struct Ul_BFu8ll_BFu32i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:32; };
struct Ul_BFu8ll_BFu32ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:32; };
struct Ul_BFu8ll_BFu33 { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:33; };
struct Ul_BFu8ll_BFu7c { unsigned long long v1; unsigned long long v2:8; unsigned char v3:7; };
struct Ul_BFu8ll_BFu7i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:7; };
struct Ul_BFu8ll_BFu7ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:7; };
struct Ul_BFu8ll_BFu7s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:7; };
struct Ul_BFu8ll_BFu8c { unsigned long long v1; unsigned long long v2:8; unsigned char v3:8; };
struct Ul_BFu8ll_BFu8i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:8; };
struct Ul_BFu8ll_BFu8ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:8; };
struct Ul_BFu8ll_BFu8s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:8; };
struct Ul_BFu8ll_BFu9i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:9; };
struct Ul_BFu8ll_BFu9ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:9; };
struct Ul_BFu8ll_BFu9s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:9; };
struct Ul_BFu8ll_C { unsigned long long v1; unsigned long long v2:8; char v3; };
struct Ul_BFu8ll_D { unsigned long long v1; unsigned long long v2:8; double v3; };
struct Ul_BFu8ll_F { unsigned long long v1; unsigned long long v2:8; float v3; };
struct Ul_BFu8ll_I { unsigned long long v1; unsigned long long v2:8; int v3; };
struct Ul_BFu8ll_Ip { unsigned long long v1; unsigned long long v2:8; int * v3; };
struct Ul_BFu8ll_L { unsigned long long v1; unsigned long long v2:8; long long v3; };
struct Ul_BFu8ll_S { unsigned long long v1; unsigned long long v2:8; short v3; };
struct Ul_BFu8ll_Uc { unsigned long long v1; unsigned long long v2:8; unsigned char v3; };
struct Ul_BFu8ll_Ui { unsigned long long v1; unsigned long long v2:8; unsigned int v3; };
struct Ul_BFu8ll_Ul { unsigned long long v1; unsigned long long v2:8; unsigned long long v3; };
struct Ul_BFu8ll_Us { unsigned long long v1; unsigned long long v2:8; unsigned short v3; };
struct Ul_BFu8ll_Vp { unsigned long long v1; unsigned long long v2:8; void * v3; };
struct Ul_BFu8s { unsigned long long v1; unsigned short v2:8; };
struct Ul_BFu8s_BFu15i { unsigned long long v1; unsigned short v2:8; unsigned int v3:15; };
struct Ul_BFu8s_BFu15ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:15; };
struct Ul_BFu8s_BFu15s { unsigned long long v1; unsigned short v2:8; unsigned short v3:15; };
struct Ul_BFu8s_BFu16i { unsigned long long v1; unsigned short v2:8; unsigned int v3:16; };
struct Ul_BFu8s_BFu16ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:16; };
struct Ul_BFu8s_BFu16s { unsigned long long v1; unsigned short v2:8; unsigned short v3:16; };
struct Ul_BFu8s_BFu17i { unsigned long long v1; unsigned short v2:8; unsigned int v3:17; };
struct Ul_BFu8s_BFu17ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:17; };
struct Ul_BFu8s_BFu1c { unsigned long long v1; unsigned short v2:8; unsigned char v3:1; };
struct Ul_BFu8s_BFu1i { unsigned long long v1; unsigned short v2:8; unsigned int v3:1; };
struct Ul_BFu8s_BFu1ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:1; };
struct Ul_BFu8s_BFu1s { unsigned long long v1; unsigned short v2:8; unsigned short v3:1; };
struct Ul_BFu8s_BFu31i { unsigned long long v1; unsigned short v2:8; unsigned int v3:31; };
struct Ul_BFu8s_BFu31ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:31; };
struct Ul_BFu8s_BFu32i { unsigned long long v1; unsigned short v2:8; unsigned int v3:32; };
struct Ul_BFu8s_BFu32ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:32; };
struct Ul_BFu8s_BFu33 { unsigned long long v1; unsigned short v2:8; unsigned long long v3:33; };
struct Ul_BFu8s_BFu7c { unsigned long long v1; unsigned short v2:8; unsigned char v3:7; };
struct Ul_BFu8s_BFu7i { unsigned long long v1; unsigned short v2:8; unsigned int v3:7; };
struct Ul_BFu8s_BFu7ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:7; };
struct Ul_BFu8s_BFu7s { unsigned long long v1; unsigned short v2:8; unsigned short v3:7; };
struct Ul_BFu8s_BFu8c { unsigned long long v1; unsigned short v2:8; unsigned char v3:8; };
struct Ul_BFu8s_BFu8i { unsigned long long v1; unsigned short v2:8; unsigned int v3:8; };
struct Ul_BFu8s_BFu8ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:8; };
struct Ul_BFu8s_BFu8s { unsigned long long v1; unsigned short v2:8; unsigned short v3:8; };
struct Ul_BFu8s_BFu9i { unsigned long long v1; unsigned short v2:8; unsigned int v3:9; };
struct Ul_BFu8s_BFu9ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:9; };
struct Ul_BFu8s_BFu9s { unsigned long long v1; unsigned short v2:8; unsigned short v3:9; };
struct Ul_BFu8s_C { unsigned long long v1; unsigned short v2:8; char v3; };
struct Ul_BFu8s_D { unsigned long long v1; unsigned short v2:8; double v3; };
struct Ul_BFu8s_F { unsigned long long v1; unsigned short v2:8; float v3; };
struct Ul_BFu8s_I { unsigned long long v1; unsigned short v2:8; int v3; };
struct Ul_BFu8s_Ip { unsigned long long v1; unsigned short v2:8; int * v3; };
struct Ul_BFu8s_L { unsigned long long v1; unsigned short v2:8; long long v3; };
struct Ul_BFu8s_S { unsigned long long v1; unsigned short v2:8; short v3; };
struct Ul_BFu8s_Uc { unsigned long long v1; unsigned short v2:8; unsigned char v3; };
struct Ul_BFu8s_Ui { unsigned long long v1; unsigned short v2:8; unsigned int v3; };
struct Ul_BFu8s_Ul { unsigned long long v1; unsigned short v2:8; unsigned long long v3; };
struct Ul_BFu8s_Us { unsigned long long v1; unsigned short v2:8; unsigned short v3; };
struct Ul_BFu8s_Vp { unsigned long long v1; unsigned short v2:8; void * v3; };
struct Ul_BFu9i { unsigned long long v1; unsigned int v2:9; };
struct Ul_BFu9i_BFu15i { unsigned long long v1; unsigned int v2:9; unsigned int v3:15; };
struct Ul_BFu9i_BFu15ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:15; };
struct Ul_BFu9i_BFu15s { unsigned long long v1; unsigned int v2:9; unsigned short v3:15; };
struct Ul_BFu9i_BFu16i { unsigned long long v1; unsigned int v2:9; unsigned int v3:16; };
struct Ul_BFu9i_BFu16ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:16; };
struct Ul_BFu9i_BFu16s { unsigned long long v1; unsigned int v2:9; unsigned short v3:16; };
struct Ul_BFu9i_BFu17i { unsigned long long v1; unsigned int v2:9; unsigned int v3:17; };
struct Ul_BFu9i_BFu17ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:17; };
struct Ul_BFu9i_BFu1c { unsigned long long v1; unsigned int v2:9; unsigned char v3:1; };
struct Ul_BFu9i_BFu1i { unsigned long long v1; unsigned int v2:9; unsigned int v3:1; };
struct Ul_BFu9i_BFu1ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:1; };
struct Ul_BFu9i_BFu1s { unsigned long long v1; unsigned int v2:9; unsigned short v3:1; };
struct Ul_BFu9i_BFu31i { unsigned long long v1; unsigned int v2:9; unsigned int v3:31; };
struct Ul_BFu9i_BFu31ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:31; };
struct Ul_BFu9i_BFu32i { unsigned long long v1; unsigned int v2:9; unsigned int v3:32; };
struct Ul_BFu9i_BFu32ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:32; };
struct Ul_BFu9i_BFu33 { unsigned long long v1; unsigned int v2:9; unsigned long long v3:33; };
struct Ul_BFu9i_BFu7c { unsigned long long v1; unsigned int v2:9; unsigned char v3:7; };
struct Ul_BFu9i_BFu7i { unsigned long long v1; unsigned int v2:9; unsigned int v3:7; };
struct Ul_BFu9i_BFu7ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:7; };
struct Ul_BFu9i_BFu7s { unsigned long long v1; unsigned int v2:9; unsigned short v3:7; };
struct Ul_BFu9i_BFu8c { unsigned long long v1; unsigned int v2:9; unsigned char v3:8; };
struct Ul_BFu9i_BFu8i { unsigned long long v1; unsigned int v2:9; unsigned int v3:8; };
struct Ul_BFu9i_BFu8ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:8; };
struct Ul_BFu9i_BFu8s { unsigned long long v1; unsigned int v2:9; unsigned short v3:8; };
struct Ul_BFu9i_BFu9i { unsigned long long v1; unsigned int v2:9; unsigned int v3:9; };
struct Ul_BFu9i_BFu9ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:9; };
struct Ul_BFu9i_BFu9s { unsigned long long v1; unsigned int v2:9; unsigned short v3:9; };
struct Ul_BFu9i_C { unsigned long long v1; unsigned int v2:9; char v3; };
struct Ul_BFu9i_D { unsigned long long v1; unsigned int v2:9; double v3; };
struct Ul_BFu9i_F { unsigned long long v1; unsigned int v2:9; float v3; };
struct Ul_BFu9i_I { unsigned long long v1; unsigned int v2:9; int v3; };
struct Ul_BFu9i_Ip { unsigned long long v1; unsigned int v2:9; int * v3; };
struct Ul_BFu9i_L { unsigned long long v1; unsigned int v2:9; long long v3; };
struct Ul_BFu9i_S { unsigned long long v1; unsigned int v2:9; short v3; };
struct Ul_BFu9i_Uc { unsigned long long v1; unsigned int v2:9; unsigned char v3; };
struct Ul_BFu9i_Ui { unsigned long long v1; unsigned int v2:9; unsigned int v3; };
struct Ul_BFu9i_Ul { unsigned long long v1; unsigned int v2:9; unsigned long long v3; };
struct Ul_BFu9i_Us { unsigned long long v1; unsigned int v2:9; unsigned short v3; };
struct Ul_BFu9i_Vp { unsigned long long v1; unsigned int v2:9; void * v3; };
struct Ul_BFu9ll { unsigned long long v1; unsigned long long v2:9; };
struct Ul_BFu9ll_BFu15i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:15; };
struct Ul_BFu9ll_BFu15ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:15; };
struct Ul_BFu9ll_BFu15s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:15; };
struct Ul_BFu9ll_BFu16i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:16; };
struct Ul_BFu9ll_BFu16ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:16; };
struct Ul_BFu9ll_BFu16s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:16; };
struct Ul_BFu9ll_BFu17i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:17; };
struct Ul_BFu9ll_BFu17ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:17; };
struct Ul_BFu9ll_BFu1c { unsigned long long v1; unsigned long long v2:9; unsigned char v3:1; };
struct Ul_BFu9ll_BFu1i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:1; };
struct Ul_BFu9ll_BFu1ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:1; };
struct Ul_BFu9ll_BFu1s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:1; };
struct Ul_BFu9ll_BFu31i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:31; };
struct Ul_BFu9ll_BFu31ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:31; };
struct Ul_BFu9ll_BFu32i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:32; };
struct Ul_BFu9ll_BFu32ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:32; };
struct Ul_BFu9ll_BFu33 { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:33; };
struct Ul_BFu9ll_BFu7c { unsigned long long v1; unsigned long long v2:9; unsigned char v3:7; };
struct Ul_BFu9ll_BFu7i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:7; };
struct Ul_BFu9ll_BFu7ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:7; };
struct Ul_BFu9ll_BFu7s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:7; };
struct Ul_BFu9ll_BFu8c { unsigned long long v1; unsigned long long v2:9; unsigned char v3:8; };
struct Ul_BFu9ll_BFu8i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:8; };
struct Ul_BFu9ll_BFu8ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:8; };
struct Ul_BFu9ll_BFu8s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:8; };
struct Ul_BFu9ll_BFu9i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:9; };
struct Ul_BFu9ll_BFu9ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:9; };
struct Ul_BFu9ll_BFu9s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:9; };
struct Ul_BFu9ll_C { unsigned long long v1; unsigned long long v2:9; char v3; };
struct Ul_BFu9ll_D { unsigned long long v1; unsigned long long v2:9; double v3; };
struct Ul_BFu9ll_F { unsigned long long v1; unsigned long long v2:9; float v3; };
struct Ul_BFu9ll_I { unsigned long long v1; unsigned long long v2:9; int v3; };
struct Ul_BFu9ll_Ip { unsigned long long v1; unsigned long long v2:9; int * v3; };
struct Ul_BFu9ll_L { unsigned long long v1; unsigned long long v2:9; long long v3; };
struct Ul_BFu9ll_S { unsigned long long v1; unsigned long long v2:9; short v3; };
struct Ul_BFu9ll_Uc { unsigned long long v1; unsigned long long v2:9; unsigned char v3; };
struct Ul_BFu9ll_Ui { unsigned long long v1; unsigned long long v2:9; unsigned int v3; };
struct Ul_BFu9ll_Ul { unsigned long long v1; unsigned long long v2:9; unsigned long long v3; };
struct Ul_BFu9ll_Us { unsigned long long v1; unsigned long long v2:9; unsigned short v3; };
struct Ul_BFu9ll_Vp { unsigned long long v1; unsigned long long v2:9; void * v3; };
struct Ul_BFu9s { unsigned long long v1; unsigned short v2:9; };
struct Ul_BFu9s_BFu15i { unsigned long long v1; unsigned short v2:9; unsigned int v3:15; };
struct Ul_BFu9s_BFu15ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:15; };
struct Ul_BFu9s_BFu15s { unsigned long long v1; unsigned short v2:9; unsigned short v3:15; };
struct Ul_BFu9s_BFu16i { unsigned long long v1; unsigned short v2:9; unsigned int v3:16; };
struct Ul_BFu9s_BFu16ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:16; };
struct Ul_BFu9s_BFu16s { unsigned long long v1; unsigned short v2:9; unsigned short v3:16; };
struct Ul_BFu9s_BFu17i { unsigned long long v1; unsigned short v2:9; unsigned int v3:17; };
struct Ul_BFu9s_BFu17ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:17; };
struct Ul_BFu9s_BFu1c { unsigned long long v1; unsigned short v2:9; unsigned char v3:1; };
struct Ul_BFu9s_BFu1i { unsigned long long v1; unsigned short v2:9; unsigned int v3:1; };
struct Ul_BFu9s_BFu1ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:1; };
struct Ul_BFu9s_BFu1s { unsigned long long v1; unsigned short v2:9; unsigned short v3:1; };
struct Ul_BFu9s_BFu31i { unsigned long long v1; unsigned short v2:9; unsigned int v3:31; };
struct Ul_BFu9s_BFu31ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:31; };
struct Ul_BFu9s_BFu32i { unsigned long long v1; unsigned short v2:9; unsigned int v3:32; };
struct Ul_BFu9s_BFu32ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:32; };
struct Ul_BFu9s_BFu33 { unsigned long long v1; unsigned short v2:9; unsigned long long v3:33; };
struct Ul_BFu9s_BFu7c { unsigned long long v1; unsigned short v2:9; unsigned char v3:7; };
struct Ul_BFu9s_BFu7i { unsigned long long v1; unsigned short v2:9; unsigned int v3:7; };
struct Ul_BFu9s_BFu7ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:7; };
struct Ul_BFu9s_BFu7s { unsigned long long v1; unsigned short v2:9; unsigned short v3:7; };
struct Ul_BFu9s_BFu8c { unsigned long long v1; unsigned short v2:9; unsigned char v3:8; };
struct Ul_BFu9s_BFu8i { unsigned long long v1; unsigned short v2:9; unsigned int v3:8; };
struct Ul_BFu9s_BFu8ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:8; };
struct Ul_BFu9s_BFu8s { unsigned long long v1; unsigned short v2:9; unsigned short v3:8; };
struct Ul_BFu9s_BFu9i { unsigned long long v1; unsigned short v2:9; unsigned int v3:9; };
struct Ul_BFu9s_BFu9ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:9; };
struct Ul_BFu9s_BFu9s { unsigned long long v1; unsigned short v2:9; unsigned short v3:9; };
struct Ul_BFu9s_C { unsigned long long v1; unsigned short v2:9; char v3; };
struct Ul_BFu9s_D { unsigned long long v1; unsigned short v2:9; double v3; };
struct Ul_BFu9s_F { unsigned long long v1; unsigned short v2:9; float v3; };
struct Ul_BFu9s_I { unsigned long long v1; unsigned short v2:9; int v3; };
struct Ul_BFu9s_Ip { unsigned long long v1; unsigned short v2:9; int * v3; };
struct Ul_BFu9s_L { unsigned long long v1; unsigned short v2:9; long long v3; };
struct Ul_BFu9s_S { unsigned long long v1; unsigned short v2:9; short v3; };
struct Ul_BFu9s_Uc { unsigned long long v1; unsigned short v2:9; unsigned char v3; };
struct Ul_BFu9s_Ui { unsigned long long v1; unsigned short v2:9; unsigned int v3; };
struct Ul_BFu9s_Ul { unsigned long long v1; unsigned short v2:9; unsigned long long v3; };
struct Ul_BFu9s_Us { unsigned long long v1; unsigned short v2:9; unsigned short v3; };
struct Ul_BFu9s_Vp { unsigned long long v1; unsigned short v2:9; void * v3; };
struct Ul_C { unsigned long long v1; char v2; };
struct Ul_C_BFu15i { unsigned long long v1; char v2; unsigned int v3:15; };
struct Ul_C_BFu15ll { unsigned long long v1; char v2; unsigned long long v3:15; };
struct Ul_C_BFu15s { unsigned long long v1; char v2; unsigned short v3:15; };
struct Ul_C_BFu16i { unsigned long long v1; char v2; unsigned int v3:16; };
struct Ul_C_BFu16ll { unsigned long long v1; char v2; unsigned long long v3:16; };
struct Ul_C_BFu16s { unsigned long long v1; char v2; unsigned short v3:16; };
struct Ul_C_BFu17i { unsigned long long v1; char v2; unsigned int v3:17; };
struct Ul_C_BFu17ll { unsigned long long v1; char v2; unsigned long long v3:17; };
struct Ul_C_BFu1c { unsigned long long v1; char v2; unsigned char v3:1; };
struct Ul_C_BFu1i { unsigned long long v1; char v2; unsigned int v3:1; };
struct Ul_C_BFu1ll { unsigned long long v1; char v2; unsigned long long v3:1; };
struct Ul_C_BFu1s { unsigned long long v1; char v2; unsigned short v3:1; };
struct Ul_C_BFu31i { unsigned long long v1; char v2; unsigned int v3:31; };
struct Ul_C_BFu31ll { unsigned long long v1; char v2; unsigned long long v3:31; };
struct Ul_C_BFu32i { unsigned long long v1; char v2; unsigned int v3:32; };
struct Ul_C_BFu32ll { unsigned long long v1; char v2; unsigned long long v3:32; };
struct Ul_C_BFu33 { unsigned long long v1; char v2; unsigned long long v3:33; };
struct Ul_C_BFu7c { unsigned long long v1; char v2; unsigned char v3:7; };
struct Ul_C_BFu7i { unsigned long long v1; char v2; unsigned int v3:7; };
struct Ul_C_BFu7ll { unsigned long long v1; char v2; unsigned long long v3:7; };
struct Ul_C_BFu7s { unsigned long long v1; char v2; unsigned short v3:7; };
struct Ul_C_BFu8c { unsigned long long v1; char v2; unsigned char v3:8; };
struct Ul_C_BFu8i { unsigned long long v1; char v2; unsigned int v3:8; };
struct Ul_C_BFu8ll { unsigned long long v1; char v2; unsigned long long v3:8; };
struct Ul_C_BFu8s { unsigned long long v1; char v2; unsigned short v3:8; };
struct Ul_C_BFu9i { unsigned long long v1; char v2; unsigned int v3:9; };
struct Ul_C_BFu9ll { unsigned long long v1; char v2; unsigned long long v3:9; };
struct Ul_C_BFu9s { unsigned long long v1; char v2; unsigned short v3:9; };
struct Ul_C_C { unsigned long long v1; char v2; char v3; };
struct Ul_C_D { unsigned long long v1; char v2; double v3; };
struct Ul_C_F { unsigned long long v1; char v2; float v3; };
struct Ul_C_I { unsigned long long v1; char v2; int v3; };
struct Ul_C_Ip { unsigned long long v1; char v2; int * v3; };
struct Ul_C_L { unsigned long long v1; char v2; long long v3; };
struct Ul_C_S { unsigned long long v1; char v2; short v3; };
struct Ul_C_Uc { unsigned long long v1; char v2; unsigned char v3; };
struct Ul_C_Ui { unsigned long long v1; char v2; unsigned int v3; };
struct Ul_C_Ul { unsigned long long v1; char v2; unsigned long long v3; };
struct Ul_C_Us { unsigned long long v1; char v2; unsigned short v3; };
struct Ul_C_Vp { unsigned long long v1; char v2; void * v3; };
struct Ul_D { unsigned long long v1; double v2; };
struct Ul_D_BFu15i { unsigned long long v1; double v2; unsigned int v3:15; };
struct Ul_D_BFu15ll { unsigned long long v1; double v2; unsigned long long v3:15; };
struct Ul_D_BFu15s { unsigned long long v1; double v2; unsigned short v3:15; };
struct Ul_D_BFu16i { unsigned long long v1; double v2; unsigned int v3:16; };
struct Ul_D_BFu16ll { unsigned long long v1; double v2; unsigned long long v3:16; };
struct Ul_D_BFu16s { unsigned long long v1; double v2; unsigned short v3:16; };
struct Ul_D_BFu17i { unsigned long long v1; double v2; unsigned int v3:17; };
struct Ul_D_BFu17ll { unsigned long long v1; double v2; unsigned long long v3:17; };
struct Ul_D_BFu1c { unsigned long long v1; double v2; unsigned char v3:1; };
struct Ul_D_BFu1i { unsigned long long v1; double v2; unsigned int v3:1; };
struct Ul_D_BFu1ll { unsigned long long v1; double v2; unsigned long long v3:1; };
struct Ul_D_BFu1s { unsigned long long v1; double v2; unsigned short v3:1; };
struct Ul_D_BFu31i { unsigned long long v1; double v2; unsigned int v3:31; };
struct Ul_D_BFu31ll { unsigned long long v1; double v2; unsigned long long v3:31; };
struct Ul_D_BFu32i { unsigned long long v1; double v2; unsigned int v3:32; };
struct Ul_D_BFu32ll { unsigned long long v1; double v2; unsigned long long v3:32; };
struct Ul_D_BFu33 { unsigned long long v1; double v2; unsigned long long v3:33; };
struct Ul_D_BFu7c { unsigned long long v1; double v2; unsigned char v3:7; };
struct Ul_D_BFu7i { unsigned long long v1; double v2; unsigned int v3:7; };
struct Ul_D_BFu7ll { unsigned long long v1; double v2; unsigned long long v3:7; };
struct Ul_D_BFu7s { unsigned long long v1; double v2; unsigned short v3:7; };
struct Ul_D_BFu8c { unsigned long long v1; double v2; unsigned char v3:8; };
struct Ul_D_BFu8i { unsigned long long v1; double v2; unsigned int v3:8; };
struct Ul_D_BFu8ll { unsigned long long v1; double v2; unsigned long long v3:8; };
struct Ul_D_BFu8s { unsigned long long v1; double v2; unsigned short v3:8; };
struct Ul_D_BFu9i { unsigned long long v1; double v2; unsigned int v3:9; };
struct Ul_D_BFu9ll { unsigned long long v1; double v2; unsigned long long v3:9; };
struct Ul_D_BFu9s { unsigned long long v1; double v2; unsigned short v3:9; };
struct Ul_D_C { unsigned long long v1; double v2; char v3; };
struct Ul_D_D { unsigned long long v1; double v2; double v3; };
struct Ul_D_F { unsigned long long v1; double v2; float v3; };
struct Ul_D_I { unsigned long long v1; double v2; int v3; };
struct Ul_D_Ip { unsigned long long v1; double v2; int * v3; };
struct Ul_D_L { unsigned long long v1; double v2; long long v3; };
struct Ul_D_S { unsigned long long v1; double v2; short v3; };
struct Ul_D_Uc { unsigned long long v1; double v2; unsigned char v3; };
struct Ul_D_Ui { unsigned long long v1; double v2; unsigned int v3; };
struct Ul_D_Ul { unsigned long long v1; double v2; unsigned long long v3; };
struct Ul_D_Us { unsigned long long v1; double v2; unsigned short v3; };
struct Ul_D_Vp { unsigned long long v1; double v2; void * v3; };
struct Ul_F { unsigned long long v1; float v2; };
struct Ul_F_BFu15i { unsigned long long v1; float v2; unsigned int v3:15; };
struct Ul_F_BFu15ll { unsigned long long v1; float v2; unsigned long long v3:15; };
struct Ul_F_BFu15s { unsigned long long v1; float v2; unsigned short v3:15; };
struct Ul_F_BFu16i { unsigned long long v1; float v2; unsigned int v3:16; };
struct Ul_F_BFu16ll { unsigned long long v1; float v2; unsigned long long v3:16; };
struct Ul_F_BFu16s { unsigned long long v1; float v2; unsigned short v3:16; };
struct Ul_F_BFu17i { unsigned long long v1; float v2; unsigned int v3:17; };
struct Ul_F_BFu17ll { unsigned long long v1; float v2; unsigned long long v3:17; };
struct Ul_F_BFu1c { unsigned long long v1; float v2; unsigned char v3:1; };
struct Ul_F_BFu1i { unsigned long long v1; float v2; unsigned int v3:1; };
struct Ul_F_BFu1ll { unsigned long long v1; float v2; unsigned long long v3:1; };
struct Ul_F_BFu1s { unsigned long long v1; float v2; unsigned short v3:1; };
struct Ul_F_BFu31i { unsigned long long v1; float v2; unsigned int v3:31; };
struct Ul_F_BFu31ll { unsigned long long v1; float v2; unsigned long long v3:31; };
struct Ul_F_BFu32i { unsigned long long v1; float v2; unsigned int v3:32; };
struct Ul_F_BFu32ll { unsigned long long v1; float v2; unsigned long long v3:32; };
struct Ul_F_BFu33 { unsigned long long v1; float v2; unsigned long long v3:33; };
struct Ul_F_BFu7c { unsigned long long v1; float v2; unsigned char v3:7; };
struct Ul_F_BFu7i { unsigned long long v1; float v2; unsigned int v3:7; };
struct Ul_F_BFu7ll { unsigned long long v1; float v2; unsigned long long v3:7; };
struct Ul_F_BFu7s { unsigned long long v1; float v2; unsigned short v3:7; };
struct Ul_F_BFu8c { unsigned long long v1; float v2; unsigned char v3:8; };
struct Ul_F_BFu8i { unsigned long long v1; float v2; unsigned int v3:8; };
struct Ul_F_BFu8ll { unsigned long long v1; float v2; unsigned long long v3:8; };
struct Ul_F_BFu8s { unsigned long long v1; float v2; unsigned short v3:8; };
struct Ul_F_BFu9i { unsigned long long v1; float v2; unsigned int v3:9; };
struct Ul_F_BFu9ll { unsigned long long v1; float v2; unsigned long long v3:9; };
struct Ul_F_BFu9s { unsigned long long v1; float v2; unsigned short v3:9; };
struct Ul_F_C { unsigned long long v1; float v2; char v3; };
struct Ul_F_D { unsigned long long v1; float v2; double v3; };
struct Ul_F_F { unsigned long long v1; float v2; float v3; };
struct Ul_F_I { unsigned long long v1; float v2; int v3; };
struct Ul_F_Ip { unsigned long long v1; float v2; int * v3; };
struct Ul_F_L { unsigned long long v1; float v2; long long v3; };
struct Ul_F_S { unsigned long long v1; float v2; short v3; };
struct Ul_F_Uc { unsigned long long v1; float v2; unsigned char v3; };
struct Ul_F_Ui { unsigned long long v1; float v2; unsigned int v3; };
struct Ul_F_Ul { unsigned long long v1; float v2; unsigned long long v3; };
struct Ul_F_Us { unsigned long long v1; float v2; unsigned short v3; };
struct Ul_F_Vp { unsigned long long v1; float v2; void * v3; };
struct Ul_I { unsigned long long v1; int v2; };
struct Ul_I_BFu15i { unsigned long long v1; int v2; unsigned int v3:15; };
struct Ul_I_BFu15ll { unsigned long long v1; int v2; unsigned long long v3:15; };
struct Ul_I_BFu15s { unsigned long long v1; int v2; unsigned short v3:15; };
struct Ul_I_BFu16i { unsigned long long v1; int v2; unsigned int v3:16; };
struct Ul_I_BFu16ll { unsigned long long v1; int v2; unsigned long long v3:16; };
struct Ul_I_BFu16s { unsigned long long v1; int v2; unsigned short v3:16; };
struct Ul_I_BFu17i { unsigned long long v1; int v2; unsigned int v3:17; };
struct Ul_I_BFu17ll { unsigned long long v1; int v2; unsigned long long v3:17; };
struct Ul_I_BFu1c { unsigned long long v1; int v2; unsigned char v3:1; };
struct Ul_I_BFu1i { unsigned long long v1; int v2; unsigned int v3:1; };
struct Ul_I_BFu1ll { unsigned long long v1; int v2; unsigned long long v3:1; };
struct Ul_I_BFu1s { unsigned long long v1; int v2; unsigned short v3:1; };
struct Ul_I_BFu31i { unsigned long long v1; int v2; unsigned int v3:31; };
struct Ul_I_BFu31ll { unsigned long long v1; int v2; unsigned long long v3:31; };
struct Ul_I_BFu32i { unsigned long long v1; int v2; unsigned int v3:32; };
struct Ul_I_BFu32ll { unsigned long long v1; int v2; unsigned long long v3:32; };
struct Ul_I_BFu33 { unsigned long long v1; int v2; unsigned long long v3:33; };
struct Ul_I_BFu7c { unsigned long long v1; int v2; unsigned char v3:7; };
struct Ul_I_BFu7i { unsigned long long v1; int v2; unsigned int v3:7; };
struct Ul_I_BFu7ll { unsigned long long v1; int v2; unsigned long long v3:7; };
struct Ul_I_BFu7s { unsigned long long v1; int v2; unsigned short v3:7; };
struct Ul_I_BFu8c { unsigned long long v1; int v2; unsigned char v3:8; };
struct Ul_I_BFu8i { unsigned long long v1; int v2; unsigned int v3:8; };
struct Ul_I_BFu8ll { unsigned long long v1; int v2; unsigned long long v3:8; };
struct Ul_I_BFu8s { unsigned long long v1; int v2; unsigned short v3:8; };
struct Ul_I_BFu9i { unsigned long long v1; int v2; unsigned int v3:9; };
struct Ul_I_BFu9ll { unsigned long long v1; int v2; unsigned long long v3:9; };
struct Ul_I_BFu9s { unsigned long long v1; int v2; unsigned short v3:9; };
struct Ul_I_C { unsigned long long v1; int v2; char v3; };
struct Ul_I_D { unsigned long long v1; int v2; double v3; };
struct Ul_I_F { unsigned long long v1; int v2; float v3; };
struct Ul_I_I { unsigned long long v1; int v2; int v3; };
struct Ul_I_Ip { unsigned long long v1; int v2; int * v3; };
struct Ul_I_L { unsigned long long v1; int v2; long long v3; };
struct Ul_I_S { unsigned long long v1; int v2; short v3; };
struct Ul_I_Uc { unsigned long long v1; int v2; unsigned char v3; };
struct Ul_I_Ui { unsigned long long v1; int v2; unsigned int v3; };
struct Ul_I_Ul { unsigned long long v1; int v2; unsigned long long v3; };
struct Ul_I_Us { unsigned long long v1; int v2; unsigned short v3; };
struct Ul_I_Vp { unsigned long long v1; int v2; void * v3; };
struct Ul_Ip { unsigned long long v1; int * v2; };
struct Ul_Ip_BFu15i { unsigned long long v1; int * v2; unsigned int v3:15; };
struct Ul_Ip_BFu15ll { unsigned long long v1; int * v2; unsigned long long v3:15; };
struct Ul_Ip_BFu15s { unsigned long long v1; int * v2; unsigned short v3:15; };
struct Ul_Ip_BFu16i { unsigned long long v1; int * v2; unsigned int v3:16; };
struct Ul_Ip_BFu16ll { unsigned long long v1; int * v2; unsigned long long v3:16; };
struct Ul_Ip_BFu16s { unsigned long long v1; int * v2; unsigned short v3:16; };
struct Ul_Ip_BFu17i { unsigned long long v1; int * v2; unsigned int v3:17; };
struct Ul_Ip_BFu17ll { unsigned long long v1; int * v2; unsigned long long v3:17; };
struct Ul_Ip_BFu1c { unsigned long long v1; int * v2; unsigned char v3:1; };
struct Ul_Ip_BFu1i { unsigned long long v1; int * v2; unsigned int v3:1; };
struct Ul_Ip_BFu1ll { unsigned long long v1; int * v2; unsigned long long v3:1; };
struct Ul_Ip_BFu1s { unsigned long long v1; int * v2; unsigned short v3:1; };
struct Ul_Ip_BFu31i { unsigned long long v1; int * v2; unsigned int v3:31; };
struct Ul_Ip_BFu31ll { unsigned long long v1; int * v2; unsigned long long v3:31; };
struct Ul_Ip_BFu32i { unsigned long long v1; int * v2; unsigned int v3:32; };
struct Ul_Ip_BFu32ll { unsigned long long v1; int * v2; unsigned long long v3:32; };
struct Ul_Ip_BFu33 { unsigned long long v1; int * v2; unsigned long long v3:33; };
struct Ul_Ip_BFu7c { unsigned long long v1; int * v2; unsigned char v3:7; };
struct Ul_Ip_BFu7i { unsigned long long v1; int * v2; unsigned int v3:7; };
struct Ul_Ip_BFu7ll { unsigned long long v1; int * v2; unsigned long long v3:7; };
struct Ul_Ip_BFu7s { unsigned long long v1; int * v2; unsigned short v3:7; };
struct Ul_Ip_BFu8c { unsigned long long v1; int * v2; unsigned char v3:8; };
struct Ul_Ip_BFu8i { unsigned long long v1; int * v2; unsigned int v3:8; };
struct Ul_Ip_BFu8ll { unsigned long long v1; int * v2; unsigned long long v3:8; };
struct Ul_Ip_BFu8s { unsigned long long v1; int * v2; unsigned short v3:8; };
struct Ul_Ip_BFu9i { unsigned long long v1; int * v2; unsigned int v3:9; };
struct Ul_Ip_BFu9ll { unsigned long long v1; int * v2; unsigned long long v3:9; };
struct Ul_Ip_BFu9s { unsigned long long v1; int * v2; unsigned short v3:9; };
struct Ul_Ip_C { unsigned long long v1; int * v2; char v3; };
struct Ul_Ip_D { unsigned long long v1; int * v2; double v3; };
struct Ul_Ip_F { unsigned long long v1; int * v2; float v3; };
struct Ul_Ip_I { unsigned long long v1; int * v2; int v3; };
struct Ul_Ip_Ip { unsigned long long v1; int * v2; int * v3; };
struct Ul_Ip_L { unsigned long long v1; int * v2; long long v3; };
struct Ul_Ip_S { unsigned long long v1; int * v2; short v3; };
struct Ul_Ip_Uc { unsigned long long v1; int * v2; unsigned char v3; };
struct Ul_Ip_Ui { unsigned long long v1; int * v2; unsigned int v3; };
struct Ul_Ip_Ul { unsigned long long v1; int * v2; unsigned long long v3; };
struct Ul_Ip_Us { unsigned long long v1; int * v2; unsigned short v3; };
struct Ul_Ip_Vp { unsigned long long v1; int * v2; void * v3; };
struct Ul_L { unsigned long long v1; long long v2; };
struct Ul_L_BFu15i { unsigned long long v1; long long v2; unsigned int v3:15; };
struct Ul_L_BFu15ll { unsigned long long v1; long long v2; unsigned long long v3:15; };
struct Ul_L_BFu15s { unsigned long long v1; long long v2; unsigned short v3:15; };
struct Ul_L_BFu16i { unsigned long long v1; long long v2; unsigned int v3:16; };
struct Ul_L_BFu16ll { unsigned long long v1; long long v2; unsigned long long v3:16; };
struct Ul_L_BFu16s { unsigned long long v1; long long v2; unsigned short v3:16; };
struct Ul_L_BFu17i { unsigned long long v1; long long v2; unsigned int v3:17; };
struct Ul_L_BFu17ll { unsigned long long v1; long long v2; unsigned long long v3:17; };
struct Ul_L_BFu1c { unsigned long long v1; long long v2; unsigned char v3:1; };
struct Ul_L_BFu1i { unsigned long long v1; long long v2; unsigned int v3:1; };
struct Ul_L_BFu1ll { unsigned long long v1; long long v2; unsigned long long v3:1; };
struct Ul_L_BFu1s { unsigned long long v1; long long v2; unsigned short v3:1; };
struct Ul_L_BFu31i { unsigned long long v1; long long v2; unsigned int v3:31; };
struct Ul_L_BFu31ll { unsigned long long v1; long long v2; unsigned long long v3:31; };
struct Ul_L_BFu32i { unsigned long long v1; long long v2; unsigned int v3:32; };
struct Ul_L_BFu32ll { unsigned long long v1; long long v2; unsigned long long v3:32; };
struct Ul_L_BFu33 { unsigned long long v1; long long v2; unsigned long long v3:33; };
struct Ul_L_BFu7c { unsigned long long v1; long long v2; unsigned char v3:7; };
struct Ul_L_BFu7i { unsigned long long v1; long long v2; unsigned int v3:7; };
struct Ul_L_BFu7ll { unsigned long long v1; long long v2; unsigned long long v3:7; };
struct Ul_L_BFu7s { unsigned long long v1; long long v2; unsigned short v3:7; };
struct Ul_L_BFu8c { unsigned long long v1; long long v2; unsigned char v3:8; };
struct Ul_L_BFu8i { unsigned long long v1; long long v2; unsigned int v3:8; };
struct Ul_L_BFu8ll { unsigned long long v1; long long v2; unsigned long long v3:8; };
struct Ul_L_BFu8s { unsigned long long v1; long long v2; unsigned short v3:8; };
struct Ul_L_BFu9i { unsigned long long v1; long long v2; unsigned int v3:9; };
struct Ul_L_BFu9ll { unsigned long long v1; long long v2; unsigned long long v3:9; };
struct Ul_L_BFu9s { unsigned long long v1; long long v2; unsigned short v3:9; };
struct Ul_L_C { unsigned long long v1; long long v2; char v3; };
struct Ul_L_D { unsigned long long v1; long long v2; double v3; };
struct Ul_L_F { unsigned long long v1; long long v2; float v3; };
struct Ul_L_I { unsigned long long v1; long long v2; int v3; };
struct Ul_L_Ip { unsigned long long v1; long long v2; int * v3; };
struct Ul_L_L { unsigned long long v1; long long v2; long long v3; };
struct Ul_L_S { unsigned long long v1; long long v2; short v3; };
struct Ul_L_Uc { unsigned long long v1; long long v2; unsigned char v3; };
struct Ul_L_Ui { unsigned long long v1; long long v2; unsigned int v3; };
struct Ul_L_Ul { unsigned long long v1; long long v2; unsigned long long v3; };
struct Ul_L_Us { unsigned long long v1; long long v2; unsigned short v3; };
struct Ul_L_Vp { unsigned long long v1; long long v2; void * v3; };
struct Ul_S { unsigned long long v1; short v2; };
struct Ul_S_BFu15i { unsigned long long v1; short v2; unsigned int v3:15; };
struct Ul_S_BFu15ll { unsigned long long v1; short v2; unsigned long long v3:15; };
struct Ul_S_BFu15s { unsigned long long v1; short v2; unsigned short v3:15; };
struct Ul_S_BFu16i { unsigned long long v1; short v2; unsigned int v3:16; };
struct Ul_S_BFu16ll { unsigned long long v1; short v2; unsigned long long v3:16; };
struct Ul_S_BFu16s { unsigned long long v1; short v2; unsigned short v3:16; };
struct Ul_S_BFu17i { unsigned long long v1; short v2; unsigned int v3:17; };
struct Ul_S_BFu17ll { unsigned long long v1; short v2; unsigned long long v3:17; };
struct Ul_S_BFu1c { unsigned long long v1; short v2; unsigned char v3:1; };
struct Ul_S_BFu1i { unsigned long long v1; short v2; unsigned int v3:1; };
struct Ul_S_BFu1ll { unsigned long long v1; short v2; unsigned long long v3:1; };
struct Ul_S_BFu1s { unsigned long long v1; short v2; unsigned short v3:1; };
struct Ul_S_BFu31i { unsigned long long v1; short v2; unsigned int v3:31; };
struct Ul_S_BFu31ll { unsigned long long v1; short v2; unsigned long long v3:31; };
struct Ul_S_BFu32i { unsigned long long v1; short v2; unsigned int v3:32; };
struct Ul_S_BFu32ll { unsigned long long v1; short v2; unsigned long long v3:32; };
struct Ul_S_BFu33 { unsigned long long v1; short v2; unsigned long long v3:33; };
struct Ul_S_BFu7c { unsigned long long v1; short v2; unsigned char v3:7; };
struct Ul_S_BFu7i { unsigned long long v1; short v2; unsigned int v3:7; };
struct Ul_S_BFu7ll { unsigned long long v1; short v2; unsigned long long v3:7; };
struct Ul_S_BFu7s { unsigned long long v1; short v2; unsigned short v3:7; };
struct Ul_S_BFu8c { unsigned long long v1; short v2; unsigned char v3:8; };
struct Ul_S_BFu8i { unsigned long long v1; short v2; unsigned int v3:8; };
struct Ul_S_BFu8ll { unsigned long long v1; short v2; unsigned long long v3:8; };
struct Ul_S_BFu8s { unsigned long long v1; short v2; unsigned short v3:8; };
struct Ul_S_BFu9i { unsigned long long v1; short v2; unsigned int v3:9; };
struct Ul_S_BFu9ll { unsigned long long v1; short v2; unsigned long long v3:9; };
struct Ul_S_BFu9s { unsigned long long v1; short v2; unsigned short v3:9; };
struct Ul_S_C { unsigned long long v1; short v2; char v3; };
struct Ul_S_D { unsigned long long v1; short v2; double v3; };
struct Ul_S_F { unsigned long long v1; short v2; float v3; };
struct Ul_S_I { unsigned long long v1; short v2; int v3; };
struct Ul_S_Ip { unsigned long long v1; short v2; int * v3; };
struct Ul_S_L { unsigned long long v1; short v2; long long v3; };
struct Ul_S_S { unsigned long long v1; short v2; short v3; };
struct Ul_S_Uc { unsigned long long v1; short v2; unsigned char v3; };
struct Ul_S_Ui { unsigned long long v1; short v2; unsigned int v3; };
struct Ul_S_Ul { unsigned long long v1; short v2; unsigned long long v3; };
struct Ul_S_Us { unsigned long long v1; short v2; unsigned short v3; };
struct Ul_S_Vp { unsigned long long v1; short v2; void * v3; };
struct Ul_Uc { unsigned long long v1; unsigned char v2; };
struct Ul_Uc_BFu15i { unsigned long long v1; unsigned char v2; unsigned int v3:15; };
struct Ul_Uc_BFu15ll { unsigned long long v1; unsigned char v2; unsigned long long v3:15; };
struct Ul_Uc_BFu15s { unsigned long long v1; unsigned char v2; unsigned short v3:15; };
struct Ul_Uc_BFu16i { unsigned long long v1; unsigned char v2; unsigned int v3:16; };
struct Ul_Uc_BFu16ll { unsigned long long v1; unsigned char v2; unsigned long long v3:16; };
struct Ul_Uc_BFu16s { unsigned long long v1; unsigned char v2; unsigned short v3:16; };
struct Ul_Uc_BFu17i { unsigned long long v1; unsigned char v2; unsigned int v3:17; };
struct Ul_Uc_BFu17ll { unsigned long long v1; unsigned char v2; unsigned long long v3:17; };
struct Ul_Uc_BFu1c { unsigned long long v1; unsigned char v2; unsigned char v3:1; };
struct Ul_Uc_BFu1i { unsigned long long v1; unsigned char v2; unsigned int v3:1; };
struct Ul_Uc_BFu1ll { unsigned long long v1; unsigned char v2; unsigned long long v3:1; };
struct Ul_Uc_BFu1s { unsigned long long v1; unsigned char v2; unsigned short v3:1; };
struct Ul_Uc_BFu31i { unsigned long long v1; unsigned char v2; unsigned int v3:31; };
struct Ul_Uc_BFu31ll { unsigned long long v1; unsigned char v2; unsigned long long v3:31; };
struct Ul_Uc_BFu32i { unsigned long long v1; unsigned char v2; unsigned int v3:32; };
struct Ul_Uc_BFu32ll { unsigned long long v1; unsigned char v2; unsigned long long v3:32; };
struct Ul_Uc_BFu33 { unsigned long long v1; unsigned char v2; unsigned long long v3:33; };
struct Ul_Uc_BFu7c { unsigned long long v1; unsigned char v2; unsigned char v3:7; };
struct Ul_Uc_BFu7i { unsigned long long v1; unsigned char v2; unsigned int v3:7; };
struct Ul_Uc_BFu7ll { unsigned long long v1; unsigned char v2; unsigned long long v3:7; };
struct Ul_Uc_BFu7s { unsigned long long v1; unsigned char v2; unsigned short v3:7; };
struct Ul_Uc_BFu8c { unsigned long long v1; unsigned char v2; unsigned char v3:8; };
struct Ul_Uc_BFu8i { unsigned long long v1; unsigned char v2; unsigned int v3:8; };
struct Ul_Uc_BFu8ll { unsigned long long v1; unsigned char v2; unsigned long long v3:8; };
struct Ul_Uc_BFu8s { unsigned long long v1; unsigned char v2; unsigned short v3:8; };
struct Ul_Uc_BFu9i { unsigned long long v1; unsigned char v2; unsigned int v3:9; };
struct Ul_Uc_BFu9ll { unsigned long long v1; unsigned char v2; unsigned long long v3:9; };
struct Ul_Uc_BFu9s { unsigned long long v1; unsigned char v2; unsigned short v3:9; };
struct Ul_Uc_C { unsigned long long v1; unsigned char v2; char v3; };
struct Ul_Uc_D { unsigned long long v1; unsigned char v2; double v3; };
struct Ul_Uc_F { unsigned long long v1; unsigned char v2; float v3; };
struct Ul_Uc_I { unsigned long long v1; unsigned char v2; int v3; };
struct Ul_Uc_Ip { unsigned long long v1; unsigned char v2; int * v3; };
struct Ul_Uc_L { unsigned long long v1; unsigned char v2; long long v3; };
struct Ul_Uc_S { unsigned long long v1; unsigned char v2; short v3; };
struct Ul_Uc_Uc { unsigned long long v1; unsigned char v2; unsigned char v3; };
struct Ul_Uc_Ui { unsigned long long v1; unsigned char v2; unsigned int v3; };
struct Ul_Uc_Ul { unsigned long long v1; unsigned char v2; unsigned long long v3; };
struct Ul_Uc_Us { unsigned long long v1; unsigned char v2; unsigned short v3; };
struct Ul_Uc_Vp { unsigned long long v1; unsigned char v2; void * v3; };
struct Ul_Ui { unsigned long long v1; unsigned int v2; };
struct Ul_Ui_BFu15i { unsigned long long v1; unsigned int v2; unsigned int v3:15; };
struct Ul_Ui_BFu15ll { unsigned long long v1; unsigned int v2; unsigned long long v3:15; };
struct Ul_Ui_BFu15s { unsigned long long v1; unsigned int v2; unsigned short v3:15; };
struct Ul_Ui_BFu16i { unsigned long long v1; unsigned int v2; unsigned int v3:16; };
struct Ul_Ui_BFu16ll { unsigned long long v1; unsigned int v2; unsigned long long v3:16; };
struct Ul_Ui_BFu16s { unsigned long long v1; unsigned int v2; unsigned short v3:16; };
struct Ul_Ui_BFu17i { unsigned long long v1; unsigned int v2; unsigned int v3:17; };
struct Ul_Ui_BFu17ll { unsigned long long v1; unsigned int v2; unsigned long long v3:17; };
struct Ul_Ui_BFu1c { unsigned long long v1; unsigned int v2; unsigned char v3:1; };
struct Ul_Ui_BFu1i { unsigned long long v1; unsigned int v2; unsigned int v3:1; };
struct Ul_Ui_BFu1ll { unsigned long long v1; unsigned int v2; unsigned long long v3:1; };
struct Ul_Ui_BFu1s { unsigned long long v1; unsigned int v2; unsigned short v3:1; };
struct Ul_Ui_BFu31i { unsigned long long v1; unsigned int v2; unsigned int v3:31; };
struct Ul_Ui_BFu31ll { unsigned long long v1; unsigned int v2; unsigned long long v3:31; };
struct Ul_Ui_BFu32i { unsigned long long v1; unsigned int v2; unsigned int v3:32; };
struct Ul_Ui_BFu32ll { unsigned long long v1; unsigned int v2; unsigned long long v3:32; };
struct Ul_Ui_BFu33 { unsigned long long v1; unsigned int v2; unsigned long long v3:33; };
struct Ul_Ui_BFu7c { unsigned long long v1; unsigned int v2; unsigned char v3:7; };
struct Ul_Ui_BFu7i { unsigned long long v1; unsigned int v2; unsigned int v3:7; };
struct Ul_Ui_BFu7ll { unsigned long long v1; unsigned int v2; unsigned long long v3:7; };
struct Ul_Ui_BFu7s { unsigned long long v1; unsigned int v2; unsigned short v3:7; };
struct Ul_Ui_BFu8c { unsigned long long v1; unsigned int v2; unsigned char v3:8; };
struct Ul_Ui_BFu8i { unsigned long long v1; unsigned int v2; unsigned int v3:8; };
struct Ul_Ui_BFu8ll { unsigned long long v1; unsigned int v2; unsigned long long v3:8; };
struct Ul_Ui_BFu8s { unsigned long long v1; unsigned int v2; unsigned short v3:8; };
struct Ul_Ui_BFu9i { unsigned long long v1; unsigned int v2; unsigned int v3:9; };
struct Ul_Ui_BFu9ll { unsigned long long v1; unsigned int v2; unsigned long long v3:9; };
struct Ul_Ui_BFu9s { unsigned long long v1; unsigned int v2; unsigned short v3:9; };
struct Ul_Ui_C { unsigned long long v1; unsigned int v2; char v3; };
struct Ul_Ui_D { unsigned long long v1; unsigned int v2; double v3; };
struct Ul_Ui_F { unsigned long long v1; unsigned int v2; float v3; };
struct Ul_Ui_I { unsigned long long v1; unsigned int v2; int v3; };
struct Ul_Ui_Ip { unsigned long long v1; unsigned int v2; int * v3; };
struct Ul_Ui_L { unsigned long long v1; unsigned int v2; long long v3; };
struct Ul_Ui_S { unsigned long long v1; unsigned int v2; short v3; };
struct Ul_Ui_Uc { unsigned long long v1; unsigned int v2; unsigned char v3; };
struct Ul_Ui_Ui { unsigned long long v1; unsigned int v2; unsigned int v3; };
struct Ul_Ui_Ul { unsigned long long v1; unsigned int v2; unsigned long long v3; };
struct Ul_Ui_Us { unsigned long long v1; unsigned int v2; unsigned short v3; };
struct Ul_Ui_Vp { unsigned long long v1; unsigned int v2; void * v3; };
struct Ul_Ul { unsigned long long v1; unsigned long long v2; };
struct Ul_Ul_BFu15i { unsigned long long v1; unsigned long long v2; unsigned int v3:15; };
struct Ul_Ul_BFu15ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:15; };
struct Ul_Ul_BFu15s { unsigned long long v1; unsigned long long v2; unsigned short v3:15; };
struct Ul_Ul_BFu16i { unsigned long long v1; unsigned long long v2; unsigned int v3:16; };
struct Ul_Ul_BFu16ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:16; };
struct Ul_Ul_BFu16s { unsigned long long v1; unsigned long long v2; unsigned short v3:16; };
struct Ul_Ul_BFu17i { unsigned long long v1; unsigned long long v2; unsigned int v3:17; };
struct Ul_Ul_BFu17ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:17; };
struct Ul_Ul_BFu1c { unsigned long long v1; unsigned long long v2; unsigned char v3:1; };
struct Ul_Ul_BFu1i { unsigned long long v1; unsigned long long v2; unsigned int v3:1; };
struct Ul_Ul_BFu1ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:1; };
struct Ul_Ul_BFu1s { unsigned long long v1; unsigned long long v2; unsigned short v3:1; };
struct Ul_Ul_BFu31i { unsigned long long v1; unsigned long long v2; unsigned int v3:31; };
struct Ul_Ul_BFu31ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:31; };
struct Ul_Ul_BFu32i { unsigned long long v1; unsigned long long v2; unsigned int v3:32; };
struct Ul_Ul_BFu32ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:32; };
struct Ul_Ul_BFu33 { unsigned long long v1; unsigned long long v2; unsigned long long v3:33; };
struct Ul_Ul_BFu7c { unsigned long long v1; unsigned long long v2; unsigned char v3:7; };
struct Ul_Ul_BFu7i { unsigned long long v1; unsigned long long v2; unsigned int v3:7; };
struct Ul_Ul_BFu7ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:7; };
struct Ul_Ul_BFu7s { unsigned long long v1; unsigned long long v2; unsigned short v3:7; };
struct Ul_Ul_BFu8c { unsigned long long v1; unsigned long long v2; unsigned char v3:8; };
struct Ul_Ul_BFu8i { unsigned long long v1; unsigned long long v2; unsigned int v3:8; };
struct Ul_Ul_BFu8ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:8; };
struct Ul_Ul_BFu8s { unsigned long long v1; unsigned long long v2; unsigned short v3:8; };
struct Ul_Ul_BFu9i { unsigned long long v1; unsigned long long v2; unsigned int v3:9; };
struct Ul_Ul_BFu9ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:9; };
struct Ul_Ul_BFu9s { unsigned long long v1; unsigned long long v2; unsigned short v3:9; };
struct Ul_Ul_C { unsigned long long v1; unsigned long long v2; char v3; };
struct Ul_Ul_D { unsigned long long v1; unsigned long long v2; double v3; };
struct Ul_Ul_F { unsigned long long v1; unsigned long long v2; float v3; };
struct Ul_Ul_I { unsigned long long v1; unsigned long long v2; int v3; };
struct Ul_Ul_Ip { unsigned long long v1; unsigned long long v2; int * v3; };
struct Ul_Ul_L { unsigned long long v1; unsigned long long v2; long long v3; };
struct Ul_Ul_S { unsigned long long v1; unsigned long long v2; short v3; };
struct Ul_Ul_Uc { unsigned long long v1; unsigned long long v2; unsigned char v3; };
struct Ul_Ul_Ui { unsigned long long v1; unsigned long long v2; unsigned int v3; };
struct Ul_Ul_Ul { unsigned long long v1; unsigned long long v2; unsigned long long v3; };
struct Ul_Ul_Us { unsigned long long v1; unsigned long long v2; unsigned short v3; };
struct Ul_Ul_Vp { unsigned long long v1; unsigned long long v2; void * v3; };
struct Ul_Us { unsigned long long v1; unsigned short v2; };
struct Ul_Us_BFu15i { unsigned long long v1; unsigned short v2; unsigned int v3:15; };
struct Ul_Us_BFu15ll { unsigned long long v1; unsigned short v2; unsigned long long v3:15; };
struct Ul_Us_BFu15s { unsigned long long v1; unsigned short v2; unsigned short v3:15; };
struct Ul_Us_BFu16i { unsigned long long v1; unsigned short v2; unsigned int v3:16; };
struct Ul_Us_BFu16ll { unsigned long long v1; unsigned short v2; unsigned long long v3:16; };
struct Ul_Us_BFu16s { unsigned long long v1; unsigned short v2; unsigned short v3:16; };
struct Ul_Us_BFu17i { unsigned long long v1; unsigned short v2; unsigned int v3:17; };
struct Ul_Us_BFu17ll { unsigned long long v1; unsigned short v2; unsigned long long v3:17; };
struct Ul_Us_BFu1c { unsigned long long v1; unsigned short v2; unsigned char v3:1; };
struct Ul_Us_BFu1i { unsigned long long v1; unsigned short v2; unsigned int v3:1; };
struct Ul_Us_BFu1ll { unsigned long long v1; unsigned short v2; unsigned long long v3:1; };
struct Ul_Us_BFu1s { unsigned long long v1; unsigned short v2; unsigned short v3:1; };
struct Ul_Us_BFu31i { unsigned long long v1; unsigned short v2; unsigned int v3:31; };
struct Ul_Us_BFu31ll { unsigned long long v1; unsigned short v2; unsigned long long v3:31; };
struct Ul_Us_BFu32i { unsigned long long v1; unsigned short v2; unsigned int v3:32; };
struct Ul_Us_BFu32ll { unsigned long long v1; unsigned short v2; unsigned long long v3:32; };
struct Ul_Us_BFu33 { unsigned long long v1; unsigned short v2; unsigned long long v3:33; };
struct Ul_Us_BFu7c { unsigned long long v1; unsigned short v2; unsigned char v3:7; };
struct Ul_Us_BFu7i { unsigned long long v1; unsigned short v2; unsigned int v3:7; };
struct Ul_Us_BFu7ll { unsigned long long v1; unsigned short v2; unsigned long long v3:7; };
struct Ul_Us_BFu7s { unsigned long long v1; unsigned short v2; unsigned short v3:7; };
struct Ul_Us_BFu8c { unsigned long long v1; unsigned short v2; unsigned char v3:8; };
struct Ul_Us_BFu8i { unsigned long long v1; unsigned short v2; unsigned int v3:8; };
struct Ul_Us_BFu8ll { unsigned long long v1; unsigned short v2; unsigned long long v3:8; };
struct Ul_Us_BFu8s { unsigned long long v1; unsigned short v2; unsigned short v3:8; };
struct Ul_Us_BFu9i { unsigned long long v1; unsigned short v2; unsigned int v3:9; };
struct Ul_Us_BFu9ll { unsigned long long v1; unsigned short v2; unsigned long long v3:9; };
struct Ul_Us_BFu9s { unsigned long long v1; unsigned short v2; unsigned short v3:9; };
struct Ul_Us_C { unsigned long long v1; unsigned short v2; char v3; };
struct Ul_Us_D { unsigned long long v1; unsigned short v2; double v3; };
struct Ul_Us_F { unsigned long long v1; unsigned short v2; float v3; };
struct Ul_Us_I { unsigned long long v1; unsigned short v2; int v3; };
struct Ul_Us_Ip { unsigned long long v1; unsigned short v2; int * v3; };
struct Ul_Us_L { unsigned long long v1; unsigned short v2; long long v3; };
struct Ul_Us_S { unsigned long long v1; unsigned short v2; short v3; };
struct Ul_Us_Uc { unsigned long long v1; unsigned short v2; unsigned char v3; };
struct Ul_Us_Ui { unsigned long long v1; unsigned short v2; unsigned int v3; };
struct Ul_Us_Ul { unsigned long long v1; unsigned short v2; unsigned long long v3; };
struct Ul_Us_Us { unsigned long long v1; unsigned short v2; unsigned short v3; };
struct Ul_Us_Vp { unsigned long long v1; unsigned short v2; void * v3; };
struct Ul_Vp { unsigned long long v1; void * v2; };
struct Ul_Vp_BFu15i { unsigned long long v1; void * v2; unsigned int v3:15; };
struct Ul_Vp_BFu15ll { unsigned long long v1; void * v2; unsigned long long v3:15; };
struct Ul_Vp_BFu15s { unsigned long long v1; void * v2; unsigned short v3:15; };
struct Ul_Vp_BFu16i { unsigned long long v1; void * v2; unsigned int v3:16; };
struct Ul_Vp_BFu16ll { unsigned long long v1; void * v2; unsigned long long v3:16; };
struct Ul_Vp_BFu16s { unsigned long long v1; void * v2; unsigned short v3:16; };
struct Ul_Vp_BFu17i { unsigned long long v1; void * v2; unsigned int v3:17; };
struct Ul_Vp_BFu17ll { unsigned long long v1; void * v2; unsigned long long v3:17; };
struct Ul_Vp_BFu1c { unsigned long long v1; void * v2; unsigned char v3:1; };
struct Ul_Vp_BFu1i { unsigned long long v1; void * v2; unsigned int v3:1; };
struct Ul_Vp_BFu1ll { unsigned long long v1; void * v2; unsigned long long v3:1; };
struct Ul_Vp_BFu1s { unsigned long long v1; void * v2; unsigned short v3:1; };
struct Ul_Vp_BFu31i { unsigned long long v1; void * v2; unsigned int v3:31; };
struct Ul_Vp_BFu31ll { unsigned long long v1; void * v2; unsigned long long v3:31; };
struct Ul_Vp_BFu32i { unsigned long long v1; void * v2; unsigned int v3:32; };
struct Ul_Vp_BFu32ll { unsigned long long v1; void * v2; unsigned long long v3:32; };
struct Ul_Vp_BFu33 { unsigned long long v1; void * v2; unsigned long long v3:33; };
struct Ul_Vp_BFu7c { unsigned long long v1; void * v2; unsigned char v3:7; };
struct Ul_Vp_BFu7i { unsigned long long v1; void * v2; unsigned int v3:7; };
struct Ul_Vp_BFu7ll { unsigned long long v1; void * v2; unsigned long long v3:7; };
struct Ul_Vp_BFu7s { unsigned long long v1; void * v2; unsigned short v3:7; };
struct Ul_Vp_BFu8c { unsigned long long v1; void * v2; unsigned char v3:8; };
struct Ul_Vp_BFu8i { unsigned long long v1; void * v2; unsigned int v3:8; };
struct Ul_Vp_BFu8ll { unsigned long long v1; void * v2; unsigned long long v3:8; };
struct Ul_Vp_BFu8s { unsigned long long v1; void * v2; unsigned short v3:8; };
struct Ul_Vp_BFu9i { unsigned long long v1; void * v2; unsigned int v3:9; };
struct Ul_Vp_BFu9ll { unsigned long long v1; void * v2; unsigned long long v3:9; };
struct Ul_Vp_BFu9s { unsigned long long v1; void * v2; unsigned short v3:9; };
struct Ul_Vp_C { unsigned long long v1; void * v2; char v3; };
struct Ul_Vp_D { unsigned long long v1; void * v2; double v3; };
struct Ul_Vp_F { unsigned long long v1; void * v2; float v3; };
struct Ul_Vp_I { unsigned long long v1; void * v2; int v3; };
struct Ul_Vp_Ip { unsigned long long v1; void * v2; int * v3; };
struct Ul_Vp_L { unsigned long long v1; void * v2; long long v3; };
struct Ul_Vp_S { unsigned long long v1; void * v2; short v3; };
struct Ul_Vp_Uc { unsigned long long v1; void * v2; unsigned char v3; };
struct Ul_Vp_Ui { unsigned long long v1; void * v2; unsigned int v3; };
struct Ul_Vp_Ul { unsigned long long v1; void * v2; unsigned long long v3; };
struct Ul_Vp_Us { unsigned long long v1; void * v2; unsigned short v3; };
struct Ul_Vp_Vp { unsigned long long v1; void * v2; void * v3; };
struct Us { unsigned short v1; };
struct Us_BFu15i { unsigned short v1; unsigned int v2:15; };
struct Us_BFu15i_BFu15i { unsigned short v1; unsigned int v2:15; unsigned int v3:15; };
struct Us_BFu15i_BFu15ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:15; };
struct Us_BFu15i_BFu15s { unsigned short v1; unsigned int v2:15; unsigned short v3:15; };
struct Us_BFu15i_BFu16i { unsigned short v1; unsigned int v2:15; unsigned int v3:16; };
struct Us_BFu15i_BFu16ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:16; };
struct Us_BFu15i_BFu16s { unsigned short v1; unsigned int v2:15; unsigned short v3:16; };
struct Us_BFu15i_BFu17i { unsigned short v1; unsigned int v2:15; unsigned int v3:17; };
struct Us_BFu15i_BFu17ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:17; };
struct Us_BFu15i_BFu1c { unsigned short v1; unsigned int v2:15; unsigned char v3:1; };
struct Us_BFu15i_BFu1i { unsigned short v1; unsigned int v2:15; unsigned int v3:1; };
struct Us_BFu15i_BFu1ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:1; };
struct Us_BFu15i_BFu1s { unsigned short v1; unsigned int v2:15; unsigned short v3:1; };
struct Us_BFu15i_BFu31i { unsigned short v1; unsigned int v2:15; unsigned int v3:31; };
struct Us_BFu15i_BFu31ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:31; };
struct Us_BFu15i_BFu32i { unsigned short v1; unsigned int v2:15; unsigned int v3:32; };
struct Us_BFu15i_BFu32ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:32; };
struct Us_BFu15i_BFu33 { unsigned short v1; unsigned int v2:15; unsigned long long v3:33; };
struct Us_BFu15i_BFu7c { unsigned short v1; unsigned int v2:15; unsigned char v3:7; };
struct Us_BFu15i_BFu7i { unsigned short v1; unsigned int v2:15; unsigned int v3:7; };
struct Us_BFu15i_BFu7ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:7; };
struct Us_BFu15i_BFu7s { unsigned short v1; unsigned int v2:15; unsigned short v3:7; };
struct Us_BFu15i_BFu8c { unsigned short v1; unsigned int v2:15; unsigned char v3:8; };
struct Us_BFu15i_BFu8i { unsigned short v1; unsigned int v2:15; unsigned int v3:8; };
struct Us_BFu15i_BFu8ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:8; };
struct Us_BFu15i_BFu8s { unsigned short v1; unsigned int v2:15; unsigned short v3:8; };
struct Us_BFu15i_BFu9i { unsigned short v1; unsigned int v2:15; unsigned int v3:9; };
struct Us_BFu15i_BFu9ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:9; };
struct Us_BFu15i_BFu9s { unsigned short v1; unsigned int v2:15; unsigned short v3:9; };
struct Us_BFu15i_C { unsigned short v1; unsigned int v2:15; char v3; };
struct Us_BFu15i_D { unsigned short v1; unsigned int v2:15; double v3; };
struct Us_BFu15i_F { unsigned short v1; unsigned int v2:15; float v3; };
struct Us_BFu15i_I { unsigned short v1; unsigned int v2:15; int v3; };
struct Us_BFu15i_Ip { unsigned short v1; unsigned int v2:15; int * v3; };
struct Us_BFu15i_L { unsigned short v1; unsigned int v2:15; long long v3; };
struct Us_BFu15i_S { unsigned short v1; unsigned int v2:15; short v3; };
struct Us_BFu15i_Uc { unsigned short v1; unsigned int v2:15; unsigned char v3; };
struct Us_BFu15i_Ui { unsigned short v1; unsigned int v2:15; unsigned int v3; };
struct Us_BFu15i_Ul { unsigned short v1; unsigned int v2:15; unsigned long long v3; };
struct Us_BFu15i_Us { unsigned short v1; unsigned int v2:15; unsigned short v3; };
struct Us_BFu15i_Vp { unsigned short v1; unsigned int v2:15; void * v3; };
struct Us_BFu15ll { unsigned short v1; unsigned long long v2:15; };
struct Us_BFu15ll_BFu15i { unsigned short v1; unsigned long long v2:15; unsigned int v3:15; };
struct Us_BFu15ll_BFu15ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:15; };
struct Us_BFu15ll_BFu15s { unsigned short v1; unsigned long long v2:15; unsigned short v3:15; };
struct Us_BFu15ll_BFu16i { unsigned short v1; unsigned long long v2:15; unsigned int v3:16; };
struct Us_BFu15ll_BFu16ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:16; };
struct Us_BFu15ll_BFu16s { unsigned short v1; unsigned long long v2:15; unsigned short v3:16; };
struct Us_BFu15ll_BFu17i { unsigned short v1; unsigned long long v2:15; unsigned int v3:17; };
struct Us_BFu15ll_BFu17ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:17; };
struct Us_BFu15ll_BFu1c { unsigned short v1; unsigned long long v2:15; unsigned char v3:1; };
struct Us_BFu15ll_BFu1i { unsigned short v1; unsigned long long v2:15; unsigned int v3:1; };
struct Us_BFu15ll_BFu1ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:1; };
struct Us_BFu15ll_BFu1s { unsigned short v1; unsigned long long v2:15; unsigned short v3:1; };
struct Us_BFu15ll_BFu31i { unsigned short v1; unsigned long long v2:15; unsigned int v3:31; };
struct Us_BFu15ll_BFu31ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:31; };
struct Us_BFu15ll_BFu32i { unsigned short v1; unsigned long long v2:15; unsigned int v3:32; };
struct Us_BFu15ll_BFu32ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:32; };
struct Us_BFu15ll_BFu33 { unsigned short v1; unsigned long long v2:15; unsigned long long v3:33; };
struct Us_BFu15ll_BFu7c { unsigned short v1; unsigned long long v2:15; unsigned char v3:7; };
struct Us_BFu15ll_BFu7i { unsigned short v1; unsigned long long v2:15; unsigned int v3:7; };
struct Us_BFu15ll_BFu7ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:7; };
struct Us_BFu15ll_BFu7s { unsigned short v1; unsigned long long v2:15; unsigned short v3:7; };
struct Us_BFu15ll_BFu8c { unsigned short v1; unsigned long long v2:15; unsigned char v3:8; };
struct Us_BFu15ll_BFu8i { unsigned short v1; unsigned long long v2:15; unsigned int v3:8; };
struct Us_BFu15ll_BFu8ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:8; };
struct Us_BFu15ll_BFu8s { unsigned short v1; unsigned long long v2:15; unsigned short v3:8; };
struct Us_BFu15ll_BFu9i { unsigned short v1; unsigned long long v2:15; unsigned int v3:9; };
struct Us_BFu15ll_BFu9ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:9; };
struct Us_BFu15ll_BFu9s { unsigned short v1; unsigned long long v2:15; unsigned short v3:9; };
struct Us_BFu15ll_C { unsigned short v1; unsigned long long v2:15; char v3; };
struct Us_BFu15ll_D { unsigned short v1; unsigned long long v2:15; double v3; };
struct Us_BFu15ll_F { unsigned short v1; unsigned long long v2:15; float v3; };
struct Us_BFu15ll_I { unsigned short v1; unsigned long long v2:15; int v3; };
struct Us_BFu15ll_Ip { unsigned short v1; unsigned long long v2:15; int * v3; };
struct Us_BFu15ll_L { unsigned short v1; unsigned long long v2:15; long long v3; };
struct Us_BFu15ll_S { unsigned short v1; unsigned long long v2:15; short v3; };
struct Us_BFu15ll_Uc { unsigned short v1; unsigned long long v2:15; unsigned char v3; };
struct Us_BFu15ll_Ui { unsigned short v1; unsigned long long v2:15; unsigned int v3; };
struct Us_BFu15ll_Ul { unsigned short v1; unsigned long long v2:15; unsigned long long v3; };
struct Us_BFu15ll_Us { unsigned short v1; unsigned long long v2:15; unsigned short v3; };
struct Us_BFu15ll_Vp { unsigned short v1; unsigned long long v2:15; void * v3; };
struct Us_BFu15s { unsigned short v1; unsigned short v2:15; };
struct Us_BFu15s_BFu15i { unsigned short v1; unsigned short v2:15; unsigned int v3:15; };
struct Us_BFu15s_BFu15ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:15; };
struct Us_BFu15s_BFu15s { unsigned short v1; unsigned short v2:15; unsigned short v3:15; };
struct Us_BFu15s_BFu16i { unsigned short v1; unsigned short v2:15; unsigned int v3:16; };
struct Us_BFu15s_BFu16ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:16; };
struct Us_BFu15s_BFu16s { unsigned short v1; unsigned short v2:15; unsigned short v3:16; };
struct Us_BFu15s_BFu17i { unsigned short v1; unsigned short v2:15; unsigned int v3:17; };
struct Us_BFu15s_BFu17ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:17; };
struct Us_BFu15s_BFu1c { unsigned short v1; unsigned short v2:15; unsigned char v3:1; };
struct Us_BFu15s_BFu1i { unsigned short v1; unsigned short v2:15; unsigned int v3:1; };
struct Us_BFu15s_BFu1ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:1; };
struct Us_BFu15s_BFu1s { unsigned short v1; unsigned short v2:15; unsigned short v3:1; };
struct Us_BFu15s_BFu31i { unsigned short v1; unsigned short v2:15; unsigned int v3:31; };
struct Us_BFu15s_BFu31ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:31; };
struct Us_BFu15s_BFu32i { unsigned short v1; unsigned short v2:15; unsigned int v3:32; };
struct Us_BFu15s_BFu32ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:32; };
struct Us_BFu15s_BFu33 { unsigned short v1; unsigned short v2:15; unsigned long long v3:33; };
struct Us_BFu15s_BFu7c { unsigned short v1; unsigned short v2:15; unsigned char v3:7; };
struct Us_BFu15s_BFu7i { unsigned short v1; unsigned short v2:15; unsigned int v3:7; };
struct Us_BFu15s_BFu7ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:7; };
struct Us_BFu15s_BFu7s { unsigned short v1; unsigned short v2:15; unsigned short v3:7; };
struct Us_BFu15s_BFu8c { unsigned short v1; unsigned short v2:15; unsigned char v3:8; };
struct Us_BFu15s_BFu8i { unsigned short v1; unsigned short v2:15; unsigned int v3:8; };
struct Us_BFu15s_BFu8ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:8; };
struct Us_BFu15s_BFu8s { unsigned short v1; unsigned short v2:15; unsigned short v3:8; };
struct Us_BFu15s_BFu9i { unsigned short v1; unsigned short v2:15; unsigned int v3:9; };
struct Us_BFu15s_BFu9ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:9; };
struct Us_BFu15s_BFu9s { unsigned short v1; unsigned short v2:15; unsigned short v3:9; };
struct Us_BFu15s_C { unsigned short v1; unsigned short v2:15; char v3; };
struct Us_BFu15s_D { unsigned short v1; unsigned short v2:15; double v3; };
struct Us_BFu15s_F { unsigned short v1; unsigned short v2:15; float v3; };
struct Us_BFu15s_I { unsigned short v1; unsigned short v2:15; int v3; };
struct Us_BFu15s_Ip { unsigned short v1; unsigned short v2:15; int * v3; };
struct Us_BFu15s_L { unsigned short v1; unsigned short v2:15; long long v3; };
struct Us_BFu15s_S { unsigned short v1; unsigned short v2:15; short v3; };
struct Us_BFu15s_Uc { unsigned short v1; unsigned short v2:15; unsigned char v3; };
struct Us_BFu15s_Ui { unsigned short v1; unsigned short v2:15; unsigned int v3; };
struct Us_BFu15s_Ul { unsigned short v1; unsigned short v2:15; unsigned long long v3; };
struct Us_BFu15s_Us { unsigned short v1; unsigned short v2:15; unsigned short v3; };
struct Us_BFu15s_Vp { unsigned short v1; unsigned short v2:15; void * v3; };
struct Us_BFu16i { unsigned short v1; unsigned int v2:16; };
struct Us_BFu16i_BFu15i { unsigned short v1; unsigned int v2:16; unsigned int v3:15; };
struct Us_BFu16i_BFu15ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:15; };
struct Us_BFu16i_BFu15s { unsigned short v1; unsigned int v2:16; unsigned short v3:15; };
struct Us_BFu16i_BFu16i { unsigned short v1; unsigned int v2:16; unsigned int v3:16; };
struct Us_BFu16i_BFu16ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:16; };
struct Us_BFu16i_BFu16s { unsigned short v1; unsigned int v2:16; unsigned short v3:16; };
struct Us_BFu16i_BFu17i { unsigned short v1; unsigned int v2:16; unsigned int v3:17; };
struct Us_BFu16i_BFu17ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:17; };
struct Us_BFu16i_BFu1c { unsigned short v1; unsigned int v2:16; unsigned char v3:1; };
struct Us_BFu16i_BFu1i { unsigned short v1; unsigned int v2:16; unsigned int v3:1; };
struct Us_BFu16i_BFu1ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:1; };
struct Us_BFu16i_BFu1s { unsigned short v1; unsigned int v2:16; unsigned short v3:1; };
struct Us_BFu16i_BFu31i { unsigned short v1; unsigned int v2:16; unsigned int v3:31; };
struct Us_BFu16i_BFu31ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:31; };
struct Us_BFu16i_BFu32i { unsigned short v1; unsigned int v2:16; unsigned int v3:32; };
struct Us_BFu16i_BFu32ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:32; };
struct Us_BFu16i_BFu33 { unsigned short v1; unsigned int v2:16; unsigned long long v3:33; };
struct Us_BFu16i_BFu7c { unsigned short v1; unsigned int v2:16; unsigned char v3:7; };
struct Us_BFu16i_BFu7i { unsigned short v1; unsigned int v2:16; unsigned int v3:7; };
struct Us_BFu16i_BFu7ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:7; };
struct Us_BFu16i_BFu7s { unsigned short v1; unsigned int v2:16; unsigned short v3:7; };
struct Us_BFu16i_BFu8c { unsigned short v1; unsigned int v2:16; unsigned char v3:8; };
struct Us_BFu16i_BFu8i { unsigned short v1; unsigned int v2:16; unsigned int v3:8; };
struct Us_BFu16i_BFu8ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:8; };
struct Us_BFu16i_BFu8s { unsigned short v1; unsigned int v2:16; unsigned short v3:8; };
struct Us_BFu16i_BFu9i { unsigned short v1; unsigned int v2:16; unsigned int v3:9; };
struct Us_BFu16i_BFu9ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:9; };
struct Us_BFu16i_BFu9s { unsigned short v1; unsigned int v2:16; unsigned short v3:9; };
struct Us_BFu16i_C { unsigned short v1; unsigned int v2:16; char v3; };
struct Us_BFu16i_D { unsigned short v1; unsigned int v2:16; double v3; };
struct Us_BFu16i_F { unsigned short v1; unsigned int v2:16; float v3; };
struct Us_BFu16i_I { unsigned short v1; unsigned int v2:16; int v3; };
struct Us_BFu16i_Ip { unsigned short v1; unsigned int v2:16; int * v3; };
struct Us_BFu16i_L { unsigned short v1; unsigned int v2:16; long long v3; };
struct Us_BFu16i_S { unsigned short v1; unsigned int v2:16; short v3; };
struct Us_BFu16i_Uc { unsigned short v1; unsigned int v2:16; unsigned char v3; };
struct Us_BFu16i_Ui { unsigned short v1; unsigned int v2:16; unsigned int v3; };
struct Us_BFu16i_Ul { unsigned short v1; unsigned int v2:16; unsigned long long v3; };
struct Us_BFu16i_Us { unsigned short v1; unsigned int v2:16; unsigned short v3; };
struct Us_BFu16i_Vp { unsigned short v1; unsigned int v2:16; void * v3; };
struct Us_BFu16ll { unsigned short v1; unsigned long long v2:16; };
struct Us_BFu16ll_BFu15i { unsigned short v1; unsigned long long v2:16; unsigned int v3:15; };
struct Us_BFu16ll_BFu15ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:15; };
struct Us_BFu16ll_BFu15s { unsigned short v1; unsigned long long v2:16; unsigned short v3:15; };
struct Us_BFu16ll_BFu16i { unsigned short v1; unsigned long long v2:16; unsigned int v3:16; };
struct Us_BFu16ll_BFu16ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:16; };
struct Us_BFu16ll_BFu16s { unsigned short v1; unsigned long long v2:16; unsigned short v3:16; };
struct Us_BFu16ll_BFu17i { unsigned short v1; unsigned long long v2:16; unsigned int v3:17; };
struct Us_BFu16ll_BFu17ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:17; };
struct Us_BFu16ll_BFu1c { unsigned short v1; unsigned long long v2:16; unsigned char v3:1; };
struct Us_BFu16ll_BFu1i { unsigned short v1; unsigned long long v2:16; unsigned int v3:1; };
struct Us_BFu16ll_BFu1ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:1; };
struct Us_BFu16ll_BFu1s { unsigned short v1; unsigned long long v2:16; unsigned short v3:1; };
struct Us_BFu16ll_BFu31i { unsigned short v1; unsigned long long v2:16; unsigned int v3:31; };
struct Us_BFu16ll_BFu31ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:31; };
struct Us_BFu16ll_BFu32i { unsigned short v1; unsigned long long v2:16; unsigned int v3:32; };
struct Us_BFu16ll_BFu32ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:32; };
struct Us_BFu16ll_BFu33 { unsigned short v1; unsigned long long v2:16; unsigned long long v3:33; };
struct Us_BFu16ll_BFu7c { unsigned short v1; unsigned long long v2:16; unsigned char v3:7; };
struct Us_BFu16ll_BFu7i { unsigned short v1; unsigned long long v2:16; unsigned int v3:7; };
struct Us_BFu16ll_BFu7ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:7; };
struct Us_BFu16ll_BFu7s { unsigned short v1; unsigned long long v2:16; unsigned short v3:7; };
struct Us_BFu16ll_BFu8c { unsigned short v1; unsigned long long v2:16; unsigned char v3:8; };
struct Us_BFu16ll_BFu8i { unsigned short v1; unsigned long long v2:16; unsigned int v3:8; };
struct Us_BFu16ll_BFu8ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:8; };
struct Us_BFu16ll_BFu8s { unsigned short v1; unsigned long long v2:16; unsigned short v3:8; };
struct Us_BFu16ll_BFu9i { unsigned short v1; unsigned long long v2:16; unsigned int v3:9; };
struct Us_BFu16ll_BFu9ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:9; };
struct Us_BFu16ll_BFu9s { unsigned short v1; unsigned long long v2:16; unsigned short v3:9; };
struct Us_BFu16ll_C { unsigned short v1; unsigned long long v2:16; char v3; };
struct Us_BFu16ll_D { unsigned short v1; unsigned long long v2:16; double v3; };
struct Us_BFu16ll_F { unsigned short v1; unsigned long long v2:16; float v3; };
struct Us_BFu16ll_I { unsigned short v1; unsigned long long v2:16; int v3; };
struct Us_BFu16ll_Ip { unsigned short v1; unsigned long long v2:16; int * v3; };
struct Us_BFu16ll_L { unsigned short v1; unsigned long long v2:16; long long v3; };
struct Us_BFu16ll_S { unsigned short v1; unsigned long long v2:16; short v3; };
struct Us_BFu16ll_Uc { unsigned short v1; unsigned long long v2:16; unsigned char v3; };
struct Us_BFu16ll_Ui { unsigned short v1; unsigned long long v2:16; unsigned int v3; };
struct Us_BFu16ll_Ul { unsigned short v1; unsigned long long v2:16; unsigned long long v3; };
struct Us_BFu16ll_Us { unsigned short v1; unsigned long long v2:16; unsigned short v3; };
struct Us_BFu16ll_Vp { unsigned short v1; unsigned long long v2:16; void * v3; };
struct Us_BFu16s { unsigned short v1; unsigned short v2:16; };
struct Us_BFu16s_BFu15i { unsigned short v1; unsigned short v2:16; unsigned int v3:15; };
struct Us_BFu16s_BFu15ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:15; };
struct Us_BFu16s_BFu15s { unsigned short v1; unsigned short v2:16; unsigned short v3:15; };
struct Us_BFu16s_BFu16i { unsigned short v1; unsigned short v2:16; unsigned int v3:16; };
struct Us_BFu16s_BFu16ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:16; };
struct Us_BFu16s_BFu16s { unsigned short v1; unsigned short v2:16; unsigned short v3:16; };
struct Us_BFu16s_BFu17i { unsigned short v1; unsigned short v2:16; unsigned int v3:17; };
struct Us_BFu16s_BFu17ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:17; };
struct Us_BFu16s_BFu1c { unsigned short v1; unsigned short v2:16; unsigned char v3:1; };
struct Us_BFu16s_BFu1i { unsigned short v1; unsigned short v2:16; unsigned int v3:1; };
struct Us_BFu16s_BFu1ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:1; };
struct Us_BFu16s_BFu1s { unsigned short v1; unsigned short v2:16; unsigned short v3:1; };
struct Us_BFu16s_BFu31i { unsigned short v1; unsigned short v2:16; unsigned int v3:31; };
struct Us_BFu16s_BFu31ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:31; };
struct Us_BFu16s_BFu32i { unsigned short v1; unsigned short v2:16; unsigned int v3:32; };
struct Us_BFu16s_BFu32ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:32; };
struct Us_BFu16s_BFu33 { unsigned short v1; unsigned short v2:16; unsigned long long v3:33; };
struct Us_BFu16s_BFu7c { unsigned short v1; unsigned short v2:16; unsigned char v3:7; };
struct Us_BFu16s_BFu7i { unsigned short v1; unsigned short v2:16; unsigned int v3:7; };
struct Us_BFu16s_BFu7ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:7; };
struct Us_BFu16s_BFu7s { unsigned short v1; unsigned short v2:16; unsigned short v3:7; };
struct Us_BFu16s_BFu8c { unsigned short v1; unsigned short v2:16; unsigned char v3:8; };
struct Us_BFu16s_BFu8i { unsigned short v1; unsigned short v2:16; unsigned int v3:8; };
struct Us_BFu16s_BFu8ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:8; };
struct Us_BFu16s_BFu8s { unsigned short v1; unsigned short v2:16; unsigned short v3:8; };
struct Us_BFu16s_BFu9i { unsigned short v1; unsigned short v2:16; unsigned int v3:9; };
struct Us_BFu16s_BFu9ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:9; };
struct Us_BFu16s_BFu9s { unsigned short v1; unsigned short v2:16; unsigned short v3:9; };
struct Us_BFu16s_C { unsigned short v1; unsigned short v2:16; char v3; };
struct Us_BFu16s_D { unsigned short v1; unsigned short v2:16; double v3; };
struct Us_BFu16s_F { unsigned short v1; unsigned short v2:16; float v3; };
struct Us_BFu16s_I { unsigned short v1; unsigned short v2:16; int v3; };
struct Us_BFu16s_Ip { unsigned short v1; unsigned short v2:16; int * v3; };
struct Us_BFu16s_L { unsigned short v1; unsigned short v2:16; long long v3; };
struct Us_BFu16s_S { unsigned short v1; unsigned short v2:16; short v3; };
struct Us_BFu16s_Uc { unsigned short v1; unsigned short v2:16; unsigned char v3; };
struct Us_BFu16s_Ui { unsigned short v1; unsigned short v2:16; unsigned int v3; };
struct Us_BFu16s_Ul { unsigned short v1; unsigned short v2:16; unsigned long long v3; };
struct Us_BFu16s_Us { unsigned short v1; unsigned short v2:16; unsigned short v3; };
struct Us_BFu16s_Vp { unsigned short v1; unsigned short v2:16; void * v3; };
struct Us_BFu17i { unsigned short v1; unsigned int v2:17; };
struct Us_BFu17i_BFu15i { unsigned short v1; unsigned int v2:17; unsigned int v3:15; };
struct Us_BFu17i_BFu15ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:15; };
struct Us_BFu17i_BFu15s { unsigned short v1; unsigned int v2:17; unsigned short v3:15; };
struct Us_BFu17i_BFu16i { unsigned short v1; unsigned int v2:17; unsigned int v3:16; };
struct Us_BFu17i_BFu16ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:16; };
struct Us_BFu17i_BFu16s { unsigned short v1; unsigned int v2:17; unsigned short v3:16; };
struct Us_BFu17i_BFu17i { unsigned short v1; unsigned int v2:17; unsigned int v3:17; };
struct Us_BFu17i_BFu17ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:17; };
struct Us_BFu17i_BFu1c { unsigned short v1; unsigned int v2:17; unsigned char v3:1; };
struct Us_BFu17i_BFu1i { unsigned short v1; unsigned int v2:17; unsigned int v3:1; };
struct Us_BFu17i_BFu1ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:1; };
struct Us_BFu17i_BFu1s { unsigned short v1; unsigned int v2:17; unsigned short v3:1; };
struct Us_BFu17i_BFu31i { unsigned short v1; unsigned int v2:17; unsigned int v3:31; };
struct Us_BFu17i_BFu31ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:31; };
struct Us_BFu17i_BFu32i { unsigned short v1; unsigned int v2:17; unsigned int v3:32; };
struct Us_BFu17i_BFu32ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:32; };
struct Us_BFu17i_BFu33 { unsigned short v1; unsigned int v2:17; unsigned long long v3:33; };
struct Us_BFu17i_BFu7c { unsigned short v1; unsigned int v2:17; unsigned char v3:7; };
struct Us_BFu17i_BFu7i { unsigned short v1; unsigned int v2:17; unsigned int v3:7; };
struct Us_BFu17i_BFu7ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:7; };
struct Us_BFu17i_BFu7s { unsigned short v1; unsigned int v2:17; unsigned short v3:7; };
struct Us_BFu17i_BFu8c { unsigned short v1; unsigned int v2:17; unsigned char v3:8; };
struct Us_BFu17i_BFu8i { unsigned short v1; unsigned int v2:17; unsigned int v3:8; };
struct Us_BFu17i_BFu8ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:8; };
struct Us_BFu17i_BFu8s { unsigned short v1; unsigned int v2:17; unsigned short v3:8; };
struct Us_BFu17i_BFu9i { unsigned short v1; unsigned int v2:17; unsigned int v3:9; };
struct Us_BFu17i_BFu9ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:9; };
struct Us_BFu17i_BFu9s { unsigned short v1; unsigned int v2:17; unsigned short v3:9; };
struct Us_BFu17i_C { unsigned short v1; unsigned int v2:17; char v3; };
struct Us_BFu17i_D { unsigned short v1; unsigned int v2:17; double v3; };
struct Us_BFu17i_F { unsigned short v1; unsigned int v2:17; float v3; };
struct Us_BFu17i_I { unsigned short v1; unsigned int v2:17; int v3; };
struct Us_BFu17i_Ip { unsigned short v1; unsigned int v2:17; int * v3; };
struct Us_BFu17i_L { unsigned short v1; unsigned int v2:17; long long v3; };
struct Us_BFu17i_S { unsigned short v1; unsigned int v2:17; short v3; };
struct Us_BFu17i_Uc { unsigned short v1; unsigned int v2:17; unsigned char v3; };
struct Us_BFu17i_Ui { unsigned short v1; unsigned int v2:17; unsigned int v3; };
struct Us_BFu17i_Ul { unsigned short v1; unsigned int v2:17; unsigned long long v3; };
struct Us_BFu17i_Us { unsigned short v1; unsigned int v2:17; unsigned short v3; };
struct Us_BFu17i_Vp { unsigned short v1; unsigned int v2:17; void * v3; };
struct Us_BFu17ll { unsigned short v1; unsigned long long v2:17; };
struct Us_BFu17ll_BFu15i { unsigned short v1; unsigned long long v2:17; unsigned int v3:15; };
struct Us_BFu17ll_BFu15ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:15; };
struct Us_BFu17ll_BFu15s { unsigned short v1; unsigned long long v2:17; unsigned short v3:15; };
struct Us_BFu17ll_BFu16i { unsigned short v1; unsigned long long v2:17; unsigned int v3:16; };
struct Us_BFu17ll_BFu16ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:16; };
struct Us_BFu17ll_BFu16s { unsigned short v1; unsigned long long v2:17; unsigned short v3:16; };
struct Us_BFu17ll_BFu17i { unsigned short v1; unsigned long long v2:17; unsigned int v3:17; };
struct Us_BFu17ll_BFu17ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:17; };
struct Us_BFu17ll_BFu1c { unsigned short v1; unsigned long long v2:17; unsigned char v3:1; };
struct Us_BFu17ll_BFu1i { unsigned short v1; unsigned long long v2:17; unsigned int v3:1; };
struct Us_BFu17ll_BFu1ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:1; };
struct Us_BFu17ll_BFu1s { unsigned short v1; unsigned long long v2:17; unsigned short v3:1; };
struct Us_BFu17ll_BFu31i { unsigned short v1; unsigned long long v2:17; unsigned int v3:31; };
struct Us_BFu17ll_BFu31ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:31; };
struct Us_BFu17ll_BFu32i { unsigned short v1; unsigned long long v2:17; unsigned int v3:32; };
struct Us_BFu17ll_BFu32ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:32; };
struct Us_BFu17ll_BFu33 { unsigned short v1; unsigned long long v2:17; unsigned long long v3:33; };
struct Us_BFu17ll_BFu7c { unsigned short v1; unsigned long long v2:17; unsigned char v3:7; };
struct Us_BFu17ll_BFu7i { unsigned short v1; unsigned long long v2:17; unsigned int v3:7; };
struct Us_BFu17ll_BFu7ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:7; };
struct Us_BFu17ll_BFu7s { unsigned short v1; unsigned long long v2:17; unsigned short v3:7; };
struct Us_BFu17ll_BFu8c { unsigned short v1; unsigned long long v2:17; unsigned char v3:8; };
struct Us_BFu17ll_BFu8i { unsigned short v1; unsigned long long v2:17; unsigned int v3:8; };
struct Us_BFu17ll_BFu8ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:8; };
struct Us_BFu17ll_BFu8s { unsigned short v1; unsigned long long v2:17; unsigned short v3:8; };
struct Us_BFu17ll_BFu9i { unsigned short v1; unsigned long long v2:17; unsigned int v3:9; };
struct Us_BFu17ll_BFu9ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:9; };
struct Us_BFu17ll_BFu9s { unsigned short v1; unsigned long long v2:17; unsigned short v3:9; };
struct Us_BFu17ll_C { unsigned short v1; unsigned long long v2:17; char v3; };
struct Us_BFu17ll_D { unsigned short v1; unsigned long long v2:17; double v3; };
struct Us_BFu17ll_F { unsigned short v1; unsigned long long v2:17; float v3; };
struct Us_BFu17ll_I { unsigned short v1; unsigned long long v2:17; int v3; };
struct Us_BFu17ll_Ip { unsigned short v1; unsigned long long v2:17; int * v3; };
struct Us_BFu17ll_L { unsigned short v1; unsigned long long v2:17; long long v3; };
struct Us_BFu17ll_S { unsigned short v1; unsigned long long v2:17; short v3; };
struct Us_BFu17ll_Uc { unsigned short v1; unsigned long long v2:17; unsigned char v3; };
struct Us_BFu17ll_Ui { unsigned short v1; unsigned long long v2:17; unsigned int v3; };
struct Us_BFu17ll_Ul { unsigned short v1; unsigned long long v2:17; unsigned long long v3; };
struct Us_BFu17ll_Us { unsigned short v1; unsigned long long v2:17; unsigned short v3; };
struct Us_BFu17ll_Vp { unsigned short v1; unsigned long long v2:17; void * v3; };
struct Us_BFu1c { unsigned short v1; unsigned char v2:1; };
struct Us_BFu1c_BFu15i { unsigned short v1; unsigned char v2:1; unsigned int v3:15; };
struct Us_BFu1c_BFu15ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:15; };
struct Us_BFu1c_BFu15s { unsigned short v1; unsigned char v2:1; unsigned short v3:15; };
struct Us_BFu1c_BFu16i { unsigned short v1; unsigned char v2:1; unsigned int v3:16; };
struct Us_BFu1c_BFu16ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:16; };
struct Us_BFu1c_BFu16s { unsigned short v1; unsigned char v2:1; unsigned short v3:16; };
struct Us_BFu1c_BFu17i { unsigned short v1; unsigned char v2:1; unsigned int v3:17; };
struct Us_BFu1c_BFu17ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:17; };
struct Us_BFu1c_BFu1c { unsigned short v1; unsigned char v2:1; unsigned char v3:1; };
struct Us_BFu1c_BFu1i { unsigned short v1; unsigned char v2:1; unsigned int v3:1; };
struct Us_BFu1c_BFu1ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:1; };
struct Us_BFu1c_BFu1s { unsigned short v1; unsigned char v2:1; unsigned short v3:1; };
struct Us_BFu1c_BFu31i { unsigned short v1; unsigned char v2:1; unsigned int v3:31; };
struct Us_BFu1c_BFu31ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:31; };
struct Us_BFu1c_BFu32i { unsigned short v1; unsigned char v2:1; unsigned int v3:32; };
struct Us_BFu1c_BFu32ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:32; };
struct Us_BFu1c_BFu33 { unsigned short v1; unsigned char v2:1; unsigned long long v3:33; };
struct Us_BFu1c_BFu7c { unsigned short v1; unsigned char v2:1; unsigned char v3:7; };
struct Us_BFu1c_BFu7i { unsigned short v1; unsigned char v2:1; unsigned int v3:7; };
struct Us_BFu1c_BFu7ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:7; };
struct Us_BFu1c_BFu7s { unsigned short v1; unsigned char v2:1; unsigned short v3:7; };
struct Us_BFu1c_BFu8c { unsigned short v1; unsigned char v2:1; unsigned char v3:8; };
struct Us_BFu1c_BFu8i { unsigned short v1; unsigned char v2:1; unsigned int v3:8; };
struct Us_BFu1c_BFu8ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:8; };
struct Us_BFu1c_BFu8s { unsigned short v1; unsigned char v2:1; unsigned short v3:8; };
struct Us_BFu1c_BFu9i { unsigned short v1; unsigned char v2:1; unsigned int v3:9; };
struct Us_BFu1c_BFu9ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:9; };
struct Us_BFu1c_BFu9s { unsigned short v1; unsigned char v2:1; unsigned short v3:9; };
struct Us_BFu1c_C { unsigned short v1; unsigned char v2:1; char v3; };
struct Us_BFu1c_D { unsigned short v1; unsigned char v2:1; double v3; };
struct Us_BFu1c_F { unsigned short v1; unsigned char v2:1; float v3; };
struct Us_BFu1c_I { unsigned short v1; unsigned char v2:1; int v3; };
struct Us_BFu1c_Ip { unsigned short v1; unsigned char v2:1; int * v3; };
struct Us_BFu1c_L { unsigned short v1; unsigned char v2:1; long long v3; };
struct Us_BFu1c_S { unsigned short v1; unsigned char v2:1; short v3; };
struct Us_BFu1c_Uc { unsigned short v1; unsigned char v2:1; unsigned char v3; };
struct Us_BFu1c_Ui { unsigned short v1; unsigned char v2:1; unsigned int v3; };
struct Us_BFu1c_Ul { unsigned short v1; unsigned char v2:1; unsigned long long v3; };
struct Us_BFu1c_Us { unsigned short v1; unsigned char v2:1; unsigned short v3; };
struct Us_BFu1c_Vp { unsigned short v1; unsigned char v2:1; void * v3; };
struct Us_BFu1i { unsigned short v1; unsigned int v2:1; };
struct Us_BFu1i_BFu15i { unsigned short v1; unsigned int v2:1; unsigned int v3:15; };
struct Us_BFu1i_BFu15ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:15; };
struct Us_BFu1i_BFu15s { unsigned short v1; unsigned int v2:1; unsigned short v3:15; };
struct Us_BFu1i_BFu16i { unsigned short v1; unsigned int v2:1; unsigned int v3:16; };
struct Us_BFu1i_BFu16ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:16; };
struct Us_BFu1i_BFu16s { unsigned short v1; unsigned int v2:1; unsigned short v3:16; };
struct Us_BFu1i_BFu17i { unsigned short v1; unsigned int v2:1; unsigned int v3:17; };
struct Us_BFu1i_BFu17ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:17; };
struct Us_BFu1i_BFu1c { unsigned short v1; unsigned int v2:1; unsigned char v3:1; };
struct Us_BFu1i_BFu1i { unsigned short v1; unsigned int v2:1; unsigned int v3:1; };
struct Us_BFu1i_BFu1ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:1; };
struct Us_BFu1i_BFu1s { unsigned short v1; unsigned int v2:1; unsigned short v3:1; };
struct Us_BFu1i_BFu31i { unsigned short v1; unsigned int v2:1; unsigned int v3:31; };
struct Us_BFu1i_BFu31ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:31; };
struct Us_BFu1i_BFu32i { unsigned short v1; unsigned int v2:1; unsigned int v3:32; };
struct Us_BFu1i_BFu32ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:32; };
struct Us_BFu1i_BFu33 { unsigned short v1; unsigned int v2:1; unsigned long long v3:33; };
struct Us_BFu1i_BFu7c { unsigned short v1; unsigned int v2:1; unsigned char v3:7; };
struct Us_BFu1i_BFu7i { unsigned short v1; unsigned int v2:1; unsigned int v3:7; };
struct Us_BFu1i_BFu7ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:7; };
struct Us_BFu1i_BFu7s { unsigned short v1; unsigned int v2:1; unsigned short v3:7; };
struct Us_BFu1i_BFu8c { unsigned short v1; unsigned int v2:1; unsigned char v3:8; };
struct Us_BFu1i_BFu8i { unsigned short v1; unsigned int v2:1; unsigned int v3:8; };
struct Us_BFu1i_BFu8ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:8; };
struct Us_BFu1i_BFu8s { unsigned short v1; unsigned int v2:1; unsigned short v3:8; };
struct Us_BFu1i_BFu9i { unsigned short v1; unsigned int v2:1; unsigned int v3:9; };
struct Us_BFu1i_BFu9ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:9; };
struct Us_BFu1i_BFu9s { unsigned short v1; unsigned int v2:1; unsigned short v3:9; };
struct Us_BFu1i_C { unsigned short v1; unsigned int v2:1; char v3; };
struct Us_BFu1i_D { unsigned short v1; unsigned int v2:1; double v3; };
struct Us_BFu1i_F { unsigned short v1; unsigned int v2:1; float v3; };
struct Us_BFu1i_I { unsigned short v1; unsigned int v2:1; int v3; };
struct Us_BFu1i_Ip { unsigned short v1; unsigned int v2:1; int * v3; };
struct Us_BFu1i_L { unsigned short v1; unsigned int v2:1; long long v3; };
struct Us_BFu1i_S { unsigned short v1; unsigned int v2:1; short v3; };
struct Us_BFu1i_Uc { unsigned short v1; unsigned int v2:1; unsigned char v3; };
struct Us_BFu1i_Ui { unsigned short v1; unsigned int v2:1; unsigned int v3; };
struct Us_BFu1i_Ul { unsigned short v1; unsigned int v2:1; unsigned long long v3; };
struct Us_BFu1i_Us { unsigned short v1; unsigned int v2:1; unsigned short v3; };
struct Us_BFu1i_Vp { unsigned short v1; unsigned int v2:1; void * v3; };
struct Us_BFu1ll { unsigned short v1; unsigned long long v2:1; };
struct Us_BFu1ll_BFu15i { unsigned short v1; unsigned long long v2:1; unsigned int v3:15; };
struct Us_BFu1ll_BFu15ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:15; };
struct Us_BFu1ll_BFu15s { unsigned short v1; unsigned long long v2:1; unsigned short v3:15; };
struct Us_BFu1ll_BFu16i { unsigned short v1; unsigned long long v2:1; unsigned int v3:16; };
struct Us_BFu1ll_BFu16ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:16; };
struct Us_BFu1ll_BFu16s { unsigned short v1; unsigned long long v2:1; unsigned short v3:16; };
struct Us_BFu1ll_BFu17i { unsigned short v1; unsigned long long v2:1; unsigned int v3:17; };
struct Us_BFu1ll_BFu17ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:17; };
struct Us_BFu1ll_BFu1c { unsigned short v1; unsigned long long v2:1; unsigned char v3:1; };
struct Us_BFu1ll_BFu1i { unsigned short v1; unsigned long long v2:1; unsigned int v3:1; };
struct Us_BFu1ll_BFu1ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:1; };
struct Us_BFu1ll_BFu1s { unsigned short v1; unsigned long long v2:1; unsigned short v3:1; };
struct Us_BFu1ll_BFu31i { unsigned short v1; unsigned long long v2:1; unsigned int v3:31; };
struct Us_BFu1ll_BFu31ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:31; };
struct Us_BFu1ll_BFu32i { unsigned short v1; unsigned long long v2:1; unsigned int v3:32; };
struct Us_BFu1ll_BFu32ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:32; };
struct Us_BFu1ll_BFu33 { unsigned short v1; unsigned long long v2:1; unsigned long long v3:33; };
struct Us_BFu1ll_BFu7c { unsigned short v1; unsigned long long v2:1; unsigned char v3:7; };
struct Us_BFu1ll_BFu7i { unsigned short v1; unsigned long long v2:1; unsigned int v3:7; };
struct Us_BFu1ll_BFu7ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:7; };
struct Us_BFu1ll_BFu7s { unsigned short v1; unsigned long long v2:1; unsigned short v3:7; };
struct Us_BFu1ll_BFu8c { unsigned short v1; unsigned long long v2:1; unsigned char v3:8; };
struct Us_BFu1ll_BFu8i { unsigned short v1; unsigned long long v2:1; unsigned int v3:8; };
struct Us_BFu1ll_BFu8ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:8; };
struct Us_BFu1ll_BFu8s { unsigned short v1; unsigned long long v2:1; unsigned short v3:8; };
struct Us_BFu1ll_BFu9i { unsigned short v1; unsigned long long v2:1; unsigned int v3:9; };
struct Us_BFu1ll_BFu9ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:9; };
struct Us_BFu1ll_BFu9s { unsigned short v1; unsigned long long v2:1; unsigned short v3:9; };
struct Us_BFu1ll_C { unsigned short v1; unsigned long long v2:1; char v3; };
struct Us_BFu1ll_D { unsigned short v1; unsigned long long v2:1; double v3; };
struct Us_BFu1ll_F { unsigned short v1; unsigned long long v2:1; float v3; };
struct Us_BFu1ll_I { unsigned short v1; unsigned long long v2:1; int v3; };
struct Us_BFu1ll_Ip { unsigned short v1; unsigned long long v2:1; int * v3; };
struct Us_BFu1ll_L { unsigned short v1; unsigned long long v2:1; long long v3; };
struct Us_BFu1ll_S { unsigned short v1; unsigned long long v2:1; short v3; };
struct Us_BFu1ll_Uc { unsigned short v1; unsigned long long v2:1; unsigned char v3; };
struct Us_BFu1ll_Ui { unsigned short v1; unsigned long long v2:1; unsigned int v3; };
struct Us_BFu1ll_Ul { unsigned short v1; unsigned long long v2:1; unsigned long long v3; };
struct Us_BFu1ll_Us { unsigned short v1; unsigned long long v2:1; unsigned short v3; };
struct Us_BFu1ll_Vp { unsigned short v1; unsigned long long v2:1; void * v3; };
struct Us_BFu1s { unsigned short v1; unsigned short v2:1; };
struct Us_BFu1s_BFu15i { unsigned short v1; unsigned short v2:1; unsigned int v3:15; };
struct Us_BFu1s_BFu15ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:15; };
struct Us_BFu1s_BFu15s { unsigned short v1; unsigned short v2:1; unsigned short v3:15; };
struct Us_BFu1s_BFu16i { unsigned short v1; unsigned short v2:1; unsigned int v3:16; };
struct Us_BFu1s_BFu16ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:16; };
struct Us_BFu1s_BFu16s { unsigned short v1; unsigned short v2:1; unsigned short v3:16; };
struct Us_BFu1s_BFu17i { unsigned short v1; unsigned short v2:1; unsigned int v3:17; };
struct Us_BFu1s_BFu17ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:17; };
struct Us_BFu1s_BFu1c { unsigned short v1; unsigned short v2:1; unsigned char v3:1; };
struct Us_BFu1s_BFu1i { unsigned short v1; unsigned short v2:1; unsigned int v3:1; };
struct Us_BFu1s_BFu1ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:1; };
struct Us_BFu1s_BFu1s { unsigned short v1; unsigned short v2:1; unsigned short v3:1; };
struct Us_BFu1s_BFu31i { unsigned short v1; unsigned short v2:1; unsigned int v3:31; };
struct Us_BFu1s_BFu31ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:31; };
struct Us_BFu1s_BFu32i { unsigned short v1; unsigned short v2:1; unsigned int v3:32; };
struct Us_BFu1s_BFu32ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:32; };
struct Us_BFu1s_BFu33 { unsigned short v1; unsigned short v2:1; unsigned long long v3:33; };
struct Us_BFu1s_BFu7c { unsigned short v1; unsigned short v2:1; unsigned char v3:7; };
struct Us_BFu1s_BFu7i { unsigned short v1; unsigned short v2:1; unsigned int v3:7; };
struct Us_BFu1s_BFu7ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:7; };
struct Us_BFu1s_BFu7s { unsigned short v1; unsigned short v2:1; unsigned short v3:7; };
struct Us_BFu1s_BFu8c { unsigned short v1; unsigned short v2:1; unsigned char v3:8; };
struct Us_BFu1s_BFu8i { unsigned short v1; unsigned short v2:1; unsigned int v3:8; };
struct Us_BFu1s_BFu8ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:8; };
struct Us_BFu1s_BFu8s { unsigned short v1; unsigned short v2:1; unsigned short v3:8; };
struct Us_BFu1s_BFu9i { unsigned short v1; unsigned short v2:1; unsigned int v3:9; };
struct Us_BFu1s_BFu9ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:9; };
struct Us_BFu1s_BFu9s { unsigned short v1; unsigned short v2:1; unsigned short v3:9; };
struct Us_BFu1s_C { unsigned short v1; unsigned short v2:1; char v3; };
struct Us_BFu1s_D { unsigned short v1; unsigned short v2:1; double v3; };
struct Us_BFu1s_F { unsigned short v1; unsigned short v2:1; float v3; };
struct Us_BFu1s_I { unsigned short v1; unsigned short v2:1; int v3; };
struct Us_BFu1s_Ip { unsigned short v1; unsigned short v2:1; int * v3; };
struct Us_BFu1s_L { unsigned short v1; unsigned short v2:1; long long v3; };
struct Us_BFu1s_S { unsigned short v1; unsigned short v2:1; short v3; };
struct Us_BFu1s_Uc { unsigned short v1; unsigned short v2:1; unsigned char v3; };
struct Us_BFu1s_Ui { unsigned short v1; unsigned short v2:1; unsigned int v3; };
struct Us_BFu1s_Ul { unsigned short v1; unsigned short v2:1; unsigned long long v3; };
struct Us_BFu1s_Us { unsigned short v1; unsigned short v2:1; unsigned short v3; };
struct Us_BFu1s_Vp { unsigned short v1; unsigned short v2:1; void * v3; };
struct Us_BFu31i { unsigned short v1; unsigned int v2:31; };
struct Us_BFu31i_BFu15i { unsigned short v1; unsigned int v2:31; unsigned int v3:15; };
struct Us_BFu31i_BFu15ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:15; };
struct Us_BFu31i_BFu15s { unsigned short v1; unsigned int v2:31; unsigned short v3:15; };
struct Us_BFu31i_BFu16i { unsigned short v1; unsigned int v2:31; unsigned int v3:16; };
struct Us_BFu31i_BFu16ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:16; };
struct Us_BFu31i_BFu16s { unsigned short v1; unsigned int v2:31; unsigned short v3:16; };
struct Us_BFu31i_BFu17i { unsigned short v1; unsigned int v2:31; unsigned int v3:17; };
struct Us_BFu31i_BFu17ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:17; };
struct Us_BFu31i_BFu1c { unsigned short v1; unsigned int v2:31; unsigned char v3:1; };
struct Us_BFu31i_BFu1i { unsigned short v1; unsigned int v2:31; unsigned int v3:1; };
struct Us_BFu31i_BFu1ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:1; };
struct Us_BFu31i_BFu1s { unsigned short v1; unsigned int v2:31; unsigned short v3:1; };
struct Us_BFu31i_BFu31i { unsigned short v1; unsigned int v2:31; unsigned int v3:31; };
struct Us_BFu31i_BFu31ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:31; };
struct Us_BFu31i_BFu32i { unsigned short v1; unsigned int v2:31; unsigned int v3:32; };
struct Us_BFu31i_BFu32ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:32; };
struct Us_BFu31i_BFu33 { unsigned short v1; unsigned int v2:31; unsigned long long v3:33; };
struct Us_BFu31i_BFu7c { unsigned short v1; unsigned int v2:31; unsigned char v3:7; };
struct Us_BFu31i_BFu7i { unsigned short v1; unsigned int v2:31; unsigned int v3:7; };
struct Us_BFu31i_BFu7ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:7; };
struct Us_BFu31i_BFu7s { unsigned short v1; unsigned int v2:31; unsigned short v3:7; };
struct Us_BFu31i_BFu8c { unsigned short v1; unsigned int v2:31; unsigned char v3:8; };
struct Us_BFu31i_BFu8i { unsigned short v1; unsigned int v2:31; unsigned int v3:8; };
struct Us_BFu31i_BFu8ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:8; };
struct Us_BFu31i_BFu8s { unsigned short v1; unsigned int v2:31; unsigned short v3:8; };
struct Us_BFu31i_BFu9i { unsigned short v1; unsigned int v2:31; unsigned int v3:9; };
struct Us_BFu31i_BFu9ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:9; };
struct Us_BFu31i_BFu9s { unsigned short v1; unsigned int v2:31; unsigned short v3:9; };
struct Us_BFu31i_C { unsigned short v1; unsigned int v2:31; char v3; };
struct Us_BFu31i_D { unsigned short v1; unsigned int v2:31; double v3; };
struct Us_BFu31i_F { unsigned short v1; unsigned int v2:31; float v3; };
struct Us_BFu31i_I { unsigned short v1; unsigned int v2:31; int v3; };
struct Us_BFu31i_Ip { unsigned short v1; unsigned int v2:31; int * v3; };
struct Us_BFu31i_L { unsigned short v1; unsigned int v2:31; long long v3; };
struct Us_BFu31i_S { unsigned short v1; unsigned int v2:31; short v3; };
struct Us_BFu31i_Uc { unsigned short v1; unsigned int v2:31; unsigned char v3; };
struct Us_BFu31i_Ui { unsigned short v1; unsigned int v2:31; unsigned int v3; };
struct Us_BFu31i_Ul { unsigned short v1; unsigned int v2:31; unsigned long long v3; };
struct Us_BFu31i_Us { unsigned short v1; unsigned int v2:31; unsigned short v3; };
struct Us_BFu31i_Vp { unsigned short v1; unsigned int v2:31; void * v3; };
struct Us_BFu31ll { unsigned short v1; unsigned long long v2:31; };
struct Us_BFu31ll_BFu15i { unsigned short v1; unsigned long long v2:31; unsigned int v3:15; };
struct Us_BFu31ll_BFu15ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:15; };
struct Us_BFu31ll_BFu15s { unsigned short v1; unsigned long long v2:31; unsigned short v3:15; };
struct Us_BFu31ll_BFu16i { unsigned short v1; unsigned long long v2:31; unsigned int v3:16; };
struct Us_BFu31ll_BFu16ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:16; };
struct Us_BFu31ll_BFu16s { unsigned short v1; unsigned long long v2:31; unsigned short v3:16; };
struct Us_BFu31ll_BFu17i { unsigned short v1; unsigned long long v2:31; unsigned int v3:17; };
struct Us_BFu31ll_BFu17ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:17; };
struct Us_BFu31ll_BFu1c { unsigned short v1; unsigned long long v2:31; unsigned char v3:1; };
struct Us_BFu31ll_BFu1i { unsigned short v1; unsigned long long v2:31; unsigned int v3:1; };
struct Us_BFu31ll_BFu1ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:1; };
struct Us_BFu31ll_BFu1s { unsigned short v1; unsigned long long v2:31; unsigned short v3:1; };
struct Us_BFu31ll_BFu31i { unsigned short v1; unsigned long long v2:31; unsigned int v3:31; };
struct Us_BFu31ll_BFu31ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:31; };
struct Us_BFu31ll_BFu32i { unsigned short v1; unsigned long long v2:31; unsigned int v3:32; };
struct Us_BFu31ll_BFu32ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:32; };
struct Us_BFu31ll_BFu33 { unsigned short v1; unsigned long long v2:31; unsigned long long v3:33; };
struct Us_BFu31ll_BFu7c { unsigned short v1; unsigned long long v2:31; unsigned char v3:7; };
struct Us_BFu31ll_BFu7i { unsigned short v1; unsigned long long v2:31; unsigned int v3:7; };
struct Us_BFu31ll_BFu7ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:7; };
struct Us_BFu31ll_BFu7s { unsigned short v1; unsigned long long v2:31; unsigned short v3:7; };
struct Us_BFu31ll_BFu8c { unsigned short v1; unsigned long long v2:31; unsigned char v3:8; };
struct Us_BFu31ll_BFu8i { unsigned short v1; unsigned long long v2:31; unsigned int v3:8; };
struct Us_BFu31ll_BFu8ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:8; };
struct Us_BFu31ll_BFu8s { unsigned short v1; unsigned long long v2:31; unsigned short v3:8; };
struct Us_BFu31ll_BFu9i { unsigned short v1; unsigned long long v2:31; unsigned int v3:9; };
struct Us_BFu31ll_BFu9ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:9; };
struct Us_BFu31ll_BFu9s { unsigned short v1; unsigned long long v2:31; unsigned short v3:9; };
struct Us_BFu31ll_C { unsigned short v1; unsigned long long v2:31; char v3; };
struct Us_BFu31ll_D { unsigned short v1; unsigned long long v2:31; double v3; };
struct Us_BFu31ll_F { unsigned short v1; unsigned long long v2:31; float v3; };
struct Us_BFu31ll_I { unsigned short v1; unsigned long long v2:31; int v3; };
struct Us_BFu31ll_Ip { unsigned short v1; unsigned long long v2:31; int * v3; };
struct Us_BFu31ll_L { unsigned short v1; unsigned long long v2:31; long long v3; };
struct Us_BFu31ll_S { unsigned short v1; unsigned long long v2:31; short v3; };
struct Us_BFu31ll_Uc { unsigned short v1; unsigned long long v2:31; unsigned char v3; };
struct Us_BFu31ll_Ui { unsigned short v1; unsigned long long v2:31; unsigned int v3; };
struct Us_BFu31ll_Ul { unsigned short v1; unsigned long long v2:31; unsigned long long v3; };
struct Us_BFu31ll_Us { unsigned short v1; unsigned long long v2:31; unsigned short v3; };
struct Us_BFu31ll_Vp { unsigned short v1; unsigned long long v2:31; void * v3; };
struct Us_BFu32i { unsigned short v1; unsigned int v2:32; };
struct Us_BFu32i_BFu15i { unsigned short v1; unsigned int v2:32; unsigned int v3:15; };
struct Us_BFu32i_BFu15ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:15; };
struct Us_BFu32i_BFu15s { unsigned short v1; unsigned int v2:32; unsigned short v3:15; };
struct Us_BFu32i_BFu16i { unsigned short v1; unsigned int v2:32; unsigned int v3:16; };
struct Us_BFu32i_BFu16ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:16; };
struct Us_BFu32i_BFu16s { unsigned short v1; unsigned int v2:32; unsigned short v3:16; };
struct Us_BFu32i_BFu17i { unsigned short v1; unsigned int v2:32; unsigned int v3:17; };
struct Us_BFu32i_BFu17ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:17; };
struct Us_BFu32i_BFu1c { unsigned short v1; unsigned int v2:32; unsigned char v3:1; };
struct Us_BFu32i_BFu1i { unsigned short v1; unsigned int v2:32; unsigned int v3:1; };
struct Us_BFu32i_BFu1ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:1; };
struct Us_BFu32i_BFu1s { unsigned short v1; unsigned int v2:32; unsigned short v3:1; };
struct Us_BFu32i_BFu31i { unsigned short v1; unsigned int v2:32; unsigned int v3:31; };
struct Us_BFu32i_BFu31ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:31; };
struct Us_BFu32i_BFu32i { unsigned short v1; unsigned int v2:32; unsigned int v3:32; };
struct Us_BFu32i_BFu32ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:32; };
struct Us_BFu32i_BFu33 { unsigned short v1; unsigned int v2:32; unsigned long long v3:33; };
struct Us_BFu32i_BFu7c { unsigned short v1; unsigned int v2:32; unsigned char v3:7; };
struct Us_BFu32i_BFu7i { unsigned short v1; unsigned int v2:32; unsigned int v3:7; };
struct Us_BFu32i_BFu7ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:7; };
struct Us_BFu32i_BFu7s { unsigned short v1; unsigned int v2:32; unsigned short v3:7; };
struct Us_BFu32i_BFu8c { unsigned short v1; unsigned int v2:32; unsigned char v3:8; };
struct Us_BFu32i_BFu8i { unsigned short v1; unsigned int v2:32; unsigned int v3:8; };
struct Us_BFu32i_BFu8ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:8; };
struct Us_BFu32i_BFu8s { unsigned short v1; unsigned int v2:32; unsigned short v3:8; };
struct Us_BFu32i_BFu9i { unsigned short v1; unsigned int v2:32; unsigned int v3:9; };
struct Us_BFu32i_BFu9ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:9; };
struct Us_BFu32i_BFu9s { unsigned short v1; unsigned int v2:32; unsigned short v3:9; };
struct Us_BFu32i_C { unsigned short v1; unsigned int v2:32; char v3; };
struct Us_BFu32i_D { unsigned short v1; unsigned int v2:32; double v3; };
struct Us_BFu32i_F { unsigned short v1; unsigned int v2:32; float v3; };
struct Us_BFu32i_I { unsigned short v1; unsigned int v2:32; int v3; };
struct Us_BFu32i_Ip { unsigned short v1; unsigned int v2:32; int * v3; };
struct Us_BFu32i_L { unsigned short v1; unsigned int v2:32; long long v3; };
struct Us_BFu32i_S { unsigned short v1; unsigned int v2:32; short v3; };
struct Us_BFu32i_Uc { unsigned short v1; unsigned int v2:32; unsigned char v3; };
struct Us_BFu32i_Ui { unsigned short v1; unsigned int v2:32; unsigned int v3; };
struct Us_BFu32i_Ul { unsigned short v1; unsigned int v2:32; unsigned long long v3; };
struct Us_BFu32i_Us { unsigned short v1; unsigned int v2:32; unsigned short v3; };
struct Us_BFu32i_Vp { unsigned short v1; unsigned int v2:32; void * v3; };
struct Us_BFu32ll { unsigned short v1; unsigned long long v2:32; };
struct Us_BFu32ll_BFu15i { unsigned short v1; unsigned long long v2:32; unsigned int v3:15; };
struct Us_BFu32ll_BFu15ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:15; };
struct Us_BFu32ll_BFu15s { unsigned short v1; unsigned long long v2:32; unsigned short v3:15; };
struct Us_BFu32ll_BFu16i { unsigned short v1; unsigned long long v2:32; unsigned int v3:16; };
struct Us_BFu32ll_BFu16ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:16; };
struct Us_BFu32ll_BFu16s { unsigned short v1; unsigned long long v2:32; unsigned short v3:16; };
struct Us_BFu32ll_BFu17i { unsigned short v1; unsigned long long v2:32; unsigned int v3:17; };
struct Us_BFu32ll_BFu17ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:17; };
struct Us_BFu32ll_BFu1c { unsigned short v1; unsigned long long v2:32; unsigned char v3:1; };
struct Us_BFu32ll_BFu1i { unsigned short v1; unsigned long long v2:32; unsigned int v3:1; };
struct Us_BFu32ll_BFu1ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:1; };
struct Us_BFu32ll_BFu1s { unsigned short v1; unsigned long long v2:32; unsigned short v3:1; };
struct Us_BFu32ll_BFu31i { unsigned short v1; unsigned long long v2:32; unsigned int v3:31; };
struct Us_BFu32ll_BFu31ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:31; };
struct Us_BFu32ll_BFu32i { unsigned short v1; unsigned long long v2:32; unsigned int v3:32; };
struct Us_BFu32ll_BFu32ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:32; };
struct Us_BFu32ll_BFu33 { unsigned short v1; unsigned long long v2:32; unsigned long long v3:33; };
struct Us_BFu32ll_BFu7c { unsigned short v1; unsigned long long v2:32; unsigned char v3:7; };
struct Us_BFu32ll_BFu7i { unsigned short v1; unsigned long long v2:32; unsigned int v3:7; };
struct Us_BFu32ll_BFu7ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:7; };
struct Us_BFu32ll_BFu7s { unsigned short v1; unsigned long long v2:32; unsigned short v3:7; };
struct Us_BFu32ll_BFu8c { unsigned short v1; unsigned long long v2:32; unsigned char v3:8; };
struct Us_BFu32ll_BFu8i { unsigned short v1; unsigned long long v2:32; unsigned int v3:8; };
struct Us_BFu32ll_BFu8ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:8; };
struct Us_BFu32ll_BFu8s { unsigned short v1; unsigned long long v2:32; unsigned short v3:8; };
struct Us_BFu32ll_BFu9i { unsigned short v1; unsigned long long v2:32; unsigned int v3:9; };
struct Us_BFu32ll_BFu9ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:9; };
struct Us_BFu32ll_BFu9s { unsigned short v1; unsigned long long v2:32; unsigned short v3:9; };
struct Us_BFu32ll_C { unsigned short v1; unsigned long long v2:32; char v3; };
struct Us_BFu32ll_D { unsigned short v1; unsigned long long v2:32; double v3; };
struct Us_BFu32ll_F { unsigned short v1; unsigned long long v2:32; float v3; };
struct Us_BFu32ll_I { unsigned short v1; unsigned long long v2:32; int v3; };
struct Us_BFu32ll_Ip { unsigned short v1; unsigned long long v2:32; int * v3; };
struct Us_BFu32ll_L { unsigned short v1; unsigned long long v2:32; long long v3; };
struct Us_BFu32ll_S { unsigned short v1; unsigned long long v2:32; short v3; };
struct Us_BFu32ll_Uc { unsigned short v1; unsigned long long v2:32; unsigned char v3; };
struct Us_BFu32ll_Ui { unsigned short v1; unsigned long long v2:32; unsigned int v3; };
struct Us_BFu32ll_Ul { unsigned short v1; unsigned long long v2:32; unsigned long long v3; };
struct Us_BFu32ll_Us { unsigned short v1; unsigned long long v2:32; unsigned short v3; };
struct Us_BFu32ll_Vp { unsigned short v1; unsigned long long v2:32; void * v3; };
struct Us_BFu33 { unsigned short v1; unsigned long long v2:33; };
struct Us_BFu33_BFu15i { unsigned short v1; unsigned long long v2:33; unsigned int v3:15; };
struct Us_BFu33_BFu15ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:15; };
struct Us_BFu33_BFu15s { unsigned short v1; unsigned long long v2:33; unsigned short v3:15; };
struct Us_BFu33_BFu16i { unsigned short v1; unsigned long long v2:33; unsigned int v3:16; };
struct Us_BFu33_BFu16ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:16; };
struct Us_BFu33_BFu16s { unsigned short v1; unsigned long long v2:33; unsigned short v3:16; };
struct Us_BFu33_BFu17i { unsigned short v1; unsigned long long v2:33; unsigned int v3:17; };
struct Us_BFu33_BFu17ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:17; };
struct Us_BFu33_BFu1c { unsigned short v1; unsigned long long v2:33; unsigned char v3:1; };
struct Us_BFu33_BFu1i { unsigned short v1; unsigned long long v2:33; unsigned int v3:1; };
struct Us_BFu33_BFu1ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:1; };
struct Us_BFu33_BFu1s { unsigned short v1; unsigned long long v2:33; unsigned short v3:1; };
struct Us_BFu33_BFu31i { unsigned short v1; unsigned long long v2:33; unsigned int v3:31; };
struct Us_BFu33_BFu31ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:31; };
struct Us_BFu33_BFu32i { unsigned short v1; unsigned long long v2:33; unsigned int v3:32; };
struct Us_BFu33_BFu32ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:32; };
struct Us_BFu33_BFu33 { unsigned short v1; unsigned long long v2:33; unsigned long long v3:33; };
struct Us_BFu33_BFu7c { unsigned short v1; unsigned long long v2:33; unsigned char v3:7; };
struct Us_BFu33_BFu7i { unsigned short v1; unsigned long long v2:33; unsigned int v3:7; };
struct Us_BFu33_BFu7ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:7; };
struct Us_BFu33_BFu7s { unsigned short v1; unsigned long long v2:33; unsigned short v3:7; };
struct Us_BFu33_BFu8c { unsigned short v1; unsigned long long v2:33; unsigned char v3:8; };
struct Us_BFu33_BFu8i { unsigned short v1; unsigned long long v2:33; unsigned int v3:8; };
struct Us_BFu33_BFu8ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:8; };
struct Us_BFu33_BFu8s { unsigned short v1; unsigned long long v2:33; unsigned short v3:8; };
struct Us_BFu33_BFu9i { unsigned short v1; unsigned long long v2:33; unsigned int v3:9; };
struct Us_BFu33_BFu9ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:9; };
struct Us_BFu33_BFu9s { unsigned short v1; unsigned long long v2:33; unsigned short v3:9; };
struct Us_BFu33_C { unsigned short v1; unsigned long long v2:33; char v3; };
struct Us_BFu33_D { unsigned short v1; unsigned long long v2:33; double v3; };
struct Us_BFu33_F { unsigned short v1; unsigned long long v2:33; float v3; };
struct Us_BFu33_I { unsigned short v1; unsigned long long v2:33; int v3; };
struct Us_BFu33_Ip { unsigned short v1; unsigned long long v2:33; int * v3; };
struct Us_BFu33_L { unsigned short v1; unsigned long long v2:33; long long v3; };
struct Us_BFu33_S { unsigned short v1; unsigned long long v2:33; short v3; };
struct Us_BFu33_Uc { unsigned short v1; unsigned long long v2:33; unsigned char v3; };
struct Us_BFu33_Ui { unsigned short v1; unsigned long long v2:33; unsigned int v3; };
struct Us_BFu33_Ul { unsigned short v1; unsigned long long v2:33; unsigned long long v3; };
struct Us_BFu33_Us { unsigned short v1; unsigned long long v2:33; unsigned short v3; };
struct Us_BFu33_Vp { unsigned short v1; unsigned long long v2:33; void * v3; };
struct Us_BFu7c { unsigned short v1; unsigned char v2:7; };
struct Us_BFu7c_BFu15i { unsigned short v1; unsigned char v2:7; unsigned int v3:15; };
struct Us_BFu7c_BFu15ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:15; };
struct Us_BFu7c_BFu15s { unsigned short v1; unsigned char v2:7; unsigned short v3:15; };
struct Us_BFu7c_BFu16i { unsigned short v1; unsigned char v2:7; unsigned int v3:16; };
struct Us_BFu7c_BFu16ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:16; };
struct Us_BFu7c_BFu16s { unsigned short v1; unsigned char v2:7; unsigned short v3:16; };
struct Us_BFu7c_BFu17i { unsigned short v1; unsigned char v2:7; unsigned int v3:17; };
struct Us_BFu7c_BFu17ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:17; };
struct Us_BFu7c_BFu1c { unsigned short v1; unsigned char v2:7; unsigned char v3:1; };
struct Us_BFu7c_BFu1i { unsigned short v1; unsigned char v2:7; unsigned int v3:1; };
struct Us_BFu7c_BFu1ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:1; };
struct Us_BFu7c_BFu1s { unsigned short v1; unsigned char v2:7; unsigned short v3:1; };
struct Us_BFu7c_BFu31i { unsigned short v1; unsigned char v2:7; unsigned int v3:31; };
struct Us_BFu7c_BFu31ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:31; };
struct Us_BFu7c_BFu32i { unsigned short v1; unsigned char v2:7; unsigned int v3:32; };
struct Us_BFu7c_BFu32ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:32; };
struct Us_BFu7c_BFu33 { unsigned short v1; unsigned char v2:7; unsigned long long v3:33; };
struct Us_BFu7c_BFu7c { unsigned short v1; unsigned char v2:7; unsigned char v3:7; };
struct Us_BFu7c_BFu7i { unsigned short v1; unsigned char v2:7; unsigned int v3:7; };
struct Us_BFu7c_BFu7ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:7; };
struct Us_BFu7c_BFu7s { unsigned short v1; unsigned char v2:7; unsigned short v3:7; };
struct Us_BFu7c_BFu8c { unsigned short v1; unsigned char v2:7; unsigned char v3:8; };
struct Us_BFu7c_BFu8i { unsigned short v1; unsigned char v2:7; unsigned int v3:8; };
struct Us_BFu7c_BFu8ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:8; };
struct Us_BFu7c_BFu8s { unsigned short v1; unsigned char v2:7; unsigned short v3:8; };
struct Us_BFu7c_BFu9i { unsigned short v1; unsigned char v2:7; unsigned int v3:9; };
struct Us_BFu7c_BFu9ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:9; };
struct Us_BFu7c_BFu9s { unsigned short v1; unsigned char v2:7; unsigned short v3:9; };
struct Us_BFu7c_C { unsigned short v1; unsigned char v2:7; char v3; };
struct Us_BFu7c_D { unsigned short v1; unsigned char v2:7; double v3; };
struct Us_BFu7c_F { unsigned short v1; unsigned char v2:7; float v3; };
struct Us_BFu7c_I { unsigned short v1; unsigned char v2:7; int v3; };
struct Us_BFu7c_Ip { unsigned short v1; unsigned char v2:7; int * v3; };
struct Us_BFu7c_L { unsigned short v1; unsigned char v2:7; long long v3; };
struct Us_BFu7c_S { unsigned short v1; unsigned char v2:7; short v3; };
struct Us_BFu7c_Uc { unsigned short v1; unsigned char v2:7; unsigned char v3; };
struct Us_BFu7c_Ui { unsigned short v1; unsigned char v2:7; unsigned int v3; };
struct Us_BFu7c_Ul { unsigned short v1; unsigned char v2:7; unsigned long long v3; };
struct Us_BFu7c_Us { unsigned short v1; unsigned char v2:7; unsigned short v3; };
struct Us_BFu7c_Vp { unsigned short v1; unsigned char v2:7; void * v3; };
struct Us_BFu7i { unsigned short v1; unsigned int v2:7; };
struct Us_BFu7i_BFu15i { unsigned short v1; unsigned int v2:7; unsigned int v3:15; };
struct Us_BFu7i_BFu15ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:15; };
struct Us_BFu7i_BFu15s { unsigned short v1; unsigned int v2:7; unsigned short v3:15; };
struct Us_BFu7i_BFu16i { unsigned short v1; unsigned int v2:7; unsigned int v3:16; };
struct Us_BFu7i_BFu16ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:16; };
struct Us_BFu7i_BFu16s { unsigned short v1; unsigned int v2:7; unsigned short v3:16; };
struct Us_BFu7i_BFu17i { unsigned short v1; unsigned int v2:7; unsigned int v3:17; };
struct Us_BFu7i_BFu17ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:17; };
struct Us_BFu7i_BFu1c { unsigned short v1; unsigned int v2:7; unsigned char v3:1; };
struct Us_BFu7i_BFu1i { unsigned short v1; unsigned int v2:7; unsigned int v3:1; };
struct Us_BFu7i_BFu1ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:1; };
struct Us_BFu7i_BFu1s { unsigned short v1; unsigned int v2:7; unsigned short v3:1; };
struct Us_BFu7i_BFu31i { unsigned short v1; unsigned int v2:7; unsigned int v3:31; };
struct Us_BFu7i_BFu31ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:31; };
struct Us_BFu7i_BFu32i { unsigned short v1; unsigned int v2:7; unsigned int v3:32; };
struct Us_BFu7i_BFu32ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:32; };
struct Us_BFu7i_BFu33 { unsigned short v1; unsigned int v2:7; unsigned long long v3:33; };
struct Us_BFu7i_BFu7c { unsigned short v1; unsigned int v2:7; unsigned char v3:7; };
struct Us_BFu7i_BFu7i { unsigned short v1; unsigned int v2:7; unsigned int v3:7; };
struct Us_BFu7i_BFu7ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:7; };
struct Us_BFu7i_BFu7s { unsigned short v1; unsigned int v2:7; unsigned short v3:7; };
struct Us_BFu7i_BFu8c { unsigned short v1; unsigned int v2:7; unsigned char v3:8; };
struct Us_BFu7i_BFu8i { unsigned short v1; unsigned int v2:7; unsigned int v3:8; };
struct Us_BFu7i_BFu8ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:8; };
struct Us_BFu7i_BFu8s { unsigned short v1; unsigned int v2:7; unsigned short v3:8; };
struct Us_BFu7i_BFu9i { unsigned short v1; unsigned int v2:7; unsigned int v3:9; };
struct Us_BFu7i_BFu9ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:9; };
struct Us_BFu7i_BFu9s { unsigned short v1; unsigned int v2:7; unsigned short v3:9; };
struct Us_BFu7i_C { unsigned short v1; unsigned int v2:7; char v3; };
struct Us_BFu7i_D { unsigned short v1; unsigned int v2:7; double v3; };
struct Us_BFu7i_F { unsigned short v1; unsigned int v2:7; float v3; };
struct Us_BFu7i_I { unsigned short v1; unsigned int v2:7; int v3; };
struct Us_BFu7i_Ip { unsigned short v1; unsigned int v2:7; int * v3; };
struct Us_BFu7i_L { unsigned short v1; unsigned int v2:7; long long v3; };
struct Us_BFu7i_S { unsigned short v1; unsigned int v2:7; short v3; };
struct Us_BFu7i_Uc { unsigned short v1; unsigned int v2:7; unsigned char v3; };
struct Us_BFu7i_Ui { unsigned short v1; unsigned int v2:7; unsigned int v3; };
struct Us_BFu7i_Ul { unsigned short v1; unsigned int v2:7; unsigned long long v3; };
struct Us_BFu7i_Us { unsigned short v1; unsigned int v2:7; unsigned short v3; };
struct Us_BFu7i_Vp { unsigned short v1; unsigned int v2:7; void * v3; };
struct Us_BFu7ll { unsigned short v1; unsigned long long v2:7; };
struct Us_BFu7ll_BFu15i { unsigned short v1; unsigned long long v2:7; unsigned int v3:15; };
struct Us_BFu7ll_BFu15ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:15; };
struct Us_BFu7ll_BFu15s { unsigned short v1; unsigned long long v2:7; unsigned short v3:15; };
struct Us_BFu7ll_BFu16i { unsigned short v1; unsigned long long v2:7; unsigned int v3:16; };
struct Us_BFu7ll_BFu16ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:16; };
struct Us_BFu7ll_BFu16s { unsigned short v1; unsigned long long v2:7; unsigned short v3:16; };
struct Us_BFu7ll_BFu17i { unsigned short v1; unsigned long long v2:7; unsigned int v3:17; };
struct Us_BFu7ll_BFu17ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:17; };
struct Us_BFu7ll_BFu1c { unsigned short v1; unsigned long long v2:7; unsigned char v3:1; };
struct Us_BFu7ll_BFu1i { unsigned short v1; unsigned long long v2:7; unsigned int v3:1; };
struct Us_BFu7ll_BFu1ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:1; };
struct Us_BFu7ll_BFu1s { unsigned short v1; unsigned long long v2:7; unsigned short v3:1; };
struct Us_BFu7ll_BFu31i { unsigned short v1; unsigned long long v2:7; unsigned int v3:31; };
struct Us_BFu7ll_BFu31ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:31; };
struct Us_BFu7ll_BFu32i { unsigned short v1; unsigned long long v2:7; unsigned int v3:32; };
struct Us_BFu7ll_BFu32ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:32; };
struct Us_BFu7ll_BFu33 { unsigned short v1; unsigned long long v2:7; unsigned long long v3:33; };
struct Us_BFu7ll_BFu7c { unsigned short v1; unsigned long long v2:7; unsigned char v3:7; };
struct Us_BFu7ll_BFu7i { unsigned short v1; unsigned long long v2:7; unsigned int v3:7; };
struct Us_BFu7ll_BFu7ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:7; };
struct Us_BFu7ll_BFu7s { unsigned short v1; unsigned long long v2:7; unsigned short v3:7; };
struct Us_BFu7ll_BFu8c { unsigned short v1; unsigned long long v2:7; unsigned char v3:8; };
struct Us_BFu7ll_BFu8i { unsigned short v1; unsigned long long v2:7; unsigned int v3:8; };
struct Us_BFu7ll_BFu8ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:8; };
struct Us_BFu7ll_BFu8s { unsigned short v1; unsigned long long v2:7; unsigned short v3:8; };
struct Us_BFu7ll_BFu9i { unsigned short v1; unsigned long long v2:7; unsigned int v3:9; };
struct Us_BFu7ll_BFu9ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:9; };
struct Us_BFu7ll_BFu9s { unsigned short v1; unsigned long long v2:7; unsigned short v3:9; };
struct Us_BFu7ll_C { unsigned short v1; unsigned long long v2:7; char v3; };
struct Us_BFu7ll_D { unsigned short v1; unsigned long long v2:7; double v3; };
struct Us_BFu7ll_F { unsigned short v1; unsigned long long v2:7; float v3; };
struct Us_BFu7ll_I { unsigned short v1; unsigned long long v2:7; int v3; };
struct Us_BFu7ll_Ip { unsigned short v1; unsigned long long v2:7; int * v3; };
struct Us_BFu7ll_L { unsigned short v1; unsigned long long v2:7; long long v3; };
struct Us_BFu7ll_S { unsigned short v1; unsigned long long v2:7; short v3; };
struct Us_BFu7ll_Uc { unsigned short v1; unsigned long long v2:7; unsigned char v3; };
struct Us_BFu7ll_Ui { unsigned short v1; unsigned long long v2:7; unsigned int v3; };
struct Us_BFu7ll_Ul { unsigned short v1; unsigned long long v2:7; unsigned long long v3; };
struct Us_BFu7ll_Us { unsigned short v1; unsigned long long v2:7; unsigned short v3; };
struct Us_BFu7ll_Vp { unsigned short v1; unsigned long long v2:7; void * v3; };
struct Us_BFu7s { unsigned short v1; unsigned short v2:7; };
struct Us_BFu7s_BFu15i { unsigned short v1; unsigned short v2:7; unsigned int v3:15; };
struct Us_BFu7s_BFu15ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:15; };
struct Us_BFu7s_BFu15s { unsigned short v1; unsigned short v2:7; unsigned short v3:15; };
struct Us_BFu7s_BFu16i { unsigned short v1; unsigned short v2:7; unsigned int v3:16; };
struct Us_BFu7s_BFu16ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:16; };
struct Us_BFu7s_BFu16s { unsigned short v1; unsigned short v2:7; unsigned short v3:16; };
struct Us_BFu7s_BFu17i { unsigned short v1; unsigned short v2:7; unsigned int v3:17; };
struct Us_BFu7s_BFu17ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:17; };
struct Us_BFu7s_BFu1c { unsigned short v1; unsigned short v2:7; unsigned char v3:1; };
struct Us_BFu7s_BFu1i { unsigned short v1; unsigned short v2:7; unsigned int v3:1; };
struct Us_BFu7s_BFu1ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:1; };
struct Us_BFu7s_BFu1s { unsigned short v1; unsigned short v2:7; unsigned short v3:1; };
struct Us_BFu7s_BFu31i { unsigned short v1; unsigned short v2:7; unsigned int v3:31; };
struct Us_BFu7s_BFu31ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:31; };
struct Us_BFu7s_BFu32i { unsigned short v1; unsigned short v2:7; unsigned int v3:32; };
struct Us_BFu7s_BFu32ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:32; };
struct Us_BFu7s_BFu33 { unsigned short v1; unsigned short v2:7; unsigned long long v3:33; };
struct Us_BFu7s_BFu7c { unsigned short v1; unsigned short v2:7; unsigned char v3:7; };
struct Us_BFu7s_BFu7i { unsigned short v1; unsigned short v2:7; unsigned int v3:7; };
struct Us_BFu7s_BFu7ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:7; };
struct Us_BFu7s_BFu7s { unsigned short v1; unsigned short v2:7; unsigned short v3:7; };
struct Us_BFu7s_BFu8c { unsigned short v1; unsigned short v2:7; unsigned char v3:8; };
struct Us_BFu7s_BFu8i { unsigned short v1; unsigned short v2:7; unsigned int v3:8; };
struct Us_BFu7s_BFu8ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:8; };
struct Us_BFu7s_BFu8s { unsigned short v1; unsigned short v2:7; unsigned short v3:8; };
struct Us_BFu7s_BFu9i { unsigned short v1; unsigned short v2:7; unsigned int v3:9; };
struct Us_BFu7s_BFu9ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:9; };
struct Us_BFu7s_BFu9s { unsigned short v1; unsigned short v2:7; unsigned short v3:9; };
struct Us_BFu7s_C { unsigned short v1; unsigned short v2:7; char v3; };
struct Us_BFu7s_D { unsigned short v1; unsigned short v2:7; double v3; };
struct Us_BFu7s_F { unsigned short v1; unsigned short v2:7; float v3; };
struct Us_BFu7s_I { unsigned short v1; unsigned short v2:7; int v3; };
struct Us_BFu7s_Ip { unsigned short v1; unsigned short v2:7; int * v3; };
struct Us_BFu7s_L { unsigned short v1; unsigned short v2:7; long long v3; };
struct Us_BFu7s_S { unsigned short v1; unsigned short v2:7; short v3; };
struct Us_BFu7s_Uc { unsigned short v1; unsigned short v2:7; unsigned char v3; };
struct Us_BFu7s_Ui { unsigned short v1; unsigned short v2:7; unsigned int v3; };
struct Us_BFu7s_Ul { unsigned short v1; unsigned short v2:7; unsigned long long v3; };
struct Us_BFu7s_Us { unsigned short v1; unsigned short v2:7; unsigned short v3; };
struct Us_BFu7s_Vp { unsigned short v1; unsigned short v2:7; void * v3; };
struct Us_BFu8c { unsigned short v1; unsigned char v2:8; };
struct Us_BFu8c_BFu15i { unsigned short v1; unsigned char v2:8; unsigned int v3:15; };
struct Us_BFu8c_BFu15ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:15; };
struct Us_BFu8c_BFu15s { unsigned short v1; unsigned char v2:8; unsigned short v3:15; };
struct Us_BFu8c_BFu16i { unsigned short v1; unsigned char v2:8; unsigned int v3:16; };
struct Us_BFu8c_BFu16ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:16; };
struct Us_BFu8c_BFu16s { unsigned short v1; unsigned char v2:8; unsigned short v3:16; };
struct Us_BFu8c_BFu17i { unsigned short v1; unsigned char v2:8; unsigned int v3:17; };
struct Us_BFu8c_BFu17ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:17; };
struct Us_BFu8c_BFu1c { unsigned short v1; unsigned char v2:8; unsigned char v3:1; };
struct Us_BFu8c_BFu1i { unsigned short v1; unsigned char v2:8; unsigned int v3:1; };
struct Us_BFu8c_BFu1ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:1; };
struct Us_BFu8c_BFu1s { unsigned short v1; unsigned char v2:8; unsigned short v3:1; };
struct Us_BFu8c_BFu31i { unsigned short v1; unsigned char v2:8; unsigned int v3:31; };
struct Us_BFu8c_BFu31ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:31; };
struct Us_BFu8c_BFu32i { unsigned short v1; unsigned char v2:8; unsigned int v3:32; };
struct Us_BFu8c_BFu32ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:32; };
struct Us_BFu8c_BFu33 { unsigned short v1; unsigned char v2:8; unsigned long long v3:33; };
struct Us_BFu8c_BFu7c { unsigned short v1; unsigned char v2:8; unsigned char v3:7; };
struct Us_BFu8c_BFu7i { unsigned short v1; unsigned char v2:8; unsigned int v3:7; };
struct Us_BFu8c_BFu7ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:7; };
struct Us_BFu8c_BFu7s { unsigned short v1; unsigned char v2:8; unsigned short v3:7; };
struct Us_BFu8c_BFu8c { unsigned short v1; unsigned char v2:8; unsigned char v3:8; };
struct Us_BFu8c_BFu8i { unsigned short v1; unsigned char v2:8; unsigned int v3:8; };
struct Us_BFu8c_BFu8ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:8; };
struct Us_BFu8c_BFu8s { unsigned short v1; unsigned char v2:8; unsigned short v3:8; };
struct Us_BFu8c_BFu9i { unsigned short v1; unsigned char v2:8; unsigned int v3:9; };
struct Us_BFu8c_BFu9ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:9; };
struct Us_BFu8c_BFu9s { unsigned short v1; unsigned char v2:8; unsigned short v3:9; };
struct Us_BFu8c_C { unsigned short v1; unsigned char v2:8; char v3; };
struct Us_BFu8c_D { unsigned short v1; unsigned char v2:8; double v3; };
struct Us_BFu8c_F { unsigned short v1; unsigned char v2:8; float v3; };
struct Us_BFu8c_I { unsigned short v1; unsigned char v2:8; int v3; };
struct Us_BFu8c_Ip { unsigned short v1; unsigned char v2:8; int * v3; };
struct Us_BFu8c_L { unsigned short v1; unsigned char v2:8; long long v3; };
struct Us_BFu8c_S { unsigned short v1; unsigned char v2:8; short v3; };
struct Us_BFu8c_Uc { unsigned short v1; unsigned char v2:8; unsigned char v3; };
struct Us_BFu8c_Ui { unsigned short v1; unsigned char v2:8; unsigned int v3; };
struct Us_BFu8c_Ul { unsigned short v1; unsigned char v2:8; unsigned long long v3; };
struct Us_BFu8c_Us { unsigned short v1; unsigned char v2:8; unsigned short v3; };
struct Us_BFu8c_Vp { unsigned short v1; unsigned char v2:8; void * v3; };
struct Us_BFu8i { unsigned short v1; unsigned int v2:8; };
struct Us_BFu8i_BFu15i { unsigned short v1; unsigned int v2:8; unsigned int v3:15; };
struct Us_BFu8i_BFu15ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:15; };
struct Us_BFu8i_BFu15s { unsigned short v1; unsigned int v2:8; unsigned short v3:15; };
struct Us_BFu8i_BFu16i { unsigned short v1; unsigned int v2:8; unsigned int v3:16; };
struct Us_BFu8i_BFu16ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:16; };
struct Us_BFu8i_BFu16s { unsigned short v1; unsigned int v2:8; unsigned short v3:16; };
struct Us_BFu8i_BFu17i { unsigned short v1; unsigned int v2:8; unsigned int v3:17; };
struct Us_BFu8i_BFu17ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:17; };
struct Us_BFu8i_BFu1c { unsigned short v1; unsigned int v2:8; unsigned char v3:1; };
struct Us_BFu8i_BFu1i { unsigned short v1; unsigned int v2:8; unsigned int v3:1; };
struct Us_BFu8i_BFu1ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:1; };
struct Us_BFu8i_BFu1s { unsigned short v1; unsigned int v2:8; unsigned short v3:1; };
struct Us_BFu8i_BFu31i { unsigned short v1; unsigned int v2:8; unsigned int v3:31; };
struct Us_BFu8i_BFu31ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:31; };
struct Us_BFu8i_BFu32i { unsigned short v1; unsigned int v2:8; unsigned int v3:32; };
struct Us_BFu8i_BFu32ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:32; };
struct Us_BFu8i_BFu33 { unsigned short v1; unsigned int v2:8; unsigned long long v3:33; };
struct Us_BFu8i_BFu7c { unsigned short v1; unsigned int v2:8; unsigned char v3:7; };
struct Us_BFu8i_BFu7i { unsigned short v1; unsigned int v2:8; unsigned int v3:7; };
struct Us_BFu8i_BFu7ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:7; };
struct Us_BFu8i_BFu7s { unsigned short v1; unsigned int v2:8; unsigned short v3:7; };
struct Us_BFu8i_BFu8c { unsigned short v1; unsigned int v2:8; unsigned char v3:8; };
struct Us_BFu8i_BFu8i { unsigned short v1; unsigned int v2:8; unsigned int v3:8; };
struct Us_BFu8i_BFu8ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:8; };
struct Us_BFu8i_BFu8s { unsigned short v1; unsigned int v2:8; unsigned short v3:8; };
struct Us_BFu8i_BFu9i { unsigned short v1; unsigned int v2:8; unsigned int v3:9; };
struct Us_BFu8i_BFu9ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:9; };
struct Us_BFu8i_BFu9s { unsigned short v1; unsigned int v2:8; unsigned short v3:9; };
struct Us_BFu8i_C { unsigned short v1; unsigned int v2:8; char v3; };
struct Us_BFu8i_D { unsigned short v1; unsigned int v2:8; double v3; };
struct Us_BFu8i_F { unsigned short v1; unsigned int v2:8; float v3; };
struct Us_BFu8i_I { unsigned short v1; unsigned int v2:8; int v3; };
struct Us_BFu8i_Ip { unsigned short v1; unsigned int v2:8; int * v3; };
struct Us_BFu8i_L { unsigned short v1; unsigned int v2:8; long long v3; };
struct Us_BFu8i_S { unsigned short v1; unsigned int v2:8; short v3; };
struct Us_BFu8i_Uc { unsigned short v1; unsigned int v2:8; unsigned char v3; };
struct Us_BFu8i_Ui { unsigned short v1; unsigned int v2:8; unsigned int v3; };
struct Us_BFu8i_Ul { unsigned short v1; unsigned int v2:8; unsigned long long v3; };
struct Us_BFu8i_Us { unsigned short v1; unsigned int v2:8; unsigned short v3; };
struct Us_BFu8i_Vp { unsigned short v1; unsigned int v2:8; void * v3; };
struct Us_BFu8ll { unsigned short v1; unsigned long long v2:8; };
struct Us_BFu8ll_BFu15i { unsigned short v1; unsigned long long v2:8; unsigned int v3:15; };
struct Us_BFu8ll_BFu15ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:15; };
struct Us_BFu8ll_BFu15s { unsigned short v1; unsigned long long v2:8; unsigned short v3:15; };
struct Us_BFu8ll_BFu16i { unsigned short v1; unsigned long long v2:8; unsigned int v3:16; };
struct Us_BFu8ll_BFu16ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:16; };
struct Us_BFu8ll_BFu16s { unsigned short v1; unsigned long long v2:8; unsigned short v3:16; };
struct Us_BFu8ll_BFu17i { unsigned short v1; unsigned long long v2:8; unsigned int v3:17; };
struct Us_BFu8ll_BFu17ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:17; };
struct Us_BFu8ll_BFu1c { unsigned short v1; unsigned long long v2:8; unsigned char v3:1; };
struct Us_BFu8ll_BFu1i { unsigned short v1; unsigned long long v2:8; unsigned int v3:1; };
struct Us_BFu8ll_BFu1ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:1; };
struct Us_BFu8ll_BFu1s { unsigned short v1; unsigned long long v2:8; unsigned short v3:1; };
struct Us_BFu8ll_BFu31i { unsigned short v1; unsigned long long v2:8; unsigned int v3:31; };
struct Us_BFu8ll_BFu31ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:31; };
struct Us_BFu8ll_BFu32i { unsigned short v1; unsigned long long v2:8; unsigned int v3:32; };
struct Us_BFu8ll_BFu32ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:32; };
struct Us_BFu8ll_BFu33 { unsigned short v1; unsigned long long v2:8; unsigned long long v3:33; };
struct Us_BFu8ll_BFu7c { unsigned short v1; unsigned long long v2:8; unsigned char v3:7; };
struct Us_BFu8ll_BFu7i { unsigned short v1; unsigned long long v2:8; unsigned int v3:7; };
struct Us_BFu8ll_BFu7ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:7; };
struct Us_BFu8ll_BFu7s { unsigned short v1; unsigned long long v2:8; unsigned short v3:7; };
struct Us_BFu8ll_BFu8c { unsigned short v1; unsigned long long v2:8; unsigned char v3:8; };
struct Us_BFu8ll_BFu8i { unsigned short v1; unsigned long long v2:8; unsigned int v3:8; };
struct Us_BFu8ll_BFu8ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:8; };
struct Us_BFu8ll_BFu8s { unsigned short v1; unsigned long long v2:8; unsigned short v3:8; };
struct Us_BFu8ll_BFu9i { unsigned short v1; unsigned long long v2:8; unsigned int v3:9; };
struct Us_BFu8ll_BFu9ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:9; };
struct Us_BFu8ll_BFu9s { unsigned short v1; unsigned long long v2:8; unsigned short v3:9; };
struct Us_BFu8ll_C { unsigned short v1; unsigned long long v2:8; char v3; };
struct Us_BFu8ll_D { unsigned short v1; unsigned long long v2:8; double v3; };
struct Us_BFu8ll_F { unsigned short v1; unsigned long long v2:8; float v3; };
struct Us_BFu8ll_I { unsigned short v1; unsigned long long v2:8; int v3; };
struct Us_BFu8ll_Ip { unsigned short v1; unsigned long long v2:8; int * v3; };
struct Us_BFu8ll_L { unsigned short v1; unsigned long long v2:8; long long v3; };
struct Us_BFu8ll_S { unsigned short v1; unsigned long long v2:8; short v3; };
struct Us_BFu8ll_Uc { unsigned short v1; unsigned long long v2:8; unsigned char v3; };
struct Us_BFu8ll_Ui { unsigned short v1; unsigned long long v2:8; unsigned int v3; };
struct Us_BFu8ll_Ul { unsigned short v1; unsigned long long v2:8; unsigned long long v3; };
struct Us_BFu8ll_Us { unsigned short v1; unsigned long long v2:8; unsigned short v3; };
struct Us_BFu8ll_Vp { unsigned short v1; unsigned long long v2:8; void * v3; };
struct Us_BFu8s { unsigned short v1; unsigned short v2:8; };
struct Us_BFu8s_BFu15i { unsigned short v1; unsigned short v2:8; unsigned int v3:15; };
struct Us_BFu8s_BFu15ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:15; };
struct Us_BFu8s_BFu15s { unsigned short v1; unsigned short v2:8; unsigned short v3:15; };
struct Us_BFu8s_BFu16i { unsigned short v1; unsigned short v2:8; unsigned int v3:16; };
struct Us_BFu8s_BFu16ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:16; };
struct Us_BFu8s_BFu16s { unsigned short v1; unsigned short v2:8; unsigned short v3:16; };
struct Us_BFu8s_BFu17i { unsigned short v1; unsigned short v2:8; unsigned int v3:17; };
struct Us_BFu8s_BFu17ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:17; };
struct Us_BFu8s_BFu1c { unsigned short v1; unsigned short v2:8; unsigned char v3:1; };
struct Us_BFu8s_BFu1i { unsigned short v1; unsigned short v2:8; unsigned int v3:1; };
struct Us_BFu8s_BFu1ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:1; };
struct Us_BFu8s_BFu1s { unsigned short v1; unsigned short v2:8; unsigned short v3:1; };
struct Us_BFu8s_BFu31i { unsigned short v1; unsigned short v2:8; unsigned int v3:31; };
struct Us_BFu8s_BFu31ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:31; };
struct Us_BFu8s_BFu32i { unsigned short v1; unsigned short v2:8; unsigned int v3:32; };
struct Us_BFu8s_BFu32ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:32; };
struct Us_BFu8s_BFu33 { unsigned short v1; unsigned short v2:8; unsigned long long v3:33; };
struct Us_BFu8s_BFu7c { unsigned short v1; unsigned short v2:8; unsigned char v3:7; };
struct Us_BFu8s_BFu7i { unsigned short v1; unsigned short v2:8; unsigned int v3:7; };
struct Us_BFu8s_BFu7ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:7; };
struct Us_BFu8s_BFu7s { unsigned short v1; unsigned short v2:8; unsigned short v3:7; };
struct Us_BFu8s_BFu8c { unsigned short v1; unsigned short v2:8; unsigned char v3:8; };
struct Us_BFu8s_BFu8i { unsigned short v1; unsigned short v2:8; unsigned int v3:8; };
struct Us_BFu8s_BFu8ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:8; };
struct Us_BFu8s_BFu8s { unsigned short v1; unsigned short v2:8; unsigned short v3:8; };
struct Us_BFu8s_BFu9i { unsigned short v1; unsigned short v2:8; unsigned int v3:9; };
struct Us_BFu8s_BFu9ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:9; };
struct Us_BFu8s_BFu9s { unsigned short v1; unsigned short v2:8; unsigned short v3:9; };
struct Us_BFu8s_C { unsigned short v1; unsigned short v2:8; char v3; };
struct Us_BFu8s_D { unsigned short v1; unsigned short v2:8; double v3; };
struct Us_BFu8s_F { unsigned short v1; unsigned short v2:8; float v3; };
struct Us_BFu8s_I { unsigned short v1; unsigned short v2:8; int v3; };
struct Us_BFu8s_Ip { unsigned short v1; unsigned short v2:8; int * v3; };
struct Us_BFu8s_L { unsigned short v1; unsigned short v2:8; long long v3; };
struct Us_BFu8s_S { unsigned short v1; unsigned short v2:8; short v3; };
struct Us_BFu8s_Uc { unsigned short v1; unsigned short v2:8; unsigned char v3; };
struct Us_BFu8s_Ui { unsigned short v1; unsigned short v2:8; unsigned int v3; };
struct Us_BFu8s_Ul { unsigned short v1; unsigned short v2:8; unsigned long long v3; };
struct Us_BFu8s_Us { unsigned short v1; unsigned short v2:8; unsigned short v3; };
struct Us_BFu8s_Vp { unsigned short v1; unsigned short v2:8; void * v3; };
struct Us_BFu9i { unsigned short v1; unsigned int v2:9; };
struct Us_BFu9i_BFu15i { unsigned short v1; unsigned int v2:9; unsigned int v3:15; };
struct Us_BFu9i_BFu15ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:15; };
struct Us_BFu9i_BFu15s { unsigned short v1; unsigned int v2:9; unsigned short v3:15; };
struct Us_BFu9i_BFu16i { unsigned short v1; unsigned int v2:9; unsigned int v3:16; };
struct Us_BFu9i_BFu16ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:16; };
struct Us_BFu9i_BFu16s { unsigned short v1; unsigned int v2:9; unsigned short v3:16; };
struct Us_BFu9i_BFu17i { unsigned short v1; unsigned int v2:9; unsigned int v3:17; };
struct Us_BFu9i_BFu17ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:17; };
struct Us_BFu9i_BFu1c { unsigned short v1; unsigned int v2:9; unsigned char v3:1; };
struct Us_BFu9i_BFu1i { unsigned short v1; unsigned int v2:9; unsigned int v3:1; };
struct Us_BFu9i_BFu1ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:1; };
struct Us_BFu9i_BFu1s { unsigned short v1; unsigned int v2:9; unsigned short v3:1; };
struct Us_BFu9i_BFu31i { unsigned short v1; unsigned int v2:9; unsigned int v3:31; };
struct Us_BFu9i_BFu31ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:31; };
struct Us_BFu9i_BFu32i { unsigned short v1; unsigned int v2:9; unsigned int v3:32; };
struct Us_BFu9i_BFu32ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:32; };
struct Us_BFu9i_BFu33 { unsigned short v1; unsigned int v2:9; unsigned long long v3:33; };
struct Us_BFu9i_BFu7c { unsigned short v1; unsigned int v2:9; unsigned char v3:7; };
struct Us_BFu9i_BFu7i { unsigned short v1; unsigned int v2:9; unsigned int v3:7; };
struct Us_BFu9i_BFu7ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:7; };
struct Us_BFu9i_BFu7s { unsigned short v1; unsigned int v2:9; unsigned short v3:7; };
struct Us_BFu9i_BFu8c { unsigned short v1; unsigned int v2:9; unsigned char v3:8; };
struct Us_BFu9i_BFu8i { unsigned short v1; unsigned int v2:9; unsigned int v3:8; };
struct Us_BFu9i_BFu8ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:8; };
struct Us_BFu9i_BFu8s { unsigned short v1; unsigned int v2:9; unsigned short v3:8; };
struct Us_BFu9i_BFu9i { unsigned short v1; unsigned int v2:9; unsigned int v3:9; };
struct Us_BFu9i_BFu9ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:9; };
struct Us_BFu9i_BFu9s { unsigned short v1; unsigned int v2:9; unsigned short v3:9; };
struct Us_BFu9i_C { unsigned short v1; unsigned int v2:9; char v3; };
struct Us_BFu9i_D { unsigned short v1; unsigned int v2:9; double v3; };
struct Us_BFu9i_F { unsigned short v1; unsigned int v2:9; float v3; };
struct Us_BFu9i_I { unsigned short v1; unsigned int v2:9; int v3; };
struct Us_BFu9i_Ip { unsigned short v1; unsigned int v2:9; int * v3; };
struct Us_BFu9i_L { unsigned short v1; unsigned int v2:9; long long v3; };
struct Us_BFu9i_S { unsigned short v1; unsigned int v2:9; short v3; };
struct Us_BFu9i_Uc { unsigned short v1; unsigned int v2:9; unsigned char v3; };
struct Us_BFu9i_Ui { unsigned short v1; unsigned int v2:9; unsigned int v3; };
struct Us_BFu9i_Ul { unsigned short v1; unsigned int v2:9; unsigned long long v3; };
struct Us_BFu9i_Us { unsigned short v1; unsigned int v2:9; unsigned short v3; };
struct Us_BFu9i_Vp { unsigned short v1; unsigned int v2:9; void * v3; };
struct Us_BFu9ll { unsigned short v1; unsigned long long v2:9; };
struct Us_BFu9ll_BFu15i { unsigned short v1; unsigned long long v2:9; unsigned int v3:15; };
struct Us_BFu9ll_BFu15ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:15; };
struct Us_BFu9ll_BFu15s { unsigned short v1; unsigned long long v2:9; unsigned short v3:15; };
struct Us_BFu9ll_BFu16i { unsigned short v1; unsigned long long v2:9; unsigned int v3:16; };
struct Us_BFu9ll_BFu16ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:16; };
struct Us_BFu9ll_BFu16s { unsigned short v1; unsigned long long v2:9; unsigned short v3:16; };
struct Us_BFu9ll_BFu17i { unsigned short v1; unsigned long long v2:9; unsigned int v3:17; };
struct Us_BFu9ll_BFu17ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:17; };
struct Us_BFu9ll_BFu1c { unsigned short v1; unsigned long long v2:9; unsigned char v3:1; };
struct Us_BFu9ll_BFu1i { unsigned short v1; unsigned long long v2:9; unsigned int v3:1; };
struct Us_BFu9ll_BFu1ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:1; };
struct Us_BFu9ll_BFu1s { unsigned short v1; unsigned long long v2:9; unsigned short v3:1; };
struct Us_BFu9ll_BFu31i { unsigned short v1; unsigned long long v2:9; unsigned int v3:31; };
struct Us_BFu9ll_BFu31ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:31; };
struct Us_BFu9ll_BFu32i { unsigned short v1; unsigned long long v2:9; unsigned int v3:32; };
struct Us_BFu9ll_BFu32ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:32; };
struct Us_BFu9ll_BFu33 { unsigned short v1; unsigned long long v2:9; unsigned long long v3:33; };
struct Us_BFu9ll_BFu7c { unsigned short v1; unsigned long long v2:9; unsigned char v3:7; };
struct Us_BFu9ll_BFu7i { unsigned short v1; unsigned long long v2:9; unsigned int v3:7; };
struct Us_BFu9ll_BFu7ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:7; };
struct Us_BFu9ll_BFu7s { unsigned short v1; unsigned long long v2:9; unsigned short v3:7; };
struct Us_BFu9ll_BFu8c { unsigned short v1; unsigned long long v2:9; unsigned char v3:8; };
struct Us_BFu9ll_BFu8i { unsigned short v1; unsigned long long v2:9; unsigned int v3:8; };
struct Us_BFu9ll_BFu8ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:8; };
struct Us_BFu9ll_BFu8s { unsigned short v1; unsigned long long v2:9; unsigned short v3:8; };
struct Us_BFu9ll_BFu9i { unsigned short v1; unsigned long long v2:9; unsigned int v3:9; };
struct Us_BFu9ll_BFu9ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:9; };
struct Us_BFu9ll_BFu9s { unsigned short v1; unsigned long long v2:9; unsigned short v3:9; };
struct Us_BFu9ll_C { unsigned short v1; unsigned long long v2:9; char v3; };
struct Us_BFu9ll_D { unsigned short v1; unsigned long long v2:9; double v3; };
struct Us_BFu9ll_F { unsigned short v1; unsigned long long v2:9; float v3; };
struct Us_BFu9ll_I { unsigned short v1; unsigned long long v2:9; int v3; };
struct Us_BFu9ll_Ip { unsigned short v1; unsigned long long v2:9; int * v3; };
struct Us_BFu9ll_L { unsigned short v1; unsigned long long v2:9; long long v3; };
struct Us_BFu9ll_S { unsigned short v1; unsigned long long v2:9; short v3; };
struct Us_BFu9ll_Uc { unsigned short v1; unsigned long long v2:9; unsigned char v3; };
struct Us_BFu9ll_Ui { unsigned short v1; unsigned long long v2:9; unsigned int v3; };
struct Us_BFu9ll_Ul { unsigned short v1; unsigned long long v2:9; unsigned long long v3; };
struct Us_BFu9ll_Us { unsigned short v1; unsigned long long v2:9; unsigned short v3; };
struct Us_BFu9ll_Vp { unsigned short v1; unsigned long long v2:9; void * v3; };
struct Us_BFu9s { unsigned short v1; unsigned short v2:9; };
struct Us_BFu9s_BFu15i { unsigned short v1; unsigned short v2:9; unsigned int v3:15; };
struct Us_BFu9s_BFu15ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:15; };
struct Us_BFu9s_BFu15s { unsigned short v1; unsigned short v2:9; unsigned short v3:15; };
struct Us_BFu9s_BFu16i { unsigned short v1; unsigned short v2:9; unsigned int v3:16; };
struct Us_BFu9s_BFu16ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:16; };
struct Us_BFu9s_BFu16s { unsigned short v1; unsigned short v2:9; unsigned short v3:16; };
struct Us_BFu9s_BFu17i { unsigned short v1; unsigned short v2:9; unsigned int v3:17; };
struct Us_BFu9s_BFu17ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:17; };
struct Us_BFu9s_BFu1c { unsigned short v1; unsigned short v2:9; unsigned char v3:1; };
struct Us_BFu9s_BFu1i { unsigned short v1; unsigned short v2:9; unsigned int v3:1; };
struct Us_BFu9s_BFu1ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:1; };
struct Us_BFu9s_BFu1s { unsigned short v1; unsigned short v2:9; unsigned short v3:1; };
struct Us_BFu9s_BFu31i { unsigned short v1; unsigned short v2:9; unsigned int v3:31; };
struct Us_BFu9s_BFu31ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:31; };
struct Us_BFu9s_BFu32i { unsigned short v1; unsigned short v2:9; unsigned int v3:32; };
struct Us_BFu9s_BFu32ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:32; };
struct Us_BFu9s_BFu33 { unsigned short v1; unsigned short v2:9; unsigned long long v3:33; };
struct Us_BFu9s_BFu7c { unsigned short v1; unsigned short v2:9; unsigned char v3:7; };
struct Us_BFu9s_BFu7i { unsigned short v1; unsigned short v2:9; unsigned int v3:7; };
struct Us_BFu9s_BFu7ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:7; };
struct Us_BFu9s_BFu7s { unsigned short v1; unsigned short v2:9; unsigned short v3:7; };
struct Us_BFu9s_BFu8c { unsigned short v1; unsigned short v2:9; unsigned char v3:8; };
struct Us_BFu9s_BFu8i { unsigned short v1; unsigned short v2:9; unsigned int v3:8; };
struct Us_BFu9s_BFu8ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:8; };
struct Us_BFu9s_BFu8s { unsigned short v1; unsigned short v2:9; unsigned short v3:8; };
struct Us_BFu9s_BFu9i { unsigned short v1; unsigned short v2:9; unsigned int v3:9; };
struct Us_BFu9s_BFu9ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:9; };
struct Us_BFu9s_BFu9s { unsigned short v1; unsigned short v2:9; unsigned short v3:9; };
struct Us_BFu9s_C { unsigned short v1; unsigned short v2:9; char v3; };
struct Us_BFu9s_D { unsigned short v1; unsigned short v2:9; double v3; };
struct Us_BFu9s_F { unsigned short v1; unsigned short v2:9; float v3; };
struct Us_BFu9s_I { unsigned short v1; unsigned short v2:9; int v3; };
struct Us_BFu9s_Ip { unsigned short v1; unsigned short v2:9; int * v3; };
struct Us_BFu9s_L { unsigned short v1; unsigned short v2:9; long long v3; };
struct Us_BFu9s_S { unsigned short v1; unsigned short v2:9; short v3; };
struct Us_BFu9s_Uc { unsigned short v1; unsigned short v2:9; unsigned char v3; };
struct Us_BFu9s_Ui { unsigned short v1; unsigned short v2:9; unsigned int v3; };
struct Us_BFu9s_Ul { unsigned short v1; unsigned short v2:9; unsigned long long v3; };
struct Us_BFu9s_Us { unsigned short v1; unsigned short v2:9; unsigned short v3; };
struct Us_BFu9s_Vp { unsigned short v1; unsigned short v2:9; void * v3; };
struct Us_C { unsigned short v1; char v2; };
struct Us_C_BFu15i { unsigned short v1; char v2; unsigned int v3:15; };
struct Us_C_BFu15ll { unsigned short v1; char v2; unsigned long long v3:15; };
struct Us_C_BFu15s { unsigned short v1; char v2; unsigned short v3:15; };
struct Us_C_BFu16i { unsigned short v1; char v2; unsigned int v3:16; };
struct Us_C_BFu16ll { unsigned short v1; char v2; unsigned long long v3:16; };
struct Us_C_BFu16s { unsigned short v1; char v2; unsigned short v3:16; };
struct Us_C_BFu17i { unsigned short v1; char v2; unsigned int v3:17; };
struct Us_C_BFu17ll { unsigned short v1; char v2; unsigned long long v3:17; };
struct Us_C_BFu1c { unsigned short v1; char v2; unsigned char v3:1; };
struct Us_C_BFu1i { unsigned short v1; char v2; unsigned int v3:1; };
struct Us_C_BFu1ll { unsigned short v1; char v2; unsigned long long v3:1; };
struct Us_C_BFu1s { unsigned short v1; char v2; unsigned short v3:1; };
struct Us_C_BFu31i { unsigned short v1; char v2; unsigned int v3:31; };
struct Us_C_BFu31ll { unsigned short v1; char v2; unsigned long long v3:31; };
struct Us_C_BFu32i { unsigned short v1; char v2; unsigned int v3:32; };
struct Us_C_BFu32ll { unsigned short v1; char v2; unsigned long long v3:32; };
struct Us_C_BFu33 { unsigned short v1; char v2; unsigned long long v3:33; };
struct Us_C_BFu7c { unsigned short v1; char v2; unsigned char v3:7; };
struct Us_C_BFu7i { unsigned short v1; char v2; unsigned int v3:7; };
struct Us_C_BFu7ll { unsigned short v1; char v2; unsigned long long v3:7; };
struct Us_C_BFu7s { unsigned short v1; char v2; unsigned short v3:7; };
struct Us_C_BFu8c { unsigned short v1; char v2; unsigned char v3:8; };
struct Us_C_BFu8i { unsigned short v1; char v2; unsigned int v3:8; };
struct Us_C_BFu8ll { unsigned short v1; char v2; unsigned long long v3:8; };
struct Us_C_BFu8s { unsigned short v1; char v2; unsigned short v3:8; };
struct Us_C_BFu9i { unsigned short v1; char v2; unsigned int v3:9; };
struct Us_C_BFu9ll { unsigned short v1; char v2; unsigned long long v3:9; };
struct Us_C_BFu9s { unsigned short v1; char v2; unsigned short v3:9; };
struct Us_C_C { unsigned short v1; char v2; char v3; };
struct Us_C_D { unsigned short v1; char v2; double v3; };
struct Us_C_F { unsigned short v1; char v2; float v3; };
struct Us_C_I { unsigned short v1; char v2; int v3; };
struct Us_C_Ip { unsigned short v1; char v2; int * v3; };
struct Us_C_L { unsigned short v1; char v2; long long v3; };
struct Us_C_S { unsigned short v1; char v2; short v3; };
struct Us_C_Uc { unsigned short v1; char v2; unsigned char v3; };
struct Us_C_Ui { unsigned short v1; char v2; unsigned int v3; };
struct Us_C_Ul { unsigned short v1; char v2; unsigned long long v3; };
struct Us_C_Us { unsigned short v1; char v2; unsigned short v3; };
struct Us_C_Vp { unsigned short v1; char v2; void * v3; };
struct Us_D { unsigned short v1; double v2; };
struct Us_D_BFu15i { unsigned short v1; double v2; unsigned int v3:15; };
struct Us_D_BFu15ll { unsigned short v1; double v2; unsigned long long v3:15; };
struct Us_D_BFu15s { unsigned short v1; double v2; unsigned short v3:15; };
struct Us_D_BFu16i { unsigned short v1; double v2; unsigned int v3:16; };
struct Us_D_BFu16ll { unsigned short v1; double v2; unsigned long long v3:16; };
struct Us_D_BFu16s { unsigned short v1; double v2; unsigned short v3:16; };
struct Us_D_BFu17i { unsigned short v1; double v2; unsigned int v3:17; };
struct Us_D_BFu17ll { unsigned short v1; double v2; unsigned long long v3:17; };
struct Us_D_BFu1c { unsigned short v1; double v2; unsigned char v3:1; };
struct Us_D_BFu1i { unsigned short v1; double v2; unsigned int v3:1; };
struct Us_D_BFu1ll { unsigned short v1; double v2; unsigned long long v3:1; };
struct Us_D_BFu1s { unsigned short v1; double v2; unsigned short v3:1; };
struct Us_D_BFu31i { unsigned short v1; double v2; unsigned int v3:31; };
struct Us_D_BFu31ll { unsigned short v1; double v2; unsigned long long v3:31; };
struct Us_D_BFu32i { unsigned short v1; double v2; unsigned int v3:32; };
struct Us_D_BFu32ll { unsigned short v1; double v2; unsigned long long v3:32; };
struct Us_D_BFu33 { unsigned short v1; double v2; unsigned long long v3:33; };
struct Us_D_BFu7c { unsigned short v1; double v2; unsigned char v3:7; };
struct Us_D_BFu7i { unsigned short v1; double v2; unsigned int v3:7; };
struct Us_D_BFu7ll { unsigned short v1; double v2; unsigned long long v3:7; };
struct Us_D_BFu7s { unsigned short v1; double v2; unsigned short v3:7; };
struct Us_D_BFu8c { unsigned short v1; double v2; unsigned char v3:8; };
struct Us_D_BFu8i { unsigned short v1; double v2; unsigned int v3:8; };
struct Us_D_BFu8ll { unsigned short v1; double v2; unsigned long long v3:8; };
struct Us_D_BFu8s { unsigned short v1; double v2; unsigned short v3:8; };
struct Us_D_BFu9i { unsigned short v1; double v2; unsigned int v3:9; };
struct Us_D_BFu9ll { unsigned short v1; double v2; unsigned long long v3:9; };
struct Us_D_BFu9s { unsigned short v1; double v2; unsigned short v3:9; };
struct Us_D_C { unsigned short v1; double v2; char v3; };
struct Us_D_D { unsigned short v1; double v2; double v3; };
struct Us_D_F { unsigned short v1; double v2; float v3; };
struct Us_D_I { unsigned short v1; double v2; int v3; };
struct Us_D_Ip { unsigned short v1; double v2; int * v3; };
struct Us_D_L { unsigned short v1; double v2; long long v3; };
struct Us_D_S { unsigned short v1; double v2; short v3; };
struct Us_D_Uc { unsigned short v1; double v2; unsigned char v3; };
struct Us_D_Ui { unsigned short v1; double v2; unsigned int v3; };
struct Us_D_Ul { unsigned short v1; double v2; unsigned long long v3; };
struct Us_D_Us { unsigned short v1; double v2; unsigned short v3; };
struct Us_D_Vp { unsigned short v1; double v2; void * v3; };
struct Us_F { unsigned short v1; float v2; };
struct Us_F_BFu15i { unsigned short v1; float v2; unsigned int v3:15; };
struct Us_F_BFu15ll { unsigned short v1; float v2; unsigned long long v3:15; };
struct Us_F_BFu15s { unsigned short v1; float v2; unsigned short v3:15; };
struct Us_F_BFu16i { unsigned short v1; float v2; unsigned int v3:16; };
struct Us_F_BFu16ll { unsigned short v1; float v2; unsigned long long v3:16; };
struct Us_F_BFu16s { unsigned short v1; float v2; unsigned short v3:16; };
struct Us_F_BFu17i { unsigned short v1; float v2; unsigned int v3:17; };
struct Us_F_BFu17ll { unsigned short v1; float v2; unsigned long long v3:17; };
struct Us_F_BFu1c { unsigned short v1; float v2; unsigned char v3:1; };
struct Us_F_BFu1i { unsigned short v1; float v2; unsigned int v3:1; };
struct Us_F_BFu1ll { unsigned short v1; float v2; unsigned long long v3:1; };
struct Us_F_BFu1s { unsigned short v1; float v2; unsigned short v3:1; };
struct Us_F_BFu31i { unsigned short v1; float v2; unsigned int v3:31; };
struct Us_F_BFu31ll { unsigned short v1; float v2; unsigned long long v3:31; };
struct Us_F_BFu32i { unsigned short v1; float v2; unsigned int v3:32; };
struct Us_F_BFu32ll { unsigned short v1; float v2; unsigned long long v3:32; };
struct Us_F_BFu33 { unsigned short v1; float v2; unsigned long long v3:33; };
struct Us_F_BFu7c { unsigned short v1; float v2; unsigned char v3:7; };
struct Us_F_BFu7i { unsigned short v1; float v2; unsigned int v3:7; };
struct Us_F_BFu7ll { unsigned short v1; float v2; unsigned long long v3:7; };
struct Us_F_BFu7s { unsigned short v1; float v2; unsigned short v3:7; };
struct Us_F_BFu8c { unsigned short v1; float v2; unsigned char v3:8; };
struct Us_F_BFu8i { unsigned short v1; float v2; unsigned int v3:8; };
struct Us_F_BFu8ll { unsigned short v1; float v2; unsigned long long v3:8; };
struct Us_F_BFu8s { unsigned short v1; float v2; unsigned short v3:8; };
struct Us_F_BFu9i { unsigned short v1; float v2; unsigned int v3:9; };
struct Us_F_BFu9ll { unsigned short v1; float v2; unsigned long long v3:9; };
struct Us_F_BFu9s { unsigned short v1; float v2; unsigned short v3:9; };
struct Us_F_C { unsigned short v1; float v2; char v3; };
struct Us_F_D { unsigned short v1; float v2; double v3; };
struct Us_F_F { unsigned short v1; float v2; float v3; };
struct Us_F_I { unsigned short v1; float v2; int v3; };
struct Us_F_Ip { unsigned short v1; float v2; int * v3; };
struct Us_F_L { unsigned short v1; float v2; long long v3; };
struct Us_F_S { unsigned short v1; float v2; short v3; };
struct Us_F_Uc { unsigned short v1; float v2; unsigned char v3; };
struct Us_F_Ui { unsigned short v1; float v2; unsigned int v3; };
struct Us_F_Ul { unsigned short v1; float v2; unsigned long long v3; };


static void Test_Ui_Ul_L()
{
  {
    init_simple_test("Ui_Ul_L");
    STRUCT_IF_C Ui_Ul_L lv;
    check2(sizeof(lv), 20, "sizeof(Ui_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_L)");
    check_field_offset(lv, v1, 0, "Ui_Ul_L.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_L.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_L, Ui_Ul_L)
//============================================================================



static void Test_Ui_Ul_S()
{
  {
    init_simple_test("Ui_Ul_S");
    STRUCT_IF_C Ui_Ul_S lv;
    check2(sizeof(lv), 14, "sizeof(Ui_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_S)");
    check_field_offset(lv, v1, 0, "Ui_Ul_S.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_S.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_S, Ui_Ul_S)
//============================================================================



static void Test_Ui_Ul_Uc()
{
  {
    init_simple_test("Ui_Ul_Uc");
    STRUCT_IF_C Ui_Ul_Uc lv;
    check2(sizeof(lv), 13, "sizeof(Ui_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_Uc)");
    check_field_offset(lv, v1, 0, "Ui_Ul_Uc.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_Uc.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_Uc, Ui_Ul_Uc)
//============================================================================



static void Test_Ui_Ul_Ui()
{
  {
    init_simple_test("Ui_Ul_Ui");
    STRUCT_IF_C Ui_Ul_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ui_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_Ui)");
    check_field_offset(lv, v1, 0, "Ui_Ul_Ui.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_Ui.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_Ui, Ui_Ul_Ui)
//============================================================================



static void Test_Ui_Ul_Ul()
{
  {
    init_simple_test("Ui_Ul_Ul");
    STRUCT_IF_C Ui_Ul_Ul lv;
    check2(sizeof(lv), 20, "sizeof(Ui_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_Ul)");
    check_field_offset(lv, v1, 0, "Ui_Ul_Ul.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_Ul.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_Ul, Ui_Ul_Ul)
//============================================================================



static void Test_Ui_Ul_Us()
{
  {
    init_simple_test("Ui_Ul_Us");
    STRUCT_IF_C Ui_Ul_Us lv;
    check2(sizeof(lv), 14, "sizeof(Ui_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_Us)");
    check_field_offset(lv, v1, 0, "Ui_Ul_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_Us.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_Us, Ui_Ul_Us)
//============================================================================



static void Test_Ui_Ul_Vp()
{
  {
    init_simple_test("Ui_Ul_Vp");
    STRUCT_IF_C Ui_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ui_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Ul_Vp)");
    check_field_offset(lv, v1, 0, "Ui_Ul_Vp.v1");
    check_field_offset(lv, v2, 4, "Ui_Ul_Vp.v2");
    check_field_offset(lv, v3, 12, "Ui_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Ul_Vp, Ui_Ul_Vp)
//============================================================================



static void Test_Ui_Us()
{
  {
    init_simple_test("Ui_Us");
    STRUCT_IF_C Ui_Us lv;
    check2(sizeof(lv), 6, "sizeof(Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us)");
    check_field_offset(lv, v1, 0, "Ui_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us, Ui_Us)
//============================================================================



static void Test_Ui_Us_BFu15i()
{
  {
    init_simple_test("Ui_Us_BFu15i");
    static STRUCT_IF_C Ui_Us_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu15i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_Us_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu15i, Ui_Us_BFu15i)
//============================================================================



static void Test_Ui_Us_BFu15ll()
{
  {
    init_simple_test("Ui_Us_BFu15ll");
    static STRUCT_IF_C Ui_Us_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_Us_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu15ll, Ui_Us_BFu15ll)
//============================================================================



static void Test_Ui_Us_BFu15s()
{
  {
    init_simple_test("Ui_Us_BFu15s");
    static STRUCT_IF_C Ui_Us_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu15s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Ui_Us_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Ui_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu15s, Ui_Us_BFu15s)
//============================================================================



static void Test_Ui_Us_BFu16i()
{
  {
    init_simple_test("Ui_Us_BFu16i");
    static STRUCT_IF_C Ui_Us_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu16i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_Us_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu16i, Ui_Us_BFu16i)
//============================================================================



static void Test_Ui_Us_BFu16ll()
{
  {
    init_simple_test("Ui_Us_BFu16ll");
    static STRUCT_IF_C Ui_Us_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_Us_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu16ll, Ui_Us_BFu16ll)
//============================================================================



static void Test_Ui_Us_BFu16s()
{
  {
    init_simple_test("Ui_Us_BFu16s");
    static STRUCT_IF_C Ui_Us_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu16s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Ui_Us_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Ui_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu16s, Ui_Us_BFu16s)
//============================================================================



static void Test_Ui_Us_BFu17i()
{
  {
    init_simple_test("Ui_Us_BFu17i");
    static STRUCT_IF_C Ui_Us_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(Ui_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu17i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "Ui_Us_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "Ui_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu17i, Ui_Us_BFu17i)
//============================================================================



static void Test_Ui_Us_BFu17ll()
{
  {
    init_simple_test("Ui_Us_BFu17ll");
    static STRUCT_IF_C Ui_Us_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(Ui_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "Ui_Us_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "Ui_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu17ll, Ui_Us_BFu17ll)
//============================================================================



static void Test_Ui_Us_BFu1c()
{
  {
    init_simple_test("Ui_Us_BFu1c");
    static STRUCT_IF_C Ui_Us_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu1c.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu1c, Ui_Us_BFu1c)
//============================================================================



static void Test_Ui_Us_BFu1i()
{
  {
    init_simple_test("Ui_Us_BFu1i");
    static STRUCT_IF_C Ui_Us_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu1i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu1i, Ui_Us_BFu1i)
//============================================================================



static void Test_Ui_Us_BFu1ll()
{
  {
    init_simple_test("Ui_Us_BFu1ll");
    static STRUCT_IF_C Ui_Us_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu1ll, Ui_Us_BFu1ll)
//============================================================================



static void Test_Ui_Us_BFu1s()
{
  {
    init_simple_test("Ui_Us_BFu1s");
    static STRUCT_IF_C Ui_Us_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu1s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "Ui_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu1s, Ui_Us_BFu1s)
//============================================================================



static void Test_Ui_Us_BFu31i()
{
  {
    init_simple_test("Ui_Us_BFu31i");
    static STRUCT_IF_C Ui_Us_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu31i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "Ui_Us_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "Ui_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu31i, Ui_Us_BFu31i)
//============================================================================



static void Test_Ui_Us_BFu31ll()
{
  {
    init_simple_test("Ui_Us_BFu31ll");
    static STRUCT_IF_C Ui_Us_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "Ui_Us_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "Ui_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu31ll, Ui_Us_BFu31ll)
//============================================================================



static void Test_Ui_Us_BFu32i()
{
  {
    init_simple_test("Ui_Us_BFu32i");
    static STRUCT_IF_C Ui_Us_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu32i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "Ui_Us_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "Ui_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu32i, Ui_Us_BFu32i)
//============================================================================



static void Test_Ui_Us_BFu32ll()
{
  {
    init_simple_test("Ui_Us_BFu32ll");
    static STRUCT_IF_C Ui_Us_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "Ui_Us_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "Ui_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu32ll, Ui_Us_BFu32ll)
//============================================================================



static void Test_Ui_Us_BFu33()
{
  {
    init_simple_test("Ui_Us_BFu33");
    static STRUCT_IF_C Ui_Us_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(Ui_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu33.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "Ui_Us_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "Ui_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu33, Ui_Us_BFu33)
//============================================================================



static void Test_Ui_Us_BFu7c()
{
  {
    init_simple_test("Ui_Us_BFu7c");
    static STRUCT_IF_C Ui_Us_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu7c.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_Us_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu7c, Ui_Us_BFu7c)
//============================================================================



static void Test_Ui_Us_BFu7i()
{
  {
    init_simple_test("Ui_Us_BFu7i");
    static STRUCT_IF_C Ui_Us_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu7i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_Us_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu7i, Ui_Us_BFu7i)
//============================================================================



static void Test_Ui_Us_BFu7ll()
{
  {
    init_simple_test("Ui_Us_BFu7ll");
    static STRUCT_IF_C Ui_Us_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_Us_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu7ll, Ui_Us_BFu7ll)
//============================================================================



static void Test_Ui_Us_BFu7s()
{
  {
    init_simple_test("Ui_Us_BFu7s");
    static STRUCT_IF_C Ui_Us_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu7s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Ui_Us_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Ui_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu7s, Ui_Us_BFu7s)
//============================================================================



static void Test_Ui_Us_BFu8c()
{
  {
    init_simple_test("Ui_Us_BFu8c");
    static STRUCT_IF_C Ui_Us_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu8c.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_Us_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu8c, Ui_Us_BFu8c)
//============================================================================



static void Test_Ui_Us_BFu8i()
{
  {
    init_simple_test("Ui_Us_BFu8i");
    static STRUCT_IF_C Ui_Us_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu8i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_Us_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu8i, Ui_Us_BFu8i)
//============================================================================



static void Test_Ui_Us_BFu8ll()
{
  {
    init_simple_test("Ui_Us_BFu8ll");
    static STRUCT_IF_C Ui_Us_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_Us_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu8ll, Ui_Us_BFu8ll)
//============================================================================



static void Test_Ui_Us_BFu8s()
{
  {
    init_simple_test("Ui_Us_BFu8s");
    static STRUCT_IF_C Ui_Us_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu8s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Ui_Us_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Ui_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu8s, Ui_Us_BFu8s)
//============================================================================



static void Test_Ui_Us_BFu9i()
{
  {
    init_simple_test("Ui_Us_BFu9i");
    static STRUCT_IF_C Ui_Us_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu9i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_Us_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu9i, Ui_Us_BFu9i)
//============================================================================



static void Test_Ui_Us_BFu9ll()
{
  {
    init_simple_test("Ui_Us_BFu9ll");
    static STRUCT_IF_C Ui_Us_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_Us_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu9ll, Ui_Us_BFu9ll)
//============================================================================



static void Test_Ui_Us_BFu9s()
{
  {
    init_simple_test("Ui_Us_BFu9s");
    static STRUCT_IF_C Ui_Us_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu9s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Ui_Us_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Ui_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_BFu9s, Ui_Us_BFu9s)
//============================================================================



static void Test_Ui_Us_C()
{
  {
    init_simple_test("Ui_Us_C");
    STRUCT_IF_C Ui_Us_C lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_C)");
    check_field_offset(lv, v1, 0, "Ui_Us_C.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_C.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_C, Ui_Us_C)
//============================================================================



static void Test_Ui_Us_D()
{
  {
    init_simple_test("Ui_Us_D");
    STRUCT_IF_C Ui_Us_D lv;
    check2(sizeof(lv), 14, "sizeof(Ui_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_D)");
    check_field_offset(lv, v1, 0, "Ui_Us_D.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_D.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_D, Ui_Us_D)
//============================================================================



static void Test_Ui_Us_F()
{
  {
    init_simple_test("Ui_Us_F");
    STRUCT_IF_C Ui_Us_F lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_F)");
    check_field_offset(lv, v1, 0, "Ui_Us_F.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_F.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_F, Ui_Us_F)
//============================================================================



static void Test_Ui_Us_I()
{
  {
    init_simple_test("Ui_Us_I");
    STRUCT_IF_C Ui_Us_I lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_I)");
    check_field_offset(lv, v1, 0, "Ui_Us_I.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_I.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_I, Ui_Us_I)
//============================================================================



static void Test_Ui_Us_Ip()
{
  {
    init_simple_test("Ui_Us_Ip");
    STRUCT_IF_C Ui_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_Ip)");
    check_field_offset(lv, v1, 0, "Ui_Us_Ip.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_Ip.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_Ip, Ui_Us_Ip)
//============================================================================



static void Test_Ui_Us_L()
{
  {
    init_simple_test("Ui_Us_L");
    STRUCT_IF_C Ui_Us_L lv;
    check2(sizeof(lv), 14, "sizeof(Ui_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_L)");
    check_field_offset(lv, v1, 0, "Ui_Us_L.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_L.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_L, Ui_Us_L)
//============================================================================



static void Test_Ui_Us_S()
{
  {
    init_simple_test("Ui_Us_S");
    STRUCT_IF_C Ui_Us_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_S)");
    check_field_offset(lv, v1, 0, "Ui_Us_S.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_S.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_S, Ui_Us_S)
//============================================================================



static void Test_Ui_Us_Uc()
{
  {
    init_simple_test("Ui_Us_Uc");
    STRUCT_IF_C Ui_Us_Uc lv;
    check2(sizeof(lv), 7, "sizeof(Ui_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_Uc)");
    check_field_offset(lv, v1, 0, "Ui_Us_Uc.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_Uc.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_Uc, Ui_Us_Uc)
//============================================================================



static void Test_Ui_Us_Ui()
{
  {
    init_simple_test("Ui_Us_Ui");
    STRUCT_IF_C Ui_Us_Ui lv;
    check2(sizeof(lv), 10, "sizeof(Ui_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_Ui)");
    check_field_offset(lv, v1, 0, "Ui_Us_Ui.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_Ui.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_Ui, Ui_Us_Ui)
//============================================================================



static void Test_Ui_Us_Ul()
{
  {
    init_simple_test("Ui_Us_Ul");
    STRUCT_IF_C Ui_Us_Ul lv;
    check2(sizeof(lv), 14, "sizeof(Ui_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_Ul)");
    check_field_offset(lv, v1, 0, "Ui_Us_Ul.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_Ul.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_Ul, Ui_Us_Ul)
//============================================================================



static void Test_Ui_Us_Us()
{
  {
    init_simple_test("Ui_Us_Us");
    STRUCT_IF_C Ui_Us_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_Us)");
    check_field_offset(lv, v1, 0, "Ui_Us_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_Us.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_Us, Ui_Us_Us)
//============================================================================



static void Test_Ui_Us_Vp()
{
  {
    init_simple_test("Ui_Us_Vp");
    STRUCT_IF_C Ui_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Us_Vp)");
    check_field_offset(lv, v1, 0, "Ui_Us_Vp.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_Vp.v2");
    check_field_offset(lv, v3, 6, "Ui_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Us_Vp, Ui_Us_Vp)
//============================================================================



static void Test_Ui_Vp()
{
  {
    init_simple_test("Ui_Vp");
    STRUCT_IF_C Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp)");
    check_field_offset(lv, v1, 0, "Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp, Ui_Vp)
//============================================================================



static void Test_Ui_Vp_BFu15i()
{
  {
    init_simple_test("Ui_Vp_BFu15i");
    static STRUCT_IF_C Ui_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ui_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ui_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu15i, Ui_Vp_BFu15i)
//============================================================================



static void Test_Ui_Vp_BFu15ll()
{
  {
    init_simple_test("Ui_Vp_BFu15ll");
    static STRUCT_IF_C Ui_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ui_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ui_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu15ll, Ui_Vp_BFu15ll)
//============================================================================



static void Test_Ui_Vp_BFu15s()
{
  {
    init_simple_test("Ui_Vp_BFu15s");
    static STRUCT_IF_C Ui_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "Ui_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "Ui_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu15s, Ui_Vp_BFu15s)
//============================================================================



static void Test_Ui_Vp_BFu16i()
{
  {
    init_simple_test("Ui_Vp_BFu16i");
    static STRUCT_IF_C Ui_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ui_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ui_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu16i, Ui_Vp_BFu16i)
//============================================================================



static void Test_Ui_Vp_BFu16ll()
{
  {
    init_simple_test("Ui_Vp_BFu16ll");
    static STRUCT_IF_C Ui_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ui_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ui_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu16ll, Ui_Vp_BFu16ll)
//============================================================================



static void Test_Ui_Vp_BFu16s()
{
  {
    init_simple_test("Ui_Vp_BFu16s");
    static STRUCT_IF_C Ui_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "Ui_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "Ui_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu16s, Ui_Vp_BFu16s)
//============================================================================



static void Test_Ui_Vp_BFu17i()
{
  {
    init_simple_test("Ui_Vp_BFu17i");
    static STRUCT_IF_C Ui_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Ui_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ui_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ui_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu17i, Ui_Vp_BFu17i)
//============================================================================



static void Test_Ui_Vp_BFu17ll()
{
  {
    init_simple_test("Ui_Vp_BFu17ll");
    static STRUCT_IF_C Ui_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(Ui_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "Ui_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "Ui_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu17ll, Ui_Vp_BFu17ll)
//============================================================================



static void Test_Ui_Vp_BFu1c()
{
  {
    init_simple_test("Ui_Vp_BFu1c");
    static STRUCT_IF_C Ui_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ui_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu1c, Ui_Vp_BFu1c)
//============================================================================



static void Test_Ui_Vp_BFu1i()
{
  {
    init_simple_test("Ui_Vp_BFu1i");
    static STRUCT_IF_C Ui_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ui_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu1i, Ui_Vp_BFu1i)
//============================================================================



static void Test_Ui_Vp_BFu1ll()
{
  {
    init_simple_test("Ui_Vp_BFu1ll");
    static STRUCT_IF_C Ui_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ui_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu1ll, Ui_Vp_BFu1ll)
//============================================================================



static void Test_Ui_Vp_BFu1s()
{
  {
    init_simple_test("Ui_Vp_BFu1s");
    static STRUCT_IF_C Ui_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "Ui_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu1s, Ui_Vp_BFu1s)
//============================================================================



static void Test_Ui_Vp_BFu31i()
{
  {
    init_simple_test("Ui_Vp_BFu31i");
    static STRUCT_IF_C Ui_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ui_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ui_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu31i, Ui_Vp_BFu31i)
//============================================================================



static void Test_Ui_Vp_BFu31ll()
{
  {
    init_simple_test("Ui_Vp_BFu31ll");
    static STRUCT_IF_C Ui_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "Ui_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "Ui_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu31ll, Ui_Vp_BFu31ll)
//============================================================================



static void Test_Ui_Vp_BFu32i()
{
  {
    init_simple_test("Ui_Vp_BFu32i");
    static STRUCT_IF_C Ui_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ui_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ui_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu32i, Ui_Vp_BFu32i)
//============================================================================



static void Test_Ui_Vp_BFu32ll()
{
  {
    init_simple_test("Ui_Vp_BFu32ll");
    static STRUCT_IF_C Ui_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "Ui_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "Ui_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu32ll, Ui_Vp_BFu32ll)
//============================================================================



static void Test_Ui_Vp_BFu33()
{
  {
    init_simple_test("Ui_Vp_BFu33");
    static STRUCT_IF_C Ui_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ui_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu33.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "Ui_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "Ui_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu33, Ui_Vp_BFu33)
//============================================================================



static void Test_Ui_Vp_BFu7c()
{
  {
    init_simple_test("Ui_Vp_BFu7c");
    static STRUCT_IF_C Ui_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ui_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ui_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu7c, Ui_Vp_BFu7c)
//============================================================================



static void Test_Ui_Vp_BFu7i()
{
  {
    init_simple_test("Ui_Vp_BFu7i");
    static STRUCT_IF_C Ui_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ui_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ui_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu7i, Ui_Vp_BFu7i)
//============================================================================



static void Test_Ui_Vp_BFu7ll()
{
  {
    init_simple_test("Ui_Vp_BFu7ll");
    static STRUCT_IF_C Ui_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ui_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ui_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu7ll, Ui_Vp_BFu7ll)
//============================================================================



static void Test_Ui_Vp_BFu7s()
{
  {
    init_simple_test("Ui_Vp_BFu7s");
    static STRUCT_IF_C Ui_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "Ui_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "Ui_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu7s, Ui_Vp_BFu7s)
//============================================================================



static void Test_Ui_Vp_BFu8c()
{
  {
    init_simple_test("Ui_Vp_BFu8c");
    static STRUCT_IF_C Ui_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ui_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ui_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu8c, Ui_Vp_BFu8c)
//============================================================================



static void Test_Ui_Vp_BFu8i()
{
  {
    init_simple_test("Ui_Vp_BFu8i");
    static STRUCT_IF_C Ui_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ui_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ui_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu8i, Ui_Vp_BFu8i)
//============================================================================



static void Test_Ui_Vp_BFu8ll()
{
  {
    init_simple_test("Ui_Vp_BFu8ll");
    static STRUCT_IF_C Ui_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ui_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ui_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu8ll, Ui_Vp_BFu8ll)
//============================================================================



static void Test_Ui_Vp_BFu8s()
{
  {
    init_simple_test("Ui_Vp_BFu8s");
    static STRUCT_IF_C Ui_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "Ui_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "Ui_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu8s, Ui_Vp_BFu8s)
//============================================================================



static void Test_Ui_Vp_BFu9i()
{
  {
    init_simple_test("Ui_Vp_BFu9i");
    static STRUCT_IF_C Ui_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ui_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ui_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu9i, Ui_Vp_BFu9i)
//============================================================================



static void Test_Ui_Vp_BFu9ll()
{
  {
    init_simple_test("Ui_Vp_BFu9ll");
    static STRUCT_IF_C Ui_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ui_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ui_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu9ll, Ui_Vp_BFu9ll)
//============================================================================



static void Test_Ui_Vp_BFu9s()
{
  {
    init_simple_test("Ui_Vp_BFu9s");
    static STRUCT_IF_C Ui_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "Ui_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "Ui_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_BFu9s, Ui_Vp_BFu9s)
//============================================================================



static void Test_Ui_Vp_C()
{
  {
    init_simple_test("Ui_Vp_C");
    STRUCT_IF_C Ui_Vp_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_C)");
    check_field_offset(lv, v1, 0, "Ui_Vp_C.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_C, Ui_Vp_C)
//============================================================================



static void Test_Ui_Vp_D()
{
  {
    init_simple_test("Ui_Vp_D");
    STRUCT_IF_C Ui_Vp_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ui_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_D)");
    check_field_offset(lv, v1, 0, "Ui_Vp_D.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_D, Ui_Vp_D)
//============================================================================



static void Test_Ui_Vp_F()
{
  {
    init_simple_test("Ui_Vp_F");
    STRUCT_IF_C Ui_Vp_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_F)");
    check_field_offset(lv, v1, 0, "Ui_Vp_F.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_F, Ui_Vp_F)
//============================================================================



static void Test_Ui_Vp_I()
{
  {
    init_simple_test("Ui_Vp_I");
    STRUCT_IF_C Ui_Vp_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_I)");
    check_field_offset(lv, v1, 0, "Ui_Vp_I.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_I, Ui_Vp_I)
//============================================================================



static void Test_Ui_Vp_Ip()
{
  {
    init_simple_test("Ui_Vp_Ip");
    STRUCT_IF_C Ui_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Ui_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_Ip)");
    check_field_offset(lv, v1, 0, "Ui_Vp_Ip.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_Ip, Ui_Vp_Ip)
//============================================================================



static void Test_Ui_Vp_L()
{
  {
    init_simple_test("Ui_Vp_L");
    STRUCT_IF_C Ui_Vp_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ui_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_L)");
    check_field_offset(lv, v1, 0, "Ui_Vp_L.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_L, Ui_Vp_L)
//============================================================================



static void Test_Ui_Vp_S()
{
  {
    init_simple_test("Ui_Vp_S");
    STRUCT_IF_C Ui_Vp_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_S)");
    check_field_offset(lv, v1, 0, "Ui_Vp_S.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_S, Ui_Vp_S)
//============================================================================



static void Test_Ui_Vp_Uc()
{
  {
    init_simple_test("Ui_Vp_Uc");
    STRUCT_IF_C Ui_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Ui_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_Uc)");
    check_field_offset(lv, v1, 0, "Ui_Vp_Uc.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_Uc, Ui_Vp_Uc)
//============================================================================



static void Test_Ui_Vp_Ui()
{
  {
    init_simple_test("Ui_Vp_Ui");
    STRUCT_IF_C Ui_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_Ui)");
    check_field_offset(lv, v1, 0, "Ui_Vp_Ui.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_Ui, Ui_Vp_Ui)
//============================================================================



static void Test_Ui_Vp_Ul()
{
  {
    init_simple_test("Ui_Vp_Ul");
    STRUCT_IF_C Ui_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ui_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_Ul)");
    check_field_offset(lv, v1, 0, "Ui_Vp_Ul.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_Ul, Ui_Vp_Ul)
//============================================================================



static void Test_Ui_Vp_Us()
{
  {
    init_simple_test("Ui_Vp_Us");
    STRUCT_IF_C Ui_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Ui_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_Us)");
    check_field_offset(lv, v1, 0, "Ui_Vp_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_Us, Ui_Vp_Us)
//============================================================================



static void Test_Ui_Vp_Vp()
{
  {
    init_simple_test("Ui_Vp_Vp");
    STRUCT_IF_C Ui_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(Ui_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ui_Vp_Vp)");
    check_field_offset(lv, v1, 0, "Ui_Vp_Vp.v1");
    check_field_offset(lv, v2, 4, "Ui_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "Ui_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ui_Vp_Vp, Ui_Vp_Vp)
//============================================================================



static void Test_Ul()
{
  {
    init_simple_test("Ul");
    STRUCT_IF_C Ul lv;
    check2(sizeof(lv), 8, "sizeof(Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul)");
    check_field_offset(lv, v1, 0, "Ul.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul, Ul)
//============================================================================



static void Test_Ul_BFu15i()
{
  {
    init_simple_test("Ul_BFu15i");
    static STRUCT_IF_C Ul_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i, Ul_BFu15i)
//============================================================================



static void Test_Ul_BFu15i_BFu15i()
{
  {
    init_simple_test("Ul_BFu15i_BFu15i");
    static STRUCT_IF_C Ul_BFu15i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu15i, Ul_BFu15i_BFu15i)
//============================================================================



static void Test_Ul_BFu15i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu15ll");
    static STRUCT_IF_C Ul_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu15ll, Ul_BFu15i_BFu15ll)
//============================================================================



static void Test_Ul_BFu15i_BFu15s()
{
  {
    init_simple_test("Ul_BFu15i_BFu15s");
    static STRUCT_IF_C Ul_BFu15i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu15s, Ul_BFu15i_BFu15s)
//============================================================================



static void Test_Ul_BFu15i_BFu16i()
{
  {
    init_simple_test("Ul_BFu15i_BFu16i");
    static STRUCT_IF_C Ul_BFu15i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu16i, Ul_BFu15i_BFu16i)
//============================================================================



static void Test_Ul_BFu15i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu16ll");
    static STRUCT_IF_C Ul_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu16ll, Ul_BFu15i_BFu16ll)
//============================================================================



static void Test_Ul_BFu15i_BFu16s()
{
  {
    init_simple_test("Ul_BFu15i_BFu16s");
    static STRUCT_IF_C Ul_BFu15i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu16s, Ul_BFu15i_BFu16s)
//============================================================================



static void Test_Ul_BFu15i_BFu17i()
{
  {
    init_simple_test("Ul_BFu15i_BFu17i");
    static STRUCT_IF_C Ul_BFu15i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "Ul_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "Ul_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu17i, Ul_BFu15i_BFu17i)
//============================================================================



static void Test_Ul_BFu15i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu17ll");
    static STRUCT_IF_C Ul_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "Ul_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "Ul_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu17ll, Ul_BFu15i_BFu17ll)
//============================================================================



static void Test_Ul_BFu15i_BFu1c()
{
  {
    init_simple_test("Ul_BFu15i_BFu1c");
    static STRUCT_IF_C Ul_BFu15i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu1c, Ul_BFu15i_BFu1c)
//============================================================================



static void Test_Ul_BFu15i_BFu1i()
{
  {
    init_simple_test("Ul_BFu15i_BFu1i");
    static STRUCT_IF_C Ul_BFu15i_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu1i, Ul_BFu15i_BFu1i)
//============================================================================



static void Test_Ul_BFu15i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu1ll");
    static STRUCT_IF_C Ul_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu1ll, Ul_BFu15i_BFu1ll)
//============================================================================



static void Test_Ul_BFu15i_BFu1s()
{
  {
    init_simple_test("Ul_BFu15i_BFu1s");
    static STRUCT_IF_C Ul_BFu15i_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu1s, Ul_BFu15i_BFu1s)
//============================================================================



static void Test_Ul_BFu15i_BFu31i()
{
  {
    init_simple_test("Ul_BFu15i_BFu31i");
    static STRUCT_IF_C Ul_BFu15i_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "Ul_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "Ul_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu31i, Ul_BFu15i_BFu31i)
//============================================================================



static void Test_Ul_BFu15i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu31ll");
    static STRUCT_IF_C Ul_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "Ul_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "Ul_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu31ll, Ul_BFu15i_BFu31ll)
//============================================================================



static void Test_Ul_BFu15i_BFu32i()
{
  {
    init_simple_test("Ul_BFu15i_BFu32i");
    static STRUCT_IF_C Ul_BFu15i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "Ul_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "Ul_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu32i, Ul_BFu15i_BFu32i)
//============================================================================



static void Test_Ul_BFu15i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu32ll");
    static STRUCT_IF_C Ul_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "Ul_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "Ul_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu32ll, Ul_BFu15i_BFu32ll)
//============================================================================



static void Test_Ul_BFu15i_BFu33()
{
  {
    init_simple_test("Ul_BFu15i_BFu33");
    static STRUCT_IF_C Ul_BFu15i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "Ul_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "Ul_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu33, Ul_BFu15i_BFu33)
//============================================================================



static void Test_Ul_BFu15i_BFu7c()
{
  {
    init_simple_test("Ul_BFu15i_BFu7c");
    static STRUCT_IF_C Ul_BFu15i_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu7c, Ul_BFu15i_BFu7c)
//============================================================================



static void Test_Ul_BFu15i_BFu7i()
{
  {
    init_simple_test("Ul_BFu15i_BFu7i");
    static STRUCT_IF_C Ul_BFu15i_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu7i, Ul_BFu15i_BFu7i)
//============================================================================



static void Test_Ul_BFu15i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu7ll");
    static STRUCT_IF_C Ul_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu7ll, Ul_BFu15i_BFu7ll)
//============================================================================



static void Test_Ul_BFu15i_BFu7s()
{
  {
    init_simple_test("Ul_BFu15i_BFu7s");
    static STRUCT_IF_C Ul_BFu15i_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu7s, Ul_BFu15i_BFu7s)
//============================================================================



static void Test_Ul_BFu15i_BFu8c()
{
  {
    init_simple_test("Ul_BFu15i_BFu8c");
    static STRUCT_IF_C Ul_BFu15i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu8c, Ul_BFu15i_BFu8c)
//============================================================================



static void Test_Ul_BFu15i_BFu8i()
{
  {
    init_simple_test("Ul_BFu15i_BFu8i");
    static STRUCT_IF_C Ul_BFu15i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu8i, Ul_BFu15i_BFu8i)
//============================================================================



static void Test_Ul_BFu15i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu8ll");
    static STRUCT_IF_C Ul_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu8ll, Ul_BFu15i_BFu8ll)
//============================================================================



static void Test_Ul_BFu15i_BFu8s()
{
  {
    init_simple_test("Ul_BFu15i_BFu8s");
    static STRUCT_IF_C Ul_BFu15i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu8s, Ul_BFu15i_BFu8s)
//============================================================================



static void Test_Ul_BFu15i_BFu9i()
{
  {
    init_simple_test("Ul_BFu15i_BFu9i");
    static STRUCT_IF_C Ul_BFu15i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu9i, Ul_BFu15i_BFu9i)
//============================================================================



static void Test_Ul_BFu15i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu9ll");
    static STRUCT_IF_C Ul_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu9ll, Ul_BFu15i_BFu9ll)
//============================================================================



static void Test_Ul_BFu15i_BFu9s()
{
  {
    init_simple_test("Ul_BFu15i_BFu9s");
    static STRUCT_IF_C Ul_BFu15i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_BFu9s, Ul_BFu15i_BFu9s)
//============================================================================



static void Test_Ul_BFu15i_C()
{
  {
    init_simple_test("Ul_BFu15i_C");
    static STRUCT_IF_C Ul_BFu15i_C lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_C");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_C, Ul_BFu15i_C)
//============================================================================



static void Test_Ul_BFu15i_D()
{
  {
    init_simple_test("Ul_BFu15i_D");
    static STRUCT_IF_C Ul_BFu15i_D lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_D");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_D, Ul_BFu15i_D)
//============================================================================



static void Test_Ul_BFu15i_F()
{
  {
    init_simple_test("Ul_BFu15i_F");
    static STRUCT_IF_C Ul_BFu15i_F lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_F");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_F, Ul_BFu15i_F)
//============================================================================



static void Test_Ul_BFu15i_I()
{
  {
    init_simple_test("Ul_BFu15i_I");
    static STRUCT_IF_C Ul_BFu15i_I lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_I");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_I, Ul_BFu15i_I)
//============================================================================



static void Test_Ul_BFu15i_Ip()
{
  {
    init_simple_test("Ul_BFu15i_Ip");
    static STRUCT_IF_C Ul_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_Ip");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_Ip, Ul_BFu15i_Ip)
//============================================================================



static void Test_Ul_BFu15i_L()
{
  {
    init_simple_test("Ul_BFu15i_L");
    static STRUCT_IF_C Ul_BFu15i_L lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_L");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_L, Ul_BFu15i_L)
//============================================================================



static void Test_Ul_BFu15i_S()
{
  {
    init_simple_test("Ul_BFu15i_S");
    static STRUCT_IF_C Ul_BFu15i_S lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_S");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_S, Ul_BFu15i_S)
//============================================================================



static void Test_Ul_BFu15i_Uc()
{
  {
    init_simple_test("Ul_BFu15i_Uc");
    static STRUCT_IF_C Ul_BFu15i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_Uc, Ul_BFu15i_Uc)
//============================================================================



static void Test_Ul_BFu15i_Ui()
{
  {
    init_simple_test("Ul_BFu15i_Ui");
    static STRUCT_IF_C Ul_BFu15i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_Ui");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_Ui, Ul_BFu15i_Ui)
//============================================================================



static void Test_Ul_BFu15i_Ul()
{
  {
    init_simple_test("Ul_BFu15i_Ul");
    static STRUCT_IF_C Ul_BFu15i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_Ul");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_Ul, Ul_BFu15i_Ul)
//============================================================================



static void Test_Ul_BFu15i_Us()
{
  {
    init_simple_test("Ul_BFu15i_Us");
    static STRUCT_IF_C Ul_BFu15i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_Us, Ul_BFu15i_Us)
//============================================================================



static void Test_Ul_BFu15i_Vp()
{
  {
    init_simple_test("Ul_BFu15i_Vp");
    static STRUCT_IF_C Ul_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_Vp");
    check_field_offset(lv, v3, 10, "Ul_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15i_Vp, Ul_BFu15i_Vp)
//============================================================================



static void Test_Ul_BFu15ll()
{
  {
    init_simple_test("Ul_BFu15ll");
    static STRUCT_IF_C Ul_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll, Ul_BFu15ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu15i");
    static STRUCT_IF_C Ul_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu15i, Ul_BFu15ll_BFu15i)
//============================================================================



static void Test_Ul_BFu15ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu15ll, Ul_BFu15ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu15s");
    static STRUCT_IF_C Ul_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu15s, Ul_BFu15ll_BFu15s)
//============================================================================



static void Test_Ul_BFu15ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu16i");
    static STRUCT_IF_C Ul_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu16i, Ul_BFu15ll_BFu16i)
//============================================================================



static void Test_Ul_BFu15ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu16ll, Ul_BFu15ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu16s");
    static STRUCT_IF_C Ul_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu16s, Ul_BFu15ll_BFu16s)
//============================================================================



static void Test_Ul_BFu15ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu17i");
    static STRUCT_IF_C Ul_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "Ul_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "Ul_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu17i, Ul_BFu15ll_BFu17i)
//============================================================================



static void Test_Ul_BFu15ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "Ul_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "Ul_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu17ll, Ul_BFu15ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu15ll_BFu1c");
    static STRUCT_IF_C Ul_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu1c, Ul_BFu15ll_BFu1c)
//============================================================================



static void Test_Ul_BFu15ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu1i");
    static STRUCT_IF_C Ul_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu1i, Ul_BFu15ll_BFu1i)
//============================================================================



static void Test_Ul_BFu15ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu1ll, Ul_BFu15ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu1s");
    static STRUCT_IF_C Ul_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu1s, Ul_BFu15ll_BFu1s)
//============================================================================



static void Test_Ul_BFu15ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu31i");
    static STRUCT_IF_C Ul_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "Ul_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "Ul_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu31i, Ul_BFu15ll_BFu31i)
//============================================================================



static void Test_Ul_BFu15ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "Ul_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "Ul_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu31ll, Ul_BFu15ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu32i");
    static STRUCT_IF_C Ul_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "Ul_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "Ul_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu32i, Ul_BFu15ll_BFu32i)
//============================================================================



static void Test_Ul_BFu15ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "Ul_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "Ul_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu32ll, Ul_BFu15ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu33()
{
  {
    init_simple_test("Ul_BFu15ll_BFu33");
    static STRUCT_IF_C Ul_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "Ul_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "Ul_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu33, Ul_BFu15ll_BFu33)
//============================================================================



static void Test_Ul_BFu15ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu15ll_BFu7c");
    static STRUCT_IF_C Ul_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu7c, Ul_BFu15ll_BFu7c)
//============================================================================



static void Test_Ul_BFu15ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu7i");
    static STRUCT_IF_C Ul_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu7i, Ul_BFu15ll_BFu7i)
//============================================================================



static void Test_Ul_BFu15ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu7ll, Ul_BFu15ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu7s");
    static STRUCT_IF_C Ul_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu7s, Ul_BFu15ll_BFu7s)
//============================================================================



static void Test_Ul_BFu15ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu15ll_BFu8c");
    static STRUCT_IF_C Ul_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu8c, Ul_BFu15ll_BFu8c)
//============================================================================



static void Test_Ul_BFu15ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu8i");
    static STRUCT_IF_C Ul_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu8i, Ul_BFu15ll_BFu8i)
//============================================================================



static void Test_Ul_BFu15ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu8ll, Ul_BFu15ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu8s");
    static STRUCT_IF_C Ul_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu8s, Ul_BFu15ll_BFu8s)
//============================================================================



static void Test_Ul_BFu15ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu9i");
    static STRUCT_IF_C Ul_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu9i, Ul_BFu15ll_BFu9i)
//============================================================================



static void Test_Ul_BFu15ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu9ll, Ul_BFu15ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu15ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu9s");
    static STRUCT_IF_C Ul_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_BFu9s, Ul_BFu15ll_BFu9s)
//============================================================================



static void Test_Ul_BFu15ll_C()
{
  {
    init_simple_test("Ul_BFu15ll_C");
    static STRUCT_IF_C Ul_BFu15ll_C lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_C");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_C, Ul_BFu15ll_C)
//============================================================================



static void Test_Ul_BFu15ll_D()
{
  {
    init_simple_test("Ul_BFu15ll_D");
    static STRUCT_IF_C Ul_BFu15ll_D lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_D");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_D, Ul_BFu15ll_D)
//============================================================================



static void Test_Ul_BFu15ll_F()
{
  {
    init_simple_test("Ul_BFu15ll_F");
    static STRUCT_IF_C Ul_BFu15ll_F lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_F");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_F, Ul_BFu15ll_F)
//============================================================================



static void Test_Ul_BFu15ll_I()
{
  {
    init_simple_test("Ul_BFu15ll_I");
    static STRUCT_IF_C Ul_BFu15ll_I lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_I");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_I, Ul_BFu15ll_I)
//============================================================================



static void Test_Ul_BFu15ll_Ip()
{
  {
    init_simple_test("Ul_BFu15ll_Ip");
    static STRUCT_IF_C Ul_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_Ip");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_Ip, Ul_BFu15ll_Ip)
//============================================================================



static void Test_Ul_BFu15ll_L()
{
  {
    init_simple_test("Ul_BFu15ll_L");
    static STRUCT_IF_C Ul_BFu15ll_L lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_L");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_L, Ul_BFu15ll_L)
//============================================================================



static void Test_Ul_BFu15ll_S()
{
  {
    init_simple_test("Ul_BFu15ll_S");
    static STRUCT_IF_C Ul_BFu15ll_S lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_S");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_S, Ul_BFu15ll_S)
//============================================================================



static void Test_Ul_BFu15ll_Uc()
{
  {
    init_simple_test("Ul_BFu15ll_Uc");
    static STRUCT_IF_C Ul_BFu15ll_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_Uc, Ul_BFu15ll_Uc)
//============================================================================



static void Test_Ul_BFu15ll_Ui()
{
  {
    init_simple_test("Ul_BFu15ll_Ui");
    static STRUCT_IF_C Ul_BFu15ll_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_Ui");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_Ui, Ul_BFu15ll_Ui)
//============================================================================



static void Test_Ul_BFu15ll_Ul()
{
  {
    init_simple_test("Ul_BFu15ll_Ul");
    static STRUCT_IF_C Ul_BFu15ll_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_Ul");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_Ul, Ul_BFu15ll_Ul)
//============================================================================



static void Test_Ul_BFu15ll_Us()
{
  {
    init_simple_test("Ul_BFu15ll_Us");
    static STRUCT_IF_C Ul_BFu15ll_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_Us, Ul_BFu15ll_Us)
//============================================================================



static void Test_Ul_BFu15ll_Vp()
{
  {
    init_simple_test("Ul_BFu15ll_Vp");
    static STRUCT_IF_C Ul_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_Vp");
    check_field_offset(lv, v3, 10, "Ul_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15ll_Vp, Ul_BFu15ll_Vp)
//============================================================================



static void Test_Ul_BFu15s()
{
  {
    init_simple_test("Ul_BFu15s");
    static STRUCT_IF_C Ul_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s, Ul_BFu15s)
//============================================================================



static void Test_Ul_BFu15s_BFu15i()
{
  {
    init_simple_test("Ul_BFu15s_BFu15i");
    static STRUCT_IF_C Ul_BFu15s_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu15i, Ul_BFu15s_BFu15i)
//============================================================================



static void Test_Ul_BFu15s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu15ll");
    static STRUCT_IF_C Ul_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu15ll, Ul_BFu15s_BFu15ll)
//============================================================================



static void Test_Ul_BFu15s_BFu15s()
{
  {
    init_simple_test("Ul_BFu15s_BFu15s");
    static STRUCT_IF_C Ul_BFu15s_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "Ul_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu15s, Ul_BFu15s_BFu15s)
//============================================================================



static void Test_Ul_BFu15s_BFu16i()
{
  {
    init_simple_test("Ul_BFu15s_BFu16i");
    static STRUCT_IF_C Ul_BFu15s_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu16i, Ul_BFu15s_BFu16i)
//============================================================================



static void Test_Ul_BFu15s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu16ll");
    static STRUCT_IF_C Ul_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu16ll, Ul_BFu15s_BFu16ll)
//============================================================================



static void Test_Ul_BFu15s_BFu16s()
{
  {
    init_simple_test("Ul_BFu15s_BFu16s");
    static STRUCT_IF_C Ul_BFu15s_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "Ul_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "Ul_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu16s, Ul_BFu15s_BFu16s)
//============================================================================



static void Test_Ul_BFu15s_BFu17i()
{
  {
    init_simple_test("Ul_BFu15s_BFu17i");
    static STRUCT_IF_C Ul_BFu15s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "Ul_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "Ul_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu17i, Ul_BFu15s_BFu17i)
//============================================================================



static void Test_Ul_BFu15s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu17ll");
    static STRUCT_IF_C Ul_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "Ul_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "Ul_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu17ll, Ul_BFu15s_BFu17ll)
//============================================================================



static void Test_Ul_BFu15s_BFu1c()
{
  {
    init_simple_test("Ul_BFu15s_BFu1c");
    static STRUCT_IF_C Ul_BFu15s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu1c, Ul_BFu15s_BFu1c)
//============================================================================



static void Test_Ul_BFu15s_BFu1i()
{
  {
    init_simple_test("Ul_BFu15s_BFu1i");
    static STRUCT_IF_C Ul_BFu15s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu1i, Ul_BFu15s_BFu1i)
//============================================================================



static void Test_Ul_BFu15s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu1ll");
    static STRUCT_IF_C Ul_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu1ll, Ul_BFu15s_BFu1ll)
//============================================================================



static void Test_Ul_BFu15s_BFu1s()
{
  {
    init_simple_test("Ul_BFu15s_BFu1s");
    static STRUCT_IF_C Ul_BFu15s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "Ul_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu1s, Ul_BFu15s_BFu1s)
//============================================================================



static void Test_Ul_BFu15s_BFu31i()
{
  {
    init_simple_test("Ul_BFu15s_BFu31i");
    static STRUCT_IF_C Ul_BFu15s_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "Ul_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "Ul_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu31i, Ul_BFu15s_BFu31i)
//============================================================================



static void Test_Ul_BFu15s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu31ll");
    static STRUCT_IF_C Ul_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "Ul_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "Ul_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu31ll, Ul_BFu15s_BFu31ll)
//============================================================================



static void Test_Ul_BFu15s_BFu32i()
{
  {
    init_simple_test("Ul_BFu15s_BFu32i");
    static STRUCT_IF_C Ul_BFu15s_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "Ul_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "Ul_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu32i, Ul_BFu15s_BFu32i)
//============================================================================



static void Test_Ul_BFu15s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu32ll");
    static STRUCT_IF_C Ul_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "Ul_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "Ul_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu32ll, Ul_BFu15s_BFu32ll)
//============================================================================



static void Test_Ul_BFu15s_BFu33()
{
  {
    init_simple_test("Ul_BFu15s_BFu33");
    static STRUCT_IF_C Ul_BFu15s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "Ul_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "Ul_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu33, Ul_BFu15s_BFu33)
//============================================================================



static void Test_Ul_BFu15s_BFu7c()
{
  {
    init_simple_test("Ul_BFu15s_BFu7c");
    static STRUCT_IF_C Ul_BFu15s_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu7c, Ul_BFu15s_BFu7c)
//============================================================================



static void Test_Ul_BFu15s_BFu7i()
{
  {
    init_simple_test("Ul_BFu15s_BFu7i");
    static STRUCT_IF_C Ul_BFu15s_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu7i, Ul_BFu15s_BFu7i)
//============================================================================



static void Test_Ul_BFu15s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu7ll");
    static STRUCT_IF_C Ul_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu7ll, Ul_BFu15s_BFu7ll)
//============================================================================



static void Test_Ul_BFu15s_BFu7s()
{
  {
    init_simple_test("Ul_BFu15s_BFu7s");
    static STRUCT_IF_C Ul_BFu15s_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "Ul_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "Ul_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu7s, Ul_BFu15s_BFu7s)
//============================================================================



static void Test_Ul_BFu15s_BFu8c()
{
  {
    init_simple_test("Ul_BFu15s_BFu8c");
    static STRUCT_IF_C Ul_BFu15s_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu8c, Ul_BFu15s_BFu8c)
//============================================================================



static void Test_Ul_BFu15s_BFu8i()
{
  {
    init_simple_test("Ul_BFu15s_BFu8i");
    static STRUCT_IF_C Ul_BFu15s_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu8i, Ul_BFu15s_BFu8i)
//============================================================================



static void Test_Ul_BFu15s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu8ll");
    static STRUCT_IF_C Ul_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu8ll, Ul_BFu15s_BFu8ll)
//============================================================================



static void Test_Ul_BFu15s_BFu8s()
{
  {
    init_simple_test("Ul_BFu15s_BFu8s");
    static STRUCT_IF_C Ul_BFu15s_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "Ul_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "Ul_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu8s, Ul_BFu15s_BFu8s)
//============================================================================



static void Test_Ul_BFu15s_BFu9i()
{
  {
    init_simple_test("Ul_BFu15s_BFu9i");
    static STRUCT_IF_C Ul_BFu15s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu9i, Ul_BFu15s_BFu9i)
//============================================================================



static void Test_Ul_BFu15s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu9ll");
    static STRUCT_IF_C Ul_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu9ll, Ul_BFu15s_BFu9ll)
//============================================================================



static void Test_Ul_BFu15s_BFu9s()
{
  {
    init_simple_test("Ul_BFu15s_BFu9s");
    static STRUCT_IF_C Ul_BFu15s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "Ul_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "Ul_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_BFu9s, Ul_BFu15s_BFu9s)
//============================================================================



static void Test_Ul_BFu15s_C()
{
  {
    init_simple_test("Ul_BFu15s_C");
    static STRUCT_IF_C Ul_BFu15s_C lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_C");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_C, Ul_BFu15s_C)
//============================================================================



static void Test_Ul_BFu15s_D()
{
  {
    init_simple_test("Ul_BFu15s_D");
    static STRUCT_IF_C Ul_BFu15s_D lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_D");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_D, Ul_BFu15s_D)
//============================================================================



static void Test_Ul_BFu15s_F()
{
  {
    init_simple_test("Ul_BFu15s_F");
    static STRUCT_IF_C Ul_BFu15s_F lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_F");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_F, Ul_BFu15s_F)
//============================================================================



static void Test_Ul_BFu15s_I()
{
  {
    init_simple_test("Ul_BFu15s_I");
    static STRUCT_IF_C Ul_BFu15s_I lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_I");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_I, Ul_BFu15s_I)
//============================================================================



static void Test_Ul_BFu15s_Ip()
{
  {
    init_simple_test("Ul_BFu15s_Ip");
    static STRUCT_IF_C Ul_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_Ip");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_Ip, Ul_BFu15s_Ip)
//============================================================================



static void Test_Ul_BFu15s_L()
{
  {
    init_simple_test("Ul_BFu15s_L");
    static STRUCT_IF_C Ul_BFu15s_L lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_L");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_L, Ul_BFu15s_L)
//============================================================================



static void Test_Ul_BFu15s_S()
{
  {
    init_simple_test("Ul_BFu15s_S");
    static STRUCT_IF_C Ul_BFu15s_S lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_S");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_S, Ul_BFu15s_S)
//============================================================================



static void Test_Ul_BFu15s_Uc()
{
  {
    init_simple_test("Ul_BFu15s_Uc");
    static STRUCT_IF_C Ul_BFu15s_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_Uc, Ul_BFu15s_Uc)
//============================================================================



static void Test_Ul_BFu15s_Ui()
{
  {
    init_simple_test("Ul_BFu15s_Ui");
    static STRUCT_IF_C Ul_BFu15s_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_Ui");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_Ui, Ul_BFu15s_Ui)
//============================================================================



static void Test_Ul_BFu15s_Ul()
{
  {
    init_simple_test("Ul_BFu15s_Ul");
    static STRUCT_IF_C Ul_BFu15s_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_Ul");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_Ul, Ul_BFu15s_Ul)
//============================================================================



static void Test_Ul_BFu15s_Us()
{
  {
    init_simple_test("Ul_BFu15s_Us");
    static STRUCT_IF_C Ul_BFu15s_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_Us, Ul_BFu15s_Us)
//============================================================================



static void Test_Ul_BFu15s_Vp()
{
  {
    init_simple_test("Ul_BFu15s_Vp");
    static STRUCT_IF_C Ul_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_Vp");
    check_field_offset(lv, v3, 10, "Ul_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu15s_Vp, Ul_BFu15s_Vp)
//============================================================================



static void Test_Ul_BFu16i()
{
  {
    init_simple_test("Ul_BFu16i");
    static STRUCT_IF_C Ul_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i, Ul_BFu16i)
//============================================================================



static void Test_Ul_BFu16i_BFu15i()
{
  {
    init_simple_test("Ul_BFu16i_BFu15i");
    static STRUCT_IF_C Ul_BFu16i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu15i, Ul_BFu16i_BFu15i)
//============================================================================



static void Test_Ul_BFu16i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu15ll");
    static STRUCT_IF_C Ul_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu15ll, Ul_BFu16i_BFu15ll)
//============================================================================



static void Test_Ul_BFu16i_BFu15s()
{
  {
    init_simple_test("Ul_BFu16i_BFu15s");
    static STRUCT_IF_C Ul_BFu16i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu15s, Ul_BFu16i_BFu15s)
//============================================================================



static void Test_Ul_BFu16i_BFu16i()
{
  {
    init_simple_test("Ul_BFu16i_BFu16i");
    static STRUCT_IF_C Ul_BFu16i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu16i, Ul_BFu16i_BFu16i)
//============================================================================



static void Test_Ul_BFu16i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu16ll");
    static STRUCT_IF_C Ul_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu16ll, Ul_BFu16i_BFu16ll)
//============================================================================



static void Test_Ul_BFu16i_BFu16s()
{
  {
    init_simple_test("Ul_BFu16i_BFu16s");
    static STRUCT_IF_C Ul_BFu16i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu16s, Ul_BFu16i_BFu16s)
//============================================================================



static void Test_Ul_BFu16i_BFu17i()
{
  {
    init_simple_test("Ul_BFu16i_BFu17i");
    static STRUCT_IF_C Ul_BFu16i_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu17i, Ul_BFu16i_BFu17i)
//============================================================================



static void Test_Ul_BFu16i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu17ll");
    static STRUCT_IF_C Ul_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu17ll, Ul_BFu16i_BFu17ll)
//============================================================================



static void Test_Ul_BFu16i_BFu1c()
{
  {
    init_simple_test("Ul_BFu16i_BFu1c");
    static STRUCT_IF_C Ul_BFu16i_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu1c, Ul_BFu16i_BFu1c)
//============================================================================



static void Test_Ul_BFu16i_BFu1i()
{
  {
    init_simple_test("Ul_BFu16i_BFu1i");
    static STRUCT_IF_C Ul_BFu16i_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu1i, Ul_BFu16i_BFu1i)
//============================================================================



static void Test_Ul_BFu16i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu1ll");
    static STRUCT_IF_C Ul_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu1ll, Ul_BFu16i_BFu1ll)
//============================================================================



static void Test_Ul_BFu16i_BFu1s()
{
  {
    init_simple_test("Ul_BFu16i_BFu1s");
    static STRUCT_IF_C Ul_BFu16i_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu1s, Ul_BFu16i_BFu1s)
//============================================================================



static void Test_Ul_BFu16i_BFu31i()
{
  {
    init_simple_test("Ul_BFu16i_BFu31i");
    static STRUCT_IF_C Ul_BFu16i_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu31i, Ul_BFu16i_BFu31i)
//============================================================================



static void Test_Ul_BFu16i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu31ll");
    static STRUCT_IF_C Ul_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu31ll, Ul_BFu16i_BFu31ll)
//============================================================================



static void Test_Ul_BFu16i_BFu32i()
{
  {
    init_simple_test("Ul_BFu16i_BFu32i");
    static STRUCT_IF_C Ul_BFu16i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu32i, Ul_BFu16i_BFu32i)
//============================================================================



static void Test_Ul_BFu16i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu32ll");
    static STRUCT_IF_C Ul_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu32ll, Ul_BFu16i_BFu32ll)
//============================================================================



static void Test_Ul_BFu16i_BFu33()
{
  {
    init_simple_test("Ul_BFu16i_BFu33");
    static STRUCT_IF_C Ul_BFu16i_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Ul_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Ul_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu33, Ul_BFu16i_BFu33)
//============================================================================



static void Test_Ul_BFu16i_BFu7c()
{
  {
    init_simple_test("Ul_BFu16i_BFu7c");
    static STRUCT_IF_C Ul_BFu16i_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu7c, Ul_BFu16i_BFu7c)
//============================================================================



static void Test_Ul_BFu16i_BFu7i()
{
  {
    init_simple_test("Ul_BFu16i_BFu7i");
    static STRUCT_IF_C Ul_BFu16i_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu7i, Ul_BFu16i_BFu7i)
//============================================================================



static void Test_Ul_BFu16i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu7ll");
    static STRUCT_IF_C Ul_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu7ll, Ul_BFu16i_BFu7ll)
//============================================================================



static void Test_Ul_BFu16i_BFu7s()
{
  {
    init_simple_test("Ul_BFu16i_BFu7s");
    static STRUCT_IF_C Ul_BFu16i_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu7s, Ul_BFu16i_BFu7s)
//============================================================================



static void Test_Ul_BFu16i_BFu8c()
{
  {
    init_simple_test("Ul_BFu16i_BFu8c");
    static STRUCT_IF_C Ul_BFu16i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu8c, Ul_BFu16i_BFu8c)
//============================================================================



static void Test_Ul_BFu16i_BFu8i()
{
  {
    init_simple_test("Ul_BFu16i_BFu8i");
    static STRUCT_IF_C Ul_BFu16i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu8i, Ul_BFu16i_BFu8i)
//============================================================================



static void Test_Ul_BFu16i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu8ll");
    static STRUCT_IF_C Ul_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu8ll, Ul_BFu16i_BFu8ll)
//============================================================================



static void Test_Ul_BFu16i_BFu8s()
{
  {
    init_simple_test("Ul_BFu16i_BFu8s");
    static STRUCT_IF_C Ul_BFu16i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu8s, Ul_BFu16i_BFu8s)
//============================================================================



static void Test_Ul_BFu16i_BFu9i()
{
  {
    init_simple_test("Ul_BFu16i_BFu9i");
    static STRUCT_IF_C Ul_BFu16i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu9i, Ul_BFu16i_BFu9i)
//============================================================================



static void Test_Ul_BFu16i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu9ll");
    static STRUCT_IF_C Ul_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu9ll, Ul_BFu16i_BFu9ll)
//============================================================================



static void Test_Ul_BFu16i_BFu9s()
{
  {
    init_simple_test("Ul_BFu16i_BFu9s");
    static STRUCT_IF_C Ul_BFu16i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_BFu9s, Ul_BFu16i_BFu9s)
//============================================================================



static void Test_Ul_BFu16i_C()
{
  {
    init_simple_test("Ul_BFu16i_C");
    static STRUCT_IF_C Ul_BFu16i_C lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_C");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_C, Ul_BFu16i_C)
//============================================================================



static void Test_Ul_BFu16i_D()
{
  {
    init_simple_test("Ul_BFu16i_D");
    static STRUCT_IF_C Ul_BFu16i_D lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_D");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_D, Ul_BFu16i_D)
//============================================================================



static void Test_Ul_BFu16i_F()
{
  {
    init_simple_test("Ul_BFu16i_F");
    static STRUCT_IF_C Ul_BFu16i_F lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_F");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_F, Ul_BFu16i_F)
//============================================================================



static void Test_Ul_BFu16i_I()
{
  {
    init_simple_test("Ul_BFu16i_I");
    static STRUCT_IF_C Ul_BFu16i_I lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_I");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_I, Ul_BFu16i_I)
//============================================================================



static void Test_Ul_BFu16i_Ip()
{
  {
    init_simple_test("Ul_BFu16i_Ip");
    static STRUCT_IF_C Ul_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_Ip");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_Ip, Ul_BFu16i_Ip)
//============================================================================



static void Test_Ul_BFu16i_L()
{
  {
    init_simple_test("Ul_BFu16i_L");
    static STRUCT_IF_C Ul_BFu16i_L lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_L");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_L, Ul_BFu16i_L)
//============================================================================



static void Test_Ul_BFu16i_S()
{
  {
    init_simple_test("Ul_BFu16i_S");
    static STRUCT_IF_C Ul_BFu16i_S lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_S");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_S, Ul_BFu16i_S)
//============================================================================



static void Test_Ul_BFu16i_Uc()
{
  {
    init_simple_test("Ul_BFu16i_Uc");
    static STRUCT_IF_C Ul_BFu16i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_Uc, Ul_BFu16i_Uc)
//============================================================================



static void Test_Ul_BFu16i_Ui()
{
  {
    init_simple_test("Ul_BFu16i_Ui");
    static STRUCT_IF_C Ul_BFu16i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_Ui");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_Ui, Ul_BFu16i_Ui)
//============================================================================



static void Test_Ul_BFu16i_Ul()
{
  {
    init_simple_test("Ul_BFu16i_Ul");
    static STRUCT_IF_C Ul_BFu16i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_Ul");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_Ul, Ul_BFu16i_Ul)
//============================================================================



static void Test_Ul_BFu16i_Us()
{
  {
    init_simple_test("Ul_BFu16i_Us");
    static STRUCT_IF_C Ul_BFu16i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_Us, Ul_BFu16i_Us)
//============================================================================



static void Test_Ul_BFu16i_Vp()
{
  {
    init_simple_test("Ul_BFu16i_Vp");
    static STRUCT_IF_C Ul_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_Vp");
    check_field_offset(lv, v3, 10, "Ul_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16i_Vp, Ul_BFu16i_Vp)
//============================================================================



static void Test_Ul_BFu16ll()
{
  {
    init_simple_test("Ul_BFu16ll");
    static STRUCT_IF_C Ul_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll, Ul_BFu16ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu15i");
    static STRUCT_IF_C Ul_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu15i, Ul_BFu16ll_BFu15i)
//============================================================================



static void Test_Ul_BFu16ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu15ll, Ul_BFu16ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu15s");
    static STRUCT_IF_C Ul_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu15s, Ul_BFu16ll_BFu15s)
//============================================================================



static void Test_Ul_BFu16ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu16i");
    static STRUCT_IF_C Ul_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu16i, Ul_BFu16ll_BFu16i)
//============================================================================



static void Test_Ul_BFu16ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu16ll, Ul_BFu16ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu16s");
    static STRUCT_IF_C Ul_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu16s, Ul_BFu16ll_BFu16s)
//============================================================================



static void Test_Ul_BFu16ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu17i");
    static STRUCT_IF_C Ul_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu17i, Ul_BFu16ll_BFu17i)
//============================================================================



static void Test_Ul_BFu16ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu17ll, Ul_BFu16ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu16ll_BFu1c");
    static STRUCT_IF_C Ul_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu1c, Ul_BFu16ll_BFu1c)
//============================================================================



static void Test_Ul_BFu16ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu1i");
    static STRUCT_IF_C Ul_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu1i, Ul_BFu16ll_BFu1i)
//============================================================================



static void Test_Ul_BFu16ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu1ll, Ul_BFu16ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu1s");
    static STRUCT_IF_C Ul_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu1s, Ul_BFu16ll_BFu1s)
//============================================================================



static void Test_Ul_BFu16ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu31i");
    static STRUCT_IF_C Ul_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu31i, Ul_BFu16ll_BFu31i)
//============================================================================



static void Test_Ul_BFu16ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu31ll, Ul_BFu16ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu32i");
    static STRUCT_IF_C Ul_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu32i, Ul_BFu16ll_BFu32i)
//============================================================================



static void Test_Ul_BFu16ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu32ll, Ul_BFu16ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu33()
{
  {
    init_simple_test("Ul_BFu16ll_BFu33");
    static STRUCT_IF_C Ul_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Ul_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Ul_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu33, Ul_BFu16ll_BFu33)
//============================================================================



static void Test_Ul_BFu16ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu16ll_BFu7c");
    static STRUCT_IF_C Ul_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu7c, Ul_BFu16ll_BFu7c)
//============================================================================



static void Test_Ul_BFu16ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu7i");
    static STRUCT_IF_C Ul_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu7i, Ul_BFu16ll_BFu7i)
//============================================================================



static void Test_Ul_BFu16ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu7ll, Ul_BFu16ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu7s");
    static STRUCT_IF_C Ul_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu7s, Ul_BFu16ll_BFu7s)
//============================================================================



static void Test_Ul_BFu16ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu16ll_BFu8c");
    static STRUCT_IF_C Ul_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu8c, Ul_BFu16ll_BFu8c)
//============================================================================



static void Test_Ul_BFu16ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu8i");
    static STRUCT_IF_C Ul_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu8i, Ul_BFu16ll_BFu8i)
//============================================================================



static void Test_Ul_BFu16ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu8ll, Ul_BFu16ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu8s");
    static STRUCT_IF_C Ul_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu8s, Ul_BFu16ll_BFu8s)
//============================================================================



static void Test_Ul_BFu16ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu9i");
    static STRUCT_IF_C Ul_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu9i, Ul_BFu16ll_BFu9i)
//============================================================================



static void Test_Ul_BFu16ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu9ll, Ul_BFu16ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu16ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu9s");
    static STRUCT_IF_C Ul_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_BFu9s, Ul_BFu16ll_BFu9s)
//============================================================================



static void Test_Ul_BFu16ll_C()
{
  {
    init_simple_test("Ul_BFu16ll_C");
    static STRUCT_IF_C Ul_BFu16ll_C lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_C");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_C, Ul_BFu16ll_C)
//============================================================================



static void Test_Ul_BFu16ll_D()
{
  {
    init_simple_test("Ul_BFu16ll_D");
    static STRUCT_IF_C Ul_BFu16ll_D lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_D");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_D, Ul_BFu16ll_D)
//============================================================================



static void Test_Ul_BFu16ll_F()
{
  {
    init_simple_test("Ul_BFu16ll_F");
    static STRUCT_IF_C Ul_BFu16ll_F lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_F");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_F, Ul_BFu16ll_F)
//============================================================================



static void Test_Ul_BFu16ll_I()
{
  {
    init_simple_test("Ul_BFu16ll_I");
    static STRUCT_IF_C Ul_BFu16ll_I lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_I");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_I, Ul_BFu16ll_I)
//============================================================================



static void Test_Ul_BFu16ll_Ip()
{
  {
    init_simple_test("Ul_BFu16ll_Ip");
    static STRUCT_IF_C Ul_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_Ip");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_Ip, Ul_BFu16ll_Ip)
//============================================================================



static void Test_Ul_BFu16ll_L()
{
  {
    init_simple_test("Ul_BFu16ll_L");
    static STRUCT_IF_C Ul_BFu16ll_L lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_L");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_L, Ul_BFu16ll_L)
//============================================================================



static void Test_Ul_BFu16ll_S()
{
  {
    init_simple_test("Ul_BFu16ll_S");
    static STRUCT_IF_C Ul_BFu16ll_S lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_S");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_S, Ul_BFu16ll_S)
//============================================================================



static void Test_Ul_BFu16ll_Uc()
{
  {
    init_simple_test("Ul_BFu16ll_Uc");
    static STRUCT_IF_C Ul_BFu16ll_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_Uc, Ul_BFu16ll_Uc)
//============================================================================



static void Test_Ul_BFu16ll_Ui()
{
  {
    init_simple_test("Ul_BFu16ll_Ui");
    static STRUCT_IF_C Ul_BFu16ll_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_Ui");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_Ui, Ul_BFu16ll_Ui)
//============================================================================



static void Test_Ul_BFu16ll_Ul()
{
  {
    init_simple_test("Ul_BFu16ll_Ul");
    static STRUCT_IF_C Ul_BFu16ll_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_Ul");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_Ul, Ul_BFu16ll_Ul)
//============================================================================



static void Test_Ul_BFu16ll_Us()
{
  {
    init_simple_test("Ul_BFu16ll_Us");
    static STRUCT_IF_C Ul_BFu16ll_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_Us, Ul_BFu16ll_Us)
//============================================================================



static void Test_Ul_BFu16ll_Vp()
{
  {
    init_simple_test("Ul_BFu16ll_Vp");
    static STRUCT_IF_C Ul_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_Vp");
    check_field_offset(lv, v3, 10, "Ul_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16ll_Vp, Ul_BFu16ll_Vp)
//============================================================================



static void Test_Ul_BFu16s()
{
  {
    init_simple_test("Ul_BFu16s");
    static STRUCT_IF_C Ul_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s, Ul_BFu16s)
//============================================================================



static void Test_Ul_BFu16s_BFu15i()
{
  {
    init_simple_test("Ul_BFu16s_BFu15i");
    static STRUCT_IF_C Ul_BFu16s_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu15i, Ul_BFu16s_BFu15i)
//============================================================================



static void Test_Ul_BFu16s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu15ll");
    static STRUCT_IF_C Ul_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu15ll, Ul_BFu16s_BFu15ll)
//============================================================================



static void Test_Ul_BFu16s_BFu15s()
{
  {
    init_simple_test("Ul_BFu16s_BFu15s");
    static STRUCT_IF_C Ul_BFu16s_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu15s, Ul_BFu16s_BFu15s)
//============================================================================



static void Test_Ul_BFu16s_BFu16i()
{
  {
    init_simple_test("Ul_BFu16s_BFu16i");
    static STRUCT_IF_C Ul_BFu16s_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu16i, Ul_BFu16s_BFu16i)
//============================================================================



static void Test_Ul_BFu16s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu16ll");
    static STRUCT_IF_C Ul_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu16ll, Ul_BFu16s_BFu16ll)
//============================================================================



static void Test_Ul_BFu16s_BFu16s()
{
  {
    init_simple_test("Ul_BFu16s_BFu16s");
    static STRUCT_IF_C Ul_BFu16s_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu16s, Ul_BFu16s_BFu16s)
//============================================================================



static void Test_Ul_BFu16s_BFu17i()
{
  {
    init_simple_test("Ul_BFu16s_BFu17i");
    static STRUCT_IF_C Ul_BFu16s_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu17i, Ul_BFu16s_BFu17i)
//============================================================================



static void Test_Ul_BFu16s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu17ll");
    static STRUCT_IF_C Ul_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu17ll, Ul_BFu16s_BFu17ll)
//============================================================================



static void Test_Ul_BFu16s_BFu1c()
{
  {
    init_simple_test("Ul_BFu16s_BFu1c");
    static STRUCT_IF_C Ul_BFu16s_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu1c, Ul_BFu16s_BFu1c)
//============================================================================



static void Test_Ul_BFu16s_BFu1i()
{
  {
    init_simple_test("Ul_BFu16s_BFu1i");
    static STRUCT_IF_C Ul_BFu16s_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu1i, Ul_BFu16s_BFu1i)
//============================================================================



static void Test_Ul_BFu16s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu1ll");
    static STRUCT_IF_C Ul_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu1ll, Ul_BFu16s_BFu1ll)
//============================================================================



static void Test_Ul_BFu16s_BFu1s()
{
  {
    init_simple_test("Ul_BFu16s_BFu1s");
    static STRUCT_IF_C Ul_BFu16s_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu1s, Ul_BFu16s_BFu1s)
//============================================================================



static void Test_Ul_BFu16s_BFu31i()
{
  {
    init_simple_test("Ul_BFu16s_BFu31i");
    static STRUCT_IF_C Ul_BFu16s_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu31i, Ul_BFu16s_BFu31i)
//============================================================================



static void Test_Ul_BFu16s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu31ll");
    static STRUCT_IF_C Ul_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu31ll, Ul_BFu16s_BFu31ll)
//============================================================================



static void Test_Ul_BFu16s_BFu32i()
{
  {
    init_simple_test("Ul_BFu16s_BFu32i");
    static STRUCT_IF_C Ul_BFu16s_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu32i, Ul_BFu16s_BFu32i)
//============================================================================



static void Test_Ul_BFu16s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu32ll");
    static STRUCT_IF_C Ul_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu32ll, Ul_BFu16s_BFu32ll)
//============================================================================



static void Test_Ul_BFu16s_BFu33()
{
  {
    init_simple_test("Ul_BFu16s_BFu33");
    static STRUCT_IF_C Ul_BFu16s_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Ul_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Ul_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu33, Ul_BFu16s_BFu33)
//============================================================================



static void Test_Ul_BFu16s_BFu7c()
{
  {
    init_simple_test("Ul_BFu16s_BFu7c");
    static STRUCT_IF_C Ul_BFu16s_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu7c, Ul_BFu16s_BFu7c)
//============================================================================



static void Test_Ul_BFu16s_BFu7i()
{
  {
    init_simple_test("Ul_BFu16s_BFu7i");
    static STRUCT_IF_C Ul_BFu16s_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu7i, Ul_BFu16s_BFu7i)
//============================================================================



static void Test_Ul_BFu16s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu7ll");
    static STRUCT_IF_C Ul_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu7ll, Ul_BFu16s_BFu7ll)
//============================================================================



static void Test_Ul_BFu16s_BFu7s()
{
  {
    init_simple_test("Ul_BFu16s_BFu7s");
    static STRUCT_IF_C Ul_BFu16s_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu7s, Ul_BFu16s_BFu7s)
//============================================================================



static void Test_Ul_BFu16s_BFu8c()
{
  {
    init_simple_test("Ul_BFu16s_BFu8c");
    static STRUCT_IF_C Ul_BFu16s_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu8c, Ul_BFu16s_BFu8c)
//============================================================================



static void Test_Ul_BFu16s_BFu8i()
{
  {
    init_simple_test("Ul_BFu16s_BFu8i");
    static STRUCT_IF_C Ul_BFu16s_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu8i, Ul_BFu16s_BFu8i)
//============================================================================



static void Test_Ul_BFu16s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu8ll");
    static STRUCT_IF_C Ul_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu8ll, Ul_BFu16s_BFu8ll)
//============================================================================



static void Test_Ul_BFu16s_BFu8s()
{
  {
    init_simple_test("Ul_BFu16s_BFu8s");
    static STRUCT_IF_C Ul_BFu16s_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu8s, Ul_BFu16s_BFu8s)
//============================================================================



static void Test_Ul_BFu16s_BFu9i()
{
  {
    init_simple_test("Ul_BFu16s_BFu9i");
    static STRUCT_IF_C Ul_BFu16s_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu9i, Ul_BFu16s_BFu9i)
//============================================================================



static void Test_Ul_BFu16s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu9ll");
    static STRUCT_IF_C Ul_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu9ll, Ul_BFu16s_BFu9ll)
//============================================================================



static void Test_Ul_BFu16s_BFu9s()
{
  {
    init_simple_test("Ul_BFu16s_BFu9s");
    static STRUCT_IF_C Ul_BFu16s_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_BFu9s, Ul_BFu16s_BFu9s)
//============================================================================



static void Test_Ul_BFu16s_C()
{
  {
    init_simple_test("Ul_BFu16s_C");
    static STRUCT_IF_C Ul_BFu16s_C lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_C");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_C, Ul_BFu16s_C)
//============================================================================



static void Test_Ul_BFu16s_D()
{
  {
    init_simple_test("Ul_BFu16s_D");
    static STRUCT_IF_C Ul_BFu16s_D lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_D");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_D, Ul_BFu16s_D)
//============================================================================



static void Test_Ul_BFu16s_F()
{
  {
    init_simple_test("Ul_BFu16s_F");
    static STRUCT_IF_C Ul_BFu16s_F lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_F");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_F, Ul_BFu16s_F)
//============================================================================



static void Test_Ul_BFu16s_I()
{
  {
    init_simple_test("Ul_BFu16s_I");
    static STRUCT_IF_C Ul_BFu16s_I lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_I");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_I, Ul_BFu16s_I)
//============================================================================



static void Test_Ul_BFu16s_Ip()
{
  {
    init_simple_test("Ul_BFu16s_Ip");
    static STRUCT_IF_C Ul_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_Ip");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_Ip, Ul_BFu16s_Ip)
//============================================================================



static void Test_Ul_BFu16s_L()
{
  {
    init_simple_test("Ul_BFu16s_L");
    static STRUCT_IF_C Ul_BFu16s_L lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_L");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_L, Ul_BFu16s_L)
//============================================================================



static void Test_Ul_BFu16s_S()
{
  {
    init_simple_test("Ul_BFu16s_S");
    static STRUCT_IF_C Ul_BFu16s_S lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_S");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_S, Ul_BFu16s_S)
//============================================================================



static void Test_Ul_BFu16s_Uc()
{
  {
    init_simple_test("Ul_BFu16s_Uc");
    static STRUCT_IF_C Ul_BFu16s_Uc lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_Uc, Ul_BFu16s_Uc)
//============================================================================



static void Test_Ul_BFu16s_Ui()
{
  {
    init_simple_test("Ul_BFu16s_Ui");
    static STRUCT_IF_C Ul_BFu16s_Ui lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_Ui");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_Ui, Ul_BFu16s_Ui)
//============================================================================



static void Test_Ul_BFu16s_Ul()
{
  {
    init_simple_test("Ul_BFu16s_Ul");
    static STRUCT_IF_C Ul_BFu16s_Ul lv;
    check2(sizeof(lv), 18, "sizeof(Ul_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_Ul");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_Ul, Ul_BFu16s_Ul)
//============================================================================



static void Test_Ul_BFu16s_Us()
{
  {
    init_simple_test("Ul_BFu16s_Us");
    static STRUCT_IF_C Ul_BFu16s_Us lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_Us, Ul_BFu16s_Us)
//============================================================================



static void Test_Ul_BFu16s_Vp()
{
  {
    init_simple_test("Ul_BFu16s_Vp");
    static STRUCT_IF_C Ul_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(Ul_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_Vp");
    check_field_offset(lv, v3, 10, "Ul_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu16s_Vp, Ul_BFu16s_Vp)
//============================================================================



static void Test_Ul_BFu17i()
{
  {
    init_simple_test("Ul_BFu17i");
    static STRUCT_IF_C Ul_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i, Ul_BFu17i)
//============================================================================



static void Test_Ul_BFu17i_BFu15i()
{
  {
    init_simple_test("Ul_BFu17i_BFu15i");
    static STRUCT_IF_C Ul_BFu17i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "Ul_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "Ul_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu15i, Ul_BFu17i_BFu15i)
//============================================================================



static void Test_Ul_BFu17i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu15ll");
    static STRUCT_IF_C Ul_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "Ul_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "Ul_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu15ll, Ul_BFu17i_BFu15ll)
//============================================================================



static void Test_Ul_BFu17i_BFu15s()
{
  {
    init_simple_test("Ul_BFu17i_BFu15s");
    static STRUCT_IF_C Ul_BFu17i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "Ul_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "Ul_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu15s, Ul_BFu17i_BFu15s)
//============================================================================



static void Test_Ul_BFu17i_BFu16i()
{
  {
    init_simple_test("Ul_BFu17i_BFu16i");
    static STRUCT_IF_C Ul_BFu17i_BFu16i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "Ul_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "Ul_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu16i, Ul_BFu17i_BFu16i)
//============================================================================



static void Test_Ul_BFu17i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu16ll");
    static STRUCT_IF_C Ul_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "Ul_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "Ul_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu16ll, Ul_BFu17i_BFu16ll)
//============================================================================



static void Test_Ul_BFu17i_BFu16s()
{
  {
    init_simple_test("Ul_BFu17i_BFu16s");
    static STRUCT_IF_C Ul_BFu17i_BFu16s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "Ul_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "Ul_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu16s, Ul_BFu17i_BFu16s)
//============================================================================



static void Test_Ul_BFu17i_BFu17i()
{
  {
    init_simple_test("Ul_BFu17i_BFu17i");
    static STRUCT_IF_C Ul_BFu17i_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 10, 1, 17, 1, "Ul_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 10, 1, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu17i, Ul_BFu17i_BFu17i)
//============================================================================



static void Test_Ul_BFu17i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu17ll");
    static STRUCT_IF_C Ul_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, 1, "Ul_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu17ll, Ul_BFu17i_BFu17ll)
//============================================================================



static void Test_Ul_BFu17i_BFu1c()
{
  {
    init_simple_test("Ul_BFu17i_BFu1c");
    static STRUCT_IF_C Ul_BFu17i_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu1c, Ul_BFu17i_BFu1c)
//============================================================================



static void Test_Ul_BFu17i_BFu1i()
{
  {
    init_simple_test("Ul_BFu17i_BFu1i");
    static STRUCT_IF_C Ul_BFu17i_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu1i, Ul_BFu17i_BFu1i)
//============================================================================



static void Test_Ul_BFu17i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu1ll");
    static STRUCT_IF_C Ul_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu1ll, Ul_BFu17i_BFu1ll)
//============================================================================



static void Test_Ul_BFu17i_BFu1s()
{
  {
    init_simple_test("Ul_BFu17i_BFu1s");
    static STRUCT_IF_C Ul_BFu17i_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu1s, Ul_BFu17i_BFu1s)
//============================================================================



static void Test_Ul_BFu17i_BFu31i()
{
  {
    init_simple_test("Ul_BFu17i_BFu31i");
    static STRUCT_IF_C Ul_BFu17i_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 10, 1, 31, 1, "Ul_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 10, 1, 31, hide_ull(1LL<<30), "Ul_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu31i, Ul_BFu17i_BFu31i)
//============================================================================



static void Test_Ul_BFu17i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu31ll");
    static STRUCT_IF_C Ul_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, 1, "Ul_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, hide_ull(1LL<<30), "Ul_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu31ll, Ul_BFu17i_BFu31ll)
//============================================================================



static void Test_Ul_BFu17i_BFu32i()
{
  {
    init_simple_test("Ul_BFu17i_BFu32i");
    static STRUCT_IF_C Ul_BFu17i_BFu32i lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 10, 1, 32, 1, "Ul_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 10, 1, 32, hide_ull(1LL<<31), "Ul_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu32i, Ul_BFu17i_BFu32i)
//============================================================================



static void Test_Ul_BFu17i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu32ll");
    static STRUCT_IF_C Ul_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, 1, "Ul_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, hide_ull(1LL<<31), "Ul_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu32ll, Ul_BFu17i_BFu32ll)
//============================================================================



static void Test_Ul_BFu17i_BFu33()
{
  {
    init_simple_test("Ul_BFu17i_BFu33");
    static STRUCT_IF_C Ul_BFu17i_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, 1, "Ul_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, hide_ull(1LL<<32), "Ul_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu33, Ul_BFu17i_BFu33)
//============================================================================



static void Test_Ul_BFu17i_BFu7c()
{
  {
    init_simple_test("Ul_BFu17i_BFu7c");
    static STRUCT_IF_C Ul_BFu17i_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu7c, Ul_BFu17i_BFu7c)
//============================================================================



static void Test_Ul_BFu17i_BFu7i()
{
  {
    init_simple_test("Ul_BFu17i_BFu7i");
    static STRUCT_IF_C Ul_BFu17i_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu7i, Ul_BFu17i_BFu7i)
//============================================================================



static void Test_Ul_BFu17i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu7ll");
    static STRUCT_IF_C Ul_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu7ll, Ul_BFu17i_BFu7ll)
//============================================================================



static void Test_Ul_BFu17i_BFu7s()
{
  {
    init_simple_test("Ul_BFu17i_BFu7s");
    static STRUCT_IF_C Ul_BFu17i_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu7s, Ul_BFu17i_BFu7s)
//============================================================================



static void Test_Ul_BFu17i_BFu8c()
{
  {
    init_simple_test("Ul_BFu17i_BFu8c");
    static STRUCT_IF_C Ul_BFu17i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu8c, Ul_BFu17i_BFu8c)
//============================================================================



static void Test_Ul_BFu17i_BFu8i()
{
  {
    init_simple_test("Ul_BFu17i_BFu8i");
    static STRUCT_IF_C Ul_BFu17i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu8i, Ul_BFu17i_BFu8i)
//============================================================================



static void Test_Ul_BFu17i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu8ll");
    static STRUCT_IF_C Ul_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu8ll, Ul_BFu17i_BFu8ll)
//============================================================================



static void Test_Ul_BFu17i_BFu8s()
{
  {
    init_simple_test("Ul_BFu17i_BFu8s");
    static STRUCT_IF_C Ul_BFu17i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu8s, Ul_BFu17i_BFu8s)
//============================================================================



static void Test_Ul_BFu17i_BFu9i()
{
  {
    init_simple_test("Ul_BFu17i_BFu9i");
    static STRUCT_IF_C Ul_BFu17i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "Ul_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "Ul_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu9i, Ul_BFu17i_BFu9i)
//============================================================================



static void Test_Ul_BFu17i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu9ll");
    static STRUCT_IF_C Ul_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "Ul_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "Ul_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu9ll, Ul_BFu17i_BFu9ll)
//============================================================================



static void Test_Ul_BFu17i_BFu9s()
{
  {
    init_simple_test("Ul_BFu17i_BFu9s");
    static STRUCT_IF_C Ul_BFu17i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "Ul_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "Ul_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_BFu9s, Ul_BFu17i_BFu9s)
//============================================================================



static void Test_Ul_BFu17i_C()
{
  {
    init_simple_test("Ul_BFu17i_C");
    static STRUCT_IF_C Ul_BFu17i_C lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_C");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_C");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_C, Ul_BFu17i_C)
//============================================================================



static void Test_Ul_BFu17i_D()
{
  {
    init_simple_test("Ul_BFu17i_D");
    static STRUCT_IF_C Ul_BFu17i_D lv;
    check2(sizeof(lv), 19, "sizeof(Ul_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_D");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_D");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_D, Ul_BFu17i_D)
//============================================================================



static void Test_Ul_BFu17i_F()
{
  {
    init_simple_test("Ul_BFu17i_F");
    static STRUCT_IF_C Ul_BFu17i_F lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_F");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_F");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_F, Ul_BFu17i_F)
//============================================================================



static void Test_Ul_BFu17i_I()
{
  {
    init_simple_test("Ul_BFu17i_I");
    static STRUCT_IF_C Ul_BFu17i_I lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_I");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_I");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_I, Ul_BFu17i_I)
//============================================================================



static void Test_Ul_BFu17i_Ip()
{
  {
    init_simple_test("Ul_BFu17i_Ip");
    static STRUCT_IF_C Ul_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Ul_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_Ip");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_Ip, Ul_BFu17i_Ip)
//============================================================================



static void Test_Ul_BFu17i_L()
{
  {
    init_simple_test("Ul_BFu17i_L");
    static STRUCT_IF_C Ul_BFu17i_L lv;
    check2(sizeof(lv), 19, "sizeof(Ul_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_L");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_L");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_L, Ul_BFu17i_L)
//============================================================================



static void Test_Ul_BFu17i_S()
{
  {
    init_simple_test("Ul_BFu17i_S");
    static STRUCT_IF_C Ul_BFu17i_S lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_S");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_S");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_S, Ul_BFu17i_S)
//============================================================================



static void Test_Ul_BFu17i_Uc()
{
  {
    init_simple_test("Ul_BFu17i_Uc");
    static STRUCT_IF_C Ul_BFu17i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_Uc");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_Uc, Ul_BFu17i_Uc)
//============================================================================



static void Test_Ul_BFu17i_Ui()
{
  {
    init_simple_test("Ul_BFu17i_Ui");
    static STRUCT_IF_C Ul_BFu17i_Ui lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_Ui");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_Ui, Ul_BFu17i_Ui)
//============================================================================



static void Test_Ul_BFu17i_Ul()
{
  {
    init_simple_test("Ul_BFu17i_Ul");
    static STRUCT_IF_C Ul_BFu17i_Ul lv;
    check2(sizeof(lv), 19, "sizeof(Ul_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_Ul");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_Ul, Ul_BFu17i_Ul)
//============================================================================



static void Test_Ul_BFu17i_Us()
{
  {
    init_simple_test("Ul_BFu17i_Us");
    static STRUCT_IF_C Ul_BFu17i_Us lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_Us");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_Us");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_Us, Ul_BFu17i_Us)
//============================================================================



static void Test_Ul_BFu17i_Vp()
{
  {
    init_simple_test("Ul_BFu17i_Vp");
    static STRUCT_IF_C Ul_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Ul_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_Vp");
    check_field_offset(lv, v3, 11, "Ul_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17i_Vp, Ul_BFu17i_Vp)
//============================================================================



static void Test_Ul_BFu17ll()
{
  {
    init_simple_test("Ul_BFu17ll");
    static STRUCT_IF_C Ul_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll, Ul_BFu17ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu15i");
    static STRUCT_IF_C Ul_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "Ul_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "Ul_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu15i, Ul_BFu17ll_BFu15i)
//============================================================================



static void Test_Ul_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "Ul_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "Ul_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu15ll, Ul_BFu17ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu15s");
    static STRUCT_IF_C Ul_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, 1, "Ul_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 1, 15, hide_ull(1LL<<14), "Ul_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu15s, Ul_BFu17ll_BFu15s)
//============================================================================



static void Test_Ul_BFu17ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu16i");
    static STRUCT_IF_C Ul_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "Ul_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "Ul_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu16i, Ul_BFu17ll_BFu16i)
//============================================================================



static void Test_Ul_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "Ul_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "Ul_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu16ll, Ul_BFu17ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu16s");
    static STRUCT_IF_C Ul_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 1, 16, 1, "Ul_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 1, 16, hide_ull(1LL<<15), "Ul_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu16s, Ul_BFu17ll_BFu16s)
//============================================================================



static void Test_Ul_BFu17ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu17i");
    static STRUCT_IF_C Ul_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 10, 1, 17, 1, "Ul_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 10, 1, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu17i, Ul_BFu17ll_BFu17i)
//============================================================================



static void Test_Ul_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, 1, "Ul_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 1, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu17ll, Ul_BFu17ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu17ll_BFu1c");
    static STRUCT_IF_C Ul_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu1c, Ul_BFu17ll_BFu1c)
//============================================================================



static void Test_Ul_BFu17ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu1i");
    static STRUCT_IF_C Ul_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu1i, Ul_BFu17ll_BFu1i)
//============================================================================



static void Test_Ul_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu1ll, Ul_BFu17ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu1s");
    static STRUCT_IF_C Ul_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 10, 1, 1, 1, "Ul_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu1s, Ul_BFu17ll_BFu1s)
//============================================================================



static void Test_Ul_BFu17ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu31i");
    static STRUCT_IF_C Ul_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 10, 1, 31, 1, "Ul_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 10, 1, 31, hide_ull(1LL<<30), "Ul_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu31i, Ul_BFu17ll_BFu31i)
//============================================================================



static void Test_Ul_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, 1, "Ul_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 10, 1, 31, hide_ull(1LL<<30), "Ul_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu31ll, Ul_BFu17ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu32i");
    static STRUCT_IF_C Ul_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 10, 1, 32, 1, "Ul_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 10, 1, 32, hide_ull(1LL<<31), "Ul_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu32i, Ul_BFu17ll_BFu32i)
//============================================================================



static void Test_Ul_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, 1, "Ul_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 10, 1, 32, hide_ull(1LL<<31), "Ul_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu32ll, Ul_BFu17ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu33()
{
  {
    init_simple_test("Ul_BFu17ll_BFu33");
    static STRUCT_IF_C Ul_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, 1, "Ul_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 10, 1, 33, hide_ull(1LL<<32), "Ul_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu33, Ul_BFu17ll_BFu33)
//============================================================================



static void Test_Ul_BFu17ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu17ll_BFu7c");
    static STRUCT_IF_C Ul_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu7c, Ul_BFu17ll_BFu7c)
//============================================================================



static void Test_Ul_BFu17ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu7i");
    static STRUCT_IF_C Ul_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu7i, Ul_BFu17ll_BFu7i)
//============================================================================



static void Test_Ul_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu7ll, Ul_BFu17ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu7s");
    static STRUCT_IF_C Ul_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, 1, "Ul_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 10, 1, 7, hide_ull(1LL<<6), "Ul_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu7s, Ul_BFu17ll_BFu7s)
//============================================================================



static void Test_Ul_BFu17ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu17ll_BFu8c");
    static STRUCT_IF_C Ul_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu8c, Ul_BFu17ll_BFu8c)
//============================================================================



static void Test_Ul_BFu17ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu8i");
    static STRUCT_IF_C Ul_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu8i, Ul_BFu17ll_BFu8i)
//============================================================================



static void Test_Ul_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu8ll, Ul_BFu17ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu8s");
    static STRUCT_IF_C Ul_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, 1, "Ul_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 1, 8, hide_ull(1LL<<7), "Ul_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu8s, Ul_BFu17ll_BFu8s)
//============================================================================



static void Test_Ul_BFu17ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu9i");
    static STRUCT_IF_C Ul_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "Ul_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "Ul_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu9i, Ul_BFu17ll_BFu9i)
//============================================================================



static void Test_Ul_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "Ul_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "Ul_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu9ll, Ul_BFu17ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu17ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu9s");
    static STRUCT_IF_C Ul_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, 1, "Ul_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 1, 9, hide_ull(1LL<<8), "Ul_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_BFu9s, Ul_BFu17ll_BFu9s)
//============================================================================



static void Test_Ul_BFu17ll_C()
{
  {
    init_simple_test("Ul_BFu17ll_C");
    static STRUCT_IF_C Ul_BFu17ll_C lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_C");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_C");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_C, Ul_BFu17ll_C)
//============================================================================



static void Test_Ul_BFu17ll_D()
{
  {
    init_simple_test("Ul_BFu17ll_D");
    static STRUCT_IF_C Ul_BFu17ll_D lv;
    check2(sizeof(lv), 19, "sizeof(Ul_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_D");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_D");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_D, Ul_BFu17ll_D)
//============================================================================



static void Test_Ul_BFu17ll_F()
{
  {
    init_simple_test("Ul_BFu17ll_F");
    static STRUCT_IF_C Ul_BFu17ll_F lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_F");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_F");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_F, Ul_BFu17ll_F)
//============================================================================



static void Test_Ul_BFu17ll_I()
{
  {
    init_simple_test("Ul_BFu17ll_I");
    static STRUCT_IF_C Ul_BFu17ll_I lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_I");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_I");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_I, Ul_BFu17ll_I)
//============================================================================



static void Test_Ul_BFu17ll_Ip()
{
  {
    init_simple_test("Ul_BFu17ll_Ip");
    static STRUCT_IF_C Ul_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Ul_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_Ip");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_Ip, Ul_BFu17ll_Ip)
//============================================================================



static void Test_Ul_BFu17ll_L()
{
  {
    init_simple_test("Ul_BFu17ll_L");
    static STRUCT_IF_C Ul_BFu17ll_L lv;
    check2(sizeof(lv), 19, "sizeof(Ul_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_L");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_L");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_L, Ul_BFu17ll_L)
//============================================================================



static void Test_Ul_BFu17ll_S()
{
  {
    init_simple_test("Ul_BFu17ll_S");
    static STRUCT_IF_C Ul_BFu17ll_S lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_S");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_S");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_S, Ul_BFu17ll_S)
//============================================================================



static void Test_Ul_BFu17ll_Uc()
{
  {
    init_simple_test("Ul_BFu17ll_Uc");
    static STRUCT_IF_C Ul_BFu17ll_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_Uc");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_Uc, Ul_BFu17ll_Uc)
//============================================================================



static void Test_Ul_BFu17ll_Ui()
{
  {
    init_simple_test("Ul_BFu17ll_Ui");
    static STRUCT_IF_C Ul_BFu17ll_Ui lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_Ui");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_Ui, Ul_BFu17ll_Ui)
//============================================================================



static void Test_Ul_BFu17ll_Ul()
{
  {
    init_simple_test("Ul_BFu17ll_Ul");
    static STRUCT_IF_C Ul_BFu17ll_Ul lv;
    check2(sizeof(lv), 19, "sizeof(Ul_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_Ul");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_Ul, Ul_BFu17ll_Ul)
//============================================================================



static void Test_Ul_BFu17ll_Us()
{
  {
    init_simple_test("Ul_BFu17ll_Us");
    static STRUCT_IF_C Ul_BFu17ll_Us lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_Us");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_Us, Ul_BFu17ll_Us)
//============================================================================



static void Test_Ul_BFu17ll_Vp()
{
  {
    init_simple_test("Ul_BFu17ll_Vp");
    static STRUCT_IF_C Ul_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(Ul_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_Vp");
    check_field_offset(lv, v3, 11, "Ul_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu17ll_Vp, Ul_BFu17ll_Vp)
//============================================================================



static void Test_Ul_BFu1c()
{
  {
    init_simple_test("Ul_BFu1c");
    static STRUCT_IF_C Ul_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c, Ul_BFu1c)
//============================================================================



static void Test_Ul_BFu1c_BFu15i()
{
  {
    init_simple_test("Ul_BFu1c_BFu15i");
    static STRUCT_IF_C Ul_BFu1c_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu15i, Ul_BFu1c_BFu15i)
//============================================================================



static void Test_Ul_BFu1c_BFu15ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu15ll");
    static STRUCT_IF_C Ul_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu15ll, Ul_BFu1c_BFu15ll)
//============================================================================



static void Test_Ul_BFu1c_BFu15s()
{
  {
    init_simple_test("Ul_BFu1c_BFu15s");
    static STRUCT_IF_C Ul_BFu1c_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu15s, Ul_BFu1c_BFu15s)
//============================================================================



static void Test_Ul_BFu1c_BFu16i()
{
  {
    init_simple_test("Ul_BFu1c_BFu16i");
    static STRUCT_IF_C Ul_BFu1c_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu16i, Ul_BFu1c_BFu16i)
//============================================================================



static void Test_Ul_BFu1c_BFu16ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu16ll");
    static STRUCT_IF_C Ul_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu16ll, Ul_BFu1c_BFu16ll)
//============================================================================



static void Test_Ul_BFu1c_BFu16s()
{
  {
    init_simple_test("Ul_BFu1c_BFu16s");
    static STRUCT_IF_C Ul_BFu1c_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu16s, Ul_BFu1c_BFu16s)
//============================================================================



static void Test_Ul_BFu1c_BFu17i()
{
  {
    init_simple_test("Ul_BFu1c_BFu17i");
    static STRUCT_IF_C Ul_BFu1c_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu17i, Ul_BFu1c_BFu17i)
//============================================================================



static void Test_Ul_BFu1c_BFu17ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu17ll");
    static STRUCT_IF_C Ul_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu17ll, Ul_BFu1c_BFu17ll)
//============================================================================



static void Test_Ul_BFu1c_BFu1c()
{
  {
    init_simple_test("Ul_BFu1c_BFu1c");
    static STRUCT_IF_C Ul_BFu1c_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu1c, Ul_BFu1c_BFu1c)
//============================================================================



static void Test_Ul_BFu1c_BFu1i()
{
  {
    init_simple_test("Ul_BFu1c_BFu1i");
    static STRUCT_IF_C Ul_BFu1c_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu1i, Ul_BFu1c_BFu1i)
//============================================================================



static void Test_Ul_BFu1c_BFu1ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu1ll");
    static STRUCT_IF_C Ul_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu1ll, Ul_BFu1c_BFu1ll)
//============================================================================



static void Test_Ul_BFu1c_BFu1s()
{
  {
    init_simple_test("Ul_BFu1c_BFu1s");
    static STRUCT_IF_C Ul_BFu1c_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu1s, Ul_BFu1c_BFu1s)
//============================================================================



static void Test_Ul_BFu1c_BFu31i()
{
  {
    init_simple_test("Ul_BFu1c_BFu31i");
    static STRUCT_IF_C Ul_BFu1c_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu31i, Ul_BFu1c_BFu31i)
//============================================================================



static void Test_Ul_BFu1c_BFu31ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu31ll");
    static STRUCT_IF_C Ul_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu31ll, Ul_BFu1c_BFu31ll)
//============================================================================



static void Test_Ul_BFu1c_BFu32i()
{
  {
    init_simple_test("Ul_BFu1c_BFu32i");
    static STRUCT_IF_C Ul_BFu1c_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu32i, Ul_BFu1c_BFu32i)
//============================================================================



static void Test_Ul_BFu1c_BFu32ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu32ll");
    static STRUCT_IF_C Ul_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu32ll, Ul_BFu1c_BFu32ll)
//============================================================================



static void Test_Ul_BFu1c_BFu33()
{
  {
    init_simple_test("Ul_BFu1c_BFu33");
    static STRUCT_IF_C Ul_BFu1c_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, 1, "Ul_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, hide_ull(1LL<<32), "Ul_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu33, Ul_BFu1c_BFu33)
//============================================================================



static void Test_Ul_BFu1c_BFu7c()
{
  {
    init_simple_test("Ul_BFu1c_BFu7c");
    static STRUCT_IF_C Ul_BFu1c_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu7c, Ul_BFu1c_BFu7c)
//============================================================================



static void Test_Ul_BFu1c_BFu7i()
{
  {
    init_simple_test("Ul_BFu1c_BFu7i");
    static STRUCT_IF_C Ul_BFu1c_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu7i, Ul_BFu1c_BFu7i)
//============================================================================



static void Test_Ul_BFu1c_BFu7ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu7ll");
    static STRUCT_IF_C Ul_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu7ll, Ul_BFu1c_BFu7ll)
//============================================================================



static void Test_Ul_BFu1c_BFu7s()
{
  {
    init_simple_test("Ul_BFu1c_BFu7s");
    static STRUCT_IF_C Ul_BFu1c_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu7s, Ul_BFu1c_BFu7s)
//============================================================================



static void Test_Ul_BFu1c_BFu8c()
{
  {
    init_simple_test("Ul_BFu1c_BFu8c");
    static STRUCT_IF_C Ul_BFu1c_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu8c, Ul_BFu1c_BFu8c)
//============================================================================



static void Test_Ul_BFu1c_BFu8i()
{
  {
    init_simple_test("Ul_BFu1c_BFu8i");
    static STRUCT_IF_C Ul_BFu1c_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu8i, Ul_BFu1c_BFu8i)
//============================================================================



static void Test_Ul_BFu1c_BFu8ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu8ll");
    static STRUCT_IF_C Ul_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu8ll, Ul_BFu1c_BFu8ll)
//============================================================================



static void Test_Ul_BFu1c_BFu8s()
{
  {
    init_simple_test("Ul_BFu1c_BFu8s");
    static STRUCT_IF_C Ul_BFu1c_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu8s, Ul_BFu1c_BFu8s)
//============================================================================



static void Test_Ul_BFu1c_BFu9i()
{
  {
    init_simple_test("Ul_BFu1c_BFu9i");
    static STRUCT_IF_C Ul_BFu1c_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu9i, Ul_BFu1c_BFu9i)
//============================================================================



static void Test_Ul_BFu1c_BFu9ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu9ll");
    static STRUCT_IF_C Ul_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu9ll, Ul_BFu1c_BFu9ll)
//============================================================================



static void Test_Ul_BFu1c_BFu9s()
{
  {
    init_simple_test("Ul_BFu1c_BFu9s");
    static STRUCT_IF_C Ul_BFu1c_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_BFu9s, Ul_BFu1c_BFu9s)
//============================================================================



static void Test_Ul_BFu1c_C()
{
  {
    init_simple_test("Ul_BFu1c_C");
    static STRUCT_IF_C Ul_BFu1c_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_C");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_C, Ul_BFu1c_C)
//============================================================================



static void Test_Ul_BFu1c_D()
{
  {
    init_simple_test("Ul_BFu1c_D");
    static STRUCT_IF_C Ul_BFu1c_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_D");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_D, Ul_BFu1c_D)
//============================================================================



static void Test_Ul_BFu1c_F()
{
  {
    init_simple_test("Ul_BFu1c_F");
    static STRUCT_IF_C Ul_BFu1c_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_F");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_F, Ul_BFu1c_F)
//============================================================================



static void Test_Ul_BFu1c_I()
{
  {
    init_simple_test("Ul_BFu1c_I");
    static STRUCT_IF_C Ul_BFu1c_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_I");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_I, Ul_BFu1c_I)
//============================================================================



static void Test_Ul_BFu1c_Ip()
{
  {
    init_simple_test("Ul_BFu1c_Ip");
    static STRUCT_IF_C Ul_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_Ip, Ul_BFu1c_Ip)
//============================================================================



static void Test_Ul_BFu1c_L()
{
  {
    init_simple_test("Ul_BFu1c_L");
    static STRUCT_IF_C Ul_BFu1c_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_L");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_L, Ul_BFu1c_L)
//============================================================================



static void Test_Ul_BFu1c_S()
{
  {
    init_simple_test("Ul_BFu1c_S");
    static STRUCT_IF_C Ul_BFu1c_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_S");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_S, Ul_BFu1c_S)
//============================================================================



static void Test_Ul_BFu1c_Uc()
{
  {
    init_simple_test("Ul_BFu1c_Uc");
    static STRUCT_IF_C Ul_BFu1c_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_Uc, Ul_BFu1c_Uc)
//============================================================================



static void Test_Ul_BFu1c_Ui()
{
  {
    init_simple_test("Ul_BFu1c_Ui");
    static STRUCT_IF_C Ul_BFu1c_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_Ui, Ul_BFu1c_Ui)
//============================================================================



static void Test_Ul_BFu1c_Ul()
{
  {
    init_simple_test("Ul_BFu1c_Ul");
    static STRUCT_IF_C Ul_BFu1c_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_Ul, Ul_BFu1c_Ul)
//============================================================================



static void Test_Ul_BFu1c_Us()
{
  {
    init_simple_test("Ul_BFu1c_Us");
    static STRUCT_IF_C Ul_BFu1c_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_Us, Ul_BFu1c_Us)
//============================================================================



static void Test_Ul_BFu1c_Vp()
{
  {
    init_simple_test("Ul_BFu1c_Vp");
    static STRUCT_IF_C Ul_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1c_Vp, Ul_BFu1c_Vp)
//============================================================================



static void Test_Ul_BFu1i()
{
  {
    init_simple_test("Ul_BFu1i");
    static STRUCT_IF_C Ul_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i, Ul_BFu1i)
//============================================================================



static void Test_Ul_BFu1i_BFu15i()
{
  {
    init_simple_test("Ul_BFu1i_BFu15i");
    static STRUCT_IF_C Ul_BFu1i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu15i, Ul_BFu1i_BFu15i)
//============================================================================



static void Test_Ul_BFu1i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu15ll");
    static STRUCT_IF_C Ul_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu15ll, Ul_BFu1i_BFu15ll)
//============================================================================



static void Test_Ul_BFu1i_BFu15s()
{
  {
    init_simple_test("Ul_BFu1i_BFu15s");
    static STRUCT_IF_C Ul_BFu1i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu15s, Ul_BFu1i_BFu15s)
//============================================================================



static void Test_Ul_BFu1i_BFu16i()
{
  {
    init_simple_test("Ul_BFu1i_BFu16i");
    static STRUCT_IF_C Ul_BFu1i_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu16i, Ul_BFu1i_BFu16i)
//============================================================================



static void Test_Ul_BFu1i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu16ll");
    static STRUCT_IF_C Ul_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu16ll, Ul_BFu1i_BFu16ll)
//============================================================================



static void Test_Ul_BFu1i_BFu16s()
{
  {
    init_simple_test("Ul_BFu1i_BFu16s");
    static STRUCT_IF_C Ul_BFu1i_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu16s, Ul_BFu1i_BFu16s)
//============================================================================



static void Test_Ul_BFu1i_BFu17i()
{
  {
    init_simple_test("Ul_BFu1i_BFu17i");
    static STRUCT_IF_C Ul_BFu1i_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu17i, Ul_BFu1i_BFu17i)
//============================================================================



static void Test_Ul_BFu1i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu17ll");
    static STRUCT_IF_C Ul_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu17ll, Ul_BFu1i_BFu17ll)
//============================================================================



static void Test_Ul_BFu1i_BFu1c()
{
  {
    init_simple_test("Ul_BFu1i_BFu1c");
    static STRUCT_IF_C Ul_BFu1i_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu1c, Ul_BFu1i_BFu1c)
//============================================================================



static void Test_Ul_BFu1i_BFu1i()
{
  {
    init_simple_test("Ul_BFu1i_BFu1i");
    static STRUCT_IF_C Ul_BFu1i_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu1i, Ul_BFu1i_BFu1i)
//============================================================================



static void Test_Ul_BFu1i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu1ll");
    static STRUCT_IF_C Ul_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu1ll, Ul_BFu1i_BFu1ll)
//============================================================================



static void Test_Ul_BFu1i_BFu1s()
{
  {
    init_simple_test("Ul_BFu1i_BFu1s");
    static STRUCT_IF_C Ul_BFu1i_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu1s, Ul_BFu1i_BFu1s)
//============================================================================



static void Test_Ul_BFu1i_BFu31i()
{
  {
    init_simple_test("Ul_BFu1i_BFu31i");
    static STRUCT_IF_C Ul_BFu1i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu31i, Ul_BFu1i_BFu31i)
//============================================================================



static void Test_Ul_BFu1i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu31ll");
    static STRUCT_IF_C Ul_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu31ll, Ul_BFu1i_BFu31ll)
//============================================================================



static void Test_Ul_BFu1i_BFu32i()
{
  {
    init_simple_test("Ul_BFu1i_BFu32i");
    static STRUCT_IF_C Ul_BFu1i_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu32i, Ul_BFu1i_BFu32i)
//============================================================================



static void Test_Ul_BFu1i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu32ll");
    static STRUCT_IF_C Ul_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu32ll, Ul_BFu1i_BFu32ll)
//============================================================================



static void Test_Ul_BFu1i_BFu33()
{
  {
    init_simple_test("Ul_BFu1i_BFu33");
    static STRUCT_IF_C Ul_BFu1i_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, 1, "Ul_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, hide_ull(1LL<<32), "Ul_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu33, Ul_BFu1i_BFu33)
//============================================================================



static void Test_Ul_BFu1i_BFu7c()
{
  {
    init_simple_test("Ul_BFu1i_BFu7c");
    static STRUCT_IF_C Ul_BFu1i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu7c, Ul_BFu1i_BFu7c)
//============================================================================



static void Test_Ul_BFu1i_BFu7i()
{
  {
    init_simple_test("Ul_BFu1i_BFu7i");
    static STRUCT_IF_C Ul_BFu1i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu7i, Ul_BFu1i_BFu7i)
//============================================================================



static void Test_Ul_BFu1i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu7ll");
    static STRUCT_IF_C Ul_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu7ll, Ul_BFu1i_BFu7ll)
//============================================================================



static void Test_Ul_BFu1i_BFu7s()
{
  {
    init_simple_test("Ul_BFu1i_BFu7s");
    static STRUCT_IF_C Ul_BFu1i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu7s, Ul_BFu1i_BFu7s)
//============================================================================



static void Test_Ul_BFu1i_BFu8c()
{
  {
    init_simple_test("Ul_BFu1i_BFu8c");
    static STRUCT_IF_C Ul_BFu1i_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu8c, Ul_BFu1i_BFu8c)
//============================================================================



static void Test_Ul_BFu1i_BFu8i()
{
  {
    init_simple_test("Ul_BFu1i_BFu8i");
    static STRUCT_IF_C Ul_BFu1i_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu8i, Ul_BFu1i_BFu8i)
//============================================================================



static void Test_Ul_BFu1i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu8ll");
    static STRUCT_IF_C Ul_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu8ll, Ul_BFu1i_BFu8ll)
//============================================================================



static void Test_Ul_BFu1i_BFu8s()
{
  {
    init_simple_test("Ul_BFu1i_BFu8s");
    static STRUCT_IF_C Ul_BFu1i_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu8s, Ul_BFu1i_BFu8s)
//============================================================================



static void Test_Ul_BFu1i_BFu9i()
{
  {
    init_simple_test("Ul_BFu1i_BFu9i");
    static STRUCT_IF_C Ul_BFu1i_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu9i, Ul_BFu1i_BFu9i)
//============================================================================



static void Test_Ul_BFu1i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu1i_BFu9ll");
    static STRUCT_IF_C Ul_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu9ll, Ul_BFu1i_BFu9ll)
//============================================================================



static void Test_Ul_BFu1i_BFu9s()
{
  {
    init_simple_test("Ul_BFu1i_BFu9s");
    static STRUCT_IF_C Ul_BFu1i_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_BFu9s, Ul_BFu1i_BFu9s)
//============================================================================



static void Test_Ul_BFu1i_C()
{
  {
    init_simple_test("Ul_BFu1i_C");
    static STRUCT_IF_C Ul_BFu1i_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_C");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_C, Ul_BFu1i_C)
//============================================================================



static void Test_Ul_BFu1i_D()
{
  {
    init_simple_test("Ul_BFu1i_D");
    static STRUCT_IF_C Ul_BFu1i_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_D");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_D, Ul_BFu1i_D)
//============================================================================



static void Test_Ul_BFu1i_F()
{
  {
    init_simple_test("Ul_BFu1i_F");
    static STRUCT_IF_C Ul_BFu1i_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_F");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_F, Ul_BFu1i_F)
//============================================================================



static void Test_Ul_BFu1i_I()
{
  {
    init_simple_test("Ul_BFu1i_I");
    static STRUCT_IF_C Ul_BFu1i_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_I");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_I, Ul_BFu1i_I)
//============================================================================



static void Test_Ul_BFu1i_Ip()
{
  {
    init_simple_test("Ul_BFu1i_Ip");
    static STRUCT_IF_C Ul_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_Ip, Ul_BFu1i_Ip)
//============================================================================



static void Test_Ul_BFu1i_L()
{
  {
    init_simple_test("Ul_BFu1i_L");
    static STRUCT_IF_C Ul_BFu1i_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_L");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_L, Ul_BFu1i_L)
//============================================================================



static void Test_Ul_BFu1i_S()
{
  {
    init_simple_test("Ul_BFu1i_S");
    static STRUCT_IF_C Ul_BFu1i_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_S");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_S, Ul_BFu1i_S)
//============================================================================



static void Test_Ul_BFu1i_Uc()
{
  {
    init_simple_test("Ul_BFu1i_Uc");
    static STRUCT_IF_C Ul_BFu1i_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_Uc, Ul_BFu1i_Uc)
//============================================================================



static void Test_Ul_BFu1i_Ui()
{
  {
    init_simple_test("Ul_BFu1i_Ui");
    static STRUCT_IF_C Ul_BFu1i_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_Ui, Ul_BFu1i_Ui)
//============================================================================



static void Test_Ul_BFu1i_Ul()
{
  {
    init_simple_test("Ul_BFu1i_Ul");
    static STRUCT_IF_C Ul_BFu1i_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_Ul, Ul_BFu1i_Ul)
//============================================================================



static void Test_Ul_BFu1i_Us()
{
  {
    init_simple_test("Ul_BFu1i_Us");
    static STRUCT_IF_C Ul_BFu1i_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_Us, Ul_BFu1i_Us)
//============================================================================



static void Test_Ul_BFu1i_Vp()
{
  {
    init_simple_test("Ul_BFu1i_Vp");
    static STRUCT_IF_C Ul_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1i_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1i_Vp, Ul_BFu1i_Vp)
//============================================================================



static void Test_Ul_BFu1ll()
{
  {
    init_simple_test("Ul_BFu1ll");
    static STRUCT_IF_C Ul_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll, Ul_BFu1ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu15i");
    static STRUCT_IF_C Ul_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu15i, Ul_BFu1ll_BFu15i)
//============================================================================



static void Test_Ul_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu15ll, Ul_BFu1ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu1ll_BFu15s");
    static STRUCT_IF_C Ul_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu15s, Ul_BFu1ll_BFu15s)
//============================================================================



static void Test_Ul_BFu1ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu16i");
    static STRUCT_IF_C Ul_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu16i, Ul_BFu1ll_BFu16i)
//============================================================================



static void Test_Ul_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu16ll, Ul_BFu1ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu1ll_BFu16s");
    static STRUCT_IF_C Ul_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu16s, Ul_BFu1ll_BFu16s)
//============================================================================



static void Test_Ul_BFu1ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu17i");
    static STRUCT_IF_C Ul_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu17i, Ul_BFu1ll_BFu17i)
//============================================================================



static void Test_Ul_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu17ll, Ul_BFu1ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu1ll_BFu1c");
    static STRUCT_IF_C Ul_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu1c, Ul_BFu1ll_BFu1c)
//============================================================================



static void Test_Ul_BFu1ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu1i");
    static STRUCT_IF_C Ul_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu1i, Ul_BFu1ll_BFu1i)
//============================================================================



static void Test_Ul_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu1ll, Ul_BFu1ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu1ll_BFu1s");
    static STRUCT_IF_C Ul_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu1s, Ul_BFu1ll_BFu1s)
//============================================================================



static void Test_Ul_BFu1ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu31i");
    static STRUCT_IF_C Ul_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu31i, Ul_BFu1ll_BFu31i)
//============================================================================



static void Test_Ul_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu31ll, Ul_BFu1ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu32i");
    static STRUCT_IF_C Ul_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu32i, Ul_BFu1ll_BFu32i)
//============================================================================



static void Test_Ul_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu32ll, Ul_BFu1ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu33()
{
  {
    init_simple_test("Ul_BFu1ll_BFu33");
    static STRUCT_IF_C Ul_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, 1, "Ul_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, hide_ull(1LL<<32), "Ul_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu33, Ul_BFu1ll_BFu33)
//============================================================================



static void Test_Ul_BFu1ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu1ll_BFu7c");
    static STRUCT_IF_C Ul_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu7c, Ul_BFu1ll_BFu7c)
//============================================================================



static void Test_Ul_BFu1ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu7i");
    static STRUCT_IF_C Ul_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu7i, Ul_BFu1ll_BFu7i)
//============================================================================



static void Test_Ul_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu7ll, Ul_BFu1ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu1ll_BFu7s");
    static STRUCT_IF_C Ul_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu7s, Ul_BFu1ll_BFu7s)
//============================================================================



static void Test_Ul_BFu1ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu1ll_BFu8c");
    static STRUCT_IF_C Ul_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu8c, Ul_BFu1ll_BFu8c)
//============================================================================



static void Test_Ul_BFu1ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu8i");
    static STRUCT_IF_C Ul_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu8i, Ul_BFu1ll_BFu8i)
//============================================================================



static void Test_Ul_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu8ll, Ul_BFu1ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu1ll_BFu8s");
    static STRUCT_IF_C Ul_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu8s, Ul_BFu1ll_BFu8s)
//============================================================================



static void Test_Ul_BFu1ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu1ll_BFu9i");
    static STRUCT_IF_C Ul_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu9i, Ul_BFu1ll_BFu9i)
//============================================================================



static void Test_Ul_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu1ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu9ll, Ul_BFu1ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu1ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu1ll_BFu9s");
    static STRUCT_IF_C Ul_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_BFu9s, Ul_BFu1ll_BFu9s)
//============================================================================



static void Test_Ul_BFu1ll_C()
{
  {
    init_simple_test("Ul_BFu1ll_C");
    static STRUCT_IF_C Ul_BFu1ll_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_C");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_C, Ul_BFu1ll_C)
//============================================================================



static void Test_Ul_BFu1ll_D()
{
  {
    init_simple_test("Ul_BFu1ll_D");
    static STRUCT_IF_C Ul_BFu1ll_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_D");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_D, Ul_BFu1ll_D)
//============================================================================



static void Test_Ul_BFu1ll_F()
{
  {
    init_simple_test("Ul_BFu1ll_F");
    static STRUCT_IF_C Ul_BFu1ll_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_F");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_F, Ul_BFu1ll_F)
//============================================================================



static void Test_Ul_BFu1ll_I()
{
  {
    init_simple_test("Ul_BFu1ll_I");
    static STRUCT_IF_C Ul_BFu1ll_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_I");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_I, Ul_BFu1ll_I)
//============================================================================



static void Test_Ul_BFu1ll_Ip()
{
  {
    init_simple_test("Ul_BFu1ll_Ip");
    static STRUCT_IF_C Ul_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_Ip, Ul_BFu1ll_Ip)
//============================================================================



static void Test_Ul_BFu1ll_L()
{
  {
    init_simple_test("Ul_BFu1ll_L");
    static STRUCT_IF_C Ul_BFu1ll_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_L");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_L, Ul_BFu1ll_L)
//============================================================================



static void Test_Ul_BFu1ll_S()
{
  {
    init_simple_test("Ul_BFu1ll_S");
    static STRUCT_IF_C Ul_BFu1ll_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_S");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_S, Ul_BFu1ll_S)
//============================================================================



static void Test_Ul_BFu1ll_Uc()
{
  {
    init_simple_test("Ul_BFu1ll_Uc");
    static STRUCT_IF_C Ul_BFu1ll_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_Uc, Ul_BFu1ll_Uc)
//============================================================================



static void Test_Ul_BFu1ll_Ui()
{
  {
    init_simple_test("Ul_BFu1ll_Ui");
    static STRUCT_IF_C Ul_BFu1ll_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_Ui, Ul_BFu1ll_Ui)
//============================================================================



static void Test_Ul_BFu1ll_Ul()
{
  {
    init_simple_test("Ul_BFu1ll_Ul");
    static STRUCT_IF_C Ul_BFu1ll_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_Ul, Ul_BFu1ll_Ul)
//============================================================================



static void Test_Ul_BFu1ll_Us()
{
  {
    init_simple_test("Ul_BFu1ll_Us");
    static STRUCT_IF_C Ul_BFu1ll_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_Us, Ul_BFu1ll_Us)
//============================================================================



static void Test_Ul_BFu1ll_Vp()
{
  {
    init_simple_test("Ul_BFu1ll_Vp");
    static STRUCT_IF_C Ul_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1ll_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1ll_Vp, Ul_BFu1ll_Vp)
//============================================================================



static void Test_Ul_BFu1s()
{
  {
    init_simple_test("Ul_BFu1s");
    static STRUCT_IF_C Ul_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s, Ul_BFu1s)
//============================================================================



static void Test_Ul_BFu1s_BFu15i()
{
  {
    init_simple_test("Ul_BFu1s_BFu15i");
    static STRUCT_IF_C Ul_BFu1s_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu15i, Ul_BFu1s_BFu15i)
//============================================================================



static void Test_Ul_BFu1s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu15ll");
    static STRUCT_IF_C Ul_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu15ll, Ul_BFu1s_BFu15ll)
//============================================================================



static void Test_Ul_BFu1s_BFu15s()
{
  {
    init_simple_test("Ul_BFu1s_BFu15s");
    static STRUCT_IF_C Ul_BFu1s_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "Ul_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "Ul_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu15s, Ul_BFu1s_BFu15s)
//============================================================================



static void Test_Ul_BFu1s_BFu16i()
{
  {
    init_simple_test("Ul_BFu1s_BFu16i");
    static STRUCT_IF_C Ul_BFu1s_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu16i, Ul_BFu1s_BFu16i)
//============================================================================



static void Test_Ul_BFu1s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu16ll");
    static STRUCT_IF_C Ul_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu16ll, Ul_BFu1s_BFu16ll)
//============================================================================



static void Test_Ul_BFu1s_BFu16s()
{
  {
    init_simple_test("Ul_BFu1s_BFu16s");
    static STRUCT_IF_C Ul_BFu1s_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "Ul_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "Ul_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu16s, Ul_BFu1s_BFu16s)
//============================================================================



static void Test_Ul_BFu1s_BFu17i()
{
  {
    init_simple_test("Ul_BFu1s_BFu17i");
    static STRUCT_IF_C Ul_BFu1s_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu17i, Ul_BFu1s_BFu17i)
//============================================================================



static void Test_Ul_BFu1s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu17ll");
    static STRUCT_IF_C Ul_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "Ul_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "Ul_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu17ll, Ul_BFu1s_BFu17ll)
//============================================================================



static void Test_Ul_BFu1s_BFu1c()
{
  {
    init_simple_test("Ul_BFu1s_BFu1c");
    static STRUCT_IF_C Ul_BFu1s_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu1c, Ul_BFu1s_BFu1c)
//============================================================================



static void Test_Ul_BFu1s_BFu1i()
{
  {
    init_simple_test("Ul_BFu1s_BFu1i");
    static STRUCT_IF_C Ul_BFu1s_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu1i, Ul_BFu1s_BFu1i)
//============================================================================



static void Test_Ul_BFu1s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu1ll");
    static STRUCT_IF_C Ul_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu1ll, Ul_BFu1s_BFu1ll)
//============================================================================



static void Test_Ul_BFu1s_BFu1s()
{
  {
    init_simple_test("Ul_BFu1s_BFu1s");
    static STRUCT_IF_C Ul_BFu1s_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "Ul_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu1s, Ul_BFu1s_BFu1s)
//============================================================================



static void Test_Ul_BFu1s_BFu31i()
{
  {
    init_simple_test("Ul_BFu1s_BFu31i");
    static STRUCT_IF_C Ul_BFu1s_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu31i, Ul_BFu1s_BFu31i)
//============================================================================



static void Test_Ul_BFu1s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu31ll");
    static STRUCT_IF_C Ul_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "Ul_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "Ul_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu31ll, Ul_BFu1s_BFu31ll)
//============================================================================



static void Test_Ul_BFu1s_BFu32i()
{
  {
    init_simple_test("Ul_BFu1s_BFu32i");
    static STRUCT_IF_C Ul_BFu1s_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu32i, Ul_BFu1s_BFu32i)
//============================================================================



static void Test_Ul_BFu1s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu32ll");
    static STRUCT_IF_C Ul_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "Ul_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "Ul_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu32ll, Ul_BFu1s_BFu32ll)
//============================================================================



static void Test_Ul_BFu1s_BFu33()
{
  {
    init_simple_test("Ul_BFu1s_BFu33");
    static STRUCT_IF_C Ul_BFu1s_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, 1, "Ul_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, hide_ull(1LL<<32), "Ul_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu33, Ul_BFu1s_BFu33)
//============================================================================



static void Test_Ul_BFu1s_BFu7c()
{
  {
    init_simple_test("Ul_BFu1s_BFu7c");
    static STRUCT_IF_C Ul_BFu1s_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu7c, Ul_BFu1s_BFu7c)
//============================================================================



static void Test_Ul_BFu1s_BFu7i()
{
  {
    init_simple_test("Ul_BFu1s_BFu7i");
    static STRUCT_IF_C Ul_BFu1s_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu7i, Ul_BFu1s_BFu7i)
//============================================================================



static void Test_Ul_BFu1s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu7ll");
    static STRUCT_IF_C Ul_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu7ll, Ul_BFu1s_BFu7ll)
//============================================================================



static void Test_Ul_BFu1s_BFu7s()
{
  {
    init_simple_test("Ul_BFu1s_BFu7s");
    static STRUCT_IF_C Ul_BFu1s_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "Ul_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "Ul_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu7s, Ul_BFu1s_BFu7s)
//============================================================================



static void Test_Ul_BFu1s_BFu8c()
{
  {
    init_simple_test("Ul_BFu1s_BFu8c");
    static STRUCT_IF_C Ul_BFu1s_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu8c, Ul_BFu1s_BFu8c)
//============================================================================



static void Test_Ul_BFu1s_BFu8i()
{
  {
    init_simple_test("Ul_BFu1s_BFu8i");
    static STRUCT_IF_C Ul_BFu1s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu8i, Ul_BFu1s_BFu8i)
//============================================================================



static void Test_Ul_BFu1s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu8ll");
    static STRUCT_IF_C Ul_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu8ll, Ul_BFu1s_BFu8ll)
//============================================================================



static void Test_Ul_BFu1s_BFu8s()
{
  {
    init_simple_test("Ul_BFu1s_BFu8s");
    static STRUCT_IF_C Ul_BFu1s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "Ul_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "Ul_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu8s, Ul_BFu1s_BFu8s)
//============================================================================



static void Test_Ul_BFu1s_BFu9i()
{
  {
    init_simple_test("Ul_BFu1s_BFu9i");
    static STRUCT_IF_C Ul_BFu1s_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu9i, Ul_BFu1s_BFu9i)
//============================================================================



static void Test_Ul_BFu1s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu1s_BFu9ll");
    static STRUCT_IF_C Ul_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu9ll, Ul_BFu1s_BFu9ll)
//============================================================================



static void Test_Ul_BFu1s_BFu9s()
{
  {
    init_simple_test("Ul_BFu1s_BFu9s");
    static STRUCT_IF_C Ul_BFu1s_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "Ul_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "Ul_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_BFu9s, Ul_BFu1s_BFu9s)
//============================================================================



static void Test_Ul_BFu1s_C()
{
  {
    init_simple_test("Ul_BFu1s_C");
    static STRUCT_IF_C Ul_BFu1s_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_C");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_C, Ul_BFu1s_C)
//============================================================================



static void Test_Ul_BFu1s_D()
{
  {
    init_simple_test("Ul_BFu1s_D");
    static STRUCT_IF_C Ul_BFu1s_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_D");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_D, Ul_BFu1s_D)
//============================================================================



static void Test_Ul_BFu1s_F()
{
  {
    init_simple_test("Ul_BFu1s_F");
    static STRUCT_IF_C Ul_BFu1s_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_F");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_F, Ul_BFu1s_F)
//============================================================================



static void Test_Ul_BFu1s_I()
{
  {
    init_simple_test("Ul_BFu1s_I");
    static STRUCT_IF_C Ul_BFu1s_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_I");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_I, Ul_BFu1s_I)
//============================================================================



static void Test_Ul_BFu1s_Ip()
{
  {
    init_simple_test("Ul_BFu1s_Ip");
    static STRUCT_IF_C Ul_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_Ip, Ul_BFu1s_Ip)
//============================================================================



static void Test_Ul_BFu1s_L()
{
  {
    init_simple_test("Ul_BFu1s_L");
    static STRUCT_IF_C Ul_BFu1s_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_L");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_L, Ul_BFu1s_L)
//============================================================================



static void Test_Ul_BFu1s_S()
{
  {
    init_simple_test("Ul_BFu1s_S");
    static STRUCT_IF_C Ul_BFu1s_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_S");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_S, Ul_BFu1s_S)
//============================================================================



static void Test_Ul_BFu1s_Uc()
{
  {
    init_simple_test("Ul_BFu1s_Uc");
    static STRUCT_IF_C Ul_BFu1s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_Uc, Ul_BFu1s_Uc)
//============================================================================



static void Test_Ul_BFu1s_Ui()
{
  {
    init_simple_test("Ul_BFu1s_Ui");
    static STRUCT_IF_C Ul_BFu1s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_Ui, Ul_BFu1s_Ui)
//============================================================================



static void Test_Ul_BFu1s_Ul()
{
  {
    init_simple_test("Ul_BFu1s_Ul");
    static STRUCT_IF_C Ul_BFu1s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_Ul, Ul_BFu1s_Ul)
//============================================================================



static void Test_Ul_BFu1s_Us()
{
  {
    init_simple_test("Ul_BFu1s_Us");
    static STRUCT_IF_C Ul_BFu1s_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_Us, Ul_BFu1s_Us)
//============================================================================



static void Test_Ul_BFu1s_Vp()
{
  {
    init_simple_test("Ul_BFu1s_Vp");
    static STRUCT_IF_C Ul_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1s_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu1s_Vp, Ul_BFu1s_Vp)
//============================================================================



static void Test_Ul_BFu31i()
{
  {
    init_simple_test("Ul_BFu31i");
    static STRUCT_IF_C Ul_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i, Ul_BFu31i)
//============================================================================



static void Test_Ul_BFu31i_BFu15i()
{
  {
    init_simple_test("Ul_BFu31i_BFu15i");
    static STRUCT_IF_C Ul_BFu31i_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "Ul_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "Ul_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu15i, Ul_BFu31i_BFu15i)
//============================================================================



static void Test_Ul_BFu31i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu15ll");
    static STRUCT_IF_C Ul_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "Ul_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "Ul_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu15ll, Ul_BFu31i_BFu15ll)
//============================================================================



static void Test_Ul_BFu31i_BFu15s()
{
  {
    init_simple_test("Ul_BFu31i_BFu15s");
    static STRUCT_IF_C Ul_BFu31i_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "Ul_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "Ul_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu15s, Ul_BFu31i_BFu15s)
//============================================================================



static void Test_Ul_BFu31i_BFu16i()
{
  {
    init_simple_test("Ul_BFu31i_BFu16i");
    static STRUCT_IF_C Ul_BFu31i_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "Ul_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "Ul_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu16i, Ul_BFu31i_BFu16i)
//============================================================================



static void Test_Ul_BFu31i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu16ll");
    static STRUCT_IF_C Ul_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "Ul_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "Ul_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu16ll, Ul_BFu31i_BFu16ll)
//============================================================================



static void Test_Ul_BFu31i_BFu16s()
{
  {
    init_simple_test("Ul_BFu31i_BFu16s");
    static STRUCT_IF_C Ul_BFu31i_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "Ul_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "Ul_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu16s, Ul_BFu31i_BFu16s)
//============================================================================



static void Test_Ul_BFu31i_BFu17i()
{
  {
    init_simple_test("Ul_BFu31i_BFu17i");
    static STRUCT_IF_C Ul_BFu31i_BFu17i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "Ul_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "Ul_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu17i, Ul_BFu31i_BFu17i)
//============================================================================



static void Test_Ul_BFu31i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu17ll");
    static STRUCT_IF_C Ul_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "Ul_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "Ul_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu17ll, Ul_BFu31i_BFu17ll)
//============================================================================



static void Test_Ul_BFu31i_BFu1c()
{
  {
    init_simple_test("Ul_BFu31i_BFu1c");
    static STRUCT_IF_C Ul_BFu31i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu1c, Ul_BFu31i_BFu1c)
//============================================================================



static void Test_Ul_BFu31i_BFu1i()
{
  {
    init_simple_test("Ul_BFu31i_BFu1i");
    static STRUCT_IF_C Ul_BFu31i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu1i, Ul_BFu31i_BFu1i)
//============================================================================



static void Test_Ul_BFu31i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu1ll");
    static STRUCT_IF_C Ul_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu1ll, Ul_BFu31i_BFu1ll)
//============================================================================



static void Test_Ul_BFu31i_BFu1s()
{
  {
    init_simple_test("Ul_BFu31i_BFu1s");
    static STRUCT_IF_C Ul_BFu31i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu1s, Ul_BFu31i_BFu1s)
//============================================================================



static void Test_Ul_BFu31i_BFu31i()
{
  {
    init_simple_test("Ul_BFu31i_BFu31i");
    static STRUCT_IF_C Ul_BFu31i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "Ul_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu31i, Ul_BFu31i_BFu31i)
//============================================================================



static void Test_Ul_BFu31i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu31ll");
    static STRUCT_IF_C Ul_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "Ul_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu31ll, Ul_BFu31i_BFu31ll)
//============================================================================



static void Test_Ul_BFu31i_BFu32i()
{
  {
    init_simple_test("Ul_BFu31i_BFu32i");
    static STRUCT_IF_C Ul_BFu31i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "Ul_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "Ul_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu32i, Ul_BFu31i_BFu32i)
//============================================================================



static void Test_Ul_BFu31i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu32ll");
    static STRUCT_IF_C Ul_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "Ul_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "Ul_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu32ll, Ul_BFu31i_BFu32ll)
//============================================================================



static void Test_Ul_BFu31i_BFu33()
{
  {
    init_simple_test("Ul_BFu31i_BFu33");
    static STRUCT_IF_C Ul_BFu31i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, 1, "Ul_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, hide_ull(1LL<<32), "Ul_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu33, Ul_BFu31i_BFu33)
//============================================================================



static void Test_Ul_BFu31i_BFu7c()
{
  {
    init_simple_test("Ul_BFu31i_BFu7c");
    static STRUCT_IF_C Ul_BFu31i_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu7c, Ul_BFu31i_BFu7c)
//============================================================================



static void Test_Ul_BFu31i_BFu7i()
{
  {
    init_simple_test("Ul_BFu31i_BFu7i");
    static STRUCT_IF_C Ul_BFu31i_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu7i, Ul_BFu31i_BFu7i)
//============================================================================



static void Test_Ul_BFu31i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu7ll");
    static STRUCT_IF_C Ul_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu7ll, Ul_BFu31i_BFu7ll)
//============================================================================



static void Test_Ul_BFu31i_BFu7s()
{
  {
    init_simple_test("Ul_BFu31i_BFu7s");
    static STRUCT_IF_C Ul_BFu31i_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu7s, Ul_BFu31i_BFu7s)
//============================================================================



static void Test_Ul_BFu31i_BFu8c()
{
  {
    init_simple_test("Ul_BFu31i_BFu8c");
    static STRUCT_IF_C Ul_BFu31i_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu8c, Ul_BFu31i_BFu8c)
//============================================================================



static void Test_Ul_BFu31i_BFu8i()
{
  {
    init_simple_test("Ul_BFu31i_BFu8i");
    static STRUCT_IF_C Ul_BFu31i_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu8i, Ul_BFu31i_BFu8i)
//============================================================================



static void Test_Ul_BFu31i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu8ll");
    static STRUCT_IF_C Ul_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu8ll, Ul_BFu31i_BFu8ll)
//============================================================================



static void Test_Ul_BFu31i_BFu8s()
{
  {
    init_simple_test("Ul_BFu31i_BFu8s");
    static STRUCT_IF_C Ul_BFu31i_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu8s, Ul_BFu31i_BFu8s)
//============================================================================



static void Test_Ul_BFu31i_BFu9i()
{
  {
    init_simple_test("Ul_BFu31i_BFu9i");
    static STRUCT_IF_C Ul_BFu31i_BFu9i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "Ul_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "Ul_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu9i, Ul_BFu31i_BFu9i)
//============================================================================



static void Test_Ul_BFu31i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu31i_BFu9ll");
    static STRUCT_IF_C Ul_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "Ul_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "Ul_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu9ll, Ul_BFu31i_BFu9ll)
//============================================================================



static void Test_Ul_BFu31i_BFu9s()
{
  {
    init_simple_test("Ul_BFu31i_BFu9s");
    static STRUCT_IF_C Ul_BFu31i_BFu9s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "Ul_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "Ul_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_BFu9s, Ul_BFu31i_BFu9s)
//============================================================================



static void Test_Ul_BFu31i_C()
{
  {
    init_simple_test("Ul_BFu31i_C");
    static STRUCT_IF_C Ul_BFu31i_C lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_C");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_C");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_C, Ul_BFu31i_C)
//============================================================================



static void Test_Ul_BFu31i_D()
{
  {
    init_simple_test("Ul_BFu31i_D");
    static STRUCT_IF_C Ul_BFu31i_D lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_D");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_D");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_D, Ul_BFu31i_D)
//============================================================================



static void Test_Ul_BFu31i_F()
{
  {
    init_simple_test("Ul_BFu31i_F");
    static STRUCT_IF_C Ul_BFu31i_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_F");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_F");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_F, Ul_BFu31i_F)
//============================================================================



static void Test_Ul_BFu31i_I()
{
  {
    init_simple_test("Ul_BFu31i_I");
    static STRUCT_IF_C Ul_BFu31i_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_I");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_I");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_I, Ul_BFu31i_I)
//============================================================================



static void Test_Ul_BFu31i_Ip()
{
  {
    init_simple_test("Ul_BFu31i_Ip");
    static STRUCT_IF_C Ul_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_Ip");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_Ip, Ul_BFu31i_Ip)
//============================================================================



static void Test_Ul_BFu31i_L()
{
  {
    init_simple_test("Ul_BFu31i_L");
    static STRUCT_IF_C Ul_BFu31i_L lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_L");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_L");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_L, Ul_BFu31i_L)
//============================================================================



static void Test_Ul_BFu31i_S()
{
  {
    init_simple_test("Ul_BFu31i_S");
    static STRUCT_IF_C Ul_BFu31i_S lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_S");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_S");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_S, Ul_BFu31i_S)
//============================================================================



static void Test_Ul_BFu31i_Uc()
{
  {
    init_simple_test("Ul_BFu31i_Uc");
    static STRUCT_IF_C Ul_BFu31i_Uc lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_Uc");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_Uc, Ul_BFu31i_Uc)
//============================================================================



static void Test_Ul_BFu31i_Ui()
{
  {
    init_simple_test("Ul_BFu31i_Ui");
    static STRUCT_IF_C Ul_BFu31i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_Ui, Ul_BFu31i_Ui)
//============================================================================



static void Test_Ul_BFu31i_Ul()
{
  {
    init_simple_test("Ul_BFu31i_Ul");
    static STRUCT_IF_C Ul_BFu31i_Ul lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_Ul");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_Ul, Ul_BFu31i_Ul)
//============================================================================



static void Test_Ul_BFu31i_Us()
{
  {
    init_simple_test("Ul_BFu31i_Us");
    static STRUCT_IF_C Ul_BFu31i_Us lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_Us");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_Us");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_Us, Ul_BFu31i_Us)
//============================================================================



static void Test_Ul_BFu31i_Vp()
{
  {
    init_simple_test("Ul_BFu31i_Vp");
    static STRUCT_IF_C Ul_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31i_Vp");
    check_field_offset(lv, v3, 12, "Ul_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31i_Vp, Ul_BFu31i_Vp)
//============================================================================



static void Test_Ul_BFu31ll()
{
  {
    init_simple_test("Ul_BFu31ll");
    static STRUCT_IF_C Ul_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll, Ul_BFu31ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu15i");
    static STRUCT_IF_C Ul_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "Ul_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "Ul_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu15i, Ul_BFu31ll_BFu15i)
//============================================================================



static void Test_Ul_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "Ul_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "Ul_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu15ll, Ul_BFu31ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu31ll_BFu15s");
    static STRUCT_IF_C Ul_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "Ul_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "Ul_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu15s, Ul_BFu31ll_BFu15s)
//============================================================================



static void Test_Ul_BFu31ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu16i");
    static STRUCT_IF_C Ul_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "Ul_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "Ul_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu16i, Ul_BFu31ll_BFu16i)
//============================================================================



static void Test_Ul_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "Ul_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "Ul_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu16ll, Ul_BFu31ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu31ll_BFu16s");
    static STRUCT_IF_C Ul_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "Ul_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "Ul_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu16s, Ul_BFu31ll_BFu16s)
//============================================================================



static void Test_Ul_BFu31ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu17i");
    static STRUCT_IF_C Ul_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "Ul_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "Ul_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu17i, Ul_BFu31ll_BFu17i)
//============================================================================



static void Test_Ul_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "Ul_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "Ul_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu17ll, Ul_BFu31ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu31ll_BFu1c");
    static STRUCT_IF_C Ul_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu1c, Ul_BFu31ll_BFu1c)
//============================================================================



static void Test_Ul_BFu31ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu1i");
    static STRUCT_IF_C Ul_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu1i, Ul_BFu31ll_BFu1i)
//============================================================================



static void Test_Ul_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu1ll, Ul_BFu31ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu31ll_BFu1s");
    static STRUCT_IF_C Ul_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "Ul_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu1s, Ul_BFu31ll_BFu1s)
//============================================================================



static void Test_Ul_BFu31ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu31i");
    static STRUCT_IF_C Ul_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "Ul_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu31i, Ul_BFu31ll_BFu31i)
//============================================================================



static void Test_Ul_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "Ul_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu31ll, Ul_BFu31ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu32i");
    static STRUCT_IF_C Ul_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "Ul_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "Ul_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu32i, Ul_BFu31ll_BFu32i)
//============================================================================



static void Test_Ul_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "Ul_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "Ul_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu32ll, Ul_BFu31ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu33()
{
  {
    init_simple_test("Ul_BFu31ll_BFu33");
    static STRUCT_IF_C Ul_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, 1, "Ul_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, hide_ull(1LL<<32), "Ul_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu33, Ul_BFu31ll_BFu33)
//============================================================================



static void Test_Ul_BFu31ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu31ll_BFu7c");
    static STRUCT_IF_C Ul_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu7c, Ul_BFu31ll_BFu7c)
//============================================================================



static void Test_Ul_BFu31ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu7i");
    static STRUCT_IF_C Ul_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu7i, Ul_BFu31ll_BFu7i)
//============================================================================



static void Test_Ul_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu7ll, Ul_BFu31ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu31ll_BFu7s");
    static STRUCT_IF_C Ul_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "Ul_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "Ul_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu7s, Ul_BFu31ll_BFu7s)
//============================================================================



static void Test_Ul_BFu31ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu31ll_BFu8c");
    static STRUCT_IF_C Ul_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu8c, Ul_BFu31ll_BFu8c)
//============================================================================



static void Test_Ul_BFu31ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu8i");
    static STRUCT_IF_C Ul_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu8i, Ul_BFu31ll_BFu8i)
//============================================================================



static void Test_Ul_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu8ll, Ul_BFu31ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu31ll_BFu8s");
    static STRUCT_IF_C Ul_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "Ul_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "Ul_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu8s, Ul_BFu31ll_BFu8s)
//============================================================================



static void Test_Ul_BFu31ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu31ll_BFu9i");
    static STRUCT_IF_C Ul_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "Ul_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "Ul_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu9i, Ul_BFu31ll_BFu9i)
//============================================================================



static void Test_Ul_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu31ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "Ul_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "Ul_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu9ll, Ul_BFu31ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu31ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu31ll_BFu9s");
    static STRUCT_IF_C Ul_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "Ul_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "Ul_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_BFu9s, Ul_BFu31ll_BFu9s)
//============================================================================



static void Test_Ul_BFu31ll_C()
{
  {
    init_simple_test("Ul_BFu31ll_C");
    static STRUCT_IF_C Ul_BFu31ll_C lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_C");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_C");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_C, Ul_BFu31ll_C)
//============================================================================



static void Test_Ul_BFu31ll_D()
{
  {
    init_simple_test("Ul_BFu31ll_D");
    static STRUCT_IF_C Ul_BFu31ll_D lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_D");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_D");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_D, Ul_BFu31ll_D)
//============================================================================



static void Test_Ul_BFu31ll_F()
{
  {
    init_simple_test("Ul_BFu31ll_F");
    static STRUCT_IF_C Ul_BFu31ll_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_F");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_F");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_F, Ul_BFu31ll_F)
//============================================================================



static void Test_Ul_BFu31ll_I()
{
  {
    init_simple_test("Ul_BFu31ll_I");
    static STRUCT_IF_C Ul_BFu31ll_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_I");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_I");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_I, Ul_BFu31ll_I)
//============================================================================



static void Test_Ul_BFu31ll_Ip()
{
  {
    init_simple_test("Ul_BFu31ll_Ip");
    static STRUCT_IF_C Ul_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_Ip");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_Ip, Ul_BFu31ll_Ip)
//============================================================================



static void Test_Ul_BFu31ll_L()
{
  {
    init_simple_test("Ul_BFu31ll_L");
    static STRUCT_IF_C Ul_BFu31ll_L lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_L");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_L");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_L, Ul_BFu31ll_L)
//============================================================================



static void Test_Ul_BFu31ll_S()
{
  {
    init_simple_test("Ul_BFu31ll_S");
    static STRUCT_IF_C Ul_BFu31ll_S lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_S");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_S");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_S, Ul_BFu31ll_S)
//============================================================================



static void Test_Ul_BFu31ll_Uc()
{
  {
    init_simple_test("Ul_BFu31ll_Uc");
    static STRUCT_IF_C Ul_BFu31ll_Uc lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_Uc");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_Uc, Ul_BFu31ll_Uc)
//============================================================================



static void Test_Ul_BFu31ll_Ui()
{
  {
    init_simple_test("Ul_BFu31ll_Ui");
    static STRUCT_IF_C Ul_BFu31ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_Ui, Ul_BFu31ll_Ui)
//============================================================================



static void Test_Ul_BFu31ll_Ul()
{
  {
    init_simple_test("Ul_BFu31ll_Ul");
    static STRUCT_IF_C Ul_BFu31ll_Ul lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_Ul");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_Ul, Ul_BFu31ll_Ul)
//============================================================================



static void Test_Ul_BFu31ll_Us()
{
  {
    init_simple_test("Ul_BFu31ll_Us");
    static STRUCT_IF_C Ul_BFu31ll_Us lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_Us");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_Us, Ul_BFu31ll_Us)
//============================================================================



static void Test_Ul_BFu31ll_Vp()
{
  {
    init_simple_test("Ul_BFu31ll_Vp");
    static STRUCT_IF_C Ul_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu31ll_Vp");
    check_field_offset(lv, v3, 12, "Ul_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu31ll_Vp, Ul_BFu31ll_Vp)
//============================================================================



static void Test_Ul_BFu32i()
{
  {
    init_simple_test("Ul_BFu32i");
    static STRUCT_IF_C Ul_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i, Ul_BFu32i)
//============================================================================



static void Test_Ul_BFu32i_BFu15i()
{
  {
    init_simple_test("Ul_BFu32i_BFu15i");
    static STRUCT_IF_C Ul_BFu32i_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu15i, Ul_BFu32i_BFu15i)
//============================================================================



static void Test_Ul_BFu32i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu15ll");
    static STRUCT_IF_C Ul_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu15ll, Ul_BFu32i_BFu15ll)
//============================================================================



static void Test_Ul_BFu32i_BFu15s()
{
  {
    init_simple_test("Ul_BFu32i_BFu15s");
    static STRUCT_IF_C Ul_BFu32i_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu15s, Ul_BFu32i_BFu15s)
//============================================================================



static void Test_Ul_BFu32i_BFu16i()
{
  {
    init_simple_test("Ul_BFu32i_BFu16i");
    static STRUCT_IF_C Ul_BFu32i_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu16i, Ul_BFu32i_BFu16i)
//============================================================================



static void Test_Ul_BFu32i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu16ll");
    static STRUCT_IF_C Ul_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu16ll, Ul_BFu32i_BFu16ll)
//============================================================================



static void Test_Ul_BFu32i_BFu16s()
{
  {
    init_simple_test("Ul_BFu32i_BFu16s");
    static STRUCT_IF_C Ul_BFu32i_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu16s, Ul_BFu32i_BFu16s)
//============================================================================



static void Test_Ul_BFu32i_BFu17i()
{
  {
    init_simple_test("Ul_BFu32i_BFu17i");
    static STRUCT_IF_C Ul_BFu32i_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu17i, Ul_BFu32i_BFu17i)
//============================================================================



static void Test_Ul_BFu32i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu17ll");
    static STRUCT_IF_C Ul_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu17ll, Ul_BFu32i_BFu17ll)
//============================================================================



static void Test_Ul_BFu32i_BFu1c()
{
  {
    init_simple_test("Ul_BFu32i_BFu1c");
    static STRUCT_IF_C Ul_BFu32i_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu1c, Ul_BFu32i_BFu1c)
//============================================================================



static void Test_Ul_BFu32i_BFu1i()
{
  {
    init_simple_test("Ul_BFu32i_BFu1i");
    static STRUCT_IF_C Ul_BFu32i_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu1i, Ul_BFu32i_BFu1i)
//============================================================================



static void Test_Ul_BFu32i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu1ll");
    static STRUCT_IF_C Ul_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu1ll, Ul_BFu32i_BFu1ll)
//============================================================================



static void Test_Ul_BFu32i_BFu1s()
{
  {
    init_simple_test("Ul_BFu32i_BFu1s");
    static STRUCT_IF_C Ul_BFu32i_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu1s, Ul_BFu32i_BFu1s)
//============================================================================



static void Test_Ul_BFu32i_BFu31i()
{
  {
    init_simple_test("Ul_BFu32i_BFu31i");
    static STRUCT_IF_C Ul_BFu32i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu31i, Ul_BFu32i_BFu31i)
//============================================================================



static void Test_Ul_BFu32i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu31ll");
    static STRUCT_IF_C Ul_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu31ll, Ul_BFu32i_BFu31ll)
//============================================================================



static void Test_Ul_BFu32i_BFu32i()
{
  {
    init_simple_test("Ul_BFu32i_BFu32i");
    static STRUCT_IF_C Ul_BFu32i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu32i, Ul_BFu32i_BFu32i)
//============================================================================



static void Test_Ul_BFu32i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu32ll");
    static STRUCT_IF_C Ul_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu32ll, Ul_BFu32i_BFu32ll)
//============================================================================



static void Test_Ul_BFu32i_BFu33()
{
  {
    init_simple_test("Ul_BFu32i_BFu33");
    static STRUCT_IF_C Ul_BFu32i_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "Ul_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "Ul_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu33, Ul_BFu32i_BFu33)
//============================================================================



static void Test_Ul_BFu32i_BFu7c()
{
  {
    init_simple_test("Ul_BFu32i_BFu7c");
    static STRUCT_IF_C Ul_BFu32i_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu7c, Ul_BFu32i_BFu7c)
//============================================================================



static void Test_Ul_BFu32i_BFu7i()
{
  {
    init_simple_test("Ul_BFu32i_BFu7i");
    static STRUCT_IF_C Ul_BFu32i_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu7i, Ul_BFu32i_BFu7i)
//============================================================================



static void Test_Ul_BFu32i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu7ll");
    static STRUCT_IF_C Ul_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu7ll, Ul_BFu32i_BFu7ll)
//============================================================================



static void Test_Ul_BFu32i_BFu7s()
{
  {
    init_simple_test("Ul_BFu32i_BFu7s");
    static STRUCT_IF_C Ul_BFu32i_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu7s, Ul_BFu32i_BFu7s)
//============================================================================



static void Test_Ul_BFu32i_BFu8c()
{
  {
    init_simple_test("Ul_BFu32i_BFu8c");
    static STRUCT_IF_C Ul_BFu32i_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu8c, Ul_BFu32i_BFu8c)
//============================================================================



static void Test_Ul_BFu32i_BFu8i()
{
  {
    init_simple_test("Ul_BFu32i_BFu8i");
    static STRUCT_IF_C Ul_BFu32i_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu8i, Ul_BFu32i_BFu8i)
//============================================================================



static void Test_Ul_BFu32i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu8ll");
    static STRUCT_IF_C Ul_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu8ll, Ul_BFu32i_BFu8ll)
//============================================================================



static void Test_Ul_BFu32i_BFu8s()
{
  {
    init_simple_test("Ul_BFu32i_BFu8s");
    static STRUCT_IF_C Ul_BFu32i_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu8s, Ul_BFu32i_BFu8s)
//============================================================================



static void Test_Ul_BFu32i_BFu9i()
{
  {
    init_simple_test("Ul_BFu32i_BFu9i");
    static STRUCT_IF_C Ul_BFu32i_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu9i, Ul_BFu32i_BFu9i)
//============================================================================



static void Test_Ul_BFu32i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu32i_BFu9ll");
    static STRUCT_IF_C Ul_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu9ll, Ul_BFu32i_BFu9ll)
//============================================================================



static void Test_Ul_BFu32i_BFu9s()
{
  {
    init_simple_test("Ul_BFu32i_BFu9s");
    static STRUCT_IF_C Ul_BFu32i_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_BFu9s, Ul_BFu32i_BFu9s)
//============================================================================



static void Test_Ul_BFu32i_C()
{
  {
    init_simple_test("Ul_BFu32i_C");
    static STRUCT_IF_C Ul_BFu32i_C lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_C");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_C");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_C, Ul_BFu32i_C)
//============================================================================



static void Test_Ul_BFu32i_D()
{
  {
    init_simple_test("Ul_BFu32i_D");
    static STRUCT_IF_C Ul_BFu32i_D lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_D");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_D");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_D, Ul_BFu32i_D)
//============================================================================



static void Test_Ul_BFu32i_F()
{
  {
    init_simple_test("Ul_BFu32i_F");
    static STRUCT_IF_C Ul_BFu32i_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_F");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_F");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_F, Ul_BFu32i_F)
//============================================================================



static void Test_Ul_BFu32i_I()
{
  {
    init_simple_test("Ul_BFu32i_I");
    static STRUCT_IF_C Ul_BFu32i_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_I");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_I");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_I, Ul_BFu32i_I)
//============================================================================



static void Test_Ul_BFu32i_Ip()
{
  {
    init_simple_test("Ul_BFu32i_Ip");
    static STRUCT_IF_C Ul_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_Ip");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_Ip, Ul_BFu32i_Ip)
//============================================================================



static void Test_Ul_BFu32i_L()
{
  {
    init_simple_test("Ul_BFu32i_L");
    static STRUCT_IF_C Ul_BFu32i_L lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_L");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_L");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_L, Ul_BFu32i_L)
//============================================================================



static void Test_Ul_BFu32i_S()
{
  {
    init_simple_test("Ul_BFu32i_S");
    static STRUCT_IF_C Ul_BFu32i_S lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_S");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_S");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_S, Ul_BFu32i_S)
//============================================================================



static void Test_Ul_BFu32i_Uc()
{
  {
    init_simple_test("Ul_BFu32i_Uc");
    static STRUCT_IF_C Ul_BFu32i_Uc lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_Uc");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_Uc, Ul_BFu32i_Uc)
//============================================================================



static void Test_Ul_BFu32i_Ui()
{
  {
    init_simple_test("Ul_BFu32i_Ui");
    static STRUCT_IF_C Ul_BFu32i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_Ui, Ul_BFu32i_Ui)
//============================================================================



static void Test_Ul_BFu32i_Ul()
{
  {
    init_simple_test("Ul_BFu32i_Ul");
    static STRUCT_IF_C Ul_BFu32i_Ul lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_Ul");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_Ul, Ul_BFu32i_Ul)
//============================================================================



static void Test_Ul_BFu32i_Us()
{
  {
    init_simple_test("Ul_BFu32i_Us");
    static STRUCT_IF_C Ul_BFu32i_Us lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_Us");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_Us");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_Us, Ul_BFu32i_Us)
//============================================================================



static void Test_Ul_BFu32i_Vp()
{
  {
    init_simple_test("Ul_BFu32i_Vp");
    static STRUCT_IF_C Ul_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32i_Vp");
    check_field_offset(lv, v3, 12, "Ul_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32i_Vp, Ul_BFu32i_Vp)
//============================================================================



static void Test_Ul_BFu32ll()
{
  {
    init_simple_test("Ul_BFu32ll");
    static STRUCT_IF_C Ul_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll, Ul_BFu32ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu15i");
    static STRUCT_IF_C Ul_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu15i, Ul_BFu32ll_BFu15i)
//============================================================================



static void Test_Ul_BFu32ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu15ll, Ul_BFu32ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu32ll_BFu15s");
    static STRUCT_IF_C Ul_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu15s, Ul_BFu32ll_BFu15s)
//============================================================================



static void Test_Ul_BFu32ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu16i");
    static STRUCT_IF_C Ul_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu16i, Ul_BFu32ll_BFu16i)
//============================================================================



static void Test_Ul_BFu32ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu16ll, Ul_BFu32ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu32ll_BFu16s");
    static STRUCT_IF_C Ul_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu16s, Ul_BFu32ll_BFu16s)
//============================================================================



static void Test_Ul_BFu32ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu17i");
    static STRUCT_IF_C Ul_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu17i, Ul_BFu32ll_BFu17i)
//============================================================================



static void Test_Ul_BFu32ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu17ll, Ul_BFu32ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu32ll_BFu1c");
    static STRUCT_IF_C Ul_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu1c, Ul_BFu32ll_BFu1c)
//============================================================================



static void Test_Ul_BFu32ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu1i");
    static STRUCT_IF_C Ul_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu1i, Ul_BFu32ll_BFu1i)
//============================================================================



static void Test_Ul_BFu32ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu1ll, Ul_BFu32ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu32ll_BFu1s");
    static STRUCT_IF_C Ul_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu1s, Ul_BFu32ll_BFu1s)
//============================================================================



static void Test_Ul_BFu32ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu31i");
    static STRUCT_IF_C Ul_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu31i, Ul_BFu32ll_BFu31i)
//============================================================================



static void Test_Ul_BFu32ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu31ll, Ul_BFu32ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu32i");
    static STRUCT_IF_C Ul_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu32i, Ul_BFu32ll_BFu32i)
//============================================================================



static void Test_Ul_BFu32ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu32ll, Ul_BFu32ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu33()
{
  {
    init_simple_test("Ul_BFu32ll_BFu33");
    static STRUCT_IF_C Ul_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "Ul_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "Ul_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu33, Ul_BFu32ll_BFu33)
//============================================================================



static void Test_Ul_BFu32ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu32ll_BFu7c");
    static STRUCT_IF_C Ul_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu7c, Ul_BFu32ll_BFu7c)
//============================================================================



static void Test_Ul_BFu32ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu7i");
    static STRUCT_IF_C Ul_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu7i, Ul_BFu32ll_BFu7i)
//============================================================================



static void Test_Ul_BFu32ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu7ll, Ul_BFu32ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu32ll_BFu7s");
    static STRUCT_IF_C Ul_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu7s, Ul_BFu32ll_BFu7s)
//============================================================================



static void Test_Ul_BFu32ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu32ll_BFu8c");
    static STRUCT_IF_C Ul_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu8c, Ul_BFu32ll_BFu8c)
//============================================================================



static void Test_Ul_BFu32ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu8i");
    static STRUCT_IF_C Ul_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu8i, Ul_BFu32ll_BFu8i)
//============================================================================



static void Test_Ul_BFu32ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu8ll, Ul_BFu32ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu32ll_BFu8s");
    static STRUCT_IF_C Ul_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu8s, Ul_BFu32ll_BFu8s)
//============================================================================



static void Test_Ul_BFu32ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu32ll_BFu9i");
    static STRUCT_IF_C Ul_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu9i, Ul_BFu32ll_BFu9i)
//============================================================================



static void Test_Ul_BFu32ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu32ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu9ll, Ul_BFu32ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu32ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu32ll_BFu9s");
    static STRUCT_IF_C Ul_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_BFu9s, Ul_BFu32ll_BFu9s)
//============================================================================



static void Test_Ul_BFu32ll_C()
{
  {
    init_simple_test("Ul_BFu32ll_C");
    static STRUCT_IF_C Ul_BFu32ll_C lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_C");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_C");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_C, Ul_BFu32ll_C)
//============================================================================



static void Test_Ul_BFu32ll_D()
{
  {
    init_simple_test("Ul_BFu32ll_D");
    static STRUCT_IF_C Ul_BFu32ll_D lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_D");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_D");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_D, Ul_BFu32ll_D)
//============================================================================



static void Test_Ul_BFu32ll_F()
{
  {
    init_simple_test("Ul_BFu32ll_F");
    static STRUCT_IF_C Ul_BFu32ll_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_F");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_F");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_F, Ul_BFu32ll_F)
//============================================================================



static void Test_Ul_BFu32ll_I()
{
  {
    init_simple_test("Ul_BFu32ll_I");
    static STRUCT_IF_C Ul_BFu32ll_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_I");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_I");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_I, Ul_BFu32ll_I)
//============================================================================



static void Test_Ul_BFu32ll_Ip()
{
  {
    init_simple_test("Ul_BFu32ll_Ip");
    static STRUCT_IF_C Ul_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_Ip");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_Ip, Ul_BFu32ll_Ip)
//============================================================================



static void Test_Ul_BFu32ll_L()
{
  {
    init_simple_test("Ul_BFu32ll_L");
    static STRUCT_IF_C Ul_BFu32ll_L lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_L");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_L");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_L, Ul_BFu32ll_L)
//============================================================================



static void Test_Ul_BFu32ll_S()
{
  {
    init_simple_test("Ul_BFu32ll_S");
    static STRUCT_IF_C Ul_BFu32ll_S lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_S");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_S");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_S, Ul_BFu32ll_S)
//============================================================================



static void Test_Ul_BFu32ll_Uc()
{
  {
    init_simple_test("Ul_BFu32ll_Uc");
    static STRUCT_IF_C Ul_BFu32ll_Uc lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_Uc");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_Uc, Ul_BFu32ll_Uc)
//============================================================================



static void Test_Ul_BFu32ll_Ui()
{
  {
    init_simple_test("Ul_BFu32ll_Ui");
    static STRUCT_IF_C Ul_BFu32ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_Ui, Ul_BFu32ll_Ui)
//============================================================================



static void Test_Ul_BFu32ll_Ul()
{
  {
    init_simple_test("Ul_BFu32ll_Ul");
    static STRUCT_IF_C Ul_BFu32ll_Ul lv;
    check2(sizeof(lv), 20, "sizeof(Ul_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_Ul");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_Ul, Ul_BFu32ll_Ul)
//============================================================================



static void Test_Ul_BFu32ll_Us()
{
  {
    init_simple_test("Ul_BFu32ll_Us");
    static STRUCT_IF_C Ul_BFu32ll_Us lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_Us");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_Us, Ul_BFu32ll_Us)
//============================================================================



static void Test_Ul_BFu32ll_Vp()
{
  {
    init_simple_test("Ul_BFu32ll_Vp");
    static STRUCT_IF_C Ul_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(Ul_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu32ll_Vp");
    check_field_offset(lv, v3, 12, "Ul_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu32ll_Vp, Ul_BFu32ll_Vp)
//============================================================================



static void Test_Ul_BFu33()
{
  {
    init_simple_test("Ul_BFu33");
    static STRUCT_IF_C Ul_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33, Ul_BFu33)
//============================================================================



static void Test_Ul_BFu33_BFu15i()
{
  {
    init_simple_test("Ul_BFu33_BFu15i");
    static STRUCT_IF_C Ul_BFu33_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 12, 1, 15, 1, "Ul_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 12, 1, 15, hide_ull(1LL<<14), "Ul_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu15i, Ul_BFu33_BFu15i)
//============================================================================



static void Test_Ul_BFu33_BFu15ll()
{
  {
    init_simple_test("Ul_BFu33_BFu15ll");
    static STRUCT_IF_C Ul_BFu33_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 12, 1, 15, 1, "Ul_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 12, 1, 15, hide_ull(1LL<<14), "Ul_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu15ll, Ul_BFu33_BFu15ll)
//============================================================================



static void Test_Ul_BFu33_BFu15s()
{
  {
    init_simple_test("Ul_BFu33_BFu15s");
    static STRUCT_IF_C Ul_BFu33_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 12, 1, 15, 1, "Ul_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 12, 1, 15, hide_ull(1LL<<14), "Ul_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu15s, Ul_BFu33_BFu15s)
//============================================================================



static void Test_Ul_BFu33_BFu16i()
{
  {
    init_simple_test("Ul_BFu33_BFu16i");
    static STRUCT_IF_C Ul_BFu33_BFu16i lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 12, 1, 16, 1, "Ul_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 12, 1, 16, hide_ull(1LL<<15), "Ul_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu16i, Ul_BFu33_BFu16i)
//============================================================================



static void Test_Ul_BFu33_BFu16ll()
{
  {
    init_simple_test("Ul_BFu33_BFu16ll");
    static STRUCT_IF_C Ul_BFu33_BFu16ll lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 12, 1, 16, 1, "Ul_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 12, 1, 16, hide_ull(1LL<<15), "Ul_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu16ll, Ul_BFu33_BFu16ll)
//============================================================================



static void Test_Ul_BFu33_BFu16s()
{
  {
    init_simple_test("Ul_BFu33_BFu16s");
    static STRUCT_IF_C Ul_BFu33_BFu16s lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 12, 1, 16, 1, "Ul_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 12, 1, 16, hide_ull(1LL<<15), "Ul_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu16s, Ul_BFu33_BFu16s)
//============================================================================



static void Test_Ul_BFu33_BFu17i()
{
  {
    init_simple_test("Ul_BFu33_BFu17i");
    static STRUCT_IF_C Ul_BFu33_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 12, 1, 17, 1, "Ul_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 12, 1, 17, hide_ull(1LL<<16), "Ul_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu17i, Ul_BFu33_BFu17i)
//============================================================================



static void Test_Ul_BFu33_BFu17ll()
{
  {
    init_simple_test("Ul_BFu33_BFu17ll");
    static STRUCT_IF_C Ul_BFu33_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 12, 1, 17, 1, "Ul_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 12, 1, 17, hide_ull(1LL<<16), "Ul_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu17ll, Ul_BFu33_BFu17ll)
//============================================================================



static void Test_Ul_BFu33_BFu1c()
{
  {
    init_simple_test("Ul_BFu33_BFu1c");
    static STRUCT_IF_C Ul_BFu33_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "Ul_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu1c, Ul_BFu33_BFu1c)
//============================================================================



static void Test_Ul_BFu33_BFu1i()
{
  {
    init_simple_test("Ul_BFu33_BFu1i");
    static STRUCT_IF_C Ul_BFu33_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "Ul_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu1i, Ul_BFu33_BFu1i)
//============================================================================



static void Test_Ul_BFu33_BFu1ll()
{
  {
    init_simple_test("Ul_BFu33_BFu1ll");
    static STRUCT_IF_C Ul_BFu33_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "Ul_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu1ll, Ul_BFu33_BFu1ll)
//============================================================================



static void Test_Ul_BFu33_BFu1s()
{
  {
    init_simple_test("Ul_BFu33_BFu1s");
    static STRUCT_IF_C Ul_BFu33_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "Ul_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu1s, Ul_BFu33_BFu1s)
//============================================================================



static void Test_Ul_BFu33_BFu31i()
{
  {
    init_simple_test("Ul_BFu33_BFu31i");
    static STRUCT_IF_C Ul_BFu33_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 12, 1, 31, 1, "Ul_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 12, 1, 31, hide_ull(1LL<<30), "Ul_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu31i, Ul_BFu33_BFu31i)
//============================================================================



static void Test_Ul_BFu33_BFu31ll()
{
  {
    init_simple_test("Ul_BFu33_BFu31ll");
    static STRUCT_IF_C Ul_BFu33_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 12, 1, 31, 1, "Ul_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 12, 1, 31, hide_ull(1LL<<30), "Ul_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu31ll, Ul_BFu33_BFu31ll)
//============================================================================



static void Test_Ul_BFu33_BFu32i()
{
  {
    init_simple_test("Ul_BFu33_BFu32i");
    static STRUCT_IF_C Ul_BFu33_BFu32i lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 12, 1, 32, 1, "Ul_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 12, 1, 32, hide_ull(1LL<<31), "Ul_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu32i, Ul_BFu33_BFu32i)
//============================================================================



static void Test_Ul_BFu33_BFu32ll()
{
  {
    init_simple_test("Ul_BFu33_BFu32ll");
    static STRUCT_IF_C Ul_BFu33_BFu32ll lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 12, 1, 32, 1, "Ul_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 12, 1, 32, hide_ull(1LL<<31), "Ul_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu32ll, Ul_BFu33_BFu32ll)
//============================================================================



static void Test_Ul_BFu33_BFu33()
{
  {
    init_simple_test("Ul_BFu33_BFu33");
    static STRUCT_IF_C Ul_BFu33_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu33");
    set_bf_and_test(lv, v3, 12, 1, 33, 1, "Ul_BFu33_BFu33");
    set_bf_and_test(lv, v3, 12, 1, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu33, Ul_BFu33_BFu33)
//============================================================================



static void Test_Ul_BFu33_BFu7c()
{
  {
    init_simple_test("Ul_BFu33_BFu7c");
    static STRUCT_IF_C Ul_BFu33_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "Ul_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "Ul_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu7c, Ul_BFu33_BFu7c)
//============================================================================



static void Test_Ul_BFu33_BFu7i()
{
  {
    init_simple_test("Ul_BFu33_BFu7i");
    static STRUCT_IF_C Ul_BFu33_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "Ul_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "Ul_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu7i, Ul_BFu33_BFu7i)
//============================================================================



static void Test_Ul_BFu33_BFu7ll()
{
  {
    init_simple_test("Ul_BFu33_BFu7ll");
    static STRUCT_IF_C Ul_BFu33_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "Ul_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "Ul_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu7ll, Ul_BFu33_BFu7ll)
//============================================================================



static void Test_Ul_BFu33_BFu7s()
{
  {
    init_simple_test("Ul_BFu33_BFu7s");
    static STRUCT_IF_C Ul_BFu33_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "Ul_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "Ul_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu7s, Ul_BFu33_BFu7s)
//============================================================================



static void Test_Ul_BFu33_BFu8c()
{
  {
    init_simple_test("Ul_BFu33_BFu8c");
    static STRUCT_IF_C Ul_BFu33_BFu8c lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "Ul_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "Ul_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu8c, Ul_BFu33_BFu8c)
//============================================================================



static void Test_Ul_BFu33_BFu8i()
{
  {
    init_simple_test("Ul_BFu33_BFu8i");
    static STRUCT_IF_C Ul_BFu33_BFu8i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "Ul_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "Ul_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu8i, Ul_BFu33_BFu8i)
//============================================================================



static void Test_Ul_BFu33_BFu8ll()
{
  {
    init_simple_test("Ul_BFu33_BFu8ll");
    static STRUCT_IF_C Ul_BFu33_BFu8ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "Ul_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "Ul_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu8ll, Ul_BFu33_BFu8ll)
//============================================================================



static void Test_Ul_BFu33_BFu8s()
{
  {
    init_simple_test("Ul_BFu33_BFu8s");
    static STRUCT_IF_C Ul_BFu33_BFu8s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "Ul_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "Ul_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu8s, Ul_BFu33_BFu8s)
//============================================================================



static void Test_Ul_BFu33_BFu9i()
{
  {
    init_simple_test("Ul_BFu33_BFu9i");
    static STRUCT_IF_C Ul_BFu33_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 12, 1, 9, 1, "Ul_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 12, 1, 9, hide_ull(1LL<<8), "Ul_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu9i, Ul_BFu33_BFu9i)
//============================================================================



static void Test_Ul_BFu33_BFu9ll()
{
  {
    init_simple_test("Ul_BFu33_BFu9ll");
    static STRUCT_IF_C Ul_BFu33_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 12, 1, 9, 1, "Ul_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 12, 1, 9, hide_ull(1LL<<8), "Ul_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu9ll, Ul_BFu33_BFu9ll)
//============================================================================



static void Test_Ul_BFu33_BFu9s()
{
  {
    init_simple_test("Ul_BFu33_BFu9s");
    static STRUCT_IF_C Ul_BFu33_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 12, 1, 9, 1, "Ul_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 12, 1, 9, hide_ull(1LL<<8), "Ul_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_BFu9s, Ul_BFu33_BFu9s)
//============================================================================



static void Test_Ul_BFu33_C()
{
  {
    init_simple_test("Ul_BFu33_C");
    static STRUCT_IF_C Ul_BFu33_C lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_C");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_C");
    check_field_offset(lv, v3, 13, "Ul_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_C, Ul_BFu33_C)
//============================================================================



static void Test_Ul_BFu33_D()
{
  {
    init_simple_test("Ul_BFu33_D");
    static STRUCT_IF_C Ul_BFu33_D lv;
    check2(sizeof(lv), 21, "sizeof(Ul_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_D");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_D");
    check_field_offset(lv, v3, 13, "Ul_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_D, Ul_BFu33_D)
//============================================================================



static void Test_Ul_BFu33_F()
{
  {
    init_simple_test("Ul_BFu33_F");
    static STRUCT_IF_C Ul_BFu33_F lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_F");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_F");
    check_field_offset(lv, v3, 13, "Ul_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_F, Ul_BFu33_F)
//============================================================================



static void Test_Ul_BFu33_I()
{
  {
    init_simple_test("Ul_BFu33_I");
    static STRUCT_IF_C Ul_BFu33_I lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_I");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_I");
    check_field_offset(lv, v3, 13, "Ul_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_I, Ul_BFu33_I)
//============================================================================



static void Test_Ul_BFu33_Ip()
{
  {
    init_simple_test("Ul_BFu33_Ip");
    static STRUCT_IF_C Ul_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(Ul_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_Ip");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_Ip");
    check_field_offset(lv, v3, 13, "Ul_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_Ip, Ul_BFu33_Ip)
//============================================================================



static void Test_Ul_BFu33_L()
{
  {
    init_simple_test("Ul_BFu33_L");
    static STRUCT_IF_C Ul_BFu33_L lv;
    check2(sizeof(lv), 21, "sizeof(Ul_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_L");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_L");
    check_field_offset(lv, v3, 13, "Ul_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_L, Ul_BFu33_L)
//============================================================================



static void Test_Ul_BFu33_S()
{
  {
    init_simple_test("Ul_BFu33_S");
    static STRUCT_IF_C Ul_BFu33_S lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_S");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_S");
    check_field_offset(lv, v3, 13, "Ul_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_S, Ul_BFu33_S)
//============================================================================



static void Test_Ul_BFu33_Uc()
{
  {
    init_simple_test("Ul_BFu33_Uc");
    static STRUCT_IF_C Ul_BFu33_Uc lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_Uc");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_Uc");
    check_field_offset(lv, v3, 13, "Ul_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_Uc, Ul_BFu33_Uc)
//============================================================================



static void Test_Ul_BFu33_Ui()
{
  {
    init_simple_test("Ul_BFu33_Ui");
    static STRUCT_IF_C Ul_BFu33_Ui lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_Ui");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_Ui");
    check_field_offset(lv, v3, 13, "Ul_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_Ui, Ul_BFu33_Ui)
//============================================================================



static void Test_Ul_BFu33_Ul()
{
  {
    init_simple_test("Ul_BFu33_Ul");
    static STRUCT_IF_C Ul_BFu33_Ul lv;
    check2(sizeof(lv), 21, "sizeof(Ul_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_Ul");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_Ul");
    check_field_offset(lv, v3, 13, "Ul_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_Ul, Ul_BFu33_Ul)
//============================================================================



static void Test_Ul_BFu33_Us()
{
  {
    init_simple_test("Ul_BFu33_Us");
    static STRUCT_IF_C Ul_BFu33_Us lv;
    check2(sizeof(lv), 15, "sizeof(Ul_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_Us");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_Us");
    check_field_offset(lv, v3, 13, "Ul_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_Us, Ul_BFu33_Us)
//============================================================================



static void Test_Ul_BFu33_Vp()
{
  {
    init_simple_test("Ul_BFu33_Vp");
    static STRUCT_IF_C Ul_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(Ul_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu33_Vp");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu33_Vp");
    check_field_offset(lv, v3, 13, "Ul_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu33_Vp, Ul_BFu33_Vp)
//============================================================================



static void Test_Ul_BFu7c()
{
  {
    init_simple_test("Ul_BFu7c");
    static STRUCT_IF_C Ul_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c, Ul_BFu7c)
//============================================================================



static void Test_Ul_BFu7c_BFu15i()
{
  {
    init_simple_test("Ul_BFu7c_BFu15i");
    static STRUCT_IF_C Ul_BFu7c_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu15i, Ul_BFu7c_BFu15i)
//============================================================================



static void Test_Ul_BFu7c_BFu15ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu15ll");
    static STRUCT_IF_C Ul_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu15ll, Ul_BFu7c_BFu15ll)
//============================================================================



static void Test_Ul_BFu7c_BFu15s()
{
  {
    init_simple_test("Ul_BFu7c_BFu15s");
    static STRUCT_IF_C Ul_BFu7c_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu15s, Ul_BFu7c_BFu15s)
//============================================================================



static void Test_Ul_BFu7c_BFu16i()
{
  {
    init_simple_test("Ul_BFu7c_BFu16i");
    static STRUCT_IF_C Ul_BFu7c_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu16i, Ul_BFu7c_BFu16i)
//============================================================================



static void Test_Ul_BFu7c_BFu16ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu16ll");
    static STRUCT_IF_C Ul_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu16ll, Ul_BFu7c_BFu16ll)
//============================================================================



static void Test_Ul_BFu7c_BFu16s()
{
  {
    init_simple_test("Ul_BFu7c_BFu16s");
    static STRUCT_IF_C Ul_BFu7c_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu16s, Ul_BFu7c_BFu16s)
//============================================================================



static void Test_Ul_BFu7c_BFu17i()
{
  {
    init_simple_test("Ul_BFu7c_BFu17i");
    static STRUCT_IF_C Ul_BFu7c_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu17i, Ul_BFu7c_BFu17i)
//============================================================================



static void Test_Ul_BFu7c_BFu17ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu17ll");
    static STRUCT_IF_C Ul_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu17ll, Ul_BFu7c_BFu17ll)
//============================================================================



static void Test_Ul_BFu7c_BFu1c()
{
  {
    init_simple_test("Ul_BFu7c_BFu1c");
    static STRUCT_IF_C Ul_BFu7c_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu1c, Ul_BFu7c_BFu1c)
//============================================================================



static void Test_Ul_BFu7c_BFu1i()
{
  {
    init_simple_test("Ul_BFu7c_BFu1i");
    static STRUCT_IF_C Ul_BFu7c_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu1i, Ul_BFu7c_BFu1i)
//============================================================================



static void Test_Ul_BFu7c_BFu1ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu1ll");
    static STRUCT_IF_C Ul_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu1ll, Ul_BFu7c_BFu1ll)
//============================================================================



static void Test_Ul_BFu7c_BFu1s()
{
  {
    init_simple_test("Ul_BFu7c_BFu1s");
    static STRUCT_IF_C Ul_BFu7c_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu1s, Ul_BFu7c_BFu1s)
//============================================================================



static void Test_Ul_BFu7c_BFu31i()
{
  {
    init_simple_test("Ul_BFu7c_BFu31i");
    static STRUCT_IF_C Ul_BFu7c_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu31i, Ul_BFu7c_BFu31i)
//============================================================================



static void Test_Ul_BFu7c_BFu31ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu31ll");
    static STRUCT_IF_C Ul_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu31ll, Ul_BFu7c_BFu31ll)
//============================================================================



static void Test_Ul_BFu7c_BFu32i()
{
  {
    init_simple_test("Ul_BFu7c_BFu32i");
    static STRUCT_IF_C Ul_BFu7c_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu32i, Ul_BFu7c_BFu32i)
//============================================================================



static void Test_Ul_BFu7c_BFu32ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu32ll");
    static STRUCT_IF_C Ul_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu32ll, Ul_BFu7c_BFu32ll)
//============================================================================



static void Test_Ul_BFu7c_BFu33()
{
  {
    init_simple_test("Ul_BFu7c_BFu33");
    static STRUCT_IF_C Ul_BFu7c_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "Ul_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "Ul_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu33, Ul_BFu7c_BFu33)
//============================================================================



static void Test_Ul_BFu7c_BFu7c()
{
  {
    init_simple_test("Ul_BFu7c_BFu7c");
    static STRUCT_IF_C Ul_BFu7c_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu7c, Ul_BFu7c_BFu7c)
//============================================================================



static void Test_Ul_BFu7c_BFu7i()
{
  {
    init_simple_test("Ul_BFu7c_BFu7i");
    static STRUCT_IF_C Ul_BFu7c_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu7i, Ul_BFu7c_BFu7i)
//============================================================================



static void Test_Ul_BFu7c_BFu7ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu7ll");
    static STRUCT_IF_C Ul_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu7ll, Ul_BFu7c_BFu7ll)
//============================================================================



static void Test_Ul_BFu7c_BFu7s()
{
  {
    init_simple_test("Ul_BFu7c_BFu7s");
    static STRUCT_IF_C Ul_BFu7c_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu7s, Ul_BFu7c_BFu7s)
//============================================================================



static void Test_Ul_BFu7c_BFu8c()
{
  {
    init_simple_test("Ul_BFu7c_BFu8c");
    static STRUCT_IF_C Ul_BFu7c_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu8c, Ul_BFu7c_BFu8c)
//============================================================================



static void Test_Ul_BFu7c_BFu8i()
{
  {
    init_simple_test("Ul_BFu7c_BFu8i");
    static STRUCT_IF_C Ul_BFu7c_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu8i, Ul_BFu7c_BFu8i)
//============================================================================



static void Test_Ul_BFu7c_BFu8ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu8ll");
    static STRUCT_IF_C Ul_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu8ll, Ul_BFu7c_BFu8ll)
//============================================================================



static void Test_Ul_BFu7c_BFu8s()
{
  {
    init_simple_test("Ul_BFu7c_BFu8s");
    static STRUCT_IF_C Ul_BFu7c_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu8s, Ul_BFu7c_BFu8s)
//============================================================================



static void Test_Ul_BFu7c_BFu9i()
{
  {
    init_simple_test("Ul_BFu7c_BFu9i");
    static STRUCT_IF_C Ul_BFu7c_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu9i, Ul_BFu7c_BFu9i)
//============================================================================



static void Test_Ul_BFu7c_BFu9ll()
{
  {
    init_simple_test("Ul_BFu7c_BFu9ll");
    static STRUCT_IF_C Ul_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu9ll, Ul_BFu7c_BFu9ll)
//============================================================================



static void Test_Ul_BFu7c_BFu9s()
{
  {
    init_simple_test("Ul_BFu7c_BFu9s");
    static STRUCT_IF_C Ul_BFu7c_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_BFu9s, Ul_BFu7c_BFu9s)
//============================================================================



static void Test_Ul_BFu7c_C()
{
  {
    init_simple_test("Ul_BFu7c_C");
    static STRUCT_IF_C Ul_BFu7c_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_C");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_C, Ul_BFu7c_C)
//============================================================================



static void Test_Ul_BFu7c_D()
{
  {
    init_simple_test("Ul_BFu7c_D");
    static STRUCT_IF_C Ul_BFu7c_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_D");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_D, Ul_BFu7c_D)
//============================================================================



static void Test_Ul_BFu7c_F()
{
  {
    init_simple_test("Ul_BFu7c_F");
    static STRUCT_IF_C Ul_BFu7c_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_F");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_F, Ul_BFu7c_F)
//============================================================================



static void Test_Ul_BFu7c_I()
{
  {
    init_simple_test("Ul_BFu7c_I");
    static STRUCT_IF_C Ul_BFu7c_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_I");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_I, Ul_BFu7c_I)
//============================================================================



static void Test_Ul_BFu7c_Ip()
{
  {
    init_simple_test("Ul_BFu7c_Ip");
    static STRUCT_IF_C Ul_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_Ip, Ul_BFu7c_Ip)
//============================================================================



static void Test_Ul_BFu7c_L()
{
  {
    init_simple_test("Ul_BFu7c_L");
    static STRUCT_IF_C Ul_BFu7c_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_L");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_L, Ul_BFu7c_L)
//============================================================================



static void Test_Ul_BFu7c_S()
{
  {
    init_simple_test("Ul_BFu7c_S");
    static STRUCT_IF_C Ul_BFu7c_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_S");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_S, Ul_BFu7c_S)
//============================================================================



static void Test_Ul_BFu7c_Uc()
{
  {
    init_simple_test("Ul_BFu7c_Uc");
    static STRUCT_IF_C Ul_BFu7c_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_Uc, Ul_BFu7c_Uc)
//============================================================================



static void Test_Ul_BFu7c_Ui()
{
  {
    init_simple_test("Ul_BFu7c_Ui");
    static STRUCT_IF_C Ul_BFu7c_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_Ui, Ul_BFu7c_Ui)
//============================================================================



static void Test_Ul_BFu7c_Ul()
{
  {
    init_simple_test("Ul_BFu7c_Ul");
    static STRUCT_IF_C Ul_BFu7c_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_Ul, Ul_BFu7c_Ul)
//============================================================================



static void Test_Ul_BFu7c_Us()
{
  {
    init_simple_test("Ul_BFu7c_Us");
    static STRUCT_IF_C Ul_BFu7c_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_Us, Ul_BFu7c_Us)
//============================================================================



static void Test_Ul_BFu7c_Vp()
{
  {
    init_simple_test("Ul_BFu7c_Vp");
    static STRUCT_IF_C Ul_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7c_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7c_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7c_Vp, Ul_BFu7c_Vp)
//============================================================================



static void Test_Ul_BFu7i()
{
  {
    init_simple_test("Ul_BFu7i");
    static STRUCT_IF_C Ul_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i, Ul_BFu7i)
//============================================================================



static void Test_Ul_BFu7i_BFu15i()
{
  {
    init_simple_test("Ul_BFu7i_BFu15i");
    static STRUCT_IF_C Ul_BFu7i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu15i, Ul_BFu7i_BFu15i)
//============================================================================



static void Test_Ul_BFu7i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu15ll");
    static STRUCT_IF_C Ul_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu15ll, Ul_BFu7i_BFu15ll)
//============================================================================



static void Test_Ul_BFu7i_BFu15s()
{
  {
    init_simple_test("Ul_BFu7i_BFu15s");
    static STRUCT_IF_C Ul_BFu7i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu15s, Ul_BFu7i_BFu15s)
//============================================================================



static void Test_Ul_BFu7i_BFu16i()
{
  {
    init_simple_test("Ul_BFu7i_BFu16i");
    static STRUCT_IF_C Ul_BFu7i_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu16i, Ul_BFu7i_BFu16i)
//============================================================================



static void Test_Ul_BFu7i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu16ll");
    static STRUCT_IF_C Ul_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu16ll, Ul_BFu7i_BFu16ll)
//============================================================================



static void Test_Ul_BFu7i_BFu16s()
{
  {
    init_simple_test("Ul_BFu7i_BFu16s");
    static STRUCT_IF_C Ul_BFu7i_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu16s, Ul_BFu7i_BFu16s)
//============================================================================



static void Test_Ul_BFu7i_BFu17i()
{
  {
    init_simple_test("Ul_BFu7i_BFu17i");
    static STRUCT_IF_C Ul_BFu7i_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu17i, Ul_BFu7i_BFu17i)
//============================================================================



static void Test_Ul_BFu7i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu17ll");
    static STRUCT_IF_C Ul_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu17ll, Ul_BFu7i_BFu17ll)
//============================================================================



static void Test_Ul_BFu7i_BFu1c()
{
  {
    init_simple_test("Ul_BFu7i_BFu1c");
    static STRUCT_IF_C Ul_BFu7i_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu1c, Ul_BFu7i_BFu1c)
//============================================================================



static void Test_Ul_BFu7i_BFu1i()
{
  {
    init_simple_test("Ul_BFu7i_BFu1i");
    static STRUCT_IF_C Ul_BFu7i_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu1i, Ul_BFu7i_BFu1i)
//============================================================================



static void Test_Ul_BFu7i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu1ll");
    static STRUCT_IF_C Ul_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu1ll, Ul_BFu7i_BFu1ll)
//============================================================================



static void Test_Ul_BFu7i_BFu1s()
{
  {
    init_simple_test("Ul_BFu7i_BFu1s");
    static STRUCT_IF_C Ul_BFu7i_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu1s, Ul_BFu7i_BFu1s)
//============================================================================



static void Test_Ul_BFu7i_BFu31i()
{
  {
    init_simple_test("Ul_BFu7i_BFu31i");
    static STRUCT_IF_C Ul_BFu7i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu31i, Ul_BFu7i_BFu31i)
//============================================================================



static void Test_Ul_BFu7i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu31ll");
    static STRUCT_IF_C Ul_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu31ll, Ul_BFu7i_BFu31ll)
//============================================================================



static void Test_Ul_BFu7i_BFu32i()
{
  {
    init_simple_test("Ul_BFu7i_BFu32i");
    static STRUCT_IF_C Ul_BFu7i_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu32i, Ul_BFu7i_BFu32i)
//============================================================================



static void Test_Ul_BFu7i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu32ll");
    static STRUCT_IF_C Ul_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu32ll, Ul_BFu7i_BFu32ll)
//============================================================================



static void Test_Ul_BFu7i_BFu33()
{
  {
    init_simple_test("Ul_BFu7i_BFu33");
    static STRUCT_IF_C Ul_BFu7i_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "Ul_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "Ul_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu33, Ul_BFu7i_BFu33)
//============================================================================



static void Test_Ul_BFu7i_BFu7c()
{
  {
    init_simple_test("Ul_BFu7i_BFu7c");
    static STRUCT_IF_C Ul_BFu7i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu7c, Ul_BFu7i_BFu7c)
//============================================================================



static void Test_Ul_BFu7i_BFu7i()
{
  {
    init_simple_test("Ul_BFu7i_BFu7i");
    static STRUCT_IF_C Ul_BFu7i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu7i, Ul_BFu7i_BFu7i)
//============================================================================



static void Test_Ul_BFu7i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu7ll");
    static STRUCT_IF_C Ul_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu7ll, Ul_BFu7i_BFu7ll)
//============================================================================



static void Test_Ul_BFu7i_BFu7s()
{
  {
    init_simple_test("Ul_BFu7i_BFu7s");
    static STRUCT_IF_C Ul_BFu7i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu7s, Ul_BFu7i_BFu7s)
//============================================================================



static void Test_Ul_BFu7i_BFu8c()
{
  {
    init_simple_test("Ul_BFu7i_BFu8c");
    static STRUCT_IF_C Ul_BFu7i_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu8c, Ul_BFu7i_BFu8c)
//============================================================================



static void Test_Ul_BFu7i_BFu8i()
{
  {
    init_simple_test("Ul_BFu7i_BFu8i");
    static STRUCT_IF_C Ul_BFu7i_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu8i, Ul_BFu7i_BFu8i)
//============================================================================



static void Test_Ul_BFu7i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu8ll");
    static STRUCT_IF_C Ul_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu8ll, Ul_BFu7i_BFu8ll)
//============================================================================



static void Test_Ul_BFu7i_BFu8s()
{
  {
    init_simple_test("Ul_BFu7i_BFu8s");
    static STRUCT_IF_C Ul_BFu7i_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu8s, Ul_BFu7i_BFu8s)
//============================================================================



static void Test_Ul_BFu7i_BFu9i()
{
  {
    init_simple_test("Ul_BFu7i_BFu9i");
    static STRUCT_IF_C Ul_BFu7i_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu9i, Ul_BFu7i_BFu9i)
//============================================================================



static void Test_Ul_BFu7i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu7i_BFu9ll");
    static STRUCT_IF_C Ul_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu9ll, Ul_BFu7i_BFu9ll)
//============================================================================



static void Test_Ul_BFu7i_BFu9s()
{
  {
    init_simple_test("Ul_BFu7i_BFu9s");
    static STRUCT_IF_C Ul_BFu7i_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_BFu9s, Ul_BFu7i_BFu9s)
//============================================================================



static void Test_Ul_BFu7i_C()
{
  {
    init_simple_test("Ul_BFu7i_C");
    static STRUCT_IF_C Ul_BFu7i_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_C");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_C, Ul_BFu7i_C)
//============================================================================



static void Test_Ul_BFu7i_D()
{
  {
    init_simple_test("Ul_BFu7i_D");
    static STRUCT_IF_C Ul_BFu7i_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_D");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_D, Ul_BFu7i_D)
//============================================================================



static void Test_Ul_BFu7i_F()
{
  {
    init_simple_test("Ul_BFu7i_F");
    static STRUCT_IF_C Ul_BFu7i_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_F");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_F, Ul_BFu7i_F)
//============================================================================



static void Test_Ul_BFu7i_I()
{
  {
    init_simple_test("Ul_BFu7i_I");
    static STRUCT_IF_C Ul_BFu7i_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_I");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_I, Ul_BFu7i_I)
//============================================================================



static void Test_Ul_BFu7i_Ip()
{
  {
    init_simple_test("Ul_BFu7i_Ip");
    static STRUCT_IF_C Ul_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_Ip, Ul_BFu7i_Ip)
//============================================================================



static void Test_Ul_BFu7i_L()
{
  {
    init_simple_test("Ul_BFu7i_L");
    static STRUCT_IF_C Ul_BFu7i_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_L");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_L, Ul_BFu7i_L)
//============================================================================



static void Test_Ul_BFu7i_S()
{
  {
    init_simple_test("Ul_BFu7i_S");
    static STRUCT_IF_C Ul_BFu7i_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_S");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_S, Ul_BFu7i_S)
//============================================================================



static void Test_Ul_BFu7i_Uc()
{
  {
    init_simple_test("Ul_BFu7i_Uc");
    static STRUCT_IF_C Ul_BFu7i_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_Uc, Ul_BFu7i_Uc)
//============================================================================



static void Test_Ul_BFu7i_Ui()
{
  {
    init_simple_test("Ul_BFu7i_Ui");
    static STRUCT_IF_C Ul_BFu7i_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_Ui, Ul_BFu7i_Ui)
//============================================================================



static void Test_Ul_BFu7i_Ul()
{
  {
    init_simple_test("Ul_BFu7i_Ul");
    static STRUCT_IF_C Ul_BFu7i_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_Ul, Ul_BFu7i_Ul)
//============================================================================



static void Test_Ul_BFu7i_Us()
{
  {
    init_simple_test("Ul_BFu7i_Us");
    static STRUCT_IF_C Ul_BFu7i_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_Us, Ul_BFu7i_Us)
//============================================================================



static void Test_Ul_BFu7i_Vp()
{
  {
    init_simple_test("Ul_BFu7i_Vp");
    static STRUCT_IF_C Ul_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7i_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7i_Vp, Ul_BFu7i_Vp)
//============================================================================



static void Test_Ul_BFu7ll()
{
  {
    init_simple_test("Ul_BFu7ll");
    static STRUCT_IF_C Ul_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll, Ul_BFu7ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu15i");
    static STRUCT_IF_C Ul_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu15i, Ul_BFu7ll_BFu15i)
//============================================================================



static void Test_Ul_BFu7ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu15ll, Ul_BFu7ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu7ll_BFu15s");
    static STRUCT_IF_C Ul_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu15s, Ul_BFu7ll_BFu15s)
//============================================================================



static void Test_Ul_BFu7ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu16i");
    static STRUCT_IF_C Ul_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu16i, Ul_BFu7ll_BFu16i)
//============================================================================



static void Test_Ul_BFu7ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu16ll, Ul_BFu7ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu7ll_BFu16s");
    static STRUCT_IF_C Ul_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu16s, Ul_BFu7ll_BFu16s)
//============================================================================



static void Test_Ul_BFu7ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu17i");
    static STRUCT_IF_C Ul_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu17i, Ul_BFu7ll_BFu17i)
//============================================================================



static void Test_Ul_BFu7ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu17ll, Ul_BFu7ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu7ll_BFu1c");
    static STRUCT_IF_C Ul_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu1c, Ul_BFu7ll_BFu1c)
//============================================================================



static void Test_Ul_BFu7ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu1i");
    static STRUCT_IF_C Ul_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu1i, Ul_BFu7ll_BFu1i)
//============================================================================



static void Test_Ul_BFu7ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu1ll, Ul_BFu7ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu7ll_BFu1s");
    static STRUCT_IF_C Ul_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu1s, Ul_BFu7ll_BFu1s)
//============================================================================



static void Test_Ul_BFu7ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu31i");
    static STRUCT_IF_C Ul_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu31i, Ul_BFu7ll_BFu31i)
//============================================================================



static void Test_Ul_BFu7ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu31ll, Ul_BFu7ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu32i");
    static STRUCT_IF_C Ul_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu32i, Ul_BFu7ll_BFu32i)
//============================================================================



static void Test_Ul_BFu7ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu32ll, Ul_BFu7ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu33()
{
  {
    init_simple_test("Ul_BFu7ll_BFu33");
    static STRUCT_IF_C Ul_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "Ul_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "Ul_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu33, Ul_BFu7ll_BFu33)
//============================================================================



static void Test_Ul_BFu7ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu7ll_BFu7c");
    static STRUCT_IF_C Ul_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu7c, Ul_BFu7ll_BFu7c)
//============================================================================



static void Test_Ul_BFu7ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu7i");
    static STRUCT_IF_C Ul_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu7i, Ul_BFu7ll_BFu7i)
//============================================================================



static void Test_Ul_BFu7ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu7ll, Ul_BFu7ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu7ll_BFu7s");
    static STRUCT_IF_C Ul_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu7s, Ul_BFu7ll_BFu7s)
//============================================================================



static void Test_Ul_BFu7ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu7ll_BFu8c");
    static STRUCT_IF_C Ul_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu8c, Ul_BFu7ll_BFu8c)
//============================================================================



static void Test_Ul_BFu7ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu8i");
    static STRUCT_IF_C Ul_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu8i, Ul_BFu7ll_BFu8i)
//============================================================================



static void Test_Ul_BFu7ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu8ll, Ul_BFu7ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu7ll_BFu8s");
    static STRUCT_IF_C Ul_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu8s, Ul_BFu7ll_BFu8s)
//============================================================================



static void Test_Ul_BFu7ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu7ll_BFu9i");
    static STRUCT_IF_C Ul_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu9i, Ul_BFu7ll_BFu9i)
//============================================================================



static void Test_Ul_BFu7ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu7ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu9ll, Ul_BFu7ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu7ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu7ll_BFu9s");
    static STRUCT_IF_C Ul_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_BFu9s, Ul_BFu7ll_BFu9s)
//============================================================================



static void Test_Ul_BFu7ll_C()
{
  {
    init_simple_test("Ul_BFu7ll_C");
    static STRUCT_IF_C Ul_BFu7ll_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_C");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_C, Ul_BFu7ll_C)
//============================================================================



static void Test_Ul_BFu7ll_D()
{
  {
    init_simple_test("Ul_BFu7ll_D");
    static STRUCT_IF_C Ul_BFu7ll_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_D");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_D, Ul_BFu7ll_D)
//============================================================================



static void Test_Ul_BFu7ll_F()
{
  {
    init_simple_test("Ul_BFu7ll_F");
    static STRUCT_IF_C Ul_BFu7ll_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_F");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_F, Ul_BFu7ll_F)
//============================================================================



static void Test_Ul_BFu7ll_I()
{
  {
    init_simple_test("Ul_BFu7ll_I");
    static STRUCT_IF_C Ul_BFu7ll_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_I");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_I, Ul_BFu7ll_I)
//============================================================================



static void Test_Ul_BFu7ll_Ip()
{
  {
    init_simple_test("Ul_BFu7ll_Ip");
    static STRUCT_IF_C Ul_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_Ip, Ul_BFu7ll_Ip)
//============================================================================



static void Test_Ul_BFu7ll_L()
{
  {
    init_simple_test("Ul_BFu7ll_L");
    static STRUCT_IF_C Ul_BFu7ll_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_L");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_L, Ul_BFu7ll_L)
//============================================================================



static void Test_Ul_BFu7ll_S()
{
  {
    init_simple_test("Ul_BFu7ll_S");
    static STRUCT_IF_C Ul_BFu7ll_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_S");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_S, Ul_BFu7ll_S)
//============================================================================



static void Test_Ul_BFu7ll_Uc()
{
  {
    init_simple_test("Ul_BFu7ll_Uc");
    static STRUCT_IF_C Ul_BFu7ll_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_Uc, Ul_BFu7ll_Uc)
//============================================================================



static void Test_Ul_BFu7ll_Ui()
{
  {
    init_simple_test("Ul_BFu7ll_Ui");
    static STRUCT_IF_C Ul_BFu7ll_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_Ui, Ul_BFu7ll_Ui)
//============================================================================



static void Test_Ul_BFu7ll_Ul()
{
  {
    init_simple_test("Ul_BFu7ll_Ul");
    static STRUCT_IF_C Ul_BFu7ll_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_Ul, Ul_BFu7ll_Ul)
//============================================================================



static void Test_Ul_BFu7ll_Us()
{
  {
    init_simple_test("Ul_BFu7ll_Us");
    static STRUCT_IF_C Ul_BFu7ll_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_Us, Ul_BFu7ll_Us)
//============================================================================



static void Test_Ul_BFu7ll_Vp()
{
  {
    init_simple_test("Ul_BFu7ll_Vp");
    static STRUCT_IF_C Ul_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7ll_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7ll_Vp, Ul_BFu7ll_Vp)
//============================================================================



static void Test_Ul_BFu7s()
{
  {
    init_simple_test("Ul_BFu7s");
    static STRUCT_IF_C Ul_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s, Ul_BFu7s)
//============================================================================



static void Test_Ul_BFu7s_BFu15i()
{
  {
    init_simple_test("Ul_BFu7s_BFu15i");
    static STRUCT_IF_C Ul_BFu7s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu15i, Ul_BFu7s_BFu15i)
//============================================================================



static void Test_Ul_BFu7s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu15ll");
    static STRUCT_IF_C Ul_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu15ll, Ul_BFu7s_BFu15ll)
//============================================================================



static void Test_Ul_BFu7s_BFu15s()
{
  {
    init_simple_test("Ul_BFu7s_BFu15s");
    static STRUCT_IF_C Ul_BFu7s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "Ul_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "Ul_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu15s, Ul_BFu7s_BFu15s)
//============================================================================



static void Test_Ul_BFu7s_BFu16i()
{
  {
    init_simple_test("Ul_BFu7s_BFu16i");
    static STRUCT_IF_C Ul_BFu7s_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu16i, Ul_BFu7s_BFu16i)
//============================================================================



static void Test_Ul_BFu7s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu16ll");
    static STRUCT_IF_C Ul_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu16ll, Ul_BFu7s_BFu16ll)
//============================================================================



static void Test_Ul_BFu7s_BFu16s()
{
  {
    init_simple_test("Ul_BFu7s_BFu16s");
    static STRUCT_IF_C Ul_BFu7s_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "Ul_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "Ul_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu16s, Ul_BFu7s_BFu16s)
//============================================================================



static void Test_Ul_BFu7s_BFu17i()
{
  {
    init_simple_test("Ul_BFu7s_BFu17i");
    static STRUCT_IF_C Ul_BFu7s_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu17i, Ul_BFu7s_BFu17i)
//============================================================================



static void Test_Ul_BFu7s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu17ll");
    static STRUCT_IF_C Ul_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "Ul_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "Ul_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu17ll, Ul_BFu7s_BFu17ll)
//============================================================================



static void Test_Ul_BFu7s_BFu1c()
{
  {
    init_simple_test("Ul_BFu7s_BFu1c");
    static STRUCT_IF_C Ul_BFu7s_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu1c, Ul_BFu7s_BFu1c)
//============================================================================



static void Test_Ul_BFu7s_BFu1i()
{
  {
    init_simple_test("Ul_BFu7s_BFu1i");
    static STRUCT_IF_C Ul_BFu7s_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu1i, Ul_BFu7s_BFu1i)
//============================================================================



static void Test_Ul_BFu7s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu1ll");
    static STRUCT_IF_C Ul_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu1ll, Ul_BFu7s_BFu1ll)
//============================================================================



static void Test_Ul_BFu7s_BFu1s()
{
  {
    init_simple_test("Ul_BFu7s_BFu1s");
    static STRUCT_IF_C Ul_BFu7s_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "Ul_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu1s, Ul_BFu7s_BFu1s)
//============================================================================



static void Test_Ul_BFu7s_BFu31i()
{
  {
    init_simple_test("Ul_BFu7s_BFu31i");
    static STRUCT_IF_C Ul_BFu7s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu31i, Ul_BFu7s_BFu31i)
//============================================================================



static void Test_Ul_BFu7s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu31ll");
    static STRUCT_IF_C Ul_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "Ul_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "Ul_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu31ll, Ul_BFu7s_BFu31ll)
//============================================================================



static void Test_Ul_BFu7s_BFu32i()
{
  {
    init_simple_test("Ul_BFu7s_BFu32i");
    static STRUCT_IF_C Ul_BFu7s_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu32i, Ul_BFu7s_BFu32i)
//============================================================================



static void Test_Ul_BFu7s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu32ll");
    static STRUCT_IF_C Ul_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "Ul_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "Ul_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu32ll, Ul_BFu7s_BFu32ll)
//============================================================================



static void Test_Ul_BFu7s_BFu33()
{
  {
    init_simple_test("Ul_BFu7s_BFu33");
    static STRUCT_IF_C Ul_BFu7s_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "Ul_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "Ul_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu33, Ul_BFu7s_BFu33)
//============================================================================



static void Test_Ul_BFu7s_BFu7c()
{
  {
    init_simple_test("Ul_BFu7s_BFu7c");
    static STRUCT_IF_C Ul_BFu7s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu7c, Ul_BFu7s_BFu7c)
//============================================================================



static void Test_Ul_BFu7s_BFu7i()
{
  {
    init_simple_test("Ul_BFu7s_BFu7i");
    static STRUCT_IF_C Ul_BFu7s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu7i, Ul_BFu7s_BFu7i)
//============================================================================



static void Test_Ul_BFu7s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu7ll");
    static STRUCT_IF_C Ul_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu7ll, Ul_BFu7s_BFu7ll)
//============================================================================



static void Test_Ul_BFu7s_BFu7s()
{
  {
    init_simple_test("Ul_BFu7s_BFu7s");
    static STRUCT_IF_C Ul_BFu7s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "Ul_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu7s, Ul_BFu7s_BFu7s)
//============================================================================



static void Test_Ul_BFu7s_BFu8c()
{
  {
    init_simple_test("Ul_BFu7s_BFu8c");
    static STRUCT_IF_C Ul_BFu7s_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu8c, Ul_BFu7s_BFu8c)
//============================================================================



static void Test_Ul_BFu7s_BFu8i()
{
  {
    init_simple_test("Ul_BFu7s_BFu8i");
    static STRUCT_IF_C Ul_BFu7s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu8i, Ul_BFu7s_BFu8i)
//============================================================================



static void Test_Ul_BFu7s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu8ll");
    static STRUCT_IF_C Ul_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu8ll, Ul_BFu7s_BFu8ll)
//============================================================================



static void Test_Ul_BFu7s_BFu8s()
{
  {
    init_simple_test("Ul_BFu7s_BFu8s");
    static STRUCT_IF_C Ul_BFu7s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "Ul_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "Ul_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu8s, Ul_BFu7s_BFu8s)
//============================================================================



static void Test_Ul_BFu7s_BFu9i()
{
  {
    init_simple_test("Ul_BFu7s_BFu9i");
    static STRUCT_IF_C Ul_BFu7s_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu9i, Ul_BFu7s_BFu9i)
//============================================================================



static void Test_Ul_BFu7s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu7s_BFu9ll");
    static STRUCT_IF_C Ul_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu9ll, Ul_BFu7s_BFu9ll)
//============================================================================



static void Test_Ul_BFu7s_BFu9s()
{
  {
    init_simple_test("Ul_BFu7s_BFu9s");
    static STRUCT_IF_C Ul_BFu7s_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "Ul_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "Ul_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_BFu9s, Ul_BFu7s_BFu9s)
//============================================================================



static void Test_Ul_BFu7s_C()
{
  {
    init_simple_test("Ul_BFu7s_C");
    static STRUCT_IF_C Ul_BFu7s_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_C");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_C, Ul_BFu7s_C)
//============================================================================



static void Test_Ul_BFu7s_D()
{
  {
    init_simple_test("Ul_BFu7s_D");
    static STRUCT_IF_C Ul_BFu7s_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_D");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_D, Ul_BFu7s_D)
//============================================================================



static void Test_Ul_BFu7s_F()
{
  {
    init_simple_test("Ul_BFu7s_F");
    static STRUCT_IF_C Ul_BFu7s_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_F");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_F, Ul_BFu7s_F)
//============================================================================



static void Test_Ul_BFu7s_I()
{
  {
    init_simple_test("Ul_BFu7s_I");
    static STRUCT_IF_C Ul_BFu7s_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_I");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_I, Ul_BFu7s_I)
//============================================================================



static void Test_Ul_BFu7s_Ip()
{
  {
    init_simple_test("Ul_BFu7s_Ip");
    static STRUCT_IF_C Ul_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_Ip, Ul_BFu7s_Ip)
//============================================================================



static void Test_Ul_BFu7s_L()
{
  {
    init_simple_test("Ul_BFu7s_L");
    static STRUCT_IF_C Ul_BFu7s_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_L");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_L, Ul_BFu7s_L)
//============================================================================



static void Test_Ul_BFu7s_S()
{
  {
    init_simple_test("Ul_BFu7s_S");
    static STRUCT_IF_C Ul_BFu7s_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_S");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_S, Ul_BFu7s_S)
//============================================================================



static void Test_Ul_BFu7s_Uc()
{
  {
    init_simple_test("Ul_BFu7s_Uc");
    static STRUCT_IF_C Ul_BFu7s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_Uc, Ul_BFu7s_Uc)
//============================================================================



static void Test_Ul_BFu7s_Ui()
{
  {
    init_simple_test("Ul_BFu7s_Ui");
    static STRUCT_IF_C Ul_BFu7s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_Ui, Ul_BFu7s_Ui)
//============================================================================



static void Test_Ul_BFu7s_Ul()
{
  {
    init_simple_test("Ul_BFu7s_Ul");
    static STRUCT_IF_C Ul_BFu7s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_Ul, Ul_BFu7s_Ul)
//============================================================================



static void Test_Ul_BFu7s_Us()
{
  {
    init_simple_test("Ul_BFu7s_Us");
    static STRUCT_IF_C Ul_BFu7s_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_Us, Ul_BFu7s_Us)
//============================================================================



static void Test_Ul_BFu7s_Vp()
{
  {
    init_simple_test("Ul_BFu7s_Vp");
    static STRUCT_IF_C Ul_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu7s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu7s_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu7s_Vp, Ul_BFu7s_Vp)
//============================================================================



static void Test_Ul_BFu8c()
{
  {
    init_simple_test("Ul_BFu8c");
    static STRUCT_IF_C Ul_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c, Ul_BFu8c)
//============================================================================



static void Test_Ul_BFu8c_BFu15i()
{
  {
    init_simple_test("Ul_BFu8c_BFu15i");
    static STRUCT_IF_C Ul_BFu8c_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu15i, Ul_BFu8c_BFu15i)
//============================================================================



static void Test_Ul_BFu8c_BFu15ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu15ll");
    static STRUCT_IF_C Ul_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu15ll, Ul_BFu8c_BFu15ll)
//============================================================================



static void Test_Ul_BFu8c_BFu15s()
{
  {
    init_simple_test("Ul_BFu8c_BFu15s");
    static STRUCT_IF_C Ul_BFu8c_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu15s, Ul_BFu8c_BFu15s)
//============================================================================



static void Test_Ul_BFu8c_BFu16i()
{
  {
    init_simple_test("Ul_BFu8c_BFu16i");
    static STRUCT_IF_C Ul_BFu8c_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu16i, Ul_BFu8c_BFu16i)
//============================================================================



static void Test_Ul_BFu8c_BFu16ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu16ll");
    static STRUCT_IF_C Ul_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu16ll, Ul_BFu8c_BFu16ll)
//============================================================================



static void Test_Ul_BFu8c_BFu16s()
{
  {
    init_simple_test("Ul_BFu8c_BFu16s");
    static STRUCT_IF_C Ul_BFu8c_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu16s, Ul_BFu8c_BFu16s)
//============================================================================



static void Test_Ul_BFu8c_BFu17i()
{
  {
    init_simple_test("Ul_BFu8c_BFu17i");
    static STRUCT_IF_C Ul_BFu8c_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu17i, Ul_BFu8c_BFu17i)
//============================================================================



static void Test_Ul_BFu8c_BFu17ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu17ll");
    static STRUCT_IF_C Ul_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu17ll, Ul_BFu8c_BFu17ll)
//============================================================================



static void Test_Ul_BFu8c_BFu1c()
{
  {
    init_simple_test("Ul_BFu8c_BFu1c");
    static STRUCT_IF_C Ul_BFu8c_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu1c, Ul_BFu8c_BFu1c)
//============================================================================



static void Test_Ul_BFu8c_BFu1i()
{
  {
    init_simple_test("Ul_BFu8c_BFu1i");
    static STRUCT_IF_C Ul_BFu8c_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu1i, Ul_BFu8c_BFu1i)
//============================================================================



static void Test_Ul_BFu8c_BFu1ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu1ll");
    static STRUCT_IF_C Ul_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu1ll, Ul_BFu8c_BFu1ll)
//============================================================================



static void Test_Ul_BFu8c_BFu1s()
{
  {
    init_simple_test("Ul_BFu8c_BFu1s");
    static STRUCT_IF_C Ul_BFu8c_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu1s, Ul_BFu8c_BFu1s)
//============================================================================



static void Test_Ul_BFu8c_BFu31i()
{
  {
    init_simple_test("Ul_BFu8c_BFu31i");
    static STRUCT_IF_C Ul_BFu8c_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu31i, Ul_BFu8c_BFu31i)
//============================================================================



static void Test_Ul_BFu8c_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu31ll");
    static STRUCT_IF_C Ul_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu31ll, Ul_BFu8c_BFu31ll)
//============================================================================



static void Test_Ul_BFu8c_BFu32i()
{
  {
    init_simple_test("Ul_BFu8c_BFu32i");
    static STRUCT_IF_C Ul_BFu8c_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu32i, Ul_BFu8c_BFu32i)
//============================================================================



static void Test_Ul_BFu8c_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu32ll");
    static STRUCT_IF_C Ul_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu32ll, Ul_BFu8c_BFu32ll)
//============================================================================



static void Test_Ul_BFu8c_BFu33()
{
  {
    init_simple_test("Ul_BFu8c_BFu33");
    static STRUCT_IF_C Ul_BFu8c_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu33, Ul_BFu8c_BFu33)
//============================================================================



static void Test_Ul_BFu8c_BFu7c()
{
  {
    init_simple_test("Ul_BFu8c_BFu7c");
    static STRUCT_IF_C Ul_BFu8c_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu7c, Ul_BFu8c_BFu7c)
//============================================================================



static void Test_Ul_BFu8c_BFu7i()
{
  {
    init_simple_test("Ul_BFu8c_BFu7i");
    static STRUCT_IF_C Ul_BFu8c_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu7i, Ul_BFu8c_BFu7i)
//============================================================================



static void Test_Ul_BFu8c_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu7ll");
    static STRUCT_IF_C Ul_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu7ll, Ul_BFu8c_BFu7ll)
//============================================================================



static void Test_Ul_BFu8c_BFu7s()
{
  {
    init_simple_test("Ul_BFu8c_BFu7s");
    static STRUCT_IF_C Ul_BFu8c_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu7s, Ul_BFu8c_BFu7s)
//============================================================================



static void Test_Ul_BFu8c_BFu8c()
{
  {
    init_simple_test("Ul_BFu8c_BFu8c");
    static STRUCT_IF_C Ul_BFu8c_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu8c, Ul_BFu8c_BFu8c)
//============================================================================



static void Test_Ul_BFu8c_BFu8i()
{
  {
    init_simple_test("Ul_BFu8c_BFu8i");
    static STRUCT_IF_C Ul_BFu8c_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu8i, Ul_BFu8c_BFu8i)
//============================================================================



static void Test_Ul_BFu8c_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu8ll");
    static STRUCT_IF_C Ul_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu8ll, Ul_BFu8c_BFu8ll)
//============================================================================



static void Test_Ul_BFu8c_BFu8s()
{
  {
    init_simple_test("Ul_BFu8c_BFu8s");
    static STRUCT_IF_C Ul_BFu8c_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu8s, Ul_BFu8c_BFu8s)
//============================================================================



static void Test_Ul_BFu8c_BFu9i()
{
  {
    init_simple_test("Ul_BFu8c_BFu9i");
    static STRUCT_IF_C Ul_BFu8c_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu9i, Ul_BFu8c_BFu9i)
//============================================================================



static void Test_Ul_BFu8c_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8c_BFu9ll");
    static STRUCT_IF_C Ul_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu9ll, Ul_BFu8c_BFu9ll)
//============================================================================



static void Test_Ul_BFu8c_BFu9s()
{
  {
    init_simple_test("Ul_BFu8c_BFu9s");
    static STRUCT_IF_C Ul_BFu8c_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_BFu9s, Ul_BFu8c_BFu9s)
//============================================================================



static void Test_Ul_BFu8c_C()
{
  {
    init_simple_test("Ul_BFu8c_C");
    static STRUCT_IF_C Ul_BFu8c_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_C, Ul_BFu8c_C)
//============================================================================



static void Test_Ul_BFu8c_D()
{
  {
    init_simple_test("Ul_BFu8c_D");
    static STRUCT_IF_C Ul_BFu8c_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_D");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_D, Ul_BFu8c_D)
//============================================================================



static void Test_Ul_BFu8c_F()
{
  {
    init_simple_test("Ul_BFu8c_F");
    static STRUCT_IF_C Ul_BFu8c_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_F");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_F, Ul_BFu8c_F)
//============================================================================



static void Test_Ul_BFu8c_I()
{
  {
    init_simple_test("Ul_BFu8c_I");
    static STRUCT_IF_C Ul_BFu8c_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_I");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_I, Ul_BFu8c_I)
//============================================================================



static void Test_Ul_BFu8c_Ip()
{
  {
    init_simple_test("Ul_BFu8c_Ip");
    static STRUCT_IF_C Ul_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_Ip, Ul_BFu8c_Ip)
//============================================================================



static void Test_Ul_BFu8c_L()
{
  {
    init_simple_test("Ul_BFu8c_L");
    static STRUCT_IF_C Ul_BFu8c_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_L");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_L, Ul_BFu8c_L)
//============================================================================



static void Test_Ul_BFu8c_S()
{
  {
    init_simple_test("Ul_BFu8c_S");
    static STRUCT_IF_C Ul_BFu8c_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_S");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_S, Ul_BFu8c_S)
//============================================================================



static void Test_Ul_BFu8c_Uc()
{
  {
    init_simple_test("Ul_BFu8c_Uc");
    static STRUCT_IF_C Ul_BFu8c_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_Uc, Ul_BFu8c_Uc)
//============================================================================



static void Test_Ul_BFu8c_Ui()
{
  {
    init_simple_test("Ul_BFu8c_Ui");
    static STRUCT_IF_C Ul_BFu8c_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_Ui, Ul_BFu8c_Ui)
//============================================================================



static void Test_Ul_BFu8c_Ul()
{
  {
    init_simple_test("Ul_BFu8c_Ul");
    static STRUCT_IF_C Ul_BFu8c_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_Ul, Ul_BFu8c_Ul)
//============================================================================



static void Test_Ul_BFu8c_Us()
{
  {
    init_simple_test("Ul_BFu8c_Us");
    static STRUCT_IF_C Ul_BFu8c_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_Us, Ul_BFu8c_Us)
//============================================================================



static void Test_Ul_BFu8c_Vp()
{
  {
    init_simple_test("Ul_BFu8c_Vp");
    static STRUCT_IF_C Ul_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8c_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8c_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8c_Vp, Ul_BFu8c_Vp)
//============================================================================



static void Test_Ul_BFu8i()
{
  {
    init_simple_test("Ul_BFu8i");
    static STRUCT_IF_C Ul_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i, Ul_BFu8i)
//============================================================================



static void Test_Ul_BFu8i_BFu15i()
{
  {
    init_simple_test("Ul_BFu8i_BFu15i");
    static STRUCT_IF_C Ul_BFu8i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu15i, Ul_BFu8i_BFu15i)
//============================================================================



static void Test_Ul_BFu8i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu15ll");
    static STRUCT_IF_C Ul_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu15ll, Ul_BFu8i_BFu15ll)
//============================================================================



static void Test_Ul_BFu8i_BFu15s()
{
  {
    init_simple_test("Ul_BFu8i_BFu15s");
    static STRUCT_IF_C Ul_BFu8i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu15s, Ul_BFu8i_BFu15s)
//============================================================================



static void Test_Ul_BFu8i_BFu16i()
{
  {
    init_simple_test("Ul_BFu8i_BFu16i");
    static STRUCT_IF_C Ul_BFu8i_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu16i, Ul_BFu8i_BFu16i)
//============================================================================



static void Test_Ul_BFu8i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu16ll");
    static STRUCT_IF_C Ul_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu16ll, Ul_BFu8i_BFu16ll)
//============================================================================



static void Test_Ul_BFu8i_BFu16s()
{
  {
    init_simple_test("Ul_BFu8i_BFu16s");
    static STRUCT_IF_C Ul_BFu8i_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu16s, Ul_BFu8i_BFu16s)
//============================================================================



static void Test_Ul_BFu8i_BFu17i()
{
  {
    init_simple_test("Ul_BFu8i_BFu17i");
    static STRUCT_IF_C Ul_BFu8i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu17i, Ul_BFu8i_BFu17i)
//============================================================================



static void Test_Ul_BFu8i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu17ll");
    static STRUCT_IF_C Ul_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu17ll, Ul_BFu8i_BFu17ll)
//============================================================================



static void Test_Ul_BFu8i_BFu1c()
{
  {
    init_simple_test("Ul_BFu8i_BFu1c");
    static STRUCT_IF_C Ul_BFu8i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu1c, Ul_BFu8i_BFu1c)
//============================================================================



static void Test_Ul_BFu8i_BFu1i()
{
  {
    init_simple_test("Ul_BFu8i_BFu1i");
    static STRUCT_IF_C Ul_BFu8i_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu1i, Ul_BFu8i_BFu1i)
//============================================================================



static void Test_Ul_BFu8i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu1ll");
    static STRUCT_IF_C Ul_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu1ll, Ul_BFu8i_BFu1ll)
//============================================================================



static void Test_Ul_BFu8i_BFu1s()
{
  {
    init_simple_test("Ul_BFu8i_BFu1s");
    static STRUCT_IF_C Ul_BFu8i_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu1s, Ul_BFu8i_BFu1s)
//============================================================================



static void Test_Ul_BFu8i_BFu31i()
{
  {
    init_simple_test("Ul_BFu8i_BFu31i");
    static STRUCT_IF_C Ul_BFu8i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu31i, Ul_BFu8i_BFu31i)
//============================================================================



static void Test_Ul_BFu8i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu31ll");
    static STRUCT_IF_C Ul_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu31ll, Ul_BFu8i_BFu31ll)
//============================================================================



static void Test_Ul_BFu8i_BFu32i()
{
  {
    init_simple_test("Ul_BFu8i_BFu32i");
    static STRUCT_IF_C Ul_BFu8i_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu32i, Ul_BFu8i_BFu32i)
//============================================================================



static void Test_Ul_BFu8i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu32ll");
    static STRUCT_IF_C Ul_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu32ll, Ul_BFu8i_BFu32ll)
//============================================================================



static void Test_Ul_BFu8i_BFu33()
{
  {
    init_simple_test("Ul_BFu8i_BFu33");
    static STRUCT_IF_C Ul_BFu8i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu33, Ul_BFu8i_BFu33)
//============================================================================



static void Test_Ul_BFu8i_BFu7c()
{
  {
    init_simple_test("Ul_BFu8i_BFu7c");
    static STRUCT_IF_C Ul_BFu8i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7c, Ul_BFu8i_BFu7c)
//============================================================================



static void Test_Ul_BFu8i_BFu7i()
{
  {
    init_simple_test("Ul_BFu8i_BFu7i");
    static STRUCT_IF_C Ul_BFu8i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7i, Ul_BFu8i_BFu7i)
//============================================================================



static void Test_Ul_BFu8i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu7ll");
    static STRUCT_IF_C Ul_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7ll, Ul_BFu8i_BFu7ll)
//============================================================================



static void Test_Ul_BFu8i_BFu7s()
{
  {
    init_simple_test("Ul_BFu8i_BFu7s");
    static STRUCT_IF_C Ul_BFu8i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7s, Ul_BFu8i_BFu7s)
//============================================================================



static void Test_Ul_BFu8i_BFu8c()
{
  {
    init_simple_test("Ul_BFu8i_BFu8c");
    static STRUCT_IF_C Ul_BFu8i_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8c, Ul_BFu8i_BFu8c)
//============================================================================



static void Test_Ul_BFu8i_BFu8i()
{
  {
    init_simple_test("Ul_BFu8i_BFu8i");
    static STRUCT_IF_C Ul_BFu8i_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8i, Ul_BFu8i_BFu8i)
//============================================================================



static void Test_Ul_BFu8i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu8ll");
    static STRUCT_IF_C Ul_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8ll, Ul_BFu8i_BFu8ll)
//============================================================================



static void Test_Ul_BFu8i_BFu8s()
{
  {
    init_simple_test("Ul_BFu8i_BFu8s");
    static STRUCT_IF_C Ul_BFu8i_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8s, Ul_BFu8i_BFu8s)
//============================================================================



static void Test_Ul_BFu8i_BFu9i()
{
  {
    init_simple_test("Ul_BFu8i_BFu9i");
    static STRUCT_IF_C Ul_BFu8i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu9i, Ul_BFu8i_BFu9i)
//============================================================================



static void Test_Ul_BFu8i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu9ll");
    static STRUCT_IF_C Ul_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu9ll, Ul_BFu8i_BFu9ll)
//============================================================================



static void Test_Ul_BFu8i_BFu9s()
{
  {
    init_simple_test("Ul_BFu8i_BFu9s");
    static STRUCT_IF_C Ul_BFu8i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu9s, Ul_BFu8i_BFu9s)
//============================================================================



static void Test_Ul_BFu8i_C()
{
  {
    init_simple_test("Ul_BFu8i_C");
    static STRUCT_IF_C Ul_BFu8i_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_C, Ul_BFu8i_C)
//============================================================================



static void Test_Ul_BFu8i_D()
{
  {
    init_simple_test("Ul_BFu8i_D");
    static STRUCT_IF_C Ul_BFu8i_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_D");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_D, Ul_BFu8i_D)
//============================================================================



static void Test_Ul_BFu8i_F()
{
  {
    init_simple_test("Ul_BFu8i_F");
    static STRUCT_IF_C Ul_BFu8i_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_F");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_F, Ul_BFu8i_F)
//============================================================================



static void Test_Ul_BFu8i_I()
{
  {
    init_simple_test("Ul_BFu8i_I");
    static STRUCT_IF_C Ul_BFu8i_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_I");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_I, Ul_BFu8i_I)
//============================================================================



static void Test_Ul_BFu8i_Ip()
{
  {
    init_simple_test("Ul_BFu8i_Ip");
    static STRUCT_IF_C Ul_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Ip, Ul_BFu8i_Ip)
//============================================================================



static void Test_Ul_BFu8i_L()
{
  {
    init_simple_test("Ul_BFu8i_L");
    static STRUCT_IF_C Ul_BFu8i_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_L");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_L, Ul_BFu8i_L)
//============================================================================



static void Test_Ul_BFu8i_S()
{
  {
    init_simple_test("Ul_BFu8i_S");
    static STRUCT_IF_C Ul_BFu8i_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_S");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_S, Ul_BFu8i_S)
//============================================================================



static void Test_Ul_BFu8i_Uc()
{
  {
    init_simple_test("Ul_BFu8i_Uc");
    static STRUCT_IF_C Ul_BFu8i_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Uc, Ul_BFu8i_Uc)
//============================================================================



static void Test_Ul_BFu8i_Ui()
{
  {
    init_simple_test("Ul_BFu8i_Ui");
    static STRUCT_IF_C Ul_BFu8i_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Ui, Ul_BFu8i_Ui)
//============================================================================



static void Test_Ul_BFu8i_Ul()
{
  {
    init_simple_test("Ul_BFu8i_Ul");
    static STRUCT_IF_C Ul_BFu8i_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Ul, Ul_BFu8i_Ul)
//============================================================================



static void Test_Ul_BFu8i_Us()
{
  {
    init_simple_test("Ul_BFu8i_Us");
    static STRUCT_IF_C Ul_BFu8i_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Us, Ul_BFu8i_Us)
//============================================================================



static void Test_Ul_BFu8i_Vp()
{
  {
    init_simple_test("Ul_BFu8i_Vp");
    static STRUCT_IF_C Ul_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Vp, Ul_BFu8i_Vp)
//============================================================================



static void Test_Ul_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8ll");
    static STRUCT_IF_C Ul_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll, Ul_BFu8ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu15i");
    static STRUCT_IF_C Ul_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu15i, Ul_BFu8ll_BFu15i)
//============================================================================



static void Test_Ul_BFu8ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu15ll, Ul_BFu8ll_BFu15ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu15s");
    static STRUCT_IF_C Ul_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu15s, Ul_BFu8ll_BFu15s)
//============================================================================



static void Test_Ul_BFu8ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu16i");
    static STRUCT_IF_C Ul_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu16i, Ul_BFu8ll_BFu16i)
//============================================================================



static void Test_Ul_BFu8ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu16ll, Ul_BFu8ll_BFu16ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu16s");
    static STRUCT_IF_C Ul_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu16s, Ul_BFu8ll_BFu16s)
//============================================================================



static void Test_Ul_BFu8ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu17i");
    static STRUCT_IF_C Ul_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu17i, Ul_BFu8ll_BFu17i)
//============================================================================



static void Test_Ul_BFu8ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu17ll, Ul_BFu8ll_BFu17ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1c");
    static STRUCT_IF_C Ul_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1c, Ul_BFu8ll_BFu1c)
//============================================================================



static void Test_Ul_BFu8ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1i");
    static STRUCT_IF_C Ul_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1i, Ul_BFu8ll_BFu1i)
//============================================================================



static void Test_Ul_BFu8ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1ll, Ul_BFu8ll_BFu1ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1s");
    static STRUCT_IF_C Ul_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1s, Ul_BFu8ll_BFu1s)
//============================================================================



static void Test_Ul_BFu8ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu31i");
    static STRUCT_IF_C Ul_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu31i, Ul_BFu8ll_BFu31i)
//============================================================================



static void Test_Ul_BFu8ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu31ll, Ul_BFu8ll_BFu31ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu32i");
    static STRUCT_IF_C Ul_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu32i, Ul_BFu8ll_BFu32i)
//============================================================================



static void Test_Ul_BFu8ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu32ll, Ul_BFu8ll_BFu32ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu33()
{
  {
    init_simple_test("Ul_BFu8ll_BFu33");
    static STRUCT_IF_C Ul_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu33, Ul_BFu8ll_BFu33)
//============================================================================



static void Test_Ul_BFu8ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7c");
    static STRUCT_IF_C Ul_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7c, Ul_BFu8ll_BFu7c)
//============================================================================



static void Test_Ul_BFu8ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7i");
    static STRUCT_IF_C Ul_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7i, Ul_BFu8ll_BFu7i)
//============================================================================



static void Test_Ul_BFu8ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7ll, Ul_BFu8ll_BFu7ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7s");
    static STRUCT_IF_C Ul_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7s, Ul_BFu8ll_BFu7s)
//============================================================================



static void Test_Ul_BFu8ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8c");
    static STRUCT_IF_C Ul_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8c, Ul_BFu8ll_BFu8c)
//============================================================================



static void Test_Ul_BFu8ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8i");
    static STRUCT_IF_C Ul_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8i, Ul_BFu8ll_BFu8i)
//============================================================================



static void Test_Ul_BFu8ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8ll, Ul_BFu8ll_BFu8ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8s");
    static STRUCT_IF_C Ul_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8s, Ul_BFu8ll_BFu8s)
//============================================================================



static void Test_Ul_BFu8ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu9i");
    static STRUCT_IF_C Ul_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu9i, Ul_BFu8ll_BFu9i)
//============================================================================



static void Test_Ul_BFu8ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu9ll, Ul_BFu8ll_BFu9ll)
//============================================================================



static void Test_Ul_BFu8ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu9s");
    static STRUCT_IF_C Ul_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu9s, Ul_BFu8ll_BFu9s)
//============================================================================



static void Test_Ul_BFu8ll_C()
{
  {
    init_simple_test("Ul_BFu8ll_C");
    static STRUCT_IF_C Ul_BFu8ll_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_C, Ul_BFu8ll_C)
//============================================================================



static void Test_Ul_BFu8ll_D()
{
  {
    init_simple_test("Ul_BFu8ll_D");
    static STRUCT_IF_C Ul_BFu8ll_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_D");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_D, Ul_BFu8ll_D)
//============================================================================



static void Test_Ul_BFu8ll_F()
{
  {
    init_simple_test("Ul_BFu8ll_F");
    static STRUCT_IF_C Ul_BFu8ll_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_F");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_F, Ul_BFu8ll_F)
//============================================================================



static void Test_Ul_BFu8ll_I()
{
  {
    init_simple_test("Ul_BFu8ll_I");
    static STRUCT_IF_C Ul_BFu8ll_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_I");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_I, Ul_BFu8ll_I)
//============================================================================



static void Test_Ul_BFu8ll_Ip()
{
  {
    init_simple_test("Ul_BFu8ll_Ip");
    static STRUCT_IF_C Ul_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Ip, Ul_BFu8ll_Ip)
//============================================================================



static void Test_Ul_BFu8ll_L()
{
  {
    init_simple_test("Ul_BFu8ll_L");
    static STRUCT_IF_C Ul_BFu8ll_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_L");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_L, Ul_BFu8ll_L)
//============================================================================



static void Test_Ul_BFu8ll_S()
{
  {
    init_simple_test("Ul_BFu8ll_S");
    static STRUCT_IF_C Ul_BFu8ll_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_S");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_S, Ul_BFu8ll_S)
//============================================================================



static void Test_Ul_BFu8ll_Uc()
{
  {
    init_simple_test("Ul_BFu8ll_Uc");
    static STRUCT_IF_C Ul_BFu8ll_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Uc, Ul_BFu8ll_Uc)
//============================================================================



static void Test_Ul_BFu8ll_Ui()
{
  {
    init_simple_test("Ul_BFu8ll_Ui");
    static STRUCT_IF_C Ul_BFu8ll_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Ui, Ul_BFu8ll_Ui)
//============================================================================



static void Test_Ul_BFu8ll_Ul()
{
  {
    init_simple_test("Ul_BFu8ll_Ul");
    static STRUCT_IF_C Ul_BFu8ll_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Ul, Ul_BFu8ll_Ul)
//============================================================================



static void Test_Ul_BFu8ll_Us()
{
  {
    init_simple_test("Ul_BFu8ll_Us");
    static STRUCT_IF_C Ul_BFu8ll_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Us, Ul_BFu8ll_Us)
//============================================================================



static void Test_Ul_BFu8ll_Vp()
{
  {
    init_simple_test("Ul_BFu8ll_Vp");
    static STRUCT_IF_C Ul_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Vp, Ul_BFu8ll_Vp)
//============================================================================



static void Test_Ul_BFu8s()
{
  {
    init_simple_test("Ul_BFu8s");
    static STRUCT_IF_C Ul_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s, Ul_BFu8s)
//============================================================================



static void Test_Ul_BFu8s_BFu15i()
{
  {
    init_simple_test("Ul_BFu8s_BFu15i");
    static STRUCT_IF_C Ul_BFu8s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu15i, Ul_BFu8s_BFu15i)
//============================================================================



static void Test_Ul_BFu8s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu15ll");
    static STRUCT_IF_C Ul_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu15ll, Ul_BFu8s_BFu15ll)
//============================================================================



static void Test_Ul_BFu8s_BFu15s()
{
  {
    init_simple_test("Ul_BFu8s_BFu15s");
    static STRUCT_IF_C Ul_BFu8s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu15s, Ul_BFu8s_BFu15s)
//============================================================================



static void Test_Ul_BFu8s_BFu16i()
{
  {
    init_simple_test("Ul_BFu8s_BFu16i");
    static STRUCT_IF_C Ul_BFu8s_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu16i, Ul_BFu8s_BFu16i)
//============================================================================



static void Test_Ul_BFu8s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu16ll");
    static STRUCT_IF_C Ul_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu16ll, Ul_BFu8s_BFu16ll)
//============================================================================



static void Test_Ul_BFu8s_BFu16s()
{
  {
    init_simple_test("Ul_BFu8s_BFu16s");
    static STRUCT_IF_C Ul_BFu8s_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu16s, Ul_BFu8s_BFu16s)
//============================================================================



static void Test_Ul_BFu8s_BFu17i()
{
  {
    init_simple_test("Ul_BFu8s_BFu17i");
    static STRUCT_IF_C Ul_BFu8s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu17i, Ul_BFu8s_BFu17i)
//============================================================================



static void Test_Ul_BFu8s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu17ll");
    static STRUCT_IF_C Ul_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu17ll, Ul_BFu8s_BFu17ll)
//============================================================================



static void Test_Ul_BFu8s_BFu1c()
{
  {
    init_simple_test("Ul_BFu8s_BFu1c");
    static STRUCT_IF_C Ul_BFu8s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1c, Ul_BFu8s_BFu1c)
//============================================================================



static void Test_Ul_BFu8s_BFu1i()
{
  {
    init_simple_test("Ul_BFu8s_BFu1i");
    static STRUCT_IF_C Ul_BFu8s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1i, Ul_BFu8s_BFu1i)
//============================================================================



static void Test_Ul_BFu8s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu1ll");
    static STRUCT_IF_C Ul_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1ll, Ul_BFu8s_BFu1ll)
//============================================================================



static void Test_Ul_BFu8s_BFu1s()
{
  {
    init_simple_test("Ul_BFu8s_BFu1s");
    static STRUCT_IF_C Ul_BFu8s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1s, Ul_BFu8s_BFu1s)
//============================================================================



static void Test_Ul_BFu8s_BFu31i()
{
  {
    init_simple_test("Ul_BFu8s_BFu31i");
    static STRUCT_IF_C Ul_BFu8s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu31i, Ul_BFu8s_BFu31i)
//============================================================================



static void Test_Ul_BFu8s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu31ll");
    static STRUCT_IF_C Ul_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu31ll, Ul_BFu8s_BFu31ll)
//============================================================================



static void Test_Ul_BFu8s_BFu32i()
{
  {
    init_simple_test("Ul_BFu8s_BFu32i");
    static STRUCT_IF_C Ul_BFu8s_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu32i, Ul_BFu8s_BFu32i)
//============================================================================



static void Test_Ul_BFu8s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu32ll");
    static STRUCT_IF_C Ul_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu32ll, Ul_BFu8s_BFu32ll)
//============================================================================



static void Test_Ul_BFu8s_BFu33()
{
  {
    init_simple_test("Ul_BFu8s_BFu33");
    static STRUCT_IF_C Ul_BFu8s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Ul_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu33, Ul_BFu8s_BFu33)
//============================================================================



static void Test_Ul_BFu8s_BFu7c()
{
  {
    init_simple_test("Ul_BFu8s_BFu7c");
    static STRUCT_IF_C Ul_BFu8s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7c, Ul_BFu8s_BFu7c)
//============================================================================



static void Test_Ul_BFu8s_BFu7i()
{
  {
    init_simple_test("Ul_BFu8s_BFu7i");
    static STRUCT_IF_C Ul_BFu8s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7i, Ul_BFu8s_BFu7i)
//============================================================================



static void Test_Ul_BFu8s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu7ll");
    static STRUCT_IF_C Ul_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7ll, Ul_BFu8s_BFu7ll)
//============================================================================



static void Test_Ul_BFu8s_BFu7s()
{
  {
    init_simple_test("Ul_BFu8s_BFu7s");
    static STRUCT_IF_C Ul_BFu8s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7s, Ul_BFu8s_BFu7s)
//============================================================================



static void Test_Ul_BFu8s_BFu8c()
{
  {
    init_simple_test("Ul_BFu8s_BFu8c");
    static STRUCT_IF_C Ul_BFu8s_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8c, Ul_BFu8s_BFu8c)
//============================================================================



static void Test_Ul_BFu8s_BFu8i()
{
  {
    init_simple_test("Ul_BFu8s_BFu8i");
    static STRUCT_IF_C Ul_BFu8s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8i, Ul_BFu8s_BFu8i)
//============================================================================



static void Test_Ul_BFu8s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu8ll");
    static STRUCT_IF_C Ul_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8ll, Ul_BFu8s_BFu8ll)
//============================================================================



static void Test_Ul_BFu8s_BFu8s()
{
  {
    init_simple_test("Ul_BFu8s_BFu8s");
    static STRUCT_IF_C Ul_BFu8s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8s, Ul_BFu8s_BFu8s)
//============================================================================



static void Test_Ul_BFu8s_BFu9i()
{
  {
    init_simple_test("Ul_BFu8s_BFu9i");
    static STRUCT_IF_C Ul_BFu8s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu9i, Ul_BFu8s_BFu9i)
//============================================================================



static void Test_Ul_BFu8s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu9ll");
    static STRUCT_IF_C Ul_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu9ll, Ul_BFu8s_BFu9ll)
//============================================================================



static void Test_Ul_BFu8s_BFu9s()
{
  {
    init_simple_test("Ul_BFu8s_BFu9s");
    static STRUCT_IF_C Ul_BFu8s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu9s, Ul_BFu8s_BFu9s)
//============================================================================



static void Test_Ul_BFu8s_C()
{
  {
    init_simple_test("Ul_BFu8s_C");
    static STRUCT_IF_C Ul_BFu8s_C lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_C, Ul_BFu8s_C)
//============================================================================



static void Test_Ul_BFu8s_D()
{
  {
    init_simple_test("Ul_BFu8s_D");
    static STRUCT_IF_C Ul_BFu8s_D lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_D");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_D, Ul_BFu8s_D)
//============================================================================



static void Test_Ul_BFu8s_F()
{
  {
    init_simple_test("Ul_BFu8s_F");
    static STRUCT_IF_C Ul_BFu8s_F lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_F");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_F, Ul_BFu8s_F)
//============================================================================



static void Test_Ul_BFu8s_I()
{
  {
    init_simple_test("Ul_BFu8s_I");
    static STRUCT_IF_C Ul_BFu8s_I lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_I");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_I, Ul_BFu8s_I)
//============================================================================



static void Test_Ul_BFu8s_Ip()
{
  {
    init_simple_test("Ul_BFu8s_Ip");
    static STRUCT_IF_C Ul_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Ip");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Ip, Ul_BFu8s_Ip)
//============================================================================



static void Test_Ul_BFu8s_L()
{
  {
    init_simple_test("Ul_BFu8s_L");
    static STRUCT_IF_C Ul_BFu8s_L lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_L");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_L, Ul_BFu8s_L)
//============================================================================



static void Test_Ul_BFu8s_S()
{
  {
    init_simple_test("Ul_BFu8s_S");
    static STRUCT_IF_C Ul_BFu8s_S lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_S");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_S, Ul_BFu8s_S)
//============================================================================



static void Test_Ul_BFu8s_Uc()
{
  {
    init_simple_test("Ul_BFu8s_Uc");
    static STRUCT_IF_C Ul_BFu8s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Uc, Ul_BFu8s_Uc)
//============================================================================



static void Test_Ul_BFu8s_Ui()
{
  {
    init_simple_test("Ul_BFu8s_Ui");
    static STRUCT_IF_C Ul_BFu8s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Ul_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Ui");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Ui, Ul_BFu8s_Ui)
//============================================================================



static void Test_Ul_BFu8s_Ul()
{
  {
    init_simple_test("Ul_BFu8s_Ul");
    static STRUCT_IF_C Ul_BFu8s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Ul_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Ul");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Ul, Ul_BFu8s_Ul)
//============================================================================



static void Test_Ul_BFu8s_Us()
{
  {
    init_simple_test("Ul_BFu8s_Us");
    static STRUCT_IF_C Ul_BFu8s_Us lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Us");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Us, Ul_BFu8s_Us)
//============================================================================



static void Test_Ul_BFu8s_Vp()
{
  {
    init_simple_test("Ul_BFu8s_Vp");
    static STRUCT_IF_C Ul_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Ul_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Vp");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Vp, Ul_BFu8s_Vp)
//============================================================================



static void Test_Ul_BFu9i()
{
  {
    init_simple_test("Ul_BFu9i");
    static STRUCT_IF_C Ul_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i, Ul_BFu9i)
//============================================================================



static void Test_Ul_BFu9i_BFu15i()
{
  {
    init_simple_test("Ul_BFu9i_BFu15i");
    static STRUCT_IF_C Ul_BFu9i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu15i, Ul_BFu9i_BFu15i)
//============================================================================



static void Test_Ul_BFu9i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu15ll");
    static STRUCT_IF_C Ul_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu15ll, Ul_BFu9i_BFu15ll)
//============================================================================



static void Test_Ul_BFu9i_BFu15s()
{
  {
    init_simple_test("Ul_BFu9i_BFu15s");
    static STRUCT_IF_C Ul_BFu9i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Ul_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu15s, Ul_BFu9i_BFu15s)
//============================================================================



static void Test_Ul_BFu9i_BFu16i()
{
  {
    init_simple_test("Ul_BFu9i_BFu16i");
    static STRUCT_IF_C Ul_BFu9i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu16i, Ul_BFu9i_BFu16i)
//============================================================================



static void Test_Ul_BFu9i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu16ll");
    static STRUCT_IF_C Ul_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu16ll, Ul_BFu9i_BFu16ll)
//============================================================================



static void Test_Ul_BFu9i_BFu16s()
{
  {
    init_simple_test("Ul_BFu9i_BFu16s");
    static STRUCT_IF_C Ul_BFu9i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu16s, Ul_BFu9i_BFu16s)
//============================================================================



static void Test_Ul_BFu9i_BFu17i()
{
  {
    init_simple_test("Ul_BFu9i_BFu17i");
    static STRUCT_IF_C Ul_BFu9i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu17i, Ul_BFu9i_BFu17i)
//============================================================================



static void Test_Ul_BFu9i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu17ll");
    static STRUCT_IF_C Ul_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Ul_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu17ll, Ul_BFu9i_BFu17ll)
//============================================================================



static void Test_Ul_BFu9i_BFu1c()
{
  {
    init_simple_test("Ul_BFu9i_BFu1c");
    static STRUCT_IF_C Ul_BFu9i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Ul_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Ul_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_B