// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct Uc_BFu16ll_BFu9s { unsigned char v1; unsigned long long v2:16; unsigned short v3:9; };
struct Uc_BFu16ll_C { unsigned char v1; unsigned long long v2:16; char v3; };
struct Uc_BFu16ll_D { unsigned char v1; unsigned long long v2:16; double v3; };
struct Uc_BFu16ll_F { unsigned char v1; unsigned long long v2:16; float v3; };
struct Uc_BFu16ll_I { unsigned char v1; unsigned long long v2:16; int v3; };
struct Uc_BFu16ll_Ip { unsigned char v1; unsigned long long v2:16; int * v3; };
struct Uc_BFu16ll_L { unsigned char v1; unsigned long long v2:16; long long v3; };
struct Uc_BFu16ll_S { unsigned char v1; unsigned long long v2:16; short v3; };
struct Uc_BFu16ll_Uc { unsigned char v1; unsigned long long v2:16; unsigned char v3; };
struct Uc_BFu16ll_Ui { unsigned char v1; unsigned long long v2:16; unsigned int v3; };
struct Uc_BFu16ll_Ul { unsigned char v1; unsigned long long v2:16; unsigned long long v3; };
struct Uc_BFu16ll_Us { unsigned char v1; unsigned long long v2:16; unsigned short v3; };
struct Uc_BFu16ll_Vp { unsigned char v1; unsigned long long v2:16; void * v3; };
struct Uc_BFu16s { unsigned char v1; unsigned short v2:16; };
struct Uc_BFu16s_BFu15i { unsigned char v1; unsigned short v2:16; unsigned int v3:15; };
struct Uc_BFu16s_BFu15ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:15; };
struct Uc_BFu16s_BFu15s { unsigned char v1; unsigned short v2:16; unsigned short v3:15; };
struct Uc_BFu16s_BFu16i { unsigned char v1; unsigned short v2:16; unsigned int v3:16; };
struct Uc_BFu16s_BFu16ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:16; };
struct Uc_BFu16s_BFu16s { unsigned char v1; unsigned short v2:16; unsigned short v3:16; };
struct Uc_BFu16s_BFu17i { unsigned char v1; unsigned short v2:16; unsigned int v3:17; };
struct Uc_BFu16s_BFu17ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:17; };
struct Uc_BFu16s_BFu1c { unsigned char v1; unsigned short v2:16; unsigned char v3:1; };
struct Uc_BFu16s_BFu1i { unsigned char v1; unsigned short v2:16; unsigned int v3:1; };
struct Uc_BFu16s_BFu1ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:1; };
struct Uc_BFu16s_BFu1s { unsigned char v1; unsigned short v2:16; unsigned short v3:1; };
struct Uc_BFu16s_BFu31i { unsigned char v1; unsigned short v2:16; unsigned int v3:31; };
struct Uc_BFu16s_BFu31ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:31; };
struct Uc_BFu16s_BFu32i { unsigned char v1; unsigned short v2:16; unsigned int v3:32; };
struct Uc_BFu16s_BFu32ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:32; };
struct Uc_BFu16s_BFu33 { unsigned char v1; unsigned short v2:16; unsigned long long v3:33; };
struct Uc_BFu16s_BFu7c { unsigned char v1; unsigned short v2:16; unsigned char v3:7; };
struct Uc_BFu16s_BFu7i { unsigned char v1; unsigned short v2:16; unsigned int v3:7; };
struct Uc_BFu16s_BFu7ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:7; };
struct Uc_BFu16s_BFu7s { unsigned char v1; unsigned short v2:16; unsigned short v3:7; };
struct Uc_BFu16s_BFu8c { unsigned char v1; unsigned short v2:16; unsigned char v3:8; };
struct Uc_BFu16s_BFu8i { unsigned char v1; unsigned short v2:16; unsigned int v3:8; };
struct Uc_BFu16s_BFu8ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:8; };
struct Uc_BFu16s_BFu8s { unsigned char v1; unsigned short v2:16; unsigned short v3:8; };
struct Uc_BFu16s_BFu9i { unsigned char v1; unsigned short v2:16; unsigned int v3:9; };
struct Uc_BFu16s_BFu9ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:9; };
struct Uc_BFu16s_BFu9s { unsigned char v1; unsigned short v2:16; unsigned short v3:9; };
struct Uc_BFu16s_C { unsigned char v1; unsigned short v2:16; char v3; };
struct Uc_BFu16s_D { unsigned char v1; unsigned short v2:16; double v3; };
struct Uc_BFu16s_F { unsigned char v1; unsigned short v2:16; float v3; };
struct Uc_BFu16s_I { unsigned char v1; unsigned short v2:16; int v3; };
struct Uc_BFu16s_Ip { unsigned char v1; unsigned short v2:16; int * v3; };
struct Uc_BFu16s_L { unsigned char v1; unsigned short v2:16; long long v3; };
struct Uc_BFu16s_S { unsigned char v1; unsigned short v2:16; short v3; };
struct Uc_BFu16s_Uc { unsigned char v1; unsigned short v2:16; unsigned char v3; };
struct Uc_BFu16s_Ui { unsigned char v1; unsigned short v2:16; unsigned int v3; };
struct Uc_BFu16s_Ul { unsigned char v1; unsigned short v2:16; unsigned long long v3; };
struct Uc_BFu16s_Us { unsigned char v1; unsigned short v2:16; unsigned short v3; };
struct Uc_BFu16s_Vp { unsigned char v1; unsigned short v2:16; void * v3; };
struct Uc_BFu17i { unsigned char v1; unsigned int v2:17; };
struct Uc_BFu17i_BFu15i { unsigned char v1; unsigned int v2:17; unsigned int v3:15; };
struct Uc_BFu17i_BFu15ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:15; };
struct Uc_BFu17i_BFu15s { unsigned char v1; unsigned int v2:17; unsigned short v3:15; };
struct Uc_BFu17i_BFu16i { unsigned char v1; unsigned int v2:17; unsigned int v3:16; };
struct Uc_BFu17i_BFu16ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:16; };
struct Uc_BFu17i_BFu16s { unsigned char v1; unsigned int v2:17; unsigned short v3:16; };
struct Uc_BFu17i_BFu17i { unsigned char v1; unsigned int v2:17; unsigned int v3:17; };
struct Uc_BFu17i_BFu17ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:17; };
struct Uc_BFu17i_BFu1c { unsigned char v1; unsigned int v2:17; unsigned char v3:1; };
struct Uc_BFu17i_BFu1i { unsigned char v1; unsigned int v2:17; unsigned int v3:1; };
struct Uc_BFu17i_BFu1ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:1; };
struct Uc_BFu17i_BFu1s { unsigned char v1; unsigned int v2:17; unsigned short v3:1; };
struct Uc_BFu17i_BFu31i { unsigned char v1; unsigned int v2:17; unsigned int v3:31; };
struct Uc_BFu17i_BFu31ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:31; };
struct Uc_BFu17i_BFu32i { unsigned char v1; unsigned int v2:17; unsigned int v3:32; };
struct Uc_BFu17i_BFu32ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:32; };
struct Uc_BFu17i_BFu33 { unsigned char v1; unsigned int v2:17; unsigned long long v3:33; };
struct Uc_BFu17i_BFu7c { unsigned char v1; unsigned int v2:17; unsigned char v3:7; };
struct Uc_BFu17i_BFu7i { unsigned char v1; unsigned int v2:17; unsigned int v3:7; };
struct Uc_BFu17i_BFu7ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:7; };
struct Uc_BFu17i_BFu7s { unsigned char v1; unsigned int v2:17; unsigned short v3:7; };
struct Uc_BFu17i_BFu8c { unsigned char v1; unsigned int v2:17; unsigned char v3:8; };
struct Uc_BFu17i_BFu8i { unsigned char v1; unsigned int v2:17; unsigned int v3:8; };
struct Uc_BFu17i_BFu8ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:8; };
struct Uc_BFu17i_BFu8s { unsigned char v1; unsigned int v2:17; unsigned short v3:8; };
struct Uc_BFu17i_BFu9i { unsigned char v1; unsigned int v2:17; unsigned int v3:9; };
struct Uc_BFu17i_BFu9ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:9; };
struct Uc_BFu17i_BFu9s { unsigned char v1; unsigned int v2:17; unsigned short v3:9; };
struct Uc_BFu17i_C { unsigned char v1; unsigned int v2:17; char v3; };
struct Uc_BFu17i_D { unsigned char v1; unsigned int v2:17; double v3; };
struct Uc_BFu17i_F { unsigned char v1; unsigned int v2:17; float v3; };
struct Uc_BFu17i_I { unsigned char v1; unsigned int v2:17; int v3; };
struct Uc_BFu17i_Ip { unsigned char v1; unsigned int v2:17; int * v3; };
struct Uc_BFu17i_L { unsigned char v1; unsigned int v2:17; long long v3; };
struct Uc_BFu17i_S { unsigned char v1; unsigned int v2:17; short v3; };
struct Uc_BFu17i_Uc { unsigned char v1; unsigned int v2:17; unsigned char v3; };
struct Uc_BFu17i_Ui { unsigned char v1; unsigned int v2:17; unsigned int v3; };
struct Uc_BFu17i_Ul { unsigned char v1; unsigned int v2:17; unsigned long long v3; };
struct Uc_BFu17i_Us { unsigned char v1; unsigned int v2:17; unsigned short v3; };
struct Uc_BFu17i_Vp { unsigned char v1; unsigned int v2:17; void * v3; };
struct Uc_BFu17ll { unsigned char v1; unsigned long long v2:17; };
struct Uc_BFu17ll_BFu15i { unsigned char v1; unsigned long long v2:17; unsigned int v3:15; };
struct Uc_BFu17ll_BFu15ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:15; };
struct Uc_BFu17ll_BFu15s { unsigned char v1; unsigned long long v2:17; unsigned short v3:15; };
struct Uc_BFu17ll_BFu16i { unsigned char v1; unsigned long long v2:17; unsigned int v3:16; };
struct Uc_BFu17ll_BFu16ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:16; };
struct Uc_BFu17ll_BFu16s { unsigned char v1; unsigned long long v2:17; unsigned short v3:16; };
struct Uc_BFu17ll_BFu17i { unsigned char v1; unsigned long long v2:17; unsigned int v3:17; };
struct Uc_BFu17ll_BFu17ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:17; };
struct Uc_BFu17ll_BFu1c { unsigned char v1; unsigned long long v2:17; unsigned char v3:1; };
struct Uc_BFu17ll_BFu1i { unsigned char v1; unsigned long long v2:17; unsigned int v3:1; };
struct Uc_BFu17ll_BFu1ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:1; };
struct Uc_BFu17ll_BFu1s { unsigned char v1; unsigned long long v2:17; unsigned short v3:1; };
struct Uc_BFu17ll_BFu31i { unsigned char v1; unsigned long long v2:17; unsigned int v3:31; };
struct Uc_BFu17ll_BFu31ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:31; };
struct Uc_BFu17ll_BFu32i { unsigned char v1; unsigned long long v2:17; unsigned int v3:32; };
struct Uc_BFu17ll_BFu32ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:32; };
struct Uc_BFu17ll_BFu33 { unsigned char v1; unsigned long long v2:17; unsigned long long v3:33; };
struct Uc_BFu17ll_BFu7c { unsigned char v1; unsigned long long v2:17; unsigned char v3:7; };
struct Uc_BFu17ll_BFu7i { unsigned char v1; unsigned long long v2:17; unsigned int v3:7; };
struct Uc_BFu17ll_BFu7ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:7; };
struct Uc_BFu17ll_BFu7s { unsigned char v1; unsigned long long v2:17; unsigned short v3:7; };
struct Uc_BFu17ll_BFu8c { unsigned char v1; unsigned long long v2:17; unsigned char v3:8; };
struct Uc_BFu17ll_BFu8i { unsigned char v1; unsigned long long v2:17; unsigned int v3:8; };
struct Uc_BFu17ll_BFu8ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:8; };
struct Uc_BFu17ll_BFu8s { unsigned char v1; unsigned long long v2:17; unsigned short v3:8; };
struct Uc_BFu17ll_BFu9i { unsigned char v1; unsigned long long v2:17; unsigned int v3:9; };
struct Uc_BFu17ll_BFu9ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:9; };
struct Uc_BFu17ll_BFu9s { unsigned char v1; unsigned long long v2:17; unsigned short v3:9; };
struct Uc_BFu17ll_C { unsigned char v1; unsigned long long v2:17; char v3; };
struct Uc_BFu17ll_D { unsigned char v1; unsigned long long v2:17; double v3; };
struct Uc_BFu17ll_F { unsigned char v1; unsigned long long v2:17; float v3; };
struct Uc_BFu17ll_I { unsigned char v1; unsigned long long v2:17; int v3; };
struct Uc_BFu17ll_Ip { unsigned char v1; unsigned long long v2:17; int * v3; };
struct Uc_BFu17ll_L { unsigned char v1; unsigned long long v2:17; long long v3; };
struct Uc_BFu17ll_S { unsigned char v1; unsigned long long v2:17; short v3; };
struct Uc_BFu17ll_Uc { unsigned char v1; unsigned long long v2:17; unsigned char v3; };
struct Uc_BFu17ll_Ui { unsigned char v1; unsigned long long v2:17; unsigned int v3; };
struct Uc_BFu17ll_Ul { unsigned char v1; unsigned long long v2:17; unsigned long long v3; };
struct Uc_BFu17ll_Us { unsigned char v1; unsigned long long v2:17; unsigned short v3; };
struct Uc_BFu17ll_Vp { unsigned char v1; unsigned long long v2:17; void * v3; };
struct Uc_BFu1c { unsigned char v1; unsigned char v2:1; };
struct Uc_BFu1c_BFu15i { unsigned char v1; unsigned char v2:1; unsigned int v3:15; };
struct Uc_BFu1c_BFu15ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:15; };
struct Uc_BFu1c_BFu15s { unsigned char v1; unsigned char v2:1; unsigned short v3:15; };
struct Uc_BFu1c_BFu16i { unsigned char v1; unsigned char v2:1; unsigned int v3:16; };
struct Uc_BFu1c_BFu16ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:16; };
struct Uc_BFu1c_BFu16s { unsigned char v1; unsigned char v2:1; unsigned short v3:16; };
struct Uc_BFu1c_BFu17i { unsigned char v1; unsigned char v2:1; unsigned int v3:17; };
struct Uc_BFu1c_BFu17ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:17; };
struct Uc_BFu1c_BFu1c { unsigned char v1; unsigned char v2:1; unsigned char v3:1; };
struct Uc_BFu1c_BFu1i { unsigned char v1; unsigned char v2:1; unsigned int v3:1; };
struct Uc_BFu1c_BFu1ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:1; };
struct Uc_BFu1c_BFu1s { unsigned char v1; unsigned char v2:1; unsigned short v3:1; };
struct Uc_BFu1c_BFu31i { unsigned char v1; unsigned char v2:1; unsigned int v3:31; };
struct Uc_BFu1c_BFu31ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:31; };
struct Uc_BFu1c_BFu32i { unsigned char v1; unsigned char v2:1; unsigned int v3:32; };
struct Uc_BFu1c_BFu32ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:32; };
struct Uc_BFu1c_BFu33 { unsigned char v1; unsigned char v2:1; unsigned long long v3:33; };
struct Uc_BFu1c_BFu7c { unsigned char v1; unsigned char v2:1; unsigned char v3:7; };
struct Uc_BFu1c_BFu7i { unsigned char v1; unsigned char v2:1; unsigned int v3:7; };
struct Uc_BFu1c_BFu7ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:7; };
struct Uc_BFu1c_BFu7s { unsigned char v1; unsigned char v2:1; unsigned short v3:7; };
struct Uc_BFu1c_BFu8c { unsigned char v1; unsigned char v2:1; unsigned char v3:8; };
struct Uc_BFu1c_BFu8i { unsigned char v1; unsigned char v2:1; unsigned int v3:8; };
struct Uc_BFu1c_BFu8ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:8; };
struct Uc_BFu1c_BFu8s { unsigned char v1; unsigned char v2:1; unsigned short v3:8; };
struct Uc_BFu1c_BFu9i { unsigned char v1; unsigned char v2:1; unsigned int v3:9; };
struct Uc_BFu1c_BFu9ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:9; };
struct Uc_BFu1c_BFu9s { unsigned char v1; unsigned char v2:1; unsigned short v3:9; };
struct Uc_BFu1c_C { unsigned char v1; unsigned char v2:1; char v3; };
struct Uc_BFu1c_D { unsigned char v1; unsigned char v2:1; double v3; };
struct Uc_BFu1c_F { unsigned char v1; unsigned char v2:1; float v3; };
struct Uc_BFu1c_I { unsigned char v1; unsigned char v2:1; int v3; };
struct Uc_BFu1c_Ip { unsigned char v1; unsigned char v2:1; int * v3; };
struct Uc_BFu1c_L { unsigned char v1; unsigned char v2:1; long long v3; };
struct Uc_BFu1c_S { unsigned char v1; unsigned char v2:1; short v3; };
struct Uc_BFu1c_Uc { unsigned char v1; unsigned char v2:1; unsigned char v3; };
struct Uc_BFu1c_Ui { unsigned char v1; unsigned char v2:1; unsigned int v3; };
struct Uc_BFu1c_Ul { unsigned char v1; unsigned char v2:1; unsigned long long v3; };
struct Uc_BFu1c_Us { unsigned char v1; unsigned char v2:1; unsigned short v3; };
struct Uc_BFu1c_Vp { unsigned char v1; unsigned char v2:1; void * v3; };
struct Uc_BFu1i { unsigned char v1; unsigned int v2:1; };
struct Uc_BFu1i_BFu15i { unsigned char v1; unsigned int v2:1; unsigned int v3:15; };
struct Uc_BFu1i_BFu15ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:15; };
struct Uc_BFu1i_BFu15s { unsigned char v1; unsigned int v2:1; unsigned short v3:15; };
struct Uc_BFu1i_BFu16i { unsigned char v1; unsigned int v2:1; unsigned int v3:16; };
struct Uc_BFu1i_BFu16ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:16; };
struct Uc_BFu1i_BFu16s { unsigned char v1; unsigned int v2:1; unsigned short v3:16; };
struct Uc_BFu1i_BFu17i { unsigned char v1; unsigned int v2:1; unsigned int v3:17; };
struct Uc_BFu1i_BFu17ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:17; };
struct Uc_BFu1i_BFu1c { unsigned char v1; unsigned int v2:1; unsigned char v3:1; };
struct Uc_BFu1i_BFu1i { unsigned char v1; unsigned int v2:1; unsigned int v3:1; };
struct Uc_BFu1i_BFu1ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:1; };
struct Uc_BFu1i_BFu1s { unsigned char v1; unsigned int v2:1; unsigned short v3:1; };
struct Uc_BFu1i_BFu31i { unsigned char v1; unsigned int v2:1; unsigned int v3:31; };
struct Uc_BFu1i_BFu31ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:31; };
struct Uc_BFu1i_BFu32i { unsigned char v1; unsigned int v2:1; unsigned int v3:32; };
struct Uc_BFu1i_BFu32ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:32; };
struct Uc_BFu1i_BFu33 { unsigned char v1; unsigned int v2:1; unsigned long long v3:33; };
struct Uc_BFu1i_BFu7c { unsigned char v1; unsigned int v2:1; unsigned char v3:7; };
struct Uc_BFu1i_BFu7i { unsigned char v1; unsigned int v2:1; unsigned int v3:7; };
struct Uc_BFu1i_BFu7ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:7; };
struct Uc_BFu1i_BFu7s { unsigned char v1; unsigned int v2:1; unsigned short v3:7; };
struct Uc_BFu1i_BFu8c { unsigned char v1; unsigned int v2:1; unsigned char v3:8; };
struct Uc_BFu1i_BFu8i { unsigned char v1; unsigned int v2:1; unsigned int v3:8; };
struct Uc_BFu1i_BFu8ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:8; };
struct Uc_BFu1i_BFu8s { unsigned char v1; unsigned int v2:1; unsigned short v3:8; };
struct Uc_BFu1i_BFu9i { unsigned char v1; unsigned int v2:1; unsigned int v3:9; };
struct Uc_BFu1i_BFu9ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:9; };
struct Uc_BFu1i_BFu9s { unsigned char v1; unsigned int v2:1; unsigned short v3:9; };
struct Uc_BFu1i_C { unsigned char v1; unsigned int v2:1; char v3; };
struct Uc_BFu1i_D { unsigned char v1; unsigned int v2:1; double v3; };
struct Uc_BFu1i_F { unsigned char v1; unsigned int v2:1; float v3; };
struct Uc_BFu1i_I { unsigned char v1; unsigned int v2:1; int v3; };
struct Uc_BFu1i_Ip { unsigned char v1; unsigned int v2:1; int * v3; };
struct Uc_BFu1i_L { unsigned char v1; unsigned int v2:1; long long v3; };
struct Uc_BFu1i_S { unsigned char v1; unsigned int v2:1; short v3; };
struct Uc_BFu1i_Uc { unsigned char v1; unsigned int v2:1; unsigned char v3; };
struct Uc_BFu1i_Ui { unsigned char v1; unsigned int v2:1; unsigned int v3; };
struct Uc_BFu1i_Ul { unsigned char v1; unsigned int v2:1; unsigned long long v3; };
struct Uc_BFu1i_Us { unsigned char v1; unsigned int v2:1; unsigned short v3; };
struct Uc_BFu1i_Vp { unsigned char v1; unsigned int v2:1; void * v3; };
struct Uc_BFu1ll { unsigned char v1; unsigned long long v2:1; };
struct Uc_BFu1ll_BFu15i { unsigned char v1; unsigned long long v2:1; unsigned int v3:15; };
struct Uc_BFu1ll_BFu15ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:15; };
struct Uc_BFu1ll_BFu15s { unsigned char v1; unsigned long long v2:1; unsigned short v3:15; };
struct Uc_BFu1ll_BFu16i { unsigned char v1; unsigned long long v2:1; unsigned int v3:16; };
struct Uc_BFu1ll_BFu16ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:16; };
struct Uc_BFu1ll_BFu16s { unsigned char v1; unsigned long long v2:1; unsigned short v3:16; };
struct Uc_BFu1ll_BFu17i { unsigned char v1; unsigned long long v2:1; unsigned int v3:17; };
struct Uc_BFu1ll_BFu17ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:17; };
struct Uc_BFu1ll_BFu1c { unsigned char v1; unsigned long long v2:1; unsigned char v3:1; };
struct Uc_BFu1ll_BFu1i { unsigned char v1; unsigned long long v2:1; unsigned int v3:1; };
struct Uc_BFu1ll_BFu1ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:1; };
struct Uc_BFu1ll_BFu1s { unsigned char v1; unsigned long long v2:1; unsigned short v3:1; };
struct Uc_BFu1ll_BFu31i { unsigned char v1; unsigned long long v2:1; unsigned int v3:31; };
struct Uc_BFu1ll_BFu31ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:31; };
struct Uc_BFu1ll_BFu32i { unsigned char v1; unsigned long long v2:1; unsigned int v3:32; };
struct Uc_BFu1ll_BFu32ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:32; };
struct Uc_BFu1ll_BFu33 { unsigned char v1; unsigned long long v2:1; unsigned long long v3:33; };
struct Uc_BFu1ll_BFu7c { unsigned char v1; unsigned long long v2:1; unsigned char v3:7; };
struct Uc_BFu1ll_BFu7i { unsigned char v1; unsigned long long v2:1; unsigned int v3:7; };
struct Uc_BFu1ll_BFu7ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:7; };
struct Uc_BFu1ll_BFu7s { unsigned char v1; unsigned long long v2:1; unsigned short v3:7; };
struct Uc_BFu1ll_BFu8c { unsigned char v1; unsigned long long v2:1; unsigned char v3:8; };
struct Uc_BFu1ll_BFu8i { unsigned char v1; unsigned long long v2:1; unsigned int v3:8; };
struct Uc_BFu1ll_BFu8ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:8; };
struct Uc_BFu1ll_BFu8s { unsigned char v1; unsigned long long v2:1; unsigned short v3:8; };
struct Uc_BFu1ll_BFu9i { unsigned char v1; unsigned long long v2:1; unsigned int v3:9; };
struct Uc_BFu1ll_BFu9ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:9; };
struct Uc_BFu1ll_BFu9s { unsigned char v1; unsigned long long v2:1; unsigned short v3:9; };
struct Uc_BFu1ll_C { unsigned char v1; unsigned long long v2:1; char v3; };
struct Uc_BFu1ll_D { unsigned char v1; unsigned long long v2:1; double v3; };
struct Uc_BFu1ll_F { unsigned char v1; unsigned long long v2:1; float v3; };
struct Uc_BFu1ll_I { unsigned char v1; unsigned long long v2:1; int v3; };
struct Uc_BFu1ll_Ip { unsigned char v1; unsigned long long v2:1; int * v3; };
struct Uc_BFu1ll_L { unsigned char v1; unsigned long long v2:1; long long v3; };
struct Uc_BFu1ll_S { unsigned char v1; unsigned long long v2:1; short v3; };
struct Uc_BFu1ll_Uc { unsigned char v1; unsigned long long v2:1; unsigned char v3; };
struct Uc_BFu1ll_Ui { unsigned char v1; unsigned long long v2:1; unsigned int v3; };
struct Uc_BFu1ll_Ul { unsigned char v1; unsigned long long v2:1; unsigned long long v3; };
struct Uc_BFu1ll_Us { unsigned char v1; unsigned long long v2:1; unsigned short v3; };
struct Uc_BFu1ll_Vp { unsigned char v1; unsigned long long v2:1; void * v3; };
struct Uc_BFu1s { unsigned char v1; unsigned short v2:1; };
struct Uc_BFu1s_BFu15i { unsigned char v1; unsigned short v2:1; unsigned int v3:15; };
struct Uc_BFu1s_BFu15ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:15; };
struct Uc_BFu1s_BFu15s { unsigned char v1; unsigned short v2:1; unsigned short v3:15; };
struct Uc_BFu1s_BFu16i { unsigned char v1; unsigned short v2:1; unsigned int v3:16; };
struct Uc_BFu1s_BFu16ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:16; };
struct Uc_BFu1s_BFu16s { unsigned char v1; unsigned short v2:1; unsigned short v3:16; };
struct Uc_BFu1s_BFu17i { unsigned char v1; unsigned short v2:1; unsigned int v3:17; };
struct Uc_BFu1s_BFu17ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:17; };
struct Uc_BFu1s_BFu1c { unsigned char v1; unsigned short v2:1; unsigned char v3:1; };
struct Uc_BFu1s_BFu1i { unsigned char v1; unsigned short v2:1; unsigned int v3:1; };
struct Uc_BFu1s_BFu1ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:1; };
struct Uc_BFu1s_BFu1s { unsigned char v1; unsigned short v2:1; unsigned short v3:1; };
struct Uc_BFu1s_BFu31i { unsigned char v1; unsigned short v2:1; unsigned int v3:31; };
struct Uc_BFu1s_BFu31ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:31; };
struct Uc_BFu1s_BFu32i { unsigned char v1; unsigned short v2:1; unsigned int v3:32; };
struct Uc_BFu1s_BFu32ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:32; };
struct Uc_BFu1s_BFu33 { unsigned char v1; unsigned short v2:1; unsigned long long v3:33; };
struct Uc_BFu1s_BFu7c { unsigned char v1; unsigned short v2:1; unsigned char v3:7; };
struct Uc_BFu1s_BFu7i { unsigned char v1; unsigned short v2:1; unsigned int v3:7; };
struct Uc_BFu1s_BFu7ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:7; };
struct Uc_BFu1s_BFu7s { unsigned char v1; unsigned short v2:1; unsigned short v3:7; };
struct Uc_BFu1s_BFu8c { unsigned char v1; unsigned short v2:1; unsigned char v3:8; };
struct Uc_BFu1s_BFu8i { unsigned char v1; unsigned short v2:1; unsigned int v3:8; };
struct Uc_BFu1s_BFu8ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:8; };
struct Uc_BFu1s_BFu8s { unsigned char v1; unsigned short v2:1; unsigned short v3:8; };
struct Uc_BFu1s_BFu9i { unsigned char v1; unsigned short v2:1; unsigned int v3:9; };
struct Uc_BFu1s_BFu9ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:9; };
struct Uc_BFu1s_BFu9s { unsigned char v1; unsigned short v2:1; unsigned short v3:9; };
struct Uc_BFu1s_C { unsigned char v1; unsigned short v2:1; char v3; };
struct Uc_BFu1s_D { unsigned char v1; unsigned short v2:1; double v3; };
struct Uc_BFu1s_F { unsigned char v1; unsigned short v2:1; float v3; };
struct Uc_BFu1s_I { unsigned char v1; unsigned short v2:1; int v3; };
struct Uc_BFu1s_Ip { unsigned char v1; unsigned short v2:1; int * v3; };
struct Uc_BFu1s_L { unsigned char v1; unsigned short v2:1; long long v3; };
struct Uc_BFu1s_S { unsigned char v1; unsigned short v2:1; short v3; };
struct Uc_BFu1s_Uc { unsigned char v1; unsigned short v2:1; unsigned char v3; };
struct Uc_BFu1s_Ui { unsigned char v1; unsigned short v2:1; unsigned int v3; };
struct Uc_BFu1s_Ul { unsigned char v1; unsigned short v2:1; unsigned long long v3; };
struct Uc_BFu1s_Us { unsigned char v1; unsigned short v2:1; unsigned short v3; };
struct Uc_BFu1s_Vp { unsigned char v1; unsigned short v2:1; void * v3; };
struct Uc_BFu31i { unsigned char v1; unsigned int v2:31; };
struct Uc_BFu31i_BFu15i { unsigned char v1; unsigned int v2:31; unsigned int v3:15; };
struct Uc_BFu31i_BFu15ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:15; };
struct Uc_BFu31i_BFu15s { unsigned char v1; unsigned int v2:31; unsigned short v3:15; };
struct Uc_BFu31i_BFu16i { unsigned char v1; unsigned int v2:31; unsigned int v3:16; };
struct Uc_BFu31i_BFu16ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:16; };
struct Uc_BFu31i_BFu16s { unsigned char v1; unsigned int v2:31; unsigned short v3:16; };
struct Uc_BFu31i_BFu17i { unsigned char v1; unsigned int v2:31; unsigned int v3:17; };
struct Uc_BFu31i_BFu17ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:17; };
struct Uc_BFu31i_BFu1c { unsigned char v1; unsigned int v2:31; unsigned char v3:1; };
struct Uc_BFu31i_BFu1i { unsigned char v1; unsigned int v2:31; unsigned int v3:1; };
struct Uc_BFu31i_BFu1ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:1; };
struct Uc_BFu31i_BFu1s { unsigned char v1; unsigned int v2:31; unsigned short v3:1; };
struct Uc_BFu31i_BFu31i { unsigned char v1; unsigned int v2:31; unsigned int v3:31; };
struct Uc_BFu31i_BFu31ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:31; };
struct Uc_BFu31i_BFu32i { unsigned char v1; unsigned int v2:31; unsigned int v3:32; };
struct Uc_BFu31i_BFu32ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:32; };
struct Uc_BFu31i_BFu33 { unsigned char v1; unsigned int v2:31; unsigned long long v3:33; };
struct Uc_BFu31i_BFu7c { unsigned char v1; unsigned int v2:31; unsigned char v3:7; };
struct Uc_BFu31i_BFu7i { unsigned char v1; unsigned int v2:31; unsigned int v3:7; };
struct Uc_BFu31i_BFu7ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:7; };
struct Uc_BFu31i_BFu7s { unsigned char v1; unsigned int v2:31; unsigned short v3:7; };
struct Uc_BFu31i_BFu8c { unsigned char v1; unsigned int v2:31; unsigned char v3:8; };
struct Uc_BFu31i_BFu8i { unsigned char v1; unsigned int v2:31; unsigned int v3:8; };
struct Uc_BFu31i_BFu8ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:8; };
struct Uc_BFu31i_BFu8s { unsigned char v1; unsigned int v2:31; unsigned short v3:8; };
struct Uc_BFu31i_BFu9i { unsigned char v1; unsigned int v2:31; unsigned int v3:9; };
struct Uc_BFu31i_BFu9ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:9; };
struct Uc_BFu31i_BFu9s { unsigned char v1; unsigned int v2:31; unsigned short v3:9; };
struct Uc_BFu31i_C { unsigned char v1; unsigned int v2:31; char v3; };
struct Uc_BFu31i_D { unsigned char v1; unsigned int v2:31; double v3; };
struct Uc_BFu31i_F { unsigned char v1; unsigned int v2:31; float v3; };
struct Uc_BFu31i_I { unsigned char v1; unsigned int v2:31; int v3; };
struct Uc_BFu31i_Ip { unsigned char v1; unsigned int v2:31; int * v3; };
struct Uc_BFu31i_L { unsigned char v1; unsigned int v2:31; long long v3; };
struct Uc_BFu31i_S { unsigned char v1; unsigned int v2:31; short v3; };
struct Uc_BFu31i_Uc { unsigned char v1; unsigned int v2:31; unsigned char v3; };
struct Uc_BFu31i_Ui { unsigned char v1; unsigned int v2:31; unsigned int v3; };
struct Uc_BFu31i_Ul { unsigned char v1; unsigned int v2:31; unsigned long long v3; };
struct Uc_BFu31i_Us { unsigned char v1; unsigned int v2:31; unsigned short v3; };
struct Uc_BFu31i_Vp { unsigned char v1; unsigned int v2:31; void * v3; };
struct Uc_BFu31ll { unsigned char v1; unsigned long long v2:31; };
struct Uc_BFu31ll_BFu15i { unsigned char v1; unsigned long long v2:31; unsigned int v3:15; };
struct Uc_BFu31ll_BFu15ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:15; };
struct Uc_BFu31ll_BFu15s { unsigned char v1; unsigned long long v2:31; unsigned short v3:15; };
struct Uc_BFu31ll_BFu16i { unsigned char v1; unsigned long long v2:31; unsigned int v3:16; };
struct Uc_BFu31ll_BFu16ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:16; };
struct Uc_BFu31ll_BFu16s { unsigned char v1; unsigned long long v2:31; unsigned short v3:16; };
struct Uc_BFu31ll_BFu17i { unsigned char v1; unsigned long long v2:31; unsigned int v3:17; };
struct Uc_BFu31ll_BFu17ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:17; };
struct Uc_BFu31ll_BFu1c { unsigned char v1; unsigned long long v2:31; unsigned char v3:1; };
struct Uc_BFu31ll_BFu1i { unsigned char v1; unsigned long long v2:31; unsigned int v3:1; };
struct Uc_BFu31ll_BFu1ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:1; };
struct Uc_BFu31ll_BFu1s { unsigned char v1; unsigned long long v2:31; unsigned short v3:1; };
struct Uc_BFu31ll_BFu31i { unsigned char v1; unsigned long long v2:31; unsigned int v3:31; };
struct Uc_BFu31ll_BFu31ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:31; };
struct Uc_BFu31ll_BFu32i { unsigned char v1; unsigned long long v2:31; unsigned int v3:32; };
struct Uc_BFu31ll_BFu32ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:32; };
struct Uc_BFu31ll_BFu33 { unsigned char v1; unsigned long long v2:31; unsigned long long v3:33; };
struct Uc_BFu31ll_BFu7c { unsigned char v1; unsigned long long v2:31; unsigned char v3:7; };
struct Uc_BFu31ll_BFu7i { unsigned char v1; unsigned long long v2:31; unsigned int v3:7; };
struct Uc_BFu31ll_BFu7ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:7; };
struct Uc_BFu31ll_BFu7s { unsigned char v1; unsigned long long v2:31; unsigned short v3:7; };
struct Uc_BFu31ll_BFu8c { unsigned char v1; unsigned long long v2:31; unsigned char v3:8; };
struct Uc_BFu31ll_BFu8i { unsigned char v1; unsigned long long v2:31; unsigned int v3:8; };
struct Uc_BFu31ll_BFu8ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:8; };
struct Uc_BFu31ll_BFu8s { unsigned char v1; unsigned long long v2:31; unsigned short v3:8; };
struct Uc_BFu31ll_BFu9i { unsigned char v1; unsigned long long v2:31; unsigned int v3:9; };
struct Uc_BFu31ll_BFu9ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:9; };
struct Uc_BFu31ll_BFu9s { unsigned char v1; unsigned long long v2:31; unsigned short v3:9; };
struct Uc_BFu31ll_C { unsigned char v1; unsigned long long v2:31; char v3; };
struct Uc_BFu31ll_D { unsigned char v1; unsigned long long v2:31; double v3; };
struct Uc_BFu31ll_F { unsigned char v1; unsigned long long v2:31; float v3; };
struct Uc_BFu31ll_I { unsigned char v1; unsigned long long v2:31; int v3; };
struct Uc_BFu31ll_Ip { unsigned char v1; unsigned long long v2:31; int * v3; };
struct Uc_BFu31ll_L { unsigned char v1; unsigned long long v2:31; long long v3; };
struct Uc_BFu31ll_S { unsigned char v1; unsigned long long v2:31; short v3; };
struct Uc_BFu31ll_Uc { unsigned char v1; unsigned long long v2:31; unsigned char v3; };
struct Uc_BFu31ll_Ui { unsigned char v1; unsigned long long v2:31; unsigned int v3; };
struct Uc_BFu31ll_Ul { unsigned char v1; unsigned long long v2:31; unsigned long long v3; };
struct Uc_BFu31ll_Us { unsigned char v1; unsigned long long v2:31; unsigned short v3; };
struct Uc_BFu31ll_Vp { unsigned char v1; unsigned long long v2:31; void * v3; };
struct Uc_BFu32i { unsigned char v1; unsigned int v2:32; };
struct Uc_BFu32i_BFu15i { unsigned char v1; unsigned int v2:32; unsigned int v3:15; };
struct Uc_BFu32i_BFu15ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:15; };
struct Uc_BFu32i_BFu15s { unsigned char v1; unsigned int v2:32; unsigned short v3:15; };
struct Uc_BFu32i_BFu16i { unsigned char v1; unsigned int v2:32; unsigned int v3:16; };
struct Uc_BFu32i_BFu16ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:16; };
struct Uc_BFu32i_BFu16s { unsigned char v1; unsigned int v2:32; unsigned short v3:16; };
struct Uc_BFu32i_BFu17i { unsigned char v1; unsigned int v2:32; unsigned int v3:17; };
struct Uc_BFu32i_BFu17ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:17; };
struct Uc_BFu32i_BFu1c { unsigned char v1; unsigned int v2:32; unsigned char v3:1; };
struct Uc_BFu32i_BFu1i { unsigned char v1; unsigned int v2:32; unsigned int v3:1; };
struct Uc_BFu32i_BFu1ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:1; };
struct Uc_BFu32i_BFu1s { unsigned char v1; unsigned int v2:32; unsigned short v3:1; };
struct Uc_BFu32i_BFu31i { unsigned char v1; unsigned int v2:32; unsigned int v3:31; };
struct Uc_BFu32i_BFu31ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:31; };
struct Uc_BFu32i_BFu32i { unsigned char v1; unsigned int v2:32; unsigned int v3:32; };
struct Uc_BFu32i_BFu32ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:32; };
struct Uc_BFu32i_BFu33 { unsigned char v1; unsigned int v2:32; unsigned long long v3:33; };
struct Uc_BFu32i_BFu7c { unsigned char v1; unsigned int v2:32; unsigned char v3:7; };
struct Uc_BFu32i_BFu7i { unsigned char v1; unsigned int v2:32; unsigned int v3:7; };
struct Uc_BFu32i_BFu7ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:7; };
struct Uc_BFu32i_BFu7s { unsigned char v1; unsigned int v2:32; unsigned short v3:7; };
struct Uc_BFu32i_BFu8c { unsigned char v1; unsigned int v2:32; unsigned char v3:8; };
struct Uc_BFu32i_BFu8i { unsigned char v1; unsigned int v2:32; unsigned int v3:8; };
struct Uc_BFu32i_BFu8ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:8; };
struct Uc_BFu32i_BFu8s { unsigned char v1; unsigned int v2:32; unsigned short v3:8; };
struct Uc_BFu32i_BFu9i { unsigned char v1; unsigned int v2:32; unsigned int v3:9; };
struct Uc_BFu32i_BFu9ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:9; };
struct Uc_BFu32i_BFu9s { unsigned char v1; unsigned int v2:32; unsigned short v3:9; };
struct Uc_BFu32i_C { unsigned char v1; unsigned int v2:32; char v3; };
struct Uc_BFu32i_D { unsigned char v1; unsigned int v2:32; double v3; };
struct Uc_BFu32i_F { unsigned char v1; unsigned int v2:32; float v3; };
struct Uc_BFu32i_I { unsigned char v1; unsigned int v2:32; int v3; };
struct Uc_BFu32i_Ip { unsigned char v1; unsigned int v2:32; int * v3; };
struct Uc_BFu32i_L { unsigned char v1; unsigned int v2:32; long long v3; };
struct Uc_BFu32i_S { unsigned char v1; unsigned int v2:32; short v3; };
struct Uc_BFu32i_Uc { unsigned char v1; unsigned int v2:32; unsigned char v3; };
struct Uc_BFu32i_Ui { unsigned char v1; unsigned int v2:32; unsigned int v3; };
struct Uc_BFu32i_Ul { unsigned char v1; unsigned int v2:32; unsigned long long v3; };
struct Uc_BFu32i_Us { unsigned char v1; unsigned int v2:32; unsigned short v3; };
struct Uc_BFu32i_Vp { unsigned char v1; unsigned int v2:32; void * v3; };
struct Uc_BFu32ll { unsigned char v1; unsigned long long v2:32; };
struct Uc_BFu32ll_BFu15i { unsigned char v1; unsigned long long v2:32; unsigned int v3:15; };
struct Uc_BFu32ll_BFu15ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:15; };
struct Uc_BFu32ll_BFu15s { unsigned char v1; unsigned long long v2:32; unsigned short v3:15; };
struct Uc_BFu32ll_BFu16i { unsigned char v1; unsigned long long v2:32; unsigned int v3:16; };
struct Uc_BFu32ll_BFu16ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:16; };
struct Uc_BFu32ll_BFu16s { unsigned char v1; unsigned long long v2:32; unsigned short v3:16; };
struct Uc_BFu32ll_BFu17i { unsigned char v1; unsigned long long v2:32; unsigned int v3:17; };
struct Uc_BFu32ll_BFu17ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:17; };
struct Uc_BFu32ll_BFu1c { unsigned char v1; unsigned long long v2:32; unsigned char v3:1; };
struct Uc_BFu32ll_BFu1i { unsigned char v1; unsigned long long v2:32; unsigned int v3:1; };
struct Uc_BFu32ll_BFu1ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:1; };
struct Uc_BFu32ll_BFu1s { unsigned char v1; unsigned long long v2:32; unsigned short v3:1; };
struct Uc_BFu32ll_BFu31i { unsigned char v1; unsigned long long v2:32; unsigned int v3:31; };
struct Uc_BFu32ll_BFu31ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:31; };
struct Uc_BFu32ll_BFu32i { unsigned char v1; unsigned long long v2:32; unsigned int v3:32; };
struct Uc_BFu32ll_BFu32ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:32; };
struct Uc_BFu32ll_BFu33 { unsigned char v1; unsigned long long v2:32; unsigned long long v3:33; };
struct Uc_BFu32ll_BFu7c { unsigned char v1; unsigned long long v2:32; unsigned char v3:7; };
struct Uc_BFu32ll_BFu7i { unsigned char v1; unsigned long long v2:32; unsigned int v3:7; };
struct Uc_BFu32ll_BFu7ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:7; };
struct Uc_BFu32ll_BFu7s { unsigned char v1; unsigned long long v2:32; unsigned short v3:7; };
struct Uc_BFu32ll_BFu8c { unsigned char v1; unsigned long long v2:32; unsigned char v3:8; };
struct Uc_BFu32ll_BFu8i { unsigned char v1; unsigned long long v2:32; unsigned int v3:8; };
struct Uc_BFu32ll_BFu8ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:8; };
struct Uc_BFu32ll_BFu8s { unsigned char v1; unsigned long long v2:32; unsigned short v3:8; };
struct Uc_BFu32ll_BFu9i { unsigned char v1; unsigned long long v2:32; unsigned int v3:9; };
struct Uc_BFu32ll_BFu9ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:9; };
struct Uc_BFu32ll_BFu9s { unsigned char v1; unsigned long long v2:32; unsigned short v3:9; };
struct Uc_BFu32ll_C { unsigned char v1; unsigned long long v2:32; char v3; };
struct Uc_BFu32ll_D { unsigned char v1; unsigned long long v2:32; double v3; };
struct Uc_BFu32ll_F { unsigned char v1; unsigned long long v2:32; float v3; };
struct Uc_BFu32ll_I { unsigned char v1; unsigned long long v2:32; int v3; };
struct Uc_BFu32ll_Ip { unsigned char v1; unsigned long long v2:32; int * v3; };
struct Uc_BFu32ll_L { unsigned char v1; unsigned long long v2:32; long long v3; };
struct Uc_BFu32ll_S { unsigned char v1; unsigned long long v2:32; short v3; };
struct Uc_BFu32ll_Uc { unsigned char v1; unsigned long long v2:32; unsigned char v3; };
struct Uc_BFu32ll_Ui { unsigned char v1; unsigned long long v2:32; unsigned int v3; };
struct Uc_BFu32ll_Ul { unsigned char v1; unsigned long long v2:32; unsigned long long v3; };
struct Uc_BFu32ll_Us { unsigned char v1; unsigned long long v2:32; unsigned short v3; };
struct Uc_BFu32ll_Vp { unsigned char v1; unsigned long long v2:32; void * v3; };
struct Uc_BFu33 { unsigned char v1; unsigned long long v2:33; };
struct Uc_BFu33_BFu15i { unsigned char v1; unsigned long long v2:33; unsigned int v3:15; };
struct Uc_BFu33_BFu15ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:15; };
struct Uc_BFu33_BFu15s { unsigned char v1; unsigned long long v2:33; unsigned short v3:15; };
struct Uc_BFu33_BFu16i { unsigned char v1; unsigned long long v2:33; unsigned int v3:16; };
struct Uc_BFu33_BFu16ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:16; };
struct Uc_BFu33_BFu16s { unsigned char v1; unsigned long long v2:33; unsigned short v3:16; };
struct Uc_BFu33_BFu17i { unsigned char v1; unsigned long long v2:33; unsigned int v3:17; };
struct Uc_BFu33_BFu17ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:17; };
struct Uc_BFu33_BFu1c { unsigned char v1; unsigned long long v2:33; unsigned char v3:1; };
struct Uc_BFu33_BFu1i { unsigned char v1; unsigned long long v2:33; unsigned int v3:1; };
struct Uc_BFu33_BFu1ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:1; };
struct Uc_BFu33_BFu1s { unsigned char v1; unsigned long long v2:33; unsigned short v3:1; };
struct Uc_BFu33_BFu31i { unsigned char v1; unsigned long long v2:33; unsigned int v3:31; };
struct Uc_BFu33_BFu31ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:31; };
struct Uc_BFu33_BFu32i { unsigned char v1; unsigned long long v2:33; unsigned int v3:32; };
struct Uc_BFu33_BFu32ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:32; };
struct Uc_BFu33_BFu33 { unsigned char v1; unsigned long long v2:33; unsigned long long v3:33; };
struct Uc_BFu33_BFu7c { unsigned char v1; unsigned long long v2:33; unsigned char v3:7; };
struct Uc_BFu33_BFu7i { unsigned char v1; unsigned long long v2:33; unsigned int v3:7; };
struct Uc_BFu33_BFu7ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:7; };
struct Uc_BFu33_BFu7s { unsigned char v1; unsigned long long v2:33; unsigned short v3:7; };
struct Uc_BFu33_BFu8c { unsigned char v1; unsigned long long v2:33; unsigned char v3:8; };
struct Uc_BFu33_BFu8i { unsigned char v1; unsigned long long v2:33; unsigned int v3:8; };
struct Uc_BFu33_BFu8ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:8; };
struct Uc_BFu33_BFu8s { unsigned char v1; unsigned long long v2:33; unsigned short v3:8; };
struct Uc_BFu33_BFu9i { unsigned char v1; unsigned long long v2:33; unsigned int v3:9; };
struct Uc_BFu33_BFu9ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:9; };
struct Uc_BFu33_BFu9s { unsigned char v1; unsigned long long v2:33; unsigned short v3:9; };
struct Uc_BFu33_C { unsigned char v1; unsigned long long v2:33; char v3; };
struct Uc_BFu33_D { unsigned char v1; unsigned long long v2:33; double v3; };
struct Uc_BFu33_F { unsigned char v1; unsigned long long v2:33; float v3; };
struct Uc_BFu33_I { unsigned char v1; unsigned long long v2:33; int v3; };
struct Uc_BFu33_Ip { unsigned char v1; unsigned long long v2:33; int * v3; };
struct Uc_BFu33_L { unsigned char v1; unsigned long long v2:33; long long v3; };
struct Uc_BFu33_S { unsigned char v1; unsigned long long v2:33; short v3; };
struct Uc_BFu33_Uc { unsigned char v1; unsigned long long v2:33; unsigned char v3; };
struct Uc_BFu33_Ui { unsigned char v1; unsigned long long v2:33; unsigned int v3; };
struct Uc_BFu33_Ul { unsigned char v1; unsigned long long v2:33; unsigned long long v3; };
struct Uc_BFu33_Us { unsigned char v1; unsigned long long v2:33; unsigned short v3; };
struct Uc_BFu33_Vp { unsigned char v1; unsigned long long v2:33; void * v3; };
struct Uc_BFu7c { unsigned char v1; unsigned char v2:7; };
struct Uc_BFu7c_BFu15i { unsigned char v1; unsigned char v2:7; unsigned int v3:15; };
struct Uc_BFu7c_BFu15ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:15; };
struct Uc_BFu7c_BFu15s { unsigned char v1; unsigned char v2:7; unsigned short v3:15; };
struct Uc_BFu7c_BFu16i { unsigned char v1; unsigned char v2:7; unsigned int v3:16; };
struct Uc_BFu7c_BFu16ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:16; };
struct Uc_BFu7c_BFu16s { unsigned char v1; unsigned char v2:7; unsigned short v3:16; };
struct Uc_BFu7c_BFu17i { unsigned char v1; unsigned char v2:7; unsigned int v3:17; };
struct Uc_BFu7c_BFu17ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:17; };
struct Uc_BFu7c_BFu1c { unsigned char v1; unsigned char v2:7; unsigned char v3:1; };
struct Uc_BFu7c_BFu1i { unsigned char v1; unsigned char v2:7; unsigned int v3:1; };
struct Uc_BFu7c_BFu1ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:1; };
struct Uc_BFu7c_BFu1s { unsigned char v1; unsigned char v2:7; unsigned short v3:1; };
struct Uc_BFu7c_BFu31i { unsigned char v1; unsigned char v2:7; unsigned int v3:31; };
struct Uc_BFu7c_BFu31ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:31; };
struct Uc_BFu7c_BFu32i { unsigned char v1; unsigned char v2:7; unsigned int v3:32; };
struct Uc_BFu7c_BFu32ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:32; };
struct Uc_BFu7c_BFu33 { unsigned char v1; unsigned char v2:7; unsigned long long v3:33; };
struct Uc_BFu7c_BFu7c { unsigned char v1; unsigned char v2:7; unsigned char v3:7; };
struct Uc_BFu7c_BFu7i { unsigned char v1; unsigned char v2:7; unsigned int v3:7; };
struct Uc_BFu7c_BFu7ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:7; };
struct Uc_BFu7c_BFu7s { unsigned char v1; unsigned char v2:7; unsigned short v3:7; };
struct Uc_BFu7c_BFu8c { unsigned char v1; unsigned char v2:7; unsigned char v3:8; };
struct Uc_BFu7c_BFu8i { unsigned char v1; unsigned char v2:7; unsigned int v3:8; };
struct Uc_BFu7c_BFu8ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:8; };
struct Uc_BFu7c_BFu8s { unsigned char v1; unsigned char v2:7; unsigned short v3:8; };
struct Uc_BFu7c_BFu9i { unsigned char v1; unsigned char v2:7; unsigned int v3:9; };
struct Uc_BFu7c_BFu9ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:9; };
struct Uc_BFu7c_BFu9s { unsigned char v1; unsigned char v2:7; unsigned short v3:9; };
struct Uc_BFu7c_C { unsigned char v1; unsigned char v2:7; char v3; };
struct Uc_BFu7c_D { unsigned char v1; unsigned char v2:7; double v3; };
struct Uc_BFu7c_F { unsigned char v1; unsigned char v2:7; float v3; };
struct Uc_BFu7c_I { unsigned char v1; unsigned char v2:7; int v3; };
struct Uc_BFu7c_Ip { unsigned char v1; unsigned char v2:7; int * v3; };
struct Uc_BFu7c_L { unsigned char v1; unsigned char v2:7; long long v3; };
struct Uc_BFu7c_S { unsigned char v1; unsigned char v2:7; short v3; };
struct Uc_BFu7c_Uc { unsigned char v1; unsigned char v2:7; unsigned char v3; };
struct Uc_BFu7c_Ui { unsigned char v1; unsigned char v2:7; unsigned int v3; };
struct Uc_BFu7c_Ul { unsigned char v1; unsigned char v2:7; unsigned long long v3; };
struct Uc_BFu7c_Us { unsigned char v1; unsigned char v2:7; unsigned short v3; };
struct Uc_BFu7c_Vp { unsigned char v1; unsigned char v2:7; void * v3; };
struct Uc_BFu7i { unsigned char v1; unsigned int v2:7; };
struct Uc_BFu7i_BFu15i { unsigned char v1; unsigned int v2:7; unsigned int v3:15; };
struct Uc_BFu7i_BFu15ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:15; };
struct Uc_BFu7i_BFu15s { unsigned char v1; unsigned int v2:7; unsigned short v3:15; };
struct Uc_BFu7i_BFu16i { unsigned char v1; unsigned int v2:7; unsigned int v3:16; };
struct Uc_BFu7i_BFu16ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:16; };
struct Uc_BFu7i_BFu16s { unsigned char v1; unsigned int v2:7; unsigned short v3:16; };
struct Uc_BFu7i_BFu17i { unsigned char v1; unsigned int v2:7; unsigned int v3:17; };
struct Uc_BFu7i_BFu17ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:17; };
struct Uc_BFu7i_BFu1c { unsigned char v1; unsigned int v2:7; unsigned char v3:1; };
struct Uc_BFu7i_BFu1i { unsigned char v1; unsigned int v2:7; unsigned int v3:1; };
struct Uc_BFu7i_BFu1ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:1; };
struct Uc_BFu7i_BFu1s { unsigned char v1; unsigned int v2:7; unsigned short v3:1; };
struct Uc_BFu7i_BFu31i { unsigned char v1; unsigned int v2:7; unsigned int v3:31; };
struct Uc_BFu7i_BFu31ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:31; };
struct Uc_BFu7i_BFu32i { unsigned char v1; unsigned int v2:7; unsigned int v3:32; };
struct Uc_BFu7i_BFu32ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:32; };
struct Uc_BFu7i_BFu33 { unsigned char v1; unsigned int v2:7; unsigned long long v3:33; };
struct Uc_BFu7i_BFu7c { unsigned char v1; unsigned int v2:7; unsigned char v3:7; };
struct Uc_BFu7i_BFu7i { unsigned char v1; unsigned int v2:7; unsigned int v3:7; };
struct Uc_BFu7i_BFu7ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:7; };
struct Uc_BFu7i_BFu7s { unsigned char v1; unsigned int v2:7; unsigned short v3:7; };
struct Uc_BFu7i_BFu8c { unsigned char v1; unsigned int v2:7; unsigned char v3:8; };
struct Uc_BFu7i_BFu8i { unsigned char v1; unsigned int v2:7; unsigned int v3:8; };
struct Uc_BFu7i_BFu8ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:8; };
struct Uc_BFu7i_BFu8s { unsigned char v1; unsigned int v2:7; unsigned short v3:8; };
struct Uc_BFu7i_BFu9i { unsigned char v1; unsigned int v2:7; unsigned int v3:9; };
struct Uc_BFu7i_BFu9ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:9; };
struct Uc_BFu7i_BFu9s { unsigned char v1; unsigned int v2:7; unsigned short v3:9; };
struct Uc_BFu7i_C { unsigned char v1; unsigned int v2:7; char v3; };
struct Uc_BFu7i_D { unsigned char v1; unsigned int v2:7; double v3; };
struct Uc_BFu7i_F { unsigned char v1; unsigned int v2:7; float v3; };
struct Uc_BFu7i_I { unsigned char v1; unsigned int v2:7; int v3; };
struct Uc_BFu7i_Ip { unsigned char v1; unsigned int v2:7; int * v3; };
struct Uc_BFu7i_L { unsigned char v1; unsigned int v2:7; long long v3; };
struct Uc_BFu7i_S { unsigned char v1; unsigned int v2:7; short v3; };
struct Uc_BFu7i_Uc { unsigned char v1; unsigned int v2:7; unsigned char v3; };
struct Uc_BFu7i_Ui { unsigned char v1; unsigned int v2:7; unsigned int v3; };
struct Uc_BFu7i_Ul { unsigned char v1; unsigned int v2:7; unsigned long long v3; };
struct Uc_BFu7i_Us { unsigned char v1; unsigned int v2:7; unsigned short v3; };
struct Uc_BFu7i_Vp { unsigned char v1; unsigned int v2:7; void * v3; };
struct Uc_BFu7ll { unsigned char v1; unsigned long long v2:7; };
struct Uc_BFu7ll_BFu15i { unsigned char v1; unsigned long long v2:7; unsigned int v3:15; };
struct Uc_BFu7ll_BFu15ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:15; };
struct Uc_BFu7ll_BFu15s { unsigned char v1; unsigned long long v2:7; unsigned short v3:15; };
struct Uc_BFu7ll_BFu16i { unsigned char v1; unsigned long long v2:7; unsigned int v3:16; };
struct Uc_BFu7ll_BFu16ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:16; };
struct Uc_BFu7ll_BFu16s { unsigned char v1; unsigned long long v2:7; unsigned short v3:16; };
struct Uc_BFu7ll_BFu17i { unsigned char v1; unsigned long long v2:7; unsigned int v3:17; };
struct Uc_BFu7ll_BFu17ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:17; };
struct Uc_BFu7ll_BFu1c { unsigned char v1; unsigned long long v2:7; unsigned char v3:1; };
struct Uc_BFu7ll_BFu1i { unsigned char v1; unsigned long long v2:7; unsigned int v3:1; };
struct Uc_BFu7ll_BFu1ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:1; };
struct Uc_BFu7ll_BFu1s { unsigned char v1; unsigned long long v2:7; unsigned short v3:1; };
struct Uc_BFu7ll_BFu31i { unsigned char v1; unsigned long long v2:7; unsigned int v3:31; };
struct Uc_BFu7ll_BFu31ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:31; };
struct Uc_BFu7ll_BFu32i { unsigned char v1; unsigned long long v2:7; unsigned int v3:32; };
struct Uc_BFu7ll_BFu32ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:32; };
struct Uc_BFu7ll_BFu33 { unsigned char v1; unsigned long long v2:7; unsigned long long v3:33; };
struct Uc_BFu7ll_BFu7c { unsigned char v1; unsigned long long v2:7; unsigned char v3:7; };
struct Uc_BFu7ll_BFu7i { unsigned char v1; unsigned long long v2:7; unsigned int v3:7; };
struct Uc_BFu7ll_BFu7ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:7; };
struct Uc_BFu7ll_BFu7s { unsigned char v1; unsigned long long v2:7; unsigned short v3:7; };
struct Uc_BFu7ll_BFu8c { unsigned char v1; unsigned long long v2:7; unsigned char v3:8; };
struct Uc_BFu7ll_BFu8i { unsigned char v1; unsigned long long v2:7; unsigned int v3:8; };
struct Uc_BFu7ll_BFu8ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:8; };
struct Uc_BFu7ll_BFu8s { unsigned char v1; unsigned long long v2:7; unsigned short v3:8; };
struct Uc_BFu7ll_BFu9i { unsigned char v1; unsigned long long v2:7; unsigned int v3:9; };
struct Uc_BFu7ll_BFu9ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:9; };
struct Uc_BFu7ll_BFu9s { unsigned char v1; unsigned long long v2:7; unsigned short v3:9; };
struct Uc_BFu7ll_C { unsigned char v1; unsigned long long v2:7; char v3; };
struct Uc_BFu7ll_D { unsigned char v1; unsigned long long v2:7; double v3; };
struct Uc_BFu7ll_F { unsigned char v1; unsigned long long v2:7; float v3; };
struct Uc_BFu7ll_I { unsigned char v1; unsigned long long v2:7; int v3; };
struct Uc_BFu7ll_Ip { unsigned char v1; unsigned long long v2:7; int * v3; };
struct Uc_BFu7ll_L { unsigned char v1; unsigned long long v2:7; long long v3; };
struct Uc_BFu7ll_S { unsigned char v1; unsigned long long v2:7; short v3; };
struct Uc_BFu7ll_Uc { unsigned char v1; unsigned long long v2:7; unsigned char v3; };
struct Uc_BFu7ll_Ui { unsigned char v1; unsigned long long v2:7; unsigned int v3; };
struct Uc_BFu7ll_Ul { unsigned char v1; unsigned long long v2:7; unsigned long long v3; };
struct Uc_BFu7ll_Us { unsigned char v1; unsigned long long v2:7; unsigned short v3; };
struct Uc_BFu7ll_Vp { unsigned char v1; unsigned long long v2:7; void * v3; };
struct Uc_BFu7s { unsigned char v1; unsigned short v2:7; };
struct Uc_BFu7s_BFu15i { unsigned char v1; unsigned short v2:7; unsigned int v3:15; };
struct Uc_BFu7s_BFu15ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:15; };
struct Uc_BFu7s_BFu15s { unsigned char v1; unsigned short v2:7; unsigned short v3:15; };
struct Uc_BFu7s_BFu16i { unsigned char v1; unsigned short v2:7; unsigned int v3:16; };
struct Uc_BFu7s_BFu16ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:16; };
struct Uc_BFu7s_BFu16s { unsigned char v1; unsigned short v2:7; unsigned short v3:16; };
struct Uc_BFu7s_BFu17i { unsigned char v1; unsigned short v2:7; unsigned int v3:17; };
struct Uc_BFu7s_BFu17ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:17; };
struct Uc_BFu7s_BFu1c { unsigned char v1; unsigned short v2:7; unsigned char v3:1; };
struct Uc_BFu7s_BFu1i { unsigned char v1; unsigned short v2:7; unsigned int v3:1; };
struct Uc_BFu7s_BFu1ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:1; };
struct Uc_BFu7s_BFu1s { unsigned char v1; unsigned short v2:7; unsigned short v3:1; };
struct Uc_BFu7s_BFu31i { unsigned char v1; unsigned short v2:7; unsigned int v3:31; };
struct Uc_BFu7s_BFu31ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:31; };
struct Uc_BFu7s_BFu32i { unsigned char v1; unsigned short v2:7; unsigned int v3:32; };
struct Uc_BFu7s_BFu32ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:32; };
struct Uc_BFu7s_BFu33 { unsigned char v1; unsigned short v2:7; unsigned long long v3:33; };
struct Uc_BFu7s_BFu7c { unsigned char v1; unsigned short v2:7; unsigned char v3:7; };
struct Uc_BFu7s_BFu7i { unsigned char v1; unsigned short v2:7; unsigned int v3:7; };
struct Uc_BFu7s_BFu7ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:7; };
struct Uc_BFu7s_BFu7s { unsigned char v1; unsigned short v2:7; unsigned short v3:7; };
struct Uc_BFu7s_BFu8c { unsigned char v1; unsigned short v2:7; unsigned char v3:8; };
struct Uc_BFu7s_BFu8i { unsigned char v1; unsigned short v2:7; unsigned int v3:8; };
struct Uc_BFu7s_BFu8ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:8; };
struct Uc_BFu7s_BFu8s { unsigned char v1; unsigned short v2:7; unsigned short v3:8; };
struct Uc_BFu7s_BFu9i { unsigned char v1; unsigned short v2:7; unsigned int v3:9; };
struct Uc_BFu7s_BFu9ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:9; };
struct Uc_BFu7s_BFu9s { unsigned char v1; unsigned short v2:7; unsigned short v3:9; };
struct Uc_BFu7s_C { unsigned char v1; unsigned short v2:7; char v3; };
struct Uc_BFu7s_D { unsigned char v1; unsigned short v2:7; double v3; };
struct Uc_BFu7s_F { unsigned char v1; unsigned short v2:7; float v3; };
struct Uc_BFu7s_I { unsigned char v1; unsigned short v2:7; int v3; };
struct Uc_BFu7s_Ip { unsigned char v1; unsigned short v2:7; int * v3; };
struct Uc_BFu7s_L { unsigned char v1; unsigned short v2:7; long long v3; };
struct Uc_BFu7s_S { unsigned char v1; unsigned short v2:7; short v3; };
struct Uc_BFu7s_Uc { unsigned char v1; unsigned short v2:7; unsigned char v3; };
struct Uc_BFu7s_Ui { unsigned char v1; unsigned short v2:7; unsigned int v3; };
struct Uc_BFu7s_Ul { unsigned char v1; unsigned short v2:7; unsigned long long v3; };
struct Uc_BFu7s_Us { unsigned char v1; unsigned short v2:7; unsigned short v3; };
struct Uc_BFu7s_Vp { unsigned char v1; unsigned short v2:7; void * v3; };
struct Uc_BFu8c { unsigned char v1; unsigned char v2:8; };
struct Uc_BFu8c_BFu15i { unsigned char v1; unsigned char v2:8; unsigned int v3:15; };
struct Uc_BFu8c_BFu15ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:15; };
struct Uc_BFu8c_BFu15s { unsigned char v1; unsigned char v2:8; unsigned short v3:15; };
struct Uc_BFu8c_BFu16i { unsigned char v1; unsigned char v2:8; unsigned int v3:16; };
struct Uc_BFu8c_BFu16ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:16; };
struct Uc_BFu8c_BFu16s { unsigned char v1; unsigned char v2:8; unsigned short v3:16; };
struct Uc_BFu8c_BFu17i { unsigned char v1; unsigned char v2:8; unsigned int v3:17; };
struct Uc_BFu8c_BFu17ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:17; };
struct Uc_BFu8c_BFu1c { unsigned char v1; unsigned char v2:8; unsigned char v3:1; };
struct Uc_BFu8c_BFu1i { unsigned char v1; unsigned char v2:8; unsigned int v3:1; };
struct Uc_BFu8c_BFu1ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:1; };
struct Uc_BFu8c_BFu1s { unsigned char v1; unsigned char v2:8; unsigned short v3:1; };
struct Uc_BFu8c_BFu31i { unsigned char v1; unsigned char v2:8; unsigned int v3:31; };
struct Uc_BFu8c_BFu31ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:31; };
struct Uc_BFu8c_BFu32i { unsigned char v1; unsigned char v2:8; unsigned int v3:32; };
struct Uc_BFu8c_BFu32ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:32; };
struct Uc_BFu8c_BFu33 { unsigned char v1; unsigned char v2:8; unsigned long long v3:33; };
struct Uc_BFu8c_BFu7c { unsigned char v1; unsigned char v2:8; unsigned char v3:7; };
struct Uc_BFu8c_BFu7i { unsigned char v1; unsigned char v2:8; unsigned int v3:7; };
struct Uc_BFu8c_BFu7ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:7; };
struct Uc_BFu8c_BFu7s { unsigned char v1; unsigned char v2:8; unsigned short v3:7; };
struct Uc_BFu8c_BFu8c { unsigned char v1; unsigned char v2:8; unsigned char v3:8; };
struct Uc_BFu8c_BFu8i { unsigned char v1; unsigned char v2:8; unsigned int v3:8; };
struct Uc_BFu8c_BFu8ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:8; };
struct Uc_BFu8c_BFu8s { unsigned char v1; unsigned char v2:8; unsigned short v3:8; };
struct Uc_BFu8c_BFu9i { unsigned char v1; unsigned char v2:8; unsigned int v3:9; };
struct Uc_BFu8c_BFu9ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:9; };
struct Uc_BFu8c_BFu9s { unsigned char v1; unsigned char v2:8; unsigned short v3:9; };
struct Uc_BFu8c_C { unsigned char v1; unsigned char v2:8; char v3; };
struct Uc_BFu8c_D { unsigned char v1; unsigned char v2:8; double v3; };
struct Uc_BFu8c_F { unsigned char v1; unsigned char v2:8; float v3; };
struct Uc_BFu8c_I { unsigned char v1; unsigned char v2:8; int v3; };
struct Uc_BFu8c_Ip { unsigned char v1; unsigned char v2:8; int * v3; };
struct Uc_BFu8c_L { unsigned char v1; unsigned char v2:8; long long v3; };
struct Uc_BFu8c_S { unsigned char v1; unsigned char v2:8; short v3; };
struct Uc_BFu8c_Uc { unsigned char v1; unsigned char v2:8; unsigned char v3; };
struct Uc_BFu8c_Ui { unsigned char v1; unsigned char v2:8; unsigned int v3; };
struct Uc_BFu8c_Ul { unsigned char v1; unsigned char v2:8; unsigned long long v3; };
struct Uc_BFu8c_Us { unsigned char v1; unsigned char v2:8; unsigned short v3; };
struct Uc_BFu8c_Vp { unsigned char v1; unsigned char v2:8; void * v3; };
struct Uc_BFu8i { unsigned char v1; unsigned int v2:8; };
struct Uc_BFu8i_BFu15i { unsigned char v1; unsigned int v2:8; unsigned int v3:15; };
struct Uc_BFu8i_BFu15ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:15; };
struct Uc_BFu8i_BFu15s { unsigned char v1; unsigned int v2:8; unsigned short v3:15; };
struct Uc_BFu8i_BFu16i { unsigned char v1; unsigned int v2:8; unsigned int v3:16; };
struct Uc_BFu8i_BFu16ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:16; };
struct Uc_BFu8i_BFu16s { unsigned char v1; unsigned int v2:8; unsigned short v3:16; };
struct Uc_BFu8i_BFu17i { unsigned char v1; unsigned int v2:8; unsigned int v3:17; };
struct Uc_BFu8i_BFu17ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:17; };
struct Uc_BFu8i_BFu1c { unsigned char v1; unsigned int v2:8; unsigned char v3:1; };
struct Uc_BFu8i_BFu1i { unsigned char v1; unsigned int v2:8; unsigned int v3:1; };
struct Uc_BFu8i_BFu1ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:1; };
struct Uc_BFu8i_BFu1s { unsigned char v1; unsigned int v2:8; unsigned short v3:1; };
struct Uc_BFu8i_BFu31i { unsigned char v1; unsigned int v2:8; unsigned int v3:31; };
struct Uc_BFu8i_BFu31ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:31; };
struct Uc_BFu8i_BFu32i { unsigned char v1; unsigned int v2:8; unsigned int v3:32; };
struct Uc_BFu8i_BFu32ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:32; };
struct Uc_BFu8i_BFu33 { unsigned char v1; unsigned int v2:8; unsigned long long v3:33; };
struct Uc_BFu8i_BFu7c { unsigned char v1; unsigned int v2:8; unsigned char v3:7; };
struct Uc_BFu8i_BFu7i { unsigned char v1; unsigned int v2:8; unsigned int v3:7; };
struct Uc_BFu8i_BFu7ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:7; };
struct Uc_BFu8i_BFu7s { unsigned char v1; unsigned int v2:8; unsigned short v3:7; };
struct Uc_BFu8i_BFu8c { unsigned char v1; unsigned int v2:8; unsigned char v3:8; };
struct Uc_BFu8i_BFu8i { unsigned char v1; unsigned int v2:8; unsigned int v3:8; };
struct Uc_BFu8i_BFu8ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:8; };
struct Uc_BFu8i_BFu8s { unsigned char v1; unsigned int v2:8; unsigned short v3:8; };
struct Uc_BFu8i_BFu9i { unsigned char v1; unsigned int v2:8; unsigned int v3:9; };
struct Uc_BFu8i_BFu9ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:9; };
struct Uc_BFu8i_BFu9s { unsigned char v1; unsigned int v2:8; unsigned short v3:9; };
struct Uc_BFu8i_C { unsigned char v1; unsigned int v2:8; char v3; };
struct Uc_BFu8i_D { unsigned char v1; unsigned int v2:8; double v3; };
struct Uc_BFu8i_F { unsigned char v1; unsigned int v2:8; float v3; };
struct Uc_BFu8i_I { unsigned char v1; unsigned int v2:8; int v3; };
struct Uc_BFu8i_Ip { unsigned char v1; unsigned int v2:8; int * v3; };
struct Uc_BFu8i_L { unsigned char v1; unsigned int v2:8; long long v3; };
struct Uc_BFu8i_S { unsigned char v1; unsigned int v2:8; short v3; };
struct Uc_BFu8i_Uc { unsigned char v1; unsigned int v2:8; unsigned char v3; };
struct Uc_BFu8i_Ui { unsigned char v1; unsigned int v2:8; unsigned int v3; };
struct Uc_BFu8i_Ul { unsigned char v1; unsigned int v2:8; unsigned long long v3; };
struct Uc_BFu8i_Us { unsigned char v1; unsigned int v2:8; unsigned short v3; };
struct Uc_BFu8i_Vp { unsigned char v1; unsigned int v2:8; void * v3; };
struct Uc_BFu8ll { unsigned char v1; unsigned long long v2:8; };
struct Uc_BFu8ll_BFu15i { unsigned char v1; unsigned long long v2:8; unsigned int v3:15; };
struct Uc_BFu8ll_BFu15ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:15; };
struct Uc_BFu8ll_BFu15s { unsigned char v1; unsigned long long v2:8; unsigned short v3:15; };
struct Uc_BFu8ll_BFu16i { unsigned char v1; unsigned long long v2:8; unsigned int v3:16; };
struct Uc_BFu8ll_BFu16ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:16; };
struct Uc_BFu8ll_BFu16s { unsigned char v1; unsigned long long v2:8; unsigned short v3:16; };
struct Uc_BFu8ll_BFu17i { unsigned char v1; unsigned long long v2:8; unsigned int v3:17; };
struct Uc_BFu8ll_BFu17ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:17; };
struct Uc_BFu8ll_BFu1c { unsigned char v1; unsigned long long v2:8; unsigned char v3:1; };
struct Uc_BFu8ll_BFu1i { unsigned char v1; unsigned long long v2:8; unsigned int v3:1; };
struct Uc_BFu8ll_BFu1ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:1; };
struct Uc_BFu8ll_BFu1s { unsigned char v1; unsigned long long v2:8; unsigned short v3:1; };
struct Uc_BFu8ll_BFu31i { unsigned char v1; unsigned long long v2:8; unsigned int v3:31; };
struct Uc_BFu8ll_BFu31ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:31; };
struct Uc_BFu8ll_BFu32i { unsigned char v1; unsigned long long v2:8; unsigned int v3:32; };
struct Uc_BFu8ll_BFu32ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:32; };
struct Uc_BFu8ll_BFu33 { unsigned char v1; unsigned long long v2:8; unsigned long long v3:33; };
struct Uc_BFu8ll_BFu7c { unsigned char v1; unsigned long long v2:8; unsigned char v3:7; };
struct Uc_BFu8ll_BFu7i { unsigned char v1; unsigned long long v2:8; unsigned int v3:7; };
struct Uc_BFu8ll_BFu7ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:7; };
struct Uc_BFu8ll_BFu7s { unsigned char v1; unsigned long long v2:8; unsigned short v3:7; };
struct Uc_BFu8ll_BFu8c { unsigned char v1; unsigned long long v2:8; unsigned char v3:8; };
struct Uc_BFu8ll_BFu8i { unsigned char v1; unsigned long long v2:8; unsigned int v3:8; };
struct Uc_BFu8ll_BFu8ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:8; };
struct Uc_BFu8ll_BFu8s { unsigned char v1; unsigned long long v2:8; unsigned short v3:8; };
struct Uc_BFu8ll_BFu9i { unsigned char v1; unsigned long long v2:8; unsigned int v3:9; };
struct Uc_BFu8ll_BFu9ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:9; };
struct Uc_BFu8ll_BFu9s { unsigned char v1; unsigned long long v2:8; unsigned short v3:9; };
struct Uc_BFu8ll_C { unsigned char v1; unsigned long long v2:8; char v3; };
struct Uc_BFu8ll_D { unsigned char v1; unsigned long long v2:8; double v3; };
struct Uc_BFu8ll_F { unsigned char v1; unsigned long long v2:8; float v3; };
struct Uc_BFu8ll_I { unsigned char v1; unsigned long long v2:8; int v3; };
struct Uc_BFu8ll_Ip { unsigned char v1; unsigned long long v2:8; int * v3; };
struct Uc_BFu8ll_L { unsigned char v1; unsigned long long v2:8; long long v3; };
struct Uc_BFu8ll_S { unsigned char v1; unsigned long long v2:8; short v3; };
struct Uc_BFu8ll_Uc { unsigned char v1; unsigned long long v2:8; unsigned char v3; };
struct Uc_BFu8ll_Ui { unsigned char v1; unsigned long long v2:8; unsigned int v3; };
struct Uc_BFu8ll_Ul { unsigned char v1; unsigned long long v2:8; unsigned long long v3; };
struct Uc_BFu8ll_Us { unsigned char v1; unsigned long long v2:8; unsigned short v3; };
struct Uc_BFu8ll_Vp { unsigned char v1; unsigned long long v2:8; void * v3; };
struct Uc_BFu8s { unsigned char v1; unsigned short v2:8; };
struct Uc_BFu8s_BFu15i { unsigned char v1; unsigned short v2:8; unsigned int v3:15; };
struct Uc_BFu8s_BFu15ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:15; };
struct Uc_BFu8s_BFu15s { unsigned char v1; unsigned short v2:8; unsigned short v3:15; };
struct Uc_BFu8s_BFu16i { unsigned char v1; unsigned short v2:8; unsigned int v3:16; };
struct Uc_BFu8s_BFu16ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:16; };
struct Uc_BFu8s_BFu16s { unsigned char v1; unsigned short v2:8; unsigned short v3:16; };
struct Uc_BFu8s_BFu17i { unsigned char v1; unsigned short v2:8; unsigned int v3:17; };
struct Uc_BFu8s_BFu17ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:17; };
struct Uc_BFu8s_BFu1c { unsigned char v1; unsigned short v2:8; unsigned char v3:1; };
struct Uc_BFu8s_BFu1i { unsigned char v1; unsigned short v2:8; unsigned int v3:1; };
struct Uc_BFu8s_BFu1ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:1; };
struct Uc_BFu8s_BFu1s { unsigned char v1; unsigned short v2:8; unsigned short v3:1; };
struct Uc_BFu8s_BFu31i { unsigned char v1; unsigned short v2:8; unsigned int v3:31; };
struct Uc_BFu8s_BFu31ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:31; };
struct Uc_BFu8s_BFu32i { unsigned char v1; unsigned short v2:8; unsigned int v3:32; };
struct Uc_BFu8s_BFu32ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:32; };
struct Uc_BFu8s_BFu33 { unsigned char v1; unsigned short v2:8; unsigned long long v3:33; };
struct Uc_BFu8s_BFu7c { unsigned char v1; unsigned short v2:8; unsigned char v3:7; };
struct Uc_BFu8s_BFu7i { unsigned char v1; unsigned short v2:8; unsigned int v3:7; };
struct Uc_BFu8s_BFu7ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:7; };
struct Uc_BFu8s_BFu7s { unsigned char v1; unsigned short v2:8; unsigned short v3:7; };
struct Uc_BFu8s_BFu8c { unsigned char v1; unsigned short v2:8; unsigned char v3:8; };
struct Uc_BFu8s_BFu8i { unsigned char v1; unsigned short v2:8; unsigned int v3:8; };
struct Uc_BFu8s_BFu8ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:8; };
struct Uc_BFu8s_BFu8s { unsigned char v1; unsigned short v2:8; unsigned short v3:8; };
struct Uc_BFu8s_BFu9i { unsigned char v1; unsigned short v2:8; unsigned int v3:9; };
struct Uc_BFu8s_BFu9ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:9; };
struct Uc_BFu8s_BFu9s { unsigned char v1; unsigned short v2:8; unsigned short v3:9; };
struct Uc_BFu8s_C { unsigned char v1; unsigned short v2:8; char v3; };
struct Uc_BFu8s_D { unsigned char v1; unsigned short v2:8; double v3; };
struct Uc_BFu8s_F { unsigned char v1; unsigned short v2:8; float v3; };
struct Uc_BFu8s_I { unsigned char v1; unsigned short v2:8; int v3; };
struct Uc_BFu8s_Ip { unsigned char v1; unsigned short v2:8; int * v3; };
struct Uc_BFu8s_L { unsigned char v1; unsigned short v2:8; long long v3; };
struct Uc_BFu8s_S { unsigned char v1; unsigned short v2:8; short v3; };
struct Uc_BFu8s_Uc { unsigned char v1; unsigned short v2:8; unsigned char v3; };
struct Uc_BFu8s_Ui { unsigned char v1; unsigned short v2:8; unsigned int v3; };
struct Uc_BFu8s_Ul { unsigned char v1; unsigned short v2:8; unsigned long long v3; };
struct Uc_BFu8s_Us { unsigned char v1; unsigned short v2:8; unsigned short v3; };
struct Uc_BFu8s_Vp { unsigned char v1; unsigned short v2:8; void * v3; };
struct Uc_BFu9i { unsigned char v1; unsigned int v2:9; };
struct Uc_BFu9i_BFu15i { unsigned char v1; unsigned int v2:9; unsigned int v3:15; };
struct Uc_BFu9i_BFu15ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:15; };
struct Uc_BFu9i_BFu15s { unsigned char v1; unsigned int v2:9; unsigned short v3:15; };
struct Uc_BFu9i_BFu16i { unsigned char v1; unsigned int v2:9; unsigned int v3:16; };
struct Uc_BFu9i_BFu16ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:16; };
struct Uc_BFu9i_BFu16s { unsigned char v1; unsigned int v2:9; unsigned short v3:16; };
struct Uc_BFu9i_BFu17i { unsigned char v1; unsigned int v2:9; unsigned int v3:17; };
struct Uc_BFu9i_BFu17ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:17; };
struct Uc_BFu9i_BFu1c { unsigned char v1; unsigned int v2:9; unsigned char v3:1; };
struct Uc_BFu9i_BFu1i { unsigned char v1; unsigned int v2:9; unsigned int v3:1; };
struct Uc_BFu9i_BFu1ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:1; };
struct Uc_BFu9i_BFu1s { unsigned char v1; unsigned int v2:9; unsigned short v3:1; };
struct Uc_BFu9i_BFu31i { unsigned char v1; unsigned int v2:9; unsigned int v3:31; };
struct Uc_BFu9i_BFu31ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:31; };
struct Uc_BFu9i_BFu32i { unsigned char v1; unsigned int v2:9; unsigned int v3:32; };
struct Uc_BFu9i_BFu32ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:32; };
struct Uc_BFu9i_BFu33 { unsigned char v1; unsigned int v2:9; unsigned long long v3:33; };
struct Uc_BFu9i_BFu7c { unsigned char v1; unsigned int v2:9; unsigned char v3:7; };
struct Uc_BFu9i_BFu7i { unsigned char v1; unsigned int v2:9; unsigned int v3:7; };
struct Uc_BFu9i_BFu7ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:7; };
struct Uc_BFu9i_BFu7s { unsigned char v1; unsigned int v2:9; unsigned short v3:7; };
struct Uc_BFu9i_BFu8c { unsigned char v1; unsigned int v2:9; unsigned char v3:8; };
struct Uc_BFu9i_BFu8i { unsigned char v1; unsigned int v2:9; unsigned int v3:8; };
struct Uc_BFu9i_BFu8ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:8; };
struct Uc_BFu9i_BFu8s { unsigned char v1; unsigned int v2:9; unsigned short v3:8; };
struct Uc_BFu9i_BFu9i { unsigned char v1; unsigned int v2:9; unsigned int v3:9; };
struct Uc_BFu9i_BFu9ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:9; };
struct Uc_BFu9i_BFu9s { unsigned char v1; unsigned int v2:9; unsigned short v3:9; };
struct Uc_BFu9i_C { unsigned char v1; unsigned int v2:9; char v3; };
struct Uc_BFu9i_D { unsigned char v1; unsigned int v2:9; double v3; };
struct Uc_BFu9i_F { unsigned char v1; unsigned int v2:9; float v3; };
struct Uc_BFu9i_I { unsigned char v1; unsigned int v2:9; int v3; };
struct Uc_BFu9i_Ip { unsigned char v1; unsigned int v2:9; int * v3; };
struct Uc_BFu9i_L { unsigned char v1; unsigned int v2:9; long long v3; };
struct Uc_BFu9i_S { unsigned char v1; unsigned int v2:9; short v3; };
struct Uc_BFu9i_Uc { unsigned char v1; unsigned int v2:9; unsigned char v3; };
struct Uc_BFu9i_Ui { unsigned char v1; unsigned int v2:9; unsigned int v3; };
struct Uc_BFu9i_Ul { unsigned char v1; unsigned int v2:9; unsigned long long v3; };
struct Uc_BFu9i_Us { unsigned char v1; unsigned int v2:9; unsigned short v3; };
struct Uc_BFu9i_Vp { unsigned char v1; unsigned int v2:9; void * v3; };
struct Uc_BFu9ll { unsigned char v1; unsigned long long v2:9; };
struct Uc_BFu9ll_BFu15i { unsigned char v1; unsigned long long v2:9; unsigned int v3:15; };
struct Uc_BFu9ll_BFu15ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:15; };
struct Uc_BFu9ll_BFu15s { unsigned char v1; unsigned long long v2:9; unsigned short v3:15; };
struct Uc_BFu9ll_BFu16i { unsigned char v1; unsigned long long v2:9; unsigned int v3:16; };
struct Uc_BFu9ll_BFu16ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:16; };
struct Uc_BFu9ll_BFu16s { unsigned char v1; unsigned long long v2:9; unsigned short v3:16; };
struct Uc_BFu9ll_BFu17i { unsigned char v1; unsigned long long v2:9; unsigned int v3:17; };
struct Uc_BFu9ll_BFu17ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:17; };
struct Uc_BFu9ll_BFu1c { unsigned char v1; unsigned long long v2:9; unsigned char v3:1; };
struct Uc_BFu9ll_BFu1i { unsigned char v1; unsigned long long v2:9; unsigned int v3:1; };
struct Uc_BFu9ll_BFu1ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:1; };
struct Uc_BFu9ll_BFu1s { unsigned char v1; unsigned long long v2:9; unsigned short v3:1; };
struct Uc_BFu9ll_BFu31i { unsigned char v1; unsigned long long v2:9; unsigned int v3:31; };
struct Uc_BFu9ll_BFu31ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:31; };
struct Uc_BFu9ll_BFu32i { unsigned char v1; unsigned long long v2:9; unsigned int v3:32; };
struct Uc_BFu9ll_BFu32ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:32; };
struct Uc_BFu9ll_BFu33 { unsigned char v1; unsigned long long v2:9; unsigned long long v3:33; };
struct Uc_BFu9ll_BFu7c { unsigned char v1; unsigned long long v2:9; unsigned char v3:7; };
struct Uc_BFu9ll_BFu7i { unsigned char v1; unsigned long long v2:9; unsigned int v3:7; };
struct Uc_BFu9ll_BFu7ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:7; };
struct Uc_BFu9ll_BFu7s { unsigned char v1; unsigned long long v2:9; unsigned short v3:7; };
struct Uc_BFu9ll_BFu8c { unsigned char v1; unsigned long long v2:9; unsigned char v3:8; };
struct Uc_BFu9ll_BFu8i { unsigned char v1; unsigned long long v2:9; unsigned int v3:8; };
struct Uc_BFu9ll_BFu8ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:8; };
struct Uc_BFu9ll_BFu8s { unsigned char v1; unsigned long long v2:9; unsigned short v3:8; };
struct Uc_BFu9ll_BFu9i { unsigned char v1; unsigned long long v2:9; unsigned int v3:9; };
struct Uc_BFu9ll_BFu9ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:9; };
struct Uc_BFu9ll_BFu9s { unsigned char v1; unsigned long long v2:9; unsigned short v3:9; };
struct Uc_BFu9ll_C { unsigned char v1; unsigned long long v2:9; char v3; };
struct Uc_BFu9ll_D { unsigned char v1; unsigned long long v2:9; double v3; };
struct Uc_BFu9ll_F { unsigned char v1; unsigned long long v2:9; float v3; };
struct Uc_BFu9ll_I { unsigned char v1; unsigned long long v2:9; int v3; };
struct Uc_BFu9ll_Ip { unsigned char v1; unsigned long long v2:9; int * v3; };
struct Uc_BFu9ll_L { unsigned char v1; unsigned long long v2:9; long long v3; };
struct Uc_BFu9ll_S { unsigned char v1; unsigned long long v2:9; short v3; };
struct Uc_BFu9ll_Uc { unsigned char v1; unsigned long long v2:9; unsigned char v3; };
struct Uc_BFu9ll_Ui { unsigned char v1; unsigned long long v2:9; unsigned int v3; };
struct Uc_BFu9ll_Ul { unsigned char v1; unsigned long long v2:9; unsigned long long v3; };
struct Uc_BFu9ll_Us { unsigned char v1; unsigned long long v2:9; unsigned short v3; };
struct Uc_BFu9ll_Vp { unsigned char v1; unsigned long long v2:9; void * v3; };
struct Uc_BFu9s { unsigned char v1; unsigned short v2:9; };
struct Uc_BFu9s_BFu15i { unsigned char v1; unsigned short v2:9; unsigned int v3:15; };
struct Uc_BFu9s_BFu15ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:15; };
struct Uc_BFu9s_BFu15s { unsigned char v1; unsigned short v2:9; unsigned short v3:15; };
struct Uc_BFu9s_BFu16i { unsigned char v1; unsigned short v2:9; unsigned int v3:16; };
struct Uc_BFu9s_BFu16ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:16; };
struct Uc_BFu9s_BFu16s { unsigned char v1; unsigned short v2:9; unsigned short v3:16; };
struct Uc_BFu9s_BFu17i { unsigned char v1; unsigned short v2:9; unsigned int v3:17; };
struct Uc_BFu9s_BFu17ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:17; };
struct Uc_BFu9s_BFu1c { unsigned char v1; unsigned short v2:9; unsigned char v3:1; };
struct Uc_BFu9s_BFu1i { unsigned char v1; unsigned short v2:9; unsigned int v3:1; };
struct Uc_BFu9s_BFu1ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:1; };
struct Uc_BFu9s_BFu1s { unsigned char v1; unsigned short v2:9; unsigned short v3:1; };
struct Uc_BFu9s_BFu31i { unsigned char v1; unsigned short v2:9; unsigned int v3:31; };
struct Uc_BFu9s_BFu31ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:31; };
struct Uc_BFu9s_BFu32i { unsigned char v1; unsigned short v2:9; unsigned int v3:32; };
struct Uc_BFu9s_BFu32ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:32; };
struct Uc_BFu9s_BFu33 { unsigned char v1; unsigned short v2:9; unsigned long long v3:33; };
struct Uc_BFu9s_BFu7c { unsigned char v1; unsigned short v2:9; unsigned char v3:7; };
struct Uc_BFu9s_BFu7i { unsigned char v1; unsigned short v2:9; unsigned int v3:7; };
struct Uc_BFu9s_BFu7ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:7; };
struct Uc_BFu9s_BFu7s { unsigned char v1; unsigned short v2:9; unsigned short v3:7; };
struct Uc_BFu9s_BFu8c { unsigned char v1; unsigned short v2:9; unsigned char v3:8; };
struct Uc_BFu9s_BFu8i { unsigned char v1; unsigned short v2:9; unsigned int v3:8; };
struct Uc_BFu9s_BFu8ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:8; };
struct Uc_BFu9s_BFu8s { unsigned char v1; unsigned short v2:9; unsigned short v3:8; };
struct Uc_BFu9s_BFu9i { unsigned char v1; unsigned short v2:9; unsigned int v3:9; };
struct Uc_BFu9s_BFu9ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:9; };
struct Uc_BFu9s_BFu9s { unsigned char v1; unsigned short v2:9; unsigned short v3:9; };
struct Uc_BFu9s_C { unsigned char v1; unsigned short v2:9; char v3; };
struct Uc_BFu9s_D { unsigned char v1; unsigned short v2:9; double v3; };
struct Uc_BFu9s_F { unsigned char v1; unsigned short v2:9; float v3; };
struct Uc_BFu9s_I { unsigned char v1; unsigned short v2:9; int v3; };
struct Uc_BFu9s_Ip { unsigned char v1; unsigned short v2:9; int * v3; };
struct Uc_BFu9s_L { unsigned char v1; unsigned short v2:9; long long v3; };
struct Uc_BFu9s_S { unsigned char v1; unsigned short v2:9; short v3; };
struct Uc_BFu9s_Uc { unsigned char v1; unsigned short v2:9; unsigned char v3; };
struct Uc_BFu9s_Ui { unsigned char v1; unsigned short v2:9; unsigned int v3; };
struct Uc_BFu9s_Ul { unsigned char v1; unsigned short v2:9; unsigned long long v3; };
struct Uc_BFu9s_Us { unsigned char v1; unsigned short v2:9; unsigned short v3; };
struct Uc_BFu9s_Vp { unsigned char v1; unsigned short v2:9; void * v3; };
struct Uc_C { unsigned char v1; char v2; };
struct Uc_C_BFu15i { unsigned char v1; char v2; unsigned int v3:15; };
struct Uc_C_BFu15ll { unsigned char v1; char v2; unsigned long long v3:15; };
struct Uc_C_BFu15s { unsigned char v1; char v2; unsigned short v3:15; };
struct Uc_C_BFu16i { unsigned char v1; char v2; unsigned int v3:16; };
struct Uc_C_BFu16ll { unsigned char v1; char v2; unsigned long long v3:16; };
struct Uc_C_BFu16s { unsigned char v1; char v2; unsigned short v3:16; };
struct Uc_C_BFu17i { unsigned char v1; char v2; unsigned int v3:17; };
struct Uc_C_BFu17ll { unsigned char v1; char v2; unsigned long long v3:17; };
struct Uc_C_BFu1c { unsigned char v1; char v2; unsigned char v3:1; };
struct Uc_C_BFu1i { unsigned char v1; char v2; unsigned int v3:1; };
struct Uc_C_BFu1ll { unsigned char v1; char v2; unsigned long long v3:1; };
struct Uc_C_BFu1s { unsigned char v1; char v2; unsigned short v3:1; };
struct Uc_C_BFu31i { unsigned char v1; char v2; unsigned int v3:31; };
struct Uc_C_BFu31ll { unsigned char v1; char v2; unsigned long long v3:31; };
struct Uc_C_BFu32i { unsigned char v1; char v2; unsigned int v3:32; };
struct Uc_C_BFu32ll { unsigned char v1; char v2; unsigned long long v3:32; };
struct Uc_C_BFu33 { unsigned char v1; char v2; unsigned long long v3:33; };
struct Uc_C_BFu7c { unsigned char v1; char v2; unsigned char v3:7; };
struct Uc_C_BFu7i { unsigned char v1; char v2; unsigned int v3:7; };
struct Uc_C_BFu7ll { unsigned char v1; char v2; unsigned long long v3:7; };
struct Uc_C_BFu7s { unsigned char v1; char v2; unsigned short v3:7; };
struct Uc_C_BFu8c { unsigned char v1; char v2; unsigned char v3:8; };
struct Uc_C_BFu8i { unsigned char v1; char v2; unsigned int v3:8; };
struct Uc_C_BFu8ll { unsigned char v1; char v2; unsigned long long v3:8; };
struct Uc_C_BFu8s { unsigned char v1; char v2; unsigned short v3:8; };
struct Uc_C_BFu9i { unsigned char v1; char v2; unsigned int v3:9; };
struct Uc_C_BFu9ll { unsigned char v1; char v2; unsigned long long v3:9; };
struct Uc_C_BFu9s { unsigned char v1; char v2; unsigned short v3:9; };
struct Uc_C_C { unsigned char v1; char v2; char v3; };
struct Uc_C_D { unsigned char v1; char v2; double v3; };
struct Uc_C_F { unsigned char v1; char v2; float v3; };
struct Uc_C_I { unsigned char v1; char v2; int v3; };
struct Uc_C_Ip { unsigned char v1; char v2; int * v3; };
struct Uc_C_L { unsigned char v1; char v2; long long v3; };
struct Uc_C_S { unsigned char v1; char v2; short v3; };
struct Uc_C_Uc { unsigned char v1; char v2; unsigned char v3; };
struct Uc_C_Ui { unsigned char v1; char v2; unsigned int v3; };
struct Uc_C_Ul { unsigned char v1; char v2; unsigned long long v3; };
struct Uc_C_Us { unsigned char v1; char v2; unsigned short v3; };
struct Uc_C_Vp { unsigned char v1; char v2; void * v3; };
struct Uc_D { unsigned char v1; double v2; };
struct Uc_D_BFu15i { unsigned char v1; double v2; unsigned int v3:15; };
struct Uc_D_BFu15ll { unsigned char v1; double v2; unsigned long long v3:15; };
struct Uc_D_BFu15s { unsigned char v1; double v2; unsigned short v3:15; };
struct Uc_D_BFu16i { unsigned char v1; double v2; unsigned int v3:16; };
struct Uc_D_BFu16ll { unsigned char v1; double v2; unsigned long long v3:16; };
struct Uc_D_BFu16s { unsigned char v1; double v2; unsigned short v3:16; };
struct Uc_D_BFu17i { unsigned char v1; double v2; unsigned int v3:17; };
struct Uc_D_BFu17ll { unsigned char v1; double v2; unsigned long long v3:17; };
struct Uc_D_BFu1c { unsigned char v1; double v2; unsigned char v3:1; };
struct Uc_D_BFu1i { unsigned char v1; double v2; unsigned int v3:1; };
struct Uc_D_BFu1ll { unsigned char v1; double v2; unsigned long long v3:1; };
struct Uc_D_BFu1s { unsigned char v1; double v2; unsigned short v3:1; };
struct Uc_D_BFu31i { unsigned char v1; double v2; unsigned int v3:31; };
struct Uc_D_BFu31ll { unsigned char v1; double v2; unsigned long long v3:31; };
struct Uc_D_BFu32i { unsigned char v1; double v2; unsigned int v3:32; };
struct Uc_D_BFu32ll { unsigned char v1; double v2; unsigned long long v3:32; };
struct Uc_D_BFu33 { unsigned char v1; double v2; unsigned long long v3:33; };
struct Uc_D_BFu7c { unsigned char v1; double v2; unsigned char v3:7; };
struct Uc_D_BFu7i { unsigned char v1; double v2; unsigned int v3:7; };
struct Uc_D_BFu7ll { unsigned char v1; double v2; unsigned long long v3:7; };
struct Uc_D_BFu7s { unsigned char v1; double v2; unsigned short v3:7; };
struct Uc_D_BFu8c { unsigned char v1; double v2; unsigned char v3:8; };
struct Uc_D_BFu8i { unsigned char v1; double v2; unsigned int v3:8; };
struct Uc_D_BFu8ll { unsigned char v1; double v2; unsigned long long v3:8; };
struct Uc_D_BFu8s { unsigned char v1; double v2; unsigned short v3:8; };
struct Uc_D_BFu9i { unsigned char v1; double v2; unsigned int v3:9; };
struct Uc_D_BFu9ll { unsigned char v1; double v2; unsigned long long v3:9; };
struct Uc_D_BFu9s { unsigned char v1; double v2; unsigned short v3:9; };
struct Uc_D_C { unsigned char v1; double v2; char v3; };
struct Uc_D_D { unsigned char v1; double v2; double v3; };
struct Uc_D_F { unsigned char v1; double v2; float v3; };
struct Uc_D_I { unsigned char v1; double v2; int v3; };
struct Uc_D_Ip { unsigned char v1; double v2; int * v3; };
struct Uc_D_L { unsigned char v1; double v2; long long v3; };
struct Uc_D_S { unsigned char v1; double v2; short v3; };
struct Uc_D_Uc { unsigned char v1; double v2; unsigned char v3; };
struct Uc_D_Ui { unsigned char v1; double v2; unsigned int v3; };
struct Uc_D_Ul { unsigned char v1; double v2; unsigned long long v3; };
struct Uc_D_Us { unsigned char v1; double v2; unsigned short v3; };
struct Uc_D_Vp { unsigned char v1; double v2; void * v3; };
struct Uc_F { unsigned char v1; float v2; };
struct Uc_F_BFu15i { unsigned char v1; float v2; unsigned int v3:15; };
struct Uc_F_BFu15ll { unsigned char v1; float v2; unsigned long long v3:15; };
struct Uc_F_BFu15s { unsigned char v1; float v2; unsigned short v3:15; };
struct Uc_F_BFu16i { unsigned char v1; float v2; unsigned int v3:16; };
struct Uc_F_BFu16ll { unsigned char v1; float v2; unsigned long long v3:16; };
struct Uc_F_BFu16s { unsigned char v1; float v2; unsigned short v3:16; };
struct Uc_F_BFu17i { unsigned char v1; float v2; unsigned int v3:17; };
struct Uc_F_BFu17ll { unsigned char v1; float v2; unsigned long long v3:17; };
struct Uc_F_BFu1c { unsigned char v1; float v2; unsigned char v3:1; };
struct Uc_F_BFu1i { unsigned char v1; float v2; unsigned int v3:1; };
struct Uc_F_BFu1ll { unsigned char v1; float v2; unsigned long long v3:1; };
struct Uc_F_BFu1s { unsigned char v1; float v2; unsigned short v3:1; };
struct Uc_F_BFu31i { unsigned char v1; float v2; unsigned int v3:31; };
struct Uc_F_BFu31ll { unsigned char v1; float v2; unsigned long long v3:31; };
struct Uc_F_BFu32i { unsigned char v1; float v2; unsigned int v3:32; };
struct Uc_F_BFu32ll { unsigned char v1; float v2; unsigned long long v3:32; };
struct Uc_F_BFu33 { unsigned char v1; float v2; unsigned long long v3:33; };
struct Uc_F_BFu7c { unsigned char v1; float v2; unsigned char v3:7; };
struct Uc_F_BFu7i { unsigned char v1; float v2; unsigned int v3:7; };
struct Uc_F_BFu7ll { unsigned char v1; float v2; unsigned long long v3:7; };
struct Uc_F_BFu7s { unsigned char v1; float v2; unsigned short v3:7; };
struct Uc_F_BFu8c { unsigned char v1; float v2; unsigned char v3:8; };
struct Uc_F_BFu8i { unsigned char v1; float v2; unsigned int v3:8; };
struct Uc_F_BFu8ll { unsigned char v1; float v2; unsigned long long v3:8; };
struct Uc_F_BFu8s { unsigned char v1; float v2; unsigned short v3:8; };
struct Uc_F_BFu9i { unsigned char v1; float v2; unsigned int v3:9; };
struct Uc_F_BFu9ll { unsigned char v1; float v2; unsigned long long v3:9; };
struct Uc_F_BFu9s { unsigned char v1; float v2; unsigned short v3:9; };
struct Uc_F_C { unsigned char v1; float v2; char v3; };
struct Uc_F_D { unsigned char v1; float v2; double v3; };
struct Uc_F_F { unsigned char v1; float v2; float v3; };
struct Uc_F_I { unsigned char v1; float v2; int v3; };
struct Uc_F_Ip { unsigned char v1; float v2; int * v3; };
struct Uc_F_L { unsigned char v1; float v2; long long v3; };
struct Uc_F_S { unsigned char v1; float v2; short v3; };
struct Uc_F_Uc { unsigned char v1; float v2; unsigned char v3; };
struct Uc_F_Ui { unsigned char v1; float v2; unsigned int v3; };
struct Uc_F_Ul { unsigned char v1; float v2; unsigned long long v3; };
struct Uc_F_Us { unsigned char v1; float v2; unsigned short v3; };
struct Uc_F_Vp { unsigned char v1; float v2; void * v3; };
struct Uc_I { unsigned char v1; int v2; };
struct Uc_I_BFu15i { unsigned char v1; int v2; unsigned int v3:15; };
struct Uc_I_BFu15ll { unsigned char v1; int v2; unsigned long long v3:15; };
struct Uc_I_BFu15s { unsigned char v1; int v2; unsigned short v3:15; };
struct Uc_I_BFu16i { unsigned char v1; int v2; unsigned int v3:16; };
struct Uc_I_BFu16ll { unsigned char v1; int v2; unsigned long long v3:16; };
struct Uc_I_BFu16s { unsigned char v1; int v2; unsigned short v3:16; };
struct Uc_I_BFu17i { unsigned char v1; int v2; unsigned int v3:17; };
struct Uc_I_BFu17ll { unsigned char v1; int v2; unsigned long long v3:17; };
struct Uc_I_BFu1c { unsigned char v1; int v2; unsigned char v3:1; };
struct Uc_I_BFu1i { unsigned char v1; int v2; unsigned int v3:1; };
struct Uc_I_BFu1ll { unsigned char v1; int v2; unsigned long long v3:1; };
struct Uc_I_BFu1s { unsigned char v1; int v2; unsigned short v3:1; };
struct Uc_I_BFu31i { unsigned char v1; int v2; unsigned int v3:31; };
struct Uc_I_BFu31ll { unsigned char v1; int v2; unsigned long long v3:31; };
struct Uc_I_BFu32i { unsigned char v1; int v2; unsigned int v3:32; };
struct Uc_I_BFu32ll { unsigned char v1; int v2; unsigned long long v3:32; };
struct Uc_I_BFu33 { unsigned char v1; int v2; unsigned long long v3:33; };
struct Uc_I_BFu7c { unsigned char v1; int v2; unsigned char v3:7; };
struct Uc_I_BFu7i { unsigned char v1; int v2; unsigned int v3:7; };
struct Uc_I_BFu7ll { unsigned char v1; int v2; unsigned long long v3:7; };
struct Uc_I_BFu7s { unsigned char v1; int v2; unsigned short v3:7; };
struct Uc_I_BFu8c { unsigned char v1; int v2; unsigned char v3:8; };
struct Uc_I_BFu8i { unsigned char v1; int v2; unsigned int v3:8; };
struct Uc_I_BFu8ll { unsigned char v1; int v2; unsigned long long v3:8; };
struct Uc_I_BFu8s { unsigned char v1; int v2; unsigned short v3:8; };
struct Uc_I_BFu9i { unsigned char v1; int v2; unsigned int v3:9; };
struct Uc_I_BFu9ll { unsigned char v1; int v2; unsigned long long v3:9; };
struct Uc_I_BFu9s { unsigned char v1; int v2; unsigned short v3:9; };
struct Uc_I_C { unsigned char v1; int v2; char v3; };
struct Uc_I_D { unsigned char v1; int v2; double v3; };
struct Uc_I_F { unsigned char v1; int v2; float v3; };
struct Uc_I_I { unsigned char v1; int v2; int v3; };
struct Uc_I_Ip { unsigned char v1; int v2; int * v3; };
struct Uc_I_L { unsigned char v1; int v2; long long v3; };
struct Uc_I_S { unsigned char v1; int v2; short v3; };
struct Uc_I_Uc { unsigned char v1; int v2; unsigned char v3; };
struct Uc_I_Ui { unsigned char v1; int v2; unsigned int v3; };
struct Uc_I_Ul { unsigned char v1; int v2; unsigned long long v3; };
struct Uc_I_Us { unsigned char v1; int v2; unsigned short v3; };
struct Uc_I_Vp { unsigned char v1; int v2; void * v3; };
struct Uc_Ip { unsigned char v1; int * v2; };
struct Uc_Ip_BFu15i { unsigned char v1; int * v2; unsigned int v3:15; };
struct Uc_Ip_BFu15ll { unsigned char v1; int * v2; unsigned long long v3:15; };
struct Uc_Ip_BFu15s { unsigned char v1; int * v2; unsigned short v3:15; };
struct Uc_Ip_BFu16i { unsigned char v1; int * v2; unsigned int v3:16; };
struct Uc_Ip_BFu16ll { unsigned char v1; int * v2; unsigned long long v3:16; };
struct Uc_Ip_BFu16s { unsigned char v1; int * v2; unsigned short v3:16; };
struct Uc_Ip_BFu17i { unsigned char v1; int * v2; unsigned int v3:17; };
struct Uc_Ip_BFu17ll { unsigned char v1; int * v2; unsigned long long v3:17; };
struct Uc_Ip_BFu1c { unsigned char v1; int * v2; unsigned char v3:1; };
struct Uc_Ip_BFu1i { unsigned char v1; int * v2; unsigned int v3:1; };
struct Uc_Ip_BFu1ll { unsigned char v1; int * v2; unsigned long long v3:1; };
struct Uc_Ip_BFu1s { unsigned char v1; int * v2; unsigned short v3:1; };
struct Uc_Ip_BFu31i { unsigned char v1; int * v2; unsigned int v3:31; };
struct Uc_Ip_BFu31ll { unsigned char v1; int * v2; unsigned long long v3:31; };
struct Uc_Ip_BFu32i { unsigned char v1; int * v2; unsigned int v3:32; };
struct Uc_Ip_BFu32ll { unsigned char v1; int * v2; unsigned long long v3:32; };
struct Uc_Ip_BFu33 { unsigned char v1; int * v2; unsigned long long v3:33; };
struct Uc_Ip_BFu7c { unsigned char v1; int * v2; unsigned char v3:7; };
struct Uc_Ip_BFu7i { unsigned char v1; int * v2; unsigned int v3:7; };
struct Uc_Ip_BFu7ll { unsigned char v1; int * v2; unsigned long long v3:7; };
struct Uc_Ip_BFu7s { unsigned char v1; int * v2; unsigned short v3:7; };
struct Uc_Ip_BFu8c { unsigned char v1; int * v2; unsigned char v3:8; };
struct Uc_Ip_BFu8i { unsigned char v1; int * v2; unsigned int v3:8; };
struct Uc_Ip_BFu8ll { unsigned char v1; int * v2; unsigned long long v3:8; };
struct Uc_Ip_BFu8s { unsigned char v1; int * v2; unsigned short v3:8; };
struct Uc_Ip_BFu9i { unsigned char v1; int * v2; unsigned int v3:9; };
struct Uc_Ip_BFu9ll { unsigned char v1; int * v2; unsigned long long v3:9; };
struct Uc_Ip_BFu9s { unsigned char v1; int * v2; unsigned short v3:9; };
struct Uc_Ip_C { unsigned char v1; int * v2; char v3; };
struct Uc_Ip_D { unsigned char v1; int * v2; double v3; };
struct Uc_Ip_F { unsigned char v1; int * v2; float v3; };
struct Uc_Ip_I { unsigned char v1; int * v2; int v3; };
struct Uc_Ip_Ip { unsigned char v1; int * v2; int * v3; };
struct Uc_Ip_L { unsigned char v1; int * v2; long long v3; };
struct Uc_Ip_S { unsigned char v1; int * v2; short v3; };
struct Uc_Ip_Uc { unsigned char v1; int * v2; unsigned char v3; };
struct Uc_Ip_Ui { unsigned char v1; int * v2; unsigned int v3; };
struct Uc_Ip_Ul { unsigned char v1; int * v2; unsigned long long v3; };
struct Uc_Ip_Us { unsigned char v1; int * v2; unsigned short v3; };
struct Uc_Ip_Vp { unsigned char v1; int * v2; void * v3; };
struct Uc_L { unsigned char v1; long long v2; };
struct Uc_L_BFu15i { unsigned char v1; long long v2; unsigned int v3:15; };
struct Uc_L_BFu15ll { unsigned char v1; long long v2; unsigned long long v3:15; };
struct Uc_L_BFu15s { unsigned char v1; long long v2; unsigned short v3:15; };
struct Uc_L_BFu16i { unsigned char v1; long long v2; unsigned int v3:16; };
struct Uc_L_BFu16ll { unsigned char v1; long long v2; unsigned long long v3:16; };
struct Uc_L_BFu16s { unsigned char v1; long long v2; unsigned short v3:16; };
struct Uc_L_BFu17i { unsigned char v1; long long v2; unsigned int v3:17; };
struct Uc_L_BFu17ll { unsigned char v1; long long v2; unsigned long long v3:17; };
struct Uc_L_BFu1c { unsigned char v1; long long v2; unsigned char v3:1; };
struct Uc_L_BFu1i { unsigned char v1; long long v2; unsigned int v3:1; };
struct Uc_L_BFu1ll { unsigned char v1; long long v2; unsigned long long v3:1; };
struct Uc_L_BFu1s { unsigned char v1; long long v2; unsigned short v3:1; };
struct Uc_L_BFu31i { unsigned char v1; long long v2; unsigned int v3:31; };
struct Uc_L_BFu31ll { unsigned char v1; long long v2; unsigned long long v3:31; };
struct Uc_L_BFu32i { unsigned char v1; long long v2; unsigned int v3:32; };
struct Uc_L_BFu32ll { unsigned char v1; long long v2; unsigned long long v3:32; };
struct Uc_L_BFu33 { unsigned char v1; long long v2; unsigned long long v3:33; };
struct Uc_L_BFu7c { unsigned char v1; long long v2; unsigned char v3:7; };
struct Uc_L_BFu7i { unsigned char v1; long long v2; unsigned int v3:7; };
struct Uc_L_BFu7ll { unsigned char v1; long long v2; unsigned long long v3:7; };
struct Uc_L_BFu7s { unsigned char v1; long long v2; unsigned short v3:7; };
struct Uc_L_BFu8c { unsigned char v1; long long v2; unsigned char v3:8; };
struct Uc_L_BFu8i { unsigned char v1; long long v2; unsigned int v3:8; };
struct Uc_L_BFu8ll { unsigned char v1; long long v2; unsigned long long v3:8; };
struct Uc_L_BFu8s { unsigned char v1; long long v2; unsigned short v3:8; };
struct Uc_L_BFu9i { unsigned char v1; long long v2; unsigned int v3:9; };
struct Uc_L_BFu9ll { unsigned char v1; long long v2; unsigned long long v3:9; };
struct Uc_L_BFu9s { unsigned char v1; long long v2; unsigned short v3:9; };
struct Uc_L_C { unsigned char v1; long long v2; char v3; };
struct Uc_L_D { unsigned char v1; long long v2; double v3; };
struct Uc_L_F { unsigned char v1; long long v2; float v3; };
struct Uc_L_I { unsigned char v1; long long v2; int v3; };
struct Uc_L_Ip { unsigned char v1; long long v2; int * v3; };
struct Uc_L_L { unsigned char v1; long long v2; long long v3; };
struct Uc_L_S { unsigned char v1; long long v2; short v3; };
struct Uc_L_Uc { unsigned char v1; long long v2; unsigned char v3; };
struct Uc_L_Ui { unsigned char v1; long long v2; unsigned int v3; };
struct Uc_L_Ul { unsigned char v1; long long v2; unsigned long long v3; };
struct Uc_L_Us { unsigned char v1; long long v2; unsigned short v3; };
struct Uc_L_Vp { unsigned char v1; long long v2; void * v3; };
struct Uc_S { unsigned char v1; short v2; };
struct Uc_S_BFu15i { unsigned char v1; short v2; unsigned int v3:15; };
struct Uc_S_BFu15ll { unsigned char v1; short v2; unsigned long long v3:15; };
struct Uc_S_BFu15s { unsigned char v1; short v2; unsigned short v3:15; };
struct Uc_S_BFu16i { unsigned char v1; short v2; unsigned int v3:16; };
struct Uc_S_BFu16ll { unsigned char v1; short v2; unsigned long long v3:16; };
struct Uc_S_BFu16s { unsigned char v1; short v2; unsigned short v3:16; };
struct Uc_S_BFu17i { unsigned char v1; short v2; unsigned int v3:17; };
struct Uc_S_BFu17ll { unsigned char v1; short v2; unsigned long long v3:17; };
struct Uc_S_BFu1c { unsigned char v1; short v2; unsigned char v3:1; };
struct Uc_S_BFu1i { unsigned char v1; short v2; unsigned int v3:1; };
struct Uc_S_BFu1ll { unsigned char v1; short v2; unsigned long long v3:1; };
struct Uc_S_BFu1s { unsigned char v1; short v2; unsigned short v3:1; };
struct Uc_S_BFu31i { unsigned char v1; short v2; unsigned int v3:31; };
struct Uc_S_BFu31ll { unsigned char v1; short v2; unsigned long long v3:31; };
struct Uc_S_BFu32i { unsigned char v1; short v2; unsigned int v3:32; };
struct Uc_S_BFu32ll { unsigned char v1; short v2; unsigned long long v3:32; };
struct Uc_S_BFu33 { unsigned char v1; short v2; unsigned long long v3:33; };
struct Uc_S_BFu7c { unsigned char v1; short v2; unsigned char v3:7; };
struct Uc_S_BFu7i { unsigned char v1; short v2; unsigned int v3:7; };
struct Uc_S_BFu7ll { unsigned char v1; short v2; unsigned long long v3:7; };
struct Uc_S_BFu7s { unsigned char v1; short v2; unsigned short v3:7; };
struct Uc_S_BFu8c { unsigned char v1; short v2; unsigned char v3:8; };
struct Uc_S_BFu8i { unsigned char v1; short v2; unsigned int v3:8; };
struct Uc_S_BFu8ll { unsigned char v1; short v2; unsigned long long v3:8; };
struct Uc_S_BFu8s { unsigned char v1; short v2; unsigned short v3:8; };
struct Uc_S_BFu9i { unsigned char v1; short v2; unsigned int v3:9; };
struct Uc_S_BFu9ll { unsigned char v1; short v2; unsigned long long v3:9; };
struct Uc_S_BFu9s { unsigned char v1; short v2; unsigned short v3:9; };
struct Uc_S_C { unsigned char v1; short v2; char v3; };
struct Uc_S_D { unsigned char v1; short v2; double v3; };
struct Uc_S_F { unsigned char v1; short v2; float v3; };
struct Uc_S_I { unsigned char v1; short v2; int v3; };
struct Uc_S_Ip { unsigned char v1; short v2; int * v3; };
struct Uc_S_L { unsigned char v1; short v2; long long v3; };
struct Uc_S_S { unsigned char v1; short v2; short v3; };
struct Uc_S_Uc { unsigned char v1; short v2; unsigned char v3; };
struct Uc_S_Ui { unsigned char v1; short v2; unsigned int v3; };
struct Uc_S_Ul { unsigned char v1; short v2; unsigned long long v3; };
struct Uc_S_Us { unsigned char v1; short v2; unsigned short v3; };
struct Uc_S_Vp { unsigned char v1; short v2; void * v3; };
struct Uc_Uc { unsigned char v1; unsigned char v2; };
struct Uc_Uc_BFu15i { unsigned char v1; unsigned char v2; unsigned int v3:15; };
struct Uc_Uc_BFu15ll { unsigned char v1; unsigned char v2; unsigned long long v3:15; };
struct Uc_Uc_BFu15s { unsigned char v1; unsigned char v2; unsigned short v3:15; };
struct Uc_Uc_BFu16i { unsigned char v1; unsigned char v2; unsigned int v3:16; };
struct Uc_Uc_BFu16ll { unsigned char v1; unsigned char v2; unsigned long long v3:16; };
struct Uc_Uc_BFu16s { unsigned char v1; unsigned char v2; unsigned short v3:16; };
struct Uc_Uc_BFu17i { unsigned char v1; unsigned char v2; unsigned int v3:17; };
struct Uc_Uc_BFu17ll { unsigned char v1; unsigned char v2; unsigned long long v3:17; };
struct Uc_Uc_BFu1c { unsigned char v1; unsigned char v2; unsigned char v3:1; };
struct Uc_Uc_BFu1i { unsigned char v1; unsigned char v2; unsigned int v3:1; };
struct Uc_Uc_BFu1ll { unsigned char v1; unsigned char v2; unsigned long long v3:1; };
struct Uc_Uc_BFu1s { unsigned char v1; unsigned char v2; unsigned short v3:1; };
struct Uc_Uc_BFu31i { unsigned char v1; unsigned char v2; unsigned int v3:31; };
struct Uc_Uc_BFu31ll { unsigned char v1; unsigned char v2; unsigned long long v3:31; };
struct Uc_Uc_BFu32i { unsigned char v1; unsigned char v2; unsigned int v3:32; };
struct Uc_Uc_BFu32ll { unsigned char v1; unsigned char v2; unsigned long long v3:32; };
struct Uc_Uc_BFu33 { unsigned char v1; unsigned char v2; unsigned long long v3:33; };
struct Uc_Uc_BFu7c { unsigned char v1; unsigned char v2; unsigned char v3:7; };
struct Uc_Uc_BFu7i { unsigned char v1; unsigned char v2; unsigned int v3:7; };
struct Uc_Uc_BFu7ll { unsigned char v1; unsigned char v2; unsigned long long v3:7; };
struct Uc_Uc_BFu7s { unsigned char v1; unsigned char v2; unsigned short v3:7; };
struct Uc_Uc_BFu8c { unsigned char v1; unsigned char v2; unsigned char v3:8; };
struct Uc_Uc_BFu8i { unsigned char v1; unsigned char v2; unsigned int v3:8; };
struct Uc_Uc_BFu8ll { unsigned char v1; unsigned char v2; unsigned long long v3:8; };
struct Uc_Uc_BFu8s { unsigned char v1; unsigned char v2; unsigned short v3:8; };
struct Uc_Uc_BFu9i { unsigned char v1; unsigned char v2; unsigned int v3:9; };
struct Uc_Uc_BFu9ll { unsigned char v1; unsigned char v2; unsigned long long v3:9; };
struct Uc_Uc_BFu9s { unsigned char v1; unsigned char v2; unsigned short v3:9; };
struct Uc_Uc_C { unsigned char v1; unsigned char v2; char v3; };
struct Uc_Uc_D { unsigned char v1; unsigned char v2; double v3; };
struct Uc_Uc_F { unsigned char v1; unsigned char v2; float v3; };
struct Uc_Uc_I { unsigned char v1; unsigned char v2; int v3; };
struct Uc_Uc_Ip { unsigned char v1; unsigned char v2; int * v3; };
struct Uc_Uc_L { unsigned char v1; unsigned char v2; long long v3; };
struct Uc_Uc_S { unsigned char v1; unsigned char v2; short v3; };
struct Uc_Uc_Uc { unsigned char v1; unsigned char v2; unsigned char v3; };
struct Uc_Uc_Ui { unsigned char v1; unsigned char v2; unsigned int v3; };
struct Uc_Uc_Ul { unsigned char v1; unsigned char v2; unsigned long long v3; };
struct Uc_Uc_Us { unsigned char v1; unsigned char v2; unsigned short v3; };
struct Uc_Uc_Vp { unsigned char v1; unsigned char v2; void * v3; };
struct Uc_Ui { unsigned char v1; unsigned int v2; };
struct Uc_Ui_BFu15i { unsigned char v1; unsigned int v2; unsigned int v3:15; };
struct Uc_Ui_BFu15ll { unsigned char v1; unsigned int v2; unsigned long long v3:15; };
struct Uc_Ui_BFu15s { unsigned char v1; unsigned int v2; unsigned short v3:15; };
struct Uc_Ui_BFu16i { unsigned char v1; unsigned int v2; unsigned int v3:16; };
struct Uc_Ui_BFu16ll { unsigned char v1; unsigned int v2; unsigned long long v3:16; };
struct Uc_Ui_BFu16s { unsigned char v1; unsigned int v2; unsigned short v3:16; };
struct Uc_Ui_BFu17i { unsigned char v1; unsigned int v2; unsigned int v3:17; };
struct Uc_Ui_BFu17ll { unsigned char v1; unsigned int v2; unsigned long long v3:17; };
struct Uc_Ui_BFu1c { unsigned char v1; unsigned int v2; unsigned char v3:1; };
struct Uc_Ui_BFu1i { unsigned char v1; unsigned int v2; unsigned int v3:1; };
struct Uc_Ui_BFu1ll { unsigned char v1; unsigned int v2; unsigned long long v3:1; };
struct Uc_Ui_BFu1s { unsigned char v1; unsigned int v2; unsigned short v3:1; };
struct Uc_Ui_BFu31i { unsigned char v1; unsigned int v2; unsigned int v3:31; };
struct Uc_Ui_BFu31ll { unsigned char v1; unsigned int v2; unsigned long long v3:31; };
struct Uc_Ui_BFu32i { unsigned char v1; unsigned int v2; unsigned int v3:32; };
struct Uc_Ui_BFu32ll { unsigned char v1; unsigned int v2; unsigned long long v3:32; };
struct Uc_Ui_BFu33 { unsigned char v1; unsigned int v2; unsigned long long v3:33; };
struct Uc_Ui_BFu7c { unsigned char v1; unsigned int v2; unsigned char v3:7; };
struct Uc_Ui_BFu7i { unsigned char v1; unsigned int v2; unsigned int v3:7; };
struct Uc_Ui_BFu7ll { unsigned char v1; unsigned int v2; unsigned long long v3:7; };
struct Uc_Ui_BFu7s { unsigned char v1; unsigned int v2; unsigned short v3:7; };
struct Uc_Ui_BFu8c { unsigned char v1; unsigned int v2; unsigned char v3:8; };
struct Uc_Ui_BFu8i { unsigned char v1; unsigned int v2; unsigned int v3:8; };
struct Uc_Ui_BFu8ll { unsigned char v1; unsigned int v2; unsigned long long v3:8; };
struct Uc_Ui_BFu8s { unsigned char v1; unsigned int v2; unsigned short v3:8; };
struct Uc_Ui_BFu9i { unsigned char v1; unsigned int v2; unsigned int v3:9; };
struct Uc_Ui_BFu9ll { unsigned char v1; unsigned int v2; unsigned long long v3:9; };
struct Uc_Ui_BFu9s { unsigned char v1; unsigned int v2; unsigned short v3:9; };
struct Uc_Ui_C { unsigned char v1; unsigned int v2; char v3; };
struct Uc_Ui_D { unsigned char v1; unsigned int v2; double v3; };
struct Uc_Ui_F { unsigned char v1; unsigned int v2; float v3; };
struct Uc_Ui_I { unsigned char v1; unsigned int v2; int v3; };
struct Uc_Ui_Ip { unsigned char v1; unsigned int v2; int * v3; };
struct Uc_Ui_L { unsigned char v1; unsigned int v2; long long v3; };
struct Uc_Ui_S { unsigned char v1; unsigned int v2; short v3; };
struct Uc_Ui_Uc { unsigned char v1; unsigned int v2; unsigned char v3; };
struct Uc_Ui_Ui { unsigned char v1; unsigned int v2; unsigned int v3; };
struct Uc_Ui_Ul { unsigned char v1; unsigned int v2; unsigned long long v3; };
struct Uc_Ui_Us { unsigned char v1; unsigned int v2; unsigned short v3; };
struct Uc_Ui_Vp { unsigned char v1; unsigned int v2; void * v3; };
struct Uc_Ul { unsigned char v1; unsigned long long v2; };
struct Uc_Ul_BFu15i { unsigned char v1; unsigned long long v2; unsigned int v3:15; };
struct Uc_Ul_BFu15ll { unsigned char v1; unsigned long long v2; unsigned long long v3:15; };
struct Uc_Ul_BFu15s { unsigned char v1; unsigned long long v2; unsigned short v3:15; };
struct Uc_Ul_BFu16i { unsigned char v1; unsigned long long v2; unsigned int v3:16; };
struct Uc_Ul_BFu16ll { unsigned char v1; unsigned long long v2; unsigned long long v3:16; };
struct Uc_Ul_BFu16s { unsigned char v1; unsigned long long v2; unsigned short v3:16; };
struct Uc_Ul_BFu17i { unsigned char v1; unsigned long long v2; unsigned int v3:17; };
struct Uc_Ul_BFu17ll { unsigned char v1; unsigned long long v2; unsigned long long v3:17; };
struct Uc_Ul_BFu1c { unsigned char v1; unsigned long long v2; unsigned char v3:1; };
struct Uc_Ul_BFu1i { unsigned char v1; unsigned long long v2; unsigned int v3:1; };
struct Uc_Ul_BFu1ll { unsigned char v1; unsigned long long v2; unsigned long long v3:1; };
struct Uc_Ul_BFu1s { unsigned char v1; unsigned long long v2; unsigned short v3:1; };
struct Uc_Ul_BFu31i { unsigned char v1; unsigned long long v2; unsigned int v3:31; };
struct Uc_Ul_BFu31ll { unsigned char v1; unsigned long long v2; unsigned long long v3:31; };
struct Uc_Ul_BFu32i { unsigned char v1; unsigned long long v2; unsigned int v3:32; };
struct Uc_Ul_BFu32ll { unsigned char v1; unsigned long long v2; unsigned long long v3:32; };
struct Uc_Ul_BFu33 { unsigned char v1; unsigned long long v2; unsigned long long v3:33; };
struct Uc_Ul_BFu7c { unsigned char v1; unsigned long long v2; unsigned char v3:7; };
struct Uc_Ul_BFu7i { unsigned char v1; unsigned long long v2; unsigned int v3:7; };
struct Uc_Ul_BFu7ll { unsigned char v1; unsigned long long v2; unsigned long long v3:7; };
struct Uc_Ul_BFu7s { unsigned char v1; unsigned long long v2; unsigned short v3:7; };
struct Uc_Ul_BFu8c { unsigned char v1; unsigned long long v2; unsigned char v3:8; };
struct Uc_Ul_BFu8i { unsigned char v1; unsigned long long v2; unsigned int v3:8; };
struct Uc_Ul_BFu8ll { unsigned char v1; unsigned long long v2; unsigned long long v3:8; };
struct Uc_Ul_BFu8s { unsigned char v1; unsigned long long v2; unsigned short v3:8; };
struct Uc_Ul_BFu9i { unsigned char v1; unsigned long long v2; unsigned int v3:9; };
struct Uc_Ul_BFu9ll { unsigned char v1; unsigned long long v2; unsigned long long v3:9; };
struct Uc_Ul_BFu9s { unsigned char v1; unsigned long long v2; unsigned short v3:9; };
struct Uc_Ul_C { unsigned char v1; unsigned long long v2; char v3; };
struct Uc_Ul_D { unsigned char v1; unsigned long long v2; double v3; };
struct Uc_Ul_F { unsigned char v1; unsigned long long v2; float v3; };
struct Uc_Ul_I { unsigned char v1; unsigned long long v2; int v3; };
struct Uc_Ul_Ip { unsigned char v1; unsigned long long v2; int * v3; };
struct Uc_Ul_L { unsigned char v1; unsigned long long v2; long long v3; };
struct Uc_Ul_S { unsigned char v1; unsigned long long v2; short v3; };
struct Uc_Ul_Uc { unsigned char v1; unsigned long long v2; unsigned char v3; };
struct Uc_Ul_Ui { unsigned char v1; unsigned long long v2; unsigned int v3; };
struct Uc_Ul_Ul { unsigned char v1; unsigned long long v2; unsigned long long v3; };
struct Uc_Ul_Us { unsigned char v1; unsigned long long v2; unsigned short v3; };
struct Uc_Ul_Vp { unsigned char v1; unsigned long long v2; void * v3; };
struct Uc_Us { unsigned char v1; unsigned short v2; };
struct Uc_Us_BFu15i { unsigned char v1; unsigned short v2; unsigned int v3:15; };
struct Uc_Us_BFu15ll { unsigned char v1; unsigned short v2; unsigned long long v3:15; };
struct Uc_Us_BFu15s { unsigned char v1; unsigned short v2; unsigned short v3:15; };
struct Uc_Us_BFu16i { unsigned char v1; unsigned short v2; unsigned int v3:16; };
struct Uc_Us_BFu16ll { unsigned char v1; unsigned short v2; unsigned long long v3:16; };
struct Uc_Us_BFu16s { unsigned char v1; unsigned short v2; unsigned short v3:16; };
struct Uc_Us_BFu17i { unsigned char v1; unsigned short v2; unsigned int v3:17; };
struct Uc_Us_BFu17ll { unsigned char v1; unsigned short v2; unsigned long long v3:17; };
struct Uc_Us_BFu1c { unsigned char v1; unsigned short v2; unsigned char v3:1; };
struct Uc_Us_BFu1i { unsigned char v1; unsigned short v2; unsigned int v3:1; };
struct Uc_Us_BFu1ll { unsigned char v1; unsigned short v2; unsigned long long v3:1; };
struct Uc_Us_BFu1s { unsigned char v1; unsigned short v2; unsigned short v3:1; };
struct Uc_Us_BFu31i { unsigned char v1; unsigned short v2; unsigned int v3:31; };
struct Uc_Us_BFu31ll { unsigned char v1; unsigned short v2; unsigned long long v3:31; };
struct Uc_Us_BFu32i { unsigned char v1; unsigned short v2; unsigned int v3:32; };
struct Uc_Us_BFu32ll { unsigned char v1; unsigned short v2; unsigned long long v3:32; };
struct Uc_Us_BFu33 { unsigned char v1; unsigned short v2; unsigned long long v3:33; };
struct Uc_Us_BFu7c { unsigned char v1; unsigned short v2; unsigned char v3:7; };
struct Uc_Us_BFu7i { unsigned char v1; unsigned short v2; unsigned int v3:7; };
struct Uc_Us_BFu7ll { unsigned char v1; unsigned short v2; unsigned long long v3:7; };
struct Uc_Us_BFu7s { unsigned char v1; unsigned short v2; unsigned short v3:7; };
struct Uc_Us_BFu8c { unsigned char v1; unsigned short v2; unsigned char v3:8; };
struct Uc_Us_BFu8i { unsigned char v1; unsigned short v2; unsigned int v3:8; };
struct Uc_Us_BFu8ll { unsigned char v1; unsigned short v2; unsigned long long v3:8; };
struct Uc_Us_BFu8s { unsigned char v1; unsigned short v2; unsigned short v3:8; };
struct Uc_Us_BFu9i { unsigned char v1; unsigned short v2; unsigned int v3:9; };
struct Uc_Us_BFu9ll { unsigned char v1; unsigned short v2; unsigned long long v3:9; };
struct Uc_Us_BFu9s { unsigned char v1; unsigned short v2; unsigned short v3:9; };
struct Uc_Us_C { unsigned char v1; unsigned short v2; char v3; };
struct Uc_Us_D { unsigned char v1; unsigned short v2; double v3; };
struct Uc_Us_F { unsigned char v1; unsigned short v2; float v3; };
struct Uc_Us_I { unsigned char v1; unsigned short v2; int v3; };
struct Uc_Us_Ip { unsigned char v1; unsigned short v2; int * v3; };
struct Uc_Us_L { unsigned char v1; unsigned short v2; long long v3; };
struct Uc_Us_S { unsigned char v1; unsigned short v2; short v3; };
struct Uc_Us_Uc { unsigned char v1; unsigned short v2; unsigned char v3; };
struct Uc_Us_Ui { unsigned char v1; unsigned short v2; unsigned int v3; };
struct Uc_Us_Ul { unsigned char v1; unsigned short v2; unsigned long long v3; };
struct Uc_Us_Us { unsigned char v1; unsigned short v2; unsigned short v3; };
struct Uc_Us_Vp { unsigned char v1; unsigned short v2; void * v3; };
struct Uc_Vp { unsigned char v1; void * v2; };
struct Uc_Vp_BFu15i { unsigned char v1; void * v2; unsigned int v3:15; };
struct Uc_Vp_BFu15ll { unsigned char v1; void * v2; unsigned long long v3:15; };
struct Uc_Vp_BFu15s { unsigned char v1; void * v2; unsigned short v3:15; };
struct Uc_Vp_BFu16i { unsigned char v1; void * v2; unsigned int v3:16; };
struct Uc_Vp_BFu16ll { unsigned char v1; void * v2; unsigned long long v3:16; };
struct Uc_Vp_BFu16s { unsigned char v1; void * v2; unsigned short v3:16; };
struct Uc_Vp_BFu17i { unsigned char v1; void * v2; unsigned int v3:17; };
struct Uc_Vp_BFu17ll { unsigned char v1; void * v2; unsigned long long v3:17; };
struct Uc_Vp_BFu1c { unsigned char v1; void * v2; unsigned char v3:1; };
struct Uc_Vp_BFu1i { unsigned char v1; void * v2; unsigned int v3:1; };
struct Uc_Vp_BFu1ll { unsigned char v1; void * v2; unsigned long long v3:1; };
struct Uc_Vp_BFu1s { unsigned char v1; void * v2; unsigned short v3:1; };
struct Uc_Vp_BFu31i { unsigned char v1; void * v2; unsigned int v3:31; };
struct Uc_Vp_BFu31ll { unsigned char v1; void * v2; unsigned long long v3:31; };
struct Uc_Vp_BFu32i { unsigned char v1; void * v2; unsigned int v3:32; };
struct Uc_Vp_BFu32ll { unsigned char v1; void * v2; unsigned long long v3:32; };
struct Uc_Vp_BFu33 { unsigned char v1; void * v2; unsigned long long v3:33; };
struct Uc_Vp_BFu7c { unsigned char v1; void * v2; unsigned char v3:7; };
struct Uc_Vp_BFu7i { unsigned char v1; void * v2; unsigned int v3:7; };
struct Uc_Vp_BFu7ll { unsigned char v1; void * v2; unsigned long long v3:7; };
struct Uc_Vp_BFu7s { unsigned char v1; void * v2; unsigned short v3:7; };
struct Uc_Vp_BFu8c { unsigned char v1; void * v2; unsigned char v3:8; };
struct Uc_Vp_BFu8i { unsigned char v1; void * v2; unsigned int v3:8; };
struct Uc_Vp_BFu8ll { unsigned char v1; void * v2; unsigned long long v3:8; };
struct Uc_Vp_BFu8s { unsigned char v1; void * v2; unsigned short v3:8; };
struct Uc_Vp_BFu9i { unsigned char v1; void * v2; unsigned int v3:9; };
struct Uc_Vp_BFu9ll { unsigned char v1; void * v2; unsigned long long v3:9; };
struct Uc_Vp_BFu9s { unsigned char v1; void * v2; unsigned short v3:9; };
struct Uc_Vp_C { unsigned char v1; void * v2; char v3; };
struct Uc_Vp_D { unsigned char v1; void * v2; double v3; };
struct Uc_Vp_F { unsigned char v1; void * v2; float v3; };
struct Uc_Vp_I { unsigned char v1; void * v2; int v3; };
struct Uc_Vp_Ip { unsigned char v1; void * v2; int * v3; };
struct Uc_Vp_L { unsigned char v1; void * v2; long long v3; };
struct Uc_Vp_S { unsigned char v1; void * v2; short v3; };
struct Uc_Vp_Uc { unsigned char v1; void * v2; unsigned char v3; };
struct Uc_Vp_Ui { unsigned char v1; void * v2; unsigned int v3; };
struct Uc_Vp_Ul { unsigned char v1; void * v2; unsigned long long v3; };
struct Uc_Vp_Us { unsigned char v1; void * v2; unsigned short v3; };
struct Uc_Vp_Vp { unsigned char v1; void * v2; void * v3; };
struct Ui { unsigned int v1; };
struct Ui_BFu15i { unsigned int v1; unsigned int v2:15; };
struct Ui_BFu15i_BFu15i { unsigned int v1; unsigned int v2:15; unsigned int v3:15; };
struct Ui_BFu15i_BFu15ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:15; };
struct Ui_BFu15i_BFu15s { unsigned int v1; unsigned int v2:15; unsigned short v3:15; };
struct Ui_BFu15i_BFu16i { unsigned int v1; unsigned int v2:15; unsigned int v3:16; };
struct Ui_BFu15i_BFu16ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:16; };
struct Ui_BFu15i_BFu16s { unsigned int v1; unsigned int v2:15; unsigned short v3:16; };
struct Ui_BFu15i_BFu17i { unsigned int v1; unsigned int v2:15; unsigned int v3:17; };
struct Ui_BFu15i_BFu17ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:17; };
struct Ui_BFu15i_BFu1c { unsigned int v1; unsigned int v2:15; unsigned char v3:1; };
struct Ui_BFu15i_BFu1i { unsigned int v1; unsigned int v2:15; unsigned int v3:1; };
struct Ui_BFu15i_BFu1ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:1; };
struct Ui_BFu15i_BFu1s { unsigned int v1; unsigned int v2:15; unsigned short v3:1; };
struct Ui_BFu15i_BFu31i { unsigned int v1; unsigned int v2:15; unsigned int v3:31; };
struct Ui_BFu15i_BFu31ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:31; };
struct Ui_BFu15i_BFu32i { unsigned int v1; unsigned int v2:15; unsigned int v3:32; };
struct Ui_BFu15i_BFu32ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:32; };
struct Ui_BFu15i_BFu33 { unsigned int v1; unsigned int v2:15; unsigned long long v3:33; };
struct Ui_BFu15i_BFu7c { unsigned int v1; unsigned int v2:15; unsigned char v3:7; };
struct Ui_BFu15i_BFu7i { unsigned int v1; unsigned int v2:15; unsigned int v3:7; };
struct Ui_BFu15i_BFu7ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:7; };
struct Ui_BFu15i_BFu7s { unsigned int v1; unsigned int v2:15; unsigned short v3:7; };
struct Ui_BFu15i_BFu8c { unsigned int v1; unsigned int v2:15; unsigned char v3:8; };
struct Ui_BFu15i_BFu8i { unsigned int v1; unsigned int v2:15; unsigned int v3:8; };
struct Ui_BFu15i_BFu8ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:8; };
struct Ui_BFu15i_BFu8s { unsigned int v1; unsigned int v2:15; unsigned short v3:8; };
struct Ui_BFu15i_BFu9i { unsigned int v1; unsigned int v2:15; unsigned int v3:9; };
struct Ui_BFu15i_BFu9ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:9; };
struct Ui_BFu15i_BFu9s { unsigned int v1; unsigned int v2:15; unsigned short v3:9; };
struct Ui_BFu15i_C { unsigned int v1; unsigned int v2:15; char v3; };
struct Ui_BFu15i_D { unsigned int v1; unsigned int v2:15; double v3; };
struct Ui_BFu15i_F { unsigned int v1; unsigned int v2:15; float v3; };
struct Ui_BFu15i_I { unsigned int v1; unsigned int v2:15; int v3; };
struct Ui_BFu15i_Ip { unsigned int v1; unsigned int v2:15; int * v3; };
struct Ui_BFu15i_L { unsigned int v1; unsigned int v2:15; long long v3; };
struct Ui_BFu15i_S { unsigned int v1; unsigned int v2:15; short v3; };
struct Ui_BFu15i_Uc { unsigned int v1; unsigned int v2:15; unsigned char v3; };
struct Ui_BFu15i_Ui { unsigned int v1; unsigned int v2:15; unsigned int v3; };
struct Ui_BFu15i_Ul { unsigned int v1; unsigned int v2:15; unsigned long long v3; };
struct Ui_BFu15i_Us { unsigned int v1; unsigned int v2:15; unsigned short v3; };
struct Ui_BFu15i_Vp { unsigned int v1; unsigned int v2:15; void * v3; };
struct Ui_BFu15ll { unsigned int v1; unsigned long long v2:15; };
struct Ui_BFu15ll_BFu15i { unsigned int v1; unsigned long long v2:15; unsigned int v3:15; };
struct Ui_BFu15ll_BFu15ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:15; };
struct Ui_BFu15ll_BFu15s { unsigned int v1; unsigned long long v2:15; unsigned short v3:15; };
struct Ui_BFu15ll_BFu16i { unsigned int v1; unsigned long long v2:15; unsigned int v3:16; };
struct Ui_BFu15ll_BFu16ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:16; };
struct Ui_BFu15ll_BFu16s { unsigned int v1; unsigned long long v2:15; unsigned short v3:16; };
struct Ui_BFu15ll_BFu17i { unsigned int v1; unsigned long long v2:15; unsigned int v3:17; };
struct Ui_BFu15ll_BFu17ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:17; };
struct Ui_BFu15ll_BFu1c { unsigned int v1; unsigned long long v2:15; unsigned char v3:1; };
struct Ui_BFu15ll_BFu1i { unsigned int v1; unsigned long long v2:15; unsigned int v3:1; };
struct Ui_BFu15ll_BFu1ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:1; };
struct Ui_BFu15ll_BFu1s { unsigned int v1; unsigned long long v2:15; unsigned short v3:1; };
struct Ui_BFu15ll_BFu31i { unsigned int v1; unsigned long long v2:15; unsigned int v3:31; };
struct Ui_BFu15ll_BFu31ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:31; };
struct Ui_BFu15ll_BFu32i { unsigned int v1; unsigned long long v2:15; unsigned int v3:32; };
struct Ui_BFu15ll_BFu32ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:32; };
struct Ui_BFu15ll_BFu33 { unsigned int v1; unsigned long long v2:15; unsigned long long v3:33; };
struct Ui_BFu15ll_BFu7c { unsigned int v1; unsigned long long v2:15; unsigned char v3:7; };
struct Ui_BFu15ll_BFu7i { unsigned int v1; unsigned long long v2:15; unsigned int v3:7; };
struct Ui_BFu15ll_BFu7ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:7; };
struct Ui_BFu15ll_BFu7s { unsigned int v1; unsigned long long v2:15; unsigned short v3:7; };
struct Ui_BFu15ll_BFu8c { unsigned int v1; unsigned long long v2:15; unsigned char v3:8; };
struct Ui_BFu15ll_BFu8i { unsigned int v1; unsigned long long v2:15; unsigned int v3:8; };
struct Ui_BFu15ll_BFu8ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:8; };
struct Ui_BFu15ll_BFu8s { unsigned int v1; unsigned long long v2:15; unsigned short v3:8; };
struct Ui_BFu15ll_BFu9i { unsigned int v1; unsigned long long v2:15; unsigned int v3:9; };
struct Ui_BFu15ll_BFu9ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:9; };
struct Ui_BFu15ll_BFu9s { unsigned int v1; unsigned long long v2:15; unsigned short v3:9; };
struct Ui_BFu15ll_C { unsigned int v1; unsigned long long v2:15; char v3; };
struct Ui_BFu15ll_D { unsigned int v1; unsigned long long v2:15; double v3; };
struct Ui_BFu15ll_F { unsigned int v1; unsigned long long v2:15; float v3; };
struct Ui_BFu15ll_I { unsigned int v1; unsigned long long v2:15; int v3; };
struct Ui_BFu15ll_Ip { unsigned int v1; unsigned long long v2:15; int * v3; };
struct Ui_BFu15ll_L { unsigned int v1; unsigned long long v2:15; long long v3; };
struct Ui_BFu15ll_S { unsigned int v1; unsigned long long v2:15; short v3; };
struct Ui_BFu15ll_Uc { unsigned int v1; unsigned long long v2:15; unsigned char v3; };
struct Ui_BFu15ll_Ui { unsigned int v1; unsigned long long v2:15; unsigned int v3; };
struct Ui_BFu15ll_Ul { unsigned int v1; unsigned long long v2:15; unsigned long long v3; };
struct Ui_BFu15ll_Us { unsigned int v1; unsigned long long v2:15; unsigned short v3; };
struct Ui_BFu15ll_Vp { unsigned int v1; unsigned long long v2:15; void * v3; };
struct Ui_BFu15s { unsigned int v1; unsigned short v2:15; };
struct Ui_BFu15s_BFu15i { unsigned int v1; unsigned short v2:15; unsigned int v3:15; };
struct Ui_BFu15s_BFu15ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:15; };
struct Ui_BFu15s_BFu15s { unsigned int v1; unsigned short v2:15; unsigned short v3:15; };
struct Ui_BFu15s_BFu16i { unsigned int v1; unsigned short v2:15; unsigned int v3:16; };
struct Ui_BFu15s_BFu16ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:16; };
struct Ui_BFu15s_BFu16s { unsigned int v1; unsigned short v2:15; unsigned short v3:16; };
struct Ui_BFu15s_BFu17i { unsigned int v1; unsigned short v2:15; unsigned int v3:17; };
struct Ui_BFu15s_BFu17ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:17; };
struct Ui_BFu15s_BFu1c { unsigned int v1; unsigned short v2:15; unsigned char v3:1; };
struct Ui_BFu15s_BFu1i { unsigned int v1; unsigned short v2:15; unsigned int v3:1; };
struct Ui_BFu15s_BFu1ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:1; };
struct Ui_BFu15s_BFu1s { unsigned int v1; unsigned short v2:15; unsigned short v3:1; };
struct Ui_BFu15s_BFu31i { unsigned int v1; unsigned short v2:15; unsigned int v3:31; };
struct Ui_BFu15s_BFu31ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:31; };
struct Ui_BFu15s_BFu32i { unsigned int v1; unsigned short v2:15; unsigned int v3:32; };
struct Ui_BFu15s_BFu32ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:32; };
struct Ui_BFu15s_BFu33 { unsigned int v1; unsigned short v2:15; unsigned long long v3:33; };
struct Ui_BFu15s_BFu7c { unsigned int v1; unsigned short v2:15; unsigned char v3:7; };
struct Ui_BFu15s_BFu7i { unsigned int v1; unsigned short v2:15; unsigned int v3:7; };
struct Ui_BFu15s_BFu7ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:7; };
struct Ui_BFu15s_BFu7s { unsigned int v1; unsigned short v2:15; unsigned short v3:7; };
struct Ui_BFu15s_BFu8c { unsigned int v1; unsigned short v2:15; unsigned char v3:8; };
struct Ui_BFu15s_BFu8i { unsigned int v1; unsigned short v2:15; unsigned int v3:8; };
struct Ui_BFu15s_BFu8ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:8; };
struct Ui_BFu15s_BFu8s { unsigned int v1; unsigned short v2:15; unsigned short v3:8; };
struct Ui_BFu15s_BFu9i { unsigned int v1; unsigned short v2:15; unsigned int v3:9; };
struct Ui_BFu15s_BFu9ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:9; };
struct Ui_BFu15s_BFu9s { unsigned int v1; unsigned short v2:15; unsigned short v3:9; };
struct Ui_BFu15s_C { unsigned int v1; unsigned short v2:15; char v3; };
struct Ui_BFu15s_D { unsigned int v1; unsigned short v2:15; double v3; };
struct Ui_BFu15s_F { unsigned int v1; unsigned short v2:15; float v3; };
struct Ui_BFu15s_I { unsigned int v1; unsigned short v2:15; int v3; };
struct Ui_BFu15s_Ip { unsigned int v1; unsigned short v2:15; int * v3; };
struct Ui_BFu15s_L { unsigned int v1; unsigned short v2:15; long long v3; };
struct Ui_BFu15s_S { unsigned int v1; unsigned short v2:15; short v3; };
struct Ui_BFu15s_Uc { unsigned int v1; unsigned short v2:15; unsigned char v3; };
struct Ui_BFu15s_Ui { unsigned int v1; unsigned short v2:15; unsigned int v3; };
struct Ui_BFu15s_Ul { unsigned int v1; unsigned short v2:15; unsigned long long v3; };
struct Ui_BFu15s_Us { unsigned int v1; unsigned short v2:15; unsigned short v3; };
struct Ui_BFu15s_Vp { unsigned int v1; unsigned short v2:15; void * v3; };
struct Ui_BFu16i { unsigned int v1; unsigned int v2:16; };
struct Ui_BFu16i_BFu15i { unsigned int v1; unsigned int v2:16; unsigned int v3:15; };
struct Ui_BFu16i_BFu15ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:15; };
struct Ui_BFu16i_BFu15s { unsigned int v1; unsigned int v2:16; unsigned short v3:15; };
struct Ui_BFu16i_BFu16i { unsigned int v1; unsigned int v2:16; unsigned int v3:16; };
struct Ui_BFu16i_BFu16ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:16; };
struct Ui_BFu16i_BFu16s { unsigned int v1; unsigned int v2:16; unsigned short v3:16; };
struct Ui_BFu16i_BFu17i { unsigned int v1; unsigned int v2:16; unsigned int v3:17; };
struct Ui_BFu16i_BFu17ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:17; };
struct Ui_BFu16i_BFu1c { unsigned int v1; unsigned int v2:16; unsigned char v3:1; };
struct Ui_BFu16i_BFu1i { unsigned int v1; unsigned int v2:16; unsigned int v3:1; };
struct Ui_BFu16i_BFu1ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:1; };
struct Ui_BFu16i_BFu1s { unsigned int v1; unsigned int v2:16; unsigned short v3:1; };
struct Ui_BFu16i_BFu31i { unsigned int v1; unsigned int v2:16; unsigned int v3:31; };
struct Ui_BFu16i_BFu31ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:31; };
struct Ui_BFu16i_BFu32i { unsigned int v1; unsigned int v2:16; unsigned int v3:32; };
struct Ui_BFu16i_BFu32ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:32; };
struct Ui_BFu16i_BFu33 { unsigned int v1; unsigned int v2:16; unsigned long long v3:33; };
struct Ui_BFu16i_BFu7c { unsigned int v1; unsigned int v2:16; unsigned char v3:7; };
struct Ui_BFu16i_BFu7i { unsigned int v1; unsigned int v2:16; unsigned int v3:7; };
struct Ui_BFu16i_BFu7ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:7; };
struct Ui_BFu16i_BFu7s { unsigned int v1; unsigned int v2:16; unsigned short v3:7; };
struct Ui_BFu16i_BFu8c { unsigned int v1; unsigned int v2:16; unsigned char v3:8; };
struct Ui_BFu16i_BFu8i { unsigned int v1; unsigned int v2:16; unsigned int v3:8; };
struct Ui_BFu16i_BFu8ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:8; };
struct Ui_BFu16i_BFu8s { unsigned int v1; unsigned int v2:16; unsigned short v3:8; };
struct Ui_BFu16i_BFu9i { unsigned int v1; unsigned int v2:16; unsigned int v3:9; };
struct Ui_BFu16i_BFu9ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:9; };
struct Ui_BFu16i_BFu9s { unsigned int v1; unsigned int v2:16; unsigned short v3:9; };
struct Ui_BFu16i_C { unsigned int v1; unsigned int v2:16; char v3; };
struct Ui_BFu16i_D { unsigned int v1; unsigned int v2:16; double v3; };
struct Ui_BFu16i_F { unsigned int v1; unsigned int v2:16; float v3; };
struct Ui_BFu16i_I { unsigned int v1; unsigned int v2:16; int v3; };
struct Ui_BFu16i_Ip { unsigned int v1; unsigned int v2:16; int * v3; };
struct Ui_BFu16i_L { unsigned int v1; unsigned int v2:16; long long v3; };
struct Ui_BFu16i_S { unsigned int v1; unsigned int v2:16; short v3; };
struct Ui_BFu16i_Uc { unsigned int v1; unsigned int v2:16; unsigned char v3; };
struct Ui_BFu16i_Ui { unsigned int v1; unsigned int v2:16; unsigned int v3; };
struct Ui_BFu16i_Ul { unsigned int v1; unsigned int v2:16; unsigned long long v3; };
struct Ui_BFu16i_Us { unsigned int v1; unsigned int v2:16; unsigned short v3; };
struct Ui_BFu16i_Vp { unsigned int v1; unsigned int v2:16; void * v3; };
struct Ui_BFu16ll { unsigned int v1; unsigned long long v2:16; };
struct Ui_BFu16ll_BFu15i { unsigned int v1; unsigned long long v2:16; unsigned int v3:15; };
struct Ui_BFu16ll_BFu15ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:15; };
struct Ui_BFu16ll_BFu15s { unsigned int v1; unsigned long long v2:16; unsigned short v3:15; };
struct Ui_BFu16ll_BFu16i { unsigned int v1; unsigned long long v2:16; unsigned int v3:16; };
struct Ui_BFu16ll_BFu16ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:16; };
struct Ui_BFu16ll_BFu16s { unsigned int v1; unsigned long long v2:16; unsigned short v3:16; };
struct Ui_BFu16ll_BFu17i { unsigned int v1; unsigned long long v2:16; unsigned int v3:17; };
struct Ui_BFu16ll_BFu17ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:17; };
struct Ui_BFu16ll_BFu1c { unsigned int v1; unsigned long long v2:16; unsigned char v3:1; };
struct Ui_BFu16ll_BFu1i { unsigned int v1; unsigned long long v2:16; unsigned int v3:1; };
struct Ui_BFu16ll_BFu1ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:1; };
struct Ui_BFu16ll_BFu1s { unsigned int v1; unsigned long long v2:16; unsigned short v3:1; };
struct Ui_BFu16ll_BFu31i { unsigned int v1; unsigned long long v2:16; unsigned int v3:31; };
struct Ui_BFu16ll_BFu31ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:31; };
struct Ui_BFu16ll_BFu32i { unsigned int v1; unsigned long long v2:16; unsigned int v3:32; };
struct Ui_BFu16ll_BFu32ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:32; };
struct Ui_BFu16ll_BFu33 { unsigned int v1; unsigned long long v2:16; unsigned long long v3:33; };
struct Ui_BFu16ll_BFu7c { unsigned int v1; unsigned long long v2:16; unsigned char v3:7; };
struct Ui_BFu16ll_BFu7i { unsigned int v1; unsigned long long v2:16; unsigned int v3:7; };
struct Ui_BFu16ll_BFu7ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:7; };
struct Ui_BFu16ll_BFu7s { unsigned int v1; unsigned long long v2:16; unsigned short v3:7; };
struct Ui_BFu16ll_BFu8c { unsigned int v1; unsigned long long v2:16; unsigned char v3:8; };
struct Ui_BFu16ll_BFu8i { unsigned int v1; unsigned long long v2:16; unsigned int v3:8; };
struct Ui_BFu16ll_BFu8ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:8; };
struct Ui_BFu16ll_BFu8s { unsigned int v1; unsigned long long v2:16; unsigned short v3:8; };
struct Ui_BFu16ll_BFu9i { unsigned int v1; unsigned long long v2:16; unsigned int v3:9; };
struct Ui_BFu16ll_BFu9ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:9; };
struct Ui_BFu16ll_BFu9s { unsigned int v1; unsigned long long v2:16; unsigned short v3:9; };
struct Ui_BFu16ll_C { unsigned int v1; unsigned long long v2:16; char v3; };
struct Ui_BFu16ll_D { unsigned int v1; unsigned long long v2:16; double v3; };
struct Ui_BFu16ll_F { unsigned int v1; unsigned long long v2:16; float v3; };
struct Ui_BFu16ll_I { unsigned int v1; unsigned long long v2:16; int v3; };
struct Ui_BFu16ll_Ip { unsigned int v1; unsigned long long v2:16; int * v3; };
struct Ui_BFu16ll_L { unsigned int v1; unsigned long long v2:16; long long v3; };
struct Ui_BFu16ll_S { unsigned int v1; unsigned long long v2:16; short v3; };
struct Ui_BFu16ll_Uc { unsigned int v1; unsigned long long v2:16; unsigned char v3; };
struct Ui_BFu16ll_Ui { unsigned int v1; unsigned long long v2:16; unsigned int v3; };
struct Ui_BFu16ll_Ul { unsigned int v1; unsigned long long v2:16; unsigned long long v3; };
struct Ui_BFu16ll_Us { unsigned int v1; unsigned long long v2:16; unsigned short v3; };
struct Ui_BFu16ll_Vp { unsigned int v1; unsigned long long v2:16; void * v3; };
struct Ui_BFu16s { unsigned int v1; unsigned short v2:16; };
struct Ui_BFu16s_BFu15i { unsigned int v1; unsigned short v2:16; unsigned int v3:15; };
struct Ui_BFu16s_BFu15ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:15; };
struct Ui_BFu16s_BFu15s { unsigned int v1; unsigned short v2:16; unsigned short v3:15; };
struct Ui_BFu16s_BFu16i { unsigned int v1; unsigned short v2:16; unsigned int v3:16; };
struct Ui_BFu16s_BFu16ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:16; };
struct Ui_BFu16s_BFu16s { unsigned int v1; unsigned short v2:16; unsigned short v3:16; };
struct Ui_BFu16s_BFu17i { unsigned int v1; unsigned short v2:16; unsigned int v3:17; };
struct Ui_BFu16s_BFu17ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:17; };
struct Ui_BFu16s_BFu1c { unsigned int v1; unsigned short v2:16; unsigned char v3:1; };
struct Ui_BFu16s_BFu1i { unsigned int v1; unsigned short v2:16; unsigned int v3:1; };
struct Ui_BFu16s_BFu1ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:1; };
struct Ui_BFu16s_BFu1s { unsigned int v1; unsigned short v2:16; unsigned short v3:1; };
struct Ui_BFu16s_BFu31i { unsigned int v1; unsigned short v2:16; unsigned int v3:31; };
struct Ui_BFu16s_BFu31ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:31; };
struct Ui_BFu16s_BFu32i { unsigned int v1; unsigned short v2:16; unsigned int v3:32; };
struct Ui_BFu16s_BFu32ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:32; };
struct Ui_BFu16s_BFu33 { unsigned int v1; unsigned short v2:16; unsigned long long v3:33; };
struct Ui_BFu16s_BFu7c { unsigned int v1; unsigned short v2:16; unsigned char v3:7; };
struct Ui_BFu16s_BFu7i { unsigned int v1; unsigned short v2:16; unsigned int v3:7; };
struct Ui_BFu16s_BFu7ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:7; };
struct Ui_BFu16s_BFu7s { unsigned int v1; unsigned short v2:16; unsigned short v3:7; };
struct Ui_BFu16s_BFu8c { unsigned int v1; unsigned short v2:16; unsigned char v3:8; };
struct Ui_BFu16s_BFu8i { unsigned int v1; unsigned short v2:16; unsigned int v3:8; };
struct Ui_BFu16s_BFu8ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:8; };
struct Ui_BFu16s_BFu8s { unsigned int v1; unsigned short v2:16; unsigned short v3:8; };
struct Ui_BFu16s_BFu9i { unsigned int v1; unsigned short v2:16; unsigned int v3:9; };
struct Ui_BFu16s_BFu9ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:9; };
struct Ui_BFu16s_BFu9s { unsigned int v1; unsigned short v2:16; unsigned short v3:9; };
struct Ui_BFu16s_C { unsigned int v1; unsigned short v2:16; char v3; };
struct Ui_BFu16s_D { unsigned int v1; unsigned short v2:16; double v3; };
struct Ui_BFu16s_F { unsigned int v1; unsigned short v2:16; float v3; };
struct Ui_BFu16s_I { unsigned int v1; unsigned short v2:16; int v3; };
struct Ui_BFu16s_Ip { unsigned int v1; unsigned short v2:16; int * v3; };
struct Ui_BFu16s_L { unsigned int v1; unsigned short v2:16; long long v3; };
struct Ui_BFu16s_S { unsigned int v1; unsigned short v2:16; short v3; };
struct Ui_BFu16s_Uc { unsigned int v1; unsigned short v2:16; unsigned char v3; };
struct Ui_BFu16s_Ui { unsigned int v1; unsigned short v2:16; unsigned int v3; };
struct Ui_BFu16s_Ul { unsigned int v1; unsigned short v2:16; unsigned long long v3; };
struct Ui_BFu16s_Us { unsigned int v1; unsigned short v2:16; unsigned short v3; };
struct Ui_BFu16s_Vp { unsigned int v1; unsigned short v2:16; void * v3; };
struct Ui_BFu17i { unsigned int v1; unsigned int v2:17; };
struct Ui_BFu17i_BFu15i { unsigned int v1; unsigned int v2:17; unsigned int v3:15; };
struct Ui_BFu17i_BFu15ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:15; };
struct Ui_BFu17i_BFu15s { unsigned int v1; unsigned int v2:17; unsigned short v3:15; };
struct Ui_BFu17i_BFu16i { unsigned int v1; unsigned int v2:17; unsigned int v3:16; };
struct Ui_BFu17i_BFu16ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:16; };
struct Ui_BFu17i_BFu16s { unsigned int v1; unsigned int v2:17; unsigned short v3:16; };
struct Ui_BFu17i_BFu17i { unsigned int v1; unsigned int v2:17; unsigned int v3:17; };
struct Ui_BFu17i_BFu17ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:17; };
struct Ui_BFu17i_BFu1c { unsigned int v1; unsigned int v2:17; unsigned char v3:1; };
struct Ui_BFu17i_BFu1i { unsigned int v1; unsigned int v2:17; unsigned int v3:1; };
struct Ui_BFu17i_BFu1ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:1; };
struct Ui_BFu17i_BFu1s { unsigned int v1; unsigned int v2:17; unsigned short v3:1; };
struct Ui_BFu17i_BFu31i { unsigned int v1; unsigned int v2:17; unsigned int v3:31; };
struct Ui_BFu17i_BFu31ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:31; };
struct Ui_BFu17i_BFu32i { unsigned int v1; unsigned int v2:17; unsigned int v3:32; };
struct Ui_BFu17i_BFu32ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:32; };
struct Ui_BFu17i_BFu33 { unsigned int v1; unsigned int v2:17; unsigned long long v3:33; };
struct Ui_BFu17i_BFu7c { unsigned int v1; unsigned int v2:17; unsigned char v3:7; };
struct Ui_BFu17i_BFu7i { unsigned int v1; unsigned int v2:17; unsigned int v3:7; };
struct Ui_BFu17i_BFu7ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:7; };
struct Ui_BFu17i_BFu7s { unsigned int v1; unsigned int v2:17; unsigned short v3:7; };
struct Ui_BFu17i_BFu8c { unsigned int v1; unsigned int v2:17; unsigned char v3:8; };
struct Ui_BFu17i_BFu8i { unsigned int v1; unsigned int v2:17; unsigned int v3:8; };
struct Ui_BFu17i_BFu8ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:8; };
struct Ui_BFu17i_BFu8s { unsigned int v1; unsigned int v2:17; unsigned short v3:8; };
struct Ui_BFu17i_BFu9i { unsigned int v1; unsigned int v2:17; unsigned int v3:9; };
struct Ui_BFu17i_BFu9ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:9; };
struct Ui_BFu17i_BFu9s { unsigned int v1; unsigned int v2:17; unsigned short v3:9; };
struct Ui_BFu17i_C { unsigned int v1; unsigned int v2:17; char v3; };
struct Ui_BFu17i_D { unsigned int v1; unsigned int v2:17; double v3; };
struct Ui_BFu17i_F { unsigned int v1; unsigned int v2:17; float v3; };
struct Ui_BFu17i_I { unsigned int v1; unsigned int v2:17; int v3; };
struct Ui_BFu17i_Ip { unsigned int v1; unsigned int v2:17; int * v3; };
struct Ui_BFu17i_L { unsigned int v1; unsigned int v2:17; long long v3; };
struct Ui_BFu17i_S { unsigned int v1; unsigned int v2:17; short v3; };
struct Ui_BFu17i_Uc { unsigned int v1; unsigned int v2:17; unsigned char v3; };
struct Ui_BFu17i_Ui { unsigned int v1; unsigned int v2:17; unsigned int v3; };
struct Ui_BFu17i_Ul { unsigned int v1; unsigned int v2:17; unsigned long long v3; };
struct Ui_BFu17i_Us { unsigned int v1; unsigned int v2:17; unsigned short v3; };
struct Ui_BFu17i_Vp { unsigned int v1; unsigned int v2:17; void * v3; };
struct Ui_BFu17ll { unsigned int v1; unsigned long long v2:17; };
struct Ui_BFu17ll_BFu15i { unsigned int v1; unsigned long long v2:17; unsigned int v3:15; };
struct Ui_BFu17ll_BFu15ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:15; };
struct Ui_BFu17ll_BFu15s { unsigned int v1; unsigned long long v2:17; unsigned short v3:15; };
struct Ui_BFu17ll_BFu16i { unsigned int v1; unsigned long long v2:17; unsigned int v3:16; };
struct Ui_BFu17ll_BFu16ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:16; };
struct Ui_BFu17ll_BFu16s { unsigned int v1; unsigned long long v2:17; unsigned short v3:16; };
struct Ui_BFu17ll_BFu17i { unsigned int v1; unsigned long long v2:17; unsigned int v3:17; };
struct Ui_BFu17ll_BFu17ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:17; };
struct Ui_BFu17ll_BFu1c { unsigned int v1; unsigned long long v2:17; unsigned char v3:1; };
struct Ui_BFu17ll_BFu1i { unsigned int v1; unsigned long long v2:17; unsigned int v3:1; };
struct Ui_BFu17ll_BFu1ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:1; };
struct Ui_BFu17ll_BFu1s { unsigned int v1; unsigned long long v2:17; unsigned short v3:1; };
struct Ui_BFu17ll_BFu31i { unsigned int v1; unsigned long long v2:17; unsigned int v3:31; };
struct Ui_BFu17ll_BFu31ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:31; };
struct Ui_BFu17ll_BFu32i { unsigned int v1; unsigned long long v2:17; unsigned int v3:32; };
struct Ui_BFu17ll_BFu32ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:32; };
struct Ui_BFu17ll_BFu33 { unsigned int v1; unsigned long long v2:17; unsigned long long v3:33; };
struct Ui_BFu17ll_BFu7c { unsigned int v1; unsigned long long v2:17; unsigned char v3:7; };
struct Ui_BFu17ll_BFu7i { unsigned int v1; unsigned long long v2:17; unsigned int v3:7; };
struct Ui_BFu17ll_BFu7ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:7; };
struct Ui_BFu17ll_BFu7s { unsigned int v1; unsigned long long v2:17; unsigned short v3:7; };
struct Ui_BFu17ll_BFu8c { unsigned int v1; unsigned long long v2:17; unsigned char v3:8; };
struct Ui_BFu17ll_BFu8i { unsigned int v1; unsigned long long v2:17; unsigned int v3:8; };
struct Ui_BFu17ll_BFu8ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:8; };
struct Ui_BFu17ll_BFu8s { unsigned int v1; unsigned long long v2:17; unsigned short v3:8; };
struct Ui_BFu17ll_BFu9i { unsigned int v1; unsigned long long v2:17; unsigned int v3:9; };
struct Ui_BFu17ll_BFu9ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:9; };
struct Ui_BFu17ll_BFu9s { unsigned int v1; unsigned long long v2:17; unsigned short v3:9; };
struct Ui_BFu17ll_C { unsigned int v1; unsigned long long v2:17; char v3; };
struct Ui_BFu17ll_D { unsigned int v1; unsigned long long v2:17; double v3; };
struct Ui_BFu17ll_F { unsigned int v1; unsigned long long v2:17; float v3; };
struct Ui_BFu17ll_I { unsigned int v1; unsigned long long v2:17; int v3; };
struct Ui_BFu17ll_Ip { unsigned int v1; unsigned long long v2:17; int * v3; };
struct Ui_BFu17ll_L { unsigned int v1; unsigned long long v2:17; long long v3; };
struct Ui_BFu17ll_S { unsigned int v1; unsigned long long v2:17; short v3; };
struct Ui_BFu17ll_Uc { unsigned int v1; unsigned long long v2:17; unsigned char v3; };
struct Ui_BFu17ll_Ui { unsigned int v1; unsigned long long v2:17; unsigned int v3; };
struct Ui_BFu17ll_Ul { unsigned int v1; unsigned long long v2:17; unsigned long long v3; };
struct Ui_BFu17ll_Us { unsigned int v1; unsigned long long v2:17; unsigned short v3; };
struct Ui_BFu17ll_Vp { unsigned int v1; unsigned long long v2:17; void * v3; };
struct Ui_BFu1c { unsigned int v1; unsigned char v2:1; };
struct Ui_BFu1c_BFu15i { unsigned int v1; unsigned char v2:1; unsigned int v3:15; };
struct Ui_BFu1c_BFu15ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:15; };
struct Ui_BFu1c_BFu15s { unsigned int v1; unsigned char v2:1; unsigned short v3:15; };
struct Ui_BFu1c_BFu16i { unsigned int v1; unsigned char v2:1; unsigned int v3:16; };
struct Ui_BFu1c_BFu16ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:16; };
struct Ui_BFu1c_BFu16s { unsigned int v1; unsigned char v2:1; unsigned short v3:16; };
struct Ui_BFu1c_BFu17i { unsigned int v1; unsigned char v2:1; unsigned int v3:17; };
struct Ui_BFu1c_BFu17ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:17; };
struct Ui_BFu1c_BFu1c { unsigned int v1; unsigned char v2:1; unsigned char v3:1; };
struct Ui_BFu1c_BFu1i { unsigned int v1; unsigned char v2:1; unsigned int v3:1; };
struct Ui_BFu1c_BFu1ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:1; };
struct Ui_BFu1c_BFu1s { unsigned int v1; unsigned char v2:1; unsigned short v3:1; };
struct Ui_BFu1c_BFu31i { unsigned int v1; unsigned char v2:1; unsigned int v3:31; };
struct Ui_BFu1c_BFu31ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:31; };
struct Ui_BFu1c_BFu32i { unsigned int v1; unsigned char v2:1; unsigned int v3:32; };
struct Ui_BFu1c_BFu32ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:32; };
struct Ui_BFu1c_BFu33 { unsigned int v1; unsigned char v2:1; unsigned long long v3:33; };
struct Ui_BFu1c_BFu7c { unsigned int v1; unsigned char v2:1; unsigned char v3:7; };
struct Ui_BFu1c_BFu7i { unsigned int v1; unsigned char v2:1; unsigned int v3:7; };
struct Ui_BFu1c_BFu7ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:7; };
struct Ui_BFu1c_BFu7s { unsigned int v1; unsigned char v2:1; unsigned short v3:7; };
struct Ui_BFu1c_BFu8c { unsigned int v1; unsigned char v2:1; unsigned char v3:8; };
struct Ui_BFu1c_BFu8i { unsigned int v1; unsigned char v2:1; unsigned int v3:8; };
struct Ui_BFu1c_BFu8ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:8; };
struct Ui_BFu1c_BFu8s { unsigned int v1; unsigned char v2:1; unsigned short v3:8; };
struct Ui_BFu1c_BFu9i { unsigned int v1; unsigned char v2:1; unsigned int v3:9; };
struct Ui_BFu1c_BFu9ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:9; };
struct Ui_BFu1c_BFu9s { unsigned int v1; unsigned char v2:1; unsigned short v3:9; };
struct Ui_BFu1c_C { unsigned int v1; unsigned char v2:1; char v3; };
struct Ui_BFu1c_D { unsigned int v1; unsigned char v2:1; double v3; };
struct Ui_BFu1c_F { unsigned int v1; unsigned char v2:1; float v3; };
struct Ui_BFu1c_I { unsigned int v1; unsigned char v2:1; int v3; };
struct Ui_BFu1c_Ip { unsigned int v1; unsigned char v2:1; int * v3; };
struct Ui_BFu1c_L { unsigned int v1; unsigned char v2:1; long long v3; };
struct Ui_BFu1c_S { unsigned int v1; unsigned char v2:1; short v3; };
struct Ui_BFu1c_Uc { unsigned int v1; unsigned char v2:1; unsigned char v3; };
struct Ui_BFu1c_Ui { unsigned int v1; unsigned char v2:1; unsigned int v3; };
struct Ui_BFu1c_Ul { unsigned int v1; unsigned char v2:1; unsigned long long v3; };
struct Ui_BFu1c_Us { unsigned int v1; unsigned char v2:1; unsigned short v3; };
struct Ui_BFu1c_Vp { unsigned int v1; unsigned char v2:1; void * v3; };
struct Ui_BFu1i { unsigned int v1; unsigned int v2:1; };
struct Ui_BFu1i_BFu15i { unsigned int v1; unsigned int v2:1; unsigned int v3:15; };
struct Ui_BFu1i_BFu15ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:15; };
struct Ui_BFu1i_BFu15s { unsigned int v1; unsigned int v2:1; unsigned short v3:15; };
struct Ui_BFu1i_BFu16i { unsigned int v1; unsigned int v2:1; unsigned int v3:16; };
struct Ui_BFu1i_BFu16ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:16; };
struct Ui_BFu1i_BFu16s { unsigned int v1; unsigned int v2:1; unsigned short v3:16; };
struct Ui_BFu1i_BFu17i { unsigned int v1; unsigned int v2:1; unsigned int v3:17; };
struct Ui_BFu1i_BFu17ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:17; };
struct Ui_BFu1i_BFu1c { unsigned int v1; unsigned int v2:1; unsigned char v3:1; };
struct Ui_BFu1i_BFu1i { unsigned int v1; unsigned int v2:1; unsigned int v3:1; };
struct Ui_BFu1i_BFu1ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:1; };
struct Ui_BFu1i_BFu1s { unsigned int v1; unsigned int v2:1; unsigned short v3:1; };
struct Ui_BFu1i_BFu31i { unsigned int v1; unsigned int v2:1; unsigned int v3:31; };
struct Ui_BFu1i_BFu31ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:31; };
struct Ui_BFu1i_BFu32i { unsigned int v1; unsigned int v2:1; unsigned int v3:32; };
struct Ui_BFu1i_BFu32ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:32; };
struct Ui_BFu1i_BFu33 { unsigned int v1; unsigned int v2:1; unsigned long long v3:33; };
struct Ui_BFu1i_BFu7c { unsigned int v1; unsigned int v2:1; unsigned char v3:7; };
struct Ui_BFu1i_BFu7i { unsigned int v1; unsigned int v2:1; unsigned int v3:7; };
struct Ui_BFu1i_BFu7ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:7; };
struct Ui_BFu1i_BFu7s { unsigned int v1; unsigned int v2:1; unsigned short v3:7; };
struct Ui_BFu1i_BFu8c { unsigned int v1; unsigned int v2:1; unsigned char v3:8; };
struct Ui_BFu1i_BFu8i { unsigned int v1; unsigned int v2:1; unsigned int v3:8; };
struct Ui_BFu1i_BFu8ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:8; };
struct Ui_BFu1i_BFu8s { unsigned int v1; unsigned int v2:1; unsigned short v3:8; };
struct Ui_BFu1i_BFu9i { unsigned int v1; unsigned int v2:1; unsigned int v3:9; };
struct Ui_BFu1i_BFu9ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:9; };
struct Ui_BFu1i_BFu9s { unsigned int v1; unsigned int v2:1; unsigned short v3:9; };
struct Ui_BFu1i_C { unsigned int v1; unsigned int v2:1; char v3; };
struct Ui_BFu1i_D { unsigned int v1; unsigned int v2:1; double v3; };
struct Ui_BFu1i_F { unsigned int v1; unsigned int v2:1; float v3; };
struct Ui_BFu1i_I { unsigned int v1; unsigned int v2:1; int v3; };
struct Ui_BFu1i_Ip { unsigned int v1; unsigned int v2:1; int * v3; };
struct Ui_BFu1i_L { unsigned int v1; unsigned int v2:1; long long v3; };
struct Ui_BFu1i_S { unsigned int v1; unsigned int v2:1; short v3; };
struct Ui_BFu1i_Uc { unsigned int v1; unsigned int v2:1; unsigned char v3; };
struct Ui_BFu1i_Ui { unsigned int v1; unsigned int v2:1; unsigned int v3; };
struct Ui_BFu1i_Ul { unsigned int v1; unsigned int v2:1; unsigned long long v3; };
struct Ui_BFu1i_Us { unsigned int v1; unsigned int v2:1; unsigned short v3; };
struct Ui_BFu1i_Vp { unsigned int v1; unsigned int v2:1; void * v3; };
struct Ui_BFu1ll { unsigned int v1; unsigned long long v2:1; };
struct Ui_BFu1ll_BFu15i { unsigned int v1; unsigned long long v2:1; unsigned int v3:15; };
struct Ui_BFu1ll_BFu15ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:15; };
struct Ui_BFu1ll_BFu15s { unsigned int v1; unsigned long long v2:1; unsigned short v3:15; };
struct Ui_BFu1ll_BFu16i { unsigned int v1; unsigned long long v2:1; unsigned int v3:16; };
struct Ui_BFu1ll_BFu16ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:16; };
struct Ui_BFu1ll_BFu16s { unsigned int v1; unsigned long long v2:1; unsigned short v3:16; };
struct Ui_BFu1ll_BFu17i { unsigned int v1; unsigned long long v2:1; unsigned int v3:17; };
struct Ui_BFu1ll_BFu17ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:17; };
struct Ui_BFu1ll_BFu1c { unsigned int v1; unsigned long long v2:1; unsigned char v3:1; };
struct Ui_BFu1ll_BFu1i { unsigned int v1; unsigned long long v2:1; unsigned int v3:1; };
struct Ui_BFu1ll_BFu1ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:1; };
struct Ui_BFu1ll_BFu1s { unsigned int v1; unsigned long long v2:1; unsigned short v3:1; };
struct Ui_BFu1ll_BFu31i { unsigned int v1; unsigned long long v2:1; unsigned int v3:31; };
struct Ui_BFu1ll_BFu31ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:31; };
struct Ui_BFu1ll_BFu32i { unsigned int v1; unsigned long long v2:1; unsigned int v3:32; };
struct Ui_BFu1ll_BFu32ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:32; };
struct Ui_BFu1ll_BFu33 { unsigned int v1; unsigned long long v2:1; unsigned long long v3:33; };
struct Ui_BFu1ll_BFu7c { unsigned int v1; unsigned long long v2:1; unsigned char v3:7; };
struct Ui_BFu1ll_BFu7i { unsigned int v1; unsigned long long v2:1; unsigned int v3:7; };
struct Ui_BFu1ll_BFu7ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:7; };
struct Ui_BFu1ll_BFu7s { unsigned int v1; unsigned long long v2:1; unsigned short v3:7; };
struct Ui_BFu1ll_BFu8c { unsigned int v1; unsigned long long v2:1; unsigned char v3:8; };
struct Ui_BFu1ll_BFu8i { unsigned int v1; unsigned long long v2:1; unsigned int v3:8; };
struct Ui_BFu1ll_BFu8ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:8; };
struct Ui_BFu1ll_BFu8s { unsigned int v1; unsigned long long v2:1; unsigned short v3:8; };
struct Ui_BFu1ll_BFu9i { unsigned int v1; unsigned long long v2:1; unsigned int v3:9; };
struct Ui_BFu1ll_BFu9ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:9; };
struct Ui_BFu1ll_BFu9s { unsigned int v1; unsigned long long v2:1; unsigned short v3:9; };
struct Ui_BFu1ll_C { unsigned int v1; unsigned long long v2:1; char v3; };
struct Ui_BFu1ll_D { unsigned int v1; unsigned long long v2:1; double v3; };
struct Ui_BFu1ll_F { unsigned int v1; unsigned long long v2:1; float v3; };
struct Ui_BFu1ll_I { unsigned int v1; unsigned long long v2:1; int v3; };
struct Ui_BFu1ll_Ip { unsigned int v1; unsigned long long v2:1; int * v3; };
struct Ui_BFu1ll_L { unsigned int v1; unsigned long long v2:1; long long v3; };
struct Ui_BFu1ll_S { unsigned int v1; unsigned long long v2:1; short v3; };
struct Ui_BFu1ll_Uc { unsigned int v1; unsigned long long v2:1; unsigned char v3; };
struct Ui_BFu1ll_Ui { unsigned int v1; unsigned long long v2:1; unsigned int v3; };
struct Ui_BFu1ll_Ul { unsigned int v1; unsigned long long v2:1; unsigned long long v3; };
struct Ui_BFu1ll_Us { unsigned int v1; unsigned long long v2:1; unsigned short v3; };
struct Ui_BFu1ll_Vp { unsigned int v1; unsigned long long v2:1; void * v3; };
struct Ui_BFu1s { unsigned int v1; unsigned short v2:1; };
struct Ui_BFu1s_BFu15i { unsigned int v1; unsigned short v2:1; unsigned int v3:15; };
struct Ui_BFu1s_BFu15ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:15; };
struct Ui_BFu1s_BFu15s { unsigned int v1; unsigned short v2:1; unsigned short v3:15; };
struct Ui_BFu1s_BFu16i { unsigned int v1; unsigned short v2:1; unsigned int v3:16; };
struct Ui_BFu1s_BFu16ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:16; };
struct Ui_BFu1s_BFu16s { unsigned int v1; unsigned short v2:1; unsigned short v3:16; };
struct Ui_BFu1s_BFu17i { unsigned int v1; unsigned short v2:1; unsigned int v3:17; };
struct Ui_BFu1s_BFu17ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:17; };
struct Ui_BFu1s_BFu1c { unsigned int v1; unsigned short v2:1; unsigned char v3:1; };
struct Ui_BFu1s_BFu1i { unsigned int v1; unsigned short v2:1; unsigned int v3:1; };
struct Ui_BFu1s_BFu1ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:1; };
struct Ui_BFu1s_BFu1s { unsigned int v1; unsigned short v2:1; unsigned short v3:1; };
struct Ui_BFu1s_BFu31i { unsigned int v1; unsigned short v2:1; unsigned int v3:31; };
struct Ui_BFu1s_BFu31ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:31; };
struct Ui_BFu1s_BFu32i { unsigned int v1; unsigned short v2:1; unsigned int v3:32; };
struct Ui_BFu1s_BFu32ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:32; };
struct Ui_BFu1s_BFu33 { unsigned int v1; unsigned short v2:1; unsigned long long v3:33; };
struct Ui_BFu1s_BFu7c { unsigned int v1; unsigned short v2:1; unsigned char v3:7; };
struct Ui_BFu1s_BFu7i { unsigned int v1; unsigned short v2:1; unsigned int v3:7; };
struct Ui_BFu1s_BFu7ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:7; };
struct Ui_BFu1s_BFu7s { unsigned int v1; unsigned short v2:1; unsigned short v3:7; };
struct Ui_BFu1s_BFu8c { unsigned int v1; unsigned short v2:1; unsigned char v3:8; };
struct Ui_BFu1s_BFu8i { unsigned int v1; unsigned short v2:1; unsigned int v3:8; };
struct Ui_BFu1s_BFu8ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:8; };
struct Ui_BFu1s_BFu8s { unsigned int v1; unsigned short v2:1; unsigned short v3:8; };
struct Ui_BFu1s_BFu9i { unsigned int v1; unsigned short v2:1; unsigned int v3:9; };
struct Ui_BFu1s_BFu9ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:9; };
struct Ui_BFu1s_BFu9s { unsigned int v1; unsigned short v2:1; unsigned short v3:9; };
struct Ui_BFu1s_C { unsigned int v1; unsigned short v2:1; char v3; };
struct Ui_BFu1s_D { unsigned int v1; unsigned short v2:1; double v3; };
struct Ui_BFu1s_F { unsigned int v1; unsigned short v2:1; float v3; };
struct Ui_BFu1s_I { unsigned int v1; unsigned short v2:1; int v3; };
struct Ui_BFu1s_Ip { unsigned int v1; unsigned short v2:1; int * v3; };
struct Ui_BFu1s_L { unsigned int v1; unsigned short v2:1; long long v3; };
struct Ui_BFu1s_S { unsigned int v1; unsigned short v2:1; short v3; };
struct Ui_BFu1s_Uc { unsigned int v1; unsigned short v2:1; unsigned char v3; };
struct Ui_BFu1s_Ui { unsigned int v1; unsigned short v2:1; unsigned int v3; };
struct Ui_BFu1s_Ul { unsigned int v1; unsigned short v2:1; unsigned long long v3; };
struct Ui_BFu1s_Us { unsigned int v1; unsigned short v2:1; unsigned short v3; };
struct Ui_BFu1s_Vp { unsigned int v1; unsigned short v2:1; void * v3; };
struct Ui_BFu31i { unsigned int v1; unsigned int v2:31; };
struct Ui_BFu31i_BFu15i { unsigned int v1; unsigned int v2:31; unsigned int v3:15; };
struct Ui_BFu31i_BFu15ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:15; };
struct Ui_BFu31i_BFu15s { unsigned int v1; unsigned int v2:31; unsigned short v3:15; };
struct Ui_BFu31i_BFu16i { unsigned int v1; unsigned int v2:31; unsigned int v3:16; };
struct Ui_BFu31i_BFu16ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:16; };
struct Ui_BFu31i_BFu16s { unsigned int v1; unsigned int v2:31; unsigned short v3:16; };
struct Ui_BFu31i_BFu17i { unsigned int v1; unsigned int v2:31; unsigned int v3:17; };
struct Ui_BFu31i_BFu17ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:17; };
struct Ui_BFu31i_BFu1c { unsigned int v1; unsigned int v2:31; unsigned char v3:1; };
struct Ui_BFu31i_BFu1i { unsigned int v1; unsigned int v2:31; unsigned int v3:1; };
struct Ui_BFu31i_BFu1ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:1; };
struct Ui_BFu31i_BFu1s { unsigned int v1; unsigned int v2:31; unsigned short v3:1; };
struct Ui_BFu31i_BFu31i { unsigned int v1; unsigned int v2:31; unsigned int v3:31; };
struct Ui_BFu31i_BFu31ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:31; };
struct Ui_BFu31i_BFu32i { unsigned int v1; unsigned int v2:31; unsigned int v3:32; };
struct Ui_BFu31i_BFu32ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:32; };
struct Ui_BFu31i_BFu33 { unsigned int v1; unsigned int v2:31; unsigned long long v3:33; };
struct Ui_BFu31i_BFu7c { unsigned int v1; unsigned int v2:31; unsigned char v3:7; };
struct Ui_BFu31i_BFu7i { unsigned int v1; unsigned int v2:31; unsigned int v3:7; };
struct Ui_BFu31i_BFu7ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:7; };
struct Ui_BFu31i_BFu7s { unsigned int v1; unsigned int v2:31; unsigned short v3:7; };
struct Ui_BFu31i_BFu8c { unsigned int v1; unsigned int v2:31; unsigned char v3:8; };
struct Ui_BFu31i_BFu8i { unsigned int v1; unsigned int v2:31; unsigned int v3:8; };
struct Ui_BFu31i_BFu8ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:8; };
struct Ui_BFu31i_BFu8s { unsigned int v1; unsigned int v2:31; unsigned short v3:8; };
struct Ui_BFu31i_BFu9i { unsigned int v1; unsigned int v2:31; unsigned int v3:9; };
struct Ui_BFu31i_BFu9ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:9; };
struct Ui_BFu31i_BFu9s { unsigned int v1; unsigned int v2:31; unsigned short v3:9; };
struct Ui_BFu31i_C { unsigned int v1; unsigned int v2:31; char v3; };
struct Ui_BFu31i_D { unsigned int v1; unsigned int v2:31; double v3; };
struct Ui_BFu31i_F { unsigned int v1; unsigned int v2:31; float v3; };
struct Ui_BFu31i_I { unsigned int v1; unsigned int v2:31; int v3; };
struct Ui_BFu31i_Ip { unsigned int v1; unsigned int v2:31; int * v3; };
struct Ui_BFu31i_L { unsigned int v1; unsigned int v2:31; long long v3; };
struct Ui_BFu31i_S { unsigned int v1; unsigned int v2:31; short v3; };
struct Ui_BFu31i_Uc { unsigned int v1; unsigned int v2:31; unsigned char v3; };
struct Ui_BFu31i_Ui { unsigned int v1; unsigned int v2:31; unsigned int v3; };
struct Ui_BFu31i_Ul { unsigned int v1; unsigned int v2:31; unsigned long long v3; };
struct Ui_BFu31i_Us { unsigned int v1; unsigned int v2:31; unsigned short v3; };
struct Ui_BFu31i_Vp { unsigned int v1; unsigned int v2:31; void * v3; };
struct Ui_BFu31ll { unsigned int v1; unsigned long long v2:31; };
struct Ui_BFu31ll_BFu15i { unsigned int v1; unsigned long long v2:31; unsigned int v3:15; };
struct Ui_BFu31ll_BFu15ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:15; };
struct Ui_BFu31ll_BFu15s { unsigned int v1; unsigned long long v2:31; unsigned short v3:15; };
struct Ui_BFu31ll_BFu16i { unsigned int v1; unsigned long long v2:31; unsigned int v3:16; };
struct Ui_BFu31ll_BFu16ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:16; };
struct Ui_BFu31ll_BFu16s { unsigned int v1; unsigned long long v2:31; unsigned short v3:16; };
struct Ui_BFu31ll_BFu17i { unsigned int v1; unsigned long long v2:31; unsigned int v3:17; };
struct Ui_BFu31ll_BFu17ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:17; };
struct Ui_BFu31ll_BFu1c { unsigned int v1; unsigned long long v2:31; unsigned char v3:1; };
struct Ui_BFu31ll_BFu1i { unsigned int v1; unsigned long long v2:31; unsigned int v3:1; };
struct Ui_BFu31ll_BFu1ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:1; };
struct Ui_BFu31ll_BFu1s { unsigned int v1; unsigned long long v2:31; unsigned short v3:1; };
struct Ui_BFu31ll_BFu31i { unsigned int v1; unsigned long long v2:31; unsigned int v3:31; };
struct Ui_BFu31ll_BFu31ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:31; };
struct Ui_BFu31ll_BFu32i { unsigned int v1; unsigned long long v2:31; unsigned int v3:32; };
struct Ui_BFu31ll_BFu32ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:32; };
struct Ui_BFu31ll_BFu33 { unsigned int v1; unsigned long long v2:31; unsigned long long v3:33; };
struct Ui_BFu31ll_BFu7c { unsigned int v1; unsigned long long v2:31; unsigned char v3:7; };
struct Ui_BFu31ll_BFu7i { unsigned int v1; unsigned long long v2:31; unsigned int v3:7; };
struct Ui_BFu31ll_BFu7ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:7; };
struct Ui_BFu31ll_BFu7s { unsigned int v1; unsigned long long v2:31; unsigned short v3:7; };
struct Ui_BFu31ll_BFu8c { unsigned int v1; unsigned long long v2:31; unsigned char v3:8; };
struct Ui_BFu31ll_BFu8i { unsigned int v1; unsigned long long v2:31; unsigned int v3:8; };
struct Ui_BFu31ll_BFu8ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:8; };
struct Ui_BFu31ll_BFu8s { unsigned int v1; unsigned long long v2:31; unsigned short v3:8; };
struct Ui_BFu31ll_BFu9i { unsigned int v1; unsigned long long v2:31; unsigned int v3:9; };
struct Ui_BFu31ll_BFu9ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:9; };
struct Ui_BFu31ll_BFu9s { unsigned int v1; unsigned long long v2:31; unsigned short v3:9; };
struct Ui_BFu31ll_C { unsigned int v1; unsigned long long v2:31; char v3; };
struct Ui_BFu31ll_D { unsigned int v1; unsigned long long v2:31; double v3; };
struct Ui_BFu31ll_F { unsigned int v1; unsigned long long v2:31; float v3; };
struct Ui_BFu31ll_I { unsigned int v1; unsigned long long v2:31; int v3; };
struct Ui_BFu31ll_Ip { unsigned int v1; unsigned long long v2:31; int * v3; };
struct Ui_BFu31ll_L { unsigned int v1; unsigned long long v2:31; long long v3; };
struct Ui_BFu31ll_S { unsigned int v1; unsigned long long v2:31; short v3; };
struct Ui_BFu31ll_Uc { unsigned int v1; unsigned long long v2:31; unsigned char v3; };
struct Ui_BFu31ll_Ui { unsigned int v1; unsigned long long v2:31; unsigned int v3; };
struct Ui_BFu31ll_Ul { unsigned int v1; unsigned long long v2:31; unsigned long long v3; };
struct Ui_BFu31ll_Us { unsigned int v1; unsigned long long v2:31; unsigned short v3; };
struct Ui_BFu31ll_Vp { unsigned int v1; unsigned long long v2:31; void * v3; };
struct Ui_BFu32i { unsigned int v1; unsigned int v2:32; };
struct Ui_BFu32i_BFu15i { unsigned int v1; unsigned int v2:32; unsigned int v3:15; };
struct Ui_BFu32i_BFu15ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:15; };
struct Ui_BFu32i_BFu15s { unsigned int v1; unsigned int v2:32; unsigned short v3:15; };
struct Ui_BFu32i_BFu16i { unsigned int v1; unsigned int v2:32; unsigned int v3:16; };
struct Ui_BFu32i_BFu16ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:16; };
struct Ui_BFu32i_BFu16s { unsigned int v1; unsigned int v2:32; unsigned short v3:16; };
struct Ui_BFu32i_BFu17i { unsigned int v1; unsigned int v2:32; unsigned int v3:17; };
struct Ui_BFu32i_BFu17ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:17; };
struct Ui_BFu32i_BFu1c { unsigned int v1; unsigned int v2:32; unsigned char v3:1; };
struct Ui_BFu32i_BFu1i { unsigned int v1; unsigned int v2:32; unsigned int v3:1; };
struct Ui_BFu32i_BFu1ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:1; };
struct Ui_BFu32i_BFu1s { unsigned int v1; unsigned int v2:32; unsigned short v3:1; };
struct Ui_BFu32i_BFu31i { unsigned int v1; unsigned int v2:32; unsigned int v3:31; };
struct Ui_BFu32i_BFu31ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:31; };
struct Ui_BFu32i_BFu32i { unsigned int v1; unsigned int v2:32; unsigned int v3:32; };
struct Ui_BFu32i_BFu32ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:32; };
struct Ui_BFu32i_BFu33 { unsigned int v1; unsigned int v2:32; unsigned long long v3:33; };
struct Ui_BFu32i_BFu7c { unsigned int v1; unsigned int v2:32; unsigned char v3:7; };
struct Ui_BFu32i_BFu7i { unsigned int v1; unsigned int v2:32; unsigned int v3:7; };
struct Ui_BFu32i_BFu7ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:7; };
struct Ui_BFu32i_BFu7s { unsigned int v1; unsigned int v2:32; unsigned short v3:7; };
struct Ui_BFu32i_BFu8c { unsigned int v1; unsigned int v2:32; unsigned char v3:8; };
struct Ui_BFu32i_BFu8i { unsigned int v1; unsigned int v2:32; unsigned int v3:8; };
struct Ui_BFu32i_BFu8ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:8; };
struct Ui_BFu32i_BFu8s { unsigned int v1; unsigned int v2:32; unsigned short v3:8; };
struct Ui_BFu32i_BFu9i { unsigned int v1; unsigned int v2:32; unsigned int v3:9; };
struct Ui_BFu32i_BFu9ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:9; };
struct Ui_BFu32i_BFu9s { unsigned int v1; unsigned int v2:32; unsigned short v3:9; };
struct Ui_BFu32i_C { unsigned int v1; unsigned int v2:32; char v3; };
struct Ui_BFu32i_D { unsigned int v1; unsigned int v2:32; double v3; };
struct Ui_BFu32i_F { unsigned int v1; unsigned int v2:32; float v3; };
struct Ui_BFu32i_I { unsigned int v1; unsigned int v2:32; int v3; };
struct Ui_BFu32i_Ip { unsigned int v1; unsigned int v2:32; int * v3; };
struct Ui_BFu32i_L { unsigned int v1; unsigned int v2:32; long long v3; };
struct Ui_BFu32i_S { unsigned int v1; unsigned int v2:32; short v3; };
struct Ui_BFu32i_Uc { unsigned int v1; unsigned int v2:32; unsigned char v3; };
struct Ui_BFu32i_Ui { unsigned int v1; unsigned int v2:32; unsigned int v3; };
struct Ui_BFu32i_Ul { unsigned int v1; unsigned int v2:32; unsigned long long v3; };
struct Ui_BFu32i_Us { unsigned int v1; unsigned int v2:32; unsigned short v3; };
struct Ui_BFu32i_Vp { unsigned int v1; unsigned int v2:32; void * v3; };
struct Ui_BFu32ll { unsigned int v1; unsigned long long v2:32; };
struct Ui_BFu32ll_BFu15i { unsigned int v1; unsigned long long v2:32; unsigned int v3:15; };
struct Ui_BFu32ll_BFu15ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:15; };
struct Ui_BFu32ll_BFu15s { unsigned int v1; unsigned long long v2:32; unsigned short v3:15; };
struct Ui_BFu32ll_BFu16i { unsigned int v1; unsigned long long v2:32; unsigned int v3:16; };
struct Ui_BFu32ll_BFu16ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:16; };
struct Ui_BFu32ll_BFu16s { unsigned int v1; unsigned long long v2:32; unsigned short v3:16; };
struct Ui_BFu32ll_BFu17i { unsigned int v1; unsigned long long v2:32; unsigned int v3:17; };
struct Ui_BFu32ll_BFu17ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:17; };
struct Ui_BFu32ll_BFu1c { unsigned int v1; unsigned long long v2:32; unsigned char v3:1; };
struct Ui_BFu32ll_BFu1i { unsigned int v1; unsigned long long v2:32; unsigned int v3:1; };
struct Ui_BFu32ll_BFu1ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:1; };
struct Ui_BFu32ll_BFu1s { unsigned int v1; unsigned long long v2:32; unsigned short v3:1; };
struct Ui_BFu32ll_BFu31i { unsigned int v1; unsigned long long v2:32; unsigned int v3:31; };
struct Ui_BFu32ll_BFu31ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:31; };
struct Ui_BFu32ll_BFu32i { unsigned int v1; unsigned long long v2:32; unsigned int v3:32; };
struct Ui_BFu32ll_BFu32ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:32; };
struct Ui_BFu32ll_BFu33 { unsigned int v1; unsigned long long v2:32; unsigned long long v3:33; };
struct Ui_BFu32ll_BFu7c { unsigned int v1; unsigned long long v2:32; unsigned char v3:7; };
struct Ui_BFu32ll_BFu7i { unsigned int v1; unsigned long long v2:32; unsigned int v3:7; };
struct Ui_BFu32ll_BFu7ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:7; };
struct Ui_BFu32ll_BFu7s { unsigned int v1; unsigned long long v2:32; unsigned short v3:7; };
struct Ui_BFu32ll_BFu8c { unsigned int v1; unsigned long long v2:32; unsigned char v3:8; };
struct Ui_BFu32ll_BFu8i { unsigned int v1; unsigned long long v2:32; unsigned int v3:8; };
struct Ui_BFu32ll_BFu8ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:8; };
struct Ui_BFu32ll_BFu8s { unsigned int v1; unsigned long long v2:32; unsigned short v3:8; };
struct Ui_BFu32ll_BFu9i { unsigned int v1; unsigned long long v2:32; unsigned int v3:9; };
struct Ui_BFu32ll_BFu9ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:9; };
struct Ui_BFu32ll_BFu9s { unsigned int v1; unsigned long long v2:32; unsigned short v3:9; };
struct Ui_BFu32ll_C { unsigned int v1; unsigned long long v2:32; char v3; };
struct Ui_BFu32ll_D { unsigned int v1; unsigned long long v2:32; double v3; };
struct Ui_BFu32ll_F { unsigned int v1; unsigned long long v2:32; float v3; };
struct Ui_BFu32ll_I { unsigned int v1; unsigned long long v2:32; int v3; };
struct Ui_BFu32ll_Ip { unsigned int v1; unsigned long long v2:32; int * v3; };
struct Ui_BFu32ll_L { unsigned int v1; unsigned long long v2:32; long long v3; };
struct Ui_BFu32ll_S { unsigned int v1; unsigned long long v2:32; short v3; };
struct Ui_BFu32ll_Uc { unsigned int v1; unsigned long long v2:32; unsigned char v3; };
struct Ui_BFu32ll_Ui { unsigned int v1; unsigned long long v2:32; unsigned int v3; };
struct Ui_BFu32ll_Ul { unsigned int v1; unsigned long long v2:32; unsigned long long v3; };
struct Ui_BFu32ll_Us { unsigned int v1; unsigned long long v2:32; unsigned short v3; };
struct Ui_BFu32ll_Vp { unsigned int v1; unsigned long long v2:32; void * v3; };
struct Ui_BFu33 { unsigned int v1; unsigned long long v2:33; };
struct Ui_BFu33_BFu15i { unsigned int v1; unsigned long long v2:33; unsigned int v3:15; };
struct Ui_BFu33_BFu15ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:15; };
struct Ui_BFu33_BFu15s { unsigned int v1; unsigned long long v2:33; unsigned short v3:15; };
struct Ui_BFu33_BFu16i { unsigned int v1; unsigned long long v2:33; unsigned int v3:16; };
struct Ui_BFu33_BFu16ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:16; };
struct Ui_BFu33_BFu16s { unsigned int v1; unsigned long long v2:33; unsigned short v3:16; };
struct Ui_BFu33_BFu17i { unsigned int v1; unsigned long long v2:33; unsigned int v3:17; };
struct Ui_BFu33_BFu17ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:17; };
struct Ui_BFu33_BFu1c { unsigned int v1; unsigned long long v2:33; unsigned char v3:1; };
struct Ui_BFu33_BFu1i { unsigned int v1; unsigned long long v2:33; unsigned int v3:1; };
struct Ui_BFu33_BFu1ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:1; };
struct Ui_BFu33_BFu1s { unsigned int v1; unsigned long long v2:33; unsigned short v3:1; };
struct Ui_BFu33_BFu31i { unsigned int v1; unsigned long long v2:33; unsigned int v3:31; };
struct Ui_BFu33_BFu31ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:31; };
struct Ui_BFu33_BFu32i { unsigned int v1; unsigned long long v2:33; unsigned int v3:32; };
struct Ui_BFu33_BFu32ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:32; };
struct Ui_BFu33_BFu33 { unsigned int v1; unsigned long long v2:33; unsigned long long v3:33; };
struct Ui_BFu33_BFu7c { unsigned int v1; unsigned long long v2:33; unsigned char v3:7; };
struct Ui_BFu33_BFu7i { unsigned int v1; unsigned long long v2:33; unsigned int v3:7; };
struct Ui_BFu33_BFu7ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:7; };
struct Ui_BFu33_BFu7s { unsigned int v1; unsigned long long v2:33; unsigned short v3:7; };
struct Ui_BFu33_BFu8c { unsigned int v1; unsigned long long v2:33; unsigned char v3:8; };
struct Ui_BFu33_BFu8i { unsigned int v1; unsigned long long v2:33; unsigned int v3:8; };
struct Ui_BFu33_BFu8ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:8; };
struct Ui_BFu33_BFu8s { unsigned int v1; unsigned long long v2:33; unsigned short v3:8; };
struct Ui_BFu33_BFu9i { unsigned int v1; unsigned long long v2:33; unsigned int v3:9; };
struct Ui_BFu33_BFu9ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:9; };
struct Ui_BFu33_BFu9s { unsigned int v1; unsigned long long v2:33; unsigned short v3:9; };
struct Ui_BFu33_C { unsigned int v1; unsigned long long v2:33; char v3; };
struct Ui_BFu33_D { unsigned int v1; unsigned long long v2:33; double v3; };
struct Ui_BFu33_F { unsigned int v1; unsigned long long v2:33; float v3; };
struct Ui_BFu33_I { unsigned int v1; unsigned long long v2:33; int v3; };
struct Ui_BFu33_Ip { unsigned int v1; unsigned long long v2:33; int * v3; };
struct Ui_BFu33_L { unsigned int v1; unsigned long long v2:33; long long v3; };
struct Ui_BFu33_S { unsigned int v1; unsigned long long v2:33; short v3; };
struct Ui_BFu33_Uc { unsigned int v1; unsigned long long v2:33; unsigned char v3; };
struct Ui_BFu33_Ui { unsigned int v1; unsigned long long v2:33; unsigned int v3; };
struct Ui_BFu33_Ul { unsigned int v1; unsigned long long v2:33; unsigned long long v3; };
struct Ui_BFu33_Us { unsigned int v1; unsigned long long v2:33; unsigned short v3; };
struct Ui_BFu33_Vp { unsigned int v1; unsigned long long v2:33; void * v3; };
struct Ui_BFu7c { unsigned int v1; unsigned char v2:7; };
struct Ui_BFu7c_BFu15i { unsigned int v1; unsigned char v2:7; unsigned int v3:15; };
struct Ui_BFu7c_BFu15ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:15; };
struct Ui_BFu7c_BFu15s { unsigned int v1; unsigned char v2:7; unsigned short v3:15; };
struct Ui_BFu7c_BFu16i { unsigned int v1; unsigned char v2:7; unsigned int v3:16; };
struct Ui_BFu7c_BFu16ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:16; };
struct Ui_BFu7c_BFu16s { unsigned int v1; unsigned char v2:7; unsigned short v3:16; };
struct Ui_BFu7c_BFu17i { unsigned int v1; unsigned char v2:7; unsigned int v3:17; };
struct Ui_BFu7c_BFu17ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:17; };
struct Ui_BFu7c_BFu1c { unsigned int v1; unsigned char v2:7; unsigned char v3:1; };
struct Ui_BFu7c_BFu1i { unsigned int v1; unsigned char v2:7; unsigned int v3:1; };
struct Ui_BFu7c_BFu1ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:1; };
struct Ui_BFu7c_BFu1s { unsigned int v1; unsigned char v2:7; unsigned short v3:1; };
struct Ui_BFu7c_BFu31i { unsigned int v1; unsigned char v2:7; unsigned int v3:31; };
struct Ui_BFu7c_BFu31ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:31; };
struct Ui_BFu7c_BFu32i { unsigned int v1; unsigned char v2:7; unsigned int v3:32; };
struct Ui_BFu7c_BFu32ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:32; };
struct Ui_BFu7c_BFu33 { unsigned int v1; unsigned char v2:7; unsigned long long v3:33; };
struct Ui_BFu7c_BFu7c { unsigned int v1; unsigned char v2:7; unsigned char v3:7; };
struct Ui_BFu7c_BFu7i { unsigned int v1; unsigned char v2:7; unsigned int v3:7; };
struct Ui_BFu7c_BFu7ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:7; };
struct Ui_BFu7c_BFu7s { unsigned int v1; unsigned char v2:7; unsigned short v3:7; };
struct Ui_BFu7c_BFu8c { unsigned int v1; unsigned char v2:7; unsigned char v3:8; };
struct Ui_BFu7c_BFu8i { unsigned int v1; unsigned char v2:7; unsigned int v3:8; };
struct Ui_BFu7c_BFu8ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:8; };
struct Ui_BFu7c_BFu8s { unsigned int v1; unsigned char v2:7; unsigned short v3:8; };
struct Ui_BFu7c_BFu9i { unsigned int v1; unsigned char v2:7; unsigned int v3:9; };
struct Ui_BFu7c_BFu9ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:9; };
struct Ui_BFu7c_BFu9s { unsigned int v1; unsigned char v2:7; unsigned short v3:9; };
struct Ui_BFu7c_C { unsigned int v1; unsigned char v2:7; char v3; };
struct Ui_BFu7c_D { unsigned int v1; unsigned char v2:7; double v3; };
struct Ui_BFu7c_F { unsigned int v1; unsigned char v2:7; float v3; };
struct Ui_BFu7c_I { unsigned int v1; unsigned char v2:7; int v3; };
struct Ui_BFu7c_Ip { unsigned int v1; unsigned char v2:7; int * v3; };
struct Ui_BFu7c_L { unsigned int v1; unsigned char v2:7; long long v3; };
struct Ui_BFu7c_S { unsigned int v1; unsigned char v2:7; short v3; };
struct Ui_BFu7c_Uc { unsigned int v1; unsigned char v2:7; unsigned char v3; };
struct Ui_BFu7c_Ui { unsigned int v1; unsigned char v2:7; unsigned int v3; };
struct Ui_BFu7c_Ul { unsigned int v1; unsigned char v2:7; unsigned long long v3; };
struct Ui_BFu7c_Us { unsigned int v1; unsigned char v2:7; unsigned short v3; };
struct Ui_BFu7c_Vp { unsigned int v1; unsigned char v2:7; void * v3; };
struct Ui_BFu7i { unsigned int v1; unsigned int v2:7; };
struct Ui_BFu7i_BFu15i { unsigned int v1; unsigned int v2:7; unsigned int v3:15; };
struct Ui_BFu7i_BFu15ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:15; };
struct Ui_BFu7i_BFu15s { unsigned int v1; unsigned int v2:7; unsigned short v3:15; };
struct Ui_BFu7i_BFu16i { unsigned int v1; unsigned int v2:7; unsigned int v3:16; };
struct Ui_BFu7i_BFu16ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:16; };
struct Ui_BFu7i_BFu16s { unsigned int v1; unsigned int v2:7; unsigned short v3:16; };
struct Ui_BFu7i_BFu17i { unsigned int v1; unsigned int v2:7; unsigned int v3:17; };
struct Ui_BFu7i_BFu17ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:17; };
struct Ui_BFu7i_BFu1c { unsigned int v1; unsigned int v2:7; unsigned char v3:1; };
struct Ui_BFu7i_BFu1i { unsigned int v1; unsigned int v2:7; unsigned int v3:1; };
struct Ui_BFu7i_BFu1ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:1; };
struct Ui_BFu7i_BFu1s { unsigned int v1; unsigned int v2:7; unsigned short v3:1; };
struct Ui_BFu7i_BFu31i { unsigned int v1; unsigned int v2:7; unsigned int v3:31; };
struct Ui_BFu7i_BFu31ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:31; };
struct Ui_BFu7i_BFu32i { unsigned int v1; unsigned int v2:7; unsigned int v3:32; };
struct Ui_BFu7i_BFu32ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:32; };
struct Ui_BFu7i_BFu33 { unsigned int v1; unsigned int v2:7; unsigned long long v3:33; };
struct Ui_BFu7i_BFu7c { unsigned int v1; unsigned int v2:7; unsigned char v3:7; };
struct Ui_BFu7i_BFu7i { unsigned int v1; unsigned int v2:7; unsigned int v3:7; };
struct Ui_BFu7i_BFu7ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:7; };
struct Ui_BFu7i_BFu7s { unsigned int v1; unsigned int v2:7; unsigned short v3:7; };
struct Ui_BFu7i_BFu8c { unsigned int v1; unsigned int v2:7; unsigned char v3:8; };
struct Ui_BFu7i_BFu8i { unsigned int v1; unsigned int v2:7; unsigned int v3:8; };
struct Ui_BFu7i_BFu8ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:8; };
struct Ui_BFu7i_BFu8s { unsigned int v1; unsigned int v2:7; unsigned short v3:8; };
struct Ui_BFu7i_BFu9i { unsigned int v1; unsigned int v2:7; unsigned int v3:9; };
struct Ui_BFu7i_BFu9ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:9; };
struct Ui_BFu7i_BFu9s { unsigned int v1; unsigned int v2:7; unsigned short v3:9; };
struct Ui_BFu7i_C { unsigned int v1; unsigned int v2:7; char v3; };
struct Ui_BFu7i_D { unsigned int v1; unsigned int v2:7; double v3; };
struct Ui_BFu7i_F { unsigned int v1; unsigned int v2:7; float v3; };
struct Ui_BFu7i_I { unsigned int v1; unsigned int v2:7; int v3; };
struct Ui_BFu7i_Ip { unsigned int v1; unsigned int v2:7; int * v3; };
struct Ui_BFu7i_L { unsigned int v1; unsigned int v2:7; long long v3; };
struct Ui_BFu7i_S { unsigned int v1; unsigned int v2:7; short v3; };
struct Ui_BFu7i_Uc { unsigned int v1; unsigned int v2:7; unsigned char v3; };
struct Ui_BFu7i_Ui { unsigned int v1; unsigned int v2:7; unsigned int v3; };
struct Ui_BFu7i_Ul { unsigned int v1; unsigned int v2:7; unsigned long long v3; };
struct Ui_BFu7i_Us { unsigned int v1; unsigned int v2:7; unsigned short v3; };
struct Ui_BFu7i_Vp { unsigned int v1; unsigned int v2:7; void * v3; };
struct Ui_BFu7ll { unsigned int v1; unsigned long long v2:7; };
struct Ui_BFu7ll_BFu15i { unsigned int v1; unsigned long long v2:7; unsigned int v3:15; };
struct Ui_BFu7ll_BFu15ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:15; };
struct Ui_BFu7ll_BFu15s { unsigned int v1; unsigned long long v2:7; unsigned short v3:15; };
struct Ui_BFu7ll_BFu16i { unsigned int v1; unsigned long long v2:7; unsigned int v3:16; };
struct Ui_BFu7ll_BFu16ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:16; };
struct Ui_BFu7ll_BFu16s { unsigned int v1; unsigned long long v2:7; unsigned short v3:16; };
struct Ui_BFu7ll_BFu17i { unsigned int v1; unsigned long long v2:7; unsigned int v3:17; };
struct Ui_BFu7ll_BFu17ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:17; };
struct Ui_BFu7ll_BFu1c { unsigned int v1; unsigned long long v2:7; unsigned char v3:1; };
struct Ui_BFu7ll_BFu1i { unsigned int v1; unsigned long long v2:7; unsigned int v3:1; };
struct Ui_BFu7ll_BFu1ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:1; };
struct Ui_BFu7ll_BFu1s { unsigned int v1; unsigned long long v2:7; unsigned short v3:1; };
struct Ui_BFu7ll_BFu31i { unsigned int v1; unsigned long long v2:7; unsigned int v3:31; };
struct Ui_BFu7ll_BFu31ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:31; };
struct Ui_BFu7ll_BFu32i { unsigned int v1; unsigned long long v2:7; unsigned int v3:32; };
struct Ui_BFu7ll_BFu32ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:32; };
struct Ui_BFu7ll_BFu33 { unsigned int v1; unsigned long long v2:7; unsigned long long v3:33; };
struct Ui_BFu7ll_BFu7c { unsigned int v1; unsigned long long v2:7; unsigned char v3:7; };
struct Ui_BFu7ll_BFu7i { unsigned int v1; unsigned long long v2:7; unsigned int v3:7; };
struct Ui_BFu7ll_BFu7ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:7; };
struct Ui_BFu7ll_BFu7s { unsigned int v1; unsigned long long v2:7; unsigned short v3:7; };
struct Ui_BFu7ll_BFu8c { unsigned int v1; unsigned long long v2:7; unsigned char v3:8; };
struct Ui_BFu7ll_BFu8i { unsigned int v1; unsigned long long v2:7; unsigned int v3:8; };
struct Ui_BFu7ll_BFu8ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:8; };
struct Ui_BFu7ll_BFu8s { unsigned int v1; unsigned long long v2:7; unsigned short v3:8; };
struct Ui_BFu7ll_BFu9i { unsigned int v1; unsigned long long v2:7; unsigned int v3:9; };
struct Ui_BFu7ll_BFu9ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:9; };
struct Ui_BFu7ll_BFu9s { unsigned int v1; unsigned long long v2:7; unsigned short v3:9; };
struct Ui_BFu7ll_C { unsigned int v1; unsigned long long v2:7; char v3; };
struct Ui_BFu7ll_D { unsigned int v1; unsigned long long v2:7; double v3; };
struct Ui_BFu7ll_F { unsigned int v1; unsigned long long v2:7; float v3; };
struct Ui_BFu7ll_I { unsigned int v1; unsigned long long v2:7; int v3; };
struct Ui_BFu7ll_Ip { unsigned int v1; unsigned long long v2:7; int * v3; };
struct Ui_BFu7ll_L { unsigned int v1; unsigned long long v2:7; long long v3; };
struct Ui_BFu7ll_S { unsigned int v1; unsigned long long v2:7; short v3; };
struct Ui_BFu7ll_Uc { unsigned int v1; unsigned long long v2:7; unsigned char v3; };
struct Ui_BFu7ll_Ui { unsigned int v1; unsigned long long v2:7; unsigned int v3; };
struct Ui_BFu7ll_Ul { unsigned int v1; unsigned long long v2:7; unsigned long long v3; };
struct Ui_BFu7ll_Us { unsigned int v1; unsigned long long v2:7; unsigned short v3; };
struct Ui_BFu7ll_Vp { unsigned int v1; unsigned long long v2:7; void * v3; };
struct Ui_BFu7s { unsigned int v1; unsigned short v2:7; };
struct Ui_BFu7s_BFu15i { unsigned int v1; unsigned short v2:7; unsigned int v3:15; };
struct Ui_BFu7s_BFu15ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:15; };
struct Ui_BFu7s_BFu15s { unsigned int v1; unsigned short v2:7; unsigned short v3:15; };
struct Ui_BFu7s_BFu16i { unsigned int v1; unsigned short v2:7; unsigned int v3:16; };
struct Ui_BFu7s_BFu16ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:16; };
struct Ui_BFu7s_BFu16s { unsigned int v1; unsigned short v2:7; unsigned short v3:16; };
struct Ui_BFu7s_BFu17i { unsigned int v1; unsigned short v2:7; unsigned int v3:17; };
struct Ui_BFu7s_BFu17ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:17; };
struct Ui_BFu7s_BFu1c { unsigned int v1; unsigned short v2:7; unsigned char v3:1; };
struct Ui_BFu7s_BFu1i { unsigned int v1; unsigned short v2:7; unsigned int v3:1; };
struct Ui_BFu7s_BFu1ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:1; };
struct Ui_BFu7s_BFu1s { unsigned int v1; unsigned short v2:7; unsigned short v3:1; };
struct Ui_BFu7s_BFu31i { unsigned int v1; unsigned short v2:7; unsigned int v3:31; };
struct Ui_BFu7s_BFu31ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:31; };
struct Ui_BFu7s_BFu32i { unsigned int v1; unsigned short v2:7; unsigned int v3:32; };
struct Ui_BFu7s_BFu32ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:32; };
struct Ui_BFu7s_BFu33 { unsigned int v1; unsigned short v2:7; unsigned long long v3:33; };
struct Ui_BFu7s_BFu7c { unsigned int v1; unsigned short v2:7; unsigned char v3:7; };
struct Ui_BFu7s_BFu7i { unsigned int v1; unsigned short v2:7; unsigned int v3:7; };
struct Ui_BFu7s_BFu7ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:7; };
struct Ui_BFu7s_BFu7s { unsigned int v1; unsigned short v2:7; unsigned short v3:7; };
struct Ui_BFu7s_BFu8c { unsigned int v1; unsigned short v2:7; unsigned char v3:8; };
struct Ui_BFu7s_BFu8i { unsigned int v1; unsigned short v2:7; unsigned int v3:8; };
struct Ui_BFu7s_BFu8ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:8; };
struct Ui_BFu7s_BFu8s { unsigned int v1; unsigned short v2:7; unsigned short v3:8; };
struct Ui_BFu7s_BFu9i { unsigned int v1; unsigned short v2:7; unsigned int v3:9; };
struct Ui_BFu7s_BFu9ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:9; };
struct Ui_BFu7s_BFu9s { unsigned int v1; unsigned short v2:7; unsigned short v3:9; };
struct Ui_BFu7s_C { unsigned int v1; unsigned short v2:7; char v3; };
struct Ui_BFu7s_D { unsigned int v1; unsigned short v2:7; double v3; };
struct Ui_BFu7s_F { unsigned int v1; unsigned short v2:7; float v3; };
struct Ui_BFu7s_I { unsigned int v1; unsigned short v2:7; int v3; };
struct Ui_BFu7s_Ip { unsigned int v1; unsigned short v2:7; int * v3; };
struct Ui_BFu7s_L { unsigned int v1; unsigned short v2:7; long long v3; };
struct Ui_BFu7s_S { unsigned int v1; unsigned short v2:7; short v3; };
struct Ui_BFu7s_Uc { unsigned int v1; unsigned short v2:7; unsigned char v3; };
struct Ui_BFu7s_Ui { unsigned int v1; unsigned short v2:7; unsigned int v3; };
struct Ui_BFu7s_Ul { unsigned int v1; unsigned short v2:7; unsigned long long v3; };
struct Ui_BFu7s_Us { unsigned int v1; unsigned short v2:7; unsigned short v3; };
struct Ui_BFu7s_Vp { unsigned int v1; unsigned short v2:7; void * v3; };
struct Ui_BFu8c { unsigned int v1; unsigned char v2:8; };
struct Ui_BFu8c_BFu15i { unsigned int v1; unsigned char v2:8; unsigned int v3:15; };
struct Ui_BFu8c_BFu15ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:15; };
struct Ui_BFu8c_BFu15s { unsigned int v1; unsigned char v2:8; unsigned short v3:15; };
struct Ui_BFu8c_BFu16i { unsigned int v1; unsigned char v2:8; unsigned int v3:16; };
struct Ui_BFu8c_BFu16ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:16; };
struct Ui_BFu8c_BFu16s { unsigned int v1; unsigned char v2:8; unsigned short v3:16; };
struct Ui_BFu8c_BFu17i { unsigned int v1; unsigned char v2:8; unsigned int v3:17; };
struct Ui_BFu8c_BFu17ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:17; };
struct Ui_BFu8c_BFu1c { unsigned int v1; unsigned char v2:8; unsigned char v3:1; };
struct Ui_BFu8c_BFu1i { unsigned int v1; unsigned char v2:8; unsigned int v3:1; };
struct Ui_BFu8c_BFu1ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:1; };
struct Ui_BFu8c_BFu1s { unsigned int v1; unsigned char v2:8; unsigned short v3:1; };
struct Ui_BFu8c_BFu31i { unsigned int v1; unsigned char v2:8; unsigned int v3:31; };
struct Ui_BFu8c_BFu31ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:31; };
struct Ui_BFu8c_BFu32i { unsigned int v1; unsigned char v2:8; unsigned int v3:32; };
struct Ui_BFu8c_BFu32ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:32; };
struct Ui_BFu8c_BFu33 { unsigned int v1; unsigned char v2:8; unsigned long long v3:33; };
struct Ui_BFu8c_BFu7c { unsigned int v1; unsigned char v2:8; unsigned char v3:7; };
struct Ui_BFu8c_BFu7i { unsigned int v1; unsigned char v2:8; unsigned int v3:7; };
struct Ui_BFu8c_BFu7ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:7; };
struct Ui_BFu8c_BFu7s { unsigned int v1; unsigned char v2:8; unsigned short v3:7; };
struct Ui_BFu8c_BFu8c { unsigned int v1; unsigned char v2:8; unsigned char v3:8; };
struct Ui_BFu8c_BFu8i { unsigned int v1; unsigned char v2:8; unsigned int v3:8; };
struct Ui_BFu8c_BFu8ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:8; };
struct Ui_BFu8c_BFu8s { unsigned int v1; unsigned char v2:8; unsigned short v3:8; };
struct Ui_BFu8c_BFu9i { unsigned int v1; unsigned char v2:8; unsigned int v3:9; };
struct Ui_BFu8c_BFu9ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:9; };
struct Ui_BFu8c_BFu9s { unsigned int v1; unsigned char v2:8; unsigned short v3:9; };
struct Ui_BFu8c_C { unsigned int v1; unsigned char v2:8; char v3; };
struct Ui_BFu8c_D { unsigned int v1; unsigned char v2:8; double v3; };
struct Ui_BFu8c_F { unsigned int v1; unsigned char v2:8; float v3; };
struct Ui_BFu8c_I { unsigned int v1; unsigned char v2:8; int v3; };
struct Ui_BFu8c_Ip { unsigned int v1; unsigned char v2:8; int * v3; };
struct Ui_BFu8c_L { unsigned int v1; unsigned char v2:8; long long v3; };
struct Ui_BFu8c_S { unsigned int v1; unsigned char v2:8; short v3; };
struct Ui_BFu8c_Uc { unsigned int v1; unsigned char v2:8; unsigned char v3; };
struct Ui_BFu8c_Ui { unsigned int v1; unsigned char v2:8; unsigned int v3; };
struct Ui_BFu8c_Ul { unsigned int v1; unsigned char v2:8; unsigned long long v3; };
struct Ui_BFu8c_Us { unsigned int v1; unsigned char v2:8; unsigned short v3; };
struct Ui_BFu8c_Vp { unsigned int v1; unsigned char v2:8; void * v3; };
struct Ui_BFu8i { unsigned int v1; unsigned int v2:8; };
struct Ui_BFu8i_BFu15i { unsigned int v1; unsigned int v2:8; unsigned int v3:15; };
struct Ui_BFu8i_BFu15ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:15; };
struct Ui_BFu8i_BFu15s { unsigned int v1; unsigned int v2:8; unsigned short v3:15; };
struct Ui_BFu8i_BFu16i { unsigned int v1; unsigned int v2:8; unsigned int v3:16; };
struct Ui_BFu8i_BFu16ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:16; };
struct Ui_BFu8i_BFu16s { unsigned int v1; unsigned int v2:8; unsigned short v3:16; };
struct Ui_BFu8i_BFu17i { unsigned int v1; unsigned int v2:8; unsigned int v3:17; };
struct Ui_BFu8i_BFu17ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:17; };
struct Ui_BFu8i_BFu1c { unsigned int v1; unsigned int v2:8; unsigned char v3:1; };
struct Ui_BFu8i_BFu1i { unsigned int v1; unsigned int v2:8; unsigned int v3:1; };
struct Ui_BFu8i_BFu1ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:1; };
struct Ui_BFu8i_BFu1s { unsigned int v1; unsigned int v2:8; unsigned short v3:1; };
struct Ui_BFu8i_BFu31i { unsigned int v1; unsigned int v2:8; unsigned int v3:31; };
struct Ui_BFu8i_BFu31ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:31; };
struct Ui_BFu8i_BFu32i { unsigned int v1; unsigned int v2:8; unsigned int v3:32; };
struct Ui_BFu8i_BFu32ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:32; };
struct Ui_BFu8i_BFu33 { unsigned int v1; unsigned int v2:8; unsigned long long v3:33; };
struct Ui_BFu8i_BFu7c { unsigned int v1; unsigned int v2:8; unsigned char v3:7; };
struct Ui_BFu8i_BFu7i { unsigned int v1; unsigned int v2:8; unsigned int v3:7; };
struct Ui_BFu8i_BFu7ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:7; };
struct Ui_BFu8i_BFu7s { unsigned int v1; unsigned int v2:8; unsigned short v3:7; };
struct Ui_BFu8i_BFu8c { unsigned int v1; unsigned int v2:8; unsigned char v3:8; };
struct Ui_BFu8i_BFu8i { unsigned int v1; unsigned int v2:8; unsigned int v3:8; };
struct Ui_BFu8i_BFu8ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:8; };
struct Ui_BFu8i_BFu8s { unsigned int v1; unsigned int v2:8; unsigned short v3:8; };
struct Ui_BFu8i_BFu9i { unsigned int v1; unsigned int v2:8; unsigned int v3:9; };
struct Ui_BFu8i_BFu9ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:9; };
struct Ui_BFu8i_BFu9s { unsigned int v1; unsigned int v2:8; unsigned short v3:9; };
struct Ui_BFu8i_C { unsigned int v1; unsigned int v2:8; char v3; };
struct Ui_BFu8i_D { unsigned int v1; unsigned int v2:8; double v3; };
struct Ui_BFu8i_F { unsigned int v1; unsigned int v2:8; float v3; };
struct Ui_BFu8i_I { unsigned int v1; unsigned int v2:8; int v3; };
struct Ui_BFu8i_Ip { unsigned int v1; unsigned int v2:8; int * v3; };
struct Ui_BFu8i_L { unsigned int v1; unsigned int v2:8; long long v3; };
struct Ui_BFu8i_S { unsigned int v1; unsigned int v2:8; short v3; };
struct Ui_BFu8i_Uc { unsigned int v1; unsigned int v2:8; unsigned char v3; };
struct Ui_BFu8i_Ui { unsigned int v1; unsigned int v2:8; unsigned int v3; };
struct Ui_BFu8i_Ul { unsigned int v1; unsigned int v2:8; unsigned long long v3; };
struct Ui_BFu8i_Us { unsigned int v1; unsigned int v2:8; unsigned short v3; };
struct Ui_BFu8i_Vp { unsigned int v1; unsigned int v2:8; void * v3; };
struct Ui_BFu8ll { unsigned int v1; unsigned long long v2:8; };
struct Ui_BFu8ll_BFu15i { unsigned int v1; unsigned long long v2:8; unsigned int v3:15; };
struct Ui_BFu8ll_BFu15ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:15; };
struct Ui_BFu8ll_BFu15s { unsigned int v1; unsigned long long v2:8; unsigned short v3:15; };
struct Ui_BFu8ll_BFu16i { unsigned int v1; unsigned long long v2:8; unsigned int v3:16; };
struct Ui_BFu8ll_BFu16ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:16; };
struct Ui_BFu8ll_BFu16s { unsigned int v1; unsigned long long v2:8; unsigned short v3:16; };
struct Ui_BFu8ll_BFu17i { unsigned int v1; unsigned long long v2:8; unsigned int v3:17; };
struct Ui_BFu8ll_BFu17ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:17; };
struct Ui_BFu8ll_BFu1c { unsigned int v1; unsigned long long v2:8; unsigned char v3:1; };
struct Ui_BFu8ll_BFu1i { unsigned int v1; unsigned long long v2:8; unsigned int v3:1; };
struct Ui_BFu8ll_BFu1ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:1; };
struct Ui_BFu8ll_BFu1s { unsigned int v1; unsigned long long v2:8; unsigned short v3:1; };
struct Ui_BFu8ll_BFu31i { unsigned int v1; unsigned long long v2:8; unsigned int v3:31; };
struct Ui_BFu8ll_BFu31ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:31; };
struct Ui_BFu8ll_BFu32i { unsigned int v1; unsigned long long v2:8; unsigned int v3:32; };
struct Ui_BFu8ll_BFu32ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:32; };
struct Ui_BFu8ll_BFu33 { unsigned int v1; unsigned long long v2:8; unsigned long long v3:33; };
struct Ui_BFu8ll_BFu7c { unsigned int v1; unsigned long long v2:8; unsigned char v3:7; };
struct Ui_BFu8ll_BFu7i { unsigned int v1; unsigned long long v2:8; unsigned int v3:7; };
struct Ui_BFu8ll_BFu7ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:7; };
struct Ui_BFu8ll_BFu7s { unsigned int v1; unsigned long long v2:8; unsigned short v3:7; };
struct Ui_BFu8ll_BFu8c { unsigned int v1; unsigned long long v2:8; unsigned char v3:8; };
struct Ui_BFu8ll_BFu8i { unsigned int v1; unsigned long long v2:8; unsigned int v3:8; };
struct Ui_BFu8ll_BFu8ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:8; };
struct Ui_BFu8ll_BFu8s { unsigned int v1; unsigned long long v2:8; unsigned short v3:8; };
struct Ui_BFu8ll_BFu9i { unsigned int v1; unsigned long long v2:8; unsigned int v3:9; };
struct Ui_BFu8ll_BFu9ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:9; };
struct Ui_BFu8ll_BFu9s { unsigned int v1; unsigned long long v2:8; unsigned short v3:9; };
struct Ui_BFu8ll_C { unsigned int v1; unsigned long long v2:8; char v3; };
struct Ui_BFu8ll_D { unsigned int v1; unsigned long long v2:8; double v3; };
struct Ui_BFu8ll_F { unsigned int v1; unsigned long long v2:8; float v3; };
struct Ui_BFu8ll_I { unsigned int v1; unsigned long long v2:8; int v3; };
struct Ui_BFu8ll_Ip { unsigned int v1; unsigned long long v2:8; int * v3; };
struct Ui_BFu8ll_L { unsigned int v1; unsigned long long v2:8; long long v3; };
struct Ui_BFu8ll_S { unsigned int v1; unsigned long long v2:8; short v3; };
struct Ui_BFu8ll_Uc { unsigned int v1; unsigned long long v2:8; unsigned char v3; };
struct Ui_BFu8ll_Ui { unsigned int v1; unsigned long long v2:8; unsigned int v3; };
struct Ui_BFu8ll_Ul { unsigned int v1; unsigned long long v2:8; unsigned long long v3; };
struct Ui_BFu8ll_Us { unsigned int v1; unsigned long long v2:8; unsigned short v3; };
struct Ui_BFu8ll_Vp { unsigned int v1; unsigned long long v2:8; void * v3; };
struct Ui_BFu8s { unsigned int v1; unsigned short v2:8; };
struct Ui_BFu8s_BFu15i { unsigned int v1; unsigned short v2:8; unsigned int v3:15; };
struct Ui_BFu8s_BFu15ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:15; };
struct Ui_BFu8s_BFu15s { unsigned int v1; unsigned short v2:8; unsigned short v3:15; };
struct Ui_BFu8s_BFu16i { unsigned int v1; unsigned short v2:8; unsigned int v3:16; };
struct Ui_BFu8s_BFu16ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:16; };
struct Ui_BFu8s_BFu16s { unsigned int v1; unsigned short v2:8; unsigned short v3:16; };
struct Ui_BFu8s_BFu17i { unsigned int v1; unsigned short v2:8; unsigned int v3:17; };
struct Ui_BFu8s_BFu17ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:17; };
struct Ui_BFu8s_BFu1c { unsigned int v1; unsigned short v2:8; unsigned char v3:1; };
struct Ui_BFu8s_BFu1i { unsigned int v1; unsigned short v2:8; unsigned int v3:1; };
struct Ui_BFu8s_BFu1ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:1; };
struct Ui_BFu8s_BFu1s { unsigned int v1; unsigned short v2:8; unsigned short v3:1; };
struct Ui_BFu8s_BFu31i { unsigned int v1; unsigned short v2:8; unsigned int v3:31; };
struct Ui_BFu8s_BFu31ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:31; };
struct Ui_BFu8s_BFu32i { unsigned int v1; unsigned short v2:8; unsigned int v3:32; };
struct Ui_BFu8s_BFu32ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:32; };
struct Ui_BFu8s_BFu33 { unsigned int v1; unsigned short v2:8; unsigned long long v3:33; };
struct Ui_BFu8s_BFu7c { unsigned int v1; unsigned short v2:8; unsigned char v3:7; };
struct Ui_BFu8s_BFu7i { unsigned int v1; unsigned short v2:8; unsigned int v3:7; };
struct Ui_BFu8s_BFu7ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:7; };
struct Ui_BFu8s_BFu7s { unsigned int v1; unsigned short v2:8; unsigned short v3:7; };
struct Ui_BFu8s_BFu8c { unsigned int v1; unsigned short v2:8; unsigned char v3:8; };
struct Ui_BFu8s_BFu8i { unsigned int v1; unsigned short v2:8; unsigned int v3:8; };
struct Ui_BFu8s_BFu8ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:8; };
struct Ui_BFu8s_BFu8s { unsigned int v1; unsigned short v2:8; unsigned short v3:8; };
struct Ui_BFu8s_BFu9i { unsigned int v1; unsigned short v2:8; unsigned int v3:9; };
struct Ui_BFu8s_BFu9ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:9; };
struct Ui_BFu8s_BFu9s { unsigned int v1; unsigned short v2:8; unsigned short v3:9; };
struct Ui_BFu8s_C { unsigned int v1; unsigned short v2:8; char v3; };
struct Ui_BFu8s_D { unsigned int v1; unsigned short v2:8; double v3; };
struct Ui_BFu8s_F { unsigned int v1; unsigned short v2:8; float v3; };
struct Ui_BFu8s_I { unsigned int v1; unsigned short v2:8; int v3; };
struct Ui_BFu8s_Ip { unsigned int v1; unsigned short v2:8; int * v3; };
struct Ui_BFu8s_L { unsigned int v1; unsigned short v2:8; long long v3; };
struct Ui_BFu8s_S { unsigned int v1; unsigned short v2:8; short v3; };
struct Ui_BFu8s_Uc { unsigned int v1; unsigned short v2:8; unsigned char v3; };
struct Ui_BFu8s_Ui { unsigned int v1; unsigned short v2:8; unsigned int v3; };
struct Ui_BFu8s_Ul { unsigned int v1; unsigned short v2:8; unsigned long long v3; };
struct Ui_BFu8s_Us { unsigned int v1; unsigned short v2:8; unsigned short v3; };
struct Ui_BFu8s_Vp { unsigned int v1; unsigned short v2:8; void * v3; };
struct Ui_BFu9i { unsigned int v1; unsigned int v2:9; };
struct Ui_BFu9i_BFu15i { unsigned int v1; unsigned int v2:9; unsigned int v3:15; };
struct Ui_BFu9i_BFu15ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:15; };
struct Ui_BFu9i_BFu15s { unsigned int v1; unsigned int v2:9; unsigned short v3:15; };
struct Ui_BFu9i_BFu16i { unsigned int v1; unsigned int v2:9; unsigned int v3:16; };
struct Ui_BFu9i_BFu16ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:16; };
struct Ui_BFu9i_BFu16s { unsigned int v1; unsigned int v2:9; unsigned short v3:16; };
struct Ui_BFu9i_BFu17i { unsigned int v1; unsigned int v2:9; unsigned int v3:17; };
struct Ui_BFu9i_BFu17ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:17; };
struct Ui_BFu9i_BFu1c { unsigned int v1; unsigned int v2:9; unsigned char v3:1; };
struct Ui_BFu9i_BFu1i { unsigned int v1; unsigned int v2:9; unsigned int v3:1; };
struct Ui_BFu9i_BFu1ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:1; };
struct Ui_BFu9i_BFu1s { unsigned int v1; unsigned int v2:9; unsigned short v3:1; };
struct Ui_BFu9i_BFu31i { unsigned int v1; unsigned int v2:9; unsigned int v3:31; };
struct Ui_BFu9i_BFu31ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:31; };
struct Ui_BFu9i_BFu32i { unsigned int v1; unsigned int v2:9; unsigned int v3:32; };
struct Ui_BFu9i_BFu32ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:32; };
struct Ui_BFu9i_BFu33 { unsigned int v1; unsigned int v2:9; unsigned long long v3:33; };
struct Ui_BFu9i_BFu7c { unsigned int v1; unsigned int v2:9; unsigned char v3:7; };
struct Ui_BFu9i_BFu7i { unsigned int v1; unsigned int v2:9; unsigned int v3:7; };
struct Ui_BFu9i_BFu7ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:7; };
struct Ui_BFu9i_BFu7s { unsigned int v1; unsigned int v2:9; unsigned short v3:7; };
struct Ui_BFu9i_BFu8c { unsigned int v1; unsigned int v2:9; unsigned char v3:8; };
struct Ui_BFu9i_BFu8i { unsigned int v1; unsigned int v2:9; unsigned int v3:8; };
struct Ui_BFu9i_BFu8ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:8; };
struct Ui_BFu9i_BFu8s { unsigned int v1; unsigned int v2:9; unsigned short v3:8; };
struct Ui_BFu9i_BFu9i { unsigned int v1; unsigned int v2:9; unsigned int v3:9; };
struct Ui_BFu9i_BFu9ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:9; };
struct Ui_BFu9i_BFu9s { unsigned int v1; unsigned int v2:9; unsigned short v3:9; };
struct Ui_BFu9i_C { unsigned int v1; unsigned int v2:9; char v3; };
struct Ui_BFu9i_D { unsigned int v1; unsigned int v2:9; double v3; };
struct Ui_BFu9i_F { unsigned int v1; unsigned int v2:9; float v3; };
struct Ui_BFu9i_I { unsigned int v1; unsigned int v2:9; int v3; };
struct Ui_BFu9i_Ip { unsigned int v1; unsigned int v2:9; int * v3; };
struct Ui_BFu9i_L { unsigned int v1; unsigned int v2:9; long long v3; };
struct Ui_BFu9i_S { unsigned int v1; unsigned int v2:9; short v3; };
struct Ui_BFu9i_Uc { unsigned int v1; unsigned int v2:9; unsigned char v3; };
struct Ui_BFu9i_Ui { unsigned int v1; unsigned int v2:9; unsigned int v3; };
struct Ui_BFu9i_Ul { unsigned int v1; unsigned int v2:9; unsigned long long v3; };
struct Ui_BFu9i_Us { unsigned int v1; unsigned int v2:9; unsigned short v3; };
struct Ui_BFu9i_Vp { unsigned int v1; unsigned int v2:9; void * v3; };
struct Ui_BFu9ll { unsigned int v1; unsigned long long v2:9; };
struct Ui_BFu9ll_BFu15i { unsigned int v1; unsigned long long v2:9; unsigned int v3:15; };
struct Ui_BFu9ll_BFu15ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:15; };
struct Ui_BFu9ll_BFu15s { unsigned int v1; unsigned long long v2:9; unsigned short v3:15; };
struct Ui_BFu9ll_BFu16i { unsigned int v1; unsigned long long v2:9; unsigned int v3:16; };
struct Ui_BFu9ll_BFu16ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:16; };
struct Ui_BFu9ll_BFu16s { unsigned int v1; unsigned long long v2:9; unsigned short v3:16; };
struct Ui_BFu9ll_BFu17i { unsigned int v1; unsigned long long v2:9; unsigned int v3:17; };
struct Ui_BFu9ll_BFu17ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:17; };
struct Ui_BFu9ll_BFu1c { unsigned int v1; unsigned long long v2:9; unsigned char v3:1; };
struct Ui_BFu9ll_BFu1i { unsigned int v1; unsigned long long v2:9; unsigned int v3:1; };
struct Ui_BFu9ll_BFu1ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:1; };
struct Ui_BFu9ll_BFu1s { unsigned int v1; unsigned long long v2:9; unsigned short v3:1; };
struct Ui_BFu9ll_BFu31i { unsigned int v1; unsigned long long v2:9; unsigned int v3:31; };
struct Ui_BFu9ll_BFu31ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:31; };
struct Ui_BFu9ll_BFu32i { unsigned int v1; unsigned long long v2:9; unsigned int v3:32; };
struct Ui_BFu9ll_BFu32ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:32; };
struct Ui_BFu9ll_BFu33 { unsigned int v1; unsigned long long v2:9; unsigned long long v3:33; };
struct Ui_BFu9ll_BFu7c { unsigned int v1; unsigned long long v2:9; unsigned char v3:7; };
struct Ui_BFu9ll_BFu7i { unsigned int v1; unsigned long long v2:9; unsigned int v3:7; };
struct Ui_BFu9ll_BFu7ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:7; };
struct Ui_BFu9ll_BFu7s { unsigned int v1; unsigned long long v2:9; unsigned short v3:7; };
struct Ui_BFu9ll_BFu8c { unsigned int v1; unsigned long long v2:9; unsigned char v3:8; };
struct Ui_BFu9ll_BFu8i { unsigned int v1; unsigned long long v2:9; unsigned int v3:8; };
struct Ui_BFu9ll_BFu8ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:8; };
struct Ui_BFu9ll_BFu8s { unsigned int v1; unsigned long long v2:9; unsigned short v3:8; };
struct Ui_BFu9ll_BFu9i { unsigned int v1; unsigned long long v2:9; unsigned int v3:9; };
struct Ui_BFu9ll_BFu9ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:9; };
struct Ui_BFu9ll_BFu9s { unsigned int v1; unsigned long long v2:9; unsigned short v3:9; };
struct Ui_BFu9ll_C { unsigned int v1; unsigned long long v2:9; char v3; };
struct Ui_BFu9ll_D { unsigned int v1; unsigned long long v2:9; double v3; };
struct Ui_BFu9ll_F { unsigned int v1; unsigned long long v2:9; float v3; };
struct Ui_BFu9ll_I { unsigned int v1; unsigned long long v2:9; int v3; };
struct Ui_BFu9ll_Ip { unsigned int v1; unsigned long long v2:9; int * v3; };
struct Ui_BFu9ll_L { unsigned int v1; unsigned long long v2:9; long long v3; };
struct Ui_BFu9ll_S { unsigned int v1; unsigned long long v2:9; short v3; };
struct Ui_BFu9ll_Uc { unsigned int v1; unsigned long long v2:9; unsigned char v3; };
struct Ui_BFu9ll_Ui { unsigned int v1; unsigned long long v2:9; unsigned int v3; };
struct Ui_BFu9ll_Ul { unsigned int v1; unsigned long long v2:9; unsigned long long v3; };
struct Ui_BFu9ll_Us { unsigned int v1; unsigned long long v2:9; unsigned short v3; };
struct Ui_BFu9ll_Vp { unsigned int v1; unsigned long long v2:9; void * v3; };
struct Ui_BFu9s { unsigned int v1; unsigned short v2:9; };
struct Ui_BFu9s_BFu15i { unsigned int v1; unsigned short v2:9; unsigned int v3:15; };
struct Ui_BFu9s_BFu15ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:15; };
struct Ui_BFu9s_BFu15s { unsigned int v1; unsigned short v2:9; unsigned short v3:15; };
struct Ui_BFu9s_BFu16i { unsigned int v1; unsigned short v2:9; unsigned int v3:16; };
struct Ui_BFu9s_BFu16ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:16; };
struct Ui_BFu9s_BFu16s { unsigned int v1; unsigned short v2:9; unsigned short v3:16; };
struct Ui_BFu9s_BFu17i { unsigned int v1; unsigned short v2:9; unsigned int v3:17; };
struct Ui_BFu9s_BFu17ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:17; };
struct Ui_BFu9s_BFu1c { unsigned int v1; unsigned short v2:9; unsigned char v3:1; };
struct Ui_BFu9s_BFu1i { unsigned int v1; unsigned short v2:9; unsigned int v3:1; };
struct Ui_BFu9s_BFu1ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:1; };
struct Ui_BFu9s_BFu1s { unsigned int v1; unsigned short v2:9; unsigned short v3:1; };
struct Ui_BFu9s_BFu31i { unsigned int v1; unsigned short v2:9; unsigned int v3:31; };
struct Ui_BFu9s_BFu31ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:31; };
struct Ui_BFu9s_BFu32i { unsigned int v1; unsigned short v2:9; unsigned int v3:32; };
struct Ui_BFu9s_BFu32ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:32; };
struct Ui_BFu9s_BFu33 { unsigned int v1; unsigned short v2:9; unsigned long long v3:33; };
struct Ui_BFu9s_BFu7c { unsigned int v1; unsigned short v2:9; unsigned char v3:7; };
struct Ui_BFu9s_BFu7i { unsigned int v1; unsigned short v2:9; unsigned int v3:7; };
struct Ui_BFu9s_BFu7ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:7; };
struct Ui_BFu9s_BFu7s { unsigned int v1; unsigned short v2:9; unsigned short v3:7; };
struct Ui_BFu9s_BFu8c { unsigned int v1; unsigned short v2:9; unsigned char v3:8; };
struct Ui_BFu9s_BFu8i { unsigned int v1; unsigned short v2:9; unsigned int v3:8; };
struct Ui_BFu9s_BFu8ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:8; };
struct Ui_BFu9s_BFu8s { unsigned int v1; unsigned short v2:9; unsigned short v3:8; };
struct Ui_BFu9s_BFu9i { unsigned int v1; unsigned short v2:9; unsigned int v3:9; };
struct Ui_BFu9s_BFu9ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:9; };
struct Ui_BFu9s_BFu9s { unsigned int v1; unsigned short v2:9; unsigned short v3:9; };
struct Ui_BFu9s_C { unsigned int v1; unsigned short v2:9; char v3; };
struct Ui_BFu9s_D { unsigned int v1; unsigned short v2:9; double v3; };
struct Ui_BFu9s_F { unsigned int v1; unsigned short v2:9; float v3; };
struct Ui_BFu9s_I { unsigned int v1; unsigned short v2:9; int v3; };
struct Ui_BFu9s_Ip { unsigned int v1; unsigned short v2:9; int * v3; };
struct Ui_BFu9s_L { unsigned int v1; unsigned short v2:9; long long v3; };
struct Ui_BFu9s_S { unsigned int v1; unsigned short v2:9; short v3; };
struct Ui_BFu9s_Uc { unsigned int v1; unsigned short v2:9; unsigned char v3; };
struct Ui_BFu9s_Ui { unsigned int v1; unsigned short v2:9; unsigned int v3; };
struct Ui_BFu9s_Ul { unsigned int v1; unsigned short v2:9; unsigned long long v3; };
struct Ui_BFu9s_Us { unsigned int v1; unsigned short v2:9; unsigned short v3; };
struct Ui_BFu9s_Vp { unsigned int v1; unsigned short v2:9; void * v3; };
struct Ui_C { unsigned int v1; char v2; };
struct Ui_C_BFu15i { unsigned int v1; char v2; unsigned int v3:15; };
struct Ui_C_BFu15ll { unsigned int v1; char v2; unsigned long long v3:15; };
struct Ui_C_BFu15s { unsigned int v1; char v2; unsigned short v3:15; };
struct Ui_C_BFu16i { unsigned int v1; char v2; unsigned int v3:16; };
struct Ui_C_BFu16ll { unsigned int v1; char v2; unsigned long long v3:16; };
struct Ui_C_BFu16s { unsigned int v1; char v2; unsigned short v3:16; };
struct Ui_C_BFu17i { unsigned int v1; char v2; unsigned int v3:17; };
struct Ui_C_BFu17ll { unsigned int v1; char v2; unsigned long long v3:17; };
struct Ui_C_BFu1c { unsigned int v1; char v2; unsigned char v3:1; };
struct Ui_C_BFu1i { unsigned int v1; char v2; unsigned int v3:1; };
struct Ui_C_BFu1ll { unsigned int v1; char v2; unsigned long long v3:1; };
struct Ui_C_BFu1s { unsigned int v1; char v2; unsigned short v3:1; };
struct Ui_C_BFu31i { unsigned int v1; char v2; unsigned int v3:31; };
struct Ui_C_BFu31ll { unsigned int v1; char v2; unsigned long long v3:31; };
struct Ui_C_BFu32i { unsigned int v1; char v2; unsigned int v3:32; };
struct Ui_C_BFu32ll { unsigned int v1; char v2; unsigned long long v3:32; };
struct Ui_C_BFu33 { unsigned int v1; char v2; unsigned long long v3:33; };
struct Ui_C_BFu7c { unsigned int v1; char v2; unsigned char v3:7; };
struct Ui_C_BFu7i { unsigned int v1; char v2; unsigned int v3:7; };
struct Ui_C_BFu7ll { unsigned int v1; char v2; unsigned long long v3:7; };
struct Ui_C_BFu7s { unsigned int v1; char v2; unsigned short v3:7; };
struct Ui_C_BFu8c { unsigned int v1; char v2; unsigned char v3:8; };
struct Ui_C_BFu8i { unsigned int v1; char v2; unsigned int v3:8; };
struct Ui_C_BFu8ll { unsigned int v1; char v2; unsigned long long v3:8; };
struct Ui_C_BFu8s { unsigned int v1; char v2; unsigned short v3:8; };
struct Ui_C_BFu9i { unsigned int v1; char v2; unsigned int v3:9; };
struct Ui_C_BFu9ll { unsigned int v1; char v2; unsigned long long v3:9; };
struct Ui_C_BFu9s { unsigned int v1; char v2; unsigned short v3:9; };
struct Ui_C_C { unsigned int v1; char v2; char v3; };
struct Ui_C_D { unsigned int v1; char v2; double v3; };
struct Ui_C_F { unsigned int v1; char v2; float v3; };
struct Ui_C_I { unsigned int v1; char v2; int v3; };
struct Ui_C_Ip { unsigned int v1; char v2; int * v3; };
struct Ui_C_L { unsigned int v1; char v2; long long v3; };
struct Ui_C_S { unsigned int v1; char v2; short v3; };
struct Ui_C_Uc { unsigned int v1; char v2; unsigned char v3; };
struct Ui_C_Ui { unsigned int v1; char v2; unsigned int v3; };
struct Ui_C_Ul { unsigned int v1; char v2; unsigned long long v3; };
struct Ui_C_Us { unsigned int v1; char v2; unsigned short v3; };
struct Ui_C_Vp { unsigned int v1; char v2; void * v3; };
struct Ui_D { unsigned int v1; double v2; };
struct Ui_D_BFu15i { unsigned int v1; double v2; unsigned int v3:15; };
struct Ui_D_BFu15ll { unsigned int v1; double v2; unsigned long long v3:15; };
struct Ui_D_BFu15s { unsigned int v1; double v2; unsigned short v3:15; };
struct Ui_D_BFu16i { unsigned int v1; double v2; unsigned int v3:16; };
struct Ui_D_BFu16ll { unsigned int v1; double v2; unsigned long long v3:16; };
struct Ui_D_BFu16s { unsigned int v1; double v2; unsigned short v3:16; };
struct Ui_D_BFu17i { unsigned int v1; double v2; unsigned int v3:17; };
struct Ui_D_BFu17ll { unsigned int v1; double v2; unsigned long long v3:17; };
struct Ui_D_BFu1c { unsigned int v1; double v2; unsigned char v3:1; };
struct Ui_D_BFu1i { unsigned int v1; double v2; unsigned int v3:1; };
struct Ui_D_BFu1ll { unsigned int v1; double v2; unsigned long long v3:1; };
struct Ui_D_BFu1s { unsigned int v1; double v2; unsigned short v3:1; };
struct Ui_D_BFu31i { unsigned int v1; double v2; unsigned int v3:31; };
struct Ui_D_BFu31ll { unsigned int v1; double v2; unsigned long long v3:31; };
struct Ui_D_BFu32i { unsigned int v1; double v2; unsigned int v3:32; };
struct Ui_D_BFu32ll { unsigned int v1; double v2; unsigned long long v3:32; };
struct Ui_D_BFu33 { unsigned int v1; double v2; unsigned long long v3:33; };
struct Ui_D_BFu7c { unsigned int v1; double v2; unsigned char v3:7; };
struct Ui_D_BFu7i { unsigned int v1; double v2; unsigned int v3:7; };
struct Ui_D_BFu7ll { unsigned int v1; double v2; unsigned long long v3:7; };
struct Ui_D_BFu7s { unsigned int v1; double v2; unsigned short v3:7; };
struct Ui_D_BFu8c { unsigned int v1; double v2; unsigned char v3:8; };
struct Ui_D_BFu8i { unsigned int v1; double v2; unsigned int v3:8; };
struct Ui_D_BFu8ll { unsigned int v1; double v2; unsigned long long v3:8; };
struct Ui_D_BFu8s { unsigned int v1; double v2; unsigned short v3:8; };
struct Ui_D_BFu9i { unsigned int v1; double v2; unsigned int v3:9; };
struct Ui_D_BFu9ll { unsigned int v1; double v2; unsigned long long v3:9; };
struct Ui_D_BFu9s { unsigned int v1; double v2; unsigned short v3:9; };
struct Ui_D_C { unsigned int v1; double v2; char v3; };
struct Ui_D_D { unsigned int v1; double v2; double v3; };
struct Ui_D_F { unsigned int v1; double v2; float v3; };
struct Ui_D_I { unsigned int v1; double v2; int v3; };
struct Ui_D_Ip { unsigned int v1; double v2; int * v3; };
struct Ui_D_L { unsigned int v1; double v2; long long v3; };
struct Ui_D_S { unsigned int v1; double v2; short v3; };
struct Ui_D_Uc { unsigned int v1; double v2; unsigned char v3; };
struct Ui_D_Ui { unsigned int v1; double v2; unsigned int v3; };
struct Ui_D_Ul { unsigned int v1; double v2; unsigned long long v3; };
struct Ui_D_Us { unsigned int v1; double v2; unsigned short v3; };
struct Ui_D_Vp { unsigned int v1; double v2; void * v3; };
struct Ui_F { unsigned int v1; float v2; };
struct Ui_F_BFu15i { unsigned int v1; float v2; unsigned int v3:15; };
struct Ui_F_BFu15ll { unsigned int v1; float v2; unsigned long long v3:15; };
struct Ui_F_BFu15s { unsigned int v1; float v2; unsigned short v3:15; };
struct Ui_F_BFu16i { unsigned int v1; float v2; unsigned int v3:16; };
struct Ui_F_BFu16ll { unsigned int v1; float v2; unsigned long long v3:16; };
struct Ui_F_BFu16s { unsigned int v1; float v2; unsigned short v3:16; };
struct Ui_F_BFu17i { unsigned int v1; float v2; unsigned int v3:17; };
struct Ui_F_BFu17ll { unsigned int v1; float v2; unsigned long long v3:17; };
struct Ui_F_BFu1c { unsigned int v1; float v2; unsigned char v3:1; };
struct Ui_F_BFu1i { unsigned int v1; float v2; unsigned int v3:1; };
struct Ui_F_BFu1ll { unsigned int v1; float v2; unsigned long long v3:1; };
struct Ui_F_BFu1s { unsigned int v1; float v2; unsigned short v3:1; };
struct Ui_F_BFu31i { unsigned int v1; float v2; unsigned int v3:31; };
struct Ui_F_BFu31ll { unsigned int v1; float v2; unsigned long long v3:31; };
struct Ui_F_BFu32i { unsigned int v1; float v2; unsigned int v3:32; };
struct Ui_F_BFu32ll { unsigned int v1; float v2; unsigned long long v3:32; };
struct Ui_F_BFu33 { unsigned int v1; float v2; unsigned long long v3:33; };
struct Ui_F_BFu7c { unsigned int v1; float v2; unsigned char v3:7; };
struct Ui_F_BFu7i { unsigned int v1; float v2; unsigned int v3:7; };
struct Ui_F_BFu7ll { unsigned int v1; float v2; unsigned long long v3:7; };
struct Ui_F_BFu7s { unsigned int v1; float v2; unsigned short v3:7; };
struct Ui_F_BFu8c { unsigned int v1; float v2; unsigned char v3:8; };
struct Ui_F_BFu8i { unsigned int v1; float v2; unsigned int v3:8; };
struct Ui_F_BFu8ll { unsigned int v1; float v2; unsigned long long v3:8; };
struct Ui_F_BFu8s { unsigned int v1; float v2; unsigned short v3:8; };
struct Ui_F_BFu9i { unsigned int v1; float v2; unsigned int v3:9; };
struct Ui_F_BFu9ll { unsigned int v1; float v2; unsigned long long v3:9; };
struct Ui_F_BFu9s { unsigned int v1; float v2; unsigned short v3:9; };
struct Ui_F_C { unsigned int v1; float v2; char v3; };
struct Ui_F_D { unsigned int v1; float v2; double v3; };
struct Ui_F_F { unsigned int v1; float v2; float v3; };
struct Ui_F_I { unsigned int v1; float v2; int v3; };
struct Ui_F_Ip { unsigned int v1; float v2; int * v3; };
struct Ui_F_L { unsigned int v1; float v2; long long v3; };
struct Ui_F_S { unsigned int v1; float v2; short v3; };
struct Ui_F_Uc { unsigned int v1; float v2; unsigned char v3; };
struct Ui_F_Ui { unsigned int v1; float v2; unsigned int v3; };
struct Ui_F_Ul { unsigned int v1; float v2; unsigned long long v3; };
struct Ui_F_Us { unsigned int v1; float v2; unsigned short v3; };
struct Ui_F_Vp { unsigned int v1; float v2; void * v3; };
struct Ui_I { unsigned int v1; int v2; };
struct Ui_I_BFu15i { unsigned int v1; int v2; unsigned int v3:15; };
struct Ui_I_BFu15ll { unsigned int v1; int v2; unsigned long long v3:15; };
struct Ui_I_BFu15s { unsigned int v1; int v2; unsigned short v3:15; };
struct Ui_I_BFu16i { unsigned int v1; int v2; unsigned int v3:16; };
struct Ui_I_BFu16ll { unsigned int v1; int v2; unsigned long long v3:16; };
struct Ui_I_BFu16s { unsigned int v1; int v2; unsigned short v3:16; };
struct Ui_I_BFu17i { unsigned int v1; int v2; unsigned int v3:17; };
struct Ui_I_BFu17ll { unsigned int v1; int v2; unsigned long long v3:17; };
struct Ui_I_BFu1c { unsigned int v1; int v2; unsigned char v3:1; };
struct Ui_I_BFu1i { unsigned int v1; int v2; unsigned int v3:1; };
struct Ui_I_BFu1ll { unsigned int v1; int v2; unsigned long long v3:1; };
struct Ui_I_BFu1s { unsigned int v1; int v2; unsigned short v3:1; };
struct Ui_I_BFu31i { unsigned int v1; int v2; unsigned int v3:31; };
struct Ui_I_BFu31ll { unsigned int v1; int v2; unsigned long long v3:31; };
struct Ui_I_BFu32i { unsigned int v1; int v2; unsigned int v3:32; };
struct Ui_I_BFu32ll { unsigned int v1; int v2; unsigned long long v3:32; };
struct Ui_I_BFu33 { unsigned int v1; int v2; unsigned long long v3:33; };
struct Ui_I_BFu7c { unsigned int v1; int v2; unsigned char v3:7; };
struct Ui_I_BFu7i { unsigned int v1; int v2; unsigned int v3:7; };
struct Ui_I_BFu7ll { unsigned int v1; int v2; unsigned long long v3:7; };
struct Ui_I_BFu7s { unsigned int v1; int v2; unsigned short v3:7; };
struct Ui_I_BFu8c { unsigned int v1; int v2; unsigned char v3:8; };
struct Ui_I_BFu8i { unsigned int v1; int v2; unsigned int v3:8; };
struct Ui_I_BFu8ll { unsigned int v1; int v2; unsigned long long v3:8; };
struct Ui_I_BFu8s { unsigned int v1; int v2; unsigned short v3:8; };
struct Ui_I_BFu9i { unsigned int v1; int v2; unsigned int v3:9; };
struct Ui_I_BFu9ll { unsigned int v1; int v2; unsigned long long v3:9; };
struct Ui_I_BFu9s { unsigned int v1; int v2; unsigned short v3:9; };
struct Ui_I_C { unsigned int v1; int v2; char v3; };
struct Ui_I_D { unsigned int v1; int v2; double v3; };
struct Ui_I_F { unsigned int v1; int v2; float v3; };
struct Ui_I_I { unsigned int v1; int v2; int v3; };
struct Ui_I_Ip { unsigned int v1; int v2; int * v3; };
struct Ui_I_L { unsigned int v1; int v2; long long v3; };
struct Ui_I_S { unsigned int v1; int v2; short v3; };
struct Ui_I_Uc { unsigned int v1; int v2; unsigned char v3; };
struct Ui_I_Ui { unsigned int v1; int v2; unsigned int v3; };
struct Ui_I_Ul { unsigned int v1; int v2; unsigned long long v3; };
struct Ui_I_Us { unsigned int v1; int v2; unsigned short v3; };
struct Ui_I_Vp { unsigned int v1; int v2; void * v3; };
struct Ui_Ip { unsigned int v1; int * v2; };
struct Ui_Ip_BFu15i { unsigned int v1; int * v2; unsigned int v3:15; };
struct Ui_Ip_BFu15ll { unsigned int v1; int * v2; unsigned long long v3:15; };
struct Ui_Ip_BFu15s { unsigned int v1; int * v2; unsigned short v3:15; };
struct Ui_Ip_BFu16i { unsigned int v1; int * v2; unsigned int v3:16; };
struct Ui_Ip_BFu16ll { unsigned int v1; int * v2; unsigned long long v3:16; };
struct Ui_Ip_BFu16s { unsigned int v1; int * v2; unsigned short v3:16; };
struct Ui_Ip_BFu17i { unsigned int v1; int * v2; unsigned int v3:17; };
struct Ui_Ip_BFu17ll { unsigned int v1; int * v2; unsigned long long v3:17; };
struct Ui_Ip_BFu1c { unsigned int v1; int * v2; unsigned char v3:1; };
struct Ui_Ip_BFu1i { unsigned int v1; int * v2; unsigned int v3:1; };
struct Ui_Ip_BFu1ll { unsigned int v1; int * v2; unsigned long long v3:1; };
struct Ui_Ip_BFu1s { unsigned int v1; int * v2; unsigned short v3:1; };
struct Ui_Ip_BFu31i { unsigned int v1; int * v2; unsigned int v3:31; };
struct Ui_Ip_BFu31ll { unsigned int v1; int * v2; unsigned long long v3:31; };
struct Ui_Ip_BFu32i { unsigned int v1; int * v2; unsigned int v3:32; };
struct Ui_Ip_BFu32ll { unsigned int v1; int * v2; unsigned long long v3:32; };
struct Ui_Ip_BFu33 { unsigned int v1; int * v2; unsigned long long v3:33; };
struct Ui_Ip_BFu7c { unsigned int v1; int * v2; unsigned char v3:7; };
struct Ui_Ip_BFu7i { unsigned int v1; int * v2; unsigned int v3:7; };
struct Ui_Ip_BFu7ll { unsigned int v1; int * v2; unsigned long long v3:7; };
struct Ui_Ip_BFu7s { unsigned int v1; int * v2; unsigned short v3:7; };
struct Ui_Ip_BFu8c { unsigned int v1; int * v2; unsigned char v3:8; };
struct Ui_Ip_BFu8i { unsigned int v1; int * v2; unsigned int v3:8; };
struct Ui_Ip_BFu8ll { unsigned int v1; int * v2; unsigned long long v3:8; };
struct Ui_Ip_BFu8s { unsigned int v1; int * v2; unsigned short v3:8; };
struct Ui_Ip_BFu9i { unsigned int v1; int * v2; unsigned int v3:9; };
struct Ui_Ip_BFu9ll { unsigned int v1; int * v2; unsigned long long v3:9; };
struct Ui_Ip_BFu9s { unsigned int v1; int * v2; unsigned short v3:9; };
struct Ui_Ip_C { unsigned int v1; int * v2; char v3; };
struct Ui_Ip_D { unsigned int v1; int * v2; double v3; };
struct Ui_Ip_F { unsigned int v1; int * v2; float v3; };
struct Ui_Ip_I { unsigned int v1; int * v2; int v3; };
struct Ui_Ip_Ip { unsigned int v1; int * v2; int * v3; };
struct Ui_Ip_L { unsigned int v1; int * v2; long long v3; };
struct Ui_Ip_S { unsigned int v1; int * v2; short v3; };
struct Ui_Ip_Uc { unsigned int v1; int * v2; unsigned char v3; };
struct Ui_Ip_Ui { unsigned int v1; int * v2; unsigned int v3; };
struct Ui_Ip_Ul { unsigned int v1; int * v2; unsigned long long v3; };
struct Ui_Ip_Us { unsigned int v1; int * v2; unsigned short v3; };
struct Ui_Ip_Vp { unsigned int v1; int * v2; void * v3; };
struct Ui_L { unsigned int v1; long long v2; };
struct Ui_L_BFu15i { unsigned int v1; long long v2; unsigned int v3:15; };
struct Ui_L_BFu15ll { unsigned int v1; long long v2; unsigned long long v3:15; };
struct Ui_L_BFu15s { unsigned int v1; long long v2; unsigned short v3:15; };
struct Ui_L_BFu16i { unsigned int v1; long long v2; unsigned int v3:16; };
struct Ui_L_BFu16ll { unsigned int v1; long long v2; unsigned long long v3:16; };
struct Ui_L_BFu16s { unsigned int v1; long long v2; unsigned short v3:16; };
struct Ui_L_BFu17i { unsigned int v1; long long v2; unsigned int v3:17; };
struct Ui_L_BFu17ll { unsigned int v1; long long v2; unsigned long long v3:17; };
struct Ui_L_BFu1c { unsigned int v1; long long v2; unsigned char v3:1; };
struct Ui_L_BFu1i { unsigned int v1; long long v2; unsigned int v3:1; };
struct Ui_L_BFu1ll { unsigned int v1; long long v2; unsigned long long v3:1; };
struct Ui_L_BFu1s { unsigned int v1; long long v2; unsigned short v3:1; };
struct Ui_L_BFu31i { unsigned int v1; long long v2; unsigned int v3:31; };
struct Ui_L_BFu31ll { unsigned int v1; long long v2; unsigned long long v3:31; };
struct Ui_L_BFu32i { unsigned int v1; long long v2; unsigned int v3:32; };
struct Ui_L_BFu32ll { unsigned int v1; long long v2; unsigned long long v3:32; };
struct Ui_L_BFu33 { unsigned int v1; long long v2; unsigned long long v3:33; };
struct Ui_L_BFu7c { unsigned int v1; long long v2; unsigned char v3:7; };
struct Ui_L_BFu7i { unsigned int v1; long long v2; unsigned int v3:7; };
struct Ui_L_BFu7ll { unsigned int v1; long long v2; unsigned long long v3:7; };
struct Ui_L_BFu7s { unsigned int v1; long long v2; unsigned short v3:7; };
struct Ui_L_BFu8c { unsigned int v1; long long v2; unsigned char v3:8; };
struct Ui_L_BFu8i { unsigned int v1; long long v2; unsigned int v3:8; };
struct Ui_L_BFu8ll { unsigned int v1; long long v2; unsigned long long v3:8; };
struct Ui_L_BFu8s { unsigned int v1; long long v2; unsigned short v3:8; };
struct Ui_L_BFu9i { unsigned int v1; long long v2; unsigned int v3:9; };
struct Ui_L_BFu9ll { unsigned int v1; long long v2; unsigned long long v3:9; };
struct Ui_L_BFu9s { unsigned int v1; long long v2; unsigned short v3:9; };
struct Ui_L_C { unsigned int v1; long long v2; char v3; };
struct Ui_L_D { unsigned int v1; long long v2; double v3; };
struct Ui_L_F { unsigned int v1; long long v2; float v3; };
struct Ui_L_I { unsigned int v1; long long v2; int v3; };
struct Ui_L_Ip { unsigned int v1; long long v2; int * v3; };
struct Ui_L_L { unsigned int v1; long long v2; long long v3; };
struct Ui_L_S { unsigned int v1; long long v2; short v3; };
struct Ui_L_Uc { unsigned int v1; long long v2; unsigned char v3; };
struct Ui_L_Ui { unsigned int v1; long long v2; unsigned int v3; };
struct Ui_L_Ul { unsigned int v1; long long v2; unsigned long long v3; };
struct Ui_L_Us { unsigned int v1; long long v2; unsigned short v3; };
struct Ui_L_Vp { unsigned int v1; long long v2; void * v3; };
struct Ui_S { unsigned int v1; short v2; };
struct Ui_S_BFu15i { unsigned int v1; short v2; unsigned int v3:15; };
struct Ui_S_BFu15ll { unsigned int v1; short v2; unsigned long long v3:15; };
struct Ui_S_BFu15s { unsigned int v1; short v2; unsigned short v3:15; };
struct Ui_S_BFu16i { unsigned int v1; short v2; unsigned int v3:16; };
struct Ui_S_BFu16ll { unsigned int v1; short v2; unsigned long long v3:16; };
struct Ui_S_BFu16s { unsigned int v1; short v2; unsigned short v3:16; };
struct Ui_S_BFu17i { unsigned int v1; short v2; unsigned int v3:17; };
struct Ui_S_BFu17ll { unsigned int v1; short v2; unsigned long long v3:17; };
struct Ui_S_BFu1c { unsigned int v1; short v2; unsigned char v3:1; };
struct Ui_S_BFu1i { unsigned int v1; short v2; unsigned int v3:1; };
struct Ui_S_BFu1ll { unsigned int v1; short v2; unsigned long long v3:1; };
struct Ui_S_BFu1s { unsigned int v1; short v2; unsigned short v3:1; };
struct Ui_S_BFu31i { unsigned int v1; short v2; unsigned int v3:31; };
struct Ui_S_BFu31ll { unsigned int v1; short v2; unsigned long long v3:31; };
struct Ui_S_BFu32i { unsigned int v1; short v2; unsigned int v3:32; };
struct Ui_S_BFu32ll { unsigned int v1; short v2; unsigned long long v3:32; };
struct Ui_S_BFu33 { unsigned int v1; short v2; unsigned long long v3:33; };
struct Ui_S_BFu7c { unsigned int v1; short v2; unsigned char v3:7; };
struct Ui_S_BFu7i { unsigned int v1; short v2; unsigned int v3:7; };
struct Ui_S_BFu7ll { unsigned int v1; short v2; unsigned long long v3:7; };
struct Ui_S_BFu7s { unsigned int v1; short v2; unsigned short v3:7; };
struct Ui_S_BFu8c { unsigned int v1; short v2; unsigned char v3:8; };
struct Ui_S_BFu8i { unsigned int v1; short v2; unsigned int v3:8; };
struct Ui_S_BFu8ll { unsigned int v1; short v2; unsigned long long v3:8; };
struct Ui_S_BFu8s { unsigned int v1; short v2; unsigned short v3:8; };
struct Ui_S_BFu9i { unsigned int v1; short v2; unsigned int v3:9; };
struct Ui_S_BFu9ll { unsigned int v1; short v2; unsigned long long v3:9; };
struct Ui_S_BFu9s { unsigned int v1; short v2; unsigned short v3:9; };
struct Ui_S_C { unsigned int v1; short v2; char v3; };
struct Ui_S_D { unsigned int v1; short v2; double v3; };
struct Ui_S_F { unsigned int v1; short v2; float v3; };
struct Ui_S_I { unsigned int v1; short v2; int v3; };
struct Ui_S_Ip { unsigned int v1; short v2; int * v3; };
struct Ui_S_L { unsigned int v1; short v2; long long v3; };
struct Ui_S_S { unsigned int v1; short v2; short v3; };
struct Ui_S_Uc { unsigned int v1; short v2; unsigned char v3; };
struct Ui_S_Ui { unsigned int v1; short v2; unsigned int v3; };
struct Ui_S_Ul { unsigned int v1; short v2; unsigned long long v3; };
struct Ui_S_Us { unsigned int v1; short v2; unsigned short v3; };
struct Ui_S_Vp { unsigned int v1; short v2; void * v3; };
struct Ui_Uc { unsigned int v1; unsigned char v2; };
struct Ui_Uc_BFu15i { unsigned int v1; unsigned char v2; unsigned int v3:15; };
struct Ui_Uc_BFu15ll { unsigned int v1; unsigned char v2; unsigned long long v3:15; };
struct Ui_Uc_BFu15s { unsigned int v1; unsigned char v2; unsigned short v3:15; };
struct Ui_Uc_BFu16i { unsigned int v1; unsigned char v2; unsigned int v3:16; };
struct Ui_Uc_BFu16ll { unsigned int v1; unsigned char v2; unsigned long long v3:16; };
struct Ui_Uc_BFu16s { unsigned int v1; unsigned char v2; unsigned short v3:16; };
struct Ui_Uc_BFu17i { unsigned int v1; unsigned char v2; unsigned int v3:17; };
struct Ui_Uc_BFu17ll { unsigned int v1; unsigned char v2; unsigned long long v3:17; };
struct Ui_Uc_BFu1c { unsigned int v1; unsigned char v2; unsigned char v3:1; };
struct Ui_Uc_BFu1i { unsigned int v1; unsigned char v2; unsigned int v3:1; };
struct Ui_Uc_BFu1ll { unsigned int v1; unsigned char v2; unsigned long long v3:1; };
struct Ui_Uc_BFu1s { unsigned int v1; unsigned char v2; unsigned short v3:1; };
struct Ui_Uc_BFu31i { unsigned int v1; unsigned char v2; unsigned int v3:31; };
struct Ui_Uc_BFu31ll { unsigned int v1; unsigned char v2; unsigned long long v3:31; };
struct Ui_Uc_BFu32i { unsigned int v1; unsigned char v2; unsigned int v3:32; };
struct Ui_Uc_BFu32ll { unsigned int v1; unsigned char v2; unsigned long long v3:32; };
struct Ui_Uc_BFu33 { unsigned int v1; unsigned char v2; unsigned long long v3:33; };
struct Ui_Uc_BFu7c { unsigned int v1; unsigned char v2; unsigned char v3:7; };
struct Ui_Uc_BFu7i { unsigned int v1; unsigned char v2; unsigned int v3:7; };
struct Ui_Uc_BFu7ll { unsigned int v1; unsigned char v2; unsigned long long v3:7; };
struct Ui_Uc_BFu7s { unsigned int v1; unsigned char v2; unsigned short v3:7; };
struct Ui_Uc_BFu8c { unsigned int v1; unsigned char v2; unsigned char v3:8; };
struct Ui_Uc_BFu8i { unsigned int v1; unsigned char v2; unsigned int v3:8; };
struct Ui_Uc_BFu8ll { unsigned int v1; unsigned char v2; unsigned long long v3:8; };
struct Ui_Uc_BFu8s { unsigned int v1; unsigned char v2; unsigned short v3:8; };
struct Ui_Uc_BFu9i { unsigned int v1; unsigned char v2; unsigned int v3:9; };
struct Ui_Uc_BFu9ll { unsigned int v1; unsigned char v2; unsigned long long v3:9; };
struct Ui_Uc_BFu9s { unsigned int v1; unsigned char v2; unsigned short v3:9; };
struct Ui_Uc_C { unsigned int v1; unsigned char v2; char v3; };
struct Ui_Uc_D { unsigned int v1; unsigned char v2; double v3; };
struct Ui_Uc_F { unsigned int v1; unsigned char v2; float v3; };
struct Ui_Uc_I { unsigned int v1; unsigned char v2; int v3; };
struct Ui_Uc_Ip { unsigned int v1; unsigned char v2; int * v3; };
struct Ui_Uc_L { unsigned int v1; unsigned char v2; long long v3; };
struct Ui_Uc_S { unsigned int v1; unsigned char v2; short v3; };
struct Ui_Uc_Uc { unsigned int v1; unsigned char v2; unsigned char v3; };
struct Ui_Uc_Ui { unsigned int v1; unsigned char v2; unsigned int v3; };
struct Ui_Uc_Ul { unsigned int v1; unsigned char v2; unsigned long long v3; };
struct Ui_Uc_Us { unsigned int v1; unsigned char v2; unsigned short v3; };
struct Ui_Uc_Vp { unsigned int v1; unsigned char v2; void * v3; };
struct Ui_Ui { unsigned int v1; unsigned int v2; };
struct Ui_Ui_BFu15i { unsigned int v1; unsigned int v2; unsigned int v3:15; };
struct Ui_Ui_BFu15ll { unsigned int v1; unsigned int v2; unsigned long long v3:15; };
struct Ui_Ui_BFu15s { unsigned int v1; unsigned int v2; unsigned short v3:15; };
struct Ui_Ui_BFu16i { unsigned int v1; unsigned int v2; unsigned int v3:16; };
struct Ui_Ui_BFu16ll { unsigned int v1; unsigned int v2; unsigned long long v3:16; };
struct Ui_Ui_BFu16s { unsigned int v1; unsigned int v2; unsigned short v3:16; };
struct Ui_Ui_BFu17i { unsigned int v1; unsigned int v2; unsigned int v3:17; };
struct Ui_Ui_BFu17ll { unsigned int v1; unsigned int v2; unsigned long long v3:17; };
struct Ui_Ui_BFu1c { unsigned int v1; unsigned int v2; unsigned char v3:1; };
struct Ui_Ui_BFu1i { unsigned int v1; unsigned int v2; unsigned int v3:1; };
struct Ui_Ui_BFu1ll { unsigned int v1; unsigned int v2; unsigned long long v3:1; };
struct Ui_Ui_BFu1s { unsigned int v1; unsigned int v2; unsigned short v3:1; };
struct Ui_Ui_BFu31i { unsigned int v1; unsigned int v2; unsigned int v3:31; };
struct Ui_Ui_BFu31ll { unsigned int v1; unsigned int v2; unsigned long long v3:31; };
struct Ui_Ui_BFu32i { unsigned int v1; unsigned int v2; unsigned int v3:32; };
struct Ui_Ui_BFu32ll { unsigned int v1; unsigned int v2; unsigned long long v3:32; };
struct Ui_Ui_BFu33 { unsigned int v1; unsigned int v2; unsigned long long v3:33; };
struct Ui_Ui_BFu7c { unsigned int v1; unsigned int v2; unsigned char v3:7; };
struct Ui_Ui_BFu7i { unsigned int v1; unsigned int v2; unsigned int v3:7; };
struct Ui_Ui_BFu7ll { unsigned int v1; unsigned int v2; unsigned long long v3:7; };
struct Ui_Ui_BFu7s { unsigned int v1; unsigned int v2; unsigned short v3:7; };
struct Ui_Ui_BFu8c { unsigned int v1; unsigned int v2; unsigned char v3:8; };
struct Ui_Ui_BFu8i { unsigned int v1; unsigned int v2; unsigned int v3:8; };
struct Ui_Ui_BFu8ll { unsigned int v1; unsigned int v2; unsigned long long v3:8; };
struct Ui_Ui_BFu8s { unsigned int v1; unsigned int v2; unsigned short v3:8; };
struct Ui_Ui_BFu9i { unsigned int v1; unsigned int v2; unsigned int v3:9; };
struct Ui_Ui_BFu9ll { unsigned int v1; unsigned int v2; unsigned long long v3:9; };
struct Ui_Ui_BFu9s { unsigned int v1; unsigned int v2; unsigned short v3:9; };
struct Ui_Ui_C { unsigned int v1; unsigned int v2; char v3; };
struct Ui_Ui_D { unsigned int v1; unsigned int v2; double v3; };
struct Ui_Ui_F { unsigned int v1; unsigned int v2; float v3; };
struct Ui_Ui_I { unsigned int v1; unsigned int v2; int v3; };
struct Ui_Ui_Ip { unsigned int v1; unsigned int v2; int * v3; };
struct Ui_Ui_L { unsigned int v1; unsigned int v2; long long v3; };
struct Ui_Ui_S { unsigned int v1; unsigned int v2; short v3; };
struct Ui_Ui_Uc { unsigned int v1; unsigned int v2; unsigned char v3; };
struct Ui_Ui_Ui { unsigned int v1; unsigned int v2; unsigned int v3; };
struct Ui_Ui_Ul { unsigned int v1; unsigned int v2; unsigned long long v3; };
struct Ui_Ui_Us { unsigned int v1; unsigned int v2; unsigned short v3; };
struct Ui_Ui_Vp { unsigned int v1; unsigned int v2; void * v3; };
struct Ui_Ul { unsigned int v1; unsigned long long v2; };
struct Ui_Ul_BFu15i { unsigned int v1; unsigned long long v2; unsigned int v3:15; };
struct Ui_Ul_BFu15ll { unsigned int v1; unsigned long long v2; unsigned long long v3:15; };
struct Ui_Ul_BFu15s { unsigned int v1; unsigned long long v2; unsigned short v3:15; };
struct Ui_Ul_BFu16i { unsigned int v1; unsigned long long v2; unsigned int v3:16; };
struct Ui_Ul_BFu16ll { unsigned int v1; unsigned long long v2; unsigned long long v3:16; };
struct Ui_Ul_BFu16s { unsigned int v1; unsigned long long v2; unsigned short v3:16; };
struct Ui_Ul_BFu17i { unsigned int v1; unsigned long long v2; unsigned int v3:17; };
struct Ui_Ul_BFu17ll { unsigned int v1; unsigned long long v2; unsigned long long v3:17; };
struct Ui_Ul_BFu1c { unsigned int v1; unsigned long long v2; unsigned char v3:1; };
struct Ui_Ul_BFu1i { unsigned int v1; unsigned long long v2; unsigned int v3:1; };
struct Ui_Ul_BFu1ll { unsigned int v1; unsigned long long v2; unsigned long long v3:1; };
struct Ui_Ul_BFu1s { unsigned int v1; unsigned long long v2; unsigned short v3:1; };
struct Ui_Ul_BFu31i { unsigned int v1; unsigned long long v2; unsigned int v3:31; };
struct Ui_Ul_BFu31ll { unsigned int v1; unsigned long long v2; unsigned long long v3:31; };
struct Ui_Ul_BFu32i { unsigned int v1; unsigned long long v2; unsigned int v3:32; };
struct Ui_Ul_BFu32ll { unsigned int v1; unsigned long long v2; unsigned long long v3:32; };
struct Ui_Ul_BFu33 { unsigned int v1; unsigned long long v2; unsigned long long v3:33; };
struct Ui_Ul_BFu7c { unsigned int v1; unsigned long long v2; unsigned char v3:7; };
struct Ui_Ul_BFu7i { unsigned int v1; unsigned long long v2; unsigned int v3:7; };
struct Ui_Ul_BFu7ll { unsigned int v1; unsigned long long v2; unsigned long long v3:7; };
struct Ui_Ul_BFu7s { unsigned int v1; unsigned long long v2; unsigned short v3:7; };
struct Ui_Ul_BFu8c { unsigned int v1; unsigned long long v2; unsigned char v3:8; };
struct Ui_Ul_BFu8i { unsigned int v1; unsigned long long v2; unsigned int v3:8; };
struct Ui_Ul_BFu8ll { unsigned int v1; unsigned long long v2; unsigned long long v3:8; };
struct Ui_Ul_BFu8s { unsigned int v1; unsigned long long v2; unsigned short v3:8; };
struct Ui_Ul_BFu9i { unsigned int v1; unsigned long long v2; unsigned int v3:9; };
struct Ui_Ul_BFu9ll { unsigned int v1; unsigned long long v2; unsigned long long v3:9; };
struct Ui_Ul_BFu9s { unsigned int v1; unsigned long long v2; unsigned short v3:9; };
struct Ui_Ul_C { unsigned int v1; unsigned long long v2; char v3; };
struct Ui_Ul_D { unsigned int v1; unsigned long long v2; double v3; };
struct Ui_Ul_F { unsigned int v1; unsigned long long v2; float v3; };
struct Ui_Ul_I { unsigned int v1; unsigned long long v2; int v3; };
struct Ui_Ul_Ip { unsigned int v1; unsigned long long v2; int * v3; };


static void Test_Uc_BFu16ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu16ll_BFu9s");
    static STRUCT_IF_C Uc_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Uc_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Uc_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_BFu9s, Uc_BFu16ll_BFu9s)
//============================================================================



static void Test_Uc_BFu16ll_C()
{
  {
    init_simple_test("Uc_BFu16ll_C");
    static STRUCT_IF_C Uc_BFu16ll_C lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_C");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_C, Uc_BFu16ll_C)
//============================================================================



static void Test_Uc_BFu16ll_D()
{
  {
    init_simple_test("Uc_BFu16ll_D");
    static STRUCT_IF_C Uc_BFu16ll_D lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_D");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_D, Uc_BFu16ll_D)
//============================================================================



static void Test_Uc_BFu16ll_F()
{
  {
    init_simple_test("Uc_BFu16ll_F");
    static STRUCT_IF_C Uc_BFu16ll_F lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_F");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_F, Uc_BFu16ll_F)
//============================================================================



static void Test_Uc_BFu16ll_I()
{
  {
    init_simple_test("Uc_BFu16ll_I");
    static STRUCT_IF_C Uc_BFu16ll_I lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_I");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_I, Uc_BFu16ll_I)
//============================================================================



static void Test_Uc_BFu16ll_Ip()
{
  {
    init_simple_test("Uc_BFu16ll_Ip");
    static STRUCT_IF_C Uc_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_Ip");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_Ip, Uc_BFu16ll_Ip)
//============================================================================



static void Test_Uc_BFu16ll_L()
{
  {
    init_simple_test("Uc_BFu16ll_L");
    static STRUCT_IF_C Uc_BFu16ll_L lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_L");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_L, Uc_BFu16ll_L)
//============================================================================



static void Test_Uc_BFu16ll_S()
{
  {
    init_simple_test("Uc_BFu16ll_S");
    static STRUCT_IF_C Uc_BFu16ll_S lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_S");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_S, Uc_BFu16ll_S)
//============================================================================



static void Test_Uc_BFu16ll_Uc()
{
  {
    init_simple_test("Uc_BFu16ll_Uc");
    static STRUCT_IF_C Uc_BFu16ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_Uc, Uc_BFu16ll_Uc)
//============================================================================



static void Test_Uc_BFu16ll_Ui()
{
  {
    init_simple_test("Uc_BFu16ll_Ui");
    static STRUCT_IF_C Uc_BFu16ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_Ui");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_Ui, Uc_BFu16ll_Ui)
//============================================================================



static void Test_Uc_BFu16ll_Ul()
{
  {
    init_simple_test("Uc_BFu16ll_Ul");
    static STRUCT_IF_C Uc_BFu16ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_Ul");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_Ul, Uc_BFu16ll_Ul)
//============================================================================



static void Test_Uc_BFu16ll_Us()
{
  {
    init_simple_test("Uc_BFu16ll_Us");
    static STRUCT_IF_C Uc_BFu16ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_Us");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_Us, Uc_BFu16ll_Us)
//============================================================================



static void Test_Uc_BFu16ll_Vp()
{
  {
    init_simple_test("Uc_BFu16ll_Vp");
    static STRUCT_IF_C Uc_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_Vp");
    check_field_offset(lv, v3, 3, "Uc_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16ll_Vp, Uc_BFu16ll_Vp)
//============================================================================



static void Test_Uc_BFu16s()
{
  {
    init_simple_test("Uc_BFu16s");
    static STRUCT_IF_C Uc_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s, Uc_BFu16s)
//============================================================================



static void Test_Uc_BFu16s_BFu15i()
{
  {
    init_simple_test("Uc_BFu16s_BFu15i");
    static STRUCT_IF_C Uc_BFu16s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Uc_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Uc_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu15i, Uc_BFu16s_BFu15i)
//============================================================================



static void Test_Uc_BFu16s_BFu15ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu15ll");
    static STRUCT_IF_C Uc_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Uc_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Uc_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu15ll, Uc_BFu16s_BFu15ll)
//============================================================================



static void Test_Uc_BFu16s_BFu15s()
{
  {
    init_simple_test("Uc_BFu16s_BFu15s");
    static STRUCT_IF_C Uc_BFu16s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Uc_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Uc_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu15s, Uc_BFu16s_BFu15s)
//============================================================================



static void Test_Uc_BFu16s_BFu16i()
{
  {
    init_simple_test("Uc_BFu16s_BFu16i");
    static STRUCT_IF_C Uc_BFu16s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Uc_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu16i, Uc_BFu16s_BFu16i)
//============================================================================



static void Test_Uc_BFu16s_BFu16ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu16ll");
    static STRUCT_IF_C Uc_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Uc_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu16ll, Uc_BFu16s_BFu16ll)
//============================================================================



static void Test_Uc_BFu16s_BFu16s()
{
  {
    init_simple_test("Uc_BFu16s_BFu16s");
    static STRUCT_IF_C Uc_BFu16s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Uc_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu16s, Uc_BFu16s_BFu16s)
//============================================================================



static void Test_Uc_BFu16s_BFu17i()
{
  {
    init_simple_test("Uc_BFu16s_BFu17i");
    static STRUCT_IF_C Uc_BFu16s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "Uc_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "Uc_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu17i, Uc_BFu16s_BFu17i)
//============================================================================



static void Test_Uc_BFu16s_BFu17ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu17ll");
    static STRUCT_IF_C Uc_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "Uc_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "Uc_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu17ll, Uc_BFu16s_BFu17ll)
//============================================================================



static void Test_Uc_BFu16s_BFu1c()
{
  {
    init_simple_test("Uc_BFu16s_BFu1c");
    static STRUCT_IF_C Uc_BFu16s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Uc_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu1c, Uc_BFu16s_BFu1c)
//============================================================================



static void Test_Uc_BFu16s_BFu1i()
{
  {
    init_simple_test("Uc_BFu16s_BFu1i");
    static STRUCT_IF_C Uc_BFu16s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Uc_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu1i, Uc_BFu16s_BFu1i)
//============================================================================



static void Test_Uc_BFu16s_BFu1ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu1ll");
    static STRUCT_IF_C Uc_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Uc_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu1ll, Uc_BFu16s_BFu1ll)
//============================================================================



static void Test_Uc_BFu16s_BFu1s()
{
  {
    init_simple_test("Uc_BFu16s_BFu1s");
    static STRUCT_IF_C Uc_BFu16s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Uc_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu1s, Uc_BFu16s_BFu1s)
//============================================================================



static void Test_Uc_BFu16s_BFu31i()
{
  {
    init_simple_test("Uc_BFu16s_BFu31i");
    static STRUCT_IF_C Uc_BFu16s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "Uc_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "Uc_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu31i, Uc_BFu16s_BFu31i)
//============================================================================



static void Test_Uc_BFu16s_BFu31ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu31ll");
    static STRUCT_IF_C Uc_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "Uc_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "Uc_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu31ll, Uc_BFu16s_BFu31ll)
//============================================================================



static void Test_Uc_BFu16s_BFu32i()
{
  {
    init_simple_test("Uc_BFu16s_BFu32i");
    static STRUCT_IF_C Uc_BFu16s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "Uc_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "Uc_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu32i, Uc_BFu16s_BFu32i)
//============================================================================



static void Test_Uc_BFu16s_BFu32ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu32ll");
    static STRUCT_IF_C Uc_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "Uc_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "Uc_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu32ll, Uc_BFu16s_BFu32ll)
//============================================================================



static void Test_Uc_BFu16s_BFu33()
{
  {
    init_simple_test("Uc_BFu16s_BFu33");
    static STRUCT_IF_C Uc_BFu16s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "Uc_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "Uc_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu33, Uc_BFu16s_BFu33)
//============================================================================



static void Test_Uc_BFu16s_BFu7c()
{
  {
    init_simple_test("Uc_BFu16s_BFu7c");
    static STRUCT_IF_C Uc_BFu16s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Uc_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Uc_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu7c, Uc_BFu16s_BFu7c)
//============================================================================



static void Test_Uc_BFu16s_BFu7i()
{
  {
    init_simple_test("Uc_BFu16s_BFu7i");
    static STRUCT_IF_C Uc_BFu16s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Uc_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Uc_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu7i, Uc_BFu16s_BFu7i)
//============================================================================



static void Test_Uc_BFu16s_BFu7ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu7ll");
    static STRUCT_IF_C Uc_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Uc_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Uc_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu7ll, Uc_BFu16s_BFu7ll)
//============================================================================



static void Test_Uc_BFu16s_BFu7s()
{
  {
    init_simple_test("Uc_BFu16s_BFu7s");
    static STRUCT_IF_C Uc_BFu16s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Uc_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Uc_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu7s, Uc_BFu16s_BFu7s)
//============================================================================



static void Test_Uc_BFu16s_BFu8c()
{
  {
    init_simple_test("Uc_BFu16s_BFu8c");
    static STRUCT_IF_C Uc_BFu16s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Uc_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Uc_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu8c, Uc_BFu16s_BFu8c)
//============================================================================



static void Test_Uc_BFu16s_BFu8i()
{
  {
    init_simple_test("Uc_BFu16s_BFu8i");
    static STRUCT_IF_C Uc_BFu16s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Uc_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Uc_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu8i, Uc_BFu16s_BFu8i)
//============================================================================



static void Test_Uc_BFu16s_BFu8ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu8ll");
    static STRUCT_IF_C Uc_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Uc_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Uc_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu8ll, Uc_BFu16s_BFu8ll)
//============================================================================



static void Test_Uc_BFu16s_BFu8s()
{
  {
    init_simple_test("Uc_BFu16s_BFu8s");
    static STRUCT_IF_C Uc_BFu16s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Uc_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Uc_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu8s, Uc_BFu16s_BFu8s)
//============================================================================



static void Test_Uc_BFu16s_BFu9i()
{
  {
    init_simple_test("Uc_BFu16s_BFu9i");
    static STRUCT_IF_C Uc_BFu16s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Uc_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Uc_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu9i, Uc_BFu16s_BFu9i)
//============================================================================



static void Test_Uc_BFu16s_BFu9ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu9ll");
    static STRUCT_IF_C Uc_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Uc_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Uc_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu9ll, Uc_BFu16s_BFu9ll)
//============================================================================



static void Test_Uc_BFu16s_BFu9s()
{
  {
    init_simple_test("Uc_BFu16s_BFu9s");
    static STRUCT_IF_C Uc_BFu16s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Uc_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Uc_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_BFu9s, Uc_BFu16s_BFu9s)
//============================================================================



static void Test_Uc_BFu16s_C()
{
  {
    init_simple_test("Uc_BFu16s_C");
    static STRUCT_IF_C Uc_BFu16s_C lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_C");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_C, Uc_BFu16s_C)
//============================================================================



static void Test_Uc_BFu16s_D()
{
  {
    init_simple_test("Uc_BFu16s_D");
    static STRUCT_IF_C Uc_BFu16s_D lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_D");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_D, Uc_BFu16s_D)
//============================================================================



static void Test_Uc_BFu16s_F()
{
  {
    init_simple_test("Uc_BFu16s_F");
    static STRUCT_IF_C Uc_BFu16s_F lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_F");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_F, Uc_BFu16s_F)
//============================================================================



static void Test_Uc_BFu16s_I()
{
  {
    init_simple_test("Uc_BFu16s_I");
    static STRUCT_IF_C Uc_BFu16s_I lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_I");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_I, Uc_BFu16s_I)
//============================================================================



static void Test_Uc_BFu16s_Ip()
{
  {
    init_simple_test("Uc_BFu16s_Ip");
    static STRUCT_IF_C Uc_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_Ip");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_Ip, Uc_BFu16s_Ip)
//============================================================================



static void Test_Uc_BFu16s_L()
{
  {
    init_simple_test("Uc_BFu16s_L");
    static STRUCT_IF_C Uc_BFu16s_L lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_L");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_L, Uc_BFu16s_L)
//============================================================================



static void Test_Uc_BFu16s_S()
{
  {
    init_simple_test("Uc_BFu16s_S");
    static STRUCT_IF_C Uc_BFu16s_S lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_S");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_S, Uc_BFu16s_S)
//============================================================================



static void Test_Uc_BFu16s_Uc()
{
  {
    init_simple_test("Uc_BFu16s_Uc");
    static STRUCT_IF_C Uc_BFu16s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_Uc");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_Uc, Uc_BFu16s_Uc)
//============================================================================



static void Test_Uc_BFu16s_Ui()
{
  {
    init_simple_test("Uc_BFu16s_Ui");
    static STRUCT_IF_C Uc_BFu16s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_Ui");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_Ui, Uc_BFu16s_Ui)
//============================================================================



static void Test_Uc_BFu16s_Ul()
{
  {
    init_simple_test("Uc_BFu16s_Ul");
    static STRUCT_IF_C Uc_BFu16s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_Ul");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_Ul, Uc_BFu16s_Ul)
//============================================================================



static void Test_Uc_BFu16s_Us()
{
  {
    init_simple_test("Uc_BFu16s_Us");
    static STRUCT_IF_C Uc_BFu16s_Us lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_Us");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_Us, Uc_BFu16s_Us)
//============================================================================



static void Test_Uc_BFu16s_Vp()
{
  {
    init_simple_test("Uc_BFu16s_Vp");
    static STRUCT_IF_C Uc_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_Vp");
    check_field_offset(lv, v3, 3, "Uc_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu16s_Vp, Uc_BFu16s_Vp)
//============================================================================



static void Test_Uc_BFu17i()
{
  {
    init_simple_test("Uc_BFu17i");
    static STRUCT_IF_C Uc_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i, Uc_BFu17i)
//============================================================================



static void Test_Uc_BFu17i_BFu15i()
{
  {
    init_simple_test("Uc_BFu17i_BFu15i");
    static STRUCT_IF_C Uc_BFu17i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Uc_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Uc_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu15i, Uc_BFu17i_BFu15i)
//============================================================================



static void Test_Uc_BFu17i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu15ll");
    static STRUCT_IF_C Uc_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Uc_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Uc_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu15ll, Uc_BFu17i_BFu15ll)
//============================================================================



static void Test_Uc_BFu17i_BFu15s()
{
  {
    init_simple_test("Uc_BFu17i_BFu15s");
    static STRUCT_IF_C Uc_BFu17i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Uc_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Uc_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu15s, Uc_BFu17i_BFu15s)
//============================================================================



static void Test_Uc_BFu17i_BFu16i()
{
  {
    init_simple_test("Uc_BFu17i_BFu16i");
    static STRUCT_IF_C Uc_BFu17i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Uc_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Uc_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu16i, Uc_BFu17i_BFu16i)
//============================================================================



static void Test_Uc_BFu17i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu16ll");
    static STRUCT_IF_C Uc_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Uc_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Uc_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu16ll, Uc_BFu17i_BFu16ll)
//============================================================================



static void Test_Uc_BFu17i_BFu16s()
{
  {
    init_simple_test("Uc_BFu17i_BFu16s");
    static STRUCT_IF_C Uc_BFu17i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Uc_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Uc_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu16s, Uc_BFu17i_BFu16s)
//============================================================================



static void Test_Uc_BFu17i_BFu17i()
{
  {
    init_simple_test("Uc_BFu17i_BFu17i");
    static STRUCT_IF_C Uc_BFu17i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Uc_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu17i, Uc_BFu17i_BFu17i)
//============================================================================



static void Test_Uc_BFu17i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu17ll");
    static STRUCT_IF_C Uc_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Uc_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu17ll, Uc_BFu17i_BFu17ll)
//============================================================================



static void Test_Uc_BFu17i_BFu1c()
{
  {
    init_simple_test("Uc_BFu17i_BFu1c");
    static STRUCT_IF_C Uc_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu1c, Uc_BFu17i_BFu1c)
//============================================================================



static void Test_Uc_BFu17i_BFu1i()
{
  {
    init_simple_test("Uc_BFu17i_BFu1i");
    static STRUCT_IF_C Uc_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu1i, Uc_BFu17i_BFu1i)
//============================================================================



static void Test_Uc_BFu17i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu1ll");
    static STRUCT_IF_C Uc_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu1ll, Uc_BFu17i_BFu1ll)
//============================================================================



static void Test_Uc_BFu17i_BFu1s()
{
  {
    init_simple_test("Uc_BFu17i_BFu1s");
    static STRUCT_IF_C Uc_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu1s, Uc_BFu17i_BFu1s)
//============================================================================



static void Test_Uc_BFu17i_BFu31i()
{
  {
    init_simple_test("Uc_BFu17i_BFu31i");
    static STRUCT_IF_C Uc_BFu17i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Uc_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Uc_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu31i, Uc_BFu17i_BFu31i)
//============================================================================



static void Test_Uc_BFu17i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu31ll");
    static STRUCT_IF_C Uc_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Uc_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Uc_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu31ll, Uc_BFu17i_BFu31ll)
//============================================================================



static void Test_Uc_BFu17i_BFu32i()
{
  {
    init_simple_test("Uc_BFu17i_BFu32i");
    static STRUCT_IF_C Uc_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Uc_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Uc_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu32i, Uc_BFu17i_BFu32i)
//============================================================================



static void Test_Uc_BFu17i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu32ll");
    static STRUCT_IF_C Uc_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Uc_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Uc_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu32ll, Uc_BFu17i_BFu32ll)
//============================================================================



static void Test_Uc_BFu17i_BFu33()
{
  {
    init_simple_test("Uc_BFu17i_BFu33");
    static STRUCT_IF_C Uc_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "Uc_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "Uc_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu33, Uc_BFu17i_BFu33)
//============================================================================



static void Test_Uc_BFu17i_BFu7c()
{
  {
    init_simple_test("Uc_BFu17i_BFu7c");
    static STRUCT_IF_C Uc_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu7c, Uc_BFu17i_BFu7c)
//============================================================================



static void Test_Uc_BFu17i_BFu7i()
{
  {
    init_simple_test("Uc_BFu17i_BFu7i");
    static STRUCT_IF_C Uc_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu7i, Uc_BFu17i_BFu7i)
//============================================================================



static void Test_Uc_BFu17i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu7ll");
    static STRUCT_IF_C Uc_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu7ll, Uc_BFu17i_BFu7ll)
//============================================================================



static void Test_Uc_BFu17i_BFu7s()
{
  {
    init_simple_test("Uc_BFu17i_BFu7s");
    static STRUCT_IF_C Uc_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu7s, Uc_BFu17i_BFu7s)
//============================================================================



static void Test_Uc_BFu17i_BFu8c()
{
  {
    init_simple_test("Uc_BFu17i_BFu8c");
    static STRUCT_IF_C Uc_BFu17i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu8c, Uc_BFu17i_BFu8c)
//============================================================================



static void Test_Uc_BFu17i_BFu8i()
{
  {
    init_simple_test("Uc_BFu17i_BFu8i");
    static STRUCT_IF_C Uc_BFu17i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu8i, Uc_BFu17i_BFu8i)
//============================================================================



static void Test_Uc_BFu17i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu8ll");
    static STRUCT_IF_C Uc_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu8ll, Uc_BFu17i_BFu8ll)
//============================================================================



static void Test_Uc_BFu17i_BFu8s()
{
  {
    init_simple_test("Uc_BFu17i_BFu8s");
    static STRUCT_IF_C Uc_BFu17i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu8s, Uc_BFu17i_BFu8s)
//============================================================================



static void Test_Uc_BFu17i_BFu9i()
{
  {
    init_simple_test("Uc_BFu17i_BFu9i");
    static STRUCT_IF_C Uc_BFu17i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Uc_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Uc_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu9i, Uc_BFu17i_BFu9i)
//============================================================================



static void Test_Uc_BFu17i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu9ll");
    static STRUCT_IF_C Uc_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Uc_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Uc_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu9ll, Uc_BFu17i_BFu9ll)
//============================================================================



static void Test_Uc_BFu17i_BFu9s()
{
  {
    init_simple_test("Uc_BFu17i_BFu9s");
    static STRUCT_IF_C Uc_BFu17i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Uc_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Uc_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_BFu9s, Uc_BFu17i_BFu9s)
//============================================================================



static void Test_Uc_BFu17i_C()
{
  {
    init_simple_test("Uc_BFu17i_C");
    static STRUCT_IF_C Uc_BFu17i_C lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_C");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_C, Uc_BFu17i_C)
//============================================================================



static void Test_Uc_BFu17i_D()
{
  {
    init_simple_test("Uc_BFu17i_D");
    static STRUCT_IF_C Uc_BFu17i_D lv;
    check2(sizeof(lv), 12, "sizeof(Uc_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_D");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_D, Uc_BFu17i_D)
//============================================================================



static void Test_Uc_BFu17i_F()
{
  {
    init_simple_test("Uc_BFu17i_F");
    static STRUCT_IF_C Uc_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_F");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_F, Uc_BFu17i_F)
//============================================================================



static void Test_Uc_BFu17i_I()
{
  {
    init_simple_test("Uc_BFu17i_I");
    static STRUCT_IF_C Uc_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_I");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_I, Uc_BFu17i_I)
//============================================================================



static void Test_Uc_BFu17i_Ip()
{
  {
    init_simple_test("Uc_BFu17i_Ip");
    static STRUCT_IF_C Uc_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_Ip");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_Ip, Uc_BFu17i_Ip)
//============================================================================



static void Test_Uc_BFu17i_L()
{
  {
    init_simple_test("Uc_BFu17i_L");
    static STRUCT_IF_C Uc_BFu17i_L lv;
    check2(sizeof(lv), 12, "sizeof(Uc_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_L");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_L, Uc_BFu17i_L)
//============================================================================



static void Test_Uc_BFu17i_S()
{
  {
    init_simple_test("Uc_BFu17i_S");
    static STRUCT_IF_C Uc_BFu17i_S lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_S");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_S, Uc_BFu17i_S)
//============================================================================



static void Test_Uc_BFu17i_Uc()
{
  {
    init_simple_test("Uc_BFu17i_Uc");
    static STRUCT_IF_C Uc_BFu17i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_Uc, Uc_BFu17i_Uc)
//============================================================================



static void Test_Uc_BFu17i_Ui()
{
  {
    init_simple_test("Uc_BFu17i_Ui");
    static STRUCT_IF_C Uc_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_Ui, Uc_BFu17i_Ui)
//============================================================================



static void Test_Uc_BFu17i_Ul()
{
  {
    init_simple_test("Uc_BFu17i_Ul");
    static STRUCT_IF_C Uc_BFu17i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(Uc_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_Ul");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_Ul, Uc_BFu17i_Ul)
//============================================================================



static void Test_Uc_BFu17i_Us()
{
  {
    init_simple_test("Uc_BFu17i_Us");
    static STRUCT_IF_C Uc_BFu17i_Us lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_Us");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_Us, Uc_BFu17i_Us)
//============================================================================



static void Test_Uc_BFu17i_Vp()
{
  {
    init_simple_test("Uc_BFu17i_Vp");
    static STRUCT_IF_C Uc_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_Vp");
    check_field_offset(lv, v3, 4, "Uc_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17i_Vp, Uc_BFu17i_Vp)
//============================================================================



static void Test_Uc_BFu17ll()
{
  {
    init_simple_test("Uc_BFu17ll");
    static STRUCT_IF_C Uc_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll, Uc_BFu17ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu15i");
    static STRUCT_IF_C Uc_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Uc_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Uc_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu15i, Uc_BFu17ll_BFu15i)
//============================================================================



static void Test_Uc_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Uc_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Uc_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu15ll, Uc_BFu17ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu15s");
    static STRUCT_IF_C Uc_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Uc_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Uc_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu15s, Uc_BFu17ll_BFu15s)
//============================================================================



static void Test_Uc_BFu17ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu16i");
    static STRUCT_IF_C Uc_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Uc_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Uc_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu16i, Uc_BFu17ll_BFu16i)
//============================================================================



static void Test_Uc_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Uc_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Uc_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu16ll, Uc_BFu17ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu16s");
    static STRUCT_IF_C Uc_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Uc_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Uc_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu16s, Uc_BFu17ll_BFu16s)
//============================================================================



static void Test_Uc_BFu17ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu17i");
    static STRUCT_IF_C Uc_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Uc_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu17i, Uc_BFu17ll_BFu17i)
//============================================================================



static void Test_Uc_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Uc_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu17ll, Uc_BFu17ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu17ll_BFu1c");
    static STRUCT_IF_C Uc_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu1c, Uc_BFu17ll_BFu1c)
//============================================================================



static void Test_Uc_BFu17ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu1i");
    static STRUCT_IF_C Uc_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu1i, Uc_BFu17ll_BFu1i)
//============================================================================



static void Test_Uc_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu1ll, Uc_BFu17ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu1s");
    static STRUCT_IF_C Uc_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Uc_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu1s, Uc_BFu17ll_BFu1s)
//============================================================================



static void Test_Uc_BFu17ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu31i");
    static STRUCT_IF_C Uc_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Uc_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Uc_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu31i, Uc_BFu17ll_BFu31i)
//============================================================================



static void Test_Uc_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Uc_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Uc_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu31ll, Uc_BFu17ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu32i");
    static STRUCT_IF_C Uc_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Uc_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Uc_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu32i, Uc_BFu17ll_BFu32i)
//============================================================================



static void Test_Uc_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Uc_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Uc_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu32ll, Uc_BFu17ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu33()
{
  {
    init_simple_test("Uc_BFu17ll_BFu33");
    static STRUCT_IF_C Uc_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "Uc_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "Uc_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu33, Uc_BFu17ll_BFu33)
//============================================================================



static void Test_Uc_BFu17ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu17ll_BFu7c");
    static STRUCT_IF_C Uc_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu7c, Uc_BFu17ll_BFu7c)
//============================================================================



static void Test_Uc_BFu17ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu7i");
    static STRUCT_IF_C Uc_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu7i, Uc_BFu17ll_BFu7i)
//============================================================================



static void Test_Uc_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu7ll, Uc_BFu17ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu7s");
    static STRUCT_IF_C Uc_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Uc_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Uc_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu7s, Uc_BFu17ll_BFu7s)
//============================================================================



static void Test_Uc_BFu17ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu17ll_BFu8c");
    static STRUCT_IF_C Uc_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu8c, Uc_BFu17ll_BFu8c)
//============================================================================



static void Test_Uc_BFu17ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu8i");
    static STRUCT_IF_C Uc_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu8i, Uc_BFu17ll_BFu8i)
//============================================================================



static void Test_Uc_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu8ll, Uc_BFu17ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu8s");
    static STRUCT_IF_C Uc_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Uc_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Uc_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu8s, Uc_BFu17ll_BFu8s)
//============================================================================



static void Test_Uc_BFu17ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu9i");
    static STRUCT_IF_C Uc_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Uc_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Uc_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu9i, Uc_BFu17ll_BFu9i)
//============================================================================



static void Test_Uc_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Uc_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Uc_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu9ll, Uc_BFu17ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu17ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu9s");
    static STRUCT_IF_C Uc_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Uc_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Uc_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_BFu9s, Uc_BFu17ll_BFu9s)
//============================================================================



static void Test_Uc_BFu17ll_C()
{
  {
    init_simple_test("Uc_BFu17ll_C");
    static STRUCT_IF_C Uc_BFu17ll_C lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_C");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_C, Uc_BFu17ll_C)
//============================================================================



static void Test_Uc_BFu17ll_D()
{
  {
    init_simple_test("Uc_BFu17ll_D");
    static STRUCT_IF_C Uc_BFu17ll_D lv;
    check2(sizeof(lv), 12, "sizeof(Uc_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_D");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_D, Uc_BFu17ll_D)
//============================================================================



static void Test_Uc_BFu17ll_F()
{
  {
    init_simple_test("Uc_BFu17ll_F");
    static STRUCT_IF_C Uc_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_F");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_F, Uc_BFu17ll_F)
//============================================================================



static void Test_Uc_BFu17ll_I()
{
  {
    init_simple_test("Uc_BFu17ll_I");
    static STRUCT_IF_C Uc_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_I");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_I, Uc_BFu17ll_I)
//============================================================================



static void Test_Uc_BFu17ll_Ip()
{
  {
    init_simple_test("Uc_BFu17ll_Ip");
    static STRUCT_IF_C Uc_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_Ip");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_Ip, Uc_BFu17ll_Ip)
//============================================================================



static void Test_Uc_BFu17ll_L()
{
  {
    init_simple_test("Uc_BFu17ll_L");
    static STRUCT_IF_C Uc_BFu17ll_L lv;
    check2(sizeof(lv), 12, "sizeof(Uc_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_L");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_L, Uc_BFu17ll_L)
//============================================================================



static void Test_Uc_BFu17ll_S()
{
  {
    init_simple_test("Uc_BFu17ll_S");
    static STRUCT_IF_C Uc_BFu17ll_S lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_S");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_S, Uc_BFu17ll_S)
//============================================================================



static void Test_Uc_BFu17ll_Uc()
{
  {
    init_simple_test("Uc_BFu17ll_Uc");
    static STRUCT_IF_C Uc_BFu17ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_Uc, Uc_BFu17ll_Uc)
//============================================================================



static void Test_Uc_BFu17ll_Ui()
{
  {
    init_simple_test("Uc_BFu17ll_Ui");
    static STRUCT_IF_C Uc_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_Ui, Uc_BFu17ll_Ui)
//============================================================================



static void Test_Uc_BFu17ll_Ul()
{
  {
    init_simple_test("Uc_BFu17ll_Ul");
    static STRUCT_IF_C Uc_BFu17ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(Uc_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_Ul");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_Ul, Uc_BFu17ll_Ul)
//============================================================================



static void Test_Uc_BFu17ll_Us()
{
  {
    init_simple_test("Uc_BFu17ll_Us");
    static STRUCT_IF_C Uc_BFu17ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_Us, Uc_BFu17ll_Us)
//============================================================================



static void Test_Uc_BFu17ll_Vp()
{
  {
    init_simple_test("Uc_BFu17ll_Vp");
    static STRUCT_IF_C Uc_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_Vp");
    check_field_offset(lv, v3, 4, "Uc_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu17ll_Vp, Uc_BFu17ll_Vp)
//============================================================================



static void Test_Uc_BFu1c()
{
  {
    init_simple_test("Uc_BFu1c");
    static STRUCT_IF_C Uc_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c, Uc_BFu1c)
//============================================================================



static void Test_Uc_BFu1c_BFu15i()
{
  {
    init_simple_test("Uc_BFu1c_BFu15i");
    static STRUCT_IF_C Uc_BFu1c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu15i, Uc_BFu1c_BFu15i)
//============================================================================



static void Test_Uc_BFu1c_BFu15ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu15ll");
    static STRUCT_IF_C Uc_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu15ll, Uc_BFu1c_BFu15ll)
//============================================================================



static void Test_Uc_BFu1c_BFu15s()
{
  {
    init_simple_test("Uc_BFu1c_BFu15s");
    static STRUCT_IF_C Uc_BFu1c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu15s, Uc_BFu1c_BFu15s)
//============================================================================



static void Test_Uc_BFu1c_BFu16i()
{
  {
    init_simple_test("Uc_BFu1c_BFu16i");
    static STRUCT_IF_C Uc_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu16i, Uc_BFu1c_BFu16i)
//============================================================================



static void Test_Uc_BFu1c_BFu16ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu16ll");
    static STRUCT_IF_C Uc_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu16ll, Uc_BFu1c_BFu16ll)
//============================================================================



static void Test_Uc_BFu1c_BFu16s()
{
  {
    init_simple_test("Uc_BFu1c_BFu16s");
    static STRUCT_IF_C Uc_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu16s, Uc_BFu1c_BFu16s)
//============================================================================



static void Test_Uc_BFu1c_BFu17i()
{
  {
    init_simple_test("Uc_BFu1c_BFu17i");
    static STRUCT_IF_C Uc_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu17i, Uc_BFu1c_BFu17i)
//============================================================================



static void Test_Uc_BFu1c_BFu17ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu17ll");
    static STRUCT_IF_C Uc_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu17ll, Uc_BFu1c_BFu17ll)
//============================================================================



static void Test_Uc_BFu1c_BFu1c()
{
  {
    init_simple_test("Uc_BFu1c_BFu1c");
    static STRUCT_IF_C Uc_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu1c, Uc_BFu1c_BFu1c)
//============================================================================



static void Test_Uc_BFu1c_BFu1i()
{
  {
    init_simple_test("Uc_BFu1c_BFu1i");
    static STRUCT_IF_C Uc_BFu1c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu1i, Uc_BFu1c_BFu1i)
//============================================================================



static void Test_Uc_BFu1c_BFu1ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu1ll");
    static STRUCT_IF_C Uc_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu1ll, Uc_BFu1c_BFu1ll)
//============================================================================



static void Test_Uc_BFu1c_BFu1s()
{
  {
    init_simple_test("Uc_BFu1c_BFu1s");
    static STRUCT_IF_C Uc_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu1s, Uc_BFu1c_BFu1s)
//============================================================================



static void Test_Uc_BFu1c_BFu31i()
{
  {
    init_simple_test("Uc_BFu1c_BFu31i");
    static STRUCT_IF_C Uc_BFu1c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu31i, Uc_BFu1c_BFu31i)
//============================================================================



static void Test_Uc_BFu1c_BFu31ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu31ll");
    static STRUCT_IF_C Uc_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu31ll, Uc_BFu1c_BFu31ll)
//============================================================================



static void Test_Uc_BFu1c_BFu32i()
{
  {
    init_simple_test("Uc_BFu1c_BFu32i");
    static STRUCT_IF_C Uc_BFu1c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu32i, Uc_BFu1c_BFu32i)
//============================================================================



static void Test_Uc_BFu1c_BFu32ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu32ll");
    static STRUCT_IF_C Uc_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu32ll, Uc_BFu1c_BFu32ll)
//============================================================================



static void Test_Uc_BFu1c_BFu33()
{
  {
    init_simple_test("Uc_BFu1c_BFu33");
    static STRUCT_IF_C Uc_BFu1c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Uc_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Uc_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu33, Uc_BFu1c_BFu33)
//============================================================================



static void Test_Uc_BFu1c_BFu7c()
{
  {
    init_simple_test("Uc_BFu1c_BFu7c");
    static STRUCT_IF_C Uc_BFu1c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu7c, Uc_BFu1c_BFu7c)
//============================================================================



static void Test_Uc_BFu1c_BFu7i()
{
  {
    init_simple_test("Uc_BFu1c_BFu7i");
    static STRUCT_IF_C Uc_BFu1c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu7i, Uc_BFu1c_BFu7i)
//============================================================================



static void Test_Uc_BFu1c_BFu7ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu7ll");
    static STRUCT_IF_C Uc_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu7ll, Uc_BFu1c_BFu7ll)
//============================================================================



static void Test_Uc_BFu1c_BFu7s()
{
  {
    init_simple_test("Uc_BFu1c_BFu7s");
    static STRUCT_IF_C Uc_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu7s, Uc_BFu1c_BFu7s)
//============================================================================



static void Test_Uc_BFu1c_BFu8c()
{
  {
    init_simple_test("Uc_BFu1c_BFu8c");
    static STRUCT_IF_C Uc_BFu1c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu8c, Uc_BFu1c_BFu8c)
//============================================================================



static void Test_Uc_BFu1c_BFu8i()
{
  {
    init_simple_test("Uc_BFu1c_BFu8i");
    static STRUCT_IF_C Uc_BFu1c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu8i, Uc_BFu1c_BFu8i)
//============================================================================



static void Test_Uc_BFu1c_BFu8ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu8ll");
    static STRUCT_IF_C Uc_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu8ll, Uc_BFu1c_BFu8ll)
//============================================================================



static void Test_Uc_BFu1c_BFu8s()
{
  {
    init_simple_test("Uc_BFu1c_BFu8s");
    static STRUCT_IF_C Uc_BFu1c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu8s, Uc_BFu1c_BFu8s)
//============================================================================



static void Test_Uc_BFu1c_BFu9i()
{
  {
    init_simple_test("Uc_BFu1c_BFu9i");
    static STRUCT_IF_C Uc_BFu1c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu9i, Uc_BFu1c_BFu9i)
//============================================================================



static void Test_Uc_BFu1c_BFu9ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu9ll");
    static STRUCT_IF_C Uc_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu9ll, Uc_BFu1c_BFu9ll)
//============================================================================



static void Test_Uc_BFu1c_BFu9s()
{
  {
    init_simple_test("Uc_BFu1c_BFu9s");
    static STRUCT_IF_C Uc_BFu1c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_BFu9s, Uc_BFu1c_BFu9s)
//============================================================================



static void Test_Uc_BFu1c_C()
{
  {
    init_simple_test("Uc_BFu1c_C");
    static STRUCT_IF_C Uc_BFu1c_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_C");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_C, Uc_BFu1c_C)
//============================================================================



static void Test_Uc_BFu1c_D()
{
  {
    init_simple_test("Uc_BFu1c_D");
    static STRUCT_IF_C Uc_BFu1c_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_D");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_D, Uc_BFu1c_D)
//============================================================================



static void Test_Uc_BFu1c_F()
{
  {
    init_simple_test("Uc_BFu1c_F");
    static STRUCT_IF_C Uc_BFu1c_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_F");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_F, Uc_BFu1c_F)
//============================================================================



static void Test_Uc_BFu1c_I()
{
  {
    init_simple_test("Uc_BFu1c_I");
    static STRUCT_IF_C Uc_BFu1c_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_I");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_I, Uc_BFu1c_I)
//============================================================================



static void Test_Uc_BFu1c_Ip()
{
  {
    init_simple_test("Uc_BFu1c_Ip");
    static STRUCT_IF_C Uc_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_Ip, Uc_BFu1c_Ip)
//============================================================================



static void Test_Uc_BFu1c_L()
{
  {
    init_simple_test("Uc_BFu1c_L");
    static STRUCT_IF_C Uc_BFu1c_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_L");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_L, Uc_BFu1c_L)
//============================================================================



static void Test_Uc_BFu1c_S()
{
  {
    init_simple_test("Uc_BFu1c_S");
    static STRUCT_IF_C Uc_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_S");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_S, Uc_BFu1c_S)
//============================================================================



static void Test_Uc_BFu1c_Uc()
{
  {
    init_simple_test("Uc_BFu1c_Uc");
    static STRUCT_IF_C Uc_BFu1c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_Uc, Uc_BFu1c_Uc)
//============================================================================



static void Test_Uc_BFu1c_Ui()
{
  {
    init_simple_test("Uc_BFu1c_Ui");
    static STRUCT_IF_C Uc_BFu1c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_Ui, Uc_BFu1c_Ui)
//============================================================================



static void Test_Uc_BFu1c_Ul()
{
  {
    init_simple_test("Uc_BFu1c_Ul");
    static STRUCT_IF_C Uc_BFu1c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_Ul, Uc_BFu1c_Ul)
//============================================================================



static void Test_Uc_BFu1c_Us()
{
  {
    init_simple_test("Uc_BFu1c_Us");
    static STRUCT_IF_C Uc_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_Us, Uc_BFu1c_Us)
//============================================================================



static void Test_Uc_BFu1c_Vp()
{
  {
    init_simple_test("Uc_BFu1c_Vp");
    static STRUCT_IF_C Uc_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1c_Vp, Uc_BFu1c_Vp)
//============================================================================



static void Test_Uc_BFu1i()
{
  {
    init_simple_test("Uc_BFu1i");
    static STRUCT_IF_C Uc_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i, Uc_BFu1i)
//============================================================================



static void Test_Uc_BFu1i_BFu15i()
{
  {
    init_simple_test("Uc_BFu1i_BFu15i");
    static STRUCT_IF_C Uc_BFu1i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu15i, Uc_BFu1i_BFu15i)
//============================================================================



static void Test_Uc_BFu1i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu15ll");
    static STRUCT_IF_C Uc_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu15ll, Uc_BFu1i_BFu15ll)
//============================================================================



static void Test_Uc_BFu1i_BFu15s()
{
  {
    init_simple_test("Uc_BFu1i_BFu15s");
    static STRUCT_IF_C Uc_BFu1i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu15s, Uc_BFu1i_BFu15s)
//============================================================================



static void Test_Uc_BFu1i_BFu16i()
{
  {
    init_simple_test("Uc_BFu1i_BFu16i");
    static STRUCT_IF_C Uc_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu16i, Uc_BFu1i_BFu16i)
//============================================================================



static void Test_Uc_BFu1i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu16ll");
    static STRUCT_IF_C Uc_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu16ll, Uc_BFu1i_BFu16ll)
//============================================================================



static void Test_Uc_BFu1i_BFu16s()
{
  {
    init_simple_test("Uc_BFu1i_BFu16s");
    static STRUCT_IF_C Uc_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu16s, Uc_BFu1i_BFu16s)
//============================================================================



static void Test_Uc_BFu1i_BFu17i()
{
  {
    init_simple_test("Uc_BFu1i_BFu17i");
    static STRUCT_IF_C Uc_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu17i, Uc_BFu1i_BFu17i)
//============================================================================



static void Test_Uc_BFu1i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu17ll");
    static STRUCT_IF_C Uc_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu17ll, Uc_BFu1i_BFu17ll)
//============================================================================



static void Test_Uc_BFu1i_BFu1c()
{
  {
    init_simple_test("Uc_BFu1i_BFu1c");
    static STRUCT_IF_C Uc_BFu1i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu1c, Uc_BFu1i_BFu1c)
//============================================================================



static void Test_Uc_BFu1i_BFu1i()
{
  {
    init_simple_test("Uc_BFu1i_BFu1i");
    static STRUCT_IF_C Uc_BFu1i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu1i, Uc_BFu1i_BFu1i)
//============================================================================



static void Test_Uc_BFu1i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu1ll");
    static STRUCT_IF_C Uc_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu1ll, Uc_BFu1i_BFu1ll)
//============================================================================



static void Test_Uc_BFu1i_BFu1s()
{
  {
    init_simple_test("Uc_BFu1i_BFu1s");
    static STRUCT_IF_C Uc_BFu1i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu1s, Uc_BFu1i_BFu1s)
//============================================================================



static void Test_Uc_BFu1i_BFu31i()
{
  {
    init_simple_test("Uc_BFu1i_BFu31i");
    static STRUCT_IF_C Uc_BFu1i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu31i, Uc_BFu1i_BFu31i)
//============================================================================



static void Test_Uc_BFu1i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu31ll");
    static STRUCT_IF_C Uc_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu31ll, Uc_BFu1i_BFu31ll)
//============================================================================



static void Test_Uc_BFu1i_BFu32i()
{
  {
    init_simple_test("Uc_BFu1i_BFu32i");
    static STRUCT_IF_C Uc_BFu1i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu32i, Uc_BFu1i_BFu32i)
//============================================================================



static void Test_Uc_BFu1i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu32ll");
    static STRUCT_IF_C Uc_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu32ll, Uc_BFu1i_BFu32ll)
//============================================================================



static void Test_Uc_BFu1i_BFu33()
{
  {
    init_simple_test("Uc_BFu1i_BFu33");
    static STRUCT_IF_C Uc_BFu1i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Uc_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Uc_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu33, Uc_BFu1i_BFu33)
//============================================================================



static void Test_Uc_BFu1i_BFu7c()
{
  {
    init_simple_test("Uc_BFu1i_BFu7c");
    static STRUCT_IF_C Uc_BFu1i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu7c, Uc_BFu1i_BFu7c)
//============================================================================



static void Test_Uc_BFu1i_BFu7i()
{
  {
    init_simple_test("Uc_BFu1i_BFu7i");
    static STRUCT_IF_C Uc_BFu1i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu7i, Uc_BFu1i_BFu7i)
//============================================================================



static void Test_Uc_BFu1i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu7ll");
    static STRUCT_IF_C Uc_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu7ll, Uc_BFu1i_BFu7ll)
//============================================================================



static void Test_Uc_BFu1i_BFu7s()
{
  {
    init_simple_test("Uc_BFu1i_BFu7s");
    static STRUCT_IF_C Uc_BFu1i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu7s, Uc_BFu1i_BFu7s)
//============================================================================



static void Test_Uc_BFu1i_BFu8c()
{
  {
    init_simple_test("Uc_BFu1i_BFu8c");
    static STRUCT_IF_C Uc_BFu1i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu8c, Uc_BFu1i_BFu8c)
//============================================================================



static void Test_Uc_BFu1i_BFu8i()
{
  {
    init_simple_test("Uc_BFu1i_BFu8i");
    static STRUCT_IF_C Uc_BFu1i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu8i, Uc_BFu1i_BFu8i)
//============================================================================



static void Test_Uc_BFu1i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu8ll");
    static STRUCT_IF_C Uc_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu8ll, Uc_BFu1i_BFu8ll)
//============================================================================



static void Test_Uc_BFu1i_BFu8s()
{
  {
    init_simple_test("Uc_BFu1i_BFu8s");
    static STRUCT_IF_C Uc_BFu1i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu8s, Uc_BFu1i_BFu8s)
//============================================================================



static void Test_Uc_BFu1i_BFu9i()
{
  {
    init_simple_test("Uc_BFu1i_BFu9i");
    static STRUCT_IF_C Uc_BFu1i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu9i, Uc_BFu1i_BFu9i)
//============================================================================



static void Test_Uc_BFu1i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu9ll");
    static STRUCT_IF_C Uc_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu9ll, Uc_BFu1i_BFu9ll)
//============================================================================



static void Test_Uc_BFu1i_BFu9s()
{
  {
    init_simple_test("Uc_BFu1i_BFu9s");
    static STRUCT_IF_C Uc_BFu1i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_BFu9s, Uc_BFu1i_BFu9s)
//============================================================================



static void Test_Uc_BFu1i_C()
{
  {
    init_simple_test("Uc_BFu1i_C");
    static STRUCT_IF_C Uc_BFu1i_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_C");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_C, Uc_BFu1i_C)
//============================================================================



static void Test_Uc_BFu1i_D()
{
  {
    init_simple_test("Uc_BFu1i_D");
    static STRUCT_IF_C Uc_BFu1i_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_D");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_D, Uc_BFu1i_D)
//============================================================================



static void Test_Uc_BFu1i_F()
{
  {
    init_simple_test("Uc_BFu1i_F");
    static STRUCT_IF_C Uc_BFu1i_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_F");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_F, Uc_BFu1i_F)
//============================================================================



static void Test_Uc_BFu1i_I()
{
  {
    init_simple_test("Uc_BFu1i_I");
    static STRUCT_IF_C Uc_BFu1i_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_I");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_I, Uc_BFu1i_I)
//============================================================================



static void Test_Uc_BFu1i_Ip()
{
  {
    init_simple_test("Uc_BFu1i_Ip");
    static STRUCT_IF_C Uc_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_Ip, Uc_BFu1i_Ip)
//============================================================================



static void Test_Uc_BFu1i_L()
{
  {
    init_simple_test("Uc_BFu1i_L");
    static STRUCT_IF_C Uc_BFu1i_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_L");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_L, Uc_BFu1i_L)
//============================================================================



static void Test_Uc_BFu1i_S()
{
  {
    init_simple_test("Uc_BFu1i_S");
    static STRUCT_IF_C Uc_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_S");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_S, Uc_BFu1i_S)
//============================================================================



static void Test_Uc_BFu1i_Uc()
{
  {
    init_simple_test("Uc_BFu1i_Uc");
    static STRUCT_IF_C Uc_BFu1i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_Uc, Uc_BFu1i_Uc)
//============================================================================



static void Test_Uc_BFu1i_Ui()
{
  {
    init_simple_test("Uc_BFu1i_Ui");
    static STRUCT_IF_C Uc_BFu1i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_Ui, Uc_BFu1i_Ui)
//============================================================================



static void Test_Uc_BFu1i_Ul()
{
  {
    init_simple_test("Uc_BFu1i_Ul");
    static STRUCT_IF_C Uc_BFu1i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_Ul, Uc_BFu1i_Ul)
//============================================================================



static void Test_Uc_BFu1i_Us()
{
  {
    init_simple_test("Uc_BFu1i_Us");
    static STRUCT_IF_C Uc_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_Us, Uc_BFu1i_Us)
//============================================================================



static void Test_Uc_BFu1i_Vp()
{
  {
    init_simple_test("Uc_BFu1i_Vp");
    static STRUCT_IF_C Uc_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1i_Vp, Uc_BFu1i_Vp)
//============================================================================



static void Test_Uc_BFu1ll()
{
  {
    init_simple_test("Uc_BFu1ll");
    static STRUCT_IF_C Uc_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll, Uc_BFu1ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu15i");
    static STRUCT_IF_C Uc_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu15i, Uc_BFu1ll_BFu15i)
//============================================================================



static void Test_Uc_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu15ll, Uc_BFu1ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu15s");
    static STRUCT_IF_C Uc_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu15s, Uc_BFu1ll_BFu15s)
//============================================================================



static void Test_Uc_BFu1ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu16i");
    static STRUCT_IF_C Uc_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu16i, Uc_BFu1ll_BFu16i)
//============================================================================



static void Test_Uc_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu16ll, Uc_BFu1ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu16s");
    static STRUCT_IF_C Uc_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu16s, Uc_BFu1ll_BFu16s)
//============================================================================



static void Test_Uc_BFu1ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu17i");
    static STRUCT_IF_C Uc_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu17i, Uc_BFu1ll_BFu17i)
//============================================================================



static void Test_Uc_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu17ll, Uc_BFu1ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu1ll_BFu1c");
    static STRUCT_IF_C Uc_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu1c, Uc_BFu1ll_BFu1c)
//============================================================================



static void Test_Uc_BFu1ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu1i");
    static STRUCT_IF_C Uc_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu1i, Uc_BFu1ll_BFu1i)
//============================================================================



static void Test_Uc_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu1ll, Uc_BFu1ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu1s");
    static STRUCT_IF_C Uc_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu1s, Uc_BFu1ll_BFu1s)
//============================================================================



static void Test_Uc_BFu1ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu31i");
    static STRUCT_IF_C Uc_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu31i, Uc_BFu1ll_BFu31i)
//============================================================================



static void Test_Uc_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu31ll, Uc_BFu1ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu32i");
    static STRUCT_IF_C Uc_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu32i, Uc_BFu1ll_BFu32i)
//============================================================================



static void Test_Uc_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu32ll, Uc_BFu1ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu33()
{
  {
    init_simple_test("Uc_BFu1ll_BFu33");
    static STRUCT_IF_C Uc_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Uc_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Uc_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu33, Uc_BFu1ll_BFu33)
//============================================================================



static void Test_Uc_BFu1ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu1ll_BFu7c");
    static STRUCT_IF_C Uc_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu7c, Uc_BFu1ll_BFu7c)
//============================================================================



static void Test_Uc_BFu1ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu7i");
    static STRUCT_IF_C Uc_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu7i, Uc_BFu1ll_BFu7i)
//============================================================================



static void Test_Uc_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu7ll, Uc_BFu1ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu7s");
    static STRUCT_IF_C Uc_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu7s, Uc_BFu1ll_BFu7s)
//============================================================================



static void Test_Uc_BFu1ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu1ll_BFu8c");
    static STRUCT_IF_C Uc_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu8c, Uc_BFu1ll_BFu8c)
//============================================================================



static void Test_Uc_BFu1ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu8i");
    static STRUCT_IF_C Uc_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu8i, Uc_BFu1ll_BFu8i)
//============================================================================



static void Test_Uc_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu8ll, Uc_BFu1ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu8s");
    static STRUCT_IF_C Uc_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu8s, Uc_BFu1ll_BFu8s)
//============================================================================



static void Test_Uc_BFu1ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu9i");
    static STRUCT_IF_C Uc_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu9i, Uc_BFu1ll_BFu9i)
//============================================================================



static void Test_Uc_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu9ll, Uc_BFu1ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu1ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu9s");
    static STRUCT_IF_C Uc_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_BFu9s, Uc_BFu1ll_BFu9s)
//============================================================================



static void Test_Uc_BFu1ll_C()
{
  {
    init_simple_test("Uc_BFu1ll_C");
    static STRUCT_IF_C Uc_BFu1ll_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_C");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_C, Uc_BFu1ll_C)
//============================================================================



static void Test_Uc_BFu1ll_D()
{
  {
    init_simple_test("Uc_BFu1ll_D");
    static STRUCT_IF_C Uc_BFu1ll_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_D");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_D, Uc_BFu1ll_D)
//============================================================================



static void Test_Uc_BFu1ll_F()
{
  {
    init_simple_test("Uc_BFu1ll_F");
    static STRUCT_IF_C Uc_BFu1ll_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_F");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_F, Uc_BFu1ll_F)
//============================================================================



static void Test_Uc_BFu1ll_I()
{
  {
    init_simple_test("Uc_BFu1ll_I");
    static STRUCT_IF_C Uc_BFu1ll_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_I");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_I, Uc_BFu1ll_I)
//============================================================================



static void Test_Uc_BFu1ll_Ip()
{
  {
    init_simple_test("Uc_BFu1ll_Ip");
    static STRUCT_IF_C Uc_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_Ip, Uc_BFu1ll_Ip)
//============================================================================



static void Test_Uc_BFu1ll_L()
{
  {
    init_simple_test("Uc_BFu1ll_L");
    static STRUCT_IF_C Uc_BFu1ll_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_L");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_L, Uc_BFu1ll_L)
//============================================================================



static void Test_Uc_BFu1ll_S()
{
  {
    init_simple_test("Uc_BFu1ll_S");
    static STRUCT_IF_C Uc_BFu1ll_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_S");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_S, Uc_BFu1ll_S)
//============================================================================



static void Test_Uc_BFu1ll_Uc()
{
  {
    init_simple_test("Uc_BFu1ll_Uc");
    static STRUCT_IF_C Uc_BFu1ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_Uc, Uc_BFu1ll_Uc)
//============================================================================



static void Test_Uc_BFu1ll_Ui()
{
  {
    init_simple_test("Uc_BFu1ll_Ui");
    static STRUCT_IF_C Uc_BFu1ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_Ui, Uc_BFu1ll_Ui)
//============================================================================



static void Test_Uc_BFu1ll_Ul()
{
  {
    init_simple_test("Uc_BFu1ll_Ul");
    static STRUCT_IF_C Uc_BFu1ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_Ul, Uc_BFu1ll_Ul)
//============================================================================



static void Test_Uc_BFu1ll_Us()
{
  {
    init_simple_test("Uc_BFu1ll_Us");
    static STRUCT_IF_C Uc_BFu1ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_Us, Uc_BFu1ll_Us)
//============================================================================



static void Test_Uc_BFu1ll_Vp()
{
  {
    init_simple_test("Uc_BFu1ll_Vp");
    static STRUCT_IF_C Uc_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1ll_Vp, Uc_BFu1ll_Vp)
//============================================================================



static void Test_Uc_BFu1s()
{
  {
    init_simple_test("Uc_BFu1s");
    static STRUCT_IF_C Uc_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s, Uc_BFu1s)
//============================================================================



static void Test_Uc_BFu1s_BFu15i()
{
  {
    init_simple_test("Uc_BFu1s_BFu15i");
    static STRUCT_IF_C Uc_BFu1s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu15i, Uc_BFu1s_BFu15i)
//============================================================================



static void Test_Uc_BFu1s_BFu15ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu15ll");
    static STRUCT_IF_C Uc_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu15ll, Uc_BFu1s_BFu15ll)
//============================================================================



static void Test_Uc_BFu1s_BFu15s()
{
  {
    init_simple_test("Uc_BFu1s_BFu15s");
    static STRUCT_IF_C Uc_BFu1s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Uc_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Uc_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu15s, Uc_BFu1s_BFu15s)
//============================================================================



static void Test_Uc_BFu1s_BFu16i()
{
  {
    init_simple_test("Uc_BFu1s_BFu16i");
    static STRUCT_IF_C Uc_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu16i, Uc_BFu1s_BFu16i)
//============================================================================



static void Test_Uc_BFu1s_BFu16ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu16ll");
    static STRUCT_IF_C Uc_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu16ll, Uc_BFu1s_BFu16ll)
//============================================================================



static void Test_Uc_BFu1s_BFu16s()
{
  {
    init_simple_test("Uc_BFu1s_BFu16s");
    static STRUCT_IF_C Uc_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Uc_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Uc_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu16s, Uc_BFu1s_BFu16s)
//============================================================================



static void Test_Uc_BFu1s_BFu17i()
{
  {
    init_simple_test("Uc_BFu1s_BFu17i");
    static STRUCT_IF_C Uc_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu17i, Uc_BFu1s_BFu17i)
//============================================================================



static void Test_Uc_BFu1s_BFu17ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu17ll");
    static STRUCT_IF_C Uc_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Uc_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Uc_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu17ll, Uc_BFu1s_BFu17ll)
//============================================================================



static void Test_Uc_BFu1s_BFu1c()
{
  {
    init_simple_test("Uc_BFu1s_BFu1c");
    static STRUCT_IF_C Uc_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu1c, Uc_BFu1s_BFu1c)
//============================================================================



static void Test_Uc_BFu1s_BFu1i()
{
  {
    init_simple_test("Uc_BFu1s_BFu1i");
    static STRUCT_IF_C Uc_BFu1s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu1i, Uc_BFu1s_BFu1i)
//============================================================================



static void Test_Uc_BFu1s_BFu1ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu1ll");
    static STRUCT_IF_C Uc_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu1ll, Uc_BFu1s_BFu1ll)
//============================================================================



static void Test_Uc_BFu1s_BFu1s()
{
  {
    init_simple_test("Uc_BFu1s_BFu1s");
    static STRUCT_IF_C Uc_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Uc_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu1s, Uc_BFu1s_BFu1s)
//============================================================================



static void Test_Uc_BFu1s_BFu31i()
{
  {
    init_simple_test("Uc_BFu1s_BFu31i");
    static STRUCT_IF_C Uc_BFu1s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu31i, Uc_BFu1s_BFu31i)
//============================================================================



static void Test_Uc_BFu1s_BFu31ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu31ll");
    static STRUCT_IF_C Uc_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Uc_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Uc_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu31ll, Uc_BFu1s_BFu31ll)
//============================================================================



static void Test_Uc_BFu1s_BFu32i()
{
  {
    init_simple_test("Uc_BFu1s_BFu32i");
    static STRUCT_IF_C Uc_BFu1s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu32i, Uc_BFu1s_BFu32i)
//============================================================================



static void Test_Uc_BFu1s_BFu32ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu32ll");
    static STRUCT_IF_C Uc_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Uc_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Uc_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu32ll, Uc_BFu1s_BFu32ll)
//============================================================================



static void Test_Uc_BFu1s_BFu33()
{
  {
    init_simple_test("Uc_BFu1s_BFu33");
    static STRUCT_IF_C Uc_BFu1s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Uc_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Uc_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu33, Uc_BFu1s_BFu33)
//============================================================================



static void Test_Uc_BFu1s_BFu7c()
{
  {
    init_simple_test("Uc_BFu1s_BFu7c");
    static STRUCT_IF_C Uc_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu7c, Uc_BFu1s_BFu7c)
//============================================================================



static void Test_Uc_BFu1s_BFu7i()
{
  {
    init_simple_test("Uc_BFu1s_BFu7i");
    static STRUCT_IF_C Uc_BFu1s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu7i, Uc_BFu1s_BFu7i)
//============================================================================



static void Test_Uc_BFu1s_BFu7ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu7ll");
    static STRUCT_IF_C Uc_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu7ll, Uc_BFu1s_BFu7ll)
//============================================================================



static void Test_Uc_BFu1s_BFu7s()
{
  {
    init_simple_test("Uc_BFu1s_BFu7s");
    static STRUCT_IF_C Uc_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Uc_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Uc_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu7s, Uc_BFu1s_BFu7s)
//============================================================================



static void Test_Uc_BFu1s_BFu8c()
{
  {
    init_simple_test("Uc_BFu1s_BFu8c");
    static STRUCT_IF_C Uc_BFu1s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu8c, Uc_BFu1s_BFu8c)
//============================================================================



static void Test_Uc_BFu1s_BFu8i()
{
  {
    init_simple_test("Uc_BFu1s_BFu8i");
    static STRUCT_IF_C Uc_BFu1s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu8i, Uc_BFu1s_BFu8i)
//============================================================================



static void Test_Uc_BFu1s_BFu8ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu8ll");
    static STRUCT_IF_C Uc_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu8ll, Uc_BFu1s_BFu8ll)
//============================================================================



static void Test_Uc_BFu1s_BFu8s()
{
  {
    init_simple_test("Uc_BFu1s_BFu8s");
    static STRUCT_IF_C Uc_BFu1s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Uc_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Uc_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu8s, Uc_BFu1s_BFu8s)
//============================================================================



static void Test_Uc_BFu1s_BFu9i()
{
  {
    init_simple_test("Uc_BFu1s_BFu9i");
    static STRUCT_IF_C Uc_BFu1s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu9i, Uc_BFu1s_BFu9i)
//============================================================================



static void Test_Uc_BFu1s_BFu9ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu9ll");
    static STRUCT_IF_C Uc_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu9ll, Uc_BFu1s_BFu9ll)
//============================================================================



static void Test_Uc_BFu1s_BFu9s()
{
  {
    init_simple_test("Uc_BFu1s_BFu9s");
    static STRUCT_IF_C Uc_BFu1s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Uc_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Uc_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_BFu9s, Uc_BFu1s_BFu9s)
//============================================================================



static void Test_Uc_BFu1s_C()
{
  {
    init_simple_test("Uc_BFu1s_C");
    static STRUCT_IF_C Uc_BFu1s_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_C");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_C, Uc_BFu1s_C)
//============================================================================



static void Test_Uc_BFu1s_D()
{
  {
    init_simple_test("Uc_BFu1s_D");
    static STRUCT_IF_C Uc_BFu1s_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_D");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_D, Uc_BFu1s_D)
//============================================================================



static void Test_Uc_BFu1s_F()
{
  {
    init_simple_test("Uc_BFu1s_F");
    static STRUCT_IF_C Uc_BFu1s_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_F");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_F, Uc_BFu1s_F)
//============================================================================



static void Test_Uc_BFu1s_I()
{
  {
    init_simple_test("Uc_BFu1s_I");
    static STRUCT_IF_C Uc_BFu1s_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_I");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_I, Uc_BFu1s_I)
//============================================================================



static void Test_Uc_BFu1s_Ip()
{
  {
    init_simple_test("Uc_BFu1s_Ip");
    static STRUCT_IF_C Uc_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_Ip, Uc_BFu1s_Ip)
//============================================================================



static void Test_Uc_BFu1s_L()
{
  {
    init_simple_test("Uc_BFu1s_L");
    static STRUCT_IF_C Uc_BFu1s_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_L");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_L, Uc_BFu1s_L)
//============================================================================



static void Test_Uc_BFu1s_S()
{
  {
    init_simple_test("Uc_BFu1s_S");
    static STRUCT_IF_C Uc_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_S");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_S, Uc_BFu1s_S)
//============================================================================



static void Test_Uc_BFu1s_Uc()
{
  {
    init_simple_test("Uc_BFu1s_Uc");
    static STRUCT_IF_C Uc_BFu1s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_Uc, Uc_BFu1s_Uc)
//============================================================================



static void Test_Uc_BFu1s_Ui()
{
  {
    init_simple_test("Uc_BFu1s_Ui");
    static STRUCT_IF_C Uc_BFu1s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_Ui, Uc_BFu1s_Ui)
//============================================================================



static void Test_Uc_BFu1s_Ul()
{
  {
    init_simple_test("Uc_BFu1s_Ul");
    static STRUCT_IF_C Uc_BFu1s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_Ul, Uc_BFu1s_Ul)
//============================================================================



static void Test_Uc_BFu1s_Us()
{
  {
    init_simple_test("Uc_BFu1s_Us");
    static STRUCT_IF_C Uc_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_Us, Uc_BFu1s_Us)
//============================================================================



static void Test_Uc_BFu1s_Vp()
{
  {
    init_simple_test("Uc_BFu1s_Vp");
    static STRUCT_IF_C Uc_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu1s_Vp, Uc_BFu1s_Vp)
//============================================================================



static void Test_Uc_BFu31i()
{
  {
    init_simple_test("Uc_BFu31i");
    static STRUCT_IF_C Uc_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i, Uc_BFu31i)
//============================================================================



static void Test_Uc_BFu31i_BFu15i()
{
  {
    init_simple_test("Uc_BFu31i_BFu15i");
    static STRUCT_IF_C Uc_BFu31i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Uc_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Uc_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu15i, Uc_BFu31i_BFu15i)
//============================================================================



static void Test_Uc_BFu31i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu15ll");
    static STRUCT_IF_C Uc_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Uc_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Uc_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu15ll, Uc_BFu31i_BFu15ll)
//============================================================================



static void Test_Uc_BFu31i_BFu15s()
{
  {
    init_simple_test("Uc_BFu31i_BFu15s");
    static STRUCT_IF_C Uc_BFu31i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Uc_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Uc_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu15s, Uc_BFu31i_BFu15s)
//============================================================================



static void Test_Uc_BFu31i_BFu16i()
{
  {
    init_simple_test("Uc_BFu31i_BFu16i");
    static STRUCT_IF_C Uc_BFu31i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Uc_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Uc_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu16i, Uc_BFu31i_BFu16i)
//============================================================================



static void Test_Uc_BFu31i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu16ll");
    static STRUCT_IF_C Uc_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Uc_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Uc_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu16ll, Uc_BFu31i_BFu16ll)
//============================================================================



static void Test_Uc_BFu31i_BFu16s()
{
  {
    init_simple_test("Uc_BFu31i_BFu16s");
    static STRUCT_IF_C Uc_BFu31i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Uc_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Uc_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu16s, Uc_BFu31i_BFu16s)
//============================================================================



static void Test_Uc_BFu31i_BFu17i()
{
  {
    init_simple_test("Uc_BFu31i_BFu17i");
    static STRUCT_IF_C Uc_BFu31i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Uc_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Uc_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu17i, Uc_BFu31i_BFu17i)
//============================================================================



static void Test_Uc_BFu31i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu17ll");
    static STRUCT_IF_C Uc_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Uc_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Uc_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu17ll, Uc_BFu31i_BFu17ll)
//============================================================================



static void Test_Uc_BFu31i_BFu1c()
{
  {
    init_simple_test("Uc_BFu31i_BFu1c");
    static STRUCT_IF_C Uc_BFu31i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu1c, Uc_BFu31i_BFu1c)
//============================================================================



static void Test_Uc_BFu31i_BFu1i()
{
  {
    init_simple_test("Uc_BFu31i_BFu1i");
    static STRUCT_IF_C Uc_BFu31i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu1i, Uc_BFu31i_BFu1i)
//============================================================================



static void Test_Uc_BFu31i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu1ll");
    static STRUCT_IF_C Uc_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu1ll, Uc_BFu31i_BFu1ll)
//============================================================================



static void Test_Uc_BFu31i_BFu1s()
{
  {
    init_simple_test("Uc_BFu31i_BFu1s");
    static STRUCT_IF_C Uc_BFu31i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu1s, Uc_BFu31i_BFu1s)
//============================================================================



static void Test_Uc_BFu31i_BFu31i()
{
  {
    init_simple_test("Uc_BFu31i_BFu31i");
    static STRUCT_IF_C Uc_BFu31i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "Uc_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu31i, Uc_BFu31i_BFu31i)
//============================================================================



static void Test_Uc_BFu31i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu31ll");
    static STRUCT_IF_C Uc_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "Uc_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu31ll, Uc_BFu31i_BFu31ll)
//============================================================================



static void Test_Uc_BFu31i_BFu32i()
{
  {
    init_simple_test("Uc_BFu31i_BFu32i");
    static STRUCT_IF_C Uc_BFu31i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "Uc_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "Uc_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu32i, Uc_BFu31i_BFu32i)
//============================================================================



static void Test_Uc_BFu31i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu32ll");
    static STRUCT_IF_C Uc_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "Uc_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "Uc_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu32ll, Uc_BFu31i_BFu32ll)
//============================================================================



static void Test_Uc_BFu31i_BFu33()
{
  {
    init_simple_test("Uc_BFu31i_BFu33");
    static STRUCT_IF_C Uc_BFu31i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "Uc_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "Uc_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu33, Uc_BFu31i_BFu33)
//============================================================================



static void Test_Uc_BFu31i_BFu7c()
{
  {
    init_simple_test("Uc_BFu31i_BFu7c");
    static STRUCT_IF_C Uc_BFu31i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu7c, Uc_BFu31i_BFu7c)
//============================================================================



static void Test_Uc_BFu31i_BFu7i()
{
  {
    init_simple_test("Uc_BFu31i_BFu7i");
    static STRUCT_IF_C Uc_BFu31i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu7i, Uc_BFu31i_BFu7i)
//============================================================================



static void Test_Uc_BFu31i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu7ll");
    static STRUCT_IF_C Uc_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu7ll, Uc_BFu31i_BFu7ll)
//============================================================================



static void Test_Uc_BFu31i_BFu7s()
{
  {
    init_simple_test("Uc_BFu31i_BFu7s");
    static STRUCT_IF_C Uc_BFu31i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu7s, Uc_BFu31i_BFu7s)
//============================================================================



static void Test_Uc_BFu31i_BFu8c()
{
  {
    init_simple_test("Uc_BFu31i_BFu8c");
    static STRUCT_IF_C Uc_BFu31i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu8c, Uc_BFu31i_BFu8c)
//============================================================================



static void Test_Uc_BFu31i_BFu8i()
{
  {
    init_simple_test("Uc_BFu31i_BFu8i");
    static STRUCT_IF_C Uc_BFu31i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu8i, Uc_BFu31i_BFu8i)
//============================================================================



static void Test_Uc_BFu31i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu8ll");
    static STRUCT_IF_C Uc_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu8ll, Uc_BFu31i_BFu8ll)
//============================================================================



static void Test_Uc_BFu31i_BFu8s()
{
  {
    init_simple_test("Uc_BFu31i_BFu8s");
    static STRUCT_IF_C Uc_BFu31i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu8s, Uc_BFu31i_BFu8s)
//============================================================================



static void Test_Uc_BFu31i_BFu9i()
{
  {
    init_simple_test("Uc_BFu31i_BFu9i");
    static STRUCT_IF_C Uc_BFu31i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Uc_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Uc_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu9i, Uc_BFu31i_BFu9i)
//============================================================================



static void Test_Uc_BFu31i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu9ll");
    static STRUCT_IF_C Uc_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Uc_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Uc_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu9ll, Uc_BFu31i_BFu9ll)
//============================================================================



static void Test_Uc_BFu31i_BFu9s()
{
  {
    init_simple_test("Uc_BFu31i_BFu9s");
    static STRUCT_IF_C Uc_BFu31i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Uc_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Uc_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_BFu9s, Uc_BFu31i_BFu9s)
//============================================================================



static void Test_Uc_BFu31i_C()
{
  {
    init_simple_test("Uc_BFu31i_C");
    static STRUCT_IF_C Uc_BFu31i_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_C");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_C, Uc_BFu31i_C)
//============================================================================



static void Test_Uc_BFu31i_D()
{
  {
    init_simple_test("Uc_BFu31i_D");
    static STRUCT_IF_C Uc_BFu31i_D lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_D");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_D, Uc_BFu31i_D)
//============================================================================



static void Test_Uc_BFu31i_F()
{
  {
    init_simple_test("Uc_BFu31i_F");
    static STRUCT_IF_C Uc_BFu31i_F lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_F");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_F, Uc_BFu31i_F)
//============================================================================



static void Test_Uc_BFu31i_I()
{
  {
    init_simple_test("Uc_BFu31i_I");
    static STRUCT_IF_C Uc_BFu31i_I lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_I");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_I, Uc_BFu31i_I)
//============================================================================



static void Test_Uc_BFu31i_Ip()
{
  {
    init_simple_test("Uc_BFu31i_Ip");
    static STRUCT_IF_C Uc_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_Ip");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_Ip, Uc_BFu31i_Ip)
//============================================================================



static void Test_Uc_BFu31i_L()
{
  {
    init_simple_test("Uc_BFu31i_L");
    static STRUCT_IF_C Uc_BFu31i_L lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_L");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_L, Uc_BFu31i_L)
//============================================================================



static void Test_Uc_BFu31i_S()
{
  {
    init_simple_test("Uc_BFu31i_S");
    static STRUCT_IF_C Uc_BFu31i_S lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_S");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_S, Uc_BFu31i_S)
//============================================================================



static void Test_Uc_BFu31i_Uc()
{
  {
    init_simple_test("Uc_BFu31i_Uc");
    static STRUCT_IF_C Uc_BFu31i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_Uc");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_Uc, Uc_BFu31i_Uc)
//============================================================================



static void Test_Uc_BFu31i_Ui()
{
  {
    init_simple_test("Uc_BFu31i_Ui");
    static STRUCT_IF_C Uc_BFu31i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_Ui");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_Ui, Uc_BFu31i_Ui)
//============================================================================



static void Test_Uc_BFu31i_Ul()
{
  {
    init_simple_test("Uc_BFu31i_Ul");
    static STRUCT_IF_C Uc_BFu31i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_Ul");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_Ul, Uc_BFu31i_Ul)
//============================================================================



static void Test_Uc_BFu31i_Us()
{
  {
    init_simple_test("Uc_BFu31i_Us");
    static STRUCT_IF_C Uc_BFu31i_Us lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_Us");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_Us, Uc_BFu31i_Us)
//============================================================================



static void Test_Uc_BFu31i_Vp()
{
  {
    init_simple_test("Uc_BFu31i_Vp");
    static STRUCT_IF_C Uc_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_Vp");
    check_field_offset(lv, v3, 5, "Uc_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31i_Vp, Uc_BFu31i_Vp)
//============================================================================



static void Test_Uc_BFu31ll()
{
  {
    init_simple_test("Uc_BFu31ll");
    static STRUCT_IF_C Uc_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll, Uc_BFu31ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu15i");
    static STRUCT_IF_C Uc_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Uc_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Uc_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu15i, Uc_BFu31ll_BFu15i)
//============================================================================



static void Test_Uc_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Uc_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Uc_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu15ll, Uc_BFu31ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu15s");
    static STRUCT_IF_C Uc_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Uc_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Uc_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu15s, Uc_BFu31ll_BFu15s)
//============================================================================



static void Test_Uc_BFu31ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu16i");
    static STRUCT_IF_C Uc_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Uc_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Uc_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu16i, Uc_BFu31ll_BFu16i)
//============================================================================



static void Test_Uc_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Uc_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Uc_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu16ll, Uc_BFu31ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu16s");
    static STRUCT_IF_C Uc_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Uc_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Uc_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu16s, Uc_BFu31ll_BFu16s)
//============================================================================



static void Test_Uc_BFu31ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu17i");
    static STRUCT_IF_C Uc_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Uc_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Uc_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu17i, Uc_BFu31ll_BFu17i)
//============================================================================



static void Test_Uc_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Uc_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Uc_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu17ll, Uc_BFu31ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu31ll_BFu1c");
    static STRUCT_IF_C Uc_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu1c, Uc_BFu31ll_BFu1c)
//============================================================================



static void Test_Uc_BFu31ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu1i");
    static STRUCT_IF_C Uc_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu1i, Uc_BFu31ll_BFu1i)
//============================================================================



static void Test_Uc_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu1ll, Uc_BFu31ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu1s");
    static STRUCT_IF_C Uc_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Uc_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu1s, Uc_BFu31ll_BFu1s)
//============================================================================



static void Test_Uc_BFu31ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu31i");
    static STRUCT_IF_C Uc_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "Uc_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu31i, Uc_BFu31ll_BFu31i)
//============================================================================



static void Test_Uc_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "Uc_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu31ll, Uc_BFu31ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu32i");
    static STRUCT_IF_C Uc_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "Uc_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "Uc_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu32i, Uc_BFu31ll_BFu32i)
//============================================================================



static void Test_Uc_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "Uc_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "Uc_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu32ll, Uc_BFu31ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu33()
{
  {
    init_simple_test("Uc_BFu31ll_BFu33");
    static STRUCT_IF_C Uc_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "Uc_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "Uc_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu33, Uc_BFu31ll_BFu33)
//============================================================================



static void Test_Uc_BFu31ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu31ll_BFu7c");
    static STRUCT_IF_C Uc_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu7c, Uc_BFu31ll_BFu7c)
//============================================================================



static void Test_Uc_BFu31ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu7i");
    static STRUCT_IF_C Uc_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu7i, Uc_BFu31ll_BFu7i)
//============================================================================



static void Test_Uc_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu7ll, Uc_BFu31ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu7s");
    static STRUCT_IF_C Uc_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Uc_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Uc_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu7s, Uc_BFu31ll_BFu7s)
//============================================================================



static void Test_Uc_BFu31ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu31ll_BFu8c");
    static STRUCT_IF_C Uc_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu8c, Uc_BFu31ll_BFu8c)
//============================================================================



static void Test_Uc_BFu31ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu8i");
    static STRUCT_IF_C Uc_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu8i, Uc_BFu31ll_BFu8i)
//============================================================================



static void Test_Uc_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu8ll, Uc_BFu31ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu8s");
    static STRUCT_IF_C Uc_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Uc_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Uc_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu8s, Uc_BFu31ll_BFu8s)
//============================================================================



static void Test_Uc_BFu31ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu9i");
    static STRUCT_IF_C Uc_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Uc_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Uc_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu9i, Uc_BFu31ll_BFu9i)
//============================================================================



static void Test_Uc_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Uc_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Uc_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu9ll, Uc_BFu31ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu31ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu9s");
    static STRUCT_IF_C Uc_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Uc_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Uc_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_BFu9s, Uc_BFu31ll_BFu9s)
//============================================================================



static void Test_Uc_BFu31ll_C()
{
  {
    init_simple_test("Uc_BFu31ll_C");
    static STRUCT_IF_C Uc_BFu31ll_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_C");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_C, Uc_BFu31ll_C)
//============================================================================



static void Test_Uc_BFu31ll_D()
{
  {
    init_simple_test("Uc_BFu31ll_D");
    static STRUCT_IF_C Uc_BFu31ll_D lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_D");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_D, Uc_BFu31ll_D)
//============================================================================



static void Test_Uc_BFu31ll_F()
{
  {
    init_simple_test("Uc_BFu31ll_F");
    static STRUCT_IF_C Uc_BFu31ll_F lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_F");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_F, Uc_BFu31ll_F)
//============================================================================



static void Test_Uc_BFu31ll_I()
{
  {
    init_simple_test("Uc_BFu31ll_I");
    static STRUCT_IF_C Uc_BFu31ll_I lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_I");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_I, Uc_BFu31ll_I)
//============================================================================



static void Test_Uc_BFu31ll_Ip()
{
  {
    init_simple_test("Uc_BFu31ll_Ip");
    static STRUCT_IF_C Uc_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_Ip");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_Ip, Uc_BFu31ll_Ip)
//============================================================================



static void Test_Uc_BFu31ll_L()
{
  {
    init_simple_test("Uc_BFu31ll_L");
    static STRUCT_IF_C Uc_BFu31ll_L lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_L");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_L, Uc_BFu31ll_L)
//============================================================================



static void Test_Uc_BFu31ll_S()
{
  {
    init_simple_test("Uc_BFu31ll_S");
    static STRUCT_IF_C Uc_BFu31ll_S lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_S");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_S, Uc_BFu31ll_S)
//============================================================================



static void Test_Uc_BFu31ll_Uc()
{
  {
    init_simple_test("Uc_BFu31ll_Uc");
    static STRUCT_IF_C Uc_BFu31ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_Uc");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_Uc, Uc_BFu31ll_Uc)
//============================================================================



static void Test_Uc_BFu31ll_Ui()
{
  {
    init_simple_test("Uc_BFu31ll_Ui");
    static STRUCT_IF_C Uc_BFu31ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_Ui");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_Ui, Uc_BFu31ll_Ui)
//============================================================================



static void Test_Uc_BFu31ll_Ul()
{
  {
    init_simple_test("Uc_BFu31ll_Ul");
    static STRUCT_IF_C Uc_BFu31ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_Ul");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_Ul, Uc_BFu31ll_Ul)
//============================================================================



static void Test_Uc_BFu31ll_Us()
{
  {
    init_simple_test("Uc_BFu31ll_Us");
    static STRUCT_IF_C Uc_BFu31ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_Us");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_Us, Uc_BFu31ll_Us)
//============================================================================



static void Test_Uc_BFu31ll_Vp()
{
  {
    init_simple_test("Uc_BFu31ll_Vp");
    static STRUCT_IF_C Uc_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_Vp");
    check_field_offset(lv, v3, 5, "Uc_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu31ll_Vp, Uc_BFu31ll_Vp)
//============================================================================



static void Test_Uc_BFu32i()
{
  {
    init_simple_test("Uc_BFu32i");
    static STRUCT_IF_C Uc_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i, Uc_BFu32i)
//============================================================================



static void Test_Uc_BFu32i_BFu15i()
{
  {
    init_simple_test("Uc_BFu32i_BFu15i");
    static STRUCT_IF_C Uc_BFu32i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu15i, Uc_BFu32i_BFu15i)
//============================================================================



static void Test_Uc_BFu32i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu15ll");
    static STRUCT_IF_C Uc_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu15ll, Uc_BFu32i_BFu15ll)
//============================================================================



static void Test_Uc_BFu32i_BFu15s()
{
  {
    init_simple_test("Uc_BFu32i_BFu15s");
    static STRUCT_IF_C Uc_BFu32i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu15s, Uc_BFu32i_BFu15s)
//============================================================================



static void Test_Uc_BFu32i_BFu16i()
{
  {
    init_simple_test("Uc_BFu32i_BFu16i");
    static STRUCT_IF_C Uc_BFu32i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu16i, Uc_BFu32i_BFu16i)
//============================================================================



static void Test_Uc_BFu32i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu16ll");
    static STRUCT_IF_C Uc_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu16ll, Uc_BFu32i_BFu16ll)
//============================================================================



static void Test_Uc_BFu32i_BFu16s()
{
  {
    init_simple_test("Uc_BFu32i_BFu16s");
    static STRUCT_IF_C Uc_BFu32i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu16s, Uc_BFu32i_BFu16s)
//============================================================================



static void Test_Uc_BFu32i_BFu17i()
{
  {
    init_simple_test("Uc_BFu32i_BFu17i");
    static STRUCT_IF_C Uc_BFu32i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu17i, Uc_BFu32i_BFu17i)
//============================================================================



static void Test_Uc_BFu32i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu17ll");
    static STRUCT_IF_C Uc_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu17ll, Uc_BFu32i_BFu17ll)
//============================================================================



static void Test_Uc_BFu32i_BFu1c()
{
  {
    init_simple_test("Uc_BFu32i_BFu1c");
    static STRUCT_IF_C Uc_BFu32i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu1c, Uc_BFu32i_BFu1c)
//============================================================================



static void Test_Uc_BFu32i_BFu1i()
{
  {
    init_simple_test("Uc_BFu32i_BFu1i");
    static STRUCT_IF_C Uc_BFu32i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu1i, Uc_BFu32i_BFu1i)
//============================================================================



static void Test_Uc_BFu32i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu1ll");
    static STRUCT_IF_C Uc_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu1ll, Uc_BFu32i_BFu1ll)
//============================================================================



static void Test_Uc_BFu32i_BFu1s()
{
  {
    init_simple_test("Uc_BFu32i_BFu1s");
    static STRUCT_IF_C Uc_BFu32i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu1s, Uc_BFu32i_BFu1s)
//============================================================================



static void Test_Uc_BFu32i_BFu31i()
{
  {
    init_simple_test("Uc_BFu32i_BFu31i");
    static STRUCT_IF_C Uc_BFu32i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu31i, Uc_BFu32i_BFu31i)
//============================================================================



static void Test_Uc_BFu32i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu31ll");
    static STRUCT_IF_C Uc_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu31ll, Uc_BFu32i_BFu31ll)
//============================================================================



static void Test_Uc_BFu32i_BFu32i()
{
  {
    init_simple_test("Uc_BFu32i_BFu32i");
    static STRUCT_IF_C Uc_BFu32i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu32i, Uc_BFu32i_BFu32i)
//============================================================================



static void Test_Uc_BFu32i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu32ll");
    static STRUCT_IF_C Uc_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu32ll, Uc_BFu32i_BFu32ll)
//============================================================================



static void Test_Uc_BFu32i_BFu33()
{
  {
    init_simple_test("Uc_BFu32i_BFu33");
    static STRUCT_IF_C Uc_BFu32i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "Uc_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "Uc_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu33, Uc_BFu32i_BFu33)
//============================================================================



static void Test_Uc_BFu32i_BFu7c()
{
  {
    init_simple_test("Uc_BFu32i_BFu7c");
    static STRUCT_IF_C Uc_BFu32i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu7c, Uc_BFu32i_BFu7c)
//============================================================================



static void Test_Uc_BFu32i_BFu7i()
{
  {
    init_simple_test("Uc_BFu32i_BFu7i");
    static STRUCT_IF_C Uc_BFu32i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu7i, Uc_BFu32i_BFu7i)
//============================================================================



static void Test_Uc_BFu32i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu7ll");
    static STRUCT_IF_C Uc_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu7ll, Uc_BFu32i_BFu7ll)
//============================================================================



static void Test_Uc_BFu32i_BFu7s()
{
  {
    init_simple_test("Uc_BFu32i_BFu7s");
    static STRUCT_IF_C Uc_BFu32i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu7s, Uc_BFu32i_BFu7s)
//============================================================================



static void Test_Uc_BFu32i_BFu8c()
{
  {
    init_simple_test("Uc_BFu32i_BFu8c");
    static STRUCT_IF_C Uc_BFu32i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu8c, Uc_BFu32i_BFu8c)
//============================================================================



static void Test_Uc_BFu32i_BFu8i()
{
  {
    init_simple_test("Uc_BFu32i_BFu8i");
    static STRUCT_IF_C Uc_BFu32i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu8i, Uc_BFu32i_BFu8i)
//============================================================================



static void Test_Uc_BFu32i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu8ll");
    static STRUCT_IF_C Uc_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu8ll, Uc_BFu32i_BFu8ll)
//============================================================================



static void Test_Uc_BFu32i_BFu8s()
{
  {
    init_simple_test("Uc_BFu32i_BFu8s");
    static STRUCT_IF_C Uc_BFu32i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu8s, Uc_BFu32i_BFu8s)
//============================================================================



static void Test_Uc_BFu32i_BFu9i()
{
  {
    init_simple_test("Uc_BFu32i_BFu9i");
    static STRUCT_IF_C Uc_BFu32i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu9i, Uc_BFu32i_BFu9i)
//============================================================================



static void Test_Uc_BFu32i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu9ll");
    static STRUCT_IF_C Uc_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu9ll, Uc_BFu32i_BFu9ll)
//============================================================================



static void Test_Uc_BFu32i_BFu9s()
{
  {
    init_simple_test("Uc_BFu32i_BFu9s");
    static STRUCT_IF_C Uc_BFu32i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_BFu9s, Uc_BFu32i_BFu9s)
//============================================================================



static void Test_Uc_BFu32i_C()
{
  {
    init_simple_test("Uc_BFu32i_C");
    static STRUCT_IF_C Uc_BFu32i_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_C");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_C, Uc_BFu32i_C)
//============================================================================



static void Test_Uc_BFu32i_D()
{
  {
    init_simple_test("Uc_BFu32i_D");
    static STRUCT_IF_C Uc_BFu32i_D lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_D");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_D, Uc_BFu32i_D)
//============================================================================



static void Test_Uc_BFu32i_F()
{
  {
    init_simple_test("Uc_BFu32i_F");
    static STRUCT_IF_C Uc_BFu32i_F lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_F");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_F, Uc_BFu32i_F)
//============================================================================



static void Test_Uc_BFu32i_I()
{
  {
    init_simple_test("Uc_BFu32i_I");
    static STRUCT_IF_C Uc_BFu32i_I lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_I");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_I, Uc_BFu32i_I)
//============================================================================



static void Test_Uc_BFu32i_Ip()
{
  {
    init_simple_test("Uc_BFu32i_Ip");
    static STRUCT_IF_C Uc_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_Ip");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_Ip, Uc_BFu32i_Ip)
//============================================================================



static void Test_Uc_BFu32i_L()
{
  {
    init_simple_test("Uc_BFu32i_L");
    static STRUCT_IF_C Uc_BFu32i_L lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_L");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_L, Uc_BFu32i_L)
//============================================================================



static void Test_Uc_BFu32i_S()
{
  {
    init_simple_test("Uc_BFu32i_S");
    static STRUCT_IF_C Uc_BFu32i_S lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_S");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_S, Uc_BFu32i_S)
//============================================================================



static void Test_Uc_BFu32i_Uc()
{
  {
    init_simple_test("Uc_BFu32i_Uc");
    static STRUCT_IF_C Uc_BFu32i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_Uc");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_Uc, Uc_BFu32i_Uc)
//============================================================================



static void Test_Uc_BFu32i_Ui()
{
  {
    init_simple_test("Uc_BFu32i_Ui");
    static STRUCT_IF_C Uc_BFu32i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_Ui");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_Ui, Uc_BFu32i_Ui)
//============================================================================



static void Test_Uc_BFu32i_Ul()
{
  {
    init_simple_test("Uc_BFu32i_Ul");
    static STRUCT_IF_C Uc_BFu32i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_Ul");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_Ul, Uc_BFu32i_Ul)
//============================================================================



static void Test_Uc_BFu32i_Us()
{
  {
    init_simple_test("Uc_BFu32i_Us");
    static STRUCT_IF_C Uc_BFu32i_Us lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_Us");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_Us, Uc_BFu32i_Us)
//============================================================================



static void Test_Uc_BFu32i_Vp()
{
  {
    init_simple_test("Uc_BFu32i_Vp");
    static STRUCT_IF_C Uc_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_Vp");
    check_field_offset(lv, v3, 5, "Uc_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32i_Vp, Uc_BFu32i_Vp)
//============================================================================



static void Test_Uc_BFu32ll()
{
  {
    init_simple_test("Uc_BFu32ll");
    static STRUCT_IF_C Uc_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll, Uc_BFu32ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu15i");
    static STRUCT_IF_C Uc_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu15i, Uc_BFu32ll_BFu15i)
//============================================================================



static void Test_Uc_BFu32ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu15ll, Uc_BFu32ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu15s");
    static STRUCT_IF_C Uc_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu15s, Uc_BFu32ll_BFu15s)
//============================================================================



static void Test_Uc_BFu32ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu16i");
    static STRUCT_IF_C Uc_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu16i, Uc_BFu32ll_BFu16i)
//============================================================================



static void Test_Uc_BFu32ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu16ll, Uc_BFu32ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu16s");
    static STRUCT_IF_C Uc_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu16s, Uc_BFu32ll_BFu16s)
//============================================================================



static void Test_Uc_BFu32ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu17i");
    static STRUCT_IF_C Uc_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu17i, Uc_BFu32ll_BFu17i)
//============================================================================



static void Test_Uc_BFu32ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu17ll, Uc_BFu32ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu32ll_BFu1c");
    static STRUCT_IF_C Uc_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu1c, Uc_BFu32ll_BFu1c)
//============================================================================



static void Test_Uc_BFu32ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu1i");
    static STRUCT_IF_C Uc_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu1i, Uc_BFu32ll_BFu1i)
//============================================================================



static void Test_Uc_BFu32ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu1ll, Uc_BFu32ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu1s");
    static STRUCT_IF_C Uc_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu1s, Uc_BFu32ll_BFu1s)
//============================================================================



static void Test_Uc_BFu32ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu31i");
    static STRUCT_IF_C Uc_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu31i, Uc_BFu32ll_BFu31i)
//============================================================================



static void Test_Uc_BFu32ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu31ll, Uc_BFu32ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu32i");
    static STRUCT_IF_C Uc_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu32i, Uc_BFu32ll_BFu32i)
//============================================================================



static void Test_Uc_BFu32ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu32ll, Uc_BFu32ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu33()
{
  {
    init_simple_test("Uc_BFu32ll_BFu33");
    static STRUCT_IF_C Uc_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "Uc_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "Uc_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu33, Uc_BFu32ll_BFu33)
//============================================================================



static void Test_Uc_BFu32ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu32ll_BFu7c");
    static STRUCT_IF_C Uc_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu7c, Uc_BFu32ll_BFu7c)
//============================================================================



static void Test_Uc_BFu32ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu7i");
    static STRUCT_IF_C Uc_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu7i, Uc_BFu32ll_BFu7i)
//============================================================================



static void Test_Uc_BFu32ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu7ll, Uc_BFu32ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu7s");
    static STRUCT_IF_C Uc_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu7s, Uc_BFu32ll_BFu7s)
//============================================================================



static void Test_Uc_BFu32ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu32ll_BFu8c");
    static STRUCT_IF_C Uc_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu8c, Uc_BFu32ll_BFu8c)
//============================================================================



static void Test_Uc_BFu32ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu8i");
    static STRUCT_IF_C Uc_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu8i, Uc_BFu32ll_BFu8i)
//============================================================================



static void Test_Uc_BFu32ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu8ll, Uc_BFu32ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu8s");
    static STRUCT_IF_C Uc_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu8s, Uc_BFu32ll_BFu8s)
//============================================================================



static void Test_Uc_BFu32ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu9i");
    static STRUCT_IF_C Uc_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu9i, Uc_BFu32ll_BFu9i)
//============================================================================



static void Test_Uc_BFu32ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu9ll, Uc_BFu32ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu32ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu9s");
    static STRUCT_IF_C Uc_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_BFu9s, Uc_BFu32ll_BFu9s)
//============================================================================



static void Test_Uc_BFu32ll_C()
{
  {
    init_simple_test("Uc_BFu32ll_C");
    static STRUCT_IF_C Uc_BFu32ll_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_C");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_C, Uc_BFu32ll_C)
//============================================================================



static void Test_Uc_BFu32ll_D()
{
  {
    init_simple_test("Uc_BFu32ll_D");
    static STRUCT_IF_C Uc_BFu32ll_D lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_D");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_D, Uc_BFu32ll_D)
//============================================================================



static void Test_Uc_BFu32ll_F()
{
  {
    init_simple_test("Uc_BFu32ll_F");
    static STRUCT_IF_C Uc_BFu32ll_F lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_F");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_F, Uc_BFu32ll_F)
//============================================================================



static void Test_Uc_BFu32ll_I()
{
  {
    init_simple_test("Uc_BFu32ll_I");
    static STRUCT_IF_C Uc_BFu32ll_I lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_I");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_I, Uc_BFu32ll_I)
//============================================================================



static void Test_Uc_BFu32ll_Ip()
{
  {
    init_simple_test("Uc_BFu32ll_Ip");
    static STRUCT_IF_C Uc_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_Ip");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_Ip, Uc_BFu32ll_Ip)
//============================================================================



static void Test_Uc_BFu32ll_L()
{
  {
    init_simple_test("Uc_BFu32ll_L");
    static STRUCT_IF_C Uc_BFu32ll_L lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_L");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_L, Uc_BFu32ll_L)
//============================================================================



static void Test_Uc_BFu32ll_S()
{
  {
    init_simple_test("Uc_BFu32ll_S");
    static STRUCT_IF_C Uc_BFu32ll_S lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_S");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_S, Uc_BFu32ll_S)
//============================================================================



static void Test_Uc_BFu32ll_Uc()
{
  {
    init_simple_test("Uc_BFu32ll_Uc");
    static STRUCT_IF_C Uc_BFu32ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_Uc, Uc_BFu32ll_Uc)
//============================================================================



static void Test_Uc_BFu32ll_Ui()
{
  {
    init_simple_test("Uc_BFu32ll_Ui");
    static STRUCT_IF_C Uc_BFu32ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_Ui");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_Ui, Uc_BFu32ll_Ui)
//============================================================================



static void Test_Uc_BFu32ll_Ul()
{
  {
    init_simple_test("Uc_BFu32ll_Ul");
    static STRUCT_IF_C Uc_BFu32ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(Uc_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_Ul");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_Ul, Uc_BFu32ll_Ul)
//============================================================================



static void Test_Uc_BFu32ll_Us()
{
  {
    init_simple_test("Uc_BFu32ll_Us");
    static STRUCT_IF_C Uc_BFu32ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_Us");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_Us, Uc_BFu32ll_Us)
//============================================================================



static void Test_Uc_BFu32ll_Vp()
{
  {
    init_simple_test("Uc_BFu32ll_Vp");
    static STRUCT_IF_C Uc_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_Vp");
    check_field_offset(lv, v3, 5, "Uc_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu32ll_Vp, Uc_BFu32ll_Vp)
//============================================================================



static void Test_Uc_BFu33()
{
  {
    init_simple_test("Uc_BFu33");
    static STRUCT_IF_C Uc_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33, Uc_BFu33)
//============================================================================



static void Test_Uc_BFu33_BFu15i()
{
  {
    init_simple_test("Uc_BFu33_BFu15i");
    static STRUCT_IF_C Uc_BFu33_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "Uc_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "Uc_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu15i, Uc_BFu33_BFu15i)
//============================================================================



static void Test_Uc_BFu33_BFu15ll()
{
  {
    init_simple_test("Uc_BFu33_BFu15ll");
    static STRUCT_IF_C Uc_BFu33_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "Uc_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "Uc_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu15ll, Uc_BFu33_BFu15ll)
//============================================================================



static void Test_Uc_BFu33_BFu15s()
{
  {
    init_simple_test("Uc_BFu33_BFu15s");
    static STRUCT_IF_C Uc_BFu33_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "Uc_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "Uc_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu15s, Uc_BFu33_BFu15s)
//============================================================================



static void Test_Uc_BFu33_BFu16i()
{
  {
    init_simple_test("Uc_BFu33_BFu16i");
    static STRUCT_IF_C Uc_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "Uc_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "Uc_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu16i, Uc_BFu33_BFu16i)
//============================================================================



static void Test_Uc_BFu33_BFu16ll()
{
  {
    init_simple_test("Uc_BFu33_BFu16ll");
    static STRUCT_IF_C Uc_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "Uc_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "Uc_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu16ll, Uc_BFu33_BFu16ll)
//============================================================================



static void Test_Uc_BFu33_BFu16s()
{
  {
    init_simple_test("Uc_BFu33_BFu16s");
    static STRUCT_IF_C Uc_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "Uc_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "Uc_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu16s, Uc_BFu33_BFu16s)
//============================================================================



static void Test_Uc_BFu33_BFu17i()
{
  {
    init_simple_test("Uc_BFu33_BFu17i");
    static STRUCT_IF_C Uc_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "Uc_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "Uc_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu17i, Uc_BFu33_BFu17i)
//============================================================================



static void Test_Uc_BFu33_BFu17ll()
{
  {
    init_simple_test("Uc_BFu33_BFu17ll");
    static STRUCT_IF_C Uc_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "Uc_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "Uc_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu17ll, Uc_BFu33_BFu17ll)
//============================================================================



static void Test_Uc_BFu33_BFu1c()
{
  {
    init_simple_test("Uc_BFu33_BFu1c");
    static STRUCT_IF_C Uc_BFu33_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Uc_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu1c, Uc_BFu33_BFu1c)
//============================================================================



static void Test_Uc_BFu33_BFu1i()
{
  {
    init_simple_test("Uc_BFu33_BFu1i");
    static STRUCT_IF_C Uc_BFu33_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Uc_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu1i, Uc_BFu33_BFu1i)
//============================================================================



static void Test_Uc_BFu33_BFu1ll()
{
  {
    init_simple_test("Uc_BFu33_BFu1ll");
    static STRUCT_IF_C Uc_BFu33_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Uc_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu1ll, Uc_BFu33_BFu1ll)
//============================================================================



static void Test_Uc_BFu33_BFu1s()
{
  {
    init_simple_test("Uc_BFu33_BFu1s");
    static STRUCT_IF_C Uc_BFu33_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Uc_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu1s, Uc_BFu33_BFu1s)
//============================================================================



static void Test_Uc_BFu33_BFu31i()
{
  {
    init_simple_test("Uc_BFu33_BFu31i");
    static STRUCT_IF_C Uc_BFu33_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "Uc_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "Uc_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu31i, Uc_BFu33_BFu31i)
//============================================================================



static void Test_Uc_BFu33_BFu31ll()
{
  {
    init_simple_test("Uc_BFu33_BFu31ll");
    static STRUCT_IF_C Uc_BFu33_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "Uc_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "Uc_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu31ll, Uc_BFu33_BFu31ll)
//============================================================================



static void Test_Uc_BFu33_BFu32i()
{
  {
    init_simple_test("Uc_BFu33_BFu32i");
    static STRUCT_IF_C Uc_BFu33_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "Uc_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "Uc_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu32i, Uc_BFu33_BFu32i)
//============================================================================



static void Test_Uc_BFu33_BFu32ll()
{
  {
    init_simple_test("Uc_BFu33_BFu32ll");
    static STRUCT_IF_C Uc_BFu33_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "Uc_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "Uc_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu32ll, Uc_BFu33_BFu32ll)
//============================================================================



static void Test_Uc_BFu33_BFu33()
{
  {
    init_simple_test("Uc_BFu33_BFu33");
    static STRUCT_IF_C Uc_BFu33_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "Uc_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu33, Uc_BFu33_BFu33)
//============================================================================



static void Test_Uc_BFu33_BFu7c()
{
  {
    init_simple_test("Uc_BFu33_BFu7c");
    static STRUCT_IF_C Uc_BFu33_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Uc_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Uc_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu7c, Uc_BFu33_BFu7c)
//============================================================================



static void Test_Uc_BFu33_BFu7i()
{
  {
    init_simple_test("Uc_BFu33_BFu7i");
    static STRUCT_IF_C Uc_BFu33_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Uc_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Uc_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu7i, Uc_BFu33_BFu7i)
//============================================================================



static void Test_Uc_BFu33_BFu7ll()
{
  {
    init_simple_test("Uc_BFu33_BFu7ll");
    static STRUCT_IF_C Uc_BFu33_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Uc_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Uc_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu7ll, Uc_BFu33_BFu7ll)
//============================================================================



static void Test_Uc_BFu33_BFu7s()
{
  {
    init_simple_test("Uc_BFu33_BFu7s");
    static STRUCT_IF_C Uc_BFu33_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Uc_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Uc_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu7s, Uc_BFu33_BFu7s)
//============================================================================



static void Test_Uc_BFu33_BFu8c()
{
  {
    init_simple_test("Uc_BFu33_BFu8c");
    static STRUCT_IF_C Uc_BFu33_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "Uc_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "Uc_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu8c, Uc_BFu33_BFu8c)
//============================================================================



static void Test_Uc_BFu33_BFu8i()
{
  {
    init_simple_test("Uc_BFu33_BFu8i");
    static STRUCT_IF_C Uc_BFu33_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "Uc_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "Uc_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu8i, Uc_BFu33_BFu8i)
//============================================================================



static void Test_Uc_BFu33_BFu8ll()
{
  {
    init_simple_test("Uc_BFu33_BFu8ll");
    static STRUCT_IF_C Uc_BFu33_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "Uc_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "Uc_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu8ll, Uc_BFu33_BFu8ll)
//============================================================================



static void Test_Uc_BFu33_BFu8s()
{
  {
    init_simple_test("Uc_BFu33_BFu8s");
    static STRUCT_IF_C Uc_BFu33_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "Uc_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "Uc_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu8s, Uc_BFu33_BFu8s)
//============================================================================



static void Test_Uc_BFu33_BFu9i()
{
  {
    init_simple_test("Uc_BFu33_BFu9i");
    static STRUCT_IF_C Uc_BFu33_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "Uc_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "Uc_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu9i, Uc_BFu33_BFu9i)
//============================================================================



static void Test_Uc_BFu33_BFu9ll()
{
  {
    init_simple_test("Uc_BFu33_BFu9ll");
    static STRUCT_IF_C Uc_BFu33_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "Uc_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "Uc_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu9ll, Uc_BFu33_BFu9ll)
//============================================================================



static void Test_Uc_BFu33_BFu9s()
{
  {
    init_simple_test("Uc_BFu33_BFu9s");
    static STRUCT_IF_C Uc_BFu33_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "Uc_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "Uc_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_BFu9s, Uc_BFu33_BFu9s)
//============================================================================



static void Test_Uc_BFu33_C()
{
  {
    init_simple_test("Uc_BFu33_C");
    static STRUCT_IF_C Uc_BFu33_C lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_C");
    check_field_offset(lv, v3, 6, "Uc_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_C, Uc_BFu33_C)
//============================================================================



static void Test_Uc_BFu33_D()
{
  {
    init_simple_test("Uc_BFu33_D");
    static STRUCT_IF_C Uc_BFu33_D lv;
    check2(sizeof(lv), 14, "sizeof(Uc_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_D");
    check_field_offset(lv, v3, 6, "Uc_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_D, Uc_BFu33_D)
//============================================================================



static void Test_Uc_BFu33_F()
{
  {
    init_simple_test("Uc_BFu33_F");
    static STRUCT_IF_C Uc_BFu33_F lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_F");
    check_field_offset(lv, v3, 6, "Uc_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_F, Uc_BFu33_F)
//============================================================================



static void Test_Uc_BFu33_I()
{
  {
    init_simple_test("Uc_BFu33_I");
    static STRUCT_IF_C Uc_BFu33_I lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_I");
    check_field_offset(lv, v3, 6, "Uc_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_I, Uc_BFu33_I)
//============================================================================



static void Test_Uc_BFu33_Ip()
{
  {
    init_simple_test("Uc_BFu33_Ip");
    static STRUCT_IF_C Uc_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Uc_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_Ip");
    check_field_offset(lv, v3, 6, "Uc_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_Ip, Uc_BFu33_Ip)
//============================================================================



static void Test_Uc_BFu33_L()
{
  {
    init_simple_test("Uc_BFu33_L");
    static STRUCT_IF_C Uc_BFu33_L lv;
    check2(sizeof(lv), 14, "sizeof(Uc_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_L");
    check_field_offset(lv, v3, 6, "Uc_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_L, Uc_BFu33_L)
//============================================================================



static void Test_Uc_BFu33_S()
{
  {
    init_simple_test("Uc_BFu33_S");
    static STRUCT_IF_C Uc_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_S");
    check_field_offset(lv, v3, 6, "Uc_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_S, Uc_BFu33_S)
//============================================================================



static void Test_Uc_BFu33_Uc()
{
  {
    init_simple_test("Uc_BFu33_Uc");
    static STRUCT_IF_C Uc_BFu33_Uc lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_Uc");
    check_field_offset(lv, v3, 6, "Uc_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_Uc, Uc_BFu33_Uc)
//============================================================================



static void Test_Uc_BFu33_Ui()
{
  {
    init_simple_test("Uc_BFu33_Ui");
    static STRUCT_IF_C Uc_BFu33_Ui lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_Ui");
    check_field_offset(lv, v3, 6, "Uc_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_Ui, Uc_BFu33_Ui)
//============================================================================



static void Test_Uc_BFu33_Ul()
{
  {
    init_simple_test("Uc_BFu33_Ul");
    static STRUCT_IF_C Uc_BFu33_Ul lv;
    check2(sizeof(lv), 14, "sizeof(Uc_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_Ul");
    check_field_offset(lv, v3, 6, "Uc_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_Ul, Uc_BFu33_Ul)
//============================================================================



static void Test_Uc_BFu33_Us()
{
  {
    init_simple_test("Uc_BFu33_Us");
    static STRUCT_IF_C Uc_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_Us");
    check_field_offset(lv, v3, 6, "Uc_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_Us, Uc_BFu33_Us)
//============================================================================



static void Test_Uc_BFu33_Vp()
{
  {
    init_simple_test("Uc_BFu33_Vp");
    static STRUCT_IF_C Uc_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Uc_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_Vp");
    check_field_offset(lv, v3, 6, "Uc_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu33_Vp, Uc_BFu33_Vp)
//============================================================================



static void Test_Uc_BFu7c()
{
  {
    init_simple_test("Uc_BFu7c");
    static STRUCT_IF_C Uc_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c, Uc_BFu7c)
//============================================================================



static void Test_Uc_BFu7c_BFu15i()
{
  {
    init_simple_test("Uc_BFu7c_BFu15i");
    static STRUCT_IF_C Uc_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu15i, Uc_BFu7c_BFu15i)
//============================================================================



static void Test_Uc_BFu7c_BFu15ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu15ll");
    static STRUCT_IF_C Uc_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu15ll, Uc_BFu7c_BFu15ll)
//============================================================================



static void Test_Uc_BFu7c_BFu15s()
{
  {
    init_simple_test("Uc_BFu7c_BFu15s");
    static STRUCT_IF_C Uc_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu15s, Uc_BFu7c_BFu15s)
//============================================================================



static void Test_Uc_BFu7c_BFu16i()
{
  {
    init_simple_test("Uc_BFu7c_BFu16i");
    static STRUCT_IF_C Uc_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu16i, Uc_BFu7c_BFu16i)
//============================================================================



static void Test_Uc_BFu7c_BFu16ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu16ll");
    static STRUCT_IF_C Uc_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu16ll, Uc_BFu7c_BFu16ll)
//============================================================================



static void Test_Uc_BFu7c_BFu16s()
{
  {
    init_simple_test("Uc_BFu7c_BFu16s");
    static STRUCT_IF_C Uc_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu16s, Uc_BFu7c_BFu16s)
//============================================================================



static void Test_Uc_BFu7c_BFu17i()
{
  {
    init_simple_test("Uc_BFu7c_BFu17i");
    static STRUCT_IF_C Uc_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu17i, Uc_BFu7c_BFu17i)
//============================================================================



static void Test_Uc_BFu7c_BFu17ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu17ll");
    static STRUCT_IF_C Uc_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu17ll, Uc_BFu7c_BFu17ll)
//============================================================================



static void Test_Uc_BFu7c_BFu1c()
{
  {
    init_simple_test("Uc_BFu7c_BFu1c");
    static STRUCT_IF_C Uc_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu1c, Uc_BFu7c_BFu1c)
//============================================================================



static void Test_Uc_BFu7c_BFu1i()
{
  {
    init_simple_test("Uc_BFu7c_BFu1i");
    static STRUCT_IF_C Uc_BFu7c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu1i, Uc_BFu7c_BFu1i)
//============================================================================



static void Test_Uc_BFu7c_BFu1ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu1ll");
    static STRUCT_IF_C Uc_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu1ll, Uc_BFu7c_BFu1ll)
//============================================================================



static void Test_Uc_BFu7c_BFu1s()
{
  {
    init_simple_test("Uc_BFu7c_BFu1s");
    static STRUCT_IF_C Uc_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu1s, Uc_BFu7c_BFu1s)
//============================================================================



static void Test_Uc_BFu7c_BFu31i()
{
  {
    init_simple_test("Uc_BFu7c_BFu31i");
    static STRUCT_IF_C Uc_BFu7c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu31i, Uc_BFu7c_BFu31i)
//============================================================================



static void Test_Uc_BFu7c_BFu31ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu31ll");
    static STRUCT_IF_C Uc_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu31ll, Uc_BFu7c_BFu31ll)
//============================================================================



static void Test_Uc_BFu7c_BFu32i()
{
  {
    init_simple_test("Uc_BFu7c_BFu32i");
    static STRUCT_IF_C Uc_BFu7c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu32i, Uc_BFu7c_BFu32i)
//============================================================================



static void Test_Uc_BFu7c_BFu32ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu32ll");
    static STRUCT_IF_C Uc_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu32ll, Uc_BFu7c_BFu32ll)
//============================================================================



static void Test_Uc_BFu7c_BFu33()
{
  {
    init_simple_test("Uc_BFu7c_BFu33");
    static STRUCT_IF_C Uc_BFu7c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Uc_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Uc_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu33, Uc_BFu7c_BFu33)
//============================================================================



static void Test_Uc_BFu7c_BFu7c()
{
  {
    init_simple_test("Uc_BFu7c_BFu7c");
    static STRUCT_IF_C Uc_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu7c, Uc_BFu7c_BFu7c)
//============================================================================



static void Test_Uc_BFu7c_BFu7i()
{
  {
    init_simple_test("Uc_BFu7c_BFu7i");
    static STRUCT_IF_C Uc_BFu7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu7i, Uc_BFu7c_BFu7i)
//============================================================================



static void Test_Uc_BFu7c_BFu7ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu7ll");
    static STRUCT_IF_C Uc_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu7ll, Uc_BFu7c_BFu7ll)
//============================================================================



static void Test_Uc_BFu7c_BFu7s()
{
  {
    init_simple_test("Uc_BFu7c_BFu7s");
    static STRUCT_IF_C Uc_BFu7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu7s, Uc_BFu7c_BFu7s)
//============================================================================



static void Test_Uc_BFu7c_BFu8c()
{
  {
    init_simple_test("Uc_BFu7c_BFu8c");
    static STRUCT_IF_C Uc_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu8c, Uc_BFu7c_BFu8c)
//============================================================================



static void Test_Uc_BFu7c_BFu8i()
{
  {
    init_simple_test("Uc_BFu7c_BFu8i");
    static STRUCT_IF_C Uc_BFu7c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu8i, Uc_BFu7c_BFu8i)
//============================================================================



static void Test_Uc_BFu7c_BFu8ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu8ll");
    static STRUCT_IF_C Uc_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu8ll, Uc_BFu7c_BFu8ll)
//============================================================================



static void Test_Uc_BFu7c_BFu8s()
{
  {
    init_simple_test("Uc_BFu7c_BFu8s");
    static STRUCT_IF_C Uc_BFu7c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu8s, Uc_BFu7c_BFu8s)
//============================================================================



static void Test_Uc_BFu7c_BFu9i()
{
  {
    init_simple_test("Uc_BFu7c_BFu9i");
    static STRUCT_IF_C Uc_BFu7c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu9i, Uc_BFu7c_BFu9i)
//============================================================================



static void Test_Uc_BFu7c_BFu9ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu9ll");
    static STRUCT_IF_C Uc_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu9ll, Uc_BFu7c_BFu9ll)
//============================================================================



static void Test_Uc_BFu7c_BFu9s()
{
  {
    init_simple_test("Uc_BFu7c_BFu9s");
    static STRUCT_IF_C Uc_BFu7c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_BFu9s, Uc_BFu7c_BFu9s)
//============================================================================



static void Test_Uc_BFu7c_C()
{
  {
    init_simple_test("Uc_BFu7c_C");
    static STRUCT_IF_C Uc_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_C");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_C, Uc_BFu7c_C)
//============================================================================



static void Test_Uc_BFu7c_D()
{
  {
    init_simple_test("Uc_BFu7c_D");
    static STRUCT_IF_C Uc_BFu7c_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_D");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_D, Uc_BFu7c_D)
//============================================================================



static void Test_Uc_BFu7c_F()
{
  {
    init_simple_test("Uc_BFu7c_F");
    static STRUCT_IF_C Uc_BFu7c_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_F");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_F, Uc_BFu7c_F)
//============================================================================



static void Test_Uc_BFu7c_I()
{
  {
    init_simple_test("Uc_BFu7c_I");
    static STRUCT_IF_C Uc_BFu7c_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_I");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_I, Uc_BFu7c_I)
//============================================================================



static void Test_Uc_BFu7c_Ip()
{
  {
    init_simple_test("Uc_BFu7c_Ip");
    static STRUCT_IF_C Uc_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_Ip, Uc_BFu7c_Ip)
//============================================================================



static void Test_Uc_BFu7c_L()
{
  {
    init_simple_test("Uc_BFu7c_L");
    static STRUCT_IF_C Uc_BFu7c_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_L");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_L, Uc_BFu7c_L)
//============================================================================



static void Test_Uc_BFu7c_S()
{
  {
    init_simple_test("Uc_BFu7c_S");
    static STRUCT_IF_C Uc_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_S");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_S, Uc_BFu7c_S)
//============================================================================



static void Test_Uc_BFu7c_Uc()
{
  {
    init_simple_test("Uc_BFu7c_Uc");
    static STRUCT_IF_C Uc_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_Uc, Uc_BFu7c_Uc)
//============================================================================



static void Test_Uc_BFu7c_Ui()
{
  {
    init_simple_test("Uc_BFu7c_Ui");
    static STRUCT_IF_C Uc_BFu7c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_Ui, Uc_BFu7c_Ui)
//============================================================================



static void Test_Uc_BFu7c_Ul()
{
  {
    init_simple_test("Uc_BFu7c_Ul");
    static STRUCT_IF_C Uc_BFu7c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_Ul, Uc_BFu7c_Ul)
//============================================================================



static void Test_Uc_BFu7c_Us()
{
  {
    init_simple_test("Uc_BFu7c_Us");
    static STRUCT_IF_C Uc_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_Us, Uc_BFu7c_Us)
//============================================================================



static void Test_Uc_BFu7c_Vp()
{
  {
    init_simple_test("Uc_BFu7c_Vp");
    static STRUCT_IF_C Uc_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7c_Vp, Uc_BFu7c_Vp)
//============================================================================



static void Test_Uc_BFu7i()
{
  {
    init_simple_test("Uc_BFu7i");
    static STRUCT_IF_C Uc_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i, Uc_BFu7i)
//============================================================================



static void Test_Uc_BFu7i_BFu15i()
{
  {
    init_simple_test("Uc_BFu7i_BFu15i");
    static STRUCT_IF_C Uc_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu15i, Uc_BFu7i_BFu15i)
//============================================================================



static void Test_Uc_BFu7i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu15ll");
    static STRUCT_IF_C Uc_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu15ll, Uc_BFu7i_BFu15ll)
//============================================================================



static void Test_Uc_BFu7i_BFu15s()
{
  {
    init_simple_test("Uc_BFu7i_BFu15s");
    static STRUCT_IF_C Uc_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu15s, Uc_BFu7i_BFu15s)
//============================================================================



static void Test_Uc_BFu7i_BFu16i()
{
  {
    init_simple_test("Uc_BFu7i_BFu16i");
    static STRUCT_IF_C Uc_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu16i, Uc_BFu7i_BFu16i)
//============================================================================



static void Test_Uc_BFu7i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu16ll");
    static STRUCT_IF_C Uc_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu16ll, Uc_BFu7i_BFu16ll)
//============================================================================



static void Test_Uc_BFu7i_BFu16s()
{
  {
    init_simple_test("Uc_BFu7i_BFu16s");
    static STRUCT_IF_C Uc_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu16s, Uc_BFu7i_BFu16s)
//============================================================================



static void Test_Uc_BFu7i_BFu17i()
{
  {
    init_simple_test("Uc_BFu7i_BFu17i");
    static STRUCT_IF_C Uc_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu17i, Uc_BFu7i_BFu17i)
//============================================================================



static void Test_Uc_BFu7i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu17ll");
    static STRUCT_IF_C Uc_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu17ll, Uc_BFu7i_BFu17ll)
//============================================================================



static void Test_Uc_BFu7i_BFu1c()
{
  {
    init_simple_test("Uc_BFu7i_BFu1c");
    static STRUCT_IF_C Uc_BFu7i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu1c, Uc_BFu7i_BFu1c)
//============================================================================



static void Test_Uc_BFu7i_BFu1i()
{
  {
    init_simple_test("Uc_BFu7i_BFu1i");
    static STRUCT_IF_C Uc_BFu7i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu1i, Uc_BFu7i_BFu1i)
//============================================================================



static void Test_Uc_BFu7i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu1ll");
    static STRUCT_IF_C Uc_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu1ll, Uc_BFu7i_BFu1ll)
//============================================================================



static void Test_Uc_BFu7i_BFu1s()
{
  {
    init_simple_test("Uc_BFu7i_BFu1s");
    static STRUCT_IF_C Uc_BFu7i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu1s, Uc_BFu7i_BFu1s)
//============================================================================



static void Test_Uc_BFu7i_BFu31i()
{
  {
    init_simple_test("Uc_BFu7i_BFu31i");
    static STRUCT_IF_C Uc_BFu7i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu31i, Uc_BFu7i_BFu31i)
//============================================================================



static void Test_Uc_BFu7i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu31ll");
    static STRUCT_IF_C Uc_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu31ll, Uc_BFu7i_BFu31ll)
//============================================================================



static void Test_Uc_BFu7i_BFu32i()
{
  {
    init_simple_test("Uc_BFu7i_BFu32i");
    static STRUCT_IF_C Uc_BFu7i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu32i, Uc_BFu7i_BFu32i)
//============================================================================



static void Test_Uc_BFu7i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu32ll");
    static STRUCT_IF_C Uc_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu32ll, Uc_BFu7i_BFu32ll)
//============================================================================



static void Test_Uc_BFu7i_BFu33()
{
  {
    init_simple_test("Uc_BFu7i_BFu33");
    static STRUCT_IF_C Uc_BFu7i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Uc_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Uc_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu33, Uc_BFu7i_BFu33)
//============================================================================



static void Test_Uc_BFu7i_BFu7c()
{
  {
    init_simple_test("Uc_BFu7i_BFu7c");
    static STRUCT_IF_C Uc_BFu7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu7c, Uc_BFu7i_BFu7c)
//============================================================================



static void Test_Uc_BFu7i_BFu7i()
{
  {
    init_simple_test("Uc_BFu7i_BFu7i");
    static STRUCT_IF_C Uc_BFu7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu7i, Uc_BFu7i_BFu7i)
//============================================================================



static void Test_Uc_BFu7i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu7ll");
    static STRUCT_IF_C Uc_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu7ll, Uc_BFu7i_BFu7ll)
//============================================================================



static void Test_Uc_BFu7i_BFu7s()
{
  {
    init_simple_test("Uc_BFu7i_BFu7s");
    static STRUCT_IF_C Uc_BFu7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu7s, Uc_BFu7i_BFu7s)
//============================================================================



static void Test_Uc_BFu7i_BFu8c()
{
  {
    init_simple_test("Uc_BFu7i_BFu8c");
    static STRUCT_IF_C Uc_BFu7i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu8c, Uc_BFu7i_BFu8c)
//============================================================================



static void Test_Uc_BFu7i_BFu8i()
{
  {
    init_simple_test("Uc_BFu7i_BFu8i");
    static STRUCT_IF_C Uc_BFu7i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu8i, Uc_BFu7i_BFu8i)
//============================================================================



static void Test_Uc_BFu7i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu8ll");
    static STRUCT_IF_C Uc_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu8ll, Uc_BFu7i_BFu8ll)
//============================================================================



static void Test_Uc_BFu7i_BFu8s()
{
  {
    init_simple_test("Uc_BFu7i_BFu8s");
    static STRUCT_IF_C Uc_BFu7i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu8s, Uc_BFu7i_BFu8s)
//============================================================================



static void Test_Uc_BFu7i_BFu9i()
{
  {
    init_simple_test("Uc_BFu7i_BFu9i");
    static STRUCT_IF_C Uc_BFu7i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu9i, Uc_BFu7i_BFu9i)
//============================================================================



static void Test_Uc_BFu7i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu9ll");
    static STRUCT_IF_C Uc_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu9ll, Uc_BFu7i_BFu9ll)
//============================================================================



static void Test_Uc_BFu7i_BFu9s()
{
  {
    init_simple_test("Uc_BFu7i_BFu9s");
    static STRUCT_IF_C Uc_BFu7i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_BFu9s, Uc_BFu7i_BFu9s)
//============================================================================



static void Test_Uc_BFu7i_C()
{
  {
    init_simple_test("Uc_BFu7i_C");
    static STRUCT_IF_C Uc_BFu7i_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_C");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_C, Uc_BFu7i_C)
//============================================================================



static void Test_Uc_BFu7i_D()
{
  {
    init_simple_test("Uc_BFu7i_D");
    static STRUCT_IF_C Uc_BFu7i_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_D");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_D, Uc_BFu7i_D)
//============================================================================



static void Test_Uc_BFu7i_F()
{
  {
    init_simple_test("Uc_BFu7i_F");
    static STRUCT_IF_C Uc_BFu7i_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_F");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_F, Uc_BFu7i_F)
//============================================================================



static void Test_Uc_BFu7i_I()
{
  {
    init_simple_test("Uc_BFu7i_I");
    static STRUCT_IF_C Uc_BFu7i_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_I");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_I, Uc_BFu7i_I)
//============================================================================



static void Test_Uc_BFu7i_Ip()
{
  {
    init_simple_test("Uc_BFu7i_Ip");
    static STRUCT_IF_C Uc_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_Ip, Uc_BFu7i_Ip)
//============================================================================



static void Test_Uc_BFu7i_L()
{
  {
    init_simple_test("Uc_BFu7i_L");
    static STRUCT_IF_C Uc_BFu7i_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_L");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_L, Uc_BFu7i_L)
//============================================================================



static void Test_Uc_BFu7i_S()
{
  {
    init_simple_test("Uc_BFu7i_S");
    static STRUCT_IF_C Uc_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_S");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_S, Uc_BFu7i_S)
//============================================================================



static void Test_Uc_BFu7i_Uc()
{
  {
    init_simple_test("Uc_BFu7i_Uc");
    static STRUCT_IF_C Uc_BFu7i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_Uc, Uc_BFu7i_Uc)
//============================================================================



static void Test_Uc_BFu7i_Ui()
{
  {
    init_simple_test("Uc_BFu7i_Ui");
    static STRUCT_IF_C Uc_BFu7i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_Ui, Uc_BFu7i_Ui)
//============================================================================



static void Test_Uc_BFu7i_Ul()
{
  {
    init_simple_test("Uc_BFu7i_Ul");
    static STRUCT_IF_C Uc_BFu7i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_Ul, Uc_BFu7i_Ul)
//============================================================================



static void Test_Uc_BFu7i_Us()
{
  {
    init_simple_test("Uc_BFu7i_Us");
    static STRUCT_IF_C Uc_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_Us, Uc_BFu7i_Us)
//============================================================================



static void Test_Uc_BFu7i_Vp()
{
  {
    init_simple_test("Uc_BFu7i_Vp");
    static STRUCT_IF_C Uc_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7i_Vp, Uc_BFu7i_Vp)
//============================================================================



static void Test_Uc_BFu7ll()
{
  {
    init_simple_test("Uc_BFu7ll");
    static STRUCT_IF_C Uc_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll, Uc_BFu7ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu15i");
    static STRUCT_IF_C Uc_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu15i, Uc_BFu7ll_BFu15i)
//============================================================================



static void Test_Uc_BFu7ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu15ll, Uc_BFu7ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu15s");
    static STRUCT_IF_C Uc_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu15s, Uc_BFu7ll_BFu15s)
//============================================================================



static void Test_Uc_BFu7ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu16i");
    static STRUCT_IF_C Uc_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu16i, Uc_BFu7ll_BFu16i)
//============================================================================



static void Test_Uc_BFu7ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu16ll, Uc_BFu7ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu16s");
    static STRUCT_IF_C Uc_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu16s, Uc_BFu7ll_BFu16s)
//============================================================================



static void Test_Uc_BFu7ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu17i");
    static STRUCT_IF_C Uc_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu17i, Uc_BFu7ll_BFu17i)
//============================================================================



static void Test_Uc_BFu7ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu17ll, Uc_BFu7ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu7ll_BFu1c");
    static STRUCT_IF_C Uc_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu1c, Uc_BFu7ll_BFu1c)
//============================================================================



static void Test_Uc_BFu7ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu1i");
    static STRUCT_IF_C Uc_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu1i, Uc_BFu7ll_BFu1i)
//============================================================================



static void Test_Uc_BFu7ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu1ll, Uc_BFu7ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu1s");
    static STRUCT_IF_C Uc_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu1s, Uc_BFu7ll_BFu1s)
//============================================================================



static void Test_Uc_BFu7ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu31i");
    static STRUCT_IF_C Uc_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu31i, Uc_BFu7ll_BFu31i)
//============================================================================



static void Test_Uc_BFu7ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu31ll, Uc_BFu7ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu32i");
    static STRUCT_IF_C Uc_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu32i, Uc_BFu7ll_BFu32i)
//============================================================================



static void Test_Uc_BFu7ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu32ll, Uc_BFu7ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu33()
{
  {
    init_simple_test("Uc_BFu7ll_BFu33");
    static STRUCT_IF_C Uc_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Uc_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Uc_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu33, Uc_BFu7ll_BFu33)
//============================================================================



static void Test_Uc_BFu7ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu7ll_BFu7c");
    static STRUCT_IF_C Uc_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu7c, Uc_BFu7ll_BFu7c)
//============================================================================



static void Test_Uc_BFu7ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu7i");
    static STRUCT_IF_C Uc_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu7i, Uc_BFu7ll_BFu7i)
//============================================================================



static void Test_Uc_BFu7ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu7ll, Uc_BFu7ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu7s");
    static STRUCT_IF_C Uc_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu7s, Uc_BFu7ll_BFu7s)
//============================================================================



static void Test_Uc_BFu7ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu7ll_BFu8c");
    static STRUCT_IF_C Uc_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu8c, Uc_BFu7ll_BFu8c)
//============================================================================



static void Test_Uc_BFu7ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu8i");
    static STRUCT_IF_C Uc_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu8i, Uc_BFu7ll_BFu8i)
//============================================================================



static void Test_Uc_BFu7ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu8ll, Uc_BFu7ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu8s");
    static STRUCT_IF_C Uc_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu8s, Uc_BFu7ll_BFu8s)
//============================================================================



static void Test_Uc_BFu7ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu9i");
    static STRUCT_IF_C Uc_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu9i, Uc_BFu7ll_BFu9i)
//============================================================================



static void Test_Uc_BFu7ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu9ll, Uc_BFu7ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu7ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu9s");
    static STRUCT_IF_C Uc_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_BFu9s, Uc_BFu7ll_BFu9s)
//============================================================================



static void Test_Uc_BFu7ll_C()
{
  {
    init_simple_test("Uc_BFu7ll_C");
    static STRUCT_IF_C Uc_BFu7ll_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_C");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_C, Uc_BFu7ll_C)
//============================================================================



static void Test_Uc_BFu7ll_D()
{
  {
    init_simple_test("Uc_BFu7ll_D");
    static STRUCT_IF_C Uc_BFu7ll_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_D");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_D, Uc_BFu7ll_D)
//============================================================================



static void Test_Uc_BFu7ll_F()
{
  {
    init_simple_test("Uc_BFu7ll_F");
    static STRUCT_IF_C Uc_BFu7ll_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_F");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_F, Uc_BFu7ll_F)
//============================================================================



static void Test_Uc_BFu7ll_I()
{
  {
    init_simple_test("Uc_BFu7ll_I");
    static STRUCT_IF_C Uc_BFu7ll_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_I");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_I, Uc_BFu7ll_I)
//============================================================================



static void Test_Uc_BFu7ll_Ip()
{
  {
    init_simple_test("Uc_BFu7ll_Ip");
    static STRUCT_IF_C Uc_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_Ip, Uc_BFu7ll_Ip)
//============================================================================



static void Test_Uc_BFu7ll_L()
{
  {
    init_simple_test("Uc_BFu7ll_L");
    static STRUCT_IF_C Uc_BFu7ll_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_L");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_L, Uc_BFu7ll_L)
//============================================================================



static void Test_Uc_BFu7ll_S()
{
  {
    init_simple_test("Uc_BFu7ll_S");
    static STRUCT_IF_C Uc_BFu7ll_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_S");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_S, Uc_BFu7ll_S)
//============================================================================



static void Test_Uc_BFu7ll_Uc()
{
  {
    init_simple_test("Uc_BFu7ll_Uc");
    static STRUCT_IF_C Uc_BFu7ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_Uc, Uc_BFu7ll_Uc)
//============================================================================



static void Test_Uc_BFu7ll_Ui()
{
  {
    init_simple_test("Uc_BFu7ll_Ui");
    static STRUCT_IF_C Uc_BFu7ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_Ui, Uc_BFu7ll_Ui)
//============================================================================



static void Test_Uc_BFu7ll_Ul()
{
  {
    init_simple_test("Uc_BFu7ll_Ul");
    static STRUCT_IF_C Uc_BFu7ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_Ul, Uc_BFu7ll_Ul)
//============================================================================



static void Test_Uc_BFu7ll_Us()
{
  {
    init_simple_test("Uc_BFu7ll_Us");
    static STRUCT_IF_C Uc_BFu7ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_Us, Uc_BFu7ll_Us)
//============================================================================



static void Test_Uc_BFu7ll_Vp()
{
  {
    init_simple_test("Uc_BFu7ll_Vp");
    static STRUCT_IF_C Uc_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7ll_Vp, Uc_BFu7ll_Vp)
//============================================================================



static void Test_Uc_BFu7s()
{
  {
    init_simple_test("Uc_BFu7s");
    static STRUCT_IF_C Uc_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s, Uc_BFu7s)
//============================================================================



static void Test_Uc_BFu7s_BFu15i()
{
  {
    init_simple_test("Uc_BFu7s_BFu15i");
    static STRUCT_IF_C Uc_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu15i, Uc_BFu7s_BFu15i)
//============================================================================



static void Test_Uc_BFu7s_BFu15ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu15ll");
    static STRUCT_IF_C Uc_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu15ll, Uc_BFu7s_BFu15ll)
//============================================================================



static void Test_Uc_BFu7s_BFu15s()
{
  {
    init_simple_test("Uc_BFu7s_BFu15s");
    static STRUCT_IF_C Uc_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Uc_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Uc_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu15s, Uc_BFu7s_BFu15s)
//============================================================================



static void Test_Uc_BFu7s_BFu16i()
{
  {
    init_simple_test("Uc_BFu7s_BFu16i");
    static STRUCT_IF_C Uc_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu16i, Uc_BFu7s_BFu16i)
//============================================================================



static void Test_Uc_BFu7s_BFu16ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu16ll");
    static STRUCT_IF_C Uc_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu16ll, Uc_BFu7s_BFu16ll)
//============================================================================



static void Test_Uc_BFu7s_BFu16s()
{
  {
    init_simple_test("Uc_BFu7s_BFu16s");
    static STRUCT_IF_C Uc_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Uc_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Uc_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu16s, Uc_BFu7s_BFu16s)
//============================================================================



static void Test_Uc_BFu7s_BFu17i()
{
  {
    init_simple_test("Uc_BFu7s_BFu17i");
    static STRUCT_IF_C Uc_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu17i, Uc_BFu7s_BFu17i)
//============================================================================



static void Test_Uc_BFu7s_BFu17ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu17ll");
    static STRUCT_IF_C Uc_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Uc_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Uc_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu17ll, Uc_BFu7s_BFu17ll)
//============================================================================



static void Test_Uc_BFu7s_BFu1c()
{
  {
    init_simple_test("Uc_BFu7s_BFu1c");
    static STRUCT_IF_C Uc_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu1c, Uc_BFu7s_BFu1c)
//============================================================================



static void Test_Uc_BFu7s_BFu1i()
{
  {
    init_simple_test("Uc_BFu7s_BFu1i");
    static STRUCT_IF_C Uc_BFu7s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu1i, Uc_BFu7s_BFu1i)
//============================================================================



static void Test_Uc_BFu7s_BFu1ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu1ll");
    static STRUCT_IF_C Uc_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu1ll, Uc_BFu7s_BFu1ll)
//============================================================================



static void Test_Uc_BFu7s_BFu1s()
{
  {
    init_simple_test("Uc_BFu7s_BFu1s");
    static STRUCT_IF_C Uc_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Uc_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu1s, Uc_BFu7s_BFu1s)
//============================================================================



static void Test_Uc_BFu7s_BFu31i()
{
  {
    init_simple_test("Uc_BFu7s_BFu31i");
    static STRUCT_IF_C Uc_BFu7s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu31i, Uc_BFu7s_BFu31i)
//============================================================================



static void Test_Uc_BFu7s_BFu31ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu31ll");
    static STRUCT_IF_C Uc_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Uc_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Uc_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu31ll, Uc_BFu7s_BFu31ll)
//============================================================================



static void Test_Uc_BFu7s_BFu32i()
{
  {
    init_simple_test("Uc_BFu7s_BFu32i");
    static STRUCT_IF_C Uc_BFu7s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu32i, Uc_BFu7s_BFu32i)
//============================================================================



static void Test_Uc_BFu7s_BFu32ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu32ll");
    static STRUCT_IF_C Uc_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Uc_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Uc_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu32ll, Uc_BFu7s_BFu32ll)
//============================================================================



static void Test_Uc_BFu7s_BFu33()
{
  {
    init_simple_test("Uc_BFu7s_BFu33");
    static STRUCT_IF_C Uc_BFu7s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Uc_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Uc_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu33, Uc_BFu7s_BFu33)
//============================================================================



static void Test_Uc_BFu7s_BFu7c()
{
  {
    init_simple_test("Uc_BFu7s_BFu7c");
    static STRUCT_IF_C Uc_BFu7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu7c, Uc_BFu7s_BFu7c)
//============================================================================



static void Test_Uc_BFu7s_BFu7i()
{
  {
    init_simple_test("Uc_BFu7s_BFu7i");
    static STRUCT_IF_C Uc_BFu7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu7i, Uc_BFu7s_BFu7i)
//============================================================================



static void Test_Uc_BFu7s_BFu7ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu7ll");
    static STRUCT_IF_C Uc_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu7ll, Uc_BFu7s_BFu7ll)
//============================================================================



static void Test_Uc_BFu7s_BFu7s()
{
  {
    init_simple_test("Uc_BFu7s_BFu7s");
    static STRUCT_IF_C Uc_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Uc_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu7s, Uc_BFu7s_BFu7s)
//============================================================================



static void Test_Uc_BFu7s_BFu8c()
{
  {
    init_simple_test("Uc_BFu7s_BFu8c");
    static STRUCT_IF_C Uc_BFu7s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu8c, Uc_BFu7s_BFu8c)
//============================================================================



static void Test_Uc_BFu7s_BFu8i()
{
  {
    init_simple_test("Uc_BFu7s_BFu8i");
    static STRUCT_IF_C Uc_BFu7s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu8i, Uc_BFu7s_BFu8i)
//============================================================================



static void Test_Uc_BFu7s_BFu8ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu8ll");
    static STRUCT_IF_C Uc_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu8ll, Uc_BFu7s_BFu8ll)
//============================================================================



static void Test_Uc_BFu7s_BFu8s()
{
  {
    init_simple_test("Uc_BFu7s_BFu8s");
    static STRUCT_IF_C Uc_BFu7s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Uc_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Uc_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu8s, Uc_BFu7s_BFu8s)
//============================================================================



static void Test_Uc_BFu7s_BFu9i()
{
  {
    init_simple_test("Uc_BFu7s_BFu9i");
    static STRUCT_IF_C Uc_BFu7s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu9i, Uc_BFu7s_BFu9i)
//============================================================================



static void Test_Uc_BFu7s_BFu9ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu9ll");
    static STRUCT_IF_C Uc_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu9ll, Uc_BFu7s_BFu9ll)
//============================================================================



static void Test_Uc_BFu7s_BFu9s()
{
  {
    init_simple_test("Uc_BFu7s_BFu9s");
    static STRUCT_IF_C Uc_BFu7s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Uc_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Uc_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_BFu9s, Uc_BFu7s_BFu9s)
//============================================================================



static void Test_Uc_BFu7s_C()
{
  {
    init_simple_test("Uc_BFu7s_C");
    static STRUCT_IF_C Uc_BFu7s_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_C");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_C, Uc_BFu7s_C)
//============================================================================



static void Test_Uc_BFu7s_D()
{
  {
    init_simple_test("Uc_BFu7s_D");
    static STRUCT_IF_C Uc_BFu7s_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_D");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_D, Uc_BFu7s_D)
//============================================================================



static void Test_Uc_BFu7s_F()
{
  {
    init_simple_test("Uc_BFu7s_F");
    static STRUCT_IF_C Uc_BFu7s_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_F");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_F, Uc_BFu7s_F)
//============================================================================



static void Test_Uc_BFu7s_I()
{
  {
    init_simple_test("Uc_BFu7s_I");
    static STRUCT_IF_C Uc_BFu7s_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_I");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_I, Uc_BFu7s_I)
//============================================================================



static void Test_Uc_BFu7s_Ip()
{
  {
    init_simple_test("Uc_BFu7s_Ip");
    static STRUCT_IF_C Uc_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_Ip, Uc_BFu7s_Ip)
//============================================================================



static void Test_Uc_BFu7s_L()
{
  {
    init_simple_test("Uc_BFu7s_L");
    static STRUCT_IF_C Uc_BFu7s_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_L");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_L, Uc_BFu7s_L)
//============================================================================



static void Test_Uc_BFu7s_S()
{
  {
    init_simple_test("Uc_BFu7s_S");
    static STRUCT_IF_C Uc_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_S");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_S, Uc_BFu7s_S)
//============================================================================



static void Test_Uc_BFu7s_Uc()
{
  {
    init_simple_test("Uc_BFu7s_Uc");
    static STRUCT_IF_C Uc_BFu7s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_Uc, Uc_BFu7s_Uc)
//============================================================================



static void Test_Uc_BFu7s_Ui()
{
  {
    init_simple_test("Uc_BFu7s_Ui");
    static STRUCT_IF_C Uc_BFu7s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_Ui, Uc_BFu7s_Ui)
//============================================================================



static void Test_Uc_BFu7s_Ul()
{
  {
    init_simple_test("Uc_BFu7s_Ul");
    static STRUCT_IF_C Uc_BFu7s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_Ul, Uc_BFu7s_Ul)
//============================================================================



static void Test_Uc_BFu7s_Us()
{
  {
    init_simple_test("Uc_BFu7s_Us");
    static STRUCT_IF_C Uc_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_Us, Uc_BFu7s_Us)
//============================================================================



static void Test_Uc_BFu7s_Vp()
{
  {
    init_simple_test("Uc_BFu7s_Vp");
    static STRUCT_IF_C Uc_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu7s_Vp, Uc_BFu7s_Vp)
//============================================================================



static void Test_Uc_BFu8c()
{
  {
    init_simple_test("Uc_BFu8c");
    static STRUCT_IF_C Uc_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c, Uc_BFu8c)
//============================================================================



static void Test_Uc_BFu8c_BFu15i()
{
  {
    init_simple_test("Uc_BFu8c_BFu15i");
    static STRUCT_IF_C Uc_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu15i, Uc_BFu8c_BFu15i)
//============================================================================



static void Test_Uc_BFu8c_BFu15ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu15ll");
    static STRUCT_IF_C Uc_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu15ll, Uc_BFu8c_BFu15ll)
//============================================================================



static void Test_Uc_BFu8c_BFu15s()
{
  {
    init_simple_test("Uc_BFu8c_BFu15s");
    static STRUCT_IF_C Uc_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu15s, Uc_BFu8c_BFu15s)
//============================================================================



static void Test_Uc_BFu8c_BFu16i()
{
  {
    init_simple_test("Uc_BFu8c_BFu16i");
    static STRUCT_IF_C Uc_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu16i, Uc_BFu8c_BFu16i)
//============================================================================



static void Test_Uc_BFu8c_BFu16ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu16ll");
    static STRUCT_IF_C Uc_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu16ll, Uc_BFu8c_BFu16ll)
//============================================================================



static void Test_Uc_BFu8c_BFu16s()
{
  {
    init_simple_test("Uc_BFu8c_BFu16s");
    static STRUCT_IF_C Uc_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu16s, Uc_BFu8c_BFu16s)
//============================================================================



static void Test_Uc_BFu8c_BFu17i()
{
  {
    init_simple_test("Uc_BFu8c_BFu17i");
    static STRUCT_IF_C Uc_BFu8c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu17i, Uc_BFu8c_BFu17i)
//============================================================================



static void Test_Uc_BFu8c_BFu17ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu17ll");
    static STRUCT_IF_C Uc_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu17ll, Uc_BFu8c_BFu17ll)
//============================================================================



static void Test_Uc_BFu8c_BFu1c()
{
  {
    init_simple_test("Uc_BFu8c_BFu1c");
    static STRUCT_IF_C Uc_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu1c, Uc_BFu8c_BFu1c)
//============================================================================



static void Test_Uc_BFu8c_BFu1i()
{
  {
    init_simple_test("Uc_BFu8c_BFu1i");
    static STRUCT_IF_C Uc_BFu8c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu1i, Uc_BFu8c_BFu1i)
//============================================================================



static void Test_Uc_BFu8c_BFu1ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu1ll");
    static STRUCT_IF_C Uc_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu1ll, Uc_BFu8c_BFu1ll)
//============================================================================



static void Test_Uc_BFu8c_BFu1s()
{
  {
    init_simple_test("Uc_BFu8c_BFu1s");
    static STRUCT_IF_C Uc_BFu8c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu1s, Uc_BFu8c_BFu1s)
//============================================================================



static void Test_Uc_BFu8c_BFu31i()
{
  {
    init_simple_test("Uc_BFu8c_BFu31i");
    static STRUCT_IF_C Uc_BFu8c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu31i, Uc_BFu8c_BFu31i)
//============================================================================



static void Test_Uc_BFu8c_BFu31ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu31ll");
    static STRUCT_IF_C Uc_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu31ll, Uc_BFu8c_BFu31ll)
//============================================================================



static void Test_Uc_BFu8c_BFu32i()
{
  {
    init_simple_test("Uc_BFu8c_BFu32i");
    static STRUCT_IF_C Uc_BFu8c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu32i, Uc_BFu8c_BFu32i)
//============================================================================



static void Test_Uc_BFu8c_BFu32ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu32ll");
    static STRUCT_IF_C Uc_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu32ll, Uc_BFu8c_BFu32ll)
//============================================================================



static void Test_Uc_BFu8c_BFu33()
{
  {
    init_simple_test("Uc_BFu8c_BFu33");
    static STRUCT_IF_C Uc_BFu8c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Uc_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Uc_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu33, Uc_BFu8c_BFu33)
//============================================================================



static void Test_Uc_BFu8c_BFu7c()
{
  {
    init_simple_test("Uc_BFu8c_BFu7c");
    static STRUCT_IF_C Uc_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu7c, Uc_BFu8c_BFu7c)
//============================================================================



static void Test_Uc_BFu8c_BFu7i()
{
  {
    init_simple_test("Uc_BFu8c_BFu7i");
    static STRUCT_IF_C Uc_BFu8c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu7i, Uc_BFu8c_BFu7i)
//============================================================================



static void Test_Uc_BFu8c_BFu7ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu7ll");
    static STRUCT_IF_C Uc_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu7ll, Uc_BFu8c_BFu7ll)
//============================================================================



static void Test_Uc_BFu8c_BFu7s()
{
  {
    init_simple_test("Uc_BFu8c_BFu7s");
    static STRUCT_IF_C Uc_BFu8c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu7s, Uc_BFu8c_BFu7s)
//============================================================================



static void Test_Uc_BFu8c_BFu8c()
{
  {
    init_simple_test("Uc_BFu8c_BFu8c");
    static STRUCT_IF_C Uc_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu8c, Uc_BFu8c_BFu8c)
//============================================================================



static void Test_Uc_BFu8c_BFu8i()
{
  {
    init_simple_test("Uc_BFu8c_BFu8i");
    static STRUCT_IF_C Uc_BFu8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu8i, Uc_BFu8c_BFu8i)
//============================================================================



static void Test_Uc_BFu8c_BFu8ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu8ll");
    static STRUCT_IF_C Uc_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu8ll, Uc_BFu8c_BFu8ll)
//============================================================================



static void Test_Uc_BFu8c_BFu8s()
{
  {
    init_simple_test("Uc_BFu8c_BFu8s");
    static STRUCT_IF_C Uc_BFu8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu8s, Uc_BFu8c_BFu8s)
//============================================================================



static void Test_Uc_BFu8c_BFu9i()
{
  {
    init_simple_test("Uc_BFu8c_BFu9i");
    static STRUCT_IF_C Uc_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu9i, Uc_BFu8c_BFu9i)
//============================================================================



static void Test_Uc_BFu8c_BFu9ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu9ll");
    static STRUCT_IF_C Uc_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu9ll, Uc_BFu8c_BFu9ll)
//============================================================================



static void Test_Uc_BFu8c_BFu9s()
{
  {
    init_simple_test("Uc_BFu8c_BFu9s");
    static STRUCT_IF_C Uc_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_BFu9s, Uc_BFu8c_BFu9s)
//============================================================================



static void Test_Uc_BFu8c_C()
{
  {
    init_simple_test("Uc_BFu8c_C");
    static STRUCT_IF_C Uc_BFu8c_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_C");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_C, Uc_BFu8c_C)
//============================================================================



static void Test_Uc_BFu8c_D()
{
  {
    init_simple_test("Uc_BFu8c_D");
    static STRUCT_IF_C Uc_BFu8c_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_D");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_D, Uc_BFu8c_D)
//============================================================================



static void Test_Uc_BFu8c_F()
{
  {
    init_simple_test("Uc_BFu8c_F");
    static STRUCT_IF_C Uc_BFu8c_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_F");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_F, Uc_BFu8c_F)
//============================================================================



static void Test_Uc_BFu8c_I()
{
  {
    init_simple_test("Uc_BFu8c_I");
    static STRUCT_IF_C Uc_BFu8c_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_I");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_I, Uc_BFu8c_I)
//============================================================================



static void Test_Uc_BFu8c_Ip()
{
  {
    init_simple_test("Uc_BFu8c_Ip");
    static STRUCT_IF_C Uc_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_Ip, Uc_BFu8c_Ip)
//============================================================================



static void Test_Uc_BFu8c_L()
{
  {
    init_simple_test("Uc_BFu8c_L");
    static STRUCT_IF_C Uc_BFu8c_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_L");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_L, Uc_BFu8c_L)
//============================================================================



static void Test_Uc_BFu8c_S()
{
  {
    init_simple_test("Uc_BFu8c_S");
    static STRUCT_IF_C Uc_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_S");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_S, Uc_BFu8c_S)
//============================================================================



static void Test_Uc_BFu8c_Uc()
{
  {
    init_simple_test("Uc_BFu8c_Uc");
    static STRUCT_IF_C Uc_BFu8c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_Uc, Uc_BFu8c_Uc)
//============================================================================



static void Test_Uc_BFu8c_Ui()
{
  {
    init_simple_test("Uc_BFu8c_Ui");
    static STRUCT_IF_C Uc_BFu8c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_Ui, Uc_BFu8c_Ui)
//============================================================================



static void Test_Uc_BFu8c_Ul()
{
  {
    init_simple_test("Uc_BFu8c_Ul");
    static STRUCT_IF_C Uc_BFu8c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_Ul, Uc_BFu8c_Ul)
//============================================================================



static void Test_Uc_BFu8c_Us()
{
  {
    init_simple_test("Uc_BFu8c_Us");
    static STRUCT_IF_C Uc_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_Us, Uc_BFu8c_Us)
//============================================================================



static void Test_Uc_BFu8c_Vp()
{
  {
    init_simple_test("Uc_BFu8c_Vp");
    static STRUCT_IF_C Uc_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8c_Vp, Uc_BFu8c_Vp)
//============================================================================



static void Test_Uc_BFu8i()
{
  {
    init_simple_test("Uc_BFu8i");
    static STRUCT_IF_C Uc_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i, Uc_BFu8i)
//============================================================================



static void Test_Uc_BFu8i_BFu15i()
{
  {
    init_simple_test("Uc_BFu8i_BFu15i");
    static STRUCT_IF_C Uc_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu15i, Uc_BFu8i_BFu15i)
//============================================================================



static void Test_Uc_BFu8i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu15ll");
    static STRUCT_IF_C Uc_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu15ll, Uc_BFu8i_BFu15ll)
//============================================================================



static void Test_Uc_BFu8i_BFu15s()
{
  {
    init_simple_test("Uc_BFu8i_BFu15s");
    static STRUCT_IF_C Uc_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu15s, Uc_BFu8i_BFu15s)
//============================================================================



static void Test_Uc_BFu8i_BFu16i()
{
  {
    init_simple_test("Uc_BFu8i_BFu16i");
    static STRUCT_IF_C Uc_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu16i, Uc_BFu8i_BFu16i)
//============================================================================



static void Test_Uc_BFu8i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu16ll");
    static STRUCT_IF_C Uc_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu16ll, Uc_BFu8i_BFu16ll)
//============================================================================



static void Test_Uc_BFu8i_BFu16s()
{
  {
    init_simple_test("Uc_BFu8i_BFu16s");
    static STRUCT_IF_C Uc_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu16s, Uc_BFu8i_BFu16s)
//============================================================================



static void Test_Uc_BFu8i_BFu17i()
{
  {
    init_simple_test("Uc_BFu8i_BFu17i");
    static STRUCT_IF_C Uc_BFu8i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu17i, Uc_BFu8i_BFu17i)
//============================================================================



static void Test_Uc_BFu8i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu17ll");
    static STRUCT_IF_C Uc_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu17ll, Uc_BFu8i_BFu17ll)
//============================================================================



static void Test_Uc_BFu8i_BFu1c()
{
  {
    init_simple_test("Uc_BFu8i_BFu1c");
    static STRUCT_IF_C Uc_BFu8i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu1c, Uc_BFu8i_BFu1c)
//============================================================================



static void Test_Uc_BFu8i_BFu1i()
{
  {
    init_simple_test("Uc_BFu8i_BFu1i");
    static STRUCT_IF_C Uc_BFu8i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu1i, Uc_BFu8i_BFu1i)
//============================================================================



static void Test_Uc_BFu8i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu1ll");
    static STRUCT_IF_C Uc_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu1ll, Uc_BFu8i_BFu1ll)
//============================================================================



static void Test_Uc_BFu8i_BFu1s()
{
  {
    init_simple_test("Uc_BFu8i_BFu1s");
    static STRUCT_IF_C Uc_BFu8i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu1s, Uc_BFu8i_BFu1s)
//============================================================================



static void Test_Uc_BFu8i_BFu31i()
{
  {
    init_simple_test("Uc_BFu8i_BFu31i");
    static STRUCT_IF_C Uc_BFu8i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu31i, Uc_BFu8i_BFu31i)
//============================================================================



static void Test_Uc_BFu8i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu31ll");
    static STRUCT_IF_C Uc_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu31ll, Uc_BFu8i_BFu31ll)
//============================================================================



static void Test_Uc_BFu8i_BFu32i()
{
  {
    init_simple_test("Uc_BFu8i_BFu32i");
    static STRUCT_IF_C Uc_BFu8i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu32i, Uc_BFu8i_BFu32i)
//============================================================================



static void Test_Uc_BFu8i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu32ll");
    static STRUCT_IF_C Uc_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu32ll, Uc_BFu8i_BFu32ll)
//============================================================================



static void Test_Uc_BFu8i_BFu33()
{
  {
    init_simple_test("Uc_BFu8i_BFu33");
    static STRUCT_IF_C Uc_BFu8i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Uc_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Uc_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu33, Uc_BFu8i_BFu33)
//============================================================================



static void Test_Uc_BFu8i_BFu7c()
{
  {
    init_simple_test("Uc_BFu8i_BFu7c");
    static STRUCT_IF_C Uc_BFu8i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu7c, Uc_BFu8i_BFu7c)
//============================================================================



static void Test_Uc_BFu8i_BFu7i()
{
  {
    init_simple_test("Uc_BFu8i_BFu7i");
    static STRUCT_IF_C Uc_BFu8i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu7i, Uc_BFu8i_BFu7i)
//============================================================================



static void Test_Uc_BFu8i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu7ll");
    static STRUCT_IF_C Uc_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu7ll, Uc_BFu8i_BFu7ll)
//============================================================================



static void Test_Uc_BFu8i_BFu7s()
{
  {
    init_simple_test("Uc_BFu8i_BFu7s");
    static STRUCT_IF_C Uc_BFu8i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu7s, Uc_BFu8i_BFu7s)
//============================================================================



static void Test_Uc_BFu8i_BFu8c()
{
  {
    init_simple_test("Uc_BFu8i_BFu8c");
    static STRUCT_IF_C Uc_BFu8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu8c, Uc_BFu8i_BFu8c)
//============================================================================



static void Test_Uc_BFu8i_BFu8i()
{
  {
    init_simple_test("Uc_BFu8i_BFu8i");
    static STRUCT_IF_C Uc_BFu8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu8i, Uc_BFu8i_BFu8i)
//============================================================================



static void Test_Uc_BFu8i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu8ll");
    static STRUCT_IF_C Uc_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu8ll, Uc_BFu8i_BFu8ll)
//============================================================================



static void Test_Uc_BFu8i_BFu8s()
{
  {
    init_simple_test("Uc_BFu8i_BFu8s");
    static STRUCT_IF_C Uc_BFu8i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu8s, Uc_BFu8i_BFu8s)
//============================================================================



static void Test_Uc_BFu8i_BFu9i()
{
  {
    init_simple_test("Uc_BFu8i_BFu9i");
    static STRUCT_IF_C Uc_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu9i, Uc_BFu8i_BFu9i)
//============================================================================



static void Test_Uc_BFu8i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu9ll");
    static STRUCT_IF_C Uc_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu9ll, Uc_BFu8i_BFu9ll)
//============================================================================



static void Test_Uc_BFu8i_BFu9s()
{
  {
    init_simple_test("Uc_BFu8i_BFu9s");
    static STRUCT_IF_C Uc_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_BFu9s, Uc_BFu8i_BFu9s)
//============================================================================



static void Test_Uc_BFu8i_C()
{
  {
    init_simple_test("Uc_BFu8i_C");
    static STRUCT_IF_C Uc_BFu8i_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_C");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_C, Uc_BFu8i_C)
//============================================================================



static void Test_Uc_BFu8i_D()
{
  {
    init_simple_test("Uc_BFu8i_D");
    static STRUCT_IF_C Uc_BFu8i_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_D");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_D, Uc_BFu8i_D)
//============================================================================



static void Test_Uc_BFu8i_F()
{
  {
    init_simple_test("Uc_BFu8i_F");
    static STRUCT_IF_C Uc_BFu8i_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_F");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_F, Uc_BFu8i_F)
//============================================================================



static void Test_Uc_BFu8i_I()
{
  {
    init_simple_test("Uc_BFu8i_I");
    static STRUCT_IF_C Uc_BFu8i_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_I");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_I, Uc_BFu8i_I)
//============================================================================



static void Test_Uc_BFu8i_Ip()
{
  {
    init_simple_test("Uc_BFu8i_Ip");
    static STRUCT_IF_C Uc_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_Ip, Uc_BFu8i_Ip)
//============================================================================



static void Test_Uc_BFu8i_L()
{
  {
    init_simple_test("Uc_BFu8i_L");
    static STRUCT_IF_C Uc_BFu8i_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_L");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_L, Uc_BFu8i_L)
//============================================================================



static void Test_Uc_BFu8i_S()
{
  {
    init_simple_test("Uc_BFu8i_S");
    static STRUCT_IF_C Uc_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_S");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_S, Uc_BFu8i_S)
//============================================================================



static void Test_Uc_BFu8i_Uc()
{
  {
    init_simple_test("Uc_BFu8i_Uc");
    static STRUCT_IF_C Uc_BFu8i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_Uc, Uc_BFu8i_Uc)
//============================================================================



static void Test_Uc_BFu8i_Ui()
{
  {
    init_simple_test("Uc_BFu8i_Ui");
    static STRUCT_IF_C Uc_BFu8i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_Ui, Uc_BFu8i_Ui)
//============================================================================



static void Test_Uc_BFu8i_Ul()
{
  {
    init_simple_test("Uc_BFu8i_Ul");
    static STRUCT_IF_C Uc_BFu8i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_Ul, Uc_BFu8i_Ul)
//============================================================================



static void Test_Uc_BFu8i_Us()
{
  {
    init_simple_test("Uc_BFu8i_Us");
    static STRUCT_IF_C Uc_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_Us, Uc_BFu8i_Us)
//============================================================================



static void Test_Uc_BFu8i_Vp()
{
  {
    init_simple_test("Uc_BFu8i_Vp");
    static STRUCT_IF_C Uc_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8i_Vp, Uc_BFu8i_Vp)
//============================================================================



static void Test_Uc_BFu8ll()
{
  {
    init_simple_test("Uc_BFu8ll");
    static STRUCT_IF_C Uc_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll, Uc_BFu8ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu15i");
    static STRUCT_IF_C Uc_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu15i, Uc_BFu8ll_BFu15i)
//============================================================================



static void Test_Uc_BFu8ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu15ll, Uc_BFu8ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu15s");
    static STRUCT_IF_C Uc_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu15s, Uc_BFu8ll_BFu15s)
//============================================================================



static void Test_Uc_BFu8ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu16i");
    static STRUCT_IF_C Uc_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu16i, Uc_BFu8ll_BFu16i)
//============================================================================



static void Test_Uc_BFu8ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu16ll, Uc_BFu8ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu16s");
    static STRUCT_IF_C Uc_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu16s, Uc_BFu8ll_BFu16s)
//============================================================================



static void Test_Uc_BFu8ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu17i");
    static STRUCT_IF_C Uc_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu17i, Uc_BFu8ll_BFu17i)
//============================================================================



static void Test_Uc_BFu8ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu17ll, Uc_BFu8ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu8ll_BFu1c");
    static STRUCT_IF_C Uc_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu1c, Uc_BFu8ll_BFu1c)
//============================================================================



static void Test_Uc_BFu8ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu1i");
    static STRUCT_IF_C Uc_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu1i, Uc_BFu8ll_BFu1i)
//============================================================================



static void Test_Uc_BFu8ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu1ll, Uc_BFu8ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu1s");
    static STRUCT_IF_C Uc_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu1s, Uc_BFu8ll_BFu1s)
//============================================================================



static void Test_Uc_BFu8ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu31i");
    static STRUCT_IF_C Uc_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu31i, Uc_BFu8ll_BFu31i)
//============================================================================



static void Test_Uc_BFu8ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu31ll, Uc_BFu8ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu32i");
    static STRUCT_IF_C Uc_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu32i, Uc_BFu8ll_BFu32i)
//============================================================================



static void Test_Uc_BFu8ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu32ll, Uc_BFu8ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu33()
{
  {
    init_simple_test("Uc_BFu8ll_BFu33");
    static STRUCT_IF_C Uc_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Uc_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Uc_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu33, Uc_BFu8ll_BFu33)
//============================================================================



static void Test_Uc_BFu8ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu8ll_BFu7c");
    static STRUCT_IF_C Uc_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu7c, Uc_BFu8ll_BFu7c)
//============================================================================



static void Test_Uc_BFu8ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu7i");
    static STRUCT_IF_C Uc_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu7i, Uc_BFu8ll_BFu7i)
//============================================================================



static void Test_Uc_BFu8ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu7ll, Uc_BFu8ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu7s");
    static STRUCT_IF_C Uc_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu7s, Uc_BFu8ll_BFu7s)
//============================================================================



static void Test_Uc_BFu8ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu8ll_BFu8c");
    static STRUCT_IF_C Uc_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu8c, Uc_BFu8ll_BFu8c)
//============================================================================



static void Test_Uc_BFu8ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu8i");
    static STRUCT_IF_C Uc_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu8i, Uc_BFu8ll_BFu8i)
//============================================================================



static void Test_Uc_BFu8ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu8ll, Uc_BFu8ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu8s");
    static STRUCT_IF_C Uc_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu8s, Uc_BFu8ll_BFu8s)
//============================================================================



static void Test_Uc_BFu8ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu9i");
    static STRUCT_IF_C Uc_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu9i, Uc_BFu8ll_BFu9i)
//============================================================================



static void Test_Uc_BFu8ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu9ll, Uc_BFu8ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu8ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu9s");
    static STRUCT_IF_C Uc_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_BFu9s, Uc_BFu8ll_BFu9s)
//============================================================================



static void Test_Uc_BFu8ll_C()
{
  {
    init_simple_test("Uc_BFu8ll_C");
    static STRUCT_IF_C Uc_BFu8ll_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_C");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_C, Uc_BFu8ll_C)
//============================================================================



static void Test_Uc_BFu8ll_D()
{
  {
    init_simple_test("Uc_BFu8ll_D");
    static STRUCT_IF_C Uc_BFu8ll_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_D");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_D, Uc_BFu8ll_D)
//============================================================================



static void Test_Uc_BFu8ll_F()
{
  {
    init_simple_test("Uc_BFu8ll_F");
    static STRUCT_IF_C Uc_BFu8ll_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_F");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_F, Uc_BFu8ll_F)
//============================================================================



static void Test_Uc_BFu8ll_I()
{
  {
    init_simple_test("Uc_BFu8ll_I");
    static STRUCT_IF_C Uc_BFu8ll_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_I");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_I, Uc_BFu8ll_I)
//============================================================================



static void Test_Uc_BFu8ll_Ip()
{
  {
    init_simple_test("Uc_BFu8ll_Ip");
    static STRUCT_IF_C Uc_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_Ip, Uc_BFu8ll_Ip)
//============================================================================



static void Test_Uc_BFu8ll_L()
{
  {
    init_simple_test("Uc_BFu8ll_L");
    static STRUCT_IF_C Uc_BFu8ll_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_L");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_L, Uc_BFu8ll_L)
//============================================================================



static void Test_Uc_BFu8ll_S()
{
  {
    init_simple_test("Uc_BFu8ll_S");
    static STRUCT_IF_C Uc_BFu8ll_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_S");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_S, Uc_BFu8ll_S)
//============================================================================



static void Test_Uc_BFu8ll_Uc()
{
  {
    init_simple_test("Uc_BFu8ll_Uc");
    static STRUCT_IF_C Uc_BFu8ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_Uc, Uc_BFu8ll_Uc)
//============================================================================



static void Test_Uc_BFu8ll_Ui()
{
  {
    init_simple_test("Uc_BFu8ll_Ui");
    static STRUCT_IF_C Uc_BFu8ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_Ui, Uc_BFu8ll_Ui)
//============================================================================



static void Test_Uc_BFu8ll_Ul()
{
  {
    init_simple_test("Uc_BFu8ll_Ul");
    static STRUCT_IF_C Uc_BFu8ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_Ul, Uc_BFu8ll_Ul)
//============================================================================



static void Test_Uc_BFu8ll_Us()
{
  {
    init_simple_test("Uc_BFu8ll_Us");
    static STRUCT_IF_C Uc_BFu8ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_Us, Uc_BFu8ll_Us)
//============================================================================



static void Test_Uc_BFu8ll_Vp()
{
  {
    init_simple_test("Uc_BFu8ll_Vp");
    static STRUCT_IF_C Uc_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8ll_Vp, Uc_BFu8ll_Vp)
//============================================================================



static void Test_Uc_BFu8s()
{
  {
    init_simple_test("Uc_BFu8s");
    static STRUCT_IF_C Uc_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s, Uc_BFu8s)
//============================================================================



static void Test_Uc_BFu8s_BFu15i()
{
  {
    init_simple_test("Uc_BFu8s_BFu15i");
    static STRUCT_IF_C Uc_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu15i, Uc_BFu8s_BFu15i)
//============================================================================



static void Test_Uc_BFu8s_BFu15ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu15ll");
    static STRUCT_IF_C Uc_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu15ll, Uc_BFu8s_BFu15ll)
//============================================================================



static void Test_Uc_BFu8s_BFu15s()
{
  {
    init_simple_test("Uc_BFu8s_BFu15s");
    static STRUCT_IF_C Uc_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu15s, Uc_BFu8s_BFu15s)
//============================================================================



static void Test_Uc_BFu8s_BFu16i()
{
  {
    init_simple_test("Uc_BFu8s_BFu16i");
    static STRUCT_IF_C Uc_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu16i, Uc_BFu8s_BFu16i)
//============================================================================



static void Test_Uc_BFu8s_BFu16ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu16ll");
    static STRUCT_IF_C Uc_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu16ll, Uc_BFu8s_BFu16ll)
//============================================================================



static void Test_Uc_BFu8s_BFu16s()
{
  {
    init_simple_test("Uc_BFu8s_BFu16s");
    static STRUCT_IF_C Uc_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu16s, Uc_BFu8s_BFu16s)
//============================================================================



static void Test_Uc_BFu8s_BFu17i()
{
  {
    init_simple_test("Uc_BFu8s_BFu17i");
    static STRUCT_IF_C Uc_BFu8s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu17i, Uc_BFu8s_BFu17i)
//============================================================================



static void Test_Uc_BFu8s_BFu17ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu17ll");
    static STRUCT_IF_C Uc_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu17ll, Uc_BFu8s_BFu17ll)
//============================================================================



static void Test_Uc_BFu8s_BFu1c()
{
  {
    init_simple_test("Uc_BFu8s_BFu1c");
    static STRUCT_IF_C Uc_BFu8s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu1c, Uc_BFu8s_BFu1c)
//============================================================================



static void Test_Uc_BFu8s_BFu1i()
{
  {
    init_simple_test("Uc_BFu8s_BFu1i");
    static STRUCT_IF_C Uc_BFu8s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu1i, Uc_BFu8s_BFu1i)
//============================================================================



static void Test_Uc_BFu8s_BFu1ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu1ll");
    static STRUCT_IF_C Uc_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu1ll, Uc_BFu8s_BFu1ll)
//============================================================================



static void Test_Uc_BFu8s_BFu1s()
{
  {
    init_simple_test("Uc_BFu8s_BFu1s");
    static STRUCT_IF_C Uc_BFu8s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu1s, Uc_BFu8s_BFu1s)
//============================================================================



static void Test_Uc_BFu8s_BFu31i()
{
  {
    init_simple_test("Uc_BFu8s_BFu31i");
    static STRUCT_IF_C Uc_BFu8s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu31i, Uc_BFu8s_BFu31i)
//============================================================================



static void Test_Uc_BFu8s_BFu31ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu31ll");
    static STRUCT_IF_C Uc_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu31ll, Uc_BFu8s_BFu31ll)
//============================================================================



static void Test_Uc_BFu8s_BFu32i()
{
  {
    init_simple_test("Uc_BFu8s_BFu32i");
    static STRUCT_IF_C Uc_BFu8s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu32i, Uc_BFu8s_BFu32i)
//============================================================================



static void Test_Uc_BFu8s_BFu32ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu32ll");
    static STRUCT_IF_C Uc_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu32ll, Uc_BFu8s_BFu32ll)
//============================================================================



static void Test_Uc_BFu8s_BFu33()
{
  {
    init_simple_test("Uc_BFu8s_BFu33");
    static STRUCT_IF_C Uc_BFu8s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Uc_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Uc_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu33, Uc_BFu8s_BFu33)
//============================================================================



static void Test_Uc_BFu8s_BFu7c()
{
  {
    init_simple_test("Uc_BFu8s_BFu7c");
    static STRUCT_IF_C Uc_BFu8s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu7c, Uc_BFu8s_BFu7c)
//============================================================================



static void Test_Uc_BFu8s_BFu7i()
{
  {
    init_simple_test("Uc_BFu8s_BFu7i");
    static STRUCT_IF_C Uc_BFu8s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu7i, Uc_BFu8s_BFu7i)
//============================================================================



static void Test_Uc_BFu8s_BFu7ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu7ll");
    static STRUCT_IF_C Uc_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu7ll, Uc_BFu8s_BFu7ll)
//============================================================================



static void Test_Uc_BFu8s_BFu7s()
{
  {
    init_simple_test("Uc_BFu8s_BFu7s");
    static STRUCT_IF_C Uc_BFu8s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu7s, Uc_BFu8s_BFu7s)
//============================================================================



static void Test_Uc_BFu8s_BFu8c()
{
  {
    init_simple_test("Uc_BFu8s_BFu8c");
    static STRUCT_IF_C Uc_BFu8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu8c, Uc_BFu8s_BFu8c)
//============================================================================



static void Test_Uc_BFu8s_BFu8i()
{
  {
    init_simple_test("Uc_BFu8s_BFu8i");
    static STRUCT_IF_C Uc_BFu8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu8i, Uc_BFu8s_BFu8i)
//============================================================================



static void Test_Uc_BFu8s_BFu8ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu8ll");
    static STRUCT_IF_C Uc_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu8ll, Uc_BFu8s_BFu8ll)
//============================================================================



static void Test_Uc_BFu8s_BFu8s()
{
  {
    init_simple_test("Uc_BFu8s_BFu8s");
    static STRUCT_IF_C Uc_BFu8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu8s, Uc_BFu8s_BFu8s)
//============================================================================



static void Test_Uc_BFu8s_BFu9i()
{
  {
    init_simple_test("Uc_BFu8s_BFu9i");
    static STRUCT_IF_C Uc_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu9i, Uc_BFu8s_BFu9i)
//============================================================================



static void Test_Uc_BFu8s_BFu9ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu9ll");
    static STRUCT_IF_C Uc_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu9ll, Uc_BFu8s_BFu9ll)
//============================================================================



static void Test_Uc_BFu8s_BFu9s()
{
  {
    init_simple_test("Uc_BFu8s_BFu9s");
    static STRUCT_IF_C Uc_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_BFu9s, Uc_BFu8s_BFu9s)
//============================================================================



static void Test_Uc_BFu8s_C()
{
  {
    init_simple_test("Uc_BFu8s_C");
    static STRUCT_IF_C Uc_BFu8s_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_C");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_C, Uc_BFu8s_C)
//============================================================================



static void Test_Uc_BFu8s_D()
{
  {
    init_simple_test("Uc_BFu8s_D");
    static STRUCT_IF_C Uc_BFu8s_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_D");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_D, Uc_BFu8s_D)
//============================================================================



static void Test_Uc_BFu8s_F()
{
  {
    init_simple_test("Uc_BFu8s_F");
    static STRUCT_IF_C Uc_BFu8s_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_F");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_F, Uc_BFu8s_F)
//============================================================================



static void Test_Uc_BFu8s_I()
{
  {
    init_simple_test("Uc_BFu8s_I");
    static STRUCT_IF_C Uc_BFu8s_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_I");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_I, Uc_BFu8s_I)
//============================================================================



static void Test_Uc_BFu8s_Ip()
{
  {
    init_simple_test("Uc_BFu8s_Ip");
    static STRUCT_IF_C Uc_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_Ip");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_Ip, Uc_BFu8s_Ip)
//============================================================================



static void Test_Uc_BFu8s_L()
{
  {
    init_simple_test("Uc_BFu8s_L");
    static STRUCT_IF_C Uc_BFu8s_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_L");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_L, Uc_BFu8s_L)
//============================================================================



static void Test_Uc_BFu8s_S()
{
  {
    init_simple_test("Uc_BFu8s_S");
    static STRUCT_IF_C Uc_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_S");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_S, Uc_BFu8s_S)
//============================================================================



static void Test_Uc_BFu8s_Uc()
{
  {
    init_simple_test("Uc_BFu8s_Uc");
    static STRUCT_IF_C Uc_BFu8s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_Uc, Uc_BFu8s_Uc)
//============================================================================



static void Test_Uc_BFu8s_Ui()
{
  {
    init_simple_test("Uc_BFu8s_Ui");
    static STRUCT_IF_C Uc_BFu8s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_Ui");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_Ui, Uc_BFu8s_Ui)
//============================================================================



static void Test_Uc_BFu8s_Ul()
{
  {
    init_simple_test("Uc_BFu8s_Ul");
    static STRUCT_IF_C Uc_BFu8s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_Ul");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_Ul, Uc_BFu8s_Ul)
//============================================================================



static void Test_Uc_BFu8s_Us()
{
  {
    init_simple_test("Uc_BFu8s_Us");
    static STRUCT_IF_C Uc_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_Us");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_Us, Uc_BFu8s_Us)
//============================================================================



static void Test_Uc_BFu8s_Vp()
{
  {
    init_simple_test("Uc_BFu8s_Vp");
    static STRUCT_IF_C Uc_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_Vp");
    check_field_offset(lv, v3, 2, "Uc_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu8s_Vp, Uc_BFu8s_Vp)
//============================================================================



static void Test_Uc_BFu9i()
{
  {
    init_simple_test("Uc_BFu9i");
    static STRUCT_IF_C Uc_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i, Uc_BFu9i)
//============================================================================



static void Test_Uc_BFu9i_BFu15i()
{
  {
    init_simple_test("Uc_BFu9i_BFu15i");
    static STRUCT_IF_C Uc_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu15i, Uc_BFu9i_BFu15i)
//============================================================================



static void Test_Uc_BFu9i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu15ll");
    static STRUCT_IF_C Uc_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu15ll, Uc_BFu9i_BFu15ll)
//============================================================================



static void Test_Uc_BFu9i_BFu15s()
{
  {
    init_simple_test("Uc_BFu9i_BFu15s");
    static STRUCT_IF_C Uc_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu15s, Uc_BFu9i_BFu15s)
//============================================================================



static void Test_Uc_BFu9i_BFu16i()
{
  {
    init_simple_test("Uc_BFu9i_BFu16i");
    static STRUCT_IF_C Uc_BFu9i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu16i, Uc_BFu9i_BFu16i)
//============================================================================



static void Test_Uc_BFu9i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu16ll");
    static STRUCT_IF_C Uc_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu16ll, Uc_BFu9i_BFu16ll)
//============================================================================



static void Test_Uc_BFu9i_BFu16s()
{
  {
    init_simple_test("Uc_BFu9i_BFu16s");
    static STRUCT_IF_C Uc_BFu9i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu16s, Uc_BFu9i_BFu16s)
//============================================================================



static void Test_Uc_BFu9i_BFu17i()
{
  {
    init_simple_test("Uc_BFu9i_BFu17i");
    static STRUCT_IF_C Uc_BFu9i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Uc_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Uc_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu17i, Uc_BFu9i_BFu17i)
//============================================================================



static void Test_Uc_BFu9i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu17ll");
    static STRUCT_IF_C Uc_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Uc_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Uc_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu17ll, Uc_BFu9i_BFu17ll)
//============================================================================



static void Test_Uc_BFu9i_BFu1c()
{
  {
    init_simple_test("Uc_BFu9i_BFu1c");
    static STRUCT_IF_C Uc_BFu9i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu1c, Uc_BFu9i_BFu1c)
//============================================================================



static void Test_Uc_BFu9i_BFu1i()
{
  {
    init_simple_test("Uc_BFu9i_BFu1i");
    static STRUCT_IF_C Uc_BFu9i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu1i, Uc_BFu9i_BFu1i)
//============================================================================



static void Test_Uc_BFu9i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu1ll");
    static STRUCT_IF_C Uc_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu1ll, Uc_BFu9i_BFu1ll)
//============================================================================



static void Test_Uc_BFu9i_BFu1s()
{
  {
    init_simple_test("Uc_BFu9i_BFu1s");
    static STRUCT_IF_C Uc_BFu9i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu1s, Uc_BFu9i_BFu1s)
//============================================================================



static void Test_Uc_BFu9i_BFu31i()
{
  {
    init_simple_test("Uc_BFu9i_BFu31i");
    static STRUCT_IF_C Uc_BFu9i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Uc_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Uc_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu31i, Uc_BFu9i_BFu31i)
//============================================================================



static void Test_Uc_BFu9i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu31ll");
    static STRUCT_IF_C Uc_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Uc_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Uc_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu31ll, Uc_BFu9i_BFu31ll)
//============================================================================



static void Test_Uc_BFu9i_BFu32i()
{
  {
    init_simple_test("Uc_BFu9i_BFu32i");
    static STRUCT_IF_C Uc_BFu9i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Uc_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Uc_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu32i, Uc_BFu9i_BFu32i)
//============================================================================



static void Test_Uc_BFu9i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu32ll");
    static STRUCT_IF_C Uc_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Uc_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Uc_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu32ll, Uc_BFu9i_BFu32ll)
//============================================================================



static void Test_Uc_BFu9i_BFu33()
{
  {
    init_simple_test("Uc_BFu9i_BFu33");
    static STRUCT_IF_C Uc_BFu9i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Uc_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Uc_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu33, Uc_BFu9i_BFu33)
//============================================================================



static void Test_Uc_BFu9i_BFu7c()
{
  {
    init_simple_test("Uc_BFu9i_BFu7c");
    static STRUCT_IF_C Uc_BFu9i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu7c, Uc_BFu9i_BFu7c)
//============================================================================



static void Test_Uc_BFu9i_BFu7i()
{
  {
    init_simple_test("Uc_BFu9i_BFu7i");
    static STRUCT_IF_C Uc_BFu9i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu7i, Uc_BFu9i_BFu7i)
//============================================================================



static void Test_Uc_BFu9i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu7ll");
    static STRUCT_IF_C Uc_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu7ll, Uc_BFu9i_BFu7ll)
//============================================================================



static void Test_Uc_BFu9i_BFu7s()
{
  {
    init_simple_test("Uc_BFu9i_BFu7s");
    static STRUCT_IF_C Uc_BFu9i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu7s, Uc_BFu9i_BFu7s)
//============================================================================



static void Test_Uc_BFu9i_BFu8c()
{
  {
    init_simple_test("Uc_BFu9i_BFu8c");
    static STRUCT_IF_C Uc_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu8c, Uc_BFu9i_BFu8c)
//============================================================================



static void Test_Uc_BFu9i_BFu8i()
{
  {
    init_simple_test("Uc_BFu9i_BFu8i");
    static STRUCT_IF_C Uc_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu8i, Uc_BFu9i_BFu8i)
//============================================================================



static void Test_Uc_BFu9i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu8ll");
    static STRUCT_IF_C Uc_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu8ll, Uc_BFu9i_BFu8ll)
//============================================================================



static void Test_Uc_BFu9i_BFu8s()
{
  {
    init_simple_test("Uc_BFu9i_BFu8s");
    static STRUCT_IF_C Uc_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu8s, Uc_BFu9i_BFu8s)
//============================================================================



static void Test_Uc_BFu9i_BFu9i()
{
  {
    init_simple_test("Uc_BFu9i_BFu9i");
    static STRUCT_IF_C Uc_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu9i, Uc_BFu9i_BFu9i)
//============================================================================



static void Test_Uc_BFu9i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu9ll");
    static STRUCT_IF_C Uc_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu9ll, Uc_BFu9i_BFu9ll)
//============================================================================



static void Test_Uc_BFu9i_BFu9s()
{
  {
    init_simple_test("Uc_BFu9i_BFu9s");
    static STRUCT_IF_C Uc_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_BFu9s, Uc_BFu9i_BFu9s)
//============================================================================



static void Test_Uc_BFu9i_C()
{
  {
    init_simple_test("Uc_BFu9i_C");
    static STRUCT_IF_C Uc_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_C");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_C, Uc_BFu9i_C)
//============================================================================



static void Test_Uc_BFu9i_D()
{
  {
    init_simple_test("Uc_BFu9i_D");
    static STRUCT_IF_C Uc_BFu9i_D lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_D");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_D, Uc_BFu9i_D)
//============================================================================



static void Test_Uc_BFu9i_F()
{
  {
    init_simple_test("Uc_BFu9i_F");
    static STRUCT_IF_C Uc_BFu9i_F lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_F");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_F, Uc_BFu9i_F)
//============================================================================



static void Test_Uc_BFu9i_I()
{
  {
    init_simple_test("Uc_BFu9i_I");
    static STRUCT_IF_C Uc_BFu9i_I lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_I");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_I, Uc_BFu9i_I)
//============================================================================



static void Test_Uc_BFu9i_Ip()
{
  {
    init_simple_test("Uc_BFu9i_Ip");
    static STRUCT_IF_C Uc_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_Ip");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_Ip, Uc_BFu9i_Ip)
//============================================================================



static void Test_Uc_BFu9i_L()
{
  {
    init_simple_test("Uc_BFu9i_L");
    static STRUCT_IF_C Uc_BFu9i_L lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_L");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_L, Uc_BFu9i_L)
//============================================================================



static void Test_Uc_BFu9i_S()
{
  {
    init_simple_test("Uc_BFu9i_S");
    static STRUCT_IF_C Uc_BFu9i_S lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_S");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_S, Uc_BFu9i_S)
//============================================================================



static void Test_Uc_BFu9i_Uc()
{
  {
    init_simple_test("Uc_BFu9i_Uc");
    static STRUCT_IF_C Uc_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_Uc, Uc_BFu9i_Uc)
//============================================================================



static void Test_Uc_BFu9i_Ui()
{
  {
    init_simple_test("Uc_BFu9i_Ui");
    static STRUCT_IF_C Uc_BFu9i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_Ui");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_Ui, Uc_BFu9i_Ui)
//============================================================================



static void Test_Uc_BFu9i_Ul()
{
  {
    init_simple_test("Uc_BFu9i_Ul");
    static STRUCT_IF_C Uc_BFu9i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_Ul");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_Ul, Uc_BFu9i_Ul)
//============================================================================



static void Test_Uc_BFu9i_Us()
{
  {
    init_simple_test("Uc_BFu9i_Us");
    static STRUCT_IF_C Uc_BFu9i_Us lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_Us");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_Us, Uc_BFu9i_Us)
//============================================================================



static void Test_Uc_BFu9i_Vp()
{
  {
    init_simple_test("Uc_BFu9i_Vp");
    static STRUCT_IF_C Uc_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_Vp");
    check_field_offset(lv, v3, 3, "Uc_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9i_Vp, Uc_BFu9i_Vp)
//============================================================================



static void Test_Uc_BFu9ll()
{
  {
    init_simple_test("Uc_BFu9ll");
    static STRUCT_IF_C Uc_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll, Uc_BFu9ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu15i");
    static STRUCT_IF_C Uc_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu15i, Uc_BFu9ll_BFu15i)
//============================================================================



static void Test_Uc_BFu9ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu15ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu15ll, Uc_BFu9ll_BFu15ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu15s");
    static STRUCT_IF_C Uc_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu15s, Uc_BFu9ll_BFu15s)
//============================================================================



static void Test_Uc_BFu9ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu16i");
    static STRUCT_IF_C Uc_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu16i, Uc_BFu9ll_BFu16i)
//============================================================================



static void Test_Uc_BFu9ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu16ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu16ll, Uc_BFu9ll_BFu16ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu16s");
    static STRUCT_IF_C Uc_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu16s, Uc_BFu9ll_BFu16s)
//============================================================================



static void Test_Uc_BFu9ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu17i");
    static STRUCT_IF_C Uc_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Uc_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Uc_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu17i, Uc_BFu9ll_BFu17i)
//============================================================================



static void Test_Uc_BFu9ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu17ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Uc_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Uc_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu17ll, Uc_BFu9ll_BFu17ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu9ll_BFu1c");
    static STRUCT_IF_C Uc_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu1c, Uc_BFu9ll_BFu1c)
//============================================================================



static void Test_Uc_BFu9ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu1i");
    static STRUCT_IF_C Uc_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu1i, Uc_BFu9ll_BFu1i)
//============================================================================



static void Test_Uc_BFu9ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu1ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu1ll, Uc_BFu9ll_BFu1ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu1s");
    static STRUCT_IF_C Uc_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu1s, Uc_BFu9ll_BFu1s)
//============================================================================



static void Test_Uc_BFu9ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu31i");
    static STRUCT_IF_C Uc_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Uc_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Uc_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu31i, Uc_BFu9ll_BFu31i)
//============================================================================



static void Test_Uc_BFu9ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu31ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Uc_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Uc_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu31ll, Uc_BFu9ll_BFu31ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu32i");
    static STRUCT_IF_C Uc_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Uc_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Uc_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu32i, Uc_BFu9ll_BFu32i)
//============================================================================



static void Test_Uc_BFu9ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu32ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Uc_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Uc_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu32ll, Uc_BFu9ll_BFu32ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu33()
{
  {
    init_simple_test("Uc_BFu9ll_BFu33");
    static STRUCT_IF_C Uc_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Uc_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Uc_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu33, Uc_BFu9ll_BFu33)
//============================================================================



static void Test_Uc_BFu9ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu9ll_BFu7c");
    static STRUCT_IF_C Uc_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu7c, Uc_BFu9ll_BFu7c)
//============================================================================



static void Test_Uc_BFu9ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu7i");
    static STRUCT_IF_C Uc_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu7i, Uc_BFu9ll_BFu7i)
//============================================================================



static void Test_Uc_BFu9ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu7ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu7ll, Uc_BFu9ll_BFu7ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu7s");
    static STRUCT_IF_C Uc_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu7s, Uc_BFu9ll_BFu7s)
//============================================================================



static void Test_Uc_BFu9ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu9ll_BFu8c");
    static STRUCT_IF_C Uc_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu8c, Uc_BFu9ll_BFu8c)
//============================================================================



static void Test_Uc_BFu9ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu8i");
    static STRUCT_IF_C Uc_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu8i, Uc_BFu9ll_BFu8i)
//============================================================================



static void Test_Uc_BFu9ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu8ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu8ll, Uc_BFu9ll_BFu8ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu8s");
    static STRUCT_IF_C Uc_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu8s, Uc_BFu9ll_BFu8s)
//============================================================================



static void Test_Uc_BFu9ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu9i");
    static STRUCT_IF_C Uc_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu9i, Uc_BFu9ll_BFu9i)
//============================================================================



static void Test_Uc_BFu9ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu9ll");
    static STRUCT_IF_C Uc_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu9ll, Uc_BFu9ll_BFu9ll)
//============================================================================



static void Test_Uc_BFu9ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu9s");
    static STRUCT_IF_C Uc_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_BFu9s, Uc_BFu9ll_BFu9s)
//============================================================================



static void Test_Uc_BFu9ll_C()
{
  {
    init_simple_test("Uc_BFu9ll_C");
    static STRUCT_IF_C Uc_BFu9ll_C lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_C");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_C, Uc_BFu9ll_C)
//============================================================================



static void Test_Uc_BFu9ll_D()
{
  {
    init_simple_test("Uc_BFu9ll_D");
    static STRUCT_IF_C Uc_BFu9ll_D lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_D");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_D, Uc_BFu9ll_D)
//============================================================================



static void Test_Uc_BFu9ll_F()
{
  {
    init_simple_test("Uc_BFu9ll_F");
    static STRUCT_IF_C Uc_BFu9ll_F lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_F");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_F, Uc_BFu9ll_F)
//============================================================================



static void Test_Uc_BFu9ll_I()
{
  {
    init_simple_test("Uc_BFu9ll_I");
    static STRUCT_IF_C Uc_BFu9ll_I lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_I");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_I, Uc_BFu9ll_I)
//============================================================================



static void Test_Uc_BFu9ll_Ip()
{
  {
    init_simple_test("Uc_BFu9ll_Ip");
    static STRUCT_IF_C Uc_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_Ip");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_Ip, Uc_BFu9ll_Ip)
//============================================================================



static void Test_Uc_BFu9ll_L()
{
  {
    init_simple_test("Uc_BFu9ll_L");
    static STRUCT_IF_C Uc_BFu9ll_L lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_L");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_L, Uc_BFu9ll_L)
//============================================================================



static void Test_Uc_BFu9ll_S()
{
  {
    init_simple_test("Uc_BFu9ll_S");
    static STRUCT_IF_C Uc_BFu9ll_S lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_S");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_S, Uc_BFu9ll_S)
//============================================================================



static void Test_Uc_BFu9ll_Uc()
{
  {
    init_simple_test("Uc_BFu9ll_Uc");
    static STRUCT_IF_C Uc_BFu9ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_Uc, Uc_BFu9ll_Uc)
//============================================================================



static void Test_Uc_BFu9ll_Ui()
{
  {
    init_simple_test("Uc_BFu9ll_Ui");
    static STRUCT_IF_C Uc_BFu9ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_Ui");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_Ui, Uc_BFu9ll_Ui)
//============================================================================



static void Test_Uc_BFu9ll_Ul()
{
  {
    init_simple_test("Uc_BFu9ll_Ul");
    static STRUCT_IF_C Uc_BFu9ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_Ul");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_Ul, Uc_BFu9ll_Ul)
//============================================================================



static void Test_Uc_BFu9ll_Us()
{
  {
    init_simple_test("Uc_BFu9ll_Us");
    static STRUCT_IF_C Uc_BFu9ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_Us");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_Us, Uc_BFu9ll_Us)
//============================================================================



static void Test_Uc_BFu9ll_Vp()
{
  {
    init_simple_test("Uc_BFu9ll_Vp");
    static STRUCT_IF_C Uc_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_Vp");
    check_field_offset(lv, v3, 3, "Uc_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9ll_Vp, Uc_BFu9ll_Vp)
//============================================================================



static void Test_Uc_BFu9s()
{
  {
    init_simple_test("Uc_BFu9s");
    static STRUCT_IF_C Uc_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s, Uc_BFu9s)
//============================================================================



static void Test_Uc_BFu9s_BFu15i()
{
  {
    init_simple_test("Uc_BFu9s_BFu15i");
    static STRUCT_IF_C Uc_BFu9s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu15i, Uc_BFu9s_BFu15i)
//============================================================================



static void Test_Uc_BFu9s_BFu15ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu15ll");
    static STRUCT_IF_C Uc_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu15ll, Uc_BFu9s_BFu15ll)
//============================================================================



static void Test_Uc_BFu9s_BFu15s()
{
  {
    init_simple_test("Uc_BFu9s_BFu15s");
    static STRUCT_IF_C Uc_BFu9s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Uc_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Uc_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu15s, Uc_BFu9s_BFu15s)
//============================================================================



static void Test_Uc_BFu9s_BFu16i()
{
  {
    init_simple_test("Uc_BFu9s_BFu16i");
    static STRUCT_IF_C Uc_BFu9s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu16i, Uc_BFu9s_BFu16i)
//============================================================================



static void Test_Uc_BFu9s_BFu16ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu16ll");
    static STRUCT_IF_C Uc_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu16ll, Uc_BFu9s_BFu16ll)
//============================================================================



static void Test_Uc_BFu9s_BFu16s()
{
  {
    init_simple_test("Uc_BFu9s_BFu16s");
    static STRUCT_IF_C Uc_BFu9s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Uc_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Uc_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu16s, Uc_BFu9s_BFu16s)
//============================================================================



static void Test_Uc_BFu9s_BFu17i()
{
  {
    init_simple_test("Uc_BFu9s_BFu17i");
    static STRUCT_IF_C Uc_BFu9s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Uc_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Uc_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu17i, Uc_BFu9s_BFu17i)
//============================================================================



static void Test_Uc_BFu9s_BFu17ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu17ll");
    static STRUCT_IF_C Uc_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Uc_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Uc_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu17ll, Uc_BFu9s_BFu17ll)
//============================================================================



static void Test_Uc_BFu9s_BFu1c()
{
  {
    init_simple_test("Uc_BFu9s_BFu1c");
    static STRUCT_IF_C Uc_BFu9s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu1c, Uc_BFu9s_BFu1c)
//============================================================================



static void Test_Uc_BFu9s_BFu1i()
{
  {
    init_simple_test("Uc_BFu9s_BFu1i");
    static STRUCT_IF_C Uc_BFu9s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu1i, Uc_BFu9s_BFu1i)
//============================================================================



static void Test_Uc_BFu9s_BFu1ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu1ll");
    static STRUCT_IF_C Uc_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu1ll, Uc_BFu9s_BFu1ll)
//============================================================================



static void Test_Uc_BFu9s_BFu1s()
{
  {
    init_simple_test("Uc_BFu9s_BFu1s");
    static STRUCT_IF_C Uc_BFu9s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Uc_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu1s, Uc_BFu9s_BFu1s)
//============================================================================



static void Test_Uc_BFu9s_BFu31i()
{
  {
    init_simple_test("Uc_BFu9s_BFu31i");
    static STRUCT_IF_C Uc_BFu9s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Uc_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Uc_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu31i, Uc_BFu9s_BFu31i)
//============================================================================



static void Test_Uc_BFu9s_BFu31ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu31ll");
    static STRUCT_IF_C Uc_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Uc_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Uc_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu31ll, Uc_BFu9s_BFu31ll)
//============================================================================



static void Test_Uc_BFu9s_BFu32i()
{
  {
    init_simple_test("Uc_BFu9s_BFu32i");
    static STRUCT_IF_C Uc_BFu9s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Uc_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Uc_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu32i, Uc_BFu9s_BFu32i)
//============================================================================



static void Test_Uc_BFu9s_BFu32ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu32ll");
    static STRUCT_IF_C Uc_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Uc_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Uc_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu32ll, Uc_BFu9s_BFu32ll)
//============================================================================



static void Test_Uc_BFu9s_BFu33()
{
  {
    init_simple_test("Uc_BFu9s_BFu33");
    static STRUCT_IF_C Uc_BFu9s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Uc_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Uc_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu33, Uc_BFu9s_BFu33)
//============================================================================



static void Test_Uc_BFu9s_BFu7c()
{
  {
    init_simple_test("Uc_BFu9s_BFu7c");
    static STRUCT_IF_C Uc_BFu9s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu7c, Uc_BFu9s_BFu7c)
//============================================================================



static void Test_Uc_BFu9s_BFu7i()
{
  {
    init_simple_test("Uc_BFu9s_BFu7i");
    static STRUCT_IF_C Uc_BFu9s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu7i, Uc_BFu9s_BFu7i)
//============================================================================



static void Test_Uc_BFu9s_BFu7ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu7ll");
    static STRUCT_IF_C Uc_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu7ll, Uc_BFu9s_BFu7ll)
//============================================================================



static void Test_Uc_BFu9s_BFu7s()
{
  {
    init_simple_test("Uc_BFu9s_BFu7s");
    static STRUCT_IF_C Uc_BFu9s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Uc_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Uc_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu7s, Uc_BFu9s_BFu7s)
//============================================================================



static void Test_Uc_BFu9s_BFu8c()
{
  {
    init_simple_test("Uc_BFu9s_BFu8c");
    static STRUCT_IF_C Uc_BFu9s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu8c, Uc_BFu9s_BFu8c)
//============================================================================



static void Test_Uc_BFu9s_BFu8i()
{
  {
    init_simple_test("Uc_BFu9s_BFu8i");
    static STRUCT_IF_C Uc_BFu9s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu8i, Uc_BFu9s_BFu8i)
//============================================================================



static void Test_Uc_BFu9s_BFu8ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu8ll");
    static STRUCT_IF_C Uc_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu8ll, Uc_BFu9s_BFu8ll)
//============================================================================



static void Test_Uc_BFu9s_BFu8s()
{
  {
    init_simple_test("Uc_BFu9s_BFu8s");
    static STRUCT_IF_C Uc_BFu9s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Uc_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Uc_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu8s, Uc_BFu9s_BFu8s)
//============================================================================



static void Test_Uc_BFu9s_BFu9i()
{
  {
    init_simple_test("Uc_BFu9s_BFu9i");
    static STRUCT_IF_C Uc_BFu9s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu9i, Uc_BFu9s_BFu9i)
//============================================================================



static void Test_Uc_BFu9s_BFu9ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu9ll");
    static STRUCT_IF_C Uc_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu9ll, Uc_BFu9s_BFu9ll)
//============================================================================



static void Test_Uc_BFu9s_BFu9s()
{
  {
    init_simple_test("Uc_BFu9s_BFu9s");
    static STRUCT_IF_C Uc_BFu9s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Uc_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_BFu9s, Uc_BFu9s_BFu9s)
//============================================================================



static void Test_Uc_BFu9s_C()
{
  {
    init_simple_test("Uc_BFu9s_C");
    static STRUCT_IF_C Uc_BFu9s_C lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_C");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_C, Uc_BFu9s_C)
//============================================================================



static void Test_Uc_BFu9s_D()
{
  {
    init_simple_test("Uc_BFu9s_D");
    static STRUCT_IF_C Uc_BFu9s_D lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_D");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_D, Uc_BFu9s_D)
//============================================================================



static void Test_Uc_BFu9s_F()
{
  {
    init_simple_test("Uc_BFu9s_F");
    static STRUCT_IF_C Uc_BFu9s_F lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_F");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_F, Uc_BFu9s_F)
//============================================================================



static void Test_Uc_BFu9s_I()
{
  {
    init_simple_test("Uc_BFu9s_I");
    static STRUCT_IF_C Uc_BFu9s_I lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_I");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_I, Uc_BFu9s_I)
//============================================================================



static void Test_Uc_BFu9s_Ip()
{
  {
    init_simple_test("Uc_BFu9s_Ip");
    static STRUCT_IF_C Uc_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_Ip");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_Ip, Uc_BFu9s_Ip)
//============================================================================



static void Test_Uc_BFu9s_L()
{
  {
    init_simple_test("Uc_BFu9s_L");
    static STRUCT_IF_C Uc_BFu9s_L lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_L");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_L, Uc_BFu9s_L)
//============================================================================



static void Test_Uc_BFu9s_S()
{
  {
    init_simple_test("Uc_BFu9s_S");
    static STRUCT_IF_C Uc_BFu9s_S lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_S");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_S, Uc_BFu9s_S)
//============================================================================



static void Test_Uc_BFu9s_Uc()
{
  {
    init_simple_test("Uc_BFu9s_Uc");
    static STRUCT_IF_C Uc_BFu9s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_Uc");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_Uc, Uc_BFu9s_Uc)
//============================================================================



static void Test_Uc_BFu9s_Ui()
{
  {
    init_simple_test("Uc_BFu9s_Ui");
    static STRUCT_IF_C Uc_BFu9s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(Uc_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_Ui");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_Ui, Uc_BFu9s_Ui)
//============================================================================



static void Test_Uc_BFu9s_Ul()
{
  {
    init_simple_test("Uc_BFu9s_Ul");
    static STRUCT_IF_C Uc_BFu9s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(Uc_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_Ul");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_Ul, Uc_BFu9s_Ul)
//============================================================================



static void Test_Uc_BFu9s_Us()
{
  {
    init_simple_test("Uc_BFu9s_Us");
    static STRUCT_IF_C Uc_BFu9s_Us lv;
    check2(sizeof(lv), 5, "sizeof(Uc_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_Us");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_Us, Uc_BFu9s_Us)
//============================================================================



static void Test_Uc_BFu9s_Vp()
{
  {
    init_simple_test("Uc_BFu9s_Vp");
    static STRUCT_IF_C Uc_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_Vp");
    check_field_offset(lv, v3, 3, "Uc_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_BFu9s_Vp, Uc_BFu9s_Vp)
//============================================================================



static void Test_Uc_C()
{
  {
    init_simple_test("Uc_C");
    STRUCT_IF_C Uc_C lv;
    check2(sizeof(lv), 2, "sizeof(Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C)");
    check_field_offset(lv, v1, 0, "Uc_C.v1");
    check_field_offset(lv, v2, 1, "Uc_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C, Uc_C)
//============================================================================



static void Test_Uc_C_BFu15i()
{
  {
    init_simple_test("Uc_C_BFu15i");
    static STRUCT_IF_C Uc_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_C_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu15i, Uc_C_BFu15i)
//============================================================================



static void Test_Uc_C_BFu15ll()
{
  {
    init_simple_test("Uc_C_BFu15ll");
    static STRUCT_IF_C Uc_C_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_C_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu15ll, Uc_C_BFu15ll)
//============================================================================



static void Test_Uc_C_BFu15s()
{
  {
    init_simple_test("Uc_C_BFu15s");
    static STRUCT_IF_C Uc_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Uc_C_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Uc_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu15s, Uc_C_BFu15s)
//============================================================================



static void Test_Uc_C_BFu16i()
{
  {
    init_simple_test("Uc_C_BFu16i");
    static STRUCT_IF_C Uc_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_C_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu16i, Uc_C_BFu16i)
//============================================================================



static void Test_Uc_C_BFu16ll()
{
  {
    init_simple_test("Uc_C_BFu16ll");
    static STRUCT_IF_C Uc_C_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_C_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu16ll, Uc_C_BFu16ll)
//============================================================================



static void Test_Uc_C_BFu16s()
{
  {
    init_simple_test("Uc_C_BFu16s");
    static STRUCT_IF_C Uc_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Uc_C_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Uc_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu16s, Uc_C_BFu16s)
//============================================================================



static void Test_Uc_C_BFu17i()
{
  {
    init_simple_test("Uc_C_BFu17i");
    static STRUCT_IF_C Uc_C_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(Uc_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_C_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu17i, Uc_C_BFu17i)
//============================================================================



static void Test_Uc_C_BFu17ll()
{
  {
    init_simple_test("Uc_C_BFu17ll");
    static STRUCT_IF_C Uc_C_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(Uc_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Uc_C_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Uc_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu17ll, Uc_C_BFu17ll)
//============================================================================



static void Test_Uc_C_BFu1c()
{
  {
    init_simple_test("Uc_C_BFu1c");
    static STRUCT_IF_C Uc_C_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu1c, Uc_C_BFu1c)
//============================================================================



static void Test_Uc_C_BFu1i()
{
  {
    init_simple_test("Uc_C_BFu1i");
    static STRUCT_IF_C Uc_C_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu1i, Uc_C_BFu1i)
//============================================================================



static void Test_Uc_C_BFu1ll()
{
  {
    init_simple_test("Uc_C_BFu1ll");
    static STRUCT_IF_C Uc_C_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu1ll, Uc_C_BFu1ll)
//============================================================================



static void Test_Uc_C_BFu1s()
{
  {
    init_simple_test("Uc_C_BFu1s");
    static STRUCT_IF_C Uc_C_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Uc_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu1s, Uc_C_BFu1s)
//============================================================================



static void Test_Uc_C_BFu31i()
{
  {
    init_simple_test("Uc_C_BFu31i");
    static STRUCT_IF_C Uc_C_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_C_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu31i, Uc_C_BFu31i)
//============================================================================



static void Test_Uc_C_BFu31ll()
{
  {
    init_simple_test("Uc_C_BFu31ll");
    static STRUCT_IF_C Uc_C_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Uc_C_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Uc_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu31ll, Uc_C_BFu31ll)
//============================================================================



static void Test_Uc_C_BFu32i()
{
  {
    init_simple_test("Uc_C_BFu32i");
    static STRUCT_IF_C Uc_C_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_C_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu32i, Uc_C_BFu32i)
//============================================================================



static void Test_Uc_C_BFu32ll()
{
  {
    init_simple_test("Uc_C_BFu32ll");
    static STRUCT_IF_C Uc_C_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Uc_C_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Uc_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu32ll, Uc_C_BFu32ll)
//============================================================================



static void Test_Uc_C_BFu33()
{
  {
    init_simple_test("Uc_C_BFu33");
    static STRUCT_IF_C Uc_C_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(Uc_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu33.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Uc_C_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Uc_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu33, Uc_C_BFu33)
//============================================================================



static void Test_Uc_C_BFu7c()
{
  {
    init_simple_test("Uc_C_BFu7c");
    static STRUCT_IF_C Uc_C_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_C_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu7c, Uc_C_BFu7c)
//============================================================================



static void Test_Uc_C_BFu7i()
{
  {
    init_simple_test("Uc_C_BFu7i");
    static STRUCT_IF_C Uc_C_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_C_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu7i, Uc_C_BFu7i)
//============================================================================



static void Test_Uc_C_BFu7ll()
{
  {
    init_simple_test("Uc_C_BFu7ll");
    static STRUCT_IF_C Uc_C_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_C_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu7ll, Uc_C_BFu7ll)
//============================================================================



static void Test_Uc_C_BFu7s()
{
  {
    init_simple_test("Uc_C_BFu7s");
    static STRUCT_IF_C Uc_C_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Uc_C_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Uc_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu7s, Uc_C_BFu7s)
//============================================================================



static void Test_Uc_C_BFu8c()
{
  {
    init_simple_test("Uc_C_BFu8c");
    static STRUCT_IF_C Uc_C_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_C_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu8c, Uc_C_BFu8c)
//============================================================================



static void Test_Uc_C_BFu8i()
{
  {
    init_simple_test("Uc_C_BFu8i");
    static STRUCT_IF_C Uc_C_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_C_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu8i, Uc_C_BFu8i)
//============================================================================



static void Test_Uc_C_BFu8ll()
{
  {
    init_simple_test("Uc_C_BFu8ll");
    static STRUCT_IF_C Uc_C_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_C_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu8ll, Uc_C_BFu8ll)
//============================================================================



static void Test_Uc_C_BFu8s()
{
  {
    init_simple_test("Uc_C_BFu8s");
    static STRUCT_IF_C Uc_C_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Uc_C_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Uc_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu8s, Uc_C_BFu8s)
//============================================================================



static void Test_Uc_C_BFu9i()
{
  {
    init_simple_test("Uc_C_BFu9i");
    static STRUCT_IF_C Uc_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_C_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu9i, Uc_C_BFu9i)
//============================================================================



static void Test_Uc_C_BFu9ll()
{
  {
    init_simple_test("Uc_C_BFu9ll");
    static STRUCT_IF_C Uc_C_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_C_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu9ll, Uc_C_BFu9ll)
//============================================================================



static void Test_Uc_C_BFu9s()
{
  {
    init_simple_test("Uc_C_BFu9s");
    static STRUCT_IF_C Uc_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Uc_C_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Uc_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_BFu9s, Uc_C_BFu9s)
//============================================================================



static void Test_Uc_C_C()
{
  {
    init_simple_test("Uc_C_C");
    STRUCT_IF_C Uc_C_C lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_C)");
    check_field_offset(lv, v1, 0, "Uc_C_C.v1");
    check_field_offset(lv, v2, 1, "Uc_C_C.v2");
    check_field_offset(lv, v3, 2, "Uc_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_C, Uc_C_C)
//============================================================================



static void Test_Uc_C_D()
{
  {
    init_simple_test("Uc_C_D");
    STRUCT_IF_C Uc_C_D lv;
    check2(sizeof(lv), 10, "sizeof(Uc_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_D)");
    check_field_offset(lv, v1, 0, "Uc_C_D.v1");
    check_field_offset(lv, v2, 1, "Uc_C_D.v2");
    check_field_offset(lv, v3, 2, "Uc_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_D, Uc_C_D)
//============================================================================



static void Test_Uc_C_F()
{
  {
    init_simple_test("Uc_C_F");
    STRUCT_IF_C Uc_C_F lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_F)");
    check_field_offset(lv, v1, 0, "Uc_C_F.v1");
    check_field_offset(lv, v2, 1, "Uc_C_F.v2");
    check_field_offset(lv, v3, 2, "Uc_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_F, Uc_C_F)
//============================================================================



static void Test_Uc_C_I()
{
  {
    init_simple_test("Uc_C_I");
    STRUCT_IF_C Uc_C_I lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_I)");
    check_field_offset(lv, v1, 0, "Uc_C_I.v1");
    check_field_offset(lv, v2, 1, "Uc_C_I.v2");
    check_field_offset(lv, v3, 2, "Uc_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_I, Uc_C_I)
//============================================================================



static void Test_Uc_C_Ip()
{
  {
    init_simple_test("Uc_C_Ip");
    STRUCT_IF_C Uc_C_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_Ip)");
    check_field_offset(lv, v1, 0, "Uc_C_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_C_Ip.v2");
    check_field_offset(lv, v3, 2, "Uc_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_Ip, Uc_C_Ip)
//============================================================================



static void Test_Uc_C_L()
{
  {
    init_simple_test("Uc_C_L");
    STRUCT_IF_C Uc_C_L lv;
    check2(sizeof(lv), 10, "sizeof(Uc_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_L)");
    check_field_offset(lv, v1, 0, "Uc_C_L.v1");
    check_field_offset(lv, v2, 1, "Uc_C_L.v2");
    check_field_offset(lv, v3, 2, "Uc_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_L, Uc_C_L)
//============================================================================



static void Test_Uc_C_S()
{
  {
    init_simple_test("Uc_C_S");
    STRUCT_IF_C Uc_C_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_S)");
    check_field_offset(lv, v1, 0, "Uc_C_S.v1");
    check_field_offset(lv, v2, 1, "Uc_C_S.v2");
    check_field_offset(lv, v3, 2, "Uc_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_S, Uc_C_S)
//============================================================================



static void Test_Uc_C_Uc()
{
  {
    init_simple_test("Uc_C_Uc");
    STRUCT_IF_C Uc_C_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Uc_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_Uc)");
    check_field_offset(lv, v1, 0, "Uc_C_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_C_Uc.v2");
    check_field_offset(lv, v3, 2, "Uc_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_Uc, Uc_C_Uc)
//============================================================================



static void Test_Uc_C_Ui()
{
  {
    init_simple_test("Uc_C_Ui");
    STRUCT_IF_C Uc_C_Ui lv;
    check2(sizeof(lv), 6, "sizeof(Uc_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_Ui)");
    check_field_offset(lv, v1, 0, "Uc_C_Ui.v1");
    check_field_offset(lv, v2, 1, "Uc_C_Ui.v2");
    check_field_offset(lv, v3, 2, "Uc_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_Ui, Uc_C_Ui)
//============================================================================



static void Test_Uc_C_Ul()
{
  {
    init_simple_test("Uc_C_Ul");
    STRUCT_IF_C Uc_C_Ul lv;
    check2(sizeof(lv), 10, "sizeof(Uc_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_Ul)");
    check_field_offset(lv, v1, 0, "Uc_C_Ul.v1");
    check_field_offset(lv, v2, 1, "Uc_C_Ul.v2");
    check_field_offset(lv, v3, 2, "Uc_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_Ul, Uc_C_Ul)
//============================================================================



static void Test_Uc_C_Us()
{
  {
    init_simple_test("Uc_C_Us");
    STRUCT_IF_C Uc_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_Us)");
    check_field_offset(lv, v1, 0, "Uc_C_Us.v1");
    check_field_offset(lv, v2, 1, "Uc_C_Us.v2");
    check_field_offset(lv, v3, 2, "Uc_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_Us, Uc_C_Us)
//============================================================================



static void Test_Uc_C_Vp()
{
  {
    init_simple_test("Uc_C_Vp");
    STRUCT_IF_C Uc_C_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_Vp)");
    check_field_offset(lv, v1, 0, "Uc_C_Vp.v1");
    check_field_offset(lv, v2, 1, "Uc_C_Vp.v2");
    check_field_offset(lv, v3, 2, "Uc_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_C_Vp, Uc_C_Vp)
//============================================================================



static void Test_Uc_D()
{
  {
    init_simple_test("Uc_D");
    STRUCT_IF_C Uc_D lv;
    check2(sizeof(lv), 9, "sizeof(Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D)");
    check_field_offset(lv, v1, 0, "Uc_D.v1");
    check_field_offset(lv, v2, 1, "Uc_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D, Uc_D)
//============================================================================



static void Test_Uc_D_BFu15i()
{
  {
    init_simple_test("Uc_D_BFu15i");
    static STRUCT_IF_C Uc_D_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Uc_D_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Uc_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu15i, Uc_D_BFu15i)
//============================================================================



static void Test_Uc_D_BFu15ll()
{
  {
    init_simple_test("Uc_D_BFu15ll");
    static STRUCT_IF_C Uc_D_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Uc_D_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Uc_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu15ll, Uc_D_BFu15ll)
//============================================================================



static void Test_Uc_D_BFu15s()
{
  {
    init_simple_test("Uc_D_BFu15s");
    static STRUCT_IF_C Uc_D_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Uc_D_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Uc_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu15s, Uc_D_BFu15s)
//============================================================================



static void Test_Uc_D_BFu16i()
{
  {
    init_simple_test("Uc_D_BFu16i");
    static STRUCT_IF_C Uc_D_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Uc_D_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Uc_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu16i, Uc_D_BFu16i)
//============================================================================



static void Test_Uc_D_BFu16ll()
{
  {
    init_simple_test("Uc_D_BFu16ll");
    static STRUCT_IF_C Uc_D_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Uc_D_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Uc_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu16ll, Uc_D_BFu16ll)
//============================================================================



static void Test_Uc_D_BFu16s()
{
  {
    init_simple_test("Uc_D_BFu16s");
    static STRUCT_IF_C Uc_D_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Uc_D_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Uc_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu16s, Uc_D_BFu16s)
//============================================================================



static void Test_Uc_D_BFu17i()
{
  {
    init_simple_test("Uc_D_BFu17i");
    static STRUCT_IF_C Uc_D_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Uc_D_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Uc_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu17i, Uc_D_BFu17i)
//============================================================================



static void Test_Uc_D_BFu17ll()
{
  {
    init_simple_test("Uc_D_BFu17ll");
    static STRUCT_IF_C Uc_D_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Uc_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Uc_D_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Uc_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu17ll, Uc_D_BFu17ll)
//============================================================================



static void Test_Uc_D_BFu1c()
{
  {
    init_simple_test("Uc_D_BFu1c");
    static STRUCT_IF_C Uc_D_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1c, Uc_D_BFu1c)
//============================================================================



static void Test_Uc_D_BFu1i()
{
  {
    init_simple_test("Uc_D_BFu1i");
    static STRUCT_IF_C Uc_D_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1i, Uc_D_BFu1i)
//============================================================================



static void Test_Uc_D_BFu1ll()
{
  {
    init_simple_test("Uc_D_BFu1ll");
    static STRUCT_IF_C Uc_D_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1ll, Uc_D_BFu1ll)
//============================================================================



static void Test_Uc_D_BFu1s()
{
  {
    init_simple_test("Uc_D_BFu1s");
    static STRUCT_IF_C Uc_D_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu1s, Uc_D_BFu1s)
//============================================================================



static void Test_Uc_D_BFu31i()
{
  {
    init_simple_test("Uc_D_BFu31i");
    static STRUCT_IF_C Uc_D_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Uc_D_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Uc_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu31i, Uc_D_BFu31i)
//============================================================================



static void Test_Uc_D_BFu31ll()
{
  {
    init_simple_test("Uc_D_BFu31ll");
    static STRUCT_IF_C Uc_D_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Uc_D_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Uc_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu31ll, Uc_D_BFu31ll)
//============================================================================



static void Test_Uc_D_BFu32i()
{
  {
    init_simple_test("Uc_D_BFu32i");
    static STRUCT_IF_C Uc_D_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Uc_D_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Uc_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu32i, Uc_D_BFu32i)
//============================================================================



static void Test_Uc_D_BFu32ll()
{
  {
    init_simple_test("Uc_D_BFu32ll");
    static STRUCT_IF_C Uc_D_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Uc_D_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Uc_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu32ll, Uc_D_BFu32ll)
//============================================================================



static void Test_Uc_D_BFu33()
{
  {
    init_simple_test("Uc_D_BFu33");
    static STRUCT_IF_C Uc_D_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(Uc_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu33.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Uc_D_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Uc_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu33, Uc_D_BFu33)
//============================================================================



static void Test_Uc_D_BFu7c()
{
  {
    init_simple_test("Uc_D_BFu7c");
    static STRUCT_IF_C Uc_D_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Uc_D_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7c, Uc_D_BFu7c)
//============================================================================



static void Test_Uc_D_BFu7i()
{
  {
    init_simple_test("Uc_D_BFu7i");
    static STRUCT_IF_C Uc_D_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Uc_D_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7i, Uc_D_BFu7i)
//============================================================================



static void Test_Uc_D_BFu7ll()
{
  {
    init_simple_test("Uc_D_BFu7ll");
    static STRUCT_IF_C Uc_D_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Uc_D_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7ll, Uc_D_BFu7ll)
//============================================================================



static void Test_Uc_D_BFu7s()
{
  {
    init_simple_test("Uc_D_BFu7s");
    static STRUCT_IF_C Uc_D_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Uc_D_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Uc_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu7s, Uc_D_BFu7s)
//============================================================================



static void Test_Uc_D_BFu8c()
{
  {
    init_simple_test("Uc_D_BFu8c");
    static STRUCT_IF_C Uc_D_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Uc_D_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8c, Uc_D_BFu8c)
//============================================================================



static void Test_Uc_D_BFu8i()
{
  {
    init_simple_test("Uc_D_BFu8i");
    static STRUCT_IF_C Uc_D_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Uc_D_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8i, Uc_D_BFu8i)
//============================================================================



static void Test_Uc_D_BFu8ll()
{
  {
    init_simple_test("Uc_D_BFu8ll");
    static STRUCT_IF_C Uc_D_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Uc_D_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8ll, Uc_D_BFu8ll)
//============================================================================



static void Test_Uc_D_BFu8s()
{
  {
    init_simple_test("Uc_D_BFu8s");
    static STRUCT_IF_C Uc_D_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Uc_D_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Uc_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu8s, Uc_D_BFu8s)
//============================================================================



static void Test_Uc_D_BFu9i()
{
  {
    init_simple_test("Uc_D_BFu9i");
    static STRUCT_IF_C Uc_D_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Uc_D_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Uc_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu9i, Uc_D_BFu9i)
//============================================================================



static void Test_Uc_D_BFu9ll()
{
  {
    init_simple_test("Uc_D_BFu9ll");
    static STRUCT_IF_C Uc_D_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Uc_D_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Uc_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu9ll, Uc_D_BFu9ll)
//============================================================================



static void Test_Uc_D_BFu9s()
{
  {
    init_simple_test("Uc_D_BFu9s");
    static STRUCT_IF_C Uc_D_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Uc_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Uc_D_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Uc_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_BFu9s, Uc_D_BFu9s)
//============================================================================



static void Test_Uc_D_C()
{
  {
    init_simple_test("Uc_D_C");
    STRUCT_IF_C Uc_D_C lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_C)");
    check_field_offset(lv, v1, 0, "Uc_D_C.v1");
    check_field_offset(lv, v2, 1, "Uc_D_C.v2");
    check_field_offset(lv, v3, 9, "Uc_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_C, Uc_D_C)
//============================================================================



static void Test_Uc_D_D()
{
  {
    init_simple_test("Uc_D_D");
    STRUCT_IF_C Uc_D_D lv;
    check2(sizeof(lv), 17, "sizeof(Uc_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_D)");
    check_field_offset(lv, v1, 0, "Uc_D_D.v1");
    check_field_offset(lv, v2, 1, "Uc_D_D.v2");
    check_field_offset(lv, v3, 9, "Uc_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_D, Uc_D_D)
//============================================================================



static void Test_Uc_D_F()
{
  {
    init_simple_test("Uc_D_F");
    STRUCT_IF_C Uc_D_F lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_F)");
    check_field_offset(lv, v1, 0, "Uc_D_F.v1");
    check_field_offset(lv, v2, 1, "Uc_D_F.v2");
    check_field_offset(lv, v3, 9, "Uc_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_F, Uc_D_F)
//============================================================================



static void Test_Uc_D_I()
{
  {
    init_simple_test("Uc_D_I");
    STRUCT_IF_C Uc_D_I lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_I)");
    check_field_offset(lv, v1, 0, "Uc_D_I.v1");
    check_field_offset(lv, v2, 1, "Uc_D_I.v2");
    check_field_offset(lv, v3, 9, "Uc_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_I, Uc_D_I)
//============================================================================



static void Test_Uc_D_Ip()
{
  {
    init_simple_test("Uc_D_Ip");
    STRUCT_IF_C Uc_D_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Uc_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_Ip)");
    check_field_offset(lv, v1, 0, "Uc_D_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_D_Ip.v2");
    check_field_offset(lv, v3, 9, "Uc_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Ip, Uc_D_Ip)
//============================================================================



static void Test_Uc_D_L()
{
  {
    init_simple_test("Uc_D_L");
    STRUCT_IF_C Uc_D_L lv;
    check2(sizeof(lv), 17, "sizeof(Uc_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_L)");
    check_field_offset(lv, v1, 0, "Uc_D_L.v1");
    check_field_offset(lv, v2, 1, "Uc_D_L.v2");
    check_field_offset(lv, v3, 9, "Uc_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_L, Uc_D_L)
//============================================================================



static void Test_Uc_D_S()
{
  {
    init_simple_test("Uc_D_S");
    STRUCT_IF_C Uc_D_S lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_S)");
    check_field_offset(lv, v1, 0, "Uc_D_S.v1");
    check_field_offset(lv, v2, 1, "Uc_D_S.v2");
    check_field_offset(lv, v3, 9, "Uc_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_S, Uc_D_S)
//============================================================================



static void Test_Uc_D_Uc()
{
  {
    init_simple_test("Uc_D_Uc");
    STRUCT_IF_C Uc_D_Uc lv;
    check2(sizeof(lv), 10, "sizeof(Uc_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_Uc)");
    check_field_offset(lv, v1, 0, "Uc_D_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_D_Uc.v2");
    check_field_offset(lv, v3, 9, "Uc_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Uc, Uc_D_Uc)
//============================================================================



static void Test_Uc_D_Ui()
{
  {
    init_simple_test("Uc_D_Ui");
    STRUCT_IF_C Uc_D_Ui lv;
    check2(sizeof(lv), 13, "sizeof(Uc_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_Ui)");
    check_field_offset(lv, v1, 0, "Uc_D_Ui.v1");
    check_field_offset(lv, v2, 1, "Uc_D_Ui.v2");
    check_field_offset(lv, v3, 9, "Uc_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Ui, Uc_D_Ui)
//============================================================================



static void Test_Uc_D_Ul()
{
  {
    init_simple_test("Uc_D_Ul");
    STRUCT_IF_C Uc_D_Ul lv;
    check2(sizeof(lv), 17, "sizeof(Uc_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_Ul)");
    check_field_offset(lv, v1, 0, "Uc_D_Ul.v1");
    check_field_offset(lv, v2, 1, "Uc_D_Ul.v2");
    check_field_offset(lv, v3, 9, "Uc_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Ul, Uc_D_Ul)
//============================================================================



static void Test_Uc_D_Us()
{
  {
    init_simple_test("Uc_D_Us");
    STRUCT_IF_C Uc_D_Us lv;
    check2(sizeof(lv), 11, "sizeof(Uc_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_Us)");
    check_field_offset(lv, v1, 0, "Uc_D_Us.v1");
    check_field_offset(lv, v2, 1, "Uc_D_Us.v2");
    check_field_offset(lv, v3, 9, "Uc_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Us, Uc_D_Us)
//============================================================================



static void Test_Uc_D_Vp()
{
  {
    init_simple_test("Uc_D_Vp");
    STRUCT_IF_C Uc_D_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Uc_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_D_Vp)");
    check_field_offset(lv, v1, 0, "Uc_D_Vp.v1");
    check_field_offset(lv, v2, 1, "Uc_D_Vp.v2");
    check_field_offset(lv, v3, 9, "Uc_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_D_Vp, Uc_D_Vp)
//============================================================================



static void Test_Uc_F()
{
  {
    init_simple_test("Uc_F");
    STRUCT_IF_C Uc_F lv;
    check2(sizeof(lv), 5, "sizeof(Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F)");
    check_field_offset(lv, v1, 0, "Uc_F.v1");
    check_field_offset(lv, v2, 1, "Uc_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F, Uc_F)
//============================================================================



static void Test_Uc_F_BFu15i()
{
  {
    init_simple_test("Uc_F_BFu15i");
    static STRUCT_IF_C Uc_F_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_F_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu15i, Uc_F_BFu15i)
//============================================================================



static void Test_Uc_F_BFu15ll()
{
  {
    init_simple_test("Uc_F_BFu15ll");
    static STRUCT_IF_C Uc_F_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_F_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu15ll, Uc_F_BFu15ll)
//============================================================================



static void Test_Uc_F_BFu15s()
{
  {
    init_simple_test("Uc_F_BFu15s");
    static STRUCT_IF_C Uc_F_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_F_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu15s, Uc_F_BFu15s)
//============================================================================



static void Test_Uc_F_BFu16i()
{
  {
    init_simple_test("Uc_F_BFu16i");
    static STRUCT_IF_C Uc_F_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_F_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu16i, Uc_F_BFu16i)
//============================================================================



static void Test_Uc_F_BFu16ll()
{
  {
    init_simple_test("Uc_F_BFu16ll");
    static STRUCT_IF_C Uc_F_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_F_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu16ll, Uc_F_BFu16ll)
//============================================================================



static void Test_Uc_F_BFu16s()
{
  {
    init_simple_test("Uc_F_BFu16s");
    static STRUCT_IF_C Uc_F_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_F_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu16s, Uc_F_BFu16s)
//============================================================================



static void Test_Uc_F_BFu17i()
{
  {
    init_simple_test("Uc_F_BFu17i");
    static STRUCT_IF_C Uc_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_F_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu17i, Uc_F_BFu17i)
//============================================================================



static void Test_Uc_F_BFu17ll()
{
  {
    init_simple_test("Uc_F_BFu17ll");
    static STRUCT_IF_C Uc_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_F_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu17ll, Uc_F_BFu17ll)
//============================================================================



static void Test_Uc_F_BFu1c()
{
  {
    init_simple_test("Uc_F_BFu1c");
    static STRUCT_IF_C Uc_F_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1c, Uc_F_BFu1c)
//============================================================================



static void Test_Uc_F_BFu1i()
{
  {
    init_simple_test("Uc_F_BFu1i");
    static STRUCT_IF_C Uc_F_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1i, Uc_F_BFu1i)
//============================================================================



static void Test_Uc_F_BFu1ll()
{
  {
    init_simple_test("Uc_F_BFu1ll");
    static STRUCT_IF_C Uc_F_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1ll, Uc_F_BFu1ll)
//============================================================================



static void Test_Uc_F_BFu1s()
{
  {
    init_simple_test("Uc_F_BFu1s");
    static STRUCT_IF_C Uc_F_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu1s, Uc_F_BFu1s)
//============================================================================



static void Test_Uc_F_BFu31i()
{
  {
    init_simple_test("Uc_F_BFu31i");
    static STRUCT_IF_C Uc_F_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_F_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu31i, Uc_F_BFu31i)
//============================================================================



static void Test_Uc_F_BFu31ll()
{
  {
    init_simple_test("Uc_F_BFu31ll");
    static STRUCT_IF_C Uc_F_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_F_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu31ll, Uc_F_BFu31ll)
//============================================================================



static void Test_Uc_F_BFu32i()
{
  {
    init_simple_test("Uc_F_BFu32i");
    static STRUCT_IF_C Uc_F_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_F_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu32i, Uc_F_BFu32i)
//============================================================================



static void Test_Uc_F_BFu32ll()
{
  {
    init_simple_test("Uc_F_BFu32ll");
    static STRUCT_IF_C Uc_F_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_F_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu32ll, Uc_F_BFu32ll)
//============================================================================



static void Test_Uc_F_BFu33()
{
  {
    init_simple_test("Uc_F_BFu33");
    static STRUCT_IF_C Uc_F_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(Uc_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu33.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "Uc_F_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "Uc_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu33, Uc_F_BFu33)
//============================================================================



static void Test_Uc_F_BFu7c()
{
  {
    init_simple_test("Uc_F_BFu7c");
    static STRUCT_IF_C Uc_F_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_F_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7c, Uc_F_BFu7c)
//============================================================================



static void Test_Uc_F_BFu7i()
{
  {
    init_simple_test("Uc_F_BFu7i");
    static STRUCT_IF_C Uc_F_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_F_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7i, Uc_F_BFu7i)
//============================================================================



static void Test_Uc_F_BFu7ll()
{
  {
    init_simple_test("Uc_F_BFu7ll");
    static STRUCT_IF_C Uc_F_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_F_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7ll, Uc_F_BFu7ll)
//============================================================================



static void Test_Uc_F_BFu7s()
{
  {
    init_simple_test("Uc_F_BFu7s");
    static STRUCT_IF_C Uc_F_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_F_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu7s, Uc_F_BFu7s)
//============================================================================



static void Test_Uc_F_BFu8c()
{
  {
    init_simple_test("Uc_F_BFu8c");
    static STRUCT_IF_C Uc_F_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_F_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8c, Uc_F_BFu8c)
//============================================================================



static void Test_Uc_F_BFu8i()
{
  {
    init_simple_test("Uc_F_BFu8i");
    static STRUCT_IF_C Uc_F_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_F_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8i, Uc_F_BFu8i)
//============================================================================



static void Test_Uc_F_BFu8ll()
{
  {
    init_simple_test("Uc_F_BFu8ll");
    static STRUCT_IF_C Uc_F_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_F_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8ll, Uc_F_BFu8ll)
//============================================================================



static void Test_Uc_F_BFu8s()
{
  {
    init_simple_test("Uc_F_BFu8s");
    static STRUCT_IF_C Uc_F_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_F_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu8s, Uc_F_BFu8s)
//============================================================================



static void Test_Uc_F_BFu9i()
{
  {
    init_simple_test("Uc_F_BFu9i");
    static STRUCT_IF_C Uc_F_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_F_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu9i, Uc_F_BFu9i)
//============================================================================



static void Test_Uc_F_BFu9ll()
{
  {
    init_simple_test("Uc_F_BFu9ll");
    static STRUCT_IF_C Uc_F_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_F_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu9ll, Uc_F_BFu9ll)
//============================================================================



static void Test_Uc_F_BFu9s()
{
  {
    init_simple_test("Uc_F_BFu9s");
    static STRUCT_IF_C Uc_F_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Uc_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_F_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_BFu9s, Uc_F_BFu9s)
//============================================================================



static void Test_Uc_F_C()
{
  {
    init_simple_test("Uc_F_C");
    STRUCT_IF_C Uc_F_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_C)");
    check_field_offset(lv, v1, 0, "Uc_F_C.v1");
    check_field_offset(lv, v2, 1, "Uc_F_C.v2");
    check_field_offset(lv, v3, 5, "Uc_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_C, Uc_F_C)
//============================================================================



static void Test_Uc_F_D()
{
  {
    init_simple_test("Uc_F_D");
    STRUCT_IF_C Uc_F_D lv;
    check2(sizeof(lv), 13, "sizeof(Uc_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_D)");
    check_field_offset(lv, v1, 0, "Uc_F_D.v1");
    check_field_offset(lv, v2, 1, "Uc_F_D.v2");
    check_field_offset(lv, v3, 5, "Uc_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_D, Uc_F_D)
//============================================================================



static void Test_Uc_F_F()
{
  {
    init_simple_test("Uc_F_F");
    STRUCT_IF_C Uc_F_F lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_F)");
    check_field_offset(lv, v1, 0, "Uc_F_F.v1");
    check_field_offset(lv, v2, 1, "Uc_F_F.v2");
    check_field_offset(lv, v3, 5, "Uc_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_F, Uc_F_F)
//============================================================================



static void Test_Uc_F_I()
{
  {
    init_simple_test("Uc_F_I");
    STRUCT_IF_C Uc_F_I lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_I)");
    check_field_offset(lv, v1, 0, "Uc_F_I.v1");
    check_field_offset(lv, v2, 1, "Uc_F_I.v2");
    check_field_offset(lv, v3, 5, "Uc_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_I, Uc_F_I)
//============================================================================



static void Test_Uc_F_Ip()
{
  {
    init_simple_test("Uc_F_Ip");
    STRUCT_IF_C Uc_F_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_Ip)");
    check_field_offset(lv, v1, 0, "Uc_F_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_F_Ip.v2");
    check_field_offset(lv, v3, 5, "Uc_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Ip, Uc_F_Ip)
//============================================================================



static void Test_Uc_F_L()
{
  {
    init_simple_test("Uc_F_L");
    STRUCT_IF_C Uc_F_L lv;
    check2(sizeof(lv), 13, "sizeof(Uc_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_L)");
    check_field_offset(lv, v1, 0, "Uc_F_L.v1");
    check_field_offset(lv, v2, 1, "Uc_F_L.v2");
    check_field_offset(lv, v3, 5, "Uc_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_L, Uc_F_L)
//============================================================================



static void Test_Uc_F_S()
{
  {
    init_simple_test("Uc_F_S");
    STRUCT_IF_C Uc_F_S lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_S)");
    check_field_offset(lv, v1, 0, "Uc_F_S.v1");
    check_field_offset(lv, v2, 1, "Uc_F_S.v2");
    check_field_offset(lv, v3, 5, "Uc_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_S, Uc_F_S)
//============================================================================



static void Test_Uc_F_Uc()
{
  {
    init_simple_test("Uc_F_Uc");
    STRUCT_IF_C Uc_F_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_Uc)");
    check_field_offset(lv, v1, 0, "Uc_F_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_F_Uc.v2");
    check_field_offset(lv, v3, 5, "Uc_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Uc, Uc_F_Uc)
//============================================================================



static void Test_Uc_F_Ui()
{
  {
    init_simple_test("Uc_F_Ui");
    STRUCT_IF_C Uc_F_Ui lv;
    check2(sizeof(lv), 9, "sizeof(Uc_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_Ui)");
    check_field_offset(lv, v1, 0, "Uc_F_Ui.v1");
    check_field_offset(lv, v2, 1, "Uc_F_Ui.v2");
    check_field_offset(lv, v3, 5, "Uc_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Ui, Uc_F_Ui)
//============================================================================



static void Test_Uc_F_Ul()
{
  {
    init_simple_test("Uc_F_Ul");
    STRUCT_IF_C Uc_F_Ul lv;
    check2(sizeof(lv), 13, "sizeof(Uc_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_Ul)");
    check_field_offset(lv, v1, 0, "Uc_F_Ul.v1");
    check_field_offset(lv, v2, 1, "Uc_F_Ul.v2");
    check_field_offset(lv, v3, 5, "Uc_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Ul, Uc_F_Ul)
//============================================================================



static void Test_Uc_F_Us()
{
  {
    init_simple_test("Uc_F_Us");
    STRUCT_IF_C Uc_F_Us lv;
    check2(sizeof(lv), 7, "sizeof(Uc_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_Us)");
    check_field_offset(lv, v1, 0, "Uc_F_Us.v1");
    check_field_offset(lv, v2, 1, "Uc_F_Us.v2");
    check_field_offset(lv, v3, 5, "Uc_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Us, Uc_F_Us)
//============================================================================



static void Test_Uc_F_Vp()
{
  {
    init_simple_test("Uc_F_Vp");
    STRUCT_IF_C Uc_F_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_F_Vp)");
    check_field_offset(lv, v1, 0, "Uc_F_Vp.v1");
    check_field_offset(lv, v2, 1, "Uc_F_Vp.v2");
    check_field_offset(lv, v3, 5, "Uc_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_F_Vp, Uc_F_Vp)
//============================================================================



static void Test_Uc_I()
{
  {
    init_simple_test("Uc_I");
    STRUCT_IF_C Uc_I lv;
    check2(sizeof(lv), 5, "sizeof(Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I)");
    check_field_offset(lv, v1, 0, "Uc_I.v1");
    check_field_offset(lv, v2, 1, "Uc_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I, Uc_I)
//============================================================================



static void Test_Uc_I_BFu15i()
{
  {
    init_simple_test("Uc_I_BFu15i");
    static STRUCT_IF_C Uc_I_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_I_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu15i, Uc_I_BFu15i)
//============================================================================



static void Test_Uc_I_BFu15ll()
{
  {
    init_simple_test("Uc_I_BFu15ll");
    static STRUCT_IF_C Uc_I_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_I_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu15ll, Uc_I_BFu15ll)
//============================================================================



static void Test_Uc_I_BFu15s()
{
  {
    init_simple_test("Uc_I_BFu15s");
    static STRUCT_IF_C Uc_I_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Uc_I_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Uc_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu15s, Uc_I_BFu15s)
//============================================================================



static void Test_Uc_I_BFu16i()
{
  {
    init_simple_test("Uc_I_BFu16i");
    static STRUCT_IF_C Uc_I_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_I_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu16i, Uc_I_BFu16i)
//============================================================================



static void Test_Uc_I_BFu16ll()
{
  {
    init_simple_test("Uc_I_BFu16ll");
    static STRUCT_IF_C Uc_I_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_I_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu16ll, Uc_I_BFu16ll)
//============================================================================



static void Test_Uc_I_BFu16s()
{
  {
    init_simple_test("Uc_I_BFu16s");
    static STRUCT_IF_C Uc_I_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Uc_I_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Uc_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu16s, Uc_I_BFu16s)
//============================================================================



static void Test_Uc_I_BFu17i()
{
  {
    init_simple_test("Uc_I_BFu17i");
    static STRUCT_IF_C Uc_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_I_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu17i, Uc_I_BFu17i)
//============================================================================



static void Test_Uc_I_BFu17ll()
{
  {
    init_simple_test("Uc_I_BFu17ll");
    static STRUCT_IF_C Uc_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Uc_I_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Uc_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu17ll, Uc_I_BFu17ll)
//============================================================================



static void Test_Uc_I_BFu1c()
{
  {
    init_simple_test("Uc_I_BFu1c");
    static STRUCT_IF_C Uc_I_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1c, Uc_I_BFu1c)
//============================================================================



static void Test_Uc_I_BFu1i()
{
  {
    init_simple_test("Uc_I_BFu1i");
    static STRUCT_IF_C Uc_I_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1i, Uc_I_BFu1i)
//============================================================================



static void Test_Uc_I_BFu1ll()
{
  {
    init_simple_test("Uc_I_BFu1ll");
    static STRUCT_IF_C Uc_I_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1ll, Uc_I_BFu1ll)
//============================================================================



static void Test_Uc_I_BFu1s()
{
  {
    init_simple_test("Uc_I_BFu1s");
    static STRUCT_IF_C Uc_I_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Uc_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu1s, Uc_I_BFu1s)
//============================================================================



static void Test_Uc_I_BFu31i()
{
  {
    init_simple_test("Uc_I_BFu31i");
    static STRUCT_IF_C Uc_I_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_I_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu31i, Uc_I_BFu31i)
//============================================================================



static void Test_Uc_I_BFu31ll()
{
  {
    init_simple_test("Uc_I_BFu31ll");
    static STRUCT_IF_C Uc_I_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "Uc_I_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "Uc_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu31ll, Uc_I_BFu31ll)
//============================================================================



static void Test_Uc_I_BFu32i()
{
  {
    init_simple_test("Uc_I_BFu32i");
    static STRUCT_IF_C Uc_I_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_I_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu32i, Uc_I_BFu32i)
//============================================================================



static void Test_Uc_I_BFu32ll()
{
  {
    init_simple_test("Uc_I_BFu32ll");
    static STRUCT_IF_C Uc_I_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "Uc_I_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "Uc_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu32ll, Uc_I_BFu32ll)
//============================================================================



static void Test_Uc_I_BFu33()
{
  {
    init_simple_test("Uc_I_BFu33");
    static STRUCT_IF_C Uc_I_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(Uc_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu33.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "Uc_I_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "Uc_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu33, Uc_I_BFu33)
//============================================================================



static void Test_Uc_I_BFu7c()
{
  {
    init_simple_test("Uc_I_BFu7c");
    static STRUCT_IF_C Uc_I_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_I_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7c, Uc_I_BFu7c)
//============================================================================



static void Test_Uc_I_BFu7i()
{
  {
    init_simple_test("Uc_I_BFu7i");
    static STRUCT_IF_C Uc_I_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_I_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7i, Uc_I_BFu7i)
//============================================================================



static void Test_Uc_I_BFu7ll()
{
  {
    init_simple_test("Uc_I_BFu7ll");
    static STRUCT_IF_C Uc_I_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_I_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7ll, Uc_I_BFu7ll)
//============================================================================



static void Test_Uc_I_BFu7s()
{
  {
    init_simple_test("Uc_I_BFu7s");
    static STRUCT_IF_C Uc_I_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Uc_I_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Uc_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu7s, Uc_I_BFu7s)
//============================================================================



static void Test_Uc_I_BFu8c()
{
  {
    init_simple_test("Uc_I_BFu8c");
    static STRUCT_IF_C Uc_I_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_I_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8c, Uc_I_BFu8c)
//============================================================================



static void Test_Uc_I_BFu8i()
{
  {
    init_simple_test("Uc_I_BFu8i");
    static STRUCT_IF_C Uc_I_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_I_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8i, Uc_I_BFu8i)
//============================================================================



static void Test_Uc_I_BFu8ll()
{
  {
    init_simple_test("Uc_I_BFu8ll");
    static STRUCT_IF_C Uc_I_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_I_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8ll, Uc_I_BFu8ll)
//============================================================================



static void Test_Uc_I_BFu8s()
{
  {
    init_simple_test("Uc_I_BFu8s");
    static STRUCT_IF_C Uc_I_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Uc_I_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Uc_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu8s, Uc_I_BFu8s)
//============================================================================



static void Test_Uc_I_BFu9i()
{
  {
    init_simple_test("Uc_I_BFu9i");
    static STRUCT_IF_C Uc_I_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_I_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu9i, Uc_I_BFu9i)
//============================================================================



static void Test_Uc_I_BFu9ll()
{
  {
    init_simple_test("Uc_I_BFu9ll");
    static STRUCT_IF_C Uc_I_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_I_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu9ll, Uc_I_BFu9ll)
//============================================================================



static void Test_Uc_I_BFu9s()
{
  {
    init_simple_test("Uc_I_BFu9s");
    static STRUCT_IF_C Uc_I_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Uc_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Uc_I_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Uc_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_BFu9s, Uc_I_BFu9s)
//============================================================================



static void Test_Uc_I_C()
{
  {
    init_simple_test("Uc_I_C");
    STRUCT_IF_C Uc_I_C lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_C)");
    check_field_offset(lv, v1, 0, "Uc_I_C.v1");
    check_field_offset(lv, v2, 1, "Uc_I_C.v2");
    check_field_offset(lv, v3, 5, "Uc_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_C, Uc_I_C)
//============================================================================



static void Test_Uc_I_D()
{
  {
    init_simple_test("Uc_I_D");
    STRUCT_IF_C Uc_I_D lv;
    check2(sizeof(lv), 13, "sizeof(Uc_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_D)");
    check_field_offset(lv, v1, 0, "Uc_I_D.v1");
    check_field_offset(lv, v2, 1, "Uc_I_D.v2");
    check_field_offset(lv, v3, 5, "Uc_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_D, Uc_I_D)
//============================================================================



static void Test_Uc_I_F()
{
  {
    init_simple_test("Uc_I_F");
    STRUCT_IF_C Uc_I_F lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_F)");
    check_field_offset(lv, v1, 0, "Uc_I_F.v1");
    check_field_offset(lv, v2, 1, "Uc_I_F.v2");
    check_field_offset(lv, v3, 5, "Uc_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_F, Uc_I_F)
//============================================================================



static void Test_Uc_I_I()
{
  {
    init_simple_test("Uc_I_I");
    STRUCT_IF_C Uc_I_I lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_I)");
    check_field_offset(lv, v1, 0, "Uc_I_I.v1");
    check_field_offset(lv, v2, 1, "Uc_I_I.v2");
    check_field_offset(lv, v3, 5, "Uc_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_I, Uc_I_I)
//============================================================================



static void Test_Uc_I_Ip()
{
  {
    init_simple_test("Uc_I_Ip");
    STRUCT_IF_C Uc_I_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_Ip)");
    check_field_offset(lv, v1, 0, "Uc_I_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_I_Ip.v2");
    check_field_offset(lv, v3, 5, "Uc_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Ip, Uc_I_Ip)
//============================================================================



static void Test_Uc_I_L()
{
  {
    init_simple_test("Uc_I_L");
    STRUCT_IF_C Uc_I_L lv;
    check2(sizeof(lv), 13, "sizeof(Uc_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_L)");
    check_field_offset(lv, v1, 0, "Uc_I_L.v1");
    check_field_offset(lv, v2, 1, "Uc_I_L.v2");
    check_field_offset(lv, v3, 5, "Uc_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_L, Uc_I_L)
//============================================================================



static void Test_Uc_I_S()
{
  {
    init_simple_test("Uc_I_S");
    STRUCT_IF_C Uc_I_S lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_S)");
    check_field_offset(lv, v1, 0, "Uc_I_S.v1");
    check_field_offset(lv, v2, 1, "Uc_I_S.v2");
    check_field_offset(lv, v3, 5, "Uc_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_S, Uc_I_S)
//============================================================================



static void Test_Uc_I_Uc()
{
  {
    init_simple_test("Uc_I_Uc");
    STRUCT_IF_C Uc_I_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Uc_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_Uc)");
    check_field_offset(lv, v1, 0, "Uc_I_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_I_Uc.v2");
    check_field_offset(lv, v3, 5, "Uc_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Uc, Uc_I_Uc)
//============================================================================



static void Test_Uc_I_Ui()
{
  {
    init_simple_test("Uc_I_Ui");
    STRUCT_IF_C Uc_I_Ui lv;
    check2(sizeof(lv), 9, "sizeof(Uc_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_Ui)");
    check_field_offset(lv, v1, 0, "Uc_I_Ui.v1");
    check_field_offset(lv, v2, 1, "Uc_I_Ui.v2");
    check_field_offset(lv, v3, 5, "Uc_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Ui, Uc_I_Ui)
//============================================================================



static void Test_Uc_I_Ul()
{
  {
    init_simple_test("Uc_I_Ul");
    STRUCT_IF_C Uc_I_Ul lv;
    check2(sizeof(lv), 13, "sizeof(Uc_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_Ul)");
    check_field_offset(lv, v1, 0, "Uc_I_Ul.v1");
    check_field_offset(lv, v2, 1, "Uc_I_Ul.v2");
    check_field_offset(lv, v3, 5, "Uc_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Ul, Uc_I_Ul)
//============================================================================



static void Test_Uc_I_Us()
{
  {
    init_simple_test("Uc_I_Us");
    STRUCT_IF_C Uc_I_Us lv;
    check2(sizeof(lv), 7, "sizeof(Uc_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_Us)");
    check_field_offset(lv, v1, 0, "Uc_I_Us.v1");
    check_field_offset(lv, v2, 1, "Uc_I_Us.v2");
    check_field_offset(lv, v3, 5, "Uc_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Us, Uc_I_Us)
//============================================================================



static void Test_Uc_I_Vp()
{
  {
    init_simple_test("Uc_I_Vp");
    STRUCT_IF_C Uc_I_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_I_Vp)");
    check_field_offset(lv, v1, 0, "Uc_I_Vp.v1");
    check_field_offset(lv, v2, 1, "Uc_I_Vp.v2");
    check_field_offset(lv, v3, 5, "Uc_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_I_Vp, Uc_I_Vp)
//============================================================================



static void Test_Uc_Ip()
{
  {
    init_simple_test("Uc_Ip");
    STRUCT_IF_C Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip, Uc_Ip)
//============================================================================



static void Test_Uc_Ip_BFu15i()
{
  {
    init_simple_test("Uc_Ip_BFu15i");
    static STRUCT_IF_C Uc_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Uc_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Uc_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu15i, Uc_Ip_BFu15i)
//============================================================================



static void Test_Uc_Ip_BFu15ll()
{
  {
    init_simple_test("Uc_Ip_BFu15ll");
    static STRUCT_IF_C Uc_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Uc_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Uc_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu15ll, Uc_Ip_BFu15ll)
//============================================================================



static void Test_Uc_Ip_BFu15s()
{
  {
    init_simple_test("Uc_Ip_BFu15s");
    static STRUCT_IF_C Uc_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "Uc_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "Uc_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu15s, Uc_Ip_BFu15s)
//============================================================================



static void Test_Uc_Ip_BFu16i()
{
  {
    init_simple_test("Uc_Ip_BFu16i");
    static STRUCT_IF_C Uc_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Uc_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Uc_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu16i, Uc_Ip_BFu16i)
//============================================================================



static void Test_Uc_Ip_BFu16ll()
{
  {
    init_simple_test("Uc_Ip_BFu16ll");
    static STRUCT_IF_C Uc_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Uc_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Uc_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu16ll, Uc_Ip_BFu16ll)
//============================================================================



static void Test_Uc_Ip_BFu16s()
{
  {
    init_simple_test("Uc_Ip_BFu16s");
    static STRUCT_IF_C Uc_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "Uc_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "Uc_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu16s, Uc_Ip_BFu16s)
//============================================================================



static void Test_Uc_Ip_BFu17i()
{
  {
    init_simple_test("Uc_Ip_BFu17i");
    static STRUCT_IF_C Uc_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Uc_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Uc_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu17i, Uc_Ip_BFu17i)
//============================================================================



static void Test_Uc_Ip_BFu17ll()
{
  {
    init_simple_test("Uc_Ip_BFu17ll");
    static STRUCT_IF_C Uc_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "Uc_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "Uc_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu17ll, Uc_Ip_BFu17ll)
//============================================================================



static void Test_Uc_Ip_BFu1c()
{
  {
    init_simple_test("Uc_Ip_BFu1c");
    static STRUCT_IF_C Uc_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Uc_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1c, Uc_Ip_BFu1c)
//============================================================================



static void Test_Uc_Ip_BFu1i()
{
  {
    init_simple_test("Uc_Ip_BFu1i");
    static STRUCT_IF_C Uc_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Uc_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1i, Uc_Ip_BFu1i)
//============================================================================



static void Test_Uc_Ip_BFu1ll()
{
  {
    init_simple_test("Uc_Ip_BFu1ll");
    static STRUCT_IF_C Uc_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Uc_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1ll, Uc_Ip_BFu1ll)
//============================================================================



static void Test_Uc_Ip_BFu1s()
{
  {
    init_simple_test("Uc_Ip_BFu1s");
    static STRUCT_IF_C Uc_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "Uc_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu1s, Uc_Ip_BFu1s)
//============================================================================



static void Test_Uc_Ip_BFu31i()
{
  {
    init_simple_test("Uc_Ip_BFu31i");
    static STRUCT_IF_C Uc_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Uc_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Uc_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu31i, Uc_Ip_BFu31i)
//============================================================================



static void Test_Uc_Ip_BFu31ll()
{
  {
    init_simple_test("Uc_Ip_BFu31ll");
    static STRUCT_IF_C Uc_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "Uc_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "Uc_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu31ll, Uc_Ip_BFu31ll)
//============================================================================



static void Test_Uc_Ip_BFu32i()
{
  {
    init_simple_test("Uc_Ip_BFu32i");
    static STRUCT_IF_C Uc_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Uc_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Uc_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu32i, Uc_Ip_BFu32i)
//============================================================================



static void Test_Uc_Ip_BFu32ll()
{
  {
    init_simple_test("Uc_Ip_BFu32ll");
    static STRUCT_IF_C Uc_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "Uc_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "Uc_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu32ll, Uc_Ip_BFu32ll)
//============================================================================



static void Test_Uc_Ip_BFu33()
{
  {
    init_simple_test("Uc_Ip_BFu33");
    static STRUCT_IF_C Uc_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(Uc_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu33.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "Uc_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "Uc_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu33, Uc_Ip_BFu33)
//============================================================================



static void Test_Uc_Ip_BFu7c()
{
  {
    init_simple_test("Uc_Ip_BFu7c");
    static STRUCT_IF_C Uc_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Uc_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7c, Uc_Ip_BFu7c)
//============================================================================



static void Test_Uc_Ip_BFu7i()
{
  {
    init_simple_test("Uc_Ip_BFu7i");
    static STRUCT_IF_C Uc_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Uc_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7i, Uc_Ip_BFu7i)
//============================================================================



static void Test_Uc_Ip_BFu7ll()
{
  {
    init_simple_test("Uc_Ip_BFu7ll");
    static STRUCT_IF_C Uc_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Uc_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7ll, Uc_Ip_BFu7ll)
//============================================================================



static void Test_Uc_Ip_BFu7s()
{
  {
    init_simple_test("Uc_Ip_BFu7s");
    static STRUCT_IF_C Uc_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "Uc_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "Uc_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu7s, Uc_Ip_BFu7s)
//============================================================================



static void Test_Uc_Ip_BFu8c()
{
  {
    init_simple_test("Uc_Ip_BFu8c");
    static STRUCT_IF_C Uc_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Uc_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8c, Uc_Ip_BFu8c)
//============================================================================



static void Test_Uc_Ip_BFu8i()
{
  {
    init_simple_test("Uc_Ip_BFu8i");
    static STRUCT_IF_C Uc_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Uc_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8i, Uc_Ip_BFu8i)
//============================================================================



static void Test_Uc_Ip_BFu8ll()
{
  {
    init_simple_test("Uc_Ip_BFu8ll");
    static STRUCT_IF_C Uc_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Uc_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8ll, Uc_Ip_BFu8ll)
//============================================================================



static void Test_Uc_Ip_BFu8s()
{
  {
    init_simple_test("Uc_Ip_BFu8s");
    static STRUCT_IF_C Uc_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "Uc_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "Uc_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu8s, Uc_Ip_BFu8s)
//============================================================================



static void Test_Uc_Ip_BFu9i()
{
  {
    init_simple_test("Uc_Ip_BFu9i");
    static STRUCT_IF_C Uc_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Uc_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Uc_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu9i, Uc_Ip_BFu9i)
//============================================================================



static void Test_Uc_Ip_BFu9ll()
{
  {
    init_simple_test("Uc_Ip_BFu9ll");
    static STRUCT_IF_C Uc_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Uc_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Uc_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu9ll, Uc_Ip_BFu9ll)
//============================================================================



static void Test_Uc_Ip_BFu9s()
{
  {
    init_simple_test("Uc_Ip_BFu9s");
    static STRUCT_IF_C Uc_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "Uc_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "Uc_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_BFu9s, Uc_Ip_BFu9s)
//============================================================================



static void Test_Uc_Ip_C()
{
  {
    init_simple_test("Uc_Ip_C");
    STRUCT_IF_C Uc_Ip_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_C)");
    check_field_offset(lv, v1, 0, "Uc_Ip_C.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_C, Uc_Ip_C)
//============================================================================



static void Test_Uc_Ip_D()
{
  {
    init_simple_test("Uc_Ip_D");
    STRUCT_IF_C Uc_Ip_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Uc_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_D)");
    check_field_offset(lv, v1, 0, "Uc_Ip_D.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_D, Uc_Ip_D)
//============================================================================



static void Test_Uc_Ip_F()
{
  {
    init_simple_test("Uc_Ip_F");
    STRUCT_IF_C Uc_Ip_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_F)");
    check_field_offset(lv, v1, 0, "Uc_Ip_F.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_F, Uc_Ip_F)
//============================================================================



static void Test_Uc_Ip_I()
{
  {
    init_simple_test("Uc_Ip_I");
    STRUCT_IF_C Uc_Ip_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_I)");
    check_field_offset(lv, v1, 0, "Uc_Ip_I.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_I, Uc_Ip_I)
//============================================================================



static void Test_Uc_Ip_Ip()
{
  {
    init_simple_test("Uc_Ip_Ip");
    STRUCT_IF_C Uc_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Uc_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_Ip)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Ip.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Ip, Uc_Ip_Ip)
//============================================================================



static void Test_Uc_Ip_L()
{
  {
    init_simple_test("Uc_Ip_L");
    STRUCT_IF_C Uc_Ip_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Uc_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_L)");
    check_field_offset(lv, v1, 0, "Uc_Ip_L.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_L, Uc_Ip_L)
//============================================================================



static void Test_Uc_Ip_S()
{
  {
    init_simple_test("Uc_Ip_S");
    STRUCT_IF_C Uc_Ip_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_S)");
    check_field_offset(lv, v1, 0, "Uc_Ip_S.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_S, Uc_Ip_S)
//============================================================================



static void Test_Uc_Ip_Uc()
{
  {
    init_simple_test("Uc_Ip_Uc");
    STRUCT_IF_C Uc_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_Uc)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Uc, Uc_Ip_Uc)
//============================================================================



static void Test_Uc_Ip_Ui()
{
  {
    init_simple_test("Uc_Ip_Ui");
    STRUCT_IF_C Uc_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(Uc_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_Ui)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Ui.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Ui, Uc_Ip_Ui)
//============================================================================



static void Test_Uc_Ip_Ul()
{
  {
    init_simple_test("Uc_Ip_Ul");
    STRUCT_IF_C Uc_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(Uc_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_Ul)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Ul.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Ul, Uc_Ip_Ul)
//============================================================================



static void Test_Uc_Ip_Us()
{
  {
    init_simple_test("Uc_Ip_Us");
    STRUCT_IF_C Uc_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(Uc_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_Us)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Us.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Us, Uc_Ip_Us)
//============================================================================



static void Test_Uc_Ip_Vp()
{
  {
    init_simple_test("Uc_Ip_Vp");
    STRUCT_IF_C Uc_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(Uc_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Ip_Vp)");
    check_field_offset(lv, v1, 0, "Uc_Ip_Vp.v1");
    check_field_offset(lv, v2, 1, "Uc_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "Uc_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_Ip_Vp, Uc_Ip_Vp)
//============================================================================



static void Test_Uc_L()
{
  {
    init_simple_test("Uc_L");
    STRUCT_IF_C Uc_L lv;
    check2(sizeof(lv), 9, "sizeof(Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L)");
    check_field_offset(lv, v1, 0, "Uc_L.v1");
    check_field_offset(lv, v2, 1, "Uc_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L, Uc_L)
//============================================================================



static void Test_Uc_L_BFu15i()
{
  {
    init_simple_test("Uc_L_BFu15i");
    static STRUCT_IF_C Uc_L_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(Uc_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Uc_L_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Uc_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu15i, Uc_L_BFu15i)
//============================================================================



static void Test_Uc_L_BFu15ll()
{
  {
    init_simple_test("Uc_L_BFu15ll");
    static STRUCT_IF_C Uc_L_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(Uc_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Uc_L_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Uc_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu15ll, Uc_L_BFu15ll)
//============================================================================



static void Test_Uc_L_BFu15s()
{
  {
    init_simple_test("Uc_L_BFu15s");
    static STRUCT_IF_C Uc_L_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(Uc_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Uc_L_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Uc_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu15s, Uc_L_BFu15s)
//============================================================================



static void Test_Uc_L_BFu16i()
{
  {
    init_simple_test("Uc_L_BFu16i");
    static STRUCT_IF_C Uc_L_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(Uc_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Uc_L_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Uc_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu16i, Uc_L_BFu16i)
//============================================================================



static void Test_Uc_L_BFu16ll()
{
  {
    init_simple_test("Uc_L_BFu16ll");
    static STRUCT_IF_C Uc_L_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(Uc_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Uc_L_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Uc_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu16ll, Uc_L_BFu16ll)
//============================================================================



static void Test_Uc_L_BFu16s()
{
  {
    init_simple_test("Uc_L_BFu16s");
    static STRUCT_IF_C Uc_L_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(Uc_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Uc_L_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Uc_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu16s, Uc_L_BFu16s)
//============================================================================



static void Test_Uc_L_BFu17i()
{
  {
    init_simple_test("Uc_L_BFu17i");
    static STRUCT_IF_C Uc_L_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Uc_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Uc_L_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Uc_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu17i, Uc_L_BFu17i)
//============================================================================



static void Test_Uc_L_BFu17ll()
{
  {
    init_simple_test("Uc_L_BFu17ll");
    static STRUCT_IF_C Uc_L_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(Uc_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Uc_L_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Uc_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu17ll, Uc_L_BFu17ll)
//============================================================================



static void Test_Uc_L_BFu1c()
{
  {
    init_simple_test("Uc_L_BFu1c");
    static STRUCT_IF_C Uc_L_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(Uc_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1c, Uc_L_BFu1c)
//============================================================================



static void Test_Uc_L_BFu1i()
{
  {
    init_simple_test("Uc_L_BFu1i");
    static STRUCT_IF_C Uc_L_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(Uc_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1i, Uc_L_BFu1i)
//============================================================================



static void Test_Uc_L_BFu1ll()
{
  {
    init_simple_test("Uc_L_BFu1ll");
    static STRUCT_IF_C Uc_L_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(Uc_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1ll, Uc_L_BFu1ll)
//============================================================================



static void Test_Uc_L_BFu1s()
{
  {
    init_simple_test("Uc_L_BFu1s");
    static STRUCT_IF_C Uc_L_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(Uc_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Uc_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu1s, Uc_L_BFu1s)
//============================================================================



static void Test_Uc_L_BFu31i()
{
  {
    init_simple_test("Uc_L_BFu31i");
    static STRUCT_IF_C Uc_L_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(Uc_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Uc_L_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Uc_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu31i, Uc_L_BFu31i)
//============================================================================



static void Test_Uc_L_BFu31ll()
{
  {
    init_simple_test("Uc_L_BFu31ll");
    static STRUCT_IF_C Uc_L_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(Uc_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Uc_L_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Uc_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_BFu31ll, Uc_L_BFu31ll)
//============================================================================



static void Test_Uc_L_BFu32i()
{
  {
    init_simple_test("Uc_L_BFu32i");
    static STRUCT_IF_C Uc_L_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(Uc_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_L_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Uc_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Uc_L_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Uc_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Uc_L_B