// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct L_BFu1s_BFu8i { long long v1; unsigned short v2:1; unsigned int v3:8; };
struct L_BFu1s_BFu8ll { long long v1; unsigned short v2:1; unsigned long long v3:8; };
struct L_BFu1s_BFu8s { long long v1; unsigned short v2:1; unsigned short v3:8; };
struct L_BFu1s_BFu9i { long long v1; unsigned short v2:1; unsigned int v3:9; };
struct L_BFu1s_BFu9ll { long long v1; unsigned short v2:1; unsigned long long v3:9; };
struct L_BFu1s_BFu9s { long long v1; unsigned short v2:1; unsigned short v3:9; };
struct L_BFu1s_C { long long v1; unsigned short v2:1; char v3; };
struct L_BFu1s_D { long long v1; unsigned short v2:1; double v3; };
struct L_BFu1s_F { long long v1; unsigned short v2:1; float v3; };
struct L_BFu1s_I { long long v1; unsigned short v2:1; int v3; };
struct L_BFu1s_Ip { long long v1; unsigned short v2:1; int * v3; };
struct L_BFu1s_L { long long v1; unsigned short v2:1; long long v3; };
struct L_BFu1s_S { long long v1; unsigned short v2:1; short v3; };
struct L_BFu1s_Uc { long long v1; unsigned short v2:1; unsigned char v3; };
struct L_BFu1s_Ui { long long v1; unsigned short v2:1; unsigned int v3; };
struct L_BFu1s_Ul { long long v1; unsigned short v2:1; unsigned long long v3; };
struct L_BFu1s_Us { long long v1; unsigned short v2:1; unsigned short v3; };
struct L_BFu1s_Vp { long long v1; unsigned short v2:1; void * v3; };
struct L_BFu31i { long long v1; unsigned int v2:31; };
struct L_BFu31i_BFu15i { long long v1; unsigned int v2:31; unsigned int v3:15; };
struct L_BFu31i_BFu15ll { long long v1; unsigned int v2:31; unsigned long long v3:15; };
struct L_BFu31i_BFu15s { long long v1; unsigned int v2:31; unsigned short v3:15; };
struct L_BFu31i_BFu16i { long long v1; unsigned int v2:31; unsigned int v3:16; };
struct L_BFu31i_BFu16ll { long long v1; unsigned int v2:31; unsigned long long v3:16; };
struct L_BFu31i_BFu16s { long long v1; unsigned int v2:31; unsigned short v3:16; };
struct L_BFu31i_BFu17i { long long v1; unsigned int v2:31; unsigned int v3:17; };
struct L_BFu31i_BFu17ll { long long v1; unsigned int v2:31; unsigned long long v3:17; };
struct L_BFu31i_BFu1c { long long v1; unsigned int v2:31; unsigned char v3:1; };
struct L_BFu31i_BFu1i { long long v1; unsigned int v2:31; unsigned int v3:1; };
struct L_BFu31i_BFu1ll { long long v1; unsigned int v2:31; unsigned long long v3:1; };
struct L_BFu31i_BFu1s { long long v1; unsigned int v2:31; unsigned short v3:1; };
struct L_BFu31i_BFu31i { long long v1; unsigned int v2:31; unsigned int v3:31; };
struct L_BFu31i_BFu31ll { long long v1; unsigned int v2:31; unsigned long long v3:31; };
struct L_BFu31i_BFu32i { long long v1; unsigned int v2:31; unsigned int v3:32; };
struct L_BFu31i_BFu32ll { long long v1; unsigned int v2:31; unsigned long long v3:32; };
struct L_BFu31i_BFu33 { long long v1; unsigned int v2:31; unsigned long long v3:33; };
struct L_BFu31i_BFu7c { long long v1; unsigned int v2:31; unsigned char v3:7; };
struct L_BFu31i_BFu7i { long long v1; unsigned int v2:31; unsigned int v3:7; };
struct L_BFu31i_BFu7ll { long long v1; unsigned int v2:31; unsigned long long v3:7; };
struct L_BFu31i_BFu7s { long long v1; unsigned int v2:31; unsigned short v3:7; };
struct L_BFu31i_BFu8c { long long v1; unsigned int v2:31; unsigned char v3:8; };
struct L_BFu31i_BFu8i { long long v1; unsigned int v2:31; unsigned int v3:8; };
struct L_BFu31i_BFu8ll { long long v1; unsigned int v2:31; unsigned long long v3:8; };
struct L_BFu31i_BFu8s { long long v1; unsigned int v2:31; unsigned short v3:8; };
struct L_BFu31i_BFu9i { long long v1; unsigned int v2:31; unsigned int v3:9; };
struct L_BFu31i_BFu9ll { long long v1; unsigned int v2:31; unsigned long long v3:9; };
struct L_BFu31i_BFu9s { long long v1; unsigned int v2:31; unsigned short v3:9; };
struct L_BFu31i_C { long long v1; unsigned int v2:31; char v3; };
struct L_BFu31i_D { long long v1; unsigned int v2:31; double v3; };
struct L_BFu31i_F { long long v1; unsigned int v2:31; float v3; };
struct L_BFu31i_I { long long v1; unsigned int v2:31; int v3; };
struct L_BFu31i_Ip { long long v1; unsigned int v2:31; int * v3; };
struct L_BFu31i_L { long long v1; unsigned int v2:31; long long v3; };
struct L_BFu31i_S { long long v1; unsigned int v2:31; short v3; };
struct L_BFu31i_Uc { long long v1; unsigned int v2:31; unsigned char v3; };
struct L_BFu31i_Ui { long long v1; unsigned int v2:31; unsigned int v3; };
struct L_BFu31i_Ul { long long v1; unsigned int v2:31; unsigned long long v3; };
struct L_BFu31i_Us { long long v1; unsigned int v2:31; unsigned short v3; };
struct L_BFu31i_Vp { long long v1; unsigned int v2:31; void * v3; };
struct L_BFu31ll { long long v1; unsigned long long v2:31; };
struct L_BFu31ll_BFu15i { long long v1; unsigned long long v2:31; unsigned int v3:15; };
struct L_BFu31ll_BFu15ll { long long v1; unsigned long long v2:31; unsigned long long v3:15; };
struct L_BFu31ll_BFu15s { long long v1; unsigned long long v2:31; unsigned short v3:15; };
struct L_BFu31ll_BFu16i { long long v1; unsigned long long v2:31; unsigned int v3:16; };
struct L_BFu31ll_BFu16ll { long long v1; unsigned long long v2:31; unsigned long long v3:16; };
struct L_BFu31ll_BFu16s { long long v1; unsigned long long v2:31; unsigned short v3:16; };
struct L_BFu31ll_BFu17i { long long v1; unsigned long long v2:31; unsigned int v3:17; };
struct L_BFu31ll_BFu17ll { long long v1; unsigned long long v2:31; unsigned long long v3:17; };
struct L_BFu31ll_BFu1c { long long v1; unsigned long long v2:31; unsigned char v3:1; };
struct L_BFu31ll_BFu1i { long long v1; unsigned long long v2:31; unsigned int v3:1; };
struct L_BFu31ll_BFu1ll { long long v1; unsigned long long v2:31; unsigned long long v3:1; };
struct L_BFu31ll_BFu1s { long long v1; unsigned long long v2:31; unsigned short v3:1; };
struct L_BFu31ll_BFu31i { long long v1; unsigned long long v2:31; unsigned int v3:31; };
struct L_BFu31ll_BFu31ll { long long v1; unsigned long long v2:31; unsigned long long v3:31; };
struct L_BFu31ll_BFu32i { long long v1; unsigned long long v2:31; unsigned int v3:32; };
struct L_BFu31ll_BFu32ll { long long v1; unsigned long long v2:31; unsigned long long v3:32; };
struct L_BFu31ll_BFu33 { long long v1; unsigned long long v2:31; unsigned long long v3:33; };
struct L_BFu31ll_BFu7c { long long v1; unsigned long long v2:31; unsigned char v3:7; };
struct L_BFu31ll_BFu7i { long long v1; unsigned long long v2:31; unsigned int v3:7; };
struct L_BFu31ll_BFu7ll { long long v1; unsigned long long v2:31; unsigned long long v3:7; };
struct L_BFu31ll_BFu7s { long long v1; unsigned long long v2:31; unsigned short v3:7; };
struct L_BFu31ll_BFu8c { long long v1; unsigned long long v2:31; unsigned char v3:8; };
struct L_BFu31ll_BFu8i { long long v1; unsigned long long v2:31; unsigned int v3:8; };
struct L_BFu31ll_BFu8ll { long long v1; unsigned long long v2:31; unsigned long long v3:8; };
struct L_BFu31ll_BFu8s { long long v1; unsigned long long v2:31; unsigned short v3:8; };
struct L_BFu31ll_BFu9i { long long v1; unsigned long long v2:31; unsigned int v3:9; };
struct L_BFu31ll_BFu9ll { long long v1; unsigned long long v2:31; unsigned long long v3:9; };
struct L_BFu31ll_BFu9s { long long v1; unsigned long long v2:31; unsigned short v3:9; };
struct L_BFu31ll_C { long long v1; unsigned long long v2:31; char v3; };
struct L_BFu31ll_D { long long v1; unsigned long long v2:31; double v3; };
struct L_BFu31ll_F { long long v1; unsigned long long v2:31; float v3; };
struct L_BFu31ll_I { long long v1; unsigned long long v2:31; int v3; };
struct L_BFu31ll_Ip { long long v1; unsigned long long v2:31; int * v3; };
struct L_BFu31ll_L { long long v1; unsigned long long v2:31; long long v3; };
struct L_BFu31ll_S { long long v1; unsigned long long v2:31; short v3; };
struct L_BFu31ll_Uc { long long v1; unsigned long long v2:31; unsigned char v3; };
struct L_BFu31ll_Ui { long long v1; unsigned long long v2:31; unsigned int v3; };
struct L_BFu31ll_Ul { long long v1; unsigned long long v2:31; unsigned long long v3; };
struct L_BFu31ll_Us { long long v1; unsigned long long v2:31; unsigned short v3; };
struct L_BFu31ll_Vp { long long v1; unsigned long long v2:31; void * v3; };
struct L_BFu32i { long long v1; unsigned int v2:32; };
struct L_BFu32i_BFu15i { long long v1; unsigned int v2:32; unsigned int v3:15; };
struct L_BFu32i_BFu15ll { long long v1; unsigned int v2:32; unsigned long long v3:15; };
struct L_BFu32i_BFu15s { long long v1; unsigned int v2:32; unsigned short v3:15; };
struct L_BFu32i_BFu16i { long long v1; unsigned int v2:32; unsigned int v3:16; };
struct L_BFu32i_BFu16ll { long long v1; unsigned int v2:32; unsigned long long v3:16; };
struct L_BFu32i_BFu16s { long long v1; unsigned int v2:32; unsigned short v3:16; };
struct L_BFu32i_BFu17i { long long v1; unsigned int v2:32; unsigned int v3:17; };
struct L_BFu32i_BFu17ll { long long v1; unsigned int v2:32; unsigned long long v3:17; };
struct L_BFu32i_BFu1c { long long v1; unsigned int v2:32; unsigned char v3:1; };
struct L_BFu32i_BFu1i { long long v1; unsigned int v2:32; unsigned int v3:1; };
struct L_BFu32i_BFu1ll { long long v1; unsigned int v2:32; unsigned long long v3:1; };
struct L_BFu32i_BFu1s { long long v1; unsigned int v2:32; unsigned short v3:1; };
struct L_BFu32i_BFu31i { long long v1; unsigned int v2:32; unsigned int v3:31; };
struct L_BFu32i_BFu31ll { long long v1; unsigned int v2:32; unsigned long long v3:31; };
struct L_BFu32i_BFu32i { long long v1; unsigned int v2:32; unsigned int v3:32; };
struct L_BFu32i_BFu32ll { long long v1; unsigned int v2:32; unsigned long long v3:32; };
struct L_BFu32i_BFu33 { long long v1; unsigned int v2:32; unsigned long long v3:33; };
struct L_BFu32i_BFu7c { long long v1; unsigned int v2:32; unsigned char v3:7; };
struct L_BFu32i_BFu7i { long long v1; unsigned int v2:32; unsigned int v3:7; };
struct L_BFu32i_BFu7ll { long long v1; unsigned int v2:32; unsigned long long v3:7; };
struct L_BFu32i_BFu7s { long long v1; unsigned int v2:32; unsigned short v3:7; };
struct L_BFu32i_BFu8c { long long v1; unsigned int v2:32; unsigned char v3:8; };
struct L_BFu32i_BFu8i { long long v1; unsigned int v2:32; unsigned int v3:8; };
struct L_BFu32i_BFu8ll { long long v1; unsigned int v2:32; unsigned long long v3:8; };
struct L_BFu32i_BFu8s { long long v1; unsigned int v2:32; unsigned short v3:8; };
struct L_BFu32i_BFu9i { long long v1; unsigned int v2:32; unsigned int v3:9; };
struct L_BFu32i_BFu9ll { long long v1; unsigned int v2:32; unsigned long long v3:9; };
struct L_BFu32i_BFu9s { long long v1; unsigned int v2:32; unsigned short v3:9; };
struct L_BFu32i_C { long long v1; unsigned int v2:32; char v3; };
struct L_BFu32i_D { long long v1; unsigned int v2:32; double v3; };
struct L_BFu32i_F { long long v1; unsigned int v2:32; float v3; };
struct L_BFu32i_I { long long v1; unsigned int v2:32; int v3; };
struct L_BFu32i_Ip { long long v1; unsigned int v2:32; int * v3; };
struct L_BFu32i_L { long long v1; unsigned int v2:32; long long v3; };
struct L_BFu32i_S { long long v1; unsigned int v2:32; short v3; };
struct L_BFu32i_Uc { long long v1; unsigned int v2:32; unsigned char v3; };
struct L_BFu32i_Ui { long long v1; unsigned int v2:32; unsigned int v3; };
struct L_BFu32i_Ul { long long v1; unsigned int v2:32; unsigned long long v3; };
struct L_BFu32i_Us { long long v1; unsigned int v2:32; unsigned short v3; };
struct L_BFu32i_Vp { long long v1; unsigned int v2:32; void * v3; };
struct L_BFu32ll { long long v1; unsigned long long v2:32; };
struct L_BFu32ll_BFu15i { long long v1; unsigned long long v2:32; unsigned int v3:15; };
struct L_BFu32ll_BFu15ll { long long v1; unsigned long long v2:32; unsigned long long v3:15; };
struct L_BFu32ll_BFu15s { long long v1; unsigned long long v2:32; unsigned short v3:15; };
struct L_BFu32ll_BFu16i { long long v1; unsigned long long v2:32; unsigned int v3:16; };
struct L_BFu32ll_BFu16ll { long long v1; unsigned long long v2:32; unsigned long long v3:16; };
struct L_BFu32ll_BFu16s { long long v1; unsigned long long v2:32; unsigned short v3:16; };
struct L_BFu32ll_BFu17i { long long v1; unsigned long long v2:32; unsigned int v3:17; };
struct L_BFu32ll_BFu17ll { long long v1; unsigned long long v2:32; unsigned long long v3:17; };
struct L_BFu32ll_BFu1c { long long v1; unsigned long long v2:32; unsigned char v3:1; };
struct L_BFu32ll_BFu1i { long long v1; unsigned long long v2:32; unsigned int v3:1; };
struct L_BFu32ll_BFu1ll { long long v1; unsigned long long v2:32; unsigned long long v3:1; };
struct L_BFu32ll_BFu1s { long long v1; unsigned long long v2:32; unsigned short v3:1; };
struct L_BFu32ll_BFu31i { long long v1; unsigned long long v2:32; unsigned int v3:31; };
struct L_BFu32ll_BFu31ll { long long v1; unsigned long long v2:32; unsigned long long v3:31; };
struct L_BFu32ll_BFu32i { long long v1; unsigned long long v2:32; unsigned int v3:32; };
struct L_BFu32ll_BFu32ll { long long v1; unsigned long long v2:32; unsigned long long v3:32; };
struct L_BFu32ll_BFu33 { long long v1; unsigned long long v2:32; unsigned long long v3:33; };
struct L_BFu32ll_BFu7c { long long v1; unsigned long long v2:32; unsigned char v3:7; };
struct L_BFu32ll_BFu7i { long long v1; unsigned long long v2:32; unsigned int v3:7; };
struct L_BFu32ll_BFu7ll { long long v1; unsigned long long v2:32; unsigned long long v3:7; };
struct L_BFu32ll_BFu7s { long long v1; unsigned long long v2:32; unsigned short v3:7; };
struct L_BFu32ll_BFu8c { long long v1; unsigned long long v2:32; unsigned char v3:8; };
struct L_BFu32ll_BFu8i { long long v1; unsigned long long v2:32; unsigned int v3:8; };
struct L_BFu32ll_BFu8ll { long long v1; unsigned long long v2:32; unsigned long long v3:8; };
struct L_BFu32ll_BFu8s { long long v1; unsigned long long v2:32; unsigned short v3:8; };
struct L_BFu32ll_BFu9i { long long v1; unsigned long long v2:32; unsigned int v3:9; };
struct L_BFu32ll_BFu9ll { long long v1; unsigned long long v2:32; unsigned long long v3:9; };
struct L_BFu32ll_BFu9s { long long v1; unsigned long long v2:32; unsigned short v3:9; };
struct L_BFu32ll_C { long long v1; unsigned long long v2:32; char v3; };
struct L_BFu32ll_D { long long v1; unsigned long long v2:32; double v3; };
struct L_BFu32ll_F { long long v1; unsigned long long v2:32; float v3; };
struct L_BFu32ll_I { long long v1; unsigned long long v2:32; int v3; };
struct L_BFu32ll_Ip { long long v1; unsigned long long v2:32; int * v3; };
struct L_BFu32ll_L { long long v1; unsigned long long v2:32; long long v3; };
struct L_BFu32ll_S { long long v1; unsigned long long v2:32; short v3; };
struct L_BFu32ll_Uc { long long v1; unsigned long long v2:32; unsigned char v3; };
struct L_BFu32ll_Ui { long long v1; unsigned long long v2:32; unsigned int v3; };
struct L_BFu32ll_Ul { long long v1; unsigned long long v2:32; unsigned long long v3; };
struct L_BFu32ll_Us { long long v1; unsigned long long v2:32; unsigned short v3; };
struct L_BFu32ll_Vp { long long v1; unsigned long long v2:32; void * v3; };
struct L_BFu33 { long long v1; unsigned long long v2:33; };
struct L_BFu33_BFu15i { long long v1; unsigned long long v2:33; unsigned int v3:15; };
struct L_BFu33_BFu15ll { long long v1; unsigned long long v2:33; unsigned long long v3:15; };
struct L_BFu33_BFu15s { long long v1; unsigned long long v2:33; unsigned short v3:15; };
struct L_BFu33_BFu16i { long long v1; unsigned long long v2:33; unsigned int v3:16; };
struct L_BFu33_BFu16ll { long long v1; unsigned long long v2:33; unsigned long long v3:16; };
struct L_BFu33_BFu16s { long long v1; unsigned long long v2:33; unsigned short v3:16; };
struct L_BFu33_BFu17i { long long v1; unsigned long long v2:33; unsigned int v3:17; };
struct L_BFu33_BFu17ll { long long v1; unsigned long long v2:33; unsigned long long v3:17; };
struct L_BFu33_BFu1c { long long v1; unsigned long long v2:33; unsigned char v3:1; };
struct L_BFu33_BFu1i { long long v1; unsigned long long v2:33; unsigned int v3:1; };
struct L_BFu33_BFu1ll { long long v1; unsigned long long v2:33; unsigned long long v3:1; };
struct L_BFu33_BFu1s { long long v1; unsigned long long v2:33; unsigned short v3:1; };
struct L_BFu33_BFu31i { long long v1; unsigned long long v2:33; unsigned int v3:31; };
struct L_BFu33_BFu31ll { long long v1; unsigned long long v2:33; unsigned long long v3:31; };
struct L_BFu33_BFu32i { long long v1; unsigned long long v2:33; unsigned int v3:32; };
struct L_BFu33_BFu32ll { long long v1; unsigned long long v2:33; unsigned long long v3:32; };
struct L_BFu33_BFu33 { long long v1; unsigned long long v2:33; unsigned long long v3:33; };
struct L_BFu33_BFu7c { long long v1; unsigned long long v2:33; unsigned char v3:7; };
struct L_BFu33_BFu7i { long long v1; unsigned long long v2:33; unsigned int v3:7; };
struct L_BFu33_BFu7ll { long long v1; unsigned long long v2:33; unsigned long long v3:7; };
struct L_BFu33_BFu7s { long long v1; unsigned long long v2:33; unsigned short v3:7; };
struct L_BFu33_BFu8c { long long v1; unsigned long long v2:33; unsigned char v3:8; };
struct L_BFu33_BFu8i { long long v1; unsigned long long v2:33; unsigned int v3:8; };
struct L_BFu33_BFu8ll { long long v1; unsigned long long v2:33; unsigned long long v3:8; };
struct L_BFu33_BFu8s { long long v1; unsigned long long v2:33; unsigned short v3:8; };
struct L_BFu33_BFu9i { long long v1; unsigned long long v2:33; unsigned int v3:9; };
struct L_BFu33_BFu9ll { long long v1; unsigned long long v2:33; unsigned long long v3:9; };
struct L_BFu33_BFu9s { long long v1; unsigned long long v2:33; unsigned short v3:9; };
struct L_BFu33_C { long long v1; unsigned long long v2:33; char v3; };
struct L_BFu33_D { long long v1; unsigned long long v2:33; double v3; };
struct L_BFu33_F { long long v1; unsigned long long v2:33; float v3; };
struct L_BFu33_I { long long v1; unsigned long long v2:33; int v3; };
struct L_BFu33_Ip { long long v1; unsigned long long v2:33; int * v3; };
struct L_BFu33_L { long long v1; unsigned long long v2:33; long long v3; };
struct L_BFu33_S { long long v1; unsigned long long v2:33; short v3; };
struct L_BFu33_Uc { long long v1; unsigned long long v2:33; unsigned char v3; };
struct L_BFu33_Ui { long long v1; unsigned long long v2:33; unsigned int v3; };
struct L_BFu33_Ul { long long v1; unsigned long long v2:33; unsigned long long v3; };
struct L_BFu33_Us { long long v1; unsigned long long v2:33; unsigned short v3; };
struct L_BFu33_Vp { long long v1; unsigned long long v2:33; void * v3; };
struct L_BFu7c { long long v1; unsigned char v2:7; };
struct L_BFu7c_BFu15i { long long v1; unsigned char v2:7; unsigned int v3:15; };
struct L_BFu7c_BFu15ll { long long v1; unsigned char v2:7; unsigned long long v3:15; };
struct L_BFu7c_BFu15s { long long v1; unsigned char v2:7; unsigned short v3:15; };
struct L_BFu7c_BFu16i { long long v1; unsigned char v2:7; unsigned int v3:16; };
struct L_BFu7c_BFu16ll { long long v1; unsigned char v2:7; unsigned long long v3:16; };
struct L_BFu7c_BFu16s { long long v1; unsigned char v2:7; unsigned short v3:16; };
struct L_BFu7c_BFu17i { long long v1; unsigned char v2:7; unsigned int v3:17; };
struct L_BFu7c_BFu17ll { long long v1; unsigned char v2:7; unsigned long long v3:17; };
struct L_BFu7c_BFu1c { long long v1; unsigned char v2:7; unsigned char v3:1; };
struct L_BFu7c_BFu1i { long long v1; unsigned char v2:7; unsigned int v3:1; };
struct L_BFu7c_BFu1ll { long long v1; unsigned char v2:7; unsigned long long v3:1; };
struct L_BFu7c_BFu1s { long long v1; unsigned char v2:7; unsigned short v3:1; };
struct L_BFu7c_BFu31i { long long v1; unsigned char v2:7; unsigned int v3:31; };
struct L_BFu7c_BFu31ll { long long v1; unsigned char v2:7; unsigned long long v3:31; };
struct L_BFu7c_BFu32i { long long v1; unsigned char v2:7; unsigned int v3:32; };
struct L_BFu7c_BFu32ll { long long v1; unsigned char v2:7; unsigned long long v3:32; };
struct L_BFu7c_BFu33 { long long v1; unsigned char v2:7; unsigned long long v3:33; };
struct L_BFu7c_BFu7c { long long v1; unsigned char v2:7; unsigned char v3:7; };
struct L_BFu7c_BFu7i { long long v1; unsigned char v2:7; unsigned int v3:7; };
struct L_BFu7c_BFu7ll { long long v1; unsigned char v2:7; unsigned long long v3:7; };
struct L_BFu7c_BFu7s { long long v1; unsigned char v2:7; unsigned short v3:7; };
struct L_BFu7c_BFu8c { long long v1; unsigned char v2:7; unsigned char v3:8; };
struct L_BFu7c_BFu8i { long long v1; unsigned char v2:7; unsigned int v3:8; };
struct L_BFu7c_BFu8ll { long long v1; unsigned char v2:7; unsigned long long v3:8; };
struct L_BFu7c_BFu8s { long long v1; unsigned char v2:7; unsigned short v3:8; };
struct L_BFu7c_BFu9i { long long v1; unsigned char v2:7; unsigned int v3:9; };
struct L_BFu7c_BFu9ll { long long v1; unsigned char v2:7; unsigned long long v3:9; };
struct L_BFu7c_BFu9s { long long v1; unsigned char v2:7; unsigned short v3:9; };
struct L_BFu7c_C { long long v1; unsigned char v2:7; char v3; };
struct L_BFu7c_D { long long v1; unsigned char v2:7; double v3; };
struct L_BFu7c_F { long long v1; unsigned char v2:7; float v3; };
struct L_BFu7c_I { long long v1; unsigned char v2:7; int v3; };
struct L_BFu7c_Ip { long long v1; unsigned char v2:7; int * v3; };
struct L_BFu7c_L { long long v1; unsigned char v2:7; long long v3; };
struct L_BFu7c_S { long long v1; unsigned char v2:7; short v3; };
struct L_BFu7c_Uc { long long v1; unsigned char v2:7; unsigned char v3; };
struct L_BFu7c_Ui { long long v1; unsigned char v2:7; unsigned int v3; };
struct L_BFu7c_Ul { long long v1; unsigned char v2:7; unsigned long long v3; };
struct L_BFu7c_Us { long long v1; unsigned char v2:7; unsigned short v3; };
struct L_BFu7c_Vp { long long v1; unsigned char v2:7; void * v3; };
struct L_BFu7i { long long v1; unsigned int v2:7; };
struct L_BFu7i_BFu15i { long long v1; unsigned int v2:7; unsigned int v3:15; };
struct L_BFu7i_BFu15ll { long long v1; unsigned int v2:7; unsigned long long v3:15; };
struct L_BFu7i_BFu15s { long long v1; unsigned int v2:7; unsigned short v3:15; };
struct L_BFu7i_BFu16i { long long v1; unsigned int v2:7; unsigned int v3:16; };
struct L_BFu7i_BFu16ll { long long v1; unsigned int v2:7; unsigned long long v3:16; };
struct L_BFu7i_BFu16s { long long v1; unsigned int v2:7; unsigned short v3:16; };
struct L_BFu7i_BFu17i { long long v1; unsigned int v2:7; unsigned int v3:17; };
struct L_BFu7i_BFu17ll { long long v1; unsigned int v2:7; unsigned long long v3:17; };
struct L_BFu7i_BFu1c { long long v1; unsigned int v2:7; unsigned char v3:1; };
struct L_BFu7i_BFu1i { long long v1; unsigned int v2:7; unsigned int v3:1; };
struct L_BFu7i_BFu1ll { long long v1; unsigned int v2:7; unsigned long long v3:1; };
struct L_BFu7i_BFu1s { long long v1; unsigned int v2:7; unsigned short v3:1; };
struct L_BFu7i_BFu31i { long long v1; unsigned int v2:7; unsigned int v3:31; };
struct L_BFu7i_BFu31ll { long long v1; unsigned int v2:7; unsigned long long v3:31; };
struct L_BFu7i_BFu32i { long long v1; unsigned int v2:7; unsigned int v3:32; };
struct L_BFu7i_BFu32ll { long long v1; unsigned int v2:7; unsigned long long v3:32; };
struct L_BFu7i_BFu33 { long long v1; unsigned int v2:7; unsigned long long v3:33; };
struct L_BFu7i_BFu7c { long long v1; unsigned int v2:7; unsigned char v3:7; };
struct L_BFu7i_BFu7i { long long v1; unsigned int v2:7; unsigned int v3:7; };
struct L_BFu7i_BFu7ll { long long v1; unsigned int v2:7; unsigned long long v3:7; };
struct L_BFu7i_BFu7s { long long v1; unsigned int v2:7; unsigned short v3:7; };
struct L_BFu7i_BFu8c { long long v1; unsigned int v2:7; unsigned char v3:8; };
struct L_BFu7i_BFu8i { long long v1; unsigned int v2:7; unsigned int v3:8; };
struct L_BFu7i_BFu8ll { long long v1; unsigned int v2:7; unsigned long long v3:8; };
struct L_BFu7i_BFu8s { long long v1; unsigned int v2:7; unsigned short v3:8; };
struct L_BFu7i_BFu9i { long long v1; unsigned int v2:7; unsigned int v3:9; };
struct L_BFu7i_BFu9ll { long long v1; unsigned int v2:7; unsigned long long v3:9; };
struct L_BFu7i_BFu9s { long long v1; unsigned int v2:7; unsigned short v3:9; };
struct L_BFu7i_C { long long v1; unsigned int v2:7; char v3; };
struct L_BFu7i_D { long long v1; unsigned int v2:7; double v3; };
struct L_BFu7i_F { long long v1; unsigned int v2:7; float v3; };
struct L_BFu7i_I { long long v1; unsigned int v2:7; int v3; };
struct L_BFu7i_Ip { long long v1; unsigned int v2:7; int * v3; };
struct L_BFu7i_L { long long v1; unsigned int v2:7; long long v3; };
struct L_BFu7i_S { long long v1; unsigned int v2:7; short v3; };
struct L_BFu7i_Uc { long long v1; unsigned int v2:7; unsigned char v3; };
struct L_BFu7i_Ui { long long v1; unsigned int v2:7; unsigned int v3; };
struct L_BFu7i_Ul { long long v1; unsigned int v2:7; unsigned long long v3; };
struct L_BFu7i_Us { long long v1; unsigned int v2:7; unsigned short v3; };
struct L_BFu7i_Vp { long long v1; unsigned int v2:7; void * v3; };
struct L_BFu7ll { long long v1; unsigned long long v2:7; };
struct L_BFu7ll_BFu15i { long long v1; unsigned long long v2:7; unsigned int v3:15; };
struct L_BFu7ll_BFu15ll { long long v1; unsigned long long v2:7; unsigned long long v3:15; };
struct L_BFu7ll_BFu15s { long long v1; unsigned long long v2:7; unsigned short v3:15; };
struct L_BFu7ll_BFu16i { long long v1; unsigned long long v2:7; unsigned int v3:16; };
struct L_BFu7ll_BFu16ll { long long v1; unsigned long long v2:7; unsigned long long v3:16; };
struct L_BFu7ll_BFu16s { long long v1; unsigned long long v2:7; unsigned short v3:16; };
struct L_BFu7ll_BFu17i { long long v1; unsigned long long v2:7; unsigned int v3:17; };
struct L_BFu7ll_BFu17ll { long long v1; unsigned long long v2:7; unsigned long long v3:17; };
struct L_BFu7ll_BFu1c { long long v1; unsigned long long v2:7; unsigned char v3:1; };
struct L_BFu7ll_BFu1i { long long v1; unsigned long long v2:7; unsigned int v3:1; };
struct L_BFu7ll_BFu1ll { long long v1; unsigned long long v2:7; unsigned long long v3:1; };
struct L_BFu7ll_BFu1s { long long v1; unsigned long long v2:7; unsigned short v3:1; };
struct L_BFu7ll_BFu31i { long long v1; unsigned long long v2:7; unsigned int v3:31; };
struct L_BFu7ll_BFu31ll { long long v1; unsigned long long v2:7; unsigned long long v3:31; };
struct L_BFu7ll_BFu32i { long long v1; unsigned long long v2:7; unsigned int v3:32; };
struct L_BFu7ll_BFu32ll { long long v1; unsigned long long v2:7; unsigned long long v3:32; };
struct L_BFu7ll_BFu33 { long long v1; unsigned long long v2:7; unsigned long long v3:33; };
struct L_BFu7ll_BFu7c { long long v1; unsigned long long v2:7; unsigned char v3:7; };
struct L_BFu7ll_BFu7i { long long v1; unsigned long long v2:7; unsigned int v3:7; };
struct L_BFu7ll_BFu7ll { long long v1; unsigned long long v2:7; unsigned long long v3:7; };
struct L_BFu7ll_BFu7s { long long v1; unsigned long long v2:7; unsigned short v3:7; };
struct L_BFu7ll_BFu8c { long long v1; unsigned long long v2:7; unsigned char v3:8; };
struct L_BFu7ll_BFu8i { long long v1; unsigned long long v2:7; unsigned int v3:8; };
struct L_BFu7ll_BFu8ll { long long v1; unsigned long long v2:7; unsigned long long v3:8; };
struct L_BFu7ll_BFu8s { long long v1; unsigned long long v2:7; unsigned short v3:8; };
struct L_BFu7ll_BFu9i { long long v1; unsigned long long v2:7; unsigned int v3:9; };
struct L_BFu7ll_BFu9ll { long long v1; unsigned long long v2:7; unsigned long long v3:9; };
struct L_BFu7ll_BFu9s { long long v1; unsigned long long v2:7; unsigned short v3:9; };
struct L_BFu7ll_C { long long v1; unsigned long long v2:7; char v3; };
struct L_BFu7ll_D { long long v1; unsigned long long v2:7; double v3; };
struct L_BFu7ll_F { long long v1; unsigned long long v2:7; float v3; };
struct L_BFu7ll_I { long long v1; unsigned long long v2:7; int v3; };
struct L_BFu7ll_Ip { long long v1; unsigned long long v2:7; int * v3; };
struct L_BFu7ll_L { long long v1; unsigned long long v2:7; long long v3; };
struct L_BFu7ll_S { long long v1; unsigned long long v2:7; short v3; };
struct L_BFu7ll_Uc { long long v1; unsigned long long v2:7; unsigned char v3; };
struct L_BFu7ll_Ui { long long v1; unsigned long long v2:7; unsigned int v3; };
struct L_BFu7ll_Ul { long long v1; unsigned long long v2:7; unsigned long long v3; };
struct L_BFu7ll_Us { long long v1; unsigned long long v2:7; unsigned short v3; };
struct L_BFu7ll_Vp { long long v1; unsigned long long v2:7; void * v3; };
struct L_BFu7s { long long v1; unsigned short v2:7; };
struct L_BFu7s_BFu15i { long long v1; unsigned short v2:7; unsigned int v3:15; };
struct L_BFu7s_BFu15ll { long long v1; unsigned short v2:7; unsigned long long v3:15; };
struct L_BFu7s_BFu15s { long long v1; unsigned short v2:7; unsigned short v3:15; };
struct L_BFu7s_BFu16i { long long v1; unsigned short v2:7; unsigned int v3:16; };
struct L_BFu7s_BFu16ll { long long v1; unsigned short v2:7; unsigned long long v3:16; };
struct L_BFu7s_BFu16s { long long v1; unsigned short v2:7; unsigned short v3:16; };
struct L_BFu7s_BFu17i { long long v1; unsigned short v2:7; unsigned int v3:17; };
struct L_BFu7s_BFu17ll { long long v1; unsigned short v2:7; unsigned long long v3:17; };
struct L_BFu7s_BFu1c { long long v1; unsigned short v2:7; unsigned char v3:1; };
struct L_BFu7s_BFu1i { long long v1; unsigned short v2:7; unsigned int v3:1; };
struct L_BFu7s_BFu1ll { long long v1; unsigned short v2:7; unsigned long long v3:1; };
struct L_BFu7s_BFu1s { long long v1; unsigned short v2:7; unsigned short v3:1; };
struct L_BFu7s_BFu31i { long long v1; unsigned short v2:7; unsigned int v3:31; };
struct L_BFu7s_BFu31ll { long long v1; unsigned short v2:7; unsigned long long v3:31; };
struct L_BFu7s_BFu32i { long long v1; unsigned short v2:7; unsigned int v3:32; };
struct L_BFu7s_BFu32ll { long long v1; unsigned short v2:7; unsigned long long v3:32; };
struct L_BFu7s_BFu33 { long long v1; unsigned short v2:7; unsigned long long v3:33; };
struct L_BFu7s_BFu7c { long long v1; unsigned short v2:7; unsigned char v3:7; };
struct L_BFu7s_BFu7i { long long v1; unsigned short v2:7; unsigned int v3:7; };
struct L_BFu7s_BFu7ll { long long v1; unsigned short v2:7; unsigned long long v3:7; };
struct L_BFu7s_BFu7s { long long v1; unsigned short v2:7; unsigned short v3:7; };
struct L_BFu7s_BFu8c { long long v1; unsigned short v2:7; unsigned char v3:8; };
struct L_BFu7s_BFu8i { long long v1; unsigned short v2:7; unsigned int v3:8; };
struct L_BFu7s_BFu8ll { long long v1; unsigned short v2:7; unsigned long long v3:8; };
struct L_BFu7s_BFu8s { long long v1; unsigned short v2:7; unsigned short v3:8; };
struct L_BFu7s_BFu9i { long long v1; unsigned short v2:7; unsigned int v3:9; };
struct L_BFu7s_BFu9ll { long long v1; unsigned short v2:7; unsigned long long v3:9; };
struct L_BFu7s_BFu9s { long long v1; unsigned short v2:7; unsigned short v3:9; };
struct L_BFu7s_C { long long v1; unsigned short v2:7; char v3; };
struct L_BFu7s_D { long long v1; unsigned short v2:7; double v3; };
struct L_BFu7s_F { long long v1; unsigned short v2:7; float v3; };
struct L_BFu7s_I { long long v1; unsigned short v2:7; int v3; };
struct L_BFu7s_Ip { long long v1; unsigned short v2:7; int * v3; };
struct L_BFu7s_L { long long v1; unsigned short v2:7; long long v3; };
struct L_BFu7s_S { long long v1; unsigned short v2:7; short v3; };
struct L_BFu7s_Uc { long long v1; unsigned short v2:7; unsigned char v3; };
struct L_BFu7s_Ui { long long v1; unsigned short v2:7; unsigned int v3; };
struct L_BFu7s_Ul { long long v1; unsigned short v2:7; unsigned long long v3; };
struct L_BFu7s_Us { long long v1; unsigned short v2:7; unsigned short v3; };
struct L_BFu7s_Vp { long long v1; unsigned short v2:7; void * v3; };
struct L_BFu8c { long long v1; unsigned char v2:8; };
struct L_BFu8c_BFu15i { long long v1; unsigned char v2:8; unsigned int v3:15; };
struct L_BFu8c_BFu15ll { long long v1; unsigned char v2:8; unsigned long long v3:15; };
struct L_BFu8c_BFu15s { long long v1; unsigned char v2:8; unsigned short v3:15; };
struct L_BFu8c_BFu16i { long long v1; unsigned char v2:8; unsigned int v3:16; };
struct L_BFu8c_BFu16ll { long long v1; unsigned char v2:8; unsigned long long v3:16; };
struct L_BFu8c_BFu16s { long long v1; unsigned char v2:8; unsigned short v3:16; };
struct L_BFu8c_BFu17i { long long v1; unsigned char v2:8; unsigned int v3:17; };
struct L_BFu8c_BFu17ll { long long v1; unsigned char v2:8; unsigned long long v3:17; };
struct L_BFu8c_BFu1c { long long v1; unsigned char v2:8; unsigned char v3:1; };
struct L_BFu8c_BFu1i { long long v1; unsigned char v2:8; unsigned int v3:1; };
struct L_BFu8c_BFu1ll { long long v1; unsigned char v2:8; unsigned long long v3:1; };
struct L_BFu8c_BFu1s { long long v1; unsigned char v2:8; unsigned short v3:1; };
struct L_BFu8c_BFu31i { long long v1; unsigned char v2:8; unsigned int v3:31; };
struct L_BFu8c_BFu31ll { long long v1; unsigned char v2:8; unsigned long long v3:31; };
struct L_BFu8c_BFu32i { long long v1; unsigned char v2:8; unsigned int v3:32; };
struct L_BFu8c_BFu32ll { long long v1; unsigned char v2:8; unsigned long long v3:32; };
struct L_BFu8c_BFu33 { long long v1; unsigned char v2:8; unsigned long long v3:33; };
struct L_BFu8c_BFu7c { long long v1; unsigned char v2:8; unsigned char v3:7; };
struct L_BFu8c_BFu7i { long long v1; unsigned char v2:8; unsigned int v3:7; };
struct L_BFu8c_BFu7ll { long long v1; unsigned char v2:8; unsigned long long v3:7; };
struct L_BFu8c_BFu7s { long long v1; unsigned char v2:8; unsigned short v3:7; };
struct L_BFu8c_BFu8c { long long v1; unsigned char v2:8; unsigned char v3:8; };
struct L_BFu8c_BFu8i { long long v1; unsigned char v2:8; unsigned int v3:8; };
struct L_BFu8c_BFu8ll { long long v1; unsigned char v2:8; unsigned long long v3:8; };
struct L_BFu8c_BFu8s { long long v1; unsigned char v2:8; unsigned short v3:8; };
struct L_BFu8c_BFu9i { long long v1; unsigned char v2:8; unsigned int v3:9; };
struct L_BFu8c_BFu9ll { long long v1; unsigned char v2:8; unsigned long long v3:9; };
struct L_BFu8c_BFu9s { long long v1; unsigned char v2:8; unsigned short v3:9; };
struct L_BFu8c_C { long long v1; unsigned char v2:8; char v3; };
struct L_BFu8c_D { long long v1; unsigned char v2:8; double v3; };
struct L_BFu8c_F { long long v1; unsigned char v2:8; float v3; };
struct L_BFu8c_I { long long v1; unsigned char v2:8; int v3; };
struct L_BFu8c_Ip { long long v1; unsigned char v2:8; int * v3; };
struct L_BFu8c_L { long long v1; unsigned char v2:8; long long v3; };
struct L_BFu8c_S { long long v1; unsigned char v2:8; short v3; };
struct L_BFu8c_Uc { long long v1; unsigned char v2:8; unsigned char v3; };
struct L_BFu8c_Ui { long long v1; unsigned char v2:8; unsigned int v3; };
struct L_BFu8c_Ul { long long v1; unsigned char v2:8; unsigned long long v3; };
struct L_BFu8c_Us { long long v1; unsigned char v2:8; unsigned short v3; };
struct L_BFu8c_Vp { long long v1; unsigned char v2:8; void * v3; };
struct L_BFu8i { long long v1; unsigned int v2:8; };
struct L_BFu8i_BFu15i { long long v1; unsigned int v2:8; unsigned int v3:15; };
struct L_BFu8i_BFu15ll { long long v1; unsigned int v2:8; unsigned long long v3:15; };
struct L_BFu8i_BFu15s { long long v1; unsigned int v2:8; unsigned short v3:15; };
struct L_BFu8i_BFu16i { long long v1; unsigned int v2:8; unsigned int v3:16; };
struct L_BFu8i_BFu16ll { long long v1; unsigned int v2:8; unsigned long long v3:16; };
struct L_BFu8i_BFu16s { long long v1; unsigned int v2:8; unsigned short v3:16; };
struct L_BFu8i_BFu17i { long long v1; unsigned int v2:8; unsigned int v3:17; };
struct L_BFu8i_BFu17ll { long long v1; unsigned int v2:8; unsigned long long v3:17; };
struct L_BFu8i_BFu1c { long long v1; unsigned int v2:8; unsigned char v3:1; };
struct L_BFu8i_BFu1i { long long v1; unsigned int v2:8; unsigned int v3:1; };
struct L_BFu8i_BFu1ll { long long v1; unsigned int v2:8; unsigned long long v3:1; };
struct L_BFu8i_BFu1s { long long v1; unsigned int v2:8; unsigned short v3:1; };
struct L_BFu8i_BFu31i { long long v1; unsigned int v2:8; unsigned int v3:31; };
struct L_BFu8i_BFu31ll { long long v1; unsigned int v2:8; unsigned long long v3:31; };
struct L_BFu8i_BFu32i { long long v1; unsigned int v2:8; unsigned int v3:32; };
struct L_BFu8i_BFu32ll { long long v1; unsigned int v2:8; unsigned long long v3:32; };
struct L_BFu8i_BFu33 { long long v1; unsigned int v2:8; unsigned long long v3:33; };
struct L_BFu8i_BFu7c { long long v1; unsigned int v2:8; unsigned char v3:7; };
struct L_BFu8i_BFu7i { long long v1; unsigned int v2:8; unsigned int v3:7; };
struct L_BFu8i_BFu7ll { long long v1; unsigned int v2:8; unsigned long long v3:7; };
struct L_BFu8i_BFu7s { long long v1; unsigned int v2:8; unsigned short v3:7; };
struct L_BFu8i_BFu8c { long long v1; unsigned int v2:8; unsigned char v3:8; };
struct L_BFu8i_BFu8i { long long v1; unsigned int v2:8; unsigned int v3:8; };
struct L_BFu8i_BFu8ll { long long v1; unsigned int v2:8; unsigned long long v3:8; };
struct L_BFu8i_BFu8s { long long v1; unsigned int v2:8; unsigned short v3:8; };
struct L_BFu8i_BFu9i { long long v1; unsigned int v2:8; unsigned int v3:9; };
struct L_BFu8i_BFu9ll { long long v1; unsigned int v2:8; unsigned long long v3:9; };
struct L_BFu8i_BFu9s { long long v1; unsigned int v2:8; unsigned short v3:9; };
struct L_BFu8i_C { long long v1; unsigned int v2:8; char v3; };
struct L_BFu8i_D { long long v1; unsigned int v2:8; double v3; };
struct L_BFu8i_F { long long v1; unsigned int v2:8; float v3; };
struct L_BFu8i_I { long long v1; unsigned int v2:8; int v3; };
struct L_BFu8i_Ip { long long v1; unsigned int v2:8; int * v3; };
struct L_BFu8i_L { long long v1; unsigned int v2:8; long long v3; };
struct L_BFu8i_S { long long v1; unsigned int v2:8; short v3; };
struct L_BFu8i_Uc { long long v1; unsigned int v2:8; unsigned char v3; };
struct L_BFu8i_Ui { long long v1; unsigned int v2:8; unsigned int v3; };
struct L_BFu8i_Ul { long long v1; unsigned int v2:8; unsigned long long v3; };
struct L_BFu8i_Us { long long v1; unsigned int v2:8; unsigned short v3; };
struct L_BFu8i_Vp { long long v1; unsigned int v2:8; void * v3; };
struct L_BFu8ll { long long v1; unsigned long long v2:8; };
struct L_BFu8ll_BFu15i { long long v1; unsigned long long v2:8; unsigned int v3:15; };
struct L_BFu8ll_BFu15ll { long long v1; unsigned long long v2:8; unsigned long long v3:15; };
struct L_BFu8ll_BFu15s { long long v1; unsigned long long v2:8; unsigned short v3:15; };
struct L_BFu8ll_BFu16i { long long v1; unsigned long long v2:8; unsigned int v3:16; };
struct L_BFu8ll_BFu16ll { long long v1; unsigned long long v2:8; unsigned long long v3:16; };
struct L_BFu8ll_BFu16s { long long v1; unsigned long long v2:8; unsigned short v3:16; };
struct L_BFu8ll_BFu17i { long long v1; unsigned long long v2:8; unsigned int v3:17; };
struct L_BFu8ll_BFu17ll { long long v1; unsigned long long v2:8; unsigned long long v3:17; };
struct L_BFu8ll_BFu1c { long long v1; unsigned long long v2:8; unsigned char v3:1; };
struct L_BFu8ll_BFu1i { long long v1; unsigned long long v2:8; unsigned int v3:1; };
struct L_BFu8ll_BFu1ll { long long v1; unsigned long long v2:8; unsigned long long v3:1; };
struct L_BFu8ll_BFu1s { long long v1; unsigned long long v2:8; unsigned short v3:1; };
struct L_BFu8ll_BFu31i { long long v1; unsigned long long v2:8; unsigned int v3:31; };
struct L_BFu8ll_BFu31ll { long long v1; unsigned long long v2:8; unsigned long long v3:31; };
struct L_BFu8ll_BFu32i { long long v1; unsigned long long v2:8; unsigned int v3:32; };
struct L_BFu8ll_BFu32ll { long long v1; unsigned long long v2:8; unsigned long long v3:32; };
struct L_BFu8ll_BFu33 { long long v1; unsigned long long v2:8; unsigned long long v3:33; };
struct L_BFu8ll_BFu7c { long long v1; unsigned long long v2:8; unsigned char v3:7; };
struct L_BFu8ll_BFu7i { long long v1; unsigned long long v2:8; unsigned int v3:7; };
struct L_BFu8ll_BFu7ll { long long v1; unsigned long long v2:8; unsigned long long v3:7; };
struct L_BFu8ll_BFu7s { long long v1; unsigned long long v2:8; unsigned short v3:7; };
struct L_BFu8ll_BFu8c { long long v1; unsigned long long v2:8; unsigned char v3:8; };
struct L_BFu8ll_BFu8i { long long v1; unsigned long long v2:8; unsigned int v3:8; };
struct L_BFu8ll_BFu8ll { long long v1; unsigned long long v2:8; unsigned long long v3:8; };
struct L_BFu8ll_BFu8s { long long v1; unsigned long long v2:8; unsigned short v3:8; };
struct L_BFu8ll_BFu9i { long long v1; unsigned long long v2:8; unsigned int v3:9; };
struct L_BFu8ll_BFu9ll { long long v1; unsigned long long v2:8; unsigned long long v3:9; };
struct L_BFu8ll_BFu9s { long long v1; unsigned long long v2:8; unsigned short v3:9; };
struct L_BFu8ll_C { long long v1; unsigned long long v2:8; char v3; };
struct L_BFu8ll_D { long long v1; unsigned long long v2:8; double v3; };
struct L_BFu8ll_F { long long v1; unsigned long long v2:8; float v3; };
struct L_BFu8ll_I { long long v1; unsigned long long v2:8; int v3; };
struct L_BFu8ll_Ip { long long v1; unsigned long long v2:8; int * v3; };
struct L_BFu8ll_L { long long v1; unsigned long long v2:8; long long v3; };
struct L_BFu8ll_S { long long v1; unsigned long long v2:8; short v3; };
struct L_BFu8ll_Uc { long long v1; unsigned long long v2:8; unsigned char v3; };
struct L_BFu8ll_Ui { long long v1; unsigned long long v2:8; unsigned int v3; };
struct L_BFu8ll_Ul { long long v1; unsigned long long v2:8; unsigned long long v3; };
struct L_BFu8ll_Us { long long v1; unsigned long long v2:8; unsigned short v3; };
struct L_BFu8ll_Vp { long long v1; unsigned long long v2:8; void * v3; };
struct L_BFu8s { long long v1; unsigned short v2:8; };
struct L_BFu8s_BFu15i { long long v1; unsigned short v2:8; unsigned int v3:15; };
struct L_BFu8s_BFu15ll { long long v1; unsigned short v2:8; unsigned long long v3:15; };
struct L_BFu8s_BFu15s { long long v1; unsigned short v2:8; unsigned short v3:15; };
struct L_BFu8s_BFu16i { long long v1; unsigned short v2:8; unsigned int v3:16; };
struct L_BFu8s_BFu16ll { long long v1; unsigned short v2:8; unsigned long long v3:16; };
struct L_BFu8s_BFu16s { long long v1; unsigned short v2:8; unsigned short v3:16; };
struct L_BFu8s_BFu17i { long long v1; unsigned short v2:8; unsigned int v3:17; };
struct L_BFu8s_BFu17ll { long long v1; unsigned short v2:8; unsigned long long v3:17; };
struct L_BFu8s_BFu1c { long long v1; unsigned short v2:8; unsigned char v3:1; };
struct L_BFu8s_BFu1i { long long v1; unsigned short v2:8; unsigned int v3:1; };
struct L_BFu8s_BFu1ll { long long v1; unsigned short v2:8; unsigned long long v3:1; };
struct L_BFu8s_BFu1s { long long v1; unsigned short v2:8; unsigned short v3:1; };
struct L_BFu8s_BFu31i { long long v1; unsigned short v2:8; unsigned int v3:31; };
struct L_BFu8s_BFu31ll { long long v1; unsigned short v2:8; unsigned long long v3:31; };
struct L_BFu8s_BFu32i { long long v1; unsigned short v2:8; unsigned int v3:32; };
struct L_BFu8s_BFu32ll { long long v1; unsigned short v2:8; unsigned long long v3:32; };
struct L_BFu8s_BFu33 { long long v1; unsigned short v2:8; unsigned long long v3:33; };
struct L_BFu8s_BFu7c { long long v1; unsigned short v2:8; unsigned char v3:7; };
struct L_BFu8s_BFu7i { long long v1; unsigned short v2:8; unsigned int v3:7; };
struct L_BFu8s_BFu7ll { long long v1; unsigned short v2:8; unsigned long long v3:7; };
struct L_BFu8s_BFu7s { long long v1; unsigned short v2:8; unsigned short v3:7; };
struct L_BFu8s_BFu8c { long long v1; unsigned short v2:8; unsigned char v3:8; };
struct L_BFu8s_BFu8i { long long v1; unsigned short v2:8; unsigned int v3:8; };
struct L_BFu8s_BFu8ll { long long v1; unsigned short v2:8; unsigned long long v3:8; };
struct L_BFu8s_BFu8s { long long v1; unsigned short v2:8; unsigned short v3:8; };
struct L_BFu8s_BFu9i { long long v1; unsigned short v2:8; unsigned int v3:9; };
struct L_BFu8s_BFu9ll { long long v1; unsigned short v2:8; unsigned long long v3:9; };
struct L_BFu8s_BFu9s { long long v1; unsigned short v2:8; unsigned short v3:9; };
struct L_BFu8s_C { long long v1; unsigned short v2:8; char v3; };
struct L_BFu8s_D { long long v1; unsigned short v2:8; double v3; };
struct L_BFu8s_F { long long v1; unsigned short v2:8; float v3; };
struct L_BFu8s_I { long long v1; unsigned short v2:8; int v3; };
struct L_BFu8s_Ip { long long v1; unsigned short v2:8; int * v3; };
struct L_BFu8s_L { long long v1; unsigned short v2:8; long long v3; };
struct L_BFu8s_S { long long v1; unsigned short v2:8; short v3; };
struct L_BFu8s_Uc { long long v1; unsigned short v2:8; unsigned char v3; };
struct L_BFu8s_Ui { long long v1; unsigned short v2:8; unsigned int v3; };
struct L_BFu8s_Ul { long long v1; unsigned short v2:8; unsigned long long v3; };
struct L_BFu8s_Us { long long v1; unsigned short v2:8; unsigned short v3; };
struct L_BFu8s_Vp { long long v1; unsigned short v2:8; void * v3; };
struct L_BFu9i { long long v1; unsigned int v2:9; };
struct L_BFu9i_BFu15i { long long v1; unsigned int v2:9; unsigned int v3:15; };
struct L_BFu9i_BFu15ll { long long v1; unsigned int v2:9; unsigned long long v3:15; };
struct L_BFu9i_BFu15s { long long v1; unsigned int v2:9; unsigned short v3:15; };
struct L_BFu9i_BFu16i { long long v1; unsigned int v2:9; unsigned int v3:16; };
struct L_BFu9i_BFu16ll { long long v1; unsigned int v2:9; unsigned long long v3:16; };
struct L_BFu9i_BFu16s { long long v1; unsigned int v2:9; unsigned short v3:16; };
struct L_BFu9i_BFu17i { long long v1; unsigned int v2:9; unsigned int v3:17; };
struct L_BFu9i_BFu17ll { long long v1; unsigned int v2:9; unsigned long long v3:17; };
struct L_BFu9i_BFu1c { long long v1; unsigned int v2:9; unsigned char v3:1; };
struct L_BFu9i_BFu1i { long long v1; unsigned int v2:9; unsigned int v3:1; };
struct L_BFu9i_BFu1ll { long long v1; unsigned int v2:9; unsigned long long v3:1; };
struct L_BFu9i_BFu1s { long long v1; unsigned int v2:9; unsigned short v3:1; };
struct L_BFu9i_BFu31i { long long v1; unsigned int v2:9; unsigned int v3:31; };
struct L_BFu9i_BFu31ll { long long v1; unsigned int v2:9; unsigned long long v3:31; };
struct L_BFu9i_BFu32i { long long v1; unsigned int v2:9; unsigned int v3:32; };
struct L_BFu9i_BFu32ll { long long v1; unsigned int v2:9; unsigned long long v3:32; };
struct L_BFu9i_BFu33 { long long v1; unsigned int v2:9; unsigned long long v3:33; };
struct L_BFu9i_BFu7c { long long v1; unsigned int v2:9; unsigned char v3:7; };
struct L_BFu9i_BFu7i { long long v1; unsigned int v2:9; unsigned int v3:7; };
struct L_BFu9i_BFu7ll { long long v1; unsigned int v2:9; unsigned long long v3:7; };
struct L_BFu9i_BFu7s { long long v1; unsigned int v2:9; unsigned short v3:7; };
struct L_BFu9i_BFu8c { long long v1; unsigned int v2:9; unsigned char v3:8; };
struct L_BFu9i_BFu8i { long long v1; unsigned int v2:9; unsigned int v3:8; };
struct L_BFu9i_BFu8ll { long long v1; unsigned int v2:9; unsigned long long v3:8; };
struct L_BFu9i_BFu8s { long long v1; unsigned int v2:9; unsigned short v3:8; };
struct L_BFu9i_BFu9i { long long v1; unsigned int v2:9; unsigned int v3:9; };
struct L_BFu9i_BFu9ll { long long v1; unsigned int v2:9; unsigned long long v3:9; };
struct L_BFu9i_BFu9s { long long v1; unsigned int v2:9; unsigned short v3:9; };
struct L_BFu9i_C { long long v1; unsigned int v2:9; char v3; };
struct L_BFu9i_D { long long v1; unsigned int v2:9; double v3; };
struct L_BFu9i_F { long long v1; unsigned int v2:9; float v3; };
struct L_BFu9i_I { long long v1; unsigned int v2:9; int v3; };
struct L_BFu9i_Ip { long long v1; unsigned int v2:9; int * v3; };
struct L_BFu9i_L { long long v1; unsigned int v2:9; long long v3; };
struct L_BFu9i_S { long long v1; unsigned int v2:9; short v3; };
struct L_BFu9i_Uc { long long v1; unsigned int v2:9; unsigned char v3; };
struct L_BFu9i_Ui { long long v1; unsigned int v2:9; unsigned int v3; };
struct L_BFu9i_Ul { long long v1; unsigned int v2:9; unsigned long long v3; };
struct L_BFu9i_Us { long long v1; unsigned int v2:9; unsigned short v3; };
struct L_BFu9i_Vp { long long v1; unsigned int v2:9; void * v3; };
struct L_BFu9ll { long long v1; unsigned long long v2:9; };
struct L_BFu9ll_BFu15i { long long v1; unsigned long long v2:9; unsigned int v3:15; };
struct L_BFu9ll_BFu15ll { long long v1; unsigned long long v2:9; unsigned long long v3:15; };
struct L_BFu9ll_BFu15s { long long v1; unsigned long long v2:9; unsigned short v3:15; };
struct L_BFu9ll_BFu16i { long long v1; unsigned long long v2:9; unsigned int v3:16; };
struct L_BFu9ll_BFu16ll { long long v1; unsigned long long v2:9; unsigned long long v3:16; };
struct L_BFu9ll_BFu16s { long long v1; unsigned long long v2:9; unsigned short v3:16; };
struct L_BFu9ll_BFu17i { long long v1; unsigned long long v2:9; unsigned int v3:17; };
struct L_BFu9ll_BFu17ll { long long v1; unsigned long long v2:9; unsigned long long v3:17; };
struct L_BFu9ll_BFu1c { long long v1; unsigned long long v2:9; unsigned char v3:1; };
struct L_BFu9ll_BFu1i { long long v1; unsigned long long v2:9; unsigned int v3:1; };
struct L_BFu9ll_BFu1ll { long long v1; unsigned long long v2:9; unsigned long long v3:1; };
struct L_BFu9ll_BFu1s { long long v1; unsigned long long v2:9; unsigned short v3:1; };
struct L_BFu9ll_BFu31i { long long v1; unsigned long long v2:9; unsigned int v3:31; };
struct L_BFu9ll_BFu31ll { long long v1; unsigned long long v2:9; unsigned long long v3:31; };
struct L_BFu9ll_BFu32i { long long v1; unsigned long long v2:9; unsigned int v3:32; };
struct L_BFu9ll_BFu32ll { long long v1; unsigned long long v2:9; unsigned long long v3:32; };
struct L_BFu9ll_BFu33 { long long v1; unsigned long long v2:9; unsigned long long v3:33; };
struct L_BFu9ll_BFu7c { long long v1; unsigned long long v2:9; unsigned char v3:7; };
struct L_BFu9ll_BFu7i { long long v1; unsigned long long v2:9; unsigned int v3:7; };
struct L_BFu9ll_BFu7ll { long long v1; unsigned long long v2:9; unsigned long long v3:7; };
struct L_BFu9ll_BFu7s { long long v1; unsigned long long v2:9; unsigned short v3:7; };
struct L_BFu9ll_BFu8c { long long v1; unsigned long long v2:9; unsigned char v3:8; };
struct L_BFu9ll_BFu8i { long long v1; unsigned long long v2:9; unsigned int v3:8; };
struct L_BFu9ll_BFu8ll { long long v1; unsigned long long v2:9; unsigned long long v3:8; };
struct L_BFu9ll_BFu8s { long long v1; unsigned long long v2:9; unsigned short v3:8; };
struct L_BFu9ll_BFu9i { long long v1; unsigned long long v2:9; unsigned int v3:9; };
struct L_BFu9ll_BFu9ll { long long v1; unsigned long long v2:9; unsigned long long v3:9; };
struct L_BFu9ll_BFu9s { long long v1; unsigned long long v2:9; unsigned short v3:9; };
struct L_BFu9ll_C { long long v1; unsigned long long v2:9; char v3; };
struct L_BFu9ll_D { long long v1; unsigned long long v2:9; double v3; };
struct L_BFu9ll_F { long long v1; unsigned long long v2:9; float v3; };
struct L_BFu9ll_I { long long v1; unsigned long long v2:9; int v3; };
struct L_BFu9ll_Ip { long long v1; unsigned long long v2:9; int * v3; };
struct L_BFu9ll_L { long long v1; unsigned long long v2:9; long long v3; };
struct L_BFu9ll_S { long long v1; unsigned long long v2:9; short v3; };
struct L_BFu9ll_Uc { long long v1; unsigned long long v2:9; unsigned char v3; };
struct L_BFu9ll_Ui { long long v1; unsigned long long v2:9; unsigned int v3; };
struct L_BFu9ll_Ul { long long v1; unsigned long long v2:9; unsigned long long v3; };
struct L_BFu9ll_Us { long long v1; unsigned long long v2:9; unsigned short v3; };
struct L_BFu9ll_Vp { long long v1; unsigned long long v2:9; void * v3; };
struct L_BFu9s { long long v1; unsigned short v2:9; };
struct L_BFu9s_BFu15i { long long v1; unsigned short v2:9; unsigned int v3:15; };
struct L_BFu9s_BFu15ll { long long v1; unsigned short v2:9; unsigned long long v3:15; };
struct L_BFu9s_BFu15s { long long v1; unsigned short v2:9; unsigned short v3:15; };
struct L_BFu9s_BFu16i { long long v1; unsigned short v2:9; unsigned int v3:16; };
struct L_BFu9s_BFu16ll { long long v1; unsigned short v2:9; unsigned long long v3:16; };
struct L_BFu9s_BFu16s { long long v1; unsigned short v2:9; unsigned short v3:16; };
struct L_BFu9s_BFu17i { long long v1; unsigned short v2:9; unsigned int v3:17; };
struct L_BFu9s_BFu17ll { long long v1; unsigned short v2:9; unsigned long long v3:17; };
struct L_BFu9s_BFu1c { long long v1; unsigned short v2:9; unsigned char v3:1; };
struct L_BFu9s_BFu1i { long long v1; unsigned short v2:9; unsigned int v3:1; };
struct L_BFu9s_BFu1ll { long long v1; unsigned short v2:9; unsigned long long v3:1; };
struct L_BFu9s_BFu1s { long long v1; unsigned short v2:9; unsigned short v3:1; };
struct L_BFu9s_BFu31i { long long v1; unsigned short v2:9; unsigned int v3:31; };
struct L_BFu9s_BFu31ll { long long v1; unsigned short v2:9; unsigned long long v3:31; };
struct L_BFu9s_BFu32i { long long v1; unsigned short v2:9; unsigned int v3:32; };
struct L_BFu9s_BFu32ll { long long v1; unsigned short v2:9; unsigned long long v3:32; };
struct L_BFu9s_BFu33 { long long v1; unsigned short v2:9; unsigned long long v3:33; };
struct L_BFu9s_BFu7c { long long v1; unsigned short v2:9; unsigned char v3:7; };
struct L_BFu9s_BFu7i { long long v1; unsigned short v2:9; unsigned int v3:7; };
struct L_BFu9s_BFu7ll { long long v1; unsigned short v2:9; unsigned long long v3:7; };
struct L_BFu9s_BFu7s { long long v1; unsigned short v2:9; unsigned short v3:7; };
struct L_BFu9s_BFu8c { long long v1; unsigned short v2:9; unsigned char v3:8; };
struct L_BFu9s_BFu8i { long long v1; unsigned short v2:9; unsigned int v3:8; };
struct L_BFu9s_BFu8ll { long long v1; unsigned short v2:9; unsigned long long v3:8; };
struct L_BFu9s_BFu8s { long long v1; unsigned short v2:9; unsigned short v3:8; };
struct L_BFu9s_BFu9i { long long v1; unsigned short v2:9; unsigned int v3:9; };
struct L_BFu9s_BFu9ll { long long v1; unsigned short v2:9; unsigned long long v3:9; };
struct L_BFu9s_BFu9s { long long v1; unsigned short v2:9; unsigned short v3:9; };
struct L_BFu9s_C { long long v1; unsigned short v2:9; char v3; };
struct L_BFu9s_D { long long v1; unsigned short v2:9; double v3; };
struct L_BFu9s_F { long long v1; unsigned short v2:9; float v3; };
struct L_BFu9s_I { long long v1; unsigned short v2:9; int v3; };
struct L_BFu9s_Ip { long long v1; unsigned short v2:9; int * v3; };
struct L_BFu9s_L { long long v1; unsigned short v2:9; long long v3; };
struct L_BFu9s_S { long long v1; unsigned short v2:9; short v3; };
struct L_BFu9s_Uc { long long v1; unsigned short v2:9; unsigned char v3; };
struct L_BFu9s_Ui { long long v1; unsigned short v2:9; unsigned int v3; };
struct L_BFu9s_Ul { long long v1; unsigned short v2:9; unsigned long long v3; };
struct L_BFu9s_Us { long long v1; unsigned short v2:9; unsigned short v3; };
struct L_BFu9s_Vp { long long v1; unsigned short v2:9; void * v3; };
struct L_C { long long v1; char v2; };
struct L_C_BFu15i { long long v1; char v2; unsigned int v3:15; };
struct L_C_BFu15ll { long long v1; char v2; unsigned long long v3:15; };
struct L_C_BFu15s { long long v1; char v2; unsigned short v3:15; };
struct L_C_BFu16i { long long v1; char v2; unsigned int v3:16; };
struct L_C_BFu16ll { long long v1; char v2; unsigned long long v3:16; };
struct L_C_BFu16s { long long v1; char v2; unsigned short v3:16; };
struct L_C_BFu17i { long long v1; char v2; unsigned int v3:17; };
struct L_C_BFu17ll { long long v1; char v2; unsigned long long v3:17; };
struct L_C_BFu1c { long long v1; char v2; unsigned char v3:1; };
struct L_C_BFu1i { long long v1; char v2; unsigned int v3:1; };
struct L_C_BFu1ll { long long v1; char v2; unsigned long long v3:1; };
struct L_C_BFu1s { long long v1; char v2; unsigned short v3:1; };
struct L_C_BFu31i { long long v1; char v2; unsigned int v3:31; };
struct L_C_BFu31ll { long long v1; char v2; unsigned long long v3:31; };
struct L_C_BFu32i { long long v1; char v2; unsigned int v3:32; };
struct L_C_BFu32ll { long long v1; char v2; unsigned long long v3:32; };
struct L_C_BFu33 { long long v1; char v2; unsigned long long v3:33; };
struct L_C_BFu7c { long long v1; char v2; unsigned char v3:7; };
struct L_C_BFu7i { long long v1; char v2; unsigned int v3:7; };
struct L_C_BFu7ll { long long v1; char v2; unsigned long long v3:7; };
struct L_C_BFu7s { long long v1; char v2; unsigned short v3:7; };
struct L_C_BFu8c { long long v1; char v2; unsigned char v3:8; };
struct L_C_BFu8i { long long v1; char v2; unsigned int v3:8; };
struct L_C_BFu8ll { long long v1; char v2; unsigned long long v3:8; };
struct L_C_BFu8s { long long v1; char v2; unsigned short v3:8; };
struct L_C_BFu9i { long long v1; char v2; unsigned int v3:9; };
struct L_C_BFu9ll { long long v1; char v2; unsigned long long v3:9; };
struct L_C_BFu9s { long long v1; char v2; unsigned short v3:9; };
struct L_C_C { long long v1; char v2; char v3; };
struct L_C_D { long long v1; char v2; double v3; };
struct L_C_F { long long v1; char v2; float v3; };
struct L_C_I { long long v1; char v2; int v3; };
struct L_C_Ip { long long v1; char v2; int * v3; };
struct L_C_L { long long v1; char v2; long long v3; };
struct L_C_S { long long v1; char v2; short v3; };
struct L_C_Uc { long long v1; char v2; unsigned char v3; };
struct L_C_Ui { long long v1; char v2; unsigned int v3; };
struct L_C_Ul { long long v1; char v2; unsigned long long v3; };
struct L_C_Us { long long v1; char v2; unsigned short v3; };
struct L_C_Vp { long long v1; char v2; void * v3; };
struct L_D { long long v1; double v2; };
struct L_D_BFu15i { long long v1; double v2; unsigned int v3:15; };
struct L_D_BFu15ll { long long v1; double v2; unsigned long long v3:15; };
struct L_D_BFu15s { long long v1; double v2; unsigned short v3:15; };
struct L_D_BFu16i { long long v1; double v2; unsigned int v3:16; };
struct L_D_BFu16ll { long long v1; double v2; unsigned long long v3:16; };
struct L_D_BFu16s { long long v1; double v2; unsigned short v3:16; };
struct L_D_BFu17i { long long v1; double v2; unsigned int v3:17; };
struct L_D_BFu17ll { long long v1; double v2; unsigned long long v3:17; };
struct L_D_BFu1c { long long v1; double v2; unsigned char v3:1; };
struct L_D_BFu1i { long long v1; double v2; unsigned int v3:1; };
struct L_D_BFu1ll { long long v1; double v2; unsigned long long v3:1; };
struct L_D_BFu1s { long long v1; double v2; unsigned short v3:1; };
struct L_D_BFu31i { long long v1; double v2; unsigned int v3:31; };
struct L_D_BFu31ll { long long v1; double v2; unsigned long long v3:31; };
struct L_D_BFu32i { long long v1; double v2; unsigned int v3:32; };
struct L_D_BFu32ll { long long v1; double v2; unsigned long long v3:32; };
struct L_D_BFu33 { long long v1; double v2; unsigned long long v3:33; };
struct L_D_BFu7c { long long v1; double v2; unsigned char v3:7; };
struct L_D_BFu7i { long long v1; double v2; unsigned int v3:7; };
struct L_D_BFu7ll { long long v1; double v2; unsigned long long v3:7; };
struct L_D_BFu7s { long long v1; double v2; unsigned short v3:7; };
struct L_D_BFu8c { long long v1; double v2; unsigned char v3:8; };
struct L_D_BFu8i { long long v1; double v2; unsigned int v3:8; };
struct L_D_BFu8ll { long long v1; double v2; unsigned long long v3:8; };
struct L_D_BFu8s { long long v1; double v2; unsigned short v3:8; };
struct L_D_BFu9i { long long v1; double v2; unsigned int v3:9; };
struct L_D_BFu9ll { long long v1; double v2; unsigned long long v3:9; };
struct L_D_BFu9s { long long v1; double v2; unsigned short v3:9; };
struct L_D_C { long long v1; double v2; char v3; };
struct L_D_D { long long v1; double v2; double v3; };
struct L_D_F { long long v1; double v2; float v3; };
struct L_D_I { long long v1; double v2; int v3; };
struct L_D_Ip { long long v1; double v2; int * v3; };
struct L_D_L { long long v1; double v2; long long v3; };
struct L_D_S { long long v1; double v2; short v3; };
struct L_D_Uc { long long v1; double v2; unsigned char v3; };
struct L_D_Ui { long long v1; double v2; unsigned int v3; };
struct L_D_Ul { long long v1; double v2; unsigned long long v3; };
struct L_D_Us { long long v1; double v2; unsigned short v3; };
struct L_D_Vp { long long v1; double v2; void * v3; };
struct L_F { long long v1; float v2; };
struct L_F_BFu15i { long long v1; float v2; unsigned int v3:15; };
struct L_F_BFu15ll { long long v1; float v2; unsigned long long v3:15; };
struct L_F_BFu15s { long long v1; float v2; unsigned short v3:15; };
struct L_F_BFu16i { long long v1; float v2; unsigned int v3:16; };
struct L_F_BFu16ll { long long v1; float v2; unsigned long long v3:16; };
struct L_F_BFu16s { long long v1; float v2; unsigned short v3:16; };
struct L_F_BFu17i { long long v1; float v2; unsigned int v3:17; };
struct L_F_BFu17ll { long long v1; float v2; unsigned long long v3:17; };
struct L_F_BFu1c { long long v1; float v2; unsigned char v3:1; };
struct L_F_BFu1i { long long v1; float v2; unsigned int v3:1; };
struct L_F_BFu1ll { long long v1; float v2; unsigned long long v3:1; };
struct L_F_BFu1s { long long v1; float v2; unsigned short v3:1; };
struct L_F_BFu31i { long long v1; float v2; unsigned int v3:31; };
struct L_F_BFu31ll { long long v1; float v2; unsigned long long v3:31; };
struct L_F_BFu32i { long long v1; float v2; unsigned int v3:32; };
struct L_F_BFu32ll { long long v1; float v2; unsigned long long v3:32; };
struct L_F_BFu33 { long long v1; float v2; unsigned long long v3:33; };
struct L_F_BFu7c { long long v1; float v2; unsigned char v3:7; };
struct L_F_BFu7i { long long v1; float v2; unsigned int v3:7; };
struct L_F_BFu7ll { long long v1; float v2; unsigned long long v3:7; };
struct L_F_BFu7s { long long v1; float v2; unsigned short v3:7; };
struct L_F_BFu8c { long long v1; float v2; unsigned char v3:8; };
struct L_F_BFu8i { long long v1; float v2; unsigned int v3:8; };
struct L_F_BFu8ll { long long v1; float v2; unsigned long long v3:8; };
struct L_F_BFu8s { long long v1; float v2; unsigned short v3:8; };
struct L_F_BFu9i { long long v1; float v2; unsigned int v3:9; };
struct L_F_BFu9ll { long long v1; float v2; unsigned long long v3:9; };
struct L_F_BFu9s { long long v1; float v2; unsigned short v3:9; };
struct L_F_C { long long v1; float v2; char v3; };
struct L_F_D { long long v1; float v2; double v3; };
struct L_F_F { long long v1; float v2; float v3; };
struct L_F_I { long long v1; float v2; int v3; };
struct L_F_Ip { long long v1; float v2; int * v3; };
struct L_F_L { long long v1; float v2; long long v3; };
struct L_F_S { long long v1; float v2; short v3; };
struct L_F_Uc { long long v1; float v2; unsigned char v3; };
struct L_F_Ui { long long v1; float v2; unsigned int v3; };
struct L_F_Ul { long long v1; float v2; unsigned long long v3; };
struct L_F_Us { long long v1; float v2; unsigned short v3; };
struct L_F_Vp { long long v1; float v2; void * v3; };
struct L_I { long long v1; int v2; };
struct L_I_BFu15i { long long v1; int v2; unsigned int v3:15; };
struct L_I_BFu15ll { long long v1; int v2; unsigned long long v3:15; };
struct L_I_BFu15s { long long v1; int v2; unsigned short v3:15; };
struct L_I_BFu16i { long long v1; int v2; unsigned int v3:16; };
struct L_I_BFu16ll { long long v1; int v2; unsigned long long v3:16; };
struct L_I_BFu16s { long long v1; int v2; unsigned short v3:16; };
struct L_I_BFu17i { long long v1; int v2; unsigned int v3:17; };
struct L_I_BFu17ll { long long v1; int v2; unsigned long long v3:17; };
struct L_I_BFu1c { long long v1; int v2; unsigned char v3:1; };
struct L_I_BFu1i { long long v1; int v2; unsigned int v3:1; };
struct L_I_BFu1ll { long long v1; int v2; unsigned long long v3:1; };
struct L_I_BFu1s { long long v1; int v2; unsigned short v3:1; };
struct L_I_BFu31i { long long v1; int v2; unsigned int v3:31; };
struct L_I_BFu31ll { long long v1; int v2; unsigned long long v3:31; };
struct L_I_BFu32i { long long v1; int v2; unsigned int v3:32; };
struct L_I_BFu32ll { long long v1; int v2; unsigned long long v3:32; };
struct L_I_BFu33 { long long v1; int v2; unsigned long long v3:33; };
struct L_I_BFu7c { long long v1; int v2; unsigned char v3:7; };
struct L_I_BFu7i { long long v1; int v2; unsigned int v3:7; };
struct L_I_BFu7ll { long long v1; int v2; unsigned long long v3:7; };
struct L_I_BFu7s { long long v1; int v2; unsigned short v3:7; };
struct L_I_BFu8c { long long v1; int v2; unsigned char v3:8; };
struct L_I_BFu8i { long long v1; int v2; unsigned int v3:8; };
struct L_I_BFu8ll { long long v1; int v2; unsigned long long v3:8; };
struct L_I_BFu8s { long long v1; int v2; unsigned short v3:8; };
struct L_I_BFu9i { long long v1; int v2; unsigned int v3:9; };
struct L_I_BFu9ll { long long v1; int v2; unsigned long long v3:9; };
struct L_I_BFu9s { long long v1; int v2; unsigned short v3:9; };
struct L_I_C { long long v1; int v2; char v3; };
struct L_I_D { long long v1; int v2; double v3; };
struct L_I_F { long long v1; int v2; float v3; };
struct L_I_I { long long v1; int v2; int v3; };
struct L_I_Ip { long long v1; int v2; int * v3; };
struct L_I_L { long long v1; int v2; long long v3; };
struct L_I_S { long long v1; int v2; short v3; };
struct L_I_Uc { long long v1; int v2; unsigned char v3; };
struct L_I_Ui { long long v1; int v2; unsigned int v3; };
struct L_I_Ul { long long v1; int v2; unsigned long long v3; };
struct L_I_Us { long long v1; int v2; unsigned short v3; };
struct L_I_Vp { long long v1; int v2; void * v3; };
struct L_Ip { long long v1; int * v2; };
struct L_Ip_BFu15i { long long v1; int * v2; unsigned int v3:15; };
struct L_Ip_BFu15ll { long long v1; int * v2; unsigned long long v3:15; };
struct L_Ip_BFu15s { long long v1; int * v2; unsigned short v3:15; };
struct L_Ip_BFu16i { long long v1; int * v2; unsigned int v3:16; };
struct L_Ip_BFu16ll { long long v1; int * v2; unsigned long long v3:16; };
struct L_Ip_BFu16s { long long v1; int * v2; unsigned short v3:16; };
struct L_Ip_BFu17i { long long v1; int * v2; unsigned int v3:17; };
struct L_Ip_BFu17ll { long long v1; int * v2; unsigned long long v3:17; };
struct L_Ip_BFu1c { long long v1; int * v2; unsigned char v3:1; };
struct L_Ip_BFu1i { long long v1; int * v2; unsigned int v3:1; };
struct L_Ip_BFu1ll { long long v1; int * v2; unsigned long long v3:1; };
struct L_Ip_BFu1s { long long v1; int * v2; unsigned short v3:1; };
struct L_Ip_BFu31i { long long v1; int * v2; unsigned int v3:31; };
struct L_Ip_BFu31ll { long long v1; int * v2; unsigned long long v3:31; };
struct L_Ip_BFu32i { long long v1; int * v2; unsigned int v3:32; };
struct L_Ip_BFu32ll { long long v1; int * v2; unsigned long long v3:32; };
struct L_Ip_BFu33 { long long v1; int * v2; unsigned long long v3:33; };
struct L_Ip_BFu7c { long long v1; int * v2; unsigned char v3:7; };
struct L_Ip_BFu7i { long long v1; int * v2; unsigned int v3:7; };
struct L_Ip_BFu7ll { long long v1; int * v2; unsigned long long v3:7; };
struct L_Ip_BFu7s { long long v1; int * v2; unsigned short v3:7; };
struct L_Ip_BFu8c { long long v1; int * v2; unsigned char v3:8; };
struct L_Ip_BFu8i { long long v1; int * v2; unsigned int v3:8; };
struct L_Ip_BFu8ll { long long v1; int * v2; unsigned long long v3:8; };
struct L_Ip_BFu8s { long long v1; int * v2; unsigned short v3:8; };
struct L_Ip_BFu9i { long long v1; int * v2; unsigned int v3:9; };
struct L_Ip_BFu9ll { long long v1; int * v2; unsigned long long v3:9; };
struct L_Ip_BFu9s { long long v1; int * v2; unsigned short v3:9; };
struct L_Ip_C { long long v1; int * v2; char v3; };
struct L_Ip_D { long long v1; int * v2; double v3; };
struct L_Ip_F { long long v1; int * v2; float v3; };
struct L_Ip_I { long long v1; int * v2; int v3; };
struct L_Ip_Ip { long long v1; int * v2; int * v3; };
struct L_Ip_L { long long v1; int * v2; long long v3; };
struct L_Ip_S { long long v1; int * v2; short v3; };
struct L_Ip_Uc { long long v1; int * v2; unsigned char v3; };
struct L_Ip_Ui { long long v1; int * v2; unsigned int v3; };
struct L_Ip_Ul { long long v1; int * v2; unsigned long long v3; };
struct L_Ip_Us { long long v1; int * v2; unsigned short v3; };
struct L_Ip_Vp { long long v1; int * v2; void * v3; };
struct L_L { long long v1; long long v2; };
struct L_L_BFu15i { long long v1; long long v2; unsigned int v3:15; };
struct L_L_BFu15ll { long long v1; long long v2; unsigned long long v3:15; };
struct L_L_BFu15s { long long v1; long long v2; unsigned short v3:15; };
struct L_L_BFu16i { long long v1; long long v2; unsigned int v3:16; };
struct L_L_BFu16ll { long long v1; long long v2; unsigned long long v3:16; };
struct L_L_BFu16s { long long v1; long long v2; unsigned short v3:16; };
struct L_L_BFu17i { long long v1; long long v2; unsigned int v3:17; };
struct L_L_BFu17ll { long long v1; long long v2; unsigned long long v3:17; };
struct L_L_BFu1c { long long v1; long long v2; unsigned char v3:1; };
struct L_L_BFu1i { long long v1; long long v2; unsigned int v3:1; };
struct L_L_BFu1ll { long long v1; long long v2; unsigned long long v3:1; };
struct L_L_BFu1s { long long v1; long long v2; unsigned short v3:1; };
struct L_L_BFu31i { long long v1; long long v2; unsigned int v3:31; };
struct L_L_BFu31ll { long long v1; long long v2; unsigned long long v3:31; };
struct L_L_BFu32i { long long v1; long long v2; unsigned int v3:32; };
struct L_L_BFu32ll { long long v1; long long v2; unsigned long long v3:32; };
struct L_L_BFu33 { long long v1; long long v2; unsigned long long v3:33; };
struct L_L_BFu7c { long long v1; long long v2; unsigned char v3:7; };
struct L_L_BFu7i { long long v1; long long v2; unsigned int v3:7; };
struct L_L_BFu7ll { long long v1; long long v2; unsigned long long v3:7; };
struct L_L_BFu7s { long long v1; long long v2; unsigned short v3:7; };
struct L_L_BFu8c { long long v1; long long v2; unsigned char v3:8; };
struct L_L_BFu8i { long long v1; long long v2; unsigned int v3:8; };
struct L_L_BFu8ll { long long v1; long long v2; unsigned long long v3:8; };
struct L_L_BFu8s { long long v1; long long v2; unsigned short v3:8; };
struct L_L_BFu9i { long long v1; long long v2; unsigned int v3:9; };
struct L_L_BFu9ll { long long v1; long long v2; unsigned long long v3:9; };
struct L_L_BFu9s { long long v1; long long v2; unsigned short v3:9; };
struct L_L_C { long long v1; long long v2; char v3; };
struct L_L_D { long long v1; long long v2; double v3; };
struct L_L_F { long long v1; long long v2; float v3; };
struct L_L_I { long long v1; long long v2; int v3; };
struct L_L_Ip { long long v1; long long v2; int * v3; };
struct L_L_L { long long v1; long long v2; long long v3; };
struct L_L_S { long long v1; long long v2; short v3; };
struct L_L_Uc { long long v1; long long v2; unsigned char v3; };
struct L_L_Ui { long long v1; long long v2; unsigned int v3; };
struct L_L_Ul { long long v1; long long v2; unsigned long long v3; };
struct L_L_Us { long long v1; long long v2; unsigned short v3; };
struct L_L_Vp { long long v1; long long v2; void * v3; };
struct L_S { long long v1; short v2; };
struct L_S_BFu15i { long long v1; short v2; unsigned int v3:15; };
struct L_S_BFu15ll { long long v1; short v2; unsigned long long v3:15; };
struct L_S_BFu15s { long long v1; short v2; unsigned short v3:15; };
struct L_S_BFu16i { long long v1; short v2; unsigned int v3:16; };
struct L_S_BFu16ll { long long v1; short v2; unsigned long long v3:16; };
struct L_S_BFu16s { long long v1; short v2; unsigned short v3:16; };
struct L_S_BFu17i { long long v1; short v2; unsigned int v3:17; };
struct L_S_BFu17ll { long long v1; short v2; unsigned long long v3:17; };
struct L_S_BFu1c { long long v1; short v2; unsigned char v3:1; };
struct L_S_BFu1i { long long v1; short v2; unsigned int v3:1; };
struct L_S_BFu1ll { long long v1; short v2; unsigned long long v3:1; };
struct L_S_BFu1s { long long v1; short v2; unsigned short v3:1; };
struct L_S_BFu31i { long long v1; short v2; unsigned int v3:31; };
struct L_S_BFu31ll { long long v1; short v2; unsigned long long v3:31; };
struct L_S_BFu32i { long long v1; short v2; unsigned int v3:32; };
struct L_S_BFu32ll { long long v1; short v2; unsigned long long v3:32; };
struct L_S_BFu33 { long long v1; short v2; unsigned long long v3:33; };
struct L_S_BFu7c { long long v1; short v2; unsigned char v3:7; };
struct L_S_BFu7i { long long v1; short v2; unsigned int v3:7; };
struct L_S_BFu7ll { long long v1; short v2; unsigned long long v3:7; };
struct L_S_BFu7s { long long v1; short v2; unsigned short v3:7; };
struct L_S_BFu8c { long long v1; short v2; unsigned char v3:8; };
struct L_S_BFu8i { long long v1; short v2; unsigned int v3:8; };
struct L_S_BFu8ll { long long v1; short v2; unsigned long long v3:8; };
struct L_S_BFu8s { long long v1; short v2; unsigned short v3:8; };
struct L_S_BFu9i { long long v1; short v2; unsigned int v3:9; };
struct L_S_BFu9ll { long long v1; short v2; unsigned long long v3:9; };
struct L_S_BFu9s { long long v1; short v2; unsigned short v3:9; };
struct L_S_C { long long v1; short v2; char v3; };
struct L_S_D { long long v1; short v2; double v3; };
struct L_S_F { long long v1; short v2; float v3; };
struct L_S_I { long long v1; short v2; int v3; };
struct L_S_Ip { long long v1; short v2; int * v3; };
struct L_S_L { long long v1; short v2; long long v3; };
struct L_S_S { long long v1; short v2; short v3; };
struct L_S_Uc { long long v1; short v2; unsigned char v3; };
struct L_S_Ui { long long v1; short v2; unsigned int v3; };
struct L_S_Ul { long long v1; short v2; unsigned long long v3; };
struct L_S_Us { long long v1; short v2; unsigned short v3; };
struct L_S_Vp { long long v1; short v2; void * v3; };
struct L_Uc { long long v1; unsigned char v2; };
struct L_Uc_BFu15i { long long v1; unsigned char v2; unsigned int v3:15; };
struct L_Uc_BFu15ll { long long v1; unsigned char v2; unsigned long long v3:15; };
struct L_Uc_BFu15s { long long v1; unsigned char v2; unsigned short v3:15; };
struct L_Uc_BFu16i { long long v1; unsigned char v2; unsigned int v3:16; };
struct L_Uc_BFu16ll { long long v1; unsigned char v2; unsigned long long v3:16; };
struct L_Uc_BFu16s { long long v1; unsigned char v2; unsigned short v3:16; };
struct L_Uc_BFu17i { long long v1; unsigned char v2; unsigned int v3:17; };
struct L_Uc_BFu17ll { long long v1; unsigned char v2; unsigned long long v3:17; };
struct L_Uc_BFu1c { long long v1; unsigned char v2; unsigned char v3:1; };
struct L_Uc_BFu1i { long long v1; unsigned char v2; unsigned int v3:1; };
struct L_Uc_BFu1ll { long long v1; unsigned char v2; unsigned long long v3:1; };
struct L_Uc_BFu1s { long long v1; unsigned char v2; unsigned short v3:1; };
struct L_Uc_BFu31i { long long v1; unsigned char v2; unsigned int v3:31; };
struct L_Uc_BFu31ll { long long v1; unsigned char v2; unsigned long long v3:31; };
struct L_Uc_BFu32i { long long v1; unsigned char v2; unsigned int v3:32; };
struct L_Uc_BFu32ll { long long v1; unsigned char v2; unsigned long long v3:32; };
struct L_Uc_BFu33 { long long v1; unsigned char v2; unsigned long long v3:33; };
struct L_Uc_BFu7c { long long v1; unsigned char v2; unsigned char v3:7; };
struct L_Uc_BFu7i { long long v1; unsigned char v2; unsigned int v3:7; };
struct L_Uc_BFu7ll { long long v1; unsigned char v2; unsigned long long v3:7; };
struct L_Uc_BFu7s { long long v1; unsigned char v2; unsigned short v3:7; };
struct L_Uc_BFu8c { long long v1; unsigned char v2; unsigned char v3:8; };
struct L_Uc_BFu8i { long long v1; unsigned char v2; unsigned int v3:8; };
struct L_Uc_BFu8ll { long long v1; unsigned char v2; unsigned long long v3:8; };
struct L_Uc_BFu8s { long long v1; unsigned char v2; unsigned short v3:8; };
struct L_Uc_BFu9i { long long v1; unsigned char v2; unsigned int v3:9; };
struct L_Uc_BFu9ll { long long v1; unsigned char v2; unsigned long long v3:9; };
struct L_Uc_BFu9s { long long v1; unsigned char v2; unsigned short v3:9; };
struct L_Uc_C { long long v1; unsigned char v2; char v3; };
struct L_Uc_D { long long v1; unsigned char v2; double v3; };
struct L_Uc_F { long long v1; unsigned char v2; float v3; };
struct L_Uc_I { long long v1; unsigned char v2; int v3; };
struct L_Uc_Ip { long long v1; unsigned char v2; int * v3; };
struct L_Uc_L { long long v1; unsigned char v2; long long v3; };
struct L_Uc_S { long long v1; unsigned char v2; short v3; };
struct L_Uc_Uc { long long v1; unsigned char v2; unsigned char v3; };
struct L_Uc_Ui { long long v1; unsigned char v2; unsigned int v3; };
struct L_Uc_Ul { long long v1; unsigned char v2; unsigned long long v3; };
struct L_Uc_Us { long long v1; unsigned char v2; unsigned short v3; };
struct L_Uc_Vp { long long v1; unsigned char v2; void * v3; };
struct L_Ui { long long v1; unsigned int v2; };
struct L_Ui_BFu15i { long long v1; unsigned int v2; unsigned int v3:15; };
struct L_Ui_BFu15ll { long long v1; unsigned int v2; unsigned long long v3:15; };
struct L_Ui_BFu15s { long long v1; unsigned int v2; unsigned short v3:15; };
struct L_Ui_BFu16i { long long v1; unsigned int v2; unsigned int v3:16; };
struct L_Ui_BFu16ll { long long v1; unsigned int v2; unsigned long long v3:16; };
struct L_Ui_BFu16s { long long v1; unsigned int v2; unsigned short v3:16; };
struct L_Ui_BFu17i { long long v1; unsigned int v2; unsigned int v3:17; };
struct L_Ui_BFu17ll { long long v1; unsigned int v2; unsigned long long v3:17; };
struct L_Ui_BFu1c { long long v1; unsigned int v2; unsigned char v3:1; };
struct L_Ui_BFu1i { long long v1; unsigned int v2; unsigned int v3:1; };
struct L_Ui_BFu1ll { long long v1; unsigned int v2; unsigned long long v3:1; };
struct L_Ui_BFu1s { long long v1; unsigned int v2; unsigned short v3:1; };
struct L_Ui_BFu31i { long long v1; unsigned int v2; unsigned int v3:31; };
struct L_Ui_BFu31ll { long long v1; unsigned int v2; unsigned long long v3:31; };
struct L_Ui_BFu32i { long long v1; unsigned int v2; unsigned int v3:32; };
struct L_Ui_BFu32ll { long long v1; unsigned int v2; unsigned long long v3:32; };
struct L_Ui_BFu33 { long long v1; unsigned int v2; unsigned long long v3:33; };
struct L_Ui_BFu7c { long long v1; unsigned int v2; unsigned char v3:7; };
struct L_Ui_BFu7i { long long v1; unsigned int v2; unsigned int v3:7; };
struct L_Ui_BFu7ll { long long v1; unsigned int v2; unsigned long long v3:7; };
struct L_Ui_BFu7s { long long v1; unsigned int v2; unsigned short v3:7; };
struct L_Ui_BFu8c { long long v1; unsigned int v2; unsigned char v3:8; };
struct L_Ui_BFu8i { long long v1; unsigned int v2; unsigned int v3:8; };
struct L_Ui_BFu8ll { long long v1; unsigned int v2; unsigned long long v3:8; };
struct L_Ui_BFu8s { long long v1; unsigned int v2; unsigned short v3:8; };
struct L_Ui_BFu9i { long long v1; unsigned int v2; unsigned int v3:9; };
struct L_Ui_BFu9ll { long long v1; unsigned int v2; unsigned long long v3:9; };
struct L_Ui_BFu9s { long long v1; unsigned int v2; unsigned short v3:9; };
struct L_Ui_C { long long v1; unsigned int v2; char v3; };
struct L_Ui_D { long long v1; unsigned int v2; double v3; };
struct L_Ui_F { long long v1; unsigned int v2; float v3; };
struct L_Ui_I { long long v1; unsigned int v2; int v3; };
struct L_Ui_Ip { long long v1; unsigned int v2; int * v3; };
struct L_Ui_L { long long v1; unsigned int v2; long long v3; };
struct L_Ui_S { long long v1; unsigned int v2; short v3; };
struct L_Ui_Uc { long long v1; unsigned int v2; unsigned char v3; };
struct L_Ui_Ui { long long v1; unsigned int v2; unsigned int v3; };
struct L_Ui_Ul { long long v1; unsigned int v2; unsigned long long v3; };
struct L_Ui_Us { long long v1; unsigned int v2; unsigned short v3; };
struct L_Ui_Vp { long long v1; unsigned int v2; void * v3; };
struct L_Ul { long long v1; unsigned long long v2; };
struct L_Ul_BFu15i { long long v1; unsigned long long v2; unsigned int v3:15; };
struct L_Ul_BFu15ll { long long v1; unsigned long long v2; unsigned long long v3:15; };
struct L_Ul_BFu15s { long long v1; unsigned long long v2; unsigned short v3:15; };
struct L_Ul_BFu16i { long long v1; unsigned long long v2; unsigned int v3:16; };
struct L_Ul_BFu16ll { long long v1; unsigned long long v2; unsigned long long v3:16; };
struct L_Ul_BFu16s { long long v1; unsigned long long v2; unsigned short v3:16; };
struct L_Ul_BFu17i { long long v1; unsigned long long v2; unsigned int v3:17; };
struct L_Ul_BFu17ll { long long v1; unsigned long long v2; unsigned long long v3:17; };
struct L_Ul_BFu1c { long long v1; unsigned long long v2; unsigned char v3:1; };
struct L_Ul_BFu1i { long long v1; unsigned long long v2; unsigned int v3:1; };
struct L_Ul_BFu1ll { long long v1; unsigned long long v2; unsigned long long v3:1; };
struct L_Ul_BFu1s { long long v1; unsigned long long v2; unsigned short v3:1; };
struct L_Ul_BFu31i { long long v1; unsigned long long v2; unsigned int v3:31; };
struct L_Ul_BFu31ll { long long v1; unsigned long long v2; unsigned long long v3:31; };
struct L_Ul_BFu32i { long long v1; unsigned long long v2; unsigned int v3:32; };
struct L_Ul_BFu32ll { long long v1; unsigned long long v2; unsigned long long v3:32; };
struct L_Ul_BFu33 { long long v1; unsigned long long v2; unsigned long long v3:33; };
struct L_Ul_BFu7c { long long v1; unsigned long long v2; unsigned char v3:7; };
struct L_Ul_BFu7i { long long v1; unsigned long long v2; unsigned int v3:7; };
struct L_Ul_BFu7ll { long long v1; unsigned long long v2; unsigned long long v3:7; };
struct L_Ul_BFu7s { long long v1; unsigned long long v2; unsigned short v3:7; };
struct L_Ul_BFu8c { long long v1; unsigned long long v2; unsigned char v3:8; };
struct L_Ul_BFu8i { long long v1; unsigned long long v2; unsigned int v3:8; };
struct L_Ul_BFu8ll { long long v1; unsigned long long v2; unsigned long long v3:8; };
struct L_Ul_BFu8s { long long v1; unsigned long long v2; unsigned short v3:8; };
struct L_Ul_BFu9i { long long v1; unsigned long long v2; unsigned int v3:9; };
struct L_Ul_BFu9ll { long long v1; unsigned long long v2; unsigned long long v3:9; };
struct L_Ul_BFu9s { long long v1; unsigned long long v2; unsigned short v3:9; };
struct L_Ul_C { long long v1; unsigned long long v2; char v3; };
struct L_Ul_D { long long v1; unsigned long long v2; double v3; };
struct L_Ul_F { long long v1; unsigned long long v2; float v3; };
struct L_Ul_I { long long v1; unsigned long long v2; int v3; };
struct L_Ul_Ip { long long v1; unsigned long long v2; int * v3; };
struct L_Ul_L { long long v1; unsigned long long v2; long long v3; };
struct L_Ul_S { long long v1; unsigned long long v2; short v3; };
struct L_Ul_Uc { long long v1; unsigned long long v2; unsigned char v3; };
struct L_Ul_Ui { long long v1; unsigned long long v2; unsigned int v3; };
struct L_Ul_Ul { long long v1; unsigned long long v2; unsigned long long v3; };
struct L_Ul_Us { long long v1; unsigned long long v2; unsigned short v3; };
struct L_Ul_Vp { long long v1; unsigned long long v2; void * v3; };
struct L_Us { long long v1; unsigned short v2; };
struct L_Us_BFu15i { long long v1; unsigned short v2; unsigned int v3:15; };
struct L_Us_BFu15ll { long long v1; unsigned short v2; unsigned long long v3:15; };
struct L_Us_BFu15s { long long v1; unsigned short v2; unsigned short v3:15; };
struct L_Us_BFu16i { long long v1; unsigned short v2; unsigned int v3:16; };
struct L_Us_BFu16ll { long long v1; unsigned short v2; unsigned long long v3:16; };
struct L_Us_BFu16s { long long v1; unsigned short v2; unsigned short v3:16; };
struct L_Us_BFu17i { long long v1; unsigned short v2; unsigned int v3:17; };
struct L_Us_BFu17ll { long long v1; unsigned short v2; unsigned long long v3:17; };
struct L_Us_BFu1c { long long v1; unsigned short v2; unsigned char v3:1; };
struct L_Us_BFu1i { long long v1; unsigned short v2; unsigned int v3:1; };
struct L_Us_BFu1ll { long long v1; unsigned short v2; unsigned long long v3:1; };
struct L_Us_BFu1s { long long v1; unsigned short v2; unsigned short v3:1; };
struct L_Us_BFu31i { long long v1; unsigned short v2; unsigned int v3:31; };
struct L_Us_BFu31ll { long long v1; unsigned short v2; unsigned long long v3:31; };
struct L_Us_BFu32i { long long v1; unsigned short v2; unsigned int v3:32; };
struct L_Us_BFu32ll { long long v1; unsigned short v2; unsigned long long v3:32; };
struct L_Us_BFu33 { long long v1; unsigned short v2; unsigned long long v3:33; };
struct L_Us_BFu7c { long long v1; unsigned short v2; unsigned char v3:7; };
struct L_Us_BFu7i { long long v1; unsigned short v2; unsigned int v3:7; };
struct L_Us_BFu7ll { long long v1; unsigned short v2; unsigned long long v3:7; };
struct L_Us_BFu7s { long long v1; unsigned short v2; unsigned short v3:7; };
struct L_Us_BFu8c { long long v1; unsigned short v2; unsigned char v3:8; };
struct L_Us_BFu8i { long long v1; unsigned short v2; unsigned int v3:8; };
struct L_Us_BFu8ll { long long v1; unsigned short v2; unsigned long long v3:8; };
struct L_Us_BFu8s { long long v1; unsigned short v2; unsigned short v3:8; };
struct L_Us_BFu9i { long long v1; unsigned short v2; unsigned int v3:9; };
struct L_Us_BFu9ll { long long v1; unsigned short v2; unsigned long long v3:9; };
struct L_Us_BFu9s { long long v1; unsigned short v2; unsigned short v3:9; };
struct L_Us_C { long long v1; unsigned short v2; char v3; };
struct L_Us_D { long long v1; unsigned short v2; double v3; };
struct L_Us_F { long long v1; unsigned short v2; float v3; };
struct L_Us_I { long long v1; unsigned short v2; int v3; };
struct L_Us_Ip { long long v1; unsigned short v2; int * v3; };
struct L_Us_L { long long v1; unsigned short v2; long long v3; };
struct L_Us_S { long long v1; unsigned short v2; short v3; };
struct L_Us_Uc { long long v1; unsigned short v2; unsigned char v3; };
struct L_Us_Ui { long long v1; unsigned short v2; unsigned int v3; };
struct L_Us_Ul { long long v1; unsigned short v2; unsigned long long v3; };
struct L_Us_Us { long long v1; unsigned short v2; unsigned short v3; };
struct L_Us_Vp { long long v1; unsigned short v2; void * v3; };
struct L_Vp { long long v1; void * v2; };
struct L_Vp_BFu15i { long long v1; void * v2; unsigned int v3:15; };
struct L_Vp_BFu15ll { long long v1; void * v2; unsigned long long v3:15; };
struct L_Vp_BFu15s { long long v1; void * v2; unsigned short v3:15; };
struct L_Vp_BFu16i { long long v1; void * v2; unsigned int v3:16; };
struct L_Vp_BFu16ll { long long v1; void * v2; unsigned long long v3:16; };
struct L_Vp_BFu16s { long long v1; void * v2; unsigned short v3:16; };
struct L_Vp_BFu17i { long long v1; void * v2; unsigned int v3:17; };
struct L_Vp_BFu17ll { long long v1; void * v2; unsigned long long v3:17; };
struct L_Vp_BFu1c { long long v1; void * v2; unsigned char v3:1; };
struct L_Vp_BFu1i { long long v1; void * v2; unsigned int v3:1; };
struct L_Vp_BFu1ll { long long v1; void * v2; unsigned long long v3:1; };
struct L_Vp_BFu1s { long long v1; void * v2; unsigned short v3:1; };
struct L_Vp_BFu31i { long long v1; void * v2; unsigned int v3:31; };
struct L_Vp_BFu31ll { long long v1; void * v2; unsigned long long v3:31; };
struct L_Vp_BFu32i { long long v1; void * v2; unsigned int v3:32; };
struct L_Vp_BFu32ll { long long v1; void * v2; unsigned long long v3:32; };
struct L_Vp_BFu33 { long long v1; void * v2; unsigned long long v3:33; };
struct L_Vp_BFu7c { long long v1; void * v2; unsigned char v3:7; };
struct L_Vp_BFu7i { long long v1; void * v2; unsigned int v3:7; };
struct L_Vp_BFu7ll { long long v1; void * v2; unsigned long long v3:7; };
struct L_Vp_BFu7s { long long v1; void * v2; unsigned short v3:7; };
struct L_Vp_BFu8c { long long v1; void * v2; unsigned char v3:8; };
struct L_Vp_BFu8i { long long v1; void * v2; unsigned int v3:8; };
struct L_Vp_BFu8ll { long long v1; void * v2; unsigned long long v3:8; };
struct L_Vp_BFu8s { long long v1; void * v2; unsigned short v3:8; };
struct L_Vp_BFu9i { long long v1; void * v2; unsigned int v3:9; };
struct L_Vp_BFu9ll { long long v1; void * v2; unsigned long long v3:9; };
struct L_Vp_BFu9s { long long v1; void * v2; unsigned short v3:9; };
struct L_Vp_C { long long v1; void * v2; char v3; };
struct L_Vp_D { long long v1; void * v2; double v3; };
struct L_Vp_F { long long v1; void * v2; float v3; };
struct L_Vp_I { long long v1; void * v2; int v3; };
struct L_Vp_Ip { long long v1; void * v2; int * v3; };
struct L_Vp_L { long long v1; void * v2; long long v3; };
struct L_Vp_S { long long v1; void * v2; short v3; };
struct L_Vp_Uc { long long v1; void * v2; unsigned char v3; };
struct L_Vp_Ui { long long v1; void * v2; unsigned int v3; };
struct L_Vp_Ul { long long v1; void * v2; unsigned long long v3; };
struct L_Vp_Us { long long v1; void * v2; unsigned short v3; };
struct L_Vp_Vp { long long v1; void * v2; void * v3; };
struct S { short v1; };
struct S_BFu15i { short v1; unsigned int v2:15; };
struct S_BFu15i_BFu15i { short v1; unsigned int v2:15; unsigned int v3:15; };
struct S_BFu15i_BFu15ll { short v1; unsigned int v2:15; unsigned long long v3:15; };
struct S_BFu15i_BFu15s { short v1; unsigned int v2:15; unsigned short v3:15; };
struct S_BFu15i_BFu16i { short v1; unsigned int v2:15; unsigned int v3:16; };
struct S_BFu15i_BFu16ll { short v1; unsigned int v2:15; unsigned long long v3:16; };
struct S_BFu15i_BFu16s { short v1; unsigned int v2:15; unsigned short v3:16; };
struct S_BFu15i_BFu17i { short v1; unsigned int v2:15; unsigned int v3:17; };
struct S_BFu15i_BFu17ll { short v1; unsigned int v2:15; unsigned long long v3:17; };
struct S_BFu15i_BFu1c { short v1; unsigned int v2:15; unsigned char v3:1; };
struct S_BFu15i_BFu1i { short v1; unsigned int v2:15; unsigned int v3:1; };
struct S_BFu15i_BFu1ll { short v1; unsigned int v2:15; unsigned long long v3:1; };
struct S_BFu15i_BFu1s { short v1; unsigned int v2:15; unsigned short v3:1; };
struct S_BFu15i_BFu31i { short v1; unsigned int v2:15; unsigned int v3:31; };
struct S_BFu15i_BFu31ll { short v1; unsigned int v2:15; unsigned long long v3:31; };
struct S_BFu15i_BFu32i { short v1; unsigned int v2:15; unsigned int v3:32; };
struct S_BFu15i_BFu32ll { short v1; unsigned int v2:15; unsigned long long v3:32; };
struct S_BFu15i_BFu33 { short v1; unsigned int v2:15; unsigned long long v3:33; };
struct S_BFu15i_BFu7c { short v1; unsigned int v2:15; unsigned char v3:7; };
struct S_BFu15i_BFu7i { short v1; unsigned int v2:15; unsigned int v3:7; };
struct S_BFu15i_BFu7ll { short v1; unsigned int v2:15; unsigned long long v3:7; };
struct S_BFu15i_BFu7s { short v1; unsigned int v2:15; unsigned short v3:7; };
struct S_BFu15i_BFu8c { short v1; unsigned int v2:15; unsigned char v3:8; };
struct S_BFu15i_BFu8i { short v1; unsigned int v2:15; unsigned int v3:8; };
struct S_BFu15i_BFu8ll { short v1; unsigned int v2:15; unsigned long long v3:8; };
struct S_BFu15i_BFu8s { short v1; unsigned int v2:15; unsigned short v3:8; };
struct S_BFu15i_BFu9i { short v1; unsigned int v2:15; unsigned int v3:9; };
struct S_BFu15i_BFu9ll { short v1; unsigned int v2:15; unsigned long long v3:9; };
struct S_BFu15i_BFu9s { short v1; unsigned int v2:15; unsigned short v3:9; };
struct S_BFu15i_C { short v1; unsigned int v2:15; char v3; };
struct S_BFu15i_D { short v1; unsigned int v2:15; double v3; };
struct S_BFu15i_F { short v1; unsigned int v2:15; float v3; };
struct S_BFu15i_I { short v1; unsigned int v2:15; int v3; };
struct S_BFu15i_Ip { short v1; unsigned int v2:15; int * v3; };
struct S_BFu15i_L { short v1; unsigned int v2:15; long long v3; };
struct S_BFu15i_S { short v1; unsigned int v2:15; short v3; };
struct S_BFu15i_Uc { short v1; unsigned int v2:15; unsigned char v3; };
struct S_BFu15i_Ui { short v1; unsigned int v2:15; unsigned int v3; };
struct S_BFu15i_Ul { short v1; unsigned int v2:15; unsigned long long v3; };
struct S_BFu15i_Us { short v1; unsigned int v2:15; unsigned short v3; };
struct S_BFu15i_Vp { short v1; unsigned int v2:15; void * v3; };
struct S_BFu15ll { short v1; unsigned long long v2:15; };
struct S_BFu15ll_BFu15i { short v1; unsigned long long v2:15; unsigned int v3:15; };
struct S_BFu15ll_BFu15ll { short v1; unsigned long long v2:15; unsigned long long v3:15; };
struct S_BFu15ll_BFu15s { short v1; unsigned long long v2:15; unsigned short v3:15; };
struct S_BFu15ll_BFu16i { short v1; unsigned long long v2:15; unsigned int v3:16; };
struct S_BFu15ll_BFu16ll { short v1; unsigned long long v2:15; unsigned long long v3:16; };
struct S_BFu15ll_BFu16s { short v1; unsigned long long v2:15; unsigned short v3:16; };
struct S_BFu15ll_BFu17i { short v1; unsigned long long v2:15; unsigned int v3:17; };
struct S_BFu15ll_BFu17ll { short v1; unsigned long long v2:15; unsigned long long v3:17; };
struct S_BFu15ll_BFu1c { short v1; unsigned long long v2:15; unsigned char v3:1; };
struct S_BFu15ll_BFu1i { short v1; unsigned long long v2:15; unsigned int v3:1; };
struct S_BFu15ll_BFu1ll { short v1; unsigned long long v2:15; unsigned long long v3:1; };
struct S_BFu15ll_BFu1s { short v1; unsigned long long v2:15; unsigned short v3:1; };
struct S_BFu15ll_BFu31i { short v1; unsigned long long v2:15; unsigned int v3:31; };
struct S_BFu15ll_BFu31ll { short v1; unsigned long long v2:15; unsigned long long v3:31; };
struct S_BFu15ll_BFu32i { short v1; unsigned long long v2:15; unsigned int v3:32; };
struct S_BFu15ll_BFu32ll { short v1; unsigned long long v2:15; unsigned long long v3:32; };
struct S_BFu15ll_BFu33 { short v1; unsigned long long v2:15; unsigned long long v3:33; };
struct S_BFu15ll_BFu7c { short v1; unsigned long long v2:15; unsigned char v3:7; };
struct S_BFu15ll_BFu7i { short v1; unsigned long long v2:15; unsigned int v3:7; };
struct S_BFu15ll_BFu7ll { short v1; unsigned long long v2:15; unsigned long long v3:7; };
struct S_BFu15ll_BFu7s { short v1; unsigned long long v2:15; unsigned short v3:7; };
struct S_BFu15ll_BFu8c { short v1; unsigned long long v2:15; unsigned char v3:8; };
struct S_BFu15ll_BFu8i { short v1; unsigned long long v2:15; unsigned int v3:8; };
struct S_BFu15ll_BFu8ll { short v1; unsigned long long v2:15; unsigned long long v3:8; };
struct S_BFu15ll_BFu8s { short v1; unsigned long long v2:15; unsigned short v3:8; };
struct S_BFu15ll_BFu9i { short v1; unsigned long long v2:15; unsigned int v3:9; };
struct S_BFu15ll_BFu9ll { short v1; unsigned long long v2:15; unsigned long long v3:9; };
struct S_BFu15ll_BFu9s { short v1; unsigned long long v2:15; unsigned short v3:9; };
struct S_BFu15ll_C { short v1; unsigned long long v2:15; char v3; };
struct S_BFu15ll_D { short v1; unsigned long long v2:15; double v3; };
struct S_BFu15ll_F { short v1; unsigned long long v2:15; float v3; };
struct S_BFu15ll_I { short v1; unsigned long long v2:15; int v3; };
struct S_BFu15ll_Ip { short v1; unsigned long long v2:15; int * v3; };
struct S_BFu15ll_L { short v1; unsigned long long v2:15; long long v3; };
struct S_BFu15ll_S { short v1; unsigned long long v2:15; short v3; };
struct S_BFu15ll_Uc { short v1; unsigned long long v2:15; unsigned char v3; };
struct S_BFu15ll_Ui { short v1; unsigned long long v2:15; unsigned int v3; };
struct S_BFu15ll_Ul { short v1; unsigned long long v2:15; unsigned long long v3; };
struct S_BFu15ll_Us { short v1; unsigned long long v2:15; unsigned short v3; };
struct S_BFu15ll_Vp { short v1; unsigned long long v2:15; void * v3; };
struct S_BFu15s { short v1; unsigned short v2:15; };
struct S_BFu15s_BFu15i { short v1; unsigned short v2:15; unsigned int v3:15; };
struct S_BFu15s_BFu15ll { short v1; unsigned short v2:15; unsigned long long v3:15; };
struct S_BFu15s_BFu15s { short v1; unsigned short v2:15; unsigned short v3:15; };
struct S_BFu15s_BFu16i { short v1; unsigned short v2:15; unsigned int v3:16; };
struct S_BFu15s_BFu16ll { short v1; unsigned short v2:15; unsigned long long v3:16; };
struct S_BFu15s_BFu16s { short v1; unsigned short v2:15; unsigned short v3:16; };
struct S_BFu15s_BFu17i { short v1; unsigned short v2:15; unsigned int v3:17; };
struct S_BFu15s_BFu17ll { short v1; unsigned short v2:15; unsigned long long v3:17; };
struct S_BFu15s_BFu1c { short v1; unsigned short v2:15; unsigned char v3:1; };
struct S_BFu15s_BFu1i { short v1; unsigned short v2:15; unsigned int v3:1; };
struct S_BFu15s_BFu1ll { short v1; unsigned short v2:15; unsigned long long v3:1; };
struct S_BFu15s_BFu1s { short v1; unsigned short v2:15; unsigned short v3:1; };
struct S_BFu15s_BFu31i { short v1; unsigned short v2:15; unsigned int v3:31; };
struct S_BFu15s_BFu31ll { short v1; unsigned short v2:15; unsigned long long v3:31; };
struct S_BFu15s_BFu32i { short v1; unsigned short v2:15; unsigned int v3:32; };
struct S_BFu15s_BFu32ll { short v1; unsigned short v2:15; unsigned long long v3:32; };
struct S_BFu15s_BFu33 { short v1; unsigned short v2:15; unsigned long long v3:33; };
struct S_BFu15s_BFu7c { short v1; unsigned short v2:15; unsigned char v3:7; };
struct S_BFu15s_BFu7i { short v1; unsigned short v2:15; unsigned int v3:7; };
struct S_BFu15s_BFu7ll { short v1; unsigned short v2:15; unsigned long long v3:7; };
struct S_BFu15s_BFu7s { short v1; unsigned short v2:15; unsigned short v3:7; };
struct S_BFu15s_BFu8c { short v1; unsigned short v2:15; unsigned char v3:8; };
struct S_BFu15s_BFu8i { short v1; unsigned short v2:15; unsigned int v3:8; };
struct S_BFu15s_BFu8ll { short v1; unsigned short v2:15; unsigned long long v3:8; };
struct S_BFu15s_BFu8s { short v1; unsigned short v2:15; unsigned short v3:8; };
struct S_BFu15s_BFu9i { short v1; unsigned short v2:15; unsigned int v3:9; };
struct S_BFu15s_BFu9ll { short v1; unsigned short v2:15; unsigned long long v3:9; };
struct S_BFu15s_BFu9s { short v1; unsigned short v2:15; unsigned short v3:9; };
struct S_BFu15s_C { short v1; unsigned short v2:15; char v3; };
struct S_BFu15s_D { short v1; unsigned short v2:15; double v3; };
struct S_BFu15s_F { short v1; unsigned short v2:15; float v3; };
struct S_BFu15s_I { short v1; unsigned short v2:15; int v3; };
struct S_BFu15s_Ip { short v1; unsigned short v2:15; int * v3; };
struct S_BFu15s_L { short v1; unsigned short v2:15; long long v3; };
struct S_BFu15s_S { short v1; unsigned short v2:15; short v3; };
struct S_BFu15s_Uc { short v1; unsigned short v2:15; unsigned char v3; };
struct S_BFu15s_Ui { short v1; unsigned short v2:15; unsigned int v3; };
struct S_BFu15s_Ul { short v1; unsigned short v2:15; unsigned long long v3; };
struct S_BFu15s_Us { short v1; unsigned short v2:15; unsigned short v3; };
struct S_BFu15s_Vp { short v1; unsigned short v2:15; void * v3; };
struct S_BFu16i { short v1; unsigned int v2:16; };
struct S_BFu16i_BFu15i { short v1; unsigned int v2:16; unsigned int v3:15; };
struct S_BFu16i_BFu15ll { short v1; unsigned int v2:16; unsigned long long v3:15; };
struct S_BFu16i_BFu15s { short v1; unsigned int v2:16; unsigned short v3:15; };
struct S_BFu16i_BFu16i { short v1; unsigned int v2:16; unsigned int v3:16; };
struct S_BFu16i_BFu16ll { short v1; unsigned int v2:16; unsigned long long v3:16; };
struct S_BFu16i_BFu16s { short v1; unsigned int v2:16; unsigned short v3:16; };
struct S_BFu16i_BFu17i { short v1; unsigned int v2:16; unsigned int v3:17; };
struct S_BFu16i_BFu17ll { short v1; unsigned int v2:16; unsigned long long v3:17; };
struct S_BFu16i_BFu1c { short v1; unsigned int v2:16; unsigned char v3:1; };
struct S_BFu16i_BFu1i { short v1; unsigned int v2:16; unsigned int v3:1; };
struct S_BFu16i_BFu1ll { short v1; unsigned int v2:16; unsigned long long v3:1; };
struct S_BFu16i_BFu1s { short v1; unsigned int v2:16; unsigned short v3:1; };
struct S_BFu16i_BFu31i { short v1; unsigned int v2:16; unsigned int v3:31; };
struct S_BFu16i_BFu31ll { short v1; unsigned int v2:16; unsigned long long v3:31; };
struct S_BFu16i_BFu32i { short v1; unsigned int v2:16; unsigned int v3:32; };
struct S_BFu16i_BFu32ll { short v1; unsigned int v2:16; unsigned long long v3:32; };
struct S_BFu16i_BFu33 { short v1; unsigned int v2:16; unsigned long long v3:33; };
struct S_BFu16i_BFu7c { short v1; unsigned int v2:16; unsigned char v3:7; };
struct S_BFu16i_BFu7i { short v1; unsigned int v2:16; unsigned int v3:7; };
struct S_BFu16i_BFu7ll { short v1; unsigned int v2:16; unsigned long long v3:7; };
struct S_BFu16i_BFu7s { short v1; unsigned int v2:16; unsigned short v3:7; };
struct S_BFu16i_BFu8c { short v1; unsigned int v2:16; unsigned char v3:8; };
struct S_BFu16i_BFu8i { short v1; unsigned int v2:16; unsigned int v3:8; };
struct S_BFu16i_BFu8ll { short v1; unsigned int v2:16; unsigned long long v3:8; };
struct S_BFu16i_BFu8s { short v1; unsigned int v2:16; unsigned short v3:8; };
struct S_BFu16i_BFu9i { short v1; unsigned int v2:16; unsigned int v3:9; };
struct S_BFu16i_BFu9ll { short v1; unsigned int v2:16; unsigned long long v3:9; };
struct S_BFu16i_BFu9s { short v1; unsigned int v2:16; unsigned short v3:9; };
struct S_BFu16i_C { short v1; unsigned int v2:16; char v3; };
struct S_BFu16i_D { short v1; unsigned int v2:16; double v3; };
struct S_BFu16i_F { short v1; unsigned int v2:16; float v3; };
struct S_BFu16i_I { short v1; unsigned int v2:16; int v3; };
struct S_BFu16i_Ip { short v1; unsigned int v2:16; int * v3; };
struct S_BFu16i_L { short v1; unsigned int v2:16; long long v3; };
struct S_BFu16i_S { short v1; unsigned int v2:16; short v3; };
struct S_BFu16i_Uc { short v1; unsigned int v2:16; unsigned char v3; };
struct S_BFu16i_Ui { short v1; unsigned int v2:16; unsigned int v3; };
struct S_BFu16i_Ul { short v1; unsigned int v2:16; unsigned long long v3; };
struct S_BFu16i_Us { short v1; unsigned int v2:16; unsigned short v3; };
struct S_BFu16i_Vp { short v1; unsigned int v2:16; void * v3; };
struct S_BFu16ll { short v1; unsigned long long v2:16; };
struct S_BFu16ll_BFu15i { short v1; unsigned long long v2:16; unsigned int v3:15; };
struct S_BFu16ll_BFu15ll { short v1; unsigned long long v2:16; unsigned long long v3:15; };
struct S_BFu16ll_BFu15s { short v1; unsigned long long v2:16; unsigned short v3:15; };
struct S_BFu16ll_BFu16i { short v1; unsigned long long v2:16; unsigned int v3:16; };
struct S_BFu16ll_BFu16ll { short v1; unsigned long long v2:16; unsigned long long v3:16; };
struct S_BFu16ll_BFu16s { short v1; unsigned long long v2:16; unsigned short v3:16; };
struct S_BFu16ll_BFu17i { short v1; unsigned long long v2:16; unsigned int v3:17; };
struct S_BFu16ll_BFu17ll { short v1; unsigned long long v2:16; unsigned long long v3:17; };
struct S_BFu16ll_BFu1c { short v1; unsigned long long v2:16; unsigned char v3:1; };
struct S_BFu16ll_BFu1i { short v1; unsigned long long v2:16; unsigned int v3:1; };
struct S_BFu16ll_BFu1ll { short v1; unsigned long long v2:16; unsigned long long v3:1; };
struct S_BFu16ll_BFu1s { short v1; unsigned long long v2:16; unsigned short v3:1; };
struct S_BFu16ll_BFu31i { short v1; unsigned long long v2:16; unsigned int v3:31; };
struct S_BFu16ll_BFu31ll { short v1; unsigned long long v2:16; unsigned long long v3:31; };
struct S_BFu16ll_BFu32i { short v1; unsigned long long v2:16; unsigned int v3:32; };
struct S_BFu16ll_BFu32ll { short v1; unsigned long long v2:16; unsigned long long v3:32; };
struct S_BFu16ll_BFu33 { short v1; unsigned long long v2:16; unsigned long long v3:33; };
struct S_BFu16ll_BFu7c { short v1; unsigned long long v2:16; unsigned char v3:7; };
struct S_BFu16ll_BFu7i { short v1; unsigned long long v2:16; unsigned int v3:7; };
struct S_BFu16ll_BFu7ll { short v1; unsigned long long v2:16; unsigned long long v3:7; };
struct S_BFu16ll_BFu7s { short v1; unsigned long long v2:16; unsigned short v3:7; };
struct S_BFu16ll_BFu8c { short v1; unsigned long long v2:16; unsigned char v3:8; };
struct S_BFu16ll_BFu8i { short v1; unsigned long long v2:16; unsigned int v3:8; };
struct S_BFu16ll_BFu8ll { short v1; unsigned long long v2:16; unsigned long long v3:8; };
struct S_BFu16ll_BFu8s { short v1; unsigned long long v2:16; unsigned short v3:8; };
struct S_BFu16ll_BFu9i { short v1; unsigned long long v2:16; unsigned int v3:9; };
struct S_BFu16ll_BFu9ll { short v1; unsigned long long v2:16; unsigned long long v3:9; };
struct S_BFu16ll_BFu9s { short v1; unsigned long long v2:16; unsigned short v3:9; };
struct S_BFu16ll_C { short v1; unsigned long long v2:16; char v3; };
struct S_BFu16ll_D { short v1; unsigned long long v2:16; double v3; };
struct S_BFu16ll_F { short v1; unsigned long long v2:16; float v3; };
struct S_BFu16ll_I { short v1; unsigned long long v2:16; int v3; };
struct S_BFu16ll_Ip { short v1; unsigned long long v2:16; int * v3; };
struct S_BFu16ll_L { short v1; unsigned long long v2:16; long long v3; };
struct S_BFu16ll_S { short v1; unsigned long long v2:16; short v3; };
struct S_BFu16ll_Uc { short v1; unsigned long long v2:16; unsigned char v3; };
struct S_BFu16ll_Ui { short v1; unsigned long long v2:16; unsigned int v3; };
struct S_BFu16ll_Ul { short v1; unsigned long long v2:16; unsigned long long v3; };
struct S_BFu16ll_Us { short v1; unsigned long long v2:16; unsigned short v3; };
struct S_BFu16ll_Vp { short v1; unsigned long long v2:16; void * v3; };
struct S_BFu16s { short v1; unsigned short v2:16; };
struct S_BFu16s_BFu15i { short v1; unsigned short v2:16; unsigned int v3:15; };
struct S_BFu16s_BFu15ll { short v1; unsigned short v2:16; unsigned long long v3:15; };
struct S_BFu16s_BFu15s { short v1; unsigned short v2:16; unsigned short v3:15; };
struct S_BFu16s_BFu16i { short v1; unsigned short v2:16; unsigned int v3:16; };
struct S_BFu16s_BFu16ll { short v1; unsigned short v2:16; unsigned long long v3:16; };
struct S_BFu16s_BFu16s { short v1; unsigned short v2:16; unsigned short v3:16; };
struct S_BFu16s_BFu17i { short v1; unsigned short v2:16; unsigned int v3:17; };
struct S_BFu16s_BFu17ll { short v1; unsigned short v2:16; unsigned long long v3:17; };
struct S_BFu16s_BFu1c { short v1; unsigned short v2:16; unsigned char v3:1; };
struct S_BFu16s_BFu1i { short v1; unsigned short v2:16; unsigned int v3:1; };
struct S_BFu16s_BFu1ll { short v1; unsigned short v2:16; unsigned long long v3:1; };
struct S_BFu16s_BFu1s { short v1; unsigned short v2:16; unsigned short v3:1; };
struct S_BFu16s_BFu31i { short v1; unsigned short v2:16; unsigned int v3:31; };
struct S_BFu16s_BFu31ll { short v1; unsigned short v2:16; unsigned long long v3:31; };
struct S_BFu16s_BFu32i { short v1; unsigned short v2:16; unsigned int v3:32; };
struct S_BFu16s_BFu32ll { short v1; unsigned short v2:16; unsigned long long v3:32; };
struct S_BFu16s_BFu33 { short v1; unsigned short v2:16; unsigned long long v3:33; };
struct S_BFu16s_BFu7c { short v1; unsigned short v2:16; unsigned char v3:7; };
struct S_BFu16s_BFu7i { short v1; unsigned short v2:16; unsigned int v3:7; };
struct S_BFu16s_BFu7ll { short v1; unsigned short v2:16; unsigned long long v3:7; };
struct S_BFu16s_BFu7s { short v1; unsigned short v2:16; unsigned short v3:7; };
struct S_BFu16s_BFu8c { short v1; unsigned short v2:16; unsigned char v3:8; };
struct S_BFu16s_BFu8i { short v1; unsigned short v2:16; unsigned int v3:8; };
struct S_BFu16s_BFu8ll { short v1; unsigned short v2:16; unsigned long long v3:8; };
struct S_BFu16s_BFu8s { short v1; unsigned short v2:16; unsigned short v3:8; };
struct S_BFu16s_BFu9i { short v1; unsigned short v2:16; unsigned int v3:9; };
struct S_BFu16s_BFu9ll { short v1; unsigned short v2:16; unsigned long long v3:9; };
struct S_BFu16s_BFu9s { short v1; unsigned short v2:16; unsigned short v3:9; };
struct S_BFu16s_C { short v1; unsigned short v2:16; char v3; };
struct S_BFu16s_D { short v1; unsigned short v2:16; double v3; };
struct S_BFu16s_F { short v1; unsigned short v2:16; float v3; };
struct S_BFu16s_I { short v1; unsigned short v2:16; int v3; };
struct S_BFu16s_Ip { short v1; unsigned short v2:16; int * v3; };
struct S_BFu16s_L { short v1; unsigned short v2:16; long long v3; };
struct S_BFu16s_S { short v1; unsigned short v2:16; short v3; };
struct S_BFu16s_Uc { short v1; unsigned short v2:16; unsigned char v3; };
struct S_BFu16s_Ui { short v1; unsigned short v2:16; unsigned int v3; };
struct S_BFu16s_Ul { short v1; unsigned short v2:16; unsigned long long v3; };
struct S_BFu16s_Us { short v1; unsigned short v2:16; unsigned short v3; };
struct S_BFu16s_Vp { short v1; unsigned short v2:16; void * v3; };
struct S_BFu17i { short v1; unsigned int v2:17; };
struct S_BFu17i_BFu15i { short v1; unsigned int v2:17; unsigned int v3:15; };
struct S_BFu17i_BFu15ll { short v1; unsigned int v2:17; unsigned long long v3:15; };
struct S_BFu17i_BFu15s { short v1; unsigned int v2:17; unsigned short v3:15; };
struct S_BFu17i_BFu16i { short v1; unsigned int v2:17; unsigned int v3:16; };
struct S_BFu17i_BFu16ll { short v1; unsigned int v2:17; unsigned long long v3:16; };
struct S_BFu17i_BFu16s { short v1; unsigned int v2:17; unsigned short v3:16; };
struct S_BFu17i_BFu17i { short v1; unsigned int v2:17; unsigned int v3:17; };
struct S_BFu17i_BFu17ll { short v1; unsigned int v2:17; unsigned long long v3:17; };
struct S_BFu17i_BFu1c { short v1; unsigned int v2:17; unsigned char v3:1; };
struct S_BFu17i_BFu1i { short v1; unsigned int v2:17; unsigned int v3:1; };
struct S_BFu17i_BFu1ll { short v1; unsigned int v2:17; unsigned long long v3:1; };
struct S_BFu17i_BFu1s { short v1; unsigned int v2:17; unsigned short v3:1; };
struct S_BFu17i_BFu31i { short v1; unsigned int v2:17; unsigned int v3:31; };
struct S_BFu17i_BFu31ll { short v1; unsigned int v2:17; unsigned long long v3:31; };
struct S_BFu17i_BFu32i { short v1; unsigned int v2:17; unsigned int v3:32; };
struct S_BFu17i_BFu32ll { short v1; unsigned int v2:17; unsigned long long v3:32; };
struct S_BFu17i_BFu33 { short v1; unsigned int v2:17; unsigned long long v3:33; };
struct S_BFu17i_BFu7c { short v1; unsigned int v2:17; unsigned char v3:7; };
struct S_BFu17i_BFu7i { short v1; unsigned int v2:17; unsigned int v3:7; };
struct S_BFu17i_BFu7ll { short v1; unsigned int v2:17; unsigned long long v3:7; };
struct S_BFu17i_BFu7s { short v1; unsigned int v2:17; unsigned short v3:7; };
struct S_BFu17i_BFu8c { short v1; unsigned int v2:17; unsigned char v3:8; };
struct S_BFu17i_BFu8i { short v1; unsigned int v2:17; unsigned int v3:8; };
struct S_BFu17i_BFu8ll { short v1; unsigned int v2:17; unsigned long long v3:8; };
struct S_BFu17i_BFu8s { short v1; unsigned int v2:17; unsigned short v3:8; };
struct S_BFu17i_BFu9i { short v1; unsigned int v2:17; unsigned int v3:9; };
struct S_BFu17i_BFu9ll { short v1; unsigned int v2:17; unsigned long long v3:9; };
struct S_BFu17i_BFu9s { short v1; unsigned int v2:17; unsigned short v3:9; };
struct S_BFu17i_C { short v1; unsigned int v2:17; char v3; };
struct S_BFu17i_D { short v1; unsigned int v2:17; double v3; };
struct S_BFu17i_F { short v1; unsigned int v2:17; float v3; };
struct S_BFu17i_I { short v1; unsigned int v2:17; int v3; };
struct S_BFu17i_Ip { short v1; unsigned int v2:17; int * v3; };
struct S_BFu17i_L { short v1; unsigned int v2:17; long long v3; };
struct S_BFu17i_S { short v1; unsigned int v2:17; short v3; };
struct S_BFu17i_Uc { short v1; unsigned int v2:17; unsigned char v3; };
struct S_BFu17i_Ui { short v1; unsigned int v2:17; unsigned int v3; };
struct S_BFu17i_Ul { short v1; unsigned int v2:17; unsigned long long v3; };
struct S_BFu17i_Us { short v1; unsigned int v2:17; unsigned short v3; };
struct S_BFu17i_Vp { short v1; unsigned int v2:17; void * v3; };
struct S_BFu17ll { short v1; unsigned long long v2:17; };
struct S_BFu17ll_BFu15i { short v1; unsigned long long v2:17; unsigned int v3:15; };
struct S_BFu17ll_BFu15ll { short v1; unsigned long long v2:17; unsigned long long v3:15; };
struct S_BFu17ll_BFu15s { short v1; unsigned long long v2:17; unsigned short v3:15; };
struct S_BFu17ll_BFu16i { short v1; unsigned long long v2:17; unsigned int v3:16; };
struct S_BFu17ll_BFu16ll { short v1; unsigned long long v2:17; unsigned long long v3:16; };
struct S_BFu17ll_BFu16s { short v1; unsigned long long v2:17; unsigned short v3:16; };
struct S_BFu17ll_BFu17i { short v1; unsigned long long v2:17; unsigned int v3:17; };
struct S_BFu17ll_BFu17ll { short v1; unsigned long long v2:17; unsigned long long v3:17; };
struct S_BFu17ll_BFu1c { short v1; unsigned long long v2:17; unsigned char v3:1; };
struct S_BFu17ll_BFu1i { short v1; unsigned long long v2:17; unsigned int v3:1; };
struct S_BFu17ll_BFu1ll { short v1; unsigned long long v2:17; unsigned long long v3:1; };
struct S_BFu17ll_BFu1s { short v1; unsigned long long v2:17; unsigned short v3:1; };
struct S_BFu17ll_BFu31i { short v1; unsigned long long v2:17; unsigned int v3:31; };
struct S_BFu17ll_BFu31ll { short v1; unsigned long long v2:17; unsigned long long v3:31; };
struct S_BFu17ll_BFu32i { short v1; unsigned long long v2:17; unsigned int v3:32; };
struct S_BFu17ll_BFu32ll { short v1; unsigned long long v2:17; unsigned long long v3:32; };
struct S_BFu17ll_BFu33 { short v1; unsigned long long v2:17; unsigned long long v3:33; };
struct S_BFu17ll_BFu7c { short v1; unsigned long long v2:17; unsigned char v3:7; };
struct S_BFu17ll_BFu7i { short v1; unsigned long long v2:17; unsigned int v3:7; };
struct S_BFu17ll_BFu7ll { short v1; unsigned long long v2:17; unsigned long long v3:7; };
struct S_BFu17ll_BFu7s { short v1; unsigned long long v2:17; unsigned short v3:7; };
struct S_BFu17ll_BFu8c { short v1; unsigned long long v2:17; unsigned char v3:8; };
struct S_BFu17ll_BFu8i { short v1; unsigned long long v2:17; unsigned int v3:8; };
struct S_BFu17ll_BFu8ll { short v1; unsigned long long v2:17; unsigned long long v3:8; };
struct S_BFu17ll_BFu8s { short v1; unsigned long long v2:17; unsigned short v3:8; };
struct S_BFu17ll_BFu9i { short v1; unsigned long long v2:17; unsigned int v3:9; };
struct S_BFu17ll_BFu9ll { short v1; unsigned long long v2:17; unsigned long long v3:9; };
struct S_BFu17ll_BFu9s { short v1; unsigned long long v2:17; unsigned short v3:9; };
struct S_BFu17ll_C { short v1; unsigned long long v2:17; char v3; };
struct S_BFu17ll_D { short v1; unsigned long long v2:17; double v3; };
struct S_BFu17ll_F { short v1; unsigned long long v2:17; float v3; };
struct S_BFu17ll_I { short v1; unsigned long long v2:17; int v3; };
struct S_BFu17ll_Ip { short v1; unsigned long long v2:17; int * v3; };
struct S_BFu17ll_L { short v1; unsigned long long v2:17; long long v3; };
struct S_BFu17ll_S { short v1; unsigned long long v2:17; short v3; };
struct S_BFu17ll_Uc { short v1; unsigned long long v2:17; unsigned char v3; };
struct S_BFu17ll_Ui { short v1; unsigned long long v2:17; unsigned int v3; };
struct S_BFu17ll_Ul { short v1; unsigned long long v2:17; unsigned long long v3; };
struct S_BFu17ll_Us { short v1; unsigned long long v2:17; unsigned short v3; };
struct S_BFu17ll_Vp { short v1; unsigned long long v2:17; void * v3; };
struct S_BFu1c { short v1; unsigned char v2:1; };
struct S_BFu1c_BFu15i { short v1; unsigned char v2:1; unsigned int v3:15; };
struct S_BFu1c_BFu15ll { short v1; unsigned char v2:1; unsigned long long v3:15; };
struct S_BFu1c_BFu15s { short v1; unsigned char v2:1; unsigned short v3:15; };
struct S_BFu1c_BFu16i { short v1; unsigned char v2:1; unsigned int v3:16; };
struct S_BFu1c_BFu16ll { short v1; unsigned char v2:1; unsigned long long v3:16; };
struct S_BFu1c_BFu16s { short v1; unsigned char v2:1; unsigned short v3:16; };
struct S_BFu1c_BFu17i { short v1; unsigned char v2:1; unsigned int v3:17; };
struct S_BFu1c_BFu17ll { short v1; unsigned char v2:1; unsigned long long v3:17; };
struct S_BFu1c_BFu1c { short v1; unsigned char v2:1; unsigned char v3:1; };
struct S_BFu1c_BFu1i { short v1; unsigned char v2:1; unsigned int v3:1; };
struct S_BFu1c_BFu1ll { short v1; unsigned char v2:1; unsigned long long v3:1; };
struct S_BFu1c_BFu1s { short v1; unsigned char v2:1; unsigned short v3:1; };
struct S_BFu1c_BFu31i { short v1; unsigned char v2:1; unsigned int v3:31; };
struct S_BFu1c_BFu31ll { short v1; unsigned char v2:1; unsigned long long v3:31; };
struct S_BFu1c_BFu32i { short v1; unsigned char v2:1; unsigned int v3:32; };
struct S_BFu1c_BFu32ll { short v1; unsigned char v2:1; unsigned long long v3:32; };
struct S_BFu1c_BFu33 { short v1; unsigned char v2:1; unsigned long long v3:33; };
struct S_BFu1c_BFu7c { short v1; unsigned char v2:1; unsigned char v3:7; };
struct S_BFu1c_BFu7i { short v1; unsigned char v2:1; unsigned int v3:7; };
struct S_BFu1c_BFu7ll { short v1; unsigned char v2:1; unsigned long long v3:7; };
struct S_BFu1c_BFu7s { short v1; unsigned char v2:1; unsigned short v3:7; };
struct S_BFu1c_BFu8c { short v1; unsigned char v2:1; unsigned char v3:8; };
struct S_BFu1c_BFu8i { short v1; unsigned char v2:1; unsigned int v3:8; };
struct S_BFu1c_BFu8ll { short v1; unsigned char v2:1; unsigned long long v3:8; };
struct S_BFu1c_BFu8s { short v1; unsigned char v2:1; unsigned short v3:8; };
struct S_BFu1c_BFu9i { short v1; unsigned char v2:1; unsigned int v3:9; };
struct S_BFu1c_BFu9ll { short v1; unsigned char v2:1; unsigned long long v3:9; };
struct S_BFu1c_BFu9s { short v1; unsigned char v2:1; unsigned short v3:9; };
struct S_BFu1c_C { short v1; unsigned char v2:1; char v3; };
struct S_BFu1c_D { short v1; unsigned char v2:1; double v3; };
struct S_BFu1c_F { short v1; unsigned char v2:1; float v3; };
struct S_BFu1c_I { short v1; unsigned char v2:1; int v3; };
struct S_BFu1c_Ip { short v1; unsigned char v2:1; int * v3; };
struct S_BFu1c_L { short v1; unsigned char v2:1; long long v3; };
struct S_BFu1c_S { short v1; unsigned char v2:1; short v3; };
struct S_BFu1c_Uc { short v1; unsigned char v2:1; unsigned char v3; };
struct S_BFu1c_Ui { short v1; unsigned char v2:1; unsigned int v3; };
struct S_BFu1c_Ul { short v1; unsigned char v2:1; unsigned long long v3; };
struct S_BFu1c_Us { short v1; unsigned char v2:1; unsigned short v3; };
struct S_BFu1c_Vp { short v1; unsigned char v2:1; void * v3; };
struct S_BFu1i { short v1; unsigned int v2:1; };
struct S_BFu1i_BFu15i { short v1; unsigned int v2:1; unsigned int v3:15; };
struct S_BFu1i_BFu15ll { short v1; unsigned int v2:1; unsigned long long v3:15; };
struct S_BFu1i_BFu15s { short v1; unsigned int v2:1; unsigned short v3:15; };
struct S_BFu1i_BFu16i { short v1; unsigned int v2:1; unsigned int v3:16; };
struct S_BFu1i_BFu16ll { short v1; unsigned int v2:1; unsigned long long v3:16; };
struct S_BFu1i_BFu16s { short v1; unsigned int v2:1; unsigned short v3:16; };
struct S_BFu1i_BFu17i { short v1; unsigned int v2:1; unsigned int v3:17; };
struct S_BFu1i_BFu17ll { short v1; unsigned int v2:1; unsigned long long v3:17; };
struct S_BFu1i_BFu1c { short v1; unsigned int v2:1; unsigned char v3:1; };
struct S_BFu1i_BFu1i { short v1; unsigned int v2:1; unsigned int v3:1; };
struct S_BFu1i_BFu1ll { short v1; unsigned int v2:1; unsigned long long v3:1; };
struct S_BFu1i_BFu1s { short v1; unsigned int v2:1; unsigned short v3:1; };
struct S_BFu1i_BFu31i { short v1; unsigned int v2:1; unsigned int v3:31; };
struct S_BFu1i_BFu31ll { short v1; unsigned int v2:1; unsigned long long v3:31; };
struct S_BFu1i_BFu32i { short v1; unsigned int v2:1; unsigned int v3:32; };
struct S_BFu1i_BFu32ll { short v1; unsigned int v2:1; unsigned long long v3:32; };
struct S_BFu1i_BFu33 { short v1; unsigned int v2:1; unsigned long long v3:33; };
struct S_BFu1i_BFu7c { short v1; unsigned int v2:1; unsigned char v3:7; };
struct S_BFu1i_BFu7i { short v1; unsigned int v2:1; unsigned int v3:7; };
struct S_BFu1i_BFu7ll { short v1; unsigned int v2:1; unsigned long long v3:7; };
struct S_BFu1i_BFu7s { short v1; unsigned int v2:1; unsigned short v3:7; };
struct S_BFu1i_BFu8c { short v1; unsigned int v2:1; unsigned char v3:8; };
struct S_BFu1i_BFu8i { short v1; unsigned int v2:1; unsigned int v3:8; };
struct S_BFu1i_BFu8ll { short v1; unsigned int v2:1; unsigned long long v3:8; };
struct S_BFu1i_BFu8s { short v1; unsigned int v2:1; unsigned short v3:8; };
struct S_BFu1i_BFu9i { short v1; unsigned int v2:1; unsigned int v3:9; };
struct S_BFu1i_BFu9ll { short v1; unsigned int v2:1; unsigned long long v3:9; };
struct S_BFu1i_BFu9s { short v1; unsigned int v2:1; unsigned short v3:9; };
struct S_BFu1i_C { short v1; unsigned int v2:1; char v3; };
struct S_BFu1i_D { short v1; unsigned int v2:1; double v3; };
struct S_BFu1i_F { short v1; unsigned int v2:1; float v3; };
struct S_BFu1i_I { short v1; unsigned int v2:1; int v3; };
struct S_BFu1i_Ip { short v1; unsigned int v2:1; int * v3; };
struct S_BFu1i_L { short v1; unsigned int v2:1; long long v3; };
struct S_BFu1i_S { short v1; unsigned int v2:1; short v3; };
struct S_BFu1i_Uc { short v1; unsigned int v2:1; unsigned char v3; };
struct S_BFu1i_Ui { short v1; unsigned int v2:1; unsigned int v3; };
struct S_BFu1i_Ul { short v1; unsigned int v2:1; unsigned long long v3; };
struct S_BFu1i_Us { short v1; unsigned int v2:1; unsigned short v3; };
struct S_BFu1i_Vp { short v1; unsigned int v2:1; void * v3; };
struct S_BFu1ll { short v1; unsigned long long v2:1; };
struct S_BFu1ll_BFu15i { short v1; unsigned long long v2:1; unsigned int v3:15; };
struct S_BFu1ll_BFu15ll { short v1; unsigned long long v2:1; unsigned long long v3:15; };
struct S_BFu1ll_BFu15s { short v1; unsigned long long v2:1; unsigned short v3:15; };
struct S_BFu1ll_BFu16i { short v1; unsigned long long v2:1; unsigned int v3:16; };
struct S_BFu1ll_BFu16ll { short v1; unsigned long long v2:1; unsigned long long v3:16; };
struct S_BFu1ll_BFu16s { short v1; unsigned long long v2:1; unsigned short v3:16; };
struct S_BFu1ll_BFu17i { short v1; unsigned long long v2:1; unsigned int v3:17; };
struct S_BFu1ll_BFu17ll { short v1; unsigned long long v2:1; unsigned long long v3:17; };
struct S_BFu1ll_BFu1c { short v1; unsigned long long v2:1; unsigned char v3:1; };
struct S_BFu1ll_BFu1i { short v1; unsigned long long v2:1; unsigned int v3:1; };
struct S_BFu1ll_BFu1ll { short v1; unsigned long long v2:1; unsigned long long v3:1; };
struct S_BFu1ll_BFu1s { short v1; unsigned long long v2:1; unsigned short v3:1; };
struct S_BFu1ll_BFu31i { short v1; unsigned long long v2:1; unsigned int v3:31; };
struct S_BFu1ll_BFu31ll { short v1; unsigned long long v2:1; unsigned long long v3:31; };
struct S_BFu1ll_BFu32i { short v1; unsigned long long v2:1; unsigned int v3:32; };
struct S_BFu1ll_BFu32ll { short v1; unsigned long long v2:1; unsigned long long v3:32; };
struct S_BFu1ll_BFu33 { short v1; unsigned long long v2:1; unsigned long long v3:33; };
struct S_BFu1ll_BFu7c { short v1; unsigned long long v2:1; unsigned char v3:7; };
struct S_BFu1ll_BFu7i { short v1; unsigned long long v2:1; unsigned int v3:7; };
struct S_BFu1ll_BFu7ll { short v1; unsigned long long v2:1; unsigned long long v3:7; };
struct S_BFu1ll_BFu7s { short v1; unsigned long long v2:1; unsigned short v3:7; };
struct S_BFu1ll_BFu8c { short v1; unsigned long long v2:1; unsigned char v3:8; };
struct S_BFu1ll_BFu8i { short v1; unsigned long long v2:1; unsigned int v3:8; };
struct S_BFu1ll_BFu8ll { short v1; unsigned long long v2:1; unsigned long long v3:8; };
struct S_BFu1ll_BFu8s { short v1; unsigned long long v2:1; unsigned short v3:8; };
struct S_BFu1ll_BFu9i { short v1; unsigned long long v2:1; unsigned int v3:9; };
struct S_BFu1ll_BFu9ll { short v1; unsigned long long v2:1; unsigned long long v3:9; };
struct S_BFu1ll_BFu9s { short v1; unsigned long long v2:1; unsigned short v3:9; };
struct S_BFu1ll_C { short v1; unsigned long long v2:1; char v3; };
struct S_BFu1ll_D { short v1; unsigned long long v2:1; double v3; };
struct S_BFu1ll_F { short v1; unsigned long long v2:1; float v3; };
struct S_BFu1ll_I { short v1; unsigned long long v2:1; int v3; };
struct S_BFu1ll_Ip { short v1; unsigned long long v2:1; int * v3; };
struct S_BFu1ll_L { short v1; unsigned long long v2:1; long long v3; };
struct S_BFu1ll_S { short v1; unsigned long long v2:1; short v3; };
struct S_BFu1ll_Uc { short v1; unsigned long long v2:1; unsigned char v3; };
struct S_BFu1ll_Ui { short v1; unsigned long long v2:1; unsigned int v3; };
struct S_BFu1ll_Ul { short v1; unsigned long long v2:1; unsigned long long v3; };
struct S_BFu1ll_Us { short v1; unsigned long long v2:1; unsigned short v3; };
struct S_BFu1ll_Vp { short v1; unsigned long long v2:1; void * v3; };
struct S_BFu1s { short v1; unsigned short v2:1; };
struct S_BFu1s_BFu15i { short v1; unsigned short v2:1; unsigned int v3:15; };
struct S_BFu1s_BFu15ll { short v1; unsigned short v2:1; unsigned long long v3:15; };
struct S_BFu1s_BFu15s { short v1; unsigned short v2:1; unsigned short v3:15; };
struct S_BFu1s_BFu16i { short v1; unsigned short v2:1; unsigned int v3:16; };
struct S_BFu1s_BFu16ll { short v1; unsigned short v2:1; unsigned long long v3:16; };
struct S_BFu1s_BFu16s { short v1; unsigned short v2:1; unsigned short v3:16; };
struct S_BFu1s_BFu17i { short v1; unsigned short v2:1; unsigned int v3:17; };
struct S_BFu1s_BFu17ll { short v1; unsigned short v2:1; unsigned long long v3:17; };
struct S_BFu1s_BFu1c { short v1; unsigned short v2:1; unsigned char v3:1; };
struct S_BFu1s_BFu1i { short v1; unsigned short v2:1; unsigned int v3:1; };
struct S_BFu1s_BFu1ll { short v1; unsigned short v2:1; unsigned long long v3:1; };
struct S_BFu1s_BFu1s { short v1; unsigned short v2:1; unsigned short v3:1; };
struct S_BFu1s_BFu31i { short v1; unsigned short v2:1; unsigned int v3:31; };
struct S_BFu1s_BFu31ll { short v1; unsigned short v2:1; unsigned long long v3:31; };
struct S_BFu1s_BFu32i { short v1; unsigned short v2:1; unsigned int v3:32; };
struct S_BFu1s_BFu32ll { short v1; unsigned short v2:1; unsigned long long v3:32; };
struct S_BFu1s_BFu33 { short v1; unsigned short v2:1; unsigned long long v3:33; };
struct S_BFu1s_BFu7c { short v1; unsigned short v2:1; unsigned char v3:7; };
struct S_BFu1s_BFu7i { short v1; unsigned short v2:1; unsigned int v3:7; };
struct S_BFu1s_BFu7ll { short v1; unsigned short v2:1; unsigned long long v3:7; };
struct S_BFu1s_BFu7s { short v1; unsigned short v2:1; unsigned short v3:7; };
struct S_BFu1s_BFu8c { short v1; unsigned short v2:1; unsigned char v3:8; };
struct S_BFu1s_BFu8i { short v1; unsigned short v2:1; unsigned int v3:8; };
struct S_BFu1s_BFu8ll { short v1; unsigned short v2:1; unsigned long long v3:8; };
struct S_BFu1s_BFu8s { short v1; unsigned short v2:1; unsigned short v3:8; };
struct S_BFu1s_BFu9i { short v1; unsigned short v2:1; unsigned int v3:9; };
struct S_BFu1s_BFu9ll { short v1; unsigned short v2:1; unsigned long long v3:9; };
struct S_BFu1s_BFu9s { short v1; unsigned short v2:1; unsigned short v3:9; };
struct S_BFu1s_C { short v1; unsigned short v2:1; char v3; };
struct S_BFu1s_D { short v1; unsigned short v2:1; double v3; };
struct S_BFu1s_F { short v1; unsigned short v2:1; float v3; };
struct S_BFu1s_I { short v1; unsigned short v2:1; int v3; };
struct S_BFu1s_Ip { short v1; unsigned short v2:1; int * v3; };
struct S_BFu1s_L { short v1; unsigned short v2:1; long long v3; };
struct S_BFu1s_S { short v1; unsigned short v2:1; short v3; };
struct S_BFu1s_Uc { short v1; unsigned short v2:1; unsigned char v3; };
struct S_BFu1s_Ui { short v1; unsigned short v2:1; unsigned int v3; };
struct S_BFu1s_Ul { short v1; unsigned short v2:1; unsigned long long v3; };
struct S_BFu1s_Us { short v1; unsigned short v2:1; unsigned short v3; };
struct S_BFu1s_Vp { short v1; unsigned short v2:1; void * v3; };
struct S_BFu31i { short v1; unsigned int v2:31; };
struct S_BFu31i_BFu15i { short v1; unsigned int v2:31; unsigned int v3:15; };
struct S_BFu31i_BFu15ll { short v1; unsigned int v2:31; unsigned long long v3:15; };
struct S_BFu31i_BFu15s { short v1; unsigned int v2:31; unsigned short v3:15; };
struct S_BFu31i_BFu16i { short v1; unsigned int v2:31; unsigned int v3:16; };
struct S_BFu31i_BFu16ll { short v1; unsigned int v2:31; unsigned long long v3:16; };
struct S_BFu31i_BFu16s { short v1; unsigned int v2:31; unsigned short v3:16; };
struct S_BFu31i_BFu17i { short v1; unsigned int v2:31; unsigned int v3:17; };
struct S_BFu31i_BFu17ll { short v1; unsigned int v2:31; unsigned long long v3:17; };
struct S_BFu31i_BFu1c { short v1; unsigned int v2:31; unsigned char v3:1; };
struct S_BFu31i_BFu1i { short v1; unsigned int v2:31; unsigned int v3:1; };
struct S_BFu31i_BFu1ll { short v1; unsigned int v2:31; unsigned long long v3:1; };
struct S_BFu31i_BFu1s { short v1; unsigned int v2:31; unsigned short v3:1; };
struct S_BFu31i_BFu31i { short v1; unsigned int v2:31; unsigned int v3:31; };
struct S_BFu31i_BFu31ll { short v1; unsigned int v2:31; unsigned long long v3:31; };
struct S_BFu31i_BFu32i { short v1; unsigned int v2:31; unsigned int v3:32; };
struct S_BFu31i_BFu32ll { short v1; unsigned int v2:31; unsigned long long v3:32; };
struct S_BFu31i_BFu33 { short v1; unsigned int v2:31; unsigned long long v3:33; };
struct S_BFu31i_BFu7c { short v1; unsigned int v2:31; unsigned char v3:7; };
struct S_BFu31i_BFu7i { short v1; unsigned int v2:31; unsigned int v3:7; };
struct S_BFu31i_BFu7ll { short v1; unsigned int v2:31; unsigned long long v3:7; };
struct S_BFu31i_BFu7s { short v1; unsigned int v2:31; unsigned short v3:7; };
struct S_BFu31i_BFu8c { short v1; unsigned int v2:31; unsigned char v3:8; };
struct S_BFu31i_BFu8i { short v1; unsigned int v2:31; unsigned int v3:8; };
struct S_BFu31i_BFu8ll { short v1; unsigned int v2:31; unsigned long long v3:8; };
struct S_BFu31i_BFu8s { short v1; unsigned int v2:31; unsigned short v3:8; };
struct S_BFu31i_BFu9i { short v1; unsigned int v2:31; unsigned int v3:9; };
struct S_BFu31i_BFu9ll { short v1; unsigned int v2:31; unsigned long long v3:9; };
struct S_BFu31i_BFu9s { short v1; unsigned int v2:31; unsigned short v3:9; };
struct S_BFu31i_C { short v1; unsigned int v2:31; char v3; };
struct S_BFu31i_D { short v1; unsigned int v2:31; double v3; };
struct S_BFu31i_F { short v1; unsigned int v2:31; float v3; };
struct S_BFu31i_I { short v1; unsigned int v2:31; int v3; };
struct S_BFu31i_Ip { short v1; unsigned int v2:31; int * v3; };
struct S_BFu31i_L { short v1; unsigned int v2:31; long long v3; };
struct S_BFu31i_S { short v1; unsigned int v2:31; short v3; };
struct S_BFu31i_Uc { short v1; unsigned int v2:31; unsigned char v3; };
struct S_BFu31i_Ui { short v1; unsigned int v2:31; unsigned int v3; };
struct S_BFu31i_Ul { short v1; unsigned int v2:31; unsigned long long v3; };
struct S_BFu31i_Us { short v1; unsigned int v2:31; unsigned short v3; };
struct S_BFu31i_Vp { short v1; unsigned int v2:31; void * v3; };
struct S_BFu31ll { short v1; unsigned long long v2:31; };
struct S_BFu31ll_BFu15i { short v1; unsigned long long v2:31; unsigned int v3:15; };
struct S_BFu31ll_BFu15ll { short v1; unsigned long long v2:31; unsigned long long v3:15; };
struct S_BFu31ll_BFu15s { short v1; unsigned long long v2:31; unsigned short v3:15; };
struct S_BFu31ll_BFu16i { short v1; unsigned long long v2:31; unsigned int v3:16; };
struct S_BFu31ll_BFu16ll { short v1; unsigned long long v2:31; unsigned long long v3:16; };
struct S_BFu31ll_BFu16s { short v1; unsigned long long v2:31; unsigned short v3:16; };
struct S_BFu31ll_BFu17i { short v1; unsigned long long v2:31; unsigned int v3:17; };
struct S_BFu31ll_BFu17ll { short v1; unsigned long long v2:31; unsigned long long v3:17; };
struct S_BFu31ll_BFu1c { short v1; unsigned long long v2:31; unsigned char v3:1; };
struct S_BFu31ll_BFu1i { short v1; unsigned long long v2:31; unsigned int v3:1; };
struct S_BFu31ll_BFu1ll { short v1; unsigned long long v2:31; unsigned long long v3:1; };
struct S_BFu31ll_BFu1s { short v1; unsigned long long v2:31; unsigned short v3:1; };
struct S_BFu31ll_BFu31i { short v1; unsigned long long v2:31; unsigned int v3:31; };
struct S_BFu31ll_BFu31ll { short v1; unsigned long long v2:31; unsigned long long v3:31; };
struct S_BFu31ll_BFu32i { short v1; unsigned long long v2:31; unsigned int v3:32; };
struct S_BFu31ll_BFu32ll { short v1; unsigned long long v2:31; unsigned long long v3:32; };
struct S_BFu31ll_BFu33 { short v1; unsigned long long v2:31; unsigned long long v3:33; };
struct S_BFu31ll_BFu7c { short v1; unsigned long long v2:31; unsigned char v3:7; };
struct S_BFu31ll_BFu7i { short v1; unsigned long long v2:31; unsigned int v3:7; };
struct S_BFu31ll_BFu7ll { short v1; unsigned long long v2:31; unsigned long long v3:7; };
struct S_BFu31ll_BFu7s { short v1; unsigned long long v2:31; unsigned short v3:7; };
struct S_BFu31ll_BFu8c { short v1; unsigned long long v2:31; unsigned char v3:8; };
struct S_BFu31ll_BFu8i { short v1; unsigned long long v2:31; unsigned int v3:8; };
struct S_BFu31ll_BFu8ll { short v1; unsigned long long v2:31; unsigned long long v3:8; };
struct S_BFu31ll_BFu8s { short v1; unsigned long long v2:31; unsigned short v3:8; };
struct S_BFu31ll_BFu9i { short v1; unsigned long long v2:31; unsigned int v3:9; };
struct S_BFu31ll_BFu9ll { short v1; unsigned long long v2:31; unsigned long long v3:9; };
struct S_BFu31ll_BFu9s { short v1; unsigned long long v2:31; unsigned short v3:9; };
struct S_BFu31ll_C { short v1; unsigned long long v2:31; char v3; };
struct S_BFu31ll_D { short v1; unsigned long long v2:31; double v3; };
struct S_BFu31ll_F { short v1; unsigned long long v2:31; float v3; };
struct S_BFu31ll_I { short v1; unsigned long long v2:31; int v3; };
struct S_BFu31ll_Ip { short v1; unsigned long long v2:31; int * v3; };
struct S_BFu31ll_L { short v1; unsigned long long v2:31; long long v3; };
struct S_BFu31ll_S { short v1; unsigned long long v2:31; short v3; };
struct S_BFu31ll_Uc { short v1; unsigned long long v2:31; unsigned char v3; };
struct S_BFu31ll_Ui { short v1; unsigned long long v2:31; unsigned int v3; };
struct S_BFu31ll_Ul { short v1; unsigned long long v2:31; unsigned long long v3; };
struct S_BFu31ll_Us { short v1; unsigned long long v2:31; unsigned short v3; };
struct S_BFu31ll_Vp { short v1; unsigned long long v2:31; void * v3; };
struct S_BFu32i { short v1; unsigned int v2:32; };
struct S_BFu32i_BFu15i { short v1; unsigned int v2:32; unsigned int v3:15; };
struct S_BFu32i_BFu15ll { short v1; unsigned int v2:32; unsigned long long v3:15; };
struct S_BFu32i_BFu15s { short v1; unsigned int v2:32; unsigned short v3:15; };
struct S_BFu32i_BFu16i { short v1; unsigned int v2:32; unsigned int v3:16; };
struct S_BFu32i_BFu16ll { short v1; unsigned int v2:32; unsigned long long v3:16; };
struct S_BFu32i_BFu16s { short v1; unsigned int v2:32; unsigned short v3:16; };
struct S_BFu32i_BFu17i { short v1; unsigned int v2:32; unsigned int v3:17; };
struct S_BFu32i_BFu17ll { short v1; unsigned int v2:32; unsigned long long v3:17; };
struct S_BFu32i_BFu1c { short v1; unsigned int v2:32; unsigned char v3:1; };
struct S_BFu32i_BFu1i { short v1; unsigned int v2:32; unsigned int v3:1; };
struct S_BFu32i_BFu1ll { short v1; unsigned int v2:32; unsigned long long v3:1; };
struct S_BFu32i_BFu1s { short v1; unsigned int v2:32; unsigned short v3:1; };
struct S_BFu32i_BFu31i { short v1; unsigned int v2:32; unsigned int v3:31; };
struct S_BFu32i_BFu31ll { short v1; unsigned int v2:32; unsigned long long v3:31; };
struct S_BFu32i_BFu32i { short v1; unsigned int v2:32; unsigned int v3:32; };
struct S_BFu32i_BFu32ll { short v1; unsigned int v2:32; unsigned long long v3:32; };
struct S_BFu32i_BFu33 { short v1; unsigned int v2:32; unsigned long long v3:33; };
struct S_BFu32i_BFu7c { short v1; unsigned int v2:32; unsigned char v3:7; };
struct S_BFu32i_BFu7i { short v1; unsigned int v2:32; unsigned int v3:7; };
struct S_BFu32i_BFu7ll { short v1; unsigned int v2:32; unsigned long long v3:7; };
struct S_BFu32i_BFu7s { short v1; unsigned int v2:32; unsigned short v3:7; };
struct S_BFu32i_BFu8c { short v1; unsigned int v2:32; unsigned char v3:8; };
struct S_BFu32i_BFu8i { short v1; unsigned int v2:32; unsigned int v3:8; };
struct S_BFu32i_BFu8ll { short v1; unsigned int v2:32; unsigned long long v3:8; };
struct S_BFu32i_BFu8s { short v1; unsigned int v2:32; unsigned short v3:8; };
struct S_BFu32i_BFu9i { short v1; unsigned int v2:32; unsigned int v3:9; };
struct S_BFu32i_BFu9ll { short v1; unsigned int v2:32; unsigned long long v3:9; };
struct S_BFu32i_BFu9s { short v1; unsigned int v2:32; unsigned short v3:9; };
struct S_BFu32i_C { short v1; unsigned int v2:32; char v3; };
struct S_BFu32i_D { short v1; unsigned int v2:32; double v3; };
struct S_BFu32i_F { short v1; unsigned int v2:32; float v3; };
struct S_BFu32i_I { short v1; unsigned int v2:32; int v3; };
struct S_BFu32i_Ip { short v1; unsigned int v2:32; int * v3; };
struct S_BFu32i_L { short v1; unsigned int v2:32; long long v3; };
struct S_BFu32i_S { short v1; unsigned int v2:32; short v3; };
struct S_BFu32i_Uc { short v1; unsigned int v2:32; unsigned char v3; };
struct S_BFu32i_Ui { short v1; unsigned int v2:32; unsigned int v3; };
struct S_BFu32i_Ul { short v1; unsigned int v2:32; unsigned long long v3; };
struct S_BFu32i_Us { short v1; unsigned int v2:32; unsigned short v3; };
struct S_BFu32i_Vp { short v1; unsigned int v2:32; void * v3; };
struct S_BFu32ll { short v1; unsigned long long v2:32; };
struct S_BFu32ll_BFu15i { short v1; unsigned long long v2:32; unsigned int v3:15; };
struct S_BFu32ll_BFu15ll { short v1; unsigned long long v2:32; unsigned long long v3:15; };
struct S_BFu32ll_BFu15s { short v1; unsigned long long v2:32; unsigned short v3:15; };
struct S_BFu32ll_BFu16i { short v1; unsigned long long v2:32; unsigned int v3:16; };
struct S_BFu32ll_BFu16ll { short v1; unsigned long long v2:32; unsigned long long v3:16; };
struct S_BFu32ll_BFu16s { short v1; unsigned long long v2:32; unsigned short v3:16; };
struct S_BFu32ll_BFu17i { short v1; unsigned long long v2:32; unsigned int v3:17; };
struct S_BFu32ll_BFu17ll { short v1; unsigned long long v2:32; unsigned long long v3:17; };
struct S_BFu32ll_BFu1c { short v1; unsigned long long v2:32; unsigned char v3:1; };
struct S_BFu32ll_BFu1i { short v1; unsigned long long v2:32; unsigned int v3:1; };
struct S_BFu32ll_BFu1ll { short v1; unsigned long long v2:32; unsigned long long v3:1; };
struct S_BFu32ll_BFu1s { short v1; unsigned long long v2:32; unsigned short v3:1; };
struct S_BFu32ll_BFu31i { short v1; unsigned long long v2:32; unsigned int v3:31; };
struct S_BFu32ll_BFu31ll { short v1; unsigned long long v2:32; unsigned long long v3:31; };
struct S_BFu32ll_BFu32i { short v1; unsigned long long v2:32; unsigned int v3:32; };
struct S_BFu32ll_BFu32ll { short v1; unsigned long long v2:32; unsigned long long v3:32; };
struct S_BFu32ll_BFu33 { short v1; unsigned long long v2:32; unsigned long long v3:33; };
struct S_BFu32ll_BFu7c { short v1; unsigned long long v2:32; unsigned char v3:7; };
struct S_BFu32ll_BFu7i { short v1; unsigned long long v2:32; unsigned int v3:7; };
struct S_BFu32ll_BFu7ll { short v1; unsigned long long v2:32; unsigned long long v3:7; };
struct S_BFu32ll_BFu7s { short v1; unsigned long long v2:32; unsigned short v3:7; };
struct S_BFu32ll_BFu8c { short v1; unsigned long long v2:32; unsigned char v3:8; };
struct S_BFu32ll_BFu8i { short v1; unsigned long long v2:32; unsigned int v3:8; };
struct S_BFu32ll_BFu8ll { short v1; unsigned long long v2:32; unsigned long long v3:8; };
struct S_BFu32ll_BFu8s { short v1; unsigned long long v2:32; unsigned short v3:8; };
struct S_BFu32ll_BFu9i { short v1; unsigned long long v2:32; unsigned int v3:9; };
struct S_BFu32ll_BFu9ll { short v1; unsigned long long v2:32; unsigned long long v3:9; };
struct S_BFu32ll_BFu9s { short v1; unsigned long long v2:32; unsigned short v3:9; };
struct S_BFu32ll_C { short v1; unsigned long long v2:32; char v3; };
struct S_BFu32ll_D { short v1; unsigned long long v2:32; double v3; };
struct S_BFu32ll_F { short v1; unsigned long long v2:32; float v3; };
struct S_BFu32ll_I { short v1; unsigned long long v2:32; int v3; };
struct S_BFu32ll_Ip { short v1; unsigned long long v2:32; int * v3; };
struct S_BFu32ll_L { short v1; unsigned long long v2:32; long long v3; };
struct S_BFu32ll_S { short v1; unsigned long long v2:32; short v3; };
struct S_BFu32ll_Uc { short v1; unsigned long long v2:32; unsigned char v3; };
struct S_BFu32ll_Ui { short v1; unsigned long long v2:32; unsigned int v3; };
struct S_BFu32ll_Ul { short v1; unsigned long long v2:32; unsigned long long v3; };
struct S_BFu32ll_Us { short v1; unsigned long long v2:32; unsigned short v3; };
struct S_BFu32ll_Vp { short v1; unsigned long long v2:32; void * v3; };
struct S_BFu33 { short v1; unsigned long long v2:33; };
struct S_BFu33_BFu15i { short v1; unsigned long long v2:33; unsigned int v3:15; };
struct S_BFu33_BFu15ll { short v1; unsigned long long v2:33; unsigned long long v3:15; };
struct S_BFu33_BFu15s { short v1; unsigned long long v2:33; unsigned short v3:15; };
struct S_BFu33_BFu16i { short v1; unsigned long long v2:33; unsigned int v3:16; };
struct S_BFu33_BFu16ll { short v1; unsigned long long v2:33; unsigned long long v3:16; };
struct S_BFu33_BFu16s { short v1; unsigned long long v2:33; unsigned short v3:16; };
struct S_BFu33_BFu17i { short v1; unsigned long long v2:33; unsigned int v3:17; };
struct S_BFu33_BFu17ll { short v1; unsigned long long v2:33; unsigned long long v3:17; };
struct S_BFu33_BFu1c { short v1; unsigned long long v2:33; unsigned char v3:1; };
struct S_BFu33_BFu1i { short v1; unsigned long long v2:33; unsigned int v3:1; };
struct S_BFu33_BFu1ll { short v1; unsigned long long v2:33; unsigned long long v3:1; };
struct S_BFu33_BFu1s { short v1; unsigned long long v2:33; unsigned short v3:1; };
struct S_BFu33_BFu31i { short v1; unsigned long long v2:33; unsigned int v3:31; };
struct S_BFu33_BFu31ll { short v1; unsigned long long v2:33; unsigned long long v3:31; };
struct S_BFu33_BFu32i { short v1; unsigned long long v2:33; unsigned int v3:32; };
struct S_BFu33_BFu32ll { short v1; unsigned long long v2:33; unsigned long long v3:32; };
struct S_BFu33_BFu33 { short v1; unsigned long long v2:33; unsigned long long v3:33; };
struct S_BFu33_BFu7c { short v1; unsigned long long v2:33; unsigned char v3:7; };
struct S_BFu33_BFu7i { short v1; unsigned long long v2:33; unsigned int v3:7; };
struct S_BFu33_BFu7ll { short v1; unsigned long long v2:33; unsigned long long v3:7; };
struct S_BFu33_BFu7s { short v1; unsigned long long v2:33; unsigned short v3:7; };
struct S_BFu33_BFu8c { short v1; unsigned long long v2:33; unsigned char v3:8; };
struct S_BFu33_BFu8i { short v1; unsigned long long v2:33; unsigned int v3:8; };
struct S_BFu33_BFu8ll { short v1; unsigned long long v2:33; unsigned long long v3:8; };
struct S_BFu33_BFu8s { short v1; unsigned long long v2:33; unsigned short v3:8; };
struct S_BFu33_BFu9i { short v1; unsigned long long v2:33; unsigned int v3:9; };
struct S_BFu33_BFu9ll { short v1; unsigned long long v2:33; unsigned long long v3:9; };
struct S_BFu33_BFu9s { short v1; unsigned long long v2:33; unsigned short v3:9; };
struct S_BFu33_C { short v1; unsigned long long v2:33; char v3; };
struct S_BFu33_D { short v1; unsigned long long v2:33; double v3; };
struct S_BFu33_F { short v1; unsigned long long v2:33; float v3; };
struct S_BFu33_I { short v1; unsigned long long v2:33; int v3; };
struct S_BFu33_Ip { short v1; unsigned long long v2:33; int * v3; };
struct S_BFu33_L { short v1; unsigned long long v2:33; long long v3; };
struct S_BFu33_S { short v1; unsigned long long v2:33; short v3; };
struct S_BFu33_Uc { short v1; unsigned long long v2:33; unsigned char v3; };
struct S_BFu33_Ui { short v1; unsigned long long v2:33; unsigned int v3; };
struct S_BFu33_Ul { short v1; unsigned long long v2:33; unsigned long long v3; };
struct S_BFu33_Us { short v1; unsigned long long v2:33; unsigned short v3; };
struct S_BFu33_Vp { short v1; unsigned long long v2:33; void * v3; };
struct S_BFu7c { short v1; unsigned char v2:7; };
struct S_BFu7c_BFu15i { short v1; unsigned char v2:7; unsigned int v3:15; };
struct S_BFu7c_BFu15ll { short v1; unsigned char v2:7; unsigned long long v3:15; };
struct S_BFu7c_BFu15s { short v1; unsigned char v2:7; unsigned short v3:15; };
struct S_BFu7c_BFu16i { short v1; unsigned char v2:7; unsigned int v3:16; };
struct S_BFu7c_BFu16ll { short v1; unsigned char v2:7; unsigned long long v3:16; };
struct S_BFu7c_BFu16s { short v1; unsigned char v2:7; unsigned short v3:16; };
struct S_BFu7c_BFu17i { short v1; unsigned char v2:7; unsigned int v3:17; };
struct S_BFu7c_BFu17ll { short v1; unsigned char v2:7; unsigned long long v3:17; };
struct S_BFu7c_BFu1c { short v1; unsigned char v2:7; unsigned char v3:1; };
struct S_BFu7c_BFu1i { short v1; unsigned char v2:7; unsigned int v3:1; };
struct S_BFu7c_BFu1ll { short v1; unsigned char v2:7; unsigned long long v3:1; };
struct S_BFu7c_BFu1s { short v1; unsigned char v2:7; unsigned short v3:1; };
struct S_BFu7c_BFu31i { short v1; unsigned char v2:7; unsigned int v3:31; };
struct S_BFu7c_BFu31ll { short v1; unsigned char v2:7; unsigned long long v3:31; };
struct S_BFu7c_BFu32i { short v1; unsigned char v2:7; unsigned int v3:32; };
struct S_BFu7c_BFu32ll { short v1; unsigned char v2:7; unsigned long long v3:32; };
struct S_BFu7c_BFu33 { short v1; unsigned char v2:7; unsigned long long v3:33; };
struct S_BFu7c_BFu7c { short v1; unsigned char v2:7; unsigned char v3:7; };
struct S_BFu7c_BFu7i { short v1; unsigned char v2:7; unsigned int v3:7; };
struct S_BFu7c_BFu7ll { short v1; unsigned char v2:7; unsigned long long v3:7; };
struct S_BFu7c_BFu7s { short v1; unsigned char v2:7; unsigned short v3:7; };
struct S_BFu7c_BFu8c { short v1; unsigned char v2:7; unsigned char v3:8; };
struct S_BFu7c_BFu8i { short v1; unsigned char v2:7; unsigned int v3:8; };
struct S_BFu7c_BFu8ll { short v1; unsigned char v2:7; unsigned long long v3:8; };
struct S_BFu7c_BFu8s { short v1; unsigned char v2:7; unsigned short v3:8; };
struct S_BFu7c_BFu9i { short v1; unsigned char v2:7; unsigned int v3:9; };
struct S_BFu7c_BFu9ll { short v1; unsigned char v2:7; unsigned long long v3:9; };
struct S_BFu7c_BFu9s { short v1; unsigned char v2:7; unsigned short v3:9; };
struct S_BFu7c_C { short v1; unsigned char v2:7; char v3; };
struct S_BFu7c_D { short v1; unsigned char v2:7; double v3; };
struct S_BFu7c_F { short v1; unsigned char v2:7; float v3; };
struct S_BFu7c_I { short v1; unsigned char v2:7; int v3; };
struct S_BFu7c_Ip { short v1; unsigned char v2:7; int * v3; };
struct S_BFu7c_L { short v1; unsigned char v2:7; long long v3; };
struct S_BFu7c_S { short v1; unsigned char v2:7; short v3; };
struct S_BFu7c_Uc { short v1; unsigned char v2:7; unsigned char v3; };
struct S_BFu7c_Ui { short v1; unsigned char v2:7; unsigned int v3; };
struct S_BFu7c_Ul { short v1; unsigned char v2:7; unsigned long long v3; };
struct S_BFu7c_Us { short v1; unsigned char v2:7; unsigned short v3; };
struct S_BFu7c_Vp { short v1; unsigned char v2:7; void * v3; };
struct S_BFu7i { short v1; unsigned int v2:7; };
struct S_BFu7i_BFu15i { short v1; unsigned int v2:7; unsigned int v3:15; };
struct S_BFu7i_BFu15ll { short v1; unsigned int v2:7; unsigned long long v3:15; };
struct S_BFu7i_BFu15s { short v1; unsigned int v2:7; unsigned short v3:15; };
struct S_BFu7i_BFu16i { short v1; unsigned int v2:7; unsigned int v3:16; };
struct S_BFu7i_BFu16ll { short v1; unsigned int v2:7; unsigned long long v3:16; };
struct S_BFu7i_BFu16s { short v1; unsigned int v2:7; unsigned short v3:16; };
struct S_BFu7i_BFu17i { short v1; unsigned int v2:7; unsigned int v3:17; };
struct S_BFu7i_BFu17ll { short v1; unsigned int v2:7; unsigned long long v3:17; };
struct S_BFu7i_BFu1c { short v1; unsigned int v2:7; unsigned char v3:1; };
struct S_BFu7i_BFu1i { short v1; unsigned int v2:7; unsigned int v3:1; };
struct S_BFu7i_BFu1ll { short v1; unsigned int v2:7; unsigned long long v3:1; };
struct S_BFu7i_BFu1s { short v1; unsigned int v2:7; unsigned short v3:1; };
struct S_BFu7i_BFu31i { short v1; unsigned int v2:7; unsigned int v3:31; };
struct S_BFu7i_BFu31ll { short v1; unsigned int v2:7; unsigned long long v3:31; };
struct S_BFu7i_BFu32i { short v1; unsigned int v2:7; unsigned int v3:32; };
struct S_BFu7i_BFu32ll { short v1; unsigned int v2:7; unsigned long long v3:32; };
struct S_BFu7i_BFu33 { short v1; unsigned int v2:7; unsigned long long v3:33; };
struct S_BFu7i_BFu7c { short v1; unsigned int v2:7; unsigned char v3:7; };
struct S_BFu7i_BFu7i { short v1; unsigned int v2:7; unsigned int v3:7; };
struct S_BFu7i_BFu7ll { short v1; unsigned int v2:7; unsigned long long v3:7; };
struct S_BFu7i_BFu7s { short v1; unsigned int v2:7; unsigned short v3:7; };
struct S_BFu7i_BFu8c { short v1; unsigned int v2:7; unsigned char v3:8; };
struct S_BFu7i_BFu8i { short v1; unsigned int v2:7; unsigned int v3:8; };
struct S_BFu7i_BFu8ll { short v1; unsigned int v2:7; unsigned long long v3:8; };
struct S_BFu7i_BFu8s { short v1; unsigned int v2:7; unsigned short v3:8; };
struct S_BFu7i_BFu9i { short v1; unsigned int v2:7; unsigned int v3:9; };
struct S_BFu7i_BFu9ll { short v1; unsigned int v2:7; unsigned long long v3:9; };
struct S_BFu7i_BFu9s { short v1; unsigned int v2:7; unsigned short v3:9; };
struct S_BFu7i_C { short v1; unsigned int v2:7; char v3; };
struct S_BFu7i_D { short v1; unsigned int v2:7; double v3; };
struct S_BFu7i_F { short v1; unsigned int v2:7; float v3; };
struct S_BFu7i_I { short v1; unsigned int v2:7; int v3; };
struct S_BFu7i_Ip { short v1; unsigned int v2:7; int * v3; };
struct S_BFu7i_L { short v1; unsigned int v2:7; long long v3; };
struct S_BFu7i_S { short v1; unsigned int v2:7; short v3; };
struct S_BFu7i_Uc { short v1; unsigned int v2:7; unsigned char v3; };
struct S_BFu7i_Ui { short v1; unsigned int v2:7; unsigned int v3; };
struct S_BFu7i_Ul { short v1; unsigned int v2:7; unsigned long long v3; };
struct S_BFu7i_Us { short v1; unsigned int v2:7; unsigned short v3; };
struct S_BFu7i_Vp { short v1; unsigned int v2:7; void * v3; };
struct S_BFu7ll { short v1; unsigned long long v2:7; };
struct S_BFu7ll_BFu15i { short v1; unsigned long long v2:7; unsigned int v3:15; };
struct S_BFu7ll_BFu15ll { short v1; unsigned long long v2:7; unsigned long long v3:15; };
struct S_BFu7ll_BFu15s { short v1; unsigned long long v2:7; unsigned short v3:15; };
struct S_BFu7ll_BFu16i { short v1; unsigned long long v2:7; unsigned int v3:16; };
struct S_BFu7ll_BFu16ll { short v1; unsigned long long v2:7; unsigned long long v3:16; };
struct S_BFu7ll_BFu16s { short v1; unsigned long long v2:7; unsigned short v3:16; };
struct S_BFu7ll_BFu17i { short v1; unsigned long long v2:7; unsigned int v3:17; };
struct S_BFu7ll_BFu17ll { short v1; unsigned long long v2:7; unsigned long long v3:17; };
struct S_BFu7ll_BFu1c { short v1; unsigned long long v2:7; unsigned char v3:1; };
struct S_BFu7ll_BFu1i { short v1; unsigned long long v2:7; unsigned int v3:1; };
struct S_BFu7ll_BFu1ll { short v1; unsigned long long v2:7; unsigned long long v3:1; };
struct S_BFu7ll_BFu1s { short v1; unsigned long long v2:7; unsigned short v3:1; };
struct S_BFu7ll_BFu31i { short v1; unsigned long long v2:7; unsigned int v3:31; };
struct S_BFu7ll_BFu31ll { short v1; unsigned long long v2:7; unsigned long long v3:31; };
struct S_BFu7ll_BFu32i { short v1; unsigned long long v2:7; unsigned int v3:32; };
struct S_BFu7ll_BFu32ll { short v1; unsigned long long v2:7; unsigned long long v3:32; };
struct S_BFu7ll_BFu33 { short v1; unsigned long long v2:7; unsigned long long v3:33; };
struct S_BFu7ll_BFu7c { short v1; unsigned long long v2:7; unsigned char v3:7; };
struct S_BFu7ll_BFu7i { short v1; unsigned long long v2:7; unsigned int v3:7; };
struct S_BFu7ll_BFu7ll { short v1; unsigned long long v2:7; unsigned long long v3:7; };
struct S_BFu7ll_BFu7s { short v1; unsigned long long v2:7; unsigned short v3:7; };
struct S_BFu7ll_BFu8c { short v1; unsigned long long v2:7; unsigned char v3:8; };
struct S_BFu7ll_BFu8i { short v1; unsigned long long v2:7; unsigned int v3:8; };
struct S_BFu7ll_BFu8ll { short v1; unsigned long long v2:7; unsigned long long v3:8; };
struct S_BFu7ll_BFu8s { short v1; unsigned long long v2:7; unsigned short v3:8; };
struct S_BFu7ll_BFu9i { short v1; unsigned long long v2:7; unsigned int v3:9; };
struct S_BFu7ll_BFu9ll { short v1; unsigned long long v2:7; unsigned long long v3:9; };
struct S_BFu7ll_BFu9s { short v1; unsigned long long v2:7; unsigned short v3:9; };
struct S_BFu7ll_C { short v1; unsigned long long v2:7; char v3; };
struct S_BFu7ll_D { short v1; unsigned long long v2:7; double v3; };
struct S_BFu7ll_F { short v1; unsigned long long v2:7; float v3; };
struct S_BFu7ll_I { short v1; unsigned long long v2:7; int v3; };
struct S_BFu7ll_Ip { short v1; unsigned long long v2:7; int * v3; };
struct S_BFu7ll_L { short v1; unsigned long long v2:7; long long v3; };
struct S_BFu7ll_S { short v1; unsigned long long v2:7; short v3; };
struct S_BFu7ll_Uc { short v1; unsigned long long v2:7; unsigned char v3; };
struct S_BFu7ll_Ui { short v1; unsigned long long v2:7; unsigned int v3; };
struct S_BFu7ll_Ul { short v1; unsigned long long v2:7; unsigned long long v3; };
struct S_BFu7ll_Us { short v1; unsigned long long v2:7; unsigned short v3; };
struct S_BFu7ll_Vp { short v1; unsigned long long v2:7; void * v3; };
struct S_BFu7s { short v1; unsigned short v2:7; };
struct S_BFu7s_BFu15i { short v1; unsigned short v2:7; unsigned int v3:15; };
struct S_BFu7s_BFu15ll { short v1; unsigned short v2:7; unsigned long long v3:15; };
struct S_BFu7s_BFu15s { short v1; unsigned short v2:7; unsigned short v3:15; };
struct S_BFu7s_BFu16i { short v1; unsigned short v2:7; unsigned int v3:16; };
struct S_BFu7s_BFu16ll { short v1; unsigned short v2:7; unsigned long long v3:16; };
struct S_BFu7s_BFu16s { short v1; unsigned short v2:7; unsigned short v3:16; };
struct S_BFu7s_BFu17i { short v1; unsigned short v2:7; unsigned int v3:17; };
struct S_BFu7s_BFu17ll { short v1; unsigned short v2:7; unsigned long long v3:17; };
struct S_BFu7s_BFu1c { short v1; unsigned short v2:7; unsigned char v3:1; };
struct S_BFu7s_BFu1i { short v1; unsigned short v2:7; unsigned int v3:1; };
struct S_BFu7s_BFu1ll { short v1; unsigned short v2:7; unsigned long long v3:1; };
struct S_BFu7s_BFu1s { short v1; unsigned short v2:7; unsigned short v3:1; };
struct S_BFu7s_BFu31i { short v1; unsigned short v2:7; unsigned int v3:31; };
struct S_BFu7s_BFu31ll { short v1; unsigned short v2:7; unsigned long long v3:31; };
struct S_BFu7s_BFu32i { short v1; unsigned short v2:7; unsigned int v3:32; };
struct S_BFu7s_BFu32ll { short v1; unsigned short v2:7; unsigned long long v3:32; };
struct S_BFu7s_BFu33 { short v1; unsigned short v2:7; unsigned long long v3:33; };
struct S_BFu7s_BFu7c { short v1; unsigned short v2:7; unsigned char v3:7; };
struct S_BFu7s_BFu7i { short v1; unsigned short v2:7; unsigned int v3:7; };
struct S_BFu7s_BFu7ll { short v1; unsigned short v2:7; unsigned long long v3:7; };
struct S_BFu7s_BFu7s { short v1; unsigned short v2:7; unsigned short v3:7; };
struct S_BFu7s_BFu8c { short v1; unsigned short v2:7; unsigned char v3:8; };
struct S_BFu7s_BFu8i { short v1; unsigned short v2:7; unsigned int v3:8; };
struct S_BFu7s_BFu8ll { short v1; unsigned short v2:7; unsigned long long v3:8; };
struct S_BFu7s_BFu8s { short v1; unsigned short v2:7; unsigned short v3:8; };
struct S_BFu7s_BFu9i { short v1; unsigned short v2:7; unsigned int v3:9; };
struct S_BFu7s_BFu9ll { short v1; unsigned short v2:7; unsigned long long v3:9; };
struct S_BFu7s_BFu9s { short v1; unsigned short v2:7; unsigned short v3:9; };
struct S_BFu7s_C { short v1; unsigned short v2:7; char v3; };
struct S_BFu7s_D { short v1; unsigned short v2:7; double v3; };
struct S_BFu7s_F { short v1; unsigned short v2:7; float v3; };
struct S_BFu7s_I { short v1; unsigned short v2:7; int v3; };
struct S_BFu7s_Ip { short v1; unsigned short v2:7; int * v3; };
struct S_BFu7s_L { short v1; unsigned short v2:7; long long v3; };
struct S_BFu7s_S { short v1; unsigned short v2:7; short v3; };
struct S_BFu7s_Uc { short v1; unsigned short v2:7; unsigned char v3; };
struct S_BFu7s_Ui { short v1; unsigned short v2:7; unsigned int v3; };
struct S_BFu7s_Ul { short v1; unsigned short v2:7; unsigned long long v3; };
struct S_BFu7s_Us { short v1; unsigned short v2:7; unsigned short v3; };
struct S_BFu7s_Vp { short v1; unsigned short v2:7; void * v3; };
struct S_BFu8c { short v1; unsigned char v2:8; };
struct S_BFu8c_BFu15i { short v1; unsigned char v2:8; unsigned int v3:15; };
struct S_BFu8c_BFu15ll { short v1; unsigned char v2:8; unsigned long long v3:15; };
struct S_BFu8c_BFu15s { short v1; unsigned char v2:8; unsigned short v3:15; };
struct S_BFu8c_BFu16i { short v1; unsigned char v2:8; unsigned int v3:16; };
struct S_BFu8c_BFu16ll { short v1; unsigned char v2:8; unsigned long long v3:16; };
struct S_BFu8c_BFu16s { short v1; unsigned char v2:8; unsigned short v3:16; };
struct S_BFu8c_BFu17i { short v1; unsigned char v2:8; unsigned int v3:17; };
struct S_BFu8c_BFu17ll { short v1; unsigned char v2:8; unsigned long long v3:17; };
struct S_BFu8c_BFu1c { short v1; unsigned char v2:8; unsigned char v3:1; };
struct S_BFu8c_BFu1i { short v1; unsigned char v2:8; unsigned int v3:1; };
struct S_BFu8c_BFu1ll { short v1; unsigned char v2:8; unsigned long long v3:1; };
struct S_BFu8c_BFu1s { short v1; unsigned char v2:8; unsigned short v3:1; };
struct S_BFu8c_BFu31i { short v1; unsigned char v2:8; unsigned int v3:31; };
struct S_BFu8c_BFu31ll { short v1; unsigned char v2:8; unsigned long long v3:31; };
struct S_BFu8c_BFu32i { short v1; unsigned char v2:8; unsigned int v3:32; };
struct S_BFu8c_BFu32ll { short v1; unsigned char v2:8; unsigned long long v3:32; };
struct S_BFu8c_BFu33 { short v1; unsigned char v2:8; unsigned long long v3:33; };
struct S_BFu8c_BFu7c { short v1; unsigned char v2:8; unsigned char v3:7; };
struct S_BFu8c_BFu7i { short v1; unsigned char v2:8; unsigned int v3:7; };
struct S_BFu8c_BFu7ll { short v1; unsigned char v2:8; unsigned long long v3:7; };
struct S_BFu8c_BFu7s { short v1; unsigned char v2:8; unsigned short v3:7; };
struct S_BFu8c_BFu8c { short v1; unsigned char v2:8; unsigned char v3:8; };
struct S_BFu8c_BFu8i { short v1; unsigned char v2:8; unsigned int v3:8; };
struct S_BFu8c_BFu8ll { short v1; unsigned char v2:8; unsigned long long v3:8; };
struct S_BFu8c_BFu8s { short v1; unsigned char v2:8; unsigned short v3:8; };
struct S_BFu8c_BFu9i { short v1; unsigned char v2:8; unsigned int v3:9; };
struct S_BFu8c_BFu9ll { short v1; unsigned char v2:8; unsigned long long v3:9; };
struct S_BFu8c_BFu9s { short v1; unsigned char v2:8; unsigned short v3:9; };
struct S_BFu8c_C { short v1; unsigned char v2:8; char v3; };
struct S_BFu8c_D { short v1; unsigned char v2:8; double v3; };
struct S_BFu8c_F { short v1; unsigned char v2:8; float v3; };
struct S_BFu8c_I { short v1; unsigned char v2:8; int v3; };
struct S_BFu8c_Ip { short v1; unsigned char v2:8; int * v3; };
struct S_BFu8c_L { short v1; unsigned char v2:8; long long v3; };
struct S_BFu8c_S { short v1; unsigned char v2:8; short v3; };
struct S_BFu8c_Uc { short v1; unsigned char v2:8; unsigned char v3; };
struct S_BFu8c_Ui { short v1; unsigned char v2:8; unsigned int v3; };
struct S_BFu8c_Ul { short v1; unsigned char v2:8; unsigned long long v3; };
struct S_BFu8c_Us { short v1; unsigned char v2:8; unsigned short v3; };
struct S_BFu8c_Vp { short v1; unsigned char v2:8; void * v3; };
struct S_BFu8i { short v1; unsigned int v2:8; };
struct S_BFu8i_BFu15i { short v1; unsigned int v2:8; unsigned int v3:15; };
struct S_BFu8i_BFu15ll { short v1; unsigned int v2:8; unsigned long long v3:15; };
struct S_BFu8i_BFu15s { short v1; unsigned int v2:8; unsigned short v3:15; };
struct S_BFu8i_BFu16i { short v1; unsigned int v2:8; unsigned int v3:16; };
struct S_BFu8i_BFu16ll { short v1; unsigned int v2:8; unsigned long long v3:16; };
struct S_BFu8i_BFu16s { short v1; unsigned int v2:8; unsigned short v3:16; };
struct S_BFu8i_BFu17i { short v1; unsigned int v2:8; unsigned int v3:17; };
struct S_BFu8i_BFu17ll { short v1; unsigned int v2:8; unsigned long long v3:17; };
struct S_BFu8i_BFu1c { short v1; unsigned int v2:8; unsigned char v3:1; };
struct S_BFu8i_BFu1i { short v1; unsigned int v2:8; unsigned int v3:1; };
struct S_BFu8i_BFu1ll { short v1; unsigned int v2:8; unsigned long long v3:1; };
struct S_BFu8i_BFu1s { short v1; unsigned int v2:8; unsigned short v3:1; };
struct S_BFu8i_BFu31i { short v1; unsigned int v2:8; unsigned int v3:31; };
struct S_BFu8i_BFu31ll { short v1; unsigned int v2:8; unsigned long long v3:31; };
struct S_BFu8i_BFu32i { short v1; unsigned int v2:8; unsigned int v3:32; };
struct S_BFu8i_BFu32ll { short v1; unsigned int v2:8; unsigned long long v3:32; };
struct S_BFu8i_BFu33 { short v1; unsigned int v2:8; unsigned long long v3:33; };
struct S_BFu8i_BFu7c { short v1; unsigned int v2:8; unsigned char v3:7; };
struct S_BFu8i_BFu7i { short v1; unsigned int v2:8; unsigned int v3:7; };
struct S_BFu8i_BFu7ll { short v1; unsigned int v2:8; unsigned long long v3:7; };
struct S_BFu8i_BFu7s { short v1; unsigned int v2:8; unsigned short v3:7; };
struct S_BFu8i_BFu8c { short v1; unsigned int v2:8; unsigned char v3:8; };
struct S_BFu8i_BFu8i { short v1; unsigned int v2:8; unsigned int v3:8; };
struct S_BFu8i_BFu8ll { short v1; unsigned int v2:8; unsigned long long v3:8; };
struct S_BFu8i_BFu8s { short v1; unsigned int v2:8; unsigned short v3:8; };
struct S_BFu8i_BFu9i { short v1; unsigned int v2:8; unsigned int v3:9; };
struct S_BFu8i_BFu9ll { short v1; unsigned int v2:8; unsigned long long v3:9; };
struct S_BFu8i_BFu9s { short v1; unsigned int v2:8; unsigned short v3:9; };
struct S_BFu8i_C { short v1; unsigned int v2:8; char v3; };
struct S_BFu8i_D { short v1; unsigned int v2:8; double v3; };
struct S_BFu8i_F { short v1; unsigned int v2:8; float v3; };
struct S_BFu8i_I { short v1; unsigned int v2:8; int v3; };
struct S_BFu8i_Ip { short v1; unsigned int v2:8; int * v3; };
struct S_BFu8i_L { short v1; unsigned int v2:8; long long v3; };
struct S_BFu8i_S { short v1; unsigned int v2:8; short v3; };
struct S_BFu8i_Uc { short v1; unsigned int v2:8; unsigned char v3; };
struct S_BFu8i_Ui { short v1; unsigned int v2:8; unsigned int v3; };
struct S_BFu8i_Ul { short v1; unsigned int v2:8; unsigned long long v3; };
struct S_BFu8i_Us { short v1; unsigned int v2:8; unsigned short v3; };
struct S_BFu8i_Vp { short v1; unsigned int v2:8; void * v3; };
struct S_BFu8ll { short v1; unsigned long long v2:8; };
struct S_BFu8ll_BFu15i { short v1; unsigned long long v2:8; unsigned int v3:15; };
struct S_BFu8ll_BFu15ll { short v1; unsigned long long v2:8; unsigned long long v3:15; };
struct S_BFu8ll_BFu15s { short v1; unsigned long long v2:8; unsigned short v3:15; };
struct S_BFu8ll_BFu16i { short v1; unsigned long long v2:8; unsigned int v3:16; };
struct S_BFu8ll_BFu16ll { short v1; unsigned long long v2:8; unsigned long long v3:16; };
struct S_BFu8ll_BFu16s { short v1; unsigned long long v2:8; unsigned short v3:16; };
struct S_BFu8ll_BFu17i { short v1; unsigned long long v2:8; unsigned int v3:17; };
struct S_BFu8ll_BFu17ll { short v1; unsigned long long v2:8; unsigned long long v3:17; };
struct S_BFu8ll_BFu1c { short v1; unsigned long long v2:8; unsigned char v3:1; };
struct S_BFu8ll_BFu1i { short v1; unsigned long long v2:8; unsigned int v3:1; };
struct S_BFu8ll_BFu1ll { short v1; unsigned long long v2:8; unsigned long long v3:1; };
struct S_BFu8ll_BFu1s { short v1; unsigned long long v2:8; unsigned short v3:1; };
struct S_BFu8ll_BFu31i { short v1; unsigned long long v2:8; unsigned int v3:31; };
struct S_BFu8ll_BFu31ll { short v1; unsigned long long v2:8; unsigned long long v3:31; };
struct S_BFu8ll_BFu32i { short v1; unsigned long long v2:8; unsigned int v3:32; };
struct S_BFu8ll_BFu32ll { short v1; unsigned long long v2:8; unsigned long long v3:32; };
struct S_BFu8ll_BFu33 { short v1; unsigned long long v2:8; unsigned long long v3:33; };
struct S_BFu8ll_BFu7c { short v1; unsigned long long v2:8; unsigned char v3:7; };
struct S_BFu8ll_BFu7i { short v1; unsigned long long v2:8; unsigned int v3:7; };
struct S_BFu8ll_BFu7ll { short v1; unsigned long long v2:8; unsigned long long v3:7; };
struct S_BFu8ll_BFu7s { short v1; unsigned long long v2:8; unsigned short v3:7; };
struct S_BFu8ll_BFu8c { short v1; unsigned long long v2:8; unsigned char v3:8; };
struct S_BFu8ll_BFu8i { short v1; unsigned long long v2:8; unsigned int v3:8; };
struct S_BFu8ll_BFu8ll { short v1; unsigned long long v2:8; unsigned long long v3:8; };
struct S_BFu8ll_BFu8s { short v1; unsigned long long v2:8; unsigned short v3:8; };
struct S_BFu8ll_BFu9i { short v1; unsigned long long v2:8; unsigned int v3:9; };
struct S_BFu8ll_BFu9ll { short v1; unsigned long long v2:8; unsigned long long v3:9; };
struct S_BFu8ll_BFu9s { short v1; unsigned long long v2:8; unsigned short v3:9; };
struct S_BFu8ll_C { short v1; unsigned long long v2:8; char v3; };
struct S_BFu8ll_D { short v1; unsigned long long v2:8; double v3; };
struct S_BFu8ll_F { short v1; unsigned long long v2:8; float v3; };
struct S_BFu8ll_I { short v1; unsigned long long v2:8; int v3; };
struct S_BFu8ll_Ip { short v1; unsigned long long v2:8; int * v3; };
struct S_BFu8ll_L { short v1; unsigned long long v2:8; long long v3; };
struct S_BFu8ll_S { short v1; unsigned long long v2:8; short v3; };
struct S_BFu8ll_Uc { short v1; unsigned long long v2:8; unsigned char v3; };
struct S_BFu8ll_Ui { short v1; unsigned long long v2:8; unsigned int v3; };
struct S_BFu8ll_Ul { short v1; unsigned long long v2:8; unsigned long long v3; };
struct S_BFu8ll_Us { short v1; unsigned long long v2:8; unsigned short v3; };
struct S_BFu8ll_Vp { short v1; unsigned long long v2:8; void * v3; };
struct S_BFu8s { short v1; unsigned short v2:8; };
struct S_BFu8s_BFu15i { short v1; unsigned short v2:8; unsigned int v3:15; };
struct S_BFu8s_BFu15ll { short v1; unsigned short v2:8; unsigned long long v3:15; };
struct S_BFu8s_BFu15s { short v1; unsigned short v2:8; unsigned short v3:15; };
struct S_BFu8s_BFu16i { short v1; unsigned short v2:8; unsigned int v3:16; };
struct S_BFu8s_BFu16ll { short v1; unsigned short v2:8; unsigned long long v3:16; };
struct S_BFu8s_BFu16s { short v1; unsigned short v2:8; unsigned short v3:16; };
struct S_BFu8s_BFu17i { short v1; unsigned short v2:8; unsigned int v3:17; };
struct S_BFu8s_BFu17ll { short v1; unsigned short v2:8; unsigned long long v3:17; };
struct S_BFu8s_BFu1c { short v1; unsigned short v2:8; unsigned char v3:1; };
struct S_BFu8s_BFu1i { short v1; unsigned short v2:8; unsigned int v3:1; };
struct S_BFu8s_BFu1ll { short v1; unsigned short v2:8; unsigned long long v3:1; };
struct S_BFu8s_BFu1s { short v1; unsigned short v2:8; unsigned short v3:1; };
struct S_BFu8s_BFu31i { short v1; unsigned short v2:8; unsigned int v3:31; };
struct S_BFu8s_BFu31ll { short v1; unsigned short v2:8; unsigned long long v3:31; };
struct S_BFu8s_BFu32i { short v1; unsigned short v2:8; unsigned int v3:32; };
struct S_BFu8s_BFu32ll { short v1; unsigned short v2:8; unsigned long long v3:32; };
struct S_BFu8s_BFu33 { short v1; unsigned short v2:8; unsigned long long v3:33; };
struct S_BFu8s_BFu7c { short v1; unsigned short v2:8; unsigned char v3:7; };
struct S_BFu8s_BFu7i { short v1; unsigned short v2:8; unsigned int v3:7; };
struct S_BFu8s_BFu7ll { short v1; unsigned short v2:8; unsigned long long v3:7; };
struct S_BFu8s_BFu7s { short v1; unsigned short v2:8; unsigned short v3:7; };
struct S_BFu8s_BFu8c { short v1; unsigned short v2:8; unsigned char v3:8; };
struct S_BFu8s_BFu8i { short v1; unsigned short v2:8; unsigned int v3:8; };
struct S_BFu8s_BFu8ll { short v1; unsigned short v2:8; unsigned long long v3:8; };
struct S_BFu8s_BFu8s { short v1; unsigned short v2:8; unsigned short v3:8; };
struct S_BFu8s_BFu9i { short v1; unsigned short v2:8; unsigned int v3:9; };
struct S_BFu8s_BFu9ll { short v1; unsigned short v2:8; unsigned long long v3:9; };
struct S_BFu8s_BFu9s { short v1; unsigned short v2:8; unsigned short v3:9; };
struct S_BFu8s_C { short v1; unsigned short v2:8; char v3; };
struct S_BFu8s_D { short v1; unsigned short v2:8; double v3; };
struct S_BFu8s_F { short v1; unsigned short v2:8; float v3; };
struct S_BFu8s_I { short v1; unsigned short v2:8; int v3; };
struct S_BFu8s_Ip { short v1; unsigned short v2:8; int * v3; };
struct S_BFu8s_L { short v1; unsigned short v2:8; long long v3; };
struct S_BFu8s_S { short v1; unsigned short v2:8; short v3; };
struct S_BFu8s_Uc { short v1; unsigned short v2:8; unsigned char v3; };
struct S_BFu8s_Ui { short v1; unsigned short v2:8; unsigned int v3; };
struct S_BFu8s_Ul { short v1; unsigned short v2:8; unsigned long long v3; };
struct S_BFu8s_Us { short v1; unsigned short v2:8; unsigned short v3; };
struct S_BFu8s_Vp { short v1; unsigned short v2:8; void * v3; };
struct S_BFu9i { short v1; unsigned int v2:9; };
struct S_BFu9i_BFu15i { short v1; unsigned int v2:9; unsigned int v3:15; };
struct S_BFu9i_BFu15ll { short v1; unsigned int v2:9; unsigned long long v3:15; };
struct S_BFu9i_BFu15s { short v1; unsigned int v2:9; unsigned short v3:15; };
struct S_BFu9i_BFu16i { short v1; unsigned int v2:9; unsigned int v3:16; };
struct S_BFu9i_BFu16ll { short v1; unsigned int v2:9; unsigned long long v3:16; };
struct S_BFu9i_BFu16s { short v1; unsigned int v2:9; unsigned short v3:16; };
struct S_BFu9i_BFu17i { short v1; unsigned int v2:9; unsigned int v3:17; };
struct S_BFu9i_BFu17ll { short v1; unsigned int v2:9; unsigned long long v3:17; };
struct S_BFu9i_BFu1c { short v1; unsigned int v2:9; unsigned char v3:1; };
struct S_BFu9i_BFu1i { short v1; unsigned int v2:9; unsigned int v3:1; };
struct S_BFu9i_BFu1ll { short v1; unsigned int v2:9; unsigned long long v3:1; };
struct S_BFu9i_BFu1s { short v1; unsigned int v2:9; unsigned short v3:1; };
struct S_BFu9i_BFu31i { short v1; unsigned int v2:9; unsigned int v3:31; };
struct S_BFu9i_BFu31ll { short v1; unsigned int v2:9; unsigned long long v3:31; };
struct S_BFu9i_BFu32i { short v1; unsigned int v2:9; unsigned int v3:32; };
struct S_BFu9i_BFu32ll { short v1; unsigned int v2:9; unsigned long long v3:32; };
struct S_BFu9i_BFu33 { short v1; unsigned int v2:9; unsigned long long v3:33; };
struct S_BFu9i_BFu7c { short v1; unsigned int v2:9; unsigned char v3:7; };
struct S_BFu9i_BFu7i { short v1; unsigned int v2:9; unsigned int v3:7; };
struct S_BFu9i_BFu7ll { short v1; unsigned int v2:9; unsigned long long v3:7; };
struct S_BFu9i_BFu7s { short v1; unsigned int v2:9; unsigned short v3:7; };
struct S_BFu9i_BFu8c { short v1; unsigned int v2:9; unsigned char v3:8; };
struct S_BFu9i_BFu8i { short v1; unsigned int v2:9; unsigned int v3:8; };
struct S_BFu9i_BFu8ll { short v1; unsigned int v2:9; unsigned long long v3:8; };
struct S_BFu9i_BFu8s { short v1; unsigned int v2:9; unsigned short v3:8; };
struct S_BFu9i_BFu9i { short v1; unsigned int v2:9; unsigned int v3:9; };
struct S_BFu9i_BFu9ll { short v1; unsigned int v2:9; unsigned long long v3:9; };
struct S_BFu9i_BFu9s { short v1; unsigned int v2:9; unsigned short v3:9; };
struct S_BFu9i_C { short v1; unsigned int v2:9; char v3; };
struct S_BFu9i_D { short v1; unsigned int v2:9; double v3; };
struct S_BFu9i_F { short v1; unsigned int v2:9; float v3; };
struct S_BFu9i_I { short v1; unsigned int v2:9; int v3; };
struct S_BFu9i_Ip { short v1; unsigned int v2:9; int * v3; };
struct S_BFu9i_L { short v1; unsigned int v2:9; long long v3; };
struct S_BFu9i_S { short v1; unsigned int v2:9; short v3; };
struct S_BFu9i_Uc { short v1; unsigned int v2:9; unsigned char v3; };
struct S_BFu9i_Ui { short v1; unsigned int v2:9; unsigned int v3; };
struct S_BFu9i_Ul { short v1; unsigned int v2:9; unsigned long long v3; };
struct S_BFu9i_Us { short v1; unsigned int v2:9; unsigned short v3; };
struct S_BFu9i_Vp { short v1; unsigned int v2:9; void * v3; };
struct S_BFu9ll { short v1; unsigned long long v2:9; };
struct S_BFu9ll_BFu15i { short v1; unsigned long long v2:9; unsigned int v3:15; };
struct S_BFu9ll_BFu15ll { short v1; unsigned long long v2:9; unsigned long long v3:15; };
struct S_BFu9ll_BFu15s { short v1; unsigned long long v2:9; unsigned short v3:15; };
struct S_BFu9ll_BFu16i { short v1; unsigned long long v2:9; unsigned int v3:16; };
struct S_BFu9ll_BFu16ll { short v1; unsigned long long v2:9; unsigned long long v3:16; };
struct S_BFu9ll_BFu16s { short v1; unsigned long long v2:9; unsigned short v3:16; };
struct S_BFu9ll_BFu17i { short v1; unsigned long long v2:9; unsigned int v3:17; };
struct S_BFu9ll_BFu17ll { short v1; unsigned long long v2:9; unsigned long long v3:17; };
struct S_BFu9ll_BFu1c { short v1; unsigned long long v2:9; unsigned char v3:1; };
struct S_BFu9ll_BFu1i { short v1; unsigned long long v2:9; unsigned int v3:1; };
struct S_BFu9ll_BFu1ll { short v1; unsigned long long v2:9; unsigned long long v3:1; };
struct S_BFu9ll_BFu1s { short v1; unsigned long long v2:9; unsigned short v3:1; };
struct S_BFu9ll_BFu31i { short v1; unsigned long long v2:9; unsigned int v3:31; };
struct S_BFu9ll_BFu31ll { short v1; unsigned long long v2:9; unsigned long long v3:31; };
struct S_BFu9ll_BFu32i { short v1; unsigned long long v2:9; unsigned int v3:32; };
struct S_BFu9ll_BFu32ll { short v1; unsigned long long v2:9; unsigned long long v3:32; };
struct S_BFu9ll_BFu33 { short v1; unsigned long long v2:9; unsigned long long v3:33; };
struct S_BFu9ll_BFu7c { short v1; unsigned long long v2:9; unsigned char v3:7; };
struct S_BFu9ll_BFu7i { short v1; unsigned long long v2:9; unsigned int v3:7; };
struct S_BFu9ll_BFu7ll { short v1; unsigned long long v2:9; unsigned long long v3:7; };
struct S_BFu9ll_BFu7s { short v1; unsigned long long v2:9; unsigned short v3:7; };
struct S_BFu9ll_BFu8c { short v1; unsigned long long v2:9; unsigned char v3:8; };
struct S_BFu9ll_BFu8i { short v1; unsigned long long v2:9; unsigned int v3:8; };
struct S_BFu9ll_BFu8ll { short v1; unsigned long long v2:9; unsigned long long v3:8; };
struct S_BFu9ll_BFu8s { short v1; unsigned long long v2:9; unsigned short v3:8; };
struct S_BFu9ll_BFu9i { short v1; unsigned long long v2:9; unsigned int v3:9; };
struct S_BFu9ll_BFu9ll { short v1; unsigned long long v2:9; unsigned long long v3:9; };
struct S_BFu9ll_BFu9s { short v1; unsigned long long v2:9; unsigned short v3:9; };
struct S_BFu9ll_C { short v1; unsigned long long v2:9; char v3; };
struct S_BFu9ll_D { short v1; unsigned long long v2:9; double v3; };
struct S_BFu9ll_F { short v1; unsigned long long v2:9; float v3; };
struct S_BFu9ll_I { short v1; unsigned long long v2:9; int v3; };
struct S_BFu9ll_Ip { short v1; unsigned long long v2:9; int * v3; };
struct S_BFu9ll_L { short v1; unsigned long long v2:9; long long v3; };
struct S_BFu9ll_S { short v1; unsigned long long v2:9; short v3; };
struct S_BFu9ll_Uc { short v1; unsigned long long v2:9; unsigned char v3; };
struct S_BFu9ll_Ui { short v1; unsigned long long v2:9; unsigned int v3; };
struct S_BFu9ll_Ul { short v1; unsigned long long v2:9; unsigned long long v3; };
struct S_BFu9ll_Us { short v1; unsigned long long v2:9; unsigned short v3; };
struct S_BFu9ll_Vp { short v1; unsigned long long v2:9; void * v3; };
struct S_BFu9s { short v1; unsigned short v2:9; };
struct S_BFu9s_BFu15i { short v1; unsigned short v2:9; unsigned int v3:15; };
struct S_BFu9s_BFu15ll { short v1; unsigned short v2:9; unsigned long long v3:15; };
struct S_BFu9s_BFu15s { short v1; unsigned short v2:9; unsigned short v3:15; };
struct S_BFu9s_BFu16i { short v1; unsigned short v2:9; unsigned int v3:16; };
struct S_BFu9s_BFu16ll { short v1; unsigned short v2:9; unsigned long long v3:16; };
struct S_BFu9s_BFu16s { short v1; unsigned short v2:9; unsigned short v3:16; };
struct S_BFu9s_BFu17i { short v1; unsigned short v2:9; unsigned int v3:17; };
struct S_BFu9s_BFu17ll { short v1; unsigned short v2:9; unsigned long long v3:17; };
struct S_BFu9s_BFu1c { short v1; unsigned short v2:9; unsigned char v3:1; };
struct S_BFu9s_BFu1i { short v1; unsigned short v2:9; unsigned int v3:1; };
struct S_BFu9s_BFu1ll { short v1; unsigned short v2:9; unsigned long long v3:1; };
struct S_BFu9s_BFu1s { short v1; unsigned short v2:9; unsigned short v3:1; };
struct S_BFu9s_BFu31i { short v1; unsigned short v2:9; unsigned int v3:31; };
struct S_BFu9s_BFu31ll { short v1; unsigned short v2:9; unsigned long long v3:31; };
struct S_BFu9s_BFu32i { short v1; unsigned short v2:9; unsigned int v3:32; };
struct S_BFu9s_BFu32ll { short v1; unsigned short v2:9; unsigned long long v3:32; };
struct S_BFu9s_BFu33 { short v1; unsigned short v2:9; unsigned long long v3:33; };
struct S_BFu9s_BFu7c { short v1; unsigned short v2:9; unsigned char v3:7; };
struct S_BFu9s_BFu7i { short v1; unsigned short v2:9; unsigned int v3:7; };
struct S_BFu9s_BFu7ll { short v1; unsigned short v2:9; unsigned long long v3:7; };
struct S_BFu9s_BFu7s { short v1; unsigned short v2:9; unsigned short v3:7; };
struct S_BFu9s_BFu8c { short v1; unsigned short v2:9; unsigned char v3:8; };
struct S_BFu9s_BFu8i { short v1; unsigned short v2:9; unsigned int v3:8; };
struct S_BFu9s_BFu8ll { short v1; unsigned short v2:9; unsigned long long v3:8; };
struct S_BFu9s_BFu8s { short v1; unsigned short v2:9; unsigned short v3:8; };
struct S_BFu9s_BFu9i { short v1; unsigned short v2:9; unsigned int v3:9; };
struct S_BFu9s_BFu9ll { short v1; unsigned short v2:9; unsigned long long v3:9; };
struct S_BFu9s_BFu9s { short v1; unsigned short v2:9; unsigned short v3:9; };
struct S_BFu9s_C { short v1; unsigned short v2:9; char v3; };
struct S_BFu9s_D { short v1; unsigned short v2:9; double v3; };
struct S_BFu9s_F { short v1; unsigned short v2:9; float v3; };
struct S_BFu9s_I { short v1; unsigned short v2:9; int v3; };
struct S_BFu9s_Ip { short v1; unsigned short v2:9; int * v3; };
struct S_BFu9s_L { short v1; unsigned short v2:9; long long v3; };
struct S_BFu9s_S { short v1; unsigned short v2:9; short v3; };
struct S_BFu9s_Uc { short v1; unsigned short v2:9; unsigned char v3; };
struct S_BFu9s_Ui { short v1; unsigned short v2:9; unsigned int v3; };
struct S_BFu9s_Ul { short v1; unsigned short v2:9; unsigned long long v3; };
struct S_BFu9s_Us { short v1; unsigned short v2:9; unsigned short v3; };
struct S_BFu9s_Vp { short v1; unsigned short v2:9; void * v3; };
struct S_C { short v1; char v2; };
struct S_C_BFu15i { short v1; char v2; unsigned int v3:15; };
struct S_C_BFu15ll { short v1; char v2; unsigned long long v3:15; };
struct S_C_BFu15s { short v1; char v2; unsigned short v3:15; };
struct S_C_BFu16i { short v1; char v2; unsigned int v3:16; };
struct S_C_BFu16ll { short v1; char v2; unsigned long long v3:16; };
struct S_C_BFu16s { short v1; char v2; unsigned short v3:16; };
struct S_C_BFu17i { short v1; char v2; unsigned int v3:17; };
struct S_C_BFu17ll { short v1; char v2; unsigned long long v3:17; };
struct S_C_BFu1c { short v1; char v2; unsigned char v3:1; };
struct S_C_BFu1i { short v1; char v2; unsigned int v3:1; };
struct S_C_BFu1ll { short v1; char v2; unsigned long long v3:1; };
struct S_C_BFu1s { short v1; char v2; unsigned short v3:1; };
struct S_C_BFu31i { short v1; char v2; unsigned int v3:31; };
struct S_C_BFu31ll { short v1; char v2; unsigned long long v3:31; };
struct S_C_BFu32i { short v1; char v2; unsigned int v3:32; };
struct S_C_BFu32ll { short v1; char v2; unsigned long long v3:32; };
struct S_C_BFu33 { short v1; char v2; unsigned long long v3:33; };
struct S_C_BFu7c { short v1; char v2; unsigned char v3:7; };
struct S_C_BFu7i { short v1; char v2; unsigned int v3:7; };
struct S_C_BFu7ll { short v1; char v2; unsigned long long v3:7; };
struct S_C_BFu7s { short v1; char v2; unsigned short v3:7; };
struct S_C_BFu8c { short v1; char v2; unsigned char v3:8; };
struct S_C_BFu8i { short v1; char v2; unsigned int v3:8; };
struct S_C_BFu8ll { short v1; char v2; unsigned long long v3:8; };
struct S_C_BFu8s { short v1; char v2; unsigned short v3:8; };
struct S_C_BFu9i { short v1; char v2; unsigned int v3:9; };
struct S_C_BFu9ll { short v1; char v2; unsigned long long v3:9; };
struct S_C_BFu9s { short v1; char v2; unsigned short v3:9; };
struct S_C_C { short v1; char v2; char v3; };
struct S_C_D { short v1; char v2; double v3; };
struct S_C_F { short v1; char v2; float v3; };
struct S_C_I { short v1; char v2; int v3; };
struct S_C_Ip { short v1; char v2; int * v3; };
struct S_C_L { short v1; char v2; long long v3; };
struct S_C_S { short v1; char v2; short v3; };
struct S_C_Uc { short v1; char v2; unsigned char v3; };
struct S_C_Ui { short v1; char v2; unsigned int v3; };
struct S_C_Ul { short v1; char v2; unsigned long long v3; };
struct S_C_Us { short v1; char v2; unsigned short v3; };
struct S_C_Vp { short v1; char v2; void * v3; };
struct S_D { short v1; double v2; };
struct S_D_BFu15i { short v1; double v2; unsigned int v3:15; };
struct S_D_BFu15ll { short v1; double v2; unsigned long long v3:15; };
struct S_D_BFu15s { short v1; double v2; unsigned short v3:15; };
struct S_D_BFu16i { short v1; double v2; unsigned int v3:16; };
struct S_D_BFu16ll { short v1; double v2; unsigned long long v3:16; };
struct S_D_BFu16s { short v1; double v2; unsigned short v3:16; };
struct S_D_BFu17i { short v1; double v2; unsigned int v3:17; };
struct S_D_BFu17ll { short v1; double v2; unsigned long long v3:17; };
struct S_D_BFu1c { short v1; double v2; unsigned char v3:1; };
struct S_D_BFu1i { short v1; double v2; unsigned int v3:1; };
struct S_D_BFu1ll { short v1; double v2; unsigned long long v3:1; };
struct S_D_BFu1s { short v1; double v2; unsigned short v3:1; };
struct S_D_BFu31i { short v1; double v2; unsigned int v3:31; };
struct S_D_BFu31ll { short v1; double v2; unsigned long long v3:31; };
struct S_D_BFu32i { short v1; double v2; unsigned int v3:32; };
struct S_D_BFu32ll { short v1; double v2; unsigned long long v3:32; };
struct S_D_BFu33 { short v1; double v2; unsigned long long v3:33; };
struct S_D_BFu7c { short v1; double v2; unsigned char v3:7; };
struct S_D_BFu7i { short v1; double v2; unsigned int v3:7; };
struct S_D_BFu7ll { short v1; double v2; unsigned long long v3:7; };
struct S_D_BFu7s { short v1; double v2; unsigned short v3:7; };
struct S_D_BFu8c { short v1; double v2; unsigned char v3:8; };
struct S_D_BFu8i { short v1; double v2; unsigned int v3:8; };
struct S_D_BFu8ll { short v1; double v2; unsigned long long v3:8; };
struct S_D_BFu8s { short v1; double v2; unsigned short v3:8; };
struct S_D_BFu9i { short v1; double v2; unsigned int v3:9; };
struct S_D_BFu9ll { short v1; double v2; unsigned long long v3:9; };
struct S_D_BFu9s { short v1; double v2; unsigned short v3:9; };
struct S_D_C { short v1; double v2; char v3; };
struct S_D_D { short v1; double v2; double v3; };
struct S_D_F { short v1; double v2; float v3; };
struct S_D_I { short v1; double v2; int v3; };
struct S_D_Ip { short v1; double v2; int * v3; };
struct S_D_L { short v1; double v2; long long v3; };
struct S_D_S { short v1; double v2; short v3; };
struct S_D_Uc { short v1; double v2; unsigned char v3; };
struct S_D_Ui { short v1; double v2; unsigned int v3; };
struct S_D_Ul { short v1; double v2; unsigned long long v3; };
struct S_D_Us { short v1; double v2; unsigned short v3; };
struct S_D_Vp { short v1; double v2; void * v3; };
struct S_F { short v1; float v2; };
struct S_F_BFu15i { short v1; float v2; unsigned int v3:15; };
struct S_F_BFu15ll { short v1; float v2; unsigned long long v3:15; };
struct S_F_BFu15s { short v1; float v2; unsigned short v3:15; };
struct S_F_BFu16i { short v1; float v2; unsigned int v3:16; };
struct S_F_BFu16ll { short v1; float v2; unsigned long long v3:16; };
struct S_F_BFu16s { short v1; float v2; unsigned short v3:16; };
struct S_F_BFu17i { short v1; float v2; unsigned int v3:17; };
struct S_F_BFu17ll { short v1; float v2; unsigned long long v3:17; };
struct S_F_BFu1c { short v1; float v2; unsigned char v3:1; };
struct S_F_BFu1i { short v1; float v2; unsigned int v3:1; };
struct S_F_BFu1ll { short v1; float v2; unsigned long long v3:1; };
struct S_F_BFu1s { short v1; float v2; unsigned short v3:1; };
struct S_F_BFu31i { short v1; float v2; unsigned int v3:31; };
struct S_F_BFu31ll { short v1; float v2; unsigned long long v3:31; };
struct S_F_BFu32i { short v1; float v2; unsigned int v3:32; };
struct S_F_BFu32ll { short v1; float v2; unsigned long long v3:32; };
struct S_F_BFu33 { short v1; float v2; unsigned long long v3:33; };
struct S_F_BFu7c { short v1; float v2; unsigned char v3:7; };
struct S_F_BFu7i { short v1; float v2; unsigned int v3:7; };
struct S_F_BFu7ll { short v1; float v2; unsigned long long v3:7; };
struct S_F_BFu7s { short v1; float v2; unsigned short v3:7; };
struct S_F_BFu8c { short v1; float v2; unsigned char v3:8; };
struct S_F_BFu8i { short v1; float v2; unsigned int v3:8; };
struct S_F_BFu8ll { short v1; float v2; unsigned long long v3:8; };
struct S_F_BFu8s { short v1; float v2; unsigned short v3:8; };
struct S_F_BFu9i { short v1; float v2; unsigned int v3:9; };
struct S_F_BFu9ll { short v1; float v2; unsigned long long v3:9; };
struct S_F_BFu9s { short v1; float v2; unsigned short v3:9; };
struct S_F_C { short v1; float v2; char v3; };
struct S_F_D { short v1; float v2; double v3; };
struct S_F_F { short v1; float v2; float v3; };
struct S_F_I { short v1; float v2; int v3; };
struct S_F_Ip { short v1; float v2; int * v3; };
struct S_F_L { short v1; float v2; long long v3; };
struct S_F_S { short v1; float v2; short v3; };
struct S_F_Uc { short v1; float v2; unsigned char v3; };
struct S_F_Ui { short v1; float v2; unsigned int v3; };
struct S_F_Ul { short v1; float v2; unsigned long long v3; };
struct S_F_Us { short v1; float v2; unsigned short v3; };
struct S_F_Vp { short v1; float v2; void * v3; };
struct S_I { short v1; int v2; };
struct S_I_BFu15i { short v1; int v2; unsigned int v3:15; };
struct S_I_BFu15ll { short v1; int v2; unsigned long long v3:15; };
struct S_I_BFu15s { short v1; int v2; unsigned short v3:15; };
struct S_I_BFu16i { short v1; int v2; unsigned int v3:16; };
struct S_I_BFu16ll { short v1; int v2; unsigned long long v3:16; };
struct S_I_BFu16s { short v1; int v2; unsigned short v3:16; };
struct S_I_BFu17i { short v1; int v2; unsigned int v3:17; };
struct S_I_BFu17ll { short v1; int v2; unsigned long long v3:17; };
struct S_I_BFu1c { short v1; int v2; unsigned char v3:1; };
struct S_I_BFu1i { short v1; int v2; unsigned int v3:1; };
struct S_I_BFu1ll { short v1; int v2; unsigned long long v3:1; };
struct S_I_BFu1s { short v1; int v2; unsigned short v3:1; };
struct S_I_BFu31i { short v1; int v2; unsigned int v3:31; };
struct S_I_BFu31ll { short v1; int v2; unsigned long long v3:31; };
struct S_I_BFu32i { short v1; int v2; unsigned int v3:32; };
struct S_I_BFu32ll { short v1; int v2; unsigned long long v3:32; };
struct S_I_BFu33 { short v1; int v2; unsigned long long v3:33; };
struct S_I_BFu7c { short v1; int v2; unsigned char v3:7; };
struct S_I_BFu7i { short v1; int v2; unsigned int v3:7; };
struct S_I_BFu7ll { short v1; int v2; unsigned long long v3:7; };
struct S_I_BFu7s { short v1; int v2; unsigned short v3:7; };
struct S_I_BFu8c { short v1; int v2; unsigned char v3:8; };
struct S_I_BFu8i { short v1; int v2; unsigned int v3:8; };
struct S_I_BFu8ll { short v1; int v2; unsigned long long v3:8; };
struct S_I_BFu8s { short v1; int v2; unsigned short v3:8; };
struct S_I_BFu9i { short v1; int v2; unsigned int v3:9; };
struct S_I_BFu9ll { short v1; int v2; unsigned long long v3:9; };
struct S_I_BFu9s { short v1; int v2; unsigned short v3:9; };
struct S_I_C { short v1; int v2; char v3; };
struct S_I_D { short v1; int v2; double v3; };
struct S_I_F { short v1; int v2; float v3; };
struct S_I_I { short v1; int v2; int v3; };
struct S_I_Ip { short v1; int v2; int * v3; };
struct S_I_L { short v1; int v2; long long v3; };
struct S_I_S { short v1; int v2; short v3; };
struct S_I_Uc { short v1; int v2; unsigned char v3; };
struct S_I_Ui { short v1; int v2; unsigned int v3; };
struct S_I_Ul { short v1; int v2; unsigned long long v3; };
struct S_I_Us { short v1; int v2; unsigned short v3; };
struct S_I_Vp { short v1; int v2; void * v3; };
struct S_Ip { short v1; int * v2; };
struct S_Ip_BFu15i { short v1; int * v2; unsigned int v3:15; };
struct S_Ip_BFu15ll { short v1; int * v2; unsigned long long v3:15; };
struct S_Ip_BFu15s { short v1; int * v2; unsigned short v3:15; };
struct S_Ip_BFu16i { short v1; int * v2; unsigned int v3:16; };
struct S_Ip_BFu16ll { short v1; int * v2; unsigned long long v3:16; };
struct S_Ip_BFu16s { short v1; int * v2; unsigned short v3:16; };
struct S_Ip_BFu17i { short v1; int * v2; unsigned int v3:17; };
struct S_Ip_BFu17ll { short v1; int * v2; unsigned long long v3:17; };
struct S_Ip_BFu1c { short v1; int * v2; unsigned char v3:1; };
struct S_Ip_BFu1i { short v1; int * v2; unsigned int v3:1; };
struct S_Ip_BFu1ll { short v1; int * v2; unsigned long long v3:1; };
struct S_Ip_BFu1s { short v1; int * v2; unsigned short v3:1; };
struct S_Ip_BFu31i { short v1; int * v2; unsigned int v3:31; };
struct S_Ip_BFu31ll { short v1; int * v2; unsigned long long v3:31; };
struct S_Ip_BFu32i { short v1; int * v2; unsigned int v3:32; };
struct S_Ip_BFu32ll { short v1; int * v2; unsigned long long v3:32; };
struct S_Ip_BFu33 { short v1; int * v2; unsigned long long v3:33; };
struct S_Ip_BFu7c { short v1; int * v2; unsigned char v3:7; };
struct S_Ip_BFu7i { short v1; int * v2; unsigned int v3:7; };
struct S_Ip_BFu7ll { short v1; int * v2; unsigned long long v3:7; };
struct S_Ip_BFu7s { short v1; int * v2; unsigned short v3:7; };
struct S_Ip_BFu8c { short v1; int * v2; unsigned char v3:8; };
struct S_Ip_BFu8i { short v1; int * v2; unsigned int v3:8; };
struct S_Ip_BFu8ll { short v1; int * v2; unsigned long long v3:8; };
struct S_Ip_BFu8s { short v1; int * v2; unsigned short v3:8; };
struct S_Ip_BFu9i { short v1; int * v2; unsigned int v3:9; };
struct S_Ip_BFu9ll { short v1; int * v2; unsigned long long v3:9; };
struct S_Ip_BFu9s { short v1; int * v2; unsigned short v3:9; };
struct S_Ip_C { short v1; int * v2; char v3; };
struct S_Ip_D { short v1; int * v2; double v3; };
struct S_Ip_F { short v1; int * v2; float v3; };
struct S_Ip_I { short v1; int * v2; int v3; };
struct S_Ip_Ip { short v1; int * v2; int * v3; };
struct S_Ip_L { short v1; int * v2; long long v3; };
struct S_Ip_S { short v1; int * v2; short v3; };
struct S_Ip_Uc { short v1; int * v2; unsigned char v3; };
struct S_Ip_Ui { short v1; int * v2; unsigned int v3; };
struct S_Ip_Ul { short v1; int * v2; unsigned long long v3; };
struct S_Ip_Us { short v1; int * v2; unsigned short v3; };
struct S_Ip_Vp { short v1; int * v2; void * v3; };
struct S_L { short v1; long long v2; };
struct S_L_BFu15i { short v1; long long v2; unsigned int v3:15; };
struct S_L_BFu15ll { short v1; long long v2; unsigned long long v3:15; };
struct S_L_BFu15s { short v1; long long v2; unsigned short v3:15; };
struct S_L_BFu16i { short v1; long long v2; unsigned int v3:16; };
struct S_L_BFu16ll { short v1; long long v2; unsigned long long v3:16; };
struct S_L_BFu16s { short v1; long long v2; unsigned short v3:16; };
struct S_L_BFu17i { short v1; long long v2; unsigned int v3:17; };
struct S_L_BFu17ll { short v1; long long v2; unsigned long long v3:17; };
struct S_L_BFu1c { short v1; long long v2; unsigned char v3:1; };
struct S_L_BFu1i { short v1; long long v2; unsigned int v3:1; };
struct S_L_BFu1ll { short v1; long long v2; unsigned long long v3:1; };
struct S_L_BFu1s { short v1; long long v2; unsigned short v3:1; };
struct S_L_BFu31i { short v1; long long v2; unsigned int v3:31; };
struct S_L_BFu31ll { short v1; long long v2; unsigned long long v3:31; };
struct S_L_BFu32i { short v1; long long v2; unsigned int v3:32; };
struct S_L_BFu32ll { short v1; long long v2; unsigned long long v3:32; };
struct S_L_BFu33 { short v1; long long v2; unsigned long long v3:33; };
struct S_L_BFu7c { short v1; long long v2; unsigned char v3:7; };
struct S_L_BFu7i { short v1; long long v2; unsigned int v3:7; };
struct S_L_BFu7ll { short v1; long long v2; unsigned long long v3:7; };
struct S_L_BFu7s { short v1; long long v2; unsigned short v3:7; };
struct S_L_BFu8c { short v1; long long v2; unsigned char v3:8; };
struct S_L_BFu8i { short v1; long long v2; unsigned int v3:8; };
struct S_L_BFu8ll { short v1; long long v2; unsigned long long v3:8; };
struct S_L_BFu8s { short v1; long long v2; unsigned short v3:8; };
struct S_L_BFu9i { short v1; long long v2; unsigned int v3:9; };
struct S_L_BFu9ll { short v1; long long v2; unsigned long long v3:9; };
struct S_L_BFu9s { short v1; long long v2; unsigned short v3:9; };
struct S_L_C { short v1; long long v2; char v3; };
struct S_L_D { short v1; long long v2; double v3; };
struct S_L_F { short v1; long long v2; float v3; };
struct S_L_I { short v1; long long v2; int v3; };
struct S_L_Ip { short v1; long long v2; int * v3; };
struct S_L_L { short v1; long long v2; long long v3; };
struct S_L_S { short v1; long long v2; short v3; };
struct S_L_Uc { short v1; long long v2; unsigned char v3; };
struct S_L_Ui { short v1; long long v2; unsigned int v3; };
struct S_L_Ul { short v1; long long v2; unsigned long long v3; };
struct S_L_Us { short v1; long long v2; unsigned short v3; };
struct S_L_Vp { short v1; long long v2; void * v3; };
struct S_S { short v1; short v2; };
struct S_S_BFu15i { short v1; short v2; unsigned int v3:15; };
struct S_S_BFu15ll { short v1; short v2; unsigned long long v3:15; };
struct S_S_BFu15s { short v1; short v2; unsigned short v3:15; };
struct S_S_BFu16i { short v1; short v2; unsigned int v3:16; };
struct S_S_BFu16ll { short v1; short v2; unsigned long long v3:16; };
struct S_S_BFu16s { short v1; short v2; unsigned short v3:16; };
struct S_S_BFu17i { short v1; short v2; unsigned int v3:17; };
struct S_S_BFu17ll { short v1; short v2; unsigned long long v3:17; };
struct S_S_BFu1c { short v1; short v2; unsigned char v3:1; };
struct S_S_BFu1i { short v1; short v2; unsigned int v3:1; };
struct S_S_BFu1ll { short v1; short v2; unsigned long long v3:1; };
struct S_S_BFu1s { short v1; short v2; unsigned short v3:1; };
struct S_S_BFu31i { short v1; short v2; unsigned int v3:31; };
struct S_S_BFu31ll { short v1; short v2; unsigned long long v3:31; };
struct S_S_BFu32i { short v1; short v2; unsigned int v3:32; };
struct S_S_BFu32ll { short v1; short v2; unsigned long long v3:32; };
struct S_S_BFu33 { short v1; short v2; unsigned long long v3:33; };
struct S_S_BFu7c { short v1; short v2; unsigned char v3:7; };
struct S_S_BFu7i { short v1; short v2; unsigned int v3:7; };
struct S_S_BFu7ll { short v1; short v2; unsigned long long v3:7; };
struct S_S_BFu7s { short v1; short v2; unsigned short v3:7; };
struct S_S_BFu8c { short v1; short v2; unsigned char v3:8; };
struct S_S_BFu8i { short v1; short v2; unsigned int v3:8; };
struct S_S_BFu8ll { short v1; short v2; unsigned long long v3:8; };
struct S_S_BFu8s { short v1; short v2; unsigned short v3:8; };
struct S_S_BFu9i { short v1; short v2; unsigned int v3:9; };
struct S_S_BFu9ll { short v1; short v2; unsigned long long v3:9; };
struct S_S_BFu9s { short v1; short v2; unsigned short v3:9; };
struct S_S_C { short v1; short v2; char v3; };
struct S_S_D { short v1; short v2; double v3; };
struct S_S_F { short v1; short v2; float v3; };
struct S_S_I { short v1; short v2; int v3; };
struct S_S_Ip { short v1; short v2; int * v3; };
struct S_S_L { short v1; short v2; long long v3; };
struct S_S_S { short v1; short v2; short v3; };
struct S_S_Uc { short v1; short v2; unsigned char v3; };
struct S_S_Ui { short v1; short v2; unsigned int v3; };
struct S_S_Ul { short v1; short v2; unsigned long long v3; };
struct S_S_Us { short v1; short v2; unsigned short v3; };
struct S_S_Vp { short v1; short v2; void * v3; };
struct S_Uc { short v1; unsigned char v2; };
struct S_Uc_BFu15i { short v1; unsigned char v2; unsigned int v3:15; };
struct S_Uc_BFu15ll { short v1; unsigned char v2; unsigned long long v3:15; };
struct S_Uc_BFu15s { short v1; unsigned char v2; unsigned short v3:15; };
struct S_Uc_BFu16i { short v1; unsigned char v2; unsigned int v3:16; };
struct S_Uc_BFu16ll { short v1; unsigned char v2; unsigned long long v3:16; };
struct S_Uc_BFu16s { short v1; unsigned char v2; unsigned short v3:16; };
struct S_Uc_BFu17i { short v1; unsigned char v2; unsigned int v3:17; };
struct S_Uc_BFu17ll { short v1; unsigned char v2; unsigned long long v3:17; };
struct S_Uc_BFu1c { short v1; unsigned char v2; unsigned char v3:1; };
struct S_Uc_BFu1i { short v1; unsigned char v2; unsigned int v3:1; };
struct S_Uc_BFu1ll { short v1; unsigned char v2; unsigned long long v3:1; };
struct S_Uc_BFu1s { short v1; unsigned char v2; unsigned short v3:1; };
struct S_Uc_BFu31i { short v1; unsigned char v2; unsigned int v3:31; };
struct S_Uc_BFu31ll { short v1; unsigned char v2; unsigned long long v3:31; };
struct S_Uc_BFu32i { short v1; unsigned char v2; unsigned int v3:32; };
struct S_Uc_BFu32ll { short v1; unsigned char v2; unsigned long long v3:32; };
struct S_Uc_BFu33 { short v1; unsigned char v2; unsigned long long v3:33; };
struct S_Uc_BFu7c { short v1; unsigned char v2; unsigned char v3:7; };
struct S_Uc_BFu7i { short v1; unsigned char v2; unsigned int v3:7; };
struct S_Uc_BFu7ll { short v1; unsigned char v2; unsigned long long v3:7; };
struct S_Uc_BFu7s { short v1; unsigned char v2; unsigned short v3:7; };
struct S_Uc_BFu8c { short v1; unsigned char v2; unsigned char v3:8; };
struct S_Uc_BFu8i { short v1; unsigned char v2; unsigned int v3:8; };
struct S_Uc_BFu8ll { short v1; unsigned char v2; unsigned long long v3:8; };
struct S_Uc_BFu8s { short v1; unsigned char v2; unsigned short v3:8; };
struct S_Uc_BFu9i { short v1; unsigned char v2; unsigned int v3:9; };
struct S_Uc_BFu9ll { short v1; unsigned char v2; unsigned long long v3:9; };
struct S_Uc_BFu9s { short v1; unsigned char v2; unsigned short v3:9; };
struct S_Uc_C { short v1; unsigned char v2; char v3; };
struct S_Uc_D { short v1; unsigned char v2; double v3; };
struct S_Uc_F { short v1; unsigned char v2; float v3; };
struct S_Uc_I { short v1; unsigned char v2; int v3; };
struct S_Uc_Ip { short v1; unsigned char v2; int * v3; };
struct S_Uc_L { short v1; unsigned char v2; long long v3; };
struct S_Uc_S { short v1; unsigned char v2; short v3; };
struct S_Uc_Uc { short v1; unsigned char v2; unsigned char v3; };
struct S_Uc_Ui { short v1; unsigned char v2; unsigned int v3; };
struct S_Uc_Ul { short v1; unsigned char v2; unsigned long long v3; };
struct S_Uc_Us { short v1; unsigned char v2; unsigned short v3; };
struct S_Uc_Vp { short v1; unsigned char v2; void * v3; };
struct S_Ui { short v1; unsigned int v2; };
struct S_Ui_BFu15i { short v1; unsigned int v2; unsigned int v3:15; };
struct S_Ui_BFu15ll { short v1; unsigned int v2; unsigned long long v3:15; };
struct S_Ui_BFu15s { short v1; unsigned int v2; unsigned short v3:15; };
struct S_Ui_BFu16i { short v1; unsigned int v2; unsigned int v3:16; };
struct S_Ui_BFu16ll { short v1; unsigned int v2; unsigned long long v3:16; };
struct S_Ui_BFu16s { short v1; unsigned int v2; unsigned short v3:16; };
struct S_Ui_BFu17i { short v1; unsigned int v2; unsigned int v3:17; };
struct S_Ui_BFu17ll { short v1; unsigned int v2; unsigned long long v3:17; };
struct S_Ui_BFu1c { short v1; unsigned int v2; unsigned char v3:1; };
struct S_Ui_BFu1i { short v1; unsigned int v2; unsigned int v3:1; };
struct S_Ui_BFu1ll { short v1; unsigned int v2; unsigned long long v3:1; };
struct S_Ui_BFu1s { short v1; unsigned int v2; unsigned short v3:1; };
struct S_Ui_BFu31i { short v1; unsigned int v2; unsigned int v3:31; };
struct S_Ui_BFu31ll { short v1; unsigned int v2; unsigned long long v3:31; };
struct S_Ui_BFu32i { short v1; unsigned int v2; unsigned int v3:32; };
struct S_Ui_BFu32ll { short v1; unsigned int v2; unsigned long long v3:32; };
struct S_Ui_BFu33 { short v1; unsigned int v2; unsigned long long v3:33; };
struct S_Ui_BFu7c { short v1; unsigned int v2; unsigned char v3:7; };
struct S_Ui_BFu7i { short v1; unsigned int v2; unsigned int v3:7; };
struct S_Ui_BFu7ll { short v1; unsigned int v2; unsigned long long v3:7; };
struct S_Ui_BFu7s { short v1; unsigned int v2; unsigned short v3:7; };
struct S_Ui_BFu8c { short v1; unsigned int v2; unsigned char v3:8; };
struct S_Ui_BFu8i { short v1; unsigned int v2; unsigned int v3:8; };
struct S_Ui_BFu8ll { short v1; unsigned int v2; unsigned long long v3:8; };
struct S_Ui_BFu8s { short v1; unsigned int v2; unsigned short v3:8; };
struct S_Ui_BFu9i { short v1; unsigned int v2; unsigned int v3:9; };
struct S_Ui_BFu9ll { short v1; unsigned int v2; unsigned long long v3:9; };
struct S_Ui_BFu9s { short v1; unsigned int v2; unsigned short v3:9; };
struct S_Ui_C { short v1; unsigned int v2; char v3; };
struct S_Ui_D { short v1; unsigned int v2; double v3; };
struct S_Ui_F { short v1; unsigned int v2; float v3; };
struct S_Ui_I { short v1; unsigned int v2; int v3; };
struct S_Ui_Ip { short v1; unsigned int v2; int * v3; };
struct S_Ui_L { short v1; unsigned int v2; long long v3; };
struct S_Ui_S { short v1; unsigned int v2; short v3; };
struct S_Ui_Uc { short v1; unsigned int v2; unsigned char v3; };
struct S_Ui_Ui { short v1; unsigned int v2; unsigned int v3; };
struct S_Ui_Ul { short v1; unsigned int v2; unsigned long long v3; };
struct S_Ui_Us { short v1; unsigned int v2; unsigned short v3; };
struct S_Ui_Vp { short v1; unsigned int v2; void * v3; };
struct S_Ul { short v1; unsigned long long v2; };
struct S_Ul_BFu15i { short v1; unsigned long long v2; unsigned int v3:15; };
struct S_Ul_BFu15ll { short v1; unsigned long long v2; unsigned long long v3:15; };
struct S_Ul_BFu15s { short v1; unsigned long long v2; unsigned short v3:15; };
struct S_Ul_BFu16i { short v1; unsigned long long v2; unsigned int v3:16; };
struct S_Ul_BFu16ll { short v1; unsigned long long v2; unsigned long long v3:16; };
struct S_Ul_BFu16s { short v1; unsigned long long v2; unsigned short v3:16; };
struct S_Ul_BFu17i { short v1; unsigned long long v2; unsigned int v3:17; };
struct S_Ul_BFu17ll { short v1; unsigned long long v2; unsigned long long v3:17; };
struct S_Ul_BFu1c { short v1; unsigned long long v2; unsigned char v3:1; };
struct S_Ul_BFu1i { short v1; unsigned long long v2; unsigned int v3:1; };
struct S_Ul_BFu1ll { short v1; unsigned long long v2; unsigned long long v3:1; };
struct S_Ul_BFu1s { short v1; unsigned long long v2; unsigned short v3:1; };
struct S_Ul_BFu31i { short v1; unsigned long long v2; unsigned int v3:31; };
struct S_Ul_BFu31ll { short v1; unsigned long long v2; unsigned long long v3:31; };
struct S_Ul_BFu32i { short v1; unsigned long long v2; unsigned int v3:32; };
struct S_Ul_BFu32ll { short v1; unsigned long long v2; unsigned long long v3:32; };
struct S_Ul_BFu33 { short v1; unsigned long long v2; unsigned long long v3:33; };
struct S_Ul_BFu7c { short v1; unsigned long long v2; unsigned char v3:7; };
struct S_Ul_BFu7i { short v1; unsigned long long v2; unsigned int v3:7; };
struct S_Ul_BFu7ll { short v1; unsigned long long v2; unsigned long long v3:7; };
struct S_Ul_BFu7s { short v1; unsigned long long v2; unsigned short v3:7; };
struct S_Ul_BFu8c { short v1; unsigned long long v2; unsigned char v3:8; };
struct S_Ul_BFu8i { short v1; unsigned long long v2; unsigned int v3:8; };
struct S_Ul_BFu8ll { short v1; unsigned long long v2; unsigned long long v3:8; };
struct S_Ul_BFu8s { short v1; unsigned long long v2; unsigned short v3:8; };
struct S_Ul_BFu9i { short v1; unsigned long long v2; unsigned int v3:9; };
struct S_Ul_BFu9ll { short v1; unsigned long long v2; unsigned long long v3:9; };
struct S_Ul_BFu9s { short v1; unsigned long long v2; unsigned short v3:9; };
struct S_Ul_C { short v1; unsigned long long v2; char v3; };
struct S_Ul_D { short v1; unsigned long long v2; double v3; };
struct S_Ul_F { short v1; unsigned long long v2; float v3; };
struct S_Ul_I { short v1; unsigned long long v2; int v3; };
struct S_Ul_Ip { short v1; unsigned long long v2; int * v3; };
struct S_Ul_L { short v1; unsigned long long v2; long long v3; };
struct S_Ul_S { short v1; unsigned long long v2; short v3; };
struct S_Ul_Uc { short v1; unsigned long long v2; unsigned char v3; };
struct S_Ul_Ui { short v1; unsigned long long v2; unsigned int v3; };
struct S_Ul_Ul { short v1; unsigned long long v2; unsigned long long v3; };
struct S_Ul_Us { short v1; unsigned long long v2; unsigned short v3; };
struct S_Ul_Vp { short v1; unsigned long long v2; void * v3; };
struct S_Us { short v1; unsigned short v2; };
struct S_Us_BFu15i { short v1; unsigned short v2; unsigned int v3:15; };
struct S_Us_BFu15ll { short v1; unsigned short v2; unsigned long long v3:15; };
struct S_Us_BFu15s { short v1; unsigned short v2; unsigned short v3:15; };
struct S_Us_BFu16i { short v1; unsigned short v2; unsigned int v3:16; };
struct S_Us_BFu16ll { short v1; unsigned short v2; unsigned long long v3:16; };
struct S_Us_BFu16s { short v1; unsigned short v2; unsigned short v3:16; };
struct S_Us_BFu17i { short v1; unsigned short v2; unsigned int v3:17; };
struct S_Us_BFu17ll { short v1; unsigned short v2; unsigned long long v3:17; };
struct S_Us_BFu1c { short v1; unsigned short v2; unsigned char v3:1; };
struct S_Us_BFu1i { short v1; unsigned short v2; unsigned int v3:1; };
struct S_Us_BFu1ll { short v1; unsigned short v2; unsigned long long v3:1; };
struct S_Us_BFu1s { short v1; unsigned short v2; unsigned short v3:1; };
struct S_Us_BFu31i { short v1; unsigned short v2; unsigned int v3:31; };
struct S_Us_BFu31ll { short v1; unsigned short v2; unsigned long long v3:31; };
struct S_Us_BFu32i { short v1; unsigned short v2; unsigned int v3:32; };
struct S_Us_BFu32ll { short v1; unsigned short v2; unsigned long long v3:32; };
struct S_Us_BFu33 { short v1; unsigned short v2; unsigned long long v3:33; };
struct S_Us_BFu7c { short v1; unsigned short v2; unsigned char v3:7; };
struct S_Us_BFu7i { short v1; unsigned short v2; unsigned int v3:7; };
struct S_Us_BFu7ll { short v1; unsigned short v2; unsigned long long v3:7; };
struct S_Us_BFu7s { short v1; unsigned short v2; unsigned short v3:7; };
struct S_Us_BFu8c { short v1; unsigned short v2; unsigned char v3:8; };
struct S_Us_BFu8i { short v1; unsigned short v2; unsigned int v3:8; };
struct S_Us_BFu8ll { short v1; unsigned short v2; unsigned long long v3:8; };
struct S_Us_BFu8s { short v1; unsigned short v2; unsigned short v3:8; };
struct S_Us_BFu9i { short v1; unsigned short v2; unsigned int v3:9; };
struct S_Us_BFu9ll { short v1; unsigned short v2; unsigned long long v3:9; };
struct S_Us_BFu9s { short v1; unsigned short v2; unsigned short v3:9; };
struct S_Us_C { short v1; unsigned short v2; char v3; };
struct S_Us_D { short v1; unsigned short v2; double v3; };
struct S_Us_F { short v1; unsigned short v2; float v3; };
struct S_Us_I { short v1; unsigned short v2; int v3; };
struct S_Us_Ip { short v1; unsigned short v2; int * v3; };
struct S_Us_L { short v1; unsigned short v2; long long v3; };
struct S_Us_S { short v1; unsigned short v2; short v3; };
struct S_Us_Uc { short v1; unsigned short v2; unsigned char v3; };
struct S_Us_Ui { short v1; unsigned short v2; unsigned int v3; };
struct S_Us_Ul { short v1; unsigned short v2; unsigned long long v3; };
struct S_Us_Us { short v1; unsigned short v2; unsigned short v3; };
struct S_Us_Vp { short v1; unsigned short v2; void * v3; };
struct S_Vp { short v1; void * v2; };
struct S_Vp_BFu15i { short v1; void * v2; unsigned int v3:15; };
struct S_Vp_BFu15ll { short v1; void * v2; unsigned long long v3:15; };
struct S_Vp_BFu15s { short v1; void * v2; unsigned short v3:15; };
struct S_Vp_BFu16i { short v1; void * v2; unsigned int v3:16; };
struct S_Vp_BFu16ll { short v1; void * v2; unsigned long long v3:16; };
struct S_Vp_BFu16s { short v1; void * v2; unsigned short v3:16; };
struct S_Vp_BFu17i { short v1; void * v2; unsigned int v3:17; };
struct S_Vp_BFu17ll { short v1; void * v2; unsigned long long v3:17; };
struct S_Vp_BFu1c { short v1; void * v2; unsigned char v3:1; };
struct S_Vp_BFu1i { short v1; void * v2; unsigned int v3:1; };
struct S_Vp_BFu1ll { short v1; void * v2; unsigned long long v3:1; };
struct S_Vp_BFu1s { short v1; void * v2; unsigned short v3:1; };
struct S_Vp_BFu31i { short v1; void * v2; unsigned int v3:31; };
struct S_Vp_BFu31ll { short v1; void * v2; unsigned long long v3:31; };
struct S_Vp_BFu32i { short v1; void * v2; unsigned int v3:32; };
struct S_Vp_BFu32ll { short v1; void * v2; unsigned long long v3:32; };
struct S_Vp_BFu33 { short v1; void * v2; unsigned long long v3:33; };
struct S_Vp_BFu7c { short v1; void * v2; unsigned char v3:7; };
struct S_Vp_BFu7i { short v1; void * v2; unsigned int v3:7; };
struct S_Vp_BFu7ll { short v1; void * v2; unsigned long long v3:7; };
struct S_Vp_BFu7s { short v1; void * v2; unsigned short v3:7; };
struct S_Vp_BFu8c { short v1; void * v2; unsigned char v3:8; };
struct S_Vp_BFu8i { short v1; void * v2; unsigned int v3:8; };
struct S_Vp_BFu8ll { short v1; void * v2; unsigned long long v3:8; };
struct S_Vp_BFu8s { short v1; void * v2; unsigned short v3:8; };
struct S_Vp_BFu9i { short v1; void * v2; unsigned int v3:9; };
struct S_Vp_BFu9ll { short v1; void * v2; unsigned long long v3:9; };
struct S_Vp_BFu9s { short v1; void * v2; unsigned short v3:9; };
struct S_Vp_C { short v1; void * v2; char v3; };
struct S_Vp_D { short v1; void * v2; double v3; };
struct S_Vp_F { short v1; void * v2; float v3; };
struct S_Vp_I { short v1; void * v2; int v3; };
struct S_Vp_Ip { short v1; void * v2; int * v3; };
struct S_Vp_L { short v1; void * v2; long long v3; };
struct S_Vp_S { short v1; void * v2; short v3; };
struct S_Vp_Uc { short v1; void * v2; unsigned char v3; };
struct S_Vp_Ui { short v1; void * v2; unsigned int v3; };
struct S_Vp_Ul { short v1; void * v2; unsigned long long v3; };
struct S_Vp_Us { short v1; void * v2; unsigned short v3; };
struct S_Vp_Vp { short v1; void * v2; void * v3; };
struct Uc { unsigned char v1; };
struct Uc_BFu15i { unsigned char v1; unsigned int v2:15; };
struct Uc_BFu15i_BFu15i { unsigned char v1; unsigned int v2:15; unsigned int v3:15; };
struct Uc_BFu15i_BFu15ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:15; };
struct Uc_BFu15i_BFu15s { unsigned char v1; unsigned int v2:15; unsigned short v3:15; };
struct Uc_BFu15i_BFu16i { unsigned char v1; unsigned int v2:15; unsigned int v3:16; };
struct Uc_BFu15i_BFu16ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:16; };
struct Uc_BFu15i_BFu16s { unsigned char v1; unsigned int v2:15; unsigned short v3:16; };
struct Uc_BFu15i_BFu17i { unsigned char v1; unsigned int v2:15; unsigned int v3:17; };
struct Uc_BFu15i_BFu17ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:17; };
struct Uc_BFu15i_BFu1c { unsigned char v1; unsigned int v2:15; unsigned char v3:1; };
struct Uc_BFu15i_BFu1i { unsigned char v1; unsigned int v2:15; unsigned int v3:1; };
struct Uc_BFu15i_BFu1ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:1; };
struct Uc_BFu15i_BFu1s { unsigned char v1; unsigned int v2:15; unsigned short v3:1; };
struct Uc_BFu15i_BFu31i { unsigned char v1; unsigned int v2:15; unsigned int v3:31; };
struct Uc_BFu15i_BFu31ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:31; };
struct Uc_BFu15i_BFu32i { unsigned char v1; unsigned int v2:15; unsigned int v3:32; };
struct Uc_BFu15i_BFu32ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:32; };
struct Uc_BFu15i_BFu33 { unsigned char v1; unsigned int v2:15; unsigned long long v3:33; };
struct Uc_BFu15i_BFu7c { unsigned char v1; unsigned int v2:15; unsigned char v3:7; };
struct Uc_BFu15i_BFu7i { unsigned char v1; unsigned int v2:15; unsigned int v3:7; };
struct Uc_BFu15i_BFu7ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:7; };
struct Uc_BFu15i_BFu7s { unsigned char v1; unsigned int v2:15; unsigned short v3:7; };
struct Uc_BFu15i_BFu8c { unsigned char v1; unsigned int v2:15; unsigned char v3:8; };
struct Uc_BFu15i_BFu8i { unsigned char v1; unsigned int v2:15; unsigned int v3:8; };
struct Uc_BFu15i_BFu8ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:8; };
struct Uc_BFu15i_BFu8s { unsigned char v1; unsigned int v2:15; unsigned short v3:8; };
struct Uc_BFu15i_BFu9i { unsigned char v1; unsigned int v2:15; unsigned int v3:9; };
struct Uc_BFu15i_BFu9ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:9; };
struct Uc_BFu15i_BFu9s { unsigned char v1; unsigned int v2:15; unsigned short v3:9; };
struct Uc_BFu15i_C { unsigned char v1; unsigned int v2:15; char v3; };
struct Uc_BFu15i_D { unsigned char v1; unsigned int v2:15; double v3; };
struct Uc_BFu15i_F { unsigned char v1; unsigned int v2:15; float v3; };
struct Uc_BFu15i_I { unsigned char v1; unsigned int v2:15; int v3; };
struct Uc_BFu15i_Ip { unsigned char v1; unsigned int v2:15; int * v3; };
struct Uc_BFu15i_L { unsigned char v1; unsigned int v2:15; long long v3; };
struct Uc_BFu15i_S { unsigned char v1; unsigned int v2:15; short v3; };
struct Uc_BFu15i_Uc { unsigned char v1; unsigned int v2:15; unsigned char v3; };
struct Uc_BFu15i_Ui { unsigned char v1; unsigned int v2:15; unsigned int v3; };
struct Uc_BFu15i_Ul { unsigned char v1; unsigned int v2:15; unsigned long long v3; };
struct Uc_BFu15i_Us { unsigned char v1; unsigned int v2:15; unsigned short v3; };
struct Uc_BFu15i_Vp { unsigned char v1; unsigned int v2:15; void * v3; };
struct Uc_BFu15ll { unsigned char v1; unsigned long long v2:15; };
struct Uc_BFu15ll_BFu15i { unsigned char v1; unsigned long long v2:15; unsigned int v3:15; };
struct Uc_BFu15ll_BFu15ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:15; };
struct Uc_BFu15ll_BFu15s { unsigned char v1; unsigned long long v2:15; unsigned short v3:15; };
struct Uc_BFu15ll_BFu16i { unsigned char v1; unsigned long long v2:15; unsigned int v3:16; };
struct Uc_BFu15ll_BFu16ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:16; };
struct Uc_BFu15ll_BFu16s { unsigned char v1; unsigned long long v2:15; unsigned short v3:16; };
struct Uc_BFu15ll_BFu17i { unsigned char v1; unsigned long long v2:15; unsigned int v3:17; };
struct Uc_BFu15ll_BFu17ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:17; };
struct Uc_BFu15ll_BFu1c { unsigned char v1; unsigned long long v2:15; unsigned char v3:1; };
struct Uc_BFu15ll_BFu1i { unsigned char v1; unsigned long long v2:15; unsigned int v3:1; };
struct Uc_BFu15ll_BFu1ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:1; };
struct Uc_BFu15ll_BFu1s { unsigned char v1; unsigned long long v2:15; unsigned short v3:1; };
struct Uc_BFu15ll_BFu31i { unsigned char v1; unsigned long long v2:15; unsigned int v3:31; };
struct Uc_BFu15ll_BFu31ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:31; };
struct Uc_BFu15ll_BFu32i { unsigned char v1; unsigned long long v2:15; unsigned int v3:32; };
struct Uc_BFu15ll_BFu32ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:32; };
struct Uc_BFu15ll_BFu33 { unsigned char v1; unsigned long long v2:15; unsigned long long v3:33; };
struct Uc_BFu15ll_BFu7c { unsigned char v1; unsigned long long v2:15; unsigned char v3:7; };
struct Uc_BFu15ll_BFu7i { unsigned char v1; unsigned long long v2:15; unsigned int v3:7; };
struct Uc_BFu15ll_BFu7ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:7; };
struct Uc_BFu15ll_BFu7s { unsigned char v1; unsigned long long v2:15; unsigned short v3:7; };
struct Uc_BFu15ll_BFu8c { unsigned char v1; unsigned long long v2:15; unsigned char v3:8; };
struct Uc_BFu15ll_BFu8i { unsigned char v1; unsigned long long v2:15; unsigned int v3:8; };
struct Uc_BFu15ll_BFu8ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:8; };
struct Uc_BFu15ll_BFu8s { unsigned char v1; unsigned long long v2:15; unsigned short v3:8; };
struct Uc_BFu15ll_BFu9i { unsigned char v1; unsigned long long v2:15; unsigned int v3:9; };
struct Uc_BFu15ll_BFu9ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:9; };
struct Uc_BFu15ll_BFu9s { unsigned char v1; unsigned long long v2:15; unsigned short v3:9; };
struct Uc_BFu15ll_C { unsigned char v1; unsigned long long v2:15; char v3; };
struct Uc_BFu15ll_D { unsigned char v1; unsigned long long v2:15; double v3; };
struct Uc_BFu15ll_F { unsigned char v1; unsigned long long v2:15; float v3; };
struct Uc_BFu15ll_I { unsigned char v1; unsigned long long v2:15; int v3; };
struct Uc_BFu15ll_Ip { unsigned char v1; unsigned long long v2:15; int * v3; };
struct Uc_BFu15ll_L { unsigned char v1; unsigned long long v2:15; long long v3; };
struct Uc_BFu15ll_S { unsigned char v1; unsigned long long v2:15; short v3; };
struct Uc_BFu15ll_Uc { unsigned char v1; unsigned long long v2:15; unsigned char v3; };
struct Uc_BFu15ll_Ui { unsigned char v1; unsigned long long v2:15; unsigned int v3; };
struct Uc_BFu15ll_Ul { unsigned char v1; unsigned long long v2:15; unsigned long long v3; };
struct Uc_BFu15ll_Us { unsigned char v1; unsigned long long v2:15; unsigned short v3; };
struct Uc_BFu15ll_Vp { unsigned char v1; unsigned long long v2:15; void * v3; };
struct Uc_BFu15s { unsigned char v1; unsigned short v2:15; };
struct Uc_BFu15s_BFu15i { unsigned char v1; unsigned short v2:15; unsigned int v3:15; };
struct Uc_BFu15s_BFu15ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:15; };
struct Uc_BFu15s_BFu15s { unsigned char v1; unsigned short v2:15; unsigned short v3:15; };
struct Uc_BFu15s_BFu16i { unsigned char v1; unsigned short v2:15; unsigned int v3:16; };
struct Uc_BFu15s_BFu16ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:16; };
struct Uc_BFu15s_BFu16s { unsigned char v1; unsigned short v2:15; unsigned short v3:16; };
struct Uc_BFu15s_BFu17i { unsigned char v1; unsigned short v2:15; unsigned int v3:17; };
struct Uc_BFu15s_BFu17ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:17; };
struct Uc_BFu15s_BFu1c { unsigned char v1; unsigned short v2:15; unsigned char v3:1; };
struct Uc_BFu15s_BFu1i { unsigned char v1; unsigned short v2:15; unsigned int v3:1; };
struct Uc_BFu15s_BFu1ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:1; };
struct Uc_BFu15s_BFu1s { unsigned char v1; unsigned short v2:15; unsigned short v3:1; };
struct Uc_BFu15s_BFu31i { unsigned char v1; unsigned short v2:15; unsigned int v3:31; };
struct Uc_BFu15s_BFu31ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:31; };
struct Uc_BFu15s_BFu32i { unsigned char v1; unsigned short v2:15; unsigned int v3:32; };
struct Uc_BFu15s_BFu32ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:32; };
struct Uc_BFu15s_BFu33 { unsigned char v1; unsigned short v2:15; unsigned long long v3:33; };
struct Uc_BFu15s_BFu7c { unsigned char v1; unsigned short v2:15; unsigned char v3:7; };
struct Uc_BFu15s_BFu7i { unsigned char v1; unsigned short v2:15; unsigned int v3:7; };
struct Uc_BFu15s_BFu7ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:7; };
struct Uc_BFu15s_BFu7s { unsigned char v1; unsigned short v2:15; unsigned short v3:7; };
struct Uc_BFu15s_BFu8c { unsigned char v1; unsigned short v2:15; unsigned char v3:8; };
struct Uc_BFu15s_BFu8i { unsigned char v1; unsigned short v2:15; unsigned int v3:8; };
struct Uc_BFu15s_BFu8ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:8; };
struct Uc_BFu15s_BFu8s { unsigned char v1; unsigned short v2:15; unsigned short v3:8; };
struct Uc_BFu15s_BFu9i { unsigned char v1; unsigned short v2:15; unsigned int v3:9; };
struct Uc_BFu15s_BFu9ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:9; };
struct Uc_BFu15s_BFu9s { unsigned char v1; unsigned short v2:15; unsigned short v3:9; };
struct Uc_BFu15s_C { unsigned char v1; unsigned short v2:15; char v3; };
struct Uc_BFu15s_D { unsigned char v1; unsigned short v2:15; double v3; };
struct Uc_BFu15s_F { unsigned char v1; unsigned short v2:15; float v3; };
struct Uc_BFu15s_I { unsigned char v1; unsigned short v2:15; int v3; };
struct Uc_BFu15s_Ip { unsigned char v1; unsigned short v2:15; int * v3; };
struct Uc_BFu15s_L { unsigned char v1; unsigned short v2:15; long long v3; };
struct Uc_BFu15s_S { unsigned char v1; unsigned short v2:15; short v3; };
struct Uc_BFu15s_Uc { unsigned char v1; unsigned short v2:15; unsigned char v3; };
struct Uc_BFu15s_Ui { unsigned char v1; unsigned short v2:15; unsigned int v3; };
struct Uc_BFu15s_Ul { unsigned char v1; unsigned short v2:15; unsigned long long v3; };
struct Uc_BFu15s_Us { unsigned char v1; unsigned short v2:15; unsigned short v3; };
struct Uc_BFu15s_Vp { unsigned char v1; unsigned short v2:15; void * v3; };
struct Uc_BFu16i { unsigned char v1; unsigned int v2:16; };
struct Uc_BFu16i_BFu15i { unsigned char v1; unsigned int v2:16; unsigned int v3:15; };
struct Uc_BFu16i_BFu15ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:15; };
struct Uc_BFu16i_BFu15s { unsigned char v1; unsigned int v2:16; unsigned short v3:15; };
struct Uc_BFu16i_BFu16i { unsigned char v1; unsigned int v2:16; unsigned int v3:16; };
struct Uc_BFu16i_BFu16ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:16; };
struct Uc_BFu16i_BFu16s { unsigned char v1; unsigned int v2:16; unsigned short v3:16; };
struct Uc_BFu16i_BFu17i { unsigned char v1; unsigned int v2:16; unsigned int v3:17; };
struct Uc_BFu16i_BFu17ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:17; };
struct Uc_BFu16i_BFu1c { unsigned char v1; unsigned int v2:16; unsigned char v3:1; };
struct Uc_BFu16i_BFu1i { unsigned char v1; unsigned int v2:16; unsigned int v3:1; };
struct Uc_BFu16i_BFu1ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:1; };
struct Uc_BFu16i_BFu1s { unsigned char v1; unsigned int v2:16; unsigned short v3:1; };
struct Uc_BFu16i_BFu31i { unsigned char v1; unsigned int v2:16; unsigned int v3:31; };
struct Uc_BFu16i_BFu31ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:31; };
struct Uc_BFu16i_BFu32i { unsigned char v1; unsigned int v2:16; unsigned int v3:32; };
struct Uc_BFu16i_BFu32ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:32; };
struct Uc_BFu16i_BFu33 { unsigned char v1; unsigned int v2:16; unsigned long long v3:33; };
struct Uc_BFu16i_BFu7c { unsigned char v1; unsigned int v2:16; unsigned char v3:7; };
struct Uc_BFu16i_BFu7i { unsigned char v1; unsigned int v2:16; unsigned int v3:7; };
struct Uc_BFu16i_BFu7ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:7; };
struct Uc_BFu16i_BFu7s { unsigned char v1; unsigned int v2:16; unsigned short v3:7; };
struct Uc_BFu16i_BFu8c { unsigned char v1; unsigned int v2:16; unsigned char v3:8; };
struct Uc_BFu16i_BFu8i { unsigned char v1; unsigned int v2:16; unsigned int v3:8; };
struct Uc_BFu16i_BFu8ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:8; };
struct Uc_BFu16i_BFu8s { unsigned char v1; unsigned int v2:16; unsigned short v3:8; };
struct Uc_BFu16i_BFu9i { unsigned char v1; unsigned int v2:16; unsigned int v3:9; };
struct Uc_BFu16i_BFu9ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:9; };
struct Uc_BFu16i_BFu9s { unsigned char v1; unsigned int v2:16; unsigned short v3:9; };
struct Uc_BFu16i_C { unsigned char v1; unsigned int v2:16; char v3; };
struct Uc_BFu16i_D { unsigned char v1; unsigned int v2:16; double v3; };
struct Uc_BFu16i_F { unsigned char v1; unsigned int v2:16; float v3; };
struct Uc_BFu16i_I { unsigned char v1; unsigned int v2:16; int v3; };
struct Uc_BFu16i_Ip { unsigned char v1; unsigned int v2:16; int * v3; };
struct Uc_BFu16i_L { unsigned char v1; unsigned int v2:16; long long v3; };
struct Uc_BFu16i_S { unsigned char v1; unsigned int v2:16; short v3; };
struct Uc_BFu16i_Uc { unsigned char v1; unsigned int v2:16; unsigned char v3; };
struct Uc_BFu16i_Ui { unsigned char v1; unsigned int v2:16; unsigned int v3; };
struct Uc_BFu16i_Ul { unsigned char v1; unsigned int v2:16; unsigned long long v3; };
struct Uc_BFu16i_Us { unsigned char v1; unsigned int v2:16; unsigned short v3; };
struct Uc_BFu16i_Vp { unsigned char v1; unsigned int v2:16; void * v3; };
struct Uc_BFu16ll { unsigned char v1; unsigned long long v2:16; };
struct Uc_BFu16ll_BFu15i { unsigned char v1; unsigned long long v2:16; unsigned int v3:15; };
struct Uc_BFu16ll_BFu15ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:15; };
struct Uc_BFu16ll_BFu15s { unsigned char v1; unsigned long long v2:16; unsigned short v3:15; };
struct Uc_BFu16ll_BFu16i { unsigned char v1; unsigned long long v2:16; unsigned int v3:16; };
struct Uc_BFu16ll_BFu16ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:16; };
struct Uc_BFu16ll_BFu16s { unsigned char v1; unsigned long long v2:16; unsigned short v3:16; };
struct Uc_BFu16ll_BFu17i { unsigned char v1; unsigned long long v2:16; unsigned int v3:17; };
struct Uc_BFu16ll_BFu17ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:17; };
struct Uc_BFu16ll_BFu1c { unsigned char v1; unsigned long long v2:16; unsigned char v3:1; };
struct Uc_BFu16ll_BFu1i { unsigned char v1; unsigned long long v2:16; unsigned int v3:1; };
struct Uc_BFu16ll_BFu1ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:1; };
struct Uc_BFu16ll_BFu1s { unsigned char v1; unsigned long long v2:16; unsigned short v3:1; };
struct Uc_BFu16ll_BFu31i { unsigned char v1; unsigned long long v2:16; unsigned int v3:31; };
struct Uc_BFu16ll_BFu31ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:31; };
struct Uc_BFu16ll_BFu32i { unsigned char v1; unsigned long long v2:16; unsigned int v3:32; };
struct Uc_BFu16ll_BFu32ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:32; };
struct Uc_BFu16ll_BFu33 { unsigned char v1; unsigned long long v2:16; unsigned long long v3:33; };
struct Uc_BFu16ll_BFu7c { unsigned char v1; unsigned long long v2:16; unsigned char v3:7; };
struct Uc_BFu16ll_BFu7i { unsigned char v1; unsigned long long v2:16; unsigned int v3:7; };
struct Uc_BFu16ll_BFu7ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:7; };
struct Uc_BFu16ll_BFu7s { unsigned char v1; unsigned long long v2:16; unsigned short v3:7; };
struct Uc_BFu16ll_BFu8c { unsigned char v1; unsigned long long v2:16; unsigned char v3:8; };
struct Uc_BFu16ll_BFu8i { unsigned char v1; unsigned long long v2:16; unsigned int v3:8; };
struct Uc_BFu16ll_BFu8ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:8; };
struct Uc_BFu16ll_BFu8s { unsigned char v1; unsigned long long v2:16; unsigned short v3:8; };
struct Uc_BFu16ll_BFu9i { unsigned char v1; unsigned long long v2:16; unsigned int v3:9; };
struct Uc_BFu16ll_BFu9ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:9; };


static void Test_L_BFu1s_BFu8i()
{
  {
    init_simple_test("L_BFu1s_BFu8i");
    static STRUCT_IF_C L_BFu1s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "L_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "L_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_BFu8i, L_BFu1s_BFu8i)
//============================================================================



static void Test_L_BFu1s_BFu8ll()
{
  {
    init_simple_test("L_BFu1s_BFu8ll");
    static STRUCT_IF_C L_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "L_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "L_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_BFu8ll, L_BFu1s_BFu8ll)
//============================================================================



static void Test_L_BFu1s_BFu8s()
{
  {
    init_simple_test("L_BFu1s_BFu8s");
    static STRUCT_IF_C L_BFu1s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "L_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "L_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_BFu8s, L_BFu1s_BFu8s)
//============================================================================



static void Test_L_BFu1s_BFu9i()
{
  {
    init_simple_test("L_BFu1s_BFu9i");
    static STRUCT_IF_C L_BFu1s_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "L_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "L_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_BFu9i, L_BFu1s_BFu9i)
//============================================================================



static void Test_L_BFu1s_BFu9ll()
{
  {
    init_simple_test("L_BFu1s_BFu9ll");
    static STRUCT_IF_C L_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "L_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "L_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_BFu9ll, L_BFu1s_BFu9ll)
//============================================================================



static void Test_L_BFu1s_BFu9s()
{
  {
    init_simple_test("L_BFu1s_BFu9s");
    static STRUCT_IF_C L_BFu1s_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "L_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "L_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_BFu9s, L_BFu1s_BFu9s)
//============================================================================



static void Test_L_BFu1s_C()
{
  {
    init_simple_test("L_BFu1s_C");
    static STRUCT_IF_C L_BFu1s_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_C)");
    check_field_offset(lv, v1, 0, "L_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_C");
    check_field_offset(lv, v3, 9, "L_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_C, L_BFu1s_C)
//============================================================================



static void Test_L_BFu1s_D()
{
  {
    init_simple_test("L_BFu1s_D");
    static STRUCT_IF_C L_BFu1s_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_D)");
    check_field_offset(lv, v1, 0, "L_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_D");
    check_field_offset(lv, v3, 9, "L_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_D, L_BFu1s_D)
//============================================================================



static void Test_L_BFu1s_F()
{
  {
    init_simple_test("L_BFu1s_F");
    static STRUCT_IF_C L_BFu1s_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_F)");
    check_field_offset(lv, v1, 0, "L_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_F");
    check_field_offset(lv, v3, 9, "L_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_F, L_BFu1s_F)
//============================================================================



static void Test_L_BFu1s_I()
{
  {
    init_simple_test("L_BFu1s_I");
    static STRUCT_IF_C L_BFu1s_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_I)");
    check_field_offset(lv, v1, 0, "L_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_I");
    check_field_offset(lv, v3, 9, "L_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_I, L_BFu1s_I)
//============================================================================



static void Test_L_BFu1s_Ip()
{
  {
    init_simple_test("L_BFu1s_Ip");
    static STRUCT_IF_C L_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_Ip");
    check_field_offset(lv, v3, 9, "L_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_Ip, L_BFu1s_Ip)
//============================================================================



static void Test_L_BFu1s_L()
{
  {
    init_simple_test("L_BFu1s_L");
    static STRUCT_IF_C L_BFu1s_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_L)");
    check_field_offset(lv, v1, 0, "L_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_L");
    check_field_offset(lv, v3, 9, "L_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_L, L_BFu1s_L)
//============================================================================



static void Test_L_BFu1s_S()
{
  {
    init_simple_test("L_BFu1s_S");
    static STRUCT_IF_C L_BFu1s_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_S)");
    check_field_offset(lv, v1, 0, "L_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_S");
    check_field_offset(lv, v3, 9, "L_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_S, L_BFu1s_S)
//============================================================================



static void Test_L_BFu1s_Uc()
{
  {
    init_simple_test("L_BFu1s_Uc");
    static STRUCT_IF_C L_BFu1s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_Uc");
    check_field_offset(lv, v3, 9, "L_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_Uc, L_BFu1s_Uc)
//============================================================================



static void Test_L_BFu1s_Ui()
{
  {
    init_simple_test("L_BFu1s_Ui");
    static STRUCT_IF_C L_BFu1s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_Ui");
    check_field_offset(lv, v3, 9, "L_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_Ui, L_BFu1s_Ui)
//============================================================================



static void Test_L_BFu1s_Ul()
{
  {
    init_simple_test("L_BFu1s_Ul");
    static STRUCT_IF_C L_BFu1s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_Ul");
    check_field_offset(lv, v3, 9, "L_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_Ul, L_BFu1s_Ul)
//============================================================================



static void Test_L_BFu1s_Us()
{
  {
    init_simple_test("L_BFu1s_Us");
    static STRUCT_IF_C L_BFu1s_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "L_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_Us");
    check_field_offset(lv, v3, 9, "L_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_Us, L_BFu1s_Us)
//============================================================================



static void Test_L_BFu1s_Vp()
{
  {
    init_simple_test("L_BFu1s_Vp");
    static STRUCT_IF_C L_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "L_BFu1s_Vp");
    check_field_offset(lv, v3, 9, "L_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu1s_Vp, L_BFu1s_Vp)
//============================================================================



static void Test_L_BFu31i()
{
  {
    init_simple_test("L_BFu31i");
    static STRUCT_IF_C L_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i, L_BFu31i)
//============================================================================



static void Test_L_BFu31i_BFu15i()
{
  {
    init_simple_test("L_BFu31i_BFu15i");
    static STRUCT_IF_C L_BFu31i_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "L_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "L_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu15i, L_BFu31i_BFu15i)
//============================================================================



static void Test_L_BFu31i_BFu15ll()
{
  {
    init_simple_test("L_BFu31i_BFu15ll");
    static STRUCT_IF_C L_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "L_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "L_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu15ll, L_BFu31i_BFu15ll)
//============================================================================



static void Test_L_BFu31i_BFu15s()
{
  {
    init_simple_test("L_BFu31i_BFu15s");
    static STRUCT_IF_C L_BFu31i_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "L_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "L_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu15s, L_BFu31i_BFu15s)
//============================================================================



static void Test_L_BFu31i_BFu16i()
{
  {
    init_simple_test("L_BFu31i_BFu16i");
    static STRUCT_IF_C L_BFu31i_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "L_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "L_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu16i, L_BFu31i_BFu16i)
//============================================================================



static void Test_L_BFu31i_BFu16ll()
{
  {
    init_simple_test("L_BFu31i_BFu16ll");
    static STRUCT_IF_C L_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "L_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "L_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu16ll, L_BFu31i_BFu16ll)
//============================================================================



static void Test_L_BFu31i_BFu16s()
{
  {
    init_simple_test("L_BFu31i_BFu16s");
    static STRUCT_IF_C L_BFu31i_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "L_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "L_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu16s, L_BFu31i_BFu16s)
//============================================================================



static void Test_L_BFu31i_BFu17i()
{
  {
    init_simple_test("L_BFu31i_BFu17i");
    static STRUCT_IF_C L_BFu31i_BFu17i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "L_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "L_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu17i, L_BFu31i_BFu17i)
//============================================================================



static void Test_L_BFu31i_BFu17ll()
{
  {
    init_simple_test("L_BFu31i_BFu17ll");
    static STRUCT_IF_C L_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "L_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "L_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu17ll, L_BFu31i_BFu17ll)
//============================================================================



static void Test_L_BFu31i_BFu1c()
{
  {
    init_simple_test("L_BFu31i_BFu1c");
    static STRUCT_IF_C L_BFu31i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu1c, L_BFu31i_BFu1c)
//============================================================================



static void Test_L_BFu31i_BFu1i()
{
  {
    init_simple_test("L_BFu31i_BFu1i");
    static STRUCT_IF_C L_BFu31i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu1i, L_BFu31i_BFu1i)
//============================================================================



static void Test_L_BFu31i_BFu1ll()
{
  {
    init_simple_test("L_BFu31i_BFu1ll");
    static STRUCT_IF_C L_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu1ll, L_BFu31i_BFu1ll)
//============================================================================



static void Test_L_BFu31i_BFu1s()
{
  {
    init_simple_test("L_BFu31i_BFu1s");
    static STRUCT_IF_C L_BFu31i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu1s, L_BFu31i_BFu1s)
//============================================================================



static void Test_L_BFu31i_BFu31i()
{
  {
    init_simple_test("L_BFu31i_BFu31i");
    static STRUCT_IF_C L_BFu31i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "L_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "L_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu31i, L_BFu31i_BFu31i)
//============================================================================



static void Test_L_BFu31i_BFu31ll()
{
  {
    init_simple_test("L_BFu31i_BFu31ll");
    static STRUCT_IF_C L_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "L_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "L_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu31ll, L_BFu31i_BFu31ll)
//============================================================================



static void Test_L_BFu31i_BFu32i()
{
  {
    init_simple_test("L_BFu31i_BFu32i");
    static STRUCT_IF_C L_BFu31i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "L_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "L_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu32i, L_BFu31i_BFu32i)
//============================================================================



static void Test_L_BFu31i_BFu32ll()
{
  {
    init_simple_test("L_BFu31i_BFu32ll");
    static STRUCT_IF_C L_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "L_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "L_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu32ll, L_BFu31i_BFu32ll)
//============================================================================



static void Test_L_BFu31i_BFu33()
{
  {
    init_simple_test("L_BFu31i_BFu33");
    static STRUCT_IF_C L_BFu31i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, 1, "L_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, hide_ull(1LL<<32), "L_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu33, L_BFu31i_BFu33)
//============================================================================



static void Test_L_BFu31i_BFu7c()
{
  {
    init_simple_test("L_BFu31i_BFu7c");
    static STRUCT_IF_C L_BFu31i_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu7c, L_BFu31i_BFu7c)
//============================================================================



static void Test_L_BFu31i_BFu7i()
{
  {
    init_simple_test("L_BFu31i_BFu7i");
    static STRUCT_IF_C L_BFu31i_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu7i, L_BFu31i_BFu7i)
//============================================================================



static void Test_L_BFu31i_BFu7ll()
{
  {
    init_simple_test("L_BFu31i_BFu7ll");
    static STRUCT_IF_C L_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu7ll, L_BFu31i_BFu7ll)
//============================================================================



static void Test_L_BFu31i_BFu7s()
{
  {
    init_simple_test("L_BFu31i_BFu7s");
    static STRUCT_IF_C L_BFu31i_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu7s, L_BFu31i_BFu7s)
//============================================================================



static void Test_L_BFu31i_BFu8c()
{
  {
    init_simple_test("L_BFu31i_BFu8c");
    static STRUCT_IF_C L_BFu31i_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu8c, L_BFu31i_BFu8c)
//============================================================================



static void Test_L_BFu31i_BFu8i()
{
  {
    init_simple_test("L_BFu31i_BFu8i");
    static STRUCT_IF_C L_BFu31i_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu8i, L_BFu31i_BFu8i)
//============================================================================



static void Test_L_BFu31i_BFu8ll()
{
  {
    init_simple_test("L_BFu31i_BFu8ll");
    static STRUCT_IF_C L_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu8ll, L_BFu31i_BFu8ll)
//============================================================================



static void Test_L_BFu31i_BFu8s()
{
  {
    init_simple_test("L_BFu31i_BFu8s");
    static STRUCT_IF_C L_BFu31i_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu8s, L_BFu31i_BFu8s)
//============================================================================



static void Test_L_BFu31i_BFu9i()
{
  {
    init_simple_test("L_BFu31i_BFu9i");
    static STRUCT_IF_C L_BFu31i_BFu9i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "L_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "L_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu9i, L_BFu31i_BFu9i)
//============================================================================



static void Test_L_BFu31i_BFu9ll()
{
  {
    init_simple_test("L_BFu31i_BFu9ll");
    static STRUCT_IF_C L_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "L_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "L_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu9ll, L_BFu31i_BFu9ll)
//============================================================================



static void Test_L_BFu31i_BFu9s()
{
  {
    init_simple_test("L_BFu31i_BFu9s");
    static STRUCT_IF_C L_BFu31i_BFu9s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "L_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "L_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_BFu9s, L_BFu31i_BFu9s)
//============================================================================



static void Test_L_BFu31i_C()
{
  {
    init_simple_test("L_BFu31i_C");
    static STRUCT_IF_C L_BFu31i_C lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_C)");
    check_field_offset(lv, v1, 0, "L_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_C");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_C");
    check_field_offset(lv, v3, 12, "L_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_C, L_BFu31i_C)
//============================================================================



static void Test_L_BFu31i_D()
{
  {
    init_simple_test("L_BFu31i_D");
    static STRUCT_IF_C L_BFu31i_D lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_D)");
    check_field_offset(lv, v1, 0, "L_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_D");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_D");
    check_field_offset(lv, v3, 12, "L_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_D, L_BFu31i_D)
//============================================================================



static void Test_L_BFu31i_F()
{
  {
    init_simple_test("L_BFu31i_F");
    static STRUCT_IF_C L_BFu31i_F lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_F)");
    check_field_offset(lv, v1, 0, "L_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_F");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_F");
    check_field_offset(lv, v3, 12, "L_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_F, L_BFu31i_F)
//============================================================================



static void Test_L_BFu31i_I()
{
  {
    init_simple_test("L_BFu31i_I");
    static STRUCT_IF_C L_BFu31i_I lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_I)");
    check_field_offset(lv, v1, 0, "L_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_I");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_I");
    check_field_offset(lv, v3, 12, "L_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_I, L_BFu31i_I)
//============================================================================



static void Test_L_BFu31i_Ip()
{
  {
    init_simple_test("L_BFu31i_Ip");
    static STRUCT_IF_C L_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_Ip");
    check_field_offset(lv, v3, 12, "L_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_Ip, L_BFu31i_Ip)
//============================================================================



static void Test_L_BFu31i_L()
{
  {
    init_simple_test("L_BFu31i_L");
    static STRUCT_IF_C L_BFu31i_L lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_L)");
    check_field_offset(lv, v1, 0, "L_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_L");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_L");
    check_field_offset(lv, v3, 12, "L_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_L, L_BFu31i_L)
//============================================================================



static void Test_L_BFu31i_S()
{
  {
    init_simple_test("L_BFu31i_S");
    static STRUCT_IF_C L_BFu31i_S lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_S)");
    check_field_offset(lv, v1, 0, "L_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_S");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_S");
    check_field_offset(lv, v3, 12, "L_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_S, L_BFu31i_S)
//============================================================================



static void Test_L_BFu31i_Uc()
{
  {
    init_simple_test("L_BFu31i_Uc");
    static STRUCT_IF_C L_BFu31i_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_Uc");
    check_field_offset(lv, v3, 12, "L_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_Uc, L_BFu31i_Uc)
//============================================================================



static void Test_L_BFu31i_Ui()
{
  {
    init_simple_test("L_BFu31i_Ui");
    static STRUCT_IF_C L_BFu31i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_Ui");
    check_field_offset(lv, v3, 12, "L_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_Ui, L_BFu31i_Ui)
//============================================================================



static void Test_L_BFu31i_Ul()
{
  {
    init_simple_test("L_BFu31i_Ul");
    static STRUCT_IF_C L_BFu31i_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_Ul");
    check_field_offset(lv, v3, 12, "L_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_Ul, L_BFu31i_Ul)
//============================================================================



static void Test_L_BFu31i_Us()
{
  {
    init_simple_test("L_BFu31i_Us");
    static STRUCT_IF_C L_BFu31i_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "L_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_Us");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_Us");
    check_field_offset(lv, v3, 12, "L_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_Us, L_BFu31i_Us)
//============================================================================



static void Test_L_BFu31i_Vp()
{
  {
    init_simple_test("L_BFu31i_Vp");
    static STRUCT_IF_C L_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31i_Vp");
    check_field_offset(lv, v3, 12, "L_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31i_Vp, L_BFu31i_Vp)
//============================================================================



static void Test_L_BFu31ll()
{
  {
    init_simple_test("L_BFu31ll");
    static STRUCT_IF_C L_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll, L_BFu31ll)
//============================================================================



static void Test_L_BFu31ll_BFu15i()
{
  {
    init_simple_test("L_BFu31ll_BFu15i");
    static STRUCT_IF_C L_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "L_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "L_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu15i, L_BFu31ll_BFu15i)
//============================================================================



static void Test_L_BFu31ll_BFu15ll()
{
  {
    init_simple_test("L_BFu31ll_BFu15ll");
    static STRUCT_IF_C L_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "L_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "L_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu15ll, L_BFu31ll_BFu15ll)
//============================================================================



static void Test_L_BFu31ll_BFu15s()
{
  {
    init_simple_test("L_BFu31ll_BFu15s");
    static STRUCT_IF_C L_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, 1, "L_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 11, 7, 15, hide_ull(1LL<<14), "L_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu15s, L_BFu31ll_BFu15s)
//============================================================================



static void Test_L_BFu31ll_BFu16i()
{
  {
    init_simple_test("L_BFu31ll_BFu16i");
    static STRUCT_IF_C L_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "L_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "L_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu16i, L_BFu31ll_BFu16i)
//============================================================================



static void Test_L_BFu31ll_BFu16ll()
{
  {
    init_simple_test("L_BFu31ll_BFu16ll");
    static STRUCT_IF_C L_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "L_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "L_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu16ll, L_BFu31ll_BFu16ll)
//============================================================================



static void Test_L_BFu31ll_BFu16s()
{
  {
    init_simple_test("L_BFu31ll_BFu16s");
    static STRUCT_IF_C L_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, 1, "L_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 11, 7, 16, hide_ull(1LL<<15), "L_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu16s, L_BFu31ll_BFu16s)
//============================================================================



static void Test_L_BFu31ll_BFu17i()
{
  {
    init_simple_test("L_BFu31ll_BFu17i");
    static STRUCT_IF_C L_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "L_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "L_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu17i, L_BFu31ll_BFu17i)
//============================================================================



static void Test_L_BFu31ll_BFu17ll()
{
  {
    init_simple_test("L_BFu31ll_BFu17ll");
    static STRUCT_IF_C L_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, 1, "L_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 11, 7, 17, hide_ull(1LL<<16), "L_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu17ll, L_BFu31ll_BFu17ll)
//============================================================================



static void Test_L_BFu31ll_BFu1c()
{
  {
    init_simple_test("L_BFu31ll_BFu1c");
    static STRUCT_IF_C L_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu1c, L_BFu31ll_BFu1c)
//============================================================================



static void Test_L_BFu31ll_BFu1i()
{
  {
    init_simple_test("L_BFu31ll_BFu1i");
    static STRUCT_IF_C L_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu1i, L_BFu31ll_BFu1i)
//============================================================================



static void Test_L_BFu31ll_BFu1ll()
{
  {
    init_simple_test("L_BFu31ll_BFu1ll");
    static STRUCT_IF_C L_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu1ll, L_BFu31ll_BFu1ll)
//============================================================================



static void Test_L_BFu31ll_BFu1s()
{
  {
    init_simple_test("L_BFu31ll_BFu1s");
    static STRUCT_IF_C L_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 11, 7, 1, 1, "L_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu1s, L_BFu31ll_BFu1s)
//============================================================================



static void Test_L_BFu31ll_BFu31i()
{
  {
    init_simple_test("L_BFu31ll_BFu31i");
    static STRUCT_IF_C L_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "L_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu31i, L_BFu31ll_BFu31i)
//============================================================================



static void Test_L_BFu31ll_BFu31ll()
{
  {
    init_simple_test("L_BFu31ll_BFu31ll");
    static STRUCT_IF_C L_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, 1, "L_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 11, 7, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu31ll, L_BFu31ll_BFu31ll)
//============================================================================



static void Test_L_BFu31ll_BFu32i()
{
  {
    init_simple_test("L_BFu31ll_BFu32i");
    static STRUCT_IF_C L_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "L_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "L_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu32i, L_BFu31ll_BFu32i)
//============================================================================



static void Test_L_BFu31ll_BFu32ll()
{
  {
    init_simple_test("L_BFu31ll_BFu32ll");
    static STRUCT_IF_C L_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, 1, "L_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 11, 7, 32, hide_ull(1LL<<31), "L_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu32ll, L_BFu31ll_BFu32ll)
//============================================================================



static void Test_L_BFu31ll_BFu33()
{
  {
    init_simple_test("L_BFu31ll_BFu33");
    static STRUCT_IF_C L_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, 1, "L_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 11, 7, 33, hide_ull(1LL<<32), "L_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu33, L_BFu31ll_BFu33)
//============================================================================



static void Test_L_BFu31ll_BFu7c()
{
  {
    init_simple_test("L_BFu31ll_BFu7c");
    static STRUCT_IF_C L_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu7c, L_BFu31ll_BFu7c)
//============================================================================



static void Test_L_BFu31ll_BFu7i()
{
  {
    init_simple_test("L_BFu31ll_BFu7i");
    static STRUCT_IF_C L_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu7i, L_BFu31ll_BFu7i)
//============================================================================



static void Test_L_BFu31ll_BFu7ll()
{
  {
    init_simple_test("L_BFu31ll_BFu7ll");
    static STRUCT_IF_C L_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu7ll, L_BFu31ll_BFu7ll)
//============================================================================



static void Test_L_BFu31ll_BFu7s()
{
  {
    init_simple_test("L_BFu31ll_BFu7s");
    static STRUCT_IF_C L_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, 1, "L_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 11, 7, 7, hide_ull(1LL<<6), "L_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu7s, L_BFu31ll_BFu7s)
//============================================================================



static void Test_L_BFu31ll_BFu8c()
{
  {
    init_simple_test("L_BFu31ll_BFu8c");
    static STRUCT_IF_C L_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu8c, L_BFu31ll_BFu8c)
//============================================================================



static void Test_L_BFu31ll_BFu8i()
{
  {
    init_simple_test("L_BFu31ll_BFu8i");
    static STRUCT_IF_C L_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu8i, L_BFu31ll_BFu8i)
//============================================================================



static void Test_L_BFu31ll_BFu8ll()
{
  {
    init_simple_test("L_BFu31ll_BFu8ll");
    static STRUCT_IF_C L_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu8ll, L_BFu31ll_BFu8ll)
//============================================================================



static void Test_L_BFu31ll_BFu8s()
{
  {
    init_simple_test("L_BFu31ll_BFu8s");
    static STRUCT_IF_C L_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, 1, "L_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 11, 7, 8, hide_ull(1LL<<7), "L_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu8s, L_BFu31ll_BFu8s)
//============================================================================



static void Test_L_BFu31ll_BFu9i()
{
  {
    init_simple_test("L_BFu31ll_BFu9i");
    static STRUCT_IF_C L_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "L_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "L_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu9i, L_BFu31ll_BFu9i)
//============================================================================



static void Test_L_BFu31ll_BFu9ll()
{
  {
    init_simple_test("L_BFu31ll_BFu9ll");
    static STRUCT_IF_C L_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "L_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "L_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu9ll, L_BFu31ll_BFu9ll)
//============================================================================



static void Test_L_BFu31ll_BFu9s()
{
  {
    init_simple_test("L_BFu31ll_BFu9s");
    static STRUCT_IF_C L_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, 1, "L_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 11, 7, 9, hide_ull(1LL<<8), "L_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_BFu9s, L_BFu31ll_BFu9s)
//============================================================================



static void Test_L_BFu31ll_C()
{
  {
    init_simple_test("L_BFu31ll_C");
    static STRUCT_IF_C L_BFu31ll_C lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_C");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_C");
    check_field_offset(lv, v3, 12, "L_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_C, L_BFu31ll_C)
//============================================================================



static void Test_L_BFu31ll_D()
{
  {
    init_simple_test("L_BFu31ll_D");
    static STRUCT_IF_C L_BFu31ll_D lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_D");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_D");
    check_field_offset(lv, v3, 12, "L_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_D, L_BFu31ll_D)
//============================================================================



static void Test_L_BFu31ll_F()
{
  {
    init_simple_test("L_BFu31ll_F");
    static STRUCT_IF_C L_BFu31ll_F lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_F");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_F");
    check_field_offset(lv, v3, 12, "L_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_F, L_BFu31ll_F)
//============================================================================



static void Test_L_BFu31ll_I()
{
  {
    init_simple_test("L_BFu31ll_I");
    static STRUCT_IF_C L_BFu31ll_I lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_I");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_I");
    check_field_offset(lv, v3, 12, "L_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_I, L_BFu31ll_I)
//============================================================================



static void Test_L_BFu31ll_Ip()
{
  {
    init_simple_test("L_BFu31ll_Ip");
    static STRUCT_IF_C L_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_Ip");
    check_field_offset(lv, v3, 12, "L_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_Ip, L_BFu31ll_Ip)
//============================================================================



static void Test_L_BFu31ll_L()
{
  {
    init_simple_test("L_BFu31ll_L");
    static STRUCT_IF_C L_BFu31ll_L lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_L");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_L");
    check_field_offset(lv, v3, 12, "L_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_L, L_BFu31ll_L)
//============================================================================



static void Test_L_BFu31ll_S()
{
  {
    init_simple_test("L_BFu31ll_S");
    static STRUCT_IF_C L_BFu31ll_S lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_S");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_S");
    check_field_offset(lv, v3, 12, "L_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_S, L_BFu31ll_S)
//============================================================================



static void Test_L_BFu31ll_Uc()
{
  {
    init_simple_test("L_BFu31ll_Uc");
    static STRUCT_IF_C L_BFu31ll_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_Uc");
    check_field_offset(lv, v3, 12, "L_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_Uc, L_BFu31ll_Uc)
//============================================================================



static void Test_L_BFu31ll_Ui()
{
  {
    init_simple_test("L_BFu31ll_Ui");
    static STRUCT_IF_C L_BFu31ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_Ui");
    check_field_offset(lv, v3, 12, "L_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_Ui, L_BFu31ll_Ui)
//============================================================================



static void Test_L_BFu31ll_Ul()
{
  {
    init_simple_test("L_BFu31ll_Ul");
    static STRUCT_IF_C L_BFu31ll_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_Ul");
    check_field_offset(lv, v3, 12, "L_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_Ul, L_BFu31ll_Ul)
//============================================================================



static void Test_L_BFu31ll_Us()
{
  {
    init_simple_test("L_BFu31ll_Us");
    static STRUCT_IF_C L_BFu31ll_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_Us");
    check_field_offset(lv, v3, 12, "L_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_Us, L_BFu31ll_Us)
//============================================================================



static void Test_L_BFu31ll_Vp()
{
  {
    init_simple_test("L_BFu31ll_Vp");
    static STRUCT_IF_C L_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "L_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "L_BFu31ll_Vp");
    check_field_offset(lv, v3, 12, "L_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu31ll_Vp, L_BFu31ll_Vp)
//============================================================================



static void Test_L_BFu32i()
{
  {
    init_simple_test("L_BFu32i");
    static STRUCT_IF_C L_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i, L_BFu32i)
//============================================================================



static void Test_L_BFu32i_BFu15i()
{
  {
    init_simple_test("L_BFu32i_BFu15i");
    static STRUCT_IF_C L_BFu32i_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu15i, L_BFu32i_BFu15i)
//============================================================================



static void Test_L_BFu32i_BFu15ll()
{
  {
    init_simple_test("L_BFu32i_BFu15ll");
    static STRUCT_IF_C L_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu15ll, L_BFu32i_BFu15ll)
//============================================================================



static void Test_L_BFu32i_BFu15s()
{
  {
    init_simple_test("L_BFu32i_BFu15s");
    static STRUCT_IF_C L_BFu32i_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu15s, L_BFu32i_BFu15s)
//============================================================================



static void Test_L_BFu32i_BFu16i()
{
  {
    init_simple_test("L_BFu32i_BFu16i");
    static STRUCT_IF_C L_BFu32i_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu16i, L_BFu32i_BFu16i)
//============================================================================



static void Test_L_BFu32i_BFu16ll()
{
  {
    init_simple_test("L_BFu32i_BFu16ll");
    static STRUCT_IF_C L_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu16ll, L_BFu32i_BFu16ll)
//============================================================================



static void Test_L_BFu32i_BFu16s()
{
  {
    init_simple_test("L_BFu32i_BFu16s");
    static STRUCT_IF_C L_BFu32i_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu16s, L_BFu32i_BFu16s)
//============================================================================



static void Test_L_BFu32i_BFu17i()
{
  {
    init_simple_test("L_BFu32i_BFu17i");
    static STRUCT_IF_C L_BFu32i_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu17i, L_BFu32i_BFu17i)
//============================================================================



static void Test_L_BFu32i_BFu17ll()
{
  {
    init_simple_test("L_BFu32i_BFu17ll");
    static STRUCT_IF_C L_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu17ll, L_BFu32i_BFu17ll)
//============================================================================



static void Test_L_BFu32i_BFu1c()
{
  {
    init_simple_test("L_BFu32i_BFu1c");
    static STRUCT_IF_C L_BFu32i_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu1c, L_BFu32i_BFu1c)
//============================================================================



static void Test_L_BFu32i_BFu1i()
{
  {
    init_simple_test("L_BFu32i_BFu1i");
    static STRUCT_IF_C L_BFu32i_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu1i, L_BFu32i_BFu1i)
//============================================================================



static void Test_L_BFu32i_BFu1ll()
{
  {
    init_simple_test("L_BFu32i_BFu1ll");
    static STRUCT_IF_C L_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu1ll, L_BFu32i_BFu1ll)
//============================================================================



static void Test_L_BFu32i_BFu1s()
{
  {
    init_simple_test("L_BFu32i_BFu1s");
    static STRUCT_IF_C L_BFu32i_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu1s, L_BFu32i_BFu1s)
//============================================================================



static void Test_L_BFu32i_BFu31i()
{
  {
    init_simple_test("L_BFu32i_BFu31i");
    static STRUCT_IF_C L_BFu32i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu31i, L_BFu32i_BFu31i)
//============================================================================



static void Test_L_BFu32i_BFu31ll()
{
  {
    init_simple_test("L_BFu32i_BFu31ll");
    static STRUCT_IF_C L_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu31ll, L_BFu32i_BFu31ll)
//============================================================================



static void Test_L_BFu32i_BFu32i()
{
  {
    init_simple_test("L_BFu32i_BFu32i");
    static STRUCT_IF_C L_BFu32i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu32i, L_BFu32i_BFu32i)
//============================================================================



static void Test_L_BFu32i_BFu32ll()
{
  {
    init_simple_test("L_BFu32i_BFu32ll");
    static STRUCT_IF_C L_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu32ll, L_BFu32i_BFu32ll)
//============================================================================



static void Test_L_BFu32i_BFu33()
{
  {
    init_simple_test("L_BFu32i_BFu33");
    static STRUCT_IF_C L_BFu32i_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "L_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "L_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu33, L_BFu32i_BFu33)
//============================================================================



static void Test_L_BFu32i_BFu7c()
{
  {
    init_simple_test("L_BFu32i_BFu7c");
    static STRUCT_IF_C L_BFu32i_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu7c, L_BFu32i_BFu7c)
//============================================================================



static void Test_L_BFu32i_BFu7i()
{
  {
    init_simple_test("L_BFu32i_BFu7i");
    static STRUCT_IF_C L_BFu32i_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu7i, L_BFu32i_BFu7i)
//============================================================================



static void Test_L_BFu32i_BFu7ll()
{
  {
    init_simple_test("L_BFu32i_BFu7ll");
    static STRUCT_IF_C L_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu7ll, L_BFu32i_BFu7ll)
//============================================================================



static void Test_L_BFu32i_BFu7s()
{
  {
    init_simple_test("L_BFu32i_BFu7s");
    static STRUCT_IF_C L_BFu32i_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu7s, L_BFu32i_BFu7s)
//============================================================================



static void Test_L_BFu32i_BFu8c()
{
  {
    init_simple_test("L_BFu32i_BFu8c");
    static STRUCT_IF_C L_BFu32i_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu8c, L_BFu32i_BFu8c)
//============================================================================



static void Test_L_BFu32i_BFu8i()
{
  {
    init_simple_test("L_BFu32i_BFu8i");
    static STRUCT_IF_C L_BFu32i_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu8i, L_BFu32i_BFu8i)
//============================================================================



static void Test_L_BFu32i_BFu8ll()
{
  {
    init_simple_test("L_BFu32i_BFu8ll");
    static STRUCT_IF_C L_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu8ll, L_BFu32i_BFu8ll)
//============================================================================



static void Test_L_BFu32i_BFu8s()
{
  {
    init_simple_test("L_BFu32i_BFu8s");
    static STRUCT_IF_C L_BFu32i_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu8s, L_BFu32i_BFu8s)
//============================================================================



static void Test_L_BFu32i_BFu9i()
{
  {
    init_simple_test("L_BFu32i_BFu9i");
    static STRUCT_IF_C L_BFu32i_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu9i, L_BFu32i_BFu9i)
//============================================================================



static void Test_L_BFu32i_BFu9ll()
{
  {
    init_simple_test("L_BFu32i_BFu9ll");
    static STRUCT_IF_C L_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu9ll, L_BFu32i_BFu9ll)
//============================================================================



static void Test_L_BFu32i_BFu9s()
{
  {
    init_simple_test("L_BFu32i_BFu9s");
    static STRUCT_IF_C L_BFu32i_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_BFu9s, L_BFu32i_BFu9s)
//============================================================================



static void Test_L_BFu32i_C()
{
  {
    init_simple_test("L_BFu32i_C");
    static STRUCT_IF_C L_BFu32i_C lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_C)");
    check_field_offset(lv, v1, 0, "L_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_C");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_C");
    check_field_offset(lv, v3, 12, "L_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_C, L_BFu32i_C)
//============================================================================



static void Test_L_BFu32i_D()
{
  {
    init_simple_test("L_BFu32i_D");
    static STRUCT_IF_C L_BFu32i_D lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_D)");
    check_field_offset(lv, v1, 0, "L_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_D");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_D");
    check_field_offset(lv, v3, 12, "L_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_D, L_BFu32i_D)
//============================================================================



static void Test_L_BFu32i_F()
{
  {
    init_simple_test("L_BFu32i_F");
    static STRUCT_IF_C L_BFu32i_F lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_F)");
    check_field_offset(lv, v1, 0, "L_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_F");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_F");
    check_field_offset(lv, v3, 12, "L_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_F, L_BFu32i_F)
//============================================================================



static void Test_L_BFu32i_I()
{
  {
    init_simple_test("L_BFu32i_I");
    static STRUCT_IF_C L_BFu32i_I lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_I)");
    check_field_offset(lv, v1, 0, "L_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_I");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_I");
    check_field_offset(lv, v3, 12, "L_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_I, L_BFu32i_I)
//============================================================================



static void Test_L_BFu32i_Ip()
{
  {
    init_simple_test("L_BFu32i_Ip");
    static STRUCT_IF_C L_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_Ip");
    check_field_offset(lv, v3, 12, "L_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_Ip, L_BFu32i_Ip)
//============================================================================



static void Test_L_BFu32i_L()
{
  {
    init_simple_test("L_BFu32i_L");
    static STRUCT_IF_C L_BFu32i_L lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_L)");
    check_field_offset(lv, v1, 0, "L_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_L");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_L");
    check_field_offset(lv, v3, 12, "L_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_L, L_BFu32i_L)
//============================================================================



static void Test_L_BFu32i_S()
{
  {
    init_simple_test("L_BFu32i_S");
    static STRUCT_IF_C L_BFu32i_S lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_S)");
    check_field_offset(lv, v1, 0, "L_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_S");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_S");
    check_field_offset(lv, v3, 12, "L_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_S, L_BFu32i_S)
//============================================================================



static void Test_L_BFu32i_Uc()
{
  {
    init_simple_test("L_BFu32i_Uc");
    static STRUCT_IF_C L_BFu32i_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_Uc");
    check_field_offset(lv, v3, 12, "L_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_Uc, L_BFu32i_Uc)
//============================================================================



static void Test_L_BFu32i_Ui()
{
  {
    init_simple_test("L_BFu32i_Ui");
    static STRUCT_IF_C L_BFu32i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_Ui");
    check_field_offset(lv, v3, 12, "L_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_Ui, L_BFu32i_Ui)
//============================================================================



static void Test_L_BFu32i_Ul()
{
  {
    init_simple_test("L_BFu32i_Ul");
    static STRUCT_IF_C L_BFu32i_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_Ul");
    check_field_offset(lv, v3, 12, "L_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_Ul, L_BFu32i_Ul)
//============================================================================



static void Test_L_BFu32i_Us()
{
  {
    init_simple_test("L_BFu32i_Us");
    static STRUCT_IF_C L_BFu32i_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "L_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_Us");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_Us");
    check_field_offset(lv, v3, 12, "L_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_Us, L_BFu32i_Us)
//============================================================================



static void Test_L_BFu32i_Vp()
{
  {
    init_simple_test("L_BFu32i_Vp");
    static STRUCT_IF_C L_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32i_Vp");
    check_field_offset(lv, v3, 12, "L_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32i_Vp, L_BFu32i_Vp)
//============================================================================



static void Test_L_BFu32ll()
{
  {
    init_simple_test("L_BFu32ll");
    static STRUCT_IF_C L_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll, L_BFu32ll)
//============================================================================



static void Test_L_BFu32ll_BFu15i()
{
  {
    init_simple_test("L_BFu32ll_BFu15i");
    static STRUCT_IF_C L_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu15i, L_BFu32ll_BFu15i)
//============================================================================



static void Test_L_BFu32ll_BFu15ll()
{
  {
    init_simple_test("L_BFu32ll_BFu15ll");
    static STRUCT_IF_C L_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu15ll, L_BFu32ll_BFu15ll)
//============================================================================



static void Test_L_BFu32ll_BFu15s()
{
  {
    init_simple_test("L_BFu32ll_BFu15s");
    static STRUCT_IF_C L_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu15s, L_BFu32ll_BFu15s)
//============================================================================



static void Test_L_BFu32ll_BFu16i()
{
  {
    init_simple_test("L_BFu32ll_BFu16i");
    static STRUCT_IF_C L_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu16i, L_BFu32ll_BFu16i)
//============================================================================



static void Test_L_BFu32ll_BFu16ll()
{
  {
    init_simple_test("L_BFu32ll_BFu16ll");
    static STRUCT_IF_C L_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu16ll, L_BFu32ll_BFu16ll)
//============================================================================



static void Test_L_BFu32ll_BFu16s()
{
  {
    init_simple_test("L_BFu32ll_BFu16s");
    static STRUCT_IF_C L_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu16s, L_BFu32ll_BFu16s)
//============================================================================



static void Test_L_BFu32ll_BFu17i()
{
  {
    init_simple_test("L_BFu32ll_BFu17i");
    static STRUCT_IF_C L_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu17i, L_BFu32ll_BFu17i)
//============================================================================



static void Test_L_BFu32ll_BFu17ll()
{
  {
    init_simple_test("L_BFu32ll_BFu17ll");
    static STRUCT_IF_C L_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu17ll, L_BFu32ll_BFu17ll)
//============================================================================



static void Test_L_BFu32ll_BFu1c()
{
  {
    init_simple_test("L_BFu32ll_BFu1c");
    static STRUCT_IF_C L_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu1c, L_BFu32ll_BFu1c)
//============================================================================



static void Test_L_BFu32ll_BFu1i()
{
  {
    init_simple_test("L_BFu32ll_BFu1i");
    static STRUCT_IF_C L_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu1i, L_BFu32ll_BFu1i)
//============================================================================



static void Test_L_BFu32ll_BFu1ll()
{
  {
    init_simple_test("L_BFu32ll_BFu1ll");
    static STRUCT_IF_C L_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu1ll, L_BFu32ll_BFu1ll)
//============================================================================



static void Test_L_BFu32ll_BFu1s()
{
  {
    init_simple_test("L_BFu32ll_BFu1s");
    static STRUCT_IF_C L_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu1s, L_BFu32ll_BFu1s)
//============================================================================



static void Test_L_BFu32ll_BFu31i()
{
  {
    init_simple_test("L_BFu32ll_BFu31i");
    static STRUCT_IF_C L_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu31i, L_BFu32ll_BFu31i)
//============================================================================



static void Test_L_BFu32ll_BFu31ll()
{
  {
    init_simple_test("L_BFu32ll_BFu31ll");
    static STRUCT_IF_C L_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu31ll, L_BFu32ll_BFu31ll)
//============================================================================



static void Test_L_BFu32ll_BFu32i()
{
  {
    init_simple_test("L_BFu32ll_BFu32i");
    static STRUCT_IF_C L_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu32i, L_BFu32ll_BFu32i)
//============================================================================



static void Test_L_BFu32ll_BFu32ll()
{
  {
    init_simple_test("L_BFu32ll_BFu32ll");
    static STRUCT_IF_C L_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu32ll, L_BFu32ll_BFu32ll)
//============================================================================



static void Test_L_BFu32ll_BFu33()
{
  {
    init_simple_test("L_BFu32ll_BFu33");
    static STRUCT_IF_C L_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "L_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "L_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu33, L_BFu32ll_BFu33)
//============================================================================



static void Test_L_BFu32ll_BFu7c()
{
  {
    init_simple_test("L_BFu32ll_BFu7c");
    static STRUCT_IF_C L_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu7c, L_BFu32ll_BFu7c)
//============================================================================



static void Test_L_BFu32ll_BFu7i()
{
  {
    init_simple_test("L_BFu32ll_BFu7i");
    static STRUCT_IF_C L_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu7i, L_BFu32ll_BFu7i)
//============================================================================



static void Test_L_BFu32ll_BFu7ll()
{
  {
    init_simple_test("L_BFu32ll_BFu7ll");
    static STRUCT_IF_C L_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu7ll, L_BFu32ll_BFu7ll)
//============================================================================



static void Test_L_BFu32ll_BFu7s()
{
  {
    init_simple_test("L_BFu32ll_BFu7s");
    static STRUCT_IF_C L_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu7s, L_BFu32ll_BFu7s)
//============================================================================



static void Test_L_BFu32ll_BFu8c()
{
  {
    init_simple_test("L_BFu32ll_BFu8c");
    static STRUCT_IF_C L_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu8c, L_BFu32ll_BFu8c)
//============================================================================



static void Test_L_BFu32ll_BFu8i()
{
  {
    init_simple_test("L_BFu32ll_BFu8i");
    static STRUCT_IF_C L_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu8i, L_BFu32ll_BFu8i)
//============================================================================



static void Test_L_BFu32ll_BFu8ll()
{
  {
    init_simple_test("L_BFu32ll_BFu8ll");
    static STRUCT_IF_C L_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu8ll, L_BFu32ll_BFu8ll)
//============================================================================



static void Test_L_BFu32ll_BFu8s()
{
  {
    init_simple_test("L_BFu32ll_BFu8s");
    static STRUCT_IF_C L_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu8s, L_BFu32ll_BFu8s)
//============================================================================



static void Test_L_BFu32ll_BFu9i()
{
  {
    init_simple_test("L_BFu32ll_BFu9i");
    static STRUCT_IF_C L_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu9i, L_BFu32ll_BFu9i)
//============================================================================



static void Test_L_BFu32ll_BFu9ll()
{
  {
    init_simple_test("L_BFu32ll_BFu9ll");
    static STRUCT_IF_C L_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu9ll, L_BFu32ll_BFu9ll)
//============================================================================



static void Test_L_BFu32ll_BFu9s()
{
  {
    init_simple_test("L_BFu32ll_BFu9s");
    static STRUCT_IF_C L_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_BFu9s, L_BFu32ll_BFu9s)
//============================================================================



static void Test_L_BFu32ll_C()
{
  {
    init_simple_test("L_BFu32ll_C");
    static STRUCT_IF_C L_BFu32ll_C lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_C");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_C");
    check_field_offset(lv, v3, 12, "L_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_C, L_BFu32ll_C)
//============================================================================



static void Test_L_BFu32ll_D()
{
  {
    init_simple_test("L_BFu32ll_D");
    static STRUCT_IF_C L_BFu32ll_D lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_D");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_D");
    check_field_offset(lv, v3, 12, "L_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_D, L_BFu32ll_D)
//============================================================================



static void Test_L_BFu32ll_F()
{
  {
    init_simple_test("L_BFu32ll_F");
    static STRUCT_IF_C L_BFu32ll_F lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_F");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_F");
    check_field_offset(lv, v3, 12, "L_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_F, L_BFu32ll_F)
//============================================================================



static void Test_L_BFu32ll_I()
{
  {
    init_simple_test("L_BFu32ll_I");
    static STRUCT_IF_C L_BFu32ll_I lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_I");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_I");
    check_field_offset(lv, v3, 12, "L_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_I, L_BFu32ll_I)
//============================================================================



static void Test_L_BFu32ll_Ip()
{
  {
    init_simple_test("L_BFu32ll_Ip");
    static STRUCT_IF_C L_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_Ip");
    check_field_offset(lv, v3, 12, "L_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_Ip, L_BFu32ll_Ip)
//============================================================================



static void Test_L_BFu32ll_L()
{
  {
    init_simple_test("L_BFu32ll_L");
    static STRUCT_IF_C L_BFu32ll_L lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_L");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_L");
    check_field_offset(lv, v3, 12, "L_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_L, L_BFu32ll_L)
//============================================================================



static void Test_L_BFu32ll_S()
{
  {
    init_simple_test("L_BFu32ll_S");
    static STRUCT_IF_C L_BFu32ll_S lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_S");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_S");
    check_field_offset(lv, v3, 12, "L_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_S, L_BFu32ll_S)
//============================================================================



static void Test_L_BFu32ll_Uc()
{
  {
    init_simple_test("L_BFu32ll_Uc");
    static STRUCT_IF_C L_BFu32ll_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_Uc");
    check_field_offset(lv, v3, 12, "L_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_Uc, L_BFu32ll_Uc)
//============================================================================



static void Test_L_BFu32ll_Ui()
{
  {
    init_simple_test("L_BFu32ll_Ui");
    static STRUCT_IF_C L_BFu32ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_Ui");
    check_field_offset(lv, v3, 12, "L_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_Ui, L_BFu32ll_Ui)
//============================================================================



static void Test_L_BFu32ll_Ul()
{
  {
    init_simple_test("L_BFu32ll_Ul");
    static STRUCT_IF_C L_BFu32ll_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_Ul");
    check_field_offset(lv, v3, 12, "L_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_Ul, L_BFu32ll_Ul)
//============================================================================



static void Test_L_BFu32ll_Us()
{
  {
    init_simple_test("L_BFu32ll_Us");
    static STRUCT_IF_C L_BFu32ll_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_Us");
    check_field_offset(lv, v3, 12, "L_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_Us, L_BFu32ll_Us)
//============================================================================



static void Test_L_BFu32ll_Vp()
{
  {
    init_simple_test("L_BFu32ll_Vp");
    static STRUCT_IF_C L_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "L_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "L_BFu32ll_Vp");
    check_field_offset(lv, v3, 12, "L_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu32ll_Vp, L_BFu32ll_Vp)
//============================================================================



static void Test_L_BFu33()
{
  {
    init_simple_test("L_BFu33");
    static STRUCT_IF_C L_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33, L_BFu33)
//============================================================================



static void Test_L_BFu33_BFu15i()
{
  {
    init_simple_test("L_BFu33_BFu15i");
    static STRUCT_IF_C L_BFu33_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 12, 1, 15, 1, "L_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 12, 1, 15, hide_ull(1LL<<14), "L_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu15i, L_BFu33_BFu15i)
//============================================================================



static void Test_L_BFu33_BFu15ll()
{
  {
    init_simple_test("L_BFu33_BFu15ll");
    static STRUCT_IF_C L_BFu33_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 12, 1, 15, 1, "L_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 12, 1, 15, hide_ull(1LL<<14), "L_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu15ll, L_BFu33_BFu15ll)
//============================================================================



static void Test_L_BFu33_BFu15s()
{
  {
    init_simple_test("L_BFu33_BFu15s");
    static STRUCT_IF_C L_BFu33_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 12, 1, 15, 1, "L_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 12, 1, 15, hide_ull(1LL<<14), "L_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu15s, L_BFu33_BFu15s)
//============================================================================



static void Test_L_BFu33_BFu16i()
{
  {
    init_simple_test("L_BFu33_BFu16i");
    static STRUCT_IF_C L_BFu33_BFu16i lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 12, 1, 16, 1, "L_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 12, 1, 16, hide_ull(1LL<<15), "L_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu16i, L_BFu33_BFu16i)
//============================================================================



static void Test_L_BFu33_BFu16ll()
{
  {
    init_simple_test("L_BFu33_BFu16ll");
    static STRUCT_IF_C L_BFu33_BFu16ll lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 12, 1, 16, 1, "L_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 12, 1, 16, hide_ull(1LL<<15), "L_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu16ll, L_BFu33_BFu16ll)
//============================================================================



static void Test_L_BFu33_BFu16s()
{
  {
    init_simple_test("L_BFu33_BFu16s");
    static STRUCT_IF_C L_BFu33_BFu16s lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 12, 1, 16, 1, "L_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 12, 1, 16, hide_ull(1LL<<15), "L_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu16s, L_BFu33_BFu16s)
//============================================================================



static void Test_L_BFu33_BFu17i()
{
  {
    init_simple_test("L_BFu33_BFu17i");
    static STRUCT_IF_C L_BFu33_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 12, 1, 17, 1, "L_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 12, 1, 17, hide_ull(1LL<<16), "L_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu17i, L_BFu33_BFu17i)
//============================================================================



static void Test_L_BFu33_BFu17ll()
{
  {
    init_simple_test("L_BFu33_BFu17ll");
    static STRUCT_IF_C L_BFu33_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 12, 1, 17, 1, "L_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 12, 1, 17, hide_ull(1LL<<16), "L_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu17ll, L_BFu33_BFu17ll)
//============================================================================



static void Test_L_BFu33_BFu1c()
{
  {
    init_simple_test("L_BFu33_BFu1c");
    static STRUCT_IF_C L_BFu33_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "L_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu1c, L_BFu33_BFu1c)
//============================================================================



static void Test_L_BFu33_BFu1i()
{
  {
    init_simple_test("L_BFu33_BFu1i");
    static STRUCT_IF_C L_BFu33_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "L_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu1i, L_BFu33_BFu1i)
//============================================================================



static void Test_L_BFu33_BFu1ll()
{
  {
    init_simple_test("L_BFu33_BFu1ll");
    static STRUCT_IF_C L_BFu33_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "L_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu1ll, L_BFu33_BFu1ll)
//============================================================================



static void Test_L_BFu33_BFu1s()
{
  {
    init_simple_test("L_BFu33_BFu1s");
    static STRUCT_IF_C L_BFu33_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 12, 1, 1, 1, "L_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu1s, L_BFu33_BFu1s)
//============================================================================



static void Test_L_BFu33_BFu31i()
{
  {
    init_simple_test("L_BFu33_BFu31i");
    static STRUCT_IF_C L_BFu33_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 12, 1, 31, 1, "L_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 12, 1, 31, hide_ull(1LL<<30), "L_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu31i, L_BFu33_BFu31i)
//============================================================================



static void Test_L_BFu33_BFu31ll()
{
  {
    init_simple_test("L_BFu33_BFu31ll");
    static STRUCT_IF_C L_BFu33_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 12, 1, 31, 1, "L_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 12, 1, 31, hide_ull(1LL<<30), "L_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu31ll, L_BFu33_BFu31ll)
//============================================================================



static void Test_L_BFu33_BFu32i()
{
  {
    init_simple_test("L_BFu33_BFu32i");
    static STRUCT_IF_C L_BFu33_BFu32i lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 12, 1, 32, 1, "L_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 12, 1, 32, hide_ull(1LL<<31), "L_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu32i, L_BFu33_BFu32i)
//============================================================================



static void Test_L_BFu33_BFu32ll()
{
  {
    init_simple_test("L_BFu33_BFu32ll");
    static STRUCT_IF_C L_BFu33_BFu32ll lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 12, 1, 32, 1, "L_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 12, 1, 32, hide_ull(1LL<<31), "L_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu32ll, L_BFu33_BFu32ll)
//============================================================================



static void Test_L_BFu33_BFu33()
{
  {
    init_simple_test("L_BFu33_BFu33");
    static STRUCT_IF_C L_BFu33_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu33");
    set_bf_and_test(lv, v3, 12, 1, 33, 1, "L_BFu33_BFu33");
    set_bf_and_test(lv, v3, 12, 1, 33, hide_ull(1LL<<32), "L_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu33, L_BFu33_BFu33)
//============================================================================



static void Test_L_BFu33_BFu7c()
{
  {
    init_simple_test("L_BFu33_BFu7c");
    static STRUCT_IF_C L_BFu33_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "L_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "L_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu7c, L_BFu33_BFu7c)
//============================================================================



static void Test_L_BFu33_BFu7i()
{
  {
    init_simple_test("L_BFu33_BFu7i");
    static STRUCT_IF_C L_BFu33_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "L_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "L_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu7i, L_BFu33_BFu7i)
//============================================================================



static void Test_L_BFu33_BFu7ll()
{
  {
    init_simple_test("L_BFu33_BFu7ll");
    static STRUCT_IF_C L_BFu33_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "L_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "L_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu7ll, L_BFu33_BFu7ll)
//============================================================================



static void Test_L_BFu33_BFu7s()
{
  {
    init_simple_test("L_BFu33_BFu7s");
    static STRUCT_IF_C L_BFu33_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 12, 1, 7, 1, "L_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 12, 1, 7, hide_ull(1LL<<6), "L_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu7s, L_BFu33_BFu7s)
//============================================================================



static void Test_L_BFu33_BFu8c()
{
  {
    init_simple_test("L_BFu33_BFu8c");
    static STRUCT_IF_C L_BFu33_BFu8c lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "L_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "L_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu8c, L_BFu33_BFu8c)
//============================================================================



static void Test_L_BFu33_BFu8i()
{
  {
    init_simple_test("L_BFu33_BFu8i");
    static STRUCT_IF_C L_BFu33_BFu8i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "L_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "L_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu8i, L_BFu33_BFu8i)
//============================================================================



static void Test_L_BFu33_BFu8ll()
{
  {
    init_simple_test("L_BFu33_BFu8ll");
    static STRUCT_IF_C L_BFu33_BFu8ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "L_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "L_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu8ll, L_BFu33_BFu8ll)
//============================================================================



static void Test_L_BFu33_BFu8s()
{
  {
    init_simple_test("L_BFu33_BFu8s");
    static STRUCT_IF_C L_BFu33_BFu8s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 12, 1, 8, 1, "L_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 12, 1, 8, hide_ull(1LL<<7), "L_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu8s, L_BFu33_BFu8s)
//============================================================================



static void Test_L_BFu33_BFu9i()
{
  {
    init_simple_test("L_BFu33_BFu9i");
    static STRUCT_IF_C L_BFu33_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 12, 1, 9, 1, "L_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 12, 1, 9, hide_ull(1LL<<8), "L_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu9i, L_BFu33_BFu9i)
//============================================================================



static void Test_L_BFu33_BFu9ll()
{
  {
    init_simple_test("L_BFu33_BFu9ll");
    static STRUCT_IF_C L_BFu33_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 12, 1, 9, 1, "L_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 12, 1, 9, hide_ull(1LL<<8), "L_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu9ll, L_BFu33_BFu9ll)
//============================================================================



static void Test_L_BFu33_BFu9s()
{
  {
    init_simple_test("L_BFu33_BFu9s");
    static STRUCT_IF_C L_BFu33_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 12, 1, 9, 1, "L_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 12, 1, 9, hide_ull(1LL<<8), "L_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_BFu9s, L_BFu33_BFu9s)
//============================================================================



static void Test_L_BFu33_C()
{
  {
    init_simple_test("L_BFu33_C");
    static STRUCT_IF_C L_BFu33_C lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_C)");
    check_field_offset(lv, v1, 0, "L_BFu33_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_C");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_C");
    check_field_offset(lv, v3, 13, "L_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_C, L_BFu33_C)
//============================================================================



static void Test_L_BFu33_D()
{
  {
    init_simple_test("L_BFu33_D");
    static STRUCT_IF_C L_BFu33_D lv;
    check2(sizeof(lv), 21, "sizeof(L_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_D)");
    check_field_offset(lv, v1, 0, "L_BFu33_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_D");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_D");
    check_field_offset(lv, v3, 13, "L_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_D, L_BFu33_D)
//============================================================================



static void Test_L_BFu33_F()
{
  {
    init_simple_test("L_BFu33_F");
    static STRUCT_IF_C L_BFu33_F lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_F)");
    check_field_offset(lv, v1, 0, "L_BFu33_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_F");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_F");
    check_field_offset(lv, v3, 13, "L_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_F, L_BFu33_F)
//============================================================================



static void Test_L_BFu33_I()
{
  {
    init_simple_test("L_BFu33_I");
    static STRUCT_IF_C L_BFu33_I lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_I)");
    check_field_offset(lv, v1, 0, "L_BFu33_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_I");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_I");
    check_field_offset(lv, v3, 13, "L_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_I, L_BFu33_I)
//============================================================================



static void Test_L_BFu33_Ip()
{
  {
    init_simple_test("L_BFu33_Ip");
    static STRUCT_IF_C L_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(L_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_Ip");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_Ip");
    check_field_offset(lv, v3, 13, "L_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_Ip, L_BFu33_Ip)
//============================================================================



static void Test_L_BFu33_L()
{
  {
    init_simple_test("L_BFu33_L");
    static STRUCT_IF_C L_BFu33_L lv;
    check2(sizeof(lv), 21, "sizeof(L_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_L)");
    check_field_offset(lv, v1, 0, "L_BFu33_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_L");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_L");
    check_field_offset(lv, v3, 13, "L_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_L, L_BFu33_L)
//============================================================================



static void Test_L_BFu33_S()
{
  {
    init_simple_test("L_BFu33_S");
    static STRUCT_IF_C L_BFu33_S lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_S)");
    check_field_offset(lv, v1, 0, "L_BFu33_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_S");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_S");
    check_field_offset(lv, v3, 13, "L_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_S, L_BFu33_S)
//============================================================================



static void Test_L_BFu33_Uc()
{
  {
    init_simple_test("L_BFu33_Uc");
    static STRUCT_IF_C L_BFu33_Uc lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_Uc");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_Uc");
    check_field_offset(lv, v3, 13, "L_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_Uc, L_BFu33_Uc)
//============================================================================



static void Test_L_BFu33_Ui()
{
  {
    init_simple_test("L_BFu33_Ui");
    static STRUCT_IF_C L_BFu33_Ui lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_Ui");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_Ui");
    check_field_offset(lv, v3, 13, "L_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_Ui, L_BFu33_Ui)
//============================================================================



static void Test_L_BFu33_Ul()
{
  {
    init_simple_test("L_BFu33_Ul");
    static STRUCT_IF_C L_BFu33_Ul lv;
    check2(sizeof(lv), 21, "sizeof(L_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_Ul");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_Ul");
    check_field_offset(lv, v3, 13, "L_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_Ul, L_BFu33_Ul)
//============================================================================



static void Test_L_BFu33_Us()
{
  {
    init_simple_test("L_BFu33_Us");
    static STRUCT_IF_C L_BFu33_Us lv;
    check2(sizeof(lv), 15, "sizeof(L_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_Us)");
    check_field_offset(lv, v1, 0, "L_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_Us");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_Us");
    check_field_offset(lv, v3, 13, "L_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_Us, L_BFu33_Us)
//============================================================================



static void Test_L_BFu33_Vp()
{
  {
    init_simple_test("L_BFu33_Vp");
    static STRUCT_IF_C L_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(L_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "L_BFu33_Vp");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "L_BFu33_Vp");
    check_field_offset(lv, v3, 13, "L_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu33_Vp, L_BFu33_Vp)
//============================================================================



static void Test_L_BFu7c()
{
  {
    init_simple_test("L_BFu7c");
    static STRUCT_IF_C L_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c, L_BFu7c)
//============================================================================



static void Test_L_BFu7c_BFu15i()
{
  {
    init_simple_test("L_BFu7c_BFu15i");
    static STRUCT_IF_C L_BFu7c_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu15i, L_BFu7c_BFu15i)
//============================================================================



static void Test_L_BFu7c_BFu15ll()
{
  {
    init_simple_test("L_BFu7c_BFu15ll");
    static STRUCT_IF_C L_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu15ll, L_BFu7c_BFu15ll)
//============================================================================



static void Test_L_BFu7c_BFu15s()
{
  {
    init_simple_test("L_BFu7c_BFu15s");
    static STRUCT_IF_C L_BFu7c_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu15s, L_BFu7c_BFu15s)
//============================================================================



static void Test_L_BFu7c_BFu16i()
{
  {
    init_simple_test("L_BFu7c_BFu16i");
    static STRUCT_IF_C L_BFu7c_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu16i, L_BFu7c_BFu16i)
//============================================================================



static void Test_L_BFu7c_BFu16ll()
{
  {
    init_simple_test("L_BFu7c_BFu16ll");
    static STRUCT_IF_C L_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu16ll, L_BFu7c_BFu16ll)
//============================================================================



static void Test_L_BFu7c_BFu16s()
{
  {
    init_simple_test("L_BFu7c_BFu16s");
    static STRUCT_IF_C L_BFu7c_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu16s, L_BFu7c_BFu16s)
//============================================================================



static void Test_L_BFu7c_BFu17i()
{
  {
    init_simple_test("L_BFu7c_BFu17i");
    static STRUCT_IF_C L_BFu7c_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu17i, L_BFu7c_BFu17i)
//============================================================================



static void Test_L_BFu7c_BFu17ll()
{
  {
    init_simple_test("L_BFu7c_BFu17ll");
    static STRUCT_IF_C L_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu17ll, L_BFu7c_BFu17ll)
//============================================================================



static void Test_L_BFu7c_BFu1c()
{
  {
    init_simple_test("L_BFu7c_BFu1c");
    static STRUCT_IF_C L_BFu7c_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu1c, L_BFu7c_BFu1c)
//============================================================================



static void Test_L_BFu7c_BFu1i()
{
  {
    init_simple_test("L_BFu7c_BFu1i");
    static STRUCT_IF_C L_BFu7c_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu1i, L_BFu7c_BFu1i)
//============================================================================



static void Test_L_BFu7c_BFu1ll()
{
  {
    init_simple_test("L_BFu7c_BFu1ll");
    static STRUCT_IF_C L_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu1ll, L_BFu7c_BFu1ll)
//============================================================================



static void Test_L_BFu7c_BFu1s()
{
  {
    init_simple_test("L_BFu7c_BFu1s");
    static STRUCT_IF_C L_BFu7c_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu1s, L_BFu7c_BFu1s)
//============================================================================



static void Test_L_BFu7c_BFu31i()
{
  {
    init_simple_test("L_BFu7c_BFu31i");
    static STRUCT_IF_C L_BFu7c_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu31i, L_BFu7c_BFu31i)
//============================================================================



static void Test_L_BFu7c_BFu31ll()
{
  {
    init_simple_test("L_BFu7c_BFu31ll");
    static STRUCT_IF_C L_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu31ll, L_BFu7c_BFu31ll)
//============================================================================



static void Test_L_BFu7c_BFu32i()
{
  {
    init_simple_test("L_BFu7c_BFu32i");
    static STRUCT_IF_C L_BFu7c_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu32i, L_BFu7c_BFu32i)
//============================================================================



static void Test_L_BFu7c_BFu32ll()
{
  {
    init_simple_test("L_BFu7c_BFu32ll");
    static STRUCT_IF_C L_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu32ll, L_BFu7c_BFu32ll)
//============================================================================



static void Test_L_BFu7c_BFu33()
{
  {
    init_simple_test("L_BFu7c_BFu33");
    static STRUCT_IF_C L_BFu7c_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "L_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "L_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu33, L_BFu7c_BFu33)
//============================================================================



static void Test_L_BFu7c_BFu7c()
{
  {
    init_simple_test("L_BFu7c_BFu7c");
    static STRUCT_IF_C L_BFu7c_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu7c, L_BFu7c_BFu7c)
//============================================================================



static void Test_L_BFu7c_BFu7i()
{
  {
    init_simple_test("L_BFu7c_BFu7i");
    static STRUCT_IF_C L_BFu7c_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu7i, L_BFu7c_BFu7i)
//============================================================================



static void Test_L_BFu7c_BFu7ll()
{
  {
    init_simple_test("L_BFu7c_BFu7ll");
    static STRUCT_IF_C L_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu7ll, L_BFu7c_BFu7ll)
//============================================================================



static void Test_L_BFu7c_BFu7s()
{
  {
    init_simple_test("L_BFu7c_BFu7s");
    static STRUCT_IF_C L_BFu7c_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu7s, L_BFu7c_BFu7s)
//============================================================================



static void Test_L_BFu7c_BFu8c()
{
  {
    init_simple_test("L_BFu7c_BFu8c");
    static STRUCT_IF_C L_BFu7c_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu8c, L_BFu7c_BFu8c)
//============================================================================



static void Test_L_BFu7c_BFu8i()
{
  {
    init_simple_test("L_BFu7c_BFu8i");
    static STRUCT_IF_C L_BFu7c_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu8i, L_BFu7c_BFu8i)
//============================================================================



static void Test_L_BFu7c_BFu8ll()
{
  {
    init_simple_test("L_BFu7c_BFu8ll");
    static STRUCT_IF_C L_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu8ll, L_BFu7c_BFu8ll)
//============================================================================



static void Test_L_BFu7c_BFu8s()
{
  {
    init_simple_test("L_BFu7c_BFu8s");
    static STRUCT_IF_C L_BFu7c_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu8s, L_BFu7c_BFu8s)
//============================================================================



static void Test_L_BFu7c_BFu9i()
{
  {
    init_simple_test("L_BFu7c_BFu9i");
    static STRUCT_IF_C L_BFu7c_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu9i, L_BFu7c_BFu9i)
//============================================================================



static void Test_L_BFu7c_BFu9ll()
{
  {
    init_simple_test("L_BFu7c_BFu9ll");
    static STRUCT_IF_C L_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu9ll, L_BFu7c_BFu9ll)
//============================================================================



static void Test_L_BFu7c_BFu9s()
{
  {
    init_simple_test("L_BFu7c_BFu9s");
    static STRUCT_IF_C L_BFu7c_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_BFu9s, L_BFu7c_BFu9s)
//============================================================================



static void Test_L_BFu7c_C()
{
  {
    init_simple_test("L_BFu7c_C");
    static STRUCT_IF_C L_BFu7c_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_C)");
    check_field_offset(lv, v1, 0, "L_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_C");
    check_field_offset(lv, v3, 9, "L_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_C, L_BFu7c_C)
//============================================================================



static void Test_L_BFu7c_D()
{
  {
    init_simple_test("L_BFu7c_D");
    static STRUCT_IF_C L_BFu7c_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_D)");
    check_field_offset(lv, v1, 0, "L_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_D");
    check_field_offset(lv, v3, 9, "L_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_D, L_BFu7c_D)
//============================================================================



static void Test_L_BFu7c_F()
{
  {
    init_simple_test("L_BFu7c_F");
    static STRUCT_IF_C L_BFu7c_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_F)");
    check_field_offset(lv, v1, 0, "L_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_F");
    check_field_offset(lv, v3, 9, "L_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_F, L_BFu7c_F)
//============================================================================



static void Test_L_BFu7c_I()
{
  {
    init_simple_test("L_BFu7c_I");
    static STRUCT_IF_C L_BFu7c_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_I)");
    check_field_offset(lv, v1, 0, "L_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_I");
    check_field_offset(lv, v3, 9, "L_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_I, L_BFu7c_I)
//============================================================================



static void Test_L_BFu7c_Ip()
{
  {
    init_simple_test("L_BFu7c_Ip");
    static STRUCT_IF_C L_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_Ip");
    check_field_offset(lv, v3, 9, "L_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_Ip, L_BFu7c_Ip)
//============================================================================



static void Test_L_BFu7c_L()
{
  {
    init_simple_test("L_BFu7c_L");
    static STRUCT_IF_C L_BFu7c_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_L)");
    check_field_offset(lv, v1, 0, "L_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_L");
    check_field_offset(lv, v3, 9, "L_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_L, L_BFu7c_L)
//============================================================================



static void Test_L_BFu7c_S()
{
  {
    init_simple_test("L_BFu7c_S");
    static STRUCT_IF_C L_BFu7c_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_S)");
    check_field_offset(lv, v1, 0, "L_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_S");
    check_field_offset(lv, v3, 9, "L_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_S, L_BFu7c_S)
//============================================================================



static void Test_L_BFu7c_Uc()
{
  {
    init_simple_test("L_BFu7c_Uc");
    static STRUCT_IF_C L_BFu7c_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_Uc");
    check_field_offset(lv, v3, 9, "L_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_Uc, L_BFu7c_Uc)
//============================================================================



static void Test_L_BFu7c_Ui()
{
  {
    init_simple_test("L_BFu7c_Ui");
    static STRUCT_IF_C L_BFu7c_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_Ui");
    check_field_offset(lv, v3, 9, "L_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_Ui, L_BFu7c_Ui)
//============================================================================



static void Test_L_BFu7c_Ul()
{
  {
    init_simple_test("L_BFu7c_Ul");
    static STRUCT_IF_C L_BFu7c_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_Ul");
    check_field_offset(lv, v3, 9, "L_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_Ul, L_BFu7c_Ul)
//============================================================================



static void Test_L_BFu7c_Us()
{
  {
    init_simple_test("L_BFu7c_Us");
    static STRUCT_IF_C L_BFu7c_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "L_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_Us");
    check_field_offset(lv, v3, 9, "L_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_Us, L_BFu7c_Us)
//============================================================================



static void Test_L_BFu7c_Vp()
{
  {
    init_simple_test("L_BFu7c_Vp");
    static STRUCT_IF_C L_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7c_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7c_Vp");
    check_field_offset(lv, v3, 9, "L_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7c_Vp, L_BFu7c_Vp)
//============================================================================



static void Test_L_BFu7i()
{
  {
    init_simple_test("L_BFu7i");
    static STRUCT_IF_C L_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i, L_BFu7i)
//============================================================================



static void Test_L_BFu7i_BFu15i()
{
  {
    init_simple_test("L_BFu7i_BFu15i");
    static STRUCT_IF_C L_BFu7i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu15i, L_BFu7i_BFu15i)
//============================================================================



static void Test_L_BFu7i_BFu15ll()
{
  {
    init_simple_test("L_BFu7i_BFu15ll");
    static STRUCT_IF_C L_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu15ll, L_BFu7i_BFu15ll)
//============================================================================



static void Test_L_BFu7i_BFu15s()
{
  {
    init_simple_test("L_BFu7i_BFu15s");
    static STRUCT_IF_C L_BFu7i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu15s, L_BFu7i_BFu15s)
//============================================================================



static void Test_L_BFu7i_BFu16i()
{
  {
    init_simple_test("L_BFu7i_BFu16i");
    static STRUCT_IF_C L_BFu7i_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu16i, L_BFu7i_BFu16i)
//============================================================================



static void Test_L_BFu7i_BFu16ll()
{
  {
    init_simple_test("L_BFu7i_BFu16ll");
    static STRUCT_IF_C L_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu16ll, L_BFu7i_BFu16ll)
//============================================================================



static void Test_L_BFu7i_BFu16s()
{
  {
    init_simple_test("L_BFu7i_BFu16s");
    static STRUCT_IF_C L_BFu7i_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu16s, L_BFu7i_BFu16s)
//============================================================================



static void Test_L_BFu7i_BFu17i()
{
  {
    init_simple_test("L_BFu7i_BFu17i");
    static STRUCT_IF_C L_BFu7i_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu17i, L_BFu7i_BFu17i)
//============================================================================



static void Test_L_BFu7i_BFu17ll()
{
  {
    init_simple_test("L_BFu7i_BFu17ll");
    static STRUCT_IF_C L_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu17ll, L_BFu7i_BFu17ll)
//============================================================================



static void Test_L_BFu7i_BFu1c()
{
  {
    init_simple_test("L_BFu7i_BFu1c");
    static STRUCT_IF_C L_BFu7i_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu1c, L_BFu7i_BFu1c)
//============================================================================



static void Test_L_BFu7i_BFu1i()
{
  {
    init_simple_test("L_BFu7i_BFu1i");
    static STRUCT_IF_C L_BFu7i_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu1i, L_BFu7i_BFu1i)
//============================================================================



static void Test_L_BFu7i_BFu1ll()
{
  {
    init_simple_test("L_BFu7i_BFu1ll");
    static STRUCT_IF_C L_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu1ll, L_BFu7i_BFu1ll)
//============================================================================



static void Test_L_BFu7i_BFu1s()
{
  {
    init_simple_test("L_BFu7i_BFu1s");
    static STRUCT_IF_C L_BFu7i_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu1s, L_BFu7i_BFu1s)
//============================================================================



static void Test_L_BFu7i_BFu31i()
{
  {
    init_simple_test("L_BFu7i_BFu31i");
    static STRUCT_IF_C L_BFu7i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu31i, L_BFu7i_BFu31i)
//============================================================================



static void Test_L_BFu7i_BFu31ll()
{
  {
    init_simple_test("L_BFu7i_BFu31ll");
    static STRUCT_IF_C L_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu31ll, L_BFu7i_BFu31ll)
//============================================================================



static void Test_L_BFu7i_BFu32i()
{
  {
    init_simple_test("L_BFu7i_BFu32i");
    static STRUCT_IF_C L_BFu7i_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu32i, L_BFu7i_BFu32i)
//============================================================================



static void Test_L_BFu7i_BFu32ll()
{
  {
    init_simple_test("L_BFu7i_BFu32ll");
    static STRUCT_IF_C L_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu32ll, L_BFu7i_BFu32ll)
//============================================================================



static void Test_L_BFu7i_BFu33()
{
  {
    init_simple_test("L_BFu7i_BFu33");
    static STRUCT_IF_C L_BFu7i_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "L_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "L_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu33, L_BFu7i_BFu33)
//============================================================================



static void Test_L_BFu7i_BFu7c()
{
  {
    init_simple_test("L_BFu7i_BFu7c");
    static STRUCT_IF_C L_BFu7i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu7c, L_BFu7i_BFu7c)
//============================================================================



static void Test_L_BFu7i_BFu7i()
{
  {
    init_simple_test("L_BFu7i_BFu7i");
    static STRUCT_IF_C L_BFu7i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu7i, L_BFu7i_BFu7i)
//============================================================================



static void Test_L_BFu7i_BFu7ll()
{
  {
    init_simple_test("L_BFu7i_BFu7ll");
    static STRUCT_IF_C L_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu7ll, L_BFu7i_BFu7ll)
//============================================================================



static void Test_L_BFu7i_BFu7s()
{
  {
    init_simple_test("L_BFu7i_BFu7s");
    static STRUCT_IF_C L_BFu7i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu7s, L_BFu7i_BFu7s)
//============================================================================



static void Test_L_BFu7i_BFu8c()
{
  {
    init_simple_test("L_BFu7i_BFu8c");
    static STRUCT_IF_C L_BFu7i_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu8c, L_BFu7i_BFu8c)
//============================================================================



static void Test_L_BFu7i_BFu8i()
{
  {
    init_simple_test("L_BFu7i_BFu8i");
    static STRUCT_IF_C L_BFu7i_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu8i, L_BFu7i_BFu8i)
//============================================================================



static void Test_L_BFu7i_BFu8ll()
{
  {
    init_simple_test("L_BFu7i_BFu8ll");
    static STRUCT_IF_C L_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu8ll, L_BFu7i_BFu8ll)
//============================================================================



static void Test_L_BFu7i_BFu8s()
{
  {
    init_simple_test("L_BFu7i_BFu8s");
    static STRUCT_IF_C L_BFu7i_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu8s, L_BFu7i_BFu8s)
//============================================================================



static void Test_L_BFu7i_BFu9i()
{
  {
    init_simple_test("L_BFu7i_BFu9i");
    static STRUCT_IF_C L_BFu7i_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu9i, L_BFu7i_BFu9i)
//============================================================================



static void Test_L_BFu7i_BFu9ll()
{
  {
    init_simple_test("L_BFu7i_BFu9ll");
    static STRUCT_IF_C L_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu9ll, L_BFu7i_BFu9ll)
//============================================================================



static void Test_L_BFu7i_BFu9s()
{
  {
    init_simple_test("L_BFu7i_BFu9s");
    static STRUCT_IF_C L_BFu7i_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_BFu9s, L_BFu7i_BFu9s)
//============================================================================



static void Test_L_BFu7i_C()
{
  {
    init_simple_test("L_BFu7i_C");
    static STRUCT_IF_C L_BFu7i_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_C)");
    check_field_offset(lv, v1, 0, "L_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_C");
    check_field_offset(lv, v3, 9, "L_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_C, L_BFu7i_C)
//============================================================================



static void Test_L_BFu7i_D()
{
  {
    init_simple_test("L_BFu7i_D");
    static STRUCT_IF_C L_BFu7i_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_D)");
    check_field_offset(lv, v1, 0, "L_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_D");
    check_field_offset(lv, v3, 9, "L_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_D, L_BFu7i_D)
//============================================================================



static void Test_L_BFu7i_F()
{
  {
    init_simple_test("L_BFu7i_F");
    static STRUCT_IF_C L_BFu7i_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_F)");
    check_field_offset(lv, v1, 0, "L_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_F");
    check_field_offset(lv, v3, 9, "L_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_F, L_BFu7i_F)
//============================================================================



static void Test_L_BFu7i_I()
{
  {
    init_simple_test("L_BFu7i_I");
    static STRUCT_IF_C L_BFu7i_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_I)");
    check_field_offset(lv, v1, 0, "L_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_I");
    check_field_offset(lv, v3, 9, "L_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_I, L_BFu7i_I)
//============================================================================



static void Test_L_BFu7i_Ip()
{
  {
    init_simple_test("L_BFu7i_Ip");
    static STRUCT_IF_C L_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_Ip");
    check_field_offset(lv, v3, 9, "L_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_Ip, L_BFu7i_Ip)
//============================================================================



static void Test_L_BFu7i_L()
{
  {
    init_simple_test("L_BFu7i_L");
    static STRUCT_IF_C L_BFu7i_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_L)");
    check_field_offset(lv, v1, 0, "L_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_L");
    check_field_offset(lv, v3, 9, "L_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_L, L_BFu7i_L)
//============================================================================



static void Test_L_BFu7i_S()
{
  {
    init_simple_test("L_BFu7i_S");
    static STRUCT_IF_C L_BFu7i_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_S)");
    check_field_offset(lv, v1, 0, "L_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_S");
    check_field_offset(lv, v3, 9, "L_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_S, L_BFu7i_S)
//============================================================================



static void Test_L_BFu7i_Uc()
{
  {
    init_simple_test("L_BFu7i_Uc");
    static STRUCT_IF_C L_BFu7i_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_Uc");
    check_field_offset(lv, v3, 9, "L_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_Uc, L_BFu7i_Uc)
//============================================================================



static void Test_L_BFu7i_Ui()
{
  {
    init_simple_test("L_BFu7i_Ui");
    static STRUCT_IF_C L_BFu7i_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_Ui");
    check_field_offset(lv, v3, 9, "L_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_Ui, L_BFu7i_Ui)
//============================================================================



static void Test_L_BFu7i_Ul()
{
  {
    init_simple_test("L_BFu7i_Ul");
    static STRUCT_IF_C L_BFu7i_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_Ul");
    check_field_offset(lv, v3, 9, "L_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_Ul, L_BFu7i_Ul)
//============================================================================



static void Test_L_BFu7i_Us()
{
  {
    init_simple_test("L_BFu7i_Us");
    static STRUCT_IF_C L_BFu7i_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "L_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_Us");
    check_field_offset(lv, v3, 9, "L_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_Us, L_BFu7i_Us)
//============================================================================



static void Test_L_BFu7i_Vp()
{
  {
    init_simple_test("L_BFu7i_Vp");
    static STRUCT_IF_C L_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7i_Vp");
    check_field_offset(lv, v3, 9, "L_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7i_Vp, L_BFu7i_Vp)
//============================================================================



static void Test_L_BFu7ll()
{
  {
    init_simple_test("L_BFu7ll");
    static STRUCT_IF_C L_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll, L_BFu7ll)
//============================================================================



static void Test_L_BFu7ll_BFu15i()
{
  {
    init_simple_test("L_BFu7ll_BFu15i");
    static STRUCT_IF_C L_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu15i, L_BFu7ll_BFu15i)
//============================================================================



static void Test_L_BFu7ll_BFu15ll()
{
  {
    init_simple_test("L_BFu7ll_BFu15ll");
    static STRUCT_IF_C L_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu15ll, L_BFu7ll_BFu15ll)
//============================================================================



static void Test_L_BFu7ll_BFu15s()
{
  {
    init_simple_test("L_BFu7ll_BFu15s");
    static STRUCT_IF_C L_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu15s, L_BFu7ll_BFu15s)
//============================================================================



static void Test_L_BFu7ll_BFu16i()
{
  {
    init_simple_test("L_BFu7ll_BFu16i");
    static STRUCT_IF_C L_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu16i, L_BFu7ll_BFu16i)
//============================================================================



static void Test_L_BFu7ll_BFu16ll()
{
  {
    init_simple_test("L_BFu7ll_BFu16ll");
    static STRUCT_IF_C L_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu16ll, L_BFu7ll_BFu16ll)
//============================================================================



static void Test_L_BFu7ll_BFu16s()
{
  {
    init_simple_test("L_BFu7ll_BFu16s");
    static STRUCT_IF_C L_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu16s, L_BFu7ll_BFu16s)
//============================================================================



static void Test_L_BFu7ll_BFu17i()
{
  {
    init_simple_test("L_BFu7ll_BFu17i");
    static STRUCT_IF_C L_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu17i, L_BFu7ll_BFu17i)
//============================================================================



static void Test_L_BFu7ll_BFu17ll()
{
  {
    init_simple_test("L_BFu7ll_BFu17ll");
    static STRUCT_IF_C L_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu17ll, L_BFu7ll_BFu17ll)
//============================================================================



static void Test_L_BFu7ll_BFu1c()
{
  {
    init_simple_test("L_BFu7ll_BFu1c");
    static STRUCT_IF_C L_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu1c, L_BFu7ll_BFu1c)
//============================================================================



static void Test_L_BFu7ll_BFu1i()
{
  {
    init_simple_test("L_BFu7ll_BFu1i");
    static STRUCT_IF_C L_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu1i, L_BFu7ll_BFu1i)
//============================================================================



static void Test_L_BFu7ll_BFu1ll()
{
  {
    init_simple_test("L_BFu7ll_BFu1ll");
    static STRUCT_IF_C L_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu1ll, L_BFu7ll_BFu1ll)
//============================================================================



static void Test_L_BFu7ll_BFu1s()
{
  {
    init_simple_test("L_BFu7ll_BFu1s");
    static STRUCT_IF_C L_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu1s, L_BFu7ll_BFu1s)
//============================================================================



static void Test_L_BFu7ll_BFu31i()
{
  {
    init_simple_test("L_BFu7ll_BFu31i");
    static STRUCT_IF_C L_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu31i, L_BFu7ll_BFu31i)
//============================================================================



static void Test_L_BFu7ll_BFu31ll()
{
  {
    init_simple_test("L_BFu7ll_BFu31ll");
    static STRUCT_IF_C L_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu31ll, L_BFu7ll_BFu31ll)
//============================================================================



static void Test_L_BFu7ll_BFu32i()
{
  {
    init_simple_test("L_BFu7ll_BFu32i");
    static STRUCT_IF_C L_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu32i, L_BFu7ll_BFu32i)
//============================================================================



static void Test_L_BFu7ll_BFu32ll()
{
  {
    init_simple_test("L_BFu7ll_BFu32ll");
    static STRUCT_IF_C L_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu32ll, L_BFu7ll_BFu32ll)
//============================================================================



static void Test_L_BFu7ll_BFu33()
{
  {
    init_simple_test("L_BFu7ll_BFu33");
    static STRUCT_IF_C L_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "L_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "L_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu33, L_BFu7ll_BFu33)
//============================================================================



static void Test_L_BFu7ll_BFu7c()
{
  {
    init_simple_test("L_BFu7ll_BFu7c");
    static STRUCT_IF_C L_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu7c, L_BFu7ll_BFu7c)
//============================================================================



static void Test_L_BFu7ll_BFu7i()
{
  {
    init_simple_test("L_BFu7ll_BFu7i");
    static STRUCT_IF_C L_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu7i, L_BFu7ll_BFu7i)
//============================================================================



static void Test_L_BFu7ll_BFu7ll()
{
  {
    init_simple_test("L_BFu7ll_BFu7ll");
    static STRUCT_IF_C L_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu7ll, L_BFu7ll_BFu7ll)
//============================================================================



static void Test_L_BFu7ll_BFu7s()
{
  {
    init_simple_test("L_BFu7ll_BFu7s");
    static STRUCT_IF_C L_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu7s, L_BFu7ll_BFu7s)
//============================================================================



static void Test_L_BFu7ll_BFu8c()
{
  {
    init_simple_test("L_BFu7ll_BFu8c");
    static STRUCT_IF_C L_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu8c, L_BFu7ll_BFu8c)
//============================================================================



static void Test_L_BFu7ll_BFu8i()
{
  {
    init_simple_test("L_BFu7ll_BFu8i");
    static STRUCT_IF_C L_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu8i, L_BFu7ll_BFu8i)
//============================================================================



static void Test_L_BFu7ll_BFu8ll()
{
  {
    init_simple_test("L_BFu7ll_BFu8ll");
    static STRUCT_IF_C L_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu8ll, L_BFu7ll_BFu8ll)
//============================================================================



static void Test_L_BFu7ll_BFu8s()
{
  {
    init_simple_test("L_BFu7ll_BFu8s");
    static STRUCT_IF_C L_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu8s, L_BFu7ll_BFu8s)
//============================================================================



static void Test_L_BFu7ll_BFu9i()
{
  {
    init_simple_test("L_BFu7ll_BFu9i");
    static STRUCT_IF_C L_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu9i, L_BFu7ll_BFu9i)
//============================================================================



static void Test_L_BFu7ll_BFu9ll()
{
  {
    init_simple_test("L_BFu7ll_BFu9ll");
    static STRUCT_IF_C L_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu9ll, L_BFu7ll_BFu9ll)
//============================================================================



static void Test_L_BFu7ll_BFu9s()
{
  {
    init_simple_test("L_BFu7ll_BFu9s");
    static STRUCT_IF_C L_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_BFu9s, L_BFu7ll_BFu9s)
//============================================================================



static void Test_L_BFu7ll_C()
{
  {
    init_simple_test("L_BFu7ll_C");
    static STRUCT_IF_C L_BFu7ll_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_C");
    check_field_offset(lv, v3, 9, "L_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_C, L_BFu7ll_C)
//============================================================================



static void Test_L_BFu7ll_D()
{
  {
    init_simple_test("L_BFu7ll_D");
    static STRUCT_IF_C L_BFu7ll_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_D");
    check_field_offset(lv, v3, 9, "L_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_D, L_BFu7ll_D)
//============================================================================



static void Test_L_BFu7ll_F()
{
  {
    init_simple_test("L_BFu7ll_F");
    static STRUCT_IF_C L_BFu7ll_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_F");
    check_field_offset(lv, v3, 9, "L_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_F, L_BFu7ll_F)
//============================================================================



static void Test_L_BFu7ll_I()
{
  {
    init_simple_test("L_BFu7ll_I");
    static STRUCT_IF_C L_BFu7ll_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_I");
    check_field_offset(lv, v3, 9, "L_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_I, L_BFu7ll_I)
//============================================================================



static void Test_L_BFu7ll_Ip()
{
  {
    init_simple_test("L_BFu7ll_Ip");
    static STRUCT_IF_C L_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_Ip");
    check_field_offset(lv, v3, 9, "L_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_Ip, L_BFu7ll_Ip)
//============================================================================



static void Test_L_BFu7ll_L()
{
  {
    init_simple_test("L_BFu7ll_L");
    static STRUCT_IF_C L_BFu7ll_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_L");
    check_field_offset(lv, v3, 9, "L_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_L, L_BFu7ll_L)
//============================================================================



static void Test_L_BFu7ll_S()
{
  {
    init_simple_test("L_BFu7ll_S");
    static STRUCT_IF_C L_BFu7ll_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_S");
    check_field_offset(lv, v3, 9, "L_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_S, L_BFu7ll_S)
//============================================================================



static void Test_L_BFu7ll_Uc()
{
  {
    init_simple_test("L_BFu7ll_Uc");
    static STRUCT_IF_C L_BFu7ll_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_Uc");
    check_field_offset(lv, v3, 9, "L_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_Uc, L_BFu7ll_Uc)
//============================================================================



static void Test_L_BFu7ll_Ui()
{
  {
    init_simple_test("L_BFu7ll_Ui");
    static STRUCT_IF_C L_BFu7ll_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_Ui");
    check_field_offset(lv, v3, 9, "L_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_Ui, L_BFu7ll_Ui)
//============================================================================



static void Test_L_BFu7ll_Ul()
{
  {
    init_simple_test("L_BFu7ll_Ul");
    static STRUCT_IF_C L_BFu7ll_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_Ul");
    check_field_offset(lv, v3, 9, "L_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_Ul, L_BFu7ll_Ul)
//============================================================================



static void Test_L_BFu7ll_Us()
{
  {
    init_simple_test("L_BFu7ll_Us");
    static STRUCT_IF_C L_BFu7ll_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_Us");
    check_field_offset(lv, v3, 9, "L_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_Us, L_BFu7ll_Us)
//============================================================================



static void Test_L_BFu7ll_Vp()
{
  {
    init_simple_test("L_BFu7ll_Vp");
    static STRUCT_IF_C L_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7ll_Vp");
    check_field_offset(lv, v3, 9, "L_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7ll_Vp, L_BFu7ll_Vp)
//============================================================================



static void Test_L_BFu7s()
{
  {
    init_simple_test("L_BFu7s");
    static STRUCT_IF_C L_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s, L_BFu7s)
//============================================================================



static void Test_L_BFu7s_BFu15i()
{
  {
    init_simple_test("L_BFu7s_BFu15i");
    static STRUCT_IF_C L_BFu7s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu15i, L_BFu7s_BFu15i)
//============================================================================



static void Test_L_BFu7s_BFu15ll()
{
  {
    init_simple_test("L_BFu7s_BFu15ll");
    static STRUCT_IF_C L_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu15ll, L_BFu7s_BFu15ll)
//============================================================================



static void Test_L_BFu7s_BFu15s()
{
  {
    init_simple_test("L_BFu7s_BFu15s");
    static STRUCT_IF_C L_BFu7s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, 1, "L_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 8, 7, 15, hide_ull(1LL<<14), "L_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu15s, L_BFu7s_BFu15s)
//============================================================================



static void Test_L_BFu7s_BFu16i()
{
  {
    init_simple_test("L_BFu7s_BFu16i");
    static STRUCT_IF_C L_BFu7s_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu16i, L_BFu7s_BFu16i)
//============================================================================



static void Test_L_BFu7s_BFu16ll()
{
  {
    init_simple_test("L_BFu7s_BFu16ll");
    static STRUCT_IF_C L_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu16ll, L_BFu7s_BFu16ll)
//============================================================================



static void Test_L_BFu7s_BFu16s()
{
  {
    init_simple_test("L_BFu7s_BFu16s");
    static STRUCT_IF_C L_BFu7s_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, 1, "L_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 8, 7, 16, hide_ull(1LL<<15), "L_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu16s, L_BFu7s_BFu16s)
//============================================================================



static void Test_L_BFu7s_BFu17i()
{
  {
    init_simple_test("L_BFu7s_BFu17i");
    static STRUCT_IF_C L_BFu7s_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu17i, L_BFu7s_BFu17i)
//============================================================================



static void Test_L_BFu7s_BFu17ll()
{
  {
    init_simple_test("L_BFu7s_BFu17ll");
    static STRUCT_IF_C L_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, 1, "L_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 8, 7, 17, hide_ull(1LL<<16), "L_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu17ll, L_BFu7s_BFu17ll)
//============================================================================



static void Test_L_BFu7s_BFu1c()
{
  {
    init_simple_test("L_BFu7s_BFu1c");
    static STRUCT_IF_C L_BFu7s_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu1c, L_BFu7s_BFu1c)
//============================================================================



static void Test_L_BFu7s_BFu1i()
{
  {
    init_simple_test("L_BFu7s_BFu1i");
    static STRUCT_IF_C L_BFu7s_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu1i, L_BFu7s_BFu1i)
//============================================================================



static void Test_L_BFu7s_BFu1ll()
{
  {
    init_simple_test("L_BFu7s_BFu1ll");
    static STRUCT_IF_C L_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu1ll, L_BFu7s_BFu1ll)
//============================================================================



static void Test_L_BFu7s_BFu1s()
{
  {
    init_simple_test("L_BFu7s_BFu1s");
    static STRUCT_IF_C L_BFu7s_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 8, 7, 1, 1, "L_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu1s, L_BFu7s_BFu1s)
//============================================================================



static void Test_L_BFu7s_BFu31i()
{
  {
    init_simple_test("L_BFu7s_BFu31i");
    static STRUCT_IF_C L_BFu7s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu31i, L_BFu7s_BFu31i)
//============================================================================



static void Test_L_BFu7s_BFu31ll()
{
  {
    init_simple_test("L_BFu7s_BFu31ll");
    static STRUCT_IF_C L_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, 1, "L_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 8, 7, 31, hide_ull(1LL<<30), "L_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu31ll, L_BFu7s_BFu31ll)
//============================================================================



static void Test_L_BFu7s_BFu32i()
{
  {
    init_simple_test("L_BFu7s_BFu32i");
    static STRUCT_IF_C L_BFu7s_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu32i, L_BFu7s_BFu32i)
//============================================================================



static void Test_L_BFu7s_BFu32ll()
{
  {
    init_simple_test("L_BFu7s_BFu32ll");
    static STRUCT_IF_C L_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, 1, "L_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 8, 7, 32, hide_ull(1LL<<31), "L_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu32ll, L_BFu7s_BFu32ll)
//============================================================================



static void Test_L_BFu7s_BFu33()
{
  {
    init_simple_test("L_BFu7s_BFu33");
    static STRUCT_IF_C L_BFu7s_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, 1, "L_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 8, 7, 33, hide_ull(1LL<<32), "L_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu33, L_BFu7s_BFu33)
//============================================================================



static void Test_L_BFu7s_BFu7c()
{
  {
    init_simple_test("L_BFu7s_BFu7c");
    static STRUCT_IF_C L_BFu7s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu7c, L_BFu7s_BFu7c)
//============================================================================



static void Test_L_BFu7s_BFu7i()
{
  {
    init_simple_test("L_BFu7s_BFu7i");
    static STRUCT_IF_C L_BFu7s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu7i, L_BFu7s_BFu7i)
//============================================================================



static void Test_L_BFu7s_BFu7ll()
{
  {
    init_simple_test("L_BFu7s_BFu7ll");
    static STRUCT_IF_C L_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu7ll, L_BFu7s_BFu7ll)
//============================================================================



static void Test_L_BFu7s_BFu7s()
{
  {
    init_simple_test("L_BFu7s_BFu7s");
    static STRUCT_IF_C L_BFu7s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, 1, "L_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 8, 7, 7, hide_ull(1LL<<6), "L_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu7s, L_BFu7s_BFu7s)
//============================================================================



static void Test_L_BFu7s_BFu8c()
{
  {
    init_simple_test("L_BFu7s_BFu8c");
    static STRUCT_IF_C L_BFu7s_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu8c, L_BFu7s_BFu8c)
//============================================================================



static void Test_L_BFu7s_BFu8i()
{
  {
    init_simple_test("L_BFu7s_BFu8i");
    static STRUCT_IF_C L_BFu7s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu8i, L_BFu7s_BFu8i)
//============================================================================



static void Test_L_BFu7s_BFu8ll()
{
  {
    init_simple_test("L_BFu7s_BFu8ll");
    static STRUCT_IF_C L_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu8ll, L_BFu7s_BFu8ll)
//============================================================================



static void Test_L_BFu7s_BFu8s()
{
  {
    init_simple_test("L_BFu7s_BFu8s");
    static STRUCT_IF_C L_BFu7s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, 1, "L_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 8, 7, 8, hide_ull(1LL<<7), "L_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu8s, L_BFu7s_BFu8s)
//============================================================================



static void Test_L_BFu7s_BFu9i()
{
  {
    init_simple_test("L_BFu7s_BFu9i");
    static STRUCT_IF_C L_BFu7s_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu9i, L_BFu7s_BFu9i)
//============================================================================



static void Test_L_BFu7s_BFu9ll()
{
  {
    init_simple_test("L_BFu7s_BFu9ll");
    static STRUCT_IF_C L_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu9ll, L_BFu7s_BFu9ll)
//============================================================================



static void Test_L_BFu7s_BFu9s()
{
  {
    init_simple_test("L_BFu7s_BFu9s");
    static STRUCT_IF_C L_BFu7s_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, 1, "L_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 8, 7, 9, hide_ull(1LL<<8), "L_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_BFu9s, L_BFu7s_BFu9s)
//============================================================================



static void Test_L_BFu7s_C()
{
  {
    init_simple_test("L_BFu7s_C");
    static STRUCT_IF_C L_BFu7s_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_C)");
    check_field_offset(lv, v1, 0, "L_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_C");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_C");
    check_field_offset(lv, v3, 9, "L_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_C, L_BFu7s_C)
//============================================================================



static void Test_L_BFu7s_D()
{
  {
    init_simple_test("L_BFu7s_D");
    static STRUCT_IF_C L_BFu7s_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_D)");
    check_field_offset(lv, v1, 0, "L_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_D");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_D");
    check_field_offset(lv, v3, 9, "L_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_D, L_BFu7s_D)
//============================================================================



static void Test_L_BFu7s_F()
{
  {
    init_simple_test("L_BFu7s_F");
    static STRUCT_IF_C L_BFu7s_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_F)");
    check_field_offset(lv, v1, 0, "L_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_F");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_F");
    check_field_offset(lv, v3, 9, "L_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_F, L_BFu7s_F)
//============================================================================



static void Test_L_BFu7s_I()
{
  {
    init_simple_test("L_BFu7s_I");
    static STRUCT_IF_C L_BFu7s_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_I)");
    check_field_offset(lv, v1, 0, "L_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_I");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_I");
    check_field_offset(lv, v3, 9, "L_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_I, L_BFu7s_I)
//============================================================================



static void Test_L_BFu7s_Ip()
{
  {
    init_simple_test("L_BFu7s_Ip");
    static STRUCT_IF_C L_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_Ip");
    check_field_offset(lv, v3, 9, "L_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_Ip, L_BFu7s_Ip)
//============================================================================



static void Test_L_BFu7s_L()
{
  {
    init_simple_test("L_BFu7s_L");
    static STRUCT_IF_C L_BFu7s_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_L)");
    check_field_offset(lv, v1, 0, "L_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_L");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_L");
    check_field_offset(lv, v3, 9, "L_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_L, L_BFu7s_L)
//============================================================================



static void Test_L_BFu7s_S()
{
  {
    init_simple_test("L_BFu7s_S");
    static STRUCT_IF_C L_BFu7s_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_S)");
    check_field_offset(lv, v1, 0, "L_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_S");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_S");
    check_field_offset(lv, v3, 9, "L_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_S, L_BFu7s_S)
//============================================================================



static void Test_L_BFu7s_Uc()
{
  {
    init_simple_test("L_BFu7s_Uc");
    static STRUCT_IF_C L_BFu7s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_Uc");
    check_field_offset(lv, v3, 9, "L_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_Uc, L_BFu7s_Uc)
//============================================================================



static void Test_L_BFu7s_Ui()
{
  {
    init_simple_test("L_BFu7s_Ui");
    static STRUCT_IF_C L_BFu7s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_Ui");
    check_field_offset(lv, v3, 9, "L_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_Ui, L_BFu7s_Ui)
//============================================================================



static void Test_L_BFu7s_Ul()
{
  {
    init_simple_test("L_BFu7s_Ul");
    static STRUCT_IF_C L_BFu7s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_Ul");
    check_field_offset(lv, v3, 9, "L_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_Ul, L_BFu7s_Ul)
//============================================================================



static void Test_L_BFu7s_Us()
{
  {
    init_simple_test("L_BFu7s_Us");
    static STRUCT_IF_C L_BFu7s_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "L_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_Us");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_Us");
    check_field_offset(lv, v3, 9, "L_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_Us, L_BFu7s_Us)
//============================================================================



static void Test_L_BFu7s_Vp()
{
  {
    init_simple_test("L_BFu7s_Vp");
    static STRUCT_IF_C L_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "L_BFu7s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "L_BFu7s_Vp");
    check_field_offset(lv, v3, 9, "L_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu7s_Vp, L_BFu7s_Vp)
//============================================================================



static void Test_L_BFu8c()
{
  {
    init_simple_test("L_BFu8c");
    static STRUCT_IF_C L_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c, L_BFu8c)
//============================================================================



static void Test_L_BFu8c_BFu15i()
{
  {
    init_simple_test("L_BFu8c_BFu15i");
    static STRUCT_IF_C L_BFu8c_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu15i, L_BFu8c_BFu15i)
//============================================================================



static void Test_L_BFu8c_BFu15ll()
{
  {
    init_simple_test("L_BFu8c_BFu15ll");
    static STRUCT_IF_C L_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu15ll, L_BFu8c_BFu15ll)
//============================================================================



static void Test_L_BFu8c_BFu15s()
{
  {
    init_simple_test("L_BFu8c_BFu15s");
    static STRUCT_IF_C L_BFu8c_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu15s, L_BFu8c_BFu15s)
//============================================================================



static void Test_L_BFu8c_BFu16i()
{
  {
    init_simple_test("L_BFu8c_BFu16i");
    static STRUCT_IF_C L_BFu8c_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu16i, L_BFu8c_BFu16i)
//============================================================================



static void Test_L_BFu8c_BFu16ll()
{
  {
    init_simple_test("L_BFu8c_BFu16ll");
    static STRUCT_IF_C L_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu16ll, L_BFu8c_BFu16ll)
//============================================================================



static void Test_L_BFu8c_BFu16s()
{
  {
    init_simple_test("L_BFu8c_BFu16s");
    static STRUCT_IF_C L_BFu8c_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu16s, L_BFu8c_BFu16s)
//============================================================================



static void Test_L_BFu8c_BFu17i()
{
  {
    init_simple_test("L_BFu8c_BFu17i");
    static STRUCT_IF_C L_BFu8c_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu17i, L_BFu8c_BFu17i)
//============================================================================



static void Test_L_BFu8c_BFu17ll()
{
  {
    init_simple_test("L_BFu8c_BFu17ll");
    static STRUCT_IF_C L_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu17ll, L_BFu8c_BFu17ll)
//============================================================================



static void Test_L_BFu8c_BFu1c()
{
  {
    init_simple_test("L_BFu8c_BFu1c");
    static STRUCT_IF_C L_BFu8c_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu1c, L_BFu8c_BFu1c)
//============================================================================



static void Test_L_BFu8c_BFu1i()
{
  {
    init_simple_test("L_BFu8c_BFu1i");
    static STRUCT_IF_C L_BFu8c_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu1i, L_BFu8c_BFu1i)
//============================================================================



static void Test_L_BFu8c_BFu1ll()
{
  {
    init_simple_test("L_BFu8c_BFu1ll");
    static STRUCT_IF_C L_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu1ll, L_BFu8c_BFu1ll)
//============================================================================



static void Test_L_BFu8c_BFu1s()
{
  {
    init_simple_test("L_BFu8c_BFu1s");
    static STRUCT_IF_C L_BFu8c_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu1s, L_BFu8c_BFu1s)
//============================================================================



static void Test_L_BFu8c_BFu31i()
{
  {
    init_simple_test("L_BFu8c_BFu31i");
    static STRUCT_IF_C L_BFu8c_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu31i, L_BFu8c_BFu31i)
//============================================================================



static void Test_L_BFu8c_BFu31ll()
{
  {
    init_simple_test("L_BFu8c_BFu31ll");
    static STRUCT_IF_C L_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu31ll, L_BFu8c_BFu31ll)
//============================================================================



static void Test_L_BFu8c_BFu32i()
{
  {
    init_simple_test("L_BFu8c_BFu32i");
    static STRUCT_IF_C L_BFu8c_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu32i, L_BFu8c_BFu32i)
//============================================================================



static void Test_L_BFu8c_BFu32ll()
{
  {
    init_simple_test("L_BFu8c_BFu32ll");
    static STRUCT_IF_C L_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu32ll, L_BFu8c_BFu32ll)
//============================================================================



static void Test_L_BFu8c_BFu33()
{
  {
    init_simple_test("L_BFu8c_BFu33");
    static STRUCT_IF_C L_BFu8c_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "L_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "L_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu33, L_BFu8c_BFu33)
//============================================================================



static void Test_L_BFu8c_BFu7c()
{
  {
    init_simple_test("L_BFu8c_BFu7c");
    static STRUCT_IF_C L_BFu8c_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu7c, L_BFu8c_BFu7c)
//============================================================================



static void Test_L_BFu8c_BFu7i()
{
  {
    init_simple_test("L_BFu8c_BFu7i");
    static STRUCT_IF_C L_BFu8c_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu7i, L_BFu8c_BFu7i)
//============================================================================



static void Test_L_BFu8c_BFu7ll()
{
  {
    init_simple_test("L_BFu8c_BFu7ll");
    static STRUCT_IF_C L_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu7ll, L_BFu8c_BFu7ll)
//============================================================================



static void Test_L_BFu8c_BFu7s()
{
  {
    init_simple_test("L_BFu8c_BFu7s");
    static STRUCT_IF_C L_BFu8c_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu7s, L_BFu8c_BFu7s)
//============================================================================



static void Test_L_BFu8c_BFu8c()
{
  {
    init_simple_test("L_BFu8c_BFu8c");
    static STRUCT_IF_C L_BFu8c_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu8c, L_BFu8c_BFu8c)
//============================================================================



static void Test_L_BFu8c_BFu8i()
{
  {
    init_simple_test("L_BFu8c_BFu8i");
    static STRUCT_IF_C L_BFu8c_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu8i, L_BFu8c_BFu8i)
//============================================================================



static void Test_L_BFu8c_BFu8ll()
{
  {
    init_simple_test("L_BFu8c_BFu8ll");
    static STRUCT_IF_C L_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu8ll, L_BFu8c_BFu8ll)
//============================================================================



static void Test_L_BFu8c_BFu8s()
{
  {
    init_simple_test("L_BFu8c_BFu8s");
    static STRUCT_IF_C L_BFu8c_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu8s, L_BFu8c_BFu8s)
//============================================================================



static void Test_L_BFu8c_BFu9i()
{
  {
    init_simple_test("L_BFu8c_BFu9i");
    static STRUCT_IF_C L_BFu8c_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu9i, L_BFu8c_BFu9i)
//============================================================================



static void Test_L_BFu8c_BFu9ll()
{
  {
    init_simple_test("L_BFu8c_BFu9ll");
    static STRUCT_IF_C L_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu9ll, L_BFu8c_BFu9ll)
//============================================================================



static void Test_L_BFu8c_BFu9s()
{
  {
    init_simple_test("L_BFu8c_BFu9s");
    static STRUCT_IF_C L_BFu8c_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_BFu9s, L_BFu8c_BFu9s)
//============================================================================



static void Test_L_BFu8c_C()
{
  {
    init_simple_test("L_BFu8c_C");
    static STRUCT_IF_C L_BFu8c_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_C)");
    check_field_offset(lv, v1, 0, "L_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_C");
    check_field_offset(lv, v3, 9, "L_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_C, L_BFu8c_C)
//============================================================================



static void Test_L_BFu8c_D()
{
  {
    init_simple_test("L_BFu8c_D");
    static STRUCT_IF_C L_BFu8c_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_D)");
    check_field_offset(lv, v1, 0, "L_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_D");
    check_field_offset(lv, v3, 9, "L_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_D, L_BFu8c_D)
//============================================================================



static void Test_L_BFu8c_F()
{
  {
    init_simple_test("L_BFu8c_F");
    static STRUCT_IF_C L_BFu8c_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_F)");
    check_field_offset(lv, v1, 0, "L_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_F");
    check_field_offset(lv, v3, 9, "L_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_F, L_BFu8c_F)
//============================================================================



static void Test_L_BFu8c_I()
{
  {
    init_simple_test("L_BFu8c_I");
    static STRUCT_IF_C L_BFu8c_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_I)");
    check_field_offset(lv, v1, 0, "L_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_I");
    check_field_offset(lv, v3, 9, "L_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_I, L_BFu8c_I)
//============================================================================



static void Test_L_BFu8c_Ip()
{
  {
    init_simple_test("L_BFu8c_Ip");
    static STRUCT_IF_C L_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_Ip");
    check_field_offset(lv, v3, 9, "L_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_Ip, L_BFu8c_Ip)
//============================================================================



static void Test_L_BFu8c_L()
{
  {
    init_simple_test("L_BFu8c_L");
    static STRUCT_IF_C L_BFu8c_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_L)");
    check_field_offset(lv, v1, 0, "L_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_L");
    check_field_offset(lv, v3, 9, "L_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_L, L_BFu8c_L)
//============================================================================



static void Test_L_BFu8c_S()
{
  {
    init_simple_test("L_BFu8c_S");
    static STRUCT_IF_C L_BFu8c_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_S)");
    check_field_offset(lv, v1, 0, "L_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_S");
    check_field_offset(lv, v3, 9, "L_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_S, L_BFu8c_S)
//============================================================================



static void Test_L_BFu8c_Uc()
{
  {
    init_simple_test("L_BFu8c_Uc");
    static STRUCT_IF_C L_BFu8c_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_Uc");
    check_field_offset(lv, v3, 9, "L_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_Uc, L_BFu8c_Uc)
//============================================================================



static void Test_L_BFu8c_Ui()
{
  {
    init_simple_test("L_BFu8c_Ui");
    static STRUCT_IF_C L_BFu8c_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_Ui");
    check_field_offset(lv, v3, 9, "L_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_Ui, L_BFu8c_Ui)
//============================================================================



static void Test_L_BFu8c_Ul()
{
  {
    init_simple_test("L_BFu8c_Ul");
    static STRUCT_IF_C L_BFu8c_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_Ul");
    check_field_offset(lv, v3, 9, "L_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_Ul, L_BFu8c_Ul)
//============================================================================



static void Test_L_BFu8c_Us()
{
  {
    init_simple_test("L_BFu8c_Us");
    static STRUCT_IF_C L_BFu8c_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "L_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_Us");
    check_field_offset(lv, v3, 9, "L_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_Us, L_BFu8c_Us)
//============================================================================



static void Test_L_BFu8c_Vp()
{
  {
    init_simple_test("L_BFu8c_Vp");
    static STRUCT_IF_C L_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_Vp");
    check_field_offset(lv, v3, 9, "L_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8c_Vp, L_BFu8c_Vp)
//============================================================================



static void Test_L_BFu8i()
{
  {
    init_simple_test("L_BFu8i");
    static STRUCT_IF_C L_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i, L_BFu8i)
//============================================================================



static void Test_L_BFu8i_BFu15i()
{
  {
    init_simple_test("L_BFu8i_BFu15i");
    static STRUCT_IF_C L_BFu8i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu15i, L_BFu8i_BFu15i)
//============================================================================



static void Test_L_BFu8i_BFu15ll()
{
  {
    init_simple_test("L_BFu8i_BFu15ll");
    static STRUCT_IF_C L_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu15ll, L_BFu8i_BFu15ll)
//============================================================================



static void Test_L_BFu8i_BFu15s()
{
  {
    init_simple_test("L_BFu8i_BFu15s");
    static STRUCT_IF_C L_BFu8i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu15s, L_BFu8i_BFu15s)
//============================================================================



static void Test_L_BFu8i_BFu16i()
{
  {
    init_simple_test("L_BFu8i_BFu16i");
    static STRUCT_IF_C L_BFu8i_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu16i, L_BFu8i_BFu16i)
//============================================================================



static void Test_L_BFu8i_BFu16ll()
{
  {
    init_simple_test("L_BFu8i_BFu16ll");
    static STRUCT_IF_C L_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu16ll, L_BFu8i_BFu16ll)
//============================================================================



static void Test_L_BFu8i_BFu16s()
{
  {
    init_simple_test("L_BFu8i_BFu16s");
    static STRUCT_IF_C L_BFu8i_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu16s, L_BFu8i_BFu16s)
//============================================================================



static void Test_L_BFu8i_BFu17i()
{
  {
    init_simple_test("L_BFu8i_BFu17i");
    static STRUCT_IF_C L_BFu8i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu17i, L_BFu8i_BFu17i)
//============================================================================



static void Test_L_BFu8i_BFu17ll()
{
  {
    init_simple_test("L_BFu8i_BFu17ll");
    static STRUCT_IF_C L_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu17ll, L_BFu8i_BFu17ll)
//============================================================================



static void Test_L_BFu8i_BFu1c()
{
  {
    init_simple_test("L_BFu8i_BFu1c");
    static STRUCT_IF_C L_BFu8i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu1c, L_BFu8i_BFu1c)
//============================================================================



static void Test_L_BFu8i_BFu1i()
{
  {
    init_simple_test("L_BFu8i_BFu1i");
    static STRUCT_IF_C L_BFu8i_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu1i, L_BFu8i_BFu1i)
//============================================================================



static void Test_L_BFu8i_BFu1ll()
{
  {
    init_simple_test("L_BFu8i_BFu1ll");
    static STRUCT_IF_C L_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu1ll, L_BFu8i_BFu1ll)
//============================================================================



static void Test_L_BFu8i_BFu1s()
{
  {
    init_simple_test("L_BFu8i_BFu1s");
    static STRUCT_IF_C L_BFu8i_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu1s, L_BFu8i_BFu1s)
//============================================================================



static void Test_L_BFu8i_BFu31i()
{
  {
    init_simple_test("L_BFu8i_BFu31i");
    static STRUCT_IF_C L_BFu8i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu31i, L_BFu8i_BFu31i)
//============================================================================



static void Test_L_BFu8i_BFu31ll()
{
  {
    init_simple_test("L_BFu8i_BFu31ll");
    static STRUCT_IF_C L_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu31ll, L_BFu8i_BFu31ll)
//============================================================================



static void Test_L_BFu8i_BFu32i()
{
  {
    init_simple_test("L_BFu8i_BFu32i");
    static STRUCT_IF_C L_BFu8i_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu32i, L_BFu8i_BFu32i)
//============================================================================



static void Test_L_BFu8i_BFu32ll()
{
  {
    init_simple_test("L_BFu8i_BFu32ll");
    static STRUCT_IF_C L_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu32ll, L_BFu8i_BFu32ll)
//============================================================================



static void Test_L_BFu8i_BFu33()
{
  {
    init_simple_test("L_BFu8i_BFu33");
    static STRUCT_IF_C L_BFu8i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "L_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "L_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu33, L_BFu8i_BFu33)
//============================================================================



static void Test_L_BFu8i_BFu7c()
{
  {
    init_simple_test("L_BFu8i_BFu7c");
    static STRUCT_IF_C L_BFu8i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu7c, L_BFu8i_BFu7c)
//============================================================================



static void Test_L_BFu8i_BFu7i()
{
  {
    init_simple_test("L_BFu8i_BFu7i");
    static STRUCT_IF_C L_BFu8i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu7i, L_BFu8i_BFu7i)
//============================================================================



static void Test_L_BFu8i_BFu7ll()
{
  {
    init_simple_test("L_BFu8i_BFu7ll");
    static STRUCT_IF_C L_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu7ll, L_BFu8i_BFu7ll)
//============================================================================



static void Test_L_BFu8i_BFu7s()
{
  {
    init_simple_test("L_BFu8i_BFu7s");
    static STRUCT_IF_C L_BFu8i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu7s, L_BFu8i_BFu7s)
//============================================================================



static void Test_L_BFu8i_BFu8c()
{
  {
    init_simple_test("L_BFu8i_BFu8c");
    static STRUCT_IF_C L_BFu8i_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu8c, L_BFu8i_BFu8c)
//============================================================================



static void Test_L_BFu8i_BFu8i()
{
  {
    init_simple_test("L_BFu8i_BFu8i");
    static STRUCT_IF_C L_BFu8i_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu8i, L_BFu8i_BFu8i)
//============================================================================



static void Test_L_BFu8i_BFu8ll()
{
  {
    init_simple_test("L_BFu8i_BFu8ll");
    static STRUCT_IF_C L_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu8ll, L_BFu8i_BFu8ll)
//============================================================================



static void Test_L_BFu8i_BFu8s()
{
  {
    init_simple_test("L_BFu8i_BFu8s");
    static STRUCT_IF_C L_BFu8i_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu8s, L_BFu8i_BFu8s)
//============================================================================



static void Test_L_BFu8i_BFu9i()
{
  {
    init_simple_test("L_BFu8i_BFu9i");
    static STRUCT_IF_C L_BFu8i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu9i, L_BFu8i_BFu9i)
//============================================================================



static void Test_L_BFu8i_BFu9ll()
{
  {
    init_simple_test("L_BFu8i_BFu9ll");
    static STRUCT_IF_C L_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu9ll, L_BFu8i_BFu9ll)
//============================================================================



static void Test_L_BFu8i_BFu9s()
{
  {
    init_simple_test("L_BFu8i_BFu9s");
    static STRUCT_IF_C L_BFu8i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_BFu9s, L_BFu8i_BFu9s)
//============================================================================



static void Test_L_BFu8i_C()
{
  {
    init_simple_test("L_BFu8i_C");
    static STRUCT_IF_C L_BFu8i_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_C)");
    check_field_offset(lv, v1, 0, "L_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_C");
    check_field_offset(lv, v3, 9, "L_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_C, L_BFu8i_C)
//============================================================================



static void Test_L_BFu8i_D()
{
  {
    init_simple_test("L_BFu8i_D");
    static STRUCT_IF_C L_BFu8i_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_D)");
    check_field_offset(lv, v1, 0, "L_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_D");
    check_field_offset(lv, v3, 9, "L_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_D, L_BFu8i_D)
//============================================================================



static void Test_L_BFu8i_F()
{
  {
    init_simple_test("L_BFu8i_F");
    static STRUCT_IF_C L_BFu8i_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_F)");
    check_field_offset(lv, v1, 0, "L_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_F");
    check_field_offset(lv, v3, 9, "L_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_F, L_BFu8i_F)
//============================================================================



static void Test_L_BFu8i_I()
{
  {
    init_simple_test("L_BFu8i_I");
    static STRUCT_IF_C L_BFu8i_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_I)");
    check_field_offset(lv, v1, 0, "L_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_I");
    check_field_offset(lv, v3, 9, "L_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_I, L_BFu8i_I)
//============================================================================



static void Test_L_BFu8i_Ip()
{
  {
    init_simple_test("L_BFu8i_Ip");
    static STRUCT_IF_C L_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_Ip");
    check_field_offset(lv, v3, 9, "L_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_Ip, L_BFu8i_Ip)
//============================================================================



static void Test_L_BFu8i_L()
{
  {
    init_simple_test("L_BFu8i_L");
    static STRUCT_IF_C L_BFu8i_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_L)");
    check_field_offset(lv, v1, 0, "L_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_L");
    check_field_offset(lv, v3, 9, "L_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_L, L_BFu8i_L)
//============================================================================



static void Test_L_BFu8i_S()
{
  {
    init_simple_test("L_BFu8i_S");
    static STRUCT_IF_C L_BFu8i_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_S)");
    check_field_offset(lv, v1, 0, "L_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_S");
    check_field_offset(lv, v3, 9, "L_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_S, L_BFu8i_S)
//============================================================================



static void Test_L_BFu8i_Uc()
{
  {
    init_simple_test("L_BFu8i_Uc");
    static STRUCT_IF_C L_BFu8i_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_Uc");
    check_field_offset(lv, v3, 9, "L_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_Uc, L_BFu8i_Uc)
//============================================================================



static void Test_L_BFu8i_Ui()
{
  {
    init_simple_test("L_BFu8i_Ui");
    static STRUCT_IF_C L_BFu8i_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_Ui");
    check_field_offset(lv, v3, 9, "L_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_Ui, L_BFu8i_Ui)
//============================================================================



static void Test_L_BFu8i_Ul()
{
  {
    init_simple_test("L_BFu8i_Ul");
    static STRUCT_IF_C L_BFu8i_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_Ul");
    check_field_offset(lv, v3, 9, "L_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_Ul, L_BFu8i_Ul)
//============================================================================



static void Test_L_BFu8i_Us()
{
  {
    init_simple_test("L_BFu8i_Us");
    static STRUCT_IF_C L_BFu8i_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "L_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_Us");
    check_field_offset(lv, v3, 9, "L_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_Us, L_BFu8i_Us)
//============================================================================



static void Test_L_BFu8i_Vp()
{
  {
    init_simple_test("L_BFu8i_Vp");
    static STRUCT_IF_C L_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_Vp");
    check_field_offset(lv, v3, 9, "L_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8i_Vp, L_BFu8i_Vp)
//============================================================================



static void Test_L_BFu8ll()
{
  {
    init_simple_test("L_BFu8ll");
    static STRUCT_IF_C L_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll, L_BFu8ll)
//============================================================================



static void Test_L_BFu8ll_BFu15i()
{
  {
    init_simple_test("L_BFu8ll_BFu15i");
    static STRUCT_IF_C L_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu15i, L_BFu8ll_BFu15i)
//============================================================================



static void Test_L_BFu8ll_BFu15ll()
{
  {
    init_simple_test("L_BFu8ll_BFu15ll");
    static STRUCT_IF_C L_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu15ll, L_BFu8ll_BFu15ll)
//============================================================================



static void Test_L_BFu8ll_BFu15s()
{
  {
    init_simple_test("L_BFu8ll_BFu15s");
    static STRUCT_IF_C L_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu15s, L_BFu8ll_BFu15s)
//============================================================================



static void Test_L_BFu8ll_BFu16i()
{
  {
    init_simple_test("L_BFu8ll_BFu16i");
    static STRUCT_IF_C L_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu16i, L_BFu8ll_BFu16i)
//============================================================================



static void Test_L_BFu8ll_BFu16ll()
{
  {
    init_simple_test("L_BFu8ll_BFu16ll");
    static STRUCT_IF_C L_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu16ll, L_BFu8ll_BFu16ll)
//============================================================================



static void Test_L_BFu8ll_BFu16s()
{
  {
    init_simple_test("L_BFu8ll_BFu16s");
    static STRUCT_IF_C L_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu16s, L_BFu8ll_BFu16s)
//============================================================================



static void Test_L_BFu8ll_BFu17i()
{
  {
    init_simple_test("L_BFu8ll_BFu17i");
    static STRUCT_IF_C L_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu17i, L_BFu8ll_BFu17i)
//============================================================================



static void Test_L_BFu8ll_BFu17ll()
{
  {
    init_simple_test("L_BFu8ll_BFu17ll");
    static STRUCT_IF_C L_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu17ll, L_BFu8ll_BFu17ll)
//============================================================================



static void Test_L_BFu8ll_BFu1c()
{
  {
    init_simple_test("L_BFu8ll_BFu1c");
    static STRUCT_IF_C L_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu1c, L_BFu8ll_BFu1c)
//============================================================================



static void Test_L_BFu8ll_BFu1i()
{
  {
    init_simple_test("L_BFu8ll_BFu1i");
    static STRUCT_IF_C L_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu1i, L_BFu8ll_BFu1i)
//============================================================================



static void Test_L_BFu8ll_BFu1ll()
{
  {
    init_simple_test("L_BFu8ll_BFu1ll");
    static STRUCT_IF_C L_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu1ll, L_BFu8ll_BFu1ll)
//============================================================================



static void Test_L_BFu8ll_BFu1s()
{
  {
    init_simple_test("L_BFu8ll_BFu1s");
    static STRUCT_IF_C L_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu1s, L_BFu8ll_BFu1s)
//============================================================================



static void Test_L_BFu8ll_BFu31i()
{
  {
    init_simple_test("L_BFu8ll_BFu31i");
    static STRUCT_IF_C L_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu31i, L_BFu8ll_BFu31i)
//============================================================================



static void Test_L_BFu8ll_BFu31ll()
{
  {
    init_simple_test("L_BFu8ll_BFu31ll");
    static STRUCT_IF_C L_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu31ll, L_BFu8ll_BFu31ll)
//============================================================================



static void Test_L_BFu8ll_BFu32i()
{
  {
    init_simple_test("L_BFu8ll_BFu32i");
    static STRUCT_IF_C L_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu32i, L_BFu8ll_BFu32i)
//============================================================================



static void Test_L_BFu8ll_BFu32ll()
{
  {
    init_simple_test("L_BFu8ll_BFu32ll");
    static STRUCT_IF_C L_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu32ll, L_BFu8ll_BFu32ll)
//============================================================================



static void Test_L_BFu8ll_BFu33()
{
  {
    init_simple_test("L_BFu8ll_BFu33");
    static STRUCT_IF_C L_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "L_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "L_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu33, L_BFu8ll_BFu33)
//============================================================================



static void Test_L_BFu8ll_BFu7c()
{
  {
    init_simple_test("L_BFu8ll_BFu7c");
    static STRUCT_IF_C L_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu7c, L_BFu8ll_BFu7c)
//============================================================================



static void Test_L_BFu8ll_BFu7i()
{
  {
    init_simple_test("L_BFu8ll_BFu7i");
    static STRUCT_IF_C L_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu7i, L_BFu8ll_BFu7i)
//============================================================================



static void Test_L_BFu8ll_BFu7ll()
{
  {
    init_simple_test("L_BFu8ll_BFu7ll");
    static STRUCT_IF_C L_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu7ll, L_BFu8ll_BFu7ll)
//============================================================================



static void Test_L_BFu8ll_BFu7s()
{
  {
    init_simple_test("L_BFu8ll_BFu7s");
    static STRUCT_IF_C L_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu7s, L_BFu8ll_BFu7s)
//============================================================================



static void Test_L_BFu8ll_BFu8c()
{
  {
    init_simple_test("L_BFu8ll_BFu8c");
    static STRUCT_IF_C L_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu8c, L_BFu8ll_BFu8c)
//============================================================================



static void Test_L_BFu8ll_BFu8i()
{
  {
    init_simple_test("L_BFu8ll_BFu8i");
    static STRUCT_IF_C L_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu8i, L_BFu8ll_BFu8i)
//============================================================================



static void Test_L_BFu8ll_BFu8ll()
{
  {
    init_simple_test("L_BFu8ll_BFu8ll");
    static STRUCT_IF_C L_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu8ll, L_BFu8ll_BFu8ll)
//============================================================================



static void Test_L_BFu8ll_BFu8s()
{
  {
    init_simple_test("L_BFu8ll_BFu8s");
    static STRUCT_IF_C L_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu8s, L_BFu8ll_BFu8s)
//============================================================================



static void Test_L_BFu8ll_BFu9i()
{
  {
    init_simple_test("L_BFu8ll_BFu9i");
    static STRUCT_IF_C L_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu9i, L_BFu8ll_BFu9i)
//============================================================================



static void Test_L_BFu8ll_BFu9ll()
{
  {
    init_simple_test("L_BFu8ll_BFu9ll");
    static STRUCT_IF_C L_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu9ll, L_BFu8ll_BFu9ll)
//============================================================================



static void Test_L_BFu8ll_BFu9s()
{
  {
    init_simple_test("L_BFu8ll_BFu9s");
    static STRUCT_IF_C L_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_BFu9s, L_BFu8ll_BFu9s)
//============================================================================



static void Test_L_BFu8ll_C()
{
  {
    init_simple_test("L_BFu8ll_C");
    static STRUCT_IF_C L_BFu8ll_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_C");
    check_field_offset(lv, v3, 9, "L_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_C, L_BFu8ll_C)
//============================================================================



static void Test_L_BFu8ll_D()
{
  {
    init_simple_test("L_BFu8ll_D");
    static STRUCT_IF_C L_BFu8ll_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_D");
    check_field_offset(lv, v3, 9, "L_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_D, L_BFu8ll_D)
//============================================================================



static void Test_L_BFu8ll_F()
{
  {
    init_simple_test("L_BFu8ll_F");
    static STRUCT_IF_C L_BFu8ll_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_F");
    check_field_offset(lv, v3, 9, "L_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_F, L_BFu8ll_F)
//============================================================================



static void Test_L_BFu8ll_I()
{
  {
    init_simple_test("L_BFu8ll_I");
    static STRUCT_IF_C L_BFu8ll_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_I");
    check_field_offset(lv, v3, 9, "L_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_I, L_BFu8ll_I)
//============================================================================



static void Test_L_BFu8ll_Ip()
{
  {
    init_simple_test("L_BFu8ll_Ip");
    static STRUCT_IF_C L_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_Ip");
    check_field_offset(lv, v3, 9, "L_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_Ip, L_BFu8ll_Ip)
//============================================================================



static void Test_L_BFu8ll_L()
{
  {
    init_simple_test("L_BFu8ll_L");
    static STRUCT_IF_C L_BFu8ll_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_L");
    check_field_offset(lv, v3, 9, "L_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_L, L_BFu8ll_L)
//============================================================================



static void Test_L_BFu8ll_S()
{
  {
    init_simple_test("L_BFu8ll_S");
    static STRUCT_IF_C L_BFu8ll_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_S");
    check_field_offset(lv, v3, 9, "L_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_S, L_BFu8ll_S)
//============================================================================



static void Test_L_BFu8ll_Uc()
{
  {
    init_simple_test("L_BFu8ll_Uc");
    static STRUCT_IF_C L_BFu8ll_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_Uc");
    check_field_offset(lv, v3, 9, "L_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_Uc, L_BFu8ll_Uc)
//============================================================================



static void Test_L_BFu8ll_Ui()
{
  {
    init_simple_test("L_BFu8ll_Ui");
    static STRUCT_IF_C L_BFu8ll_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_Ui");
    check_field_offset(lv, v3, 9, "L_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_Ui, L_BFu8ll_Ui)
//============================================================================



static void Test_L_BFu8ll_Ul()
{
  {
    init_simple_test("L_BFu8ll_Ul");
    static STRUCT_IF_C L_BFu8ll_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_Ul");
    check_field_offset(lv, v3, 9, "L_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_Ul, L_BFu8ll_Ul)
//============================================================================



static void Test_L_BFu8ll_Us()
{
  {
    init_simple_test("L_BFu8ll_Us");
    static STRUCT_IF_C L_BFu8ll_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_Us");
    check_field_offset(lv, v3, 9, "L_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_Us, L_BFu8ll_Us)
//============================================================================



static void Test_L_BFu8ll_Vp()
{
  {
    init_simple_test("L_BFu8ll_Vp");
    static STRUCT_IF_C L_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_Vp");
    check_field_offset(lv, v3, 9, "L_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8ll_Vp, L_BFu8ll_Vp)
//============================================================================



static void Test_L_BFu8s()
{
  {
    init_simple_test("L_BFu8s");
    static STRUCT_IF_C L_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s, L_BFu8s)
//============================================================================



static void Test_L_BFu8s_BFu15i()
{
  {
    init_simple_test("L_BFu8s_BFu15i");
    static STRUCT_IF_C L_BFu8s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu15i, L_BFu8s_BFu15i)
//============================================================================



static void Test_L_BFu8s_BFu15ll()
{
  {
    init_simple_test("L_BFu8s_BFu15ll");
    static STRUCT_IF_C L_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu15ll, L_BFu8s_BFu15ll)
//============================================================================



static void Test_L_BFu8s_BFu15s()
{
  {
    init_simple_test("L_BFu8s_BFu15s");
    static STRUCT_IF_C L_BFu8s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu15s, L_BFu8s_BFu15s)
//============================================================================



static void Test_L_BFu8s_BFu16i()
{
  {
    init_simple_test("L_BFu8s_BFu16i");
    static STRUCT_IF_C L_BFu8s_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu16i, L_BFu8s_BFu16i)
//============================================================================



static void Test_L_BFu8s_BFu16ll()
{
  {
    init_simple_test("L_BFu8s_BFu16ll");
    static STRUCT_IF_C L_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu16ll, L_BFu8s_BFu16ll)
//============================================================================



static void Test_L_BFu8s_BFu16s()
{
  {
    init_simple_test("L_BFu8s_BFu16s");
    static STRUCT_IF_C L_BFu8s_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu16s, L_BFu8s_BFu16s)
//============================================================================



static void Test_L_BFu8s_BFu17i()
{
  {
    init_simple_test("L_BFu8s_BFu17i");
    static STRUCT_IF_C L_BFu8s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu17i, L_BFu8s_BFu17i)
//============================================================================



static void Test_L_BFu8s_BFu17ll()
{
  {
    init_simple_test("L_BFu8s_BFu17ll");
    static STRUCT_IF_C L_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu17ll, L_BFu8s_BFu17ll)
//============================================================================



static void Test_L_BFu8s_BFu1c()
{
  {
    init_simple_test("L_BFu8s_BFu1c");
    static STRUCT_IF_C L_BFu8s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu1c, L_BFu8s_BFu1c)
//============================================================================



static void Test_L_BFu8s_BFu1i()
{
  {
    init_simple_test("L_BFu8s_BFu1i");
    static STRUCT_IF_C L_BFu8s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu1i, L_BFu8s_BFu1i)
//============================================================================



static void Test_L_BFu8s_BFu1ll()
{
  {
    init_simple_test("L_BFu8s_BFu1ll");
    static STRUCT_IF_C L_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu1ll, L_BFu8s_BFu1ll)
//============================================================================



static void Test_L_BFu8s_BFu1s()
{
  {
    init_simple_test("L_BFu8s_BFu1s");
    static STRUCT_IF_C L_BFu8s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu1s, L_BFu8s_BFu1s)
//============================================================================



static void Test_L_BFu8s_BFu31i()
{
  {
    init_simple_test("L_BFu8s_BFu31i");
    static STRUCT_IF_C L_BFu8s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu31i, L_BFu8s_BFu31i)
//============================================================================



static void Test_L_BFu8s_BFu31ll()
{
  {
    init_simple_test("L_BFu8s_BFu31ll");
    static STRUCT_IF_C L_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu31ll, L_BFu8s_BFu31ll)
//============================================================================



static void Test_L_BFu8s_BFu32i()
{
  {
    init_simple_test("L_BFu8s_BFu32i");
    static STRUCT_IF_C L_BFu8s_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu32i, L_BFu8s_BFu32i)
//============================================================================



static void Test_L_BFu8s_BFu32ll()
{
  {
    init_simple_test("L_BFu8s_BFu32ll");
    static STRUCT_IF_C L_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu32ll, L_BFu8s_BFu32ll)
//============================================================================



static void Test_L_BFu8s_BFu33()
{
  {
    init_simple_test("L_BFu8s_BFu33");
    static STRUCT_IF_C L_BFu8s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "L_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "L_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu33, L_BFu8s_BFu33)
//============================================================================



static void Test_L_BFu8s_BFu7c()
{
  {
    init_simple_test("L_BFu8s_BFu7c");
    static STRUCT_IF_C L_BFu8s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu7c, L_BFu8s_BFu7c)
//============================================================================



static void Test_L_BFu8s_BFu7i()
{
  {
    init_simple_test("L_BFu8s_BFu7i");
    static STRUCT_IF_C L_BFu8s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu7i, L_BFu8s_BFu7i)
//============================================================================



static void Test_L_BFu8s_BFu7ll()
{
  {
    init_simple_test("L_BFu8s_BFu7ll");
    static STRUCT_IF_C L_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu7ll, L_BFu8s_BFu7ll)
//============================================================================



static void Test_L_BFu8s_BFu7s()
{
  {
    init_simple_test("L_BFu8s_BFu7s");
    static STRUCT_IF_C L_BFu8s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu7s, L_BFu8s_BFu7s)
//============================================================================



static void Test_L_BFu8s_BFu8c()
{
  {
    init_simple_test("L_BFu8s_BFu8c");
    static STRUCT_IF_C L_BFu8s_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu8c, L_BFu8s_BFu8c)
//============================================================================



static void Test_L_BFu8s_BFu8i()
{
  {
    init_simple_test("L_BFu8s_BFu8i");
    static STRUCT_IF_C L_BFu8s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu8i, L_BFu8s_BFu8i)
//============================================================================



static void Test_L_BFu8s_BFu8ll()
{
  {
    init_simple_test("L_BFu8s_BFu8ll");
    static STRUCT_IF_C L_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu8ll, L_BFu8s_BFu8ll)
//============================================================================



static void Test_L_BFu8s_BFu8s()
{
  {
    init_simple_test("L_BFu8s_BFu8s");
    static STRUCT_IF_C L_BFu8s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu8s, L_BFu8s_BFu8s)
//============================================================================



static void Test_L_BFu8s_BFu9i()
{
  {
    init_simple_test("L_BFu8s_BFu9i");
    static STRUCT_IF_C L_BFu8s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu9i, L_BFu8s_BFu9i)
//============================================================================



static void Test_L_BFu8s_BFu9ll()
{
  {
    init_simple_test("L_BFu8s_BFu9ll");
    static STRUCT_IF_C L_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu9ll, L_BFu8s_BFu9ll)
//============================================================================



static void Test_L_BFu8s_BFu9s()
{
  {
    init_simple_test("L_BFu8s_BFu9s");
    static STRUCT_IF_C L_BFu8s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_BFu9s, L_BFu8s_BFu9s)
//============================================================================



static void Test_L_BFu8s_C()
{
  {
    init_simple_test("L_BFu8s_C");
    static STRUCT_IF_C L_BFu8s_C lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_C)");
    check_field_offset(lv, v1, 0, "L_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_C");
    check_field_offset(lv, v3, 9, "L_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_C, L_BFu8s_C)
//============================================================================



static void Test_L_BFu8s_D()
{
  {
    init_simple_test("L_BFu8s_D");
    static STRUCT_IF_C L_BFu8s_D lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_D)");
    check_field_offset(lv, v1, 0, "L_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_D");
    check_field_offset(lv, v3, 9, "L_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_D, L_BFu8s_D)
//============================================================================



static void Test_L_BFu8s_F()
{
  {
    init_simple_test("L_BFu8s_F");
    static STRUCT_IF_C L_BFu8s_F lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_F)");
    check_field_offset(lv, v1, 0, "L_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_F");
    check_field_offset(lv, v3, 9, "L_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_F, L_BFu8s_F)
//============================================================================



static void Test_L_BFu8s_I()
{
  {
    init_simple_test("L_BFu8s_I");
    static STRUCT_IF_C L_BFu8s_I lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_I)");
    check_field_offset(lv, v1, 0, "L_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_I");
    check_field_offset(lv, v3, 9, "L_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_I, L_BFu8s_I)
//============================================================================



static void Test_L_BFu8s_Ip()
{
  {
    init_simple_test("L_BFu8s_Ip");
    static STRUCT_IF_C L_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_Ip");
    check_field_offset(lv, v3, 9, "L_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_Ip, L_BFu8s_Ip)
//============================================================================



static void Test_L_BFu8s_L()
{
  {
    init_simple_test("L_BFu8s_L");
    static STRUCT_IF_C L_BFu8s_L lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_L)");
    check_field_offset(lv, v1, 0, "L_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_L");
    check_field_offset(lv, v3, 9, "L_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_L, L_BFu8s_L)
//============================================================================



static void Test_L_BFu8s_S()
{
  {
    init_simple_test("L_BFu8s_S");
    static STRUCT_IF_C L_BFu8s_S lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_S)");
    check_field_offset(lv, v1, 0, "L_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_S");
    check_field_offset(lv, v3, 9, "L_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_S, L_BFu8s_S)
//============================================================================



static void Test_L_BFu8s_Uc()
{
  {
    init_simple_test("L_BFu8s_Uc");
    static STRUCT_IF_C L_BFu8s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_Uc");
    check_field_offset(lv, v3, 9, "L_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_Uc, L_BFu8s_Uc)
//============================================================================



static void Test_L_BFu8s_Ui()
{
  {
    init_simple_test("L_BFu8s_Ui");
    static STRUCT_IF_C L_BFu8s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_Ui");
    check_field_offset(lv, v3, 9, "L_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_Ui, L_BFu8s_Ui)
//============================================================================



static void Test_L_BFu8s_Ul()
{
  {
    init_simple_test("L_BFu8s_Ul");
    static STRUCT_IF_C L_BFu8s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_Ul");
    check_field_offset(lv, v3, 9, "L_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_Ul, L_BFu8s_Ul)
//============================================================================



static void Test_L_BFu8s_Us()
{
  {
    init_simple_test("L_BFu8s_Us");
    static STRUCT_IF_C L_BFu8s_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "L_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_Us");
    check_field_offset(lv, v3, 9, "L_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_Us, L_BFu8s_Us)
//============================================================================



static void Test_L_BFu8s_Vp()
{
  {
    init_simple_test("L_BFu8s_Vp");
    static STRUCT_IF_C L_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_Vp");
    check_field_offset(lv, v3, 9, "L_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu8s_Vp, L_BFu8s_Vp)
//============================================================================



static void Test_L_BFu9i()
{
  {
    init_simple_test("L_BFu9i");
    static STRUCT_IF_C L_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i, L_BFu9i)
//============================================================================



static void Test_L_BFu9i_BFu15i()
{
  {
    init_simple_test("L_BFu9i_BFu15i");
    static STRUCT_IF_C L_BFu9i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu15i, L_BFu9i_BFu15i)
//============================================================================



static void Test_L_BFu9i_BFu15ll()
{
  {
    init_simple_test("L_BFu9i_BFu15ll");
    static STRUCT_IF_C L_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu15ll, L_BFu9i_BFu15ll)
//============================================================================



static void Test_L_BFu9i_BFu15s()
{
  {
    init_simple_test("L_BFu9i_BFu15s");
    static STRUCT_IF_C L_BFu9i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu15s, L_BFu9i_BFu15s)
//============================================================================



static void Test_L_BFu9i_BFu16i()
{
  {
    init_simple_test("L_BFu9i_BFu16i");
    static STRUCT_IF_C L_BFu9i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu16i, L_BFu9i_BFu16i)
//============================================================================



static void Test_L_BFu9i_BFu16ll()
{
  {
    init_simple_test("L_BFu9i_BFu16ll");
    static STRUCT_IF_C L_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu16ll, L_BFu9i_BFu16ll)
//============================================================================



static void Test_L_BFu9i_BFu16s()
{
  {
    init_simple_test("L_BFu9i_BFu16s");
    static STRUCT_IF_C L_BFu9i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu16s, L_BFu9i_BFu16s)
//============================================================================



static void Test_L_BFu9i_BFu17i()
{
  {
    init_simple_test("L_BFu9i_BFu17i");
    static STRUCT_IF_C L_BFu9i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "L_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "L_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu17i, L_BFu9i_BFu17i)
//============================================================================



static void Test_L_BFu9i_BFu17ll()
{
  {
    init_simple_test("L_BFu9i_BFu17ll");
    static STRUCT_IF_C L_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "L_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "L_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu17ll, L_BFu9i_BFu17ll)
//============================================================================



static void Test_L_BFu9i_BFu1c()
{
  {
    init_simple_test("L_BFu9i_BFu1c");
    static STRUCT_IF_C L_BFu9i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu1c, L_BFu9i_BFu1c)
//============================================================================



static void Test_L_BFu9i_BFu1i()
{
  {
    init_simple_test("L_BFu9i_BFu1i");
    static STRUCT_IF_C L_BFu9i_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu1i, L_BFu9i_BFu1i)
//============================================================================



static void Test_L_BFu9i_BFu1ll()
{
  {
    init_simple_test("L_BFu9i_BFu1ll");
    static STRUCT_IF_C L_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu1ll, L_BFu9i_BFu1ll)
//============================================================================



static void Test_L_BFu9i_BFu1s()
{
  {
    init_simple_test("L_BFu9i_BFu1s");
    static STRUCT_IF_C L_BFu9i_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu1s, L_BFu9i_BFu1s)
//============================================================================



static void Test_L_BFu9i_BFu31i()
{
  {
    init_simple_test("L_BFu9i_BFu31i");
    static STRUCT_IF_C L_BFu9i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "L_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "L_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu31i, L_BFu9i_BFu31i)
//============================================================================



static void Test_L_BFu9i_BFu31ll()
{
  {
    init_simple_test("L_BFu9i_BFu31ll");
    static STRUCT_IF_C L_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "L_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "L_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu31ll, L_BFu9i_BFu31ll)
//============================================================================



static void Test_L_BFu9i_BFu32i()
{
  {
    init_simple_test("L_BFu9i_BFu32i");
    static STRUCT_IF_C L_BFu9i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "L_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "L_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu32i, L_BFu9i_BFu32i)
//============================================================================



static void Test_L_BFu9i_BFu32ll()
{
  {
    init_simple_test("L_BFu9i_BFu32ll");
    static STRUCT_IF_C L_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "L_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "L_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu32ll, L_BFu9i_BFu32ll)
//============================================================================



static void Test_L_BFu9i_BFu33()
{
  {
    init_simple_test("L_BFu9i_BFu33");
    static STRUCT_IF_C L_BFu9i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "L_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "L_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu33, L_BFu9i_BFu33)
//============================================================================



static void Test_L_BFu9i_BFu7c()
{
  {
    init_simple_test("L_BFu9i_BFu7c");
    static STRUCT_IF_C L_BFu9i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu7c, L_BFu9i_BFu7c)
//============================================================================



static void Test_L_BFu9i_BFu7i()
{
  {
    init_simple_test("L_BFu9i_BFu7i");
    static STRUCT_IF_C L_BFu9i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu7i, L_BFu9i_BFu7i)
//============================================================================



static void Test_L_BFu9i_BFu7ll()
{
  {
    init_simple_test("L_BFu9i_BFu7ll");
    static STRUCT_IF_C L_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu7ll, L_BFu9i_BFu7ll)
//============================================================================



static void Test_L_BFu9i_BFu7s()
{
  {
    init_simple_test("L_BFu9i_BFu7s");
    static STRUCT_IF_C L_BFu9i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu7s, L_BFu9i_BFu7s)
//============================================================================



static void Test_L_BFu9i_BFu8c()
{
  {
    init_simple_test("L_BFu9i_BFu8c");
    static STRUCT_IF_C L_BFu9i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu8c, L_BFu9i_BFu8c)
//============================================================================



static void Test_L_BFu9i_BFu8i()
{
  {
    init_simple_test("L_BFu9i_BFu8i");
    static STRUCT_IF_C L_BFu9i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu8i, L_BFu9i_BFu8i)
//============================================================================



static void Test_L_BFu9i_BFu8ll()
{
  {
    init_simple_test("L_BFu9i_BFu8ll");
    static STRUCT_IF_C L_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu8ll, L_BFu9i_BFu8ll)
//============================================================================



static void Test_L_BFu9i_BFu8s()
{
  {
    init_simple_test("L_BFu9i_BFu8s");
    static STRUCT_IF_C L_BFu9i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu8s, L_BFu9i_BFu8s)
//============================================================================



static void Test_L_BFu9i_BFu9i()
{
  {
    init_simple_test("L_BFu9i_BFu9i");
    static STRUCT_IF_C L_BFu9i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu9i, L_BFu9i_BFu9i)
//============================================================================



static void Test_L_BFu9i_BFu9ll()
{
  {
    init_simple_test("L_BFu9i_BFu9ll");
    static STRUCT_IF_C L_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu9ll, L_BFu9i_BFu9ll)
//============================================================================



static void Test_L_BFu9i_BFu9s()
{
  {
    init_simple_test("L_BFu9i_BFu9s");
    static STRUCT_IF_C L_BFu9i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_BFu9s, L_BFu9i_BFu9s)
//============================================================================



static void Test_L_BFu9i_C()
{
  {
    init_simple_test("L_BFu9i_C");
    static STRUCT_IF_C L_BFu9i_C lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_C)");
    check_field_offset(lv, v1, 0, "L_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_C");
    check_field_offset(lv, v3, 10, "L_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_C, L_BFu9i_C)
//============================================================================



static void Test_L_BFu9i_D()
{
  {
    init_simple_test("L_BFu9i_D");
    static STRUCT_IF_C L_BFu9i_D lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_D)");
    check_field_offset(lv, v1, 0, "L_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_D");
    check_field_offset(lv, v3, 10, "L_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_D, L_BFu9i_D)
//============================================================================



static void Test_L_BFu9i_F()
{
  {
    init_simple_test("L_BFu9i_F");
    static STRUCT_IF_C L_BFu9i_F lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_F)");
    check_field_offset(lv, v1, 0, "L_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_F");
    check_field_offset(lv, v3, 10, "L_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_F, L_BFu9i_F)
//============================================================================



static void Test_L_BFu9i_I()
{
  {
    init_simple_test("L_BFu9i_I");
    static STRUCT_IF_C L_BFu9i_I lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_I)");
    check_field_offset(lv, v1, 0, "L_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_I");
    check_field_offset(lv, v3, 10, "L_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_I, L_BFu9i_I)
//============================================================================



static void Test_L_BFu9i_Ip()
{
  {
    init_simple_test("L_BFu9i_Ip");
    static STRUCT_IF_C L_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_Ip");
    check_field_offset(lv, v3, 10, "L_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_Ip, L_BFu9i_Ip)
//============================================================================



static void Test_L_BFu9i_L()
{
  {
    init_simple_test("L_BFu9i_L");
    static STRUCT_IF_C L_BFu9i_L lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_L)");
    check_field_offset(lv, v1, 0, "L_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_L");
    check_field_offset(lv, v3, 10, "L_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_L, L_BFu9i_L)
//============================================================================



static void Test_L_BFu9i_S()
{
  {
    init_simple_test("L_BFu9i_S");
    static STRUCT_IF_C L_BFu9i_S lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_S)");
    check_field_offset(lv, v1, 0, "L_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_S");
    check_field_offset(lv, v3, 10, "L_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_S, L_BFu9i_S)
//============================================================================



static void Test_L_BFu9i_Uc()
{
  {
    init_simple_test("L_BFu9i_Uc");
    static STRUCT_IF_C L_BFu9i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_Uc");
    check_field_offset(lv, v3, 10, "L_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_Uc, L_BFu9i_Uc)
//============================================================================



static void Test_L_BFu9i_Ui()
{
  {
    init_simple_test("L_BFu9i_Ui");
    static STRUCT_IF_C L_BFu9i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_Ui");
    check_field_offset(lv, v3, 10, "L_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_Ui, L_BFu9i_Ui)
//============================================================================



static void Test_L_BFu9i_Ul()
{
  {
    init_simple_test("L_BFu9i_Ul");
    static STRUCT_IF_C L_BFu9i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_Ul");
    check_field_offset(lv, v3, 10, "L_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_Ul, L_BFu9i_Ul)
//============================================================================



static void Test_L_BFu9i_Us()
{
  {
    init_simple_test("L_BFu9i_Us");
    static STRUCT_IF_C L_BFu9i_Us lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "L_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_Us");
    check_field_offset(lv, v3, 10, "L_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_Us, L_BFu9i_Us)
//============================================================================



static void Test_L_BFu9i_Vp()
{
  {
    init_simple_test("L_BFu9i_Vp");
    static STRUCT_IF_C L_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_Vp");
    check_field_offset(lv, v3, 10, "L_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9i_Vp, L_BFu9i_Vp)
//============================================================================



static void Test_L_BFu9ll()
{
  {
    init_simple_test("L_BFu9ll");
    static STRUCT_IF_C L_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll, L_BFu9ll)
//============================================================================



static void Test_L_BFu9ll_BFu15i()
{
  {
    init_simple_test("L_BFu9ll_BFu15i");
    static STRUCT_IF_C L_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu15i, L_BFu9ll_BFu15i)
//============================================================================



static void Test_L_BFu9ll_BFu15ll()
{
  {
    init_simple_test("L_BFu9ll_BFu15ll");
    static STRUCT_IF_C L_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu15ll, L_BFu9ll_BFu15ll)
//============================================================================



static void Test_L_BFu9ll_BFu15s()
{
  {
    init_simple_test("L_BFu9ll_BFu15s");
    static STRUCT_IF_C L_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu15s, L_BFu9ll_BFu15s)
//============================================================================



static void Test_L_BFu9ll_BFu16i()
{
  {
    init_simple_test("L_BFu9ll_BFu16i");
    static STRUCT_IF_C L_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu16i, L_BFu9ll_BFu16i)
//============================================================================



static void Test_L_BFu9ll_BFu16ll()
{
  {
    init_simple_test("L_BFu9ll_BFu16ll");
    static STRUCT_IF_C L_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu16ll, L_BFu9ll_BFu16ll)
//============================================================================



static void Test_L_BFu9ll_BFu16s()
{
  {
    init_simple_test("L_BFu9ll_BFu16s");
    static STRUCT_IF_C L_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu16s, L_BFu9ll_BFu16s)
//============================================================================



static void Test_L_BFu9ll_BFu17i()
{
  {
    init_simple_test("L_BFu9ll_BFu17i");
    static STRUCT_IF_C L_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "L_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "L_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu17i, L_BFu9ll_BFu17i)
//============================================================================



static void Test_L_BFu9ll_BFu17ll()
{
  {
    init_simple_test("L_BFu9ll_BFu17ll");
    static STRUCT_IF_C L_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "L_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "L_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu17ll, L_BFu9ll_BFu17ll)
//============================================================================



static void Test_L_BFu9ll_BFu1c()
{
  {
    init_simple_test("L_BFu9ll_BFu1c");
    static STRUCT_IF_C L_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu1c, L_BFu9ll_BFu1c)
//============================================================================



static void Test_L_BFu9ll_BFu1i()
{
  {
    init_simple_test("L_BFu9ll_BFu1i");
    static STRUCT_IF_C L_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu1i, L_BFu9ll_BFu1i)
//============================================================================



static void Test_L_BFu9ll_BFu1ll()
{
  {
    init_simple_test("L_BFu9ll_BFu1ll");
    static STRUCT_IF_C L_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu1ll, L_BFu9ll_BFu1ll)
//============================================================================



static void Test_L_BFu9ll_BFu1s()
{
  {
    init_simple_test("L_BFu9ll_BFu1s");
    static STRUCT_IF_C L_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu1s, L_BFu9ll_BFu1s)
//============================================================================



static void Test_L_BFu9ll_BFu31i()
{
  {
    init_simple_test("L_BFu9ll_BFu31i");
    static STRUCT_IF_C L_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "L_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "L_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu31i, L_BFu9ll_BFu31i)
//============================================================================



static void Test_L_BFu9ll_BFu31ll()
{
  {
    init_simple_test("L_BFu9ll_BFu31ll");
    static STRUCT_IF_C L_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "L_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "L_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu31ll, L_BFu9ll_BFu31ll)
//============================================================================



static void Test_L_BFu9ll_BFu32i()
{
  {
    init_simple_test("L_BFu9ll_BFu32i");
    static STRUCT_IF_C L_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "L_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "L_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu32i, L_BFu9ll_BFu32i)
//============================================================================



static void Test_L_BFu9ll_BFu32ll()
{
  {
    init_simple_test("L_BFu9ll_BFu32ll");
    static STRUCT_IF_C L_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "L_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "L_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu32ll, L_BFu9ll_BFu32ll)
//============================================================================



static void Test_L_BFu9ll_BFu33()
{
  {
    init_simple_test("L_BFu9ll_BFu33");
    static STRUCT_IF_C L_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "L_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "L_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu33, L_BFu9ll_BFu33)
//============================================================================



static void Test_L_BFu9ll_BFu7c()
{
  {
    init_simple_test("L_BFu9ll_BFu7c");
    static STRUCT_IF_C L_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu7c, L_BFu9ll_BFu7c)
//============================================================================



static void Test_L_BFu9ll_BFu7i()
{
  {
    init_simple_test("L_BFu9ll_BFu7i");
    static STRUCT_IF_C L_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu7i, L_BFu9ll_BFu7i)
//============================================================================



static void Test_L_BFu9ll_BFu7ll()
{
  {
    init_simple_test("L_BFu9ll_BFu7ll");
    static STRUCT_IF_C L_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu7ll, L_BFu9ll_BFu7ll)
//============================================================================



static void Test_L_BFu9ll_BFu7s()
{
  {
    init_simple_test("L_BFu9ll_BFu7s");
    static STRUCT_IF_C L_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu7s, L_BFu9ll_BFu7s)
//============================================================================



static void Test_L_BFu9ll_BFu8c()
{
  {
    init_simple_test("L_BFu9ll_BFu8c");
    static STRUCT_IF_C L_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu8c, L_BFu9ll_BFu8c)
//============================================================================



static void Test_L_BFu9ll_BFu8i()
{
  {
    init_simple_test("L_BFu9ll_BFu8i");
    static STRUCT_IF_C L_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu8i, L_BFu9ll_BFu8i)
//============================================================================



static void Test_L_BFu9ll_BFu8ll()
{
  {
    init_simple_test("L_BFu9ll_BFu8ll");
    static STRUCT_IF_C L_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu8ll, L_BFu9ll_BFu8ll)
//============================================================================



static void Test_L_BFu9ll_BFu8s()
{
  {
    init_simple_test("L_BFu9ll_BFu8s");
    static STRUCT_IF_C L_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu8s, L_BFu9ll_BFu8s)
//============================================================================



static void Test_L_BFu9ll_BFu9i()
{
  {
    init_simple_test("L_BFu9ll_BFu9i");
    static STRUCT_IF_C L_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu9i, L_BFu9ll_BFu9i)
//============================================================================



static void Test_L_BFu9ll_BFu9ll()
{
  {
    init_simple_test("L_BFu9ll_BFu9ll");
    static STRUCT_IF_C L_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu9ll, L_BFu9ll_BFu9ll)
//============================================================================



static void Test_L_BFu9ll_BFu9s()
{
  {
    init_simple_test("L_BFu9ll_BFu9s");
    static STRUCT_IF_C L_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_BFu9s, L_BFu9ll_BFu9s)
//============================================================================



static void Test_L_BFu9ll_C()
{
  {
    init_simple_test("L_BFu9ll_C");
    static STRUCT_IF_C L_BFu9ll_C lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_C");
    check_field_offset(lv, v3, 10, "L_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_C, L_BFu9ll_C)
//============================================================================



static void Test_L_BFu9ll_D()
{
  {
    init_simple_test("L_BFu9ll_D");
    static STRUCT_IF_C L_BFu9ll_D lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_D");
    check_field_offset(lv, v3, 10, "L_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_D, L_BFu9ll_D)
//============================================================================



static void Test_L_BFu9ll_F()
{
  {
    init_simple_test("L_BFu9ll_F");
    static STRUCT_IF_C L_BFu9ll_F lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_F");
    check_field_offset(lv, v3, 10, "L_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_F, L_BFu9ll_F)
//============================================================================



static void Test_L_BFu9ll_I()
{
  {
    init_simple_test("L_BFu9ll_I");
    static STRUCT_IF_C L_BFu9ll_I lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_I");
    check_field_offset(lv, v3, 10, "L_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_I, L_BFu9ll_I)
//============================================================================



static void Test_L_BFu9ll_Ip()
{
  {
    init_simple_test("L_BFu9ll_Ip");
    static STRUCT_IF_C L_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_Ip");
    check_field_offset(lv, v3, 10, "L_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_Ip, L_BFu9ll_Ip)
//============================================================================



static void Test_L_BFu9ll_L()
{
  {
    init_simple_test("L_BFu9ll_L");
    static STRUCT_IF_C L_BFu9ll_L lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_L");
    check_field_offset(lv, v3, 10, "L_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_L, L_BFu9ll_L)
//============================================================================



static void Test_L_BFu9ll_S()
{
  {
    init_simple_test("L_BFu9ll_S");
    static STRUCT_IF_C L_BFu9ll_S lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_S");
    check_field_offset(lv, v3, 10, "L_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_S, L_BFu9ll_S)
//============================================================================



static void Test_L_BFu9ll_Uc()
{
  {
    init_simple_test("L_BFu9ll_Uc");
    static STRUCT_IF_C L_BFu9ll_Uc lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_Uc");
    check_field_offset(lv, v3, 10, "L_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_Uc, L_BFu9ll_Uc)
//============================================================================



static void Test_L_BFu9ll_Ui()
{
  {
    init_simple_test("L_BFu9ll_Ui");
    static STRUCT_IF_C L_BFu9ll_Ui lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_Ui");
    check_field_offset(lv, v3, 10, "L_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_Ui, L_BFu9ll_Ui)
//============================================================================



static void Test_L_BFu9ll_Ul()
{
  {
    init_simple_test("L_BFu9ll_Ul");
    static STRUCT_IF_C L_BFu9ll_Ul lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_Ul");
    check_field_offset(lv, v3, 10, "L_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_Ul, L_BFu9ll_Ul)
//============================================================================



static void Test_L_BFu9ll_Us()
{
  {
    init_simple_test("L_BFu9ll_Us");
    static STRUCT_IF_C L_BFu9ll_Us lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_Us");
    check_field_offset(lv, v3, 10, "L_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_Us, L_BFu9ll_Us)
//============================================================================



static void Test_L_BFu9ll_Vp()
{
  {
    init_simple_test("L_BFu9ll_Vp");
    static STRUCT_IF_C L_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_Vp");
    check_field_offset(lv, v3, 10, "L_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9ll_Vp, L_BFu9ll_Vp)
//============================================================================



static void Test_L_BFu9s()
{
  {
    init_simple_test("L_BFu9s");
    static STRUCT_IF_C L_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s, L_BFu9s)
//============================================================================



static void Test_L_BFu9s_BFu15i()
{
  {
    init_simple_test("L_BFu9s_BFu15i");
    static STRUCT_IF_C L_BFu9s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu15i, L_BFu9s_BFu15i)
//============================================================================



static void Test_L_BFu9s_BFu15ll()
{
  {
    init_simple_test("L_BFu9s_BFu15ll");
    static STRUCT_IF_C L_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu15ll, L_BFu9s_BFu15ll)
//============================================================================



static void Test_L_BFu9s_BFu15s()
{
  {
    init_simple_test("L_BFu9s_BFu15s");
    static STRUCT_IF_C L_BFu9s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "L_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "L_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu15s, L_BFu9s_BFu15s)
//============================================================================



static void Test_L_BFu9s_BFu16i()
{
  {
    init_simple_test("L_BFu9s_BFu16i");
    static STRUCT_IF_C L_BFu9s_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu16i, L_BFu9s_BFu16i)
//============================================================================



static void Test_L_BFu9s_BFu16ll()
{
  {
    init_simple_test("L_BFu9s_BFu16ll");
    static STRUCT_IF_C L_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu16ll, L_BFu9s_BFu16ll)
//============================================================================



static void Test_L_BFu9s_BFu16s()
{
  {
    init_simple_test("L_BFu9s_BFu16s");
    static STRUCT_IF_C L_BFu9s_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "L_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "L_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu16s, L_BFu9s_BFu16s)
//============================================================================



static void Test_L_BFu9s_BFu17i()
{
  {
    init_simple_test("L_BFu9s_BFu17i");
    static STRUCT_IF_C L_BFu9s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "L_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "L_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu17i, L_BFu9s_BFu17i)
//============================================================================



static void Test_L_BFu9s_BFu17ll()
{
  {
    init_simple_test("L_BFu9s_BFu17ll");
    static STRUCT_IF_C L_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "L_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "L_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu17ll, L_BFu9s_BFu17ll)
//============================================================================



static void Test_L_BFu9s_BFu1c()
{
  {
    init_simple_test("L_BFu9s_BFu1c");
    static STRUCT_IF_C L_BFu9s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu1c, L_BFu9s_BFu1c)
//============================================================================



static void Test_L_BFu9s_BFu1i()
{
  {
    init_simple_test("L_BFu9s_BFu1i");
    static STRUCT_IF_C L_BFu9s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu1i, L_BFu9s_BFu1i)
//============================================================================



static void Test_L_BFu9s_BFu1ll()
{
  {
    init_simple_test("L_BFu9s_BFu1ll");
    static STRUCT_IF_C L_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu1ll, L_BFu9s_BFu1ll)
//============================================================================



static void Test_L_BFu9s_BFu1s()
{
  {
    init_simple_test("L_BFu9s_BFu1s");
    static STRUCT_IF_C L_BFu9s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "L_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu1s, L_BFu9s_BFu1s)
//============================================================================



static void Test_L_BFu9s_BFu31i()
{
  {
    init_simple_test("L_BFu9s_BFu31i");
    static STRUCT_IF_C L_BFu9s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "L_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "L_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu31i, L_BFu9s_BFu31i)
//============================================================================



static void Test_L_BFu9s_BFu31ll()
{
  {
    init_simple_test("L_BFu9s_BFu31ll");
    static STRUCT_IF_C L_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "L_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "L_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu31ll, L_BFu9s_BFu31ll)
//============================================================================



static void Test_L_BFu9s_BFu32i()
{
  {
    init_simple_test("L_BFu9s_BFu32i");
    static STRUCT_IF_C L_BFu9s_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "L_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "L_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu32i, L_BFu9s_BFu32i)
//============================================================================



static void Test_L_BFu9s_BFu32ll()
{
  {
    init_simple_test("L_BFu9s_BFu32ll");
    static STRUCT_IF_C L_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "L_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "L_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu32ll, L_BFu9s_BFu32ll)
//============================================================================



static void Test_L_BFu9s_BFu33()
{
  {
    init_simple_test("L_BFu9s_BFu33");
    static STRUCT_IF_C L_BFu9s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "L_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "L_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu33, L_BFu9s_BFu33)
//============================================================================



static void Test_L_BFu9s_BFu7c()
{
  {
    init_simple_test("L_BFu9s_BFu7c");
    static STRUCT_IF_C L_BFu9s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu7c, L_BFu9s_BFu7c)
//============================================================================



static void Test_L_BFu9s_BFu7i()
{
  {
    init_simple_test("L_BFu9s_BFu7i");
    static STRUCT_IF_C L_BFu9s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu7i, L_BFu9s_BFu7i)
//============================================================================



static void Test_L_BFu9s_BFu7ll()
{
  {
    init_simple_test("L_BFu9s_BFu7ll");
    static STRUCT_IF_C L_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu7ll, L_BFu9s_BFu7ll)
//============================================================================



static void Test_L_BFu9s_BFu7s()
{
  {
    init_simple_test("L_BFu9s_BFu7s");
    static STRUCT_IF_C L_BFu9s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "L_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "L_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu7s, L_BFu9s_BFu7s)
//============================================================================



static void Test_L_BFu9s_BFu8c()
{
  {
    init_simple_test("L_BFu9s_BFu8c");
    static STRUCT_IF_C L_BFu9s_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu8c, L_BFu9s_BFu8c)
//============================================================================



static void Test_L_BFu9s_BFu8i()
{
  {
    init_simple_test("L_BFu9s_BFu8i");
    static STRUCT_IF_C L_BFu9s_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu8i, L_BFu9s_BFu8i)
//============================================================================



static void Test_L_BFu9s_BFu8ll()
{
  {
    init_simple_test("L_BFu9s_BFu8ll");
    static STRUCT_IF_C L_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu8ll, L_BFu9s_BFu8ll)
//============================================================================



static void Test_L_BFu9s_BFu8s()
{
  {
    init_simple_test("L_BFu9s_BFu8s");
    static STRUCT_IF_C L_BFu9s_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "L_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "L_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu8s, L_BFu9s_BFu8s)
//============================================================================



static void Test_L_BFu9s_BFu9i()
{
  {
    init_simple_test("L_BFu9s_BFu9i");
    static STRUCT_IF_C L_BFu9s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu9i, L_BFu9s_BFu9i)
//============================================================================



static void Test_L_BFu9s_BFu9ll()
{
  {
    init_simple_test("L_BFu9s_BFu9ll");
    static STRUCT_IF_C L_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu9ll, L_BFu9s_BFu9ll)
//============================================================================



static void Test_L_BFu9s_BFu9s()
{
  {
    init_simple_test("L_BFu9s_BFu9s");
    static STRUCT_IF_C L_BFu9s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "L_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "L_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_BFu9s, L_BFu9s_BFu9s)
//============================================================================



static void Test_L_BFu9s_C()
{
  {
    init_simple_test("L_BFu9s_C");
    static STRUCT_IF_C L_BFu9s_C lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_C)");
    check_field_offset(lv, v1, 0, "L_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_C");
    check_field_offset(lv, v3, 10, "L_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_C, L_BFu9s_C)
//============================================================================



static void Test_L_BFu9s_D()
{
  {
    init_simple_test("L_BFu9s_D");
    static STRUCT_IF_C L_BFu9s_D lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_D)");
    check_field_offset(lv, v1, 0, "L_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_D");
    check_field_offset(lv, v3, 10, "L_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_D, L_BFu9s_D)
//============================================================================



static void Test_L_BFu9s_F()
{
  {
    init_simple_test("L_BFu9s_F");
    static STRUCT_IF_C L_BFu9s_F lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_F)");
    check_field_offset(lv, v1, 0, "L_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_F");
    check_field_offset(lv, v3, 10, "L_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_F, L_BFu9s_F)
//============================================================================



static void Test_L_BFu9s_I()
{
  {
    init_simple_test("L_BFu9s_I");
    static STRUCT_IF_C L_BFu9s_I lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_I)");
    check_field_offset(lv, v1, 0, "L_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_I");
    check_field_offset(lv, v3, 10, "L_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_I, L_BFu9s_I)
//============================================================================



static void Test_L_BFu9s_Ip()
{
  {
    init_simple_test("L_BFu9s_Ip");
    static STRUCT_IF_C L_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "L_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_Ip");
    check_field_offset(lv, v3, 10, "L_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_Ip, L_BFu9s_Ip)
//============================================================================



static void Test_L_BFu9s_L()
{
  {
    init_simple_test("L_BFu9s_L");
    static STRUCT_IF_C L_BFu9s_L lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_L)");
    check_field_offset(lv, v1, 0, "L_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_L");
    check_field_offset(lv, v3, 10, "L_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_L, L_BFu9s_L)
//============================================================================



static void Test_L_BFu9s_S()
{
  {
    init_simple_test("L_BFu9s_S");
    static STRUCT_IF_C L_BFu9s_S lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_S)");
    check_field_offset(lv, v1, 0, "L_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_S");
    check_field_offset(lv, v3, 10, "L_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_S, L_BFu9s_S)
//============================================================================



static void Test_L_BFu9s_Uc()
{
  {
    init_simple_test("L_BFu9s_Uc");
    static STRUCT_IF_C L_BFu9s_Uc lv;
    check2(sizeof(lv), 11, "sizeof(L_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "L_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_Uc");
    check_field_offset(lv, v3, 10, "L_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_Uc, L_BFu9s_Uc)
//============================================================================



static void Test_L_BFu9s_Ui()
{
  {
    init_simple_test("L_BFu9s_Ui");
    static STRUCT_IF_C L_BFu9s_Ui lv;
    check2(sizeof(lv), 14, "sizeof(L_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "L_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_Ui");
    check_field_offset(lv, v3, 10, "L_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_Ui, L_BFu9s_Ui)
//============================================================================



static void Test_L_BFu9s_Ul()
{
  {
    init_simple_test("L_BFu9s_Ul");
    static STRUCT_IF_C L_BFu9s_Ul lv;
    check2(sizeof(lv), 18, "sizeof(L_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "L_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_Ul");
    check_field_offset(lv, v3, 10, "L_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_Ul, L_BFu9s_Ul)
//============================================================================



static void Test_L_BFu9s_Us()
{
  {
    init_simple_test("L_BFu9s_Us");
    static STRUCT_IF_C L_BFu9s_Us lv;
    check2(sizeof(lv), 12, "sizeof(L_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "L_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_Us");
    check_field_offset(lv, v3, 10, "L_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_Us, L_BFu9s_Us)
//============================================================================



static void Test_L_BFu9s_Vp()
{
  {
    init_simple_test("L_BFu9s_Vp");
    static STRUCT_IF_C L_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "L_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_Vp");
    check_field_offset(lv, v3, 10, "L_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_BFu9s_Vp, L_BFu9s_Vp)
//============================================================================



static void Test_L_C()
{
  {
    init_simple_test("L_C");
    STRUCT_IF_C L_C lv;
    check2(sizeof(lv), 9, "sizeof(L_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_C)");
    check_field_offset(lv, v1, 0, "L_C.v1");
    check_field_offset(lv, v2, 8, "L_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C, L_C)
//============================================================================



static void Test_L_C_BFu15i()
{
  {
    init_simple_test("L_C_BFu15i");
    static STRUCT_IF_C L_C_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu15i)");
    check_field_offset(lv, v1, 0, "L_C_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_C_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu15i, L_C_BFu15i)
//============================================================================



static void Test_L_C_BFu15ll()
{
  {
    init_simple_test("L_C_BFu15ll");
    static STRUCT_IF_C L_C_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_C_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu15ll, L_C_BFu15ll)
//============================================================================



static void Test_L_C_BFu15s()
{
  {
    init_simple_test("L_C_BFu15s");
    static STRUCT_IF_C L_C_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu15s)");
    check_field_offset(lv, v1, 0, "L_C_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_C_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu15s, L_C_BFu15s)
//============================================================================



static void Test_L_C_BFu16i()
{
  {
    init_simple_test("L_C_BFu16i");
    static STRUCT_IF_C L_C_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu16i)");
    check_field_offset(lv, v1, 0, "L_C_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_C_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu16i, L_C_BFu16i)
//============================================================================



static void Test_L_C_BFu16ll()
{
  {
    init_simple_test("L_C_BFu16ll");
    static STRUCT_IF_C L_C_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_C_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu16ll, L_C_BFu16ll)
//============================================================================



static void Test_L_C_BFu16s()
{
  {
    init_simple_test("L_C_BFu16s");
    static STRUCT_IF_C L_C_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu16s)");
    check_field_offset(lv, v1, 0, "L_C_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_C_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu16s, L_C_BFu16s)
//============================================================================



static void Test_L_C_BFu17i()
{
  {
    init_simple_test("L_C_BFu17i");
    static STRUCT_IF_C L_C_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu17i)");
    check_field_offset(lv, v1, 0, "L_C_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_C_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu17i, L_C_BFu17i)
//============================================================================



static void Test_L_C_BFu17ll()
{
  {
    init_simple_test("L_C_BFu17ll");
    static STRUCT_IF_C L_C_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_C_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu17ll, L_C_BFu17ll)
//============================================================================



static void Test_L_C_BFu1c()
{
  {
    init_simple_test("L_C_BFu1c");
    static STRUCT_IF_C L_C_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu1c)");
    check_field_offset(lv, v1, 0, "L_C_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu1c, L_C_BFu1c)
//============================================================================



static void Test_L_C_BFu1i()
{
  {
    init_simple_test("L_C_BFu1i");
    static STRUCT_IF_C L_C_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu1i)");
    check_field_offset(lv, v1, 0, "L_C_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu1i, L_C_BFu1i)
//============================================================================



static void Test_L_C_BFu1ll()
{
  {
    init_simple_test("L_C_BFu1ll");
    static STRUCT_IF_C L_C_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu1ll, L_C_BFu1ll)
//============================================================================



static void Test_L_C_BFu1s()
{
  {
    init_simple_test("L_C_BFu1s");
    static STRUCT_IF_C L_C_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu1s)");
    check_field_offset(lv, v1, 0, "L_C_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu1s, L_C_BFu1s)
//============================================================================



static void Test_L_C_BFu31i()
{
  {
    init_simple_test("L_C_BFu31i");
    static STRUCT_IF_C L_C_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu31i)");
    check_field_offset(lv, v1, 0, "L_C_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_C_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu31i, L_C_BFu31i)
//============================================================================



static void Test_L_C_BFu31ll()
{
  {
    init_simple_test("L_C_BFu31ll");
    static STRUCT_IF_C L_C_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_C_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu31ll, L_C_BFu31ll)
//============================================================================



static void Test_L_C_BFu32i()
{
  {
    init_simple_test("L_C_BFu32i");
    static STRUCT_IF_C L_C_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu32i)");
    check_field_offset(lv, v1, 0, "L_C_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_C_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu32i, L_C_BFu32i)
//============================================================================



static void Test_L_C_BFu32ll()
{
  {
    init_simple_test("L_C_BFu32ll");
    static STRUCT_IF_C L_C_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_C_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu32ll, L_C_BFu32ll)
//============================================================================



static void Test_L_C_BFu33()
{
  {
    init_simple_test("L_C_BFu33");
    static STRUCT_IF_C L_C_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu33)");
    check_field_offset(lv, v1, 0, "L_C_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "L_C_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "L_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu33, L_C_BFu33)
//============================================================================



static void Test_L_C_BFu7c()
{
  {
    init_simple_test("L_C_BFu7c");
    static STRUCT_IF_C L_C_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu7c)");
    check_field_offset(lv, v1, 0, "L_C_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_C_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu7c, L_C_BFu7c)
//============================================================================



static void Test_L_C_BFu7i()
{
  {
    init_simple_test("L_C_BFu7i");
    static STRUCT_IF_C L_C_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu7i)");
    check_field_offset(lv, v1, 0, "L_C_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_C_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu7i, L_C_BFu7i)
//============================================================================



static void Test_L_C_BFu7ll()
{
  {
    init_simple_test("L_C_BFu7ll");
    static STRUCT_IF_C L_C_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_C_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu7ll, L_C_BFu7ll)
//============================================================================



static void Test_L_C_BFu7s()
{
  {
    init_simple_test("L_C_BFu7s");
    static STRUCT_IF_C L_C_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu7s)");
    check_field_offset(lv, v1, 0, "L_C_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_C_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu7s, L_C_BFu7s)
//============================================================================



static void Test_L_C_BFu8c()
{
  {
    init_simple_test("L_C_BFu8c");
    static STRUCT_IF_C L_C_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu8c)");
    check_field_offset(lv, v1, 0, "L_C_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_C_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu8c, L_C_BFu8c)
//============================================================================



static void Test_L_C_BFu8i()
{
  {
    init_simple_test("L_C_BFu8i");
    static STRUCT_IF_C L_C_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu8i)");
    check_field_offset(lv, v1, 0, "L_C_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_C_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu8i, L_C_BFu8i)
//============================================================================



static void Test_L_C_BFu8ll()
{
  {
    init_simple_test("L_C_BFu8ll");
    static STRUCT_IF_C L_C_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_C_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu8ll, L_C_BFu8ll)
//============================================================================



static void Test_L_C_BFu8s()
{
  {
    init_simple_test("L_C_BFu8s");
    static STRUCT_IF_C L_C_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu8s)");
    check_field_offset(lv, v1, 0, "L_C_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_C_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu8s, L_C_BFu8s)
//============================================================================



static void Test_L_C_BFu9i()
{
  {
    init_simple_test("L_C_BFu9i");
    static STRUCT_IF_C L_C_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu9i)");
    check_field_offset(lv, v1, 0, "L_C_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_C_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu9i, L_C_BFu9i)
//============================================================================



static void Test_L_C_BFu9ll()
{
  {
    init_simple_test("L_C_BFu9ll");
    static STRUCT_IF_C L_C_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_C_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu9ll, L_C_BFu9ll)
//============================================================================



static void Test_L_C_BFu9s()
{
  {
    init_simple_test("L_C_BFu9s");
    static STRUCT_IF_C L_C_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_BFu9s)");
    check_field_offset(lv, v1, 0, "L_C_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_C_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_BFu9s, L_C_BFu9s)
//============================================================================



static void Test_L_C_C()
{
  {
    init_simple_test("L_C_C");
    STRUCT_IF_C L_C_C lv;
    check2(sizeof(lv), 10, "sizeof(L_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_C)");
    check_field_offset(lv, v1, 0, "L_C_C.v1");
    check_field_offset(lv, v2, 8, "L_C_C.v2");
    check_field_offset(lv, v3, 9, "L_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_C, L_C_C)
//============================================================================



static void Test_L_C_D()
{
  {
    init_simple_test("L_C_D");
    STRUCT_IF_C L_C_D lv;
    check2(sizeof(lv), 17, "sizeof(L_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_D)");
    check_field_offset(lv, v1, 0, "L_C_D.v1");
    check_field_offset(lv, v2, 8, "L_C_D.v2");
    check_field_offset(lv, v3, 9, "L_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_D, L_C_D)
//============================================================================



static void Test_L_C_F()
{
  {
    init_simple_test("L_C_F");
    STRUCT_IF_C L_C_F lv;
    check2(sizeof(lv), 13, "sizeof(L_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_F)");
    check_field_offset(lv, v1, 0, "L_C_F.v1");
    check_field_offset(lv, v2, 8, "L_C_F.v2");
    check_field_offset(lv, v3, 9, "L_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_F, L_C_F)
//============================================================================



static void Test_L_C_I()
{
  {
    init_simple_test("L_C_I");
    STRUCT_IF_C L_C_I lv;
    check2(sizeof(lv), 13, "sizeof(L_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_I)");
    check_field_offset(lv, v1, 0, "L_C_I.v1");
    check_field_offset(lv, v2, 8, "L_C_I.v2");
    check_field_offset(lv, v3, 9, "L_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_I, L_C_I)
//============================================================================



static void Test_L_C_Ip()
{
  {
    init_simple_test("L_C_Ip");
    STRUCT_IF_C L_C_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_Ip)");
    check_field_offset(lv, v1, 0, "L_C_Ip.v1");
    check_field_offset(lv, v2, 8, "L_C_Ip.v2");
    check_field_offset(lv, v3, 9, "L_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_Ip, L_C_Ip)
//============================================================================



static void Test_L_C_L()
{
  {
    init_simple_test("L_C_L");
    STRUCT_IF_C L_C_L lv;
    check2(sizeof(lv), 17, "sizeof(L_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_L)");
    check_field_offset(lv, v1, 0, "L_C_L.v1");
    check_field_offset(lv, v2, 8, "L_C_L.v2");
    check_field_offset(lv, v3, 9, "L_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_L, L_C_L)
//============================================================================



static void Test_L_C_S()
{
  {
    init_simple_test("L_C_S");
    STRUCT_IF_C L_C_S lv;
    check2(sizeof(lv), 11, "sizeof(L_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_S)");
    check_field_offset(lv, v1, 0, "L_C_S.v1");
    check_field_offset(lv, v2, 8, "L_C_S.v2");
    check_field_offset(lv, v3, 9, "L_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_S, L_C_S)
//============================================================================



static void Test_L_C_Uc()
{
  {
    init_simple_test("L_C_Uc");
    STRUCT_IF_C L_C_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_Uc)");
    check_field_offset(lv, v1, 0, "L_C_Uc.v1");
    check_field_offset(lv, v2, 8, "L_C_Uc.v2");
    check_field_offset(lv, v3, 9, "L_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_Uc, L_C_Uc)
//============================================================================



static void Test_L_C_Ui()
{
  {
    init_simple_test("L_C_Ui");
    STRUCT_IF_C L_C_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_Ui)");
    check_field_offset(lv, v1, 0, "L_C_Ui.v1");
    check_field_offset(lv, v2, 8, "L_C_Ui.v2");
    check_field_offset(lv, v3, 9, "L_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_Ui, L_C_Ui)
//============================================================================



static void Test_L_C_Ul()
{
  {
    init_simple_test("L_C_Ul");
    STRUCT_IF_C L_C_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_Ul)");
    check_field_offset(lv, v1, 0, "L_C_Ul.v1");
    check_field_offset(lv, v2, 8, "L_C_Ul.v2");
    check_field_offset(lv, v3, 9, "L_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_Ul, L_C_Ul)
//============================================================================



static void Test_L_C_Us()
{
  {
    init_simple_test("L_C_Us");
    STRUCT_IF_C L_C_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_Us)");
    check_field_offset(lv, v1, 0, "L_C_Us.v1");
    check_field_offset(lv, v2, 8, "L_C_Us.v2");
    check_field_offset(lv, v3, 9, "L_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_Us, L_C_Us)
//============================================================================



static void Test_L_C_Vp()
{
  {
    init_simple_test("L_C_Vp");
    STRUCT_IF_C L_C_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_C_Vp)");
    check_field_offset(lv, v1, 0, "L_C_Vp.v1");
    check_field_offset(lv, v2, 8, "L_C_Vp.v2");
    check_field_offset(lv, v3, 9, "L_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_C_Vp, L_C_Vp)
//============================================================================



static void Test_L_D()
{
  {
    init_simple_test("L_D");
    STRUCT_IF_C L_D lv;
    check2(sizeof(lv), 16, "sizeof(L_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_D)");
    check_field_offset(lv, v1, 0, "L_D.v1");
    check_field_offset(lv, v2, 8, "L_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D, L_D)
//============================================================================



static void Test_L_D_BFu15i()
{
  {
    init_simple_test("L_D_BFu15i");
    static STRUCT_IF_C L_D_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu15i)");
    check_field_offset(lv, v1, 0, "L_D_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_D_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu15i, L_D_BFu15i)
//============================================================================



static void Test_L_D_BFu15ll()
{
  {
    init_simple_test("L_D_BFu15ll");
    static STRUCT_IF_C L_D_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_D_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu15ll, L_D_BFu15ll)
//============================================================================



static void Test_L_D_BFu15s()
{
  {
    init_simple_test("L_D_BFu15s");
    static STRUCT_IF_C L_D_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu15s)");
    check_field_offset(lv, v1, 0, "L_D_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_D_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu15s, L_D_BFu15s)
//============================================================================



static void Test_L_D_BFu16i()
{
  {
    init_simple_test("L_D_BFu16i");
    static STRUCT_IF_C L_D_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu16i)");
    check_field_offset(lv, v1, 0, "L_D_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_D_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu16i, L_D_BFu16i)
//============================================================================



static void Test_L_D_BFu16ll()
{
  {
    init_simple_test("L_D_BFu16ll");
    static STRUCT_IF_C L_D_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_D_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu16ll, L_D_BFu16ll)
//============================================================================



static void Test_L_D_BFu16s()
{
  {
    init_simple_test("L_D_BFu16s");
    static STRUCT_IF_C L_D_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu16s)");
    check_field_offset(lv, v1, 0, "L_D_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_D_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu16s, L_D_BFu16s)
//============================================================================



static void Test_L_D_BFu17i()
{
  {
    init_simple_test("L_D_BFu17i");
    static STRUCT_IF_C L_D_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(L_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu17i)");
    check_field_offset(lv, v1, 0, "L_D_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_D_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu17i, L_D_BFu17i)
//============================================================================



static void Test_L_D_BFu17ll()
{
  {
    init_simple_test("L_D_BFu17ll");
    static STRUCT_IF_C L_D_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(L_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_D_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu17ll, L_D_BFu17ll)
//============================================================================



static void Test_L_D_BFu1c()
{
  {
    init_simple_test("L_D_BFu1c");
    static STRUCT_IF_C L_D_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu1c)");
    check_field_offset(lv, v1, 0, "L_D_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu1c, L_D_BFu1c)
//============================================================================



static void Test_L_D_BFu1i()
{
  {
    init_simple_test("L_D_BFu1i");
    static STRUCT_IF_C L_D_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu1i)");
    check_field_offset(lv, v1, 0, "L_D_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu1i, L_D_BFu1i)
//============================================================================



static void Test_L_D_BFu1ll()
{
  {
    init_simple_test("L_D_BFu1ll");
    static STRUCT_IF_C L_D_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu1ll, L_D_BFu1ll)
//============================================================================



static void Test_L_D_BFu1s()
{
  {
    init_simple_test("L_D_BFu1s");
    static STRUCT_IF_C L_D_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu1s)");
    check_field_offset(lv, v1, 0, "L_D_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu1s, L_D_BFu1s)
//============================================================================



static void Test_L_D_BFu31i()
{
  {
    init_simple_test("L_D_BFu31i");
    static STRUCT_IF_C L_D_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(L_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu31i)");
    check_field_offset(lv, v1, 0, "L_D_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_D_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu31i, L_D_BFu31i)
//============================================================================



static void Test_L_D_BFu31ll()
{
  {
    init_simple_test("L_D_BFu31ll");
    static STRUCT_IF_C L_D_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(L_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_D_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu31ll, L_D_BFu31ll)
//============================================================================



static void Test_L_D_BFu32i()
{
  {
    init_simple_test("L_D_BFu32i");
    static STRUCT_IF_C L_D_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(L_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu32i)");
    check_field_offset(lv, v1, 0, "L_D_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_D_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu32i, L_D_BFu32i)
//============================================================================



static void Test_L_D_BFu32ll()
{
  {
    init_simple_test("L_D_BFu32ll");
    static STRUCT_IF_C L_D_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(L_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_D_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu32ll, L_D_BFu32ll)
//============================================================================



static void Test_L_D_BFu33()
{
  {
    init_simple_test("L_D_BFu33");
    static STRUCT_IF_C L_D_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(L_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu33)");
    check_field_offset(lv, v1, 0, "L_D_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "L_D_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "L_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu33, L_D_BFu33)
//============================================================================



static void Test_L_D_BFu7c()
{
  {
    init_simple_test("L_D_BFu7c");
    static STRUCT_IF_C L_D_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu7c)");
    check_field_offset(lv, v1, 0, "L_D_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_D_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu7c, L_D_BFu7c)
//============================================================================



static void Test_L_D_BFu7i()
{
  {
    init_simple_test("L_D_BFu7i");
    static STRUCT_IF_C L_D_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu7i)");
    check_field_offset(lv, v1, 0, "L_D_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_D_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu7i, L_D_BFu7i)
//============================================================================



static void Test_L_D_BFu7ll()
{
  {
    init_simple_test("L_D_BFu7ll");
    static STRUCT_IF_C L_D_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_D_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu7ll, L_D_BFu7ll)
//============================================================================



static void Test_L_D_BFu7s()
{
  {
    init_simple_test("L_D_BFu7s");
    static STRUCT_IF_C L_D_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu7s)");
    check_field_offset(lv, v1, 0, "L_D_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_D_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu7s, L_D_BFu7s)
//============================================================================



static void Test_L_D_BFu8c()
{
  {
    init_simple_test("L_D_BFu8c");
    static STRUCT_IF_C L_D_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu8c)");
    check_field_offset(lv, v1, 0, "L_D_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_D_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu8c, L_D_BFu8c)
//============================================================================



static void Test_L_D_BFu8i()
{
  {
    init_simple_test("L_D_BFu8i");
    static STRUCT_IF_C L_D_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu8i)");
    check_field_offset(lv, v1, 0, "L_D_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_D_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu8i, L_D_BFu8i)
//============================================================================



static void Test_L_D_BFu8ll()
{
  {
    init_simple_test("L_D_BFu8ll");
    static STRUCT_IF_C L_D_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_D_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu8ll, L_D_BFu8ll)
//============================================================================



static void Test_L_D_BFu8s()
{
  {
    init_simple_test("L_D_BFu8s");
    static STRUCT_IF_C L_D_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(L_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu8s)");
    check_field_offset(lv, v1, 0, "L_D_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_D_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu8s, L_D_BFu8s)
//============================================================================



static void Test_L_D_BFu9i()
{
  {
    init_simple_test("L_D_BFu9i");
    static STRUCT_IF_C L_D_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu9i)");
    check_field_offset(lv, v1, 0, "L_D_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_D_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu9i, L_D_BFu9i)
//============================================================================



static void Test_L_D_BFu9ll()
{
  {
    init_simple_test("L_D_BFu9ll");
    static STRUCT_IF_C L_D_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_D_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu9ll, L_D_BFu9ll)
//============================================================================



static void Test_L_D_BFu9s()
{
  {
    init_simple_test("L_D_BFu9s");
    static STRUCT_IF_C L_D_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(L_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_BFu9s)");
    check_field_offset(lv, v1, 0, "L_D_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_D_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_BFu9s, L_D_BFu9s)
//============================================================================



static void Test_L_D_C()
{
  {
    init_simple_test("L_D_C");
    STRUCT_IF_C L_D_C lv;
    check2(sizeof(lv), 17, "sizeof(L_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_C)");
    check_field_offset(lv, v1, 0, "L_D_C.v1");
    check_field_offset(lv, v2, 8, "L_D_C.v2");
    check_field_offset(lv, v3, 16, "L_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_C, L_D_C)
//============================================================================



static void Test_L_D_D()
{
  {
    init_simple_test("L_D_D");
    STRUCT_IF_C L_D_D lv;
    check2(sizeof(lv), 24, "sizeof(L_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_D)");
    check_field_offset(lv, v1, 0, "L_D_D.v1");
    check_field_offset(lv, v2, 8, "L_D_D.v2");
    check_field_offset(lv, v3, 16, "L_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_D, L_D_D)
//============================================================================



static void Test_L_D_F()
{
  {
    init_simple_test("L_D_F");
    STRUCT_IF_C L_D_F lv;
    check2(sizeof(lv), 20, "sizeof(L_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_F)");
    check_field_offset(lv, v1, 0, "L_D_F.v1");
    check_field_offset(lv, v2, 8, "L_D_F.v2");
    check_field_offset(lv, v3, 16, "L_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_F, L_D_F)
//============================================================================



static void Test_L_D_I()
{
  {
    init_simple_test("L_D_I");
    STRUCT_IF_C L_D_I lv;
    check2(sizeof(lv), 20, "sizeof(L_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_I)");
    check_field_offset(lv, v1, 0, "L_D_I.v1");
    check_field_offset(lv, v2, 8, "L_D_I.v2");
    check_field_offset(lv, v3, 16, "L_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_I, L_D_I)
//============================================================================



static void Test_L_D_Ip()
{
  {
    init_simple_test("L_D_Ip");
    STRUCT_IF_C L_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_Ip)");
    check_field_offset(lv, v1, 0, "L_D_Ip.v1");
    check_field_offset(lv, v2, 8, "L_D_Ip.v2");
    check_field_offset(lv, v3, 16, "L_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_Ip, L_D_Ip)
//============================================================================



static void Test_L_D_L()
{
  {
    init_simple_test("L_D_L");
    STRUCT_IF_C L_D_L lv;
    check2(sizeof(lv), 24, "sizeof(L_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_L)");
    check_field_offset(lv, v1, 0, "L_D_L.v1");
    check_field_offset(lv, v2, 8, "L_D_L.v2");
    check_field_offset(lv, v3, 16, "L_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_L, L_D_L)
//============================================================================



static void Test_L_D_S()
{
  {
    init_simple_test("L_D_S");
    STRUCT_IF_C L_D_S lv;
    check2(sizeof(lv), 18, "sizeof(L_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_S)");
    check_field_offset(lv, v1, 0, "L_D_S.v1");
    check_field_offset(lv, v2, 8, "L_D_S.v2");
    check_field_offset(lv, v3, 16, "L_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_S, L_D_S)
//============================================================================



static void Test_L_D_Uc()
{
  {
    init_simple_test("L_D_Uc");
    STRUCT_IF_C L_D_Uc lv;
    check2(sizeof(lv), 17, "sizeof(L_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_Uc)");
    check_field_offset(lv, v1, 0, "L_D_Uc.v1");
    check_field_offset(lv, v2, 8, "L_D_Uc.v2");
    check_field_offset(lv, v3, 16, "L_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_Uc, L_D_Uc)
//============================================================================



static void Test_L_D_Ui()
{
  {
    init_simple_test("L_D_Ui");
    STRUCT_IF_C L_D_Ui lv;
    check2(sizeof(lv), 20, "sizeof(L_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_Ui)");
    check_field_offset(lv, v1, 0, "L_D_Ui.v1");
    check_field_offset(lv, v2, 8, "L_D_Ui.v2");
    check_field_offset(lv, v3, 16, "L_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_Ui, L_D_Ui)
//============================================================================



static void Test_L_D_Ul()
{
  {
    init_simple_test("L_D_Ul");
    STRUCT_IF_C L_D_Ul lv;
    check2(sizeof(lv), 24, "sizeof(L_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_Ul)");
    check_field_offset(lv, v1, 0, "L_D_Ul.v1");
    check_field_offset(lv, v2, 8, "L_D_Ul.v2");
    check_field_offset(lv, v3, 16, "L_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_Ul, L_D_Ul)
//============================================================================



static void Test_L_D_Us()
{
  {
    init_simple_test("L_D_Us");
    STRUCT_IF_C L_D_Us lv;
    check2(sizeof(lv), 18, "sizeof(L_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_Us)");
    check_field_offset(lv, v1, 0, "L_D_Us.v1");
    check_field_offset(lv, v2, 8, "L_D_Us.v2");
    check_field_offset(lv, v3, 16, "L_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_Us, L_D_Us)
//============================================================================



static void Test_L_D_Vp()
{
  {
    init_simple_test("L_D_Vp");
    STRUCT_IF_C L_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_D_Vp)");
    check_field_offset(lv, v1, 0, "L_D_Vp.v1");
    check_field_offset(lv, v2, 8, "L_D_Vp.v2");
    check_field_offset(lv, v3, 16, "L_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_D_Vp, L_D_Vp)
//============================================================================



static void Test_L_F()
{
  {
    init_simple_test("L_F");
    STRUCT_IF_C L_F lv;
    check2(sizeof(lv), 12, "sizeof(L_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_F)");
    check_field_offset(lv, v1, 0, "L_F.v1");
    check_field_offset(lv, v2, 8, "L_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F, L_F)
//============================================================================



static void Test_L_F_BFu15i()
{
  {
    init_simple_test("L_F_BFu15i");
    static STRUCT_IF_C L_F_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu15i)");
    check_field_offset(lv, v1, 0, "L_F_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_F_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu15i, L_F_BFu15i)
//============================================================================



static void Test_L_F_BFu15ll()
{
  {
    init_simple_test("L_F_BFu15ll");
    static STRUCT_IF_C L_F_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_F_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu15ll, L_F_BFu15ll)
//============================================================================



static void Test_L_F_BFu15s()
{
  {
    init_simple_test("L_F_BFu15s");
    static STRUCT_IF_C L_F_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu15s)");
    check_field_offset(lv, v1, 0, "L_F_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_F_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu15s, L_F_BFu15s)
//============================================================================



static void Test_L_F_BFu16i()
{
  {
    init_simple_test("L_F_BFu16i");
    static STRUCT_IF_C L_F_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu16i)");
    check_field_offset(lv, v1, 0, "L_F_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_F_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu16i, L_F_BFu16i)
//============================================================================



static void Test_L_F_BFu16ll()
{
  {
    init_simple_test("L_F_BFu16ll");
    static STRUCT_IF_C L_F_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_F_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu16ll, L_F_BFu16ll)
//============================================================================



static void Test_L_F_BFu16s()
{
  {
    init_simple_test("L_F_BFu16s");
    static STRUCT_IF_C L_F_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu16s)");
    check_field_offset(lv, v1, 0, "L_F_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_F_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu16s, L_F_BFu16s)
//============================================================================



static void Test_L_F_BFu17i()
{
  {
    init_simple_test("L_F_BFu17i");
    static STRUCT_IF_C L_F_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(L_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu17i)");
    check_field_offset(lv, v1, 0, "L_F_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_F_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu17i, L_F_BFu17i)
//============================================================================



static void Test_L_F_BFu17ll()
{
  {
    init_simple_test("L_F_BFu17ll");
    static STRUCT_IF_C L_F_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(L_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_F_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu17ll, L_F_BFu17ll)
//============================================================================



static void Test_L_F_BFu1c()
{
  {
    init_simple_test("L_F_BFu1c");
    static STRUCT_IF_C L_F_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu1c)");
    check_field_offset(lv, v1, 0, "L_F_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu1c, L_F_BFu1c)
//============================================================================



static void Test_L_F_BFu1i()
{
  {
    init_simple_test("L_F_BFu1i");
    static STRUCT_IF_C L_F_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu1i)");
    check_field_offset(lv, v1, 0, "L_F_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu1i, L_F_BFu1i)
//============================================================================



static void Test_L_F_BFu1ll()
{
  {
    init_simple_test("L_F_BFu1ll");
    static STRUCT_IF_C L_F_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu1ll, L_F_BFu1ll)
//============================================================================



static void Test_L_F_BFu1s()
{
  {
    init_simple_test("L_F_BFu1s");
    static STRUCT_IF_C L_F_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu1s)");
    check_field_offset(lv, v1, 0, "L_F_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu1s, L_F_BFu1s)
//============================================================================



static void Test_L_F_BFu31i()
{
  {
    init_simple_test("L_F_BFu31i");
    static STRUCT_IF_C L_F_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu31i)");
    check_field_offset(lv, v1, 0, "L_F_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_F_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu31i, L_F_BFu31i)
//============================================================================



static void Test_L_F_BFu31ll()
{
  {
    init_simple_test("L_F_BFu31ll");
    static STRUCT_IF_C L_F_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_F_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu31ll, L_F_BFu31ll)
//============================================================================



static void Test_L_F_BFu32i()
{
  {
    init_simple_test("L_F_BFu32i");
    static STRUCT_IF_C L_F_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu32i)");
    check_field_offset(lv, v1, 0, "L_F_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_F_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu32i, L_F_BFu32i)
//============================================================================



static void Test_L_F_BFu32ll()
{
  {
    init_simple_test("L_F_BFu32ll");
    static STRUCT_IF_C L_F_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_F_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu32ll, L_F_BFu32ll)
//============================================================================



static void Test_L_F_BFu33()
{
  {
    init_simple_test("L_F_BFu33");
    static STRUCT_IF_C L_F_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(L_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu33)");
    check_field_offset(lv, v1, 0, "L_F_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "L_F_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "L_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu33, L_F_BFu33)
//============================================================================



static void Test_L_F_BFu7c()
{
  {
    init_simple_test("L_F_BFu7c");
    static STRUCT_IF_C L_F_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu7c)");
    check_field_offset(lv, v1, 0, "L_F_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_F_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu7c, L_F_BFu7c)
//============================================================================



static void Test_L_F_BFu7i()
{
  {
    init_simple_test("L_F_BFu7i");
    static STRUCT_IF_C L_F_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu7i)");
    check_field_offset(lv, v1, 0, "L_F_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_F_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu7i, L_F_BFu7i)
//============================================================================



static void Test_L_F_BFu7ll()
{
  {
    init_simple_test("L_F_BFu7ll");
    static STRUCT_IF_C L_F_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_F_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu7ll, L_F_BFu7ll)
//============================================================================



static void Test_L_F_BFu7s()
{
  {
    init_simple_test("L_F_BFu7s");
    static STRUCT_IF_C L_F_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu7s)");
    check_field_offset(lv, v1, 0, "L_F_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_F_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu7s, L_F_BFu7s)
//============================================================================



static void Test_L_F_BFu8c()
{
  {
    init_simple_test("L_F_BFu8c");
    static STRUCT_IF_C L_F_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu8c)");
    check_field_offset(lv, v1, 0, "L_F_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_F_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu8c, L_F_BFu8c)
//============================================================================



static void Test_L_F_BFu8i()
{
  {
    init_simple_test("L_F_BFu8i");
    static STRUCT_IF_C L_F_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu8i)");
    check_field_offset(lv, v1, 0, "L_F_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_F_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu8i, L_F_BFu8i)
//============================================================================



static void Test_L_F_BFu8ll()
{
  {
    init_simple_test("L_F_BFu8ll");
    static STRUCT_IF_C L_F_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_F_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu8ll, L_F_BFu8ll)
//============================================================================



static void Test_L_F_BFu8s()
{
  {
    init_simple_test("L_F_BFu8s");
    static STRUCT_IF_C L_F_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu8s)");
    check_field_offset(lv, v1, 0, "L_F_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_F_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu8s, L_F_BFu8s)
//============================================================================



static void Test_L_F_BFu9i()
{
  {
    init_simple_test("L_F_BFu9i");
    static STRUCT_IF_C L_F_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu9i)");
    check_field_offset(lv, v1, 0, "L_F_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_F_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu9i, L_F_BFu9i)
//============================================================================



static void Test_L_F_BFu9ll()
{
  {
    init_simple_test("L_F_BFu9ll");
    static STRUCT_IF_C L_F_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_F_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu9ll, L_F_BFu9ll)
//============================================================================



static void Test_L_F_BFu9s()
{
  {
    init_simple_test("L_F_BFu9s");
    static STRUCT_IF_C L_F_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(L_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_BFu9s)");
    check_field_offset(lv, v1, 0, "L_F_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_F_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_BFu9s, L_F_BFu9s)
//============================================================================



static void Test_L_F_C()
{
  {
    init_simple_test("L_F_C");
    STRUCT_IF_C L_F_C lv;
    check2(sizeof(lv), 13, "sizeof(L_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_C)");
    check_field_offset(lv, v1, 0, "L_F_C.v1");
    check_field_offset(lv, v2, 8, "L_F_C.v2");
    check_field_offset(lv, v3, 12, "L_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_C, L_F_C)
//============================================================================



static void Test_L_F_D()
{
  {
    init_simple_test("L_F_D");
    STRUCT_IF_C L_F_D lv;
    check2(sizeof(lv), 20, "sizeof(L_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_D)");
    check_field_offset(lv, v1, 0, "L_F_D.v1");
    check_field_offset(lv, v2, 8, "L_F_D.v2");
    check_field_offset(lv, v3, 12, "L_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_D, L_F_D)
//============================================================================



static void Test_L_F_F()
{
  {
    init_simple_test("L_F_F");
    STRUCT_IF_C L_F_F lv;
    check2(sizeof(lv), 16, "sizeof(L_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_F)");
    check_field_offset(lv, v1, 0, "L_F_F.v1");
    check_field_offset(lv, v2, 8, "L_F_F.v2");
    check_field_offset(lv, v3, 12, "L_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_F, L_F_F)
//============================================================================



static void Test_L_F_I()
{
  {
    init_simple_test("L_F_I");
    STRUCT_IF_C L_F_I lv;
    check2(sizeof(lv), 16, "sizeof(L_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_I)");
    check_field_offset(lv, v1, 0, "L_F_I.v1");
    check_field_offset(lv, v2, 8, "L_F_I.v2");
    check_field_offset(lv, v3, 12, "L_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_I, L_F_I)
//============================================================================



static void Test_L_F_Ip()
{
  {
    init_simple_test("L_F_Ip");
    STRUCT_IF_C L_F_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_Ip)");
    check_field_offset(lv, v1, 0, "L_F_Ip.v1");
    check_field_offset(lv, v2, 8, "L_F_Ip.v2");
    check_field_offset(lv, v3, 12, "L_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_Ip, L_F_Ip)
//============================================================================



static void Test_L_F_L()
{
  {
    init_simple_test("L_F_L");
    STRUCT_IF_C L_F_L lv;
    check2(sizeof(lv), 20, "sizeof(L_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_L)");
    check_field_offset(lv, v1, 0, "L_F_L.v1");
    check_field_offset(lv, v2, 8, "L_F_L.v2");
    check_field_offset(lv, v3, 12, "L_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_L, L_F_L)
//============================================================================



static void Test_L_F_S()
{
  {
    init_simple_test("L_F_S");
    STRUCT_IF_C L_F_S lv;
    check2(sizeof(lv), 14, "sizeof(L_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_S)");
    check_field_offset(lv, v1, 0, "L_F_S.v1");
    check_field_offset(lv, v2, 8, "L_F_S.v2");
    check_field_offset(lv, v3, 12, "L_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_S, L_F_S)
//============================================================================



static void Test_L_F_Uc()
{
  {
    init_simple_test("L_F_Uc");
    STRUCT_IF_C L_F_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_Uc)");
    check_field_offset(lv, v1, 0, "L_F_Uc.v1");
    check_field_offset(lv, v2, 8, "L_F_Uc.v2");
    check_field_offset(lv, v3, 12, "L_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_Uc, L_F_Uc)
//============================================================================



static void Test_L_F_Ui()
{
  {
    init_simple_test("L_F_Ui");
    STRUCT_IF_C L_F_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_Ui)");
    check_field_offset(lv, v1, 0, "L_F_Ui.v1");
    check_field_offset(lv, v2, 8, "L_F_Ui.v2");
    check_field_offset(lv, v3, 12, "L_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_Ui, L_F_Ui)
//============================================================================



static void Test_L_F_Ul()
{
  {
    init_simple_test("L_F_Ul");
    STRUCT_IF_C L_F_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_Ul)");
    check_field_offset(lv, v1, 0, "L_F_Ul.v1");
    check_field_offset(lv, v2, 8, "L_F_Ul.v2");
    check_field_offset(lv, v3, 12, "L_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_Ul, L_F_Ul)
//============================================================================



static void Test_L_F_Us()
{
  {
    init_simple_test("L_F_Us");
    STRUCT_IF_C L_F_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_Us)");
    check_field_offset(lv, v1, 0, "L_F_Us.v1");
    check_field_offset(lv, v2, 8, "L_F_Us.v2");
    check_field_offset(lv, v3, 12, "L_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_Us, L_F_Us)
//============================================================================



static void Test_L_F_Vp()
{
  {
    init_simple_test("L_F_Vp");
    STRUCT_IF_C L_F_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_F_Vp)");
    check_field_offset(lv, v1, 0, "L_F_Vp.v1");
    check_field_offset(lv, v2, 8, "L_F_Vp.v2");
    check_field_offset(lv, v3, 12, "L_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_F_Vp, L_F_Vp)
//============================================================================



static void Test_L_I()
{
  {
    init_simple_test("L_I");
    STRUCT_IF_C L_I lv;
    check2(sizeof(lv), 12, "sizeof(L_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_I)");
    check_field_offset(lv, v1, 0, "L_I.v1");
    check_field_offset(lv, v2, 8, "L_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I, L_I)
//============================================================================



static void Test_L_I_BFu15i()
{
  {
    init_simple_test("L_I_BFu15i");
    static STRUCT_IF_C L_I_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu15i)");
    check_field_offset(lv, v1, 0, "L_I_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_I_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu15i, L_I_BFu15i)
//============================================================================



static void Test_L_I_BFu15ll()
{
  {
    init_simple_test("L_I_BFu15ll");
    static STRUCT_IF_C L_I_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_I_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu15ll, L_I_BFu15ll)
//============================================================================



static void Test_L_I_BFu15s()
{
  {
    init_simple_test("L_I_BFu15s");
    static STRUCT_IF_C L_I_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu15s)");
    check_field_offset(lv, v1, 0, "L_I_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_I_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu15s, L_I_BFu15s)
//============================================================================



static void Test_L_I_BFu16i()
{
  {
    init_simple_test("L_I_BFu16i");
    static STRUCT_IF_C L_I_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu16i)");
    check_field_offset(lv, v1, 0, "L_I_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_I_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu16i, L_I_BFu16i)
//============================================================================



static void Test_L_I_BFu16ll()
{
  {
    init_simple_test("L_I_BFu16ll");
    static STRUCT_IF_C L_I_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_I_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu16ll, L_I_BFu16ll)
//============================================================================



static void Test_L_I_BFu16s()
{
  {
    init_simple_test("L_I_BFu16s");
    static STRUCT_IF_C L_I_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu16s)");
    check_field_offset(lv, v1, 0, "L_I_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_I_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu16s, L_I_BFu16s)
//============================================================================



static void Test_L_I_BFu17i()
{
  {
    init_simple_test("L_I_BFu17i");
    static STRUCT_IF_C L_I_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(L_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu17i)");
    check_field_offset(lv, v1, 0, "L_I_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_I_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu17i, L_I_BFu17i)
//============================================================================



static void Test_L_I_BFu17ll()
{
  {
    init_simple_test("L_I_BFu17ll");
    static STRUCT_IF_C L_I_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(L_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_I_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu17ll, L_I_BFu17ll)
//============================================================================



static void Test_L_I_BFu1c()
{
  {
    init_simple_test("L_I_BFu1c");
    static STRUCT_IF_C L_I_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu1c)");
    check_field_offset(lv, v1, 0, "L_I_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu1c, L_I_BFu1c)
//============================================================================



static void Test_L_I_BFu1i()
{
  {
    init_simple_test("L_I_BFu1i");
    static STRUCT_IF_C L_I_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu1i)");
    check_field_offset(lv, v1, 0, "L_I_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu1i, L_I_BFu1i)
//============================================================================



static void Test_L_I_BFu1ll()
{
  {
    init_simple_test("L_I_BFu1ll");
    static STRUCT_IF_C L_I_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu1ll, L_I_BFu1ll)
//============================================================================



static void Test_L_I_BFu1s()
{
  {
    init_simple_test("L_I_BFu1s");
    static STRUCT_IF_C L_I_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu1s)");
    check_field_offset(lv, v1, 0, "L_I_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu1s, L_I_BFu1s)
//============================================================================



static void Test_L_I_BFu31i()
{
  {
    init_simple_test("L_I_BFu31i");
    static STRUCT_IF_C L_I_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu31i)");
    check_field_offset(lv, v1, 0, "L_I_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_I_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu31i, L_I_BFu31i)
//============================================================================



static void Test_L_I_BFu31ll()
{
  {
    init_simple_test("L_I_BFu31ll");
    static STRUCT_IF_C L_I_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_I_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu31ll, L_I_BFu31ll)
//============================================================================



static void Test_L_I_BFu32i()
{
  {
    init_simple_test("L_I_BFu32i");
    static STRUCT_IF_C L_I_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu32i)");
    check_field_offset(lv, v1, 0, "L_I_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_I_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu32i, L_I_BFu32i)
//============================================================================



static void Test_L_I_BFu32ll()
{
  {
    init_simple_test("L_I_BFu32ll");
    static STRUCT_IF_C L_I_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_I_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu32ll, L_I_BFu32ll)
//============================================================================



static void Test_L_I_BFu33()
{
  {
    init_simple_test("L_I_BFu33");
    static STRUCT_IF_C L_I_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(L_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu33)");
    check_field_offset(lv, v1, 0, "L_I_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "L_I_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "L_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu33, L_I_BFu33)
//============================================================================



static void Test_L_I_BFu7c()
{
  {
    init_simple_test("L_I_BFu7c");
    static STRUCT_IF_C L_I_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu7c)");
    check_field_offset(lv, v1, 0, "L_I_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_I_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu7c, L_I_BFu7c)
//============================================================================



static void Test_L_I_BFu7i()
{
  {
    init_simple_test("L_I_BFu7i");
    static STRUCT_IF_C L_I_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu7i)");
    check_field_offset(lv, v1, 0, "L_I_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_I_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu7i, L_I_BFu7i)
//============================================================================



static void Test_L_I_BFu7ll()
{
  {
    init_simple_test("L_I_BFu7ll");
    static STRUCT_IF_C L_I_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_I_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu7ll, L_I_BFu7ll)
//============================================================================



static void Test_L_I_BFu7s()
{
  {
    init_simple_test("L_I_BFu7s");
    static STRUCT_IF_C L_I_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu7s)");
    check_field_offset(lv, v1, 0, "L_I_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_I_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu7s, L_I_BFu7s)
//============================================================================



static void Test_L_I_BFu8c()
{
  {
    init_simple_test("L_I_BFu8c");
    static STRUCT_IF_C L_I_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu8c)");
    check_field_offset(lv, v1, 0, "L_I_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_I_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu8c, L_I_BFu8c)
//============================================================================



static void Test_L_I_BFu8i()
{
  {
    init_simple_test("L_I_BFu8i");
    static STRUCT_IF_C L_I_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu8i)");
    check_field_offset(lv, v1, 0, "L_I_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_I_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu8i, L_I_BFu8i)
//============================================================================



static void Test_L_I_BFu8ll()
{
  {
    init_simple_test("L_I_BFu8ll");
    static STRUCT_IF_C L_I_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_I_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu8ll, L_I_BFu8ll)
//============================================================================



static void Test_L_I_BFu8s()
{
  {
    init_simple_test("L_I_BFu8s");
    static STRUCT_IF_C L_I_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu8s)");
    check_field_offset(lv, v1, 0, "L_I_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_I_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu8s, L_I_BFu8s)
//============================================================================



static void Test_L_I_BFu9i()
{
  {
    init_simple_test("L_I_BFu9i");
    static STRUCT_IF_C L_I_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu9i)");
    check_field_offset(lv, v1, 0, "L_I_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_I_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu9i, L_I_BFu9i)
//============================================================================



static void Test_L_I_BFu9ll()
{
  {
    init_simple_test("L_I_BFu9ll");
    static STRUCT_IF_C L_I_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_I_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu9ll, L_I_BFu9ll)
//============================================================================



static void Test_L_I_BFu9s()
{
  {
    init_simple_test("L_I_BFu9s");
    static STRUCT_IF_C L_I_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(L_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_BFu9s)");
    check_field_offset(lv, v1, 0, "L_I_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_I_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_BFu9s, L_I_BFu9s)
//============================================================================



static void Test_L_I_C()
{
  {
    init_simple_test("L_I_C");
    STRUCT_IF_C L_I_C lv;
    check2(sizeof(lv), 13, "sizeof(L_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_C)");
    check_field_offset(lv, v1, 0, "L_I_C.v1");
    check_field_offset(lv, v2, 8, "L_I_C.v2");
    check_field_offset(lv, v3, 12, "L_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_C, L_I_C)
//============================================================================



static void Test_L_I_D()
{
  {
    init_simple_test("L_I_D");
    STRUCT_IF_C L_I_D lv;
    check2(sizeof(lv), 20, "sizeof(L_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_D)");
    check_field_offset(lv, v1, 0, "L_I_D.v1");
    check_field_offset(lv, v2, 8, "L_I_D.v2");
    check_field_offset(lv, v3, 12, "L_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_D, L_I_D)
//============================================================================



static void Test_L_I_F()
{
  {
    init_simple_test("L_I_F");
    STRUCT_IF_C L_I_F lv;
    check2(sizeof(lv), 16, "sizeof(L_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_F)");
    check_field_offset(lv, v1, 0, "L_I_F.v1");
    check_field_offset(lv, v2, 8, "L_I_F.v2");
    check_field_offset(lv, v3, 12, "L_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_F, L_I_F)
//============================================================================



static void Test_L_I_I()
{
  {
    init_simple_test("L_I_I");
    STRUCT_IF_C L_I_I lv;
    check2(sizeof(lv), 16, "sizeof(L_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_I)");
    check_field_offset(lv, v1, 0, "L_I_I.v1");
    check_field_offset(lv, v2, 8, "L_I_I.v2");
    check_field_offset(lv, v3, 12, "L_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_I, L_I_I)
//============================================================================



static void Test_L_I_Ip()
{
  {
    init_simple_test("L_I_Ip");
    STRUCT_IF_C L_I_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_Ip)");
    check_field_offset(lv, v1, 0, "L_I_Ip.v1");
    check_field_offset(lv, v2, 8, "L_I_Ip.v2");
    check_field_offset(lv, v3, 12, "L_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_Ip, L_I_Ip)
//============================================================================



static void Test_L_I_L()
{
  {
    init_simple_test("L_I_L");
    STRUCT_IF_C L_I_L lv;
    check2(sizeof(lv), 20, "sizeof(L_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_L)");
    check_field_offset(lv, v1, 0, "L_I_L.v1");
    check_field_offset(lv, v2, 8, "L_I_L.v2");
    check_field_offset(lv, v3, 12, "L_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_L, L_I_L)
//============================================================================



static void Test_L_I_S()
{
  {
    init_simple_test("L_I_S");
    STRUCT_IF_C L_I_S lv;
    check2(sizeof(lv), 14, "sizeof(L_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_S)");
    check_field_offset(lv, v1, 0, "L_I_S.v1");
    check_field_offset(lv, v2, 8, "L_I_S.v2");
    check_field_offset(lv, v3, 12, "L_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_S, L_I_S)
//============================================================================



static void Test_L_I_Uc()
{
  {
    init_simple_test("L_I_Uc");
    STRUCT_IF_C L_I_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_Uc)");
    check_field_offset(lv, v1, 0, "L_I_Uc.v1");
    check_field_offset(lv, v2, 8, "L_I_Uc.v2");
    check_field_offset(lv, v3, 12, "L_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_Uc, L_I_Uc)
//============================================================================



static void Test_L_I_Ui()
{
  {
    init_simple_test("L_I_Ui");
    STRUCT_IF_C L_I_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_Ui)");
    check_field_offset(lv, v1, 0, "L_I_Ui.v1");
    check_field_offset(lv, v2, 8, "L_I_Ui.v2");
    check_field_offset(lv, v3, 12, "L_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_Ui, L_I_Ui)
//============================================================================



static void Test_L_I_Ul()
{
  {
    init_simple_test("L_I_Ul");
    STRUCT_IF_C L_I_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_Ul)");
    check_field_offset(lv, v1, 0, "L_I_Ul.v1");
    check_field_offset(lv, v2, 8, "L_I_Ul.v2");
    check_field_offset(lv, v3, 12, "L_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_Ul, L_I_Ul)
//============================================================================



static void Test_L_I_Us()
{
  {
    init_simple_test("L_I_Us");
    STRUCT_IF_C L_I_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_Us)");
    check_field_offset(lv, v1, 0, "L_I_Us.v1");
    check_field_offset(lv, v2, 8, "L_I_Us.v2");
    check_field_offset(lv, v3, 12, "L_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_Us, L_I_Us)
//============================================================================



static void Test_L_I_Vp()
{
  {
    init_simple_test("L_I_Vp");
    STRUCT_IF_C L_I_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_I_Vp)");
    check_field_offset(lv, v1, 0, "L_I_Vp.v1");
    check_field_offset(lv, v2, 8, "L_I_Vp.v2");
    check_field_offset(lv, v3, 12, "L_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_I_Vp, L_I_Vp)
//============================================================================



static void Test_L_Ip()
{
  {
    init_simple_test("L_Ip");
    STRUCT_IF_C L_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip)");
    check_field_offset(lv, v1, 0, "L_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip, L_Ip)
//============================================================================



static void Test_L_Ip_BFu15i()
{
  {
    init_simple_test("L_Ip_BFu15i");
    static STRUCT_IF_C L_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu15i, L_Ip_BFu15i)
//============================================================================



static void Test_L_Ip_BFu15ll()
{
  {
    init_simple_test("L_Ip_BFu15ll");
    static STRUCT_IF_C L_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu15ll, L_Ip_BFu15ll)
//============================================================================



static void Test_L_Ip_BFu15s()
{
  {
    init_simple_test("L_Ip_BFu15s");
    static STRUCT_IF_C L_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu15s, L_Ip_BFu15s)
//============================================================================



static void Test_L_Ip_BFu16i()
{
  {
    init_simple_test("L_Ip_BFu16i");
    static STRUCT_IF_C L_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu16i, L_Ip_BFu16i)
//============================================================================



static void Test_L_Ip_BFu16ll()
{
  {
    init_simple_test("L_Ip_BFu16ll");
    static STRUCT_IF_C L_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu16ll, L_Ip_BFu16ll)
//============================================================================



static void Test_L_Ip_BFu16s()
{
  {
    init_simple_test("L_Ip_BFu16s");
    static STRUCT_IF_C L_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu16s, L_Ip_BFu16s)
//============================================================================



static void Test_L_Ip_BFu17i()
{
  {
    init_simple_test("L_Ip_BFu17i");
    static STRUCT_IF_C L_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(L_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "L_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "L_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu17i, L_Ip_BFu17i)
//============================================================================



static void Test_L_Ip_BFu17ll()
{
  {
    init_simple_test("L_Ip_BFu17ll");
    static STRUCT_IF_C L_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(L_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "L_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "L_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu17ll, L_Ip_BFu17ll)
//============================================================================



static void Test_L_Ip_BFu1c()
{
  {
    init_simple_test("L_Ip_BFu1c");
    static STRUCT_IF_C L_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu1c, L_Ip_BFu1c)
//============================================================================



static void Test_L_Ip_BFu1i()
{
  {
    init_simple_test("L_Ip_BFu1i");
    static STRUCT_IF_C L_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu1i, L_Ip_BFu1i)
//============================================================================



static void Test_L_Ip_BFu1ll()
{
  {
    init_simple_test("L_Ip_BFu1ll");
    static STRUCT_IF_C L_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu1ll, L_Ip_BFu1ll)
//============================================================================



static void Test_L_Ip_BFu1s()
{
  {
    init_simple_test("L_Ip_BFu1s");
    static STRUCT_IF_C L_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu1s, L_Ip_BFu1s)
//============================================================================



static void Test_L_Ip_BFu31i()
{
  {
    init_simple_test("L_Ip_BFu31i");
    static STRUCT_IF_C L_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "L_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "L_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu31i, L_Ip_BFu31i)
//============================================================================



static void Test_L_Ip_BFu31ll()
{
  {
    init_simple_test("L_Ip_BFu31ll");
    static STRUCT_IF_C L_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "L_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "L_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu31ll, L_Ip_BFu31ll)
//============================================================================



static void Test_L_Ip_BFu32i()
{
  {
    init_simple_test("L_Ip_BFu32i");
    static STRUCT_IF_C L_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "L_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "L_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu32i, L_Ip_BFu32i)
//============================================================================



static void Test_L_Ip_BFu32ll()
{
  {
    init_simple_test("L_Ip_BFu32ll");
    static STRUCT_IF_C L_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "L_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "L_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu32ll, L_Ip_BFu32ll)
//============================================================================



static void Test_L_Ip_BFu33()
{
  {
    init_simple_test("L_Ip_BFu33");
    static STRUCT_IF_C L_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(L_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "L_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "L_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu33, L_Ip_BFu33)
//============================================================================



static void Test_L_Ip_BFu7c()
{
  {
    init_simple_test("L_Ip_BFu7c");
    static STRUCT_IF_C L_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu7c, L_Ip_BFu7c)
//============================================================================



static void Test_L_Ip_BFu7i()
{
  {
    init_simple_test("L_Ip_BFu7i");
    static STRUCT_IF_C L_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu7i, L_Ip_BFu7i)
//============================================================================



static void Test_L_Ip_BFu7ll()
{
  {
    init_simple_test("L_Ip_BFu7ll");
    static STRUCT_IF_C L_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu7ll, L_Ip_BFu7ll)
//============================================================================



static void Test_L_Ip_BFu7s()
{
  {
    init_simple_test("L_Ip_BFu7s");
    static STRUCT_IF_C L_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu7s, L_Ip_BFu7s)
//============================================================================



static void Test_L_Ip_BFu8c()
{
  {
    init_simple_test("L_Ip_BFu8c");
    static STRUCT_IF_C L_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu8c, L_Ip_BFu8c)
//============================================================================



static void Test_L_Ip_BFu8i()
{
  {
    init_simple_test("L_Ip_BFu8i");
    static STRUCT_IF_C L_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu8i, L_Ip_BFu8i)
//============================================================================



static void Test_L_Ip_BFu8ll()
{
  {
    init_simple_test("L_Ip_BFu8ll");
    static STRUCT_IF_C L_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu8ll, L_Ip_BFu8ll)
//============================================================================



static void Test_L_Ip_BFu8s()
{
  {
    init_simple_test("L_Ip_BFu8s");
    static STRUCT_IF_C L_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu8s, L_Ip_BFu8s)
//============================================================================



static void Test_L_Ip_BFu9i()
{
  {
    init_simple_test("L_Ip_BFu9i");
    static STRUCT_IF_C L_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu9i, L_Ip_BFu9i)
//============================================================================



static void Test_L_Ip_BFu9ll()
{
  {
    init_simple_test("L_Ip_BFu9ll");
    static STRUCT_IF_C L_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu9ll, L_Ip_BFu9ll)
//============================================================================



static void Test_L_Ip_BFu9s()
{
  {
    init_simple_test("L_Ip_BFu9s");
    static STRUCT_IF_C L_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_BFu9s, L_Ip_BFu9s)
//============================================================================



static void Test_L_Ip_C()
{
  {
    init_simple_test("L_Ip_C");
    STRUCT_IF_C L_Ip_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_C)");
    check_field_offset(lv, v1, 0, "L_Ip_C.v1");
    check_field_offset(lv, v2, 8, "L_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_C, L_Ip_C)
//============================================================================



static void Test_L_Ip_D()
{
  {
    init_simple_test("L_Ip_D");
    STRUCT_IF_C L_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_D)");
    check_field_offset(lv, v1, 0, "L_Ip_D.v1");
    check_field_offset(lv, v2, 8, "L_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_D, L_Ip_D)
//============================================================================



static void Test_L_Ip_F()
{
  {
    init_simple_test("L_Ip_F");
    STRUCT_IF_C L_Ip_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_F)");
    check_field_offset(lv, v1, 0, "L_Ip_F.v1");
    check_field_offset(lv, v2, 8, "L_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_F, L_Ip_F)
//============================================================================



static void Test_L_Ip_I()
{
  {
    init_simple_test("L_Ip_I");
    STRUCT_IF_C L_Ip_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_I)");
    check_field_offset(lv, v1, 0, "L_Ip_I.v1");
    check_field_offset(lv, v2, 8, "L_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_I, L_Ip_I)
//============================================================================



static void Test_L_Ip_Ip()
{
  {
    init_simple_test("L_Ip_Ip");
    STRUCT_IF_C L_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_Ip)");
    check_field_offset(lv, v1, 0, "L_Ip_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_Ip, L_Ip_Ip)
//============================================================================



static void Test_L_Ip_L()
{
  {
    init_simple_test("L_Ip_L");
    STRUCT_IF_C L_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_L)");
    check_field_offset(lv, v1, 0, "L_Ip_L.v1");
    check_field_offset(lv, v2, 8, "L_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_L, L_Ip_L)
//============================================================================



static void Test_L_Ip_S()
{
  {
    init_simple_test("L_Ip_S");
    STRUCT_IF_C L_Ip_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_S)");
    check_field_offset(lv, v1, 0, "L_Ip_S.v1");
    check_field_offset(lv, v2, 8, "L_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_S, L_Ip_S)
//============================================================================



static void Test_L_Ip_Uc()
{
  {
    init_simple_test("L_Ip_Uc");
    STRUCT_IF_C L_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_Uc)");
    check_field_offset(lv, v1, 0, "L_Ip_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_Uc, L_Ip_Uc)
//============================================================================



static void Test_L_Ip_Ui()
{
  {
    init_simple_test("L_Ip_Ui");
    STRUCT_IF_C L_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_Ui)");
    check_field_offset(lv, v1, 0, "L_Ip_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_Ui, L_Ip_Ui)
//============================================================================



static void Test_L_Ip_Ul()
{
  {
    init_simple_test("L_Ip_Ul");
    STRUCT_IF_C L_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_Ul)");
    check_field_offset(lv, v1, 0, "L_Ip_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_Ul, L_Ip_Ul)
//============================================================================



static void Test_L_Ip_Us()
{
  {
    init_simple_test("L_Ip_Us");
    STRUCT_IF_C L_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_Us)");
    check_field_offset(lv, v1, 0, "L_Ip_Us.v1");
    check_field_offset(lv, v2, 8, "L_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_Us, L_Ip_Us)
//============================================================================



static void Test_L_Ip_Vp()
{
  {
    init_simple_test("L_Ip_Vp");
    STRUCT_IF_C L_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ip_Vp)");
    check_field_offset(lv, v1, 0, "L_Ip_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ip_Vp, L_Ip_Vp)
//============================================================================



static void Test_L_L()
{
  {
    init_simple_test("L_L");
    STRUCT_IF_C L_L lv;
    check2(sizeof(lv), 16, "sizeof(L_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_L)");
    check_field_offset(lv, v1, 0, "L_L.v1");
    check_field_offset(lv, v2, 8, "L_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L, L_L)
//============================================================================



static void Test_L_L_BFu15i()
{
  {
    init_simple_test("L_L_BFu15i");
    static STRUCT_IF_C L_L_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu15i)");
    check_field_offset(lv, v1, 0, "L_L_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_L_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu15i, L_L_BFu15i)
//============================================================================



static void Test_L_L_BFu15ll()
{
  {
    init_simple_test("L_L_BFu15ll");
    static STRUCT_IF_C L_L_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_L_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu15ll, L_L_BFu15ll)
//============================================================================



static void Test_L_L_BFu15s()
{
  {
    init_simple_test("L_L_BFu15s");
    static STRUCT_IF_C L_L_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu15s)");
    check_field_offset(lv, v1, 0, "L_L_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_L_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu15s, L_L_BFu15s)
//============================================================================



static void Test_L_L_BFu16i()
{
  {
    init_simple_test("L_L_BFu16i");
    static STRUCT_IF_C L_L_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu16i)");
    check_field_offset(lv, v1, 0, "L_L_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_L_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu16i, L_L_BFu16i)
//============================================================================



static void Test_L_L_BFu16ll()
{
  {
    init_simple_test("L_L_BFu16ll");
    static STRUCT_IF_C L_L_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_L_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu16ll, L_L_BFu16ll)
//============================================================================



static void Test_L_L_BFu16s()
{
  {
    init_simple_test("L_L_BFu16s");
    static STRUCT_IF_C L_L_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu16s)");
    check_field_offset(lv, v1, 0, "L_L_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_L_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu16s, L_L_BFu16s)
//============================================================================



static void Test_L_L_BFu17i()
{
  {
    init_simple_test("L_L_BFu17i");
    static STRUCT_IF_C L_L_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(L_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu17i)");
    check_field_offset(lv, v1, 0, "L_L_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_L_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu17i, L_L_BFu17i)
//============================================================================



static void Test_L_L_BFu17ll()
{
  {
    init_simple_test("L_L_BFu17ll");
    static STRUCT_IF_C L_L_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(L_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_L_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu17ll, L_L_BFu17ll)
//============================================================================



static void Test_L_L_BFu1c()
{
  {
    init_simple_test("L_L_BFu1c");
    static STRUCT_IF_C L_L_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu1c)");
    check_field_offset(lv, v1, 0, "L_L_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu1c, L_L_BFu1c)
//============================================================================



static void Test_L_L_BFu1i()
{
  {
    init_simple_test("L_L_BFu1i");
    static STRUCT_IF_C L_L_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu1i)");
    check_field_offset(lv, v1, 0, "L_L_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu1i, L_L_BFu1i)
//============================================================================



static void Test_L_L_BFu1ll()
{
  {
    init_simple_test("L_L_BFu1ll");
    static STRUCT_IF_C L_L_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu1ll, L_L_BFu1ll)
//============================================================================



static void Test_L_L_BFu1s()
{
  {
    init_simple_test("L_L_BFu1s");
    static STRUCT_IF_C L_L_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu1s)");
    check_field_offset(lv, v1, 0, "L_L_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu1s, L_L_BFu1s)
//============================================================================



static void Test_L_L_BFu31i()
{
  {
    init_simple_test("L_L_BFu31i");
    static STRUCT_IF_C L_L_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(L_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu31i)");
    check_field_offset(lv, v1, 0, "L_L_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_L_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu31i, L_L_BFu31i)
//============================================================================



static void Test_L_L_BFu31ll()
{
  {
    init_simple_test("L_L_BFu31ll");
    static STRUCT_IF_C L_L_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(L_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_L_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu31ll, L_L_BFu31ll)
//============================================================================



static void Test_L_L_BFu32i()
{
  {
    init_simple_test("L_L_BFu32i");
    static STRUCT_IF_C L_L_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(L_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu32i)");
    check_field_offset(lv, v1, 0, "L_L_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_L_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu32i, L_L_BFu32i)
//============================================================================



static void Test_L_L_BFu32ll()
{
  {
    init_simple_test("L_L_BFu32ll");
    static STRUCT_IF_C L_L_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(L_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_L_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu32ll, L_L_BFu32ll)
//============================================================================



static void Test_L_L_BFu33()
{
  {
    init_simple_test("L_L_BFu33");
    static STRUCT_IF_C L_L_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(L_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu33)");
    check_field_offset(lv, v1, 0, "L_L_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "L_L_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "L_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu33, L_L_BFu33)
//============================================================================



static void Test_L_L_BFu7c()
{
  {
    init_simple_test("L_L_BFu7c");
    static STRUCT_IF_C L_L_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu7c)");
    check_field_offset(lv, v1, 0, "L_L_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_L_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu7c, L_L_BFu7c)
//============================================================================



static void Test_L_L_BFu7i()
{
  {
    init_simple_test("L_L_BFu7i");
    static STRUCT_IF_C L_L_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu7i)");
    check_field_offset(lv, v1, 0, "L_L_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_L_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu7i, L_L_BFu7i)
//============================================================================



static void Test_L_L_BFu7ll()
{
  {
    init_simple_test("L_L_BFu7ll");
    static STRUCT_IF_C L_L_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_L_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu7ll, L_L_BFu7ll)
//============================================================================



static void Test_L_L_BFu7s()
{
  {
    init_simple_test("L_L_BFu7s");
    static STRUCT_IF_C L_L_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu7s)");
    check_field_offset(lv, v1, 0, "L_L_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_L_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu7s, L_L_BFu7s)
//============================================================================



static void Test_L_L_BFu8c()
{
  {
    init_simple_test("L_L_BFu8c");
    static STRUCT_IF_C L_L_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu8c)");
    check_field_offset(lv, v1, 0, "L_L_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_L_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu8c, L_L_BFu8c)
//============================================================================



static void Test_L_L_BFu8i()
{
  {
    init_simple_test("L_L_BFu8i");
    static STRUCT_IF_C L_L_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu8i)");
    check_field_offset(lv, v1, 0, "L_L_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_L_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu8i, L_L_BFu8i)
//============================================================================



static void Test_L_L_BFu8ll()
{
  {
    init_simple_test("L_L_BFu8ll");
    static STRUCT_IF_C L_L_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_L_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu8ll, L_L_BFu8ll)
//============================================================================



static void Test_L_L_BFu8s()
{
  {
    init_simple_test("L_L_BFu8s");
    static STRUCT_IF_C L_L_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(L_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu8s)");
    check_field_offset(lv, v1, 0, "L_L_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_L_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu8s, L_L_BFu8s)
//============================================================================



static void Test_L_L_BFu9i()
{
  {
    init_simple_test("L_L_BFu9i");
    static STRUCT_IF_C L_L_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu9i)");
    check_field_offset(lv, v1, 0, "L_L_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_L_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu9i, L_L_BFu9i)
//============================================================================



static void Test_L_L_BFu9ll()
{
  {
    init_simple_test("L_L_BFu9ll");
    static STRUCT_IF_C L_L_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_L_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu9ll, L_L_BFu9ll)
//============================================================================



static void Test_L_L_BFu9s()
{
  {
    init_simple_test("L_L_BFu9s");
    static STRUCT_IF_C L_L_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(L_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_BFu9s)");
    check_field_offset(lv, v1, 0, "L_L_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_L_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_BFu9s, L_L_BFu9s)
//============================================================================



static void Test_L_L_C()
{
  {
    init_simple_test("L_L_C");
    STRUCT_IF_C L_L_C lv;
    check2(sizeof(lv), 17, "sizeof(L_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_C)");
    check_field_offset(lv, v1, 0, "L_L_C.v1");
    check_field_offset(lv, v2, 8, "L_L_C.v2");
    check_field_offset(lv, v3, 16, "L_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_C, L_L_C)
//============================================================================



static void Test_L_L_D()
{
  {
    init_simple_test("L_L_D");
    STRUCT_IF_C L_L_D lv;
    check2(sizeof(lv), 24, "sizeof(L_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_D)");
    check_field_offset(lv, v1, 0, "L_L_D.v1");
    check_field_offset(lv, v2, 8, "L_L_D.v2");
    check_field_offset(lv, v3, 16, "L_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_D, L_L_D)
//============================================================================



static void Test_L_L_F()
{
  {
    init_simple_test("L_L_F");
    STRUCT_IF_C L_L_F lv;
    check2(sizeof(lv), 20, "sizeof(L_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_F)");
    check_field_offset(lv, v1, 0, "L_L_F.v1");
    check_field_offset(lv, v2, 8, "L_L_F.v2");
    check_field_offset(lv, v3, 16, "L_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_F, L_L_F)
//============================================================================



static void Test_L_L_I()
{
  {
    init_simple_test("L_L_I");
    STRUCT_IF_C L_L_I lv;
    check2(sizeof(lv), 20, "sizeof(L_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_I)");
    check_field_offset(lv, v1, 0, "L_L_I.v1");
    check_field_offset(lv, v2, 8, "L_L_I.v2");
    check_field_offset(lv, v3, 16, "L_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_I, L_L_I)
//============================================================================



static void Test_L_L_Ip()
{
  {
    init_simple_test("L_L_Ip");
    STRUCT_IF_C L_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_Ip)");
    check_field_offset(lv, v1, 0, "L_L_Ip.v1");
    check_field_offset(lv, v2, 8, "L_L_Ip.v2");
    check_field_offset(lv, v3, 16, "L_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_Ip, L_L_Ip)
//============================================================================



static void Test_L_L_L()
{
  {
    init_simple_test("L_L_L");
    STRUCT_IF_C L_L_L lv;
    check2(sizeof(lv), 24, "sizeof(L_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_L)");
    check_field_offset(lv, v1, 0, "L_L_L.v1");
    check_field_offset(lv, v2, 8, "L_L_L.v2");
    check_field_offset(lv, v3, 16, "L_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_L, L_L_L)
//============================================================================



static void Test_L_L_S()
{
  {
    init_simple_test("L_L_S");
    STRUCT_IF_C L_L_S lv;
    check2(sizeof(lv), 18, "sizeof(L_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_S)");
    check_field_offset(lv, v1, 0, "L_L_S.v1");
    check_field_offset(lv, v2, 8, "L_L_S.v2");
    check_field_offset(lv, v3, 16, "L_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_S, L_L_S)
//============================================================================



static void Test_L_L_Uc()
{
  {
    init_simple_test("L_L_Uc");
    STRUCT_IF_C L_L_Uc lv;
    check2(sizeof(lv), 17, "sizeof(L_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_Uc)");
    check_field_offset(lv, v1, 0, "L_L_Uc.v1");
    check_field_offset(lv, v2, 8, "L_L_Uc.v2");
    check_field_offset(lv, v3, 16, "L_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_Uc, L_L_Uc)
//============================================================================



static void Test_L_L_Ui()
{
  {
    init_simple_test("L_L_Ui");
    STRUCT_IF_C L_L_Ui lv;
    check2(sizeof(lv), 20, "sizeof(L_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_Ui)");
    check_field_offset(lv, v1, 0, "L_L_Ui.v1");
    check_field_offset(lv, v2, 8, "L_L_Ui.v2");
    check_field_offset(lv, v3, 16, "L_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_Ui, L_L_Ui)
//============================================================================



static void Test_L_L_Ul()
{
  {
    init_simple_test("L_L_Ul");
    STRUCT_IF_C L_L_Ul lv;
    check2(sizeof(lv), 24, "sizeof(L_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_Ul)");
    check_field_offset(lv, v1, 0, "L_L_Ul.v1");
    check_field_offset(lv, v2, 8, "L_L_Ul.v2");
    check_field_offset(lv, v3, 16, "L_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_Ul, L_L_Ul)
//============================================================================



static void Test_L_L_Us()
{
  {
    init_simple_test("L_L_Us");
    STRUCT_IF_C L_L_Us lv;
    check2(sizeof(lv), 18, "sizeof(L_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_Us)");
    check_field_offset(lv, v1, 0, "L_L_Us.v1");
    check_field_offset(lv, v2, 8, "L_L_Us.v2");
    check_field_offset(lv, v3, 16, "L_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_Us, L_L_Us)
//============================================================================



static void Test_L_L_Vp()
{
  {
    init_simple_test("L_L_Vp");
    STRUCT_IF_C L_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_L_Vp)");
    check_field_offset(lv, v1, 0, "L_L_Vp.v1");
    check_field_offset(lv, v2, 8, "L_L_Vp.v2");
    check_field_offset(lv, v3, 16, "L_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_L_Vp, L_L_Vp)
//============================================================================



static void Test_L_S()
{
  {
    init_simple_test("L_S");
    STRUCT_IF_C L_S lv;
    check2(sizeof(lv), 10, "sizeof(L_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_S)");
    check_field_offset(lv, v1, 0, "L_S.v1");
    check_field_offset(lv, v2, 8, "L_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S, L_S)
//============================================================================



static void Test_L_S_BFu15i()
{
  {
    init_simple_test("L_S_BFu15i");
    static STRUCT_IF_C L_S_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu15i)");
    check_field_offset(lv, v1, 0, "L_S_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_S_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu15i, L_S_BFu15i)
//============================================================================



static void Test_L_S_BFu15ll()
{
  {
    init_simple_test("L_S_BFu15ll");
    static STRUCT_IF_C L_S_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_S_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu15ll, L_S_BFu15ll)
//============================================================================



static void Test_L_S_BFu15s()
{
  {
    init_simple_test("L_S_BFu15s");
    static STRUCT_IF_C L_S_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu15s)");
    check_field_offset(lv, v1, 0, "L_S_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_S_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu15s, L_S_BFu15s)
//============================================================================



static void Test_L_S_BFu16i()
{
  {
    init_simple_test("L_S_BFu16i");
    static STRUCT_IF_C L_S_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu16i)");
    check_field_offset(lv, v1, 0, "L_S_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_S_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu16i, L_S_BFu16i)
//============================================================================



static void Test_L_S_BFu16ll()
{
  {
    init_simple_test("L_S_BFu16ll");
    static STRUCT_IF_C L_S_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_S_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu16ll, L_S_BFu16ll)
//============================================================================



static void Test_L_S_BFu16s()
{
  {
    init_simple_test("L_S_BFu16s");
    static STRUCT_IF_C L_S_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu16s)");
    check_field_offset(lv, v1, 0, "L_S_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_S_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu16s, L_S_BFu16s)
//============================================================================



static void Test_L_S_BFu17i()
{
  {
    init_simple_test("L_S_BFu17i");
    static STRUCT_IF_C L_S_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(L_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu17i)");
    check_field_offset(lv, v1, 0, "L_S_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "L_S_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "L_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu17i, L_S_BFu17i)
//============================================================================



static void Test_L_S_BFu17ll()
{
  {
    init_simple_test("L_S_BFu17ll");
    static STRUCT_IF_C L_S_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(L_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "L_S_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "L_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu17ll, L_S_BFu17ll)
//============================================================================



static void Test_L_S_BFu1c()
{
  {
    init_simple_test("L_S_BFu1c");
    static STRUCT_IF_C L_S_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu1c)");
    check_field_offset(lv, v1, 0, "L_S_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu1c, L_S_BFu1c)
//============================================================================



static void Test_L_S_BFu1i()
{
  {
    init_simple_test("L_S_BFu1i");
    static STRUCT_IF_C L_S_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu1i)");
    check_field_offset(lv, v1, 0, "L_S_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu1i, L_S_BFu1i)
//============================================================================



static void Test_L_S_BFu1ll()
{
  {
    init_simple_test("L_S_BFu1ll");
    static STRUCT_IF_C L_S_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu1ll, L_S_BFu1ll)
//============================================================================



static void Test_L_S_BFu1s()
{
  {
    init_simple_test("L_S_BFu1s");
    static STRUCT_IF_C L_S_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu1s)");
    check_field_offset(lv, v1, 0, "L_S_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu1s, L_S_BFu1s)
//============================================================================



static void Test_L_S_BFu31i()
{
  {
    init_simple_test("L_S_BFu31i");
    static STRUCT_IF_C L_S_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(L_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu31i)");
    check_field_offset(lv, v1, 0, "L_S_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "L_S_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "L_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu31i, L_S_BFu31i)
//============================================================================



static void Test_L_S_BFu31ll()
{
  {
    init_simple_test("L_S_BFu31ll");
    static STRUCT_IF_C L_S_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(L_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "L_S_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "L_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu31ll, L_S_BFu31ll)
//============================================================================



static void Test_L_S_BFu32i()
{
  {
    init_simple_test("L_S_BFu32i");
    static STRUCT_IF_C L_S_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(L_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu32i)");
    check_field_offset(lv, v1, 0, "L_S_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "L_S_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "L_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu32i, L_S_BFu32i)
//============================================================================



static void Test_L_S_BFu32ll()
{
  {
    init_simple_test("L_S_BFu32ll");
    static STRUCT_IF_C L_S_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(L_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "L_S_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "L_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu32ll, L_S_BFu32ll)
//============================================================================



static void Test_L_S_BFu33()
{
  {
    init_simple_test("L_S_BFu33");
    static STRUCT_IF_C L_S_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(L_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu33)");
    check_field_offset(lv, v1, 0, "L_S_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "L_S_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "L_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu33, L_S_BFu33)
//============================================================================



static void Test_L_S_BFu7c()
{
  {
    init_simple_test("L_S_BFu7c");
    static STRUCT_IF_C L_S_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu7c)");
    check_field_offset(lv, v1, 0, "L_S_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_S_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu7c, L_S_BFu7c)
//============================================================================



static void Test_L_S_BFu7i()
{
  {
    init_simple_test("L_S_BFu7i");
    static STRUCT_IF_C L_S_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu7i)");
    check_field_offset(lv, v1, 0, "L_S_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_S_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu7i, L_S_BFu7i)
//============================================================================



static void Test_L_S_BFu7ll()
{
  {
    init_simple_test("L_S_BFu7ll");
    static STRUCT_IF_C L_S_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_S_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu7ll, L_S_BFu7ll)
//============================================================================



static void Test_L_S_BFu7s()
{
  {
    init_simple_test("L_S_BFu7s");
    static STRUCT_IF_C L_S_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu7s)");
    check_field_offset(lv, v1, 0, "L_S_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_S_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu7s, L_S_BFu7s)
//============================================================================



static void Test_L_S_BFu8c()
{
  {
    init_simple_test("L_S_BFu8c");
    static STRUCT_IF_C L_S_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu8c)");
    check_field_offset(lv, v1, 0, "L_S_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_S_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu8c, L_S_BFu8c)
//============================================================================



static void Test_L_S_BFu8i()
{
  {
    init_simple_test("L_S_BFu8i");
    static STRUCT_IF_C L_S_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu8i)");
    check_field_offset(lv, v1, 0, "L_S_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_S_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu8i, L_S_BFu8i)
//============================================================================



static void Test_L_S_BFu8ll()
{
  {
    init_simple_test("L_S_BFu8ll");
    static STRUCT_IF_C L_S_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_S_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu8ll, L_S_BFu8ll)
//============================================================================



static void Test_L_S_BFu8s()
{
  {
    init_simple_test("L_S_BFu8s");
    static STRUCT_IF_C L_S_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(L_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu8s)");
    check_field_offset(lv, v1, 0, "L_S_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_S_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu8s, L_S_BFu8s)
//============================================================================



static void Test_L_S_BFu9i()
{
  {
    init_simple_test("L_S_BFu9i");
    static STRUCT_IF_C L_S_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu9i)");
    check_field_offset(lv, v1, 0, "L_S_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_S_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu9i, L_S_BFu9i)
//============================================================================



static void Test_L_S_BFu9ll()
{
  {
    init_simple_test("L_S_BFu9ll");
    static STRUCT_IF_C L_S_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_S_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu9ll, L_S_BFu9ll)
//============================================================================



static void Test_L_S_BFu9s()
{
  {
    init_simple_test("L_S_BFu9s");
    static STRUCT_IF_C L_S_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(L_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_BFu9s)");
    check_field_offset(lv, v1, 0, "L_S_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_S_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_BFu9s, L_S_BFu9s)
//============================================================================



static void Test_L_S_C()
{
  {
    init_simple_test("L_S_C");
    STRUCT_IF_C L_S_C lv;
    check2(sizeof(lv), 11, "sizeof(L_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_C)");
    check_field_offset(lv, v1, 0, "L_S_C.v1");
    check_field_offset(lv, v2, 8, "L_S_C.v2");
    check_field_offset(lv, v3, 10, "L_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_C, L_S_C)
//============================================================================



static void Test_L_S_D()
{
  {
    init_simple_test("L_S_D");
    STRUCT_IF_C L_S_D lv;
    check2(sizeof(lv), 18, "sizeof(L_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_D)");
    check_field_offset(lv, v1, 0, "L_S_D.v1");
    check_field_offset(lv, v2, 8, "L_S_D.v2");
    check_field_offset(lv, v3, 10, "L_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_D, L_S_D)
//============================================================================



static void Test_L_S_F()
{
  {
    init_simple_test("L_S_F");
    STRUCT_IF_C L_S_F lv;
    check2(sizeof(lv), 14, "sizeof(L_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_F)");
    check_field_offset(lv, v1, 0, "L_S_F.v1");
    check_field_offset(lv, v2, 8, "L_S_F.v2");
    check_field_offset(lv, v3, 10, "L_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_F, L_S_F)
//============================================================================



static void Test_L_S_I()
{
  {
    init_simple_test("L_S_I");
    STRUCT_IF_C L_S_I lv;
    check2(sizeof(lv), 14, "sizeof(L_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_I)");
    check_field_offset(lv, v1, 0, "L_S_I.v1");
    check_field_offset(lv, v2, 8, "L_S_I.v2");
    check_field_offset(lv, v3, 10, "L_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_I, L_S_I)
//============================================================================



static void Test_L_S_Ip()
{
  {
    init_simple_test("L_S_Ip");
    STRUCT_IF_C L_S_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_Ip)");
    check_field_offset(lv, v1, 0, "L_S_Ip.v1");
    check_field_offset(lv, v2, 8, "L_S_Ip.v2");
    check_field_offset(lv, v3, 10, "L_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_Ip, L_S_Ip)
//============================================================================



static void Test_L_S_L()
{
  {
    init_simple_test("L_S_L");
    STRUCT_IF_C L_S_L lv;
    check2(sizeof(lv), 18, "sizeof(L_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_L)");
    check_field_offset(lv, v1, 0, "L_S_L.v1");
    check_field_offset(lv, v2, 8, "L_S_L.v2");
    check_field_offset(lv, v3, 10, "L_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_L, L_S_L)
//============================================================================



static void Test_L_S_S()
{
  {
    init_simple_test("L_S_S");
    STRUCT_IF_C L_S_S lv;
    check2(sizeof(lv), 12, "sizeof(L_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_S)");
    check_field_offset(lv, v1, 0, "L_S_S.v1");
    check_field_offset(lv, v2, 8, "L_S_S.v2");
    check_field_offset(lv, v3, 10, "L_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_S, L_S_S)
//============================================================================



static void Test_L_S_Uc()
{
  {
    init_simple_test("L_S_Uc");
    STRUCT_IF_C L_S_Uc lv;
    check2(sizeof(lv), 11, "sizeof(L_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_Uc)");
    check_field_offset(lv, v1, 0, "L_S_Uc.v1");
    check_field_offset(lv, v2, 8, "L_S_Uc.v2");
    check_field_offset(lv, v3, 10, "L_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_Uc, L_S_Uc)
//============================================================================



static void Test_L_S_Ui()
{
  {
    init_simple_test("L_S_Ui");
    STRUCT_IF_C L_S_Ui lv;
    check2(sizeof(lv), 14, "sizeof(L_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_Ui)");
    check_field_offset(lv, v1, 0, "L_S_Ui.v1");
    check_field_offset(lv, v2, 8, "L_S_Ui.v2");
    check_field_offset(lv, v3, 10, "L_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_Ui, L_S_Ui)
//============================================================================



static void Test_L_S_Ul()
{
  {
    init_simple_test("L_S_Ul");
    STRUCT_IF_C L_S_Ul lv;
    check2(sizeof(lv), 18, "sizeof(L_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_Ul)");
    check_field_offset(lv, v1, 0, "L_S_Ul.v1");
    check_field_offset(lv, v2, 8, "L_S_Ul.v2");
    check_field_offset(lv, v3, 10, "L_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_Ul, L_S_Ul)
//============================================================================



static void Test_L_S_Us()
{
  {
    init_simple_test("L_S_Us");
    STRUCT_IF_C L_S_Us lv;
    check2(sizeof(lv), 12, "sizeof(L_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_Us)");
    check_field_offset(lv, v1, 0, "L_S_Us.v1");
    check_field_offset(lv, v2, 8, "L_S_Us.v2");
    check_field_offset(lv, v3, 10, "L_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_Us, L_S_Us)
//============================================================================



static void Test_L_S_Vp()
{
  {
    init_simple_test("L_S_Vp");
    STRUCT_IF_C L_S_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_S_Vp)");
    check_field_offset(lv, v1, 0, "L_S_Vp.v1");
    check_field_offset(lv, v2, 8, "L_S_Vp.v2");
    check_field_offset(lv, v3, 10, "L_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_S_Vp, L_S_Vp)
//============================================================================



static void Test_L_Uc()
{
  {
    init_simple_test("L_Uc");
    STRUCT_IF_C L_Uc lv;
    check2(sizeof(lv), 9, "sizeof(L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc)");
    check_field_offset(lv, v1, 0, "L_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc, L_Uc)
//============================================================================



static void Test_L_Uc_BFu15i()
{
  {
    init_simple_test("L_Uc_BFu15i");
    static STRUCT_IF_C L_Uc_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_Uc_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu15i, L_Uc_BFu15i)
//============================================================================



static void Test_L_Uc_BFu15ll()
{
  {
    init_simple_test("L_Uc_BFu15ll");
    static STRUCT_IF_C L_Uc_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu15ll, L_Uc_BFu15ll)
//============================================================================



static void Test_L_Uc_BFu15s()
{
  {
    init_simple_test("L_Uc_BFu15s");
    static STRUCT_IF_C L_Uc_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "L_Uc_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "L_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu15s, L_Uc_BFu15s)
//============================================================================



static void Test_L_Uc_BFu16i()
{
  {
    init_simple_test("L_Uc_BFu16i");
    static STRUCT_IF_C L_Uc_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_Uc_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu16i, L_Uc_BFu16i)
//============================================================================



static void Test_L_Uc_BFu16ll()
{
  {
    init_simple_test("L_Uc_BFu16ll");
    static STRUCT_IF_C L_Uc_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu16ll, L_Uc_BFu16ll)
//============================================================================



static void Test_L_Uc_BFu16s()
{
  {
    init_simple_test("L_Uc_BFu16s");
    static STRUCT_IF_C L_Uc_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "L_Uc_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "L_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu16s, L_Uc_BFu16s)
//============================================================================



static void Test_L_Uc_BFu17i()
{
  {
    init_simple_test("L_Uc_BFu17i");
    static STRUCT_IF_C L_Uc_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(L_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_Uc_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu17i, L_Uc_BFu17i)
//============================================================================



static void Test_L_Uc_BFu17ll()
{
  {
    init_simple_test("L_Uc_BFu17ll");
    static STRUCT_IF_C L_Uc_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(L_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "L_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "L_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu17ll, L_Uc_BFu17ll)
//============================================================================



static void Test_L_Uc_BFu1c()
{
  {
    init_simple_test("L_Uc_BFu1c");
    static STRUCT_IF_C L_Uc_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu1c, L_Uc_BFu1c)
//============================================================================



static void Test_L_Uc_BFu1i()
{
  {
    init_simple_test("L_Uc_BFu1i");
    static STRUCT_IF_C L_Uc_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu1i, L_Uc_BFu1i)
//============================================================================



static void Test_L_Uc_BFu1ll()
{
  {
    init_simple_test("L_Uc_BFu1ll");
    static STRUCT_IF_C L_Uc_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu1ll, L_Uc_BFu1ll)
//============================================================================



static void Test_L_Uc_BFu1s()
{
  {
    init_simple_test("L_Uc_BFu1s");
    static STRUCT_IF_C L_Uc_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "L_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu1s, L_Uc_BFu1s)
//============================================================================



static void Test_L_Uc_BFu31i()
{
  {
    init_simple_test("L_Uc_BFu31i");
    static STRUCT_IF_C L_Uc_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_Uc_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu31i, L_Uc_BFu31i)
//============================================================================



static void Test_L_Uc_BFu31ll()
{
  {
    init_simple_test("L_Uc_BFu31ll");
    static STRUCT_IF_C L_Uc_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "L_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "L_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu31ll, L_Uc_BFu31ll)
//============================================================================



static void Test_L_Uc_BFu32i()
{
  {
    init_simple_test("L_Uc_BFu32i");
    static STRUCT_IF_C L_Uc_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_Uc_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu32i, L_Uc_BFu32i)
//============================================================================



static void Test_L_Uc_BFu32ll()
{
  {
    init_simple_test("L_Uc_BFu32ll");
    static STRUCT_IF_C L_Uc_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "L_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "L_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu32ll, L_Uc_BFu32ll)
//============================================================================



static void Test_L_Uc_BFu33()
{
  {
    init_simple_test("L_Uc_BFu33");
    static STRUCT_IF_C L_Uc_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(L_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "L_Uc_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "L_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu33, L_Uc_BFu33)
//============================================================================



static void Test_L_Uc_BFu7c()
{
  {
    init_simple_test("L_Uc_BFu7c");
    static STRUCT_IF_C L_Uc_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_Uc_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu7c, L_Uc_BFu7c)
//============================================================================



static void Test_L_Uc_BFu7i()
{
  {
    init_simple_test("L_Uc_BFu7i");
    static STRUCT_IF_C L_Uc_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_Uc_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu7i, L_Uc_BFu7i)
//============================================================================



static void Test_L_Uc_BFu7ll()
{
  {
    init_simple_test("L_Uc_BFu7ll");
    static STRUCT_IF_C L_Uc_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu7ll, L_Uc_BFu7ll)
//============================================================================



static void Test_L_Uc_BFu7s()
{
  {
    init_simple_test("L_Uc_BFu7s");
    static STRUCT_IF_C L_Uc_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "L_Uc_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "L_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu7s, L_Uc_BFu7s)
//============================================================================



static void Test_L_Uc_BFu8c()
{
  {
    init_simple_test("L_Uc_BFu8c");
    static STRUCT_IF_C L_Uc_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_Uc_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu8c, L_Uc_BFu8c)
//============================================================================



static void Test_L_Uc_BFu8i()
{
  {
    init_simple_test("L_Uc_BFu8i");
    static STRUCT_IF_C L_Uc_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_Uc_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu8i, L_Uc_BFu8i)
//============================================================================



static void Test_L_Uc_BFu8ll()
{
  {
    init_simple_test("L_Uc_BFu8ll");
    static STRUCT_IF_C L_Uc_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu8ll, L_Uc_BFu8ll)
//============================================================================



static void Test_L_Uc_BFu8s()
{
  {
    init_simple_test("L_Uc_BFu8s");
    static STRUCT_IF_C L_Uc_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "L_Uc_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "L_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu8s, L_Uc_BFu8s)
//============================================================================



static void Test_L_Uc_BFu9i()
{
  {
    init_simple_test("L_Uc_BFu9i");
    static STRUCT_IF_C L_Uc_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_Uc_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu9i, L_Uc_BFu9i)
//============================================================================



static void Test_L_Uc_BFu9ll()
{
  {
    init_simple_test("L_Uc_BFu9ll");
    static STRUCT_IF_C L_Uc_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu9ll, L_Uc_BFu9ll)
//============================================================================



static void Test_L_Uc_BFu9s()
{
  {
    init_simple_test("L_Uc_BFu9s");
    static STRUCT_IF_C L_Uc_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "L_Uc_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "L_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_BFu9s, L_Uc_BFu9s)
//============================================================================



static void Test_L_Uc_C()
{
  {
    init_simple_test("L_Uc_C");
    STRUCT_IF_C L_Uc_C lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_C)");
    check_field_offset(lv, v1, 0, "L_Uc_C.v1");
    check_field_offset(lv, v2, 8, "L_Uc_C.v2");
    check_field_offset(lv, v3, 9, "L_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_C, L_Uc_C)
//============================================================================



static void Test_L_Uc_D()
{
  {
    init_simple_test("L_Uc_D");
    STRUCT_IF_C L_Uc_D lv;
    check2(sizeof(lv), 17, "sizeof(L_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_D)");
    check_field_offset(lv, v1, 0, "L_Uc_D.v1");
    check_field_offset(lv, v2, 8, "L_Uc_D.v2");
    check_field_offset(lv, v3, 9, "L_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_D, L_Uc_D)
//============================================================================



static void Test_L_Uc_F()
{
  {
    init_simple_test("L_Uc_F");
    STRUCT_IF_C L_Uc_F lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_F)");
    check_field_offset(lv, v1, 0, "L_Uc_F.v1");
    check_field_offset(lv, v2, 8, "L_Uc_F.v2");
    check_field_offset(lv, v3, 9, "L_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_F, L_Uc_F)
//============================================================================



static void Test_L_Uc_I()
{
  {
    init_simple_test("L_Uc_I");
    STRUCT_IF_C L_Uc_I lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_I)");
    check_field_offset(lv, v1, 0, "L_Uc_I.v1");
    check_field_offset(lv, v2, 8, "L_Uc_I.v2");
    check_field_offset(lv, v3, 9, "L_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_I, L_Uc_I)
//============================================================================



static void Test_L_Uc_Ip()
{
  {
    init_simple_test("L_Uc_Ip");
    STRUCT_IF_C L_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_Ip)");
    check_field_offset(lv, v1, 0, "L_Uc_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Uc_Ip.v2");
    check_field_offset(lv, v3, 9, "L_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_Ip, L_Uc_Ip)
//============================================================================



static void Test_L_Uc_L()
{
  {
    init_simple_test("L_Uc_L");
    STRUCT_IF_C L_Uc_L lv;
    check2(sizeof(lv), 17, "sizeof(L_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_L)");
    check_field_offset(lv, v1, 0, "L_Uc_L.v1");
    check_field_offset(lv, v2, 8, "L_Uc_L.v2");
    check_field_offset(lv, v3, 9, "L_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_L, L_Uc_L)
//============================================================================



static void Test_L_Uc_S()
{
  {
    init_simple_test("L_Uc_S");
    STRUCT_IF_C L_Uc_S lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_S)");
    check_field_offset(lv, v1, 0, "L_Uc_S.v1");
    check_field_offset(lv, v2, 8, "L_Uc_S.v2");
    check_field_offset(lv, v3, 9, "L_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_S, L_Uc_S)
//============================================================================



static void Test_L_Uc_Uc()
{
  {
    init_simple_test("L_Uc_Uc");
    STRUCT_IF_C L_Uc_Uc lv;
    check2(sizeof(lv), 10, "sizeof(L_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_Uc)");
    check_field_offset(lv, v1, 0, "L_Uc_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Uc_Uc.v2");
    check_field_offset(lv, v3, 9, "L_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_Uc, L_Uc_Uc)
//============================================================================



static void Test_L_Uc_Ui()
{
  {
    init_simple_test("L_Uc_Ui");
    STRUCT_IF_C L_Uc_Ui lv;
    check2(sizeof(lv), 13, "sizeof(L_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_Ui)");
    check_field_offset(lv, v1, 0, "L_Uc_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Uc_Ui.v2");
    check_field_offset(lv, v3, 9, "L_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_Ui, L_Uc_Ui)
//============================================================================



static void Test_L_Uc_Ul()
{
  {
    init_simple_test("L_Uc_Ul");
    STRUCT_IF_C L_Uc_Ul lv;
    check2(sizeof(lv), 17, "sizeof(L_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_Ul)");
    check_field_offset(lv, v1, 0, "L_Uc_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Uc_Ul.v2");
    check_field_offset(lv, v3, 9, "L_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_Ul, L_Uc_Ul)
//============================================================================



static void Test_L_Uc_Us()
{
  {
    init_simple_test("L_Uc_Us");
    STRUCT_IF_C L_Uc_Us lv;
    check2(sizeof(lv), 11, "sizeof(L_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_Us)");
    check_field_offset(lv, v1, 0, "L_Uc_Us.v1");
    check_field_offset(lv, v2, 8, "L_Uc_Us.v2");
    check_field_offset(lv, v3, 9, "L_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_Us, L_Uc_Us)
//============================================================================



static void Test_L_Uc_Vp()
{
  {
    init_simple_test("L_Uc_Vp");
    STRUCT_IF_C L_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Uc_Vp)");
    check_field_offset(lv, v1, 0, "L_Uc_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Uc_Vp.v2");
    check_field_offset(lv, v3, 9, "L_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Uc_Vp, L_Uc_Vp)
//============================================================================



static void Test_L_Ui()
{
  {
    init_simple_test("L_Ui");
    STRUCT_IF_C L_Ui lv;
    check2(sizeof(lv), 12, "sizeof(L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui)");
    check_field_offset(lv, v1, 0, "L_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui, L_Ui)
//============================================================================



static void Test_L_Ui_BFu15i()
{
  {
    init_simple_test("L_Ui_BFu15i");
    static STRUCT_IF_C L_Ui_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_Ui_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu15i, L_Ui_BFu15i)
//============================================================================



static void Test_L_Ui_BFu15ll()
{
  {
    init_simple_test("L_Ui_BFu15ll");
    static STRUCT_IF_C L_Ui_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu15ll, L_Ui_BFu15ll)
//============================================================================



static void Test_L_Ui_BFu15s()
{
  {
    init_simple_test("L_Ui_BFu15s");
    static STRUCT_IF_C L_Ui_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "L_Ui_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "L_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu15s, L_Ui_BFu15s)
//============================================================================



static void Test_L_Ui_BFu16i()
{
  {
    init_simple_test("L_Ui_BFu16i");
    static STRUCT_IF_C L_Ui_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_Ui_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu16i, L_Ui_BFu16i)
//============================================================================



static void Test_L_Ui_BFu16ll()
{
  {
    init_simple_test("L_Ui_BFu16ll");
    static STRUCT_IF_C L_Ui_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu16ll, L_Ui_BFu16ll)
//============================================================================



static void Test_L_Ui_BFu16s()
{
  {
    init_simple_test("L_Ui_BFu16s");
    static STRUCT_IF_C L_Ui_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "L_Ui_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "L_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu16s, L_Ui_BFu16s)
//============================================================================



static void Test_L_Ui_BFu17i()
{
  {
    init_simple_test("L_Ui_BFu17i");
    static STRUCT_IF_C L_Ui_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(L_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_Ui_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu17i, L_Ui_BFu17i)
//============================================================================



static void Test_L_Ui_BFu17ll()
{
  {
    init_simple_test("L_Ui_BFu17ll");
    static STRUCT_IF_C L_Ui_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(L_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "L_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "L_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu17ll, L_Ui_BFu17ll)
//============================================================================



static void Test_L_Ui_BFu1c()
{
  {
    init_simple_test("L_Ui_BFu1c");
    static STRUCT_IF_C L_Ui_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1c, L_Ui_BFu1c)
//============================================================================



static void Test_L_Ui_BFu1i()
{
  {
    init_simple_test("L_Ui_BFu1i");
    static STRUCT_IF_C L_Ui_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1i, L_Ui_BFu1i)
//============================================================================



static void Test_L_Ui_BFu1ll()
{
  {
    init_simple_test("L_Ui_BFu1ll");
    static STRUCT_IF_C L_Ui_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1ll, L_Ui_BFu1ll)
//============================================================================



static void Test_L_Ui_BFu1s()
{
  {
    init_simple_test("L_Ui_BFu1s");
    static STRUCT_IF_C L_Ui_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "L_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu1s, L_Ui_BFu1s)
//============================================================================



static void Test_L_Ui_BFu31i()
{
  {
    init_simple_test("L_Ui_BFu31i");
    static STRUCT_IF_C L_Ui_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_Ui_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu31i, L_Ui_BFu31i)
//============================================================================



static void Test_L_Ui_BFu31ll()
{
  {
    init_simple_test("L_Ui_BFu31ll");
    static STRUCT_IF_C L_Ui_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "L_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "L_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu31ll, L_Ui_BFu31ll)
//============================================================================



static void Test_L_Ui_BFu32i()
{
  {
    init_simple_test("L_Ui_BFu32i");
    static STRUCT_IF_C L_Ui_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_Ui_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu32i, L_Ui_BFu32i)
//============================================================================



static void Test_L_Ui_BFu32ll()
{
  {
    init_simple_test("L_Ui_BFu32ll");
    static STRUCT_IF_C L_Ui_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "L_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "L_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu32ll, L_Ui_BFu32ll)
//============================================================================



static void Test_L_Ui_BFu33()
{
  {
    init_simple_test("L_Ui_BFu33");
    static STRUCT_IF_C L_Ui_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(L_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "L_Ui_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "L_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu33, L_Ui_BFu33)
//============================================================================



static void Test_L_Ui_BFu7c()
{
  {
    init_simple_test("L_Ui_BFu7c");
    static STRUCT_IF_C L_Ui_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7c, L_Ui_BFu7c)
//============================================================================



static void Test_L_Ui_BFu7i()
{
  {
    init_simple_test("L_Ui_BFu7i");
    static STRUCT_IF_C L_Ui_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7i, L_Ui_BFu7i)
//============================================================================



static void Test_L_Ui_BFu7ll()
{
  {
    init_simple_test("L_Ui_BFu7ll");
    static STRUCT_IF_C L_Ui_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7ll, L_Ui_BFu7ll)
//============================================================================



static void Test_L_Ui_BFu7s()
{
  {
    init_simple_test("L_Ui_BFu7s");
    static STRUCT_IF_C L_Ui_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "L_Ui_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "L_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu7s, L_Ui_BFu7s)
//============================================================================



static void Test_L_Ui_BFu8c()
{
  {
    init_simple_test("L_Ui_BFu8c");
    static STRUCT_IF_C L_Ui_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8c, L_Ui_BFu8c)
//============================================================================



static void Test_L_Ui_BFu8i()
{
  {
    init_simple_test("L_Ui_BFu8i");
    static STRUCT_IF_C L_Ui_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8i, L_Ui_BFu8i)
//============================================================================



static void Test_L_Ui_BFu8ll()
{
  {
    init_simple_test("L_Ui_BFu8ll");
    static STRUCT_IF_C L_Ui_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8ll, L_Ui_BFu8ll)
//============================================================================



static void Test_L_Ui_BFu8s()
{
  {
    init_simple_test("L_Ui_BFu8s");
    static STRUCT_IF_C L_Ui_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "L_Ui_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "L_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu8s, L_Ui_BFu8s)
//============================================================================



static void Test_L_Ui_BFu9i()
{
  {
    init_simple_test("L_Ui_BFu9i");
    static STRUCT_IF_C L_Ui_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_Ui_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu9i, L_Ui_BFu9i)
//============================================================================



static void Test_L_Ui_BFu9ll()
{
  {
    init_simple_test("L_Ui_BFu9ll");
    static STRUCT_IF_C L_Ui_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu9ll, L_Ui_BFu9ll)
//============================================================================



static void Test_L_Ui_BFu9s()
{
  {
    init_simple_test("L_Ui_BFu9s");
    static STRUCT_IF_C L_Ui_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "L_Ui_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "L_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_BFu9s, L_Ui_BFu9s)
//============================================================================



static void Test_L_Ui_C()
{
  {
    init_simple_test("L_Ui_C");
    STRUCT_IF_C L_Ui_C lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_C)");
    check_field_offset(lv, v1, 0, "L_Ui_C.v1");
    check_field_offset(lv, v2, 8, "L_Ui_C.v2");
    check_field_offset(lv, v3, 12, "L_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_C, L_Ui_C)
//============================================================================



static void Test_L_Ui_D()
{
  {
    init_simple_test("L_Ui_D");
    STRUCT_IF_C L_Ui_D lv;
    check2(sizeof(lv), 20, "sizeof(L_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_D)");
    check_field_offset(lv, v1, 0, "L_Ui_D.v1");
    check_field_offset(lv, v2, 8, "L_Ui_D.v2");
    check_field_offset(lv, v3, 12, "L_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_D, L_Ui_D)
//============================================================================



static void Test_L_Ui_F()
{
  {
    init_simple_test("L_Ui_F");
    STRUCT_IF_C L_Ui_F lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_F)");
    check_field_offset(lv, v1, 0, "L_Ui_F.v1");
    check_field_offset(lv, v2, 8, "L_Ui_F.v2");
    check_field_offset(lv, v3, 12, "L_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_F, L_Ui_F)
//============================================================================



static void Test_L_Ui_I()
{
  {
    init_simple_test("L_Ui_I");
    STRUCT_IF_C L_Ui_I lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_I)");
    check_field_offset(lv, v1, 0, "L_Ui_I.v1");
    check_field_offset(lv, v2, 8, "L_Ui_I.v2");
    check_field_offset(lv, v3, 12, "L_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_I, L_Ui_I)
//============================================================================



static void Test_L_Ui_Ip()
{
  {
    init_simple_test("L_Ui_Ip");
    STRUCT_IF_C L_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_Ip)");
    check_field_offset(lv, v1, 0, "L_Ui_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Ip.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Ip, L_Ui_Ip)
//============================================================================



static void Test_L_Ui_L()
{
  {
    init_simple_test("L_Ui_L");
    STRUCT_IF_C L_Ui_L lv;
    check2(sizeof(lv), 20, "sizeof(L_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_L)");
    check_field_offset(lv, v1, 0, "L_Ui_L.v1");
    check_field_offset(lv, v2, 8, "L_Ui_L.v2");
    check_field_offset(lv, v3, 12, "L_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_L, L_Ui_L)
//============================================================================



static void Test_L_Ui_S()
{
  {
    init_simple_test("L_Ui_S");
    STRUCT_IF_C L_Ui_S lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_S)");
    check_field_offset(lv, v1, 0, "L_Ui_S.v1");
    check_field_offset(lv, v2, 8, "L_Ui_S.v2");
    check_field_offset(lv, v3, 12, "L_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_S, L_Ui_S)
//============================================================================



static void Test_L_Ui_Uc()
{
  {
    init_simple_test("L_Ui_Uc");
    STRUCT_IF_C L_Ui_Uc lv;
    check2(sizeof(lv), 13, "sizeof(L_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_Uc)");
    check_field_offset(lv, v1, 0, "L_Ui_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Uc.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Uc, L_Ui_Uc)
//============================================================================



static void Test_L_Ui_Ui()
{
  {
    init_simple_test("L_Ui_Ui");
    STRUCT_IF_C L_Ui_Ui lv;
    check2(sizeof(lv), 16, "sizeof(L_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_Ui)");
    check_field_offset(lv, v1, 0, "L_Ui_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Ui.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Ui, L_Ui_Ui)
//============================================================================



static void Test_L_Ui_Ul()
{
  {
    init_simple_test("L_Ui_Ul");
    STRUCT_IF_C L_Ui_Ul lv;
    check2(sizeof(lv), 20, "sizeof(L_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_Ul)");
    check_field_offset(lv, v1, 0, "L_Ui_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Ul.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Ul, L_Ui_Ul)
//============================================================================



static void Test_L_Ui_Us()
{
  {
    init_simple_test("L_Ui_Us");
    STRUCT_IF_C L_Ui_Us lv;
    check2(sizeof(lv), 14, "sizeof(L_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_Us)");
    check_field_offset(lv, v1, 0, "L_Ui_Us.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Us.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Us, L_Ui_Us)
//============================================================================



static void Test_L_Ui_Vp()
{
  {
    init_simple_test("L_Ui_Vp");
    STRUCT_IF_C L_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ui_Vp)");
    check_field_offset(lv, v1, 0, "L_Ui_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Ui_Vp.v2");
    check_field_offset(lv, v3, 12, "L_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ui_Vp, L_Ui_Vp)
//============================================================================



static void Test_L_Ul()
{
  {
    init_simple_test("L_Ul");
    STRUCT_IF_C L_Ul lv;
    check2(sizeof(lv), 16, "sizeof(L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul)");
    check_field_offset(lv, v1, 0, "L_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul, L_Ul)
//============================================================================



static void Test_L_Ul_BFu15i()
{
  {
    init_simple_test("L_Ul_BFu15i");
    static STRUCT_IF_C L_Ul_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_Ul_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu15i, L_Ul_BFu15i)
//============================================================================



static void Test_L_Ul_BFu15ll()
{
  {
    init_simple_test("L_Ul_BFu15ll");
    static STRUCT_IF_C L_Ul_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu15ll, L_Ul_BFu15ll)
//============================================================================



static void Test_L_Ul_BFu15s()
{
  {
    init_simple_test("L_Ul_BFu15s");
    static STRUCT_IF_C L_Ul_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "L_Ul_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "L_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu15s, L_Ul_BFu15s)
//============================================================================



static void Test_L_Ul_BFu16i()
{
  {
    init_simple_test("L_Ul_BFu16i");
    static STRUCT_IF_C L_Ul_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_Ul_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu16i, L_Ul_BFu16i)
//============================================================================



static void Test_L_Ul_BFu16ll()
{
  {
    init_simple_test("L_Ul_BFu16ll");
    static STRUCT_IF_C L_Ul_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu16ll, L_Ul_BFu16ll)
//============================================================================



static void Test_L_Ul_BFu16s()
{
  {
    init_simple_test("L_Ul_BFu16s");
    static STRUCT_IF_C L_Ul_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "L_Ul_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "L_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu16s, L_Ul_BFu16s)
//============================================================================



static void Test_L_Ul_BFu17i()
{
  {
    init_simple_test("L_Ul_BFu17i");
    static STRUCT_IF_C L_Ul_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(L_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_Ul_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu17i, L_Ul_BFu17i)
//============================================================================



static void Test_L_Ul_BFu17ll()
{
  {
    init_simple_test("L_Ul_BFu17ll");
    static STRUCT_IF_C L_Ul_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(L_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "L_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "L_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu17ll, L_Ul_BFu17ll)
//============================================================================



static void Test_L_Ul_BFu1c()
{
  {
    init_simple_test("L_Ul_BFu1c");
    static STRUCT_IF_C L_Ul_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1c, L_Ul_BFu1c)
//============================================================================



static void Test_L_Ul_BFu1i()
{
  {
    init_simple_test("L_Ul_BFu1i");
    static STRUCT_IF_C L_Ul_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1i, L_Ul_BFu1i)
//============================================================================



static void Test_L_Ul_BFu1ll()
{
  {
    init_simple_test("L_Ul_BFu1ll");
    static STRUCT_IF_C L_Ul_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1ll, L_Ul_BFu1ll)
//============================================================================



static void Test_L_Ul_BFu1s()
{
  {
    init_simple_test("L_Ul_BFu1s");
    static STRUCT_IF_C L_Ul_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "L_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu1s, L_Ul_BFu1s)
//============================================================================



static void Test_L_Ul_BFu31i()
{
  {
    init_simple_test("L_Ul_BFu31i");
    static STRUCT_IF_C L_Ul_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_Ul_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu31i, L_Ul_BFu31i)
//============================================================================



static void Test_L_Ul_BFu31ll()
{
  {
    init_simple_test("L_Ul_BFu31ll");
    static STRUCT_IF_C L_Ul_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "L_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "L_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu31ll, L_Ul_BFu31ll)
//============================================================================



static void Test_L_Ul_BFu32i()
{
  {
    init_simple_test("L_Ul_BFu32i");
    static STRUCT_IF_C L_Ul_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_Ul_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu32i, L_Ul_BFu32i)
//============================================================================



static void Test_L_Ul_BFu32ll()
{
  {
    init_simple_test("L_Ul_BFu32ll");
    static STRUCT_IF_C L_Ul_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "L_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "L_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu32ll, L_Ul_BFu32ll)
//============================================================================



static void Test_L_Ul_BFu33()
{
  {
    init_simple_test("L_Ul_BFu33");
    static STRUCT_IF_C L_Ul_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(L_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "L_Ul_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "L_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu33, L_Ul_BFu33)
//============================================================================



static void Test_L_Ul_BFu7c()
{
  {
    init_simple_test("L_Ul_BFu7c");
    static STRUCT_IF_C L_Ul_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7c, L_Ul_BFu7c)
//============================================================================



static void Test_L_Ul_BFu7i()
{
  {
    init_simple_test("L_Ul_BFu7i");
    static STRUCT_IF_C L_Ul_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7i, L_Ul_BFu7i)
//============================================================================



static void Test_L_Ul_BFu7ll()
{
  {
    init_simple_test("L_Ul_BFu7ll");
    static STRUCT_IF_C L_Ul_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7ll, L_Ul_BFu7ll)
//============================================================================



static void Test_L_Ul_BFu7s()
{
  {
    init_simple_test("L_Ul_BFu7s");
    static STRUCT_IF_C L_Ul_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "L_Ul_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "L_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu7s, L_Ul_BFu7s)
//============================================================================



static void Test_L_Ul_BFu8c()
{
  {
    init_simple_test("L_Ul_BFu8c");
    static STRUCT_IF_C L_Ul_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8c, L_Ul_BFu8c)
//============================================================================



static void Test_L_Ul_BFu8i()
{
  {
    init_simple_test("L_Ul_BFu8i");
    static STRUCT_IF_C L_Ul_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8i, L_Ul_BFu8i)
//============================================================================



static void Test_L_Ul_BFu8ll()
{
  {
    init_simple_test("L_Ul_BFu8ll");
    static STRUCT_IF_C L_Ul_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8ll, L_Ul_BFu8ll)
//============================================================================



static void Test_L_Ul_BFu8s()
{
  {
    init_simple_test("L_Ul_BFu8s");
    static STRUCT_IF_C L_Ul_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "L_Ul_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "L_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu8s, L_Ul_BFu8s)
//============================================================================



static void Test_L_Ul_BFu9i()
{
  {
    init_simple_test("L_Ul_BFu9i");
    static STRUCT_IF_C L_Ul_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_Ul_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu9i, L_Ul_BFu9i)
//============================================================================



static void Test_L_Ul_BFu9ll()
{
  {
    init_simple_test("L_Ul_BFu9ll");
    static STRUCT_IF_C L_Ul_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu9ll, L_Ul_BFu9ll)
//============================================================================



static void Test_L_Ul_BFu9s()
{
  {
    init_simple_test("L_Ul_BFu9s");
    static STRUCT_IF_C L_Ul_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "L_Ul_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "L_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_BFu9s, L_Ul_BFu9s)
//============================================================================



static void Test_L_Ul_C()
{
  {
    init_simple_test("L_Ul_C");
    STRUCT_IF_C L_Ul_C lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_C)");
    check_field_offset(lv, v1, 0, "L_Ul_C.v1");
    check_field_offset(lv, v2, 8, "L_Ul_C.v2");
    check_field_offset(lv, v3, 16, "L_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_C, L_Ul_C)
//============================================================================



static void Test_L_Ul_D()
{
  {
    init_simple_test("L_Ul_D");
    STRUCT_IF_C L_Ul_D lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_D)");
    check_field_offset(lv, v1, 0, "L_Ul_D.v1");
    check_field_offset(lv, v2, 8, "L_Ul_D.v2");
    check_field_offset(lv, v3, 16, "L_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_D, L_Ul_D)
//============================================================================



static void Test_L_Ul_F()
{
  {
    init_simple_test("L_Ul_F");
    STRUCT_IF_C L_Ul_F lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_F)");
    check_field_offset(lv, v1, 0, "L_Ul_F.v1");
    check_field_offset(lv, v2, 8, "L_Ul_F.v2");
    check_field_offset(lv, v3, 16, "L_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_F, L_Ul_F)
//============================================================================



static void Test_L_Ul_I()
{
  {
    init_simple_test("L_Ul_I");
    STRUCT_IF_C L_Ul_I lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_I)");
    check_field_offset(lv, v1, 0, "L_Ul_I.v1");
    check_field_offset(lv, v2, 8, "L_Ul_I.v2");
    check_field_offset(lv, v3, 16, "L_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_I, L_Ul_I)
//============================================================================



static void Test_L_Ul_Ip()
{
  {
    init_simple_test("L_Ul_Ip");
    STRUCT_IF_C L_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_Ip)");
    check_field_offset(lv, v1, 0, "L_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Ip.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Ip, L_Ul_Ip)
//============================================================================



static void Test_L_Ul_L()
{
  {
    init_simple_test("L_Ul_L");
    STRUCT_IF_C L_Ul_L lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_L)");
    check_field_offset(lv, v1, 0, "L_Ul_L.v1");
    check_field_offset(lv, v2, 8, "L_Ul_L.v2");
    check_field_offset(lv, v3, 16, "L_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_L, L_Ul_L)
//============================================================================



static void Test_L_Ul_S()
{
  {
    init_simple_test("L_Ul_S");
    STRUCT_IF_C L_Ul_S lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_S)");
    check_field_offset(lv, v1, 0, "L_Ul_S.v1");
    check_field_offset(lv, v2, 8, "L_Ul_S.v2");
    check_field_offset(lv, v3, 16, "L_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_S, L_Ul_S)
//============================================================================



static void Test_L_Ul_Uc()
{
  {
    init_simple_test("L_Ul_Uc");
    STRUCT_IF_C L_Ul_Uc lv;
    check2(sizeof(lv), 17, "sizeof(L_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_Uc)");
    check_field_offset(lv, v1, 0, "L_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Uc.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Uc, L_Ul_Uc)
//============================================================================



static void Test_L_Ul_Ui()
{
  {
    init_simple_test("L_Ul_Ui");
    STRUCT_IF_C L_Ul_Ui lv;
    check2(sizeof(lv), 20, "sizeof(L_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_Ui)");
    check_field_offset(lv, v1, 0, "L_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Ui.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Ui, L_Ul_Ui)
//============================================================================



static void Test_L_Ul_Ul()
{
  {
    init_simple_test("L_Ul_Ul");
    STRUCT_IF_C L_Ul_Ul lv;
    check2(sizeof(lv), 24, "sizeof(L_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_Ul)");
    check_field_offset(lv, v1, 0, "L_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Ul.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Ul, L_Ul_Ul)
//============================================================================



static void Test_L_Ul_Us()
{
  {
    init_simple_test("L_Ul_Us");
    STRUCT_IF_C L_Ul_Us lv;
    check2(sizeof(lv), 18, "sizeof(L_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_Us)");
    check_field_offset(lv, v1, 0, "L_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Us.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Us, L_Ul_Us)
//============================================================================



static void Test_L_Ul_Vp()
{
  {
    init_simple_test("L_Ul_Vp");
    STRUCT_IF_C L_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Ul_Vp)");
    check_field_offset(lv, v1, 0, "L_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Ul_Vp.v2");
    check_field_offset(lv, v3, 16, "L_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Ul_Vp, L_Ul_Vp)
//============================================================================



static void Test_L_Us()
{
  {
    init_simple_test("L_Us");
    STRUCT_IF_C L_Us lv;
    check2(sizeof(lv), 10, "sizeof(L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us)");
    check_field_offset(lv, v1, 0, "L_Us.v1");
    check_field_offset(lv, v2, 8, "L_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us, L_Us)
//============================================================================



static void Test_L_Us_BFu15i()
{
  {
    init_simple_test("L_Us_BFu15i");
    static STRUCT_IF_C L_Us_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_Us_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu15i, L_Us_BFu15i)
//============================================================================



static void Test_L_Us_BFu15ll()
{
  {
    init_simple_test("L_Us_BFu15ll");
    static STRUCT_IF_C L_Us_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_Us_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu15ll, L_Us_BFu15ll)
//============================================================================



static void Test_L_Us_BFu15s()
{
  {
    init_simple_test("L_Us_BFu15s");
    static STRUCT_IF_C L_Us_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "L_Us_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "L_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu15s, L_Us_BFu15s)
//============================================================================



static void Test_L_Us_BFu16i()
{
  {
    init_simple_test("L_Us_BFu16i");
    static STRUCT_IF_C L_Us_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_Us_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu16i, L_Us_BFu16i)
//============================================================================



static void Test_L_Us_BFu16ll()
{
  {
    init_simple_test("L_Us_BFu16ll");
    static STRUCT_IF_C L_Us_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_Us_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu16ll, L_Us_BFu16ll)
//============================================================================



static void Test_L_Us_BFu16s()
{
  {
    init_simple_test("L_Us_BFu16s");
    static STRUCT_IF_C L_Us_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "L_Us_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "L_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu16s, L_Us_BFu16s)
//============================================================================



static void Test_L_Us_BFu17i()
{
  {
    init_simple_test("L_Us_BFu17i");
    static STRUCT_IF_C L_Us_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(L_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "L_Us_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "L_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu17i, L_Us_BFu17i)
//============================================================================



static void Test_L_Us_BFu17ll()
{
  {
    init_simple_test("L_Us_BFu17ll");
    static STRUCT_IF_C L_Us_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(L_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "L_Us_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "L_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu17ll, L_Us_BFu17ll)
//============================================================================



static void Test_L_Us_BFu1c()
{
  {
    init_simple_test("L_Us_BFu1c");
    static STRUCT_IF_C L_Us_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1c, L_Us_BFu1c)
//============================================================================



static void Test_L_Us_BFu1i()
{
  {
    init_simple_test("L_Us_BFu1i");
    static STRUCT_IF_C L_Us_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1i, L_Us_BFu1i)
//============================================================================



static void Test_L_Us_BFu1ll()
{
  {
    init_simple_test("L_Us_BFu1ll");
    static STRUCT_IF_C L_Us_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1ll, L_Us_BFu1ll)
//============================================================================



static void Test_L_Us_BFu1s()
{
  {
    init_simple_test("L_Us_BFu1s");
    static STRUCT_IF_C L_Us_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "L_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu1s, L_Us_BFu1s)
//============================================================================



static void Test_L_Us_BFu31i()
{
  {
    init_simple_test("L_Us_BFu31i");
    static STRUCT_IF_C L_Us_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "L_Us_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "L_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu31i, L_Us_BFu31i)
//============================================================================



static void Test_L_Us_BFu31ll()
{
  {
    init_simple_test("L_Us_BFu31ll");
    static STRUCT_IF_C L_Us_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "L_Us_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "L_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu31ll, L_Us_BFu31ll)
//============================================================================



static void Test_L_Us_BFu32i()
{
  {
    init_simple_test("L_Us_BFu32i");
    static STRUCT_IF_C L_Us_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "L_Us_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "L_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu32i, L_Us_BFu32i)
//============================================================================



static void Test_L_Us_BFu32ll()
{
  {
    init_simple_test("L_Us_BFu32ll");
    static STRUCT_IF_C L_Us_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "L_Us_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "L_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu32ll, L_Us_BFu32ll)
//============================================================================



static void Test_L_Us_BFu33()
{
  {
    init_simple_test("L_Us_BFu33");
    static STRUCT_IF_C L_Us_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(L_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu33)");
    check_field_offset(lv, v1, 0, "L_Us_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "L_Us_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "L_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu33, L_Us_BFu33)
//============================================================================



static void Test_L_Us_BFu7c()
{
  {
    init_simple_test("L_Us_BFu7c");
    static STRUCT_IF_C L_Us_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7c, L_Us_BFu7c)
//============================================================================



static void Test_L_Us_BFu7i()
{
  {
    init_simple_test("L_Us_BFu7i");
    static STRUCT_IF_C L_Us_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7i, L_Us_BFu7i)
//============================================================================



static void Test_L_Us_BFu7ll()
{
  {
    init_simple_test("L_Us_BFu7ll");
    static STRUCT_IF_C L_Us_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7ll, L_Us_BFu7ll)
//============================================================================



static void Test_L_Us_BFu7s()
{
  {
    init_simple_test("L_Us_BFu7s");
    static STRUCT_IF_C L_Us_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "L_Us_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "L_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu7s, L_Us_BFu7s)
//============================================================================



static void Test_L_Us_BFu8c()
{
  {
    init_simple_test("L_Us_BFu8c");
    static STRUCT_IF_C L_Us_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8c, L_Us_BFu8c)
//============================================================================



static void Test_L_Us_BFu8i()
{
  {
    init_simple_test("L_Us_BFu8i");
    static STRUCT_IF_C L_Us_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8i, L_Us_BFu8i)
//============================================================================



static void Test_L_Us_BFu8ll()
{
  {
    init_simple_test("L_Us_BFu8ll");
    static STRUCT_IF_C L_Us_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8ll, L_Us_BFu8ll)
//============================================================================



static void Test_L_Us_BFu8s()
{
  {
    init_simple_test("L_Us_BFu8s");
    static STRUCT_IF_C L_Us_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "L_Us_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "L_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu8s, L_Us_BFu8s)
//============================================================================



static void Test_L_Us_BFu9i()
{
  {
    init_simple_test("L_Us_BFu9i");
    static STRUCT_IF_C L_Us_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_Us_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu9i, L_Us_BFu9i)
//============================================================================



static void Test_L_Us_BFu9ll()
{
  {
    init_simple_test("L_Us_BFu9ll");
    static STRUCT_IF_C L_Us_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_Us_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu9ll, L_Us_BFu9ll)
//============================================================================



static void Test_L_Us_BFu9s()
{
  {
    init_simple_test("L_Us_BFu9s");
    static STRUCT_IF_C L_Us_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "L_Us_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "L_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_BFu9s, L_Us_BFu9s)
//============================================================================



static void Test_L_Us_C()
{
  {
    init_simple_test("L_Us_C");
    STRUCT_IF_C L_Us_C lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_C)");
    check_field_offset(lv, v1, 0, "L_Us_C.v1");
    check_field_offset(lv, v2, 8, "L_Us_C.v2");
    check_field_offset(lv, v3, 10, "L_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_C, L_Us_C)
//============================================================================



static void Test_L_Us_D()
{
  {
    init_simple_test("L_Us_D");
    STRUCT_IF_C L_Us_D lv;
    check2(sizeof(lv), 18, "sizeof(L_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_D)");
    check_field_offset(lv, v1, 0, "L_Us_D.v1");
    check_field_offset(lv, v2, 8, "L_Us_D.v2");
    check_field_offset(lv, v3, 10, "L_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_D, L_Us_D)
//============================================================================



static void Test_L_Us_F()
{
  {
    init_simple_test("L_Us_F");
    STRUCT_IF_C L_Us_F lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_F)");
    check_field_offset(lv, v1, 0, "L_Us_F.v1");
    check_field_offset(lv, v2, 8, "L_Us_F.v2");
    check_field_offset(lv, v3, 10, "L_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_F, L_Us_F)
//============================================================================



static void Test_L_Us_I()
{
  {
    init_simple_test("L_Us_I");
    STRUCT_IF_C L_Us_I lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_I)");
    check_field_offset(lv, v1, 0, "L_Us_I.v1");
    check_field_offset(lv, v2, 8, "L_Us_I.v2");
    check_field_offset(lv, v3, 10, "L_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_I, L_Us_I)
//============================================================================



static void Test_L_Us_Ip()
{
  {
    init_simple_test("L_Us_Ip");
    STRUCT_IF_C L_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_Ip)");
    check_field_offset(lv, v1, 0, "L_Us_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Us_Ip.v2");
    check_field_offset(lv, v3, 10, "L_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Ip, L_Us_Ip)
//============================================================================



static void Test_L_Us_L()
{
  {
    init_simple_test("L_Us_L");
    STRUCT_IF_C L_Us_L lv;
    check2(sizeof(lv), 18, "sizeof(L_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_L)");
    check_field_offset(lv, v1, 0, "L_Us_L.v1");
    check_field_offset(lv, v2, 8, "L_Us_L.v2");
    check_field_offset(lv, v3, 10, "L_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_L, L_Us_L)
//============================================================================



static void Test_L_Us_S()
{
  {
    init_simple_test("L_Us_S");
    STRUCT_IF_C L_Us_S lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_S)");
    check_field_offset(lv, v1, 0, "L_Us_S.v1");
    check_field_offset(lv, v2, 8, "L_Us_S.v2");
    check_field_offset(lv, v3, 10, "L_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_S, L_Us_S)
//============================================================================



static void Test_L_Us_Uc()
{
  {
    init_simple_test("L_Us_Uc");
    STRUCT_IF_C L_Us_Uc lv;
    check2(sizeof(lv), 11, "sizeof(L_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_Uc)");
    check_field_offset(lv, v1, 0, "L_Us_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Us_Uc.v2");
    check_field_offset(lv, v3, 10, "L_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Uc, L_Us_Uc)
//============================================================================



static void Test_L_Us_Ui()
{
  {
    init_simple_test("L_Us_Ui");
    STRUCT_IF_C L_Us_Ui lv;
    check2(sizeof(lv), 14, "sizeof(L_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_Ui)");
    check_field_offset(lv, v1, 0, "L_Us_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Us_Ui.v2");
    check_field_offset(lv, v3, 10, "L_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Ui, L_Us_Ui)
//============================================================================



static void Test_L_Us_Ul()
{
  {
    init_simple_test("L_Us_Ul");
    STRUCT_IF_C L_Us_Ul lv;
    check2(sizeof(lv), 18, "sizeof(L_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_Ul)");
    check_field_offset(lv, v1, 0, "L_Us_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Us_Ul.v2");
    check_field_offset(lv, v3, 10, "L_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Ul, L_Us_Ul)
//============================================================================



static void Test_L_Us_Us()
{
  {
    init_simple_test("L_Us_Us");
    STRUCT_IF_C L_Us_Us lv;
    check2(sizeof(lv), 12, "sizeof(L_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_Us)");
    check_field_offset(lv, v1, 0, "L_Us_Us.v1");
    check_field_offset(lv, v2, 8, "L_Us_Us.v2");
    check_field_offset(lv, v3, 10, "L_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Us, L_Us_Us)
//============================================================================



static void Test_L_Us_Vp()
{
  {
    init_simple_test("L_Us_Vp");
    STRUCT_IF_C L_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Us_Vp)");
    check_field_offset(lv, v1, 0, "L_Us_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Us_Vp.v2");
    check_field_offset(lv, v3, 10, "L_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Us_Vp, L_Us_Vp)
//============================================================================



static void Test_L_Vp()
{
  {
    init_simple_test("L_Vp");
    STRUCT_IF_C L_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp)");
    check_field_offset(lv, v1, 0, "L_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp, L_Vp)
//============================================================================



static void Test_L_Vp_BFu15i()
{
  {
    init_simple_test("L_Vp_BFu15i");
    static STRUCT_IF_C L_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu15i, L_Vp_BFu15i)
//============================================================================



static void Test_L_Vp_BFu15ll()
{
  {
    init_simple_test("L_Vp_BFu15ll");
    static STRUCT_IF_C L_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu15ll, L_Vp_BFu15ll)
//============================================================================



static void Test_L_Vp_BFu15s()
{
  {
    init_simple_test("L_Vp_BFu15s");
    static STRUCT_IF_C L_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "L_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "L_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu15s, L_Vp_BFu15s)
//============================================================================



static void Test_L_Vp_BFu16i()
{
  {
    init_simple_test("L_Vp_BFu16i");
    static STRUCT_IF_C L_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu16i, L_Vp_BFu16i)
//============================================================================



static void Test_L_Vp_BFu16ll()
{
  {
    init_simple_test("L_Vp_BFu16ll");
    static STRUCT_IF_C L_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu16ll, L_Vp_BFu16ll)
//============================================================================



static void Test_L_Vp_BFu16s()
{
  {
    init_simple_test("L_Vp_BFu16s");
    static STRUCT_IF_C L_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "L_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "L_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu16s, L_Vp_BFu16s)
//============================================================================



static void Test_L_Vp_BFu17i()
{
  {
    init_simple_test("L_Vp_BFu17i");
    static STRUCT_IF_C L_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(L_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "L_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "L_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu17i, L_Vp_BFu17i)
//============================================================================



static void Test_L_Vp_BFu17ll()
{
  {
    init_simple_test("L_Vp_BFu17ll");
    static STRUCT_IF_C L_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(L_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "L_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "L_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu17ll, L_Vp_BFu17ll)
//============================================================================



static void Test_L_Vp_BFu1c()
{
  {
    init_simple_test("L_Vp_BFu1c");
    static STRUCT_IF_C L_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1c, L_Vp_BFu1c)
//============================================================================



static void Test_L_Vp_BFu1i()
{
  {
    init_simple_test("L_Vp_BFu1i");
    static STRUCT_IF_C L_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1i, L_Vp_BFu1i)
//============================================================================



static void Test_L_Vp_BFu1ll()
{
  {
    init_simple_test("L_Vp_BFu1ll");
    static STRUCT_IF_C L_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1ll, L_Vp_BFu1ll)
//============================================================================



static void Test_L_Vp_BFu1s()
{
  {
    init_simple_test("L_Vp_BFu1s");
    static STRUCT_IF_C L_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "L_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu1s, L_Vp_BFu1s)
//============================================================================



static void Test_L_Vp_BFu31i()
{
  {
    init_simple_test("L_Vp_BFu31i");
    static STRUCT_IF_C L_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "L_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "L_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu31i, L_Vp_BFu31i)
//============================================================================



static void Test_L_Vp_BFu31ll()
{
  {
    init_simple_test("L_Vp_BFu31ll");
    static STRUCT_IF_C L_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "L_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "L_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu31ll, L_Vp_BFu31ll)
//============================================================================



static void Test_L_Vp_BFu32i()
{
  {
    init_simple_test("L_Vp_BFu32i");
    static STRUCT_IF_C L_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "L_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "L_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu32i, L_Vp_BFu32i)
//============================================================================



static void Test_L_Vp_BFu32ll()
{
  {
    init_simple_test("L_Vp_BFu32ll");
    static STRUCT_IF_C L_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "L_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "L_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu32ll, L_Vp_BFu32ll)
//============================================================================



static void Test_L_Vp_BFu33()
{
  {
    init_simple_test("L_Vp_BFu33");
    static STRUCT_IF_C L_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(L_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu33.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "L_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "L_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu33, L_Vp_BFu33)
//============================================================================



static void Test_L_Vp_BFu7c()
{
  {
    init_simple_test("L_Vp_BFu7c");
    static STRUCT_IF_C L_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7c, L_Vp_BFu7c)
//============================================================================



static void Test_L_Vp_BFu7i()
{
  {
    init_simple_test("L_Vp_BFu7i");
    static STRUCT_IF_C L_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7i, L_Vp_BFu7i)
//============================================================================



static void Test_L_Vp_BFu7ll()
{
  {
    init_simple_test("L_Vp_BFu7ll");
    static STRUCT_IF_C L_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7ll, L_Vp_BFu7ll)
//============================================================================



static void Test_L_Vp_BFu7s()
{
  {
    init_simple_test("L_Vp_BFu7s");
    static STRUCT_IF_C L_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "L_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "L_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu7s, L_Vp_BFu7s)
//============================================================================



static void Test_L_Vp_BFu8c()
{
  {
    init_simple_test("L_Vp_BFu8c");
    static STRUCT_IF_C L_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8c, L_Vp_BFu8c)
//============================================================================



static void Test_L_Vp_BFu8i()
{
  {
    init_simple_test("L_Vp_BFu8i");
    static STRUCT_IF_C L_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8i, L_Vp_BFu8i)
//============================================================================



static void Test_L_Vp_BFu8ll()
{
  {
    init_simple_test("L_Vp_BFu8ll");
    static STRUCT_IF_C L_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8ll, L_Vp_BFu8ll)
//============================================================================



static void Test_L_Vp_BFu8s()
{
  {
    init_simple_test("L_Vp_BFu8s");
    static STRUCT_IF_C L_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "L_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "L_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu8s, L_Vp_BFu8s)
//============================================================================



static void Test_L_Vp_BFu9i()
{
  {
    init_simple_test("L_Vp_BFu9i");
    static STRUCT_IF_C L_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu9i, L_Vp_BFu9i)
//============================================================================



static void Test_L_Vp_BFu9ll()
{
  {
    init_simple_test("L_Vp_BFu9ll");
    static STRUCT_IF_C L_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu9ll, L_Vp_BFu9ll)
//============================================================================



static void Test_L_Vp_BFu9s()
{
  {
    init_simple_test("L_Vp_BFu9s");
    static STRUCT_IF_C L_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "L_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "L_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_BFu9s, L_Vp_BFu9s)
//============================================================================



static void Test_L_Vp_C()
{
  {
    init_simple_test("L_Vp_C");
    STRUCT_IF_C L_Vp_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_C)");
    check_field_offset(lv, v1, 0, "L_Vp_C.v1");
    check_field_offset(lv, v2, 8, "L_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_C, L_Vp_C)
//============================================================================



static void Test_L_Vp_D()
{
  {
    init_simple_test("L_Vp_D");
    STRUCT_IF_C L_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_D)");
    check_field_offset(lv, v1, 0, "L_Vp_D.v1");
    check_field_offset(lv, v2, 8, "L_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_D, L_Vp_D)
//============================================================================



static void Test_L_Vp_F()
{
  {
    init_simple_test("L_Vp_F");
    STRUCT_IF_C L_Vp_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_F)");
    check_field_offset(lv, v1, 0, "L_Vp_F.v1");
    check_field_offset(lv, v2, 8, "L_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_F, L_Vp_F)
//============================================================================



static void Test_L_Vp_I()
{
  {
    init_simple_test("L_Vp_I");
    STRUCT_IF_C L_Vp_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_I)");
    check_field_offset(lv, v1, 0, "L_Vp_I.v1");
    check_field_offset(lv, v2, 8, "L_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_I, L_Vp_I)
//============================================================================



static void Test_L_Vp_Ip()
{
  {
    init_simple_test("L_Vp_Ip");
    STRUCT_IF_C L_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_Ip)");
    check_field_offset(lv, v1, 0, "L_Vp_Ip.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Ip, L_Vp_Ip)
//============================================================================



static void Test_L_Vp_L()
{
  {
    init_simple_test("L_Vp_L");
    STRUCT_IF_C L_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_L)");
    check_field_offset(lv, v1, 0, "L_Vp_L.v1");
    check_field_offset(lv, v2, 8, "L_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_L, L_Vp_L)
//============================================================================



static void Test_L_Vp_S()
{
  {
    init_simple_test("L_Vp_S");
    STRUCT_IF_C L_Vp_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_S)");
    check_field_offset(lv, v1, 0, "L_Vp_S.v1");
    check_field_offset(lv, v2, 8, "L_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_S, L_Vp_S)
//============================================================================



static void Test_L_Vp_Uc()
{
  {
    init_simple_test("L_Vp_Uc");
    STRUCT_IF_C L_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(L_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_Uc)");
    check_field_offset(lv, v1, 0, "L_Vp_Uc.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Uc, L_Vp_Uc)
//============================================================================



static void Test_L_Vp_Ui()
{
  {
    init_simple_test("L_Vp_Ui");
    STRUCT_IF_C L_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(L_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_Ui)");
    check_field_offset(lv, v1, 0, "L_Vp_Ui.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Ui, L_Vp_Ui)
//============================================================================



static void Test_L_Vp_Ul()
{
  {
    init_simple_test("L_Vp_Ul");
    STRUCT_IF_C L_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(L_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_Ul)");
    check_field_offset(lv, v1, 0, "L_Vp_Ul.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Ul, L_Vp_Ul)
//============================================================================



static void Test_L_Vp_Us()
{
  {
    init_simple_test("L_Vp_Us");
    STRUCT_IF_C L_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(L_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_Us)");
    check_field_offset(lv, v1, 0, "L_Vp_Us.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Us, L_Vp_Us)
//============================================================================



static void Test_L_Vp_Vp()
{
  {
    init_simple_test("L_Vp_Vp");
    STRUCT_IF_C L_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(L_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(L_Vp_Vp)");
    check_field_offset(lv, v1, 0, "L_Vp_Vp.v1");
    check_field_offset(lv, v2, 8, "L_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "L_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_L_Vp_Vp, L_Vp_Vp)
//============================================================================



static void Test_S()
{
  {
    init_simple_test("S");
    STRUCT_IF_C S lv;
    check2(sizeof(lv), 2, "sizeof(S)");
    check2(__alignof__(lv), 1, "__alignof__(S)");
    check_field_offset(lv, v1, 0, "S.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_S, S)
//============================================================================



static void Test_S_BFu15i()
{
  {
    init_simple_test("S_BFu15i");
    static STRUCT_IF_C S_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i, S_BFu15i)
//============================================================================



static void Test_S_BFu15i_BFu15i()
{
  {
    init_simple_test("S_BFu15i_BFu15i");
    static STRUCT_IF_C S_BFu15i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu15i, S_BFu15i_BFu15i)
//============================================================================



static void Test_S_BFu15i_BFu15ll()
{
  {
    init_simple_test("S_BFu15i_BFu15ll");
    static STRUCT_IF_C S_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu15ll, S_BFu15i_BFu15ll)
//============================================================================



static void Test_S_BFu15i_BFu15s()
{
  {
    init_simple_test("S_BFu15i_BFu15s");
    static STRUCT_IF_C S_BFu15i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu15s, S_BFu15i_BFu15s)
//============================================================================



static void Test_S_BFu15i_BFu16i()
{
  {
    init_simple_test("S_BFu15i_BFu16i");
    static STRUCT_IF_C S_BFu15i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu16i, S_BFu15i_BFu16i)
//============================================================================



static void Test_S_BFu15i_BFu16ll()
{
  {
    init_simple_test("S_BFu15i_BFu16ll");
    static STRUCT_IF_C S_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu16ll, S_BFu15i_BFu16ll)
//============================================================================



static void Test_S_BFu15i_BFu16s()
{
  {
    init_simple_test("S_BFu15i_BFu16s");
    static STRUCT_IF_C S_BFu15i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu16s, S_BFu15i_BFu16s)
//============================================================================



static void Test_S_BFu15i_BFu17i()
{
  {
    init_simple_test("S_BFu15i_BFu17i");
    static STRUCT_IF_C S_BFu15i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu17i, S_BFu15i_BFu17i)
//============================================================================



static void Test_S_BFu15i_BFu17ll()
{
  {
    init_simple_test("S_BFu15i_BFu17ll");
    static STRUCT_IF_C S_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu17ll, S_BFu15i_BFu17ll)
//============================================================================



static void Test_S_BFu15i_BFu1c()
{
  {
    init_simple_test("S_BFu15i_BFu1c");
    static STRUCT_IF_C S_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1c, S_BFu15i_BFu1c)
//============================================================================



static void Test_S_BFu15i_BFu1i()
{
  {
    init_simple_test("S_BFu15i_BFu1i");
    static STRUCT_IF_C S_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1i, S_BFu15i_BFu1i)
//============================================================================



static void Test_S_BFu15i_BFu1ll()
{
  {
    init_simple_test("S_BFu15i_BFu1ll");
    static STRUCT_IF_C S_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1ll, S_BFu15i_BFu1ll)
//============================================================================



static void Test_S_BFu15i_BFu1s()
{
  {
    init_simple_test("S_BFu15i_BFu1s");
    static STRUCT_IF_C S_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu1s, S_BFu15i_BFu1s)
//============================================================================



static void Test_S_BFu15i_BFu31i()
{
  {
    init_simple_test("S_BFu15i_BFu31i");
    static STRUCT_IF_C S_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu31i, S_BFu15i_BFu31i)
//============================================================================



static void Test_S_BFu15i_BFu31ll()
{
  {
    init_simple_test("S_BFu15i_BFu31ll");
    static STRUCT_IF_C S_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu31ll, S_BFu15i_BFu31ll)
//============================================================================



static void Test_S_BFu15i_BFu32i()
{
  {
    init_simple_test("S_BFu15i_BFu32i");
    static STRUCT_IF_C S_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu32i, S_BFu15i_BFu32i)
//============================================================================



static void Test_S_BFu15i_BFu32ll()
{
  {
    init_simple_test("S_BFu15i_BFu32ll");
    static STRUCT_IF_C S_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu32ll, S_BFu15i_BFu32ll)
//============================================================================



static void Test_S_BFu15i_BFu33()
{
  {
    init_simple_test("S_BFu15i_BFu33");
    static STRUCT_IF_C S_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "S_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "S_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu33, S_BFu15i_BFu33)
//============================================================================



static void Test_S_BFu15i_BFu7c()
{
  {
    init_simple_test("S_BFu15i_BFu7c");
    static STRUCT_IF_C S_BFu15i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7c, S_BFu15i_BFu7c)
//============================================================================



static void Test_S_BFu15i_BFu7i()
{
  {
    init_simple_test("S_BFu15i_BFu7i");
    static STRUCT_IF_C S_BFu15i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7i, S_BFu15i_BFu7i)
//============================================================================



static void Test_S_BFu15i_BFu7ll()
{
  {
    init_simple_test("S_BFu15i_BFu7ll");
    static STRUCT_IF_C S_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7ll, S_BFu15i_BFu7ll)
//============================================================================



static void Test_S_BFu15i_BFu7s()
{
  {
    init_simple_test("S_BFu15i_BFu7s");
    static STRUCT_IF_C S_BFu15i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu7s, S_BFu15i_BFu7s)
//============================================================================



static void Test_S_BFu15i_BFu8c()
{
  {
    init_simple_test("S_BFu15i_BFu8c");
    static STRUCT_IF_C S_BFu15i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8c, S_BFu15i_BFu8c)
//============================================================================



static void Test_S_BFu15i_BFu8i()
{
  {
    init_simple_test("S_BFu15i_BFu8i");
    static STRUCT_IF_C S_BFu15i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8i, S_BFu15i_BFu8i)
//============================================================================



static void Test_S_BFu15i_BFu8ll()
{
  {
    init_simple_test("S_BFu15i_BFu8ll");
    static STRUCT_IF_C S_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8ll, S_BFu15i_BFu8ll)
//============================================================================



static void Test_S_BFu15i_BFu8s()
{
  {
    init_simple_test("S_BFu15i_BFu8s");
    static STRUCT_IF_C S_BFu15i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu8s, S_BFu15i_BFu8s)
//============================================================================



static void Test_S_BFu15i_BFu9i()
{
  {
    init_simple_test("S_BFu15i_BFu9i");
    static STRUCT_IF_C S_BFu15i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu9i, S_BFu15i_BFu9i)
//============================================================================



static void Test_S_BFu15i_BFu9ll()
{
  {
    init_simple_test("S_BFu15i_BFu9ll");
    static STRUCT_IF_C S_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu9ll, S_BFu15i_BFu9ll)
//============================================================================



static void Test_S_BFu15i_BFu9s()
{
  {
    init_simple_test("S_BFu15i_BFu9s");
    static STRUCT_IF_C S_BFu15i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_BFu9s, S_BFu15i_BFu9s)
//============================================================================



static void Test_S_BFu15i_C()
{
  {
    init_simple_test("S_BFu15i_C");
    static STRUCT_IF_C S_BFu15i_C lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_C)");
    check_field_offset(lv, v1, 0, "S_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_C");
    check_field_offset(lv, v3, 4, "S_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_C, S_BFu15i_C)
//============================================================================



static void Test_S_BFu15i_D()
{
  {
    init_simple_test("S_BFu15i_D");
    static STRUCT_IF_C S_BFu15i_D lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_D)");
    check_field_offset(lv, v1, 0, "S_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_D");
    check_field_offset(lv, v3, 4, "S_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_D, S_BFu15i_D)
//============================================================================



static void Test_S_BFu15i_F()
{
  {
    init_simple_test("S_BFu15i_F");
    static STRUCT_IF_C S_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_F)");
    check_field_offset(lv, v1, 0, "S_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_F");
    check_field_offset(lv, v3, 4, "S_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_F, S_BFu15i_F)
//============================================================================



static void Test_S_BFu15i_I()
{
  {
    init_simple_test("S_BFu15i_I");
    static STRUCT_IF_C S_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_I)");
    check_field_offset(lv, v1, 0, "S_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_I");
    check_field_offset(lv, v3, 4, "S_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_I, S_BFu15i_I)
//============================================================================



static void Test_S_BFu15i_Ip()
{
  {
    init_simple_test("S_BFu15i_Ip");
    static STRUCT_IF_C S_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Ip");
    check_field_offset(lv, v3, 4, "S_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Ip, S_BFu15i_Ip)
//============================================================================



static void Test_S_BFu15i_L()
{
  {
    init_simple_test("S_BFu15i_L");
    static STRUCT_IF_C S_BFu15i_L lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_L)");
    check_field_offset(lv, v1, 0, "S_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_L");
    check_field_offset(lv, v3, 4, "S_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_L, S_BFu15i_L)
//============================================================================



static void Test_S_BFu15i_S()
{
  {
    init_simple_test("S_BFu15i_S");
    static STRUCT_IF_C S_BFu15i_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_S)");
    check_field_offset(lv, v1, 0, "S_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_S");
    check_field_offset(lv, v3, 4, "S_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_S, S_BFu15i_S)
//============================================================================



static void Test_S_BFu15i_Uc()
{
  {
    init_simple_test("S_BFu15i_Uc");
    static STRUCT_IF_C S_BFu15i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Uc");
    check_field_offset(lv, v3, 4, "S_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Uc, S_BFu15i_Uc)
//============================================================================



static void Test_S_BFu15i_Ui()
{
  {
    init_simple_test("S_BFu15i_Ui");
    static STRUCT_IF_C S_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "S_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Ui, S_BFu15i_Ui)
//============================================================================



static void Test_S_BFu15i_Ul()
{
  {
    init_simple_test("S_BFu15i_Ul");
    static STRUCT_IF_C S_BFu15i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Ul");
    check_field_offset(lv, v3, 4, "S_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Ul, S_BFu15i_Ul)
//============================================================================



static void Test_S_BFu15i_Us()
{
  {
    init_simple_test("S_BFu15i_Us");
    static STRUCT_IF_C S_BFu15i_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Us");
    check_field_offset(lv, v3, 4, "S_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Us, S_BFu15i_Us)
//============================================================================



static void Test_S_BFu15i_Vp()
{
  {
    init_simple_test("S_BFu15i_Vp");
    static STRUCT_IF_C S_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_Vp");
    check_field_offset(lv, v3, 4, "S_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15i_Vp, S_BFu15i_Vp)
//============================================================================



static void Test_S_BFu15ll()
{
  {
    init_simple_test("S_BFu15ll");
    static STRUCT_IF_C S_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll, S_BFu15ll)
//============================================================================



static void Test_S_BFu15ll_BFu15i()
{
  {
    init_simple_test("S_BFu15ll_BFu15i");
    static STRUCT_IF_C S_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu15i, S_BFu15ll_BFu15i)
//============================================================================



static void Test_S_BFu15ll_BFu15ll()
{
  {
    init_simple_test("S_BFu15ll_BFu15ll");
    static STRUCT_IF_C S_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu15ll, S_BFu15ll_BFu15ll)
//============================================================================



static void Test_S_BFu15ll_BFu15s()
{
  {
    init_simple_test("S_BFu15ll_BFu15s");
    static STRUCT_IF_C S_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu15s, S_BFu15ll_BFu15s)
//============================================================================



static void Test_S_BFu15ll_BFu16i()
{
  {
    init_simple_test("S_BFu15ll_BFu16i");
    static STRUCT_IF_C S_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu16i, S_BFu15ll_BFu16i)
//============================================================================



static void Test_S_BFu15ll_BFu16ll()
{
  {
    init_simple_test("S_BFu15ll_BFu16ll");
    static STRUCT_IF_C S_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu16ll, S_BFu15ll_BFu16ll)
//============================================================================



static void Test_S_BFu15ll_BFu16s()
{
  {
    init_simple_test("S_BFu15ll_BFu16s");
    static STRUCT_IF_C S_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu16s, S_BFu15ll_BFu16s)
//============================================================================



static void Test_S_BFu15ll_BFu17i()
{
  {
    init_simple_test("S_BFu15ll_BFu17i");
    static STRUCT_IF_C S_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu17i, S_BFu15ll_BFu17i)
//============================================================================



static void Test_S_BFu15ll_BFu17ll()
{
  {
    init_simple_test("S_BFu15ll_BFu17ll");
    static STRUCT_IF_C S_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "S_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "S_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu17ll, S_BFu15ll_BFu17ll)
//============================================================================



static void Test_S_BFu15ll_BFu1c()
{
  {
    init_simple_test("S_BFu15ll_BFu1c");
    static STRUCT_IF_C S_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1c, S_BFu15ll_BFu1c)
//============================================================================



static void Test_S_BFu15ll_BFu1i()
{
  {
    init_simple_test("S_BFu15ll_BFu1i");
    static STRUCT_IF_C S_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1i, S_BFu15ll_BFu1i)
//============================================================================



static void Test_S_BFu15ll_BFu1ll()
{
  {
    init_simple_test("S_BFu15ll_BFu1ll");
    static STRUCT_IF_C S_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1ll, S_BFu15ll_BFu1ll)
//============================================================================



static void Test_S_BFu15ll_BFu1s()
{
  {
    init_simple_test("S_BFu15ll_BFu1s");
    static STRUCT_IF_C S_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "S_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu1s, S_BFu15ll_BFu1s)
//============================================================================



static void Test_S_BFu15ll_BFu31i()
{
  {
    init_simple_test("S_BFu15ll_BFu31i");
    static STRUCT_IF_C S_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu31i, S_BFu15ll_BFu31i)
//============================================================================



static void Test_S_BFu15ll_BFu31ll()
{
  {
    init_simple_test("S_BFu15ll_BFu31ll");
    static STRUCT_IF_C S_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "S_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "S_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu31ll, S_BFu15ll_BFu31ll)
//============================================================================



static void Test_S_BFu15ll_BFu32i()
{
  {
    init_simple_test("S_BFu15ll_BFu32i");
    static STRUCT_IF_C S_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu32i, S_BFu15ll_BFu32i)
//============================================================================



static void Test_S_BFu15ll_BFu32ll()
{
  {
    init_simple_test("S_BFu15ll_BFu32ll");
    static STRUCT_IF_C S_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "S_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "S_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu32ll, S_BFu15ll_BFu32ll)
//============================================================================



static void Test_S_BFu15ll_BFu33()
{
  {
    init_simple_test("S_BFu15ll_BFu33");
    static STRUCT_IF_C S_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "S_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "S_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu33, S_BFu15ll_BFu33)
//============================================================================



static void Test_S_BFu15ll_BFu7c()
{
  {
    init_simple_test("S_BFu15ll_BFu7c");
    static STRUCT_IF_C S_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7c, S_BFu15ll_BFu7c)
//============================================================================



static void Test_S_BFu15ll_BFu7i()
{
  {
    init_simple_test("S_BFu15ll_BFu7i");
    static STRUCT_IF_C S_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7i, S_BFu15ll_BFu7i)
//============================================================================



static void Test_S_BFu15ll_BFu7ll()
{
  {
    init_simple_test("S_BFu15ll_BFu7ll");
    static STRUCT_IF_C S_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7ll, S_BFu15ll_BFu7ll)
//============================================================================



static void Test_S_BFu15ll_BFu7s()
{
  {
    init_simple_test("S_BFu15ll_BFu7s");
    static STRUCT_IF_C S_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "S_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "S_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu7s, S_BFu15ll_BFu7s)
//============================================================================



static void Test_S_BFu15ll_BFu8c()
{
  {
    init_simple_test("S_BFu15ll_BFu8c");
    static STRUCT_IF_C S_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8c, S_BFu15ll_BFu8c)
//============================================================================



static void Test_S_BFu15ll_BFu8i()
{
  {
    init_simple_test("S_BFu15ll_BFu8i");
    static STRUCT_IF_C S_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8i, S_BFu15ll_BFu8i)
//============================================================================



static void Test_S_BFu15ll_BFu8ll()
{
  {
    init_simple_test("S_BFu15ll_BFu8ll");
    static STRUCT_IF_C S_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8ll, S_BFu15ll_BFu8ll)
//============================================================================



static void Test_S_BFu15ll_BFu8s()
{
  {
    init_simple_test("S_BFu15ll_BFu8s");
    static STRUCT_IF_C S_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "S_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "S_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu8s, S_BFu15ll_BFu8s)
//============================================================================



static void Test_S_BFu15ll_BFu9i()
{
  {
    init_simple_test("S_BFu15ll_BFu9i");
    static STRUCT_IF_C S_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu9i, S_BFu15ll_BFu9i)
//============================================================================



static void Test_S_BFu15ll_BFu9ll()
{
  {
    init_simple_test("S_BFu15ll_BFu9ll");
    static STRUCT_IF_C S_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu9ll, S_BFu15ll_BFu9ll)
//============================================================================



static void Test_S_BFu15ll_BFu9s()
{
  {
    init_simple_test("S_BFu15ll_BFu9s");
    static STRUCT_IF_C S_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "S_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "S_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_BFu9s, S_BFu15ll_BFu9s)
//============================================================================



static void Test_S_BFu15ll_C()
{
  {
    init_simple_test("S_BFu15ll_C");
    static STRUCT_IF_C S_BFu15ll_C lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_C");
    check_field_offset(lv, v3, 4, "S_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_C, S_BFu15ll_C)
//============================================================================



static void Test_S_BFu15ll_D()
{
  {
    init_simple_test("S_BFu15ll_D");
    static STRUCT_IF_C S_BFu15ll_D lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_D");
    check_field_offset(lv, v3, 4, "S_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_D, S_BFu15ll_D)
//============================================================================



static void Test_S_BFu15ll_F()
{
  {
    init_simple_test("S_BFu15ll_F");
    static STRUCT_IF_C S_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_F");
    check_field_offset(lv, v3, 4, "S_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_F, S_BFu15ll_F)
//============================================================================



static void Test_S_BFu15ll_I()
{
  {
    init_simple_test("S_BFu15ll_I");
    static STRUCT_IF_C S_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_I");
    check_field_offset(lv, v3, 4, "S_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_I, S_BFu15ll_I)
//============================================================================



static void Test_S_BFu15ll_Ip()
{
  {
    init_simple_test("S_BFu15ll_Ip");
    static STRUCT_IF_C S_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Ip");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Ip, S_BFu15ll_Ip)
//============================================================================



static void Test_S_BFu15ll_L()
{
  {
    init_simple_test("S_BFu15ll_L");
    static STRUCT_IF_C S_BFu15ll_L lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_L");
    check_field_offset(lv, v3, 4, "S_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_L, S_BFu15ll_L)
//============================================================================



static void Test_S_BFu15ll_S()
{
  {
    init_simple_test("S_BFu15ll_S");
    static STRUCT_IF_C S_BFu15ll_S lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_S");
    check_field_offset(lv, v3, 4, "S_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_S, S_BFu15ll_S)
//============================================================================



static void Test_S_BFu15ll_Uc()
{
  {
    init_simple_test("S_BFu15ll_Uc");
    static STRUCT_IF_C S_BFu15ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(S_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Uc");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Uc, S_BFu15ll_Uc)
//============================================================================



static void Test_S_BFu15ll_Ui()
{
  {
    init_simple_test("S_BFu15ll_Ui");
    static STRUCT_IF_C S_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Ui, S_BFu15ll_Ui)
//============================================================================



static void Test_S_BFu15ll_Ul()
{
  {
    init_simple_test("S_BFu15ll_Ul");
    static STRUCT_IF_C S_BFu15ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(S_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Ul");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Ul, S_BFu15ll_Ul)
//============================================================================



static void Test_S_BFu15ll_Us()
{
  {
    init_simple_test("S_BFu15ll_Us");
    static STRUCT_IF_C S_BFu15ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Us, S_BFu15ll_Us)
//============================================================================



static void Test_S_BFu15ll_Vp()
{
  {
    init_simple_test("S_BFu15ll_Vp");
    static STRUCT_IF_C S_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_Vp");
    check_field_offset(lv, v3, 4, "S_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15ll_Vp, S_BFu15ll_Vp)
//============================================================================



static void Test_S_BFu15s()
{
  {
    init_simple_test("S_BFu15s");
    static STRUCT_IF_C S_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s, S_BFu15s)
//============================================================================



static void Test_S_BFu15s_BFu15i()
{
  {
    init_simple_test("S_BFu15s_BFu15i");
    static STRUCT_IF_C S_BFu15s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu15i, S_BFu15s_BFu15i)
//============================================================================



static void Test_S_BFu15s_BFu15ll()
{
  {
    init_simple_test("S_BFu15s_BFu15ll");
    static STRUCT_IF_C S_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu15ll, S_BFu15s_BFu15ll)
//============================================================================



static void Test_S_BFu15s_BFu15s()
{
  {
    init_simple_test("S_BFu15s_BFu15s");
    static STRUCT_IF_C S_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "S_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "S_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu15s, S_BFu15s_BFu15s)
//============================================================================



static void Test_S_BFu15s_BFu16i()
{
  {
    init_simple_test("S_BFu15s_BFu16i");
    static STRUCT_IF_C S_BFu15s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "S_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "S_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_S_BFu15s_BFu16i, S_BFu15s_BFu16i)
//============================================================================



static void Test_S_BFu15s_BFu16ll()
{
  {
    init_simple_test("S_BFu15s_BFu16ll");
    static STRUCT_IF_C S_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(S_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(S_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu1