// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct D_BFu9i_BFu31i { double v1; unsigned int v2:9; unsigned int v3:31; };
struct D_BFu9i_BFu31ll { double v1; unsigned int v2:9; unsigned long long v3:31; };
struct D_BFu9i_BFu32i { double v1; unsigned int v2:9; unsigned int v3:32; };
struct D_BFu9i_BFu32ll { double v1; unsigned int v2:9; unsigned long long v3:32; };
struct D_BFu9i_BFu33 { double v1; unsigned int v2:9; unsigned long long v3:33; };
struct D_BFu9i_BFu7c { double v1; unsigned int v2:9; unsigned char v3:7; };
struct D_BFu9i_BFu7i { double v1; unsigned int v2:9; unsigned int v3:7; };
struct D_BFu9i_BFu7ll { double v1; unsigned int v2:9; unsigned long long v3:7; };
struct D_BFu9i_BFu7s { double v1; unsigned int v2:9; unsigned short v3:7; };
struct D_BFu9i_BFu8c { double v1; unsigned int v2:9; unsigned char v3:8; };
struct D_BFu9i_BFu8i { double v1; unsigned int v2:9; unsigned int v3:8; };
struct D_BFu9i_BFu8ll { double v1; unsigned int v2:9; unsigned long long v3:8; };
struct D_BFu9i_BFu8s { double v1; unsigned int v2:9; unsigned short v3:8; };
struct D_BFu9i_BFu9i { double v1; unsigned int v2:9; unsigned int v3:9; };
struct D_BFu9i_BFu9ll { double v1; unsigned int v2:9; unsigned long long v3:9; };
struct D_BFu9i_BFu9s { double v1; unsigned int v2:9; unsigned short v3:9; };
struct D_BFu9i_C { double v1; unsigned int v2:9; char v3; };
struct D_BFu9i_D { double v1; unsigned int v2:9; double v3; };
struct D_BFu9i_F { double v1; unsigned int v2:9; float v3; };
struct D_BFu9i_I { double v1; unsigned int v2:9; int v3; };
struct D_BFu9i_Ip { double v1; unsigned int v2:9; int * v3; };
struct D_BFu9i_L { double v1; unsigned int v2:9; long long v3; };
struct D_BFu9i_S { double v1; unsigned int v2:9; short v3; };
struct D_BFu9i_Uc { double v1; unsigned int v2:9; unsigned char v3; };
struct D_BFu9i_Ui { double v1; unsigned int v2:9; unsigned int v3; };
struct D_BFu9i_Ul { double v1; unsigned int v2:9; unsigned long long v3; };
struct D_BFu9i_Us { double v1; unsigned int v2:9; unsigned short v3; };
struct D_BFu9i_Vp { double v1; unsigned int v2:9; void * v3; };
struct D_BFu9ll { double v1; unsigned long long v2:9; };
struct D_BFu9ll_BFu15i { double v1; unsigned long long v2:9; unsigned int v3:15; };
struct D_BFu9ll_BFu15ll { double v1; unsigned long long v2:9; unsigned long long v3:15; };
struct D_BFu9ll_BFu15s { double v1; unsigned long long v2:9; unsigned short v3:15; };
struct D_BFu9ll_BFu16i { double v1; unsigned long long v2:9; unsigned int v3:16; };
struct D_BFu9ll_BFu16ll { double v1; unsigned long long v2:9; unsigned long long v3:16; };
struct D_BFu9ll_BFu16s { double v1; unsigned long long v2:9; unsigned short v3:16; };
struct D_BFu9ll_BFu17i { double v1; unsigned long long v2:9; unsigned int v3:17; };
struct D_BFu9ll_BFu17ll { double v1; unsigned long long v2:9; unsigned long long v3:17; };
struct D_BFu9ll_BFu1c { double v1; unsigned long long v2:9; unsigned char v3:1; };
struct D_BFu9ll_BFu1i { double v1; unsigned long long v2:9; unsigned int v3:1; };
struct D_BFu9ll_BFu1ll { double v1; unsigned long long v2:9; unsigned long long v3:1; };
struct D_BFu9ll_BFu1s { double v1; unsigned long long v2:9; unsigned short v3:1; };
struct D_BFu9ll_BFu31i { double v1; unsigned long long v2:9; unsigned int v3:31; };
struct D_BFu9ll_BFu31ll { double v1; unsigned long long v2:9; unsigned long long v3:31; };
struct D_BFu9ll_BFu32i { double v1; unsigned long long v2:9; unsigned int v3:32; };
struct D_BFu9ll_BFu32ll { double v1; unsigned long long v2:9; unsigned long long v3:32; };
struct D_BFu9ll_BFu33 { double v1; unsigned long long v2:9; unsigned long long v3:33; };
struct D_BFu9ll_BFu7c { double v1; unsigned long long v2:9; unsigned char v3:7; };
struct D_BFu9ll_BFu7i { double v1; unsigned long long v2:9; unsigned int v3:7; };
struct D_BFu9ll_BFu7ll { double v1; unsigned long long v2:9; unsigned long long v3:7; };
struct D_BFu9ll_BFu7s { double v1; unsigned long long v2:9; unsigned short v3:7; };
struct D_BFu9ll_BFu8c { double v1; unsigned long long v2:9; unsigned char v3:8; };
struct D_BFu9ll_BFu8i { double v1; unsigned long long v2:9; unsigned int v3:8; };
struct D_BFu9ll_BFu8ll { double v1; unsigned long long v2:9; unsigned long long v3:8; };
struct D_BFu9ll_BFu8s { double v1; unsigned long long v2:9; unsigned short v3:8; };
struct D_BFu9ll_BFu9i { double v1; unsigned long long v2:9; unsigned int v3:9; };
struct D_BFu9ll_BFu9ll { double v1; unsigned long long v2:9; unsigned long long v3:9; };
struct D_BFu9ll_BFu9s { double v1; unsigned long long v2:9; unsigned short v3:9; };
struct D_BFu9ll_C { double v1; unsigned long long v2:9; char v3; };
struct D_BFu9ll_D { double v1; unsigned long long v2:9; double v3; };
struct D_BFu9ll_F { double v1; unsigned long long v2:9; float v3; };
struct D_BFu9ll_I { double v1; unsigned long long v2:9; int v3; };
struct D_BFu9ll_Ip { double v1; unsigned long long v2:9; int * v3; };
struct D_BFu9ll_L { double v1; unsigned long long v2:9; long long v3; };
struct D_BFu9ll_S { double v1; unsigned long long v2:9; short v3; };
struct D_BFu9ll_Uc { double v1; unsigned long long v2:9; unsigned char v3; };
struct D_BFu9ll_Ui { double v1; unsigned long long v2:9; unsigned int v3; };
struct D_BFu9ll_Ul { double v1; unsigned long long v2:9; unsigned long long v3; };
struct D_BFu9ll_Us { double v1; unsigned long long v2:9; unsigned short v3; };
struct D_BFu9ll_Vp { double v1; unsigned long long v2:9; void * v3; };
struct D_BFu9s { double v1; unsigned short v2:9; };
struct D_BFu9s_BFu15i { double v1; unsigned short v2:9; unsigned int v3:15; };
struct D_BFu9s_BFu15ll { double v1; unsigned short v2:9; unsigned long long v3:15; };
struct D_BFu9s_BFu15s { double v1; unsigned short v2:9; unsigned short v3:15; };
struct D_BFu9s_BFu16i { double v1; unsigned short v2:9; unsigned int v3:16; };
struct D_BFu9s_BFu16ll { double v1; unsigned short v2:9; unsigned long long v3:16; };
struct D_BFu9s_BFu16s { double v1; unsigned short v2:9; unsigned short v3:16; };
struct D_BFu9s_BFu17i { double v1; unsigned short v2:9; unsigned int v3:17; };
struct D_BFu9s_BFu17ll { double v1; unsigned short v2:9; unsigned long long v3:17; };
struct D_BFu9s_BFu1c { double v1; unsigned short v2:9; unsigned char v3:1; };
struct D_BFu9s_BFu1i { double v1; unsigned short v2:9; unsigned int v3:1; };
struct D_BFu9s_BFu1ll { double v1; unsigned short v2:9; unsigned long long v3:1; };
struct D_BFu9s_BFu1s { double v1; unsigned short v2:9; unsigned short v3:1; };
struct D_BFu9s_BFu31i { double v1; unsigned short v2:9; unsigned int v3:31; };
struct D_BFu9s_BFu31ll { double v1; unsigned short v2:9; unsigned long long v3:31; };
struct D_BFu9s_BFu32i { double v1; unsigned short v2:9; unsigned int v3:32; };
struct D_BFu9s_BFu32ll { double v1; unsigned short v2:9; unsigned long long v3:32; };
struct D_BFu9s_BFu33 { double v1; unsigned short v2:9; unsigned long long v3:33; };
struct D_BFu9s_BFu7c { double v1; unsigned short v2:9; unsigned char v3:7; };
struct D_BFu9s_BFu7i { double v1; unsigned short v2:9; unsigned int v3:7; };
struct D_BFu9s_BFu7ll { double v1; unsigned short v2:9; unsigned long long v3:7; };
struct D_BFu9s_BFu7s { double v1; unsigned short v2:9; unsigned short v3:7; };
struct D_BFu9s_BFu8c { double v1; unsigned short v2:9; unsigned char v3:8; };
struct D_BFu9s_BFu8i { double v1; unsigned short v2:9; unsigned int v3:8; };
struct D_BFu9s_BFu8ll { double v1; unsigned short v2:9; unsigned long long v3:8; };
struct D_BFu9s_BFu8s { double v1; unsigned short v2:9; unsigned short v3:8; };
struct D_BFu9s_BFu9i { double v1; unsigned short v2:9; unsigned int v3:9; };
struct D_BFu9s_BFu9ll { double v1; unsigned short v2:9; unsigned long long v3:9; };
struct D_BFu9s_BFu9s { double v1; unsigned short v2:9; unsigned short v3:9; };
struct D_BFu9s_C { double v1; unsigned short v2:9; char v3; };
struct D_BFu9s_D { double v1; unsigned short v2:9; double v3; };
struct D_BFu9s_F { double v1; unsigned short v2:9; float v3; };
struct D_BFu9s_I { double v1; unsigned short v2:9; int v3; };
struct D_BFu9s_Ip { double v1; unsigned short v2:9; int * v3; };
struct D_BFu9s_L { double v1; unsigned short v2:9; long long v3; };
struct D_BFu9s_S { double v1; unsigned short v2:9; short v3; };
struct D_BFu9s_Uc { double v1; unsigned short v2:9; unsigned char v3; };
struct D_BFu9s_Ui { double v1; unsigned short v2:9; unsigned int v3; };
struct D_BFu9s_Ul { double v1; unsigned short v2:9; unsigned long long v3; };
struct D_BFu9s_Us { double v1; unsigned short v2:9; unsigned short v3; };
struct D_BFu9s_Vp { double v1; unsigned short v2:9; void * v3; };
struct D_C { double v1; char v2; };
struct D_C_BFu15i { double v1; char v2; unsigned int v3:15; };
struct D_C_BFu15ll { double v1; char v2; unsigned long long v3:15; };
struct D_C_BFu15s { double v1; char v2; unsigned short v3:15; };
struct D_C_BFu16i { double v1; char v2; unsigned int v3:16; };
struct D_C_BFu16ll { double v1; char v2; unsigned long long v3:16; };
struct D_C_BFu16s { double v1; char v2; unsigned short v3:16; };
struct D_C_BFu17i { double v1; char v2; unsigned int v3:17; };
struct D_C_BFu17ll { double v1; char v2; unsigned long long v3:17; };
struct D_C_BFu1c { double v1; char v2; unsigned char v3:1; };
struct D_C_BFu1i { double v1; char v2; unsigned int v3:1; };
struct D_C_BFu1ll { double v1; char v2; unsigned long long v3:1; };
struct D_C_BFu1s { double v1; char v2; unsigned short v3:1; };
struct D_C_BFu31i { double v1; char v2; unsigned int v3:31; };
struct D_C_BFu31ll { double v1; char v2; unsigned long long v3:31; };
struct D_C_BFu32i { double v1; char v2; unsigned int v3:32; };
struct D_C_BFu32ll { double v1; char v2; unsigned long long v3:32; };
struct D_C_BFu33 { double v1; char v2; unsigned long long v3:33; };
struct D_C_BFu7c { double v1; char v2; unsigned char v3:7; };
struct D_C_BFu7i { double v1; char v2; unsigned int v3:7; };
struct D_C_BFu7ll { double v1; char v2; unsigned long long v3:7; };
struct D_C_BFu7s { double v1; char v2; unsigned short v3:7; };
struct D_C_BFu8c { double v1; char v2; unsigned char v3:8; };
struct D_C_BFu8i { double v1; char v2; unsigned int v3:8; };
struct D_C_BFu8ll { double v1; char v2; unsigned long long v3:8; };
struct D_C_BFu8s { double v1; char v2; unsigned short v3:8; };
struct D_C_BFu9i { double v1; char v2; unsigned int v3:9; };
struct D_C_BFu9ll { double v1; char v2; unsigned long long v3:9; };
struct D_C_BFu9s { double v1; char v2; unsigned short v3:9; };
struct D_C_C { double v1; char v2; char v3; };
struct D_C_D { double v1; char v2; double v3; };
struct D_C_F { double v1; char v2; float v3; };
struct D_C_I { double v1; char v2; int v3; };
struct D_C_Ip { double v1; char v2; int * v3; };
struct D_C_L { double v1; char v2; long long v3; };
struct D_C_S { double v1; char v2; short v3; };
struct D_C_Uc { double v1; char v2; unsigned char v3; };
struct D_C_Ui { double v1; char v2; unsigned int v3; };
struct D_C_Ul { double v1; char v2; unsigned long long v3; };
struct D_C_Us { double v1; char v2; unsigned short v3; };
struct D_C_Vp { double v1; char v2; void * v3; };
struct D_D { double v1; double v2; };
struct D_D_BFu15i { double v1; double v2; unsigned int v3:15; };
struct D_D_BFu15ll { double v1; double v2; unsigned long long v3:15; };
struct D_D_BFu15s { double v1; double v2; unsigned short v3:15; };
struct D_D_BFu16i { double v1; double v2; unsigned int v3:16; };
struct D_D_BFu16ll { double v1; double v2; unsigned long long v3:16; };
struct D_D_BFu16s { double v1; double v2; unsigned short v3:16; };
struct D_D_BFu17i { double v1; double v2; unsigned int v3:17; };
struct D_D_BFu17ll { double v1; double v2; unsigned long long v3:17; };
struct D_D_BFu1c { double v1; double v2; unsigned char v3:1; };
struct D_D_BFu1i { double v1; double v2; unsigned int v3:1; };
struct D_D_BFu1ll { double v1; double v2; unsigned long long v3:1; };
struct D_D_BFu1s { double v1; double v2; unsigned short v3:1; };
struct D_D_BFu31i { double v1; double v2; unsigned int v3:31; };
struct D_D_BFu31ll { double v1; double v2; unsigned long long v3:31; };
struct D_D_BFu32i { double v1; double v2; unsigned int v3:32; };
struct D_D_BFu32ll { double v1; double v2; unsigned long long v3:32; };
struct D_D_BFu33 { double v1; double v2; unsigned long long v3:33; };
struct D_D_BFu7c { double v1; double v2; unsigned char v3:7; };
struct D_D_BFu7i { double v1; double v2; unsigned int v3:7; };
struct D_D_BFu7ll { double v1; double v2; unsigned long long v3:7; };
struct D_D_BFu7s { double v1; double v2; unsigned short v3:7; };
struct D_D_BFu8c { double v1; double v2; unsigned char v3:8; };
struct D_D_BFu8i { double v1; double v2; unsigned int v3:8; };
struct D_D_BFu8ll { double v1; double v2; unsigned long long v3:8; };
struct D_D_BFu8s { double v1; double v2; unsigned short v3:8; };
struct D_D_BFu9i { double v1; double v2; unsigned int v3:9; };
struct D_D_BFu9ll { double v1; double v2; unsigned long long v3:9; };
struct D_D_BFu9s { double v1; double v2; unsigned short v3:9; };
struct D_D_C { double v1; double v2; char v3; };
struct D_D_D { double v1; double v2; double v3; };
struct D_D_F { double v1; double v2; float v3; };
struct D_D_I { double v1; double v2; int v3; };
struct D_D_Ip { double v1; double v2; int * v3; };
struct D_D_L { double v1; double v2; long long v3; };
struct D_D_S { double v1; double v2; short v3; };
struct D_D_Uc { double v1; double v2; unsigned char v3; };
struct D_D_Ui { double v1; double v2; unsigned int v3; };
struct D_D_Ul { double v1; double v2; unsigned long long v3; };
struct D_D_Us { double v1; double v2; unsigned short v3; };
struct D_D_Vp { double v1; double v2; void * v3; };
struct D_F { double v1; float v2; };
struct D_F_BFu15i { double v1; float v2; unsigned int v3:15; };
struct D_F_BFu15ll { double v1; float v2; unsigned long long v3:15; };
struct D_F_BFu15s { double v1; float v2; unsigned short v3:15; };
struct D_F_BFu16i { double v1; float v2; unsigned int v3:16; };
struct D_F_BFu16ll { double v1; float v2; unsigned long long v3:16; };
struct D_F_BFu16s { double v1; float v2; unsigned short v3:16; };
struct D_F_BFu17i { double v1; float v2; unsigned int v3:17; };
struct D_F_BFu17ll { double v1; float v2; unsigned long long v3:17; };
struct D_F_BFu1c { double v1; float v2; unsigned char v3:1; };
struct D_F_BFu1i { double v1; float v2; unsigned int v3:1; };
struct D_F_BFu1ll { double v1; float v2; unsigned long long v3:1; };
struct D_F_BFu1s { double v1; float v2; unsigned short v3:1; };
struct D_F_BFu31i { double v1; float v2; unsigned int v3:31; };
struct D_F_BFu31ll { double v1; float v2; unsigned long long v3:31; };
struct D_F_BFu32i { double v1; float v2; unsigned int v3:32; };
struct D_F_BFu32ll { double v1; float v2; unsigned long long v3:32; };
struct D_F_BFu33 { double v1; float v2; unsigned long long v3:33; };
struct D_F_BFu7c { double v1; float v2; unsigned char v3:7; };
struct D_F_BFu7i { double v1; float v2; unsigned int v3:7; };
struct D_F_BFu7ll { double v1; float v2; unsigned long long v3:7; };
struct D_F_BFu7s { double v1; float v2; unsigned short v3:7; };
struct D_F_BFu8c { double v1; float v2; unsigned char v3:8; };
struct D_F_BFu8i { double v1; float v2; unsigned int v3:8; };
struct D_F_BFu8ll { double v1; float v2; unsigned long long v3:8; };
struct D_F_BFu8s { double v1; float v2; unsigned short v3:8; };
struct D_F_BFu9i { double v1; float v2; unsigned int v3:9; };
struct D_F_BFu9ll { double v1; float v2; unsigned long long v3:9; };
struct D_F_BFu9s { double v1; float v2; unsigned short v3:9; };
struct D_F_C { double v1; float v2; char v3; };
struct D_F_D { double v1; float v2; double v3; };
struct D_F_F { double v1; float v2; float v3; };
struct D_F_I { double v1; float v2; int v3; };
struct D_F_Ip { double v1; float v2; int * v3; };
struct D_F_L { double v1; float v2; long long v3; };
struct D_F_S { double v1; float v2; short v3; };
struct D_F_Uc { double v1; float v2; unsigned char v3; };
struct D_F_Ui { double v1; float v2; unsigned int v3; };
struct D_F_Ul { double v1; float v2; unsigned long long v3; };
struct D_F_Us { double v1; float v2; unsigned short v3; };
struct D_F_Vp { double v1; float v2; void * v3; };
struct D_I { double v1; int v2; };
struct D_I_BFu15i { double v1; int v2; unsigned int v3:15; };
struct D_I_BFu15ll { double v1; int v2; unsigned long long v3:15; };
struct D_I_BFu15s { double v1; int v2; unsigned short v3:15; };
struct D_I_BFu16i { double v1; int v2; unsigned int v3:16; };
struct D_I_BFu16ll { double v1; int v2; unsigned long long v3:16; };
struct D_I_BFu16s { double v1; int v2; unsigned short v3:16; };
struct D_I_BFu17i { double v1; int v2; unsigned int v3:17; };
struct D_I_BFu17ll { double v1; int v2; unsigned long long v3:17; };
struct D_I_BFu1c { double v1; int v2; unsigned char v3:1; };
struct D_I_BFu1i { double v1; int v2; unsigned int v3:1; };
struct D_I_BFu1ll { double v1; int v2; unsigned long long v3:1; };
struct D_I_BFu1s { double v1; int v2; unsigned short v3:1; };
struct D_I_BFu31i { double v1; int v2; unsigned int v3:31; };
struct D_I_BFu31ll { double v1; int v2; unsigned long long v3:31; };
struct D_I_BFu32i { double v1; int v2; unsigned int v3:32; };
struct D_I_BFu32ll { double v1; int v2; unsigned long long v3:32; };
struct D_I_BFu33 { double v1; int v2; unsigned long long v3:33; };
struct D_I_BFu7c { double v1; int v2; unsigned char v3:7; };
struct D_I_BFu7i { double v1; int v2; unsigned int v3:7; };
struct D_I_BFu7ll { double v1; int v2; unsigned long long v3:7; };
struct D_I_BFu7s { double v1; int v2; unsigned short v3:7; };
struct D_I_BFu8c { double v1; int v2; unsigned char v3:8; };
struct D_I_BFu8i { double v1; int v2; unsigned int v3:8; };
struct D_I_BFu8ll { double v1; int v2; unsigned long long v3:8; };
struct D_I_BFu8s { double v1; int v2; unsigned short v3:8; };
struct D_I_BFu9i { double v1; int v2; unsigned int v3:9; };
struct D_I_BFu9ll { double v1; int v2; unsigned long long v3:9; };
struct D_I_BFu9s { double v1; int v2; unsigned short v3:9; };
struct D_I_C { double v1; int v2; char v3; };
struct D_I_D { double v1; int v2; double v3; };
struct D_I_F { double v1; int v2; float v3; };
struct D_I_I { double v1; int v2; int v3; };
struct D_I_Ip { double v1; int v2; int * v3; };
struct D_I_L { double v1; int v2; long long v3; };
struct D_I_S { double v1; int v2; short v3; };
struct D_I_Uc { double v1; int v2; unsigned char v3; };
struct D_I_Ui { double v1; int v2; unsigned int v3; };
struct D_I_Ul { double v1; int v2; unsigned long long v3; };
struct D_I_Us { double v1; int v2; unsigned short v3; };
struct D_I_Vp { double v1; int v2; void * v3; };
struct D_Ip { double v1; int * v2; };
struct D_Ip_BFu15i { double v1; int * v2; unsigned int v3:15; };
struct D_Ip_BFu15ll { double v1; int * v2; unsigned long long v3:15; };
struct D_Ip_BFu15s { double v1; int * v2; unsigned short v3:15; };
struct D_Ip_BFu16i { double v1; int * v2; unsigned int v3:16; };
struct D_Ip_BFu16ll { double v1; int * v2; unsigned long long v3:16; };
struct D_Ip_BFu16s { double v1; int * v2; unsigned short v3:16; };
struct D_Ip_BFu17i { double v1; int * v2; unsigned int v3:17; };
struct D_Ip_BFu17ll { double v1; int * v2; unsigned long long v3:17; };
struct D_Ip_BFu1c { double v1; int * v2; unsigned char v3:1; };
struct D_Ip_BFu1i { double v1; int * v2; unsigned int v3:1; };
struct D_Ip_BFu1ll { double v1; int * v2; unsigned long long v3:1; };
struct D_Ip_BFu1s { double v1; int * v2; unsigned short v3:1; };
struct D_Ip_BFu31i { double v1; int * v2; unsigned int v3:31; };
struct D_Ip_BFu31ll { double v1; int * v2; unsigned long long v3:31; };
struct D_Ip_BFu32i { double v1; int * v2; unsigned int v3:32; };
struct D_Ip_BFu32ll { double v1; int * v2; unsigned long long v3:32; };
struct D_Ip_BFu33 { double v1; int * v2; unsigned long long v3:33; };
struct D_Ip_BFu7c { double v1; int * v2; unsigned char v3:7; };
struct D_Ip_BFu7i { double v1; int * v2; unsigned int v3:7; };
struct D_Ip_BFu7ll { double v1; int * v2; unsigned long long v3:7; };
struct D_Ip_BFu7s { double v1; int * v2; unsigned short v3:7; };
struct D_Ip_BFu8c { double v1; int * v2; unsigned char v3:8; };
struct D_Ip_BFu8i { double v1; int * v2; unsigned int v3:8; };
struct D_Ip_BFu8ll { double v1; int * v2; unsigned long long v3:8; };
struct D_Ip_BFu8s { double v1; int * v2; unsigned short v3:8; };
struct D_Ip_BFu9i { double v1; int * v2; unsigned int v3:9; };
struct D_Ip_BFu9ll { double v1; int * v2; unsigned long long v3:9; };
struct D_Ip_BFu9s { double v1; int * v2; unsigned short v3:9; };
struct D_Ip_C { double v1; int * v2; char v3; };
struct D_Ip_D { double v1; int * v2; double v3; };
struct D_Ip_F { double v1; int * v2; float v3; };
struct D_Ip_I { double v1; int * v2; int v3; };
struct D_Ip_Ip { double v1; int * v2; int * v3; };
struct D_Ip_L { double v1; int * v2; long long v3; };
struct D_Ip_S { double v1; int * v2; short v3; };
struct D_Ip_Uc { double v1; int * v2; unsigned char v3; };
struct D_Ip_Ui { double v1; int * v2; unsigned int v3; };
struct D_Ip_Ul { double v1; int * v2; unsigned long long v3; };
struct D_Ip_Us { double v1; int * v2; unsigned short v3; };
struct D_Ip_Vp { double v1; int * v2; void * v3; };
struct D_L { double v1; long long v2; };
struct D_L_BFu15i { double v1; long long v2; unsigned int v3:15; };
struct D_L_BFu15ll { double v1; long long v2; unsigned long long v3:15; };
struct D_L_BFu15s { double v1; long long v2; unsigned short v3:15; };
struct D_L_BFu16i { double v1; long long v2; unsigned int v3:16; };
struct D_L_BFu16ll { double v1; long long v2; unsigned long long v3:16; };
struct D_L_BFu16s { double v1; long long v2; unsigned short v3:16; };
struct D_L_BFu17i { double v1; long long v2; unsigned int v3:17; };
struct D_L_BFu17ll { double v1; long long v2; unsigned long long v3:17; };
struct D_L_BFu1c { double v1; long long v2; unsigned char v3:1; };
struct D_L_BFu1i { double v1; long long v2; unsigned int v3:1; };
struct D_L_BFu1ll { double v1; long long v2; unsigned long long v3:1; };
struct D_L_BFu1s { double v1; long long v2; unsigned short v3:1; };
struct D_L_BFu31i { double v1; long long v2; unsigned int v3:31; };
struct D_L_BFu31ll { double v1; long long v2; unsigned long long v3:31; };
struct D_L_BFu32i { double v1; long long v2; unsigned int v3:32; };
struct D_L_BFu32ll { double v1; long long v2; unsigned long long v3:32; };
struct D_L_BFu33 { double v1; long long v2; unsigned long long v3:33; };
struct D_L_BFu7c { double v1; long long v2; unsigned char v3:7; };
struct D_L_BFu7i { double v1; long long v2; unsigned int v3:7; };
struct D_L_BFu7ll { double v1; long long v2; unsigned long long v3:7; };
struct D_L_BFu7s { double v1; long long v2; unsigned short v3:7; };
struct D_L_BFu8c { double v1; long long v2; unsigned char v3:8; };
struct D_L_BFu8i { double v1; long long v2; unsigned int v3:8; };
struct D_L_BFu8ll { double v1; long long v2; unsigned long long v3:8; };
struct D_L_BFu8s { double v1; long long v2; unsigned short v3:8; };
struct D_L_BFu9i { double v1; long long v2; unsigned int v3:9; };
struct D_L_BFu9ll { double v1; long long v2; unsigned long long v3:9; };
struct D_L_BFu9s { double v1; long long v2; unsigned short v3:9; };
struct D_L_C { double v1; long long v2; char v3; };
struct D_L_D { double v1; long long v2; double v3; };
struct D_L_F { double v1; long long v2; float v3; };
struct D_L_I { double v1; long long v2; int v3; };
struct D_L_Ip { double v1; long long v2; int * v3; };
struct D_L_L { double v1; long long v2; long long v3; };
struct D_L_S { double v1; long long v2; short v3; };
struct D_L_Uc { double v1; long long v2; unsigned char v3; };
struct D_L_Ui { double v1; long long v2; unsigned int v3; };
struct D_L_Ul { double v1; long long v2; unsigned long long v3; };
struct D_L_Us { double v1; long long v2; unsigned short v3; };
struct D_L_Vp { double v1; long long v2; void * v3; };
struct D_S { double v1; short v2; };
struct D_S_BFu15i { double v1; short v2; unsigned int v3:15; };
struct D_S_BFu15ll { double v1; short v2; unsigned long long v3:15; };
struct D_S_BFu15s { double v1; short v2; unsigned short v3:15; };
struct D_S_BFu16i { double v1; short v2; unsigned int v3:16; };
struct D_S_BFu16ll { double v1; short v2; unsigned long long v3:16; };
struct D_S_BFu16s { double v1; short v2; unsigned short v3:16; };
struct D_S_BFu17i { double v1; short v2; unsigned int v3:17; };
struct D_S_BFu17ll { double v1; short v2; unsigned long long v3:17; };
struct D_S_BFu1c { double v1; short v2; unsigned char v3:1; };
struct D_S_BFu1i { double v1; short v2; unsigned int v3:1; };
struct D_S_BFu1ll { double v1; short v2; unsigned long long v3:1; };
struct D_S_BFu1s { double v1; short v2; unsigned short v3:1; };
struct D_S_BFu31i { double v1; short v2; unsigned int v3:31; };
struct D_S_BFu31ll { double v1; short v2; unsigned long long v3:31; };
struct D_S_BFu32i { double v1; short v2; unsigned int v3:32; };
struct D_S_BFu32ll { double v1; short v2; unsigned long long v3:32; };
struct D_S_BFu33 { double v1; short v2; unsigned long long v3:33; };
struct D_S_BFu7c { double v1; short v2; unsigned char v3:7; };
struct D_S_BFu7i { double v1; short v2; unsigned int v3:7; };
struct D_S_BFu7ll { double v1; short v2; unsigned long long v3:7; };
struct D_S_BFu7s { double v1; short v2; unsigned short v3:7; };
struct D_S_BFu8c { double v1; short v2; unsigned char v3:8; };
struct D_S_BFu8i { double v1; short v2; unsigned int v3:8; };
struct D_S_BFu8ll { double v1; short v2; unsigned long long v3:8; };
struct D_S_BFu8s { double v1; short v2; unsigned short v3:8; };
struct D_S_BFu9i { double v1; short v2; unsigned int v3:9; };
struct D_S_BFu9ll { double v1; short v2; unsigned long long v3:9; };
struct D_S_BFu9s { double v1; short v2; unsigned short v3:9; };
struct D_S_C { double v1; short v2; char v3; };
struct D_S_D { double v1; short v2; double v3; };
struct D_S_F { double v1; short v2; float v3; };
struct D_S_I { double v1; short v2; int v3; };
struct D_S_Ip { double v1; short v2; int * v3; };
struct D_S_L { double v1; short v2; long long v3; };
struct D_S_S { double v1; short v2; short v3; };
struct D_S_Uc { double v1; short v2; unsigned char v3; };
struct D_S_Ui { double v1; short v2; unsigned int v3; };
struct D_S_Ul { double v1; short v2; unsigned long long v3; };
struct D_S_Us { double v1; short v2; unsigned short v3; };
struct D_S_Vp { double v1; short v2; void * v3; };
struct D_Uc { double v1; unsigned char v2; };
struct D_Uc_BFu15i { double v1; unsigned char v2; unsigned int v3:15; };
struct D_Uc_BFu15ll { double v1; unsigned char v2; unsigned long long v3:15; };
struct D_Uc_BFu15s { double v1; unsigned char v2; unsigned short v3:15; };
struct D_Uc_BFu16i { double v1; unsigned char v2; unsigned int v3:16; };
struct D_Uc_BFu16ll { double v1; unsigned char v2; unsigned long long v3:16; };
struct D_Uc_BFu16s { double v1; unsigned char v2; unsigned short v3:16; };
struct D_Uc_BFu17i { double v1; unsigned char v2; unsigned int v3:17; };
struct D_Uc_BFu17ll { double v1; unsigned char v2; unsigned long long v3:17; };
struct D_Uc_BFu1c { double v1; unsigned char v2; unsigned char v3:1; };
struct D_Uc_BFu1i { double v1; unsigned char v2; unsigned int v3:1; };
struct D_Uc_BFu1ll { double v1; unsigned char v2; unsigned long long v3:1; };
struct D_Uc_BFu1s { double v1; unsigned char v2; unsigned short v3:1; };
struct D_Uc_BFu31i { double v1; unsigned char v2; unsigned int v3:31; };
struct D_Uc_BFu31ll { double v1; unsigned char v2; unsigned long long v3:31; };
struct D_Uc_BFu32i { double v1; unsigned char v2; unsigned int v3:32; };
struct D_Uc_BFu32ll { double v1; unsigned char v2; unsigned long long v3:32; };
struct D_Uc_BFu33 { double v1; unsigned char v2; unsigned long long v3:33; };
struct D_Uc_BFu7c { double v1; unsigned char v2; unsigned char v3:7; };
struct D_Uc_BFu7i { double v1; unsigned char v2; unsigned int v3:7; };
struct D_Uc_BFu7ll { double v1; unsigned char v2; unsigned long long v3:7; };
struct D_Uc_BFu7s { double v1; unsigned char v2; unsigned short v3:7; };
struct D_Uc_BFu8c { double v1; unsigned char v2; unsigned char v3:8; };
struct D_Uc_BFu8i { double v1; unsigned char v2; unsigned int v3:8; };
struct D_Uc_BFu8ll { double v1; unsigned char v2; unsigned long long v3:8; };
struct D_Uc_BFu8s { double v1; unsigned char v2; unsigned short v3:8; };
struct D_Uc_BFu9i { double v1; unsigned char v2; unsigned int v3:9; };
struct D_Uc_BFu9ll { double v1; unsigned char v2; unsigned long long v3:9; };
struct D_Uc_BFu9s { double v1; unsigned char v2; unsigned short v3:9; };
struct D_Uc_C { double v1; unsigned char v2; char v3; };
struct D_Uc_D { double v1; unsigned char v2; double v3; };
struct D_Uc_F { double v1; unsigned char v2; float v3; };
struct D_Uc_I { double v1; unsigned char v2; int v3; };
struct D_Uc_Ip { double v1; unsigned char v2; int * v3; };
struct D_Uc_L { double v1; unsigned char v2; long long v3; };
struct D_Uc_S { double v1; unsigned char v2; short v3; };
struct D_Uc_Uc { double v1; unsigned char v2; unsigned char v3; };
struct D_Uc_Ui { double v1; unsigned char v2; unsigned int v3; };
struct D_Uc_Ul { double v1; unsigned char v2; unsigned long long v3; };
struct D_Uc_Us { double v1; unsigned char v2; unsigned short v3; };
struct D_Uc_Vp { double v1; unsigned char v2; void * v3; };
struct D_Ui { double v1; unsigned int v2; };
struct D_Ui_BFu15i { double v1; unsigned int v2; unsigned int v3:15; };
struct D_Ui_BFu15ll { double v1; unsigned int v2; unsigned long long v3:15; };
struct D_Ui_BFu15s { double v1; unsigned int v2; unsigned short v3:15; };
struct D_Ui_BFu16i { double v1; unsigned int v2; unsigned int v3:16; };
struct D_Ui_BFu16ll { double v1; unsigned int v2; unsigned long long v3:16; };
struct D_Ui_BFu16s { double v1; unsigned int v2; unsigned short v3:16; };
struct D_Ui_BFu17i { double v1; unsigned int v2; unsigned int v3:17; };
struct D_Ui_BFu17ll { double v1; unsigned int v2; unsigned long long v3:17; };
struct D_Ui_BFu1c { double v1; unsigned int v2; unsigned char v3:1; };
struct D_Ui_BFu1i { double v1; unsigned int v2; unsigned int v3:1; };
struct D_Ui_BFu1ll { double v1; unsigned int v2; unsigned long long v3:1; };
struct D_Ui_BFu1s { double v1; unsigned int v2; unsigned short v3:1; };
struct D_Ui_BFu31i { double v1; unsigned int v2; unsigned int v3:31; };
struct D_Ui_BFu31ll { double v1; unsigned int v2; unsigned long long v3:31; };
struct D_Ui_BFu32i { double v1; unsigned int v2; unsigned int v3:32; };
struct D_Ui_BFu32ll { double v1; unsigned int v2; unsigned long long v3:32; };
struct D_Ui_BFu33 { double v1; unsigned int v2; unsigned long long v3:33; };
struct D_Ui_BFu7c { double v1; unsigned int v2; unsigned char v3:7; };
struct D_Ui_BFu7i { double v1; unsigned int v2; unsigned int v3:7; };
struct D_Ui_BFu7ll { double v1; unsigned int v2; unsigned long long v3:7; };
struct D_Ui_BFu7s { double v1; unsigned int v2; unsigned short v3:7; };
struct D_Ui_BFu8c { double v1; unsigned int v2; unsigned char v3:8; };
struct D_Ui_BFu8i { double v1; unsigned int v2; unsigned int v3:8; };
struct D_Ui_BFu8ll { double v1; unsigned int v2; unsigned long long v3:8; };
struct D_Ui_BFu8s { double v1; unsigned int v2; unsigned short v3:8; };
struct D_Ui_BFu9i { double v1; unsigned int v2; unsigned int v3:9; };
struct D_Ui_BFu9ll { double v1; unsigned int v2; unsigned long long v3:9; };
struct D_Ui_BFu9s { double v1; unsigned int v2; unsigned short v3:9; };
struct D_Ui_C { double v1; unsigned int v2; char v3; };
struct D_Ui_D { double v1; unsigned int v2; double v3; };
struct D_Ui_F { double v1; unsigned int v2; float v3; };
struct D_Ui_I { double v1; unsigned int v2; int v3; };
struct D_Ui_Ip { double v1; unsigned int v2; int * v3; };
struct D_Ui_L { double v1; unsigned int v2; long long v3; };
struct D_Ui_S { double v1; unsigned int v2; short v3; };
struct D_Ui_Uc { double v1; unsigned int v2; unsigned char v3; };
struct D_Ui_Ui { double v1; unsigned int v2; unsigned int v3; };
struct D_Ui_Ul { double v1; unsigned int v2; unsigned long long v3; };
struct D_Ui_Us { double v1; unsigned int v2; unsigned short v3; };
struct D_Ui_Vp { double v1; unsigned int v2; void * v3; };
struct D_Ul { double v1; unsigned long long v2; };
struct D_Ul_BFu15i { double v1; unsigned long long v2; unsigned int v3:15; };
struct D_Ul_BFu15ll { double v1; unsigned long long v2; unsigned long long v3:15; };
struct D_Ul_BFu15s { double v1; unsigned long long v2; unsigned short v3:15; };
struct D_Ul_BFu16i { double v1; unsigned long long v2; unsigned int v3:16; };
struct D_Ul_BFu16ll { double v1; unsigned long long v2; unsigned long long v3:16; };
struct D_Ul_BFu16s { double v1; unsigned long long v2; unsigned short v3:16; };
struct D_Ul_BFu17i { double v1; unsigned long long v2; unsigned int v3:17; };
struct D_Ul_BFu17ll { double v1; unsigned long long v2; unsigned long long v3:17; };
struct D_Ul_BFu1c { double v1; unsigned long long v2; unsigned char v3:1; };
struct D_Ul_BFu1i { double v1; unsigned long long v2; unsigned int v3:1; };
struct D_Ul_BFu1ll { double v1; unsigned long long v2; unsigned long long v3:1; };
struct D_Ul_BFu1s { double v1; unsigned long long v2; unsigned short v3:1; };
struct D_Ul_BFu31i { double v1; unsigned long long v2; unsigned int v3:31; };
struct D_Ul_BFu31ll { double v1; unsigned long long v2; unsigned long long v3:31; };
struct D_Ul_BFu32i { double v1; unsigned long long v2; unsigned int v3:32; };
struct D_Ul_BFu32ll { double v1; unsigned long long v2; unsigned long long v3:32; };
struct D_Ul_BFu33 { double v1; unsigned long long v2; unsigned long long v3:33; };
struct D_Ul_BFu7c { double v1; unsigned long long v2; unsigned char v3:7; };
struct D_Ul_BFu7i { double v1; unsigned long long v2; unsigned int v3:7; };
struct D_Ul_BFu7ll { double v1; unsigned long long v2; unsigned long long v3:7; };
struct D_Ul_BFu7s { double v1; unsigned long long v2; unsigned short v3:7; };
struct D_Ul_BFu8c { double v1; unsigned long long v2; unsigned char v3:8; };
struct D_Ul_BFu8i { double v1; unsigned long long v2; unsigned int v3:8; };
struct D_Ul_BFu8ll { double v1; unsigned long long v2; unsigned long long v3:8; };
struct D_Ul_BFu8s { double v1; unsigned long long v2; unsigned short v3:8; };
struct D_Ul_BFu9i { double v1; unsigned long long v2; unsigned int v3:9; };
struct D_Ul_BFu9ll { double v1; unsigned long long v2; unsigned long long v3:9; };
struct D_Ul_BFu9s { double v1; unsigned long long v2; unsigned short v3:9; };
struct D_Ul_C { double v1; unsigned long long v2; char v3; };
struct D_Ul_D { double v1; unsigned long long v2; double v3; };
struct D_Ul_F { double v1; unsigned long long v2; float v3; };
struct D_Ul_I { double v1; unsigned long long v2; int v3; };
struct D_Ul_Ip { double v1; unsigned long long v2; int * v3; };
struct D_Ul_L { double v1; unsigned long long v2; long long v3; };
struct D_Ul_S { double v1; unsigned long long v2; short v3; };
struct D_Ul_Uc { double v1; unsigned long long v2; unsigned char v3; };
struct D_Ul_Ui { double v1; unsigned long long v2; unsigned int v3; };
struct D_Ul_Ul { double v1; unsigned long long v2; unsigned long long v3; };
struct D_Ul_Us { double v1; unsigned long long v2; unsigned short v3; };
struct D_Ul_Vp { double v1; unsigned long long v2; void * v3; };
struct D_Us { double v1; unsigned short v2; };
struct D_Us_BFu15i { double v1; unsigned short v2; unsigned int v3:15; };
struct D_Us_BFu15ll { double v1; unsigned short v2; unsigned long long v3:15; };
struct D_Us_BFu15s { double v1; unsigned short v2; unsigned short v3:15; };
struct D_Us_BFu16i { double v1; unsigned short v2; unsigned int v3:16; };
struct D_Us_BFu16ll { double v1; unsigned short v2; unsigned long long v3:16; };
struct D_Us_BFu16s { double v1; unsigned short v2; unsigned short v3:16; };
struct D_Us_BFu17i { double v1; unsigned short v2; unsigned int v3:17; };
struct D_Us_BFu17ll { double v1; unsigned short v2; unsigned long long v3:17; };
struct D_Us_BFu1c { double v1; unsigned short v2; unsigned char v3:1; };
struct D_Us_BFu1i { double v1; unsigned short v2; unsigned int v3:1; };
struct D_Us_BFu1ll { double v1; unsigned short v2; unsigned long long v3:1; };
struct D_Us_BFu1s { double v1; unsigned short v2; unsigned short v3:1; };
struct D_Us_BFu31i { double v1; unsigned short v2; unsigned int v3:31; };
struct D_Us_BFu31ll { double v1; unsigned short v2; unsigned long long v3:31; };
struct D_Us_BFu32i { double v1; unsigned short v2; unsigned int v3:32; };
struct D_Us_BFu32ll { double v1; unsigned short v2; unsigned long long v3:32; };
struct D_Us_BFu33 { double v1; unsigned short v2; unsigned long long v3:33; };
struct D_Us_BFu7c { double v1; unsigned short v2; unsigned char v3:7; };
struct D_Us_BFu7i { double v1; unsigned short v2; unsigned int v3:7; };
struct D_Us_BFu7ll { double v1; unsigned short v2; unsigned long long v3:7; };
struct D_Us_BFu7s { double v1; unsigned short v2; unsigned short v3:7; };
struct D_Us_BFu8c { double v1; unsigned short v2; unsigned char v3:8; };
struct D_Us_BFu8i { double v1; unsigned short v2; unsigned int v3:8; };
struct D_Us_BFu8ll { double v1; unsigned short v2; unsigned long long v3:8; };
struct D_Us_BFu8s { double v1; unsigned short v2; unsigned short v3:8; };
struct D_Us_BFu9i { double v1; unsigned short v2; unsigned int v3:9; };
struct D_Us_BFu9ll { double v1; unsigned short v2; unsigned long long v3:9; };
struct D_Us_BFu9s { double v1; unsigned short v2; unsigned short v3:9; };
struct D_Us_C { double v1; unsigned short v2; char v3; };
struct D_Us_D { double v1; unsigned short v2; double v3; };
struct D_Us_F { double v1; unsigned short v2; float v3; };
struct D_Us_I { double v1; unsigned short v2; int v3; };
struct D_Us_Ip { double v1; unsigned short v2; int * v3; };
struct D_Us_L { double v1; unsigned short v2; long long v3; };
struct D_Us_S { double v1; unsigned short v2; short v3; };
struct D_Us_Uc { double v1; unsigned short v2; unsigned char v3; };
struct D_Us_Ui { double v1; unsigned short v2; unsigned int v3; };
struct D_Us_Ul { double v1; unsigned short v2; unsigned long long v3; };
struct D_Us_Us { double v1; unsigned short v2; unsigned short v3; };
struct D_Us_Vp { double v1; unsigned short v2; void * v3; };
struct D_Vp { double v1; void * v2; };
struct D_Vp_BFu15i { double v1; void * v2; unsigned int v3:15; };
struct D_Vp_BFu15ll { double v1; void * v2; unsigned long long v3:15; };
struct D_Vp_BFu15s { double v1; void * v2; unsigned short v3:15; };
struct D_Vp_BFu16i { double v1; void * v2; unsigned int v3:16; };
struct D_Vp_BFu16ll { double v1; void * v2; unsigned long long v3:16; };
struct D_Vp_BFu16s { double v1; void * v2; unsigned short v3:16; };
struct D_Vp_BFu17i { double v1; void * v2; unsigned int v3:17; };
struct D_Vp_BFu17ll { double v1; void * v2; unsigned long long v3:17; };
struct D_Vp_BFu1c { double v1; void * v2; unsigned char v3:1; };
struct D_Vp_BFu1i { double v1; void * v2; unsigned int v3:1; };
struct D_Vp_BFu1ll { double v1; void * v2; unsigned long long v3:1; };
struct D_Vp_BFu1s { double v1; void * v2; unsigned short v3:1; };
struct D_Vp_BFu31i { double v1; void * v2; unsigned int v3:31; };
struct D_Vp_BFu31ll { double v1; void * v2; unsigned long long v3:31; };
struct D_Vp_BFu32i { double v1; void * v2; unsigned int v3:32; };
struct D_Vp_BFu32ll { double v1; void * v2; unsigned long long v3:32; };
struct D_Vp_BFu33 { double v1; void * v2; unsigned long long v3:33; };
struct D_Vp_BFu7c { double v1; void * v2; unsigned char v3:7; };
struct D_Vp_BFu7i { double v1; void * v2; unsigned int v3:7; };
struct D_Vp_BFu7ll { double v1; void * v2; unsigned long long v3:7; };
struct D_Vp_BFu7s { double v1; void * v2; unsigned short v3:7; };
struct D_Vp_BFu8c { double v1; void * v2; unsigned char v3:8; };
struct D_Vp_BFu8i { double v1; void * v2; unsigned int v3:8; };
struct D_Vp_BFu8ll { double v1; void * v2; unsigned long long v3:8; };
struct D_Vp_BFu8s { double v1; void * v2; unsigned short v3:8; };
struct D_Vp_BFu9i { double v1; void * v2; unsigned int v3:9; };
struct D_Vp_BFu9ll { double v1; void * v2; unsigned long long v3:9; };
struct D_Vp_BFu9s { double v1; void * v2; unsigned short v3:9; };
struct D_Vp_C { double v1; void * v2; char v3; };
struct D_Vp_D { double v1; void * v2; double v3; };
struct D_Vp_F { double v1; void * v2; float v3; };
struct D_Vp_I { double v1; void * v2; int v3; };
struct D_Vp_Ip { double v1; void * v2; int * v3; };
struct D_Vp_L { double v1; void * v2; long long v3; };
struct D_Vp_S { double v1; void * v2; short v3; };
struct D_Vp_Uc { double v1; void * v2; unsigned char v3; };
struct D_Vp_Ui { double v1; void * v2; unsigned int v3; };
struct D_Vp_Ul { double v1; void * v2; unsigned long long v3; };
struct D_Vp_Us { double v1; void * v2; unsigned short v3; };
struct D_Vp_Vp { double v1; void * v2; void * v3; };
struct F { float v1; };
struct F_BFu15i { float v1; unsigned int v2:15; };
struct F_BFu15i_BFu15i { float v1; unsigned int v2:15; unsigned int v3:15; };
struct F_BFu15i_BFu15ll { float v1; unsigned int v2:15; unsigned long long v3:15; };
struct F_BFu15i_BFu15s { float v1; unsigned int v2:15; unsigned short v3:15; };
struct F_BFu15i_BFu16i { float v1; unsigned int v2:15; unsigned int v3:16; };
struct F_BFu15i_BFu16ll { float v1; unsigned int v2:15; unsigned long long v3:16; };
struct F_BFu15i_BFu16s { float v1; unsigned int v2:15; unsigned short v3:16; };
struct F_BFu15i_BFu17i { float v1; unsigned int v2:15; unsigned int v3:17; };
struct F_BFu15i_BFu17ll { float v1; unsigned int v2:15; unsigned long long v3:17; };
struct F_BFu15i_BFu1c { float v1; unsigned int v2:15; unsigned char v3:1; };
struct F_BFu15i_BFu1i { float v1; unsigned int v2:15; unsigned int v3:1; };
struct F_BFu15i_BFu1ll { float v1; unsigned int v2:15; unsigned long long v3:1; };
struct F_BFu15i_BFu1s { float v1; unsigned int v2:15; unsigned short v3:1; };
struct F_BFu15i_BFu31i { float v1; unsigned int v2:15; unsigned int v3:31; };
struct F_BFu15i_BFu31ll { float v1; unsigned int v2:15; unsigned long long v3:31; };
struct F_BFu15i_BFu32i { float v1; unsigned int v2:15; unsigned int v3:32; };
struct F_BFu15i_BFu32ll { float v1; unsigned int v2:15; unsigned long long v3:32; };
struct F_BFu15i_BFu33 { float v1; unsigned int v2:15; unsigned long long v3:33; };
struct F_BFu15i_BFu7c { float v1; unsigned int v2:15; unsigned char v3:7; };
struct F_BFu15i_BFu7i { float v1; unsigned int v2:15; unsigned int v3:7; };
struct F_BFu15i_BFu7ll { float v1; unsigned int v2:15; unsigned long long v3:7; };
struct F_BFu15i_BFu7s { float v1; unsigned int v2:15; unsigned short v3:7; };
struct F_BFu15i_BFu8c { float v1; unsigned int v2:15; unsigned char v3:8; };
struct F_BFu15i_BFu8i { float v1; unsigned int v2:15; unsigned int v3:8; };
struct F_BFu15i_BFu8ll { float v1; unsigned int v2:15; unsigned long long v3:8; };
struct F_BFu15i_BFu8s { float v1; unsigned int v2:15; unsigned short v3:8; };
struct F_BFu15i_BFu9i { float v1; unsigned int v2:15; unsigned int v3:9; };
struct F_BFu15i_BFu9ll { float v1; unsigned int v2:15; unsigned long long v3:9; };
struct F_BFu15i_BFu9s { float v1; unsigned int v2:15; unsigned short v3:9; };
struct F_BFu15i_C { float v1; unsigned int v2:15; char v3; };
struct F_BFu15i_D { float v1; unsigned int v2:15; double v3; };
struct F_BFu15i_F { float v1; unsigned int v2:15; float v3; };
struct F_BFu15i_I { float v1; unsigned int v2:15; int v3; };
struct F_BFu15i_Ip { float v1; unsigned int v2:15; int * v3; };
struct F_BFu15i_L { float v1; unsigned int v2:15; long long v3; };
struct F_BFu15i_S { float v1; unsigned int v2:15; short v3; };
struct F_BFu15i_Uc { float v1; unsigned int v2:15; unsigned char v3; };
struct F_BFu15i_Ui { float v1; unsigned int v2:15; unsigned int v3; };
struct F_BFu15i_Ul { float v1; unsigned int v2:15; unsigned long long v3; };
struct F_BFu15i_Us { float v1; unsigned int v2:15; unsigned short v3; };
struct F_BFu15i_Vp { float v1; unsigned int v2:15; void * v3; };
struct F_BFu15ll { float v1; unsigned long long v2:15; };
struct F_BFu15ll_BFu15i { float v1; unsigned long long v2:15; unsigned int v3:15; };
struct F_BFu15ll_BFu15ll { float v1; unsigned long long v2:15; unsigned long long v3:15; };
struct F_BFu15ll_BFu15s { float v1; unsigned long long v2:15; unsigned short v3:15; };
struct F_BFu15ll_BFu16i { float v1; unsigned long long v2:15; unsigned int v3:16; };
struct F_BFu15ll_BFu16ll { float v1; unsigned long long v2:15; unsigned long long v3:16; };
struct F_BFu15ll_BFu16s { float v1; unsigned long long v2:15; unsigned short v3:16; };
struct F_BFu15ll_BFu17i { float v1; unsigned long long v2:15; unsigned int v3:17; };
struct F_BFu15ll_BFu17ll { float v1; unsigned long long v2:15; unsigned long long v3:17; };
struct F_BFu15ll_BFu1c { float v1; unsigned long long v2:15; unsigned char v3:1; };
struct F_BFu15ll_BFu1i { float v1; unsigned long long v2:15; unsigned int v3:1; };
struct F_BFu15ll_BFu1ll { float v1; unsigned long long v2:15; unsigned long long v3:1; };
struct F_BFu15ll_BFu1s { float v1; unsigned long long v2:15; unsigned short v3:1; };
struct F_BFu15ll_BFu31i { float v1; unsigned long long v2:15; unsigned int v3:31; };
struct F_BFu15ll_BFu31ll { float v1; unsigned long long v2:15; unsigned long long v3:31; };
struct F_BFu15ll_BFu32i { float v1; unsigned long long v2:15; unsigned int v3:32; };
struct F_BFu15ll_BFu32ll { float v1; unsigned long long v2:15; unsigned long long v3:32; };
struct F_BFu15ll_BFu33 { float v1; unsigned long long v2:15; unsigned long long v3:33; };
struct F_BFu15ll_BFu7c { float v1; unsigned long long v2:15; unsigned char v3:7; };
struct F_BFu15ll_BFu7i { float v1; unsigned long long v2:15; unsigned int v3:7; };
struct F_BFu15ll_BFu7ll { float v1; unsigned long long v2:15; unsigned long long v3:7; };
struct F_BFu15ll_BFu7s { float v1; unsigned long long v2:15; unsigned short v3:7; };
struct F_BFu15ll_BFu8c { float v1; unsigned long long v2:15; unsigned char v3:8; };
struct F_BFu15ll_BFu8i { float v1; unsigned long long v2:15; unsigned int v3:8; };
struct F_BFu15ll_BFu8ll { float v1; unsigned long long v2:15; unsigned long long v3:8; };
struct F_BFu15ll_BFu8s { float v1; unsigned long long v2:15; unsigned short v3:8; };
struct F_BFu15ll_BFu9i { float v1; unsigned long long v2:15; unsigned int v3:9; };
struct F_BFu15ll_BFu9ll { float v1; unsigned long long v2:15; unsigned long long v3:9; };
struct F_BFu15ll_BFu9s { float v1; unsigned long long v2:15; unsigned short v3:9; };
struct F_BFu15ll_C { float v1; unsigned long long v2:15; char v3; };
struct F_BFu15ll_D { float v1; unsigned long long v2:15; double v3; };
struct F_BFu15ll_F { float v1; unsigned long long v2:15; float v3; };
struct F_BFu15ll_I { float v1; unsigned long long v2:15; int v3; };
struct F_BFu15ll_Ip { float v1; unsigned long long v2:15; int * v3; };
struct F_BFu15ll_L { float v1; unsigned long long v2:15; long long v3; };
struct F_BFu15ll_S { float v1; unsigned long long v2:15; short v3; };
struct F_BFu15ll_Uc { float v1; unsigned long long v2:15; unsigned char v3; };
struct F_BFu15ll_Ui { float v1; unsigned long long v2:15; unsigned int v3; };
struct F_BFu15ll_Ul { float v1; unsigned long long v2:15; unsigned long long v3; };
struct F_BFu15ll_Us { float v1; unsigned long long v2:15; unsigned short v3; };
struct F_BFu15ll_Vp { float v1; unsigned long long v2:15; void * v3; };
struct F_BFu15s { float v1; unsigned short v2:15; };
struct F_BFu15s_BFu15i { float v1; unsigned short v2:15; unsigned int v3:15; };
struct F_BFu15s_BFu15ll { float v1; unsigned short v2:15; unsigned long long v3:15; };
struct F_BFu15s_BFu15s { float v1; unsigned short v2:15; unsigned short v3:15; };
struct F_BFu15s_BFu16i { float v1; unsigned short v2:15; unsigned int v3:16; };
struct F_BFu15s_BFu16ll { float v1; unsigned short v2:15; unsigned long long v3:16; };
struct F_BFu15s_BFu16s { float v1; unsigned short v2:15; unsigned short v3:16; };
struct F_BFu15s_BFu17i { float v1; unsigned short v2:15; unsigned int v3:17; };
struct F_BFu15s_BFu17ll { float v1; unsigned short v2:15; unsigned long long v3:17; };
struct F_BFu15s_BFu1c { float v1; unsigned short v2:15; unsigned char v3:1; };
struct F_BFu15s_BFu1i { float v1; unsigned short v2:15; unsigned int v3:1; };
struct F_BFu15s_BFu1ll { float v1; unsigned short v2:15; unsigned long long v3:1; };
struct F_BFu15s_BFu1s { float v1; unsigned short v2:15; unsigned short v3:1; };
struct F_BFu15s_BFu31i { float v1; unsigned short v2:15; unsigned int v3:31; };
struct F_BFu15s_BFu31ll { float v1; unsigned short v2:15; unsigned long long v3:31; };
struct F_BFu15s_BFu32i { float v1; unsigned short v2:15; unsigned int v3:32; };
struct F_BFu15s_BFu32ll { float v1; unsigned short v2:15; unsigned long long v3:32; };
struct F_BFu15s_BFu33 { float v1; unsigned short v2:15; unsigned long long v3:33; };
struct F_BFu15s_BFu7c { float v1; unsigned short v2:15; unsigned char v3:7; };
struct F_BFu15s_BFu7i { float v1; unsigned short v2:15; unsigned int v3:7; };
struct F_BFu15s_BFu7ll { float v1; unsigned short v2:15; unsigned long long v3:7; };
struct F_BFu15s_BFu7s { float v1; unsigned short v2:15; unsigned short v3:7; };
struct F_BFu15s_BFu8c { float v1; unsigned short v2:15; unsigned char v3:8; };
struct F_BFu15s_BFu8i { float v1; unsigned short v2:15; unsigned int v3:8; };
struct F_BFu15s_BFu8ll { float v1; unsigned short v2:15; unsigned long long v3:8; };
struct F_BFu15s_BFu8s { float v1; unsigned short v2:15; unsigned short v3:8; };
struct F_BFu15s_BFu9i { float v1; unsigned short v2:15; unsigned int v3:9; };
struct F_BFu15s_BFu9ll { float v1; unsigned short v2:15; unsigned long long v3:9; };
struct F_BFu15s_BFu9s { float v1; unsigned short v2:15; unsigned short v3:9; };
struct F_BFu15s_C { float v1; unsigned short v2:15; char v3; };
struct F_BFu15s_D { float v1; unsigned short v2:15; double v3; };
struct F_BFu15s_F { float v1; unsigned short v2:15; float v3; };
struct F_BFu15s_I { float v1; unsigned short v2:15; int v3; };
struct F_BFu15s_Ip { float v1; unsigned short v2:15; int * v3; };
struct F_BFu15s_L { float v1; unsigned short v2:15; long long v3; };
struct F_BFu15s_S { float v1; unsigned short v2:15; short v3; };
struct F_BFu15s_Uc { float v1; unsigned short v2:15; unsigned char v3; };
struct F_BFu15s_Ui { float v1; unsigned short v2:15; unsigned int v3; };
struct F_BFu15s_Ul { float v1; unsigned short v2:15; unsigned long long v3; };
struct F_BFu15s_Us { float v1; unsigned short v2:15; unsigned short v3; };
struct F_BFu15s_Vp { float v1; unsigned short v2:15; void * v3; };
struct F_BFu16i { float v1; unsigned int v2:16; };
struct F_BFu16i_BFu15i { float v1; unsigned int v2:16; unsigned int v3:15; };
struct F_BFu16i_BFu15ll { float v1; unsigned int v2:16; unsigned long long v3:15; };
struct F_BFu16i_BFu15s { float v1; unsigned int v2:16; unsigned short v3:15; };
struct F_BFu16i_BFu16i { float v1; unsigned int v2:16; unsigned int v3:16; };
struct F_BFu16i_BFu16ll { float v1; unsigned int v2:16; unsigned long long v3:16; };
struct F_BFu16i_BFu16s { float v1; unsigned int v2:16; unsigned short v3:16; };
struct F_BFu16i_BFu17i { float v1; unsigned int v2:16; unsigned int v3:17; };
struct F_BFu16i_BFu17ll { float v1; unsigned int v2:16; unsigned long long v3:17; };
struct F_BFu16i_BFu1c { float v1; unsigned int v2:16; unsigned char v3:1; };
struct F_BFu16i_BFu1i { float v1; unsigned int v2:16; unsigned int v3:1; };
struct F_BFu16i_BFu1ll { float v1; unsigned int v2:16; unsigned long long v3:1; };
struct F_BFu16i_BFu1s { float v1; unsigned int v2:16; unsigned short v3:1; };
struct F_BFu16i_BFu31i { float v1; unsigned int v2:16; unsigned int v3:31; };
struct F_BFu16i_BFu31ll { float v1; unsigned int v2:16; unsigned long long v3:31; };
struct F_BFu16i_BFu32i { float v1; unsigned int v2:16; unsigned int v3:32; };
struct F_BFu16i_BFu32ll { float v1; unsigned int v2:16; unsigned long long v3:32; };
struct F_BFu16i_BFu33 { float v1; unsigned int v2:16; unsigned long long v3:33; };
struct F_BFu16i_BFu7c { float v1; unsigned int v2:16; unsigned char v3:7; };
struct F_BFu16i_BFu7i { float v1; unsigned int v2:16; unsigned int v3:7; };
struct F_BFu16i_BFu7ll { float v1; unsigned int v2:16; unsigned long long v3:7; };
struct F_BFu16i_BFu7s { float v1; unsigned int v2:16; unsigned short v3:7; };
struct F_BFu16i_BFu8c { float v1; unsigned int v2:16; unsigned char v3:8; };
struct F_BFu16i_BFu8i { float v1; unsigned int v2:16; unsigned int v3:8; };
struct F_BFu16i_BFu8ll { float v1; unsigned int v2:16; unsigned long long v3:8; };
struct F_BFu16i_BFu8s { float v1; unsigned int v2:16; unsigned short v3:8; };
struct F_BFu16i_BFu9i { float v1; unsigned int v2:16; unsigned int v3:9; };
struct F_BFu16i_BFu9ll { float v1; unsigned int v2:16; unsigned long long v3:9; };
struct F_BFu16i_BFu9s { float v1; unsigned int v2:16; unsigned short v3:9; };
struct F_BFu16i_C { float v1; unsigned int v2:16; char v3; };
struct F_BFu16i_D { float v1; unsigned int v2:16; double v3; };
struct F_BFu16i_F { float v1; unsigned int v2:16; float v3; };
struct F_BFu16i_I { float v1; unsigned int v2:16; int v3; };
struct F_BFu16i_Ip { float v1; unsigned int v2:16; int * v3; };
struct F_BFu16i_L { float v1; unsigned int v2:16; long long v3; };
struct F_BFu16i_S { float v1; unsigned int v2:16; short v3; };
struct F_BFu16i_Uc { float v1; unsigned int v2:16; unsigned char v3; };
struct F_BFu16i_Ui { float v1; unsigned int v2:16; unsigned int v3; };
struct F_BFu16i_Ul { float v1; unsigned int v2:16; unsigned long long v3; };
struct F_BFu16i_Us { float v1; unsigned int v2:16; unsigned short v3; };
struct F_BFu16i_Vp { float v1; unsigned int v2:16; void * v3; };
struct F_BFu16ll { float v1; unsigned long long v2:16; };
struct F_BFu16ll_BFu15i { float v1; unsigned long long v2:16; unsigned int v3:15; };
struct F_BFu16ll_BFu15ll { float v1; unsigned long long v2:16; unsigned long long v3:15; };
struct F_BFu16ll_BFu15s { float v1; unsigned long long v2:16; unsigned short v3:15; };
struct F_BFu16ll_BFu16i { float v1; unsigned long long v2:16; unsigned int v3:16; };
struct F_BFu16ll_BFu16ll { float v1; unsigned long long v2:16; unsigned long long v3:16; };
struct F_BFu16ll_BFu16s { float v1; unsigned long long v2:16; unsigned short v3:16; };
struct F_BFu16ll_BFu17i { float v1; unsigned long long v2:16; unsigned int v3:17; };
struct F_BFu16ll_BFu17ll { float v1; unsigned long long v2:16; unsigned long long v3:17; };
struct F_BFu16ll_BFu1c { float v1; unsigned long long v2:16; unsigned char v3:1; };
struct F_BFu16ll_BFu1i { float v1; unsigned long long v2:16; unsigned int v3:1; };
struct F_BFu16ll_BFu1ll { float v1; unsigned long long v2:16; unsigned long long v3:1; };
struct F_BFu16ll_BFu1s { float v1; unsigned long long v2:16; unsigned short v3:1; };
struct F_BFu16ll_BFu31i { float v1; unsigned long long v2:16; unsigned int v3:31; };
struct F_BFu16ll_BFu31ll { float v1; unsigned long long v2:16; unsigned long long v3:31; };
struct F_BFu16ll_BFu32i { float v1; unsigned long long v2:16; unsigned int v3:32; };
struct F_BFu16ll_BFu32ll { float v1; unsigned long long v2:16; unsigned long long v3:32; };
struct F_BFu16ll_BFu33 { float v1; unsigned long long v2:16; unsigned long long v3:33; };
struct F_BFu16ll_BFu7c { float v1; unsigned long long v2:16; unsigned char v3:7; };
struct F_BFu16ll_BFu7i { float v1; unsigned long long v2:16; unsigned int v3:7; };
struct F_BFu16ll_BFu7ll { float v1; unsigned long long v2:16; unsigned long long v3:7; };
struct F_BFu16ll_BFu7s { float v1; unsigned long long v2:16; unsigned short v3:7; };
struct F_BFu16ll_BFu8c { float v1; unsigned long long v2:16; unsigned char v3:8; };
struct F_BFu16ll_BFu8i { float v1; unsigned long long v2:16; unsigned int v3:8; };
struct F_BFu16ll_BFu8ll { float v1; unsigned long long v2:16; unsigned long long v3:8; };
struct F_BFu16ll_BFu8s { float v1; unsigned long long v2:16; unsigned short v3:8; };
struct F_BFu16ll_BFu9i { float v1; unsigned long long v2:16; unsigned int v3:9; };
struct F_BFu16ll_BFu9ll { float v1; unsigned long long v2:16; unsigned long long v3:9; };
struct F_BFu16ll_BFu9s { float v1; unsigned long long v2:16; unsigned short v3:9; };
struct F_BFu16ll_C { float v1; unsigned long long v2:16; char v3; };
struct F_BFu16ll_D { float v1; unsigned long long v2:16; double v3; };
struct F_BFu16ll_F { float v1; unsigned long long v2:16; float v3; };
struct F_BFu16ll_I { float v1; unsigned long long v2:16; int v3; };
struct F_BFu16ll_Ip { float v1; unsigned long long v2:16; int * v3; };
struct F_BFu16ll_L { float v1; unsigned long long v2:16; long long v3; };
struct F_BFu16ll_S { float v1; unsigned long long v2:16; short v3; };
struct F_BFu16ll_Uc { float v1; unsigned long long v2:16; unsigned char v3; };
struct F_BFu16ll_Ui { float v1; unsigned long long v2:16; unsigned int v3; };
struct F_BFu16ll_Ul { float v1; unsigned long long v2:16; unsigned long long v3; };
struct F_BFu16ll_Us { float v1; unsigned long long v2:16; unsigned short v3; };
struct F_BFu16ll_Vp { float v1; unsigned long long v2:16; void * v3; };
struct F_BFu16s { float v1; unsigned short v2:16; };
struct F_BFu16s_BFu15i { float v1; unsigned short v2:16; unsigned int v3:15; };
struct F_BFu16s_BFu15ll { float v1; unsigned short v2:16; unsigned long long v3:15; };
struct F_BFu16s_BFu15s { float v1; unsigned short v2:16; unsigned short v3:15; };
struct F_BFu16s_BFu16i { float v1; unsigned short v2:16; unsigned int v3:16; };
struct F_BFu16s_BFu16ll { float v1; unsigned short v2:16; unsigned long long v3:16; };
struct F_BFu16s_BFu16s { float v1; unsigned short v2:16; unsigned short v3:16; };
struct F_BFu16s_BFu17i { float v1; unsigned short v2:16; unsigned int v3:17; };
struct F_BFu16s_BFu17ll { float v1; unsigned short v2:16; unsigned long long v3:17; };
struct F_BFu16s_BFu1c { float v1; unsigned short v2:16; unsigned char v3:1; };
struct F_BFu16s_BFu1i { float v1; unsigned short v2:16; unsigned int v3:1; };
struct F_BFu16s_BFu1ll { float v1; unsigned short v2:16; unsigned long long v3:1; };
struct F_BFu16s_BFu1s { float v1; unsigned short v2:16; unsigned short v3:1; };
struct F_BFu16s_BFu31i { float v1; unsigned short v2:16; unsigned int v3:31; };
struct F_BFu16s_BFu31ll { float v1; unsigned short v2:16; unsigned long long v3:31; };
struct F_BFu16s_BFu32i { float v1; unsigned short v2:16; unsigned int v3:32; };
struct F_BFu16s_BFu32ll { float v1; unsigned short v2:16; unsigned long long v3:32; };
struct F_BFu16s_BFu33 { float v1; unsigned short v2:16; unsigned long long v3:33; };
struct F_BFu16s_BFu7c { float v1; unsigned short v2:16; unsigned char v3:7; };
struct F_BFu16s_BFu7i { float v1; unsigned short v2:16; unsigned int v3:7; };
struct F_BFu16s_BFu7ll { float v1; unsigned short v2:16; unsigned long long v3:7; };
struct F_BFu16s_BFu7s { float v1; unsigned short v2:16; unsigned short v3:7; };
struct F_BFu16s_BFu8c { float v1; unsigned short v2:16; unsigned char v3:8; };
struct F_BFu16s_BFu8i { float v1; unsigned short v2:16; unsigned int v3:8; };
struct F_BFu16s_BFu8ll { float v1; unsigned short v2:16; unsigned long long v3:8; };
struct F_BFu16s_BFu8s { float v1; unsigned short v2:16; unsigned short v3:8; };
struct F_BFu16s_BFu9i { float v1; unsigned short v2:16; unsigned int v3:9; };
struct F_BFu16s_BFu9ll { float v1; unsigned short v2:16; unsigned long long v3:9; };
struct F_BFu16s_BFu9s { float v1; unsigned short v2:16; unsigned short v3:9; };
struct F_BFu16s_C { float v1; unsigned short v2:16; char v3; };
struct F_BFu16s_D { float v1; unsigned short v2:16; double v3; };
struct F_BFu16s_F { float v1; unsigned short v2:16; float v3; };
struct F_BFu16s_I { float v1; unsigned short v2:16; int v3; };
struct F_BFu16s_Ip { float v1; unsigned short v2:16; int * v3; };
struct F_BFu16s_L { float v1; unsigned short v2:16; long long v3; };
struct F_BFu16s_S { float v1; unsigned short v2:16; short v3; };
struct F_BFu16s_Uc { float v1; unsigned short v2:16; unsigned char v3; };
struct F_BFu16s_Ui { float v1; unsigned short v2:16; unsigned int v3; };
struct F_BFu16s_Ul { float v1; unsigned short v2:16; unsigned long long v3; };
struct F_BFu16s_Us { float v1; unsigned short v2:16; unsigned short v3; };
struct F_BFu16s_Vp { float v1; unsigned short v2:16; void * v3; };
struct F_BFu17i { float v1; unsigned int v2:17; };
struct F_BFu17i_BFu15i { float v1; unsigned int v2:17; unsigned int v3:15; };
struct F_BFu17i_BFu15ll { float v1; unsigned int v2:17; unsigned long long v3:15; };
struct F_BFu17i_BFu15s { float v1; unsigned int v2:17; unsigned short v3:15; };
struct F_BFu17i_BFu16i { float v1; unsigned int v2:17; unsigned int v3:16; };
struct F_BFu17i_BFu16ll { float v1; unsigned int v2:17; unsigned long long v3:16; };
struct F_BFu17i_BFu16s { float v1; unsigned int v2:17; unsigned short v3:16; };
struct F_BFu17i_BFu17i { float v1; unsigned int v2:17; unsigned int v3:17; };
struct F_BFu17i_BFu17ll { float v1; unsigned int v2:17; unsigned long long v3:17; };
struct F_BFu17i_BFu1c { float v1; unsigned int v2:17; unsigned char v3:1; };
struct F_BFu17i_BFu1i { float v1; unsigned int v2:17; unsigned int v3:1; };
struct F_BFu17i_BFu1ll { float v1; unsigned int v2:17; unsigned long long v3:1; };
struct F_BFu17i_BFu1s { float v1; unsigned int v2:17; unsigned short v3:1; };
struct F_BFu17i_BFu31i { float v1; unsigned int v2:17; unsigned int v3:31; };
struct F_BFu17i_BFu31ll { float v1; unsigned int v2:17; unsigned long long v3:31; };
struct F_BFu17i_BFu32i { float v1; unsigned int v2:17; unsigned int v3:32; };
struct F_BFu17i_BFu32ll { float v1; unsigned int v2:17; unsigned long long v3:32; };
struct F_BFu17i_BFu33 { float v1; unsigned int v2:17; unsigned long long v3:33; };
struct F_BFu17i_BFu7c { float v1; unsigned int v2:17; unsigned char v3:7; };
struct F_BFu17i_BFu7i { float v1; unsigned int v2:17; unsigned int v3:7; };
struct F_BFu17i_BFu7ll { float v1; unsigned int v2:17; unsigned long long v3:7; };
struct F_BFu17i_BFu7s { float v1; unsigned int v2:17; unsigned short v3:7; };
struct F_BFu17i_BFu8c { float v1; unsigned int v2:17; unsigned char v3:8; };
struct F_BFu17i_BFu8i { float v1; unsigned int v2:17; unsigned int v3:8; };
struct F_BFu17i_BFu8ll { float v1; unsigned int v2:17; unsigned long long v3:8; };
struct F_BFu17i_BFu8s { float v1; unsigned int v2:17; unsigned short v3:8; };
struct F_BFu17i_BFu9i { float v1; unsigned int v2:17; unsigned int v3:9; };
struct F_BFu17i_BFu9ll { float v1; unsigned int v2:17; unsigned long long v3:9; };
struct F_BFu17i_BFu9s { float v1; unsigned int v2:17; unsigned short v3:9; };
struct F_BFu17i_C { float v1; unsigned int v2:17; char v3; };
struct F_BFu17i_D { float v1; unsigned int v2:17; double v3; };
struct F_BFu17i_F { float v1; unsigned int v2:17; float v3; };
struct F_BFu17i_I { float v1; unsigned int v2:17; int v3; };
struct F_BFu17i_Ip { float v1; unsigned int v2:17; int * v3; };
struct F_BFu17i_L { float v1; unsigned int v2:17; long long v3; };
struct F_BFu17i_S { float v1; unsigned int v2:17; short v3; };
struct F_BFu17i_Uc { float v1; unsigned int v2:17; unsigned char v3; };
struct F_BFu17i_Ui { float v1; unsigned int v2:17; unsigned int v3; };
struct F_BFu17i_Ul { float v1; unsigned int v2:17; unsigned long long v3; };
struct F_BFu17i_Us { float v1; unsigned int v2:17; unsigned short v3; };
struct F_BFu17i_Vp { float v1; unsigned int v2:17; void * v3; };
struct F_BFu17ll { float v1; unsigned long long v2:17; };
struct F_BFu17ll_BFu15i { float v1; unsigned long long v2:17; unsigned int v3:15; };
struct F_BFu17ll_BFu15ll { float v1; unsigned long long v2:17; unsigned long long v3:15; };
struct F_BFu17ll_BFu15s { float v1; unsigned long long v2:17; unsigned short v3:15; };
struct F_BFu17ll_BFu16i { float v1; unsigned long long v2:17; unsigned int v3:16; };
struct F_BFu17ll_BFu16ll { float v1; unsigned long long v2:17; unsigned long long v3:16; };
struct F_BFu17ll_BFu16s { float v1; unsigned long long v2:17; unsigned short v3:16; };
struct F_BFu17ll_BFu17i { float v1; unsigned long long v2:17; unsigned int v3:17; };
struct F_BFu17ll_BFu17ll { float v1; unsigned long long v2:17; unsigned long long v3:17; };
struct F_BFu17ll_BFu1c { float v1; unsigned long long v2:17; unsigned char v3:1; };
struct F_BFu17ll_BFu1i { float v1; unsigned long long v2:17; unsigned int v3:1; };
struct F_BFu17ll_BFu1ll { float v1; unsigned long long v2:17; unsigned long long v3:1; };
struct F_BFu17ll_BFu1s { float v1; unsigned long long v2:17; unsigned short v3:1; };
struct F_BFu17ll_BFu31i { float v1; unsigned long long v2:17; unsigned int v3:31; };
struct F_BFu17ll_BFu31ll { float v1; unsigned long long v2:17; unsigned long long v3:31; };
struct F_BFu17ll_BFu32i { float v1; unsigned long long v2:17; unsigned int v3:32; };
struct F_BFu17ll_BFu32ll { float v1; unsigned long long v2:17; unsigned long long v3:32; };
struct F_BFu17ll_BFu33 { float v1; unsigned long long v2:17; unsigned long long v3:33; };
struct F_BFu17ll_BFu7c { float v1; unsigned long long v2:17; unsigned char v3:7; };
struct F_BFu17ll_BFu7i { float v1; unsigned long long v2:17; unsigned int v3:7; };
struct F_BFu17ll_BFu7ll { float v1; unsigned long long v2:17; unsigned long long v3:7; };
struct F_BFu17ll_BFu7s { float v1; unsigned long long v2:17; unsigned short v3:7; };
struct F_BFu17ll_BFu8c { float v1; unsigned long long v2:17; unsigned char v3:8; };
struct F_BFu17ll_BFu8i { float v1; unsigned long long v2:17; unsigned int v3:8; };
struct F_BFu17ll_BFu8ll { float v1; unsigned long long v2:17; unsigned long long v3:8; };
struct F_BFu17ll_BFu8s { float v1; unsigned long long v2:17; unsigned short v3:8; };
struct F_BFu17ll_BFu9i { float v1; unsigned long long v2:17; unsigned int v3:9; };
struct F_BFu17ll_BFu9ll { float v1; unsigned long long v2:17; unsigned long long v3:9; };
struct F_BFu17ll_BFu9s { float v1; unsigned long long v2:17; unsigned short v3:9; };
struct F_BFu17ll_C { float v1; unsigned long long v2:17; char v3; };
struct F_BFu17ll_D { float v1; unsigned long long v2:17; double v3; };
struct F_BFu17ll_F { float v1; unsigned long long v2:17; float v3; };
struct F_BFu17ll_I { float v1; unsigned long long v2:17; int v3; };
struct F_BFu17ll_Ip { float v1; unsigned long long v2:17; int * v3; };
struct F_BFu17ll_L { float v1; unsigned long long v2:17; long long v3; };
struct F_BFu17ll_S { float v1; unsigned long long v2:17; short v3; };
struct F_BFu17ll_Uc { float v1; unsigned long long v2:17; unsigned char v3; };
struct F_BFu17ll_Ui { float v1; unsigned long long v2:17; unsigned int v3; };
struct F_BFu17ll_Ul { float v1; unsigned long long v2:17; unsigned long long v3; };
struct F_BFu17ll_Us { float v1; unsigned long long v2:17; unsigned short v3; };
struct F_BFu17ll_Vp { float v1; unsigned long long v2:17; void * v3; };
struct F_BFu1c { float v1; unsigned char v2:1; };
struct F_BFu1c_BFu15i { float v1; unsigned char v2:1; unsigned int v3:15; };
struct F_BFu1c_BFu15ll { float v1; unsigned char v2:1; unsigned long long v3:15; };
struct F_BFu1c_BFu15s { float v1; unsigned char v2:1; unsigned short v3:15; };
struct F_BFu1c_BFu16i { float v1; unsigned char v2:1; unsigned int v3:16; };
struct F_BFu1c_BFu16ll { float v1; unsigned char v2:1; unsigned long long v3:16; };
struct F_BFu1c_BFu16s { float v1; unsigned char v2:1; unsigned short v3:16; };
struct F_BFu1c_BFu17i { float v1; unsigned char v2:1; unsigned int v3:17; };
struct F_BFu1c_BFu17ll { float v1; unsigned char v2:1; unsigned long long v3:17; };
struct F_BFu1c_BFu1c { float v1; unsigned char v2:1; unsigned char v3:1; };
struct F_BFu1c_BFu1i { float v1; unsigned char v2:1; unsigned int v3:1; };
struct F_BFu1c_BFu1ll { float v1; unsigned char v2:1; unsigned long long v3:1; };
struct F_BFu1c_BFu1s { float v1; unsigned char v2:1; unsigned short v3:1; };
struct F_BFu1c_BFu31i { float v1; unsigned char v2:1; unsigned int v3:31; };
struct F_BFu1c_BFu31ll { float v1; unsigned char v2:1; unsigned long long v3:31; };
struct F_BFu1c_BFu32i { float v1; unsigned char v2:1; unsigned int v3:32; };
struct F_BFu1c_BFu32ll { float v1; unsigned char v2:1; unsigned long long v3:32; };
struct F_BFu1c_BFu33 { float v1; unsigned char v2:1; unsigned long long v3:33; };
struct F_BFu1c_BFu7c { float v1; unsigned char v2:1; unsigned char v3:7; };
struct F_BFu1c_BFu7i { float v1; unsigned char v2:1; unsigned int v3:7; };
struct F_BFu1c_BFu7ll { float v1; unsigned char v2:1; unsigned long long v3:7; };
struct F_BFu1c_BFu7s { float v1; unsigned char v2:1; unsigned short v3:7; };
struct F_BFu1c_BFu8c { float v1; unsigned char v2:1; unsigned char v3:8; };
struct F_BFu1c_BFu8i { float v1; unsigned char v2:1; unsigned int v3:8; };
struct F_BFu1c_BFu8ll { float v1; unsigned char v2:1; unsigned long long v3:8; };
struct F_BFu1c_BFu8s { float v1; unsigned char v2:1; unsigned short v3:8; };
struct F_BFu1c_BFu9i { float v1; unsigned char v2:1; unsigned int v3:9; };
struct F_BFu1c_BFu9ll { float v1; unsigned char v2:1; unsigned long long v3:9; };
struct F_BFu1c_BFu9s { float v1; unsigned char v2:1; unsigned short v3:9; };
struct F_BFu1c_C { float v1; unsigned char v2:1; char v3; };
struct F_BFu1c_D { float v1; unsigned char v2:1; double v3; };
struct F_BFu1c_F { float v1; unsigned char v2:1; float v3; };
struct F_BFu1c_I { float v1; unsigned char v2:1; int v3; };
struct F_BFu1c_Ip { float v1; unsigned char v2:1; int * v3; };
struct F_BFu1c_L { float v1; unsigned char v2:1; long long v3; };
struct F_BFu1c_S { float v1; unsigned char v2:1; short v3; };
struct F_BFu1c_Uc { float v1; unsigned char v2:1; unsigned char v3; };
struct F_BFu1c_Ui { float v1; unsigned char v2:1; unsigned int v3; };
struct F_BFu1c_Ul { float v1; unsigned char v2:1; unsigned long long v3; };
struct F_BFu1c_Us { float v1; unsigned char v2:1; unsigned short v3; };
struct F_BFu1c_Vp { float v1; unsigned char v2:1; void * v3; };
struct F_BFu1i { float v1; unsigned int v2:1; };
struct F_BFu1i_BFu15i { float v1; unsigned int v2:1; unsigned int v3:15; };
struct F_BFu1i_BFu15ll { float v1; unsigned int v2:1; unsigned long long v3:15; };
struct F_BFu1i_BFu15s { float v1; unsigned int v2:1; unsigned short v3:15; };
struct F_BFu1i_BFu16i { float v1; unsigned int v2:1; unsigned int v3:16; };
struct F_BFu1i_BFu16ll { float v1; unsigned int v2:1; unsigned long long v3:16; };
struct F_BFu1i_BFu16s { float v1; unsigned int v2:1; unsigned short v3:16; };
struct F_BFu1i_BFu17i { float v1; unsigned int v2:1; unsigned int v3:17; };
struct F_BFu1i_BFu17ll { float v1; unsigned int v2:1; unsigned long long v3:17; };
struct F_BFu1i_BFu1c { float v1; unsigned int v2:1; unsigned char v3:1; };
struct F_BFu1i_BFu1i { float v1; unsigned int v2:1; unsigned int v3:1; };
struct F_BFu1i_BFu1ll { float v1; unsigned int v2:1; unsigned long long v3:1; };
struct F_BFu1i_BFu1s { float v1; unsigned int v2:1; unsigned short v3:1; };
struct F_BFu1i_BFu31i { float v1; unsigned int v2:1; unsigned int v3:31; };
struct F_BFu1i_BFu31ll { float v1; unsigned int v2:1; unsigned long long v3:31; };
struct F_BFu1i_BFu32i { float v1; unsigned int v2:1; unsigned int v3:32; };
struct F_BFu1i_BFu32ll { float v1; unsigned int v2:1; unsigned long long v3:32; };
struct F_BFu1i_BFu33 { float v1; unsigned int v2:1; unsigned long long v3:33; };
struct F_BFu1i_BFu7c { float v1; unsigned int v2:1; unsigned char v3:7; };
struct F_BFu1i_BFu7i { float v1; unsigned int v2:1; unsigned int v3:7; };
struct F_BFu1i_BFu7ll { float v1; unsigned int v2:1; unsigned long long v3:7; };
struct F_BFu1i_BFu7s { float v1; unsigned int v2:1; unsigned short v3:7; };
struct F_BFu1i_BFu8c { float v1; unsigned int v2:1; unsigned char v3:8; };
struct F_BFu1i_BFu8i { float v1; unsigned int v2:1; unsigned int v3:8; };
struct F_BFu1i_BFu8ll { float v1; unsigned int v2:1; unsigned long long v3:8; };
struct F_BFu1i_BFu8s { float v1; unsigned int v2:1; unsigned short v3:8; };
struct F_BFu1i_BFu9i { float v1; unsigned int v2:1; unsigned int v3:9; };
struct F_BFu1i_BFu9ll { float v1; unsigned int v2:1; unsigned long long v3:9; };
struct F_BFu1i_BFu9s { float v1; unsigned int v2:1; unsigned short v3:9; };
struct F_BFu1i_C { float v1; unsigned int v2:1; char v3; };
struct F_BFu1i_D { float v1; unsigned int v2:1; double v3; };
struct F_BFu1i_F { float v1; unsigned int v2:1; float v3; };
struct F_BFu1i_I { float v1; unsigned int v2:1; int v3; };
struct F_BFu1i_Ip { float v1; unsigned int v2:1; int * v3; };
struct F_BFu1i_L { float v1; unsigned int v2:1; long long v3; };
struct F_BFu1i_S { float v1; unsigned int v2:1; short v3; };
struct F_BFu1i_Uc { float v1; unsigned int v2:1; unsigned char v3; };
struct F_BFu1i_Ui { float v1; unsigned int v2:1; unsigned int v3; };
struct F_BFu1i_Ul { float v1; unsigned int v2:1; unsigned long long v3; };
struct F_BFu1i_Us { float v1; unsigned int v2:1; unsigned short v3; };
struct F_BFu1i_Vp { float v1; unsigned int v2:1; void * v3; };
struct F_BFu1ll { float v1; unsigned long long v2:1; };
struct F_BFu1ll_BFu15i { float v1; unsigned long long v2:1; unsigned int v3:15; };
struct F_BFu1ll_BFu15ll { float v1; unsigned long long v2:1; unsigned long long v3:15; };
struct F_BFu1ll_BFu15s { float v1; unsigned long long v2:1; unsigned short v3:15; };
struct F_BFu1ll_BFu16i { float v1; unsigned long long v2:1; unsigned int v3:16; };
struct F_BFu1ll_BFu16ll { float v1; unsigned long long v2:1; unsigned long long v3:16; };
struct F_BFu1ll_BFu16s { float v1; unsigned long long v2:1; unsigned short v3:16; };
struct F_BFu1ll_BFu17i { float v1; unsigned long long v2:1; unsigned int v3:17; };
struct F_BFu1ll_BFu17ll { float v1; unsigned long long v2:1; unsigned long long v3:17; };
struct F_BFu1ll_BFu1c { float v1; unsigned long long v2:1; unsigned char v3:1; };
struct F_BFu1ll_BFu1i { float v1; unsigned long long v2:1; unsigned int v3:1; };
struct F_BFu1ll_BFu1ll { float v1; unsigned long long v2:1; unsigned long long v3:1; };
struct F_BFu1ll_BFu1s { float v1; unsigned long long v2:1; unsigned short v3:1; };
struct F_BFu1ll_BFu31i { float v1; unsigned long long v2:1; unsigned int v3:31; };
struct F_BFu1ll_BFu31ll { float v1; unsigned long long v2:1; unsigned long long v3:31; };
struct F_BFu1ll_BFu32i { float v1; unsigned long long v2:1; unsigned int v3:32; };
struct F_BFu1ll_BFu32ll { float v1; unsigned long long v2:1; unsigned long long v3:32; };
struct F_BFu1ll_BFu33 { float v1; unsigned long long v2:1; unsigned long long v3:33; };
struct F_BFu1ll_BFu7c { float v1; unsigned long long v2:1; unsigned char v3:7; };
struct F_BFu1ll_BFu7i { float v1; unsigned long long v2:1; unsigned int v3:7; };
struct F_BFu1ll_BFu7ll { float v1; unsigned long long v2:1; unsigned long long v3:7; };
struct F_BFu1ll_BFu7s { float v1; unsigned long long v2:1; unsigned short v3:7; };
struct F_BFu1ll_BFu8c { float v1; unsigned long long v2:1; unsigned char v3:8; };
struct F_BFu1ll_BFu8i { float v1; unsigned long long v2:1; unsigned int v3:8; };
struct F_BFu1ll_BFu8ll { float v1; unsigned long long v2:1; unsigned long long v3:8; };
struct F_BFu1ll_BFu8s { float v1; unsigned long long v2:1; unsigned short v3:8; };
struct F_BFu1ll_BFu9i { float v1; unsigned long long v2:1; unsigned int v3:9; };
struct F_BFu1ll_BFu9ll { float v1; unsigned long long v2:1; unsigned long long v3:9; };
struct F_BFu1ll_BFu9s { float v1; unsigned long long v2:1; unsigned short v3:9; };
struct F_BFu1ll_C { float v1; unsigned long long v2:1; char v3; };
struct F_BFu1ll_D { float v1; unsigned long long v2:1; double v3; };
struct F_BFu1ll_F { float v1; unsigned long long v2:1; float v3; };
struct F_BFu1ll_I { float v1; unsigned long long v2:1; int v3; };
struct F_BFu1ll_Ip { float v1; unsigned long long v2:1; int * v3; };
struct F_BFu1ll_L { float v1; unsigned long long v2:1; long long v3; };
struct F_BFu1ll_S { float v1; unsigned long long v2:1; short v3; };
struct F_BFu1ll_Uc { float v1; unsigned long long v2:1; unsigned char v3; };
struct F_BFu1ll_Ui { float v1; unsigned long long v2:1; unsigned int v3; };
struct F_BFu1ll_Ul { float v1; unsigned long long v2:1; unsigned long long v3; };
struct F_BFu1ll_Us { float v1; unsigned long long v2:1; unsigned short v3; };
struct F_BFu1ll_Vp { float v1; unsigned long long v2:1; void * v3; };
struct F_BFu1s { float v1; unsigned short v2:1; };
struct F_BFu1s_BFu15i { float v1; unsigned short v2:1; unsigned int v3:15; };
struct F_BFu1s_BFu15ll { float v1; unsigned short v2:1; unsigned long long v3:15; };
struct F_BFu1s_BFu15s { float v1; unsigned short v2:1; unsigned short v3:15; };
struct F_BFu1s_BFu16i { float v1; unsigned short v2:1; unsigned int v3:16; };
struct F_BFu1s_BFu16ll { float v1; unsigned short v2:1; unsigned long long v3:16; };
struct F_BFu1s_BFu16s { float v1; unsigned short v2:1; unsigned short v3:16; };
struct F_BFu1s_BFu17i { float v1; unsigned short v2:1; unsigned int v3:17; };
struct F_BFu1s_BFu17ll { float v1; unsigned short v2:1; unsigned long long v3:17; };
struct F_BFu1s_BFu1c { float v1; unsigned short v2:1; unsigned char v3:1; };
struct F_BFu1s_BFu1i { float v1; unsigned short v2:1; unsigned int v3:1; };
struct F_BFu1s_BFu1ll { float v1; unsigned short v2:1; unsigned long long v3:1; };
struct F_BFu1s_BFu1s { float v1; unsigned short v2:1; unsigned short v3:1; };
struct F_BFu1s_BFu31i { float v1; unsigned short v2:1; unsigned int v3:31; };
struct F_BFu1s_BFu31ll { float v1; unsigned short v2:1; unsigned long long v3:31; };
struct F_BFu1s_BFu32i { float v1; unsigned short v2:1; unsigned int v3:32; };
struct F_BFu1s_BFu32ll { float v1; unsigned short v2:1; unsigned long long v3:32; };
struct F_BFu1s_BFu33 { float v1; unsigned short v2:1; unsigned long long v3:33; };
struct F_BFu1s_BFu7c { float v1; unsigned short v2:1; unsigned char v3:7; };
struct F_BFu1s_BFu7i { float v1; unsigned short v2:1; unsigned int v3:7; };
struct F_BFu1s_BFu7ll { float v1; unsigned short v2:1; unsigned long long v3:7; };
struct F_BFu1s_BFu7s { float v1; unsigned short v2:1; unsigned short v3:7; };
struct F_BFu1s_BFu8c { float v1; unsigned short v2:1; unsigned char v3:8; };
struct F_BFu1s_BFu8i { float v1; unsigned short v2:1; unsigned int v3:8; };
struct F_BFu1s_BFu8ll { float v1; unsigned short v2:1; unsigned long long v3:8; };
struct F_BFu1s_BFu8s { float v1; unsigned short v2:1; unsigned short v3:8; };
struct F_BFu1s_BFu9i { float v1; unsigned short v2:1; unsigned int v3:9; };
struct F_BFu1s_BFu9ll { float v1; unsigned short v2:1; unsigned long long v3:9; };
struct F_BFu1s_BFu9s { float v1; unsigned short v2:1; unsigned short v3:9; };
struct F_BFu1s_C { float v1; unsigned short v2:1; char v3; };
struct F_BFu1s_D { float v1; unsigned short v2:1; double v3; };
struct F_BFu1s_F { float v1; unsigned short v2:1; float v3; };
struct F_BFu1s_I { float v1; unsigned short v2:1; int v3; };
struct F_BFu1s_Ip { float v1; unsigned short v2:1; int * v3; };
struct F_BFu1s_L { float v1; unsigned short v2:1; long long v3; };
struct F_BFu1s_S { float v1; unsigned short v2:1; short v3; };
struct F_BFu1s_Uc { float v1; unsigned short v2:1; unsigned char v3; };
struct F_BFu1s_Ui { float v1; unsigned short v2:1; unsigned int v3; };
struct F_BFu1s_Ul { float v1; unsigned short v2:1; unsigned long long v3; };
struct F_BFu1s_Us { float v1; unsigned short v2:1; unsigned short v3; };
struct F_BFu1s_Vp { float v1; unsigned short v2:1; void * v3; };
struct F_BFu31i { float v1; unsigned int v2:31; };
struct F_BFu31i_BFu15i { float v1; unsigned int v2:31; unsigned int v3:15; };
struct F_BFu31i_BFu15ll { float v1; unsigned int v2:31; unsigned long long v3:15; };
struct F_BFu31i_BFu15s { float v1; unsigned int v2:31; unsigned short v3:15; };
struct F_BFu31i_BFu16i { float v1; unsigned int v2:31; unsigned int v3:16; };
struct F_BFu31i_BFu16ll { float v1; unsigned int v2:31; unsigned long long v3:16; };
struct F_BFu31i_BFu16s { float v1; unsigned int v2:31; unsigned short v3:16; };
struct F_BFu31i_BFu17i { float v1; unsigned int v2:31; unsigned int v3:17; };
struct F_BFu31i_BFu17ll { float v1; unsigned int v2:31; unsigned long long v3:17; };
struct F_BFu31i_BFu1c { float v1; unsigned int v2:31; unsigned char v3:1; };
struct F_BFu31i_BFu1i { float v1; unsigned int v2:31; unsigned int v3:1; };
struct F_BFu31i_BFu1ll { float v1; unsigned int v2:31; unsigned long long v3:1; };
struct F_BFu31i_BFu1s { float v1; unsigned int v2:31; unsigned short v3:1; };
struct F_BFu31i_BFu31i { float v1; unsigned int v2:31; unsigned int v3:31; };
struct F_BFu31i_BFu31ll { float v1; unsigned int v2:31; unsigned long long v3:31; };
struct F_BFu31i_BFu32i { float v1; unsigned int v2:31; unsigned int v3:32; };
struct F_BFu31i_BFu32ll { float v1; unsigned int v2:31; unsigned long long v3:32; };
struct F_BFu31i_BFu33 { float v1; unsigned int v2:31; unsigned long long v3:33; };
struct F_BFu31i_BFu7c { float v1; unsigned int v2:31; unsigned char v3:7; };
struct F_BFu31i_BFu7i { float v1; unsigned int v2:31; unsigned int v3:7; };
struct F_BFu31i_BFu7ll { float v1; unsigned int v2:31; unsigned long long v3:7; };
struct F_BFu31i_BFu7s { float v1; unsigned int v2:31; unsigned short v3:7; };
struct F_BFu31i_BFu8c { float v1; unsigned int v2:31; unsigned char v3:8; };
struct F_BFu31i_BFu8i { float v1; unsigned int v2:31; unsigned int v3:8; };
struct F_BFu31i_BFu8ll { float v1; unsigned int v2:31; unsigned long long v3:8; };
struct F_BFu31i_BFu8s { float v1; unsigned int v2:31; unsigned short v3:8; };
struct F_BFu31i_BFu9i { float v1; unsigned int v2:31; unsigned int v3:9; };
struct F_BFu31i_BFu9ll { float v1; unsigned int v2:31; unsigned long long v3:9; };
struct F_BFu31i_BFu9s { float v1; unsigned int v2:31; unsigned short v3:9; };
struct F_BFu31i_C { float v1; unsigned int v2:31; char v3; };
struct F_BFu31i_D { float v1; unsigned int v2:31; double v3; };
struct F_BFu31i_F { float v1; unsigned int v2:31; float v3; };
struct F_BFu31i_I { float v1; unsigned int v2:31; int v3; };
struct F_BFu31i_Ip { float v1; unsigned int v2:31; int * v3; };
struct F_BFu31i_L { float v1; unsigned int v2:31; long long v3; };
struct F_BFu31i_S { float v1; unsigned int v2:31; short v3; };
struct F_BFu31i_Uc { float v1; unsigned int v2:31; unsigned char v3; };
struct F_BFu31i_Ui { float v1; unsigned int v2:31; unsigned int v3; };
struct F_BFu31i_Ul { float v1; unsigned int v2:31; unsigned long long v3; };
struct F_BFu31i_Us { float v1; unsigned int v2:31; unsigned short v3; };
struct F_BFu31i_Vp { float v1; unsigned int v2:31; void * v3; };
struct F_BFu31ll { float v1; unsigned long long v2:31; };
struct F_BFu31ll_BFu15i { float v1; unsigned long long v2:31; unsigned int v3:15; };
struct F_BFu31ll_BFu15ll { float v1; unsigned long long v2:31; unsigned long long v3:15; };
struct F_BFu31ll_BFu15s { float v1; unsigned long long v2:31; unsigned short v3:15; };
struct F_BFu31ll_BFu16i { float v1; unsigned long long v2:31; unsigned int v3:16; };
struct F_BFu31ll_BFu16ll { float v1; unsigned long long v2:31; unsigned long long v3:16; };
struct F_BFu31ll_BFu16s { float v1; unsigned long long v2:31; unsigned short v3:16; };
struct F_BFu31ll_BFu17i { float v1; unsigned long long v2:31; unsigned int v3:17; };
struct F_BFu31ll_BFu17ll { float v1; unsigned long long v2:31; unsigned long long v3:17; };
struct F_BFu31ll_BFu1c { float v1; unsigned long long v2:31; unsigned char v3:1; };
struct F_BFu31ll_BFu1i { float v1; unsigned long long v2:31; unsigned int v3:1; };
struct F_BFu31ll_BFu1ll { float v1; unsigned long long v2:31; unsigned long long v3:1; };
struct F_BFu31ll_BFu1s { float v1; unsigned long long v2:31; unsigned short v3:1; };
struct F_BFu31ll_BFu31i { float v1; unsigned long long v2:31; unsigned int v3:31; };
struct F_BFu31ll_BFu31ll { float v1; unsigned long long v2:31; unsigned long long v3:31; };
struct F_BFu31ll_BFu32i { float v1; unsigned long long v2:31; unsigned int v3:32; };
struct F_BFu31ll_BFu32ll { float v1; unsigned long long v2:31; unsigned long long v3:32; };
struct F_BFu31ll_BFu33 { float v1; unsigned long long v2:31; unsigned long long v3:33; };
struct F_BFu31ll_BFu7c { float v1; unsigned long long v2:31; unsigned char v3:7; };
struct F_BFu31ll_BFu7i { float v1; unsigned long long v2:31; unsigned int v3:7; };
struct F_BFu31ll_BFu7ll { float v1; unsigned long long v2:31; unsigned long long v3:7; };
struct F_BFu31ll_BFu7s { float v1; unsigned long long v2:31; unsigned short v3:7; };
struct F_BFu31ll_BFu8c { float v1; unsigned long long v2:31; unsigned char v3:8; };
struct F_BFu31ll_BFu8i { float v1; unsigned long long v2:31; unsigned int v3:8; };
struct F_BFu31ll_BFu8ll { float v1; unsigned long long v2:31; unsigned long long v3:8; };
struct F_BFu31ll_BFu8s { float v1; unsigned long long v2:31; unsigned short v3:8; };
struct F_BFu31ll_BFu9i { float v1; unsigned long long v2:31; unsigned int v3:9; };
struct F_BFu31ll_BFu9ll { float v1; unsigned long long v2:31; unsigned long long v3:9; };
struct F_BFu31ll_BFu9s { float v1; unsigned long long v2:31; unsigned short v3:9; };
struct F_BFu31ll_C { float v1; unsigned long long v2:31; char v3; };
struct F_BFu31ll_D { float v1; unsigned long long v2:31; double v3; };
struct F_BFu31ll_F { float v1; unsigned long long v2:31; float v3; };
struct F_BFu31ll_I { float v1; unsigned long long v2:31; int v3; };
struct F_BFu31ll_Ip { float v1; unsigned long long v2:31; int * v3; };
struct F_BFu31ll_L { float v1; unsigned long long v2:31; long long v3; };
struct F_BFu31ll_S { float v1; unsigned long long v2:31; short v3; };
struct F_BFu31ll_Uc { float v1; unsigned long long v2:31; unsigned char v3; };
struct F_BFu31ll_Ui { float v1; unsigned long long v2:31; unsigned int v3; };
struct F_BFu31ll_Ul { float v1; unsigned long long v2:31; unsigned long long v3; };
struct F_BFu31ll_Us { float v1; unsigned long long v2:31; unsigned short v3; };
struct F_BFu31ll_Vp { float v1; unsigned long long v2:31; void * v3; };
struct F_BFu32i { float v1; unsigned int v2:32; };
struct F_BFu32i_BFu15i { float v1; unsigned int v2:32; unsigned int v3:15; };
struct F_BFu32i_BFu15ll { float v1; unsigned int v2:32; unsigned long long v3:15; };
struct F_BFu32i_BFu15s { float v1; unsigned int v2:32; unsigned short v3:15; };
struct F_BFu32i_BFu16i { float v1; unsigned int v2:32; unsigned int v3:16; };
struct F_BFu32i_BFu16ll { float v1; unsigned int v2:32; unsigned long long v3:16; };
struct F_BFu32i_BFu16s { float v1; unsigned int v2:32; unsigned short v3:16; };
struct F_BFu32i_BFu17i { float v1; unsigned int v2:32; unsigned int v3:17; };
struct F_BFu32i_BFu17ll { float v1; unsigned int v2:32; unsigned long long v3:17; };
struct F_BFu32i_BFu1c { float v1; unsigned int v2:32; unsigned char v3:1; };
struct F_BFu32i_BFu1i { float v1; unsigned int v2:32; unsigned int v3:1; };
struct F_BFu32i_BFu1ll { float v1; unsigned int v2:32; unsigned long long v3:1; };
struct F_BFu32i_BFu1s { float v1; unsigned int v2:32; unsigned short v3:1; };
struct F_BFu32i_BFu31i { float v1; unsigned int v2:32; unsigned int v3:31; };
struct F_BFu32i_BFu31ll { float v1; unsigned int v2:32; unsigned long long v3:31; };
struct F_BFu32i_BFu32i { float v1; unsigned int v2:32; unsigned int v3:32; };
struct F_BFu32i_BFu32ll { float v1; unsigned int v2:32; unsigned long long v3:32; };
struct F_BFu32i_BFu33 { float v1; unsigned int v2:32; unsigned long long v3:33; };
struct F_BFu32i_BFu7c { float v1; unsigned int v2:32; unsigned char v3:7; };
struct F_BFu32i_BFu7i { float v1; unsigned int v2:32; unsigned int v3:7; };
struct F_BFu32i_BFu7ll { float v1; unsigned int v2:32; unsigned long long v3:7; };
struct F_BFu32i_BFu7s { float v1; unsigned int v2:32; unsigned short v3:7; };
struct F_BFu32i_BFu8c { float v1; unsigned int v2:32; unsigned char v3:8; };
struct F_BFu32i_BFu8i { float v1; unsigned int v2:32; unsigned int v3:8; };
struct F_BFu32i_BFu8ll { float v1; unsigned int v2:32; unsigned long long v3:8; };
struct F_BFu32i_BFu8s { float v1; unsigned int v2:32; unsigned short v3:8; };
struct F_BFu32i_BFu9i { float v1; unsigned int v2:32; unsigned int v3:9; };
struct F_BFu32i_BFu9ll { float v1; unsigned int v2:32; unsigned long long v3:9; };
struct F_BFu32i_BFu9s { float v1; unsigned int v2:32; unsigned short v3:9; };
struct F_BFu32i_C { float v1; unsigned int v2:32; char v3; };
struct F_BFu32i_D { float v1; unsigned int v2:32; double v3; };
struct F_BFu32i_F { float v1; unsigned int v2:32; float v3; };
struct F_BFu32i_I { float v1; unsigned int v2:32; int v3; };
struct F_BFu32i_Ip { float v1; unsigned int v2:32; int * v3; };
struct F_BFu32i_L { float v1; unsigned int v2:32; long long v3; };
struct F_BFu32i_S { float v1; unsigned int v2:32; short v3; };
struct F_BFu32i_Uc { float v1; unsigned int v2:32; unsigned char v3; };
struct F_BFu32i_Ui { float v1; unsigned int v2:32; unsigned int v3; };
struct F_BFu32i_Ul { float v1; unsigned int v2:32; unsigned long long v3; };
struct F_BFu32i_Us { float v1; unsigned int v2:32; unsigned short v3; };
struct F_BFu32i_Vp { float v1; unsigned int v2:32; void * v3; };
struct F_BFu32ll { float v1; unsigned long long v2:32; };
struct F_BFu32ll_BFu15i { float v1; unsigned long long v2:32; unsigned int v3:15; };
struct F_BFu32ll_BFu15ll { float v1; unsigned long long v2:32; unsigned long long v3:15; };
struct F_BFu32ll_BFu15s { float v1; unsigned long long v2:32; unsigned short v3:15; };
struct F_BFu32ll_BFu16i { float v1; unsigned long long v2:32; unsigned int v3:16; };
struct F_BFu32ll_BFu16ll { float v1; unsigned long long v2:32; unsigned long long v3:16; };
struct F_BFu32ll_BFu16s { float v1; unsigned long long v2:32; unsigned short v3:16; };
struct F_BFu32ll_BFu17i { float v1; unsigned long long v2:32; unsigned int v3:17; };
struct F_BFu32ll_BFu17ll { float v1; unsigned long long v2:32; unsigned long long v3:17; };
struct F_BFu32ll_BFu1c { float v1; unsigned long long v2:32; unsigned char v3:1; };
struct F_BFu32ll_BFu1i { float v1; unsigned long long v2:32; unsigned int v3:1; };
struct F_BFu32ll_BFu1ll { float v1; unsigned long long v2:32; unsigned long long v3:1; };
struct F_BFu32ll_BFu1s { float v1; unsigned long long v2:32; unsigned short v3:1; };
struct F_BFu32ll_BFu31i { float v1; unsigned long long v2:32; unsigned int v3:31; };
struct F_BFu32ll_BFu31ll { float v1; unsigned long long v2:32; unsigned long long v3:31; };
struct F_BFu32ll_BFu32i { float v1; unsigned long long v2:32; unsigned int v3:32; };
struct F_BFu32ll_BFu32ll { float v1; unsigned long long v2:32; unsigned long long v3:32; };
struct F_BFu32ll_BFu33 { float v1; unsigned long long v2:32; unsigned long long v3:33; };
struct F_BFu32ll_BFu7c { float v1; unsigned long long v2:32; unsigned char v3:7; };
struct F_BFu32ll_BFu7i { float v1; unsigned long long v2:32; unsigned int v3:7; };
struct F_BFu32ll_BFu7ll { float v1; unsigned long long v2:32; unsigned long long v3:7; };
struct F_BFu32ll_BFu7s { float v1; unsigned long long v2:32; unsigned short v3:7; };
struct F_BFu32ll_BFu8c { float v1; unsigned long long v2:32; unsigned char v3:8; };
struct F_BFu32ll_BFu8i { float v1; unsigned long long v2:32; unsigned int v3:8; };
struct F_BFu32ll_BFu8ll { float v1; unsigned long long v2:32; unsigned long long v3:8; };
struct F_BFu32ll_BFu8s { float v1; unsigned long long v2:32; unsigned short v3:8; };
struct F_BFu32ll_BFu9i { float v1; unsigned long long v2:32; unsigned int v3:9; };
struct F_BFu32ll_BFu9ll { float v1; unsigned long long v2:32; unsigned long long v3:9; };
struct F_BFu32ll_BFu9s { float v1; unsigned long long v2:32; unsigned short v3:9; };
struct F_BFu32ll_C { float v1; unsigned long long v2:32; char v3; };
struct F_BFu32ll_D { float v1; unsigned long long v2:32; double v3; };
struct F_BFu32ll_F { float v1; unsigned long long v2:32; float v3; };
struct F_BFu32ll_I { float v1; unsigned long long v2:32; int v3; };
struct F_BFu32ll_Ip { float v1; unsigned long long v2:32; int * v3; };
struct F_BFu32ll_L { float v1; unsigned long long v2:32; long long v3; };
struct F_BFu32ll_S { float v1; unsigned long long v2:32; short v3; };
struct F_BFu32ll_Uc { float v1; unsigned long long v2:32; unsigned char v3; };
struct F_BFu32ll_Ui { float v1; unsigned long long v2:32; unsigned int v3; };
struct F_BFu32ll_Ul { float v1; unsigned long long v2:32; unsigned long long v3; };
struct F_BFu32ll_Us { float v1; unsigned long long v2:32; unsigned short v3; };
struct F_BFu32ll_Vp { float v1; unsigned long long v2:32; void * v3; };
struct F_BFu33 { float v1; unsigned long long v2:33; };
struct F_BFu33_BFu15i { float v1; unsigned long long v2:33; unsigned int v3:15; };
struct F_BFu33_BFu15ll { float v1; unsigned long long v2:33; unsigned long long v3:15; };
struct F_BFu33_BFu15s { float v1; unsigned long long v2:33; unsigned short v3:15; };
struct F_BFu33_BFu16i { float v1; unsigned long long v2:33; unsigned int v3:16; };
struct F_BFu33_BFu16ll { float v1; unsigned long long v2:33; unsigned long long v3:16; };
struct F_BFu33_BFu16s { float v1; unsigned long long v2:33; unsigned short v3:16; };
struct F_BFu33_BFu17i { float v1; unsigned long long v2:33; unsigned int v3:17; };
struct F_BFu33_BFu17ll { float v1; unsigned long long v2:33; unsigned long long v3:17; };
struct F_BFu33_BFu1c { float v1; unsigned long long v2:33; unsigned char v3:1; };
struct F_BFu33_BFu1i { float v1; unsigned long long v2:33; unsigned int v3:1; };
struct F_BFu33_BFu1ll { float v1; unsigned long long v2:33; unsigned long long v3:1; };
struct F_BFu33_BFu1s { float v1; unsigned long long v2:33; unsigned short v3:1; };
struct F_BFu33_BFu31i { float v1; unsigned long long v2:33; unsigned int v3:31; };
struct F_BFu33_BFu31ll { float v1; unsigned long long v2:33; unsigned long long v3:31; };
struct F_BFu33_BFu32i { float v1; unsigned long long v2:33; unsigned int v3:32; };
struct F_BFu33_BFu32ll { float v1; unsigned long long v2:33; unsigned long long v3:32; };
struct F_BFu33_BFu33 { float v1; unsigned long long v2:33; unsigned long long v3:33; };
struct F_BFu33_BFu7c { float v1; unsigned long long v2:33; unsigned char v3:7; };
struct F_BFu33_BFu7i { float v1; unsigned long long v2:33; unsigned int v3:7; };
struct F_BFu33_BFu7ll { float v1; unsigned long long v2:33; unsigned long long v3:7; };
struct F_BFu33_BFu7s { float v1; unsigned long long v2:33; unsigned short v3:7; };
struct F_BFu33_BFu8c { float v1; unsigned long long v2:33; unsigned char v3:8; };
struct F_BFu33_BFu8i { float v1; unsigned long long v2:33; unsigned int v3:8; };
struct F_BFu33_BFu8ll { float v1; unsigned long long v2:33; unsigned long long v3:8; };
struct F_BFu33_BFu8s { float v1; unsigned long long v2:33; unsigned short v3:8; };
struct F_BFu33_BFu9i { float v1; unsigned long long v2:33; unsigned int v3:9; };
struct F_BFu33_BFu9ll { float v1; unsigned long long v2:33; unsigned long long v3:9; };
struct F_BFu33_BFu9s { float v1; unsigned long long v2:33; unsigned short v3:9; };
struct F_BFu33_C { float v1; unsigned long long v2:33; char v3; };
struct F_BFu33_D { float v1; unsigned long long v2:33; double v3; };
struct F_BFu33_F { float v1; unsigned long long v2:33; float v3; };
struct F_BFu33_I { float v1; unsigned long long v2:33; int v3; };
struct F_BFu33_Ip { float v1; unsigned long long v2:33; int * v3; };
struct F_BFu33_L { float v1; unsigned long long v2:33; long long v3; };
struct F_BFu33_S { float v1; unsigned long long v2:33; short v3; };
struct F_BFu33_Uc { float v1; unsigned long long v2:33; unsigned char v3; };
struct F_BFu33_Ui { float v1; unsigned long long v2:33; unsigned int v3; };
struct F_BFu33_Ul { float v1; unsigned long long v2:33; unsigned long long v3; };
struct F_BFu33_Us { float v1; unsigned long long v2:33; unsigned short v3; };
struct F_BFu33_Vp { float v1; unsigned long long v2:33; void * v3; };
struct F_BFu7c { float v1; unsigned char v2:7; };
struct F_BFu7c_BFu15i { float v1; unsigned char v2:7; unsigned int v3:15; };
struct F_BFu7c_BFu15ll { float v1; unsigned char v2:7; unsigned long long v3:15; };
struct F_BFu7c_BFu15s { float v1; unsigned char v2:7; unsigned short v3:15; };
struct F_BFu7c_BFu16i { float v1; unsigned char v2:7; unsigned int v3:16; };
struct F_BFu7c_BFu16ll { float v1; unsigned char v2:7; unsigned long long v3:16; };
struct F_BFu7c_BFu16s { float v1; unsigned char v2:7; unsigned short v3:16; };
struct F_BFu7c_BFu17i { float v1; unsigned char v2:7; unsigned int v3:17; };
struct F_BFu7c_BFu17ll { float v1; unsigned char v2:7; unsigned long long v3:17; };
struct F_BFu7c_BFu1c { float v1; unsigned char v2:7; unsigned char v3:1; };
struct F_BFu7c_BFu1i { float v1; unsigned char v2:7; unsigned int v3:1; };
struct F_BFu7c_BFu1ll { float v1; unsigned char v2:7; unsigned long long v3:1; };
struct F_BFu7c_BFu1s { float v1; unsigned char v2:7; unsigned short v3:1; };
struct F_BFu7c_BFu31i { float v1; unsigned char v2:7; unsigned int v3:31; };
struct F_BFu7c_BFu31ll { float v1; unsigned char v2:7; unsigned long long v3:31; };
struct F_BFu7c_BFu32i { float v1; unsigned char v2:7; unsigned int v3:32; };
struct F_BFu7c_BFu32ll { float v1; unsigned char v2:7; unsigned long long v3:32; };
struct F_BFu7c_BFu33 { float v1; unsigned char v2:7; unsigned long long v3:33; };
struct F_BFu7c_BFu7c { float v1; unsigned char v2:7; unsigned char v3:7; };
struct F_BFu7c_BFu7i { float v1; unsigned char v2:7; unsigned int v3:7; };
struct F_BFu7c_BFu7ll { float v1; unsigned char v2:7; unsigned long long v3:7; };
struct F_BFu7c_BFu7s { float v1; unsigned char v2:7; unsigned short v3:7; };
struct F_BFu7c_BFu8c { float v1; unsigned char v2:7; unsigned char v3:8; };
struct F_BFu7c_BFu8i { float v1; unsigned char v2:7; unsigned int v3:8; };
struct F_BFu7c_BFu8ll { float v1; unsigned char v2:7; unsigned long long v3:8; };
struct F_BFu7c_BFu8s { float v1; unsigned char v2:7; unsigned short v3:8; };
struct F_BFu7c_BFu9i { float v1; unsigned char v2:7; unsigned int v3:9; };
struct F_BFu7c_BFu9ll { float v1; unsigned char v2:7; unsigned long long v3:9; };
struct F_BFu7c_BFu9s { float v1; unsigned char v2:7; unsigned short v3:9; };
struct F_BFu7c_C { float v1; unsigned char v2:7; char v3; };
struct F_BFu7c_D { float v1; unsigned char v2:7; double v3; };
struct F_BFu7c_F { float v1; unsigned char v2:7; float v3; };
struct F_BFu7c_I { float v1; unsigned char v2:7; int v3; };
struct F_BFu7c_Ip { float v1; unsigned char v2:7; int * v3; };
struct F_BFu7c_L { float v1; unsigned char v2:7; long long v3; };
struct F_BFu7c_S { float v1; unsigned char v2:7; short v3; };
struct F_BFu7c_Uc { float v1; unsigned char v2:7; unsigned char v3; };
struct F_BFu7c_Ui { float v1; unsigned char v2:7; unsigned int v3; };
struct F_BFu7c_Ul { float v1; unsigned char v2:7; unsigned long long v3; };
struct F_BFu7c_Us { float v1; unsigned char v2:7; unsigned short v3; };
struct F_BFu7c_Vp { float v1; unsigned char v2:7; void * v3; };
struct F_BFu7i { float v1; unsigned int v2:7; };
struct F_BFu7i_BFu15i { float v1; unsigned int v2:7; unsigned int v3:15; };
struct F_BFu7i_BFu15ll { float v1; unsigned int v2:7; unsigned long long v3:15; };
struct F_BFu7i_BFu15s { float v1; unsigned int v2:7; unsigned short v3:15; };
struct F_BFu7i_BFu16i { float v1; unsigned int v2:7; unsigned int v3:16; };
struct F_BFu7i_BFu16ll { float v1; unsigned int v2:7; unsigned long long v3:16; };
struct F_BFu7i_BFu16s { float v1; unsigned int v2:7; unsigned short v3:16; };
struct F_BFu7i_BFu17i { float v1; unsigned int v2:7; unsigned int v3:17; };
struct F_BFu7i_BFu17ll { float v1; unsigned int v2:7; unsigned long long v3:17; };
struct F_BFu7i_BFu1c { float v1; unsigned int v2:7; unsigned char v3:1; };
struct F_BFu7i_BFu1i { float v1; unsigned int v2:7; unsigned int v3:1; };
struct F_BFu7i_BFu1ll { float v1; unsigned int v2:7; unsigned long long v3:1; };
struct F_BFu7i_BFu1s { float v1; unsigned int v2:7; unsigned short v3:1; };
struct F_BFu7i_BFu31i { float v1; unsigned int v2:7; unsigned int v3:31; };
struct F_BFu7i_BFu31ll { float v1; unsigned int v2:7; unsigned long long v3:31; };
struct F_BFu7i_BFu32i { float v1; unsigned int v2:7; unsigned int v3:32; };
struct F_BFu7i_BFu32ll { float v1; unsigned int v2:7; unsigned long long v3:32; };
struct F_BFu7i_BFu33 { float v1; unsigned int v2:7; unsigned long long v3:33; };
struct F_BFu7i_BFu7c { float v1; unsigned int v2:7; unsigned char v3:7; };
struct F_BFu7i_BFu7i { float v1; unsigned int v2:7; unsigned int v3:7; };
struct F_BFu7i_BFu7ll { float v1; unsigned int v2:7; unsigned long long v3:7; };
struct F_BFu7i_BFu7s { float v1; unsigned int v2:7; unsigned short v3:7; };
struct F_BFu7i_BFu8c { float v1; unsigned int v2:7; unsigned char v3:8; };
struct F_BFu7i_BFu8i { float v1; unsigned int v2:7; unsigned int v3:8; };
struct F_BFu7i_BFu8ll { float v1; unsigned int v2:7; unsigned long long v3:8; };
struct F_BFu7i_BFu8s { float v1; unsigned int v2:7; unsigned short v3:8; };
struct F_BFu7i_BFu9i { float v1; unsigned int v2:7; unsigned int v3:9; };
struct F_BFu7i_BFu9ll { float v1; unsigned int v2:7; unsigned long long v3:9; };
struct F_BFu7i_BFu9s { float v1; unsigned int v2:7; unsigned short v3:9; };
struct F_BFu7i_C { float v1; unsigned int v2:7; char v3; };
struct F_BFu7i_D { float v1; unsigned int v2:7; double v3; };
struct F_BFu7i_F { float v1; unsigned int v2:7; float v3; };
struct F_BFu7i_I { float v1; unsigned int v2:7; int v3; };
struct F_BFu7i_Ip { float v1; unsigned int v2:7; int * v3; };
struct F_BFu7i_L { float v1; unsigned int v2:7; long long v3; };
struct F_BFu7i_S { float v1; unsigned int v2:7; short v3; };
struct F_BFu7i_Uc { float v1; unsigned int v2:7; unsigned char v3; };
struct F_BFu7i_Ui { float v1; unsigned int v2:7; unsigned int v3; };
struct F_BFu7i_Ul { float v1; unsigned int v2:7; unsigned long long v3; };
struct F_BFu7i_Us { float v1; unsigned int v2:7; unsigned short v3; };
struct F_BFu7i_Vp { float v1; unsigned int v2:7; void * v3; };
struct F_BFu7ll { float v1; unsigned long long v2:7; };
struct F_BFu7ll_BFu15i { float v1; unsigned long long v2:7; unsigned int v3:15; };
struct F_BFu7ll_BFu15ll { float v1; unsigned long long v2:7; unsigned long long v3:15; };
struct F_BFu7ll_BFu15s { float v1; unsigned long long v2:7; unsigned short v3:15; };
struct F_BFu7ll_BFu16i { float v1; unsigned long long v2:7; unsigned int v3:16; };
struct F_BFu7ll_BFu16ll { float v1; unsigned long long v2:7; unsigned long long v3:16; };
struct F_BFu7ll_BFu16s { float v1; unsigned long long v2:7; unsigned short v3:16; };
struct F_BFu7ll_BFu17i { float v1; unsigned long long v2:7; unsigned int v3:17; };
struct F_BFu7ll_BFu17ll { float v1; unsigned long long v2:7; unsigned long long v3:17; };
struct F_BFu7ll_BFu1c { float v1; unsigned long long v2:7; unsigned char v3:1; };
struct F_BFu7ll_BFu1i { float v1; unsigned long long v2:7; unsigned int v3:1; };
struct F_BFu7ll_BFu1ll { float v1; unsigned long long v2:7; unsigned long long v3:1; };
struct F_BFu7ll_BFu1s { float v1; unsigned long long v2:7; unsigned short v3:1; };
struct F_BFu7ll_BFu31i { float v1; unsigned long long v2:7; unsigned int v3:31; };
struct F_BFu7ll_BFu31ll { float v1; unsigned long long v2:7; unsigned long long v3:31; };
struct F_BFu7ll_BFu32i { float v1; unsigned long long v2:7; unsigned int v3:32; };
struct F_BFu7ll_BFu32ll { float v1; unsigned long long v2:7; unsigned long long v3:32; };
struct F_BFu7ll_BFu33 { float v1; unsigned long long v2:7; unsigned long long v3:33; };
struct F_BFu7ll_BFu7c { float v1; unsigned long long v2:7; unsigned char v3:7; };
struct F_BFu7ll_BFu7i { float v1; unsigned long long v2:7; unsigned int v3:7; };
struct F_BFu7ll_BFu7ll { float v1; unsigned long long v2:7; unsigned long long v3:7; };
struct F_BFu7ll_BFu7s { float v1; unsigned long long v2:7; unsigned short v3:7; };
struct F_BFu7ll_BFu8c { float v1; unsigned long long v2:7; unsigned char v3:8; };
struct F_BFu7ll_BFu8i { float v1; unsigned long long v2:7; unsigned int v3:8; };
struct F_BFu7ll_BFu8ll { float v1; unsigned long long v2:7; unsigned long long v3:8; };
struct F_BFu7ll_BFu8s { float v1; unsigned long long v2:7; unsigned short v3:8; };
struct F_BFu7ll_BFu9i { float v1; unsigned long long v2:7; unsigned int v3:9; };
struct F_BFu7ll_BFu9ll { float v1; unsigned long long v2:7; unsigned long long v3:9; };
struct F_BFu7ll_BFu9s { float v1; unsigned long long v2:7; unsigned short v3:9; };
struct F_BFu7ll_C { float v1; unsigned long long v2:7; char v3; };
struct F_BFu7ll_D { float v1; unsigned long long v2:7; double v3; };
struct F_BFu7ll_F { float v1; unsigned long long v2:7; float v3; };
struct F_BFu7ll_I { float v1; unsigned long long v2:7; int v3; };
struct F_BFu7ll_Ip { float v1; unsigned long long v2:7; int * v3; };
struct F_BFu7ll_L { float v1; unsigned long long v2:7; long long v3; };
struct F_BFu7ll_S { float v1; unsigned long long v2:7; short v3; };
struct F_BFu7ll_Uc { float v1; unsigned long long v2:7; unsigned char v3; };
struct F_BFu7ll_Ui { float v1; unsigned long long v2:7; unsigned int v3; };
struct F_BFu7ll_Ul { float v1; unsigned long long v2:7; unsigned long long v3; };
struct F_BFu7ll_Us { float v1; unsigned long long v2:7; unsigned short v3; };
struct F_BFu7ll_Vp { float v1; unsigned long long v2:7; void * v3; };
struct F_BFu7s { float v1; unsigned short v2:7; };
struct F_BFu7s_BFu15i { float v1; unsigned short v2:7; unsigned int v3:15; };
struct F_BFu7s_BFu15ll { float v1; unsigned short v2:7; unsigned long long v3:15; };
struct F_BFu7s_BFu15s { float v1; unsigned short v2:7; unsigned short v3:15; };
struct F_BFu7s_BFu16i { float v1; unsigned short v2:7; unsigned int v3:16; };
struct F_BFu7s_BFu16ll { float v1; unsigned short v2:7; unsigned long long v3:16; };
struct F_BFu7s_BFu16s { float v1; unsigned short v2:7; unsigned short v3:16; };
struct F_BFu7s_BFu17i { float v1; unsigned short v2:7; unsigned int v3:17; };
struct F_BFu7s_BFu17ll { float v1; unsigned short v2:7; unsigned long long v3:17; };
struct F_BFu7s_BFu1c { float v1; unsigned short v2:7; unsigned char v3:1; };
struct F_BFu7s_BFu1i { float v1; unsigned short v2:7; unsigned int v3:1; };
struct F_BFu7s_BFu1ll { float v1; unsigned short v2:7; unsigned long long v3:1; };
struct F_BFu7s_BFu1s { float v1; unsigned short v2:7; unsigned short v3:1; };
struct F_BFu7s_BFu31i { float v1; unsigned short v2:7; unsigned int v3:31; };
struct F_BFu7s_BFu31ll { float v1; unsigned short v2:7; unsigned long long v3:31; };
struct F_BFu7s_BFu32i { float v1; unsigned short v2:7; unsigned int v3:32; };
struct F_BFu7s_BFu32ll { float v1; unsigned short v2:7; unsigned long long v3:32; };
struct F_BFu7s_BFu33 { float v1; unsigned short v2:7; unsigned long long v3:33; };
struct F_BFu7s_BFu7c { float v1; unsigned short v2:7; unsigned char v3:7; };
struct F_BFu7s_BFu7i { float v1; unsigned short v2:7; unsigned int v3:7; };
struct F_BFu7s_BFu7ll { float v1; unsigned short v2:7; unsigned long long v3:7; };
struct F_BFu7s_BFu7s { float v1; unsigned short v2:7; unsigned short v3:7; };
struct F_BFu7s_BFu8c { float v1; unsigned short v2:7; unsigned char v3:8; };
struct F_BFu7s_BFu8i { float v1; unsigned short v2:7; unsigned int v3:8; };
struct F_BFu7s_BFu8ll { float v1; unsigned short v2:7; unsigned long long v3:8; };
struct F_BFu7s_BFu8s { float v1; unsigned short v2:7; unsigned short v3:8; };
struct F_BFu7s_BFu9i { float v1; unsigned short v2:7; unsigned int v3:9; };
struct F_BFu7s_BFu9ll { float v1; unsigned short v2:7; unsigned long long v3:9; };
struct F_BFu7s_BFu9s { float v1; unsigned short v2:7; unsigned short v3:9; };
struct F_BFu7s_C { float v1; unsigned short v2:7; char v3; };
struct F_BFu7s_D { float v1; unsigned short v2:7; double v3; };
struct F_BFu7s_F { float v1; unsigned short v2:7; float v3; };
struct F_BFu7s_I { float v1; unsigned short v2:7; int v3; };
struct F_BFu7s_Ip { float v1; unsigned short v2:7; int * v3; };
struct F_BFu7s_L { float v1; unsigned short v2:7; long long v3; };
struct F_BFu7s_S { float v1; unsigned short v2:7; short v3; };
struct F_BFu7s_Uc { float v1; unsigned short v2:7; unsigned char v3; };
struct F_BFu7s_Ui { float v1; unsigned short v2:7; unsigned int v3; };
struct F_BFu7s_Ul { float v1; unsigned short v2:7; unsigned long long v3; };
struct F_BFu7s_Us { float v1; unsigned short v2:7; unsigned short v3; };
struct F_BFu7s_Vp { float v1; unsigned short v2:7; void * v3; };
struct F_BFu8c { float v1; unsigned char v2:8; };
struct F_BFu8c_BFu15i { float v1; unsigned char v2:8; unsigned int v3:15; };
struct F_BFu8c_BFu15ll { float v1; unsigned char v2:8; unsigned long long v3:15; };
struct F_BFu8c_BFu15s { float v1; unsigned char v2:8; unsigned short v3:15; };
struct F_BFu8c_BFu16i { float v1; unsigned char v2:8; unsigned int v3:16; };
struct F_BFu8c_BFu16ll { float v1; unsigned char v2:8; unsigned long long v3:16; };
struct F_BFu8c_BFu16s { float v1; unsigned char v2:8; unsigned short v3:16; };
struct F_BFu8c_BFu17i { float v1; unsigned char v2:8; unsigned int v3:17; };
struct F_BFu8c_BFu17ll { float v1; unsigned char v2:8; unsigned long long v3:17; };
struct F_BFu8c_BFu1c { float v1; unsigned char v2:8; unsigned char v3:1; };
struct F_BFu8c_BFu1i { float v1; unsigned char v2:8; unsigned int v3:1; };
struct F_BFu8c_BFu1ll { float v1; unsigned char v2:8; unsigned long long v3:1; };
struct F_BFu8c_BFu1s { float v1; unsigned char v2:8; unsigned short v3:1; };
struct F_BFu8c_BFu31i { float v1; unsigned char v2:8; unsigned int v3:31; };
struct F_BFu8c_BFu31ll { float v1; unsigned char v2:8; unsigned long long v3:31; };
struct F_BFu8c_BFu32i { float v1; unsigned char v2:8; unsigned int v3:32; };
struct F_BFu8c_BFu32ll { float v1; unsigned char v2:8; unsigned long long v3:32; };
struct F_BFu8c_BFu33 { float v1; unsigned char v2:8; unsigned long long v3:33; };
struct F_BFu8c_BFu7c { float v1; unsigned char v2:8; unsigned char v3:7; };
struct F_BFu8c_BFu7i { float v1; unsigned char v2:8; unsigned int v3:7; };
struct F_BFu8c_BFu7ll { float v1; unsigned char v2:8; unsigned long long v3:7; };
struct F_BFu8c_BFu7s { float v1; unsigned char v2:8; unsigned short v3:7; };
struct F_BFu8c_BFu8c { float v1; unsigned char v2:8; unsigned char v3:8; };
struct F_BFu8c_BFu8i { float v1; unsigned char v2:8; unsigned int v3:8; };
struct F_BFu8c_BFu8ll { float v1; unsigned char v2:8; unsigned long long v3:8; };
struct F_BFu8c_BFu8s { float v1; unsigned char v2:8; unsigned short v3:8; };
struct F_BFu8c_BFu9i { float v1; unsigned char v2:8; unsigned int v3:9; };
struct F_BFu8c_BFu9ll { float v1; unsigned char v2:8; unsigned long long v3:9; };
struct F_BFu8c_BFu9s { float v1; unsigned char v2:8; unsigned short v3:9; };
struct F_BFu8c_C { float v1; unsigned char v2:8; char v3; };
struct F_BFu8c_D { float v1; unsigned char v2:8; double v3; };
struct F_BFu8c_F { float v1; unsigned char v2:8; float v3; };
struct F_BFu8c_I { float v1; unsigned char v2:8; int v3; };
struct F_BFu8c_Ip { float v1; unsigned char v2:8; int * v3; };
struct F_BFu8c_L { float v1; unsigned char v2:8; long long v3; };
struct F_BFu8c_S { float v1; unsigned char v2:8; short v3; };
struct F_BFu8c_Uc { float v1; unsigned char v2:8; unsigned char v3; };
struct F_BFu8c_Ui { float v1; unsigned char v2:8; unsigned int v3; };
struct F_BFu8c_Ul { float v1; unsigned char v2:8; unsigned long long v3; };
struct F_BFu8c_Us { float v1; unsigned char v2:8; unsigned short v3; };
struct F_BFu8c_Vp { float v1; unsigned char v2:8; void * v3; };
struct F_BFu8i { float v1; unsigned int v2:8; };
struct F_BFu8i_BFu15i { float v1; unsigned int v2:8; unsigned int v3:15; };
struct F_BFu8i_BFu15ll { float v1; unsigned int v2:8; unsigned long long v3:15; };
struct F_BFu8i_BFu15s { float v1; unsigned int v2:8; unsigned short v3:15; };
struct F_BFu8i_BFu16i { float v1; unsigned int v2:8; unsigned int v3:16; };
struct F_BFu8i_BFu16ll { float v1; unsigned int v2:8; unsigned long long v3:16; };
struct F_BFu8i_BFu16s { float v1; unsigned int v2:8; unsigned short v3:16; };
struct F_BFu8i_BFu17i { float v1; unsigned int v2:8; unsigned int v3:17; };
struct F_BFu8i_BFu17ll { float v1; unsigned int v2:8; unsigned long long v3:17; };
struct F_BFu8i_BFu1c { float v1; unsigned int v2:8; unsigned char v3:1; };
struct F_BFu8i_BFu1i { float v1; unsigned int v2:8; unsigned int v3:1; };
struct F_BFu8i_BFu1ll { float v1; unsigned int v2:8; unsigned long long v3:1; };
struct F_BFu8i_BFu1s { float v1; unsigned int v2:8; unsigned short v3:1; };
struct F_BFu8i_BFu31i { float v1; unsigned int v2:8; unsigned int v3:31; };
struct F_BFu8i_BFu31ll { float v1; unsigned int v2:8; unsigned long long v3:31; };
struct F_BFu8i_BFu32i { float v1; unsigned int v2:8; unsigned int v3:32; };
struct F_BFu8i_BFu32ll { float v1; unsigned int v2:8; unsigned long long v3:32; };
struct F_BFu8i_BFu33 { float v1; unsigned int v2:8; unsigned long long v3:33; };
struct F_BFu8i_BFu7c { float v1; unsigned int v2:8; unsigned char v3:7; };
struct F_BFu8i_BFu7i { float v1; unsigned int v2:8; unsigned int v3:7; };
struct F_BFu8i_BFu7ll { float v1; unsigned int v2:8; unsigned long long v3:7; };
struct F_BFu8i_BFu7s { float v1; unsigned int v2:8; unsigned short v3:7; };
struct F_BFu8i_BFu8c { float v1; unsigned int v2:8; unsigned char v3:8; };
struct F_BFu8i_BFu8i { float v1; unsigned int v2:8; unsigned int v3:8; };
struct F_BFu8i_BFu8ll { float v1; unsigned int v2:8; unsigned long long v3:8; };
struct F_BFu8i_BFu8s { float v1; unsigned int v2:8; unsigned short v3:8; };
struct F_BFu8i_BFu9i { float v1; unsigned int v2:8; unsigned int v3:9; };
struct F_BFu8i_BFu9ll { float v1; unsigned int v2:8; unsigned long long v3:9; };
struct F_BFu8i_BFu9s { float v1; unsigned int v2:8; unsigned short v3:9; };
struct F_BFu8i_C { float v1; unsigned int v2:8; char v3; };
struct F_BFu8i_D { float v1; unsigned int v2:8; double v3; };
struct F_BFu8i_F { float v1; unsigned int v2:8; float v3; };
struct F_BFu8i_I { float v1; unsigned int v2:8; int v3; };
struct F_BFu8i_Ip { float v1; unsigned int v2:8; int * v3; };
struct F_BFu8i_L { float v1; unsigned int v2:8; long long v3; };
struct F_BFu8i_S { float v1; unsigned int v2:8; short v3; };
struct F_BFu8i_Uc { float v1; unsigned int v2:8; unsigned char v3; };
struct F_BFu8i_Ui { float v1; unsigned int v2:8; unsigned int v3; };
struct F_BFu8i_Ul { float v1; unsigned int v2:8; unsigned long long v3; };
struct F_BFu8i_Us { float v1; unsigned int v2:8; unsigned short v3; };
struct F_BFu8i_Vp { float v1; unsigned int v2:8; void * v3; };
struct F_BFu8ll { float v1; unsigned long long v2:8; };
struct F_BFu8ll_BFu15i { float v1; unsigned long long v2:8; unsigned int v3:15; };
struct F_BFu8ll_BFu15ll { float v1; unsigned long long v2:8; unsigned long long v3:15; };
struct F_BFu8ll_BFu15s { float v1; unsigned long long v2:8; unsigned short v3:15; };
struct F_BFu8ll_BFu16i { float v1; unsigned long long v2:8; unsigned int v3:16; };
struct F_BFu8ll_BFu16ll { float v1; unsigned long long v2:8; unsigned long long v3:16; };
struct F_BFu8ll_BFu16s { float v1; unsigned long long v2:8; unsigned short v3:16; };
struct F_BFu8ll_BFu17i { float v1; unsigned long long v2:8; unsigned int v3:17; };
struct F_BFu8ll_BFu17ll { float v1; unsigned long long v2:8; unsigned long long v3:17; };
struct F_BFu8ll_BFu1c { float v1; unsigned long long v2:8; unsigned char v3:1; };
struct F_BFu8ll_BFu1i { float v1; unsigned long long v2:8; unsigned int v3:1; };
struct F_BFu8ll_BFu1ll { float v1; unsigned long long v2:8; unsigned long long v3:1; };
struct F_BFu8ll_BFu1s { float v1; unsigned long long v2:8; unsigned short v3:1; };
struct F_BFu8ll_BFu31i { float v1; unsigned long long v2:8; unsigned int v3:31; };
struct F_BFu8ll_BFu31ll { float v1; unsigned long long v2:8; unsigned long long v3:31; };
struct F_BFu8ll_BFu32i { float v1; unsigned long long v2:8; unsigned int v3:32; };
struct F_BFu8ll_BFu32ll { float v1; unsigned long long v2:8; unsigned long long v3:32; };
struct F_BFu8ll_BFu33 { float v1; unsigned long long v2:8; unsigned long long v3:33; };
struct F_BFu8ll_BFu7c { float v1; unsigned long long v2:8; unsigned char v3:7; };
struct F_BFu8ll_BFu7i { float v1; unsigned long long v2:8; unsigned int v3:7; };
struct F_BFu8ll_BFu7ll { float v1; unsigned long long v2:8; unsigned long long v3:7; };
struct F_BFu8ll_BFu7s { float v1; unsigned long long v2:8; unsigned short v3:7; };
struct F_BFu8ll_BFu8c { float v1; unsigned long long v2:8; unsigned char v3:8; };
struct F_BFu8ll_BFu8i { float v1; unsigned long long v2:8; unsigned int v3:8; };
struct F_BFu8ll_BFu8ll { float v1; unsigned long long v2:8; unsigned long long v3:8; };
struct F_BFu8ll_BFu8s { float v1; unsigned long long v2:8; unsigned short v3:8; };
struct F_BFu8ll_BFu9i { float v1; unsigned long long v2:8; unsigned int v3:9; };
struct F_BFu8ll_BFu9ll { float v1; unsigned long long v2:8; unsigned long long v3:9; };
struct F_BFu8ll_BFu9s { float v1; unsigned long long v2:8; unsigned short v3:9; };
struct F_BFu8ll_C { float v1; unsigned long long v2:8; char v3; };
struct F_BFu8ll_D { float v1; unsigned long long v2:8; double v3; };
struct F_BFu8ll_F { float v1; unsigned long long v2:8; float v3; };
struct F_BFu8ll_I { float v1; unsigned long long v2:8; int v3; };
struct F_BFu8ll_Ip { float v1; unsigned long long v2:8; int * v3; };
struct F_BFu8ll_L { float v1; unsigned long long v2:8; long long v3; };
struct F_BFu8ll_S { float v1; unsigned long long v2:8; short v3; };
struct F_BFu8ll_Uc { float v1; unsigned long long v2:8; unsigned char v3; };
struct F_BFu8ll_Ui { float v1; unsigned long long v2:8; unsigned int v3; };
struct F_BFu8ll_Ul { float v1; unsigned long long v2:8; unsigned long long v3; };
struct F_BFu8ll_Us { float v1; unsigned long long v2:8; unsigned short v3; };
struct F_BFu8ll_Vp { float v1; unsigned long long v2:8; void * v3; };
struct F_BFu8s { float v1; unsigned short v2:8; };
struct F_BFu8s_BFu15i { float v1; unsigned short v2:8; unsigned int v3:15; };
struct F_BFu8s_BFu15ll { float v1; unsigned short v2:8; unsigned long long v3:15; };
struct F_BFu8s_BFu15s { float v1; unsigned short v2:8; unsigned short v3:15; };
struct F_BFu8s_BFu16i { float v1; unsigned short v2:8; unsigned int v3:16; };
struct F_BFu8s_BFu16ll { float v1; unsigned short v2:8; unsigned long long v3:16; };
struct F_BFu8s_BFu16s { float v1; unsigned short v2:8; unsigned short v3:16; };
struct F_BFu8s_BFu17i { float v1; unsigned short v2:8; unsigned int v3:17; };
struct F_BFu8s_BFu17ll { float v1; unsigned short v2:8; unsigned long long v3:17; };
struct F_BFu8s_BFu1c { float v1; unsigned short v2:8; unsigned char v3:1; };
struct F_BFu8s_BFu1i { float v1; unsigned short v2:8; unsigned int v3:1; };
struct F_BFu8s_BFu1ll { float v1; unsigned short v2:8; unsigned long long v3:1; };
struct F_BFu8s_BFu1s { float v1; unsigned short v2:8; unsigned short v3:1; };
struct F_BFu8s_BFu31i { float v1; unsigned short v2:8; unsigned int v3:31; };
struct F_BFu8s_BFu31ll { float v1; unsigned short v2:8; unsigned long long v3:31; };
struct F_BFu8s_BFu32i { float v1; unsigned short v2:8; unsigned int v3:32; };
struct F_BFu8s_BFu32ll { float v1; unsigned short v2:8; unsigned long long v3:32; };
struct F_BFu8s_BFu33 { float v1; unsigned short v2:8; unsigned long long v3:33; };
struct F_BFu8s_BFu7c { float v1; unsigned short v2:8; unsigned char v3:7; };
struct F_BFu8s_BFu7i { float v1; unsigned short v2:8; unsigned int v3:7; };
struct F_BFu8s_BFu7ll { float v1; unsigned short v2:8; unsigned long long v3:7; };
struct F_BFu8s_BFu7s { float v1; unsigned short v2:8; unsigned short v3:7; };
struct F_BFu8s_BFu8c { float v1; unsigned short v2:8; unsigned char v3:8; };
struct F_BFu8s_BFu8i { float v1; unsigned short v2:8; unsigned int v3:8; };
struct F_BFu8s_BFu8ll { float v1; unsigned short v2:8; unsigned long long v3:8; };
struct F_BFu8s_BFu8s { float v1; unsigned short v2:8; unsigned short v3:8; };
struct F_BFu8s_BFu9i { float v1; unsigned short v2:8; unsigned int v3:9; };
struct F_BFu8s_BFu9ll { float v1; unsigned short v2:8; unsigned long long v3:9; };
struct F_BFu8s_BFu9s { float v1; unsigned short v2:8; unsigned short v3:9; };
struct F_BFu8s_C { float v1; unsigned short v2:8; char v3; };
struct F_BFu8s_D { float v1; unsigned short v2:8; double v3; };
struct F_BFu8s_F { float v1; unsigned short v2:8; float v3; };
struct F_BFu8s_I { float v1; unsigned short v2:8; int v3; };
struct F_BFu8s_Ip { float v1; unsigned short v2:8; int * v3; };
struct F_BFu8s_L { float v1; unsigned short v2:8; long long v3; };
struct F_BFu8s_S { float v1; unsigned short v2:8; short v3; };
struct F_BFu8s_Uc { float v1; unsigned short v2:8; unsigned char v3; };
struct F_BFu8s_Ui { float v1; unsigned short v2:8; unsigned int v3; };
struct F_BFu8s_Ul { float v1; unsigned short v2:8; unsigned long long v3; };
struct F_BFu8s_Us { float v1; unsigned short v2:8; unsigned short v3; };
struct F_BFu8s_Vp { float v1; unsigned short v2:8; void * v3; };
struct F_BFu9i { float v1; unsigned int v2:9; };
struct F_BFu9i_BFu15i { float v1; unsigned int v2:9; unsigned int v3:15; };
struct F_BFu9i_BFu15ll { float v1; unsigned int v2:9; unsigned long long v3:15; };
struct F_BFu9i_BFu15s { float v1; unsigned int v2:9; unsigned short v3:15; };
struct F_BFu9i_BFu16i { float v1; unsigned int v2:9; unsigned int v3:16; };
struct F_BFu9i_BFu16ll { float v1; unsigned int v2:9; unsigned long long v3:16; };
struct F_BFu9i_BFu16s { float v1; unsigned int v2:9; unsigned short v3:16; };
struct F_BFu9i_BFu17i { float v1; unsigned int v2:9; unsigned int v3:17; };
struct F_BFu9i_BFu17ll { float v1; unsigned int v2:9; unsigned long long v3:17; };
struct F_BFu9i_BFu1c { float v1; unsigned int v2:9; unsigned char v3:1; };
struct F_BFu9i_BFu1i { float v1; unsigned int v2:9; unsigned int v3:1; };
struct F_BFu9i_BFu1ll { float v1; unsigned int v2:9; unsigned long long v3:1; };
struct F_BFu9i_BFu1s { float v1; unsigned int v2:9; unsigned short v3:1; };
struct F_BFu9i_BFu31i { float v1; unsigned int v2:9; unsigned int v3:31; };
struct F_BFu9i_BFu31ll { float v1; unsigned int v2:9; unsigned long long v3:31; };
struct F_BFu9i_BFu32i { float v1; unsigned int v2:9; unsigned int v3:32; };
struct F_BFu9i_BFu32ll { float v1; unsigned int v2:9; unsigned long long v3:32; };
struct F_BFu9i_BFu33 { float v1; unsigned int v2:9; unsigned long long v3:33; };
struct F_BFu9i_BFu7c { float v1; unsigned int v2:9; unsigned char v3:7; };
struct F_BFu9i_BFu7i { float v1; unsigned int v2:9; unsigned int v3:7; };
struct F_BFu9i_BFu7ll { float v1; unsigned int v2:9; unsigned long long v3:7; };
struct F_BFu9i_BFu7s { float v1; unsigned int v2:9; unsigned short v3:7; };
struct F_BFu9i_BFu8c { float v1; unsigned int v2:9; unsigned char v3:8; };
struct F_BFu9i_BFu8i { float v1; unsigned int v2:9; unsigned int v3:8; };
struct F_BFu9i_BFu8ll { float v1; unsigned int v2:9; unsigned long long v3:8; };
struct F_BFu9i_BFu8s { float v1; unsigned int v2:9; unsigned short v3:8; };
struct F_BFu9i_BFu9i { float v1; unsigned int v2:9; unsigned int v3:9; };
struct F_BFu9i_BFu9ll { float v1; unsigned int v2:9; unsigned long long v3:9; };
struct F_BFu9i_BFu9s { float v1; unsigned int v2:9; unsigned short v3:9; };
struct F_BFu9i_C { float v1; unsigned int v2:9; char v3; };
struct F_BFu9i_D { float v1; unsigned int v2:9; double v3; };
struct F_BFu9i_F { float v1; unsigned int v2:9; float v3; };
struct F_BFu9i_I { float v1; unsigned int v2:9; int v3; };
struct F_BFu9i_Ip { float v1; unsigned int v2:9; int * v3; };
struct F_BFu9i_L { float v1; unsigned int v2:9; long long v3; };
struct F_BFu9i_S { float v1; unsigned int v2:9; short v3; };
struct F_BFu9i_Uc { float v1; unsigned int v2:9; unsigned char v3; };
struct F_BFu9i_Ui { float v1; unsigned int v2:9; unsigned int v3; };
struct F_BFu9i_Ul { float v1; unsigned int v2:9; unsigned long long v3; };
struct F_BFu9i_Us { float v1; unsigned int v2:9; unsigned short v3; };
struct F_BFu9i_Vp { float v1; unsigned int v2:9; void * v3; };
struct F_BFu9ll { float v1; unsigned long long v2:9; };
struct F_BFu9ll_BFu15i { float v1; unsigned long long v2:9; unsigned int v3:15; };
struct F_BFu9ll_BFu15ll { float v1; unsigned long long v2:9; unsigned long long v3:15; };
struct F_BFu9ll_BFu15s { float v1; unsigned long long v2:9; unsigned short v3:15; };
struct F_BFu9ll_BFu16i { float v1; unsigned long long v2:9; unsigned int v3:16; };
struct F_BFu9ll_BFu16ll { float v1; unsigned long long v2:9; unsigned long long v3:16; };
struct F_BFu9ll_BFu16s { float v1; unsigned long long v2:9; unsigned short v3:16; };
struct F_BFu9ll_BFu17i { float v1; unsigned long long v2:9; unsigned int v3:17; };
struct F_BFu9ll_BFu17ll { float v1; unsigned long long v2:9; unsigned long long v3:17; };
struct F_BFu9ll_BFu1c { float v1; unsigned long long v2:9; unsigned char v3:1; };
struct F_BFu9ll_BFu1i { float v1; unsigned long long v2:9; unsigned int v3:1; };
struct F_BFu9ll_BFu1ll { float v1; unsigned long long v2:9; unsigned long long v3:1; };
struct F_BFu9ll_BFu1s { float v1; unsigned long long v2:9; unsigned short v3:1; };
struct F_BFu9ll_BFu31i { float v1; unsigned long long v2:9; unsigned int v3:31; };
struct F_BFu9ll_BFu31ll { float v1; unsigned long long v2:9; unsigned long long v3:31; };
struct F_BFu9ll_BFu32i { float v1; unsigned long long v2:9; unsigned int v3:32; };
struct F_BFu9ll_BFu32ll { float v1; unsigned long long v2:9; unsigned long long v3:32; };
struct F_BFu9ll_BFu33 { float v1; unsigned long long v2:9; unsigned long long v3:33; };
struct F_BFu9ll_BFu7c { float v1; unsigned long long v2:9; unsigned char v3:7; };
struct F_BFu9ll_BFu7i { float v1; unsigned long long v2:9; unsigned int v3:7; };
struct F_BFu9ll_BFu7ll { float v1; unsigned long long v2:9; unsigned long long v3:7; };
struct F_BFu9ll_BFu7s { float v1; unsigned long long v2:9; unsigned short v3:7; };
struct F_BFu9ll_BFu8c { float v1; unsigned long long v2:9; unsigned char v3:8; };
struct F_BFu9ll_BFu8i { float v1; unsigned long long v2:9; unsigned int v3:8; };
struct F_BFu9ll_BFu8ll { float v1; unsigned long long v2:9; unsigned long long v3:8; };
struct F_BFu9ll_BFu8s { float v1; unsigned long long v2:9; unsigned short v3:8; };
struct F_BFu9ll_BFu9i { float v1; unsigned long long v2:9; unsigned int v3:9; };
struct F_BFu9ll_BFu9ll { float v1; unsigned long long v2:9; unsigned long long v3:9; };
struct F_BFu9ll_BFu9s { float v1; unsigned long long v2:9; unsigned short v3:9; };
struct F_BFu9ll_C { float v1; unsigned long long v2:9; char v3; };
struct F_BFu9ll_D { float v1; unsigned long long v2:9; double v3; };
struct F_BFu9ll_F { float v1; unsigned long long v2:9; float v3; };
struct F_BFu9ll_I { float v1; unsigned long long v2:9; int v3; };
struct F_BFu9ll_Ip { float v1; unsigned long long v2:9; int * v3; };
struct F_BFu9ll_L { float v1; unsigned long long v2:9; long long v3; };
struct F_BFu9ll_S { float v1; unsigned long long v2:9; short v3; };
struct F_BFu9ll_Uc { float v1; unsigned long long v2:9; unsigned char v3; };
struct F_BFu9ll_Ui { float v1; unsigned long long v2:9; unsigned int v3; };
struct F_BFu9ll_Ul { float v1; unsigned long long v2:9; unsigned long long v3; };
struct F_BFu9ll_Us { float v1; unsigned long long v2:9; unsigned short v3; };
struct F_BFu9ll_Vp { float v1; unsigned long long v2:9; void * v3; };
struct F_BFu9s { float v1; unsigned short v2:9; };
struct F_BFu9s_BFu15i { float v1; unsigned short v2:9; unsigned int v3:15; };
struct F_BFu9s_BFu15ll { float v1; unsigned short v2:9; unsigned long long v3:15; };
struct F_BFu9s_BFu15s { float v1; unsigned short v2:9; unsigned short v3:15; };
struct F_BFu9s_BFu16i { float v1; unsigned short v2:9; unsigned int v3:16; };
struct F_BFu9s_BFu16ll { float v1; unsigned short v2:9; unsigned long long v3:16; };
struct F_BFu9s_BFu16s { float v1; unsigned short v2:9; unsigned short v3:16; };
struct F_BFu9s_BFu17i { float v1; unsigned short v2:9; unsigned int v3:17; };
struct F_BFu9s_BFu17ll { float v1; unsigned short v2:9; unsigned long long v3:17; };
struct F_BFu9s_BFu1c { float v1; unsigned short v2:9; unsigned char v3:1; };
struct F_BFu9s_BFu1i { float v1; unsigned short v2:9; unsigned int v3:1; };
struct F_BFu9s_BFu1ll { float v1; unsigned short v2:9; unsigned long long v3:1; };
struct F_BFu9s_BFu1s { float v1; unsigned short v2:9; unsigned short v3:1; };
struct F_BFu9s_BFu31i { float v1; unsigned short v2:9; unsigned int v3:31; };
struct F_BFu9s_BFu31ll { float v1; unsigned short v2:9; unsigned long long v3:31; };
struct F_BFu9s_BFu32i { float v1; unsigned short v2:9; unsigned int v3:32; };
struct F_BFu9s_BFu32ll { float v1; unsigned short v2:9; unsigned long long v3:32; };
struct F_BFu9s_BFu33 { float v1; unsigned short v2:9; unsigned long long v3:33; };
struct F_BFu9s_BFu7c { float v1; unsigned short v2:9; unsigned char v3:7; };
struct F_BFu9s_BFu7i { float v1; unsigned short v2:9; unsigned int v3:7; };
struct F_BFu9s_BFu7ll { float v1; unsigned short v2:9; unsigned long long v3:7; };
struct F_BFu9s_BFu7s { float v1; unsigned short v2:9; unsigned short v3:7; };
struct F_BFu9s_BFu8c { float v1; unsigned short v2:9; unsigned char v3:8; };
struct F_BFu9s_BFu8i { float v1; unsigned short v2:9; unsigned int v3:8; };
struct F_BFu9s_BFu8ll { float v1; unsigned short v2:9; unsigned long long v3:8; };
struct F_BFu9s_BFu8s { float v1; unsigned short v2:9; unsigned short v3:8; };
struct F_BFu9s_BFu9i { float v1; unsigned short v2:9; unsigned int v3:9; };
struct F_BFu9s_BFu9ll { float v1; unsigned short v2:9; unsigned long long v3:9; };
struct F_BFu9s_BFu9s { float v1; unsigned short v2:9; unsigned short v3:9; };
struct F_BFu9s_C { float v1; unsigned short v2:9; char v3; };
struct F_BFu9s_D { float v1; unsigned short v2:9; double v3; };
struct F_BFu9s_F { float v1; unsigned short v2:9; float v3; };
struct F_BFu9s_I { float v1; unsigned short v2:9; int v3; };
struct F_BFu9s_Ip { float v1; unsigned short v2:9; int * v3; };
struct F_BFu9s_L { float v1; unsigned short v2:9; long long v3; };
struct F_BFu9s_S { float v1; unsigned short v2:9; short v3; };
struct F_BFu9s_Uc { float v1; unsigned short v2:9; unsigned char v3; };
struct F_BFu9s_Ui { float v1; unsigned short v2:9; unsigned int v3; };
struct F_BFu9s_Ul { float v1; unsigned short v2:9; unsigned long long v3; };
struct F_BFu9s_Us { float v1; unsigned short v2:9; unsigned short v3; };
struct F_BFu9s_Vp { float v1; unsigned short v2:9; void * v3; };
struct F_C { float v1; char v2; };
struct F_C_BFu15i { float v1; char v2; unsigned int v3:15; };
struct F_C_BFu15ll { float v1; char v2; unsigned long long v3:15; };
struct F_C_BFu15s { float v1; char v2; unsigned short v3:15; };
struct F_C_BFu16i { float v1; char v2; unsigned int v3:16; };
struct F_C_BFu16ll { float v1; char v2; unsigned long long v3:16; };
struct F_C_BFu16s { float v1; char v2; unsigned short v3:16; };
struct F_C_BFu17i { float v1; char v2; unsigned int v3:17; };
struct F_C_BFu17ll { float v1; char v2; unsigned long long v3:17; };
struct F_C_BFu1c { float v1; char v2; unsigned char v3:1; };
struct F_C_BFu1i { float v1; char v2; unsigned int v3:1; };
struct F_C_BFu1ll { float v1; char v2; unsigned long long v3:1; };
struct F_C_BFu1s { float v1; char v2; unsigned short v3:1; };
struct F_C_BFu31i { float v1; char v2; unsigned int v3:31; };
struct F_C_BFu31ll { float v1; char v2; unsigned long long v3:31; };
struct F_C_BFu32i { float v1; char v2; unsigned int v3:32; };
struct F_C_BFu32ll { float v1; char v2; unsigned long long v3:32; };
struct F_C_BFu33 { float v1; char v2; unsigned long long v3:33; };
struct F_C_BFu7c { float v1; char v2; unsigned char v3:7; };
struct F_C_BFu7i { float v1; char v2; unsigned int v3:7; };
struct F_C_BFu7ll { float v1; char v2; unsigned long long v3:7; };
struct F_C_BFu7s { float v1; char v2; unsigned short v3:7; };
struct F_C_BFu8c { float v1; char v2; unsigned char v3:8; };
struct F_C_BFu8i { float v1; char v2; unsigned int v3:8; };
struct F_C_BFu8ll { float v1; char v2; unsigned long long v3:8; };
struct F_C_BFu8s { float v1; char v2; unsigned short v3:8; };
struct F_C_BFu9i { float v1; char v2; unsigned int v3:9; };
struct F_C_BFu9ll { float v1; char v2; unsigned long long v3:9; };
struct F_C_BFu9s { float v1; char v2; unsigned short v3:9; };
struct F_C_C { float v1; char v2; char v3; };
struct F_C_D { float v1; char v2; double v3; };
struct F_C_F { float v1; char v2; float v3; };
struct F_C_I { float v1; char v2; int v3; };
struct F_C_Ip { float v1; char v2; int * v3; };
struct F_C_L { float v1; char v2; long long v3; };
struct F_C_S { float v1; char v2; short v3; };
struct F_C_Uc { float v1; char v2; unsigned char v3; };
struct F_C_Ui { float v1; char v2; unsigned int v3; };
struct F_C_Ul { float v1; char v2; unsigned long long v3; };
struct F_C_Us { float v1; char v2; unsigned short v3; };
struct F_C_Vp { float v1; char v2; void * v3; };
struct F_D { float v1; double v2; };
struct F_D_BFu15i { float v1; double v2; unsigned int v3:15; };
struct F_D_BFu15ll { float v1; double v2; unsigned long long v3:15; };
struct F_D_BFu15s { float v1; double v2; unsigned short v3:15; };
struct F_D_BFu16i { float v1; double v2; unsigned int v3:16; };
struct F_D_BFu16ll { float v1; double v2; unsigned long long v3:16; };
struct F_D_BFu16s { float v1; double v2; unsigned short v3:16; };
struct F_D_BFu17i { float v1; double v2; unsigned int v3:17; };
struct F_D_BFu17ll { float v1; double v2; unsigned long long v3:17; };
struct F_D_BFu1c { float v1; double v2; unsigned char v3:1; };
struct F_D_BFu1i { float v1; double v2; unsigned int v3:1; };
struct F_D_BFu1ll { float v1; double v2; unsigned long long v3:1; };
struct F_D_BFu1s { float v1; double v2; unsigned short v3:1; };
struct F_D_BFu31i { float v1; double v2; unsigned int v3:31; };
struct F_D_BFu31ll { float v1; double v2; unsigned long long v3:31; };
struct F_D_BFu32i { float v1; double v2; unsigned int v3:32; };
struct F_D_BFu32ll { float v1; double v2; unsigned long long v3:32; };
struct F_D_BFu33 { float v1; double v2; unsigned long long v3:33; };
struct F_D_BFu7c { float v1; double v2; unsigned char v3:7; };
struct F_D_BFu7i { float v1; double v2; unsigned int v3:7; };
struct F_D_BFu7ll { float v1; double v2; unsigned long long v3:7; };
struct F_D_BFu7s { float v1; double v2; unsigned short v3:7; };
struct F_D_BFu8c { float v1; double v2; unsigned char v3:8; };
struct F_D_BFu8i { float v1; double v2; unsigned int v3:8; };
struct F_D_BFu8ll { float v1; double v2; unsigned long long v3:8; };
struct F_D_BFu8s { float v1; double v2; unsigned short v3:8; };
struct F_D_BFu9i { float v1; double v2; unsigned int v3:9; };
struct F_D_BFu9ll { float v1; double v2; unsigned long long v3:9; };
struct F_D_BFu9s { float v1; double v2; unsigned short v3:9; };
struct F_D_C { float v1; double v2; char v3; };
struct F_D_D { float v1; double v2; double v3; };
struct F_D_F { float v1; double v2; float v3; };
struct F_D_I { float v1; double v2; int v3; };
struct F_D_Ip { float v1; double v2; int * v3; };
struct F_D_L { float v1; double v2; long long v3; };
struct F_D_S { float v1; double v2; short v3; };
struct F_D_Uc { float v1; double v2; unsigned char v3; };
struct F_D_Ui { float v1; double v2; unsigned int v3; };
struct F_D_Ul { float v1; double v2; unsigned long long v3; };
struct F_D_Us { float v1; double v2; unsigned short v3; };
struct F_D_Vp { float v1; double v2; void * v3; };
struct F_F { float v1; float v2; };
struct F_F_BFu15i { float v1; float v2; unsigned int v3:15; };
struct F_F_BFu15ll { float v1; float v2; unsigned long long v3:15; };
struct F_F_BFu15s { float v1; float v2; unsigned short v3:15; };
struct F_F_BFu16i { float v1; float v2; unsigned int v3:16; };
struct F_F_BFu16ll { float v1; float v2; unsigned long long v3:16; };
struct F_F_BFu16s { float v1; float v2; unsigned short v3:16; };
struct F_F_BFu17i { float v1; float v2; unsigned int v3:17; };
struct F_F_BFu17ll { float v1; float v2; unsigned long long v3:17; };
struct F_F_BFu1c { float v1; float v2; unsigned char v3:1; };
struct F_F_BFu1i { float v1; float v2; unsigned int v3:1; };
struct F_F_BFu1ll { float v1; float v2; unsigned long long v3:1; };
struct F_F_BFu1s { float v1; float v2; unsigned short v3:1; };
struct F_F_BFu31i { float v1; float v2; unsigned int v3:31; };
struct F_F_BFu31ll { float v1; float v2; unsigned long long v3:31; };
struct F_F_BFu32i { float v1; float v2; unsigned int v3:32; };
struct F_F_BFu32ll { float v1; float v2; unsigned long long v3:32; };
struct F_F_BFu33 { float v1; float v2; unsigned long long v3:33; };
struct F_F_BFu7c { float v1; float v2; unsigned char v3:7; };
struct F_F_BFu7i { float v1; float v2; unsigned int v3:7; };
struct F_F_BFu7ll { float v1; float v2; unsigned long long v3:7; };
struct F_F_BFu7s { float v1; float v2; unsigned short v3:7; };
struct F_F_BFu8c { float v1; float v2; unsigned char v3:8; };
struct F_F_BFu8i { float v1; float v2; unsigned int v3:8; };
struct F_F_BFu8ll { float v1; float v2; unsigned long long v3:8; };
struct F_F_BFu8s { float v1; float v2; unsigned short v3:8; };
struct F_F_BFu9i { float v1; float v2; unsigned int v3:9; };
struct F_F_BFu9ll { float v1; float v2; unsigned long long v3:9; };
struct F_F_BFu9s { float v1; float v2; unsigned short v3:9; };
struct F_F_C { float v1; float v2; char v3; };
struct F_F_D { float v1; float v2; double v3; };
struct F_F_F { float v1; float v2; float v3; };
struct F_F_I { float v1; float v2; int v3; };
struct F_F_Ip { float v1; float v2; int * v3; };
struct F_F_L { float v1; float v2; long long v3; };
struct F_F_S { float v1; float v2; short v3; };
struct F_F_Uc { float v1; float v2; unsigned char v3; };
struct F_F_Ui { float v1; float v2; unsigned int v3; };
struct F_F_Ul { float v1; float v2; unsigned long long v3; };
struct F_F_Us { float v1; float v2; unsigned short v3; };
struct F_F_Vp { float v1; float v2; void * v3; };
struct F_I { float v1; int v2; };
struct F_I_BFu15i { float v1; int v2; unsigned int v3:15; };
struct F_I_BFu15ll { float v1; int v2; unsigned long long v3:15; };
struct F_I_BFu15s { float v1; int v2; unsigned short v3:15; };
struct F_I_BFu16i { float v1; int v2; unsigned int v3:16; };
struct F_I_BFu16ll { float v1; int v2; unsigned long long v3:16; };
struct F_I_BFu16s { float v1; int v2; unsigned short v3:16; };
struct F_I_BFu17i { float v1; int v2; unsigned int v3:17; };
struct F_I_BFu17ll { float v1; int v2; unsigned long long v3:17; };
struct F_I_BFu1c { float v1; int v2; unsigned char v3:1; };
struct F_I_BFu1i { float v1; int v2; unsigned int v3:1; };
struct F_I_BFu1ll { float v1; int v2; unsigned long long v3:1; };
struct F_I_BFu1s { float v1; int v2; unsigned short v3:1; };
struct F_I_BFu31i { float v1; int v2; unsigned int v3:31; };
struct F_I_BFu31ll { float v1; int v2; unsigned long long v3:31; };
struct F_I_BFu32i { float v1; int v2; unsigned int v3:32; };
struct F_I_BFu32ll { float v1; int v2; unsigned long long v3:32; };
struct F_I_BFu33 { float v1; int v2; unsigned long long v3:33; };
struct F_I_BFu7c { float v1; int v2; unsigned char v3:7; };
struct F_I_BFu7i { float v1; int v2; unsigned int v3:7; };
struct F_I_BFu7ll { float v1; int v2; unsigned long long v3:7; };
struct F_I_BFu7s { float v1; int v2; unsigned short v3:7; };
struct F_I_BFu8c { float v1; int v2; unsigned char v3:8; };
struct F_I_BFu8i { float v1; int v2; unsigned int v3:8; };
struct F_I_BFu8ll { float v1; int v2; unsigned long long v3:8; };
struct F_I_BFu8s { float v1; int v2; unsigned short v3:8; };
struct F_I_BFu9i { float v1; int v2; unsigned int v3:9; };
struct F_I_BFu9ll { float v1; int v2; unsigned long long v3:9; };
struct F_I_BFu9s { float v1; int v2; unsigned short v3:9; };
struct F_I_C { float v1; int v2; char v3; };
struct F_I_D { float v1; int v2; double v3; };
struct F_I_F { float v1; int v2; float v3; };
struct F_I_I { float v1; int v2; int v3; };
struct F_I_Ip { float v1; int v2; int * v3; };
struct F_I_L { float v1; int v2; long long v3; };
struct F_I_S { float v1; int v2; short v3; };
struct F_I_Uc { float v1; int v2; unsigned char v3; };
struct F_I_Ui { float v1; int v2; unsigned int v3; };
struct F_I_Ul { float v1; int v2; unsigned long long v3; };
struct F_I_Us { float v1; int v2; unsigned short v3; };
struct F_I_Vp { float v1; int v2; void * v3; };
struct F_Ip { float v1; int * v2; };
struct F_Ip_BFu15i { float v1; int * v2; unsigned int v3:15; };
struct F_Ip_BFu15ll { float v1; int * v2; unsigned long long v3:15; };
struct F_Ip_BFu15s { float v1; int * v2; unsigned short v3:15; };
struct F_Ip_BFu16i { float v1; int * v2; unsigned int v3:16; };
struct F_Ip_BFu16ll { float v1; int * v2; unsigned long long v3:16; };
struct F_Ip_BFu16s { float v1; int * v2; unsigned short v3:16; };
struct F_Ip_BFu17i { float v1; int * v2; unsigned int v3:17; };
struct F_Ip_BFu17ll { float v1; int * v2; unsigned long long v3:17; };
struct F_Ip_BFu1c { float v1; int * v2; unsigned char v3:1; };
struct F_Ip_BFu1i { float v1; int * v2; unsigned int v3:1; };
struct F_Ip_BFu1ll { float v1; int * v2; unsigned long long v3:1; };
struct F_Ip_BFu1s { float v1; int * v2; unsigned short v3:1; };
struct F_Ip_BFu31i { float v1; int * v2; unsigned int v3:31; };
struct F_Ip_BFu31ll { float v1; int * v2; unsigned long long v3:31; };
struct F_Ip_BFu32i { float v1; int * v2; unsigned int v3:32; };
struct F_Ip_BFu32ll { float v1; int * v2; unsigned long long v3:32; };
struct F_Ip_BFu33 { float v1; int * v2; unsigned long long v3:33; };
struct F_Ip_BFu7c { float v1; int * v2; unsigned char v3:7; };
struct F_Ip_BFu7i { float v1; int * v2; unsigned int v3:7; };
struct F_Ip_BFu7ll { float v1; int * v2; unsigned long long v3:7; };
struct F_Ip_BFu7s { float v1; int * v2; unsigned short v3:7; };
struct F_Ip_BFu8c { float v1; int * v2; unsigned char v3:8; };
struct F_Ip_BFu8i { float v1; int * v2; unsigned int v3:8; };
struct F_Ip_BFu8ll { float v1; int * v2; unsigned long long v3:8; };
struct F_Ip_BFu8s { float v1; int * v2; unsigned short v3:8; };
struct F_Ip_BFu9i { float v1; int * v2; unsigned int v3:9; };
struct F_Ip_BFu9ll { float v1; int * v2; unsigned long long v3:9; };
struct F_Ip_BFu9s { float v1; int * v2; unsigned short v3:9; };
struct F_Ip_C { float v1; int * v2; char v3; };
struct F_Ip_D { float v1; int * v2; double v3; };
struct F_Ip_F { float v1; int * v2; float v3; };
struct F_Ip_I { float v1; int * v2; int v3; };
struct F_Ip_Ip { float v1; int * v2; int * v3; };
struct F_Ip_L { float v1; int * v2; long long v3; };
struct F_Ip_S { float v1; int * v2; short v3; };
struct F_Ip_Uc { float v1; int * v2; unsigned char v3; };
struct F_Ip_Ui { float v1; int * v2; unsigned int v3; };
struct F_Ip_Ul { float v1; int * v2; unsigned long long v3; };
struct F_Ip_Us { float v1; int * v2; unsigned short v3; };
struct F_Ip_Vp { float v1; int * v2; void * v3; };
struct F_L { float v1; long long v2; };
struct F_L_BFu15i { float v1; long long v2; unsigned int v3:15; };
struct F_L_BFu15ll { float v1; long long v2; unsigned long long v3:15; };
struct F_L_BFu15s { float v1; long long v2; unsigned short v3:15; };
struct F_L_BFu16i { float v1; long long v2; unsigned int v3:16; };
struct F_L_BFu16ll { float v1; long long v2; unsigned long long v3:16; };
struct F_L_BFu16s { float v1; long long v2; unsigned short v3:16; };
struct F_L_BFu17i { float v1; long long v2; unsigned int v3:17; };
struct F_L_BFu17ll { float v1; long long v2; unsigned long long v3:17; };
struct F_L_BFu1c { float v1; long long v2; unsigned char v3:1; };
struct F_L_BFu1i { float v1; long long v2; unsigned int v3:1; };
struct F_L_BFu1ll { float v1; long long v2; unsigned long long v3:1; };
struct F_L_BFu1s { float v1; long long v2; unsigned short v3:1; };
struct F_L_BFu31i { float v1; long long v2; unsigned int v3:31; };
struct F_L_BFu31ll { float v1; long long v2; unsigned long long v3:31; };
struct F_L_BFu32i { float v1; long long v2; unsigned int v3:32; };
struct F_L_BFu32ll { float v1; long long v2; unsigned long long v3:32; };
struct F_L_BFu33 { float v1; long long v2; unsigned long long v3:33; };
struct F_L_BFu7c { float v1; long long v2; unsigned char v3:7; };
struct F_L_BFu7i { float v1; long long v2; unsigned int v3:7; };
struct F_L_BFu7ll { float v1; long long v2; unsigned long long v3:7; };
struct F_L_BFu7s { float v1; long long v2; unsigned short v3:7; };
struct F_L_BFu8c { float v1; long long v2; unsigned char v3:8; };
struct F_L_BFu8i { float v1; long long v2; unsigned int v3:8; };
struct F_L_BFu8ll { float v1; long long v2; unsigned long long v3:8; };
struct F_L_BFu8s { float v1; long long v2; unsigned short v3:8; };
struct F_L_BFu9i { float v1; long long v2; unsigned int v3:9; };
struct F_L_BFu9ll { float v1; long long v2; unsigned long long v3:9; };
struct F_L_BFu9s { float v1; long long v2; unsigned short v3:9; };
struct F_L_C { float v1; long long v2; char v3; };
struct F_L_D { float v1; long long v2; double v3; };
struct F_L_F { float v1; long long v2; float v3; };
struct F_L_I { float v1; long long v2; int v3; };
struct F_L_Ip { float v1; long long v2; int * v3; };
struct F_L_L { float v1; long long v2; long long v3; };
struct F_L_S { float v1; long long v2; short v3; };
struct F_L_Uc { float v1; long long v2; unsigned char v3; };
struct F_L_Ui { float v1; long long v2; unsigned int v3; };
struct F_L_Ul { float v1; long long v2; unsigned long long v3; };
struct F_L_Us { float v1; long long v2; unsigned short v3; };
struct F_L_Vp { float v1; long long v2; void * v3; };
struct F_S { float v1; short v2; };
struct F_S_BFu15i { float v1; short v2; unsigned int v3:15; };
struct F_S_BFu15ll { float v1; short v2; unsigned long long v3:15; };
struct F_S_BFu15s { float v1; short v2; unsigned short v3:15; };
struct F_S_BFu16i { float v1; short v2; unsigned int v3:16; };
struct F_S_BFu16ll { float v1; short v2; unsigned long long v3:16; };
struct F_S_BFu16s { float v1; short v2; unsigned short v3:16; };
struct F_S_BFu17i { float v1; short v2; unsigned int v3:17; };
struct F_S_BFu17ll { float v1; short v2; unsigned long long v3:17; };
struct F_S_BFu1c { float v1; short v2; unsigned char v3:1; };
struct F_S_BFu1i { float v1; short v2; unsigned int v3:1; };
struct F_S_BFu1ll { float v1; short v2; unsigned long long v3:1; };
struct F_S_BFu1s { float v1; short v2; unsigned short v3:1; };
struct F_S_BFu31i { float v1; short v2; unsigned int v3:31; };
struct F_S_BFu31ll { float v1; short v2; unsigned long long v3:31; };
struct F_S_BFu32i { float v1; short v2; unsigned int v3:32; };
struct F_S_BFu32ll { float v1; short v2; unsigned long long v3:32; };
struct F_S_BFu33 { float v1; short v2; unsigned long long v3:33; };
struct F_S_BFu7c { float v1; short v2; unsigned char v3:7; };
struct F_S_BFu7i { float v1; short v2; unsigned int v3:7; };
struct F_S_BFu7ll { float v1; short v2; unsigned long long v3:7; };
struct F_S_BFu7s { float v1; short v2; unsigned short v3:7; };
struct F_S_BFu8c { float v1; short v2; unsigned char v3:8; };
struct F_S_BFu8i { float v1; short v2; unsigned int v3:8; };
struct F_S_BFu8ll { float v1; short v2; unsigned long long v3:8; };
struct F_S_BFu8s { float v1; short v2; unsigned short v3:8; };
struct F_S_BFu9i { float v1; short v2; unsigned int v3:9; };
struct F_S_BFu9ll { float v1; short v2; unsigned long long v3:9; };
struct F_S_BFu9s { float v1; short v2; unsigned short v3:9; };
struct F_S_C { float v1; short v2; char v3; };
struct F_S_D { float v1; short v2; double v3; };
struct F_S_F { float v1; short v2; float v3; };
struct F_S_I { float v1; short v2; int v3; };
struct F_S_Ip { float v1; short v2; int * v3; };
struct F_S_L { float v1; short v2; long long v3; };
struct F_S_S { float v1; short v2; short v3; };
struct F_S_Uc { float v1; short v2; unsigned char v3; };
struct F_S_Ui { float v1; short v2; unsigned int v3; };
struct F_S_Ul { float v1; short v2; unsigned long long v3; };
struct F_S_Us { float v1; short v2; unsigned short v3; };
struct F_S_Vp { float v1; short v2; void * v3; };
struct F_Uc { float v1; unsigned char v2; };
struct F_Uc_BFu15i { float v1; unsigned char v2; unsigned int v3:15; };
struct F_Uc_BFu15ll { float v1; unsigned char v2; unsigned long long v3:15; };
struct F_Uc_BFu15s { float v1; unsigned char v2; unsigned short v3:15; };
struct F_Uc_BFu16i { float v1; unsigned char v2; unsigned int v3:16; };
struct F_Uc_BFu16ll { float v1; unsigned char v2; unsigned long long v3:16; };
struct F_Uc_BFu16s { float v1; unsigned char v2; unsigned short v3:16; };
struct F_Uc_BFu17i { float v1; unsigned char v2; unsigned int v3:17; };
struct F_Uc_BFu17ll { float v1; unsigned char v2; unsigned long long v3:17; };
struct F_Uc_BFu1c { float v1; unsigned char v2; unsigned char v3:1; };
struct F_Uc_BFu1i { float v1; unsigned char v2; unsigned int v3:1; };
struct F_Uc_BFu1ll { float v1; unsigned char v2; unsigned long long v3:1; };
struct F_Uc_BFu1s { float v1; unsigned char v2; unsigned short v3:1; };
struct F_Uc_BFu31i { float v1; unsigned char v2; unsigned int v3:31; };
struct F_Uc_BFu31ll { float v1; unsigned char v2; unsigned long long v3:31; };
struct F_Uc_BFu32i { float v1; unsigned char v2; unsigned int v3:32; };
struct F_Uc_BFu32ll { float v1; unsigned char v2; unsigned long long v3:32; };
struct F_Uc_BFu33 { float v1; unsigned char v2; unsigned long long v3:33; };
struct F_Uc_BFu7c { float v1; unsigned char v2; unsigned char v3:7; };
struct F_Uc_BFu7i { float v1; unsigned char v2; unsigned int v3:7; };
struct F_Uc_BFu7ll { float v1; unsigned char v2; unsigned long long v3:7; };
struct F_Uc_BFu7s { float v1; unsigned char v2; unsigned short v3:7; };
struct F_Uc_BFu8c { float v1; unsigned char v2; unsigned char v3:8; };
struct F_Uc_BFu8i { float v1; unsigned char v2; unsigned int v3:8; };
struct F_Uc_BFu8ll { float v1; unsigned char v2; unsigned long long v3:8; };
struct F_Uc_BFu8s { float v1; unsigned char v2; unsigned short v3:8; };
struct F_Uc_BFu9i { float v1; unsigned char v2; unsigned int v3:9; };
struct F_Uc_BFu9ll { float v1; unsigned char v2; unsigned long long v3:9; };
struct F_Uc_BFu9s { float v1; unsigned char v2; unsigned short v3:9; };
struct F_Uc_C { float v1; unsigned char v2; char v3; };
struct F_Uc_D { float v1; unsigned char v2; double v3; };
struct F_Uc_F { float v1; unsigned char v2; float v3; };
struct F_Uc_I { float v1; unsigned char v2; int v3; };
struct F_Uc_Ip { float v1; unsigned char v2; int * v3; };
struct F_Uc_L { float v1; unsigned char v2; long long v3; };
struct F_Uc_S { float v1; unsigned char v2; short v3; };
struct F_Uc_Uc { float v1; unsigned char v2; unsigned char v3; };
struct F_Uc_Ui { float v1; unsigned char v2; unsigned int v3; };
struct F_Uc_Ul { float v1; unsigned char v2; unsigned long long v3; };
struct F_Uc_Us { float v1; unsigned char v2; unsigned short v3; };
struct F_Uc_Vp { float v1; unsigned char v2; void * v3; };
struct F_Ui { float v1; unsigned int v2; };
struct F_Ui_BFu15i { float v1; unsigned int v2; unsigned int v3:15; };
struct F_Ui_BFu15ll { float v1; unsigned int v2; unsigned long long v3:15; };
struct F_Ui_BFu15s { float v1; unsigned int v2; unsigned short v3:15; };
struct F_Ui_BFu16i { float v1; unsigned int v2; unsigned int v3:16; };
struct F_Ui_BFu16ll { float v1; unsigned int v2; unsigned long long v3:16; };
struct F_Ui_BFu16s { float v1; unsigned int v2; unsigned short v3:16; };
struct F_Ui_BFu17i { float v1; unsigned int v2; unsigned int v3:17; };
struct F_Ui_BFu17ll { float v1; unsigned int v2; unsigned long long v3:17; };
struct F_Ui_BFu1c { float v1; unsigned int v2; unsigned char v3:1; };
struct F_Ui_BFu1i { float v1; unsigned int v2; unsigned int v3:1; };
struct F_Ui_BFu1ll { float v1; unsigned int v2; unsigned long long v3:1; };
struct F_Ui_BFu1s { float v1; unsigned int v2; unsigned short v3:1; };
struct F_Ui_BFu31i { float v1; unsigned int v2; unsigned int v3:31; };
struct F_Ui_BFu31ll { float v1; unsigned int v2; unsigned long long v3:31; };
struct F_Ui_BFu32i { float v1; unsigned int v2; unsigned int v3:32; };
struct F_Ui_BFu32ll { float v1; unsigned int v2; unsigned long long v3:32; };
struct F_Ui_BFu33 { float v1; unsigned int v2; unsigned long long v3:33; };
struct F_Ui_BFu7c { float v1; unsigned int v2; unsigned char v3:7; };
struct F_Ui_BFu7i { float v1; unsigned int v2; unsigned int v3:7; };
struct F_Ui_BFu7ll { float v1; unsigned int v2; unsigned long long v3:7; };
struct F_Ui_BFu7s { float v1; unsigned int v2; unsigned short v3:7; };
struct F_Ui_BFu8c { float v1; unsigned int v2; unsigned char v3:8; };
struct F_Ui_BFu8i { float v1; unsigned int v2; unsigned int v3:8; };
struct F_Ui_BFu8ll { float v1; unsigned int v2; unsigned long long v3:8; };
struct F_Ui_BFu8s { float v1; unsigned int v2; unsigned short v3:8; };
struct F_Ui_BFu9i { float v1; unsigned int v2; unsigned int v3:9; };
struct F_Ui_BFu9ll { float v1; unsigned int v2; unsigned long long v3:9; };
struct F_Ui_BFu9s { float v1; unsigned int v2; unsigned short v3:9; };
struct F_Ui_C { float v1; unsigned int v2; char v3; };
struct F_Ui_D { float v1; unsigned int v2; double v3; };
struct F_Ui_F { float v1; unsigned int v2; float v3; };
struct F_Ui_I { float v1; unsigned int v2; int v3; };
struct F_Ui_Ip { float v1; unsigned int v2; int * v3; };
struct F_Ui_L { float v1; unsigned int v2; long long v3; };
struct F_Ui_S { float v1; unsigned int v2; short v3; };
struct F_Ui_Uc { float v1; unsigned int v2; unsigned char v3; };
struct F_Ui_Ui { float v1; unsigned int v2; unsigned int v3; };
struct F_Ui_Ul { float v1; unsigned int v2; unsigned long long v3; };
struct F_Ui_Us { float v1; unsigned int v2; unsigned short v3; };
struct F_Ui_Vp { float v1; unsigned int v2; void * v3; };
struct F_Ul { float v1; unsigned long long v2; };
struct F_Ul_BFu15i { float v1; unsigned long long v2; unsigned int v3:15; };
struct F_Ul_BFu15ll { float v1; unsigned long long v2; unsigned long long v3:15; };
struct F_Ul_BFu15s { float v1; unsigned long long v2; unsigned short v3:15; };
struct F_Ul_BFu16i { float v1; unsigned long long v2; unsigned int v3:16; };
struct F_Ul_BFu16ll { float v1; unsigned long long v2; unsigned long long v3:16; };
struct F_Ul_BFu16s { float v1; unsigned long long v2; unsigned short v3:16; };
struct F_Ul_BFu17i { float v1; unsigned long long v2; unsigned int v3:17; };
struct F_Ul_BFu17ll { float v1; unsigned long long v2; unsigned long long v3:17; };
struct F_Ul_BFu1c { float v1; unsigned long long v2; unsigned char v3:1; };
struct F_Ul_BFu1i { float v1; unsigned long long v2; unsigned int v3:1; };
struct F_Ul_BFu1ll { float v1; unsigned long long v2; unsigned long long v3:1; };
struct F_Ul_BFu1s { float v1; unsigned long long v2; unsigned short v3:1; };
struct F_Ul_BFu31i { float v1; unsigned long long v2; unsigned int v3:31; };
struct F_Ul_BFu31ll { float v1; unsigned long long v2; unsigned long long v3:31; };
struct F_Ul_BFu32i { float v1; unsigned long long v2; unsigned int v3:32; };
struct F_Ul_BFu32ll { float v1; unsigned long long v2; unsigned long long v3:32; };
struct F_Ul_BFu33 { float v1; unsigned long long v2; unsigned long long v3:33; };
struct F_Ul_BFu7c { float v1; unsigned long long v2; unsigned char v3:7; };
struct F_Ul_BFu7i { float v1; unsigned long long v2; unsigned int v3:7; };
struct F_Ul_BFu7ll { float v1; unsigned long long v2; unsigned long long v3:7; };
struct F_Ul_BFu7s { float v1; unsigned long long v2; unsigned short v3:7; };
struct F_Ul_BFu8c { float v1; unsigned long long v2; unsigned char v3:8; };
struct F_Ul_BFu8i { float v1; unsigned long long v2; unsigned int v3:8; };
struct F_Ul_BFu8ll { float v1; unsigned long long v2; unsigned long long v3:8; };
struct F_Ul_BFu8s { float v1; unsigned long long v2; unsigned short v3:8; };
struct F_Ul_BFu9i { float v1; unsigned long long v2; unsigned int v3:9; };
struct F_Ul_BFu9ll { float v1; unsigned long long v2; unsigned long long v3:9; };
struct F_Ul_BFu9s { float v1; unsigned long long v2; unsigned short v3:9; };
struct F_Ul_C { float v1; unsigned long long v2; char v3; };
struct F_Ul_D { float v1; unsigned long long v2; double v3; };
struct F_Ul_F { float v1; unsigned long long v2; float v3; };
struct F_Ul_I { float v1; unsigned long long v2; int v3; };
struct F_Ul_Ip { float v1; unsigned long long v2; int * v3; };
struct F_Ul_L { float v1; unsigned long long v2; long long v3; };
struct F_Ul_S { float v1; unsigned long long v2; short v3; };
struct F_Ul_Uc { float v1; unsigned long long v2; unsigned char v3; };
struct F_Ul_Ui { float v1; unsigned long long v2; unsigned int v3; };
struct F_Ul_Ul { float v1; unsigned long long v2; unsigned long long v3; };
struct F_Ul_Us { float v1; unsigned long long v2; unsigned short v3; };
struct F_Ul_Vp { float v1; unsigned long long v2; void * v3; };
struct F_Us { float v1; unsigned short v2; };
struct F_Us_BFu15i { float v1; unsigned short v2; unsigned int v3:15; };
struct F_Us_BFu15ll { float v1; unsigned short v2; unsigned long long v3:15; };
struct F_Us_BFu15s { float v1; unsigned short v2; unsigned short v3:15; };
struct F_Us_BFu16i { float v1; unsigned short v2; unsigned int v3:16; };
struct F_Us_BFu16ll { float v1; unsigned short v2; unsigned long long v3:16; };
struct F_Us_BFu16s { float v1; unsigned short v2; unsigned short v3:16; };
struct F_Us_BFu17i { float v1; unsigned short v2; unsigned int v3:17; };
struct F_Us_BFu17ll { float v1; unsigned short v2; unsigned long long v3:17; };
struct F_Us_BFu1c { float v1; unsigned short v2; unsigned char v3:1; };
struct F_Us_BFu1i { float v1; unsigned short v2; unsigned int v3:1; };
struct F_Us_BFu1ll { float v1; unsigned short v2; unsigned long long v3:1; };
struct F_Us_BFu1s { float v1; unsigned short v2; unsigned short v3:1; };
struct F_Us_BFu31i { float v1; unsigned short v2; unsigned int v3:31; };
struct F_Us_BFu31ll { float v1; unsigned short v2; unsigned long long v3:31; };
struct F_Us_BFu32i { float v1; unsigned short v2; unsigned int v3:32; };
struct F_Us_BFu32ll { float v1; unsigned short v2; unsigned long long v3:32; };
struct F_Us_BFu33 { float v1; unsigned short v2; unsigned long long v3:33; };
struct F_Us_BFu7c { float v1; unsigned short v2; unsigned char v3:7; };
struct F_Us_BFu7i { float v1; unsigned short v2; unsigned int v3:7; };
struct F_Us_BFu7ll { float v1; unsigned short v2; unsigned long long v3:7; };
struct F_Us_BFu7s { float v1; unsigned short v2; unsigned short v3:7; };
struct F_Us_BFu8c { float v1; unsigned short v2; unsigned char v3:8; };
struct F_Us_BFu8i { float v1; unsigned short v2; unsigned int v3:8; };
struct F_Us_BFu8ll { float v1; unsigned short v2; unsigned long long v3:8; };
struct F_Us_BFu8s { float v1; unsigned short v2; unsigned short v3:8; };
struct F_Us_BFu9i { float v1; unsigned short v2; unsigned int v3:9; };
struct F_Us_BFu9ll { float v1; unsigned short v2; unsigned long long v3:9; };
struct F_Us_BFu9s { float v1; unsigned short v2; unsigned short v3:9; };
struct F_Us_C { float v1; unsigned short v2; char v3; };
struct F_Us_D { float v1; unsigned short v2; double v3; };
struct F_Us_F { float v1; unsigned short v2; float v3; };
struct F_Us_I { float v1; unsigned short v2; int v3; };
struct F_Us_Ip { float v1; unsigned short v2; int * v3; };
struct F_Us_L { float v1; unsigned short v2; long long v3; };
struct F_Us_S { float v1; unsigned short v2; short v3; };
struct F_Us_Uc { float v1; unsigned short v2; unsigned char v3; };
struct F_Us_Ui { float v1; unsigned short v2; unsigned int v3; };
struct F_Us_Ul { float v1; unsigned short v2; unsigned long long v3; };
struct F_Us_Us { float v1; unsigned short v2; unsigned short v3; };
struct F_Us_Vp { float v1; unsigned short v2; void * v3; };
struct F_Vp { float v1; void * v2; };
struct F_Vp_BFu15i { float v1; void * v2; unsigned int v3:15; };
struct F_Vp_BFu15ll { float v1; void * v2; unsigned long long v3:15; };
struct F_Vp_BFu15s { float v1; void * v2; unsigned short v3:15; };
struct F_Vp_BFu16i { float v1; void * v2; unsigned int v3:16; };
struct F_Vp_BFu16ll { float v1; void * v2; unsigned long long v3:16; };
struct F_Vp_BFu16s { float v1; void * v2; unsigned short v3:16; };
struct F_Vp_BFu17i { float v1; void * v2; unsigned int v3:17; };
struct F_Vp_BFu17ll { float v1; void * v2; unsigned long long v3:17; };
struct F_Vp_BFu1c { float v1; void * v2; unsigned char v3:1; };
struct F_Vp_BFu1i { float v1; void * v2; unsigned int v3:1; };
struct F_Vp_BFu1ll { float v1; void * v2; unsigned long long v3:1; };
struct F_Vp_BFu1s { float v1; void * v2; unsigned short v3:1; };
struct F_Vp_BFu31i { float v1; void * v2; unsigned int v3:31; };
struct F_Vp_BFu31ll { float v1; void * v2; unsigned long long v3:31; };
struct F_Vp_BFu32i { float v1; void * v2; unsigned int v3:32; };
struct F_Vp_BFu32ll { float v1; void * v2; unsigned long long v3:32; };
struct F_Vp_BFu33 { float v1; void * v2; unsigned long long v3:33; };
struct F_Vp_BFu7c { float v1; void * v2; unsigned char v3:7; };
struct F_Vp_BFu7i { float v1; void * v2; unsigned int v3:7; };
struct F_Vp_BFu7ll { float v1; void * v2; unsigned long long v3:7; };
struct F_Vp_BFu7s { float v1; void * v2; unsigned short v3:7; };
struct F_Vp_BFu8c { float v1; void * v2; unsigned char v3:8; };
struct F_Vp_BFu8i { float v1; void * v2; unsigned int v3:8; };
struct F_Vp_BFu8ll { float v1; void * v2; unsigned long long v3:8; };
struct F_Vp_BFu8s { float v1; void * v2; unsigned short v3:8; };
struct F_Vp_BFu9i { float v1; void * v2; unsigned int v3:9; };
struct F_Vp_BFu9ll { float v1; void * v2; unsigned long long v3:9; };
struct F_Vp_BFu9s { float v1; void * v2; unsigned short v3:9; };
struct F_Vp_C { float v1; void * v2; char v3; };
struct F_Vp_D { float v1; void * v2; double v3; };
struct F_Vp_F { float v1; void * v2; float v3; };
struct F_Vp_I { float v1; void * v2; int v3; };
struct F_Vp_Ip { float v1; void * v2; int * v3; };
struct F_Vp_L { float v1; void * v2; long long v3; };
struct F_Vp_S { float v1; void * v2; short v3; };
struct F_Vp_Uc { float v1; void * v2; unsigned char v3; };
struct F_Vp_Ui { float v1; void * v2; unsigned int v3; };
struct F_Vp_Ul { float v1; void * v2; unsigned long long v3; };
struct F_Vp_Us { float v1; void * v2; unsigned short v3; };
struct F_Vp_Vp { float v1; void * v2; void * v3; };
struct I { int v1; };
struct I_BFu15i { int v1; unsigned int v2:15; };
struct I_BFu15i_BFu15i { int v1; unsigned int v2:15; unsigned int v3:15; };
struct I_BFu15i_BFu15ll { int v1; unsigned int v2:15; unsigned long long v3:15; };
struct I_BFu15i_BFu15s { int v1; unsigned int v2:15; unsigned short v3:15; };
struct I_BFu15i_BFu16i { int v1; unsigned int v2:15; unsigned int v3:16; };
struct I_BFu15i_BFu16ll { int v1; unsigned int v2:15; unsigned long long v3:16; };
struct I_BFu15i_BFu16s { int v1; unsigned int v2:15; unsigned short v3:16; };
struct I_BFu15i_BFu17i { int v1; unsigned int v2:15; unsigned int v3:17; };
struct I_BFu15i_BFu17ll { int v1; unsigned int v2:15; unsigned long long v3:17; };
struct I_BFu15i_BFu1c { int v1; unsigned int v2:15; unsigned char v3:1; };
struct I_BFu15i_BFu1i { int v1; unsigned int v2:15; unsigned int v3:1; };
struct I_BFu15i_BFu1ll { int v1; unsigned int v2:15; unsigned long long v3:1; };
struct I_BFu15i_BFu1s { int v1; unsigned int v2:15; unsigned short v3:1; };
struct I_BFu15i_BFu31i { int v1; unsigned int v2:15; unsigned int v3:31; };
struct I_BFu15i_BFu31ll { int v1; unsigned int v2:15; unsigned long long v3:31; };
struct I_BFu15i_BFu32i { int v1; unsigned int v2:15; unsigned int v3:32; };
struct I_BFu15i_BFu32ll { int v1; unsigned int v2:15; unsigned long long v3:32; };
struct I_BFu15i_BFu33 { int v1; unsigned int v2:15; unsigned long long v3:33; };
struct I_BFu15i_BFu7c { int v1; unsigned int v2:15; unsigned char v3:7; };
struct I_BFu15i_BFu7i { int v1; unsigned int v2:15; unsigned int v3:7; };
struct I_BFu15i_BFu7ll { int v1; unsigned int v2:15; unsigned long long v3:7; };
struct I_BFu15i_BFu7s { int v1; unsigned int v2:15; unsigned short v3:7; };
struct I_BFu15i_BFu8c { int v1; unsigned int v2:15; unsigned char v3:8; };
struct I_BFu15i_BFu8i { int v1; unsigned int v2:15; unsigned int v3:8; };
struct I_BFu15i_BFu8ll { int v1; unsigned int v2:15; unsigned long long v3:8; };
struct I_BFu15i_BFu8s { int v1; unsigned int v2:15; unsigned short v3:8; };
struct I_BFu15i_BFu9i { int v1; unsigned int v2:15; unsigned int v3:9; };
struct I_BFu15i_BFu9ll { int v1; unsigned int v2:15; unsigned long long v3:9; };
struct I_BFu15i_BFu9s { int v1; unsigned int v2:15; unsigned short v3:9; };
struct I_BFu15i_C { int v1; unsigned int v2:15; char v3; };
struct I_BFu15i_D { int v1; unsigned int v2:15; double v3; };
struct I_BFu15i_F { int v1; unsigned int v2:15; float v3; };
struct I_BFu15i_I { int v1; unsigned int v2:15; int v3; };
struct I_BFu15i_Ip { int v1; unsigned int v2:15; int * v3; };
struct I_BFu15i_L { int v1; unsigned int v2:15; long long v3; };
struct I_BFu15i_S { int v1; unsigned int v2:15; short v3; };
struct I_BFu15i_Uc { int v1; unsigned int v2:15; unsigned char v3; };
struct I_BFu15i_Ui { int v1; unsigned int v2:15; unsigned int v3; };
struct I_BFu15i_Ul { int v1; unsigned int v2:15; unsigned long long v3; };
struct I_BFu15i_Us { int v1; unsigned int v2:15; unsigned short v3; };
struct I_BFu15i_Vp { int v1; unsigned int v2:15; void * v3; };
struct I_BFu15ll { int v1; unsigned long long v2:15; };
struct I_BFu15ll_BFu15i { int v1; unsigned long long v2:15; unsigned int v3:15; };
struct I_BFu15ll_BFu15ll { int v1; unsigned long long v2:15; unsigned long long v3:15; };
struct I_BFu15ll_BFu15s { int v1; unsigned long long v2:15; unsigned short v3:15; };
struct I_BFu15ll_BFu16i { int v1; unsigned long long v2:15; unsigned int v3:16; };
struct I_BFu15ll_BFu16ll { int v1; unsigned long long v2:15; unsigned long long v3:16; };
struct I_BFu15ll_BFu16s { int v1; unsigned long long v2:15; unsigned short v3:16; };
struct I_BFu15ll_BFu17i { int v1; unsigned long long v2:15; unsigned int v3:17; };
struct I_BFu15ll_BFu17ll { int v1; unsigned long long v2:15; unsigned long long v3:17; };
struct I_BFu15ll_BFu1c { int v1; unsigned long long v2:15; unsigned char v3:1; };
struct I_BFu15ll_BFu1i { int v1; unsigned long long v2:15; unsigned int v3:1; };
struct I_BFu15ll_BFu1ll { int v1; unsigned long long v2:15; unsigned long long v3:1; };
struct I_BFu15ll_BFu1s { int v1; unsigned long long v2:15; unsigned short v3:1; };
struct I_BFu15ll_BFu31i { int v1; unsigned long long v2:15; unsigned int v3:31; };
struct I_BFu15ll_BFu31ll { int v1; unsigned long long v2:15; unsigned long long v3:31; };
struct I_BFu15ll_BFu32i { int v1; unsigned long long v2:15; unsigned int v3:32; };
struct I_BFu15ll_BFu32ll { int v1; unsigned long long v2:15; unsigned long long v3:32; };
struct I_BFu15ll_BFu33 { int v1; unsigned long long v2:15; unsigned long long v3:33; };
struct I_BFu15ll_BFu7c { int v1; unsigned long long v2:15; unsigned char v3:7; };
struct I_BFu15ll_BFu7i { int v1; unsigned long long v2:15; unsigned int v3:7; };
struct I_BFu15ll_BFu7ll { int v1; unsigned long long v2:15; unsigned long long v3:7; };
struct I_BFu15ll_BFu7s { int v1; unsigned long long v2:15; unsigned short v3:7; };
struct I_BFu15ll_BFu8c { int v1; unsigned long long v2:15; unsigned char v3:8; };
struct I_BFu15ll_BFu8i { int v1; unsigned long long v2:15; unsigned int v3:8; };
struct I_BFu15ll_BFu8ll { int v1; unsigned long long v2:15; unsigned long long v3:8; };
struct I_BFu15ll_BFu8s { int v1; unsigned long long v2:15; unsigned short v3:8; };
struct I_BFu15ll_BFu9i { int v1; unsigned long long v2:15; unsigned int v3:9; };
struct I_BFu15ll_BFu9ll { int v1; unsigned long long v2:15; unsigned long long v3:9; };
struct I_BFu15ll_BFu9s { int v1; unsigned long long v2:15; unsigned short v3:9; };
struct I_BFu15ll_C { int v1; unsigned long long v2:15; char v3; };
struct I_BFu15ll_D { int v1; unsigned long long v2:15; double v3; };
struct I_BFu15ll_F { int v1; unsigned long long v2:15; float v3; };
struct I_BFu15ll_I { int v1; unsigned long long v2:15; int v3; };
struct I_BFu15ll_Ip { int v1; unsigned long long v2:15; int * v3; };
struct I_BFu15ll_L { int v1; unsigned long long v2:15; long long v3; };
struct I_BFu15ll_S { int v1; unsigned long long v2:15; short v3; };
struct I_BFu15ll_Uc { int v1; unsigned long long v2:15; unsigned char v3; };
struct I_BFu15ll_Ui { int v1; unsigned long long v2:15; unsigned int v3; };
struct I_BFu15ll_Ul { int v1; unsigned long long v2:15; unsigned long long v3; };
struct I_BFu15ll_Us { int v1; unsigned long long v2:15; unsigned short v3; };
struct I_BFu15ll_Vp { int v1; unsigned long long v2:15; void * v3; };
struct I_BFu15s { int v1; unsigned short v2:15; };
struct I_BFu15s_BFu15i { int v1; unsigned short v2:15; unsigned int v3:15; };
struct I_BFu15s_BFu15ll { int v1; unsigned short v2:15; unsigned long long v3:15; };
struct I_BFu15s_BFu15s { int v1; unsigned short v2:15; unsigned short v3:15; };
struct I_BFu15s_BFu16i { int v1; unsigned short v2:15; unsigned int v3:16; };
struct I_BFu15s_BFu16ll { int v1; unsigned short v2:15; unsigned long long v3:16; };
struct I_BFu15s_BFu16s { int v1; unsigned short v2:15; unsigned short v3:16; };
struct I_BFu15s_BFu17i { int v1; unsigned short v2:15; unsigned int v3:17; };
struct I_BFu15s_BFu17ll { int v1; unsigned short v2:15; unsigned long long v3:17; };
struct I_BFu15s_BFu1c { int v1; unsigned short v2:15; unsigned char v3:1; };
struct I_BFu15s_BFu1i { int v1; unsigned short v2:15; unsigned int v3:1; };
struct I_BFu15s_BFu1ll { int v1; unsigned short v2:15; unsigned long long v3:1; };
struct I_BFu15s_BFu1s { int v1; unsigned short v2:15; unsigned short v3:1; };
struct I_BFu15s_BFu31i { int v1; unsigned short v2:15; unsigned int v3:31; };
struct I_BFu15s_BFu31ll { int v1; unsigned short v2:15; unsigned long long v3:31; };
struct I_BFu15s_BFu32i { int v1; unsigned short v2:15; unsigned int v3:32; };
struct I_BFu15s_BFu32ll { int v1; unsigned short v2:15; unsigned long long v3:32; };
struct I_BFu15s_BFu33 { int v1; unsigned short v2:15; unsigned long long v3:33; };
struct I_BFu15s_BFu7c { int v1; unsigned short v2:15; unsigned char v3:7; };
struct I_BFu15s_BFu7i { int v1; unsigned short v2:15; unsigned int v3:7; };
struct I_BFu15s_BFu7ll { int v1; unsigned short v2:15; unsigned long long v3:7; };
struct I_BFu15s_BFu7s { int v1; unsigned short v2:15; unsigned short v3:7; };
struct I_BFu15s_BFu8c { int v1; unsigned short v2:15; unsigned char v3:8; };
struct I_BFu15s_BFu8i { int v1; unsigned short v2:15; unsigned int v3:8; };
struct I_BFu15s_BFu8ll { int v1; unsigned short v2:15; unsigned long long v3:8; };
struct I_BFu15s_BFu8s { int v1; unsigned short v2:15; unsigned short v3:8; };
struct I_BFu15s_BFu9i { int v1; unsigned short v2:15; unsigned int v3:9; };
struct I_BFu15s_BFu9ll { int v1; unsigned short v2:15; unsigned long long v3:9; };
struct I_BFu15s_BFu9s { int v1; unsigned short v2:15; unsigned short v3:9; };
struct I_BFu15s_C { int v1; unsigned short v2:15; char v3; };
struct I_BFu15s_D { int v1; unsigned short v2:15; double v3; };
struct I_BFu15s_F { int v1; unsigned short v2:15; float v3; };
struct I_BFu15s_I { int v1; unsigned short v2:15; int v3; };
struct I_BFu15s_Ip { int v1; unsigned short v2:15; int * v3; };
struct I_BFu15s_L { int v1; unsigned short v2:15; long long v3; };
struct I_BFu15s_S { int v1; unsigned short v2:15; short v3; };
struct I_BFu15s_Uc { int v1; unsigned short v2:15; unsigned char v3; };
struct I_BFu15s_Ui { int v1; unsigned short v2:15; unsigned int v3; };
struct I_BFu15s_Ul { int v1; unsigned short v2:15; unsigned long long v3; };
struct I_BFu15s_Us { int v1; unsigned short v2:15; unsigned short v3; };
struct I_BFu15s_Vp { int v1; unsigned short v2:15; void * v3; };
struct I_BFu16i { int v1; unsigned int v2:16; };
struct I_BFu16i_BFu15i { int v1; unsigned int v2:16; unsigned int v3:15; };
struct I_BFu16i_BFu15ll { int v1; unsigned int v2:16; unsigned long long v3:15; };
struct I_BFu16i_BFu15s { int v1; unsigned int v2:16; unsigned short v3:15; };
struct I_BFu16i_BFu16i { int v1; unsigned int v2:16; unsigned int v3:16; };
struct I_BFu16i_BFu16ll { int v1; unsigned int v2:16; unsigned long long v3:16; };
struct I_BFu16i_BFu16s { int v1; unsigned int v2:16; unsigned short v3:16; };
struct I_BFu16i_BFu17i { int v1; unsigned int v2:16; unsigned int v3:17; };
struct I_BFu16i_BFu17ll { int v1; unsigned int v2:16; unsigned long long v3:17; };
struct I_BFu16i_BFu1c { int v1; unsigned int v2:16; unsigned char v3:1; };
struct I_BFu16i_BFu1i { int v1; unsigned int v2:16; unsigned int v3:1; };
struct I_BFu16i_BFu1ll { int v1; unsigned int v2:16; unsigned long long v3:1; };
struct I_BFu16i_BFu1s { int v1; unsigned int v2:16; unsigned short v3:1; };
struct I_BFu16i_BFu31i { int v1; unsigned int v2:16; unsigned int v3:31; };
struct I_BFu16i_BFu31ll { int v1; unsigned int v2:16; unsigned long long v3:31; };
struct I_BFu16i_BFu32i { int v1; unsigned int v2:16; unsigned int v3:32; };
struct I_BFu16i_BFu32ll { int v1; unsigned int v2:16; unsigned long long v3:32; };
struct I_BFu16i_BFu33 { int v1; unsigned int v2:16; unsigned long long v3:33; };
struct I_BFu16i_BFu7c { int v1; unsigned int v2:16; unsigned char v3:7; };
struct I_BFu16i_BFu7i { int v1; unsigned int v2:16; unsigned int v3:7; };
struct I_BFu16i_BFu7ll { int v1; unsigned int v2:16; unsigned long long v3:7; };
struct I_BFu16i_BFu7s { int v1; unsigned int v2:16; unsigned short v3:7; };
struct I_BFu16i_BFu8c { int v1; unsigned int v2:16; unsigned char v3:8; };
struct I_BFu16i_BFu8i { int v1; unsigned int v2:16; unsigned int v3:8; };
struct I_BFu16i_BFu8ll { int v1; unsigned int v2:16; unsigned long long v3:8; };
struct I_BFu16i_BFu8s { int v1; unsigned int v2:16; unsigned short v3:8; };
struct I_BFu16i_BFu9i { int v1; unsigned int v2:16; unsigned int v3:9; };
struct I_BFu16i_BFu9ll { int v1; unsigned int v2:16; unsigned long long v3:9; };
struct I_BFu16i_BFu9s { int v1; unsigned int v2:16; unsigned short v3:9; };
struct I_BFu16i_C { int v1; unsigned int v2:16; char v3; };
struct I_BFu16i_D { int v1; unsigned int v2:16; double v3; };
struct I_BFu16i_F { int v1; unsigned int v2:16; float v3; };
struct I_BFu16i_I { int v1; unsigned int v2:16; int v3; };
struct I_BFu16i_Ip { int v1; unsigned int v2:16; int * v3; };
struct I_BFu16i_L { int v1; unsigned int v2:16; long long v3; };
struct I_BFu16i_S { int v1; unsigned int v2:16; short v3; };
struct I_BFu16i_Uc { int v1; unsigned int v2:16; unsigned char v3; };
struct I_BFu16i_Ui { int v1; unsigned int v2:16; unsigned int v3; };
struct I_BFu16i_Ul { int v1; unsigned int v2:16; unsigned long long v3; };
struct I_BFu16i_Us { int v1; unsigned int v2:16; unsigned short v3; };
struct I_BFu16i_Vp { int v1; unsigned int v2:16; void * v3; };
struct I_BFu16ll { int v1; unsigned long long v2:16; };
struct I_BFu16ll_BFu15i { int v1; unsigned long long v2:16; unsigned int v3:15; };
struct I_BFu16ll_BFu15ll { int v1; unsigned long long v2:16; unsigned long long v3:15; };
struct I_BFu16ll_BFu15s { int v1; unsigned long long v2:16; unsigned short v3:15; };
struct I_BFu16ll_BFu16i { int v1; unsigned long long v2:16; unsigned int v3:16; };
struct I_BFu16ll_BFu16ll { int v1; unsigned long long v2:16; unsigned long long v3:16; };
struct I_BFu16ll_BFu16s { int v1; unsigned long long v2:16; unsigned short v3:16; };
struct I_BFu16ll_BFu17i { int v1; unsigned long long v2:16; unsigned int v3:17; };
struct I_BFu16ll_BFu17ll { int v1; unsigned long long v2:16; unsigned long long v3:17; };
struct I_BFu16ll_BFu1c { int v1; unsigned long long v2:16; unsigned char v3:1; };
struct I_BFu16ll_BFu1i { int v1; unsigned long long v2:16; unsigned int v3:1; };
struct I_BFu16ll_BFu1ll { int v1; unsigned long long v2:16; unsigned long long v3:1; };
struct I_BFu16ll_BFu1s { int v1; unsigned long long v2:16; unsigned short v3:1; };
struct I_BFu16ll_BFu31i { int v1; unsigned long long v2:16; unsigned int v3:31; };
struct I_BFu16ll_BFu31ll { int v1; unsigned long long v2:16; unsigned long long v3:31; };
struct I_BFu16ll_BFu32i { int v1; unsigned long long v2:16; unsigned int v3:32; };
struct I_BFu16ll_BFu32ll { int v1; unsigned long long v2:16; unsigned long long v3:32; };
struct I_BFu16ll_BFu33 { int v1; unsigned long long v2:16; unsigned long long v3:33; };
struct I_BFu16ll_BFu7c { int v1; unsigned long long v2:16; unsigned char v3:7; };
struct I_BFu16ll_BFu7i { int v1; unsigned long long v2:16; unsigned int v3:7; };
struct I_BFu16ll_BFu7ll { int v1; unsigned long long v2:16; unsigned long long v3:7; };
struct I_BFu16ll_BFu7s { int v1; unsigned long long v2:16; unsigned short v3:7; };
struct I_BFu16ll_BFu8c { int v1; unsigned long long v2:16; unsigned char v3:8; };
struct I_BFu16ll_BFu8i { int v1; unsigned long long v2:16; unsigned int v3:8; };
struct I_BFu16ll_BFu8ll { int v1; unsigned long long v2:16; unsigned long long v3:8; };
struct I_BFu16ll_BFu8s { int v1; unsigned long long v2:16; unsigned short v3:8; };
struct I_BFu16ll_BFu9i { int v1; unsigned long long v2:16; unsigned int v3:9; };
struct I_BFu16ll_BFu9ll { int v1; unsigned long long v2:16; unsigned long long v3:9; };
struct I_BFu16ll_BFu9s { int v1; unsigned long long v2:16; unsigned short v3:9; };
struct I_BFu16ll_C { int v1; unsigned long long v2:16; char v3; };
struct I_BFu16ll_D { int v1; unsigned long long v2:16; double v3; };
struct I_BFu16ll_F { int v1; unsigned long long v2:16; float v3; };
struct I_BFu16ll_I { int v1; unsigned long long v2:16; int v3; };
struct I_BFu16ll_Ip { int v1; unsigned long long v2:16; int * v3; };
struct I_BFu16ll_L { int v1; unsigned long long v2:16; long long v3; };
struct I_BFu16ll_S { int v1; unsigned long long v2:16; short v3; };
struct I_BFu16ll_Uc { int v1; unsigned long long v2:16; unsigned char v3; };
struct I_BFu16ll_Ui { int v1; unsigned long long v2:16; unsigned int v3; };
struct I_BFu16ll_Ul { int v1; unsigned long long v2:16; unsigned long long v3; };
struct I_BFu16ll_Us { int v1; unsigned long long v2:16; unsigned short v3; };
struct I_BFu16ll_Vp { int v1; unsigned long long v2:16; void * v3; };
struct I_BFu16s { int v1; unsigned short v2:16; };
struct I_BFu16s_BFu15i { int v1; unsigned short v2:16; unsigned int v3:15; };
struct I_BFu16s_BFu15ll { int v1; unsigned short v2:16; unsigned long long v3:15; };
struct I_BFu16s_BFu15s { int v1; unsigned short v2:16; unsigned short v3:15; };
struct I_BFu16s_BFu16i { int v1; unsigned short v2:16; unsigned int v3:16; };
struct I_BFu16s_BFu16ll { int v1; unsigned short v2:16; unsigned long long v3:16; };
struct I_BFu16s_BFu16s { int v1; unsigned short v2:16; unsigned short v3:16; };
struct I_BFu16s_BFu17i { int v1; unsigned short v2:16; unsigned int v3:17; };
struct I_BFu16s_BFu17ll { int v1; unsigned short v2:16; unsigned long long v3:17; };
struct I_BFu16s_BFu1c { int v1; unsigned short v2:16; unsigned char v3:1; };
struct I_BFu16s_BFu1i { int v1; unsigned short v2:16; unsigned int v3:1; };
struct I_BFu16s_BFu1ll { int v1; unsigned short v2:16; unsigned long long v3:1; };
struct I_BFu16s_BFu1s { int v1; unsigned short v2:16; unsigned short v3:1; };
struct I_BFu16s_BFu31i { int v1; unsigned short v2:16; unsigned int v3:31; };
struct I_BFu16s_BFu31ll { int v1; unsigned short v2:16; unsigned long long v3:31; };
struct I_BFu16s_BFu32i { int v1; unsigned short v2:16; unsigned int v3:32; };
struct I_BFu16s_BFu32ll { int v1; unsigned short v2:16; unsigned long long v3:32; };
struct I_BFu16s_BFu33 { int v1; unsigned short v2:16; unsigned long long v3:33; };
struct I_BFu16s_BFu7c { int v1; unsigned short v2:16; unsigned char v3:7; };
struct I_BFu16s_BFu7i { int v1; unsigned short v2:16; unsigned int v3:7; };
struct I_BFu16s_BFu7ll { int v1; unsigned short v2:16; unsigned long long v3:7; };
struct I_BFu16s_BFu7s { int v1; unsigned short v2:16; unsigned short v3:7; };
struct I_BFu16s_BFu8c { int v1; unsigned short v2:16; unsigned char v3:8; };
struct I_BFu16s_BFu8i { int v1; unsigned short v2:16; unsigned int v3:8; };
struct I_BFu16s_BFu8ll { int v1; unsigned short v2:16; unsigned long long v3:8; };
struct I_BFu16s_BFu8s { int v1; unsigned short v2:16; unsigned short v3:8; };
struct I_BFu16s_BFu9i { int v1; unsigned short v2:16; unsigned int v3:9; };
struct I_BFu16s_BFu9ll { int v1; unsigned short v2:16; unsigned long long v3:9; };
struct I_BFu16s_BFu9s { int v1; unsigned short v2:16; unsigned short v3:9; };
struct I_BFu16s_C { int v1; unsigned short v2:16; char v3; };
struct I_BFu16s_D { int v1; unsigned short v2:16; double v3; };
struct I_BFu16s_F { int v1; unsigned short v2:16; float v3; };
struct I_BFu16s_I { int v1; unsigned short v2:16; int v3; };
struct I_BFu16s_Ip { int v1; unsigned short v2:16; int * v3; };
struct I_BFu16s_L { int v1; unsigned short v2:16; long long v3; };
struct I_BFu16s_S { int v1; unsigned short v2:16; short v3; };
struct I_BFu16s_Uc { int v1; unsigned short v2:16; unsigned char v3; };
struct I_BFu16s_Ui { int v1; unsigned short v2:16; unsigned int v3; };
struct I_BFu16s_Ul { int v1; unsigned short v2:16; unsigned long long v3; };
struct I_BFu16s_Us { int v1; unsigned short v2:16; unsigned short v3; };
struct I_BFu16s_Vp { int v1; unsigned short v2:16; void * v3; };
struct I_BFu17i { int v1; unsigned int v2:17; };
struct I_BFu17i_BFu15i { int v1; unsigned int v2:17; unsigned int v3:15; };
struct I_BFu17i_BFu15ll { int v1; unsigned int v2:17; unsigned long long v3:15; };
struct I_BFu17i_BFu15s { int v1; unsigned int v2:17; unsigned short v3:15; };
struct I_BFu17i_BFu16i { int v1; unsigned int v2:17; unsigned int v3:16; };
struct I_BFu17i_BFu16ll { int v1; unsigned int v2:17; unsigned long long v3:16; };
struct I_BFu17i_BFu16s { int v1; unsigned int v2:17; unsigned short v3:16; };
struct I_BFu17i_BFu17i { int v1; unsigned int v2:17; unsigned int v3:17; };
struct I_BFu17i_BFu17ll { int v1; unsigned int v2:17; unsigned long long v3:17; };
struct I_BFu17i_BFu1c { int v1; unsigned int v2:17; unsigned char v3:1; };
struct I_BFu17i_BFu1i { int v1; unsigned int v2:17; unsigned int v3:1; };
struct I_BFu17i_BFu1ll { int v1; unsigned int v2:17; unsigned long long v3:1; };
struct I_BFu17i_BFu1s { int v1; unsigned int v2:17; unsigned short v3:1; };
struct I_BFu17i_BFu31i { int v1; unsigned int v2:17; unsigned int v3:31; };
struct I_BFu17i_BFu31ll { int v1; unsigned int v2:17; unsigned long long v3:31; };
struct I_BFu17i_BFu32i { int v1; unsigned int v2:17; unsigned int v3:32; };
struct I_BFu17i_BFu32ll { int v1; unsigned int v2:17; unsigned long long v3:32; };
struct I_BFu17i_BFu33 { int v1; unsigned int v2:17; unsigned long long v3:33; };
struct I_BFu17i_BFu7c { int v1; unsigned int v2:17; unsigned char v3:7; };
struct I_BFu17i_BFu7i { int v1; unsigned int v2:17; unsigned int v3:7; };
struct I_BFu17i_BFu7ll { int v1; unsigned int v2:17; unsigned long long v3:7; };
struct I_BFu17i_BFu7s { int v1; unsigned int v2:17; unsigned short v3:7; };
struct I_BFu17i_BFu8c { int v1; unsigned int v2:17; unsigned char v3:8; };
struct I_BFu17i_BFu8i { int v1; unsigned int v2:17; unsigned int v3:8; };
struct I_BFu17i_BFu8ll { int v1; unsigned int v2:17; unsigned long long v3:8; };
struct I_BFu17i_BFu8s { int v1; unsigned int v2:17; unsigned short v3:8; };
struct I_BFu17i_BFu9i { int v1; unsigned int v2:17; unsigned int v3:9; };
struct I_BFu17i_BFu9ll { int v1; unsigned int v2:17; unsigned long long v3:9; };
struct I_BFu17i_BFu9s { int v1; unsigned int v2:17; unsigned short v3:9; };
struct I_BFu17i_C { int v1; unsigned int v2:17; char v3; };
struct I_BFu17i_D { int v1; unsigned int v2:17; double v3; };
struct I_BFu17i_F { int v1; unsigned int v2:17; float v3; };
struct I_BFu17i_I { int v1; unsigned int v2:17; int v3; };
struct I_BFu17i_Ip { int v1; unsigned int v2:17; int * v3; };
struct I_BFu17i_L { int v1; unsigned int v2:17; long long v3; };
struct I_BFu17i_S { int v1; unsigned int v2:17; short v3; };
struct I_BFu17i_Uc { int v1; unsigned int v2:17; unsigned char v3; };
struct I_BFu17i_Ui { int v1; unsigned int v2:17; unsigned int v3; };
struct I_BFu17i_Ul { int v1; unsigned int v2:17; unsigned long long v3; };
struct I_BFu17i_Us { int v1; unsigned int v2:17; unsigned short v3; };
struct I_BFu17i_Vp { int v1; unsigned int v2:17; void * v3; };
struct I_BFu17ll { int v1; unsigned long long v2:17; };
struct I_BFu17ll_BFu15i { int v1; unsigned long long v2:17; unsigned int v3:15; };
struct I_BFu17ll_BFu15ll { int v1; unsigned long long v2:17; unsigned long long v3:15; };
struct I_BFu17ll_BFu15s { int v1; unsigned long long v2:17; unsigned short v3:15; };
struct I_BFu17ll_BFu16i { int v1; unsigned long long v2:17; unsigned int v3:16; };
struct I_BFu17ll_BFu16ll { int v1; unsigned long long v2:17; unsigned long long v3:16; };
struct I_BFu17ll_BFu16s { int v1; unsigned long long v2:17; unsigned short v3:16; };
struct I_BFu17ll_BFu17i { int v1; unsigned long long v2:17; unsigned int v3:17; };
struct I_BFu17ll_BFu17ll { int v1; unsigned long long v2:17; unsigned long long v3:17; };
struct I_BFu17ll_BFu1c { int v1; unsigned long long v2:17; unsigned char v3:1; };
struct I_BFu17ll_BFu1i { int v1; unsigned long long v2:17; unsigned int v3:1; };
struct I_BFu17ll_BFu1ll { int v1; unsigned long long v2:17; unsigned long long v3:1; };
struct I_BFu17ll_BFu1s { int v1; unsigned long long v2:17; unsigned short v3:1; };
struct I_BFu17ll_BFu31i { int v1; unsigned long long v2:17; unsigned int v3:31; };
struct I_BFu17ll_BFu31ll { int v1; unsigned long long v2:17; unsigned long long v3:31; };
struct I_BFu17ll_BFu32i { int v1; unsigned long long v2:17; unsigned int v3:32; };
struct I_BFu17ll_BFu32ll { int v1; unsigned long long v2:17; unsigned long long v3:32; };
struct I_BFu17ll_BFu33 { int v1; unsigned long long v2:17; unsigned long long v3:33; };
struct I_BFu17ll_BFu7c { int v1; unsigned long long v2:17; unsigned char v3:7; };
struct I_BFu17ll_BFu7i { int v1; unsigned long long v2:17; unsigned int v3:7; };
struct I_BFu17ll_BFu7ll { int v1; unsigned long long v2:17; unsigned long long v3:7; };
struct I_BFu17ll_BFu7s { int v1; unsigned long long v2:17; unsigned short v3:7; };
struct I_BFu17ll_BFu8c { int v1; unsigned long long v2:17; unsigned char v3:8; };
struct I_BFu17ll_BFu8i { int v1; unsigned long long v2:17; unsigned int v3:8; };
struct I_BFu17ll_BFu8ll { int v1; unsigned long long v2:17; unsigned long long v3:8; };
struct I_BFu17ll_BFu8s { int v1; unsigned long long v2:17; unsigned short v3:8; };
struct I_BFu17ll_BFu9i { int v1; unsigned long long v2:17; unsigned int v3:9; };
struct I_BFu17ll_BFu9ll { int v1; unsigned long long v2:17; unsigned long long v3:9; };
struct I_BFu17ll_BFu9s { int v1; unsigned long long v2:17; unsigned short v3:9; };
struct I_BFu17ll_C { int v1; unsigned long long v2:17; char v3; };
struct I_BFu17ll_D { int v1; unsigned long long v2:17; double v3; };
struct I_BFu17ll_F { int v1; unsigned long long v2:17; float v3; };
struct I_BFu17ll_I { int v1; unsigned long long v2:17; int v3; };
struct I_BFu17ll_Ip { int v1; unsigned long long v2:17; int * v3; };
struct I_BFu17ll_L { int v1; unsigned long long v2:17; long long v3; };
struct I_BFu17ll_S { int v1; unsigned long long v2:17; short v3; };
struct I_BFu17ll_Uc { int v1; unsigned long long v2:17; unsigned char v3; };
struct I_BFu17ll_Ui { int v1; unsigned long long v2:17; unsigned int v3; };
struct I_BFu17ll_Ul { int v1; unsigned long long v2:17; unsigned long long v3; };
struct I_BFu17ll_Us { int v1; unsigned long long v2:17; unsigned short v3; };
struct I_BFu17ll_Vp { int v1; unsigned long long v2:17; void * v3; };
struct I_BFu1c { int v1; unsigned char v2:1; };
struct I_BFu1c_BFu15i { int v1; unsigned char v2:1; unsigned int v3:15; };
struct I_BFu1c_BFu15ll { int v1; unsigned char v2:1; unsigned long long v3:15; };
struct I_BFu1c_BFu15s { int v1; unsigned char v2:1; unsigned short v3:15; };
struct I_BFu1c_BFu16i { int v1; unsigned char v2:1; unsigned int v3:16; };
struct I_BFu1c_BFu16ll { int v1; unsigned char v2:1; unsigned long long v3:16; };
struct I_BFu1c_BFu16s { int v1; unsigned char v2:1; unsigned short v3:16; };
struct I_BFu1c_BFu17i { int v1; unsigned char v2:1; unsigned int v3:17; };
struct I_BFu1c_BFu17ll { int v1; unsigned char v2:1; unsigned long long v3:17; };
struct I_BFu1c_BFu1c { int v1; unsigned char v2:1; unsigned char v3:1; };
struct I_BFu1c_BFu1i { int v1; unsigned char v2:1; unsigned int v3:1; };
struct I_BFu1c_BFu1ll { int v1; unsigned char v2:1; unsigned long long v3:1; };
struct I_BFu1c_BFu1s { int v1; unsigned char v2:1; unsigned short v3:1; };
struct I_BFu1c_BFu31i { int v1; unsigned char v2:1; unsigned int v3:31; };
struct I_BFu1c_BFu31ll { int v1; unsigned char v2:1; unsigned long long v3:31; };
struct I_BFu1c_BFu32i { int v1; unsigned char v2:1; unsigned int v3:32; };
struct I_BFu1c_BFu32ll { int v1; unsigned char v2:1; unsigned long long v3:32; };
struct I_BFu1c_BFu33 { int v1; unsigned char v2:1; unsigned long long v3:33; };
struct I_BFu1c_BFu7c { int v1; unsigned char v2:1; unsigned char v3:7; };
struct I_BFu1c_BFu7i { int v1; unsigned char v2:1; unsigned int v3:7; };
struct I_BFu1c_BFu7ll { int v1; unsigned char v2:1; unsigned long long v3:7; };
struct I_BFu1c_BFu7s { int v1; unsigned char v2:1; unsigned short v3:7; };
struct I_BFu1c_BFu8c { int v1; unsigned char v2:1; unsigned char v3:8; };
struct I_BFu1c_BFu8i { int v1; unsigned char v2:1; unsigned int v3:8; };
struct I_BFu1c_BFu8ll { int v1; unsigned char v2:1; unsigned long long v3:8; };
struct I_BFu1c_BFu8s { int v1; unsigned char v2:1; unsigned short v3:8; };
struct I_BFu1c_BFu9i { int v1; unsigned char v2:1; unsigned int v3:9; };
struct I_BFu1c_BFu9ll { int v1; unsigned char v2:1; unsigned long long v3:9; };
struct I_BFu1c_BFu9s { int v1; unsigned char v2:1; unsigned short v3:9; };
struct I_BFu1c_C { int v1; unsigned char v2:1; char v3; };
struct I_BFu1c_D { int v1; unsigned char v2:1; double v3; };
struct I_BFu1c_F { int v1; unsigned char v2:1; float v3; };
struct I_BFu1c_I { int v1; unsigned char v2:1; int v3; };
struct I_BFu1c_Ip { int v1; unsigned char v2:1; int * v3; };
struct I_BFu1c_L { int v1; unsigned char v2:1; long long v3; };
struct I_BFu1c_S { int v1; unsigned char v2:1; short v3; };
struct I_BFu1c_Uc { int v1; unsigned char v2:1; unsigned char v3; };
struct I_BFu1c_Ui { int v1; unsigned char v2:1; unsigned int v3; };
struct I_BFu1c_Ul { int v1; unsigned char v2:1; unsigned long long v3; };
struct I_BFu1c_Us { int v1; unsigned char v2:1; unsigned short v3; };
struct I_BFu1c_Vp { int v1; unsigned char v2:1; void * v3; };
struct I_BFu1i { int v1; unsigned int v2:1; };
struct I_BFu1i_BFu15i { int v1; unsigned int v2:1; unsigned int v3:15; };
struct I_BFu1i_BFu15ll { int v1; unsigned int v2:1; unsigned long long v3:15; };
struct I_BFu1i_BFu15s { int v1; unsigned int v2:1; unsigned short v3:15; };
struct I_BFu1i_BFu16i { int v1; unsigned int v2:1; unsigned int v3:16; };
struct I_BFu1i_BFu16ll { int v1; unsigned int v2:1; unsigned long long v3:16; };
struct I_BFu1i_BFu16s { int v1; unsigned int v2:1; unsigned short v3:16; };
struct I_BFu1i_BFu17i { int v1; unsigned int v2:1; unsigned int v3:17; };
struct I_BFu1i_BFu17ll { int v1; unsigned int v2:1; unsigned long long v3:17; };
struct I_BFu1i_BFu1c { int v1; unsigned int v2:1; unsigned char v3:1; };
struct I_BFu1i_BFu1i { int v1; unsigned int v2:1; unsigned int v3:1; };
struct I_BFu1i_BFu1ll { int v1; unsigned int v2:1; unsigned long long v3:1; };
struct I_BFu1i_BFu1s { int v1; unsigned int v2:1; unsigned short v3:1; };
struct I_BFu1i_BFu31i { int v1; unsigned int v2:1; unsigned int v3:31; };
struct I_BFu1i_BFu31ll { int v1; unsigned int v2:1; unsigned long long v3:31; };
struct I_BFu1i_BFu32i { int v1; unsigned int v2:1; unsigned int v3:32; };
struct I_BFu1i_BFu32ll { int v1; unsigned int v2:1; unsigned long long v3:32; };
struct I_BFu1i_BFu33 { int v1; unsigned int v2:1; unsigned long long v3:33; };
struct I_BFu1i_BFu7c { int v1; unsigned int v2:1; unsigned char v3:7; };
struct I_BFu1i_BFu7i { int v1; unsigned int v2:1; unsigned int v3:7; };
struct I_BFu1i_BFu7ll { int v1; unsigned int v2:1; unsigned long long v3:7; };
struct I_BFu1i_BFu7s { int v1; unsigned int v2:1; unsigned short v3:7; };
struct I_BFu1i_BFu8c { int v1; unsigned int v2:1; unsigned char v3:8; };
struct I_BFu1i_BFu8i { int v1; unsigned int v2:1; unsigned int v3:8; };
struct I_BFu1i_BFu8ll { int v1; unsigned int v2:1; unsigned long long v3:8; };
struct I_BFu1i_BFu8s { int v1; unsigned int v2:1; unsigned short v3:8; };
struct I_BFu1i_BFu9i { int v1; unsigned int v2:1; unsigned int v3:9; };
struct I_BFu1i_BFu9ll { int v1; unsigned int v2:1; unsigned long long v3:9; };
struct I_BFu1i_BFu9s { int v1; unsigned int v2:1; unsigned short v3:9; };
struct I_BFu1i_C { int v1; unsigned int v2:1; char v3; };
struct I_BFu1i_D { int v1; unsigned int v2:1; double v3; };
struct I_BFu1i_F { int v1; unsigned int v2:1; float v3; };
struct I_BFu1i_I { int v1; unsigned int v2:1; int v3; };
struct I_BFu1i_Ip { int v1; unsigned int v2:1; int * v3; };
struct I_BFu1i_L { int v1; unsigned int v2:1; long long v3; };
struct I_BFu1i_S { int v1; unsigned int v2:1; short v3; };
struct I_BFu1i_Uc { int v1; unsigned int v2:1; unsigned char v3; };
struct I_BFu1i_Ui { int v1; unsigned int v2:1; unsigned int v3; };
struct I_BFu1i_Ul { int v1; unsigned int v2:1; unsigned long long v3; };
struct I_BFu1i_Us { int v1; unsigned int v2:1; unsigned short v3; };
struct I_BFu1i_Vp { int v1; unsigned int v2:1; void * v3; };
struct I_BFu1ll { int v1; unsigned long long v2:1; };
struct I_BFu1ll_BFu15i { int v1; unsigned long long v2:1; unsigned int v3:15; };
struct I_BFu1ll_BFu15ll { int v1; unsigned long long v2:1; unsigned long long v3:15; };
struct I_BFu1ll_BFu15s { int v1; unsigned long long v2:1; unsigned short v3:15; };
struct I_BFu1ll_BFu16i { int v1; unsigned long long v2:1; unsigned int v3:16; };
struct I_BFu1ll_BFu16ll { int v1; unsigned long long v2:1; unsigned long long v3:16; };
struct I_BFu1ll_BFu16s { int v1; unsigned long long v2:1; unsigned short v3:16; };
struct I_BFu1ll_BFu17i { int v1; unsigned long long v2:1; unsigned int v3:17; };
struct I_BFu1ll_BFu17ll { int v1; unsigned long long v2:1; unsigned long long v3:17; };
struct I_BFu1ll_BFu1c { int v1; unsigned long long v2:1; unsigned char v3:1; };
struct I_BFu1ll_BFu1i { int v1; unsigned long long v2:1; unsigned int v3:1; };
struct I_BFu1ll_BFu1ll { int v1; unsigned long long v2:1; unsigned long long v3:1; };
struct I_BFu1ll_BFu1s { int v1; unsigned long long v2:1; unsigned short v3:1; };
struct I_BFu1ll_BFu31i { int v1; unsigned long long v2:1; unsigned int v3:31; };
struct I_BFu1ll_BFu31ll { int v1; unsigned long long v2:1; unsigned long long v3:31; };
struct I_BFu1ll_BFu32i { int v1; unsigned long long v2:1; unsigned int v3:32; };
struct I_BFu1ll_BFu32ll { int v1; unsigned long long v2:1; unsigned long long v3:32; };
struct I_BFu1ll_BFu33 { int v1; unsigned long long v2:1; unsigned long long v3:33; };
struct I_BFu1ll_BFu7c { int v1; unsigned long long v2:1; unsigned char v3:7; };
struct I_BFu1ll_BFu7i { int v1; unsigned long long v2:1; unsigned int v3:7; };
struct I_BFu1ll_BFu7ll { int v1; unsigned long long v2:1; unsigned long long v3:7; };
struct I_BFu1ll_BFu7s { int v1; unsigned long long v2:1; unsigned short v3:7; };
struct I_BFu1ll_BFu8c { int v1; unsigned long long v2:1; unsigned char v3:8; };
struct I_BFu1ll_BFu8i { int v1; unsigned long long v2:1; unsigned int v3:8; };
struct I_BFu1ll_BFu8ll { int v1; unsigned long long v2:1; unsigned long long v3:8; };
struct I_BFu1ll_BFu8s { int v1; unsigned long long v2:1; unsigned short v3:8; };
struct I_BFu1ll_BFu9i { int v1; unsigned long long v2:1; unsigned int v3:9; };
struct I_BFu1ll_BFu9ll { int v1; unsigned long long v2:1; unsigned long long v3:9; };
struct I_BFu1ll_BFu9s { int v1; unsigned long long v2:1; unsigned short v3:9; };
struct I_BFu1ll_C { int v1; unsigned long long v2:1; char v3; };
struct I_BFu1ll_D { int v1; unsigned long long v2:1; double v3; };
struct I_BFu1ll_F { int v1; unsigned long long v2:1; float v3; };
struct I_BFu1ll_I { int v1; unsigned long long v2:1; int v3; };
struct I_BFu1ll_Ip { int v1; unsigned long long v2:1; int * v3; };
struct I_BFu1ll_L { int v1; unsigned long long v2:1; long long v3; };
struct I_BFu1ll_S { int v1; unsigned long long v2:1; short v3; };
struct I_BFu1ll_Uc { int v1; unsigned long long v2:1; unsigned char v3; };
struct I_BFu1ll_Ui { int v1; unsigned long long v2:1; unsigned int v3; };
struct I_BFu1ll_Ul { int v1; unsigned long long v2:1; unsigned long long v3; };
struct I_BFu1ll_Us { int v1; unsigned long long v2:1; unsigned short v3; };
struct I_BFu1ll_Vp { int v1; unsigned long long v2:1; void * v3; };
struct I_BFu1s { int v1; unsigned short v2:1; };
struct I_BFu1s_BFu15i { int v1; unsigned short v2:1; unsigned int v3:15; };
struct I_BFu1s_BFu15ll { int v1; unsigned short v2:1; unsigned long long v3:15; };
struct I_BFu1s_BFu15s { int v1; unsigned short v2:1; unsigned short v3:15; };
struct I_BFu1s_BFu16i { int v1; unsigned short v2:1; unsigned int v3:16; };
struct I_BFu1s_BFu16ll { int v1; unsigned short v2:1; unsigned long long v3:16; };
struct I_BFu1s_BFu16s { int v1; unsigned short v2:1; unsigned short v3:16; };
struct I_BFu1s_BFu17i { int v1; unsigned short v2:1; unsigned int v3:17; };
struct I_BFu1s_BFu17ll { int v1; unsigned short v2:1; unsigned long long v3:17; };
struct I_BFu1s_BFu1c { int v1; unsigned short v2:1; unsigned char v3:1; };
struct I_BFu1s_BFu1i { int v1; unsigned short v2:1; unsigned int v3:1; };
struct I_BFu1s_BFu1ll { int v1; unsigned short v2:1; unsigned long long v3:1; };
struct I_BFu1s_BFu1s { int v1; unsigned short v2:1; unsigned short v3:1; };
struct I_BFu1s_BFu31i { int v1; unsigned short v2:1; unsigned int v3:31; };
struct I_BFu1s_BFu31ll { int v1; unsigned short v2:1; unsigned long long v3:31; };
struct I_BFu1s_BFu32i { int v1; unsigned short v2:1; unsigned int v3:32; };
struct I_BFu1s_BFu32ll { int v1; unsigned short v2:1; unsigned long long v3:32; };
struct I_BFu1s_BFu33 { int v1; unsigned short v2:1; unsigned long long v3:33; };
struct I_BFu1s_BFu7c { int v1; unsigned short v2:1; unsigned char v3:7; };
struct I_BFu1s_BFu7i { int v1; unsigned short v2:1; unsigned int v3:7; };
struct I_BFu1s_BFu7ll { int v1; unsigned short v2:1; unsigned long long v3:7; };
struct I_BFu1s_BFu7s { int v1; unsigned short v2:1; unsigned short v3:7; };
struct I_BFu1s_BFu8c { int v1; unsigned short v2:1; unsigned char v3:8; };
struct I_BFu1s_BFu8i { int v1; unsigned short v2:1; unsigned int v3:8; };
struct I_BFu1s_BFu8ll { int v1; unsigned short v2:1; unsigned long long v3:8; };
struct I_BFu1s_BFu8s { int v1; unsigned short v2:1; unsigned short v3:8; };
struct I_BFu1s_BFu9i { int v1; unsigned short v2:1; unsigned int v3:9; };
struct I_BFu1s_BFu9ll { int v1; unsigned short v2:1; unsigned long long v3:9; };
struct I_BFu1s_BFu9s { int v1; unsigned short v2:1; unsigned short v3:9; };
struct I_BFu1s_C { int v1; unsigned short v2:1; char v3; };
struct I_BFu1s_D { int v1; unsigned short v2:1; double v3; };
struct I_BFu1s_F { int v1; unsigned short v2:1; float v3; };
struct I_BFu1s_I { int v1; unsigned short v2:1; int v3; };
struct I_BFu1s_Ip { int v1; unsigned short v2:1; int * v3; };
struct I_BFu1s_L { int v1; unsigned short v2:1; long long v3; };
struct I_BFu1s_S { int v1; unsigned short v2:1; short v3; };
struct I_BFu1s_Uc { int v1; unsigned short v2:1; unsigned char v3; };
struct I_BFu1s_Ui { int v1; unsigned short v2:1; unsigned int v3; };
struct I_BFu1s_Ul { int v1; unsigned short v2:1; unsigned long long v3; };
struct I_BFu1s_Us { int v1; unsigned short v2:1; unsigned short v3; };
struct I_BFu1s_Vp { int v1; unsigned short v2:1; void * v3; };
struct I_BFu31i { int v1; unsigned int v2:31; };
struct I_BFu31i_BFu15i { int v1; unsigned int v2:31; unsigned int v3:15; };
struct I_BFu31i_BFu15ll { int v1; unsigned int v2:31; unsigned long long v3:15; };
struct I_BFu31i_BFu15s { int v1; unsigned int v2:31; unsigned short v3:15; };
struct I_BFu31i_BFu16i { int v1; unsigned int v2:31; unsigned int v3:16; };
struct I_BFu31i_BFu16ll { int v1; unsigned int v2:31; unsigned long long v3:16; };
struct I_BFu31i_BFu16s { int v1; unsigned int v2:31; unsigned short v3:16; };
struct I_BFu31i_BFu17i { int v1; unsigned int v2:31; unsigned int v3:17; };
struct I_BFu31i_BFu17ll { int v1; unsigned int v2:31; unsigned long long v3:17; };
struct I_BFu31i_BFu1c { int v1; unsigned int v2:31; unsigned char v3:1; };
struct I_BFu31i_BFu1i { int v1; unsigned int v2:31; unsigned int v3:1; };
struct I_BFu31i_BFu1ll { int v1; unsigned int v2:31; unsigned long long v3:1; };
struct I_BFu31i_BFu1s { int v1; unsigned int v2:31; unsigned short v3:1; };
struct I_BFu31i_BFu31i { int v1; unsigned int v2:31; unsigned int v3:31; };
struct I_BFu31i_BFu31ll { int v1; unsigned int v2:31; unsigned long long v3:31; };
struct I_BFu31i_BFu32i { int v1; unsigned int v2:31; unsigned int v3:32; };
struct I_BFu31i_BFu32ll { int v1; unsigned int v2:31; unsigned long long v3:32; };
struct I_BFu31i_BFu33 { int v1; unsigned int v2:31; unsigned long long v3:33; };
struct I_BFu31i_BFu7c { int v1; unsigned int v2:31; unsigned char v3:7; };
struct I_BFu31i_BFu7i { int v1; unsigned int v2:31; unsigned int v3:7; };
struct I_BFu31i_BFu7ll { int v1; unsigned int v2:31; unsigned long long v3:7; };
struct I_BFu31i_BFu7s { int v1; unsigned int v2:31; unsigned short v3:7; };
struct I_BFu31i_BFu8c { int v1; unsigned int v2:31; unsigned char v3:8; };
struct I_BFu31i_BFu8i { int v1; unsigned int v2:31; unsigned int v3:8; };
struct I_BFu31i_BFu8ll { int v1; unsigned int v2:31; unsigned long long v3:8; };
struct I_BFu31i_BFu8s { int v1; unsigned int v2:31; unsigned short v3:8; };
struct I_BFu31i_BFu9i { int v1; unsigned int v2:31; unsigned int v3:9; };
struct I_BFu31i_BFu9ll { int v1; unsigned int v2:31; unsigned long long v3:9; };
struct I_BFu31i_BFu9s { int v1; unsigned int v2:31; unsigned short v3:9; };
struct I_BFu31i_C { int v1; unsigned int v2:31; char v3; };
struct I_BFu31i_D { int v1; unsigned int v2:31; double v3; };
struct I_BFu31i_F { int v1; unsigned int v2:31; float v3; };
struct I_BFu31i_I { int v1; unsigned int v2:31; int v3; };
struct I_BFu31i_Ip { int v1; unsigned int v2:31; int * v3; };
struct I_BFu31i_L { int v1; unsigned int v2:31; long long v3; };
struct I_BFu31i_S { int v1; unsigned int v2:31; short v3; };
struct I_BFu31i_Uc { int v1; unsigned int v2:31; unsigned char v3; };
struct I_BFu31i_Ui { int v1; unsigned int v2:31; unsigned int v3; };
struct I_BFu31i_Ul { int v1; unsigned int v2:31; unsigned long long v3; };
struct I_BFu31i_Us { int v1; unsigned int v2:31; unsigned short v3; };
struct I_BFu31i_Vp { int v1; unsigned int v2:31; void * v3; };
struct I_BFu31ll { int v1; unsigned long long v2:31; };
struct I_BFu31ll_BFu15i { int v1; unsigned long long v2:31; unsigned int v3:15; };
struct I_BFu31ll_BFu15ll { int v1; unsigned long long v2:31; unsigned long long v3:15; };
struct I_BFu31ll_BFu15s { int v1; unsigned long long v2:31; unsigned short v3:15; };
struct I_BFu31ll_BFu16i { int v1; unsigned long long v2:31; unsigned int v3:16; };
struct I_BFu31ll_BFu16ll { int v1; unsigned long long v2:31; unsigned long long v3:16; };
struct I_BFu31ll_BFu16s { int v1; unsigned long long v2:31; unsigned short v3:16; };
struct I_BFu31ll_BFu17i { int v1; unsigned long long v2:31; unsigned int v3:17; };
struct I_BFu31ll_BFu17ll { int v1; unsigned long long v2:31; unsigned long long v3:17; };
struct I_BFu31ll_BFu1c { int v1; unsigned long long v2:31; unsigned char v3:1; };
struct I_BFu31ll_BFu1i { int v1; unsigned long long v2:31; unsigned int v3:1; };
struct I_BFu31ll_BFu1ll { int v1; unsigned long long v2:31; unsigned long long v3:1; };
struct I_BFu31ll_BFu1s { int v1; unsigned long long v2:31; unsigned short v3:1; };
struct I_BFu31ll_BFu31i { int v1; unsigned long long v2:31; unsigned int v3:31; };
struct I_BFu31ll_BFu31ll { int v1; unsigned long long v2:31; unsigned long long v3:31; };
struct I_BFu31ll_BFu32i { int v1; unsigned long long v2:31; unsigned int v3:32; };
struct I_BFu31ll_BFu32ll { int v1; unsigned long long v2:31; unsigned long long v3:32; };
struct I_BFu31ll_BFu33 { int v1; unsigned long long v2:31; unsigned long long v3:33; };
struct I_BFu31ll_BFu7c { int v1; unsigned long long v2:31; unsigned char v3:7; };
struct I_BFu31ll_BFu7i { int v1; unsigned long long v2:31; unsigned int v3:7; };
struct I_BFu31ll_BFu7ll { int v1; unsigned long long v2:31; unsigned long long v3:7; };
struct I_BFu31ll_BFu7s { int v1; unsigned long long v2:31; unsigned short v3:7; };
struct I_BFu31ll_BFu8c { int v1; unsigned long long v2:31; unsigned char v3:8; };
struct I_BFu31ll_BFu8i { int v1; unsigned long long v2:31; unsigned int v3:8; };
struct I_BFu31ll_BFu8ll { int v1; unsigned long long v2:31; unsigned long long v3:8; };
struct I_BFu31ll_BFu8s { int v1; unsigned long long v2:31; unsigned short v3:8; };
struct I_BFu31ll_BFu9i { int v1; unsigned long long v2:31; unsigned int v3:9; };
struct I_BFu31ll_BFu9ll { int v1; unsigned long long v2:31; unsigned long long v3:9; };
struct I_BFu31ll_BFu9s { int v1; unsigned long long v2:31; unsigned short v3:9; };
struct I_BFu31ll_C { int v1; unsigned long long v2:31; char v3; };
struct I_BFu31ll_D { int v1; unsigned long long v2:31; double v3; };
struct I_BFu31ll_F { int v1; unsigned long long v2:31; float v3; };
struct I_BFu31ll_I { int v1; unsigned long long v2:31; int v3; };
struct I_BFu31ll_Ip { int v1; unsigned long long v2:31; int * v3; };
struct I_BFu31ll_L { int v1; unsigned long long v2:31; long long v3; };
struct I_BFu31ll_S { int v1; unsigned long long v2:31; short v3; };
struct I_BFu31ll_Uc { int v1; unsigned long long v2:31; unsigned char v3; };
struct I_BFu31ll_Ui { int v1; unsigned long long v2:31; unsigned int v3; };
struct I_BFu31ll_Ul { int v1; unsigned long long v2:31; unsigned long long v3; };
struct I_BFu31ll_Us { int v1; unsigned long long v2:31; unsigned short v3; };
struct I_BFu31ll_Vp { int v1; unsigned long long v2:31; void * v3; };
struct I_BFu32i { int v1; unsigned int v2:32; };
struct I_BFu32i_BFu15i { int v1; unsigned int v2:32; unsigned int v3:15; };
struct I_BFu32i_BFu15ll { int v1; unsigned int v2:32; unsigned long long v3:15; };
struct I_BFu32i_BFu15s { int v1; unsigned int v2:32; unsigned short v3:15; };
struct I_BFu32i_BFu16i { int v1; unsigned int v2:32; unsigned int v3:16; };
struct I_BFu32i_BFu16ll { int v1; unsigned int v2:32; unsigned long long v3:16; };
struct I_BFu32i_BFu16s { int v1; unsigned int v2:32; unsigned short v3:16; };
struct I_BFu32i_BFu17i { int v1; unsigned int v2:32; unsigned int v3:17; };
struct I_BFu32i_BFu17ll { int v1; unsigned int v2:32; unsigned long long v3:17; };
struct I_BFu32i_BFu1c { int v1; unsigned int v2:32; unsigned char v3:1; };
struct I_BFu32i_BFu1i { int v1; unsigned int v2:32; unsigned int v3:1; };
struct I_BFu32i_BFu1ll { int v1; unsigned int v2:32; unsigned long long v3:1; };
struct I_BFu32i_BFu1s { int v1; unsigned int v2:32; unsigned short v3:1; };
struct I_BFu32i_BFu31i { int v1; unsigned int v2:32; unsigned int v3:31; };
struct I_BFu32i_BFu31ll { int v1; unsigned int v2:32; unsigned long long v3:31; };
struct I_BFu32i_BFu32i { int v1; unsigned int v2:32; unsigned int v3:32; };
struct I_BFu32i_BFu32ll { int v1; unsigned int v2:32; unsigned long long v3:32; };
struct I_BFu32i_BFu33 { int v1; unsigned int v2:32; unsigned long long v3:33; };
struct I_BFu32i_BFu7c { int v1; unsigned int v2:32; unsigned char v3:7; };
struct I_BFu32i_BFu7i { int v1; unsigned int v2:32; unsigned int v3:7; };
struct I_BFu32i_BFu7ll { int v1; unsigned int v2:32; unsigned long long v3:7; };
struct I_BFu32i_BFu7s { int v1; unsigned int v2:32; unsigned short v3:7; };
struct I_BFu32i_BFu8c { int v1; unsigned int v2:32; unsigned char v3:8; };
struct I_BFu32i_BFu8i { int v1; unsigned int v2:32; unsigned int v3:8; };
struct I_BFu32i_BFu8ll { int v1; unsigned int v2:32; unsigned long long v3:8; };
struct I_BFu32i_BFu8s { int v1; unsigned int v2:32; unsigned short v3:8; };
struct I_BFu32i_BFu9i { int v1; unsigned int v2:32; unsigned int v3:9; };
struct I_BFu32i_BFu9ll { int v1; unsigned int v2:32; unsigned long long v3:9; };
struct I_BFu32i_BFu9s { int v1; unsigned int v2:32; unsigned short v3:9; };
struct I_BFu32i_C { int v1; unsigned int v2:32; char v3; };
struct I_BFu32i_D { int v1; unsigned int v2:32; double v3; };
struct I_BFu32i_F { int v1; unsigned int v2:32; float v3; };
struct I_BFu32i_I { int v1; unsigned int v2:32; int v3; };
struct I_BFu32i_Ip { int v1; unsigned int v2:32; int * v3; };
struct I_BFu32i_L { int v1; unsigned int v2:32; long long v3; };
struct I_BFu32i_S { int v1; unsigned int v2:32; short v3; };
struct I_BFu32i_Uc { int v1; unsigned int v2:32; unsigned char v3; };
struct I_BFu32i_Ui { int v1; unsigned int v2:32; unsigned int v3; };
struct I_BFu32i_Ul { int v1; unsigned int v2:32; unsigned long long v3; };
struct I_BFu32i_Us { int v1; unsigned int v2:32; unsigned short v3; };
struct I_BFu32i_Vp { int v1; unsigned int v2:32; void * v3; };
struct I_BFu32ll { int v1; unsigned long long v2:32; };
struct I_BFu32ll_BFu15i { int v1; unsigned long long v2:32; unsigned int v3:15; };
struct I_BFu32ll_BFu15ll { int v1; unsigned long long v2:32; unsigned long long v3:15; };
struct I_BFu32ll_BFu15s { int v1; unsigned long long v2:32; unsigned short v3:15; };
struct I_BFu32ll_BFu16i { int v1; unsigned long long v2:32; unsigned int v3:16; };
struct I_BFu32ll_BFu16ll { int v1; unsigned long long v2:32; unsigned long long v3:16; };
struct I_BFu32ll_BFu16s { int v1; unsigned long long v2:32; unsigned short v3:16; };
struct I_BFu32ll_BFu17i { int v1; unsigned long long v2:32; unsigned int v3:17; };
struct I_BFu32ll_BFu17ll { int v1; unsigned long long v2:32; unsigned long long v3:17; };
struct I_BFu32ll_BFu1c { int v1; unsigned long long v2:32; unsigned char v3:1; };
struct I_BFu32ll_BFu1i { int v1; unsigned long long v2:32; unsigned int v3:1; };
struct I_BFu32ll_BFu1ll { int v1; unsigned long long v2:32; unsigned long long v3:1; };
struct I_BFu32ll_BFu1s { int v1; unsigned long long v2:32; unsigned short v3:1; };
struct I_BFu32ll_BFu31i { int v1; unsigned long long v2:32; unsigned int v3:31; };
struct I_BFu32ll_BFu31ll { int v1; unsigned long long v2:32; unsigned long long v3:31; };
struct I_BFu32ll_BFu32i { int v1; unsigned long long v2:32; unsigned int v3:32; };
struct I_BFu32ll_BFu32ll { int v1; unsigned long long v2:32; unsigned long long v3:32; };
struct I_BFu32ll_BFu33 { int v1; unsigned long long v2:32; unsigned long long v3:33; };
struct I_BFu32ll_BFu7c { int v1; unsigned long long v2:32; unsigned char v3:7; };
struct I_BFu32ll_BFu7i { int v1; unsigned long long v2:32; unsigned int v3:7; };
struct I_BFu32ll_BFu7ll { int v1; unsigned long long v2:32; unsigned long long v3:7; };
struct I_BFu32ll_BFu7s { int v1; unsigned long long v2:32; unsigned short v3:7; };
struct I_BFu32ll_BFu8c { int v1; unsigned long long v2:32; unsigned char v3:8; };
struct I_BFu32ll_BFu8i { int v1; unsigned long long v2:32; unsigned int v3:8; };
struct I_BFu32ll_BFu8ll { int v1; unsigned long long v2:32; unsigned long long v3:8; };
struct I_BFu32ll_BFu8s { int v1; unsigned long long v2:32; unsigned short v3:8; };
struct I_BFu32ll_BFu9i { int v1; unsigned long long v2:32; unsigned int v3:9; };
struct I_BFu32ll_BFu9ll { int v1; unsigned long long v2:32; unsigned long long v3:9; };
struct I_BFu32ll_BFu9s { int v1; unsigned long long v2:32; unsigned short v3:9; };
struct I_BFu32ll_C { int v1; unsigned long long v2:32; char v3; };
struct I_BFu32ll_D { int v1; unsigned long long v2:32; double v3; };
struct I_BFu32ll_F { int v1; unsigned long long v2:32; float v3; };
struct I_BFu32ll_I { int v1; unsigned long long v2:32; int v3; };
struct I_BFu32ll_Ip { int v1; unsigned long long v2:32; int * v3; };
struct I_BFu32ll_L { int v1; unsigned long long v2:32; long long v3; };
struct I_BFu32ll_S { int v1; unsigned long long v2:32; short v3; };
struct I_BFu32ll_Uc { int v1; unsigned long long v2:32; unsigned char v3; };
struct I_BFu32ll_Ui { int v1; unsigned long long v2:32; unsigned int v3; };
struct I_BFu32ll_Ul { int v1; unsigned long long v2:32; unsigned long long v3; };
struct I_BFu32ll_Us { int v1; unsigned long long v2:32; unsigned short v3; };
struct I_BFu32ll_Vp { int v1; unsigned long long v2:32; void * v3; };
struct I_BFu33 { int v1; unsigned long long v2:33; };
struct I_BFu33_BFu15i { int v1; unsigned long long v2:33; unsigned int v3:15; };
struct I_BFu33_BFu15ll { int v1; unsigned long long v2:33; unsigned long long v3:15; };
struct I_BFu33_BFu15s { int v1; unsigned long long v2:33; unsigned short v3:15; };
struct I_BFu33_BFu16i { int v1; unsigned long long v2:33; unsigned int v3:16; };
struct I_BFu33_BFu16ll { int v1; unsigned long long v2:33; unsigned long long v3:16; };
struct I_BFu33_BFu16s { int v1; unsigned long long v2:33; unsigned short v3:16; };
struct I_BFu33_BFu17i { int v1; unsigned long long v2:33; unsigned int v3:17; };
struct I_BFu33_BFu17ll { int v1; unsigned long long v2:33; unsigned long long v3:17; };
struct I_BFu33_BFu1c { int v1; unsigned long long v2:33; unsigned char v3:1; };
struct I_BFu33_BFu1i { int v1; unsigned long long v2:33; unsigned int v3:1; };
struct I_BFu33_BFu1ll { int v1; unsigned long long v2:33; unsigned long long v3:1; };
struct I_BFu33_BFu1s { int v1; unsigned long long v2:33; unsigned short v3:1; };
struct I_BFu33_BFu31i { int v1; unsigned long long v2:33; unsigned int v3:31; };
struct I_BFu33_BFu31ll { int v1; unsigned long long v2:33; unsigned long long v3:31; };
struct I_BFu33_BFu32i { int v1; unsigned long long v2:33; unsigned int v3:32; };
struct I_BFu33_BFu32ll { int v1; unsigned long long v2:33; unsigned long long v3:32; };
struct I_BFu33_BFu33 { int v1; unsigned long long v2:33; unsigned long long v3:33; };
struct I_BFu33_BFu7c { int v1; unsigned long long v2:33; unsigned char v3:7; };
struct I_BFu33_BFu7i { int v1; unsigned long long v2:33; unsigned int v3:7; };
struct I_BFu33_BFu7ll { int v1; unsigned long long v2:33; unsigned long long v3:7; };
struct I_BFu33_BFu7s { int v1; unsigned long long v2:33; unsigned short v3:7; };
struct I_BFu33_BFu8c { int v1; unsigned long long v2:33; unsigned char v3:8; };
struct I_BFu33_BFu8i { int v1; unsigned long long v2:33; unsigned int v3:8; };
struct I_BFu33_BFu8ll { int v1; unsigned long long v2:33; unsigned long long v3:8; };
struct I_BFu33_BFu8s { int v1; unsigned long long v2:33; unsigned short v3:8; };
struct I_BFu33_BFu9i { int v1; unsigned long long v2:33; unsigned int v3:9; };
struct I_BFu33_BFu9ll { int v1; unsigned long long v2:33; unsigned long long v3:9; };
struct I_BFu33_BFu9s { int v1; unsigned long long v2:33; unsigned short v3:9; };
struct I_BFu33_C { int v1; unsigned long long v2:33; char v3; };
struct I_BFu33_D { int v1; unsigned long long v2:33; double v3; };
struct I_BFu33_F { int v1; unsigned long long v2:33; float v3; };
struct I_BFu33_I { int v1; unsigned long long v2:33; int v3; };
struct I_BFu33_Ip { int v1; unsigned long long v2:33; int * v3; };
struct I_BFu33_L { int v1; unsigned long long v2:33; long long v3; };
struct I_BFu33_S { int v1; unsigned long long v2:33; short v3; };
struct I_BFu33_Uc { int v1; unsigned long long v2:33; unsigned char v3; };
struct I_BFu33_Ui { int v1; unsigned long long v2:33; unsigned int v3; };
struct I_BFu33_Ul { int v1; unsigned long long v2:33; unsigned long long v3; };
struct I_BFu33_Us { int v1; unsigned long long v2:33; unsigned short v3; };
struct I_BFu33_Vp { int v1; unsigned long long v2:33; void * v3; };
struct I_BFu7c { int v1; unsigned char v2:7; };
struct I_BFu7c_BFu15i { int v1; unsigned char v2:7; unsigned int v3:15; };
struct I_BFu7c_BFu15ll { int v1; unsigned char v2:7; unsigned long long v3:15; };
struct I_BFu7c_BFu15s { int v1; unsigned char v2:7; unsigned short v3:15; };
struct I_BFu7c_BFu16i { int v1; unsigned char v2:7; unsigned int v3:16; };
struct I_BFu7c_BFu16ll { int v1; unsigned char v2:7; unsigned long long v3:16; };
struct I_BFu7c_BFu16s { int v1; unsigned char v2:7; unsigned short v3:16; };
struct I_BFu7c_BFu17i { int v1; unsigned char v2:7; unsigned int v3:17; };
struct I_BFu7c_BFu17ll { int v1; unsigned char v2:7; unsigned long long v3:17; };
struct I_BFu7c_BFu1c { int v1; unsigned char v2:7; unsigned char v3:1; };
struct I_BFu7c_BFu1i { int v1; unsigned char v2:7; unsigned int v3:1; };
struct I_BFu7c_BFu1ll { int v1; unsigned char v2:7; unsigned long long v3:1; };
struct I_BFu7c_BFu1s { int v1; unsigned char v2:7; unsigned short v3:1; };
struct I_BFu7c_BFu31i { int v1; unsigned char v2:7; unsigned int v3:31; };
struct I_BFu7c_BFu31ll { int v1; unsigned char v2:7; unsigned long long v3:31; };
struct I_BFu7c_BFu32i { int v1; unsigned char v2:7; unsigned int v3:32; };
struct I_BFu7c_BFu32ll { int v1; unsigned char v2:7; unsigned long long v3:32; };
struct I_BFu7c_BFu33 { int v1; unsigned char v2:7; unsigned long long v3:33; };
struct I_BFu7c_BFu7c { int v1; unsigned char v2:7; unsigned char v3:7; };
struct I_BFu7c_BFu7i { int v1; unsigned char v2:7; unsigned int v3:7; };
struct I_BFu7c_BFu7ll { int v1; unsigned char v2:7; unsigned long long v3:7; };
struct I_BFu7c_BFu7s { int v1; unsigned char v2:7; unsigned short v3:7; };
struct I_BFu7c_BFu8c { int v1; unsigned char v2:7; unsigned char v3:8; };
struct I_BFu7c_BFu8i { int v1; unsigned char v2:7; unsigned int v3:8; };
struct I_BFu7c_BFu8ll { int v1; unsigned char v2:7; unsigned long long v3:8; };
struct I_BFu7c_BFu8s { int v1; unsigned char v2:7; unsigned short v3:8; };
struct I_BFu7c_BFu9i { int v1; unsigned char v2:7; unsigned int v3:9; };
struct I_BFu7c_BFu9ll { int v1; unsigned char v2:7; unsigned long long v3:9; };
struct I_BFu7c_BFu9s { int v1; unsigned char v2:7; unsigned short v3:9; };
struct I_BFu7c_C { int v1; unsigned char v2:7; char v3; };
struct I_BFu7c_D { int v1; unsigned char v2:7; double v3; };
struct I_BFu7c_F { int v1; unsigned char v2:7; float v3; };
struct I_BFu7c_I { int v1; unsigned char v2:7; int v3; };
struct I_BFu7c_Ip { int v1; unsigned char v2:7; int * v3; };
struct I_BFu7c_L { int v1; unsigned char v2:7; long long v3; };
struct I_BFu7c_S { int v1; unsigned char v2:7; short v3; };
struct I_BFu7c_Uc { int v1; unsigned char v2:7; unsigned char v3; };
struct I_BFu7c_Ui { int v1; unsigned char v2:7; unsigned int v3; };
struct I_BFu7c_Ul { int v1; unsigned char v2:7; unsigned long long v3; };
struct I_BFu7c_Us { int v1; unsigned char v2:7; unsigned short v3; };
struct I_BFu7c_Vp { int v1; unsigned char v2:7; void * v3; };
struct I_BFu7i { int v1; unsigned int v2:7; };
struct I_BFu7i_BFu15i { int v1; unsigned int v2:7; unsigned int v3:15; };
struct I_BFu7i_BFu15ll { int v1; unsigned int v2:7; unsigned long long v3:15; };
struct I_BFu7i_BFu15s { int v1; unsigned int v2:7; unsigned short v3:15; };
struct I_BFu7i_BFu16i { int v1; unsigned int v2:7; unsigned int v3:16; };
struct I_BFu7i_BFu16ll { int v1; unsigned int v2:7; unsigned long long v3:16; };
struct I_BFu7i_BFu16s { int v1; unsigned int v2:7; unsigned short v3:16; };
struct I_BFu7i_BFu17i { int v1; unsigned int v2:7; unsigned int v3:17; };
struct I_BFu7i_BFu17ll { int v1; unsigned int v2:7; unsigned long long v3:17; };
struct I_BFu7i_BFu1c { int v1; unsigned int v2:7; unsigned char v3:1; };
struct I_BFu7i_BFu1i { int v1; unsigned int v2:7; unsigned int v3:1; };
struct I_BFu7i_BFu1ll { int v1; unsigned int v2:7; unsigned long long v3:1; };
struct I_BFu7i_BFu1s { int v1; unsigned int v2:7; unsigned short v3:1; };
struct I_BFu7i_BFu31i { int v1; unsigned int v2:7; unsigned int v3:31; };
struct I_BFu7i_BFu31ll { int v1; unsigned int v2:7; unsigned long long v3:31; };
struct I_BFu7i_BFu32i { int v1; unsigned int v2:7; unsigned int v3:32; };
struct I_BFu7i_BFu32ll { int v1; unsigned int v2:7; unsigned long long v3:32; };
struct I_BFu7i_BFu33 { int v1; unsigned int v2:7; unsigned long long v3:33; };


static void Test_D_BFu9i_BFu31i()
{
  {
    init_simple_test("D_BFu9i_BFu31i");
    static STRUCT_IF_C D_BFu9i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(D_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "D_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "D_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu31i, D_BFu9i_BFu31i)
//============================================================================



static void Test_D_BFu9i_BFu31ll()
{
  {
    init_simple_test("D_BFu9i_BFu31ll");
    static STRUCT_IF_C D_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(D_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "D_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "D_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu31ll, D_BFu9i_BFu31ll)
//============================================================================



static void Test_D_BFu9i_BFu32i()
{
  {
    init_simple_test("D_BFu9i_BFu32i");
    static STRUCT_IF_C D_BFu9i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "D_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "D_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu32i, D_BFu9i_BFu32i)
//============================================================================



static void Test_D_BFu9i_BFu32ll()
{
  {
    init_simple_test("D_BFu9i_BFu32ll");
    static STRUCT_IF_C D_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "D_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "D_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu32ll, D_BFu9i_BFu32ll)
//============================================================================



static void Test_D_BFu9i_BFu33()
{
  {
    init_simple_test("D_BFu9i_BFu33");
    static STRUCT_IF_C D_BFu9i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "D_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "D_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu33, D_BFu9i_BFu33)
//============================================================================



static void Test_D_BFu9i_BFu7c()
{
  {
    init_simple_test("D_BFu9i_BFu7c");
    static STRUCT_IF_C D_BFu9i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu7c, D_BFu9i_BFu7c)
//============================================================================



static void Test_D_BFu9i_BFu7i()
{
  {
    init_simple_test("D_BFu9i_BFu7i");
    static STRUCT_IF_C D_BFu9i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu7i, D_BFu9i_BFu7i)
//============================================================================



static void Test_D_BFu9i_BFu7ll()
{
  {
    init_simple_test("D_BFu9i_BFu7ll");
    static STRUCT_IF_C D_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu7ll, D_BFu9i_BFu7ll)
//============================================================================



static void Test_D_BFu9i_BFu7s()
{
  {
    init_simple_test("D_BFu9i_BFu7s");
    static STRUCT_IF_C D_BFu9i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu7s, D_BFu9i_BFu7s)
//============================================================================



static void Test_D_BFu9i_BFu8c()
{
  {
    init_simple_test("D_BFu9i_BFu8c");
    static STRUCT_IF_C D_BFu9i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu8c, D_BFu9i_BFu8c)
//============================================================================



static void Test_D_BFu9i_BFu8i()
{
  {
    init_simple_test("D_BFu9i_BFu8i");
    static STRUCT_IF_C D_BFu9i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu8i, D_BFu9i_BFu8i)
//============================================================================



static void Test_D_BFu9i_BFu8ll()
{
  {
    init_simple_test("D_BFu9i_BFu8ll");
    static STRUCT_IF_C D_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu8ll, D_BFu9i_BFu8ll)
//============================================================================



static void Test_D_BFu9i_BFu8s()
{
  {
    init_simple_test("D_BFu9i_BFu8s");
    static STRUCT_IF_C D_BFu9i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu8s, D_BFu9i_BFu8s)
//============================================================================



static void Test_D_BFu9i_BFu9i()
{
  {
    init_simple_test("D_BFu9i_BFu9i");
    static STRUCT_IF_C D_BFu9i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu9i, D_BFu9i_BFu9i)
//============================================================================



static void Test_D_BFu9i_BFu9ll()
{
  {
    init_simple_test("D_BFu9i_BFu9ll");
    static STRUCT_IF_C D_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu9ll, D_BFu9i_BFu9ll)
//============================================================================



static void Test_D_BFu9i_BFu9s()
{
  {
    init_simple_test("D_BFu9i_BFu9s");
    static STRUCT_IF_C D_BFu9i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_BFu9s, D_BFu9i_BFu9s)
//============================================================================



static void Test_D_BFu9i_C()
{
  {
    init_simple_test("D_BFu9i_C");
    static STRUCT_IF_C D_BFu9i_C lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_C)");
    check_field_offset(lv, v1, 0, "D_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_C");
    check_field_offset(lv, v3, 10, "D_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_C, D_BFu9i_C)
//============================================================================



static void Test_D_BFu9i_D()
{
  {
    init_simple_test("D_BFu9i_D");
    static STRUCT_IF_C D_BFu9i_D lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_D)");
    check_field_offset(lv, v1, 0, "D_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_D");
    check_field_offset(lv, v3, 10, "D_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_D, D_BFu9i_D)
//============================================================================



static void Test_D_BFu9i_F()
{
  {
    init_simple_test("D_BFu9i_F");
    static STRUCT_IF_C D_BFu9i_F lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_F)");
    check_field_offset(lv, v1, 0, "D_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_F");
    check_field_offset(lv, v3, 10, "D_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_F, D_BFu9i_F)
//============================================================================



static void Test_D_BFu9i_I()
{
  {
    init_simple_test("D_BFu9i_I");
    static STRUCT_IF_C D_BFu9i_I lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_I)");
    check_field_offset(lv, v1, 0, "D_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_I");
    check_field_offset(lv, v3, 10, "D_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_I, D_BFu9i_I)
//============================================================================



static void Test_D_BFu9i_Ip()
{
  {
    init_simple_test("D_BFu9i_Ip");
    static STRUCT_IF_C D_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_Ip");
    check_field_offset(lv, v3, 10, "D_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_Ip, D_BFu9i_Ip)
//============================================================================



static void Test_D_BFu9i_L()
{
  {
    init_simple_test("D_BFu9i_L");
    static STRUCT_IF_C D_BFu9i_L lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_L)");
    check_field_offset(lv, v1, 0, "D_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_L");
    check_field_offset(lv, v3, 10, "D_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_L, D_BFu9i_L)
//============================================================================



static void Test_D_BFu9i_S()
{
  {
    init_simple_test("D_BFu9i_S");
    static STRUCT_IF_C D_BFu9i_S lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_S)");
    check_field_offset(lv, v1, 0, "D_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_S");
    check_field_offset(lv, v3, 10, "D_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_S, D_BFu9i_S)
//============================================================================



static void Test_D_BFu9i_Uc()
{
  {
    init_simple_test("D_BFu9i_Uc");
    static STRUCT_IF_C D_BFu9i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_Uc");
    check_field_offset(lv, v3, 10, "D_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_Uc, D_BFu9i_Uc)
//============================================================================



static void Test_D_BFu9i_Ui()
{
  {
    init_simple_test("D_BFu9i_Ui");
    static STRUCT_IF_C D_BFu9i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_Ui");
    check_field_offset(lv, v3, 10, "D_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_Ui, D_BFu9i_Ui)
//============================================================================



static void Test_D_BFu9i_Ul()
{
  {
    init_simple_test("D_BFu9i_Ul");
    static STRUCT_IF_C D_BFu9i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_Ul");
    check_field_offset(lv, v3, 10, "D_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_Ul, D_BFu9i_Ul)
//============================================================================



static void Test_D_BFu9i_Us()
{
  {
    init_simple_test("D_BFu9i_Us");
    static STRUCT_IF_C D_BFu9i_Us lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "D_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_Us");
    check_field_offset(lv, v3, 10, "D_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_Us, D_BFu9i_Us)
//============================================================================



static void Test_D_BFu9i_Vp()
{
  {
    init_simple_test("D_BFu9i_Vp");
    static STRUCT_IF_C D_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9i_Vp");
    check_field_offset(lv, v3, 10, "D_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9i_Vp, D_BFu9i_Vp)
//============================================================================



static void Test_D_BFu9ll()
{
  {
    init_simple_test("D_BFu9ll");
    static STRUCT_IF_C D_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll, D_BFu9ll)
//============================================================================



static void Test_D_BFu9ll_BFu15i()
{
  {
    init_simple_test("D_BFu9ll_BFu15i");
    static STRUCT_IF_C D_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "D_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "D_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu15i, D_BFu9ll_BFu15i)
//============================================================================



static void Test_D_BFu9ll_BFu15ll()
{
  {
    init_simple_test("D_BFu9ll_BFu15ll");
    static STRUCT_IF_C D_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "D_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "D_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu15ll, D_BFu9ll_BFu15ll)
//============================================================================



static void Test_D_BFu9ll_BFu15s()
{
  {
    init_simple_test("D_BFu9ll_BFu15s");
    static STRUCT_IF_C D_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "D_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "D_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu15s, D_BFu9ll_BFu15s)
//============================================================================



static void Test_D_BFu9ll_BFu16i()
{
  {
    init_simple_test("D_BFu9ll_BFu16i");
    static STRUCT_IF_C D_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "D_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "D_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu16i, D_BFu9ll_BFu16i)
//============================================================================



static void Test_D_BFu9ll_BFu16ll()
{
  {
    init_simple_test("D_BFu9ll_BFu16ll");
    static STRUCT_IF_C D_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "D_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "D_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu16ll, D_BFu9ll_BFu16ll)
//============================================================================



static void Test_D_BFu9ll_BFu16s()
{
  {
    init_simple_test("D_BFu9ll_BFu16s");
    static STRUCT_IF_C D_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "D_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "D_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu16s, D_BFu9ll_BFu16s)
//============================================================================



static void Test_D_BFu9ll_BFu17i()
{
  {
    init_simple_test("D_BFu9ll_BFu17i");
    static STRUCT_IF_C D_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "D_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "D_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu17i, D_BFu9ll_BFu17i)
//============================================================================



static void Test_D_BFu9ll_BFu17ll()
{
  {
    init_simple_test("D_BFu9ll_BFu17ll");
    static STRUCT_IF_C D_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "D_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "D_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu17ll, D_BFu9ll_BFu17ll)
//============================================================================



static void Test_D_BFu9ll_BFu1c()
{
  {
    init_simple_test("D_BFu9ll_BFu1c");
    static STRUCT_IF_C D_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu1c, D_BFu9ll_BFu1c)
//============================================================================



static void Test_D_BFu9ll_BFu1i()
{
  {
    init_simple_test("D_BFu9ll_BFu1i");
    static STRUCT_IF_C D_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu1i, D_BFu9ll_BFu1i)
//============================================================================



static void Test_D_BFu9ll_BFu1ll()
{
  {
    init_simple_test("D_BFu9ll_BFu1ll");
    static STRUCT_IF_C D_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu1ll, D_BFu9ll_BFu1ll)
//============================================================================



static void Test_D_BFu9ll_BFu1s()
{
  {
    init_simple_test("D_BFu9ll_BFu1s");
    static STRUCT_IF_C D_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu1s, D_BFu9ll_BFu1s)
//============================================================================



static void Test_D_BFu9ll_BFu31i()
{
  {
    init_simple_test("D_BFu9ll_BFu31i");
    static STRUCT_IF_C D_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(D_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "D_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "D_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu31i, D_BFu9ll_BFu31i)
//============================================================================



static void Test_D_BFu9ll_BFu31ll()
{
  {
    init_simple_test("D_BFu9ll_BFu31ll");
    static STRUCT_IF_C D_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(D_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "D_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "D_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu31ll, D_BFu9ll_BFu31ll)
//============================================================================



static void Test_D_BFu9ll_BFu32i()
{
  {
    init_simple_test("D_BFu9ll_BFu32i");
    static STRUCT_IF_C D_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "D_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "D_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu32i, D_BFu9ll_BFu32i)
//============================================================================



static void Test_D_BFu9ll_BFu32ll()
{
  {
    init_simple_test("D_BFu9ll_BFu32ll");
    static STRUCT_IF_C D_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "D_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "D_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu32ll, D_BFu9ll_BFu32ll)
//============================================================================



static void Test_D_BFu9ll_BFu33()
{
  {
    init_simple_test("D_BFu9ll_BFu33");
    static STRUCT_IF_C D_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "D_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "D_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu33, D_BFu9ll_BFu33)
//============================================================================



static void Test_D_BFu9ll_BFu7c()
{
  {
    init_simple_test("D_BFu9ll_BFu7c");
    static STRUCT_IF_C D_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu7c, D_BFu9ll_BFu7c)
//============================================================================



static void Test_D_BFu9ll_BFu7i()
{
  {
    init_simple_test("D_BFu9ll_BFu7i");
    static STRUCT_IF_C D_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu7i, D_BFu9ll_BFu7i)
//============================================================================



static void Test_D_BFu9ll_BFu7ll()
{
  {
    init_simple_test("D_BFu9ll_BFu7ll");
    static STRUCT_IF_C D_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu7ll, D_BFu9ll_BFu7ll)
//============================================================================



static void Test_D_BFu9ll_BFu7s()
{
  {
    init_simple_test("D_BFu9ll_BFu7s");
    static STRUCT_IF_C D_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu7s, D_BFu9ll_BFu7s)
//============================================================================



static void Test_D_BFu9ll_BFu8c()
{
  {
    init_simple_test("D_BFu9ll_BFu8c");
    static STRUCT_IF_C D_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu8c, D_BFu9ll_BFu8c)
//============================================================================



static void Test_D_BFu9ll_BFu8i()
{
  {
    init_simple_test("D_BFu9ll_BFu8i");
    static STRUCT_IF_C D_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu8i, D_BFu9ll_BFu8i)
//============================================================================



static void Test_D_BFu9ll_BFu8ll()
{
  {
    init_simple_test("D_BFu9ll_BFu8ll");
    static STRUCT_IF_C D_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu8ll, D_BFu9ll_BFu8ll)
//============================================================================



static void Test_D_BFu9ll_BFu8s()
{
  {
    init_simple_test("D_BFu9ll_BFu8s");
    static STRUCT_IF_C D_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu8s, D_BFu9ll_BFu8s)
//============================================================================



static void Test_D_BFu9ll_BFu9i()
{
  {
    init_simple_test("D_BFu9ll_BFu9i");
    static STRUCT_IF_C D_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu9i, D_BFu9ll_BFu9i)
//============================================================================



static void Test_D_BFu9ll_BFu9ll()
{
  {
    init_simple_test("D_BFu9ll_BFu9ll");
    static STRUCT_IF_C D_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu9ll, D_BFu9ll_BFu9ll)
//============================================================================



static void Test_D_BFu9ll_BFu9s()
{
  {
    init_simple_test("D_BFu9ll_BFu9s");
    static STRUCT_IF_C D_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_BFu9s, D_BFu9ll_BFu9s)
//============================================================================



static void Test_D_BFu9ll_C()
{
  {
    init_simple_test("D_BFu9ll_C");
    static STRUCT_IF_C D_BFu9ll_C lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_C");
    check_field_offset(lv, v3, 10, "D_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_C, D_BFu9ll_C)
//============================================================================



static void Test_D_BFu9ll_D()
{
  {
    init_simple_test("D_BFu9ll_D");
    static STRUCT_IF_C D_BFu9ll_D lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_D");
    check_field_offset(lv, v3, 10, "D_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_D, D_BFu9ll_D)
//============================================================================



static void Test_D_BFu9ll_F()
{
  {
    init_simple_test("D_BFu9ll_F");
    static STRUCT_IF_C D_BFu9ll_F lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_F");
    check_field_offset(lv, v3, 10, "D_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_F, D_BFu9ll_F)
//============================================================================



static void Test_D_BFu9ll_I()
{
  {
    init_simple_test("D_BFu9ll_I");
    static STRUCT_IF_C D_BFu9ll_I lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_I");
    check_field_offset(lv, v3, 10, "D_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_I, D_BFu9ll_I)
//============================================================================



static void Test_D_BFu9ll_Ip()
{
  {
    init_simple_test("D_BFu9ll_Ip");
    static STRUCT_IF_C D_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_Ip");
    check_field_offset(lv, v3, 10, "D_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_Ip, D_BFu9ll_Ip)
//============================================================================



static void Test_D_BFu9ll_L()
{
  {
    init_simple_test("D_BFu9ll_L");
    static STRUCT_IF_C D_BFu9ll_L lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_L");
    check_field_offset(lv, v3, 10, "D_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_L, D_BFu9ll_L)
//============================================================================



static void Test_D_BFu9ll_S()
{
  {
    init_simple_test("D_BFu9ll_S");
    static STRUCT_IF_C D_BFu9ll_S lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_S");
    check_field_offset(lv, v3, 10, "D_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_S, D_BFu9ll_S)
//============================================================================



static void Test_D_BFu9ll_Uc()
{
  {
    init_simple_test("D_BFu9ll_Uc");
    static STRUCT_IF_C D_BFu9ll_Uc lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_Uc");
    check_field_offset(lv, v3, 10, "D_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_Uc, D_BFu9ll_Uc)
//============================================================================



static void Test_D_BFu9ll_Ui()
{
  {
    init_simple_test("D_BFu9ll_Ui");
    static STRUCT_IF_C D_BFu9ll_Ui lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_Ui");
    check_field_offset(lv, v3, 10, "D_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_Ui, D_BFu9ll_Ui)
//============================================================================



static void Test_D_BFu9ll_Ul()
{
  {
    init_simple_test("D_BFu9ll_Ul");
    static STRUCT_IF_C D_BFu9ll_Ul lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_Ul");
    check_field_offset(lv, v3, 10, "D_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_Ul, D_BFu9ll_Ul)
//============================================================================



static void Test_D_BFu9ll_Us()
{
  {
    init_simple_test("D_BFu9ll_Us");
    static STRUCT_IF_C D_BFu9ll_Us lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_Us");
    check_field_offset(lv, v3, 10, "D_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_Us, D_BFu9ll_Us)
//============================================================================



static void Test_D_BFu9ll_Vp()
{
  {
    init_simple_test("D_BFu9ll_Vp");
    static STRUCT_IF_C D_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9ll_Vp");
    check_field_offset(lv, v3, 10, "D_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9ll_Vp, D_BFu9ll_Vp)
//============================================================================



static void Test_D_BFu9s()
{
  {
    init_simple_test("D_BFu9s");
    static STRUCT_IF_C D_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s, D_BFu9s)
//============================================================================



static void Test_D_BFu9s_BFu15i()
{
  {
    init_simple_test("D_BFu9s_BFu15i");
    static STRUCT_IF_C D_BFu9s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "D_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "D_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu15i, D_BFu9s_BFu15i)
//============================================================================



static void Test_D_BFu9s_BFu15ll()
{
  {
    init_simple_test("D_BFu9s_BFu15ll");
    static STRUCT_IF_C D_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "D_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "D_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu15ll, D_BFu9s_BFu15ll)
//============================================================================



static void Test_D_BFu9s_BFu15s()
{
  {
    init_simple_test("D_BFu9s_BFu15s");
    static STRUCT_IF_C D_BFu9s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "D_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "D_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu15s, D_BFu9s_BFu15s)
//============================================================================



static void Test_D_BFu9s_BFu16i()
{
  {
    init_simple_test("D_BFu9s_BFu16i");
    static STRUCT_IF_C D_BFu9s_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "D_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "D_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu16i, D_BFu9s_BFu16i)
//============================================================================



static void Test_D_BFu9s_BFu16ll()
{
  {
    init_simple_test("D_BFu9s_BFu16ll");
    static STRUCT_IF_C D_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "D_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "D_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu16ll, D_BFu9s_BFu16ll)
//============================================================================



static void Test_D_BFu9s_BFu16s()
{
  {
    init_simple_test("D_BFu9s_BFu16s");
    static STRUCT_IF_C D_BFu9s_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "D_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "D_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu16s, D_BFu9s_BFu16s)
//============================================================================



static void Test_D_BFu9s_BFu17i()
{
  {
    init_simple_test("D_BFu9s_BFu17i");
    static STRUCT_IF_C D_BFu9s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "D_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "D_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu17i, D_BFu9s_BFu17i)
//============================================================================



static void Test_D_BFu9s_BFu17ll()
{
  {
    init_simple_test("D_BFu9s_BFu17ll");
    static STRUCT_IF_C D_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "D_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "D_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu17ll, D_BFu9s_BFu17ll)
//============================================================================



static void Test_D_BFu9s_BFu1c()
{
  {
    init_simple_test("D_BFu9s_BFu1c");
    static STRUCT_IF_C D_BFu9s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu1c, D_BFu9s_BFu1c)
//============================================================================



static void Test_D_BFu9s_BFu1i()
{
  {
    init_simple_test("D_BFu9s_BFu1i");
    static STRUCT_IF_C D_BFu9s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu1i, D_BFu9s_BFu1i)
//============================================================================



static void Test_D_BFu9s_BFu1ll()
{
  {
    init_simple_test("D_BFu9s_BFu1ll");
    static STRUCT_IF_C D_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu1ll, D_BFu9s_BFu1ll)
//============================================================================



static void Test_D_BFu9s_BFu1s()
{
  {
    init_simple_test("D_BFu9s_BFu1s");
    static STRUCT_IF_C D_BFu9s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "D_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu1s, D_BFu9s_BFu1s)
//============================================================================



static void Test_D_BFu9s_BFu31i()
{
  {
    init_simple_test("D_BFu9s_BFu31i");
    static STRUCT_IF_C D_BFu9s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(D_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "D_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "D_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu31i, D_BFu9s_BFu31i)
//============================================================================



static void Test_D_BFu9s_BFu31ll()
{
  {
    init_simple_test("D_BFu9s_BFu31ll");
    static STRUCT_IF_C D_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(D_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "D_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "D_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu31ll, D_BFu9s_BFu31ll)
//============================================================================



static void Test_D_BFu9s_BFu32i()
{
  {
    init_simple_test("D_BFu9s_BFu32i");
    static STRUCT_IF_C D_BFu9s_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "D_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "D_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu32i, D_BFu9s_BFu32i)
//============================================================================



static void Test_D_BFu9s_BFu32ll()
{
  {
    init_simple_test("D_BFu9s_BFu32ll");
    static STRUCT_IF_C D_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "D_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "D_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu32ll, D_BFu9s_BFu32ll)
//============================================================================



static void Test_D_BFu9s_BFu33()
{
  {
    init_simple_test("D_BFu9s_BFu33");
    static STRUCT_IF_C D_BFu9s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "D_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "D_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu33, D_BFu9s_BFu33)
//============================================================================



static void Test_D_BFu9s_BFu7c()
{
  {
    init_simple_test("D_BFu9s_BFu7c");
    static STRUCT_IF_C D_BFu9s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu7c, D_BFu9s_BFu7c)
//============================================================================



static void Test_D_BFu9s_BFu7i()
{
  {
    init_simple_test("D_BFu9s_BFu7i");
    static STRUCT_IF_C D_BFu9s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu7i, D_BFu9s_BFu7i)
//============================================================================



static void Test_D_BFu9s_BFu7ll()
{
  {
    init_simple_test("D_BFu9s_BFu7ll");
    static STRUCT_IF_C D_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu7ll, D_BFu9s_BFu7ll)
//============================================================================



static void Test_D_BFu9s_BFu7s()
{
  {
    init_simple_test("D_BFu9s_BFu7s");
    static STRUCT_IF_C D_BFu9s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(D_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "D_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "D_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu7s, D_BFu9s_BFu7s)
//============================================================================



static void Test_D_BFu9s_BFu8c()
{
  {
    init_simple_test("D_BFu9s_BFu8c");
    static STRUCT_IF_C D_BFu9s_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu8c, D_BFu9s_BFu8c)
//============================================================================



static void Test_D_BFu9s_BFu8i()
{
  {
    init_simple_test("D_BFu9s_BFu8i");
    static STRUCT_IF_C D_BFu9s_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu8i, D_BFu9s_BFu8i)
//============================================================================



static void Test_D_BFu9s_BFu8ll()
{
  {
    init_simple_test("D_BFu9s_BFu8ll");
    static STRUCT_IF_C D_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu8ll, D_BFu9s_BFu8ll)
//============================================================================



static void Test_D_BFu9s_BFu8s()
{
  {
    init_simple_test("D_BFu9s_BFu8s");
    static STRUCT_IF_C D_BFu9s_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "D_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "D_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu8s, D_BFu9s_BFu8s)
//============================================================================



static void Test_D_BFu9s_BFu9i()
{
  {
    init_simple_test("D_BFu9s_BFu9i");
    static STRUCT_IF_C D_BFu9s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu9i, D_BFu9s_BFu9i)
//============================================================================



static void Test_D_BFu9s_BFu9ll()
{
  {
    init_simple_test("D_BFu9s_BFu9ll");
    static STRUCT_IF_C D_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu9ll, D_BFu9s_BFu9ll)
//============================================================================



static void Test_D_BFu9s_BFu9s()
{
  {
    init_simple_test("D_BFu9s_BFu9s");
    static STRUCT_IF_C D_BFu9s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "D_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "D_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "D_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_BFu9s, D_BFu9s_BFu9s)
//============================================================================



static void Test_D_BFu9s_C()
{
  {
    init_simple_test("D_BFu9s_C");
    static STRUCT_IF_C D_BFu9s_C lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_C)");
    check_field_offset(lv, v1, 0, "D_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_C");
    check_field_offset(lv, v3, 10, "D_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_C, D_BFu9s_C)
//============================================================================



static void Test_D_BFu9s_D()
{
  {
    init_simple_test("D_BFu9s_D");
    static STRUCT_IF_C D_BFu9s_D lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_D)");
    check_field_offset(lv, v1, 0, "D_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_D");
    check_field_offset(lv, v3, 10, "D_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_D, D_BFu9s_D)
//============================================================================



static void Test_D_BFu9s_F()
{
  {
    init_simple_test("D_BFu9s_F");
    static STRUCT_IF_C D_BFu9s_F lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_F)");
    check_field_offset(lv, v1, 0, "D_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_F");
    check_field_offset(lv, v3, 10, "D_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_F, D_BFu9s_F)
//============================================================================



static void Test_D_BFu9s_I()
{
  {
    init_simple_test("D_BFu9s_I");
    static STRUCT_IF_C D_BFu9s_I lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_I)");
    check_field_offset(lv, v1, 0, "D_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_I");
    check_field_offset(lv, v3, 10, "D_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_I, D_BFu9s_I)
//============================================================================



static void Test_D_BFu9s_Ip()
{
  {
    init_simple_test("D_BFu9s_Ip");
    static STRUCT_IF_C D_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "D_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_Ip");
    check_field_offset(lv, v3, 10, "D_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_Ip, D_BFu9s_Ip)
//============================================================================



static void Test_D_BFu9s_L()
{
  {
    init_simple_test("D_BFu9s_L");
    static STRUCT_IF_C D_BFu9s_L lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_L)");
    check_field_offset(lv, v1, 0, "D_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_L");
    check_field_offset(lv, v3, 10, "D_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_L, D_BFu9s_L)
//============================================================================



static void Test_D_BFu9s_S()
{
  {
    init_simple_test("D_BFu9s_S");
    static STRUCT_IF_C D_BFu9s_S lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_S)");
    check_field_offset(lv, v1, 0, "D_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_S");
    check_field_offset(lv, v3, 10, "D_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_S, D_BFu9s_S)
//============================================================================



static void Test_D_BFu9s_Uc()
{
  {
    init_simple_test("D_BFu9s_Uc");
    static STRUCT_IF_C D_BFu9s_Uc lv;
    check2(sizeof(lv), 11, "sizeof(D_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "D_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_Uc");
    check_field_offset(lv, v3, 10, "D_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_Uc, D_BFu9s_Uc)
//============================================================================



static void Test_D_BFu9s_Ui()
{
  {
    init_simple_test("D_BFu9s_Ui");
    static STRUCT_IF_C D_BFu9s_Ui lv;
    check2(sizeof(lv), 14, "sizeof(D_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "D_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_Ui");
    check_field_offset(lv, v3, 10, "D_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_Ui, D_BFu9s_Ui)
//============================================================================



static void Test_D_BFu9s_Ul()
{
  {
    init_simple_test("D_BFu9s_Ul");
    static STRUCT_IF_C D_BFu9s_Ul lv;
    check2(sizeof(lv), 18, "sizeof(D_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "D_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_Ul");
    check_field_offset(lv, v3, 10, "D_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_Ul, D_BFu9s_Ul)
//============================================================================



static void Test_D_BFu9s_Us()
{
  {
    init_simple_test("D_BFu9s_Us");
    static STRUCT_IF_C D_BFu9s_Us lv;
    check2(sizeof(lv), 12, "sizeof(D_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "D_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_Us");
    check_field_offset(lv, v3, 10, "D_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_Us, D_BFu9s_Us)
//============================================================================



static void Test_D_BFu9s_Vp()
{
  {
    init_simple_test("D_BFu9s_Vp");
    static STRUCT_IF_C D_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "D_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "D_BFu9s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "D_BFu9s_Vp");
    check_field_offset(lv, v3, 10, "D_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_BFu9s_Vp, D_BFu9s_Vp)
//============================================================================



static void Test_D_C()
{
  {
    init_simple_test("D_C");
    STRUCT_IF_C D_C lv;
    check2(sizeof(lv), 9, "sizeof(D_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_C)");
    check_field_offset(lv, v1, 0, "D_C.v1");
    check_field_offset(lv, v2, 8, "D_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C, D_C)
//============================================================================



static void Test_D_C_BFu15i()
{
  {
    init_simple_test("D_C_BFu15i");
    static STRUCT_IF_C D_C_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu15i)");
    check_field_offset(lv, v1, 0, "D_C_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_C_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu15i, D_C_BFu15i)
//============================================================================



static void Test_D_C_BFu15ll()
{
  {
    init_simple_test("D_C_BFu15ll");
    static STRUCT_IF_C D_C_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_C_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu15ll, D_C_BFu15ll)
//============================================================================



static void Test_D_C_BFu15s()
{
  {
    init_simple_test("D_C_BFu15s");
    static STRUCT_IF_C D_C_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu15s)");
    check_field_offset(lv, v1, 0, "D_C_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_C_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu15s, D_C_BFu15s)
//============================================================================



static void Test_D_C_BFu16i()
{
  {
    init_simple_test("D_C_BFu16i");
    static STRUCT_IF_C D_C_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu16i)");
    check_field_offset(lv, v1, 0, "D_C_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_C_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu16i, D_C_BFu16i)
//============================================================================



static void Test_D_C_BFu16ll()
{
  {
    init_simple_test("D_C_BFu16ll");
    static STRUCT_IF_C D_C_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_C_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu16ll, D_C_BFu16ll)
//============================================================================



static void Test_D_C_BFu16s()
{
  {
    init_simple_test("D_C_BFu16s");
    static STRUCT_IF_C D_C_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu16s)");
    check_field_offset(lv, v1, 0, "D_C_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_C_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu16s, D_C_BFu16s)
//============================================================================



static void Test_D_C_BFu17i()
{
  {
    init_simple_test("D_C_BFu17i");
    static STRUCT_IF_C D_C_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(D_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu17i)");
    check_field_offset(lv, v1, 0, "D_C_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "D_C_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "D_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu17i, D_C_BFu17i)
//============================================================================



static void Test_D_C_BFu17ll()
{
  {
    init_simple_test("D_C_BFu17ll");
    static STRUCT_IF_C D_C_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(D_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "D_C_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "D_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu17ll, D_C_BFu17ll)
//============================================================================



static void Test_D_C_BFu1c()
{
  {
    init_simple_test("D_C_BFu1c");
    static STRUCT_IF_C D_C_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu1c)");
    check_field_offset(lv, v1, 0, "D_C_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu1c, D_C_BFu1c)
//============================================================================



static void Test_D_C_BFu1i()
{
  {
    init_simple_test("D_C_BFu1i");
    static STRUCT_IF_C D_C_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu1i)");
    check_field_offset(lv, v1, 0, "D_C_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu1i, D_C_BFu1i)
//============================================================================



static void Test_D_C_BFu1ll()
{
  {
    init_simple_test("D_C_BFu1ll");
    static STRUCT_IF_C D_C_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu1ll, D_C_BFu1ll)
//============================================================================



static void Test_D_C_BFu1s()
{
  {
    init_simple_test("D_C_BFu1s");
    static STRUCT_IF_C D_C_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu1s)");
    check_field_offset(lv, v1, 0, "D_C_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu1s, D_C_BFu1s)
//============================================================================



static void Test_D_C_BFu31i()
{
  {
    init_simple_test("D_C_BFu31i");
    static STRUCT_IF_C D_C_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(D_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu31i)");
    check_field_offset(lv, v1, 0, "D_C_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "D_C_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "D_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu31i, D_C_BFu31i)
//============================================================================



static void Test_D_C_BFu31ll()
{
  {
    init_simple_test("D_C_BFu31ll");
    static STRUCT_IF_C D_C_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(D_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "D_C_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "D_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu31ll, D_C_BFu31ll)
//============================================================================



static void Test_D_C_BFu32i()
{
  {
    init_simple_test("D_C_BFu32i");
    static STRUCT_IF_C D_C_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(D_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu32i)");
    check_field_offset(lv, v1, 0, "D_C_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "D_C_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "D_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu32i, D_C_BFu32i)
//============================================================================



static void Test_D_C_BFu32ll()
{
  {
    init_simple_test("D_C_BFu32ll");
    static STRUCT_IF_C D_C_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(D_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "D_C_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "D_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu32ll, D_C_BFu32ll)
//============================================================================



static void Test_D_C_BFu33()
{
  {
    init_simple_test("D_C_BFu33");
    static STRUCT_IF_C D_C_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(D_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu33)");
    check_field_offset(lv, v1, 0, "D_C_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "D_C_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "D_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu33, D_C_BFu33)
//============================================================================



static void Test_D_C_BFu7c()
{
  {
    init_simple_test("D_C_BFu7c");
    static STRUCT_IF_C D_C_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu7c)");
    check_field_offset(lv, v1, 0, "D_C_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_C_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu7c, D_C_BFu7c)
//============================================================================



static void Test_D_C_BFu7i()
{
  {
    init_simple_test("D_C_BFu7i");
    static STRUCT_IF_C D_C_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu7i)");
    check_field_offset(lv, v1, 0, "D_C_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_C_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu7i, D_C_BFu7i)
//============================================================================



static void Test_D_C_BFu7ll()
{
  {
    init_simple_test("D_C_BFu7ll");
    static STRUCT_IF_C D_C_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_C_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu7ll, D_C_BFu7ll)
//============================================================================



static void Test_D_C_BFu7s()
{
  {
    init_simple_test("D_C_BFu7s");
    static STRUCT_IF_C D_C_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu7s)");
    check_field_offset(lv, v1, 0, "D_C_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_C_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu7s, D_C_BFu7s)
//============================================================================



static void Test_D_C_BFu8c()
{
  {
    init_simple_test("D_C_BFu8c");
    static STRUCT_IF_C D_C_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu8c)");
    check_field_offset(lv, v1, 0, "D_C_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_C_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu8c, D_C_BFu8c)
//============================================================================



static void Test_D_C_BFu8i()
{
  {
    init_simple_test("D_C_BFu8i");
    static STRUCT_IF_C D_C_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu8i)");
    check_field_offset(lv, v1, 0, "D_C_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_C_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu8i, D_C_BFu8i)
//============================================================================



static void Test_D_C_BFu8ll()
{
  {
    init_simple_test("D_C_BFu8ll");
    static STRUCT_IF_C D_C_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_C_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu8ll, D_C_BFu8ll)
//============================================================================



static void Test_D_C_BFu8s()
{
  {
    init_simple_test("D_C_BFu8s");
    static STRUCT_IF_C D_C_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(D_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu8s)");
    check_field_offset(lv, v1, 0, "D_C_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_C_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu8s, D_C_BFu8s)
//============================================================================



static void Test_D_C_BFu9i()
{
  {
    init_simple_test("D_C_BFu9i");
    static STRUCT_IF_C D_C_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu9i)");
    check_field_offset(lv, v1, 0, "D_C_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_C_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu9i, D_C_BFu9i)
//============================================================================



static void Test_D_C_BFu9ll()
{
  {
    init_simple_test("D_C_BFu9ll");
    static STRUCT_IF_C D_C_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_C_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_C_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu9ll, D_C_BFu9ll)
//============================================================================



static void Test_D_C_BFu9s()
{
  {
    init_simple_test("D_C_BFu9s");
    static STRUCT_IF_C D_C_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(D_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_BFu9s)");
    check_field_offset(lv, v1, 0, "D_C_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_C_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_BFu9s, D_C_BFu9s)
//============================================================================



static void Test_D_C_C()
{
  {
    init_simple_test("D_C_C");
    STRUCT_IF_C D_C_C lv;
    check2(sizeof(lv), 10, "sizeof(D_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_C)");
    check_field_offset(lv, v1, 0, "D_C_C.v1");
    check_field_offset(lv, v2, 8, "D_C_C.v2");
    check_field_offset(lv, v3, 9, "D_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_C, D_C_C)
//============================================================================



static void Test_D_C_D()
{
  {
    init_simple_test("D_C_D");
    STRUCT_IF_C D_C_D lv;
    check2(sizeof(lv), 17, "sizeof(D_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_D)");
    check_field_offset(lv, v1, 0, "D_C_D.v1");
    check_field_offset(lv, v2, 8, "D_C_D.v2");
    check_field_offset(lv, v3, 9, "D_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_D, D_C_D)
//============================================================================



static void Test_D_C_F()
{
  {
    init_simple_test("D_C_F");
    STRUCT_IF_C D_C_F lv;
    check2(sizeof(lv), 13, "sizeof(D_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_F)");
    check_field_offset(lv, v1, 0, "D_C_F.v1");
    check_field_offset(lv, v2, 8, "D_C_F.v2");
    check_field_offset(lv, v3, 9, "D_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_F, D_C_F)
//============================================================================



static void Test_D_C_I()
{
  {
    init_simple_test("D_C_I");
    STRUCT_IF_C D_C_I lv;
    check2(sizeof(lv), 13, "sizeof(D_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_I)");
    check_field_offset(lv, v1, 0, "D_C_I.v1");
    check_field_offset(lv, v2, 8, "D_C_I.v2");
    check_field_offset(lv, v3, 9, "D_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_I, D_C_I)
//============================================================================



static void Test_D_C_Ip()
{
  {
    init_simple_test("D_C_Ip");
    STRUCT_IF_C D_C_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_Ip)");
    check_field_offset(lv, v1, 0, "D_C_Ip.v1");
    check_field_offset(lv, v2, 8, "D_C_Ip.v2");
    check_field_offset(lv, v3, 9, "D_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_Ip, D_C_Ip)
//============================================================================



static void Test_D_C_L()
{
  {
    init_simple_test("D_C_L");
    STRUCT_IF_C D_C_L lv;
    check2(sizeof(lv), 17, "sizeof(D_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_L)");
    check_field_offset(lv, v1, 0, "D_C_L.v1");
    check_field_offset(lv, v2, 8, "D_C_L.v2");
    check_field_offset(lv, v3, 9, "D_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_L, D_C_L)
//============================================================================



static void Test_D_C_S()
{
  {
    init_simple_test("D_C_S");
    STRUCT_IF_C D_C_S lv;
    check2(sizeof(lv), 11, "sizeof(D_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_S)");
    check_field_offset(lv, v1, 0, "D_C_S.v1");
    check_field_offset(lv, v2, 8, "D_C_S.v2");
    check_field_offset(lv, v3, 9, "D_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_S, D_C_S)
//============================================================================



static void Test_D_C_Uc()
{
  {
    init_simple_test("D_C_Uc");
    STRUCT_IF_C D_C_Uc lv;
    check2(sizeof(lv), 10, "sizeof(D_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_Uc)");
    check_field_offset(lv, v1, 0, "D_C_Uc.v1");
    check_field_offset(lv, v2, 8, "D_C_Uc.v2");
    check_field_offset(lv, v3, 9, "D_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_Uc, D_C_Uc)
//============================================================================



static void Test_D_C_Ui()
{
  {
    init_simple_test("D_C_Ui");
    STRUCT_IF_C D_C_Ui lv;
    check2(sizeof(lv), 13, "sizeof(D_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_Ui)");
    check_field_offset(lv, v1, 0, "D_C_Ui.v1");
    check_field_offset(lv, v2, 8, "D_C_Ui.v2");
    check_field_offset(lv, v3, 9, "D_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_Ui, D_C_Ui)
//============================================================================



static void Test_D_C_Ul()
{
  {
    init_simple_test("D_C_Ul");
    STRUCT_IF_C D_C_Ul lv;
    check2(sizeof(lv), 17, "sizeof(D_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_Ul)");
    check_field_offset(lv, v1, 0, "D_C_Ul.v1");
    check_field_offset(lv, v2, 8, "D_C_Ul.v2");
    check_field_offset(lv, v3, 9, "D_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_Ul, D_C_Ul)
//============================================================================



static void Test_D_C_Us()
{
  {
    init_simple_test("D_C_Us");
    STRUCT_IF_C D_C_Us lv;
    check2(sizeof(lv), 11, "sizeof(D_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_Us)");
    check_field_offset(lv, v1, 0, "D_C_Us.v1");
    check_field_offset(lv, v2, 8, "D_C_Us.v2");
    check_field_offset(lv, v3, 9, "D_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_Us, D_C_Us)
//============================================================================



static void Test_D_C_Vp()
{
  {
    init_simple_test("D_C_Vp");
    STRUCT_IF_C D_C_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_C_Vp)");
    check_field_offset(lv, v1, 0, "D_C_Vp.v1");
    check_field_offset(lv, v2, 8, "D_C_Vp.v2");
    check_field_offset(lv, v3, 9, "D_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_C_Vp, D_C_Vp)
//============================================================================



static void Test_D_D()
{
  {
    init_simple_test("D_D");
    STRUCT_IF_C D_D lv;
    check2(sizeof(lv), 16, "sizeof(D_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_D)");
    check_field_offset(lv, v1, 0, "D_D.v1");
    check_field_offset(lv, v2, 8, "D_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D, D_D)
//============================================================================



static void Test_D_D_BFu15i()
{
  {
    init_simple_test("D_D_BFu15i");
    static STRUCT_IF_C D_D_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu15i)");
    check_field_offset(lv, v1, 0, "D_D_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_D_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu15i, D_D_BFu15i)
//============================================================================



static void Test_D_D_BFu15ll()
{
  {
    init_simple_test("D_D_BFu15ll");
    static STRUCT_IF_C D_D_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_D_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu15ll, D_D_BFu15ll)
//============================================================================



static void Test_D_D_BFu15s()
{
  {
    init_simple_test("D_D_BFu15s");
    static STRUCT_IF_C D_D_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu15s)");
    check_field_offset(lv, v1, 0, "D_D_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_D_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu15s, D_D_BFu15s)
//============================================================================



static void Test_D_D_BFu16i()
{
  {
    init_simple_test("D_D_BFu16i");
    static STRUCT_IF_C D_D_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu16i)");
    check_field_offset(lv, v1, 0, "D_D_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_D_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu16i, D_D_BFu16i)
//============================================================================



static void Test_D_D_BFu16ll()
{
  {
    init_simple_test("D_D_BFu16ll");
    static STRUCT_IF_C D_D_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_D_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu16ll, D_D_BFu16ll)
//============================================================================



static void Test_D_D_BFu16s()
{
  {
    init_simple_test("D_D_BFu16s");
    static STRUCT_IF_C D_D_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu16s)");
    check_field_offset(lv, v1, 0, "D_D_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_D_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu16s, D_D_BFu16s)
//============================================================================



static void Test_D_D_BFu17i()
{
  {
    init_simple_test("D_D_BFu17i");
    static STRUCT_IF_C D_D_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(D_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu17i)");
    check_field_offset(lv, v1, 0, "D_D_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "D_D_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "D_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu17i, D_D_BFu17i)
//============================================================================



static void Test_D_D_BFu17ll()
{
  {
    init_simple_test("D_D_BFu17ll");
    static STRUCT_IF_C D_D_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(D_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "D_D_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "D_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu17ll, D_D_BFu17ll)
//============================================================================



static void Test_D_D_BFu1c()
{
  {
    init_simple_test("D_D_BFu1c");
    static STRUCT_IF_C D_D_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu1c)");
    check_field_offset(lv, v1, 0, "D_D_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu1c, D_D_BFu1c)
//============================================================================



static void Test_D_D_BFu1i()
{
  {
    init_simple_test("D_D_BFu1i");
    static STRUCT_IF_C D_D_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu1i)");
    check_field_offset(lv, v1, 0, "D_D_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu1i, D_D_BFu1i)
//============================================================================



static void Test_D_D_BFu1ll()
{
  {
    init_simple_test("D_D_BFu1ll");
    static STRUCT_IF_C D_D_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu1ll, D_D_BFu1ll)
//============================================================================



static void Test_D_D_BFu1s()
{
  {
    init_simple_test("D_D_BFu1s");
    static STRUCT_IF_C D_D_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu1s)");
    check_field_offset(lv, v1, 0, "D_D_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu1s, D_D_BFu1s)
//============================================================================



static void Test_D_D_BFu31i()
{
  {
    init_simple_test("D_D_BFu31i");
    static STRUCT_IF_C D_D_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(D_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu31i)");
    check_field_offset(lv, v1, 0, "D_D_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "D_D_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "D_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu31i, D_D_BFu31i)
//============================================================================



static void Test_D_D_BFu31ll()
{
  {
    init_simple_test("D_D_BFu31ll");
    static STRUCT_IF_C D_D_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(D_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "D_D_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "D_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu31ll, D_D_BFu31ll)
//============================================================================



static void Test_D_D_BFu32i()
{
  {
    init_simple_test("D_D_BFu32i");
    static STRUCT_IF_C D_D_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(D_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu32i)");
    check_field_offset(lv, v1, 0, "D_D_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "D_D_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "D_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu32i, D_D_BFu32i)
//============================================================================



static void Test_D_D_BFu32ll()
{
  {
    init_simple_test("D_D_BFu32ll");
    static STRUCT_IF_C D_D_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(D_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "D_D_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "D_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu32ll, D_D_BFu32ll)
//============================================================================



static void Test_D_D_BFu33()
{
  {
    init_simple_test("D_D_BFu33");
    static STRUCT_IF_C D_D_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(D_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu33)");
    check_field_offset(lv, v1, 0, "D_D_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "D_D_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "D_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu33, D_D_BFu33)
//============================================================================



static void Test_D_D_BFu7c()
{
  {
    init_simple_test("D_D_BFu7c");
    static STRUCT_IF_C D_D_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu7c)");
    check_field_offset(lv, v1, 0, "D_D_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_D_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu7c, D_D_BFu7c)
//============================================================================



static void Test_D_D_BFu7i()
{
  {
    init_simple_test("D_D_BFu7i");
    static STRUCT_IF_C D_D_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu7i)");
    check_field_offset(lv, v1, 0, "D_D_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_D_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu7i, D_D_BFu7i)
//============================================================================



static void Test_D_D_BFu7ll()
{
  {
    init_simple_test("D_D_BFu7ll");
    static STRUCT_IF_C D_D_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_D_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu7ll, D_D_BFu7ll)
//============================================================================



static void Test_D_D_BFu7s()
{
  {
    init_simple_test("D_D_BFu7s");
    static STRUCT_IF_C D_D_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu7s)");
    check_field_offset(lv, v1, 0, "D_D_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_D_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu7s, D_D_BFu7s)
//============================================================================



static void Test_D_D_BFu8c()
{
  {
    init_simple_test("D_D_BFu8c");
    static STRUCT_IF_C D_D_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu8c)");
    check_field_offset(lv, v1, 0, "D_D_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_D_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu8c, D_D_BFu8c)
//============================================================================



static void Test_D_D_BFu8i()
{
  {
    init_simple_test("D_D_BFu8i");
    static STRUCT_IF_C D_D_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu8i)");
    check_field_offset(lv, v1, 0, "D_D_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_D_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu8i, D_D_BFu8i)
//============================================================================



static void Test_D_D_BFu8ll()
{
  {
    init_simple_test("D_D_BFu8ll");
    static STRUCT_IF_C D_D_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_D_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu8ll, D_D_BFu8ll)
//============================================================================



static void Test_D_D_BFu8s()
{
  {
    init_simple_test("D_D_BFu8s");
    static STRUCT_IF_C D_D_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(D_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu8s)");
    check_field_offset(lv, v1, 0, "D_D_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_D_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu8s, D_D_BFu8s)
//============================================================================



static void Test_D_D_BFu9i()
{
  {
    init_simple_test("D_D_BFu9i");
    static STRUCT_IF_C D_D_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu9i)");
    check_field_offset(lv, v1, 0, "D_D_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_D_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu9i, D_D_BFu9i)
//============================================================================



static void Test_D_D_BFu9ll()
{
  {
    init_simple_test("D_D_BFu9ll");
    static STRUCT_IF_C D_D_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_D_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_D_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu9ll, D_D_BFu9ll)
//============================================================================



static void Test_D_D_BFu9s()
{
  {
    init_simple_test("D_D_BFu9s");
    static STRUCT_IF_C D_D_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(D_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_BFu9s)");
    check_field_offset(lv, v1, 0, "D_D_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_D_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_BFu9s, D_D_BFu9s)
//============================================================================



static void Test_D_D_C()
{
  {
    init_simple_test("D_D_C");
    STRUCT_IF_C D_D_C lv;
    check2(sizeof(lv), 17, "sizeof(D_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_C)");
    check_field_offset(lv, v1, 0, "D_D_C.v1");
    check_field_offset(lv, v2, 8, "D_D_C.v2");
    check_field_offset(lv, v3, 16, "D_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_C, D_D_C)
//============================================================================



static void Test_D_D_D()
{
  {
    init_simple_test("D_D_D");
    STRUCT_IF_C D_D_D lv;
    check2(sizeof(lv), 24, "sizeof(D_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_D)");
    check_field_offset(lv, v1, 0, "D_D_D.v1");
    check_field_offset(lv, v2, 8, "D_D_D.v2");
    check_field_offset(lv, v3, 16, "D_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_D, D_D_D)
//============================================================================



static void Test_D_D_F()
{
  {
    init_simple_test("D_D_F");
    STRUCT_IF_C D_D_F lv;
    check2(sizeof(lv), 20, "sizeof(D_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_F)");
    check_field_offset(lv, v1, 0, "D_D_F.v1");
    check_field_offset(lv, v2, 8, "D_D_F.v2");
    check_field_offset(lv, v3, 16, "D_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_F, D_D_F)
//============================================================================



static void Test_D_D_I()
{
  {
    init_simple_test("D_D_I");
    STRUCT_IF_C D_D_I lv;
    check2(sizeof(lv), 20, "sizeof(D_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_I)");
    check_field_offset(lv, v1, 0, "D_D_I.v1");
    check_field_offset(lv, v2, 8, "D_D_I.v2");
    check_field_offset(lv, v3, 16, "D_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_I, D_D_I)
//============================================================================



static void Test_D_D_Ip()
{
  {
    init_simple_test("D_D_Ip");
    STRUCT_IF_C D_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_Ip)");
    check_field_offset(lv, v1, 0, "D_D_Ip.v1");
    check_field_offset(lv, v2, 8, "D_D_Ip.v2");
    check_field_offset(lv, v3, 16, "D_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_Ip, D_D_Ip)
//============================================================================



static void Test_D_D_L()
{
  {
    init_simple_test("D_D_L");
    STRUCT_IF_C D_D_L lv;
    check2(sizeof(lv), 24, "sizeof(D_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_L)");
    check_field_offset(lv, v1, 0, "D_D_L.v1");
    check_field_offset(lv, v2, 8, "D_D_L.v2");
    check_field_offset(lv, v3, 16, "D_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_L, D_D_L)
//============================================================================



static void Test_D_D_S()
{
  {
    init_simple_test("D_D_S");
    STRUCT_IF_C D_D_S lv;
    check2(sizeof(lv), 18, "sizeof(D_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_S)");
    check_field_offset(lv, v1, 0, "D_D_S.v1");
    check_field_offset(lv, v2, 8, "D_D_S.v2");
    check_field_offset(lv, v3, 16, "D_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_S, D_D_S)
//============================================================================



static void Test_D_D_Uc()
{
  {
    init_simple_test("D_D_Uc");
    STRUCT_IF_C D_D_Uc lv;
    check2(sizeof(lv), 17, "sizeof(D_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_Uc)");
    check_field_offset(lv, v1, 0, "D_D_Uc.v1");
    check_field_offset(lv, v2, 8, "D_D_Uc.v2");
    check_field_offset(lv, v3, 16, "D_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_Uc, D_D_Uc)
//============================================================================



static void Test_D_D_Ui()
{
  {
    init_simple_test("D_D_Ui");
    STRUCT_IF_C D_D_Ui lv;
    check2(sizeof(lv), 20, "sizeof(D_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_Ui)");
    check_field_offset(lv, v1, 0, "D_D_Ui.v1");
    check_field_offset(lv, v2, 8, "D_D_Ui.v2");
    check_field_offset(lv, v3, 16, "D_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_Ui, D_D_Ui)
//============================================================================



static void Test_D_D_Ul()
{
  {
    init_simple_test("D_D_Ul");
    STRUCT_IF_C D_D_Ul lv;
    check2(sizeof(lv), 24, "sizeof(D_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_Ul)");
    check_field_offset(lv, v1, 0, "D_D_Ul.v1");
    check_field_offset(lv, v2, 8, "D_D_Ul.v2");
    check_field_offset(lv, v3, 16, "D_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_Ul, D_D_Ul)
//============================================================================



static void Test_D_D_Us()
{
  {
    init_simple_test("D_D_Us");
    STRUCT_IF_C D_D_Us lv;
    check2(sizeof(lv), 18, "sizeof(D_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_Us)");
    check_field_offset(lv, v1, 0, "D_D_Us.v1");
    check_field_offset(lv, v2, 8, "D_D_Us.v2");
    check_field_offset(lv, v3, 16, "D_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_Us, D_D_Us)
//============================================================================



static void Test_D_D_Vp()
{
  {
    init_simple_test("D_D_Vp");
    STRUCT_IF_C D_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_D_Vp)");
    check_field_offset(lv, v1, 0, "D_D_Vp.v1");
    check_field_offset(lv, v2, 8, "D_D_Vp.v2");
    check_field_offset(lv, v3, 16, "D_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_D_Vp, D_D_Vp)
//============================================================================



static void Test_D_F()
{
  {
    init_simple_test("D_F");
    STRUCT_IF_C D_F lv;
    check2(sizeof(lv), 12, "sizeof(D_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_F)");
    check_field_offset(lv, v1, 0, "D_F.v1");
    check_field_offset(lv, v2, 8, "D_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F, D_F)
//============================================================================



static void Test_D_F_BFu15i()
{
  {
    init_simple_test("D_F_BFu15i");
    static STRUCT_IF_C D_F_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu15i)");
    check_field_offset(lv, v1, 0, "D_F_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_F_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu15i, D_F_BFu15i)
//============================================================================



static void Test_D_F_BFu15ll()
{
  {
    init_simple_test("D_F_BFu15ll");
    static STRUCT_IF_C D_F_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_F_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu15ll, D_F_BFu15ll)
//============================================================================



static void Test_D_F_BFu15s()
{
  {
    init_simple_test("D_F_BFu15s");
    static STRUCT_IF_C D_F_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu15s)");
    check_field_offset(lv, v1, 0, "D_F_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_F_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu15s, D_F_BFu15s)
//============================================================================



static void Test_D_F_BFu16i()
{
  {
    init_simple_test("D_F_BFu16i");
    static STRUCT_IF_C D_F_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu16i)");
    check_field_offset(lv, v1, 0, "D_F_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_F_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu16i, D_F_BFu16i)
//============================================================================



static void Test_D_F_BFu16ll()
{
  {
    init_simple_test("D_F_BFu16ll");
    static STRUCT_IF_C D_F_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_F_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu16ll, D_F_BFu16ll)
//============================================================================



static void Test_D_F_BFu16s()
{
  {
    init_simple_test("D_F_BFu16s");
    static STRUCT_IF_C D_F_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu16s)");
    check_field_offset(lv, v1, 0, "D_F_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_F_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu16s, D_F_BFu16s)
//============================================================================



static void Test_D_F_BFu17i()
{
  {
    init_simple_test("D_F_BFu17i");
    static STRUCT_IF_C D_F_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(D_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu17i)");
    check_field_offset(lv, v1, 0, "D_F_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_F_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu17i, D_F_BFu17i)
//============================================================================



static void Test_D_F_BFu17ll()
{
  {
    init_simple_test("D_F_BFu17ll");
    static STRUCT_IF_C D_F_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(D_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_F_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu17ll, D_F_BFu17ll)
//============================================================================



static void Test_D_F_BFu1c()
{
  {
    init_simple_test("D_F_BFu1c");
    static STRUCT_IF_C D_F_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu1c)");
    check_field_offset(lv, v1, 0, "D_F_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu1c, D_F_BFu1c)
//============================================================================



static void Test_D_F_BFu1i()
{
  {
    init_simple_test("D_F_BFu1i");
    static STRUCT_IF_C D_F_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu1i)");
    check_field_offset(lv, v1, 0, "D_F_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu1i, D_F_BFu1i)
//============================================================================



static void Test_D_F_BFu1ll()
{
  {
    init_simple_test("D_F_BFu1ll");
    static STRUCT_IF_C D_F_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu1ll, D_F_BFu1ll)
//============================================================================



static void Test_D_F_BFu1s()
{
  {
    init_simple_test("D_F_BFu1s");
    static STRUCT_IF_C D_F_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu1s)");
    check_field_offset(lv, v1, 0, "D_F_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu1s, D_F_BFu1s)
//============================================================================



static void Test_D_F_BFu31i()
{
  {
    init_simple_test("D_F_BFu31i");
    static STRUCT_IF_C D_F_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu31i)");
    check_field_offset(lv, v1, 0, "D_F_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_F_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu31i, D_F_BFu31i)
//============================================================================



static void Test_D_F_BFu31ll()
{
  {
    init_simple_test("D_F_BFu31ll");
    static STRUCT_IF_C D_F_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_F_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu31ll, D_F_BFu31ll)
//============================================================================



static void Test_D_F_BFu32i()
{
  {
    init_simple_test("D_F_BFu32i");
    static STRUCT_IF_C D_F_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu32i)");
    check_field_offset(lv, v1, 0, "D_F_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_F_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu32i, D_F_BFu32i)
//============================================================================



static void Test_D_F_BFu32ll()
{
  {
    init_simple_test("D_F_BFu32ll");
    static STRUCT_IF_C D_F_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_F_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu32ll, D_F_BFu32ll)
//============================================================================



static void Test_D_F_BFu33()
{
  {
    init_simple_test("D_F_BFu33");
    static STRUCT_IF_C D_F_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(D_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu33)");
    check_field_offset(lv, v1, 0, "D_F_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "D_F_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "D_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu33, D_F_BFu33)
//============================================================================



static void Test_D_F_BFu7c()
{
  {
    init_simple_test("D_F_BFu7c");
    static STRUCT_IF_C D_F_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu7c)");
    check_field_offset(lv, v1, 0, "D_F_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_F_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu7c, D_F_BFu7c)
//============================================================================



static void Test_D_F_BFu7i()
{
  {
    init_simple_test("D_F_BFu7i");
    static STRUCT_IF_C D_F_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu7i)");
    check_field_offset(lv, v1, 0, "D_F_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_F_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu7i, D_F_BFu7i)
//============================================================================



static void Test_D_F_BFu7ll()
{
  {
    init_simple_test("D_F_BFu7ll");
    static STRUCT_IF_C D_F_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_F_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu7ll, D_F_BFu7ll)
//============================================================================



static void Test_D_F_BFu7s()
{
  {
    init_simple_test("D_F_BFu7s");
    static STRUCT_IF_C D_F_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu7s)");
    check_field_offset(lv, v1, 0, "D_F_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_F_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu7s, D_F_BFu7s)
//============================================================================



static void Test_D_F_BFu8c()
{
  {
    init_simple_test("D_F_BFu8c");
    static STRUCT_IF_C D_F_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu8c)");
    check_field_offset(lv, v1, 0, "D_F_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_F_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu8c, D_F_BFu8c)
//============================================================================



static void Test_D_F_BFu8i()
{
  {
    init_simple_test("D_F_BFu8i");
    static STRUCT_IF_C D_F_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu8i)");
    check_field_offset(lv, v1, 0, "D_F_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_F_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu8i, D_F_BFu8i)
//============================================================================



static void Test_D_F_BFu8ll()
{
  {
    init_simple_test("D_F_BFu8ll");
    static STRUCT_IF_C D_F_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_F_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu8ll, D_F_BFu8ll)
//============================================================================



static void Test_D_F_BFu8s()
{
  {
    init_simple_test("D_F_BFu8s");
    static STRUCT_IF_C D_F_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(D_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu8s)");
    check_field_offset(lv, v1, 0, "D_F_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_F_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu8s, D_F_BFu8s)
//============================================================================



static void Test_D_F_BFu9i()
{
  {
    init_simple_test("D_F_BFu9i");
    static STRUCT_IF_C D_F_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu9i)");
    check_field_offset(lv, v1, 0, "D_F_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_F_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu9i, D_F_BFu9i)
//============================================================================



static void Test_D_F_BFu9ll()
{
  {
    init_simple_test("D_F_BFu9ll");
    static STRUCT_IF_C D_F_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_F_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_F_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu9ll, D_F_BFu9ll)
//============================================================================



static void Test_D_F_BFu9s()
{
  {
    init_simple_test("D_F_BFu9s");
    static STRUCT_IF_C D_F_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(D_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_BFu9s)");
    check_field_offset(lv, v1, 0, "D_F_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_F_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_BFu9s, D_F_BFu9s)
//============================================================================



static void Test_D_F_C()
{
  {
    init_simple_test("D_F_C");
    STRUCT_IF_C D_F_C lv;
    check2(sizeof(lv), 13, "sizeof(D_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_C)");
    check_field_offset(lv, v1, 0, "D_F_C.v1");
    check_field_offset(lv, v2, 8, "D_F_C.v2");
    check_field_offset(lv, v3, 12, "D_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_C, D_F_C)
//============================================================================



static void Test_D_F_D()
{
  {
    init_simple_test("D_F_D");
    STRUCT_IF_C D_F_D lv;
    check2(sizeof(lv), 20, "sizeof(D_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_D)");
    check_field_offset(lv, v1, 0, "D_F_D.v1");
    check_field_offset(lv, v2, 8, "D_F_D.v2");
    check_field_offset(lv, v3, 12, "D_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_D, D_F_D)
//============================================================================



static void Test_D_F_F()
{
  {
    init_simple_test("D_F_F");
    STRUCT_IF_C D_F_F lv;
    check2(sizeof(lv), 16, "sizeof(D_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_F)");
    check_field_offset(lv, v1, 0, "D_F_F.v1");
    check_field_offset(lv, v2, 8, "D_F_F.v2");
    check_field_offset(lv, v3, 12, "D_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_F, D_F_F)
//============================================================================



static void Test_D_F_I()
{
  {
    init_simple_test("D_F_I");
    STRUCT_IF_C D_F_I lv;
    check2(sizeof(lv), 16, "sizeof(D_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_I)");
    check_field_offset(lv, v1, 0, "D_F_I.v1");
    check_field_offset(lv, v2, 8, "D_F_I.v2");
    check_field_offset(lv, v3, 12, "D_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_I, D_F_I)
//============================================================================



static void Test_D_F_Ip()
{
  {
    init_simple_test("D_F_Ip");
    STRUCT_IF_C D_F_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_Ip)");
    check_field_offset(lv, v1, 0, "D_F_Ip.v1");
    check_field_offset(lv, v2, 8, "D_F_Ip.v2");
    check_field_offset(lv, v3, 12, "D_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_Ip, D_F_Ip)
//============================================================================



static void Test_D_F_L()
{
  {
    init_simple_test("D_F_L");
    STRUCT_IF_C D_F_L lv;
    check2(sizeof(lv), 20, "sizeof(D_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_L)");
    check_field_offset(lv, v1, 0, "D_F_L.v1");
    check_field_offset(lv, v2, 8, "D_F_L.v2");
    check_field_offset(lv, v3, 12, "D_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_L, D_F_L)
//============================================================================



static void Test_D_F_S()
{
  {
    init_simple_test("D_F_S");
    STRUCT_IF_C D_F_S lv;
    check2(sizeof(lv), 14, "sizeof(D_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_S)");
    check_field_offset(lv, v1, 0, "D_F_S.v1");
    check_field_offset(lv, v2, 8, "D_F_S.v2");
    check_field_offset(lv, v3, 12, "D_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_S, D_F_S)
//============================================================================



static void Test_D_F_Uc()
{
  {
    init_simple_test("D_F_Uc");
    STRUCT_IF_C D_F_Uc lv;
    check2(sizeof(lv), 13, "sizeof(D_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_Uc)");
    check_field_offset(lv, v1, 0, "D_F_Uc.v1");
    check_field_offset(lv, v2, 8, "D_F_Uc.v2");
    check_field_offset(lv, v3, 12, "D_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_Uc, D_F_Uc)
//============================================================================



static void Test_D_F_Ui()
{
  {
    init_simple_test("D_F_Ui");
    STRUCT_IF_C D_F_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_Ui)");
    check_field_offset(lv, v1, 0, "D_F_Ui.v1");
    check_field_offset(lv, v2, 8, "D_F_Ui.v2");
    check_field_offset(lv, v3, 12, "D_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_Ui, D_F_Ui)
//============================================================================



static void Test_D_F_Ul()
{
  {
    init_simple_test("D_F_Ul");
    STRUCT_IF_C D_F_Ul lv;
    check2(sizeof(lv), 20, "sizeof(D_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_Ul)");
    check_field_offset(lv, v1, 0, "D_F_Ul.v1");
    check_field_offset(lv, v2, 8, "D_F_Ul.v2");
    check_field_offset(lv, v3, 12, "D_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_Ul, D_F_Ul)
//============================================================================



static void Test_D_F_Us()
{
  {
    init_simple_test("D_F_Us");
    STRUCT_IF_C D_F_Us lv;
    check2(sizeof(lv), 14, "sizeof(D_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_Us)");
    check_field_offset(lv, v1, 0, "D_F_Us.v1");
    check_field_offset(lv, v2, 8, "D_F_Us.v2");
    check_field_offset(lv, v3, 12, "D_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_Us, D_F_Us)
//============================================================================



static void Test_D_F_Vp()
{
  {
    init_simple_test("D_F_Vp");
    STRUCT_IF_C D_F_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_F_Vp)");
    check_field_offset(lv, v1, 0, "D_F_Vp.v1");
    check_field_offset(lv, v2, 8, "D_F_Vp.v2");
    check_field_offset(lv, v3, 12, "D_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_F_Vp, D_F_Vp)
//============================================================================



static void Test_D_I()
{
  {
    init_simple_test("D_I");
    STRUCT_IF_C D_I lv;
    check2(sizeof(lv), 12, "sizeof(D_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_I)");
    check_field_offset(lv, v1, 0, "D_I.v1");
    check_field_offset(lv, v2, 8, "D_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I, D_I)
//============================================================================



static void Test_D_I_BFu15i()
{
  {
    init_simple_test("D_I_BFu15i");
    static STRUCT_IF_C D_I_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu15i)");
    check_field_offset(lv, v1, 0, "D_I_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_I_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu15i, D_I_BFu15i)
//============================================================================



static void Test_D_I_BFu15ll()
{
  {
    init_simple_test("D_I_BFu15ll");
    static STRUCT_IF_C D_I_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_I_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu15ll, D_I_BFu15ll)
//============================================================================



static void Test_D_I_BFu15s()
{
  {
    init_simple_test("D_I_BFu15s");
    static STRUCT_IF_C D_I_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu15s)");
    check_field_offset(lv, v1, 0, "D_I_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_I_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu15s, D_I_BFu15s)
//============================================================================



static void Test_D_I_BFu16i()
{
  {
    init_simple_test("D_I_BFu16i");
    static STRUCT_IF_C D_I_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu16i)");
    check_field_offset(lv, v1, 0, "D_I_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_I_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu16i, D_I_BFu16i)
//============================================================================



static void Test_D_I_BFu16ll()
{
  {
    init_simple_test("D_I_BFu16ll");
    static STRUCT_IF_C D_I_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_I_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu16ll, D_I_BFu16ll)
//============================================================================



static void Test_D_I_BFu16s()
{
  {
    init_simple_test("D_I_BFu16s");
    static STRUCT_IF_C D_I_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu16s)");
    check_field_offset(lv, v1, 0, "D_I_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_I_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu16s, D_I_BFu16s)
//============================================================================



static void Test_D_I_BFu17i()
{
  {
    init_simple_test("D_I_BFu17i");
    static STRUCT_IF_C D_I_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(D_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu17i)");
    check_field_offset(lv, v1, 0, "D_I_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_I_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu17i, D_I_BFu17i)
//============================================================================



static void Test_D_I_BFu17ll()
{
  {
    init_simple_test("D_I_BFu17ll");
    static STRUCT_IF_C D_I_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(D_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_I_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu17ll, D_I_BFu17ll)
//============================================================================



static void Test_D_I_BFu1c()
{
  {
    init_simple_test("D_I_BFu1c");
    static STRUCT_IF_C D_I_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu1c)");
    check_field_offset(lv, v1, 0, "D_I_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu1c, D_I_BFu1c)
//============================================================================



static void Test_D_I_BFu1i()
{
  {
    init_simple_test("D_I_BFu1i");
    static STRUCT_IF_C D_I_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu1i)");
    check_field_offset(lv, v1, 0, "D_I_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu1i, D_I_BFu1i)
//============================================================================



static void Test_D_I_BFu1ll()
{
  {
    init_simple_test("D_I_BFu1ll");
    static STRUCT_IF_C D_I_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu1ll, D_I_BFu1ll)
//============================================================================



static void Test_D_I_BFu1s()
{
  {
    init_simple_test("D_I_BFu1s");
    static STRUCT_IF_C D_I_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu1s)");
    check_field_offset(lv, v1, 0, "D_I_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu1s, D_I_BFu1s)
//============================================================================



static void Test_D_I_BFu31i()
{
  {
    init_simple_test("D_I_BFu31i");
    static STRUCT_IF_C D_I_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu31i)");
    check_field_offset(lv, v1, 0, "D_I_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_I_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu31i, D_I_BFu31i)
//============================================================================



static void Test_D_I_BFu31ll()
{
  {
    init_simple_test("D_I_BFu31ll");
    static STRUCT_IF_C D_I_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_I_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu31ll, D_I_BFu31ll)
//============================================================================



static void Test_D_I_BFu32i()
{
  {
    init_simple_test("D_I_BFu32i");
    static STRUCT_IF_C D_I_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu32i)");
    check_field_offset(lv, v1, 0, "D_I_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_I_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu32i, D_I_BFu32i)
//============================================================================



static void Test_D_I_BFu32ll()
{
  {
    init_simple_test("D_I_BFu32ll");
    static STRUCT_IF_C D_I_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_I_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu32ll, D_I_BFu32ll)
//============================================================================



static void Test_D_I_BFu33()
{
  {
    init_simple_test("D_I_BFu33");
    static STRUCT_IF_C D_I_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(D_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu33)");
    check_field_offset(lv, v1, 0, "D_I_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "D_I_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "D_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu33, D_I_BFu33)
//============================================================================



static void Test_D_I_BFu7c()
{
  {
    init_simple_test("D_I_BFu7c");
    static STRUCT_IF_C D_I_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu7c)");
    check_field_offset(lv, v1, 0, "D_I_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_I_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu7c, D_I_BFu7c)
//============================================================================



static void Test_D_I_BFu7i()
{
  {
    init_simple_test("D_I_BFu7i");
    static STRUCT_IF_C D_I_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu7i)");
    check_field_offset(lv, v1, 0, "D_I_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_I_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu7i, D_I_BFu7i)
//============================================================================



static void Test_D_I_BFu7ll()
{
  {
    init_simple_test("D_I_BFu7ll");
    static STRUCT_IF_C D_I_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_I_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu7ll, D_I_BFu7ll)
//============================================================================



static void Test_D_I_BFu7s()
{
  {
    init_simple_test("D_I_BFu7s");
    static STRUCT_IF_C D_I_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu7s)");
    check_field_offset(lv, v1, 0, "D_I_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_I_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu7s, D_I_BFu7s)
//============================================================================



static void Test_D_I_BFu8c()
{
  {
    init_simple_test("D_I_BFu8c");
    static STRUCT_IF_C D_I_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu8c)");
    check_field_offset(lv, v1, 0, "D_I_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_I_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu8c, D_I_BFu8c)
//============================================================================



static void Test_D_I_BFu8i()
{
  {
    init_simple_test("D_I_BFu8i");
    static STRUCT_IF_C D_I_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu8i)");
    check_field_offset(lv, v1, 0, "D_I_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_I_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu8i, D_I_BFu8i)
//============================================================================



static void Test_D_I_BFu8ll()
{
  {
    init_simple_test("D_I_BFu8ll");
    static STRUCT_IF_C D_I_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_I_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu8ll, D_I_BFu8ll)
//============================================================================



static void Test_D_I_BFu8s()
{
  {
    init_simple_test("D_I_BFu8s");
    static STRUCT_IF_C D_I_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(D_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu8s)");
    check_field_offset(lv, v1, 0, "D_I_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_I_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu8s, D_I_BFu8s)
//============================================================================



static void Test_D_I_BFu9i()
{
  {
    init_simple_test("D_I_BFu9i");
    static STRUCT_IF_C D_I_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu9i)");
    check_field_offset(lv, v1, 0, "D_I_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_I_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu9i, D_I_BFu9i)
//============================================================================



static void Test_D_I_BFu9ll()
{
  {
    init_simple_test("D_I_BFu9ll");
    static STRUCT_IF_C D_I_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_I_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_I_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu9ll, D_I_BFu9ll)
//============================================================================



static void Test_D_I_BFu9s()
{
  {
    init_simple_test("D_I_BFu9s");
    static STRUCT_IF_C D_I_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(D_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_BFu9s)");
    check_field_offset(lv, v1, 0, "D_I_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_I_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_BFu9s, D_I_BFu9s)
//============================================================================



static void Test_D_I_C()
{
  {
    init_simple_test("D_I_C");
    STRUCT_IF_C D_I_C lv;
    check2(sizeof(lv), 13, "sizeof(D_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_C)");
    check_field_offset(lv, v1, 0, "D_I_C.v1");
    check_field_offset(lv, v2, 8, "D_I_C.v2");
    check_field_offset(lv, v3, 12, "D_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_C, D_I_C)
//============================================================================



static void Test_D_I_D()
{
  {
    init_simple_test("D_I_D");
    STRUCT_IF_C D_I_D lv;
    check2(sizeof(lv), 20, "sizeof(D_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_D)");
    check_field_offset(lv, v1, 0, "D_I_D.v1");
    check_field_offset(lv, v2, 8, "D_I_D.v2");
    check_field_offset(lv, v3, 12, "D_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_D, D_I_D)
//============================================================================



static void Test_D_I_F()
{
  {
    init_simple_test("D_I_F");
    STRUCT_IF_C D_I_F lv;
    check2(sizeof(lv), 16, "sizeof(D_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_F)");
    check_field_offset(lv, v1, 0, "D_I_F.v1");
    check_field_offset(lv, v2, 8, "D_I_F.v2");
    check_field_offset(lv, v3, 12, "D_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_F, D_I_F)
//============================================================================



static void Test_D_I_I()
{
  {
    init_simple_test("D_I_I");
    STRUCT_IF_C D_I_I lv;
    check2(sizeof(lv), 16, "sizeof(D_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_I)");
    check_field_offset(lv, v1, 0, "D_I_I.v1");
    check_field_offset(lv, v2, 8, "D_I_I.v2");
    check_field_offset(lv, v3, 12, "D_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_I, D_I_I)
//============================================================================



static void Test_D_I_Ip()
{
  {
    init_simple_test("D_I_Ip");
    STRUCT_IF_C D_I_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_Ip)");
    check_field_offset(lv, v1, 0, "D_I_Ip.v1");
    check_field_offset(lv, v2, 8, "D_I_Ip.v2");
    check_field_offset(lv, v3, 12, "D_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_Ip, D_I_Ip)
//============================================================================



static void Test_D_I_L()
{
  {
    init_simple_test("D_I_L");
    STRUCT_IF_C D_I_L lv;
    check2(sizeof(lv), 20, "sizeof(D_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_L)");
    check_field_offset(lv, v1, 0, "D_I_L.v1");
    check_field_offset(lv, v2, 8, "D_I_L.v2");
    check_field_offset(lv, v3, 12, "D_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_L, D_I_L)
//============================================================================



static void Test_D_I_S()
{
  {
    init_simple_test("D_I_S");
    STRUCT_IF_C D_I_S lv;
    check2(sizeof(lv), 14, "sizeof(D_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_S)");
    check_field_offset(lv, v1, 0, "D_I_S.v1");
    check_field_offset(lv, v2, 8, "D_I_S.v2");
    check_field_offset(lv, v3, 12, "D_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_S, D_I_S)
//============================================================================



static void Test_D_I_Uc()
{
  {
    init_simple_test("D_I_Uc");
    STRUCT_IF_C D_I_Uc lv;
    check2(sizeof(lv), 13, "sizeof(D_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_Uc)");
    check_field_offset(lv, v1, 0, "D_I_Uc.v1");
    check_field_offset(lv, v2, 8, "D_I_Uc.v2");
    check_field_offset(lv, v3, 12, "D_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_Uc, D_I_Uc)
//============================================================================



static void Test_D_I_Ui()
{
  {
    init_simple_test("D_I_Ui");
    STRUCT_IF_C D_I_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_Ui)");
    check_field_offset(lv, v1, 0, "D_I_Ui.v1");
    check_field_offset(lv, v2, 8, "D_I_Ui.v2");
    check_field_offset(lv, v3, 12, "D_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_Ui, D_I_Ui)
//============================================================================



static void Test_D_I_Ul()
{
  {
    init_simple_test("D_I_Ul");
    STRUCT_IF_C D_I_Ul lv;
    check2(sizeof(lv), 20, "sizeof(D_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_Ul)");
    check_field_offset(lv, v1, 0, "D_I_Ul.v1");
    check_field_offset(lv, v2, 8, "D_I_Ul.v2");
    check_field_offset(lv, v3, 12, "D_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_Ul, D_I_Ul)
//============================================================================



static void Test_D_I_Us()
{
  {
    init_simple_test("D_I_Us");
    STRUCT_IF_C D_I_Us lv;
    check2(sizeof(lv), 14, "sizeof(D_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_Us)");
    check_field_offset(lv, v1, 0, "D_I_Us.v1");
    check_field_offset(lv, v2, 8, "D_I_Us.v2");
    check_field_offset(lv, v3, 12, "D_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_Us, D_I_Us)
//============================================================================



static void Test_D_I_Vp()
{
  {
    init_simple_test("D_I_Vp");
    STRUCT_IF_C D_I_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_I_Vp)");
    check_field_offset(lv, v1, 0, "D_I_Vp.v1");
    check_field_offset(lv, v2, 8, "D_I_Vp.v2");
    check_field_offset(lv, v3, 12, "D_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_I_Vp, D_I_Vp)
//============================================================================



static void Test_D_Ip()
{
  {
    init_simple_test("D_Ip");
    STRUCT_IF_C D_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip)");
    check_field_offset(lv, v1, 0, "D_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip, D_Ip)
//============================================================================



static void Test_D_Ip_BFu15i()
{
  {
    init_simple_test("D_Ip_BFu15i");
    static STRUCT_IF_C D_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "D_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "D_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu15i, D_Ip_BFu15i)
//============================================================================



static void Test_D_Ip_BFu15ll()
{
  {
    init_simple_test("D_Ip_BFu15ll");
    static STRUCT_IF_C D_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "D_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "D_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu15ll, D_Ip_BFu15ll)
//============================================================================



static void Test_D_Ip_BFu15s()
{
  {
    init_simple_test("D_Ip_BFu15s");
    static STRUCT_IF_C D_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "D_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "D_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu15s, D_Ip_BFu15s)
//============================================================================



static void Test_D_Ip_BFu16i()
{
  {
    init_simple_test("D_Ip_BFu16i");
    static STRUCT_IF_C D_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "D_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "D_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu16i, D_Ip_BFu16i)
//============================================================================



static void Test_D_Ip_BFu16ll()
{
  {
    init_simple_test("D_Ip_BFu16ll");
    static STRUCT_IF_C D_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "D_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "D_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu16ll, D_Ip_BFu16ll)
//============================================================================



static void Test_D_Ip_BFu16s()
{
  {
    init_simple_test("D_Ip_BFu16s");
    static STRUCT_IF_C D_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "D_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "D_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu16s, D_Ip_BFu16s)
//============================================================================



static void Test_D_Ip_BFu17i()
{
  {
    init_simple_test("D_Ip_BFu17i");
    static STRUCT_IF_C D_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(D_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "D_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "D_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu17i, D_Ip_BFu17i)
//============================================================================



static void Test_D_Ip_BFu17ll()
{
  {
    init_simple_test("D_Ip_BFu17ll");
    static STRUCT_IF_C D_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(D_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "D_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "D_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu17ll, D_Ip_BFu17ll)
//============================================================================



static void Test_D_Ip_BFu1c()
{
  {
    init_simple_test("D_Ip_BFu1c");
    static STRUCT_IF_C D_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu1c, D_Ip_BFu1c)
//============================================================================



static void Test_D_Ip_BFu1i()
{
  {
    init_simple_test("D_Ip_BFu1i");
    static STRUCT_IF_C D_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu1i, D_Ip_BFu1i)
//============================================================================



static void Test_D_Ip_BFu1ll()
{
  {
    init_simple_test("D_Ip_BFu1ll");
    static STRUCT_IF_C D_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu1ll, D_Ip_BFu1ll)
//============================================================================



static void Test_D_Ip_BFu1s()
{
  {
    init_simple_test("D_Ip_BFu1s");
    static STRUCT_IF_C D_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu1s, D_Ip_BFu1s)
//============================================================================



static void Test_D_Ip_BFu31i()
{
  {
    init_simple_test("D_Ip_BFu31i");
    static STRUCT_IF_C D_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "D_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "D_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu31i, D_Ip_BFu31i)
//============================================================================



static void Test_D_Ip_BFu31ll()
{
  {
    init_simple_test("D_Ip_BFu31ll");
    static STRUCT_IF_C D_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "D_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "D_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu31ll, D_Ip_BFu31ll)
//============================================================================



static void Test_D_Ip_BFu32i()
{
  {
    init_simple_test("D_Ip_BFu32i");
    static STRUCT_IF_C D_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "D_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "D_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu32i, D_Ip_BFu32i)
//============================================================================



static void Test_D_Ip_BFu32ll()
{
  {
    init_simple_test("D_Ip_BFu32ll");
    static STRUCT_IF_C D_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "D_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "D_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu32ll, D_Ip_BFu32ll)
//============================================================================



static void Test_D_Ip_BFu33()
{
  {
    init_simple_test("D_Ip_BFu33");
    static STRUCT_IF_C D_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(D_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "D_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "D_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu33, D_Ip_BFu33)
//============================================================================



static void Test_D_Ip_BFu7c()
{
  {
    init_simple_test("D_Ip_BFu7c");
    static STRUCT_IF_C D_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu7c, D_Ip_BFu7c)
//============================================================================



static void Test_D_Ip_BFu7i()
{
  {
    init_simple_test("D_Ip_BFu7i");
    static STRUCT_IF_C D_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu7i, D_Ip_BFu7i)
//============================================================================



static void Test_D_Ip_BFu7ll()
{
  {
    init_simple_test("D_Ip_BFu7ll");
    static STRUCT_IF_C D_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu7ll, D_Ip_BFu7ll)
//============================================================================



static void Test_D_Ip_BFu7s()
{
  {
    init_simple_test("D_Ip_BFu7s");
    static STRUCT_IF_C D_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu7s, D_Ip_BFu7s)
//============================================================================



static void Test_D_Ip_BFu8c()
{
  {
    init_simple_test("D_Ip_BFu8c");
    static STRUCT_IF_C D_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu8c, D_Ip_BFu8c)
//============================================================================



static void Test_D_Ip_BFu8i()
{
  {
    init_simple_test("D_Ip_BFu8i");
    static STRUCT_IF_C D_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu8i, D_Ip_BFu8i)
//============================================================================



static void Test_D_Ip_BFu8ll()
{
  {
    init_simple_test("D_Ip_BFu8ll");
    static STRUCT_IF_C D_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu8ll, D_Ip_BFu8ll)
//============================================================================



static void Test_D_Ip_BFu8s()
{
  {
    init_simple_test("D_Ip_BFu8s");
    static STRUCT_IF_C D_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu8s, D_Ip_BFu8s)
//============================================================================



static void Test_D_Ip_BFu9i()
{
  {
    init_simple_test("D_Ip_BFu9i");
    static STRUCT_IF_C D_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "D_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "D_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu9i, D_Ip_BFu9i)
//============================================================================



static void Test_D_Ip_BFu9ll()
{
  {
    init_simple_test("D_Ip_BFu9ll");
    static STRUCT_IF_C D_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "D_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "D_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu9ll, D_Ip_BFu9ll)
//============================================================================



static void Test_D_Ip_BFu9s()
{
  {
    init_simple_test("D_Ip_BFu9s");
    static STRUCT_IF_C D_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "D_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "D_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "D_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_BFu9s, D_Ip_BFu9s)
//============================================================================



static void Test_D_Ip_C()
{
  {
    init_simple_test("D_Ip_C");
    STRUCT_IF_C D_Ip_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_C)");
    check_field_offset(lv, v1, 0, "D_Ip_C.v1");
    check_field_offset(lv, v2, 8, "D_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_C, D_Ip_C)
//============================================================================



static void Test_D_Ip_D()
{
  {
    init_simple_test("D_Ip_D");
    STRUCT_IF_C D_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_D)");
    check_field_offset(lv, v1, 0, "D_Ip_D.v1");
    check_field_offset(lv, v2, 8, "D_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_D, D_Ip_D)
//============================================================================



static void Test_D_Ip_F()
{
  {
    init_simple_test("D_Ip_F");
    STRUCT_IF_C D_Ip_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_F)");
    check_field_offset(lv, v1, 0, "D_Ip_F.v1");
    check_field_offset(lv, v2, 8, "D_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_F, D_Ip_F)
//============================================================================



static void Test_D_Ip_I()
{
  {
    init_simple_test("D_Ip_I");
    STRUCT_IF_C D_Ip_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_I)");
    check_field_offset(lv, v1, 0, "D_Ip_I.v1");
    check_field_offset(lv, v2, 8, "D_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_I, D_Ip_I)
//============================================================================



static void Test_D_Ip_Ip()
{
  {
    init_simple_test("D_Ip_Ip");
    STRUCT_IF_C D_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_Ip)");
    check_field_offset(lv, v1, 0, "D_Ip_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_Ip, D_Ip_Ip)
//============================================================================



static void Test_D_Ip_L()
{
  {
    init_simple_test("D_Ip_L");
    STRUCT_IF_C D_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_L)");
    check_field_offset(lv, v1, 0, "D_Ip_L.v1");
    check_field_offset(lv, v2, 8, "D_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_L, D_Ip_L)
//============================================================================



static void Test_D_Ip_S()
{
  {
    init_simple_test("D_Ip_S");
    STRUCT_IF_C D_Ip_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_S)");
    check_field_offset(lv, v1, 0, "D_Ip_S.v1");
    check_field_offset(lv, v2, 8, "D_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_S, D_Ip_S)
//============================================================================



static void Test_D_Ip_Uc()
{
  {
    init_simple_test("D_Ip_Uc");
    STRUCT_IF_C D_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_Uc)");
    check_field_offset(lv, v1, 0, "D_Ip_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_Uc, D_Ip_Uc)
//============================================================================



static void Test_D_Ip_Ui()
{
  {
    init_simple_test("D_Ip_Ui");
    STRUCT_IF_C D_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_Ui)");
    check_field_offset(lv, v1, 0, "D_Ip_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_Ui, D_Ip_Ui)
//============================================================================



static void Test_D_Ip_Ul()
{
  {
    init_simple_test("D_Ip_Ul");
    STRUCT_IF_C D_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_Ul)");
    check_field_offset(lv, v1, 0, "D_Ip_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_Ul, D_Ip_Ul)
//============================================================================



static void Test_D_Ip_Us()
{
  {
    init_simple_test("D_Ip_Us");
    STRUCT_IF_C D_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_Us)");
    check_field_offset(lv, v1, 0, "D_Ip_Us.v1");
    check_field_offset(lv, v2, 8, "D_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_Us, D_Ip_Us)
//============================================================================



static void Test_D_Ip_Vp()
{
  {
    init_simple_test("D_Ip_Vp");
    STRUCT_IF_C D_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ip_Vp)");
    check_field_offset(lv, v1, 0, "D_Ip_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ip_Vp, D_Ip_Vp)
//============================================================================



static void Test_D_L()
{
  {
    init_simple_test("D_L");
    STRUCT_IF_C D_L lv;
    check2(sizeof(lv), 16, "sizeof(D_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_L)");
    check_field_offset(lv, v1, 0, "D_L.v1");
    check_field_offset(lv, v2, 8, "D_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L, D_L)
//============================================================================



static void Test_D_L_BFu15i()
{
  {
    init_simple_test("D_L_BFu15i");
    static STRUCT_IF_C D_L_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu15i)");
    check_field_offset(lv, v1, 0, "D_L_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_L_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu15i, D_L_BFu15i)
//============================================================================



static void Test_D_L_BFu15ll()
{
  {
    init_simple_test("D_L_BFu15ll");
    static STRUCT_IF_C D_L_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_L_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu15ll, D_L_BFu15ll)
//============================================================================



static void Test_D_L_BFu15s()
{
  {
    init_simple_test("D_L_BFu15s");
    static STRUCT_IF_C D_L_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu15s)");
    check_field_offset(lv, v1, 0, "D_L_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_L_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu15s, D_L_BFu15s)
//============================================================================



static void Test_D_L_BFu16i()
{
  {
    init_simple_test("D_L_BFu16i");
    static STRUCT_IF_C D_L_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu16i)");
    check_field_offset(lv, v1, 0, "D_L_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_L_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu16i, D_L_BFu16i)
//============================================================================



static void Test_D_L_BFu16ll()
{
  {
    init_simple_test("D_L_BFu16ll");
    static STRUCT_IF_C D_L_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_L_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu16ll, D_L_BFu16ll)
//============================================================================



static void Test_D_L_BFu16s()
{
  {
    init_simple_test("D_L_BFu16s");
    static STRUCT_IF_C D_L_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu16s)");
    check_field_offset(lv, v1, 0, "D_L_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_L_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu16s, D_L_BFu16s)
//============================================================================



static void Test_D_L_BFu17i()
{
  {
    init_simple_test("D_L_BFu17i");
    static STRUCT_IF_C D_L_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(D_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu17i)");
    check_field_offset(lv, v1, 0, "D_L_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "D_L_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "D_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu17i, D_L_BFu17i)
//============================================================================



static void Test_D_L_BFu17ll()
{
  {
    init_simple_test("D_L_BFu17ll");
    static STRUCT_IF_C D_L_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(D_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "D_L_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "D_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu17ll, D_L_BFu17ll)
//============================================================================



static void Test_D_L_BFu1c()
{
  {
    init_simple_test("D_L_BFu1c");
    static STRUCT_IF_C D_L_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu1c)");
    check_field_offset(lv, v1, 0, "D_L_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu1c, D_L_BFu1c)
//============================================================================



static void Test_D_L_BFu1i()
{
  {
    init_simple_test("D_L_BFu1i");
    static STRUCT_IF_C D_L_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu1i)");
    check_field_offset(lv, v1, 0, "D_L_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu1i, D_L_BFu1i)
//============================================================================



static void Test_D_L_BFu1ll()
{
  {
    init_simple_test("D_L_BFu1ll");
    static STRUCT_IF_C D_L_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu1ll, D_L_BFu1ll)
//============================================================================



static void Test_D_L_BFu1s()
{
  {
    init_simple_test("D_L_BFu1s");
    static STRUCT_IF_C D_L_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu1s)");
    check_field_offset(lv, v1, 0, "D_L_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu1s, D_L_BFu1s)
//============================================================================



static void Test_D_L_BFu31i()
{
  {
    init_simple_test("D_L_BFu31i");
    static STRUCT_IF_C D_L_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(D_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu31i)");
    check_field_offset(lv, v1, 0, "D_L_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "D_L_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "D_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu31i, D_L_BFu31i)
//============================================================================



static void Test_D_L_BFu31ll()
{
  {
    init_simple_test("D_L_BFu31ll");
    static STRUCT_IF_C D_L_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(D_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "D_L_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "D_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu31ll, D_L_BFu31ll)
//============================================================================



static void Test_D_L_BFu32i()
{
  {
    init_simple_test("D_L_BFu32i");
    static STRUCT_IF_C D_L_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(D_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu32i)");
    check_field_offset(lv, v1, 0, "D_L_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "D_L_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "D_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu32i, D_L_BFu32i)
//============================================================================



static void Test_D_L_BFu32ll()
{
  {
    init_simple_test("D_L_BFu32ll");
    static STRUCT_IF_C D_L_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(D_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "D_L_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "D_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu32ll, D_L_BFu32ll)
//============================================================================



static void Test_D_L_BFu33()
{
  {
    init_simple_test("D_L_BFu33");
    static STRUCT_IF_C D_L_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(D_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu33)");
    check_field_offset(lv, v1, 0, "D_L_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "D_L_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "D_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu33, D_L_BFu33)
//============================================================================



static void Test_D_L_BFu7c()
{
  {
    init_simple_test("D_L_BFu7c");
    static STRUCT_IF_C D_L_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu7c)");
    check_field_offset(lv, v1, 0, "D_L_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_L_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu7c, D_L_BFu7c)
//============================================================================



static void Test_D_L_BFu7i()
{
  {
    init_simple_test("D_L_BFu7i");
    static STRUCT_IF_C D_L_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu7i)");
    check_field_offset(lv, v1, 0, "D_L_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_L_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu7i, D_L_BFu7i)
//============================================================================



static void Test_D_L_BFu7ll()
{
  {
    init_simple_test("D_L_BFu7ll");
    static STRUCT_IF_C D_L_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_L_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu7ll, D_L_BFu7ll)
//============================================================================



static void Test_D_L_BFu7s()
{
  {
    init_simple_test("D_L_BFu7s");
    static STRUCT_IF_C D_L_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu7s)");
    check_field_offset(lv, v1, 0, "D_L_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_L_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu7s, D_L_BFu7s)
//============================================================================



static void Test_D_L_BFu8c()
{
  {
    init_simple_test("D_L_BFu8c");
    static STRUCT_IF_C D_L_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu8c)");
    check_field_offset(lv, v1, 0, "D_L_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_L_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu8c, D_L_BFu8c)
//============================================================================



static void Test_D_L_BFu8i()
{
  {
    init_simple_test("D_L_BFu8i");
    static STRUCT_IF_C D_L_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu8i)");
    check_field_offset(lv, v1, 0, "D_L_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_L_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu8i, D_L_BFu8i)
//============================================================================



static void Test_D_L_BFu8ll()
{
  {
    init_simple_test("D_L_BFu8ll");
    static STRUCT_IF_C D_L_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_L_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu8ll, D_L_BFu8ll)
//============================================================================



static void Test_D_L_BFu8s()
{
  {
    init_simple_test("D_L_BFu8s");
    static STRUCT_IF_C D_L_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(D_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu8s)");
    check_field_offset(lv, v1, 0, "D_L_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_L_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu8s, D_L_BFu8s)
//============================================================================



static void Test_D_L_BFu9i()
{
  {
    init_simple_test("D_L_BFu9i");
    static STRUCT_IF_C D_L_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu9i)");
    check_field_offset(lv, v1, 0, "D_L_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_L_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu9i, D_L_BFu9i)
//============================================================================



static void Test_D_L_BFu9ll()
{
  {
    init_simple_test("D_L_BFu9ll");
    static STRUCT_IF_C D_L_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_L_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_L_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu9ll, D_L_BFu9ll)
//============================================================================



static void Test_D_L_BFu9s()
{
  {
    init_simple_test("D_L_BFu9s");
    static STRUCT_IF_C D_L_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(D_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_BFu9s)");
    check_field_offset(lv, v1, 0, "D_L_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_L_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_BFu9s, D_L_BFu9s)
//============================================================================



static void Test_D_L_C()
{
  {
    init_simple_test("D_L_C");
    STRUCT_IF_C D_L_C lv;
    check2(sizeof(lv), 17, "sizeof(D_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_C)");
    check_field_offset(lv, v1, 0, "D_L_C.v1");
    check_field_offset(lv, v2, 8, "D_L_C.v2");
    check_field_offset(lv, v3, 16, "D_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_C, D_L_C)
//============================================================================



static void Test_D_L_D()
{
  {
    init_simple_test("D_L_D");
    STRUCT_IF_C D_L_D lv;
    check2(sizeof(lv), 24, "sizeof(D_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_D)");
    check_field_offset(lv, v1, 0, "D_L_D.v1");
    check_field_offset(lv, v2, 8, "D_L_D.v2");
    check_field_offset(lv, v3, 16, "D_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_D, D_L_D)
//============================================================================



static void Test_D_L_F()
{
  {
    init_simple_test("D_L_F");
    STRUCT_IF_C D_L_F lv;
    check2(sizeof(lv), 20, "sizeof(D_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_F)");
    check_field_offset(lv, v1, 0, "D_L_F.v1");
    check_field_offset(lv, v2, 8, "D_L_F.v2");
    check_field_offset(lv, v3, 16, "D_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_F, D_L_F)
//============================================================================



static void Test_D_L_I()
{
  {
    init_simple_test("D_L_I");
    STRUCT_IF_C D_L_I lv;
    check2(sizeof(lv), 20, "sizeof(D_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_I)");
    check_field_offset(lv, v1, 0, "D_L_I.v1");
    check_field_offset(lv, v2, 8, "D_L_I.v2");
    check_field_offset(lv, v3, 16, "D_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_I, D_L_I)
//============================================================================



static void Test_D_L_Ip()
{
  {
    init_simple_test("D_L_Ip");
    STRUCT_IF_C D_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_Ip)");
    check_field_offset(lv, v1, 0, "D_L_Ip.v1");
    check_field_offset(lv, v2, 8, "D_L_Ip.v2");
    check_field_offset(lv, v3, 16, "D_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_Ip, D_L_Ip)
//============================================================================



static void Test_D_L_L()
{
  {
    init_simple_test("D_L_L");
    STRUCT_IF_C D_L_L lv;
    check2(sizeof(lv), 24, "sizeof(D_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_L)");
    check_field_offset(lv, v1, 0, "D_L_L.v1");
    check_field_offset(lv, v2, 8, "D_L_L.v2");
    check_field_offset(lv, v3, 16, "D_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_L, D_L_L)
//============================================================================



static void Test_D_L_S()
{
  {
    init_simple_test("D_L_S");
    STRUCT_IF_C D_L_S lv;
    check2(sizeof(lv), 18, "sizeof(D_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_S)");
    check_field_offset(lv, v1, 0, "D_L_S.v1");
    check_field_offset(lv, v2, 8, "D_L_S.v2");
    check_field_offset(lv, v3, 16, "D_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_S, D_L_S)
//============================================================================



static void Test_D_L_Uc()
{
  {
    init_simple_test("D_L_Uc");
    STRUCT_IF_C D_L_Uc lv;
    check2(sizeof(lv), 17, "sizeof(D_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_Uc)");
    check_field_offset(lv, v1, 0, "D_L_Uc.v1");
    check_field_offset(lv, v2, 8, "D_L_Uc.v2");
    check_field_offset(lv, v3, 16, "D_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_Uc, D_L_Uc)
//============================================================================



static void Test_D_L_Ui()
{
  {
    init_simple_test("D_L_Ui");
    STRUCT_IF_C D_L_Ui lv;
    check2(sizeof(lv), 20, "sizeof(D_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_Ui)");
    check_field_offset(lv, v1, 0, "D_L_Ui.v1");
    check_field_offset(lv, v2, 8, "D_L_Ui.v2");
    check_field_offset(lv, v3, 16, "D_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_Ui, D_L_Ui)
//============================================================================



static void Test_D_L_Ul()
{
  {
    init_simple_test("D_L_Ul");
    STRUCT_IF_C D_L_Ul lv;
    check2(sizeof(lv), 24, "sizeof(D_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_Ul)");
    check_field_offset(lv, v1, 0, "D_L_Ul.v1");
    check_field_offset(lv, v2, 8, "D_L_Ul.v2");
    check_field_offset(lv, v3, 16, "D_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_Ul, D_L_Ul)
//============================================================================



static void Test_D_L_Us()
{
  {
    init_simple_test("D_L_Us");
    STRUCT_IF_C D_L_Us lv;
    check2(sizeof(lv), 18, "sizeof(D_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_Us)");
    check_field_offset(lv, v1, 0, "D_L_Us.v1");
    check_field_offset(lv, v2, 8, "D_L_Us.v2");
    check_field_offset(lv, v3, 16, "D_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_Us, D_L_Us)
//============================================================================



static void Test_D_L_Vp()
{
  {
    init_simple_test("D_L_Vp");
    STRUCT_IF_C D_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_L_Vp)");
    check_field_offset(lv, v1, 0, "D_L_Vp.v1");
    check_field_offset(lv, v2, 8, "D_L_Vp.v2");
    check_field_offset(lv, v3, 16, "D_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_L_Vp, D_L_Vp)
//============================================================================



static void Test_D_S()
{
  {
    init_simple_test("D_S");
    STRUCT_IF_C D_S lv;
    check2(sizeof(lv), 10, "sizeof(D_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_S)");
    check_field_offset(lv, v1, 0, "D_S.v1");
    check_field_offset(lv, v2, 8, "D_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S, D_S)
//============================================================================



static void Test_D_S_BFu15i()
{
  {
    init_simple_test("D_S_BFu15i");
    static STRUCT_IF_C D_S_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu15i)");
    check_field_offset(lv, v1, 0, "D_S_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_S_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu15i, D_S_BFu15i)
//============================================================================



static void Test_D_S_BFu15ll()
{
  {
    init_simple_test("D_S_BFu15ll");
    static STRUCT_IF_C D_S_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_S_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu15ll, D_S_BFu15ll)
//============================================================================



static void Test_D_S_BFu15s()
{
  {
    init_simple_test("D_S_BFu15s");
    static STRUCT_IF_C D_S_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu15s)");
    check_field_offset(lv, v1, 0, "D_S_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_S_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu15s, D_S_BFu15s)
//============================================================================



static void Test_D_S_BFu16i()
{
  {
    init_simple_test("D_S_BFu16i");
    static STRUCT_IF_C D_S_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu16i)");
    check_field_offset(lv, v1, 0, "D_S_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_S_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu16i, D_S_BFu16i)
//============================================================================



static void Test_D_S_BFu16ll()
{
  {
    init_simple_test("D_S_BFu16ll");
    static STRUCT_IF_C D_S_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_S_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu16ll, D_S_BFu16ll)
//============================================================================



static void Test_D_S_BFu16s()
{
  {
    init_simple_test("D_S_BFu16s");
    static STRUCT_IF_C D_S_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu16s)");
    check_field_offset(lv, v1, 0, "D_S_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_S_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu16s, D_S_BFu16s)
//============================================================================



static void Test_D_S_BFu17i()
{
  {
    init_simple_test("D_S_BFu17i");
    static STRUCT_IF_C D_S_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(D_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu17i)");
    check_field_offset(lv, v1, 0, "D_S_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_S_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu17i, D_S_BFu17i)
//============================================================================



static void Test_D_S_BFu17ll()
{
  {
    init_simple_test("D_S_BFu17ll");
    static STRUCT_IF_C D_S_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(D_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_S_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu17ll, D_S_BFu17ll)
//============================================================================



static void Test_D_S_BFu1c()
{
  {
    init_simple_test("D_S_BFu1c");
    static STRUCT_IF_C D_S_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu1c)");
    check_field_offset(lv, v1, 0, "D_S_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu1c, D_S_BFu1c)
//============================================================================



static void Test_D_S_BFu1i()
{
  {
    init_simple_test("D_S_BFu1i");
    static STRUCT_IF_C D_S_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu1i)");
    check_field_offset(lv, v1, 0, "D_S_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu1i, D_S_BFu1i)
//============================================================================



static void Test_D_S_BFu1ll()
{
  {
    init_simple_test("D_S_BFu1ll");
    static STRUCT_IF_C D_S_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu1ll, D_S_BFu1ll)
//============================================================================



static void Test_D_S_BFu1s()
{
  {
    init_simple_test("D_S_BFu1s");
    static STRUCT_IF_C D_S_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu1s)");
    check_field_offset(lv, v1, 0, "D_S_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu1s, D_S_BFu1s)
//============================================================================



static void Test_D_S_BFu31i()
{
  {
    init_simple_test("D_S_BFu31i");
    static STRUCT_IF_C D_S_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(D_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu31i)");
    check_field_offset(lv, v1, 0, "D_S_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_S_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu31i, D_S_BFu31i)
//============================================================================



static void Test_D_S_BFu31ll()
{
  {
    init_simple_test("D_S_BFu31ll");
    static STRUCT_IF_C D_S_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(D_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_S_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu31ll, D_S_BFu31ll)
//============================================================================



static void Test_D_S_BFu32i()
{
  {
    init_simple_test("D_S_BFu32i");
    static STRUCT_IF_C D_S_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(D_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu32i)");
    check_field_offset(lv, v1, 0, "D_S_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_S_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu32i, D_S_BFu32i)
//============================================================================



static void Test_D_S_BFu32ll()
{
  {
    init_simple_test("D_S_BFu32ll");
    static STRUCT_IF_C D_S_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(D_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_S_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu32ll, D_S_BFu32ll)
//============================================================================



static void Test_D_S_BFu33()
{
  {
    init_simple_test("D_S_BFu33");
    static STRUCT_IF_C D_S_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(D_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu33)");
    check_field_offset(lv, v1, 0, "D_S_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "D_S_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "D_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu33, D_S_BFu33)
//============================================================================



static void Test_D_S_BFu7c()
{
  {
    init_simple_test("D_S_BFu7c");
    static STRUCT_IF_C D_S_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu7c)");
    check_field_offset(lv, v1, 0, "D_S_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_S_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu7c, D_S_BFu7c)
//============================================================================



static void Test_D_S_BFu7i()
{
  {
    init_simple_test("D_S_BFu7i");
    static STRUCT_IF_C D_S_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu7i)");
    check_field_offset(lv, v1, 0, "D_S_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_S_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu7i, D_S_BFu7i)
//============================================================================



static void Test_D_S_BFu7ll()
{
  {
    init_simple_test("D_S_BFu7ll");
    static STRUCT_IF_C D_S_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_S_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu7ll, D_S_BFu7ll)
//============================================================================



static void Test_D_S_BFu7s()
{
  {
    init_simple_test("D_S_BFu7s");
    static STRUCT_IF_C D_S_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu7s)");
    check_field_offset(lv, v1, 0, "D_S_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_S_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu7s, D_S_BFu7s)
//============================================================================



static void Test_D_S_BFu8c()
{
  {
    init_simple_test("D_S_BFu8c");
    static STRUCT_IF_C D_S_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu8c)");
    check_field_offset(lv, v1, 0, "D_S_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_S_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu8c, D_S_BFu8c)
//============================================================================



static void Test_D_S_BFu8i()
{
  {
    init_simple_test("D_S_BFu8i");
    static STRUCT_IF_C D_S_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu8i)");
    check_field_offset(lv, v1, 0, "D_S_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_S_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu8i, D_S_BFu8i)
//============================================================================



static void Test_D_S_BFu8ll()
{
  {
    init_simple_test("D_S_BFu8ll");
    static STRUCT_IF_C D_S_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_S_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu8ll, D_S_BFu8ll)
//============================================================================



static void Test_D_S_BFu8s()
{
  {
    init_simple_test("D_S_BFu8s");
    static STRUCT_IF_C D_S_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(D_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu8s)");
    check_field_offset(lv, v1, 0, "D_S_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_S_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu8s, D_S_BFu8s)
//============================================================================



static void Test_D_S_BFu9i()
{
  {
    init_simple_test("D_S_BFu9i");
    static STRUCT_IF_C D_S_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu9i)");
    check_field_offset(lv, v1, 0, "D_S_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_S_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu9i, D_S_BFu9i)
//============================================================================



static void Test_D_S_BFu9ll()
{
  {
    init_simple_test("D_S_BFu9ll");
    static STRUCT_IF_C D_S_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_S_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_S_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu9ll, D_S_BFu9ll)
//============================================================================



static void Test_D_S_BFu9s()
{
  {
    init_simple_test("D_S_BFu9s");
    static STRUCT_IF_C D_S_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(D_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_BFu9s)");
    check_field_offset(lv, v1, 0, "D_S_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_S_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_BFu9s, D_S_BFu9s)
//============================================================================



static void Test_D_S_C()
{
  {
    init_simple_test("D_S_C");
    STRUCT_IF_C D_S_C lv;
    check2(sizeof(lv), 11, "sizeof(D_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_C)");
    check_field_offset(lv, v1, 0, "D_S_C.v1");
    check_field_offset(lv, v2, 8, "D_S_C.v2");
    check_field_offset(lv, v3, 10, "D_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_C, D_S_C)
//============================================================================



static void Test_D_S_D()
{
  {
    init_simple_test("D_S_D");
    STRUCT_IF_C D_S_D lv;
    check2(sizeof(lv), 18, "sizeof(D_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_D)");
    check_field_offset(lv, v1, 0, "D_S_D.v1");
    check_field_offset(lv, v2, 8, "D_S_D.v2");
    check_field_offset(lv, v3, 10, "D_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_D, D_S_D)
//============================================================================



static void Test_D_S_F()
{
  {
    init_simple_test("D_S_F");
    STRUCT_IF_C D_S_F lv;
    check2(sizeof(lv), 14, "sizeof(D_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_F)");
    check_field_offset(lv, v1, 0, "D_S_F.v1");
    check_field_offset(lv, v2, 8, "D_S_F.v2");
    check_field_offset(lv, v3, 10, "D_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_F, D_S_F)
//============================================================================



static void Test_D_S_I()
{
  {
    init_simple_test("D_S_I");
    STRUCT_IF_C D_S_I lv;
    check2(sizeof(lv), 14, "sizeof(D_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_I)");
    check_field_offset(lv, v1, 0, "D_S_I.v1");
    check_field_offset(lv, v2, 8, "D_S_I.v2");
    check_field_offset(lv, v3, 10, "D_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_I, D_S_I)
//============================================================================



static void Test_D_S_Ip()
{
  {
    init_simple_test("D_S_Ip");
    STRUCT_IF_C D_S_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_Ip)");
    check_field_offset(lv, v1, 0, "D_S_Ip.v1");
    check_field_offset(lv, v2, 8, "D_S_Ip.v2");
    check_field_offset(lv, v3, 10, "D_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_Ip, D_S_Ip)
//============================================================================



static void Test_D_S_L()
{
  {
    init_simple_test("D_S_L");
    STRUCT_IF_C D_S_L lv;
    check2(sizeof(lv), 18, "sizeof(D_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_L)");
    check_field_offset(lv, v1, 0, "D_S_L.v1");
    check_field_offset(lv, v2, 8, "D_S_L.v2");
    check_field_offset(lv, v3, 10, "D_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_L, D_S_L)
//============================================================================



static void Test_D_S_S()
{
  {
    init_simple_test("D_S_S");
    STRUCT_IF_C D_S_S lv;
    check2(sizeof(lv), 12, "sizeof(D_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_S)");
    check_field_offset(lv, v1, 0, "D_S_S.v1");
    check_field_offset(lv, v2, 8, "D_S_S.v2");
    check_field_offset(lv, v3, 10, "D_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_S, D_S_S)
//============================================================================



static void Test_D_S_Uc()
{
  {
    init_simple_test("D_S_Uc");
    STRUCT_IF_C D_S_Uc lv;
    check2(sizeof(lv), 11, "sizeof(D_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_Uc)");
    check_field_offset(lv, v1, 0, "D_S_Uc.v1");
    check_field_offset(lv, v2, 8, "D_S_Uc.v2");
    check_field_offset(lv, v3, 10, "D_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_Uc, D_S_Uc)
//============================================================================



static void Test_D_S_Ui()
{
  {
    init_simple_test("D_S_Ui");
    STRUCT_IF_C D_S_Ui lv;
    check2(sizeof(lv), 14, "sizeof(D_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_Ui)");
    check_field_offset(lv, v1, 0, "D_S_Ui.v1");
    check_field_offset(lv, v2, 8, "D_S_Ui.v2");
    check_field_offset(lv, v3, 10, "D_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_Ui, D_S_Ui)
//============================================================================



static void Test_D_S_Ul()
{
  {
    init_simple_test("D_S_Ul");
    STRUCT_IF_C D_S_Ul lv;
    check2(sizeof(lv), 18, "sizeof(D_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_Ul)");
    check_field_offset(lv, v1, 0, "D_S_Ul.v1");
    check_field_offset(lv, v2, 8, "D_S_Ul.v2");
    check_field_offset(lv, v3, 10, "D_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_Ul, D_S_Ul)
//============================================================================



static void Test_D_S_Us()
{
  {
    init_simple_test("D_S_Us");
    STRUCT_IF_C D_S_Us lv;
    check2(sizeof(lv), 12, "sizeof(D_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_Us)");
    check_field_offset(lv, v1, 0, "D_S_Us.v1");
    check_field_offset(lv, v2, 8, "D_S_Us.v2");
    check_field_offset(lv, v3, 10, "D_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_Us, D_S_Us)
//============================================================================



static void Test_D_S_Vp()
{
  {
    init_simple_test("D_S_Vp");
    STRUCT_IF_C D_S_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_S_Vp)");
    check_field_offset(lv, v1, 0, "D_S_Vp.v1");
    check_field_offset(lv, v2, 8, "D_S_Vp.v2");
    check_field_offset(lv, v3, 10, "D_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_S_Vp, D_S_Vp)
//============================================================================



static void Test_D_Uc()
{
  {
    init_simple_test("D_Uc");
    STRUCT_IF_C D_Uc lv;
    check2(sizeof(lv), 9, "sizeof(D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc)");
    check_field_offset(lv, v1, 0, "D_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc, D_Uc)
//============================================================================



static void Test_D_Uc_BFu15i()
{
  {
    init_simple_test("D_Uc_BFu15i");
    static STRUCT_IF_C D_Uc_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_Uc_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu15i, D_Uc_BFu15i)
//============================================================================



static void Test_D_Uc_BFu15ll()
{
  {
    init_simple_test("D_Uc_BFu15ll");
    static STRUCT_IF_C D_Uc_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu15ll, D_Uc_BFu15ll)
//============================================================================



static void Test_D_Uc_BFu15s()
{
  {
    init_simple_test("D_Uc_BFu15s");
    static STRUCT_IF_C D_Uc_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_Uc_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu15s, D_Uc_BFu15s)
//============================================================================



static void Test_D_Uc_BFu16i()
{
  {
    init_simple_test("D_Uc_BFu16i");
    static STRUCT_IF_C D_Uc_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_Uc_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu16i, D_Uc_BFu16i)
//============================================================================



static void Test_D_Uc_BFu16ll()
{
  {
    init_simple_test("D_Uc_BFu16ll");
    static STRUCT_IF_C D_Uc_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu16ll, D_Uc_BFu16ll)
//============================================================================



static void Test_D_Uc_BFu16s()
{
  {
    init_simple_test("D_Uc_BFu16s");
    static STRUCT_IF_C D_Uc_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_Uc_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu16s, D_Uc_BFu16s)
//============================================================================



static void Test_D_Uc_BFu17i()
{
  {
    init_simple_test("D_Uc_BFu17i");
    static STRUCT_IF_C D_Uc_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(D_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "D_Uc_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "D_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu17i, D_Uc_BFu17i)
//============================================================================



static void Test_D_Uc_BFu17ll()
{
  {
    init_simple_test("D_Uc_BFu17ll");
    static STRUCT_IF_C D_Uc_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(D_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "D_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "D_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu17ll, D_Uc_BFu17ll)
//============================================================================



static void Test_D_Uc_BFu1c()
{
  {
    init_simple_test("D_Uc_BFu1c");
    static STRUCT_IF_C D_Uc_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu1c, D_Uc_BFu1c)
//============================================================================



static void Test_D_Uc_BFu1i()
{
  {
    init_simple_test("D_Uc_BFu1i");
    static STRUCT_IF_C D_Uc_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu1i, D_Uc_BFu1i)
//============================================================================



static void Test_D_Uc_BFu1ll()
{
  {
    init_simple_test("D_Uc_BFu1ll");
    static STRUCT_IF_C D_Uc_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu1ll, D_Uc_BFu1ll)
//============================================================================



static void Test_D_Uc_BFu1s()
{
  {
    init_simple_test("D_Uc_BFu1s");
    static STRUCT_IF_C D_Uc_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu1s, D_Uc_BFu1s)
//============================================================================



static void Test_D_Uc_BFu31i()
{
  {
    init_simple_test("D_Uc_BFu31i");
    static STRUCT_IF_C D_Uc_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "D_Uc_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "D_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu31i, D_Uc_BFu31i)
//============================================================================



static void Test_D_Uc_BFu31ll()
{
  {
    init_simple_test("D_Uc_BFu31ll");
    static STRUCT_IF_C D_Uc_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "D_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "D_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu31ll, D_Uc_BFu31ll)
//============================================================================



static void Test_D_Uc_BFu32i()
{
  {
    init_simple_test("D_Uc_BFu32i");
    static STRUCT_IF_C D_Uc_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "D_Uc_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "D_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu32i, D_Uc_BFu32i)
//============================================================================



static void Test_D_Uc_BFu32ll()
{
  {
    init_simple_test("D_Uc_BFu32ll");
    static STRUCT_IF_C D_Uc_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "D_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "D_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu32ll, D_Uc_BFu32ll)
//============================================================================



static void Test_D_Uc_BFu33()
{
  {
    init_simple_test("D_Uc_BFu33");
    static STRUCT_IF_C D_Uc_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(D_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "D_Uc_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "D_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu33, D_Uc_BFu33)
//============================================================================



static void Test_D_Uc_BFu7c()
{
  {
    init_simple_test("D_Uc_BFu7c");
    static STRUCT_IF_C D_Uc_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_Uc_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu7c, D_Uc_BFu7c)
//============================================================================



static void Test_D_Uc_BFu7i()
{
  {
    init_simple_test("D_Uc_BFu7i");
    static STRUCT_IF_C D_Uc_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_Uc_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu7i, D_Uc_BFu7i)
//============================================================================



static void Test_D_Uc_BFu7ll()
{
  {
    init_simple_test("D_Uc_BFu7ll");
    static STRUCT_IF_C D_Uc_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu7ll, D_Uc_BFu7ll)
//============================================================================



static void Test_D_Uc_BFu7s()
{
  {
    init_simple_test("D_Uc_BFu7s");
    static STRUCT_IF_C D_Uc_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_Uc_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu7s, D_Uc_BFu7s)
//============================================================================



static void Test_D_Uc_BFu8c()
{
  {
    init_simple_test("D_Uc_BFu8c");
    static STRUCT_IF_C D_Uc_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_Uc_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu8c, D_Uc_BFu8c)
//============================================================================



static void Test_D_Uc_BFu8i()
{
  {
    init_simple_test("D_Uc_BFu8i");
    static STRUCT_IF_C D_Uc_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_Uc_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu8i, D_Uc_BFu8i)
//============================================================================



static void Test_D_Uc_BFu8ll()
{
  {
    init_simple_test("D_Uc_BFu8ll");
    static STRUCT_IF_C D_Uc_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu8ll, D_Uc_BFu8ll)
//============================================================================



static void Test_D_Uc_BFu8s()
{
  {
    init_simple_test("D_Uc_BFu8s");
    static STRUCT_IF_C D_Uc_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_Uc_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu8s, D_Uc_BFu8s)
//============================================================================



static void Test_D_Uc_BFu9i()
{
  {
    init_simple_test("D_Uc_BFu9i");
    static STRUCT_IF_C D_Uc_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_Uc_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu9i, D_Uc_BFu9i)
//============================================================================



static void Test_D_Uc_BFu9ll()
{
  {
    init_simple_test("D_Uc_BFu9ll");
    static STRUCT_IF_C D_Uc_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu9ll, D_Uc_BFu9ll)
//============================================================================



static void Test_D_Uc_BFu9s()
{
  {
    init_simple_test("D_Uc_BFu9s");
    static STRUCT_IF_C D_Uc_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "D_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_Uc_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_BFu9s, D_Uc_BFu9s)
//============================================================================



static void Test_D_Uc_C()
{
  {
    init_simple_test("D_Uc_C");
    STRUCT_IF_C D_Uc_C lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_C)");
    check_field_offset(lv, v1, 0, "D_Uc_C.v1");
    check_field_offset(lv, v2, 8, "D_Uc_C.v2");
    check_field_offset(lv, v3, 9, "D_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_C, D_Uc_C)
//============================================================================



static void Test_D_Uc_D()
{
  {
    init_simple_test("D_Uc_D");
    STRUCT_IF_C D_Uc_D lv;
    check2(sizeof(lv), 17, "sizeof(D_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_D)");
    check_field_offset(lv, v1, 0, "D_Uc_D.v1");
    check_field_offset(lv, v2, 8, "D_Uc_D.v2");
    check_field_offset(lv, v3, 9, "D_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_D, D_Uc_D)
//============================================================================



static void Test_D_Uc_F()
{
  {
    init_simple_test("D_Uc_F");
    STRUCT_IF_C D_Uc_F lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_F)");
    check_field_offset(lv, v1, 0, "D_Uc_F.v1");
    check_field_offset(lv, v2, 8, "D_Uc_F.v2");
    check_field_offset(lv, v3, 9, "D_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_F, D_Uc_F)
//============================================================================



static void Test_D_Uc_I()
{
  {
    init_simple_test("D_Uc_I");
    STRUCT_IF_C D_Uc_I lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_I)");
    check_field_offset(lv, v1, 0, "D_Uc_I.v1");
    check_field_offset(lv, v2, 8, "D_Uc_I.v2");
    check_field_offset(lv, v3, 9, "D_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_I, D_Uc_I)
//============================================================================



static void Test_D_Uc_Ip()
{
  {
    init_simple_test("D_Uc_Ip");
    STRUCT_IF_C D_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_Ip)");
    check_field_offset(lv, v1, 0, "D_Uc_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Uc_Ip.v2");
    check_field_offset(lv, v3, 9, "D_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_Ip, D_Uc_Ip)
//============================================================================



static void Test_D_Uc_L()
{
  {
    init_simple_test("D_Uc_L");
    STRUCT_IF_C D_Uc_L lv;
    check2(sizeof(lv), 17, "sizeof(D_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_L)");
    check_field_offset(lv, v1, 0, "D_Uc_L.v1");
    check_field_offset(lv, v2, 8, "D_Uc_L.v2");
    check_field_offset(lv, v3, 9, "D_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_L, D_Uc_L)
//============================================================================



static void Test_D_Uc_S()
{
  {
    init_simple_test("D_Uc_S");
    STRUCT_IF_C D_Uc_S lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_S)");
    check_field_offset(lv, v1, 0, "D_Uc_S.v1");
    check_field_offset(lv, v2, 8, "D_Uc_S.v2");
    check_field_offset(lv, v3, 9, "D_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_S, D_Uc_S)
//============================================================================



static void Test_D_Uc_Uc()
{
  {
    init_simple_test("D_Uc_Uc");
    STRUCT_IF_C D_Uc_Uc lv;
    check2(sizeof(lv), 10, "sizeof(D_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_Uc)");
    check_field_offset(lv, v1, 0, "D_Uc_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Uc_Uc.v2");
    check_field_offset(lv, v3, 9, "D_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_Uc, D_Uc_Uc)
//============================================================================



static void Test_D_Uc_Ui()
{
  {
    init_simple_test("D_Uc_Ui");
    STRUCT_IF_C D_Uc_Ui lv;
    check2(sizeof(lv), 13, "sizeof(D_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_Ui)");
    check_field_offset(lv, v1, 0, "D_Uc_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Uc_Ui.v2");
    check_field_offset(lv, v3, 9, "D_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_Ui, D_Uc_Ui)
//============================================================================



static void Test_D_Uc_Ul()
{
  {
    init_simple_test("D_Uc_Ul");
    STRUCT_IF_C D_Uc_Ul lv;
    check2(sizeof(lv), 17, "sizeof(D_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_Ul)");
    check_field_offset(lv, v1, 0, "D_Uc_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Uc_Ul.v2");
    check_field_offset(lv, v3, 9, "D_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_Ul, D_Uc_Ul)
//============================================================================



static void Test_D_Uc_Us()
{
  {
    init_simple_test("D_Uc_Us");
    STRUCT_IF_C D_Uc_Us lv;
    check2(sizeof(lv), 11, "sizeof(D_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_Us)");
    check_field_offset(lv, v1, 0, "D_Uc_Us.v1");
    check_field_offset(lv, v2, 8, "D_Uc_Us.v2");
    check_field_offset(lv, v3, 9, "D_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_Us, D_Uc_Us)
//============================================================================



static void Test_D_Uc_Vp()
{
  {
    init_simple_test("D_Uc_Vp");
    STRUCT_IF_C D_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Uc_Vp)");
    check_field_offset(lv, v1, 0, "D_Uc_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Uc_Vp.v2");
    check_field_offset(lv, v3, 9, "D_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Uc_Vp, D_Uc_Vp)
//============================================================================



static void Test_D_Ui()
{
  {
    init_simple_test("D_Ui");
    STRUCT_IF_C D_Ui lv;
    check2(sizeof(lv), 12, "sizeof(D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui)");
    check_field_offset(lv, v1, 0, "D_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui, D_Ui)
//============================================================================



static void Test_D_Ui_BFu15i()
{
  {
    init_simple_test("D_Ui_BFu15i");
    static STRUCT_IF_C D_Ui_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_Ui_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu15i, D_Ui_BFu15i)
//============================================================================



static void Test_D_Ui_BFu15ll()
{
  {
    init_simple_test("D_Ui_BFu15ll");
    static STRUCT_IF_C D_Ui_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu15ll, D_Ui_BFu15ll)
//============================================================================



static void Test_D_Ui_BFu15s()
{
  {
    init_simple_test("D_Ui_BFu15s");
    static STRUCT_IF_C D_Ui_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "D_Ui_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "D_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu15s, D_Ui_BFu15s)
//============================================================================



static void Test_D_Ui_BFu16i()
{
  {
    init_simple_test("D_Ui_BFu16i");
    static STRUCT_IF_C D_Ui_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_Ui_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu16i, D_Ui_BFu16i)
//============================================================================



static void Test_D_Ui_BFu16ll()
{
  {
    init_simple_test("D_Ui_BFu16ll");
    static STRUCT_IF_C D_Ui_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu16ll, D_Ui_BFu16ll)
//============================================================================



static void Test_D_Ui_BFu16s()
{
  {
    init_simple_test("D_Ui_BFu16s");
    static STRUCT_IF_C D_Ui_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "D_Ui_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "D_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu16s, D_Ui_BFu16s)
//============================================================================



static void Test_D_Ui_BFu17i()
{
  {
    init_simple_test("D_Ui_BFu17i");
    static STRUCT_IF_C D_Ui_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(D_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_Ui_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu17i, D_Ui_BFu17i)
//============================================================================



static void Test_D_Ui_BFu17ll()
{
  {
    init_simple_test("D_Ui_BFu17ll");
    static STRUCT_IF_C D_Ui_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(D_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "D_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "D_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu17ll, D_Ui_BFu17ll)
//============================================================================



static void Test_D_Ui_BFu1c()
{
  {
    init_simple_test("D_Ui_BFu1c");
    static STRUCT_IF_C D_Ui_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu1c, D_Ui_BFu1c)
//============================================================================



static void Test_D_Ui_BFu1i()
{
  {
    init_simple_test("D_Ui_BFu1i");
    static STRUCT_IF_C D_Ui_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu1i, D_Ui_BFu1i)
//============================================================================



static void Test_D_Ui_BFu1ll()
{
  {
    init_simple_test("D_Ui_BFu1ll");
    static STRUCT_IF_C D_Ui_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu1ll, D_Ui_BFu1ll)
//============================================================================



static void Test_D_Ui_BFu1s()
{
  {
    init_simple_test("D_Ui_BFu1s");
    static STRUCT_IF_C D_Ui_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "D_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu1s, D_Ui_BFu1s)
//============================================================================



static void Test_D_Ui_BFu31i()
{
  {
    init_simple_test("D_Ui_BFu31i");
    static STRUCT_IF_C D_Ui_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_Ui_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu31i, D_Ui_BFu31i)
//============================================================================



static void Test_D_Ui_BFu31ll()
{
  {
    init_simple_test("D_Ui_BFu31ll");
    static STRUCT_IF_C D_Ui_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu31ll, D_Ui_BFu31ll)
//============================================================================



static void Test_D_Ui_BFu32i()
{
  {
    init_simple_test("D_Ui_BFu32i");
    static STRUCT_IF_C D_Ui_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_Ui_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu32i, D_Ui_BFu32i)
//============================================================================



static void Test_D_Ui_BFu32ll()
{
  {
    init_simple_test("D_Ui_BFu32ll");
    static STRUCT_IF_C D_Ui_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu32ll, D_Ui_BFu32ll)
//============================================================================



static void Test_D_Ui_BFu33()
{
  {
    init_simple_test("D_Ui_BFu33");
    static STRUCT_IF_C D_Ui_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(D_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "D_Ui_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "D_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu33, D_Ui_BFu33)
//============================================================================



static void Test_D_Ui_BFu7c()
{
  {
    init_simple_test("D_Ui_BFu7c");
    static STRUCT_IF_C D_Ui_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_Ui_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu7c, D_Ui_BFu7c)
//============================================================================



static void Test_D_Ui_BFu7i()
{
  {
    init_simple_test("D_Ui_BFu7i");
    static STRUCT_IF_C D_Ui_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_Ui_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu7i, D_Ui_BFu7i)
//============================================================================



static void Test_D_Ui_BFu7ll()
{
  {
    init_simple_test("D_Ui_BFu7ll");
    static STRUCT_IF_C D_Ui_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu7ll, D_Ui_BFu7ll)
//============================================================================



static void Test_D_Ui_BFu7s()
{
  {
    init_simple_test("D_Ui_BFu7s");
    static STRUCT_IF_C D_Ui_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "D_Ui_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "D_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu7s, D_Ui_BFu7s)
//============================================================================



static void Test_D_Ui_BFu8c()
{
  {
    init_simple_test("D_Ui_BFu8c");
    static STRUCT_IF_C D_Ui_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_Ui_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu8c, D_Ui_BFu8c)
//============================================================================



static void Test_D_Ui_BFu8i()
{
  {
    init_simple_test("D_Ui_BFu8i");
    static STRUCT_IF_C D_Ui_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_Ui_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu8i, D_Ui_BFu8i)
//============================================================================



static void Test_D_Ui_BFu8ll()
{
  {
    init_simple_test("D_Ui_BFu8ll");
    static STRUCT_IF_C D_Ui_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu8ll, D_Ui_BFu8ll)
//============================================================================



static void Test_D_Ui_BFu8s()
{
  {
    init_simple_test("D_Ui_BFu8s");
    static STRUCT_IF_C D_Ui_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "D_Ui_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "D_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu8s, D_Ui_BFu8s)
//============================================================================



static void Test_D_Ui_BFu9i()
{
  {
    init_simple_test("D_Ui_BFu9i");
    static STRUCT_IF_C D_Ui_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_Ui_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu9i, D_Ui_BFu9i)
//============================================================================



static void Test_D_Ui_BFu9ll()
{
  {
    init_simple_test("D_Ui_BFu9ll");
    static STRUCT_IF_C D_Ui_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu9ll, D_Ui_BFu9ll)
//============================================================================



static void Test_D_Ui_BFu9s()
{
  {
    init_simple_test("D_Ui_BFu9s");
    static STRUCT_IF_C D_Ui_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "D_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "D_Ui_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "D_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_BFu9s, D_Ui_BFu9s)
//============================================================================



static void Test_D_Ui_C()
{
  {
    init_simple_test("D_Ui_C");
    STRUCT_IF_C D_Ui_C lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_C)");
    check_field_offset(lv, v1, 0, "D_Ui_C.v1");
    check_field_offset(lv, v2, 8, "D_Ui_C.v2");
    check_field_offset(lv, v3, 12, "D_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_C, D_Ui_C)
//============================================================================



static void Test_D_Ui_D()
{
  {
    init_simple_test("D_Ui_D");
    STRUCT_IF_C D_Ui_D lv;
    check2(sizeof(lv), 20, "sizeof(D_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_D)");
    check_field_offset(lv, v1, 0, "D_Ui_D.v1");
    check_field_offset(lv, v2, 8, "D_Ui_D.v2");
    check_field_offset(lv, v3, 12, "D_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_D, D_Ui_D)
//============================================================================



static void Test_D_Ui_F()
{
  {
    init_simple_test("D_Ui_F");
    STRUCT_IF_C D_Ui_F lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_F)");
    check_field_offset(lv, v1, 0, "D_Ui_F.v1");
    check_field_offset(lv, v2, 8, "D_Ui_F.v2");
    check_field_offset(lv, v3, 12, "D_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_F, D_Ui_F)
//============================================================================



static void Test_D_Ui_I()
{
  {
    init_simple_test("D_Ui_I");
    STRUCT_IF_C D_Ui_I lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_I)");
    check_field_offset(lv, v1, 0, "D_Ui_I.v1");
    check_field_offset(lv, v2, 8, "D_Ui_I.v2");
    check_field_offset(lv, v3, 12, "D_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_I, D_Ui_I)
//============================================================================



static void Test_D_Ui_Ip()
{
  {
    init_simple_test("D_Ui_Ip");
    STRUCT_IF_C D_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_Ip)");
    check_field_offset(lv, v1, 0, "D_Ui_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Ui_Ip.v2");
    check_field_offset(lv, v3, 12, "D_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_Ip, D_Ui_Ip)
//============================================================================



static void Test_D_Ui_L()
{
  {
    init_simple_test("D_Ui_L");
    STRUCT_IF_C D_Ui_L lv;
    check2(sizeof(lv), 20, "sizeof(D_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_L)");
    check_field_offset(lv, v1, 0, "D_Ui_L.v1");
    check_field_offset(lv, v2, 8, "D_Ui_L.v2");
    check_field_offset(lv, v3, 12, "D_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_L, D_Ui_L)
//============================================================================



static void Test_D_Ui_S()
{
  {
    init_simple_test("D_Ui_S");
    STRUCT_IF_C D_Ui_S lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_S)");
    check_field_offset(lv, v1, 0, "D_Ui_S.v1");
    check_field_offset(lv, v2, 8, "D_Ui_S.v2");
    check_field_offset(lv, v3, 12, "D_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_S, D_Ui_S)
//============================================================================



static void Test_D_Ui_Uc()
{
  {
    init_simple_test("D_Ui_Uc");
    STRUCT_IF_C D_Ui_Uc lv;
    check2(sizeof(lv), 13, "sizeof(D_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_Uc)");
    check_field_offset(lv, v1, 0, "D_Ui_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Ui_Uc.v2");
    check_field_offset(lv, v3, 12, "D_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_Uc, D_Ui_Uc)
//============================================================================



static void Test_D_Ui_Ui()
{
  {
    init_simple_test("D_Ui_Ui");
    STRUCT_IF_C D_Ui_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_Ui)");
    check_field_offset(lv, v1, 0, "D_Ui_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Ui_Ui.v2");
    check_field_offset(lv, v3, 12, "D_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_Ui, D_Ui_Ui)
//============================================================================



static void Test_D_Ui_Ul()
{
  {
    init_simple_test("D_Ui_Ul");
    STRUCT_IF_C D_Ui_Ul lv;
    check2(sizeof(lv), 20, "sizeof(D_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_Ul)");
    check_field_offset(lv, v1, 0, "D_Ui_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Ui_Ul.v2");
    check_field_offset(lv, v3, 12, "D_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_Ul, D_Ui_Ul)
//============================================================================



static void Test_D_Ui_Us()
{
  {
    init_simple_test("D_Ui_Us");
    STRUCT_IF_C D_Ui_Us lv;
    check2(sizeof(lv), 14, "sizeof(D_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_Us)");
    check_field_offset(lv, v1, 0, "D_Ui_Us.v1");
    check_field_offset(lv, v2, 8, "D_Ui_Us.v2");
    check_field_offset(lv, v3, 12, "D_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_Us, D_Ui_Us)
//============================================================================



static void Test_D_Ui_Vp()
{
  {
    init_simple_test("D_Ui_Vp");
    STRUCT_IF_C D_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ui_Vp)");
    check_field_offset(lv, v1, 0, "D_Ui_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Ui_Vp.v2");
    check_field_offset(lv, v3, 12, "D_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ui_Vp, D_Ui_Vp)
//============================================================================



static void Test_D_Ul()
{
  {
    init_simple_test("D_Ul");
    STRUCT_IF_C D_Ul lv;
    check2(sizeof(lv), 16, "sizeof(D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul)");
    check_field_offset(lv, v1, 0, "D_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul, D_Ul)
//============================================================================



static void Test_D_Ul_BFu15i()
{
  {
    init_simple_test("D_Ul_BFu15i");
    static STRUCT_IF_C D_Ul_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_Ul_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu15i, D_Ul_BFu15i)
//============================================================================



static void Test_D_Ul_BFu15ll()
{
  {
    init_simple_test("D_Ul_BFu15ll");
    static STRUCT_IF_C D_Ul_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu15ll, D_Ul_BFu15ll)
//============================================================================



static void Test_D_Ul_BFu15s()
{
  {
    init_simple_test("D_Ul_BFu15s");
    static STRUCT_IF_C D_Ul_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "D_Ul_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "D_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu15s, D_Ul_BFu15s)
//============================================================================



static void Test_D_Ul_BFu16i()
{
  {
    init_simple_test("D_Ul_BFu16i");
    static STRUCT_IF_C D_Ul_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_Ul_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu16i, D_Ul_BFu16i)
//============================================================================



static void Test_D_Ul_BFu16ll()
{
  {
    init_simple_test("D_Ul_BFu16ll");
    static STRUCT_IF_C D_Ul_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu16ll, D_Ul_BFu16ll)
//============================================================================



static void Test_D_Ul_BFu16s()
{
  {
    init_simple_test("D_Ul_BFu16s");
    static STRUCT_IF_C D_Ul_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "D_Ul_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "D_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu16s, D_Ul_BFu16s)
//============================================================================



static void Test_D_Ul_BFu17i()
{
  {
    init_simple_test("D_Ul_BFu17i");
    static STRUCT_IF_C D_Ul_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(D_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "D_Ul_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "D_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu17i, D_Ul_BFu17i)
//============================================================================



static void Test_D_Ul_BFu17ll()
{
  {
    init_simple_test("D_Ul_BFu17ll");
    static STRUCT_IF_C D_Ul_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(D_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "D_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "D_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu17ll, D_Ul_BFu17ll)
//============================================================================



static void Test_D_Ul_BFu1c()
{
  {
    init_simple_test("D_Ul_BFu1c");
    static STRUCT_IF_C D_Ul_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu1c, D_Ul_BFu1c)
//============================================================================



static void Test_D_Ul_BFu1i()
{
  {
    init_simple_test("D_Ul_BFu1i");
    static STRUCT_IF_C D_Ul_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu1i, D_Ul_BFu1i)
//============================================================================



static void Test_D_Ul_BFu1ll()
{
  {
    init_simple_test("D_Ul_BFu1ll");
    static STRUCT_IF_C D_Ul_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu1ll, D_Ul_BFu1ll)
//============================================================================



static void Test_D_Ul_BFu1s()
{
  {
    init_simple_test("D_Ul_BFu1s");
    static STRUCT_IF_C D_Ul_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "D_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu1s, D_Ul_BFu1s)
//============================================================================



static void Test_D_Ul_BFu31i()
{
  {
    init_simple_test("D_Ul_BFu31i");
    static STRUCT_IF_C D_Ul_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "D_Ul_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "D_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu31i, D_Ul_BFu31i)
//============================================================================



static void Test_D_Ul_BFu31ll()
{
  {
    init_simple_test("D_Ul_BFu31ll");
    static STRUCT_IF_C D_Ul_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "D_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "D_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu31ll, D_Ul_BFu31ll)
//============================================================================



static void Test_D_Ul_BFu32i()
{
  {
    init_simple_test("D_Ul_BFu32i");
    static STRUCT_IF_C D_Ul_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "D_Ul_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "D_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu32i, D_Ul_BFu32i)
//============================================================================



static void Test_D_Ul_BFu32ll()
{
  {
    init_simple_test("D_Ul_BFu32ll");
    static STRUCT_IF_C D_Ul_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "D_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "D_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu32ll, D_Ul_BFu32ll)
//============================================================================



static void Test_D_Ul_BFu33()
{
  {
    init_simple_test("D_Ul_BFu33");
    static STRUCT_IF_C D_Ul_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(D_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "D_Ul_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "D_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu33, D_Ul_BFu33)
//============================================================================



static void Test_D_Ul_BFu7c()
{
  {
    init_simple_test("D_Ul_BFu7c");
    static STRUCT_IF_C D_Ul_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_Ul_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu7c, D_Ul_BFu7c)
//============================================================================



static void Test_D_Ul_BFu7i()
{
  {
    init_simple_test("D_Ul_BFu7i");
    static STRUCT_IF_C D_Ul_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_Ul_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu7i, D_Ul_BFu7i)
//============================================================================



static void Test_D_Ul_BFu7ll()
{
  {
    init_simple_test("D_Ul_BFu7ll");
    static STRUCT_IF_C D_Ul_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu7ll, D_Ul_BFu7ll)
//============================================================================



static void Test_D_Ul_BFu7s()
{
  {
    init_simple_test("D_Ul_BFu7s");
    static STRUCT_IF_C D_Ul_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "D_Ul_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "D_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu7s, D_Ul_BFu7s)
//============================================================================



static void Test_D_Ul_BFu8c()
{
  {
    init_simple_test("D_Ul_BFu8c");
    static STRUCT_IF_C D_Ul_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_Ul_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu8c, D_Ul_BFu8c)
//============================================================================



static void Test_D_Ul_BFu8i()
{
  {
    init_simple_test("D_Ul_BFu8i");
    static STRUCT_IF_C D_Ul_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_Ul_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu8i, D_Ul_BFu8i)
//============================================================================



static void Test_D_Ul_BFu8ll()
{
  {
    init_simple_test("D_Ul_BFu8ll");
    static STRUCT_IF_C D_Ul_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu8ll, D_Ul_BFu8ll)
//============================================================================



static void Test_D_Ul_BFu8s()
{
  {
    init_simple_test("D_Ul_BFu8s");
    static STRUCT_IF_C D_Ul_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "D_Ul_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "D_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu8s, D_Ul_BFu8s)
//============================================================================



static void Test_D_Ul_BFu9i()
{
  {
    init_simple_test("D_Ul_BFu9i");
    static STRUCT_IF_C D_Ul_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_Ul_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu9i, D_Ul_BFu9i)
//============================================================================



static void Test_D_Ul_BFu9ll()
{
  {
    init_simple_test("D_Ul_BFu9ll");
    static STRUCT_IF_C D_Ul_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu9ll, D_Ul_BFu9ll)
//============================================================================



static void Test_D_Ul_BFu9s()
{
  {
    init_simple_test("D_Ul_BFu9s");
    static STRUCT_IF_C D_Ul_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "D_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "D_Ul_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "D_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_BFu9s, D_Ul_BFu9s)
//============================================================================



static void Test_D_Ul_C()
{
  {
    init_simple_test("D_Ul_C");
    STRUCT_IF_C D_Ul_C lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_C)");
    check_field_offset(lv, v1, 0, "D_Ul_C.v1");
    check_field_offset(lv, v2, 8, "D_Ul_C.v2");
    check_field_offset(lv, v3, 16, "D_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_C, D_Ul_C)
//============================================================================



static void Test_D_Ul_D()
{
  {
    init_simple_test("D_Ul_D");
    STRUCT_IF_C D_Ul_D lv;
    check2(sizeof(lv), 24, "sizeof(D_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_D)");
    check_field_offset(lv, v1, 0, "D_Ul_D.v1");
    check_field_offset(lv, v2, 8, "D_Ul_D.v2");
    check_field_offset(lv, v3, 16, "D_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_D, D_Ul_D)
//============================================================================



static void Test_D_Ul_F()
{
  {
    init_simple_test("D_Ul_F");
    STRUCT_IF_C D_Ul_F lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_F)");
    check_field_offset(lv, v1, 0, "D_Ul_F.v1");
    check_field_offset(lv, v2, 8, "D_Ul_F.v2");
    check_field_offset(lv, v3, 16, "D_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_F, D_Ul_F)
//============================================================================



static void Test_D_Ul_I()
{
  {
    init_simple_test("D_Ul_I");
    STRUCT_IF_C D_Ul_I lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_I)");
    check_field_offset(lv, v1, 0, "D_Ul_I.v1");
    check_field_offset(lv, v2, 8, "D_Ul_I.v2");
    check_field_offset(lv, v3, 16, "D_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_I, D_Ul_I)
//============================================================================



static void Test_D_Ul_Ip()
{
  {
    init_simple_test("D_Ul_Ip");
    STRUCT_IF_C D_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_Ip)");
    check_field_offset(lv, v1, 0, "D_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Ul_Ip.v2");
    check_field_offset(lv, v3, 16, "D_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_Ip, D_Ul_Ip)
//============================================================================



static void Test_D_Ul_L()
{
  {
    init_simple_test("D_Ul_L");
    STRUCT_IF_C D_Ul_L lv;
    check2(sizeof(lv), 24, "sizeof(D_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_L)");
    check_field_offset(lv, v1, 0, "D_Ul_L.v1");
    check_field_offset(lv, v2, 8, "D_Ul_L.v2");
    check_field_offset(lv, v3, 16, "D_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_L, D_Ul_L)
//============================================================================



static void Test_D_Ul_S()
{
  {
    init_simple_test("D_Ul_S");
    STRUCT_IF_C D_Ul_S lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_S)");
    check_field_offset(lv, v1, 0, "D_Ul_S.v1");
    check_field_offset(lv, v2, 8, "D_Ul_S.v2");
    check_field_offset(lv, v3, 16, "D_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_S, D_Ul_S)
//============================================================================



static void Test_D_Ul_Uc()
{
  {
    init_simple_test("D_Ul_Uc");
    STRUCT_IF_C D_Ul_Uc lv;
    check2(sizeof(lv), 17, "sizeof(D_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_Uc)");
    check_field_offset(lv, v1, 0, "D_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Ul_Uc.v2");
    check_field_offset(lv, v3, 16, "D_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_Uc, D_Ul_Uc)
//============================================================================



static void Test_D_Ul_Ui()
{
  {
    init_simple_test("D_Ul_Ui");
    STRUCT_IF_C D_Ul_Ui lv;
    check2(sizeof(lv), 20, "sizeof(D_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_Ui)");
    check_field_offset(lv, v1, 0, "D_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Ul_Ui.v2");
    check_field_offset(lv, v3, 16, "D_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_Ui, D_Ul_Ui)
//============================================================================



static void Test_D_Ul_Ul()
{
  {
    init_simple_test("D_Ul_Ul");
    STRUCT_IF_C D_Ul_Ul lv;
    check2(sizeof(lv), 24, "sizeof(D_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_Ul)");
    check_field_offset(lv, v1, 0, "D_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Ul_Ul.v2");
    check_field_offset(lv, v3, 16, "D_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_Ul, D_Ul_Ul)
//============================================================================



static void Test_D_Ul_Us()
{
  {
    init_simple_test("D_Ul_Us");
    STRUCT_IF_C D_Ul_Us lv;
    check2(sizeof(lv), 18, "sizeof(D_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_Us)");
    check_field_offset(lv, v1, 0, "D_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "D_Ul_Us.v2");
    check_field_offset(lv, v3, 16, "D_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_Us, D_Ul_Us)
//============================================================================



static void Test_D_Ul_Vp()
{
  {
    init_simple_test("D_Ul_Vp");
    STRUCT_IF_C D_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Ul_Vp)");
    check_field_offset(lv, v1, 0, "D_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Ul_Vp.v2");
    check_field_offset(lv, v3, 16, "D_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Ul_Vp, D_Ul_Vp)
//============================================================================



static void Test_D_Us()
{
  {
    init_simple_test("D_Us");
    STRUCT_IF_C D_Us lv;
    check2(sizeof(lv), 10, "sizeof(D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us)");
    check_field_offset(lv, v1, 0, "D_Us.v1");
    check_field_offset(lv, v2, 8, "D_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us, D_Us)
//============================================================================



static void Test_D_Us_BFu15i()
{
  {
    init_simple_test("D_Us_BFu15i");
    static STRUCT_IF_C D_Us_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_Us_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu15i, D_Us_BFu15i)
//============================================================================



static void Test_D_Us_BFu15ll()
{
  {
    init_simple_test("D_Us_BFu15ll");
    static STRUCT_IF_C D_Us_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_Us_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu15ll, D_Us_BFu15ll)
//============================================================================



static void Test_D_Us_BFu15s()
{
  {
    init_simple_test("D_Us_BFu15s");
    static STRUCT_IF_C D_Us_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "D_Us_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_Us_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu15s, D_Us_BFu15s)
//============================================================================



static void Test_D_Us_BFu16i()
{
  {
    init_simple_test("D_Us_BFu16i");
    static STRUCT_IF_C D_Us_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_Us_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu16i, D_Us_BFu16i)
//============================================================================



static void Test_D_Us_BFu16ll()
{
  {
    init_simple_test("D_Us_BFu16ll");
    static STRUCT_IF_C D_Us_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_Us_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu16ll, D_Us_BFu16ll)
//============================================================================



static void Test_D_Us_BFu16s()
{
  {
    init_simple_test("D_Us_BFu16s");
    static STRUCT_IF_C D_Us_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "D_Us_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_Us_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu16s, D_Us_BFu16s)
//============================================================================



static void Test_D_Us_BFu17i()
{
  {
    init_simple_test("D_Us_BFu17i");
    static STRUCT_IF_C D_Us_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(D_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_Us_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu17i, D_Us_BFu17i)
//============================================================================



static void Test_D_Us_BFu17ll()
{
  {
    init_simple_test("D_Us_BFu17ll");
    static STRUCT_IF_C D_Us_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(D_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "D_Us_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "D_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu17ll, D_Us_BFu17ll)
//============================================================================



static void Test_D_Us_BFu1c()
{
  {
    init_simple_test("D_Us_BFu1c");
    static STRUCT_IF_C D_Us_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "D_Us_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu1c, D_Us_BFu1c)
//============================================================================



static void Test_D_Us_BFu1i()
{
  {
    init_simple_test("D_Us_BFu1i");
    static STRUCT_IF_C D_Us_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu1i, D_Us_BFu1i)
//============================================================================



static void Test_D_Us_BFu1ll()
{
  {
    init_simple_test("D_Us_BFu1ll");
    static STRUCT_IF_C D_Us_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu1ll, D_Us_BFu1ll)
//============================================================================



static void Test_D_Us_BFu1s()
{
  {
    init_simple_test("D_Us_BFu1s");
    static STRUCT_IF_C D_Us_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "D_Us_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "D_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu1s, D_Us_BFu1s)
//============================================================================



static void Test_D_Us_BFu31i()
{
  {
    init_simple_test("D_Us_BFu31i");
    static STRUCT_IF_C D_Us_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_Us_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu31i, D_Us_BFu31i)
//============================================================================



static void Test_D_Us_BFu31ll()
{
  {
    init_simple_test("D_Us_BFu31ll");
    static STRUCT_IF_C D_Us_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "D_Us_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "D_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu31ll, D_Us_BFu31ll)
//============================================================================



static void Test_D_Us_BFu32i()
{
  {
    init_simple_test("D_Us_BFu32i");
    static STRUCT_IF_C D_Us_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_Us_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu32i, D_Us_BFu32i)
//============================================================================



static void Test_D_Us_BFu32ll()
{
  {
    init_simple_test("D_Us_BFu32ll");
    static STRUCT_IF_C D_Us_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "D_Us_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "D_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu32ll, D_Us_BFu32ll)
//============================================================================



static void Test_D_Us_BFu33()
{
  {
    init_simple_test("D_Us_BFu33");
    static STRUCT_IF_C D_Us_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(D_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu33)");
    check_field_offset(lv, v1, 0, "D_Us_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "D_Us_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "D_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu33, D_Us_BFu33)
//============================================================================



static void Test_D_Us_BFu7c()
{
  {
    init_simple_test("D_Us_BFu7c");
    static STRUCT_IF_C D_Us_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "D_Us_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_Us_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu7c, D_Us_BFu7c)
//============================================================================



static void Test_D_Us_BFu7i()
{
  {
    init_simple_test("D_Us_BFu7i");
    static STRUCT_IF_C D_Us_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_Us_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu7i, D_Us_BFu7i)
//============================================================================



static void Test_D_Us_BFu7ll()
{
  {
    init_simple_test("D_Us_BFu7ll");
    static STRUCT_IF_C D_Us_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_Us_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu7ll, D_Us_BFu7ll)
//============================================================================



static void Test_D_Us_BFu7s()
{
  {
    init_simple_test("D_Us_BFu7s");
    static STRUCT_IF_C D_Us_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "D_Us_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "D_Us_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "D_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu7s, D_Us_BFu7s)
//============================================================================



static void Test_D_Us_BFu8c()
{
  {
    init_simple_test("D_Us_BFu8c");
    static STRUCT_IF_C D_Us_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "D_Us_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_Us_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu8c, D_Us_BFu8c)
//============================================================================



static void Test_D_Us_BFu8i()
{
  {
    init_simple_test("D_Us_BFu8i");
    static STRUCT_IF_C D_Us_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_Us_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu8i, D_Us_BFu8i)
//============================================================================



static void Test_D_Us_BFu8ll()
{
  {
    init_simple_test("D_Us_BFu8ll");
    static STRUCT_IF_C D_Us_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_Us_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu8ll, D_Us_BFu8ll)
//============================================================================



static void Test_D_Us_BFu8s()
{
  {
    init_simple_test("D_Us_BFu8s");
    static STRUCT_IF_C D_Us_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "D_Us_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "D_Us_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "D_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu8s, D_Us_BFu8s)
//============================================================================



static void Test_D_Us_BFu9i()
{
  {
    init_simple_test("D_Us_BFu9i");
    static STRUCT_IF_C D_Us_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "D_Us_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_Us_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu9i, D_Us_BFu9i)
//============================================================================



static void Test_D_Us_BFu9ll()
{
  {
    init_simple_test("D_Us_BFu9ll");
    static STRUCT_IF_C D_Us_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_Us_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu9ll, D_Us_BFu9ll)
//============================================================================



static void Test_D_Us_BFu9s()
{
  {
    init_simple_test("D_Us_BFu9s");
    static STRUCT_IF_C D_Us_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "D_Us_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_Us_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_BFu9s, D_Us_BFu9s)
//============================================================================



static void Test_D_Us_C()
{
  {
    init_simple_test("D_Us_C");
    STRUCT_IF_C D_Us_C lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_C)");
    check_field_offset(lv, v1, 0, "D_Us_C.v1");
    check_field_offset(lv, v2, 8, "D_Us_C.v2");
    check_field_offset(lv, v3, 10, "D_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_C, D_Us_C)
//============================================================================



static void Test_D_Us_D()
{
  {
    init_simple_test("D_Us_D");
    STRUCT_IF_C D_Us_D lv;
    check2(sizeof(lv), 18, "sizeof(D_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_D)");
    check_field_offset(lv, v1, 0, "D_Us_D.v1");
    check_field_offset(lv, v2, 8, "D_Us_D.v2");
    check_field_offset(lv, v3, 10, "D_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_D, D_Us_D)
//============================================================================



static void Test_D_Us_F()
{
  {
    init_simple_test("D_Us_F");
    STRUCT_IF_C D_Us_F lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_F)");
    check_field_offset(lv, v1, 0, "D_Us_F.v1");
    check_field_offset(lv, v2, 8, "D_Us_F.v2");
    check_field_offset(lv, v3, 10, "D_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_F, D_Us_F)
//============================================================================



static void Test_D_Us_I()
{
  {
    init_simple_test("D_Us_I");
    STRUCT_IF_C D_Us_I lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_I)");
    check_field_offset(lv, v1, 0, "D_Us_I.v1");
    check_field_offset(lv, v2, 8, "D_Us_I.v2");
    check_field_offset(lv, v3, 10, "D_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_I, D_Us_I)
//============================================================================



static void Test_D_Us_Ip()
{
  {
    init_simple_test("D_Us_Ip");
    STRUCT_IF_C D_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_Ip)");
    check_field_offset(lv, v1, 0, "D_Us_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Us_Ip.v2");
    check_field_offset(lv, v3, 10, "D_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_Ip, D_Us_Ip)
//============================================================================



static void Test_D_Us_L()
{
  {
    init_simple_test("D_Us_L");
    STRUCT_IF_C D_Us_L lv;
    check2(sizeof(lv), 18, "sizeof(D_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_L)");
    check_field_offset(lv, v1, 0, "D_Us_L.v1");
    check_field_offset(lv, v2, 8, "D_Us_L.v2");
    check_field_offset(lv, v3, 10, "D_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_L, D_Us_L)
//============================================================================



static void Test_D_Us_S()
{
  {
    init_simple_test("D_Us_S");
    STRUCT_IF_C D_Us_S lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_S)");
    check_field_offset(lv, v1, 0, "D_Us_S.v1");
    check_field_offset(lv, v2, 8, "D_Us_S.v2");
    check_field_offset(lv, v3, 10, "D_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_S, D_Us_S)
//============================================================================



static void Test_D_Us_Uc()
{
  {
    init_simple_test("D_Us_Uc");
    STRUCT_IF_C D_Us_Uc lv;
    check2(sizeof(lv), 11, "sizeof(D_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_Uc)");
    check_field_offset(lv, v1, 0, "D_Us_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Us_Uc.v2");
    check_field_offset(lv, v3, 10, "D_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_Uc, D_Us_Uc)
//============================================================================



static void Test_D_Us_Ui()
{
  {
    init_simple_test("D_Us_Ui");
    STRUCT_IF_C D_Us_Ui lv;
    check2(sizeof(lv), 14, "sizeof(D_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_Ui)");
    check_field_offset(lv, v1, 0, "D_Us_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Us_Ui.v2");
    check_field_offset(lv, v3, 10, "D_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_Ui, D_Us_Ui)
//============================================================================



static void Test_D_Us_Ul()
{
  {
    init_simple_test("D_Us_Ul");
    STRUCT_IF_C D_Us_Ul lv;
    check2(sizeof(lv), 18, "sizeof(D_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_Ul)");
    check_field_offset(lv, v1, 0, "D_Us_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Us_Ul.v2");
    check_field_offset(lv, v3, 10, "D_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_Ul, D_Us_Ul)
//============================================================================



static void Test_D_Us_Us()
{
  {
    init_simple_test("D_Us_Us");
    STRUCT_IF_C D_Us_Us lv;
    check2(sizeof(lv), 12, "sizeof(D_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_Us)");
    check_field_offset(lv, v1, 0, "D_Us_Us.v1");
    check_field_offset(lv, v2, 8, "D_Us_Us.v2");
    check_field_offset(lv, v3, 10, "D_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_Us, D_Us_Us)
//============================================================================



static void Test_D_Us_Vp()
{
  {
    init_simple_test("D_Us_Vp");
    STRUCT_IF_C D_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Us_Vp)");
    check_field_offset(lv, v1, 0, "D_Us_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Us_Vp.v2");
    check_field_offset(lv, v3, 10, "D_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Us_Vp, D_Us_Vp)
//============================================================================



static void Test_D_Vp()
{
  {
    init_simple_test("D_Vp");
    STRUCT_IF_C D_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp)");
    check_field_offset(lv, v1, 0, "D_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp, D_Vp)
//============================================================================



static void Test_D_Vp_BFu15i()
{
  {
    init_simple_test("D_Vp_BFu15i");
    static STRUCT_IF_C D_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "D_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "D_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu15i, D_Vp_BFu15i)
//============================================================================



static void Test_D_Vp_BFu15ll()
{
  {
    init_simple_test("D_Vp_BFu15ll");
    static STRUCT_IF_C D_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "D_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "D_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu15ll, D_Vp_BFu15ll)
//============================================================================



static void Test_D_Vp_BFu15s()
{
  {
    init_simple_test("D_Vp_BFu15s");
    static STRUCT_IF_C D_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "D_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "D_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu15s, D_Vp_BFu15s)
//============================================================================



static void Test_D_Vp_BFu16i()
{
  {
    init_simple_test("D_Vp_BFu16i");
    static STRUCT_IF_C D_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "D_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "D_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu16i, D_Vp_BFu16i)
//============================================================================



static void Test_D_Vp_BFu16ll()
{
  {
    init_simple_test("D_Vp_BFu16ll");
    static STRUCT_IF_C D_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "D_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "D_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu16ll, D_Vp_BFu16ll)
//============================================================================



static void Test_D_Vp_BFu16s()
{
  {
    init_simple_test("D_Vp_BFu16s");
    static STRUCT_IF_C D_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "D_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "D_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu16s, D_Vp_BFu16s)
//============================================================================



static void Test_D_Vp_BFu17i()
{
  {
    init_simple_test("D_Vp_BFu17i");
    static STRUCT_IF_C D_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(D_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "D_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "D_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu17i, D_Vp_BFu17i)
//============================================================================



static void Test_D_Vp_BFu17ll()
{
  {
    init_simple_test("D_Vp_BFu17ll");
    static STRUCT_IF_C D_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(D_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "D_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "D_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu17ll, D_Vp_BFu17ll)
//============================================================================



static void Test_D_Vp_BFu1c()
{
  {
    init_simple_test("D_Vp_BFu1c");
    static STRUCT_IF_C D_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu1c, D_Vp_BFu1c)
//============================================================================



static void Test_D_Vp_BFu1i()
{
  {
    init_simple_test("D_Vp_BFu1i");
    static STRUCT_IF_C D_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu1i, D_Vp_BFu1i)
//============================================================================



static void Test_D_Vp_BFu1ll()
{
  {
    init_simple_test("D_Vp_BFu1ll");
    static STRUCT_IF_C D_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu1ll, D_Vp_BFu1ll)
//============================================================================



static void Test_D_Vp_BFu1s()
{
  {
    init_simple_test("D_Vp_BFu1s");
    static STRUCT_IF_C D_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "D_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu1s, D_Vp_BFu1s)
//============================================================================



static void Test_D_Vp_BFu31i()
{
  {
    init_simple_test("D_Vp_BFu31i");
    static STRUCT_IF_C D_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "D_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "D_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu31i, D_Vp_BFu31i)
//============================================================================



static void Test_D_Vp_BFu31ll()
{
  {
    init_simple_test("D_Vp_BFu31ll");
    static STRUCT_IF_C D_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "D_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "D_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu31ll, D_Vp_BFu31ll)
//============================================================================



static void Test_D_Vp_BFu32i()
{
  {
    init_simple_test("D_Vp_BFu32i");
    static STRUCT_IF_C D_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "D_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "D_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu32i, D_Vp_BFu32i)
//============================================================================



static void Test_D_Vp_BFu32ll()
{
  {
    init_simple_test("D_Vp_BFu32ll");
    static STRUCT_IF_C D_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "D_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "D_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu32ll, D_Vp_BFu32ll)
//============================================================================



static void Test_D_Vp_BFu33()
{
  {
    init_simple_test("D_Vp_BFu33");
    static STRUCT_IF_C D_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(D_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "D_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "D_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu33, D_Vp_BFu33)
//============================================================================



static void Test_D_Vp_BFu7c()
{
  {
    init_simple_test("D_Vp_BFu7c");
    static STRUCT_IF_C D_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu7c, D_Vp_BFu7c)
//============================================================================



static void Test_D_Vp_BFu7i()
{
  {
    init_simple_test("D_Vp_BFu7i");
    static STRUCT_IF_C D_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu7i, D_Vp_BFu7i)
//============================================================================



static void Test_D_Vp_BFu7ll()
{
  {
    init_simple_test("D_Vp_BFu7ll");
    static STRUCT_IF_C D_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu7ll, D_Vp_BFu7ll)
//============================================================================



static void Test_D_Vp_BFu7s()
{
  {
    init_simple_test("D_Vp_BFu7s");
    static STRUCT_IF_C D_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "D_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "D_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu7s, D_Vp_BFu7s)
//============================================================================



static void Test_D_Vp_BFu8c()
{
  {
    init_simple_test("D_Vp_BFu8c");
    static STRUCT_IF_C D_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu8c, D_Vp_BFu8c)
//============================================================================



static void Test_D_Vp_BFu8i()
{
  {
    init_simple_test("D_Vp_BFu8i");
    static STRUCT_IF_C D_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu8i, D_Vp_BFu8i)
//============================================================================



static void Test_D_Vp_BFu8ll()
{
  {
    init_simple_test("D_Vp_BFu8ll");
    static STRUCT_IF_C D_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu8ll, D_Vp_BFu8ll)
//============================================================================



static void Test_D_Vp_BFu8s()
{
  {
    init_simple_test("D_Vp_BFu8s");
    static STRUCT_IF_C D_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "D_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "D_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu8s, D_Vp_BFu8s)
//============================================================================



static void Test_D_Vp_BFu9i()
{
  {
    init_simple_test("D_Vp_BFu9i");
    static STRUCT_IF_C D_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "D_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "D_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu9i, D_Vp_BFu9i)
//============================================================================



static void Test_D_Vp_BFu9ll()
{
  {
    init_simple_test("D_Vp_BFu9ll");
    static STRUCT_IF_C D_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "D_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "D_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu9ll, D_Vp_BFu9ll)
//============================================================================



static void Test_D_Vp_BFu9s()
{
  {
    init_simple_test("D_Vp_BFu9s");
    static STRUCT_IF_C D_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "D_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "D_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "D_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_BFu9s, D_Vp_BFu9s)
//============================================================================



static void Test_D_Vp_C()
{
  {
    init_simple_test("D_Vp_C");
    STRUCT_IF_C D_Vp_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_C)");
    check_field_offset(lv, v1, 0, "D_Vp_C.v1");
    check_field_offset(lv, v2, 8, "D_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_C, D_Vp_C)
//============================================================================



static void Test_D_Vp_D()
{
  {
    init_simple_test("D_Vp_D");
    STRUCT_IF_C D_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_D)");
    check_field_offset(lv, v1, 0, "D_Vp_D.v1");
    check_field_offset(lv, v2, 8, "D_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_D, D_Vp_D)
//============================================================================



static void Test_D_Vp_F()
{
  {
    init_simple_test("D_Vp_F");
    STRUCT_IF_C D_Vp_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_F)");
    check_field_offset(lv, v1, 0, "D_Vp_F.v1");
    check_field_offset(lv, v2, 8, "D_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_F, D_Vp_F)
//============================================================================



static void Test_D_Vp_I()
{
  {
    init_simple_test("D_Vp_I");
    STRUCT_IF_C D_Vp_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_I)");
    check_field_offset(lv, v1, 0, "D_Vp_I.v1");
    check_field_offset(lv, v2, 8, "D_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_I, D_Vp_I)
//============================================================================



static void Test_D_Vp_Ip()
{
  {
    init_simple_test("D_Vp_Ip");
    STRUCT_IF_C D_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_Ip)");
    check_field_offset(lv, v1, 0, "D_Vp_Ip.v1");
    check_field_offset(lv, v2, 8, "D_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_Ip, D_Vp_Ip)
//============================================================================



static void Test_D_Vp_L()
{
  {
    init_simple_test("D_Vp_L");
    STRUCT_IF_C D_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_L)");
    check_field_offset(lv, v1, 0, "D_Vp_L.v1");
    check_field_offset(lv, v2, 8, "D_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_L, D_Vp_L)
//============================================================================



static void Test_D_Vp_S()
{
  {
    init_simple_test("D_Vp_S");
    STRUCT_IF_C D_Vp_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_S)");
    check_field_offset(lv, v1, 0, "D_Vp_S.v1");
    check_field_offset(lv, v2, 8, "D_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_S, D_Vp_S)
//============================================================================



static void Test_D_Vp_Uc()
{
  {
    init_simple_test("D_Vp_Uc");
    STRUCT_IF_C D_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(D_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_Uc)");
    check_field_offset(lv, v1, 0, "D_Vp_Uc.v1");
    check_field_offset(lv, v2, 8, "D_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_Uc, D_Vp_Uc)
//============================================================================



static void Test_D_Vp_Ui()
{
  {
    init_simple_test("D_Vp_Ui");
    STRUCT_IF_C D_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(D_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_Ui)");
    check_field_offset(lv, v1, 0, "D_Vp_Ui.v1");
    check_field_offset(lv, v2, 8, "D_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_Ui, D_Vp_Ui)
//============================================================================



static void Test_D_Vp_Ul()
{
  {
    init_simple_test("D_Vp_Ul");
    STRUCT_IF_C D_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_Ul)");
    check_field_offset(lv, v1, 0, "D_Vp_Ul.v1");
    check_field_offset(lv, v2, 8, "D_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_Ul, D_Vp_Ul)
//============================================================================



static void Test_D_Vp_Us()
{
  {
    init_simple_test("D_Vp_Us");
    STRUCT_IF_C D_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(D_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_Us)");
    check_field_offset(lv, v1, 0, "D_Vp_Us.v1");
    check_field_offset(lv, v2, 8, "D_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_Us, D_Vp_Us)
//============================================================================



static void Test_D_Vp_Vp()
{
  {
    init_simple_test("D_Vp_Vp");
    STRUCT_IF_C D_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(D_Vp_Vp)");
    check_field_offset(lv, v1, 0, "D_Vp_Vp.v1");
    check_field_offset(lv, v2, 8, "D_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_D_Vp_Vp, D_Vp_Vp)
//============================================================================



static void Test_F()
{
  {
    init_simple_test("F");
    STRUCT_IF_C F lv;
    check2(sizeof(lv), 4, "sizeof(F)");
    check2(__alignof__(lv), 1, "__alignof__(F)");
    check_field_offset(lv, v1, 0, "F.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_F, F)
//============================================================================



static void Test_F_BFu15i()
{
  {
    init_simple_test("F_BFu15i");
    static STRUCT_IF_C F_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i, F_BFu15i)
//============================================================================



static void Test_F_BFu15i_BFu15i()
{
  {
    init_simple_test("F_BFu15i_BFu15i");
    static STRUCT_IF_C F_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu15i, F_BFu15i_BFu15i)
//============================================================================



static void Test_F_BFu15i_BFu15ll()
{
  {
    init_simple_test("F_BFu15i_BFu15ll");
    static STRUCT_IF_C F_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu15ll, F_BFu15i_BFu15ll)
//============================================================================



static void Test_F_BFu15i_BFu15s()
{
  {
    init_simple_test("F_BFu15i_BFu15s");
    static STRUCT_IF_C F_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu15s, F_BFu15i_BFu15s)
//============================================================================



static void Test_F_BFu15i_BFu16i()
{
  {
    init_simple_test("F_BFu15i_BFu16i");
    static STRUCT_IF_C F_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu16i, F_BFu15i_BFu16i)
//============================================================================



static void Test_F_BFu15i_BFu16ll()
{
  {
    init_simple_test("F_BFu15i_BFu16ll");
    static STRUCT_IF_C F_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu16ll, F_BFu15i_BFu16ll)
//============================================================================



static void Test_F_BFu15i_BFu16s()
{
  {
    init_simple_test("F_BFu15i_BFu16s");
    static STRUCT_IF_C F_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu16s, F_BFu15i_BFu16s)
//============================================================================



static void Test_F_BFu15i_BFu17i()
{
  {
    init_simple_test("F_BFu15i_BFu17i");
    static STRUCT_IF_C F_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "F_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "F_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu17i, F_BFu15i_BFu17i)
//============================================================================



static void Test_F_BFu15i_BFu17ll()
{
  {
    init_simple_test("F_BFu15i_BFu17ll");
    static STRUCT_IF_C F_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "F_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "F_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu17ll, F_BFu15i_BFu17ll)
//============================================================================



static void Test_F_BFu15i_BFu1c()
{
  {
    init_simple_test("F_BFu15i_BFu1c");
    static STRUCT_IF_C F_BFu15i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu1c, F_BFu15i_BFu1c)
//============================================================================



static void Test_F_BFu15i_BFu1i()
{
  {
    init_simple_test("F_BFu15i_BFu1i");
    static STRUCT_IF_C F_BFu15i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu1i, F_BFu15i_BFu1i)
//============================================================================



static void Test_F_BFu15i_BFu1ll()
{
  {
    init_simple_test("F_BFu15i_BFu1ll");
    static STRUCT_IF_C F_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu1ll, F_BFu15i_BFu1ll)
//============================================================================



static void Test_F_BFu15i_BFu1s()
{
  {
    init_simple_test("F_BFu15i_BFu1s");
    static STRUCT_IF_C F_BFu15i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu1s, F_BFu15i_BFu1s)
//============================================================================



static void Test_F_BFu15i_BFu31i()
{
  {
    init_simple_test("F_BFu15i_BFu31i");
    static STRUCT_IF_C F_BFu15i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "F_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "F_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu31i, F_BFu15i_BFu31i)
//============================================================================



static void Test_F_BFu15i_BFu31ll()
{
  {
    init_simple_test("F_BFu15i_BFu31ll");
    static STRUCT_IF_C F_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "F_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "F_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu31ll, F_BFu15i_BFu31ll)
//============================================================================



static void Test_F_BFu15i_BFu32i()
{
  {
    init_simple_test("F_BFu15i_BFu32i");
    static STRUCT_IF_C F_BFu15i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "F_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "F_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu32i, F_BFu15i_BFu32i)
//============================================================================



static void Test_F_BFu15i_BFu32ll()
{
  {
    init_simple_test("F_BFu15i_BFu32ll");
    static STRUCT_IF_C F_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "F_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "F_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu32ll, F_BFu15i_BFu32ll)
//============================================================================



static void Test_F_BFu15i_BFu33()
{
  {
    init_simple_test("F_BFu15i_BFu33");
    static STRUCT_IF_C F_BFu15i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "F_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "F_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu33, F_BFu15i_BFu33)
//============================================================================



static void Test_F_BFu15i_BFu7c()
{
  {
    init_simple_test("F_BFu15i_BFu7c");
    static STRUCT_IF_C F_BFu15i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu7c, F_BFu15i_BFu7c)
//============================================================================



static void Test_F_BFu15i_BFu7i()
{
  {
    init_simple_test("F_BFu15i_BFu7i");
    static STRUCT_IF_C F_BFu15i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu7i, F_BFu15i_BFu7i)
//============================================================================



static void Test_F_BFu15i_BFu7ll()
{
  {
    init_simple_test("F_BFu15i_BFu7ll");
    static STRUCT_IF_C F_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu7ll, F_BFu15i_BFu7ll)
//============================================================================



static void Test_F_BFu15i_BFu7s()
{
  {
    init_simple_test("F_BFu15i_BFu7s");
    static STRUCT_IF_C F_BFu15i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu7s, F_BFu15i_BFu7s)
//============================================================================



static void Test_F_BFu15i_BFu8c()
{
  {
    init_simple_test("F_BFu15i_BFu8c");
    static STRUCT_IF_C F_BFu15i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu8c, F_BFu15i_BFu8c)
//============================================================================



static void Test_F_BFu15i_BFu8i()
{
  {
    init_simple_test("F_BFu15i_BFu8i");
    static STRUCT_IF_C F_BFu15i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu8i, F_BFu15i_BFu8i)
//============================================================================



static void Test_F_BFu15i_BFu8ll()
{
  {
    init_simple_test("F_BFu15i_BFu8ll");
    static STRUCT_IF_C F_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu8ll, F_BFu15i_BFu8ll)
//============================================================================



static void Test_F_BFu15i_BFu8s()
{
  {
    init_simple_test("F_BFu15i_BFu8s");
    static STRUCT_IF_C F_BFu15i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu8s, F_BFu15i_BFu8s)
//============================================================================



static void Test_F_BFu15i_BFu9i()
{
  {
    init_simple_test("F_BFu15i_BFu9i");
    static STRUCT_IF_C F_BFu15i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu9i, F_BFu15i_BFu9i)
//============================================================================



static void Test_F_BFu15i_BFu9ll()
{
  {
    init_simple_test("F_BFu15i_BFu9ll");
    static STRUCT_IF_C F_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu9ll, F_BFu15i_BFu9ll)
//============================================================================



static void Test_F_BFu15i_BFu9s()
{
  {
    init_simple_test("F_BFu15i_BFu9s");
    static STRUCT_IF_C F_BFu15i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_BFu9s, F_BFu15i_BFu9s)
//============================================================================



static void Test_F_BFu15i_C()
{
  {
    init_simple_test("F_BFu15i_C");
    static STRUCT_IF_C F_BFu15i_C lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_C)");
    check_field_offset(lv, v1, 0, "F_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_C");
    check_field_offset(lv, v3, 6, "F_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_C, F_BFu15i_C)
//============================================================================



static void Test_F_BFu15i_D()
{
  {
    init_simple_test("F_BFu15i_D");
    static STRUCT_IF_C F_BFu15i_D lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_D)");
    check_field_offset(lv, v1, 0, "F_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_D");
    check_field_offset(lv, v3, 6, "F_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_D, F_BFu15i_D)
//============================================================================



static void Test_F_BFu15i_F()
{
  {
    init_simple_test("F_BFu15i_F");
    static STRUCT_IF_C F_BFu15i_F lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_F)");
    check_field_offset(lv, v1, 0, "F_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_F");
    check_field_offset(lv, v3, 6, "F_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_F, F_BFu15i_F)
//============================================================================



static void Test_F_BFu15i_I()
{
  {
    init_simple_test("F_BFu15i_I");
    static STRUCT_IF_C F_BFu15i_I lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_I)");
    check_field_offset(lv, v1, 0, "F_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_I");
    check_field_offset(lv, v3, 6, "F_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_I, F_BFu15i_I)
//============================================================================



static void Test_F_BFu15i_Ip()
{
  {
    init_simple_test("F_BFu15i_Ip");
    static STRUCT_IF_C F_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_Ip");
    check_field_offset(lv, v3, 6, "F_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_Ip, F_BFu15i_Ip)
//============================================================================



static void Test_F_BFu15i_L()
{
  {
    init_simple_test("F_BFu15i_L");
    static STRUCT_IF_C F_BFu15i_L lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_L)");
    check_field_offset(lv, v1, 0, "F_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_L");
    check_field_offset(lv, v3, 6, "F_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_L, F_BFu15i_L)
//============================================================================



static void Test_F_BFu15i_S()
{
  {
    init_simple_test("F_BFu15i_S");
    static STRUCT_IF_C F_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_S)");
    check_field_offset(lv, v1, 0, "F_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_S");
    check_field_offset(lv, v3, 6, "F_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_S, F_BFu15i_S)
//============================================================================



static void Test_F_BFu15i_Uc()
{
  {
    init_simple_test("F_BFu15i_Uc");
    static STRUCT_IF_C F_BFu15i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_Uc");
    check_field_offset(lv, v3, 6, "F_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_Uc, F_BFu15i_Uc)
//============================================================================



static void Test_F_BFu15i_Ui()
{
  {
    init_simple_test("F_BFu15i_Ui");
    static STRUCT_IF_C F_BFu15i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_Ui");
    check_field_offset(lv, v3, 6, "F_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_Ui, F_BFu15i_Ui)
//============================================================================



static void Test_F_BFu15i_Ul()
{
  {
    init_simple_test("F_BFu15i_Ul");
    static STRUCT_IF_C F_BFu15i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_Ul");
    check_field_offset(lv, v3, 6, "F_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_Ul, F_BFu15i_Ul)
//============================================================================



static void Test_F_BFu15i_Us()
{
  {
    init_simple_test("F_BFu15i_Us");
    static STRUCT_IF_C F_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_Us");
    check_field_offset(lv, v3, 6, "F_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_Us, F_BFu15i_Us)
//============================================================================



static void Test_F_BFu15i_Vp()
{
  {
    init_simple_test("F_BFu15i_Vp");
    static STRUCT_IF_C F_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15i_Vp");
    check_field_offset(lv, v3, 6, "F_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15i_Vp, F_BFu15i_Vp)
//============================================================================



static void Test_F_BFu15ll()
{
  {
    init_simple_test("F_BFu15ll");
    static STRUCT_IF_C F_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll, F_BFu15ll)
//============================================================================



static void Test_F_BFu15ll_BFu15i()
{
  {
    init_simple_test("F_BFu15ll_BFu15i");
    static STRUCT_IF_C F_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu15i, F_BFu15ll_BFu15i)
//============================================================================



static void Test_F_BFu15ll_BFu15ll()
{
  {
    init_simple_test("F_BFu15ll_BFu15ll");
    static STRUCT_IF_C F_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu15ll, F_BFu15ll_BFu15ll)
//============================================================================



static void Test_F_BFu15ll_BFu15s()
{
  {
    init_simple_test("F_BFu15ll_BFu15s");
    static STRUCT_IF_C F_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu15s, F_BFu15ll_BFu15s)
//============================================================================



static void Test_F_BFu15ll_BFu16i()
{
  {
    init_simple_test("F_BFu15ll_BFu16i");
    static STRUCT_IF_C F_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu16i, F_BFu15ll_BFu16i)
//============================================================================



static void Test_F_BFu15ll_BFu16ll()
{
  {
    init_simple_test("F_BFu15ll_BFu16ll");
    static STRUCT_IF_C F_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu16ll, F_BFu15ll_BFu16ll)
//============================================================================



static void Test_F_BFu15ll_BFu16s()
{
  {
    init_simple_test("F_BFu15ll_BFu16s");
    static STRUCT_IF_C F_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu16s, F_BFu15ll_BFu16s)
//============================================================================



static void Test_F_BFu15ll_BFu17i()
{
  {
    init_simple_test("F_BFu15ll_BFu17i");
    static STRUCT_IF_C F_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "F_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "F_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu17i, F_BFu15ll_BFu17i)
//============================================================================



static void Test_F_BFu15ll_BFu17ll()
{
  {
    init_simple_test("F_BFu15ll_BFu17ll");
    static STRUCT_IF_C F_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "F_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "F_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu17ll, F_BFu15ll_BFu17ll)
//============================================================================



static void Test_F_BFu15ll_BFu1c()
{
  {
    init_simple_test("F_BFu15ll_BFu1c");
    static STRUCT_IF_C F_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu1c, F_BFu15ll_BFu1c)
//============================================================================



static void Test_F_BFu15ll_BFu1i()
{
  {
    init_simple_test("F_BFu15ll_BFu1i");
    static STRUCT_IF_C F_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu1i, F_BFu15ll_BFu1i)
//============================================================================



static void Test_F_BFu15ll_BFu1ll()
{
  {
    init_simple_test("F_BFu15ll_BFu1ll");
    static STRUCT_IF_C F_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu1ll, F_BFu15ll_BFu1ll)
//============================================================================



static void Test_F_BFu15ll_BFu1s()
{
  {
    init_simple_test("F_BFu15ll_BFu1s");
    static STRUCT_IF_C F_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu1s, F_BFu15ll_BFu1s)
//============================================================================



static void Test_F_BFu15ll_BFu31i()
{
  {
    init_simple_test("F_BFu15ll_BFu31i");
    static STRUCT_IF_C F_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "F_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "F_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu31i, F_BFu15ll_BFu31i)
//============================================================================



static void Test_F_BFu15ll_BFu31ll()
{
  {
    init_simple_test("F_BFu15ll_BFu31ll");
    static STRUCT_IF_C F_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "F_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "F_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu31ll, F_BFu15ll_BFu31ll)
//============================================================================



static void Test_F_BFu15ll_BFu32i()
{
  {
    init_simple_test("F_BFu15ll_BFu32i");
    static STRUCT_IF_C F_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "F_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "F_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu32i, F_BFu15ll_BFu32i)
//============================================================================



static void Test_F_BFu15ll_BFu32ll()
{
  {
    init_simple_test("F_BFu15ll_BFu32ll");
    static STRUCT_IF_C F_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "F_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "F_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu32ll, F_BFu15ll_BFu32ll)
//============================================================================



static void Test_F_BFu15ll_BFu33()
{
  {
    init_simple_test("F_BFu15ll_BFu33");
    static STRUCT_IF_C F_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "F_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "F_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu33, F_BFu15ll_BFu33)
//============================================================================



static void Test_F_BFu15ll_BFu7c()
{
  {
    init_simple_test("F_BFu15ll_BFu7c");
    static STRUCT_IF_C F_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu7c, F_BFu15ll_BFu7c)
//============================================================================



static void Test_F_BFu15ll_BFu7i()
{
  {
    init_simple_test("F_BFu15ll_BFu7i");
    static STRUCT_IF_C F_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu7i, F_BFu15ll_BFu7i)
//============================================================================



static void Test_F_BFu15ll_BFu7ll()
{
  {
    init_simple_test("F_BFu15ll_BFu7ll");
    static STRUCT_IF_C F_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu7ll, F_BFu15ll_BFu7ll)
//============================================================================



static void Test_F_BFu15ll_BFu7s()
{
  {
    init_simple_test("F_BFu15ll_BFu7s");
    static STRUCT_IF_C F_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu7s, F_BFu15ll_BFu7s)
//============================================================================



static void Test_F_BFu15ll_BFu8c()
{
  {
    init_simple_test("F_BFu15ll_BFu8c");
    static STRUCT_IF_C F_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu8c, F_BFu15ll_BFu8c)
//============================================================================



static void Test_F_BFu15ll_BFu8i()
{
  {
    init_simple_test("F_BFu15ll_BFu8i");
    static STRUCT_IF_C F_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu8i, F_BFu15ll_BFu8i)
//============================================================================



static void Test_F_BFu15ll_BFu8ll()
{
  {
    init_simple_test("F_BFu15ll_BFu8ll");
    static STRUCT_IF_C F_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu8ll, F_BFu15ll_BFu8ll)
//============================================================================



static void Test_F_BFu15ll_BFu8s()
{
  {
    init_simple_test("F_BFu15ll_BFu8s");
    static STRUCT_IF_C F_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu8s, F_BFu15ll_BFu8s)
//============================================================================



static void Test_F_BFu15ll_BFu9i()
{
  {
    init_simple_test("F_BFu15ll_BFu9i");
    static STRUCT_IF_C F_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu9i, F_BFu15ll_BFu9i)
//============================================================================



static void Test_F_BFu15ll_BFu9ll()
{
  {
    init_simple_test("F_BFu15ll_BFu9ll");
    static STRUCT_IF_C F_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu9ll, F_BFu15ll_BFu9ll)
//============================================================================



static void Test_F_BFu15ll_BFu9s()
{
  {
    init_simple_test("F_BFu15ll_BFu9s");
    static STRUCT_IF_C F_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_BFu9s, F_BFu15ll_BFu9s)
//============================================================================



static void Test_F_BFu15ll_C()
{
  {
    init_simple_test("F_BFu15ll_C");
    static STRUCT_IF_C F_BFu15ll_C lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_C");
    check_field_offset(lv, v3, 6, "F_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_C, F_BFu15ll_C)
//============================================================================



static void Test_F_BFu15ll_D()
{
  {
    init_simple_test("F_BFu15ll_D");
    static STRUCT_IF_C F_BFu15ll_D lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_D");
    check_field_offset(lv, v3, 6, "F_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_D, F_BFu15ll_D)
//============================================================================



static void Test_F_BFu15ll_F()
{
  {
    init_simple_test("F_BFu15ll_F");
    static STRUCT_IF_C F_BFu15ll_F lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_F");
    check_field_offset(lv, v3, 6, "F_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_F, F_BFu15ll_F)
//============================================================================



static void Test_F_BFu15ll_I()
{
  {
    init_simple_test("F_BFu15ll_I");
    static STRUCT_IF_C F_BFu15ll_I lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_I");
    check_field_offset(lv, v3, 6, "F_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_I, F_BFu15ll_I)
//============================================================================



static void Test_F_BFu15ll_Ip()
{
  {
    init_simple_test("F_BFu15ll_Ip");
    static STRUCT_IF_C F_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_Ip");
    check_field_offset(lv, v3, 6, "F_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_Ip, F_BFu15ll_Ip)
//============================================================================



static void Test_F_BFu15ll_L()
{
  {
    init_simple_test("F_BFu15ll_L");
    static STRUCT_IF_C F_BFu15ll_L lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_L");
    check_field_offset(lv, v3, 6, "F_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_L, F_BFu15ll_L)
//============================================================================



static void Test_F_BFu15ll_S()
{
  {
    init_simple_test("F_BFu15ll_S");
    static STRUCT_IF_C F_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_S");
    check_field_offset(lv, v3, 6, "F_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_S, F_BFu15ll_S)
//============================================================================



static void Test_F_BFu15ll_Uc()
{
  {
    init_simple_test("F_BFu15ll_Uc");
    static STRUCT_IF_C F_BFu15ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_Uc");
    check_field_offset(lv, v3, 6, "F_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_Uc, F_BFu15ll_Uc)
//============================================================================



static void Test_F_BFu15ll_Ui()
{
  {
    init_simple_test("F_BFu15ll_Ui");
    static STRUCT_IF_C F_BFu15ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_Ui");
    check_field_offset(lv, v3, 6, "F_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_Ui, F_BFu15ll_Ui)
//============================================================================



static void Test_F_BFu15ll_Ul()
{
  {
    init_simple_test("F_BFu15ll_Ul");
    static STRUCT_IF_C F_BFu15ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_Ul");
    check_field_offset(lv, v3, 6, "F_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_Ul, F_BFu15ll_Ul)
//============================================================================



static void Test_F_BFu15ll_Us()
{
  {
    init_simple_test("F_BFu15ll_Us");
    static STRUCT_IF_C F_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_Us");
    check_field_offset(lv, v3, 6, "F_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_Us, F_BFu15ll_Us)
//============================================================================



static void Test_F_BFu15ll_Vp()
{
  {
    init_simple_test("F_BFu15ll_Vp");
    static STRUCT_IF_C F_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15ll_Vp");
    check_field_offset(lv, v3, 6, "F_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15ll_Vp, F_BFu15ll_Vp)
//============================================================================



static void Test_F_BFu15s()
{
  {
    init_simple_test("F_BFu15s");
    static STRUCT_IF_C F_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s, F_BFu15s)
//============================================================================



static void Test_F_BFu15s_BFu15i()
{
  {
    init_simple_test("F_BFu15s_BFu15i");
    static STRUCT_IF_C F_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu15i, F_BFu15s_BFu15i)
//============================================================================



static void Test_F_BFu15s_BFu15ll()
{
  {
    init_simple_test("F_BFu15s_BFu15ll");
    static STRUCT_IF_C F_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu15ll, F_BFu15s_BFu15ll)
//============================================================================



static void Test_F_BFu15s_BFu15s()
{
  {
    init_simple_test("F_BFu15s_BFu15s");
    static STRUCT_IF_C F_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "F_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "F_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu15s, F_BFu15s_BFu15s)
//============================================================================



static void Test_F_BFu15s_BFu16i()
{
  {
    init_simple_test("F_BFu15s_BFu16i");
    static STRUCT_IF_C F_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu16i, F_BFu15s_BFu16i)
//============================================================================



static void Test_F_BFu15s_BFu16ll()
{
  {
    init_simple_test("F_BFu15s_BFu16ll");
    static STRUCT_IF_C F_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu16ll, F_BFu15s_BFu16ll)
//============================================================================



static void Test_F_BFu15s_BFu16s()
{
  {
    init_simple_test("F_BFu15s_BFu16s");
    static STRUCT_IF_C F_BFu15s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "F_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "F_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu16s, F_BFu15s_BFu16s)
//============================================================================



static void Test_F_BFu15s_BFu17i()
{
  {
    init_simple_test("F_BFu15s_BFu17i");
    static STRUCT_IF_C F_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "F_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "F_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu17i, F_BFu15s_BFu17i)
//============================================================================



static void Test_F_BFu15s_BFu17ll()
{
  {
    init_simple_test("F_BFu15s_BFu17ll");
    static STRUCT_IF_C F_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "F_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "F_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu17ll, F_BFu15s_BFu17ll)
//============================================================================



static void Test_F_BFu15s_BFu1c()
{
  {
    init_simple_test("F_BFu15s_BFu1c");
    static STRUCT_IF_C F_BFu15s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu1c, F_BFu15s_BFu1c)
//============================================================================



static void Test_F_BFu15s_BFu1i()
{
  {
    init_simple_test("F_BFu15s_BFu1i");
    static STRUCT_IF_C F_BFu15s_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu1i, F_BFu15s_BFu1i)
//============================================================================



static void Test_F_BFu15s_BFu1ll()
{
  {
    init_simple_test("F_BFu15s_BFu1ll");
    static STRUCT_IF_C F_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu1ll, F_BFu15s_BFu1ll)
//============================================================================



static void Test_F_BFu15s_BFu1s()
{
  {
    init_simple_test("F_BFu15s_BFu1s");
    static STRUCT_IF_C F_BFu15s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "F_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu1s, F_BFu15s_BFu1s)
//============================================================================



static void Test_F_BFu15s_BFu31i()
{
  {
    init_simple_test("F_BFu15s_BFu31i");
    static STRUCT_IF_C F_BFu15s_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "F_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "F_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu31i, F_BFu15s_BFu31i)
//============================================================================



static void Test_F_BFu15s_BFu31ll()
{
  {
    init_simple_test("F_BFu15s_BFu31ll");
    static STRUCT_IF_C F_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "F_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "F_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu31ll, F_BFu15s_BFu31ll)
//============================================================================



static void Test_F_BFu15s_BFu32i()
{
  {
    init_simple_test("F_BFu15s_BFu32i");
    static STRUCT_IF_C F_BFu15s_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "F_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "F_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu32i, F_BFu15s_BFu32i)
//============================================================================



static void Test_F_BFu15s_BFu32ll()
{
  {
    init_simple_test("F_BFu15s_BFu32ll");
    static STRUCT_IF_C F_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "F_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "F_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu32ll, F_BFu15s_BFu32ll)
//============================================================================



static void Test_F_BFu15s_BFu33()
{
  {
    init_simple_test("F_BFu15s_BFu33");
    static STRUCT_IF_C F_BFu15s_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "F_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "F_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu33, F_BFu15s_BFu33)
//============================================================================



static void Test_F_BFu15s_BFu7c()
{
  {
    init_simple_test("F_BFu15s_BFu7c");
    static STRUCT_IF_C F_BFu15s_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu7c, F_BFu15s_BFu7c)
//============================================================================



static void Test_F_BFu15s_BFu7i()
{
  {
    init_simple_test("F_BFu15s_BFu7i");
    static STRUCT_IF_C F_BFu15s_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu7i, F_BFu15s_BFu7i)
//============================================================================



static void Test_F_BFu15s_BFu7ll()
{
  {
    init_simple_test("F_BFu15s_BFu7ll");
    static STRUCT_IF_C F_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu7ll, F_BFu15s_BFu7ll)
//============================================================================



static void Test_F_BFu15s_BFu7s()
{
  {
    init_simple_test("F_BFu15s_BFu7s");
    static STRUCT_IF_C F_BFu15s_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "F_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "F_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu7s, F_BFu15s_BFu7s)
//============================================================================



static void Test_F_BFu15s_BFu8c()
{
  {
    init_simple_test("F_BFu15s_BFu8c");
    static STRUCT_IF_C F_BFu15s_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu8c, F_BFu15s_BFu8c)
//============================================================================



static void Test_F_BFu15s_BFu8i()
{
  {
    init_simple_test("F_BFu15s_BFu8i");
    static STRUCT_IF_C F_BFu15s_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu8i, F_BFu15s_BFu8i)
//============================================================================



static void Test_F_BFu15s_BFu8ll()
{
  {
    init_simple_test("F_BFu15s_BFu8ll");
    static STRUCT_IF_C F_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu8ll, F_BFu15s_BFu8ll)
//============================================================================



static void Test_F_BFu15s_BFu8s()
{
  {
    init_simple_test("F_BFu15s_BFu8s");
    static STRUCT_IF_C F_BFu15s_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "F_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "F_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu8s, F_BFu15s_BFu8s)
//============================================================================



static void Test_F_BFu15s_BFu9i()
{
  {
    init_simple_test("F_BFu15s_BFu9i");
    static STRUCT_IF_C F_BFu15s_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu9i, F_BFu15s_BFu9i)
//============================================================================



static void Test_F_BFu15s_BFu9ll()
{
  {
    init_simple_test("F_BFu15s_BFu9ll");
    static STRUCT_IF_C F_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu9ll, F_BFu15s_BFu9ll)
//============================================================================



static void Test_F_BFu15s_BFu9s()
{
  {
    init_simple_test("F_BFu15s_BFu9s");
    static STRUCT_IF_C F_BFu15s_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "F_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "F_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_BFu9s, F_BFu15s_BFu9s)
//============================================================================



static void Test_F_BFu15s_C()
{
  {
    init_simple_test("F_BFu15s_C");
    static STRUCT_IF_C F_BFu15s_C lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_C)");
    check_field_offset(lv, v1, 0, "F_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_C");
    check_field_offset(lv, v3, 6, "F_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_C, F_BFu15s_C)
//============================================================================



static void Test_F_BFu15s_D()
{
  {
    init_simple_test("F_BFu15s_D");
    static STRUCT_IF_C F_BFu15s_D lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_D)");
    check_field_offset(lv, v1, 0, "F_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_D");
    check_field_offset(lv, v3, 6, "F_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_D, F_BFu15s_D)
//============================================================================



static void Test_F_BFu15s_F()
{
  {
    init_simple_test("F_BFu15s_F");
    static STRUCT_IF_C F_BFu15s_F lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_F)");
    check_field_offset(lv, v1, 0, "F_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_F");
    check_field_offset(lv, v3, 6, "F_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_F, F_BFu15s_F)
//============================================================================



static void Test_F_BFu15s_I()
{
  {
    init_simple_test("F_BFu15s_I");
    static STRUCT_IF_C F_BFu15s_I lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_I)");
    check_field_offset(lv, v1, 0, "F_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_I");
    check_field_offset(lv, v3, 6, "F_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_I, F_BFu15s_I)
//============================================================================



static void Test_F_BFu15s_Ip()
{
  {
    init_simple_test("F_BFu15s_Ip");
    static STRUCT_IF_C F_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_Ip");
    check_field_offset(lv, v3, 6, "F_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_Ip, F_BFu15s_Ip)
//============================================================================



static void Test_F_BFu15s_L()
{
  {
    init_simple_test("F_BFu15s_L");
    static STRUCT_IF_C F_BFu15s_L lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_L)");
    check_field_offset(lv, v1, 0, "F_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_L");
    check_field_offset(lv, v3, 6, "F_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_L, F_BFu15s_L)
//============================================================================



static void Test_F_BFu15s_S()
{
  {
    init_simple_test("F_BFu15s_S");
    static STRUCT_IF_C F_BFu15s_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_S)");
    check_field_offset(lv, v1, 0, "F_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_S");
    check_field_offset(lv, v3, 6, "F_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_S, F_BFu15s_S)
//============================================================================



static void Test_F_BFu15s_Uc()
{
  {
    init_simple_test("F_BFu15s_Uc");
    static STRUCT_IF_C F_BFu15s_Uc lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_Uc");
    check_field_offset(lv, v3, 6, "F_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_Uc, F_BFu15s_Uc)
//============================================================================



static void Test_F_BFu15s_Ui()
{
  {
    init_simple_test("F_BFu15s_Ui");
    static STRUCT_IF_C F_BFu15s_Ui lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_Ui");
    check_field_offset(lv, v3, 6, "F_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_Ui, F_BFu15s_Ui)
//============================================================================



static void Test_F_BFu15s_Ul()
{
  {
    init_simple_test("F_BFu15s_Ul");
    static STRUCT_IF_C F_BFu15s_Ul lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_Ul");
    check_field_offset(lv, v3, 6, "F_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_Ul, F_BFu15s_Ul)
//============================================================================



static void Test_F_BFu15s_Us()
{
  {
    init_simple_test("F_BFu15s_Us");
    static STRUCT_IF_C F_BFu15s_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_Us");
    check_field_offset(lv, v3, 6, "F_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_Us, F_BFu15s_Us)
//============================================================================



static void Test_F_BFu15s_Vp()
{
  {
    init_simple_test("F_BFu15s_Vp");
    static STRUCT_IF_C F_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "F_BFu15s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "F_BFu15s_Vp");
    check_field_offset(lv, v3, 6, "F_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu15s_Vp, F_BFu15s_Vp)
//============================================================================



static void Test_F_BFu16i()
{
  {
    init_simple_test("F_BFu16i");
    static STRUCT_IF_C F_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i, F_BFu16i)
//============================================================================



static void Test_F_BFu16i_BFu15i()
{
  {
    init_simple_test("F_BFu16i_BFu15i");
    static STRUCT_IF_C F_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu15i, F_BFu16i_BFu15i)
//============================================================================



static void Test_F_BFu16i_BFu15ll()
{
  {
    init_simple_test("F_BFu16i_BFu15ll");
    static STRUCT_IF_C F_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu15ll, F_BFu16i_BFu15ll)
//============================================================================



static void Test_F_BFu16i_BFu15s()
{
  {
    init_simple_test("F_BFu16i_BFu15s");
    static STRUCT_IF_C F_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu15s, F_BFu16i_BFu15s)
//============================================================================



static void Test_F_BFu16i_BFu16i()
{
  {
    init_simple_test("F_BFu16i_BFu16i");
    static STRUCT_IF_C F_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu16i, F_BFu16i_BFu16i)
//============================================================================



static void Test_F_BFu16i_BFu16ll()
{
  {
    init_simple_test("F_BFu16i_BFu16ll");
    static STRUCT_IF_C F_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu16ll, F_BFu16i_BFu16ll)
//============================================================================



static void Test_F_BFu16i_BFu16s()
{
  {
    init_simple_test("F_BFu16i_BFu16s");
    static STRUCT_IF_C F_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu16s, F_BFu16i_BFu16s)
//============================================================================



static void Test_F_BFu16i_BFu17i()
{
  {
    init_simple_test("F_BFu16i_BFu17i");
    static STRUCT_IF_C F_BFu16i_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "F_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "F_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu17i, F_BFu16i_BFu17i)
//============================================================================



static void Test_F_BFu16i_BFu17ll()
{
  {
    init_simple_test("F_BFu16i_BFu17ll");
    static STRUCT_IF_C F_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "F_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "F_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu17ll, F_BFu16i_BFu17ll)
//============================================================================



static void Test_F_BFu16i_BFu1c()
{
  {
    init_simple_test("F_BFu16i_BFu1c");
    static STRUCT_IF_C F_BFu16i_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu1c, F_BFu16i_BFu1c)
//============================================================================



static void Test_F_BFu16i_BFu1i()
{
  {
    init_simple_test("F_BFu16i_BFu1i");
    static STRUCT_IF_C F_BFu16i_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu1i, F_BFu16i_BFu1i)
//============================================================================



static void Test_F_BFu16i_BFu1ll()
{
  {
    init_simple_test("F_BFu16i_BFu1ll");
    static STRUCT_IF_C F_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu1ll, F_BFu16i_BFu1ll)
//============================================================================



static void Test_F_BFu16i_BFu1s()
{
  {
    init_simple_test("F_BFu16i_BFu1s");
    static STRUCT_IF_C F_BFu16i_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu1s, F_BFu16i_BFu1s)
//============================================================================



static void Test_F_BFu16i_BFu31i()
{
  {
    init_simple_test("F_BFu16i_BFu31i");
    static STRUCT_IF_C F_BFu16i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "F_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "F_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu31i, F_BFu16i_BFu31i)
//============================================================================



static void Test_F_BFu16i_BFu31ll()
{
  {
    init_simple_test("F_BFu16i_BFu31ll");
    static STRUCT_IF_C F_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "F_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "F_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu31ll, F_BFu16i_BFu31ll)
//============================================================================



static void Test_F_BFu16i_BFu32i()
{
  {
    init_simple_test("F_BFu16i_BFu32i");
    static STRUCT_IF_C F_BFu16i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "F_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "F_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu32i, F_BFu16i_BFu32i)
//============================================================================



static void Test_F_BFu16i_BFu32ll()
{
  {
    init_simple_test("F_BFu16i_BFu32ll");
    static STRUCT_IF_C F_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "F_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "F_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu32ll, F_BFu16i_BFu32ll)
//============================================================================



static void Test_F_BFu16i_BFu33()
{
  {
    init_simple_test("F_BFu16i_BFu33");
    static STRUCT_IF_C F_BFu16i_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "F_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "F_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu33, F_BFu16i_BFu33)
//============================================================================



static void Test_F_BFu16i_BFu7c()
{
  {
    init_simple_test("F_BFu16i_BFu7c");
    static STRUCT_IF_C F_BFu16i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu7c, F_BFu16i_BFu7c)
//============================================================================



static void Test_F_BFu16i_BFu7i()
{
  {
    init_simple_test("F_BFu16i_BFu7i");
    static STRUCT_IF_C F_BFu16i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu7i, F_BFu16i_BFu7i)
//============================================================================



static void Test_F_BFu16i_BFu7ll()
{
  {
    init_simple_test("F_BFu16i_BFu7ll");
    static STRUCT_IF_C F_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu7ll, F_BFu16i_BFu7ll)
//============================================================================



static void Test_F_BFu16i_BFu7s()
{
  {
    init_simple_test("F_BFu16i_BFu7s");
    static STRUCT_IF_C F_BFu16i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu7s, F_BFu16i_BFu7s)
//============================================================================



static void Test_F_BFu16i_BFu8c()
{
  {
    init_simple_test("F_BFu16i_BFu8c");
    static STRUCT_IF_C F_BFu16i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu8c, F_BFu16i_BFu8c)
//============================================================================



static void Test_F_BFu16i_BFu8i()
{
  {
    init_simple_test("F_BFu16i_BFu8i");
    static STRUCT_IF_C F_BFu16i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu8i, F_BFu16i_BFu8i)
//============================================================================



static void Test_F_BFu16i_BFu8ll()
{
  {
    init_simple_test("F_BFu16i_BFu8ll");
    static STRUCT_IF_C F_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu8ll, F_BFu16i_BFu8ll)
//============================================================================



static void Test_F_BFu16i_BFu8s()
{
  {
    init_simple_test("F_BFu16i_BFu8s");
    static STRUCT_IF_C F_BFu16i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu8s, F_BFu16i_BFu8s)
//============================================================================



static void Test_F_BFu16i_BFu9i()
{
  {
    init_simple_test("F_BFu16i_BFu9i");
    static STRUCT_IF_C F_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu9i, F_BFu16i_BFu9i)
//============================================================================



static void Test_F_BFu16i_BFu9ll()
{
  {
    init_simple_test("F_BFu16i_BFu9ll");
    static STRUCT_IF_C F_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu9ll, F_BFu16i_BFu9ll)
//============================================================================



static void Test_F_BFu16i_BFu9s()
{
  {
    init_simple_test("F_BFu16i_BFu9s");
    static STRUCT_IF_C F_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_BFu9s, F_BFu16i_BFu9s)
//============================================================================



static void Test_F_BFu16i_C()
{
  {
    init_simple_test("F_BFu16i_C");
    static STRUCT_IF_C F_BFu16i_C lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_C)");
    check_field_offset(lv, v1, 0, "F_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_C");
    check_field_offset(lv, v3, 6, "F_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_C, F_BFu16i_C)
//============================================================================



static void Test_F_BFu16i_D()
{
  {
    init_simple_test("F_BFu16i_D");
    static STRUCT_IF_C F_BFu16i_D lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_D)");
    check_field_offset(lv, v1, 0, "F_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_D");
    check_field_offset(lv, v3, 6, "F_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_D, F_BFu16i_D)
//============================================================================



static void Test_F_BFu16i_F()
{
  {
    init_simple_test("F_BFu16i_F");
    static STRUCT_IF_C F_BFu16i_F lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_F)");
    check_field_offset(lv, v1, 0, "F_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_F");
    check_field_offset(lv, v3, 6, "F_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_F, F_BFu16i_F)
//============================================================================



static void Test_F_BFu16i_I()
{
  {
    init_simple_test("F_BFu16i_I");
    static STRUCT_IF_C F_BFu16i_I lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_I)");
    check_field_offset(lv, v1, 0, "F_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_I");
    check_field_offset(lv, v3, 6, "F_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_I, F_BFu16i_I)
//============================================================================



static void Test_F_BFu16i_Ip()
{
  {
    init_simple_test("F_BFu16i_Ip");
    static STRUCT_IF_C F_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_Ip");
    check_field_offset(lv, v3, 6, "F_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_Ip, F_BFu16i_Ip)
//============================================================================



static void Test_F_BFu16i_L()
{
  {
    init_simple_test("F_BFu16i_L");
    static STRUCT_IF_C F_BFu16i_L lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_L)");
    check_field_offset(lv, v1, 0, "F_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_L");
    check_field_offset(lv, v3, 6, "F_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_L, F_BFu16i_L)
//============================================================================



static void Test_F_BFu16i_S()
{
  {
    init_simple_test("F_BFu16i_S");
    static STRUCT_IF_C F_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_S)");
    check_field_offset(lv, v1, 0, "F_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_S");
    check_field_offset(lv, v3, 6, "F_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_S, F_BFu16i_S)
//============================================================================



static void Test_F_BFu16i_Uc()
{
  {
    init_simple_test("F_BFu16i_Uc");
    static STRUCT_IF_C F_BFu16i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_Uc");
    check_field_offset(lv, v3, 6, "F_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_Uc, F_BFu16i_Uc)
//============================================================================



static void Test_F_BFu16i_Ui()
{
  {
    init_simple_test("F_BFu16i_Ui");
    static STRUCT_IF_C F_BFu16i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_Ui");
    check_field_offset(lv, v3, 6, "F_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_Ui, F_BFu16i_Ui)
//============================================================================



static void Test_F_BFu16i_Ul()
{
  {
    init_simple_test("F_BFu16i_Ul");
    static STRUCT_IF_C F_BFu16i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_Ul");
    check_field_offset(lv, v3, 6, "F_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_Ul, F_BFu16i_Ul)
//============================================================================



static void Test_F_BFu16i_Us()
{
  {
    init_simple_test("F_BFu16i_Us");
    static STRUCT_IF_C F_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_Us");
    check_field_offset(lv, v3, 6, "F_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_Us, F_BFu16i_Us)
//============================================================================



static void Test_F_BFu16i_Vp()
{
  {
    init_simple_test("F_BFu16i_Vp");
    static STRUCT_IF_C F_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16i_Vp");
    check_field_offset(lv, v3, 6, "F_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16i_Vp, F_BFu16i_Vp)
//============================================================================



static void Test_F_BFu16ll()
{
  {
    init_simple_test("F_BFu16ll");
    static STRUCT_IF_C F_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll, F_BFu16ll)
//============================================================================



static void Test_F_BFu16ll_BFu15i()
{
  {
    init_simple_test("F_BFu16ll_BFu15i");
    static STRUCT_IF_C F_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu15i, F_BFu16ll_BFu15i)
//============================================================================



static void Test_F_BFu16ll_BFu15ll()
{
  {
    init_simple_test("F_BFu16ll_BFu15ll");
    static STRUCT_IF_C F_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu15ll, F_BFu16ll_BFu15ll)
//============================================================================



static void Test_F_BFu16ll_BFu15s()
{
  {
    init_simple_test("F_BFu16ll_BFu15s");
    static STRUCT_IF_C F_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu15s, F_BFu16ll_BFu15s)
//============================================================================



static void Test_F_BFu16ll_BFu16i()
{
  {
    init_simple_test("F_BFu16ll_BFu16i");
    static STRUCT_IF_C F_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu16i, F_BFu16ll_BFu16i)
//============================================================================



static void Test_F_BFu16ll_BFu16ll()
{
  {
    init_simple_test("F_BFu16ll_BFu16ll");
    static STRUCT_IF_C F_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu16ll, F_BFu16ll_BFu16ll)
//============================================================================



static void Test_F_BFu16ll_BFu16s()
{
  {
    init_simple_test("F_BFu16ll_BFu16s");
    static STRUCT_IF_C F_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu16s, F_BFu16ll_BFu16s)
//============================================================================



static void Test_F_BFu16ll_BFu17i()
{
  {
    init_simple_test("F_BFu16ll_BFu17i");
    static STRUCT_IF_C F_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "F_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "F_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu17i, F_BFu16ll_BFu17i)
//============================================================================



static void Test_F_BFu16ll_BFu17ll()
{
  {
    init_simple_test("F_BFu16ll_BFu17ll");
    static STRUCT_IF_C F_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "F_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "F_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu17ll, F_BFu16ll_BFu17ll)
//============================================================================



static void Test_F_BFu16ll_BFu1c()
{
  {
    init_simple_test("F_BFu16ll_BFu1c");
    static STRUCT_IF_C F_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu1c, F_BFu16ll_BFu1c)
//============================================================================



static void Test_F_BFu16ll_BFu1i()
{
  {
    init_simple_test("F_BFu16ll_BFu1i");
    static STRUCT_IF_C F_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu1i, F_BFu16ll_BFu1i)
//============================================================================



static void Test_F_BFu16ll_BFu1ll()
{
  {
    init_simple_test("F_BFu16ll_BFu1ll");
    static STRUCT_IF_C F_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu1ll, F_BFu16ll_BFu1ll)
//============================================================================



static void Test_F_BFu16ll_BFu1s()
{
  {
    init_simple_test("F_BFu16ll_BFu1s");
    static STRUCT_IF_C F_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu1s, F_BFu16ll_BFu1s)
//============================================================================



static void Test_F_BFu16ll_BFu31i()
{
  {
    init_simple_test("F_BFu16ll_BFu31i");
    static STRUCT_IF_C F_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "F_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "F_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu31i, F_BFu16ll_BFu31i)
//============================================================================



static void Test_F_BFu16ll_BFu31ll()
{
  {
    init_simple_test("F_BFu16ll_BFu31ll");
    static STRUCT_IF_C F_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "F_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "F_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu31ll, F_BFu16ll_BFu31ll)
//============================================================================



static void Test_F_BFu16ll_BFu32i()
{
  {
    init_simple_test("F_BFu16ll_BFu32i");
    static STRUCT_IF_C F_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "F_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "F_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu32i, F_BFu16ll_BFu32i)
//============================================================================



static void Test_F_BFu16ll_BFu32ll()
{
  {
    init_simple_test("F_BFu16ll_BFu32ll");
    static STRUCT_IF_C F_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "F_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "F_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu32ll, F_BFu16ll_BFu32ll)
//============================================================================



static void Test_F_BFu16ll_BFu33()
{
  {
    init_simple_test("F_BFu16ll_BFu33");
    static STRUCT_IF_C F_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "F_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "F_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu33, F_BFu16ll_BFu33)
//============================================================================



static void Test_F_BFu16ll_BFu7c()
{
  {
    init_simple_test("F_BFu16ll_BFu7c");
    static STRUCT_IF_C F_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu7c, F_BFu16ll_BFu7c)
//============================================================================



static void Test_F_BFu16ll_BFu7i()
{
  {
    init_simple_test("F_BFu16ll_BFu7i");
    static STRUCT_IF_C F_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu7i, F_BFu16ll_BFu7i)
//============================================================================



static void Test_F_BFu16ll_BFu7ll()
{
  {
    init_simple_test("F_BFu16ll_BFu7ll");
    static STRUCT_IF_C F_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu7ll, F_BFu16ll_BFu7ll)
//============================================================================



static void Test_F_BFu16ll_BFu7s()
{
  {
    init_simple_test("F_BFu16ll_BFu7s");
    static STRUCT_IF_C F_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu7s, F_BFu16ll_BFu7s)
//============================================================================



static void Test_F_BFu16ll_BFu8c()
{
  {
    init_simple_test("F_BFu16ll_BFu8c");
    static STRUCT_IF_C F_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu8c, F_BFu16ll_BFu8c)
//============================================================================



static void Test_F_BFu16ll_BFu8i()
{
  {
    init_simple_test("F_BFu16ll_BFu8i");
    static STRUCT_IF_C F_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu8i, F_BFu16ll_BFu8i)
//============================================================================



static void Test_F_BFu16ll_BFu8ll()
{
  {
    init_simple_test("F_BFu16ll_BFu8ll");
    static STRUCT_IF_C F_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu8ll, F_BFu16ll_BFu8ll)
//============================================================================



static void Test_F_BFu16ll_BFu8s()
{
  {
    init_simple_test("F_BFu16ll_BFu8s");
    static STRUCT_IF_C F_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu8s, F_BFu16ll_BFu8s)
//============================================================================



static void Test_F_BFu16ll_BFu9i()
{
  {
    init_simple_test("F_BFu16ll_BFu9i");
    static STRUCT_IF_C F_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu9i, F_BFu16ll_BFu9i)
//============================================================================



static void Test_F_BFu16ll_BFu9ll()
{
  {
    init_simple_test("F_BFu16ll_BFu9ll");
    static STRUCT_IF_C F_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu9ll, F_BFu16ll_BFu9ll)
//============================================================================



static void Test_F_BFu16ll_BFu9s()
{
  {
    init_simple_test("F_BFu16ll_BFu9s");
    static STRUCT_IF_C F_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_BFu9s, F_BFu16ll_BFu9s)
//============================================================================



static void Test_F_BFu16ll_C()
{
  {
    init_simple_test("F_BFu16ll_C");
    static STRUCT_IF_C F_BFu16ll_C lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_C");
    check_field_offset(lv, v3, 6, "F_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_C, F_BFu16ll_C)
//============================================================================



static void Test_F_BFu16ll_D()
{
  {
    init_simple_test("F_BFu16ll_D");
    static STRUCT_IF_C F_BFu16ll_D lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_D");
    check_field_offset(lv, v3, 6, "F_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_D, F_BFu16ll_D)
//============================================================================



static void Test_F_BFu16ll_F()
{
  {
    init_simple_test("F_BFu16ll_F");
    static STRUCT_IF_C F_BFu16ll_F lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_F");
    check_field_offset(lv, v3, 6, "F_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_F, F_BFu16ll_F)
//============================================================================



static void Test_F_BFu16ll_I()
{
  {
    init_simple_test("F_BFu16ll_I");
    static STRUCT_IF_C F_BFu16ll_I lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_I");
    check_field_offset(lv, v3, 6, "F_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_I, F_BFu16ll_I)
//============================================================================



static void Test_F_BFu16ll_Ip()
{
  {
    init_simple_test("F_BFu16ll_Ip");
    static STRUCT_IF_C F_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_Ip");
    check_field_offset(lv, v3, 6, "F_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_Ip, F_BFu16ll_Ip)
//============================================================================



static void Test_F_BFu16ll_L()
{
  {
    init_simple_test("F_BFu16ll_L");
    static STRUCT_IF_C F_BFu16ll_L lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_L");
    check_field_offset(lv, v3, 6, "F_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_L, F_BFu16ll_L)
//============================================================================



static void Test_F_BFu16ll_S()
{
  {
    init_simple_test("F_BFu16ll_S");
    static STRUCT_IF_C F_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_S");
    check_field_offset(lv, v3, 6, "F_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_S, F_BFu16ll_S)
//============================================================================



static void Test_F_BFu16ll_Uc()
{
  {
    init_simple_test("F_BFu16ll_Uc");
    static STRUCT_IF_C F_BFu16ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_Uc");
    check_field_offset(lv, v3, 6, "F_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_Uc, F_BFu16ll_Uc)
//============================================================================



static void Test_F_BFu16ll_Ui()
{
  {
    init_simple_test("F_BFu16ll_Ui");
    static STRUCT_IF_C F_BFu16ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_Ui");
    check_field_offset(lv, v3, 6, "F_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_Ui, F_BFu16ll_Ui)
//============================================================================



static void Test_F_BFu16ll_Ul()
{
  {
    init_simple_test("F_BFu16ll_Ul");
    static STRUCT_IF_C F_BFu16ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_Ul");
    check_field_offset(lv, v3, 6, "F_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_Ul, F_BFu16ll_Ul)
//============================================================================



static void Test_F_BFu16ll_Us()
{
  {
    init_simple_test("F_BFu16ll_Us");
    static STRUCT_IF_C F_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_Us");
    check_field_offset(lv, v3, 6, "F_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_Us, F_BFu16ll_Us)
//============================================================================



static void Test_F_BFu16ll_Vp()
{
  {
    init_simple_test("F_BFu16ll_Vp");
    static STRUCT_IF_C F_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16ll_Vp");
    check_field_offset(lv, v3, 6, "F_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16ll_Vp, F_BFu16ll_Vp)
//============================================================================



static void Test_F_BFu16s()
{
  {
    init_simple_test("F_BFu16s");
    static STRUCT_IF_C F_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s, F_BFu16s)
//============================================================================



static void Test_F_BFu16s_BFu15i()
{
  {
    init_simple_test("F_BFu16s_BFu15i");
    static STRUCT_IF_C F_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu15i, F_BFu16s_BFu15i)
//============================================================================



static void Test_F_BFu16s_BFu15ll()
{
  {
    init_simple_test("F_BFu16s_BFu15ll");
    static STRUCT_IF_C F_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu15ll, F_BFu16s_BFu15ll)
//============================================================================



static void Test_F_BFu16s_BFu15s()
{
  {
    init_simple_test("F_BFu16s_BFu15s");
    static STRUCT_IF_C F_BFu16s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "F_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "F_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu15s, F_BFu16s_BFu15s)
//============================================================================



static void Test_F_BFu16s_BFu16i()
{
  {
    init_simple_test("F_BFu16s_BFu16i");
    static STRUCT_IF_C F_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu16i, F_BFu16s_BFu16i)
//============================================================================



static void Test_F_BFu16s_BFu16ll()
{
  {
    init_simple_test("F_BFu16s_BFu16ll");
    static STRUCT_IF_C F_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu16ll, F_BFu16s_BFu16ll)
//============================================================================



static void Test_F_BFu16s_BFu16s()
{
  {
    init_simple_test("F_BFu16s_BFu16s");
    static STRUCT_IF_C F_BFu16s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "F_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu16s, F_BFu16s_BFu16s)
//============================================================================



static void Test_F_BFu16s_BFu17i()
{
  {
    init_simple_test("F_BFu16s_BFu17i");
    static STRUCT_IF_C F_BFu16s_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "F_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "F_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu17i, F_BFu16s_BFu17i)
//============================================================================



static void Test_F_BFu16s_BFu17ll()
{
  {
    init_simple_test("F_BFu16s_BFu17ll");
    static STRUCT_IF_C F_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "F_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "F_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu17ll, F_BFu16s_BFu17ll)
//============================================================================



static void Test_F_BFu16s_BFu1c()
{
  {
    init_simple_test("F_BFu16s_BFu1c");
    static STRUCT_IF_C F_BFu16s_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu1c, F_BFu16s_BFu1c)
//============================================================================



static void Test_F_BFu16s_BFu1i()
{
  {
    init_simple_test("F_BFu16s_BFu1i");
    static STRUCT_IF_C F_BFu16s_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu1i, F_BFu16s_BFu1i)
//============================================================================



static void Test_F_BFu16s_BFu1ll()
{
  {
    init_simple_test("F_BFu16s_BFu1ll");
    static STRUCT_IF_C F_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu1ll, F_BFu16s_BFu1ll)
//============================================================================



static void Test_F_BFu16s_BFu1s()
{
  {
    init_simple_test("F_BFu16s_BFu1s");
    static STRUCT_IF_C F_BFu16s_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "F_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu1s, F_BFu16s_BFu1s)
//============================================================================



static void Test_F_BFu16s_BFu31i()
{
  {
    init_simple_test("F_BFu16s_BFu31i");
    static STRUCT_IF_C F_BFu16s_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "F_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "F_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu31i, F_BFu16s_BFu31i)
//============================================================================



static void Test_F_BFu16s_BFu31ll()
{
  {
    init_simple_test("F_BFu16s_BFu31ll");
    static STRUCT_IF_C F_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "F_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "F_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu31ll, F_BFu16s_BFu31ll)
//============================================================================



static void Test_F_BFu16s_BFu32i()
{
  {
    init_simple_test("F_BFu16s_BFu32i");
    static STRUCT_IF_C F_BFu16s_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "F_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "F_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu32i, F_BFu16s_BFu32i)
//============================================================================



static void Test_F_BFu16s_BFu32ll()
{
  {
    init_simple_test("F_BFu16s_BFu32ll");
    static STRUCT_IF_C F_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "F_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "F_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu32ll, F_BFu16s_BFu32ll)
//============================================================================



static void Test_F_BFu16s_BFu33()
{
  {
    init_simple_test("F_BFu16s_BFu33");
    static STRUCT_IF_C F_BFu16s_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "F_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "F_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu33, F_BFu16s_BFu33)
//============================================================================



static void Test_F_BFu16s_BFu7c()
{
  {
    init_simple_test("F_BFu16s_BFu7c");
    static STRUCT_IF_C F_BFu16s_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu7c, F_BFu16s_BFu7c)
//============================================================================



static void Test_F_BFu16s_BFu7i()
{
  {
    init_simple_test("F_BFu16s_BFu7i");
    static STRUCT_IF_C F_BFu16s_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu7i, F_BFu16s_BFu7i)
//============================================================================



static void Test_F_BFu16s_BFu7ll()
{
  {
    init_simple_test("F_BFu16s_BFu7ll");
    static STRUCT_IF_C F_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu7ll, F_BFu16s_BFu7ll)
//============================================================================



static void Test_F_BFu16s_BFu7s()
{
  {
    init_simple_test("F_BFu16s_BFu7s");
    static STRUCT_IF_C F_BFu16s_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "F_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "F_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu7s, F_BFu16s_BFu7s)
//============================================================================



static void Test_F_BFu16s_BFu8c()
{
  {
    init_simple_test("F_BFu16s_BFu8c");
    static STRUCT_IF_C F_BFu16s_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu8c, F_BFu16s_BFu8c)
//============================================================================



static void Test_F_BFu16s_BFu8i()
{
  {
    init_simple_test("F_BFu16s_BFu8i");
    static STRUCT_IF_C F_BFu16s_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu8i, F_BFu16s_BFu8i)
//============================================================================



static void Test_F_BFu16s_BFu8ll()
{
  {
    init_simple_test("F_BFu16s_BFu8ll");
    static STRUCT_IF_C F_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu8ll, F_BFu16s_BFu8ll)
//============================================================================



static void Test_F_BFu16s_BFu8s()
{
  {
    init_simple_test("F_BFu16s_BFu8s");
    static STRUCT_IF_C F_BFu16s_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "F_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "F_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu8s, F_BFu16s_BFu8s)
//============================================================================



static void Test_F_BFu16s_BFu9i()
{
  {
    init_simple_test("F_BFu16s_BFu9i");
    static STRUCT_IF_C F_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu9i, F_BFu16s_BFu9i)
//============================================================================



static void Test_F_BFu16s_BFu9ll()
{
  {
    init_simple_test("F_BFu16s_BFu9ll");
    static STRUCT_IF_C F_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu9ll, F_BFu16s_BFu9ll)
//============================================================================



static void Test_F_BFu16s_BFu9s()
{
  {
    init_simple_test("F_BFu16s_BFu9s");
    static STRUCT_IF_C F_BFu16s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "F_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "F_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_BFu9s, F_BFu16s_BFu9s)
//============================================================================



static void Test_F_BFu16s_C()
{
  {
    init_simple_test("F_BFu16s_C");
    static STRUCT_IF_C F_BFu16s_C lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_C)");
    check_field_offset(lv, v1, 0, "F_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_C");
    check_field_offset(lv, v3, 6, "F_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_C, F_BFu16s_C)
//============================================================================



static void Test_F_BFu16s_D()
{
  {
    init_simple_test("F_BFu16s_D");
    static STRUCT_IF_C F_BFu16s_D lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_D)");
    check_field_offset(lv, v1, 0, "F_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_D");
    check_field_offset(lv, v3, 6, "F_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_D, F_BFu16s_D)
//============================================================================



static void Test_F_BFu16s_F()
{
  {
    init_simple_test("F_BFu16s_F");
    static STRUCT_IF_C F_BFu16s_F lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_F)");
    check_field_offset(lv, v1, 0, "F_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_F");
    check_field_offset(lv, v3, 6, "F_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_F, F_BFu16s_F)
//============================================================================



static void Test_F_BFu16s_I()
{
  {
    init_simple_test("F_BFu16s_I");
    static STRUCT_IF_C F_BFu16s_I lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_I)");
    check_field_offset(lv, v1, 0, "F_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_I");
    check_field_offset(lv, v3, 6, "F_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_I, F_BFu16s_I)
//============================================================================



static void Test_F_BFu16s_Ip()
{
  {
    init_simple_test("F_BFu16s_Ip");
    static STRUCT_IF_C F_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_Ip");
    check_field_offset(lv, v3, 6, "F_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_Ip, F_BFu16s_Ip)
//============================================================================



static void Test_F_BFu16s_L()
{
  {
    init_simple_test("F_BFu16s_L");
    static STRUCT_IF_C F_BFu16s_L lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_L)");
    check_field_offset(lv, v1, 0, "F_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_L");
    check_field_offset(lv, v3, 6, "F_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_L, F_BFu16s_L)
//============================================================================



static void Test_F_BFu16s_S()
{
  {
    init_simple_test("F_BFu16s_S");
    static STRUCT_IF_C F_BFu16s_S lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_S)");
    check_field_offset(lv, v1, 0, "F_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_S");
    check_field_offset(lv, v3, 6, "F_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_S, F_BFu16s_S)
//============================================================================



static void Test_F_BFu16s_Uc()
{
  {
    init_simple_test("F_BFu16s_Uc");
    static STRUCT_IF_C F_BFu16s_Uc lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_Uc");
    check_field_offset(lv, v3, 6, "F_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_Uc, F_BFu16s_Uc)
//============================================================================



static void Test_F_BFu16s_Ui()
{
  {
    init_simple_test("F_BFu16s_Ui");
    static STRUCT_IF_C F_BFu16s_Ui lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_Ui");
    check_field_offset(lv, v3, 6, "F_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_Ui, F_BFu16s_Ui)
//============================================================================



static void Test_F_BFu16s_Ul()
{
  {
    init_simple_test("F_BFu16s_Ul");
    static STRUCT_IF_C F_BFu16s_Ul lv;
    check2(sizeof(lv), 14, "sizeof(F_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_Ul");
    check_field_offset(lv, v3, 6, "F_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_Ul, F_BFu16s_Ul)
//============================================================================



static void Test_F_BFu16s_Us()
{
  {
    init_simple_test("F_BFu16s_Us");
    static STRUCT_IF_C F_BFu16s_Us lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_Us");
    check_field_offset(lv, v3, 6, "F_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_Us, F_BFu16s_Us)
//============================================================================



static void Test_F_BFu16s_Vp()
{
  {
    init_simple_test("F_BFu16s_Vp");
    static STRUCT_IF_C F_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(F_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "F_BFu16s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "F_BFu16s_Vp");
    check_field_offset(lv, v3, 6, "F_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu16s_Vp, F_BFu16s_Vp)
//============================================================================



static void Test_F_BFu17i()
{
  {
    init_simple_test("F_BFu17i");
    static STRUCT_IF_C F_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i, F_BFu17i)
//============================================================================



static void Test_F_BFu17i_BFu15i()
{
  {
    init_simple_test("F_BFu17i_BFu15i");
    static STRUCT_IF_C F_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "F_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "F_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu15i, F_BFu17i_BFu15i)
//============================================================================



static void Test_F_BFu17i_BFu15ll()
{
  {
    init_simple_test("F_BFu17i_BFu15ll");
    static STRUCT_IF_C F_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "F_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "F_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu15ll, F_BFu17i_BFu15ll)
//============================================================================



static void Test_F_BFu17i_BFu15s()
{
  {
    init_simple_test("F_BFu17i_BFu15s");
    static STRUCT_IF_C F_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "F_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "F_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu15s, F_BFu17i_BFu15s)
//============================================================================



static void Test_F_BFu17i_BFu16i()
{
  {
    init_simple_test("F_BFu17i_BFu16i");
    static STRUCT_IF_C F_BFu17i_BFu16i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "F_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "F_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu16i, F_BFu17i_BFu16i)
//============================================================================



static void Test_F_BFu17i_BFu16ll()
{
  {
    init_simple_test("F_BFu17i_BFu16ll");
    static STRUCT_IF_C F_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "F_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "F_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu16ll, F_BFu17i_BFu16ll)
//============================================================================



static void Test_F_BFu17i_BFu16s()
{
  {
    init_simple_test("F_BFu17i_BFu16s");
    static STRUCT_IF_C F_BFu17i_BFu16s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "F_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "F_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu16s, F_BFu17i_BFu16s)
//============================================================================



static void Test_F_BFu17i_BFu17i()
{
  {
    init_simple_test("F_BFu17i_BFu17i");
    static STRUCT_IF_C F_BFu17i_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "F_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "F_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu17i, F_BFu17i_BFu17i)
//============================================================================



static void Test_F_BFu17i_BFu17ll()
{
  {
    init_simple_test("F_BFu17i_BFu17ll");
    static STRUCT_IF_C F_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "F_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "F_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu17ll, F_BFu17i_BFu17ll)
//============================================================================



static void Test_F_BFu17i_BFu1c()
{
  {
    init_simple_test("F_BFu17i_BFu1c");
    static STRUCT_IF_C F_BFu17i_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu1c, F_BFu17i_BFu1c)
//============================================================================



static void Test_F_BFu17i_BFu1i()
{
  {
    init_simple_test("F_BFu17i_BFu1i");
    static STRUCT_IF_C F_BFu17i_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu1i, F_BFu17i_BFu1i)
//============================================================================



static void Test_F_BFu17i_BFu1ll()
{
  {
    init_simple_test("F_BFu17i_BFu1ll");
    static STRUCT_IF_C F_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu1ll, F_BFu17i_BFu1ll)
//============================================================================



static void Test_F_BFu17i_BFu1s()
{
  {
    init_simple_test("F_BFu17i_BFu1s");
    static STRUCT_IF_C F_BFu17i_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu1s, F_BFu17i_BFu1s)
//============================================================================



static void Test_F_BFu17i_BFu31i()
{
  {
    init_simple_test("F_BFu17i_BFu31i");
    static STRUCT_IF_C F_BFu17i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "F_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "F_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu31i, F_BFu17i_BFu31i)
//============================================================================



static void Test_F_BFu17i_BFu31ll()
{
  {
    init_simple_test("F_BFu17i_BFu31ll");
    static STRUCT_IF_C F_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "F_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "F_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu31ll, F_BFu17i_BFu31ll)
//============================================================================



static void Test_F_BFu17i_BFu32i()
{
  {
    init_simple_test("F_BFu17i_BFu32i");
    static STRUCT_IF_C F_BFu17i_BFu32i lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "F_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "F_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu32i, F_BFu17i_BFu32i)
//============================================================================



static void Test_F_BFu17i_BFu32ll()
{
  {
    init_simple_test("F_BFu17i_BFu32ll");
    static STRUCT_IF_C F_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "F_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "F_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu32ll, F_BFu17i_BFu32ll)
//============================================================================



static void Test_F_BFu17i_BFu33()
{
  {
    init_simple_test("F_BFu17i_BFu33");
    static STRUCT_IF_C F_BFu17i_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, 1, "F_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, hide_ull(1LL<<32), "F_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu33, F_BFu17i_BFu33)
//============================================================================



static void Test_F_BFu17i_BFu7c()
{
  {
    init_simple_test("F_BFu17i_BFu7c");
    static STRUCT_IF_C F_BFu17i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu7c, F_BFu17i_BFu7c)
//============================================================================



static void Test_F_BFu17i_BFu7i()
{
  {
    init_simple_test("F_BFu17i_BFu7i");
    static STRUCT_IF_C F_BFu17i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu7i, F_BFu17i_BFu7i)
//============================================================================



static void Test_F_BFu17i_BFu7ll()
{
  {
    init_simple_test("F_BFu17i_BFu7ll");
    static STRUCT_IF_C F_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu7ll, F_BFu17i_BFu7ll)
//============================================================================



static void Test_F_BFu17i_BFu7s()
{
  {
    init_simple_test("F_BFu17i_BFu7s");
    static STRUCT_IF_C F_BFu17i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu7s, F_BFu17i_BFu7s)
//============================================================================



static void Test_F_BFu17i_BFu8c()
{
  {
    init_simple_test("F_BFu17i_BFu8c");
    static STRUCT_IF_C F_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu8c, F_BFu17i_BFu8c)
//============================================================================



static void Test_F_BFu17i_BFu8i()
{
  {
    init_simple_test("F_BFu17i_BFu8i");
    static STRUCT_IF_C F_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu8i, F_BFu17i_BFu8i)
//============================================================================



static void Test_F_BFu17i_BFu8ll()
{
  {
    init_simple_test("F_BFu17i_BFu8ll");
    static STRUCT_IF_C F_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu8ll, F_BFu17i_BFu8ll)
//============================================================================



static void Test_F_BFu17i_BFu8s()
{
  {
    init_simple_test("F_BFu17i_BFu8s");
    static STRUCT_IF_C F_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu8s, F_BFu17i_BFu8s)
//============================================================================



static void Test_F_BFu17i_BFu9i()
{
  {
    init_simple_test("F_BFu17i_BFu9i");
    static STRUCT_IF_C F_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "F_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "F_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu9i, F_BFu17i_BFu9i)
//============================================================================



static void Test_F_BFu17i_BFu9ll()
{
  {
    init_simple_test("F_BFu17i_BFu9ll");
    static STRUCT_IF_C F_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "F_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "F_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu9ll, F_BFu17i_BFu9ll)
//============================================================================



static void Test_F_BFu17i_BFu9s()
{
  {
    init_simple_test("F_BFu17i_BFu9s");
    static STRUCT_IF_C F_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "F_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "F_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_BFu9s, F_BFu17i_BFu9s)
//============================================================================



static void Test_F_BFu17i_C()
{
  {
    init_simple_test("F_BFu17i_C");
    static STRUCT_IF_C F_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_C)");
    check_field_offset(lv, v1, 0, "F_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_C");
    check_field_offset(lv, v3, 7, "F_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_C, F_BFu17i_C)
//============================================================================



static void Test_F_BFu17i_D()
{
  {
    init_simple_test("F_BFu17i_D");
    static STRUCT_IF_C F_BFu17i_D lv;
    check2(sizeof(lv), 15, "sizeof(F_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_D)");
    check_field_offset(lv, v1, 0, "F_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_D");
    check_field_offset(lv, v3, 7, "F_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_D, F_BFu17i_D)
//============================================================================



static void Test_F_BFu17i_F()
{
  {
    init_simple_test("F_BFu17i_F");
    static STRUCT_IF_C F_BFu17i_F lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_F)");
    check_field_offset(lv, v1, 0, "F_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_F");
    check_field_offset(lv, v3, 7, "F_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_F, F_BFu17i_F)
//============================================================================



static void Test_F_BFu17i_I()
{
  {
    init_simple_test("F_BFu17i_I");
    static STRUCT_IF_C F_BFu17i_I lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_I)");
    check_field_offset(lv, v1, 0, "F_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_I");
    check_field_offset(lv, v3, 7, "F_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_I, F_BFu17i_I)
//============================================================================



static void Test_F_BFu17i_Ip()
{
  {
    init_simple_test("F_BFu17i_Ip");
    static STRUCT_IF_C F_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(F_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_Ip");
    check_field_offset(lv, v3, 7, "F_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_Ip, F_BFu17i_Ip)
//============================================================================



static void Test_F_BFu17i_L()
{
  {
    init_simple_test("F_BFu17i_L");
    static STRUCT_IF_C F_BFu17i_L lv;
    check2(sizeof(lv), 15, "sizeof(F_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_L)");
    check_field_offset(lv, v1, 0, "F_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_L");
    check_field_offset(lv, v3, 7, "F_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_L, F_BFu17i_L)
//============================================================================



static void Test_F_BFu17i_S()
{
  {
    init_simple_test("F_BFu17i_S");
    static STRUCT_IF_C F_BFu17i_S lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_S)");
    check_field_offset(lv, v1, 0, "F_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_S");
    check_field_offset(lv, v3, 7, "F_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_S, F_BFu17i_S)
//============================================================================



static void Test_F_BFu17i_Uc()
{
  {
    init_simple_test("F_BFu17i_Uc");
    static STRUCT_IF_C F_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_Uc");
    check_field_offset(lv, v3, 7, "F_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_Uc, F_BFu17i_Uc)
//============================================================================



static void Test_F_BFu17i_Ui()
{
  {
    init_simple_test("F_BFu17i_Ui");
    static STRUCT_IF_C F_BFu17i_Ui lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_Ui");
    check_field_offset(lv, v3, 7, "F_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_Ui, F_BFu17i_Ui)
//============================================================================



static void Test_F_BFu17i_Ul()
{
  {
    init_simple_test("F_BFu17i_Ul");
    static STRUCT_IF_C F_BFu17i_Ul lv;
    check2(sizeof(lv), 15, "sizeof(F_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_Ul");
    check_field_offset(lv, v3, 7, "F_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_Ul, F_BFu17i_Ul)
//============================================================================



static void Test_F_BFu17i_Us()
{
  {
    init_simple_test("F_BFu17i_Us");
    static STRUCT_IF_C F_BFu17i_Us lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_Us");
    check_field_offset(lv, v3, 7, "F_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_Us, F_BFu17i_Us)
//============================================================================



static void Test_F_BFu17i_Vp()
{
  {
    init_simple_test("F_BFu17i_Vp");
    static STRUCT_IF_C F_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(F_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17i_Vp");
    check_field_offset(lv, v3, 7, "F_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17i_Vp, F_BFu17i_Vp)
//============================================================================



static void Test_F_BFu17ll()
{
  {
    init_simple_test("F_BFu17ll");
    static STRUCT_IF_C F_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll, F_BFu17ll)
//============================================================================



static void Test_F_BFu17ll_BFu15i()
{
  {
    init_simple_test("F_BFu17ll_BFu15i");
    static STRUCT_IF_C F_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "F_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "F_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu15i, F_BFu17ll_BFu15i)
//============================================================================



static void Test_F_BFu17ll_BFu15ll()
{
  {
    init_simple_test("F_BFu17ll_BFu15ll");
    static STRUCT_IF_C F_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "F_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "F_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu15ll, F_BFu17ll_BFu15ll)
//============================================================================



static void Test_F_BFu17ll_BFu15s()
{
  {
    init_simple_test("F_BFu17ll_BFu15s");
    static STRUCT_IF_C F_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "F_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "F_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu15s, F_BFu17ll_BFu15s)
//============================================================================



static void Test_F_BFu17ll_BFu16i()
{
  {
    init_simple_test("F_BFu17ll_BFu16i");
    static STRUCT_IF_C F_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "F_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "F_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu16i, F_BFu17ll_BFu16i)
//============================================================================



static void Test_F_BFu17ll_BFu16ll()
{
  {
    init_simple_test("F_BFu17ll_BFu16ll");
    static STRUCT_IF_C F_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "F_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "F_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu16ll, F_BFu17ll_BFu16ll)
//============================================================================



static void Test_F_BFu17ll_BFu16s()
{
  {
    init_simple_test("F_BFu17ll_BFu16s");
    static STRUCT_IF_C F_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "F_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "F_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu16s, F_BFu17ll_BFu16s)
//============================================================================



static void Test_F_BFu17ll_BFu17i()
{
  {
    init_simple_test("F_BFu17ll_BFu17i");
    static STRUCT_IF_C F_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "F_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu17i, F_BFu17ll_BFu17i)
//============================================================================



static void Test_F_BFu17ll_BFu17ll()
{
  {
    init_simple_test("F_BFu17ll_BFu17ll");
    static STRUCT_IF_C F_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "F_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu17ll, F_BFu17ll_BFu17ll)
//============================================================================



static void Test_F_BFu17ll_BFu1c()
{
  {
    init_simple_test("F_BFu17ll_BFu1c");
    static STRUCT_IF_C F_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu1c, F_BFu17ll_BFu1c)
//============================================================================



static void Test_F_BFu17ll_BFu1i()
{
  {
    init_simple_test("F_BFu17ll_BFu1i");
    static STRUCT_IF_C F_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu1i, F_BFu17ll_BFu1i)
//============================================================================



static void Test_F_BFu17ll_BFu1ll()
{
  {
    init_simple_test("F_BFu17ll_BFu1ll");
    static STRUCT_IF_C F_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu1ll, F_BFu17ll_BFu1ll)
//============================================================================



static void Test_F_BFu17ll_BFu1s()
{
  {
    init_simple_test("F_BFu17ll_BFu1s");
    static STRUCT_IF_C F_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "F_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu1s, F_BFu17ll_BFu1s)
//============================================================================



static void Test_F_BFu17ll_BFu31i()
{
  {
    init_simple_test("F_BFu17ll_BFu31i");
    static STRUCT_IF_C F_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "F_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "F_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu31i, F_BFu17ll_BFu31i)
//============================================================================



static void Test_F_BFu17ll_BFu31ll()
{
  {
    init_simple_test("F_BFu17ll_BFu31ll");
    static STRUCT_IF_C F_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "F_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "F_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu31ll, F_BFu17ll_BFu31ll)
//============================================================================



static void Test_F_BFu17ll_BFu32i()
{
  {
    init_simple_test("F_BFu17ll_BFu32i");
    static STRUCT_IF_C F_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "F_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "F_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu32i, F_BFu17ll_BFu32i)
//============================================================================



static void Test_F_BFu17ll_BFu32ll()
{
  {
    init_simple_test("F_BFu17ll_BFu32ll");
    static STRUCT_IF_C F_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "F_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "F_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu32ll, F_BFu17ll_BFu32ll)
//============================================================================



static void Test_F_BFu17ll_BFu33()
{
  {
    init_simple_test("F_BFu17ll_BFu33");
    static STRUCT_IF_C F_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, 1, "F_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, hide_ull(1LL<<32), "F_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu33, F_BFu17ll_BFu33)
//============================================================================



static void Test_F_BFu17ll_BFu7c()
{
  {
    init_simple_test("F_BFu17ll_BFu7c");
    static STRUCT_IF_C F_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu7c, F_BFu17ll_BFu7c)
//============================================================================



static void Test_F_BFu17ll_BFu7i()
{
  {
    init_simple_test("F_BFu17ll_BFu7i");
    static STRUCT_IF_C F_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu7i, F_BFu17ll_BFu7i)
//============================================================================



static void Test_F_BFu17ll_BFu7ll()
{
  {
    init_simple_test("F_BFu17ll_BFu7ll");
    static STRUCT_IF_C F_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu7ll, F_BFu17ll_BFu7ll)
//============================================================================



static void Test_F_BFu17ll_BFu7s()
{
  {
    init_simple_test("F_BFu17ll_BFu7s");
    static STRUCT_IF_C F_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "F_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "F_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu7s, F_BFu17ll_BFu7s)
//============================================================================



static void Test_F_BFu17ll_BFu8c()
{
  {
    init_simple_test("F_BFu17ll_BFu8c");
    static STRUCT_IF_C F_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu8c, F_BFu17ll_BFu8c)
//============================================================================



static void Test_F_BFu17ll_BFu8i()
{
  {
    init_simple_test("F_BFu17ll_BFu8i");
    static STRUCT_IF_C F_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu8i, F_BFu17ll_BFu8i)
//============================================================================



static void Test_F_BFu17ll_BFu8ll()
{
  {
    init_simple_test("F_BFu17ll_BFu8ll");
    static STRUCT_IF_C F_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu8ll, F_BFu17ll_BFu8ll)
//============================================================================



static void Test_F_BFu17ll_BFu8s()
{
  {
    init_simple_test("F_BFu17ll_BFu8s");
    static STRUCT_IF_C F_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "F_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "F_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu8s, F_BFu17ll_BFu8s)
//============================================================================



static void Test_F_BFu17ll_BFu9i()
{
  {
    init_simple_test("F_BFu17ll_BFu9i");
    static STRUCT_IF_C F_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "F_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "F_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu9i, F_BFu17ll_BFu9i)
//============================================================================



static void Test_F_BFu17ll_BFu9ll()
{
  {
    init_simple_test("F_BFu17ll_BFu9ll");
    static STRUCT_IF_C F_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "F_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "F_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu9ll, F_BFu17ll_BFu9ll)
//============================================================================



static void Test_F_BFu17ll_BFu9s()
{
  {
    init_simple_test("F_BFu17ll_BFu9s");
    static STRUCT_IF_C F_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "F_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "F_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_BFu9s, F_BFu17ll_BFu9s)
//============================================================================



static void Test_F_BFu17ll_C()
{
  {
    init_simple_test("F_BFu17ll_C");
    static STRUCT_IF_C F_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_C");
    check_field_offset(lv, v3, 7, "F_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_C, F_BFu17ll_C)
//============================================================================



static void Test_F_BFu17ll_D()
{
  {
    init_simple_test("F_BFu17ll_D");
    static STRUCT_IF_C F_BFu17ll_D lv;
    check2(sizeof(lv), 15, "sizeof(F_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_D");
    check_field_offset(lv, v3, 7, "F_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_D, F_BFu17ll_D)
//============================================================================



static void Test_F_BFu17ll_F()
{
  {
    init_simple_test("F_BFu17ll_F");
    static STRUCT_IF_C F_BFu17ll_F lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_F");
    check_field_offset(lv, v3, 7, "F_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_F, F_BFu17ll_F)
//============================================================================



static void Test_F_BFu17ll_I()
{
  {
    init_simple_test("F_BFu17ll_I");
    static STRUCT_IF_C F_BFu17ll_I lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_I");
    check_field_offset(lv, v3, 7, "F_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_I, F_BFu17ll_I)
//============================================================================



static void Test_F_BFu17ll_Ip()
{
  {
    init_simple_test("F_BFu17ll_Ip");
    static STRUCT_IF_C F_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(F_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_Ip");
    check_field_offset(lv, v3, 7, "F_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_Ip, F_BFu17ll_Ip)
//============================================================================



static void Test_F_BFu17ll_L()
{
  {
    init_simple_test("F_BFu17ll_L");
    static STRUCT_IF_C F_BFu17ll_L lv;
    check2(sizeof(lv), 15, "sizeof(F_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_L");
    check_field_offset(lv, v3, 7, "F_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_L, F_BFu17ll_L)
//============================================================================



static void Test_F_BFu17ll_S()
{
  {
    init_simple_test("F_BFu17ll_S");
    static STRUCT_IF_C F_BFu17ll_S lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_S");
    check_field_offset(lv, v3, 7, "F_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_S, F_BFu17ll_S)
//============================================================================



static void Test_F_BFu17ll_Uc()
{
  {
    init_simple_test("F_BFu17ll_Uc");
    static STRUCT_IF_C F_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_Uc");
    check_field_offset(lv, v3, 7, "F_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_Uc, F_BFu17ll_Uc)
//============================================================================



static void Test_F_BFu17ll_Ui()
{
  {
    init_simple_test("F_BFu17ll_Ui");
    static STRUCT_IF_C F_BFu17ll_Ui lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_Ui");
    check_field_offset(lv, v3, 7, "F_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_Ui, F_BFu17ll_Ui)
//============================================================================



static void Test_F_BFu17ll_Ul()
{
  {
    init_simple_test("F_BFu17ll_Ul");
    static STRUCT_IF_C F_BFu17ll_Ul lv;
    check2(sizeof(lv), 15, "sizeof(F_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_Ul");
    check_field_offset(lv, v3, 7, "F_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_Ul, F_BFu17ll_Ul)
//============================================================================



static void Test_F_BFu17ll_Us()
{
  {
    init_simple_test("F_BFu17ll_Us");
    static STRUCT_IF_C F_BFu17ll_Us lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_Us");
    check_field_offset(lv, v3, 7, "F_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_Us, F_BFu17ll_Us)
//============================================================================



static void Test_F_BFu17ll_Vp()
{
  {
    init_simple_test("F_BFu17ll_Vp");
    static STRUCT_IF_C F_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(F_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "F_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "F_BFu17ll_Vp");
    check_field_offset(lv, v3, 7, "F_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu17ll_Vp, F_BFu17ll_Vp)
//============================================================================



static void Test_F_BFu1c()
{
  {
    init_simple_test("F_BFu1c");
    static STRUCT_IF_C F_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c, F_BFu1c)
//============================================================================



static void Test_F_BFu1c_BFu15i()
{
  {
    init_simple_test("F_BFu1c_BFu15i");
    static STRUCT_IF_C F_BFu1c_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu15i, F_BFu1c_BFu15i)
//============================================================================



static void Test_F_BFu1c_BFu15ll()
{
  {
    init_simple_test("F_BFu1c_BFu15ll");
    static STRUCT_IF_C F_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu15ll, F_BFu1c_BFu15ll)
//============================================================================



static void Test_F_BFu1c_BFu15s()
{
  {
    init_simple_test("F_BFu1c_BFu15s");
    static STRUCT_IF_C F_BFu1c_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu15s, F_BFu1c_BFu15s)
//============================================================================



static void Test_F_BFu1c_BFu16i()
{
  {
    init_simple_test("F_BFu1c_BFu16i");
    static STRUCT_IF_C F_BFu1c_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu16i, F_BFu1c_BFu16i)
//============================================================================



static void Test_F_BFu1c_BFu16ll()
{
  {
    init_simple_test("F_BFu1c_BFu16ll");
    static STRUCT_IF_C F_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu16ll, F_BFu1c_BFu16ll)
//============================================================================



static void Test_F_BFu1c_BFu16s()
{
  {
    init_simple_test("F_BFu1c_BFu16s");
    static STRUCT_IF_C F_BFu1c_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu16s, F_BFu1c_BFu16s)
//============================================================================



static void Test_F_BFu1c_BFu17i()
{
  {
    init_simple_test("F_BFu1c_BFu17i");
    static STRUCT_IF_C F_BFu1c_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu17i, F_BFu1c_BFu17i)
//============================================================================



static void Test_F_BFu1c_BFu17ll()
{
  {
    init_simple_test("F_BFu1c_BFu17ll");
    static STRUCT_IF_C F_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu17ll, F_BFu1c_BFu17ll)
//============================================================================



static void Test_F_BFu1c_BFu1c()
{
  {
    init_simple_test("F_BFu1c_BFu1c");
    static STRUCT_IF_C F_BFu1c_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu1c, F_BFu1c_BFu1c)
//============================================================================



static void Test_F_BFu1c_BFu1i()
{
  {
    init_simple_test("F_BFu1c_BFu1i");
    static STRUCT_IF_C F_BFu1c_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu1i, F_BFu1c_BFu1i)
//============================================================================



static void Test_F_BFu1c_BFu1ll()
{
  {
    init_simple_test("F_BFu1c_BFu1ll");
    static STRUCT_IF_C F_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu1ll, F_BFu1c_BFu1ll)
//============================================================================



static void Test_F_BFu1c_BFu1s()
{
  {
    init_simple_test("F_BFu1c_BFu1s");
    static STRUCT_IF_C F_BFu1c_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu1s, F_BFu1c_BFu1s)
//============================================================================



static void Test_F_BFu1c_BFu31i()
{
  {
    init_simple_test("F_BFu1c_BFu31i");
    static STRUCT_IF_C F_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu31i, F_BFu1c_BFu31i)
//============================================================================



static void Test_F_BFu1c_BFu31ll()
{
  {
    init_simple_test("F_BFu1c_BFu31ll");
    static STRUCT_IF_C F_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu31ll, F_BFu1c_BFu31ll)
//============================================================================



static void Test_F_BFu1c_BFu32i()
{
  {
    init_simple_test("F_BFu1c_BFu32i");
    static STRUCT_IF_C F_BFu1c_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu32i, F_BFu1c_BFu32i)
//============================================================================



static void Test_F_BFu1c_BFu32ll()
{
  {
    init_simple_test("F_BFu1c_BFu32ll");
    static STRUCT_IF_C F_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu32ll, F_BFu1c_BFu32ll)
//============================================================================



static void Test_F_BFu1c_BFu33()
{
  {
    init_simple_test("F_BFu1c_BFu33");
    static STRUCT_IF_C F_BFu1c_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "F_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "F_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu33, F_BFu1c_BFu33)
//============================================================================



static void Test_F_BFu1c_BFu7c()
{
  {
    init_simple_test("F_BFu1c_BFu7c");
    static STRUCT_IF_C F_BFu1c_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu7c, F_BFu1c_BFu7c)
//============================================================================



static void Test_F_BFu1c_BFu7i()
{
  {
    init_simple_test("F_BFu1c_BFu7i");
    static STRUCT_IF_C F_BFu1c_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu7i, F_BFu1c_BFu7i)
//============================================================================



static void Test_F_BFu1c_BFu7ll()
{
  {
    init_simple_test("F_BFu1c_BFu7ll");
    static STRUCT_IF_C F_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu7ll, F_BFu1c_BFu7ll)
//============================================================================



static void Test_F_BFu1c_BFu7s()
{
  {
    init_simple_test("F_BFu1c_BFu7s");
    static STRUCT_IF_C F_BFu1c_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu7s, F_BFu1c_BFu7s)
//============================================================================



static void Test_F_BFu1c_BFu8c()
{
  {
    init_simple_test("F_BFu1c_BFu8c");
    static STRUCT_IF_C F_BFu1c_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu8c, F_BFu1c_BFu8c)
//============================================================================



static void Test_F_BFu1c_BFu8i()
{
  {
    init_simple_test("F_BFu1c_BFu8i");
    static STRUCT_IF_C F_BFu1c_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu8i, F_BFu1c_BFu8i)
//============================================================================



static void Test_F_BFu1c_BFu8ll()
{
  {
    init_simple_test("F_BFu1c_BFu8ll");
    static STRUCT_IF_C F_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu8ll, F_BFu1c_BFu8ll)
//============================================================================



static void Test_F_BFu1c_BFu8s()
{
  {
    init_simple_test("F_BFu1c_BFu8s");
    static STRUCT_IF_C F_BFu1c_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu8s, F_BFu1c_BFu8s)
//============================================================================



static void Test_F_BFu1c_BFu9i()
{
  {
    init_simple_test("F_BFu1c_BFu9i");
    static STRUCT_IF_C F_BFu1c_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu9i, F_BFu1c_BFu9i)
//============================================================================



static void Test_F_BFu1c_BFu9ll()
{
  {
    init_simple_test("F_BFu1c_BFu9ll");
    static STRUCT_IF_C F_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu9ll, F_BFu1c_BFu9ll)
//============================================================================



static void Test_F_BFu1c_BFu9s()
{
  {
    init_simple_test("F_BFu1c_BFu9s");
    static STRUCT_IF_C F_BFu1c_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_BFu9s, F_BFu1c_BFu9s)
//============================================================================



static void Test_F_BFu1c_C()
{
  {
    init_simple_test("F_BFu1c_C");
    static STRUCT_IF_C F_BFu1c_C lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_C)");
    check_field_offset(lv, v1, 0, "F_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_C");
    check_field_offset(lv, v3, 5, "F_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_C, F_BFu1c_C)
//============================================================================



static void Test_F_BFu1c_D()
{
  {
    init_simple_test("F_BFu1c_D");
    static STRUCT_IF_C F_BFu1c_D lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_D)");
    check_field_offset(lv, v1, 0, "F_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_D");
    check_field_offset(lv, v3, 5, "F_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_D, F_BFu1c_D)
//============================================================================



static void Test_F_BFu1c_F()
{
  {
    init_simple_test("F_BFu1c_F");
    static STRUCT_IF_C F_BFu1c_F lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_F)");
    check_field_offset(lv, v1, 0, "F_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_F");
    check_field_offset(lv, v3, 5, "F_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_F, F_BFu1c_F)
//============================================================================



static void Test_F_BFu1c_I()
{
  {
    init_simple_test("F_BFu1c_I");
    static STRUCT_IF_C F_BFu1c_I lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_I)");
    check_field_offset(lv, v1, 0, "F_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_I");
    check_field_offset(lv, v3, 5, "F_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_I, F_BFu1c_I)
//============================================================================



static void Test_F_BFu1c_Ip()
{
  {
    init_simple_test("F_BFu1c_Ip");
    static STRUCT_IF_C F_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_Ip");
    check_field_offset(lv, v3, 5, "F_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_Ip, F_BFu1c_Ip)
//============================================================================



static void Test_F_BFu1c_L()
{
  {
    init_simple_test("F_BFu1c_L");
    static STRUCT_IF_C F_BFu1c_L lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_L)");
    check_field_offset(lv, v1, 0, "F_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_L");
    check_field_offset(lv, v3, 5, "F_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_L, F_BFu1c_L)
//============================================================================



static void Test_F_BFu1c_S()
{
  {
    init_simple_test("F_BFu1c_S");
    static STRUCT_IF_C F_BFu1c_S lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_S)");
    check_field_offset(lv, v1, 0, "F_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_S");
    check_field_offset(lv, v3, 5, "F_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_S, F_BFu1c_S)
//============================================================================



static void Test_F_BFu1c_Uc()
{
  {
    init_simple_test("F_BFu1c_Uc");
    static STRUCT_IF_C F_BFu1c_Uc lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_Uc, F_BFu1c_Uc)
//============================================================================



static void Test_F_BFu1c_Ui()
{
  {
    init_simple_test("F_BFu1c_Ui");
    static STRUCT_IF_C F_BFu1c_Ui lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_Ui");
    check_field_offset(lv, v3, 5, "F_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_Ui, F_BFu1c_Ui)
//============================================================================



static void Test_F_BFu1c_Ul()
{
  {
    init_simple_test("F_BFu1c_Ul");
    static STRUCT_IF_C F_BFu1c_Ul lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_Ul");
    check_field_offset(lv, v3, 5, "F_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_Ul, F_BFu1c_Ul)
//============================================================================



static void Test_F_BFu1c_Us()
{
  {
    init_simple_test("F_BFu1c_Us");
    static STRUCT_IF_C F_BFu1c_Us lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_Us");
    check_field_offset(lv, v3, 5, "F_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_Us, F_BFu1c_Us)
//============================================================================



static void Test_F_BFu1c_Vp()
{
  {
    init_simple_test("F_BFu1c_Vp");
    static STRUCT_IF_C F_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1c_Vp");
    check_field_offset(lv, v3, 5, "F_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1c_Vp, F_BFu1c_Vp)
//============================================================================



static void Test_F_BFu1i()
{
  {
    init_simple_test("F_BFu1i");
    static STRUCT_IF_C F_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i, F_BFu1i)
//============================================================================



static void Test_F_BFu1i_BFu15i()
{
  {
    init_simple_test("F_BFu1i_BFu15i");
    static STRUCT_IF_C F_BFu1i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu15i, F_BFu1i_BFu15i)
//============================================================================



static void Test_F_BFu1i_BFu15ll()
{
  {
    init_simple_test("F_BFu1i_BFu15ll");
    static STRUCT_IF_C F_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu15ll, F_BFu1i_BFu15ll)
//============================================================================



static void Test_F_BFu1i_BFu15s()
{
  {
    init_simple_test("F_BFu1i_BFu15s");
    static STRUCT_IF_C F_BFu1i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu15s, F_BFu1i_BFu15s)
//============================================================================



static void Test_F_BFu1i_BFu16i()
{
  {
    init_simple_test("F_BFu1i_BFu16i");
    static STRUCT_IF_C F_BFu1i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu16i, F_BFu1i_BFu16i)
//============================================================================



static void Test_F_BFu1i_BFu16ll()
{
  {
    init_simple_test("F_BFu1i_BFu16ll");
    static STRUCT_IF_C F_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu16ll, F_BFu1i_BFu16ll)
//============================================================================



static void Test_F_BFu1i_BFu16s()
{
  {
    init_simple_test("F_BFu1i_BFu16s");
    static STRUCT_IF_C F_BFu1i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu16s, F_BFu1i_BFu16s)
//============================================================================



static void Test_F_BFu1i_BFu17i()
{
  {
    init_simple_test("F_BFu1i_BFu17i");
    static STRUCT_IF_C F_BFu1i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu17i, F_BFu1i_BFu17i)
//============================================================================



static void Test_F_BFu1i_BFu17ll()
{
  {
    init_simple_test("F_BFu1i_BFu17ll");
    static STRUCT_IF_C F_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu17ll, F_BFu1i_BFu17ll)
//============================================================================



static void Test_F_BFu1i_BFu1c()
{
  {
    init_simple_test("F_BFu1i_BFu1c");
    static STRUCT_IF_C F_BFu1i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu1c, F_BFu1i_BFu1c)
//============================================================================



static void Test_F_BFu1i_BFu1i()
{
  {
    init_simple_test("F_BFu1i_BFu1i");
    static STRUCT_IF_C F_BFu1i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu1i, F_BFu1i_BFu1i)
//============================================================================



static void Test_F_BFu1i_BFu1ll()
{
  {
    init_simple_test("F_BFu1i_BFu1ll");
    static STRUCT_IF_C F_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu1ll, F_BFu1i_BFu1ll)
//============================================================================



static void Test_F_BFu1i_BFu1s()
{
  {
    init_simple_test("F_BFu1i_BFu1s");
    static STRUCT_IF_C F_BFu1i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu1s, F_BFu1i_BFu1s)
//============================================================================



static void Test_F_BFu1i_BFu31i()
{
  {
    init_simple_test("F_BFu1i_BFu31i");
    static STRUCT_IF_C F_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu31i, F_BFu1i_BFu31i)
//============================================================================



static void Test_F_BFu1i_BFu31ll()
{
  {
    init_simple_test("F_BFu1i_BFu31ll");
    static STRUCT_IF_C F_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu31ll, F_BFu1i_BFu31ll)
//============================================================================



static void Test_F_BFu1i_BFu32i()
{
  {
    init_simple_test("F_BFu1i_BFu32i");
    static STRUCT_IF_C F_BFu1i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu32i, F_BFu1i_BFu32i)
//============================================================================



static void Test_F_BFu1i_BFu32ll()
{
  {
    init_simple_test("F_BFu1i_BFu32ll");
    static STRUCT_IF_C F_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu32ll, F_BFu1i_BFu32ll)
//============================================================================



static void Test_F_BFu1i_BFu33()
{
  {
    init_simple_test("F_BFu1i_BFu33");
    static STRUCT_IF_C F_BFu1i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "F_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "F_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu33, F_BFu1i_BFu33)
//============================================================================



static void Test_F_BFu1i_BFu7c()
{
  {
    init_simple_test("F_BFu1i_BFu7c");
    static STRUCT_IF_C F_BFu1i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu7c, F_BFu1i_BFu7c)
//============================================================================



static void Test_F_BFu1i_BFu7i()
{
  {
    init_simple_test("F_BFu1i_BFu7i");
    static STRUCT_IF_C F_BFu1i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu7i, F_BFu1i_BFu7i)
//============================================================================



static void Test_F_BFu1i_BFu7ll()
{
  {
    init_simple_test("F_BFu1i_BFu7ll");
    static STRUCT_IF_C F_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu7ll, F_BFu1i_BFu7ll)
//============================================================================



static void Test_F_BFu1i_BFu7s()
{
  {
    init_simple_test("F_BFu1i_BFu7s");
    static STRUCT_IF_C F_BFu1i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu7s, F_BFu1i_BFu7s)
//============================================================================



static void Test_F_BFu1i_BFu8c()
{
  {
    init_simple_test("F_BFu1i_BFu8c");
    static STRUCT_IF_C F_BFu1i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu8c, F_BFu1i_BFu8c)
//============================================================================



static void Test_F_BFu1i_BFu8i()
{
  {
    init_simple_test("F_BFu1i_BFu8i");
    static STRUCT_IF_C F_BFu1i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu8i, F_BFu1i_BFu8i)
//============================================================================



static void Test_F_BFu1i_BFu8ll()
{
  {
    init_simple_test("F_BFu1i_BFu8ll");
    static STRUCT_IF_C F_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu8ll, F_BFu1i_BFu8ll)
//============================================================================



static void Test_F_BFu1i_BFu8s()
{
  {
    init_simple_test("F_BFu1i_BFu8s");
    static STRUCT_IF_C F_BFu1i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu8s, F_BFu1i_BFu8s)
//============================================================================



static void Test_F_BFu1i_BFu9i()
{
  {
    init_simple_test("F_BFu1i_BFu9i");
    static STRUCT_IF_C F_BFu1i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu9i, F_BFu1i_BFu9i)
//============================================================================



static void Test_F_BFu1i_BFu9ll()
{
  {
    init_simple_test("F_BFu1i_BFu9ll");
    static STRUCT_IF_C F_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu9ll, F_BFu1i_BFu9ll)
//============================================================================



static void Test_F_BFu1i_BFu9s()
{
  {
    init_simple_test("F_BFu1i_BFu9s");
    static STRUCT_IF_C F_BFu1i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_BFu9s, F_BFu1i_BFu9s)
//============================================================================



static void Test_F_BFu1i_C()
{
  {
    init_simple_test("F_BFu1i_C");
    static STRUCT_IF_C F_BFu1i_C lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_C)");
    check_field_offset(lv, v1, 0, "F_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_C");
    check_field_offset(lv, v3, 5, "F_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_C, F_BFu1i_C)
//============================================================================



static void Test_F_BFu1i_D()
{
  {
    init_simple_test("F_BFu1i_D");
    static STRUCT_IF_C F_BFu1i_D lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_D)");
    check_field_offset(lv, v1, 0, "F_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_D");
    check_field_offset(lv, v3, 5, "F_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_D, F_BFu1i_D)
//============================================================================



static void Test_F_BFu1i_F()
{
  {
    init_simple_test("F_BFu1i_F");
    static STRUCT_IF_C F_BFu1i_F lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_F)");
    check_field_offset(lv, v1, 0, "F_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_F");
    check_field_offset(lv, v3, 5, "F_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_F, F_BFu1i_F)
//============================================================================



static void Test_F_BFu1i_I()
{
  {
    init_simple_test("F_BFu1i_I");
    static STRUCT_IF_C F_BFu1i_I lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_I)");
    check_field_offset(lv, v1, 0, "F_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_I");
    check_field_offset(lv, v3, 5, "F_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_I, F_BFu1i_I)
//============================================================================



static void Test_F_BFu1i_Ip()
{
  {
    init_simple_test("F_BFu1i_Ip");
    static STRUCT_IF_C F_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Ip");
    check_field_offset(lv, v3, 5, "F_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Ip, F_BFu1i_Ip)
//============================================================================



static void Test_F_BFu1i_L()
{
  {
    init_simple_test("F_BFu1i_L");
    static STRUCT_IF_C F_BFu1i_L lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_L)");
    check_field_offset(lv, v1, 0, "F_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_L");
    check_field_offset(lv, v3, 5, "F_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_L, F_BFu1i_L)
//============================================================================



static void Test_F_BFu1i_S()
{
  {
    init_simple_test("F_BFu1i_S");
    static STRUCT_IF_C F_BFu1i_S lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_S)");
    check_field_offset(lv, v1, 0, "F_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_S");
    check_field_offset(lv, v3, 5, "F_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_S, F_BFu1i_S)
//============================================================================



static void Test_F_BFu1i_Uc()
{
  {
    init_simple_test("F_BFu1i_Uc");
    static STRUCT_IF_C F_BFu1i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Uc, F_BFu1i_Uc)
//============================================================================



static void Test_F_BFu1i_Ui()
{
  {
    init_simple_test("F_BFu1i_Ui");
    static STRUCT_IF_C F_BFu1i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Ui");
    check_field_offset(lv, v3, 5, "F_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Ui, F_BFu1i_Ui)
//============================================================================



static void Test_F_BFu1i_Ul()
{
  {
    init_simple_test("F_BFu1i_Ul");
    static STRUCT_IF_C F_BFu1i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Ul");
    check_field_offset(lv, v3, 5, "F_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Ul, F_BFu1i_Ul)
//============================================================================



static void Test_F_BFu1i_Us()
{
  {
    init_simple_test("F_BFu1i_Us");
    static STRUCT_IF_C F_BFu1i_Us lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Us");
    check_field_offset(lv, v3, 5, "F_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Us, F_BFu1i_Us)
//============================================================================



static void Test_F_BFu1i_Vp()
{
  {
    init_simple_test("F_BFu1i_Vp");
    static STRUCT_IF_C F_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1i_Vp");
    check_field_offset(lv, v3, 5, "F_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1i_Vp, F_BFu1i_Vp)
//============================================================================



static void Test_F_BFu1ll()
{
  {
    init_simple_test("F_BFu1ll");
    static STRUCT_IF_C F_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll, F_BFu1ll)
//============================================================================



static void Test_F_BFu1ll_BFu15i()
{
  {
    init_simple_test("F_BFu1ll_BFu15i");
    static STRUCT_IF_C F_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu15i, F_BFu1ll_BFu15i)
//============================================================================



static void Test_F_BFu1ll_BFu15ll()
{
  {
    init_simple_test("F_BFu1ll_BFu15ll");
    static STRUCT_IF_C F_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu15ll, F_BFu1ll_BFu15ll)
//============================================================================



static void Test_F_BFu1ll_BFu15s()
{
  {
    init_simple_test("F_BFu1ll_BFu15s");
    static STRUCT_IF_C F_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu15s, F_BFu1ll_BFu15s)
//============================================================================



static void Test_F_BFu1ll_BFu16i()
{
  {
    init_simple_test("F_BFu1ll_BFu16i");
    static STRUCT_IF_C F_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu16i, F_BFu1ll_BFu16i)
//============================================================================



static void Test_F_BFu1ll_BFu16ll()
{
  {
    init_simple_test("F_BFu1ll_BFu16ll");
    static STRUCT_IF_C F_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu16ll, F_BFu1ll_BFu16ll)
//============================================================================



static void Test_F_BFu1ll_BFu16s()
{
  {
    init_simple_test("F_BFu1ll_BFu16s");
    static STRUCT_IF_C F_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu16s, F_BFu1ll_BFu16s)
//============================================================================



static void Test_F_BFu1ll_BFu17i()
{
  {
    init_simple_test("F_BFu1ll_BFu17i");
    static STRUCT_IF_C F_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu17i, F_BFu1ll_BFu17i)
//============================================================================



static void Test_F_BFu1ll_BFu17ll()
{
  {
    init_simple_test("F_BFu1ll_BFu17ll");
    static STRUCT_IF_C F_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu17ll, F_BFu1ll_BFu17ll)
//============================================================================



static void Test_F_BFu1ll_BFu1c()
{
  {
    init_simple_test("F_BFu1ll_BFu1c");
    static STRUCT_IF_C F_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1c, F_BFu1ll_BFu1c)
//============================================================================



static void Test_F_BFu1ll_BFu1i()
{
  {
    init_simple_test("F_BFu1ll_BFu1i");
    static STRUCT_IF_C F_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1i, F_BFu1ll_BFu1i)
//============================================================================



static void Test_F_BFu1ll_BFu1ll()
{
  {
    init_simple_test("F_BFu1ll_BFu1ll");
    static STRUCT_IF_C F_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1ll, F_BFu1ll_BFu1ll)
//============================================================================



static void Test_F_BFu1ll_BFu1s()
{
  {
    init_simple_test("F_BFu1ll_BFu1s");
    static STRUCT_IF_C F_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu1s, F_BFu1ll_BFu1s)
//============================================================================



static void Test_F_BFu1ll_BFu31i()
{
  {
    init_simple_test("F_BFu1ll_BFu31i");
    static STRUCT_IF_C F_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu31i, F_BFu1ll_BFu31i)
//============================================================================



static void Test_F_BFu1ll_BFu31ll()
{
  {
    init_simple_test("F_BFu1ll_BFu31ll");
    static STRUCT_IF_C F_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu31ll, F_BFu1ll_BFu31ll)
//============================================================================



static void Test_F_BFu1ll_BFu32i()
{
  {
    init_simple_test("F_BFu1ll_BFu32i");
    static STRUCT_IF_C F_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu32i, F_BFu1ll_BFu32i)
//============================================================================



static void Test_F_BFu1ll_BFu32ll()
{
  {
    init_simple_test("F_BFu1ll_BFu32ll");
    static STRUCT_IF_C F_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu32ll, F_BFu1ll_BFu32ll)
//============================================================================



static void Test_F_BFu1ll_BFu33()
{
  {
    init_simple_test("F_BFu1ll_BFu33");
    static STRUCT_IF_C F_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "F_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "F_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu33, F_BFu1ll_BFu33)
//============================================================================



static void Test_F_BFu1ll_BFu7c()
{
  {
    init_simple_test("F_BFu1ll_BFu7c");
    static STRUCT_IF_C F_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7c, F_BFu1ll_BFu7c)
//============================================================================



static void Test_F_BFu1ll_BFu7i()
{
  {
    init_simple_test("F_BFu1ll_BFu7i");
    static STRUCT_IF_C F_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7i, F_BFu1ll_BFu7i)
//============================================================================



static void Test_F_BFu1ll_BFu7ll()
{
  {
    init_simple_test("F_BFu1ll_BFu7ll");
    static STRUCT_IF_C F_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7ll, F_BFu1ll_BFu7ll)
//============================================================================



static void Test_F_BFu1ll_BFu7s()
{
  {
    init_simple_test("F_BFu1ll_BFu7s");
    static STRUCT_IF_C F_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu7s, F_BFu1ll_BFu7s)
//============================================================================



static void Test_F_BFu1ll_BFu8c()
{
  {
    init_simple_test("F_BFu1ll_BFu8c");
    static STRUCT_IF_C F_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8c, F_BFu1ll_BFu8c)
//============================================================================



static void Test_F_BFu1ll_BFu8i()
{
  {
    init_simple_test("F_BFu1ll_BFu8i");
    static STRUCT_IF_C F_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8i, F_BFu1ll_BFu8i)
//============================================================================



static void Test_F_BFu1ll_BFu8ll()
{
  {
    init_simple_test("F_BFu1ll_BFu8ll");
    static STRUCT_IF_C F_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8ll, F_BFu1ll_BFu8ll)
//============================================================================



static void Test_F_BFu1ll_BFu8s()
{
  {
    init_simple_test("F_BFu1ll_BFu8s");
    static STRUCT_IF_C F_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu8s, F_BFu1ll_BFu8s)
//============================================================================



static void Test_F_BFu1ll_BFu9i()
{
  {
    init_simple_test("F_BFu1ll_BFu9i");
    static STRUCT_IF_C F_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu9i, F_BFu1ll_BFu9i)
//============================================================================



static void Test_F_BFu1ll_BFu9ll()
{
  {
    init_simple_test("F_BFu1ll_BFu9ll");
    static STRUCT_IF_C F_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu9ll, F_BFu1ll_BFu9ll)
//============================================================================



static void Test_F_BFu1ll_BFu9s()
{
  {
    init_simple_test("F_BFu1ll_BFu9s");
    static STRUCT_IF_C F_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_BFu9s, F_BFu1ll_BFu9s)
//============================================================================



static void Test_F_BFu1ll_C()
{
  {
    init_simple_test("F_BFu1ll_C");
    static STRUCT_IF_C F_BFu1ll_C lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_C");
    check_field_offset(lv, v3, 5, "F_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_C, F_BFu1ll_C)
//============================================================================



static void Test_F_BFu1ll_D()
{
  {
    init_simple_test("F_BFu1ll_D");
    static STRUCT_IF_C F_BFu1ll_D lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_D");
    check_field_offset(lv, v3, 5, "F_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_D, F_BFu1ll_D)
//============================================================================



static void Test_F_BFu1ll_F()
{
  {
    init_simple_test("F_BFu1ll_F");
    static STRUCT_IF_C F_BFu1ll_F lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_F");
    check_field_offset(lv, v3, 5, "F_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_F, F_BFu1ll_F)
//============================================================================



static void Test_F_BFu1ll_I()
{
  {
    init_simple_test("F_BFu1ll_I");
    static STRUCT_IF_C F_BFu1ll_I lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_I");
    check_field_offset(lv, v3, 5, "F_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_I, F_BFu1ll_I)
//============================================================================



static void Test_F_BFu1ll_Ip()
{
  {
    init_simple_test("F_BFu1ll_Ip");
    static STRUCT_IF_C F_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Ip");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Ip, F_BFu1ll_Ip)
//============================================================================



static void Test_F_BFu1ll_L()
{
  {
    init_simple_test("F_BFu1ll_L");
    static STRUCT_IF_C F_BFu1ll_L lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_L");
    check_field_offset(lv, v3, 5, "F_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_L, F_BFu1ll_L)
//============================================================================



static void Test_F_BFu1ll_S()
{
  {
    init_simple_test("F_BFu1ll_S");
    static STRUCT_IF_C F_BFu1ll_S lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_S");
    check_field_offset(lv, v3, 5, "F_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_S, F_BFu1ll_S)
//============================================================================



static void Test_F_BFu1ll_Uc()
{
  {
    init_simple_test("F_BFu1ll_Uc");
    static STRUCT_IF_C F_BFu1ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Uc, F_BFu1ll_Uc)
//============================================================================



static void Test_F_BFu1ll_Ui()
{
  {
    init_simple_test("F_BFu1ll_Ui");
    static STRUCT_IF_C F_BFu1ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Ui");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Ui, F_BFu1ll_Ui)
//============================================================================



static void Test_F_BFu1ll_Ul()
{
  {
    init_simple_test("F_BFu1ll_Ul");
    static STRUCT_IF_C F_BFu1ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Ul");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Ul, F_BFu1ll_Ul)
//============================================================================



static void Test_F_BFu1ll_Us()
{
  {
    init_simple_test("F_BFu1ll_Us");
    static STRUCT_IF_C F_BFu1ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Us");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Us, F_BFu1ll_Us)
//============================================================================



static void Test_F_BFu1ll_Vp()
{
  {
    init_simple_test("F_BFu1ll_Vp");
    static STRUCT_IF_C F_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1ll_Vp");
    check_field_offset(lv, v3, 5, "F_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1ll_Vp, F_BFu1ll_Vp)
//============================================================================



static void Test_F_BFu1s()
{
  {
    init_simple_test("F_BFu1s");
    static STRUCT_IF_C F_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s, F_BFu1s)
//============================================================================



static void Test_F_BFu1s_BFu15i()
{
  {
    init_simple_test("F_BFu1s_BFu15i");
    static STRUCT_IF_C F_BFu1s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu15i, F_BFu1s_BFu15i)
//============================================================================



static void Test_F_BFu1s_BFu15ll()
{
  {
    init_simple_test("F_BFu1s_BFu15ll");
    static STRUCT_IF_C F_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu15ll, F_BFu1s_BFu15ll)
//============================================================================



static void Test_F_BFu1s_BFu15s()
{
  {
    init_simple_test("F_BFu1s_BFu15s");
    static STRUCT_IF_C F_BFu1s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "F_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "F_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu15s, F_BFu1s_BFu15s)
//============================================================================



static void Test_F_BFu1s_BFu16i()
{
  {
    init_simple_test("F_BFu1s_BFu16i");
    static STRUCT_IF_C F_BFu1s_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu16i, F_BFu1s_BFu16i)
//============================================================================



static void Test_F_BFu1s_BFu16ll()
{
  {
    init_simple_test("F_BFu1s_BFu16ll");
    static STRUCT_IF_C F_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu16ll, F_BFu1s_BFu16ll)
//============================================================================



static void Test_F_BFu1s_BFu16s()
{
  {
    init_simple_test("F_BFu1s_BFu16s");
    static STRUCT_IF_C F_BFu1s_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "F_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "F_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu16s, F_BFu1s_BFu16s)
//============================================================================



static void Test_F_BFu1s_BFu17i()
{
  {
    init_simple_test("F_BFu1s_BFu17i");
    static STRUCT_IF_C F_BFu1s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu17i, F_BFu1s_BFu17i)
//============================================================================



static void Test_F_BFu1s_BFu17ll()
{
  {
    init_simple_test("F_BFu1s_BFu17ll");
    static STRUCT_IF_C F_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "F_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "F_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu17ll, F_BFu1s_BFu17ll)
//============================================================================



static void Test_F_BFu1s_BFu1c()
{
  {
    init_simple_test("F_BFu1s_BFu1c");
    static STRUCT_IF_C F_BFu1s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1c, F_BFu1s_BFu1c)
//============================================================================



static void Test_F_BFu1s_BFu1i()
{
  {
    init_simple_test("F_BFu1s_BFu1i");
    static STRUCT_IF_C F_BFu1s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1i, F_BFu1s_BFu1i)
//============================================================================



static void Test_F_BFu1s_BFu1ll()
{
  {
    init_simple_test("F_BFu1s_BFu1ll");
    static STRUCT_IF_C F_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1ll, F_BFu1s_BFu1ll)
//============================================================================



static void Test_F_BFu1s_BFu1s()
{
  {
    init_simple_test("F_BFu1s_BFu1s");
    static STRUCT_IF_C F_BFu1s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "F_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu1s, F_BFu1s_BFu1s)
//============================================================================



static void Test_F_BFu1s_BFu31i()
{
  {
    init_simple_test("F_BFu1s_BFu31i");
    static STRUCT_IF_C F_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu31i, F_BFu1s_BFu31i)
//============================================================================



static void Test_F_BFu1s_BFu31ll()
{
  {
    init_simple_test("F_BFu1s_BFu31ll");
    static STRUCT_IF_C F_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "F_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "F_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu31ll, F_BFu1s_BFu31ll)
//============================================================================



static void Test_F_BFu1s_BFu32i()
{
  {
    init_simple_test("F_BFu1s_BFu32i");
    static STRUCT_IF_C F_BFu1s_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu32i, F_BFu1s_BFu32i)
//============================================================================



static void Test_F_BFu1s_BFu32ll()
{
  {
    init_simple_test("F_BFu1s_BFu32ll");
    static STRUCT_IF_C F_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "F_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "F_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu32ll, F_BFu1s_BFu32ll)
//============================================================================



static void Test_F_BFu1s_BFu33()
{
  {
    init_simple_test("F_BFu1s_BFu33");
    static STRUCT_IF_C F_BFu1s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "F_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "F_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu33, F_BFu1s_BFu33)
//============================================================================



static void Test_F_BFu1s_BFu7c()
{
  {
    init_simple_test("F_BFu1s_BFu7c");
    static STRUCT_IF_C F_BFu1s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7c, F_BFu1s_BFu7c)
//============================================================================



static void Test_F_BFu1s_BFu7i()
{
  {
    init_simple_test("F_BFu1s_BFu7i");
    static STRUCT_IF_C F_BFu1s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7i, F_BFu1s_BFu7i)
//============================================================================



static void Test_F_BFu1s_BFu7ll()
{
  {
    init_simple_test("F_BFu1s_BFu7ll");
    static STRUCT_IF_C F_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7ll, F_BFu1s_BFu7ll)
//============================================================================



static void Test_F_BFu1s_BFu7s()
{
  {
    init_simple_test("F_BFu1s_BFu7s");
    static STRUCT_IF_C F_BFu1s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(F_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "F_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "F_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu7s, F_BFu1s_BFu7s)
//============================================================================



static void Test_F_BFu1s_BFu8c()
{
  {
    init_simple_test("F_BFu1s_BFu8c");
    static STRUCT_IF_C F_BFu1s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8c, F_BFu1s_BFu8c)
//============================================================================



static void Test_F_BFu1s_BFu8i()
{
  {
    init_simple_test("F_BFu1s_BFu8i");
    static STRUCT_IF_C F_BFu1s_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8i, F_BFu1s_BFu8i)
//============================================================================



static void Test_F_BFu1s_BFu8ll()
{
  {
    init_simple_test("F_BFu1s_BFu8ll");
    static STRUCT_IF_C F_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8ll, F_BFu1s_BFu8ll)
//============================================================================



static void Test_F_BFu1s_BFu8s()
{
  {
    init_simple_test("F_BFu1s_BFu8s");
    static STRUCT_IF_C F_BFu1s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "F_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "F_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu8s, F_BFu1s_BFu8s)
//============================================================================



static void Test_F_BFu1s_BFu9i()
{
  {
    init_simple_test("F_BFu1s_BFu9i");
    static STRUCT_IF_C F_BFu1s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu9i, F_BFu1s_BFu9i)
//============================================================================



static void Test_F_BFu1s_BFu9ll()
{
  {
    init_simple_test("F_BFu1s_BFu9ll");
    static STRUCT_IF_C F_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu9ll, F_BFu1s_BFu9ll)
//============================================================================



static void Test_F_BFu1s_BFu9s()
{
  {
    init_simple_test("F_BFu1s_BFu9s");
    static STRUCT_IF_C F_BFu1s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "F_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "F_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_BFu9s, F_BFu1s_BFu9s)
//============================================================================



static void Test_F_BFu1s_C()
{
  {
    init_simple_test("F_BFu1s_C");
    static STRUCT_IF_C F_BFu1s_C lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_C)");
    check_field_offset(lv, v1, 0, "F_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_C");
    check_field_offset(lv, v3, 5, "F_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_C, F_BFu1s_C)
//============================================================================



static void Test_F_BFu1s_D()
{
  {
    init_simple_test("F_BFu1s_D");
    static STRUCT_IF_C F_BFu1s_D lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_D)");
    check_field_offset(lv, v1, 0, "F_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_D");
    check_field_offset(lv, v3, 5, "F_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_D, F_BFu1s_D)
//============================================================================



static void Test_F_BFu1s_F()
{
  {
    init_simple_test("F_BFu1s_F");
    static STRUCT_IF_C F_BFu1s_F lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_F)");
    check_field_offset(lv, v1, 0, "F_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_F");
    check_field_offset(lv, v3, 5, "F_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_F, F_BFu1s_F)
//============================================================================



static void Test_F_BFu1s_I()
{
  {
    init_simple_test("F_BFu1s_I");
    static STRUCT_IF_C F_BFu1s_I lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_I)");
    check_field_offset(lv, v1, 0, "F_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_I");
    check_field_offset(lv, v3, 5, "F_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_I, F_BFu1s_I)
//============================================================================



static void Test_F_BFu1s_Ip()
{
  {
    init_simple_test("F_BFu1s_Ip");
    static STRUCT_IF_C F_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Ip");
    check_field_offset(lv, v3, 5, "F_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Ip, F_BFu1s_Ip)
//============================================================================



static void Test_F_BFu1s_L()
{
  {
    init_simple_test("F_BFu1s_L");
    static STRUCT_IF_C F_BFu1s_L lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_L)");
    check_field_offset(lv, v1, 0, "F_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_L");
    check_field_offset(lv, v3, 5, "F_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_L, F_BFu1s_L)
//============================================================================



static void Test_F_BFu1s_S()
{
  {
    init_simple_test("F_BFu1s_S");
    static STRUCT_IF_C F_BFu1s_S lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_S)");
    check_field_offset(lv, v1, 0, "F_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_S");
    check_field_offset(lv, v3, 5, "F_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_S, F_BFu1s_S)
//============================================================================



static void Test_F_BFu1s_Uc()
{
  {
    init_simple_test("F_BFu1s_Uc");
    static STRUCT_IF_C F_BFu1s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(F_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Uc");
    check_field_offset(lv, v3, 5, "F_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Uc, F_BFu1s_Uc)
//============================================================================



static void Test_F_BFu1s_Ui()
{
  {
    init_simple_test("F_BFu1s_Ui");
    static STRUCT_IF_C F_BFu1s_Ui lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Ui");
    check_field_offset(lv, v3, 5, "F_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Ui, F_BFu1s_Ui)
//============================================================================



static void Test_F_BFu1s_Ul()
{
  {
    init_simple_test("F_BFu1s_Ul");
    static STRUCT_IF_C F_BFu1s_Ul lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Ul");
    check_field_offset(lv, v3, 5, "F_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Ul, F_BFu1s_Ul)
//============================================================================



static void Test_F_BFu1s_Us()
{
  {
    init_simple_test("F_BFu1s_Us");
    static STRUCT_IF_C F_BFu1s_Us lv;
    check2(sizeof(lv), 7, "sizeof(F_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Us");
    check_field_offset(lv, v3, 5, "F_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Us, F_BFu1s_Us)
//============================================================================



static void Test_F_BFu1s_Vp()
{
  {
    init_simple_test("F_BFu1s_Vp");
    static STRUCT_IF_C F_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(F_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "F_BFu1s_Vp");
    check_field_offset(lv, v3, 5, "F_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu1s_Vp, F_BFu1s_Vp)
//============================================================================



static void Test_F_BFu31i()
{
  {
    init_simple_test("F_BFu31i");
    static STRUCT_IF_C F_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i, F_BFu31i)
//============================================================================



static void Test_F_BFu31i_BFu15i()
{
  {
    init_simple_test("F_BFu31i_BFu15i");
    static STRUCT_IF_C F_BFu31i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "F_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "F_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu15i, F_BFu31i_BFu15i)
//============================================================================



static void Test_F_BFu31i_BFu15ll()
{
  {
    init_simple_test("F_BFu31i_BFu15ll");
    static STRUCT_IF_C F_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "F_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "F_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu15ll, F_BFu31i_BFu15ll)
//============================================================================



static void Test_F_BFu31i_BFu15s()
{
  {
    init_simple_test("F_BFu31i_BFu15s");
    static STRUCT_IF_C F_BFu31i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "F_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "F_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu15s, F_BFu31i_BFu15s)
//============================================================================



static void Test_F_BFu31i_BFu16i()
{
  {
    init_simple_test("F_BFu31i_BFu16i");
    static STRUCT_IF_C F_BFu31i_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "F_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "F_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu16i, F_BFu31i_BFu16i)
//============================================================================



static void Test_F_BFu31i_BFu16ll()
{
  {
    init_simple_test("F_BFu31i_BFu16ll");
    static STRUCT_IF_C F_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "F_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "F_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu16ll, F_BFu31i_BFu16ll)
//============================================================================



static void Test_F_BFu31i_BFu16s()
{
  {
    init_simple_test("F_BFu31i_BFu16s");
    static STRUCT_IF_C F_BFu31i_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "F_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "F_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu16s, F_BFu31i_BFu16s)
//============================================================================



static void Test_F_BFu31i_BFu17i()
{
  {
    init_simple_test("F_BFu31i_BFu17i");
    static STRUCT_IF_C F_BFu31i_BFu17i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "F_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "F_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu17i, F_BFu31i_BFu17i)
//============================================================================



static void Test_F_BFu31i_BFu17ll()
{
  {
    init_simple_test("F_BFu31i_BFu17ll");
    static STRUCT_IF_C F_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "F_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "F_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu17ll, F_BFu31i_BFu17ll)
//============================================================================



static void Test_F_BFu31i_BFu1c()
{
  {
    init_simple_test("F_BFu31i_BFu1c");
    static STRUCT_IF_C F_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1c, F_BFu31i_BFu1c)
//============================================================================



static void Test_F_BFu31i_BFu1i()
{
  {
    init_simple_test("F_BFu31i_BFu1i");
    static STRUCT_IF_C F_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1i, F_BFu31i_BFu1i)
//============================================================================



static void Test_F_BFu31i_BFu1ll()
{
  {
    init_simple_test("F_BFu31i_BFu1ll");
    static STRUCT_IF_C F_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1ll, F_BFu31i_BFu1ll)
//============================================================================



static void Test_F_BFu31i_BFu1s()
{
  {
    init_simple_test("F_BFu31i_BFu1s");
    static STRUCT_IF_C F_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu1s, F_BFu31i_BFu1s)
//============================================================================



static void Test_F_BFu31i_BFu31i()
{
  {
    init_simple_test("F_BFu31i_BFu31i");
    static STRUCT_IF_C F_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "F_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu31i, F_BFu31i_BFu31i)
//============================================================================



static void Test_F_BFu31i_BFu31ll()
{
  {
    init_simple_test("F_BFu31i_BFu31ll");
    static STRUCT_IF_C F_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "F_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "F_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu31ll, F_BFu31i_BFu31ll)
//============================================================================



static void Test_F_BFu31i_BFu32i()
{
  {
    init_simple_test("F_BFu31i_BFu32i");
    static STRUCT_IF_C F_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "F_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "F_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu32i, F_BFu31i_BFu32i)
//============================================================================



static void Test_F_BFu31i_BFu32ll()
{
  {
    init_simple_test("F_BFu31i_BFu32ll");
    static STRUCT_IF_C F_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "F_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "F_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu32ll, F_BFu31i_BFu32ll)
//============================================================================



static void Test_F_BFu31i_BFu33()
{
  {
    init_simple_test("F_BFu31i_BFu33");
    static STRUCT_IF_C F_BFu31i_BFu33 lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, 1, "F_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, hide_ull(1LL<<32), "F_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu33, F_BFu31i_BFu33)
//============================================================================



static void Test_F_BFu31i_BFu7c()
{
  {
    init_simple_test("F_BFu31i_BFu7c");
    static STRUCT_IF_C F_BFu31i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7c, F_BFu31i_BFu7c)
//============================================================================



static void Test_F_BFu31i_BFu7i()
{
  {
    init_simple_test("F_BFu31i_BFu7i");
    static STRUCT_IF_C F_BFu31i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7i, F_BFu31i_BFu7i)
//============================================================================



static void Test_F_BFu31i_BFu7ll()
{
  {
    init_simple_test("F_BFu31i_BFu7ll");
    static STRUCT_IF_C F_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7ll, F_BFu31i_BFu7ll)
//============================================================================



static void Test_F_BFu31i_BFu7s()
{
  {
    init_simple_test("F_BFu31i_BFu7s");
    static STRUCT_IF_C F_BFu31i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu7s, F_BFu31i_BFu7s)
//============================================================================



static void Test_F_BFu31i_BFu8c()
{
  {
    init_simple_test("F_BFu31i_BFu8c");
    static STRUCT_IF_C F_BFu31i_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8c, F_BFu31i_BFu8c)
//============================================================================



static void Test_F_BFu31i_BFu8i()
{
  {
    init_simple_test("F_BFu31i_BFu8i");
    static STRUCT_IF_C F_BFu31i_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8i, F_BFu31i_BFu8i)
//============================================================================



static void Test_F_BFu31i_BFu8ll()
{
  {
    init_simple_test("F_BFu31i_BFu8ll");
    static STRUCT_IF_C F_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8ll, F_BFu31i_BFu8ll)
//============================================================================



static void Test_F_BFu31i_BFu8s()
{
  {
    init_simple_test("F_BFu31i_BFu8s");
    static STRUCT_IF_C F_BFu31i_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu8s, F_BFu31i_BFu8s)
//============================================================================



static void Test_F_BFu31i_BFu9i()
{
  {
    init_simple_test("F_BFu31i_BFu9i");
    static STRUCT_IF_C F_BFu31i_BFu9i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "F_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "F_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu9i, F_BFu31i_BFu9i)
//============================================================================



static void Test_F_BFu31i_BFu9ll()
{
  {
    init_simple_test("F_BFu31i_BFu9ll");
    static STRUCT_IF_C F_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "F_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "F_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu9ll, F_BFu31i_BFu9ll)
//============================================================================



static void Test_F_BFu31i_BFu9s()
{
  {
    init_simple_test("F_BFu31i_BFu9s");
    static STRUCT_IF_C F_BFu31i_BFu9s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "F_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "F_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_BFu9s, F_BFu31i_BFu9s)
//============================================================================



static void Test_F_BFu31i_C()
{
  {
    init_simple_test("F_BFu31i_C");
    static STRUCT_IF_C F_BFu31i_C lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_C)");
    check_field_offset(lv, v1, 0, "F_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_C");
    check_field_offset(lv, v3, 8, "F_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_C, F_BFu31i_C)
//============================================================================



static void Test_F_BFu31i_D()
{
  {
    init_simple_test("F_BFu31i_D");
    static STRUCT_IF_C F_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_D)");
    check_field_offset(lv, v1, 0, "F_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_D");
    check_field_offset(lv, v3, 8, "F_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_D, F_BFu31i_D)
//============================================================================



static void Test_F_BFu31i_F()
{
  {
    init_simple_test("F_BFu31i_F");
    static STRUCT_IF_C F_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_F)");
    check_field_offset(lv, v1, 0, "F_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_F");
    check_field_offset(lv, v3, 8, "F_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_F, F_BFu31i_F)
//============================================================================



static void Test_F_BFu31i_I()
{
  {
    init_simple_test("F_BFu31i_I");
    static STRUCT_IF_C F_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_I)");
    check_field_offset(lv, v1, 0, "F_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_I");
    check_field_offset(lv, v3, 8, "F_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_I, F_BFu31i_I)
//============================================================================



static void Test_F_BFu31i_Ip()
{
  {
    init_simple_test("F_BFu31i_Ip");
    static STRUCT_IF_C F_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Ip, F_BFu31i_Ip)
//============================================================================



static void Test_F_BFu31i_L()
{
  {
    init_simple_test("F_BFu31i_L");
    static STRUCT_IF_C F_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_L)");
    check_field_offset(lv, v1, 0, "F_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_L");
    check_field_offset(lv, v3, 8, "F_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_L, F_BFu31i_L)
//============================================================================



static void Test_F_BFu31i_S()
{
  {
    init_simple_test("F_BFu31i_S");
    static STRUCT_IF_C F_BFu31i_S lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_S)");
    check_field_offset(lv, v1, 0, "F_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_S");
    check_field_offset(lv, v3, 8, "F_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_S, F_BFu31i_S)
//============================================================================



static void Test_F_BFu31i_Uc()
{
  {
    init_simple_test("F_BFu31i_Uc");
    static STRUCT_IF_C F_BFu31i_Uc lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "F_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Uc, F_BFu31i_Uc)
//============================================================================



static void Test_F_BFu31i_Ui()
{
  {
    init_simple_test("F_BFu31i_Ui");
    static STRUCT_IF_C F_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Ui, F_BFu31i_Ui)
//============================================================================



static void Test_F_BFu31i_Ul()
{
  {
    init_simple_test("F_BFu31i_Ul");
    static STRUCT_IF_C F_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Ul, F_BFu31i_Ul)
//============================================================================



static void Test_F_BFu31i_Us()
{
  {
    init_simple_test("F_BFu31i_Us");
    static STRUCT_IF_C F_BFu31i_Us lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Us");
    check_field_offset(lv, v3, 8, "F_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Us, F_BFu31i_Us)
//============================================================================



static void Test_F_BFu31i_Vp()
{
  {
    init_simple_test("F_BFu31i_Vp");
    static STRUCT_IF_C F_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31i_Vp, F_BFu31i_Vp)
//============================================================================



static void Test_F_BFu31ll()
{
  {
    init_simple_test("F_BFu31ll");
    static STRUCT_IF_C F_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll, F_BFu31ll)
//============================================================================



static void Test_F_BFu31ll_BFu15i()
{
  {
    init_simple_test("F_BFu31ll_BFu15i");
    static STRUCT_IF_C F_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "F_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "F_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu15i, F_BFu31ll_BFu15i)
//============================================================================



static void Test_F_BFu31ll_BFu15ll()
{
  {
    init_simple_test("F_BFu31ll_BFu15ll");
    static STRUCT_IF_C F_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "F_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "F_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu15ll, F_BFu31ll_BFu15ll)
//============================================================================



static void Test_F_BFu31ll_BFu15s()
{
  {
    init_simple_test("F_BFu31ll_BFu15s");
    static STRUCT_IF_C F_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "F_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "F_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu15s, F_BFu31ll_BFu15s)
//============================================================================



static void Test_F_BFu31ll_BFu16i()
{
  {
    init_simple_test("F_BFu31ll_BFu16i");
    static STRUCT_IF_C F_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "F_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "F_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu16i, F_BFu31ll_BFu16i)
//============================================================================



static void Test_F_BFu31ll_BFu16ll()
{
  {
    init_simple_test("F_BFu31ll_BFu16ll");
    static STRUCT_IF_C F_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "F_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "F_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu16ll, F_BFu31ll_BFu16ll)
//============================================================================



static void Test_F_BFu31ll_BFu16s()
{
  {
    init_simple_test("F_BFu31ll_BFu16s");
    static STRUCT_IF_C F_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "F_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "F_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu16s, F_BFu31ll_BFu16s)
//============================================================================



static void Test_F_BFu31ll_BFu17i()
{
  {
    init_simple_test("F_BFu31ll_BFu17i");
    static STRUCT_IF_C F_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "F_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "F_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu17i, F_BFu31ll_BFu17i)
//============================================================================



static void Test_F_BFu31ll_BFu17ll()
{
  {
    init_simple_test("F_BFu31ll_BFu17ll");
    static STRUCT_IF_C F_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "F_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "F_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu17ll, F_BFu31ll_BFu17ll)
//============================================================================



static void Test_F_BFu31ll_BFu1c()
{
  {
    init_simple_test("F_BFu31ll_BFu1c");
    static STRUCT_IF_C F_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1c, F_BFu31ll_BFu1c)
//============================================================================



static void Test_F_BFu31ll_BFu1i()
{
  {
    init_simple_test("F_BFu31ll_BFu1i");
    static STRUCT_IF_C F_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1i, F_BFu31ll_BFu1i)
//============================================================================



static void Test_F_BFu31ll_BFu1ll()
{
  {
    init_simple_test("F_BFu31ll_BFu1ll");
    static STRUCT_IF_C F_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1ll, F_BFu31ll_BFu1ll)
//============================================================================



static void Test_F_BFu31ll_BFu1s()
{
  {
    init_simple_test("F_BFu31ll_BFu1s");
    static STRUCT_IF_C F_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "F_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu1s, F_BFu31ll_BFu1s)
//============================================================================



static void Test_F_BFu31ll_BFu31i()
{
  {
    init_simple_test("F_BFu31ll_BFu31i");
    static STRUCT_IF_C F_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "F_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu31i, F_BFu31ll_BFu31i)
//============================================================================



static void Test_F_BFu31ll_BFu31ll()
{
  {
    init_simple_test("F_BFu31ll_BFu31ll");
    static STRUCT_IF_C F_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "F_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu31ll, F_BFu31ll_BFu31ll)
//============================================================================



static void Test_F_BFu31ll_BFu32i()
{
  {
    init_simple_test("F_BFu31ll_BFu32i");
    static STRUCT_IF_C F_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "F_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "F_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu32i, F_BFu31ll_BFu32i)
//============================================================================



static void Test_F_BFu31ll_BFu32ll()
{
  {
    init_simple_test("F_BFu31ll_BFu32ll");
    static STRUCT_IF_C F_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "F_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "F_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu32ll, F_BFu31ll_BFu32ll)
//============================================================================



static void Test_F_BFu31ll_BFu33()
{
  {
    init_simple_test("F_BFu31ll_BFu33");
    static STRUCT_IF_C F_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, 1, "F_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, hide_ull(1LL<<32), "F_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu33, F_BFu31ll_BFu33)
//============================================================================



static void Test_F_BFu31ll_BFu7c()
{
  {
    init_simple_test("F_BFu31ll_BFu7c");
    static STRUCT_IF_C F_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7c, F_BFu31ll_BFu7c)
//============================================================================



static void Test_F_BFu31ll_BFu7i()
{
  {
    init_simple_test("F_BFu31ll_BFu7i");
    static STRUCT_IF_C F_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7i, F_BFu31ll_BFu7i)
//============================================================================



static void Test_F_BFu31ll_BFu7ll()
{
  {
    init_simple_test("F_BFu31ll_BFu7ll");
    static STRUCT_IF_C F_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7ll, F_BFu31ll_BFu7ll)
//============================================================================



static void Test_F_BFu31ll_BFu7s()
{
  {
    init_simple_test("F_BFu31ll_BFu7s");
    static STRUCT_IF_C F_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "F_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "F_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu7s, F_BFu31ll_BFu7s)
//============================================================================



static void Test_F_BFu31ll_BFu8c()
{
  {
    init_simple_test("F_BFu31ll_BFu8c");
    static STRUCT_IF_C F_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8c, F_BFu31ll_BFu8c)
//============================================================================



static void Test_F_BFu31ll_BFu8i()
{
  {
    init_simple_test("F_BFu31ll_BFu8i");
    static STRUCT_IF_C F_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8i, F_BFu31ll_BFu8i)
//============================================================================



static void Test_F_BFu31ll_BFu8ll()
{
  {
    init_simple_test("F_BFu31ll_BFu8ll");
    static STRUCT_IF_C F_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8ll, F_BFu31ll_BFu8ll)
//============================================================================



static void Test_F_BFu31ll_BFu8s()
{
  {
    init_simple_test("F_BFu31ll_BFu8s");
    static STRUCT_IF_C F_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "F_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "F_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu8s, F_BFu31ll_BFu8s)
//============================================================================



static void Test_F_BFu31ll_BFu9i()
{
  {
    init_simple_test("F_BFu31ll_BFu9i");
    static STRUCT_IF_C F_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "F_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "F_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu9i, F_BFu31ll_BFu9i)
//============================================================================



static void Test_F_BFu31ll_BFu9ll()
{
  {
    init_simple_test("F_BFu31ll_BFu9ll");
    static STRUCT_IF_C F_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "F_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "F_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu9ll, F_BFu31ll_BFu9ll)
//============================================================================



static void Test_F_BFu31ll_BFu9s()
{
  {
    init_simple_test("F_BFu31ll_BFu9s");
    static STRUCT_IF_C F_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "F_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "F_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_BFu9s, F_BFu31ll_BFu9s)
//============================================================================



static void Test_F_BFu31ll_C()
{
  {
    init_simple_test("F_BFu31ll_C");
    static STRUCT_IF_C F_BFu31ll_C lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_C");
    check_field_offset(lv, v3, 8, "F_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_C, F_BFu31ll_C)
//============================================================================



static void Test_F_BFu31ll_D()
{
  {
    init_simple_test("F_BFu31ll_D");
    static STRUCT_IF_C F_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_D");
    check_field_offset(lv, v3, 8, "F_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_D, F_BFu31ll_D)
//============================================================================



static void Test_F_BFu31ll_F()
{
  {
    init_simple_test("F_BFu31ll_F");
    static STRUCT_IF_C F_BFu31ll_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_F");
    check_field_offset(lv, v3, 8, "F_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_F, F_BFu31ll_F)
//============================================================================



static void Test_F_BFu31ll_I()
{
  {
    init_simple_test("F_BFu31ll_I");
    static STRUCT_IF_C F_BFu31ll_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_I");
    check_field_offset(lv, v3, 8, "F_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_I, F_BFu31ll_I)
//============================================================================



static void Test_F_BFu31ll_Ip()
{
  {
    init_simple_test("F_BFu31ll_Ip");
    static STRUCT_IF_C F_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Ip, F_BFu31ll_Ip)
//============================================================================



static void Test_F_BFu31ll_L()
{
  {
    init_simple_test("F_BFu31ll_L");
    static STRUCT_IF_C F_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_L");
    check_field_offset(lv, v3, 8, "F_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_L, F_BFu31ll_L)
//============================================================================



static void Test_F_BFu31ll_S()
{
  {
    init_simple_test("F_BFu31ll_S");
    static STRUCT_IF_C F_BFu31ll_S lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_S");
    check_field_offset(lv, v3, 8, "F_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_S, F_BFu31ll_S)
//============================================================================



static void Test_F_BFu31ll_Uc()
{
  {
    init_simple_test("F_BFu31ll_Uc");
    static STRUCT_IF_C F_BFu31ll_Uc lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Uc");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Uc, F_BFu31ll_Uc)
//============================================================================



static void Test_F_BFu31ll_Ui()
{
  {
    init_simple_test("F_BFu31ll_Ui");
    static STRUCT_IF_C F_BFu31ll_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Ui, F_BFu31ll_Ui)
//============================================================================



static void Test_F_BFu31ll_Ul()
{
  {
    init_simple_test("F_BFu31ll_Ul");
    static STRUCT_IF_C F_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Ul, F_BFu31ll_Ul)
//============================================================================



static void Test_F_BFu31ll_Us()
{
  {
    init_simple_test("F_BFu31ll_Us");
    static STRUCT_IF_C F_BFu31ll_Us lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Us");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Us, F_BFu31ll_Us)
//============================================================================



static void Test_F_BFu31ll_Vp()
{
  {
    init_simple_test("F_BFu31ll_Vp");
    static STRUCT_IF_C F_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "F_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "F_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu31ll_Vp, F_BFu31ll_Vp)
//============================================================================



static void Test_F_BFu32i()
{
  {
    init_simple_test("F_BFu32i");
    static STRUCT_IF_C F_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i, F_BFu32i)
//============================================================================



static void Test_F_BFu32i_BFu15i()
{
  {
    init_simple_test("F_BFu32i_BFu15i");
    static STRUCT_IF_C F_BFu32i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu15i, F_BFu32i_BFu15i)
//============================================================================



static void Test_F_BFu32i_BFu15ll()
{
  {
    init_simple_test("F_BFu32i_BFu15ll");
    static STRUCT_IF_C F_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu15ll, F_BFu32i_BFu15ll)
//============================================================================



static void Test_F_BFu32i_BFu15s()
{
  {
    init_simple_test("F_BFu32i_BFu15s");
    static STRUCT_IF_C F_BFu32i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu15s, F_BFu32i_BFu15s)
//============================================================================



static void Test_F_BFu32i_BFu16i()
{
  {
    init_simple_test("F_BFu32i_BFu16i");
    static STRUCT_IF_C F_BFu32i_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu16i, F_BFu32i_BFu16i)
//============================================================================



static void Test_F_BFu32i_BFu16ll()
{
  {
    init_simple_test("F_BFu32i_BFu16ll");
    static STRUCT_IF_C F_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu16ll, F_BFu32i_BFu16ll)
//============================================================================



static void Test_F_BFu32i_BFu16s()
{
  {
    init_simple_test("F_BFu32i_BFu16s");
    static STRUCT_IF_C F_BFu32i_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu16s, F_BFu32i_BFu16s)
//============================================================================



static void Test_F_BFu32i_BFu17i()
{
  {
    init_simple_test("F_BFu32i_BFu17i");
    static STRUCT_IF_C F_BFu32i_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu17i, F_BFu32i_BFu17i)
//============================================================================



static void Test_F_BFu32i_BFu17ll()
{
  {
    init_simple_test("F_BFu32i_BFu17ll");
    static STRUCT_IF_C F_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu17ll, F_BFu32i_BFu17ll)
//============================================================================



static void Test_F_BFu32i_BFu1c()
{
  {
    init_simple_test("F_BFu32i_BFu1c");
    static STRUCT_IF_C F_BFu32i_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1c, F_BFu32i_BFu1c)
//============================================================================



static void Test_F_BFu32i_BFu1i()
{
  {
    init_simple_test("F_BFu32i_BFu1i");
    static STRUCT_IF_C F_BFu32i_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1i, F_BFu32i_BFu1i)
//============================================================================



static void Test_F_BFu32i_BFu1ll()
{
  {
    init_simple_test("F_BFu32i_BFu1ll");
    static STRUCT_IF_C F_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1ll, F_BFu32i_BFu1ll)
//============================================================================



static void Test_F_BFu32i_BFu1s()
{
  {
    init_simple_test("F_BFu32i_BFu1s");
    static STRUCT_IF_C F_BFu32i_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu1s, F_BFu32i_BFu1s)
//============================================================================



static void Test_F_BFu32i_BFu31i()
{
  {
    init_simple_test("F_BFu32i_BFu31i");
    static STRUCT_IF_C F_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu31i, F_BFu32i_BFu31i)
//============================================================================



static void Test_F_BFu32i_BFu31ll()
{
  {
    init_simple_test("F_BFu32i_BFu31ll");
    static STRUCT_IF_C F_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu31ll, F_BFu32i_BFu31ll)
//============================================================================



static void Test_F_BFu32i_BFu32i()
{
  {
    init_simple_test("F_BFu32i_BFu32i");
    static STRUCT_IF_C F_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu32i, F_BFu32i_BFu32i)
//============================================================================



static void Test_F_BFu32i_BFu32ll()
{
  {
    init_simple_test("F_BFu32i_BFu32ll");
    static STRUCT_IF_C F_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu32ll, F_BFu32i_BFu32ll)
//============================================================================



static void Test_F_BFu32i_BFu33()
{
  {
    init_simple_test("F_BFu32i_BFu33");
    static STRUCT_IF_C F_BFu32i_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu33, F_BFu32i_BFu33)
//============================================================================



static void Test_F_BFu32i_BFu7c()
{
  {
    init_simple_test("F_BFu32i_BFu7c");
    static STRUCT_IF_C F_BFu32i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7c, F_BFu32i_BFu7c)
//============================================================================



static void Test_F_BFu32i_BFu7i()
{
  {
    init_simple_test("F_BFu32i_BFu7i");
    static STRUCT_IF_C F_BFu32i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7i, F_BFu32i_BFu7i)
//============================================================================



static void Test_F_BFu32i_BFu7ll()
{
  {
    init_simple_test("F_BFu32i_BFu7ll");
    static STRUCT_IF_C F_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7ll, F_BFu32i_BFu7ll)
//============================================================================



static void Test_F_BFu32i_BFu7s()
{
  {
    init_simple_test("F_BFu32i_BFu7s");
    static STRUCT_IF_C F_BFu32i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu7s, F_BFu32i_BFu7s)
//============================================================================



static void Test_F_BFu32i_BFu8c()
{
  {
    init_simple_test("F_BFu32i_BFu8c");
    static STRUCT_IF_C F_BFu32i_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8c, F_BFu32i_BFu8c)
//============================================================================



static void Test_F_BFu32i_BFu8i()
{
  {
    init_simple_test("F_BFu32i_BFu8i");
    static STRUCT_IF_C F_BFu32i_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8i, F_BFu32i_BFu8i)
//============================================================================



static void Test_F_BFu32i_BFu8ll()
{
  {
    init_simple_test("F_BFu32i_BFu8ll");
    static STRUCT_IF_C F_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8ll, F_BFu32i_BFu8ll)
//============================================================================



static void Test_F_BFu32i_BFu8s()
{
  {
    init_simple_test("F_BFu32i_BFu8s");
    static STRUCT_IF_C F_BFu32i_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu8s, F_BFu32i_BFu8s)
//============================================================================



static void Test_F_BFu32i_BFu9i()
{
  {
    init_simple_test("F_BFu32i_BFu9i");
    static STRUCT_IF_C F_BFu32i_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu9i, F_BFu32i_BFu9i)
//============================================================================



static void Test_F_BFu32i_BFu9ll()
{
  {
    init_simple_test("F_BFu32i_BFu9ll");
    static STRUCT_IF_C F_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu9ll, F_BFu32i_BFu9ll)
//============================================================================



static void Test_F_BFu32i_BFu9s()
{
  {
    init_simple_test("F_BFu32i_BFu9s");
    static STRUCT_IF_C F_BFu32i_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_BFu9s, F_BFu32i_BFu9s)
//============================================================================



static void Test_F_BFu32i_C()
{
  {
    init_simple_test("F_BFu32i_C");
    static STRUCT_IF_C F_BFu32i_C lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_C)");
    check_field_offset(lv, v1, 0, "F_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_C");
    check_field_offset(lv, v3, 8, "F_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_C, F_BFu32i_C)
//============================================================================



static void Test_F_BFu32i_D()
{
  {
    init_simple_test("F_BFu32i_D");
    static STRUCT_IF_C F_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_D)");
    check_field_offset(lv, v1, 0, "F_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_D");
    check_field_offset(lv, v3, 8, "F_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_D, F_BFu32i_D)
//============================================================================



static void Test_F_BFu32i_F()
{
  {
    init_simple_test("F_BFu32i_F");
    static STRUCT_IF_C F_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_F)");
    check_field_offset(lv, v1, 0, "F_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_F");
    check_field_offset(lv, v3, 8, "F_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_F, F_BFu32i_F)
//============================================================================



static void Test_F_BFu32i_I()
{
  {
    init_simple_test("F_BFu32i_I");
    static STRUCT_IF_C F_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_I)");
    check_field_offset(lv, v1, 0, "F_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_I");
    check_field_offset(lv, v3, 8, "F_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_I, F_BFu32i_I)
//============================================================================



static void Test_F_BFu32i_Ip()
{
  {
    init_simple_test("F_BFu32i_Ip");
    static STRUCT_IF_C F_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "F_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Ip, F_BFu32i_Ip)
//============================================================================



static void Test_F_BFu32i_L()
{
  {
    init_simple_test("F_BFu32i_L");
    static STRUCT_IF_C F_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_L)");
    check_field_offset(lv, v1, 0, "F_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_L");
    check_field_offset(lv, v3, 8, "F_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_L, F_BFu32i_L)
//============================================================================



static void Test_F_BFu32i_S()
{
  {
    init_simple_test("F_BFu32i_S");
    static STRUCT_IF_C F_BFu32i_S lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_S)");
    check_field_offset(lv, v1, 0, "F_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_S");
    check_field_offset(lv, v3, 8, "F_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_S, F_BFu32i_S)
//============================================================================



static void Test_F_BFu32i_Uc()
{
  {
    init_simple_test("F_BFu32i_Uc");
    static STRUCT_IF_C F_BFu32i_Uc lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "F_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Uc, F_BFu32i_Uc)
//============================================================================



static void Test_F_BFu32i_Ui()
{
  {
    init_simple_test("F_BFu32i_Ui");
    static STRUCT_IF_C F_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "F_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Ui, F_BFu32i_Ui)
//============================================================================



static void Test_F_BFu32i_Ul()
{
  {
    init_simple_test("F_BFu32i_Ul");
    static STRUCT_IF_C F_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "F_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Ul, F_BFu32i_Ul)
//============================================================================



static void Test_F_BFu32i_Us()
{
  {
    init_simple_test("F_BFu32i_Us");
    static STRUCT_IF_C F_BFu32i_Us lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Us");
    check_field_offset(lv, v3, 8, "F_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Us, F_BFu32i_Us)
//============================================================================



static void Test_F_BFu32i_Vp()
{
  {
    init_simple_test("F_BFu32i_Vp");
    static STRUCT_IF_C F_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "F_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32i_Vp, F_BFu32i_Vp)
//============================================================================



static void Test_F_BFu32ll()
{
  {
    init_simple_test("F_BFu32ll");
    static STRUCT_IF_C F_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll, F_BFu32ll)
//============================================================================



static void Test_F_BFu32ll_BFu15i()
{
  {
    init_simple_test("F_BFu32ll_BFu15i");
    static STRUCT_IF_C F_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu15i, F_BFu32ll_BFu15i)
//============================================================================



static void Test_F_BFu32ll_BFu15ll()
{
  {
    init_simple_test("F_BFu32ll_BFu15ll");
    static STRUCT_IF_C F_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu15ll, F_BFu32ll_BFu15ll)
//============================================================================



static void Test_F_BFu32ll_BFu15s()
{
  {
    init_simple_test("F_BFu32ll_BFu15s");
    static STRUCT_IF_C F_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "F_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "F_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu15s, F_BFu32ll_BFu15s)
//============================================================================



static void Test_F_BFu32ll_BFu16i()
{
  {
    init_simple_test("F_BFu32ll_BFu16i");
    static STRUCT_IF_C F_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu16i, F_BFu32ll_BFu16i)
//============================================================================



static void Test_F_BFu32ll_BFu16ll()
{
  {
    init_simple_test("F_BFu32ll_BFu16ll");
    static STRUCT_IF_C F_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu16ll, F_BFu32ll_BFu16ll)
//============================================================================



static void Test_F_BFu32ll_BFu16s()
{
  {
    init_simple_test("F_BFu32ll_BFu16s");
    static STRUCT_IF_C F_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "F_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "F_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu16s, F_BFu32ll_BFu16s)
//============================================================================



static void Test_F_BFu32ll_BFu17i()
{
  {
    init_simple_test("F_BFu32ll_BFu17i");
    static STRUCT_IF_C F_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu17i, F_BFu32ll_BFu17i)
//============================================================================



static void Test_F_BFu32ll_BFu17ll()
{
  {
    init_simple_test("F_BFu32ll_BFu17ll");
    static STRUCT_IF_C F_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "F_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "F_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu17ll, F_BFu32ll_BFu17ll)
//============================================================================



static void Test_F_BFu32ll_BFu1c()
{
  {
    init_simple_test("F_BFu32ll_BFu1c");
    static STRUCT_IF_C F_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1c, F_BFu32ll_BFu1c)
//============================================================================



static void Test_F_BFu32ll_BFu1i()
{
  {
    init_simple_test("F_BFu32ll_BFu1i");
    static STRUCT_IF_C F_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1i, F_BFu32ll_BFu1i)
//============================================================================



static void Test_F_BFu32ll_BFu1ll()
{
  {
    init_simple_test("F_BFu32ll_BFu1ll");
    static STRUCT_IF_C F_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1ll, F_BFu32ll_BFu1ll)
//============================================================================



static void Test_F_BFu32ll_BFu1s()
{
  {
    init_simple_test("F_BFu32ll_BFu1s");
    static STRUCT_IF_C F_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "F_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu1s, F_BFu32ll_BFu1s)
//============================================================================



static void Test_F_BFu32ll_BFu31i()
{
  {
    init_simple_test("F_BFu32ll_BFu31i");
    static STRUCT_IF_C F_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu31i, F_BFu32ll_BFu31i)
//============================================================================



static void Test_F_BFu32ll_BFu31ll()
{
  {
    init_simple_test("F_BFu32ll_BFu31ll");
    static STRUCT_IF_C F_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "F_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "F_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu31ll, F_BFu32ll_BFu31ll)
//============================================================================



static void Test_F_BFu32ll_BFu32i()
{
  {
    init_simple_test("F_BFu32ll_BFu32i");
    static STRUCT_IF_C F_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu32i, F_BFu32ll_BFu32i)
//============================================================================



static void Test_F_BFu32ll_BFu32ll()
{
  {
    init_simple_test("F_BFu32ll_BFu32ll");
    static STRUCT_IF_C F_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "F_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu32ll, F_BFu32ll_BFu32ll)
//============================================================================



static void Test_F_BFu32ll_BFu33()
{
  {
    init_simple_test("F_BFu32ll_BFu33");
    static STRUCT_IF_C F_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "F_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "F_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu33, F_BFu32ll_BFu33)
//============================================================================



static void Test_F_BFu32ll_BFu7c()
{
  {
    init_simple_test("F_BFu32ll_BFu7c");
    static STRUCT_IF_C F_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7c, F_BFu32ll_BFu7c)
//============================================================================



static void Test_F_BFu32ll_BFu7i()
{
  {
    init_simple_test("F_BFu32ll_BFu7i");
    static STRUCT_IF_C F_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7i, F_BFu32ll_BFu7i)
//============================================================================



static void Test_F_BFu32ll_BFu7ll()
{
  {
    init_simple_test("F_BFu32ll_BFu7ll");
    static STRUCT_IF_C F_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7ll, F_BFu32ll_BFu7ll)
//============================================================================



static void Test_F_BFu32ll_BFu7s()
{
  {
    init_simple_test("F_BFu32ll_BFu7s");
    static STRUCT_IF_C F_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "F_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "F_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu7s, F_BFu32ll_BFu7s)
//============================================================================



static void Test_F_BFu32ll_BFu8c()
{
  {
    init_simple_test("F_BFu32ll_BFu8c");
    static STRUCT_IF_C F_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8c, F_BFu32ll_BFu8c)
//============================================================================



static void Test_F_BFu32ll_BFu8i()
{
  {
    init_simple_test("F_BFu32ll_BFu8i");
    static STRUCT_IF_C F_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8i, F_BFu32ll_BFu8i)
//============================================================================



static void Test_F_BFu32ll_BFu8ll()
{
  {
    init_simple_test("F_BFu32ll_BFu8ll");
    static STRUCT_IF_C F_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8ll, F_BFu32ll_BFu8ll)
//============================================================================



static void Test_F_BFu32ll_BFu8s()
{
  {
    init_simple_test("F_BFu32ll_BFu8s");
    static STRUCT_IF_C F_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "F_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "F_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu8s, F_BFu32ll_BFu8s)
//============================================================================



static void Test_F_BFu32ll_BFu9i()
{
  {
    init_simple_test("F_BFu32ll_BFu9i");
    static STRUCT_IF_C F_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu9i, F_BFu32ll_BFu9i)
//============================================================================



static void Test_F_BFu32ll_BFu9ll()
{
  {
    init_simple_test("F_BFu32ll_BFu9ll");
    static STRUCT_IF_C F_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu9ll, F_BFu32ll_BFu9ll)
//============================================================================



static void Test_F_BFu32ll_BFu9s()
{
  {
    init_simple_test("F_BFu32ll_BFu9s");
    static STRUCT_IF_C F_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "F_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "F_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_BFu9s, F_BFu32ll_BFu9s)
//============================================================================



static void Test_F_BFu32ll_C()
{
  {
    init_simple_test("F_BFu32ll_C");
    static STRUCT_IF_C F_BFu32ll_C lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_C");
    check_field_offset(lv, v3, 8, "F_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_C, F_BFu32ll_C)
//============================================================================



static void Test_F_BFu32ll_D()
{
  {
    init_simple_test("F_BFu32ll_D");
    static STRUCT_IF_C F_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_D");
    check_field_offset(lv, v3, 8, "F_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_D, F_BFu32ll_D)
//============================================================================



static void Test_F_BFu32ll_F()
{
  {
    init_simple_test("F_BFu32ll_F");
    static STRUCT_IF_C F_BFu32ll_F lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_F");
    check_field_offset(lv, v3, 8, "F_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_F, F_BFu32ll_F)
//============================================================================



static void Test_F_BFu32ll_I()
{
  {
    init_simple_test("F_BFu32ll_I");
    static STRUCT_IF_C F_BFu32ll_I lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_I");
    check_field_offset(lv, v3, 8, "F_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_I, F_BFu32ll_I)
//============================================================================



static void Test_F_BFu32ll_Ip()
{
  {
    init_simple_test("F_BFu32ll_Ip");
    static STRUCT_IF_C F_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Ip, F_BFu32ll_Ip)
//============================================================================



static void Test_F_BFu32ll_L()
{
  {
    init_simple_test("F_BFu32ll_L");
    static STRUCT_IF_C F_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_L");
    check_field_offset(lv, v3, 8, "F_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_L, F_BFu32ll_L)
//============================================================================



static void Test_F_BFu32ll_S()
{
  {
    init_simple_test("F_BFu32ll_S");
    static STRUCT_IF_C F_BFu32ll_S lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_S");
    check_field_offset(lv, v3, 8, "F_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_S, F_BFu32ll_S)
//============================================================================



static void Test_F_BFu32ll_Uc()
{
  {
    init_simple_test("F_BFu32ll_Uc");
    static STRUCT_IF_C F_BFu32ll_Uc lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Uc");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Uc, F_BFu32ll_Uc)
//============================================================================



static void Test_F_BFu32ll_Ui()
{
  {
    init_simple_test("F_BFu32ll_Ui");
    static STRUCT_IF_C F_BFu32ll_Ui lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Ui, F_BFu32ll_Ui)
//============================================================================



static void Test_F_BFu32ll_Ul()
{
  {
    init_simple_test("F_BFu32ll_Ul");
    static STRUCT_IF_C F_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(F_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Ul, F_BFu32ll_Ul)
//============================================================================



static void Test_F_BFu32ll_Us()
{
  {
    init_simple_test("F_BFu32ll_Us");
    static STRUCT_IF_C F_BFu32ll_Us lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Us");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Us, F_BFu32ll_Us)
//============================================================================



static void Test_F_BFu32ll_Vp()
{
  {
    init_simple_test("F_BFu32ll_Vp");
    static STRUCT_IF_C F_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(F_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "F_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "F_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "F_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "F_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu32ll_Vp, F_BFu32ll_Vp)
//============================================================================



static void Test_F_BFu33()
{
  {
    init_simple_test("F_BFu33");
    static STRUCT_IF_C F_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33)");
    check_field_offset(lv, v1, 0, "F_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33, F_BFu33)
//============================================================================



static void Test_F_BFu33_BFu15i()
{
  {
    init_simple_test("F_BFu33_BFu15i");
    static STRUCT_IF_C F_BFu33_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "F_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "F_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu15i, F_BFu33_BFu15i)
//============================================================================



static void Test_F_BFu33_BFu15ll()
{
  {
    init_simple_test("F_BFu33_BFu15ll");
    static STRUCT_IF_C F_BFu33_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "F_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "F_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu15ll, F_BFu33_BFu15ll)
//============================================================================



static void Test_F_BFu33_BFu15s()
{
  {
    init_simple_test("F_BFu33_BFu15s");
    static STRUCT_IF_C F_BFu33_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(F_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "F_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "F_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu15s, F_BFu33_BFu15s)
//============================================================================



static void Test_F_BFu33_BFu16i()
{
  {
    init_simple_test("F_BFu33_BFu16i");
    static STRUCT_IF_C F_BFu33_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "F_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "F_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu16i, F_BFu33_BFu16i)
//============================================================================



static void Test_F_BFu33_BFu16ll()
{
  {
    init_simple_test("F_BFu33_BFu16ll");
    static STRUCT_IF_C F_BFu33_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "F_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "F_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu16ll, F_BFu33_BFu16ll)
//============================================================================



static void Test_F_BFu33_BFu16s()
{
  {
    init_simple_test("F_BFu33_BFu16s");
    static STRUCT_IF_C F_BFu33_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "F_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "F_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu16s, F_BFu33_BFu16s)
//============================================================================



static void Test_F_BFu33_BFu17i()
{
  {
    init_simple_test("F_BFu33_BFu17i");
    static STRUCT_IF_C F_BFu33_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "F_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "F_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu17i, F_BFu33_BFu17i)
//============================================================================



static void Test_F_BFu33_BFu17ll()
{
  {
    init_simple_test("F_BFu33_BFu17ll");
    static STRUCT_IF_C F_BFu33_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(F_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "F_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "F_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu17ll, F_BFu33_BFu17ll)
//============================================================================



static void Test_F_BFu33_BFu1c()
{
  {
    init_simple_test("F_BFu33_BFu1c");
    static STRUCT_IF_C F_BFu33_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "F_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1c, F_BFu33_BFu1c)
//============================================================================



static void Test_F_BFu33_BFu1i()
{
  {
    init_simple_test("F_BFu33_BFu1i");
    static STRUCT_IF_C F_BFu33_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "F_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1i, F_BFu33_BFu1i)
//============================================================================



static void Test_F_BFu33_BFu1ll()
{
  {
    init_simple_test("F_BFu33_BFu1ll");
    static STRUCT_IF_C F_BFu33_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "F_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1ll, F_BFu33_BFu1ll)
//============================================================================



static void Test_F_BFu33_BFu1s()
{
  {
    init_simple_test("F_BFu33_BFu1s");
    static STRUCT_IF_C F_BFu33_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(F_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "F_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu1s, F_BFu33_BFu1s)
//============================================================================



static void Test_F_BFu33_BFu31i()
{
  {
    init_simple_test("F_BFu33_BFu31i");
    static STRUCT_IF_C F_BFu33_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "F_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "F_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu31i, F_BFu33_BFu31i)
//============================================================================



static void Test_F_BFu33_BFu31ll()
{
  {
    init_simple_test("F_BFu33_BFu31ll");
    static STRUCT_IF_C F_BFu33_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(F_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "F_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "F_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu31ll, F_BFu33_BFu31ll)
//============================================================================



static void Test_F_BFu33_BFu32i()
{
  {
    init_simple_test("F_BFu33_BFu32i");
    static STRUCT_IF_C F_BFu33_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(F_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "F_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "F_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "F_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "F_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "F_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_F_BFu33_BFu32i, F_BFu33_BFu32i)
//============================================================================



static void Test_F_BFu33_BFu32ll()
{
  {
    init_simple_test("F_BFu33_BFu32ll");
    static STRUCT_IF_C F_BFu33_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(F_BFu33_BFu32ll)");
    check2(__alignof