// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct BFu9s_Ip_BFu17ll { unsigned short v1:9; int * v2; unsigned long long v3:17; };
struct BFu9s_Ip_BFu1c { unsigned short v1:9; int * v2; unsigned char v3:1; };
struct BFu9s_Ip_BFu1i { unsigned short v1:9; int * v2; unsigned int v3:1; };
struct BFu9s_Ip_BFu1ll { unsigned short v1:9; int * v2; unsigned long long v3:1; };
struct BFu9s_Ip_BFu1s { unsigned short v1:9; int * v2; unsigned short v3:1; };
struct BFu9s_Ip_BFu31i { unsigned short v1:9; int * v2; unsigned int v3:31; };
struct BFu9s_Ip_BFu31ll { unsigned short v1:9; int * v2; unsigned long long v3:31; };
struct BFu9s_Ip_BFu32i { unsigned short v1:9; int * v2; unsigned int v3:32; };
struct BFu9s_Ip_BFu32ll { unsigned short v1:9; int * v2; unsigned long long v3:32; };
struct BFu9s_Ip_BFu33 { unsigned short v1:9; int * v2; unsigned long long v3:33; };
struct BFu9s_Ip_BFu7c { unsigned short v1:9; int * v2; unsigned char v3:7; };
struct BFu9s_Ip_BFu7i { unsigned short v1:9; int * v2; unsigned int v3:7; };
struct BFu9s_Ip_BFu7ll { unsigned short v1:9; int * v2; unsigned long long v3:7; };
struct BFu9s_Ip_BFu7s { unsigned short v1:9; int * v2; unsigned short v3:7; };
struct BFu9s_Ip_BFu8c { unsigned short v1:9; int * v2; unsigned char v3:8; };
struct BFu9s_Ip_BFu8i { unsigned short v1:9; int * v2; unsigned int v3:8; };
struct BFu9s_Ip_BFu8ll { unsigned short v1:9; int * v2; unsigned long long v3:8; };
struct BFu9s_Ip_BFu8s { unsigned short v1:9; int * v2; unsigned short v3:8; };
struct BFu9s_Ip_BFu9i { unsigned short v1:9; int * v2; unsigned int v3:9; };
struct BFu9s_Ip_BFu9ll { unsigned short v1:9; int * v2; unsigned long long v3:9; };
struct BFu9s_Ip_BFu9s { unsigned short v1:9; int * v2; unsigned short v3:9; };
struct BFu9s_Ip_C { unsigned short v1:9; int * v2; char v3; };
struct BFu9s_Ip_D { unsigned short v1:9; int * v2; double v3; };
struct BFu9s_Ip_F { unsigned short v1:9; int * v2; float v3; };
struct BFu9s_Ip_I { unsigned short v1:9; int * v2; int v3; };
struct BFu9s_Ip_Ip { unsigned short v1:9; int * v2; int * v3; };
struct BFu9s_Ip_L { unsigned short v1:9; int * v2; long long v3; };
struct BFu9s_Ip_S { unsigned short v1:9; int * v2; short v3; };
struct BFu9s_Ip_Uc { unsigned short v1:9; int * v2; unsigned char v3; };
struct BFu9s_Ip_Ui { unsigned short v1:9; int * v2; unsigned int v3; };
struct BFu9s_Ip_Ul { unsigned short v1:9; int * v2; unsigned long long v3; };
struct BFu9s_Ip_Us { unsigned short v1:9; int * v2; unsigned short v3; };
struct BFu9s_Ip_Vp { unsigned short v1:9; int * v2; void * v3; };
struct BFu9s_L { unsigned short v1:9; long long v2; };
struct BFu9s_L_BFu15i { unsigned short v1:9; long long v2; unsigned int v3:15; };
struct BFu9s_L_BFu15ll { unsigned short v1:9; long long v2; unsigned long long v3:15; };
struct BFu9s_L_BFu15s { unsigned short v1:9; long long v2; unsigned short v3:15; };
struct BFu9s_L_BFu16i { unsigned short v1:9; long long v2; unsigned int v3:16; };
struct BFu9s_L_BFu16ll { unsigned short v1:9; long long v2; unsigned long long v3:16; };
struct BFu9s_L_BFu16s { unsigned short v1:9; long long v2; unsigned short v3:16; };
struct BFu9s_L_BFu17i { unsigned short v1:9; long long v2; unsigned int v3:17; };
struct BFu9s_L_BFu17ll { unsigned short v1:9; long long v2; unsigned long long v3:17; };
struct BFu9s_L_BFu1c { unsigned short v1:9; long long v2; unsigned char v3:1; };
struct BFu9s_L_BFu1i { unsigned short v1:9; long long v2; unsigned int v3:1; };
struct BFu9s_L_BFu1ll { unsigned short v1:9; long long v2; unsigned long long v3:1; };
struct BFu9s_L_BFu1s { unsigned short v1:9; long long v2; unsigned short v3:1; };
struct BFu9s_L_BFu31i { unsigned short v1:9; long long v2; unsigned int v3:31; };
struct BFu9s_L_BFu31ll { unsigned short v1:9; long long v2; unsigned long long v3:31; };
struct BFu9s_L_BFu32i { unsigned short v1:9; long long v2; unsigned int v3:32; };
struct BFu9s_L_BFu32ll { unsigned short v1:9; long long v2; unsigned long long v3:32; };
struct BFu9s_L_BFu33 { unsigned short v1:9; long long v2; unsigned long long v3:33; };
struct BFu9s_L_BFu7c { unsigned short v1:9; long long v2; unsigned char v3:7; };
struct BFu9s_L_BFu7i { unsigned short v1:9; long long v2; unsigned int v3:7; };
struct BFu9s_L_BFu7ll { unsigned short v1:9; long long v2; unsigned long long v3:7; };
struct BFu9s_L_BFu7s { unsigned short v1:9; long long v2; unsigned short v3:7; };
struct BFu9s_L_BFu8c { unsigned short v1:9; long long v2; unsigned char v3:8; };
struct BFu9s_L_BFu8i { unsigned short v1:9; long long v2; unsigned int v3:8; };
struct BFu9s_L_BFu8ll { unsigned short v1:9; long long v2; unsigned long long v3:8; };
struct BFu9s_L_BFu8s { unsigned short v1:9; long long v2; unsigned short v3:8; };
struct BFu9s_L_BFu9i { unsigned short v1:9; long long v2; unsigned int v3:9; };
struct BFu9s_L_BFu9ll { unsigned short v1:9; long long v2; unsigned long long v3:9; };
struct BFu9s_L_BFu9s { unsigned short v1:9; long long v2; unsigned short v3:9; };
struct BFu9s_L_C { unsigned short v1:9; long long v2; char v3; };
struct BFu9s_L_D { unsigned short v1:9; long long v2; double v3; };
struct BFu9s_L_F { unsigned short v1:9; long long v2; float v3; };
struct BFu9s_L_I { unsigned short v1:9; long long v2; int v3; };
struct BFu9s_L_Ip { unsigned short v1:9; long long v2; int * v3; };
struct BFu9s_L_L { unsigned short v1:9; long long v2; long long v3; };
struct BFu9s_L_S { unsigned short v1:9; long long v2; short v3; };
struct BFu9s_L_Uc { unsigned short v1:9; long long v2; unsigned char v3; };
struct BFu9s_L_Ui { unsigned short v1:9; long long v2; unsigned int v3; };
struct BFu9s_L_Ul { unsigned short v1:9; long long v2; unsigned long long v3; };
struct BFu9s_L_Us { unsigned short v1:9; long long v2; unsigned short v3; };
struct BFu9s_L_Vp { unsigned short v1:9; long long v2; void * v3; };
struct BFu9s_S { unsigned short v1:9; short v2; };
struct BFu9s_S_BFu15i { unsigned short v1:9; short v2; unsigned int v3:15; };
struct BFu9s_S_BFu15ll { unsigned short v1:9; short v2; unsigned long long v3:15; };
struct BFu9s_S_BFu15s { unsigned short v1:9; short v2; unsigned short v3:15; };
struct BFu9s_S_BFu16i { unsigned short v1:9; short v2; unsigned int v3:16; };
struct BFu9s_S_BFu16ll { unsigned short v1:9; short v2; unsigned long long v3:16; };
struct BFu9s_S_BFu16s { unsigned short v1:9; short v2; unsigned short v3:16; };
struct BFu9s_S_BFu17i { unsigned short v1:9; short v2; unsigned int v3:17; };
struct BFu9s_S_BFu17ll { unsigned short v1:9; short v2; unsigned long long v3:17; };
struct BFu9s_S_BFu1c { unsigned short v1:9; short v2; unsigned char v3:1; };
struct BFu9s_S_BFu1i { unsigned short v1:9; short v2; unsigned int v3:1; };
struct BFu9s_S_BFu1ll { unsigned short v1:9; short v2; unsigned long long v3:1; };
struct BFu9s_S_BFu1s { unsigned short v1:9; short v2; unsigned short v3:1; };
struct BFu9s_S_BFu31i { unsigned short v1:9; short v2; unsigned int v3:31; };
struct BFu9s_S_BFu31ll { unsigned short v1:9; short v2; unsigned long long v3:31; };
struct BFu9s_S_BFu32i { unsigned short v1:9; short v2; unsigned int v3:32; };
struct BFu9s_S_BFu32ll { unsigned short v1:9; short v2; unsigned long long v3:32; };
struct BFu9s_S_BFu33 { unsigned short v1:9; short v2; unsigned long long v3:33; };
struct BFu9s_S_BFu7c { unsigned short v1:9; short v2; unsigned char v3:7; };
struct BFu9s_S_BFu7i { unsigned short v1:9; short v2; unsigned int v3:7; };
struct BFu9s_S_BFu7ll { unsigned short v1:9; short v2; unsigned long long v3:7; };
struct BFu9s_S_BFu7s { unsigned short v1:9; short v2; unsigned short v3:7; };
struct BFu9s_S_BFu8c { unsigned short v1:9; short v2; unsigned char v3:8; };
struct BFu9s_S_BFu8i { unsigned short v1:9; short v2; unsigned int v3:8; };
struct BFu9s_S_BFu8ll { unsigned short v1:9; short v2; unsigned long long v3:8; };
struct BFu9s_S_BFu8s { unsigned short v1:9; short v2; unsigned short v3:8; };
struct BFu9s_S_BFu9i { unsigned short v1:9; short v2; unsigned int v3:9; };
struct BFu9s_S_BFu9ll { unsigned short v1:9; short v2; unsigned long long v3:9; };
struct BFu9s_S_BFu9s { unsigned short v1:9; short v2; unsigned short v3:9; };
struct BFu9s_S_C { unsigned short v1:9; short v2; char v3; };
struct BFu9s_S_D { unsigned short v1:9; short v2; double v3; };
struct BFu9s_S_F { unsigned short v1:9; short v2; float v3; };
struct BFu9s_S_I { unsigned short v1:9; short v2; int v3; };
struct BFu9s_S_Ip { unsigned short v1:9; short v2; int * v3; };
struct BFu9s_S_L { unsigned short v1:9; short v2; long long v3; };
struct BFu9s_S_S { unsigned short v1:9; short v2; short v3; };
struct BFu9s_S_Uc { unsigned short v1:9; short v2; unsigned char v3; };
struct BFu9s_S_Ui { unsigned short v1:9; short v2; unsigned int v3; };
struct BFu9s_S_Ul { unsigned short v1:9; short v2; unsigned long long v3; };
struct BFu9s_S_Us { unsigned short v1:9; short v2; unsigned short v3; };
struct BFu9s_S_Vp { unsigned short v1:9; short v2; void * v3; };
struct BFu9s_Uc { unsigned short v1:9; unsigned char v2; };
struct BFu9s_Uc_BFu15i { unsigned short v1:9; unsigned char v2; unsigned int v3:15; };
struct BFu9s_Uc_BFu15ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:15; };
struct BFu9s_Uc_BFu15s { unsigned short v1:9; unsigned char v2; unsigned short v3:15; };
struct BFu9s_Uc_BFu16i { unsigned short v1:9; unsigned char v2; unsigned int v3:16; };
struct BFu9s_Uc_BFu16ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:16; };
struct BFu9s_Uc_BFu16s { unsigned short v1:9; unsigned char v2; unsigned short v3:16; };
struct BFu9s_Uc_BFu17i { unsigned short v1:9; unsigned char v2; unsigned int v3:17; };
struct BFu9s_Uc_BFu17ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:17; };
struct BFu9s_Uc_BFu1c { unsigned short v1:9; unsigned char v2; unsigned char v3:1; };
struct BFu9s_Uc_BFu1i { unsigned short v1:9; unsigned char v2; unsigned int v3:1; };
struct BFu9s_Uc_BFu1ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:1; };
struct BFu9s_Uc_BFu1s { unsigned short v1:9; unsigned char v2; unsigned short v3:1; };
struct BFu9s_Uc_BFu31i { unsigned short v1:9; unsigned char v2; unsigned int v3:31; };
struct BFu9s_Uc_BFu31ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:31; };
struct BFu9s_Uc_BFu32i { unsigned short v1:9; unsigned char v2; unsigned int v3:32; };
struct BFu9s_Uc_BFu32ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:32; };
struct BFu9s_Uc_BFu33 { unsigned short v1:9; unsigned char v2; unsigned long long v3:33; };
struct BFu9s_Uc_BFu7c { unsigned short v1:9; unsigned char v2; unsigned char v3:7; };
struct BFu9s_Uc_BFu7i { unsigned short v1:9; unsigned char v2; unsigned int v3:7; };
struct BFu9s_Uc_BFu7ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:7; };
struct BFu9s_Uc_BFu7s { unsigned short v1:9; unsigned char v2; unsigned short v3:7; };
struct BFu9s_Uc_BFu8c { unsigned short v1:9; unsigned char v2; unsigned char v3:8; };
struct BFu9s_Uc_BFu8i { unsigned short v1:9; unsigned char v2; unsigned int v3:8; };
struct BFu9s_Uc_BFu8ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:8; };
struct BFu9s_Uc_BFu8s { unsigned short v1:9; unsigned char v2; unsigned short v3:8; };
struct BFu9s_Uc_BFu9i { unsigned short v1:9; unsigned char v2; unsigned int v3:9; };
struct BFu9s_Uc_BFu9ll { unsigned short v1:9; unsigned char v2; unsigned long long v3:9; };
struct BFu9s_Uc_BFu9s { unsigned short v1:9; unsigned char v2; unsigned short v3:9; };
struct BFu9s_Uc_C { unsigned short v1:9; unsigned char v2; char v3; };
struct BFu9s_Uc_D { unsigned short v1:9; unsigned char v2; double v3; };
struct BFu9s_Uc_F { unsigned short v1:9; unsigned char v2; float v3; };
struct BFu9s_Uc_I { unsigned short v1:9; unsigned char v2; int v3; };
struct BFu9s_Uc_Ip { unsigned short v1:9; unsigned char v2; int * v3; };
struct BFu9s_Uc_L { unsigned short v1:9; unsigned char v2; long long v3; };
struct BFu9s_Uc_S { unsigned short v1:9; unsigned char v2; short v3; };
struct BFu9s_Uc_Uc { unsigned short v1:9; unsigned char v2; unsigned char v3; };
struct BFu9s_Uc_Ui { unsigned short v1:9; unsigned char v2; unsigned int v3; };
struct BFu9s_Uc_Ul { unsigned short v1:9; unsigned char v2; unsigned long long v3; };
struct BFu9s_Uc_Us { unsigned short v1:9; unsigned char v2; unsigned short v3; };
struct BFu9s_Uc_Vp { unsigned short v1:9; unsigned char v2; void * v3; };
struct BFu9s_Ui { unsigned short v1:9; unsigned int v2; };
struct BFu9s_Ui_BFu15i { unsigned short v1:9; unsigned int v2; unsigned int v3:15; };
struct BFu9s_Ui_BFu15ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:15; };
struct BFu9s_Ui_BFu15s { unsigned short v1:9; unsigned int v2; unsigned short v3:15; };
struct BFu9s_Ui_BFu16i { unsigned short v1:9; unsigned int v2; unsigned int v3:16; };
struct BFu9s_Ui_BFu16ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:16; };
struct BFu9s_Ui_BFu16s { unsigned short v1:9; unsigned int v2; unsigned short v3:16; };
struct BFu9s_Ui_BFu17i { unsigned short v1:9; unsigned int v2; unsigned int v3:17; };
struct BFu9s_Ui_BFu17ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:17; };
struct BFu9s_Ui_BFu1c { unsigned short v1:9; unsigned int v2; unsigned char v3:1; };
struct BFu9s_Ui_BFu1i { unsigned short v1:9; unsigned int v2; unsigned int v3:1; };
struct BFu9s_Ui_BFu1ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:1; };
struct BFu9s_Ui_BFu1s { unsigned short v1:9; unsigned int v2; unsigned short v3:1; };
struct BFu9s_Ui_BFu31i { unsigned short v1:9; unsigned int v2; unsigned int v3:31; };
struct BFu9s_Ui_BFu31ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:31; };
struct BFu9s_Ui_BFu32i { unsigned short v1:9; unsigned int v2; unsigned int v3:32; };
struct BFu9s_Ui_BFu32ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:32; };
struct BFu9s_Ui_BFu33 { unsigned short v1:9; unsigned int v2; unsigned long long v3:33; };
struct BFu9s_Ui_BFu7c { unsigned short v1:9; unsigned int v2; unsigned char v3:7; };
struct BFu9s_Ui_BFu7i { unsigned short v1:9; unsigned int v2; unsigned int v3:7; };
struct BFu9s_Ui_BFu7ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:7; };
struct BFu9s_Ui_BFu7s { unsigned short v1:9; unsigned int v2; unsigned short v3:7; };
struct BFu9s_Ui_BFu8c { unsigned short v1:9; unsigned int v2; unsigned char v3:8; };
struct BFu9s_Ui_BFu8i { unsigned short v1:9; unsigned int v2; unsigned int v3:8; };
struct BFu9s_Ui_BFu8ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:8; };
struct BFu9s_Ui_BFu8s { unsigned short v1:9; unsigned int v2; unsigned short v3:8; };
struct BFu9s_Ui_BFu9i { unsigned short v1:9; unsigned int v2; unsigned int v3:9; };
struct BFu9s_Ui_BFu9ll { unsigned short v1:9; unsigned int v2; unsigned long long v3:9; };
struct BFu9s_Ui_BFu9s { unsigned short v1:9; unsigned int v2; unsigned short v3:9; };
struct BFu9s_Ui_C { unsigned short v1:9; unsigned int v2; char v3; };
struct BFu9s_Ui_D { unsigned short v1:9; unsigned int v2; double v3; };
struct BFu9s_Ui_F { unsigned short v1:9; unsigned int v2; float v3; };
struct BFu9s_Ui_I { unsigned short v1:9; unsigned int v2; int v3; };
struct BFu9s_Ui_Ip { unsigned short v1:9; unsigned int v2; int * v3; };
struct BFu9s_Ui_L { unsigned short v1:9; unsigned int v2; long long v3; };
struct BFu9s_Ui_S { unsigned short v1:9; unsigned int v2; short v3; };
struct BFu9s_Ui_Uc { unsigned short v1:9; unsigned int v2; unsigned char v3; };
struct BFu9s_Ui_Ui { unsigned short v1:9; unsigned int v2; unsigned int v3; };
struct BFu9s_Ui_Ul { unsigned short v1:9; unsigned int v2; unsigned long long v3; };
struct BFu9s_Ui_Us { unsigned short v1:9; unsigned int v2; unsigned short v3; };
struct BFu9s_Ui_Vp { unsigned short v1:9; unsigned int v2; void * v3; };
struct BFu9s_Ul { unsigned short v1:9; unsigned long long v2; };
struct BFu9s_Ul_BFu15i { unsigned short v1:9; unsigned long long v2; unsigned int v3:15; };
struct BFu9s_Ul_BFu15ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:15; };
struct BFu9s_Ul_BFu15s { unsigned short v1:9; unsigned long long v2; unsigned short v3:15; };
struct BFu9s_Ul_BFu16i { unsigned short v1:9; unsigned long long v2; unsigned int v3:16; };
struct BFu9s_Ul_BFu16ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:16; };
struct BFu9s_Ul_BFu16s { unsigned short v1:9; unsigned long long v2; unsigned short v3:16; };
struct BFu9s_Ul_BFu17i { unsigned short v1:9; unsigned long long v2; unsigned int v3:17; };
struct BFu9s_Ul_BFu17ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:17; };
struct BFu9s_Ul_BFu1c { unsigned short v1:9; unsigned long long v2; unsigned char v3:1; };
struct BFu9s_Ul_BFu1i { unsigned short v1:9; unsigned long long v2; unsigned int v3:1; };
struct BFu9s_Ul_BFu1ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:1; };
struct BFu9s_Ul_BFu1s { unsigned short v1:9; unsigned long long v2; unsigned short v3:1; };
struct BFu9s_Ul_BFu31i { unsigned short v1:9; unsigned long long v2; unsigned int v3:31; };
struct BFu9s_Ul_BFu31ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:31; };
struct BFu9s_Ul_BFu32i { unsigned short v1:9; unsigned long long v2; unsigned int v3:32; };
struct BFu9s_Ul_BFu32ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:32; };
struct BFu9s_Ul_BFu33 { unsigned short v1:9; unsigned long long v2; unsigned long long v3:33; };
struct BFu9s_Ul_BFu7c { unsigned short v1:9; unsigned long long v2; unsigned char v3:7; };
struct BFu9s_Ul_BFu7i { unsigned short v1:9; unsigned long long v2; unsigned int v3:7; };
struct BFu9s_Ul_BFu7ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:7; };
struct BFu9s_Ul_BFu7s { unsigned short v1:9; unsigned long long v2; unsigned short v3:7; };
struct BFu9s_Ul_BFu8c { unsigned short v1:9; unsigned long long v2; unsigned char v3:8; };
struct BFu9s_Ul_BFu8i { unsigned short v1:9; unsigned long long v2; unsigned int v3:8; };
struct BFu9s_Ul_BFu8ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:8; };
struct BFu9s_Ul_BFu8s { unsigned short v1:9; unsigned long long v2; unsigned short v3:8; };
struct BFu9s_Ul_BFu9i { unsigned short v1:9; unsigned long long v2; unsigned int v3:9; };
struct BFu9s_Ul_BFu9ll { unsigned short v1:9; unsigned long long v2; unsigned long long v3:9; };
struct BFu9s_Ul_BFu9s { unsigned short v1:9; unsigned long long v2; unsigned short v3:9; };
struct BFu9s_Ul_C { unsigned short v1:9; unsigned long long v2; char v3; };
struct BFu9s_Ul_D { unsigned short v1:9; unsigned long long v2; double v3; };
struct BFu9s_Ul_F { unsigned short v1:9; unsigned long long v2; float v3; };
struct BFu9s_Ul_I { unsigned short v1:9; unsigned long long v2; int v3; };
struct BFu9s_Ul_Ip { unsigned short v1:9; unsigned long long v2; int * v3; };
struct BFu9s_Ul_L { unsigned short v1:9; unsigned long long v2; long long v3; };
struct BFu9s_Ul_S { unsigned short v1:9; unsigned long long v2; short v3; };
struct BFu9s_Ul_Uc { unsigned short v1:9; unsigned long long v2; unsigned char v3; };
struct BFu9s_Ul_Ui { unsigned short v1:9; unsigned long long v2; unsigned int v3; };
struct BFu9s_Ul_Ul { unsigned short v1:9; unsigned long long v2; unsigned long long v3; };
struct BFu9s_Ul_Us { unsigned short v1:9; unsigned long long v2; unsigned short v3; };
struct BFu9s_Ul_Vp { unsigned short v1:9; unsigned long long v2; void * v3; };
struct BFu9s_Us { unsigned short v1:9; unsigned short v2; };
struct BFu9s_Us_BFu15i { unsigned short v1:9; unsigned short v2; unsigned int v3:15; };
struct BFu9s_Us_BFu15ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:15; };
struct BFu9s_Us_BFu15s { unsigned short v1:9; unsigned short v2; unsigned short v3:15; };
struct BFu9s_Us_BFu16i { unsigned short v1:9; unsigned short v2; unsigned int v3:16; };
struct BFu9s_Us_BFu16ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:16; };
struct BFu9s_Us_BFu16s { unsigned short v1:9; unsigned short v2; unsigned short v3:16; };
struct BFu9s_Us_BFu17i { unsigned short v1:9; unsigned short v2; unsigned int v3:17; };
struct BFu9s_Us_BFu17ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:17; };
struct BFu9s_Us_BFu1c { unsigned short v1:9; unsigned short v2; unsigned char v3:1; };
struct BFu9s_Us_BFu1i { unsigned short v1:9; unsigned short v2; unsigned int v3:1; };
struct BFu9s_Us_BFu1ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:1; };
struct BFu9s_Us_BFu1s { unsigned short v1:9; unsigned short v2; unsigned short v3:1; };
struct BFu9s_Us_BFu31i { unsigned short v1:9; unsigned short v2; unsigned int v3:31; };
struct BFu9s_Us_BFu31ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:31; };
struct BFu9s_Us_BFu32i { unsigned short v1:9; unsigned short v2; unsigned int v3:32; };
struct BFu9s_Us_BFu32ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:32; };
struct BFu9s_Us_BFu33 { unsigned short v1:9; unsigned short v2; unsigned long long v3:33; };
struct BFu9s_Us_BFu7c { unsigned short v1:9; unsigned short v2; unsigned char v3:7; };
struct BFu9s_Us_BFu7i { unsigned short v1:9; unsigned short v2; unsigned int v3:7; };
struct BFu9s_Us_BFu7ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:7; };
struct BFu9s_Us_BFu7s { unsigned short v1:9; unsigned short v2; unsigned short v3:7; };
struct BFu9s_Us_BFu8c { unsigned short v1:9; unsigned short v2; unsigned char v3:8; };
struct BFu9s_Us_BFu8i { unsigned short v1:9; unsigned short v2; unsigned int v3:8; };
struct BFu9s_Us_BFu8ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:8; };
struct BFu9s_Us_BFu8s { unsigned short v1:9; unsigned short v2; unsigned short v3:8; };
struct BFu9s_Us_BFu9i { unsigned short v1:9; unsigned short v2; unsigned int v3:9; };
struct BFu9s_Us_BFu9ll { unsigned short v1:9; unsigned short v2; unsigned long long v3:9; };
struct BFu9s_Us_BFu9s { unsigned short v1:9; unsigned short v2; unsigned short v3:9; };
struct BFu9s_Us_C { unsigned short v1:9; unsigned short v2; char v3; };
struct BFu9s_Us_D { unsigned short v1:9; unsigned short v2; double v3; };
struct BFu9s_Us_F { unsigned short v1:9; unsigned short v2; float v3; };
struct BFu9s_Us_I { unsigned short v1:9; unsigned short v2; int v3; };
struct BFu9s_Us_Ip { unsigned short v1:9; unsigned short v2; int * v3; };
struct BFu9s_Us_L { unsigned short v1:9; unsigned short v2; long long v3; };
struct BFu9s_Us_S { unsigned short v1:9; unsigned short v2; short v3; };
struct BFu9s_Us_Uc { unsigned short v1:9; unsigned short v2; unsigned char v3; };
struct BFu9s_Us_Ui { unsigned short v1:9; unsigned short v2; unsigned int v3; };
struct BFu9s_Us_Ul { unsigned short v1:9; unsigned short v2; unsigned long long v3; };
struct BFu9s_Us_Us { unsigned short v1:9; unsigned short v2; unsigned short v3; };
struct BFu9s_Us_Vp { unsigned short v1:9; unsigned short v2; void * v3; };
struct BFu9s_Vp { unsigned short v1:9; void * v2; };
struct BFu9s_Vp_BFu15i { unsigned short v1:9; void * v2; unsigned int v3:15; };
struct BFu9s_Vp_BFu15ll { unsigned short v1:9; void * v2; unsigned long long v3:15; };
struct BFu9s_Vp_BFu15s { unsigned short v1:9; void * v2; unsigned short v3:15; };
struct BFu9s_Vp_BFu16i { unsigned short v1:9; void * v2; unsigned int v3:16; };
struct BFu9s_Vp_BFu16ll { unsigned short v1:9; void * v2; unsigned long long v3:16; };
struct BFu9s_Vp_BFu16s { unsigned short v1:9; void * v2; unsigned short v3:16; };
struct BFu9s_Vp_BFu17i { unsigned short v1:9; void * v2; unsigned int v3:17; };
struct BFu9s_Vp_BFu17ll { unsigned short v1:9; void * v2; unsigned long long v3:17; };
struct BFu9s_Vp_BFu1c { unsigned short v1:9; void * v2; unsigned char v3:1; };
struct BFu9s_Vp_BFu1i { unsigned short v1:9; void * v2; unsigned int v3:1; };
struct BFu9s_Vp_BFu1ll { unsigned short v1:9; void * v2; unsigned long long v3:1; };
struct BFu9s_Vp_BFu1s { unsigned short v1:9; void * v2; unsigned short v3:1; };
struct BFu9s_Vp_BFu31i { unsigned short v1:9; void * v2; unsigned int v3:31; };
struct BFu9s_Vp_BFu31ll { unsigned short v1:9; void * v2; unsigned long long v3:31; };
struct BFu9s_Vp_BFu32i { unsigned short v1:9; void * v2; unsigned int v3:32; };
struct BFu9s_Vp_BFu32ll { unsigned short v1:9; void * v2; unsigned long long v3:32; };
struct BFu9s_Vp_BFu33 { unsigned short v1:9; void * v2; unsigned long long v3:33; };
struct BFu9s_Vp_BFu7c { unsigned short v1:9; void * v2; unsigned char v3:7; };
struct BFu9s_Vp_BFu7i { unsigned short v1:9; void * v2; unsigned int v3:7; };
struct BFu9s_Vp_BFu7ll { unsigned short v1:9; void * v2; unsigned long long v3:7; };
struct BFu9s_Vp_BFu7s { unsigned short v1:9; void * v2; unsigned short v3:7; };
struct BFu9s_Vp_BFu8c { unsigned short v1:9; void * v2; unsigned char v3:8; };
struct BFu9s_Vp_BFu8i { unsigned short v1:9; void * v2; unsigned int v3:8; };
struct BFu9s_Vp_BFu8ll { unsigned short v1:9; void * v2; unsigned long long v3:8; };
struct BFu9s_Vp_BFu8s { unsigned short v1:9; void * v2; unsigned short v3:8; };
struct BFu9s_Vp_BFu9i { unsigned short v1:9; void * v2; unsigned int v3:9; };
struct BFu9s_Vp_BFu9ll { unsigned short v1:9; void * v2; unsigned long long v3:9; };
struct BFu9s_Vp_BFu9s { unsigned short v1:9; void * v2; unsigned short v3:9; };
struct BFu9s_Vp_C { unsigned short v1:9; void * v2; char v3; };
struct BFu9s_Vp_D { unsigned short v1:9; void * v2; double v3; };
struct BFu9s_Vp_F { unsigned short v1:9; void * v2; float v3; };
struct BFu9s_Vp_I { unsigned short v1:9; void * v2; int v3; };
struct BFu9s_Vp_Ip { unsigned short v1:9; void * v2; int * v3; };
struct BFu9s_Vp_L { unsigned short v1:9; void * v2; long long v3; };
struct BFu9s_Vp_S { unsigned short v1:9; void * v2; short v3; };
struct BFu9s_Vp_Uc { unsigned short v1:9; void * v2; unsigned char v3; };
struct BFu9s_Vp_Ui { unsigned short v1:9; void * v2; unsigned int v3; };
struct BFu9s_Vp_Ul { unsigned short v1:9; void * v2; unsigned long long v3; };
struct BFu9s_Vp_Us { unsigned short v1:9; void * v2; unsigned short v3; };
struct BFu9s_Vp_Vp { unsigned short v1:9; void * v2; void * v3; };
struct C { char v1; };
struct C_BFu15i { char v1; unsigned int v2:15; };
struct C_BFu15i_BFu15i { char v1; unsigned int v2:15; unsigned int v3:15; };
struct C_BFu15i_BFu15ll { char v1; unsigned int v2:15; unsigned long long v3:15; };
struct C_BFu15i_BFu15s { char v1; unsigned int v2:15; unsigned short v3:15; };
struct C_BFu15i_BFu16i { char v1; unsigned int v2:15; unsigned int v3:16; };
struct C_BFu15i_BFu16ll { char v1; unsigned int v2:15; unsigned long long v3:16; };
struct C_BFu15i_BFu16s { char v1; unsigned int v2:15; unsigned short v3:16; };
struct C_BFu15i_BFu17i { char v1; unsigned int v2:15; unsigned int v3:17; };
struct C_BFu15i_BFu17ll { char v1; unsigned int v2:15; unsigned long long v3:17; };
struct C_BFu15i_BFu1c { char v1; unsigned int v2:15; unsigned char v3:1; };
struct C_BFu15i_BFu1i { char v1; unsigned int v2:15; unsigned int v3:1; };
struct C_BFu15i_BFu1ll { char v1; unsigned int v2:15; unsigned long long v3:1; };
struct C_BFu15i_BFu1s { char v1; unsigned int v2:15; unsigned short v3:1; };
struct C_BFu15i_BFu31i { char v1; unsigned int v2:15; unsigned int v3:31; };
struct C_BFu15i_BFu31ll { char v1; unsigned int v2:15; unsigned long long v3:31; };
struct C_BFu15i_BFu32i { char v1; unsigned int v2:15; unsigned int v3:32; };
struct C_BFu15i_BFu32ll { char v1; unsigned int v2:15; unsigned long long v3:32; };
struct C_BFu15i_BFu33 { char v1; unsigned int v2:15; unsigned long long v3:33; };
struct C_BFu15i_BFu7c { char v1; unsigned int v2:15; unsigned char v3:7; };
struct C_BFu15i_BFu7i { char v1; unsigned int v2:15; unsigned int v3:7; };
struct C_BFu15i_BFu7ll { char v1; unsigned int v2:15; unsigned long long v3:7; };
struct C_BFu15i_BFu7s { char v1; unsigned int v2:15; unsigned short v3:7; };
struct C_BFu15i_BFu8c { char v1; unsigned int v2:15; unsigned char v3:8; };
struct C_BFu15i_BFu8i { char v1; unsigned int v2:15; unsigned int v3:8; };
struct C_BFu15i_BFu8ll { char v1; unsigned int v2:15; unsigned long long v3:8; };
struct C_BFu15i_BFu8s { char v1; unsigned int v2:15; unsigned short v3:8; };
struct C_BFu15i_BFu9i { char v1; unsigned int v2:15; unsigned int v3:9; };
struct C_BFu15i_BFu9ll { char v1; unsigned int v2:15; unsigned long long v3:9; };
struct C_BFu15i_BFu9s { char v1; unsigned int v2:15; unsigned short v3:9; };
struct C_BFu15i_C { char v1; unsigned int v2:15; char v3; };
struct C_BFu15i_D { char v1; unsigned int v2:15; double v3; };
struct C_BFu15i_F { char v1; unsigned int v2:15; float v3; };
struct C_BFu15i_I { char v1; unsigned int v2:15; int v3; };
struct C_BFu15i_Ip { char v1; unsigned int v2:15; int * v3; };
struct C_BFu15i_L { char v1; unsigned int v2:15; long long v3; };
struct C_BFu15i_S { char v1; unsigned int v2:15; short v3; };
struct C_BFu15i_Uc { char v1; unsigned int v2:15; unsigned char v3; };
struct C_BFu15i_Ui { char v1; unsigned int v2:15; unsigned int v3; };
struct C_BFu15i_Ul { char v1; unsigned int v2:15; unsigned long long v3; };
struct C_BFu15i_Us { char v1; unsigned int v2:15; unsigned short v3; };
struct C_BFu15i_Vp { char v1; unsigned int v2:15; void * v3; };
struct C_BFu15ll { char v1; unsigned long long v2:15; };
struct C_BFu15ll_BFu15i { char v1; unsigned long long v2:15; unsigned int v3:15; };
struct C_BFu15ll_BFu15ll { char v1; unsigned long long v2:15; unsigned long long v3:15; };
struct C_BFu15ll_BFu15s { char v1; unsigned long long v2:15; unsigned short v3:15; };
struct C_BFu15ll_BFu16i { char v1; unsigned long long v2:15; unsigned int v3:16; };
struct C_BFu15ll_BFu16ll { char v1; unsigned long long v2:15; unsigned long long v3:16; };
struct C_BFu15ll_BFu16s { char v1; unsigned long long v2:15; unsigned short v3:16; };
struct C_BFu15ll_BFu17i { char v1; unsigned long long v2:15; unsigned int v3:17; };
struct C_BFu15ll_BFu17ll { char v1; unsigned long long v2:15; unsigned long long v3:17; };
struct C_BFu15ll_BFu1c { char v1; unsigned long long v2:15; unsigned char v3:1; };
struct C_BFu15ll_BFu1i { char v1; unsigned long long v2:15; unsigned int v3:1; };
struct C_BFu15ll_BFu1ll { char v1; unsigned long long v2:15; unsigned long long v3:1; };
struct C_BFu15ll_BFu1s { char v1; unsigned long long v2:15; unsigned short v3:1; };
struct C_BFu15ll_BFu31i { char v1; unsigned long long v2:15; unsigned int v3:31; };
struct C_BFu15ll_BFu31ll { char v1; unsigned long long v2:15; unsigned long long v3:31; };
struct C_BFu15ll_BFu32i { char v1; unsigned long long v2:15; unsigned int v3:32; };
struct C_BFu15ll_BFu32ll { char v1; unsigned long long v2:15; unsigned long long v3:32; };
struct C_BFu15ll_BFu33 { char v1; unsigned long long v2:15; unsigned long long v3:33; };
struct C_BFu15ll_BFu7c { char v1; unsigned long long v2:15; unsigned char v3:7; };
struct C_BFu15ll_BFu7i { char v1; unsigned long long v2:15; unsigned int v3:7; };
struct C_BFu15ll_BFu7ll { char v1; unsigned long long v2:15; unsigned long long v3:7; };
struct C_BFu15ll_BFu7s { char v1; unsigned long long v2:15; unsigned short v3:7; };
struct C_BFu15ll_BFu8c { char v1; unsigned long long v2:15; unsigned char v3:8; };
struct C_BFu15ll_BFu8i { char v1; unsigned long long v2:15; unsigned int v3:8; };
struct C_BFu15ll_BFu8ll { char v1; unsigned long long v2:15; unsigned long long v3:8; };
struct C_BFu15ll_BFu8s { char v1; unsigned long long v2:15; unsigned short v3:8; };
struct C_BFu15ll_BFu9i { char v1; unsigned long long v2:15; unsigned int v3:9; };
struct C_BFu15ll_BFu9ll { char v1; unsigned long long v2:15; unsigned long long v3:9; };
struct C_BFu15ll_BFu9s { char v1; unsigned long long v2:15; unsigned short v3:9; };
struct C_BFu15ll_C { char v1; unsigned long long v2:15; char v3; };
struct C_BFu15ll_D { char v1; unsigned long long v2:15; double v3; };
struct C_BFu15ll_F { char v1; unsigned long long v2:15; float v3; };
struct C_BFu15ll_I { char v1; unsigned long long v2:15; int v3; };
struct C_BFu15ll_Ip { char v1; unsigned long long v2:15; int * v3; };
struct C_BFu15ll_L { char v1; unsigned long long v2:15; long long v3; };
struct C_BFu15ll_S { char v1; unsigned long long v2:15; short v3; };
struct C_BFu15ll_Uc { char v1; unsigned long long v2:15; unsigned char v3; };
struct C_BFu15ll_Ui { char v1; unsigned long long v2:15; unsigned int v3; };
struct C_BFu15ll_Ul { char v1; unsigned long long v2:15; unsigned long long v3; };
struct C_BFu15ll_Us { char v1; unsigned long long v2:15; unsigned short v3; };
struct C_BFu15ll_Vp { char v1; unsigned long long v2:15; void * v3; };
struct C_BFu15s { char v1; unsigned short v2:15; };
struct C_BFu15s_BFu15i { char v1; unsigned short v2:15; unsigned int v3:15; };
struct C_BFu15s_BFu15ll { char v1; unsigned short v2:15; unsigned long long v3:15; };
struct C_BFu15s_BFu15s { char v1; unsigned short v2:15; unsigned short v3:15; };
struct C_BFu15s_BFu16i { char v1; unsigned short v2:15; unsigned int v3:16; };
struct C_BFu15s_BFu16ll { char v1; unsigned short v2:15; unsigned long long v3:16; };
struct C_BFu15s_BFu16s { char v1; unsigned short v2:15; unsigned short v3:16; };
struct C_BFu15s_BFu17i { char v1; unsigned short v2:15; unsigned int v3:17; };
struct C_BFu15s_BFu17ll { char v1; unsigned short v2:15; unsigned long long v3:17; };
struct C_BFu15s_BFu1c { char v1; unsigned short v2:15; unsigned char v3:1; };
struct C_BFu15s_BFu1i { char v1; unsigned short v2:15; unsigned int v3:1; };
struct C_BFu15s_BFu1ll { char v1; unsigned short v2:15; unsigned long long v3:1; };
struct C_BFu15s_BFu1s { char v1; unsigned short v2:15; unsigned short v3:1; };
struct C_BFu15s_BFu31i { char v1; unsigned short v2:15; unsigned int v3:31; };
struct C_BFu15s_BFu31ll { char v1; unsigned short v2:15; unsigned long long v3:31; };
struct C_BFu15s_BFu32i { char v1; unsigned short v2:15; unsigned int v3:32; };
struct C_BFu15s_BFu32ll { char v1; unsigned short v2:15; unsigned long long v3:32; };
struct C_BFu15s_BFu33 { char v1; unsigned short v2:15; unsigned long long v3:33; };
struct C_BFu15s_BFu7c { char v1; unsigned short v2:15; unsigned char v3:7; };
struct C_BFu15s_BFu7i { char v1; unsigned short v2:15; unsigned int v3:7; };
struct C_BFu15s_BFu7ll { char v1; unsigned short v2:15; unsigned long long v3:7; };
struct C_BFu15s_BFu7s { char v1; unsigned short v2:15; unsigned short v3:7; };
struct C_BFu15s_BFu8c { char v1; unsigned short v2:15; unsigned char v3:8; };
struct C_BFu15s_BFu8i { char v1; unsigned short v2:15; unsigned int v3:8; };
struct C_BFu15s_BFu8ll { char v1; unsigned short v2:15; unsigned long long v3:8; };
struct C_BFu15s_BFu8s { char v1; unsigned short v2:15; unsigned short v3:8; };
struct C_BFu15s_BFu9i { char v1; unsigned short v2:15; unsigned int v3:9; };
struct C_BFu15s_BFu9ll { char v1; unsigned short v2:15; unsigned long long v3:9; };
struct C_BFu15s_BFu9s { char v1; unsigned short v2:15; unsigned short v3:9; };
struct C_BFu15s_C { char v1; unsigned short v2:15; char v3; };
struct C_BFu15s_D { char v1; unsigned short v2:15; double v3; };
struct C_BFu15s_F { char v1; unsigned short v2:15; float v3; };
struct C_BFu15s_I { char v1; unsigned short v2:15; int v3; };
struct C_BFu15s_Ip { char v1; unsigned short v2:15; int * v3; };
struct C_BFu15s_L { char v1; unsigned short v2:15; long long v3; };
struct C_BFu15s_S { char v1; unsigned short v2:15; short v3; };
struct C_BFu15s_Uc { char v1; unsigned short v2:15; unsigned char v3; };
struct C_BFu15s_Ui { char v1; unsigned short v2:15; unsigned int v3; };
struct C_BFu15s_Ul { char v1; unsigned short v2:15; unsigned long long v3; };
struct C_BFu15s_Us { char v1; unsigned short v2:15; unsigned short v3; };
struct C_BFu15s_Vp { char v1; unsigned short v2:15; void * v3; };
struct C_BFu16i { char v1; unsigned int v2:16; };
struct C_BFu16i_BFu15i { char v1; unsigned int v2:16; unsigned int v3:15; };
struct C_BFu16i_BFu15ll { char v1; unsigned int v2:16; unsigned long long v3:15; };
struct C_BFu16i_BFu15s { char v1; unsigned int v2:16; unsigned short v3:15; };
struct C_BFu16i_BFu16i { char v1; unsigned int v2:16; unsigned int v3:16; };
struct C_BFu16i_BFu16ll { char v1; unsigned int v2:16; unsigned long long v3:16; };
struct C_BFu16i_BFu16s { char v1; unsigned int v2:16; unsigned short v3:16; };
struct C_BFu16i_BFu17i { char v1; unsigned int v2:16; unsigned int v3:17; };
struct C_BFu16i_BFu17ll { char v1; unsigned int v2:16; unsigned long long v3:17; };
struct C_BFu16i_BFu1c { char v1; unsigned int v2:16; unsigned char v3:1; };
struct C_BFu16i_BFu1i { char v1; unsigned int v2:16; unsigned int v3:1; };
struct C_BFu16i_BFu1ll { char v1; unsigned int v2:16; unsigned long long v3:1; };
struct C_BFu16i_BFu1s { char v1; unsigned int v2:16; unsigned short v3:1; };
struct C_BFu16i_BFu31i { char v1; unsigned int v2:16; unsigned int v3:31; };
struct C_BFu16i_BFu31ll { char v1; unsigned int v2:16; unsigned long long v3:31; };
struct C_BFu16i_BFu32i { char v1; unsigned int v2:16; unsigned int v3:32; };
struct C_BFu16i_BFu32ll { char v1; unsigned int v2:16; unsigned long long v3:32; };
struct C_BFu16i_BFu33 { char v1; unsigned int v2:16; unsigned long long v3:33; };
struct C_BFu16i_BFu7c { char v1; unsigned int v2:16; unsigned char v3:7; };
struct C_BFu16i_BFu7i { char v1; unsigned int v2:16; unsigned int v3:7; };
struct C_BFu16i_BFu7ll { char v1; unsigned int v2:16; unsigned long long v3:7; };
struct C_BFu16i_BFu7s { char v1; unsigned int v2:16; unsigned short v3:7; };
struct C_BFu16i_BFu8c { char v1; unsigned int v2:16; unsigned char v3:8; };
struct C_BFu16i_BFu8i { char v1; unsigned int v2:16; unsigned int v3:8; };
struct C_BFu16i_BFu8ll { char v1; unsigned int v2:16; unsigned long long v3:8; };
struct C_BFu16i_BFu8s { char v1; unsigned int v2:16; unsigned short v3:8; };
struct C_BFu16i_BFu9i { char v1; unsigned int v2:16; unsigned int v3:9; };
struct C_BFu16i_BFu9ll { char v1; unsigned int v2:16; unsigned long long v3:9; };
struct C_BFu16i_BFu9s { char v1; unsigned int v2:16; unsigned short v3:9; };
struct C_BFu16i_C { char v1; unsigned int v2:16; char v3; };
struct C_BFu16i_D { char v1; unsigned int v2:16; double v3; };
struct C_BFu16i_F { char v1; unsigned int v2:16; float v3; };
struct C_BFu16i_I { char v1; unsigned int v2:16; int v3; };
struct C_BFu16i_Ip { char v1; unsigned int v2:16; int * v3; };
struct C_BFu16i_L { char v1; unsigned int v2:16; long long v3; };
struct C_BFu16i_S { char v1; unsigned int v2:16; short v3; };
struct C_BFu16i_Uc { char v1; unsigned int v2:16; unsigned char v3; };
struct C_BFu16i_Ui { char v1; unsigned int v2:16; unsigned int v3; };
struct C_BFu16i_Ul { char v1; unsigned int v2:16; unsigned long long v3; };
struct C_BFu16i_Us { char v1; unsigned int v2:16; unsigned short v3; };
struct C_BFu16i_Vp { char v1; unsigned int v2:16; void * v3; };
struct C_BFu16ll { char v1; unsigned long long v2:16; };
struct C_BFu16ll_BFu15i { char v1; unsigned long long v2:16; unsigned int v3:15; };
struct C_BFu16ll_BFu15ll { char v1; unsigned long long v2:16; unsigned long long v3:15; };
struct C_BFu16ll_BFu15s { char v1; unsigned long long v2:16; unsigned short v3:15; };
struct C_BFu16ll_BFu16i { char v1; unsigned long long v2:16; unsigned int v3:16; };
struct C_BFu16ll_BFu16ll { char v1; unsigned long long v2:16; unsigned long long v3:16; };
struct C_BFu16ll_BFu16s { char v1; unsigned long long v2:16; unsigned short v3:16; };
struct C_BFu16ll_BFu17i { char v1; unsigned long long v2:16; unsigned int v3:17; };
struct C_BFu16ll_BFu17ll { char v1; unsigned long long v2:16; unsigned long long v3:17; };
struct C_BFu16ll_BFu1c { char v1; unsigned long long v2:16; unsigned char v3:1; };
struct C_BFu16ll_BFu1i { char v1; unsigned long long v2:16; unsigned int v3:1; };
struct C_BFu16ll_BFu1ll { char v1; unsigned long long v2:16; unsigned long long v3:1; };
struct C_BFu16ll_BFu1s { char v1; unsigned long long v2:16; unsigned short v3:1; };
struct C_BFu16ll_BFu31i { char v1; unsigned long long v2:16; unsigned int v3:31; };
struct C_BFu16ll_BFu31ll { char v1; unsigned long long v2:16; unsigned long long v3:31; };
struct C_BFu16ll_BFu32i { char v1; unsigned long long v2:16; unsigned int v3:32; };
struct C_BFu16ll_BFu32ll { char v1; unsigned long long v2:16; unsigned long long v3:32; };
struct C_BFu16ll_BFu33 { char v1; unsigned long long v2:16; unsigned long long v3:33; };
struct C_BFu16ll_BFu7c { char v1; unsigned long long v2:16; unsigned char v3:7; };
struct C_BFu16ll_BFu7i { char v1; unsigned long long v2:16; unsigned int v3:7; };
struct C_BFu16ll_BFu7ll { char v1; unsigned long long v2:16; unsigned long long v3:7; };
struct C_BFu16ll_BFu7s { char v1; unsigned long long v2:16; unsigned short v3:7; };
struct C_BFu16ll_BFu8c { char v1; unsigned long long v2:16; unsigned char v3:8; };
struct C_BFu16ll_BFu8i { char v1; unsigned long long v2:16; unsigned int v3:8; };
struct C_BFu16ll_BFu8ll { char v1; unsigned long long v2:16; unsigned long long v3:8; };
struct C_BFu16ll_BFu8s { char v1; unsigned long long v2:16; unsigned short v3:8; };
struct C_BFu16ll_BFu9i { char v1; unsigned long long v2:16; unsigned int v3:9; };
struct C_BFu16ll_BFu9ll { char v1; unsigned long long v2:16; unsigned long long v3:9; };
struct C_BFu16ll_BFu9s { char v1; unsigned long long v2:16; unsigned short v3:9; };
struct C_BFu16ll_C { char v1; unsigned long long v2:16; char v3; };
struct C_BFu16ll_D { char v1; unsigned long long v2:16; double v3; };
struct C_BFu16ll_F { char v1; unsigned long long v2:16; float v3; };
struct C_BFu16ll_I { char v1; unsigned long long v2:16; int v3; };
struct C_BFu16ll_Ip { char v1; unsigned long long v2:16; int * v3; };
struct C_BFu16ll_L { char v1; unsigned long long v2:16; long long v3; };
struct C_BFu16ll_S { char v1; unsigned long long v2:16; short v3; };
struct C_BFu16ll_Uc { char v1; unsigned long long v2:16; unsigned char v3; };
struct C_BFu16ll_Ui { char v1; unsigned long long v2:16; unsigned int v3; };
struct C_BFu16ll_Ul { char v1; unsigned long long v2:16; unsigned long long v3; };
struct C_BFu16ll_Us { char v1; unsigned long long v2:16; unsigned short v3; };
struct C_BFu16ll_Vp { char v1; unsigned long long v2:16; void * v3; };
struct C_BFu16s { char v1; unsigned short v2:16; };
struct C_BFu16s_BFu15i { char v1; unsigned short v2:16; unsigned int v3:15; };
struct C_BFu16s_BFu15ll { char v1; unsigned short v2:16; unsigned long long v3:15; };
struct C_BFu16s_BFu15s { char v1; unsigned short v2:16; unsigned short v3:15; };
struct C_BFu16s_BFu16i { char v1; unsigned short v2:16; unsigned int v3:16; };
struct C_BFu16s_BFu16ll { char v1; unsigned short v2:16; unsigned long long v3:16; };
struct C_BFu16s_BFu16s { char v1; unsigned short v2:16; unsigned short v3:16; };
struct C_BFu16s_BFu17i { char v1; unsigned short v2:16; unsigned int v3:17; };
struct C_BFu16s_BFu17ll { char v1; unsigned short v2:16; unsigned long long v3:17; };
struct C_BFu16s_BFu1c { char v1; unsigned short v2:16; unsigned char v3:1; };
struct C_BFu16s_BFu1i { char v1; unsigned short v2:16; unsigned int v3:1; };
struct C_BFu16s_BFu1ll { char v1; unsigned short v2:16; unsigned long long v3:1; };
struct C_BFu16s_BFu1s { char v1; unsigned short v2:16; unsigned short v3:1; };
struct C_BFu16s_BFu31i { char v1; unsigned short v2:16; unsigned int v3:31; };
struct C_BFu16s_BFu31ll { char v1; unsigned short v2:16; unsigned long long v3:31; };
struct C_BFu16s_BFu32i { char v1; unsigned short v2:16; unsigned int v3:32; };
struct C_BFu16s_BFu32ll { char v1; unsigned short v2:16; unsigned long long v3:32; };
struct C_BFu16s_BFu33 { char v1; unsigned short v2:16; unsigned long long v3:33; };
struct C_BFu16s_BFu7c { char v1; unsigned short v2:16; unsigned char v3:7; };
struct C_BFu16s_BFu7i { char v1; unsigned short v2:16; unsigned int v3:7; };
struct C_BFu16s_BFu7ll { char v1; unsigned short v2:16; unsigned long long v3:7; };
struct C_BFu16s_BFu7s { char v1; unsigned short v2:16; unsigned short v3:7; };
struct C_BFu16s_BFu8c { char v1; unsigned short v2:16; unsigned char v3:8; };
struct C_BFu16s_BFu8i { char v1; unsigned short v2:16; unsigned int v3:8; };
struct C_BFu16s_BFu8ll { char v1; unsigned short v2:16; unsigned long long v3:8; };
struct C_BFu16s_BFu8s { char v1; unsigned short v2:16; unsigned short v3:8; };
struct C_BFu16s_BFu9i { char v1; unsigned short v2:16; unsigned int v3:9; };
struct C_BFu16s_BFu9ll { char v1; unsigned short v2:16; unsigned long long v3:9; };
struct C_BFu16s_BFu9s { char v1; unsigned short v2:16; unsigned short v3:9; };
struct C_BFu16s_C { char v1; unsigned short v2:16; char v3; };
struct C_BFu16s_D { char v1; unsigned short v2:16; double v3; };
struct C_BFu16s_F { char v1; unsigned short v2:16; float v3; };
struct C_BFu16s_I { char v1; unsigned short v2:16; int v3; };
struct C_BFu16s_Ip { char v1; unsigned short v2:16; int * v3; };
struct C_BFu16s_L { char v1; unsigned short v2:16; long long v3; };
struct C_BFu16s_S { char v1; unsigned short v2:16; short v3; };
struct C_BFu16s_Uc { char v1; unsigned short v2:16; unsigned char v3; };
struct C_BFu16s_Ui { char v1; unsigned short v2:16; unsigned int v3; };
struct C_BFu16s_Ul { char v1; unsigned short v2:16; unsigned long long v3; };
struct C_BFu16s_Us { char v1; unsigned short v2:16; unsigned short v3; };
struct C_BFu16s_Vp { char v1; unsigned short v2:16; void * v3; };
struct C_BFu17i { char v1; unsigned int v2:17; };
struct C_BFu17i_BFu15i { char v1; unsigned int v2:17; unsigned int v3:15; };
struct C_BFu17i_BFu15ll { char v1; unsigned int v2:17; unsigned long long v3:15; };
struct C_BFu17i_BFu15s { char v1; unsigned int v2:17; unsigned short v3:15; };
struct C_BFu17i_BFu16i { char v1; unsigned int v2:17; unsigned int v3:16; };
struct C_BFu17i_BFu16ll { char v1; unsigned int v2:17; unsigned long long v3:16; };
struct C_BFu17i_BFu16s { char v1; unsigned int v2:17; unsigned short v3:16; };
struct C_BFu17i_BFu17i { char v1; unsigned int v2:17; unsigned int v3:17; };
struct C_BFu17i_BFu17ll { char v1; unsigned int v2:17; unsigned long long v3:17; };
struct C_BFu17i_BFu1c { char v1; unsigned int v2:17; unsigned char v3:1; };
struct C_BFu17i_BFu1i { char v1; unsigned int v2:17; unsigned int v3:1; };
struct C_BFu17i_BFu1ll { char v1; unsigned int v2:17; unsigned long long v3:1; };
struct C_BFu17i_BFu1s { char v1; unsigned int v2:17; unsigned short v3:1; };
struct C_BFu17i_BFu31i { char v1; unsigned int v2:17; unsigned int v3:31; };
struct C_BFu17i_BFu31ll { char v1; unsigned int v2:17; unsigned long long v3:31; };
struct C_BFu17i_BFu32i { char v1; unsigned int v2:17; unsigned int v3:32; };
struct C_BFu17i_BFu32ll { char v1; unsigned int v2:17; unsigned long long v3:32; };
struct C_BFu17i_BFu33 { char v1; unsigned int v2:17; unsigned long long v3:33; };
struct C_BFu17i_BFu7c { char v1; unsigned int v2:17; unsigned char v3:7; };
struct C_BFu17i_BFu7i { char v1; unsigned int v2:17; unsigned int v3:7; };
struct C_BFu17i_BFu7ll { char v1; unsigned int v2:17; unsigned long long v3:7; };
struct C_BFu17i_BFu7s { char v1; unsigned int v2:17; unsigned short v3:7; };
struct C_BFu17i_BFu8c { char v1; unsigned int v2:17; unsigned char v3:8; };
struct C_BFu17i_BFu8i { char v1; unsigned int v2:17; unsigned int v3:8; };
struct C_BFu17i_BFu8ll { char v1; unsigned int v2:17; unsigned long long v3:8; };
struct C_BFu17i_BFu8s { char v1; unsigned int v2:17; unsigned short v3:8; };
struct C_BFu17i_BFu9i { char v1; unsigned int v2:17; unsigned int v3:9; };
struct C_BFu17i_BFu9ll { char v1; unsigned int v2:17; unsigned long long v3:9; };
struct C_BFu17i_BFu9s { char v1; unsigned int v2:17; unsigned short v3:9; };
struct C_BFu17i_C { char v1; unsigned int v2:17; char v3; };
struct C_BFu17i_D { char v1; unsigned int v2:17; double v3; };
struct C_BFu17i_F { char v1; unsigned int v2:17; float v3; };
struct C_BFu17i_I { char v1; unsigned int v2:17; int v3; };
struct C_BFu17i_Ip { char v1; unsigned int v2:17; int * v3; };
struct C_BFu17i_L { char v1; unsigned int v2:17; long long v3; };
struct C_BFu17i_S { char v1; unsigned int v2:17; short v3; };
struct C_BFu17i_Uc { char v1; unsigned int v2:17; unsigned char v3; };
struct C_BFu17i_Ui { char v1; unsigned int v2:17; unsigned int v3; };
struct C_BFu17i_Ul { char v1; unsigned int v2:17; unsigned long long v3; };
struct C_BFu17i_Us { char v1; unsigned int v2:17; unsigned short v3; };
struct C_BFu17i_Vp { char v1; unsigned int v2:17; void * v3; };
struct C_BFu17ll { char v1; unsigned long long v2:17; };
struct C_BFu17ll_BFu15i { char v1; unsigned long long v2:17; unsigned int v3:15; };
struct C_BFu17ll_BFu15ll { char v1; unsigned long long v2:17; unsigned long long v3:15; };
struct C_BFu17ll_BFu15s { char v1; unsigned long long v2:17; unsigned short v3:15; };
struct C_BFu17ll_BFu16i { char v1; unsigned long long v2:17; unsigned int v3:16; };
struct C_BFu17ll_BFu16ll { char v1; unsigned long long v2:17; unsigned long long v3:16; };
struct C_BFu17ll_BFu16s { char v1; unsigned long long v2:17; unsigned short v3:16; };
struct C_BFu17ll_BFu17i { char v1; unsigned long long v2:17; unsigned int v3:17; };
struct C_BFu17ll_BFu17ll { char v1; unsigned long long v2:17; unsigned long long v3:17; };
struct C_BFu17ll_BFu1c { char v1; unsigned long long v2:17; unsigned char v3:1; };
struct C_BFu17ll_BFu1i { char v1; unsigned long long v2:17; unsigned int v3:1; };
struct C_BFu17ll_BFu1ll { char v1; unsigned long long v2:17; unsigned long long v3:1; };
struct C_BFu17ll_BFu1s { char v1; unsigned long long v2:17; unsigned short v3:1; };
struct C_BFu17ll_BFu31i { char v1; unsigned long long v2:17; unsigned int v3:31; };
struct C_BFu17ll_BFu31ll { char v1; unsigned long long v2:17; unsigned long long v3:31; };
struct C_BFu17ll_BFu32i { char v1; unsigned long long v2:17; unsigned int v3:32; };
struct C_BFu17ll_BFu32ll { char v1; unsigned long long v2:17; unsigned long long v3:32; };
struct C_BFu17ll_BFu33 { char v1; unsigned long long v2:17; unsigned long long v3:33; };
struct C_BFu17ll_BFu7c { char v1; unsigned long long v2:17; unsigned char v3:7; };
struct C_BFu17ll_BFu7i { char v1; unsigned long long v2:17; unsigned int v3:7; };
struct C_BFu17ll_BFu7ll { char v1; unsigned long long v2:17; unsigned long long v3:7; };
struct C_BFu17ll_BFu7s { char v1; unsigned long long v2:17; unsigned short v3:7; };
struct C_BFu17ll_BFu8c { char v1; unsigned long long v2:17; unsigned char v3:8; };
struct C_BFu17ll_BFu8i { char v1; unsigned long long v2:17; unsigned int v3:8; };
struct C_BFu17ll_BFu8ll { char v1; unsigned long long v2:17; unsigned long long v3:8; };
struct C_BFu17ll_BFu8s { char v1; unsigned long long v2:17; unsigned short v3:8; };
struct C_BFu17ll_BFu9i { char v1; unsigned long long v2:17; unsigned int v3:9; };
struct C_BFu17ll_BFu9ll { char v1; unsigned long long v2:17; unsigned long long v3:9; };
struct C_BFu17ll_BFu9s { char v1; unsigned long long v2:17; unsigned short v3:9; };
struct C_BFu17ll_C { char v1; unsigned long long v2:17; char v3; };
struct C_BFu17ll_D { char v1; unsigned long long v2:17; double v3; };
struct C_BFu17ll_F { char v1; unsigned long long v2:17; float v3; };
struct C_BFu17ll_I { char v1; unsigned long long v2:17; int v3; };
struct C_BFu17ll_Ip { char v1; unsigned long long v2:17; int * v3; };
struct C_BFu17ll_L { char v1; unsigned long long v2:17; long long v3; };
struct C_BFu17ll_S { char v1; unsigned long long v2:17; short v3; };
struct C_BFu17ll_Uc { char v1; unsigned long long v2:17; unsigned char v3; };
struct C_BFu17ll_Ui { char v1; unsigned long long v2:17; unsigned int v3; };
struct C_BFu17ll_Ul { char v1; unsigned long long v2:17; unsigned long long v3; };
struct C_BFu17ll_Us { char v1; unsigned long long v2:17; unsigned short v3; };
struct C_BFu17ll_Vp { char v1; unsigned long long v2:17; void * v3; };
struct C_BFu1c { char v1; unsigned char v2:1; };
struct C_BFu1c_BFu15i { char v1; unsigned char v2:1; unsigned int v3:15; };
struct C_BFu1c_BFu15ll { char v1; unsigned char v2:1; unsigned long long v3:15; };
struct C_BFu1c_BFu15s { char v1; unsigned char v2:1; unsigned short v3:15; };
struct C_BFu1c_BFu16i { char v1; unsigned char v2:1; unsigned int v3:16; };
struct C_BFu1c_BFu16ll { char v1; unsigned char v2:1; unsigned long long v3:16; };
struct C_BFu1c_BFu16s { char v1; unsigned char v2:1; unsigned short v3:16; };
struct C_BFu1c_BFu17i { char v1; unsigned char v2:1; unsigned int v3:17; };
struct C_BFu1c_BFu17ll { char v1; unsigned char v2:1; unsigned long long v3:17; };
struct C_BFu1c_BFu1c { char v1; unsigned char v2:1; unsigned char v3:1; };
struct C_BFu1c_BFu1i { char v1; unsigned char v2:1; unsigned int v3:1; };
struct C_BFu1c_BFu1ll { char v1; unsigned char v2:1; unsigned long long v3:1; };
struct C_BFu1c_BFu1s { char v1; unsigned char v2:1; unsigned short v3:1; };
struct C_BFu1c_BFu31i { char v1; unsigned char v2:1; unsigned int v3:31; };
struct C_BFu1c_BFu31ll { char v1; unsigned char v2:1; unsigned long long v3:31; };
struct C_BFu1c_BFu32i { char v1; unsigned char v2:1; unsigned int v3:32; };
struct C_BFu1c_BFu32ll { char v1; unsigned char v2:1; unsigned long long v3:32; };
struct C_BFu1c_BFu33 { char v1; unsigned char v2:1; unsigned long long v3:33; };
struct C_BFu1c_BFu7c { char v1; unsigned char v2:1; unsigned char v3:7; };
struct C_BFu1c_BFu7i { char v1; unsigned char v2:1; unsigned int v3:7; };
struct C_BFu1c_BFu7ll { char v1; unsigned char v2:1; unsigned long long v3:7; };
struct C_BFu1c_BFu7s { char v1; unsigned char v2:1; unsigned short v3:7; };
struct C_BFu1c_BFu8c { char v1; unsigned char v2:1; unsigned char v3:8; };
struct C_BFu1c_BFu8i { char v1; unsigned char v2:1; unsigned int v3:8; };
struct C_BFu1c_BFu8ll { char v1; unsigned char v2:1; unsigned long long v3:8; };
struct C_BFu1c_BFu8s { char v1; unsigned char v2:1; unsigned short v3:8; };
struct C_BFu1c_BFu9i { char v1; unsigned char v2:1; unsigned int v3:9; };
struct C_BFu1c_BFu9ll { char v1; unsigned char v2:1; unsigned long long v3:9; };
struct C_BFu1c_BFu9s { char v1; unsigned char v2:1; unsigned short v3:9; };
struct C_BFu1c_C { char v1; unsigned char v2:1; char v3; };
struct C_BFu1c_D { char v1; unsigned char v2:1; double v3; };
struct C_BFu1c_F { char v1; unsigned char v2:1; float v3; };
struct C_BFu1c_I { char v1; unsigned char v2:1; int v3; };
struct C_BFu1c_Ip { char v1; unsigned char v2:1; int * v3; };
struct C_BFu1c_L { char v1; unsigned char v2:1; long long v3; };
struct C_BFu1c_S { char v1; unsigned char v2:1; short v3; };
struct C_BFu1c_Uc { char v1; unsigned char v2:1; unsigned char v3; };
struct C_BFu1c_Ui { char v1; unsigned char v2:1; unsigned int v3; };
struct C_BFu1c_Ul { char v1; unsigned char v2:1; unsigned long long v3; };
struct C_BFu1c_Us { char v1; unsigned char v2:1; unsigned short v3; };
struct C_BFu1c_Vp { char v1; unsigned char v2:1; void * v3; };
struct C_BFu1i { char v1; unsigned int v2:1; };
struct C_BFu1i_BFu15i { char v1; unsigned int v2:1; unsigned int v3:15; };
struct C_BFu1i_BFu15ll { char v1; unsigned int v2:1; unsigned long long v3:15; };
struct C_BFu1i_BFu15s { char v1; unsigned int v2:1; unsigned short v3:15; };
struct C_BFu1i_BFu16i { char v1; unsigned int v2:1; unsigned int v3:16; };
struct C_BFu1i_BFu16ll { char v1; unsigned int v2:1; unsigned long long v3:16; };
struct C_BFu1i_BFu16s { char v1; unsigned int v2:1; unsigned short v3:16; };
struct C_BFu1i_BFu17i { char v1; unsigned int v2:1; unsigned int v3:17; };
struct C_BFu1i_BFu17ll { char v1; unsigned int v2:1; unsigned long long v3:17; };
struct C_BFu1i_BFu1c { char v1; unsigned int v2:1; unsigned char v3:1; };
struct C_BFu1i_BFu1i { char v1; unsigned int v2:1; unsigned int v3:1; };
struct C_BFu1i_BFu1ll { char v1; unsigned int v2:1; unsigned long long v3:1; };
struct C_BFu1i_BFu1s { char v1; unsigned int v2:1; unsigned short v3:1; };
struct C_BFu1i_BFu31i { char v1; unsigned int v2:1; unsigned int v3:31; };
struct C_BFu1i_BFu31ll { char v1; unsigned int v2:1; unsigned long long v3:31; };
struct C_BFu1i_BFu32i { char v1; unsigned int v2:1; unsigned int v3:32; };
struct C_BFu1i_BFu32ll { char v1; unsigned int v2:1; unsigned long long v3:32; };
struct C_BFu1i_BFu33 { char v1; unsigned int v2:1; unsigned long long v3:33; };
struct C_BFu1i_BFu7c { char v1; unsigned int v2:1; unsigned char v3:7; };
struct C_BFu1i_BFu7i { char v1; unsigned int v2:1; unsigned int v3:7; };
struct C_BFu1i_BFu7ll { char v1; unsigned int v2:1; unsigned long long v3:7; };
struct C_BFu1i_BFu7s { char v1; unsigned int v2:1; unsigned short v3:7; };
struct C_BFu1i_BFu8c { char v1; unsigned int v2:1; unsigned char v3:8; };
struct C_BFu1i_BFu8i { char v1; unsigned int v2:1; unsigned int v3:8; };
struct C_BFu1i_BFu8ll { char v1; unsigned int v2:1; unsigned long long v3:8; };
struct C_BFu1i_BFu8s { char v1; unsigned int v2:1; unsigned short v3:8; };
struct C_BFu1i_BFu9i { char v1; unsigned int v2:1; unsigned int v3:9; };
struct C_BFu1i_BFu9ll { char v1; unsigned int v2:1; unsigned long long v3:9; };
struct C_BFu1i_BFu9s { char v1; unsigned int v2:1; unsigned short v3:9; };
struct C_BFu1i_C { char v1; unsigned int v2:1; char v3; };
struct C_BFu1i_D { char v1; unsigned int v2:1; double v3; };
struct C_BFu1i_F { char v1; unsigned int v2:1; float v3; };
struct C_BFu1i_I { char v1; unsigned int v2:1; int v3; };
struct C_BFu1i_Ip { char v1; unsigned int v2:1; int * v3; };
struct C_BFu1i_L { char v1; unsigned int v2:1; long long v3; };
struct C_BFu1i_S { char v1; unsigned int v2:1; short v3; };
struct C_BFu1i_Uc { char v1; unsigned int v2:1; unsigned char v3; };
struct C_BFu1i_Ui { char v1; unsigned int v2:1; unsigned int v3; };
struct C_BFu1i_Ul { char v1; unsigned int v2:1; unsigned long long v3; };
struct C_BFu1i_Us { char v1; unsigned int v2:1; unsigned short v3; };
struct C_BFu1i_Vp { char v1; unsigned int v2:1; void * v3; };
struct C_BFu1ll { char v1; unsigned long long v2:1; };
struct C_BFu1ll_BFu15i { char v1; unsigned long long v2:1; unsigned int v3:15; };
struct C_BFu1ll_BFu15ll { char v1; unsigned long long v2:1; unsigned long long v3:15; };
struct C_BFu1ll_BFu15s { char v1; unsigned long long v2:1; unsigned short v3:15; };
struct C_BFu1ll_BFu16i { char v1; unsigned long long v2:1; unsigned int v3:16; };
struct C_BFu1ll_BFu16ll { char v1; unsigned long long v2:1; unsigned long long v3:16; };
struct C_BFu1ll_BFu16s { char v1; unsigned long long v2:1; unsigned short v3:16; };
struct C_BFu1ll_BFu17i { char v1; unsigned long long v2:1; unsigned int v3:17; };
struct C_BFu1ll_BFu17ll { char v1; unsigned long long v2:1; unsigned long long v3:17; };
struct C_BFu1ll_BFu1c { char v1; unsigned long long v2:1; unsigned char v3:1; };
struct C_BFu1ll_BFu1i { char v1; unsigned long long v2:1; unsigned int v3:1; };
struct C_BFu1ll_BFu1ll { char v1; unsigned long long v2:1; unsigned long long v3:1; };
struct C_BFu1ll_BFu1s { char v1; unsigned long long v2:1; unsigned short v3:1; };
struct C_BFu1ll_BFu31i { char v1; unsigned long long v2:1; unsigned int v3:31; };
struct C_BFu1ll_BFu31ll { char v1; unsigned long long v2:1; unsigned long long v3:31; };
struct C_BFu1ll_BFu32i { char v1; unsigned long long v2:1; unsigned int v3:32; };
struct C_BFu1ll_BFu32ll { char v1; unsigned long long v2:1; unsigned long long v3:32; };
struct C_BFu1ll_BFu33 { char v1; unsigned long long v2:1; unsigned long long v3:33; };
struct C_BFu1ll_BFu7c { char v1; unsigned long long v2:1; unsigned char v3:7; };
struct C_BFu1ll_BFu7i { char v1; unsigned long long v2:1; unsigned int v3:7; };
struct C_BFu1ll_BFu7ll { char v1; unsigned long long v2:1; unsigned long long v3:7; };
struct C_BFu1ll_BFu7s { char v1; unsigned long long v2:1; unsigned short v3:7; };
struct C_BFu1ll_BFu8c { char v1; unsigned long long v2:1; unsigned char v3:8; };
struct C_BFu1ll_BFu8i { char v1; unsigned long long v2:1; unsigned int v3:8; };
struct C_BFu1ll_BFu8ll { char v1; unsigned long long v2:1; unsigned long long v3:8; };
struct C_BFu1ll_BFu8s { char v1; unsigned long long v2:1; unsigned short v3:8; };
struct C_BFu1ll_BFu9i { char v1; unsigned long long v2:1; unsigned int v3:9; };
struct C_BFu1ll_BFu9ll { char v1; unsigned long long v2:1; unsigned long long v3:9; };
struct C_BFu1ll_BFu9s { char v1; unsigned long long v2:1; unsigned short v3:9; };
struct C_BFu1ll_C { char v1; unsigned long long v2:1; char v3; };
struct C_BFu1ll_D { char v1; unsigned long long v2:1; double v3; };
struct C_BFu1ll_F { char v1; unsigned long long v2:1; float v3; };
struct C_BFu1ll_I { char v1; unsigned long long v2:1; int v3; };
struct C_BFu1ll_Ip { char v1; unsigned long long v2:1; int * v3; };
struct C_BFu1ll_L { char v1; unsigned long long v2:1; long long v3; };
struct C_BFu1ll_S { char v1; unsigned long long v2:1; short v3; };
struct C_BFu1ll_Uc { char v1; unsigned long long v2:1; unsigned char v3; };
struct C_BFu1ll_Ui { char v1; unsigned long long v2:1; unsigned int v3; };
struct C_BFu1ll_Ul { char v1; unsigned long long v2:1; unsigned long long v3; };
struct C_BFu1ll_Us { char v1; unsigned long long v2:1; unsigned short v3; };
struct C_BFu1ll_Vp { char v1; unsigned long long v2:1; void * v3; };
struct C_BFu1s { char v1; unsigned short v2:1; };
struct C_BFu1s_BFu15i { char v1; unsigned short v2:1; unsigned int v3:15; };
struct C_BFu1s_BFu15ll { char v1; unsigned short v2:1; unsigned long long v3:15; };
struct C_BFu1s_BFu15s { char v1; unsigned short v2:1; unsigned short v3:15; };
struct C_BFu1s_BFu16i { char v1; unsigned short v2:1; unsigned int v3:16; };
struct C_BFu1s_BFu16ll { char v1; unsigned short v2:1; unsigned long long v3:16; };
struct C_BFu1s_BFu16s { char v1; unsigned short v2:1; unsigned short v3:16; };
struct C_BFu1s_BFu17i { char v1; unsigned short v2:1; unsigned int v3:17; };
struct C_BFu1s_BFu17ll { char v1; unsigned short v2:1; unsigned long long v3:17; };
struct C_BFu1s_BFu1c { char v1; unsigned short v2:1; unsigned char v3:1; };
struct C_BFu1s_BFu1i { char v1; unsigned short v2:1; unsigned int v3:1; };
struct C_BFu1s_BFu1ll { char v1; unsigned short v2:1; unsigned long long v3:1; };
struct C_BFu1s_BFu1s { char v1; unsigned short v2:1; unsigned short v3:1; };
struct C_BFu1s_BFu31i { char v1; unsigned short v2:1; unsigned int v3:31; };
struct C_BFu1s_BFu31ll { char v1; unsigned short v2:1; unsigned long long v3:31; };
struct C_BFu1s_BFu32i { char v1; unsigned short v2:1; unsigned int v3:32; };
struct C_BFu1s_BFu32ll { char v1; unsigned short v2:1; unsigned long long v3:32; };
struct C_BFu1s_BFu33 { char v1; unsigned short v2:1; unsigned long long v3:33; };
struct C_BFu1s_BFu7c { char v1; unsigned short v2:1; unsigned char v3:7; };
struct C_BFu1s_BFu7i { char v1; unsigned short v2:1; unsigned int v3:7; };
struct C_BFu1s_BFu7ll { char v1; unsigned short v2:1; unsigned long long v3:7; };
struct C_BFu1s_BFu7s { char v1; unsigned short v2:1; unsigned short v3:7; };
struct C_BFu1s_BFu8c { char v1; unsigned short v2:1; unsigned char v3:8; };
struct C_BFu1s_BFu8i { char v1; unsigned short v2:1; unsigned int v3:8; };
struct C_BFu1s_BFu8ll { char v1; unsigned short v2:1; unsigned long long v3:8; };
struct C_BFu1s_BFu8s { char v1; unsigned short v2:1; unsigned short v3:8; };
struct C_BFu1s_BFu9i { char v1; unsigned short v2:1; unsigned int v3:9; };
struct C_BFu1s_BFu9ll { char v1; unsigned short v2:1; unsigned long long v3:9; };
struct C_BFu1s_BFu9s { char v1; unsigned short v2:1; unsigned short v3:9; };
struct C_BFu1s_C { char v1; unsigned short v2:1; char v3; };
struct C_BFu1s_D { char v1; unsigned short v2:1; double v3; };
struct C_BFu1s_F { char v1; unsigned short v2:1; float v3; };
struct C_BFu1s_I { char v1; unsigned short v2:1; int v3; };
struct C_BFu1s_Ip { char v1; unsigned short v2:1; int * v3; };
struct C_BFu1s_L { char v1; unsigned short v2:1; long long v3; };
struct C_BFu1s_S { char v1; unsigned short v2:1; short v3; };
struct C_BFu1s_Uc { char v1; unsigned short v2:1; unsigned char v3; };
struct C_BFu1s_Ui { char v1; unsigned short v2:1; unsigned int v3; };
struct C_BFu1s_Ul { char v1; unsigned short v2:1; unsigned long long v3; };
struct C_BFu1s_Us { char v1; unsigned short v2:1; unsigned short v3; };
struct C_BFu1s_Vp { char v1; unsigned short v2:1; void * v3; };
struct C_BFu31i { char v1; unsigned int v2:31; };
struct C_BFu31i_BFu15i { char v1; unsigned int v2:31; unsigned int v3:15; };
struct C_BFu31i_BFu15ll { char v1; unsigned int v2:31; unsigned long long v3:15; };
struct C_BFu31i_BFu15s { char v1; unsigned int v2:31; unsigned short v3:15; };
struct C_BFu31i_BFu16i { char v1; unsigned int v2:31; unsigned int v3:16; };
struct C_BFu31i_BFu16ll { char v1; unsigned int v2:31; unsigned long long v3:16; };
struct C_BFu31i_BFu16s { char v1; unsigned int v2:31; unsigned short v3:16; };
struct C_BFu31i_BFu17i { char v1; unsigned int v2:31; unsigned int v3:17; };
struct C_BFu31i_BFu17ll { char v1; unsigned int v2:31; unsigned long long v3:17; };
struct C_BFu31i_BFu1c { char v1; unsigned int v2:31; unsigned char v3:1; };
struct C_BFu31i_BFu1i { char v1; unsigned int v2:31; unsigned int v3:1; };
struct C_BFu31i_BFu1ll { char v1; unsigned int v2:31; unsigned long long v3:1; };
struct C_BFu31i_BFu1s { char v1; unsigned int v2:31; unsigned short v3:1; };
struct C_BFu31i_BFu31i { char v1; unsigned int v2:31; unsigned int v3:31; };
struct C_BFu31i_BFu31ll { char v1; unsigned int v2:31; unsigned long long v3:31; };
struct C_BFu31i_BFu32i { char v1; unsigned int v2:31; unsigned int v3:32; };
struct C_BFu31i_BFu32ll { char v1; unsigned int v2:31; unsigned long long v3:32; };
struct C_BFu31i_BFu33 { char v1; unsigned int v2:31; unsigned long long v3:33; };
struct C_BFu31i_BFu7c { char v1; unsigned int v2:31; unsigned char v3:7; };
struct C_BFu31i_BFu7i { char v1; unsigned int v2:31; unsigned int v3:7; };
struct C_BFu31i_BFu7ll { char v1; unsigned int v2:31; unsigned long long v3:7; };
struct C_BFu31i_BFu7s { char v1; unsigned int v2:31; unsigned short v3:7; };
struct C_BFu31i_BFu8c { char v1; unsigned int v2:31; unsigned char v3:8; };
struct C_BFu31i_BFu8i { char v1; unsigned int v2:31; unsigned int v3:8; };
struct C_BFu31i_BFu8ll { char v1; unsigned int v2:31; unsigned long long v3:8; };
struct C_BFu31i_BFu8s { char v1; unsigned int v2:31; unsigned short v3:8; };
struct C_BFu31i_BFu9i { char v1; unsigned int v2:31; unsigned int v3:9; };
struct C_BFu31i_BFu9ll { char v1; unsigned int v2:31; unsigned long long v3:9; };
struct C_BFu31i_BFu9s { char v1; unsigned int v2:31; unsigned short v3:9; };
struct C_BFu31i_C { char v1; unsigned int v2:31; char v3; };
struct C_BFu31i_D { char v1; unsigned int v2:31; double v3; };
struct C_BFu31i_F { char v1; unsigned int v2:31; float v3; };
struct C_BFu31i_I { char v1; unsigned int v2:31; int v3; };
struct C_BFu31i_Ip { char v1; unsigned int v2:31; int * v3; };
struct C_BFu31i_L { char v1; unsigned int v2:31; long long v3; };
struct C_BFu31i_S { char v1; unsigned int v2:31; short v3; };
struct C_BFu31i_Uc { char v1; unsigned int v2:31; unsigned char v3; };
struct C_BFu31i_Ui { char v1; unsigned int v2:31; unsigned int v3; };
struct C_BFu31i_Ul { char v1; unsigned int v2:31; unsigned long long v3; };
struct C_BFu31i_Us { char v1; unsigned int v2:31; unsigned short v3; };
struct C_BFu31i_Vp { char v1; unsigned int v2:31; void * v3; };
struct C_BFu31ll { char v1; unsigned long long v2:31; };
struct C_BFu31ll_BFu15i { char v1; unsigned long long v2:31; unsigned int v3:15; };
struct C_BFu31ll_BFu15ll { char v1; unsigned long long v2:31; unsigned long long v3:15; };
struct C_BFu31ll_BFu15s { char v1; unsigned long long v2:31; unsigned short v3:15; };
struct C_BFu31ll_BFu16i { char v1; unsigned long long v2:31; unsigned int v3:16; };
struct C_BFu31ll_BFu16ll { char v1; unsigned long long v2:31; unsigned long long v3:16; };
struct C_BFu31ll_BFu16s { char v1; unsigned long long v2:31; unsigned short v3:16; };
struct C_BFu31ll_BFu17i { char v1; unsigned long long v2:31; unsigned int v3:17; };
struct C_BFu31ll_BFu17ll { char v1; unsigned long long v2:31; unsigned long long v3:17; };
struct C_BFu31ll_BFu1c { char v1; unsigned long long v2:31; unsigned char v3:1; };
struct C_BFu31ll_BFu1i { char v1; unsigned long long v2:31; unsigned int v3:1; };
struct C_BFu31ll_BFu1ll { char v1; unsigned long long v2:31; unsigned long long v3:1; };
struct C_BFu31ll_BFu1s { char v1; unsigned long long v2:31; unsigned short v3:1; };
struct C_BFu31ll_BFu31i { char v1; unsigned long long v2:31; unsigned int v3:31; };
struct C_BFu31ll_BFu31ll { char v1; unsigned long long v2:31; unsigned long long v3:31; };
struct C_BFu31ll_BFu32i { char v1; unsigned long long v2:31; unsigned int v3:32; };
struct C_BFu31ll_BFu32ll { char v1; unsigned long long v2:31; unsigned long long v3:32; };
struct C_BFu31ll_BFu33 { char v1; unsigned long long v2:31; unsigned long long v3:33; };
struct C_BFu31ll_BFu7c { char v1; unsigned long long v2:31; unsigned char v3:7; };
struct C_BFu31ll_BFu7i { char v1; unsigned long long v2:31; unsigned int v3:7; };
struct C_BFu31ll_BFu7ll { char v1; unsigned long long v2:31; unsigned long long v3:7; };
struct C_BFu31ll_BFu7s { char v1; unsigned long long v2:31; unsigned short v3:7; };
struct C_BFu31ll_BFu8c { char v1; unsigned long long v2:31; unsigned char v3:8; };
struct C_BFu31ll_BFu8i { char v1; unsigned long long v2:31; unsigned int v3:8; };
struct C_BFu31ll_BFu8ll { char v1; unsigned long long v2:31; unsigned long long v3:8; };
struct C_BFu31ll_BFu8s { char v1; unsigned long long v2:31; unsigned short v3:8; };
struct C_BFu31ll_BFu9i { char v1; unsigned long long v2:31; unsigned int v3:9; };
struct C_BFu31ll_BFu9ll { char v1; unsigned long long v2:31; unsigned long long v3:9; };
struct C_BFu31ll_BFu9s { char v1; unsigned long long v2:31; unsigned short v3:9; };
struct C_BFu31ll_C { char v1; unsigned long long v2:31; char v3; };
struct C_BFu31ll_D { char v1; unsigned long long v2:31; double v3; };
struct C_BFu31ll_F { char v1; unsigned long long v2:31; float v3; };
struct C_BFu31ll_I { char v1; unsigned long long v2:31; int v3; };
struct C_BFu31ll_Ip { char v1; unsigned long long v2:31; int * v3; };
struct C_BFu31ll_L { char v1; unsigned long long v2:31; long long v3; };
struct C_BFu31ll_S { char v1; unsigned long long v2:31; short v3; };
struct C_BFu31ll_Uc { char v1; unsigned long long v2:31; unsigned char v3; };
struct C_BFu31ll_Ui { char v1; unsigned long long v2:31; unsigned int v3; };
struct C_BFu31ll_Ul { char v1; unsigned long long v2:31; unsigned long long v3; };
struct C_BFu31ll_Us { char v1; unsigned long long v2:31; unsigned short v3; };
struct C_BFu31ll_Vp { char v1; unsigned long long v2:31; void * v3; };
struct C_BFu32i { char v1; unsigned int v2:32; };
struct C_BFu32i_BFu15i { char v1; unsigned int v2:32; unsigned int v3:15; };
struct C_BFu32i_BFu15ll { char v1; unsigned int v2:32; unsigned long long v3:15; };
struct C_BFu32i_BFu15s { char v1; unsigned int v2:32; unsigned short v3:15; };
struct C_BFu32i_BFu16i { char v1; unsigned int v2:32; unsigned int v3:16; };
struct C_BFu32i_BFu16ll { char v1; unsigned int v2:32; unsigned long long v3:16; };
struct C_BFu32i_BFu16s { char v1; unsigned int v2:32; unsigned short v3:16; };
struct C_BFu32i_BFu17i { char v1; unsigned int v2:32; unsigned int v3:17; };
struct C_BFu32i_BFu17ll { char v1; unsigned int v2:32; unsigned long long v3:17; };
struct C_BFu32i_BFu1c { char v1; unsigned int v2:32; unsigned char v3:1; };
struct C_BFu32i_BFu1i { char v1; unsigned int v2:32; unsigned int v3:1; };
struct C_BFu32i_BFu1ll { char v1; unsigned int v2:32; unsigned long long v3:1; };
struct C_BFu32i_BFu1s { char v1; unsigned int v2:32; unsigned short v3:1; };
struct C_BFu32i_BFu31i { char v1; unsigned int v2:32; unsigned int v3:31; };
struct C_BFu32i_BFu31ll { char v1; unsigned int v2:32; unsigned long long v3:31; };
struct C_BFu32i_BFu32i { char v1; unsigned int v2:32; unsigned int v3:32; };
struct C_BFu32i_BFu32ll { char v1; unsigned int v2:32; unsigned long long v3:32; };
struct C_BFu32i_BFu33 { char v1; unsigned int v2:32; unsigned long long v3:33; };
struct C_BFu32i_BFu7c { char v1; unsigned int v2:32; unsigned char v3:7; };
struct C_BFu32i_BFu7i { char v1; unsigned int v2:32; unsigned int v3:7; };
struct C_BFu32i_BFu7ll { char v1; unsigned int v2:32; unsigned long long v3:7; };
struct C_BFu32i_BFu7s { char v1; unsigned int v2:32; unsigned short v3:7; };
struct C_BFu32i_BFu8c { char v1; unsigned int v2:32; unsigned char v3:8; };
struct C_BFu32i_BFu8i { char v1; unsigned int v2:32; unsigned int v3:8; };
struct C_BFu32i_BFu8ll { char v1; unsigned int v2:32; unsigned long long v3:8; };
struct C_BFu32i_BFu8s { char v1; unsigned int v2:32; unsigned short v3:8; };
struct C_BFu32i_BFu9i { char v1; unsigned int v2:32; unsigned int v3:9; };
struct C_BFu32i_BFu9ll { char v1; unsigned int v2:32; unsigned long long v3:9; };
struct C_BFu32i_BFu9s { char v1; unsigned int v2:32; unsigned short v3:9; };
struct C_BFu32i_C { char v1; unsigned int v2:32; char v3; };
struct C_BFu32i_D { char v1; unsigned int v2:32; double v3; };
struct C_BFu32i_F { char v1; unsigned int v2:32; float v3; };
struct C_BFu32i_I { char v1; unsigned int v2:32; int v3; };
struct C_BFu32i_Ip { char v1; unsigned int v2:32; int * v3; };
struct C_BFu32i_L { char v1; unsigned int v2:32; long long v3; };
struct C_BFu32i_S { char v1; unsigned int v2:32; short v3; };
struct C_BFu32i_Uc { char v1; unsigned int v2:32; unsigned char v3; };
struct C_BFu32i_Ui { char v1; unsigned int v2:32; unsigned int v3; };
struct C_BFu32i_Ul { char v1; unsigned int v2:32; unsigned long long v3; };
struct C_BFu32i_Us { char v1; unsigned int v2:32; unsigned short v3; };
struct C_BFu32i_Vp { char v1; unsigned int v2:32; void * v3; };
struct C_BFu32ll { char v1; unsigned long long v2:32; };
struct C_BFu32ll_BFu15i { char v1; unsigned long long v2:32; unsigned int v3:15; };
struct C_BFu32ll_BFu15ll { char v1; unsigned long long v2:32; unsigned long long v3:15; };
struct C_BFu32ll_BFu15s { char v1; unsigned long long v2:32; unsigned short v3:15; };
struct C_BFu32ll_BFu16i { char v1; unsigned long long v2:32; unsigned int v3:16; };
struct C_BFu32ll_BFu16ll { char v1; unsigned long long v2:32; unsigned long long v3:16; };
struct C_BFu32ll_BFu16s { char v1; unsigned long long v2:32; unsigned short v3:16; };
struct C_BFu32ll_BFu17i { char v1; unsigned long long v2:32; unsigned int v3:17; };
struct C_BFu32ll_BFu17ll { char v1; unsigned long long v2:32; unsigned long long v3:17; };
struct C_BFu32ll_BFu1c { char v1; unsigned long long v2:32; unsigned char v3:1; };
struct C_BFu32ll_BFu1i { char v1; unsigned long long v2:32; unsigned int v3:1; };
struct C_BFu32ll_BFu1ll { char v1; unsigned long long v2:32; unsigned long long v3:1; };
struct C_BFu32ll_BFu1s { char v1; unsigned long long v2:32; unsigned short v3:1; };
struct C_BFu32ll_BFu31i { char v1; unsigned long long v2:32; unsigned int v3:31; };
struct C_BFu32ll_BFu31ll { char v1; unsigned long long v2:32; unsigned long long v3:31; };
struct C_BFu32ll_BFu32i { char v1; unsigned long long v2:32; unsigned int v3:32; };
struct C_BFu32ll_BFu32ll { char v1; unsigned long long v2:32; unsigned long long v3:32; };
struct C_BFu32ll_BFu33 { char v1; unsigned long long v2:32; unsigned long long v3:33; };
struct C_BFu32ll_BFu7c { char v1; unsigned long long v2:32; unsigned char v3:7; };
struct C_BFu32ll_BFu7i { char v1; unsigned long long v2:32; unsigned int v3:7; };
struct C_BFu32ll_BFu7ll { char v1; unsigned long long v2:32; unsigned long long v3:7; };
struct C_BFu32ll_BFu7s { char v1; unsigned long long v2:32; unsigned short v3:7; };
struct C_BFu32ll_BFu8c { char v1; unsigned long long v2:32; unsigned char v3:8; };
struct C_BFu32ll_BFu8i { char v1; unsigned long long v2:32; unsigned int v3:8; };
struct C_BFu32ll_BFu8ll { char v1; unsigned long long v2:32; unsigned long long v3:8; };
struct C_BFu32ll_BFu8s { char v1; unsigned long long v2:32; unsigned short v3:8; };
struct C_BFu32ll_BFu9i { char v1; unsigned long long v2:32; unsigned int v3:9; };
struct C_BFu32ll_BFu9ll { char v1; unsigned long long v2:32; unsigned long long v3:9; };
struct C_BFu32ll_BFu9s { char v1; unsigned long long v2:32; unsigned short v3:9; };
struct C_BFu32ll_C { char v1; unsigned long long v2:32; char v3; };
struct C_BFu32ll_D { char v1; unsigned long long v2:32; double v3; };
struct C_BFu32ll_F { char v1; unsigned long long v2:32; float v3; };
struct C_BFu32ll_I { char v1; unsigned long long v2:32; int v3; };
struct C_BFu32ll_Ip { char v1; unsigned long long v2:32; int * v3; };
struct C_BFu32ll_L { char v1; unsigned long long v2:32; long long v3; };
struct C_BFu32ll_S { char v1; unsigned long long v2:32; short v3; };
struct C_BFu32ll_Uc { char v1; unsigned long long v2:32; unsigned char v3; };
struct C_BFu32ll_Ui { char v1; unsigned long long v2:32; unsigned int v3; };
struct C_BFu32ll_Ul { char v1; unsigned long long v2:32; unsigned long long v3; };
struct C_BFu32ll_Us { char v1; unsigned long long v2:32; unsigned short v3; };
struct C_BFu32ll_Vp { char v1; unsigned long long v2:32; void * v3; };
struct C_BFu33 { char v1; unsigned long long v2:33; };
struct C_BFu33_BFu15i { char v1; unsigned long long v2:33; unsigned int v3:15; };
struct C_BFu33_BFu15ll { char v1; unsigned long long v2:33; unsigned long long v3:15; };
struct C_BFu33_BFu15s { char v1; unsigned long long v2:33; unsigned short v3:15; };
struct C_BFu33_BFu16i { char v1; unsigned long long v2:33; unsigned int v3:16; };
struct C_BFu33_BFu16ll { char v1; unsigned long long v2:33; unsigned long long v3:16; };
struct C_BFu33_BFu16s { char v1; unsigned long long v2:33; unsigned short v3:16; };
struct C_BFu33_BFu17i { char v1; unsigned long long v2:33; unsigned int v3:17; };
struct C_BFu33_BFu17ll { char v1; unsigned long long v2:33; unsigned long long v3:17; };
struct C_BFu33_BFu1c { char v1; unsigned long long v2:33; unsigned char v3:1; };
struct C_BFu33_BFu1i { char v1; unsigned long long v2:33; unsigned int v3:1; };
struct C_BFu33_BFu1ll { char v1; unsigned long long v2:33; unsigned long long v3:1; };
struct C_BFu33_BFu1s { char v1; unsigned long long v2:33; unsigned short v3:1; };
struct C_BFu33_BFu31i { char v1; unsigned long long v2:33; unsigned int v3:31; };
struct C_BFu33_BFu31ll { char v1; unsigned long long v2:33; unsigned long long v3:31; };
struct C_BFu33_BFu32i { char v1; unsigned long long v2:33; unsigned int v3:32; };
struct C_BFu33_BFu32ll { char v1; unsigned long long v2:33; unsigned long long v3:32; };
struct C_BFu33_BFu33 { char v1; unsigned long long v2:33; unsigned long long v3:33; };
struct C_BFu33_BFu7c { char v1; unsigned long long v2:33; unsigned char v3:7; };
struct C_BFu33_BFu7i { char v1; unsigned long long v2:33; unsigned int v3:7; };
struct C_BFu33_BFu7ll { char v1; unsigned long long v2:33; unsigned long long v3:7; };
struct C_BFu33_BFu7s { char v1; unsigned long long v2:33; unsigned short v3:7; };
struct C_BFu33_BFu8c { char v1; unsigned long long v2:33; unsigned char v3:8; };
struct C_BFu33_BFu8i { char v1; unsigned long long v2:33; unsigned int v3:8; };
struct C_BFu33_BFu8ll { char v1; unsigned long long v2:33; unsigned long long v3:8; };
struct C_BFu33_BFu8s { char v1; unsigned long long v2:33; unsigned short v3:8; };
struct C_BFu33_BFu9i { char v1; unsigned long long v2:33; unsigned int v3:9; };
struct C_BFu33_BFu9ll { char v1; unsigned long long v2:33; unsigned long long v3:9; };
struct C_BFu33_BFu9s { char v1; unsigned long long v2:33; unsigned short v3:9; };
struct C_BFu33_C { char v1; unsigned long long v2:33; char v3; };
struct C_BFu33_D { char v1; unsigned long long v2:33; double v3; };
struct C_BFu33_F { char v1; unsigned long long v2:33; float v3; };
struct C_BFu33_I { char v1; unsigned long long v2:33; int v3; };
struct C_BFu33_Ip { char v1; unsigned long long v2:33; int * v3; };
struct C_BFu33_L { char v1; unsigned long long v2:33; long long v3; };
struct C_BFu33_S { char v1; unsigned long long v2:33; short v3; };
struct C_BFu33_Uc { char v1; unsigned long long v2:33; unsigned char v3; };
struct C_BFu33_Ui { char v1; unsigned long long v2:33; unsigned int v3; };
struct C_BFu33_Ul { char v1; unsigned long long v2:33; unsigned long long v3; };
struct C_BFu33_Us { char v1; unsigned long long v2:33; unsigned short v3; };
struct C_BFu33_Vp { char v1; unsigned long long v2:33; void * v3; };
struct C_BFu7c { char v1; unsigned char v2:7; };
struct C_BFu7c_BFu15i { char v1; unsigned char v2:7; unsigned int v3:15; };
struct C_BFu7c_BFu15ll { char v1; unsigned char v2:7; unsigned long long v3:15; };
struct C_BFu7c_BFu15s { char v1; unsigned char v2:7; unsigned short v3:15; };
struct C_BFu7c_BFu16i { char v1; unsigned char v2:7; unsigned int v3:16; };
struct C_BFu7c_BFu16ll { char v1; unsigned char v2:7; unsigned long long v3:16; };
struct C_BFu7c_BFu16s { char v1; unsigned char v2:7; unsigned short v3:16; };
struct C_BFu7c_BFu17i { char v1; unsigned char v2:7; unsigned int v3:17; };
struct C_BFu7c_BFu17ll { char v1; unsigned char v2:7; unsigned long long v3:17; };
struct C_BFu7c_BFu1c { char v1; unsigned char v2:7; unsigned char v3:1; };
struct C_BFu7c_BFu1i { char v1; unsigned char v2:7; unsigned int v3:1; };
struct C_BFu7c_BFu1ll { char v1; unsigned char v2:7; unsigned long long v3:1; };
struct C_BFu7c_BFu1s { char v1; unsigned char v2:7; unsigned short v3:1; };
struct C_BFu7c_BFu31i { char v1; unsigned char v2:7; unsigned int v3:31; };
struct C_BFu7c_BFu31ll { char v1; unsigned char v2:7; unsigned long long v3:31; };
struct C_BFu7c_BFu32i { char v1; unsigned char v2:7; unsigned int v3:32; };
struct C_BFu7c_BFu32ll { char v1; unsigned char v2:7; unsigned long long v3:32; };
struct C_BFu7c_BFu33 { char v1; unsigned char v2:7; unsigned long long v3:33; };
struct C_BFu7c_BFu7c { char v1; unsigned char v2:7; unsigned char v3:7; };
struct C_BFu7c_BFu7i { char v1; unsigned char v2:7; unsigned int v3:7; };
struct C_BFu7c_BFu7ll { char v1; unsigned char v2:7; unsigned long long v3:7; };
struct C_BFu7c_BFu7s { char v1; unsigned char v2:7; unsigned short v3:7; };
struct C_BFu7c_BFu8c { char v1; unsigned char v2:7; unsigned char v3:8; };
struct C_BFu7c_BFu8i { char v1; unsigned char v2:7; unsigned int v3:8; };
struct C_BFu7c_BFu8ll { char v1; unsigned char v2:7; unsigned long long v3:8; };
struct C_BFu7c_BFu8s { char v1; unsigned char v2:7; unsigned short v3:8; };
struct C_BFu7c_BFu9i { char v1; unsigned char v2:7; unsigned int v3:9; };
struct C_BFu7c_BFu9ll { char v1; unsigned char v2:7; unsigned long long v3:9; };
struct C_BFu7c_BFu9s { char v1; unsigned char v2:7; unsigned short v3:9; };
struct C_BFu7c_C { char v1; unsigned char v2:7; char v3; };
struct C_BFu7c_D { char v1; unsigned char v2:7; double v3; };
struct C_BFu7c_F { char v1; unsigned char v2:7; float v3; };
struct C_BFu7c_I { char v1; unsigned char v2:7; int v3; };
struct C_BFu7c_Ip { char v1; unsigned char v2:7; int * v3; };
struct C_BFu7c_L { char v1; unsigned char v2:7; long long v3; };
struct C_BFu7c_S { char v1; unsigned char v2:7; short v3; };
struct C_BFu7c_Uc { char v1; unsigned char v2:7; unsigned char v3; };
struct C_BFu7c_Ui { char v1; unsigned char v2:7; unsigned int v3; };
struct C_BFu7c_Ul { char v1; unsigned char v2:7; unsigned long long v3; };
struct C_BFu7c_Us { char v1; unsigned char v2:7; unsigned short v3; };
struct C_BFu7c_Vp { char v1; unsigned char v2:7; void * v3; };
struct C_BFu7i { char v1; unsigned int v2:7; };
struct C_BFu7i_BFu15i { char v1; unsigned int v2:7; unsigned int v3:15; };
struct C_BFu7i_BFu15ll { char v1; unsigned int v2:7; unsigned long long v3:15; };
struct C_BFu7i_BFu15s { char v1; unsigned int v2:7; unsigned short v3:15; };
struct C_BFu7i_BFu16i { char v1; unsigned int v2:7; unsigned int v3:16; };
struct C_BFu7i_BFu16ll { char v1; unsigned int v2:7; unsigned long long v3:16; };
struct C_BFu7i_BFu16s { char v1; unsigned int v2:7; unsigned short v3:16; };
struct C_BFu7i_BFu17i { char v1; unsigned int v2:7; unsigned int v3:17; };
struct C_BFu7i_BFu17ll { char v1; unsigned int v2:7; unsigned long long v3:17; };
struct C_BFu7i_BFu1c { char v1; unsigned int v2:7; unsigned char v3:1; };
struct C_BFu7i_BFu1i { char v1; unsigned int v2:7; unsigned int v3:1; };
struct C_BFu7i_BFu1ll { char v1; unsigned int v2:7; unsigned long long v3:1; };
struct C_BFu7i_BFu1s { char v1; unsigned int v2:7; unsigned short v3:1; };
struct C_BFu7i_BFu31i { char v1; unsigned int v2:7; unsigned int v3:31; };
struct C_BFu7i_BFu31ll { char v1; unsigned int v2:7; unsigned long long v3:31; };
struct C_BFu7i_BFu32i { char v1; unsigned int v2:7; unsigned int v3:32; };
struct C_BFu7i_BFu32ll { char v1; unsigned int v2:7; unsigned long long v3:32; };
struct C_BFu7i_BFu33 { char v1; unsigned int v2:7; unsigned long long v3:33; };
struct C_BFu7i_BFu7c { char v1; unsigned int v2:7; unsigned char v3:7; };
struct C_BFu7i_BFu7i { char v1; unsigned int v2:7; unsigned int v3:7; };
struct C_BFu7i_BFu7ll { char v1; unsigned int v2:7; unsigned long long v3:7; };
struct C_BFu7i_BFu7s { char v1; unsigned int v2:7; unsigned short v3:7; };
struct C_BFu7i_BFu8c { char v1; unsigned int v2:7; unsigned char v3:8; };
struct C_BFu7i_BFu8i { char v1; unsigned int v2:7; unsigned int v3:8; };
struct C_BFu7i_BFu8ll { char v1; unsigned int v2:7; unsigned long long v3:8; };
struct C_BFu7i_BFu8s { char v1; unsigned int v2:7; unsigned short v3:8; };
struct C_BFu7i_BFu9i { char v1; unsigned int v2:7; unsigned int v3:9; };
struct C_BFu7i_BFu9ll { char v1; unsigned int v2:7; unsigned long long v3:9; };
struct C_BFu7i_BFu9s { char v1; unsigned int v2:7; unsigned short v3:9; };
struct C_BFu7i_C { char v1; unsigned int v2:7; char v3; };
struct C_BFu7i_D { char v1; unsigned int v2:7; double v3; };
struct C_BFu7i_F { char v1; unsigned int v2:7; float v3; };
struct C_BFu7i_I { char v1; unsigned int v2:7; int v3; };
struct C_BFu7i_Ip { char v1; unsigned int v2:7; int * v3; };
struct C_BFu7i_L { char v1; unsigned int v2:7; long long v3; };
struct C_BFu7i_S { char v1; unsigned int v2:7; short v3; };
struct C_BFu7i_Uc { char v1; unsigned int v2:7; unsigned char v3; };
struct C_BFu7i_Ui { char v1; unsigned int v2:7; unsigned int v3; };
struct C_BFu7i_Ul { char v1; unsigned int v2:7; unsigned long long v3; };
struct C_BFu7i_Us { char v1; unsigned int v2:7; unsigned short v3; };
struct C_BFu7i_Vp { char v1; unsigned int v2:7; void * v3; };
struct C_BFu7ll { char v1; unsigned long long v2:7; };
struct C_BFu7ll_BFu15i { char v1; unsigned long long v2:7; unsigned int v3:15; };
struct C_BFu7ll_BFu15ll { char v1; unsigned long long v2:7; unsigned long long v3:15; };
struct C_BFu7ll_BFu15s { char v1; unsigned long long v2:7; unsigned short v3:15; };
struct C_BFu7ll_BFu16i { char v1; unsigned long long v2:7; unsigned int v3:16; };
struct C_BFu7ll_BFu16ll { char v1; unsigned long long v2:7; unsigned long long v3:16; };
struct C_BFu7ll_BFu16s { char v1; unsigned long long v2:7; unsigned short v3:16; };
struct C_BFu7ll_BFu17i { char v1; unsigned long long v2:7; unsigned int v3:17; };
struct C_BFu7ll_BFu17ll { char v1; unsigned long long v2:7; unsigned long long v3:17; };
struct C_BFu7ll_BFu1c { char v1; unsigned long long v2:7; unsigned char v3:1; };
struct C_BFu7ll_BFu1i { char v1; unsigned long long v2:7; unsigned int v3:1; };
struct C_BFu7ll_BFu1ll { char v1; unsigned long long v2:7; unsigned long long v3:1; };
struct C_BFu7ll_BFu1s { char v1; unsigned long long v2:7; unsigned short v3:1; };
struct C_BFu7ll_BFu31i { char v1; unsigned long long v2:7; unsigned int v3:31; };
struct C_BFu7ll_BFu31ll { char v1; unsigned long long v2:7; unsigned long long v3:31; };
struct C_BFu7ll_BFu32i { char v1; unsigned long long v2:7; unsigned int v3:32; };
struct C_BFu7ll_BFu32ll { char v1; unsigned long long v2:7; unsigned long long v3:32; };
struct C_BFu7ll_BFu33 { char v1; unsigned long long v2:7; unsigned long long v3:33; };
struct C_BFu7ll_BFu7c { char v1; unsigned long long v2:7; unsigned char v3:7; };
struct C_BFu7ll_BFu7i { char v1; unsigned long long v2:7; unsigned int v3:7; };
struct C_BFu7ll_BFu7ll { char v1; unsigned long long v2:7; unsigned long long v3:7; };
struct C_BFu7ll_BFu7s { char v1; unsigned long long v2:7; unsigned short v3:7; };
struct C_BFu7ll_BFu8c { char v1; unsigned long long v2:7; unsigned char v3:8; };
struct C_BFu7ll_BFu8i { char v1; unsigned long long v2:7; unsigned int v3:8; };
struct C_BFu7ll_BFu8ll { char v1; unsigned long long v2:7; unsigned long long v3:8; };
struct C_BFu7ll_BFu8s { char v1; unsigned long long v2:7; unsigned short v3:8; };
struct C_BFu7ll_BFu9i { char v1; unsigned long long v2:7; unsigned int v3:9; };
struct C_BFu7ll_BFu9ll { char v1; unsigned long long v2:7; unsigned long long v3:9; };
struct C_BFu7ll_BFu9s { char v1; unsigned long long v2:7; unsigned short v3:9; };
struct C_BFu7ll_C { char v1; unsigned long long v2:7; char v3; };
struct C_BFu7ll_D { char v1; unsigned long long v2:7; double v3; };
struct C_BFu7ll_F { char v1; unsigned long long v2:7; float v3; };
struct C_BFu7ll_I { char v1; unsigned long long v2:7; int v3; };
struct C_BFu7ll_Ip { char v1; unsigned long long v2:7; int * v3; };
struct C_BFu7ll_L { char v1; unsigned long long v2:7; long long v3; };
struct C_BFu7ll_S { char v1; unsigned long long v2:7; short v3; };
struct C_BFu7ll_Uc { char v1; unsigned long long v2:7; unsigned char v3; };
struct C_BFu7ll_Ui { char v1; unsigned long long v2:7; unsigned int v3; };
struct C_BFu7ll_Ul { char v1; unsigned long long v2:7; unsigned long long v3; };
struct C_BFu7ll_Us { char v1; unsigned long long v2:7; unsigned short v3; };
struct C_BFu7ll_Vp { char v1; unsigned long long v2:7; void * v3; };
struct C_BFu7s { char v1; unsigned short v2:7; };
struct C_BFu7s_BFu15i { char v1; unsigned short v2:7; unsigned int v3:15; };
struct C_BFu7s_BFu15ll { char v1; unsigned short v2:7; unsigned long long v3:15; };
struct C_BFu7s_BFu15s { char v1; unsigned short v2:7; unsigned short v3:15; };
struct C_BFu7s_BFu16i { char v1; unsigned short v2:7; unsigned int v3:16; };
struct C_BFu7s_BFu16ll { char v1; unsigned short v2:7; unsigned long long v3:16; };
struct C_BFu7s_BFu16s { char v1; unsigned short v2:7; unsigned short v3:16; };
struct C_BFu7s_BFu17i { char v1; unsigned short v2:7; unsigned int v3:17; };
struct C_BFu7s_BFu17ll { char v1; unsigned short v2:7; unsigned long long v3:17; };
struct C_BFu7s_BFu1c { char v1; unsigned short v2:7; unsigned char v3:1; };
struct C_BFu7s_BFu1i { char v1; unsigned short v2:7; unsigned int v3:1; };
struct C_BFu7s_BFu1ll { char v1; unsigned short v2:7; unsigned long long v3:1; };
struct C_BFu7s_BFu1s { char v1; unsigned short v2:7; unsigned short v3:1; };
struct C_BFu7s_BFu31i { char v1; unsigned short v2:7; unsigned int v3:31; };
struct C_BFu7s_BFu31ll { char v1; unsigned short v2:7; unsigned long long v3:31; };
struct C_BFu7s_BFu32i { char v1; unsigned short v2:7; unsigned int v3:32; };
struct C_BFu7s_BFu32ll { char v1; unsigned short v2:7; unsigned long long v3:32; };
struct C_BFu7s_BFu33 { char v1; unsigned short v2:7; unsigned long long v3:33; };
struct C_BFu7s_BFu7c { char v1; unsigned short v2:7; unsigned char v3:7; };
struct C_BFu7s_BFu7i { char v1; unsigned short v2:7; unsigned int v3:7; };
struct C_BFu7s_BFu7ll { char v1; unsigned short v2:7; unsigned long long v3:7; };
struct C_BFu7s_BFu7s { char v1; unsigned short v2:7; unsigned short v3:7; };
struct C_BFu7s_BFu8c { char v1; unsigned short v2:7; unsigned char v3:8; };
struct C_BFu7s_BFu8i { char v1; unsigned short v2:7; unsigned int v3:8; };
struct C_BFu7s_BFu8ll { char v1; unsigned short v2:7; unsigned long long v3:8; };
struct C_BFu7s_BFu8s { char v1; unsigned short v2:7; unsigned short v3:8; };
struct C_BFu7s_BFu9i { char v1; unsigned short v2:7; unsigned int v3:9; };
struct C_BFu7s_BFu9ll { char v1; unsigned short v2:7; unsigned long long v3:9; };
struct C_BFu7s_BFu9s { char v1; unsigned short v2:7; unsigned short v3:9; };
struct C_BFu7s_C { char v1; unsigned short v2:7; char v3; };
struct C_BFu7s_D { char v1; unsigned short v2:7; double v3; };
struct C_BFu7s_F { char v1; unsigned short v2:7; float v3; };
struct C_BFu7s_I { char v1; unsigned short v2:7; int v3; };
struct C_BFu7s_Ip { char v1; unsigned short v2:7; int * v3; };
struct C_BFu7s_L { char v1; unsigned short v2:7; long long v3; };
struct C_BFu7s_S { char v1; unsigned short v2:7; short v3; };
struct C_BFu7s_Uc { char v1; unsigned short v2:7; unsigned char v3; };
struct C_BFu7s_Ui { char v1; unsigned short v2:7; unsigned int v3; };
struct C_BFu7s_Ul { char v1; unsigned short v2:7; unsigned long long v3; };
struct C_BFu7s_Us { char v1; unsigned short v2:7; unsigned short v3; };
struct C_BFu7s_Vp { char v1; unsigned short v2:7; void * v3; };
struct C_BFu8c { char v1; unsigned char v2:8; };
struct C_BFu8c_BFu15i { char v1; unsigned char v2:8; unsigned int v3:15; };
struct C_BFu8c_BFu15ll { char v1; unsigned char v2:8; unsigned long long v3:15; };
struct C_BFu8c_BFu15s { char v1; unsigned char v2:8; unsigned short v3:15; };
struct C_BFu8c_BFu16i { char v1; unsigned char v2:8; unsigned int v3:16; };
struct C_BFu8c_BFu16ll { char v1; unsigned char v2:8; unsigned long long v3:16; };
struct C_BFu8c_BFu16s { char v1; unsigned char v2:8; unsigned short v3:16; };
struct C_BFu8c_BFu17i { char v1; unsigned char v2:8; unsigned int v3:17; };
struct C_BFu8c_BFu17ll { char v1; unsigned char v2:8; unsigned long long v3:17; };
struct C_BFu8c_BFu1c { char v1; unsigned char v2:8; unsigned char v3:1; };
struct C_BFu8c_BFu1i { char v1; unsigned char v2:8; unsigned int v3:1; };
struct C_BFu8c_BFu1ll { char v1; unsigned char v2:8; unsigned long long v3:1; };
struct C_BFu8c_BFu1s { char v1; unsigned char v2:8; unsigned short v3:1; };
struct C_BFu8c_BFu31i { char v1; unsigned char v2:8; unsigned int v3:31; };
struct C_BFu8c_BFu31ll { char v1; unsigned char v2:8; unsigned long long v3:31; };
struct C_BFu8c_BFu32i { char v1; unsigned char v2:8; unsigned int v3:32; };
struct C_BFu8c_BFu32ll { char v1; unsigned char v2:8; unsigned long long v3:32; };
struct C_BFu8c_BFu33 { char v1; unsigned char v2:8; unsigned long long v3:33; };
struct C_BFu8c_BFu7c { char v1; unsigned char v2:8; unsigned char v3:7; };
struct C_BFu8c_BFu7i { char v1; unsigned char v2:8; unsigned int v3:7; };
struct C_BFu8c_BFu7ll { char v1; unsigned char v2:8; unsigned long long v3:7; };
struct C_BFu8c_BFu7s { char v1; unsigned char v2:8; unsigned short v3:7; };
struct C_BFu8c_BFu8c { char v1; unsigned char v2:8; unsigned char v3:8; };
struct C_BFu8c_BFu8i { char v1; unsigned char v2:8; unsigned int v3:8; };
struct C_BFu8c_BFu8ll { char v1; unsigned char v2:8; unsigned long long v3:8; };
struct C_BFu8c_BFu8s { char v1; unsigned char v2:8; unsigned short v3:8; };
struct C_BFu8c_BFu9i { char v1; unsigned char v2:8; unsigned int v3:9; };
struct C_BFu8c_BFu9ll { char v1; unsigned char v2:8; unsigned long long v3:9; };
struct C_BFu8c_BFu9s { char v1; unsigned char v2:8; unsigned short v3:9; };
struct C_BFu8c_C { char v1; unsigned char v2:8; char v3; };
struct C_BFu8c_D { char v1; unsigned char v2:8; double v3; };
struct C_BFu8c_F { char v1; unsigned char v2:8; float v3; };
struct C_BFu8c_I { char v1; unsigned char v2:8; int v3; };
struct C_BFu8c_Ip { char v1; unsigned char v2:8; int * v3; };
struct C_BFu8c_L { char v1; unsigned char v2:8; long long v3; };
struct C_BFu8c_S { char v1; unsigned char v2:8; short v3; };
struct C_BFu8c_Uc { char v1; unsigned char v2:8; unsigned char v3; };
struct C_BFu8c_Ui { char v1; unsigned char v2:8; unsigned int v3; };
struct C_BFu8c_Ul { char v1; unsigned char v2:8; unsigned long long v3; };
struct C_BFu8c_Us { char v1; unsigned char v2:8; unsigned short v3; };
struct C_BFu8c_Vp { char v1; unsigned char v2:8; void * v3; };
struct C_BFu8i { char v1; unsigned int v2:8; };
struct C_BFu8i_BFu15i { char v1; unsigned int v2:8; unsigned int v3:15; };
struct C_BFu8i_BFu15ll { char v1; unsigned int v2:8; unsigned long long v3:15; };
struct C_BFu8i_BFu15s { char v1; unsigned int v2:8; unsigned short v3:15; };
struct C_BFu8i_BFu16i { char v1; unsigned int v2:8; unsigned int v3:16; };
struct C_BFu8i_BFu16ll { char v1; unsigned int v2:8; unsigned long long v3:16; };
struct C_BFu8i_BFu16s { char v1; unsigned int v2:8; unsigned short v3:16; };
struct C_BFu8i_BFu17i { char v1; unsigned int v2:8; unsigned int v3:17; };
struct C_BFu8i_BFu17ll { char v1; unsigned int v2:8; unsigned long long v3:17; };
struct C_BFu8i_BFu1c { char v1; unsigned int v2:8; unsigned char v3:1; };
struct C_BFu8i_BFu1i { char v1; unsigned int v2:8; unsigned int v3:1; };
struct C_BFu8i_BFu1ll { char v1; unsigned int v2:8; unsigned long long v3:1; };
struct C_BFu8i_BFu1s { char v1; unsigned int v2:8; unsigned short v3:1; };
struct C_BFu8i_BFu31i { char v1; unsigned int v2:8; unsigned int v3:31; };
struct C_BFu8i_BFu31ll { char v1; unsigned int v2:8; unsigned long long v3:31; };
struct C_BFu8i_BFu32i { char v1; unsigned int v2:8; unsigned int v3:32; };
struct C_BFu8i_BFu32ll { char v1; unsigned int v2:8; unsigned long long v3:32; };
struct C_BFu8i_BFu33 { char v1; unsigned int v2:8; unsigned long long v3:33; };
struct C_BFu8i_BFu7c { char v1; unsigned int v2:8; unsigned char v3:7; };
struct C_BFu8i_BFu7i { char v1; unsigned int v2:8; unsigned int v3:7; };
struct C_BFu8i_BFu7ll { char v1; unsigned int v2:8; unsigned long long v3:7; };
struct C_BFu8i_BFu7s { char v1; unsigned int v2:8; unsigned short v3:7; };
struct C_BFu8i_BFu8c { char v1; unsigned int v2:8; unsigned char v3:8; };
struct C_BFu8i_BFu8i { char v1; unsigned int v2:8; unsigned int v3:8; };
struct C_BFu8i_BFu8ll { char v1; unsigned int v2:8; unsigned long long v3:8; };
struct C_BFu8i_BFu8s { char v1; unsigned int v2:8; unsigned short v3:8; };
struct C_BFu8i_BFu9i { char v1; unsigned int v2:8; unsigned int v3:9; };
struct C_BFu8i_BFu9ll { char v1; unsigned int v2:8; unsigned long long v3:9; };
struct C_BFu8i_BFu9s { char v1; unsigned int v2:8; unsigned short v3:9; };
struct C_BFu8i_C { char v1; unsigned int v2:8; char v3; };
struct C_BFu8i_D { char v1; unsigned int v2:8; double v3; };
struct C_BFu8i_F { char v1; unsigned int v2:8; float v3; };
struct C_BFu8i_I { char v1; unsigned int v2:8; int v3; };
struct C_BFu8i_Ip { char v1; unsigned int v2:8; int * v3; };
struct C_BFu8i_L { char v1; unsigned int v2:8; long long v3; };
struct C_BFu8i_S { char v1; unsigned int v2:8; short v3; };
struct C_BFu8i_Uc { char v1; unsigned int v2:8; unsigned char v3; };
struct C_BFu8i_Ui { char v1; unsigned int v2:8; unsigned int v3; };
struct C_BFu8i_Ul { char v1; unsigned int v2:8; unsigned long long v3; };
struct C_BFu8i_Us { char v1; unsigned int v2:8; unsigned short v3; };
struct C_BFu8i_Vp { char v1; unsigned int v2:8; void * v3; };
struct C_BFu8ll { char v1; unsigned long long v2:8; };
struct C_BFu8ll_BFu15i { char v1; unsigned long long v2:8; unsigned int v3:15; };
struct C_BFu8ll_BFu15ll { char v1; unsigned long long v2:8; unsigned long long v3:15; };
struct C_BFu8ll_BFu15s { char v1; unsigned long long v2:8; unsigned short v3:15; };
struct C_BFu8ll_BFu16i { char v1; unsigned long long v2:8; unsigned int v3:16; };
struct C_BFu8ll_BFu16ll { char v1; unsigned long long v2:8; unsigned long long v3:16; };
struct C_BFu8ll_BFu16s { char v1; unsigned long long v2:8; unsigned short v3:16; };
struct C_BFu8ll_BFu17i { char v1; unsigned long long v2:8; unsigned int v3:17; };
struct C_BFu8ll_BFu17ll { char v1; unsigned long long v2:8; unsigned long long v3:17; };
struct C_BFu8ll_BFu1c { char v1; unsigned long long v2:8; unsigned char v3:1; };
struct C_BFu8ll_BFu1i { char v1; unsigned long long v2:8; unsigned int v3:1; };
struct C_BFu8ll_BFu1ll { char v1; unsigned long long v2:8; unsigned long long v3:1; };
struct C_BFu8ll_BFu1s { char v1; unsigned long long v2:8; unsigned short v3:1; };
struct C_BFu8ll_BFu31i { char v1; unsigned long long v2:8; unsigned int v3:31; };
struct C_BFu8ll_BFu31ll { char v1; unsigned long long v2:8; unsigned long long v3:31; };
struct C_BFu8ll_BFu32i { char v1; unsigned long long v2:8; unsigned int v3:32; };
struct C_BFu8ll_BFu32ll { char v1; unsigned long long v2:8; unsigned long long v3:32; };
struct C_BFu8ll_BFu33 { char v1; unsigned long long v2:8; unsigned long long v3:33; };
struct C_BFu8ll_BFu7c { char v1; unsigned long long v2:8; unsigned char v3:7; };
struct C_BFu8ll_BFu7i { char v1; unsigned long long v2:8; unsigned int v3:7; };
struct C_BFu8ll_BFu7ll { char v1; unsigned long long v2:8; unsigned long long v3:7; };
struct C_BFu8ll_BFu7s { char v1; unsigned long long v2:8; unsigned short v3:7; };
struct C_BFu8ll_BFu8c { char v1; unsigned long long v2:8; unsigned char v3:8; };
struct C_BFu8ll_BFu8i { char v1; unsigned long long v2:8; unsigned int v3:8; };
struct C_BFu8ll_BFu8ll { char v1; unsigned long long v2:8; unsigned long long v3:8; };
struct C_BFu8ll_BFu8s { char v1; unsigned long long v2:8; unsigned short v3:8; };
struct C_BFu8ll_BFu9i { char v1; unsigned long long v2:8; unsigned int v3:9; };
struct C_BFu8ll_BFu9ll { char v1; unsigned long long v2:8; unsigned long long v3:9; };
struct C_BFu8ll_BFu9s { char v1; unsigned long long v2:8; unsigned short v3:9; };
struct C_BFu8ll_C { char v1; unsigned long long v2:8; char v3; };
struct C_BFu8ll_D { char v1; unsigned long long v2:8; double v3; };
struct C_BFu8ll_F { char v1; unsigned long long v2:8; float v3; };
struct C_BFu8ll_I { char v1; unsigned long long v2:8; int v3; };
struct C_BFu8ll_Ip { char v1; unsigned long long v2:8; int * v3; };
struct C_BFu8ll_L { char v1; unsigned long long v2:8; long long v3; };
struct C_BFu8ll_S { char v1; unsigned long long v2:8; short v3; };
struct C_BFu8ll_Uc { char v1; unsigned long long v2:8; unsigned char v3; };
struct C_BFu8ll_Ui { char v1; unsigned long long v2:8; unsigned int v3; };
struct C_BFu8ll_Ul { char v1; unsigned long long v2:8; unsigned long long v3; };
struct C_BFu8ll_Us { char v1; unsigned long long v2:8; unsigned short v3; };
struct C_BFu8ll_Vp { char v1; unsigned long long v2:8; void * v3; };
struct C_BFu8s { char v1; unsigned short v2:8; };
struct C_BFu8s_BFu15i { char v1; unsigned short v2:8; unsigned int v3:15; };
struct C_BFu8s_BFu15ll { char v1; unsigned short v2:8; unsigned long long v3:15; };
struct C_BFu8s_BFu15s { char v1; unsigned short v2:8; unsigned short v3:15; };
struct C_BFu8s_BFu16i { char v1; unsigned short v2:8; unsigned int v3:16; };
struct C_BFu8s_BFu16ll { char v1; unsigned short v2:8; unsigned long long v3:16; };
struct C_BFu8s_BFu16s { char v1; unsigned short v2:8; unsigned short v3:16; };
struct C_BFu8s_BFu17i { char v1; unsigned short v2:8; unsigned int v3:17; };
struct C_BFu8s_BFu17ll { char v1; unsigned short v2:8; unsigned long long v3:17; };
struct C_BFu8s_BFu1c { char v1; unsigned short v2:8; unsigned char v3:1; };
struct C_BFu8s_BFu1i { char v1; unsigned short v2:8; unsigned int v3:1; };
struct C_BFu8s_BFu1ll { char v1; unsigned short v2:8; unsigned long long v3:1; };
struct C_BFu8s_BFu1s { char v1; unsigned short v2:8; unsigned short v3:1; };
struct C_BFu8s_BFu31i { char v1; unsigned short v2:8; unsigned int v3:31; };
struct C_BFu8s_BFu31ll { char v1; unsigned short v2:8; unsigned long long v3:31; };
struct C_BFu8s_BFu32i { char v1; unsigned short v2:8; unsigned int v3:32; };
struct C_BFu8s_BFu32ll { char v1; unsigned short v2:8; unsigned long long v3:32; };
struct C_BFu8s_BFu33 { char v1; unsigned short v2:8; unsigned long long v3:33; };
struct C_BFu8s_BFu7c { char v1; unsigned short v2:8; unsigned char v3:7; };
struct C_BFu8s_BFu7i { char v1; unsigned short v2:8; unsigned int v3:7; };
struct C_BFu8s_BFu7ll { char v1; unsigned short v2:8; unsigned long long v3:7; };
struct C_BFu8s_BFu7s { char v1; unsigned short v2:8; unsigned short v3:7; };
struct C_BFu8s_BFu8c { char v1; unsigned short v2:8; unsigned char v3:8; };
struct C_BFu8s_BFu8i { char v1; unsigned short v2:8; unsigned int v3:8; };
struct C_BFu8s_BFu8ll { char v1; unsigned short v2:8; unsigned long long v3:8; };
struct C_BFu8s_BFu8s { char v1; unsigned short v2:8; unsigned short v3:8; };
struct C_BFu8s_BFu9i { char v1; unsigned short v2:8; unsigned int v3:9; };
struct C_BFu8s_BFu9ll { char v1; unsigned short v2:8; unsigned long long v3:9; };
struct C_BFu8s_BFu9s { char v1; unsigned short v2:8; unsigned short v3:9; };
struct C_BFu8s_C { char v1; unsigned short v2:8; char v3; };
struct C_BFu8s_D { char v1; unsigned short v2:8; double v3; };
struct C_BFu8s_F { char v1; unsigned short v2:8; float v3; };
struct C_BFu8s_I { char v1; unsigned short v2:8; int v3; };
struct C_BFu8s_Ip { char v1; unsigned short v2:8; int * v3; };
struct C_BFu8s_L { char v1; unsigned short v2:8; long long v3; };
struct C_BFu8s_S { char v1; unsigned short v2:8; short v3; };
struct C_BFu8s_Uc { char v1; unsigned short v2:8; unsigned char v3; };
struct C_BFu8s_Ui { char v1; unsigned short v2:8; unsigned int v3; };
struct C_BFu8s_Ul { char v1; unsigned short v2:8; unsigned long long v3; };
struct C_BFu8s_Us { char v1; unsigned short v2:8; unsigned short v3; };
struct C_BFu8s_Vp { char v1; unsigned short v2:8; void * v3; };
struct C_BFu9i { char v1; unsigned int v2:9; };
struct C_BFu9i_BFu15i { char v1; unsigned int v2:9; unsigned int v3:15; };
struct C_BFu9i_BFu15ll { char v1; unsigned int v2:9; unsigned long long v3:15; };
struct C_BFu9i_BFu15s { char v1; unsigned int v2:9; unsigned short v3:15; };
struct C_BFu9i_BFu16i { char v1; unsigned int v2:9; unsigned int v3:16; };
struct C_BFu9i_BFu16ll { char v1; unsigned int v2:9; unsigned long long v3:16; };
struct C_BFu9i_BFu16s { char v1; unsigned int v2:9; unsigned short v3:16; };
struct C_BFu9i_BFu17i { char v1; unsigned int v2:9; unsigned int v3:17; };
struct C_BFu9i_BFu17ll { char v1; unsigned int v2:9; unsigned long long v3:17; };
struct C_BFu9i_BFu1c { char v1; unsigned int v2:9; unsigned char v3:1; };
struct C_BFu9i_BFu1i { char v1; unsigned int v2:9; unsigned int v3:1; };
struct C_BFu9i_BFu1ll { char v1; unsigned int v2:9; unsigned long long v3:1; };
struct C_BFu9i_BFu1s { char v1; unsigned int v2:9; unsigned short v3:1; };
struct C_BFu9i_BFu31i { char v1; unsigned int v2:9; unsigned int v3:31; };
struct C_BFu9i_BFu31ll { char v1; unsigned int v2:9; unsigned long long v3:31; };
struct C_BFu9i_BFu32i { char v1; unsigned int v2:9; unsigned int v3:32; };
struct C_BFu9i_BFu32ll { char v1; unsigned int v2:9; unsigned long long v3:32; };
struct C_BFu9i_BFu33 { char v1; unsigned int v2:9; unsigned long long v3:33; };
struct C_BFu9i_BFu7c { char v1; unsigned int v2:9; unsigned char v3:7; };
struct C_BFu9i_BFu7i { char v1; unsigned int v2:9; unsigned int v3:7; };
struct C_BFu9i_BFu7ll { char v1; unsigned int v2:9; unsigned long long v3:7; };
struct C_BFu9i_BFu7s { char v1; unsigned int v2:9; unsigned short v3:7; };
struct C_BFu9i_BFu8c { char v1; unsigned int v2:9; unsigned char v3:8; };
struct C_BFu9i_BFu8i { char v1; unsigned int v2:9; unsigned int v3:8; };
struct C_BFu9i_BFu8ll { char v1; unsigned int v2:9; unsigned long long v3:8; };
struct C_BFu9i_BFu8s { char v1; unsigned int v2:9; unsigned short v3:8; };
struct C_BFu9i_BFu9i { char v1; unsigned int v2:9; unsigned int v3:9; };
struct C_BFu9i_BFu9ll { char v1; unsigned int v2:9; unsigned long long v3:9; };
struct C_BFu9i_BFu9s { char v1; unsigned int v2:9; unsigned short v3:9; };
struct C_BFu9i_C { char v1; unsigned int v2:9; char v3; };
struct C_BFu9i_D { char v1; unsigned int v2:9; double v3; };
struct C_BFu9i_F { char v1; unsigned int v2:9; float v3; };
struct C_BFu9i_I { char v1; unsigned int v2:9; int v3; };
struct C_BFu9i_Ip { char v1; unsigned int v2:9; int * v3; };
struct C_BFu9i_L { char v1; unsigned int v2:9; long long v3; };
struct C_BFu9i_S { char v1; unsigned int v2:9; short v3; };
struct C_BFu9i_Uc { char v1; unsigned int v2:9; unsigned char v3; };
struct C_BFu9i_Ui { char v1; unsigned int v2:9; unsigned int v3; };
struct C_BFu9i_Ul { char v1; unsigned int v2:9; unsigned long long v3; };
struct C_BFu9i_Us { char v1; unsigned int v2:9; unsigned short v3; };
struct C_BFu9i_Vp { char v1; unsigned int v2:9; void * v3; };
struct C_BFu9ll { char v1; unsigned long long v2:9; };
struct C_BFu9ll_BFu15i { char v1; unsigned long long v2:9; unsigned int v3:15; };
struct C_BFu9ll_BFu15ll { char v1; unsigned long long v2:9; unsigned long long v3:15; };
struct C_BFu9ll_BFu15s { char v1; unsigned long long v2:9; unsigned short v3:15; };
struct C_BFu9ll_BFu16i { char v1; unsigned long long v2:9; unsigned int v3:16; };
struct C_BFu9ll_BFu16ll { char v1; unsigned long long v2:9; unsigned long long v3:16; };
struct C_BFu9ll_BFu16s { char v1; unsigned long long v2:9; unsigned short v3:16; };
struct C_BFu9ll_BFu17i { char v1; unsigned long long v2:9; unsigned int v3:17; };
struct C_BFu9ll_BFu17ll { char v1; unsigned long long v2:9; unsigned long long v3:17; };
struct C_BFu9ll_BFu1c { char v1; unsigned long long v2:9; unsigned char v3:1; };
struct C_BFu9ll_BFu1i { char v1; unsigned long long v2:9; unsigned int v3:1; };
struct C_BFu9ll_BFu1ll { char v1; unsigned long long v2:9; unsigned long long v3:1; };
struct C_BFu9ll_BFu1s { char v1; unsigned long long v2:9; unsigned short v3:1; };
struct C_BFu9ll_BFu31i { char v1; unsigned long long v2:9; unsigned int v3:31; };
struct C_BFu9ll_BFu31ll { char v1; unsigned long long v2:9; unsigned long long v3:31; };
struct C_BFu9ll_BFu32i { char v1; unsigned long long v2:9; unsigned int v3:32; };
struct C_BFu9ll_BFu32ll { char v1; unsigned long long v2:9; unsigned long long v3:32; };
struct C_BFu9ll_BFu33 { char v1; unsigned long long v2:9; unsigned long long v3:33; };
struct C_BFu9ll_BFu7c { char v1; unsigned long long v2:9; unsigned char v3:7; };
struct C_BFu9ll_BFu7i { char v1; unsigned long long v2:9; unsigned int v3:7; };
struct C_BFu9ll_BFu7ll { char v1; unsigned long long v2:9; unsigned long long v3:7; };
struct C_BFu9ll_BFu7s { char v1; unsigned long long v2:9; unsigned short v3:7; };
struct C_BFu9ll_BFu8c { char v1; unsigned long long v2:9; unsigned char v3:8; };
struct C_BFu9ll_BFu8i { char v1; unsigned long long v2:9; unsigned int v3:8; };
struct C_BFu9ll_BFu8ll { char v1; unsigned long long v2:9; unsigned long long v3:8; };
struct C_BFu9ll_BFu8s { char v1; unsigned long long v2:9; unsigned short v3:8; };
struct C_BFu9ll_BFu9i { char v1; unsigned long long v2:9; unsigned int v3:9; };
struct C_BFu9ll_BFu9ll { char v1; unsigned long long v2:9; unsigned long long v3:9; };
struct C_BFu9ll_BFu9s { char v1; unsigned long long v2:9; unsigned short v3:9; };
struct C_BFu9ll_C { char v1; unsigned long long v2:9; char v3; };
struct C_BFu9ll_D { char v1; unsigned long long v2:9; double v3; };
struct C_BFu9ll_F { char v1; unsigned long long v2:9; float v3; };
struct C_BFu9ll_I { char v1; unsigned long long v2:9; int v3; };
struct C_BFu9ll_Ip { char v1; unsigned long long v2:9; int * v3; };
struct C_BFu9ll_L { char v1; unsigned long long v2:9; long long v3; };
struct C_BFu9ll_S { char v1; unsigned long long v2:9; short v3; };
struct C_BFu9ll_Uc { char v1; unsigned long long v2:9; unsigned char v3; };
struct C_BFu9ll_Ui { char v1; unsigned long long v2:9; unsigned int v3; };
struct C_BFu9ll_Ul { char v1; unsigned long long v2:9; unsigned long long v3; };
struct C_BFu9ll_Us { char v1; unsigned long long v2:9; unsigned short v3; };
struct C_BFu9ll_Vp { char v1; unsigned long long v2:9; void * v3; };
struct C_BFu9s { char v1; unsigned short v2:9; };
struct C_BFu9s_BFu15i { char v1; unsigned short v2:9; unsigned int v3:15; };
struct C_BFu9s_BFu15ll { char v1; unsigned short v2:9; unsigned long long v3:15; };
struct C_BFu9s_BFu15s { char v1; unsigned short v2:9; unsigned short v3:15; };
struct C_BFu9s_BFu16i { char v1; unsigned short v2:9; unsigned int v3:16; };
struct C_BFu9s_BFu16ll { char v1; unsigned short v2:9; unsigned long long v3:16; };
struct C_BFu9s_BFu16s { char v1; unsigned short v2:9; unsigned short v3:16; };
struct C_BFu9s_BFu17i { char v1; unsigned short v2:9; unsigned int v3:17; };
struct C_BFu9s_BFu17ll { char v1; unsigned short v2:9; unsigned long long v3:17; };
struct C_BFu9s_BFu1c { char v1; unsigned short v2:9; unsigned char v3:1; };
struct C_BFu9s_BFu1i { char v1; unsigned short v2:9; unsigned int v3:1; };
struct C_BFu9s_BFu1ll { char v1; unsigned short v2:9; unsigned long long v3:1; };
struct C_BFu9s_BFu1s { char v1; unsigned short v2:9; unsigned short v3:1; };
struct C_BFu9s_BFu31i { char v1; unsigned short v2:9; unsigned int v3:31; };
struct C_BFu9s_BFu31ll { char v1; unsigned short v2:9; unsigned long long v3:31; };
struct C_BFu9s_BFu32i { char v1; unsigned short v2:9; unsigned int v3:32; };
struct C_BFu9s_BFu32ll { char v1; unsigned short v2:9; unsigned long long v3:32; };
struct C_BFu9s_BFu33 { char v1; unsigned short v2:9; unsigned long long v3:33; };
struct C_BFu9s_BFu7c { char v1; unsigned short v2:9; unsigned char v3:7; };
struct C_BFu9s_BFu7i { char v1; unsigned short v2:9; unsigned int v3:7; };
struct C_BFu9s_BFu7ll { char v1; unsigned short v2:9; unsigned long long v3:7; };
struct C_BFu9s_BFu7s { char v1; unsigned short v2:9; unsigned short v3:7; };
struct C_BFu9s_BFu8c { char v1; unsigned short v2:9; unsigned char v3:8; };
struct C_BFu9s_BFu8i { char v1; unsigned short v2:9; unsigned int v3:8; };
struct C_BFu9s_BFu8ll { char v1; unsigned short v2:9; unsigned long long v3:8; };
struct C_BFu9s_BFu8s { char v1; unsigned short v2:9; unsigned short v3:8; };
struct C_BFu9s_BFu9i { char v1; unsigned short v2:9; unsigned int v3:9; };
struct C_BFu9s_BFu9ll { char v1; unsigned short v2:9; unsigned long long v3:9; };
struct C_BFu9s_BFu9s { char v1; unsigned short v2:9; unsigned short v3:9; };
struct C_BFu9s_C { char v1; unsigned short v2:9; char v3; };
struct C_BFu9s_D { char v1; unsigned short v2:9; double v3; };
struct C_BFu9s_F { char v1; unsigned short v2:9; float v3; };
struct C_BFu9s_I { char v1; unsigned short v2:9; int v3; };
struct C_BFu9s_Ip { char v1; unsigned short v2:9; int * v3; };
struct C_BFu9s_L { char v1; unsigned short v2:9; long long v3; };
struct C_BFu9s_S { char v1; unsigned short v2:9; short v3; };
struct C_BFu9s_Uc { char v1; unsigned short v2:9; unsigned char v3; };
struct C_BFu9s_Ui { char v1; unsigned short v2:9; unsigned int v3; };
struct C_BFu9s_Ul { char v1; unsigned short v2:9; unsigned long long v3; };
struct C_BFu9s_Us { char v1; unsigned short v2:9; unsigned short v3; };
struct C_BFu9s_Vp { char v1; unsigned short v2:9; void * v3; };
struct C_C { char v1; char v2; };
struct C_C_BFu15i { char v1; char v2; unsigned int v3:15; };
struct C_C_BFu15ll { char v1; char v2; unsigned long long v3:15; };
struct C_C_BFu15s { char v1; char v2; unsigned short v3:15; };
struct C_C_BFu16i { char v1; char v2; unsigned int v3:16; };
struct C_C_BFu16ll { char v1; char v2; unsigned long long v3:16; };
struct C_C_BFu16s { char v1; char v2; unsigned short v3:16; };
struct C_C_BFu17i { char v1; char v2; unsigned int v3:17; };
struct C_C_BFu17ll { char v1; char v2; unsigned long long v3:17; };
struct C_C_BFu1c { char v1; char v2; unsigned char v3:1; };
struct C_C_BFu1i { char v1; char v2; unsigned int v3:1; };
struct C_C_BFu1ll { char v1; char v2; unsigned long long v3:1; };
struct C_C_BFu1s { char v1; char v2; unsigned short v3:1; };
struct C_C_BFu31i { char v1; char v2; unsigned int v3:31; };
struct C_C_BFu31ll { char v1; char v2; unsigned long long v3:31; };
struct C_C_BFu32i { char v1; char v2; unsigned int v3:32; };
struct C_C_BFu32ll { char v1; char v2; unsigned long long v3:32; };
struct C_C_BFu33 { char v1; char v2; unsigned long long v3:33; };
struct C_C_BFu7c { char v1; char v2; unsigned char v3:7; };
struct C_C_BFu7i { char v1; char v2; unsigned int v3:7; };
struct C_C_BFu7ll { char v1; char v2; unsigned long long v3:7; };
struct C_C_BFu7s { char v1; char v2; unsigned short v3:7; };
struct C_C_BFu8c { char v1; char v2; unsigned char v3:8; };
struct C_C_BFu8i { char v1; char v2; unsigned int v3:8; };
struct C_C_BFu8ll { char v1; char v2; unsigned long long v3:8; };
struct C_C_BFu8s { char v1; char v2; unsigned short v3:8; };
struct C_C_BFu9i { char v1; char v2; unsigned int v3:9; };
struct C_C_BFu9ll { char v1; char v2; unsigned long long v3:9; };
struct C_C_BFu9s { char v1; char v2; unsigned short v3:9; };
struct C_C_C { char v1; char v2; char v3; };
struct C_C_D { char v1; char v2; double v3; };
struct C_C_F { char v1; char v2; float v3; };
struct C_C_I { char v1; char v2; int v3; };
struct C_C_Ip { char v1; char v2; int * v3; };
struct C_C_L { char v1; char v2; long long v3; };
struct C_C_S { char v1; char v2; short v3; };
struct C_C_Uc { char v1; char v2; unsigned char v3; };
struct C_C_Ui { char v1; char v2; unsigned int v3; };
struct C_C_Ul { char v1; char v2; unsigned long long v3; };
struct C_C_Us { char v1; char v2; unsigned short v3; };
struct C_C_Vp { char v1; char v2; void * v3; };
struct C_D { char v1; double v2; };
struct C_D_BFu15i { char v1; double v2; unsigned int v3:15; };
struct C_D_BFu15ll { char v1; double v2; unsigned long long v3:15; };
struct C_D_BFu15s { char v1; double v2; unsigned short v3:15; };
struct C_D_BFu16i { char v1; double v2; unsigned int v3:16; };
struct C_D_BFu16ll { char v1; double v2; unsigned long long v3:16; };
struct C_D_BFu16s { char v1; double v2; unsigned short v3:16; };
struct C_D_BFu17i { char v1; double v2; unsigned int v3:17; };
struct C_D_BFu17ll { char v1; double v2; unsigned long long v3:17; };
struct C_D_BFu1c { char v1; double v2; unsigned char v3:1; };
struct C_D_BFu1i { char v1; double v2; unsigned int v3:1; };
struct C_D_BFu1ll { char v1; double v2; unsigned long long v3:1; };
struct C_D_BFu1s { char v1; double v2; unsigned short v3:1; };
struct C_D_BFu31i { char v1; double v2; unsigned int v3:31; };
struct C_D_BFu31ll { char v1; double v2; unsigned long long v3:31; };
struct C_D_BFu32i { char v1; double v2; unsigned int v3:32; };
struct C_D_BFu32ll { char v1; double v2; unsigned long long v3:32; };
struct C_D_BFu33 { char v1; double v2; unsigned long long v3:33; };
struct C_D_BFu7c { char v1; double v2; unsigned char v3:7; };
struct C_D_BFu7i { char v1; double v2; unsigned int v3:7; };
struct C_D_BFu7ll { char v1; double v2; unsigned long long v3:7; };
struct C_D_BFu7s { char v1; double v2; unsigned short v3:7; };
struct C_D_BFu8c { char v1; double v2; unsigned char v3:8; };
struct C_D_BFu8i { char v1; double v2; unsigned int v3:8; };
struct C_D_BFu8ll { char v1; double v2; unsigned long long v3:8; };
struct C_D_BFu8s { char v1; double v2; unsigned short v3:8; };
struct C_D_BFu9i { char v1; double v2; unsigned int v3:9; };
struct C_D_BFu9ll { char v1; double v2; unsigned long long v3:9; };
struct C_D_BFu9s { char v1; double v2; unsigned short v3:9; };
struct C_D_C { char v1; double v2; char v3; };
struct C_D_D { char v1; double v2; double v3; };
struct C_D_F { char v1; double v2; float v3; };
struct C_D_I { char v1; double v2; int v3; };
struct C_D_Ip { char v1; double v2; int * v3; };
struct C_D_L { char v1; double v2; long long v3; };
struct C_D_S { char v1; double v2; short v3; };
struct C_D_Uc { char v1; double v2; unsigned char v3; };
struct C_D_Ui { char v1; double v2; unsigned int v3; };
struct C_D_Ul { char v1; double v2; unsigned long long v3; };
struct C_D_Us { char v1; double v2; unsigned short v3; };
struct C_D_Vp { char v1; double v2; void * v3; };
struct C_F { char v1; float v2; };
struct C_F_BFu15i { char v1; float v2; unsigned int v3:15; };
struct C_F_BFu15ll { char v1; float v2; unsigned long long v3:15; };
struct C_F_BFu15s { char v1; float v2; unsigned short v3:15; };
struct C_F_BFu16i { char v1; float v2; unsigned int v3:16; };
struct C_F_BFu16ll { char v1; float v2; unsigned long long v3:16; };
struct C_F_BFu16s { char v1; float v2; unsigned short v3:16; };
struct C_F_BFu17i { char v1; float v2; unsigned int v3:17; };
struct C_F_BFu17ll { char v1; float v2; unsigned long long v3:17; };
struct C_F_BFu1c { char v1; float v2; unsigned char v3:1; };
struct C_F_BFu1i { char v1; float v2; unsigned int v3:1; };
struct C_F_BFu1ll { char v1; float v2; unsigned long long v3:1; };
struct C_F_BFu1s { char v1; float v2; unsigned short v3:1; };
struct C_F_BFu31i { char v1; float v2; unsigned int v3:31; };
struct C_F_BFu31ll { char v1; float v2; unsigned long long v3:31; };
struct C_F_BFu32i { char v1; float v2; unsigned int v3:32; };
struct C_F_BFu32ll { char v1; float v2; unsigned long long v3:32; };
struct C_F_BFu33 { char v1; float v2; unsigned long long v3:33; };
struct C_F_BFu7c { char v1; float v2; unsigned char v3:7; };
struct C_F_BFu7i { char v1; float v2; unsigned int v3:7; };
struct C_F_BFu7ll { char v1; float v2; unsigned long long v3:7; };
struct C_F_BFu7s { char v1; float v2; unsigned short v3:7; };
struct C_F_BFu8c { char v1; float v2; unsigned char v3:8; };
struct C_F_BFu8i { char v1; float v2; unsigned int v3:8; };
struct C_F_BFu8ll { char v1; float v2; unsigned long long v3:8; };
struct C_F_BFu8s { char v1; float v2; unsigned short v3:8; };
struct C_F_BFu9i { char v1; float v2; unsigned int v3:9; };
struct C_F_BFu9ll { char v1; float v2; unsigned long long v3:9; };
struct C_F_BFu9s { char v1; float v2; unsigned short v3:9; };
struct C_F_C { char v1; float v2; char v3; };
struct C_F_D { char v1; float v2; double v3; };
struct C_F_F { char v1; float v2; float v3; };
struct C_F_I { char v1; float v2; int v3; };
struct C_F_Ip { char v1; float v2; int * v3; };
struct C_F_L { char v1; float v2; long long v3; };
struct C_F_S { char v1; float v2; short v3; };
struct C_F_Uc { char v1; float v2; unsigned char v3; };
struct C_F_Ui { char v1; float v2; unsigned int v3; };
struct C_F_Ul { char v1; float v2; unsigned long long v3; };
struct C_F_Us { char v1; float v2; unsigned short v3; };
struct C_F_Vp { char v1; float v2; void * v3; };
struct C_I { char v1; int v2; };
struct C_I_BFu15i { char v1; int v2; unsigned int v3:15; };
struct C_I_BFu15ll { char v1; int v2; unsigned long long v3:15; };
struct C_I_BFu15s { char v1; int v2; unsigned short v3:15; };
struct C_I_BFu16i { char v1; int v2; unsigned int v3:16; };
struct C_I_BFu16ll { char v1; int v2; unsigned long long v3:16; };
struct C_I_BFu16s { char v1; int v2; unsigned short v3:16; };
struct C_I_BFu17i { char v1; int v2; unsigned int v3:17; };
struct C_I_BFu17ll { char v1; int v2; unsigned long long v3:17; };
struct C_I_BFu1c { char v1; int v2; unsigned char v3:1; };
struct C_I_BFu1i { char v1; int v2; unsigned int v3:1; };
struct C_I_BFu1ll { char v1; int v2; unsigned long long v3:1; };
struct C_I_BFu1s { char v1; int v2; unsigned short v3:1; };
struct C_I_BFu31i { char v1; int v2; unsigned int v3:31; };
struct C_I_BFu31ll { char v1; int v2; unsigned long long v3:31; };
struct C_I_BFu32i { char v1; int v2; unsigned int v3:32; };
struct C_I_BFu32ll { char v1; int v2; unsigned long long v3:32; };
struct C_I_BFu33 { char v1; int v2; unsigned long long v3:33; };
struct C_I_BFu7c { char v1; int v2; unsigned char v3:7; };
struct C_I_BFu7i { char v1; int v2; unsigned int v3:7; };
struct C_I_BFu7ll { char v1; int v2; unsigned long long v3:7; };
struct C_I_BFu7s { char v1; int v2; unsigned short v3:7; };
struct C_I_BFu8c { char v1; int v2; unsigned char v3:8; };
struct C_I_BFu8i { char v1; int v2; unsigned int v3:8; };
struct C_I_BFu8ll { char v1; int v2; unsigned long long v3:8; };
struct C_I_BFu8s { char v1; int v2; unsigned short v3:8; };
struct C_I_BFu9i { char v1; int v2; unsigned int v3:9; };
struct C_I_BFu9ll { char v1; int v2; unsigned long long v3:9; };
struct C_I_BFu9s { char v1; int v2; unsigned short v3:9; };
struct C_I_C { char v1; int v2; char v3; };
struct C_I_D { char v1; int v2; double v3; };
struct C_I_F { char v1; int v2; float v3; };
struct C_I_I { char v1; int v2; int v3; };
struct C_I_Ip { char v1; int v2; int * v3; };
struct C_I_L { char v1; int v2; long long v3; };
struct C_I_S { char v1; int v2; short v3; };
struct C_I_Uc { char v1; int v2; unsigned char v3; };
struct C_I_Ui { char v1; int v2; unsigned int v3; };
struct C_I_Ul { char v1; int v2; unsigned long long v3; };
struct C_I_Us { char v1; int v2; unsigned short v3; };
struct C_I_Vp { char v1; int v2; void * v3; };
struct C_Ip { char v1; int * v2; };
struct C_Ip_BFu15i { char v1; int * v2; unsigned int v3:15; };
struct C_Ip_BFu15ll { char v1; int * v2; unsigned long long v3:15; };
struct C_Ip_BFu15s { char v1; int * v2; unsigned short v3:15; };
struct C_Ip_BFu16i { char v1; int * v2; unsigned int v3:16; };
struct C_Ip_BFu16ll { char v1; int * v2; unsigned long long v3:16; };
struct C_Ip_BFu16s { char v1; int * v2; unsigned short v3:16; };
struct C_Ip_BFu17i { char v1; int * v2; unsigned int v3:17; };
struct C_Ip_BFu17ll { char v1; int * v2; unsigned long long v3:17; };
struct C_Ip_BFu1c { char v1; int * v2; unsigned char v3:1; };
struct C_Ip_BFu1i { char v1; int * v2; unsigned int v3:1; };
struct C_Ip_BFu1ll { char v1; int * v2; unsigned long long v3:1; };
struct C_Ip_BFu1s { char v1; int * v2; unsigned short v3:1; };
struct C_Ip_BFu31i { char v1; int * v2; unsigned int v3:31; };
struct C_Ip_BFu31ll { char v1; int * v2; unsigned long long v3:31; };
struct C_Ip_BFu32i { char v1; int * v2; unsigned int v3:32; };
struct C_Ip_BFu32ll { char v1; int * v2; unsigned long long v3:32; };
struct C_Ip_BFu33 { char v1; int * v2; unsigned long long v3:33; };
struct C_Ip_BFu7c { char v1; int * v2; unsigned char v3:7; };
struct C_Ip_BFu7i { char v1; int * v2; unsigned int v3:7; };
struct C_Ip_BFu7ll { char v1; int * v2; unsigned long long v3:7; };
struct C_Ip_BFu7s { char v1; int * v2; unsigned short v3:7; };
struct C_Ip_BFu8c { char v1; int * v2; unsigned char v3:8; };
struct C_Ip_BFu8i { char v1; int * v2; unsigned int v3:8; };
struct C_Ip_BFu8ll { char v1; int * v2; unsigned long long v3:8; };
struct C_Ip_BFu8s { char v1; int * v2; unsigned short v3:8; };
struct C_Ip_BFu9i { char v1; int * v2; unsigned int v3:9; };
struct C_Ip_BFu9ll { char v1; int * v2; unsigned long long v3:9; };
struct C_Ip_BFu9s { char v1; int * v2; unsigned short v3:9; };
struct C_Ip_C { char v1; int * v2; char v3; };
struct C_Ip_D { char v1; int * v2; double v3; };
struct C_Ip_F { char v1; int * v2; float v3; };
struct C_Ip_I { char v1; int * v2; int v3; };
struct C_Ip_Ip { char v1; int * v2; int * v3; };
struct C_Ip_L { char v1; int * v2; long long v3; };
struct C_Ip_S { char v1; int * v2; short v3; };
struct C_Ip_Uc { char v1; int * v2; unsigned char v3; };
struct C_Ip_Ui { char v1; int * v2; unsigned int v3; };
struct C_Ip_Ul { char v1; int * v2; unsigned long long v3; };
struct C_Ip_Us { char v1; int * v2; unsigned short v3; };
struct C_Ip_Vp { char v1; int * v2; void * v3; };
struct C_L { char v1; long long v2; };
struct C_L_BFu15i { char v1; long long v2; unsigned int v3:15; };
struct C_L_BFu15ll { char v1; long long v2; unsigned long long v3:15; };
struct C_L_BFu15s { char v1; long long v2; unsigned short v3:15; };
struct C_L_BFu16i { char v1; long long v2; unsigned int v3:16; };
struct C_L_BFu16ll { char v1; long long v2; unsigned long long v3:16; };
struct C_L_BFu16s { char v1; long long v2; unsigned short v3:16; };
struct C_L_BFu17i { char v1; long long v2; unsigned int v3:17; };
struct C_L_BFu17ll { char v1; long long v2; unsigned long long v3:17; };
struct C_L_BFu1c { char v1; long long v2; unsigned char v3:1; };
struct C_L_BFu1i { char v1; long long v2; unsigned int v3:1; };
struct C_L_BFu1ll { char v1; long long v2; unsigned long long v3:1; };
struct C_L_BFu1s { char v1; long long v2; unsigned short v3:1; };
struct C_L_BFu31i { char v1; long long v2; unsigned int v3:31; };
struct C_L_BFu31ll { char v1; long long v2; unsigned long long v3:31; };
struct C_L_BFu32i { char v1; long long v2; unsigned int v3:32; };
struct C_L_BFu32ll { char v1; long long v2; unsigned long long v3:32; };
struct C_L_BFu33 { char v1; long long v2; unsigned long long v3:33; };
struct C_L_BFu7c { char v1; long long v2; unsigned char v3:7; };
struct C_L_BFu7i { char v1; long long v2; unsigned int v3:7; };
struct C_L_BFu7ll { char v1; long long v2; unsigned long long v3:7; };
struct C_L_BFu7s { char v1; long long v2; unsigned short v3:7; };
struct C_L_BFu8c { char v1; long long v2; unsigned char v3:8; };
struct C_L_BFu8i { char v1; long long v2; unsigned int v3:8; };
struct C_L_BFu8ll { char v1; long long v2; unsigned long long v3:8; };
struct C_L_BFu8s { char v1; long long v2; unsigned short v3:8; };
struct C_L_BFu9i { char v1; long long v2; unsigned int v3:9; };
struct C_L_BFu9ll { char v1; long long v2; unsigned long long v3:9; };
struct C_L_BFu9s { char v1; long long v2; unsigned short v3:9; };
struct C_L_C { char v1; long long v2; char v3; };
struct C_L_D { char v1; long long v2; double v3; };
struct C_L_F { char v1; long long v2; float v3; };
struct C_L_I { char v1; long long v2; int v3; };
struct C_L_Ip { char v1; long long v2; int * v3; };
struct C_L_L { char v1; long long v2; long long v3; };
struct C_L_S { char v1; long long v2; short v3; };
struct C_L_Uc { char v1; long long v2; unsigned char v3; };
struct C_L_Ui { char v1; long long v2; unsigned int v3; };
struct C_L_Ul { char v1; long long v2; unsigned long long v3; };
struct C_L_Us { char v1; long long v2; unsigned short v3; };
struct C_L_Vp { char v1; long long v2; void * v3; };
struct C_S { char v1; short v2; };
struct C_S_BFu15i { char v1; short v2; unsigned int v3:15; };
struct C_S_BFu15ll { char v1; short v2; unsigned long long v3:15; };
struct C_S_BFu15s { char v1; short v2; unsigned short v3:15; };
struct C_S_BFu16i { char v1; short v2; unsigned int v3:16; };
struct C_S_BFu16ll { char v1; short v2; unsigned long long v3:16; };
struct C_S_BFu16s { char v1; short v2; unsigned short v3:16; };
struct C_S_BFu17i { char v1; short v2; unsigned int v3:17; };
struct C_S_BFu17ll { char v1; short v2; unsigned long long v3:17; };
struct C_S_BFu1c { char v1; short v2; unsigned char v3:1; };
struct C_S_BFu1i { char v1; short v2; unsigned int v3:1; };
struct C_S_BFu1ll { char v1; short v2; unsigned long long v3:1; };
struct C_S_BFu1s { char v1; short v2; unsigned short v3:1; };
struct C_S_BFu31i { char v1; short v2; unsigned int v3:31; };
struct C_S_BFu31ll { char v1; short v2; unsigned long long v3:31; };
struct C_S_BFu32i { char v1; short v2; unsigned int v3:32; };
struct C_S_BFu32ll { char v1; short v2; unsigned long long v3:32; };
struct C_S_BFu33 { char v1; short v2; unsigned long long v3:33; };
struct C_S_BFu7c { char v1; short v2; unsigned char v3:7; };
struct C_S_BFu7i { char v1; short v2; unsigned int v3:7; };
struct C_S_BFu7ll { char v1; short v2; unsigned long long v3:7; };
struct C_S_BFu7s { char v1; short v2; unsigned short v3:7; };
struct C_S_BFu8c { char v1; short v2; unsigned char v3:8; };
struct C_S_BFu8i { char v1; short v2; unsigned int v3:8; };
struct C_S_BFu8ll { char v1; short v2; unsigned long long v3:8; };
struct C_S_BFu8s { char v1; short v2; unsigned short v3:8; };
struct C_S_BFu9i { char v1; short v2; unsigned int v3:9; };
struct C_S_BFu9ll { char v1; short v2; unsigned long long v3:9; };
struct C_S_BFu9s { char v1; short v2; unsigned short v3:9; };
struct C_S_C { char v1; short v2; char v3; };
struct C_S_D { char v1; short v2; double v3; };
struct C_S_F { char v1; short v2; float v3; };
struct C_S_I { char v1; short v2; int v3; };
struct C_S_Ip { char v1; short v2; int * v3; };
struct C_S_L { char v1; short v2; long long v3; };
struct C_S_S { char v1; short v2; short v3; };
struct C_S_Uc { char v1; short v2; unsigned char v3; };
struct C_S_Ui { char v1; short v2; unsigned int v3; };
struct C_S_Ul { char v1; short v2; unsigned long long v3; };
struct C_S_Us { char v1; short v2; unsigned short v3; };
struct C_S_Vp { char v1; short v2; void * v3; };
struct C_Uc { char v1; unsigned char v2; };
struct C_Uc_BFu15i { char v1; unsigned char v2; unsigned int v3:15; };
struct C_Uc_BFu15ll { char v1; unsigned char v2; unsigned long long v3:15; };
struct C_Uc_BFu15s { char v1; unsigned char v2; unsigned short v3:15; };
struct C_Uc_BFu16i { char v1; unsigned char v2; unsigned int v3:16; };
struct C_Uc_BFu16ll { char v1; unsigned char v2; unsigned long long v3:16; };
struct C_Uc_BFu16s { char v1; unsigned char v2; unsigned short v3:16; };
struct C_Uc_BFu17i { char v1; unsigned char v2; unsigned int v3:17; };
struct C_Uc_BFu17ll { char v1; unsigned char v2; unsigned long long v3:17; };
struct C_Uc_BFu1c { char v1; unsigned char v2; unsigned char v3:1; };
struct C_Uc_BFu1i { char v1; unsigned char v2; unsigned int v3:1; };
struct C_Uc_BFu1ll { char v1; unsigned char v2; unsigned long long v3:1; };
struct C_Uc_BFu1s { char v1; unsigned char v2; unsigned short v3:1; };
struct C_Uc_BFu31i { char v1; unsigned char v2; unsigned int v3:31; };
struct C_Uc_BFu31ll { char v1; unsigned char v2; unsigned long long v3:31; };
struct C_Uc_BFu32i { char v1; unsigned char v2; unsigned int v3:32; };
struct C_Uc_BFu32ll { char v1; unsigned char v2; unsigned long long v3:32; };
struct C_Uc_BFu33 { char v1; unsigned char v2; unsigned long long v3:33; };
struct C_Uc_BFu7c { char v1; unsigned char v2; unsigned char v3:7; };
struct C_Uc_BFu7i { char v1; unsigned char v2; unsigned int v3:7; };
struct C_Uc_BFu7ll { char v1; unsigned char v2; unsigned long long v3:7; };
struct C_Uc_BFu7s { char v1; unsigned char v2; unsigned short v3:7; };
struct C_Uc_BFu8c { char v1; unsigned char v2; unsigned char v3:8; };
struct C_Uc_BFu8i { char v1; unsigned char v2; unsigned int v3:8; };
struct C_Uc_BFu8ll { char v1; unsigned char v2; unsigned long long v3:8; };
struct C_Uc_BFu8s { char v1; unsigned char v2; unsigned short v3:8; };
struct C_Uc_BFu9i { char v1; unsigned char v2; unsigned int v3:9; };
struct C_Uc_BFu9ll { char v1; unsigned char v2; unsigned long long v3:9; };
struct C_Uc_BFu9s { char v1; unsigned char v2; unsigned short v3:9; };
struct C_Uc_C { char v1; unsigned char v2; char v3; };
struct C_Uc_D { char v1; unsigned char v2; double v3; };
struct C_Uc_F { char v1; unsigned char v2; float v3; };
struct C_Uc_I { char v1; unsigned char v2; int v3; };
struct C_Uc_Ip { char v1; unsigned char v2; int * v3; };
struct C_Uc_L { char v1; unsigned char v2; long long v3; };
struct C_Uc_S { char v1; unsigned char v2; short v3; };
struct C_Uc_Uc { char v1; unsigned char v2; unsigned char v3; };
struct C_Uc_Ui { char v1; unsigned char v2; unsigned int v3; };
struct C_Uc_Ul { char v1; unsigned char v2; unsigned long long v3; };
struct C_Uc_Us { char v1; unsigned char v2; unsigned short v3; };
struct C_Uc_Vp { char v1; unsigned char v2; void * v3; };
struct C_Ui { char v1; unsigned int v2; };
struct C_Ui_BFu15i { char v1; unsigned int v2; unsigned int v3:15; };
struct C_Ui_BFu15ll { char v1; unsigned int v2; unsigned long long v3:15; };
struct C_Ui_BFu15s { char v1; unsigned int v2; unsigned short v3:15; };
struct C_Ui_BFu16i { char v1; unsigned int v2; unsigned int v3:16; };
struct C_Ui_BFu16ll { char v1; unsigned int v2; unsigned long long v3:16; };
struct C_Ui_BFu16s { char v1; unsigned int v2; unsigned short v3:16; };
struct C_Ui_BFu17i { char v1; unsigned int v2; unsigned int v3:17; };
struct C_Ui_BFu17ll { char v1; unsigned int v2; unsigned long long v3:17; };
struct C_Ui_BFu1c { char v1; unsigned int v2; unsigned char v3:1; };
struct C_Ui_BFu1i { char v1; unsigned int v2; unsigned int v3:1; };
struct C_Ui_BFu1ll { char v1; unsigned int v2; unsigned long long v3:1; };
struct C_Ui_BFu1s { char v1; unsigned int v2; unsigned short v3:1; };
struct C_Ui_BFu31i { char v1; unsigned int v2; unsigned int v3:31; };
struct C_Ui_BFu31ll { char v1; unsigned int v2; unsigned long long v3:31; };
struct C_Ui_BFu32i { char v1; unsigned int v2; unsigned int v3:32; };
struct C_Ui_BFu32ll { char v1; unsigned int v2; unsigned long long v3:32; };
struct C_Ui_BFu33 { char v1; unsigned int v2; unsigned long long v3:33; };
struct C_Ui_BFu7c { char v1; unsigned int v2; unsigned char v3:7; };
struct C_Ui_BFu7i { char v1; unsigned int v2; unsigned int v3:7; };
struct C_Ui_BFu7ll { char v1; unsigned int v2; unsigned long long v3:7; };
struct C_Ui_BFu7s { char v1; unsigned int v2; unsigned short v3:7; };
struct C_Ui_BFu8c { char v1; unsigned int v2; unsigned char v3:8; };
struct C_Ui_BFu8i { char v1; unsigned int v2; unsigned int v3:8; };
struct C_Ui_BFu8ll { char v1; unsigned int v2; unsigned long long v3:8; };
struct C_Ui_BFu8s { char v1; unsigned int v2; unsigned short v3:8; };
struct C_Ui_BFu9i { char v1; unsigned int v2; unsigned int v3:9; };
struct C_Ui_BFu9ll { char v1; unsigned int v2; unsigned long long v3:9; };
struct C_Ui_BFu9s { char v1; unsigned int v2; unsigned short v3:9; };
struct C_Ui_C { char v1; unsigned int v2; char v3; };
struct C_Ui_D { char v1; unsigned int v2; double v3; };
struct C_Ui_F { char v1; unsigned int v2; float v3; };
struct C_Ui_I { char v1; unsigned int v2; int v3; };
struct C_Ui_Ip { char v1; unsigned int v2; int * v3; };
struct C_Ui_L { char v1; unsigned int v2; long long v3; };
struct C_Ui_S { char v1; unsigned int v2; short v3; };
struct C_Ui_Uc { char v1; unsigned int v2; unsigned char v3; };
struct C_Ui_Ui { char v1; unsigned int v2; unsigned int v3; };
struct C_Ui_Ul { char v1; unsigned int v2; unsigned long long v3; };
struct C_Ui_Us { char v1; unsigned int v2; unsigned short v3; };
struct C_Ui_Vp { char v1; unsigned int v2; void * v3; };
struct C_Ul { char v1; unsigned long long v2; };
struct C_Ul_BFu15i { char v1; unsigned long long v2; unsigned int v3:15; };
struct C_Ul_BFu15ll { char v1; unsigned long long v2; unsigned long long v3:15; };
struct C_Ul_BFu15s { char v1; unsigned long long v2; unsigned short v3:15; };
struct C_Ul_BFu16i { char v1; unsigned long long v2; unsigned int v3:16; };
struct C_Ul_BFu16ll { char v1; unsigned long long v2; unsigned long long v3:16; };
struct C_Ul_BFu16s { char v1; unsigned long long v2; unsigned short v3:16; };
struct C_Ul_BFu17i { char v1; unsigned long long v2; unsigned int v3:17; };
struct C_Ul_BFu17ll { char v1; unsigned long long v2; unsigned long long v3:17; };
struct C_Ul_BFu1c { char v1; unsigned long long v2; unsigned char v3:1; };
struct C_Ul_BFu1i { char v1; unsigned long long v2; unsigned int v3:1; };
struct C_Ul_BFu1ll { char v1; unsigned long long v2; unsigned long long v3:1; };
struct C_Ul_BFu1s { char v1; unsigned long long v2; unsigned short v3:1; };
struct C_Ul_BFu31i { char v1; unsigned long long v2; unsigned int v3:31; };
struct C_Ul_BFu31ll { char v1; unsigned long long v2; unsigned long long v3:31; };
struct C_Ul_BFu32i { char v1; unsigned long long v2; unsigned int v3:32; };
struct C_Ul_BFu32ll { char v1; unsigned long long v2; unsigned long long v3:32; };
struct C_Ul_BFu33 { char v1; unsigned long long v2; unsigned long long v3:33; };
struct C_Ul_BFu7c { char v1; unsigned long long v2; unsigned char v3:7; };
struct C_Ul_BFu7i { char v1; unsigned long long v2; unsigned int v3:7; };
struct C_Ul_BFu7ll { char v1; unsigned long long v2; unsigned long long v3:7; };
struct C_Ul_BFu7s { char v1; unsigned long long v2; unsigned short v3:7; };
struct C_Ul_BFu8c { char v1; unsigned long long v2; unsigned char v3:8; };
struct C_Ul_BFu8i { char v1; unsigned long long v2; unsigned int v3:8; };
struct C_Ul_BFu8ll { char v1; unsigned long long v2; unsigned long long v3:8; };
struct C_Ul_BFu8s { char v1; unsigned long long v2; unsigned short v3:8; };
struct C_Ul_BFu9i { char v1; unsigned long long v2; unsigned int v3:9; };
struct C_Ul_BFu9ll { char v1; unsigned long long v2; unsigned long long v3:9; };
struct C_Ul_BFu9s { char v1; unsigned long long v2; unsigned short v3:9; };
struct C_Ul_C { char v1; unsigned long long v2; char v3; };
struct C_Ul_D { char v1; unsigned long long v2; double v3; };
struct C_Ul_F { char v1; unsigned long long v2; float v3; };
struct C_Ul_I { char v1; unsigned long long v2; int v3; };
struct C_Ul_Ip { char v1; unsigned long long v2; int * v3; };
struct C_Ul_L { char v1; unsigned long long v2; long long v3; };
struct C_Ul_S { char v1; unsigned long long v2; short v3; };
struct C_Ul_Uc { char v1; unsigned long long v2; unsigned char v3; };
struct C_Ul_Ui { char v1; unsigned long long v2; unsigned int v3; };
struct C_Ul_Ul { char v1; unsigned long long v2; unsigned long long v3; };
struct C_Ul_Us { char v1; unsigned long long v2; unsigned short v3; };
struct C_Ul_Vp { char v1; unsigned long long v2; void * v3; };
struct C_Us { char v1; unsigned short v2; };
struct C_Us_BFu15i { char v1; unsigned short v2; unsigned int v3:15; };
struct C_Us_BFu15ll { char v1; unsigned short v2; unsigned long long v3:15; };
struct C_Us_BFu15s { char v1; unsigned short v2; unsigned short v3:15; };
struct C_Us_BFu16i { char v1; unsigned short v2; unsigned int v3:16; };
struct C_Us_BFu16ll { char v1; unsigned short v2; unsigned long long v3:16; };
struct C_Us_BFu16s { char v1; unsigned short v2; unsigned short v3:16; };
struct C_Us_BFu17i { char v1; unsigned short v2; unsigned int v3:17; };
struct C_Us_BFu17ll { char v1; unsigned short v2; unsigned long long v3:17; };
struct C_Us_BFu1c { char v1; unsigned short v2; unsigned char v3:1; };
struct C_Us_BFu1i { char v1; unsigned short v2; unsigned int v3:1; };
struct C_Us_BFu1ll { char v1; unsigned short v2; unsigned long long v3:1; };
struct C_Us_BFu1s { char v1; unsigned short v2; unsigned short v3:1; };
struct C_Us_BFu31i { char v1; unsigned short v2; unsigned int v3:31; };
struct C_Us_BFu31ll { char v1; unsigned short v2; unsigned long long v3:31; };
struct C_Us_BFu32i { char v1; unsigned short v2; unsigned int v3:32; };
struct C_Us_BFu32ll { char v1; unsigned short v2; unsigned long long v3:32; };
struct C_Us_BFu33 { char v1; unsigned short v2; unsigned long long v3:33; };
struct C_Us_BFu7c { char v1; unsigned short v2; unsigned char v3:7; };
struct C_Us_BFu7i { char v1; unsigned short v2; unsigned int v3:7; };
struct C_Us_BFu7ll { char v1; unsigned short v2; unsigned long long v3:7; };
struct C_Us_BFu7s { char v1; unsigned short v2; unsigned short v3:7; };
struct C_Us_BFu8c { char v1; unsigned short v2; unsigned char v3:8; };
struct C_Us_BFu8i { char v1; unsigned short v2; unsigned int v3:8; };
struct C_Us_BFu8ll { char v1; unsigned short v2; unsigned long long v3:8; };
struct C_Us_BFu8s { char v1; unsigned short v2; unsigned short v3:8; };
struct C_Us_BFu9i { char v1; unsigned short v2; unsigned int v3:9; };
struct C_Us_BFu9ll { char v1; unsigned short v2; unsigned long long v3:9; };
struct C_Us_BFu9s { char v1; unsigned short v2; unsigned short v3:9; };
struct C_Us_C { char v1; unsigned short v2; char v3; };
struct C_Us_D { char v1; unsigned short v2; double v3; };
struct C_Us_F { char v1; unsigned short v2; float v3; };
struct C_Us_I { char v1; unsigned short v2; int v3; };
struct C_Us_Ip { char v1; unsigned short v2; int * v3; };
struct C_Us_L { char v1; unsigned short v2; long long v3; };
struct C_Us_S { char v1; unsigned short v2; short v3; };
struct C_Us_Uc { char v1; unsigned short v2; unsigned char v3; };
struct C_Us_Ui { char v1; unsigned short v2; unsigned int v3; };
struct C_Us_Ul { char v1; unsigned short v2; unsigned long long v3; };
struct C_Us_Us { char v1; unsigned short v2; unsigned short v3; };
struct C_Us_Vp { char v1; unsigned short v2; void * v3; };
struct C_Vp { char v1; void * v2; };
struct C_Vp_BFu15i { char v1; void * v2; unsigned int v3:15; };
struct C_Vp_BFu15ll { char v1; void * v2; unsigned long long v3:15; };
struct C_Vp_BFu15s { char v1; void * v2; unsigned short v3:15; };
struct C_Vp_BFu16i { char v1; void * v2; unsigned int v3:16; };
struct C_Vp_BFu16ll { char v1; void * v2; unsigned long long v3:16; };
struct C_Vp_BFu16s { char v1; void * v2; unsigned short v3:16; };
struct C_Vp_BFu17i { char v1; void * v2; unsigned int v3:17; };
struct C_Vp_BFu17ll { char v1; void * v2; unsigned long long v3:17; };
struct C_Vp_BFu1c { char v1; void * v2; unsigned char v3:1; };
struct C_Vp_BFu1i { char v1; void * v2; unsigned int v3:1; };
struct C_Vp_BFu1ll { char v1; void * v2; unsigned long long v3:1; };
struct C_Vp_BFu1s { char v1; void * v2; unsigned short v3:1; };
struct C_Vp_BFu31i { char v1; void * v2; unsigned int v3:31; };
struct C_Vp_BFu31ll { char v1; void * v2; unsigned long long v3:31; };
struct C_Vp_BFu32i { char v1; void * v2; unsigned int v3:32; };
struct C_Vp_BFu32ll { char v1; void * v2; unsigned long long v3:32; };
struct C_Vp_BFu33 { char v1; void * v2; unsigned long long v3:33; };
struct C_Vp_BFu7c { char v1; void * v2; unsigned char v3:7; };
struct C_Vp_BFu7i { char v1; void * v2; unsigned int v3:7; };
struct C_Vp_BFu7ll { char v1; void * v2; unsigned long long v3:7; };
struct C_Vp_BFu7s { char v1; void * v2; unsigned short v3:7; };
struct C_Vp_BFu8c { char v1; void * v2; unsigned char v3:8; };
struct C_Vp_BFu8i { char v1; void * v2; unsigned int v3:8; };
struct C_Vp_BFu8ll { char v1; void * v2; unsigned long long v3:8; };
struct C_Vp_BFu8s { char v1; void * v2; unsigned short v3:8; };
struct C_Vp_BFu9i { char v1; void * v2; unsigned int v3:9; };
struct C_Vp_BFu9ll { char v1; void * v2; unsigned long long v3:9; };
struct C_Vp_BFu9s { char v1; void * v2; unsigned short v3:9; };
struct C_Vp_C { char v1; void * v2; char v3; };
struct C_Vp_D { char v1; void * v2; double v3; };
struct C_Vp_F { char v1; void * v2; float v3; };
struct C_Vp_I { char v1; void * v2; int v3; };
struct C_Vp_Ip { char v1; void * v2; int * v3; };
struct C_Vp_L { char v1; void * v2; long long v3; };
struct C_Vp_S { char v1; void * v2; short v3; };
struct C_Vp_Uc { char v1; void * v2; unsigned char v3; };
struct C_Vp_Ui { char v1; void * v2; unsigned int v3; };
struct C_Vp_Ul { char v1; void * v2; unsigned long long v3; };
struct C_Vp_Us { char v1; void * v2; unsigned short v3; };
struct C_Vp_Vp { char v1; void * v2; void * v3; };
struct D { double v1; };
struct D_BFu15i { double v1; unsigned int v2:15; };
struct D_BFu15i_BFu15i { double v1; unsigned int v2:15; unsigned int v3:15; };
struct D_BFu15i_BFu15ll { double v1; unsigned int v2:15; unsigned long long v3:15; };
struct D_BFu15i_BFu15s { double v1; unsigned int v2:15; unsigned short v3:15; };
struct D_BFu15i_BFu16i { double v1; unsigned int v2:15; unsigned int v3:16; };
struct D_BFu15i_BFu16ll { double v1; unsigned int v2:15; unsigned long long v3:16; };
struct D_BFu15i_BFu16s { double v1; unsigned int v2:15; unsigned short v3:16; };
struct D_BFu15i_BFu17i { double v1; unsigned int v2:15; unsigned int v3:17; };
struct D_BFu15i_BFu17ll { double v1; unsigned int v2:15; unsigned long long v3:17; };
struct D_BFu15i_BFu1c { double v1; unsigned int v2:15; unsigned char v3:1; };
struct D_BFu15i_BFu1i { double v1; unsigned int v2:15; unsigned int v3:1; };
struct D_BFu15i_BFu1ll { double v1; unsigned int v2:15; unsigned long long v3:1; };
struct D_BFu15i_BFu1s { double v1; unsigned int v2:15; unsigned short v3:1; };
struct D_BFu15i_BFu31i { double v1; unsigned int v2:15; unsigned int v3:31; };
struct D_BFu15i_BFu31ll { double v1; unsigned int v2:15; unsigned long long v3:31; };
struct D_BFu15i_BFu32i { double v1; unsigned int v2:15; unsigned int v3:32; };
struct D_BFu15i_BFu32ll { double v1; unsigned int v2:15; unsigned long long v3:32; };
struct D_BFu15i_BFu33 { double v1; unsigned int v2:15; unsigned long long v3:33; };
struct D_BFu15i_BFu7c { double v1; unsigned int v2:15; unsigned char v3:7; };
struct D_BFu15i_BFu7i { double v1; unsigned int v2:15; unsigned int v3:7; };
struct D_BFu15i_BFu7ll { double v1; unsigned int v2:15; unsigned long long v3:7; };
struct D_BFu15i_BFu7s { double v1; unsigned int v2:15; unsigned short v3:7; };
struct D_BFu15i_BFu8c { double v1; unsigned int v2:15; unsigned char v3:8; };
struct D_BFu15i_BFu8i { double v1; unsigned int v2:15; unsigned int v3:8; };
struct D_BFu15i_BFu8ll { double v1; unsigned int v2:15; unsigned long long v3:8; };
struct D_BFu15i_BFu8s { double v1; unsigned int v2:15; unsigned short v3:8; };
struct D_BFu15i_BFu9i { double v1; unsigned int v2:15; unsigned int v3:9; };
struct D_BFu15i_BFu9ll { double v1; unsigned int v2:15; unsigned long long v3:9; };
struct D_BFu15i_BFu9s { double v1; unsigned int v2:15; unsigned short v3:9; };
struct D_BFu15i_C { double v1; unsigned int v2:15; char v3; };
struct D_BFu15i_D { double v1; unsigned int v2:15; double v3; };
struct D_BFu15i_F { double v1; unsigned int v2:15; float v3; };
struct D_BFu15i_I { double v1; unsigned int v2:15; int v3; };
struct D_BFu15i_Ip { double v1; unsigned int v2:15; int * v3; };
struct D_BFu15i_L { double v1; unsigned int v2:15; long long v3; };
struct D_BFu15i_S { double v1; unsigned int v2:15; short v3; };
struct D_BFu15i_Uc { double v1; unsigned int v2:15; unsigned char v3; };
struct D_BFu15i_Ui { double v1; unsigned int v2:15; unsigned int v3; };
struct D_BFu15i_Ul { double v1; unsigned int v2:15; unsigned long long v3; };
struct D_BFu15i_Us { double v1; unsigned int v2:15; unsigned short v3; };
struct D_BFu15i_Vp { double v1; unsigned int v2:15; void * v3; };
struct D_BFu15ll { double v1; unsigned long long v2:15; };
struct D_BFu15ll_BFu15i { double v1; unsigned long long v2:15; unsigned int v3:15; };
struct D_BFu15ll_BFu15ll { double v1; unsigned long long v2:15; unsigned long long v3:15; };
struct D_BFu15ll_BFu15s { double v1; unsigned long long v2:15; unsigned short v3:15; };
struct D_BFu15ll_BFu16i { double v1; unsigned long long v2:15; unsigned int v3:16; };
struct D_BFu15ll_BFu16ll { double v1; unsigned long long v2:15; unsigned long long v3:16; };
struct D_BFu15ll_BFu16s { double v1; unsigned long long v2:15; unsigned short v3:16; };
struct D_BFu15ll_BFu17i { double v1; unsigned long long v2:15; unsigned int v3:17; };
struct D_BFu15ll_BFu17ll { double v1; unsigned long long v2:15; unsigned long long v3:17; };
struct D_BFu15ll_BFu1c { double v1; unsigned long long v2:15; unsigned char v3:1; };
struct D_BFu15ll_BFu1i { double v1; unsigned long long v2:15; unsigned int v3:1; };
struct D_BFu15ll_BFu1ll { double v1; unsigned long long v2:15; unsigned long long v3:1; };
struct D_BFu15ll_BFu1s { double v1; unsigned long long v2:15; unsigned short v3:1; };
struct D_BFu15ll_BFu31i { double v1; unsigned long long v2:15; unsigned int v3:31; };
struct D_BFu15ll_BFu31ll { double v1; unsigned long long v2:15; unsigned long long v3:31; };
struct D_BFu15ll_BFu32i { double v1; unsigned long long v2:15; unsigned int v3:32; };
struct D_BFu15ll_BFu32ll { double v1; unsigned long long v2:15; unsigned long long v3:32; };
struct D_BFu15ll_BFu33 { double v1; unsigned long long v2:15; unsigned long long v3:33; };
struct D_BFu15ll_BFu7c { double v1; unsigned long long v2:15; unsigned char v3:7; };
struct D_BFu15ll_BFu7i { double v1; unsigned long long v2:15; unsigned int v3:7; };
struct D_BFu15ll_BFu7ll { double v1; unsigned long long v2:15; unsigned long long v3:7; };
struct D_BFu15ll_BFu7s { double v1; unsigned long long v2:15; unsigned short v3:7; };
struct D_BFu15ll_BFu8c { double v1; unsigned long long v2:15; unsigned char v3:8; };
struct D_BFu15ll_BFu8i { double v1; unsigned long long v2:15; unsigned int v3:8; };
struct D_BFu15ll_BFu8ll { double v1; unsigned long long v2:15; unsigned long long v3:8; };
struct D_BFu15ll_BFu8s { double v1; unsigned long long v2:15; unsigned short v3:8; };
struct D_BFu15ll_BFu9i { double v1; unsigned long long v2:15; unsigned int v3:9; };
struct D_BFu15ll_BFu9ll { double v1; unsigned long long v2:15; unsigned long long v3:9; };
struct D_BFu15ll_BFu9s { double v1; unsigned long long v2:15; unsigned short v3:9; };
struct D_BFu15ll_C { double v1; unsigned long long v2:15; char v3; };
struct D_BFu15ll_D { double v1; unsigned long long v2:15; double v3; };
struct D_BFu15ll_F { double v1; unsigned long long v2:15; float v3; };
struct D_BFu15ll_I { double v1; unsigned long long v2:15; int v3; };
struct D_BFu15ll_Ip { double v1; unsigned long long v2:15; int * v3; };
struct D_BFu15ll_L { double v1; unsigned long long v2:15; long long v3; };
struct D_BFu15ll_S { double v1; unsigned long long v2:15; short v3; };
struct D_BFu15ll_Uc { double v1; unsigned long long v2:15; unsigned char v3; };
struct D_BFu15ll_Ui { double v1; unsigned long long v2:15; unsigned int v3; };
struct D_BFu15ll_Ul { double v1; unsigned long long v2:15; unsigned long long v3; };
struct D_BFu15ll_Us { double v1; unsigned long long v2:15; unsigned short v3; };
struct D_BFu15ll_Vp { double v1; unsigned long long v2:15; void * v3; };
struct D_BFu15s { double v1; unsigned short v2:15; };
struct D_BFu15s_BFu15i { double v1; unsigned short v2:15; unsigned int v3:15; };
struct D_BFu15s_BFu15ll { double v1; unsigned short v2:15; unsigned long long v3:15; };
struct D_BFu15s_BFu15s { double v1; unsigned short v2:15; unsigned short v3:15; };
struct D_BFu15s_BFu16i { double v1; unsigned short v2:15; unsigned int v3:16; };
struct D_BFu15s_BFu16ll { double v1; unsigned short v2:15; unsigned long long v3:16; };
struct D_BFu15s_BFu16s { double v1; unsigned short v2:15; unsigned short v3:16; };
struct D_BFu15s_BFu17i { double v1; unsigned short v2:15; unsigned int v3:17; };
struct D_BFu15s_BFu17ll { double v1; unsigned short v2:15; unsigned long long v3:17; };
struct D_BFu15s_BFu1c { double v1; unsigned short v2:15; unsigned char v3:1; };
struct D_BFu15s_BFu1i { double v1; unsigned short v2:15; unsigned int v3:1; };
struct D_BFu15s_BFu1ll { double v1; unsigned short v2:15; unsigned long long v3:1; };
struct D_BFu15s_BFu1s { double v1; unsigned short v2:15; unsigned short v3:1; };
struct D_BFu15s_BFu31i { double v1; unsigned short v2:15; unsigned int v3:31; };
struct D_BFu15s_BFu31ll { double v1; unsigned short v2:15; unsigned long long v3:31; };
struct D_BFu15s_BFu32i { double v1; unsigned short v2:15; unsigned int v3:32; };
struct D_BFu15s_BFu32ll { double v1; unsigned short v2:15; unsigned long long v3:32; };
struct D_BFu15s_BFu33 { double v1; unsigned short v2:15; unsigned long long v3:33; };
struct D_BFu15s_BFu7c { double v1; unsigned short v2:15; unsigned char v3:7; };
struct D_BFu15s_BFu7i { double v1; unsigned short v2:15; unsigned int v3:7; };
struct D_BFu15s_BFu7ll { double v1; unsigned short v2:15; unsigned long long v3:7; };
struct D_BFu15s_BFu7s { double v1; unsigned short v2:15; unsigned short v3:7; };
struct D_BFu15s_BFu8c { double v1; unsigned short v2:15; unsigned char v3:8; };
struct D_BFu15s_BFu8i { double v1; unsigned short v2:15; unsigned int v3:8; };
struct D_BFu15s_BFu8ll { double v1; unsigned short v2:15; unsigned long long v3:8; };
struct D_BFu15s_BFu8s { double v1; unsigned short v2:15; unsigned short v3:8; };
struct D_BFu15s_BFu9i { double v1; unsigned short v2:15; unsigned int v3:9; };
struct D_BFu15s_BFu9ll { double v1; unsigned short v2:15; unsigned long long v3:9; };
struct D_BFu15s_BFu9s { double v1; unsigned short v2:15; unsigned short v3:9; };
struct D_BFu15s_C { double v1; unsigned short v2:15; char v3; };
struct D_BFu15s_D { double v1; unsigned short v2:15; double v3; };
struct D_BFu15s_F { double v1; unsigned short v2:15; float v3; };
struct D_BFu15s_I { double v1; unsigned short v2:15; int v3; };
struct D_BFu15s_Ip { double v1; unsigned short v2:15; int * v3; };
struct D_BFu15s_L { double v1; unsigned short v2:15; long long v3; };
struct D_BFu15s_S { double v1; unsigned short v2:15; short v3; };
struct D_BFu15s_Uc { double v1; unsigned short v2:15; unsigned char v3; };
struct D_BFu15s_Ui { double v1; unsigned short v2:15; unsigned int v3; };
struct D_BFu15s_Ul { double v1; unsigned short v2:15; unsigned long long v3; };
struct D_BFu15s_Us { double v1; unsigned short v2:15; unsigned short v3; };
struct D_BFu15s_Vp { double v1; unsigned short v2:15; void * v3; };
struct D_BFu16i { double v1; unsigned int v2:16; };
struct D_BFu16i_BFu15i { double v1; unsigned int v2:16; unsigned int v3:15; };
struct D_BFu16i_BFu15ll { double v1; unsigned int v2:16; unsigned long long v3:15; };
struct D_BFu16i_BFu15s { double v1; unsigned int v2:16; unsigned short v3:15; };
struct D_BFu16i_BFu16i { double v1; unsigned int v2:16; unsigned int v3:16; };
struct D_BFu16i_BFu16ll { double v1; unsigned int v2:16; unsigned long long v3:16; };
struct D_BFu16i_BFu16s { double v1; unsigned int v2:16; unsigned short v3:16; };
struct D_BFu16i_BFu17i { double v1; unsigned int v2:16; unsigned int v3:17; };
struct D_BFu16i_BFu17ll { double v1; unsigned int v2:16; unsigned long long v3:17; };
struct D_BFu16i_BFu1c { double v1; unsigned int v2:16; unsigned char v3:1; };
struct D_BFu16i_BFu1i { double v1; unsigned int v2:16; unsigned int v3:1; };
struct D_BFu16i_BFu1ll { double v1; unsigned int v2:16; unsigned long long v3:1; };
struct D_BFu16i_BFu1s { double v1; unsigned int v2:16; unsigned short v3:1; };
struct D_BFu16i_BFu31i { double v1; unsigned int v2:16; unsigned int v3:31; };
struct D_BFu16i_BFu31ll { double v1; unsigned int v2:16; unsigned long long v3:31; };
struct D_BFu16i_BFu32i { double v1; unsigned int v2:16; unsigned int v3:32; };
struct D_BFu16i_BFu32ll { double v1; unsigned int v2:16; unsigned long long v3:32; };
struct D_BFu16i_BFu33 { double v1; unsigned int v2:16; unsigned long long v3:33; };
struct D_BFu16i_BFu7c { double v1; unsigned int v2:16; unsigned char v3:7; };
struct D_BFu16i_BFu7i { double v1; unsigned int v2:16; unsigned int v3:7; };
struct D_BFu16i_BFu7ll { double v1; unsigned int v2:16; unsigned long long v3:7; };
struct D_BFu16i_BFu7s { double v1; unsigned int v2:16; unsigned short v3:7; };
struct D_BFu16i_BFu8c { double v1; unsigned int v2:16; unsigned char v3:8; };
struct D_BFu16i_BFu8i { double v1; unsigned int v2:16; unsigned int v3:8; };
struct D_BFu16i_BFu8ll { double v1; unsigned int v2:16; unsigned long long v3:8; };
struct D_BFu16i_BFu8s { double v1; unsigned int v2:16; unsigned short v3:8; };
struct D_BFu16i_BFu9i { double v1; unsigned int v2:16; unsigned int v3:9; };
struct D_BFu16i_BFu9ll { double v1; unsigned int v2:16; unsigned long long v3:9; };
struct D_BFu16i_BFu9s { double v1; unsigned int v2:16; unsigned short v3:9; };
struct D_BFu16i_C { double v1; unsigned int v2:16; char v3; };
struct D_BFu16i_D { double v1; unsigned int v2:16; double v3; };
struct D_BFu16i_F { double v1; unsigned int v2:16; float v3; };
struct D_BFu16i_I { double v1; unsigned int v2:16; int v3; };
struct D_BFu16i_Ip { double v1; unsigned int v2:16; int * v3; };
struct D_BFu16i_L { double v1; unsigned int v2:16; long long v3; };
struct D_BFu16i_S { double v1; unsigned int v2:16; short v3; };
struct D_BFu16i_Uc { double v1; unsigned int v2:16; unsigned char v3; };
struct D_BFu16i_Ui { double v1; unsigned int v2:16; unsigned int v3; };
struct D_BFu16i_Ul { double v1; unsigned int v2:16; unsigned long long v3; };
struct D_BFu16i_Us { double v1; unsigned int v2:16; unsigned short v3; };
struct D_BFu16i_Vp { double v1; unsigned int v2:16; void * v3; };
struct D_BFu16ll { double v1; unsigned long long v2:16; };
struct D_BFu16ll_BFu15i { double v1; unsigned long long v2:16; unsigned int v3:15; };
struct D_BFu16ll_BFu15ll { double v1; unsigned long long v2:16; unsigned long long v3:15; };
struct D_BFu16ll_BFu15s { double v1; unsigned long long v2:16; unsigned short v3:15; };
struct D_BFu16ll_BFu16i { double v1; unsigned long long v2:16; unsigned int v3:16; };
struct D_BFu16ll_BFu16ll { double v1; unsigned long long v2:16; unsigned long long v3:16; };
struct D_BFu16ll_BFu16s { double v1; unsigned long long v2:16; unsigned short v3:16; };
struct D_BFu16ll_BFu17i { double v1; unsigned long long v2:16; unsigned int v3:17; };
struct D_BFu16ll_BFu17ll { double v1; unsigned long long v2:16; unsigned long long v3:17; };
struct D_BFu16ll_BFu1c { double v1; unsigned long long v2:16; unsigned char v3:1; };
struct D_BFu16ll_BFu1i { double v1; unsigned long long v2:16; unsigned int v3:1; };
struct D_BFu16ll_BFu1ll { double v1; unsigned long long v2:16; unsigned long long v3:1; };
struct D_BFu16ll_BFu1s { double v1; unsigned long long v2:16; unsigned short v3:1; };
struct D_BFu16ll_BFu31i { double v1; unsigned long long v2:16; unsigned int v3:31; };
struct D_BFu16ll_BFu31ll { double v1; unsigned long long v2:16; unsigned long long v3:31; };
struct D_BFu16ll_BFu32i { double v1; unsigned long long v2:16; unsigned int v3:32; };
struct D_BFu16ll_BFu32ll { double v1; unsigned long long v2:16; unsigned long long v3:32; };
struct D_BFu16ll_BFu33 { double v1; unsigned long long v2:16; unsigned long long v3:33; };
struct D_BFu16ll_BFu7c { double v1; unsigned long long v2:16; unsigned char v3:7; };
struct D_BFu16ll_BFu7i { double v1; unsigned long long v2:16; unsigned int v3:7; };
struct D_BFu16ll_BFu7ll { double v1; unsigned long long v2:16; unsigned long long v3:7; };
struct D_BFu16ll_BFu7s { double v1; unsigned long long v2:16; unsigned short v3:7; };
struct D_BFu16ll_BFu8c { double v1; unsigned long long v2:16; unsigned char v3:8; };
struct D_BFu16ll_BFu8i { double v1; unsigned long long v2:16; unsigned int v3:8; };
struct D_BFu16ll_BFu8ll { double v1; unsigned long long v2:16; unsigned long long v3:8; };
struct D_BFu16ll_BFu8s { double v1; unsigned long long v2:16; unsigned short v3:8; };
struct D_BFu16ll_BFu9i { double v1; unsigned long long v2:16; unsigned int v3:9; };
struct D_BFu16ll_BFu9ll { double v1; unsigned long long v2:16; unsigned long long v3:9; };
struct D_BFu16ll_BFu9s { double v1; unsigned long long v2:16; unsigned short v3:9; };
struct D_BFu16ll_C { double v1; unsigned long long v2:16; char v3; };
struct D_BFu16ll_D { double v1; unsigned long long v2:16; double v3; };
struct D_BFu16ll_F { double v1; unsigned long long v2:16; float v3; };
struct D_BFu16ll_I { double v1; unsigned long long v2:16; int v3; };
struct D_BFu16ll_Ip { double v1; unsigned long long v2:16; int * v3; };
struct D_BFu16ll_L { double v1; unsigned long long v2:16; long long v3; };
struct D_BFu16ll_S { double v1; unsigned long long v2:16; short v3; };
struct D_BFu16ll_Uc { double v1; unsigned long long v2:16; unsigned char v3; };
struct D_BFu16ll_Ui { double v1; unsigned long long v2:16; unsigned int v3; };
struct D_BFu16ll_Ul { double v1; unsigned long long v2:16; unsigned long long v3; };
struct D_BFu16ll_Us { double v1; unsigned long long v2:16; unsigned short v3; };
struct D_BFu16ll_Vp { double v1; unsigned long long v2:16; void * v3; };
struct D_BFu16s { double v1; unsigned short v2:16; };
struct D_BFu16s_BFu15i { double v1; unsigned short v2:16; unsigned int v3:15; };
struct D_BFu16s_BFu15ll { double v1; unsigned short v2:16; unsigned long long v3:15; };
struct D_BFu16s_BFu15s { double v1; unsigned short v2:16; unsigned short v3:15; };
struct D_BFu16s_BFu16i { double v1; unsigned short v2:16; unsigned int v3:16; };
struct D_BFu16s_BFu16ll { double v1; unsigned short v2:16; unsigned long long v3:16; };
struct D_BFu16s_BFu16s { double v1; unsigned short v2:16; unsigned short v3:16; };
struct D_BFu16s_BFu17i { double v1; unsigned short v2:16; unsigned int v3:17; };
struct D_BFu16s_BFu17ll { double v1; unsigned short v2:16; unsigned long long v3:17; };
struct D_BFu16s_BFu1c { double v1; unsigned short v2:16; unsigned char v3:1; };
struct D_BFu16s_BFu1i { double v1; unsigned short v2:16; unsigned int v3:1; };
struct D_BFu16s_BFu1ll { double v1; unsigned short v2:16; unsigned long long v3:1; };
struct D_BFu16s_BFu1s { double v1; unsigned short v2:16; unsigned short v3:1; };
struct D_BFu16s_BFu31i { double v1; unsigned short v2:16; unsigned int v3:31; };
struct D_BFu16s_BFu31ll { double v1; unsigned short v2:16; unsigned long long v3:31; };
struct D_BFu16s_BFu32i { double v1; unsigned short v2:16; unsigned int v3:32; };
struct D_BFu16s_BFu32ll { double v1; unsigned short v2:16; unsigned long long v3:32; };
struct D_BFu16s_BFu33 { double v1; unsigned short v2:16; unsigned long long v3:33; };
struct D_BFu16s_BFu7c { double v1; unsigned short v2:16; unsigned char v3:7; };
struct D_BFu16s_BFu7i { double v1; unsigned short v2:16; unsigned int v3:7; };
struct D_BFu16s_BFu7ll { double v1; unsigned short v2:16; unsigned long long v3:7; };
struct D_BFu16s_BFu7s { double v1; unsigned short v2:16; unsigned short v3:7; };
struct D_BFu16s_BFu8c { double v1; unsigned short v2:16; unsigned char v3:8; };
struct D_BFu16s_BFu8i { double v1; unsigned short v2:16; unsigned int v3:8; };
struct D_BFu16s_BFu8ll { double v1; unsigned short v2:16; unsigned long long v3:8; };
struct D_BFu16s_BFu8s { double v1; unsigned short v2:16; unsigned short v3:8; };
struct D_BFu16s_BFu9i { double v1; unsigned short v2:16; unsigned int v3:9; };
struct D_BFu16s_BFu9ll { double v1; unsigned short v2:16; unsigned long long v3:9; };
struct D_BFu16s_BFu9s { double v1; unsigned short v2:16; unsigned short v3:9; };
struct D_BFu16s_C { double v1; unsigned short v2:16; char v3; };
struct D_BFu16s_D { double v1; unsigned short v2:16; double v3; };
struct D_BFu16s_F { double v1; unsigned short v2:16; float v3; };
struct D_BFu16s_I { double v1; unsigned short v2:16; int v3; };
struct D_BFu16s_Ip { double v1; unsigned short v2:16; int * v3; };
struct D_BFu16s_L { double v1; unsigned short v2:16; long long v3; };
struct D_BFu16s_S { double v1; unsigned short v2:16; short v3; };
struct D_BFu16s_Uc { double v1; unsigned short v2:16; unsigned char v3; };
struct D_BFu16s_Ui { double v1; unsigned short v2:16; unsigned int v3; };
struct D_BFu16s_Ul { double v1; unsigned short v2:16; unsigned long long v3; };
struct D_BFu16s_Us { double v1; unsigned short v2:16; unsigned short v3; };
struct D_BFu16s_Vp { double v1; unsigned short v2:16; void * v3; };
struct D_BFu17i { double v1; unsigned int v2:17; };
struct D_BFu17i_BFu15i { double v1; unsigned int v2:17; unsigned int v3:15; };
struct D_BFu17i_BFu15ll { double v1; unsigned int v2:17; unsigned long long v3:15; };
struct D_BFu17i_BFu15s { double v1; unsigned int v2:17; unsigned short v3:15; };
struct D_BFu17i_BFu16i { double v1; unsigned int v2:17; unsigned int v3:16; };
struct D_BFu17i_BFu16ll { double v1; unsigned int v2:17; unsigned long long v3:16; };
struct D_BFu17i_BFu16s { double v1; unsigned int v2:17; unsigned short v3:16; };
struct D_BFu17i_BFu17i { double v1; unsigned int v2:17; unsigned int v3:17; };
struct D_BFu17i_BFu17ll { double v1; unsigned int v2:17; unsigned long long v3:17; };
struct D_BFu17i_BFu1c { double v1; unsigned int v2:17; unsigned char v3:1; };
struct D_BFu17i_BFu1i { double v1; unsigned int v2:17; unsigned int v3:1; };
struct D_BFu17i_BFu1ll { double v1; unsigned int v2:17; unsigned long long v3:1; };
struct D_BFu17i_BFu1s { double v1; unsigned int v2:17; unsigned short v3:1; };
struct D_BFu17i_BFu31i { double v1; unsigned int v2:17; unsigned int v3:31; };
struct D_BFu17i_BFu31ll { double v1; unsigned int v2:17; unsigned long long v3:31; };
struct D_BFu17i_BFu32i { double v1; unsigned int v2:17; unsigned int v3:32; };
struct D_BFu17i_BFu32ll { double v1; unsigned int v2:17; unsigned long long v3:32; };
struct D_BFu17i_BFu33 { double v1; unsigned int v2:17; unsigned long long v3:33; };
struct D_BFu17i_BFu7c { double v1; unsigned int v2:17; unsigned char v3:7; };
struct D_BFu17i_BFu7i { double v1; unsigned int v2:17; unsigned int v3:7; };
struct D_BFu17i_BFu7ll { double v1; unsigned int v2:17; unsigned long long v3:7; };
struct D_BFu17i_BFu7s { double v1; unsigned int v2:17; unsigned short v3:7; };
struct D_BFu17i_BFu8c { double v1; unsigned int v2:17; unsigned char v3:8; };
struct D_BFu17i_BFu8i { double v1; unsigned int v2:17; unsigned int v3:8; };
struct D_BFu17i_BFu8ll { double v1; unsigned int v2:17; unsigned long long v3:8; };
struct D_BFu17i_BFu8s { double v1; unsigned int v2:17; unsigned short v3:8; };
struct D_BFu17i_BFu9i { double v1; unsigned int v2:17; unsigned int v3:9; };
struct D_BFu17i_BFu9ll { double v1; unsigned int v2:17; unsigned long long v3:9; };
struct D_BFu17i_BFu9s { double v1; unsigned int v2:17; unsigned short v3:9; };
struct D_BFu17i_C { double v1; unsigned int v2:17; char v3; };
struct D_BFu17i_D { double v1; unsigned int v2:17; double v3; };
struct D_BFu17i_F { double v1; unsigned int v2:17; float v3; };
struct D_BFu17i_I { double v1; unsigned int v2:17; int v3; };
struct D_BFu17i_Ip { double v1; unsigned int v2:17; int * v3; };
struct D_BFu17i_L { double v1; unsigned int v2:17; long long v3; };
struct D_BFu17i_S { double v1; unsigned int v2:17; short v3; };
struct D_BFu17i_Uc { double v1; unsigned int v2:17; unsigned char v3; };
struct D_BFu17i_Ui { double v1; unsigned int v2:17; unsigned int v3; };
struct D_BFu17i_Ul { double v1; unsigned int v2:17; unsigned long long v3; };
struct D_BFu17i_Us { double v1; unsigned int v2:17; unsigned short v3; };
struct D_BFu17i_Vp { double v1; unsigned int v2:17; void * v3; };
struct D_BFu17ll { double v1; unsigned long long v2:17; };
struct D_BFu17ll_BFu15i { double v1; unsigned long long v2:17; unsigned int v3:15; };
struct D_BFu17ll_BFu15ll { double v1; unsigned long long v2:17; unsigned long long v3:15; };
struct D_BFu17ll_BFu15s { double v1; unsigned long long v2:17; unsigned short v3:15; };
struct D_BFu17ll_BFu16i { double v1; unsigned long long v2:17; unsigned int v3:16; };
struct D_BFu17ll_BFu16ll { double v1; unsigned long long v2:17; unsigned long long v3:16; };
struct D_BFu17ll_BFu16s { double v1; unsigned long long v2:17; unsigned short v3:16; };
struct D_BFu17ll_BFu17i { double v1; unsigned long long v2:17; unsigned int v3:17; };
struct D_BFu17ll_BFu17ll { double v1; unsigned long long v2:17; unsigned long long v3:17; };
struct D_BFu17ll_BFu1c { double v1; unsigned long long v2:17; unsigned char v3:1; };
struct D_BFu17ll_BFu1i { double v1; unsigned long long v2:17; unsigned int v3:1; };
struct D_BFu17ll_BFu1ll { double v1; unsigned long long v2:17; unsigned long long v3:1; };
struct D_BFu17ll_BFu1s { double v1; unsigned long long v2:17; unsigned short v3:1; };
struct D_BFu17ll_BFu31i { double v1; unsigned long long v2:17; unsigned int v3:31; };
struct D_BFu17ll_BFu31ll { double v1; unsigned long long v2:17; unsigned long long v3:31; };
struct D_BFu17ll_BFu32i { double v1; unsigned long long v2:17; unsigned int v3:32; };
struct D_BFu17ll_BFu32ll { double v1; unsigned long long v2:17; unsigned long long v3:32; };
struct D_BFu17ll_BFu33 { double v1; unsigned long long v2:17; unsigned long long v3:33; };
struct D_BFu17ll_BFu7c { double v1; unsigned long long v2:17; unsigned char v3:7; };
struct D_BFu17ll_BFu7i { double v1; unsigned long long v2:17; unsigned int v3:7; };
struct D_BFu17ll_BFu7ll { double v1; unsigned long long v2:17; unsigned long long v3:7; };
struct D_BFu17ll_BFu7s { double v1; unsigned long long v2:17; unsigned short v3:7; };
struct D_BFu17ll_BFu8c { double v1; unsigned long long v2:17; unsigned char v3:8; };
struct D_BFu17ll_BFu8i { double v1; unsigned long long v2:17; unsigned int v3:8; };
struct D_BFu17ll_BFu8ll { double v1; unsigned long long v2:17; unsigned long long v3:8; };
struct D_BFu17ll_BFu8s { double v1; unsigned long long v2:17; unsigned short v3:8; };
struct D_BFu17ll_BFu9i { double v1; unsigned long long v2:17; unsigned int v3:9; };
struct D_BFu17ll_BFu9ll { double v1; unsigned long long v2:17; unsigned long long v3:9; };
struct D_BFu17ll_BFu9s { double v1; unsigned long long v2:17; unsigned short v3:9; };
struct D_BFu17ll_C { double v1; unsigned long long v2:17; char v3; };
struct D_BFu17ll_D { double v1; unsigned long long v2:17; double v3; };
struct D_BFu17ll_F { double v1; unsigned long long v2:17; float v3; };
struct D_BFu17ll_I { double v1; unsigned long long v2:17; int v3; };
struct D_BFu17ll_Ip { double v1; unsigned long long v2:17; int * v3; };
struct D_BFu17ll_L { double v1; unsigned long long v2:17; long long v3; };
struct D_BFu17ll_S { double v1; unsigned long long v2:17; short v3; };
struct D_BFu17ll_Uc { double v1; unsigned long long v2:17; unsigned char v3; };
struct D_BFu17ll_Ui { double v1; unsigned long long v2:17; unsigned int v3; };
struct D_BFu17ll_Ul { double v1; unsigned long long v2:17; unsigned long long v3; };
struct D_BFu17ll_Us { double v1; unsigned long long v2:17; unsigned short v3; };
struct D_BFu17ll_Vp { double v1; unsigned long long v2:17; void * v3; };
struct D_BFu1c { double v1; unsigned char v2:1; };
struct D_BFu1c_BFu15i { double v1; unsigned char v2:1; unsigned int v3:15; };
struct D_BFu1c_BFu15ll { double v1; unsigned char v2:1; unsigned long long v3:15; };
struct D_BFu1c_BFu15s { double v1; unsigned char v2:1; unsigned short v3:15; };
struct D_BFu1c_BFu16i { double v1; unsigned char v2:1; unsigned int v3:16; };
struct D_BFu1c_BFu16ll { double v1; unsigned char v2:1; unsigned long long v3:16; };
struct D_BFu1c_BFu16s { double v1; unsigned char v2:1; unsigned short v3:16; };
struct D_BFu1c_BFu17i { double v1; unsigned char v2:1; unsigned int v3:17; };
struct D_BFu1c_BFu17ll { double v1; unsigned char v2:1; unsigned long long v3:17; };
struct D_BFu1c_BFu1c { double v1; unsigned char v2:1; unsigned char v3:1; };
struct D_BFu1c_BFu1i { double v1; unsigned char v2:1; unsigned int v3:1; };
struct D_BFu1c_BFu1ll { double v1; unsigned char v2:1; unsigned long long v3:1; };
struct D_BFu1c_BFu1s { double v1; unsigned char v2:1; unsigned short v3:1; };
struct D_BFu1c_BFu31i { double v1; unsigned char v2:1; unsigned int v3:31; };
struct D_BFu1c_BFu31ll { double v1; unsigned char v2:1; unsigned long long v3:31; };
struct D_BFu1c_BFu32i { double v1; unsigned char v2:1; unsigned int v3:32; };
struct D_BFu1c_BFu32ll { double v1; unsigned char v2:1; unsigned long long v3:32; };
struct D_BFu1c_BFu33 { double v1; unsigned char v2:1; unsigned long long v3:33; };
struct D_BFu1c_BFu7c { double v1; unsigned char v2:1; unsigned char v3:7; };
struct D_BFu1c_BFu7i { double v1; unsigned char v2:1; unsigned int v3:7; };
struct D_BFu1c_BFu7ll { double v1; unsigned char v2:1; unsigned long long v3:7; };
struct D_BFu1c_BFu7s { double v1; unsigned char v2:1; unsigned short v3:7; };
struct D_BFu1c_BFu8c { double v1; unsigned char v2:1; unsigned char v3:8; };
struct D_BFu1c_BFu8i { double v1; unsigned char v2:1; unsigned int v3:8; };
struct D_BFu1c_BFu8ll { double v1; unsigned char v2:1; unsigned long long v3:8; };
struct D_BFu1c_BFu8s { double v1; unsigned char v2:1; unsigned short v3:8; };
struct D_BFu1c_BFu9i { double v1; unsigned char v2:1; unsigned int v3:9; };
struct D_BFu1c_BFu9ll { double v1; unsigned char v2:1; unsigned long long v3:9; };
struct D_BFu1c_BFu9s { double v1; unsigned char v2:1; unsigned short v3:9; };
struct D_BFu1c_C { double v1; unsigned char v2:1; char v3; };
struct D_BFu1c_D { double v1; unsigned char v2:1; double v3; };
struct D_BFu1c_F { double v1; unsigned char v2:1; float v3; };
struct D_BFu1c_I { double v1; unsigned char v2:1; int v3; };
struct D_BFu1c_Ip { double v1; unsigned char v2:1; int * v3; };
struct D_BFu1c_L { double v1; unsigned char v2:1; long long v3; };
struct D_BFu1c_S { double v1; unsigned char v2:1; short v3; };
struct D_BFu1c_Uc { double v1; unsigned char v2:1; unsigned char v3; };
struct D_BFu1c_Ui { double v1; unsigned char v2:1; unsigned int v3; };
struct D_BFu1c_Ul { double v1; unsigned char v2:1; unsigned long long v3; };
struct D_BFu1c_Us { double v1; unsigned char v2:1; unsigned short v3; };
struct D_BFu1c_Vp { double v1; unsigned char v2:1; void * v3; };
struct D_BFu1i { double v1; unsigned int v2:1; };
struct D_BFu1i_BFu15i { double v1; unsigned int v2:1; unsigned int v3:15; };
struct D_BFu1i_BFu15ll { double v1; unsigned int v2:1; unsigned long long v3:15; };
struct D_BFu1i_BFu15s { double v1; unsigned int v2:1; unsigned short v3:15; };
struct D_BFu1i_BFu16i { double v1; unsigned int v2:1; unsigned int v3:16; };
struct D_BFu1i_BFu16ll { double v1; unsigned int v2:1; unsigned long long v3:16; };
struct D_BFu1i_BFu16s { double v1; unsigned int v2:1; unsigned short v3:16; };
struct D_BFu1i_BFu17i { double v1; unsigned int v2:1; unsigned int v3:17; };
struct D_BFu1i_BFu17ll { double v1; unsigned int v2:1; unsigned long long v3:17; };
struct D_BFu1i_BFu1c { double v1; unsigned int v2:1; unsigned char v3:1; };
struct D_BFu1i_BFu1i { double v1; unsigned int v2:1; unsigned int v3:1; };
struct D_BFu1i_BFu1ll { double v1; unsigned int v2:1; unsigned long long v3:1; };
struct D_BFu1i_BFu1s { double v1; unsigned int v2:1; unsigned short v3:1; };
struct D_BFu1i_BFu31i { double v1; unsigned int v2:1; unsigned int v3:31; };
struct D_BFu1i_BFu31ll { double v1; unsigned int v2:1; unsigned long long v3:31; };
struct D_BFu1i_BFu32i { double v1; unsigned int v2:1; unsigned int v3:32; };
struct D_BFu1i_BFu32ll { double v1; unsigned int v2:1; unsigned long long v3:32; };
struct D_BFu1i_BFu33 { double v1; unsigned int v2:1; unsigned long long v3:33; };
struct D_BFu1i_BFu7c { double v1; unsigned int v2:1; unsigned char v3:7; };
struct D_BFu1i_BFu7i { double v1; unsigned int v2:1; unsigned int v3:7; };
struct D_BFu1i_BFu7ll { double v1; unsigned int v2:1; unsigned long long v3:7; };
struct D_BFu1i_BFu7s { double v1; unsigned int v2:1; unsigned short v3:7; };
struct D_BFu1i_BFu8c { double v1; unsigned int v2:1; unsigned char v3:8; };
struct D_BFu1i_BFu8i { double v1; unsigned int v2:1; unsigned int v3:8; };
struct D_BFu1i_BFu8ll { double v1; unsigned int v2:1; unsigned long long v3:8; };
struct D_BFu1i_BFu8s { double v1; unsigned int v2:1; unsigned short v3:8; };
struct D_BFu1i_BFu9i { double v1; unsigned int v2:1; unsigned int v3:9; };
struct D_BFu1i_BFu9ll { double v1; unsigned int v2:1; unsigned long long v3:9; };
struct D_BFu1i_BFu9s { double v1; unsigned int v2:1; unsigned short v3:9; };
struct D_BFu1i_C { double v1; unsigned int v2:1; char v3; };
struct D_BFu1i_D { double v1; unsigned int v2:1; double v3; };
struct D_BFu1i_F { double v1; unsigned int v2:1; float v3; };
struct D_BFu1i_I { double v1; unsigned int v2:1; int v3; };
struct D_BFu1i_Ip { double v1; unsigned int v2:1; int * v3; };
struct D_BFu1i_L { double v1; unsigned int v2:1; long long v3; };
struct D_BFu1i_S { double v1; unsigned int v2:1; short v3; };
struct D_BFu1i_Uc { double v1; unsigned int v2:1; unsigned char v3; };
struct D_BFu1i_Ui { double v1; unsigned int v2:1; unsigned int v3; };
struct D_BFu1i_Ul { double v1; unsigned int v2:1; unsigned long long v3; };
struct D_BFu1i_Us { double v1; unsigned int v2:1; unsigned short v3; };
struct D_BFu1i_Vp { double v1; unsigned int v2:1; void * v3; };
struct D_BFu1ll { double v1; unsigned long long v2:1; };
struct D_BFu1ll_BFu15i { double v1; unsigned long long v2:1; unsigned int v3:15; };
struct D_BFu1ll_BFu15ll { double v1; unsigned long long v2:1; unsigned long long v3:15; };
struct D_BFu1ll_BFu15s { double v1; unsigned long long v2:1; unsigned short v3:15; };
struct D_BFu1ll_BFu16i { double v1; unsigned long long v2:1; unsigned int v3:16; };
struct D_BFu1ll_BFu16ll { double v1; unsigned long long v2:1; unsigned long long v3:16; };
struct D_BFu1ll_BFu16s { double v1; unsigned long long v2:1; unsigned short v3:16; };
struct D_BFu1ll_BFu17i { double v1; unsigned long long v2:1; unsigned int v3:17; };
struct D_BFu1ll_BFu17ll { double v1; unsigned long long v2:1; unsigned long long v3:17; };
struct D_BFu1ll_BFu1c { double v1; unsigned long long v2:1; unsigned char v3:1; };
struct D_BFu1ll_BFu1i { double v1; unsigned long long v2:1; unsigned int v3:1; };
struct D_BFu1ll_BFu1ll { double v1; unsigned long long v2:1; unsigned long long v3:1; };
struct D_BFu1ll_BFu1s { double v1; unsigned long long v2:1; unsigned short v3:1; };
struct D_BFu1ll_BFu31i { double v1; unsigned long long v2:1; unsigned int v3:31; };
struct D_BFu1ll_BFu31ll { double v1; unsigned long long v2:1; unsigned long long v3:31; };
struct D_BFu1ll_BFu32i { double v1; unsigned long long v2:1; unsigned int v3:32; };
struct D_BFu1ll_BFu32ll { double v1; unsigned long long v2:1; unsigned long long v3:32; };
struct D_BFu1ll_BFu33 { double v1; unsigned long long v2:1; unsigned long long v3:33; };
struct D_BFu1ll_BFu7c { double v1; unsigned long long v2:1; unsigned char v3:7; };
struct D_BFu1ll_BFu7i { double v1; unsigned long long v2:1; unsigned int v3:7; };
struct D_BFu1ll_BFu7ll { double v1; unsigned long long v2:1; unsigned long long v3:7; };
struct D_BFu1ll_BFu7s { double v1; unsigned long long v2:1; unsigned short v3:7; };
struct D_BFu1ll_BFu8c { double v1; unsigned long long v2:1; unsigned char v3:8; };
struct D_BFu1ll_BFu8i { double v1; unsigned long long v2:1; unsigned int v3:8; };
struct D_BFu1ll_BFu8ll { double v1; unsigned long long v2:1; unsigned long long v3:8; };
struct D_BFu1ll_BFu8s { double v1; unsigned long long v2:1; unsigned short v3:8; };
struct D_BFu1ll_BFu9i { double v1; unsigned long long v2:1; unsigned int v3:9; };
struct D_BFu1ll_BFu9ll { double v1; unsigned long long v2:1; unsigned long long v3:9; };
struct D_BFu1ll_BFu9s { double v1; unsigned long long v2:1; unsigned short v3:9; };
struct D_BFu1ll_C { double v1; unsigned long long v2:1; char v3; };
struct D_BFu1ll_D { double v1; unsigned long long v2:1; double v3; };
struct D_BFu1ll_F { double v1; unsigned long long v2:1; float v3; };
struct D_BFu1ll_I { double v1; unsigned long long v2:1; int v3; };
struct D_BFu1ll_Ip { double v1; unsigned long long v2:1; int * v3; };
struct D_BFu1ll_L { double v1; unsigned long long v2:1; long long v3; };
struct D_BFu1ll_S { double v1; unsigned long long v2:1; short v3; };
struct D_BFu1ll_Uc { double v1; unsigned long long v2:1; unsigned char v3; };
struct D_BFu1ll_Ui { double v1; unsigned long long v2:1; unsigned int v3; };
struct D_BFu1ll_Ul { double v1; unsigned long long v2:1; unsigned long long v3; };
struct D_BFu1ll_Us { double v1; unsigned long long v2:1; unsigned short v3; };
struct D_BFu1ll_Vp { double v1; unsigned long long v2:1; void * v3; };
struct D_BFu1s { double v1; unsigned short v2:1; };
struct D_BFu1s_BFu15i { double v1; unsigned short v2:1; unsigned int v3:15; };
struct D_BFu1s_BFu15ll { double v1; unsigned short v2:1; unsigned long long v3:15; };
struct D_BFu1s_BFu15s { double v1; unsigned short v2:1; unsigned short v3:15; };
struct D_BFu1s_BFu16i { double v1; unsigned short v2:1; unsigned int v3:16; };
struct D_BFu1s_BFu16ll { double v1; unsigned short v2:1; unsigned long long v3:16; };
struct D_BFu1s_BFu16s { double v1; unsigned short v2:1; unsigned short v3:16; };
struct D_BFu1s_BFu17i { double v1; unsigned short v2:1; unsigned int v3:17; };
struct D_BFu1s_BFu17ll { double v1; unsigned short v2:1; unsigned long long v3:17; };
struct D_BFu1s_BFu1c { double v1; unsigned short v2:1; unsigned char v3:1; };
struct D_BFu1s_BFu1i { double v1; unsigned short v2:1; unsigned int v3:1; };
struct D_BFu1s_BFu1ll { double v1; unsigned short v2:1; unsigned long long v3:1; };
struct D_BFu1s_BFu1s { double v1; unsigned short v2:1; unsigned short v3:1; };
struct D_BFu1s_BFu31i { double v1; unsigned short v2:1; unsigned int v3:31; };
struct D_BFu1s_BFu31ll { double v1; unsigned short v2:1; unsigned long long v3:31; };
struct D_BFu1s_BFu32i { double v1; unsigned short v2:1; unsigned int v3:32; };
struct D_BFu1s_BFu32ll { double v1; unsigned short v2:1; unsigned long long v3:32; };
struct D_BFu1s_BFu33 { double v1; unsigned short v2:1; unsigned long long v3:33; };
struct D_BFu1s_BFu7c { double v1; unsigned short v2:1; unsigned char v3:7; };
struct D_BFu1s_BFu7i { double v1; unsigned short v2:1; unsigned int v3:7; };
struct D_BFu1s_BFu7ll { double v1; unsigned short v2:1; unsigned long long v3:7; };
struct D_BFu1s_BFu7s { double v1; unsigned short v2:1; unsigned short v3:7; };
struct D_BFu1s_BFu8c { double v1; unsigned short v2:1; unsigned char v3:8; };
struct D_BFu1s_BFu8i { double v1; unsigned short v2:1; unsigned int v3:8; };
struct D_BFu1s_BFu8ll { double v1; unsigned short v2:1; unsigned long long v3:8; };
struct D_BFu1s_BFu8s { double v1; unsigned short v2:1; unsigned short v3:8; };
struct D_BFu1s_BFu9i { double v1; unsigned short v2:1; unsigned int v3:9; };
struct D_BFu1s_BFu9ll { double v1; unsigned short v2:1; unsigned long long v3:9; };
struct D_BFu1s_BFu9s { double v1; unsigned short v2:1; unsigned short v3:9; };
struct D_BFu1s_C { double v1; unsigned short v2:1; char v3; };
struct D_BFu1s_D { double v1; unsigned short v2:1; double v3; };
struct D_BFu1s_F { double v1; unsigned short v2:1; float v3; };
struct D_BFu1s_I { double v1; unsigned short v2:1; int v3; };
struct D_BFu1s_Ip { double v1; unsigned short v2:1; int * v3; };
struct D_BFu1s_L { double v1; unsigned short v2:1; long long v3; };
struct D_BFu1s_S { double v1; unsigned short v2:1; short v3; };
struct D_BFu1s_Uc { double v1; unsigned short v2:1; unsigned char v3; };
struct D_BFu1s_Ui { double v1; unsigned short v2:1; unsigned int v3; };
struct D_BFu1s_Ul { double v1; unsigned short v2:1; unsigned long long v3; };
struct D_BFu1s_Us { double v1; unsigned short v2:1; unsigned short v3; };
struct D_BFu1s_Vp { double v1; unsigned short v2:1; void * v3; };
struct D_BFu31i { double v1; unsigned int v2:31; };
struct D_BFu31i_BFu15i { double v1; unsigned int v2:31; unsigned int v3:15; };
struct D_BFu31i_BFu15ll { double v1; unsigned int v2:31; unsigned long long v3:15; };
struct D_BFu31i_BFu15s { double v1; unsigned int v2:31; unsigned short v3:15; };
struct D_BFu31i_BFu16i { double v1; unsigned int v2:31; unsigned int v3:16; };
struct D_BFu31i_BFu16ll { double v1; unsigned int v2:31; unsigned long long v3:16; };
struct D_BFu31i_BFu16s { double v1; unsigned int v2:31; unsigned short v3:16; };
struct D_BFu31i_BFu17i { double v1; unsigned int v2:31; unsigned int v3:17; };
struct D_BFu31i_BFu17ll { double v1; unsigned int v2:31; unsigned long long v3:17; };
struct D_BFu31i_BFu1c { double v1; unsigned int v2:31; unsigned char v3:1; };
struct D_BFu31i_BFu1i { double v1; unsigned int v2:31; unsigned int v3:1; };
struct D_BFu31i_BFu1ll { double v1; unsigned int v2:31; unsigned long long v3:1; };
struct D_BFu31i_BFu1s { double v1; unsigned int v2:31; unsigned short v3:1; };
struct D_BFu31i_BFu31i { double v1; unsigned int v2:31; unsigned int v3:31; };
struct D_BFu31i_BFu31ll { double v1; unsigned int v2:31; unsigned long long v3:31; };
struct D_BFu31i_BFu32i { double v1; unsigned int v2:31; unsigned int v3:32; };
struct D_BFu31i_BFu32ll { double v1; unsigned int v2:31; unsigned long long v3:32; };
struct D_BFu31i_BFu33 { double v1; unsigned int v2:31; unsigned long long v3:33; };
struct D_BFu31i_BFu7c { double v1; unsigned int v2:31; unsigned char v3:7; };
struct D_BFu31i_BFu7i { double v1; unsigned int v2:31; unsigned int v3:7; };
struct D_BFu31i_BFu7ll { double v1; unsigned int v2:31; unsigned long long v3:7; };
struct D_BFu31i_BFu7s { double v1; unsigned int v2:31; unsigned short v3:7; };
struct D_BFu31i_BFu8c { double v1; unsigned int v2:31; unsigned char v3:8; };
struct D_BFu31i_BFu8i { double v1; unsigned int v2:31; unsigned int v3:8; };
struct D_BFu31i_BFu8ll { double v1; unsigned int v2:31; unsigned long long v3:8; };
struct D_BFu31i_BFu8s { double v1; unsigned int v2:31; unsigned short v3:8; };
struct D_BFu31i_BFu9i { double v1; unsigned int v2:31; unsigned int v3:9; };
struct D_BFu31i_BFu9ll { double v1; unsigned int v2:31; unsigned long long v3:9; };
struct D_BFu31i_BFu9s { double v1; unsigned int v2:31; unsigned short v3:9; };
struct D_BFu31i_C { double v1; unsigned int v2:31; char v3; };
struct D_BFu31i_D { double v1; unsigned int v2:31; double v3; };
struct D_BFu31i_F { double v1; unsigned int v2:31; float v3; };
struct D_BFu31i_I { double v1; unsigned int v2:31; int v3; };
struct D_BFu31i_Ip { double v1; unsigned int v2:31; int * v3; };
struct D_BFu31i_L { double v1; unsigned int v2:31; long long v3; };
struct D_BFu31i_S { double v1; unsigned int v2:31; short v3; };
struct D_BFu31i_Uc { double v1; unsigned int v2:31; unsigned char v3; };
struct D_BFu31i_Ui { double v1; unsigned int v2:31; unsigned int v3; };
struct D_BFu31i_Ul { double v1; unsigned int v2:31; unsigned long long v3; };
struct D_BFu31i_Us { double v1; unsigned int v2:31; unsigned short v3; };
struct D_BFu31i_Vp { double v1; unsigned int v2:31; void * v3; };
struct D_BFu31ll { double v1; unsigned long long v2:31; };
struct D_BFu31ll_BFu15i { double v1; unsigned long long v2:31; unsigned int v3:15; };
struct D_BFu31ll_BFu15ll { double v1; unsigned long long v2:31; unsigned long long v3:15; };
struct D_BFu31ll_BFu15s { double v1; unsigned long long v2:31; unsigned short v3:15; };
struct D_BFu31ll_BFu16i { double v1; unsigned long long v2:31; unsigned int v3:16; };
struct D_BFu31ll_BFu16ll { double v1; unsigned long long v2:31; unsigned long long v3:16; };
struct D_BFu31ll_BFu16s { double v1; unsigned long long v2:31; unsigned short v3:16; };
struct D_BFu31ll_BFu17i { double v1; unsigned long long v2:31; unsigned int v3:17; };
struct D_BFu31ll_BFu17ll { double v1; unsigned long long v2:31; unsigned long long v3:17; };
struct D_BFu31ll_BFu1c { double v1; unsigned long long v2:31; unsigned char v3:1; };
struct D_BFu31ll_BFu1i { double v1; unsigned long long v2:31; unsigned int v3:1; };
struct D_BFu31ll_BFu1ll { double v1; unsigned long long v2:31; unsigned long long v3:1; };
struct D_BFu31ll_BFu1s { double v1; unsigned long long v2:31; unsigned short v3:1; };
struct D_BFu31ll_BFu31i { double v1; unsigned long long v2:31; unsigned int v3:31; };
struct D_BFu31ll_BFu31ll { double v1; unsigned long long v2:31; unsigned long long v3:31; };
struct D_BFu31ll_BFu32i { double v1; unsigned long long v2:31; unsigned int v3:32; };
struct D_BFu31ll_BFu32ll { double v1; unsigned long long v2:31; unsigned long long v3:32; };
struct D_BFu31ll_BFu33 { double v1; unsigned long long v2:31; unsigned long long v3:33; };
struct D_BFu31ll_BFu7c { double v1; unsigned long long v2:31; unsigned char v3:7; };
struct D_BFu31ll_BFu7i { double v1; unsigned long long v2:31; unsigned int v3:7; };
struct D_BFu31ll_BFu7ll { double v1; unsigned long long v2:31; unsigned long long v3:7; };
struct D_BFu31ll_BFu7s { double v1; unsigned long long v2:31; unsigned short v3:7; };
struct D_BFu31ll_BFu8c { double v1; unsigned long long v2:31; unsigned char v3:8; };
struct D_BFu31ll_BFu8i { double v1; unsigned long long v2:31; unsigned int v3:8; };
struct D_BFu31ll_BFu8ll { double v1; unsigned long long v2:31; unsigned long long v3:8; };
struct D_BFu31ll_BFu8s { double v1; unsigned long long v2:31; unsigned short v3:8; };
struct D_BFu31ll_BFu9i { double v1; unsigned long long v2:31; unsigned int v3:9; };
struct D_BFu31ll_BFu9ll { double v1; unsigned long long v2:31; unsigned long long v3:9; };
struct D_BFu31ll_BFu9s { double v1; unsigned long long v2:31; unsigned short v3:9; };
struct D_BFu31ll_C { double v1; unsigned long long v2:31; char v3; };
struct D_BFu31ll_D { double v1; unsigned long long v2:31; double v3; };
struct D_BFu31ll_F { double v1; unsigned long long v2:31; float v3; };
struct D_BFu31ll_I { double v1; unsigned long long v2:31; int v3; };
struct D_BFu31ll_Ip { double v1; unsigned long long v2:31; int * v3; };
struct D_BFu31ll_L { double v1; unsigned long long v2:31; long long v3; };
struct D_BFu31ll_S { double v1; unsigned long long v2:31; short v3; };
struct D_BFu31ll_Uc { double v1; unsigned long long v2:31; unsigned char v3; };
struct D_BFu31ll_Ui { double v1; unsigned long long v2:31; unsigned int v3; };
struct D_BFu31ll_Ul { double v1; unsigned long long v2:31; unsigned long long v3; };
struct D_BFu31ll_Us { double v1; unsigned long long v2:31; unsigned short v3; };
struct D_BFu31ll_Vp { double v1; unsigned long long v2:31; void * v3; };
struct D_BFu32i { double v1; unsigned int v2:32; };
struct D_BFu32i_BFu15i { double v1; unsigned int v2:32; unsigned int v3:15; };
struct D_BFu32i_BFu15ll { double v1; unsigned int v2:32; unsigned long long v3:15; };
struct D_BFu32i_BFu15s { double v1; unsigned int v2:32; unsigned short v3:15; };
struct D_BFu32i_BFu16i { double v1; unsigned int v2:32; unsigned int v3:16; };
struct D_BFu32i_BFu16ll { double v1; unsigned int v2:32; unsigned long long v3:16; };
struct D_BFu32i_BFu16s { double v1; unsigned int v2:32; unsigned short v3:16; };
struct D_BFu32i_BFu17i { double v1; unsigned int v2:32; unsigned int v3:17; };
struct D_BFu32i_BFu17ll { double v1; unsigned int v2:32; unsigned long long v3:17; };
struct D_BFu32i_BFu1c { double v1; unsigned int v2:32; unsigned char v3:1; };
struct D_BFu32i_BFu1i { double v1; unsigned int v2:32; unsigned int v3:1; };
struct D_BFu32i_BFu1ll { double v1; unsigned int v2:32; unsigned long long v3:1; };
struct D_BFu32i_BFu1s { double v1; unsigned int v2:32; unsigned short v3:1; };
struct D_BFu32i_BFu31i { double v1; unsigned int v2:32; unsigned int v3:31; };
struct D_BFu32i_BFu31ll { double v1; unsigned int v2:32; unsigned long long v3:31; };
struct D_BFu32i_BFu32i { double v1; unsigned int v2:32; unsigned int v3:32; };
struct D_BFu32i_BFu32ll { double v1; unsigned int v2:32; unsigned long long v3:32; };
struct D_BFu32i_BFu33 { double v1; unsigned int v2:32; unsigned long long v3:33; };
struct D_BFu32i_BFu7c { double v1; unsigned int v2:32; unsigned char v3:7; };
struct D_BFu32i_BFu7i { double v1; unsigned int v2:32; unsigned int v3:7; };
struct D_BFu32i_BFu7ll { double v1; unsigned int v2:32; unsigned long long v3:7; };
struct D_BFu32i_BFu7s { double v1; unsigned int v2:32; unsigned short v3:7; };
struct D_BFu32i_BFu8c { double v1; unsigned int v2:32; unsigned char v3:8; };
struct D_BFu32i_BFu8i { double v1; unsigned int v2:32; unsigned int v3:8; };
struct D_BFu32i_BFu8ll { double v1; unsigned int v2:32; unsigned long long v3:8; };
struct D_BFu32i_BFu8s { double v1; unsigned int v2:32; unsigned short v3:8; };
struct D_BFu32i_BFu9i { double v1; unsigned int v2:32; unsigned int v3:9; };
struct D_BFu32i_BFu9ll { double v1; unsigned int v2:32; unsigned long long v3:9; };
struct D_BFu32i_BFu9s { double v1; unsigned int v2:32; unsigned short v3:9; };
struct D_BFu32i_C { double v1; unsigned int v2:32; char v3; };
struct D_BFu32i_D { double v1; unsigned int v2:32; double v3; };
struct D_BFu32i_F { double v1; unsigned int v2:32; float v3; };
struct D_BFu32i_I { double v1; unsigned int v2:32; int v3; };
struct D_BFu32i_Ip { double v1; unsigned int v2:32; int * v3; };
struct D_BFu32i_L { double v1; unsigned int v2:32; long long v3; };
struct D_BFu32i_S { double v1; unsigned int v2:32; short v3; };
struct D_BFu32i_Uc { double v1; unsigned int v2:32; unsigned char v3; };
struct D_BFu32i_Ui { double v1; unsigned int v2:32; unsigned int v3; };
struct D_BFu32i_Ul { double v1; unsigned int v2:32; unsigned long long v3; };
struct D_BFu32i_Us { double v1; unsigned int v2:32; unsigned short v3; };
struct D_BFu32i_Vp { double v1; unsigned int v2:32; void * v3; };
struct D_BFu32ll { double v1; unsigned long long v2:32; };
struct D_BFu32ll_BFu15i { double v1; unsigned long long v2:32; unsigned int v3:15; };
struct D_BFu32ll_BFu15ll { double v1; unsigned long long v2:32; unsigned long long v3:15; };
struct D_BFu32ll_BFu15s { double v1; unsigned long long v2:32; unsigned short v3:15; };
struct D_BFu32ll_BFu16i { double v1; unsigned long long v2:32; unsigned int v3:16; };
struct D_BFu32ll_BFu16ll { double v1; unsigned long long v2:32; unsigned long long v3:16; };
struct D_BFu32ll_BFu16s { double v1; unsigned long long v2:32; unsigned short v3:16; };
struct D_BFu32ll_BFu17i { double v1; unsigned long long v2:32; unsigned int v3:17; };
struct D_BFu32ll_BFu17ll { double v1; unsigned long long v2:32; unsigned long long v3:17; };
struct D_BFu32ll_BFu1c { double v1; unsigned long long v2:32; unsigned char v3:1; };
struct D_BFu32ll_BFu1i { double v1; unsigned long long v2:32; unsigned int v3:1; };
struct D_BFu32ll_BFu1ll { double v1; unsigned long long v2:32; unsigned long long v3:1; };
struct D_BFu32ll_BFu1s { double v1; unsigned long long v2:32; unsigned short v3:1; };
struct D_BFu32ll_BFu31i { double v1; unsigned long long v2:32; unsigned int v3:31; };
struct D_BFu32ll_BFu31ll { double v1; unsigned long long v2:32; unsigned long long v3:31; };
struct D_BFu32ll_BFu32i { double v1; unsigned long long v2:32; unsigned int v3:32; };
struct D_BFu32ll_BFu32ll { double v1; unsigned long long v2:32; unsigned long long v3:32; };
struct D_BFu32ll_BFu33 { double v1; unsigned long long v2:32; unsigned long long v3:33; };
struct D_BFu32ll_BFu7c { double v1; unsigned long long v2:32; unsigned char v3:7; };
struct D_BFu32ll_BFu7i { double v1; unsigned long long v2:32; unsigned int v3:7; };
struct D_BFu32ll_BFu7ll { double v1; unsigned long long v2:32; unsigned long long v3:7; };
struct D_BFu32ll_BFu7s { double v1; unsigned long long v2:32; unsigned short v3:7; };
struct D_BFu32ll_BFu8c { double v1; unsigned long long v2:32; unsigned char v3:8; };
struct D_BFu32ll_BFu8i { double v1; unsigned long long v2:32; unsigned int v3:8; };
struct D_BFu32ll_BFu8ll { double v1; unsigned long long v2:32; unsigned long long v3:8; };
struct D_BFu32ll_BFu8s { double v1; unsigned long long v2:32; unsigned short v3:8; };
struct D_BFu32ll_BFu9i { double v1; unsigned long long v2:32; unsigned int v3:9; };
struct D_BFu32ll_BFu9ll { double v1; unsigned long long v2:32; unsigned long long v3:9; };
struct D_BFu32ll_BFu9s { double v1; unsigned long long v2:32; unsigned short v3:9; };
struct D_BFu32ll_C { double v1; unsigned long long v2:32; char v3; };
struct D_BFu32ll_D { double v1; unsigned long long v2:32; double v3; };
struct D_BFu32ll_F { double v1; unsigned long long v2:32; float v3; };
struct D_BFu32ll_I { double v1; unsigned long long v2:32; int v3; };
struct D_BFu32ll_Ip { double v1; unsigned long long v2:32; int * v3; };
struct D_BFu32ll_L { double v1; unsigned long long v2:32; long long v3; };
struct D_BFu32ll_S { double v1; unsigned long long v2:32; short v3; };
struct D_BFu32ll_Uc { double v1; unsigned long long v2:32; unsigned char v3; };
struct D_BFu32ll_Ui { double v1; unsigned long long v2:32; unsigned int v3; };
struct D_BFu32ll_Ul { double v1; unsigned long long v2:32; unsigned long long v3; };
struct D_BFu32ll_Us { double v1; unsigned long long v2:32; unsigned short v3; };
struct D_BFu32ll_Vp { double v1; unsigned long long v2:32; void * v3; };
struct D_BFu33 { double v1; unsigned long long v2:33; };
struct D_BFu33_BFu15i { double v1; unsigned long long v2:33; unsigned int v3:15; };
struct D_BFu33_BFu15ll { double v1; unsigned long long v2:33; unsigned long long v3:15; };
struct D_BFu33_BFu15s { double v1; unsigned long long v2:33; unsigned short v3:15; };
struct D_BFu33_BFu16i { double v1; unsigned long long v2:33; unsigned int v3:16; };
struct D_BFu33_BFu16ll { double v1; unsigned long long v2:33; unsigned long long v3:16; };
struct D_BFu33_BFu16s { double v1; unsigned long long v2:33; unsigned short v3:16; };
struct D_BFu33_BFu17i { double v1; unsigned long long v2:33; unsigned int v3:17; };
struct D_BFu33_BFu17ll { double v1; unsigned long long v2:33; unsigned long long v3:17; };
struct D_BFu33_BFu1c { double v1; unsigned long long v2:33; unsigned char v3:1; };
struct D_BFu33_BFu1i { double v1; unsigned long long v2:33; unsigned int v3:1; };
struct D_BFu33_BFu1ll { double v1; unsigned long long v2:33; unsigned long long v3:1; };
struct D_BFu33_BFu1s { double v1; unsigned long long v2:33; unsigned short v3:1; };
struct D_BFu33_BFu31i { double v1; unsigned long long v2:33; unsigned int v3:31; };
struct D_BFu33_BFu31ll { double v1; unsigned long long v2:33; unsigned long long v3:31; };
struct D_BFu33_BFu32i { double v1; unsigned long long v2:33; unsigned int v3:32; };
struct D_BFu33_BFu32ll { double v1; unsigned long long v2:33; unsigned long long v3:32; };
struct D_BFu33_BFu33 { double v1; unsigned long long v2:33; unsigned long long v3:33; };
struct D_BFu33_BFu7c { double v1; unsigned long long v2:33; unsigned char v3:7; };
struct D_BFu33_BFu7i { double v1; unsigned long long v2:33; unsigned int v3:7; };
struct D_BFu33_BFu7ll { double v1; unsigned long long v2:33; unsigned long long v3:7; };
struct D_BFu33_BFu7s { double v1; unsigned long long v2:33; unsigned short v3:7; };
struct D_BFu33_BFu8c { double v1; unsigned long long v2:33; unsigned char v3:8; };
struct D_BFu33_BFu8i { double v1; unsigned long long v2:33; unsigned int v3:8; };
struct D_BFu33_BFu8ll { double v1; unsigned long long v2:33; unsigned long long v3:8; };
struct D_BFu33_BFu8s { double v1; unsigned long long v2:33; unsigned short v3:8; };
struct D_BFu33_BFu9i { double v1; unsigned long long v2:33; unsigned int v3:9; };
struct D_BFu33_BFu9ll { double v1; unsigned long long v2:33; unsigned long long v3:9; };
struct D_BFu33_BFu9s { double v1; unsigned long long v2:33; unsigned short v3:9; };
struct D_BFu33_C { double v1; unsigned long long v2:33; char v3; };
struct D_BFu33_D { double v1; unsigned long long v2:33; double v3; };
struct D_BFu33_F { double v1; unsigned long long v2:33; float v3; };
struct D_BFu33_I { double v1; unsigned long long v2:33; int v3; };
struct D_BFu33_Ip { double v1; unsigned long long v2:33; int * v3; };
struct D_BFu33_L { double v1; unsigned long long v2:33; long long v3; };
struct D_BFu33_S { double v1; unsigned long long v2:33; short v3; };
struct D_BFu33_Uc { double v1; unsigned long long v2:33; unsigned char v3; };
struct D_BFu33_Ui { double v1; unsigned long long v2:33; unsigned int v3; };
struct D_BFu33_Ul { double v1; unsigned long long v2:33; unsigned long long v3; };
struct D_BFu33_Us { double v1; unsigned long long v2:33; unsigned short v3; };
struct D_BFu33_Vp { double v1; unsigned long long v2:33; void * v3; };
struct D_BFu7c { double v1; unsigned char v2:7; };
struct D_BFu7c_BFu15i { double v1; unsigned char v2:7; unsigned int v3:15; };
struct D_BFu7c_BFu15ll { double v1; unsigned char v2:7; unsigned long long v3:15; };
struct D_BFu7c_BFu15s { double v1; unsigned char v2:7; unsigned short v3:15; };
struct D_BFu7c_BFu16i { double v1; unsigned char v2:7; unsigned int v3:16; };
struct D_BFu7c_BFu16ll { double v1; unsigned char v2:7; unsigned long long v3:16; };
struct D_BFu7c_BFu16s { double v1; unsigned char v2:7; unsigned short v3:16; };
struct D_BFu7c_BFu17i { double v1; unsigned char v2:7; unsigned int v3:17; };
struct D_BFu7c_BFu17ll { double v1; unsigned char v2:7; unsigned long long v3:17; };
struct D_BFu7c_BFu1c { double v1; unsigned char v2:7; unsigned char v3:1; };
struct D_BFu7c_BFu1i { double v1; unsigned char v2:7; unsigned int v3:1; };
struct D_BFu7c_BFu1ll { double v1; unsigned char v2:7; unsigned long long v3:1; };
struct D_BFu7c_BFu1s { double v1; unsigned char v2:7; unsigned short v3:1; };
struct D_BFu7c_BFu31i { double v1; unsigned char v2:7; unsigned int v3:31; };
struct D_BFu7c_BFu31ll { double v1; unsigned char v2:7; unsigned long long v3:31; };
struct D_BFu7c_BFu32i { double v1; unsigned char v2:7; unsigned int v3:32; };
struct D_BFu7c_BFu32ll { double v1; unsigned char v2:7; unsigned long long v3:32; };
struct D_BFu7c_BFu33 { double v1; unsigned char v2:7; unsigned long long v3:33; };
struct D_BFu7c_BFu7c { double v1; unsigned char v2:7; unsigned char v3:7; };
struct D_BFu7c_BFu7i { double v1; unsigned char v2:7; unsigned int v3:7; };
struct D_BFu7c_BFu7ll { double v1; unsigned char v2:7; unsigned long long v3:7; };
struct D_BFu7c_BFu7s { double v1; unsigned char v2:7; unsigned short v3:7; };
struct D_BFu7c_BFu8c { double v1; unsigned char v2:7; unsigned char v3:8; };
struct D_BFu7c_BFu8i { double v1; unsigned char v2:7; unsigned int v3:8; };
struct D_BFu7c_BFu8ll { double v1; unsigned char v2:7; unsigned long long v3:8; };
struct D_BFu7c_BFu8s { double v1; unsigned char v2:7; unsigned short v3:8; };
struct D_BFu7c_BFu9i { double v1; unsigned char v2:7; unsigned int v3:9; };
struct D_BFu7c_BFu9ll { double v1; unsigned char v2:7; unsigned long long v3:9; };
struct D_BFu7c_BFu9s { double v1; unsigned char v2:7; unsigned short v3:9; };
struct D_BFu7c_C { double v1; unsigned char v2:7; char v3; };
struct D_BFu7c_D { double v1; unsigned char v2:7; double v3; };
struct D_BFu7c_F { double v1; unsigned char v2:7; float v3; };
struct D_BFu7c_I { double v1; unsigned char v2:7; int v3; };
struct D_BFu7c_Ip { double v1; unsigned char v2:7; int * v3; };
struct D_BFu7c_L { double v1; unsigned char v2:7; long long v3; };
struct D_BFu7c_S { double v1; unsigned char v2:7; short v3; };
struct D_BFu7c_Uc { double v1; unsigned char v2:7; unsigned char v3; };
struct D_BFu7c_Ui { double v1; unsigned char v2:7; unsigned int v3; };
struct D_BFu7c_Ul { double v1; unsigned char v2:7; unsigned long long v3; };
struct D_BFu7c_Us { double v1; unsigned char v2:7; unsigned short v3; };
struct D_BFu7c_Vp { double v1; unsigned char v2:7; void * v3; };
struct D_BFu7i { double v1; unsigned int v2:7; };
struct D_BFu7i_BFu15i { double v1; unsigned int v2:7; unsigned int v3:15; };
struct D_BFu7i_BFu15ll { double v1; unsigned int v2:7; unsigned long long v3:15; };
struct D_BFu7i_BFu15s { double v1; unsigned int v2:7; unsigned short v3:15; };
struct D_BFu7i_BFu16i { double v1; unsigned int v2:7; unsigned int v3:16; };
struct D_BFu7i_BFu16ll { double v1; unsigned int v2:7; unsigned long long v3:16; };
struct D_BFu7i_BFu16s { double v1; unsigned int v2:7; unsigned short v3:16; };
struct D_BFu7i_BFu17i { double v1; unsigned int v2:7; unsigned int v3:17; };
struct D_BFu7i_BFu17ll { double v1; unsigned int v2:7; unsigned long long v3:17; };
struct D_BFu7i_BFu1c { double v1; unsigned int v2:7; unsigned char v3:1; };
struct D_BFu7i_BFu1i { double v1; unsigned int v2:7; unsigned int v3:1; };
struct D_BFu7i_BFu1ll { double v1; unsigned int v2:7; unsigned long long v3:1; };
struct D_BFu7i_BFu1s { double v1; unsigned int v2:7; unsigned short v3:1; };
struct D_BFu7i_BFu31i { double v1; unsigned int v2:7; unsigned int v3:31; };
struct D_BFu7i_BFu31ll { double v1; unsigned int v2:7; unsigned long long v3:31; };
struct D_BFu7i_BFu32i { double v1; unsigned int v2:7; unsigned int v3:32; };
struct D_BFu7i_BFu32ll { double v1; unsigned int v2:7; unsigned long long v3:32; };
struct D_BFu7i_BFu33 { double v1; unsigned int v2:7; unsigned long long v3:33; };
struct D_BFu7i_BFu7c { double v1; unsigned int v2:7; unsigned char v3:7; };
struct D_BFu7i_BFu7i { double v1; unsigned int v2:7; unsigned int v3:7; };
struct D_BFu7i_BFu7ll { double v1; unsigned int v2:7; unsigned long long v3:7; };
struct D_BFu7i_BFu7s { double v1; unsigned int v2:7; unsigned short v3:7; };
struct D_BFu7i_BFu8c { double v1; unsigned int v2:7; unsigned char v3:8; };
struct D_BFu7i_BFu8i { double v1; unsigned int v2:7; unsigned int v3:8; };
struct D_BFu7i_BFu8ll { double v1; unsigned int v2:7; unsigned long long v3:8; };
struct D_BFu7i_BFu8s { double v1; unsigned int v2:7; unsigned short v3:8; };
struct D_BFu7i_BFu9i { double v1; unsigned int v2:7; unsigned int v3:9; };
struct D_BFu7i_BFu9ll { double v1; unsigned int v2:7; unsigned long long v3:9; };
struct D_BFu7i_BFu9s { double v1; unsigned int v2:7; unsigned short v3:9; };
struct D_BFu7i_C { double v1; unsigned int v2:7; char v3; };
struct D_BFu7i_D { double v1; unsigned int v2:7; double v3; };
struct D_BFu7i_F { double v1; unsigned int v2:7; float v3; };
struct D_BFu7i_I { double v1; unsigned int v2:7; int v3; };
struct D_BFu7i_Ip { double v1; unsigned int v2:7; int * v3; };
struct D_BFu7i_L { double v1; unsigned int v2:7; long long v3; };
struct D_BFu7i_S { double v1; unsigned int v2:7; short v3; };
struct D_BFu7i_Uc { double v1; unsigned int v2:7; unsigned char v3; };
struct D_BFu7i_Ui { double v1; unsigned int v2:7; unsigned int v3; };
struct D_BFu7i_Ul { double v1; unsigned int v2:7; unsigned long long v3; };
struct D_BFu7i_Us { double v1; unsigned int v2:7; unsigned short v3; };
struct D_BFu7i_Vp { double v1; unsigned int v2:7; void * v3; };
struct D_BFu7ll { double v1; unsigned long long v2:7; };
struct D_BFu7ll_BFu15i { double v1; unsigned long long v2:7; unsigned int v3:15; };
struct D_BFu7ll_BFu15ll { double v1; unsigned long long v2:7; unsigned long long v3:15; };
struct D_BFu7ll_BFu15s { double v1; unsigned long long v2:7; unsigned short v3:15; };
struct D_BFu7ll_BFu16i { double v1; unsigned long long v2:7; unsigned int v3:16; };
struct D_BFu7ll_BFu16ll { double v1; unsigned long long v2:7; unsigned long long v3:16; };
struct D_BFu7ll_BFu16s { double v1; unsigned long long v2:7; unsigned short v3:16; };
struct D_BFu7ll_BFu17i { double v1; unsigned long long v2:7; unsigned int v3:17; };
struct D_BFu7ll_BFu17ll { double v1; unsigned long long v2:7; unsigned long long v3:17; };
struct D_BFu7ll_BFu1c { double v1; unsigned long long v2:7; unsigned char v3:1; };
struct D_BFu7ll_BFu1i { double v1; unsigned long long v2:7; unsigned int v3:1; };
struct D_BFu7ll_BFu1ll { double v1; unsigned long long v2:7; unsigned long long v3:1; };
struct D_BFu7ll_BFu1s { double v1; unsigned long long v2:7; unsigned short v3:1; };
struct D_BFu7ll_BFu31i { double v1; unsigned long long v2:7; unsigned int v3:31; };
struct D_BFu7ll_BFu31ll { double v1; unsigned long long v2:7; unsigned long long v3:31; };
struct D_BFu7ll_BFu32i { double v1; unsigned long long v2:7; unsigned int v3:32; };
struct D_BFu7ll_BFu32ll { double v1; unsigned long long v2:7; unsigned long long v3:32; };
struct D_BFu7ll_BFu33 { double v1; unsigned long long v2:7; unsigned long long v3:33; };
struct D_BFu7ll_BFu7c { double v1; unsigned long long v2:7; unsigned char v3:7; };
struct D_BFu7ll_BFu7i { double v1; unsigned long long v2:7; unsigned int v3:7; };
struct D_BFu7ll_BFu7ll { double v1; unsigned long long v2:7; unsigned long long v3:7; };
struct D_BFu7ll_BFu7s { double v1; unsigned long long v2:7; unsigned short v3:7; };
struct D_BFu7ll_BFu8c { double v1; unsigned long long v2:7; unsigned char v3:8; };
struct D_BFu7ll_BFu8i { double v1; unsigned long long v2:7; unsigned int v3:8; };
struct D_BFu7ll_BFu8ll { double v1; unsigned long long v2:7; unsigned long long v3:8; };
struct D_BFu7ll_BFu8s { double v1; unsigned long long v2:7; unsigned short v3:8; };
struct D_BFu7ll_BFu9i { double v1; unsigned long long v2:7; unsigned int v3:9; };
struct D_BFu7ll_BFu9ll { double v1; unsigned long long v2:7; unsigned long long v3:9; };
struct D_BFu7ll_BFu9s { double v1; unsigned long long v2:7; unsigned short v3:9; };
struct D_BFu7ll_C { double v1; unsigned long long v2:7; char v3; };
struct D_BFu7ll_D { double v1; unsigned long long v2:7; double v3; };
struct D_BFu7ll_F { double v1; unsigned long long v2:7; float v3; };
struct D_BFu7ll_I { double v1; unsigned long long v2:7; int v3; };
struct D_BFu7ll_Ip { double v1; unsigned long long v2:7; int * v3; };
struct D_BFu7ll_L { double v1; unsigned long long v2:7; long long v3; };
struct D_BFu7ll_S { double v1; unsigned long long v2:7; short v3; };
struct D_BFu7ll_Uc { double v1; unsigned long long v2:7; unsigned char v3; };
struct D_BFu7ll_Ui { double v1; unsigned long long v2:7; unsigned int v3; };
struct D_BFu7ll_Ul { double v1; unsigned long long v2:7; unsigned long long v3; };
struct D_BFu7ll_Us { double v1; unsigned long long v2:7; unsigned short v3; };
struct D_BFu7ll_Vp { double v1; unsigned long long v2:7; void * v3; };
struct D_BFu7s { double v1; unsigned short v2:7; };
struct D_BFu7s_BFu15i { double v1; unsigned short v2:7; unsigned int v3:15; };
struct D_BFu7s_BFu15ll { double v1; unsigned short v2:7; unsigned long long v3:15; };
struct D_BFu7s_BFu15s { double v1; unsigned short v2:7; unsigned short v3:15; };
struct D_BFu7s_BFu16i { double v1; unsigned short v2:7; unsigned int v3:16; };
struct D_BFu7s_BFu16ll { double v1; unsigned short v2:7; unsigned long long v3:16; };
struct D_BFu7s_BFu16s { double v1; unsigned short v2:7; unsigned short v3:16; };
struct D_BFu7s_BFu17i { double v1; unsigned short v2:7; unsigned int v3:17; };
struct D_BFu7s_BFu17ll { double v1; unsigned short v2:7; unsigned long long v3:17; };
struct D_BFu7s_BFu1c { double v1; unsigned short v2:7; unsigned char v3:1; };
struct D_BFu7s_BFu1i { double v1; unsigned short v2:7; unsigned int v3:1; };
struct D_BFu7s_BFu1ll { double v1; unsigned short v2:7; unsigned long long v3:1; };
struct D_BFu7s_BFu1s { double v1; unsigned short v2:7; unsigned short v3:1; };
struct D_BFu7s_BFu31i { double v1; unsigned short v2:7; unsigned int v3:31; };
struct D_BFu7s_BFu31ll { double v1; unsigned short v2:7; unsigned long long v3:31; };
struct D_BFu7s_BFu32i { double v1; unsigned short v2:7; unsigned int v3:32; };
struct D_BFu7s_BFu32ll { double v1; unsigned short v2:7; unsigned long long v3:32; };
struct D_BFu7s_BFu33 { double v1; unsigned short v2:7; unsigned long long v3:33; };
struct D_BFu7s_BFu7c { double v1; unsigned short v2:7; unsigned char v3:7; };
struct D_BFu7s_BFu7i { double v1; unsigned short v2:7; unsigned int v3:7; };
struct D_BFu7s_BFu7ll { double v1; unsigned short v2:7; unsigned long long v3:7; };
struct D_BFu7s_BFu7s { double v1; unsigned short v2:7; unsigned short v3:7; };
struct D_BFu7s_BFu8c { double v1; unsigned short v2:7; unsigned char v3:8; };
struct D_BFu7s_BFu8i { double v1; unsigned short v2:7; unsigned int v3:8; };
struct D_BFu7s_BFu8ll { double v1; unsigned short v2:7; unsigned long long v3:8; };
struct D_BFu7s_BFu8s { double v1; unsigned short v2:7; unsigned short v3:8; };
struct D_BFu7s_BFu9i { double v1; unsigned short v2:7; unsigned int v3:9; };
struct D_BFu7s_BFu9ll { double v1; unsigned short v2:7; unsigned long long v3:9; };
struct D_BFu7s_BFu9s { double v1; unsigned short v2:7; unsigned short v3:9; };
struct D_BFu7s_C { double v1; unsigned short v2:7; char v3; };
struct D_BFu7s_D { double v1; unsigned short v2:7; double v3; };
struct D_BFu7s_F { double v1; unsigned short v2:7; float v3; };
struct D_BFu7s_I { double v1; unsigned short v2:7; int v3; };
struct D_BFu7s_Ip { double v1; unsigned short v2:7; int * v3; };
struct D_BFu7s_L { double v1; unsigned short v2:7; long long v3; };
struct D_BFu7s_S { double v1; unsigned short v2:7; short v3; };
struct D_BFu7s_Uc { double v1; unsigned short v2:7; unsigned char v3; };
struct D_BFu7s_Ui { double v1; unsigned short v2:7; unsigned int v3; };
struct D_BFu7s_Ul { double v1; unsigned short v2:7; unsigned long long v3; };
struct D_BFu7s_Us { double v1; unsigned short v2:7; unsigned short v3; };
struct D_BFu7s_Vp { double v1; unsigned short v2:7; void * v3; };
struct D_BFu8c { double v1; unsigned char v2:8; };
struct D_BFu8c_BFu15i { double v1; unsigned char v2:8; unsigned int v3:15; };
struct D_BFu8c_BFu15ll { double v1; unsigned char v2:8; unsigned long long v3:15; };
struct D_BFu8c_BFu15s { double v1; unsigned char v2:8; unsigned short v3:15; };
struct D_BFu8c_BFu16i { double v1; unsigned char v2:8; unsigned int v3:16; };
struct D_BFu8c_BFu16ll { double v1; unsigned char v2:8; unsigned long long v3:16; };
struct D_BFu8c_BFu16s { double v1; unsigned char v2:8; unsigned short v3:16; };
struct D_BFu8c_BFu17i { double v1; unsigned char v2:8; unsigned int v3:17; };
struct D_BFu8c_BFu17ll { double v1; unsigned char v2:8; unsigned long long v3:17; };
struct D_BFu8c_BFu1c { double v1; unsigned char v2:8; unsigned char v3:1; };
struct D_BFu8c_BFu1i { double v1; unsigned char v2:8; unsigned int v3:1; };
struct D_BFu8c_BFu1ll { double v1; unsigned char v2:8; unsigned long long v3:1; };
struct D_BFu8c_BFu1s { double v1; unsigned char v2:8; unsigned short v3:1; };
struct D_BFu8c_BFu31i { double v1; unsigned char v2:8; unsigned int v3:31; };
struct D_BFu8c_BFu31ll { double v1; unsigned char v2:8; unsigned long long v3:31; };
struct D_BFu8c_BFu32i { double v1; unsigned char v2:8; unsigned int v3:32; };
struct D_BFu8c_BFu32ll { double v1; unsigned char v2:8; unsigned long long v3:32; };
struct D_BFu8c_BFu33 { double v1; unsigned char v2:8; unsigned long long v3:33; };
struct D_BFu8c_BFu7c { double v1; unsigned char v2:8; unsigned char v3:7; };
struct D_BFu8c_BFu7i { double v1; unsigned char v2:8; unsigned int v3:7; };
struct D_BFu8c_BFu7ll { double v1; unsigned char v2:8; unsigned long long v3:7; };
struct D_BFu8c_BFu7s { double v1; unsigned char v2:8; unsigned short v3:7; };
struct D_BFu8c_BFu8c { double v1; unsigned char v2:8; unsigned char v3:8; };
struct D_BFu8c_BFu8i { double v1; unsigned char v2:8; unsigned int v3:8; };
struct D_BFu8c_BFu8ll { double v1; unsigned char v2:8; unsigned long long v3:8; };
struct D_BFu8c_BFu8s { double v1; unsigned char v2:8; unsigned short v3:8; };
struct D_BFu8c_BFu9i { double v1; unsigned char v2:8; unsigned int v3:9; };
struct D_BFu8c_BFu9ll { double v1; unsigned char v2:8; unsigned long long v3:9; };
struct D_BFu8c_BFu9s { double v1; unsigned char v2:8; unsigned short v3:9; };
struct D_BFu8c_C { double v1; unsigned char v2:8; char v3; };
struct D_BFu8c_D { double v1; unsigned char v2:8; double v3; };
struct D_BFu8c_F { double v1; unsigned char v2:8; float v3; };
struct D_BFu8c_I { double v1; unsigned char v2:8; int v3; };
struct D_BFu8c_Ip { double v1; unsigned char v2:8; int * v3; };
struct D_BFu8c_L { double v1; unsigned char v2:8; long long v3; };
struct D_BFu8c_S { double v1; unsigned char v2:8; short v3; };
struct D_BFu8c_Uc { double v1; unsigned char v2:8; unsigned char v3; };
struct D_BFu8c_Ui { double v1; unsigned char v2:8; unsigned int v3; };
struct D_BFu8c_Ul { double v1; unsigned char v2:8; unsigned long long v3; };
struct D_BFu8c_Us { double v1; unsigned char v2:8; unsigned short v3; };
struct D_BFu8c_Vp { double v1; unsigned char v2:8; void * v3; };
struct D_BFu8i { double v1; unsigned int v2:8; };
struct D_BFu8i_BFu15i { double v1; unsigned int v2:8; unsigned int v3:15; };
struct D_BFu8i_BFu15ll { double v1; unsigned int v2:8; unsigned long long v3:15; };
struct D_BFu8i_BFu15s { double v1; unsigned int v2:8; unsigned short v3:15; };
struct D_BFu8i_BFu16i { double v1; unsigned int v2:8; unsigned int v3:16; };
struct D_BFu8i_BFu16ll { double v1; unsigned int v2:8; unsigned long long v3:16; };
struct D_BFu8i_BFu16s { double v1; unsigned int v2:8; unsigned short v3:16; };
struct D_BFu8i_BFu17i { double v1; unsigned int v2:8; unsigned int v3:17; };
struct D_BFu8i_BFu17ll { double v1; unsigned int v2:8; unsigned long long v3:17; };
struct D_BFu8i_BFu1c { double v1; unsigned int v2:8; unsigned char v3:1; };
struct D_BFu8i_BFu1i { double v1; unsigned int v2:8; unsigned int v3:1; };
struct D_BFu8i_BFu1ll { double v1; unsigned int v2:8; unsigned long long v3:1; };
struct D_BFu8i_BFu1s { double v1; unsigned int v2:8; unsigned short v3:1; };
struct D_BFu8i_BFu31i { double v1; unsigned int v2:8; unsigned int v3:31; };
struct D_BFu8i_BFu31ll { double v1; unsigned int v2:8; unsigned long long v3:31; };
struct D_BFu8i_BFu32i { double v1; unsigned int v2:8; unsigned int v3:32; };
struct D_BFu8i_BFu32ll { double v1; unsigned int v2:8; unsigned long long v3:32; };
struct D_BFu8i_BFu33 { double v1; unsigned int v2:8; unsigned long long v3:33; };
struct D_BFu8i_BFu7c { double v1; unsigned int v2:8; unsigned char v3:7; };
struct D_BFu8i_BFu7i { double v1; unsigned int v2:8; unsigned int v3:7; };
struct D_BFu8i_BFu7ll { double v1; unsigned int v2:8; unsigned long long v3:7; };
struct D_BFu8i_BFu7s { double v1; unsigned int v2:8; unsigned short v3:7; };
struct D_BFu8i_BFu8c { double v1; unsigned int v2:8; unsigned char v3:8; };
struct D_BFu8i_BFu8i { double v1; unsigned int v2:8; unsigned int v3:8; };
struct D_BFu8i_BFu8ll { double v1; unsigned int v2:8; unsigned long long v3:8; };
struct D_BFu8i_BFu8s { double v1; unsigned int v2:8; unsigned short v3:8; };
struct D_BFu8i_BFu9i { double v1; unsigned int v2:8; unsigned int v3:9; };
struct D_BFu8i_BFu9ll { double v1; unsigned int v2:8; unsigned long long v3:9; };
struct D_BFu8i_BFu9s { double v1; unsigned int v2:8; unsigned short v3:9; };
struct D_BFu8i_C { double v1; unsigned int v2:8; char v3; };
struct D_BFu8i_D { double v1; unsigned int v2:8; double v3; };
struct D_BFu8i_F { double v1; unsigned int v2:8; float v3; };
struct D_BFu8i_I { double v1; unsigned int v2:8; int v3; };
struct D_BFu8i_Ip { double v1; unsigned int v2:8; int * v3; };
struct D_BFu8i_L { double v1; unsigned int v2:8; long long v3; };
struct D_BFu8i_S { double v1; unsigned int v2:8; short v3; };
struct D_BFu8i_Uc { double v1; unsigned int v2:8; unsigned char v3; };
struct D_BFu8i_Ui { double v1; unsigned int v2:8; unsigned int v3; };
struct D_BFu8i_Ul { double v1; unsigned int v2:8; unsigned long long v3; };
struct D_BFu8i_Us { double v1; unsigned int v2:8; unsigned short v3; };
struct D_BFu8i_Vp { double v1; unsigned int v2:8; void * v3; };
struct D_BFu8ll { double v1; unsigned long long v2:8; };
struct D_BFu8ll_BFu15i { double v1; unsigned long long v2:8; unsigned int v3:15; };
struct D_BFu8ll_BFu15ll { double v1; unsigned long long v2:8; unsigned long long v3:15; };
struct D_BFu8ll_BFu15s { double v1; unsigned long long v2:8; unsigned short v3:15; };
struct D_BFu8ll_BFu16i { double v1; unsigned long long v2:8; unsigned int v3:16; };
struct D_BFu8ll_BFu16ll { double v1; unsigned long long v2:8; unsigned long long v3:16; };
struct D_BFu8ll_BFu16s { double v1; unsigned long long v2:8; unsigned short v3:16; };
struct D_BFu8ll_BFu17i { double v1; unsigned long long v2:8; unsigned int v3:17; };
struct D_BFu8ll_BFu17ll { double v1; unsigned long long v2:8; unsigned long long v3:17; };
struct D_BFu8ll_BFu1c { double v1; unsigned long long v2:8; unsigned char v3:1; };
struct D_BFu8ll_BFu1i { double v1; unsigned long long v2:8; unsigned int v3:1; };
struct D_BFu8ll_BFu1ll { double v1; unsigned long long v2:8; unsigned long long v3:1; };
struct D_BFu8ll_BFu1s { double v1; unsigned long long v2:8; unsigned short v3:1; };
struct D_BFu8ll_BFu31i { double v1; unsigned long long v2:8; unsigned int v3:31; };
struct D_BFu8ll_BFu31ll { double v1; unsigned long long v2:8; unsigned long long v3:31; };
struct D_BFu8ll_BFu32i { double v1; unsigned long long v2:8; unsigned int v3:32; };
struct D_BFu8ll_BFu32ll { double v1; unsigned long long v2:8; unsigned long long v3:32; };
struct D_BFu8ll_BFu33 { double v1; unsigned long long v2:8; unsigned long long v3:33; };
struct D_BFu8ll_BFu7c { double v1; unsigned long long v2:8; unsigned char v3:7; };
struct D_BFu8ll_BFu7i { double v1; unsigned long long v2:8; unsigned int v3:7; };
struct D_BFu8ll_BFu7ll { double v1; unsigned long long v2:8; unsigned long long v3:7; };
struct D_BFu8ll_BFu7s { double v1; unsigned long long v2:8; unsigned short v3:7; };
struct D_BFu8ll_BFu8c { double v1; unsigned long long v2:8; unsigned char v3:8; };
struct D_BFu8ll_BFu8i { double v1; unsigned long long v2:8; unsigned int v3:8; };
struct D_BFu8ll_BFu8ll { double v1; unsigned long long v2:8; unsigned long long v3:8; };
struct D_BFu8ll_BFu8s { double v1; unsigned long long v2:8; unsigned short v3:8; };
struct D_BFu8ll_BFu9i { double v1; unsigned long long v2:8; unsigned int v3:9; };
struct D_BFu8ll_BFu9ll { double v1; unsigned long long v2:8; unsigned long long v3:9; };
struct D_BFu8ll_BFu9s { double v1; unsigned long long v2:8; unsigned short v3:9; };
struct D_BFu8ll_C { double v1; unsigned long long v2:8; char v3; };
struct D_BFu8ll_D { double v1; unsigned long long v2:8; double v3; };
struct D_BFu8ll_F { double v1; unsigned long long v2:8; float v3; };
struct D_BFu8ll_I { double v1; unsigned long long v2:8; int v3; };
struct D_BFu8ll_Ip { double v1; unsigned long long v2:8; int * v3; };
struct D_BFu8ll_L { double v1; unsigned long long v2:8; long long v3; };
struct D_BFu8ll_S { double v1; unsigned long long v2:8; short v3; };
struct D_BFu8ll_Uc { double v1; unsigned long long v2:8; unsigned char v3; };
struct D_BFu8ll_Ui { double v1; unsigned long long v2:8; unsigned int v3; };
struct D_BFu8ll_Ul { double v1; unsigned long long v2:8; unsigned long long v3; };
struct D_BFu8ll_Us { double v1; unsigned long long v2:8; unsigned short v3; };
struct D_BFu8ll_Vp { double v1; unsigned long long v2:8; void * v3; };
struct D_BFu8s { double v1; unsigned short v2:8; };
struct D_BFu8s_BFu15i { double v1; unsigned short v2:8; unsigned int v3:15; };
struct D_BFu8s_BFu15ll { double v1; unsigned short v2:8; unsigned long long v3:15; };
struct D_BFu8s_BFu15s { double v1; unsigned short v2:8; unsigned short v3:15; };
struct D_BFu8s_BFu16i { double v1; unsigned short v2:8; unsigned int v3:16; };
struct D_BFu8s_BFu16ll { double v1; unsigned short v2:8; unsigned long long v3:16; };
struct D_BFu8s_BFu16s { double v1; unsigned short v2:8; unsigned short v3:16; };
struct D_BFu8s_BFu17i { double v1; unsigned short v2:8; unsigned int v3:17; };
struct D_BFu8s_BFu17ll { double v1; unsigned short v2:8; unsigned long long v3:17; };
struct D_BFu8s_BFu1c { double v1; unsigned short v2:8; unsigned char v3:1; };
struct D_BFu8s_BFu1i { double v1; unsigned short v2:8; unsigned int v3:1; };
struct D_BFu8s_BFu1ll { double v1; unsigned short v2:8; unsigned long long v3:1; };
struct D_BFu8s_BFu1s { double v1; unsigned short v2:8; unsigned short v3:1; };
struct D_BFu8s_BFu31i { double v1; unsigned short v2:8; unsigned int v3:31; };
struct D_BFu8s_BFu31ll { double v1; unsigned short v2:8; unsigned long long v3:31; };
struct D_BFu8s_BFu32i { double v1; unsigned short v2:8; unsigned int v3:32; };
struct D_BFu8s_BFu32ll { double v1; unsigned short v2:8; unsigned long long v3:32; };
struct D_BFu8s_BFu33 { double v1; unsigned short v2:8; unsigned long long v3:33; };
struct D_BFu8s_BFu7c { double v1; unsigned short v2:8; unsigned char v3:7; };
struct D_BFu8s_BFu7i { double v1; unsigned short v2:8; unsigned int v3:7; };
struct D_BFu8s_BFu7ll { double v1; unsigned short v2:8; unsigned long long v3:7; };
struct D_BFu8s_BFu7s { double v1; unsigned short v2:8; unsigned short v3:7; };
struct D_BFu8s_BFu8c { double v1; unsigned short v2:8; unsigned char v3:8; };
struct D_BFu8s_BFu8i { double v1; unsigned short v2:8; unsigned int v3:8; };
struct D_BFu8s_BFu8ll { double v1; unsigned short v2:8; unsigned long long v3:8; };
struct D_BFu8s_BFu8s { double v1; unsigned short v2:8; unsigned short v3:8; };
struct D_BFu8s_BFu9i { double v1; unsigned short v2:8; unsigned int v3:9; };
struct D_BFu8s_BFu9ll { double v1; unsigned short v2:8; unsigned long long v3:9; };
struct D_BFu8s_BFu9s { double v1; unsigned short v2:8; unsigned short v3:9; };
struct D_BFu8s_C { double v1; unsigned short v2:8; char v3; };
struct D_BFu8s_D { double v1; unsigned short v2:8; double v3; };
struct D_BFu8s_F { double v1; unsigned short v2:8; float v3; };
struct D_BFu8s_I { double v1; unsigned short v2:8; int v3; };
struct D_BFu8s_Ip { double v1; unsigned short v2:8; int * v3; };
struct D_BFu8s_L { double v1; unsigned short v2:8; long long v3; };
struct D_BFu8s_S { double v1; unsigned short v2:8; short v3; };
struct D_BFu8s_Uc { double v1; unsigned short v2:8; unsigned char v3; };
struct D_BFu8s_Ui { double v1; unsigned short v2:8; unsigned int v3; };
struct D_BFu8s_Ul { double v1; unsigned short v2:8; unsigned long long v3; };
struct D_BFu8s_Us { double v1; unsigned short v2:8; unsigned short v3; };
struct D_BFu8s_Vp { double v1; unsigned short v2:8; void * v3; };
struct D_BFu9i { double v1; unsigned int v2:9; };
struct D_BFu9i_BFu15i { double v1; unsigned int v2:9; unsigned int v3:15; };
struct D_BFu9i_BFu15ll { double v1; unsigned int v2:9; unsigned long long v3:15; };
struct D_BFu9i_BFu15s { double v1; unsigned int v2:9; unsigned short v3:15; };
struct D_BFu9i_BFu16i { double v1; unsigned int v2:9; unsigned int v3:16; };
struct D_BFu9i_BFu16ll { double v1; unsigned int v2:9; unsigned long long v3:16; };
struct D_BFu9i_BFu16s { double v1; unsigned int v2:9; unsigned short v3:16; };
struct D_BFu9i_BFu17i { double v1; unsigned int v2:9; unsigned int v3:17; };
struct D_BFu9i_BFu17ll { double v1; unsigned int v2:9; unsigned long long v3:17; };
struct D_BFu9i_BFu1c { double v1; unsigned int v2:9; unsigned char v3:1; };
struct D_BFu9i_BFu1i { double v1; unsigned int v2:9; unsigned int v3:1; };
struct D_BFu9i_BFu1ll { double v1; unsigned int v2:9; unsigned long long v3:1; };
struct D_BFu9i_BFu1s { double v1; unsigned int v2:9; unsigned short v3:1; };


static void Test_BFu9s_Ip_BFu17ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu17ll");
    static STRUCT_IF_C BFu9s_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu9s_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu9s_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu9s_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu17ll, BFu9s_Ip_BFu17ll)
//============================================================================



static void Test_BFu9s_Ip_BFu1c()
{
  {
    init_simple_test("BFu9s_Ip_BFu1c");
    static STRUCT_IF_C BFu9s_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu1c, BFu9s_Ip_BFu1c)
//============================================================================



static void Test_BFu9s_Ip_BFu1i()
{
  {
    init_simple_test("BFu9s_Ip_BFu1i");
    static STRUCT_IF_C BFu9s_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu1i, BFu9s_Ip_BFu1i)
//============================================================================



static void Test_BFu9s_Ip_BFu1ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu1ll");
    static STRUCT_IF_C BFu9s_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu1ll, BFu9s_Ip_BFu1ll)
//============================================================================



static void Test_BFu9s_Ip_BFu1s()
{
  {
    init_simple_test("BFu9s_Ip_BFu1s");
    static STRUCT_IF_C BFu9s_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu1s, BFu9s_Ip_BFu1s)
//============================================================================



static void Test_BFu9s_Ip_BFu31i()
{
  {
    init_simple_test("BFu9s_Ip_BFu31i");
    static STRUCT_IF_C BFu9s_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu9s_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu9s_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu31i, BFu9s_Ip_BFu31i)
//============================================================================



static void Test_BFu9s_Ip_BFu31ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu31ll");
    static STRUCT_IF_C BFu9s_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu9s_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu9s_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu31ll, BFu9s_Ip_BFu31ll)
//============================================================================



static void Test_BFu9s_Ip_BFu32i()
{
  {
    init_simple_test("BFu9s_Ip_BFu32i");
    static STRUCT_IF_C BFu9s_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu9s_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu9s_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu32i, BFu9s_Ip_BFu32i)
//============================================================================



static void Test_BFu9s_Ip_BFu32ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu32ll");
    static STRUCT_IF_C BFu9s_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu9s_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu9s_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu32ll, BFu9s_Ip_BFu32ll)
//============================================================================



static void Test_BFu9s_Ip_BFu33()
{
  {
    init_simple_test("BFu9s_Ip_BFu33");
    static STRUCT_IF_C BFu9s_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(BFu9s_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "BFu9s_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "BFu9s_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu33, BFu9s_Ip_BFu33)
//============================================================================



static void Test_BFu9s_Ip_BFu7c()
{
  {
    init_simple_test("BFu9s_Ip_BFu7c");
    static STRUCT_IF_C BFu9s_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu7c, BFu9s_Ip_BFu7c)
//============================================================================



static void Test_BFu9s_Ip_BFu7i()
{
  {
    init_simple_test("BFu9s_Ip_BFu7i");
    static STRUCT_IF_C BFu9s_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu7i, BFu9s_Ip_BFu7i)
//============================================================================



static void Test_BFu9s_Ip_BFu7ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu7ll");
    static STRUCT_IF_C BFu9s_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu7ll, BFu9s_Ip_BFu7ll)
//============================================================================



static void Test_BFu9s_Ip_BFu7s()
{
  {
    init_simple_test("BFu9s_Ip_BFu7s");
    static STRUCT_IF_C BFu9s_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu7s, BFu9s_Ip_BFu7s)
//============================================================================



static void Test_BFu9s_Ip_BFu8c()
{
  {
    init_simple_test("BFu9s_Ip_BFu8c");
    static STRUCT_IF_C BFu9s_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu8c, BFu9s_Ip_BFu8c)
//============================================================================



static void Test_BFu9s_Ip_BFu8i()
{
  {
    init_simple_test("BFu9s_Ip_BFu8i");
    static STRUCT_IF_C BFu9s_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu8i, BFu9s_Ip_BFu8i)
//============================================================================



static void Test_BFu9s_Ip_BFu8ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu8ll");
    static STRUCT_IF_C BFu9s_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu8ll, BFu9s_Ip_BFu8ll)
//============================================================================



static void Test_BFu9s_Ip_BFu8s()
{
  {
    init_simple_test("BFu9s_Ip_BFu8s");
    static STRUCT_IF_C BFu9s_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu8s, BFu9s_Ip_BFu8s)
//============================================================================



static void Test_BFu9s_Ip_BFu9i()
{
  {
    init_simple_test("BFu9s_Ip_BFu9i");
    static STRUCT_IF_C BFu9s_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu9s_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu9i, BFu9s_Ip_BFu9i)
//============================================================================



static void Test_BFu9s_Ip_BFu9ll()
{
  {
    init_simple_test("BFu9s_Ip_BFu9ll");
    static STRUCT_IF_C BFu9s_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu9s_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu9ll, BFu9s_Ip_BFu9ll)
//============================================================================



static void Test_BFu9s_Ip_BFu9s()
{
  {
    init_simple_test("BFu9s_Ip_BFu9s");
    static STRUCT_IF_C BFu9s_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu9s_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_BFu9s, BFu9s_Ip_BFu9s)
//============================================================================



static void Test_BFu9s_Ip_C()
{
  {
    init_simple_test("BFu9s_Ip_C");
    static STRUCT_IF_C BFu9s_Ip_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_C");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_C, BFu9s_Ip_C)
//============================================================================



static void Test_BFu9s_Ip_D()
{
  {
    init_simple_test("BFu9s_Ip_D");
    static STRUCT_IF_C BFu9s_Ip_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_D");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_D, BFu9s_Ip_D)
//============================================================================



static void Test_BFu9s_Ip_F()
{
  {
    init_simple_test("BFu9s_Ip_F");
    static STRUCT_IF_C BFu9s_Ip_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_F");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_F, BFu9s_Ip_F)
//============================================================================



static void Test_BFu9s_Ip_I()
{
  {
    init_simple_test("BFu9s_Ip_I");
    static STRUCT_IF_C BFu9s_Ip_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_I");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_I, BFu9s_Ip_I)
//============================================================================



static void Test_BFu9s_Ip_Ip()
{
  {
    init_simple_test("BFu9s_Ip_Ip");
    static STRUCT_IF_C BFu9s_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu9s_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_Ip, BFu9s_Ip_Ip)
//============================================================================



static void Test_BFu9s_Ip_L()
{
  {
    init_simple_test("BFu9s_Ip_L");
    static STRUCT_IF_C BFu9s_Ip_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_L");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_L, BFu9s_Ip_L)
//============================================================================



static void Test_BFu9s_Ip_S()
{
  {
    init_simple_test("BFu9s_Ip_S");
    static STRUCT_IF_C BFu9s_Ip_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_S");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_S, BFu9s_Ip_S)
//============================================================================



static void Test_BFu9s_Ip_Uc()
{
  {
    init_simple_test("BFu9s_Ip_Uc");
    static STRUCT_IF_C BFu9s_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_Uc, BFu9s_Ip_Uc)
//============================================================================



static void Test_BFu9s_Ip_Ui()
{
  {
    init_simple_test("BFu9s_Ip_Ui");
    static STRUCT_IF_C BFu9s_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_Ui, BFu9s_Ip_Ui)
//============================================================================



static void Test_BFu9s_Ip_Ul()
{
  {
    init_simple_test("BFu9s_Ip_Ul");
    static STRUCT_IF_C BFu9s_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_Ul, BFu9s_Ip_Ul)
//============================================================================



static void Test_BFu9s_Ip_Us()
{
  {
    init_simple_test("BFu9s_Ip_Us");
    static STRUCT_IF_C BFu9s_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_Us, BFu9s_Ip_Us)
//============================================================================



static void Test_BFu9s_Ip_Vp()
{
  {
    init_simple_test("BFu9s_Ip_Vp");
    static STRUCT_IF_C BFu9s_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu9s_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ip_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ip_Vp, BFu9s_Ip_Vp)
//============================================================================



static void Test_BFu9s_L()
{
  {
    init_simple_test("BFu9s_L");
    static STRUCT_IF_C BFu9s_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L");
    check_field_offset(lv, v2, 2, "BFu9s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L, BFu9s_L)
//============================================================================



static void Test_BFu9s_L_BFu15i()
{
  {
    init_simple_test("BFu9s_L_BFu15i");
    static STRUCT_IF_C BFu9s_L_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu9s_L_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu9s_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu15i, BFu9s_L_BFu15i)
//============================================================================



static void Test_BFu9s_L_BFu15ll()
{
  {
    init_simple_test("BFu9s_L_BFu15ll");
    static STRUCT_IF_C BFu9s_L_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu9s_L_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu9s_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu15ll, BFu9s_L_BFu15ll)
//============================================================================



static void Test_BFu9s_L_BFu15s()
{
  {
    init_simple_test("BFu9s_L_BFu15s");
    static STRUCT_IF_C BFu9s_L_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu9s_L_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu9s_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu15s, BFu9s_L_BFu15s)
//============================================================================



static void Test_BFu9s_L_BFu16i()
{
  {
    init_simple_test("BFu9s_L_BFu16i");
    static STRUCT_IF_C BFu9s_L_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu9s_L_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu9s_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu16i, BFu9s_L_BFu16i)
//============================================================================



static void Test_BFu9s_L_BFu16ll()
{
  {
    init_simple_test("BFu9s_L_BFu16ll");
    static STRUCT_IF_C BFu9s_L_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu9s_L_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu9s_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu16ll, BFu9s_L_BFu16ll)
//============================================================================



static void Test_BFu9s_L_BFu16s()
{
  {
    init_simple_test("BFu9s_L_BFu16s");
    static STRUCT_IF_C BFu9s_L_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu9s_L_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu9s_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu16s, BFu9s_L_BFu16s)
//============================================================================



static void Test_BFu9s_L_BFu17i()
{
  {
    init_simple_test("BFu9s_L_BFu17i");
    static STRUCT_IF_C BFu9s_L_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(BFu9s_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu9s_L_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu9s_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu17i, BFu9s_L_BFu17i)
//============================================================================



static void Test_BFu9s_L_BFu17ll()
{
  {
    init_simple_test("BFu9s_L_BFu17ll");
    static STRUCT_IF_C BFu9s_L_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu9s_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu9s_L_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu9s_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu17ll, BFu9s_L_BFu17ll)
//============================================================================



static void Test_BFu9s_L_BFu1c()
{
  {
    init_simple_test("BFu9s_L_BFu1c");
    static STRUCT_IF_C BFu9s_L_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu1c, BFu9s_L_BFu1c)
//============================================================================



static void Test_BFu9s_L_BFu1i()
{
  {
    init_simple_test("BFu9s_L_BFu1i");
    static STRUCT_IF_C BFu9s_L_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu1i, BFu9s_L_BFu1i)
//============================================================================



static void Test_BFu9s_L_BFu1ll()
{
  {
    init_simple_test("BFu9s_L_BFu1ll");
    static STRUCT_IF_C BFu9s_L_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu1ll, BFu9s_L_BFu1ll)
//============================================================================



static void Test_BFu9s_L_BFu1s()
{
  {
    init_simple_test("BFu9s_L_BFu1s");
    static STRUCT_IF_C BFu9s_L_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu1s, BFu9s_L_BFu1s)
//============================================================================



static void Test_BFu9s_L_BFu31i()
{
  {
    init_simple_test("BFu9s_L_BFu31i");
    static STRUCT_IF_C BFu9s_L_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu9s_L_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu9s_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu31i, BFu9s_L_BFu31i)
//============================================================================



static void Test_BFu9s_L_BFu31ll()
{
  {
    init_simple_test("BFu9s_L_BFu31ll");
    static STRUCT_IF_C BFu9s_L_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu9s_L_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu9s_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu31ll, BFu9s_L_BFu31ll)
//============================================================================



static void Test_BFu9s_L_BFu32i()
{
  {
    init_simple_test("BFu9s_L_BFu32i");
    static STRUCT_IF_C BFu9s_L_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu9s_L_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu9s_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu32i, BFu9s_L_BFu32i)
//============================================================================



static void Test_BFu9s_L_BFu32ll()
{
  {
    init_simple_test("BFu9s_L_BFu32ll");
    static STRUCT_IF_C BFu9s_L_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu9s_L_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu9s_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu32ll, BFu9s_L_BFu32ll)
//============================================================================



static void Test_BFu9s_L_BFu33()
{
  {
    init_simple_test("BFu9s_L_BFu33");
    static STRUCT_IF_C BFu9s_L_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(BFu9s_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "BFu9s_L_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "BFu9s_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu33, BFu9s_L_BFu33)
//============================================================================



static void Test_BFu9s_L_BFu7c()
{
  {
    init_simple_test("BFu9s_L_BFu7c");
    static STRUCT_IF_C BFu9s_L_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_L_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu7c, BFu9s_L_BFu7c)
//============================================================================



static void Test_BFu9s_L_BFu7i()
{
  {
    init_simple_test("BFu9s_L_BFu7i");
    static STRUCT_IF_C BFu9s_L_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_L_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu7i, BFu9s_L_BFu7i)
//============================================================================



static void Test_BFu9s_L_BFu7ll()
{
  {
    init_simple_test("BFu9s_L_BFu7ll");
    static STRUCT_IF_C BFu9s_L_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_L_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu7ll, BFu9s_L_BFu7ll)
//============================================================================



static void Test_BFu9s_L_BFu7s()
{
  {
    init_simple_test("BFu9s_L_BFu7s");
    static STRUCT_IF_C BFu9s_L_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_L_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu7s, BFu9s_L_BFu7s)
//============================================================================



static void Test_BFu9s_L_BFu8c()
{
  {
    init_simple_test("BFu9s_L_BFu8c");
    static STRUCT_IF_C BFu9s_L_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_L_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu8c, BFu9s_L_BFu8c)
//============================================================================



static void Test_BFu9s_L_BFu8i()
{
  {
    init_simple_test("BFu9s_L_BFu8i");
    static STRUCT_IF_C BFu9s_L_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_L_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu8i, BFu9s_L_BFu8i)
//============================================================================



static void Test_BFu9s_L_BFu8ll()
{
  {
    init_simple_test("BFu9s_L_BFu8ll");
    static STRUCT_IF_C BFu9s_L_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_L_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu8ll, BFu9s_L_BFu8ll)
//============================================================================



static void Test_BFu9s_L_BFu8s()
{
  {
    init_simple_test("BFu9s_L_BFu8s");
    static STRUCT_IF_C BFu9s_L_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_L_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu8s, BFu9s_L_BFu8s)
//============================================================================



static void Test_BFu9s_L_BFu9i()
{
  {
    init_simple_test("BFu9s_L_BFu9i");
    static STRUCT_IF_C BFu9s_L_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu9s_L_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu9i, BFu9s_L_BFu9i)
//============================================================================



static void Test_BFu9s_L_BFu9ll()
{
  {
    init_simple_test("BFu9s_L_BFu9ll");
    static STRUCT_IF_C BFu9s_L_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu9s_L_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu9ll, BFu9s_L_BFu9ll)
//============================================================================



static void Test_BFu9s_L_BFu9s()
{
  {
    init_simple_test("BFu9s_L_BFu9s");
    static STRUCT_IF_C BFu9s_L_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu9s_L_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu9s_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_BFu9s, BFu9s_L_BFu9s)
//============================================================================



static void Test_BFu9s_L_C()
{
  {
    init_simple_test("BFu9s_L_C");
    static STRUCT_IF_C BFu9s_L_C lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_C");
    check_field_offset(lv, v2, 2, "BFu9s_L_C.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_C, BFu9s_L_C)
//============================================================================



static void Test_BFu9s_L_D()
{
  {
    init_simple_test("BFu9s_L_D");
    static STRUCT_IF_C BFu9s_L_D lv;
    check2(sizeof(lv), 18, "sizeof(BFu9s_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_D");
    check_field_offset(lv, v2, 2, "BFu9s_L_D.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_D, BFu9s_L_D)
//============================================================================



static void Test_BFu9s_L_F()
{
  {
    init_simple_test("BFu9s_L_F");
    static STRUCT_IF_C BFu9s_L_F lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_F");
    check_field_offset(lv, v2, 2, "BFu9s_L_F.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_F, BFu9s_L_F)
//============================================================================



static void Test_BFu9s_L_I()
{
  {
    init_simple_test("BFu9s_L_I");
    static STRUCT_IF_C BFu9s_L_I lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_I");
    check_field_offset(lv, v2, 2, "BFu9s_L_I.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_I, BFu9s_L_I)
//============================================================================



static void Test_BFu9s_L_Ip()
{
  {
    init_simple_test("BFu9s_L_Ip");
    static STRUCT_IF_C BFu9s_L_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_L_Ip.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_Ip, BFu9s_L_Ip)
//============================================================================



static void Test_BFu9s_L_L()
{
  {
    init_simple_test("BFu9s_L_L");
    static STRUCT_IF_C BFu9s_L_L lv;
    check2(sizeof(lv), 18, "sizeof(BFu9s_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_L");
    check_field_offset(lv, v2, 2, "BFu9s_L_L.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_L, BFu9s_L_L)
//============================================================================



static void Test_BFu9s_L_S()
{
  {
    init_simple_test("BFu9s_L_S");
    static STRUCT_IF_C BFu9s_L_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_S");
    check_field_offset(lv, v2, 2, "BFu9s_L_S.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_S, BFu9s_L_S)
//============================================================================



static void Test_BFu9s_L_Uc()
{
  {
    init_simple_test("BFu9s_L_Uc");
    static STRUCT_IF_C BFu9s_L_Uc lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_L_Uc.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_Uc, BFu9s_L_Uc)
//============================================================================



static void Test_BFu9s_L_Ui()
{
  {
    init_simple_test("BFu9s_L_Ui");
    static STRUCT_IF_C BFu9s_L_Ui lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_L_Ui.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_Ui, BFu9s_L_Ui)
//============================================================================



static void Test_BFu9s_L_Ul()
{
  {
    init_simple_test("BFu9s_L_Ul");
    static STRUCT_IF_C BFu9s_L_Ul lv;
    check2(sizeof(lv), 18, "sizeof(BFu9s_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_L_Ul.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_Ul, BFu9s_L_Ul)
//============================================================================



static void Test_BFu9s_L_Us()
{
  {
    init_simple_test("BFu9s_L_Us");
    static STRUCT_IF_C BFu9s_L_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_Us");
    check_field_offset(lv, v2, 2, "BFu9s_L_Us.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_Us, BFu9s_L_Us)
//============================================================================



static void Test_BFu9s_L_Vp()
{
  {
    init_simple_test("BFu9s_L_Vp");
    static STRUCT_IF_C BFu9s_L_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_L_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_L_Vp.v2");
    check_field_offset(lv, v3, 10, "BFu9s_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_L_Vp, BFu9s_L_Vp)
//============================================================================



static void Test_BFu9s_S()
{
  {
    init_simple_test("BFu9s_S");
    static STRUCT_IF_C BFu9s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S");
    check_field_offset(lv, v2, 2, "BFu9s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S, BFu9s_S)
//============================================================================



static void Test_BFu9s_S_BFu15i()
{
  {
    init_simple_test("BFu9s_S_BFu15i");
    static STRUCT_IF_C BFu9s_S_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_S_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu15i, BFu9s_S_BFu15i)
//============================================================================



static void Test_BFu9s_S_BFu15ll()
{
  {
    init_simple_test("BFu9s_S_BFu15ll");
    static STRUCT_IF_C BFu9s_S_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_S_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu15ll, BFu9s_S_BFu15ll)
//============================================================================



static void Test_BFu9s_S_BFu15s()
{
  {
    init_simple_test("BFu9s_S_BFu15s");
    static STRUCT_IF_C BFu9s_S_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_S_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu15s, BFu9s_S_BFu15s)
//============================================================================



static void Test_BFu9s_S_BFu16i()
{
  {
    init_simple_test("BFu9s_S_BFu16i");
    static STRUCT_IF_C BFu9s_S_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_S_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu16i, BFu9s_S_BFu16i)
//============================================================================



static void Test_BFu9s_S_BFu16ll()
{
  {
    init_simple_test("BFu9s_S_BFu16ll");
    static STRUCT_IF_C BFu9s_S_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_S_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu16ll, BFu9s_S_BFu16ll)
//============================================================================



static void Test_BFu9s_S_BFu16s()
{
  {
    init_simple_test("BFu9s_S_BFu16s");
    static STRUCT_IF_C BFu9s_S_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_S_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu16s, BFu9s_S_BFu16s)
//============================================================================



static void Test_BFu9s_S_BFu17i()
{
  {
    init_simple_test("BFu9s_S_BFu17i");
    static STRUCT_IF_C BFu9s_S_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9s_S_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9s_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu17i, BFu9s_S_BFu17i)
//============================================================================



static void Test_BFu9s_S_BFu17ll()
{
  {
    init_simple_test("BFu9s_S_BFu17ll");
    static STRUCT_IF_C BFu9s_S_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9s_S_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9s_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu17ll, BFu9s_S_BFu17ll)
//============================================================================



static void Test_BFu9s_S_BFu1c()
{
  {
    init_simple_test("BFu9s_S_BFu1c");
    static STRUCT_IF_C BFu9s_S_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu1c, BFu9s_S_BFu1c)
//============================================================================



static void Test_BFu9s_S_BFu1i()
{
  {
    init_simple_test("BFu9s_S_BFu1i");
    static STRUCT_IF_C BFu9s_S_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu1i, BFu9s_S_BFu1i)
//============================================================================



static void Test_BFu9s_S_BFu1ll()
{
  {
    init_simple_test("BFu9s_S_BFu1ll");
    static STRUCT_IF_C BFu9s_S_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu1ll, BFu9s_S_BFu1ll)
//============================================================================



static void Test_BFu9s_S_BFu1s()
{
  {
    init_simple_test("BFu9s_S_BFu1s");
    static STRUCT_IF_C BFu9s_S_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu1s, BFu9s_S_BFu1s)
//============================================================================



static void Test_BFu9s_S_BFu31i()
{
  {
    init_simple_test("BFu9s_S_BFu31i");
    static STRUCT_IF_C BFu9s_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9s_S_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9s_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu31i, BFu9s_S_BFu31i)
//============================================================================



static void Test_BFu9s_S_BFu31ll()
{
  {
    init_simple_test("BFu9s_S_BFu31ll");
    static STRUCT_IF_C BFu9s_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9s_S_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9s_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu31ll, BFu9s_S_BFu31ll)
//============================================================================



static void Test_BFu9s_S_BFu32i()
{
  {
    init_simple_test("BFu9s_S_BFu32i");
    static STRUCT_IF_C BFu9s_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9s_S_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9s_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu32i, BFu9s_S_BFu32i)
//============================================================================



static void Test_BFu9s_S_BFu32ll()
{
  {
    init_simple_test("BFu9s_S_BFu32ll");
    static STRUCT_IF_C BFu9s_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9s_S_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9s_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu32ll, BFu9s_S_BFu32ll)
//============================================================================



static void Test_BFu9s_S_BFu33()
{
  {
    init_simple_test("BFu9s_S_BFu33");
    static STRUCT_IF_C BFu9s_S_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu9s_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu9s_S_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu9s_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu33, BFu9s_S_BFu33)
//============================================================================



static void Test_BFu9s_S_BFu7c()
{
  {
    init_simple_test("BFu9s_S_BFu7c");
    static STRUCT_IF_C BFu9s_S_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_S_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu7c, BFu9s_S_BFu7c)
//============================================================================



static void Test_BFu9s_S_BFu7i()
{
  {
    init_simple_test("BFu9s_S_BFu7i");
    static STRUCT_IF_C BFu9s_S_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_S_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu7i, BFu9s_S_BFu7i)
//============================================================================



static void Test_BFu9s_S_BFu7ll()
{
  {
    init_simple_test("BFu9s_S_BFu7ll");
    static STRUCT_IF_C BFu9s_S_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_S_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu7ll, BFu9s_S_BFu7ll)
//============================================================================



static void Test_BFu9s_S_BFu7s()
{
  {
    init_simple_test("BFu9s_S_BFu7s");
    static STRUCT_IF_C BFu9s_S_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_S_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu7s, BFu9s_S_BFu7s)
//============================================================================



static void Test_BFu9s_S_BFu8c()
{
  {
    init_simple_test("BFu9s_S_BFu8c");
    static STRUCT_IF_C BFu9s_S_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_S_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu8c, BFu9s_S_BFu8c)
//============================================================================



static void Test_BFu9s_S_BFu8i()
{
  {
    init_simple_test("BFu9s_S_BFu8i");
    static STRUCT_IF_C BFu9s_S_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_S_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu8i, BFu9s_S_BFu8i)
//============================================================================



static void Test_BFu9s_S_BFu8ll()
{
  {
    init_simple_test("BFu9s_S_BFu8ll");
    static STRUCT_IF_C BFu9s_S_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_S_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu8ll, BFu9s_S_BFu8ll)
//============================================================================



static void Test_BFu9s_S_BFu8s()
{
  {
    init_simple_test("BFu9s_S_BFu8s");
    static STRUCT_IF_C BFu9s_S_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_S_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu8s, BFu9s_S_BFu8s)
//============================================================================



static void Test_BFu9s_S_BFu9i()
{
  {
    init_simple_test("BFu9s_S_BFu9i");
    static STRUCT_IF_C BFu9s_S_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_S_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu9i, BFu9s_S_BFu9i)
//============================================================================



static void Test_BFu9s_S_BFu9ll()
{
  {
    init_simple_test("BFu9s_S_BFu9ll");
    static STRUCT_IF_C BFu9s_S_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_S_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu9ll, BFu9s_S_BFu9ll)
//============================================================================



static void Test_BFu9s_S_BFu9s()
{
  {
    init_simple_test("BFu9s_S_BFu9s");
    static STRUCT_IF_C BFu9s_S_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_S_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_BFu9s, BFu9s_S_BFu9s)
//============================================================================



static void Test_BFu9s_S_C()
{
  {
    init_simple_test("BFu9s_S_C");
    static STRUCT_IF_C BFu9s_S_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_C");
    check_field_offset(lv, v2, 2, "BFu9s_S_C.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_C, BFu9s_S_C)
//============================================================================



static void Test_BFu9s_S_D()
{
  {
    init_simple_test("BFu9s_S_D");
    static STRUCT_IF_C BFu9s_S_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_D");
    check_field_offset(lv, v2, 2, "BFu9s_S_D.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_D, BFu9s_S_D)
//============================================================================



static void Test_BFu9s_S_F()
{
  {
    init_simple_test("BFu9s_S_F");
    static STRUCT_IF_C BFu9s_S_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_F");
    check_field_offset(lv, v2, 2, "BFu9s_S_F.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_F, BFu9s_S_F)
//============================================================================



static void Test_BFu9s_S_I()
{
  {
    init_simple_test("BFu9s_S_I");
    static STRUCT_IF_C BFu9s_S_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_I");
    check_field_offset(lv, v2, 2, "BFu9s_S_I.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_I, BFu9s_S_I)
//============================================================================



static void Test_BFu9s_S_Ip()
{
  {
    init_simple_test("BFu9s_S_Ip");
    static STRUCT_IF_C BFu9s_S_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_S_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_Ip, BFu9s_S_Ip)
//============================================================================



static void Test_BFu9s_S_L()
{
  {
    init_simple_test("BFu9s_S_L");
    static STRUCT_IF_C BFu9s_S_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_L");
    check_field_offset(lv, v2, 2, "BFu9s_S_L.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_L, BFu9s_S_L)
//============================================================================



static void Test_BFu9s_S_S()
{
  {
    init_simple_test("BFu9s_S_S");
    static STRUCT_IF_C BFu9s_S_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_S");
    check_field_offset(lv, v2, 2, "BFu9s_S_S.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_S, BFu9s_S_S)
//============================================================================



static void Test_BFu9s_S_Uc()
{
  {
    init_simple_test("BFu9s_S_Uc");
    static STRUCT_IF_C BFu9s_S_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_S_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_Uc, BFu9s_S_Uc)
//============================================================================



static void Test_BFu9s_S_Ui()
{
  {
    init_simple_test("BFu9s_S_Ui");
    static STRUCT_IF_C BFu9s_S_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_S_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_Ui, BFu9s_S_Ui)
//============================================================================



static void Test_BFu9s_S_Ul()
{
  {
    init_simple_test("BFu9s_S_Ul");
    static STRUCT_IF_C BFu9s_S_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_S_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_Ul, BFu9s_S_Ul)
//============================================================================



static void Test_BFu9s_S_Us()
{
  {
    init_simple_test("BFu9s_S_Us");
    static STRUCT_IF_C BFu9s_S_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_Us");
    check_field_offset(lv, v2, 2, "BFu9s_S_Us.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_Us, BFu9s_S_Us)
//============================================================================



static void Test_BFu9s_S_Vp()
{
  {
    init_simple_test("BFu9s_S_Vp");
    static STRUCT_IF_C BFu9s_S_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_S_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_S_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_S_Vp, BFu9s_S_Vp)
//============================================================================



static void Test_BFu9s_Uc()
{
  {
    init_simple_test("BFu9s_Uc");
    static STRUCT_IF_C BFu9s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc, BFu9s_Uc)
//============================================================================



static void Test_BFu9s_Uc_BFu15i()
{
  {
    init_simple_test("BFu9s_Uc_BFu15i");
    static STRUCT_IF_C BFu9s_Uc_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu9s_Uc_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu9s_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu15i, BFu9s_Uc_BFu15i)
//============================================================================



static void Test_BFu9s_Uc_BFu15ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu15ll");
    static STRUCT_IF_C BFu9s_Uc_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu9s_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu9s_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu15ll, BFu9s_Uc_BFu15ll)
//============================================================================



static void Test_BFu9s_Uc_BFu15s()
{
  {
    init_simple_test("BFu9s_Uc_BFu15s");
    static STRUCT_IF_C BFu9s_Uc_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu9s_Uc_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu9s_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu15s, BFu9s_Uc_BFu15s)
//============================================================================



static void Test_BFu9s_Uc_BFu16i()
{
  {
    init_simple_test("BFu9s_Uc_BFu16i");
    static STRUCT_IF_C BFu9s_Uc_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu9s_Uc_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu9s_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu16i, BFu9s_Uc_BFu16i)
//============================================================================



static void Test_BFu9s_Uc_BFu16ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu16ll");
    static STRUCT_IF_C BFu9s_Uc_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu9s_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu9s_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu16ll, BFu9s_Uc_BFu16ll)
//============================================================================



static void Test_BFu9s_Uc_BFu16s()
{
  {
    init_simple_test("BFu9s_Uc_BFu16s");
    static STRUCT_IF_C BFu9s_Uc_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu9s_Uc_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu9s_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu16s, BFu9s_Uc_BFu16s)
//============================================================================



static void Test_BFu9s_Uc_BFu17i()
{
  {
    init_simple_test("BFu9s_Uc_BFu17i");
    static STRUCT_IF_C BFu9s_Uc_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu9s_Uc_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu9s_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu17i, BFu9s_Uc_BFu17i)
//============================================================================



static void Test_BFu9s_Uc_BFu17ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu17ll");
    static STRUCT_IF_C BFu9s_Uc_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu9s_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu9s_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu17ll, BFu9s_Uc_BFu17ll)
//============================================================================



static void Test_BFu9s_Uc_BFu1c()
{
  {
    init_simple_test("BFu9s_Uc_BFu1c");
    static STRUCT_IF_C BFu9s_Uc_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu1c, BFu9s_Uc_BFu1c)
//============================================================================



static void Test_BFu9s_Uc_BFu1i()
{
  {
    init_simple_test("BFu9s_Uc_BFu1i");
    static STRUCT_IF_C BFu9s_Uc_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu1i, BFu9s_Uc_BFu1i)
//============================================================================



static void Test_BFu9s_Uc_BFu1ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu1ll");
    static STRUCT_IF_C BFu9s_Uc_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu1ll, BFu9s_Uc_BFu1ll)
//============================================================================



static void Test_BFu9s_Uc_BFu1s()
{
  {
    init_simple_test("BFu9s_Uc_BFu1s");
    static STRUCT_IF_C BFu9s_Uc_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu1s, BFu9s_Uc_BFu1s)
//============================================================================



static void Test_BFu9s_Uc_BFu31i()
{
  {
    init_simple_test("BFu9s_Uc_BFu31i");
    static STRUCT_IF_C BFu9s_Uc_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu9s_Uc_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu9s_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu31i, BFu9s_Uc_BFu31i)
//============================================================================



static void Test_BFu9s_Uc_BFu31ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu31ll");
    static STRUCT_IF_C BFu9s_Uc_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu9s_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu9s_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu31ll, BFu9s_Uc_BFu31ll)
//============================================================================



static void Test_BFu9s_Uc_BFu32i()
{
  {
    init_simple_test("BFu9s_Uc_BFu32i");
    static STRUCT_IF_C BFu9s_Uc_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu9s_Uc_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu9s_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu32i, BFu9s_Uc_BFu32i)
//============================================================================



static void Test_BFu9s_Uc_BFu32ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu32ll");
    static STRUCT_IF_C BFu9s_Uc_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu9s_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu9s_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu32ll, BFu9s_Uc_BFu32ll)
//============================================================================



static void Test_BFu9s_Uc_BFu33()
{
  {
    init_simple_test("BFu9s_Uc_BFu33");
    static STRUCT_IF_C BFu9s_Uc_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu9s_Uc_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu9s_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu33, BFu9s_Uc_BFu33)
//============================================================================



static void Test_BFu9s_Uc_BFu7c()
{
  {
    init_simple_test("BFu9s_Uc_BFu7c");
    static STRUCT_IF_C BFu9s_Uc_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_Uc_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu7c, BFu9s_Uc_BFu7c)
//============================================================================



static void Test_BFu9s_Uc_BFu7i()
{
  {
    init_simple_test("BFu9s_Uc_BFu7i");
    static STRUCT_IF_C BFu9s_Uc_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_Uc_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu7i, BFu9s_Uc_BFu7i)
//============================================================================



static void Test_BFu9s_Uc_BFu7ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu7ll");
    static STRUCT_IF_C BFu9s_Uc_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu7ll, BFu9s_Uc_BFu7ll)
//============================================================================



static void Test_BFu9s_Uc_BFu7s()
{
  {
    init_simple_test("BFu9s_Uc_BFu7s");
    static STRUCT_IF_C BFu9s_Uc_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_Uc_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu7s, BFu9s_Uc_BFu7s)
//============================================================================



static void Test_BFu9s_Uc_BFu8c()
{
  {
    init_simple_test("BFu9s_Uc_BFu8c");
    static STRUCT_IF_C BFu9s_Uc_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_Uc_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu8c, BFu9s_Uc_BFu8c)
//============================================================================



static void Test_BFu9s_Uc_BFu8i()
{
  {
    init_simple_test("BFu9s_Uc_BFu8i");
    static STRUCT_IF_C BFu9s_Uc_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_Uc_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu8i, BFu9s_Uc_BFu8i)
//============================================================================



static void Test_BFu9s_Uc_BFu8ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu8ll");
    static STRUCT_IF_C BFu9s_Uc_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu8ll, BFu9s_Uc_BFu8ll)
//============================================================================



static void Test_BFu9s_Uc_BFu8s()
{
  {
    init_simple_test("BFu9s_Uc_BFu8s");
    static STRUCT_IF_C BFu9s_Uc_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_Uc_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu8s, BFu9s_Uc_BFu8s)
//============================================================================



static void Test_BFu9s_Uc_BFu9i()
{
  {
    init_simple_test("BFu9s_Uc_BFu9i");
    static STRUCT_IF_C BFu9s_Uc_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu9s_Uc_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu9i, BFu9s_Uc_BFu9i)
//============================================================================



static void Test_BFu9s_Uc_BFu9ll()
{
  {
    init_simple_test("BFu9s_Uc_BFu9ll");
    static STRUCT_IF_C BFu9s_Uc_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu9s_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu9ll, BFu9s_Uc_BFu9ll)
//============================================================================



static void Test_BFu9s_Uc_BFu9s()
{
  {
    init_simple_test("BFu9s_Uc_BFu9s");
    static STRUCT_IF_C BFu9s_Uc_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu9s_Uc_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_BFu9s, BFu9s_Uc_BFu9s)
//============================================================================



static void Test_BFu9s_Uc_C()
{
  {
    init_simple_test("BFu9s_Uc_C");
    static STRUCT_IF_C BFu9s_Uc_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_C");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_C.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_C, BFu9s_Uc_C)
//============================================================================



static void Test_BFu9s_Uc_D()
{
  {
    init_simple_test("BFu9s_Uc_D");
    static STRUCT_IF_C BFu9s_Uc_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_D");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_D.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_D, BFu9s_Uc_D)
//============================================================================



static void Test_BFu9s_Uc_F()
{
  {
    init_simple_test("BFu9s_Uc_F");
    static STRUCT_IF_C BFu9s_Uc_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_F");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_F.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_F, BFu9s_Uc_F)
//============================================================================



static void Test_BFu9s_Uc_I()
{
  {
    init_simple_test("BFu9s_Uc_I");
    static STRUCT_IF_C BFu9s_Uc_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_I");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_I.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_I, BFu9s_Uc_I)
//============================================================================



static void Test_BFu9s_Uc_Ip()
{
  {
    init_simple_test("BFu9s_Uc_Ip");
    static STRUCT_IF_C BFu9s_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_Ip, BFu9s_Uc_Ip)
//============================================================================



static void Test_BFu9s_Uc_L()
{
  {
    init_simple_test("BFu9s_Uc_L");
    static STRUCT_IF_C BFu9s_Uc_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_L");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_L.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_L, BFu9s_Uc_L)
//============================================================================



static void Test_BFu9s_Uc_S()
{
  {
    init_simple_test("BFu9s_Uc_S");
    static STRUCT_IF_C BFu9s_Uc_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_S");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_S.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_S, BFu9s_Uc_S)
//============================================================================



static void Test_BFu9s_Uc_Uc()
{
  {
    init_simple_test("BFu9s_Uc_Uc");
    static STRUCT_IF_C BFu9s_Uc_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_Uc, BFu9s_Uc_Uc)
//============================================================================



static void Test_BFu9s_Uc_Ui()
{
  {
    init_simple_test("BFu9s_Uc_Ui");
    static STRUCT_IF_C BFu9s_Uc_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_Ui, BFu9s_Uc_Ui)
//============================================================================



static void Test_BFu9s_Uc_Ul()
{
  {
    init_simple_test("BFu9s_Uc_Ul");
    static STRUCT_IF_C BFu9s_Uc_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_Ul, BFu9s_Uc_Ul)
//============================================================================



static void Test_BFu9s_Uc_Us()
{
  {
    init_simple_test("BFu9s_Uc_Us");
    static STRUCT_IF_C BFu9s_Uc_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_Us.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_Us, BFu9s_Uc_Us)
//============================================================================



static void Test_BFu9s_Uc_Vp()
{
  {
    init_simple_test("BFu9s_Uc_Vp");
    static STRUCT_IF_C BFu9s_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Uc_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Uc_Vp, BFu9s_Uc_Vp)
//============================================================================



static void Test_BFu9s_Ui()
{
  {
    init_simple_test("BFu9s_Ui");
    static STRUCT_IF_C BFu9s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui, BFu9s_Ui)
//============================================================================



static void Test_BFu9s_Ui_BFu15i()
{
  {
    init_simple_test("BFu9s_Ui_BFu15i");
    static STRUCT_IF_C BFu9s_Ui_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu9s_Ui_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu9s_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu15i, BFu9s_Ui_BFu15i)
//============================================================================



static void Test_BFu9s_Ui_BFu15ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu15ll");
    static STRUCT_IF_C BFu9s_Ui_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu9s_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu9s_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu15ll, BFu9s_Ui_BFu15ll)
//============================================================================



static void Test_BFu9s_Ui_BFu15s()
{
  {
    init_simple_test("BFu9s_Ui_BFu15s");
    static STRUCT_IF_C BFu9s_Ui_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu9s_Ui_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu9s_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu15s, BFu9s_Ui_BFu15s)
//============================================================================



static void Test_BFu9s_Ui_BFu16i()
{
  {
    init_simple_test("BFu9s_Ui_BFu16i");
    static STRUCT_IF_C BFu9s_Ui_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu9s_Ui_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu9s_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu16i, BFu9s_Ui_BFu16i)
//============================================================================



static void Test_BFu9s_Ui_BFu16ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu16ll");
    static STRUCT_IF_C BFu9s_Ui_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu9s_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu9s_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu16ll, BFu9s_Ui_BFu16ll)
//============================================================================



static void Test_BFu9s_Ui_BFu16s()
{
  {
    init_simple_test("BFu9s_Ui_BFu16s");
    static STRUCT_IF_C BFu9s_Ui_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu9s_Ui_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu9s_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu16s, BFu9s_Ui_BFu16s)
//============================================================================



static void Test_BFu9s_Ui_BFu17i()
{
  {
    init_simple_test("BFu9s_Ui_BFu17i");
    static STRUCT_IF_C BFu9s_Ui_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(BFu9s_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu9s_Ui_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu9s_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu17i, BFu9s_Ui_BFu17i)
//============================================================================



static void Test_BFu9s_Ui_BFu17ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu17ll");
    static STRUCT_IF_C BFu9s_Ui_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu9s_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu9s_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu9s_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu17ll, BFu9s_Ui_BFu17ll)
//============================================================================



static void Test_BFu9s_Ui_BFu1c()
{
  {
    init_simple_test("BFu9s_Ui_BFu1c");
    static STRUCT_IF_C BFu9s_Ui_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu9s_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu1c, BFu9s_Ui_BFu1c)
//============================================================================



static void Test_BFu9s_Ui_BFu1i()
{
  {
    init_simple_test("BFu9s_Ui_BFu1i");
    static STRUCT_IF_C BFu9s_Ui_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu9s_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu1i, BFu9s_Ui_BFu1i)
//============================================================================



static void Test_BFu9s_Ui_BFu1ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu1ll");
    static STRUCT_IF_C BFu9s_Ui_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu9s_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu1ll, BFu9s_Ui_BFu1ll)
//============================================================================



static void Test_BFu9s_Ui_BFu1s()
{
  {
    init_simple_test("BFu9s_Ui_BFu1s");
    static STRUCT_IF_C BFu9s_Ui_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu9s_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu1s, BFu9s_Ui_BFu1s)
//============================================================================



static void Test_BFu9s_Ui_BFu31i()
{
  {
    init_simple_test("BFu9s_Ui_BFu31i");
    static STRUCT_IF_C BFu9s_Ui_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu9s_Ui_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu9s_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu31i, BFu9s_Ui_BFu31i)
//============================================================================



static void Test_BFu9s_Ui_BFu31ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu31ll");
    static STRUCT_IF_C BFu9s_Ui_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu9s_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu9s_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu31ll, BFu9s_Ui_BFu31ll)
//============================================================================



static void Test_BFu9s_Ui_BFu32i()
{
  {
    init_simple_test("BFu9s_Ui_BFu32i");
    static STRUCT_IF_C BFu9s_Ui_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu9s_Ui_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu9s_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu32i, BFu9s_Ui_BFu32i)
//============================================================================



static void Test_BFu9s_Ui_BFu32ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu32ll");
    static STRUCT_IF_C BFu9s_Ui_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu9s_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu9s_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu32ll, BFu9s_Ui_BFu32ll)
//============================================================================



static void Test_BFu9s_Ui_BFu33()
{
  {
    init_simple_test("BFu9s_Ui_BFu33");
    static STRUCT_IF_C BFu9s_Ui_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "BFu9s_Ui_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "BFu9s_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu33, BFu9s_Ui_BFu33)
//============================================================================



static void Test_BFu9s_Ui_BFu7c()
{
  {
    init_simple_test("BFu9s_Ui_BFu7c");
    static STRUCT_IF_C BFu9s_Ui_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu9s_Ui_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu9s_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu7c, BFu9s_Ui_BFu7c)
//============================================================================



static void Test_BFu9s_Ui_BFu7i()
{
  {
    init_simple_test("BFu9s_Ui_BFu7i");
    static STRUCT_IF_C BFu9s_Ui_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu9s_Ui_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu9s_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu7i, BFu9s_Ui_BFu7i)
//============================================================================



static void Test_BFu9s_Ui_BFu7ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu7ll");
    static STRUCT_IF_C BFu9s_Ui_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu9s_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu9s_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu7ll, BFu9s_Ui_BFu7ll)
//============================================================================



static void Test_BFu9s_Ui_BFu7s()
{
  {
    init_simple_test("BFu9s_Ui_BFu7s");
    static STRUCT_IF_C BFu9s_Ui_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu9s_Ui_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu9s_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu7s, BFu9s_Ui_BFu7s)
//============================================================================



static void Test_BFu9s_Ui_BFu8c()
{
  {
    init_simple_test("BFu9s_Ui_BFu8c");
    static STRUCT_IF_C BFu9s_Ui_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu9s_Ui_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu9s_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu8c, BFu9s_Ui_BFu8c)
//============================================================================



static void Test_BFu9s_Ui_BFu8i()
{
  {
    init_simple_test("BFu9s_Ui_BFu8i");
    static STRUCT_IF_C BFu9s_Ui_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu9s_Ui_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu9s_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu8i, BFu9s_Ui_BFu8i)
//============================================================================



static void Test_BFu9s_Ui_BFu8ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu8ll");
    static STRUCT_IF_C BFu9s_Ui_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu9s_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu9s_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu8ll, BFu9s_Ui_BFu8ll)
//============================================================================



static void Test_BFu9s_Ui_BFu8s()
{
  {
    init_simple_test("BFu9s_Ui_BFu8s");
    static STRUCT_IF_C BFu9s_Ui_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu9s_Ui_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu9s_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu8s, BFu9s_Ui_BFu8s)
//============================================================================



static void Test_BFu9s_Ui_BFu9i()
{
  {
    init_simple_test("BFu9s_Ui_BFu9i");
    static STRUCT_IF_C BFu9s_Ui_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu9s_Ui_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu9i, BFu9s_Ui_BFu9i)
//============================================================================



static void Test_BFu9s_Ui_BFu9ll()
{
  {
    init_simple_test("BFu9s_Ui_BFu9ll");
    static STRUCT_IF_C BFu9s_Ui_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu9s_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu9ll, BFu9s_Ui_BFu9ll)
//============================================================================



static void Test_BFu9s_Ui_BFu9s()
{
  {
    init_simple_test("BFu9s_Ui_BFu9s");
    static STRUCT_IF_C BFu9s_Ui_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu9s_Ui_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_BFu9s, BFu9s_Ui_BFu9s)
//============================================================================



static void Test_BFu9s_Ui_C()
{
  {
    init_simple_test("BFu9s_Ui_C");
    static STRUCT_IF_C BFu9s_Ui_C lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_C");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_C.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_C, BFu9s_Ui_C)
//============================================================================



static void Test_BFu9s_Ui_D()
{
  {
    init_simple_test("BFu9s_Ui_D");
    static STRUCT_IF_C BFu9s_Ui_D lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_D");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_D.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_D, BFu9s_Ui_D)
//============================================================================



static void Test_BFu9s_Ui_F()
{
  {
    init_simple_test("BFu9s_Ui_F");
    static STRUCT_IF_C BFu9s_Ui_F lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_F");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_F.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_F, BFu9s_Ui_F)
//============================================================================



static void Test_BFu9s_Ui_I()
{
  {
    init_simple_test("BFu9s_Ui_I");
    static STRUCT_IF_C BFu9s_Ui_I lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_I");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_I.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_I, BFu9s_Ui_I)
//============================================================================



static void Test_BFu9s_Ui_Ip()
{
  {
    init_simple_test("BFu9s_Ui_Ip");
    static STRUCT_IF_C BFu9s_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_Ip.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_Ip, BFu9s_Ui_Ip)
//============================================================================



static void Test_BFu9s_Ui_L()
{
  {
    init_simple_test("BFu9s_Ui_L");
    static STRUCT_IF_C BFu9s_Ui_L lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_L");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_L.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_L, BFu9s_Ui_L)
//============================================================================



static void Test_BFu9s_Ui_S()
{
  {
    init_simple_test("BFu9s_Ui_S");
    static STRUCT_IF_C BFu9s_Ui_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_S");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_S.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_S, BFu9s_Ui_S)
//============================================================================



static void Test_BFu9s_Ui_Uc()
{
  {
    init_simple_test("BFu9s_Ui_Uc");
    static STRUCT_IF_C BFu9s_Ui_Uc lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_Uc, BFu9s_Ui_Uc)
//============================================================================



static void Test_BFu9s_Ui_Ui()
{
  {
    init_simple_test("BFu9s_Ui_Ui");
    static STRUCT_IF_C BFu9s_Ui_Ui lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_Ui.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_Ui, BFu9s_Ui_Ui)
//============================================================================



static void Test_BFu9s_Ui_Ul()
{
  {
    init_simple_test("BFu9s_Ui_Ul");
    static STRUCT_IF_C BFu9s_Ui_Ul lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_Ul.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_Ul, BFu9s_Ui_Ul)
//============================================================================



static void Test_BFu9s_Ui_Us()
{
  {
    init_simple_test("BFu9s_Ui_Us");
    static STRUCT_IF_C BFu9s_Ui_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_Us.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_Us, BFu9s_Ui_Us)
//============================================================================



static void Test_BFu9s_Ui_Vp()
{
  {
    init_simple_test("BFu9s_Ui_Vp");
    static STRUCT_IF_C BFu9s_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ui_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Ui_Vp.v2");
    check_field_offset(lv, v3, 6, "BFu9s_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ui_Vp, BFu9s_Ui_Vp)
//============================================================================



static void Test_BFu9s_Ul()
{
  {
    init_simple_test("BFu9s_Ul");
    static STRUCT_IF_C BFu9s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul, BFu9s_Ul)
//============================================================================



static void Test_BFu9s_Ul_BFu15i()
{
  {
    init_simple_test("BFu9s_Ul_BFu15i");
    static STRUCT_IF_C BFu9s_Ul_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu9s_Ul_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu9s_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu15i, BFu9s_Ul_BFu15i)
//============================================================================



static void Test_BFu9s_Ul_BFu15ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu15ll");
    static STRUCT_IF_C BFu9s_Ul_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu9s_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu9s_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu15ll, BFu9s_Ul_BFu15ll)
//============================================================================



static void Test_BFu9s_Ul_BFu15s()
{
  {
    init_simple_test("BFu9s_Ul_BFu15s");
    static STRUCT_IF_C BFu9s_Ul_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu9s_Ul_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu9s_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu15s, BFu9s_Ul_BFu15s)
//============================================================================



static void Test_BFu9s_Ul_BFu16i()
{
  {
    init_simple_test("BFu9s_Ul_BFu16i");
    static STRUCT_IF_C BFu9s_Ul_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu9s_Ul_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu9s_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu16i, BFu9s_Ul_BFu16i)
//============================================================================



static void Test_BFu9s_Ul_BFu16ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu16ll");
    static STRUCT_IF_C BFu9s_Ul_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu9s_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu9s_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu16ll, BFu9s_Ul_BFu16ll)
//============================================================================



static void Test_BFu9s_Ul_BFu16s()
{
  {
    init_simple_test("BFu9s_Ul_BFu16s");
    static STRUCT_IF_C BFu9s_Ul_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu9s_Ul_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu9s_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu16s, BFu9s_Ul_BFu16s)
//============================================================================



static void Test_BFu9s_Ul_BFu17i()
{
  {
    init_simple_test("BFu9s_Ul_BFu17i");
    static STRUCT_IF_C BFu9s_Ul_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(BFu9s_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu9s_Ul_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu9s_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu17i, BFu9s_Ul_BFu17i)
//============================================================================



static void Test_BFu9s_Ul_BFu17ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu17ll");
    static STRUCT_IF_C BFu9s_Ul_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu9s_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu9s_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu9s_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu17ll, BFu9s_Ul_BFu17ll)
//============================================================================



static void Test_BFu9s_Ul_BFu1c()
{
  {
    init_simple_test("BFu9s_Ul_BFu1c");
    static STRUCT_IF_C BFu9s_Ul_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu1c, BFu9s_Ul_BFu1c)
//============================================================================



static void Test_BFu9s_Ul_BFu1i()
{
  {
    init_simple_test("BFu9s_Ul_BFu1i");
    static STRUCT_IF_C BFu9s_Ul_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu1i, BFu9s_Ul_BFu1i)
//============================================================================



static void Test_BFu9s_Ul_BFu1ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu1ll");
    static STRUCT_IF_C BFu9s_Ul_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu1ll, BFu9s_Ul_BFu1ll)
//============================================================================



static void Test_BFu9s_Ul_BFu1s()
{
  {
    init_simple_test("BFu9s_Ul_BFu1s");
    static STRUCT_IF_C BFu9s_Ul_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu9s_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu1s, BFu9s_Ul_BFu1s)
//============================================================================



static void Test_BFu9s_Ul_BFu31i()
{
  {
    init_simple_test("BFu9s_Ul_BFu31i");
    static STRUCT_IF_C BFu9s_Ul_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu9s_Ul_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu9s_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu31i, BFu9s_Ul_BFu31i)
//============================================================================



static void Test_BFu9s_Ul_BFu31ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu31ll");
    static STRUCT_IF_C BFu9s_Ul_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu9s_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu9s_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu31ll, BFu9s_Ul_BFu31ll)
//============================================================================



static void Test_BFu9s_Ul_BFu32i()
{
  {
    init_simple_test("BFu9s_Ul_BFu32i");
    static STRUCT_IF_C BFu9s_Ul_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu9s_Ul_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu9s_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu32i, BFu9s_Ul_BFu32i)
//============================================================================



static void Test_BFu9s_Ul_BFu32ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu32ll");
    static STRUCT_IF_C BFu9s_Ul_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu9s_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu9s_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu32ll, BFu9s_Ul_BFu32ll)
//============================================================================



static void Test_BFu9s_Ul_BFu33()
{
  {
    init_simple_test("BFu9s_Ul_BFu33");
    static STRUCT_IF_C BFu9s_Ul_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(BFu9s_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "BFu9s_Ul_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "BFu9s_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu33, BFu9s_Ul_BFu33)
//============================================================================



static void Test_BFu9s_Ul_BFu7c()
{
  {
    init_simple_test("BFu9s_Ul_BFu7c");
    static STRUCT_IF_C BFu9s_Ul_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_Ul_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu7c, BFu9s_Ul_BFu7c)
//============================================================================



static void Test_BFu9s_Ul_BFu7i()
{
  {
    init_simple_test("BFu9s_Ul_BFu7i");
    static STRUCT_IF_C BFu9s_Ul_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_Ul_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu7i, BFu9s_Ul_BFu7i)
//============================================================================



static void Test_BFu9s_Ul_BFu7ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu7ll");
    static STRUCT_IF_C BFu9s_Ul_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu7ll, BFu9s_Ul_BFu7ll)
//============================================================================



static void Test_BFu9s_Ul_BFu7s()
{
  {
    init_simple_test("BFu9s_Ul_BFu7s");
    static STRUCT_IF_C BFu9s_Ul_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu9s_Ul_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu9s_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu7s, BFu9s_Ul_BFu7s)
//============================================================================



static void Test_BFu9s_Ul_BFu8c()
{
  {
    init_simple_test("BFu9s_Ul_BFu8c");
    static STRUCT_IF_C BFu9s_Ul_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_Ul_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu8c, BFu9s_Ul_BFu8c)
//============================================================================



static void Test_BFu9s_Ul_BFu8i()
{
  {
    init_simple_test("BFu9s_Ul_BFu8i");
    static STRUCT_IF_C BFu9s_Ul_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_Ul_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu8i, BFu9s_Ul_BFu8i)
//============================================================================



static void Test_BFu9s_Ul_BFu8ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu8ll");
    static STRUCT_IF_C BFu9s_Ul_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu8ll, BFu9s_Ul_BFu8ll)
//============================================================================



static void Test_BFu9s_Ul_BFu8s()
{
  {
    init_simple_test("BFu9s_Ul_BFu8s");
    static STRUCT_IF_C BFu9s_Ul_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu9s_Ul_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu9s_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu8s, BFu9s_Ul_BFu8s)
//============================================================================



static void Test_BFu9s_Ul_BFu9i()
{
  {
    init_simple_test("BFu9s_Ul_BFu9i");
    static STRUCT_IF_C BFu9s_Ul_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu9s_Ul_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu9i, BFu9s_Ul_BFu9i)
//============================================================================



static void Test_BFu9s_Ul_BFu9ll()
{
  {
    init_simple_test("BFu9s_Ul_BFu9ll");
    static STRUCT_IF_C BFu9s_Ul_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu9s_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu9ll, BFu9s_Ul_BFu9ll)
//============================================================================



static void Test_BFu9s_Ul_BFu9s()
{
  {
    init_simple_test("BFu9s_Ul_BFu9s");
    static STRUCT_IF_C BFu9s_Ul_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu9s_Ul_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_BFu9s, BFu9s_Ul_BFu9s)
//============================================================================



static void Test_BFu9s_Ul_C()
{
  {
    init_simple_test("BFu9s_Ul_C");
    static STRUCT_IF_C BFu9s_Ul_C lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_C");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_C.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_C, BFu9s_Ul_C)
//============================================================================



static void Test_BFu9s_Ul_D()
{
  {
    init_simple_test("BFu9s_Ul_D");
    static STRUCT_IF_C BFu9s_Ul_D lv;
    check2(sizeof(lv), 18, "sizeof(BFu9s_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_D");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_D.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_D, BFu9s_Ul_D)
//============================================================================



static void Test_BFu9s_Ul_F()
{
  {
    init_simple_test("BFu9s_Ul_F");
    static STRUCT_IF_C BFu9s_Ul_F lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_F");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_F.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_F, BFu9s_Ul_F)
//============================================================================



static void Test_BFu9s_Ul_I()
{
  {
    init_simple_test("BFu9s_Ul_I");
    static STRUCT_IF_C BFu9s_Ul_I lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_I");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_I.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_I, BFu9s_Ul_I)
//============================================================================



static void Test_BFu9s_Ul_Ip()
{
  {
    init_simple_test("BFu9s_Ul_Ip");
    static STRUCT_IF_C BFu9s_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_Ip.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_Ip, BFu9s_Ul_Ip)
//============================================================================



static void Test_BFu9s_Ul_L()
{
  {
    init_simple_test("BFu9s_Ul_L");
    static STRUCT_IF_C BFu9s_Ul_L lv;
    check2(sizeof(lv), 18, "sizeof(BFu9s_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_L");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_L.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_L, BFu9s_Ul_L)
//============================================================================



static void Test_BFu9s_Ul_S()
{
  {
    init_simple_test("BFu9s_Ul_S");
    static STRUCT_IF_C BFu9s_Ul_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_S");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_S.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_S, BFu9s_Ul_S)
//============================================================================



static void Test_BFu9s_Ul_Uc()
{
  {
    init_simple_test("BFu9s_Ul_Uc");
    static STRUCT_IF_C BFu9s_Ul_Uc lv;
    check2(sizeof(lv), 11, "sizeof(BFu9s_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_Uc.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_Uc, BFu9s_Ul_Uc)
//============================================================================



static void Test_BFu9s_Ul_Ui()
{
  {
    init_simple_test("BFu9s_Ul_Ui");
    static STRUCT_IF_C BFu9s_Ul_Ui lv;
    check2(sizeof(lv), 14, "sizeof(BFu9s_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_Ui.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_Ui, BFu9s_Ul_Ui)
//============================================================================



static void Test_BFu9s_Ul_Ul()
{
  {
    init_simple_test("BFu9s_Ul_Ul");
    static STRUCT_IF_C BFu9s_Ul_Ul lv;
    check2(sizeof(lv), 18, "sizeof(BFu9s_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_Ul.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_Ul, BFu9s_Ul_Ul)
//============================================================================



static void Test_BFu9s_Ul_Us()
{
  {
    init_simple_test("BFu9s_Ul_Us");
    static STRUCT_IF_C BFu9s_Ul_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_Us.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_Us, BFu9s_Ul_Us)
//============================================================================



static void Test_BFu9s_Ul_Vp()
{
  {
    init_simple_test("BFu9s_Ul_Vp");
    static STRUCT_IF_C BFu9s_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Ul_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Ul_Vp.v2");
    check_field_offset(lv, v3, 10, "BFu9s_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Ul_Vp, BFu9s_Ul_Vp)
//============================================================================



static void Test_BFu9s_Us()
{
  {
    init_simple_test("BFu9s_Us");
    static STRUCT_IF_C BFu9s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us, BFu9s_Us)
//============================================================================



static void Test_BFu9s_Us_BFu15i()
{
  {
    init_simple_test("BFu9s_Us_BFu15i");
    static STRUCT_IF_C BFu9s_Us_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_Us_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu15i, BFu9s_Us_BFu15i)
//============================================================================



static void Test_BFu9s_Us_BFu15ll()
{
  {
    init_simple_test("BFu9s_Us_BFu15ll");
    static STRUCT_IF_C BFu9s_Us_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_Us_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu15ll, BFu9s_Us_BFu15ll)
//============================================================================



static void Test_BFu9s_Us_BFu15s()
{
  {
    init_simple_test("BFu9s_Us_BFu15s");
    static STRUCT_IF_C BFu9s_Us_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_Us_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu15s, BFu9s_Us_BFu15s)
//============================================================================



static void Test_BFu9s_Us_BFu16i()
{
  {
    init_simple_test("BFu9s_Us_BFu16i");
    static STRUCT_IF_C BFu9s_Us_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_Us_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu16i, BFu9s_Us_BFu16i)
//============================================================================



static void Test_BFu9s_Us_BFu16ll()
{
  {
    init_simple_test("BFu9s_Us_BFu16ll");
    static STRUCT_IF_C BFu9s_Us_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_Us_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu16ll, BFu9s_Us_BFu16ll)
//============================================================================



static void Test_BFu9s_Us_BFu16s()
{
  {
    init_simple_test("BFu9s_Us_BFu16s");
    static STRUCT_IF_C BFu9s_Us_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_Us_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu16s, BFu9s_Us_BFu16s)
//============================================================================



static void Test_BFu9s_Us_BFu17i()
{
  {
    init_simple_test("BFu9s_Us_BFu17i");
    static STRUCT_IF_C BFu9s_Us_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9s_Us_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9s_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu17i, BFu9s_Us_BFu17i)
//============================================================================



static void Test_BFu9s_Us_BFu17ll()
{
  {
    init_simple_test("BFu9s_Us_BFu17ll");
    static STRUCT_IF_C BFu9s_Us_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu9s_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9s_Us_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9s_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu17ll, BFu9s_Us_BFu17ll)
//============================================================================



static void Test_BFu9s_Us_BFu1c()
{
  {
    init_simple_test("BFu9s_Us_BFu1c");
    static STRUCT_IF_C BFu9s_Us_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu1c, BFu9s_Us_BFu1c)
//============================================================================



static void Test_BFu9s_Us_BFu1i()
{
  {
    init_simple_test("BFu9s_Us_BFu1i");
    static STRUCT_IF_C BFu9s_Us_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu1i, BFu9s_Us_BFu1i)
//============================================================================



static void Test_BFu9s_Us_BFu1ll()
{
  {
    init_simple_test("BFu9s_Us_BFu1ll");
    static STRUCT_IF_C BFu9s_Us_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu1ll, BFu9s_Us_BFu1ll)
//============================================================================



static void Test_BFu9s_Us_BFu1s()
{
  {
    init_simple_test("BFu9s_Us_BFu1s");
    static STRUCT_IF_C BFu9s_Us_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu9s_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu1s, BFu9s_Us_BFu1s)
//============================================================================



static void Test_BFu9s_Us_BFu31i()
{
  {
    init_simple_test("BFu9s_Us_BFu31i");
    static STRUCT_IF_C BFu9s_Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9s_Us_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9s_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu31i, BFu9s_Us_BFu31i)
//============================================================================



static void Test_BFu9s_Us_BFu31ll()
{
  {
    init_simple_test("BFu9s_Us_BFu31ll");
    static STRUCT_IF_C BFu9s_Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9s_Us_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9s_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu31ll, BFu9s_Us_BFu31ll)
//============================================================================



static void Test_BFu9s_Us_BFu32i()
{
  {
    init_simple_test("BFu9s_Us_BFu32i");
    static STRUCT_IF_C BFu9s_Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9s_Us_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9s_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu32i, BFu9s_Us_BFu32i)
//============================================================================



static void Test_BFu9s_Us_BFu32ll()
{
  {
    init_simple_test("BFu9s_Us_BFu32ll");
    static STRUCT_IF_C BFu9s_Us_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9s_Us_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9s_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu32ll, BFu9s_Us_BFu32ll)
//============================================================================



static void Test_BFu9s_Us_BFu33()
{
  {
    init_simple_test("BFu9s_Us_BFu33");
    static STRUCT_IF_C BFu9s_Us_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu9s_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu9s_Us_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu9s_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu33, BFu9s_Us_BFu33)
//============================================================================



static void Test_BFu9s_Us_BFu7c()
{
  {
    init_simple_test("BFu9s_Us_BFu7c");
    static STRUCT_IF_C BFu9s_Us_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_Us_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu7c, BFu9s_Us_BFu7c)
//============================================================================



static void Test_BFu9s_Us_BFu7i()
{
  {
    init_simple_test("BFu9s_Us_BFu7i");
    static STRUCT_IF_C BFu9s_Us_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_Us_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu7i, BFu9s_Us_BFu7i)
//============================================================================



static void Test_BFu9s_Us_BFu7ll()
{
  {
    init_simple_test("BFu9s_Us_BFu7ll");
    static STRUCT_IF_C BFu9s_Us_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_Us_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu7ll, BFu9s_Us_BFu7ll)
//============================================================================



static void Test_BFu9s_Us_BFu7s()
{
  {
    init_simple_test("BFu9s_Us_BFu7s");
    static STRUCT_IF_C BFu9s_Us_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu9s_Us_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu9s_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu7s, BFu9s_Us_BFu7s)
//============================================================================



static void Test_BFu9s_Us_BFu8c()
{
  {
    init_simple_test("BFu9s_Us_BFu8c");
    static STRUCT_IF_C BFu9s_Us_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_Us_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu8c, BFu9s_Us_BFu8c)
//============================================================================



static void Test_BFu9s_Us_BFu8i()
{
  {
    init_simple_test("BFu9s_Us_BFu8i");
    static STRUCT_IF_C BFu9s_Us_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_Us_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu8i, BFu9s_Us_BFu8i)
//============================================================================



static void Test_BFu9s_Us_BFu8ll()
{
  {
    init_simple_test("BFu9s_Us_BFu8ll");
    static STRUCT_IF_C BFu9s_Us_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_Us_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu8ll, BFu9s_Us_BFu8ll)
//============================================================================



static void Test_BFu9s_Us_BFu8s()
{
  {
    init_simple_test("BFu9s_Us_BFu8s");
    static STRUCT_IF_C BFu9s_Us_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu9s_Us_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu9s_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu8s, BFu9s_Us_BFu8s)
//============================================================================



static void Test_BFu9s_Us_BFu9i()
{
  {
    init_simple_test("BFu9s_Us_BFu9i");
    static STRUCT_IF_C BFu9s_Us_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_Us_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu9i, BFu9s_Us_BFu9i)
//============================================================================



static void Test_BFu9s_Us_BFu9ll()
{
  {
    init_simple_test("BFu9s_Us_BFu9ll");
    static STRUCT_IF_C BFu9s_Us_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_Us_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu9ll, BFu9s_Us_BFu9ll)
//============================================================================



static void Test_BFu9s_Us_BFu9s()
{
  {
    init_simple_test("BFu9s_Us_BFu9s");
    static STRUCT_IF_C BFu9s_Us_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_Us_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_BFu9s, BFu9s_Us_BFu9s)
//============================================================================



static void Test_BFu9s_Us_C()
{
  {
    init_simple_test("BFu9s_Us_C");
    static STRUCT_IF_C BFu9s_Us_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_C");
    check_field_offset(lv, v2, 2, "BFu9s_Us_C.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_C, BFu9s_Us_C)
//============================================================================



static void Test_BFu9s_Us_D()
{
  {
    init_simple_test("BFu9s_Us_D");
    static STRUCT_IF_C BFu9s_Us_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_D");
    check_field_offset(lv, v2, 2, "BFu9s_Us_D.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_D, BFu9s_Us_D)
//============================================================================



static void Test_BFu9s_Us_F()
{
  {
    init_simple_test("BFu9s_Us_F");
    static STRUCT_IF_C BFu9s_Us_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_F");
    check_field_offset(lv, v2, 2, "BFu9s_Us_F.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_F, BFu9s_Us_F)
//============================================================================



static void Test_BFu9s_Us_I()
{
  {
    init_simple_test("BFu9s_Us_I");
    static STRUCT_IF_C BFu9s_Us_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_I");
    check_field_offset(lv, v2, 2, "BFu9s_Us_I.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_I, BFu9s_Us_I)
//============================================================================



static void Test_BFu9s_Us_Ip()
{
  {
    init_simple_test("BFu9s_Us_Ip");
    static STRUCT_IF_C BFu9s_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_Us_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_Ip, BFu9s_Us_Ip)
//============================================================================



static void Test_BFu9s_Us_L()
{
  {
    init_simple_test("BFu9s_Us_L");
    static STRUCT_IF_C BFu9s_Us_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_L");
    check_field_offset(lv, v2, 2, "BFu9s_Us_L.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_L, BFu9s_Us_L)
//============================================================================



static void Test_BFu9s_Us_S()
{
  {
    init_simple_test("BFu9s_Us_S");
    static STRUCT_IF_C BFu9s_Us_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_S");
    check_field_offset(lv, v2, 2, "BFu9s_Us_S.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_S, BFu9s_Us_S)
//============================================================================



static void Test_BFu9s_Us_Uc()
{
  {
    init_simple_test("BFu9s_Us_Uc");
    static STRUCT_IF_C BFu9s_Us_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu9s_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Us_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_Uc, BFu9s_Us_Uc)
//============================================================================



static void Test_BFu9s_Us_Ui()
{
  {
    init_simple_test("BFu9s_Us_Ui");
    static STRUCT_IF_C BFu9s_Us_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Us_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_Ui, BFu9s_Us_Ui)
//============================================================================



static void Test_BFu9s_Us_Ul()
{
  {
    init_simple_test("BFu9s_Us_Ul");
    static STRUCT_IF_C BFu9s_Us_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Us_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_Ul, BFu9s_Us_Ul)
//============================================================================



static void Test_BFu9s_Us_Us()
{
  {
    init_simple_test("BFu9s_Us_Us");
    static STRUCT_IF_C BFu9s_Us_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Us_Us.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_Us, BFu9s_Us_Us)
//============================================================================



static void Test_BFu9s_Us_Vp()
{
  {
    init_simple_test("BFu9s_Us_Vp");
    static STRUCT_IF_C BFu9s_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Us_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Us_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Us_Vp, BFu9s_Us_Vp)
//============================================================================



static void Test_BFu9s_Vp()
{
  {
    init_simple_test("BFu9s_Vp");
    static STRUCT_IF_C BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp, BFu9s_Vp)
//============================================================================



static void Test_BFu9s_Vp_BFu15i()
{
  {
    init_simple_test("BFu9s_Vp_BFu15i");
    static STRUCT_IF_C BFu9s_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu9s_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu9s_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu15i, BFu9s_Vp_BFu15i)
//============================================================================



static void Test_BFu9s_Vp_BFu15ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu15ll");
    static STRUCT_IF_C BFu9s_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu9s_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu9s_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu15ll, BFu9s_Vp_BFu15ll)
//============================================================================



static void Test_BFu9s_Vp_BFu15s()
{
  {
    init_simple_test("BFu9s_Vp_BFu15s");
    static STRUCT_IF_C BFu9s_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu9s_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu9s_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu15s, BFu9s_Vp_BFu15s)
//============================================================================



static void Test_BFu9s_Vp_BFu16i()
{
  {
    init_simple_test("BFu9s_Vp_BFu16i");
    static STRUCT_IF_C BFu9s_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu9s_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu9s_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu16i, BFu9s_Vp_BFu16i)
//============================================================================



static void Test_BFu9s_Vp_BFu16ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu16ll");
    static STRUCT_IF_C BFu9s_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu9s_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu9s_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu16ll, BFu9s_Vp_BFu16ll)
//============================================================================



static void Test_BFu9s_Vp_BFu16s()
{
  {
    init_simple_test("BFu9s_Vp_BFu16s");
    static STRUCT_IF_C BFu9s_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu9s_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu9s_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu16s, BFu9s_Vp_BFu16s)
//============================================================================



static void Test_BFu9s_Vp_BFu17i()
{
  {
    init_simple_test("BFu9s_Vp_BFu17i");
    static STRUCT_IF_C BFu9s_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu9s_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu9s_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu9s_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu17i, BFu9s_Vp_BFu17i)
//============================================================================



static void Test_BFu9s_Vp_BFu17ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu17ll");
    static STRUCT_IF_C BFu9s_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu9s_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu9s_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu9s_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu17ll, BFu9s_Vp_BFu17ll)
//============================================================================



static void Test_BFu9s_Vp_BFu1c()
{
  {
    init_simple_test("BFu9s_Vp_BFu1c");
    static STRUCT_IF_C BFu9s_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu1c, BFu9s_Vp_BFu1c)
//============================================================================



static void Test_BFu9s_Vp_BFu1i()
{
  {
    init_simple_test("BFu9s_Vp_BFu1i");
    static STRUCT_IF_C BFu9s_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu1i, BFu9s_Vp_BFu1i)
//============================================================================



static void Test_BFu9s_Vp_BFu1ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu1ll");
    static STRUCT_IF_C BFu9s_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu1ll, BFu9s_Vp_BFu1ll)
//============================================================================



static void Test_BFu9s_Vp_BFu1s()
{
  {
    init_simple_test("BFu9s_Vp_BFu1s");
    static STRUCT_IF_C BFu9s_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu9s_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu1s, BFu9s_Vp_BFu1s)
//============================================================================



static void Test_BFu9s_Vp_BFu31i()
{
  {
    init_simple_test("BFu9s_Vp_BFu31i");
    static STRUCT_IF_C BFu9s_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu9s_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu9s_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu31i, BFu9s_Vp_BFu31i)
//============================================================================



static void Test_BFu9s_Vp_BFu31ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu31ll");
    static STRUCT_IF_C BFu9s_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu9s_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu9s_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu31ll, BFu9s_Vp_BFu31ll)
//============================================================================



static void Test_BFu9s_Vp_BFu32i()
{
  {
    init_simple_test("BFu9s_Vp_BFu32i");
    static STRUCT_IF_C BFu9s_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu9s_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu9s_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu32i, BFu9s_Vp_BFu32i)
//============================================================================



static void Test_BFu9s_Vp_BFu32ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu32ll");
    static STRUCT_IF_C BFu9s_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu9s_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu9s_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu32ll, BFu9s_Vp_BFu32ll)
//============================================================================



static void Test_BFu9s_Vp_BFu33()
{
  {
    init_simple_test("BFu9s_Vp_BFu33");
    static STRUCT_IF_C BFu9s_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(BFu9s_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "BFu9s_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "BFu9s_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu33, BFu9s_Vp_BFu33)
//============================================================================



static void Test_BFu9s_Vp_BFu7c()
{
  {
    init_simple_test("BFu9s_Vp_BFu7c");
    static STRUCT_IF_C BFu9s_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu7c, BFu9s_Vp_BFu7c)
//============================================================================



static void Test_BFu9s_Vp_BFu7i()
{
  {
    init_simple_test("BFu9s_Vp_BFu7i");
    static STRUCT_IF_C BFu9s_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu7i, BFu9s_Vp_BFu7i)
//============================================================================



static void Test_BFu9s_Vp_BFu7ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu7ll");
    static STRUCT_IF_C BFu9s_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu7ll, BFu9s_Vp_BFu7ll)
//============================================================================



static void Test_BFu9s_Vp_BFu7s()
{
  {
    init_simple_test("BFu9s_Vp_BFu7s");
    static STRUCT_IF_C BFu9s_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu9s_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu9s_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu7s, BFu9s_Vp_BFu7s)
//============================================================================



static void Test_BFu9s_Vp_BFu8c()
{
  {
    init_simple_test("BFu9s_Vp_BFu8c");
    static STRUCT_IF_C BFu9s_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu8c, BFu9s_Vp_BFu8c)
//============================================================================



static void Test_BFu9s_Vp_BFu8i()
{
  {
    init_simple_test("BFu9s_Vp_BFu8i");
    static STRUCT_IF_C BFu9s_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu8i, BFu9s_Vp_BFu8i)
//============================================================================



static void Test_BFu9s_Vp_BFu8ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu8ll");
    static STRUCT_IF_C BFu9s_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu8ll, BFu9s_Vp_BFu8ll)
//============================================================================



static void Test_BFu9s_Vp_BFu8s()
{
  {
    init_simple_test("BFu9s_Vp_BFu8s");
    static STRUCT_IF_C BFu9s_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu9s_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu9s_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu8s, BFu9s_Vp_BFu8s)
//============================================================================



static void Test_BFu9s_Vp_BFu9i()
{
  {
    init_simple_test("BFu9s_Vp_BFu9i");
    static STRUCT_IF_C BFu9s_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu9s_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu9i, BFu9s_Vp_BFu9i)
//============================================================================



static void Test_BFu9s_Vp_BFu9ll()
{
  {
    init_simple_test("BFu9s_Vp_BFu9ll");
    static STRUCT_IF_C BFu9s_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu9s_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu9ll, BFu9s_Vp_BFu9ll)
//============================================================================



static void Test_BFu9s_Vp_BFu9s()
{
  {
    init_simple_test("BFu9s_Vp_BFu9s");
    static STRUCT_IF_C BFu9s_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu9s_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_BFu9s, BFu9s_Vp_BFu9s)
//============================================================================



static void Test_BFu9s_Vp_C()
{
  {
    init_simple_test("BFu9s_Vp_C");
    static STRUCT_IF_C BFu9s_Vp_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_C");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_C, BFu9s_Vp_C)
//============================================================================



static void Test_BFu9s_Vp_D()
{
  {
    init_simple_test("BFu9s_Vp_D");
    static STRUCT_IF_C BFu9s_Vp_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_D");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_D, BFu9s_Vp_D)
//============================================================================



static void Test_BFu9s_Vp_F()
{
  {
    init_simple_test("BFu9s_Vp_F");
    static STRUCT_IF_C BFu9s_Vp_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_F");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_F, BFu9s_Vp_F)
//============================================================================



static void Test_BFu9s_Vp_I()
{
  {
    init_simple_test("BFu9s_Vp_I");
    static STRUCT_IF_C BFu9s_Vp_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_I");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_I, BFu9s_Vp_I)
//============================================================================



static void Test_BFu9s_Vp_Ip()
{
  {
    init_simple_test("BFu9s_Vp_Ip");
    static STRUCT_IF_C BFu9s_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu9s_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_Ip, BFu9s_Vp_Ip)
//============================================================================



static void Test_BFu9s_Vp_L()
{
  {
    init_simple_test("BFu9s_Vp_L");
    static STRUCT_IF_C BFu9s_Vp_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_L");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_L, BFu9s_Vp_L)
//============================================================================



static void Test_BFu9s_Vp_S()
{
  {
    init_simple_test("BFu9s_Vp_S");
    static STRUCT_IF_C BFu9s_Vp_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_S");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_S, BFu9s_Vp_S)
//============================================================================



static void Test_BFu9s_Vp_Uc()
{
  {
    init_simple_test("BFu9s_Vp_Uc");
    static STRUCT_IF_C BFu9s_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu9s_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_Uc, BFu9s_Vp_Uc)
//============================================================================



static void Test_BFu9s_Vp_Ui()
{
  {
    init_simple_test("BFu9s_Vp_Ui");
    static STRUCT_IF_C BFu9s_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu9s_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_Ui, BFu9s_Vp_Ui)
//============================================================================



static void Test_BFu9s_Vp_Ul()
{
  {
    init_simple_test("BFu9s_Vp_Ul");
    static STRUCT_IF_C BFu9s_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu9s_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_Ul, BFu9s_Vp_Ul)
//============================================================================



static void Test_BFu9s_Vp_Us()
{
  {
    init_simple_test("BFu9s_Vp_Us");
    static STRUCT_IF_C BFu9s_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu9s_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_Us");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_Us, BFu9s_Vp_Us)
//============================================================================



static void Test_BFu9s_Vp_Vp()
{
  {
    init_simple_test("BFu9s_Vp_Vp");
    static STRUCT_IF_C BFu9s_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu9s_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9s_Vp_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9s_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9s_Vp_Vp, BFu9s_Vp_Vp)
//============================================================================



static void Test_C()
{
  {
    init_simple_test("C");
    STRUCT_IF_C C lv;
    check2(sizeof(lv), 1, "sizeof(C)");
    check2(__alignof__(lv), 1, "__alignof__(C)");
    check_field_offset(lv, v1, 0, "C.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_C, C)
//============================================================================



static void Test_C_BFu15i()
{
  {
    init_simple_test("C_BFu15i");
    static STRUCT_IF_C C_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i, C_BFu15i)
//============================================================================



static void Test_C_BFu15i_BFu15i()
{
  {
    init_simple_test("C_BFu15i_BFu15i");
    static STRUCT_IF_C C_BFu15i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu15i, C_BFu15i_BFu15i)
//============================================================================



static void Test_C_BFu15i_BFu15ll()
{
  {
    init_simple_test("C_BFu15i_BFu15ll");
    static STRUCT_IF_C C_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu15ll, C_BFu15i_BFu15ll)
//============================================================================



static void Test_C_BFu15i_BFu15s()
{
  {
    init_simple_test("C_BFu15i_BFu15s");
    static STRUCT_IF_C C_BFu15i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu15s, C_BFu15i_BFu15s)
//============================================================================



static void Test_C_BFu15i_BFu16i()
{
  {
    init_simple_test("C_BFu15i_BFu16i");
    static STRUCT_IF_C C_BFu15i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu16i, C_BFu15i_BFu16i)
//============================================================================



static void Test_C_BFu15i_BFu16ll()
{
  {
    init_simple_test("C_BFu15i_BFu16ll");
    static STRUCT_IF_C C_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu16ll, C_BFu15i_BFu16ll)
//============================================================================



static void Test_C_BFu15i_BFu16s()
{
  {
    init_simple_test("C_BFu15i_BFu16s");
    static STRUCT_IF_C C_BFu15i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu16s, C_BFu15i_BFu16s)
//============================================================================



static void Test_C_BFu15i_BFu17i()
{
  {
    init_simple_test("C_BFu15i_BFu17i");
    static STRUCT_IF_C C_BFu15i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "C_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "C_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu17i, C_BFu15i_BFu17i)
//============================================================================



static void Test_C_BFu15i_BFu17ll()
{
  {
    init_simple_test("C_BFu15i_BFu17ll");
    static STRUCT_IF_C C_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "C_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "C_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu17ll, C_BFu15i_BFu17ll)
//============================================================================



static void Test_C_BFu15i_BFu1c()
{
  {
    init_simple_test("C_BFu15i_BFu1c");
    static STRUCT_IF_C C_BFu15i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu1c, C_BFu15i_BFu1c)
//============================================================================



static void Test_C_BFu15i_BFu1i()
{
  {
    init_simple_test("C_BFu15i_BFu1i");
    static STRUCT_IF_C C_BFu15i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu1i, C_BFu15i_BFu1i)
//============================================================================



static void Test_C_BFu15i_BFu1ll()
{
  {
    init_simple_test("C_BFu15i_BFu1ll");
    static STRUCT_IF_C C_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu1ll, C_BFu15i_BFu1ll)
//============================================================================



static void Test_C_BFu15i_BFu1s()
{
  {
    init_simple_test("C_BFu15i_BFu1s");
    static STRUCT_IF_C C_BFu15i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu1s, C_BFu15i_BFu1s)
//============================================================================



static void Test_C_BFu15i_BFu31i()
{
  {
    init_simple_test("C_BFu15i_BFu31i");
    static STRUCT_IF_C C_BFu15i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "C_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "C_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu31i, C_BFu15i_BFu31i)
//============================================================================



static void Test_C_BFu15i_BFu31ll()
{
  {
    init_simple_test("C_BFu15i_BFu31ll");
    static STRUCT_IF_C C_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "C_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "C_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu31ll, C_BFu15i_BFu31ll)
//============================================================================



static void Test_C_BFu15i_BFu32i()
{
  {
    init_simple_test("C_BFu15i_BFu32i");
    static STRUCT_IF_C C_BFu15i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "C_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "C_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu32i, C_BFu15i_BFu32i)
//============================================================================



static void Test_C_BFu15i_BFu32ll()
{
  {
    init_simple_test("C_BFu15i_BFu32ll");
    static STRUCT_IF_C C_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "C_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "C_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu32ll, C_BFu15i_BFu32ll)
//============================================================================



static void Test_C_BFu15i_BFu33()
{
  {
    init_simple_test("C_BFu15i_BFu33");
    static STRUCT_IF_C C_BFu15i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "C_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "C_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu33, C_BFu15i_BFu33)
//============================================================================



static void Test_C_BFu15i_BFu7c()
{
  {
    init_simple_test("C_BFu15i_BFu7c");
    static STRUCT_IF_C C_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu7c, C_BFu15i_BFu7c)
//============================================================================



static void Test_C_BFu15i_BFu7i()
{
  {
    init_simple_test("C_BFu15i_BFu7i");
    static STRUCT_IF_C C_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu7i, C_BFu15i_BFu7i)
//============================================================================



static void Test_C_BFu15i_BFu7ll()
{
  {
    init_simple_test("C_BFu15i_BFu7ll");
    static STRUCT_IF_C C_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu7ll, C_BFu15i_BFu7ll)
//============================================================================



static void Test_C_BFu15i_BFu7s()
{
  {
    init_simple_test("C_BFu15i_BFu7s");
    static STRUCT_IF_C C_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu7s, C_BFu15i_BFu7s)
//============================================================================



static void Test_C_BFu15i_BFu8c()
{
  {
    init_simple_test("C_BFu15i_BFu8c");
    static STRUCT_IF_C C_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu8c, C_BFu15i_BFu8c)
//============================================================================



static void Test_C_BFu15i_BFu8i()
{
  {
    init_simple_test("C_BFu15i_BFu8i");
    static STRUCT_IF_C C_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu8i, C_BFu15i_BFu8i)
//============================================================================



static void Test_C_BFu15i_BFu8ll()
{
  {
    init_simple_test("C_BFu15i_BFu8ll");
    static STRUCT_IF_C C_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu8ll, C_BFu15i_BFu8ll)
//============================================================================



static void Test_C_BFu15i_BFu8s()
{
  {
    init_simple_test("C_BFu15i_BFu8s");
    static STRUCT_IF_C C_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu8s, C_BFu15i_BFu8s)
//============================================================================



static void Test_C_BFu15i_BFu9i()
{
  {
    init_simple_test("C_BFu15i_BFu9i");
    static STRUCT_IF_C C_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu9i, C_BFu15i_BFu9i)
//============================================================================



static void Test_C_BFu15i_BFu9ll()
{
  {
    init_simple_test("C_BFu15i_BFu9ll");
    static STRUCT_IF_C C_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu9ll, C_BFu15i_BFu9ll)
//============================================================================



static void Test_C_BFu15i_BFu9s()
{
  {
    init_simple_test("C_BFu15i_BFu9s");
    static STRUCT_IF_C C_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_BFu9s, C_BFu15i_BFu9s)
//============================================================================



static void Test_C_BFu15i_C()
{
  {
    init_simple_test("C_BFu15i_C");
    static STRUCT_IF_C C_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_C)");
    check_field_offset(lv, v1, 0, "C_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_C");
    check_field_offset(lv, v3, 3, "C_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_C, C_BFu15i_C)
//============================================================================



static void Test_C_BFu15i_D()
{
  {
    init_simple_test("C_BFu15i_D");
    static STRUCT_IF_C C_BFu15i_D lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_D)");
    check_field_offset(lv, v1, 0, "C_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_D");
    check_field_offset(lv, v3, 3, "C_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_D, C_BFu15i_D)
//============================================================================



static void Test_C_BFu15i_F()
{
  {
    init_simple_test("C_BFu15i_F");
    static STRUCT_IF_C C_BFu15i_F lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_F)");
    check_field_offset(lv, v1, 0, "C_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_F");
    check_field_offset(lv, v3, 3, "C_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_F, C_BFu15i_F)
//============================================================================



static void Test_C_BFu15i_I()
{
  {
    init_simple_test("C_BFu15i_I");
    static STRUCT_IF_C C_BFu15i_I lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_I)");
    check_field_offset(lv, v1, 0, "C_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_I");
    check_field_offset(lv, v3, 3, "C_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_I, C_BFu15i_I)
//============================================================================



static void Test_C_BFu15i_Ip()
{
  {
    init_simple_test("C_BFu15i_Ip");
    static STRUCT_IF_C C_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_Ip");
    check_field_offset(lv, v3, 3, "C_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_Ip, C_BFu15i_Ip)
//============================================================================



static void Test_C_BFu15i_L()
{
  {
    init_simple_test("C_BFu15i_L");
    static STRUCT_IF_C C_BFu15i_L lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_L)");
    check_field_offset(lv, v1, 0, "C_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_L");
    check_field_offset(lv, v3, 3, "C_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_L, C_BFu15i_L)
//============================================================================



static void Test_C_BFu15i_S()
{
  {
    init_simple_test("C_BFu15i_S");
    static STRUCT_IF_C C_BFu15i_S lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_S)");
    check_field_offset(lv, v1, 0, "C_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_S");
    check_field_offset(lv, v3, 3, "C_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_S, C_BFu15i_S)
//============================================================================



static void Test_C_BFu15i_Uc()
{
  {
    init_simple_test("C_BFu15i_Uc");
    static STRUCT_IF_C C_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_Uc");
    check_field_offset(lv, v3, 3, "C_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_Uc, C_BFu15i_Uc)
//============================================================================



static void Test_C_BFu15i_Ui()
{
  {
    init_simple_test("C_BFu15i_Ui");
    static STRUCT_IF_C C_BFu15i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_Ui");
    check_field_offset(lv, v3, 3, "C_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_Ui, C_BFu15i_Ui)
//============================================================================



static void Test_C_BFu15i_Ul()
{
  {
    init_simple_test("C_BFu15i_Ul");
    static STRUCT_IF_C C_BFu15i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_Ul");
    check_field_offset(lv, v3, 3, "C_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_Ul, C_BFu15i_Ul)
//============================================================================



static void Test_C_BFu15i_Us()
{
  {
    init_simple_test("C_BFu15i_Us");
    static STRUCT_IF_C C_BFu15i_Us lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_Us");
    check_field_offset(lv, v3, 3, "C_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_Us, C_BFu15i_Us)
//============================================================================



static void Test_C_BFu15i_Vp()
{
  {
    init_simple_test("C_BFu15i_Vp");
    static STRUCT_IF_C C_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_Vp");
    check_field_offset(lv, v3, 3, "C_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15i_Vp, C_BFu15i_Vp)
//============================================================================



static void Test_C_BFu15ll()
{
  {
    init_simple_test("C_BFu15ll");
    static STRUCT_IF_C C_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll, C_BFu15ll)
//============================================================================



static void Test_C_BFu15ll_BFu15i()
{
  {
    init_simple_test("C_BFu15ll_BFu15i");
    static STRUCT_IF_C C_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu15i, C_BFu15ll_BFu15i)
//============================================================================



static void Test_C_BFu15ll_BFu15ll()
{
  {
    init_simple_test("C_BFu15ll_BFu15ll");
    static STRUCT_IF_C C_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu15ll, C_BFu15ll_BFu15ll)
//============================================================================



static void Test_C_BFu15ll_BFu15s()
{
  {
    init_simple_test("C_BFu15ll_BFu15s");
    static STRUCT_IF_C C_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu15s, C_BFu15ll_BFu15s)
//============================================================================



static void Test_C_BFu15ll_BFu16i()
{
  {
    init_simple_test("C_BFu15ll_BFu16i");
    static STRUCT_IF_C C_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu16i, C_BFu15ll_BFu16i)
//============================================================================



static void Test_C_BFu15ll_BFu16ll()
{
  {
    init_simple_test("C_BFu15ll_BFu16ll");
    static STRUCT_IF_C C_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu16ll, C_BFu15ll_BFu16ll)
//============================================================================



static void Test_C_BFu15ll_BFu16s()
{
  {
    init_simple_test("C_BFu15ll_BFu16s");
    static STRUCT_IF_C C_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu16s, C_BFu15ll_BFu16s)
//============================================================================



static void Test_C_BFu15ll_BFu17i()
{
  {
    init_simple_test("C_BFu15ll_BFu17i");
    static STRUCT_IF_C C_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "C_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "C_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu17i, C_BFu15ll_BFu17i)
//============================================================================



static void Test_C_BFu15ll_BFu17ll()
{
  {
    init_simple_test("C_BFu15ll_BFu17ll");
    static STRUCT_IF_C C_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "C_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "C_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu17ll, C_BFu15ll_BFu17ll)
//============================================================================



static void Test_C_BFu15ll_BFu1c()
{
  {
    init_simple_test("C_BFu15ll_BFu1c");
    static STRUCT_IF_C C_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu1c, C_BFu15ll_BFu1c)
//============================================================================



static void Test_C_BFu15ll_BFu1i()
{
  {
    init_simple_test("C_BFu15ll_BFu1i");
    static STRUCT_IF_C C_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu1i, C_BFu15ll_BFu1i)
//============================================================================



static void Test_C_BFu15ll_BFu1ll()
{
  {
    init_simple_test("C_BFu15ll_BFu1ll");
    static STRUCT_IF_C C_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu1ll, C_BFu15ll_BFu1ll)
//============================================================================



static void Test_C_BFu15ll_BFu1s()
{
  {
    init_simple_test("C_BFu15ll_BFu1s");
    static STRUCT_IF_C C_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu1s, C_BFu15ll_BFu1s)
//============================================================================



static void Test_C_BFu15ll_BFu31i()
{
  {
    init_simple_test("C_BFu15ll_BFu31i");
    static STRUCT_IF_C C_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "C_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "C_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu31i, C_BFu15ll_BFu31i)
//============================================================================



static void Test_C_BFu15ll_BFu31ll()
{
  {
    init_simple_test("C_BFu15ll_BFu31ll");
    static STRUCT_IF_C C_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "C_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "C_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu31ll, C_BFu15ll_BFu31ll)
//============================================================================



static void Test_C_BFu15ll_BFu32i()
{
  {
    init_simple_test("C_BFu15ll_BFu32i");
    static STRUCT_IF_C C_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "C_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "C_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu32i, C_BFu15ll_BFu32i)
//============================================================================



static void Test_C_BFu15ll_BFu32ll()
{
  {
    init_simple_test("C_BFu15ll_BFu32ll");
    static STRUCT_IF_C C_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "C_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "C_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu32ll, C_BFu15ll_BFu32ll)
//============================================================================



static void Test_C_BFu15ll_BFu33()
{
  {
    init_simple_test("C_BFu15ll_BFu33");
    static STRUCT_IF_C C_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "C_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "C_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu33, C_BFu15ll_BFu33)
//============================================================================



static void Test_C_BFu15ll_BFu7c()
{
  {
    init_simple_test("C_BFu15ll_BFu7c");
    static STRUCT_IF_C C_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu7c, C_BFu15ll_BFu7c)
//============================================================================



static void Test_C_BFu15ll_BFu7i()
{
  {
    init_simple_test("C_BFu15ll_BFu7i");
    static STRUCT_IF_C C_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu7i, C_BFu15ll_BFu7i)
//============================================================================



static void Test_C_BFu15ll_BFu7ll()
{
  {
    init_simple_test("C_BFu15ll_BFu7ll");
    static STRUCT_IF_C C_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu7ll, C_BFu15ll_BFu7ll)
//============================================================================



static void Test_C_BFu15ll_BFu7s()
{
  {
    init_simple_test("C_BFu15ll_BFu7s");
    static STRUCT_IF_C C_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu7s, C_BFu15ll_BFu7s)
//============================================================================



static void Test_C_BFu15ll_BFu8c()
{
  {
    init_simple_test("C_BFu15ll_BFu8c");
    static STRUCT_IF_C C_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu8c, C_BFu15ll_BFu8c)
//============================================================================



static void Test_C_BFu15ll_BFu8i()
{
  {
    init_simple_test("C_BFu15ll_BFu8i");
    static STRUCT_IF_C C_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu8i, C_BFu15ll_BFu8i)
//============================================================================



static void Test_C_BFu15ll_BFu8ll()
{
  {
    init_simple_test("C_BFu15ll_BFu8ll");
    static STRUCT_IF_C C_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu8ll, C_BFu15ll_BFu8ll)
//============================================================================



static void Test_C_BFu15ll_BFu8s()
{
  {
    init_simple_test("C_BFu15ll_BFu8s");
    static STRUCT_IF_C C_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu8s, C_BFu15ll_BFu8s)
//============================================================================



static void Test_C_BFu15ll_BFu9i()
{
  {
    init_simple_test("C_BFu15ll_BFu9i");
    static STRUCT_IF_C C_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu9i, C_BFu15ll_BFu9i)
//============================================================================



static void Test_C_BFu15ll_BFu9ll()
{
  {
    init_simple_test("C_BFu15ll_BFu9ll");
    static STRUCT_IF_C C_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu9ll, C_BFu15ll_BFu9ll)
//============================================================================



static void Test_C_BFu15ll_BFu9s()
{
  {
    init_simple_test("C_BFu15ll_BFu9s");
    static STRUCT_IF_C C_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_BFu9s, C_BFu15ll_BFu9s)
//============================================================================



static void Test_C_BFu15ll_C()
{
  {
    init_simple_test("C_BFu15ll_C");
    static STRUCT_IF_C C_BFu15ll_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_C");
    check_field_offset(lv, v3, 3, "C_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_C, C_BFu15ll_C)
//============================================================================



static void Test_C_BFu15ll_D()
{
  {
    init_simple_test("C_BFu15ll_D");
    static STRUCT_IF_C C_BFu15ll_D lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_D");
    check_field_offset(lv, v3, 3, "C_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_D, C_BFu15ll_D)
//============================================================================



static void Test_C_BFu15ll_F()
{
  {
    init_simple_test("C_BFu15ll_F");
    static STRUCT_IF_C C_BFu15ll_F lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_F");
    check_field_offset(lv, v3, 3, "C_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_F, C_BFu15ll_F)
//============================================================================



static void Test_C_BFu15ll_I()
{
  {
    init_simple_test("C_BFu15ll_I");
    static STRUCT_IF_C C_BFu15ll_I lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_I");
    check_field_offset(lv, v3, 3, "C_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_I, C_BFu15ll_I)
//============================================================================



static void Test_C_BFu15ll_Ip()
{
  {
    init_simple_test("C_BFu15ll_Ip");
    static STRUCT_IF_C C_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_Ip");
    check_field_offset(lv, v3, 3, "C_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_Ip, C_BFu15ll_Ip)
//============================================================================



static void Test_C_BFu15ll_L()
{
  {
    init_simple_test("C_BFu15ll_L");
    static STRUCT_IF_C C_BFu15ll_L lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_L");
    check_field_offset(lv, v3, 3, "C_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_L, C_BFu15ll_L)
//============================================================================



static void Test_C_BFu15ll_S()
{
  {
    init_simple_test("C_BFu15ll_S");
    static STRUCT_IF_C C_BFu15ll_S lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_S");
    check_field_offset(lv, v3, 3, "C_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_S, C_BFu15ll_S)
//============================================================================



static void Test_C_BFu15ll_Uc()
{
  {
    init_simple_test("C_BFu15ll_Uc");
    static STRUCT_IF_C C_BFu15ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_Uc");
    check_field_offset(lv, v3, 3, "C_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_Uc, C_BFu15ll_Uc)
//============================================================================



static void Test_C_BFu15ll_Ui()
{
  {
    init_simple_test("C_BFu15ll_Ui");
    static STRUCT_IF_C C_BFu15ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_Ui");
    check_field_offset(lv, v3, 3, "C_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_Ui, C_BFu15ll_Ui)
//============================================================================



static void Test_C_BFu15ll_Ul()
{
  {
    init_simple_test("C_BFu15ll_Ul");
    static STRUCT_IF_C C_BFu15ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_Ul");
    check_field_offset(lv, v3, 3, "C_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_Ul, C_BFu15ll_Ul)
//============================================================================



static void Test_C_BFu15ll_Us()
{
  {
    init_simple_test("C_BFu15ll_Us");
    static STRUCT_IF_C C_BFu15ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_Us");
    check_field_offset(lv, v3, 3, "C_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_Us, C_BFu15ll_Us)
//============================================================================



static void Test_C_BFu15ll_Vp()
{
  {
    init_simple_test("C_BFu15ll_Vp");
    static STRUCT_IF_C C_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_Vp");
    check_field_offset(lv, v3, 3, "C_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15ll_Vp, C_BFu15ll_Vp)
//============================================================================



static void Test_C_BFu15s()
{
  {
    init_simple_test("C_BFu15s");
    static STRUCT_IF_C C_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s, C_BFu15s)
//============================================================================



static void Test_C_BFu15s_BFu15i()
{
  {
    init_simple_test("C_BFu15s_BFu15i");
    static STRUCT_IF_C C_BFu15s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu15i, C_BFu15s_BFu15i)
//============================================================================



static void Test_C_BFu15s_BFu15ll()
{
  {
    init_simple_test("C_BFu15s_BFu15ll");
    static STRUCT_IF_C C_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu15ll, C_BFu15s_BFu15ll)
//============================================================================



static void Test_C_BFu15s_BFu15s()
{
  {
    init_simple_test("C_BFu15s_BFu15s");
    static STRUCT_IF_C C_BFu15s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "C_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "C_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu15s, C_BFu15s_BFu15s)
//============================================================================



static void Test_C_BFu15s_BFu16i()
{
  {
    init_simple_test("C_BFu15s_BFu16i");
    static STRUCT_IF_C C_BFu15s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu16i, C_BFu15s_BFu16i)
//============================================================================



static void Test_C_BFu15s_BFu16ll()
{
  {
    init_simple_test("C_BFu15s_BFu16ll");
    static STRUCT_IF_C C_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu16ll, C_BFu15s_BFu16ll)
//============================================================================



static void Test_C_BFu15s_BFu16s()
{
  {
    init_simple_test("C_BFu15s_BFu16s");
    static STRUCT_IF_C C_BFu15s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "C_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "C_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu16s, C_BFu15s_BFu16s)
//============================================================================



static void Test_C_BFu15s_BFu17i()
{
  {
    init_simple_test("C_BFu15s_BFu17i");
    static STRUCT_IF_C C_BFu15s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "C_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "C_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu17i, C_BFu15s_BFu17i)
//============================================================================



static void Test_C_BFu15s_BFu17ll()
{
  {
    init_simple_test("C_BFu15s_BFu17ll");
    static STRUCT_IF_C C_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "C_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "C_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu17ll, C_BFu15s_BFu17ll)
//============================================================================



static void Test_C_BFu15s_BFu1c()
{
  {
    init_simple_test("C_BFu15s_BFu1c");
    static STRUCT_IF_C C_BFu15s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu1c, C_BFu15s_BFu1c)
//============================================================================



static void Test_C_BFu15s_BFu1i()
{
  {
    init_simple_test("C_BFu15s_BFu1i");
    static STRUCT_IF_C C_BFu15s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu1i, C_BFu15s_BFu1i)
//============================================================================



static void Test_C_BFu15s_BFu1ll()
{
  {
    init_simple_test("C_BFu15s_BFu1ll");
    static STRUCT_IF_C C_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu1ll, C_BFu15s_BFu1ll)
//============================================================================



static void Test_C_BFu15s_BFu1s()
{
  {
    init_simple_test("C_BFu15s_BFu1s");
    static STRUCT_IF_C C_BFu15s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "C_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu1s, C_BFu15s_BFu1s)
//============================================================================



static void Test_C_BFu15s_BFu31i()
{
  {
    init_simple_test("C_BFu15s_BFu31i");
    static STRUCT_IF_C C_BFu15s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "C_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "C_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu31i, C_BFu15s_BFu31i)
//============================================================================



static void Test_C_BFu15s_BFu31ll()
{
  {
    init_simple_test("C_BFu15s_BFu31ll");
    static STRUCT_IF_C C_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "C_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "C_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu31ll, C_BFu15s_BFu31ll)
//============================================================================



static void Test_C_BFu15s_BFu32i()
{
  {
    init_simple_test("C_BFu15s_BFu32i");
    static STRUCT_IF_C C_BFu15s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "C_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "C_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu32i, C_BFu15s_BFu32i)
//============================================================================



static void Test_C_BFu15s_BFu32ll()
{
  {
    init_simple_test("C_BFu15s_BFu32ll");
    static STRUCT_IF_C C_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "C_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "C_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu32ll, C_BFu15s_BFu32ll)
//============================================================================



static void Test_C_BFu15s_BFu33()
{
  {
    init_simple_test("C_BFu15s_BFu33");
    static STRUCT_IF_C C_BFu15s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "C_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "C_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu33, C_BFu15s_BFu33)
//============================================================================



static void Test_C_BFu15s_BFu7c()
{
  {
    init_simple_test("C_BFu15s_BFu7c");
    static STRUCT_IF_C C_BFu15s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu7c, C_BFu15s_BFu7c)
//============================================================================



static void Test_C_BFu15s_BFu7i()
{
  {
    init_simple_test("C_BFu15s_BFu7i");
    static STRUCT_IF_C C_BFu15s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu7i, C_BFu15s_BFu7i)
//============================================================================



static void Test_C_BFu15s_BFu7ll()
{
  {
    init_simple_test("C_BFu15s_BFu7ll");
    static STRUCT_IF_C C_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu7ll, C_BFu15s_BFu7ll)
//============================================================================



static void Test_C_BFu15s_BFu7s()
{
  {
    init_simple_test("C_BFu15s_BFu7s");
    static STRUCT_IF_C C_BFu15s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "C_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "C_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu7s, C_BFu15s_BFu7s)
//============================================================================



static void Test_C_BFu15s_BFu8c()
{
  {
    init_simple_test("C_BFu15s_BFu8c");
    static STRUCT_IF_C C_BFu15s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu8c, C_BFu15s_BFu8c)
//============================================================================



static void Test_C_BFu15s_BFu8i()
{
  {
    init_simple_test("C_BFu15s_BFu8i");
    static STRUCT_IF_C C_BFu15s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu8i, C_BFu15s_BFu8i)
//============================================================================



static void Test_C_BFu15s_BFu8ll()
{
  {
    init_simple_test("C_BFu15s_BFu8ll");
    static STRUCT_IF_C C_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu8ll, C_BFu15s_BFu8ll)
//============================================================================



static void Test_C_BFu15s_BFu8s()
{
  {
    init_simple_test("C_BFu15s_BFu8s");
    static STRUCT_IF_C C_BFu15s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "C_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "C_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu8s, C_BFu15s_BFu8s)
//============================================================================



static void Test_C_BFu15s_BFu9i()
{
  {
    init_simple_test("C_BFu15s_BFu9i");
    static STRUCT_IF_C C_BFu15s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu9i, C_BFu15s_BFu9i)
//============================================================================



static void Test_C_BFu15s_BFu9ll()
{
  {
    init_simple_test("C_BFu15s_BFu9ll");
    static STRUCT_IF_C C_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu9ll, C_BFu15s_BFu9ll)
//============================================================================



static void Test_C_BFu15s_BFu9s()
{
  {
    init_simple_test("C_BFu15s_BFu9s");
    static STRUCT_IF_C C_BFu15s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "C_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "C_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_BFu9s, C_BFu15s_BFu9s)
//============================================================================



static void Test_C_BFu15s_C()
{
  {
    init_simple_test("C_BFu15s_C");
    static STRUCT_IF_C C_BFu15s_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_C)");
    check_field_offset(lv, v1, 0, "C_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_C");
    check_field_offset(lv, v3, 3, "C_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_C, C_BFu15s_C)
//============================================================================



static void Test_C_BFu15s_D()
{
  {
    init_simple_test("C_BFu15s_D");
    static STRUCT_IF_C C_BFu15s_D lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_D)");
    check_field_offset(lv, v1, 0, "C_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_D");
    check_field_offset(lv, v3, 3, "C_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_D, C_BFu15s_D)
//============================================================================



static void Test_C_BFu15s_F()
{
  {
    init_simple_test("C_BFu15s_F");
    static STRUCT_IF_C C_BFu15s_F lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_F)");
    check_field_offset(lv, v1, 0, "C_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_F");
    check_field_offset(lv, v3, 3, "C_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_F, C_BFu15s_F)
//============================================================================



static void Test_C_BFu15s_I()
{
  {
    init_simple_test("C_BFu15s_I");
    static STRUCT_IF_C C_BFu15s_I lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_I)");
    check_field_offset(lv, v1, 0, "C_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_I");
    check_field_offset(lv, v3, 3, "C_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_I, C_BFu15s_I)
//============================================================================



static void Test_C_BFu15s_Ip()
{
  {
    init_simple_test("C_BFu15s_Ip");
    static STRUCT_IF_C C_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_Ip");
    check_field_offset(lv, v3, 3, "C_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_Ip, C_BFu15s_Ip)
//============================================================================



static void Test_C_BFu15s_L()
{
  {
    init_simple_test("C_BFu15s_L");
    static STRUCT_IF_C C_BFu15s_L lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_L)");
    check_field_offset(lv, v1, 0, "C_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_L");
    check_field_offset(lv, v3, 3, "C_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_L, C_BFu15s_L)
//============================================================================



static void Test_C_BFu15s_S()
{
  {
    init_simple_test("C_BFu15s_S");
    static STRUCT_IF_C C_BFu15s_S lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_S)");
    check_field_offset(lv, v1, 0, "C_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_S");
    check_field_offset(lv, v3, 3, "C_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_S, C_BFu15s_S)
//============================================================================



static void Test_C_BFu15s_Uc()
{
  {
    init_simple_test("C_BFu15s_Uc");
    static STRUCT_IF_C C_BFu15s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_Uc");
    check_field_offset(lv, v3, 3, "C_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_Uc, C_BFu15s_Uc)
//============================================================================



static void Test_C_BFu15s_Ui()
{
  {
    init_simple_test("C_BFu15s_Ui");
    static STRUCT_IF_C C_BFu15s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_Ui");
    check_field_offset(lv, v3, 3, "C_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_Ui, C_BFu15s_Ui)
//============================================================================



static void Test_C_BFu15s_Ul()
{
  {
    init_simple_test("C_BFu15s_Ul");
    static STRUCT_IF_C C_BFu15s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_Ul");
    check_field_offset(lv, v3, 3, "C_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_Ul, C_BFu15s_Ul)
//============================================================================



static void Test_C_BFu15s_Us()
{
  {
    init_simple_test("C_BFu15s_Us");
    static STRUCT_IF_C C_BFu15s_Us lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "C_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_Us");
    check_field_offset(lv, v3, 3, "C_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_Us, C_BFu15s_Us)
//============================================================================



static void Test_C_BFu15s_Vp()
{
  {
    init_simple_test("C_BFu15s_Vp");
    static STRUCT_IF_C C_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15s_Vp");
    check_field_offset(lv, v3, 3, "C_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu15s_Vp, C_BFu15s_Vp)
//============================================================================



static void Test_C_BFu16i()
{
  {
    init_simple_test("C_BFu16i");
    static STRUCT_IF_C C_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i, C_BFu16i)
//============================================================================



static void Test_C_BFu16i_BFu15i()
{
  {
    init_simple_test("C_BFu16i_BFu15i");
    static STRUCT_IF_C C_BFu16i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu15i, C_BFu16i_BFu15i)
//============================================================================



static void Test_C_BFu16i_BFu15ll()
{
  {
    init_simple_test("C_BFu16i_BFu15ll");
    static STRUCT_IF_C C_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu15ll, C_BFu16i_BFu15ll)
//============================================================================



static void Test_C_BFu16i_BFu15s()
{
  {
    init_simple_test("C_BFu16i_BFu15s");
    static STRUCT_IF_C C_BFu16i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu15s, C_BFu16i_BFu15s)
//============================================================================



static void Test_C_BFu16i_BFu16i()
{
  {
    init_simple_test("C_BFu16i_BFu16i");
    static STRUCT_IF_C C_BFu16i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu16i, C_BFu16i_BFu16i)
//============================================================================



static void Test_C_BFu16i_BFu16ll()
{
  {
    init_simple_test("C_BFu16i_BFu16ll");
    static STRUCT_IF_C C_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu16ll, C_BFu16i_BFu16ll)
//============================================================================



static void Test_C_BFu16i_BFu16s()
{
  {
    init_simple_test("C_BFu16i_BFu16s");
    static STRUCT_IF_C C_BFu16i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu16s, C_BFu16i_BFu16s)
//============================================================================



static void Test_C_BFu16i_BFu17i()
{
  {
    init_simple_test("C_BFu16i_BFu17i");
    static STRUCT_IF_C C_BFu16i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "C_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "C_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu17i, C_BFu16i_BFu17i)
//============================================================================



static void Test_C_BFu16i_BFu17ll()
{
  {
    init_simple_test("C_BFu16i_BFu17ll");
    static STRUCT_IF_C C_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "C_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "C_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu17ll, C_BFu16i_BFu17ll)
//============================================================================



static void Test_C_BFu16i_BFu1c()
{
  {
    init_simple_test("C_BFu16i_BFu1c");
    static STRUCT_IF_C C_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu1c, C_BFu16i_BFu1c)
//============================================================================



static void Test_C_BFu16i_BFu1i()
{
  {
    init_simple_test("C_BFu16i_BFu1i");
    static STRUCT_IF_C C_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu1i, C_BFu16i_BFu1i)
//============================================================================



static void Test_C_BFu16i_BFu1ll()
{
  {
    init_simple_test("C_BFu16i_BFu1ll");
    static STRUCT_IF_C C_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu1ll, C_BFu16i_BFu1ll)
//============================================================================



static void Test_C_BFu16i_BFu1s()
{
  {
    init_simple_test("C_BFu16i_BFu1s");
    static STRUCT_IF_C C_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu1s, C_BFu16i_BFu1s)
//============================================================================



static void Test_C_BFu16i_BFu31i()
{
  {
    init_simple_test("C_BFu16i_BFu31i");
    static STRUCT_IF_C C_BFu16i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "C_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "C_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu31i, C_BFu16i_BFu31i)
//============================================================================



static void Test_C_BFu16i_BFu31ll()
{
  {
    init_simple_test("C_BFu16i_BFu31ll");
    static STRUCT_IF_C C_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "C_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "C_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu31ll, C_BFu16i_BFu31ll)
//============================================================================



static void Test_C_BFu16i_BFu32i()
{
  {
    init_simple_test("C_BFu16i_BFu32i");
    static STRUCT_IF_C C_BFu16i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "C_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "C_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu32i, C_BFu16i_BFu32i)
//============================================================================



static void Test_C_BFu16i_BFu32ll()
{
  {
    init_simple_test("C_BFu16i_BFu32ll");
    static STRUCT_IF_C C_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "C_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "C_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu32ll, C_BFu16i_BFu32ll)
//============================================================================



static void Test_C_BFu16i_BFu33()
{
  {
    init_simple_test("C_BFu16i_BFu33");
    static STRUCT_IF_C C_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "C_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "C_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu33, C_BFu16i_BFu33)
//============================================================================



static void Test_C_BFu16i_BFu7c()
{
  {
    init_simple_test("C_BFu16i_BFu7c");
    static STRUCT_IF_C C_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu7c, C_BFu16i_BFu7c)
//============================================================================



static void Test_C_BFu16i_BFu7i()
{
  {
    init_simple_test("C_BFu16i_BFu7i");
    static STRUCT_IF_C C_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu7i, C_BFu16i_BFu7i)
//============================================================================



static void Test_C_BFu16i_BFu7ll()
{
  {
    init_simple_test("C_BFu16i_BFu7ll");
    static STRUCT_IF_C C_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu7ll, C_BFu16i_BFu7ll)
//============================================================================



static void Test_C_BFu16i_BFu7s()
{
  {
    init_simple_test("C_BFu16i_BFu7s");
    static STRUCT_IF_C C_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu7s, C_BFu16i_BFu7s)
//============================================================================



static void Test_C_BFu16i_BFu8c()
{
  {
    init_simple_test("C_BFu16i_BFu8c");
    static STRUCT_IF_C C_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu8c, C_BFu16i_BFu8c)
//============================================================================



static void Test_C_BFu16i_BFu8i()
{
  {
    init_simple_test("C_BFu16i_BFu8i");
    static STRUCT_IF_C C_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu8i, C_BFu16i_BFu8i)
//============================================================================



static void Test_C_BFu16i_BFu8ll()
{
  {
    init_simple_test("C_BFu16i_BFu8ll");
    static STRUCT_IF_C C_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu8ll, C_BFu16i_BFu8ll)
//============================================================================



static void Test_C_BFu16i_BFu8s()
{
  {
    init_simple_test("C_BFu16i_BFu8s");
    static STRUCT_IF_C C_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu8s, C_BFu16i_BFu8s)
//============================================================================



static void Test_C_BFu16i_BFu9i()
{
  {
    init_simple_test("C_BFu16i_BFu9i");
    static STRUCT_IF_C C_BFu16i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu9i, C_BFu16i_BFu9i)
//============================================================================



static void Test_C_BFu16i_BFu9ll()
{
  {
    init_simple_test("C_BFu16i_BFu9ll");
    static STRUCT_IF_C C_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu9ll, C_BFu16i_BFu9ll)
//============================================================================



static void Test_C_BFu16i_BFu9s()
{
  {
    init_simple_test("C_BFu16i_BFu9s");
    static STRUCT_IF_C C_BFu16i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_BFu9s, C_BFu16i_BFu9s)
//============================================================================



static void Test_C_BFu16i_C()
{
  {
    init_simple_test("C_BFu16i_C");
    static STRUCT_IF_C C_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_C)");
    check_field_offset(lv, v1, 0, "C_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_C");
    check_field_offset(lv, v3, 3, "C_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_C, C_BFu16i_C)
//============================================================================



static void Test_C_BFu16i_D()
{
  {
    init_simple_test("C_BFu16i_D");
    static STRUCT_IF_C C_BFu16i_D lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_D)");
    check_field_offset(lv, v1, 0, "C_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_D");
    check_field_offset(lv, v3, 3, "C_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_D, C_BFu16i_D)
//============================================================================



static void Test_C_BFu16i_F()
{
  {
    init_simple_test("C_BFu16i_F");
    static STRUCT_IF_C C_BFu16i_F lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_F)");
    check_field_offset(lv, v1, 0, "C_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_F");
    check_field_offset(lv, v3, 3, "C_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_F, C_BFu16i_F)
//============================================================================



static void Test_C_BFu16i_I()
{
  {
    init_simple_test("C_BFu16i_I");
    static STRUCT_IF_C C_BFu16i_I lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_I)");
    check_field_offset(lv, v1, 0, "C_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_I");
    check_field_offset(lv, v3, 3, "C_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_I, C_BFu16i_I)
//============================================================================



static void Test_C_BFu16i_Ip()
{
  {
    init_simple_test("C_BFu16i_Ip");
    static STRUCT_IF_C C_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_Ip");
    check_field_offset(lv, v3, 3, "C_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_Ip, C_BFu16i_Ip)
//============================================================================



static void Test_C_BFu16i_L()
{
  {
    init_simple_test("C_BFu16i_L");
    static STRUCT_IF_C C_BFu16i_L lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_L)");
    check_field_offset(lv, v1, 0, "C_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_L");
    check_field_offset(lv, v3, 3, "C_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_L, C_BFu16i_L)
//============================================================================



static void Test_C_BFu16i_S()
{
  {
    init_simple_test("C_BFu16i_S");
    static STRUCT_IF_C C_BFu16i_S lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_S)");
    check_field_offset(lv, v1, 0, "C_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_S");
    check_field_offset(lv, v3, 3, "C_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_S, C_BFu16i_S)
//============================================================================



static void Test_C_BFu16i_Uc()
{
  {
    init_simple_test("C_BFu16i_Uc");
    static STRUCT_IF_C C_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "C_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_Uc, C_BFu16i_Uc)
//============================================================================



static void Test_C_BFu16i_Ui()
{
  {
    init_simple_test("C_BFu16i_Ui");
    static STRUCT_IF_C C_BFu16i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_Ui");
    check_field_offset(lv, v3, 3, "C_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_Ui, C_BFu16i_Ui)
//============================================================================



static void Test_C_BFu16i_Ul()
{
  {
    init_simple_test("C_BFu16i_Ul");
    static STRUCT_IF_C C_BFu16i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_Ul");
    check_field_offset(lv, v3, 3, "C_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_Ul, C_BFu16i_Ul)
//============================================================================



static void Test_C_BFu16i_Us()
{
  {
    init_simple_test("C_BFu16i_Us");
    static STRUCT_IF_C C_BFu16i_Us lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_Us");
    check_field_offset(lv, v3, 3, "C_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_Us, C_BFu16i_Us)
//============================================================================



static void Test_C_BFu16i_Vp()
{
  {
    init_simple_test("C_BFu16i_Vp");
    static STRUCT_IF_C C_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_Vp");
    check_field_offset(lv, v3, 3, "C_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16i_Vp, C_BFu16i_Vp)
//============================================================================



static void Test_C_BFu16ll()
{
  {
    init_simple_test("C_BFu16ll");
    static STRUCT_IF_C C_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll, C_BFu16ll)
//============================================================================



static void Test_C_BFu16ll_BFu15i()
{
  {
    init_simple_test("C_BFu16ll_BFu15i");
    static STRUCT_IF_C C_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu15i, C_BFu16ll_BFu15i)
//============================================================================



static void Test_C_BFu16ll_BFu15ll()
{
  {
    init_simple_test("C_BFu16ll_BFu15ll");
    static STRUCT_IF_C C_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu15ll, C_BFu16ll_BFu15ll)
//============================================================================



static void Test_C_BFu16ll_BFu15s()
{
  {
    init_simple_test("C_BFu16ll_BFu15s");
    static STRUCT_IF_C C_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu15s, C_BFu16ll_BFu15s)
//============================================================================



static void Test_C_BFu16ll_BFu16i()
{
  {
    init_simple_test("C_BFu16ll_BFu16i");
    static STRUCT_IF_C C_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu16i, C_BFu16ll_BFu16i)
//============================================================================



static void Test_C_BFu16ll_BFu16ll()
{
  {
    init_simple_test("C_BFu16ll_BFu16ll");
    static STRUCT_IF_C C_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu16ll, C_BFu16ll_BFu16ll)
//============================================================================



static void Test_C_BFu16ll_BFu16s()
{
  {
    init_simple_test("C_BFu16ll_BFu16s");
    static STRUCT_IF_C C_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu16s, C_BFu16ll_BFu16s)
//============================================================================



static void Test_C_BFu16ll_BFu17i()
{
  {
    init_simple_test("C_BFu16ll_BFu17i");
    static STRUCT_IF_C C_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "C_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "C_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu17i, C_BFu16ll_BFu17i)
//============================================================================



static void Test_C_BFu16ll_BFu17ll()
{
  {
    init_simple_test("C_BFu16ll_BFu17ll");
    static STRUCT_IF_C C_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "C_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "C_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu17ll, C_BFu16ll_BFu17ll)
//============================================================================



static void Test_C_BFu16ll_BFu1c()
{
  {
    init_simple_test("C_BFu16ll_BFu1c");
    static STRUCT_IF_C C_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu1c, C_BFu16ll_BFu1c)
//============================================================================



static void Test_C_BFu16ll_BFu1i()
{
  {
    init_simple_test("C_BFu16ll_BFu1i");
    static STRUCT_IF_C C_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu1i, C_BFu16ll_BFu1i)
//============================================================================



static void Test_C_BFu16ll_BFu1ll()
{
  {
    init_simple_test("C_BFu16ll_BFu1ll");
    static STRUCT_IF_C C_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu1ll, C_BFu16ll_BFu1ll)
//============================================================================



static void Test_C_BFu16ll_BFu1s()
{
  {
    init_simple_test("C_BFu16ll_BFu1s");
    static STRUCT_IF_C C_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu1s, C_BFu16ll_BFu1s)
//============================================================================



static void Test_C_BFu16ll_BFu31i()
{
  {
    init_simple_test("C_BFu16ll_BFu31i");
    static STRUCT_IF_C C_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "C_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "C_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu31i, C_BFu16ll_BFu31i)
//============================================================================



static void Test_C_BFu16ll_BFu31ll()
{
  {
    init_simple_test("C_BFu16ll_BFu31ll");
    static STRUCT_IF_C C_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "C_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "C_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu31ll, C_BFu16ll_BFu31ll)
//============================================================================



static void Test_C_BFu16ll_BFu32i()
{
  {
    init_simple_test("C_BFu16ll_BFu32i");
    static STRUCT_IF_C C_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "C_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "C_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu32i, C_BFu16ll_BFu32i)
//============================================================================



static void Test_C_BFu16ll_BFu32ll()
{
  {
    init_simple_test("C_BFu16ll_BFu32ll");
    static STRUCT_IF_C C_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "C_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "C_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu32ll, C_BFu16ll_BFu32ll)
//============================================================================



static void Test_C_BFu16ll_BFu33()
{
  {
    init_simple_test("C_BFu16ll_BFu33");
    static STRUCT_IF_C C_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "C_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "C_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu33, C_BFu16ll_BFu33)
//============================================================================



static void Test_C_BFu16ll_BFu7c()
{
  {
    init_simple_test("C_BFu16ll_BFu7c");
    static STRUCT_IF_C C_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu7c, C_BFu16ll_BFu7c)
//============================================================================



static void Test_C_BFu16ll_BFu7i()
{
  {
    init_simple_test("C_BFu16ll_BFu7i");
    static STRUCT_IF_C C_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu7i, C_BFu16ll_BFu7i)
//============================================================================



static void Test_C_BFu16ll_BFu7ll()
{
  {
    init_simple_test("C_BFu16ll_BFu7ll");
    static STRUCT_IF_C C_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu7ll, C_BFu16ll_BFu7ll)
//============================================================================



static void Test_C_BFu16ll_BFu7s()
{
  {
    init_simple_test("C_BFu16ll_BFu7s");
    static STRUCT_IF_C C_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu7s, C_BFu16ll_BFu7s)
//============================================================================



static void Test_C_BFu16ll_BFu8c()
{
  {
    init_simple_test("C_BFu16ll_BFu8c");
    static STRUCT_IF_C C_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu8c, C_BFu16ll_BFu8c)
//============================================================================



static void Test_C_BFu16ll_BFu8i()
{
  {
    init_simple_test("C_BFu16ll_BFu8i");
    static STRUCT_IF_C C_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu8i, C_BFu16ll_BFu8i)
//============================================================================



static void Test_C_BFu16ll_BFu8ll()
{
  {
    init_simple_test("C_BFu16ll_BFu8ll");
    static STRUCT_IF_C C_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu8ll, C_BFu16ll_BFu8ll)
//============================================================================



static void Test_C_BFu16ll_BFu8s()
{
  {
    init_simple_test("C_BFu16ll_BFu8s");
    static STRUCT_IF_C C_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu8s, C_BFu16ll_BFu8s)
//============================================================================



static void Test_C_BFu16ll_BFu9i()
{
  {
    init_simple_test("C_BFu16ll_BFu9i");
    static STRUCT_IF_C C_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu9i, C_BFu16ll_BFu9i)
//============================================================================



static void Test_C_BFu16ll_BFu9ll()
{
  {
    init_simple_test("C_BFu16ll_BFu9ll");
    static STRUCT_IF_C C_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu9ll, C_BFu16ll_BFu9ll)
//============================================================================



static void Test_C_BFu16ll_BFu9s()
{
  {
    init_simple_test("C_BFu16ll_BFu9s");
    static STRUCT_IF_C C_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_BFu9s, C_BFu16ll_BFu9s)
//============================================================================



static void Test_C_BFu16ll_C()
{
  {
    init_simple_test("C_BFu16ll_C");
    static STRUCT_IF_C C_BFu16ll_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_C");
    check_field_offset(lv, v3, 3, "C_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_C, C_BFu16ll_C)
//============================================================================



static void Test_C_BFu16ll_D()
{
  {
    init_simple_test("C_BFu16ll_D");
    static STRUCT_IF_C C_BFu16ll_D lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_D");
    check_field_offset(lv, v3, 3, "C_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_D, C_BFu16ll_D)
//============================================================================



static void Test_C_BFu16ll_F()
{
  {
    init_simple_test("C_BFu16ll_F");
    static STRUCT_IF_C C_BFu16ll_F lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_F");
    check_field_offset(lv, v3, 3, "C_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_F, C_BFu16ll_F)
//============================================================================



static void Test_C_BFu16ll_I()
{
  {
    init_simple_test("C_BFu16ll_I");
    static STRUCT_IF_C C_BFu16ll_I lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_I");
    check_field_offset(lv, v3, 3, "C_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_I, C_BFu16ll_I)
//============================================================================



static void Test_C_BFu16ll_Ip()
{
  {
    init_simple_test("C_BFu16ll_Ip");
    static STRUCT_IF_C C_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_Ip");
    check_field_offset(lv, v3, 3, "C_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_Ip, C_BFu16ll_Ip)
//============================================================================



static void Test_C_BFu16ll_L()
{
  {
    init_simple_test("C_BFu16ll_L");
    static STRUCT_IF_C C_BFu16ll_L lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_L");
    check_field_offset(lv, v3, 3, "C_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_L, C_BFu16ll_L)
//============================================================================



static void Test_C_BFu16ll_S()
{
  {
    init_simple_test("C_BFu16ll_S");
    static STRUCT_IF_C C_BFu16ll_S lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_S");
    check_field_offset(lv, v3, 3, "C_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_S, C_BFu16ll_S)
//============================================================================



static void Test_C_BFu16ll_Uc()
{
  {
    init_simple_test("C_BFu16ll_Uc");
    static STRUCT_IF_C C_BFu16ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "C_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_Uc, C_BFu16ll_Uc)
//============================================================================



static void Test_C_BFu16ll_Ui()
{
  {
    init_simple_test("C_BFu16ll_Ui");
    static STRUCT_IF_C C_BFu16ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_Ui");
    check_field_offset(lv, v3, 3, "C_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_Ui, C_BFu16ll_Ui)
//============================================================================



static void Test_C_BFu16ll_Ul()
{
  {
    init_simple_test("C_BFu16ll_Ul");
    static STRUCT_IF_C C_BFu16ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_Ul");
    check_field_offset(lv, v3, 3, "C_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_Ul, C_BFu16ll_Ul)
//============================================================================



static void Test_C_BFu16ll_Us()
{
  {
    init_simple_test("C_BFu16ll_Us");
    static STRUCT_IF_C C_BFu16ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_Us");
    check_field_offset(lv, v3, 3, "C_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_Us, C_BFu16ll_Us)
//============================================================================



static void Test_C_BFu16ll_Vp()
{
  {
    init_simple_test("C_BFu16ll_Vp");
    static STRUCT_IF_C C_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_Vp");
    check_field_offset(lv, v3, 3, "C_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16ll_Vp, C_BFu16ll_Vp)
//============================================================================



static void Test_C_BFu16s()
{
  {
    init_simple_test("C_BFu16s");
    static STRUCT_IF_C C_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s, C_BFu16s)
//============================================================================



static void Test_C_BFu16s_BFu15i()
{
  {
    init_simple_test("C_BFu16s_BFu15i");
    static STRUCT_IF_C C_BFu16s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu15i, C_BFu16s_BFu15i)
//============================================================================



static void Test_C_BFu16s_BFu15ll()
{
  {
    init_simple_test("C_BFu16s_BFu15ll");
    static STRUCT_IF_C C_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu15ll, C_BFu16s_BFu15ll)
//============================================================================



static void Test_C_BFu16s_BFu15s()
{
  {
    init_simple_test("C_BFu16s_BFu15s");
    static STRUCT_IF_C C_BFu16s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "C_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "C_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu15s, C_BFu16s_BFu15s)
//============================================================================



static void Test_C_BFu16s_BFu16i()
{
  {
    init_simple_test("C_BFu16s_BFu16i");
    static STRUCT_IF_C C_BFu16s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu16i, C_BFu16s_BFu16i)
//============================================================================



static void Test_C_BFu16s_BFu16ll()
{
  {
    init_simple_test("C_BFu16s_BFu16ll");
    static STRUCT_IF_C C_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu16ll, C_BFu16s_BFu16ll)
//============================================================================



static void Test_C_BFu16s_BFu16s()
{
  {
    init_simple_test("C_BFu16s_BFu16s");
    static STRUCT_IF_C C_BFu16s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "C_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu16s, C_BFu16s_BFu16s)
//============================================================================



static void Test_C_BFu16s_BFu17i()
{
  {
    init_simple_test("C_BFu16s_BFu17i");
    static STRUCT_IF_C C_BFu16s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "C_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "C_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu17i, C_BFu16s_BFu17i)
//============================================================================



static void Test_C_BFu16s_BFu17ll()
{
  {
    init_simple_test("C_BFu16s_BFu17ll");
    static STRUCT_IF_C C_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "C_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "C_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu17ll, C_BFu16s_BFu17ll)
//============================================================================



static void Test_C_BFu16s_BFu1c()
{
  {
    init_simple_test("C_BFu16s_BFu1c");
    static STRUCT_IF_C C_BFu16s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu1c, C_BFu16s_BFu1c)
//============================================================================



static void Test_C_BFu16s_BFu1i()
{
  {
    init_simple_test("C_BFu16s_BFu1i");
    static STRUCT_IF_C C_BFu16s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu1i, C_BFu16s_BFu1i)
//============================================================================



static void Test_C_BFu16s_BFu1ll()
{
  {
    init_simple_test("C_BFu16s_BFu1ll");
    static STRUCT_IF_C C_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu1ll, C_BFu16s_BFu1ll)
//============================================================================



static void Test_C_BFu16s_BFu1s()
{
  {
    init_simple_test("C_BFu16s_BFu1s");
    static STRUCT_IF_C C_BFu16s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "C_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu1s, C_BFu16s_BFu1s)
//============================================================================



static void Test_C_BFu16s_BFu31i()
{
  {
    init_simple_test("C_BFu16s_BFu31i");
    static STRUCT_IF_C C_BFu16s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "C_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "C_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu31i, C_BFu16s_BFu31i)
//============================================================================



static void Test_C_BFu16s_BFu31ll()
{
  {
    init_simple_test("C_BFu16s_BFu31ll");
    static STRUCT_IF_C C_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "C_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "C_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu31ll, C_BFu16s_BFu31ll)
//============================================================================



static void Test_C_BFu16s_BFu32i()
{
  {
    init_simple_test("C_BFu16s_BFu32i");
    static STRUCT_IF_C C_BFu16s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "C_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "C_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu32i, C_BFu16s_BFu32i)
//============================================================================



static void Test_C_BFu16s_BFu32ll()
{
  {
    init_simple_test("C_BFu16s_BFu32ll");
    static STRUCT_IF_C C_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "C_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "C_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu32ll, C_BFu16s_BFu32ll)
//============================================================================



static void Test_C_BFu16s_BFu33()
{
  {
    init_simple_test("C_BFu16s_BFu33");
    static STRUCT_IF_C C_BFu16s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "C_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "C_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu33, C_BFu16s_BFu33)
//============================================================================



static void Test_C_BFu16s_BFu7c()
{
  {
    init_simple_test("C_BFu16s_BFu7c");
    static STRUCT_IF_C C_BFu16s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu7c, C_BFu16s_BFu7c)
//============================================================================



static void Test_C_BFu16s_BFu7i()
{
  {
    init_simple_test("C_BFu16s_BFu7i");
    static STRUCT_IF_C C_BFu16s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu7i, C_BFu16s_BFu7i)
//============================================================================



static void Test_C_BFu16s_BFu7ll()
{
  {
    init_simple_test("C_BFu16s_BFu7ll");
    static STRUCT_IF_C C_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu7ll, C_BFu16s_BFu7ll)
//============================================================================



static void Test_C_BFu16s_BFu7s()
{
  {
    init_simple_test("C_BFu16s_BFu7s");
    static STRUCT_IF_C C_BFu16s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "C_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "C_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu7s, C_BFu16s_BFu7s)
//============================================================================



static void Test_C_BFu16s_BFu8c()
{
  {
    init_simple_test("C_BFu16s_BFu8c");
    static STRUCT_IF_C C_BFu16s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu8c, C_BFu16s_BFu8c)
//============================================================================



static void Test_C_BFu16s_BFu8i()
{
  {
    init_simple_test("C_BFu16s_BFu8i");
    static STRUCT_IF_C C_BFu16s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu8i, C_BFu16s_BFu8i)
//============================================================================



static void Test_C_BFu16s_BFu8ll()
{
  {
    init_simple_test("C_BFu16s_BFu8ll");
    static STRUCT_IF_C C_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu8ll, C_BFu16s_BFu8ll)
//============================================================================



static void Test_C_BFu16s_BFu8s()
{
  {
    init_simple_test("C_BFu16s_BFu8s");
    static STRUCT_IF_C C_BFu16s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "C_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "C_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu8s, C_BFu16s_BFu8s)
//============================================================================



static void Test_C_BFu16s_BFu9i()
{
  {
    init_simple_test("C_BFu16s_BFu9i");
    static STRUCT_IF_C C_BFu16s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu9i, C_BFu16s_BFu9i)
//============================================================================



static void Test_C_BFu16s_BFu9ll()
{
  {
    init_simple_test("C_BFu16s_BFu9ll");
    static STRUCT_IF_C C_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu9ll, C_BFu16s_BFu9ll)
//============================================================================



static void Test_C_BFu16s_BFu9s()
{
  {
    init_simple_test("C_BFu16s_BFu9s");
    static STRUCT_IF_C C_BFu16s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "C_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "C_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_BFu9s, C_BFu16s_BFu9s)
//============================================================================



static void Test_C_BFu16s_C()
{
  {
    init_simple_test("C_BFu16s_C");
    static STRUCT_IF_C C_BFu16s_C lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_C)");
    check_field_offset(lv, v1, 0, "C_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_C");
    check_field_offset(lv, v3, 3, "C_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_C, C_BFu16s_C)
//============================================================================



static void Test_C_BFu16s_D()
{
  {
    init_simple_test("C_BFu16s_D");
    static STRUCT_IF_C C_BFu16s_D lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_D)");
    check_field_offset(lv, v1, 0, "C_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_D");
    check_field_offset(lv, v3, 3, "C_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_D, C_BFu16s_D)
//============================================================================



static void Test_C_BFu16s_F()
{
  {
    init_simple_test("C_BFu16s_F");
    static STRUCT_IF_C C_BFu16s_F lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_F)");
    check_field_offset(lv, v1, 0, "C_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_F");
    check_field_offset(lv, v3, 3, "C_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_F, C_BFu16s_F)
//============================================================================



static void Test_C_BFu16s_I()
{
  {
    init_simple_test("C_BFu16s_I");
    static STRUCT_IF_C C_BFu16s_I lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_I)");
    check_field_offset(lv, v1, 0, "C_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_I");
    check_field_offset(lv, v3, 3, "C_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_I, C_BFu16s_I)
//============================================================================



static void Test_C_BFu16s_Ip()
{
  {
    init_simple_test("C_BFu16s_Ip");
    static STRUCT_IF_C C_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_Ip");
    check_field_offset(lv, v3, 3, "C_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_Ip, C_BFu16s_Ip)
//============================================================================



static void Test_C_BFu16s_L()
{
  {
    init_simple_test("C_BFu16s_L");
    static STRUCT_IF_C C_BFu16s_L lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_L)");
    check_field_offset(lv, v1, 0, "C_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_L");
    check_field_offset(lv, v3, 3, "C_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_L, C_BFu16s_L)
//============================================================================



static void Test_C_BFu16s_S()
{
  {
    init_simple_test("C_BFu16s_S");
    static STRUCT_IF_C C_BFu16s_S lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_S)");
    check_field_offset(lv, v1, 0, "C_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_S");
    check_field_offset(lv, v3, 3, "C_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_S, C_BFu16s_S)
//============================================================================



static void Test_C_BFu16s_Uc()
{
  {
    init_simple_test("C_BFu16s_Uc");
    static STRUCT_IF_C C_BFu16s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_Uc");
    check_field_offset(lv, v3, 3, "C_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_Uc, C_BFu16s_Uc)
//============================================================================



static void Test_C_BFu16s_Ui()
{
  {
    init_simple_test("C_BFu16s_Ui");
    static STRUCT_IF_C C_BFu16s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_Ui");
    check_field_offset(lv, v3, 3, "C_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_Ui, C_BFu16s_Ui)
//============================================================================



static void Test_C_BFu16s_Ul()
{
  {
    init_simple_test("C_BFu16s_Ul");
    static STRUCT_IF_C C_BFu16s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(C_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_Ul");
    check_field_offset(lv, v3, 3, "C_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_Ul, C_BFu16s_Ul)
//============================================================================



static void Test_C_BFu16s_Us()
{
  {
    init_simple_test("C_BFu16s_Us");
    static STRUCT_IF_C C_BFu16s_Us lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "C_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_Us");
    check_field_offset(lv, v3, 3, "C_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_Us, C_BFu16s_Us)
//============================================================================



static void Test_C_BFu16s_Vp()
{
  {
    init_simple_test("C_BFu16s_Vp");
    static STRUCT_IF_C C_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(C_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16s_Vp");
    check_field_offset(lv, v3, 3, "C_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu16s_Vp, C_BFu16s_Vp)
//============================================================================



static void Test_C_BFu17i()
{
  {
    init_simple_test("C_BFu17i");
    static STRUCT_IF_C C_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i, C_BFu17i)
//============================================================================



static void Test_C_BFu17i_BFu15i()
{
  {
    init_simple_test("C_BFu17i_BFu15i");
    static STRUCT_IF_C C_BFu17i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu15i, C_BFu17i_BFu15i)
//============================================================================



static void Test_C_BFu17i_BFu15ll()
{
  {
    init_simple_test("C_BFu17i_BFu15ll");
    static STRUCT_IF_C C_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu15ll, C_BFu17i_BFu15ll)
//============================================================================



static void Test_C_BFu17i_BFu15s()
{
  {
    init_simple_test("C_BFu17i_BFu15s");
    static STRUCT_IF_C C_BFu17i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu15s, C_BFu17i_BFu15s)
//============================================================================



static void Test_C_BFu17i_BFu16i()
{
  {
    init_simple_test("C_BFu17i_BFu16i");
    static STRUCT_IF_C C_BFu17i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu16i, C_BFu17i_BFu16i)
//============================================================================



static void Test_C_BFu17i_BFu16ll()
{
  {
    init_simple_test("C_BFu17i_BFu16ll");
    static STRUCT_IF_C C_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu16ll, C_BFu17i_BFu16ll)
//============================================================================



static void Test_C_BFu17i_BFu16s()
{
  {
    init_simple_test("C_BFu17i_BFu16s");
    static STRUCT_IF_C C_BFu17i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu16s, C_BFu17i_BFu16s)
//============================================================================



static void Test_C_BFu17i_BFu17i()
{
  {
    init_simple_test("C_BFu17i_BFu17i");
    static STRUCT_IF_C C_BFu17i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "C_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "C_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu17i, C_BFu17i_BFu17i)
//============================================================================



static void Test_C_BFu17i_BFu17ll()
{
  {
    init_simple_test("C_BFu17i_BFu17ll");
    static STRUCT_IF_C C_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "C_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "C_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu17ll, C_BFu17i_BFu17ll)
//============================================================================



static void Test_C_BFu17i_BFu1c()
{
  {
    init_simple_test("C_BFu17i_BFu1c");
    static STRUCT_IF_C C_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu1c, C_BFu17i_BFu1c)
//============================================================================



static void Test_C_BFu17i_BFu1i()
{
  {
    init_simple_test("C_BFu17i_BFu1i");
    static STRUCT_IF_C C_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu1i, C_BFu17i_BFu1i)
//============================================================================



static void Test_C_BFu17i_BFu1ll()
{
  {
    init_simple_test("C_BFu17i_BFu1ll");
    static STRUCT_IF_C C_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu1ll, C_BFu17i_BFu1ll)
//============================================================================



static void Test_C_BFu17i_BFu1s()
{
  {
    init_simple_test("C_BFu17i_BFu1s");
    static STRUCT_IF_C C_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu1s, C_BFu17i_BFu1s)
//============================================================================



static void Test_C_BFu17i_BFu31i()
{
  {
    init_simple_test("C_BFu17i_BFu31i");
    static STRUCT_IF_C C_BFu17i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "C_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "C_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu31i, C_BFu17i_BFu31i)
//============================================================================



static void Test_C_BFu17i_BFu31ll()
{
  {
    init_simple_test("C_BFu17i_BFu31ll");
    static STRUCT_IF_C C_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "C_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "C_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu31ll, C_BFu17i_BFu31ll)
//============================================================================



static void Test_C_BFu17i_BFu32i()
{
  {
    init_simple_test("C_BFu17i_BFu32i");
    static STRUCT_IF_C C_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "C_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "C_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu32i, C_BFu17i_BFu32i)
//============================================================================



static void Test_C_BFu17i_BFu32ll()
{
  {
    init_simple_test("C_BFu17i_BFu32ll");
    static STRUCT_IF_C C_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "C_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "C_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu32ll, C_BFu17i_BFu32ll)
//============================================================================



static void Test_C_BFu17i_BFu33()
{
  {
    init_simple_test("C_BFu17i_BFu33");
    static STRUCT_IF_C C_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "C_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "C_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu33, C_BFu17i_BFu33)
//============================================================================



static void Test_C_BFu17i_BFu7c()
{
  {
    init_simple_test("C_BFu17i_BFu7c");
    static STRUCT_IF_C C_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu7c, C_BFu17i_BFu7c)
//============================================================================



static void Test_C_BFu17i_BFu7i()
{
  {
    init_simple_test("C_BFu17i_BFu7i");
    static STRUCT_IF_C C_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu7i, C_BFu17i_BFu7i)
//============================================================================



static void Test_C_BFu17i_BFu7ll()
{
  {
    init_simple_test("C_BFu17i_BFu7ll");
    static STRUCT_IF_C C_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu7ll, C_BFu17i_BFu7ll)
//============================================================================



static void Test_C_BFu17i_BFu7s()
{
  {
    init_simple_test("C_BFu17i_BFu7s");
    static STRUCT_IF_C C_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu7s, C_BFu17i_BFu7s)
//============================================================================



static void Test_C_BFu17i_BFu8c()
{
  {
    init_simple_test("C_BFu17i_BFu8c");
    static STRUCT_IF_C C_BFu17i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu8c, C_BFu17i_BFu8c)
//============================================================================



static void Test_C_BFu17i_BFu8i()
{
  {
    init_simple_test("C_BFu17i_BFu8i");
    static STRUCT_IF_C C_BFu17i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu8i, C_BFu17i_BFu8i)
//============================================================================



static void Test_C_BFu17i_BFu8ll()
{
  {
    init_simple_test("C_BFu17i_BFu8ll");
    static STRUCT_IF_C C_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu8ll, C_BFu17i_BFu8ll)
//============================================================================



static void Test_C_BFu17i_BFu8s()
{
  {
    init_simple_test("C_BFu17i_BFu8s");
    static STRUCT_IF_C C_BFu17i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu8s, C_BFu17i_BFu8s)
//============================================================================



static void Test_C_BFu17i_BFu9i()
{
  {
    init_simple_test("C_BFu17i_BFu9i");
    static STRUCT_IF_C C_BFu17i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu9i, C_BFu17i_BFu9i)
//============================================================================



static void Test_C_BFu17i_BFu9ll()
{
  {
    init_simple_test("C_BFu17i_BFu9ll");
    static STRUCT_IF_C C_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu9ll, C_BFu17i_BFu9ll)
//============================================================================



static void Test_C_BFu17i_BFu9s()
{
  {
    init_simple_test("C_BFu17i_BFu9s");
    static STRUCT_IF_C C_BFu17i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_BFu9s, C_BFu17i_BFu9s)
//============================================================================



static void Test_C_BFu17i_C()
{
  {
    init_simple_test("C_BFu17i_C");
    static STRUCT_IF_C C_BFu17i_C lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_C)");
    check_field_offset(lv, v1, 0, "C_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_C");
    check_field_offset(lv, v3, 4, "C_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_C, C_BFu17i_C)
//============================================================================



static void Test_C_BFu17i_D()
{
  {
    init_simple_test("C_BFu17i_D");
    static STRUCT_IF_C C_BFu17i_D lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_D)");
    check_field_offset(lv, v1, 0, "C_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_D");
    check_field_offset(lv, v3, 4, "C_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_D, C_BFu17i_D)
//============================================================================



static void Test_C_BFu17i_F()
{
  {
    init_simple_test("C_BFu17i_F");
    static STRUCT_IF_C C_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_F)");
    check_field_offset(lv, v1, 0, "C_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_F");
    check_field_offset(lv, v3, 4, "C_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_F, C_BFu17i_F)
//============================================================================



static void Test_C_BFu17i_I()
{
  {
    init_simple_test("C_BFu17i_I");
    static STRUCT_IF_C C_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_I)");
    check_field_offset(lv, v1, 0, "C_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_I");
    check_field_offset(lv, v3, 4, "C_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_I, C_BFu17i_I)
//============================================================================



static void Test_C_BFu17i_Ip()
{
  {
    init_simple_test("C_BFu17i_Ip");
    static STRUCT_IF_C C_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(C_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_Ip");
    check_field_offset(lv, v3, 4, "C_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_Ip, C_BFu17i_Ip)
//============================================================================



static void Test_C_BFu17i_L()
{
  {
    init_simple_test("C_BFu17i_L");
    static STRUCT_IF_C C_BFu17i_L lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_L)");
    check_field_offset(lv, v1, 0, "C_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_L");
    check_field_offset(lv, v3, 4, "C_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_L, C_BFu17i_L)
//============================================================================



static void Test_C_BFu17i_S()
{
  {
    init_simple_test("C_BFu17i_S");
    static STRUCT_IF_C C_BFu17i_S lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_S)");
    check_field_offset(lv, v1, 0, "C_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_S");
    check_field_offset(lv, v3, 4, "C_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_S, C_BFu17i_S)
//============================================================================



static void Test_C_BFu17i_Uc()
{
  {
    init_simple_test("C_BFu17i_Uc");
    static STRUCT_IF_C C_BFu17i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "C_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_Uc, C_BFu17i_Uc)
//============================================================================



static void Test_C_BFu17i_Ui()
{
  {
    init_simple_test("C_BFu17i_Ui");
    static STRUCT_IF_C C_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "C_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_Ui, C_BFu17i_Ui)
//============================================================================



static void Test_C_BFu17i_Ul()
{
  {
    init_simple_test("C_BFu17i_Ul");
    static STRUCT_IF_C C_BFu17i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_Ul");
    check_field_offset(lv, v3, 4, "C_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_Ul, C_BFu17i_Ul)
//============================================================================



static void Test_C_BFu17i_Us()
{
  {
    init_simple_test("C_BFu17i_Us");
    static STRUCT_IF_C C_BFu17i_Us lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_Us");
    check_field_offset(lv, v3, 4, "C_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_Us, C_BFu17i_Us)
//============================================================================



static void Test_C_BFu17i_Vp()
{
  {
    init_simple_test("C_BFu17i_Vp");
    static STRUCT_IF_C C_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(C_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_Vp");
    check_field_offset(lv, v3, 4, "C_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17i_Vp, C_BFu17i_Vp)
//============================================================================



static void Test_C_BFu17ll()
{
  {
    init_simple_test("C_BFu17ll");
    static STRUCT_IF_C C_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll, C_BFu17ll)
//============================================================================



static void Test_C_BFu17ll_BFu15i()
{
  {
    init_simple_test("C_BFu17ll_BFu15i");
    static STRUCT_IF_C C_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu15i, C_BFu17ll_BFu15i)
//============================================================================



static void Test_C_BFu17ll_BFu15ll()
{
  {
    init_simple_test("C_BFu17ll_BFu15ll");
    static STRUCT_IF_C C_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu15ll, C_BFu17ll_BFu15ll)
//============================================================================



static void Test_C_BFu17ll_BFu15s()
{
  {
    init_simple_test("C_BFu17ll_BFu15s");
    static STRUCT_IF_C C_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "C_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "C_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu15s, C_BFu17ll_BFu15s)
//============================================================================



static void Test_C_BFu17ll_BFu16i()
{
  {
    init_simple_test("C_BFu17ll_BFu16i");
    static STRUCT_IF_C C_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu16i, C_BFu17ll_BFu16i)
//============================================================================



static void Test_C_BFu17ll_BFu16ll()
{
  {
    init_simple_test("C_BFu17ll_BFu16ll");
    static STRUCT_IF_C C_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu16ll, C_BFu17ll_BFu16ll)
//============================================================================



static void Test_C_BFu17ll_BFu16s()
{
  {
    init_simple_test("C_BFu17ll_BFu16s");
    static STRUCT_IF_C C_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "C_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "C_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu16s, C_BFu17ll_BFu16s)
//============================================================================



static void Test_C_BFu17ll_BFu17i()
{
  {
    init_simple_test("C_BFu17ll_BFu17i");
    static STRUCT_IF_C C_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "C_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu17i, C_BFu17ll_BFu17i)
//============================================================================



static void Test_C_BFu17ll_BFu17ll()
{
  {
    init_simple_test("C_BFu17ll_BFu17ll");
    static STRUCT_IF_C C_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "C_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu17ll, C_BFu17ll_BFu17ll)
//============================================================================



static void Test_C_BFu17ll_BFu1c()
{
  {
    init_simple_test("C_BFu17ll_BFu1c");
    static STRUCT_IF_C C_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu1c, C_BFu17ll_BFu1c)
//============================================================================



static void Test_C_BFu17ll_BFu1i()
{
  {
    init_simple_test("C_BFu17ll_BFu1i");
    static STRUCT_IF_C C_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu1i, C_BFu17ll_BFu1i)
//============================================================================



static void Test_C_BFu17ll_BFu1ll()
{
  {
    init_simple_test("C_BFu17ll_BFu1ll");
    static STRUCT_IF_C C_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu1ll, C_BFu17ll_BFu1ll)
//============================================================================



static void Test_C_BFu17ll_BFu1s()
{
  {
    init_simple_test("C_BFu17ll_BFu1s");
    static STRUCT_IF_C C_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "C_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu1s, C_BFu17ll_BFu1s)
//============================================================================



static void Test_C_BFu17ll_BFu31i()
{
  {
    init_simple_test("C_BFu17ll_BFu31i");
    static STRUCT_IF_C C_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "C_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "C_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu31i, C_BFu17ll_BFu31i)
//============================================================================



static void Test_C_BFu17ll_BFu31ll()
{
  {
    init_simple_test("C_BFu17ll_BFu31ll");
    static STRUCT_IF_C C_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "C_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "C_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu31ll, C_BFu17ll_BFu31ll)
//============================================================================



static void Test_C_BFu17ll_BFu32i()
{
  {
    init_simple_test("C_BFu17ll_BFu32i");
    static STRUCT_IF_C C_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "C_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "C_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu32i, C_BFu17ll_BFu32i)
//============================================================================



static void Test_C_BFu17ll_BFu32ll()
{
  {
    init_simple_test("C_BFu17ll_BFu32ll");
    static STRUCT_IF_C C_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "C_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "C_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu32ll, C_BFu17ll_BFu32ll)
//============================================================================



static void Test_C_BFu17ll_BFu33()
{
  {
    init_simple_test("C_BFu17ll_BFu33");
    static STRUCT_IF_C C_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "C_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "C_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu33, C_BFu17ll_BFu33)
//============================================================================



static void Test_C_BFu17ll_BFu7c()
{
  {
    init_simple_test("C_BFu17ll_BFu7c");
    static STRUCT_IF_C C_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu7c, C_BFu17ll_BFu7c)
//============================================================================



static void Test_C_BFu17ll_BFu7i()
{
  {
    init_simple_test("C_BFu17ll_BFu7i");
    static STRUCT_IF_C C_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu7i, C_BFu17ll_BFu7i)
//============================================================================



static void Test_C_BFu17ll_BFu7ll()
{
  {
    init_simple_test("C_BFu17ll_BFu7ll");
    static STRUCT_IF_C C_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu7ll, C_BFu17ll_BFu7ll)
//============================================================================



static void Test_C_BFu17ll_BFu7s()
{
  {
    init_simple_test("C_BFu17ll_BFu7s");
    static STRUCT_IF_C C_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "C_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "C_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu7s, C_BFu17ll_BFu7s)
//============================================================================



static void Test_C_BFu17ll_BFu8c()
{
  {
    init_simple_test("C_BFu17ll_BFu8c");
    static STRUCT_IF_C C_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu8c, C_BFu17ll_BFu8c)
//============================================================================



static void Test_C_BFu17ll_BFu8i()
{
  {
    init_simple_test("C_BFu17ll_BFu8i");
    static STRUCT_IF_C C_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu8i, C_BFu17ll_BFu8i)
//============================================================================



static void Test_C_BFu17ll_BFu8ll()
{
  {
    init_simple_test("C_BFu17ll_BFu8ll");
    static STRUCT_IF_C C_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu8ll, C_BFu17ll_BFu8ll)
//============================================================================



static void Test_C_BFu17ll_BFu8s()
{
  {
    init_simple_test("C_BFu17ll_BFu8s");
    static STRUCT_IF_C C_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "C_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "C_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu8s, C_BFu17ll_BFu8s)
//============================================================================



static void Test_C_BFu17ll_BFu9i()
{
  {
    init_simple_test("C_BFu17ll_BFu9i");
    static STRUCT_IF_C C_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu9i, C_BFu17ll_BFu9i)
//============================================================================



static void Test_C_BFu17ll_BFu9ll()
{
  {
    init_simple_test("C_BFu17ll_BFu9ll");
    static STRUCT_IF_C C_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu9ll, C_BFu17ll_BFu9ll)
//============================================================================



static void Test_C_BFu17ll_BFu9s()
{
  {
    init_simple_test("C_BFu17ll_BFu9s");
    static STRUCT_IF_C C_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "C_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "C_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_BFu9s, C_BFu17ll_BFu9s)
//============================================================================



static void Test_C_BFu17ll_C()
{
  {
    init_simple_test("C_BFu17ll_C");
    static STRUCT_IF_C C_BFu17ll_C lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_C");
    check_field_offset(lv, v3, 4, "C_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_C, C_BFu17ll_C)
//============================================================================



static void Test_C_BFu17ll_D()
{
  {
    init_simple_test("C_BFu17ll_D");
    static STRUCT_IF_C C_BFu17ll_D lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_D");
    check_field_offset(lv, v3, 4, "C_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_D, C_BFu17ll_D)
//============================================================================



static void Test_C_BFu17ll_F()
{
  {
    init_simple_test("C_BFu17ll_F");
    static STRUCT_IF_C C_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_F");
    check_field_offset(lv, v3, 4, "C_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_F, C_BFu17ll_F)
//============================================================================



static void Test_C_BFu17ll_I()
{
  {
    init_simple_test("C_BFu17ll_I");
    static STRUCT_IF_C C_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_I");
    check_field_offset(lv, v3, 4, "C_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_I, C_BFu17ll_I)
//============================================================================



static void Test_C_BFu17ll_Ip()
{
  {
    init_simple_test("C_BFu17ll_Ip");
    static STRUCT_IF_C C_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(C_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_Ip");
    check_field_offset(lv, v3, 4, "C_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_Ip, C_BFu17ll_Ip)
//============================================================================



static void Test_C_BFu17ll_L()
{
  {
    init_simple_test("C_BFu17ll_L");
    static STRUCT_IF_C C_BFu17ll_L lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_L");
    check_field_offset(lv, v3, 4, "C_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_L, C_BFu17ll_L)
//============================================================================



static void Test_C_BFu17ll_S()
{
  {
    init_simple_test("C_BFu17ll_S");
    static STRUCT_IF_C C_BFu17ll_S lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_S");
    check_field_offset(lv, v3, 4, "C_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_S, C_BFu17ll_S)
//============================================================================



static void Test_C_BFu17ll_Uc()
{
  {
    init_simple_test("C_BFu17ll_Uc");
    static STRUCT_IF_C C_BFu17ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "C_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_Uc, C_BFu17ll_Uc)
//============================================================================



static void Test_C_BFu17ll_Ui()
{
  {
    init_simple_test("C_BFu17ll_Ui");
    static STRUCT_IF_C C_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "C_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_Ui, C_BFu17ll_Ui)
//============================================================================



static void Test_C_BFu17ll_Ul()
{
  {
    init_simple_test("C_BFu17ll_Ul");
    static STRUCT_IF_C C_BFu17ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_Ul");
    check_field_offset(lv, v3, 4, "C_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_Ul, C_BFu17ll_Ul)
//============================================================================



static void Test_C_BFu17ll_Us()
{
  {
    init_simple_test("C_BFu17ll_Us");
    static STRUCT_IF_C C_BFu17ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "C_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_Us, C_BFu17ll_Us)
//============================================================================



static void Test_C_BFu17ll_Vp()
{
  {
    init_simple_test("C_BFu17ll_Vp");
    static STRUCT_IF_C C_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(C_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_Vp");
    check_field_offset(lv, v3, 4, "C_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu17ll_Vp, C_BFu17ll_Vp)
//============================================================================



static void Test_C_BFu1c()
{
  {
    init_simple_test("C_BFu1c");
    static STRUCT_IF_C C_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c, C_BFu1c)
//============================================================================



static void Test_C_BFu1c_BFu15i()
{
  {
    init_simple_test("C_BFu1c_BFu15i");
    static STRUCT_IF_C C_BFu1c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu15i, C_BFu1c_BFu15i)
//============================================================================



static void Test_C_BFu1c_BFu15ll()
{
  {
    init_simple_test("C_BFu1c_BFu15ll");
    static STRUCT_IF_C C_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu15ll, C_BFu1c_BFu15ll)
//============================================================================



static void Test_C_BFu1c_BFu15s()
{
  {
    init_simple_test("C_BFu1c_BFu15s");
    static STRUCT_IF_C C_BFu1c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu15s, C_BFu1c_BFu15s)
//============================================================================



static void Test_C_BFu1c_BFu16i()
{
  {
    init_simple_test("C_BFu1c_BFu16i");
    static STRUCT_IF_C C_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu16i, C_BFu1c_BFu16i)
//============================================================================



static void Test_C_BFu1c_BFu16ll()
{
  {
    init_simple_test("C_BFu1c_BFu16ll");
    static STRUCT_IF_C C_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu16ll, C_BFu1c_BFu16ll)
//============================================================================



static void Test_C_BFu1c_BFu16s()
{
  {
    init_simple_test("C_BFu1c_BFu16s");
    static STRUCT_IF_C C_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu16s, C_BFu1c_BFu16s)
//============================================================================



static void Test_C_BFu1c_BFu17i()
{
  {
    init_simple_test("C_BFu1c_BFu17i");
    static STRUCT_IF_C C_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu17i, C_BFu1c_BFu17i)
//============================================================================



static void Test_C_BFu1c_BFu17ll()
{
  {
    init_simple_test("C_BFu1c_BFu17ll");
    static STRUCT_IF_C C_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu17ll, C_BFu1c_BFu17ll)
//============================================================================



static void Test_C_BFu1c_BFu1c()
{
  {
    init_simple_test("C_BFu1c_BFu1c");
    static STRUCT_IF_C C_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu1c, C_BFu1c_BFu1c)
//============================================================================



static void Test_C_BFu1c_BFu1i()
{
  {
    init_simple_test("C_BFu1c_BFu1i");
    static STRUCT_IF_C C_BFu1c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu1i, C_BFu1c_BFu1i)
//============================================================================



static void Test_C_BFu1c_BFu1ll()
{
  {
    init_simple_test("C_BFu1c_BFu1ll");
    static STRUCT_IF_C C_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu1ll, C_BFu1c_BFu1ll)
//============================================================================



static void Test_C_BFu1c_BFu1s()
{
  {
    init_simple_test("C_BFu1c_BFu1s");
    static STRUCT_IF_C C_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu1s, C_BFu1c_BFu1s)
//============================================================================



static void Test_C_BFu1c_BFu31i()
{
  {
    init_simple_test("C_BFu1c_BFu31i");
    static STRUCT_IF_C C_BFu1c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu31i, C_BFu1c_BFu31i)
//============================================================================



static void Test_C_BFu1c_BFu31ll()
{
  {
    init_simple_test("C_BFu1c_BFu31ll");
    static STRUCT_IF_C C_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu31ll, C_BFu1c_BFu31ll)
//============================================================================



static void Test_C_BFu1c_BFu32i()
{
  {
    init_simple_test("C_BFu1c_BFu32i");
    static STRUCT_IF_C C_BFu1c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu32i, C_BFu1c_BFu32i)
//============================================================================



static void Test_C_BFu1c_BFu32ll()
{
  {
    init_simple_test("C_BFu1c_BFu32ll");
    static STRUCT_IF_C C_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu32ll, C_BFu1c_BFu32ll)
//============================================================================



static void Test_C_BFu1c_BFu33()
{
  {
    init_simple_test("C_BFu1c_BFu33");
    static STRUCT_IF_C C_BFu1c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "C_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "C_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu33, C_BFu1c_BFu33)
//============================================================================



static void Test_C_BFu1c_BFu7c()
{
  {
    init_simple_test("C_BFu1c_BFu7c");
    static STRUCT_IF_C C_BFu1c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu7c, C_BFu1c_BFu7c)
//============================================================================



static void Test_C_BFu1c_BFu7i()
{
  {
    init_simple_test("C_BFu1c_BFu7i");
    static STRUCT_IF_C C_BFu1c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu7i, C_BFu1c_BFu7i)
//============================================================================



static void Test_C_BFu1c_BFu7ll()
{
  {
    init_simple_test("C_BFu1c_BFu7ll");
    static STRUCT_IF_C C_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu7ll, C_BFu1c_BFu7ll)
//============================================================================



static void Test_C_BFu1c_BFu7s()
{
  {
    init_simple_test("C_BFu1c_BFu7s");
    static STRUCT_IF_C C_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu7s, C_BFu1c_BFu7s)
//============================================================================



static void Test_C_BFu1c_BFu8c()
{
  {
    init_simple_test("C_BFu1c_BFu8c");
    static STRUCT_IF_C C_BFu1c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu8c, C_BFu1c_BFu8c)
//============================================================================



static void Test_C_BFu1c_BFu8i()
{
  {
    init_simple_test("C_BFu1c_BFu8i");
    static STRUCT_IF_C C_BFu1c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu8i, C_BFu1c_BFu8i)
//============================================================================



static void Test_C_BFu1c_BFu8ll()
{
  {
    init_simple_test("C_BFu1c_BFu8ll");
    static STRUCT_IF_C C_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu8ll, C_BFu1c_BFu8ll)
//============================================================================



static void Test_C_BFu1c_BFu8s()
{
  {
    init_simple_test("C_BFu1c_BFu8s");
    static STRUCT_IF_C C_BFu1c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu8s, C_BFu1c_BFu8s)
//============================================================================



static void Test_C_BFu1c_BFu9i()
{
  {
    init_simple_test("C_BFu1c_BFu9i");
    static STRUCT_IF_C C_BFu1c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu9i, C_BFu1c_BFu9i)
//============================================================================



static void Test_C_BFu1c_BFu9ll()
{
  {
    init_simple_test("C_BFu1c_BFu9ll");
    static STRUCT_IF_C C_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu9ll, C_BFu1c_BFu9ll)
//============================================================================



static void Test_C_BFu1c_BFu9s()
{
  {
    init_simple_test("C_BFu1c_BFu9s");
    static STRUCT_IF_C C_BFu1c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_BFu9s, C_BFu1c_BFu9s)
//============================================================================



static void Test_C_BFu1c_C()
{
  {
    init_simple_test("C_BFu1c_C");
    static STRUCT_IF_C C_BFu1c_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_C)");
    check_field_offset(lv, v1, 0, "C_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_C");
    check_field_offset(lv, v3, 2, "C_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_C, C_BFu1c_C)
//============================================================================



static void Test_C_BFu1c_D()
{
  {
    init_simple_test("C_BFu1c_D");
    static STRUCT_IF_C C_BFu1c_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_D)");
    check_field_offset(lv, v1, 0, "C_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_D");
    check_field_offset(lv, v3, 2, "C_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_D, C_BFu1c_D)
//============================================================================



static void Test_C_BFu1c_F()
{
  {
    init_simple_test("C_BFu1c_F");
    static STRUCT_IF_C C_BFu1c_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_F)");
    check_field_offset(lv, v1, 0, "C_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_F");
    check_field_offset(lv, v3, 2, "C_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_F, C_BFu1c_F)
//============================================================================



static void Test_C_BFu1c_I()
{
  {
    init_simple_test("C_BFu1c_I");
    static STRUCT_IF_C C_BFu1c_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_I)");
    check_field_offset(lv, v1, 0, "C_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_I");
    check_field_offset(lv, v3, 2, "C_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_I, C_BFu1c_I)
//============================================================================



static void Test_C_BFu1c_Ip()
{
  {
    init_simple_test("C_BFu1c_Ip");
    static STRUCT_IF_C C_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_Ip");
    check_field_offset(lv, v3, 2, "C_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_Ip, C_BFu1c_Ip)
//============================================================================



static void Test_C_BFu1c_L()
{
  {
    init_simple_test("C_BFu1c_L");
    static STRUCT_IF_C C_BFu1c_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_L)");
    check_field_offset(lv, v1, 0, "C_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_L");
    check_field_offset(lv, v3, 2, "C_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_L, C_BFu1c_L)
//============================================================================



static void Test_C_BFu1c_S()
{
  {
    init_simple_test("C_BFu1c_S");
    static STRUCT_IF_C C_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_S)");
    check_field_offset(lv, v1, 0, "C_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_S");
    check_field_offset(lv, v3, 2, "C_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_S, C_BFu1c_S)
//============================================================================



static void Test_C_BFu1c_Uc()
{
  {
    init_simple_test("C_BFu1c_Uc");
    static STRUCT_IF_C C_BFu1c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "C_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_Uc, C_BFu1c_Uc)
//============================================================================



static void Test_C_BFu1c_Ui()
{
  {
    init_simple_test("C_BFu1c_Ui");
    static STRUCT_IF_C C_BFu1c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_Ui");
    check_field_offset(lv, v3, 2, "C_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_Ui, C_BFu1c_Ui)
//============================================================================



static void Test_C_BFu1c_Ul()
{
  {
    init_simple_test("C_BFu1c_Ul");
    static STRUCT_IF_C C_BFu1c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_Ul");
    check_field_offset(lv, v3, 2, "C_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_Ul, C_BFu1c_Ul)
//============================================================================



static void Test_C_BFu1c_Us()
{
  {
    init_simple_test("C_BFu1c_Us");
    static STRUCT_IF_C C_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "C_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_Us");
    check_field_offset(lv, v3, 2, "C_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_Us, C_BFu1c_Us)
//============================================================================



static void Test_C_BFu1c_Vp()
{
  {
    init_simple_test("C_BFu1c_Vp");
    static STRUCT_IF_C C_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_Vp");
    check_field_offset(lv, v3, 2, "C_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1c_Vp, C_BFu1c_Vp)
//============================================================================



static void Test_C_BFu1i()
{
  {
    init_simple_test("C_BFu1i");
    static STRUCT_IF_C C_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i, C_BFu1i)
//============================================================================



static void Test_C_BFu1i_BFu15i()
{
  {
    init_simple_test("C_BFu1i_BFu15i");
    static STRUCT_IF_C C_BFu1i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu15i, C_BFu1i_BFu15i)
//============================================================================



static void Test_C_BFu1i_BFu15ll()
{
  {
    init_simple_test("C_BFu1i_BFu15ll");
    static STRUCT_IF_C C_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu15ll, C_BFu1i_BFu15ll)
//============================================================================



static void Test_C_BFu1i_BFu15s()
{
  {
    init_simple_test("C_BFu1i_BFu15s");
    static STRUCT_IF_C C_BFu1i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu15s, C_BFu1i_BFu15s)
//============================================================================



static void Test_C_BFu1i_BFu16i()
{
  {
    init_simple_test("C_BFu1i_BFu16i");
    static STRUCT_IF_C C_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu16i, C_BFu1i_BFu16i)
//============================================================================



static void Test_C_BFu1i_BFu16ll()
{
  {
    init_simple_test("C_BFu1i_BFu16ll");
    static STRUCT_IF_C C_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu16ll, C_BFu1i_BFu16ll)
//============================================================================



static void Test_C_BFu1i_BFu16s()
{
  {
    init_simple_test("C_BFu1i_BFu16s");
    static STRUCT_IF_C C_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu16s, C_BFu1i_BFu16s)
//============================================================================



static void Test_C_BFu1i_BFu17i()
{
  {
    init_simple_test("C_BFu1i_BFu17i");
    static STRUCT_IF_C C_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu17i, C_BFu1i_BFu17i)
//============================================================================



static void Test_C_BFu1i_BFu17ll()
{
  {
    init_simple_test("C_BFu1i_BFu17ll");
    static STRUCT_IF_C C_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu17ll, C_BFu1i_BFu17ll)
//============================================================================



static void Test_C_BFu1i_BFu1c()
{
  {
    init_simple_test("C_BFu1i_BFu1c");
    static STRUCT_IF_C C_BFu1i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu1c, C_BFu1i_BFu1c)
//============================================================================



static void Test_C_BFu1i_BFu1i()
{
  {
    init_simple_test("C_BFu1i_BFu1i");
    static STRUCT_IF_C C_BFu1i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu1i, C_BFu1i_BFu1i)
//============================================================================



static void Test_C_BFu1i_BFu1ll()
{
  {
    init_simple_test("C_BFu1i_BFu1ll");
    static STRUCT_IF_C C_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu1ll, C_BFu1i_BFu1ll)
//============================================================================



static void Test_C_BFu1i_BFu1s()
{
  {
    init_simple_test("C_BFu1i_BFu1s");
    static STRUCT_IF_C C_BFu1i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu1s, C_BFu1i_BFu1s)
//============================================================================



static void Test_C_BFu1i_BFu31i()
{
  {
    init_simple_test("C_BFu1i_BFu31i");
    static STRUCT_IF_C C_BFu1i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu31i, C_BFu1i_BFu31i)
//============================================================================



static void Test_C_BFu1i_BFu31ll()
{
  {
    init_simple_test("C_BFu1i_BFu31ll");
    static STRUCT_IF_C C_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu31ll, C_BFu1i_BFu31ll)
//============================================================================



static void Test_C_BFu1i_BFu32i()
{
  {
    init_simple_test("C_BFu1i_BFu32i");
    static STRUCT_IF_C C_BFu1i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu32i, C_BFu1i_BFu32i)
//============================================================================



static void Test_C_BFu1i_BFu32ll()
{
  {
    init_simple_test("C_BFu1i_BFu32ll");
    static STRUCT_IF_C C_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu32ll, C_BFu1i_BFu32ll)
//============================================================================



static void Test_C_BFu1i_BFu33()
{
  {
    init_simple_test("C_BFu1i_BFu33");
    static STRUCT_IF_C C_BFu1i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "C_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "C_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu33, C_BFu1i_BFu33)
//============================================================================



static void Test_C_BFu1i_BFu7c()
{
  {
    init_simple_test("C_BFu1i_BFu7c");
    static STRUCT_IF_C C_BFu1i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu7c, C_BFu1i_BFu7c)
//============================================================================



static void Test_C_BFu1i_BFu7i()
{
  {
    init_simple_test("C_BFu1i_BFu7i");
    static STRUCT_IF_C C_BFu1i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu7i, C_BFu1i_BFu7i)
//============================================================================



static void Test_C_BFu1i_BFu7ll()
{
  {
    init_simple_test("C_BFu1i_BFu7ll");
    static STRUCT_IF_C C_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu7ll, C_BFu1i_BFu7ll)
//============================================================================



static void Test_C_BFu1i_BFu7s()
{
  {
    init_simple_test("C_BFu1i_BFu7s");
    static STRUCT_IF_C C_BFu1i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu7s, C_BFu1i_BFu7s)
//============================================================================



static void Test_C_BFu1i_BFu8c()
{
  {
    init_simple_test("C_BFu1i_BFu8c");
    static STRUCT_IF_C C_BFu1i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu8c, C_BFu1i_BFu8c)
//============================================================================



static void Test_C_BFu1i_BFu8i()
{
  {
    init_simple_test("C_BFu1i_BFu8i");
    static STRUCT_IF_C C_BFu1i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu8i, C_BFu1i_BFu8i)
//============================================================================



static void Test_C_BFu1i_BFu8ll()
{
  {
    init_simple_test("C_BFu1i_BFu8ll");
    static STRUCT_IF_C C_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu8ll, C_BFu1i_BFu8ll)
//============================================================================



static void Test_C_BFu1i_BFu8s()
{
  {
    init_simple_test("C_BFu1i_BFu8s");
    static STRUCT_IF_C C_BFu1i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu8s, C_BFu1i_BFu8s)
//============================================================================



static void Test_C_BFu1i_BFu9i()
{
  {
    init_simple_test("C_BFu1i_BFu9i");
    static STRUCT_IF_C C_BFu1i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu9i, C_BFu1i_BFu9i)
//============================================================================



static void Test_C_BFu1i_BFu9ll()
{
  {
    init_simple_test("C_BFu1i_BFu9ll");
    static STRUCT_IF_C C_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu9ll, C_BFu1i_BFu9ll)
//============================================================================



static void Test_C_BFu1i_BFu9s()
{
  {
    init_simple_test("C_BFu1i_BFu9s");
    static STRUCT_IF_C C_BFu1i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_BFu9s, C_BFu1i_BFu9s)
//============================================================================



static void Test_C_BFu1i_C()
{
  {
    init_simple_test("C_BFu1i_C");
    static STRUCT_IF_C C_BFu1i_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_C)");
    check_field_offset(lv, v1, 0, "C_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_C");
    check_field_offset(lv, v3, 2, "C_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_C, C_BFu1i_C)
//============================================================================



static void Test_C_BFu1i_D()
{
  {
    init_simple_test("C_BFu1i_D");
    static STRUCT_IF_C C_BFu1i_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_D)");
    check_field_offset(lv, v1, 0, "C_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_D");
    check_field_offset(lv, v3, 2, "C_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_D, C_BFu1i_D)
//============================================================================



static void Test_C_BFu1i_F()
{
  {
    init_simple_test("C_BFu1i_F");
    static STRUCT_IF_C C_BFu1i_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_F)");
    check_field_offset(lv, v1, 0, "C_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_F");
    check_field_offset(lv, v3, 2, "C_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_F, C_BFu1i_F)
//============================================================================



static void Test_C_BFu1i_I()
{
  {
    init_simple_test("C_BFu1i_I");
    static STRUCT_IF_C C_BFu1i_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_I)");
    check_field_offset(lv, v1, 0, "C_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_I");
    check_field_offset(lv, v3, 2, "C_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_I, C_BFu1i_I)
//============================================================================



static void Test_C_BFu1i_Ip()
{
  {
    init_simple_test("C_BFu1i_Ip");
    static STRUCT_IF_C C_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_Ip");
    check_field_offset(lv, v3, 2, "C_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_Ip, C_BFu1i_Ip)
//============================================================================



static void Test_C_BFu1i_L()
{
  {
    init_simple_test("C_BFu1i_L");
    static STRUCT_IF_C C_BFu1i_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_L)");
    check_field_offset(lv, v1, 0, "C_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_L");
    check_field_offset(lv, v3, 2, "C_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_L, C_BFu1i_L)
//============================================================================



static void Test_C_BFu1i_S()
{
  {
    init_simple_test("C_BFu1i_S");
    static STRUCT_IF_C C_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_S)");
    check_field_offset(lv, v1, 0, "C_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_S");
    check_field_offset(lv, v3, 2, "C_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_S, C_BFu1i_S)
//============================================================================



static void Test_C_BFu1i_Uc()
{
  {
    init_simple_test("C_BFu1i_Uc");
    static STRUCT_IF_C C_BFu1i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "C_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_Uc, C_BFu1i_Uc)
//============================================================================



static void Test_C_BFu1i_Ui()
{
  {
    init_simple_test("C_BFu1i_Ui");
    static STRUCT_IF_C C_BFu1i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_Ui");
    check_field_offset(lv, v3, 2, "C_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_Ui, C_BFu1i_Ui)
//============================================================================



static void Test_C_BFu1i_Ul()
{
  {
    init_simple_test("C_BFu1i_Ul");
    static STRUCT_IF_C C_BFu1i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_Ul");
    check_field_offset(lv, v3, 2, "C_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_Ul, C_BFu1i_Ul)
//============================================================================



static void Test_C_BFu1i_Us()
{
  {
    init_simple_test("C_BFu1i_Us");
    static STRUCT_IF_C C_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_Us");
    check_field_offset(lv, v3, 2, "C_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_Us, C_BFu1i_Us)
//============================================================================



static void Test_C_BFu1i_Vp()
{
  {
    init_simple_test("C_BFu1i_Vp");
    static STRUCT_IF_C C_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_Vp");
    check_field_offset(lv, v3, 2, "C_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1i_Vp, C_BFu1i_Vp)
//============================================================================



static void Test_C_BFu1ll()
{
  {
    init_simple_test("C_BFu1ll");
    static STRUCT_IF_C C_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll, C_BFu1ll)
//============================================================================



static void Test_C_BFu1ll_BFu15i()
{
  {
    init_simple_test("C_BFu1ll_BFu15i");
    static STRUCT_IF_C C_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu15i, C_BFu1ll_BFu15i)
//============================================================================



static void Test_C_BFu1ll_BFu15ll()
{
  {
    init_simple_test("C_BFu1ll_BFu15ll");
    static STRUCT_IF_C C_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu15ll, C_BFu1ll_BFu15ll)
//============================================================================



static void Test_C_BFu1ll_BFu15s()
{
  {
    init_simple_test("C_BFu1ll_BFu15s");
    static STRUCT_IF_C C_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu15s, C_BFu1ll_BFu15s)
//============================================================================



static void Test_C_BFu1ll_BFu16i()
{
  {
    init_simple_test("C_BFu1ll_BFu16i");
    static STRUCT_IF_C C_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu16i, C_BFu1ll_BFu16i)
//============================================================================



static void Test_C_BFu1ll_BFu16ll()
{
  {
    init_simple_test("C_BFu1ll_BFu16ll");
    static STRUCT_IF_C C_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu16ll, C_BFu1ll_BFu16ll)
//============================================================================



static void Test_C_BFu1ll_BFu16s()
{
  {
    init_simple_test("C_BFu1ll_BFu16s");
    static STRUCT_IF_C C_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu16s, C_BFu1ll_BFu16s)
//============================================================================



static void Test_C_BFu1ll_BFu17i()
{
  {
    init_simple_test("C_BFu1ll_BFu17i");
    static STRUCT_IF_C C_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu17i, C_BFu1ll_BFu17i)
//============================================================================



static void Test_C_BFu1ll_BFu17ll()
{
  {
    init_simple_test("C_BFu1ll_BFu17ll");
    static STRUCT_IF_C C_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu17ll, C_BFu1ll_BFu17ll)
//============================================================================



static void Test_C_BFu1ll_BFu1c()
{
  {
    init_simple_test("C_BFu1ll_BFu1c");
    static STRUCT_IF_C C_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu1c, C_BFu1ll_BFu1c)
//============================================================================



static void Test_C_BFu1ll_BFu1i()
{
  {
    init_simple_test("C_BFu1ll_BFu1i");
    static STRUCT_IF_C C_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu1i, C_BFu1ll_BFu1i)
//============================================================================



static void Test_C_BFu1ll_BFu1ll()
{
  {
    init_simple_test("C_BFu1ll_BFu1ll");
    static STRUCT_IF_C C_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu1ll, C_BFu1ll_BFu1ll)
//============================================================================



static void Test_C_BFu1ll_BFu1s()
{
  {
    init_simple_test("C_BFu1ll_BFu1s");
    static STRUCT_IF_C C_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu1s, C_BFu1ll_BFu1s)
//============================================================================



static void Test_C_BFu1ll_BFu31i()
{
  {
    init_simple_test("C_BFu1ll_BFu31i");
    static STRUCT_IF_C C_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu31i, C_BFu1ll_BFu31i)
//============================================================================



static void Test_C_BFu1ll_BFu31ll()
{
  {
    init_simple_test("C_BFu1ll_BFu31ll");
    static STRUCT_IF_C C_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu31ll, C_BFu1ll_BFu31ll)
//============================================================================



static void Test_C_BFu1ll_BFu32i()
{
  {
    init_simple_test("C_BFu1ll_BFu32i");
    static STRUCT_IF_C C_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu32i, C_BFu1ll_BFu32i)
//============================================================================



static void Test_C_BFu1ll_BFu32ll()
{
  {
    init_simple_test("C_BFu1ll_BFu32ll");
    static STRUCT_IF_C C_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu32ll, C_BFu1ll_BFu32ll)
//============================================================================



static void Test_C_BFu1ll_BFu33()
{
  {
    init_simple_test("C_BFu1ll_BFu33");
    static STRUCT_IF_C C_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "C_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "C_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu33, C_BFu1ll_BFu33)
//============================================================================



static void Test_C_BFu1ll_BFu7c()
{
  {
    init_simple_test("C_BFu1ll_BFu7c");
    static STRUCT_IF_C C_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu7c, C_BFu1ll_BFu7c)
//============================================================================



static void Test_C_BFu1ll_BFu7i()
{
  {
    init_simple_test("C_BFu1ll_BFu7i");
    static STRUCT_IF_C C_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu7i, C_BFu1ll_BFu7i)
//============================================================================



static void Test_C_BFu1ll_BFu7ll()
{
  {
    init_simple_test("C_BFu1ll_BFu7ll");
    static STRUCT_IF_C C_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu7ll, C_BFu1ll_BFu7ll)
//============================================================================



static void Test_C_BFu1ll_BFu7s()
{
  {
    init_simple_test("C_BFu1ll_BFu7s");
    static STRUCT_IF_C C_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu7s, C_BFu1ll_BFu7s)
//============================================================================



static void Test_C_BFu1ll_BFu8c()
{
  {
    init_simple_test("C_BFu1ll_BFu8c");
    static STRUCT_IF_C C_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu8c, C_BFu1ll_BFu8c)
//============================================================================



static void Test_C_BFu1ll_BFu8i()
{
  {
    init_simple_test("C_BFu1ll_BFu8i");
    static STRUCT_IF_C C_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu8i, C_BFu1ll_BFu8i)
//============================================================================



static void Test_C_BFu1ll_BFu8ll()
{
  {
    init_simple_test("C_BFu1ll_BFu8ll");
    static STRUCT_IF_C C_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu8ll, C_BFu1ll_BFu8ll)
//============================================================================



static void Test_C_BFu1ll_BFu8s()
{
  {
    init_simple_test("C_BFu1ll_BFu8s");
    static STRUCT_IF_C C_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu8s, C_BFu1ll_BFu8s)
//============================================================================



static void Test_C_BFu1ll_BFu9i()
{
  {
    init_simple_test("C_BFu1ll_BFu9i");
    static STRUCT_IF_C C_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu9i, C_BFu1ll_BFu9i)
//============================================================================



static void Test_C_BFu1ll_BFu9ll()
{
  {
    init_simple_test("C_BFu1ll_BFu9ll");
    static STRUCT_IF_C C_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu9ll, C_BFu1ll_BFu9ll)
//============================================================================



static void Test_C_BFu1ll_BFu9s()
{
  {
    init_simple_test("C_BFu1ll_BFu9s");
    static STRUCT_IF_C C_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_BFu9s, C_BFu1ll_BFu9s)
//============================================================================



static void Test_C_BFu1ll_C()
{
  {
    init_simple_test("C_BFu1ll_C");
    static STRUCT_IF_C C_BFu1ll_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_C");
    check_field_offset(lv, v3, 2, "C_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_C, C_BFu1ll_C)
//============================================================================



static void Test_C_BFu1ll_D()
{
  {
    init_simple_test("C_BFu1ll_D");
    static STRUCT_IF_C C_BFu1ll_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_D");
    check_field_offset(lv, v3, 2, "C_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_D, C_BFu1ll_D)
//============================================================================



static void Test_C_BFu1ll_F()
{
  {
    init_simple_test("C_BFu1ll_F");
    static STRUCT_IF_C C_BFu1ll_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_F");
    check_field_offset(lv, v3, 2, "C_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_F, C_BFu1ll_F)
//============================================================================



static void Test_C_BFu1ll_I()
{
  {
    init_simple_test("C_BFu1ll_I");
    static STRUCT_IF_C C_BFu1ll_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_I");
    check_field_offset(lv, v3, 2, "C_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_I, C_BFu1ll_I)
//============================================================================



static void Test_C_BFu1ll_Ip()
{
  {
    init_simple_test("C_BFu1ll_Ip");
    static STRUCT_IF_C C_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_Ip");
    check_field_offset(lv, v3, 2, "C_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_Ip, C_BFu1ll_Ip)
//============================================================================



static void Test_C_BFu1ll_L()
{
  {
    init_simple_test("C_BFu1ll_L");
    static STRUCT_IF_C C_BFu1ll_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_L");
    check_field_offset(lv, v3, 2, "C_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_L, C_BFu1ll_L)
//============================================================================



static void Test_C_BFu1ll_S()
{
  {
    init_simple_test("C_BFu1ll_S");
    static STRUCT_IF_C C_BFu1ll_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_S");
    check_field_offset(lv, v3, 2, "C_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_S, C_BFu1ll_S)
//============================================================================



static void Test_C_BFu1ll_Uc()
{
  {
    init_simple_test("C_BFu1ll_Uc");
    static STRUCT_IF_C C_BFu1ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "C_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_Uc, C_BFu1ll_Uc)
//============================================================================



static void Test_C_BFu1ll_Ui()
{
  {
    init_simple_test("C_BFu1ll_Ui");
    static STRUCT_IF_C C_BFu1ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_Ui");
    check_field_offset(lv, v3, 2, "C_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_Ui, C_BFu1ll_Ui)
//============================================================================



static void Test_C_BFu1ll_Ul()
{
  {
    init_simple_test("C_BFu1ll_Ul");
    static STRUCT_IF_C C_BFu1ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_Ul");
    check_field_offset(lv, v3, 2, "C_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_Ul, C_BFu1ll_Ul)
//============================================================================



static void Test_C_BFu1ll_Us()
{
  {
    init_simple_test("C_BFu1ll_Us");
    static STRUCT_IF_C C_BFu1ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "C_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_Us, C_BFu1ll_Us)
//============================================================================



static void Test_C_BFu1ll_Vp()
{
  {
    init_simple_test("C_BFu1ll_Vp");
    static STRUCT_IF_C C_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_Vp");
    check_field_offset(lv, v3, 2, "C_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1ll_Vp, C_BFu1ll_Vp)
//============================================================================



static void Test_C_BFu1s()
{
  {
    init_simple_test("C_BFu1s");
    static STRUCT_IF_C C_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s, C_BFu1s)
//============================================================================



static void Test_C_BFu1s_BFu15i()
{
  {
    init_simple_test("C_BFu1s_BFu15i");
    static STRUCT_IF_C C_BFu1s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu15i, C_BFu1s_BFu15i)
//============================================================================



static void Test_C_BFu1s_BFu15ll()
{
  {
    init_simple_test("C_BFu1s_BFu15ll");
    static STRUCT_IF_C C_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu15ll, C_BFu1s_BFu15ll)
//============================================================================



static void Test_C_BFu1s_BFu15s()
{
  {
    init_simple_test("C_BFu1s_BFu15s");
    static STRUCT_IF_C C_BFu1s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "C_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "C_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu15s, C_BFu1s_BFu15s)
//============================================================================



static void Test_C_BFu1s_BFu16i()
{
  {
    init_simple_test("C_BFu1s_BFu16i");
    static STRUCT_IF_C C_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu16i, C_BFu1s_BFu16i)
//============================================================================



static void Test_C_BFu1s_BFu16ll()
{
  {
    init_simple_test("C_BFu1s_BFu16ll");
    static STRUCT_IF_C C_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu16ll, C_BFu1s_BFu16ll)
//============================================================================



static void Test_C_BFu1s_BFu16s()
{
  {
    init_simple_test("C_BFu1s_BFu16s");
    static STRUCT_IF_C C_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "C_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "C_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu16s, C_BFu1s_BFu16s)
//============================================================================



static void Test_C_BFu1s_BFu17i()
{
  {
    init_simple_test("C_BFu1s_BFu17i");
    static STRUCT_IF_C C_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu17i, C_BFu1s_BFu17i)
//============================================================================



static void Test_C_BFu1s_BFu17ll()
{
  {
    init_simple_test("C_BFu1s_BFu17ll");
    static STRUCT_IF_C C_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "C_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "C_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu17ll, C_BFu1s_BFu17ll)
//============================================================================



static void Test_C_BFu1s_BFu1c()
{
  {
    init_simple_test("C_BFu1s_BFu1c");
    static STRUCT_IF_C C_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu1c, C_BFu1s_BFu1c)
//============================================================================



static void Test_C_BFu1s_BFu1i()
{
  {
    init_simple_test("C_BFu1s_BFu1i");
    static STRUCT_IF_C C_BFu1s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu1i, C_BFu1s_BFu1i)
//============================================================================



static void Test_C_BFu1s_BFu1ll()
{
  {
    init_simple_test("C_BFu1s_BFu1ll");
    static STRUCT_IF_C C_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu1ll, C_BFu1s_BFu1ll)
//============================================================================



static void Test_C_BFu1s_BFu1s()
{
  {
    init_simple_test("C_BFu1s_BFu1s");
    static STRUCT_IF_C C_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "C_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu1s, C_BFu1s_BFu1s)
//============================================================================



static void Test_C_BFu1s_BFu31i()
{
  {
    init_simple_test("C_BFu1s_BFu31i");
    static STRUCT_IF_C C_BFu1s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu31i, C_BFu1s_BFu31i)
//============================================================================



static void Test_C_BFu1s_BFu31ll()
{
  {
    init_simple_test("C_BFu1s_BFu31ll");
    static STRUCT_IF_C C_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "C_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "C_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu31ll, C_BFu1s_BFu31ll)
//============================================================================



static void Test_C_BFu1s_BFu32i()
{
  {
    init_simple_test("C_BFu1s_BFu32i");
    static STRUCT_IF_C C_BFu1s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu32i, C_BFu1s_BFu32i)
//============================================================================



static void Test_C_BFu1s_BFu32ll()
{
  {
    init_simple_test("C_BFu1s_BFu32ll");
    static STRUCT_IF_C C_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "C_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "C_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu32ll, C_BFu1s_BFu32ll)
//============================================================================



static void Test_C_BFu1s_BFu33()
{
  {
    init_simple_test("C_BFu1s_BFu33");
    static STRUCT_IF_C C_BFu1s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "C_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "C_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu33, C_BFu1s_BFu33)
//============================================================================



static void Test_C_BFu1s_BFu7c()
{
  {
    init_simple_test("C_BFu1s_BFu7c");
    static STRUCT_IF_C C_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu7c, C_BFu1s_BFu7c)
//============================================================================



static void Test_C_BFu1s_BFu7i()
{
  {
    init_simple_test("C_BFu1s_BFu7i");
    static STRUCT_IF_C C_BFu1s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu7i, C_BFu1s_BFu7i)
//============================================================================



static void Test_C_BFu1s_BFu7ll()
{
  {
    init_simple_test("C_BFu1s_BFu7ll");
    static STRUCT_IF_C C_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu7ll, C_BFu1s_BFu7ll)
//============================================================================



static void Test_C_BFu1s_BFu7s()
{
  {
    init_simple_test("C_BFu1s_BFu7s");
    static STRUCT_IF_C C_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "C_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "C_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu7s, C_BFu1s_BFu7s)
//============================================================================



static void Test_C_BFu1s_BFu8c()
{
  {
    init_simple_test("C_BFu1s_BFu8c");
    static STRUCT_IF_C C_BFu1s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu8c, C_BFu1s_BFu8c)
//============================================================================



static void Test_C_BFu1s_BFu8i()
{
  {
    init_simple_test("C_BFu1s_BFu8i");
    static STRUCT_IF_C C_BFu1s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu8i, C_BFu1s_BFu8i)
//============================================================================



static void Test_C_BFu1s_BFu8ll()
{
  {
    init_simple_test("C_BFu1s_BFu8ll");
    static STRUCT_IF_C C_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu8ll, C_BFu1s_BFu8ll)
//============================================================================



static void Test_C_BFu1s_BFu8s()
{
  {
    init_simple_test("C_BFu1s_BFu8s");
    static STRUCT_IF_C C_BFu1s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "C_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "C_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu8s, C_BFu1s_BFu8s)
//============================================================================



static void Test_C_BFu1s_BFu9i()
{
  {
    init_simple_test("C_BFu1s_BFu9i");
    static STRUCT_IF_C C_BFu1s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu9i, C_BFu1s_BFu9i)
//============================================================================



static void Test_C_BFu1s_BFu9ll()
{
  {
    init_simple_test("C_BFu1s_BFu9ll");
    static STRUCT_IF_C C_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu9ll, C_BFu1s_BFu9ll)
//============================================================================



static void Test_C_BFu1s_BFu9s()
{
  {
    init_simple_test("C_BFu1s_BFu9s");
    static STRUCT_IF_C C_BFu1s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "C_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "C_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_BFu9s, C_BFu1s_BFu9s)
//============================================================================



static void Test_C_BFu1s_C()
{
  {
    init_simple_test("C_BFu1s_C");
    static STRUCT_IF_C C_BFu1s_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_C)");
    check_field_offset(lv, v1, 0, "C_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_C");
    check_field_offset(lv, v3, 2, "C_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_C, C_BFu1s_C)
//============================================================================



static void Test_C_BFu1s_D()
{
  {
    init_simple_test("C_BFu1s_D");
    static STRUCT_IF_C C_BFu1s_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_D)");
    check_field_offset(lv, v1, 0, "C_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_D");
    check_field_offset(lv, v3, 2, "C_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_D, C_BFu1s_D)
//============================================================================



static void Test_C_BFu1s_F()
{
  {
    init_simple_test("C_BFu1s_F");
    static STRUCT_IF_C C_BFu1s_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_F)");
    check_field_offset(lv, v1, 0, "C_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_F");
    check_field_offset(lv, v3, 2, "C_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_F, C_BFu1s_F)
//============================================================================



static void Test_C_BFu1s_I()
{
  {
    init_simple_test("C_BFu1s_I");
    static STRUCT_IF_C C_BFu1s_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_I)");
    check_field_offset(lv, v1, 0, "C_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_I");
    check_field_offset(lv, v3, 2, "C_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_I, C_BFu1s_I)
//============================================================================



static void Test_C_BFu1s_Ip()
{
  {
    init_simple_test("C_BFu1s_Ip");
    static STRUCT_IF_C C_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_Ip");
    check_field_offset(lv, v3, 2, "C_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_Ip, C_BFu1s_Ip)
//============================================================================



static void Test_C_BFu1s_L()
{
  {
    init_simple_test("C_BFu1s_L");
    static STRUCT_IF_C C_BFu1s_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_L)");
    check_field_offset(lv, v1, 0, "C_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_L");
    check_field_offset(lv, v3, 2, "C_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_L, C_BFu1s_L)
//============================================================================



static void Test_C_BFu1s_S()
{
  {
    init_simple_test("C_BFu1s_S");
    static STRUCT_IF_C C_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_S)");
    check_field_offset(lv, v1, 0, "C_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_S");
    check_field_offset(lv, v3, 2, "C_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_S, C_BFu1s_S)
//============================================================================



static void Test_C_BFu1s_Uc()
{
  {
    init_simple_test("C_BFu1s_Uc");
    static STRUCT_IF_C C_BFu1s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "C_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_Uc, C_BFu1s_Uc)
//============================================================================



static void Test_C_BFu1s_Ui()
{
  {
    init_simple_test("C_BFu1s_Ui");
    static STRUCT_IF_C C_BFu1s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_Ui");
    check_field_offset(lv, v3, 2, "C_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_Ui, C_BFu1s_Ui)
//============================================================================



static void Test_C_BFu1s_Ul()
{
  {
    init_simple_test("C_BFu1s_Ul");
    static STRUCT_IF_C C_BFu1s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_Ul");
    check_field_offset(lv, v3, 2, "C_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_Ul, C_BFu1s_Ul)
//============================================================================



static void Test_C_BFu1s_Us()
{
  {
    init_simple_test("C_BFu1s_Us");
    static STRUCT_IF_C C_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "C_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_Us");
    check_field_offset(lv, v3, 2, "C_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_Us, C_BFu1s_Us)
//============================================================================



static void Test_C_BFu1s_Vp()
{
  {
    init_simple_test("C_BFu1s_Vp");
    static STRUCT_IF_C C_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_Vp");
    check_field_offset(lv, v3, 2, "C_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu1s_Vp, C_BFu1s_Vp)
//============================================================================



static void Test_C_BFu31i()
{
  {
    init_simple_test("C_BFu31i");
    static STRUCT_IF_C C_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i, C_BFu31i)
//============================================================================



static void Test_C_BFu31i_BFu15i()
{
  {
    init_simple_test("C_BFu31i_BFu15i");
    static STRUCT_IF_C C_BFu31i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "C_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "C_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu15i, C_BFu31i_BFu15i)
//============================================================================



static void Test_C_BFu31i_BFu15ll()
{
  {
    init_simple_test("C_BFu31i_BFu15ll");
    static STRUCT_IF_C C_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "C_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "C_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu15ll, C_BFu31i_BFu15ll)
//============================================================================



static void Test_C_BFu31i_BFu15s()
{
  {
    init_simple_test("C_BFu31i_BFu15s");
    static STRUCT_IF_C C_BFu31i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "C_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "C_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu15s, C_BFu31i_BFu15s)
//============================================================================



static void Test_C_BFu31i_BFu16i()
{
  {
    init_simple_test("C_BFu31i_BFu16i");
    static STRUCT_IF_C C_BFu31i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "C_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "C_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu16i, C_BFu31i_BFu16i)
//============================================================================



static void Test_C_BFu31i_BFu16ll()
{
  {
    init_simple_test("C_BFu31i_BFu16ll");
    static STRUCT_IF_C C_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "C_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "C_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu16ll, C_BFu31i_BFu16ll)
//============================================================================



static void Test_C_BFu31i_BFu16s()
{
  {
    init_simple_test("C_BFu31i_BFu16s");
    static STRUCT_IF_C C_BFu31i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "C_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "C_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu16s, C_BFu31i_BFu16s)
//============================================================================



static void Test_C_BFu31i_BFu17i()
{
  {
    init_simple_test("C_BFu31i_BFu17i");
    static STRUCT_IF_C C_BFu31i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "C_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "C_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu17i, C_BFu31i_BFu17i)
//============================================================================



static void Test_C_BFu31i_BFu17ll()
{
  {
    init_simple_test("C_BFu31i_BFu17ll");
    static STRUCT_IF_C C_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "C_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "C_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu17ll, C_BFu31i_BFu17ll)
//============================================================================



static void Test_C_BFu31i_BFu1c()
{
  {
    init_simple_test("C_BFu31i_BFu1c");
    static STRUCT_IF_C C_BFu31i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu1c, C_BFu31i_BFu1c)
//============================================================================



static void Test_C_BFu31i_BFu1i()
{
  {
    init_simple_test("C_BFu31i_BFu1i");
    static STRUCT_IF_C C_BFu31i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu1i, C_BFu31i_BFu1i)
//============================================================================



static void Test_C_BFu31i_BFu1ll()
{
  {
    init_simple_test("C_BFu31i_BFu1ll");
    static STRUCT_IF_C C_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu1ll, C_BFu31i_BFu1ll)
//============================================================================



static void Test_C_BFu31i_BFu1s()
{
  {
    init_simple_test("C_BFu31i_BFu1s");
    static STRUCT_IF_C C_BFu31i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu1s, C_BFu31i_BFu1s)
//============================================================================



static void Test_C_BFu31i_BFu31i()
{
  {
    init_simple_test("C_BFu31i_BFu31i");
    static STRUCT_IF_C C_BFu31i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "C_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "C_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu31i, C_BFu31i_BFu31i)
//============================================================================



static void Test_C_BFu31i_BFu31ll()
{
  {
    init_simple_test("C_BFu31i_BFu31ll");
    static STRUCT_IF_C C_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "C_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "C_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu31ll, C_BFu31i_BFu31ll)
//============================================================================



static void Test_C_BFu31i_BFu32i()
{
  {
    init_simple_test("C_BFu31i_BFu32i");
    static STRUCT_IF_C C_BFu31i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "C_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "C_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu32i, C_BFu31i_BFu32i)
//============================================================================



static void Test_C_BFu31i_BFu32ll()
{
  {
    init_simple_test("C_BFu31i_BFu32ll");
    static STRUCT_IF_C C_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "C_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "C_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu32ll, C_BFu31i_BFu32ll)
//============================================================================



static void Test_C_BFu31i_BFu33()
{
  {
    init_simple_test("C_BFu31i_BFu33");
    static STRUCT_IF_C C_BFu31i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "C_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "C_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu33, C_BFu31i_BFu33)
//============================================================================



static void Test_C_BFu31i_BFu7c()
{
  {
    init_simple_test("C_BFu31i_BFu7c");
    static STRUCT_IF_C C_BFu31i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu7c, C_BFu31i_BFu7c)
//============================================================================



static void Test_C_BFu31i_BFu7i()
{
  {
    init_simple_test("C_BFu31i_BFu7i");
    static STRUCT_IF_C C_BFu31i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu7i, C_BFu31i_BFu7i)
//============================================================================



static void Test_C_BFu31i_BFu7ll()
{
  {
    init_simple_test("C_BFu31i_BFu7ll");
    static STRUCT_IF_C C_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu7ll, C_BFu31i_BFu7ll)
//============================================================================



static void Test_C_BFu31i_BFu7s()
{
  {
    init_simple_test("C_BFu31i_BFu7s");
    static STRUCT_IF_C C_BFu31i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu7s, C_BFu31i_BFu7s)
//============================================================================



static void Test_C_BFu31i_BFu8c()
{
  {
    init_simple_test("C_BFu31i_BFu8c");
    static STRUCT_IF_C C_BFu31i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu8c, C_BFu31i_BFu8c)
//============================================================================



static void Test_C_BFu31i_BFu8i()
{
  {
    init_simple_test("C_BFu31i_BFu8i");
    static STRUCT_IF_C C_BFu31i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu8i, C_BFu31i_BFu8i)
//============================================================================



static void Test_C_BFu31i_BFu8ll()
{
  {
    init_simple_test("C_BFu31i_BFu8ll");
    static STRUCT_IF_C C_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu8ll, C_BFu31i_BFu8ll)
//============================================================================



static void Test_C_BFu31i_BFu8s()
{
  {
    init_simple_test("C_BFu31i_BFu8s");
    static STRUCT_IF_C C_BFu31i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu8s, C_BFu31i_BFu8s)
//============================================================================



static void Test_C_BFu31i_BFu9i()
{
  {
    init_simple_test("C_BFu31i_BFu9i");
    static STRUCT_IF_C C_BFu31i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "C_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "C_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu9i, C_BFu31i_BFu9i)
//============================================================================



static void Test_C_BFu31i_BFu9ll()
{
  {
    init_simple_test("C_BFu31i_BFu9ll");
    static STRUCT_IF_C C_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "C_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "C_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu9ll, C_BFu31i_BFu9ll)
//============================================================================



static void Test_C_BFu31i_BFu9s()
{
  {
    init_simple_test("C_BFu31i_BFu9s");
    static STRUCT_IF_C C_BFu31i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "C_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "C_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_BFu9s, C_BFu31i_BFu9s)
//============================================================================



static void Test_C_BFu31i_C()
{
  {
    init_simple_test("C_BFu31i_C");
    static STRUCT_IF_C C_BFu31i_C lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_C)");
    check_field_offset(lv, v1, 0, "C_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_C");
    check_field_offset(lv, v3, 5, "C_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_C, C_BFu31i_C)
//============================================================================



static void Test_C_BFu31i_D()
{
  {
    init_simple_test("C_BFu31i_D");
    static STRUCT_IF_C C_BFu31i_D lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_D)");
    check_field_offset(lv, v1, 0, "C_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_D");
    check_field_offset(lv, v3, 5, "C_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_D, C_BFu31i_D)
//============================================================================



static void Test_C_BFu31i_F()
{
  {
    init_simple_test("C_BFu31i_F");
    static STRUCT_IF_C C_BFu31i_F lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_F)");
    check_field_offset(lv, v1, 0, "C_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_F");
    check_field_offset(lv, v3, 5, "C_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_F, C_BFu31i_F)
//============================================================================



static void Test_C_BFu31i_I()
{
  {
    init_simple_test("C_BFu31i_I");
    static STRUCT_IF_C C_BFu31i_I lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_I)");
    check_field_offset(lv, v1, 0, "C_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_I");
    check_field_offset(lv, v3, 5, "C_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_I, C_BFu31i_I)
//============================================================================



static void Test_C_BFu31i_Ip()
{
  {
    init_simple_test("C_BFu31i_Ip");
    static STRUCT_IF_C C_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_Ip");
    check_field_offset(lv, v3, 5, "C_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_Ip, C_BFu31i_Ip)
//============================================================================



static void Test_C_BFu31i_L()
{
  {
    init_simple_test("C_BFu31i_L");
    static STRUCT_IF_C C_BFu31i_L lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_L)");
    check_field_offset(lv, v1, 0, "C_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_L");
    check_field_offset(lv, v3, 5, "C_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_L, C_BFu31i_L)
//============================================================================



static void Test_C_BFu31i_S()
{
  {
    init_simple_test("C_BFu31i_S");
    static STRUCT_IF_C C_BFu31i_S lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_S)");
    check_field_offset(lv, v1, 0, "C_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_S");
    check_field_offset(lv, v3, 5, "C_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_S, C_BFu31i_S)
//============================================================================



static void Test_C_BFu31i_Uc()
{
  {
    init_simple_test("C_BFu31i_Uc");
    static STRUCT_IF_C C_BFu31i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_Uc");
    check_field_offset(lv, v3, 5, "C_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_Uc, C_BFu31i_Uc)
//============================================================================



static void Test_C_BFu31i_Ui()
{
  {
    init_simple_test("C_BFu31i_Ui");
    static STRUCT_IF_C C_BFu31i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_Ui");
    check_field_offset(lv, v3, 5, "C_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_Ui, C_BFu31i_Ui)
//============================================================================



static void Test_C_BFu31i_Ul()
{
  {
    init_simple_test("C_BFu31i_Ul");
    static STRUCT_IF_C C_BFu31i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_Ul");
    check_field_offset(lv, v3, 5, "C_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_Ul, C_BFu31i_Ul)
//============================================================================



static void Test_C_BFu31i_Us()
{
  {
    init_simple_test("C_BFu31i_Us");
    static STRUCT_IF_C C_BFu31i_Us lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_Us");
    check_field_offset(lv, v3, 5, "C_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_Us, C_BFu31i_Us)
//============================================================================



static void Test_C_BFu31i_Vp()
{
  {
    init_simple_test("C_BFu31i_Vp");
    static STRUCT_IF_C C_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31i_Vp");
    check_field_offset(lv, v3, 5, "C_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31i_Vp, C_BFu31i_Vp)
//============================================================================



static void Test_C_BFu31ll()
{
  {
    init_simple_test("C_BFu31ll");
    static STRUCT_IF_C C_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll, C_BFu31ll)
//============================================================================



static void Test_C_BFu31ll_BFu15i()
{
  {
    init_simple_test("C_BFu31ll_BFu15i");
    static STRUCT_IF_C C_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "C_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "C_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu15i, C_BFu31ll_BFu15i)
//============================================================================



static void Test_C_BFu31ll_BFu15ll()
{
  {
    init_simple_test("C_BFu31ll_BFu15ll");
    static STRUCT_IF_C C_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "C_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "C_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu15ll, C_BFu31ll_BFu15ll)
//============================================================================



static void Test_C_BFu31ll_BFu15s()
{
  {
    init_simple_test("C_BFu31ll_BFu15s");
    static STRUCT_IF_C C_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "C_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "C_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu15s, C_BFu31ll_BFu15s)
//============================================================================



static void Test_C_BFu31ll_BFu16i()
{
  {
    init_simple_test("C_BFu31ll_BFu16i");
    static STRUCT_IF_C C_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "C_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "C_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu16i, C_BFu31ll_BFu16i)
//============================================================================



static void Test_C_BFu31ll_BFu16ll()
{
  {
    init_simple_test("C_BFu31ll_BFu16ll");
    static STRUCT_IF_C C_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "C_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "C_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu16ll, C_BFu31ll_BFu16ll)
//============================================================================



static void Test_C_BFu31ll_BFu16s()
{
  {
    init_simple_test("C_BFu31ll_BFu16s");
    static STRUCT_IF_C C_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "C_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "C_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu16s, C_BFu31ll_BFu16s)
//============================================================================



static void Test_C_BFu31ll_BFu17i()
{
  {
    init_simple_test("C_BFu31ll_BFu17i");
    static STRUCT_IF_C C_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "C_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "C_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu17i, C_BFu31ll_BFu17i)
//============================================================================



static void Test_C_BFu31ll_BFu17ll()
{
  {
    init_simple_test("C_BFu31ll_BFu17ll");
    static STRUCT_IF_C C_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "C_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "C_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu17ll, C_BFu31ll_BFu17ll)
//============================================================================



static void Test_C_BFu31ll_BFu1c()
{
  {
    init_simple_test("C_BFu31ll_BFu1c");
    static STRUCT_IF_C C_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu1c, C_BFu31ll_BFu1c)
//============================================================================



static void Test_C_BFu31ll_BFu1i()
{
  {
    init_simple_test("C_BFu31ll_BFu1i");
    static STRUCT_IF_C C_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu1i, C_BFu31ll_BFu1i)
//============================================================================



static void Test_C_BFu31ll_BFu1ll()
{
  {
    init_simple_test("C_BFu31ll_BFu1ll");
    static STRUCT_IF_C C_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu1ll, C_BFu31ll_BFu1ll)
//============================================================================



static void Test_C_BFu31ll_BFu1s()
{
  {
    init_simple_test("C_BFu31ll_BFu1s");
    static STRUCT_IF_C C_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "C_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu1s, C_BFu31ll_BFu1s)
//============================================================================



static void Test_C_BFu31ll_BFu31i()
{
  {
    init_simple_test("C_BFu31ll_BFu31i");
    static STRUCT_IF_C C_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "C_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu31i, C_BFu31ll_BFu31i)
//============================================================================



static void Test_C_BFu31ll_BFu31ll()
{
  {
    init_simple_test("C_BFu31ll_BFu31ll");
    static STRUCT_IF_C C_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "C_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu31ll, C_BFu31ll_BFu31ll)
//============================================================================



static void Test_C_BFu31ll_BFu32i()
{
  {
    init_simple_test("C_BFu31ll_BFu32i");
    static STRUCT_IF_C C_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "C_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "C_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu32i, C_BFu31ll_BFu32i)
//============================================================================



static void Test_C_BFu31ll_BFu32ll()
{
  {
    init_simple_test("C_BFu31ll_BFu32ll");
    static STRUCT_IF_C C_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "C_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "C_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu32ll, C_BFu31ll_BFu32ll)
//============================================================================



static void Test_C_BFu31ll_BFu33()
{
  {
    init_simple_test("C_BFu31ll_BFu33");
    static STRUCT_IF_C C_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "C_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "C_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu33, C_BFu31ll_BFu33)
//============================================================================



static void Test_C_BFu31ll_BFu7c()
{
  {
    init_simple_test("C_BFu31ll_BFu7c");
    static STRUCT_IF_C C_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu7c, C_BFu31ll_BFu7c)
//============================================================================



static void Test_C_BFu31ll_BFu7i()
{
  {
    init_simple_test("C_BFu31ll_BFu7i");
    static STRUCT_IF_C C_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu7i, C_BFu31ll_BFu7i)
//============================================================================



static void Test_C_BFu31ll_BFu7ll()
{
  {
    init_simple_test("C_BFu31ll_BFu7ll");
    static STRUCT_IF_C C_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu7ll, C_BFu31ll_BFu7ll)
//============================================================================



static void Test_C_BFu31ll_BFu7s()
{
  {
    init_simple_test("C_BFu31ll_BFu7s");
    static STRUCT_IF_C C_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "C_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "C_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu7s, C_BFu31ll_BFu7s)
//============================================================================



static void Test_C_BFu31ll_BFu8c()
{
  {
    init_simple_test("C_BFu31ll_BFu8c");
    static STRUCT_IF_C C_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu8c, C_BFu31ll_BFu8c)
//============================================================================



static void Test_C_BFu31ll_BFu8i()
{
  {
    init_simple_test("C_BFu31ll_BFu8i");
    static STRUCT_IF_C C_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu8i, C_BFu31ll_BFu8i)
//============================================================================



static void Test_C_BFu31ll_BFu8ll()
{
  {
    init_simple_test("C_BFu31ll_BFu8ll");
    static STRUCT_IF_C C_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu8ll, C_BFu31ll_BFu8ll)
//============================================================================



static void Test_C_BFu31ll_BFu8s()
{
  {
    init_simple_test("C_BFu31ll_BFu8s");
    static STRUCT_IF_C C_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "C_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "C_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu8s, C_BFu31ll_BFu8s)
//============================================================================



static void Test_C_BFu31ll_BFu9i()
{
  {
    init_simple_test("C_BFu31ll_BFu9i");
    static STRUCT_IF_C C_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "C_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "C_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu9i, C_BFu31ll_BFu9i)
//============================================================================



static void Test_C_BFu31ll_BFu9ll()
{
  {
    init_simple_test("C_BFu31ll_BFu9ll");
    static STRUCT_IF_C C_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "C_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "C_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu9ll, C_BFu31ll_BFu9ll)
//============================================================================



static void Test_C_BFu31ll_BFu9s()
{
  {
    init_simple_test("C_BFu31ll_BFu9s");
    static STRUCT_IF_C C_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "C_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "C_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_BFu9s, C_BFu31ll_BFu9s)
//============================================================================



static void Test_C_BFu31ll_C()
{
  {
    init_simple_test("C_BFu31ll_C");
    static STRUCT_IF_C C_BFu31ll_C lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_C");
    check_field_offset(lv, v3, 5, "C_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_C, C_BFu31ll_C)
//============================================================================



static void Test_C_BFu31ll_D()
{
  {
    init_simple_test("C_BFu31ll_D");
    static STRUCT_IF_C C_BFu31ll_D lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_D");
    check_field_offset(lv, v3, 5, "C_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_D, C_BFu31ll_D)
//============================================================================



static void Test_C_BFu31ll_F()
{
  {
    init_simple_test("C_BFu31ll_F");
    static STRUCT_IF_C C_BFu31ll_F lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_F");
    check_field_offset(lv, v3, 5, "C_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_F, C_BFu31ll_F)
//============================================================================



static void Test_C_BFu31ll_I()
{
  {
    init_simple_test("C_BFu31ll_I");
    static STRUCT_IF_C C_BFu31ll_I lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_I");
    check_field_offset(lv, v3, 5, "C_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_I, C_BFu31ll_I)
//============================================================================



static void Test_C_BFu31ll_Ip()
{
  {
    init_simple_test("C_BFu31ll_Ip");
    static STRUCT_IF_C C_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_Ip");
    check_field_offset(lv, v3, 5, "C_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_Ip, C_BFu31ll_Ip)
//============================================================================



static void Test_C_BFu31ll_L()
{
  {
    init_simple_test("C_BFu31ll_L");
    static STRUCT_IF_C C_BFu31ll_L lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_L");
    check_field_offset(lv, v3, 5, "C_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_L, C_BFu31ll_L)
//============================================================================



static void Test_C_BFu31ll_S()
{
  {
    init_simple_test("C_BFu31ll_S");
    static STRUCT_IF_C C_BFu31ll_S lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_S");
    check_field_offset(lv, v3, 5, "C_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_S, C_BFu31ll_S)
//============================================================================



static void Test_C_BFu31ll_Uc()
{
  {
    init_simple_test("C_BFu31ll_Uc");
    static STRUCT_IF_C C_BFu31ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_Uc");
    check_field_offset(lv, v3, 5, "C_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_Uc, C_BFu31ll_Uc)
//============================================================================



static void Test_C_BFu31ll_Ui()
{
  {
    init_simple_test("C_BFu31ll_Ui");
    static STRUCT_IF_C C_BFu31ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_Ui");
    check_field_offset(lv, v3, 5, "C_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_Ui, C_BFu31ll_Ui)
//============================================================================



static void Test_C_BFu31ll_Ul()
{
  {
    init_simple_test("C_BFu31ll_Ul");
    static STRUCT_IF_C C_BFu31ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_Ul");
    check_field_offset(lv, v3, 5, "C_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_Ul, C_BFu31ll_Ul)
//============================================================================



static void Test_C_BFu31ll_Us()
{
  {
    init_simple_test("C_BFu31ll_Us");
    static STRUCT_IF_C C_BFu31ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_Us");
    check_field_offset(lv, v3, 5, "C_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_Us, C_BFu31ll_Us)
//============================================================================



static void Test_C_BFu31ll_Vp()
{
  {
    init_simple_test("C_BFu31ll_Vp");
    static STRUCT_IF_C C_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_Vp");
    check_field_offset(lv, v3, 5, "C_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu31ll_Vp, C_BFu31ll_Vp)
//============================================================================



static void Test_C_BFu32i()
{
  {
    init_simple_test("C_BFu32i");
    static STRUCT_IF_C C_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i, C_BFu32i)
//============================================================================



static void Test_C_BFu32i_BFu15i()
{
  {
    init_simple_test("C_BFu32i_BFu15i");
    static STRUCT_IF_C C_BFu32i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "C_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "C_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu15i, C_BFu32i_BFu15i)
//============================================================================



static void Test_C_BFu32i_BFu15ll()
{
  {
    init_simple_test("C_BFu32i_BFu15ll");
    static STRUCT_IF_C C_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "C_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "C_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu15ll, C_BFu32i_BFu15ll)
//============================================================================



static void Test_C_BFu32i_BFu15s()
{
  {
    init_simple_test("C_BFu32i_BFu15s");
    static STRUCT_IF_C C_BFu32i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "C_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "C_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu15s, C_BFu32i_BFu15s)
//============================================================================



static void Test_C_BFu32i_BFu16i()
{
  {
    init_simple_test("C_BFu32i_BFu16i");
    static STRUCT_IF_C C_BFu32i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "C_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "C_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu16i, C_BFu32i_BFu16i)
//============================================================================



static void Test_C_BFu32i_BFu16ll()
{
  {
    init_simple_test("C_BFu32i_BFu16ll");
    static STRUCT_IF_C C_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "C_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "C_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu16ll, C_BFu32i_BFu16ll)
//============================================================================



static void Test_C_BFu32i_BFu16s()
{
  {
    init_simple_test("C_BFu32i_BFu16s");
    static STRUCT_IF_C C_BFu32i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "C_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "C_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu16s, C_BFu32i_BFu16s)
//============================================================================



static void Test_C_BFu32i_BFu17i()
{
  {
    init_simple_test("C_BFu32i_BFu17i");
    static STRUCT_IF_C C_BFu32i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "C_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "C_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu17i, C_BFu32i_BFu17i)
//============================================================================



static void Test_C_BFu32i_BFu17ll()
{
  {
    init_simple_test("C_BFu32i_BFu17ll");
    static STRUCT_IF_C C_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "C_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "C_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu17ll, C_BFu32i_BFu17ll)
//============================================================================



static void Test_C_BFu32i_BFu1c()
{
  {
    init_simple_test("C_BFu32i_BFu1c");
    static STRUCT_IF_C C_BFu32i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu1c, C_BFu32i_BFu1c)
//============================================================================



static void Test_C_BFu32i_BFu1i()
{
  {
    init_simple_test("C_BFu32i_BFu1i");
    static STRUCT_IF_C C_BFu32i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu1i, C_BFu32i_BFu1i)
//============================================================================



static void Test_C_BFu32i_BFu1ll()
{
  {
    init_simple_test("C_BFu32i_BFu1ll");
    static STRUCT_IF_C C_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu1ll, C_BFu32i_BFu1ll)
//============================================================================



static void Test_C_BFu32i_BFu1s()
{
  {
    init_simple_test("C_BFu32i_BFu1s");
    static STRUCT_IF_C C_BFu32i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu1s, C_BFu32i_BFu1s)
//============================================================================



static void Test_C_BFu32i_BFu31i()
{
  {
    init_simple_test("C_BFu32i_BFu31i");
    static STRUCT_IF_C C_BFu32i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "C_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "C_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu31i, C_BFu32i_BFu31i)
//============================================================================



static void Test_C_BFu32i_BFu31ll()
{
  {
    init_simple_test("C_BFu32i_BFu31ll");
    static STRUCT_IF_C C_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "C_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "C_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu31ll, C_BFu32i_BFu31ll)
//============================================================================



static void Test_C_BFu32i_BFu32i()
{
  {
    init_simple_test("C_BFu32i_BFu32i");
    static STRUCT_IF_C C_BFu32i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "C_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu32i, C_BFu32i_BFu32i)
//============================================================================



static void Test_C_BFu32i_BFu32ll()
{
  {
    init_simple_test("C_BFu32i_BFu32ll");
    static STRUCT_IF_C C_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "C_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu32ll, C_BFu32i_BFu32ll)
//============================================================================



static void Test_C_BFu32i_BFu33()
{
  {
    init_simple_test("C_BFu32i_BFu33");
    static STRUCT_IF_C C_BFu32i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "C_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "C_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu33, C_BFu32i_BFu33)
//============================================================================



static void Test_C_BFu32i_BFu7c()
{
  {
    init_simple_test("C_BFu32i_BFu7c");
    static STRUCT_IF_C C_BFu32i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu7c, C_BFu32i_BFu7c)
//============================================================================



static void Test_C_BFu32i_BFu7i()
{
  {
    init_simple_test("C_BFu32i_BFu7i");
    static STRUCT_IF_C C_BFu32i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu7i, C_BFu32i_BFu7i)
//============================================================================



static void Test_C_BFu32i_BFu7ll()
{
  {
    init_simple_test("C_BFu32i_BFu7ll");
    static STRUCT_IF_C C_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu7ll, C_BFu32i_BFu7ll)
//============================================================================



static void Test_C_BFu32i_BFu7s()
{
  {
    init_simple_test("C_BFu32i_BFu7s");
    static STRUCT_IF_C C_BFu32i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu7s, C_BFu32i_BFu7s)
//============================================================================



static void Test_C_BFu32i_BFu8c()
{
  {
    init_simple_test("C_BFu32i_BFu8c");
    static STRUCT_IF_C C_BFu32i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu8c, C_BFu32i_BFu8c)
//============================================================================



static void Test_C_BFu32i_BFu8i()
{
  {
    init_simple_test("C_BFu32i_BFu8i");
    static STRUCT_IF_C C_BFu32i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu8i, C_BFu32i_BFu8i)
//============================================================================



static void Test_C_BFu32i_BFu8ll()
{
  {
    init_simple_test("C_BFu32i_BFu8ll");
    static STRUCT_IF_C C_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu8ll, C_BFu32i_BFu8ll)
//============================================================================



static void Test_C_BFu32i_BFu8s()
{
  {
    init_simple_test("C_BFu32i_BFu8s");
    static STRUCT_IF_C C_BFu32i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu8s, C_BFu32i_BFu8s)
//============================================================================



static void Test_C_BFu32i_BFu9i()
{
  {
    init_simple_test("C_BFu32i_BFu9i");
    static STRUCT_IF_C C_BFu32i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "C_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "C_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu9i, C_BFu32i_BFu9i)
//============================================================================



static void Test_C_BFu32i_BFu9ll()
{
  {
    init_simple_test("C_BFu32i_BFu9ll");
    static STRUCT_IF_C C_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "C_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "C_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu9ll, C_BFu32i_BFu9ll)
//============================================================================



static void Test_C_BFu32i_BFu9s()
{
  {
    init_simple_test("C_BFu32i_BFu9s");
    static STRUCT_IF_C C_BFu32i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "C_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "C_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_BFu9s, C_BFu32i_BFu9s)
//============================================================================



static void Test_C_BFu32i_C()
{
  {
    init_simple_test("C_BFu32i_C");
    static STRUCT_IF_C C_BFu32i_C lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_C)");
    check_field_offset(lv, v1, 0, "C_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_C");
    check_field_offset(lv, v3, 5, "C_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_C, C_BFu32i_C)
//============================================================================



static void Test_C_BFu32i_D()
{
  {
    init_simple_test("C_BFu32i_D");
    static STRUCT_IF_C C_BFu32i_D lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_D)");
    check_field_offset(lv, v1, 0, "C_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_D");
    check_field_offset(lv, v3, 5, "C_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_D, C_BFu32i_D)
//============================================================================



static void Test_C_BFu32i_F()
{
  {
    init_simple_test("C_BFu32i_F");
    static STRUCT_IF_C C_BFu32i_F lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_F)");
    check_field_offset(lv, v1, 0, "C_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_F");
    check_field_offset(lv, v3, 5, "C_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_F, C_BFu32i_F)
//============================================================================



static void Test_C_BFu32i_I()
{
  {
    init_simple_test("C_BFu32i_I");
    static STRUCT_IF_C C_BFu32i_I lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_I)");
    check_field_offset(lv, v1, 0, "C_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_I");
    check_field_offset(lv, v3, 5, "C_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_I, C_BFu32i_I)
//============================================================================



static void Test_C_BFu32i_Ip()
{
  {
    init_simple_test("C_BFu32i_Ip");
    static STRUCT_IF_C C_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_Ip");
    check_field_offset(lv, v3, 5, "C_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_Ip, C_BFu32i_Ip)
//============================================================================



static void Test_C_BFu32i_L()
{
  {
    init_simple_test("C_BFu32i_L");
    static STRUCT_IF_C C_BFu32i_L lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_L)");
    check_field_offset(lv, v1, 0, "C_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_L");
    check_field_offset(lv, v3, 5, "C_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_L, C_BFu32i_L)
//============================================================================



static void Test_C_BFu32i_S()
{
  {
    init_simple_test("C_BFu32i_S");
    static STRUCT_IF_C C_BFu32i_S lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_S)");
    check_field_offset(lv, v1, 0, "C_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_S");
    check_field_offset(lv, v3, 5, "C_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_S, C_BFu32i_S)
//============================================================================



static void Test_C_BFu32i_Uc()
{
  {
    init_simple_test("C_BFu32i_Uc");
    static STRUCT_IF_C C_BFu32i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_Uc");
    check_field_offset(lv, v3, 5, "C_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_Uc, C_BFu32i_Uc)
//============================================================================



static void Test_C_BFu32i_Ui()
{
  {
    init_simple_test("C_BFu32i_Ui");
    static STRUCT_IF_C C_BFu32i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_Ui");
    check_field_offset(lv, v3, 5, "C_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_Ui, C_BFu32i_Ui)
//============================================================================



static void Test_C_BFu32i_Ul()
{
  {
    init_simple_test("C_BFu32i_Ul");
    static STRUCT_IF_C C_BFu32i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_Ul");
    check_field_offset(lv, v3, 5, "C_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_Ul, C_BFu32i_Ul)
//============================================================================



static void Test_C_BFu32i_Us()
{
  {
    init_simple_test("C_BFu32i_Us");
    static STRUCT_IF_C C_BFu32i_Us lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_Us");
    check_field_offset(lv, v3, 5, "C_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_Us, C_BFu32i_Us)
//============================================================================



static void Test_C_BFu32i_Vp()
{
  {
    init_simple_test("C_BFu32i_Vp");
    static STRUCT_IF_C C_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32i_Vp");
    check_field_offset(lv, v3, 5, "C_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32i_Vp, C_BFu32i_Vp)
//============================================================================



static void Test_C_BFu32ll()
{
  {
    init_simple_test("C_BFu32ll");
    static STRUCT_IF_C C_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll, C_BFu32ll)
//============================================================================



static void Test_C_BFu32ll_BFu15i()
{
  {
    init_simple_test("C_BFu32ll_BFu15i");
    static STRUCT_IF_C C_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "C_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "C_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu15i, C_BFu32ll_BFu15i)
//============================================================================



static void Test_C_BFu32ll_BFu15ll()
{
  {
    init_simple_test("C_BFu32ll_BFu15ll");
    static STRUCT_IF_C C_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "C_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "C_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu15ll, C_BFu32ll_BFu15ll)
//============================================================================



static void Test_C_BFu32ll_BFu15s()
{
  {
    init_simple_test("C_BFu32ll_BFu15s");
    static STRUCT_IF_C C_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "C_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "C_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu15s, C_BFu32ll_BFu15s)
//============================================================================



static void Test_C_BFu32ll_BFu16i()
{
  {
    init_simple_test("C_BFu32ll_BFu16i");
    static STRUCT_IF_C C_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "C_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "C_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu16i, C_BFu32ll_BFu16i)
//============================================================================



static void Test_C_BFu32ll_BFu16ll()
{
  {
    init_simple_test("C_BFu32ll_BFu16ll");
    static STRUCT_IF_C C_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "C_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "C_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu16ll, C_BFu32ll_BFu16ll)
//============================================================================



static void Test_C_BFu32ll_BFu16s()
{
  {
    init_simple_test("C_BFu32ll_BFu16s");
    static STRUCT_IF_C C_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "C_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "C_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu16s, C_BFu32ll_BFu16s)
//============================================================================



static void Test_C_BFu32ll_BFu17i()
{
  {
    init_simple_test("C_BFu32ll_BFu17i");
    static STRUCT_IF_C C_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "C_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "C_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu17i, C_BFu32ll_BFu17i)
//============================================================================



static void Test_C_BFu32ll_BFu17ll()
{
  {
    init_simple_test("C_BFu32ll_BFu17ll");
    static STRUCT_IF_C C_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "C_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "C_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu17ll, C_BFu32ll_BFu17ll)
//============================================================================



static void Test_C_BFu32ll_BFu1c()
{
  {
    init_simple_test("C_BFu32ll_BFu1c");
    static STRUCT_IF_C C_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu1c, C_BFu32ll_BFu1c)
//============================================================================



static void Test_C_BFu32ll_BFu1i()
{
  {
    init_simple_test("C_BFu32ll_BFu1i");
    static STRUCT_IF_C C_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu1i, C_BFu32ll_BFu1i)
//============================================================================



static void Test_C_BFu32ll_BFu1ll()
{
  {
    init_simple_test("C_BFu32ll_BFu1ll");
    static STRUCT_IF_C C_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu1ll, C_BFu32ll_BFu1ll)
//============================================================================



static void Test_C_BFu32ll_BFu1s()
{
  {
    init_simple_test("C_BFu32ll_BFu1s");
    static STRUCT_IF_C C_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "C_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu1s, C_BFu32ll_BFu1s)
//============================================================================



static void Test_C_BFu32ll_BFu31i()
{
  {
    init_simple_test("C_BFu32ll_BFu31i");
    static STRUCT_IF_C C_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "C_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "C_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu31i, C_BFu32ll_BFu31i)
//============================================================================



static void Test_C_BFu32ll_BFu31ll()
{
  {
    init_simple_test("C_BFu32ll_BFu31ll");
    static STRUCT_IF_C C_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "C_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "C_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu31ll, C_BFu32ll_BFu31ll)
//============================================================================



static void Test_C_BFu32ll_BFu32i()
{
  {
    init_simple_test("C_BFu32ll_BFu32i");
    static STRUCT_IF_C C_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "C_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu32i, C_BFu32ll_BFu32i)
//============================================================================



static void Test_C_BFu32ll_BFu32ll()
{
  {
    init_simple_test("C_BFu32ll_BFu32ll");
    static STRUCT_IF_C C_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "C_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu32ll, C_BFu32ll_BFu32ll)
//============================================================================



static void Test_C_BFu32ll_BFu33()
{
  {
    init_simple_test("C_BFu32ll_BFu33");
    static STRUCT_IF_C C_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "C_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "C_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu33, C_BFu32ll_BFu33)
//============================================================================



static void Test_C_BFu32ll_BFu7c()
{
  {
    init_simple_test("C_BFu32ll_BFu7c");
    static STRUCT_IF_C C_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu7c, C_BFu32ll_BFu7c)
//============================================================================



static void Test_C_BFu32ll_BFu7i()
{
  {
    init_simple_test("C_BFu32ll_BFu7i");
    static STRUCT_IF_C C_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu7i, C_BFu32ll_BFu7i)
//============================================================================



static void Test_C_BFu32ll_BFu7ll()
{
  {
    init_simple_test("C_BFu32ll_BFu7ll");
    static STRUCT_IF_C C_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu7ll, C_BFu32ll_BFu7ll)
//============================================================================



static void Test_C_BFu32ll_BFu7s()
{
  {
    init_simple_test("C_BFu32ll_BFu7s");
    static STRUCT_IF_C C_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "C_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "C_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu7s, C_BFu32ll_BFu7s)
//============================================================================



static void Test_C_BFu32ll_BFu8c()
{
  {
    init_simple_test("C_BFu32ll_BFu8c");
    static STRUCT_IF_C C_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu8c, C_BFu32ll_BFu8c)
//============================================================================



static void Test_C_BFu32ll_BFu8i()
{
  {
    init_simple_test("C_BFu32ll_BFu8i");
    static STRUCT_IF_C C_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu8i, C_BFu32ll_BFu8i)
//============================================================================



static void Test_C_BFu32ll_BFu8ll()
{
  {
    init_simple_test("C_BFu32ll_BFu8ll");
    static STRUCT_IF_C C_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu8ll, C_BFu32ll_BFu8ll)
//============================================================================



static void Test_C_BFu32ll_BFu8s()
{
  {
    init_simple_test("C_BFu32ll_BFu8s");
    static STRUCT_IF_C C_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "C_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "C_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu8s, C_BFu32ll_BFu8s)
//============================================================================



static void Test_C_BFu32ll_BFu9i()
{
  {
    init_simple_test("C_BFu32ll_BFu9i");
    static STRUCT_IF_C C_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "C_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "C_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu9i, C_BFu32ll_BFu9i)
//============================================================================



static void Test_C_BFu32ll_BFu9ll()
{
  {
    init_simple_test("C_BFu32ll_BFu9ll");
    static STRUCT_IF_C C_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "C_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "C_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu9ll, C_BFu32ll_BFu9ll)
//============================================================================



static void Test_C_BFu32ll_BFu9s()
{
  {
    init_simple_test("C_BFu32ll_BFu9s");
    static STRUCT_IF_C C_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "C_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "C_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_BFu9s, C_BFu32ll_BFu9s)
//============================================================================



static void Test_C_BFu32ll_C()
{
  {
    init_simple_test("C_BFu32ll_C");
    static STRUCT_IF_C C_BFu32ll_C lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_C");
    check_field_offset(lv, v3, 5, "C_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_C, C_BFu32ll_C)
//============================================================================



static void Test_C_BFu32ll_D()
{
  {
    init_simple_test("C_BFu32ll_D");
    static STRUCT_IF_C C_BFu32ll_D lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_D");
    check_field_offset(lv, v3, 5, "C_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_D, C_BFu32ll_D)
//============================================================================



static void Test_C_BFu32ll_F()
{
  {
    init_simple_test("C_BFu32ll_F");
    static STRUCT_IF_C C_BFu32ll_F lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_F");
    check_field_offset(lv, v3, 5, "C_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_F, C_BFu32ll_F)
//============================================================================



static void Test_C_BFu32ll_I()
{
  {
    init_simple_test("C_BFu32ll_I");
    static STRUCT_IF_C C_BFu32ll_I lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_I");
    check_field_offset(lv, v3, 5, "C_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_I, C_BFu32ll_I)
//============================================================================



static void Test_C_BFu32ll_Ip()
{
  {
    init_simple_test("C_BFu32ll_Ip");
    static STRUCT_IF_C C_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_Ip");
    check_field_offset(lv, v3, 5, "C_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_Ip, C_BFu32ll_Ip)
//============================================================================



static void Test_C_BFu32ll_L()
{
  {
    init_simple_test("C_BFu32ll_L");
    static STRUCT_IF_C C_BFu32ll_L lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_L");
    check_field_offset(lv, v3, 5, "C_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_L, C_BFu32ll_L)
//============================================================================



static void Test_C_BFu32ll_S()
{
  {
    init_simple_test("C_BFu32ll_S");
    static STRUCT_IF_C C_BFu32ll_S lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_S");
    check_field_offset(lv, v3, 5, "C_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_S, C_BFu32ll_S)
//============================================================================



static void Test_C_BFu32ll_Uc()
{
  {
    init_simple_test("C_BFu32ll_Uc");
    static STRUCT_IF_C C_BFu32ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "C_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_Uc, C_BFu32ll_Uc)
//============================================================================



static void Test_C_BFu32ll_Ui()
{
  {
    init_simple_test("C_BFu32ll_Ui");
    static STRUCT_IF_C C_BFu32ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_Ui");
    check_field_offset(lv, v3, 5, "C_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_Ui, C_BFu32ll_Ui)
//============================================================================



static void Test_C_BFu32ll_Ul()
{
  {
    init_simple_test("C_BFu32ll_Ul");
    static STRUCT_IF_C C_BFu32ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(C_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_Ul");
    check_field_offset(lv, v3, 5, "C_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_Ul, C_BFu32ll_Ul)
//============================================================================



static void Test_C_BFu32ll_Us()
{
  {
    init_simple_test("C_BFu32ll_Us");
    static STRUCT_IF_C C_BFu32ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_Us");
    check_field_offset(lv, v3, 5, "C_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_Us, C_BFu32ll_Us)
//============================================================================



static void Test_C_BFu32ll_Vp()
{
  {
    init_simple_test("C_BFu32ll_Vp");
    static STRUCT_IF_C C_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(C_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_Vp");
    check_field_offset(lv, v3, 5, "C_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu32ll_Vp, C_BFu32ll_Vp)
//============================================================================



static void Test_C_BFu33()
{
  {
    init_simple_test("C_BFu33");
    static STRUCT_IF_C C_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33, C_BFu33)
//============================================================================



static void Test_C_BFu33_BFu15i()
{
  {
    init_simple_test("C_BFu33_BFu15i");
    static STRUCT_IF_C C_BFu33_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "C_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "C_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu15i, C_BFu33_BFu15i)
//============================================================================



static void Test_C_BFu33_BFu15ll()
{
  {
    init_simple_test("C_BFu33_BFu15ll");
    static STRUCT_IF_C C_BFu33_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "C_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "C_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu15ll, C_BFu33_BFu15ll)
//============================================================================



static void Test_C_BFu33_BFu15s()
{
  {
    init_simple_test("C_BFu33_BFu15s");
    static STRUCT_IF_C C_BFu33_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "C_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "C_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu15s, C_BFu33_BFu15s)
//============================================================================



static void Test_C_BFu33_BFu16i()
{
  {
    init_simple_test("C_BFu33_BFu16i");
    static STRUCT_IF_C C_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "C_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "C_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu16i, C_BFu33_BFu16i)
//============================================================================



static void Test_C_BFu33_BFu16ll()
{
  {
    init_simple_test("C_BFu33_BFu16ll");
    static STRUCT_IF_C C_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "C_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "C_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu16ll, C_BFu33_BFu16ll)
//============================================================================



static void Test_C_BFu33_BFu16s()
{
  {
    init_simple_test("C_BFu33_BFu16s");
    static STRUCT_IF_C C_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "C_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "C_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu16s, C_BFu33_BFu16s)
//============================================================================



static void Test_C_BFu33_BFu17i()
{
  {
    init_simple_test("C_BFu33_BFu17i");
    static STRUCT_IF_C C_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "C_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "C_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu17i, C_BFu33_BFu17i)
//============================================================================



static void Test_C_BFu33_BFu17ll()
{
  {
    init_simple_test("C_BFu33_BFu17ll");
    static STRUCT_IF_C C_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "C_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "C_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu17ll, C_BFu33_BFu17ll)
//============================================================================



static void Test_C_BFu33_BFu1c()
{
  {
    init_simple_test("C_BFu33_BFu1c");
    static STRUCT_IF_C C_BFu33_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "C_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu1c, C_BFu33_BFu1c)
//============================================================================



static void Test_C_BFu33_BFu1i()
{
  {
    init_simple_test("C_BFu33_BFu1i");
    static STRUCT_IF_C C_BFu33_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "C_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu1i, C_BFu33_BFu1i)
//============================================================================



static void Test_C_BFu33_BFu1ll()
{
  {
    init_simple_test("C_BFu33_BFu1ll");
    static STRUCT_IF_C C_BFu33_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "C_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu1ll, C_BFu33_BFu1ll)
//============================================================================



static void Test_C_BFu33_BFu1s()
{
  {
    init_simple_test("C_BFu33_BFu1s");
    static STRUCT_IF_C C_BFu33_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "C_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu1s, C_BFu33_BFu1s)
//============================================================================



static void Test_C_BFu33_BFu31i()
{
  {
    init_simple_test("C_BFu33_BFu31i");
    static STRUCT_IF_C C_BFu33_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "C_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "C_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu31i, C_BFu33_BFu31i)
//============================================================================



static void Test_C_BFu33_BFu31ll()
{
  {
    init_simple_test("C_BFu33_BFu31ll");
    static STRUCT_IF_C C_BFu33_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(C_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "C_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "C_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu31ll, C_BFu33_BFu31ll)
//============================================================================



static void Test_C_BFu33_BFu32i()
{
  {
    init_simple_test("C_BFu33_BFu32i");
    static STRUCT_IF_C C_BFu33_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "C_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "C_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu32i, C_BFu33_BFu32i)
//============================================================================



static void Test_C_BFu33_BFu32ll()
{
  {
    init_simple_test("C_BFu33_BFu32ll");
    static STRUCT_IF_C C_BFu33_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "C_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "C_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu32ll, C_BFu33_BFu32ll)
//============================================================================



static void Test_C_BFu33_BFu33()
{
  {
    init_simple_test("C_BFu33_BFu33");
    static STRUCT_IF_C C_BFu33_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "C_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "C_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu33, C_BFu33_BFu33)
//============================================================================



static void Test_C_BFu33_BFu7c()
{
  {
    init_simple_test("C_BFu33_BFu7c");
    static STRUCT_IF_C C_BFu33_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "C_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "C_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu7c, C_BFu33_BFu7c)
//============================================================================



static void Test_C_BFu33_BFu7i()
{
  {
    init_simple_test("C_BFu33_BFu7i");
    static STRUCT_IF_C C_BFu33_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "C_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "C_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu7i, C_BFu33_BFu7i)
//============================================================================



static void Test_C_BFu33_BFu7ll()
{
  {
    init_simple_test("C_BFu33_BFu7ll");
    static STRUCT_IF_C C_BFu33_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "C_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "C_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu7ll, C_BFu33_BFu7ll)
//============================================================================



static void Test_C_BFu33_BFu7s()
{
  {
    init_simple_test("C_BFu33_BFu7s");
    static STRUCT_IF_C C_BFu33_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "C_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "C_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu7s, C_BFu33_BFu7s)
//============================================================================



static void Test_C_BFu33_BFu8c()
{
  {
    init_simple_test("C_BFu33_BFu8c");
    static STRUCT_IF_C C_BFu33_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "C_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "C_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu8c, C_BFu33_BFu8c)
//============================================================================



static void Test_C_BFu33_BFu8i()
{
  {
    init_simple_test("C_BFu33_BFu8i");
    static STRUCT_IF_C C_BFu33_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "C_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "C_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu8i, C_BFu33_BFu8i)
//============================================================================



static void Test_C_BFu33_BFu8ll()
{
  {
    init_simple_test("C_BFu33_BFu8ll");
    static STRUCT_IF_C C_BFu33_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "C_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "C_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu8ll, C_BFu33_BFu8ll)
//============================================================================



static void Test_C_BFu33_BFu8s()
{
  {
    init_simple_test("C_BFu33_BFu8s");
    static STRUCT_IF_C C_BFu33_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "C_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "C_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu8s, C_BFu33_BFu8s)
//============================================================================



static void Test_C_BFu33_BFu9i()
{
  {
    init_simple_test("C_BFu33_BFu9i");
    static STRUCT_IF_C C_BFu33_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "C_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "C_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu9i, C_BFu33_BFu9i)
//============================================================================



static void Test_C_BFu33_BFu9ll()
{
  {
    init_simple_test("C_BFu33_BFu9ll");
    static STRUCT_IF_C C_BFu33_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "C_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "C_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu9ll, C_BFu33_BFu9ll)
//============================================================================



static void Test_C_BFu33_BFu9s()
{
  {
    init_simple_test("C_BFu33_BFu9s");
    static STRUCT_IF_C C_BFu33_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "C_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "C_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_BFu9s, C_BFu33_BFu9s)
//============================================================================



static void Test_C_BFu33_C()
{
  {
    init_simple_test("C_BFu33_C");
    static STRUCT_IF_C C_BFu33_C lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_C)");
    check_field_offset(lv, v1, 0, "C_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_C");
    check_field_offset(lv, v3, 6, "C_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_C, C_BFu33_C)
//============================================================================



static void Test_C_BFu33_D()
{
  {
    init_simple_test("C_BFu33_D");
    static STRUCT_IF_C C_BFu33_D lv;
    check2(sizeof(lv), 14, "sizeof(C_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_D)");
    check_field_offset(lv, v1, 0, "C_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_D");
    check_field_offset(lv, v3, 6, "C_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_D, C_BFu33_D)
//============================================================================



static void Test_C_BFu33_F()
{
  {
    init_simple_test("C_BFu33_F");
    static STRUCT_IF_C C_BFu33_F lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_F)");
    check_field_offset(lv, v1, 0, "C_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_F");
    check_field_offset(lv, v3, 6, "C_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_F, C_BFu33_F)
//============================================================================



static void Test_C_BFu33_I()
{
  {
    init_simple_test("C_BFu33_I");
    static STRUCT_IF_C C_BFu33_I lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_I)");
    check_field_offset(lv, v1, 0, "C_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_I");
    check_field_offset(lv, v3, 6, "C_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_I, C_BFu33_I)
//============================================================================



static void Test_C_BFu33_Ip()
{
  {
    init_simple_test("C_BFu33_Ip");
    static STRUCT_IF_C C_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(C_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Ip");
    check_field_offset(lv, v3, 6, "C_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Ip, C_BFu33_Ip)
//============================================================================



static void Test_C_BFu33_L()
{
  {
    init_simple_test("C_BFu33_L");
    static STRUCT_IF_C C_BFu33_L lv;
    check2(sizeof(lv), 14, "sizeof(C_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_L)");
    check_field_offset(lv, v1, 0, "C_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_L");
    check_field_offset(lv, v3, 6, "C_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_L, C_BFu33_L)
//============================================================================



static void Test_C_BFu33_S()
{
  {
    init_simple_test("C_BFu33_S");
    static STRUCT_IF_C C_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_S)");
    check_field_offset(lv, v1, 0, "C_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_S");
    check_field_offset(lv, v3, 6, "C_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_S, C_BFu33_S)
//============================================================================



static void Test_C_BFu33_Uc()
{
  {
    init_simple_test("C_BFu33_Uc");
    static STRUCT_IF_C C_BFu33_Uc lv;
    check2(sizeof(lv), 7, "sizeof(C_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Uc");
    check_field_offset(lv, v3, 6, "C_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Uc, C_BFu33_Uc)
//============================================================================



static void Test_C_BFu33_Ui()
{
  {
    init_simple_test("C_BFu33_Ui");
    static STRUCT_IF_C C_BFu33_Ui lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Ui");
    check_field_offset(lv, v3, 6, "C_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Ui, C_BFu33_Ui)
//============================================================================



static void Test_C_BFu33_Ul()
{
  {
    init_simple_test("C_BFu33_Ul");
    static STRUCT_IF_C C_BFu33_Ul lv;
    check2(sizeof(lv), 14, "sizeof(C_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Ul");
    check_field_offset(lv, v3, 6, "C_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Ul, C_BFu33_Ul)
//============================================================================



static void Test_C_BFu33_Us()
{
  {
    init_simple_test("C_BFu33_Us");
    static STRUCT_IF_C C_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_Us)");
    check_field_offset(lv, v1, 0, "C_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Us");
    check_field_offset(lv, v3, 6, "C_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Us, C_BFu33_Us)
//============================================================================



static void Test_C_BFu33_Vp()
{
  {
    init_simple_test("C_BFu33_Vp");
    static STRUCT_IF_C C_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(C_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_Vp");
    check_field_offset(lv, v3, 6, "C_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu33_Vp, C_BFu33_Vp)
//============================================================================



static void Test_C_BFu7c()
{
  {
    init_simple_test("C_BFu7c");
    static STRUCT_IF_C C_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c, C_BFu7c)
//============================================================================



static void Test_C_BFu7c_BFu15i()
{
  {
    init_simple_test("C_BFu7c_BFu15i");
    static STRUCT_IF_C C_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu15i, C_BFu7c_BFu15i)
//============================================================================



static void Test_C_BFu7c_BFu15ll()
{
  {
    init_simple_test("C_BFu7c_BFu15ll");
    static STRUCT_IF_C C_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu15ll, C_BFu7c_BFu15ll)
//============================================================================



static void Test_C_BFu7c_BFu15s()
{
  {
    init_simple_test("C_BFu7c_BFu15s");
    static STRUCT_IF_C C_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu15s, C_BFu7c_BFu15s)
//============================================================================



static void Test_C_BFu7c_BFu16i()
{
  {
    init_simple_test("C_BFu7c_BFu16i");
    static STRUCT_IF_C C_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu16i, C_BFu7c_BFu16i)
//============================================================================



static void Test_C_BFu7c_BFu16ll()
{
  {
    init_simple_test("C_BFu7c_BFu16ll");
    static STRUCT_IF_C C_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu16ll, C_BFu7c_BFu16ll)
//============================================================================



static void Test_C_BFu7c_BFu16s()
{
  {
    init_simple_test("C_BFu7c_BFu16s");
    static STRUCT_IF_C C_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu16s, C_BFu7c_BFu16s)
//============================================================================



static void Test_C_BFu7c_BFu17i()
{
  {
    init_simple_test("C_BFu7c_BFu17i");
    static STRUCT_IF_C C_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu17i, C_BFu7c_BFu17i)
//============================================================================



static void Test_C_BFu7c_BFu17ll()
{
  {
    init_simple_test("C_BFu7c_BFu17ll");
    static STRUCT_IF_C C_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu17ll, C_BFu7c_BFu17ll)
//============================================================================



static void Test_C_BFu7c_BFu1c()
{
  {
    init_simple_test("C_BFu7c_BFu1c");
    static STRUCT_IF_C C_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1c, C_BFu7c_BFu1c)
//============================================================================



static void Test_C_BFu7c_BFu1i()
{
  {
    init_simple_test("C_BFu7c_BFu1i");
    static STRUCT_IF_C C_BFu7c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1i, C_BFu7c_BFu1i)
//============================================================================



static void Test_C_BFu7c_BFu1ll()
{
  {
    init_simple_test("C_BFu7c_BFu1ll");
    static STRUCT_IF_C C_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1ll, C_BFu7c_BFu1ll)
//============================================================================



static void Test_C_BFu7c_BFu1s()
{
  {
    init_simple_test("C_BFu7c_BFu1s");
    static STRUCT_IF_C C_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu1s, C_BFu7c_BFu1s)
//============================================================================



static void Test_C_BFu7c_BFu31i()
{
  {
    init_simple_test("C_BFu7c_BFu31i");
    static STRUCT_IF_C C_BFu7c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu31i, C_BFu7c_BFu31i)
//============================================================================



static void Test_C_BFu7c_BFu31ll()
{
  {
    init_simple_test("C_BFu7c_BFu31ll");
    static STRUCT_IF_C C_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu31ll, C_BFu7c_BFu31ll)
//============================================================================



static void Test_C_BFu7c_BFu32i()
{
  {
    init_simple_test("C_BFu7c_BFu32i");
    static STRUCT_IF_C C_BFu7c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu32i, C_BFu7c_BFu32i)
//============================================================================



static void Test_C_BFu7c_BFu32ll()
{
  {
    init_simple_test("C_BFu7c_BFu32ll");
    static STRUCT_IF_C C_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu32ll, C_BFu7c_BFu32ll)
//============================================================================



static void Test_C_BFu7c_BFu33()
{
  {
    init_simple_test("C_BFu7c_BFu33");
    static STRUCT_IF_C C_BFu7c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu33, C_BFu7c_BFu33)
//============================================================================



static void Test_C_BFu7c_BFu7c()
{
  {
    init_simple_test("C_BFu7c_BFu7c");
    static STRUCT_IF_C C_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7c, C_BFu7c_BFu7c)
//============================================================================



static void Test_C_BFu7c_BFu7i()
{
  {
    init_simple_test("C_BFu7c_BFu7i");
    static STRUCT_IF_C C_BFu7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7i, C_BFu7c_BFu7i)
//============================================================================



static void Test_C_BFu7c_BFu7ll()
{
  {
    init_simple_test("C_BFu7c_BFu7ll");
    static STRUCT_IF_C C_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7ll, C_BFu7c_BFu7ll)
//============================================================================



static void Test_C_BFu7c_BFu7s()
{
  {
    init_simple_test("C_BFu7c_BFu7s");
    static STRUCT_IF_C C_BFu7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu7s, C_BFu7c_BFu7s)
//============================================================================



static void Test_C_BFu7c_BFu8c()
{
  {
    init_simple_test("C_BFu7c_BFu8c");
    static STRUCT_IF_C C_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8c, C_BFu7c_BFu8c)
//============================================================================



static void Test_C_BFu7c_BFu8i()
{
  {
    init_simple_test("C_BFu7c_BFu8i");
    static STRUCT_IF_C C_BFu7c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8i, C_BFu7c_BFu8i)
//============================================================================



static void Test_C_BFu7c_BFu8ll()
{
  {
    init_simple_test("C_BFu7c_BFu8ll");
    static STRUCT_IF_C C_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8ll, C_BFu7c_BFu8ll)
//============================================================================



static void Test_C_BFu7c_BFu8s()
{
  {
    init_simple_test("C_BFu7c_BFu8s");
    static STRUCT_IF_C C_BFu7c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu8s, C_BFu7c_BFu8s)
//============================================================================



static void Test_C_BFu7c_BFu9i()
{
  {
    init_simple_test("C_BFu7c_BFu9i");
    static STRUCT_IF_C C_BFu7c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu9i, C_BFu7c_BFu9i)
//============================================================================



static void Test_C_BFu7c_BFu9ll()
{
  {
    init_simple_test("C_BFu7c_BFu9ll");
    static STRUCT_IF_C C_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu9ll, C_BFu7c_BFu9ll)
//============================================================================



static void Test_C_BFu7c_BFu9s()
{
  {
    init_simple_test("C_BFu7c_BFu9s");
    static STRUCT_IF_C C_BFu7c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_BFu9s, C_BFu7c_BFu9s)
//============================================================================



static void Test_C_BFu7c_C()
{
  {
    init_simple_test("C_BFu7c_C");
    static STRUCT_IF_C C_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_C)");
    check_field_offset(lv, v1, 0, "C_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_C");
    check_field_offset(lv, v3, 2, "C_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_C, C_BFu7c_C)
//============================================================================



static void Test_C_BFu7c_D()
{
  {
    init_simple_test("C_BFu7c_D");
    static STRUCT_IF_C C_BFu7c_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_D)");
    check_field_offset(lv, v1, 0, "C_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_D");
    check_field_offset(lv, v3, 2, "C_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_D, C_BFu7c_D)
//============================================================================



static void Test_C_BFu7c_F()
{
  {
    init_simple_test("C_BFu7c_F");
    static STRUCT_IF_C C_BFu7c_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_F)");
    check_field_offset(lv, v1, 0, "C_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_F");
    check_field_offset(lv, v3, 2, "C_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_F, C_BFu7c_F)
//============================================================================



static void Test_C_BFu7c_I()
{
  {
    init_simple_test("C_BFu7c_I");
    static STRUCT_IF_C C_BFu7c_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_I)");
    check_field_offset(lv, v1, 0, "C_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_I");
    check_field_offset(lv, v3, 2, "C_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_I, C_BFu7c_I)
//============================================================================



static void Test_C_BFu7c_Ip()
{
  {
    init_simple_test("C_BFu7c_Ip");
    static STRUCT_IF_C C_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Ip");
    check_field_offset(lv, v3, 2, "C_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Ip, C_BFu7c_Ip)
//============================================================================



static void Test_C_BFu7c_L()
{
  {
    init_simple_test("C_BFu7c_L");
    static STRUCT_IF_C C_BFu7c_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_L)");
    check_field_offset(lv, v1, 0, "C_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_L");
    check_field_offset(lv, v3, 2, "C_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_L, C_BFu7c_L)
//============================================================================



static void Test_C_BFu7c_S()
{
  {
    init_simple_test("C_BFu7c_S");
    static STRUCT_IF_C C_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_S)");
    check_field_offset(lv, v1, 0, "C_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_S");
    check_field_offset(lv, v3, 2, "C_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_S, C_BFu7c_S)
//============================================================================



static void Test_C_BFu7c_Uc()
{
  {
    init_simple_test("C_BFu7c_Uc");
    static STRUCT_IF_C C_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Uc, C_BFu7c_Uc)
//============================================================================



static void Test_C_BFu7c_Ui()
{
  {
    init_simple_test("C_BFu7c_Ui");
    static STRUCT_IF_C C_BFu7c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Ui");
    check_field_offset(lv, v3, 2, "C_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Ui, C_BFu7c_Ui)
//============================================================================



static void Test_C_BFu7c_Ul()
{
  {
    init_simple_test("C_BFu7c_Ul");
    static STRUCT_IF_C C_BFu7c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Ul");
    check_field_offset(lv, v3, 2, "C_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Ul, C_BFu7c_Ul)
//============================================================================



static void Test_C_BFu7c_Us()
{
  {
    init_simple_test("C_BFu7c_Us");
    static STRUCT_IF_C C_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Us");
    check_field_offset(lv, v3, 2, "C_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Us, C_BFu7c_Us)
//============================================================================



static void Test_C_BFu7c_Vp()
{
  {
    init_simple_test("C_BFu7c_Vp");
    static STRUCT_IF_C C_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_Vp");
    check_field_offset(lv, v3, 2, "C_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7c_Vp, C_BFu7c_Vp)
//============================================================================



static void Test_C_BFu7i()
{
  {
    init_simple_test("C_BFu7i");
    static STRUCT_IF_C C_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i, C_BFu7i)
//============================================================================



static void Test_C_BFu7i_BFu15i()
{
  {
    init_simple_test("C_BFu7i_BFu15i");
    static STRUCT_IF_C C_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu15i, C_BFu7i_BFu15i)
//============================================================================



static void Test_C_BFu7i_BFu15ll()
{
  {
    init_simple_test("C_BFu7i_BFu15ll");
    static STRUCT_IF_C C_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu15ll, C_BFu7i_BFu15ll)
//============================================================================



static void Test_C_BFu7i_BFu15s()
{
  {
    init_simple_test("C_BFu7i_BFu15s");
    static STRUCT_IF_C C_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu15s, C_BFu7i_BFu15s)
//============================================================================



static void Test_C_BFu7i_BFu16i()
{
  {
    init_simple_test("C_BFu7i_BFu16i");
    static STRUCT_IF_C C_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu16i, C_BFu7i_BFu16i)
//============================================================================



static void Test_C_BFu7i_BFu16ll()
{
  {
    init_simple_test("C_BFu7i_BFu16ll");
    static STRUCT_IF_C C_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu16ll, C_BFu7i_BFu16ll)
//============================================================================



static void Test_C_BFu7i_BFu16s()
{
  {
    init_simple_test("C_BFu7i_BFu16s");
    static STRUCT_IF_C C_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu16s, C_BFu7i_BFu16s)
//============================================================================



static void Test_C_BFu7i_BFu17i()
{
  {
    init_simple_test("C_BFu7i_BFu17i");
    static STRUCT_IF_C C_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu17i, C_BFu7i_BFu17i)
//============================================================================



static void Test_C_BFu7i_BFu17ll()
{
  {
    init_simple_test("C_BFu7i_BFu17ll");
    static STRUCT_IF_C C_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu17ll, C_BFu7i_BFu17ll)
//============================================================================



static void Test_C_BFu7i_BFu1c()
{
  {
    init_simple_test("C_BFu7i_BFu1c");
    static STRUCT_IF_C C_BFu7i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1c, C_BFu7i_BFu1c)
//============================================================================



static void Test_C_BFu7i_BFu1i()
{
  {
    init_simple_test("C_BFu7i_BFu1i");
    static STRUCT_IF_C C_BFu7i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1i, C_BFu7i_BFu1i)
//============================================================================



static void Test_C_BFu7i_BFu1ll()
{
  {
    init_simple_test("C_BFu7i_BFu1ll");
    static STRUCT_IF_C C_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1ll, C_BFu7i_BFu1ll)
//============================================================================



static void Test_C_BFu7i_BFu1s()
{
  {
    init_simple_test("C_BFu7i_BFu1s");
    static STRUCT_IF_C C_BFu7i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu1s, C_BFu7i_BFu1s)
//============================================================================



static void Test_C_BFu7i_BFu31i()
{
  {
    init_simple_test("C_BFu7i_BFu31i");
    static STRUCT_IF_C C_BFu7i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu31i, C_BFu7i_BFu31i)
//============================================================================



static void Test_C_BFu7i_BFu31ll()
{
  {
    init_simple_test("C_BFu7i_BFu31ll");
    static STRUCT_IF_C C_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu31ll, C_BFu7i_BFu31ll)
//============================================================================



static void Test_C_BFu7i_BFu32i()
{
  {
    init_simple_test("C_BFu7i_BFu32i");
    static STRUCT_IF_C C_BFu7i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu32i, C_BFu7i_BFu32i)
//============================================================================



static void Test_C_BFu7i_BFu32ll()
{
  {
    init_simple_test("C_BFu7i_BFu32ll");
    static STRUCT_IF_C C_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu32ll, C_BFu7i_BFu32ll)
//============================================================================



static void Test_C_BFu7i_BFu33()
{
  {
    init_simple_test("C_BFu7i_BFu33");
    static STRUCT_IF_C C_BFu7i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu33, C_BFu7i_BFu33)
//============================================================================



static void Test_C_BFu7i_BFu7c()
{
  {
    init_simple_test("C_BFu7i_BFu7c");
    static STRUCT_IF_C C_BFu7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7c, C_BFu7i_BFu7c)
//============================================================================



static void Test_C_BFu7i_BFu7i()
{
  {
    init_simple_test("C_BFu7i_BFu7i");
    static STRUCT_IF_C C_BFu7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7i, C_BFu7i_BFu7i)
//============================================================================



static void Test_C_BFu7i_BFu7ll()
{
  {
    init_simple_test("C_BFu7i_BFu7ll");
    static STRUCT_IF_C C_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7ll, C_BFu7i_BFu7ll)
//============================================================================



static void Test_C_BFu7i_BFu7s()
{
  {
    init_simple_test("C_BFu7i_BFu7s");
    static STRUCT_IF_C C_BFu7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu7s, C_BFu7i_BFu7s)
//============================================================================



static void Test_C_BFu7i_BFu8c()
{
  {
    init_simple_test("C_BFu7i_BFu8c");
    static STRUCT_IF_C C_BFu7i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8c, C_BFu7i_BFu8c)
//============================================================================



static void Test_C_BFu7i_BFu8i()
{
  {
    init_simple_test("C_BFu7i_BFu8i");
    static STRUCT_IF_C C_BFu7i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8i, C_BFu7i_BFu8i)
//============================================================================



static void Test_C_BFu7i_BFu8ll()
{
  {
    init_simple_test("C_BFu7i_BFu8ll");
    static STRUCT_IF_C C_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8ll, C_BFu7i_BFu8ll)
//============================================================================



static void Test_C_BFu7i_BFu8s()
{
  {
    init_simple_test("C_BFu7i_BFu8s");
    static STRUCT_IF_C C_BFu7i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu8s, C_BFu7i_BFu8s)
//============================================================================



static void Test_C_BFu7i_BFu9i()
{
  {
    init_simple_test("C_BFu7i_BFu9i");
    static STRUCT_IF_C C_BFu7i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu9i, C_BFu7i_BFu9i)
//============================================================================



static void Test_C_BFu7i_BFu9ll()
{
  {
    init_simple_test("C_BFu7i_BFu9ll");
    static STRUCT_IF_C C_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu9ll, C_BFu7i_BFu9ll)
//============================================================================



static void Test_C_BFu7i_BFu9s()
{
  {
    init_simple_test("C_BFu7i_BFu9s");
    static STRUCT_IF_C C_BFu7i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_BFu9s, C_BFu7i_BFu9s)
//============================================================================



static void Test_C_BFu7i_C()
{
  {
    init_simple_test("C_BFu7i_C");
    static STRUCT_IF_C C_BFu7i_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_C)");
    check_field_offset(lv, v1, 0, "C_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_C");
    check_field_offset(lv, v3, 2, "C_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_C, C_BFu7i_C)
//============================================================================



static void Test_C_BFu7i_D()
{
  {
    init_simple_test("C_BFu7i_D");
    static STRUCT_IF_C C_BFu7i_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_D)");
    check_field_offset(lv, v1, 0, "C_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_D");
    check_field_offset(lv, v3, 2, "C_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_D, C_BFu7i_D)
//============================================================================



static void Test_C_BFu7i_F()
{
  {
    init_simple_test("C_BFu7i_F");
    static STRUCT_IF_C C_BFu7i_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_F)");
    check_field_offset(lv, v1, 0, "C_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_F");
    check_field_offset(lv, v3, 2, "C_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_F, C_BFu7i_F)
//============================================================================



static void Test_C_BFu7i_I()
{
  {
    init_simple_test("C_BFu7i_I");
    static STRUCT_IF_C C_BFu7i_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_I)");
    check_field_offset(lv, v1, 0, "C_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_I");
    check_field_offset(lv, v3, 2, "C_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_I, C_BFu7i_I)
//============================================================================



static void Test_C_BFu7i_Ip()
{
  {
    init_simple_test("C_BFu7i_Ip");
    static STRUCT_IF_C C_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Ip");
    check_field_offset(lv, v3, 2, "C_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Ip, C_BFu7i_Ip)
//============================================================================



static void Test_C_BFu7i_L()
{
  {
    init_simple_test("C_BFu7i_L");
    static STRUCT_IF_C C_BFu7i_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_L)");
    check_field_offset(lv, v1, 0, "C_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_L");
    check_field_offset(lv, v3, 2, "C_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_L, C_BFu7i_L)
//============================================================================



static void Test_C_BFu7i_S()
{
  {
    init_simple_test("C_BFu7i_S");
    static STRUCT_IF_C C_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_S)");
    check_field_offset(lv, v1, 0, "C_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_S");
    check_field_offset(lv, v3, 2, "C_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_S, C_BFu7i_S)
//============================================================================



static void Test_C_BFu7i_Uc()
{
  {
    init_simple_test("C_BFu7i_Uc");
    static STRUCT_IF_C C_BFu7i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Uc, C_BFu7i_Uc)
//============================================================================



static void Test_C_BFu7i_Ui()
{
  {
    init_simple_test("C_BFu7i_Ui");
    static STRUCT_IF_C C_BFu7i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Ui");
    check_field_offset(lv, v3, 2, "C_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Ui, C_BFu7i_Ui)
//============================================================================



static void Test_C_BFu7i_Ul()
{
  {
    init_simple_test("C_BFu7i_Ul");
    static STRUCT_IF_C C_BFu7i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Ul");
    check_field_offset(lv, v3, 2, "C_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Ul, C_BFu7i_Ul)
//============================================================================



static void Test_C_BFu7i_Us()
{
  {
    init_simple_test("C_BFu7i_Us");
    static STRUCT_IF_C C_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Us");
    check_field_offset(lv, v3, 2, "C_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Us, C_BFu7i_Us)
//============================================================================



static void Test_C_BFu7i_Vp()
{
  {
    init_simple_test("C_BFu7i_Vp");
    static STRUCT_IF_C C_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_Vp");
    check_field_offset(lv, v3, 2, "C_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7i_Vp, C_BFu7i_Vp)
//============================================================================



static void Test_C_BFu7ll()
{
  {
    init_simple_test("C_BFu7ll");
    static STRUCT_IF_C C_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll, C_BFu7ll)
//============================================================================



static void Test_C_BFu7ll_BFu15i()
{
  {
    init_simple_test("C_BFu7ll_BFu15i");
    static STRUCT_IF_C C_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu15i, C_BFu7ll_BFu15i)
//============================================================================



static void Test_C_BFu7ll_BFu15ll()
{
  {
    init_simple_test("C_BFu7ll_BFu15ll");
    static STRUCT_IF_C C_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu15ll, C_BFu7ll_BFu15ll)
//============================================================================



static void Test_C_BFu7ll_BFu15s()
{
  {
    init_simple_test("C_BFu7ll_BFu15s");
    static STRUCT_IF_C C_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu15s, C_BFu7ll_BFu15s)
//============================================================================



static void Test_C_BFu7ll_BFu16i()
{
  {
    init_simple_test("C_BFu7ll_BFu16i");
    static STRUCT_IF_C C_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu16i, C_BFu7ll_BFu16i)
//============================================================================



static void Test_C_BFu7ll_BFu16ll()
{
  {
    init_simple_test("C_BFu7ll_BFu16ll");
    static STRUCT_IF_C C_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu16ll, C_BFu7ll_BFu16ll)
//============================================================================



static void Test_C_BFu7ll_BFu16s()
{
  {
    init_simple_test("C_BFu7ll_BFu16s");
    static STRUCT_IF_C C_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu16s, C_BFu7ll_BFu16s)
//============================================================================



static void Test_C_BFu7ll_BFu17i()
{
  {
    init_simple_test("C_BFu7ll_BFu17i");
    static STRUCT_IF_C C_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu17i, C_BFu7ll_BFu17i)
//============================================================================



static void Test_C_BFu7ll_BFu17ll()
{
  {
    init_simple_test("C_BFu7ll_BFu17ll");
    static STRUCT_IF_C C_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu17ll, C_BFu7ll_BFu17ll)
//============================================================================



static void Test_C_BFu7ll_BFu1c()
{
  {
    init_simple_test("C_BFu7ll_BFu1c");
    static STRUCT_IF_C C_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1c, C_BFu7ll_BFu1c)
//============================================================================



static void Test_C_BFu7ll_BFu1i()
{
  {
    init_simple_test("C_BFu7ll_BFu1i");
    static STRUCT_IF_C C_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1i, C_BFu7ll_BFu1i)
//============================================================================



static void Test_C_BFu7ll_BFu1ll()
{
  {
    init_simple_test("C_BFu7ll_BFu1ll");
    static STRUCT_IF_C C_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1ll, C_BFu7ll_BFu1ll)
//============================================================================



static void Test_C_BFu7ll_BFu1s()
{
  {
    init_simple_test("C_BFu7ll_BFu1s");
    static STRUCT_IF_C C_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu1s, C_BFu7ll_BFu1s)
//============================================================================



static void Test_C_BFu7ll_BFu31i()
{
  {
    init_simple_test("C_BFu7ll_BFu31i");
    static STRUCT_IF_C C_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu31i, C_BFu7ll_BFu31i)
//============================================================================



static void Test_C_BFu7ll_BFu31ll()
{
  {
    init_simple_test("C_BFu7ll_BFu31ll");
    static STRUCT_IF_C C_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu31ll, C_BFu7ll_BFu31ll)
//============================================================================



static void Test_C_BFu7ll_BFu32i()
{
  {
    init_simple_test("C_BFu7ll_BFu32i");
    static STRUCT_IF_C C_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu32i, C_BFu7ll_BFu32i)
//============================================================================



static void Test_C_BFu7ll_BFu32ll()
{
  {
    init_simple_test("C_BFu7ll_BFu32ll");
    static STRUCT_IF_C C_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu32ll, C_BFu7ll_BFu32ll)
//============================================================================



static void Test_C_BFu7ll_BFu33()
{
  {
    init_simple_test("C_BFu7ll_BFu33");
    static STRUCT_IF_C C_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu33, C_BFu7ll_BFu33)
//============================================================================



static void Test_C_BFu7ll_BFu7c()
{
  {
    init_simple_test("C_BFu7ll_BFu7c");
    static STRUCT_IF_C C_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7c, C_BFu7ll_BFu7c)
//============================================================================



static void Test_C_BFu7ll_BFu7i()
{
  {
    init_simple_test("C_BFu7ll_BFu7i");
    static STRUCT_IF_C C_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7i, C_BFu7ll_BFu7i)
//============================================================================



static void Test_C_BFu7ll_BFu7ll()
{
  {
    init_simple_test("C_BFu7ll_BFu7ll");
    static STRUCT_IF_C C_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7ll, C_BFu7ll_BFu7ll)
//============================================================================



static void Test_C_BFu7ll_BFu7s()
{
  {
    init_simple_test("C_BFu7ll_BFu7s");
    static STRUCT_IF_C C_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu7s, C_BFu7ll_BFu7s)
//============================================================================



static void Test_C_BFu7ll_BFu8c()
{
  {
    init_simple_test("C_BFu7ll_BFu8c");
    static STRUCT_IF_C C_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8c, C_BFu7ll_BFu8c)
//============================================================================



static void Test_C_BFu7ll_BFu8i()
{
  {
    init_simple_test("C_BFu7ll_BFu8i");
    static STRUCT_IF_C C_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8i, C_BFu7ll_BFu8i)
//============================================================================



static void Test_C_BFu7ll_BFu8ll()
{
  {
    init_simple_test("C_BFu7ll_BFu8ll");
    static STRUCT_IF_C C_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8ll, C_BFu7ll_BFu8ll)
//============================================================================



static void Test_C_BFu7ll_BFu8s()
{
  {
    init_simple_test("C_BFu7ll_BFu8s");
    static STRUCT_IF_C C_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu8s, C_BFu7ll_BFu8s)
//============================================================================



static void Test_C_BFu7ll_BFu9i()
{
  {
    init_simple_test("C_BFu7ll_BFu9i");
    static STRUCT_IF_C C_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu9i, C_BFu7ll_BFu9i)
//============================================================================



static void Test_C_BFu7ll_BFu9ll()
{
  {
    init_simple_test("C_BFu7ll_BFu9ll");
    static STRUCT_IF_C C_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu9ll, C_BFu7ll_BFu9ll)
//============================================================================



static void Test_C_BFu7ll_BFu9s()
{
  {
    init_simple_test("C_BFu7ll_BFu9s");
    static STRUCT_IF_C C_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_BFu9s, C_BFu7ll_BFu9s)
//============================================================================



static void Test_C_BFu7ll_C()
{
  {
    init_simple_test("C_BFu7ll_C");
    static STRUCT_IF_C C_BFu7ll_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_C");
    check_field_offset(lv, v3, 2, "C_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_C, C_BFu7ll_C)
//============================================================================



static void Test_C_BFu7ll_D()
{
  {
    init_simple_test("C_BFu7ll_D");
    static STRUCT_IF_C C_BFu7ll_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_D");
    check_field_offset(lv, v3, 2, "C_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_D, C_BFu7ll_D)
//============================================================================



static void Test_C_BFu7ll_F()
{
  {
    init_simple_test("C_BFu7ll_F");
    static STRUCT_IF_C C_BFu7ll_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_F");
    check_field_offset(lv, v3, 2, "C_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_F, C_BFu7ll_F)
//============================================================================



static void Test_C_BFu7ll_I()
{
  {
    init_simple_test("C_BFu7ll_I");
    static STRUCT_IF_C C_BFu7ll_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_I");
    check_field_offset(lv, v3, 2, "C_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_I, C_BFu7ll_I)
//============================================================================



static void Test_C_BFu7ll_Ip()
{
  {
    init_simple_test("C_BFu7ll_Ip");
    static STRUCT_IF_C C_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Ip");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Ip, C_BFu7ll_Ip)
//============================================================================



static void Test_C_BFu7ll_L()
{
  {
    init_simple_test("C_BFu7ll_L");
    static STRUCT_IF_C C_BFu7ll_L lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_L");
    check_field_offset(lv, v3, 2, "C_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_L, C_BFu7ll_L)
//============================================================================



static void Test_C_BFu7ll_S()
{
  {
    init_simple_test("C_BFu7ll_S");
    static STRUCT_IF_C C_BFu7ll_S lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_S");
    check_field_offset(lv, v3, 2, "C_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_S, C_BFu7ll_S)
//============================================================================



static void Test_C_BFu7ll_Uc()
{
  {
    init_simple_test("C_BFu7ll_Uc");
    static STRUCT_IF_C C_BFu7ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Uc, C_BFu7ll_Uc)
//============================================================================



static void Test_C_BFu7ll_Ui()
{
  {
    init_simple_test("C_BFu7ll_Ui");
    static STRUCT_IF_C C_BFu7ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Ui");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Ui, C_BFu7ll_Ui)
//============================================================================



static void Test_C_BFu7ll_Ul()
{
  {
    init_simple_test("C_BFu7ll_Ul");
    static STRUCT_IF_C C_BFu7ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Ul");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Ul, C_BFu7ll_Ul)
//============================================================================



static void Test_C_BFu7ll_Us()
{
  {
    init_simple_test("C_BFu7ll_Us");
    static STRUCT_IF_C C_BFu7ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Us, C_BFu7ll_Us)
//============================================================================



static void Test_C_BFu7ll_Vp()
{
  {
    init_simple_test("C_BFu7ll_Vp");
    static STRUCT_IF_C C_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_Vp");
    check_field_offset(lv, v3, 2, "C_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7ll_Vp, C_BFu7ll_Vp)
//============================================================================



static void Test_C_BFu7s()
{
  {
    init_simple_test("C_BFu7s");
    static STRUCT_IF_C C_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s, C_BFu7s)
//============================================================================



static void Test_C_BFu7s_BFu15i()
{
  {
    init_simple_test("C_BFu7s_BFu15i");
    static STRUCT_IF_C C_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu15i, C_BFu7s_BFu15i)
//============================================================================



static void Test_C_BFu7s_BFu15ll()
{
  {
    init_simple_test("C_BFu7s_BFu15ll");
    static STRUCT_IF_C C_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu15ll, C_BFu7s_BFu15ll)
//============================================================================



static void Test_C_BFu7s_BFu15s()
{
  {
    init_simple_test("C_BFu7s_BFu15s");
    static STRUCT_IF_C C_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "C_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "C_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu15s, C_BFu7s_BFu15s)
//============================================================================



static void Test_C_BFu7s_BFu16i()
{
  {
    init_simple_test("C_BFu7s_BFu16i");
    static STRUCT_IF_C C_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu16i, C_BFu7s_BFu16i)
//============================================================================



static void Test_C_BFu7s_BFu16ll()
{
  {
    init_simple_test("C_BFu7s_BFu16ll");
    static STRUCT_IF_C C_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu16ll, C_BFu7s_BFu16ll)
//============================================================================



static void Test_C_BFu7s_BFu16s()
{
  {
    init_simple_test("C_BFu7s_BFu16s");
    static STRUCT_IF_C C_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "C_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "C_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu16s, C_BFu7s_BFu16s)
//============================================================================



static void Test_C_BFu7s_BFu17i()
{
  {
    init_simple_test("C_BFu7s_BFu17i");
    static STRUCT_IF_C C_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu17i, C_BFu7s_BFu17i)
//============================================================================



static void Test_C_BFu7s_BFu17ll()
{
  {
    init_simple_test("C_BFu7s_BFu17ll");
    static STRUCT_IF_C C_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "C_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "C_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu17ll, C_BFu7s_BFu17ll)
//============================================================================



static void Test_C_BFu7s_BFu1c()
{
  {
    init_simple_test("C_BFu7s_BFu1c");
    static STRUCT_IF_C C_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1c, C_BFu7s_BFu1c)
//============================================================================



static void Test_C_BFu7s_BFu1i()
{
  {
    init_simple_test("C_BFu7s_BFu1i");
    static STRUCT_IF_C C_BFu7s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1i, C_BFu7s_BFu1i)
//============================================================================



static void Test_C_BFu7s_BFu1ll()
{
  {
    init_simple_test("C_BFu7s_BFu1ll");
    static STRUCT_IF_C C_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1ll, C_BFu7s_BFu1ll)
//============================================================================



static void Test_C_BFu7s_BFu1s()
{
  {
    init_simple_test("C_BFu7s_BFu1s");
    static STRUCT_IF_C C_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(C_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "C_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu1s, C_BFu7s_BFu1s)
//============================================================================



static void Test_C_BFu7s_BFu31i()
{
  {
    init_simple_test("C_BFu7s_BFu31i");
    static STRUCT_IF_C C_BFu7s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu31i, C_BFu7s_BFu31i)
//============================================================================



static void Test_C_BFu7s_BFu31ll()
{
  {
    init_simple_test("C_BFu7s_BFu31ll");
    static STRUCT_IF_C C_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "C_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "C_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu31ll, C_BFu7s_BFu31ll)
//============================================================================



static void Test_C_BFu7s_BFu32i()
{
  {
    init_simple_test("C_BFu7s_BFu32i");
    static STRUCT_IF_C C_BFu7s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu32i, C_BFu7s_BFu32i)
//============================================================================



static void Test_C_BFu7s_BFu32ll()
{
  {
    init_simple_test("C_BFu7s_BFu32ll");
    static STRUCT_IF_C C_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "C_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "C_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu32ll, C_BFu7s_BFu32ll)
//============================================================================



static void Test_C_BFu7s_BFu33()
{
  {
    init_simple_test("C_BFu7s_BFu33");
    static STRUCT_IF_C C_BFu7s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "C_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "C_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu33, C_BFu7s_BFu33)
//============================================================================



static void Test_C_BFu7s_BFu7c()
{
  {
    init_simple_test("C_BFu7s_BFu7c");
    static STRUCT_IF_C C_BFu7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7c, C_BFu7s_BFu7c)
//============================================================================



static void Test_C_BFu7s_BFu7i()
{
  {
    init_simple_test("C_BFu7s_BFu7i");
    static STRUCT_IF_C C_BFu7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7i, C_BFu7s_BFu7i)
//============================================================================



static void Test_C_BFu7s_BFu7ll()
{
  {
    init_simple_test("C_BFu7s_BFu7ll");
    static STRUCT_IF_C C_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7ll, C_BFu7s_BFu7ll)
//============================================================================



static void Test_C_BFu7s_BFu7s()
{
  {
    init_simple_test("C_BFu7s_BFu7s");
    static STRUCT_IF_C C_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "C_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "C_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu7s, C_BFu7s_BFu7s)
//============================================================================



static void Test_C_BFu7s_BFu8c()
{
  {
    init_simple_test("C_BFu7s_BFu8c");
    static STRUCT_IF_C C_BFu7s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8c, C_BFu7s_BFu8c)
//============================================================================



static void Test_C_BFu7s_BFu8i()
{
  {
    init_simple_test("C_BFu7s_BFu8i");
    static STRUCT_IF_C C_BFu7s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8i, C_BFu7s_BFu8i)
//============================================================================



static void Test_C_BFu7s_BFu8ll()
{
  {
    init_simple_test("C_BFu7s_BFu8ll");
    static STRUCT_IF_C C_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8ll, C_BFu7s_BFu8ll)
//============================================================================



static void Test_C_BFu7s_BFu8s()
{
  {
    init_simple_test("C_BFu7s_BFu8s");
    static STRUCT_IF_C C_BFu7s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "C_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "C_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu8s, C_BFu7s_BFu8s)
//============================================================================



static void Test_C_BFu7s_BFu9i()
{
  {
    init_simple_test("C_BFu7s_BFu9i");
    static STRUCT_IF_C C_BFu7s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu9i, C_BFu7s_BFu9i)
//============================================================================



static void Test_C_BFu7s_BFu9ll()
{
  {
    init_simple_test("C_BFu7s_BFu9ll");
    static STRUCT_IF_C C_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu9ll, C_BFu7s_BFu9ll)
//============================================================================



static void Test_C_BFu7s_BFu9s()
{
  {
    init_simple_test("C_BFu7s_BFu9s");
    static STRUCT_IF_C C_BFu7s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "C_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "C_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "C_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_BFu9s, C_BFu7s_BFu9s)
//============================================================================



static void Test_C_BFu7s_C()
{
  {
    init_simple_test("C_BFu7s_C");
    static STRUCT_IF_C C_BFu7s_C lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_C)");
    check_field_offset(lv, v1, 0, "C_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_C");
    check_field_offset(lv, v3, 2, "C_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_C, C_BFu7s_C)
//============================================================================



static void Test_C_BFu7s_D()
{
  {
    init_simple_test("C_BFu7s_D");
    static STRUCT_IF_C C_BFu7s_D lv;
    check2(sizeof(lv), 10, "sizeof(C_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_D)");
    check_field_offset(lv, v1, 0, "C_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_D");
    check_field_offset(lv, v3, 2, "C_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_D, C_BFu7s_D)
//============================================================================



static void Test_C_BFu7s_F()
{
  {
    init_simple_test("C_BFu7s_F");
    static STRUCT_IF_C C_BFu7s_F lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_F)");
    check_field_offset(lv, v1, 0, "C_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_F");
    check_field_offset(lv, v3, 2, "C_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_F, C_BFu7s_F)
//============================================================================



static void Test_C_BFu7s_I()
{
  {
    init_simple_test("C_BFu7s_I");
    static STRUCT_IF_C C_BFu7s_I lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_I)");
    check_field_offset(lv, v1, 0, "C_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_I");
    check_field_offset(lv, v3, 2, "C_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_I, C_BFu7s_I)
//============================================================================



static void Test_C_BFu7s_Ip()
{
  {
    init_simple_test("C_BFu7s_Ip");
    static STRUCT_IF_C C_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(C_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "C_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_Ip");
    check_field_offset(lv, v3, 2, "C_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_C_BFu7s_Ip, C_BFu7s_Ip)
//============================================================================



static void Test_C_BFu7s_L()
{
  {
