// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct BFu7c_S_BFu8c { unsigned char v1:7; short v2; unsigned char v3:8; };
struct BFu7c_S_BFu8i { unsigned char v1:7; short v2; unsigned int v3:8; };
struct BFu7c_S_BFu8ll { unsigned char v1:7; short v2; unsigned long long v3:8; };
struct BFu7c_S_BFu8s { unsigned char v1:7; short v2; unsigned short v3:8; };
struct BFu7c_S_BFu9i { unsigned char v1:7; short v2; unsigned int v3:9; };
struct BFu7c_S_BFu9ll { unsigned char v1:7; short v2; unsigned long long v3:9; };
struct BFu7c_S_BFu9s { unsigned char v1:7; short v2; unsigned short v3:9; };
struct BFu7c_S_C { unsigned char v1:7; short v2; char v3; };
struct BFu7c_S_D { unsigned char v1:7; short v2; double v3; };
struct BFu7c_S_F { unsigned char v1:7; short v2; float v3; };
struct BFu7c_S_I { unsigned char v1:7; short v2; int v3; };
struct BFu7c_S_Ip { unsigned char v1:7; short v2; int * v3; };
struct BFu7c_S_L { unsigned char v1:7; short v2; long long v3; };
struct BFu7c_S_S { unsigned char v1:7; short v2; short v3; };
struct BFu7c_S_Uc { unsigned char v1:7; short v2; unsigned char v3; };
struct BFu7c_S_Ui { unsigned char v1:7; short v2; unsigned int v3; };
struct BFu7c_S_Ul { unsigned char v1:7; short v2; unsigned long long v3; };
struct BFu7c_S_Us { unsigned char v1:7; short v2; unsigned short v3; };
struct BFu7c_S_Vp { unsigned char v1:7; short v2; void * v3; };
struct BFu7c_Uc { unsigned char v1:7; unsigned char v2; };
struct BFu7c_Uc_BFu15i { unsigned char v1:7; unsigned char v2; unsigned int v3:15; };
struct BFu7c_Uc_BFu15ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:15; };
struct BFu7c_Uc_BFu15s { unsigned char v1:7; unsigned char v2; unsigned short v3:15; };
struct BFu7c_Uc_BFu16i { unsigned char v1:7; unsigned char v2; unsigned int v3:16; };
struct BFu7c_Uc_BFu16ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:16; };
struct BFu7c_Uc_BFu16s { unsigned char v1:7; unsigned char v2; unsigned short v3:16; };
struct BFu7c_Uc_BFu17i { unsigned char v1:7; unsigned char v2; unsigned int v3:17; };
struct BFu7c_Uc_BFu17ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:17; };
struct BFu7c_Uc_BFu1c { unsigned char v1:7; unsigned char v2; unsigned char v3:1; };
struct BFu7c_Uc_BFu1i { unsigned char v1:7; unsigned char v2; unsigned int v3:1; };
struct BFu7c_Uc_BFu1ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:1; };
struct BFu7c_Uc_BFu1s { unsigned char v1:7; unsigned char v2; unsigned short v3:1; };
struct BFu7c_Uc_BFu31i { unsigned char v1:7; unsigned char v2; unsigned int v3:31; };
struct BFu7c_Uc_BFu31ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:31; };
struct BFu7c_Uc_BFu32i { unsigned char v1:7; unsigned char v2; unsigned int v3:32; };
struct BFu7c_Uc_BFu32ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:32; };
struct BFu7c_Uc_BFu33 { unsigned char v1:7; unsigned char v2; unsigned long long v3:33; };
struct BFu7c_Uc_BFu7c { unsigned char v1:7; unsigned char v2; unsigned char v3:7; };
struct BFu7c_Uc_BFu7i { unsigned char v1:7; unsigned char v2; unsigned int v3:7; };
struct BFu7c_Uc_BFu7ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:7; };
struct BFu7c_Uc_BFu7s { unsigned char v1:7; unsigned char v2; unsigned short v3:7; };
struct BFu7c_Uc_BFu8c { unsigned char v1:7; unsigned char v2; unsigned char v3:8; };
struct BFu7c_Uc_BFu8i { unsigned char v1:7; unsigned char v2; unsigned int v3:8; };
struct BFu7c_Uc_BFu8ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:8; };
struct BFu7c_Uc_BFu8s { unsigned char v1:7; unsigned char v2; unsigned short v3:8; };
struct BFu7c_Uc_BFu9i { unsigned char v1:7; unsigned char v2; unsigned int v3:9; };
struct BFu7c_Uc_BFu9ll { unsigned char v1:7; unsigned char v2; unsigned long long v3:9; };
struct BFu7c_Uc_BFu9s { unsigned char v1:7; unsigned char v2; unsigned short v3:9; };
struct BFu7c_Uc_C { unsigned char v1:7; unsigned char v2; char v3; };
struct BFu7c_Uc_D { unsigned char v1:7; unsigned char v2; double v3; };
struct BFu7c_Uc_F { unsigned char v1:7; unsigned char v2; float v3; };
struct BFu7c_Uc_I { unsigned char v1:7; unsigned char v2; int v3; };
struct BFu7c_Uc_Ip { unsigned char v1:7; unsigned char v2; int * v3; };
struct BFu7c_Uc_L { unsigned char v1:7; unsigned char v2; long long v3; };
struct BFu7c_Uc_S { unsigned char v1:7; unsigned char v2; short v3; };
struct BFu7c_Uc_Uc { unsigned char v1:7; unsigned char v2; unsigned char v3; };
struct BFu7c_Uc_Ui { unsigned char v1:7; unsigned char v2; unsigned int v3; };
struct BFu7c_Uc_Ul { unsigned char v1:7; unsigned char v2; unsigned long long v3; };
struct BFu7c_Uc_Us { unsigned char v1:7; unsigned char v2; unsigned short v3; };
struct BFu7c_Uc_Vp { unsigned char v1:7; unsigned char v2; void * v3; };
struct BFu7c_Ui { unsigned char v1:7; unsigned int v2; };
struct BFu7c_Ui_BFu15i { unsigned char v1:7; unsigned int v2; unsigned int v3:15; };
struct BFu7c_Ui_BFu15ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:15; };
struct BFu7c_Ui_BFu15s { unsigned char v1:7; unsigned int v2; unsigned short v3:15; };
struct BFu7c_Ui_BFu16i { unsigned char v1:7; unsigned int v2; unsigned int v3:16; };
struct BFu7c_Ui_BFu16ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:16; };
struct BFu7c_Ui_BFu16s { unsigned char v1:7; unsigned int v2; unsigned short v3:16; };
struct BFu7c_Ui_BFu17i { unsigned char v1:7; unsigned int v2; unsigned int v3:17; };
struct BFu7c_Ui_BFu17ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:17; };
struct BFu7c_Ui_BFu1c { unsigned char v1:7; unsigned int v2; unsigned char v3:1; };
struct BFu7c_Ui_BFu1i { unsigned char v1:7; unsigned int v2; unsigned int v3:1; };
struct BFu7c_Ui_BFu1ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:1; };
struct BFu7c_Ui_BFu1s { unsigned char v1:7; unsigned int v2; unsigned short v3:1; };
struct BFu7c_Ui_BFu31i { unsigned char v1:7; unsigned int v2; unsigned int v3:31; };
struct BFu7c_Ui_BFu31ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:31; };
struct BFu7c_Ui_BFu32i { unsigned char v1:7; unsigned int v2; unsigned int v3:32; };
struct BFu7c_Ui_BFu32ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:32; };
struct BFu7c_Ui_BFu33 { unsigned char v1:7; unsigned int v2; unsigned long long v3:33; };
struct BFu7c_Ui_BFu7c { unsigned char v1:7; unsigned int v2; unsigned char v3:7; };
struct BFu7c_Ui_BFu7i { unsigned char v1:7; unsigned int v2; unsigned int v3:7; };
struct BFu7c_Ui_BFu7ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:7; };
struct BFu7c_Ui_BFu7s { unsigned char v1:7; unsigned int v2; unsigned short v3:7; };
struct BFu7c_Ui_BFu8c { unsigned char v1:7; unsigned int v2; unsigned char v3:8; };
struct BFu7c_Ui_BFu8i { unsigned char v1:7; unsigned int v2; unsigned int v3:8; };
struct BFu7c_Ui_BFu8ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:8; };
struct BFu7c_Ui_BFu8s { unsigned char v1:7; unsigned int v2; unsigned short v3:8; };
struct BFu7c_Ui_BFu9i { unsigned char v1:7; unsigned int v2; unsigned int v3:9; };
struct BFu7c_Ui_BFu9ll { unsigned char v1:7; unsigned int v2; unsigned long long v3:9; };
struct BFu7c_Ui_BFu9s { unsigned char v1:7; unsigned int v2; unsigned short v3:9; };
struct BFu7c_Ui_C { unsigned char v1:7; unsigned int v2; char v3; };
struct BFu7c_Ui_D { unsigned char v1:7; unsigned int v2; double v3; };
struct BFu7c_Ui_F { unsigned char v1:7; unsigned int v2; float v3; };
struct BFu7c_Ui_I { unsigned char v1:7; unsigned int v2; int v3; };
struct BFu7c_Ui_Ip { unsigned char v1:7; unsigned int v2; int * v3; };
struct BFu7c_Ui_L { unsigned char v1:7; unsigned int v2; long long v3; };
struct BFu7c_Ui_S { unsigned char v1:7; unsigned int v2; short v3; };
struct BFu7c_Ui_Uc { unsigned char v1:7; unsigned int v2; unsigned char v3; };
struct BFu7c_Ui_Ui { unsigned char v1:7; unsigned int v2; unsigned int v3; };
struct BFu7c_Ui_Ul { unsigned char v1:7; unsigned int v2; unsigned long long v3; };
struct BFu7c_Ui_Us { unsigned char v1:7; unsigned int v2; unsigned short v3; };
struct BFu7c_Ui_Vp { unsigned char v1:7; unsigned int v2; void * v3; };
struct BFu7c_Ul { unsigned char v1:7; unsigned long long v2; };
struct BFu7c_Ul_BFu15i { unsigned char v1:7; unsigned long long v2; unsigned int v3:15; };
struct BFu7c_Ul_BFu15ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:15; };
struct BFu7c_Ul_BFu15s { unsigned char v1:7; unsigned long long v2; unsigned short v3:15; };
struct BFu7c_Ul_BFu16i { unsigned char v1:7; unsigned long long v2; unsigned int v3:16; };
struct BFu7c_Ul_BFu16ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:16; };
struct BFu7c_Ul_BFu16s { unsigned char v1:7; unsigned long long v2; unsigned short v3:16; };
struct BFu7c_Ul_BFu17i { unsigned char v1:7; unsigned long long v2; unsigned int v3:17; };
struct BFu7c_Ul_BFu17ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:17; };
struct BFu7c_Ul_BFu1c { unsigned char v1:7; unsigned long long v2; unsigned char v3:1; };
struct BFu7c_Ul_BFu1i { unsigned char v1:7; unsigned long long v2; unsigned int v3:1; };
struct BFu7c_Ul_BFu1ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:1; };
struct BFu7c_Ul_BFu1s { unsigned char v1:7; unsigned long long v2; unsigned short v3:1; };
struct BFu7c_Ul_BFu31i { unsigned char v1:7; unsigned long long v2; unsigned int v3:31; };
struct BFu7c_Ul_BFu31ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:31; };
struct BFu7c_Ul_BFu32i { unsigned char v1:7; unsigned long long v2; unsigned int v3:32; };
struct BFu7c_Ul_BFu32ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:32; };
struct BFu7c_Ul_BFu33 { unsigned char v1:7; unsigned long long v2; unsigned long long v3:33; };
struct BFu7c_Ul_BFu7c { unsigned char v1:7; unsigned long long v2; unsigned char v3:7; };
struct BFu7c_Ul_BFu7i { unsigned char v1:7; unsigned long long v2; unsigned int v3:7; };
struct BFu7c_Ul_BFu7ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:7; };
struct BFu7c_Ul_BFu7s { unsigned char v1:7; unsigned long long v2; unsigned short v3:7; };
struct BFu7c_Ul_BFu8c { unsigned char v1:7; unsigned long long v2; unsigned char v3:8; };
struct BFu7c_Ul_BFu8i { unsigned char v1:7; unsigned long long v2; unsigned int v3:8; };
struct BFu7c_Ul_BFu8ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:8; };
struct BFu7c_Ul_BFu8s { unsigned char v1:7; unsigned long long v2; unsigned short v3:8; };
struct BFu7c_Ul_BFu9i { unsigned char v1:7; unsigned long long v2; unsigned int v3:9; };
struct BFu7c_Ul_BFu9ll { unsigned char v1:7; unsigned long long v2; unsigned long long v3:9; };
struct BFu7c_Ul_BFu9s { unsigned char v1:7; unsigned long long v2; unsigned short v3:9; };
struct BFu7c_Ul_C { unsigned char v1:7; unsigned long long v2; char v3; };
struct BFu7c_Ul_D { unsigned char v1:7; unsigned long long v2; double v3; };
struct BFu7c_Ul_F { unsigned char v1:7; unsigned long long v2; float v3; };
struct BFu7c_Ul_I { unsigned char v1:7; unsigned long long v2; int v3; };
struct BFu7c_Ul_Ip { unsigned char v1:7; unsigned long long v2; int * v3; };
struct BFu7c_Ul_L { unsigned char v1:7; unsigned long long v2; long long v3; };
struct BFu7c_Ul_S { unsigned char v1:7; unsigned long long v2; short v3; };
struct BFu7c_Ul_Uc { unsigned char v1:7; unsigned long long v2; unsigned char v3; };
struct BFu7c_Ul_Ui { unsigned char v1:7; unsigned long long v2; unsigned int v3; };
struct BFu7c_Ul_Ul { unsigned char v1:7; unsigned long long v2; unsigned long long v3; };
struct BFu7c_Ul_Us { unsigned char v1:7; unsigned long long v2; unsigned short v3; };
struct BFu7c_Ul_Vp { unsigned char v1:7; unsigned long long v2; void * v3; };
struct BFu7c_Us { unsigned char v1:7; unsigned short v2; };
struct BFu7c_Us_BFu15i { unsigned char v1:7; unsigned short v2; unsigned int v3:15; };
struct BFu7c_Us_BFu15ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:15; };
struct BFu7c_Us_BFu15s { unsigned char v1:7; unsigned short v2; unsigned short v3:15; };
struct BFu7c_Us_BFu16i { unsigned char v1:7; unsigned short v2; unsigned int v3:16; };
struct BFu7c_Us_BFu16ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:16; };
struct BFu7c_Us_BFu16s { unsigned char v1:7; unsigned short v2; unsigned short v3:16; };
struct BFu7c_Us_BFu17i { unsigned char v1:7; unsigned short v2; unsigned int v3:17; };
struct BFu7c_Us_BFu17ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:17; };
struct BFu7c_Us_BFu1c { unsigned char v1:7; unsigned short v2; unsigned char v3:1; };
struct BFu7c_Us_BFu1i { unsigned char v1:7; unsigned short v2; unsigned int v3:1; };
struct BFu7c_Us_BFu1ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:1; };
struct BFu7c_Us_BFu1s { unsigned char v1:7; unsigned short v2; unsigned short v3:1; };
struct BFu7c_Us_BFu31i { unsigned char v1:7; unsigned short v2; unsigned int v3:31; };
struct BFu7c_Us_BFu31ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:31; };
struct BFu7c_Us_BFu32i { unsigned char v1:7; unsigned short v2; unsigned int v3:32; };
struct BFu7c_Us_BFu32ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:32; };
struct BFu7c_Us_BFu33 { unsigned char v1:7; unsigned short v2; unsigned long long v3:33; };
struct BFu7c_Us_BFu7c { unsigned char v1:7; unsigned short v2; unsigned char v3:7; };
struct BFu7c_Us_BFu7i { unsigned char v1:7; unsigned short v2; unsigned int v3:7; };
struct BFu7c_Us_BFu7ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:7; };
struct BFu7c_Us_BFu7s { unsigned char v1:7; unsigned short v2; unsigned short v3:7; };
struct BFu7c_Us_BFu8c { unsigned char v1:7; unsigned short v2; unsigned char v3:8; };
struct BFu7c_Us_BFu8i { unsigned char v1:7; unsigned short v2; unsigned int v3:8; };
struct BFu7c_Us_BFu8ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:8; };
struct BFu7c_Us_BFu8s { unsigned char v1:7; unsigned short v2; unsigned short v3:8; };
struct BFu7c_Us_BFu9i { unsigned char v1:7; unsigned short v2; unsigned int v3:9; };
struct BFu7c_Us_BFu9ll { unsigned char v1:7; unsigned short v2; unsigned long long v3:9; };
struct BFu7c_Us_BFu9s { unsigned char v1:7; unsigned short v2; unsigned short v3:9; };
struct BFu7c_Us_C { unsigned char v1:7; unsigned short v2; char v3; };
struct BFu7c_Us_D { unsigned char v1:7; unsigned short v2; double v3; };
struct BFu7c_Us_F { unsigned char v1:7; unsigned short v2; float v3; };
struct BFu7c_Us_I { unsigned char v1:7; unsigned short v2; int v3; };
struct BFu7c_Us_Ip { unsigned char v1:7; unsigned short v2; int * v3; };
struct BFu7c_Us_L { unsigned char v1:7; unsigned short v2; long long v3; };
struct BFu7c_Us_S { unsigned char v1:7; unsigned short v2; short v3; };
struct BFu7c_Us_Uc { unsigned char v1:7; unsigned short v2; unsigned char v3; };
struct BFu7c_Us_Ui { unsigned char v1:7; unsigned short v2; unsigned int v3; };
struct BFu7c_Us_Ul { unsigned char v1:7; unsigned short v2; unsigned long long v3; };
struct BFu7c_Us_Us { unsigned char v1:7; unsigned short v2; unsigned short v3; };
struct BFu7c_Us_Vp { unsigned char v1:7; unsigned short v2; void * v3; };
struct BFu7c_Vp { unsigned char v1:7; void * v2; };
struct BFu7c_Vp_BFu15i { unsigned char v1:7; void * v2; unsigned int v3:15; };
struct BFu7c_Vp_BFu15ll { unsigned char v1:7; void * v2; unsigned long long v3:15; };
struct BFu7c_Vp_BFu15s { unsigned char v1:7; void * v2; unsigned short v3:15; };
struct BFu7c_Vp_BFu16i { unsigned char v1:7; void * v2; unsigned int v3:16; };
struct BFu7c_Vp_BFu16ll { unsigned char v1:7; void * v2; unsigned long long v3:16; };
struct BFu7c_Vp_BFu16s { unsigned char v1:7; void * v2; unsigned short v3:16; };
struct BFu7c_Vp_BFu17i { unsigned char v1:7; void * v2; unsigned int v3:17; };
struct BFu7c_Vp_BFu17ll { unsigned char v1:7; void * v2; unsigned long long v3:17; };
struct BFu7c_Vp_BFu1c { unsigned char v1:7; void * v2; unsigned char v3:1; };
struct BFu7c_Vp_BFu1i { unsigned char v1:7; void * v2; unsigned int v3:1; };
struct BFu7c_Vp_BFu1ll { unsigned char v1:7; void * v2; unsigned long long v3:1; };
struct BFu7c_Vp_BFu1s { unsigned char v1:7; void * v2; unsigned short v3:1; };
struct BFu7c_Vp_BFu31i { unsigned char v1:7; void * v2; unsigned int v3:31; };
struct BFu7c_Vp_BFu31ll { unsigned char v1:7; void * v2; unsigned long long v3:31; };
struct BFu7c_Vp_BFu32i { unsigned char v1:7; void * v2; unsigned int v3:32; };
struct BFu7c_Vp_BFu32ll { unsigned char v1:7; void * v2; unsigned long long v3:32; };
struct BFu7c_Vp_BFu33 { unsigned char v1:7; void * v2; unsigned long long v3:33; };
struct BFu7c_Vp_BFu7c { unsigned char v1:7; void * v2; unsigned char v3:7; };
struct BFu7c_Vp_BFu7i { unsigned char v1:7; void * v2; unsigned int v3:7; };
struct BFu7c_Vp_BFu7ll { unsigned char v1:7; void * v2; unsigned long long v3:7; };
struct BFu7c_Vp_BFu7s { unsigned char v1:7; void * v2; unsigned short v3:7; };
struct BFu7c_Vp_BFu8c { unsigned char v1:7; void * v2; unsigned char v3:8; };
struct BFu7c_Vp_BFu8i { unsigned char v1:7; void * v2; unsigned int v3:8; };
struct BFu7c_Vp_BFu8ll { unsigned char v1:7; void * v2; unsigned long long v3:8; };
struct BFu7c_Vp_BFu8s { unsigned char v1:7; void * v2; unsigned short v3:8; };
struct BFu7c_Vp_BFu9i { unsigned char v1:7; void * v2; unsigned int v3:9; };
struct BFu7c_Vp_BFu9ll { unsigned char v1:7; void * v2; unsigned long long v3:9; };
struct BFu7c_Vp_BFu9s { unsigned char v1:7; void * v2; unsigned short v3:9; };
struct BFu7c_Vp_C { unsigned char v1:7; void * v2; char v3; };
struct BFu7c_Vp_D { unsigned char v1:7; void * v2; double v3; };
struct BFu7c_Vp_F { unsigned char v1:7; void * v2; float v3; };
struct BFu7c_Vp_I { unsigned char v1:7; void * v2; int v3; };
struct BFu7c_Vp_Ip { unsigned char v1:7; void * v2; int * v3; };
struct BFu7c_Vp_L { unsigned char v1:7; void * v2; long long v3; };
struct BFu7c_Vp_S { unsigned char v1:7; void * v2; short v3; };
struct BFu7c_Vp_Uc { unsigned char v1:7; void * v2; unsigned char v3; };
struct BFu7c_Vp_Ui { unsigned char v1:7; void * v2; unsigned int v3; };
struct BFu7c_Vp_Ul { unsigned char v1:7; void * v2; unsigned long long v3; };
struct BFu7c_Vp_Us { unsigned char v1:7; void * v2; unsigned short v3; };
struct BFu7c_Vp_Vp { unsigned char v1:7; void * v2; void * v3; };
struct BFu7i { unsigned int v1:7; };
struct BFu7i_BFs7c { unsigned int v1:7; signed char v2:7; };
struct BFu7i_BFs7c_BFs7c { unsigned int v1:7; signed char v2:7; signed char v3:7; };
struct BFu7i_BFs7c_BFs7c_BFs7c { unsigned int v1:7; signed char v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFs7c_BFs7i { unsigned int v1:7; signed char v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFs7c_BFs7ll { unsigned int v1:7; signed char v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFs7c_BFs7s { unsigned int v1:7; signed char v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFs7c_BFu7c { unsigned int v1:7; signed char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFs7c_BFu7i { unsigned int v1:7; signed char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFs7c_BFu7ll { unsigned int v1:7; signed char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFs7c_BFu7s { unsigned int v1:7; signed char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFs7i { unsigned int v1:7; signed char v2:7; signed int v3:7; };
struct BFu7i_BFs7c_BFs7i_BFs7c { unsigned int v1:7; signed char v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFs7i_BFs7i { unsigned int v1:7; signed char v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFs7i_BFs7ll { unsigned int v1:7; signed char v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFs7i_BFs7s { unsigned int v1:7; signed char v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFs7i_BFu7c { unsigned int v1:7; signed char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFs7i_BFu7i { unsigned int v1:7; signed char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFs7i_BFu7ll { unsigned int v1:7; signed char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFs7i_BFu7s { unsigned int v1:7; signed char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFs7ll { unsigned int v1:7; signed char v2:7; signed long long v3:7; };
struct BFu7i_BFs7c_BFs7ll_BFs7c { unsigned int v1:7; signed char v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFs7i { unsigned int v1:7; signed char v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFs7ll { unsigned int v1:7; signed char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFs7s { unsigned int v1:7; signed char v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFu7c { unsigned int v1:7; signed char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFu7i { unsigned int v1:7; signed char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFu7ll { unsigned int v1:7; signed char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFs7ll_BFu7s { unsigned int v1:7; signed char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFs7s { unsigned int v1:7; signed char v2:7; signed short v3:7; };
struct BFu7i_BFs7c_BFs7s_BFs7c { unsigned int v1:7; signed char v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFs7s_BFs7i { unsigned int v1:7; signed char v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFs7s_BFs7ll { unsigned int v1:7; signed char v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFs7s_BFs7s { unsigned int v1:7; signed char v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFs7s_BFu7c { unsigned int v1:7; signed char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFs7s_BFu7i { unsigned int v1:7; signed char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFs7s_BFu7ll { unsigned int v1:7; signed char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFs7s_BFu7s { unsigned int v1:7; signed char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFu7c { unsigned int v1:7; signed char v2:7; unsigned char v3:7; };
struct BFu7i_BFs7c_BFu7c_BFs7c { unsigned int v1:7; signed char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFu7c_BFs7i { unsigned int v1:7; signed char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFu7c_BFs7ll { unsigned int v1:7; signed char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFu7c_BFs7s { unsigned int v1:7; signed char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFu7c_BFu7c { unsigned int v1:7; signed char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFu7c_BFu7i { unsigned int v1:7; signed char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFu7c_BFu7ll { unsigned int v1:7; signed char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFu7c_BFu7s { unsigned int v1:7; signed char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFu7i { unsigned int v1:7; signed char v2:7; unsigned int v3:7; };
struct BFu7i_BFs7c_BFu7i_BFs7c { unsigned int v1:7; signed char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFu7i_BFs7i { unsigned int v1:7; signed char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFu7i_BFs7ll { unsigned int v1:7; signed char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFu7i_BFs7s { unsigned int v1:7; signed char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFu7i_BFu7c { unsigned int v1:7; signed char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFu7i_BFu7i { unsigned int v1:7; signed char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFu7i_BFu7ll { unsigned int v1:7; signed char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFu7i_BFu7s { unsigned int v1:7; signed char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFu7ll { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; };
struct BFu7i_BFs7c_BFu7ll_BFs7c { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFs7i { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFs7ll { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFs7s { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFu7c { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFu7i { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFu7ll { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFu7ll_BFu7s { unsigned int v1:7; signed char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7c_BFu7s { unsigned int v1:7; signed char v2:7; unsigned short v3:7; };
struct BFu7i_BFs7c_BFu7s_BFs7c { unsigned int v1:7; signed char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFs7c_BFu7s_BFs7i { unsigned int v1:7; signed char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFs7c_BFu7s_BFs7ll { unsigned int v1:7; signed char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFs7c_BFu7s_BFs7s { unsigned int v1:7; signed char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFs7c_BFu7s_BFu7c { unsigned int v1:7; signed char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7c_BFu7s_BFu7i { unsigned int v1:7; signed char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7c_BFu7s_BFu7ll { unsigned int v1:7; signed char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7c_BFu7s_BFu7s { unsigned int v1:7; signed char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i { unsigned int v1:7; signed int v2:7; };
struct BFu7i_BFs7i_BFs7c { unsigned int v1:7; signed int v2:7; signed char v3:7; };
struct BFu7i_BFs7i_BFs7c_BFs7c { unsigned int v1:7; signed int v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFs7c_BFs7i { unsigned int v1:7; signed int v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFs7c_BFs7ll { unsigned int v1:7; signed int v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFs7c_BFs7s { unsigned int v1:7; signed int v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFs7c_BFu7c { unsigned int v1:7; signed int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFs7c_BFu7i { unsigned int v1:7; signed int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFs7c_BFu7ll { unsigned int v1:7; signed int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFs7c_BFu7s { unsigned int v1:7; signed int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFs7i { unsigned int v1:7; signed int v2:7; signed int v3:7; };
struct BFu7i_BFs7i_BFs7i_BFs7c { unsigned int v1:7; signed int v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFs7i_BFs7i { unsigned int v1:7; signed int v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFs7i_BFs7ll { unsigned int v1:7; signed int v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFs7i_BFs7s { unsigned int v1:7; signed int v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFs7i_BFu7c { unsigned int v1:7; signed int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFs7i_BFu7i { unsigned int v1:7; signed int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFs7i_BFu7ll { unsigned int v1:7; signed int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFs7i_BFu7s { unsigned int v1:7; signed int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFs7ll { unsigned int v1:7; signed int v2:7; signed long long v3:7; };
struct BFu7i_BFs7i_BFs7ll_BFs7c { unsigned int v1:7; signed int v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFs7i { unsigned int v1:7; signed int v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFs7ll { unsigned int v1:7; signed int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFs7s { unsigned int v1:7; signed int v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFu7c { unsigned int v1:7; signed int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFu7i { unsigned int v1:7; signed int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFu7ll { unsigned int v1:7; signed int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFs7ll_BFu7s { unsigned int v1:7; signed int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFs7s { unsigned int v1:7; signed int v2:7; signed short v3:7; };
struct BFu7i_BFs7i_BFs7s_BFs7c { unsigned int v1:7; signed int v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFs7s_BFs7i { unsigned int v1:7; signed int v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFs7s_BFs7ll { unsigned int v1:7; signed int v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFs7s_BFs7s { unsigned int v1:7; signed int v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFs7s_BFu7c { unsigned int v1:7; signed int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFs7s_BFu7i { unsigned int v1:7; signed int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFs7s_BFu7ll { unsigned int v1:7; signed int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFs7s_BFu7s { unsigned int v1:7; signed int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFu7c { unsigned int v1:7; signed int v2:7; unsigned char v3:7; };
struct BFu7i_BFs7i_BFu7c_BFs7c { unsigned int v1:7; signed int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFu7c_BFs7i { unsigned int v1:7; signed int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFu7c_BFs7ll { unsigned int v1:7; signed int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFu7c_BFs7s { unsigned int v1:7; signed int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFu7c_BFu7c { unsigned int v1:7; signed int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFu7c_BFu7i { unsigned int v1:7; signed int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFu7c_BFu7ll { unsigned int v1:7; signed int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFu7c_BFu7s { unsigned int v1:7; signed int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFu7i { unsigned int v1:7; signed int v2:7; unsigned int v3:7; };
struct BFu7i_BFs7i_BFu7i_BFs7c { unsigned int v1:7; signed int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFu7i_BFs7i { unsigned int v1:7; signed int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFu7i_BFs7ll { unsigned int v1:7; signed int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFu7i_BFs7s { unsigned int v1:7; signed int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFu7i_BFu7c { unsigned int v1:7; signed int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFu7i_BFu7i { unsigned int v1:7; signed int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFu7i_BFu7ll { unsigned int v1:7; signed int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFu7i_BFu7s { unsigned int v1:7; signed int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFu7ll { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; };
struct BFu7i_BFs7i_BFu7ll_BFs7c { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFs7i { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFs7ll { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFs7s { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFu7c { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFu7i { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFu7ll { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFu7ll_BFu7s { unsigned int v1:7; signed int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7i_BFu7s { unsigned int v1:7; signed int v2:7; unsigned short v3:7; };
struct BFu7i_BFs7i_BFu7s_BFs7c { unsigned int v1:7; signed int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFs7i_BFu7s_BFs7i { unsigned int v1:7; signed int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFs7i_BFu7s_BFs7ll { unsigned int v1:7; signed int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFs7i_BFu7s_BFs7s { unsigned int v1:7; signed int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFs7i_BFu7s_BFu7c { unsigned int v1:7; signed int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7i_BFu7s_BFu7i { unsigned int v1:7; signed int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7i_BFu7s_BFu7ll { unsigned int v1:7; signed int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7i_BFu7s_BFu7s { unsigned int v1:7; signed int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll { unsigned int v1:7; signed long long v2:7; };
struct BFu7i_BFs7ll_BFs7c { unsigned int v1:7; signed long long v2:7; signed char v3:7; };
struct BFu7i_BFs7ll_BFs7c_BFs7c { unsigned int v1:7; signed long long v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFs7i { unsigned int v1:7; signed long long v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFs7ll { unsigned int v1:7; signed long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFs7s { unsigned int v1:7; signed long long v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFu7c { unsigned int v1:7; signed long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFu7i { unsigned int v1:7; signed long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFu7ll { unsigned int v1:7; signed long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFs7c_BFu7s { unsigned int v1:7; signed long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFs7i { unsigned int v1:7; signed long long v2:7; signed int v3:7; };
struct BFu7i_BFs7ll_BFs7i_BFs7c { unsigned int v1:7; signed long long v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFs7i { unsigned int v1:7; signed long long v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFs7ll { unsigned int v1:7; signed long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFs7s { unsigned int v1:7; signed long long v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFu7c { unsigned int v1:7; signed long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFu7i { unsigned int v1:7; signed long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFu7ll { unsigned int v1:7; signed long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFs7i_BFu7s { unsigned int v1:7; signed long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFs7ll { unsigned int v1:7; signed long long v2:7; signed long long v3:7; };
struct BFu7i_BFs7ll_BFs7ll_BFs7c { unsigned int v1:7; signed long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFs7i { unsigned int v1:7; signed long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFs7ll { unsigned int v1:7; signed long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFs7s { unsigned int v1:7; signed long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFu7c { unsigned int v1:7; signed long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFu7i { unsigned int v1:7; signed long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFu7ll { unsigned int v1:7; signed long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFs7ll_BFu7s { unsigned int v1:7; signed long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFs7s { unsigned int v1:7; signed long long v2:7; signed short v3:7; };
struct BFu7i_BFs7ll_BFs7s_BFs7c { unsigned int v1:7; signed long long v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFs7i { unsigned int v1:7; signed long long v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFs7ll { unsigned int v1:7; signed long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFs7s { unsigned int v1:7; signed long long v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFu7c { unsigned int v1:7; signed long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFu7i { unsigned int v1:7; signed long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFu7ll { unsigned int v1:7; signed long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFs7s_BFu7s { unsigned int v1:7; signed long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFu7c { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; };
struct BFu7i_BFs7ll_BFu7c_BFs7c { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFs7i { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFs7ll { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFs7s { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFu7c { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFu7i { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFu7ll { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFu7c_BFu7s { unsigned int v1:7; signed long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFu7i { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; };
struct BFu7i_BFs7ll_BFu7i_BFs7c { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFs7i { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFs7ll { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFs7s { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFu7c { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFu7i { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFu7ll { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFu7i_BFu7s { unsigned int v1:7; signed long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFu7ll { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; };
struct BFu7i_BFs7ll_BFu7ll_BFs7c { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFs7i { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFs7ll { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFs7s { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFu7c { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFu7i { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFu7ll { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFu7ll_BFu7s { unsigned int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7ll_BFu7s { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; };
struct BFu7i_BFs7ll_BFu7s_BFs7c { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFs7i { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFs7ll { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFs7s { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFu7c { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFu7i { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFu7ll { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7ll_BFu7s_BFu7s { unsigned int v1:7; signed long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s { unsigned int v1:7; signed short v2:7; };
struct BFu7i_BFs7s_BFs7c { unsigned int v1:7; signed short v2:7; signed char v3:7; };
struct BFu7i_BFs7s_BFs7c_BFs7c { unsigned int v1:7; signed short v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFs7c_BFs7i { unsigned int v1:7; signed short v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFs7c_BFs7ll { unsigned int v1:7; signed short v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFs7c_BFs7s { unsigned int v1:7; signed short v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFs7c_BFu7c { unsigned int v1:7; signed short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFs7c_BFu7i { unsigned int v1:7; signed short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFs7c_BFu7ll { unsigned int v1:7; signed short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFs7c_BFu7s { unsigned int v1:7; signed short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFs7i { unsigned int v1:7; signed short v2:7; signed int v3:7; };
struct BFu7i_BFs7s_BFs7i_BFs7c { unsigned int v1:7; signed short v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFs7i_BFs7i { unsigned int v1:7; signed short v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFs7i_BFs7ll { unsigned int v1:7; signed short v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFs7i_BFs7s { unsigned int v1:7; signed short v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFs7i_BFu7c { unsigned int v1:7; signed short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFs7i_BFu7i { unsigned int v1:7; signed short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFs7i_BFu7ll { unsigned int v1:7; signed short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFs7i_BFu7s { unsigned int v1:7; signed short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFs7ll { unsigned int v1:7; signed short v2:7; signed long long v3:7; };
struct BFu7i_BFs7s_BFs7ll_BFs7c { unsigned int v1:7; signed short v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFs7i { unsigned int v1:7; signed short v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFs7ll { unsigned int v1:7; signed short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFs7s { unsigned int v1:7; signed short v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFu7c { unsigned int v1:7; signed short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFu7i { unsigned int v1:7; signed short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFu7ll { unsigned int v1:7; signed short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFs7ll_BFu7s { unsigned int v1:7; signed short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFs7s { unsigned int v1:7; signed short v2:7; signed short v3:7; };
struct BFu7i_BFs7s_BFs7s_BFs7c { unsigned int v1:7; signed short v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFs7s_BFs7i { unsigned int v1:7; signed short v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFs7s_BFs7ll { unsigned int v1:7; signed short v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFs7s_BFs7s { unsigned int v1:7; signed short v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFs7s_BFu7c { unsigned int v1:7; signed short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFs7s_BFu7i { unsigned int v1:7; signed short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFs7s_BFu7ll { unsigned int v1:7; signed short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFs7s_BFu7s { unsigned int v1:7; signed short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFu7c { unsigned int v1:7; signed short v2:7; unsigned char v3:7; };
struct BFu7i_BFs7s_BFu7c_BFs7c { unsigned int v1:7; signed short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFu7c_BFs7i { unsigned int v1:7; signed short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFu7c_BFs7ll { unsigned int v1:7; signed short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFu7c_BFs7s { unsigned int v1:7; signed short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFu7c_BFu7c { unsigned int v1:7; signed short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFu7c_BFu7i { unsigned int v1:7; signed short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFu7c_BFu7ll { unsigned int v1:7; signed short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFu7c_BFu7s { unsigned int v1:7; signed short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFu7i { unsigned int v1:7; signed short v2:7; unsigned int v3:7; };
struct BFu7i_BFs7s_BFu7i_BFs7c { unsigned int v1:7; signed short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFu7i_BFs7i { unsigned int v1:7; signed short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFu7i_BFs7ll { unsigned int v1:7; signed short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFu7i_BFs7s { unsigned int v1:7; signed short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFu7i_BFu7c { unsigned int v1:7; signed short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFu7i_BFu7i { unsigned int v1:7; signed short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFu7i_BFu7ll { unsigned int v1:7; signed short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFu7i_BFu7s { unsigned int v1:7; signed short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFu7ll { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; };
struct BFu7i_BFs7s_BFu7ll_BFs7c { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFs7i { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFs7ll { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFs7s { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFu7c { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFu7i { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFu7ll { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFu7ll_BFu7s { unsigned int v1:7; signed short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFs7s_BFu7s { unsigned int v1:7; signed short v2:7; unsigned short v3:7; };
struct BFu7i_BFs7s_BFu7s_BFs7c { unsigned int v1:7; signed short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFs7s_BFu7s_BFs7i { unsigned int v1:7; signed short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFs7s_BFu7s_BFs7ll { unsigned int v1:7; signed short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFs7s_BFu7s_BFs7s { unsigned int v1:7; signed short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFs7s_BFu7s_BFu7c { unsigned int v1:7; signed short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFs7s_BFu7s_BFu7i { unsigned int v1:7; signed short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFs7s_BFu7s_BFu7ll { unsigned int v1:7; signed short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFs7s_BFu7s_BFu7s { unsigned int v1:7; signed short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFu15i { unsigned int v1:7; unsigned int v2:15; };
struct BFu7i_BFu15i_BFu15i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:15; };
struct BFu7i_BFu15i_BFu15ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:15; };
struct BFu7i_BFu15i_BFu15s { unsigned int v1:7; unsigned int v2:15; unsigned short v3:15; };
struct BFu7i_BFu15i_BFu16i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:16; };
struct BFu7i_BFu15i_BFu16ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:16; };
struct BFu7i_BFu15i_BFu16s { unsigned int v1:7; unsigned int v2:15; unsigned short v3:16; };
struct BFu7i_BFu15i_BFu17i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:17; };
struct BFu7i_BFu15i_BFu17ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:17; };
struct BFu7i_BFu15i_BFu1c { unsigned int v1:7; unsigned int v2:15; unsigned char v3:1; };
struct BFu7i_BFu15i_BFu1i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:1; };
struct BFu7i_BFu15i_BFu1ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:1; };
struct BFu7i_BFu15i_BFu1s { unsigned int v1:7; unsigned int v2:15; unsigned short v3:1; };
struct BFu7i_BFu15i_BFu31i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:31; };
struct BFu7i_BFu15i_BFu31ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:31; };
struct BFu7i_BFu15i_BFu32i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:32; };
struct BFu7i_BFu15i_BFu32ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:32; };
struct BFu7i_BFu15i_BFu33 { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:33; };
struct BFu7i_BFu15i_BFu7c { unsigned int v1:7; unsigned int v2:15; unsigned char v3:7; };
struct BFu7i_BFu15i_BFu7i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:7; };
struct BFu7i_BFu15i_BFu7ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:7; };
struct BFu7i_BFu15i_BFu7s { unsigned int v1:7; unsigned int v2:15; unsigned short v3:7; };
struct BFu7i_BFu15i_BFu8c { unsigned int v1:7; unsigned int v2:15; unsigned char v3:8; };
struct BFu7i_BFu15i_BFu8i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:8; };
struct BFu7i_BFu15i_BFu8ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:8; };
struct BFu7i_BFu15i_BFu8s { unsigned int v1:7; unsigned int v2:15; unsigned short v3:8; };
struct BFu7i_BFu15i_BFu9i { unsigned int v1:7; unsigned int v2:15; unsigned int v3:9; };
struct BFu7i_BFu15i_BFu9ll { unsigned int v1:7; unsigned int v2:15; unsigned long long v3:9; };
struct BFu7i_BFu15i_BFu9s { unsigned int v1:7; unsigned int v2:15; unsigned short v3:9; };
struct BFu7i_BFu15i_C { unsigned int v1:7; unsigned int v2:15; char v3; };
struct BFu7i_BFu15i_D { unsigned int v1:7; unsigned int v2:15; double v3; };
struct BFu7i_BFu15i_F { unsigned int v1:7; unsigned int v2:15; float v3; };
struct BFu7i_BFu15i_I { unsigned int v1:7; unsigned int v2:15; int v3; };
struct BFu7i_BFu15i_Ip { unsigned int v1:7; unsigned int v2:15; int * v3; };
struct BFu7i_BFu15i_L { unsigned int v1:7; unsigned int v2:15; long long v3; };
struct BFu7i_BFu15i_S { unsigned int v1:7; unsigned int v2:15; short v3; };
struct BFu7i_BFu15i_Uc { unsigned int v1:7; unsigned int v2:15; unsigned char v3; };
struct BFu7i_BFu15i_Ui { unsigned int v1:7; unsigned int v2:15; unsigned int v3; };
struct BFu7i_BFu15i_Ul { unsigned int v1:7; unsigned int v2:15; unsigned long long v3; };
struct BFu7i_BFu15i_Us { unsigned int v1:7; unsigned int v2:15; unsigned short v3; };
struct BFu7i_BFu15i_Vp { unsigned int v1:7; unsigned int v2:15; void * v3; };
struct BFu7i_BFu15ll { unsigned int v1:7; unsigned long long v2:15; };
struct BFu7i_BFu15ll_BFu15i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:15; };
struct BFu7i_BFu15ll_BFu15ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:15; };
struct BFu7i_BFu15ll_BFu15s { unsigned int v1:7; unsigned long long v2:15; unsigned short v3:15; };
struct BFu7i_BFu15ll_BFu16i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:16; };
struct BFu7i_BFu15ll_BFu16ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:16; };
struct BFu7i_BFu15ll_BFu16s { unsigned int v1:7; unsigned long long v2:15; unsigned short v3:16; };
struct BFu7i_BFu15ll_BFu17i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:17; };
struct BFu7i_BFu15ll_BFu17ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:17; };
struct BFu7i_BFu15ll_BFu1c { unsigned int v1:7; unsigned long long v2:15; unsigned char v3:1; };
struct BFu7i_BFu15ll_BFu1i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:1; };
struct BFu7i_BFu15ll_BFu1ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:1; };
struct BFu7i_BFu15ll_BFu1s { unsigned int v1:7; unsigned long long v2:15; unsigned short v3:1; };
struct BFu7i_BFu15ll_BFu31i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:31; };
struct BFu7i_BFu15ll_BFu31ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:31; };
struct BFu7i_BFu15ll_BFu32i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:32; };
struct BFu7i_BFu15ll_BFu32ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:32; };
struct BFu7i_BFu15ll_BFu33 { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:33; };
struct BFu7i_BFu15ll_BFu7c { unsigned int v1:7; unsigned long long v2:15; unsigned char v3:7; };
struct BFu7i_BFu15ll_BFu7i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:7; };
struct BFu7i_BFu15ll_BFu7ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:7; };
struct BFu7i_BFu15ll_BFu7s { unsigned int v1:7; unsigned long long v2:15; unsigned short v3:7; };
struct BFu7i_BFu15ll_BFu8c { unsigned int v1:7; unsigned long long v2:15; unsigned char v3:8; };
struct BFu7i_BFu15ll_BFu8i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:8; };
struct BFu7i_BFu15ll_BFu8ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:8; };
struct BFu7i_BFu15ll_BFu8s { unsigned int v1:7; unsigned long long v2:15; unsigned short v3:8; };
struct BFu7i_BFu15ll_BFu9i { unsigned int v1:7; unsigned long long v2:15; unsigned int v3:9; };
struct BFu7i_BFu15ll_BFu9ll { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3:9; };
struct BFu7i_BFu15ll_BFu9s { unsigned int v1:7; unsigned long long v2:15; unsigned short v3:9; };
struct BFu7i_BFu15ll_C { unsigned int v1:7; unsigned long long v2:15; char v3; };
struct BFu7i_BFu15ll_D { unsigned int v1:7; unsigned long long v2:15; double v3; };
struct BFu7i_BFu15ll_F { unsigned int v1:7; unsigned long long v2:15; float v3; };
struct BFu7i_BFu15ll_I { unsigned int v1:7; unsigned long long v2:15; int v3; };
struct BFu7i_BFu15ll_Ip { unsigned int v1:7; unsigned long long v2:15; int * v3; };
struct BFu7i_BFu15ll_L { unsigned int v1:7; unsigned long long v2:15; long long v3; };
struct BFu7i_BFu15ll_S { unsigned int v1:7; unsigned long long v2:15; short v3; };
struct BFu7i_BFu15ll_Uc { unsigned int v1:7; unsigned long long v2:15; unsigned char v3; };
struct BFu7i_BFu15ll_Ui { unsigned int v1:7; unsigned long long v2:15; unsigned int v3; };
struct BFu7i_BFu15ll_Ul { unsigned int v1:7; unsigned long long v2:15; unsigned long long v3; };
struct BFu7i_BFu15ll_Us { unsigned int v1:7; unsigned long long v2:15; unsigned short v3; };
struct BFu7i_BFu15ll_Vp { unsigned int v1:7; unsigned long long v2:15; void * v3; };
struct BFu7i_BFu15s { unsigned int v1:7; unsigned short v2:15; };
struct BFu7i_BFu15s_BFu15i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:15; };
struct BFu7i_BFu15s_BFu15ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:15; };
struct BFu7i_BFu15s_BFu15s { unsigned int v1:7; unsigned short v2:15; unsigned short v3:15; };
struct BFu7i_BFu15s_BFu16i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:16; };
struct BFu7i_BFu15s_BFu16ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:16; };
struct BFu7i_BFu15s_BFu16s { unsigned int v1:7; unsigned short v2:15; unsigned short v3:16; };
struct BFu7i_BFu15s_BFu17i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:17; };
struct BFu7i_BFu15s_BFu17ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:17; };
struct BFu7i_BFu15s_BFu1c { unsigned int v1:7; unsigned short v2:15; unsigned char v3:1; };
struct BFu7i_BFu15s_BFu1i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:1; };
struct BFu7i_BFu15s_BFu1ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:1; };
struct BFu7i_BFu15s_BFu1s { unsigned int v1:7; unsigned short v2:15; unsigned short v3:1; };
struct BFu7i_BFu15s_BFu31i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:31; };
struct BFu7i_BFu15s_BFu31ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:31; };
struct BFu7i_BFu15s_BFu32i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:32; };
struct BFu7i_BFu15s_BFu32ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:32; };
struct BFu7i_BFu15s_BFu33 { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:33; };
struct BFu7i_BFu15s_BFu7c { unsigned int v1:7; unsigned short v2:15; unsigned char v3:7; };
struct BFu7i_BFu15s_BFu7i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:7; };
struct BFu7i_BFu15s_BFu7ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:7; };
struct BFu7i_BFu15s_BFu7s { unsigned int v1:7; unsigned short v2:15; unsigned short v3:7; };
struct BFu7i_BFu15s_BFu8c { unsigned int v1:7; unsigned short v2:15; unsigned char v3:8; };
struct BFu7i_BFu15s_BFu8i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:8; };
struct BFu7i_BFu15s_BFu8ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:8; };
struct BFu7i_BFu15s_BFu8s { unsigned int v1:7; unsigned short v2:15; unsigned short v3:8; };
struct BFu7i_BFu15s_BFu9i { unsigned int v1:7; unsigned short v2:15; unsigned int v3:9; };
struct BFu7i_BFu15s_BFu9ll { unsigned int v1:7; unsigned short v2:15; unsigned long long v3:9; };
struct BFu7i_BFu15s_BFu9s { unsigned int v1:7; unsigned short v2:15; unsigned short v3:9; };
struct BFu7i_BFu15s_C { unsigned int v1:7; unsigned short v2:15; char v3; };
struct BFu7i_BFu15s_D { unsigned int v1:7; unsigned short v2:15; double v3; };
struct BFu7i_BFu15s_F { unsigned int v1:7; unsigned short v2:15; float v3; };
struct BFu7i_BFu15s_I { unsigned int v1:7; unsigned short v2:15; int v3; };
struct BFu7i_BFu15s_Ip { unsigned int v1:7; unsigned short v2:15; int * v3; };
struct BFu7i_BFu15s_L { unsigned int v1:7; unsigned short v2:15; long long v3; };
struct BFu7i_BFu15s_S { unsigned int v1:7; unsigned short v2:15; short v3; };
struct BFu7i_BFu15s_Uc { unsigned int v1:7; unsigned short v2:15; unsigned char v3; };
struct BFu7i_BFu15s_Ui { unsigned int v1:7; unsigned short v2:15; unsigned int v3; };
struct BFu7i_BFu15s_Ul { unsigned int v1:7; unsigned short v2:15; unsigned long long v3; };
struct BFu7i_BFu15s_Us { unsigned int v1:7; unsigned short v2:15; unsigned short v3; };
struct BFu7i_BFu15s_Vp { unsigned int v1:7; unsigned short v2:15; void * v3; };
struct BFu7i_BFu16i { unsigned int v1:7; unsigned int v2:16; };
struct BFu7i_BFu16i_BFu15i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:15; };
struct BFu7i_BFu16i_BFu15ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:15; };
struct BFu7i_BFu16i_BFu15s { unsigned int v1:7; unsigned int v2:16; unsigned short v3:15; };
struct BFu7i_BFu16i_BFu16i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:16; };
struct BFu7i_BFu16i_BFu16ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:16; };
struct BFu7i_BFu16i_BFu16s { unsigned int v1:7; unsigned int v2:16; unsigned short v3:16; };
struct BFu7i_BFu16i_BFu17i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:17; };
struct BFu7i_BFu16i_BFu17ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:17; };
struct BFu7i_BFu16i_BFu1c { unsigned int v1:7; unsigned int v2:16; unsigned char v3:1; };
struct BFu7i_BFu16i_BFu1i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:1; };
struct BFu7i_BFu16i_BFu1ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:1; };
struct BFu7i_BFu16i_BFu1s { unsigned int v1:7; unsigned int v2:16; unsigned short v3:1; };
struct BFu7i_BFu16i_BFu31i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:31; };
struct BFu7i_BFu16i_BFu31ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:31; };
struct BFu7i_BFu16i_BFu32i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:32; };
struct BFu7i_BFu16i_BFu32ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:32; };
struct BFu7i_BFu16i_BFu33 { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:33; };
struct BFu7i_BFu16i_BFu7c { unsigned int v1:7; unsigned int v2:16; unsigned char v3:7; };
struct BFu7i_BFu16i_BFu7i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:7; };
struct BFu7i_BFu16i_BFu7ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:7; };
struct BFu7i_BFu16i_BFu7s { unsigned int v1:7; unsigned int v2:16; unsigned short v3:7; };
struct BFu7i_BFu16i_BFu8c { unsigned int v1:7; unsigned int v2:16; unsigned char v3:8; };
struct BFu7i_BFu16i_BFu8i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:8; };
struct BFu7i_BFu16i_BFu8ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:8; };
struct BFu7i_BFu16i_BFu8s { unsigned int v1:7; unsigned int v2:16; unsigned short v3:8; };
struct BFu7i_BFu16i_BFu9i { unsigned int v1:7; unsigned int v2:16; unsigned int v3:9; };
struct BFu7i_BFu16i_BFu9ll { unsigned int v1:7; unsigned int v2:16; unsigned long long v3:9; };
struct BFu7i_BFu16i_BFu9s { unsigned int v1:7; unsigned int v2:16; unsigned short v3:9; };
struct BFu7i_BFu16i_C { unsigned int v1:7; unsigned int v2:16; char v3; };
struct BFu7i_BFu16i_D { unsigned int v1:7; unsigned int v2:16; double v3; };
struct BFu7i_BFu16i_F { unsigned int v1:7; unsigned int v2:16; float v3; };
struct BFu7i_BFu16i_I { unsigned int v1:7; unsigned int v2:16; int v3; };
struct BFu7i_BFu16i_Ip { unsigned int v1:7; unsigned int v2:16; int * v3; };
struct BFu7i_BFu16i_L { unsigned int v1:7; unsigned int v2:16; long long v3; };
struct BFu7i_BFu16i_S { unsigned int v1:7; unsigned int v2:16; short v3; };
struct BFu7i_BFu16i_Uc { unsigned int v1:7; unsigned int v2:16; unsigned char v3; };
struct BFu7i_BFu16i_Ui { unsigned int v1:7; unsigned int v2:16; unsigned int v3; };
struct BFu7i_BFu16i_Ul { unsigned int v1:7; unsigned int v2:16; unsigned long long v3; };
struct BFu7i_BFu16i_Us { unsigned int v1:7; unsigned int v2:16; unsigned short v3; };
struct BFu7i_BFu16i_Vp { unsigned int v1:7; unsigned int v2:16; void * v3; };
struct BFu7i_BFu16ll { unsigned int v1:7; unsigned long long v2:16; };
struct BFu7i_BFu16ll_BFu15i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:15; };
struct BFu7i_BFu16ll_BFu15ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:15; };
struct BFu7i_BFu16ll_BFu15s { unsigned int v1:7; unsigned long long v2:16; unsigned short v3:15; };
struct BFu7i_BFu16ll_BFu16i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:16; };
struct BFu7i_BFu16ll_BFu16ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:16; };
struct BFu7i_BFu16ll_BFu16s { unsigned int v1:7; unsigned long long v2:16; unsigned short v3:16; };
struct BFu7i_BFu16ll_BFu17i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:17; };
struct BFu7i_BFu16ll_BFu17ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:17; };
struct BFu7i_BFu16ll_BFu1c { unsigned int v1:7; unsigned long long v2:16; unsigned char v3:1; };
struct BFu7i_BFu16ll_BFu1i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:1; };
struct BFu7i_BFu16ll_BFu1ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:1; };
struct BFu7i_BFu16ll_BFu1s { unsigned int v1:7; unsigned long long v2:16; unsigned short v3:1; };
struct BFu7i_BFu16ll_BFu31i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:31; };
struct BFu7i_BFu16ll_BFu31ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:31; };
struct BFu7i_BFu16ll_BFu32i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:32; };
struct BFu7i_BFu16ll_BFu32ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:32; };
struct BFu7i_BFu16ll_BFu33 { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:33; };
struct BFu7i_BFu16ll_BFu7c { unsigned int v1:7; unsigned long long v2:16; unsigned char v3:7; };
struct BFu7i_BFu16ll_BFu7i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:7; };
struct BFu7i_BFu16ll_BFu7ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:7; };
struct BFu7i_BFu16ll_BFu7s { unsigned int v1:7; unsigned long long v2:16; unsigned short v3:7; };
struct BFu7i_BFu16ll_BFu8c { unsigned int v1:7; unsigned long long v2:16; unsigned char v3:8; };
struct BFu7i_BFu16ll_BFu8i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:8; };
struct BFu7i_BFu16ll_BFu8ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:8; };
struct BFu7i_BFu16ll_BFu8s { unsigned int v1:7; unsigned long long v2:16; unsigned short v3:8; };
struct BFu7i_BFu16ll_BFu9i { unsigned int v1:7; unsigned long long v2:16; unsigned int v3:9; };
struct BFu7i_BFu16ll_BFu9ll { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3:9; };
struct BFu7i_BFu16ll_BFu9s { unsigned int v1:7; unsigned long long v2:16; unsigned short v3:9; };
struct BFu7i_BFu16ll_C { unsigned int v1:7; unsigned long long v2:16; char v3; };
struct BFu7i_BFu16ll_D { unsigned int v1:7; unsigned long long v2:16; double v3; };
struct BFu7i_BFu16ll_F { unsigned int v1:7; unsigned long long v2:16; float v3; };
struct BFu7i_BFu16ll_I { unsigned int v1:7; unsigned long long v2:16; int v3; };
struct BFu7i_BFu16ll_Ip { unsigned int v1:7; unsigned long long v2:16; int * v3; };
struct BFu7i_BFu16ll_L { unsigned int v1:7; unsigned long long v2:16; long long v3; };
struct BFu7i_BFu16ll_S { unsigned int v1:7; unsigned long long v2:16; short v3; };
struct BFu7i_BFu16ll_Uc { unsigned int v1:7; unsigned long long v2:16; unsigned char v3; };
struct BFu7i_BFu16ll_Ui { unsigned int v1:7; unsigned long long v2:16; unsigned int v3; };
struct BFu7i_BFu16ll_Ul { unsigned int v1:7; unsigned long long v2:16; unsigned long long v3; };
struct BFu7i_BFu16ll_Us { unsigned int v1:7; unsigned long long v2:16; unsigned short v3; };
struct BFu7i_BFu16ll_Vp { unsigned int v1:7; unsigned long long v2:16; void * v3; };
struct BFu7i_BFu16s { unsigned int v1:7; unsigned short v2:16; };
struct BFu7i_BFu16s_BFu15i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:15; };
struct BFu7i_BFu16s_BFu15ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:15; };
struct BFu7i_BFu16s_BFu15s { unsigned int v1:7; unsigned short v2:16; unsigned short v3:15; };
struct BFu7i_BFu16s_BFu16i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:16; };
struct BFu7i_BFu16s_BFu16ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:16; };
struct BFu7i_BFu16s_BFu16s { unsigned int v1:7; unsigned short v2:16; unsigned short v3:16; };
struct BFu7i_BFu16s_BFu17i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:17; };
struct BFu7i_BFu16s_BFu17ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:17; };
struct BFu7i_BFu16s_BFu1c { unsigned int v1:7; unsigned short v2:16; unsigned char v3:1; };
struct BFu7i_BFu16s_BFu1i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:1; };
struct BFu7i_BFu16s_BFu1ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:1; };
struct BFu7i_BFu16s_BFu1s { unsigned int v1:7; unsigned short v2:16; unsigned short v3:1; };
struct BFu7i_BFu16s_BFu31i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:31; };
struct BFu7i_BFu16s_BFu31ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:31; };
struct BFu7i_BFu16s_BFu32i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:32; };
struct BFu7i_BFu16s_BFu32ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:32; };
struct BFu7i_BFu16s_BFu33 { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:33; };
struct BFu7i_BFu16s_BFu7c { unsigned int v1:7; unsigned short v2:16; unsigned char v3:7; };
struct BFu7i_BFu16s_BFu7i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:7; };
struct BFu7i_BFu16s_BFu7ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:7; };
struct BFu7i_BFu16s_BFu7s { unsigned int v1:7; unsigned short v2:16; unsigned short v3:7; };
struct BFu7i_BFu16s_BFu8c { unsigned int v1:7; unsigned short v2:16; unsigned char v3:8; };
struct BFu7i_BFu16s_BFu8i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:8; };
struct BFu7i_BFu16s_BFu8ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:8; };
struct BFu7i_BFu16s_BFu8s { unsigned int v1:7; unsigned short v2:16; unsigned short v3:8; };
struct BFu7i_BFu16s_BFu9i { unsigned int v1:7; unsigned short v2:16; unsigned int v3:9; };
struct BFu7i_BFu16s_BFu9ll { unsigned int v1:7; unsigned short v2:16; unsigned long long v3:9; };
struct BFu7i_BFu16s_BFu9s { unsigned int v1:7; unsigned short v2:16; unsigned short v3:9; };
struct BFu7i_BFu16s_C { unsigned int v1:7; unsigned short v2:16; char v3; };
struct BFu7i_BFu16s_D { unsigned int v1:7; unsigned short v2:16; double v3; };
struct BFu7i_BFu16s_F { unsigned int v1:7; unsigned short v2:16; float v3; };
struct BFu7i_BFu16s_I { unsigned int v1:7; unsigned short v2:16; int v3; };
struct BFu7i_BFu16s_Ip { unsigned int v1:7; unsigned short v2:16; int * v3; };
struct BFu7i_BFu16s_L { unsigned int v1:7; unsigned short v2:16; long long v3; };
struct BFu7i_BFu16s_S { unsigned int v1:7; unsigned short v2:16; short v3; };
struct BFu7i_BFu16s_Uc { unsigned int v1:7; unsigned short v2:16; unsigned char v3; };
struct BFu7i_BFu16s_Ui { unsigned int v1:7; unsigned short v2:16; unsigned int v3; };
struct BFu7i_BFu16s_Ul { unsigned int v1:7; unsigned short v2:16; unsigned long long v3; };
struct BFu7i_BFu16s_Us { unsigned int v1:7; unsigned short v2:16; unsigned short v3; };
struct BFu7i_BFu16s_Vp { unsigned int v1:7; unsigned short v2:16; void * v3; };
struct BFu7i_BFu17i { unsigned int v1:7; unsigned int v2:17; };
struct BFu7i_BFu17i_BFu15i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:15; };
struct BFu7i_BFu17i_BFu15ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:15; };
struct BFu7i_BFu17i_BFu15s { unsigned int v1:7; unsigned int v2:17; unsigned short v3:15; };
struct BFu7i_BFu17i_BFu16i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:16; };
struct BFu7i_BFu17i_BFu16ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:16; };
struct BFu7i_BFu17i_BFu16s { unsigned int v1:7; unsigned int v2:17; unsigned short v3:16; };
struct BFu7i_BFu17i_BFu17i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:17; };
struct BFu7i_BFu17i_BFu17ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:17; };
struct BFu7i_BFu17i_BFu1c { unsigned int v1:7; unsigned int v2:17; unsigned char v3:1; };
struct BFu7i_BFu17i_BFu1i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:1; };
struct BFu7i_BFu17i_BFu1ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:1; };
struct BFu7i_BFu17i_BFu1s { unsigned int v1:7; unsigned int v2:17; unsigned short v3:1; };
struct BFu7i_BFu17i_BFu31i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:31; };
struct BFu7i_BFu17i_BFu31ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:31; };
struct BFu7i_BFu17i_BFu32i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:32; };
struct BFu7i_BFu17i_BFu32ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:32; };
struct BFu7i_BFu17i_BFu33 { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:33; };
struct BFu7i_BFu17i_BFu7c { unsigned int v1:7; unsigned int v2:17; unsigned char v3:7; };
struct BFu7i_BFu17i_BFu7i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:7; };
struct BFu7i_BFu17i_BFu7ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:7; };
struct BFu7i_BFu17i_BFu7s { unsigned int v1:7; unsigned int v2:17; unsigned short v3:7; };
struct BFu7i_BFu17i_BFu8c { unsigned int v1:7; unsigned int v2:17; unsigned char v3:8; };
struct BFu7i_BFu17i_BFu8i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:8; };
struct BFu7i_BFu17i_BFu8ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:8; };
struct BFu7i_BFu17i_BFu8s { unsigned int v1:7; unsigned int v2:17; unsigned short v3:8; };
struct BFu7i_BFu17i_BFu9i { unsigned int v1:7; unsigned int v2:17; unsigned int v3:9; };
struct BFu7i_BFu17i_BFu9ll { unsigned int v1:7; unsigned int v2:17; unsigned long long v3:9; };
struct BFu7i_BFu17i_BFu9s { unsigned int v1:7; unsigned int v2:17; unsigned short v3:9; };
struct BFu7i_BFu17i_C { unsigned int v1:7; unsigned int v2:17; char v3; };
struct BFu7i_BFu17i_D { unsigned int v1:7; unsigned int v2:17; double v3; };
struct BFu7i_BFu17i_F { unsigned int v1:7; unsigned int v2:17; float v3; };
struct BFu7i_BFu17i_I { unsigned int v1:7; unsigned int v2:17; int v3; };
struct BFu7i_BFu17i_Ip { unsigned int v1:7; unsigned int v2:17; int * v3; };
struct BFu7i_BFu17i_L { unsigned int v1:7; unsigned int v2:17; long long v3; };
struct BFu7i_BFu17i_S { unsigned int v1:7; unsigned int v2:17; short v3; };
struct BFu7i_BFu17i_Uc { unsigned int v1:7; unsigned int v2:17; unsigned char v3; };
struct BFu7i_BFu17i_Ui { unsigned int v1:7; unsigned int v2:17; unsigned int v3; };
struct BFu7i_BFu17i_Ul { unsigned int v1:7; unsigned int v2:17; unsigned long long v3; };
struct BFu7i_BFu17i_Us { unsigned int v1:7; unsigned int v2:17; unsigned short v3; };
struct BFu7i_BFu17i_Vp { unsigned int v1:7; unsigned int v2:17; void * v3; };
struct BFu7i_BFu17ll { unsigned int v1:7; unsigned long long v2:17; };
struct BFu7i_BFu17ll_BFu15i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:15; };
struct BFu7i_BFu17ll_BFu15ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:15; };
struct BFu7i_BFu17ll_BFu15s { unsigned int v1:7; unsigned long long v2:17; unsigned short v3:15; };
struct BFu7i_BFu17ll_BFu16i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:16; };
struct BFu7i_BFu17ll_BFu16ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:16; };
struct BFu7i_BFu17ll_BFu16s { unsigned int v1:7; unsigned long long v2:17; unsigned short v3:16; };
struct BFu7i_BFu17ll_BFu17i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:17; };
struct BFu7i_BFu17ll_BFu17ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:17; };
struct BFu7i_BFu17ll_BFu1c { unsigned int v1:7; unsigned long long v2:17; unsigned char v3:1; };
struct BFu7i_BFu17ll_BFu1i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:1; };
struct BFu7i_BFu17ll_BFu1ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:1; };
struct BFu7i_BFu17ll_BFu1s { unsigned int v1:7; unsigned long long v2:17; unsigned short v3:1; };
struct BFu7i_BFu17ll_BFu31i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:31; };
struct BFu7i_BFu17ll_BFu31ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:31; };
struct BFu7i_BFu17ll_BFu32i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:32; };
struct BFu7i_BFu17ll_BFu32ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:32; };
struct BFu7i_BFu17ll_BFu33 { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:33; };
struct BFu7i_BFu17ll_BFu7c { unsigned int v1:7; unsigned long long v2:17; unsigned char v3:7; };
struct BFu7i_BFu17ll_BFu7i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:7; };
struct BFu7i_BFu17ll_BFu7ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:7; };
struct BFu7i_BFu17ll_BFu7s { unsigned int v1:7; unsigned long long v2:17; unsigned short v3:7; };
struct BFu7i_BFu17ll_BFu8c { unsigned int v1:7; unsigned long long v2:17; unsigned char v3:8; };
struct BFu7i_BFu17ll_BFu8i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:8; };
struct BFu7i_BFu17ll_BFu8ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:8; };
struct BFu7i_BFu17ll_BFu8s { unsigned int v1:7; unsigned long long v2:17; unsigned short v3:8; };
struct BFu7i_BFu17ll_BFu9i { unsigned int v1:7; unsigned long long v2:17; unsigned int v3:9; };
struct BFu7i_BFu17ll_BFu9ll { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3:9; };
struct BFu7i_BFu17ll_BFu9s { unsigned int v1:7; unsigned long long v2:17; unsigned short v3:9; };
struct BFu7i_BFu17ll_C { unsigned int v1:7; unsigned long long v2:17; char v3; };
struct BFu7i_BFu17ll_D { unsigned int v1:7; unsigned long long v2:17; double v3; };
struct BFu7i_BFu17ll_F { unsigned int v1:7; unsigned long long v2:17; float v3; };
struct BFu7i_BFu17ll_I { unsigned int v1:7; unsigned long long v2:17; int v3; };
struct BFu7i_BFu17ll_Ip { unsigned int v1:7; unsigned long long v2:17; int * v3; };
struct BFu7i_BFu17ll_L { unsigned int v1:7; unsigned long long v2:17; long long v3; };
struct BFu7i_BFu17ll_S { unsigned int v1:7; unsigned long long v2:17; short v3; };
struct BFu7i_BFu17ll_Uc { unsigned int v1:7; unsigned long long v2:17; unsigned char v3; };
struct BFu7i_BFu17ll_Ui { unsigned int v1:7; unsigned long long v2:17; unsigned int v3; };
struct BFu7i_BFu17ll_Ul { unsigned int v1:7; unsigned long long v2:17; unsigned long long v3; };
struct BFu7i_BFu17ll_Us { unsigned int v1:7; unsigned long long v2:17; unsigned short v3; };
struct BFu7i_BFu17ll_Vp { unsigned int v1:7; unsigned long long v2:17; void * v3; };
struct BFu7i_BFu1c { unsigned int v1:7; unsigned char v2:1; };
struct BFu7i_BFu1c_BFu15i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:15; };
struct BFu7i_BFu1c_BFu15ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:15; };
struct BFu7i_BFu1c_BFu15s { unsigned int v1:7; unsigned char v2:1; unsigned short v3:15; };
struct BFu7i_BFu1c_BFu16i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:16; };
struct BFu7i_BFu1c_BFu16ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:16; };
struct BFu7i_BFu1c_BFu16s { unsigned int v1:7; unsigned char v2:1; unsigned short v3:16; };
struct BFu7i_BFu1c_BFu17i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:17; };
struct BFu7i_BFu1c_BFu17ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:17; };
struct BFu7i_BFu1c_BFu1c { unsigned int v1:7; unsigned char v2:1; unsigned char v3:1; };
struct BFu7i_BFu1c_BFu1i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:1; };
struct BFu7i_BFu1c_BFu1ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:1; };
struct BFu7i_BFu1c_BFu1s { unsigned int v1:7; unsigned char v2:1; unsigned short v3:1; };
struct BFu7i_BFu1c_BFu31i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:31; };
struct BFu7i_BFu1c_BFu31ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:31; };
struct BFu7i_BFu1c_BFu32i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:32; };
struct BFu7i_BFu1c_BFu32ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:32; };
struct BFu7i_BFu1c_BFu33 { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:33; };
struct BFu7i_BFu1c_BFu7c { unsigned int v1:7; unsigned char v2:1; unsigned char v3:7; };
struct BFu7i_BFu1c_BFu7i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:7; };
struct BFu7i_BFu1c_BFu7ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:7; };
struct BFu7i_BFu1c_BFu7s { unsigned int v1:7; unsigned char v2:1; unsigned short v3:7; };
struct BFu7i_BFu1c_BFu8c { unsigned int v1:7; unsigned char v2:1; unsigned char v3:8; };
struct BFu7i_BFu1c_BFu8i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:8; };
struct BFu7i_BFu1c_BFu8ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:8; };
struct BFu7i_BFu1c_BFu8s { unsigned int v1:7; unsigned char v2:1; unsigned short v3:8; };
struct BFu7i_BFu1c_BFu9i { unsigned int v1:7; unsigned char v2:1; unsigned int v3:9; };
struct BFu7i_BFu1c_BFu9ll { unsigned int v1:7; unsigned char v2:1; unsigned long long v3:9; };
struct BFu7i_BFu1c_BFu9s { unsigned int v1:7; unsigned char v2:1; unsigned short v3:9; };
struct BFu7i_BFu1c_C { unsigned int v1:7; unsigned char v2:1; char v3; };
struct BFu7i_BFu1c_D { unsigned int v1:7; unsigned char v2:1; double v3; };
struct BFu7i_BFu1c_F { unsigned int v1:7; unsigned char v2:1; float v3; };
struct BFu7i_BFu1c_I { unsigned int v1:7; unsigned char v2:1; int v3; };
struct BFu7i_BFu1c_Ip { unsigned int v1:7; unsigned char v2:1; int * v3; };
struct BFu7i_BFu1c_L { unsigned int v1:7; unsigned char v2:1; long long v3; };
struct BFu7i_BFu1c_S { unsigned int v1:7; unsigned char v2:1; short v3; };
struct BFu7i_BFu1c_Uc { unsigned int v1:7; unsigned char v2:1; unsigned char v3; };
struct BFu7i_BFu1c_Ui { unsigned int v1:7; unsigned char v2:1; unsigned int v3; };
struct BFu7i_BFu1c_Ul { unsigned int v1:7; unsigned char v2:1; unsigned long long v3; };
struct BFu7i_BFu1c_Us { unsigned int v1:7; unsigned char v2:1; unsigned short v3; };
struct BFu7i_BFu1c_Vp { unsigned int v1:7; unsigned char v2:1; void * v3; };
struct BFu7i_BFu1i { unsigned int v1:7; unsigned int v2:1; };
struct BFu7i_BFu1i_BFu15i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:15; };
struct BFu7i_BFu1i_BFu15ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:15; };
struct BFu7i_BFu1i_BFu15s { unsigned int v1:7; unsigned int v2:1; unsigned short v3:15; };
struct BFu7i_BFu1i_BFu16i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:16; };
struct BFu7i_BFu1i_BFu16ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:16; };
struct BFu7i_BFu1i_BFu16s { unsigned int v1:7; unsigned int v2:1; unsigned short v3:16; };
struct BFu7i_BFu1i_BFu17i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:17; };
struct BFu7i_BFu1i_BFu17ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:17; };
struct BFu7i_BFu1i_BFu1c { unsigned int v1:7; unsigned int v2:1; unsigned char v3:1; };
struct BFu7i_BFu1i_BFu1i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:1; };
struct BFu7i_BFu1i_BFu1ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:1; };
struct BFu7i_BFu1i_BFu1s { unsigned int v1:7; unsigned int v2:1; unsigned short v3:1; };
struct BFu7i_BFu1i_BFu31i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:31; };
struct BFu7i_BFu1i_BFu31ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:31; };
struct BFu7i_BFu1i_BFu32i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:32; };
struct BFu7i_BFu1i_BFu32ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:32; };
struct BFu7i_BFu1i_BFu33 { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:33; };
struct BFu7i_BFu1i_BFu7c { unsigned int v1:7; unsigned int v2:1; unsigned char v3:7; };
struct BFu7i_BFu1i_BFu7i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:7; };
struct BFu7i_BFu1i_BFu7ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:7; };
struct BFu7i_BFu1i_BFu7s { unsigned int v1:7; unsigned int v2:1; unsigned short v3:7; };
struct BFu7i_BFu1i_BFu8c { unsigned int v1:7; unsigned int v2:1; unsigned char v3:8; };
struct BFu7i_BFu1i_BFu8i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:8; };
struct BFu7i_BFu1i_BFu8ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:8; };
struct BFu7i_BFu1i_BFu8s { unsigned int v1:7; unsigned int v2:1; unsigned short v3:8; };
struct BFu7i_BFu1i_BFu9i { unsigned int v1:7; unsigned int v2:1; unsigned int v3:9; };
struct BFu7i_BFu1i_BFu9ll { unsigned int v1:7; unsigned int v2:1; unsigned long long v3:9; };
struct BFu7i_BFu1i_BFu9s { unsigned int v1:7; unsigned int v2:1; unsigned short v3:9; };
struct BFu7i_BFu1i_C { unsigned int v1:7; unsigned int v2:1; char v3; };
struct BFu7i_BFu1i_D { unsigned int v1:7; unsigned int v2:1; double v3; };
struct BFu7i_BFu1i_F { unsigned int v1:7; unsigned int v2:1; float v3; };
struct BFu7i_BFu1i_I { unsigned int v1:7; unsigned int v2:1; int v3; };
struct BFu7i_BFu1i_Ip { unsigned int v1:7; unsigned int v2:1; int * v3; };
struct BFu7i_BFu1i_L { unsigned int v1:7; unsigned int v2:1; long long v3; };
struct BFu7i_BFu1i_S { unsigned int v1:7; unsigned int v2:1; short v3; };
struct BFu7i_BFu1i_Uc { unsigned int v1:7; unsigned int v2:1; unsigned char v3; };
struct BFu7i_BFu1i_Ui { unsigned int v1:7; unsigned int v2:1; unsigned int v3; };
struct BFu7i_BFu1i_Ul { unsigned int v1:7; unsigned int v2:1; unsigned long long v3; };
struct BFu7i_BFu1i_Us { unsigned int v1:7; unsigned int v2:1; unsigned short v3; };
struct BFu7i_BFu1i_Vp { unsigned int v1:7; unsigned int v2:1; void * v3; };
struct BFu7i_BFu1ll { unsigned int v1:7; unsigned long long v2:1; };
struct BFu7i_BFu1ll_BFu15i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:15; };
struct BFu7i_BFu1ll_BFu15ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:15; };
struct BFu7i_BFu1ll_BFu15s { unsigned int v1:7; unsigned long long v2:1; unsigned short v3:15; };
struct BFu7i_BFu1ll_BFu16i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:16; };
struct BFu7i_BFu1ll_BFu16ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:16; };
struct BFu7i_BFu1ll_BFu16s { unsigned int v1:7; unsigned long long v2:1; unsigned short v3:16; };
struct BFu7i_BFu1ll_BFu17i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:17; };
struct BFu7i_BFu1ll_BFu17ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:17; };
struct BFu7i_BFu1ll_BFu1c { unsigned int v1:7; unsigned long long v2:1; unsigned char v3:1; };
struct BFu7i_BFu1ll_BFu1i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:1; };
struct BFu7i_BFu1ll_BFu1ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:1; };
struct BFu7i_BFu1ll_BFu1s { unsigned int v1:7; unsigned long long v2:1; unsigned short v3:1; };
struct BFu7i_BFu1ll_BFu31i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:31; };
struct BFu7i_BFu1ll_BFu31ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:31; };
struct BFu7i_BFu1ll_BFu32i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:32; };
struct BFu7i_BFu1ll_BFu32ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:32; };
struct BFu7i_BFu1ll_BFu33 { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:33; };
struct BFu7i_BFu1ll_BFu7c { unsigned int v1:7; unsigned long long v2:1; unsigned char v3:7; };
struct BFu7i_BFu1ll_BFu7i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:7; };
struct BFu7i_BFu1ll_BFu7ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:7; };
struct BFu7i_BFu1ll_BFu7s { unsigned int v1:7; unsigned long long v2:1; unsigned short v3:7; };
struct BFu7i_BFu1ll_BFu8c { unsigned int v1:7; unsigned long long v2:1; unsigned char v3:8; };
struct BFu7i_BFu1ll_BFu8i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:8; };
struct BFu7i_BFu1ll_BFu8ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:8; };
struct BFu7i_BFu1ll_BFu8s { unsigned int v1:7; unsigned long long v2:1; unsigned short v3:8; };
struct BFu7i_BFu1ll_BFu9i { unsigned int v1:7; unsigned long long v2:1; unsigned int v3:9; };
struct BFu7i_BFu1ll_BFu9ll { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3:9; };
struct BFu7i_BFu1ll_BFu9s { unsigned int v1:7; unsigned long long v2:1; unsigned short v3:9; };
struct BFu7i_BFu1ll_C { unsigned int v1:7; unsigned long long v2:1; char v3; };
struct BFu7i_BFu1ll_D { unsigned int v1:7; unsigned long long v2:1; double v3; };
struct BFu7i_BFu1ll_F { unsigned int v1:7; unsigned long long v2:1; float v3; };
struct BFu7i_BFu1ll_I { unsigned int v1:7; unsigned long long v2:1; int v3; };
struct BFu7i_BFu1ll_Ip { unsigned int v1:7; unsigned long long v2:1; int * v3; };
struct BFu7i_BFu1ll_L { unsigned int v1:7; unsigned long long v2:1; long long v3; };
struct BFu7i_BFu1ll_S { unsigned int v1:7; unsigned long long v2:1; short v3; };
struct BFu7i_BFu1ll_Uc { unsigned int v1:7; unsigned long long v2:1; unsigned char v3; };
struct BFu7i_BFu1ll_Ui { unsigned int v1:7; unsigned long long v2:1; unsigned int v3; };
struct BFu7i_BFu1ll_Ul { unsigned int v1:7; unsigned long long v2:1; unsigned long long v3; };
struct BFu7i_BFu1ll_Us { unsigned int v1:7; unsigned long long v2:1; unsigned short v3; };
struct BFu7i_BFu1ll_Vp { unsigned int v1:7; unsigned long long v2:1; void * v3; };
struct BFu7i_BFu1s { unsigned int v1:7; unsigned short v2:1; };
struct BFu7i_BFu1s_BFu15i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:15; };
struct BFu7i_BFu1s_BFu15ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:15; };
struct BFu7i_BFu1s_BFu15s { unsigned int v1:7; unsigned short v2:1; unsigned short v3:15; };
struct BFu7i_BFu1s_BFu16i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:16; };
struct BFu7i_BFu1s_BFu16ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:16; };
struct BFu7i_BFu1s_BFu16s { unsigned int v1:7; unsigned short v2:1; unsigned short v3:16; };
struct BFu7i_BFu1s_BFu17i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:17; };
struct BFu7i_BFu1s_BFu17ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:17; };
struct BFu7i_BFu1s_BFu1c { unsigned int v1:7; unsigned short v2:1; unsigned char v3:1; };
struct BFu7i_BFu1s_BFu1i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:1; };
struct BFu7i_BFu1s_BFu1ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:1; };
struct BFu7i_BFu1s_BFu1s { unsigned int v1:7; unsigned short v2:1; unsigned short v3:1; };
struct BFu7i_BFu1s_BFu31i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:31; };
struct BFu7i_BFu1s_BFu31ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:31; };
struct BFu7i_BFu1s_BFu32i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:32; };
struct BFu7i_BFu1s_BFu32ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:32; };
struct BFu7i_BFu1s_BFu33 { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:33; };
struct BFu7i_BFu1s_BFu7c { unsigned int v1:7; unsigned short v2:1; unsigned char v3:7; };
struct BFu7i_BFu1s_BFu7i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:7; };
struct BFu7i_BFu1s_BFu7ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:7; };
struct BFu7i_BFu1s_BFu7s { unsigned int v1:7; unsigned short v2:1; unsigned short v3:7; };
struct BFu7i_BFu1s_BFu8c { unsigned int v1:7; unsigned short v2:1; unsigned char v3:8; };
struct BFu7i_BFu1s_BFu8i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:8; };
struct BFu7i_BFu1s_BFu8ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:8; };
struct BFu7i_BFu1s_BFu8s { unsigned int v1:7; unsigned short v2:1; unsigned short v3:8; };
struct BFu7i_BFu1s_BFu9i { unsigned int v1:7; unsigned short v2:1; unsigned int v3:9; };
struct BFu7i_BFu1s_BFu9ll { unsigned int v1:7; unsigned short v2:1; unsigned long long v3:9; };
struct BFu7i_BFu1s_BFu9s { unsigned int v1:7; unsigned short v2:1; unsigned short v3:9; };
struct BFu7i_BFu1s_C { unsigned int v1:7; unsigned short v2:1; char v3; };
struct BFu7i_BFu1s_D { unsigned int v1:7; unsigned short v2:1; double v3; };
struct BFu7i_BFu1s_F { unsigned int v1:7; unsigned short v2:1; float v3; };
struct BFu7i_BFu1s_I { unsigned int v1:7; unsigned short v2:1; int v3; };
struct BFu7i_BFu1s_Ip { unsigned int v1:7; unsigned short v2:1; int * v3; };
struct BFu7i_BFu1s_L { unsigned int v1:7; unsigned short v2:1; long long v3; };
struct BFu7i_BFu1s_S { unsigned int v1:7; unsigned short v2:1; short v3; };
struct BFu7i_BFu1s_Uc { unsigned int v1:7; unsigned short v2:1; unsigned char v3; };
struct BFu7i_BFu1s_Ui { unsigned int v1:7; unsigned short v2:1; unsigned int v3; };
struct BFu7i_BFu1s_Ul { unsigned int v1:7; unsigned short v2:1; unsigned long long v3; };
struct BFu7i_BFu1s_Us { unsigned int v1:7; unsigned short v2:1; unsigned short v3; };
struct BFu7i_BFu1s_Vp { unsigned int v1:7; unsigned short v2:1; void * v3; };
struct BFu7i_BFu31i { unsigned int v1:7; unsigned int v2:31; };
struct BFu7i_BFu31i_BFu15i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:15; };
struct BFu7i_BFu31i_BFu15ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:15; };
struct BFu7i_BFu31i_BFu15s { unsigned int v1:7; unsigned int v2:31; unsigned short v3:15; };
struct BFu7i_BFu31i_BFu16i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:16; };
struct BFu7i_BFu31i_BFu16ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:16; };
struct BFu7i_BFu31i_BFu16s { unsigned int v1:7; unsigned int v2:31; unsigned short v3:16; };
struct BFu7i_BFu31i_BFu17i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:17; };
struct BFu7i_BFu31i_BFu17ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:17; };
struct BFu7i_BFu31i_BFu1c { unsigned int v1:7; unsigned int v2:31; unsigned char v3:1; };
struct BFu7i_BFu31i_BFu1i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:1; };
struct BFu7i_BFu31i_BFu1ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:1; };
struct BFu7i_BFu31i_BFu1s { unsigned int v1:7; unsigned int v2:31; unsigned short v3:1; };
struct BFu7i_BFu31i_BFu31i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:31; };
struct BFu7i_BFu31i_BFu31ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:31; };
struct BFu7i_BFu31i_BFu32i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:32; };
struct BFu7i_BFu31i_BFu32ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:32; };
struct BFu7i_BFu31i_BFu33 { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:33; };
struct BFu7i_BFu31i_BFu7c { unsigned int v1:7; unsigned int v2:31; unsigned char v3:7; };
struct BFu7i_BFu31i_BFu7i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:7; };
struct BFu7i_BFu31i_BFu7ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:7; };
struct BFu7i_BFu31i_BFu7s { unsigned int v1:7; unsigned int v2:31; unsigned short v3:7; };
struct BFu7i_BFu31i_BFu8c { unsigned int v1:7; unsigned int v2:31; unsigned char v3:8; };
struct BFu7i_BFu31i_BFu8i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:8; };
struct BFu7i_BFu31i_BFu8ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:8; };
struct BFu7i_BFu31i_BFu8s { unsigned int v1:7; unsigned int v2:31; unsigned short v3:8; };
struct BFu7i_BFu31i_BFu9i { unsigned int v1:7; unsigned int v2:31; unsigned int v3:9; };
struct BFu7i_BFu31i_BFu9ll { unsigned int v1:7; unsigned int v2:31; unsigned long long v3:9; };
struct BFu7i_BFu31i_BFu9s { unsigned int v1:7; unsigned int v2:31; unsigned short v3:9; };
struct BFu7i_BFu31i_C { unsigned int v1:7; unsigned int v2:31; char v3; };
struct BFu7i_BFu31i_D { unsigned int v1:7; unsigned int v2:31; double v3; };
struct BFu7i_BFu31i_F { unsigned int v1:7; unsigned int v2:31; float v3; };
struct BFu7i_BFu31i_I { unsigned int v1:7; unsigned int v2:31; int v3; };
struct BFu7i_BFu31i_Ip { unsigned int v1:7; unsigned int v2:31; int * v3; };
struct BFu7i_BFu31i_L { unsigned int v1:7; unsigned int v2:31; long long v3; };
struct BFu7i_BFu31i_S { unsigned int v1:7; unsigned int v2:31; short v3; };
struct BFu7i_BFu31i_Uc { unsigned int v1:7; unsigned int v2:31; unsigned char v3; };
struct BFu7i_BFu31i_Ui { unsigned int v1:7; unsigned int v2:31; unsigned int v3; };
struct BFu7i_BFu31i_Ul { unsigned int v1:7; unsigned int v2:31; unsigned long long v3; };
struct BFu7i_BFu31i_Us { unsigned int v1:7; unsigned int v2:31; unsigned short v3; };
struct BFu7i_BFu31i_Vp { unsigned int v1:7; unsigned int v2:31; void * v3; };
struct BFu7i_BFu31ll { unsigned int v1:7; unsigned long long v2:31; };
struct BFu7i_BFu31ll_BFu15i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:15; };
struct BFu7i_BFu31ll_BFu15ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:15; };
struct BFu7i_BFu31ll_BFu15s { unsigned int v1:7; unsigned long long v2:31; unsigned short v3:15; };
struct BFu7i_BFu31ll_BFu16i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:16; };
struct BFu7i_BFu31ll_BFu16ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:16; };
struct BFu7i_BFu31ll_BFu16s { unsigned int v1:7; unsigned long long v2:31; unsigned short v3:16; };
struct BFu7i_BFu31ll_BFu17i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:17; };
struct BFu7i_BFu31ll_BFu17ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:17; };
struct BFu7i_BFu31ll_BFu1c { unsigned int v1:7; unsigned long long v2:31; unsigned char v3:1; };
struct BFu7i_BFu31ll_BFu1i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:1; };
struct BFu7i_BFu31ll_BFu1ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:1; };
struct BFu7i_BFu31ll_BFu1s { unsigned int v1:7; unsigned long long v2:31; unsigned short v3:1; };
struct BFu7i_BFu31ll_BFu31i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:31; };
struct BFu7i_BFu31ll_BFu31ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:31; };
struct BFu7i_BFu31ll_BFu32i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:32; };
struct BFu7i_BFu31ll_BFu32ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:32; };
struct BFu7i_BFu31ll_BFu33 { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:33; };
struct BFu7i_BFu31ll_BFu7c { unsigned int v1:7; unsigned long long v2:31; unsigned char v3:7; };
struct BFu7i_BFu31ll_BFu7i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:7; };
struct BFu7i_BFu31ll_BFu7ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:7; };
struct BFu7i_BFu31ll_BFu7s { unsigned int v1:7; unsigned long long v2:31; unsigned short v3:7; };
struct BFu7i_BFu31ll_BFu8c { unsigned int v1:7; unsigned long long v2:31; unsigned char v3:8; };
struct BFu7i_BFu31ll_BFu8i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:8; };
struct BFu7i_BFu31ll_BFu8ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:8; };
struct BFu7i_BFu31ll_BFu8s { unsigned int v1:7; unsigned long long v2:31; unsigned short v3:8; };
struct BFu7i_BFu31ll_BFu9i { unsigned int v1:7; unsigned long long v2:31; unsigned int v3:9; };
struct BFu7i_BFu31ll_BFu9ll { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3:9; };
struct BFu7i_BFu31ll_BFu9s { unsigned int v1:7; unsigned long long v2:31; unsigned short v3:9; };
struct BFu7i_BFu31ll_C { unsigned int v1:7; unsigned long long v2:31; char v3; };
struct BFu7i_BFu31ll_D { unsigned int v1:7; unsigned long long v2:31; double v3; };
struct BFu7i_BFu31ll_F { unsigned int v1:7; unsigned long long v2:31; float v3; };
struct BFu7i_BFu31ll_I { unsigned int v1:7; unsigned long long v2:31; int v3; };
struct BFu7i_BFu31ll_Ip { unsigned int v1:7; unsigned long long v2:31; int * v3; };
struct BFu7i_BFu31ll_L { unsigned int v1:7; unsigned long long v2:31; long long v3; };
struct BFu7i_BFu31ll_S { unsigned int v1:7; unsigned long long v2:31; short v3; };
struct BFu7i_BFu31ll_Uc { unsigned int v1:7; unsigned long long v2:31; unsigned char v3; };
struct BFu7i_BFu31ll_Ui { unsigned int v1:7; unsigned long long v2:31; unsigned int v3; };
struct BFu7i_BFu31ll_Ul { unsigned int v1:7; unsigned long long v2:31; unsigned long long v3; };
struct BFu7i_BFu31ll_Us { unsigned int v1:7; unsigned long long v2:31; unsigned short v3; };
struct BFu7i_BFu31ll_Vp { unsigned int v1:7; unsigned long long v2:31; void * v3; };
struct BFu7i_BFu32i { unsigned int v1:7; unsigned int v2:32; };
struct BFu7i_BFu32i_BFu15i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:15; };
struct BFu7i_BFu32i_BFu15ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:15; };
struct BFu7i_BFu32i_BFu15s { unsigned int v1:7; unsigned int v2:32; unsigned short v3:15; };
struct BFu7i_BFu32i_BFu16i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:16; };
struct BFu7i_BFu32i_BFu16ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:16; };
struct BFu7i_BFu32i_BFu16s { unsigned int v1:7; unsigned int v2:32; unsigned short v3:16; };
struct BFu7i_BFu32i_BFu17i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:17; };
struct BFu7i_BFu32i_BFu17ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:17; };
struct BFu7i_BFu32i_BFu1c { unsigned int v1:7; unsigned int v2:32; unsigned char v3:1; };
struct BFu7i_BFu32i_BFu1i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:1; };
struct BFu7i_BFu32i_BFu1ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:1; };
struct BFu7i_BFu32i_BFu1s { unsigned int v1:7; unsigned int v2:32; unsigned short v3:1; };
struct BFu7i_BFu32i_BFu31i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:31; };
struct BFu7i_BFu32i_BFu31ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:31; };
struct BFu7i_BFu32i_BFu32i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:32; };
struct BFu7i_BFu32i_BFu32ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:32; };
struct BFu7i_BFu32i_BFu33 { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:33; };
struct BFu7i_BFu32i_BFu7c { unsigned int v1:7; unsigned int v2:32; unsigned char v3:7; };
struct BFu7i_BFu32i_BFu7i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:7; };
struct BFu7i_BFu32i_BFu7ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:7; };
struct BFu7i_BFu32i_BFu7s { unsigned int v1:7; unsigned int v2:32; unsigned short v3:7; };
struct BFu7i_BFu32i_BFu8c { unsigned int v1:7; unsigned int v2:32; unsigned char v3:8; };
struct BFu7i_BFu32i_BFu8i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:8; };
struct BFu7i_BFu32i_BFu8ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:8; };
struct BFu7i_BFu32i_BFu8s { unsigned int v1:7; unsigned int v2:32; unsigned short v3:8; };
struct BFu7i_BFu32i_BFu9i { unsigned int v1:7; unsigned int v2:32; unsigned int v3:9; };
struct BFu7i_BFu32i_BFu9ll { unsigned int v1:7; unsigned int v2:32; unsigned long long v3:9; };
struct BFu7i_BFu32i_BFu9s { unsigned int v1:7; unsigned int v2:32; unsigned short v3:9; };
struct BFu7i_BFu32i_C { unsigned int v1:7; unsigned int v2:32; char v3; };
struct BFu7i_BFu32i_D { unsigned int v1:7; unsigned int v2:32; double v3; };
struct BFu7i_BFu32i_F { unsigned int v1:7; unsigned int v2:32; float v3; };
struct BFu7i_BFu32i_I { unsigned int v1:7; unsigned int v2:32; int v3; };
struct BFu7i_BFu32i_Ip { unsigned int v1:7; unsigned int v2:32; int * v3; };
struct BFu7i_BFu32i_L { unsigned int v1:7; unsigned int v2:32; long long v3; };
struct BFu7i_BFu32i_S { unsigned int v1:7; unsigned int v2:32; short v3; };
struct BFu7i_BFu32i_Uc { unsigned int v1:7; unsigned int v2:32; unsigned char v3; };
struct BFu7i_BFu32i_Ui { unsigned int v1:7; unsigned int v2:32; unsigned int v3; };
struct BFu7i_BFu32i_Ul { unsigned int v1:7; unsigned int v2:32; unsigned long long v3; };
struct BFu7i_BFu32i_Us { unsigned int v1:7; unsigned int v2:32; unsigned short v3; };
struct BFu7i_BFu32i_Vp { unsigned int v1:7; unsigned int v2:32; void * v3; };
struct BFu7i_BFu32ll { unsigned int v1:7; unsigned long long v2:32; };
struct BFu7i_BFu32ll_BFu15i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:15; };
struct BFu7i_BFu32ll_BFu15ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:15; };
struct BFu7i_BFu32ll_BFu15s { unsigned int v1:7; unsigned long long v2:32; unsigned short v3:15; };
struct BFu7i_BFu32ll_BFu16i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:16; };
struct BFu7i_BFu32ll_BFu16ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:16; };
struct BFu7i_BFu32ll_BFu16s { unsigned int v1:7; unsigned long long v2:32; unsigned short v3:16; };
struct BFu7i_BFu32ll_BFu17i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:17; };
struct BFu7i_BFu32ll_BFu17ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:17; };
struct BFu7i_BFu32ll_BFu1c { unsigned int v1:7; unsigned long long v2:32; unsigned char v3:1; };
struct BFu7i_BFu32ll_BFu1i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:1; };
struct BFu7i_BFu32ll_BFu1ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:1; };
struct BFu7i_BFu32ll_BFu1s { unsigned int v1:7; unsigned long long v2:32; unsigned short v3:1; };
struct BFu7i_BFu32ll_BFu31i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:31; };
struct BFu7i_BFu32ll_BFu31ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:31; };
struct BFu7i_BFu32ll_BFu32i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:32; };
struct BFu7i_BFu32ll_BFu32ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:32; };
struct BFu7i_BFu32ll_BFu33 { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:33; };
struct BFu7i_BFu32ll_BFu7c { unsigned int v1:7; unsigned long long v2:32; unsigned char v3:7; };
struct BFu7i_BFu32ll_BFu7i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:7; };
struct BFu7i_BFu32ll_BFu7ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:7; };
struct BFu7i_BFu32ll_BFu7s { unsigned int v1:7; unsigned long long v2:32; unsigned short v3:7; };
struct BFu7i_BFu32ll_BFu8c { unsigned int v1:7; unsigned long long v2:32; unsigned char v3:8; };
struct BFu7i_BFu32ll_BFu8i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:8; };
struct BFu7i_BFu32ll_BFu8ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:8; };
struct BFu7i_BFu32ll_BFu8s { unsigned int v1:7; unsigned long long v2:32; unsigned short v3:8; };
struct BFu7i_BFu32ll_BFu9i { unsigned int v1:7; unsigned long long v2:32; unsigned int v3:9; };
struct BFu7i_BFu32ll_BFu9ll { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3:9; };
struct BFu7i_BFu32ll_BFu9s { unsigned int v1:7; unsigned long long v2:32; unsigned short v3:9; };
struct BFu7i_BFu32ll_C { unsigned int v1:7; unsigned long long v2:32; char v3; };
struct BFu7i_BFu32ll_D { unsigned int v1:7; unsigned long long v2:32; double v3; };
struct BFu7i_BFu32ll_F { unsigned int v1:7; unsigned long long v2:32; float v3; };
struct BFu7i_BFu32ll_I { unsigned int v1:7; unsigned long long v2:32; int v3; };
struct BFu7i_BFu32ll_Ip { unsigned int v1:7; unsigned long long v2:32; int * v3; };
struct BFu7i_BFu32ll_L { unsigned int v1:7; unsigned long long v2:32; long long v3; };
struct BFu7i_BFu32ll_S { unsigned int v1:7; unsigned long long v2:32; short v3; };
struct BFu7i_BFu32ll_Uc { unsigned int v1:7; unsigned long long v2:32; unsigned char v3; };
struct BFu7i_BFu32ll_Ui { unsigned int v1:7; unsigned long long v2:32; unsigned int v3; };
struct BFu7i_BFu32ll_Ul { unsigned int v1:7; unsigned long long v2:32; unsigned long long v3; };
struct BFu7i_BFu32ll_Us { unsigned int v1:7; unsigned long long v2:32; unsigned short v3; };
struct BFu7i_BFu32ll_Vp { unsigned int v1:7; unsigned long long v2:32; void * v3; };
struct BFu7i_BFu33 { unsigned int v1:7; unsigned long long v2:33; };
struct BFu7i_BFu33_BFu15i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:15; };
struct BFu7i_BFu33_BFu15ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:15; };
struct BFu7i_BFu33_BFu15s { unsigned int v1:7; unsigned long long v2:33; unsigned short v3:15; };
struct BFu7i_BFu33_BFu16i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:16; };
struct BFu7i_BFu33_BFu16ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:16; };
struct BFu7i_BFu33_BFu16s { unsigned int v1:7; unsigned long long v2:33; unsigned short v3:16; };
struct BFu7i_BFu33_BFu17i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:17; };
struct BFu7i_BFu33_BFu17ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:17; };
struct BFu7i_BFu33_BFu1c { unsigned int v1:7; unsigned long long v2:33; unsigned char v3:1; };
struct BFu7i_BFu33_BFu1i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:1; };
struct BFu7i_BFu33_BFu1ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:1; };
struct BFu7i_BFu33_BFu1s { unsigned int v1:7; unsigned long long v2:33; unsigned short v3:1; };
struct BFu7i_BFu33_BFu31i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:31; };
struct BFu7i_BFu33_BFu31ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:31; };
struct BFu7i_BFu33_BFu32i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:32; };
struct BFu7i_BFu33_BFu32ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:32; };
struct BFu7i_BFu33_BFu33 { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:33; };
struct BFu7i_BFu33_BFu7c { unsigned int v1:7; unsigned long long v2:33; unsigned char v3:7; };
struct BFu7i_BFu33_BFu7i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:7; };
struct BFu7i_BFu33_BFu7ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:7; };
struct BFu7i_BFu33_BFu7s { unsigned int v1:7; unsigned long long v2:33; unsigned short v3:7; };
struct BFu7i_BFu33_BFu8c { unsigned int v1:7; unsigned long long v2:33; unsigned char v3:8; };
struct BFu7i_BFu33_BFu8i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:8; };
struct BFu7i_BFu33_BFu8ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:8; };
struct BFu7i_BFu33_BFu8s { unsigned int v1:7; unsigned long long v2:33; unsigned short v3:8; };
struct BFu7i_BFu33_BFu9i { unsigned int v1:7; unsigned long long v2:33; unsigned int v3:9; };
struct BFu7i_BFu33_BFu9ll { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3:9; };
struct BFu7i_BFu33_BFu9s { unsigned int v1:7; unsigned long long v2:33; unsigned short v3:9; };
struct BFu7i_BFu33_C { unsigned int v1:7; unsigned long long v2:33; char v3; };
struct BFu7i_BFu33_D { unsigned int v1:7; unsigned long long v2:33; double v3; };
struct BFu7i_BFu33_F { unsigned int v1:7; unsigned long long v2:33; float v3; };
struct BFu7i_BFu33_I { unsigned int v1:7; unsigned long long v2:33; int v3; };
struct BFu7i_BFu33_Ip { unsigned int v1:7; unsigned long long v2:33; int * v3; };
struct BFu7i_BFu33_L { unsigned int v1:7; unsigned long long v2:33; long long v3; };
struct BFu7i_BFu33_S { unsigned int v1:7; unsigned long long v2:33; short v3; };
struct BFu7i_BFu33_Uc { unsigned int v1:7; unsigned long long v2:33; unsigned char v3; };
struct BFu7i_BFu33_Ui { unsigned int v1:7; unsigned long long v2:33; unsigned int v3; };
struct BFu7i_BFu33_Ul { unsigned int v1:7; unsigned long long v2:33; unsigned long long v3; };
struct BFu7i_BFu33_Us { unsigned int v1:7; unsigned long long v2:33; unsigned short v3; };
struct BFu7i_BFu33_Vp { unsigned int v1:7; unsigned long long v2:33; void * v3; };
struct BFu7i_BFu7c { unsigned int v1:7; unsigned char v2:7; };
struct BFu7i_BFu7c_BFs7c { unsigned int v1:7; unsigned char v2:7; signed char v3:7; };
struct BFu7i_BFu7c_BFs7c_BFs7c { unsigned int v1:7; unsigned char v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFs7c_BFs7i { unsigned int v1:7; unsigned char v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFs7c_BFs7ll { unsigned int v1:7; unsigned char v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFs7c_BFs7s { unsigned int v1:7; unsigned char v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFs7c_BFu7c { unsigned int v1:7; unsigned char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFs7c_BFu7i { unsigned int v1:7; unsigned char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFs7c_BFu7ll { unsigned int v1:7; unsigned char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFs7c_BFu7s { unsigned int v1:7; unsigned char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFs7i { unsigned int v1:7; unsigned char v2:7; signed int v3:7; };
struct BFu7i_BFu7c_BFs7i_BFs7c { unsigned int v1:7; unsigned char v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFs7i_BFs7i { unsigned int v1:7; unsigned char v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFs7i_BFs7ll { unsigned int v1:7; unsigned char v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFs7i_BFs7s { unsigned int v1:7; unsigned char v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFs7i_BFu7c { unsigned int v1:7; unsigned char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFs7i_BFu7i { unsigned int v1:7; unsigned char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFs7i_BFu7ll { unsigned int v1:7; unsigned char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFs7i_BFu7s { unsigned int v1:7; unsigned char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFs7ll { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; };
struct BFu7i_BFu7c_BFs7ll_BFs7c { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFs7i { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFs7ll { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFs7s { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFu7c { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFu7i { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFu7ll { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFs7ll_BFu7s { unsigned int v1:7; unsigned char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFs7s { unsigned int v1:7; unsigned char v2:7; signed short v3:7; };
struct BFu7i_BFu7c_BFs7s_BFs7c { unsigned int v1:7; unsigned char v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFs7s_BFs7i { unsigned int v1:7; unsigned char v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFs7s_BFs7ll { unsigned int v1:7; unsigned char v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFs7s_BFs7s { unsigned int v1:7; unsigned char v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFs7s_BFu7c { unsigned int v1:7; unsigned char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFs7s_BFu7i { unsigned int v1:7; unsigned char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFs7s_BFu7ll { unsigned int v1:7; unsigned char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFs7s_BFu7s { unsigned int v1:7; unsigned char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFu15i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:15; };
struct BFu7i_BFu7c_BFu15ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:15; };
struct BFu7i_BFu7c_BFu15s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:15; };
struct BFu7i_BFu7c_BFu16i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:16; };
struct BFu7i_BFu7c_BFu16ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:16; };
struct BFu7i_BFu7c_BFu16s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:16; };
struct BFu7i_BFu7c_BFu17i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:17; };
struct BFu7i_BFu7c_BFu17ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:17; };
struct BFu7i_BFu7c_BFu1c { unsigned int v1:7; unsigned char v2:7; unsigned char v3:1; };
struct BFu7i_BFu7c_BFu1i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:1; };
struct BFu7i_BFu7c_BFu1ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:1; };
struct BFu7i_BFu7c_BFu1s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:1; };
struct BFu7i_BFu7c_BFu31i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:31; };
struct BFu7i_BFu7c_BFu31ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:31; };
struct BFu7i_BFu7c_BFu32i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:32; };
struct BFu7i_BFu7c_BFu32ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:32; };
struct BFu7i_BFu7c_BFu33 { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:33; };
struct BFu7i_BFu7c_BFu7c { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; };
struct BFu7i_BFu7c_BFu7c_BFs7c { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFu7c_BFs7i { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFu7c_BFs7ll { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFu7c_BFs7s { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFu7c_BFu7c { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFu7c_BFu7i { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFu7c_BFu7ll { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFu7c_BFu7s { unsigned int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFu7i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; };
struct BFu7i_BFu7c_BFu7i_BFs7c { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFu7i_BFs7i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFu7i_BFs7ll { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFu7i_BFs7s { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFu7i_BFu7c { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFu7i_BFu7i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFu7i_BFu7ll { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFu7i_BFu7s { unsigned int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFu7ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; };
struct BFu7i_BFu7c_BFu7ll_BFs7c { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFs7i { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFs7ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFs7s { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFu7c { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFu7i { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFu7ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFu7ll_BFu7s { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFu7s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; };
struct BFu7i_BFu7c_BFu7s_BFs7c { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFu7c_BFu7s_BFs7i { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFu7c_BFu7s_BFs7ll { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFu7c_BFu7s_BFs7s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFu7c_BFu7s_BFu7c { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7c_BFu7s_BFu7i { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7c_BFu7s_BFu7ll { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7c_BFu7s_BFu7s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7c_BFu8c { unsigned int v1:7; unsigned char v2:7; unsigned char v3:8; };
struct BFu7i_BFu7c_BFu8i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:8; };
struct BFu7i_BFu7c_BFu8ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:8; };
struct BFu7i_BFu7c_BFu8s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:8; };
struct BFu7i_BFu7c_BFu9i { unsigned int v1:7; unsigned char v2:7; unsigned int v3:9; };
struct BFu7i_BFu7c_BFu9ll { unsigned int v1:7; unsigned char v2:7; unsigned long long v3:9; };
struct BFu7i_BFu7c_BFu9s { unsigned int v1:7; unsigned char v2:7; unsigned short v3:9; };
struct BFu7i_BFu7c_C { unsigned int v1:7; unsigned char v2:7; char v3; };
struct BFu7i_BFu7c_D { unsigned int v1:7; unsigned char v2:7; double v3; };
struct BFu7i_BFu7c_F { unsigned int v1:7; unsigned char v2:7; float v3; };
struct BFu7i_BFu7c_I { unsigned int v1:7; unsigned char v2:7; int v3; };
struct BFu7i_BFu7c_Ip { unsigned int v1:7; unsigned char v2:7; int * v3; };
struct BFu7i_BFu7c_L { unsigned int v1:7; unsigned char v2:7; long long v3; };
struct BFu7i_BFu7c_S { unsigned int v1:7; unsigned char v2:7; short v3; };
struct BFu7i_BFu7c_Uc { unsigned int v1:7; unsigned char v2:7; unsigned char v3; };
struct BFu7i_BFu7c_Ui { unsigned int v1:7; unsigned char v2:7; unsigned int v3; };
struct BFu7i_BFu7c_Ul { unsigned int v1:7; unsigned char v2:7; unsigned long long v3; };
struct BFu7i_BFu7c_Us { unsigned int v1:7; unsigned char v2:7; unsigned short v3; };
struct BFu7i_BFu7c_Vp { unsigned int v1:7; unsigned char v2:7; void * v3; };
struct BFu7i_BFu7i { unsigned int v1:7; unsigned int v2:7; };
struct BFu7i_BFu7i_BFs7c { unsigned int v1:7; unsigned int v2:7; signed char v3:7; };
struct BFu7i_BFu7i_BFs7c_BFs7c { unsigned int v1:7; unsigned int v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFs7c_BFs7i { unsigned int v1:7; unsigned int v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFs7c_BFs7ll { unsigned int v1:7; unsigned int v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFs7c_BFs7s { unsigned int v1:7; unsigned int v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFs7c_BFu7c { unsigned int v1:7; unsigned int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFs7c_BFu7i { unsigned int v1:7; unsigned int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFs7c_BFu7ll { unsigned int v1:7; unsigned int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFs7c_BFu7s { unsigned int v1:7; unsigned int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFs7i { unsigned int v1:7; unsigned int v2:7; signed int v3:7; };
struct BFu7i_BFu7i_BFs7i_BFs7c { unsigned int v1:7; unsigned int v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFs7i_BFs7i { unsigned int v1:7; unsigned int v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFs7i_BFs7ll { unsigned int v1:7; unsigned int v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFs7i_BFs7s { unsigned int v1:7; unsigned int v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFs7i_BFu7c { unsigned int v1:7; unsigned int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFs7i_BFu7i { unsigned int v1:7; unsigned int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFs7i_BFu7ll { unsigned int v1:7; unsigned int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFs7i_BFu7s { unsigned int v1:7; unsigned int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFs7ll { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; };
struct BFu7i_BFu7i_BFs7ll_BFs7c { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFs7i { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFs7ll { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFs7s { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFu7c { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFu7i { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFu7ll { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFs7ll_BFu7s { unsigned int v1:7; unsigned int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFs7s { unsigned int v1:7; unsigned int v2:7; signed short v3:7; };
struct BFu7i_BFu7i_BFs7s_BFs7c { unsigned int v1:7; unsigned int v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFs7s_BFs7i { unsigned int v1:7; unsigned int v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFs7s_BFs7ll { unsigned int v1:7; unsigned int v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFs7s_BFs7s { unsigned int v1:7; unsigned int v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFs7s_BFu7c { unsigned int v1:7; unsigned int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFs7s_BFu7i { unsigned int v1:7; unsigned int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFs7s_BFu7ll { unsigned int v1:7; unsigned int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFs7s_BFu7s { unsigned int v1:7; unsigned int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFu15i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:15; };
struct BFu7i_BFu7i_BFu15ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:15; };
struct BFu7i_BFu7i_BFu15s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:15; };
struct BFu7i_BFu7i_BFu16i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:16; };
struct BFu7i_BFu7i_BFu16ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:16; };
struct BFu7i_BFu7i_BFu16s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:16; };
struct BFu7i_BFu7i_BFu17i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:17; };
struct BFu7i_BFu7i_BFu17ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:17; };
struct BFu7i_BFu7i_BFu1c { unsigned int v1:7; unsigned int v2:7; unsigned char v3:1; };
struct BFu7i_BFu7i_BFu1i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:1; };
struct BFu7i_BFu7i_BFu1ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:1; };
struct BFu7i_BFu7i_BFu1s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:1; };
struct BFu7i_BFu7i_BFu31i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:31; };
struct BFu7i_BFu7i_BFu31ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:31; };
struct BFu7i_BFu7i_BFu32i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:32; };
struct BFu7i_BFu7i_BFu32ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:32; };
struct BFu7i_BFu7i_BFu33 { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:33; };
struct BFu7i_BFu7i_BFu7c { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; };
struct BFu7i_BFu7i_BFu7c_BFs7c { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFu7c_BFs7i { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFu7c_BFs7ll { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFu7c_BFs7s { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFu7c_BFu7c { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFu7c_BFu7i { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFu7c_BFu7ll { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFu7c_BFu7s { unsigned int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFu7i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; };
struct BFu7i_BFu7i_BFu7i_BFs7c { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFu7i_BFs7i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFu7i_BFs7ll { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFu7i_BFs7s { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFu7i_BFu7c { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFu7i_BFu7i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFu7i_BFu7ll { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFu7i_BFu7s { unsigned int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFu7ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; };
struct BFu7i_BFu7i_BFu7ll_BFs7c { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFs7i { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFs7ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFs7s { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFu7c { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFu7i { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFu7ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFu7ll_BFu7s { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFu7s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; };
struct BFu7i_BFu7i_BFu7s_BFs7c { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFu7i_BFu7s_BFs7i { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFu7i_BFu7s_BFs7ll { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFu7i_BFu7s_BFs7s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFu7i_BFu7s_BFu7c { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7i_BFu7s_BFu7i { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7i_BFu7s_BFu7ll { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7i_BFu7s_BFu7s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7i_BFu8c { unsigned int v1:7; unsigned int v2:7; unsigned char v3:8; };
struct BFu7i_BFu7i_BFu8i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:8; };
struct BFu7i_BFu7i_BFu8ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:8; };
struct BFu7i_BFu7i_BFu8s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:8; };
struct BFu7i_BFu7i_BFu9i { unsigned int v1:7; unsigned int v2:7; unsigned int v3:9; };
struct BFu7i_BFu7i_BFu9ll { unsigned int v1:7; unsigned int v2:7; unsigned long long v3:9; };
struct BFu7i_BFu7i_BFu9s { unsigned int v1:7; unsigned int v2:7; unsigned short v3:9; };
struct BFu7i_BFu7i_C { unsigned int v1:7; unsigned int v2:7; char v3; };
struct BFu7i_BFu7i_D { unsigned int v1:7; unsigned int v2:7; double v3; };
struct BFu7i_BFu7i_F { unsigned int v1:7; unsigned int v2:7; float v3; };
struct BFu7i_BFu7i_I { unsigned int v1:7; unsigned int v2:7; int v3; };
struct BFu7i_BFu7i_Ip { unsigned int v1:7; unsigned int v2:7; int * v3; };
struct BFu7i_BFu7i_L { unsigned int v1:7; unsigned int v2:7; long long v3; };
struct BFu7i_BFu7i_S { unsigned int v1:7; unsigned int v2:7; short v3; };
struct BFu7i_BFu7i_Uc { unsigned int v1:7; unsigned int v2:7; unsigned char v3; };
struct BFu7i_BFu7i_Ui { unsigned int v1:7; unsigned int v2:7; unsigned int v3; };
struct BFu7i_BFu7i_Ul { unsigned int v1:7; unsigned int v2:7; unsigned long long v3; };
struct BFu7i_BFu7i_Us { unsigned int v1:7; unsigned int v2:7; unsigned short v3; };
struct BFu7i_BFu7i_Vp { unsigned int v1:7; unsigned int v2:7; void * v3; };
struct BFu7i_BFu7ll { unsigned int v1:7; unsigned long long v2:7; };
struct BFu7i_BFu7ll_BFs7c { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; };
struct BFu7i_BFu7ll_BFs7c_BFs7c { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFs7i { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFs7ll { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFs7s { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFu7c { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFu7i { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFu7ll { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFs7c_BFu7s { unsigned int v1:7; unsigned long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFs7i { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; };
struct BFu7i_BFu7ll_BFs7i_BFs7c { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFs7i { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFs7ll { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFs7s { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFu7c { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFu7i { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFu7ll { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFs7i_BFu7s { unsigned int v1:7; unsigned long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFs7ll { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; };
struct BFu7i_BFu7ll_BFs7ll_BFs7c { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFs7i { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFs7ll { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFs7s { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFu7c { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFu7i { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFu7ll { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFs7ll_BFu7s { unsigned int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFs7s { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; };
struct BFu7i_BFu7ll_BFs7s_BFs7c { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFs7i { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFs7ll { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFs7s { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFu7c { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFu7i { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFu7ll { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFs7s_BFu7s { unsigned int v1:7; unsigned long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFu15i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:15; };
struct BFu7i_BFu7ll_BFu15ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:15; };
struct BFu7i_BFu7ll_BFu15s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:15; };
struct BFu7i_BFu7ll_BFu16i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:16; };
struct BFu7i_BFu7ll_BFu16ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:16; };
struct BFu7i_BFu7ll_BFu16s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:16; };
struct BFu7i_BFu7ll_BFu17i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:17; };
struct BFu7i_BFu7ll_BFu17ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:17; };
struct BFu7i_BFu7ll_BFu1c { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:1; };
struct BFu7i_BFu7ll_BFu1i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:1; };
struct BFu7i_BFu7ll_BFu1ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:1; };
struct BFu7i_BFu7ll_BFu1s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:1; };
struct BFu7i_BFu7ll_BFu31i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:31; };
struct BFu7i_BFu7ll_BFu31ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:31; };
struct BFu7i_BFu7ll_BFu32i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:32; };
struct BFu7i_BFu7ll_BFu32ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:32; };
struct BFu7i_BFu7ll_BFu33 { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:33; };
struct BFu7i_BFu7ll_BFu7c { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; };
struct BFu7i_BFu7ll_BFu7c_BFs7c { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFs7i { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFs7ll { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFs7s { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFu7c { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFu7i { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFu7ll { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFu7c_BFu7s { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFu7i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; };
struct BFu7i_BFu7ll_BFu7i_BFs7c { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFs7i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFs7ll { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFs7s { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFu7c { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFu7i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFu7ll { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFu7i_BFu7s { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFu7ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; };
struct BFu7i_BFu7ll_BFu7ll_BFs7c { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFs7i { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFs7ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFs7s { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFu7c { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFu7i { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFu7ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFu7ll_BFu7s { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFu7s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; };
struct BFu7i_BFu7ll_BFu7s_BFs7c { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFs7i { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFs7ll { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFs7s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFu7c { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFu7i { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFu7ll { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7ll_BFu7s_BFu7s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7ll_BFu8c { unsigned int v1:7; unsigned long long v2:7; unsigned char v3:8; };
struct BFu7i_BFu7ll_BFu8i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:8; };
struct BFu7i_BFu7ll_BFu8ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:8; };
struct BFu7i_BFu7ll_BFu8s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:8; };
struct BFu7i_BFu7ll_BFu9i { unsigned int v1:7; unsigned long long v2:7; unsigned int v3:9; };
struct BFu7i_BFu7ll_BFu9ll { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3:9; };
struct BFu7i_BFu7ll_BFu9s { unsigned int v1:7; unsigned long long v2:7; unsigned short v3:9; };
struct BFu7i_BFu7ll_C { unsigned int v1:7; unsigned long long v2:7; char v3; };
struct BFu7i_BFu7ll_D { unsigned int v1:7; unsigned long long v2:7; double v3; };
struct BFu7i_BFu7ll_F { unsigned int v1:7; unsigned long long v2:7; float v3; };
struct BFu7i_BFu7ll_I { unsigned int v1:7; unsigned long long v2:7; int v3; };
struct BFu7i_BFu7ll_Ip { unsigned int v1:7; unsigned long long v2:7; int * v3; };
struct BFu7i_BFu7ll_L { unsigned int v1:7; unsigned long long v2:7; long long v3; };
struct BFu7i_BFu7ll_S { unsigned int v1:7; unsigned long long v2:7; short v3; };
struct BFu7i_BFu7ll_Uc { unsigned int v1:7; unsigned long long v2:7; unsigned char v3; };
struct BFu7i_BFu7ll_Ui { unsigned int v1:7; unsigned long long v2:7; unsigned int v3; };
struct BFu7i_BFu7ll_Ul { unsigned int v1:7; unsigned long long v2:7; unsigned long long v3; };
struct BFu7i_BFu7ll_Us { unsigned int v1:7; unsigned long long v2:7; unsigned short v3; };
struct BFu7i_BFu7ll_Vp { unsigned int v1:7; unsigned long long v2:7; void * v3; };
struct BFu7i_BFu7s { unsigned int v1:7; unsigned short v2:7; };
struct BFu7i_BFu7s_BFs7c { unsigned int v1:7; unsigned short v2:7; signed char v3:7; };
struct BFu7i_BFu7s_BFs7c_BFs7c { unsigned int v1:7; unsigned short v2:7; signed char v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFs7c_BFs7i { unsigned int v1:7; unsigned short v2:7; signed char v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFs7c_BFs7ll { unsigned int v1:7; unsigned short v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFs7c_BFs7s { unsigned int v1:7; unsigned short v2:7; signed char v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFs7c_BFu7c { unsigned int v1:7; unsigned short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFs7c_BFu7i { unsigned int v1:7; unsigned short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFs7c_BFu7ll { unsigned int v1:7; unsigned short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFs7c_BFu7s { unsigned int v1:7; unsigned short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFs7i { unsigned int v1:7; unsigned short v2:7; signed int v3:7; };
struct BFu7i_BFu7s_BFs7i_BFs7c { unsigned int v1:7; unsigned short v2:7; signed int v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFs7i_BFs7i { unsigned int v1:7; unsigned short v2:7; signed int v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFs7i_BFs7ll { unsigned int v1:7; unsigned short v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFs7i_BFs7s { unsigned int v1:7; unsigned short v2:7; signed int v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFs7i_BFu7c { unsigned int v1:7; unsigned short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFs7i_BFu7i { unsigned int v1:7; unsigned short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFs7i_BFu7ll { unsigned int v1:7; unsigned short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFs7i_BFu7s { unsigned int v1:7; unsigned short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFs7ll { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; };
struct BFu7i_BFu7s_BFs7ll_BFs7c { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFs7i { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFs7ll { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFs7s { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFu7c { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFu7i { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFu7ll { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFs7ll_BFu7s { unsigned int v1:7; unsigned short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFs7s { unsigned int v1:7; unsigned short v2:7; signed short v3:7; };
struct BFu7i_BFu7s_BFs7s_BFs7c { unsigned int v1:7; unsigned short v2:7; signed short v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFs7s_BFs7i { unsigned int v1:7; unsigned short v2:7; signed short v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFs7s_BFs7ll { unsigned int v1:7; unsigned short v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFs7s_BFs7s { unsigned int v1:7; unsigned short v2:7; signed short v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFs7s_BFu7c { unsigned int v1:7; unsigned short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFs7s_BFu7i { unsigned int v1:7; unsigned short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFs7s_BFu7ll { unsigned int v1:7; unsigned short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFs7s_BFu7s { unsigned int v1:7; unsigned short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFu15i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:15; };
struct BFu7i_BFu7s_BFu15ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:15; };
struct BFu7i_BFu7s_BFu15s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:15; };
struct BFu7i_BFu7s_BFu16i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:16; };
struct BFu7i_BFu7s_BFu16ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:16; };
struct BFu7i_BFu7s_BFu16s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:16; };
struct BFu7i_BFu7s_BFu17i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:17; };
struct BFu7i_BFu7s_BFu17ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:17; };
struct BFu7i_BFu7s_BFu1c { unsigned int v1:7; unsigned short v2:7; unsigned char v3:1; };
struct BFu7i_BFu7s_BFu1i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:1; };
struct BFu7i_BFu7s_BFu1ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:1; };
struct BFu7i_BFu7s_BFu1s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:1; };
struct BFu7i_BFu7s_BFu31i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:31; };
struct BFu7i_BFu7s_BFu31ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:31; };
struct BFu7i_BFu7s_BFu32i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:32; };
struct BFu7i_BFu7s_BFu32ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:32; };
struct BFu7i_BFu7s_BFu33 { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:33; };
struct BFu7i_BFu7s_BFu7c { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; };
struct BFu7i_BFu7s_BFu7c_BFs7c { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFu7c_BFs7i { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFu7c_BFs7ll { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFu7c_BFs7s { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFu7c_BFu7c { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFu7c_BFu7i { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFu7c_BFu7ll { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFu7c_BFu7s { unsigned int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFu7i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; };
struct BFu7i_BFu7s_BFu7i_BFs7c { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFu7i_BFs7i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFu7i_BFs7ll { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFu7i_BFs7s { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFu7i_BFu7c { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFu7i_BFu7i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFu7i_BFu7ll { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFu7i_BFu7s { unsigned int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFu7ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; };
struct BFu7i_BFu7s_BFu7ll_BFs7c { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFs7i { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFs7ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFs7s { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFu7c { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFu7i { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFu7ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFu7ll_BFu7s { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFu7s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; };
struct BFu7i_BFu7s_BFu7s_BFs7c { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7i_BFu7s_BFu7s_BFs7i { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7i_BFu7s_BFu7s_BFs7ll { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7i_BFu7s_BFu7s_BFs7s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7i_BFu7s_BFu7s_BFu7c { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7i_BFu7s_BFu7s_BFu7i { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7i_BFu7s_BFu7s_BFu7ll { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7i_BFu7s_BFu7s_BFu7s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7i_BFu7s_BFu8c { unsigned int v1:7; unsigned short v2:7; unsigned char v3:8; };
struct BFu7i_BFu7s_BFu8i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:8; };
struct BFu7i_BFu7s_BFu8ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:8; };
struct BFu7i_BFu7s_BFu8s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:8; };
struct BFu7i_BFu7s_BFu9i { unsigned int v1:7; unsigned short v2:7; unsigned int v3:9; };
struct BFu7i_BFu7s_BFu9ll { unsigned int v1:7; unsigned short v2:7; unsigned long long v3:9; };
struct BFu7i_BFu7s_BFu9s { unsigned int v1:7; unsigned short v2:7; unsigned short v3:9; };
struct BFu7i_BFu7s_C { unsigned int v1:7; unsigned short v2:7; char v3; };
struct BFu7i_BFu7s_D { unsigned int v1:7; unsigned short v2:7; double v3; };
struct BFu7i_BFu7s_F { unsigned int v1:7; unsigned short v2:7; float v3; };
struct BFu7i_BFu7s_I { unsigned int v1:7; unsigned short v2:7; int v3; };
struct BFu7i_BFu7s_Ip { unsigned int v1:7; unsigned short v2:7; int * v3; };
struct BFu7i_BFu7s_L { unsigned int v1:7; unsigned short v2:7; long long v3; };
struct BFu7i_BFu7s_S { unsigned int v1:7; unsigned short v2:7; short v3; };
struct BFu7i_BFu7s_Uc { unsigned int v1:7; unsigned short v2:7; unsigned char v3; };
struct BFu7i_BFu7s_Ui { unsigned int v1:7; unsigned short v2:7; unsigned int v3; };
struct BFu7i_BFu7s_Ul { unsigned int v1:7; unsigned short v2:7; unsigned long long v3; };
struct BFu7i_BFu7s_Us { unsigned int v1:7; unsigned short v2:7; unsigned short v3; };
struct BFu7i_BFu7s_Vp { unsigned int v1:7; unsigned short v2:7; void * v3; };
struct BFu7i_BFu8c { unsigned int v1:7; unsigned char v2:8; };
struct BFu7i_BFu8c_BFu15i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:15; };
struct BFu7i_BFu8c_BFu15ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:15; };
struct BFu7i_BFu8c_BFu15s { unsigned int v1:7; unsigned char v2:8; unsigned short v3:15; };
struct BFu7i_BFu8c_BFu16i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:16; };
struct BFu7i_BFu8c_BFu16ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:16; };
struct BFu7i_BFu8c_BFu16s { unsigned int v1:7; unsigned char v2:8; unsigned short v3:16; };
struct BFu7i_BFu8c_BFu17i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:17; };
struct BFu7i_BFu8c_BFu17ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:17; };
struct BFu7i_BFu8c_BFu1c { unsigned int v1:7; unsigned char v2:8; unsigned char v3:1; };
struct BFu7i_BFu8c_BFu1i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:1; };
struct BFu7i_BFu8c_BFu1ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:1; };
struct BFu7i_BFu8c_BFu1s { unsigned int v1:7; unsigned char v2:8; unsigned short v3:1; };
struct BFu7i_BFu8c_BFu31i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:31; };
struct BFu7i_BFu8c_BFu31ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:31; };
struct BFu7i_BFu8c_BFu32i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:32; };
struct BFu7i_BFu8c_BFu32ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:32; };
struct BFu7i_BFu8c_BFu33 { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:33; };
struct BFu7i_BFu8c_BFu7c { unsigned int v1:7; unsigned char v2:8; unsigned char v3:7; };
struct BFu7i_BFu8c_BFu7i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:7; };
struct BFu7i_BFu8c_BFu7ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:7; };
struct BFu7i_BFu8c_BFu7s { unsigned int v1:7; unsigned char v2:8; unsigned short v3:7; };
struct BFu7i_BFu8c_BFu8c { unsigned int v1:7; unsigned char v2:8; unsigned char v3:8; };
struct BFu7i_BFu8c_BFu8i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:8; };
struct BFu7i_BFu8c_BFu8ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:8; };
struct BFu7i_BFu8c_BFu8s { unsigned int v1:7; unsigned char v2:8; unsigned short v3:8; };
struct BFu7i_BFu8c_BFu9i { unsigned int v1:7; unsigned char v2:8; unsigned int v3:9; };
struct BFu7i_BFu8c_BFu9ll { unsigned int v1:7; unsigned char v2:8; unsigned long long v3:9; };
struct BFu7i_BFu8c_BFu9s { unsigned int v1:7; unsigned char v2:8; unsigned short v3:9; };
struct BFu7i_BFu8c_C { unsigned int v1:7; unsigned char v2:8; char v3; };
struct BFu7i_BFu8c_D { unsigned int v1:7; unsigned char v2:8; double v3; };
struct BFu7i_BFu8c_F { unsigned int v1:7; unsigned char v2:8; float v3; };
struct BFu7i_BFu8c_I { unsigned int v1:7; unsigned char v2:8; int v3; };
struct BFu7i_BFu8c_Ip { unsigned int v1:7; unsigned char v2:8; int * v3; };
struct BFu7i_BFu8c_L { unsigned int v1:7; unsigned char v2:8; long long v3; };
struct BFu7i_BFu8c_S { unsigned int v1:7; unsigned char v2:8; short v3; };
struct BFu7i_BFu8c_Uc { unsigned int v1:7; unsigned char v2:8; unsigned char v3; };
struct BFu7i_BFu8c_Ui { unsigned int v1:7; unsigned char v2:8; unsigned int v3; };
struct BFu7i_BFu8c_Ul { unsigned int v1:7; unsigned char v2:8; unsigned long long v3; };
struct BFu7i_BFu8c_Us { unsigned int v1:7; unsigned char v2:8; unsigned short v3; };
struct BFu7i_BFu8c_Vp { unsigned int v1:7; unsigned char v2:8; void * v3; };
struct BFu7i_BFu8i { unsigned int v1:7; unsigned int v2:8; };
struct BFu7i_BFu8i_BFu15i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:15; };
struct BFu7i_BFu8i_BFu15ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:15; };
struct BFu7i_BFu8i_BFu15s { unsigned int v1:7; unsigned int v2:8; unsigned short v3:15; };
struct BFu7i_BFu8i_BFu16i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:16; };
struct BFu7i_BFu8i_BFu16ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:16; };
struct BFu7i_BFu8i_BFu16s { unsigned int v1:7; unsigned int v2:8; unsigned short v3:16; };
struct BFu7i_BFu8i_BFu17i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:17; };
struct BFu7i_BFu8i_BFu17ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:17; };
struct BFu7i_BFu8i_BFu1c { unsigned int v1:7; unsigned int v2:8; unsigned char v3:1; };
struct BFu7i_BFu8i_BFu1i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:1; };
struct BFu7i_BFu8i_BFu1ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:1; };
struct BFu7i_BFu8i_BFu1s { unsigned int v1:7; unsigned int v2:8; unsigned short v3:1; };
struct BFu7i_BFu8i_BFu31i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:31; };
struct BFu7i_BFu8i_BFu31ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:31; };
struct BFu7i_BFu8i_BFu32i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:32; };
struct BFu7i_BFu8i_BFu32ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:32; };
struct BFu7i_BFu8i_BFu33 { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:33; };
struct BFu7i_BFu8i_BFu7c { unsigned int v1:7; unsigned int v2:8; unsigned char v3:7; };
struct BFu7i_BFu8i_BFu7i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:7; };
struct BFu7i_BFu8i_BFu7ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:7; };
struct BFu7i_BFu8i_BFu7s { unsigned int v1:7; unsigned int v2:8; unsigned short v3:7; };
struct BFu7i_BFu8i_BFu8c { unsigned int v1:7; unsigned int v2:8; unsigned char v3:8; };
struct BFu7i_BFu8i_BFu8i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:8; };
struct BFu7i_BFu8i_BFu8ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:8; };
struct BFu7i_BFu8i_BFu8s { unsigned int v1:7; unsigned int v2:8; unsigned short v3:8; };
struct BFu7i_BFu8i_BFu9i { unsigned int v1:7; unsigned int v2:8; unsigned int v3:9; };
struct BFu7i_BFu8i_BFu9ll { unsigned int v1:7; unsigned int v2:8; unsigned long long v3:9; };
struct BFu7i_BFu8i_BFu9s { unsigned int v1:7; unsigned int v2:8; unsigned short v3:9; };
struct BFu7i_BFu8i_C { unsigned int v1:7; unsigned int v2:8; char v3; };
struct BFu7i_BFu8i_D { unsigned int v1:7; unsigned int v2:8; double v3; };
struct BFu7i_BFu8i_F { unsigned int v1:7; unsigned int v2:8; float v3; };
struct BFu7i_BFu8i_I { unsigned int v1:7; unsigned int v2:8; int v3; };
struct BFu7i_BFu8i_Ip { unsigned int v1:7; unsigned int v2:8; int * v3; };
struct BFu7i_BFu8i_L { unsigned int v1:7; unsigned int v2:8; long long v3; };
struct BFu7i_BFu8i_S { unsigned int v1:7; unsigned int v2:8; short v3; };
struct BFu7i_BFu8i_Uc { unsigned int v1:7; unsigned int v2:8; unsigned char v3; };
struct BFu7i_BFu8i_Ui { unsigned int v1:7; unsigned int v2:8; unsigned int v3; };
struct BFu7i_BFu8i_Ul { unsigned int v1:7; unsigned int v2:8; unsigned long long v3; };
struct BFu7i_BFu8i_Us { unsigned int v1:7; unsigned int v2:8; unsigned short v3; };
struct BFu7i_BFu8i_Vp { unsigned int v1:7; unsigned int v2:8; void * v3; };
struct BFu7i_BFu8ll { unsigned int v1:7; unsigned long long v2:8; };
struct BFu7i_BFu8ll_BFu15i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:15; };
struct BFu7i_BFu8ll_BFu15ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:15; };
struct BFu7i_BFu8ll_BFu15s { unsigned int v1:7; unsigned long long v2:8; unsigned short v3:15; };
struct BFu7i_BFu8ll_BFu16i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:16; };
struct BFu7i_BFu8ll_BFu16ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:16; };
struct BFu7i_BFu8ll_BFu16s { unsigned int v1:7; unsigned long long v2:8; unsigned short v3:16; };
struct BFu7i_BFu8ll_BFu17i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:17; };
struct BFu7i_BFu8ll_BFu17ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:17; };
struct BFu7i_BFu8ll_BFu1c { unsigned int v1:7; unsigned long long v2:8; unsigned char v3:1; };
struct BFu7i_BFu8ll_BFu1i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:1; };
struct BFu7i_BFu8ll_BFu1ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:1; };
struct BFu7i_BFu8ll_BFu1s { unsigned int v1:7; unsigned long long v2:8; unsigned short v3:1; };
struct BFu7i_BFu8ll_BFu31i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:31; };
struct BFu7i_BFu8ll_BFu31ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:31; };
struct BFu7i_BFu8ll_BFu32i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:32; };
struct BFu7i_BFu8ll_BFu32ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:32; };
struct BFu7i_BFu8ll_BFu33 { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:33; };
struct BFu7i_BFu8ll_BFu7c { unsigned int v1:7; unsigned long long v2:8; unsigned char v3:7; };
struct BFu7i_BFu8ll_BFu7i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:7; };
struct BFu7i_BFu8ll_BFu7ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:7; };
struct BFu7i_BFu8ll_BFu7s { unsigned int v1:7; unsigned long long v2:8; unsigned short v3:7; };
struct BFu7i_BFu8ll_BFu8c { unsigned int v1:7; unsigned long long v2:8; unsigned char v3:8; };
struct BFu7i_BFu8ll_BFu8i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:8; };
struct BFu7i_BFu8ll_BFu8ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:8; };
struct BFu7i_BFu8ll_BFu8s { unsigned int v1:7; unsigned long long v2:8; unsigned short v3:8; };
struct BFu7i_BFu8ll_BFu9i { unsigned int v1:7; unsigned long long v2:8; unsigned int v3:9; };
struct BFu7i_BFu8ll_BFu9ll { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3:9; };
struct BFu7i_BFu8ll_BFu9s { unsigned int v1:7; unsigned long long v2:8; unsigned short v3:9; };
struct BFu7i_BFu8ll_C { unsigned int v1:7; unsigned long long v2:8; char v3; };
struct BFu7i_BFu8ll_D { unsigned int v1:7; unsigned long long v2:8; double v3; };
struct BFu7i_BFu8ll_F { unsigned int v1:7; unsigned long long v2:8; float v3; };
struct BFu7i_BFu8ll_I { unsigned int v1:7; unsigned long long v2:8; int v3; };
struct BFu7i_BFu8ll_Ip { unsigned int v1:7; unsigned long long v2:8; int * v3; };
struct BFu7i_BFu8ll_L { unsigned int v1:7; unsigned long long v2:8; long long v3; };
struct BFu7i_BFu8ll_S { unsigned int v1:7; unsigned long long v2:8; short v3; };
struct BFu7i_BFu8ll_Uc { unsigned int v1:7; unsigned long long v2:8; unsigned char v3; };
struct BFu7i_BFu8ll_Ui { unsigned int v1:7; unsigned long long v2:8; unsigned int v3; };
struct BFu7i_BFu8ll_Ul { unsigned int v1:7; unsigned long long v2:8; unsigned long long v3; };
struct BFu7i_BFu8ll_Us { unsigned int v1:7; unsigned long long v2:8; unsigned short v3; };
struct BFu7i_BFu8ll_Vp { unsigned int v1:7; unsigned long long v2:8; void * v3; };
struct BFu7i_BFu8s { unsigned int v1:7; unsigned short v2:8; };
struct BFu7i_BFu8s_BFu15i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:15; };
struct BFu7i_BFu8s_BFu15ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:15; };
struct BFu7i_BFu8s_BFu15s { unsigned int v1:7; unsigned short v2:8; unsigned short v3:15; };
struct BFu7i_BFu8s_BFu16i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:16; };
struct BFu7i_BFu8s_BFu16ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:16; };
struct BFu7i_BFu8s_BFu16s { unsigned int v1:7; unsigned short v2:8; unsigned short v3:16; };
struct BFu7i_BFu8s_BFu17i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:17; };
struct BFu7i_BFu8s_BFu17ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:17; };
struct BFu7i_BFu8s_BFu1c { unsigned int v1:7; unsigned short v2:8; unsigned char v3:1; };
struct BFu7i_BFu8s_BFu1i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:1; };
struct BFu7i_BFu8s_BFu1ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:1; };
struct BFu7i_BFu8s_BFu1s { unsigned int v1:7; unsigned short v2:8; unsigned short v3:1; };
struct BFu7i_BFu8s_BFu31i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:31; };
struct BFu7i_BFu8s_BFu31ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:31; };
struct BFu7i_BFu8s_BFu32i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:32; };
struct BFu7i_BFu8s_BFu32ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:32; };
struct BFu7i_BFu8s_BFu33 { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:33; };
struct BFu7i_BFu8s_BFu7c { unsigned int v1:7; unsigned short v2:8; unsigned char v3:7; };
struct BFu7i_BFu8s_BFu7i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:7; };
struct BFu7i_BFu8s_BFu7ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:7; };
struct BFu7i_BFu8s_BFu7s { unsigned int v1:7; unsigned short v2:8; unsigned short v3:7; };
struct BFu7i_BFu8s_BFu8c { unsigned int v1:7; unsigned short v2:8; unsigned char v3:8; };
struct BFu7i_BFu8s_BFu8i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:8; };
struct BFu7i_BFu8s_BFu8ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:8; };
struct BFu7i_BFu8s_BFu8s { unsigned int v1:7; unsigned short v2:8; unsigned short v3:8; };
struct BFu7i_BFu8s_BFu9i { unsigned int v1:7; unsigned short v2:8; unsigned int v3:9; };
struct BFu7i_BFu8s_BFu9ll { unsigned int v1:7; unsigned short v2:8; unsigned long long v3:9; };
struct BFu7i_BFu8s_BFu9s { unsigned int v1:7; unsigned short v2:8; unsigned short v3:9; };
struct BFu7i_BFu8s_C { unsigned int v1:7; unsigned short v2:8; char v3; };
struct BFu7i_BFu8s_D { unsigned int v1:7; unsigned short v2:8; double v3; };
struct BFu7i_BFu8s_F { unsigned int v1:7; unsigned short v2:8; float v3; };
struct BFu7i_BFu8s_I { unsigned int v1:7; unsigned short v2:8; int v3; };
struct BFu7i_BFu8s_Ip { unsigned int v1:7; unsigned short v2:8; int * v3; };
struct BFu7i_BFu8s_L { unsigned int v1:7; unsigned short v2:8; long long v3; };
struct BFu7i_BFu8s_S { unsigned int v1:7; unsigned short v2:8; short v3; };
struct BFu7i_BFu8s_Uc { unsigned int v1:7; unsigned short v2:8; unsigned char v3; };
struct BFu7i_BFu8s_Ui { unsigned int v1:7; unsigned short v2:8; unsigned int v3; };
struct BFu7i_BFu8s_Ul { unsigned int v1:7; unsigned short v2:8; unsigned long long v3; };
struct BFu7i_BFu8s_Us { unsigned int v1:7; unsigned short v2:8; unsigned short v3; };
struct BFu7i_BFu8s_Vp { unsigned int v1:7; unsigned short v2:8; void * v3; };
struct BFu7i_BFu9i { unsigned int v1:7; unsigned int v2:9; };
struct BFu7i_BFu9i_BFu15i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:15; };
struct BFu7i_BFu9i_BFu15ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:15; };
struct BFu7i_BFu9i_BFu15s { unsigned int v1:7; unsigned int v2:9; unsigned short v3:15; };
struct BFu7i_BFu9i_BFu16i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:16; };
struct BFu7i_BFu9i_BFu16ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:16; };
struct BFu7i_BFu9i_BFu16s { unsigned int v1:7; unsigned int v2:9; unsigned short v3:16; };
struct BFu7i_BFu9i_BFu17i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:17; };
struct BFu7i_BFu9i_BFu17ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:17; };
struct BFu7i_BFu9i_BFu1c { unsigned int v1:7; unsigned int v2:9; unsigned char v3:1; };
struct BFu7i_BFu9i_BFu1i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:1; };
struct BFu7i_BFu9i_BFu1ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:1; };
struct BFu7i_BFu9i_BFu1s { unsigned int v1:7; unsigned int v2:9; unsigned short v3:1; };
struct BFu7i_BFu9i_BFu31i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:31; };
struct BFu7i_BFu9i_BFu31ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:31; };
struct BFu7i_BFu9i_BFu32i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:32; };
struct BFu7i_BFu9i_BFu32ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:32; };
struct BFu7i_BFu9i_BFu33 { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:33; };
struct BFu7i_BFu9i_BFu7c { unsigned int v1:7; unsigned int v2:9; unsigned char v3:7; };
struct BFu7i_BFu9i_BFu7i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:7; };
struct BFu7i_BFu9i_BFu7ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:7; };
struct BFu7i_BFu9i_BFu7s { unsigned int v1:7; unsigned int v2:9; unsigned short v3:7; };
struct BFu7i_BFu9i_BFu8c { unsigned int v1:7; unsigned int v2:9; unsigned char v3:8; };
struct BFu7i_BFu9i_BFu8i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:8; };
struct BFu7i_BFu9i_BFu8ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:8; };
struct BFu7i_BFu9i_BFu8s { unsigned int v1:7; unsigned int v2:9; unsigned short v3:8; };
struct BFu7i_BFu9i_BFu9i { unsigned int v1:7; unsigned int v2:9; unsigned int v3:9; };
struct BFu7i_BFu9i_BFu9ll { unsigned int v1:7; unsigned int v2:9; unsigned long long v3:9; };
struct BFu7i_BFu9i_BFu9s { unsigned int v1:7; unsigned int v2:9; unsigned short v3:9; };
struct BFu7i_BFu9i_C { unsigned int v1:7; unsigned int v2:9; char v3; };
struct BFu7i_BFu9i_D { unsigned int v1:7; unsigned int v2:9; double v3; };
struct BFu7i_BFu9i_F { unsigned int v1:7; unsigned int v2:9; float v3; };
struct BFu7i_BFu9i_I { unsigned int v1:7; unsigned int v2:9; int v3; };
struct BFu7i_BFu9i_Ip { unsigned int v1:7; unsigned int v2:9; int * v3; };
struct BFu7i_BFu9i_L { unsigned int v1:7; unsigned int v2:9; long long v3; };
struct BFu7i_BFu9i_S { unsigned int v1:7; unsigned int v2:9; short v3; };
struct BFu7i_BFu9i_Uc { unsigned int v1:7; unsigned int v2:9; unsigned char v3; };
struct BFu7i_BFu9i_Ui { unsigned int v1:7; unsigned int v2:9; unsigned int v3; };
struct BFu7i_BFu9i_Ul { unsigned int v1:7; unsigned int v2:9; unsigned long long v3; };
struct BFu7i_BFu9i_Us { unsigned int v1:7; unsigned int v2:9; unsigned short v3; };
struct BFu7i_BFu9i_Vp { unsigned int v1:7; unsigned int v2:9; void * v3; };
struct BFu7i_BFu9ll { unsigned int v1:7; unsigned long long v2:9; };
struct BFu7i_BFu9ll_BFu15i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:15; };
struct BFu7i_BFu9ll_BFu15ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:15; };
struct BFu7i_BFu9ll_BFu15s { unsigned int v1:7; unsigned long long v2:9; unsigned short v3:15; };
struct BFu7i_BFu9ll_BFu16i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:16; };
struct BFu7i_BFu9ll_BFu16ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:16; };
struct BFu7i_BFu9ll_BFu16s { unsigned int v1:7; unsigned long long v2:9; unsigned short v3:16; };
struct BFu7i_BFu9ll_BFu17i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:17; };
struct BFu7i_BFu9ll_BFu17ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:17; };
struct BFu7i_BFu9ll_BFu1c { unsigned int v1:7; unsigned long long v2:9; unsigned char v3:1; };
struct BFu7i_BFu9ll_BFu1i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:1; };
struct BFu7i_BFu9ll_BFu1ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:1; };
struct BFu7i_BFu9ll_BFu1s { unsigned int v1:7; unsigned long long v2:9; unsigned short v3:1; };
struct BFu7i_BFu9ll_BFu31i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:31; };
struct BFu7i_BFu9ll_BFu31ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:31; };
struct BFu7i_BFu9ll_BFu32i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:32; };
struct BFu7i_BFu9ll_BFu32ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:32; };
struct BFu7i_BFu9ll_BFu33 { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:33; };
struct BFu7i_BFu9ll_BFu7c { unsigned int v1:7; unsigned long long v2:9; unsigned char v3:7; };
struct BFu7i_BFu9ll_BFu7i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:7; };
struct BFu7i_BFu9ll_BFu7ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:7; };
struct BFu7i_BFu9ll_BFu7s { unsigned int v1:7; unsigned long long v2:9; unsigned short v3:7; };
struct BFu7i_BFu9ll_BFu8c { unsigned int v1:7; unsigned long long v2:9; unsigned char v3:8; };
struct BFu7i_BFu9ll_BFu8i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:8; };
struct BFu7i_BFu9ll_BFu8ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:8; };
struct BFu7i_BFu9ll_BFu8s { unsigned int v1:7; unsigned long long v2:9; unsigned short v3:8; };
struct BFu7i_BFu9ll_BFu9i { unsigned int v1:7; unsigned long long v2:9; unsigned int v3:9; };
struct BFu7i_BFu9ll_BFu9ll { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3:9; };
struct BFu7i_BFu9ll_BFu9s { unsigned int v1:7; unsigned long long v2:9; unsigned short v3:9; };
struct BFu7i_BFu9ll_C { unsigned int v1:7; unsigned long long v2:9; char v3; };
struct BFu7i_BFu9ll_D { unsigned int v1:7; unsigned long long v2:9; double v3; };
struct BFu7i_BFu9ll_F { unsigned int v1:7; unsigned long long v2:9; float v3; };
struct BFu7i_BFu9ll_I { unsigned int v1:7; unsigned long long v2:9; int v3; };
struct BFu7i_BFu9ll_Ip { unsigned int v1:7; unsigned long long v2:9; int * v3; };
struct BFu7i_BFu9ll_L { unsigned int v1:7; unsigned long long v2:9; long long v3; };
struct BFu7i_BFu9ll_S { unsigned int v1:7; unsigned long long v2:9; short v3; };
struct BFu7i_BFu9ll_Uc { unsigned int v1:7; unsigned long long v2:9; unsigned char v3; };
struct BFu7i_BFu9ll_Ui { unsigned int v1:7; unsigned long long v2:9; unsigned int v3; };
struct BFu7i_BFu9ll_Ul { unsigned int v1:7; unsigned long long v2:9; unsigned long long v3; };
struct BFu7i_BFu9ll_Us { unsigned int v1:7; unsigned long long v2:9; unsigned short v3; };
struct BFu7i_BFu9ll_Vp { unsigned int v1:7; unsigned long long v2:9; void * v3; };
struct BFu7i_BFu9s { unsigned int v1:7; unsigned short v2:9; };
struct BFu7i_BFu9s_BFu15i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:15; };
struct BFu7i_BFu9s_BFu15ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:15; };
struct BFu7i_BFu9s_BFu15s { unsigned int v1:7; unsigned short v2:9; unsigned short v3:15; };
struct BFu7i_BFu9s_BFu16i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:16; };
struct BFu7i_BFu9s_BFu16ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:16; };
struct BFu7i_BFu9s_BFu16s { unsigned int v1:7; unsigned short v2:9; unsigned short v3:16; };
struct BFu7i_BFu9s_BFu17i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:17; };
struct BFu7i_BFu9s_BFu17ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:17; };
struct BFu7i_BFu9s_BFu1c { unsigned int v1:7; unsigned short v2:9; unsigned char v3:1; };
struct BFu7i_BFu9s_BFu1i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:1; };
struct BFu7i_BFu9s_BFu1ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:1; };
struct BFu7i_BFu9s_BFu1s { unsigned int v1:7; unsigned short v2:9; unsigned short v3:1; };
struct BFu7i_BFu9s_BFu31i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:31; };
struct BFu7i_BFu9s_BFu31ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:31; };
struct BFu7i_BFu9s_BFu32i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:32; };
struct BFu7i_BFu9s_BFu32ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:32; };
struct BFu7i_BFu9s_BFu33 { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:33; };
struct BFu7i_BFu9s_BFu7c { unsigned int v1:7; unsigned short v2:9; unsigned char v3:7; };
struct BFu7i_BFu9s_BFu7i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:7; };
struct BFu7i_BFu9s_BFu7ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:7; };
struct BFu7i_BFu9s_BFu7s { unsigned int v1:7; unsigned short v2:9; unsigned short v3:7; };
struct BFu7i_BFu9s_BFu8c { unsigned int v1:7; unsigned short v2:9; unsigned char v3:8; };
struct BFu7i_BFu9s_BFu8i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:8; };
struct BFu7i_BFu9s_BFu8ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:8; };
struct BFu7i_BFu9s_BFu8s { unsigned int v1:7; unsigned short v2:9; unsigned short v3:8; };
struct BFu7i_BFu9s_BFu9i { unsigned int v1:7; unsigned short v2:9; unsigned int v3:9; };
struct BFu7i_BFu9s_BFu9ll { unsigned int v1:7; unsigned short v2:9; unsigned long long v3:9; };
struct BFu7i_BFu9s_BFu9s { unsigned int v1:7; unsigned short v2:9; unsigned short v3:9; };
struct BFu7i_BFu9s_C { unsigned int v1:7; unsigned short v2:9; char v3; };
struct BFu7i_BFu9s_D { unsigned int v1:7; unsigned short v2:9; double v3; };
struct BFu7i_BFu9s_F { unsigned int v1:7; unsigned short v2:9; float v3; };
struct BFu7i_BFu9s_I { unsigned int v1:7; unsigned short v2:9; int v3; };
struct BFu7i_BFu9s_Ip { unsigned int v1:7; unsigned short v2:9; int * v3; };
struct BFu7i_BFu9s_L { unsigned int v1:7; unsigned short v2:9; long long v3; };
struct BFu7i_BFu9s_S { unsigned int v1:7; unsigned short v2:9; short v3; };
struct BFu7i_BFu9s_Uc { unsigned int v1:7; unsigned short v2:9; unsigned char v3; };
struct BFu7i_BFu9s_Ui { unsigned int v1:7; unsigned short v2:9; unsigned int v3; };
struct BFu7i_BFu9s_Ul { unsigned int v1:7; unsigned short v2:9; unsigned long long v3; };
struct BFu7i_BFu9s_Us { unsigned int v1:7; unsigned short v2:9; unsigned short v3; };
struct BFu7i_BFu9s_Vp { unsigned int v1:7; unsigned short v2:9; void * v3; };
struct BFu7i_C { unsigned int v1:7; char v2; };
struct BFu7i_C_BFu15i { unsigned int v1:7; char v2; unsigned int v3:15; };
struct BFu7i_C_BFu15ll { unsigned int v1:7; char v2; unsigned long long v3:15; };
struct BFu7i_C_BFu15s { unsigned int v1:7; char v2; unsigned short v3:15; };
struct BFu7i_C_BFu16i { unsigned int v1:7; char v2; unsigned int v3:16; };
struct BFu7i_C_BFu16ll { unsigned int v1:7; char v2; unsigned long long v3:16; };
struct BFu7i_C_BFu16s { unsigned int v1:7; char v2; unsigned short v3:16; };
struct BFu7i_C_BFu17i { unsigned int v1:7; char v2; unsigned int v3:17; };
struct BFu7i_C_BFu17ll { unsigned int v1:7; char v2; unsigned long long v3:17; };
struct BFu7i_C_BFu1c { unsigned int v1:7; char v2; unsigned char v3:1; };
struct BFu7i_C_BFu1i { unsigned int v1:7; char v2; unsigned int v3:1; };
struct BFu7i_C_BFu1ll { unsigned int v1:7; char v2; unsigned long long v3:1; };
struct BFu7i_C_BFu1s { unsigned int v1:7; char v2; unsigned short v3:1; };
struct BFu7i_C_BFu31i { unsigned int v1:7; char v2; unsigned int v3:31; };
struct BFu7i_C_BFu31ll { unsigned int v1:7; char v2; unsigned long long v3:31; };
struct BFu7i_C_BFu32i { unsigned int v1:7; char v2; unsigned int v3:32; };
struct BFu7i_C_BFu32ll { unsigned int v1:7; char v2; unsigned long long v3:32; };
struct BFu7i_C_BFu33 { unsigned int v1:7; char v2; unsigned long long v3:33; };
struct BFu7i_C_BFu7c { unsigned int v1:7; char v2; unsigned char v3:7; };
struct BFu7i_C_BFu7i { unsigned int v1:7; char v2; unsigned int v3:7; };
struct BFu7i_C_BFu7ll { unsigned int v1:7; char v2; unsigned long long v3:7; };
struct BFu7i_C_BFu7s { unsigned int v1:7; char v2; unsigned short v3:7; };
struct BFu7i_C_BFu8c { unsigned int v1:7; char v2; unsigned char v3:8; };
struct BFu7i_C_BFu8i { unsigned int v1:7; char v2; unsigned int v3:8; };
struct BFu7i_C_BFu8ll { unsigned int v1:7; char v2; unsigned long long v3:8; };
struct BFu7i_C_BFu8s { unsigned int v1:7; char v2; unsigned short v3:8; };
struct BFu7i_C_BFu9i { unsigned int v1:7; char v2; unsigned int v3:9; };
struct BFu7i_C_BFu9ll { unsigned int v1:7; char v2; unsigned long long v3:9; };
struct BFu7i_C_BFu9s { unsigned int v1:7; char v2; unsigned short v3:9; };
struct BFu7i_C_C { unsigned int v1:7; char v2; char v3; };
struct BFu7i_C_D { unsigned int v1:7; char v2; double v3; };
struct BFu7i_C_F { unsigned int v1:7; char v2; float v3; };
struct BFu7i_C_I { unsigned int v1:7; char v2; int v3; };
struct BFu7i_C_Ip { unsigned int v1:7; char v2; int * v3; };
struct BFu7i_C_L { unsigned int v1:7; char v2; long long v3; };
struct BFu7i_C_S { unsigned int v1:7; char v2; short v3; };
struct BFu7i_C_Uc { unsigned int v1:7; char v2; unsigned char v3; };
struct BFu7i_C_Ui { unsigned int v1:7; char v2; unsigned int v3; };
struct BFu7i_C_Ul { unsigned int v1:7; char v2; unsigned long long v3; };
struct BFu7i_C_Us { unsigned int v1:7; char v2; unsigned short v3; };
struct BFu7i_C_Vp { unsigned int v1:7; char v2; void * v3; };
struct BFu7i_D { unsigned int v1:7; double v2; };
struct BFu7i_D_BFu15i { unsigned int v1:7; double v2; unsigned int v3:15; };
struct BFu7i_D_BFu15ll { unsigned int v1:7; double v2; unsigned long long v3:15; };
struct BFu7i_D_BFu15s { unsigned int v1:7; double v2; unsigned short v3:15; };
struct BFu7i_D_BFu16i { unsigned int v1:7; double v2; unsigned int v3:16; };
struct BFu7i_D_BFu16ll { unsigned int v1:7; double v2; unsigned long long v3:16; };
struct BFu7i_D_BFu16s { unsigned int v1:7; double v2; unsigned short v3:16; };
struct BFu7i_D_BFu17i { unsigned int v1:7; double v2; unsigned int v3:17; };
struct BFu7i_D_BFu17ll { unsigned int v1:7; double v2; unsigned long long v3:17; };
struct BFu7i_D_BFu1c { unsigned int v1:7; double v2; unsigned char v3:1; };
struct BFu7i_D_BFu1i { unsigned int v1:7; double v2; unsigned int v3:1; };
struct BFu7i_D_BFu1ll { unsigned int v1:7; double v2; unsigned long long v3:1; };
struct BFu7i_D_BFu1s { unsigned int v1:7; double v2; unsigned short v3:1; };
struct BFu7i_D_BFu31i { unsigned int v1:7; double v2; unsigned int v3:31; };
struct BFu7i_D_BFu31ll { unsigned int v1:7; double v2; unsigned long long v3:31; };
struct BFu7i_D_BFu32i { unsigned int v1:7; double v2; unsigned int v3:32; };
struct BFu7i_D_BFu32ll { unsigned int v1:7; double v2; unsigned long long v3:32; };
struct BFu7i_D_BFu33 { unsigned int v1:7; double v2; unsigned long long v3:33; };
struct BFu7i_D_BFu7c { unsigned int v1:7; double v2; unsigned char v3:7; };
struct BFu7i_D_BFu7i { unsigned int v1:7; double v2; unsigned int v3:7; };
struct BFu7i_D_BFu7ll { unsigned int v1:7; double v2; unsigned long long v3:7; };
struct BFu7i_D_BFu7s { unsigned int v1:7; double v2; unsigned short v3:7; };
struct BFu7i_D_BFu8c { unsigned int v1:7; double v2; unsigned char v3:8; };
struct BFu7i_D_BFu8i { unsigned int v1:7; double v2; unsigned int v3:8; };
struct BFu7i_D_BFu8ll { unsigned int v1:7; double v2; unsigned long long v3:8; };
struct BFu7i_D_BFu8s { unsigned int v1:7; double v2; unsigned short v3:8; };
struct BFu7i_D_BFu9i { unsigned int v1:7; double v2; unsigned int v3:9; };
struct BFu7i_D_BFu9ll { unsigned int v1:7; double v2; unsigned long long v3:9; };
struct BFu7i_D_BFu9s { unsigned int v1:7; double v2; unsigned short v3:9; };
struct BFu7i_D_C { unsigned int v1:7; double v2; char v3; };
struct BFu7i_D_D { unsigned int v1:7; double v2; double v3; };
struct BFu7i_D_F { unsigned int v1:7; double v2; float v3; };
struct BFu7i_D_I { unsigned int v1:7; double v2; int v3; };
struct BFu7i_D_Ip { unsigned int v1:7; double v2; int * v3; };
struct BFu7i_D_L { unsigned int v1:7; double v2; long long v3; };
struct BFu7i_D_S { unsigned int v1:7; double v2; short v3; };
struct BFu7i_D_Uc { unsigned int v1:7; double v2; unsigned char v3; };
struct BFu7i_D_Ui { unsigned int v1:7; double v2; unsigned int v3; };
struct BFu7i_D_Ul { unsigned int v1:7; double v2; unsigned long long v3; };
struct BFu7i_D_Us { unsigned int v1:7; double v2; unsigned short v3; };
struct BFu7i_D_Vp { unsigned int v1:7; double v2; void * v3; };
struct BFu7i_F { unsigned int v1:7; float v2; };
struct BFu7i_F_BFu15i { unsigned int v1:7; float v2; unsigned int v3:15; };
struct BFu7i_F_BFu15ll { unsigned int v1:7; float v2; unsigned long long v3:15; };
struct BFu7i_F_BFu15s { unsigned int v1:7; float v2; unsigned short v3:15; };
struct BFu7i_F_BFu16i { unsigned int v1:7; float v2; unsigned int v3:16; };
struct BFu7i_F_BFu16ll { unsigned int v1:7; float v2; unsigned long long v3:16; };
struct BFu7i_F_BFu16s { unsigned int v1:7; float v2; unsigned short v3:16; };
struct BFu7i_F_BFu17i { unsigned int v1:7; float v2; unsigned int v3:17; };
struct BFu7i_F_BFu17ll { unsigned int v1:7; float v2; unsigned long long v3:17; };
struct BFu7i_F_BFu1c { unsigned int v1:7; float v2; unsigned char v3:1; };
struct BFu7i_F_BFu1i { unsigned int v1:7; float v2; unsigned int v3:1; };
struct BFu7i_F_BFu1ll { unsigned int v1:7; float v2; unsigned long long v3:1; };
struct BFu7i_F_BFu1s { unsigned int v1:7; float v2; unsigned short v3:1; };
struct BFu7i_F_BFu31i { unsigned int v1:7; float v2; unsigned int v3:31; };
struct BFu7i_F_BFu31ll { unsigned int v1:7; float v2; unsigned long long v3:31; };
struct BFu7i_F_BFu32i { unsigned int v1:7; float v2; unsigned int v3:32; };
struct BFu7i_F_BFu32ll { unsigned int v1:7; float v2; unsigned long long v3:32; };
struct BFu7i_F_BFu33 { unsigned int v1:7; float v2; unsigned long long v3:33; };
struct BFu7i_F_BFu7c { unsigned int v1:7; float v2; unsigned char v3:7; };
struct BFu7i_F_BFu7i { unsigned int v1:7; float v2; unsigned int v3:7; };
struct BFu7i_F_BFu7ll { unsigned int v1:7; float v2; unsigned long long v3:7; };
struct BFu7i_F_BFu7s { unsigned int v1:7; float v2; unsigned short v3:7; };
struct BFu7i_F_BFu8c { unsigned int v1:7; float v2; unsigned char v3:8; };
struct BFu7i_F_BFu8i { unsigned int v1:7; float v2; unsigned int v3:8; };
struct BFu7i_F_BFu8ll { unsigned int v1:7; float v2; unsigned long long v3:8; };
struct BFu7i_F_BFu8s { unsigned int v1:7; float v2; unsigned short v3:8; };
struct BFu7i_F_BFu9i { unsigned int v1:7; float v2; unsigned int v3:9; };
struct BFu7i_F_BFu9ll { unsigned int v1:7; float v2; unsigned long long v3:9; };
struct BFu7i_F_BFu9s { unsigned int v1:7; float v2; unsigned short v3:9; };
struct BFu7i_F_C { unsigned int v1:7; float v2; char v3; };
struct BFu7i_F_D { unsigned int v1:7; float v2; double v3; };
struct BFu7i_F_F { unsigned int v1:7; float v2; float v3; };
struct BFu7i_F_I { unsigned int v1:7; float v2; int v3; };
struct BFu7i_F_Ip { unsigned int v1:7; float v2; int * v3; };
struct BFu7i_F_L { unsigned int v1:7; float v2; long long v3; };
struct BFu7i_F_S { unsigned int v1:7; float v2; short v3; };
struct BFu7i_F_Uc { unsigned int v1:7; float v2; unsigned char v3; };
struct BFu7i_F_Ui { unsigned int v1:7; float v2; unsigned int v3; };
struct BFu7i_F_Ul { unsigned int v1:7; float v2; unsigned long long v3; };
struct BFu7i_F_Us { unsigned int v1:7; float v2; unsigned short v3; };
struct BFu7i_F_Vp { unsigned int v1:7; float v2; void * v3; };
struct BFu7i_I { unsigned int v1:7; int v2; };
struct BFu7i_I_BFu15i { unsigned int v1:7; int v2; unsigned int v3:15; };
struct BFu7i_I_BFu15ll { unsigned int v1:7; int v2; unsigned long long v3:15; };
struct BFu7i_I_BFu15s { unsigned int v1:7; int v2; unsigned short v3:15; };
struct BFu7i_I_BFu16i { unsigned int v1:7; int v2; unsigned int v3:16; };
struct BFu7i_I_BFu16ll { unsigned int v1:7; int v2; unsigned long long v3:16; };
struct BFu7i_I_BFu16s { unsigned int v1:7; int v2; unsigned short v3:16; };
struct BFu7i_I_BFu17i { unsigned int v1:7; int v2; unsigned int v3:17; };
struct BFu7i_I_BFu17ll { unsigned int v1:7; int v2; unsigned long long v3:17; };
struct BFu7i_I_BFu1c { unsigned int v1:7; int v2; unsigned char v3:1; };
struct BFu7i_I_BFu1i { unsigned int v1:7; int v2; unsigned int v3:1; };
struct BFu7i_I_BFu1ll { unsigned int v1:7; int v2; unsigned long long v3:1; };
struct BFu7i_I_BFu1s { unsigned int v1:7; int v2; unsigned short v3:1; };
struct BFu7i_I_BFu31i { unsigned int v1:7; int v2; unsigned int v3:31; };
struct BFu7i_I_BFu31ll { unsigned int v1:7; int v2; unsigned long long v3:31; };
struct BFu7i_I_BFu32i { unsigned int v1:7; int v2; unsigned int v3:32; };
struct BFu7i_I_BFu32ll { unsigned int v1:7; int v2; unsigned long long v3:32; };
struct BFu7i_I_BFu33 { unsigned int v1:7; int v2; unsigned long long v3:33; };
struct BFu7i_I_BFu7c { unsigned int v1:7; int v2; unsigned char v3:7; };
struct BFu7i_I_BFu7i { unsigned int v1:7; int v2; unsigned int v3:7; };
struct BFu7i_I_BFu7ll { unsigned int v1:7; int v2; unsigned long long v3:7; };
struct BFu7i_I_BFu7s { unsigned int v1:7; int v2; unsigned short v3:7; };
struct BFu7i_I_BFu8c { unsigned int v1:7; int v2; unsigned char v3:8; };
struct BFu7i_I_BFu8i { unsigned int v1:7; int v2; unsigned int v3:8; };
struct BFu7i_I_BFu8ll { unsigned int v1:7; int v2; unsigned long long v3:8; };
struct BFu7i_I_BFu8s { unsigned int v1:7; int v2; unsigned short v3:8; };
struct BFu7i_I_BFu9i { unsigned int v1:7; int v2; unsigned int v3:9; };
struct BFu7i_I_BFu9ll { unsigned int v1:7; int v2; unsigned long long v3:9; };
struct BFu7i_I_BFu9s { unsigned int v1:7; int v2; unsigned short v3:9; };
struct BFu7i_I_C { unsigned int v1:7; int v2; char v3; };
struct BFu7i_I_D { unsigned int v1:7; int v2; double v3; };
struct BFu7i_I_F { unsigned int v1:7; int v2; float v3; };
struct BFu7i_I_I { unsigned int v1:7; int v2; int v3; };
struct BFu7i_I_Ip { unsigned int v1:7; int v2; int * v3; };
struct BFu7i_I_L { unsigned int v1:7; int v2; long long v3; };
struct BFu7i_I_S { unsigned int v1:7; int v2; short v3; };
struct BFu7i_I_Uc { unsigned int v1:7; int v2; unsigned char v3; };
struct BFu7i_I_Ui { unsigned int v1:7; int v2; unsigned int v3; };
struct BFu7i_I_Ul { unsigned int v1:7; int v2; unsigned long long v3; };
struct BFu7i_I_Us { unsigned int v1:7; int v2; unsigned short v3; };
struct BFu7i_I_Vp { unsigned int v1:7; int v2; void * v3; };
struct BFu7i_Ip { unsigned int v1:7; int * v2; };
struct BFu7i_Ip_BFu15i { unsigned int v1:7; int * v2; unsigned int v3:15; };
struct BFu7i_Ip_BFu15ll { unsigned int v1:7; int * v2; unsigned long long v3:15; };
struct BFu7i_Ip_BFu15s { unsigned int v1:7; int * v2; unsigned short v3:15; };
struct BFu7i_Ip_BFu16i { unsigned int v1:7; int * v2; unsigned int v3:16; };
struct BFu7i_Ip_BFu16ll { unsigned int v1:7; int * v2; unsigned long long v3:16; };
struct BFu7i_Ip_BFu16s { unsigned int v1:7; int * v2; unsigned short v3:16; };
struct BFu7i_Ip_BFu17i { unsigned int v1:7; int * v2; unsigned int v3:17; };
struct BFu7i_Ip_BFu17ll { unsigned int v1:7; int * v2; unsigned long long v3:17; };
struct BFu7i_Ip_BFu1c { unsigned int v1:7; int * v2; unsigned char v3:1; };
struct BFu7i_Ip_BFu1i { unsigned int v1:7; int * v2; unsigned int v3:1; };
struct BFu7i_Ip_BFu1ll { unsigned int v1:7; int * v2; unsigned long long v3:1; };
struct BFu7i_Ip_BFu1s { unsigned int v1:7; int * v2; unsigned short v3:1; };
struct BFu7i_Ip_BFu31i { unsigned int v1:7; int * v2; unsigned int v3:31; };
struct BFu7i_Ip_BFu31ll { unsigned int v1:7; int * v2; unsigned long long v3:31; };
struct BFu7i_Ip_BFu32i { unsigned int v1:7; int * v2; unsigned int v3:32; };
struct BFu7i_Ip_BFu32ll { unsigned int v1:7; int * v2; unsigned long long v3:32; };
struct BFu7i_Ip_BFu33 { unsigned int v1:7; int * v2; unsigned long long v3:33; };
struct BFu7i_Ip_BFu7c { unsigned int v1:7; int * v2; unsigned char v3:7; };
struct BFu7i_Ip_BFu7i { unsigned int v1:7; int * v2; unsigned int v3:7; };
struct BFu7i_Ip_BFu7ll { unsigned int v1:7; int * v2; unsigned long long v3:7; };
struct BFu7i_Ip_BFu7s { unsigned int v1:7; int * v2; unsigned short v3:7; };
struct BFu7i_Ip_BFu8c { unsigned int v1:7; int * v2; unsigned char v3:8; };
struct BFu7i_Ip_BFu8i { unsigned int v1:7; int * v2; unsigned int v3:8; };
struct BFu7i_Ip_BFu8ll { unsigned int v1:7; int * v2; unsigned long long v3:8; };
struct BFu7i_Ip_BFu8s { unsigned int v1:7; int * v2; unsigned short v3:8; };
struct BFu7i_Ip_BFu9i { unsigned int v1:7; int * v2; unsigned int v3:9; };
struct BFu7i_Ip_BFu9ll { unsigned int v1:7; int * v2; unsigned long long v3:9; };
struct BFu7i_Ip_BFu9s { unsigned int v1:7; int * v2; unsigned short v3:9; };
struct BFu7i_Ip_C { unsigned int v1:7; int * v2; char v3; };
struct BFu7i_Ip_D { unsigned int v1:7; int * v2; double v3; };
struct BFu7i_Ip_F { unsigned int v1:7; int * v2; float v3; };
struct BFu7i_Ip_I { unsigned int v1:7; int * v2; int v3; };
struct BFu7i_Ip_Ip { unsigned int v1:7; int * v2; int * v3; };
struct BFu7i_Ip_L { unsigned int v1:7; int * v2; long long v3; };
struct BFu7i_Ip_S { unsigned int v1:7; int * v2; short v3; };
struct BFu7i_Ip_Uc { unsigned int v1:7; int * v2; unsigned char v3; };
struct BFu7i_Ip_Ui { unsigned int v1:7; int * v2; unsigned int v3; };
struct BFu7i_Ip_Ul { unsigned int v1:7; int * v2; unsigned long long v3; };
struct BFu7i_Ip_Us { unsigned int v1:7; int * v2; unsigned short v3; };
struct BFu7i_Ip_Vp { unsigned int v1:7; int * v2; void * v3; };
struct BFu7i_L { unsigned int v1:7; long long v2; };
struct BFu7i_L_BFu15i { unsigned int v1:7; long long v2; unsigned int v3:15; };
struct BFu7i_L_BFu15ll { unsigned int v1:7; long long v2; unsigned long long v3:15; };
struct BFu7i_L_BFu15s { unsigned int v1:7; long long v2; unsigned short v3:15; };
struct BFu7i_L_BFu16i { unsigned int v1:7; long long v2; unsigned int v3:16; };
struct BFu7i_L_BFu16ll { unsigned int v1:7; long long v2; unsigned long long v3:16; };
struct BFu7i_L_BFu16s { unsigned int v1:7; long long v2; unsigned short v3:16; };
struct BFu7i_L_BFu17i { unsigned int v1:7; long long v2; unsigned int v3:17; };
struct BFu7i_L_BFu17ll { unsigned int v1:7; long long v2; unsigned long long v3:17; };
struct BFu7i_L_BFu1c { unsigned int v1:7; long long v2; unsigned char v3:1; };
struct BFu7i_L_BFu1i { unsigned int v1:7; long long v2; unsigned int v3:1; };
struct BFu7i_L_BFu1ll { unsigned int v1:7; long long v2; unsigned long long v3:1; };
struct BFu7i_L_BFu1s { unsigned int v1:7; long long v2; unsigned short v3:1; };
struct BFu7i_L_BFu31i { unsigned int v1:7; long long v2; unsigned int v3:31; };
struct BFu7i_L_BFu31ll { unsigned int v1:7; long long v2; unsigned long long v3:31; };
struct BFu7i_L_BFu32i { unsigned int v1:7; long long v2; unsigned int v3:32; };
struct BFu7i_L_BFu32ll { unsigned int v1:7; long long v2; unsigned long long v3:32; };
struct BFu7i_L_BFu33 { unsigned int v1:7; long long v2; unsigned long long v3:33; };
struct BFu7i_L_BFu7c { unsigned int v1:7; long long v2; unsigned char v3:7; };
struct BFu7i_L_BFu7i { unsigned int v1:7; long long v2; unsigned int v3:7; };
struct BFu7i_L_BFu7ll { unsigned int v1:7; long long v2; unsigned long long v3:7; };
struct BFu7i_L_BFu7s { unsigned int v1:7; long long v2; unsigned short v3:7; };
struct BFu7i_L_BFu8c { unsigned int v1:7; long long v2; unsigned char v3:8; };
struct BFu7i_L_BFu8i { unsigned int v1:7; long long v2; unsigned int v3:8; };
struct BFu7i_L_BFu8ll { unsigned int v1:7; long long v2; unsigned long long v3:8; };
struct BFu7i_L_BFu8s { unsigned int v1:7; long long v2; unsigned short v3:8; };
struct BFu7i_L_BFu9i { unsigned int v1:7; long long v2; unsigned int v3:9; };
struct BFu7i_L_BFu9ll { unsigned int v1:7; long long v2; unsigned long long v3:9; };
struct BFu7i_L_BFu9s { unsigned int v1:7; long long v2; unsigned short v3:9; };
struct BFu7i_L_C { unsigned int v1:7; long long v2; char v3; };
struct BFu7i_L_D { unsigned int v1:7; long long v2; double v3; };
struct BFu7i_L_F { unsigned int v1:7; long long v2; float v3; };
struct BFu7i_L_I { unsigned int v1:7; long long v2; int v3; };
struct BFu7i_L_Ip { unsigned int v1:7; long long v2; int * v3; };
struct BFu7i_L_L { unsigned int v1:7; long long v2; long long v3; };
struct BFu7i_L_S { unsigned int v1:7; long long v2; short v3; };
struct BFu7i_L_Uc { unsigned int v1:7; long long v2; unsigned char v3; };
struct BFu7i_L_Ui { unsigned int v1:7; long long v2; unsigned int v3; };
struct BFu7i_L_Ul { unsigned int v1:7; long long v2; unsigned long long v3; };
struct BFu7i_L_Us { unsigned int v1:7; long long v2; unsigned short v3; };
struct BFu7i_L_Vp { unsigned int v1:7; long long v2; void * v3; };
struct BFu7i_S { unsigned int v1:7; short v2; };
struct BFu7i_S_BFu15i { unsigned int v1:7; short v2; unsigned int v3:15; };
struct BFu7i_S_BFu15ll { unsigned int v1:7; short v2; unsigned long long v3:15; };
struct BFu7i_S_BFu15s { unsigned int v1:7; short v2; unsigned short v3:15; };
struct BFu7i_S_BFu16i { unsigned int v1:7; short v2; unsigned int v3:16; };
struct BFu7i_S_BFu16ll { unsigned int v1:7; short v2; unsigned long long v3:16; };
struct BFu7i_S_BFu16s { unsigned int v1:7; short v2; unsigned short v3:16; };
struct BFu7i_S_BFu17i { unsigned int v1:7; short v2; unsigned int v3:17; };
struct BFu7i_S_BFu17ll { unsigned int v1:7; short v2; unsigned long long v3:17; };
struct BFu7i_S_BFu1c { unsigned int v1:7; short v2; unsigned char v3:1; };
struct BFu7i_S_BFu1i { unsigned int v1:7; short v2; unsigned int v3:1; };
struct BFu7i_S_BFu1ll { unsigned int v1:7; short v2; unsigned long long v3:1; };
struct BFu7i_S_BFu1s { unsigned int v1:7; short v2; unsigned short v3:1; };
struct BFu7i_S_BFu31i { unsigned int v1:7; short v2; unsigned int v3:31; };
struct BFu7i_S_BFu31ll { unsigned int v1:7; short v2; unsigned long long v3:31; };
struct BFu7i_S_BFu32i { unsigned int v1:7; short v2; unsigned int v3:32; };
struct BFu7i_S_BFu32ll { unsigned int v1:7; short v2; unsigned long long v3:32; };
struct BFu7i_S_BFu33 { unsigned int v1:7; short v2; unsigned long long v3:33; };
struct BFu7i_S_BFu7c { unsigned int v1:7; short v2; unsigned char v3:7; };
struct BFu7i_S_BFu7i { unsigned int v1:7; short v2; unsigned int v3:7; };
struct BFu7i_S_BFu7ll { unsigned int v1:7; short v2; unsigned long long v3:7; };
struct BFu7i_S_BFu7s { unsigned int v1:7; short v2; unsigned short v3:7; };
struct BFu7i_S_BFu8c { unsigned int v1:7; short v2; unsigned char v3:8; };
struct BFu7i_S_BFu8i { unsigned int v1:7; short v2; unsigned int v3:8; };
struct BFu7i_S_BFu8ll { unsigned int v1:7; short v2; unsigned long long v3:8; };
struct BFu7i_S_BFu8s { unsigned int v1:7; short v2; unsigned short v3:8; };
struct BFu7i_S_BFu9i { unsigned int v1:7; short v2; unsigned int v3:9; };
struct BFu7i_S_BFu9ll { unsigned int v1:7; short v2; unsigned long long v3:9; };
struct BFu7i_S_BFu9s { unsigned int v1:7; short v2; unsigned short v3:9; };
struct BFu7i_S_C { unsigned int v1:7; short v2; char v3; };
struct BFu7i_S_D { unsigned int v1:7; short v2; double v3; };
struct BFu7i_S_F { unsigned int v1:7; short v2; float v3; };
struct BFu7i_S_I { unsigned int v1:7; short v2; int v3; };
struct BFu7i_S_Ip { unsigned int v1:7; short v2; int * v3; };
struct BFu7i_S_L { unsigned int v1:7; short v2; long long v3; };
struct BFu7i_S_S { unsigned int v1:7; short v2; short v3; };
struct BFu7i_S_Uc { unsigned int v1:7; short v2; unsigned char v3; };
struct BFu7i_S_Ui { unsigned int v1:7; short v2; unsigned int v3; };
struct BFu7i_S_Ul { unsigned int v1:7; short v2; unsigned long long v3; };
struct BFu7i_S_Us { unsigned int v1:7; short v2; unsigned short v3; };
struct BFu7i_S_Vp { unsigned int v1:7; short v2; void * v3; };
struct BFu7i_Uc { unsigned int v1:7; unsigned char v2; };
struct BFu7i_Uc_BFu15i { unsigned int v1:7; unsigned char v2; unsigned int v3:15; };
struct BFu7i_Uc_BFu15ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:15; };
struct BFu7i_Uc_BFu15s { unsigned int v1:7; unsigned char v2; unsigned short v3:15; };
struct BFu7i_Uc_BFu16i { unsigned int v1:7; unsigned char v2; unsigned int v3:16; };
struct BFu7i_Uc_BFu16ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:16; };
struct BFu7i_Uc_BFu16s { unsigned int v1:7; unsigned char v2; unsigned short v3:16; };
struct BFu7i_Uc_BFu17i { unsigned int v1:7; unsigned char v2; unsigned int v3:17; };
struct BFu7i_Uc_BFu17ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:17; };
struct BFu7i_Uc_BFu1c { unsigned int v1:7; unsigned char v2; unsigned char v3:1; };
struct BFu7i_Uc_BFu1i { unsigned int v1:7; unsigned char v2; unsigned int v3:1; };
struct BFu7i_Uc_BFu1ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:1; };
struct BFu7i_Uc_BFu1s { unsigned int v1:7; unsigned char v2; unsigned short v3:1; };
struct BFu7i_Uc_BFu31i { unsigned int v1:7; unsigned char v2; unsigned int v3:31; };
struct BFu7i_Uc_BFu31ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:31; };
struct BFu7i_Uc_BFu32i { unsigned int v1:7; unsigned char v2; unsigned int v3:32; };
struct BFu7i_Uc_BFu32ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:32; };
struct BFu7i_Uc_BFu33 { unsigned int v1:7; unsigned char v2; unsigned long long v3:33; };
struct BFu7i_Uc_BFu7c { unsigned int v1:7; unsigned char v2; unsigned char v3:7; };
struct BFu7i_Uc_BFu7i { unsigned int v1:7; unsigned char v2; unsigned int v3:7; };
struct BFu7i_Uc_BFu7ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:7; };
struct BFu7i_Uc_BFu7s { unsigned int v1:7; unsigned char v2; unsigned short v3:7; };
struct BFu7i_Uc_BFu8c { unsigned int v1:7; unsigned char v2; unsigned char v3:8; };
struct BFu7i_Uc_BFu8i { unsigned int v1:7; unsigned char v2; unsigned int v3:8; };
struct BFu7i_Uc_BFu8ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:8; };
struct BFu7i_Uc_BFu8s { unsigned int v1:7; unsigned char v2; unsigned short v3:8; };
struct BFu7i_Uc_BFu9i { unsigned int v1:7; unsigned char v2; unsigned int v3:9; };
struct BFu7i_Uc_BFu9ll { unsigned int v1:7; unsigned char v2; unsigned long long v3:9; };
struct BFu7i_Uc_BFu9s { unsigned int v1:7; unsigned char v2; unsigned short v3:9; };
struct BFu7i_Uc_C { unsigned int v1:7; unsigned char v2; char v3; };
struct BFu7i_Uc_D { unsigned int v1:7; unsigned char v2; double v3; };
struct BFu7i_Uc_F { unsigned int v1:7; unsigned char v2; float v3; };
struct BFu7i_Uc_I { unsigned int v1:7; unsigned char v2; int v3; };
struct BFu7i_Uc_Ip { unsigned int v1:7; unsigned char v2; int * v3; };
struct BFu7i_Uc_L { unsigned int v1:7; unsigned char v2; long long v3; };
struct BFu7i_Uc_S { unsigned int v1:7; unsigned char v2; short v3; };
struct BFu7i_Uc_Uc { unsigned int v1:7; unsigned char v2; unsigned char v3; };
struct BFu7i_Uc_Ui { unsigned int v1:7; unsigned char v2; unsigned int v3; };
struct BFu7i_Uc_Ul { unsigned int v1:7; unsigned char v2; unsigned long long v3; };
struct BFu7i_Uc_Us { unsigned int v1:7; unsigned char v2; unsigned short v3; };
struct BFu7i_Uc_Vp { unsigned int v1:7; unsigned char v2; void * v3; };
struct BFu7i_Ui { unsigned int v1:7; unsigned int v2; };
struct BFu7i_Ui_BFu15i { unsigned int v1:7; unsigned int v2; unsigned int v3:15; };
struct BFu7i_Ui_BFu15ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:15; };
struct BFu7i_Ui_BFu15s { unsigned int v1:7; unsigned int v2; unsigned short v3:15; };
struct BFu7i_Ui_BFu16i { unsigned int v1:7; unsigned int v2; unsigned int v3:16; };
struct BFu7i_Ui_BFu16ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:16; };
struct BFu7i_Ui_BFu16s { unsigned int v1:7; unsigned int v2; unsigned short v3:16; };
struct BFu7i_Ui_BFu17i { unsigned int v1:7; unsigned int v2; unsigned int v3:17; };
struct BFu7i_Ui_BFu17ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:17; };
struct BFu7i_Ui_BFu1c { unsigned int v1:7; unsigned int v2; unsigned char v3:1; };
struct BFu7i_Ui_BFu1i { unsigned int v1:7; unsigned int v2; unsigned int v3:1; };
struct BFu7i_Ui_BFu1ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:1; };
struct BFu7i_Ui_BFu1s { unsigned int v1:7; unsigned int v2; unsigned short v3:1; };
struct BFu7i_Ui_BFu31i { unsigned int v1:7; unsigned int v2; unsigned int v3:31; };
struct BFu7i_Ui_BFu31ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:31; };
struct BFu7i_Ui_BFu32i { unsigned int v1:7; unsigned int v2; unsigned int v3:32; };
struct BFu7i_Ui_BFu32ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:32; };
struct BFu7i_Ui_BFu33 { unsigned int v1:7; unsigned int v2; unsigned long long v3:33; };
struct BFu7i_Ui_BFu7c { unsigned int v1:7; unsigned int v2; unsigned char v3:7; };
struct BFu7i_Ui_BFu7i { unsigned int v1:7; unsigned int v2; unsigned int v3:7; };
struct BFu7i_Ui_BFu7ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:7; };
struct BFu7i_Ui_BFu7s { unsigned int v1:7; unsigned int v2; unsigned short v3:7; };
struct BFu7i_Ui_BFu8c { unsigned int v1:7; unsigned int v2; unsigned char v3:8; };
struct BFu7i_Ui_BFu8i { unsigned int v1:7; unsigned int v2; unsigned int v3:8; };
struct BFu7i_Ui_BFu8ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:8; };
struct BFu7i_Ui_BFu8s { unsigned int v1:7; unsigned int v2; unsigned short v3:8; };
struct BFu7i_Ui_BFu9i { unsigned int v1:7; unsigned int v2; unsigned int v3:9; };
struct BFu7i_Ui_BFu9ll { unsigned int v1:7; unsigned int v2; unsigned long long v3:9; };
struct BFu7i_Ui_BFu9s { unsigned int v1:7; unsigned int v2; unsigned short v3:9; };
struct BFu7i_Ui_C { unsigned int v1:7; unsigned int v2; char v3; };
struct BFu7i_Ui_D { unsigned int v1:7; unsigned int v2; double v3; };
struct BFu7i_Ui_F { unsigned int v1:7; unsigned int v2; float v3; };
struct BFu7i_Ui_I { unsigned int v1:7; unsigned int v2; int v3; };
struct BFu7i_Ui_Ip { unsigned int v1:7; unsigned int v2; int * v3; };
struct BFu7i_Ui_L { unsigned int v1:7; unsigned int v2; long long v3; };
struct BFu7i_Ui_S { unsigned int v1:7; unsigned int v2; short v3; };
struct BFu7i_Ui_Uc { unsigned int v1:7; unsigned int v2; unsigned char v3; };
struct BFu7i_Ui_Ui { unsigned int v1:7; unsigned int v2; unsigned int v3; };
struct BFu7i_Ui_Ul { unsigned int v1:7; unsigned int v2; unsigned long long v3; };
struct BFu7i_Ui_Us { unsigned int v1:7; unsigned int v2; unsigned short v3; };
struct BFu7i_Ui_Vp { unsigned int v1:7; unsigned int v2; void * v3; };
struct BFu7i_Ul { unsigned int v1:7; unsigned long long v2; };
struct BFu7i_Ul_BFu15i { unsigned int v1:7; unsigned long long v2; unsigned int v3:15; };
struct BFu7i_Ul_BFu15ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:15; };
struct BFu7i_Ul_BFu15s { unsigned int v1:7; unsigned long long v2; unsigned short v3:15; };
struct BFu7i_Ul_BFu16i { unsigned int v1:7; unsigned long long v2; unsigned int v3:16; };
struct BFu7i_Ul_BFu16ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:16; };
struct BFu7i_Ul_BFu16s { unsigned int v1:7; unsigned long long v2; unsigned short v3:16; };
struct BFu7i_Ul_BFu17i { unsigned int v1:7; unsigned long long v2; unsigned int v3:17; };
struct BFu7i_Ul_BFu17ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:17; };
struct BFu7i_Ul_BFu1c { unsigned int v1:7; unsigned long long v2; unsigned char v3:1; };
struct BFu7i_Ul_BFu1i { unsigned int v1:7; unsigned long long v2; unsigned int v3:1; };
struct BFu7i_Ul_BFu1ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:1; };
struct BFu7i_Ul_BFu1s { unsigned int v1:7; unsigned long long v2; unsigned short v3:1; };
struct BFu7i_Ul_BFu31i { unsigned int v1:7; unsigned long long v2; unsigned int v3:31; };
struct BFu7i_Ul_BFu31ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:31; };
struct BFu7i_Ul_BFu32i { unsigned int v1:7; unsigned long long v2; unsigned int v3:32; };
struct BFu7i_Ul_BFu32ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:32; };
struct BFu7i_Ul_BFu33 { unsigned int v1:7; unsigned long long v2; unsigned long long v3:33; };
struct BFu7i_Ul_BFu7c { unsigned int v1:7; unsigned long long v2; unsigned char v3:7; };
struct BFu7i_Ul_BFu7i { unsigned int v1:7; unsigned long long v2; unsigned int v3:7; };
struct BFu7i_Ul_BFu7ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:7; };
struct BFu7i_Ul_BFu7s { unsigned int v1:7; unsigned long long v2; unsigned short v3:7; };
struct BFu7i_Ul_BFu8c { unsigned int v1:7; unsigned long long v2; unsigned char v3:8; };
struct BFu7i_Ul_BFu8i { unsigned int v1:7; unsigned long long v2; unsigned int v3:8; };
struct BFu7i_Ul_BFu8ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:8; };
struct BFu7i_Ul_BFu8s { unsigned int v1:7; unsigned long long v2; unsigned short v3:8; };
struct BFu7i_Ul_BFu9i { unsigned int v1:7; unsigned long long v2; unsigned int v3:9; };
struct BFu7i_Ul_BFu9ll { unsigned int v1:7; unsigned long long v2; unsigned long long v3:9; };
struct BFu7i_Ul_BFu9s { unsigned int v1:7; unsigned long long v2; unsigned short v3:9; };
struct BFu7i_Ul_C { unsigned int v1:7; unsigned long long v2; char v3; };
struct BFu7i_Ul_D { unsigned int v1:7; unsigned long long v2; double v3; };
struct BFu7i_Ul_F { unsigned int v1:7; unsigned long long v2; float v3; };
struct BFu7i_Ul_I { unsigned int v1:7; unsigned long long v2; int v3; };
struct BFu7i_Ul_Ip { unsigned int v1:7; unsigned long long v2; int * v3; };
struct BFu7i_Ul_L { unsigned int v1:7; unsigned long long v2; long long v3; };
struct BFu7i_Ul_S { unsigned int v1:7; unsigned long long v2; short v3; };
struct BFu7i_Ul_Uc { unsigned int v1:7; unsigned long long v2; unsigned char v3; };
struct BFu7i_Ul_Ui { unsigned int v1:7; unsigned long long v2; unsigned int v3; };
struct BFu7i_Ul_Ul { unsigned int v1:7; unsigned long long v2; unsigned long long v3; };
struct BFu7i_Ul_Us { unsigned int v1:7; unsigned long long v2; unsigned short v3; };
struct BFu7i_Ul_Vp { unsigned int v1:7; unsigned long long v2; void * v3; };
struct BFu7i_Us { unsigned int v1:7; unsigned short v2; };
struct BFu7i_Us_BFu15i { unsigned int v1:7; unsigned short v2; unsigned int v3:15; };
struct BFu7i_Us_BFu15ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:15; };
struct BFu7i_Us_BFu15s { unsigned int v1:7; unsigned short v2; unsigned short v3:15; };
struct BFu7i_Us_BFu16i { unsigned int v1:7; unsigned short v2; unsigned int v3:16; };
struct BFu7i_Us_BFu16ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:16; };
struct BFu7i_Us_BFu16s { unsigned int v1:7; unsigned short v2; unsigned short v3:16; };
struct BFu7i_Us_BFu17i { unsigned int v1:7; unsigned short v2; unsigned int v3:17; };
struct BFu7i_Us_BFu17ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:17; };
struct BFu7i_Us_BFu1c { unsigned int v1:7; unsigned short v2; unsigned char v3:1; };
struct BFu7i_Us_BFu1i { unsigned int v1:7; unsigned short v2; unsigned int v3:1; };
struct BFu7i_Us_BFu1ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:1; };
struct BFu7i_Us_BFu1s { unsigned int v1:7; unsigned short v2; unsigned short v3:1; };
struct BFu7i_Us_BFu31i { unsigned int v1:7; unsigned short v2; unsigned int v3:31; };
struct BFu7i_Us_BFu31ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:31; };
struct BFu7i_Us_BFu32i { unsigned int v1:7; unsigned short v2; unsigned int v3:32; };
struct BFu7i_Us_BFu32ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:32; };
struct BFu7i_Us_BFu33 { unsigned int v1:7; unsigned short v2; unsigned long long v3:33; };
struct BFu7i_Us_BFu7c { unsigned int v1:7; unsigned short v2; unsigned char v3:7; };
struct BFu7i_Us_BFu7i { unsigned int v1:7; unsigned short v2; unsigned int v3:7; };
struct BFu7i_Us_BFu7ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:7; };
struct BFu7i_Us_BFu7s { unsigned int v1:7; unsigned short v2; unsigned short v3:7; };
struct BFu7i_Us_BFu8c { unsigned int v1:7; unsigned short v2; unsigned char v3:8; };
struct BFu7i_Us_BFu8i { unsigned int v1:7; unsigned short v2; unsigned int v3:8; };
struct BFu7i_Us_BFu8ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:8; };
struct BFu7i_Us_BFu8s { unsigned int v1:7; unsigned short v2; unsigned short v3:8; };
struct BFu7i_Us_BFu9i { unsigned int v1:7; unsigned short v2; unsigned int v3:9; };
struct BFu7i_Us_BFu9ll { unsigned int v1:7; unsigned short v2; unsigned long long v3:9; };
struct BFu7i_Us_BFu9s { unsigned int v1:7; unsigned short v2; unsigned short v3:9; };
struct BFu7i_Us_C { unsigned int v1:7; unsigned short v2; char v3; };
struct BFu7i_Us_D { unsigned int v1:7; unsigned short v2; double v3; };
struct BFu7i_Us_F { unsigned int v1:7; unsigned short v2; float v3; };
struct BFu7i_Us_I { unsigned int v1:7; unsigned short v2; int v3; };
struct BFu7i_Us_Ip { unsigned int v1:7; unsigned short v2; int * v3; };
struct BFu7i_Us_L { unsigned int v1:7; unsigned short v2; long long v3; };
struct BFu7i_Us_S { unsigned int v1:7; unsigned short v2; short v3; };
struct BFu7i_Us_Uc { unsigned int v1:7; unsigned short v2; unsigned char v3; };
struct BFu7i_Us_Ui { unsigned int v1:7; unsigned short v2; unsigned int v3; };
struct BFu7i_Us_Ul { unsigned int v1:7; unsigned short v2; unsigned long long v3; };
struct BFu7i_Us_Us { unsigned int v1:7; unsigned short v2; unsigned short v3; };
struct BFu7i_Us_Vp { unsigned int v1:7; unsigned short v2; void * v3; };
struct BFu7i_Vp { unsigned int v1:7; void * v2; };
struct BFu7i_Vp_BFu15i { unsigned int v1:7; void * v2; unsigned int v3:15; };
struct BFu7i_Vp_BFu15ll { unsigned int v1:7; void * v2; unsigned long long v3:15; };
struct BFu7i_Vp_BFu15s { unsigned int v1:7; void * v2; unsigned short v3:15; };
struct BFu7i_Vp_BFu16i { unsigned int v1:7; void * v2; unsigned int v3:16; };
struct BFu7i_Vp_BFu16ll { unsigned int v1:7; void * v2; unsigned long long v3:16; };
struct BFu7i_Vp_BFu16s { unsigned int v1:7; void * v2; unsigned short v3:16; };
struct BFu7i_Vp_BFu17i { unsigned int v1:7; void * v2; unsigned int v3:17; };
struct BFu7i_Vp_BFu17ll { unsigned int v1:7; void * v2; unsigned long long v3:17; };
struct BFu7i_Vp_BFu1c { unsigned int v1:7; void * v2; unsigned char v3:1; };
struct BFu7i_Vp_BFu1i { unsigned int v1:7; void * v2; unsigned int v3:1; };
struct BFu7i_Vp_BFu1ll { unsigned int v1:7; void * v2; unsigned long long v3:1; };
struct BFu7i_Vp_BFu1s { unsigned int v1:7; void * v2; unsigned short v3:1; };
struct BFu7i_Vp_BFu31i { unsigned int v1:7; void * v2; unsigned int v3:31; };
struct BFu7i_Vp_BFu31ll { unsigned int v1:7; void * v2; unsigned long long v3:31; };
struct BFu7i_Vp_BFu32i { unsigned int v1:7; void * v2; unsigned int v3:32; };
struct BFu7i_Vp_BFu32ll { unsigned int v1:7; void * v2; unsigned long long v3:32; };
struct BFu7i_Vp_BFu33 { unsigned int v1:7; void * v2; unsigned long long v3:33; };
struct BFu7i_Vp_BFu7c { unsigned int v1:7; void * v2; unsigned char v3:7; };
struct BFu7i_Vp_BFu7i { unsigned int v1:7; void * v2; unsigned int v3:7; };
struct BFu7i_Vp_BFu7ll { unsigned int v1:7; void * v2; unsigned long long v3:7; };
struct BFu7i_Vp_BFu7s { unsigned int v1:7; void * v2; unsigned short v3:7; };
struct BFu7i_Vp_BFu8c { unsigned int v1:7; void * v2; unsigned char v3:8; };
struct BFu7i_Vp_BFu8i { unsigned int v1:7; void * v2; unsigned int v3:8; };
struct BFu7i_Vp_BFu8ll { unsigned int v1:7; void * v2; unsigned long long v3:8; };
struct BFu7i_Vp_BFu8s { unsigned int v1:7; void * v2; unsigned short v3:8; };
struct BFu7i_Vp_BFu9i { unsigned int v1:7; void * v2; unsigned int v3:9; };
struct BFu7i_Vp_BFu9ll { unsigned int v1:7; void * v2; unsigned long long v3:9; };
struct BFu7i_Vp_BFu9s { unsigned int v1:7; void * v2; unsigned short v3:9; };
struct BFu7i_Vp_C { unsigned int v1:7; void * v2; char v3; };
struct BFu7i_Vp_D { unsigned int v1:7; void * v2; double v3; };
struct BFu7i_Vp_F { unsigned int v1:7; void * v2; float v3; };
struct BFu7i_Vp_I { unsigned int v1:7; void * v2; int v3; };
struct BFu7i_Vp_Ip { unsigned int v1:7; void * v2; int * v3; };
struct BFu7i_Vp_L { unsigned int v1:7; void * v2; long long v3; };
struct BFu7i_Vp_S { unsigned int v1:7; void * v2; short v3; };
struct BFu7i_Vp_Uc { unsigned int v1:7; void * v2; unsigned char v3; };
struct BFu7i_Vp_Ui { unsigned int v1:7; void * v2; unsigned int v3; };
struct BFu7i_Vp_Ul { unsigned int v1:7; void * v2; unsigned long long v3; };
struct BFu7i_Vp_Us { unsigned int v1:7; void * v2; unsigned short v3; };
struct BFu7i_Vp_Vp { unsigned int v1:7; void * v2; void * v3; };
struct BFu7ll { unsigned long long v1:7; };
struct BFu7ll_BFs7c { unsigned long long v1:7; signed char v2:7; };
struct BFu7ll_BFs7c_BFs7c { unsigned long long v1:7; signed char v2:7; signed char v3:7; };
struct BFu7ll_BFs7c_BFs7c_BFs7c { unsigned long long v1:7; signed char v2:7; signed char v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFs7i { unsigned long long v1:7; signed char v2:7; signed char v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFs7ll { unsigned long long v1:7; signed char v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFs7s { unsigned long long v1:7; signed char v2:7; signed char v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFu7c { unsigned long long v1:7; signed char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFu7i { unsigned long long v1:7; signed char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFu7ll { unsigned long long v1:7; signed char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFs7c_BFu7s { unsigned long long v1:7; signed char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFs7i { unsigned long long v1:7; signed char v2:7; signed int v3:7; };
struct BFu7ll_BFs7c_BFs7i_BFs7c { unsigned long long v1:7; signed char v2:7; signed int v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFs7i { unsigned long long v1:7; signed char v2:7; signed int v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFs7ll { unsigned long long v1:7; signed char v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFs7s { unsigned long long v1:7; signed char v2:7; signed int v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFu7c { unsigned long long v1:7; signed char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFu7i { unsigned long long v1:7; signed char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFu7ll { unsigned long long v1:7; signed char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFs7i_BFu7s { unsigned long long v1:7; signed char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFs7ll { unsigned long long v1:7; signed char v2:7; signed long long v3:7; };
struct BFu7ll_BFs7c_BFs7ll_BFs7c { unsigned long long v1:7; signed char v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFs7i { unsigned long long v1:7; signed char v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFs7ll { unsigned long long v1:7; signed char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFs7s { unsigned long long v1:7; signed char v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFu7c { unsigned long long v1:7; signed char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFu7i { unsigned long long v1:7; signed char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFu7ll { unsigned long long v1:7; signed char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFs7ll_BFu7s { unsigned long long v1:7; signed char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFs7s { unsigned long long v1:7; signed char v2:7; signed short v3:7; };
struct BFu7ll_BFs7c_BFs7s_BFs7c { unsigned long long v1:7; signed char v2:7; signed short v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFs7i { unsigned long long v1:7; signed char v2:7; signed short v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFs7ll { unsigned long long v1:7; signed char v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFs7s { unsigned long long v1:7; signed char v2:7; signed short v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFu7c { unsigned long long v1:7; signed char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFu7i { unsigned long long v1:7; signed char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFu7ll { unsigned long long v1:7; signed char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFs7s_BFu7s { unsigned long long v1:7; signed char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFu7c { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; };
struct BFu7ll_BFs7c_BFu7c_BFs7c { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFs7i { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFs7ll { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFs7s { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFu7c { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFu7i { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFu7ll { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFu7c_BFu7s { unsigned long long v1:7; signed char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFu7i { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; };
struct BFu7ll_BFs7c_BFu7i_BFs7c { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFs7i { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFs7ll { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFs7s { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFu7c { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFu7i { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFu7ll { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFu7i_BFu7s { unsigned long long v1:7; signed char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFu7ll { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; };
struct BFu7ll_BFs7c_BFu7ll_BFs7c { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFs7i { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFs7ll { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFs7s { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFu7c { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFu7i { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFu7ll { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFu7ll_BFu7s { unsigned long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7c_BFu7s { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; };
struct BFu7ll_BFs7c_BFu7s_BFs7c { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFs7i { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFs7ll { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFs7s { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFu7c { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFu7i { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFu7ll { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7c_BFu7s_BFu7s { unsigned long long v1:7; signed char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i { unsigned long long v1:7; signed int v2:7; };
struct BFu7ll_BFs7i_BFs7c { unsigned long long v1:7; signed int v2:7; signed char v3:7; };
struct BFu7ll_BFs7i_BFs7c_BFs7c { unsigned long long v1:7; signed int v2:7; signed char v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFs7i { unsigned long long v1:7; signed int v2:7; signed char v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFs7ll { unsigned long long v1:7; signed int v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFs7s { unsigned long long v1:7; signed int v2:7; signed char v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFu7c { unsigned long long v1:7; signed int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFu7i { unsigned long long v1:7; signed int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFu7ll { unsigned long long v1:7; signed int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFs7c_BFu7s { unsigned long long v1:7; signed int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFs7i { unsigned long long v1:7; signed int v2:7; signed int v3:7; };
struct BFu7ll_BFs7i_BFs7i_BFs7c { unsigned long long v1:7; signed int v2:7; signed int v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFs7i { unsigned long long v1:7; signed int v2:7; signed int v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFs7ll { unsigned long long v1:7; signed int v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFs7s { unsigned long long v1:7; signed int v2:7; signed int v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFu7c { unsigned long long v1:7; signed int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFu7i { unsigned long long v1:7; signed int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFu7ll { unsigned long long v1:7; signed int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFs7i_BFu7s { unsigned long long v1:7; signed int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFs7ll { unsigned long long v1:7; signed int v2:7; signed long long v3:7; };
struct BFu7ll_BFs7i_BFs7ll_BFs7c { unsigned long long v1:7; signed int v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFs7i { unsigned long long v1:7; signed int v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFs7ll { unsigned long long v1:7; signed int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFs7s { unsigned long long v1:7; signed int v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFu7c { unsigned long long v1:7; signed int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFu7i { unsigned long long v1:7; signed int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFu7ll { unsigned long long v1:7; signed int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFs7ll_BFu7s { unsigned long long v1:7; signed int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFs7s { unsigned long long v1:7; signed int v2:7; signed short v3:7; };
struct BFu7ll_BFs7i_BFs7s_BFs7c { unsigned long long v1:7; signed int v2:7; signed short v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFs7i { unsigned long long v1:7; signed int v2:7; signed short v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFs7ll { unsigned long long v1:7; signed int v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFs7s { unsigned long long v1:7; signed int v2:7; signed short v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFu7c { unsigned long long v1:7; signed int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFu7i { unsigned long long v1:7; signed int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFu7ll { unsigned long long v1:7; signed int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFs7s_BFu7s { unsigned long long v1:7; signed int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFu7c { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; };
struct BFu7ll_BFs7i_BFu7c_BFs7c { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFs7i { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFs7ll { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFs7s { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFu7c { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFu7i { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFu7ll { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFu7c_BFu7s { unsigned long long v1:7; signed int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFu7i { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; };
struct BFu7ll_BFs7i_BFu7i_BFs7c { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFs7i { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFs7ll { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFs7s { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFu7c { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFu7i { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFu7ll { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFu7i_BFu7s { unsigned long long v1:7; signed int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFu7ll { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; };
struct BFu7ll_BFs7i_BFu7ll_BFs7c { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFs7i { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFs7ll { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFs7s { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFu7c { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFu7i { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFu7ll { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFu7ll_BFu7s { unsigned long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7i_BFu7s { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; };
struct BFu7ll_BFs7i_BFu7s_BFs7c { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFs7i { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFs7ll { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFs7s { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFu7c { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFu7i { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFu7ll { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7i_BFu7s_BFu7s { unsigned long long v1:7; signed int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll { unsigned long long v1:7; signed long long v2:7; };
struct BFu7ll_BFs7ll_BFs7c { unsigned long long v1:7; signed long long v2:7; signed char v3:7; };
struct BFu7ll_BFs7ll_BFs7c_BFs7c { unsigned long long v1:7; signed long long v2:7; signed char v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFs7i { unsigned long long v1:7; signed long long v2:7; signed char v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFs7ll { unsigned long long v1:7; signed long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFs7s { unsigned long long v1:7; signed long long v2:7; signed char v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFu7c { unsigned long long v1:7; signed long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFu7i { unsigned long long v1:7; signed long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFu7ll { unsigned long long v1:7; signed long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFs7c_BFu7s { unsigned long long v1:7; signed long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFs7i { unsigned long long v1:7; signed long long v2:7; signed int v3:7; };
struct BFu7ll_BFs7ll_BFs7i_BFs7c { unsigned long long v1:7; signed long long v2:7; signed int v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFs7i { unsigned long long v1:7; signed long long v2:7; signed int v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFs7ll { unsigned long long v1:7; signed long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFs7s { unsigned long long v1:7; signed long long v2:7; signed int v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFu7c { unsigned long long v1:7; signed long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFu7i { unsigned long long v1:7; signed long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFu7ll { unsigned long long v1:7; signed long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFs7i_BFu7s { unsigned long long v1:7; signed long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFs7ll { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFs7c { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFs7i { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFs7ll { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFs7s { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFu7c { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFu7i { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFu7ll { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFs7ll_BFu7s { unsigned long long v1:7; signed long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFs7s { unsigned long long v1:7; signed long long v2:7; signed short v3:7; };
struct BFu7ll_BFs7ll_BFs7s_BFs7c { unsigned long long v1:7; signed long long v2:7; signed short v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFs7i { unsigned long long v1:7; signed long long v2:7; signed short v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFs7ll { unsigned long long v1:7; signed long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFs7s { unsigned long long v1:7; signed long long v2:7; signed short v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFu7c { unsigned long long v1:7; signed long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFu7i { unsigned long long v1:7; signed long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFu7ll { unsigned long long v1:7; signed long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFs7s_BFu7s { unsigned long long v1:7; signed long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFu7c { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; };
struct BFu7ll_BFs7ll_BFu7c_BFs7c { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFs7i { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFs7ll { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFs7s { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFu7c { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFu7i { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFu7ll { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFu7c_BFu7s { unsigned long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFu7i { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; };
struct BFu7ll_BFs7ll_BFu7i_BFs7c { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFs7i { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFs7ll { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFs7s { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFu7c { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFu7i { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFu7ll { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFu7i_BFu7s { unsigned long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFu7ll { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFs7c { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFs7i { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFs7ll { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFs7s { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFu7c { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFu7i { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFu7ll { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFu7ll_BFu7s { unsigned long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7ll_BFu7s { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; };
struct BFu7ll_BFs7ll_BFu7s_BFs7c { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFs7i { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFs7ll { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFs7s { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFu7c { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFu7i { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFu7ll { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7ll_BFu7s_BFu7s { unsigned long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s { unsigned long long v1:7; signed short v2:7; };
struct BFu7ll_BFs7s_BFs7c { unsigned long long v1:7; signed short v2:7; signed char v3:7; };
struct BFu7ll_BFs7s_BFs7c_BFs7c { unsigned long long v1:7; signed short v2:7; signed char v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFs7i { unsigned long long v1:7; signed short v2:7; signed char v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFs7ll { unsigned long long v1:7; signed short v2:7; signed char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFs7s { unsigned long long v1:7; signed short v2:7; signed char v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFu7c { unsigned long long v1:7; signed short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFu7i { unsigned long long v1:7; signed short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFu7ll { unsigned long long v1:7; signed short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFs7c_BFu7s { unsigned long long v1:7; signed short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFs7i { unsigned long long v1:7; signed short v2:7; signed int v3:7; };
struct BFu7ll_BFs7s_BFs7i_BFs7c { unsigned long long v1:7; signed short v2:7; signed int v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFs7i { unsigned long long v1:7; signed short v2:7; signed int v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFs7ll { unsigned long long v1:7; signed short v2:7; signed int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFs7s { unsigned long long v1:7; signed short v2:7; signed int v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFu7c { unsigned long long v1:7; signed short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFu7i { unsigned long long v1:7; signed short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFu7ll { unsigned long long v1:7; signed short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFs7i_BFu7s { unsigned long long v1:7; signed short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFs7ll { unsigned long long v1:7; signed short v2:7; signed long long v3:7; };
struct BFu7ll_BFs7s_BFs7ll_BFs7c { unsigned long long v1:7; signed short v2:7; signed long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFs7i { unsigned long long v1:7; signed short v2:7; signed long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFs7ll { unsigned long long v1:7; signed short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFs7s { unsigned long long v1:7; signed short v2:7; signed long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFu7c { unsigned long long v1:7; signed short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFu7i { unsigned long long v1:7; signed short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFu7ll { unsigned long long v1:7; signed short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFs7ll_BFu7s { unsigned long long v1:7; signed short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFs7s { unsigned long long v1:7; signed short v2:7; signed short v3:7; };
struct BFu7ll_BFs7s_BFs7s_BFs7c { unsigned long long v1:7; signed short v2:7; signed short v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFs7i { unsigned long long v1:7; signed short v2:7; signed short v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFs7ll { unsigned long long v1:7; signed short v2:7; signed short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFs7s { unsigned long long v1:7; signed short v2:7; signed short v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFu7c { unsigned long long v1:7; signed short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFu7i { unsigned long long v1:7; signed short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFu7ll { unsigned long long v1:7; signed short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFs7s_BFu7s { unsigned long long v1:7; signed short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFu7c { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; };
struct BFu7ll_BFs7s_BFu7c_BFs7c { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFs7i { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFs7ll { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFs7s { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFu7c { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFu7i { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFu7ll { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFu7c_BFu7s { unsigned long long v1:7; signed short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFu7i { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; };
struct BFu7ll_BFs7s_BFu7i_BFs7c { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFs7i { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFs7ll { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFs7s { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFu7c { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFu7i { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFu7ll { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFu7i_BFu7s { unsigned long long v1:7; signed short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFu7ll { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; };
struct BFu7ll_BFs7s_BFu7ll_BFs7c { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFs7i { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFs7ll { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFs7s { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFu7c { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFu7i { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFu7ll { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFu7ll_BFu7s { unsigned long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFu7ll_BFs7s_BFu7s { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; };
struct BFu7ll_BFs7s_BFu7s_BFs7c { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFs7i { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFs7ll { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFs7s { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFu7c { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFu7i { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFu7ll { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFu7ll_BFs7s_BFu7s_BFu7s { unsigned long long v1:7; signed short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFu7ll_BFu15i { unsigned long long v1:7; unsigned int v2:15; };
struct BFu7ll_BFu15i_BFu15i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:15; };
struct BFu7ll_BFu15i_BFu15ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:15; };
struct BFu7ll_BFu15i_BFu15s { unsigned long long v1:7; unsigned int v2:15; unsigned short v3:15; };
struct BFu7ll_BFu15i_BFu16i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:16; };
struct BFu7ll_BFu15i_BFu16ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:16; };
struct BFu7ll_BFu15i_BFu16s { unsigned long long v1:7; unsigned int v2:15; unsigned short v3:16; };
struct BFu7ll_BFu15i_BFu17i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:17; };
struct BFu7ll_BFu15i_BFu17ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:17; };
struct BFu7ll_BFu15i_BFu1c { unsigned long long v1:7; unsigned int v2:15; unsigned char v3:1; };
struct BFu7ll_BFu15i_BFu1i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:1; };
struct BFu7ll_BFu15i_BFu1ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:1; };
struct BFu7ll_BFu15i_BFu1s { unsigned long long v1:7; unsigned int v2:15; unsigned short v3:1; };
struct BFu7ll_BFu15i_BFu31i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:31; };
struct BFu7ll_BFu15i_BFu31ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:31; };
struct BFu7ll_BFu15i_BFu32i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:32; };
struct BFu7ll_BFu15i_BFu32ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:32; };
struct BFu7ll_BFu15i_BFu33 { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:33; };
struct BFu7ll_BFu15i_BFu7c { unsigned long long v1:7; unsigned int v2:15; unsigned char v3:7; };
struct BFu7ll_BFu15i_BFu7i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:7; };
struct BFu7ll_BFu15i_BFu7ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:7; };
struct BFu7ll_BFu15i_BFu7s { unsigned long long v1:7; unsigned int v2:15; unsigned short v3:7; };
struct BFu7ll_BFu15i_BFu8c { unsigned long long v1:7; unsigned int v2:15; unsigned char v3:8; };
struct BFu7ll_BFu15i_BFu8i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:8; };
struct BFu7ll_BFu15i_BFu8ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:8; };
struct BFu7ll_BFu15i_BFu8s { unsigned long long v1:7; unsigned int v2:15; unsigned short v3:8; };
struct BFu7ll_BFu15i_BFu9i { unsigned long long v1:7; unsigned int v2:15; unsigned int v3:9; };
struct BFu7ll_BFu15i_BFu9ll { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3:9; };
struct BFu7ll_BFu15i_BFu9s { unsigned long long v1:7; unsigned int v2:15; unsigned short v3:9; };
struct BFu7ll_BFu15i_C { unsigned long long v1:7; unsigned int v2:15; char v3; };
struct BFu7ll_BFu15i_D { unsigned long long v1:7; unsigned int v2:15; double v3; };
struct BFu7ll_BFu15i_F { unsigned long long v1:7; unsigned int v2:15; float v3; };
struct BFu7ll_BFu15i_I { unsigned long long v1:7; unsigned int v2:15; int v3; };
struct BFu7ll_BFu15i_Ip { unsigned long long v1:7; unsigned int v2:15; int * v3; };
struct BFu7ll_BFu15i_L { unsigned long long v1:7; unsigned int v2:15; long long v3; };
struct BFu7ll_BFu15i_S { unsigned long long v1:7; unsigned int v2:15; short v3; };
struct BFu7ll_BFu15i_Uc { unsigned long long v1:7; unsigned int v2:15; unsigned char v3; };
struct BFu7ll_BFu15i_Ui { unsigned long long v1:7; unsigned int v2:15; unsigned int v3; };
struct BFu7ll_BFu15i_Ul { unsigned long long v1:7; unsigned int v2:15; unsigned long long v3; };
struct BFu7ll_BFu15i_Us { unsigned long long v1:7; unsigned int v2:15; unsigned short v3; };
struct BFu7ll_BFu15i_Vp { unsigned long long v1:7; unsigned int v2:15; void * v3; };
struct BFu7ll_BFu15ll { unsigned long long v1:7; unsigned long long v2:15; };
struct BFu7ll_BFu15ll_BFu15i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:15; };
struct BFu7ll_BFu15ll_BFu15ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:15; };
struct BFu7ll_BFu15ll_BFu15s { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3:15; };
struct BFu7ll_BFu15ll_BFu16i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:16; };
struct BFu7ll_BFu15ll_BFu16ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:16; };
struct BFu7ll_BFu15ll_BFu16s { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3:16; };
struct BFu7ll_BFu15ll_BFu17i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:17; };
struct BFu7ll_BFu15ll_BFu17ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:17; };
struct BFu7ll_BFu15ll_BFu1c { unsigned long long v1:7; unsigned long long v2:15; unsigned char v3:1; };
struct BFu7ll_BFu15ll_BFu1i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:1; };
struct BFu7ll_BFu15ll_BFu1ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:1; };
struct BFu7ll_BFu15ll_BFu1s { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3:1; };
struct BFu7ll_BFu15ll_BFu31i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:31; };
struct BFu7ll_BFu15ll_BFu31ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:31; };
struct BFu7ll_BFu15ll_BFu32i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:32; };
struct BFu7ll_BFu15ll_BFu32ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:32; };
struct BFu7ll_BFu15ll_BFu33 { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:33; };
struct BFu7ll_BFu15ll_BFu7c { unsigned long long v1:7; unsigned long long v2:15; unsigned char v3:7; };
struct BFu7ll_BFu15ll_BFu7i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:7; };
struct BFu7ll_BFu15ll_BFu7ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:7; };
struct BFu7ll_BFu15ll_BFu7s { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3:7; };
struct BFu7ll_BFu15ll_BFu8c { unsigned long long v1:7; unsigned long long v2:15; unsigned char v3:8; };
struct BFu7ll_BFu15ll_BFu8i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:8; };
struct BFu7ll_BFu15ll_BFu8ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:8; };
struct BFu7ll_BFu15ll_BFu8s { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3:8; };
struct BFu7ll_BFu15ll_BFu9i { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3:9; };
struct BFu7ll_BFu15ll_BFu9ll { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3:9; };
struct BFu7ll_BFu15ll_BFu9s { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3:9; };
struct BFu7ll_BFu15ll_C { unsigned long long v1:7; unsigned long long v2:15; char v3; };
struct BFu7ll_BFu15ll_D { unsigned long long v1:7; unsigned long long v2:15; double v3; };
struct BFu7ll_BFu15ll_F { unsigned long long v1:7; unsigned long long v2:15; float v3; };
struct BFu7ll_BFu15ll_I { unsigned long long v1:7; unsigned long long v2:15; int v3; };
struct BFu7ll_BFu15ll_Ip { unsigned long long v1:7; unsigned long long v2:15; int * v3; };
struct BFu7ll_BFu15ll_L { unsigned long long v1:7; unsigned long long v2:15; long long v3; };
struct BFu7ll_BFu15ll_S { unsigned long long v1:7; unsigned long long v2:15; short v3; };
struct BFu7ll_BFu15ll_Uc { unsigned long long v1:7; unsigned long long v2:15; unsigned char v3; };
struct BFu7ll_BFu15ll_Ui { unsigned long long v1:7; unsigned long long v2:15; unsigned int v3; };
struct BFu7ll_BFu15ll_Ul { unsigned long long v1:7; unsigned long long v2:15; unsigned long long v3; };
struct BFu7ll_BFu15ll_Us { unsigned long long v1:7; unsigned long long v2:15; unsigned short v3; };
struct BFu7ll_BFu15ll_Vp { unsigned long long v1:7; unsigned long long v2:15; void * v3; };
struct BFu7ll_BFu15s { unsigned long long v1:7; unsigned short v2:15; };
struct BFu7ll_BFu15s_BFu15i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:15; };
struct BFu7ll_BFu15s_BFu15ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:15; };
struct BFu7ll_BFu15s_BFu15s { unsigned long long v1:7; unsigned short v2:15; unsigned short v3:15; };
struct BFu7ll_BFu15s_BFu16i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:16; };
struct BFu7ll_BFu15s_BFu16ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:16; };
struct BFu7ll_BFu15s_BFu16s { unsigned long long v1:7; unsigned short v2:15; unsigned short v3:16; };
struct BFu7ll_BFu15s_BFu17i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:17; };
struct BFu7ll_BFu15s_BFu17ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:17; };
struct BFu7ll_BFu15s_BFu1c { unsigned long long v1:7; unsigned short v2:15; unsigned char v3:1; };
struct BFu7ll_BFu15s_BFu1i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:1; };
struct BFu7ll_BFu15s_BFu1ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:1; };
struct BFu7ll_BFu15s_BFu1s { unsigned long long v1:7; unsigned short v2:15; unsigned short v3:1; };
struct BFu7ll_BFu15s_BFu31i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:31; };
struct BFu7ll_BFu15s_BFu31ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:31; };
struct BFu7ll_BFu15s_BFu32i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:32; };
struct BFu7ll_BFu15s_BFu32ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:32; };
struct BFu7ll_BFu15s_BFu33 { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:33; };
struct BFu7ll_BFu15s_BFu7c { unsigned long long v1:7; unsigned short v2:15; unsigned char v3:7; };
struct BFu7ll_BFu15s_BFu7i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:7; };
struct BFu7ll_BFu15s_BFu7ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:7; };
struct BFu7ll_BFu15s_BFu7s { unsigned long long v1:7; unsigned short v2:15; unsigned short v3:7; };
struct BFu7ll_BFu15s_BFu8c { unsigned long long v1:7; unsigned short v2:15; unsigned char v3:8; };
struct BFu7ll_BFu15s_BFu8i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:8; };
struct BFu7ll_BFu15s_BFu8ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:8; };
struct BFu7ll_BFu15s_BFu8s { unsigned long long v1:7; unsigned short v2:15; unsigned short v3:8; };
struct BFu7ll_BFu15s_BFu9i { unsigned long long v1:7; unsigned short v2:15; unsigned int v3:9; };
struct BFu7ll_BFu15s_BFu9ll { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3:9; };
struct BFu7ll_BFu15s_BFu9s { unsigned long long v1:7; unsigned short v2:15; unsigned short v3:9; };
struct BFu7ll_BFu15s_C { unsigned long long v1:7; unsigned short v2:15; char v3; };
struct BFu7ll_BFu15s_D { unsigned long long v1:7; unsigned short v2:15; double v3; };
struct BFu7ll_BFu15s_F { unsigned long long v1:7; unsigned short v2:15; float v3; };
struct BFu7ll_BFu15s_I { unsigned long long v1:7; unsigned short v2:15; int v3; };
struct BFu7ll_BFu15s_Ip { unsigned long long v1:7; unsigned short v2:15; int * v3; };
struct BFu7ll_BFu15s_L { unsigned long long v1:7; unsigned short v2:15; long long v3; };
struct BFu7ll_BFu15s_S { unsigned long long v1:7; unsigned short v2:15; short v3; };
struct BFu7ll_BFu15s_Uc { unsigned long long v1:7; unsigned short v2:15; unsigned char v3; };
struct BFu7ll_BFu15s_Ui { unsigned long long v1:7; unsigned short v2:15; unsigned int v3; };
struct BFu7ll_BFu15s_Ul { unsigned long long v1:7; unsigned short v2:15; unsigned long long v3; };
struct BFu7ll_BFu15s_Us { unsigned long long v1:7; unsigned short v2:15; unsigned short v3; };
struct BFu7ll_BFu15s_Vp { unsigned long long v1:7; unsigned short v2:15; void * v3; };
struct BFu7ll_BFu16i { unsigned long long v1:7; unsigned int v2:16; };
struct BFu7ll_BFu16i_BFu15i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:15; };
struct BFu7ll_BFu16i_BFu15ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:15; };
struct BFu7ll_BFu16i_BFu15s { unsigned long long v1:7; unsigned int v2:16; unsigned short v3:15; };
struct BFu7ll_BFu16i_BFu16i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:16; };
struct BFu7ll_BFu16i_BFu16ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:16; };
struct BFu7ll_BFu16i_BFu16s { unsigned long long v1:7; unsigned int v2:16; unsigned short v3:16; };
struct BFu7ll_BFu16i_BFu17i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:17; };
struct BFu7ll_BFu16i_BFu17ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:17; };
struct BFu7ll_BFu16i_BFu1c { unsigned long long v1:7; unsigned int v2:16; unsigned char v3:1; };
struct BFu7ll_BFu16i_BFu1i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:1; };
struct BFu7ll_BFu16i_BFu1ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:1; };
struct BFu7ll_BFu16i_BFu1s { unsigned long long v1:7; unsigned int v2:16; unsigned short v3:1; };
struct BFu7ll_BFu16i_BFu31i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:31; };
struct BFu7ll_BFu16i_BFu31ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:31; };
struct BFu7ll_BFu16i_BFu32i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:32; };
struct BFu7ll_BFu16i_BFu32ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:32; };
struct BFu7ll_BFu16i_BFu33 { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:33; };
struct BFu7ll_BFu16i_BFu7c { unsigned long long v1:7; unsigned int v2:16; unsigned char v3:7; };
struct BFu7ll_BFu16i_BFu7i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:7; };
struct BFu7ll_BFu16i_BFu7ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:7; };
struct BFu7ll_BFu16i_BFu7s { unsigned long long v1:7; unsigned int v2:16; unsigned short v3:7; };
struct BFu7ll_BFu16i_BFu8c { unsigned long long v1:7; unsigned int v2:16; unsigned char v3:8; };
struct BFu7ll_BFu16i_BFu8i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:8; };
struct BFu7ll_BFu16i_BFu8ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:8; };
struct BFu7ll_BFu16i_BFu8s { unsigned long long v1:7; unsigned int v2:16; unsigned short v3:8; };
struct BFu7ll_BFu16i_BFu9i { unsigned long long v1:7; unsigned int v2:16; unsigned int v3:9; };
struct BFu7ll_BFu16i_BFu9ll { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3:9; };
struct BFu7ll_BFu16i_BFu9s { unsigned long long v1:7; unsigned int v2:16; unsigned short v3:9; };
struct BFu7ll_BFu16i_C { unsigned long long v1:7; unsigned int v2:16; char v3; };
struct BFu7ll_BFu16i_D { unsigned long long v1:7; unsigned int v2:16; double v3; };
struct BFu7ll_BFu16i_F { unsigned long long v1:7; unsigned int v2:16; float v3; };
struct BFu7ll_BFu16i_I { unsigned long long v1:7; unsigned int v2:16; int v3; };
struct BFu7ll_BFu16i_Ip { unsigned long long v1:7; unsigned int v2:16; int * v3; };
struct BFu7ll_BFu16i_L { unsigned long long v1:7; unsigned int v2:16; long long v3; };
struct BFu7ll_BFu16i_S { unsigned long long v1:7; unsigned int v2:16; short v3; };
struct BFu7ll_BFu16i_Uc { unsigned long long v1:7; unsigned int v2:16; unsigned char v3; };
struct BFu7ll_BFu16i_Ui { unsigned long long v1:7; unsigned int v2:16; unsigned int v3; };
struct BFu7ll_BFu16i_Ul { unsigned long long v1:7; unsigned int v2:16; unsigned long long v3; };
struct BFu7ll_BFu16i_Us { unsigned long long v1:7; unsigned int v2:16; unsigned short v3; };
struct BFu7ll_BFu16i_Vp { unsigned long long v1:7; unsigned int v2:16; void * v3; };
struct BFu7ll_BFu16ll { unsigned long long v1:7; unsigned long long v2:16; };
struct BFu7ll_BFu16ll_BFu15i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:15; };
struct BFu7ll_BFu16ll_BFu15ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:15; };
struct BFu7ll_BFu16ll_BFu15s { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3:15; };
struct BFu7ll_BFu16ll_BFu16i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:16; };
struct BFu7ll_BFu16ll_BFu16ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:16; };
struct BFu7ll_BFu16ll_BFu16s { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3:16; };
struct BFu7ll_BFu16ll_BFu17i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:17; };
struct BFu7ll_BFu16ll_BFu17ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:17; };
struct BFu7ll_BFu16ll_BFu1c { unsigned long long v1:7; unsigned long long v2:16; unsigned char v3:1; };
struct BFu7ll_BFu16ll_BFu1i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:1; };
struct BFu7ll_BFu16ll_BFu1ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:1; };
struct BFu7ll_BFu16ll_BFu1s { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3:1; };
struct BFu7ll_BFu16ll_BFu31i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:31; };
struct BFu7ll_BFu16ll_BFu31ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:31; };
struct BFu7ll_BFu16ll_BFu32i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:32; };
struct BFu7ll_BFu16ll_BFu32ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:32; };
struct BFu7ll_BFu16ll_BFu33 { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:33; };
struct BFu7ll_BFu16ll_BFu7c { unsigned long long v1:7; unsigned long long v2:16; unsigned char v3:7; };
struct BFu7ll_BFu16ll_BFu7i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:7; };
struct BFu7ll_BFu16ll_BFu7ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:7; };
struct BFu7ll_BFu16ll_BFu7s { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3:7; };
struct BFu7ll_BFu16ll_BFu8c { unsigned long long v1:7; unsigned long long v2:16; unsigned char v3:8; };
struct BFu7ll_BFu16ll_BFu8i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:8; };
struct BFu7ll_BFu16ll_BFu8ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:8; };
struct BFu7ll_BFu16ll_BFu8s { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3:8; };
struct BFu7ll_BFu16ll_BFu9i { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3:9; };
struct BFu7ll_BFu16ll_BFu9ll { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3:9; };
struct BFu7ll_BFu16ll_BFu9s { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3:9; };
struct BFu7ll_BFu16ll_C { unsigned long long v1:7; unsigned long long v2:16; char v3; };
struct BFu7ll_BFu16ll_D { unsigned long long v1:7; unsigned long long v2:16; double v3; };
struct BFu7ll_BFu16ll_F { unsigned long long v1:7; unsigned long long v2:16; float v3; };
struct BFu7ll_BFu16ll_I { unsigned long long v1:7; unsigned long long v2:16; int v3; };
struct BFu7ll_BFu16ll_Ip { unsigned long long v1:7; unsigned long long v2:16; int * v3; };
struct BFu7ll_BFu16ll_L { unsigned long long v1:7; unsigned long long v2:16; long long v3; };
struct BFu7ll_BFu16ll_S { unsigned long long v1:7; unsigned long long v2:16; short v3; };
struct BFu7ll_BFu16ll_Uc { unsigned long long v1:7; unsigned long long v2:16; unsigned char v3; };
struct BFu7ll_BFu16ll_Ui { unsigned long long v1:7; unsigned long long v2:16; unsigned int v3; };
struct BFu7ll_BFu16ll_Ul { unsigned long long v1:7; unsigned long long v2:16; unsigned long long v3; };
struct BFu7ll_BFu16ll_Us { unsigned long long v1:7; unsigned long long v2:16; unsigned short v3; };
struct BFu7ll_BFu16ll_Vp { unsigned long long v1:7; unsigned long long v2:16; void * v3; };
struct BFu7ll_BFu16s { unsigned long long v1:7; unsigned short v2:16; };
struct BFu7ll_BFu16s_BFu15i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:15; };
struct BFu7ll_BFu16s_BFu15ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:15; };
struct BFu7ll_BFu16s_BFu15s { unsigned long long v1:7; unsigned short v2:16; unsigned short v3:15; };
struct BFu7ll_BFu16s_BFu16i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:16; };
struct BFu7ll_BFu16s_BFu16ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:16; };
struct BFu7ll_BFu16s_BFu16s { unsigned long long v1:7; unsigned short v2:16; unsigned short v3:16; };
struct BFu7ll_BFu16s_BFu17i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:17; };
struct BFu7ll_BFu16s_BFu17ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:17; };
struct BFu7ll_BFu16s_BFu1c { unsigned long long v1:7; unsigned short v2:16; unsigned char v3:1; };
struct BFu7ll_BFu16s_BFu1i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:1; };
struct BFu7ll_BFu16s_BFu1ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:1; };
struct BFu7ll_BFu16s_BFu1s { unsigned long long v1:7; unsigned short v2:16; unsigned short v3:1; };
struct BFu7ll_BFu16s_BFu31i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:31; };
struct BFu7ll_BFu16s_BFu31ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:31; };
struct BFu7ll_BFu16s_BFu32i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:32; };
struct BFu7ll_BFu16s_BFu32ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:32; };
struct BFu7ll_BFu16s_BFu33 { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:33; };
struct BFu7ll_BFu16s_BFu7c { unsigned long long v1:7; unsigned short v2:16; unsigned char v3:7; };
struct BFu7ll_BFu16s_BFu7i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:7; };
struct BFu7ll_BFu16s_BFu7ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:7; };
struct BFu7ll_BFu16s_BFu7s { unsigned long long v1:7; unsigned short v2:16; unsigned short v3:7; };
struct BFu7ll_BFu16s_BFu8c { unsigned long long v1:7; unsigned short v2:16; unsigned char v3:8; };
struct BFu7ll_BFu16s_BFu8i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:8; };
struct BFu7ll_BFu16s_BFu8ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:8; };
struct BFu7ll_BFu16s_BFu8s { unsigned long long v1:7; unsigned short v2:16; unsigned short v3:8; };
struct BFu7ll_BFu16s_BFu9i { unsigned long long v1:7; unsigned short v2:16; unsigned int v3:9; };
struct BFu7ll_BFu16s_BFu9ll { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3:9; };
struct BFu7ll_BFu16s_BFu9s { unsigned long long v1:7; unsigned short v2:16; unsigned short v3:9; };
struct BFu7ll_BFu16s_C { unsigned long long v1:7; unsigned short v2:16; char v3; };
struct BFu7ll_BFu16s_D { unsigned long long v1:7; unsigned short v2:16; double v3; };
struct BFu7ll_BFu16s_F { unsigned long long v1:7; unsigned short v2:16; float v3; };
struct BFu7ll_BFu16s_I { unsigned long long v1:7; unsigned short v2:16; int v3; };
struct BFu7ll_BFu16s_Ip { unsigned long long v1:7; unsigned short v2:16; int * v3; };
struct BFu7ll_BFu16s_L { unsigned long long v1:7; unsigned short v2:16; long long v3; };
struct BFu7ll_BFu16s_S { unsigned long long v1:7; unsigned short v2:16; short v3; };
struct BFu7ll_BFu16s_Uc { unsigned long long v1:7; unsigned short v2:16; unsigned char v3; };
struct BFu7ll_BFu16s_Ui { unsigned long long v1:7; unsigned short v2:16; unsigned int v3; };
struct BFu7ll_BFu16s_Ul { unsigned long long v1:7; unsigned short v2:16; unsigned long long v3; };
struct BFu7ll_BFu16s_Us { unsigned long long v1:7; unsigned short v2:16; unsigned short v3; };
struct BFu7ll_BFu16s_Vp { unsigned long long v1:7; unsigned short v2:16; void * v3; };
struct BFu7ll_BFu17i { unsigned long long v1:7; unsigned int v2:17; };
struct BFu7ll_BFu17i_BFu15i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:15; };
struct BFu7ll_BFu17i_BFu15ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:15; };
struct BFu7ll_BFu17i_BFu15s { unsigned long long v1:7; unsigned int v2:17; unsigned short v3:15; };
struct BFu7ll_BFu17i_BFu16i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:16; };
struct BFu7ll_BFu17i_BFu16ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:16; };
struct BFu7ll_BFu17i_BFu16s { unsigned long long v1:7; unsigned int v2:17; unsigned short v3:16; };
struct BFu7ll_BFu17i_BFu17i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:17; };
struct BFu7ll_BFu17i_BFu17ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:17; };
struct BFu7ll_BFu17i_BFu1c { unsigned long long v1:7; unsigned int v2:17; unsigned char v3:1; };
struct BFu7ll_BFu17i_BFu1i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:1; };
struct BFu7ll_BFu17i_BFu1ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:1; };
struct BFu7ll_BFu17i_BFu1s { unsigned long long v1:7; unsigned int v2:17; unsigned short v3:1; };
struct BFu7ll_BFu17i_BFu31i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:31; };
struct BFu7ll_BFu17i_BFu31ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:31; };
struct BFu7ll_BFu17i_BFu32i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:32; };
struct BFu7ll_BFu17i_BFu32ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:32; };
struct BFu7ll_BFu17i_BFu33 { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:33; };
struct BFu7ll_BFu17i_BFu7c { unsigned long long v1:7; unsigned int v2:17; unsigned char v3:7; };
struct BFu7ll_BFu17i_BFu7i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:7; };
struct BFu7ll_BFu17i_BFu7ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:7; };
struct BFu7ll_BFu17i_BFu7s { unsigned long long v1:7; unsigned int v2:17; unsigned short v3:7; };
struct BFu7ll_BFu17i_BFu8c { unsigned long long v1:7; unsigned int v2:17; unsigned char v3:8; };
struct BFu7ll_BFu17i_BFu8i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:8; };
struct BFu7ll_BFu17i_BFu8ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:8; };
struct BFu7ll_BFu17i_BFu8s { unsigned long long v1:7; unsigned int v2:17; unsigned short v3:8; };
struct BFu7ll_BFu17i_BFu9i { unsigned long long v1:7; unsigned int v2:17; unsigned int v3:9; };
struct BFu7ll_BFu17i_BFu9ll { unsigned long long v1:7; unsigned int v2:17; unsigned long long v3:9; };
struct BFu7ll_BFu17i_BFu9s { unsigned long long v1:7; unsigned int v2:17; unsigned short v3:9; };
struct BFu7ll_BFu17i_C { unsigned long long v1:7; unsigned int v2:17; char v3; };
struct BFu7ll_BFu17i_D { unsigned long long v1:7; unsigned int v2:17; double v3; };
struct BFu7ll_BFu17i_F { unsigned long long v1:7; unsigned int v2:17; float v3; };


static void Test_BFu7c_S_BFu8c()
{
  {
    init_simple_test("BFu7c_S_BFu8c");
    static STRUCT_IF_C BFu7c_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_S_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu8c, BFu7c_S_BFu8c)
//============================================================================



static void Test_BFu7c_S_BFu8i()
{
  {
    init_simple_test("BFu7c_S_BFu8i");
    static STRUCT_IF_C BFu7c_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_S_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu8i, BFu7c_S_BFu8i)
//============================================================================



static void Test_BFu7c_S_BFu8ll()
{
  {
    init_simple_test("BFu7c_S_BFu8ll");
    static STRUCT_IF_C BFu7c_S_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_S_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu8ll, BFu7c_S_BFu8ll)
//============================================================================



static void Test_BFu7c_S_BFu8s()
{
  {
    init_simple_test("BFu7c_S_BFu8s");
    static STRUCT_IF_C BFu7c_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_S_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu8s, BFu7c_S_BFu8s)
//============================================================================



static void Test_BFu7c_S_BFu9i()
{
  {
    init_simple_test("BFu7c_S_BFu9i");
    static STRUCT_IF_C BFu7c_S_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7c_S_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7c_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu9i, BFu7c_S_BFu9i)
//============================================================================



static void Test_BFu7c_S_BFu9ll()
{
  {
    init_simple_test("BFu7c_S_BFu9ll");
    static STRUCT_IF_C BFu7c_S_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7c_S_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7c_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu9ll, BFu7c_S_BFu9ll)
//============================================================================



static void Test_BFu7c_S_BFu9s()
{
  {
    init_simple_test("BFu7c_S_BFu9s");
    static STRUCT_IF_C BFu7c_S_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7c_S_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7c_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu9s, BFu7c_S_BFu9s)
//============================================================================



static void Test_BFu7c_S_C()
{
  {
    init_simple_test("BFu7c_S_C");
    static STRUCT_IF_C BFu7c_S_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_C");
    check_field_offset(lv, v2, 1, "BFu7c_S_C.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_C, BFu7c_S_C)
//============================================================================



static void Test_BFu7c_S_D()
{
  {
    init_simple_test("BFu7c_S_D");
    static STRUCT_IF_C BFu7c_S_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_D");
    check_field_offset(lv, v2, 1, "BFu7c_S_D.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_D, BFu7c_S_D)
//============================================================================



static void Test_BFu7c_S_F()
{
  {
    init_simple_test("BFu7c_S_F");
    static STRUCT_IF_C BFu7c_S_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_F");
    check_field_offset(lv, v2, 1, "BFu7c_S_F.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_F, BFu7c_S_F)
//============================================================================



static void Test_BFu7c_S_I()
{
  {
    init_simple_test("BFu7c_S_I");
    static STRUCT_IF_C BFu7c_S_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_I");
    check_field_offset(lv, v2, 1, "BFu7c_S_I.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_I, BFu7c_S_I)
//============================================================================



static void Test_BFu7c_S_Ip()
{
  {
    init_simple_test("BFu7c_S_Ip");
    static STRUCT_IF_C BFu7c_S_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_S_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Ip, BFu7c_S_Ip)
//============================================================================



static void Test_BFu7c_S_L()
{
  {
    init_simple_test("BFu7c_S_L");
    static STRUCT_IF_C BFu7c_S_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_L");
    check_field_offset(lv, v2, 1, "BFu7c_S_L.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_L, BFu7c_S_L)
//============================================================================



static void Test_BFu7c_S_S()
{
  {
    init_simple_test("BFu7c_S_S");
    static STRUCT_IF_C BFu7c_S_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_S");
    check_field_offset(lv, v2, 1, "BFu7c_S_S.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_S, BFu7c_S_S)
//============================================================================



static void Test_BFu7c_S_Uc()
{
  {
    init_simple_test("BFu7c_S_Uc");
    static STRUCT_IF_C BFu7c_S_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_S_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Uc, BFu7c_S_Uc)
//============================================================================



static void Test_BFu7c_S_Ui()
{
  {
    init_simple_test("BFu7c_S_Ui");
    static STRUCT_IF_C BFu7c_S_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_S_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Ui, BFu7c_S_Ui)
//============================================================================



static void Test_BFu7c_S_Ul()
{
  {
    init_simple_test("BFu7c_S_Ul");
    static STRUCT_IF_C BFu7c_S_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_S_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Ul, BFu7c_S_Ul)
//============================================================================



static void Test_BFu7c_S_Us()
{
  {
    init_simple_test("BFu7c_S_Us");
    static STRUCT_IF_C BFu7c_S_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Us");
    check_field_offset(lv, v2, 1, "BFu7c_S_Us.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Us, BFu7c_S_Us)
//============================================================================



static void Test_BFu7c_S_Vp()
{
  {
    init_simple_test("BFu7c_S_Vp");
    static STRUCT_IF_C BFu7c_S_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_S_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Vp, BFu7c_S_Vp)
//============================================================================



static void Test_BFu7c_Uc()
{
  {
    init_simple_test("BFu7c_Uc");
    static STRUCT_IF_C BFu7c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc, BFu7c_Uc)
//============================================================================



static void Test_BFu7c_Uc_BFu15i()
{
  {
    init_simple_test("BFu7c_Uc_BFu15i");
    static STRUCT_IF_C BFu7c_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7c_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu15i, BFu7c_Uc_BFu15i)
//============================================================================



static void Test_BFu7c_Uc_BFu15ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu15ll");
    static STRUCT_IF_C BFu7c_Uc_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7c_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu15ll, BFu7c_Uc_BFu15ll)
//============================================================================



static void Test_BFu7c_Uc_BFu15s()
{
  {
    init_simple_test("BFu7c_Uc_BFu15s");
    static STRUCT_IF_C BFu7c_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7c_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu15s, BFu7c_Uc_BFu15s)
//============================================================================



static void Test_BFu7c_Uc_BFu16i()
{
  {
    init_simple_test("BFu7c_Uc_BFu16i");
    static STRUCT_IF_C BFu7c_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7c_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu16i, BFu7c_Uc_BFu16i)
//============================================================================



static void Test_BFu7c_Uc_BFu16ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu16ll");
    static STRUCT_IF_C BFu7c_Uc_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7c_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu16ll, BFu7c_Uc_BFu16ll)
//============================================================================



static void Test_BFu7c_Uc_BFu16s()
{
  {
    init_simple_test("BFu7c_Uc_BFu16s");
    static STRUCT_IF_C BFu7c_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7c_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu16s, BFu7c_Uc_BFu16s)
//============================================================================



static void Test_BFu7c_Uc_BFu17i()
{
  {
    init_simple_test("BFu7c_Uc_BFu17i");
    static STRUCT_IF_C BFu7c_Uc_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu7c_Uc_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu7c_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu17i, BFu7c_Uc_BFu17i)
//============================================================================



static void Test_BFu7c_Uc_BFu17ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu17ll");
    static STRUCT_IF_C BFu7c_Uc_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu7c_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu7c_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu17ll, BFu7c_Uc_BFu17ll)
//============================================================================



static void Test_BFu7c_Uc_BFu1c()
{
  {
    init_simple_test("BFu7c_Uc_BFu1c");
    static STRUCT_IF_C BFu7c_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu1c, BFu7c_Uc_BFu1c)
//============================================================================



static void Test_BFu7c_Uc_BFu1i()
{
  {
    init_simple_test("BFu7c_Uc_BFu1i");
    static STRUCT_IF_C BFu7c_Uc_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu1i, BFu7c_Uc_BFu1i)
//============================================================================



static void Test_BFu7c_Uc_BFu1ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu1ll");
    static STRUCT_IF_C BFu7c_Uc_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu1ll, BFu7c_Uc_BFu1ll)
//============================================================================



static void Test_BFu7c_Uc_BFu1s()
{
  {
    init_simple_test("BFu7c_Uc_BFu1s");
    static STRUCT_IF_C BFu7c_Uc_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu1s, BFu7c_Uc_BFu1s)
//============================================================================



static void Test_BFu7c_Uc_BFu31i()
{
  {
    init_simple_test("BFu7c_Uc_BFu31i");
    static STRUCT_IF_C BFu7c_Uc_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu7c_Uc_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu7c_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu31i, BFu7c_Uc_BFu31i)
//============================================================================



static void Test_BFu7c_Uc_BFu31ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu31ll");
    static STRUCT_IF_C BFu7c_Uc_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu7c_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu7c_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu31ll, BFu7c_Uc_BFu31ll)
//============================================================================



static void Test_BFu7c_Uc_BFu32i()
{
  {
    init_simple_test("BFu7c_Uc_BFu32i");
    static STRUCT_IF_C BFu7c_Uc_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu7c_Uc_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu7c_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu32i, BFu7c_Uc_BFu32i)
//============================================================================



static void Test_BFu7c_Uc_BFu32ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu32ll");
    static STRUCT_IF_C BFu7c_Uc_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu7c_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu7c_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu32ll, BFu7c_Uc_BFu32ll)
//============================================================================



static void Test_BFu7c_Uc_BFu33()
{
  {
    init_simple_test("BFu7c_Uc_BFu33");
    static STRUCT_IF_C BFu7c_Uc_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu7c_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu7c_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu33, BFu7c_Uc_BFu33)
//============================================================================



static void Test_BFu7c_Uc_BFu7c()
{
  {
    init_simple_test("BFu7c_Uc_BFu7c");
    static STRUCT_IF_C BFu7c_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu7c, BFu7c_Uc_BFu7c)
//============================================================================



static void Test_BFu7c_Uc_BFu7i()
{
  {
    init_simple_test("BFu7c_Uc_BFu7i");
    static STRUCT_IF_C BFu7c_Uc_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu7i, BFu7c_Uc_BFu7i)
//============================================================================



static void Test_BFu7c_Uc_BFu7ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu7ll");
    static STRUCT_IF_C BFu7c_Uc_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu7ll, BFu7c_Uc_BFu7ll)
//============================================================================



static void Test_BFu7c_Uc_BFu7s()
{
  {
    init_simple_test("BFu7c_Uc_BFu7s");
    static STRUCT_IF_C BFu7c_Uc_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu7s, BFu7c_Uc_BFu7s)
//============================================================================



static void Test_BFu7c_Uc_BFu8c()
{
  {
    init_simple_test("BFu7c_Uc_BFu8c");
    static STRUCT_IF_C BFu7c_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu8c, BFu7c_Uc_BFu8c)
//============================================================================



static void Test_BFu7c_Uc_BFu8i()
{
  {
    init_simple_test("BFu7c_Uc_BFu8i");
    static STRUCT_IF_C BFu7c_Uc_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu8i, BFu7c_Uc_BFu8i)
//============================================================================



static void Test_BFu7c_Uc_BFu8ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu8ll");
    static STRUCT_IF_C BFu7c_Uc_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu8ll, BFu7c_Uc_BFu8ll)
//============================================================================



static void Test_BFu7c_Uc_BFu8s()
{
  {
    init_simple_test("BFu7c_Uc_BFu8s");
    static STRUCT_IF_C BFu7c_Uc_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu8s, BFu7c_Uc_BFu8s)
//============================================================================



static void Test_BFu7c_Uc_BFu9i()
{
  {
    init_simple_test("BFu7c_Uc_BFu9i");
    static STRUCT_IF_C BFu7c_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7c_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu9i, BFu7c_Uc_BFu9i)
//============================================================================



static void Test_BFu7c_Uc_BFu9ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu9ll");
    static STRUCT_IF_C BFu7c_Uc_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7c_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu9ll, BFu7c_Uc_BFu9ll)
//============================================================================



static void Test_BFu7c_Uc_BFu9s()
{
  {
    init_simple_test("BFu7c_Uc_BFu9s");
    static STRUCT_IF_C BFu7c_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7c_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu9s, BFu7c_Uc_BFu9s)
//============================================================================



static void Test_BFu7c_Uc_C()
{
  {
    init_simple_test("BFu7c_Uc_C");
    static STRUCT_IF_C BFu7c_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_C");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_C.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_C, BFu7c_Uc_C)
//============================================================================



static void Test_BFu7c_Uc_D()
{
  {
    init_simple_test("BFu7c_Uc_D");
    static STRUCT_IF_C BFu7c_Uc_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_D");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_D.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_D, BFu7c_Uc_D)
//============================================================================



static void Test_BFu7c_Uc_F()
{
  {
    init_simple_test("BFu7c_Uc_F");
    static STRUCT_IF_C BFu7c_Uc_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_F");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_F.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_F, BFu7c_Uc_F)
//============================================================================



static void Test_BFu7c_Uc_I()
{
  {
    init_simple_test("BFu7c_Uc_I");
    static STRUCT_IF_C BFu7c_Uc_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_I");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_I.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_I, BFu7c_Uc_I)
//============================================================================



static void Test_BFu7c_Uc_Ip()
{
  {
    init_simple_test("BFu7c_Uc_Ip");
    static STRUCT_IF_C BFu7c_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Ip.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Ip, BFu7c_Uc_Ip)
//============================================================================



static void Test_BFu7c_Uc_L()
{
  {
    init_simple_test("BFu7c_Uc_L");
    static STRUCT_IF_C BFu7c_Uc_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_L");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_L.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_L, BFu7c_Uc_L)
//============================================================================



static void Test_BFu7c_Uc_S()
{
  {
    init_simple_test("BFu7c_Uc_S");
    static STRUCT_IF_C BFu7c_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_S");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_S.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_S, BFu7c_Uc_S)
//============================================================================



static void Test_BFu7c_Uc_Uc()
{
  {
    init_simple_test("BFu7c_Uc_Uc");
    static STRUCT_IF_C BFu7c_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Uc, BFu7c_Uc_Uc)
//============================================================================



static void Test_BFu7c_Uc_Ui()
{
  {
    init_simple_test("BFu7c_Uc_Ui");
    static STRUCT_IF_C BFu7c_Uc_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Ui.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Ui, BFu7c_Uc_Ui)
//============================================================================



static void Test_BFu7c_Uc_Ul()
{
  {
    init_simple_test("BFu7c_Uc_Ul");
    static STRUCT_IF_C BFu7c_Uc_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Ul.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Ul, BFu7c_Uc_Ul)
//============================================================================



static void Test_BFu7c_Uc_Us()
{
  {
    init_simple_test("BFu7c_Uc_Us");
    static STRUCT_IF_C BFu7c_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Us, BFu7c_Uc_Us)
//============================================================================



static void Test_BFu7c_Uc_Vp()
{
  {
    init_simple_test("BFu7c_Uc_Vp");
    static STRUCT_IF_C BFu7c_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Vp.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Vp, BFu7c_Uc_Vp)
//============================================================================



static void Test_BFu7c_Ui()
{
  {
    init_simple_test("BFu7c_Ui");
    static STRUCT_IF_C BFu7c_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui, BFu7c_Ui)
//============================================================================



static void Test_BFu7c_Ui_BFu15i()
{
  {
    init_simple_test("BFu7c_Ui_BFu15i");
    static STRUCT_IF_C BFu7c_Ui_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu7c_Ui_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu7c_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu15i, BFu7c_Ui_BFu15i)
//============================================================================



static void Test_BFu7c_Ui_BFu15ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu15ll");
    static STRUCT_IF_C BFu7c_Ui_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu7c_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu7c_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu15ll, BFu7c_Ui_BFu15ll)
//============================================================================



static void Test_BFu7c_Ui_BFu15s()
{
  {
    init_simple_test("BFu7c_Ui_BFu15s");
    static STRUCT_IF_C BFu7c_Ui_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu7c_Ui_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu7c_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu15s, BFu7c_Ui_BFu15s)
//============================================================================



static void Test_BFu7c_Ui_BFu16i()
{
  {
    init_simple_test("BFu7c_Ui_BFu16i");
    static STRUCT_IF_C BFu7c_Ui_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu7c_Ui_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu7c_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu16i, BFu7c_Ui_BFu16i)
//============================================================================



static void Test_BFu7c_Ui_BFu16ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu16ll");
    static STRUCT_IF_C BFu7c_Ui_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu7c_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu7c_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu16ll, BFu7c_Ui_BFu16ll)
//============================================================================



static void Test_BFu7c_Ui_BFu16s()
{
  {
    init_simple_test("BFu7c_Ui_BFu16s");
    static STRUCT_IF_C BFu7c_Ui_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu7c_Ui_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu7c_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu16s, BFu7c_Ui_BFu16s)
//============================================================================



static void Test_BFu7c_Ui_BFu17i()
{
  {
    init_simple_test("BFu7c_Ui_BFu17i");
    static STRUCT_IF_C BFu7c_Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu7c_Ui_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu7c_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu17i, BFu7c_Ui_BFu17i)
//============================================================================



static void Test_BFu7c_Ui_BFu17ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu17ll");
    static STRUCT_IF_C BFu7c_Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu7c_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu7c_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu17ll, BFu7c_Ui_BFu17ll)
//============================================================================



static void Test_BFu7c_Ui_BFu1c()
{
  {
    init_simple_test("BFu7c_Ui_BFu1c");
    static STRUCT_IF_C BFu7c_Ui_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu7c_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu1c, BFu7c_Ui_BFu1c)
//============================================================================



static void Test_BFu7c_Ui_BFu1i()
{
  {
    init_simple_test("BFu7c_Ui_BFu1i");
    static STRUCT_IF_C BFu7c_Ui_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu7c_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu1i, BFu7c_Ui_BFu1i)
//============================================================================



static void Test_BFu7c_Ui_BFu1ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu1ll");
    static STRUCT_IF_C BFu7c_Ui_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu7c_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu1ll, BFu7c_Ui_BFu1ll)
//============================================================================



static void Test_BFu7c_Ui_BFu1s()
{
  {
    init_simple_test("BFu7c_Ui_BFu1s");
    static STRUCT_IF_C BFu7c_Ui_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu7c_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu1s, BFu7c_Ui_BFu1s)
//============================================================================



static void Test_BFu7c_Ui_BFu31i()
{
  {
    init_simple_test("BFu7c_Ui_BFu31i");
    static STRUCT_IF_C BFu7c_Ui_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "BFu7c_Ui_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "BFu7c_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu31i, BFu7c_Ui_BFu31i)
//============================================================================



static void Test_BFu7c_Ui_BFu31ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu31ll");
    static STRUCT_IF_C BFu7c_Ui_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "BFu7c_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "BFu7c_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu31ll, BFu7c_Ui_BFu31ll)
//============================================================================



static void Test_BFu7c_Ui_BFu32i()
{
  {
    init_simple_test("BFu7c_Ui_BFu32i");
    static STRUCT_IF_C BFu7c_Ui_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "BFu7c_Ui_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "BFu7c_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu32i, BFu7c_Ui_BFu32i)
//============================================================================



static void Test_BFu7c_Ui_BFu32ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu32ll");
    static STRUCT_IF_C BFu7c_Ui_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "BFu7c_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "BFu7c_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu32ll, BFu7c_Ui_BFu32ll)
//============================================================================



static void Test_BFu7c_Ui_BFu33()
{
  {
    init_simple_test("BFu7c_Ui_BFu33");
    static STRUCT_IF_C BFu7c_Ui_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "BFu7c_Ui_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "BFu7c_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu33, BFu7c_Ui_BFu33)
//============================================================================



static void Test_BFu7c_Ui_BFu7c()
{
  {
    init_simple_test("BFu7c_Ui_BFu7c");
    static STRUCT_IF_C BFu7c_Ui_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu7c_Ui_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu7c, BFu7c_Ui_BFu7c)
//============================================================================



static void Test_BFu7c_Ui_BFu7i()
{
  {
    init_simple_test("BFu7c_Ui_BFu7i");
    static STRUCT_IF_C BFu7c_Ui_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu7c_Ui_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu7i, BFu7c_Ui_BFu7i)
//============================================================================



static void Test_BFu7c_Ui_BFu7ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu7ll");
    static STRUCT_IF_C BFu7c_Ui_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu7c_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu7ll, BFu7c_Ui_BFu7ll)
//============================================================================



static void Test_BFu7c_Ui_BFu7s()
{
  {
    init_simple_test("BFu7c_Ui_BFu7s");
    static STRUCT_IF_C BFu7c_Ui_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu7c_Ui_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu7s, BFu7c_Ui_BFu7s)
//============================================================================



static void Test_BFu7c_Ui_BFu8c()
{
  {
    init_simple_test("BFu7c_Ui_BFu8c");
    static STRUCT_IF_C BFu7c_Ui_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu7c_Ui_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu7c_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu8c, BFu7c_Ui_BFu8c)
//============================================================================



static void Test_BFu7c_Ui_BFu8i()
{
  {
    init_simple_test("BFu7c_Ui_BFu8i");
    static STRUCT_IF_C BFu7c_Ui_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu7c_Ui_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu7c_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu8i, BFu7c_Ui_BFu8i)
//============================================================================



static void Test_BFu7c_Ui_BFu8ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu8ll");
    static STRUCT_IF_C BFu7c_Ui_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu7c_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu7c_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu8ll, BFu7c_Ui_BFu8ll)
//============================================================================



static void Test_BFu7c_Ui_BFu8s()
{
  {
    init_simple_test("BFu7c_Ui_BFu8s");
    static STRUCT_IF_C BFu7c_Ui_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu7c_Ui_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu7c_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu8s, BFu7c_Ui_BFu8s)
//============================================================================



static void Test_BFu7c_Ui_BFu9i()
{
  {
    init_simple_test("BFu7c_Ui_BFu9i");
    static STRUCT_IF_C BFu7c_Ui_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu7c_Ui_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu7c_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu9i, BFu7c_Ui_BFu9i)
//============================================================================



static void Test_BFu7c_Ui_BFu9ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu9ll");
    static STRUCT_IF_C BFu7c_Ui_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu7c_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu7c_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu9ll, BFu7c_Ui_BFu9ll)
//============================================================================



static void Test_BFu7c_Ui_BFu9s()
{
  {
    init_simple_test("BFu7c_Ui_BFu9s");
    static STRUCT_IF_C BFu7c_Ui_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu7c_Ui_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu7c_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu9s, BFu7c_Ui_BFu9s)
//============================================================================



static void Test_BFu7c_Ui_C()
{
  {
    init_simple_test("BFu7c_Ui_C");
    static STRUCT_IF_C BFu7c_Ui_C lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_C");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_C.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_C, BFu7c_Ui_C)
//============================================================================



static void Test_BFu7c_Ui_D()
{
  {
    init_simple_test("BFu7c_Ui_D");
    static STRUCT_IF_C BFu7c_Ui_D lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_D");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_D.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_D, BFu7c_Ui_D)
//============================================================================



static void Test_BFu7c_Ui_F()
{
  {
    init_simple_test("BFu7c_Ui_F");
    static STRUCT_IF_C BFu7c_Ui_F lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_F");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_F.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_F, BFu7c_Ui_F)
//============================================================================



static void Test_BFu7c_Ui_I()
{
  {
    init_simple_test("BFu7c_Ui_I");
    static STRUCT_IF_C BFu7c_Ui_I lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_I");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_I.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_I, BFu7c_Ui_I)
//============================================================================



static void Test_BFu7c_Ui_Ip()
{
  {
    init_simple_test("BFu7c_Ui_Ip");
    static STRUCT_IF_C BFu7c_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Ip.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Ip, BFu7c_Ui_Ip)
//============================================================================



static void Test_BFu7c_Ui_L()
{
  {
    init_simple_test("BFu7c_Ui_L");
    static STRUCT_IF_C BFu7c_Ui_L lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_L");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_L.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_L, BFu7c_Ui_L)
//============================================================================



static void Test_BFu7c_Ui_S()
{
  {
    init_simple_test("BFu7c_Ui_S");
    static STRUCT_IF_C BFu7c_Ui_S lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_S");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_S.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_S, BFu7c_Ui_S)
//============================================================================



static void Test_BFu7c_Ui_Uc()
{
  {
    init_simple_test("BFu7c_Ui_Uc");
    static STRUCT_IF_C BFu7c_Ui_Uc lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Uc.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Uc, BFu7c_Ui_Uc)
//============================================================================



static void Test_BFu7c_Ui_Ui()
{
  {
    init_simple_test("BFu7c_Ui_Ui");
    static STRUCT_IF_C BFu7c_Ui_Ui lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Ui.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Ui, BFu7c_Ui_Ui)
//============================================================================



static void Test_BFu7c_Ui_Ul()
{
  {
    init_simple_test("BFu7c_Ui_Ul");
    static STRUCT_IF_C BFu7c_Ui_Ul lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Ul.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Ul, BFu7c_Ui_Ul)
//============================================================================



static void Test_BFu7c_Ui_Us()
{
  {
    init_simple_test("BFu7c_Ui_Us");
    static STRUCT_IF_C BFu7c_Ui_Us lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Us.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Us, BFu7c_Ui_Us)
//============================================================================



static void Test_BFu7c_Ui_Vp()
{
  {
    init_simple_test("BFu7c_Ui_Vp");
    static STRUCT_IF_C BFu7c_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Vp.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Vp, BFu7c_Ui_Vp)
//============================================================================



static void Test_BFu7c_Ul()
{
  {
    init_simple_test("BFu7c_Ul");
    static STRUCT_IF_C BFu7c_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul, BFu7c_Ul)
//============================================================================



static void Test_BFu7c_Ul_BFu15i()
{
  {
    init_simple_test("BFu7c_Ul_BFu15i");
    static STRUCT_IF_C BFu7c_Ul_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "BFu7c_Ul_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "BFu7c_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu15i, BFu7c_Ul_BFu15i)
//============================================================================



static void Test_BFu7c_Ul_BFu15ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu15ll");
    static STRUCT_IF_C BFu7c_Ul_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "BFu7c_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "BFu7c_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu15ll, BFu7c_Ul_BFu15ll)
//============================================================================



static void Test_BFu7c_Ul_BFu15s()
{
  {
    init_simple_test("BFu7c_Ul_BFu15s");
    static STRUCT_IF_C BFu7c_Ul_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "BFu7c_Ul_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "BFu7c_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu15s, BFu7c_Ul_BFu15s)
//============================================================================



static void Test_BFu7c_Ul_BFu16i()
{
  {
    init_simple_test("BFu7c_Ul_BFu16i");
    static STRUCT_IF_C BFu7c_Ul_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "BFu7c_Ul_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "BFu7c_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu16i, BFu7c_Ul_BFu16i)
//============================================================================



static void Test_BFu7c_Ul_BFu16ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu16ll");
    static STRUCT_IF_C BFu7c_Ul_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "BFu7c_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "BFu7c_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu16ll, BFu7c_Ul_BFu16ll)
//============================================================================



static void Test_BFu7c_Ul_BFu16s()
{
  {
    init_simple_test("BFu7c_Ul_BFu16s");
    static STRUCT_IF_C BFu7c_Ul_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "BFu7c_Ul_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "BFu7c_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu16s, BFu7c_Ul_BFu16s)
//============================================================================



static void Test_BFu7c_Ul_BFu17i()
{
  {
    init_simple_test("BFu7c_Ul_BFu17i");
    static STRUCT_IF_C BFu7c_Ul_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "BFu7c_Ul_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "BFu7c_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu17i, BFu7c_Ul_BFu17i)
//============================================================================



static void Test_BFu7c_Ul_BFu17ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu17ll");
    static STRUCT_IF_C BFu7c_Ul_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "BFu7c_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "BFu7c_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu17ll, BFu7c_Ul_BFu17ll)
//============================================================================



static void Test_BFu7c_Ul_BFu1c()
{
  {
    init_simple_test("BFu7c_Ul_BFu1c");
    static STRUCT_IF_C BFu7c_Ul_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "BFu7c_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu1c, BFu7c_Ul_BFu1c)
//============================================================================



static void Test_BFu7c_Ul_BFu1i()
{
  {
    init_simple_test("BFu7c_Ul_BFu1i");
    static STRUCT_IF_C BFu7c_Ul_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "BFu7c_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu1i, BFu7c_Ul_BFu1i)
//============================================================================



static void Test_BFu7c_Ul_BFu1ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu1ll");
    static STRUCT_IF_C BFu7c_Ul_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "BFu7c_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu1ll, BFu7c_Ul_BFu1ll)
//============================================================================



static void Test_BFu7c_Ul_BFu1s()
{
  {
    init_simple_test("BFu7c_Ul_BFu1s");
    static STRUCT_IF_C BFu7c_Ul_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "BFu7c_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu1s, BFu7c_Ul_BFu1s)
//============================================================================



static void Test_BFu7c_Ul_BFu31i()
{
  {
    init_simple_test("BFu7c_Ul_BFu31i");
    static STRUCT_IF_C BFu7c_Ul_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "BFu7c_Ul_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "BFu7c_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu31i, BFu7c_Ul_BFu31i)
//============================================================================



static void Test_BFu7c_Ul_BFu31ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu31ll");
    static STRUCT_IF_C BFu7c_Ul_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "BFu7c_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "BFu7c_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu31ll, BFu7c_Ul_BFu31ll)
//============================================================================



static void Test_BFu7c_Ul_BFu32i()
{
  {
    init_simple_test("BFu7c_Ul_BFu32i");
    static STRUCT_IF_C BFu7c_Ul_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "BFu7c_Ul_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "BFu7c_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu32i, BFu7c_Ul_BFu32i)
//============================================================================



static void Test_BFu7c_Ul_BFu32ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu32ll");
    static STRUCT_IF_C BFu7c_Ul_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "BFu7c_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "BFu7c_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu32ll, BFu7c_Ul_BFu32ll)
//============================================================================



static void Test_BFu7c_Ul_BFu33()
{
  {
    init_simple_test("BFu7c_Ul_BFu33");
    static STRUCT_IF_C BFu7c_Ul_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(BFu7c_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "BFu7c_Ul_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "BFu7c_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu33, BFu7c_Ul_BFu33)
//============================================================================



static void Test_BFu7c_Ul_BFu7c()
{
  {
    init_simple_test("BFu7c_Ul_BFu7c");
    static STRUCT_IF_C BFu7c_Ul_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "BFu7c_Ul_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu7c, BFu7c_Ul_BFu7c)
//============================================================================



static void Test_BFu7c_Ul_BFu7i()
{
  {
    init_simple_test("BFu7c_Ul_BFu7i");
    static STRUCT_IF_C BFu7c_Ul_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "BFu7c_Ul_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu7i, BFu7c_Ul_BFu7i)
//============================================================================



static void Test_BFu7c_Ul_BFu7ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu7ll");
    static STRUCT_IF_C BFu7c_Ul_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "BFu7c_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu7ll, BFu7c_Ul_BFu7ll)
//============================================================================



static void Test_BFu7c_Ul_BFu7s()
{
  {
    init_simple_test("BFu7c_Ul_BFu7s");
    static STRUCT_IF_C BFu7c_Ul_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "BFu7c_Ul_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu7s, BFu7c_Ul_BFu7s)
//============================================================================



static void Test_BFu7c_Ul_BFu8c()
{
  {
    init_simple_test("BFu7c_Ul_BFu8c");
    static STRUCT_IF_C BFu7c_Ul_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "BFu7c_Ul_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "BFu7c_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu8c, BFu7c_Ul_BFu8c)
//============================================================================



static void Test_BFu7c_Ul_BFu8i()
{
  {
    init_simple_test("BFu7c_Ul_BFu8i");
    static STRUCT_IF_C BFu7c_Ul_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "BFu7c_Ul_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "BFu7c_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu8i, BFu7c_Ul_BFu8i)
//============================================================================



static void Test_BFu7c_Ul_BFu8ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu8ll");
    static STRUCT_IF_C BFu7c_Ul_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "BFu7c_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "BFu7c_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu8ll, BFu7c_Ul_BFu8ll)
//============================================================================



static void Test_BFu7c_Ul_BFu8s()
{
  {
    init_simple_test("BFu7c_Ul_BFu8s");
    static STRUCT_IF_C BFu7c_Ul_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "BFu7c_Ul_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "BFu7c_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu8s, BFu7c_Ul_BFu8s)
//============================================================================



static void Test_BFu7c_Ul_BFu9i()
{
  {
    init_simple_test("BFu7c_Ul_BFu9i");
    static STRUCT_IF_C BFu7c_Ul_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "BFu7c_Ul_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "BFu7c_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu9i, BFu7c_Ul_BFu9i)
//============================================================================



static void Test_BFu7c_Ul_BFu9ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu9ll");
    static STRUCT_IF_C BFu7c_Ul_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "BFu7c_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "BFu7c_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu9ll, BFu7c_Ul_BFu9ll)
//============================================================================



static void Test_BFu7c_Ul_BFu9s()
{
  {
    init_simple_test("BFu7c_Ul_BFu9s");
    static STRUCT_IF_C BFu7c_Ul_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "BFu7c_Ul_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "BFu7c_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu9s, BFu7c_Ul_BFu9s)
//============================================================================



static void Test_BFu7c_Ul_C()
{
  {
    init_simple_test("BFu7c_Ul_C");
    static STRUCT_IF_C BFu7c_Ul_C lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_C");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_C.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_C, BFu7c_Ul_C)
//============================================================================



static void Test_BFu7c_Ul_D()
{
  {
    init_simple_test("BFu7c_Ul_D");
    static STRUCT_IF_C BFu7c_Ul_D lv;
    check2(sizeof(lv), 17, "sizeof(BFu7c_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_D");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_D.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_D, BFu7c_Ul_D)
//============================================================================



static void Test_BFu7c_Ul_F()
{
  {
    init_simple_test("BFu7c_Ul_F");
    static STRUCT_IF_C BFu7c_Ul_F lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_F");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_F.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_F, BFu7c_Ul_F)
//============================================================================



static void Test_BFu7c_Ul_I()
{
  {
    init_simple_test("BFu7c_Ul_I");
    static STRUCT_IF_C BFu7c_Ul_I lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_I");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_I.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_I, BFu7c_Ul_I)
//============================================================================



static void Test_BFu7c_Ul_Ip()
{
  {
    init_simple_test("BFu7c_Ul_Ip");
    static STRUCT_IF_C BFu7c_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(BFu7c_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Ip.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Ip, BFu7c_Ul_Ip)
//============================================================================



static void Test_BFu7c_Ul_L()
{
  {
    init_simple_test("BFu7c_Ul_L");
    static STRUCT_IF_C BFu7c_Ul_L lv;
    check2(sizeof(lv), 17, "sizeof(BFu7c_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_L");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_L.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_L, BFu7c_Ul_L)
//============================================================================



static void Test_BFu7c_Ul_S()
{
  {
    init_simple_test("BFu7c_Ul_S");
    static STRUCT_IF_C BFu7c_Ul_S lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_S");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_S.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_S, BFu7c_Ul_S)
//============================================================================



static void Test_BFu7c_Ul_Uc()
{
  {
    init_simple_test("BFu7c_Ul_Uc");
    static STRUCT_IF_C BFu7c_Ul_Uc lv;
    check2(sizeof(lv), 10, "sizeof(BFu7c_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Uc.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Uc, BFu7c_Ul_Uc)
//============================================================================



static void Test_BFu7c_Ul_Ui()
{
  {
    init_simple_test("BFu7c_Ul_Ui");
    static STRUCT_IF_C BFu7c_Ul_Ui lv;
    check2(sizeof(lv), 13, "sizeof(BFu7c_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Ui.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Ui, BFu7c_Ul_Ui)
//============================================================================



static void Test_BFu7c_Ul_Ul()
{
  {
    init_simple_test("BFu7c_Ul_Ul");
    static STRUCT_IF_C BFu7c_Ul_Ul lv;
    check2(sizeof(lv), 17, "sizeof(BFu7c_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Ul.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Ul, BFu7c_Ul_Ul)
//============================================================================



static void Test_BFu7c_Ul_Us()
{
  {
    init_simple_test("BFu7c_Ul_Us");
    static STRUCT_IF_C BFu7c_Ul_Us lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Us.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Us, BFu7c_Ul_Us)
//============================================================================



static void Test_BFu7c_Ul_Vp()
{
  {
    init_simple_test("BFu7c_Ul_Vp");
    static STRUCT_IF_C BFu7c_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(BFu7c_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Vp.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Vp, BFu7c_Ul_Vp)
//============================================================================



static void Test_BFu7c_Us()
{
  {
    init_simple_test("BFu7c_Us");
    static STRUCT_IF_C BFu7c_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us, BFu7c_Us)
//============================================================================



static void Test_BFu7c_Us_BFu15i()
{
  {
    init_simple_test("BFu7c_Us_BFu15i");
    static STRUCT_IF_C BFu7c_Us_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7c_Us_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7c_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu15i, BFu7c_Us_BFu15i)
//============================================================================



static void Test_BFu7c_Us_BFu15ll()
{
  {
    init_simple_test("BFu7c_Us_BFu15ll");
    static STRUCT_IF_C BFu7c_Us_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7c_Us_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7c_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu15ll, BFu7c_Us_BFu15ll)
//============================================================================



static void Test_BFu7c_Us_BFu15s()
{
  {
    init_simple_test("BFu7c_Us_BFu15s");
    static STRUCT_IF_C BFu7c_Us_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7c_Us_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7c_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu15s, BFu7c_Us_BFu15s)
//============================================================================



static void Test_BFu7c_Us_BFu16i()
{
  {
    init_simple_test("BFu7c_Us_BFu16i");
    static STRUCT_IF_C BFu7c_Us_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7c_Us_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7c_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu16i, BFu7c_Us_BFu16i)
//============================================================================



static void Test_BFu7c_Us_BFu16ll()
{
  {
    init_simple_test("BFu7c_Us_BFu16ll");
    static STRUCT_IF_C BFu7c_Us_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7c_Us_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7c_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu16ll, BFu7c_Us_BFu16ll)
//============================================================================



static void Test_BFu7c_Us_BFu16s()
{
  {
    init_simple_test("BFu7c_Us_BFu16s");
    static STRUCT_IF_C BFu7c_Us_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7c_Us_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7c_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu16s, BFu7c_Us_BFu16s)
//============================================================================



static void Test_BFu7c_Us_BFu17i()
{
  {
    init_simple_test("BFu7c_Us_BFu17i");
    static STRUCT_IF_C BFu7c_Us_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu7c_Us_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu7c_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu17i, BFu7c_Us_BFu17i)
//============================================================================



static void Test_BFu7c_Us_BFu17ll()
{
  {
    init_simple_test("BFu7c_Us_BFu17ll");
    static STRUCT_IF_C BFu7c_Us_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu7c_Us_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu7c_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu17ll, BFu7c_Us_BFu17ll)
//============================================================================



static void Test_BFu7c_Us_BFu1c()
{
  {
    init_simple_test("BFu7c_Us_BFu1c");
    static STRUCT_IF_C BFu7c_Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7c_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu1c, BFu7c_Us_BFu1c)
//============================================================================



static void Test_BFu7c_Us_BFu1i()
{
  {
    init_simple_test("BFu7c_Us_BFu1i");
    static STRUCT_IF_C BFu7c_Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7c_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu1i, BFu7c_Us_BFu1i)
//============================================================================



static void Test_BFu7c_Us_BFu1ll()
{
  {
    init_simple_test("BFu7c_Us_BFu1ll");
    static STRUCT_IF_C BFu7c_Us_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7c_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu1ll, BFu7c_Us_BFu1ll)
//============================================================================



static void Test_BFu7c_Us_BFu1s()
{
  {
    init_simple_test("BFu7c_Us_BFu1s");
    static STRUCT_IF_C BFu7c_Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7c_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu1s, BFu7c_Us_BFu1s)
//============================================================================



static void Test_BFu7c_Us_BFu31i()
{
  {
    init_simple_test("BFu7c_Us_BFu31i");
    static STRUCT_IF_C BFu7c_Us_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu7c_Us_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu7c_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu31i, BFu7c_Us_BFu31i)
//============================================================================



static void Test_BFu7c_Us_BFu31ll()
{
  {
    init_simple_test("BFu7c_Us_BFu31ll");
    static STRUCT_IF_C BFu7c_Us_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu7c_Us_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu7c_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu31ll, BFu7c_Us_BFu31ll)
//============================================================================



static void Test_BFu7c_Us_BFu32i()
{
  {
    init_simple_test("BFu7c_Us_BFu32i");
    static STRUCT_IF_C BFu7c_Us_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu7c_Us_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu7c_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu32i, BFu7c_Us_BFu32i)
//============================================================================



static void Test_BFu7c_Us_BFu32ll()
{
  {
    init_simple_test("BFu7c_Us_BFu32ll");
    static STRUCT_IF_C BFu7c_Us_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu7c_Us_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu7c_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu32ll, BFu7c_Us_BFu32ll)
//============================================================================



static void Test_BFu7c_Us_BFu33()
{
  {
    init_simple_test("BFu7c_Us_BFu33");
    static STRUCT_IF_C BFu7c_Us_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu7c_Us_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu7c_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu33, BFu7c_Us_BFu33)
//============================================================================



static void Test_BFu7c_Us_BFu7c()
{
  {
    init_simple_test("BFu7c_Us_BFu7c");
    static STRUCT_IF_C BFu7c_Us_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7c_Us_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu7c, BFu7c_Us_BFu7c)
//============================================================================



static void Test_BFu7c_Us_BFu7i()
{
  {
    init_simple_test("BFu7c_Us_BFu7i");
    static STRUCT_IF_C BFu7c_Us_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7c_Us_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu7i, BFu7c_Us_BFu7i)
//============================================================================



static void Test_BFu7c_Us_BFu7ll()
{
  {
    init_simple_test("BFu7c_Us_BFu7ll");
    static STRUCT_IF_C BFu7c_Us_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7c_Us_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu7ll, BFu7c_Us_BFu7ll)
//============================================================================



static void Test_BFu7c_Us_BFu7s()
{
  {
    init_simple_test("BFu7c_Us_BFu7s");
    static STRUCT_IF_C BFu7c_Us_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7c_Us_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu7s, BFu7c_Us_BFu7s)
//============================================================================



static void Test_BFu7c_Us_BFu8c()
{
  {
    init_simple_test("BFu7c_Us_BFu8c");
    static STRUCT_IF_C BFu7c_Us_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_Us_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu8c, BFu7c_Us_BFu8c)
//============================================================================



static void Test_BFu7c_Us_BFu8i()
{
  {
    init_simple_test("BFu7c_Us_BFu8i");
    static STRUCT_IF_C BFu7c_Us_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_Us_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu8i, BFu7c_Us_BFu8i)
//============================================================================



static void Test_BFu7c_Us_BFu8ll()
{
  {
    init_simple_test("BFu7c_Us_BFu8ll");
    static STRUCT_IF_C BFu7c_Us_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_Us_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu8ll, BFu7c_Us_BFu8ll)
//============================================================================



static void Test_BFu7c_Us_BFu8s()
{
  {
    init_simple_test("BFu7c_Us_BFu8s");
    static STRUCT_IF_C BFu7c_Us_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7c_Us_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7c_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu8s, BFu7c_Us_BFu8s)
//============================================================================



static void Test_BFu7c_Us_BFu9i()
{
  {
    init_simple_test("BFu7c_Us_BFu9i");
    static STRUCT_IF_C BFu7c_Us_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7c_Us_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7c_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu9i, BFu7c_Us_BFu9i)
//============================================================================



static void Test_BFu7c_Us_BFu9ll()
{
  {
    init_simple_test("BFu7c_Us_BFu9ll");
    static STRUCT_IF_C BFu7c_Us_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7c_Us_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7c_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu9ll, BFu7c_Us_BFu9ll)
//============================================================================



static void Test_BFu7c_Us_BFu9s()
{
  {
    init_simple_test("BFu7c_Us_BFu9s");
    static STRUCT_IF_C BFu7c_Us_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7c_Us_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7c_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu9s, BFu7c_Us_BFu9s)
//============================================================================



static void Test_BFu7c_Us_C()
{
  {
    init_simple_test("BFu7c_Us_C");
    static STRUCT_IF_C BFu7c_Us_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_C");
    check_field_offset(lv, v2, 1, "BFu7c_Us_C.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_C, BFu7c_Us_C)
//============================================================================



static void Test_BFu7c_Us_D()
{
  {
    init_simple_test("BFu7c_Us_D");
    static STRUCT_IF_C BFu7c_Us_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_D");
    check_field_offset(lv, v2, 1, "BFu7c_Us_D.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_D, BFu7c_Us_D)
//============================================================================



static void Test_BFu7c_Us_F()
{
  {
    init_simple_test("BFu7c_Us_F");
    static STRUCT_IF_C BFu7c_Us_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_F");
    check_field_offset(lv, v2, 1, "BFu7c_Us_F.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_F, BFu7c_Us_F)
//============================================================================



static void Test_BFu7c_Us_I()
{
  {
    init_simple_test("BFu7c_Us_I");
    static STRUCT_IF_C BFu7c_Us_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_I");
    check_field_offset(lv, v2, 1, "BFu7c_Us_I.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_I, BFu7c_Us_I)
//============================================================================



static void Test_BFu7c_Us_Ip()
{
  {
    init_simple_test("BFu7c_Us_Ip");
    static STRUCT_IF_C BFu7c_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Ip, BFu7c_Us_Ip)
//============================================================================



static void Test_BFu7c_Us_L()
{
  {
    init_simple_test("BFu7c_Us_L");
    static STRUCT_IF_C BFu7c_Us_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_L");
    check_field_offset(lv, v2, 1, "BFu7c_Us_L.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_L, BFu7c_Us_L)
//============================================================================



static void Test_BFu7c_Us_S()
{
  {
    init_simple_test("BFu7c_Us_S");
    static STRUCT_IF_C BFu7c_Us_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_S");
    check_field_offset(lv, v2, 1, "BFu7c_Us_S.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_S, BFu7c_Us_S)
//============================================================================



static void Test_BFu7c_Us_Uc()
{
  {
    init_simple_test("BFu7c_Us_Uc");
    static STRUCT_IF_C BFu7c_Us_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Uc, BFu7c_Us_Uc)
//============================================================================



static void Test_BFu7c_Us_Ui()
{
  {
    init_simple_test("BFu7c_Us_Ui");
    static STRUCT_IF_C BFu7c_Us_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7c_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Ui, BFu7c_Us_Ui)
//============================================================================



static void Test_BFu7c_Us_Ul()
{
  {
    init_simple_test("BFu7c_Us_Ul");
    static STRUCT_IF_C BFu7c_Us_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7c_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Ul, BFu7c_Us_Ul)
//============================================================================



static void Test_BFu7c_Us_Us()
{
  {
    init_simple_test("BFu7c_Us_Us");
    static STRUCT_IF_C BFu7c_Us_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Us.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Us, BFu7c_Us_Us)
//============================================================================



static void Test_BFu7c_Us_Vp()
{
  {
    init_simple_test("BFu7c_Us_Vp");
    static STRUCT_IF_C BFu7c_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Vp, BFu7c_Us_Vp)
//============================================================================



static void Test_BFu7c_Vp()
{
  {
    init_simple_test("BFu7c_Vp");
    static STRUCT_IF_C BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp, BFu7c_Vp)
//============================================================================



static void Test_BFu7c_Vp_BFu15i()
{
  {
    init_simple_test("BFu7c_Vp_BFu15i");
    static STRUCT_IF_C BFu7c_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "BFu7c_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "BFu7c_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu15i, BFu7c_Vp_BFu15i)
//============================================================================



static void Test_BFu7c_Vp_BFu15ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu15ll");
    static STRUCT_IF_C BFu7c_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "BFu7c_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "BFu7c_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu15ll, BFu7c_Vp_BFu15ll)
//============================================================================



static void Test_BFu7c_Vp_BFu15s()
{
  {
    init_simple_test("BFu7c_Vp_BFu15s");
    static STRUCT_IF_C BFu7c_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "BFu7c_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "BFu7c_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu15s, BFu7c_Vp_BFu15s)
//============================================================================



static void Test_BFu7c_Vp_BFu16i()
{
  {
    init_simple_test("BFu7c_Vp_BFu16i");
    static STRUCT_IF_C BFu7c_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "BFu7c_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "BFu7c_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu16i, BFu7c_Vp_BFu16i)
//============================================================================



static void Test_BFu7c_Vp_BFu16ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu16ll");
    static STRUCT_IF_C BFu7c_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "BFu7c_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "BFu7c_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu16ll, BFu7c_Vp_BFu16ll)
//============================================================================



static void Test_BFu7c_Vp_BFu16s()
{
  {
    init_simple_test("BFu7c_Vp_BFu16s");
    static STRUCT_IF_C BFu7c_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "BFu7c_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "BFu7c_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu16s, BFu7c_Vp_BFu16s)
//============================================================================



static void Test_BFu7c_Vp_BFu17i()
{
  {
    init_simple_test("BFu7c_Vp_BFu17i");
    static STRUCT_IF_C BFu7c_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "BFu7c_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "BFu7c_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu17i, BFu7c_Vp_BFu17i)
//============================================================================



static void Test_BFu7c_Vp_BFu17ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu17ll");
    static STRUCT_IF_C BFu7c_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "BFu7c_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "BFu7c_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu17ll, BFu7c_Vp_BFu17ll)
//============================================================================



static void Test_BFu7c_Vp_BFu1c()
{
  {
    init_simple_test("BFu7c_Vp_BFu1c");
    static STRUCT_IF_C BFu7c_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "BFu7c_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu1c, BFu7c_Vp_BFu1c)
//============================================================================



static void Test_BFu7c_Vp_BFu1i()
{
  {
    init_simple_test("BFu7c_Vp_BFu1i");
    static STRUCT_IF_C BFu7c_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "BFu7c_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu1i, BFu7c_Vp_BFu1i)
//============================================================================



static void Test_BFu7c_Vp_BFu1ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu1ll");
    static STRUCT_IF_C BFu7c_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "BFu7c_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu1ll, BFu7c_Vp_BFu1ll)
//============================================================================



static void Test_BFu7c_Vp_BFu1s()
{
  {
    init_simple_test("BFu7c_Vp_BFu1s");
    static STRUCT_IF_C BFu7c_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "BFu7c_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu1s, BFu7c_Vp_BFu1s)
//============================================================================



static void Test_BFu7c_Vp_BFu31i()
{
  {
    init_simple_test("BFu7c_Vp_BFu31i");
    static STRUCT_IF_C BFu7c_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "BFu7c_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "BFu7c_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu31i, BFu7c_Vp_BFu31i)
//============================================================================



static void Test_BFu7c_Vp_BFu31ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu31ll");
    static STRUCT_IF_C BFu7c_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "BFu7c_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "BFu7c_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu31ll, BFu7c_Vp_BFu31ll)
//============================================================================



static void Test_BFu7c_Vp_BFu32i()
{
  {
    init_simple_test("BFu7c_Vp_BFu32i");
    static STRUCT_IF_C BFu7c_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "BFu7c_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "BFu7c_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu32i, BFu7c_Vp_BFu32i)
//============================================================================



static void Test_BFu7c_Vp_BFu32ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu32ll");
    static STRUCT_IF_C BFu7c_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "BFu7c_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "BFu7c_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu32ll, BFu7c_Vp_BFu32ll)
//============================================================================



static void Test_BFu7c_Vp_BFu33()
{
  {
    init_simple_test("BFu7c_Vp_BFu33");
    static STRUCT_IF_C BFu7c_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu7c_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "BFu7c_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "BFu7c_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu33, BFu7c_Vp_BFu33)
//============================================================================



static void Test_BFu7c_Vp_BFu7c()
{
  {
    init_simple_test("BFu7c_Vp_BFu7c");
    static STRUCT_IF_C BFu7c_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "BFu7c_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu7c, BFu7c_Vp_BFu7c)
//============================================================================



static void Test_BFu7c_Vp_BFu7i()
{
  {
    init_simple_test("BFu7c_Vp_BFu7i");
    static STRUCT_IF_C BFu7c_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "BFu7c_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu7i, BFu7c_Vp_BFu7i)
//============================================================================



static void Test_BFu7c_Vp_BFu7ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu7ll");
    static STRUCT_IF_C BFu7c_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "BFu7c_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu7ll, BFu7c_Vp_BFu7ll)
//============================================================================



static void Test_BFu7c_Vp_BFu7s()
{
  {
    init_simple_test("BFu7c_Vp_BFu7s");
    static STRUCT_IF_C BFu7c_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "BFu7c_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu7s, BFu7c_Vp_BFu7s)
//============================================================================



static void Test_BFu7c_Vp_BFu8c()
{
  {
    init_simple_test("BFu7c_Vp_BFu8c");
    static STRUCT_IF_C BFu7c_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "BFu7c_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "BFu7c_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu8c, BFu7c_Vp_BFu8c)
//============================================================================



static void Test_BFu7c_Vp_BFu8i()
{
  {
    init_simple_test("BFu7c_Vp_BFu8i");
    static STRUCT_IF_C BFu7c_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "BFu7c_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "BFu7c_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu8i, BFu7c_Vp_BFu8i)
//============================================================================



static void Test_BFu7c_Vp_BFu8ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu8ll");
    static STRUCT_IF_C BFu7c_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "BFu7c_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "BFu7c_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu8ll, BFu7c_Vp_BFu8ll)
//============================================================================



static void Test_BFu7c_Vp_BFu8s()
{
  {
    init_simple_test("BFu7c_Vp_BFu8s");
    static STRUCT_IF_C BFu7c_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "BFu7c_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "BFu7c_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu8s, BFu7c_Vp_BFu8s)
//============================================================================



static void Test_BFu7c_Vp_BFu9i()
{
  {
    init_simple_test("BFu7c_Vp_BFu9i");
    static STRUCT_IF_C BFu7c_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "BFu7c_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "BFu7c_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu9i, BFu7c_Vp_BFu9i)
//============================================================================



static void Test_BFu7c_Vp_BFu9ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu9ll");
    static STRUCT_IF_C BFu7c_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "BFu7c_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "BFu7c_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu9ll, BFu7c_Vp_BFu9ll)
//============================================================================



static void Test_BFu7c_Vp_BFu9s()
{
  {
    init_simple_test("BFu7c_Vp_BFu9s");
    static STRUCT_IF_C BFu7c_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "BFu7c_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "BFu7c_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu9s, BFu7c_Vp_BFu9s)
//============================================================================



static void Test_BFu7c_Vp_C()
{
  {
    init_simple_test("BFu7c_Vp_C");
    static STRUCT_IF_C BFu7c_Vp_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_C");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_C, BFu7c_Vp_C)
//============================================================================



static void Test_BFu7c_Vp_D()
{
  {
    init_simple_test("BFu7c_Vp_D");
    static STRUCT_IF_C BFu7c_Vp_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(BFu7c_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_D");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_D, BFu7c_Vp_D)
//============================================================================



static void Test_BFu7c_Vp_F()
{
  {
    init_simple_test("BFu7c_Vp_F");
    static STRUCT_IF_C BFu7c_Vp_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_F");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_F, BFu7c_Vp_F)
//============================================================================



static void Test_BFu7c_Vp_I()
{
  {
    init_simple_test("BFu7c_Vp_I");
    static STRUCT_IF_C BFu7c_Vp_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_I");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_I, BFu7c_Vp_I)
//============================================================================



static void Test_BFu7c_Vp_Ip()
{
  {
    init_simple_test("BFu7c_Vp_Ip");
    static STRUCT_IF_C BFu7c_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(BFu7c_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Ip, BFu7c_Vp_Ip)
//============================================================================



static void Test_BFu7c_Vp_L()
{
  {
    init_simple_test("BFu7c_Vp_L");
    static STRUCT_IF_C BFu7c_Vp_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(BFu7c_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_L");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_L, BFu7c_Vp_L)
//============================================================================



static void Test_BFu7c_Vp_S()
{
  {
    init_simple_test("BFu7c_Vp_S");
    static STRUCT_IF_C BFu7c_Vp_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_S");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_S, BFu7c_Vp_S)
//============================================================================



static void Test_BFu7c_Vp_Uc()
{
  {
    init_simple_test("BFu7c_Vp_Uc");
    static STRUCT_IF_C BFu7c_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Uc, BFu7c_Vp_Uc)
//============================================================================



static void Test_BFu7c_Vp_Ui()
{
  {
    init_simple_test("BFu7c_Vp_Ui");
    static STRUCT_IF_C BFu7c_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu7c_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Ui, BFu7c_Vp_Ui)
//============================================================================



static void Test_BFu7c_Vp_Ul()
{
  {
    init_simple_test("BFu7c_Vp_Ul");
    static STRUCT_IF_C BFu7c_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(BFu7c_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Ul, BFu7c_Vp_Ul)
//============================================================================



static void Test_BFu7c_Vp_Us()
{
  {
    init_simple_test("BFu7c_Vp_Us");
    static STRUCT_IF_C BFu7c_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7c_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Us, BFu7c_Vp_Us)
//============================================================================



static void Test_BFu7c_Vp_Vp()
{
  {
    init_simple_test("BFu7c_Vp_Vp");
    static STRUCT_IF_C BFu7c_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(BFu7c_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Vp, BFu7c_Vp_Vp)
//============================================================================



static void Test_BFu7i()
{
  {
    init_simple_test("BFu7i");
    static STRUCT_IF_C BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i, BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c, BFu7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c, BFu7i_BFs7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFs7c, BFu7i_BFs7c_BFs7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFs7i, BFu7i_BFs7c_BFs7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFs7ll, BFu7i_BFs7c_BFs7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFs7s, BFu7i_BFs7c_BFs7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFu7c, BFu7i_BFs7c_BFs7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFu7i, BFu7i_BFs7c_BFs7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFu7ll, BFu7i_BFs7c_BFs7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7c_BFu7s, BFu7i_BFs7c_BFs7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i, BFu7i_BFs7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFs7c, BFu7i_BFs7c_BFs7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFs7i, BFu7i_BFs7c_BFs7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFs7ll, BFu7i_BFs7c_BFs7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFs7s, BFu7i_BFs7c_BFs7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFu7c, BFu7i_BFs7c_BFs7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFu7i, BFu7i_BFs7c_BFs7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFu7ll, BFu7i_BFs7c_BFs7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7i_BFu7s, BFu7i_BFs7c_BFs7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll, BFu7i_BFs7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFs7c, BFu7i_BFs7c_BFs7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFs7i, BFu7i_BFs7c_BFs7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFs7ll, BFu7i_BFs7c_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFs7s, BFu7i_BFs7c_BFs7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFu7c, BFu7i_BFs7c_BFs7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFu7i, BFu7i_BFs7c_BFs7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFu7ll, BFu7i_BFs7c_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7ll_BFu7s, BFu7i_BFs7c_BFs7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s, BFu7i_BFs7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFs7c, BFu7i_BFs7c_BFs7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFs7i, BFu7i_BFs7c_BFs7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFs7ll, BFu7i_BFs7c_BFs7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFs7s, BFu7i_BFs7c_BFs7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFu7c, BFu7i_BFs7c_BFs7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFu7i, BFu7i_BFs7c_BFs7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFu7ll, BFu7i_BFs7c_BFs7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFs7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFs7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFs7s_BFu7s, BFu7i_BFs7c_BFs7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c, BFu7i_BFs7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFs7c, BFu7i_BFs7c_BFu7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFs7i, BFu7i_BFs7c_BFu7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFs7ll, BFu7i_BFs7c_BFu7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFs7s, BFu7i_BFs7c_BFu7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFu7c, BFu7i_BFs7c_BFu7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFu7i, BFu7i_BFs7c_BFu7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFu7ll, BFu7i_BFs7c_BFu7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7c_BFu7s, BFu7i_BFs7c_BFu7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i, BFu7i_BFs7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFs7c, BFu7i_BFs7c_BFu7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFs7i, BFu7i_BFs7c_BFu7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFs7ll, BFu7i_BFs7c_BFu7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFs7s, BFu7i_BFs7c_BFu7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFu7c, BFu7i_BFs7c_BFu7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFu7i, BFu7i_BFs7c_BFu7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFu7ll, BFu7i_BFs7c_BFu7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7i_BFu7s, BFu7i_BFs7c_BFu7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll, BFu7i_BFs7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFs7c, BFu7i_BFs7c_BFu7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFs7i, BFu7i_BFs7c_BFu7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFs7ll, BFu7i_BFs7c_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFs7s, BFu7i_BFs7c_BFu7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFu7c, BFu7i_BFs7c_BFu7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFu7i, BFu7i_BFs7c_BFu7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFu7ll, BFu7i_BFs7c_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7ll_BFu7s, BFu7i_BFs7c_BFu7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s, BFu7i_BFs7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFs7c, BFu7i_BFs7c_BFu7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFs7i, BFu7i_BFs7c_BFu7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFs7ll, BFu7i_BFs7c_BFu7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFs7s, BFu7i_BFs7c_BFu7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFu7c, BFu7i_BFs7c_BFu7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFu7i, BFu7i_BFs7c_BFu7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFu7ll, BFu7i_BFs7c_BFu7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7c_BFu7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7c_BFu7s_BFu7s, BFu7i_BFs7c_BFu7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i, BFu7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c, BFu7i_BFs7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFs7c, BFu7i_BFs7i_BFs7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFs7i, BFu7i_BFs7i_BFs7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFs7ll, BFu7i_BFs7i_BFs7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFs7s, BFu7i_BFs7i_BFs7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFu7c, BFu7i_BFs7i_BFs7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFu7i, BFu7i_BFs7i_BFs7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFu7ll, BFu7i_BFs7i_BFs7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7c_BFu7s, BFu7i_BFs7i_BFs7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i, BFu7i_BFs7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFs7c, BFu7i_BFs7i_BFs7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFs7i, BFu7i_BFs7i_BFs7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFs7ll, BFu7i_BFs7i_BFs7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFs7s, BFu7i_BFs7i_BFs7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFu7c, BFu7i_BFs7i_BFs7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFu7i, BFu7i_BFs7i_BFs7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFu7ll, BFu7i_BFs7i_BFs7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7i_BFu7s, BFu7i_BFs7i_BFs7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll, BFu7i_BFs7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFs7c, BFu7i_BFs7i_BFs7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFs7i, BFu7i_BFs7i_BFs7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFs7ll, BFu7i_BFs7i_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFs7s, BFu7i_BFs7i_BFs7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFu7c, BFu7i_BFs7i_BFs7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFu7i, BFu7i_BFs7i_BFs7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFu7ll, BFu7i_BFs7i_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7ll_BFu7s, BFu7i_BFs7i_BFs7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s, BFu7i_BFs7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFs7c, BFu7i_BFs7i_BFs7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFs7i, BFu7i_BFs7i_BFs7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFs7ll, BFu7i_BFs7i_BFs7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFs7s, BFu7i_BFs7i_BFs7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFu7c, BFu7i_BFs7i_BFs7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFu7i, BFu7i_BFs7i_BFs7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFu7ll, BFu7i_BFs7i_BFs7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFs7s_BFu7s, BFu7i_BFs7i_BFs7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c, BFu7i_BFs7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFs7c, BFu7i_BFs7i_BFu7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFs7i, BFu7i_BFs7i_BFu7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFs7ll, BFu7i_BFs7i_BFu7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFs7s, BFu7i_BFs7i_BFu7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFu7c, BFu7i_BFs7i_BFu7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFu7i, BFu7i_BFs7i_BFu7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFu7ll, BFu7i_BFs7i_BFu7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7c_BFu7s, BFu7i_BFs7i_BFu7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i, BFu7i_BFs7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFs7c, BFu7i_BFs7i_BFu7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFs7i, BFu7i_BFs7i_BFu7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFs7ll, BFu7i_BFs7i_BFu7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFs7s, BFu7i_BFs7i_BFu7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFu7c, BFu7i_BFs7i_BFu7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFu7i, BFu7i_BFs7i_BFu7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFu7ll, BFu7i_BFs7i_BFu7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7i_BFu7s, BFu7i_BFs7i_BFu7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll, BFu7i_BFs7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFs7c, BFu7i_BFs7i_BFu7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFs7i, BFu7i_BFs7i_BFu7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFs7ll, BFu7i_BFs7i_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFs7s, BFu7i_BFs7i_BFu7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFu7c, BFu7i_BFs7i_BFu7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFu7i, BFu7i_BFs7i_BFu7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFu7ll, BFu7i_BFs7i_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7ll_BFu7s, BFu7i_BFs7i_BFu7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s, BFu7i_BFs7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFs7c, BFu7i_BFs7i_BFu7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFs7i, BFu7i_BFs7i_BFu7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFs7ll, BFu7i_BFs7i_BFu7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFs7s, BFu7i_BFs7i_BFu7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFu7c, BFu7i_BFs7i_BFu7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFu7i, BFu7i_BFs7i_BFu7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFu7ll, BFu7i_BFs7i_BFu7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7i_BFu7s_BFu7s, BFu7i_BFs7i_BFu7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll, BFu7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c, BFu7i_BFs7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFs7c, BFu7i_BFs7ll_BFs7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFs7i, BFu7i_BFs7ll_BFs7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFs7ll, BFu7i_BFs7ll_BFs7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFs7s, BFu7i_BFs7ll_BFs7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFu7c, BFu7i_BFs7ll_BFs7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFu7i, BFu7i_BFs7ll_BFs7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFu7ll, BFu7i_BFs7ll_BFs7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7c_BFu7s, BFu7i_BFs7ll_BFs7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i, BFu7i_BFs7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFs7c, BFu7i_BFs7ll_BFs7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFs7i, BFu7i_BFs7ll_BFs7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFs7ll, BFu7i_BFs7ll_BFs7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFs7s, BFu7i_BFs7ll_BFs7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFu7c, BFu7i_BFs7ll_BFs7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFu7i, BFu7i_BFs7ll_BFs7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFu7ll, BFu7i_BFs7ll_BFs7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7i_BFu7s, BFu7i_BFs7ll_BFs7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll, BFu7i_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFs7c, BFu7i_BFs7ll_BFs7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFs7i, BFu7i_BFs7ll_BFs7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFs7ll, BFu7i_BFs7ll_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFs7s, BFu7i_BFs7ll_BFs7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFu7c, BFu7i_BFs7ll_BFs7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFu7i, BFu7i_BFs7ll_BFs7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFu7ll, BFu7i_BFs7ll_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7ll_BFu7s, BFu7i_BFs7ll_BFs7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s, BFu7i_BFs7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFs7c, BFu7i_BFs7ll_BFs7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFs7i, BFu7i_BFs7ll_BFs7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFs7ll, BFu7i_BFs7ll_BFs7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFs7s, BFu7i_BFs7ll_BFs7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFu7c, BFu7i_BFs7ll_BFs7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFu7i, BFu7i_BFs7ll_BFs7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFu7ll, BFu7i_BFs7ll_BFs7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFs7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFs7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFs7s_BFu7s, BFu7i_BFs7ll_BFs7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c, BFu7i_BFs7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFs7c, BFu7i_BFs7ll_BFu7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFs7i, BFu7i_BFs7ll_BFu7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFs7ll, BFu7i_BFs7ll_BFu7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFs7s, BFu7i_BFs7ll_BFu7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFu7c, BFu7i_BFs7ll_BFu7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFu7i, BFu7i_BFs7ll_BFu7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFu7ll, BFu7i_BFs7ll_BFu7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7c_BFu7s, BFu7i_BFs7ll_BFu7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i, BFu7i_BFs7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFs7c, BFu7i_BFs7ll_BFu7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFs7i, BFu7i_BFs7ll_BFu7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFs7ll, BFu7i_BFs7ll_BFu7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFs7s, BFu7i_BFs7ll_BFu7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFu7c, BFu7i_BFs7ll_BFu7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFu7i, BFu7i_BFs7ll_BFu7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFu7ll, BFu7i_BFs7ll_BFu7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7i_BFu7s, BFu7i_BFs7ll_BFu7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll, BFu7i_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFs7c, BFu7i_BFs7ll_BFu7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFs7i, BFu7i_BFs7ll_BFu7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFs7ll, BFu7i_BFs7ll_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFs7s, BFu7i_BFs7ll_BFu7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFu7c, BFu7i_BFs7ll_BFu7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFu7i, BFu7i_BFs7ll_BFu7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFu7ll, BFu7i_BFs7ll_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7ll_BFu7s, BFu7i_BFs7ll_BFu7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s, BFu7i_BFs7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFs7c, BFu7i_BFs7ll_BFu7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFs7i, BFu7i_BFs7ll_BFu7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFs7ll, BFu7i_BFs7ll_BFu7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFs7s, BFu7i_BFs7ll_BFu7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFu7c, BFu7i_BFs7ll_BFu7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFu7i, BFu7i_BFs7ll_BFu7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFu7ll, BFu7i_BFs7ll_BFu7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7ll_BFu7s_BFu7s, BFu7i_BFs7ll_BFu7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s, BFu7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c, BFu7i_BFs7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFs7c, BFu7i_BFs7s_BFs7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFs7i, BFu7i_BFs7s_BFs7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFs7ll, BFu7i_BFs7s_BFs7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFs7s, BFu7i_BFs7s_BFs7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFu7c, BFu7i_BFs7s_BFs7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFu7i, BFu7i_BFs7s_BFs7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFu7ll, BFu7i_BFs7s_BFs7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7c_BFu7s, BFu7i_BFs7s_BFs7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i, BFu7i_BFs7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFs7c, BFu7i_BFs7s_BFs7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFs7i, BFu7i_BFs7s_BFs7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFs7ll, BFu7i_BFs7s_BFs7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFs7s, BFu7i_BFs7s_BFs7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFu7c, BFu7i_BFs7s_BFs7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFu7i, BFu7i_BFs7s_BFs7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFu7ll, BFu7i_BFs7s_BFs7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7i_BFu7s, BFu7i_BFs7s_BFs7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll, BFu7i_BFs7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFs7c, BFu7i_BFs7s_BFs7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFs7i, BFu7i_BFs7s_BFs7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFs7ll, BFu7i_BFs7s_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFs7s, BFu7i_BFs7s_BFs7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFu7c, BFu7i_BFs7s_BFs7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFu7i, BFu7i_BFs7s_BFs7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFu7ll, BFu7i_BFs7s_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7ll_BFu7s, BFu7i_BFs7s_BFs7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s, BFu7i_BFs7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFs7c, BFu7i_BFs7s_BFs7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFs7i, BFu7i_BFs7s_BFs7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFs7ll, BFu7i_BFs7s_BFs7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFs7s, BFu7i_BFs7s_BFs7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFu7c, BFu7i_BFs7s_BFs7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFu7i, BFu7i_BFs7s_BFs7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFu7ll, BFu7i_BFs7s_BFs7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFs7s_BFu7s, BFu7i_BFs7s_BFs7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c, BFu7i_BFs7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFs7c, BFu7i_BFs7s_BFu7c_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFs7i, BFu7i_BFs7s_BFu7c_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFs7ll, BFu7i_BFs7s_BFu7c_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFs7s, BFu7i_BFs7s_BFu7c_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFu7c, BFu7i_BFs7s_BFu7c_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFu7i, BFu7i_BFs7s_BFu7c_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFu7ll, BFu7i_BFs7s_BFu7c_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7c_BFu7s, BFu7i_BFs7s_BFu7c_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i, BFu7i_BFs7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFs7c, BFu7i_BFs7s_BFu7i_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFs7i, BFu7i_BFs7s_BFu7i_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFs7ll, BFu7i_BFs7s_BFu7i_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFs7s, BFu7i_BFs7s_BFu7i_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFu7c, BFu7i_BFs7s_BFu7i_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFu7i, BFu7i_BFs7s_BFu7i_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFu7ll, BFu7i_BFs7s_BFu7i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7i_BFu7s, BFu7i_BFs7s_BFu7i_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll, BFu7i_BFs7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFs7c, BFu7i_BFs7s_BFu7ll_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFs7i, BFu7i_BFs7s_BFu7ll_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFs7ll, BFu7i_BFs7s_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFs7s, BFu7i_BFs7s_BFu7ll_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFu7c, BFu7i_BFs7s_BFu7ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFu7i, BFu7i_BFs7s_BFu7ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFu7ll, BFu7i_BFs7s_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7ll_BFu7s, BFu7i_BFs7s_BFu7ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s, BFu7i_BFs7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFs7c, BFu7i_BFs7s_BFu7s_BFs7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFs7i, BFu7i_BFs7s_BFu7s_BFs7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFs7ll, BFu7i_BFs7s_BFu7s_BFs7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFs7s, BFu7i_BFs7s_BFu7s_BFs7s)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFu7c, BFu7i_BFs7s_BFu7s_BFu7c)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFu7i, BFu7i_BFs7s_BFu7s_BFu7i)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFu7ll, BFu7i_BFs7s_BFu7s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFs7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFs7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFu7i_BFs7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFs7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFs7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFu7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFu7i_BFs7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFs7s_BFu7s_BFu7s, BFu7i_BFs7s_BFu7s_BFu7s)
//============================================================================



static void Test_BFu7i_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu15i");
    static STRUCT_IF_C BFu7i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i, BFu7i_BFu15i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu15i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu15i, BFu7i_BFu15i_BFu15i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu15ll, BFu7i_BFu15i_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu15s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu15s, BFu7i_BFu15i_BFu15s)
//============================================================================



static void Test_BFu7i_BFu15i_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu16i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu16i, BFu7i_BFu15i_BFu16i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu16ll, BFu7i_BFu15i_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu16s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu16s, BFu7i_BFu15i_BFu16s)
//============================================================================



static void Test_BFu7i_BFu15i_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu17i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu7i_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu7i_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu17i, BFu7i_BFu15i_BFu17i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu7i_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu7i_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu17ll, BFu7i_BFu15i_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu1c");
    static STRUCT_IF_C BFu7i_BFu15i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu1c, BFu7i_BFu15i_BFu1c)
//============================================================================



static void Test_BFu7i_BFu15i_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu1i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu1i, BFu7i_BFu15i_BFu1i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu1ll, BFu7i_BFu15i_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu1s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu1s, BFu7i_BFu15i_BFu1s)
//============================================================================



static void Test_BFu7i_BFu15i_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu31i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu7i_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu7i_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu31i, BFu7i_BFu15i_BFu31i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu7i_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu7i_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu31ll, BFu7i_BFu15i_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu32i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu7i_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu7i_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu32i, BFu7i_BFu15i_BFu32i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu7i_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu7i_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu32ll, BFu7i_BFu15i_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu33()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu33");
    static STRUCT_IF_C BFu7i_BFu15i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, 1, "BFu7i_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, hide_ull(1LL<<32), "BFu7i_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu33, BFu7i_BFu15i_BFu33)
//============================================================================



static void Test_BFu7i_BFu15i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu7c");
    static STRUCT_IF_C BFu7i_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu7c, BFu7i_BFu15i_BFu7c)
//============================================================================



static void Test_BFu7i_BFu15i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu7i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu7i, BFu7i_BFu15i_BFu7i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu7ll, BFu7i_BFu15i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu7s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu7s, BFu7i_BFu15i_BFu7s)
//============================================================================



static void Test_BFu7i_BFu15i_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu8c");
    static STRUCT_IF_C BFu7i_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu8c, BFu7i_BFu15i_BFu8c)
//============================================================================



static void Test_BFu7i_BFu15i_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu8i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu8i, BFu7i_BFu15i_BFu8i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu8ll, BFu7i_BFu15i_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu8s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu8s, BFu7i_BFu15i_BFu8s)
//============================================================================



static void Test_BFu7i_BFu15i_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu9i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu9i, BFu7i_BFu15i_BFu9i)
//============================================================================



static void Test_BFu7i_BFu15i_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu9ll, BFu7i_BFu15i_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu15i_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu9s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu9s, BFu7i_BFu15i_BFu9s)
//============================================================================



static void Test_BFu7i_BFu15i_C()
{
  {
    init_simple_test("BFu7i_BFu15i_C");
    static STRUCT_IF_C BFu7i_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_C");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_C");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_C, BFu7i_BFu15i_C)
//============================================================================



static void Test_BFu7i_BFu15i_D()
{
  {
    init_simple_test("BFu7i_BFu15i_D");
    static STRUCT_IF_C BFu7i_BFu15i_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_D");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_D");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_D, BFu7i_BFu15i_D)
//============================================================================



static void Test_BFu7i_BFu15i_F()
{
  {
    init_simple_test("BFu7i_BFu15i_F");
    static STRUCT_IF_C BFu7i_BFu15i_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_F");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_F");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_F, BFu7i_BFu15i_F)
//============================================================================



static void Test_BFu7i_BFu15i_I()
{
  {
    init_simple_test("BFu7i_BFu15i_I");
    static STRUCT_IF_C BFu7i_BFu15i_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_I");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_I");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_I, BFu7i_BFu15i_I)
//============================================================================



static void Test_BFu7i_BFu15i_Ip()
{
  {
    init_simple_test("BFu7i_BFu15i_Ip");
    static STRUCT_IF_C BFu7i_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Ip");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Ip");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Ip, BFu7i_BFu15i_Ip)
//============================================================================



static void Test_BFu7i_BFu15i_L()
{
  {
    init_simple_test("BFu7i_BFu15i_L");
    static STRUCT_IF_C BFu7i_BFu15i_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_L");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_L");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_L, BFu7i_BFu15i_L)
//============================================================================



static void Test_BFu7i_BFu15i_S()
{
  {
    init_simple_test("BFu7i_BFu15i_S");
    static STRUCT_IF_C BFu7i_BFu15i_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_S");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_S");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_S, BFu7i_BFu15i_S)
//============================================================================



static void Test_BFu7i_BFu15i_Uc()
{
  {
    init_simple_test("BFu7i_BFu15i_Uc");
    static STRUCT_IF_C BFu7i_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Uc");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Uc");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Uc, BFu7i_BFu15i_Uc)
//============================================================================



static void Test_BFu7i_BFu15i_Ui()
{
  {
    init_simple_test("BFu7i_BFu15i_Ui");
    static STRUCT_IF_C BFu7i_BFu15i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Ui");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Ui");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Ui, BFu7i_BFu15i_Ui)
//============================================================================



static void Test_BFu7i_BFu15i_Ul()
{
  {
    init_simple_test("BFu7i_BFu15i_Ul");
    static STRUCT_IF_C BFu7i_BFu15i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Ul");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Ul");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Ul, BFu7i_BFu15i_Ul)
//============================================================================



static void Test_BFu7i_BFu15i_Us()
{
  {
    init_simple_test("BFu7i_BFu15i_Us");
    static STRUCT_IF_C BFu7i_BFu15i_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Us");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Us");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Us, BFu7i_BFu15i_Us)
//============================================================================



static void Test_BFu7i_BFu15i_Vp()
{
  {
    init_simple_test("BFu7i_BFu15i_Vp");
    static STRUCT_IF_C BFu7i_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Vp");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Vp");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Vp, BFu7i_BFu15i_Vp)
//============================================================================



static void Test_BFu7i_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll, BFu7i_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu15i, BFu7i_BFu15ll_BFu15i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu15ll, BFu7i_BFu15ll_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu15s, BFu7i_BFu15ll_BFu15s)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu16i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu16i, BFu7i_BFu15ll_BFu16i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu16ll, BFu7i_BFu15ll_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu16s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu16s, BFu7i_BFu15ll_BFu16s)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu17i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu7i_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu7i_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu17i, BFu7i_BFu15ll_BFu17i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu7i_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu7i_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu17ll, BFu7i_BFu15ll_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu1c");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu1c, BFu7i_BFu15ll_BFu1c)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu1i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu1i, BFu7i_BFu15ll_BFu1i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu1ll, BFu7i_BFu15ll_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu1s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu1s, BFu7i_BFu15ll_BFu1s)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu31i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu7i_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu7i_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu31i, BFu7i_BFu15ll_BFu31i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu7i_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu7i_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu31ll, BFu7i_BFu15ll_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu32i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu7i_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu7i_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu32i, BFu7i_BFu15ll_BFu32i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu7i_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu7i_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu32ll, BFu7i_BFu15ll_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu33()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu33");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, 1, "BFu7i_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, hide_ull(1LL<<32), "BFu7i_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu33, BFu7i_BFu15ll_BFu33)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu7c, BFu7i_BFu15ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu7i, BFu7i_BFu15ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu7ll, BFu7i_BFu15ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu7s, BFu7i_BFu15ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu8c");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu8c, BFu7i_BFu15ll_BFu8c)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu8i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu8i, BFu7i_BFu15ll_BFu8i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu8ll, BFu7i_BFu15ll_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu8s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu8s, BFu7i_BFu15ll_BFu8s)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu9i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu9i, BFu7i_BFu15ll_BFu9i)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu9ll, BFu7i_BFu15ll_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu15ll_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu9s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu9s, BFu7i_BFu15ll_BFu9s)
//============================================================================



static void Test_BFu7i_BFu15ll_C()
{
  {
    init_simple_test("BFu7i_BFu15ll_C");
    static STRUCT_IF_C BFu7i_BFu15ll_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_C");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_C");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_C, BFu7i_BFu15ll_C)
//============================================================================



static void Test_BFu7i_BFu15ll_D()
{
  {
    init_simple_test("BFu7i_BFu15ll_D");
    static STRUCT_IF_C BFu7i_BFu15ll_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_D");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_D");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_D, BFu7i_BFu15ll_D)
//============================================================================



static void Test_BFu7i_BFu15ll_F()
{
  {
    init_simple_test("BFu7i_BFu15ll_F");
    static STRUCT_IF_C BFu7i_BFu15ll_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_F");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_F");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_F, BFu7i_BFu15ll_F)
//============================================================================



static void Test_BFu7i_BFu15ll_I()
{
  {
    init_simple_test("BFu7i_BFu15ll_I");
    static STRUCT_IF_C BFu7i_BFu15ll_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_I");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_I");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_I, BFu7i_BFu15ll_I)
//============================================================================



static void Test_BFu7i_BFu15ll_Ip()
{
  {
    init_simple_test("BFu7i_BFu15ll_Ip");
    static STRUCT_IF_C BFu7i_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Ip, BFu7i_BFu15ll_Ip)
//============================================================================



static void Test_BFu7i_BFu15ll_L()
{
  {
    init_simple_test("BFu7i_BFu15ll_L");
    static STRUCT_IF_C BFu7i_BFu15ll_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_L");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_L");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_L, BFu7i_BFu15ll_L)
//============================================================================



static void Test_BFu7i_BFu15ll_S()
{
  {
    init_simple_test("BFu7i_BFu15ll_S");
    static STRUCT_IF_C BFu7i_BFu15ll_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_S");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_S");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_S, BFu7i_BFu15ll_S)
//============================================================================



static void Test_BFu7i_BFu15ll_Uc()
{
  {
    init_simple_test("BFu7i_BFu15ll_Uc");
    static STRUCT_IF_C BFu7i_BFu15ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Uc, BFu7i_BFu15ll_Uc)
//============================================================================



static void Test_BFu7i_BFu15ll_Ui()
{
  {
    init_simple_test("BFu7i_BFu15ll_Ui");
    static STRUCT_IF_C BFu7i_BFu15ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Ui, BFu7i_BFu15ll_Ui)
//============================================================================



static void Test_BFu7i_BFu15ll_Ul()
{
  {
    init_simple_test("BFu7i_BFu15ll_Ul");
    static STRUCT_IF_C BFu7i_BFu15ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Ul, BFu7i_BFu15ll_Ul)
//============================================================================



static void Test_BFu7i_BFu15ll_Us()
{
  {
    init_simple_test("BFu7i_BFu15ll_Us");
    static STRUCT_IF_C BFu7i_BFu15ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Us");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Us");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Us, BFu7i_BFu15ll_Us)
//============================================================================



static void Test_BFu7i_BFu15ll_Vp()
{
  {
    init_simple_test("BFu7i_BFu15ll_Vp");
    static STRUCT_IF_C BFu7i_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Vp, BFu7i_BFu15ll_Vp)
//============================================================================



static void Test_BFu7i_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu15s");
    static STRUCT_IF_C BFu7i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s, BFu7i_BFu15s)
//============================================================================



static void Test_BFu7i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu15i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu15i, BFu7i_BFu15s_BFu15i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu15ll, BFu7i_BFu15s_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu15s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 6, 15, 1, "BFu7i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 6, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu15s, BFu7i_BFu15s_BFu15s)
//============================================================================



static void Test_BFu7i_BFu15s_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu16i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu16i, BFu7i_BFu15s_BFu16i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu16ll, BFu7i_BFu15s_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu16s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 6, 16, 1, "BFu7i_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 6, 16, hide_ull(1LL<<15), "BFu7i_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu16s, BFu7i_BFu15s_BFu16s)
//============================================================================



static void Test_BFu7i_BFu15s_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu17i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu7i_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu7i_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu17i, BFu7i_BFu15s_BFu17i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, 1, "BFu7i_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 6, 17, hide_ull(1LL<<16), "BFu7i_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu17ll, BFu7i_BFu15s_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu1c");
    static STRUCT_IF_C BFu7i_BFu15s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu1c, BFu7i_BFu15s_BFu1c)
//============================================================================



static void Test_BFu7i_BFu15s_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu1i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu1i, BFu7i_BFu15s_BFu1i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu1ll, BFu7i_BFu15s_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu1s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 2, 6, 1, 1, "BFu7i_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu1s, BFu7i_BFu15s_BFu1s)
//============================================================================



static void Test_BFu7i_BFu15s_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu31i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu7i_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu7i_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu31i, BFu7i_BFu15s_BFu31i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, 1, "BFu7i_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 6, 31, hide_ull(1LL<<30), "BFu7i_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu31ll, BFu7i_BFu15s_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu32i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu7i_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu7i_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu32i, BFu7i_BFu15s_BFu32i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, 1, "BFu7i_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 6, 32, hide_ull(1LL<<31), "BFu7i_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu32ll, BFu7i_BFu15s_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu33()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu33");
    static STRUCT_IF_C BFu7i_BFu15s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, 1, "BFu7i_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 6, 33, hide_ull(1LL<<32), "BFu7i_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu33, BFu7i_BFu15s_BFu33)
//============================================================================



static void Test_BFu7i_BFu15s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu7c");
    static STRUCT_IF_C BFu7i_BFu15s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu7c, BFu7i_BFu15s_BFu7c)
//============================================================================



static void Test_BFu7i_BFu15s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu7i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu7i, BFu7i_BFu15s_BFu7i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu7ll, BFu7i_BFu15s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu7s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, 1, "BFu7i_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 6, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu7s, BFu7i_BFu15s_BFu7s)
//============================================================================



static void Test_BFu7i_BFu15s_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu8c");
    static STRUCT_IF_C BFu7i_BFu15s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu8c, BFu7i_BFu15s_BFu8c)
//============================================================================



static void Test_BFu7i_BFu15s_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu8i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu8i, BFu7i_BFu15s_BFu8i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu8ll, BFu7i_BFu15s_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu8s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, 1, "BFu7i_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 6, 8, hide_ull(1LL<<7), "BFu7i_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu8s, BFu7i_BFu15s_BFu8s)
//============================================================================



static void Test_BFu7i_BFu15s_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu9i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu9i, BFu7i_BFu15s_BFu9i)
//============================================================================



static void Test_BFu7i_BFu15s_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu9ll, BFu7i_BFu15s_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu15s_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu9s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, 1, "BFu7i_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 6, 9, hide_ull(1LL<<8), "BFu7i_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu9s, BFu7i_BFu15s_BFu9s)
//============================================================================



static void Test_BFu7i_BFu15s_C()
{
  {
    init_simple_test("BFu7i_BFu15s_C");
    static STRUCT_IF_C BFu7i_BFu15s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_C");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_C");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_C, BFu7i_BFu15s_C)
//============================================================================



static void Test_BFu7i_BFu15s_D()
{
  {
    init_simple_test("BFu7i_BFu15s_D");
    static STRUCT_IF_C BFu7i_BFu15s_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_D");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_D");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_D, BFu7i_BFu15s_D)
//============================================================================



static void Test_BFu7i_BFu15s_F()
{
  {
    init_simple_test("BFu7i_BFu15s_F");
    static STRUCT_IF_C BFu7i_BFu15s_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_F");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_F");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_F, BFu7i_BFu15s_F)
//============================================================================



static void Test_BFu7i_BFu15s_I()
{
  {
    init_simple_test("BFu7i_BFu15s_I");
    static STRUCT_IF_C BFu7i_BFu15s_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_I");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_I");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_I, BFu7i_BFu15s_I)
//============================================================================



static void Test_BFu7i_BFu15s_Ip()
{
  {
    init_simple_test("BFu7i_BFu15s_Ip");
    static STRUCT_IF_C BFu7i_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Ip");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Ip");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Ip, BFu7i_BFu15s_Ip)
//============================================================================



static void Test_BFu7i_BFu15s_L()
{
  {
    init_simple_test("BFu7i_BFu15s_L");
    static STRUCT_IF_C BFu7i_BFu15s_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_L");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_L");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_L, BFu7i_BFu15s_L)
//============================================================================



static void Test_BFu7i_BFu15s_S()
{
  {
    init_simple_test("BFu7i_BFu15s_S");
    static STRUCT_IF_C BFu7i_BFu15s_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_S");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_S");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_S, BFu7i_BFu15s_S)
//============================================================================



static void Test_BFu7i_BFu15s_Uc()
{
  {
    init_simple_test("BFu7i_BFu15s_Uc");
    static STRUCT_IF_C BFu7i_BFu15s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Uc");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Uc");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Uc, BFu7i_BFu15s_Uc)
//============================================================================



static void Test_BFu7i_BFu15s_Ui()
{
  {
    init_simple_test("BFu7i_BFu15s_Ui");
    static STRUCT_IF_C BFu7i_BFu15s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Ui");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Ui");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Ui, BFu7i_BFu15s_Ui)
//============================================================================



static void Test_BFu7i_BFu15s_Ul()
{
  {
    init_simple_test("BFu7i_BFu15s_Ul");
    static STRUCT_IF_C BFu7i_BFu15s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Ul");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Ul");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Ul, BFu7i_BFu15s_Ul)
//============================================================================



static void Test_BFu7i_BFu15s_Us()
{
  {
    init_simple_test("BFu7i_BFu15s_Us");
    static STRUCT_IF_C BFu7i_BFu15s_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Us");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Us");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Us, BFu7i_BFu15s_Us)
//============================================================================



static void Test_BFu7i_BFu15s_Vp()
{
  {
    init_simple_test("BFu7i_BFu15s_Vp");
    static STRUCT_IF_C BFu7i_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Vp");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Vp");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Vp, BFu7i_BFu15s_Vp)
//============================================================================



static void Test_BFu7i_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu16i");
    static STRUCT_IF_C BFu7i_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i, BFu7i_BFu16i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu15i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu15i, BFu7i_BFu16i_BFu15i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu15ll, BFu7i_BFu16i_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu15s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu15s, BFu7i_BFu16i_BFu15s)
//============================================================================



static void Test_BFu7i_BFu16i_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu16i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu16i, BFu7i_BFu16i_BFu16i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu16ll, BFu7i_BFu16i_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu16s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu16s, BFu7i_BFu16i_BFu16s)
//============================================================================



static void Test_BFu7i_BFu16i_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu17i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu7i_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu17i, BFu7i_BFu16i_BFu17i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu7i_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu17ll, BFu7i_BFu16i_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu1c");
    static STRUCT_IF_C BFu7i_BFu16i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu1c, BFu7i_BFu16i_BFu1c)
//============================================================================



static void Test_BFu7i_BFu16i_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu1i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu1i, BFu7i_BFu16i_BFu1i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu1ll, BFu7i_BFu16i_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu1s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu1s, BFu7i_BFu16i_BFu1s)
//============================================================================



static void Test_BFu7i_BFu16i_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu31i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu7i_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu31i, BFu7i_BFu16i_BFu31i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu7i_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu31ll, BFu7i_BFu16i_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu32i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu7i_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu32i, BFu7i_BFu16i_BFu32i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu7i_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu32ll, BFu7i_BFu16i_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu33()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu33");
    static STRUCT_IF_C BFu7i_BFu16i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu7i_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu33, BFu7i_BFu16i_BFu33)
//============================================================================



static void Test_BFu7i_BFu16i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu7c");
    static STRUCT_IF_C BFu7i_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu7c, BFu7i_BFu16i_BFu7c)
//============================================================================



static void Test_BFu7i_BFu16i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu7i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu7i, BFu7i_BFu16i_BFu7i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu7ll, BFu7i_BFu16i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu7s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu7s, BFu7i_BFu16i_BFu7s)
//============================================================================



static void Test_BFu7i_BFu16i_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu8c");
    static STRUCT_IF_C BFu7i_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu8c, BFu7i_BFu16i_BFu8c)
//============================================================================



static void Test_BFu7i_BFu16i_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu8i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu8i, BFu7i_BFu16i_BFu8i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu8ll, BFu7i_BFu16i_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu8s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu8s, BFu7i_BFu16i_BFu8s)
//============================================================================



static void Test_BFu7i_BFu16i_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu9i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu9i, BFu7i_BFu16i_BFu9i)
//============================================================================



static void Test_BFu7i_BFu16i_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu9ll, BFu7i_BFu16i_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu16i_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu9s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu9s, BFu7i_BFu16i_BFu9s)
//============================================================================



static void Test_BFu7i_BFu16i_C()
{
  {
    init_simple_test("BFu7i_BFu16i_C");
    static STRUCT_IF_C BFu7i_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_C");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_C");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_C, BFu7i_BFu16i_C)
//============================================================================



static void Test_BFu7i_BFu16i_D()
{
  {
    init_simple_test("BFu7i_BFu16i_D");
    static STRUCT_IF_C BFu7i_BFu16i_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_D");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_D");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_D, BFu7i_BFu16i_D)
//============================================================================



static void Test_BFu7i_BFu16i_F()
{
  {
    init_simple_test("BFu7i_BFu16i_F");
    static STRUCT_IF_C BFu7i_BFu16i_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_F");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_F");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_F, BFu7i_BFu16i_F)
//============================================================================



static void Test_BFu7i_BFu16i_I()
{
  {
    init_simple_test("BFu7i_BFu16i_I");
    static STRUCT_IF_C BFu7i_BFu16i_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_I");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_I");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_I, BFu7i_BFu16i_I)
//============================================================================



static void Test_BFu7i_BFu16i_Ip()
{
  {
    init_simple_test("BFu7i_BFu16i_Ip");
    static STRUCT_IF_C BFu7i_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Ip");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Ip");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Ip, BFu7i_BFu16i_Ip)
//============================================================================



static void Test_BFu7i_BFu16i_L()
{
  {
    init_simple_test("BFu7i_BFu16i_L");
    static STRUCT_IF_C BFu7i_BFu16i_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_L");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_L");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_L, BFu7i_BFu16i_L)
//============================================================================



static void Test_BFu7i_BFu16i_S()
{
  {
    init_simple_test("BFu7i_BFu16i_S");
    static STRUCT_IF_C BFu7i_BFu16i_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_S");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_S");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_S, BFu7i_BFu16i_S)
//============================================================================



static void Test_BFu7i_BFu16i_Uc()
{
  {
    init_simple_test("BFu7i_BFu16i_Uc");
    static STRUCT_IF_C BFu7i_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Uc");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Uc");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Uc, BFu7i_BFu16i_Uc)
//============================================================================



static void Test_BFu7i_BFu16i_Ui()
{
  {
    init_simple_test("BFu7i_BFu16i_Ui");
    static STRUCT_IF_C BFu7i_BFu16i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Ui");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Ui");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Ui, BFu7i_BFu16i_Ui)
//============================================================================



static void Test_BFu7i_BFu16i_Ul()
{
  {
    init_simple_test("BFu7i_BFu16i_Ul");
    static STRUCT_IF_C BFu7i_BFu16i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Ul");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Ul");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Ul, BFu7i_BFu16i_Ul)
//============================================================================



static void Test_BFu7i_BFu16i_Us()
{
  {
    init_simple_test("BFu7i_BFu16i_Us");
    static STRUCT_IF_C BFu7i_BFu16i_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Us");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Us");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Us, BFu7i_BFu16i_Us)
//============================================================================



static void Test_BFu7i_BFu16i_Vp()
{
  {
    init_simple_test("BFu7i_BFu16i_Vp");
    static STRUCT_IF_C BFu7i_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Vp");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Vp");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Vp, BFu7i_BFu16i_Vp)
//============================================================================



static void Test_BFu7i_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll, BFu7i_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu15i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu15i, BFu7i_BFu16ll_BFu15i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu15ll, BFu7i_BFu16ll_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu15s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu15s, BFu7i_BFu16ll_BFu15s)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu16i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu16i, BFu7i_BFu16ll_BFu16i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu16ll, BFu7i_BFu16ll_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu16s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu16s, BFu7i_BFu16ll_BFu16s)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu17i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu7i_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu17i, BFu7i_BFu16ll_BFu17i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu7i_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu17ll, BFu7i_BFu16ll_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu1c");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu1c, BFu7i_BFu16ll_BFu1c)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu1i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu1i, BFu7i_BFu16ll_BFu1i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu1ll, BFu7i_BFu16ll_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu1s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu1s, BFu7i_BFu16ll_BFu1s)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu31i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu7i_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu31i, BFu7i_BFu16ll_BFu31i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu7i_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu31ll, BFu7i_BFu16ll_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu32i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu7i_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu32i, BFu7i_BFu16ll_BFu32i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu7i_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu32ll, BFu7i_BFu16ll_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu33()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu33");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu7i_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu33, BFu7i_BFu16ll_BFu33)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu7c, BFu7i_BFu16ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu7i, BFu7i_BFu16ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu7ll, BFu7i_BFu16ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu7s, BFu7i_BFu16ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu8c");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu8c, BFu7i_BFu16ll_BFu8c)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu8i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu8i, BFu7i_BFu16ll_BFu8i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu8ll, BFu7i_BFu16ll_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu8s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu8s, BFu7i_BFu16ll_BFu8s)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu9i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu9i, BFu7i_BFu16ll_BFu9i)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu9ll, BFu7i_BFu16ll_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu16ll_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu9s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu9s, BFu7i_BFu16ll_BFu9s)
//============================================================================



static void Test_BFu7i_BFu16ll_C()
{
  {
    init_simple_test("BFu7i_BFu16ll_C");
    static STRUCT_IF_C BFu7i_BFu16ll_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_C");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_C");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_C, BFu7i_BFu16ll_C)
//============================================================================



static void Test_BFu7i_BFu16ll_D()
{
  {
    init_simple_test("BFu7i_BFu16ll_D");
    static STRUCT_IF_C BFu7i_BFu16ll_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_D");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_D");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_D, BFu7i_BFu16ll_D)
//============================================================================



static void Test_BFu7i_BFu16ll_F()
{
  {
    init_simple_test("BFu7i_BFu16ll_F");
    static STRUCT_IF_C BFu7i_BFu16ll_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_F");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_F");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_F, BFu7i_BFu16ll_F)
//============================================================================



static void Test_BFu7i_BFu16ll_I()
{
  {
    init_simple_test("BFu7i_BFu16ll_I");
    static STRUCT_IF_C BFu7i_BFu16ll_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_I");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_I");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_I, BFu7i_BFu16ll_I)
//============================================================================



static void Test_BFu7i_BFu16ll_Ip()
{
  {
    init_simple_test("BFu7i_BFu16ll_Ip");
    static STRUCT_IF_C BFu7i_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Ip, BFu7i_BFu16ll_Ip)
//============================================================================



static void Test_BFu7i_BFu16ll_L()
{
  {
    init_simple_test("BFu7i_BFu16ll_L");
    static STRUCT_IF_C BFu7i_BFu16ll_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_L");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_L");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_L, BFu7i_BFu16ll_L)
//============================================================================



static void Test_BFu7i_BFu16ll_S()
{
  {
    init_simple_test("BFu7i_BFu16ll_S");
    static STRUCT_IF_C BFu7i_BFu16ll_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_S");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_S");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_S, BFu7i_BFu16ll_S)
//============================================================================



static void Test_BFu7i_BFu16ll_Uc()
{
  {
    init_simple_test("BFu7i_BFu16ll_Uc");
    static STRUCT_IF_C BFu7i_BFu16ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Uc, BFu7i_BFu16ll_Uc)
//============================================================================



static void Test_BFu7i_BFu16ll_Ui()
{
  {
    init_simple_test("BFu7i_BFu16ll_Ui");
    static STRUCT_IF_C BFu7i_BFu16ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Ui, BFu7i_BFu16ll_Ui)
//============================================================================



static void Test_BFu7i_BFu16ll_Ul()
{
  {
    init_simple_test("BFu7i_BFu16ll_Ul");
    static STRUCT_IF_C BFu7i_BFu16ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Ul, BFu7i_BFu16ll_Ul)
//============================================================================



static void Test_BFu7i_BFu16ll_Us()
{
  {
    init_simple_test("BFu7i_BFu16ll_Us");
    static STRUCT_IF_C BFu7i_BFu16ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Us");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Us");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Us, BFu7i_BFu16ll_Us)
//============================================================================



static void Test_BFu7i_BFu16ll_Vp()
{
  {
    init_simple_test("BFu7i_BFu16ll_Vp");
    static STRUCT_IF_C BFu7i_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Vp, BFu7i_BFu16ll_Vp)
//============================================================================



static void Test_BFu7i_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu16s");
    static STRUCT_IF_C BFu7i_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s, BFu7i_BFu16s)
//============================================================================



static void Test_BFu7i_BFu16s_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu15i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu15i, BFu7i_BFu16s_BFu15i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu15ll, BFu7i_BFu16s_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu15s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu7i_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu15s, BFu7i_BFu16s_BFu15s)
//============================================================================



static void Test_BFu7i_BFu16s_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu16i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu16i, BFu7i_BFu16s_BFu16i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu16ll, BFu7i_BFu16s_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu16s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu7i_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu16s, BFu7i_BFu16s_BFu16s)
//============================================================================



static void Test_BFu7i_BFu16s_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu17i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu7i_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu17i, BFu7i_BFu16s_BFu17i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu7i_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu17ll, BFu7i_BFu16s_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu1c");
    static STRUCT_IF_C BFu7i_BFu16s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu1c, BFu7i_BFu16s_BFu1c)
//============================================================================



static void Test_BFu7i_BFu16s_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu1i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu1i, BFu7i_BFu16s_BFu1i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu1ll, BFu7i_BFu16s_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu1s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu7i_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu1s, BFu7i_BFu16s_BFu1s)
//============================================================================



static void Test_BFu7i_BFu16s_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu31i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu7i_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu31i, BFu7i_BFu16s_BFu31i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu7i_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu31ll, BFu7i_BFu16s_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu32i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu7i_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu32i, BFu7i_BFu16s_BFu32i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu7i_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu32ll, BFu7i_BFu16s_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu33()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu33");
    static STRUCT_IF_C BFu7i_BFu16s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu7i_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu33, BFu7i_BFu16s_BFu33)
//============================================================================



static void Test_BFu7i_BFu16s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu7c");
    static STRUCT_IF_C BFu7i_BFu16s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu7c, BFu7i_BFu16s_BFu7c)
//============================================================================



static void Test_BFu7i_BFu16s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu7i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu7i, BFu7i_BFu16s_BFu7i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu7ll, BFu7i_BFu16s_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu7s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu7i_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu7s, BFu7i_BFu16s_BFu7s)
//============================================================================



static void Test_BFu7i_BFu16s_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu8c");
    static STRUCT_IF_C BFu7i_BFu16s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu8c, BFu7i_BFu16s_BFu8c)
//============================================================================



static void Test_BFu7i_BFu16s_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu8i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu8i, BFu7i_BFu16s_BFu8i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu8ll, BFu7i_BFu16s_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu8s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu7i_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu8s, BFu7i_BFu16s_BFu8s)
//============================================================================



static void Test_BFu7i_BFu16s_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu9i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu9i, BFu7i_BFu16s_BFu9i)
//============================================================================



static void Test_BFu7i_BFu16s_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu9ll, BFu7i_BFu16s_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu16s_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu9s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu7i_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu9s, BFu7i_BFu16s_BFu9s)
//============================================================================



static void Test_BFu7i_BFu16s_C()
{
  {
    init_simple_test("BFu7i_BFu16s_C");
    static STRUCT_IF_C BFu7i_BFu16s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_C");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_C");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_C, BFu7i_BFu16s_C)
//============================================================================



static void Test_BFu7i_BFu16s_D()
{
  {
    init_simple_test("BFu7i_BFu16s_D");
    static STRUCT_IF_C BFu7i_BFu16s_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_D");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_D");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_D, BFu7i_BFu16s_D)
//============================================================================



static void Test_BFu7i_BFu16s_F()
{
  {
    init_simple_test("BFu7i_BFu16s_F");
    static STRUCT_IF_C BFu7i_BFu16s_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_F");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_F");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_F, BFu7i_BFu16s_F)
//============================================================================



static void Test_BFu7i_BFu16s_I()
{
  {
    init_simple_test("BFu7i_BFu16s_I");
    static STRUCT_IF_C BFu7i_BFu16s_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_I");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_I");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_I, BFu7i_BFu16s_I)
//============================================================================



static void Test_BFu7i_BFu16s_Ip()
{
  {
    init_simple_test("BFu7i_BFu16s_Ip");
    static STRUCT_IF_C BFu7i_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Ip");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Ip");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Ip, BFu7i_BFu16s_Ip)
//============================================================================



static void Test_BFu7i_BFu16s_L()
{
  {
    init_simple_test("BFu7i_BFu16s_L");
    static STRUCT_IF_C BFu7i_BFu16s_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_L");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_L");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_L, BFu7i_BFu16s_L)
//============================================================================



static void Test_BFu7i_BFu16s_S()
{
  {
    init_simple_test("BFu7i_BFu16s_S");
    static STRUCT_IF_C BFu7i_BFu16s_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_S");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_S");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_S, BFu7i_BFu16s_S)
//============================================================================



static void Test_BFu7i_BFu16s_Uc()
{
  {
    init_simple_test("BFu7i_BFu16s_Uc");
    static STRUCT_IF_C BFu7i_BFu16s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Uc");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Uc");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Uc, BFu7i_BFu16s_Uc)
//============================================================================



static void Test_BFu7i_BFu16s_Ui()
{
  {
    init_simple_test("BFu7i_BFu16s_Ui");
    static STRUCT_IF_C BFu7i_BFu16s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Ui");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Ui");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Ui, BFu7i_BFu16s_Ui)
//============================================================================



static void Test_BFu7i_BFu16s_Ul()
{
  {
    init_simple_test("BFu7i_BFu16s_Ul");
    static STRUCT_IF_C BFu7i_BFu16s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Ul");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Ul");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Ul, BFu7i_BFu16s_Ul)
//============================================================================



static void Test_BFu7i_BFu16s_Us()
{
  {
    init_simple_test("BFu7i_BFu16s_Us");
    static STRUCT_IF_C BFu7i_BFu16s_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Us");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Us");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Us, BFu7i_BFu16s_Us)
//============================================================================



static void Test_BFu7i_BFu16s_Vp()
{
  {
    init_simple_test("BFu7i_BFu16s_Vp");
    static STRUCT_IF_C BFu7i_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Vp");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Vp");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Vp, BFu7i_BFu16s_Vp)
//============================================================================



static void Test_BFu7i_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu17i");
    static STRUCT_IF_C BFu7i_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i, BFu7i_BFu17i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu15i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7i_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu15i, BFu7i_BFu17i_BFu15i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7i_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu15ll, BFu7i_BFu17i_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu15s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7i_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu15s, BFu7i_BFu17i_BFu15s)
//============================================================================



static void Test_BFu7i_BFu17i_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu16i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7i_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu16i, BFu7i_BFu17i_BFu16i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7i_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu16ll, BFu7i_BFu17i_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu16s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7i_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu16s, BFu7i_BFu17i_BFu16s)
//============================================================================



static void Test_BFu7i_BFu17i_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu17i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7i_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu7i_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu17i, BFu7i_BFu17i_BFu17i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7i_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu7i_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu17ll, BFu7i_BFu17i_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu1c");
    static STRUCT_IF_C BFu7i_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu1c, BFu7i_BFu17i_BFu1c)
//============================================================================



static void Test_BFu7i_BFu17i_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu1i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu1i, BFu7i_BFu17i_BFu1i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu1ll, BFu7i_BFu17i_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu1s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu1s, BFu7i_BFu17i_BFu1s)
//============================================================================



static void Test_BFu7i_BFu17i_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu31i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu7i_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu31i, BFu7i_BFu17i_BFu31i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu7i_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu31ll, BFu7i_BFu17i_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu32i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu7i_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu32i, BFu7i_BFu17i_BFu32i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu7i_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu32ll, BFu7i_BFu17i_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu33()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu33");
    static STRUCT_IF_C BFu7i_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu7i_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu7i_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu33, BFu7i_BFu17i_BFu33)
//============================================================================



static void Test_BFu7i_BFu17i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu7c");
    static STRUCT_IF_C BFu7i_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu7c, BFu7i_BFu17i_BFu7c)
//============================================================================



static void Test_BFu7i_BFu17i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu7i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu7i, BFu7i_BFu17i_BFu7i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu7ll, BFu7i_BFu17i_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu7s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu7s, BFu7i_BFu17i_BFu7s)
//============================================================================



static void Test_BFu7i_BFu17i_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu8c");
    static STRUCT_IF_C BFu7i_BFu17i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu8c, BFu7i_BFu17i_BFu8c)
//============================================================================



static void Test_BFu7i_BFu17i_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu8i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu8i, BFu7i_BFu17i_BFu8i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu8ll, BFu7i_BFu17i_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu8s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu8s, BFu7i_BFu17i_BFu8s)
//============================================================================



static void Test_BFu7i_BFu17i_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu9i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7i_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu9i, BFu7i_BFu17i_BFu9i)
//============================================================================



static void Test_BFu7i_BFu17i_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7i_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu9ll, BFu7i_BFu17i_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu17i_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu9s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7i_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu9s, BFu7i_BFu17i_BFu9s)
//============================================================================



static void Test_BFu7i_BFu17i_C()
{
  {
    init_simple_test("BFu7i_BFu17i_C");
    static STRUCT_IF_C BFu7i_BFu17i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_C");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_C");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_C, BFu7i_BFu17i_C)
//============================================================================



static void Test_BFu7i_BFu17i_D()
{
  {
    init_simple_test("BFu7i_BFu17i_D");
    static STRUCT_IF_C BFu7i_BFu17i_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_D");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_D");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_D, BFu7i_BFu17i_D)
//============================================================================



static void Test_BFu7i_BFu17i_F()
{
  {
    init_simple_test("BFu7i_BFu17i_F");
    static STRUCT_IF_C BFu7i_BFu17i_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_F");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_F");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_F, BFu7i_BFu17i_F)
//============================================================================



static void Test_BFu7i_BFu17i_I()
{
  {
    init_simple_test("BFu7i_BFu17i_I");
    static STRUCT_IF_C BFu7i_BFu17i_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_I");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_I");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_I, BFu7i_BFu17i_I)
//============================================================================



static void Test_BFu7i_BFu17i_Ip()
{
  {
    init_simple_test("BFu7i_BFu17i_Ip");
    static STRUCT_IF_C BFu7i_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Ip");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Ip");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Ip, BFu7i_BFu17i_Ip)
//============================================================================



static void Test_BFu7i_BFu17i_L()
{
  {
    init_simple_test("BFu7i_BFu17i_L");
    static STRUCT_IF_C BFu7i_BFu17i_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_L");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_L");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_L, BFu7i_BFu17i_L)
//============================================================================



static void Test_BFu7i_BFu17i_S()
{
  {
    init_simple_test("BFu7i_BFu17i_S");
    static STRUCT_IF_C BFu7i_BFu17i_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_S");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_S");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_S, BFu7i_BFu17i_S)
//============================================================================



static void Test_BFu7i_BFu17i_Uc()
{
  {
    init_simple_test("BFu7i_BFu17i_Uc");
    static STRUCT_IF_C BFu7i_BFu17i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Uc");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Uc");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Uc, BFu7i_BFu17i_Uc)
//============================================================================



static void Test_BFu7i_BFu17i_Ui()
{
  {
    init_simple_test("BFu7i_BFu17i_Ui");
    static STRUCT_IF_C BFu7i_BFu17i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Ui");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Ui");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Ui, BFu7i_BFu17i_Ui)
//============================================================================



static void Test_BFu7i_BFu17i_Ul()
{
  {
    init_simple_test("BFu7i_BFu17i_Ul");
    static STRUCT_IF_C BFu7i_BFu17i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Ul");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Ul");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Ul, BFu7i_BFu17i_Ul)
//============================================================================



static void Test_BFu7i_BFu17i_Us()
{
  {
    init_simple_test("BFu7i_BFu17i_Us");
    static STRUCT_IF_C BFu7i_BFu17i_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Us");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Us");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Us, BFu7i_BFu17i_Us)
//============================================================================



static void Test_BFu7i_BFu17i_Vp()
{
  {
    init_simple_test("BFu7i_BFu17i_Vp");
    static STRUCT_IF_C BFu7i_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Vp");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Vp");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Vp, BFu7i_BFu17i_Vp)
//============================================================================



static void Test_BFu7i_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll, BFu7i_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu15i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7i_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu15i, BFu7i_BFu17ll_BFu15i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7i_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu15ll, BFu7i_BFu17ll_BFu15ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu15s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu7i_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu15s, BFu7i_BFu17ll_BFu15s)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu16i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7i_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu16i, BFu7i_BFu17ll_BFu16i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7i_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu16ll, BFu7i_BFu17ll_BFu16ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu16s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu7i_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu16s, BFu7i_BFu17ll_BFu16s)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu17i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu7i_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu7i_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu17i, BFu7i_BFu17ll_BFu17i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu7i_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu7i_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu17ll, BFu7i_BFu17ll_BFu17ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu1c");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu1c, BFu7i_BFu17ll_BFu1c)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu1i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu1i, BFu7i_BFu17ll_BFu1i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu1ll, BFu7i_BFu17ll_BFu1ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu1s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu7i_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu1s, BFu7i_BFu17ll_BFu1s)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu31i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu7i_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu31i, BFu7i_BFu17ll_BFu31i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu7i_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu31ll, BFu7i_BFu17ll_BFu31ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu32i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu7i_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu32i, BFu7i_BFu17ll_BFu32i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu7i_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu32ll, BFu7i_BFu17ll_BFu32ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu33()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu33");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu7i_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu7i_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu33, BFu7i_BFu17ll_BFu33)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu7c, BFu7i_BFu17ll_BFu7c)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu7i, BFu7i_BFu17ll_BFu7i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu7ll, BFu7i_BFu17ll_BFu7ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu7i_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu7s, BFu7i_BFu17ll_BFu7s)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu8c");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu8c, BFu7i_BFu17ll_BFu8c)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu8i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu8i, BFu7i_BFu17ll_BFu8i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu8ll, BFu7i_BFu17ll_BFu8ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu8s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu7i_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu8s, BFu7i_BFu17ll_BFu8s)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu9i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7i_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu9i, BFu7i_BFu17ll_BFu9i)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7i_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu9ll, BFu7i_BFu17ll_BFu9ll)
//============================================================================



static void Test_BFu7i_BFu17ll_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu9s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu7i_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu9s, BFu7i_BFu17ll_BFu9s)
//============================================================================



static void Test_BFu7i_BFu17ll_C()
{
  {
    init_simple_test("BFu7i_BFu17ll_C");
    static STRUCT_IF_C BFu7i_BFu17ll_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_C");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_C");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_C");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_C, BFu7i_BFu17ll_C)
//============================================================================



static void Test_BFu7i_BFu17ll_D()
{
  {
    init_simple_test("BFu7i_BFu17ll_D");
    static STRUCT_IF_C BFu7i_BFu17ll_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_D");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_D");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_D");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_D, BFu7i_BFu17ll_D)
//============================================================================



static void Test_BFu7i_BFu17ll_F()
{
  {
    init_simple_test("BFu7i_BFu17ll_F");
    static STRUCT_IF_C BFu7i_BFu17ll_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_F");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_F");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_F");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_F, BFu7i_BFu17ll_F)
//============================================================================



static void Test_BFu7i_BFu17ll_I()
{
  {
    init_simple_test("BFu7i_BFu17ll_I");
    static STRUCT_IF_C BFu7i_BFu17ll_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_I");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_I");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_I");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_I, BFu7i_BFu17ll_I)
//============================================================================



static void Test_BFu7i_BFu17ll_Ip()
{
  {
    init_simple_test("BFu7i_BFu17ll_Ip");
    static STRUCT_IF_C BFu7i_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Ip");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Ip, BFu7i_BFu17ll_Ip)
//============================================================================



static void Test_BFu7i_BFu17ll_L()
{
  {
    init_simple_test("BFu7i_BFu17ll_L");
    static STRUCT_IF_C BFu7i_BFu17ll_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_L");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_L");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_L");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_L, BFu7i_BFu17ll_L)
//============================================================================



static void Test_BFu7i_BFu17ll_S()
{
  {
    init_simple_test("BFu7i_BFu17ll_S");
    static STRUCT_IF_C BFu7i_BFu17ll_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_S");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_S");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_S");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_S, BFu7i_BFu17ll_S)
//============================================================================



static void Test_BFu7i_BFu17ll_Uc()
{
  {
    init_simple_test("BFu7i_BFu17ll_Uc");
    static STRUCT_IF_C BFu7i_BFu17ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Uc");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Uc, BFu7i_BFu17ll_Uc)
//============================================================================



static void Test_BFu7i_BFu17ll_Ui()
{
  {
    init_simple_test("BFu7i_BFu17ll_Ui");
    static STRUCT_IF_C BFu7i_BFu17ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu7i_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Ui");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Ui, BFu7i_BFu17ll_Ui)
//============================================================================



static void Test_BFu7i_BFu17ll_Ul()
{
  {
    init_simple_test("BFu7i_BFu17ll_Ul");
    static STRUCT_IF_C BFu7i_BFu17ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu7i_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Ul");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Ul, BFu7i_BFu17ll_Ul)
//============================================================================



static void Test_BFu7i_BFu17ll_Us()
{
  {
    init_simple_test("BFu7i_BFu17ll_Us");
    static STRUCT_IF_C BFu7i_BFu17ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Us");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Us");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Us");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Us, BFu7i_BFu17ll_Us)
//============================================================================



static void Test_BFu7i_BFu17ll_Vp()
{
  {
    init_simple_test("BFu7i_BFu17ll_Vp");
    static STRUCT_IF_C BFu7i_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu7i_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Vp");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Vp, BFu7i_BFu17ll_Vp)
//============================================================================



static void Test_BFu7i_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu1c"