// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct BFu15i_BFu8c_BFu1i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:1; };
struct BFu15i_BFu8c_BFu1ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:1; };
struct BFu15i_BFu8c_BFu1s { unsigned int v1:15; unsigned char v2:8; unsigned short v3:1; };
struct BFu15i_BFu8c_BFu31i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:31; };
struct BFu15i_BFu8c_BFu31ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:31; };
struct BFu15i_BFu8c_BFu32i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:32; };
struct BFu15i_BFu8c_BFu32ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:32; };
struct BFu15i_BFu8c_BFu33 { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:33; };
struct BFu15i_BFu8c_BFu7c { unsigned int v1:15; unsigned char v2:8; unsigned char v3:7; };
struct BFu15i_BFu8c_BFu7i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:7; };
struct BFu15i_BFu8c_BFu7ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:7; };
struct BFu15i_BFu8c_BFu7s { unsigned int v1:15; unsigned char v2:8; unsigned short v3:7; };
struct BFu15i_BFu8c_BFu8c { unsigned int v1:15; unsigned char v2:8; unsigned char v3:8; };
struct BFu15i_BFu8c_BFu8i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:8; };
struct BFu15i_BFu8c_BFu8ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:8; };
struct BFu15i_BFu8c_BFu8s { unsigned int v1:15; unsigned char v2:8; unsigned short v3:8; };
struct BFu15i_BFu8c_BFu9i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:9; };
struct BFu15i_BFu8c_BFu9ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:9; };
struct BFu15i_BFu8c_BFu9s { unsigned int v1:15; unsigned char v2:8; unsigned short v3:9; };
struct BFu15i_BFu8c_C { unsigned int v1:15; unsigned char v2:8; char v3; };
struct BFu15i_BFu8c_D { unsigned int v1:15; unsigned char v2:8; double v3; };
struct BFu15i_BFu8c_F { unsigned int v1:15; unsigned char v2:8; float v3; };
struct BFu15i_BFu8c_I { unsigned int v1:15; unsigned char v2:8; int v3; };
struct BFu15i_BFu8c_Ip { unsigned int v1:15; unsigned char v2:8; int * v3; };
struct BFu15i_BFu8c_L { unsigned int v1:15; unsigned char v2:8; long long v3; };
struct BFu15i_BFu8c_S { unsigned int v1:15; unsigned char v2:8; short v3; };
struct BFu15i_BFu8c_Uc { unsigned int v1:15; unsigned char v2:8; unsigned char v3; };
struct BFu15i_BFu8c_Ui { unsigned int v1:15; unsigned char v2:8; unsigned int v3; };
struct BFu15i_BFu8c_Ul { unsigned int v1:15; unsigned char v2:8; unsigned long long v3; };
struct BFu15i_BFu8c_Us { unsigned int v1:15; unsigned char v2:8; unsigned short v3; };
struct BFu15i_BFu8c_Vp { unsigned int v1:15; unsigned char v2:8; void * v3; };
struct BFu15i_BFu8i { unsigned int v1:15; unsigned int v2:8; };
struct BFu15i_BFu8i_BFu15i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:15; };
struct BFu15i_BFu8i_BFu15ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:15; };
struct BFu15i_BFu8i_BFu15s { unsigned int v1:15; unsigned int v2:8; unsigned short v3:15; };
struct BFu15i_BFu8i_BFu16i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:16; };
struct BFu15i_BFu8i_BFu16ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:16; };
struct BFu15i_BFu8i_BFu16s { unsigned int v1:15; unsigned int v2:8; unsigned short v3:16; };
struct BFu15i_BFu8i_BFu17i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:17; };
struct BFu15i_BFu8i_BFu17ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:17; };
struct BFu15i_BFu8i_BFu1c { unsigned int v1:15; unsigned int v2:8; unsigned char v3:1; };
struct BFu15i_BFu8i_BFu1i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:1; };
struct BFu15i_BFu8i_BFu1ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:1; };
struct BFu15i_BFu8i_BFu1s { unsigned int v1:15; unsigned int v2:8; unsigned short v3:1; };
struct BFu15i_BFu8i_BFu31i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:31; };
struct BFu15i_BFu8i_BFu31ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:31; };
struct BFu15i_BFu8i_BFu32i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:32; };
struct BFu15i_BFu8i_BFu32ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:32; };
struct BFu15i_BFu8i_BFu33 { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:33; };
struct BFu15i_BFu8i_BFu7c { unsigned int v1:15; unsigned int v2:8; unsigned char v3:7; };
struct BFu15i_BFu8i_BFu7i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:7; };
struct BFu15i_BFu8i_BFu7ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:7; };
struct BFu15i_BFu8i_BFu7s { unsigned int v1:15; unsigned int v2:8; unsigned short v3:7; };
struct BFu15i_BFu8i_BFu8c { unsigned int v1:15; unsigned int v2:8; unsigned char v3:8; };
struct BFu15i_BFu8i_BFu8i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:8; };
struct BFu15i_BFu8i_BFu8ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:8; };
struct BFu15i_BFu8i_BFu8s { unsigned int v1:15; unsigned int v2:8; unsigned short v3:8; };
struct BFu15i_BFu8i_BFu9i { unsigned int v1:15; unsigned int v2:8; unsigned int v3:9; };
struct BFu15i_BFu8i_BFu9ll { unsigned int v1:15; unsigned int v2:8; unsigned long long v3:9; };
struct BFu15i_BFu8i_BFu9s { unsigned int v1:15; unsigned int v2:8; unsigned short v3:9; };
struct BFu15i_BFu8i_C { unsigned int v1:15; unsigned int v2:8; char v3; };
struct BFu15i_BFu8i_D { unsigned int v1:15; unsigned int v2:8; double v3; };
struct BFu15i_BFu8i_F { unsigned int v1:15; unsigned int v2:8; float v3; };
struct BFu15i_BFu8i_I { unsigned int v1:15; unsigned int v2:8; int v3; };
struct BFu15i_BFu8i_Ip { unsigned int v1:15; unsigned int v2:8; int * v3; };
struct BFu15i_BFu8i_L { unsigned int v1:15; unsigned int v2:8; long long v3; };
struct BFu15i_BFu8i_S { unsigned int v1:15; unsigned int v2:8; short v3; };
struct BFu15i_BFu8i_Uc { unsigned int v1:15; unsigned int v2:8; unsigned char v3; };
struct BFu15i_BFu8i_Ui { unsigned int v1:15; unsigned int v2:8; unsigned int v3; };
struct BFu15i_BFu8i_Ul { unsigned int v1:15; unsigned int v2:8; unsigned long long v3; };
struct BFu15i_BFu8i_Us { unsigned int v1:15; unsigned int v2:8; unsigned short v3; };
struct BFu15i_BFu8i_Vp { unsigned int v1:15; unsigned int v2:8; void * v3; };
struct BFu15i_BFu8ll { unsigned int v1:15; unsigned long long v2:8; };
struct BFu15i_BFu8ll_BFu15i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:15; };
struct BFu15i_BFu8ll_BFu15ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:15; };
struct BFu15i_BFu8ll_BFu15s { unsigned int v1:15; unsigned long long v2:8; unsigned short v3:15; };
struct BFu15i_BFu8ll_BFu16i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:16; };
struct BFu15i_BFu8ll_BFu16ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:16; };
struct BFu15i_BFu8ll_BFu16s { unsigned int v1:15; unsigned long long v2:8; unsigned short v3:16; };
struct BFu15i_BFu8ll_BFu17i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:17; };
struct BFu15i_BFu8ll_BFu17ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:17; };
struct BFu15i_BFu8ll_BFu1c { unsigned int v1:15; unsigned long long v2:8; unsigned char v3:1; };
struct BFu15i_BFu8ll_BFu1i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:1; };
struct BFu15i_BFu8ll_BFu1ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:1; };
struct BFu15i_BFu8ll_BFu1s { unsigned int v1:15; unsigned long long v2:8; unsigned short v3:1; };
struct BFu15i_BFu8ll_BFu31i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:31; };
struct BFu15i_BFu8ll_BFu31ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:31; };
struct BFu15i_BFu8ll_BFu32i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:32; };
struct BFu15i_BFu8ll_BFu32ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:32; };
struct BFu15i_BFu8ll_BFu33 { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:33; };
struct BFu15i_BFu8ll_BFu7c { unsigned int v1:15; unsigned long long v2:8; unsigned char v3:7; };
struct BFu15i_BFu8ll_BFu7i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:7; };
struct BFu15i_BFu8ll_BFu7ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:7; };
struct BFu15i_BFu8ll_BFu7s { unsigned int v1:15; unsigned long long v2:8; unsigned short v3:7; };
struct BFu15i_BFu8ll_BFu8c { unsigned int v1:15; unsigned long long v2:8; unsigned char v3:8; };
struct BFu15i_BFu8ll_BFu8i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:8; };
struct BFu15i_BFu8ll_BFu8ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:8; };
struct BFu15i_BFu8ll_BFu8s { unsigned int v1:15; unsigned long long v2:8; unsigned short v3:8; };
struct BFu15i_BFu8ll_BFu9i { unsigned int v1:15; unsigned long long v2:8; unsigned int v3:9; };
struct BFu15i_BFu8ll_BFu9ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3:9; };
struct BFu15i_BFu8ll_BFu9s { unsigned int v1:15; unsigned long long v2:8; unsigned short v3:9; };
struct BFu15i_BFu8ll_C { unsigned int v1:15; unsigned long long v2:8; char v3; };
struct BFu15i_BFu8ll_D { unsigned int v1:15; unsigned long long v2:8; double v3; };
struct BFu15i_BFu8ll_F { unsigned int v1:15; unsigned long long v2:8; float v3; };
struct BFu15i_BFu8ll_I { unsigned int v1:15; unsigned long long v2:8; int v3; };
struct BFu15i_BFu8ll_Ip { unsigned int v1:15; unsigned long long v2:8; int * v3; };
struct BFu15i_BFu8ll_L { unsigned int v1:15; unsigned long long v2:8; long long v3; };
struct BFu15i_BFu8ll_S { unsigned int v1:15; unsigned long long v2:8; short v3; };
struct BFu15i_BFu8ll_Uc { unsigned int v1:15; unsigned long long v2:8; unsigned char v3; };
struct BFu15i_BFu8ll_Ui { unsigned int v1:15; unsigned long long v2:8; unsigned int v3; };
struct BFu15i_BFu8ll_Ul { unsigned int v1:15; unsigned long long v2:8; unsigned long long v3; };
struct BFu15i_BFu8ll_Us { unsigned int v1:15; unsigned long long v2:8; unsigned short v3; };
struct BFu15i_BFu8ll_Vp { unsigned int v1:15; unsigned long long v2:8; void * v3; };
struct BFu15i_BFu8s { unsigned int v1:15; unsigned short v2:8; };
struct BFu15i_BFu8s_BFu15i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:15; };
struct BFu15i_BFu8s_BFu15ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:15; };
struct BFu15i_BFu8s_BFu15s { unsigned int v1:15; unsigned short v2:8; unsigned short v3:15; };
struct BFu15i_BFu8s_BFu16i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:16; };
struct BFu15i_BFu8s_BFu16ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:16; };
struct BFu15i_BFu8s_BFu16s { unsigned int v1:15; unsigned short v2:8; unsigned short v3:16; };
struct BFu15i_BFu8s_BFu17i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:17; };
struct BFu15i_BFu8s_BFu17ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:17; };
struct BFu15i_BFu8s_BFu1c { unsigned int v1:15; unsigned short v2:8; unsigned char v3:1; };
struct BFu15i_BFu8s_BFu1i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:1; };
struct BFu15i_BFu8s_BFu1ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:1; };
struct BFu15i_BFu8s_BFu1s { unsigned int v1:15; unsigned short v2:8; unsigned short v3:1; };
struct BFu15i_BFu8s_BFu31i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:31; };
struct BFu15i_BFu8s_BFu31ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:31; };
struct BFu15i_BFu8s_BFu32i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:32; };
struct BFu15i_BFu8s_BFu32ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:32; };
struct BFu15i_BFu8s_BFu33 { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:33; };
struct BFu15i_BFu8s_BFu7c { unsigned int v1:15; unsigned short v2:8; unsigned char v3:7; };
struct BFu15i_BFu8s_BFu7i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:7; };
struct BFu15i_BFu8s_BFu7ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:7; };
struct BFu15i_BFu8s_BFu7s { unsigned int v1:15; unsigned short v2:8; unsigned short v3:7; };
struct BFu15i_BFu8s_BFu8c { unsigned int v1:15; unsigned short v2:8; unsigned char v3:8; };
struct BFu15i_BFu8s_BFu8i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:8; };
struct BFu15i_BFu8s_BFu8ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:8; };
struct BFu15i_BFu8s_BFu8s { unsigned int v1:15; unsigned short v2:8; unsigned short v3:8; };
struct BFu15i_BFu8s_BFu9i { unsigned int v1:15; unsigned short v2:8; unsigned int v3:9; };
struct BFu15i_BFu8s_BFu9ll { unsigned int v1:15; unsigned short v2:8; unsigned long long v3:9; };
struct BFu15i_BFu8s_BFu9s { unsigned int v1:15; unsigned short v2:8; unsigned short v3:9; };
struct BFu15i_BFu8s_C { unsigned int v1:15; unsigned short v2:8; char v3; };
struct BFu15i_BFu8s_D { unsigned int v1:15; unsigned short v2:8; double v3; };
struct BFu15i_BFu8s_F { unsigned int v1:15; unsigned short v2:8; float v3; };
struct BFu15i_BFu8s_I { unsigned int v1:15; unsigned short v2:8; int v3; };
struct BFu15i_BFu8s_Ip { unsigned int v1:15; unsigned short v2:8; int * v3; };
struct BFu15i_BFu8s_L { unsigned int v1:15; unsigned short v2:8; long long v3; };
struct BFu15i_BFu8s_S { unsigned int v1:15; unsigned short v2:8; short v3; };
struct BFu15i_BFu8s_Uc { unsigned int v1:15; unsigned short v2:8; unsigned char v3; };
struct BFu15i_BFu8s_Ui { unsigned int v1:15; unsigned short v2:8; unsigned int v3; };
struct BFu15i_BFu8s_Ul { unsigned int v1:15; unsigned short v2:8; unsigned long long v3; };
struct BFu15i_BFu8s_Us { unsigned int v1:15; unsigned short v2:8; unsigned short v3; };
struct BFu15i_BFu8s_Vp { unsigned int v1:15; unsigned short v2:8; void * v3; };
struct BFu15i_BFu9i { unsigned int v1:15; unsigned int v2:9; };
struct BFu15i_BFu9i_BFu15i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:15; };
struct BFu15i_BFu9i_BFu15ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:15; };
struct BFu15i_BFu9i_BFu15s { unsigned int v1:15; unsigned int v2:9; unsigned short v3:15; };
struct BFu15i_BFu9i_BFu16i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:16; };
struct BFu15i_BFu9i_BFu16ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:16; };
struct BFu15i_BFu9i_BFu16s { unsigned int v1:15; unsigned int v2:9; unsigned short v3:16; };
struct BFu15i_BFu9i_BFu17i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:17; };
struct BFu15i_BFu9i_BFu17ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:17; };
struct BFu15i_BFu9i_BFu1c { unsigned int v1:15; unsigned int v2:9; unsigned char v3:1; };
struct BFu15i_BFu9i_BFu1i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:1; };
struct BFu15i_BFu9i_BFu1ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:1; };
struct BFu15i_BFu9i_BFu1s { unsigned int v1:15; unsigned int v2:9; unsigned short v3:1; };
struct BFu15i_BFu9i_BFu31i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:31; };
struct BFu15i_BFu9i_BFu31ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:31; };
struct BFu15i_BFu9i_BFu32i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:32; };
struct BFu15i_BFu9i_BFu32ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:32; };
struct BFu15i_BFu9i_BFu33 { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:33; };
struct BFu15i_BFu9i_BFu7c { unsigned int v1:15; unsigned int v2:9; unsigned char v3:7; };
struct BFu15i_BFu9i_BFu7i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:7; };
struct BFu15i_BFu9i_BFu7ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:7; };
struct BFu15i_BFu9i_BFu7s { unsigned int v1:15; unsigned int v2:9; unsigned short v3:7; };
struct BFu15i_BFu9i_BFu8c { unsigned int v1:15; unsigned int v2:9; unsigned char v3:8; };
struct BFu15i_BFu9i_BFu8i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:8; };
struct BFu15i_BFu9i_BFu8ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:8; };
struct BFu15i_BFu9i_BFu8s { unsigned int v1:15; unsigned int v2:9; unsigned short v3:8; };
struct BFu15i_BFu9i_BFu9i { unsigned int v1:15; unsigned int v2:9; unsigned int v3:9; };
struct BFu15i_BFu9i_BFu9ll { unsigned int v1:15; unsigned int v2:9; unsigned long long v3:9; };
struct BFu15i_BFu9i_BFu9s { unsigned int v1:15; unsigned int v2:9; unsigned short v3:9; };
struct BFu15i_BFu9i_C { unsigned int v1:15; unsigned int v2:9; char v3; };
struct BFu15i_BFu9i_D { unsigned int v1:15; unsigned int v2:9; double v3; };
struct BFu15i_BFu9i_F { unsigned int v1:15; unsigned int v2:9; float v3; };
struct BFu15i_BFu9i_I { unsigned int v1:15; unsigned int v2:9; int v3; };
struct BFu15i_BFu9i_Ip { unsigned int v1:15; unsigned int v2:9; int * v3; };
struct BFu15i_BFu9i_L { unsigned int v1:15; unsigned int v2:9; long long v3; };
struct BFu15i_BFu9i_S { unsigned int v1:15; unsigned int v2:9; short v3; };
struct BFu15i_BFu9i_Uc { unsigned int v1:15; unsigned int v2:9; unsigned char v3; };
struct BFu15i_BFu9i_Ui { unsigned int v1:15; unsigned int v2:9; unsigned int v3; };
struct BFu15i_BFu9i_Ul { unsigned int v1:15; unsigned int v2:9; unsigned long long v3; };
struct BFu15i_BFu9i_Us { unsigned int v1:15; unsigned int v2:9; unsigned short v3; };
struct BFu15i_BFu9i_Vp { unsigned int v1:15; unsigned int v2:9; void * v3; };
struct BFu15i_BFu9ll { unsigned int v1:15; unsigned long long v2:9; };
struct BFu15i_BFu9ll_BFu15i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:15; };
struct BFu15i_BFu9ll_BFu15ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:15; };
struct BFu15i_BFu9ll_BFu15s { unsigned int v1:15; unsigned long long v2:9; unsigned short v3:15; };
struct BFu15i_BFu9ll_BFu16i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:16; };
struct BFu15i_BFu9ll_BFu16ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:16; };
struct BFu15i_BFu9ll_BFu16s { unsigned int v1:15; unsigned long long v2:9; unsigned short v3:16; };
struct BFu15i_BFu9ll_BFu17i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:17; };
struct BFu15i_BFu9ll_BFu17ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:17; };
struct BFu15i_BFu9ll_BFu1c { unsigned int v1:15; unsigned long long v2:9; unsigned char v3:1; };
struct BFu15i_BFu9ll_BFu1i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:1; };
struct BFu15i_BFu9ll_BFu1ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:1; };
struct BFu15i_BFu9ll_BFu1s { unsigned int v1:15; unsigned long long v2:9; unsigned short v3:1; };
struct BFu15i_BFu9ll_BFu31i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:31; };
struct BFu15i_BFu9ll_BFu31ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:31; };
struct BFu15i_BFu9ll_BFu32i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:32; };
struct BFu15i_BFu9ll_BFu32ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:32; };
struct BFu15i_BFu9ll_BFu33 { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:33; };
struct BFu15i_BFu9ll_BFu7c { unsigned int v1:15; unsigned long long v2:9; unsigned char v3:7; };
struct BFu15i_BFu9ll_BFu7i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:7; };
struct BFu15i_BFu9ll_BFu7ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:7; };
struct BFu15i_BFu9ll_BFu7s { unsigned int v1:15; unsigned long long v2:9; unsigned short v3:7; };
struct BFu15i_BFu9ll_BFu8c { unsigned int v1:15; unsigned long long v2:9; unsigned char v3:8; };
struct BFu15i_BFu9ll_BFu8i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:8; };
struct BFu15i_BFu9ll_BFu8ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:8; };
struct BFu15i_BFu9ll_BFu8s { unsigned int v1:15; unsigned long long v2:9; unsigned short v3:8; };
struct BFu15i_BFu9ll_BFu9i { unsigned int v1:15; unsigned long long v2:9; unsigned int v3:9; };
struct BFu15i_BFu9ll_BFu9ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3:9; };
struct BFu15i_BFu9ll_BFu9s { unsigned int v1:15; unsigned long long v2:9; unsigned short v3:9; };
struct BFu15i_BFu9ll_C { unsigned int v1:15; unsigned long long v2:9; char v3; };
struct BFu15i_BFu9ll_D { unsigned int v1:15; unsigned long long v2:9; double v3; };
struct BFu15i_BFu9ll_F { unsigned int v1:15; unsigned long long v2:9; float v3; };
struct BFu15i_BFu9ll_I { unsigned int v1:15; unsigned long long v2:9; int v3; };
struct BFu15i_BFu9ll_Ip { unsigned int v1:15; unsigned long long v2:9; int * v3; };
struct BFu15i_BFu9ll_L { unsigned int v1:15; unsigned long long v2:9; long long v3; };
struct BFu15i_BFu9ll_S { unsigned int v1:15; unsigned long long v2:9; short v3; };
struct BFu15i_BFu9ll_Uc { unsigned int v1:15; unsigned long long v2:9; unsigned char v3; };
struct BFu15i_BFu9ll_Ui { unsigned int v1:15; unsigned long long v2:9; unsigned int v3; };
struct BFu15i_BFu9ll_Ul { unsigned int v1:15; unsigned long long v2:9; unsigned long long v3; };
struct BFu15i_BFu9ll_Us { unsigned int v1:15; unsigned long long v2:9; unsigned short v3; };
struct BFu15i_BFu9ll_Vp { unsigned int v1:15; unsigned long long v2:9; void * v3; };
struct BFu15i_BFu9s { unsigned int v1:15; unsigned short v2:9; };
struct BFu15i_BFu9s_BFu15i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:15; };
struct BFu15i_BFu9s_BFu15ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:15; };
struct BFu15i_BFu9s_BFu15s { unsigned int v1:15; unsigned short v2:9; unsigned short v3:15; };
struct BFu15i_BFu9s_BFu16i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:16; };
struct BFu15i_BFu9s_BFu16ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:16; };
struct BFu15i_BFu9s_BFu16s { unsigned int v1:15; unsigned short v2:9; unsigned short v3:16; };
struct BFu15i_BFu9s_BFu17i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:17; };
struct BFu15i_BFu9s_BFu17ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:17; };
struct BFu15i_BFu9s_BFu1c { unsigned int v1:15; unsigned short v2:9; unsigned char v3:1; };
struct BFu15i_BFu9s_BFu1i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:1; };
struct BFu15i_BFu9s_BFu1ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:1; };
struct BFu15i_BFu9s_BFu1s { unsigned int v1:15; unsigned short v2:9; unsigned short v3:1; };
struct BFu15i_BFu9s_BFu31i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:31; };
struct BFu15i_BFu9s_BFu31ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:31; };
struct BFu15i_BFu9s_BFu32i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:32; };
struct BFu15i_BFu9s_BFu32ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:32; };
struct BFu15i_BFu9s_BFu33 { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:33; };
struct BFu15i_BFu9s_BFu7c { unsigned int v1:15; unsigned short v2:9; unsigned char v3:7; };
struct BFu15i_BFu9s_BFu7i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:7; };
struct BFu15i_BFu9s_BFu7ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:7; };
struct BFu15i_BFu9s_BFu7s { unsigned int v1:15; unsigned short v2:9; unsigned short v3:7; };
struct BFu15i_BFu9s_BFu8c { unsigned int v1:15; unsigned short v2:9; unsigned char v3:8; };
struct BFu15i_BFu9s_BFu8i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:8; };
struct BFu15i_BFu9s_BFu8ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:8; };
struct BFu15i_BFu9s_BFu8s { unsigned int v1:15; unsigned short v2:9; unsigned short v3:8; };
struct BFu15i_BFu9s_BFu9i { unsigned int v1:15; unsigned short v2:9; unsigned int v3:9; };
struct BFu15i_BFu9s_BFu9ll { unsigned int v1:15; unsigned short v2:9; unsigned long long v3:9; };
struct BFu15i_BFu9s_BFu9s { unsigned int v1:15; unsigned short v2:9; unsigned short v3:9; };
struct BFu15i_BFu9s_C { unsigned int v1:15; unsigned short v2:9; char v3; };
struct BFu15i_BFu9s_D { unsigned int v1:15; unsigned short v2:9; double v3; };
struct BFu15i_BFu9s_F { unsigned int v1:15; unsigned short v2:9; float v3; };
struct BFu15i_BFu9s_I { unsigned int v1:15; unsigned short v2:9; int v3; };
struct BFu15i_BFu9s_Ip { unsigned int v1:15; unsigned short v2:9; int * v3; };
struct BFu15i_BFu9s_L { unsigned int v1:15; unsigned short v2:9; long long v3; };
struct BFu15i_BFu9s_S { unsigned int v1:15; unsigned short v2:9; short v3; };
struct BFu15i_BFu9s_Uc { unsigned int v1:15; unsigned short v2:9; unsigned char v3; };
struct BFu15i_BFu9s_Ui { unsigned int v1:15; unsigned short v2:9; unsigned int v3; };
struct BFu15i_BFu9s_Ul { unsigned int v1:15; unsigned short v2:9; unsigned long long v3; };
struct BFu15i_BFu9s_Us { unsigned int v1:15; unsigned short v2:9; unsigned short v3; };
struct BFu15i_BFu9s_Vp { unsigned int v1:15; unsigned short v2:9; void * v3; };
struct BFu15i_C { unsigned int v1:15; char v2; };
struct BFu15i_C_BFu15i { unsigned int v1:15; char v2; unsigned int v3:15; };
struct BFu15i_C_BFu15ll { unsigned int v1:15; char v2; unsigned long long v3:15; };
struct BFu15i_C_BFu15s { unsigned int v1:15; char v2; unsigned short v3:15; };
struct BFu15i_C_BFu16i { unsigned int v1:15; char v2; unsigned int v3:16; };
struct BFu15i_C_BFu16ll { unsigned int v1:15; char v2; unsigned long long v3:16; };
struct BFu15i_C_BFu16s { unsigned int v1:15; char v2; unsigned short v3:16; };
struct BFu15i_C_BFu17i { unsigned int v1:15; char v2; unsigned int v3:17; };
struct BFu15i_C_BFu17ll { unsigned int v1:15; char v2; unsigned long long v3:17; };
struct BFu15i_C_BFu1c { unsigned int v1:15; char v2; unsigned char v3:1; };
struct BFu15i_C_BFu1i { unsigned int v1:15; char v2; unsigned int v3:1; };
struct BFu15i_C_BFu1ll { unsigned int v1:15; char v2; unsigned long long v3:1; };
struct BFu15i_C_BFu1s { unsigned int v1:15; char v2; unsigned short v3:1; };
struct BFu15i_C_BFu31i { unsigned int v1:15; char v2; unsigned int v3:31; };
struct BFu15i_C_BFu31ll { unsigned int v1:15; char v2; unsigned long long v3:31; };
struct BFu15i_C_BFu32i { unsigned int v1:15; char v2; unsigned int v3:32; };
struct BFu15i_C_BFu32ll { unsigned int v1:15; char v2; unsigned long long v3:32; };
struct BFu15i_C_BFu33 { unsigned int v1:15; char v2; unsigned long long v3:33; };
struct BFu15i_C_BFu7c { unsigned int v1:15; char v2; unsigned char v3:7; };
struct BFu15i_C_BFu7i { unsigned int v1:15; char v2; unsigned int v3:7; };
struct BFu15i_C_BFu7ll { unsigned int v1:15; char v2; unsigned long long v3:7; };
struct BFu15i_C_BFu7s { unsigned int v1:15; char v2; unsigned short v3:7; };
struct BFu15i_C_BFu8c { unsigned int v1:15; char v2; unsigned char v3:8; };
struct BFu15i_C_BFu8i { unsigned int v1:15; char v2; unsigned int v3:8; };
struct BFu15i_C_BFu8ll { unsigned int v1:15; char v2; unsigned long long v3:8; };
struct BFu15i_C_BFu8s { unsigned int v1:15; char v2; unsigned short v3:8; };
struct BFu15i_C_BFu9i { unsigned int v1:15; char v2; unsigned int v3:9; };
struct BFu15i_C_BFu9ll { unsigned int v1:15; char v2; unsigned long long v3:9; };
struct BFu15i_C_BFu9s { unsigned int v1:15; char v2; unsigned short v3:9; };
struct BFu15i_C_C { unsigned int v1:15; char v2; char v3; };
struct BFu15i_C_D { unsigned int v1:15; char v2; double v3; };
struct BFu15i_C_F { unsigned int v1:15; char v2; float v3; };
struct BFu15i_C_I { unsigned int v1:15; char v2; int v3; };
struct BFu15i_C_Ip { unsigned int v1:15; char v2; int * v3; };
struct BFu15i_C_L { unsigned int v1:15; char v2; long long v3; };
struct BFu15i_C_S { unsigned int v1:15; char v2; short v3; };
struct BFu15i_C_Uc { unsigned int v1:15; char v2; unsigned char v3; };
struct BFu15i_C_Ui { unsigned int v1:15; char v2; unsigned int v3; };
struct BFu15i_C_Ul { unsigned int v1:15; char v2; unsigned long long v3; };
struct BFu15i_C_Us { unsigned int v1:15; char v2; unsigned short v3; };
struct BFu15i_C_Vp { unsigned int v1:15; char v2; void * v3; };
struct BFu15i_D { unsigned int v1:15; double v2; };
struct BFu15i_D_BFu15i { unsigned int v1:15; double v2; unsigned int v3:15; };
struct BFu15i_D_BFu15ll { unsigned int v1:15; double v2; unsigned long long v3:15; };
struct BFu15i_D_BFu15s { unsigned int v1:15; double v2; unsigned short v3:15; };
struct BFu15i_D_BFu16i { unsigned int v1:15; double v2; unsigned int v3:16; };
struct BFu15i_D_BFu16ll { unsigned int v1:15; double v2; unsigned long long v3:16; };
struct BFu15i_D_BFu16s { unsigned int v1:15; double v2; unsigned short v3:16; };
struct BFu15i_D_BFu17i { unsigned int v1:15; double v2; unsigned int v3:17; };
struct BFu15i_D_BFu17ll { unsigned int v1:15; double v2; unsigned long long v3:17; };
struct BFu15i_D_BFu1c { unsigned int v1:15; double v2; unsigned char v3:1; };
struct BFu15i_D_BFu1i { unsigned int v1:15; double v2; unsigned int v3:1; };
struct BFu15i_D_BFu1ll { unsigned int v1:15; double v2; unsigned long long v3:1; };
struct BFu15i_D_BFu1s { unsigned int v1:15; double v2; unsigned short v3:1; };
struct BFu15i_D_BFu31i { unsigned int v1:15; double v2; unsigned int v3:31; };
struct BFu15i_D_BFu31ll { unsigned int v1:15; double v2; unsigned long long v3:31; };
struct BFu15i_D_BFu32i { unsigned int v1:15; double v2; unsigned int v3:32; };
struct BFu15i_D_BFu32ll { unsigned int v1:15; double v2; unsigned long long v3:32; };
struct BFu15i_D_BFu33 { unsigned int v1:15; double v2; unsigned long long v3:33; };
struct BFu15i_D_BFu7c { unsigned int v1:15; double v2; unsigned char v3:7; };
struct BFu15i_D_BFu7i { unsigned int v1:15; double v2; unsigned int v3:7; };
struct BFu15i_D_BFu7ll { unsigned int v1:15; double v2; unsigned long long v3:7; };
struct BFu15i_D_BFu7s { unsigned int v1:15; double v2; unsigned short v3:7; };
struct BFu15i_D_BFu8c { unsigned int v1:15; double v2; unsigned char v3:8; };
struct BFu15i_D_BFu8i { unsigned int v1:15; double v2; unsigned int v3:8; };
struct BFu15i_D_BFu8ll { unsigned int v1:15; double v2; unsigned long long v3:8; };
struct BFu15i_D_BFu8s { unsigned int v1:15; double v2; unsigned short v3:8; };
struct BFu15i_D_BFu9i { unsigned int v1:15; double v2; unsigned int v3:9; };
struct BFu15i_D_BFu9ll { unsigned int v1:15; double v2; unsigned long long v3:9; };
struct BFu15i_D_BFu9s { unsigned int v1:15; double v2; unsigned short v3:9; };
struct BFu15i_D_C { unsigned int v1:15; double v2; char v3; };
struct BFu15i_D_D { unsigned int v1:15; double v2; double v3; };
struct BFu15i_D_F { unsigned int v1:15; double v2; float v3; };
struct BFu15i_D_I { unsigned int v1:15; double v2; int v3; };
struct BFu15i_D_Ip { unsigned int v1:15; double v2; int * v3; };
struct BFu15i_D_L { unsigned int v1:15; double v2; long long v3; };
struct BFu15i_D_S { unsigned int v1:15; double v2; short v3; };
struct BFu15i_D_Uc { unsigned int v1:15; double v2; unsigned char v3; };
struct BFu15i_D_Ui { unsigned int v1:15; double v2; unsigned int v3; };
struct BFu15i_D_Ul { unsigned int v1:15; double v2; unsigned long long v3; };
struct BFu15i_D_Us { unsigned int v1:15; double v2; unsigned short v3; };
struct BFu15i_D_Vp { unsigned int v1:15; double v2; void * v3; };
struct BFu15i_F { unsigned int v1:15; float v2; };
struct BFu15i_F_BFu15i { unsigned int v1:15; float v2; unsigned int v3:15; };
struct BFu15i_F_BFu15ll { unsigned int v1:15; float v2; unsigned long long v3:15; };
struct BFu15i_F_BFu15s { unsigned int v1:15; float v2; unsigned short v3:15; };
struct BFu15i_F_BFu16i { unsigned int v1:15; float v2; unsigned int v3:16; };
struct BFu15i_F_BFu16ll { unsigned int v1:15; float v2; unsigned long long v3:16; };
struct BFu15i_F_BFu16s { unsigned int v1:15; float v2; unsigned short v3:16; };
struct BFu15i_F_BFu17i { unsigned int v1:15; float v2; unsigned int v3:17; };
struct BFu15i_F_BFu17ll { unsigned int v1:15; float v2; unsigned long long v3:17; };
struct BFu15i_F_BFu1c { unsigned int v1:15; float v2; unsigned char v3:1; };
struct BFu15i_F_BFu1i { unsigned int v1:15; float v2; unsigned int v3:1; };
struct BFu15i_F_BFu1ll { unsigned int v1:15; float v2; unsigned long long v3:1; };
struct BFu15i_F_BFu1s { unsigned int v1:15; float v2; unsigned short v3:1; };
struct BFu15i_F_BFu31i { unsigned int v1:15; float v2; unsigned int v3:31; };
struct BFu15i_F_BFu31ll { unsigned int v1:15; float v2; unsigned long long v3:31; };
struct BFu15i_F_BFu32i { unsigned int v1:15; float v2; unsigned int v3:32; };
struct BFu15i_F_BFu32ll { unsigned int v1:15; float v2; unsigned long long v3:32; };
struct BFu15i_F_BFu33 { unsigned int v1:15; float v2; unsigned long long v3:33; };
struct BFu15i_F_BFu7c { unsigned int v1:15; float v2; unsigned char v3:7; };
struct BFu15i_F_BFu7i { unsigned int v1:15; float v2; unsigned int v3:7; };
struct BFu15i_F_BFu7ll { unsigned int v1:15; float v2; unsigned long long v3:7; };
struct BFu15i_F_BFu7s { unsigned int v1:15; float v2; unsigned short v3:7; };
struct BFu15i_F_BFu8c { unsigned int v1:15; float v2; unsigned char v3:8; };
struct BFu15i_F_BFu8i { unsigned int v1:15; float v2; unsigned int v3:8; };
struct BFu15i_F_BFu8ll { unsigned int v1:15; float v2; unsigned long long v3:8; };
struct BFu15i_F_BFu8s { unsigned int v1:15; float v2; unsigned short v3:8; };
struct BFu15i_F_BFu9i { unsigned int v1:15; float v2; unsigned int v3:9; };
struct BFu15i_F_BFu9ll { unsigned int v1:15; float v2; unsigned long long v3:9; };
struct BFu15i_F_BFu9s { unsigned int v1:15; float v2; unsigned short v3:9; };
struct BFu15i_F_C { unsigned int v1:15; float v2; char v3; };
struct BFu15i_F_D { unsigned int v1:15; float v2; double v3; };
struct BFu15i_F_F { unsigned int v1:15; float v2; float v3; };
struct BFu15i_F_I { unsigned int v1:15; float v2; int v3; };
struct BFu15i_F_Ip { unsigned int v1:15; float v2; int * v3; };
struct BFu15i_F_L { unsigned int v1:15; float v2; long long v3; };
struct BFu15i_F_S { unsigned int v1:15; float v2; short v3; };
struct BFu15i_F_Uc { unsigned int v1:15; float v2; unsigned char v3; };
struct BFu15i_F_Ui { unsigned int v1:15; float v2; unsigned int v3; };
struct BFu15i_F_Ul { unsigned int v1:15; float v2; unsigned long long v3; };
struct BFu15i_F_Us { unsigned int v1:15; float v2; unsigned short v3; };
struct BFu15i_F_Vp { unsigned int v1:15; float v2; void * v3; };
struct BFu15i_I { unsigned int v1:15; int v2; };
struct BFu15i_I_BFu15i { unsigned int v1:15; int v2; unsigned int v3:15; };
struct BFu15i_I_BFu15ll { unsigned int v1:15; int v2; unsigned long long v3:15; };
struct BFu15i_I_BFu15s { unsigned int v1:15; int v2; unsigned short v3:15; };
struct BFu15i_I_BFu16i { unsigned int v1:15; int v2; unsigned int v3:16; };
struct BFu15i_I_BFu16ll { unsigned int v1:15; int v2; unsigned long long v3:16; };
struct BFu15i_I_BFu16s { unsigned int v1:15; int v2; unsigned short v3:16; };
struct BFu15i_I_BFu17i { unsigned int v1:15; int v2; unsigned int v3:17; };
struct BFu15i_I_BFu17ll { unsigned int v1:15; int v2; unsigned long long v3:17; };
struct BFu15i_I_BFu1c { unsigned int v1:15; int v2; unsigned char v3:1; };
struct BFu15i_I_BFu1i { unsigned int v1:15; int v2; unsigned int v3:1; };
struct BFu15i_I_BFu1ll { unsigned int v1:15; int v2; unsigned long long v3:1; };
struct BFu15i_I_BFu1s { unsigned int v1:15; int v2; unsigned short v3:1; };
struct BFu15i_I_BFu31i { unsigned int v1:15; int v2; unsigned int v3:31; };
struct BFu15i_I_BFu31ll { unsigned int v1:15; int v2; unsigned long long v3:31; };
struct BFu15i_I_BFu32i { unsigned int v1:15; int v2; unsigned int v3:32; };
struct BFu15i_I_BFu32ll { unsigned int v1:15; int v2; unsigned long long v3:32; };
struct BFu15i_I_BFu33 { unsigned int v1:15; int v2; unsigned long long v3:33; };
struct BFu15i_I_BFu7c { unsigned int v1:15; int v2; unsigned char v3:7; };
struct BFu15i_I_BFu7i { unsigned int v1:15; int v2; unsigned int v3:7; };
struct BFu15i_I_BFu7ll { unsigned int v1:15; int v2; unsigned long long v3:7; };
struct BFu15i_I_BFu7s { unsigned int v1:15; int v2; unsigned short v3:7; };
struct BFu15i_I_BFu8c { unsigned int v1:15; int v2; unsigned char v3:8; };
struct BFu15i_I_BFu8i { unsigned int v1:15; int v2; unsigned int v3:8; };
struct BFu15i_I_BFu8ll { unsigned int v1:15; int v2; unsigned long long v3:8; };
struct BFu15i_I_BFu8s { unsigned int v1:15; int v2; unsigned short v3:8; };
struct BFu15i_I_BFu9i { unsigned int v1:15; int v2; unsigned int v3:9; };
struct BFu15i_I_BFu9ll { unsigned int v1:15; int v2; unsigned long long v3:9; };
struct BFu15i_I_BFu9s { unsigned int v1:15; int v2; unsigned short v3:9; };
struct BFu15i_I_C { unsigned int v1:15; int v2; char v3; };
struct BFu15i_I_D { unsigned int v1:15; int v2; double v3; };
struct BFu15i_I_F { unsigned int v1:15; int v2; float v3; };
struct BFu15i_I_I { unsigned int v1:15; int v2; int v3; };
struct BFu15i_I_Ip { unsigned int v1:15; int v2; int * v3; };
struct BFu15i_I_L { unsigned int v1:15; int v2; long long v3; };
struct BFu15i_I_S { unsigned int v1:15; int v2; short v3; };
struct BFu15i_I_Uc { unsigned int v1:15; int v2; unsigned char v3; };
struct BFu15i_I_Ui { unsigned int v1:15; int v2; unsigned int v3; };
struct BFu15i_I_Ul { unsigned int v1:15; int v2; unsigned long long v3; };
struct BFu15i_I_Us { unsigned int v1:15; int v2; unsigned short v3; };
struct BFu15i_I_Vp { unsigned int v1:15; int v2; void * v3; };
struct BFu15i_Ip { unsigned int v1:15; int * v2; };
struct BFu15i_Ip_BFu15i { unsigned int v1:15; int * v2; unsigned int v3:15; };
struct BFu15i_Ip_BFu15ll { unsigned int v1:15; int * v2; unsigned long long v3:15; };
struct BFu15i_Ip_BFu15s { unsigned int v1:15; int * v2; unsigned short v3:15; };
struct BFu15i_Ip_BFu16i { unsigned int v1:15; int * v2; unsigned int v3:16; };
struct BFu15i_Ip_BFu16ll { unsigned int v1:15; int * v2; unsigned long long v3:16; };
struct BFu15i_Ip_BFu16s { unsigned int v1:15; int * v2; unsigned short v3:16; };
struct BFu15i_Ip_BFu17i { unsigned int v1:15; int * v2; unsigned int v3:17; };
struct BFu15i_Ip_BFu17ll { unsigned int v1:15; int * v2; unsigned long long v3:17; };
struct BFu15i_Ip_BFu1c { unsigned int v1:15; int * v2; unsigned char v3:1; };
struct BFu15i_Ip_BFu1i { unsigned int v1:15; int * v2; unsigned int v3:1; };
struct BFu15i_Ip_BFu1ll { unsigned int v1:15; int * v2; unsigned long long v3:1; };
struct BFu15i_Ip_BFu1s { unsigned int v1:15; int * v2; unsigned short v3:1; };
struct BFu15i_Ip_BFu31i { unsigned int v1:15; int * v2; unsigned int v3:31; };
struct BFu15i_Ip_BFu31ll { unsigned int v1:15; int * v2; unsigned long long v3:31; };
struct BFu15i_Ip_BFu32i { unsigned int v1:15; int * v2; unsigned int v3:32; };
struct BFu15i_Ip_BFu32ll { unsigned int v1:15; int * v2; unsigned long long v3:32; };
struct BFu15i_Ip_BFu33 { unsigned int v1:15; int * v2; unsigned long long v3:33; };
struct BFu15i_Ip_BFu7c { unsigned int v1:15; int * v2; unsigned char v3:7; };
struct BFu15i_Ip_BFu7i { unsigned int v1:15; int * v2; unsigned int v3:7; };
struct BFu15i_Ip_BFu7ll { unsigned int v1:15; int * v2; unsigned long long v3:7; };
struct BFu15i_Ip_BFu7s { unsigned int v1:15; int * v2; unsigned short v3:7; };
struct BFu15i_Ip_BFu8c { unsigned int v1:15; int * v2; unsigned char v3:8; };
struct BFu15i_Ip_BFu8i { unsigned int v1:15; int * v2; unsigned int v3:8; };
struct BFu15i_Ip_BFu8ll { unsigned int v1:15; int * v2; unsigned long long v3:8; };
struct BFu15i_Ip_BFu8s { unsigned int v1:15; int * v2; unsigned short v3:8; };
struct BFu15i_Ip_BFu9i { unsigned int v1:15; int * v2; unsigned int v3:9; };
struct BFu15i_Ip_BFu9ll { unsigned int v1:15; int * v2; unsigned long long v3:9; };
struct BFu15i_Ip_BFu9s { unsigned int v1:15; int * v2; unsigned short v3:9; };
struct BFu15i_Ip_C { unsigned int v1:15; int * v2; char v3; };
struct BFu15i_Ip_D { unsigned int v1:15; int * v2; double v3; };
struct BFu15i_Ip_F { unsigned int v1:15; int * v2; float v3; };
struct BFu15i_Ip_I { unsigned int v1:15; int * v2; int v3; };
struct BFu15i_Ip_Ip { unsigned int v1:15; int * v2; int * v3; };
struct BFu15i_Ip_L { unsigned int v1:15; int * v2; long long v3; };
struct BFu15i_Ip_S { unsigned int v1:15; int * v2; short v3; };
struct BFu15i_Ip_Uc { unsigned int v1:15; int * v2; unsigned char v3; };
struct BFu15i_Ip_Ui { unsigned int v1:15; int * v2; unsigned int v3; };
struct BFu15i_Ip_Ul { unsigned int v1:15; int * v2; unsigned long long v3; };
struct BFu15i_Ip_Us { unsigned int v1:15; int * v2; unsigned short v3; };
struct BFu15i_Ip_Vp { unsigned int v1:15; int * v2; void * v3; };
struct BFu15i_L { unsigned int v1:15; long long v2; };
struct BFu15i_L_BFu15i { unsigned int v1:15; long long v2; unsigned int v3:15; };
struct BFu15i_L_BFu15ll { unsigned int v1:15; long long v2; unsigned long long v3:15; };
struct BFu15i_L_BFu15s { unsigned int v1:15; long long v2; unsigned short v3:15; };
struct BFu15i_L_BFu16i { unsigned int v1:15; long long v2; unsigned int v3:16; };
struct BFu15i_L_BFu16ll { unsigned int v1:15; long long v2; unsigned long long v3:16; };
struct BFu15i_L_BFu16s { unsigned int v1:15; long long v2; unsigned short v3:16; };
struct BFu15i_L_BFu17i { unsigned int v1:15; long long v2; unsigned int v3:17; };
struct BFu15i_L_BFu17ll { unsigned int v1:15; long long v2; unsigned long long v3:17; };
struct BFu15i_L_BFu1c { unsigned int v1:15; long long v2; unsigned char v3:1; };
struct BFu15i_L_BFu1i { unsigned int v1:15; long long v2; unsigned int v3:1; };
struct BFu15i_L_BFu1ll { unsigned int v1:15; long long v2; unsigned long long v3:1; };
struct BFu15i_L_BFu1s { unsigned int v1:15; long long v2; unsigned short v3:1; };
struct BFu15i_L_BFu31i { unsigned int v1:15; long long v2; unsigned int v3:31; };
struct BFu15i_L_BFu31ll { unsigned int v1:15; long long v2; unsigned long long v3:31; };
struct BFu15i_L_BFu32i { unsigned int v1:15; long long v2; unsigned int v3:32; };
struct BFu15i_L_BFu32ll { unsigned int v1:15; long long v2; unsigned long long v3:32; };
struct BFu15i_L_BFu33 { unsigned int v1:15; long long v2; unsigned long long v3:33; };
struct BFu15i_L_BFu7c { unsigned int v1:15; long long v2; unsigned char v3:7; };
struct BFu15i_L_BFu7i { unsigned int v1:15; long long v2; unsigned int v3:7; };
struct BFu15i_L_BFu7ll { unsigned int v1:15; long long v2; unsigned long long v3:7; };
struct BFu15i_L_BFu7s { unsigned int v1:15; long long v2; unsigned short v3:7; };
struct BFu15i_L_BFu8c { unsigned int v1:15; long long v2; unsigned char v3:8; };
struct BFu15i_L_BFu8i { unsigned int v1:15; long long v2; unsigned int v3:8; };
struct BFu15i_L_BFu8ll { unsigned int v1:15; long long v2; unsigned long long v3:8; };
struct BFu15i_L_BFu8s { unsigned int v1:15; long long v2; unsigned short v3:8; };
struct BFu15i_L_BFu9i { unsigned int v1:15; long long v2; unsigned int v3:9; };
struct BFu15i_L_BFu9ll { unsigned int v1:15; long long v2; unsigned long long v3:9; };
struct BFu15i_L_BFu9s { unsigned int v1:15; long long v2; unsigned short v3:9; };
struct BFu15i_L_C { unsigned int v1:15; long long v2; char v3; };
struct BFu15i_L_D { unsigned int v1:15; long long v2; double v3; };
struct BFu15i_L_F { unsigned int v1:15; long long v2; float v3; };
struct BFu15i_L_I { unsigned int v1:15; long long v2; int v3; };
struct BFu15i_L_Ip { unsigned int v1:15; long long v2; int * v3; };
struct BFu15i_L_L { unsigned int v1:15; long long v2; long long v3; };
struct BFu15i_L_S { unsigned int v1:15; long long v2; short v3; };
struct BFu15i_L_Uc { unsigned int v1:15; long long v2; unsigned char v3; };
struct BFu15i_L_Ui { unsigned int v1:15; long long v2; unsigned int v3; };
struct BFu15i_L_Ul { unsigned int v1:15; long long v2; unsigned long long v3; };
struct BFu15i_L_Us { unsigned int v1:15; long long v2; unsigned short v3; };
struct BFu15i_L_Vp { unsigned int v1:15; long long v2; void * v3; };
struct BFu15i_S { unsigned int v1:15; short v2; };
struct BFu15i_S_BFu15i { unsigned int v1:15; short v2; unsigned int v3:15; };
struct BFu15i_S_BFu15ll { unsigned int v1:15; short v2; unsigned long long v3:15; };
struct BFu15i_S_BFu15s { unsigned int v1:15; short v2; unsigned short v3:15; };
struct BFu15i_S_BFu16i { unsigned int v1:15; short v2; unsigned int v3:16; };
struct BFu15i_S_BFu16ll { unsigned int v1:15; short v2; unsigned long long v3:16; };
struct BFu15i_S_BFu16s { unsigned int v1:15; short v2; unsigned short v3:16; };
struct BFu15i_S_BFu17i { unsigned int v1:15; short v2; unsigned int v3:17; };
struct BFu15i_S_BFu17ll { unsigned int v1:15; short v2; unsigned long long v3:17; };
struct BFu15i_S_BFu1c { unsigned int v1:15; short v2; unsigned char v3:1; };
struct BFu15i_S_BFu1i { unsigned int v1:15; short v2; unsigned int v3:1; };
struct BFu15i_S_BFu1ll { unsigned int v1:15; short v2; unsigned long long v3:1; };
struct BFu15i_S_BFu1s { unsigned int v1:15; short v2; unsigned short v3:1; };
struct BFu15i_S_BFu31i { unsigned int v1:15; short v2; unsigned int v3:31; };
struct BFu15i_S_BFu31ll { unsigned int v1:15; short v2; unsigned long long v3:31; };
struct BFu15i_S_BFu32i { unsigned int v1:15; short v2; unsigned int v3:32; };
struct BFu15i_S_BFu32ll { unsigned int v1:15; short v2; unsigned long long v3:32; };
struct BFu15i_S_BFu33 { unsigned int v1:15; short v2; unsigned long long v3:33; };
struct BFu15i_S_BFu7c { unsigned int v1:15; short v2; unsigned char v3:7; };
struct BFu15i_S_BFu7i { unsigned int v1:15; short v2; unsigned int v3:7; };
struct BFu15i_S_BFu7ll { unsigned int v1:15; short v2; unsigned long long v3:7; };
struct BFu15i_S_BFu7s { unsigned int v1:15; short v2; unsigned short v3:7; };
struct BFu15i_S_BFu8c { unsigned int v1:15; short v2; unsigned char v3:8; };
struct BFu15i_S_BFu8i { unsigned int v1:15; short v2; unsigned int v3:8; };
struct BFu15i_S_BFu8ll { unsigned int v1:15; short v2; unsigned long long v3:8; };
struct BFu15i_S_BFu8s { unsigned int v1:15; short v2; unsigned short v3:8; };
struct BFu15i_S_BFu9i { unsigned int v1:15; short v2; unsigned int v3:9; };
struct BFu15i_S_BFu9ll { unsigned int v1:15; short v2; unsigned long long v3:9; };
struct BFu15i_S_BFu9s { unsigned int v1:15; short v2; unsigned short v3:9; };
struct BFu15i_S_C { unsigned int v1:15; short v2; char v3; };
struct BFu15i_S_D { unsigned int v1:15; short v2; double v3; };
struct BFu15i_S_F { unsigned int v1:15; short v2; float v3; };
struct BFu15i_S_I { unsigned int v1:15; short v2; int v3; };
struct BFu15i_S_Ip { unsigned int v1:15; short v2; int * v3; };
struct BFu15i_S_L { unsigned int v1:15; short v2; long long v3; };
struct BFu15i_S_S { unsigned int v1:15; short v2; short v3; };
struct BFu15i_S_Uc { unsigned int v1:15; short v2; unsigned char v3; };
struct BFu15i_S_Ui { unsigned int v1:15; short v2; unsigned int v3; };
struct BFu15i_S_Ul { unsigned int v1:15; short v2; unsigned long long v3; };
struct BFu15i_S_Us { unsigned int v1:15; short v2; unsigned short v3; };
struct BFu15i_S_Vp { unsigned int v1:15; short v2; void * v3; };
struct BFu15i_Uc { unsigned int v1:15; unsigned char v2; };
struct BFu15i_Uc_BFu15i { unsigned int v1:15; unsigned char v2; unsigned int v3:15; };
struct BFu15i_Uc_BFu15ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:15; };
struct BFu15i_Uc_BFu15s { unsigned int v1:15; unsigned char v2; unsigned short v3:15; };
struct BFu15i_Uc_BFu16i { unsigned int v1:15; unsigned char v2; unsigned int v3:16; };
struct BFu15i_Uc_BFu16ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:16; };
struct BFu15i_Uc_BFu16s { unsigned int v1:15; unsigned char v2; unsigned short v3:16; };
struct BFu15i_Uc_BFu17i { unsigned int v1:15; unsigned char v2; unsigned int v3:17; };
struct BFu15i_Uc_BFu17ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:17; };
struct BFu15i_Uc_BFu1c { unsigned int v1:15; unsigned char v2; unsigned char v3:1; };
struct BFu15i_Uc_BFu1i { unsigned int v1:15; unsigned char v2; unsigned int v3:1; };
struct BFu15i_Uc_BFu1ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:1; };
struct BFu15i_Uc_BFu1s { unsigned int v1:15; unsigned char v2; unsigned short v3:1; };
struct BFu15i_Uc_BFu31i { unsigned int v1:15; unsigned char v2; unsigned int v3:31; };
struct BFu15i_Uc_BFu31ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:31; };
struct BFu15i_Uc_BFu32i { unsigned int v1:15; unsigned char v2; unsigned int v3:32; };
struct BFu15i_Uc_BFu32ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:32; };
struct BFu15i_Uc_BFu33 { unsigned int v1:15; unsigned char v2; unsigned long long v3:33; };
struct BFu15i_Uc_BFu7c { unsigned int v1:15; unsigned char v2; unsigned char v3:7; };
struct BFu15i_Uc_BFu7i { unsigned int v1:15; unsigned char v2; unsigned int v3:7; };
struct BFu15i_Uc_BFu7ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:7; };
struct BFu15i_Uc_BFu7s { unsigned int v1:15; unsigned char v2; unsigned short v3:7; };
struct BFu15i_Uc_BFu8c { unsigned int v1:15; unsigned char v2; unsigned char v3:8; };
struct BFu15i_Uc_BFu8i { unsigned int v1:15; unsigned char v2; unsigned int v3:8; };
struct BFu15i_Uc_BFu8ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:8; };
struct BFu15i_Uc_BFu8s { unsigned int v1:15; unsigned char v2; unsigned short v3:8; };
struct BFu15i_Uc_BFu9i { unsigned int v1:15; unsigned char v2; unsigned int v3:9; };
struct BFu15i_Uc_BFu9ll { unsigned int v1:15; unsigned char v2; unsigned long long v3:9; };
struct BFu15i_Uc_BFu9s { unsigned int v1:15; unsigned char v2; unsigned short v3:9; };
struct BFu15i_Uc_C { unsigned int v1:15; unsigned char v2; char v3; };
struct BFu15i_Uc_D { unsigned int v1:15; unsigned char v2; double v3; };
struct BFu15i_Uc_F { unsigned int v1:15; unsigned char v2; float v3; };
struct BFu15i_Uc_I { unsigned int v1:15; unsigned char v2; int v3; };
struct BFu15i_Uc_Ip { unsigned int v1:15; unsigned char v2; int * v3; };
struct BFu15i_Uc_L { unsigned int v1:15; unsigned char v2; long long v3; };
struct BFu15i_Uc_S { unsigned int v1:15; unsigned char v2; short v3; };
struct BFu15i_Uc_Uc { unsigned int v1:15; unsigned char v2; unsigned char v3; };
struct BFu15i_Uc_Ui { unsigned int v1:15; unsigned char v2; unsigned int v3; };
struct BFu15i_Uc_Ul { unsigned int v1:15; unsigned char v2; unsigned long long v3; };
struct BFu15i_Uc_Us { unsigned int v1:15; unsigned char v2; unsigned short v3; };
struct BFu15i_Uc_Vp { unsigned int v1:15; unsigned char v2; void * v3; };
struct BFu15i_Ui { unsigned int v1:15; unsigned int v2; };
struct BFu15i_Ui_BFu15i { unsigned int v1:15; unsigned int v2; unsigned int v3:15; };
struct BFu15i_Ui_BFu15ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:15; };
struct BFu15i_Ui_BFu15s { unsigned int v1:15; unsigned int v2; unsigned short v3:15; };
struct BFu15i_Ui_BFu16i { unsigned int v1:15; unsigned int v2; unsigned int v3:16; };
struct BFu15i_Ui_BFu16ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:16; };
struct BFu15i_Ui_BFu16s { unsigned int v1:15; unsigned int v2; unsigned short v3:16; };
struct BFu15i_Ui_BFu17i { unsigned int v1:15; unsigned int v2; unsigned int v3:17; };
struct BFu15i_Ui_BFu17ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:17; };
struct BFu15i_Ui_BFu1c { unsigned int v1:15; unsigned int v2; unsigned char v3:1; };
struct BFu15i_Ui_BFu1i { unsigned int v1:15; unsigned int v2; unsigned int v3:1; };
struct BFu15i_Ui_BFu1ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:1; };
struct BFu15i_Ui_BFu1s { unsigned int v1:15; unsigned int v2; unsigned short v3:1; };
struct BFu15i_Ui_BFu31i { unsigned int v1:15; unsigned int v2; unsigned int v3:31; };
struct BFu15i_Ui_BFu31ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:31; };
struct BFu15i_Ui_BFu32i { unsigned int v1:15; unsigned int v2; unsigned int v3:32; };
struct BFu15i_Ui_BFu32ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:32; };
struct BFu15i_Ui_BFu33 { unsigned int v1:15; unsigned int v2; unsigned long long v3:33; };
struct BFu15i_Ui_BFu7c { unsigned int v1:15; unsigned int v2; unsigned char v3:7; };
struct BFu15i_Ui_BFu7i { unsigned int v1:15; unsigned int v2; unsigned int v3:7; };
struct BFu15i_Ui_BFu7ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:7; };
struct BFu15i_Ui_BFu7s { unsigned int v1:15; unsigned int v2; unsigned short v3:7; };
struct BFu15i_Ui_BFu8c { unsigned int v1:15; unsigned int v2; unsigned char v3:8; };
struct BFu15i_Ui_BFu8i { unsigned int v1:15; unsigned int v2; unsigned int v3:8; };
struct BFu15i_Ui_BFu8ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:8; };
struct BFu15i_Ui_BFu8s { unsigned int v1:15; unsigned int v2; unsigned short v3:8; };
struct BFu15i_Ui_BFu9i { unsigned int v1:15; unsigned int v2; unsigned int v3:9; };
struct BFu15i_Ui_BFu9ll { unsigned int v1:15; unsigned int v2; unsigned long long v3:9; };
struct BFu15i_Ui_BFu9s { unsigned int v1:15; unsigned int v2; unsigned short v3:9; };
struct BFu15i_Ui_C { unsigned int v1:15; unsigned int v2; char v3; };
struct BFu15i_Ui_D { unsigned int v1:15; unsigned int v2; double v3; };
struct BFu15i_Ui_F { unsigned int v1:15; unsigned int v2; float v3; };
struct BFu15i_Ui_I { unsigned int v1:15; unsigned int v2; int v3; };
struct BFu15i_Ui_Ip { unsigned int v1:15; unsigned int v2; int * v3; };
struct BFu15i_Ui_L { unsigned int v1:15; unsigned int v2; long long v3; };
struct BFu15i_Ui_S { unsigned int v1:15; unsigned int v2; short v3; };
struct BFu15i_Ui_Uc { unsigned int v1:15; unsigned int v2; unsigned char v3; };
struct BFu15i_Ui_Ui { unsigned int v1:15; unsigned int v2; unsigned int v3; };
struct BFu15i_Ui_Ul { unsigned int v1:15; unsigned int v2; unsigned long long v3; };
struct BFu15i_Ui_Us { unsigned int v1:15; unsigned int v2; unsigned short v3; };
struct BFu15i_Ui_Vp { unsigned int v1:15; unsigned int v2; void * v3; };
struct BFu15i_Ul { unsigned int v1:15; unsigned long long v2; };
struct BFu15i_Ul_BFu15i { unsigned int v1:15; unsigned long long v2; unsigned int v3:15; };
struct BFu15i_Ul_BFu15ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:15; };
struct BFu15i_Ul_BFu15s { unsigned int v1:15; unsigned long long v2; unsigned short v3:15; };
struct BFu15i_Ul_BFu16i { unsigned int v1:15; unsigned long long v2; unsigned int v3:16; };
struct BFu15i_Ul_BFu16ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:16; };
struct BFu15i_Ul_BFu16s { unsigned int v1:15; unsigned long long v2; unsigned short v3:16; };
struct BFu15i_Ul_BFu17i { unsigned int v1:15; unsigned long long v2; unsigned int v3:17; };
struct BFu15i_Ul_BFu17ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:17; };
struct BFu15i_Ul_BFu1c { unsigned int v1:15; unsigned long long v2; unsigned char v3:1; };
struct BFu15i_Ul_BFu1i { unsigned int v1:15; unsigned long long v2; unsigned int v3:1; };
struct BFu15i_Ul_BFu1ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:1; };
struct BFu15i_Ul_BFu1s { unsigned int v1:15; unsigned long long v2; unsigned short v3:1; };
struct BFu15i_Ul_BFu31i { unsigned int v1:15; unsigned long long v2; unsigned int v3:31; };
struct BFu15i_Ul_BFu31ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:31; };
struct BFu15i_Ul_BFu32i { unsigned int v1:15; unsigned long long v2; unsigned int v3:32; };
struct BFu15i_Ul_BFu32ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:32; };
struct BFu15i_Ul_BFu33 { unsigned int v1:15; unsigned long long v2; unsigned long long v3:33; };
struct BFu15i_Ul_BFu7c { unsigned int v1:15; unsigned long long v2; unsigned char v3:7; };
struct BFu15i_Ul_BFu7i { unsigned int v1:15; unsigned long long v2; unsigned int v3:7; };
struct BFu15i_Ul_BFu7ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:7; };
struct BFu15i_Ul_BFu7s { unsigned int v1:15; unsigned long long v2; unsigned short v3:7; };
struct BFu15i_Ul_BFu8c { unsigned int v1:15; unsigned long long v2; unsigned char v3:8; };
struct BFu15i_Ul_BFu8i { unsigned int v1:15; unsigned long long v2; unsigned int v3:8; };
struct BFu15i_Ul_BFu8ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:8; };
struct BFu15i_Ul_BFu8s { unsigned int v1:15; unsigned long long v2; unsigned short v3:8; };
struct BFu15i_Ul_BFu9i { unsigned int v1:15; unsigned long long v2; unsigned int v3:9; };
struct BFu15i_Ul_BFu9ll { unsigned int v1:15; unsigned long long v2; unsigned long long v3:9; };
struct BFu15i_Ul_BFu9s { unsigned int v1:15; unsigned long long v2; unsigned short v3:9; };
struct BFu15i_Ul_C { unsigned int v1:15; unsigned long long v2; char v3; };
struct BFu15i_Ul_D { unsigned int v1:15; unsigned long long v2; double v3; };
struct BFu15i_Ul_F { unsigned int v1:15; unsigned long long v2; float v3; };
struct BFu15i_Ul_I { unsigned int v1:15; unsigned long long v2; int v3; };
struct BFu15i_Ul_Ip { unsigned int v1:15; unsigned long long v2; int * v3; };
struct BFu15i_Ul_L { unsigned int v1:15; unsigned long long v2; long long v3; };
struct BFu15i_Ul_S { unsigned int v1:15; unsigned long long v2; short v3; };
struct BFu15i_Ul_Uc { unsigned int v1:15; unsigned long long v2; unsigned char v3; };
struct BFu15i_Ul_Ui { unsigned int v1:15; unsigned long long v2; unsigned int v3; };
struct BFu15i_Ul_Ul { unsigned int v1:15; unsigned long long v2; unsigned long long v3; };
struct BFu15i_Ul_Us { unsigned int v1:15; unsigned long long v2; unsigned short v3; };
struct BFu15i_Ul_Vp { unsigned int v1:15; unsigned long long v2; void * v3; };
struct BFu15i_Us { unsigned int v1:15; unsigned short v2; };
struct BFu15i_Us_BFu15i { unsigned int v1:15; unsigned short v2; unsigned int v3:15; };
struct BFu15i_Us_BFu15ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:15; };
struct BFu15i_Us_BFu15s { unsigned int v1:15; unsigned short v2; unsigned short v3:15; };
struct BFu15i_Us_BFu16i { unsigned int v1:15; unsigned short v2; unsigned int v3:16; };
struct BFu15i_Us_BFu16ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:16; };
struct BFu15i_Us_BFu16s { unsigned int v1:15; unsigned short v2; unsigned short v3:16; };
struct BFu15i_Us_BFu17i { unsigned int v1:15; unsigned short v2; unsigned int v3:17; };
struct BFu15i_Us_BFu17ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:17; };
struct BFu15i_Us_BFu1c { unsigned int v1:15; unsigned short v2; unsigned char v3:1; };
struct BFu15i_Us_BFu1i { unsigned int v1:15; unsigned short v2; unsigned int v3:1; };
struct BFu15i_Us_BFu1ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:1; };
struct BFu15i_Us_BFu1s { unsigned int v1:15; unsigned short v2; unsigned short v3:1; };
struct BFu15i_Us_BFu31i { unsigned int v1:15; unsigned short v2; unsigned int v3:31; };
struct BFu15i_Us_BFu31ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:31; };
struct BFu15i_Us_BFu32i { unsigned int v1:15; unsigned short v2; unsigned int v3:32; };
struct BFu15i_Us_BFu32ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:32; };
struct BFu15i_Us_BFu33 { unsigned int v1:15; unsigned short v2; unsigned long long v3:33; };
struct BFu15i_Us_BFu7c { unsigned int v1:15; unsigned short v2; unsigned char v3:7; };
struct BFu15i_Us_BFu7i { unsigned int v1:15; unsigned short v2; unsigned int v3:7; };
struct BFu15i_Us_BFu7ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:7; };
struct BFu15i_Us_BFu7s { unsigned int v1:15; unsigned short v2; unsigned short v3:7; };
struct BFu15i_Us_BFu8c { unsigned int v1:15; unsigned short v2; unsigned char v3:8; };
struct BFu15i_Us_BFu8i { unsigned int v1:15; unsigned short v2; unsigned int v3:8; };
struct BFu15i_Us_BFu8ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:8; };
struct BFu15i_Us_BFu8s { unsigned int v1:15; unsigned short v2; unsigned short v3:8; };
struct BFu15i_Us_BFu9i { unsigned int v1:15; unsigned short v2; unsigned int v3:9; };
struct BFu15i_Us_BFu9ll { unsigned int v1:15; unsigned short v2; unsigned long long v3:9; };
struct BFu15i_Us_BFu9s { unsigned int v1:15; unsigned short v2; unsigned short v3:9; };
struct BFu15i_Us_C { unsigned int v1:15; unsigned short v2; char v3; };
struct BFu15i_Us_D { unsigned int v1:15; unsigned short v2; double v3; };
struct BFu15i_Us_F { unsigned int v1:15; unsigned short v2; float v3; };
struct BFu15i_Us_I { unsigned int v1:15; unsigned short v2; int v3; };
struct BFu15i_Us_Ip { unsigned int v1:15; unsigned short v2; int * v3; };
struct BFu15i_Us_L { unsigned int v1:15; unsigned short v2; long long v3; };
struct BFu15i_Us_S { unsigned int v1:15; unsigned short v2; short v3; };
struct BFu15i_Us_Uc { unsigned int v1:15; unsigned short v2; unsigned char v3; };
struct BFu15i_Us_Ui { unsigned int v1:15; unsigned short v2; unsigned int v3; };
struct BFu15i_Us_Ul { unsigned int v1:15; unsigned short v2; unsigned long long v3; };
struct BFu15i_Us_Us { unsigned int v1:15; unsigned short v2; unsigned short v3; };
struct BFu15i_Us_Vp { unsigned int v1:15; unsigned short v2; void * v3; };
struct BFu15i_Vp { unsigned int v1:15; void * v2; };
struct BFu15i_Vp_BFu15i { unsigned int v1:15; void * v2; unsigned int v3:15; };
struct BFu15i_Vp_BFu15ll { unsigned int v1:15; void * v2; unsigned long long v3:15; };
struct BFu15i_Vp_BFu15s { unsigned int v1:15; void * v2; unsigned short v3:15; };
struct BFu15i_Vp_BFu16i { unsigned int v1:15; void * v2; unsigned int v3:16; };
struct BFu15i_Vp_BFu16ll { unsigned int v1:15; void * v2; unsigned long long v3:16; };
struct BFu15i_Vp_BFu16s { unsigned int v1:15; void * v2; unsigned short v3:16; };
struct BFu15i_Vp_BFu17i { unsigned int v1:15; void * v2; unsigned int v3:17; };
struct BFu15i_Vp_BFu17ll { unsigned int v1:15; void * v2; unsigned long long v3:17; };
struct BFu15i_Vp_BFu1c { unsigned int v1:15; void * v2; unsigned char v3:1; };
struct BFu15i_Vp_BFu1i { unsigned int v1:15; void * v2; unsigned int v3:1; };
struct BFu15i_Vp_BFu1ll { unsigned int v1:15; void * v2; unsigned long long v3:1; };
struct BFu15i_Vp_BFu1s { unsigned int v1:15; void * v2; unsigned short v3:1; };
struct BFu15i_Vp_BFu31i { unsigned int v1:15; void * v2; unsigned int v3:31; };
struct BFu15i_Vp_BFu31ll { unsigned int v1:15; void * v2; unsigned long long v3:31; };
struct BFu15i_Vp_BFu32i { unsigned int v1:15; void * v2; unsigned int v3:32; };
struct BFu15i_Vp_BFu32ll { unsigned int v1:15; void * v2; unsigned long long v3:32; };
struct BFu15i_Vp_BFu33 { unsigned int v1:15; void * v2; unsigned long long v3:33; };
struct BFu15i_Vp_BFu7c { unsigned int v1:15; void * v2; unsigned char v3:7; };
struct BFu15i_Vp_BFu7i { unsigned int v1:15; void * v2; unsigned int v3:7; };
struct BFu15i_Vp_BFu7ll { unsigned int v1:15; void * v2; unsigned long long v3:7; };
struct BFu15i_Vp_BFu7s { unsigned int v1:15; void * v2; unsigned short v3:7; };
struct BFu15i_Vp_BFu8c { unsigned int v1:15; void * v2; unsigned char v3:8; };
struct BFu15i_Vp_BFu8i { unsigned int v1:15; void * v2; unsigned int v3:8; };
struct BFu15i_Vp_BFu8ll { unsigned int v1:15; void * v2; unsigned long long v3:8; };
struct BFu15i_Vp_BFu8s { unsigned int v1:15; void * v2; unsigned short v3:8; };
struct BFu15i_Vp_BFu9i { unsigned int v1:15; void * v2; unsigned int v3:9; };
struct BFu15i_Vp_BFu9ll { unsigned int v1:15; void * v2; unsigned long long v3:9; };
struct BFu15i_Vp_BFu9s { unsigned int v1:15; void * v2; unsigned short v3:9; };
struct BFu15i_Vp_C { unsigned int v1:15; void * v2; char v3; };
struct BFu15i_Vp_D { unsigned int v1:15; void * v2; double v3; };
struct BFu15i_Vp_F { unsigned int v1:15; void * v2; float v3; };
struct BFu15i_Vp_I { unsigned int v1:15; void * v2; int v3; };
struct BFu15i_Vp_Ip { unsigned int v1:15; void * v2; int * v3; };
struct BFu15i_Vp_L { unsigned int v1:15; void * v2; long long v3; };
struct BFu15i_Vp_S { unsigned int v1:15; void * v2; short v3; };
struct BFu15i_Vp_Uc { unsigned int v1:15; void * v2; unsigned char v3; };
struct BFu15i_Vp_Ui { unsigned int v1:15; void * v2; unsigned int v3; };
struct BFu15i_Vp_Ul { unsigned int v1:15; void * v2; unsigned long long v3; };
struct BFu15i_Vp_Us { unsigned int v1:15; void * v2; unsigned short v3; };
struct BFu15i_Vp_Vp { unsigned int v1:15; void * v2; void * v3; };
struct BFu15ll { unsigned long long v1:15; };
struct BFu15ll_BFs15i { unsigned long long v1:15; signed int v2:15; };
struct BFu15ll_BFs15i_BFs15i { unsigned long long v1:15; signed int v2:15; signed int v3:15; };
struct BFu15ll_BFs15i_BFs15i_BFs15i { unsigned long long v1:15; signed int v2:15; signed int v3:15; signed int v4:15; };
struct BFu15ll_BFs15i_BFs15i_BFs15ll { unsigned long long v1:15; signed int v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15ll_BFs15i_BFs15i_BFs15s { unsigned long long v1:15; signed int v2:15; signed int v3:15; signed short v4:15; };
struct BFu15ll_BFs15i_BFs15i_BFu15i { unsigned long long v1:15; signed int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15i_BFs15i_BFu15ll { unsigned long long v1:15; signed int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15i_BFs15i_BFu15s { unsigned long long v1:15; signed int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15i_BFs15ll { unsigned long long v1:15; signed int v2:15; signed long long v3:15; };
struct BFu15ll_BFs15i_BFs15ll_BFs15i { unsigned long long v1:15; signed int v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15ll_BFs15i_BFs15ll_BFs15ll { unsigned long long v1:15; signed int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15ll_BFs15i_BFs15ll_BFs15s { unsigned long long v1:15; signed int v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15ll_BFs15i_BFs15ll_BFu15i { unsigned long long v1:15; signed int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15i_BFs15ll_BFu15ll { unsigned long long v1:15; signed int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15i_BFs15ll_BFu15s { unsigned long long v1:15; signed int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15i_BFs15s { unsigned long long v1:15; signed int v2:15; signed short v3:15; };
struct BFu15ll_BFs15i_BFs15s_BFs15i { unsigned long long v1:15; signed int v2:15; signed short v3:15; signed int v4:15; };
struct BFu15ll_BFs15i_BFs15s_BFs15ll { unsigned long long v1:15; signed int v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15ll_BFs15i_BFs15s_BFs15s { unsigned long long v1:15; signed int v2:15; signed short v3:15; signed short v4:15; };
struct BFu15ll_BFs15i_BFs15s_BFu15i { unsigned long long v1:15; signed int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15i_BFs15s_BFu15ll { unsigned long long v1:15; signed int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15i_BFs15s_BFu15s { unsigned long long v1:15; signed int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15i_BFu15i { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; };
struct BFu15ll_BFs15i_BFu15i_BFs15i { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15ll_BFs15i_BFu15i_BFs15ll { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15ll_BFs15i_BFu15i_BFs15s { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15ll_BFs15i_BFu15i_BFu15i { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15i_BFu15i_BFu15ll { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15i_BFu15i_BFu15s { unsigned long long v1:15; signed int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15i_BFu15ll { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; };
struct BFu15ll_BFs15i_BFu15ll_BFs15i { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15ll_BFs15i_BFu15ll_BFs15ll { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15ll_BFs15i_BFu15ll_BFs15s { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15ll_BFs15i_BFu15ll_BFu15i { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15i_BFu15ll_BFu15ll { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15i_BFu15ll_BFu15s { unsigned long long v1:15; signed int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15i_BFu15s { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; };
struct BFu15ll_BFs15i_BFu15s_BFs15i { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15ll_BFs15i_BFu15s_BFs15ll { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15ll_BFs15i_BFu15s_BFs15s { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15ll_BFs15i_BFu15s_BFu15i { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15i_BFu15s_BFu15ll { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15i_BFu15s_BFu15s { unsigned long long v1:15; signed int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15ll { unsigned long long v1:15; signed long long v2:15; };
struct BFu15ll_BFs15ll_BFs15i { unsigned long long v1:15; signed long long v2:15; signed int v3:15; };
struct BFu15ll_BFs15ll_BFs15i_BFs15i { unsigned long long v1:15; signed long long v2:15; signed int v3:15; signed int v4:15; };
struct BFu15ll_BFs15ll_BFs15i_BFs15ll { unsigned long long v1:15; signed long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15ll_BFs15ll_BFs15i_BFs15s { unsigned long long v1:15; signed long long v2:15; signed int v3:15; signed short v4:15; };
struct BFu15ll_BFs15ll_BFs15i_BFu15i { unsigned long long v1:15; signed long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15ll_BFs15i_BFu15ll { unsigned long long v1:15; signed long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15ll_BFs15i_BFu15s { unsigned long long v1:15; signed long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15ll_BFs15ll { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; };
struct BFu15ll_BFs15ll_BFs15ll_BFs15i { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15ll_BFs15ll_BFs15ll_BFs15ll { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15ll_BFs15ll_BFs15ll_BFs15s { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15ll_BFs15ll_BFs15ll_BFu15i { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15ll_BFs15ll_BFu15ll { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15ll_BFs15ll_BFu15s { unsigned long long v1:15; signed long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15ll_BFs15s { unsigned long long v1:15; signed long long v2:15; signed short v3:15; };
struct BFu15ll_BFs15ll_BFs15s_BFs15i { unsigned long long v1:15; signed long long v2:15; signed short v3:15; signed int v4:15; };
struct BFu15ll_BFs15ll_BFs15s_BFs15ll { unsigned long long v1:15; signed long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15ll_BFs15ll_BFs15s_BFs15s { unsigned long long v1:15; signed long long v2:15; signed short v3:15; signed short v4:15; };
struct BFu15ll_BFs15ll_BFs15s_BFu15i { unsigned long long v1:15; signed long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15ll_BFs15s_BFu15ll { unsigned long long v1:15; signed long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15ll_BFs15s_BFu15s { unsigned long long v1:15; signed long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15ll_BFu15i { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; };
struct BFu15ll_BFs15ll_BFu15i_BFs15i { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15ll_BFs15ll_BFu15i_BFs15ll { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15ll_BFs15ll_BFu15i_BFs15s { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15ll_BFs15ll_BFu15i_BFu15i { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15ll_BFu15i_BFu15ll { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15ll_BFu15i_BFu15s { unsigned long long v1:15; signed long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15ll_BFu15ll { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; };
struct BFu15ll_BFs15ll_BFu15ll_BFs15i { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15ll_BFs15ll_BFu15ll_BFs15ll { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15ll_BFs15ll_BFu15ll_BFs15s { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15ll_BFs15ll_BFu15ll_BFu15i { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15ll_BFu15ll_BFu15ll { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15ll_BFu15ll_BFu15s { unsigned long long v1:15; signed long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15ll_BFu15s { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; };
struct BFu15ll_BFs15ll_BFu15s_BFs15i { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15ll_BFs15ll_BFu15s_BFs15ll { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15ll_BFs15ll_BFu15s_BFs15s { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15ll_BFs15ll_BFu15s_BFu15i { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15ll_BFu15s_BFu15ll { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15ll_BFu15s_BFu15s { unsigned long long v1:15; signed long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15s { unsigned long long v1:15; signed short v2:15; };
struct BFu15ll_BFs15s_BFs15i { unsigned long long v1:15; signed short v2:15; signed int v3:15; };
struct BFu15ll_BFs15s_BFs15i_BFs15i { unsigned long long v1:15; signed short v2:15; signed int v3:15; signed int v4:15; };
struct BFu15ll_BFs15s_BFs15i_BFs15ll { unsigned long long v1:15; signed short v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15ll_BFs15s_BFs15i_BFs15s { unsigned long long v1:15; signed short v2:15; signed int v3:15; signed short v4:15; };
struct BFu15ll_BFs15s_BFs15i_BFu15i { unsigned long long v1:15; signed short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15s_BFs15i_BFu15ll { unsigned long long v1:15; signed short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15s_BFs15i_BFu15s { unsigned long long v1:15; signed short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15s_BFs15ll { unsigned long long v1:15; signed short v2:15; signed long long v3:15; };
struct BFu15ll_BFs15s_BFs15ll_BFs15i { unsigned long long v1:15; signed short v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15ll_BFs15s_BFs15ll_BFs15ll { unsigned long long v1:15; signed short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15ll_BFs15s_BFs15ll_BFs15s { unsigned long long v1:15; signed short v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15ll_BFs15s_BFs15ll_BFu15i { unsigned long long v1:15; signed short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15s_BFs15ll_BFu15ll { unsigned long long v1:15; signed short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15s_BFs15ll_BFu15s { unsigned long long v1:15; signed short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15s_BFs15s { unsigned long long v1:15; signed short v2:15; signed short v3:15; };
struct BFu15ll_BFs15s_BFs15s_BFs15i { unsigned long long v1:15; signed short v2:15; signed short v3:15; signed int v4:15; };
struct BFu15ll_BFs15s_BFs15s_BFs15ll { unsigned long long v1:15; signed short v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15ll_BFs15s_BFs15s_BFs15s { unsigned long long v1:15; signed short v2:15; signed short v3:15; signed short v4:15; };
struct BFu15ll_BFs15s_BFs15s_BFu15i { unsigned long long v1:15; signed short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15s_BFs15s_BFu15ll { unsigned long long v1:15; signed short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15s_BFs15s_BFu15s { unsigned long long v1:15; signed short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15s_BFu15i { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; };
struct BFu15ll_BFs15s_BFu15i_BFs15i { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15ll_BFs15s_BFu15i_BFs15ll { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15ll_BFs15s_BFu15i_BFs15s { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15ll_BFs15s_BFu15i_BFu15i { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15s_BFu15i_BFu15ll { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15s_BFu15i_BFu15s { unsigned long long v1:15; signed short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15s_BFu15ll { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; };
struct BFu15ll_BFs15s_BFu15ll_BFs15i { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15ll_BFs15s_BFu15ll_BFs15ll { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15ll_BFs15s_BFu15ll_BFs15s { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15ll_BFs15s_BFu15ll_BFu15i { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15s_BFu15ll_BFu15ll { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15s_BFu15ll_BFu15s { unsigned long long v1:15; signed short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFs15s_BFu15s { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; };
struct BFu15ll_BFs15s_BFu15s_BFs15i { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15ll_BFs15s_BFu15s_BFs15ll { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15ll_BFs15s_BFu15s_BFs15s { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15ll_BFs15s_BFu15s_BFu15i { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15ll_BFs15s_BFu15s_BFu15ll { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFs15s_BFu15s_BFu15s { unsigned long long v1:15; signed short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i { unsigned long long v1:15; unsigned int v2:15; };
struct BFu15ll_BFu15i_BFs15i { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; };
struct BFu15ll_BFu15i_BFs15i_BFs15i { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; signed int v4:15; };
struct BFu15ll_BFu15i_BFs15i_BFs15ll { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15ll_BFu15i_BFs15i_BFs15s { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; signed short v4:15; };
struct BFu15ll_BFu15i_BFs15i_BFu15i { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15i_BFs15i_BFu15ll { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15i_BFs15i_BFu15s { unsigned long long v1:15; unsigned int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i_BFs15ll { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; };
struct BFu15ll_BFu15i_BFs15ll_BFs15i { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15ll_BFu15i_BFs15ll_BFs15ll { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15ll_BFu15i_BFs15ll_BFs15s { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15ll_BFu15i_BFs15ll_BFu15i { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15i_BFs15ll_BFu15ll { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15i_BFs15ll_BFu15s { unsigned long long v1:15; unsigned int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i_BFs15s { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; };
struct BFu15ll_BFu15i_BFs15s_BFs15i { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; signed int v4:15; };
struct BFu15ll_BFu15i_BFs15s_BFs15ll { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15ll_BFu15i_BFs15s_BFs15s { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; signed short v4:15; };
struct BFu15ll_BFu15i_BFs15s_BFu15i { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15i_BFs15s_BFu15ll { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15i_BFs15s_BFu15s { unsigned long long v1:15; unsigned int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i_BFu15i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; };
struct BFu15ll_BFu15i_BFu15i_BFs15i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15ll_BFu15i_BFu15i_BFs15ll { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15ll_BFu15i_BFu15i_BFs15s { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15ll_BFu15i_BFu15i_BFu15i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15i_BFu15i_BFu15ll { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15i_BFu15i_BFu15s { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i_BFu15ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; };
struct BFu15ll_BFu15i_BFu15ll_BFs15i { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15ll_BFu15i_BFu15ll_BFs15ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15ll_BFu15i_BFu15ll_BFs15s { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15ll_BFu15i_BFu15ll_BFu15i { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15i_BFu15ll_BFu15ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15i_BFu15ll_BFu15s { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i_BFu15s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; };
struct BFu15ll_BFu15i_BFu15s_BFs15i { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15ll_BFu15i_BFu15s_BFs15ll { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15ll_BFu15i_BFu15s_BFs15s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15ll_BFu15i_BFu15s_BFu15i { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15i_BFu15s_BFu15ll { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15i_BFu15s_BFu15s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15i_BFu16i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:16; };
struct BFu15ll_BFu15i_BFu16ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:16; };
struct BFu15ll_BFu15i_BFu16s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:16; };
struct BFu15ll_BFu15i_BFu17i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:17; };
struct BFu15ll_BFu15i_BFu17ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:17; };
struct BFu15ll_BFu15i_BFu1c { unsigned long long v1:15; unsigned int v2:15; unsigned char v3:1; };
struct BFu15ll_BFu15i_BFu1i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:1; };
struct BFu15ll_BFu15i_BFu1ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:1; };
struct BFu15ll_BFu15i_BFu1s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:1; };
struct BFu15ll_BFu15i_BFu31i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:31; };
struct BFu15ll_BFu15i_BFu31ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:31; };
struct BFu15ll_BFu15i_BFu32i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:32; };
struct BFu15ll_BFu15i_BFu32ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:32; };
struct BFu15ll_BFu15i_BFu33 { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:33; };
struct BFu15ll_BFu15i_BFu7c { unsigned long long v1:15; unsigned int v2:15; unsigned char v3:7; };
struct BFu15ll_BFu15i_BFu7i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:7; };
struct BFu15ll_BFu15i_BFu7ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:7; };
struct BFu15ll_BFu15i_BFu7s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:7; };
struct BFu15ll_BFu15i_BFu8c { unsigned long long v1:15; unsigned int v2:15; unsigned char v3:8; };
struct BFu15ll_BFu15i_BFu8i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:8; };
struct BFu15ll_BFu15i_BFu8ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:8; };
struct BFu15ll_BFu15i_BFu8s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:8; };
struct BFu15ll_BFu15i_BFu9i { unsigned long long v1:15; unsigned int v2:15; unsigned int v3:9; };
struct BFu15ll_BFu15i_BFu9ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3:9; };
struct BFu15ll_BFu15i_BFu9s { unsigned long long v1:15; unsigned int v2:15; unsigned short v3:9; };
struct BFu15ll_BFu15i_C { unsigned long long v1:15; unsigned int v2:15; char v3; };
struct BFu15ll_BFu15i_D { unsigned long long v1:15; unsigned int v2:15; double v3; };
struct BFu15ll_BFu15i_F { unsigned long long v1:15; unsigned int v2:15; float v3; };
struct BFu15ll_BFu15i_I { unsigned long long v1:15; unsigned int v2:15; int v3; };
struct BFu15ll_BFu15i_Ip { unsigned long long v1:15; unsigned int v2:15; int * v3; };
struct BFu15ll_BFu15i_L { unsigned long long v1:15; unsigned int v2:15; long long v3; };
struct BFu15ll_BFu15i_S { unsigned long long v1:15; unsigned int v2:15; short v3; };
struct BFu15ll_BFu15i_Uc { unsigned long long v1:15; unsigned int v2:15; unsigned char v3; };
struct BFu15ll_BFu15i_Ui { unsigned long long v1:15; unsigned int v2:15; unsigned int v3; };
struct BFu15ll_BFu15i_Ul { unsigned long long v1:15; unsigned int v2:15; unsigned long long v3; };
struct BFu15ll_BFu15i_Us { unsigned long long v1:15; unsigned int v2:15; unsigned short v3; };
struct BFu15ll_BFu15i_Vp { unsigned long long v1:15; unsigned int v2:15; void * v3; };
struct BFu15ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; };
struct BFu15ll_BFu15ll_BFs15i { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; };
struct BFu15ll_BFu15ll_BFs15i_BFs15i { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; signed int v4:15; };
struct BFu15ll_BFu15ll_BFs15i_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15ll_BFu15ll_BFs15i_BFs15s { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; signed short v4:15; };
struct BFu15ll_BFu15ll_BFs15i_BFu15i { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15ll_BFs15i_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15ll_BFs15i_BFu15s { unsigned long long v1:15; unsigned long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15ll_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; };
struct BFu15ll_BFu15ll_BFs15ll_BFs15i { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15ll_BFu15ll_BFs15ll_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15ll_BFu15ll_BFs15ll_BFs15s { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15ll_BFu15ll_BFs15ll_BFu15i { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15ll_BFs15ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15ll_BFs15ll_BFu15s { unsigned long long v1:15; unsigned long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15ll_BFs15s { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; };
struct BFu15ll_BFu15ll_BFs15s_BFs15i { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; signed int v4:15; };
struct BFu15ll_BFu15ll_BFs15s_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15ll_BFu15ll_BFs15s_BFs15s { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; signed short v4:15; };
struct BFu15ll_BFu15ll_BFs15s_BFu15i { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15ll_BFs15s_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15ll_BFs15s_BFu15s { unsigned long long v1:15; unsigned long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15ll_BFu15i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; };
struct BFu15ll_BFu15ll_BFu15i_BFs15i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15ll_BFu15ll_BFu15i_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15ll_BFu15ll_BFu15i_BFs15s { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15ll_BFu15ll_BFu15i_BFu15i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15ll_BFu15i_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15ll_BFu15i_BFu15s { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; };
struct BFu15ll_BFu15ll_BFu15ll_BFs15i { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15ll_BFu15ll_BFu15ll_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15ll_BFu15ll_BFu15ll_BFs15s { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15ll_BFu15ll_BFu15ll_BFu15i { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15ll_BFu15ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15ll_BFu15ll_BFu15s { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15ll_BFu15s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; };
struct BFu15ll_BFu15ll_BFu15s_BFs15i { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15ll_BFu15ll_BFu15s_BFs15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15ll_BFu15ll_BFu15s_BFs15s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15ll_BFu15ll_BFu15s_BFu15i { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15ll_BFu15s_BFu15ll { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15ll_BFu15s_BFu15s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15ll_BFu16i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:16; };
struct BFu15ll_BFu15ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:16; };
struct BFu15ll_BFu15ll_BFu16s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:16; };
struct BFu15ll_BFu15ll_BFu17i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:17; };
struct BFu15ll_BFu15ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:17; };
struct BFu15ll_BFu15ll_BFu1c { unsigned long long v1:15; unsigned long long v2:15; unsigned char v3:1; };
struct BFu15ll_BFu15ll_BFu1i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:1; };
struct BFu15ll_BFu15ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:1; };
struct BFu15ll_BFu15ll_BFu1s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:1; };
struct BFu15ll_BFu15ll_BFu31i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:31; };
struct BFu15ll_BFu15ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:31; };
struct BFu15ll_BFu15ll_BFu32i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:32; };
struct BFu15ll_BFu15ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:32; };
struct BFu15ll_BFu15ll_BFu33 { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:33; };
struct BFu15ll_BFu15ll_BFu7c { unsigned long long v1:15; unsigned long long v2:15; unsigned char v3:7; };
struct BFu15ll_BFu15ll_BFu7i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:7; };
struct BFu15ll_BFu15ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:7; };
struct BFu15ll_BFu15ll_BFu7s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:7; };
struct BFu15ll_BFu15ll_BFu8c { unsigned long long v1:15; unsigned long long v2:15; unsigned char v3:8; };
struct BFu15ll_BFu15ll_BFu8i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:8; };
struct BFu15ll_BFu15ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:8; };
struct BFu15ll_BFu15ll_BFu8s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:8; };
struct BFu15ll_BFu15ll_BFu9i { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3:9; };
struct BFu15ll_BFu15ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3:9; };
struct BFu15ll_BFu15ll_BFu9s { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3:9; };
struct BFu15ll_BFu15ll_C { unsigned long long v1:15; unsigned long long v2:15; char v3; };
struct BFu15ll_BFu15ll_D { unsigned long long v1:15; unsigned long long v2:15; double v3; };
struct BFu15ll_BFu15ll_F { unsigned long long v1:15; unsigned long long v2:15; float v3; };
struct BFu15ll_BFu15ll_I { unsigned long long v1:15; unsigned long long v2:15; int v3; };
struct BFu15ll_BFu15ll_Ip { unsigned long long v1:15; unsigned long long v2:15; int * v3; };
struct BFu15ll_BFu15ll_L { unsigned long long v1:15; unsigned long long v2:15; long long v3; };
struct BFu15ll_BFu15ll_S { unsigned long long v1:15; unsigned long long v2:15; short v3; };
struct BFu15ll_BFu15ll_Uc { unsigned long long v1:15; unsigned long long v2:15; unsigned char v3; };
struct BFu15ll_BFu15ll_Ui { unsigned long long v1:15; unsigned long long v2:15; unsigned int v3; };
struct BFu15ll_BFu15ll_Ul { unsigned long long v1:15; unsigned long long v2:15; unsigned long long v3; };
struct BFu15ll_BFu15ll_Us { unsigned long long v1:15; unsigned long long v2:15; unsigned short v3; };
struct BFu15ll_BFu15ll_Vp { unsigned long long v1:15; unsigned long long v2:15; void * v3; };
struct BFu15ll_BFu15s { unsigned long long v1:15; unsigned short v2:15; };
struct BFu15ll_BFu15s_BFs15i { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; };
struct BFu15ll_BFu15s_BFs15i_BFs15i { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; signed int v4:15; };
struct BFu15ll_BFu15s_BFs15i_BFs15ll { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15ll_BFu15s_BFs15i_BFs15s { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; signed short v4:15; };
struct BFu15ll_BFu15s_BFs15i_BFu15i { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15s_BFs15i_BFu15ll { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15s_BFs15i_BFu15s { unsigned long long v1:15; unsigned short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15s_BFs15ll { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; };
struct BFu15ll_BFu15s_BFs15ll_BFs15i { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15ll_BFu15s_BFs15ll_BFs15ll { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15ll_BFu15s_BFs15ll_BFs15s { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15ll_BFu15s_BFs15ll_BFu15i { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15s_BFs15ll_BFu15ll { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15s_BFs15ll_BFu15s { unsigned long long v1:15; unsigned short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15s_BFs15s { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; };
struct BFu15ll_BFu15s_BFs15s_BFs15i { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; signed int v4:15; };
struct BFu15ll_BFu15s_BFs15s_BFs15ll { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15ll_BFu15s_BFs15s_BFs15s { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; signed short v4:15; };
struct BFu15ll_BFu15s_BFs15s_BFu15i { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15s_BFs15s_BFu15ll { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15s_BFs15s_BFu15s { unsigned long long v1:15; unsigned short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15s_BFu15i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; };
struct BFu15ll_BFu15s_BFu15i_BFs15i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15ll_BFu15s_BFu15i_BFs15ll { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15ll_BFu15s_BFu15i_BFs15s { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15ll_BFu15s_BFu15i_BFu15i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15s_BFu15i_BFu15ll { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15s_BFu15i_BFu15s { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15s_BFu15ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; };
struct BFu15ll_BFu15s_BFu15ll_BFs15i { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15ll_BFu15s_BFu15ll_BFs15ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15ll_BFu15s_BFu15ll_BFs15s { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15ll_BFu15s_BFu15ll_BFu15i { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15s_BFu15ll_BFu15ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15s_BFu15ll_BFu15s { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15s_BFu15s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; };
struct BFu15ll_BFu15s_BFu15s_BFs15i { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15ll_BFu15s_BFu15s_BFs15ll { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15ll_BFu15s_BFu15s_BFs15s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15ll_BFu15s_BFu15s_BFu15i { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15ll_BFu15s_BFu15s_BFu15ll { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15ll_BFu15s_BFu15s_BFu15s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15ll_BFu15s_BFu16i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:16; };
struct BFu15ll_BFu15s_BFu16ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:16; };
struct BFu15ll_BFu15s_BFu16s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:16; };
struct BFu15ll_BFu15s_BFu17i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:17; };
struct BFu15ll_BFu15s_BFu17ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:17; };
struct BFu15ll_BFu15s_BFu1c { unsigned long long v1:15; unsigned short v2:15; unsigned char v3:1; };
struct BFu15ll_BFu15s_BFu1i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:1; };
struct BFu15ll_BFu15s_BFu1ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:1; };
struct BFu15ll_BFu15s_BFu1s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:1; };
struct BFu15ll_BFu15s_BFu31i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:31; };
struct BFu15ll_BFu15s_BFu31ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:31; };
struct BFu15ll_BFu15s_BFu32i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:32; };
struct BFu15ll_BFu15s_BFu32ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:32; };
struct BFu15ll_BFu15s_BFu33 { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:33; };
struct BFu15ll_BFu15s_BFu7c { unsigned long long v1:15; unsigned short v2:15; unsigned char v3:7; };
struct BFu15ll_BFu15s_BFu7i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:7; };
struct BFu15ll_BFu15s_BFu7ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:7; };
struct BFu15ll_BFu15s_BFu7s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:7; };
struct BFu15ll_BFu15s_BFu8c { unsigned long long v1:15; unsigned short v2:15; unsigned char v3:8; };
struct BFu15ll_BFu15s_BFu8i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:8; };
struct BFu15ll_BFu15s_BFu8ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:8; };
struct BFu15ll_BFu15s_BFu8s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:8; };
struct BFu15ll_BFu15s_BFu9i { unsigned long long v1:15; unsigned short v2:15; unsigned int v3:9; };
struct BFu15ll_BFu15s_BFu9ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3:9; };
struct BFu15ll_BFu15s_BFu9s { unsigned long long v1:15; unsigned short v2:15; unsigned short v3:9; };
struct BFu15ll_BFu15s_C { unsigned long long v1:15; unsigned short v2:15; char v3; };
struct BFu15ll_BFu15s_D { unsigned long long v1:15; unsigned short v2:15; double v3; };
struct BFu15ll_BFu15s_F { unsigned long long v1:15; unsigned short v2:15; float v3; };
struct BFu15ll_BFu15s_I { unsigned long long v1:15; unsigned short v2:15; int v3; };
struct BFu15ll_BFu15s_Ip { unsigned long long v1:15; unsigned short v2:15; int * v3; };
struct BFu15ll_BFu15s_L { unsigned long long v1:15; unsigned short v2:15; long long v3; };
struct BFu15ll_BFu15s_S { unsigned long long v1:15; unsigned short v2:15; short v3; };
struct BFu15ll_BFu15s_Uc { unsigned long long v1:15; unsigned short v2:15; unsigned char v3; };
struct BFu15ll_BFu15s_Ui { unsigned long long v1:15; unsigned short v2:15; unsigned int v3; };
struct BFu15ll_BFu15s_Ul { unsigned long long v1:15; unsigned short v2:15; unsigned long long v3; };
struct BFu15ll_BFu15s_Us { unsigned long long v1:15; unsigned short v2:15; unsigned short v3; };
struct BFu15ll_BFu15s_Vp { unsigned long long v1:15; unsigned short v2:15; void * v3; };
struct BFu15ll_BFu16i { unsigned long long v1:15; unsigned int v2:16; };
struct BFu15ll_BFu16i_BFu15i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:15; };
struct BFu15ll_BFu16i_BFu15ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:15; };
struct BFu15ll_BFu16i_BFu15s { unsigned long long v1:15; unsigned int v2:16; unsigned short v3:15; };
struct BFu15ll_BFu16i_BFu16i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:16; };
struct BFu15ll_BFu16i_BFu16ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:16; };
struct BFu15ll_BFu16i_BFu16s { unsigned long long v1:15; unsigned int v2:16; unsigned short v3:16; };
struct BFu15ll_BFu16i_BFu17i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:17; };
struct BFu15ll_BFu16i_BFu17ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:17; };
struct BFu15ll_BFu16i_BFu1c { unsigned long long v1:15; unsigned int v2:16; unsigned char v3:1; };
struct BFu15ll_BFu16i_BFu1i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:1; };
struct BFu15ll_BFu16i_BFu1ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:1; };
struct BFu15ll_BFu16i_BFu1s { unsigned long long v1:15; unsigned int v2:16; unsigned short v3:1; };
struct BFu15ll_BFu16i_BFu31i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:31; };
struct BFu15ll_BFu16i_BFu31ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:31; };
struct BFu15ll_BFu16i_BFu32i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:32; };
struct BFu15ll_BFu16i_BFu32ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:32; };
struct BFu15ll_BFu16i_BFu33 { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:33; };
struct BFu15ll_BFu16i_BFu7c { unsigned long long v1:15; unsigned int v2:16; unsigned char v3:7; };
struct BFu15ll_BFu16i_BFu7i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:7; };
struct BFu15ll_BFu16i_BFu7ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:7; };
struct BFu15ll_BFu16i_BFu7s { unsigned long long v1:15; unsigned int v2:16; unsigned short v3:7; };
struct BFu15ll_BFu16i_BFu8c { unsigned long long v1:15; unsigned int v2:16; unsigned char v3:8; };
struct BFu15ll_BFu16i_BFu8i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:8; };
struct BFu15ll_BFu16i_BFu8ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:8; };
struct BFu15ll_BFu16i_BFu8s { unsigned long long v1:15; unsigned int v2:16; unsigned short v3:8; };
struct BFu15ll_BFu16i_BFu9i { unsigned long long v1:15; unsigned int v2:16; unsigned int v3:9; };
struct BFu15ll_BFu16i_BFu9ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3:9; };
struct BFu15ll_BFu16i_BFu9s { unsigned long long v1:15; unsigned int v2:16; unsigned short v3:9; };
struct BFu15ll_BFu16i_C { unsigned long long v1:15; unsigned int v2:16; char v3; };
struct BFu15ll_BFu16i_D { unsigned long long v1:15; unsigned int v2:16; double v3; };
struct BFu15ll_BFu16i_F { unsigned long long v1:15; unsigned int v2:16; float v3; };
struct BFu15ll_BFu16i_I { unsigned long long v1:15; unsigned int v2:16; int v3; };
struct BFu15ll_BFu16i_Ip { unsigned long long v1:15; unsigned int v2:16; int * v3; };
struct BFu15ll_BFu16i_L { unsigned long long v1:15; unsigned int v2:16; long long v3; };
struct BFu15ll_BFu16i_S { unsigned long long v1:15; unsigned int v2:16; short v3; };
struct BFu15ll_BFu16i_Uc { unsigned long long v1:15; unsigned int v2:16; unsigned char v3; };
struct BFu15ll_BFu16i_Ui { unsigned long long v1:15; unsigned int v2:16; unsigned int v3; };
struct BFu15ll_BFu16i_Ul { unsigned long long v1:15; unsigned int v2:16; unsigned long long v3; };
struct BFu15ll_BFu16i_Us { unsigned long long v1:15; unsigned int v2:16; unsigned short v3; };
struct BFu15ll_BFu16i_Vp { unsigned long long v1:15; unsigned int v2:16; void * v3; };
struct BFu15ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:16; };
struct BFu15ll_BFu16ll_BFu15i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:15; };
struct BFu15ll_BFu16ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:15; };
struct BFu15ll_BFu16ll_BFu15s { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3:15; };
struct BFu15ll_BFu16ll_BFu16i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:16; };
struct BFu15ll_BFu16ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:16; };
struct BFu15ll_BFu16ll_BFu16s { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3:16; };
struct BFu15ll_BFu16ll_BFu17i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:17; };
struct BFu15ll_BFu16ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:17; };
struct BFu15ll_BFu16ll_BFu1c { unsigned long long v1:15; unsigned long long v2:16; unsigned char v3:1; };
struct BFu15ll_BFu16ll_BFu1i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:1; };
struct BFu15ll_BFu16ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:1; };
struct BFu15ll_BFu16ll_BFu1s { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3:1; };
struct BFu15ll_BFu16ll_BFu31i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:31; };
struct BFu15ll_BFu16ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:31; };
struct BFu15ll_BFu16ll_BFu32i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:32; };
struct BFu15ll_BFu16ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:32; };
struct BFu15ll_BFu16ll_BFu33 { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:33; };
struct BFu15ll_BFu16ll_BFu7c { unsigned long long v1:15; unsigned long long v2:16; unsigned char v3:7; };
struct BFu15ll_BFu16ll_BFu7i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:7; };
struct BFu15ll_BFu16ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:7; };
struct BFu15ll_BFu16ll_BFu7s { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3:7; };
struct BFu15ll_BFu16ll_BFu8c { unsigned long long v1:15; unsigned long long v2:16; unsigned char v3:8; };
struct BFu15ll_BFu16ll_BFu8i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:8; };
struct BFu15ll_BFu16ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:8; };
struct BFu15ll_BFu16ll_BFu8s { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3:8; };
struct BFu15ll_BFu16ll_BFu9i { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3:9; };
struct BFu15ll_BFu16ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3:9; };
struct BFu15ll_BFu16ll_BFu9s { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3:9; };
struct BFu15ll_BFu16ll_C { unsigned long long v1:15; unsigned long long v2:16; char v3; };
struct BFu15ll_BFu16ll_D { unsigned long long v1:15; unsigned long long v2:16; double v3; };
struct BFu15ll_BFu16ll_F { unsigned long long v1:15; unsigned long long v2:16; float v3; };
struct BFu15ll_BFu16ll_I { unsigned long long v1:15; unsigned long long v2:16; int v3; };
struct BFu15ll_BFu16ll_Ip { unsigned long long v1:15; unsigned long long v2:16; int * v3; };
struct BFu15ll_BFu16ll_L { unsigned long long v1:15; unsigned long long v2:16; long long v3; };
struct BFu15ll_BFu16ll_S { unsigned long long v1:15; unsigned long long v2:16; short v3; };
struct BFu15ll_BFu16ll_Uc { unsigned long long v1:15; unsigned long long v2:16; unsigned char v3; };
struct BFu15ll_BFu16ll_Ui { unsigned long long v1:15; unsigned long long v2:16; unsigned int v3; };
struct BFu15ll_BFu16ll_Ul { unsigned long long v1:15; unsigned long long v2:16; unsigned long long v3; };
struct BFu15ll_BFu16ll_Us { unsigned long long v1:15; unsigned long long v2:16; unsigned short v3; };
struct BFu15ll_BFu16ll_Vp { unsigned long long v1:15; unsigned long long v2:16; void * v3; };
struct BFu15ll_BFu16s { unsigned long long v1:15; unsigned short v2:16; };
struct BFu15ll_BFu16s_BFu15i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:15; };
struct BFu15ll_BFu16s_BFu15ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:15; };
struct BFu15ll_BFu16s_BFu15s { unsigned long long v1:15; unsigned short v2:16; unsigned short v3:15; };
struct BFu15ll_BFu16s_BFu16i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:16; };
struct BFu15ll_BFu16s_BFu16ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:16; };
struct BFu15ll_BFu16s_BFu16s { unsigned long long v1:15; unsigned short v2:16; unsigned short v3:16; };
struct BFu15ll_BFu16s_BFu17i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:17; };
struct BFu15ll_BFu16s_BFu17ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:17; };
struct BFu15ll_BFu16s_BFu1c { unsigned long long v1:15; unsigned short v2:16; unsigned char v3:1; };
struct BFu15ll_BFu16s_BFu1i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:1; };
struct BFu15ll_BFu16s_BFu1ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:1; };
struct BFu15ll_BFu16s_BFu1s { unsigned long long v1:15; unsigned short v2:16; unsigned short v3:1; };
struct BFu15ll_BFu16s_BFu31i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:31; };
struct BFu15ll_BFu16s_BFu31ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:31; };
struct BFu15ll_BFu16s_BFu32i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:32; };
struct BFu15ll_BFu16s_BFu32ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:32; };
struct BFu15ll_BFu16s_BFu33 { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:33; };
struct BFu15ll_BFu16s_BFu7c { unsigned long long v1:15; unsigned short v2:16; unsigned char v3:7; };
struct BFu15ll_BFu16s_BFu7i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:7; };
struct BFu15ll_BFu16s_BFu7ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:7; };
struct BFu15ll_BFu16s_BFu7s { unsigned long long v1:15; unsigned short v2:16; unsigned short v3:7; };
struct BFu15ll_BFu16s_BFu8c { unsigned long long v1:15; unsigned short v2:16; unsigned char v3:8; };
struct BFu15ll_BFu16s_BFu8i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:8; };
struct BFu15ll_BFu16s_BFu8ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:8; };
struct BFu15ll_BFu16s_BFu8s { unsigned long long v1:15; unsigned short v2:16; unsigned short v3:8; };
struct BFu15ll_BFu16s_BFu9i { unsigned long long v1:15; unsigned short v2:16; unsigned int v3:9; };
struct BFu15ll_BFu16s_BFu9ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3:9; };
struct BFu15ll_BFu16s_BFu9s { unsigned long long v1:15; unsigned short v2:16; unsigned short v3:9; };
struct BFu15ll_BFu16s_C { unsigned long long v1:15; unsigned short v2:16; char v3; };
struct BFu15ll_BFu16s_D { unsigned long long v1:15; unsigned short v2:16; double v3; };
struct BFu15ll_BFu16s_F { unsigned long long v1:15; unsigned short v2:16; float v3; };
struct BFu15ll_BFu16s_I { unsigned long long v1:15; unsigned short v2:16; int v3; };
struct BFu15ll_BFu16s_Ip { unsigned long long v1:15; unsigned short v2:16; int * v3; };
struct BFu15ll_BFu16s_L { unsigned long long v1:15; unsigned short v2:16; long long v3; };
struct BFu15ll_BFu16s_S { unsigned long long v1:15; unsigned short v2:16; short v3; };
struct BFu15ll_BFu16s_Uc { unsigned long long v1:15; unsigned short v2:16; unsigned char v3; };
struct BFu15ll_BFu16s_Ui { unsigned long long v1:15; unsigned short v2:16; unsigned int v3; };
struct BFu15ll_BFu16s_Ul { unsigned long long v1:15; unsigned short v2:16; unsigned long long v3; };
struct BFu15ll_BFu16s_Us { unsigned long long v1:15; unsigned short v2:16; unsigned short v3; };
struct BFu15ll_BFu16s_Vp { unsigned long long v1:15; unsigned short v2:16; void * v3; };
struct BFu15ll_BFu17i { unsigned long long v1:15; unsigned int v2:17; };
struct BFu15ll_BFu17i_BFu15i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:15; };
struct BFu15ll_BFu17i_BFu15ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:15; };
struct BFu15ll_BFu17i_BFu15s { unsigned long long v1:15; unsigned int v2:17; unsigned short v3:15; };
struct BFu15ll_BFu17i_BFu16i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:16; };
struct BFu15ll_BFu17i_BFu16ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:16; };
struct BFu15ll_BFu17i_BFu16s { unsigned long long v1:15; unsigned int v2:17; unsigned short v3:16; };
struct BFu15ll_BFu17i_BFu17i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:17; };
struct BFu15ll_BFu17i_BFu17ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:17; };
struct BFu15ll_BFu17i_BFu1c { unsigned long long v1:15; unsigned int v2:17; unsigned char v3:1; };
struct BFu15ll_BFu17i_BFu1i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:1; };
struct BFu15ll_BFu17i_BFu1ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:1; };
struct BFu15ll_BFu17i_BFu1s { unsigned long long v1:15; unsigned int v2:17; unsigned short v3:1; };
struct BFu15ll_BFu17i_BFu31i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:31; };
struct BFu15ll_BFu17i_BFu31ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:31; };
struct BFu15ll_BFu17i_BFu32i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:32; };
struct BFu15ll_BFu17i_BFu32ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:32; };
struct BFu15ll_BFu17i_BFu33 { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:33; };
struct BFu15ll_BFu17i_BFu7c { unsigned long long v1:15; unsigned int v2:17; unsigned char v3:7; };
struct BFu15ll_BFu17i_BFu7i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:7; };
struct BFu15ll_BFu17i_BFu7ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:7; };
struct BFu15ll_BFu17i_BFu7s { unsigned long long v1:15; unsigned int v2:17; unsigned short v3:7; };
struct BFu15ll_BFu17i_BFu8c { unsigned long long v1:15; unsigned int v2:17; unsigned char v3:8; };
struct BFu15ll_BFu17i_BFu8i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:8; };
struct BFu15ll_BFu17i_BFu8ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:8; };
struct BFu15ll_BFu17i_BFu8s { unsigned long long v1:15; unsigned int v2:17; unsigned short v3:8; };
struct BFu15ll_BFu17i_BFu9i { unsigned long long v1:15; unsigned int v2:17; unsigned int v3:9; };
struct BFu15ll_BFu17i_BFu9ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3:9; };
struct BFu15ll_BFu17i_BFu9s { unsigned long long v1:15; unsigned int v2:17; unsigned short v3:9; };
struct BFu15ll_BFu17i_C { unsigned long long v1:15; unsigned int v2:17; char v3; };
struct BFu15ll_BFu17i_D { unsigned long long v1:15; unsigned int v2:17; double v3; };
struct BFu15ll_BFu17i_F { unsigned long long v1:15; unsigned int v2:17; float v3; };
struct BFu15ll_BFu17i_I { unsigned long long v1:15; unsigned int v2:17; int v3; };
struct BFu15ll_BFu17i_Ip { unsigned long long v1:15; unsigned int v2:17; int * v3; };
struct BFu15ll_BFu17i_L { unsigned long long v1:15; unsigned int v2:17; long long v3; };
struct BFu15ll_BFu17i_S { unsigned long long v1:15; unsigned int v2:17; short v3; };
struct BFu15ll_BFu17i_Uc { unsigned long long v1:15; unsigned int v2:17; unsigned char v3; };
struct BFu15ll_BFu17i_Ui { unsigned long long v1:15; unsigned int v2:17; unsigned int v3; };
struct BFu15ll_BFu17i_Ul { unsigned long long v1:15; unsigned int v2:17; unsigned long long v3; };
struct BFu15ll_BFu17i_Us { unsigned long long v1:15; unsigned int v2:17; unsigned short v3; };
struct BFu15ll_BFu17i_Vp { unsigned long long v1:15; unsigned int v2:17; void * v3; };
struct BFu15ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:17; };
struct BFu15ll_BFu17ll_BFu15i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:15; };
struct BFu15ll_BFu17ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:15; };
struct BFu15ll_BFu17ll_BFu15s { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3:15; };
struct BFu15ll_BFu17ll_BFu16i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:16; };
struct BFu15ll_BFu17ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:16; };
struct BFu15ll_BFu17ll_BFu16s { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3:16; };
struct BFu15ll_BFu17ll_BFu17i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:17; };
struct BFu15ll_BFu17ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:17; };
struct BFu15ll_BFu17ll_BFu1c { unsigned long long v1:15; unsigned long long v2:17; unsigned char v3:1; };
struct BFu15ll_BFu17ll_BFu1i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:1; };
struct BFu15ll_BFu17ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:1; };
struct BFu15ll_BFu17ll_BFu1s { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3:1; };
struct BFu15ll_BFu17ll_BFu31i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:31; };
struct BFu15ll_BFu17ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:31; };
struct BFu15ll_BFu17ll_BFu32i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:32; };
struct BFu15ll_BFu17ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:32; };
struct BFu15ll_BFu17ll_BFu33 { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:33; };
struct BFu15ll_BFu17ll_BFu7c { unsigned long long v1:15; unsigned long long v2:17; unsigned char v3:7; };
struct BFu15ll_BFu17ll_BFu7i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:7; };
struct BFu15ll_BFu17ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:7; };
struct BFu15ll_BFu17ll_BFu7s { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3:7; };
struct BFu15ll_BFu17ll_BFu8c { unsigned long long v1:15; unsigned long long v2:17; unsigned char v3:8; };
struct BFu15ll_BFu17ll_BFu8i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:8; };
struct BFu15ll_BFu17ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:8; };
struct BFu15ll_BFu17ll_BFu8s { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3:8; };
struct BFu15ll_BFu17ll_BFu9i { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3:9; };
struct BFu15ll_BFu17ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3:9; };
struct BFu15ll_BFu17ll_BFu9s { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3:9; };
struct BFu15ll_BFu17ll_C { unsigned long long v1:15; unsigned long long v2:17; char v3; };
struct BFu15ll_BFu17ll_D { unsigned long long v1:15; unsigned long long v2:17; double v3; };
struct BFu15ll_BFu17ll_F { unsigned long long v1:15; unsigned long long v2:17; float v3; };
struct BFu15ll_BFu17ll_I { unsigned long long v1:15; unsigned long long v2:17; int v3; };
struct BFu15ll_BFu17ll_Ip { unsigned long long v1:15; unsigned long long v2:17; int * v3; };
struct BFu15ll_BFu17ll_L { unsigned long long v1:15; unsigned long long v2:17; long long v3; };
struct BFu15ll_BFu17ll_S { unsigned long long v1:15; unsigned long long v2:17; short v3; };
struct BFu15ll_BFu17ll_Uc { unsigned long long v1:15; unsigned long long v2:17; unsigned char v3; };
struct BFu15ll_BFu17ll_Ui { unsigned long long v1:15; unsigned long long v2:17; unsigned int v3; };
struct BFu15ll_BFu17ll_Ul { unsigned long long v1:15; unsigned long long v2:17; unsigned long long v3; };
struct BFu15ll_BFu17ll_Us { unsigned long long v1:15; unsigned long long v2:17; unsigned short v3; };
struct BFu15ll_BFu17ll_Vp { unsigned long long v1:15; unsigned long long v2:17; void * v3; };
struct BFu15ll_BFu1c { unsigned long long v1:15; unsigned char v2:1; };
struct BFu15ll_BFu1c_BFu15i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:15; };
struct BFu15ll_BFu1c_BFu15ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:15; };
struct BFu15ll_BFu1c_BFu15s { unsigned long long v1:15; unsigned char v2:1; unsigned short v3:15; };
struct BFu15ll_BFu1c_BFu16i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:16; };
struct BFu15ll_BFu1c_BFu16ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:16; };
struct BFu15ll_BFu1c_BFu16s { unsigned long long v1:15; unsigned char v2:1; unsigned short v3:16; };
struct BFu15ll_BFu1c_BFu17i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:17; };
struct BFu15ll_BFu1c_BFu17ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:17; };
struct BFu15ll_BFu1c_BFu1c { unsigned long long v1:15; unsigned char v2:1; unsigned char v3:1; };
struct BFu15ll_BFu1c_BFu1i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:1; };
struct BFu15ll_BFu1c_BFu1ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:1; };
struct BFu15ll_BFu1c_BFu1s { unsigned long long v1:15; unsigned char v2:1; unsigned short v3:1; };
struct BFu15ll_BFu1c_BFu31i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:31; };
struct BFu15ll_BFu1c_BFu31ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:31; };
struct BFu15ll_BFu1c_BFu32i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:32; };
struct BFu15ll_BFu1c_BFu32ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:32; };
struct BFu15ll_BFu1c_BFu33 { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:33; };
struct BFu15ll_BFu1c_BFu7c { unsigned long long v1:15; unsigned char v2:1; unsigned char v3:7; };
struct BFu15ll_BFu1c_BFu7i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:7; };
struct BFu15ll_BFu1c_BFu7ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:7; };
struct BFu15ll_BFu1c_BFu7s { unsigned long long v1:15; unsigned char v2:1; unsigned short v3:7; };
struct BFu15ll_BFu1c_BFu8c { unsigned long long v1:15; unsigned char v2:1; unsigned char v3:8; };
struct BFu15ll_BFu1c_BFu8i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:8; };
struct BFu15ll_BFu1c_BFu8ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:8; };
struct BFu15ll_BFu1c_BFu8s { unsigned long long v1:15; unsigned char v2:1; unsigned short v3:8; };
struct BFu15ll_BFu1c_BFu9i { unsigned long long v1:15; unsigned char v2:1; unsigned int v3:9; };
struct BFu15ll_BFu1c_BFu9ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3:9; };
struct BFu15ll_BFu1c_BFu9s { unsigned long long v1:15; unsigned char v2:1; unsigned short v3:9; };
struct BFu15ll_BFu1c_C { unsigned long long v1:15; unsigned char v2:1; char v3; };
struct BFu15ll_BFu1c_D { unsigned long long v1:15; unsigned char v2:1; double v3; };
struct BFu15ll_BFu1c_F { unsigned long long v1:15; unsigned char v2:1; float v3; };
struct BFu15ll_BFu1c_I { unsigned long long v1:15; unsigned char v2:1; int v3; };
struct BFu15ll_BFu1c_Ip { unsigned long long v1:15; unsigned char v2:1; int * v3; };
struct BFu15ll_BFu1c_L { unsigned long long v1:15; unsigned char v2:1; long long v3; };
struct BFu15ll_BFu1c_S { unsigned long long v1:15; unsigned char v2:1; short v3; };
struct BFu15ll_BFu1c_Uc { unsigned long long v1:15; unsigned char v2:1; unsigned char v3; };
struct BFu15ll_BFu1c_Ui { unsigned long long v1:15; unsigned char v2:1; unsigned int v3; };
struct BFu15ll_BFu1c_Ul { unsigned long long v1:15; unsigned char v2:1; unsigned long long v3; };
struct BFu15ll_BFu1c_Us { unsigned long long v1:15; unsigned char v2:1; unsigned short v3; };
struct BFu15ll_BFu1c_Vp { unsigned long long v1:15; unsigned char v2:1; void * v3; };
struct BFu15ll_BFu1i { unsigned long long v1:15; unsigned int v2:1; };
struct BFu15ll_BFu1i_BFu15i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:15; };
struct BFu15ll_BFu1i_BFu15ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:15; };
struct BFu15ll_BFu1i_BFu15s { unsigned long long v1:15; unsigned int v2:1; unsigned short v3:15; };
struct BFu15ll_BFu1i_BFu16i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:16; };
struct BFu15ll_BFu1i_BFu16ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:16; };
struct BFu15ll_BFu1i_BFu16s { unsigned long long v1:15; unsigned int v2:1; unsigned short v3:16; };
struct BFu15ll_BFu1i_BFu17i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:17; };
struct BFu15ll_BFu1i_BFu17ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:17; };
struct BFu15ll_BFu1i_BFu1c { unsigned long long v1:15; unsigned int v2:1; unsigned char v3:1; };
struct BFu15ll_BFu1i_BFu1i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:1; };
struct BFu15ll_BFu1i_BFu1ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:1; };
struct BFu15ll_BFu1i_BFu1s { unsigned long long v1:15; unsigned int v2:1; unsigned short v3:1; };
struct BFu15ll_BFu1i_BFu31i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:31; };
struct BFu15ll_BFu1i_BFu31ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:31; };
struct BFu15ll_BFu1i_BFu32i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:32; };
struct BFu15ll_BFu1i_BFu32ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:32; };
struct BFu15ll_BFu1i_BFu33 { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:33; };
struct BFu15ll_BFu1i_BFu7c { unsigned long long v1:15; unsigned int v2:1; unsigned char v3:7; };
struct BFu15ll_BFu1i_BFu7i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:7; };
struct BFu15ll_BFu1i_BFu7ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:7; };
struct BFu15ll_BFu1i_BFu7s { unsigned long long v1:15; unsigned int v2:1; unsigned short v3:7; };
struct BFu15ll_BFu1i_BFu8c { unsigned long long v1:15; unsigned int v2:1; unsigned char v3:8; };
struct BFu15ll_BFu1i_BFu8i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:8; };
struct BFu15ll_BFu1i_BFu8ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:8; };
struct BFu15ll_BFu1i_BFu8s { unsigned long long v1:15; unsigned int v2:1; unsigned short v3:8; };
struct BFu15ll_BFu1i_BFu9i { unsigned long long v1:15; unsigned int v2:1; unsigned int v3:9; };
struct BFu15ll_BFu1i_BFu9ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3:9; };
struct BFu15ll_BFu1i_BFu9s { unsigned long long v1:15; unsigned int v2:1; unsigned short v3:9; };
struct BFu15ll_BFu1i_C { unsigned long long v1:15; unsigned int v2:1; char v3; };
struct BFu15ll_BFu1i_D { unsigned long long v1:15; unsigned int v2:1; double v3; };
struct BFu15ll_BFu1i_F { unsigned long long v1:15; unsigned int v2:1; float v3; };
struct BFu15ll_BFu1i_I { unsigned long long v1:15; unsigned int v2:1; int v3; };
struct BFu15ll_BFu1i_Ip { unsigned long long v1:15; unsigned int v2:1; int * v3; };
struct BFu15ll_BFu1i_L { unsigned long long v1:15; unsigned int v2:1; long long v3; };
struct BFu15ll_BFu1i_S { unsigned long long v1:15; unsigned int v2:1; short v3; };
struct BFu15ll_BFu1i_Uc { unsigned long long v1:15; unsigned int v2:1; unsigned char v3; };
struct BFu15ll_BFu1i_Ui { unsigned long long v1:15; unsigned int v2:1; unsigned int v3; };
struct BFu15ll_BFu1i_Ul { unsigned long long v1:15; unsigned int v2:1; unsigned long long v3; };
struct BFu15ll_BFu1i_Us { unsigned long long v1:15; unsigned int v2:1; unsigned short v3; };
struct BFu15ll_BFu1i_Vp { unsigned long long v1:15; unsigned int v2:1; void * v3; };
struct BFu15ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:1; };
struct BFu15ll_BFu1ll_BFu15i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:15; };
struct BFu15ll_BFu1ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:15; };
struct BFu15ll_BFu1ll_BFu15s { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3:15; };
struct BFu15ll_BFu1ll_BFu16i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:16; };
struct BFu15ll_BFu1ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:16; };
struct BFu15ll_BFu1ll_BFu16s { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3:16; };
struct BFu15ll_BFu1ll_BFu17i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:17; };
struct BFu15ll_BFu1ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:17; };
struct BFu15ll_BFu1ll_BFu1c { unsigned long long v1:15; unsigned long long v2:1; unsigned char v3:1; };
struct BFu15ll_BFu1ll_BFu1i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:1; };
struct BFu15ll_BFu1ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:1; };
struct BFu15ll_BFu1ll_BFu1s { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3:1; };
struct BFu15ll_BFu1ll_BFu31i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:31; };
struct BFu15ll_BFu1ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:31; };
struct BFu15ll_BFu1ll_BFu32i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:32; };
struct BFu15ll_BFu1ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:32; };
struct BFu15ll_BFu1ll_BFu33 { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:33; };
struct BFu15ll_BFu1ll_BFu7c { unsigned long long v1:15; unsigned long long v2:1; unsigned char v3:7; };
struct BFu15ll_BFu1ll_BFu7i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:7; };
struct BFu15ll_BFu1ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:7; };
struct BFu15ll_BFu1ll_BFu7s { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3:7; };
struct BFu15ll_BFu1ll_BFu8c { unsigned long long v1:15; unsigned long long v2:1; unsigned char v3:8; };
struct BFu15ll_BFu1ll_BFu8i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:8; };
struct BFu15ll_BFu1ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:8; };
struct BFu15ll_BFu1ll_BFu8s { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3:8; };
struct BFu15ll_BFu1ll_BFu9i { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3:9; };
struct BFu15ll_BFu1ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3:9; };
struct BFu15ll_BFu1ll_BFu9s { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3:9; };
struct BFu15ll_BFu1ll_C { unsigned long long v1:15; unsigned long long v2:1; char v3; };
struct BFu15ll_BFu1ll_D { unsigned long long v1:15; unsigned long long v2:1; double v3; };
struct BFu15ll_BFu1ll_F { unsigned long long v1:15; unsigned long long v2:1; float v3; };
struct BFu15ll_BFu1ll_I { unsigned long long v1:15; unsigned long long v2:1; int v3; };
struct BFu15ll_BFu1ll_Ip { unsigned long long v1:15; unsigned long long v2:1; int * v3; };
struct BFu15ll_BFu1ll_L { unsigned long long v1:15; unsigned long long v2:1; long long v3; };
struct BFu15ll_BFu1ll_S { unsigned long long v1:15; unsigned long long v2:1; short v3; };
struct BFu15ll_BFu1ll_Uc { unsigned long long v1:15; unsigned long long v2:1; unsigned char v3; };
struct BFu15ll_BFu1ll_Ui { unsigned long long v1:15; unsigned long long v2:1; unsigned int v3; };
struct BFu15ll_BFu1ll_Ul { unsigned long long v1:15; unsigned long long v2:1; unsigned long long v3; };
struct BFu15ll_BFu1ll_Us { unsigned long long v1:15; unsigned long long v2:1; unsigned short v3; };
struct BFu15ll_BFu1ll_Vp { unsigned long long v1:15; unsigned long long v2:1; void * v3; };
struct BFu15ll_BFu1s { unsigned long long v1:15; unsigned short v2:1; };
struct BFu15ll_BFu1s_BFu15i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:15; };
struct BFu15ll_BFu1s_BFu15ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:15; };
struct BFu15ll_BFu1s_BFu15s { unsigned long long v1:15; unsigned short v2:1; unsigned short v3:15; };
struct BFu15ll_BFu1s_BFu16i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:16; };
struct BFu15ll_BFu1s_BFu16ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:16; };
struct BFu15ll_BFu1s_BFu16s { unsigned long long v1:15; unsigned short v2:1; unsigned short v3:16; };
struct BFu15ll_BFu1s_BFu17i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:17; };
struct BFu15ll_BFu1s_BFu17ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:17; };
struct BFu15ll_BFu1s_BFu1c { unsigned long long v1:15; unsigned short v2:1; unsigned char v3:1; };
struct BFu15ll_BFu1s_BFu1i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:1; };
struct BFu15ll_BFu1s_BFu1ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:1; };
struct BFu15ll_BFu1s_BFu1s { unsigned long long v1:15; unsigned short v2:1; unsigned short v3:1; };
struct BFu15ll_BFu1s_BFu31i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:31; };
struct BFu15ll_BFu1s_BFu31ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:31; };
struct BFu15ll_BFu1s_BFu32i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:32; };
struct BFu15ll_BFu1s_BFu32ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:32; };
struct BFu15ll_BFu1s_BFu33 { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:33; };
struct BFu15ll_BFu1s_BFu7c { unsigned long long v1:15; unsigned short v2:1; unsigned char v3:7; };
struct BFu15ll_BFu1s_BFu7i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:7; };
struct BFu15ll_BFu1s_BFu7ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:7; };
struct BFu15ll_BFu1s_BFu7s { unsigned long long v1:15; unsigned short v2:1; unsigned short v3:7; };
struct BFu15ll_BFu1s_BFu8c { unsigned long long v1:15; unsigned short v2:1; unsigned char v3:8; };
struct BFu15ll_BFu1s_BFu8i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:8; };
struct BFu15ll_BFu1s_BFu8ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:8; };
struct BFu15ll_BFu1s_BFu8s { unsigned long long v1:15; unsigned short v2:1; unsigned short v3:8; };
struct BFu15ll_BFu1s_BFu9i { unsigned long long v1:15; unsigned short v2:1; unsigned int v3:9; };
struct BFu15ll_BFu1s_BFu9ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3:9; };
struct BFu15ll_BFu1s_BFu9s { unsigned long long v1:15; unsigned short v2:1; unsigned short v3:9; };
struct BFu15ll_BFu1s_C { unsigned long long v1:15; unsigned short v2:1; char v3; };
struct BFu15ll_BFu1s_D { unsigned long long v1:15; unsigned short v2:1; double v3; };
struct BFu15ll_BFu1s_F { unsigned long long v1:15; unsigned short v2:1; float v3; };
struct BFu15ll_BFu1s_I { unsigned long long v1:15; unsigned short v2:1; int v3; };
struct BFu15ll_BFu1s_Ip { unsigned long long v1:15; unsigned short v2:1; int * v3; };
struct BFu15ll_BFu1s_L { unsigned long long v1:15; unsigned short v2:1; long long v3; };
struct BFu15ll_BFu1s_S { unsigned long long v1:15; unsigned short v2:1; short v3; };
struct BFu15ll_BFu1s_Uc { unsigned long long v1:15; unsigned short v2:1; unsigned char v3; };
struct BFu15ll_BFu1s_Ui { unsigned long long v1:15; unsigned short v2:1; unsigned int v3; };
struct BFu15ll_BFu1s_Ul { unsigned long long v1:15; unsigned short v2:1; unsigned long long v3; };
struct BFu15ll_BFu1s_Us { unsigned long long v1:15; unsigned short v2:1; unsigned short v3; };
struct BFu15ll_BFu1s_Vp { unsigned long long v1:15; unsigned short v2:1; void * v3; };
struct BFu15ll_BFu31i { unsigned long long v1:15; unsigned int v2:31; };
struct BFu15ll_BFu31i_BFu15i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:15; };
struct BFu15ll_BFu31i_BFu15ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:15; };
struct BFu15ll_BFu31i_BFu15s { unsigned long long v1:15; unsigned int v2:31; unsigned short v3:15; };
struct BFu15ll_BFu31i_BFu16i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:16; };
struct BFu15ll_BFu31i_BFu16ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:16; };
struct BFu15ll_BFu31i_BFu16s { unsigned long long v1:15; unsigned int v2:31; unsigned short v3:16; };
struct BFu15ll_BFu31i_BFu17i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:17; };
struct BFu15ll_BFu31i_BFu17ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:17; };
struct BFu15ll_BFu31i_BFu1c { unsigned long long v1:15; unsigned int v2:31; unsigned char v3:1; };
struct BFu15ll_BFu31i_BFu1i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:1; };
struct BFu15ll_BFu31i_BFu1ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:1; };
struct BFu15ll_BFu31i_BFu1s { unsigned long long v1:15; unsigned int v2:31; unsigned short v3:1; };
struct BFu15ll_BFu31i_BFu31i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:31; };
struct BFu15ll_BFu31i_BFu31ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:31; };
struct BFu15ll_BFu31i_BFu32i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:32; };
struct BFu15ll_BFu31i_BFu32ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:32; };
struct BFu15ll_BFu31i_BFu33 { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:33; };
struct BFu15ll_BFu31i_BFu7c { unsigned long long v1:15; unsigned int v2:31; unsigned char v3:7; };
struct BFu15ll_BFu31i_BFu7i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:7; };
struct BFu15ll_BFu31i_BFu7ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:7; };
struct BFu15ll_BFu31i_BFu7s { unsigned long long v1:15; unsigned int v2:31; unsigned short v3:7; };
struct BFu15ll_BFu31i_BFu8c { unsigned long long v1:15; unsigned int v2:31; unsigned char v3:8; };
struct BFu15ll_BFu31i_BFu8i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:8; };
struct BFu15ll_BFu31i_BFu8ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:8; };
struct BFu15ll_BFu31i_BFu8s { unsigned long long v1:15; unsigned int v2:31; unsigned short v3:8; };
struct BFu15ll_BFu31i_BFu9i { unsigned long long v1:15; unsigned int v2:31; unsigned int v3:9; };
struct BFu15ll_BFu31i_BFu9ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3:9; };
struct BFu15ll_BFu31i_BFu9s { unsigned long long v1:15; unsigned int v2:31; unsigned short v3:9; };
struct BFu15ll_BFu31i_C { unsigned long long v1:15; unsigned int v2:31; char v3; };
struct BFu15ll_BFu31i_D { unsigned long long v1:15; unsigned int v2:31; double v3; };
struct BFu15ll_BFu31i_F { unsigned long long v1:15; unsigned int v2:31; float v3; };
struct BFu15ll_BFu31i_I { unsigned long long v1:15; unsigned int v2:31; int v3; };
struct BFu15ll_BFu31i_Ip { unsigned long long v1:15; unsigned int v2:31; int * v3; };
struct BFu15ll_BFu31i_L { unsigned long long v1:15; unsigned int v2:31; long long v3; };
struct BFu15ll_BFu31i_S { unsigned long long v1:15; unsigned int v2:31; short v3; };
struct BFu15ll_BFu31i_Uc { unsigned long long v1:15; unsigned int v2:31; unsigned char v3; };
struct BFu15ll_BFu31i_Ui { unsigned long long v1:15; unsigned int v2:31; unsigned int v3; };
struct BFu15ll_BFu31i_Ul { unsigned long long v1:15; unsigned int v2:31; unsigned long long v3; };
struct BFu15ll_BFu31i_Us { unsigned long long v1:15; unsigned int v2:31; unsigned short v3; };
struct BFu15ll_BFu31i_Vp { unsigned long long v1:15; unsigned int v2:31; void * v3; };
struct BFu15ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:31; };
struct BFu15ll_BFu31ll_BFu15i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:15; };
struct BFu15ll_BFu31ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:15; };
struct BFu15ll_BFu31ll_BFu15s { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3:15; };
struct BFu15ll_BFu31ll_BFu16i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:16; };
struct BFu15ll_BFu31ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:16; };
struct BFu15ll_BFu31ll_BFu16s { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3:16; };
struct BFu15ll_BFu31ll_BFu17i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:17; };
struct BFu15ll_BFu31ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:17; };
struct BFu15ll_BFu31ll_BFu1c { unsigned long long v1:15; unsigned long long v2:31; unsigned char v3:1; };
struct BFu15ll_BFu31ll_BFu1i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:1; };
struct BFu15ll_BFu31ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:1; };
struct BFu15ll_BFu31ll_BFu1s { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3:1; };
struct BFu15ll_BFu31ll_BFu31i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:31; };
struct BFu15ll_BFu31ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:31; };
struct BFu15ll_BFu31ll_BFu32i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:32; };
struct BFu15ll_BFu31ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:32; };
struct BFu15ll_BFu31ll_BFu33 { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:33; };
struct BFu15ll_BFu31ll_BFu7c { unsigned long long v1:15; unsigned long long v2:31; unsigned char v3:7; };
struct BFu15ll_BFu31ll_BFu7i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:7; };
struct BFu15ll_BFu31ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:7; };
struct BFu15ll_BFu31ll_BFu7s { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3:7; };
struct BFu15ll_BFu31ll_BFu8c { unsigned long long v1:15; unsigned long long v2:31; unsigned char v3:8; };
struct BFu15ll_BFu31ll_BFu8i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:8; };
struct BFu15ll_BFu31ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:8; };
struct BFu15ll_BFu31ll_BFu8s { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3:8; };
struct BFu15ll_BFu31ll_BFu9i { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3:9; };
struct BFu15ll_BFu31ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3:9; };
struct BFu15ll_BFu31ll_BFu9s { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3:9; };
struct BFu15ll_BFu31ll_C { unsigned long long v1:15; unsigned long long v2:31; char v3; };
struct BFu15ll_BFu31ll_D { unsigned long long v1:15; unsigned long long v2:31; double v3; };
struct BFu15ll_BFu31ll_F { unsigned long long v1:15; unsigned long long v2:31; float v3; };
struct BFu15ll_BFu31ll_I { unsigned long long v1:15; unsigned long long v2:31; int v3; };
struct BFu15ll_BFu31ll_Ip { unsigned long long v1:15; unsigned long long v2:31; int * v3; };
struct BFu15ll_BFu31ll_L { unsigned long long v1:15; unsigned long long v2:31; long long v3; };
struct BFu15ll_BFu31ll_S { unsigned long long v1:15; unsigned long long v2:31; short v3; };
struct BFu15ll_BFu31ll_Uc { unsigned long long v1:15; unsigned long long v2:31; unsigned char v3; };
struct BFu15ll_BFu31ll_Ui { unsigned long long v1:15; unsigned long long v2:31; unsigned int v3; };
struct BFu15ll_BFu31ll_Ul { unsigned long long v1:15; unsigned long long v2:31; unsigned long long v3; };
struct BFu15ll_BFu31ll_Us { unsigned long long v1:15; unsigned long long v2:31; unsigned short v3; };
struct BFu15ll_BFu31ll_Vp { unsigned long long v1:15; unsigned long long v2:31; void * v3; };
struct BFu15ll_BFu32i { unsigned long long v1:15; unsigned int v2:32; };
struct BFu15ll_BFu32i_BFu15i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:15; };
struct BFu15ll_BFu32i_BFu15ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:15; };
struct BFu15ll_BFu32i_BFu15s { unsigned long long v1:15; unsigned int v2:32; unsigned short v3:15; };
struct BFu15ll_BFu32i_BFu16i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:16; };
struct BFu15ll_BFu32i_BFu16ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:16; };
struct BFu15ll_BFu32i_BFu16s { unsigned long long v1:15; unsigned int v2:32; unsigned short v3:16; };
struct BFu15ll_BFu32i_BFu17i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:17; };
struct BFu15ll_BFu32i_BFu17ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:17; };
struct BFu15ll_BFu32i_BFu1c { unsigned long long v1:15; unsigned int v2:32; unsigned char v3:1; };
struct BFu15ll_BFu32i_BFu1i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:1; };
struct BFu15ll_BFu32i_BFu1ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:1; };
struct BFu15ll_BFu32i_BFu1s { unsigned long long v1:15; unsigned int v2:32; unsigned short v3:1; };
struct BFu15ll_BFu32i_BFu31i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:31; };
struct BFu15ll_BFu32i_BFu31ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:31; };
struct BFu15ll_BFu32i_BFu32i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:32; };
struct BFu15ll_BFu32i_BFu32ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:32; };
struct BFu15ll_BFu32i_BFu33 { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:33; };
struct BFu15ll_BFu32i_BFu7c { unsigned long long v1:15; unsigned int v2:32; unsigned char v3:7; };
struct BFu15ll_BFu32i_BFu7i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:7; };
struct BFu15ll_BFu32i_BFu7ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:7; };
struct BFu15ll_BFu32i_BFu7s { unsigned long long v1:15; unsigned int v2:32; unsigned short v3:7; };
struct BFu15ll_BFu32i_BFu8c { unsigned long long v1:15; unsigned int v2:32; unsigned char v3:8; };
struct BFu15ll_BFu32i_BFu8i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:8; };
struct BFu15ll_BFu32i_BFu8ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:8; };
struct BFu15ll_BFu32i_BFu8s { unsigned long long v1:15; unsigned int v2:32; unsigned short v3:8; };
struct BFu15ll_BFu32i_BFu9i { unsigned long long v1:15; unsigned int v2:32; unsigned int v3:9; };
struct BFu15ll_BFu32i_BFu9ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3:9; };
struct BFu15ll_BFu32i_BFu9s { unsigned long long v1:15; unsigned int v2:32; unsigned short v3:9; };
struct BFu15ll_BFu32i_C { unsigned long long v1:15; unsigned int v2:32; char v3; };
struct BFu15ll_BFu32i_D { unsigned long long v1:15; unsigned int v2:32; double v3; };
struct BFu15ll_BFu32i_F { unsigned long long v1:15; unsigned int v2:32; float v3; };
struct BFu15ll_BFu32i_I { unsigned long long v1:15; unsigned int v2:32; int v3; };
struct BFu15ll_BFu32i_Ip { unsigned long long v1:15; unsigned int v2:32; int * v3; };
struct BFu15ll_BFu32i_L { unsigned long long v1:15; unsigned int v2:32; long long v3; };
struct BFu15ll_BFu32i_S { unsigned long long v1:15; unsigned int v2:32; short v3; };
struct BFu15ll_BFu32i_Uc { unsigned long long v1:15; unsigned int v2:32; unsigned char v3; };
struct BFu15ll_BFu32i_Ui { unsigned long long v1:15; unsigned int v2:32; unsigned int v3; };
struct BFu15ll_BFu32i_Ul { unsigned long long v1:15; unsigned int v2:32; unsigned long long v3; };
struct BFu15ll_BFu32i_Us { unsigned long long v1:15; unsigned int v2:32; unsigned short v3; };
struct BFu15ll_BFu32i_Vp { unsigned long long v1:15; unsigned int v2:32; void * v3; };
struct BFu15ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:32; };
struct BFu15ll_BFu32ll_BFu15i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:15; };
struct BFu15ll_BFu32ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:15; };
struct BFu15ll_BFu32ll_BFu15s { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3:15; };
struct BFu15ll_BFu32ll_BFu16i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:16; };
struct BFu15ll_BFu32ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:16; };
struct BFu15ll_BFu32ll_BFu16s { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3:16; };
struct BFu15ll_BFu32ll_BFu17i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:17; };
struct BFu15ll_BFu32ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:17; };
struct BFu15ll_BFu32ll_BFu1c { unsigned long long v1:15; unsigned long long v2:32; unsigned char v3:1; };
struct BFu15ll_BFu32ll_BFu1i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:1; };
struct BFu15ll_BFu32ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:1; };
struct BFu15ll_BFu32ll_BFu1s { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3:1; };
struct BFu15ll_BFu32ll_BFu31i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:31; };
struct BFu15ll_BFu32ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:31; };
struct BFu15ll_BFu32ll_BFu32i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:32; };
struct BFu15ll_BFu32ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:32; };
struct BFu15ll_BFu32ll_BFu33 { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:33; };
struct BFu15ll_BFu32ll_BFu7c { unsigned long long v1:15; unsigned long long v2:32; unsigned char v3:7; };
struct BFu15ll_BFu32ll_BFu7i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:7; };
struct BFu15ll_BFu32ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:7; };
struct BFu15ll_BFu32ll_BFu7s { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3:7; };
struct BFu15ll_BFu32ll_BFu8c { unsigned long long v1:15; unsigned long long v2:32; unsigned char v3:8; };
struct BFu15ll_BFu32ll_BFu8i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:8; };
struct BFu15ll_BFu32ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:8; };
struct BFu15ll_BFu32ll_BFu8s { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3:8; };
struct BFu15ll_BFu32ll_BFu9i { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3:9; };
struct BFu15ll_BFu32ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3:9; };
struct BFu15ll_BFu32ll_BFu9s { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3:9; };
struct BFu15ll_BFu32ll_C { unsigned long long v1:15; unsigned long long v2:32; char v3; };
struct BFu15ll_BFu32ll_D { unsigned long long v1:15; unsigned long long v2:32; double v3; };
struct BFu15ll_BFu32ll_F { unsigned long long v1:15; unsigned long long v2:32; float v3; };
struct BFu15ll_BFu32ll_I { unsigned long long v1:15; unsigned long long v2:32; int v3; };
struct BFu15ll_BFu32ll_Ip { unsigned long long v1:15; unsigned long long v2:32; int * v3; };
struct BFu15ll_BFu32ll_L { unsigned long long v1:15; unsigned long long v2:32; long long v3; };
struct BFu15ll_BFu32ll_S { unsigned long long v1:15; unsigned long long v2:32; short v3; };
struct BFu15ll_BFu32ll_Uc { unsigned long long v1:15; unsigned long long v2:32; unsigned char v3; };
struct BFu15ll_BFu32ll_Ui { unsigned long long v1:15; unsigned long long v2:32; unsigned int v3; };
struct BFu15ll_BFu32ll_Ul { unsigned long long v1:15; unsigned long long v2:32; unsigned long long v3; };
struct BFu15ll_BFu32ll_Us { unsigned long long v1:15; unsigned long long v2:32; unsigned short v3; };
struct BFu15ll_BFu32ll_Vp { unsigned long long v1:15; unsigned long long v2:32; void * v3; };
struct BFu15ll_BFu33 { unsigned long long v1:15; unsigned long long v2:33; };
struct BFu15ll_BFu33_BFu15i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:15; };
struct BFu15ll_BFu33_BFu15ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:15; };
struct BFu15ll_BFu33_BFu15s { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3:15; };
struct BFu15ll_BFu33_BFu16i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:16; };
struct BFu15ll_BFu33_BFu16ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:16; };
struct BFu15ll_BFu33_BFu16s { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3:16; };
struct BFu15ll_BFu33_BFu17i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:17; };
struct BFu15ll_BFu33_BFu17ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:17; };
struct BFu15ll_BFu33_BFu1c { unsigned long long v1:15; unsigned long long v2:33; unsigned char v3:1; };
struct BFu15ll_BFu33_BFu1i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:1; };
struct BFu15ll_BFu33_BFu1ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:1; };
struct BFu15ll_BFu33_BFu1s { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3:1; };
struct BFu15ll_BFu33_BFu31i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:31; };
struct BFu15ll_BFu33_BFu31ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:31; };
struct BFu15ll_BFu33_BFu32i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:32; };
struct BFu15ll_BFu33_BFu32ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:32; };
struct BFu15ll_BFu33_BFu33 { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:33; };
struct BFu15ll_BFu33_BFu7c { unsigned long long v1:15; unsigned long long v2:33; unsigned char v3:7; };
struct BFu15ll_BFu33_BFu7i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:7; };
struct BFu15ll_BFu33_BFu7ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:7; };
struct BFu15ll_BFu33_BFu7s { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3:7; };
struct BFu15ll_BFu33_BFu8c { unsigned long long v1:15; unsigned long long v2:33; unsigned char v3:8; };
struct BFu15ll_BFu33_BFu8i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:8; };
struct BFu15ll_BFu33_BFu8ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:8; };
struct BFu15ll_BFu33_BFu8s { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3:8; };
struct BFu15ll_BFu33_BFu9i { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3:9; };
struct BFu15ll_BFu33_BFu9ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3:9; };
struct BFu15ll_BFu33_BFu9s { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3:9; };
struct BFu15ll_BFu33_C { unsigned long long v1:15; unsigned long long v2:33; char v3; };
struct BFu15ll_BFu33_D { unsigned long long v1:15; unsigned long long v2:33; double v3; };
struct BFu15ll_BFu33_F { unsigned long long v1:15; unsigned long long v2:33; float v3; };
struct BFu15ll_BFu33_I { unsigned long long v1:15; unsigned long long v2:33; int v3; };
struct BFu15ll_BFu33_Ip { unsigned long long v1:15; unsigned long long v2:33; int * v3; };
struct BFu15ll_BFu33_L { unsigned long long v1:15; unsigned long long v2:33; long long v3; };
struct BFu15ll_BFu33_S { unsigned long long v1:15; unsigned long long v2:33; short v3; };
struct BFu15ll_BFu33_Uc { unsigned long long v1:15; unsigned long long v2:33; unsigned char v3; };
struct BFu15ll_BFu33_Ui { unsigned long long v1:15; unsigned long long v2:33; unsigned int v3; };
struct BFu15ll_BFu33_Ul { unsigned long long v1:15; unsigned long long v2:33; unsigned long long v3; };
struct BFu15ll_BFu33_Us { unsigned long long v1:15; unsigned long long v2:33; unsigned short v3; };
struct BFu15ll_BFu33_Vp { unsigned long long v1:15; unsigned long long v2:33; void * v3; };
struct BFu15ll_BFu7c { unsigned long long v1:15; unsigned char v2:7; };
struct BFu15ll_BFu7c_BFu15i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:15; };
struct BFu15ll_BFu7c_BFu15ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:15; };
struct BFu15ll_BFu7c_BFu15s { unsigned long long v1:15; unsigned char v2:7; unsigned short v3:15; };
struct BFu15ll_BFu7c_BFu16i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:16; };
struct BFu15ll_BFu7c_BFu16ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:16; };
struct BFu15ll_BFu7c_BFu16s { unsigned long long v1:15; unsigned char v2:7; unsigned short v3:16; };
struct BFu15ll_BFu7c_BFu17i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:17; };
struct BFu15ll_BFu7c_BFu17ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:17; };
struct BFu15ll_BFu7c_BFu1c { unsigned long long v1:15; unsigned char v2:7; unsigned char v3:1; };
struct BFu15ll_BFu7c_BFu1i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:1; };
struct BFu15ll_BFu7c_BFu1ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:1; };
struct BFu15ll_BFu7c_BFu1s { unsigned long long v1:15; unsigned char v2:7; unsigned short v3:1; };
struct BFu15ll_BFu7c_BFu31i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:31; };
struct BFu15ll_BFu7c_BFu31ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:31; };
struct BFu15ll_BFu7c_BFu32i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:32; };
struct BFu15ll_BFu7c_BFu32ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:32; };
struct BFu15ll_BFu7c_BFu33 { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:33; };
struct BFu15ll_BFu7c_BFu7c { unsigned long long v1:15; unsigned char v2:7; unsigned char v3:7; };
struct BFu15ll_BFu7c_BFu7i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:7; };
struct BFu15ll_BFu7c_BFu7ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:7; };
struct BFu15ll_BFu7c_BFu7s { unsigned long long v1:15; unsigned char v2:7; unsigned short v3:7; };
struct BFu15ll_BFu7c_BFu8c { unsigned long long v1:15; unsigned char v2:7; unsigned char v3:8; };
struct BFu15ll_BFu7c_BFu8i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:8; };
struct BFu15ll_BFu7c_BFu8ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:8; };
struct BFu15ll_BFu7c_BFu8s { unsigned long long v1:15; unsigned char v2:7; unsigned short v3:8; };
struct BFu15ll_BFu7c_BFu9i { unsigned long long v1:15; unsigned char v2:7; unsigned int v3:9; };
struct BFu15ll_BFu7c_BFu9ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3:9; };
struct BFu15ll_BFu7c_BFu9s { unsigned long long v1:15; unsigned char v2:7; unsigned short v3:9; };
struct BFu15ll_BFu7c_C { unsigned long long v1:15; unsigned char v2:7; char v3; };
struct BFu15ll_BFu7c_D { unsigned long long v1:15; unsigned char v2:7; double v3; };
struct BFu15ll_BFu7c_F { unsigned long long v1:15; unsigned char v2:7; float v3; };
struct BFu15ll_BFu7c_I { unsigned long long v1:15; unsigned char v2:7; int v3; };
struct BFu15ll_BFu7c_Ip { unsigned long long v1:15; unsigned char v2:7; int * v3; };
struct BFu15ll_BFu7c_L { unsigned long long v1:15; unsigned char v2:7; long long v3; };
struct BFu15ll_BFu7c_S { unsigned long long v1:15; unsigned char v2:7; short v3; };
struct BFu15ll_BFu7c_Uc { unsigned long long v1:15; unsigned char v2:7; unsigned char v3; };
struct BFu15ll_BFu7c_Ui { unsigned long long v1:15; unsigned char v2:7; unsigned int v3; };
struct BFu15ll_BFu7c_Ul { unsigned long long v1:15; unsigned char v2:7; unsigned long long v3; };
struct BFu15ll_BFu7c_Us { unsigned long long v1:15; unsigned char v2:7; unsigned short v3; };
struct BFu15ll_BFu7c_Vp { unsigned long long v1:15; unsigned char v2:7; void * v3; };
struct BFu15ll_BFu7i { unsigned long long v1:15; unsigned int v2:7; };
struct BFu15ll_BFu7i_BFu15i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:15; };
struct BFu15ll_BFu7i_BFu15ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:15; };
struct BFu15ll_BFu7i_BFu15s { unsigned long long v1:15; unsigned int v2:7; unsigned short v3:15; };
struct BFu15ll_BFu7i_BFu16i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:16; };
struct BFu15ll_BFu7i_BFu16ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:16; };
struct BFu15ll_BFu7i_BFu16s { unsigned long long v1:15; unsigned int v2:7; unsigned short v3:16; };
struct BFu15ll_BFu7i_BFu17i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:17; };
struct BFu15ll_BFu7i_BFu17ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:17; };
struct BFu15ll_BFu7i_BFu1c { unsigned long long v1:15; unsigned int v2:7; unsigned char v3:1; };
struct BFu15ll_BFu7i_BFu1i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:1; };
struct BFu15ll_BFu7i_BFu1ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:1; };
struct BFu15ll_BFu7i_BFu1s { unsigned long long v1:15; unsigned int v2:7; unsigned short v3:1; };
struct BFu15ll_BFu7i_BFu31i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:31; };
struct BFu15ll_BFu7i_BFu31ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:31; };
struct BFu15ll_BFu7i_BFu32i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:32; };
struct BFu15ll_BFu7i_BFu32ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:32; };
struct BFu15ll_BFu7i_BFu33 { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:33; };
struct BFu15ll_BFu7i_BFu7c { unsigned long long v1:15; unsigned int v2:7; unsigned char v3:7; };
struct BFu15ll_BFu7i_BFu7i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:7; };
struct BFu15ll_BFu7i_BFu7ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:7; };
struct BFu15ll_BFu7i_BFu7s { unsigned long long v1:15; unsigned int v2:7; unsigned short v3:7; };
struct BFu15ll_BFu7i_BFu8c { unsigned long long v1:15; unsigned int v2:7; unsigned char v3:8; };
struct BFu15ll_BFu7i_BFu8i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:8; };
struct BFu15ll_BFu7i_BFu8ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:8; };
struct BFu15ll_BFu7i_BFu8s { unsigned long long v1:15; unsigned int v2:7; unsigned short v3:8; };
struct BFu15ll_BFu7i_BFu9i { unsigned long long v1:15; unsigned int v2:7; unsigned int v3:9; };
struct BFu15ll_BFu7i_BFu9ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3:9; };
struct BFu15ll_BFu7i_BFu9s { unsigned long long v1:15; unsigned int v2:7; unsigned short v3:9; };
struct BFu15ll_BFu7i_C { unsigned long long v1:15; unsigned int v2:7; char v3; };
struct BFu15ll_BFu7i_D { unsigned long long v1:15; unsigned int v2:7; double v3; };
struct BFu15ll_BFu7i_F { unsigned long long v1:15; unsigned int v2:7; float v3; };
struct BFu15ll_BFu7i_I { unsigned long long v1:15; unsigned int v2:7; int v3; };
struct BFu15ll_BFu7i_Ip { unsigned long long v1:15; unsigned int v2:7; int * v3; };
struct BFu15ll_BFu7i_L { unsigned long long v1:15; unsigned int v2:7; long long v3; };
struct BFu15ll_BFu7i_S { unsigned long long v1:15; unsigned int v2:7; short v3; };
struct BFu15ll_BFu7i_Uc { unsigned long long v1:15; unsigned int v2:7; unsigned char v3; };
struct BFu15ll_BFu7i_Ui { unsigned long long v1:15; unsigned int v2:7; unsigned int v3; };
struct BFu15ll_BFu7i_Ul { unsigned long long v1:15; unsigned int v2:7; unsigned long long v3; };
struct BFu15ll_BFu7i_Us { unsigned long long v1:15; unsigned int v2:7; unsigned short v3; };
struct BFu15ll_BFu7i_Vp { unsigned long long v1:15; unsigned int v2:7; void * v3; };
struct BFu15ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:7; };
struct BFu15ll_BFu7ll_BFu15i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:15; };
struct BFu15ll_BFu7ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:15; };
struct BFu15ll_BFu7ll_BFu15s { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3:15; };
struct BFu15ll_BFu7ll_BFu16i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:16; };
struct BFu15ll_BFu7ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:16; };
struct BFu15ll_BFu7ll_BFu16s { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3:16; };
struct BFu15ll_BFu7ll_BFu17i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:17; };
struct BFu15ll_BFu7ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:17; };
struct BFu15ll_BFu7ll_BFu1c { unsigned long long v1:15; unsigned long long v2:7; unsigned char v3:1; };
struct BFu15ll_BFu7ll_BFu1i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:1; };
struct BFu15ll_BFu7ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:1; };
struct BFu15ll_BFu7ll_BFu1s { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3:1; };
struct BFu15ll_BFu7ll_BFu31i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:31; };
struct BFu15ll_BFu7ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:31; };
struct BFu15ll_BFu7ll_BFu32i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:32; };
struct BFu15ll_BFu7ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:32; };
struct BFu15ll_BFu7ll_BFu33 { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:33; };
struct BFu15ll_BFu7ll_BFu7c { unsigned long long v1:15; unsigned long long v2:7; unsigned char v3:7; };
struct BFu15ll_BFu7ll_BFu7i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:7; };
struct BFu15ll_BFu7ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:7; };
struct BFu15ll_BFu7ll_BFu7s { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3:7; };
struct BFu15ll_BFu7ll_BFu8c { unsigned long long v1:15; unsigned long long v2:7; unsigned char v3:8; };
struct BFu15ll_BFu7ll_BFu8i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:8; };
struct BFu15ll_BFu7ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:8; };
struct BFu15ll_BFu7ll_BFu8s { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3:8; };
struct BFu15ll_BFu7ll_BFu9i { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3:9; };
struct BFu15ll_BFu7ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3:9; };
struct BFu15ll_BFu7ll_BFu9s { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3:9; };
struct BFu15ll_BFu7ll_C { unsigned long long v1:15; unsigned long long v2:7; char v3; };
struct BFu15ll_BFu7ll_D { unsigned long long v1:15; unsigned long long v2:7; double v3; };
struct BFu15ll_BFu7ll_F { unsigned long long v1:15; unsigned long long v2:7; float v3; };
struct BFu15ll_BFu7ll_I { unsigned long long v1:15; unsigned long long v2:7; int v3; };
struct BFu15ll_BFu7ll_Ip { unsigned long long v1:15; unsigned long long v2:7; int * v3; };
struct BFu15ll_BFu7ll_L { unsigned long long v1:15; unsigned long long v2:7; long long v3; };
struct BFu15ll_BFu7ll_S { unsigned long long v1:15; unsigned long long v2:7; short v3; };
struct BFu15ll_BFu7ll_Uc { unsigned long long v1:15; unsigned long long v2:7; unsigned char v3; };
struct BFu15ll_BFu7ll_Ui { unsigned long long v1:15; unsigned long long v2:7; unsigned int v3; };
struct BFu15ll_BFu7ll_Ul { unsigned long long v1:15; unsigned long long v2:7; unsigned long long v3; };
struct BFu15ll_BFu7ll_Us { unsigned long long v1:15; unsigned long long v2:7; unsigned short v3; };
struct BFu15ll_BFu7ll_Vp { unsigned long long v1:15; unsigned long long v2:7; void * v3; };
struct BFu15ll_BFu7s { unsigned long long v1:15; unsigned short v2:7; };
struct BFu15ll_BFu7s_BFu15i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:15; };
struct BFu15ll_BFu7s_BFu15ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:15; };
struct BFu15ll_BFu7s_BFu15s { unsigned long long v1:15; unsigned short v2:7; unsigned short v3:15; };
struct BFu15ll_BFu7s_BFu16i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:16; };
struct BFu15ll_BFu7s_BFu16ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:16; };
struct BFu15ll_BFu7s_BFu16s { unsigned long long v1:15; unsigned short v2:7; unsigned short v3:16; };
struct BFu15ll_BFu7s_BFu17i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:17; };
struct BFu15ll_BFu7s_BFu17ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:17; };
struct BFu15ll_BFu7s_BFu1c { unsigned long long v1:15; unsigned short v2:7; unsigned char v3:1; };
struct BFu15ll_BFu7s_BFu1i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:1; };
struct BFu15ll_BFu7s_BFu1ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:1; };
struct BFu15ll_BFu7s_BFu1s { unsigned long long v1:15; unsigned short v2:7; unsigned short v3:1; };
struct BFu15ll_BFu7s_BFu31i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:31; };
struct BFu15ll_BFu7s_BFu31ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:31; };
struct BFu15ll_BFu7s_BFu32i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:32; };
struct BFu15ll_BFu7s_BFu32ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:32; };
struct BFu15ll_BFu7s_BFu33 { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:33; };
struct BFu15ll_BFu7s_BFu7c { unsigned long long v1:15; unsigned short v2:7; unsigned char v3:7; };
struct BFu15ll_BFu7s_BFu7i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:7; };
struct BFu15ll_BFu7s_BFu7ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:7; };
struct BFu15ll_BFu7s_BFu7s { unsigned long long v1:15; unsigned short v2:7; unsigned short v3:7; };
struct BFu15ll_BFu7s_BFu8c { unsigned long long v1:15; unsigned short v2:7; unsigned char v3:8; };
struct BFu15ll_BFu7s_BFu8i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:8; };
struct BFu15ll_BFu7s_BFu8ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:8; };
struct BFu15ll_BFu7s_BFu8s { unsigned long long v1:15; unsigned short v2:7; unsigned short v3:8; };
struct BFu15ll_BFu7s_BFu9i { unsigned long long v1:15; unsigned short v2:7; unsigned int v3:9; };
struct BFu15ll_BFu7s_BFu9ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3:9; };
struct BFu15ll_BFu7s_BFu9s { unsigned long long v1:15; unsigned short v2:7; unsigned short v3:9; };
struct BFu15ll_BFu7s_C { unsigned long long v1:15; unsigned short v2:7; char v3; };
struct BFu15ll_BFu7s_D { unsigned long long v1:15; unsigned short v2:7; double v3; };
struct BFu15ll_BFu7s_F { unsigned long long v1:15; unsigned short v2:7; float v3; };
struct BFu15ll_BFu7s_I { unsigned long long v1:15; unsigned short v2:7; int v3; };
struct BFu15ll_BFu7s_Ip { unsigned long long v1:15; unsigned short v2:7; int * v3; };
struct BFu15ll_BFu7s_L { unsigned long long v1:15; unsigned short v2:7; long long v3; };
struct BFu15ll_BFu7s_S { unsigned long long v1:15; unsigned short v2:7; short v3; };
struct BFu15ll_BFu7s_Uc { unsigned long long v1:15; unsigned short v2:7; unsigned char v3; };
struct BFu15ll_BFu7s_Ui { unsigned long long v1:15; unsigned short v2:7; unsigned int v3; };
struct BFu15ll_BFu7s_Ul { unsigned long long v1:15; unsigned short v2:7; unsigned long long v3; };
struct BFu15ll_BFu7s_Us { unsigned long long v1:15; unsigned short v2:7; unsigned short v3; };
struct BFu15ll_BFu7s_Vp { unsigned long long v1:15; unsigned short v2:7; void * v3; };
struct BFu15ll_BFu8c { unsigned long long v1:15; unsigned char v2:8; };
struct BFu15ll_BFu8c_BFu15i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:15; };
struct BFu15ll_BFu8c_BFu15ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:15; };
struct BFu15ll_BFu8c_BFu15s { unsigned long long v1:15; unsigned char v2:8; unsigned short v3:15; };
struct BFu15ll_BFu8c_BFu16i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:16; };
struct BFu15ll_BFu8c_BFu16ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:16; };
struct BFu15ll_BFu8c_BFu16s { unsigned long long v1:15; unsigned char v2:8; unsigned short v3:16; };
struct BFu15ll_BFu8c_BFu17i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:17; };
struct BFu15ll_BFu8c_BFu17ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:17; };
struct BFu15ll_BFu8c_BFu1c { unsigned long long v1:15; unsigned char v2:8; unsigned char v3:1; };
struct BFu15ll_BFu8c_BFu1i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:1; };
struct BFu15ll_BFu8c_BFu1ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:1; };
struct BFu15ll_BFu8c_BFu1s { unsigned long long v1:15; unsigned char v2:8; unsigned short v3:1; };
struct BFu15ll_BFu8c_BFu31i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:31; };
struct BFu15ll_BFu8c_BFu31ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:31; };
struct BFu15ll_BFu8c_BFu32i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:32; };
struct BFu15ll_BFu8c_BFu32ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:32; };
struct BFu15ll_BFu8c_BFu33 { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:33; };
struct BFu15ll_BFu8c_BFu7c { unsigned long long v1:15; unsigned char v2:8; unsigned char v3:7; };
struct BFu15ll_BFu8c_BFu7i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:7; };
struct BFu15ll_BFu8c_BFu7ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:7; };
struct BFu15ll_BFu8c_BFu7s { unsigned long long v1:15; unsigned char v2:8; unsigned short v3:7; };
struct BFu15ll_BFu8c_BFu8c { unsigned long long v1:15; unsigned char v2:8; unsigned char v3:8; };
struct BFu15ll_BFu8c_BFu8i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:8; };
struct BFu15ll_BFu8c_BFu8ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:8; };
struct BFu15ll_BFu8c_BFu8s { unsigned long long v1:15; unsigned char v2:8; unsigned short v3:8; };
struct BFu15ll_BFu8c_BFu9i { unsigned long long v1:15; unsigned char v2:8; unsigned int v3:9; };
struct BFu15ll_BFu8c_BFu9ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3:9; };
struct BFu15ll_BFu8c_BFu9s { unsigned long long v1:15; unsigned char v2:8; unsigned short v3:9; };
struct BFu15ll_BFu8c_C { unsigned long long v1:15; unsigned char v2:8; char v3; };
struct BFu15ll_BFu8c_D { unsigned long long v1:15; unsigned char v2:8; double v3; };
struct BFu15ll_BFu8c_F { unsigned long long v1:15; unsigned char v2:8; float v3; };
struct BFu15ll_BFu8c_I { unsigned long long v1:15; unsigned char v2:8; int v3; };
struct BFu15ll_BFu8c_Ip { unsigned long long v1:15; unsigned char v2:8; int * v3; };
struct BFu15ll_BFu8c_L { unsigned long long v1:15; unsigned char v2:8; long long v3; };
struct BFu15ll_BFu8c_S { unsigned long long v1:15; unsigned char v2:8; short v3; };
struct BFu15ll_BFu8c_Uc { unsigned long long v1:15; unsigned char v2:8; unsigned char v3; };
struct BFu15ll_BFu8c_Ui { unsigned long long v1:15; unsigned char v2:8; unsigned int v3; };
struct BFu15ll_BFu8c_Ul { unsigned long long v1:15; unsigned char v2:8; unsigned long long v3; };
struct BFu15ll_BFu8c_Us { unsigned long long v1:15; unsigned char v2:8; unsigned short v3; };
struct BFu15ll_BFu8c_Vp { unsigned long long v1:15; unsigned char v2:8; void * v3; };
struct BFu15ll_BFu8i { unsigned long long v1:15; unsigned int v2:8; };
struct BFu15ll_BFu8i_BFu15i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:15; };
struct BFu15ll_BFu8i_BFu15ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:15; };
struct BFu15ll_BFu8i_BFu15s { unsigned long long v1:15; unsigned int v2:8; unsigned short v3:15; };
struct BFu15ll_BFu8i_BFu16i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:16; };
struct BFu15ll_BFu8i_BFu16ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:16; };
struct BFu15ll_BFu8i_BFu16s { unsigned long long v1:15; unsigned int v2:8; unsigned short v3:16; };
struct BFu15ll_BFu8i_BFu17i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:17; };
struct BFu15ll_BFu8i_BFu17ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:17; };
struct BFu15ll_BFu8i_BFu1c { unsigned long long v1:15; unsigned int v2:8; unsigned char v3:1; };
struct BFu15ll_BFu8i_BFu1i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:1; };
struct BFu15ll_BFu8i_BFu1ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:1; };
struct BFu15ll_BFu8i_BFu1s { unsigned long long v1:15; unsigned int v2:8; unsigned short v3:1; };
struct BFu15ll_BFu8i_BFu31i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:31; };
struct BFu15ll_BFu8i_BFu31ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:31; };
struct BFu15ll_BFu8i_BFu32i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:32; };
struct BFu15ll_BFu8i_BFu32ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:32; };
struct BFu15ll_BFu8i_BFu33 { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:33; };
struct BFu15ll_BFu8i_BFu7c { unsigned long long v1:15; unsigned int v2:8; unsigned char v3:7; };
struct BFu15ll_BFu8i_BFu7i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:7; };
struct BFu15ll_BFu8i_BFu7ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:7; };
struct BFu15ll_BFu8i_BFu7s { unsigned long long v1:15; unsigned int v2:8; unsigned short v3:7; };
struct BFu15ll_BFu8i_BFu8c { unsigned long long v1:15; unsigned int v2:8; unsigned char v3:8; };
struct BFu15ll_BFu8i_BFu8i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:8; };
struct BFu15ll_BFu8i_BFu8ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:8; };
struct BFu15ll_BFu8i_BFu8s { unsigned long long v1:15; unsigned int v2:8; unsigned short v3:8; };
struct BFu15ll_BFu8i_BFu9i { unsigned long long v1:15; unsigned int v2:8; unsigned int v3:9; };
struct BFu15ll_BFu8i_BFu9ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3:9; };
struct BFu15ll_BFu8i_BFu9s { unsigned long long v1:15; unsigned int v2:8; unsigned short v3:9; };
struct BFu15ll_BFu8i_C { unsigned long long v1:15; unsigned int v2:8; char v3; };
struct BFu15ll_BFu8i_D { unsigned long long v1:15; unsigned int v2:8; double v3; };
struct BFu15ll_BFu8i_F { unsigned long long v1:15; unsigned int v2:8; float v3; };
struct BFu15ll_BFu8i_I { unsigned long long v1:15; unsigned int v2:8; int v3; };
struct BFu15ll_BFu8i_Ip { unsigned long long v1:15; unsigned int v2:8; int * v3; };
struct BFu15ll_BFu8i_L { unsigned long long v1:15; unsigned int v2:8; long long v3; };
struct BFu15ll_BFu8i_S { unsigned long long v1:15; unsigned int v2:8; short v3; };
struct BFu15ll_BFu8i_Uc { unsigned long long v1:15; unsigned int v2:8; unsigned char v3; };
struct BFu15ll_BFu8i_Ui { unsigned long long v1:15; unsigned int v2:8; unsigned int v3; };
struct BFu15ll_BFu8i_Ul { unsigned long long v1:15; unsigned int v2:8; unsigned long long v3; };
struct BFu15ll_BFu8i_Us { unsigned long long v1:15; unsigned int v2:8; unsigned short v3; };
struct BFu15ll_BFu8i_Vp { unsigned long long v1:15; unsigned int v2:8; void * v3; };
struct BFu15ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:8; };
struct BFu15ll_BFu8ll_BFu15i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:15; };
struct BFu15ll_BFu8ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:15; };
struct BFu15ll_BFu8ll_BFu15s { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3:15; };
struct BFu15ll_BFu8ll_BFu16i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:16; };
struct BFu15ll_BFu8ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:16; };
struct BFu15ll_BFu8ll_BFu16s { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3:16; };
struct BFu15ll_BFu8ll_BFu17i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:17; };
struct BFu15ll_BFu8ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:17; };
struct BFu15ll_BFu8ll_BFu1c { unsigned long long v1:15; unsigned long long v2:8; unsigned char v3:1; };
struct BFu15ll_BFu8ll_BFu1i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:1; };
struct BFu15ll_BFu8ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:1; };
struct BFu15ll_BFu8ll_BFu1s { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3:1; };
struct BFu15ll_BFu8ll_BFu31i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:31; };
struct BFu15ll_BFu8ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:31; };
struct BFu15ll_BFu8ll_BFu32i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:32; };
struct BFu15ll_BFu8ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:32; };
struct BFu15ll_BFu8ll_BFu33 { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:33; };
struct BFu15ll_BFu8ll_BFu7c { unsigned long long v1:15; unsigned long long v2:8; unsigned char v3:7; };
struct BFu15ll_BFu8ll_BFu7i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:7; };
struct BFu15ll_BFu8ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:7; };
struct BFu15ll_BFu8ll_BFu7s { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3:7; };
struct BFu15ll_BFu8ll_BFu8c { unsigned long long v1:15; unsigned long long v2:8; unsigned char v3:8; };
struct BFu15ll_BFu8ll_BFu8i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:8; };
struct BFu15ll_BFu8ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:8; };
struct BFu15ll_BFu8ll_BFu8s { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3:8; };
struct BFu15ll_BFu8ll_BFu9i { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3:9; };
struct BFu15ll_BFu8ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3:9; };
struct BFu15ll_BFu8ll_BFu9s { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3:9; };
struct BFu15ll_BFu8ll_C { unsigned long long v1:15; unsigned long long v2:8; char v3; };
struct BFu15ll_BFu8ll_D { unsigned long long v1:15; unsigned long long v2:8; double v3; };
struct BFu15ll_BFu8ll_F { unsigned long long v1:15; unsigned long long v2:8; float v3; };
struct BFu15ll_BFu8ll_I { unsigned long long v1:15; unsigned long long v2:8; int v3; };
struct BFu15ll_BFu8ll_Ip { unsigned long long v1:15; unsigned long long v2:8; int * v3; };
struct BFu15ll_BFu8ll_L { unsigned long long v1:15; unsigned long long v2:8; long long v3; };
struct BFu15ll_BFu8ll_S { unsigned long long v1:15; unsigned long long v2:8; short v3; };
struct BFu15ll_BFu8ll_Uc { unsigned long long v1:15; unsigned long long v2:8; unsigned char v3; };
struct BFu15ll_BFu8ll_Ui { unsigned long long v1:15; unsigned long long v2:8; unsigned int v3; };
struct BFu15ll_BFu8ll_Ul { unsigned long long v1:15; unsigned long long v2:8; unsigned long long v3; };
struct BFu15ll_BFu8ll_Us { unsigned long long v1:15; unsigned long long v2:8; unsigned short v3; };
struct BFu15ll_BFu8ll_Vp { unsigned long long v1:15; unsigned long long v2:8; void * v3; };
struct BFu15ll_BFu8s { unsigned long long v1:15; unsigned short v2:8; };
struct BFu15ll_BFu8s_BFu15i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:15; };
struct BFu15ll_BFu8s_BFu15ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:15; };
struct BFu15ll_BFu8s_BFu15s { unsigned long long v1:15; unsigned short v2:8; unsigned short v3:15; };
struct BFu15ll_BFu8s_BFu16i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:16; };
struct BFu15ll_BFu8s_BFu16ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:16; };
struct BFu15ll_BFu8s_BFu16s { unsigned long long v1:15; unsigned short v2:8; unsigned short v3:16; };
struct BFu15ll_BFu8s_BFu17i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:17; };
struct BFu15ll_BFu8s_BFu17ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:17; };
struct BFu15ll_BFu8s_BFu1c { unsigned long long v1:15; unsigned short v2:8; unsigned char v3:1; };
struct BFu15ll_BFu8s_BFu1i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:1; };
struct BFu15ll_BFu8s_BFu1ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:1; };
struct BFu15ll_BFu8s_BFu1s { unsigned long long v1:15; unsigned short v2:8; unsigned short v3:1; };
struct BFu15ll_BFu8s_BFu31i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:31; };
struct BFu15ll_BFu8s_BFu31ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:31; };
struct BFu15ll_BFu8s_BFu32i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:32; };
struct BFu15ll_BFu8s_BFu32ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:32; };
struct BFu15ll_BFu8s_BFu33 { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:33; };
struct BFu15ll_BFu8s_BFu7c { unsigned long long v1:15; unsigned short v2:8; unsigned char v3:7; };
struct BFu15ll_BFu8s_BFu7i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:7; };
struct BFu15ll_BFu8s_BFu7ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:7; };
struct BFu15ll_BFu8s_BFu7s { unsigned long long v1:15; unsigned short v2:8; unsigned short v3:7; };
struct BFu15ll_BFu8s_BFu8c { unsigned long long v1:15; unsigned short v2:8; unsigned char v3:8; };
struct BFu15ll_BFu8s_BFu8i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:8; };
struct BFu15ll_BFu8s_BFu8ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:8; };
struct BFu15ll_BFu8s_BFu8s { unsigned long long v1:15; unsigned short v2:8; unsigned short v3:8; };
struct BFu15ll_BFu8s_BFu9i { unsigned long long v1:15; unsigned short v2:8; unsigned int v3:9; };
struct BFu15ll_BFu8s_BFu9ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3:9; };
struct BFu15ll_BFu8s_BFu9s { unsigned long long v1:15; unsigned short v2:8; unsigned short v3:9; };
struct BFu15ll_BFu8s_C { unsigned long long v1:15; unsigned short v2:8; char v3; };
struct BFu15ll_BFu8s_D { unsigned long long v1:15; unsigned short v2:8; double v3; };
struct BFu15ll_BFu8s_F { unsigned long long v1:15; unsigned short v2:8; float v3; };
struct BFu15ll_BFu8s_I { unsigned long long v1:15; unsigned short v2:8; int v3; };
struct BFu15ll_BFu8s_Ip { unsigned long long v1:15; unsigned short v2:8; int * v3; };
struct BFu15ll_BFu8s_L { unsigned long long v1:15; unsigned short v2:8; long long v3; };
struct BFu15ll_BFu8s_S { unsigned long long v1:15; unsigned short v2:8; short v3; };
struct BFu15ll_BFu8s_Uc { unsigned long long v1:15; unsigned short v2:8; unsigned char v3; };
struct BFu15ll_BFu8s_Ui { unsigned long long v1:15; unsigned short v2:8; unsigned int v3; };
struct BFu15ll_BFu8s_Ul { unsigned long long v1:15; unsigned short v2:8; unsigned long long v3; };
struct BFu15ll_BFu8s_Us { unsigned long long v1:15; unsigned short v2:8; unsigned short v3; };
struct BFu15ll_BFu8s_Vp { unsigned long long v1:15; unsigned short v2:8; void * v3; };
struct BFu15ll_BFu9i { unsigned long long v1:15; unsigned int v2:9; };
struct BFu15ll_BFu9i_BFu15i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:15; };
struct BFu15ll_BFu9i_BFu15ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:15; };
struct BFu15ll_BFu9i_BFu15s { unsigned long long v1:15; unsigned int v2:9; unsigned short v3:15; };
struct BFu15ll_BFu9i_BFu16i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:16; };
struct BFu15ll_BFu9i_BFu16ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:16; };
struct BFu15ll_BFu9i_BFu16s { unsigned long long v1:15; unsigned int v2:9; unsigned short v3:16; };
struct BFu15ll_BFu9i_BFu17i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:17; };
struct BFu15ll_BFu9i_BFu17ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:17; };
struct BFu15ll_BFu9i_BFu1c { unsigned long long v1:15; unsigned int v2:9; unsigned char v3:1; };
struct BFu15ll_BFu9i_BFu1i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:1; };
struct BFu15ll_BFu9i_BFu1ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:1; };
struct BFu15ll_BFu9i_BFu1s { unsigned long long v1:15; unsigned int v2:9; unsigned short v3:1; };
struct BFu15ll_BFu9i_BFu31i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:31; };
struct BFu15ll_BFu9i_BFu31ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:31; };
struct BFu15ll_BFu9i_BFu32i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:32; };
struct BFu15ll_BFu9i_BFu32ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:32; };
struct BFu15ll_BFu9i_BFu33 { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:33; };
struct BFu15ll_BFu9i_BFu7c { unsigned long long v1:15; unsigned int v2:9; unsigned char v3:7; };
struct BFu15ll_BFu9i_BFu7i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:7; };
struct BFu15ll_BFu9i_BFu7ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:7; };
struct BFu15ll_BFu9i_BFu7s { unsigned long long v1:15; unsigned int v2:9; unsigned short v3:7; };
struct BFu15ll_BFu9i_BFu8c { unsigned long long v1:15; unsigned int v2:9; unsigned char v3:8; };
struct BFu15ll_BFu9i_BFu8i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:8; };
struct BFu15ll_BFu9i_BFu8ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:8; };
struct BFu15ll_BFu9i_BFu8s { unsigned long long v1:15; unsigned int v2:9; unsigned short v3:8; };
struct BFu15ll_BFu9i_BFu9i { unsigned long long v1:15; unsigned int v2:9; unsigned int v3:9; };
struct BFu15ll_BFu9i_BFu9ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3:9; };
struct BFu15ll_BFu9i_BFu9s { unsigned long long v1:15; unsigned int v2:9; unsigned short v3:9; };
struct BFu15ll_BFu9i_C { unsigned long long v1:15; unsigned int v2:9; char v3; };
struct BFu15ll_BFu9i_D { unsigned long long v1:15; unsigned int v2:9; double v3; };
struct BFu15ll_BFu9i_F { unsigned long long v1:15; unsigned int v2:9; float v3; };
struct BFu15ll_BFu9i_I { unsigned long long v1:15; unsigned int v2:9; int v3; };
struct BFu15ll_BFu9i_Ip { unsigned long long v1:15; unsigned int v2:9; int * v3; };
struct BFu15ll_BFu9i_L { unsigned long long v1:15; unsigned int v2:9; long long v3; };
struct BFu15ll_BFu9i_S { unsigned long long v1:15; unsigned int v2:9; short v3; };
struct BFu15ll_BFu9i_Uc { unsigned long long v1:15; unsigned int v2:9; unsigned char v3; };
struct BFu15ll_BFu9i_Ui { unsigned long long v1:15; unsigned int v2:9; unsigned int v3; };
struct BFu15ll_BFu9i_Ul { unsigned long long v1:15; unsigned int v2:9; unsigned long long v3; };
struct BFu15ll_BFu9i_Us { unsigned long long v1:15; unsigned int v2:9; unsigned short v3; };
struct BFu15ll_BFu9i_Vp { unsigned long long v1:15; unsigned int v2:9; void * v3; };
struct BFu15ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:9; };
struct BFu15ll_BFu9ll_BFu15i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:15; };
struct BFu15ll_BFu9ll_BFu15ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:15; };
struct BFu15ll_BFu9ll_BFu15s { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3:15; };
struct BFu15ll_BFu9ll_BFu16i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:16; };
struct BFu15ll_BFu9ll_BFu16ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:16; };
struct BFu15ll_BFu9ll_BFu16s { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3:16; };
struct BFu15ll_BFu9ll_BFu17i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:17; };
struct BFu15ll_BFu9ll_BFu17ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:17; };
struct BFu15ll_BFu9ll_BFu1c { unsigned long long v1:15; unsigned long long v2:9; unsigned char v3:1; };
struct BFu15ll_BFu9ll_BFu1i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:1; };
struct BFu15ll_BFu9ll_BFu1ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:1; };
struct BFu15ll_BFu9ll_BFu1s { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3:1; };
struct BFu15ll_BFu9ll_BFu31i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:31; };
struct BFu15ll_BFu9ll_BFu31ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:31; };
struct BFu15ll_BFu9ll_BFu32i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:32; };
struct BFu15ll_BFu9ll_BFu32ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:32; };
struct BFu15ll_BFu9ll_BFu33 { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:33; };
struct BFu15ll_BFu9ll_BFu7c { unsigned long long v1:15; unsigned long long v2:9; unsigned char v3:7; };
struct BFu15ll_BFu9ll_BFu7i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:7; };
struct BFu15ll_BFu9ll_BFu7ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:7; };
struct BFu15ll_BFu9ll_BFu7s { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3:7; };
struct BFu15ll_BFu9ll_BFu8c { unsigned long long v1:15; unsigned long long v2:9; unsigned char v3:8; };
struct BFu15ll_BFu9ll_BFu8i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:8; };
struct BFu15ll_BFu9ll_BFu8ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:8; };
struct BFu15ll_BFu9ll_BFu8s { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3:8; };
struct BFu15ll_BFu9ll_BFu9i { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3:9; };
struct BFu15ll_BFu9ll_BFu9ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3:9; };
struct BFu15ll_BFu9ll_BFu9s { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3:9; };
struct BFu15ll_BFu9ll_C { unsigned long long v1:15; unsigned long long v2:9; char v3; };
struct BFu15ll_BFu9ll_D { unsigned long long v1:15; unsigned long long v2:9; double v3; };
struct BFu15ll_BFu9ll_F { unsigned long long v1:15; unsigned long long v2:9; float v3; };
struct BFu15ll_BFu9ll_I { unsigned long long v1:15; unsigned long long v2:9; int v3; };
struct BFu15ll_BFu9ll_Ip { unsigned long long v1:15; unsigned long long v2:9; int * v3; };
struct BFu15ll_BFu9ll_L { unsigned long long v1:15; unsigned long long v2:9; long long v3; };
struct BFu15ll_BFu9ll_S { unsigned long long v1:15; unsigned long long v2:9; short v3; };
struct BFu15ll_BFu9ll_Uc { unsigned long long v1:15; unsigned long long v2:9; unsigned char v3; };
struct BFu15ll_BFu9ll_Ui { unsigned long long v1:15; unsigned long long v2:9; unsigned int v3; };
struct BFu15ll_BFu9ll_Ul { unsigned long long v1:15; unsigned long long v2:9; unsigned long long v3; };
struct BFu15ll_BFu9ll_Us { unsigned long long v1:15; unsigned long long v2:9; unsigned short v3; };
struct BFu15ll_BFu9ll_Vp { unsigned long long v1:15; unsigned long long v2:9; void * v3; };
struct BFu15ll_BFu9s { unsigned long long v1:15; unsigned short v2:9; };
struct BFu15ll_BFu9s_BFu15i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:15; };
struct BFu15ll_BFu9s_BFu15ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:15; };
struct BFu15ll_BFu9s_BFu15s { unsigned long long v1:15; unsigned short v2:9; unsigned short v3:15; };
struct BFu15ll_BFu9s_BFu16i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:16; };
struct BFu15ll_BFu9s_BFu16ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:16; };
struct BFu15ll_BFu9s_BFu16s { unsigned long long v1:15; unsigned short v2:9; unsigned short v3:16; };
struct BFu15ll_BFu9s_BFu17i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:17; };
struct BFu15ll_BFu9s_BFu17ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:17; };
struct BFu15ll_BFu9s_BFu1c { unsigned long long v1:15; unsigned short v2:9; unsigned char v3:1; };
struct BFu15ll_BFu9s_BFu1i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:1; };
struct BFu15ll_BFu9s_BFu1ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:1; };
struct BFu15ll_BFu9s_BFu1s { unsigned long long v1:15; unsigned short v2:9; unsigned short v3:1; };
struct BFu15ll_BFu9s_BFu31i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:31; };
struct BFu15ll_BFu9s_BFu31ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:31; };
struct BFu15ll_BFu9s_BFu32i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:32; };
struct BFu15ll_BFu9s_BFu32ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:32; };
struct BFu15ll_BFu9s_BFu33 { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:33; };
struct BFu15ll_BFu9s_BFu7c { unsigned long long v1:15; unsigned short v2:9; unsigned char v3:7; };
struct BFu15ll_BFu9s_BFu7i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:7; };
struct BFu15ll_BFu9s_BFu7ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:7; };
struct BFu15ll_BFu9s_BFu7s { unsigned long long v1:15; unsigned short v2:9; unsigned short v3:7; };
struct BFu15ll_BFu9s_BFu8c { unsigned long long v1:15; unsigned short v2:9; unsigned char v3:8; };
struct BFu15ll_BFu9s_BFu8i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:8; };
struct BFu15ll_BFu9s_BFu8ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:8; };
struct BFu15ll_BFu9s_BFu8s { unsigned long long v1:15; unsigned short v2:9; unsigned short v3:8; };
struct BFu15ll_BFu9s_BFu9i { unsigned long long v1:15; unsigned short v2:9; unsigned int v3:9; };
struct BFu15ll_BFu9s_BFu9ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3:9; };
struct BFu15ll_BFu9s_BFu9s { unsigned long long v1:15; unsigned short v2:9; unsigned short v3:9; };
struct BFu15ll_BFu9s_C { unsigned long long v1:15; unsigned short v2:9; char v3; };
struct BFu15ll_BFu9s_D { unsigned long long v1:15; unsigned short v2:9; double v3; };
struct BFu15ll_BFu9s_F { unsigned long long v1:15; unsigned short v2:9; float v3; };
struct BFu15ll_BFu9s_I { unsigned long long v1:15; unsigned short v2:9; int v3; };
struct BFu15ll_BFu9s_Ip { unsigned long long v1:15; unsigned short v2:9; int * v3; };
struct BFu15ll_BFu9s_L { unsigned long long v1:15; unsigned short v2:9; long long v3; };
struct BFu15ll_BFu9s_S { unsigned long long v1:15; unsigned short v2:9; short v3; };
struct BFu15ll_BFu9s_Uc { unsigned long long v1:15; unsigned short v2:9; unsigned char v3; };
struct BFu15ll_BFu9s_Ui { unsigned long long v1:15; unsigned short v2:9; unsigned int v3; };
struct BFu15ll_BFu9s_Ul { unsigned long long v1:15; unsigned short v2:9; unsigned long long v3; };
struct BFu15ll_BFu9s_Us { unsigned long long v1:15; unsigned short v2:9; unsigned short v3; };
struct BFu15ll_BFu9s_Vp { unsigned long long v1:15; unsigned short v2:9; void * v3; };
struct BFu15ll_C { unsigned long long v1:15; char v2; };
struct BFu15ll_C_BFu15i { unsigned long long v1:15; char v2; unsigned int v3:15; };
struct BFu15ll_C_BFu15ll { unsigned long long v1:15; char v2; unsigned long long v3:15; };
struct BFu15ll_C_BFu15s { unsigned long long v1:15; char v2; unsigned short v3:15; };
struct BFu15ll_C_BFu16i { unsigned long long v1:15; char v2; unsigned int v3:16; };
struct BFu15ll_C_BFu16ll { unsigned long long v1:15; char v2; unsigned long long v3:16; };
struct BFu15ll_C_BFu16s { unsigned long long v1:15; char v2; unsigned short v3:16; };
struct BFu15ll_C_BFu17i { unsigned long long v1:15; char v2; unsigned int v3:17; };
struct BFu15ll_C_BFu17ll { unsigned long long v1:15; char v2; unsigned long long v3:17; };
struct BFu15ll_C_BFu1c { unsigned long long v1:15; char v2; unsigned char v3:1; };
struct BFu15ll_C_BFu1i { unsigned long long v1:15; char v2; unsigned int v3:1; };
struct BFu15ll_C_BFu1ll { unsigned long long v1:15; char v2; unsigned long long v3:1; };
struct BFu15ll_C_BFu1s { unsigned long long v1:15; char v2; unsigned short v3:1; };
struct BFu15ll_C_BFu31i { unsigned long long v1:15; char v2; unsigned int v3:31; };
struct BFu15ll_C_BFu31ll { unsigned long long v1:15; char v2; unsigned long long v3:31; };
struct BFu15ll_C_BFu32i { unsigned long long v1:15; char v2; unsigned int v3:32; };
struct BFu15ll_C_BFu32ll { unsigned long long v1:15; char v2; unsigned long long v3:32; };
struct BFu15ll_C_BFu33 { unsigned long long v1:15; char v2; unsigned long long v3:33; };
struct BFu15ll_C_BFu7c { unsigned long long v1:15; char v2; unsigned char v3:7; };
struct BFu15ll_C_BFu7i { unsigned long long v1:15; char v2; unsigned int v3:7; };
struct BFu15ll_C_BFu7ll { unsigned long long v1:15; char v2; unsigned long long v3:7; };
struct BFu15ll_C_BFu7s { unsigned long long v1:15; char v2; unsigned short v3:7; };
struct BFu15ll_C_BFu8c { unsigned long long v1:15; char v2; unsigned char v3:8; };
struct BFu15ll_C_BFu8i { unsigned long long v1:15; char v2; unsigned int v3:8; };
struct BFu15ll_C_BFu8ll { unsigned long long v1:15; char v2; unsigned long long v3:8; };
struct BFu15ll_C_BFu8s { unsigned long long v1:15; char v2; unsigned short v3:8; };
struct BFu15ll_C_BFu9i { unsigned long long v1:15; char v2; unsigned int v3:9; };
struct BFu15ll_C_BFu9ll { unsigned long long v1:15; char v2; unsigned long long v3:9; };
struct BFu15ll_C_BFu9s { unsigned long long v1:15; char v2; unsigned short v3:9; };
struct BFu15ll_C_C { unsigned long long v1:15; char v2; char v3; };
struct BFu15ll_C_D { unsigned long long v1:15; char v2; double v3; };
struct BFu15ll_C_F { unsigned long long v1:15; char v2; float v3; };
struct BFu15ll_C_I { unsigned long long v1:15; char v2; int v3; };
struct BFu15ll_C_Ip { unsigned long long v1:15; char v2; int * v3; };
struct BFu15ll_C_L { unsigned long long v1:15; char v2; long long v3; };
struct BFu15ll_C_S { unsigned long long v1:15; char v2; short v3; };
struct BFu15ll_C_Uc { unsigned long long v1:15; char v2; unsigned char v3; };
struct BFu15ll_C_Ui { unsigned long long v1:15; char v2; unsigned int v3; };
struct BFu15ll_C_Ul { unsigned long long v1:15; char v2; unsigned long long v3; };
struct BFu15ll_C_Us { unsigned long long v1:15; char v2; unsigned short v3; };
struct BFu15ll_C_Vp { unsigned long long v1:15; char v2; void * v3; };
struct BFu15ll_D { unsigned long long v1:15; double v2; };
struct BFu15ll_D_BFu15i { unsigned long long v1:15; double v2; unsigned int v3:15; };
struct BFu15ll_D_BFu15ll { unsigned long long v1:15; double v2; unsigned long long v3:15; };
struct BFu15ll_D_BFu15s { unsigned long long v1:15; double v2; unsigned short v3:15; };
struct BFu15ll_D_BFu16i { unsigned long long v1:15; double v2; unsigned int v3:16; };
struct BFu15ll_D_BFu16ll { unsigned long long v1:15; double v2; unsigned long long v3:16; };
struct BFu15ll_D_BFu16s { unsigned long long v1:15; double v2; unsigned short v3:16; };
struct BFu15ll_D_BFu17i { unsigned long long v1:15; double v2; unsigned int v3:17; };
struct BFu15ll_D_BFu17ll { unsigned long long v1:15; double v2; unsigned long long v3:17; };
struct BFu15ll_D_BFu1c { unsigned long long v1:15; double v2; unsigned char v3:1; };
struct BFu15ll_D_BFu1i { unsigned long long v1:15; double v2; unsigned int v3:1; };
struct BFu15ll_D_BFu1ll { unsigned long long v1:15; double v2; unsigned long long v3:1; };
struct BFu15ll_D_BFu1s { unsigned long long v1:15; double v2; unsigned short v3:1; };
struct BFu15ll_D_BFu31i { unsigned long long v1:15; double v2; unsigned int v3:31; };
struct BFu15ll_D_BFu31ll { unsigned long long v1:15; double v2; unsigned long long v3:31; };
struct BFu15ll_D_BFu32i { unsigned long long v1:15; double v2; unsigned int v3:32; };
struct BFu15ll_D_BFu32ll { unsigned long long v1:15; double v2; unsigned long long v3:32; };
struct BFu15ll_D_BFu33 { unsigned long long v1:15; double v2; unsigned long long v3:33; };
struct BFu15ll_D_BFu7c { unsigned long long v1:15; double v2; unsigned char v3:7; };
struct BFu15ll_D_BFu7i { unsigned long long v1:15; double v2; unsigned int v3:7; };
struct BFu15ll_D_BFu7ll { unsigned long long v1:15; double v2; unsigned long long v3:7; };
struct BFu15ll_D_BFu7s { unsigned long long v1:15; double v2; unsigned short v3:7; };
struct BFu15ll_D_BFu8c { unsigned long long v1:15; double v2; unsigned char v3:8; };
struct BFu15ll_D_BFu8i { unsigned long long v1:15; double v2; unsigned int v3:8; };
struct BFu15ll_D_BFu8ll { unsigned long long v1:15; double v2; unsigned long long v3:8; };
struct BFu15ll_D_BFu8s { unsigned long long v1:15; double v2; unsigned short v3:8; };
struct BFu15ll_D_BFu9i { unsigned long long v1:15; double v2; unsigned int v3:9; };
struct BFu15ll_D_BFu9ll { unsigned long long v1:15; double v2; unsigned long long v3:9; };
struct BFu15ll_D_BFu9s { unsigned long long v1:15; double v2; unsigned short v3:9; };
struct BFu15ll_D_C { unsigned long long v1:15; double v2; char v3; };
struct BFu15ll_D_D { unsigned long long v1:15; double v2; double v3; };
struct BFu15ll_D_F { unsigned long long v1:15; double v2; float v3; };
struct BFu15ll_D_I { unsigned long long v1:15; double v2; int v3; };
struct BFu15ll_D_Ip { unsigned long long v1:15; double v2; int * v3; };
struct BFu15ll_D_L { unsigned long long v1:15; double v2; long long v3; };
struct BFu15ll_D_S { unsigned long long v1:15; double v2; short v3; };
struct BFu15ll_D_Uc { unsigned long long v1:15; double v2; unsigned char v3; };
struct BFu15ll_D_Ui { unsigned long long v1:15; double v2; unsigned int v3; };
struct BFu15ll_D_Ul { unsigned long long v1:15; double v2; unsigned long long v3; };
struct BFu15ll_D_Us { unsigned long long v1:15; double v2; unsigned short v3; };
struct BFu15ll_D_Vp { unsigned long long v1:15; double v2; void * v3; };
struct BFu15ll_F { unsigned long long v1:15; float v2; };
struct BFu15ll_F_BFu15i { unsigned long long v1:15; float v2; unsigned int v3:15; };
struct BFu15ll_F_BFu15ll { unsigned long long v1:15; float v2; unsigned long long v3:15; };
struct BFu15ll_F_BFu15s { unsigned long long v1:15; float v2; unsigned short v3:15; };
struct BFu15ll_F_BFu16i { unsigned long long v1:15; float v2; unsigned int v3:16; };
struct BFu15ll_F_BFu16ll { unsigned long long v1:15; float v2; unsigned long long v3:16; };
struct BFu15ll_F_BFu16s { unsigned long long v1:15; float v2; unsigned short v3:16; };
struct BFu15ll_F_BFu17i { unsigned long long v1:15; float v2; unsigned int v3:17; };
struct BFu15ll_F_BFu17ll { unsigned long long v1:15; float v2; unsigned long long v3:17; };
struct BFu15ll_F_BFu1c { unsigned long long v1:15; float v2; unsigned char v3:1; };
struct BFu15ll_F_BFu1i { unsigned long long v1:15; float v2; unsigned int v3:1; };
struct BFu15ll_F_BFu1ll { unsigned long long v1:15; float v2; unsigned long long v3:1; };
struct BFu15ll_F_BFu1s { unsigned long long v1:15; float v2; unsigned short v3:1; };
struct BFu15ll_F_BFu31i { unsigned long long v1:15; float v2; unsigned int v3:31; };
struct BFu15ll_F_BFu31ll { unsigned long long v1:15; float v2; unsigned long long v3:31; };
struct BFu15ll_F_BFu32i { unsigned long long v1:15; float v2; unsigned int v3:32; };
struct BFu15ll_F_BFu32ll { unsigned long long v1:15; float v2; unsigned long long v3:32; };
struct BFu15ll_F_BFu33 { unsigned long long v1:15; float v2; unsigned long long v3:33; };
struct BFu15ll_F_BFu7c { unsigned long long v1:15; float v2; unsigned char v3:7; };
struct BFu15ll_F_BFu7i { unsigned long long v1:15; float v2; unsigned int v3:7; };
struct BFu15ll_F_BFu7ll { unsigned long long v1:15; float v2; unsigned long long v3:7; };
struct BFu15ll_F_BFu7s { unsigned long long v1:15; float v2; unsigned short v3:7; };
struct BFu15ll_F_BFu8c { unsigned long long v1:15; float v2; unsigned char v3:8; };
struct BFu15ll_F_BFu8i { unsigned long long v1:15; float v2; unsigned int v3:8; };
struct BFu15ll_F_BFu8ll { unsigned long long v1:15; float v2; unsigned long long v3:8; };
struct BFu15ll_F_BFu8s { unsigned long long v1:15; float v2; unsigned short v3:8; };
struct BFu15ll_F_BFu9i { unsigned long long v1:15; float v2; unsigned int v3:9; };
struct BFu15ll_F_BFu9ll { unsigned long long v1:15; float v2; unsigned long long v3:9; };
struct BFu15ll_F_BFu9s { unsigned long long v1:15; float v2; unsigned short v3:9; };
struct BFu15ll_F_C { unsigned long long v1:15; float v2; char v3; };
struct BFu15ll_F_D { unsigned long long v1:15; float v2; double v3; };
struct BFu15ll_F_F { unsigned long long v1:15; float v2; float v3; };
struct BFu15ll_F_I { unsigned long long v1:15; float v2; int v3; };
struct BFu15ll_F_Ip { unsigned long long v1:15; float v2; int * v3; };
struct BFu15ll_F_L { unsigned long long v1:15; float v2; long long v3; };
struct BFu15ll_F_S { unsigned long long v1:15; float v2; short v3; };
struct BFu15ll_F_Uc { unsigned long long v1:15; float v2; unsigned char v3; };
struct BFu15ll_F_Ui { unsigned long long v1:15; float v2; unsigned int v3; };
struct BFu15ll_F_Ul { unsigned long long v1:15; float v2; unsigned long long v3; };
struct BFu15ll_F_Us { unsigned long long v1:15; float v2; unsigned short v3; };
struct BFu15ll_F_Vp { unsigned long long v1:15; float v2; void * v3; };
struct BFu15ll_I { unsigned long long v1:15; int v2; };
struct BFu15ll_I_BFu15i { unsigned long long v1:15; int v2; unsigned int v3:15; };
struct BFu15ll_I_BFu15ll { unsigned long long v1:15; int v2; unsigned long long v3:15; };
struct BFu15ll_I_BFu15s { unsigned long long v1:15; int v2; unsigned short v3:15; };
struct BFu15ll_I_BFu16i { unsigned long long v1:15; int v2; unsigned int v3:16; };
struct BFu15ll_I_BFu16ll { unsigned long long v1:15; int v2; unsigned long long v3:16; };
struct BFu15ll_I_BFu16s { unsigned long long v1:15; int v2; unsigned short v3:16; };
struct BFu15ll_I_BFu17i { unsigned long long v1:15; int v2; unsigned int v3:17; };
struct BFu15ll_I_BFu17ll { unsigned long long v1:15; int v2; unsigned long long v3:17; };
struct BFu15ll_I_BFu1c { unsigned long long v1:15; int v2; unsigned char v3:1; };
struct BFu15ll_I_BFu1i { unsigned long long v1:15; int v2; unsigned int v3:1; };
struct BFu15ll_I_BFu1ll { unsigned long long v1:15; int v2; unsigned long long v3:1; };
struct BFu15ll_I_BFu1s { unsigned long long v1:15; int v2; unsigned short v3:1; };
struct BFu15ll_I_BFu31i { unsigned long long v1:15; int v2; unsigned int v3:31; };
struct BFu15ll_I_BFu31ll { unsigned long long v1:15; int v2; unsigned long long v3:31; };
struct BFu15ll_I_BFu32i { unsigned long long v1:15; int v2; unsigned int v3:32; };
struct BFu15ll_I_BFu32ll { unsigned long long v1:15; int v2; unsigned long long v3:32; };
struct BFu15ll_I_BFu33 { unsigned long long v1:15; int v2; unsigned long long v3:33; };
struct BFu15ll_I_BFu7c { unsigned long long v1:15; int v2; unsigned char v3:7; };
struct BFu15ll_I_BFu7i { unsigned long long v1:15; int v2; unsigned int v3:7; };
struct BFu15ll_I_BFu7ll { unsigned long long v1:15; int v2; unsigned long long v3:7; };
struct BFu15ll_I_BFu7s { unsigned long long v1:15; int v2; unsigned short v3:7; };
struct BFu15ll_I_BFu8c { unsigned long long v1:15; int v2; unsigned char v3:8; };
struct BFu15ll_I_BFu8i { unsigned long long v1:15; int v2; unsigned int v3:8; };
struct BFu15ll_I_BFu8ll { unsigned long long v1:15; int v2; unsigned long long v3:8; };
struct BFu15ll_I_BFu8s { unsigned long long v1:15; int v2; unsigned short v3:8; };
struct BFu15ll_I_BFu9i { unsigned long long v1:15; int v2; unsigned int v3:9; };
struct BFu15ll_I_BFu9ll { unsigned long long v1:15; int v2; unsigned long long v3:9; };
struct BFu15ll_I_BFu9s { unsigned long long v1:15; int v2; unsigned short v3:9; };
struct BFu15ll_I_C { unsigned long long v1:15; int v2; char v3; };
struct BFu15ll_I_D { unsigned long long v1:15; int v2; double v3; };
struct BFu15ll_I_F { unsigned long long v1:15; int v2; float v3; };
struct BFu15ll_I_I { unsigned long long v1:15; int v2; int v3; };
struct BFu15ll_I_Ip { unsigned long long v1:15; int v2; int * v3; };
struct BFu15ll_I_L { unsigned long long v1:15; int v2; long long v3; };
struct BFu15ll_I_S { unsigned long long v1:15; int v2; short v3; };
struct BFu15ll_I_Uc { unsigned long long v1:15; int v2; unsigned char v3; };
struct BFu15ll_I_Ui { unsigned long long v1:15; int v2; unsigned int v3; };
struct BFu15ll_I_Ul { unsigned long long v1:15; int v2; unsigned long long v3; };
struct BFu15ll_I_Us { unsigned long long v1:15; int v2; unsigned short v3; };
struct BFu15ll_I_Vp { unsigned long long v1:15; int v2; void * v3; };
struct BFu15ll_Ip { unsigned long long v1:15; int * v2; };
struct BFu15ll_Ip_BFu15i { unsigned long long v1:15; int * v2; unsigned int v3:15; };
struct BFu15ll_Ip_BFu15ll { unsigned long long v1:15; int * v2; unsigned long long v3:15; };
struct BFu15ll_Ip_BFu15s { unsigned long long v1:15; int * v2; unsigned short v3:15; };
struct BFu15ll_Ip_BFu16i { unsigned long long v1:15; int * v2; unsigned int v3:16; };
struct BFu15ll_Ip_BFu16ll { unsigned long long v1:15; int * v2; unsigned long long v3:16; };
struct BFu15ll_Ip_BFu16s { unsigned long long v1:15; int * v2; unsigned short v3:16; };
struct BFu15ll_Ip_BFu17i { unsigned long long v1:15; int * v2; unsigned int v3:17; };
struct BFu15ll_Ip_BFu17ll { unsigned long long v1:15; int * v2; unsigned long long v3:17; };
struct BFu15ll_Ip_BFu1c { unsigned long long v1:15; int * v2; unsigned char v3:1; };
struct BFu15ll_Ip_BFu1i { unsigned long long v1:15; int * v2; unsigned int v3:1; };
struct BFu15ll_Ip_BFu1ll { unsigned long long v1:15; int * v2; unsigned long long v3:1; };
struct BFu15ll_Ip_BFu1s { unsigned long long v1:15; int * v2; unsigned short v3:1; };
struct BFu15ll_Ip_BFu31i { unsigned long long v1:15; int * v2; unsigned int v3:31; };
struct BFu15ll_Ip_BFu31ll { unsigned long long v1:15; int * v2; unsigned long long v3:31; };
struct BFu15ll_Ip_BFu32i { unsigned long long v1:15; int * v2; unsigned int v3:32; };
struct BFu15ll_Ip_BFu32ll { unsigned long long v1:15; int * v2; unsigned long long v3:32; };
struct BFu15ll_Ip_BFu33 { unsigned long long v1:15; int * v2; unsigned long long v3:33; };
struct BFu15ll_Ip_BFu7c { unsigned long long v1:15; int * v2; unsigned char v3:7; };
struct BFu15ll_Ip_BFu7i { unsigned long long v1:15; int * v2; unsigned int v3:7; };
struct BFu15ll_Ip_BFu7ll { unsigned long long v1:15; int * v2; unsigned long long v3:7; };
struct BFu15ll_Ip_BFu7s { unsigned long long v1:15; int * v2; unsigned short v3:7; };
struct BFu15ll_Ip_BFu8c { unsigned long long v1:15; int * v2; unsigned char v3:8; };
struct BFu15ll_Ip_BFu8i { unsigned long long v1:15; int * v2; unsigned int v3:8; };
struct BFu15ll_Ip_BFu8ll { unsigned long long v1:15; int * v2; unsigned long long v3:8; };
struct BFu15ll_Ip_BFu8s { unsigned long long v1:15; int * v2; unsigned short v3:8; };
struct BFu15ll_Ip_BFu9i { unsigned long long v1:15; int * v2; unsigned int v3:9; };
struct BFu15ll_Ip_BFu9ll { unsigned long long v1:15; int * v2; unsigned long long v3:9; };
struct BFu15ll_Ip_BFu9s { unsigned long long v1:15; int * v2; unsigned short v3:9; };
struct BFu15ll_Ip_C { unsigned long long v1:15; int * v2; char v3; };
struct BFu15ll_Ip_D { unsigned long long v1:15; int * v2; double v3; };
struct BFu15ll_Ip_F { unsigned long long v1:15; int * v2; float v3; };
struct BFu15ll_Ip_I { unsigned long long v1:15; int * v2; int v3; };
struct BFu15ll_Ip_Ip { unsigned long long v1:15; int * v2; int * v3; };
struct BFu15ll_Ip_L { unsigned long long v1:15; int * v2; long long v3; };
struct BFu15ll_Ip_S { unsigned long long v1:15; int * v2; short v3; };
struct BFu15ll_Ip_Uc { unsigned long long v1:15; int * v2; unsigned char v3; };
struct BFu15ll_Ip_Ui { unsigned long long v1:15; int * v2; unsigned int v3; };
struct BFu15ll_Ip_Ul { unsigned long long v1:15; int * v2; unsigned long long v3; };
struct BFu15ll_Ip_Us { unsigned long long v1:15; int * v2; unsigned short v3; };
struct BFu15ll_Ip_Vp { unsigned long long v1:15; int * v2; void * v3; };
struct BFu15ll_L { unsigned long long v1:15; long long v2; };
struct BFu15ll_L_BFu15i { unsigned long long v1:15; long long v2; unsigned int v3:15; };
struct BFu15ll_L_BFu15ll { unsigned long long v1:15; long long v2; unsigned long long v3:15; };
struct BFu15ll_L_BFu15s { unsigned long long v1:15; long long v2; unsigned short v3:15; };
struct BFu15ll_L_BFu16i { unsigned long long v1:15; long long v2; unsigned int v3:16; };
struct BFu15ll_L_BFu16ll { unsigned long long v1:15; long long v2; unsigned long long v3:16; };
struct BFu15ll_L_BFu16s { unsigned long long v1:15; long long v2; unsigned short v3:16; };
struct BFu15ll_L_BFu17i { unsigned long long v1:15; long long v2; unsigned int v3:17; };
struct BFu15ll_L_BFu17ll { unsigned long long v1:15; long long v2; unsigned long long v3:17; };
struct BFu15ll_L_BFu1c { unsigned long long v1:15; long long v2; unsigned char v3:1; };
struct BFu15ll_L_BFu1i { unsigned long long v1:15; long long v2; unsigned int v3:1; };
struct BFu15ll_L_BFu1ll { unsigned long long v1:15; long long v2; unsigned long long v3:1; };
struct BFu15ll_L_BFu1s { unsigned long long v1:15; long long v2; unsigned short v3:1; };
struct BFu15ll_L_BFu31i { unsigned long long v1:15; long long v2; unsigned int v3:31; };
struct BFu15ll_L_BFu31ll { unsigned long long v1:15; long long v2; unsigned long long v3:31; };
struct BFu15ll_L_BFu32i { unsigned long long v1:15; long long v2; unsigned int v3:32; };
struct BFu15ll_L_BFu32ll { unsigned long long v1:15; long long v2; unsigned long long v3:32; };
struct BFu15ll_L_BFu33 { unsigned long long v1:15; long long v2; unsigned long long v3:33; };
struct BFu15ll_L_BFu7c { unsigned long long v1:15; long long v2; unsigned char v3:7; };
struct BFu15ll_L_BFu7i { unsigned long long v1:15; long long v2; unsigned int v3:7; };
struct BFu15ll_L_BFu7ll { unsigned long long v1:15; long long v2; unsigned long long v3:7; };
struct BFu15ll_L_BFu7s { unsigned long long v1:15; long long v2; unsigned short v3:7; };
struct BFu15ll_L_BFu8c { unsigned long long v1:15; long long v2; unsigned char v3:8; };
struct BFu15ll_L_BFu8i { unsigned long long v1:15; long long v2; unsigned int v3:8; };
struct BFu15ll_L_BFu8ll { unsigned long long v1:15; long long v2; unsigned long long v3:8; };
struct BFu15ll_L_BFu8s { unsigned long long v1:15; long long v2; unsigned short v3:8; };
struct BFu15ll_L_BFu9i { unsigned long long v1:15; long long v2; unsigned int v3:9; };
struct BFu15ll_L_BFu9ll { unsigned long long v1:15; long long v2; unsigned long long v3:9; };
struct BFu15ll_L_BFu9s { unsigned long long v1:15; long long v2; unsigned short v3:9; };
struct BFu15ll_L_C { unsigned long long v1:15; long long v2; char v3; };
struct BFu15ll_L_D { unsigned long long v1:15; long long v2; double v3; };
struct BFu15ll_L_F { unsigned long long v1:15; long long v2; float v3; };
struct BFu15ll_L_I { unsigned long long v1:15; long long v2; int v3; };
struct BFu15ll_L_Ip { unsigned long long v1:15; long long v2; int * v3; };
struct BFu15ll_L_L { unsigned long long v1:15; long long v2; long long v3; };
struct BFu15ll_L_S { unsigned long long v1:15; long long v2; short v3; };
struct BFu15ll_L_Uc { unsigned long long v1:15; long long v2; unsigned char v3; };
struct BFu15ll_L_Ui { unsigned long long v1:15; long long v2; unsigned int v3; };
struct BFu15ll_L_Ul { unsigned long long v1:15; long long v2; unsigned long long v3; };
struct BFu15ll_L_Us { unsigned long long v1:15; long long v2; unsigned short v3; };
struct BFu15ll_L_Vp { unsigned long long v1:15; long long v2; void * v3; };
struct BFu15ll_S { unsigned long long v1:15; short v2; };
struct BFu15ll_S_BFu15i { unsigned long long v1:15; short v2; unsigned int v3:15; };
struct BFu15ll_S_BFu15ll { unsigned long long v1:15; short v2; unsigned long long v3:15; };
struct BFu15ll_S_BFu15s { unsigned long long v1:15; short v2; unsigned short v3:15; };
struct BFu15ll_S_BFu16i { unsigned long long v1:15; short v2; unsigned int v3:16; };
struct BFu15ll_S_BFu16ll { unsigned long long v1:15; short v2; unsigned long long v3:16; };
struct BFu15ll_S_BFu16s { unsigned long long v1:15; short v2; unsigned short v3:16; };
struct BFu15ll_S_BFu17i { unsigned long long v1:15; short v2; unsigned int v3:17; };
struct BFu15ll_S_BFu17ll { unsigned long long v1:15; short v2; unsigned long long v3:17; };
struct BFu15ll_S_BFu1c { unsigned long long v1:15; short v2; unsigned char v3:1; };
struct BFu15ll_S_BFu1i { unsigned long long v1:15; short v2; unsigned int v3:1; };
struct BFu15ll_S_BFu1ll { unsigned long long v1:15; short v2; unsigned long long v3:1; };
struct BFu15ll_S_BFu1s { unsigned long long v1:15; short v2; unsigned short v3:1; };
struct BFu15ll_S_BFu31i { unsigned long long v1:15; short v2; unsigned int v3:31; };
struct BFu15ll_S_BFu31ll { unsigned long long v1:15; short v2; unsigned long long v3:31; };
struct BFu15ll_S_BFu32i { unsigned long long v1:15; short v2; unsigned int v3:32; };
struct BFu15ll_S_BFu32ll { unsigned long long v1:15; short v2; unsigned long long v3:32; };
struct BFu15ll_S_BFu33 { unsigned long long v1:15; short v2; unsigned long long v3:33; };
struct BFu15ll_S_BFu7c { unsigned long long v1:15; short v2; unsigned char v3:7; };
struct BFu15ll_S_BFu7i { unsigned long long v1:15; short v2; unsigned int v3:7; };
struct BFu15ll_S_BFu7ll { unsigned long long v1:15; short v2; unsigned long long v3:7; };
struct BFu15ll_S_BFu7s { unsigned long long v1:15; short v2; unsigned short v3:7; };
struct BFu15ll_S_BFu8c { unsigned long long v1:15; short v2; unsigned char v3:8; };
struct BFu15ll_S_BFu8i { unsigned long long v1:15; short v2; unsigned int v3:8; };
struct BFu15ll_S_BFu8ll { unsigned long long v1:15; short v2; unsigned long long v3:8; };
struct BFu15ll_S_BFu8s { unsigned long long v1:15; short v2; unsigned short v3:8; };
struct BFu15ll_S_BFu9i { unsigned long long v1:15; short v2; unsigned int v3:9; };
struct BFu15ll_S_BFu9ll { unsigned long long v1:15; short v2; unsigned long long v3:9; };
struct BFu15ll_S_BFu9s { unsigned long long v1:15; short v2; unsigned short v3:9; };
struct BFu15ll_S_C { unsigned long long v1:15; short v2; char v3; };
struct BFu15ll_S_D { unsigned long long v1:15; short v2; double v3; };
struct BFu15ll_S_F { unsigned long long v1:15; short v2; float v3; };
struct BFu15ll_S_I { unsigned long long v1:15; short v2; int v3; };
struct BFu15ll_S_Ip { unsigned long long v1:15; short v2; int * v3; };
struct BFu15ll_S_L { unsigned long long v1:15; short v2; long long v3; };
struct BFu15ll_S_S { unsigned long long v1:15; short v2; short v3; };
struct BFu15ll_S_Uc { unsigned long long v1:15; short v2; unsigned char v3; };
struct BFu15ll_S_Ui { unsigned long long v1:15; short v2; unsigned int v3; };
struct BFu15ll_S_Ul { unsigned long long v1:15; short v2; unsigned long long v3; };
struct BFu15ll_S_Us { unsigned long long v1:15; short v2; unsigned short v3; };
struct BFu15ll_S_Vp { unsigned long long v1:15; short v2; void * v3; };
struct BFu15ll_Uc { unsigned long long v1:15; unsigned char v2; };
struct BFu15ll_Uc_BFu15i { unsigned long long v1:15; unsigned char v2; unsigned int v3:15; };
struct BFu15ll_Uc_BFu15ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:15; };
struct BFu15ll_Uc_BFu15s { unsigned long long v1:15; unsigned char v2; unsigned short v3:15; };
struct BFu15ll_Uc_BFu16i { unsigned long long v1:15; unsigned char v2; unsigned int v3:16; };
struct BFu15ll_Uc_BFu16ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:16; };
struct BFu15ll_Uc_BFu16s { unsigned long long v1:15; unsigned char v2; unsigned short v3:16; };
struct BFu15ll_Uc_BFu17i { unsigned long long v1:15; unsigned char v2; unsigned int v3:17; };
struct BFu15ll_Uc_BFu17ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:17; };
struct BFu15ll_Uc_BFu1c { unsigned long long v1:15; unsigned char v2; unsigned char v3:1; };
struct BFu15ll_Uc_BFu1i { unsigned long long v1:15; unsigned char v2; unsigned int v3:1; };
struct BFu15ll_Uc_BFu1ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:1; };
struct BFu15ll_Uc_BFu1s { unsigned long long v1:15; unsigned char v2; unsigned short v3:1; };
struct BFu15ll_Uc_BFu31i { unsigned long long v1:15; unsigned char v2; unsigned int v3:31; };
struct BFu15ll_Uc_BFu31ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:31; };
struct BFu15ll_Uc_BFu32i { unsigned long long v1:15; unsigned char v2; unsigned int v3:32; };
struct BFu15ll_Uc_BFu32ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:32; };
struct BFu15ll_Uc_BFu33 { unsigned long long v1:15; unsigned char v2; unsigned long long v3:33; };
struct BFu15ll_Uc_BFu7c { unsigned long long v1:15; unsigned char v2; unsigned char v3:7; };
struct BFu15ll_Uc_BFu7i { unsigned long long v1:15; unsigned char v2; unsigned int v3:7; };
struct BFu15ll_Uc_BFu7ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:7; };
struct BFu15ll_Uc_BFu7s { unsigned long long v1:15; unsigned char v2; unsigned short v3:7; };
struct BFu15ll_Uc_BFu8c { unsigned long long v1:15; unsigned char v2; unsigned char v3:8; };
struct BFu15ll_Uc_BFu8i { unsigned long long v1:15; unsigned char v2; unsigned int v3:8; };
struct BFu15ll_Uc_BFu8ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:8; };
struct BFu15ll_Uc_BFu8s { unsigned long long v1:15; unsigned char v2; unsigned short v3:8; };
struct BFu15ll_Uc_BFu9i { unsigned long long v1:15; unsigned char v2; unsigned int v3:9; };
struct BFu15ll_Uc_BFu9ll { unsigned long long v1:15; unsigned char v2; unsigned long long v3:9; };
struct BFu15ll_Uc_BFu9s { unsigned long long v1:15; unsigned char v2; unsigned short v3:9; };
struct BFu15ll_Uc_C { unsigned long long v1:15; unsigned char v2; char v3; };
struct BFu15ll_Uc_D { unsigned long long v1:15; unsigned char v2; double v3; };
struct BFu15ll_Uc_F { unsigned long long v1:15; unsigned char v2; float v3; };
struct BFu15ll_Uc_I { unsigned long long v1:15; unsigned char v2; int v3; };
struct BFu15ll_Uc_Ip { unsigned long long v1:15; unsigned char v2; int * v3; };
struct BFu15ll_Uc_L { unsigned long long v1:15; unsigned char v2; long long v3; };
struct BFu15ll_Uc_S { unsigned long long v1:15; unsigned char v2; short v3; };
struct BFu15ll_Uc_Uc { unsigned long long v1:15; unsigned char v2; unsigned char v3; };
struct BFu15ll_Uc_Ui { unsigned long long v1:15; unsigned char v2; unsigned int v3; };
struct BFu15ll_Uc_Ul { unsigned long long v1:15; unsigned char v2; unsigned long long v3; };
struct BFu15ll_Uc_Us { unsigned long long v1:15; unsigned char v2; unsigned short v3; };
struct BFu15ll_Uc_Vp { unsigned long long v1:15; unsigned char v2; void * v3; };
struct BFu15ll_Ui { unsigned long long v1:15; unsigned int v2; };
struct BFu15ll_Ui_BFu15i { unsigned long long v1:15; unsigned int v2; unsigned int v3:15; };
struct BFu15ll_Ui_BFu15ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:15; };
struct BFu15ll_Ui_BFu15s { unsigned long long v1:15; unsigned int v2; unsigned short v3:15; };
struct BFu15ll_Ui_BFu16i { unsigned long long v1:15; unsigned int v2; unsigned int v3:16; };
struct BFu15ll_Ui_BFu16ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:16; };
struct BFu15ll_Ui_BFu16s { unsigned long long v1:15; unsigned int v2; unsigned short v3:16; };
struct BFu15ll_Ui_BFu17i { unsigned long long v1:15; unsigned int v2; unsigned int v3:17; };
struct BFu15ll_Ui_BFu17ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:17; };
struct BFu15ll_Ui_BFu1c { unsigned long long v1:15; unsigned int v2; unsigned char v3:1; };
struct BFu15ll_Ui_BFu1i { unsigned long long v1:15; unsigned int v2; unsigned int v3:1; };
struct BFu15ll_Ui_BFu1ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:1; };
struct BFu15ll_Ui_BFu1s { unsigned long long v1:15; unsigned int v2; unsigned short v3:1; };
struct BFu15ll_Ui_BFu31i { unsigned long long v1:15; unsigned int v2; unsigned int v3:31; };
struct BFu15ll_Ui_BFu31ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:31; };
struct BFu15ll_Ui_BFu32i { unsigned long long v1:15; unsigned int v2; unsigned int v3:32; };
struct BFu15ll_Ui_BFu32ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:32; };
struct BFu15ll_Ui_BFu33 { unsigned long long v1:15; unsigned int v2; unsigned long long v3:33; };
struct BFu15ll_Ui_BFu7c { unsigned long long v1:15; unsigned int v2; unsigned char v3:7; };
struct BFu15ll_Ui_BFu7i { unsigned long long v1:15; unsigned int v2; unsigned int v3:7; };
struct BFu15ll_Ui_BFu7ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:7; };
struct BFu15ll_Ui_BFu7s { unsigned long long v1:15; unsigned int v2; unsigned short v3:7; };
struct BFu15ll_Ui_BFu8c { unsigned long long v1:15; unsigned int v2; unsigned char v3:8; };
struct BFu15ll_Ui_BFu8i { unsigned long long v1:15; unsigned int v2; unsigned int v3:8; };
struct BFu15ll_Ui_BFu8ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:8; };
struct BFu15ll_Ui_BFu8s { unsigned long long v1:15; unsigned int v2; unsigned short v3:8; };
struct BFu15ll_Ui_BFu9i { unsigned long long v1:15; unsigned int v2; unsigned int v3:9; };
struct BFu15ll_Ui_BFu9ll { unsigned long long v1:15; unsigned int v2; unsigned long long v3:9; };
struct BFu15ll_Ui_BFu9s { unsigned long long v1:15; unsigned int v2; unsigned short v3:9; };
struct BFu15ll_Ui_C { unsigned long long v1:15; unsigned int v2; char v3; };
struct BFu15ll_Ui_D { unsigned long long v1:15; unsigned int v2; double v3; };
struct BFu15ll_Ui_F { unsigned long long v1:15; unsigned int v2; float v3; };
struct BFu15ll_Ui_I { unsigned long long v1:15; unsigned int v2; int v3; };
struct BFu15ll_Ui_Ip { unsigned long long v1:15; unsigned int v2; int * v3; };
struct BFu15ll_Ui_L { unsigned long long v1:15; unsigned int v2; long long v3; };
struct BFu15ll_Ui_S { unsigned long long v1:15; unsigned int v2; short v3; };
struct BFu15ll_Ui_Uc { unsigned long long v1:15; unsigned int v2; unsigned char v3; };
struct BFu15ll_Ui_Ui { unsigned long long v1:15; unsigned int v2; unsigned int v3; };
struct BFu15ll_Ui_Ul { unsigned long long v1:15; unsigned int v2; unsigned long long v3; };
struct BFu15ll_Ui_Us { unsigned long long v1:15; unsigned int v2; unsigned short v3; };
struct BFu15ll_Ui_Vp { unsigned long long v1:15; unsigned int v2; void * v3; };
struct BFu15ll_Ul { unsigned long long v1:15; unsigned long long v2; };
struct BFu15ll_Ul_BFu15i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:15; };
struct BFu15ll_Ul_BFu15ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:15; };
struct BFu15ll_Ul_BFu15s { unsigned long long v1:15; unsigned long long v2; unsigned short v3:15; };
struct BFu15ll_Ul_BFu16i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:16; };
struct BFu15ll_Ul_BFu16ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:16; };
struct BFu15ll_Ul_BFu16s { unsigned long long v1:15; unsigned long long v2; unsigned short v3:16; };
struct BFu15ll_Ul_BFu17i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:17; };
struct BFu15ll_Ul_BFu17ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:17; };
struct BFu15ll_Ul_BFu1c { unsigned long long v1:15; unsigned long long v2; unsigned char v3:1; };
struct BFu15ll_Ul_BFu1i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:1; };
struct BFu15ll_Ul_BFu1ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:1; };
struct BFu15ll_Ul_BFu1s { unsigned long long v1:15; unsigned long long v2; unsigned short v3:1; };
struct BFu15ll_Ul_BFu31i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:31; };
struct BFu15ll_Ul_BFu31ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:31; };
struct BFu15ll_Ul_BFu32i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:32; };
struct BFu15ll_Ul_BFu32ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:32; };
struct BFu15ll_Ul_BFu33 { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:33; };
struct BFu15ll_Ul_BFu7c { unsigned long long v1:15; unsigned long long v2; unsigned char v3:7; };
struct BFu15ll_Ul_BFu7i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:7; };
struct BFu15ll_Ul_BFu7ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:7; };
struct BFu15ll_Ul_BFu7s { unsigned long long v1:15; unsigned long long v2; unsigned short v3:7; };
struct BFu15ll_Ul_BFu8c { unsigned long long v1:15; unsigned long long v2; unsigned char v3:8; };
struct BFu15ll_Ul_BFu8i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:8; };
struct BFu15ll_Ul_BFu8ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:8; };
struct BFu15ll_Ul_BFu8s { unsigned long long v1:15; unsigned long long v2; unsigned short v3:8; };
struct BFu15ll_Ul_BFu9i { unsigned long long v1:15; unsigned long long v2; unsigned int v3:9; };
struct BFu15ll_Ul_BFu9ll { unsigned long long v1:15; unsigned long long v2; unsigned long long v3:9; };
struct BFu15ll_Ul_BFu9s { unsigned long long v1:15; unsigned long long v2; unsigned short v3:9; };
struct BFu15ll_Ul_C { unsigned long long v1:15; unsigned long long v2; char v3; };
struct BFu15ll_Ul_D { unsigned long long v1:15; unsigned long long v2; double v3; };
struct BFu15ll_Ul_F { unsigned long long v1:15; unsigned long long v2; float v3; };
struct BFu15ll_Ul_I { unsigned long long v1:15; unsigned long long v2; int v3; };
struct BFu15ll_Ul_Ip { unsigned long long v1:15; unsigned long long v2; int * v3; };
struct BFu15ll_Ul_L { unsigned long long v1:15; unsigned long long v2; long long v3; };
struct BFu15ll_Ul_S { unsigned long long v1:15; unsigned long long v2; short v3; };
struct BFu15ll_Ul_Uc { unsigned long long v1:15; unsigned long long v2; unsigned char v3; };
struct BFu15ll_Ul_Ui { unsigned long long v1:15; unsigned long long v2; unsigned int v3; };
struct BFu15ll_Ul_Ul { unsigned long long v1:15; unsigned long long v2; unsigned long long v3; };
struct BFu15ll_Ul_Us { unsigned long long v1:15; unsigned long long v2; unsigned short v3; };
struct BFu15ll_Ul_Vp { unsigned long long v1:15; unsigned long long v2; void * v3; };
struct BFu15ll_Us { unsigned long long v1:15; unsigned short v2; };
struct BFu15ll_Us_BFu15i { unsigned long long v1:15; unsigned short v2; unsigned int v3:15; };
struct BFu15ll_Us_BFu15ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:15; };
struct BFu15ll_Us_BFu15s { unsigned long long v1:15; unsigned short v2; unsigned short v3:15; };
struct BFu15ll_Us_BFu16i { unsigned long long v1:15; unsigned short v2; unsigned int v3:16; };
struct BFu15ll_Us_BFu16ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:16; };
struct BFu15ll_Us_BFu16s { unsigned long long v1:15; unsigned short v2; unsigned short v3:16; };
struct BFu15ll_Us_BFu17i { unsigned long long v1:15; unsigned short v2; unsigned int v3:17; };
struct BFu15ll_Us_BFu17ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:17; };
struct BFu15ll_Us_BFu1c { unsigned long long v1:15; unsigned short v2; unsigned char v3:1; };
struct BFu15ll_Us_BFu1i { unsigned long long v1:15; unsigned short v2; unsigned int v3:1; };
struct BFu15ll_Us_BFu1ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:1; };
struct BFu15ll_Us_BFu1s { unsigned long long v1:15; unsigned short v2; unsigned short v3:1; };
struct BFu15ll_Us_BFu31i { unsigned long long v1:15; unsigned short v2; unsigned int v3:31; };
struct BFu15ll_Us_BFu31ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:31; };
struct BFu15ll_Us_BFu32i { unsigned long long v1:15; unsigned short v2; unsigned int v3:32; };
struct BFu15ll_Us_BFu32ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:32; };
struct BFu15ll_Us_BFu33 { unsigned long long v1:15; unsigned short v2; unsigned long long v3:33; };
struct BFu15ll_Us_BFu7c { unsigned long long v1:15; unsigned short v2; unsigned char v3:7; };
struct BFu15ll_Us_BFu7i { unsigned long long v1:15; unsigned short v2; unsigned int v3:7; };
struct BFu15ll_Us_BFu7ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:7; };
struct BFu15ll_Us_BFu7s { unsigned long long v1:15; unsigned short v2; unsigned short v3:7; };
struct BFu15ll_Us_BFu8c { unsigned long long v1:15; unsigned short v2; unsigned char v3:8; };
struct BFu15ll_Us_BFu8i { unsigned long long v1:15; unsigned short v2; unsigned int v3:8; };
struct BFu15ll_Us_BFu8ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:8; };
struct BFu15ll_Us_BFu8s { unsigned long long v1:15; unsigned short v2; unsigned short v3:8; };
struct BFu15ll_Us_BFu9i { unsigned long long v1:15; unsigned short v2; unsigned int v3:9; };
struct BFu15ll_Us_BFu9ll { unsigned long long v1:15; unsigned short v2; unsigned long long v3:9; };
struct BFu15ll_Us_BFu9s { unsigned long long v1:15; unsigned short v2; unsigned short v3:9; };
struct BFu15ll_Us_C { unsigned long long v1:15; unsigned short v2; char v3; };
struct BFu15ll_Us_D { unsigned long long v1:15; unsigned short v2; double v3; };
struct BFu15ll_Us_F { unsigned long long v1:15; unsigned short v2; float v3; };
struct BFu15ll_Us_I { unsigned long long v1:15; unsigned short v2; int v3; };
struct BFu15ll_Us_Ip { unsigned long long v1:15; unsigned short v2; int * v3; };
struct BFu15ll_Us_L { unsigned long long v1:15; unsigned short v2; long long v3; };
struct BFu15ll_Us_S { unsigned long long v1:15; unsigned short v2; short v3; };
struct BFu15ll_Us_Uc { unsigned long long v1:15; unsigned short v2; unsigned char v3; };
struct BFu15ll_Us_Ui { unsigned long long v1:15; unsigned short v2; unsigned int v3; };
struct BFu15ll_Us_Ul { unsigned long long v1:15; unsigned short v2; unsigned long long v3; };
struct BFu15ll_Us_Us { unsigned long long v1:15; unsigned short v2; unsigned short v3; };
struct BFu15ll_Us_Vp { unsigned long long v1:15; unsigned short v2; void * v3; };
struct BFu15ll_Vp { unsigned long long v1:15; void * v2; };
struct BFu15ll_Vp_BFu15i { unsigned long long v1:15; void * v2; unsigned int v3:15; };
struct BFu15ll_Vp_BFu15ll { unsigned long long v1:15; void * v2; unsigned long long v3:15; };
struct BFu15ll_Vp_BFu15s { unsigned long long v1:15; void * v2; unsigned short v3:15; };
struct BFu15ll_Vp_BFu16i { unsigned long long v1:15; void * v2; unsigned int v3:16; };
struct BFu15ll_Vp_BFu16ll { unsigned long long v1:15; void * v2; unsigned long long v3:16; };
struct BFu15ll_Vp_BFu16s { unsigned long long v1:15; void * v2; unsigned short v3:16; };
struct BFu15ll_Vp_BFu17i { unsigned long long v1:15; void * v2; unsigned int v3:17; };
struct BFu15ll_Vp_BFu17ll { unsigned long long v1:15; void * v2; unsigned long long v3:17; };
struct BFu15ll_Vp_BFu1c { unsigned long long v1:15; void * v2; unsigned char v3:1; };
struct BFu15ll_Vp_BFu1i { unsigned long long v1:15; void * v2; unsigned int v3:1; };
struct BFu15ll_Vp_BFu1ll { unsigned long long v1:15; void * v2; unsigned long long v3:1; };
struct BFu15ll_Vp_BFu1s { unsigned long long v1:15; void * v2; unsigned short v3:1; };
struct BFu15ll_Vp_BFu31i { unsigned long long v1:15; void * v2; unsigned int v3:31; };
struct BFu15ll_Vp_BFu31ll { unsigned long long v1:15; void * v2; unsigned long long v3:31; };
struct BFu15ll_Vp_BFu32i { unsigned long long v1:15; void * v2; unsigned int v3:32; };
struct BFu15ll_Vp_BFu32ll { unsigned long long v1:15; void * v2; unsigned long long v3:32; };
struct BFu15ll_Vp_BFu33 { unsigned long long v1:15; void * v2; unsigned long long v3:33; };
struct BFu15ll_Vp_BFu7c { unsigned long long v1:15; void * v2; unsigned char v3:7; };
struct BFu15ll_Vp_BFu7i { unsigned long long v1:15; void * v2; unsigned int v3:7; };
struct BFu15ll_Vp_BFu7ll { unsigned long long v1:15; void * v2; unsigned long long v3:7; };
struct BFu15ll_Vp_BFu7s { unsigned long long v1:15; void * v2; unsigned short v3:7; };
struct BFu15ll_Vp_BFu8c { unsigned long long v1:15; void * v2; unsigned char v3:8; };
struct BFu15ll_Vp_BFu8i { unsigned long long v1:15; void * v2; unsigned int v3:8; };
struct BFu15ll_Vp_BFu8ll { unsigned long long v1:15; void * v2; unsigned long long v3:8; };
struct BFu15ll_Vp_BFu8s { unsigned long long v1:15; void * v2; unsigned short v3:8; };
struct BFu15ll_Vp_BFu9i { unsigned long long v1:15; void * v2; unsigned int v3:9; };
struct BFu15ll_Vp_BFu9ll { unsigned long long v1:15; void * v2; unsigned long long v3:9; };
struct BFu15ll_Vp_BFu9s { unsigned long long v1:15; void * v2; unsigned short v3:9; };
struct BFu15ll_Vp_C { unsigned long long v1:15; void * v2; char v3; };
struct BFu15ll_Vp_D { unsigned long long v1:15; void * v2; double v3; };
struct BFu15ll_Vp_F { unsigned long long v1:15; void * v2; float v3; };
struct BFu15ll_Vp_I { unsigned long long v1:15; void * v2; int v3; };
struct BFu15ll_Vp_Ip { unsigned long long v1:15; void * v2; int * v3; };
struct BFu15ll_Vp_L { unsigned long long v1:15; void * v2; long long v3; };
struct BFu15ll_Vp_S { unsigned long long v1:15; void * v2; short v3; };
struct BFu15ll_Vp_Uc { unsigned long long v1:15; void * v2; unsigned char v3; };
struct BFu15ll_Vp_Ui { unsigned long long v1:15; void * v2; unsigned int v3; };
struct BFu15ll_Vp_Ul { unsigned long long v1:15; void * v2; unsigned long long v3; };
struct BFu15ll_Vp_Us { unsigned long long v1:15; void * v2; unsigned short v3; };
struct BFu15ll_Vp_Vp { unsigned long long v1:15; void * v2; void * v3; };
struct BFu15s { unsigned short v1:15; };
struct BFu15s_BFs15i { unsigned short v1:15; signed int v2:15; };
struct BFu15s_BFs15i_BFs15i { unsigned short v1:15; signed int v2:15; signed int v3:15; };
struct BFu15s_BFs15i_BFs15i_BFs15i { unsigned short v1:15; signed int v2:15; signed int v3:15; signed int v4:15; };
struct BFu15s_BFs15i_BFs15i_BFs15ll { unsigned short v1:15; signed int v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15s_BFs15i_BFs15i_BFs15s { unsigned short v1:15; signed int v2:15; signed int v3:15; signed short v4:15; };
struct BFu15s_BFs15i_BFs15i_BFu15i { unsigned short v1:15; signed int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15s_BFs15i_BFs15i_BFu15ll { unsigned short v1:15; signed int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15i_BFs15i_BFu15s { unsigned short v1:15; signed int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15s_BFs15i_BFs15ll { unsigned short v1:15; signed int v2:15; signed long long v3:15; };
struct BFu15s_BFs15i_BFs15ll_BFs15i { unsigned short v1:15; signed int v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15s_BFs15i_BFs15ll_BFs15ll { unsigned short v1:15; signed int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15s_BFs15i_BFs15ll_BFs15s { unsigned short v1:15; signed int v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15s_BFs15i_BFs15ll_BFu15i { unsigned short v1:15; signed int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15s_BFs15i_BFs15ll_BFu15ll { unsigned short v1:15; signed int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15i_BFs15ll_BFu15s { unsigned short v1:15; signed int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15s_BFs15i_BFs15s { unsigned short v1:15; signed int v2:15; signed short v3:15; };
struct BFu15s_BFs15i_BFs15s_BFs15i { unsigned short v1:15; signed int v2:15; signed short v3:15; signed int v4:15; };
struct BFu15s_BFs15i_BFs15s_BFs15ll { unsigned short v1:15; signed int v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15s_BFs15i_BFs15s_BFs15s { unsigned short v1:15; signed int v2:15; signed short v3:15; signed short v4:15; };
struct BFu15s_BFs15i_BFs15s_BFu15i { unsigned short v1:15; signed int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15s_BFs15i_BFs15s_BFu15ll { unsigned short v1:15; signed int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15i_BFs15s_BFu15s { unsigned short v1:15; signed int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15s_BFs15i_BFu15i { unsigned short v1:15; signed int v2:15; unsigned int v3:15; };
struct BFu15s_BFs15i_BFu15i_BFs15i { unsigned short v1:15; signed int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15s_BFs15i_BFu15i_BFs15ll { unsigned short v1:15; signed int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15s_BFs15i_BFu15i_BFs15s { unsigned short v1:15; signed int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15s_BFs15i_BFu15i_BFu15i { unsigned short v1:15; signed int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15s_BFs15i_BFu15i_BFu15ll { unsigned short v1:15; signed int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15i_BFu15i_BFu15s { unsigned short v1:15; signed int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15s_BFs15i_BFu15ll { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; };
struct BFu15s_BFs15i_BFu15ll_BFs15i { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15s_BFs15i_BFu15ll_BFs15ll { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15s_BFs15i_BFu15ll_BFs15s { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15s_BFs15i_BFu15ll_BFu15i { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15s_BFs15i_BFu15ll_BFu15ll { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15i_BFu15ll_BFu15s { unsigned short v1:15; signed int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15s_BFs15i_BFu15s { unsigned short v1:15; signed int v2:15; unsigned short v3:15; };
struct BFu15s_BFs15i_BFu15s_BFs15i { unsigned short v1:15; signed int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15s_BFs15i_BFu15s_BFs15ll { unsigned short v1:15; signed int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15s_BFs15i_BFu15s_BFs15s { unsigned short v1:15; signed int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15s_BFs15i_BFu15s_BFu15i { unsigned short v1:15; signed int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15s_BFs15i_BFu15s_BFu15ll { unsigned short v1:15; signed int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15i_BFu15s_BFu15s { unsigned short v1:15; signed int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15s_BFs15ll { unsigned short v1:15; signed long long v2:15; };
struct BFu15s_BFs15ll_BFs15i { unsigned short v1:15; signed long long v2:15; signed int v3:15; };
struct BFu15s_BFs15ll_BFs15i_BFs15i { unsigned short v1:15; signed long long v2:15; signed int v3:15; signed int v4:15; };
struct BFu15s_BFs15ll_BFs15i_BFs15ll { unsigned short v1:15; signed long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15s_BFs15ll_BFs15i_BFs15s { unsigned short v1:15; signed long long v2:15; signed int v3:15; signed short v4:15; };
struct BFu15s_BFs15ll_BFs15i_BFu15i { unsigned short v1:15; signed long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15s_BFs15ll_BFs15i_BFu15ll { unsigned short v1:15; signed long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15ll_BFs15i_BFu15s { unsigned short v1:15; signed long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15s_BFs15ll_BFs15ll { unsigned short v1:15; signed long long v2:15; signed long long v3:15; };
struct BFu15s_BFs15ll_BFs15ll_BFs15i { unsigned short v1:15; signed long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15s_BFs15ll_BFs15ll_BFs15ll { unsigned short v1:15; signed long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15s_BFs15ll_BFs15ll_BFs15s { unsigned short v1:15; signed long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15s_BFs15ll_BFs15ll_BFu15i { unsigned short v1:15; signed long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15s_BFs15ll_BFs15ll_BFu15ll { unsigned short v1:15; signed long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15ll_BFs15ll_BFu15s { unsigned short v1:15; signed long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15s_BFs15ll_BFs15s { unsigned short v1:15; signed long long v2:15; signed short v3:15; };
struct BFu15s_BFs15ll_BFs15s_BFs15i { unsigned short v1:15; signed long long v2:15; signed short v3:15; signed int v4:15; };
struct BFu15s_BFs15ll_BFs15s_BFs15ll { unsigned short v1:15; signed long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15s_BFs15ll_BFs15s_BFs15s { unsigned short v1:15; signed long long v2:15; signed short v3:15; signed short v4:15; };
struct BFu15s_BFs15ll_BFs15s_BFu15i { unsigned short v1:15; signed long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15s_BFs15ll_BFs15s_BFu15ll { unsigned short v1:15; signed long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15ll_BFs15s_BFu15s { unsigned short v1:15; signed long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15s_BFs15ll_BFu15i { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; };
struct BFu15s_BFs15ll_BFu15i_BFs15i { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15s_BFs15ll_BFu15i_BFs15ll { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15s_BFs15ll_BFu15i_BFs15s { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15s_BFs15ll_BFu15i_BFu15i { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15s_BFs15ll_BFu15i_BFu15ll { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15ll_BFu15i_BFu15s { unsigned short v1:15; signed long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15s_BFs15ll_BFu15ll { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; };
struct BFu15s_BFs15ll_BFu15ll_BFs15i { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15s_BFs15ll_BFu15ll_BFs15ll { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15s_BFs15ll_BFu15ll_BFs15s { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15s_BFs15ll_BFu15ll_BFu15i { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15s_BFs15ll_BFu15ll_BFu15ll { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15ll_BFu15ll_BFu15s { unsigned short v1:15; signed long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15s_BFs15ll_BFu15s { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; };
struct BFu15s_BFs15ll_BFu15s_BFs15i { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15s_BFs15ll_BFu15s_BFs15ll { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15s_BFs15ll_BFu15s_BFs15s { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15s_BFs15ll_BFu15s_BFu15i { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15s_BFs15ll_BFu15s_BFu15ll { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15ll_BFu15s_BFu15s { unsigned short v1:15; signed long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15s_BFs15s { unsigned short v1:15; signed short v2:15; };
struct BFu15s_BFs15s_BFs15i { unsigned short v1:15; signed short v2:15; signed int v3:15; };
struct BFu15s_BFs15s_BFs15i_BFs15i { unsigned short v1:15; signed short v2:15; signed int v3:15; signed int v4:15; };
struct BFu15s_BFs15s_BFs15i_BFs15ll { unsigned short v1:15; signed short v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15s_BFs15s_BFs15i_BFs15s { unsigned short v1:15; signed short v2:15; signed int v3:15; signed short v4:15; };
struct BFu15s_BFs15s_BFs15i_BFu15i { unsigned short v1:15; signed short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15s_BFs15s_BFs15i_BFu15ll { unsigned short v1:15; signed short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15s_BFs15i_BFu15s { unsigned short v1:15; signed short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15s_BFs15s_BFs15ll { unsigned short v1:15; signed short v2:15; signed long long v3:15; };
struct BFu15s_BFs15s_BFs15ll_BFs15i { unsigned short v1:15; signed short v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15s_BFs15s_BFs15ll_BFs15ll { unsigned short v1:15; signed short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15s_BFs15s_BFs15ll_BFs15s { unsigned short v1:15; signed short v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15s_BFs15s_BFs15ll_BFu15i { unsigned short v1:15; signed short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15s_BFs15s_BFs15ll_BFu15ll { unsigned short v1:15; signed short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15s_BFs15ll_BFu15s { unsigned short v1:15; signed short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15s_BFs15s_BFs15s { unsigned short v1:15; signed short v2:15; signed short v3:15; };
struct BFu15s_BFs15s_BFs15s_BFs15i { unsigned short v1:15; signed short v2:15; signed short v3:15; signed int v4:15; };
struct BFu15s_BFs15s_BFs15s_BFs15ll { unsigned short v1:15; signed short v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15s_BFs15s_BFs15s_BFs15s { unsigned short v1:15; signed short v2:15; signed short v3:15; signed short v4:15; };
struct BFu15s_BFs15s_BFs15s_BFu15i { unsigned short v1:15; signed short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15s_BFs15s_BFs15s_BFu15ll { unsigned short v1:15; signed short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15s_BFs15s_BFu15s { unsigned short v1:15; signed short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15s_BFs15s_BFu15i { unsigned short v1:15; signed short v2:15; unsigned int v3:15; };
struct BFu15s_BFs15s_BFu15i_BFs15i { unsigned short v1:15; signed short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15s_BFs15s_BFu15i_BFs15ll { unsigned short v1:15; signed short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15s_BFs15s_BFu15i_BFs15s { unsigned short v1:15; signed short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15s_BFs15s_BFu15i_BFu15i { unsigned short v1:15; signed short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15s_BFs15s_BFu15i_BFu15ll { unsigned short v1:15; signed short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15s_BFu15i_BFu15s { unsigned short v1:15; signed short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15s_BFs15s_BFu15ll { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; };
struct BFu15s_BFs15s_BFu15ll_BFs15i { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15s_BFs15s_BFu15ll_BFs15ll { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15s_BFs15s_BFu15ll_BFs15s { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15s_BFs15s_BFu15ll_BFu15i { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15s_BFs15s_BFu15ll_BFu15ll { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15s_BFu15ll_BFu15s { unsigned short v1:15; signed short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15s_BFs15s_BFu15s { unsigned short v1:15; signed short v2:15; unsigned short v3:15; };
struct BFu15s_BFs15s_BFu15s_BFs15i { unsigned short v1:15; signed short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15s_BFs15s_BFu15s_BFs15ll { unsigned short v1:15; signed short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15s_BFs15s_BFu15s_BFs15s { unsigned short v1:15; signed short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15s_BFs15s_BFu15s_BFu15i { unsigned short v1:15; signed short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15s_BFs15s_BFu15s_BFu15ll { unsigned short v1:15; signed short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15s_BFs15s_BFu15s_BFu15s { unsigned short v1:15; signed short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i { unsigned short v1:15; unsigned int v2:15; };
struct BFu15s_BFu15i_BFs15i { unsigned short v1:15; unsigned int v2:15; signed int v3:15; };
struct BFu15s_BFu15i_BFs15i_BFs15i { unsigned short v1:15; unsigned int v2:15; signed int v3:15; signed int v4:15; };
struct BFu15s_BFu15i_BFs15i_BFs15ll { unsigned short v1:15; unsigned int v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15s_BFu15i_BFs15i_BFs15s { unsigned short v1:15; unsigned int v2:15; signed int v3:15; signed short v4:15; };
struct BFu15s_BFu15i_BFs15i_BFu15i { unsigned short v1:15; unsigned int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15s_BFu15i_BFs15i_BFu15ll { unsigned short v1:15; unsigned int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15i_BFs15i_BFu15s { unsigned short v1:15; unsigned int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i_BFs15ll { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; };
struct BFu15s_BFu15i_BFs15ll_BFs15i { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15s_BFu15i_BFs15ll_BFs15ll { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15s_BFu15i_BFs15ll_BFs15s { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15s_BFu15i_BFs15ll_BFu15i { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15s_BFu15i_BFs15ll_BFu15ll { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15i_BFs15ll_BFu15s { unsigned short v1:15; unsigned int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i_BFs15s { unsigned short v1:15; unsigned int v2:15; signed short v3:15; };
struct BFu15s_BFu15i_BFs15s_BFs15i { unsigned short v1:15; unsigned int v2:15; signed short v3:15; signed int v4:15; };
struct BFu15s_BFu15i_BFs15s_BFs15ll { unsigned short v1:15; unsigned int v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15s_BFu15i_BFs15s_BFs15s { unsigned short v1:15; unsigned int v2:15; signed short v3:15; signed short v4:15; };
struct BFu15s_BFu15i_BFs15s_BFu15i { unsigned short v1:15; unsigned int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15s_BFu15i_BFs15s_BFu15ll { unsigned short v1:15; unsigned int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15i_BFs15s_BFu15s { unsigned short v1:15; unsigned int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i_BFu15i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; };
struct BFu15s_BFu15i_BFu15i_BFs15i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15s_BFu15i_BFu15i_BFs15ll { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15s_BFu15i_BFu15i_BFs15s { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15s_BFu15i_BFu15i_BFu15i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15s_BFu15i_BFu15i_BFu15ll { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15i_BFu15i_BFu15s { unsigned short v1:15; unsigned int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i_BFu15ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; };
struct BFu15s_BFu15i_BFu15ll_BFs15i { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15s_BFu15i_BFu15ll_BFs15ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15s_BFu15i_BFu15ll_BFs15s { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15s_BFu15i_BFu15ll_BFu15i { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15s_BFu15i_BFu15ll_BFu15ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15i_BFu15ll_BFu15s { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i_BFu15s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; };
struct BFu15s_BFu15i_BFu15s_BFs15i { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15s_BFu15i_BFu15s_BFs15ll { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15s_BFu15i_BFu15s_BFs15s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15s_BFu15i_BFu15s_BFu15i { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15s_BFu15i_BFu15s_BFu15ll { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15i_BFu15s_BFu15s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15i_BFu16i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:16; };
struct BFu15s_BFu15i_BFu16ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:16; };
struct BFu15s_BFu15i_BFu16s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:16; };
struct BFu15s_BFu15i_BFu17i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:17; };
struct BFu15s_BFu15i_BFu17ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:17; };
struct BFu15s_BFu15i_BFu1c { unsigned short v1:15; unsigned int v2:15; unsigned char v3:1; };
struct BFu15s_BFu15i_BFu1i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:1; };
struct BFu15s_BFu15i_BFu1ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:1; };
struct BFu15s_BFu15i_BFu1s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:1; };
struct BFu15s_BFu15i_BFu31i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:31; };
struct BFu15s_BFu15i_BFu31ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:31; };
struct BFu15s_BFu15i_BFu32i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:32; };
struct BFu15s_BFu15i_BFu32ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:32; };
struct BFu15s_BFu15i_BFu33 { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:33; };
struct BFu15s_BFu15i_BFu7c { unsigned short v1:15; unsigned int v2:15; unsigned char v3:7; };
struct BFu15s_BFu15i_BFu7i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:7; };
struct BFu15s_BFu15i_BFu7ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:7; };
struct BFu15s_BFu15i_BFu7s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:7; };
struct BFu15s_BFu15i_BFu8c { unsigned short v1:15; unsigned int v2:15; unsigned char v3:8; };
struct BFu15s_BFu15i_BFu8i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:8; };
struct BFu15s_BFu15i_BFu8ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:8; };
struct BFu15s_BFu15i_BFu8s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:8; };
struct BFu15s_BFu15i_BFu9i { unsigned short v1:15; unsigned int v2:15; unsigned int v3:9; };
struct BFu15s_BFu15i_BFu9ll { unsigned short v1:15; unsigned int v2:15; unsigned long long v3:9; };
struct BFu15s_BFu15i_BFu9s { unsigned short v1:15; unsigned int v2:15; unsigned short v3:9; };
struct BFu15s_BFu15i_C { unsigned short v1:15; unsigned int v2:15; char v3; };
struct BFu15s_BFu15i_D { unsigned short v1:15; unsigned int v2:15; double v3; };
struct BFu15s_BFu15i_F { unsigned short v1:15; unsigned int v2:15; float v3; };
struct BFu15s_BFu15i_I { unsigned short v1:15; unsigned int v2:15; int v3; };
struct BFu15s_BFu15i_Ip { unsigned short v1:15; unsigned int v2:15; int * v3; };
struct BFu15s_BFu15i_L { unsigned short v1:15; unsigned int v2:15; long long v3; };
struct BFu15s_BFu15i_S { unsigned short v1:15; unsigned int v2:15; short v3; };
struct BFu15s_BFu15i_Uc { unsigned short v1:15; unsigned int v2:15; unsigned char v3; };
struct BFu15s_BFu15i_Ui { unsigned short v1:15; unsigned int v2:15; unsigned int v3; };
struct BFu15s_BFu15i_Ul { unsigned short v1:15; unsigned int v2:15; unsigned long long v3; };
struct BFu15s_BFu15i_Us { unsigned short v1:15; unsigned int v2:15; unsigned short v3; };
struct BFu15s_BFu15i_Vp { unsigned short v1:15; unsigned int v2:15; void * v3; };
struct BFu15s_BFu15ll { unsigned short v1:15; unsigned long long v2:15; };
struct BFu15s_BFu15ll_BFs15i { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; };
struct BFu15s_BFu15ll_BFs15i_BFs15i { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; signed int v4:15; };
struct BFu15s_BFu15ll_BFs15i_BFs15ll { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15s_BFu15ll_BFs15i_BFs15s { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; signed short v4:15; };
struct BFu15s_BFu15ll_BFs15i_BFu15i { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15s_BFu15ll_BFs15i_BFu15ll { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15ll_BFs15i_BFu15s { unsigned short v1:15; unsigned long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15s_BFu15ll_BFs15ll { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; };
struct BFu15s_BFu15ll_BFs15ll_BFs15i { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15s_BFu15ll_BFs15ll_BFs15ll { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15s_BFu15ll_BFs15ll_BFs15s { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15s_BFu15ll_BFs15ll_BFu15i { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15s_BFu15ll_BFs15ll_BFu15ll { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15ll_BFs15ll_BFu15s { unsigned short v1:15; unsigned long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15s_BFu15ll_BFs15s { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; };
struct BFu15s_BFu15ll_BFs15s_BFs15i { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; signed int v4:15; };
struct BFu15s_BFu15ll_BFs15s_BFs15ll { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15s_BFu15ll_BFs15s_BFs15s { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; signed short v4:15; };
struct BFu15s_BFu15ll_BFs15s_BFu15i { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15s_BFu15ll_BFs15s_BFu15ll { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15ll_BFs15s_BFu15s { unsigned short v1:15; unsigned long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15ll_BFu15i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; };
struct BFu15s_BFu15ll_BFu15i_BFs15i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15s_BFu15ll_BFu15i_BFs15ll { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15s_BFu15ll_BFu15i_BFs15s { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15s_BFu15ll_BFu15i_BFu15i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15s_BFu15ll_BFu15i_BFu15ll { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15ll_BFu15i_BFu15s { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15s_BFu15ll_BFu15ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; };
struct BFu15s_BFu15ll_BFu15ll_BFs15i { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15s_BFu15ll_BFu15ll_BFs15ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15s_BFu15ll_BFu15ll_BFs15s { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15s_BFu15ll_BFu15ll_BFu15i { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15s_BFu15ll_BFu15ll_BFu15ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15ll_BFu15ll_BFu15s { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15s_BFu15ll_BFu15s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; };
struct BFu15s_BFu15ll_BFu15s_BFs15i { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15s_BFu15ll_BFu15s_BFs15ll { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15s_BFu15ll_BFu15s_BFs15s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15s_BFu15ll_BFu15s_BFu15i { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15s_BFu15ll_BFu15s_BFu15ll { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15ll_BFu15s_BFu15s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15ll_BFu16i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:16; };
struct BFu15s_BFu15ll_BFu16ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:16; };
struct BFu15s_BFu15ll_BFu16s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:16; };
struct BFu15s_BFu15ll_BFu17i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:17; };
struct BFu15s_BFu15ll_BFu17ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:17; };
struct BFu15s_BFu15ll_BFu1c { unsigned short v1:15; unsigned long long v2:15; unsigned char v3:1; };
struct BFu15s_BFu15ll_BFu1i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:1; };
struct BFu15s_BFu15ll_BFu1ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:1; };
struct BFu15s_BFu15ll_BFu1s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:1; };
struct BFu15s_BFu15ll_BFu31i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:31; };
struct BFu15s_BFu15ll_BFu31ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:31; };
struct BFu15s_BFu15ll_BFu32i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:32; };
struct BFu15s_BFu15ll_BFu32ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:32; };
struct BFu15s_BFu15ll_BFu33 { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:33; };
struct BFu15s_BFu15ll_BFu7c { unsigned short v1:15; unsigned long long v2:15; unsigned char v3:7; };
struct BFu15s_BFu15ll_BFu7i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:7; };
struct BFu15s_BFu15ll_BFu7ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:7; };
struct BFu15s_BFu15ll_BFu7s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:7; };
struct BFu15s_BFu15ll_BFu8c { unsigned short v1:15; unsigned long long v2:15; unsigned char v3:8; };
struct BFu15s_BFu15ll_BFu8i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:8; };
struct BFu15s_BFu15ll_BFu8ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:8; };
struct BFu15s_BFu15ll_BFu8s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:8; };
struct BFu15s_BFu15ll_BFu9i { unsigned short v1:15; unsigned long long v2:15; unsigned int v3:9; };
struct BFu15s_BFu15ll_BFu9ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3:9; };
struct BFu15s_BFu15ll_BFu9s { unsigned short v1:15; unsigned long long v2:15; unsigned short v3:9; };
struct BFu15s_BFu15ll_C { unsigned short v1:15; unsigned long long v2:15; char v3; };
struct BFu15s_BFu15ll_D { unsigned short v1:15; unsigned long long v2:15; double v3; };
struct BFu15s_BFu15ll_F { unsigned short v1:15; unsigned long long v2:15; float v3; };
struct BFu15s_BFu15ll_I { unsigned short v1:15; unsigned long long v2:15; int v3; };
struct BFu15s_BFu15ll_Ip { unsigned short v1:15; unsigned long long v2:15; int * v3; };
struct BFu15s_BFu15ll_L { unsigned short v1:15; unsigned long long v2:15; long long v3; };
struct BFu15s_BFu15ll_S { unsigned short v1:15; unsigned long long v2:15; short v3; };
struct BFu15s_BFu15ll_Uc { unsigned short v1:15; unsigned long long v2:15; unsigned char v3; };
struct BFu15s_BFu15ll_Ui { unsigned short v1:15; unsigned long long v2:15; unsigned int v3; };
struct BFu15s_BFu15ll_Ul { unsigned short v1:15; unsigned long long v2:15; unsigned long long v3; };
struct BFu15s_BFu15ll_Us { unsigned short v1:15; unsigned long long v2:15; unsigned short v3; };
struct BFu15s_BFu15ll_Vp { unsigned short v1:15; unsigned long long v2:15; void * v3; };
struct BFu15s_BFu15s { unsigned short v1:15; unsigned short v2:15; };
struct BFu15s_BFu15s_BFs15i { unsigned short v1:15; unsigned short v2:15; signed int v3:15; };
struct BFu15s_BFu15s_BFs15i_BFs15i { unsigned short v1:15; unsigned short v2:15; signed int v3:15; signed int v4:15; };
struct BFu15s_BFu15s_BFs15i_BFs15ll { unsigned short v1:15; unsigned short v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15s_BFu15s_BFs15i_BFs15s { unsigned short v1:15; unsigned short v2:15; signed int v3:15; signed short v4:15; };
struct BFu15s_BFu15s_BFs15i_BFu15i { unsigned short v1:15; unsigned short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15s_BFu15s_BFs15i_BFu15ll { unsigned short v1:15; unsigned short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15s_BFs15i_BFu15s { unsigned short v1:15; unsigned short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15s_BFu15s_BFs15ll { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; };
struct BFu15s_BFu15s_BFs15ll_BFs15i { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15s_BFu15s_BFs15ll_BFs15ll { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15s_BFu15s_BFs15ll_BFs15s { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15s_BFu15s_BFs15ll_BFu15i { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15s_BFu15s_BFs15ll_BFu15ll { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15s_BFs15ll_BFu15s { unsigned short v1:15; unsigned short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15s_BFu15s_BFs15s { unsigned short v1:15; unsigned short v2:15; signed short v3:15; };
struct BFu15s_BFu15s_BFs15s_BFs15i { unsigned short v1:15; unsigned short v2:15; signed short v3:15; signed int v4:15; };
struct BFu15s_BFu15s_BFs15s_BFs15ll { unsigned short v1:15; unsigned short v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15s_BFu15s_BFs15s_BFs15s { unsigned short v1:15; unsigned short v2:15; signed short v3:15; signed short v4:15; };
struct BFu15s_BFu15s_BFs15s_BFu15i { unsigned short v1:15; unsigned short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15s_BFu15s_BFs15s_BFu15ll { unsigned short v1:15; unsigned short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15s_BFs15s_BFu15s { unsigned short v1:15; unsigned short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15s_BFu15i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; };
struct BFu15s_BFu15s_BFu15i_BFs15i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15s_BFu15s_BFu15i_BFs15ll { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15s_BFu15s_BFu15i_BFs15s { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15s_BFu15s_BFu15i_BFu15i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15s_BFu15s_BFu15i_BFu15ll { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15s_BFu15i_BFu15s { unsigned short v1:15; unsigned short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15s_BFu15s_BFu15ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; };
struct BFu15s_BFu15s_BFu15ll_BFs15i { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15s_BFu15s_BFu15ll_BFs15ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15s_BFu15s_BFu15ll_BFs15s { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15s_BFu15s_BFu15ll_BFu15i { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15s_BFu15s_BFu15ll_BFu15ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15s_BFu15ll_BFu15s { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15s_BFu15s_BFu15s { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; };
struct BFu15s_BFu15s_BFu15s_BFs15i { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15s_BFu15s_BFu15s_BFs15ll { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15s_BFu15s_BFu15s_BFs15s { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15s_BFu15s_BFu15s_BFu15i { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15s_BFu15s_BFu15s_BFu15ll { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15s_BFu15s_BFu15s_BFu15s { unsigned short v1:15; unsigned short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15s_BFu15s_BFu16i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:16; };
struct BFu15s_BFu15s_BFu16ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:16; };
struct BFu15s_BFu15s_BFu16s { unsigned short v1:15; unsigned short v2:15; unsigned short v3:16; };
struct BFu15s_BFu15s_BFu17i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:17; };
struct BFu15s_BFu15s_BFu17ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:17; };
struct BFu15s_BFu15s_BFu1c { unsigned short v1:15; unsigned short v2:15; unsigned char v3:1; };
struct BFu15s_BFu15s_BFu1i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:1; };
struct BFu15s_BFu15s_BFu1ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:1; };
struct BFu15s_BFu15s_BFu1s { unsigned short v1:15; unsigned short v2:15; unsigned short v3:1; };
struct BFu15s_BFu15s_BFu31i { unsigned short v1:15; unsigned short v2:15; unsigned int v3:31; };
struct BFu15s_BFu15s_BFu31ll { unsigned short v1:15; unsigned short v2:15; unsigned long long v3:31; };


static void Test_BFu15i_BFu8c_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu1i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu1i, BFu15i_BFu8c_BFu1i)
//============================================================================



static void Test_BFu15i_BFu8c_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu1ll, BFu15i_BFu8c_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu8c_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu1s");
    static STRUCT_IF_C BFu15i_BFu8c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu1s, BFu15i_BFu8c_BFu1s)
//============================================================================



static void Test_BFu15i_BFu8c_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu31i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu31i, BFu15i_BFu8c_BFu31i)
//============================================================================



static void Test_BFu15i_BFu8c_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu31ll, BFu15i_BFu8c_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu8c_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu32i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu32i, BFu15i_BFu8c_BFu32i)
//============================================================================



static void Test_BFu15i_BFu8c_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu32ll, BFu15i_BFu8c_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu8c_BFu33()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu33");
    static STRUCT_IF_C BFu15i_BFu8c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15i_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu33, BFu15i_BFu8c_BFu33)
//============================================================================



static void Test_BFu15i_BFu8c_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu7c");
    static STRUCT_IF_C BFu15i_BFu8c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu7c, BFu15i_BFu8c_BFu7c)
//============================================================================



static void Test_BFu15i_BFu8c_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu7i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu7i, BFu15i_BFu8c_BFu7i)
//============================================================================



static void Test_BFu15i_BFu8c_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu7ll, BFu15i_BFu8c_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu8c_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu7s");
    static STRUCT_IF_C BFu15i_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu7s, BFu15i_BFu8c_BFu7s)
//============================================================================



static void Test_BFu15i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu8c");
    static STRUCT_IF_C BFu15i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu8c, BFu15i_BFu8c_BFu8c)
//============================================================================



static void Test_BFu15i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu8i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu8i, BFu15i_BFu8c_BFu8i)
//============================================================================



static void Test_BFu15i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu8ll, BFu15i_BFu8c_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu8s");
    static STRUCT_IF_C BFu15i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu8s, BFu15i_BFu8c_BFu8s)
//============================================================================



static void Test_BFu15i_BFu8c_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu9i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu9i, BFu15i_BFu8c_BFu9i)
//============================================================================



static void Test_BFu15i_BFu8c_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu9ll, BFu15i_BFu8c_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu8c_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu9s");
    static STRUCT_IF_C BFu15i_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu9s, BFu15i_BFu8c_BFu9s)
//============================================================================



static void Test_BFu15i_BFu8c_C()
{
  {
    init_simple_test("BFu15i_BFu8c_C");
    static STRUCT_IF_C BFu15i_BFu8c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_C, BFu15i_BFu8c_C)
//============================================================================



static void Test_BFu15i_BFu8c_D()
{
  {
    init_simple_test("BFu15i_BFu8c_D");
    static STRUCT_IF_C BFu15i_BFu8c_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_D, BFu15i_BFu8c_D)
//============================================================================



static void Test_BFu15i_BFu8c_F()
{
  {
    init_simple_test("BFu15i_BFu8c_F");
    static STRUCT_IF_C BFu15i_BFu8c_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_F, BFu15i_BFu8c_F)
//============================================================================



static void Test_BFu15i_BFu8c_I()
{
  {
    init_simple_test("BFu15i_BFu8c_I");
    static STRUCT_IF_C BFu15i_BFu8c_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_I, BFu15i_BFu8c_I)
//============================================================================



static void Test_BFu15i_BFu8c_Ip()
{
  {
    init_simple_test("BFu15i_BFu8c_Ip");
    static STRUCT_IF_C BFu15i_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_Ip, BFu15i_BFu8c_Ip)
//============================================================================



static void Test_BFu15i_BFu8c_L()
{
  {
    init_simple_test("BFu15i_BFu8c_L");
    static STRUCT_IF_C BFu15i_BFu8c_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_L, BFu15i_BFu8c_L)
//============================================================================



static void Test_BFu15i_BFu8c_S()
{
  {
    init_simple_test("BFu15i_BFu8c_S");
    static STRUCT_IF_C BFu15i_BFu8c_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_S, BFu15i_BFu8c_S)
//============================================================================



static void Test_BFu15i_BFu8c_Uc()
{
  {
    init_simple_test("BFu15i_BFu8c_Uc");
    static STRUCT_IF_C BFu15i_BFu8c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_Uc, BFu15i_BFu8c_Uc)
//============================================================================



static void Test_BFu15i_BFu8c_Ui()
{
  {
    init_simple_test("BFu15i_BFu8c_Ui");
    static STRUCT_IF_C BFu15i_BFu8c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_Ui, BFu15i_BFu8c_Ui)
//============================================================================



static void Test_BFu15i_BFu8c_Ul()
{
  {
    init_simple_test("BFu15i_BFu8c_Ul");
    static STRUCT_IF_C BFu15i_BFu8c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_Ul, BFu15i_BFu8c_Ul)
//============================================================================



static void Test_BFu15i_BFu8c_Us()
{
  {
    init_simple_test("BFu15i_BFu8c_Us");
    static STRUCT_IF_C BFu15i_BFu8c_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_Us, BFu15i_BFu8c_Us)
//============================================================================



static void Test_BFu15i_BFu8c_Vp()
{
  {
    init_simple_test("BFu15i_BFu8c_Vp");
    static STRUCT_IF_C BFu15i_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_Vp, BFu15i_BFu8c_Vp)
//============================================================================



static void Test_BFu15i_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu8i");
    static STRUCT_IF_C BFu15i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i, BFu15i_BFu8i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu15i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu15i, BFu15i_BFu8i_BFu15i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu15ll, BFu15i_BFu8i_BFu15ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu15s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu15s, BFu15i_BFu8i_BFu15s)
//============================================================================



static void Test_BFu15i_BFu8i_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu16i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu16i, BFu15i_BFu8i_BFu16i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu16ll, BFu15i_BFu8i_BFu16ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu16s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu16s, BFu15i_BFu8i_BFu16s)
//============================================================================



static void Test_BFu15i_BFu8i_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu17i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15i_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu17i, BFu15i_BFu8i_BFu17i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu17ll, BFu15i_BFu8i_BFu17ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu1c");
    static STRUCT_IF_C BFu15i_BFu8i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu1c, BFu15i_BFu8i_BFu1c)
//============================================================================



static void Test_BFu15i_BFu8i_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu1i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu1i, BFu15i_BFu8i_BFu1i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu1ll, BFu15i_BFu8i_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu1s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu1s, BFu15i_BFu8i_BFu1s)
//============================================================================



static void Test_BFu15i_BFu8i_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu31i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu31i, BFu15i_BFu8i_BFu31i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu31ll, BFu15i_BFu8i_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu32i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu32i, BFu15i_BFu8i_BFu32i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu32ll, BFu15i_BFu8i_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu33()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu33");
    static STRUCT_IF_C BFu15i_BFu8i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15i_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu33, BFu15i_BFu8i_BFu33)
//============================================================================



static void Test_BFu15i_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu7c");
    static STRUCT_IF_C BFu15i_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu7c, BFu15i_BFu8i_BFu7c)
//============================================================================



static void Test_BFu15i_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu7i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu7i, BFu15i_BFu8i_BFu7i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu7ll, BFu15i_BFu8i_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu7s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu7s, BFu15i_BFu8i_BFu7s)
//============================================================================



static void Test_BFu15i_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu8c");
    static STRUCT_IF_C BFu15i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu8c, BFu15i_BFu8i_BFu8c)
//============================================================================



static void Test_BFu15i_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu8i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu8i, BFu15i_BFu8i_BFu8i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu8ll, BFu15i_BFu8i_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu8s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu8s, BFu15i_BFu8i_BFu8s)
//============================================================================



static void Test_BFu15i_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu9i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu9i, BFu15i_BFu8i_BFu9i)
//============================================================================



static void Test_BFu15i_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu9ll, BFu15i_BFu8i_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu9s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu9s, BFu15i_BFu8i_BFu9s)
//============================================================================



static void Test_BFu15i_BFu8i_C()
{
  {
    init_simple_test("BFu15i_BFu8i_C");
    static STRUCT_IF_C BFu15i_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_C, BFu15i_BFu8i_C)
//============================================================================



static void Test_BFu15i_BFu8i_D()
{
  {
    init_simple_test("BFu15i_BFu8i_D");
    static STRUCT_IF_C BFu15i_BFu8i_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_D, BFu15i_BFu8i_D)
//============================================================================



static void Test_BFu15i_BFu8i_F()
{
  {
    init_simple_test("BFu15i_BFu8i_F");
    static STRUCT_IF_C BFu15i_BFu8i_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_F, BFu15i_BFu8i_F)
//============================================================================



static void Test_BFu15i_BFu8i_I()
{
  {
    init_simple_test("BFu15i_BFu8i_I");
    static STRUCT_IF_C BFu15i_BFu8i_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_I, BFu15i_BFu8i_I)
//============================================================================



static void Test_BFu15i_BFu8i_Ip()
{
  {
    init_simple_test("BFu15i_BFu8i_Ip");
    static STRUCT_IF_C BFu15i_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_Ip, BFu15i_BFu8i_Ip)
//============================================================================



static void Test_BFu15i_BFu8i_L()
{
  {
    init_simple_test("BFu15i_BFu8i_L");
    static STRUCT_IF_C BFu15i_BFu8i_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_L, BFu15i_BFu8i_L)
//============================================================================



static void Test_BFu15i_BFu8i_S()
{
  {
    init_simple_test("BFu15i_BFu8i_S");
    static STRUCT_IF_C BFu15i_BFu8i_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_S, BFu15i_BFu8i_S)
//============================================================================



static void Test_BFu15i_BFu8i_Uc()
{
  {
    init_simple_test("BFu15i_BFu8i_Uc");
    static STRUCT_IF_C BFu15i_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_Uc, BFu15i_BFu8i_Uc)
//============================================================================



static void Test_BFu15i_BFu8i_Ui()
{
  {
    init_simple_test("BFu15i_BFu8i_Ui");
    static STRUCT_IF_C BFu15i_BFu8i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_Ui, BFu15i_BFu8i_Ui)
//============================================================================



static void Test_BFu15i_BFu8i_Ul()
{
  {
    init_simple_test("BFu15i_BFu8i_Ul");
    static STRUCT_IF_C BFu15i_BFu8i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_Ul, BFu15i_BFu8i_Ul)
//============================================================================



static void Test_BFu15i_BFu8i_Us()
{
  {
    init_simple_test("BFu15i_BFu8i_Us");
    static STRUCT_IF_C BFu15i_BFu8i_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_Us, BFu15i_BFu8i_Us)
//============================================================================



static void Test_BFu15i_BFu8i_Vp()
{
  {
    init_simple_test("BFu15i_BFu8i_Vp");
    static STRUCT_IF_C BFu15i_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_Vp, BFu15i_BFu8i_Vp)
//============================================================================



static void Test_BFu15i_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll, BFu15i_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu15i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu15i, BFu15i_BFu8ll_BFu15i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu15ll, BFu15i_BFu8ll_BFu15ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu15s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu15s, BFu15i_BFu8ll_BFu15s)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu16i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu16i, BFu15i_BFu8ll_BFu16i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu16ll, BFu15i_BFu8ll_BFu16ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu16s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu16s, BFu15i_BFu8ll_BFu16s)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu17i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu17i, BFu15i_BFu8ll_BFu17i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu17ll, BFu15i_BFu8ll_BFu17ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu1c");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu1c, BFu15i_BFu8ll_BFu1c)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu1i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu1i, BFu15i_BFu8ll_BFu1i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu1ll, BFu15i_BFu8ll_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu1s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu1s, BFu15i_BFu8ll_BFu1s)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu31i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu31i, BFu15i_BFu8ll_BFu31i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu31ll, BFu15i_BFu8ll_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu32i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu32i, BFu15i_BFu8ll_BFu32i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu32ll, BFu15i_BFu8ll_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu33()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu33");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15i_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu33, BFu15i_BFu8ll_BFu33)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu7c");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu7c, BFu15i_BFu8ll_BFu7c)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu7i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu7i, BFu15i_BFu8ll_BFu7i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu7ll, BFu15i_BFu8ll_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu7s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu7s, BFu15i_BFu8ll_BFu7s)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu8c, BFu15i_BFu8ll_BFu8c)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu8i, BFu15i_BFu8ll_BFu8i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu8ll, BFu15i_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu8s, BFu15i_BFu8ll_BFu8s)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu9i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu9i, BFu15i_BFu8ll_BFu9i)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu9ll, BFu15i_BFu8ll_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu8ll_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu9s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu9s, BFu15i_BFu8ll_BFu9s)
//============================================================================



static void Test_BFu15i_BFu8ll_C()
{
  {
    init_simple_test("BFu15i_BFu8ll_C");
    static STRUCT_IF_C BFu15i_BFu8ll_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_C, BFu15i_BFu8ll_C)
//============================================================================



static void Test_BFu15i_BFu8ll_D()
{
  {
    init_simple_test("BFu15i_BFu8ll_D");
    static STRUCT_IF_C BFu15i_BFu8ll_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_D, BFu15i_BFu8ll_D)
//============================================================================



static void Test_BFu15i_BFu8ll_F()
{
  {
    init_simple_test("BFu15i_BFu8ll_F");
    static STRUCT_IF_C BFu15i_BFu8ll_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_F, BFu15i_BFu8ll_F)
//============================================================================



static void Test_BFu15i_BFu8ll_I()
{
  {
    init_simple_test("BFu15i_BFu8ll_I");
    static STRUCT_IF_C BFu15i_BFu8ll_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_I, BFu15i_BFu8ll_I)
//============================================================================



static void Test_BFu15i_BFu8ll_Ip()
{
  {
    init_simple_test("BFu15i_BFu8ll_Ip");
    static STRUCT_IF_C BFu15i_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_Ip, BFu15i_BFu8ll_Ip)
//============================================================================



static void Test_BFu15i_BFu8ll_L()
{
  {
    init_simple_test("BFu15i_BFu8ll_L");
    static STRUCT_IF_C BFu15i_BFu8ll_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_L, BFu15i_BFu8ll_L)
//============================================================================



static void Test_BFu15i_BFu8ll_S()
{
  {
    init_simple_test("BFu15i_BFu8ll_S");
    static STRUCT_IF_C BFu15i_BFu8ll_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_S, BFu15i_BFu8ll_S)
//============================================================================



static void Test_BFu15i_BFu8ll_Uc()
{
  {
    init_simple_test("BFu15i_BFu8ll_Uc");
    static STRUCT_IF_C BFu15i_BFu8ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_Uc, BFu15i_BFu8ll_Uc)
//============================================================================



static void Test_BFu15i_BFu8ll_Ui()
{
  {
    init_simple_test("BFu15i_BFu8ll_Ui");
    static STRUCT_IF_C BFu15i_BFu8ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_Ui, BFu15i_BFu8ll_Ui)
//============================================================================



static void Test_BFu15i_BFu8ll_Ul()
{
  {
    init_simple_test("BFu15i_BFu8ll_Ul");
    static STRUCT_IF_C BFu15i_BFu8ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_Ul, BFu15i_BFu8ll_Ul)
//============================================================================



static void Test_BFu15i_BFu8ll_Us()
{
  {
    init_simple_test("BFu15i_BFu8ll_Us");
    static STRUCT_IF_C BFu15i_BFu8ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_Us, BFu15i_BFu8ll_Us)
//============================================================================



static void Test_BFu15i_BFu8ll_Vp()
{
  {
    init_simple_test("BFu15i_BFu8ll_Vp");
    static STRUCT_IF_C BFu15i_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_Vp, BFu15i_BFu8ll_Vp)
//============================================================================



static void Test_BFu15i_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu8s");
    static STRUCT_IF_C BFu15i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s, BFu15i_BFu8s)
//============================================================================



static void Test_BFu15i_BFu8s_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu15i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu15i, BFu15i_BFu8s_BFu15i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu15ll, BFu15i_BFu8s_BFu15ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu15s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "BFu15i_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu15s, BFu15i_BFu8s_BFu15s)
//============================================================================



static void Test_BFu15i_BFu8s_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu16i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu16i, BFu15i_BFu8s_BFu16i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu16ll, BFu15i_BFu8s_BFu16ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu16s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "BFu15i_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu16s, BFu15i_BFu8s_BFu16s)
//============================================================================



static void Test_BFu15i_BFu8s_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu17i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15i_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu17i, BFu15i_BFu8s_BFu17i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "BFu15i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu17ll, BFu15i_BFu8s_BFu17ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu1c");
    static STRUCT_IF_C BFu15i_BFu8s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu1c, BFu15i_BFu8s_BFu1c)
//============================================================================



static void Test_BFu15i_BFu8s_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu1i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu1i, BFu15i_BFu8s_BFu1i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu1ll, BFu15i_BFu8s_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu1s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "BFu15i_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu1s, BFu15i_BFu8s_BFu1s)
//============================================================================



static void Test_BFu15i_BFu8s_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu31i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu31i, BFu15i_BFu8s_BFu31i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "BFu15i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu31ll, BFu15i_BFu8s_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu32i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu32i, BFu15i_BFu8s_BFu32i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "BFu15i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu32ll, BFu15i_BFu8s_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu33()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu33");
    static STRUCT_IF_C BFu15i_BFu8s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "BFu15i_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu33, BFu15i_BFu8s_BFu33)
//============================================================================



static void Test_BFu15i_BFu8s_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu7c");
    static STRUCT_IF_C BFu15i_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu7c, BFu15i_BFu8s_BFu7c)
//============================================================================



static void Test_BFu15i_BFu8s_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu7i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu7i, BFu15i_BFu8s_BFu7i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu7ll, BFu15i_BFu8s_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu7s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "BFu15i_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu7s, BFu15i_BFu8s_BFu7s)
//============================================================================



static void Test_BFu15i_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu8c");
    static STRUCT_IF_C BFu15i_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu8c, BFu15i_BFu8s_BFu8c)
//============================================================================



static void Test_BFu15i_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu8i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu8i, BFu15i_BFu8s_BFu8i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu8ll, BFu15i_BFu8s_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu8s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "BFu15i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu8s, BFu15i_BFu8s_BFu8s)
//============================================================================



static void Test_BFu15i_BFu8s_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu9i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu9i, BFu15i_BFu8s_BFu9i)
//============================================================================



static void Test_BFu15i_BFu8s_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu9ll, BFu15i_BFu8s_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu8s_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu9s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "BFu15i_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu9s, BFu15i_BFu8s_BFu9s)
//============================================================================



static void Test_BFu15i_BFu8s_C()
{
  {
    init_simple_test("BFu15i_BFu8s_C");
    static STRUCT_IF_C BFu15i_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_C, BFu15i_BFu8s_C)
//============================================================================



static void Test_BFu15i_BFu8s_D()
{
  {
    init_simple_test("BFu15i_BFu8s_D");
    static STRUCT_IF_C BFu15i_BFu8s_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_D, BFu15i_BFu8s_D)
//============================================================================



static void Test_BFu15i_BFu8s_F()
{
  {
    init_simple_test("BFu15i_BFu8s_F");
    static STRUCT_IF_C BFu15i_BFu8s_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_F, BFu15i_BFu8s_F)
//============================================================================



static void Test_BFu15i_BFu8s_I()
{
  {
    init_simple_test("BFu15i_BFu8s_I");
    static STRUCT_IF_C BFu15i_BFu8s_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_I, BFu15i_BFu8s_I)
//============================================================================



static void Test_BFu15i_BFu8s_Ip()
{
  {
    init_simple_test("BFu15i_BFu8s_Ip");
    static STRUCT_IF_C BFu15i_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_Ip, BFu15i_BFu8s_Ip)
//============================================================================



static void Test_BFu15i_BFu8s_L()
{
  {
    init_simple_test("BFu15i_BFu8s_L");
    static STRUCT_IF_C BFu15i_BFu8s_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_L, BFu15i_BFu8s_L)
//============================================================================



static void Test_BFu15i_BFu8s_S()
{
  {
    init_simple_test("BFu15i_BFu8s_S");
    static STRUCT_IF_C BFu15i_BFu8s_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_S, BFu15i_BFu8s_S)
//============================================================================



static void Test_BFu15i_BFu8s_Uc()
{
  {
    init_simple_test("BFu15i_BFu8s_Uc");
    static STRUCT_IF_C BFu15i_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_Uc, BFu15i_BFu8s_Uc)
//============================================================================



static void Test_BFu15i_BFu8s_Ui()
{
  {
    init_simple_test("BFu15i_BFu8s_Ui");
    static STRUCT_IF_C BFu15i_BFu8s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_Ui, BFu15i_BFu8s_Ui)
//============================================================================



static void Test_BFu15i_BFu8s_Ul()
{
  {
    init_simple_test("BFu15i_BFu8s_Ul");
    static STRUCT_IF_C BFu15i_BFu8s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_Ul, BFu15i_BFu8s_Ul)
//============================================================================



static void Test_BFu15i_BFu8s_Us()
{
  {
    init_simple_test("BFu15i_BFu8s_Us");
    static STRUCT_IF_C BFu15i_BFu8s_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_Us, BFu15i_BFu8s_Us)
//============================================================================



static void Test_BFu15i_BFu8s_Vp()
{
  {
    init_simple_test("BFu15i_BFu8s_Vp");
    static STRUCT_IF_C BFu15i_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_Vp, BFu15i_BFu8s_Vp)
//============================================================================



static void Test_BFu15i_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu9i");
    static STRUCT_IF_C BFu15i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i, BFu15i_BFu9i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu15i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu15i, BFu15i_BFu9i_BFu15i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu15ll, BFu15i_BFu9i_BFu15ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu15s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu15s, BFu15i_BFu9i_BFu15s)
//============================================================================



static void Test_BFu15i_BFu9i_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu16i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu16i, BFu15i_BFu9i_BFu16i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu16ll, BFu15i_BFu9i_BFu16ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu16s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu16s, BFu15i_BFu9i_BFu16s)
//============================================================================



static void Test_BFu15i_BFu9i_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu17i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu17i, BFu15i_BFu9i_BFu17i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu17ll, BFu15i_BFu9i_BFu17ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu1c");
    static STRUCT_IF_C BFu15i_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu1c, BFu15i_BFu9i_BFu1c)
//============================================================================



static void Test_BFu15i_BFu9i_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu1i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu1i, BFu15i_BFu9i_BFu1i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu1ll, BFu15i_BFu9i_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu1s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu1s, BFu15i_BFu9i_BFu1s)
//============================================================================



static void Test_BFu15i_BFu9i_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu31i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu31i, BFu15i_BFu9i_BFu31i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu31ll, BFu15i_BFu9i_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu32i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu32i, BFu15i_BFu9i_BFu32i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu32ll, BFu15i_BFu9i_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu33()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu33");
    static STRUCT_IF_C BFu15i_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu33, BFu15i_BFu9i_BFu33)
//============================================================================



static void Test_BFu15i_BFu9i_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu7c");
    static STRUCT_IF_C BFu15i_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu7c, BFu15i_BFu9i_BFu7c)
//============================================================================



static void Test_BFu15i_BFu9i_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu7i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu7i, BFu15i_BFu9i_BFu7i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu7ll, BFu15i_BFu9i_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu7s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu7s, BFu15i_BFu9i_BFu7s)
//============================================================================



static void Test_BFu15i_BFu9i_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu8c");
    static STRUCT_IF_C BFu15i_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu8c, BFu15i_BFu9i_BFu8c)
//============================================================================



static void Test_BFu15i_BFu9i_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu8i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu8i, BFu15i_BFu9i_BFu8i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu8ll, BFu15i_BFu9i_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu8s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu8s, BFu15i_BFu9i_BFu8s)
//============================================================================



static void Test_BFu15i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu9i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu9i, BFu15i_BFu9i_BFu9i)
//============================================================================



static void Test_BFu15i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu9ll, BFu15i_BFu9i_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu9s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu9s, BFu15i_BFu9i_BFu9s)
//============================================================================



static void Test_BFu15i_BFu9i_C()
{
  {
    init_simple_test("BFu15i_BFu9i_C");
    static STRUCT_IF_C BFu15i_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_C, BFu15i_BFu9i_C)
//============================================================================



static void Test_BFu15i_BFu9i_D()
{
  {
    init_simple_test("BFu15i_BFu9i_D");
    static STRUCT_IF_C BFu15i_BFu9i_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_D, BFu15i_BFu9i_D)
//============================================================================



static void Test_BFu15i_BFu9i_F()
{
  {
    init_simple_test("BFu15i_BFu9i_F");
    static STRUCT_IF_C BFu15i_BFu9i_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_F, BFu15i_BFu9i_F)
//============================================================================



static void Test_BFu15i_BFu9i_I()
{
  {
    init_simple_test("BFu15i_BFu9i_I");
    static STRUCT_IF_C BFu15i_BFu9i_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_I, BFu15i_BFu9i_I)
//============================================================================



static void Test_BFu15i_BFu9i_Ip()
{
  {
    init_simple_test("BFu15i_BFu9i_Ip");
    static STRUCT_IF_C BFu15i_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_Ip, BFu15i_BFu9i_Ip)
//============================================================================



static void Test_BFu15i_BFu9i_L()
{
  {
    init_simple_test("BFu15i_BFu9i_L");
    static STRUCT_IF_C BFu15i_BFu9i_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_L, BFu15i_BFu9i_L)
//============================================================================



static void Test_BFu15i_BFu9i_S()
{
  {
    init_simple_test("BFu15i_BFu9i_S");
    static STRUCT_IF_C BFu15i_BFu9i_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_S, BFu15i_BFu9i_S)
//============================================================================



static void Test_BFu15i_BFu9i_Uc()
{
  {
    init_simple_test("BFu15i_BFu9i_Uc");
    static STRUCT_IF_C BFu15i_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_Uc, BFu15i_BFu9i_Uc)
//============================================================================



static void Test_BFu15i_BFu9i_Ui()
{
  {
    init_simple_test("BFu15i_BFu9i_Ui");
    static STRUCT_IF_C BFu15i_BFu9i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_Ui, BFu15i_BFu9i_Ui)
//============================================================================



static void Test_BFu15i_BFu9i_Ul()
{
  {
    init_simple_test("BFu15i_BFu9i_Ul");
    static STRUCT_IF_C BFu15i_BFu9i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_Ul, BFu15i_BFu9i_Ul)
//============================================================================



static void Test_BFu15i_BFu9i_Us()
{
  {
    init_simple_test("BFu15i_BFu9i_Us");
    static STRUCT_IF_C BFu15i_BFu9i_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_Us, BFu15i_BFu9i_Us)
//============================================================================



static void Test_BFu15i_BFu9i_Vp()
{
  {
    init_simple_test("BFu15i_BFu9i_Vp");
    static STRUCT_IF_C BFu15i_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_Vp, BFu15i_BFu9i_Vp)
//============================================================================



static void Test_BFu15i_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll, BFu15i_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu15i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu15i, BFu15i_BFu9ll_BFu15i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu15ll, BFu15i_BFu9ll_BFu15ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu15s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu15s, BFu15i_BFu9ll_BFu15s)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu16i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu16i, BFu15i_BFu9ll_BFu16i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu16ll, BFu15i_BFu9ll_BFu16ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu16s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu16s, BFu15i_BFu9ll_BFu16s)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu17i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu17i, BFu15i_BFu9ll_BFu17i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu17ll, BFu15i_BFu9ll_BFu17ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu1c");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu1c, BFu15i_BFu9ll_BFu1c)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu1i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu1i, BFu15i_BFu9ll_BFu1i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu1ll, BFu15i_BFu9ll_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu1s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu1s, BFu15i_BFu9ll_BFu1s)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu31i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu31i, BFu15i_BFu9ll_BFu31i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu31ll, BFu15i_BFu9ll_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu32i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu32i, BFu15i_BFu9ll_BFu32i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu32ll, BFu15i_BFu9ll_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu33()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu33");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu33, BFu15i_BFu9ll_BFu33)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu7c");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu7c, BFu15i_BFu9ll_BFu7c)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu7i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu7i, BFu15i_BFu9ll_BFu7i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu7ll, BFu15i_BFu9ll_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu7s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu7s, BFu15i_BFu9ll_BFu7s)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu8c");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu8c, BFu15i_BFu9ll_BFu8c)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu8i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu8i, BFu15i_BFu9ll_BFu8i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu8ll, BFu15i_BFu9ll_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu8s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu8s, BFu15i_BFu9ll_BFu8s)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu9i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu9i, BFu15i_BFu9ll_BFu9i)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu9ll, BFu15i_BFu9ll_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu9s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu9s, BFu15i_BFu9ll_BFu9s)
//============================================================================



static void Test_BFu15i_BFu9ll_C()
{
  {
    init_simple_test("BFu15i_BFu9ll_C");
    static STRUCT_IF_C BFu15i_BFu9ll_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_C, BFu15i_BFu9ll_C)
//============================================================================



static void Test_BFu15i_BFu9ll_D()
{
  {
    init_simple_test("BFu15i_BFu9ll_D");
    static STRUCT_IF_C BFu15i_BFu9ll_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_D, BFu15i_BFu9ll_D)
//============================================================================



static void Test_BFu15i_BFu9ll_F()
{
  {
    init_simple_test("BFu15i_BFu9ll_F");
    static STRUCT_IF_C BFu15i_BFu9ll_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_F, BFu15i_BFu9ll_F)
//============================================================================



static void Test_BFu15i_BFu9ll_I()
{
  {
    init_simple_test("BFu15i_BFu9ll_I");
    static STRUCT_IF_C BFu15i_BFu9ll_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_I, BFu15i_BFu9ll_I)
//============================================================================



static void Test_BFu15i_BFu9ll_Ip()
{
  {
    init_simple_test("BFu15i_BFu9ll_Ip");
    static STRUCT_IF_C BFu15i_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_Ip, BFu15i_BFu9ll_Ip)
//============================================================================



static void Test_BFu15i_BFu9ll_L()
{
  {
    init_simple_test("BFu15i_BFu9ll_L");
    static STRUCT_IF_C BFu15i_BFu9ll_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_L, BFu15i_BFu9ll_L)
//============================================================================



static void Test_BFu15i_BFu9ll_S()
{
  {
    init_simple_test("BFu15i_BFu9ll_S");
    static STRUCT_IF_C BFu15i_BFu9ll_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_S, BFu15i_BFu9ll_S)
//============================================================================



static void Test_BFu15i_BFu9ll_Uc()
{
  {
    init_simple_test("BFu15i_BFu9ll_Uc");
    static STRUCT_IF_C BFu15i_BFu9ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_Uc, BFu15i_BFu9ll_Uc)
//============================================================================



static void Test_BFu15i_BFu9ll_Ui()
{
  {
    init_simple_test("BFu15i_BFu9ll_Ui");
    static STRUCT_IF_C BFu15i_BFu9ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_Ui, BFu15i_BFu9ll_Ui)
//============================================================================



static void Test_BFu15i_BFu9ll_Ul()
{
  {
    init_simple_test("BFu15i_BFu9ll_Ul");
    static STRUCT_IF_C BFu15i_BFu9ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_Ul, BFu15i_BFu9ll_Ul)
//============================================================================



static void Test_BFu15i_BFu9ll_Us()
{
  {
    init_simple_test("BFu15i_BFu9ll_Us");
    static STRUCT_IF_C BFu15i_BFu9ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_Us, BFu15i_BFu9ll_Us)
//============================================================================



static void Test_BFu15i_BFu9ll_Vp()
{
  {
    init_simple_test("BFu15i_BFu9ll_Vp");
    static STRUCT_IF_C BFu15i_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_Vp, BFu15i_BFu9ll_Vp)
//============================================================================



static void Test_BFu15i_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu9s");
    static STRUCT_IF_C BFu15i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s, BFu15i_BFu9s)
//============================================================================



static void Test_BFu15i_BFu9s_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu15i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu15i, BFu15i_BFu9s_BFu15i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu15ll, BFu15i_BFu9s_BFu15ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu15s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu15s, BFu15i_BFu9s_BFu15s)
//============================================================================



static void Test_BFu15i_BFu9s_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu16i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu16i, BFu15i_BFu9s_BFu16i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu16ll, BFu15i_BFu9s_BFu16ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu16s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu16s, BFu15i_BFu9s_BFu16s)
//============================================================================



static void Test_BFu15i_BFu9s_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu17i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu17i, BFu15i_BFu9s_BFu17i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu17ll, BFu15i_BFu9s_BFu17ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu1c");
    static STRUCT_IF_C BFu15i_BFu9s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu1c, BFu15i_BFu9s_BFu1c)
//============================================================================



static void Test_BFu15i_BFu9s_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu1i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu1i, BFu15i_BFu9s_BFu1i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu1ll, BFu15i_BFu9s_BFu1ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu1s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu1s, BFu15i_BFu9s_BFu1s)
//============================================================================



static void Test_BFu15i_BFu9s_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu31i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu31i, BFu15i_BFu9s_BFu31i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu31ll, BFu15i_BFu9s_BFu31ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu32i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu32i, BFu15i_BFu9s_BFu32i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu32ll, BFu15i_BFu9s_BFu32ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu33()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu33");
    static STRUCT_IF_C BFu15i_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu33, BFu15i_BFu9s_BFu33)
//============================================================================



static void Test_BFu15i_BFu9s_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu7c");
    static STRUCT_IF_C BFu15i_BFu9s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu7c, BFu15i_BFu9s_BFu7c)
//============================================================================



static void Test_BFu15i_BFu9s_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu7i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu7i, BFu15i_BFu9s_BFu7i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu7ll, BFu15i_BFu9s_BFu7ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu7s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu7s, BFu15i_BFu9s_BFu7s)
//============================================================================



static void Test_BFu15i_BFu9s_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu8c");
    static STRUCT_IF_C BFu15i_BFu9s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu8c, BFu15i_BFu9s_BFu8c)
//============================================================================



static void Test_BFu15i_BFu9s_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu8i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu8i, BFu15i_BFu9s_BFu8i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu8ll, BFu15i_BFu9s_BFu8ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu8s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu8s, BFu15i_BFu9s_BFu8s)
//============================================================================



static void Test_BFu15i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu9i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu9i, BFu15i_BFu9s_BFu9i)
//============================================================================



static void Test_BFu15i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu9ll, BFu15i_BFu9s_BFu9ll)
//============================================================================



static void Test_BFu15i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu9s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu9s, BFu15i_BFu9s_BFu9s)
//============================================================================



static void Test_BFu15i_BFu9s_C()
{
  {
    init_simple_test("BFu15i_BFu9s_C");
    static STRUCT_IF_C BFu15i_BFu9s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_C");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_C");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_C");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_C, BFu15i_BFu9s_C)
//============================================================================



static void Test_BFu15i_BFu9s_D()
{
  {
    init_simple_test("BFu15i_BFu9s_D");
    static STRUCT_IF_C BFu15i_BFu9s_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_D");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_D");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_D");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_D, BFu15i_BFu9s_D)
//============================================================================



static void Test_BFu15i_BFu9s_F()
{
  {
    init_simple_test("BFu15i_BFu9s_F");
    static STRUCT_IF_C BFu15i_BFu9s_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_F");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_F");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_F");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_F, BFu15i_BFu9s_F)
//============================================================================



static void Test_BFu15i_BFu9s_I()
{
  {
    init_simple_test("BFu15i_BFu9s_I");
    static STRUCT_IF_C BFu15i_BFu9s_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_I");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_I");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_I");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_I, BFu15i_BFu9s_I)
//============================================================================



static void Test_BFu15i_BFu9s_Ip()
{
  {
    init_simple_test("BFu15i_BFu9s_Ip");
    static STRUCT_IF_C BFu15i_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Ip");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_Ip");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Ip");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_Ip, BFu15i_BFu9s_Ip)
//============================================================================



static void Test_BFu15i_BFu9s_L()
{
  {
    init_simple_test("BFu15i_BFu9s_L");
    static STRUCT_IF_C BFu15i_BFu9s_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_L");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_L");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_L");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_L, BFu15i_BFu9s_L)
//============================================================================



static void Test_BFu15i_BFu9s_S()
{
  {
    init_simple_test("BFu15i_BFu9s_S");
    static STRUCT_IF_C BFu15i_BFu9s_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_S");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_S");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_S");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_S, BFu15i_BFu9s_S)
//============================================================================



static void Test_BFu15i_BFu9s_Uc()
{
  {
    init_simple_test("BFu15i_BFu9s_Uc");
    static STRUCT_IF_C BFu15i_BFu9s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Uc");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_Uc");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Uc");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_Uc, BFu15i_BFu9s_Uc)
//============================================================================



static void Test_BFu15i_BFu9s_Ui()
{
  {
    init_simple_test("BFu15i_BFu9s_Ui");
    static STRUCT_IF_C BFu15i_BFu9s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Ui");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_Ui");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Ui");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_Ui, BFu15i_BFu9s_Ui)
//============================================================================



static void Test_BFu15i_BFu9s_Ul()
{
  {
    init_simple_test("BFu15i_BFu9s_Ul");
    static STRUCT_IF_C BFu15i_BFu9s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Ul");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_Ul");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Ul");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_Ul, BFu15i_BFu9s_Ul)
//============================================================================



static void Test_BFu15i_BFu9s_Us()
{
  {
    init_simple_test("BFu15i_BFu9s_Us");
    static STRUCT_IF_C BFu15i_BFu9s_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Us");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_Us");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Us");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_Us, BFu15i_BFu9s_Us)
//============================================================================



static void Test_BFu15i_BFu9s_Vp()
{
  {
    init_simple_test("BFu15i_BFu9s_Vp");
    static STRUCT_IF_C BFu15i_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Vp");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_Vp");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Vp");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_Vp, BFu15i_BFu9s_Vp)
//============================================================================



static void Test_BFu15i_C()
{
  {
    init_simple_test("BFu15i_C");
    static STRUCT_IF_C BFu15i_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C");
    check_field_offset(lv, v2, 2, "BFu15i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C, BFu15i_C)
//============================================================================



static void Test_BFu15i_C_BFu15i()
{
  {
    init_simple_test("BFu15i_C_BFu15i");
    static STRUCT_IF_C BFu15i_C_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_C_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu15i, BFu15i_C_BFu15i)
//============================================================================



static void Test_BFu15i_C_BFu15ll()
{
  {
    init_simple_test("BFu15i_C_BFu15ll");
    static STRUCT_IF_C BFu15i_C_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_C_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu15ll, BFu15i_C_BFu15ll)
//============================================================================



static void Test_BFu15i_C_BFu15s()
{
  {
    init_simple_test("BFu15i_C_BFu15s");
    static STRUCT_IF_C BFu15i_C_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_C_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu15s, BFu15i_C_BFu15s)
//============================================================================



static void Test_BFu15i_C_BFu16i()
{
  {
    init_simple_test("BFu15i_C_BFu16i");
    static STRUCT_IF_C BFu15i_C_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_C_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu16i, BFu15i_C_BFu16i)
//============================================================================



static void Test_BFu15i_C_BFu16ll()
{
  {
    init_simple_test("BFu15i_C_BFu16ll");
    static STRUCT_IF_C BFu15i_C_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_C_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu16ll, BFu15i_C_BFu16ll)
//============================================================================



static void Test_BFu15i_C_BFu16s()
{
  {
    init_simple_test("BFu15i_C_BFu16s");
    static STRUCT_IF_C BFu15i_C_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_C_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu16s, BFu15i_C_BFu16s)
//============================================================================



static void Test_BFu15i_C_BFu17i()
{
  {
    init_simple_test("BFu15i_C_BFu17i");
    static STRUCT_IF_C BFu15i_C_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_C_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu17i, BFu15i_C_BFu17i)
//============================================================================



static void Test_BFu15i_C_BFu17ll()
{
  {
    init_simple_test("BFu15i_C_BFu17ll");
    static STRUCT_IF_C BFu15i_C_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_C_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu17ll, BFu15i_C_BFu17ll)
//============================================================================



static void Test_BFu15i_C_BFu1c()
{
  {
    init_simple_test("BFu15i_C_BFu1c");
    static STRUCT_IF_C BFu15i_C_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu1c, BFu15i_C_BFu1c)
//============================================================================



static void Test_BFu15i_C_BFu1i()
{
  {
    init_simple_test("BFu15i_C_BFu1i");
    static STRUCT_IF_C BFu15i_C_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu1i, BFu15i_C_BFu1i)
//============================================================================



static void Test_BFu15i_C_BFu1ll()
{
  {
    init_simple_test("BFu15i_C_BFu1ll");
    static STRUCT_IF_C BFu15i_C_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu1ll, BFu15i_C_BFu1ll)
//============================================================================



static void Test_BFu15i_C_BFu1s()
{
  {
    init_simple_test("BFu15i_C_BFu1s");
    static STRUCT_IF_C BFu15i_C_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu1s, BFu15i_C_BFu1s)
//============================================================================



static void Test_BFu15i_C_BFu31i()
{
  {
    init_simple_test("BFu15i_C_BFu31i");
    static STRUCT_IF_C BFu15i_C_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_C_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu31i, BFu15i_C_BFu31i)
//============================================================================



static void Test_BFu15i_C_BFu31ll()
{
  {
    init_simple_test("BFu15i_C_BFu31ll");
    static STRUCT_IF_C BFu15i_C_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_C_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu31ll, BFu15i_C_BFu31ll)
//============================================================================



static void Test_BFu15i_C_BFu32i()
{
  {
    init_simple_test("BFu15i_C_BFu32i");
    static STRUCT_IF_C BFu15i_C_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_C_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu32i, BFu15i_C_BFu32i)
//============================================================================



static void Test_BFu15i_C_BFu32ll()
{
  {
    init_simple_test("BFu15i_C_BFu32ll");
    static STRUCT_IF_C BFu15i_C_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_C_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu32ll, BFu15i_C_BFu32ll)
//============================================================================



static void Test_BFu15i_C_BFu33()
{
  {
    init_simple_test("BFu15i_C_BFu33");
    static STRUCT_IF_C BFu15i_C_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_C_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu33, BFu15i_C_BFu33)
//============================================================================



static void Test_BFu15i_C_BFu7c()
{
  {
    init_simple_test("BFu15i_C_BFu7c");
    static STRUCT_IF_C BFu15i_C_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_C_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu7c, BFu15i_C_BFu7c)
//============================================================================



static void Test_BFu15i_C_BFu7i()
{
  {
    init_simple_test("BFu15i_C_BFu7i");
    static STRUCT_IF_C BFu15i_C_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_C_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu7i, BFu15i_C_BFu7i)
//============================================================================



static void Test_BFu15i_C_BFu7ll()
{
  {
    init_simple_test("BFu15i_C_BFu7ll");
    static STRUCT_IF_C BFu15i_C_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_C_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu7ll, BFu15i_C_BFu7ll)
//============================================================================



static void Test_BFu15i_C_BFu7s()
{
  {
    init_simple_test("BFu15i_C_BFu7s");
    static STRUCT_IF_C BFu15i_C_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_C_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu7s, BFu15i_C_BFu7s)
//============================================================================



static void Test_BFu15i_C_BFu8c()
{
  {
    init_simple_test("BFu15i_C_BFu8c");
    static STRUCT_IF_C BFu15i_C_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_C_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu8c, BFu15i_C_BFu8c)
//============================================================================



static void Test_BFu15i_C_BFu8i()
{
  {
    init_simple_test("BFu15i_C_BFu8i");
    static STRUCT_IF_C BFu15i_C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_C_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu8i, BFu15i_C_BFu8i)
//============================================================================



static void Test_BFu15i_C_BFu8ll()
{
  {
    init_simple_test("BFu15i_C_BFu8ll");
    static STRUCT_IF_C BFu15i_C_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_C_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu8ll, BFu15i_C_BFu8ll)
//============================================================================



static void Test_BFu15i_C_BFu8s()
{
  {
    init_simple_test("BFu15i_C_BFu8s");
    static STRUCT_IF_C BFu15i_C_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_C_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu8s, BFu15i_C_BFu8s)
//============================================================================



static void Test_BFu15i_C_BFu9i()
{
  {
    init_simple_test("BFu15i_C_BFu9i");
    static STRUCT_IF_C BFu15i_C_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_C_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu9i, BFu15i_C_BFu9i)
//============================================================================



static void Test_BFu15i_C_BFu9ll()
{
  {
    init_simple_test("BFu15i_C_BFu9ll");
    static STRUCT_IF_C BFu15i_C_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_C_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu9ll, BFu15i_C_BFu9ll)
//============================================================================



static void Test_BFu15i_C_BFu9s()
{
  {
    init_simple_test("BFu15i_C_BFu9s");
    static STRUCT_IF_C BFu15i_C_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_C_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu9s, BFu15i_C_BFu9s)
//============================================================================



static void Test_BFu15i_C_C()
{
  {
    init_simple_test("BFu15i_C_C");
    static STRUCT_IF_C BFu15i_C_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_C");
    check_field_offset(lv, v2, 2, "BFu15i_C_C.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_C, BFu15i_C_C)
//============================================================================



static void Test_BFu15i_C_D()
{
  {
    init_simple_test("BFu15i_C_D");
    static STRUCT_IF_C BFu15i_C_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_D");
    check_field_offset(lv, v2, 2, "BFu15i_C_D.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_D, BFu15i_C_D)
//============================================================================



static void Test_BFu15i_C_F()
{
  {
    init_simple_test("BFu15i_C_F");
    static STRUCT_IF_C BFu15i_C_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_F");
    check_field_offset(lv, v2, 2, "BFu15i_C_F.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_F, BFu15i_C_F)
//============================================================================



static void Test_BFu15i_C_I()
{
  {
    init_simple_test("BFu15i_C_I");
    static STRUCT_IF_C BFu15i_C_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_I");
    check_field_offset(lv, v2, 2, "BFu15i_C_I.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_I, BFu15i_C_I)
//============================================================================



static void Test_BFu15i_C_Ip()
{
  {
    init_simple_test("BFu15i_C_Ip");
    static STRUCT_IF_C BFu15i_C_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_C_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_Ip, BFu15i_C_Ip)
//============================================================================



static void Test_BFu15i_C_L()
{
  {
    init_simple_test("BFu15i_C_L");
    static STRUCT_IF_C BFu15i_C_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_L");
    check_field_offset(lv, v2, 2, "BFu15i_C_L.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_L, BFu15i_C_L)
//============================================================================



static void Test_BFu15i_C_S()
{
  {
    init_simple_test("BFu15i_C_S");
    static STRUCT_IF_C BFu15i_C_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_S");
    check_field_offset(lv, v2, 2, "BFu15i_C_S.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_S, BFu15i_C_S)
//============================================================================



static void Test_BFu15i_C_Uc()
{
  {
    init_simple_test("BFu15i_C_Uc");
    static STRUCT_IF_C BFu15i_C_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_C_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_Uc, BFu15i_C_Uc)
//============================================================================



static void Test_BFu15i_C_Ui()
{
  {
    init_simple_test("BFu15i_C_Ui");
    static STRUCT_IF_C BFu15i_C_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_C_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_Ui, BFu15i_C_Ui)
//============================================================================



static void Test_BFu15i_C_Ul()
{
  {
    init_simple_test("BFu15i_C_Ul");
    static STRUCT_IF_C BFu15i_C_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_C_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_Ul, BFu15i_C_Ul)
//============================================================================



static void Test_BFu15i_C_Us()
{
  {
    init_simple_test("BFu15i_C_Us");
    static STRUCT_IF_C BFu15i_C_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Us");
    check_field_offset(lv, v2, 2, "BFu15i_C_Us.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_Us, BFu15i_C_Us)
//============================================================================



static void Test_BFu15i_C_Vp()
{
  {
    init_simple_test("BFu15i_C_Vp");
    static STRUCT_IF_C BFu15i_C_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_C_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_Vp, BFu15i_C_Vp)
//============================================================================



static void Test_BFu15i_D()
{
  {
    init_simple_test("BFu15i_D");
    static STRUCT_IF_C BFu15i_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D");
    check_field_offset(lv, v2, 2, "BFu15i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D, BFu15i_D)
//============================================================================



static void Test_BFu15i_D_BFu15i()
{
  {
    init_simple_test("BFu15i_D_BFu15i");
    static STRUCT_IF_C BFu15i_D_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_D_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu15i, BFu15i_D_BFu15i)
//============================================================================



static void Test_BFu15i_D_BFu15ll()
{
  {
    init_simple_test("BFu15i_D_BFu15ll");
    static STRUCT_IF_C BFu15i_D_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_D_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu15ll, BFu15i_D_BFu15ll)
//============================================================================



static void Test_BFu15i_D_BFu15s()
{
  {
    init_simple_test("BFu15i_D_BFu15s");
    static STRUCT_IF_C BFu15i_D_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_D_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu15s, BFu15i_D_BFu15s)
//============================================================================



static void Test_BFu15i_D_BFu16i()
{
  {
    init_simple_test("BFu15i_D_BFu16i");
    static STRUCT_IF_C BFu15i_D_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_D_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu16i, BFu15i_D_BFu16i)
//============================================================================



static void Test_BFu15i_D_BFu16ll()
{
  {
    init_simple_test("BFu15i_D_BFu16ll");
    static STRUCT_IF_C BFu15i_D_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_D_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu16ll, BFu15i_D_BFu16ll)
//============================================================================



static void Test_BFu15i_D_BFu16s()
{
  {
    init_simple_test("BFu15i_D_BFu16s");
    static STRUCT_IF_C BFu15i_D_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_D_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu16s, BFu15i_D_BFu16s)
//============================================================================



static void Test_BFu15i_D_BFu17i()
{
  {
    init_simple_test("BFu15i_D_BFu17i");
    static STRUCT_IF_C BFu15i_D_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(BFu15i_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu15i_D_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu15i_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu17i, BFu15i_D_BFu17i)
//============================================================================



static void Test_BFu15i_D_BFu17ll()
{
  {
    init_simple_test("BFu15i_D_BFu17ll");
    static STRUCT_IF_C BFu15i_D_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu15i_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu15i_D_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu15i_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu17ll, BFu15i_D_BFu17ll)
//============================================================================



static void Test_BFu15i_D_BFu1c()
{
  {
    init_simple_test("BFu15i_D_BFu1c");
    static STRUCT_IF_C BFu15i_D_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu1c, BFu15i_D_BFu1c)
//============================================================================



static void Test_BFu15i_D_BFu1i()
{
  {
    init_simple_test("BFu15i_D_BFu1i");
    static STRUCT_IF_C BFu15i_D_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu1i, BFu15i_D_BFu1i)
//============================================================================



static void Test_BFu15i_D_BFu1ll()
{
  {
    init_simple_test("BFu15i_D_BFu1ll");
    static STRUCT_IF_C BFu15i_D_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu1ll, BFu15i_D_BFu1ll)
//============================================================================



static void Test_BFu15i_D_BFu1s()
{
  {
    init_simple_test("BFu15i_D_BFu1s");
    static STRUCT_IF_C BFu15i_D_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu1s, BFu15i_D_BFu1s)
//============================================================================



static void Test_BFu15i_D_BFu31i()
{
  {
    init_simple_test("BFu15i_D_BFu31i");
    static STRUCT_IF_C BFu15i_D_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu15i_D_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu15i_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu31i, BFu15i_D_BFu31i)
//============================================================================



static void Test_BFu15i_D_BFu31ll()
{
  {
    init_simple_test("BFu15i_D_BFu31ll");
    static STRUCT_IF_C BFu15i_D_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu15i_D_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu15i_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu31ll, BFu15i_D_BFu31ll)
//============================================================================



static void Test_BFu15i_D_BFu32i()
{
  {
    init_simple_test("BFu15i_D_BFu32i");
    static STRUCT_IF_C BFu15i_D_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu15i_D_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu15i_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu32i, BFu15i_D_BFu32i)
//============================================================================



static void Test_BFu15i_D_BFu32ll()
{
  {
    init_simple_test("BFu15i_D_BFu32ll");
    static STRUCT_IF_C BFu15i_D_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu15i_D_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu15i_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu32ll, BFu15i_D_BFu32ll)
//============================================================================



static void Test_BFu15i_D_BFu33()
{
  {
    init_simple_test("BFu15i_D_BFu33");
    static STRUCT_IF_C BFu15i_D_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(BFu15i_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "BFu15i_D_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "BFu15i_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu33, BFu15i_D_BFu33)
//============================================================================



static void Test_BFu15i_D_BFu7c()
{
  {
    init_simple_test("BFu15i_D_BFu7c");
    static STRUCT_IF_C BFu15i_D_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_D_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu7c, BFu15i_D_BFu7c)
//============================================================================



static void Test_BFu15i_D_BFu7i()
{
  {
    init_simple_test("BFu15i_D_BFu7i");
    static STRUCT_IF_C BFu15i_D_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_D_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu7i, BFu15i_D_BFu7i)
//============================================================================



static void Test_BFu15i_D_BFu7ll()
{
  {
    init_simple_test("BFu15i_D_BFu7ll");
    static STRUCT_IF_C BFu15i_D_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_D_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu7ll, BFu15i_D_BFu7ll)
//============================================================================



static void Test_BFu15i_D_BFu7s()
{
  {
    init_simple_test("BFu15i_D_BFu7s");
    static STRUCT_IF_C BFu15i_D_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_D_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu7s, BFu15i_D_BFu7s)
//============================================================================



static void Test_BFu15i_D_BFu8c()
{
  {
    init_simple_test("BFu15i_D_BFu8c");
    static STRUCT_IF_C BFu15i_D_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_D_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu8c, BFu15i_D_BFu8c)
//============================================================================



static void Test_BFu15i_D_BFu8i()
{
  {
    init_simple_test("BFu15i_D_BFu8i");
    static STRUCT_IF_C BFu15i_D_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_D_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu8i, BFu15i_D_BFu8i)
//============================================================================



static void Test_BFu15i_D_BFu8ll()
{
  {
    init_simple_test("BFu15i_D_BFu8ll");
    static STRUCT_IF_C BFu15i_D_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_D_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu8ll, BFu15i_D_BFu8ll)
//============================================================================



static void Test_BFu15i_D_BFu8s()
{
  {
    init_simple_test("BFu15i_D_BFu8s");
    static STRUCT_IF_C BFu15i_D_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_D_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu8s, BFu15i_D_BFu8s)
//============================================================================



static void Test_BFu15i_D_BFu9i()
{
  {
    init_simple_test("BFu15i_D_BFu9i");
    static STRUCT_IF_C BFu15i_D_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_D_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu9i, BFu15i_D_BFu9i)
//============================================================================



static void Test_BFu15i_D_BFu9ll()
{
  {
    init_simple_test("BFu15i_D_BFu9ll");
    static STRUCT_IF_C BFu15i_D_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_D_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu9ll, BFu15i_D_BFu9ll)
//============================================================================



static void Test_BFu15i_D_BFu9s()
{
  {
    init_simple_test("BFu15i_D_BFu9s");
    static STRUCT_IF_C BFu15i_D_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_D_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu9s, BFu15i_D_BFu9s)
//============================================================================



static void Test_BFu15i_D_C()
{
  {
    init_simple_test("BFu15i_D_C");
    static STRUCT_IF_C BFu15i_D_C lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_C");
    check_field_offset(lv, v2, 2, "BFu15i_D_C.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_C, BFu15i_D_C)
//============================================================================



static void Test_BFu15i_D_D()
{
  {
    init_simple_test("BFu15i_D_D");
    static STRUCT_IF_C BFu15i_D_D lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_D");
    check_field_offset(lv, v2, 2, "BFu15i_D_D.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_D, BFu15i_D_D)
//============================================================================



static void Test_BFu15i_D_F()
{
  {
    init_simple_test("BFu15i_D_F");
    static STRUCT_IF_C BFu15i_D_F lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_F");
    check_field_offset(lv, v2, 2, "BFu15i_D_F.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_F, BFu15i_D_F)
//============================================================================



static void Test_BFu15i_D_I()
{
  {
    init_simple_test("BFu15i_D_I");
    static STRUCT_IF_C BFu15i_D_I lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_I");
    check_field_offset(lv, v2, 2, "BFu15i_D_I.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_I, BFu15i_D_I)
//============================================================================



static void Test_BFu15i_D_Ip()
{
  {
    init_simple_test("BFu15i_D_Ip");
    static STRUCT_IF_C BFu15i_D_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_D_Ip.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_Ip, BFu15i_D_Ip)
//============================================================================



static void Test_BFu15i_D_L()
{
  {
    init_simple_test("BFu15i_D_L");
    static STRUCT_IF_C BFu15i_D_L lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_L");
    check_field_offset(lv, v2, 2, "BFu15i_D_L.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_L, BFu15i_D_L)
//============================================================================



static void Test_BFu15i_D_S()
{
  {
    init_simple_test("BFu15i_D_S");
    static STRUCT_IF_C BFu15i_D_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_S");
    check_field_offset(lv, v2, 2, "BFu15i_D_S.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_S, BFu15i_D_S)
//============================================================================



static void Test_BFu15i_D_Uc()
{
  {
    init_simple_test("BFu15i_D_Uc");
    static STRUCT_IF_C BFu15i_D_Uc lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_D_Uc.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_Uc, BFu15i_D_Uc)
//============================================================================



static void Test_BFu15i_D_Ui()
{
  {
    init_simple_test("BFu15i_D_Ui");
    static STRUCT_IF_C BFu15i_D_Ui lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_D_Ui.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_Ui, BFu15i_D_Ui)
//============================================================================



static void Test_BFu15i_D_Ul()
{
  {
    init_simple_test("BFu15i_D_Ul");
    static STRUCT_IF_C BFu15i_D_Ul lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_D_Ul.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_Ul, BFu15i_D_Ul)
//============================================================================



static void Test_BFu15i_D_Us()
{
  {
    init_simple_test("BFu15i_D_Us");
    static STRUCT_IF_C BFu15i_D_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Us");
    check_field_offset(lv, v2, 2, "BFu15i_D_Us.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_Us, BFu15i_D_Us)
//============================================================================



static void Test_BFu15i_D_Vp()
{
  {
    init_simple_test("BFu15i_D_Vp");
    static STRUCT_IF_C BFu15i_D_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_D_Vp.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_Vp, BFu15i_D_Vp)
//============================================================================



static void Test_BFu15i_F()
{
  {
    init_simple_test("BFu15i_F");
    static STRUCT_IF_C BFu15i_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F");
    check_field_offset(lv, v2, 2, "BFu15i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F, BFu15i_F)
//============================================================================



static void Test_BFu15i_F_BFu15i()
{
  {
    init_simple_test("BFu15i_F_BFu15i");
    static STRUCT_IF_C BFu15i_F_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_F_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu15i, BFu15i_F_BFu15i)
//============================================================================



static void Test_BFu15i_F_BFu15ll()
{
  {
    init_simple_test("BFu15i_F_BFu15ll");
    static STRUCT_IF_C BFu15i_F_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_F_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu15ll, BFu15i_F_BFu15ll)
//============================================================================



static void Test_BFu15i_F_BFu15s()
{
  {
    init_simple_test("BFu15i_F_BFu15s");
    static STRUCT_IF_C BFu15i_F_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_F_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu15s, BFu15i_F_BFu15s)
//============================================================================



static void Test_BFu15i_F_BFu16i()
{
  {
    init_simple_test("BFu15i_F_BFu16i");
    static STRUCT_IF_C BFu15i_F_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_F_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu16i, BFu15i_F_BFu16i)
//============================================================================



static void Test_BFu15i_F_BFu16ll()
{
  {
    init_simple_test("BFu15i_F_BFu16ll");
    static STRUCT_IF_C BFu15i_F_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_F_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu16ll, BFu15i_F_BFu16ll)
//============================================================================



static void Test_BFu15i_F_BFu16s()
{
  {
    init_simple_test("BFu15i_F_BFu16s");
    static STRUCT_IF_C BFu15i_F_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_F_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu16s, BFu15i_F_BFu16s)
//============================================================================



static void Test_BFu15i_F_BFu17i()
{
  {
    init_simple_test("BFu15i_F_BFu17i");
    static STRUCT_IF_C BFu15i_F_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu15i_F_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu15i_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu17i, BFu15i_F_BFu17i)
//============================================================================



static void Test_BFu15i_F_BFu17ll()
{
  {
    init_simple_test("BFu15i_F_BFu17ll");
    static STRUCT_IF_C BFu15i_F_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu15i_F_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu15i_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu17ll, BFu15i_F_BFu17ll)
//============================================================================



static void Test_BFu15i_F_BFu1c()
{
  {
    init_simple_test("BFu15i_F_BFu1c");
    static STRUCT_IF_C BFu15i_F_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu1c, BFu15i_F_BFu1c)
//============================================================================



static void Test_BFu15i_F_BFu1i()
{
  {
    init_simple_test("BFu15i_F_BFu1i");
    static STRUCT_IF_C BFu15i_F_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu1i, BFu15i_F_BFu1i)
//============================================================================



static void Test_BFu15i_F_BFu1ll()
{
  {
    init_simple_test("BFu15i_F_BFu1ll");
    static STRUCT_IF_C BFu15i_F_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu1ll, BFu15i_F_BFu1ll)
//============================================================================



static void Test_BFu15i_F_BFu1s()
{
  {
    init_simple_test("BFu15i_F_BFu1s");
    static STRUCT_IF_C BFu15i_F_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu1s, BFu15i_F_BFu1s)
//============================================================================



static void Test_BFu15i_F_BFu31i()
{
  {
    init_simple_test("BFu15i_F_BFu31i");
    static STRUCT_IF_C BFu15i_F_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu15i_F_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu15i_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu31i, BFu15i_F_BFu31i)
//============================================================================



static void Test_BFu15i_F_BFu31ll()
{
  {
    init_simple_test("BFu15i_F_BFu31ll");
    static STRUCT_IF_C BFu15i_F_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu15i_F_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu15i_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu31ll, BFu15i_F_BFu31ll)
//============================================================================



static void Test_BFu15i_F_BFu32i()
{
  {
    init_simple_test("BFu15i_F_BFu32i");
    static STRUCT_IF_C BFu15i_F_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu15i_F_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu15i_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu32i, BFu15i_F_BFu32i)
//============================================================================



static void Test_BFu15i_F_BFu32ll()
{
  {
    init_simple_test("BFu15i_F_BFu32ll");
    static STRUCT_IF_C BFu15i_F_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu15i_F_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu15i_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu32ll, BFu15i_F_BFu32ll)
//============================================================================



static void Test_BFu15i_F_BFu33()
{
  {
    init_simple_test("BFu15i_F_BFu33");
    static STRUCT_IF_C BFu15i_F_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "BFu15i_F_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "BFu15i_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu33, BFu15i_F_BFu33)
//============================================================================



static void Test_BFu15i_F_BFu7c()
{
  {
    init_simple_test("BFu15i_F_BFu7c");
    static STRUCT_IF_C BFu15i_F_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_F_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu7c, BFu15i_F_BFu7c)
//============================================================================



static void Test_BFu15i_F_BFu7i()
{
  {
    init_simple_test("BFu15i_F_BFu7i");
    static STRUCT_IF_C BFu15i_F_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_F_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu7i, BFu15i_F_BFu7i)
//============================================================================



static void Test_BFu15i_F_BFu7ll()
{
  {
    init_simple_test("BFu15i_F_BFu7ll");
    static STRUCT_IF_C BFu15i_F_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_F_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu7ll, BFu15i_F_BFu7ll)
//============================================================================



static void Test_BFu15i_F_BFu7s()
{
  {
    init_simple_test("BFu15i_F_BFu7s");
    static STRUCT_IF_C BFu15i_F_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_F_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu7s, BFu15i_F_BFu7s)
//============================================================================



static void Test_BFu15i_F_BFu8c()
{
  {
    init_simple_test("BFu15i_F_BFu8c");
    static STRUCT_IF_C BFu15i_F_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_F_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu8c, BFu15i_F_BFu8c)
//============================================================================



static void Test_BFu15i_F_BFu8i()
{
  {
    init_simple_test("BFu15i_F_BFu8i");
    static STRUCT_IF_C BFu15i_F_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_F_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu8i, BFu15i_F_BFu8i)
//============================================================================



static void Test_BFu15i_F_BFu8ll()
{
  {
    init_simple_test("BFu15i_F_BFu8ll");
    static STRUCT_IF_C BFu15i_F_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_F_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu8ll, BFu15i_F_BFu8ll)
//============================================================================



static void Test_BFu15i_F_BFu8s()
{
  {
    init_simple_test("BFu15i_F_BFu8s");
    static STRUCT_IF_C BFu15i_F_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_F_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu8s, BFu15i_F_BFu8s)
//============================================================================



static void Test_BFu15i_F_BFu9i()
{
  {
    init_simple_test("BFu15i_F_BFu9i");
    static STRUCT_IF_C BFu15i_F_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_F_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu9i, BFu15i_F_BFu9i)
//============================================================================



static void Test_BFu15i_F_BFu9ll()
{
  {
    init_simple_test("BFu15i_F_BFu9ll");
    static STRUCT_IF_C BFu15i_F_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_F_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu9ll, BFu15i_F_BFu9ll)
//============================================================================



static void Test_BFu15i_F_BFu9s()
{
  {
    init_simple_test("BFu15i_F_BFu9s");
    static STRUCT_IF_C BFu15i_F_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_F_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu9s, BFu15i_F_BFu9s)
//============================================================================



static void Test_BFu15i_F_C()
{
  {
    init_simple_test("BFu15i_F_C");
    static STRUCT_IF_C BFu15i_F_C lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_C");
    check_field_offset(lv, v2, 2, "BFu15i_F_C.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_C, BFu15i_F_C)
//============================================================================



static void Test_BFu15i_F_D()
{
  {
    init_simple_test("BFu15i_F_D");
    static STRUCT_IF_C BFu15i_F_D lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_D");
    check_field_offset(lv, v2, 2, "BFu15i_F_D.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_D, BFu15i_F_D)
//============================================================================



static void Test_BFu15i_F_F()
{
  {
    init_simple_test("BFu15i_F_F");
    static STRUCT_IF_C BFu15i_F_F lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_F");
    check_field_offset(lv, v2, 2, "BFu15i_F_F.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_F, BFu15i_F_F)
//============================================================================



static void Test_BFu15i_F_I()
{
  {
    init_simple_test("BFu15i_F_I");
    static STRUCT_IF_C BFu15i_F_I lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_I");
    check_field_offset(lv, v2, 2, "BFu15i_F_I.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_I, BFu15i_F_I)
//============================================================================



static void Test_BFu15i_F_Ip()
{
  {
    init_simple_test("BFu15i_F_Ip");
    static STRUCT_IF_C BFu15i_F_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_F_Ip.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_Ip, BFu15i_F_Ip)
//============================================================================



static void Test_BFu15i_F_L()
{
  {
    init_simple_test("BFu15i_F_L");
    static STRUCT_IF_C BFu15i_F_L lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_L");
    check_field_offset(lv, v2, 2, "BFu15i_F_L.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_L, BFu15i_F_L)
//============================================================================



static void Test_BFu15i_F_S()
{
  {
    init_simple_test("BFu15i_F_S");
    static STRUCT_IF_C BFu15i_F_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_S");
    check_field_offset(lv, v2, 2, "BFu15i_F_S.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_S, BFu15i_F_S)
//============================================================================



static void Test_BFu15i_F_Uc()
{
  {
    init_simple_test("BFu15i_F_Uc");
    static STRUCT_IF_C BFu15i_F_Uc lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_F_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_Uc, BFu15i_F_Uc)
//============================================================================



static void Test_BFu15i_F_Ui()
{
  {
    init_simple_test("BFu15i_F_Ui");
    static STRUCT_IF_C BFu15i_F_Ui lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_F_Ui.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_Ui, BFu15i_F_Ui)
//============================================================================



static void Test_BFu15i_F_Ul()
{
  {
    init_simple_test("BFu15i_F_Ul");
    static STRUCT_IF_C BFu15i_F_Ul lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_F_Ul.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_Ul, BFu15i_F_Ul)
//============================================================================



static void Test_BFu15i_F_Us()
{
  {
    init_simple_test("BFu15i_F_Us");
    static STRUCT_IF_C BFu15i_F_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Us");
    check_field_offset(lv, v2, 2, "BFu15i_F_Us.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_Us, BFu15i_F_Us)
//============================================================================



static void Test_BFu15i_F_Vp()
{
  {
    init_simple_test("BFu15i_F_Vp");
    static STRUCT_IF_C BFu15i_F_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_F_Vp.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_Vp, BFu15i_F_Vp)
//============================================================================



static void Test_BFu15i_I()
{
  {
    init_simple_test("BFu15i_I");
    static STRUCT_IF_C BFu15i_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I");
    check_field_offset(lv, v2, 2, "BFu15i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I, BFu15i_I)
//============================================================================



static void Test_BFu15i_I_BFu15i()
{
  {
    init_simple_test("BFu15i_I_BFu15i");
    static STRUCT_IF_C BFu15i_I_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_I_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu15i, BFu15i_I_BFu15i)
//============================================================================



static void Test_BFu15i_I_BFu15ll()
{
  {
    init_simple_test("BFu15i_I_BFu15ll");
    static STRUCT_IF_C BFu15i_I_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_I_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu15ll, BFu15i_I_BFu15ll)
//============================================================================



static void Test_BFu15i_I_BFu15s()
{
  {
    init_simple_test("BFu15i_I_BFu15s");
    static STRUCT_IF_C BFu15i_I_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_I_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu15s, BFu15i_I_BFu15s)
//============================================================================



static void Test_BFu15i_I_BFu16i()
{
  {
    init_simple_test("BFu15i_I_BFu16i");
    static STRUCT_IF_C BFu15i_I_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_I_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu16i, BFu15i_I_BFu16i)
//============================================================================



static void Test_BFu15i_I_BFu16ll()
{
  {
    init_simple_test("BFu15i_I_BFu16ll");
    static STRUCT_IF_C BFu15i_I_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_I_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu16ll, BFu15i_I_BFu16ll)
//============================================================================



static void Test_BFu15i_I_BFu16s()
{
  {
    init_simple_test("BFu15i_I_BFu16s");
    static STRUCT_IF_C BFu15i_I_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_I_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu16s, BFu15i_I_BFu16s)
//============================================================================



static void Test_BFu15i_I_BFu17i()
{
  {
    init_simple_test("BFu15i_I_BFu17i");
    static STRUCT_IF_C BFu15i_I_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu15i_I_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu15i_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu17i, BFu15i_I_BFu17i)
//============================================================================



static void Test_BFu15i_I_BFu17ll()
{
  {
    init_simple_test("BFu15i_I_BFu17ll");
    static STRUCT_IF_C BFu15i_I_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu15i_I_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu15i_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu17ll, BFu15i_I_BFu17ll)
//============================================================================



static void Test_BFu15i_I_BFu1c()
{
  {
    init_simple_test("BFu15i_I_BFu1c");
    static STRUCT_IF_C BFu15i_I_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu1c, BFu15i_I_BFu1c)
//============================================================================



static void Test_BFu15i_I_BFu1i()
{
  {
    init_simple_test("BFu15i_I_BFu1i");
    static STRUCT_IF_C BFu15i_I_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu1i, BFu15i_I_BFu1i)
//============================================================================



static void Test_BFu15i_I_BFu1ll()
{
  {
    init_simple_test("BFu15i_I_BFu1ll");
    static STRUCT_IF_C BFu15i_I_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu1ll, BFu15i_I_BFu1ll)
//============================================================================



static void Test_BFu15i_I_BFu1s()
{
  {
    init_simple_test("BFu15i_I_BFu1s");
    static STRUCT_IF_C BFu15i_I_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu1s, BFu15i_I_BFu1s)
//============================================================================



static void Test_BFu15i_I_BFu31i()
{
  {
    init_simple_test("BFu15i_I_BFu31i");
    static STRUCT_IF_C BFu15i_I_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu15i_I_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu15i_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu31i, BFu15i_I_BFu31i)
//============================================================================



static void Test_BFu15i_I_BFu31ll()
{
  {
    init_simple_test("BFu15i_I_BFu31ll");
    static STRUCT_IF_C BFu15i_I_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu15i_I_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu15i_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu31ll, BFu15i_I_BFu31ll)
//============================================================================



static void Test_BFu15i_I_BFu32i()
{
  {
    init_simple_test("BFu15i_I_BFu32i");
    static STRUCT_IF_C BFu15i_I_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu15i_I_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu15i_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu32i, BFu15i_I_BFu32i)
//============================================================================



static void Test_BFu15i_I_BFu32ll()
{
  {
    init_simple_test("BFu15i_I_BFu32ll");
    static STRUCT_IF_C BFu15i_I_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu15i_I_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu15i_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu32ll, BFu15i_I_BFu32ll)
//============================================================================



static void Test_BFu15i_I_BFu33()
{
  {
    init_simple_test("BFu15i_I_BFu33");
    static STRUCT_IF_C BFu15i_I_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "BFu15i_I_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "BFu15i_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu33, BFu15i_I_BFu33)
//============================================================================



static void Test_BFu15i_I_BFu7c()
{
  {
    init_simple_test("BFu15i_I_BFu7c");
    static STRUCT_IF_C BFu15i_I_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_I_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu7c, BFu15i_I_BFu7c)
//============================================================================



static void Test_BFu15i_I_BFu7i()
{
  {
    init_simple_test("BFu15i_I_BFu7i");
    static STRUCT_IF_C BFu15i_I_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_I_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu7i, BFu15i_I_BFu7i)
//============================================================================



static void Test_BFu15i_I_BFu7ll()
{
  {
    init_simple_test("BFu15i_I_BFu7ll");
    static STRUCT_IF_C BFu15i_I_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_I_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu7ll, BFu15i_I_BFu7ll)
//============================================================================



static void Test_BFu15i_I_BFu7s()
{
  {
    init_simple_test("BFu15i_I_BFu7s");
    static STRUCT_IF_C BFu15i_I_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_I_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu7s, BFu15i_I_BFu7s)
//============================================================================



static void Test_BFu15i_I_BFu8c()
{
  {
    init_simple_test("BFu15i_I_BFu8c");
    static STRUCT_IF_C BFu15i_I_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_I_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu8c, BFu15i_I_BFu8c)
//============================================================================



static void Test_BFu15i_I_BFu8i()
{
  {
    init_simple_test("BFu15i_I_BFu8i");
    static STRUCT_IF_C BFu15i_I_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_I_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu8i, BFu15i_I_BFu8i)
//============================================================================



static void Test_BFu15i_I_BFu8ll()
{
  {
    init_simple_test("BFu15i_I_BFu8ll");
    static STRUCT_IF_C BFu15i_I_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_I_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu8ll, BFu15i_I_BFu8ll)
//============================================================================



static void Test_BFu15i_I_BFu8s()
{
  {
    init_simple_test("BFu15i_I_BFu8s");
    static STRUCT_IF_C BFu15i_I_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_I_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu8s, BFu15i_I_BFu8s)
//============================================================================



static void Test_BFu15i_I_BFu9i()
{
  {
    init_simple_test("BFu15i_I_BFu9i");
    static STRUCT_IF_C BFu15i_I_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_I_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu9i, BFu15i_I_BFu9i)
//============================================================================



static void Test_BFu15i_I_BFu9ll()
{
  {
    init_simple_test("BFu15i_I_BFu9ll");
    static STRUCT_IF_C BFu15i_I_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_I_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu9ll, BFu15i_I_BFu9ll)
//============================================================================



static void Test_BFu15i_I_BFu9s()
{
  {
    init_simple_test("BFu15i_I_BFu9s");
    static STRUCT_IF_C BFu15i_I_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_I_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu9s, BFu15i_I_BFu9s)
//============================================================================



static void Test_BFu15i_I_C()
{
  {
    init_simple_test("BFu15i_I_C");
    static STRUCT_IF_C BFu15i_I_C lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_C");
    check_field_offset(lv, v2, 2, "BFu15i_I_C.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_C, BFu15i_I_C)
//============================================================================



static void Test_BFu15i_I_D()
{
  {
    init_simple_test("BFu15i_I_D");
    static STRUCT_IF_C BFu15i_I_D lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_D");
    check_field_offset(lv, v2, 2, "BFu15i_I_D.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_D, BFu15i_I_D)
//============================================================================



static void Test_BFu15i_I_F()
{
  {
    init_simple_test("BFu15i_I_F");
    static STRUCT_IF_C BFu15i_I_F lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_F");
    check_field_offset(lv, v2, 2, "BFu15i_I_F.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_F, BFu15i_I_F)
//============================================================================



static void Test_BFu15i_I_I()
{
  {
    init_simple_test("BFu15i_I_I");
    static STRUCT_IF_C BFu15i_I_I lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_I");
    check_field_offset(lv, v2, 2, "BFu15i_I_I.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_I, BFu15i_I_I)
//============================================================================



static void Test_BFu15i_I_Ip()
{
  {
    init_simple_test("BFu15i_I_Ip");
    static STRUCT_IF_C BFu15i_I_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_I_Ip.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_Ip, BFu15i_I_Ip)
//============================================================================



static void Test_BFu15i_I_L()
{
  {
    init_simple_test("BFu15i_I_L");
    static STRUCT_IF_C BFu15i_I_L lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_L");
    check_field_offset(lv, v2, 2, "BFu15i_I_L.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_L, BFu15i_I_L)
//============================================================================



static void Test_BFu15i_I_S()
{
  {
    init_simple_test("BFu15i_I_S");
    static STRUCT_IF_C BFu15i_I_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_S");
    check_field_offset(lv, v2, 2, "BFu15i_I_S.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_S, BFu15i_I_S)
//============================================================================



static void Test_BFu15i_I_Uc()
{
  {
    init_simple_test("BFu15i_I_Uc");
    static STRUCT_IF_C BFu15i_I_Uc lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_I_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_Uc, BFu15i_I_Uc)
//============================================================================



static void Test_BFu15i_I_Ui()
{
  {
    init_simple_test("BFu15i_I_Ui");
    static STRUCT_IF_C BFu15i_I_Ui lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_I_Ui.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_Ui, BFu15i_I_Ui)
//============================================================================



static void Test_BFu15i_I_Ul()
{
  {
    init_simple_test("BFu15i_I_Ul");
    static STRUCT_IF_C BFu15i_I_Ul lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_I_Ul.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_Ul, BFu15i_I_Ul)
//============================================================================



static void Test_BFu15i_I_Us()
{
  {
    init_simple_test("BFu15i_I_Us");
    static STRUCT_IF_C BFu15i_I_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Us");
    check_field_offset(lv, v2, 2, "BFu15i_I_Us.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_Us, BFu15i_I_Us)
//============================================================================



static void Test_BFu15i_I_Vp()
{
  {
    init_simple_test("BFu15i_I_Vp");
    static STRUCT_IF_C BFu15i_I_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_I_Vp.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_Vp, BFu15i_I_Vp)
//============================================================================



static void Test_BFu15i_Ip()
{
  {
    init_simple_test("BFu15i_Ip");
    static STRUCT_IF_C BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip, BFu15i_Ip)
//============================================================================



static void Test_BFu15i_Ip_BFu15i()
{
  {
    init_simple_test("BFu15i_Ip_BFu15i");
    static STRUCT_IF_C BFu15i_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu15i_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu15i, BFu15i_Ip_BFu15i)
//============================================================================



static void Test_BFu15i_Ip_BFu15ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu15ll");
    static STRUCT_IF_C BFu15i_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu15i_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu15ll, BFu15i_Ip_BFu15ll)
//============================================================================



static void Test_BFu15i_Ip_BFu15s()
{
  {
    init_simple_test("BFu15i_Ip_BFu15s");
    static STRUCT_IF_C BFu15i_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu15i_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu15s, BFu15i_Ip_BFu15s)
//============================================================================



static void Test_BFu15i_Ip_BFu16i()
{
  {
    init_simple_test("BFu15i_Ip_BFu16i");
    static STRUCT_IF_C BFu15i_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu15i_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu15i_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu16i, BFu15i_Ip_BFu16i)
//============================================================================



static void Test_BFu15i_Ip_BFu16ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu16ll");
    static STRUCT_IF_C BFu15i_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu15i_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu15i_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu16ll, BFu15i_Ip_BFu16ll)
//============================================================================



static void Test_BFu15i_Ip_BFu16s()
{
  {
    init_simple_test("BFu15i_Ip_BFu16s");
    static STRUCT_IF_C BFu15i_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu15i_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu15i_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu16s, BFu15i_Ip_BFu16s)
//============================================================================



static void Test_BFu15i_Ip_BFu17i()
{
  {
    init_simple_test("BFu15i_Ip_BFu17i");
    static STRUCT_IF_C BFu15i_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu15i_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu15i_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu15i_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu17i, BFu15i_Ip_BFu17i)
//============================================================================



static void Test_BFu15i_Ip_BFu17ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu17ll");
    static STRUCT_IF_C BFu15i_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu15i_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu15i_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu15i_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu17ll, BFu15i_Ip_BFu17ll)
//============================================================================



static void Test_BFu15i_Ip_BFu1c()
{
  {
    init_simple_test("BFu15i_Ip_BFu1c");
    static STRUCT_IF_C BFu15i_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu1c, BFu15i_Ip_BFu1c)
//============================================================================



static void Test_BFu15i_Ip_BFu1i()
{
  {
    init_simple_test("BFu15i_Ip_BFu1i");
    static STRUCT_IF_C BFu15i_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu1i, BFu15i_Ip_BFu1i)
//============================================================================



static void Test_BFu15i_Ip_BFu1ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu1ll");
    static STRUCT_IF_C BFu15i_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu1ll, BFu15i_Ip_BFu1ll)
//============================================================================



static void Test_BFu15i_Ip_BFu1s()
{
  {
    init_simple_test("BFu15i_Ip_BFu1s");
    static STRUCT_IF_C BFu15i_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu1s, BFu15i_Ip_BFu1s)
//============================================================================



static void Test_BFu15i_Ip_BFu31i()
{
  {
    init_simple_test("BFu15i_Ip_BFu31i");
    static STRUCT_IF_C BFu15i_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu15i_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu15i_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu31i, BFu15i_Ip_BFu31i)
//============================================================================



static void Test_BFu15i_Ip_BFu31ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu31ll");
    static STRUCT_IF_C BFu15i_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu15i_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu15i_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu31ll, BFu15i_Ip_BFu31ll)
//============================================================================



static void Test_BFu15i_Ip_BFu32i()
{
  {
    init_simple_test("BFu15i_Ip_BFu32i");
    static STRUCT_IF_C BFu15i_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu15i_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu15i_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu32i, BFu15i_Ip_BFu32i)
//============================================================================



static void Test_BFu15i_Ip_BFu32ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu32ll");
    static STRUCT_IF_C BFu15i_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu15i_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu15i_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu32ll, BFu15i_Ip_BFu32ll)
//============================================================================



static void Test_BFu15i_Ip_BFu33()
{
  {
    init_simple_test("BFu15i_Ip_BFu33");
    static STRUCT_IF_C BFu15i_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(BFu15i_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "BFu15i_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "BFu15i_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu33, BFu15i_Ip_BFu33)
//============================================================================



static void Test_BFu15i_Ip_BFu7c()
{
  {
    init_simple_test("BFu15i_Ip_BFu7c");
    static STRUCT_IF_C BFu15i_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu7c, BFu15i_Ip_BFu7c)
//============================================================================



static void Test_BFu15i_Ip_BFu7i()
{
  {
    init_simple_test("BFu15i_Ip_BFu7i");
    static STRUCT_IF_C BFu15i_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu7i, BFu15i_Ip_BFu7i)
//============================================================================



static void Test_BFu15i_Ip_BFu7ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu7ll");
    static STRUCT_IF_C BFu15i_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu7ll, BFu15i_Ip_BFu7ll)
//============================================================================



static void Test_BFu15i_Ip_BFu7s()
{
  {
    init_simple_test("BFu15i_Ip_BFu7s");
    static STRUCT_IF_C BFu15i_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu7s, BFu15i_Ip_BFu7s)
//============================================================================



static void Test_BFu15i_Ip_BFu8c()
{
  {
    init_simple_test("BFu15i_Ip_BFu8c");
    static STRUCT_IF_C BFu15i_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu8c, BFu15i_Ip_BFu8c)
//============================================================================



static void Test_BFu15i_Ip_BFu8i()
{
  {
    init_simple_test("BFu15i_Ip_BFu8i");
    static STRUCT_IF_C BFu15i_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu8i, BFu15i_Ip_BFu8i)
//============================================================================



static void Test_BFu15i_Ip_BFu8ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu8ll");
    static STRUCT_IF_C BFu15i_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu8ll, BFu15i_Ip_BFu8ll)
//============================================================================



static void Test_BFu15i_Ip_BFu8s()
{
  {
    init_simple_test("BFu15i_Ip_BFu8s");
    static STRUCT_IF_C BFu15i_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu8s, BFu15i_Ip_BFu8s)
//============================================================================



static void Test_BFu15i_Ip_BFu9i()
{
  {
    init_simple_test("BFu15i_Ip_BFu9i");
    static STRUCT_IF_C BFu15i_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu15i_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu15i_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu9i, BFu15i_Ip_BFu9i)
//============================================================================



static void Test_BFu15i_Ip_BFu9ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu9ll");
    static STRUCT_IF_C BFu15i_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu15i_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu15i_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu9ll, BFu15i_Ip_BFu9ll)
//============================================================================



static void Test_BFu15i_Ip_BFu9s()
{
  {
    init_simple_test("BFu15i_Ip_BFu9s");
    static STRUCT_IF_C BFu15i_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu15i_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu15i_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu9s, BFu15i_Ip_BFu9s)
//============================================================================



static void Test_BFu15i_Ip_C()
{
  {
    init_simple_test("BFu15i_Ip_C");
    static STRUCT_IF_C BFu15i_Ip_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_C");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_C, BFu15i_Ip_C)
//============================================================================



static void Test_BFu15i_Ip_D()
{
  {
    init_simple_test("BFu15i_Ip_D");
    static STRUCT_IF_C BFu15i_Ip_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_D");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_D, BFu15i_Ip_D)
//============================================================================



static void Test_BFu15i_Ip_F()
{
  {
    init_simple_test("BFu15i_Ip_F");
    static STRUCT_IF_C BFu15i_Ip_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_F");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_F, BFu15i_Ip_F)
//============================================================================



static void Test_BFu15i_Ip_I()
{
  {
    init_simple_test("BFu15i_Ip_I");
    static STRUCT_IF_C BFu15i_Ip_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_I");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_I, BFu15i_Ip_I)
//============================================================================



static void Test_BFu15i_Ip_Ip()
{
  {
    init_simple_test("BFu15i_Ip_Ip");
    static STRUCT_IF_C BFu15i_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu15i_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_Ip, BFu15i_Ip_Ip)
//============================================================================



static void Test_BFu15i_Ip_L()
{
  {
    init_simple_test("BFu15i_Ip_L");
    static STRUCT_IF_C BFu15i_Ip_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_L");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_L, BFu15i_Ip_L)
//============================================================================



static void Test_BFu15i_Ip_S()
{
  {
    init_simple_test("BFu15i_Ip_S");
    static STRUCT_IF_C BFu15i_Ip_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_S");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_S, BFu15i_Ip_S)
//============================================================================



static void Test_BFu15i_Ip_Uc()
{
  {
    init_simple_test("BFu15i_Ip_Uc");
    static STRUCT_IF_C BFu15i_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_Uc, BFu15i_Ip_Uc)
//============================================================================



static void Test_BFu15i_Ip_Ui()
{
  {
    init_simple_test("BFu15i_Ip_Ui");
    static STRUCT_IF_C BFu15i_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_Ui, BFu15i_Ip_Ui)
//============================================================================



static void Test_BFu15i_Ip_Ul()
{
  {
    init_simple_test("BFu15i_Ip_Ul");
    static STRUCT_IF_C BFu15i_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_Ul, BFu15i_Ip_Ul)
//============================================================================



static void Test_BFu15i_Ip_Us()
{
  {
    init_simple_test("BFu15i_Ip_Us");
    static STRUCT_IF_C BFu15i_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_Us, BFu15i_Ip_Us)
//============================================================================



static void Test_BFu15i_Ip_Vp()
{
  {
    init_simple_test("BFu15i_Ip_Vp");
    static STRUCT_IF_C BFu15i_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu15i_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_Vp, BFu15i_Ip_Vp)
//============================================================================



static void Test_BFu15i_L()
{
  {
    init_simple_test("BFu15i_L");
    static STRUCT_IF_C BFu15i_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L");
    check_field_offset(lv, v2, 2, "BFu15i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L, BFu15i_L)
//============================================================================



static void Test_BFu15i_L_BFu15i()
{
  {
    init_simple_test("BFu15i_L_BFu15i");
    static STRUCT_IF_C BFu15i_L_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_L_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu15i, BFu15i_L_BFu15i)
//============================================================================



static void Test_BFu15i_L_BFu15ll()
{
  {
    init_simple_test("BFu15i_L_BFu15ll");
    static STRUCT_IF_C BFu15i_L_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_L_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu15ll, BFu15i_L_BFu15ll)
//============================================================================



static void Test_BFu15i_L_BFu15s()
{
  {
    init_simple_test("BFu15i_L_BFu15s");
    static STRUCT_IF_C BFu15i_L_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_L_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu15s, BFu15i_L_BFu15s)
//============================================================================



static void Test_BFu15i_L_BFu16i()
{
  {
    init_simple_test("BFu15i_L_BFu16i");
    static STRUCT_IF_C BFu15i_L_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_L_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu16i, BFu15i_L_BFu16i)
//============================================================================



static void Test_BFu15i_L_BFu16ll()
{
  {
    init_simple_test("BFu15i_L_BFu16ll");
    static STRUCT_IF_C BFu15i_L_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_L_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu16ll, BFu15i_L_BFu16ll)
//============================================================================



static void Test_BFu15i_L_BFu16s()
{
  {
    init_simple_test("BFu15i_L_BFu16s");
    static STRUCT_IF_C BFu15i_L_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_L_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu16s, BFu15i_L_BFu16s)
//============================================================================



static void Test_BFu15i_L_BFu17i()
{
  {
    init_simple_test("BFu15i_L_BFu17i");
    static STRUCT_IF_C BFu15i_L_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(BFu15i_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu15i_L_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu15i_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu17i, BFu15i_L_BFu17i)
//============================================================================



static void Test_BFu15i_L_BFu17ll()
{
  {
    init_simple_test("BFu15i_L_BFu17ll");
    static STRUCT_IF_C BFu15i_L_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu15i_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu15i_L_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu15i_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu17ll, BFu15i_L_BFu17ll)
//============================================================================



static void Test_BFu15i_L_BFu1c()
{
  {
    init_simple_test("BFu15i_L_BFu1c");
    static STRUCT_IF_C BFu15i_L_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu1c, BFu15i_L_BFu1c)
//============================================================================



static void Test_BFu15i_L_BFu1i()
{
  {
    init_simple_test("BFu15i_L_BFu1i");
    static STRUCT_IF_C BFu15i_L_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu1i, BFu15i_L_BFu1i)
//============================================================================



static void Test_BFu15i_L_BFu1ll()
{
  {
    init_simple_test("BFu15i_L_BFu1ll");
    static STRUCT_IF_C BFu15i_L_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu1ll, BFu15i_L_BFu1ll)
//============================================================================



static void Test_BFu15i_L_BFu1s()
{
  {
    init_simple_test("BFu15i_L_BFu1s");
    static STRUCT_IF_C BFu15i_L_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu1s, BFu15i_L_BFu1s)
//============================================================================



static void Test_BFu15i_L_BFu31i()
{
  {
    init_simple_test("BFu15i_L_BFu31i");
    static STRUCT_IF_C BFu15i_L_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu15i_L_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu15i_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu31i, BFu15i_L_BFu31i)
//============================================================================



static void Test_BFu15i_L_BFu31ll()
{
  {
    init_simple_test("BFu15i_L_BFu31ll");
    static STRUCT_IF_C BFu15i_L_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu15i_L_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu15i_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu31ll, BFu15i_L_BFu31ll)
//============================================================================



static void Test_BFu15i_L_BFu32i()
{
  {
    init_simple_test("BFu15i_L_BFu32i");
    static STRUCT_IF_C BFu15i_L_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu15i_L_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu15i_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu32i, BFu15i_L_BFu32i)
//============================================================================



static void Test_BFu15i_L_BFu32ll()
{
  {
    init_simple_test("BFu15i_L_BFu32ll");
    static STRUCT_IF_C BFu15i_L_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu15i_L_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu15i_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu32ll, BFu15i_L_BFu32ll)
//============================================================================



static void Test_BFu15i_L_BFu33()
{
  {
    init_simple_test("BFu15i_L_BFu33");
    static STRUCT_IF_C BFu15i_L_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(BFu15i_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "BFu15i_L_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "BFu15i_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu33, BFu15i_L_BFu33)
//============================================================================



static void Test_BFu15i_L_BFu7c()
{
  {
    init_simple_test("BFu15i_L_BFu7c");
    static STRUCT_IF_C BFu15i_L_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_L_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu7c, BFu15i_L_BFu7c)
//============================================================================



static void Test_BFu15i_L_BFu7i()
{
  {
    init_simple_test("BFu15i_L_BFu7i");
    static STRUCT_IF_C BFu15i_L_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_L_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu7i, BFu15i_L_BFu7i)
//============================================================================



static void Test_BFu15i_L_BFu7ll()
{
  {
    init_simple_test("BFu15i_L_BFu7ll");
    static STRUCT_IF_C BFu15i_L_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_L_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu7ll, BFu15i_L_BFu7ll)
//============================================================================



static void Test_BFu15i_L_BFu7s()
{
  {
    init_simple_test("BFu15i_L_BFu7s");
    static STRUCT_IF_C BFu15i_L_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_L_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu7s, BFu15i_L_BFu7s)
//============================================================================



static void Test_BFu15i_L_BFu8c()
{
  {
    init_simple_test("BFu15i_L_BFu8c");
    static STRUCT_IF_C BFu15i_L_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_L_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu8c, BFu15i_L_BFu8c)
//============================================================================



static void Test_BFu15i_L_BFu8i()
{
  {
    init_simple_test("BFu15i_L_BFu8i");
    static STRUCT_IF_C BFu15i_L_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_L_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu8i, BFu15i_L_BFu8i)
//============================================================================



static void Test_BFu15i_L_BFu8ll()
{
  {
    init_simple_test("BFu15i_L_BFu8ll");
    static STRUCT_IF_C BFu15i_L_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_L_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu8ll, BFu15i_L_BFu8ll)
//============================================================================



static void Test_BFu15i_L_BFu8s()
{
  {
    init_simple_test("BFu15i_L_BFu8s");
    static STRUCT_IF_C BFu15i_L_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_L_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu8s, BFu15i_L_BFu8s)
//============================================================================



static void Test_BFu15i_L_BFu9i()
{
  {
    init_simple_test("BFu15i_L_BFu9i");
    static STRUCT_IF_C BFu15i_L_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_L_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu9i, BFu15i_L_BFu9i)
//============================================================================



static void Test_BFu15i_L_BFu9ll()
{
  {
    init_simple_test("BFu15i_L_BFu9ll");
    static STRUCT_IF_C BFu15i_L_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_L_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu9ll, BFu15i_L_BFu9ll)
//============================================================================



static void Test_BFu15i_L_BFu9s()
{
  {
    init_simple_test("BFu15i_L_BFu9s");
    static STRUCT_IF_C BFu15i_L_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_L_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu9s, BFu15i_L_BFu9s)
//============================================================================



static void Test_BFu15i_L_C()
{
  {
    init_simple_test("BFu15i_L_C");
    static STRUCT_IF_C BFu15i_L_C lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_C");
    check_field_offset(lv, v2, 2, "BFu15i_L_C.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_C, BFu15i_L_C)
//============================================================================



static void Test_BFu15i_L_D()
{
  {
    init_simple_test("BFu15i_L_D");
    static STRUCT_IF_C BFu15i_L_D lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_D");
    check_field_offset(lv, v2, 2, "BFu15i_L_D.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_D, BFu15i_L_D)
//============================================================================



static void Test_BFu15i_L_F()
{
  {
    init_simple_test("BFu15i_L_F");
    static STRUCT_IF_C BFu15i_L_F lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_F");
    check_field_offset(lv, v2, 2, "BFu15i_L_F.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_F, BFu15i_L_F)
//============================================================================



static void Test_BFu15i_L_I()
{
  {
    init_simple_test("BFu15i_L_I");
    static STRUCT_IF_C BFu15i_L_I lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_I");
    check_field_offset(lv, v2, 2, "BFu15i_L_I.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_I, BFu15i_L_I)
//============================================================================



static void Test_BFu15i_L_Ip()
{
  {
    init_simple_test("BFu15i_L_Ip");
    static STRUCT_IF_C BFu15i_L_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_L_Ip.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_Ip, BFu15i_L_Ip)
//============================================================================



static void Test_BFu15i_L_L()
{
  {
    init_simple_test("BFu15i_L_L");
    static STRUCT_IF_C BFu15i_L_L lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_L");
    check_field_offset(lv, v2, 2, "BFu15i_L_L.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_L, BFu15i_L_L)
//============================================================================



static void Test_BFu15i_L_S()
{
  {
    init_simple_test("BFu15i_L_S");
    static STRUCT_IF_C BFu15i_L_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_S");
    check_field_offset(lv, v2, 2, "BFu15i_L_S.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_S, BFu15i_L_S)
//============================================================================



static void Test_BFu15i_L_Uc()
{
  {
    init_simple_test("BFu15i_L_Uc");
    static STRUCT_IF_C BFu15i_L_Uc lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_L_Uc.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_Uc, BFu15i_L_Uc)
//============================================================================



static void Test_BFu15i_L_Ui()
{
  {
    init_simple_test("BFu15i_L_Ui");
    static STRUCT_IF_C BFu15i_L_Ui lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_L_Ui.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_Ui, BFu15i_L_Ui)
//============================================================================



static void Test_BFu15i_L_Ul()
{
  {
    init_simple_test("BFu15i_L_Ul");
    static STRUCT_IF_C BFu15i_L_Ul lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_L_Ul.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_Ul, BFu15i_L_Ul)
//============================================================================



static void Test_BFu15i_L_Us()
{
  {
    init_simple_test("BFu15i_L_Us");
    static STRUCT_IF_C BFu15i_L_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Us");
    check_field_offset(lv, v2, 2, "BFu15i_L_Us.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_Us, BFu15i_L_Us)
//============================================================================



static void Test_BFu15i_L_Vp()
{
  {
    init_simple_test("BFu15i_L_Vp");
    static STRUCT_IF_C BFu15i_L_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_L_Vp.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_Vp, BFu15i_L_Vp)
//============================================================================



static void Test_BFu15i_S()
{
  {
    init_simple_test("BFu15i_S");
    static STRUCT_IF_C BFu15i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S");
    check_field_offset(lv, v2, 2, "BFu15i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S, BFu15i_S)
//============================================================================



static void Test_BFu15i_S_BFu15i()
{
  {
    init_simple_test("BFu15i_S_BFu15i");
    static STRUCT_IF_C BFu15i_S_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_S_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu15i, BFu15i_S_BFu15i)
//============================================================================



static void Test_BFu15i_S_BFu15ll()
{
  {
    init_simple_test("BFu15i_S_BFu15ll");
    static STRUCT_IF_C BFu15i_S_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_S_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu15ll, BFu15i_S_BFu15ll)
//============================================================================



static void Test_BFu15i_S_BFu15s()
{
  {
    init_simple_test("BFu15i_S_BFu15s");
    static STRUCT_IF_C BFu15i_S_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_S_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu15s, BFu15i_S_BFu15s)
//============================================================================



static void Test_BFu15i_S_BFu16i()
{
  {
    init_simple_test("BFu15i_S_BFu16i");
    static STRUCT_IF_C BFu15i_S_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_S_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu16i, BFu15i_S_BFu16i)
//============================================================================



static void Test_BFu15i_S_BFu16ll()
{
  {
    init_simple_test("BFu15i_S_BFu16ll");
    static STRUCT_IF_C BFu15i_S_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_S_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu16ll, BFu15i_S_BFu16ll)
//============================================================================



static void Test_BFu15i_S_BFu16s()
{
  {
    init_simple_test("BFu15i_S_BFu16s");
    static STRUCT_IF_C BFu15i_S_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_S_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu16s, BFu15i_S_BFu16s)
//============================================================================



static void Test_BFu15i_S_BFu17i()
{
  {
    init_simple_test("BFu15i_S_BFu17i");
    static STRUCT_IF_C BFu15i_S_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15i_S_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu17i, BFu15i_S_BFu17i)
//============================================================================



static void Test_BFu15i_S_BFu17ll()
{
  {
    init_simple_test("BFu15i_S_BFu17ll");
    static STRUCT_IF_C BFu15i_S_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15i_S_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu17ll, BFu15i_S_BFu17ll)
//============================================================================



static void Test_BFu15i_S_BFu1c()
{
  {
    init_simple_test("BFu15i_S_BFu1c");
    static STRUCT_IF_C BFu15i_S_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu1c, BFu15i_S_BFu1c)
//============================================================================



static void Test_BFu15i_S_BFu1i()
{
  {
    init_simple_test("BFu15i_S_BFu1i");
    static STRUCT_IF_C BFu15i_S_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu1i, BFu15i_S_BFu1i)
//============================================================================



static void Test_BFu15i_S_BFu1ll()
{
  {
    init_simple_test("BFu15i_S_BFu1ll");
    static STRUCT_IF_C BFu15i_S_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu1ll, BFu15i_S_BFu1ll)
//============================================================================



static void Test_BFu15i_S_BFu1s()
{
  {
    init_simple_test("BFu15i_S_BFu1s");
    static STRUCT_IF_C BFu15i_S_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu1s, BFu15i_S_BFu1s)
//============================================================================



static void Test_BFu15i_S_BFu31i()
{
  {
    init_simple_test("BFu15i_S_BFu31i");
    static STRUCT_IF_C BFu15i_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15i_S_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu31i, BFu15i_S_BFu31i)
//============================================================================



static void Test_BFu15i_S_BFu31ll()
{
  {
    init_simple_test("BFu15i_S_BFu31ll");
    static STRUCT_IF_C BFu15i_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15i_S_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu31ll, BFu15i_S_BFu31ll)
//============================================================================



static void Test_BFu15i_S_BFu32i()
{
  {
    init_simple_test("BFu15i_S_BFu32i");
    static STRUCT_IF_C BFu15i_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15i_S_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu32i, BFu15i_S_BFu32i)
//============================================================================



static void Test_BFu15i_S_BFu32ll()
{
  {
    init_simple_test("BFu15i_S_BFu32ll");
    static STRUCT_IF_C BFu15i_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15i_S_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu32ll, BFu15i_S_BFu32ll)
//============================================================================



static void Test_BFu15i_S_BFu33()
{
  {
    init_simple_test("BFu15i_S_BFu33");
    static STRUCT_IF_C BFu15i_S_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu15i_S_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu15i_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu33, BFu15i_S_BFu33)
//============================================================================



static void Test_BFu15i_S_BFu7c()
{
  {
    init_simple_test("BFu15i_S_BFu7c");
    static STRUCT_IF_C BFu15i_S_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_S_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu7c, BFu15i_S_BFu7c)
//============================================================================



static void Test_BFu15i_S_BFu7i()
{
  {
    init_simple_test("BFu15i_S_BFu7i");
    static STRUCT_IF_C BFu15i_S_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_S_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu7i, BFu15i_S_BFu7i)
//============================================================================



static void Test_BFu15i_S_BFu7ll()
{
  {
    init_simple_test("BFu15i_S_BFu7ll");
    static STRUCT_IF_C BFu15i_S_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_S_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu7ll, BFu15i_S_BFu7ll)
//============================================================================



static void Test_BFu15i_S_BFu7s()
{
  {
    init_simple_test("BFu15i_S_BFu7s");
    static STRUCT_IF_C BFu15i_S_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_S_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu7s, BFu15i_S_BFu7s)
//============================================================================



static void Test_BFu15i_S_BFu8c()
{
  {
    init_simple_test("BFu15i_S_BFu8c");
    static STRUCT_IF_C BFu15i_S_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_S_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu8c, BFu15i_S_BFu8c)
//============================================================================



static void Test_BFu15i_S_BFu8i()
{
  {
    init_simple_test("BFu15i_S_BFu8i");
    static STRUCT_IF_C BFu15i_S_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_S_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu8i, BFu15i_S_BFu8i)
//============================================================================



static void Test_BFu15i_S_BFu8ll()
{
  {
    init_simple_test("BFu15i_S_BFu8ll");
    static STRUCT_IF_C BFu15i_S_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_S_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu8ll, BFu15i_S_BFu8ll)
//============================================================================



static void Test_BFu15i_S_BFu8s()
{
  {
    init_simple_test("BFu15i_S_BFu8s");
    static STRUCT_IF_C BFu15i_S_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_S_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu8s, BFu15i_S_BFu8s)
//============================================================================



static void Test_BFu15i_S_BFu9i()
{
  {
    init_simple_test("BFu15i_S_BFu9i");
    static STRUCT_IF_C BFu15i_S_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_S_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu9i, BFu15i_S_BFu9i)
//============================================================================



static void Test_BFu15i_S_BFu9ll()
{
  {
    init_simple_test("BFu15i_S_BFu9ll");
    static STRUCT_IF_C BFu15i_S_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_S_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu9ll, BFu15i_S_BFu9ll)
//============================================================================



static void Test_BFu15i_S_BFu9s()
{
  {
    init_simple_test("BFu15i_S_BFu9s");
    static STRUCT_IF_C BFu15i_S_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_S_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu9s, BFu15i_S_BFu9s)
//============================================================================



static void Test_BFu15i_S_C()
{
  {
    init_simple_test("BFu15i_S_C");
    static STRUCT_IF_C BFu15i_S_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_C");
    check_field_offset(lv, v2, 2, "BFu15i_S_C.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_C, BFu15i_S_C)
//============================================================================



static void Test_BFu15i_S_D()
{
  {
    init_simple_test("BFu15i_S_D");
    static STRUCT_IF_C BFu15i_S_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_D");
    check_field_offset(lv, v2, 2, "BFu15i_S_D.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_D, BFu15i_S_D)
//============================================================================



static void Test_BFu15i_S_F()
{
  {
    init_simple_test("BFu15i_S_F");
    static STRUCT_IF_C BFu15i_S_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_F");
    check_field_offset(lv, v2, 2, "BFu15i_S_F.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_F, BFu15i_S_F)
//============================================================================



static void Test_BFu15i_S_I()
{
  {
    init_simple_test("BFu15i_S_I");
    static STRUCT_IF_C BFu15i_S_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_I");
    check_field_offset(lv, v2, 2, "BFu15i_S_I.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_I, BFu15i_S_I)
//============================================================================



static void Test_BFu15i_S_Ip()
{
  {
    init_simple_test("BFu15i_S_Ip");
    static STRUCT_IF_C BFu15i_S_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_S_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_Ip, BFu15i_S_Ip)
//============================================================================



static void Test_BFu15i_S_L()
{
  {
    init_simple_test("BFu15i_S_L");
    static STRUCT_IF_C BFu15i_S_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_L");
    check_field_offset(lv, v2, 2, "BFu15i_S_L.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_L, BFu15i_S_L)
//============================================================================



static void Test_BFu15i_S_S()
{
  {
    init_simple_test("BFu15i_S_S");
    static STRUCT_IF_C BFu15i_S_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_S");
    check_field_offset(lv, v2, 2, "BFu15i_S_S.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_S, BFu15i_S_S)
//============================================================================



static void Test_BFu15i_S_Uc()
{
  {
    init_simple_test("BFu15i_S_Uc");
    static STRUCT_IF_C BFu15i_S_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_S_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_Uc, BFu15i_S_Uc)
//============================================================================



static void Test_BFu15i_S_Ui()
{
  {
    init_simple_test("BFu15i_S_Ui");
    static STRUCT_IF_C BFu15i_S_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_S_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_Ui, BFu15i_S_Ui)
//============================================================================



static void Test_BFu15i_S_Ul()
{
  {
    init_simple_test("BFu15i_S_Ul");
    static STRUCT_IF_C BFu15i_S_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_S_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_Ul, BFu15i_S_Ul)
//============================================================================



static void Test_BFu15i_S_Us()
{
  {
    init_simple_test("BFu15i_S_Us");
    static STRUCT_IF_C BFu15i_S_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Us");
    check_field_offset(lv, v2, 2, "BFu15i_S_Us.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_Us, BFu15i_S_Us)
//============================================================================



static void Test_BFu15i_S_Vp()
{
  {
    init_simple_test("BFu15i_S_Vp");
    static STRUCT_IF_C BFu15i_S_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_S_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_Vp, BFu15i_S_Vp)
//============================================================================



static void Test_BFu15i_Uc()
{
  {
    init_simple_test("BFu15i_Uc");
    static STRUCT_IF_C BFu15i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc, BFu15i_Uc)
//============================================================================



static void Test_BFu15i_Uc_BFu15i()
{
  {
    init_simple_test("BFu15i_Uc_BFu15i");
    static STRUCT_IF_C BFu15i_Uc_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_Uc_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu15i, BFu15i_Uc_BFu15i)
//============================================================================



static void Test_BFu15i_Uc_BFu15ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu15ll");
    static STRUCT_IF_C BFu15i_Uc_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu15ll, BFu15i_Uc_BFu15ll)
//============================================================================



static void Test_BFu15i_Uc_BFu15s()
{
  {
    init_simple_test("BFu15i_Uc_BFu15s");
    static STRUCT_IF_C BFu15i_Uc_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_Uc_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu15s, BFu15i_Uc_BFu15s)
//============================================================================



static void Test_BFu15i_Uc_BFu16i()
{
  {
    init_simple_test("BFu15i_Uc_BFu16i");
    static STRUCT_IF_C BFu15i_Uc_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_Uc_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu16i, BFu15i_Uc_BFu16i)
//============================================================================



static void Test_BFu15i_Uc_BFu16ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu16ll");
    static STRUCT_IF_C BFu15i_Uc_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu16ll, BFu15i_Uc_BFu16ll)
//============================================================================



static void Test_BFu15i_Uc_BFu16s()
{
  {
    init_simple_test("BFu15i_Uc_BFu16s");
    static STRUCT_IF_C BFu15i_Uc_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_Uc_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu16s, BFu15i_Uc_BFu16s)
//============================================================================



static void Test_BFu15i_Uc_BFu17i()
{
  {
    init_simple_test("BFu15i_Uc_BFu17i");
    static STRUCT_IF_C BFu15i_Uc_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_Uc_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu17i, BFu15i_Uc_BFu17i)
//============================================================================



static void Test_BFu15i_Uc_BFu17ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu17ll");
    static STRUCT_IF_C BFu15i_Uc_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu17ll, BFu15i_Uc_BFu17ll)
//============================================================================



static void Test_BFu15i_Uc_BFu1c()
{
  {
    init_simple_test("BFu15i_Uc_BFu1c");
    static STRUCT_IF_C BFu15i_Uc_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu1c, BFu15i_Uc_BFu1c)
//============================================================================



static void Test_BFu15i_Uc_BFu1i()
{
  {
    init_simple_test("BFu15i_Uc_BFu1i");
    static STRUCT_IF_C BFu15i_Uc_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu1i, BFu15i_Uc_BFu1i)
//============================================================================



static void Test_BFu15i_Uc_BFu1ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu1ll");
    static STRUCT_IF_C BFu15i_Uc_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu1ll, BFu15i_Uc_BFu1ll)
//============================================================================



static void Test_BFu15i_Uc_BFu1s()
{
  {
    init_simple_test("BFu15i_Uc_BFu1s");
    static STRUCT_IF_C BFu15i_Uc_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu1s, BFu15i_Uc_BFu1s)
//============================================================================



static void Test_BFu15i_Uc_BFu31i()
{
  {
    init_simple_test("BFu15i_Uc_BFu31i");
    static STRUCT_IF_C BFu15i_Uc_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_Uc_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu31i, BFu15i_Uc_BFu31i)
//============================================================================



static void Test_BFu15i_Uc_BFu31ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu31ll");
    static STRUCT_IF_C BFu15i_Uc_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu31ll, BFu15i_Uc_BFu31ll)
//============================================================================



static void Test_BFu15i_Uc_BFu32i()
{
  {
    init_simple_test("BFu15i_Uc_BFu32i");
    static STRUCT_IF_C BFu15i_Uc_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_Uc_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu32i, BFu15i_Uc_BFu32i)
//============================================================================



static void Test_BFu15i_Uc_BFu32ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu32ll");
    static STRUCT_IF_C BFu15i_Uc_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu32ll, BFu15i_Uc_BFu32ll)
//============================================================================



static void Test_BFu15i_Uc_BFu33()
{
  {
    init_simple_test("BFu15i_Uc_BFu33");
    static STRUCT_IF_C BFu15i_Uc_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_Uc_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu33, BFu15i_Uc_BFu33)
//============================================================================



static void Test_BFu15i_Uc_BFu7c()
{
  {
    init_simple_test("BFu15i_Uc_BFu7c");
    static STRUCT_IF_C BFu15i_Uc_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Uc_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu7c, BFu15i_Uc_BFu7c)
//============================================================================



static void Test_BFu15i_Uc_BFu7i()
{
  {
    init_simple_test("BFu15i_Uc_BFu7i");
    static STRUCT_IF_C BFu15i_Uc_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Uc_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu7i, BFu15i_Uc_BFu7i)
//============================================================================



static void Test_BFu15i_Uc_BFu7ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu7ll");
    static STRUCT_IF_C BFu15i_Uc_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu7ll, BFu15i_Uc_BFu7ll)
//============================================================================



static void Test_BFu15i_Uc_BFu7s()
{
  {
    init_simple_test("BFu15i_Uc_BFu7s");
    static STRUCT_IF_C BFu15i_Uc_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Uc_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu7s, BFu15i_Uc_BFu7s)
//============================================================================



static void Test_BFu15i_Uc_BFu8c()
{
  {
    init_simple_test("BFu15i_Uc_BFu8c");
    static STRUCT_IF_C BFu15i_Uc_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Uc_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu8c, BFu15i_Uc_BFu8c)
//============================================================================



static void Test_BFu15i_Uc_BFu8i()
{
  {
    init_simple_test("BFu15i_Uc_BFu8i");
    static STRUCT_IF_C BFu15i_Uc_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Uc_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu8i, BFu15i_Uc_BFu8i)
//============================================================================



static void Test_BFu15i_Uc_BFu8ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu8ll");
    static STRUCT_IF_C BFu15i_Uc_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu8ll, BFu15i_Uc_BFu8ll)
//============================================================================



static void Test_BFu15i_Uc_BFu8s()
{
  {
    init_simple_test("BFu15i_Uc_BFu8s");
    static STRUCT_IF_C BFu15i_Uc_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Uc_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu8s, BFu15i_Uc_BFu8s)
//============================================================================



static void Test_BFu15i_Uc_BFu9i()
{
  {
    init_simple_test("BFu15i_Uc_BFu9i");
    static STRUCT_IF_C BFu15i_Uc_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_Uc_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu9i, BFu15i_Uc_BFu9i)
//============================================================================



static void Test_BFu15i_Uc_BFu9ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu9ll");
    static STRUCT_IF_C BFu15i_Uc_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu9ll, BFu15i_Uc_BFu9ll)
//============================================================================



static void Test_BFu15i_Uc_BFu9s()
{
  {
    init_simple_test("BFu15i_Uc_BFu9s");
    static STRUCT_IF_C BFu15i_Uc_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_Uc_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu9s, BFu15i_Uc_BFu9s)
//============================================================================



static void Test_BFu15i_Uc_C()
{
  {
    init_simple_test("BFu15i_Uc_C");
    static STRUCT_IF_C BFu15i_Uc_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_C");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_C.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_C, BFu15i_Uc_C)
//============================================================================



static void Test_BFu15i_Uc_D()
{
  {
    init_simple_test("BFu15i_Uc_D");
    static STRUCT_IF_C BFu15i_Uc_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_D");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_D.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_D, BFu15i_Uc_D)
//============================================================================



static void Test_BFu15i_Uc_F()
{
  {
    init_simple_test("BFu15i_Uc_F");
    static STRUCT_IF_C BFu15i_Uc_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_F");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_F.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_F, BFu15i_Uc_F)
//============================================================================



static void Test_BFu15i_Uc_I()
{
  {
    init_simple_test("BFu15i_Uc_I");
    static STRUCT_IF_C BFu15i_Uc_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_I");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_I.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_I, BFu15i_Uc_I)
//============================================================================



static void Test_BFu15i_Uc_Ip()
{
  {
    init_simple_test("BFu15i_Uc_Ip");
    static STRUCT_IF_C BFu15i_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_Ip, BFu15i_Uc_Ip)
//============================================================================



static void Test_BFu15i_Uc_L()
{
  {
    init_simple_test("BFu15i_Uc_L");
    static STRUCT_IF_C BFu15i_Uc_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_L");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_L.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_L, BFu15i_Uc_L)
//============================================================================



static void Test_BFu15i_Uc_S()
{
  {
    init_simple_test("BFu15i_Uc_S");
    static STRUCT_IF_C BFu15i_Uc_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_S");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_S.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_S, BFu15i_Uc_S)
//============================================================================



static void Test_BFu15i_Uc_Uc()
{
  {
    init_simple_test("BFu15i_Uc_Uc");
    static STRUCT_IF_C BFu15i_Uc_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_Uc, BFu15i_Uc_Uc)
//============================================================================



static void Test_BFu15i_Uc_Ui()
{
  {
    init_simple_test("BFu15i_Uc_Ui");
    static STRUCT_IF_C BFu15i_Uc_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_Ui, BFu15i_Uc_Ui)
//============================================================================



static void Test_BFu15i_Uc_Ul()
{
  {
    init_simple_test("BFu15i_Uc_Ul");
    static STRUCT_IF_C BFu15i_Uc_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_Ul, BFu15i_Uc_Ul)
//============================================================================



static void Test_BFu15i_Uc_Us()
{
  {
    init_simple_test("BFu15i_Uc_Us");
    static STRUCT_IF_C BFu15i_Uc_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Us.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_Us, BFu15i_Uc_Us)
//============================================================================



static void Test_BFu15i_Uc_Vp()
{
  {
    init_simple_test("BFu15i_Uc_Vp");
    static STRUCT_IF_C BFu15i_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_Vp, BFu15i_Uc_Vp)
//============================================================================



static void Test_BFu15i_Ui()
{
  {
    init_simple_test("BFu15i_Ui");
    static STRUCT_IF_C BFu15i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui, BFu15i_Ui)
//============================================================================



static void Test_BFu15i_Ui_BFu15i()
{
  {
    init_simple_test("BFu15i_Ui_BFu15i");
    static STRUCT_IF_C BFu15i_Ui_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_Ui_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu15i, BFu15i_Ui_BFu15i)
//============================================================================



static void Test_BFu15i_Ui_BFu15ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu15ll");
    static STRUCT_IF_C BFu15i_Ui_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu15ll, BFu15i_Ui_BFu15ll)
//============================================================================



static void Test_BFu15i_Ui_BFu15s()
{
  {
    init_simple_test("BFu15i_Ui_BFu15s");
    static STRUCT_IF_C BFu15i_Ui_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu15i_Ui_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu15s, BFu15i_Ui_BFu15s)
//============================================================================



static void Test_BFu15i_Ui_BFu16i()
{
  {
    init_simple_test("BFu15i_Ui_BFu16i");
    static STRUCT_IF_C BFu15i_Ui_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_Ui_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu16i, BFu15i_Ui_BFu16i)
//============================================================================



static void Test_BFu15i_Ui_BFu16ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu16ll");
    static STRUCT_IF_C BFu15i_Ui_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu16ll, BFu15i_Ui_BFu16ll)
//============================================================================



static void Test_BFu15i_Ui_BFu16s()
{
  {
    init_simple_test("BFu15i_Ui_BFu16s");
    static STRUCT_IF_C BFu15i_Ui_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu15i_Ui_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu15i_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu16s, BFu15i_Ui_BFu16s)
//============================================================================



static void Test_BFu15i_Ui_BFu17i()
{
  {
    init_simple_test("BFu15i_Ui_BFu17i");
    static STRUCT_IF_C BFu15i_Ui_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu15i_Ui_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu15i_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu17i, BFu15i_Ui_BFu17i)
//============================================================================



static void Test_BFu15i_Ui_BFu17ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu17ll");
    static STRUCT_IF_C BFu15i_Ui_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "BFu15i_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "BFu15i_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu17ll, BFu15i_Ui_BFu17ll)
//============================================================================



static void Test_BFu15i_Ui_BFu1c()
{
  {
    init_simple_test("BFu15i_Ui_BFu1c");
    static STRUCT_IF_C BFu15i_Ui_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu1c, BFu15i_Ui_BFu1c)
//============================================================================



static void Test_BFu15i_Ui_BFu1i()
{
  {
    init_simple_test("BFu15i_Ui_BFu1i");
    static STRUCT_IF_C BFu15i_Ui_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu1i, BFu15i_Ui_BFu1i)
//============================================================================



static void Test_BFu15i_Ui_BFu1ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu1ll");
    static STRUCT_IF_C BFu15i_Ui_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu1ll, BFu15i_Ui_BFu1ll)
//============================================================================



static void Test_BFu15i_Ui_BFu1s()
{
  {
    init_simple_test("BFu15i_Ui_BFu1s");
    static STRUCT_IF_C BFu15i_Ui_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu15i_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu1s, BFu15i_Ui_BFu1s)
//============================================================================



static void Test_BFu15i_Ui_BFu31i()
{
  {
    init_simple_test("BFu15i_Ui_BFu31i");
    static STRUCT_IF_C BFu15i_Ui_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu15i_Ui_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu15i_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu31i, BFu15i_Ui_BFu31i)
//============================================================================



static void Test_BFu15i_Ui_BFu31ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu31ll");
    static STRUCT_IF_C BFu15i_Ui_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "BFu15i_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "BFu15i_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu31ll, BFu15i_Ui_BFu31ll)
//============================================================================



static void Test_BFu15i_Ui_BFu32i()
{
  {
    init_simple_test("BFu15i_Ui_BFu32i");
    static STRUCT_IF_C BFu15i_Ui_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu15i_Ui_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu15i_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu32i, BFu15i_Ui_BFu32i)
//============================================================================



static void Test_BFu15i_Ui_BFu32ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu32ll");
    static STRUCT_IF_C BFu15i_Ui_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "BFu15i_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "BFu15i_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu32ll, BFu15i_Ui_BFu32ll)
//============================================================================



static void Test_BFu15i_Ui_BFu33()
{
  {
    init_simple_test("BFu15i_Ui_BFu33");
    static STRUCT_IF_C BFu15i_Ui_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "BFu15i_Ui_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "BFu15i_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu33, BFu15i_Ui_BFu33)
//============================================================================



static void Test_BFu15i_Ui_BFu7c()
{
  {
    init_simple_test("BFu15i_Ui_BFu7c");
    static STRUCT_IF_C BFu15i_Ui_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_Ui_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu7c, BFu15i_Ui_BFu7c)
//============================================================================



static void Test_BFu15i_Ui_BFu7i()
{
  {
    init_simple_test("BFu15i_Ui_BFu7i");
    static STRUCT_IF_C BFu15i_Ui_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_Ui_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu7i, BFu15i_Ui_BFu7i)
//============================================================================



static void Test_BFu15i_Ui_BFu7ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu7ll");
    static STRUCT_IF_C BFu15i_Ui_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu7ll, BFu15i_Ui_BFu7ll)
//============================================================================



static void Test_BFu15i_Ui_BFu7s()
{
  {
    init_simple_test("BFu15i_Ui_BFu7s");
    static STRUCT_IF_C BFu15i_Ui_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu15i_Ui_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu15i_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu7s, BFu15i_Ui_BFu7s)
//============================================================================



static void Test_BFu15i_Ui_BFu8c()
{
  {
    init_simple_test("BFu15i_Ui_BFu8c");
    static STRUCT_IF_C BFu15i_Ui_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_Ui_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu8c, BFu15i_Ui_BFu8c)
//============================================================================



static void Test_BFu15i_Ui_BFu8i()
{
  {
    init_simple_test("BFu15i_Ui_BFu8i");
    static STRUCT_IF_C BFu15i_Ui_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_Ui_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu8i, BFu15i_Ui_BFu8i)
//============================================================================



static void Test_BFu15i_Ui_BFu8ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu8ll");
    static STRUCT_IF_C BFu15i_Ui_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu8ll, BFu15i_Ui_BFu8ll)
//============================================================================



static void Test_BFu15i_Ui_BFu8s()
{
  {
    init_simple_test("BFu15i_Ui_BFu8s");
    static STRUCT_IF_C BFu15i_Ui_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu15i_Ui_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu15i_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu8s, BFu15i_Ui_BFu8s)
//============================================================================



static void Test_BFu15i_Ui_BFu9i()
{
  {
    init_simple_test("BFu15i_Ui_BFu9i");
    static STRUCT_IF_C BFu15i_Ui_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_Ui_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu9i, BFu15i_Ui_BFu9i)
//============================================================================



static void Test_BFu15i_Ui_BFu9ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu9ll");
    static STRUCT_IF_C BFu15i_Ui_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu9ll, BFu15i_Ui_BFu9ll)
//============================================================================



static void Test_BFu15i_Ui_BFu9s()
{
  {
    init_simple_test("BFu15i_Ui_BFu9s");
    static STRUCT_IF_C BFu15i_Ui_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu15i_Ui_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu15i_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu9s, BFu15i_Ui_BFu9s)
//============================================================================



static void Test_BFu15i_Ui_C()
{
  {
    init_simple_test("BFu15i_Ui_C");
    static STRUCT_IF_C BFu15i_Ui_C lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_C");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_C.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_C, BFu15i_Ui_C)
//============================================================================



static void Test_BFu15i_Ui_D()
{
  {
    init_simple_test("BFu15i_Ui_D");
    static STRUCT_IF_C BFu15i_Ui_D lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_D");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_D.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_D, BFu15i_Ui_D)
//============================================================================



static void Test_BFu15i_Ui_F()
{
  {
    init_simple_test("BFu15i_Ui_F");
    static STRUCT_IF_C BFu15i_Ui_F lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_F");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_F.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_F, BFu15i_Ui_F)
//============================================================================



static void Test_BFu15i_Ui_I()
{
  {
    init_simple_test("BFu15i_Ui_I");
    static STRUCT_IF_C BFu15i_Ui_I lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_I");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_I.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_I, BFu15i_Ui_I)
//============================================================================



static void Test_BFu15i_Ui_Ip()
{
  {
    init_simple_test("BFu15i_Ui_Ip");
    static STRUCT_IF_C BFu15i_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_Ip.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_Ip, BFu15i_Ui_Ip)
//============================================================================



static void Test_BFu15i_Ui_L()
{
  {
    init_simple_test("BFu15i_Ui_L");
    static STRUCT_IF_C BFu15i_Ui_L lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_L");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_L.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_L, BFu15i_Ui_L)
//============================================================================



static void Test_BFu15i_Ui_S()
{
  {
    init_simple_test("BFu15i_Ui_S");
    static STRUCT_IF_C BFu15i_Ui_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_S");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_S.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_S, BFu15i_Ui_S)
//============================================================================



static void Test_BFu15i_Ui_Uc()
{
  {
    init_simple_test("BFu15i_Ui_Uc");
    static STRUCT_IF_C BFu15i_Ui_Uc lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_Uc, BFu15i_Ui_Uc)
//============================================================================



static void Test_BFu15i_Ui_Ui()
{
  {
    init_simple_test("BFu15i_Ui_Ui");
    static STRUCT_IF_C BFu15i_Ui_Ui lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_Ui.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_Ui, BFu15i_Ui_Ui)
//============================================================================



static void Test_BFu15i_Ui_Ul()
{
  {
    init_simple_test("BFu15i_Ui_Ul");
    static STRUCT_IF_C BFu15i_Ui_Ul lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_Ul.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_Ul, BFu15i_Ui_Ul)
//============================================================================



static void Test_BFu15i_Ui_Us()
{
  {
    init_simple_test("BFu15i_Ui_Us");
    static STRUCT_IF_C BFu15i_Ui_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_Us.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_Us, BFu15i_Ui_Us)
//============================================================================



static void Test_BFu15i_Ui_Vp()
{
  {
    init_simple_test("BFu15i_Ui_Vp");
    static STRUCT_IF_C BFu15i_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_Vp.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_Vp, BFu15i_Ui_Vp)
//============================================================================



static void Test_BFu15i_Ul()
{
  {
    init_simple_test("BFu15i_Ul");
    static STRUCT_IF_C BFu15i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul, BFu15i_Ul)
//============================================================================



static void Test_BFu15i_Ul_BFu15i()
{
  {
    init_simple_test("BFu15i_Ul_BFu15i");
    static STRUCT_IF_C BFu15i_Ul_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_Ul_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu15i, BFu15i_Ul_BFu15i)
//============================================================================



static void Test_BFu15i_Ul_BFu15ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu15ll");
    static STRUCT_IF_C BFu15i_Ul_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu15ll, BFu15i_Ul_BFu15ll)
//============================================================================



static void Test_BFu15i_Ul_BFu15s()
{
  {
    init_simple_test("BFu15i_Ul_BFu15s");
    static STRUCT_IF_C BFu15i_Ul_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "BFu15i_Ul_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu15s, BFu15i_Ul_BFu15s)
//============================================================================



static void Test_BFu15i_Ul_BFu16i()
{
  {
    init_simple_test("BFu15i_Ul_BFu16i");
    static STRUCT_IF_C BFu15i_Ul_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_Ul_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu16i, BFu15i_Ul_BFu16i)
//============================================================================



static void Test_BFu15i_Ul_BFu16ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu16ll");
    static STRUCT_IF_C BFu15i_Ul_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu16ll, BFu15i_Ul_BFu16ll)
//============================================================================



static void Test_BFu15i_Ul_BFu16s()
{
  {
    init_simple_test("BFu15i_Ul_BFu16s");
    static STRUCT_IF_C BFu15i_Ul_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "BFu15i_Ul_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "BFu15i_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu16s, BFu15i_Ul_BFu16s)
//============================================================================



static void Test_BFu15i_Ul_BFu17i()
{
  {
    init_simple_test("BFu15i_Ul_BFu17i");
    static STRUCT_IF_C BFu15i_Ul_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(BFu15i_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu15i_Ul_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu15i_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu17i, BFu15i_Ul_BFu17i)
//============================================================================



static void Test_BFu15i_Ul_BFu17ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu17ll");
    static STRUCT_IF_C BFu15i_Ul_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(BFu15i_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "BFu15i_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "BFu15i_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu17ll, BFu15i_Ul_BFu17ll)
//============================================================================



static void Test_BFu15i_Ul_BFu1c()
{
  {
    init_simple_test("BFu15i_Ul_BFu1c");
    static STRUCT_IF_C BFu15i_Ul_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu1c, BFu15i_Ul_BFu1c)
//============================================================================



static void Test_BFu15i_Ul_BFu1i()
{
  {
    init_simple_test("BFu15i_Ul_BFu1i");
    static STRUCT_IF_C BFu15i_Ul_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu1i, BFu15i_Ul_BFu1i)
//============================================================================



static void Test_BFu15i_Ul_BFu1ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu1ll");
    static STRUCT_IF_C BFu15i_Ul_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu1ll, BFu15i_Ul_BFu1ll)
//============================================================================



static void Test_BFu15i_Ul_BFu1s()
{
  {
    init_simple_test("BFu15i_Ul_BFu1s");
    static STRUCT_IF_C BFu15i_Ul_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "BFu15i_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu1s, BFu15i_Ul_BFu1s)
//============================================================================



static void Test_BFu15i_Ul_BFu31i()
{
  {
    init_simple_test("BFu15i_Ul_BFu31i");
    static STRUCT_IF_C BFu15i_Ul_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu15i_Ul_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu15i_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu31i, BFu15i_Ul_BFu31i)
//============================================================================



static void Test_BFu15i_Ul_BFu31ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu31ll");
    static STRUCT_IF_C BFu15i_Ul_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "BFu15i_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "BFu15i_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu31ll, BFu15i_Ul_BFu31ll)
//============================================================================



static void Test_BFu15i_Ul_BFu32i()
{
  {
    init_simple_test("BFu15i_Ul_BFu32i");
    static STRUCT_IF_C BFu15i_Ul_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu15i_Ul_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu15i_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu32i, BFu15i_Ul_BFu32i)
//============================================================================



static void Test_BFu15i_Ul_BFu32ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu32ll");
    static STRUCT_IF_C BFu15i_Ul_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "BFu15i_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "BFu15i_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu32ll, BFu15i_Ul_BFu32ll)
//============================================================================



static void Test_BFu15i_Ul_BFu33()
{
  {
    init_simple_test("BFu15i_Ul_BFu33");
    static STRUCT_IF_C BFu15i_Ul_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(BFu15i_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "BFu15i_Ul_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "BFu15i_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu33, BFu15i_Ul_BFu33)
//============================================================================



static void Test_BFu15i_Ul_BFu7c()
{
  {
    init_simple_test("BFu15i_Ul_BFu7c");
    static STRUCT_IF_C BFu15i_Ul_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_Ul_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu7c, BFu15i_Ul_BFu7c)
//============================================================================



static void Test_BFu15i_Ul_BFu7i()
{
  {
    init_simple_test("BFu15i_Ul_BFu7i");
    static STRUCT_IF_C BFu15i_Ul_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_Ul_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu7i, BFu15i_Ul_BFu7i)
//============================================================================



static void Test_BFu15i_Ul_BFu7ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu7ll");
    static STRUCT_IF_C BFu15i_Ul_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu7ll, BFu15i_Ul_BFu7ll)
//============================================================================



static void Test_BFu15i_Ul_BFu7s()
{
  {
    init_simple_test("BFu15i_Ul_BFu7s");
    static STRUCT_IF_C BFu15i_Ul_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "BFu15i_Ul_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "BFu15i_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu7s, BFu15i_Ul_BFu7s)
//============================================================================



static void Test_BFu15i_Ul_BFu8c()
{
  {
    init_simple_test("BFu15i_Ul_BFu8c");
    static STRUCT_IF_C BFu15i_Ul_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_Ul_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu8c, BFu15i_Ul_BFu8c)
//============================================================================



static void Test_BFu15i_Ul_BFu8i()
{
  {
    init_simple_test("BFu15i_Ul_BFu8i");
    static STRUCT_IF_C BFu15i_Ul_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_Ul_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu8i, BFu15i_Ul_BFu8i)
//============================================================================



static void Test_BFu15i_Ul_BFu8ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu8ll");
    static STRUCT_IF_C BFu15i_Ul_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu8ll, BFu15i_Ul_BFu8ll)
//============================================================================



static void Test_BFu15i_Ul_BFu8s()
{
  {
    init_simple_test("BFu15i_Ul_BFu8s");
    static STRUCT_IF_C BFu15i_Ul_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "BFu15i_Ul_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "BFu15i_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu8s, BFu15i_Ul_BFu8s)
//============================================================================



static void Test_BFu15i_Ul_BFu9i()
{
  {
    init_simple_test("BFu15i_Ul_BFu9i");
    static STRUCT_IF_C BFu15i_Ul_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_Ul_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu9i, BFu15i_Ul_BFu9i)
//============================================================================



static void Test_BFu15i_Ul_BFu9ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu9ll");
    static STRUCT_IF_C BFu15i_Ul_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu9ll, BFu15i_Ul_BFu9ll)
//============================================================================



static void Test_BFu15i_Ul_BFu9s()
{
  {
    init_simple_test("BFu15i_Ul_BFu9s");
    static STRUCT_IF_C BFu15i_Ul_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "BFu15i_Ul_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "BFu15i_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu9s, BFu15i_Ul_BFu9s)
//============================================================================



static void Test_BFu15i_Ul_C()
{
  {
    init_simple_test("BFu15i_Ul_C");
    static STRUCT_IF_C BFu15i_Ul_C lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_C");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_C.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_C, BFu15i_Ul_C)
//============================================================================



static void Test_BFu15i_Ul_D()
{
  {
    init_simple_test("BFu15i_Ul_D");
    static STRUCT_IF_C BFu15i_Ul_D lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_D");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_D.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_D, BFu15i_Ul_D)
//============================================================================



static void Test_BFu15i_Ul_F()
{
  {
    init_simple_test("BFu15i_Ul_F");
    static STRUCT_IF_C BFu15i_Ul_F lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_F");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_F.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_F, BFu15i_Ul_F)
//============================================================================



static void Test_BFu15i_Ul_I()
{
  {
    init_simple_test("BFu15i_Ul_I");
    static STRUCT_IF_C BFu15i_Ul_I lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_I");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_I.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_I, BFu15i_Ul_I)
//============================================================================



static void Test_BFu15i_Ul_Ip()
{
  {
    init_simple_test("BFu15i_Ul_Ip");
    static STRUCT_IF_C BFu15i_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_Ip.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_Ip, BFu15i_Ul_Ip)
//============================================================================



static void Test_BFu15i_Ul_L()
{
  {
    init_simple_test("BFu15i_Ul_L");
    static STRUCT_IF_C BFu15i_Ul_L lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_L");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_L.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_L, BFu15i_Ul_L)
//============================================================================



static void Test_BFu15i_Ul_S()
{
  {
    init_simple_test("BFu15i_Ul_S");
    static STRUCT_IF_C BFu15i_Ul_S lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_S");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_S.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_S, BFu15i_Ul_S)
//============================================================================



static void Test_BFu15i_Ul_Uc()
{
  {
    init_simple_test("BFu15i_Ul_Uc");
    static STRUCT_IF_C BFu15i_Ul_Uc lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_Uc.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_Uc, BFu15i_Ul_Uc)
//============================================================================



static void Test_BFu15i_Ul_Ui()
{
  {
    init_simple_test("BFu15i_Ul_Ui");
    static STRUCT_IF_C BFu15i_Ul_Ui lv;
    check2(sizeof(lv), 14, "sizeof(BFu15i_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_Ui.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_Ui, BFu15i_Ul_Ui)
//============================================================================



static void Test_BFu15i_Ul_Ul()
{
  {
    init_simple_test("BFu15i_Ul_Ul");
    static STRUCT_IF_C BFu15i_Ul_Ul lv;
    check2(sizeof(lv), 18, "sizeof(BFu15i_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_Ul.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_Ul, BFu15i_Ul_Ul)
//============================================================================



static void Test_BFu15i_Ul_Us()
{
  {
    init_simple_test("BFu15i_Ul_Us");
    static STRUCT_IF_C BFu15i_Ul_Us lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_Us.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_Us, BFu15i_Ul_Us)
//============================================================================



static void Test_BFu15i_Ul_Vp()
{
  {
    init_simple_test("BFu15i_Ul_Vp");
    static STRUCT_IF_C BFu15i_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_Vp.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_Vp, BFu15i_Ul_Vp)
//============================================================================



static void Test_BFu15i_Us()
{
  {
    init_simple_test("BFu15i_Us");
    static STRUCT_IF_C BFu15i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us, BFu15i_Us)
//============================================================================



static void Test_BFu15i_Us_BFu15i()
{
  {
    init_simple_test("BFu15i_Us_BFu15i");
    static STRUCT_IF_C BFu15i_Us_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_Us_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu15i, BFu15i_Us_BFu15i)
//============================================================================



static void Test_BFu15i_Us_BFu15ll()
{
  {
    init_simple_test("BFu15i_Us_BFu15ll");
    static STRUCT_IF_C BFu15i_Us_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_Us_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu15ll, BFu15i_Us_BFu15ll)
//============================================================================



static void Test_BFu15i_Us_BFu15s()
{
  {
    init_simple_test("BFu15i_Us_BFu15s");
    static STRUCT_IF_C BFu15i_Us_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_Us_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu15s, BFu15i_Us_BFu15s)
//============================================================================



static void Test_BFu15i_Us_BFu16i()
{
  {
    init_simple_test("BFu15i_Us_BFu16i");
    static STRUCT_IF_C BFu15i_Us_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_Us_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu16i, BFu15i_Us_BFu16i)
//============================================================================



static void Test_BFu15i_Us_BFu16ll()
{
  {
    init_simple_test("BFu15i_Us_BFu16ll");
    static STRUCT_IF_C BFu15i_Us_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_Us_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu16ll, BFu15i_Us_BFu16ll)
//============================================================================



static void Test_BFu15i_Us_BFu16s()
{
  {
    init_simple_test("BFu15i_Us_BFu16s");
    static STRUCT_IF_C BFu15i_Us_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_Us_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu16s, BFu15i_Us_BFu16s)
//============================================================================



static void Test_BFu15i_Us_BFu17i()
{
  {
    init_simple_test("BFu15i_Us_BFu17i");
    static STRUCT_IF_C BFu15i_Us_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15i_Us_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu17i, BFu15i_Us_BFu17i)
//============================================================================



static void Test_BFu15i_Us_BFu17ll()
{
  {
    init_simple_test("BFu15i_Us_BFu17ll");
    static STRUCT_IF_C BFu15i_Us_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15i_Us_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu17ll, BFu15i_Us_BFu17ll)
//============================================================================



static void Test_BFu15i_Us_BFu1c()
{
  {
    init_simple_test("BFu15i_Us_BFu1c");
    static STRUCT_IF_C BFu15i_Us_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu1c, BFu15i_Us_BFu1c)
//============================================================================



static void Test_BFu15i_Us_BFu1i()
{
  {
    init_simple_test("BFu15i_Us_BFu1i");
    static STRUCT_IF_C BFu15i_Us_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu1i, BFu15i_Us_BFu1i)
//============================================================================



static void Test_BFu15i_Us_BFu1ll()
{
  {
    init_simple_test("BFu15i_Us_BFu1ll");
    static STRUCT_IF_C BFu15i_Us_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu1ll, BFu15i_Us_BFu1ll)
//============================================================================



static void Test_BFu15i_Us_BFu1s()
{
  {
    init_simple_test("BFu15i_Us_BFu1s");
    static STRUCT_IF_C BFu15i_Us_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu15i_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu1s, BFu15i_Us_BFu1s)
//============================================================================



static void Test_BFu15i_Us_BFu31i()
{
  {
    init_simple_test("BFu15i_Us_BFu31i");
    static STRUCT_IF_C BFu15i_Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15i_Us_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu31i, BFu15i_Us_BFu31i)
//============================================================================



static void Test_BFu15i_Us_BFu31ll()
{
  {
    init_simple_test("BFu15i_Us_BFu31ll");
    static STRUCT_IF_C BFu15i_Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15i_Us_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu31ll, BFu15i_Us_BFu31ll)
//============================================================================



static void Test_BFu15i_Us_BFu32i()
{
  {
    init_simple_test("BFu15i_Us_BFu32i");
    static STRUCT_IF_C BFu15i_Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15i_Us_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu32i, BFu15i_Us_BFu32i)
//============================================================================



static void Test_BFu15i_Us_BFu32ll()
{
  {
    init_simple_test("BFu15i_Us_BFu32ll");
    static STRUCT_IF_C BFu15i_Us_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15i_Us_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu32ll, BFu15i_Us_BFu32ll)
//============================================================================



static void Test_BFu15i_Us_BFu33()
{
  {
    init_simple_test("BFu15i_Us_BFu33");
    static STRUCT_IF_C BFu15i_Us_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu15i_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu15i_Us_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu15i_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu33, BFu15i_Us_BFu33)
//============================================================================



static void Test_BFu15i_Us_BFu7c()
{
  {
    init_simple_test("BFu15i_Us_BFu7c");
    static STRUCT_IF_C BFu15i_Us_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_Us_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu7c, BFu15i_Us_BFu7c)
//============================================================================



static void Test_BFu15i_Us_BFu7i()
{
  {
    init_simple_test("BFu15i_Us_BFu7i");
    static STRUCT_IF_C BFu15i_Us_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_Us_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu7i, BFu15i_Us_BFu7i)
//============================================================================



static void Test_BFu15i_Us_BFu7ll()
{
  {
    init_simple_test("BFu15i_Us_BFu7ll");
    static STRUCT_IF_C BFu15i_Us_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_Us_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu7ll, BFu15i_Us_BFu7ll)
//============================================================================



static void Test_BFu15i_Us_BFu7s()
{
  {
    init_simple_test("BFu15i_Us_BFu7s");
    static STRUCT_IF_C BFu15i_Us_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu15i_Us_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu7s, BFu15i_Us_BFu7s)
//============================================================================



static void Test_BFu15i_Us_BFu8c()
{
  {
    init_simple_test("BFu15i_Us_BFu8c");
    static STRUCT_IF_C BFu15i_Us_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_Us_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu8c, BFu15i_Us_BFu8c)
//============================================================================



static void Test_BFu15i_Us_BFu8i()
{
  {
    init_simple_test("BFu15i_Us_BFu8i");
    static STRUCT_IF_C BFu15i_Us_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_Us_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu8i, BFu15i_Us_BFu8i)
//============================================================================



static void Test_BFu15i_Us_BFu8ll()
{
  {
    init_simple_test("BFu15i_Us_BFu8ll");
    static STRUCT_IF_C BFu15i_Us_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_Us_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu8ll, BFu15i_Us_BFu8ll)
//============================================================================



static void Test_BFu15i_Us_BFu8s()
{
  {
    init_simple_test("BFu15i_Us_BFu8s");
    static STRUCT_IF_C BFu15i_Us_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu15i_Us_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu8s, BFu15i_Us_BFu8s)
//============================================================================



static void Test_BFu15i_Us_BFu9i()
{
  {
    init_simple_test("BFu15i_Us_BFu9i");
    static STRUCT_IF_C BFu15i_Us_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_Us_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu9i, BFu15i_Us_BFu9i)
//============================================================================



static void Test_BFu15i_Us_BFu9ll()
{
  {
    init_simple_test("BFu15i_Us_BFu9ll");
    static STRUCT_IF_C BFu15i_Us_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_Us_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu9ll, BFu15i_Us_BFu9ll)
//============================================================================



static void Test_BFu15i_Us_BFu9s()
{
  {
    init_simple_test("BFu15i_Us_BFu9s");
    static STRUCT_IF_C BFu15i_Us_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_Us_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu9s, BFu15i_Us_BFu9s)
//============================================================================



static void Test_BFu15i_Us_C()
{
  {
    init_simple_test("BFu15i_Us_C");
    static STRUCT_IF_C BFu15i_Us_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_C");
    check_field_offset(lv, v2, 2, "BFu15i_Us_C.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_C, BFu15i_Us_C)
//============================================================================



static void Test_BFu15i_Us_D()
{
  {
    init_simple_test("BFu15i_Us_D");
    static STRUCT_IF_C BFu15i_Us_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_D");
    check_field_offset(lv, v2, 2, "BFu15i_Us_D.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_D, BFu15i_Us_D)
//============================================================================



static void Test_BFu15i_Us_F()
{
  {
    init_simple_test("BFu15i_Us_F");
    static STRUCT_IF_C BFu15i_Us_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_F");
    check_field_offset(lv, v2, 2, "BFu15i_Us_F.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_F, BFu15i_Us_F)
//============================================================================



static void Test_BFu15i_Us_I()
{
  {
    init_simple_test("BFu15i_Us_I");
    static STRUCT_IF_C BFu15i_Us_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_I");
    check_field_offset(lv, v2, 2, "BFu15i_Us_I.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_I, BFu15i_Us_I)
//============================================================================



static void Test_BFu15i_Us_Ip()
{
  {
    init_simple_test("BFu15i_Us_Ip");
    static STRUCT_IF_C BFu15i_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_Ip, BFu15i_Us_Ip)
//============================================================================



static void Test_BFu15i_Us_L()
{
  {
    init_simple_test("BFu15i_Us_L");
    static STRUCT_IF_C BFu15i_Us_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_L");
    check_field_offset(lv, v2, 2, "BFu15i_Us_L.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_L, BFu15i_Us_L)
//============================================================================



static void Test_BFu15i_Us_S()
{
  {
    init_simple_test("BFu15i_Us_S");
    static STRUCT_IF_C BFu15i_Us_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_S");
    check_field_offset(lv, v2, 2, "BFu15i_Us_S.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_S, BFu15i_Us_S)
//============================================================================



static void Test_BFu15i_Us_Uc()
{
  {
    init_simple_test("BFu15i_Us_Uc");
    static STRUCT_IF_C BFu15i_Us_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_Uc, BFu15i_Us_Uc)
//============================================================================



static void Test_BFu15i_Us_Ui()
{
  {
    init_simple_test("BFu15i_Us_Ui");
    static STRUCT_IF_C BFu15i_Us_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_Ui, BFu15i_Us_Ui)
//============================================================================



static void Test_BFu15i_Us_Ul()
{
  {
    init_simple_test("BFu15i_Us_Ul");
    static STRUCT_IF_C BFu15i_Us_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_Ul, BFu15i_Us_Ul)
//============================================================================



static void Test_BFu15i_Us_Us()
{
  {
    init_simple_test("BFu15i_Us_Us");
    static STRUCT_IF_C BFu15i_Us_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Us.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_Us, BFu15i_Us_Us)
//============================================================================



static void Test_BFu15i_Us_Vp()
{
  {
    init_simple_test("BFu15i_Us_Vp");
    static STRUCT_IF_C BFu15i_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_Vp, BFu15i_Us_Vp)
//============================================================================



static void Test_BFu15i_Vp()
{
  {
    init_simple_test("BFu15i_Vp");
    static STRUCT_IF_C BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp, BFu15i_Vp)
//============================================================================



static void Test_BFu15i_Vp_BFu15i()
{
  {
    init_simple_test("BFu15i_Vp_BFu15i");
    static STRUCT_IF_C BFu15i_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu15i_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu15i, BFu15i_Vp_BFu15i)
//============================================================================



static void Test_BFu15i_Vp_BFu15ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu15ll");
    static STRUCT_IF_C BFu15i_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu15i_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu15ll, BFu15i_Vp_BFu15ll)
//============================================================================



static void Test_BFu15i_Vp_BFu15s()
{
  {
    init_simple_test("BFu15i_Vp_BFu15s");
    static STRUCT_IF_C BFu15i_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "BFu15i_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu15s, BFu15i_Vp_BFu15s)
//============================================================================



static void Test_BFu15i_Vp_BFu16i()
{
  {
    init_simple_test("BFu15i_Vp_BFu16i");
    static STRUCT_IF_C BFu15i_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu15i_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu15i_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu16i, BFu15i_Vp_BFu16i)
//============================================================================



static void Test_BFu15i_Vp_BFu16ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu16ll");
    static STRUCT_IF_C BFu15i_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu15i_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu15i_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu16ll, BFu15i_Vp_BFu16ll)
//============================================================================



static void Test_BFu15i_Vp_BFu16s()
{
  {
    init_simple_test("BFu15i_Vp_BFu16s");
    static STRUCT_IF_C BFu15i_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "BFu15i_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "BFu15i_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu16s, BFu15i_Vp_BFu16s)
//============================================================================



static void Test_BFu15i_Vp_BFu17i()
{
  {
    init_simple_test("BFu15i_Vp_BFu17i");
    static STRUCT_IF_C BFu15i_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu15i_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu15i_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu15i_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu17i, BFu15i_Vp_BFu17i)
//============================================================================



static void Test_BFu15i_Vp_BFu17ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu17ll");
    static STRUCT_IF_C BFu15i_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu15i_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "BFu15i_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "BFu15i_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu17ll, BFu15i_Vp_BFu17ll)
//============================================================================



static void Test_BFu15i_Vp_BFu1c()
{
  {
    init_simple_test("BFu15i_Vp_BFu1c");
    static STRUCT_IF_C BFu15i_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu1c, BFu15i_Vp_BFu1c)
//============================================================================



static void Test_BFu15i_Vp_BFu1i()
{
  {
    init_simple_test("BFu15i_Vp_BFu1i");
    static STRUCT_IF_C BFu15i_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu1i, BFu15i_Vp_BFu1i)
//============================================================================



static void Test_BFu15i_Vp_BFu1ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu1ll");
    static STRUCT_IF_C BFu15i_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu1ll, BFu15i_Vp_BFu1ll)
//============================================================================



static void Test_BFu15i_Vp_BFu1s()
{
  {
    init_simple_test("BFu15i_Vp_BFu1s");
    static STRUCT_IF_C BFu15i_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "BFu15i_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu1s, BFu15i_Vp_BFu1s)
//============================================================================



static void Test_BFu15i_Vp_BFu31i()
{
  {
    init_simple_test("BFu15i_Vp_BFu31i");
    static STRUCT_IF_C BFu15i_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu15i_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu15i_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu31i, BFu15i_Vp_BFu31i)
//============================================================================



static void Test_BFu15i_Vp_BFu31ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu31ll");
    static STRUCT_IF_C BFu15i_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "BFu15i_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "BFu15i_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu31ll, BFu15i_Vp_BFu31ll)
//============================================================================



static void Test_BFu15i_Vp_BFu32i()
{
  {
    init_simple_test("BFu15i_Vp_BFu32i");
    static STRUCT_IF_C BFu15i_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu15i_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu15i_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu32i, BFu15i_Vp_BFu32i)
//============================================================================



static void Test_BFu15i_Vp_BFu32ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu32ll");
    static STRUCT_IF_C BFu15i_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "BFu15i_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "BFu15i_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu32ll, BFu15i_Vp_BFu32ll)
//============================================================================



static void Test_BFu15i_Vp_BFu33()
{
  {
    init_simple_test("BFu15i_Vp_BFu33");
    static STRUCT_IF_C BFu15i_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(BFu15i_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "BFu15i_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "BFu15i_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu33, BFu15i_Vp_BFu33)
//============================================================================



static void Test_BFu15i_Vp_BFu7c()
{
  {
    init_simple_test("BFu15i_Vp_BFu7c");
    static STRUCT_IF_C BFu15i_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu7c, BFu15i_Vp_BFu7c)
//============================================================================



static void Test_BFu15i_Vp_BFu7i()
{
  {
    init_simple_test("BFu15i_Vp_BFu7i");
    static STRUCT_IF_C BFu15i_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu7i, BFu15i_Vp_BFu7i)
//============================================================================



static void Test_BFu15i_Vp_BFu7ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu7ll");
    static STRUCT_IF_C BFu15i_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu7ll, BFu15i_Vp_BFu7ll)
//============================================================================



static void Test_BFu15i_Vp_BFu7s()
{
  {
    init_simple_test("BFu15i_Vp_BFu7s");
    static STRUCT_IF_C BFu15i_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "BFu15i_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "BFu15i_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu7s, BFu15i_Vp_BFu7s)
//============================================================================



static void Test_BFu15i_Vp_BFu8c()
{
  {
    init_simple_test("BFu15i_Vp_BFu8c");
    static STRUCT_IF_C BFu15i_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu8c, BFu15i_Vp_BFu8c)
//============================================================================



static void Test_BFu15i_Vp_BFu8i()
{
  {
    init_simple_test("BFu15i_Vp_BFu8i");
    static STRUCT_IF_C BFu15i_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu8i, BFu15i_Vp_BFu8i)
//============================================================================



static void Test_BFu15i_Vp_BFu8ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu8ll");
    static STRUCT_IF_C BFu15i_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu8ll, BFu15i_Vp_BFu8ll)
//============================================================================



static void Test_BFu15i_Vp_BFu8s()
{
  {
    init_simple_test("BFu15i_Vp_BFu8s");
    static STRUCT_IF_C BFu15i_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "BFu15i_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "BFu15i_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu8s, BFu15i_Vp_BFu8s)
//============================================================================



static void Test_BFu15i_Vp_BFu9i()
{
  {
    init_simple_test("BFu15i_Vp_BFu9i");
    static STRUCT_IF_C BFu15i_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu15i_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu15i_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu9i, BFu15i_Vp_BFu9i)
//============================================================================



static void Test_BFu15i_Vp_BFu9ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu9ll");
    static STRUCT_IF_C BFu15i_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu15i_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu15i_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu9ll, BFu15i_Vp_BFu9ll)
//============================================================================



static void Test_BFu15i_Vp_BFu9s()
{
  {
    init_simple_test("BFu15i_Vp_BFu9s");
    static STRUCT_IF_C BFu15i_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "BFu15i_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "BFu15i_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu9s, BFu15i_Vp_BFu9s)
//============================================================================



static void Test_BFu15i_Vp_C()
{
  {
    init_simple_test("BFu15i_Vp_C");
    static STRUCT_IF_C BFu15i_Vp_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_C");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_C, BFu15i_Vp_C)
//============================================================================



static void Test_BFu15i_Vp_D()
{
  {
    init_simple_test("BFu15i_Vp_D");
    static STRUCT_IF_C BFu15i_Vp_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_D");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_D, BFu15i_Vp_D)
//============================================================================



static void Test_BFu15i_Vp_F()
{
  {
    init_simple_test("BFu15i_Vp_F");
    static STRUCT_IF_C BFu15i_Vp_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_F");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_F, BFu15i_Vp_F)
//============================================================================



static void Test_BFu15i_Vp_I()
{
  {
    init_simple_test("BFu15i_Vp_I");
    static STRUCT_IF_C BFu15i_Vp_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_I");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_I, BFu15i_Vp_I)
//============================================================================



static void Test_BFu15i_Vp_Ip()
{
  {
    init_simple_test("BFu15i_Vp_Ip");
    static STRUCT_IF_C BFu15i_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu15i_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_Ip, BFu15i_Vp_Ip)
//============================================================================



static void Test_BFu15i_Vp_L()
{
  {
    init_simple_test("BFu15i_Vp_L");
    static STRUCT_IF_C BFu15i_Vp_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_L");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_L, BFu15i_Vp_L)
//============================================================================



static void Test_BFu15i_Vp_S()
{
  {
    init_simple_test("BFu15i_Vp_S");
    static STRUCT_IF_C BFu15i_Vp_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_S");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_S, BFu15i_Vp_S)
//============================================================================



static void Test_BFu15i_Vp_Uc()
{
  {
    init_simple_test("BFu15i_Vp_Uc");
    static STRUCT_IF_C BFu15i_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_Uc, BFu15i_Vp_Uc)
//============================================================================



static void Test_BFu15i_Vp_Ui()
{
  {
    init_simple_test("BFu15i_Vp_Ui");
    static STRUCT_IF_C BFu15i_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(BFu15i_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_Ui, BFu15i_Vp_Ui)
//============================================================================



static void Test_BFu15i_Vp_Ul()
{
  {
    init_simple_test("BFu15i_Vp_Ul");
    static STRUCT_IF_C BFu15i_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(BFu15i_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_Ul, BFu15i_Vp_Ul)
//============================================================================



static void Test_BFu15i_Vp_Us()
{
  {
    init_simple_test("BFu15i_Vp_Us");
    static STRUCT_IF_C BFu15i_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_Us, BFu15i_Vp_Us)
//============================================================================



static void Test_BFu15i_Vp_Vp()
{
  {
    init_simple_test("BFu15i_Vp_Vp");
    static STRUCT_IF_C BFu15i_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(BFu15i_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_Vp, BFu15i_Vp_Vp)
//============================================================================



static void Test_BFu15ll()
{
  {
    init_simple_test("BFu15ll");
    static STRUCT_IF_C BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll, BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i, BFu15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i, BFu15ll_BFs15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i_BFs15i, BFu15ll_BFs15i_BFs15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i_BFs15ll, BFu15ll_BFs15i_BFs15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i_BFs15s, BFu15ll_BFs15i_BFs15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i_BFu15i, BFu15ll_BFs15i_BFs15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i_BFu15ll, BFu15ll_BFs15i_BFs15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15i_BFu15s, BFu15ll_BFs15i_BFs15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll, BFu15ll_BFs15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll_BFs15i, BFu15ll_BFs15i_BFs15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll_BFs15ll, BFu15ll_BFs15i_BFs15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll_BFs15s, BFu15ll_BFs15i_BFs15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll_BFu15i, BFu15ll_BFs15i_BFs15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll_BFu15ll, BFu15ll_BFs15i_BFs15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15ll_BFu15s, BFu15ll_BFs15i_BFs15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s, BFu15ll_BFs15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s_BFs15i, BFu15ll_BFs15i_BFs15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s_BFs15ll, BFu15ll_BFs15i_BFs15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s_BFs15s, BFu15ll_BFs15i_BFs15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s_BFu15i, BFu15ll_BFs15i_BFs15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s_BFu15ll, BFu15ll_BFs15i_BFs15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFs15s_BFu15s, BFu15ll_BFs15i_BFs15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i, BFu15ll_BFs15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i_BFs15i, BFu15ll_BFs15i_BFu15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i_BFs15ll, BFu15ll_BFs15i_BFu15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i_BFs15s, BFu15ll_BFs15i_BFu15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i_BFu15i, BFu15ll_BFs15i_BFu15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i_BFu15ll, BFu15ll_BFs15i_BFu15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15i_BFu15s, BFu15ll_BFs15i_BFu15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll, BFu15ll_BFs15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll_BFs15i, BFu15ll_BFs15i_BFu15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll_BFs15ll, BFu15ll_BFs15i_BFu15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll_BFs15s, BFu15ll_BFs15i_BFu15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll_BFu15i, BFu15ll_BFs15i_BFu15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll_BFu15ll, BFu15ll_BFs15i_BFu15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15ll_BFu15s, BFu15ll_BFs15i_BFu15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s, BFu15ll_BFs15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s_BFs15i, BFu15ll_BFs15i_BFu15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s_BFs15ll, BFu15ll_BFs15i_BFu15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s_BFs15s, BFu15ll_BFs15i_BFu15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s_BFu15i, BFu15ll_BFs15i_BFu15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s_BFu15ll, BFu15ll_BFs15i_BFu15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15i_BFu15s_BFu15s, BFu15ll_BFs15i_BFu15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll, BFu15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i, BFu15ll_BFs15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i_BFs15i, BFu15ll_BFs15ll_BFs15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i_BFs15ll, BFu15ll_BFs15ll_BFs15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i_BFs15s, BFu15ll_BFs15ll_BFs15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i_BFu15i, BFu15ll_BFs15ll_BFs15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i_BFu15ll, BFu15ll_BFs15ll_BFs15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15i_BFu15s, BFu15ll_BFs15ll_BFs15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll, BFu15ll_BFs15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll_BFs15i, BFu15ll_BFs15ll_BFs15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll_BFs15ll, BFu15ll_BFs15ll_BFs15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll_BFs15s, BFu15ll_BFs15ll_BFs15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll_BFu15i, BFu15ll_BFs15ll_BFs15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll_BFu15ll, BFu15ll_BFs15ll_BFs15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15ll_BFu15s, BFu15ll_BFs15ll_BFs15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s, BFu15ll_BFs15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s_BFs15i, BFu15ll_BFs15ll_BFs15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s_BFs15ll, BFu15ll_BFs15ll_BFs15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s_BFs15s, BFu15ll_BFs15ll_BFs15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s_BFu15i, BFu15ll_BFs15ll_BFs15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s_BFu15ll, BFu15ll_BFs15ll_BFs15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFs15s_BFu15s, BFu15ll_BFs15ll_BFs15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i, BFu15ll_BFs15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i_BFs15i, BFu15ll_BFs15ll_BFu15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i_BFs15ll, BFu15ll_BFs15ll_BFu15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i_BFs15s, BFu15ll_BFs15ll_BFu15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i_BFu15i, BFu15ll_BFs15ll_BFu15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i_BFu15ll, BFu15ll_BFs15ll_BFu15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15i_BFu15s, BFu15ll_BFs15ll_BFu15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll, BFu15ll_BFs15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll_BFs15i, BFu15ll_BFs15ll_BFu15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll_BFs15ll, BFu15ll_BFs15ll_BFu15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll_BFs15s, BFu15ll_BFs15ll_BFu15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll_BFu15i, BFu15ll_BFs15ll_BFu15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll_BFu15ll, BFu15ll_BFs15ll_BFu15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15ll_BFu15s, BFu15ll_BFs15ll_BFu15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s, BFu15ll_BFs15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s_BFs15i, BFu15ll_BFs15ll_BFu15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s_BFs15ll, BFu15ll_BFs15ll_BFu15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s_BFs15s, BFu15ll_BFs15ll_BFu15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s_BFu15i, BFu15ll_BFs15ll_BFu15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s_BFu15ll, BFu15ll_BFs15ll_BFu15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15ll_BFu15s_BFu15s, BFu15ll_BFs15ll_BFu15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s, BFu15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i, BFu15ll_BFs15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i_BFs15i, BFu15ll_BFs15s_BFs15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i_BFs15ll, BFu15ll_BFs15s_BFs15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i_BFs15s, BFu15ll_BFs15s_BFs15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i_BFu15i, BFu15ll_BFs15s_BFs15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i_BFu15ll, BFu15ll_BFs15s_BFs15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15i_BFu15s, BFu15ll_BFs15s_BFs15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll, BFu15ll_BFs15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll_BFs15i, BFu15ll_BFs15s_BFs15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll_BFs15ll, BFu15ll_BFs15s_BFs15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll_BFs15s, BFu15ll_BFs15s_BFs15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll_BFu15i, BFu15ll_BFs15s_BFs15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll_BFu15ll, BFu15ll_BFs15s_BFs15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15ll_BFu15s, BFu15ll_BFs15s_BFs15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s, BFu15ll_BFs15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s_BFs15i, BFu15ll_BFs15s_BFs15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s_BFs15ll, BFu15ll_BFs15s_BFs15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s_BFs15s, BFu15ll_BFs15s_BFs15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s_BFu15i, BFu15ll_BFs15s_BFs15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s_BFu15ll, BFu15ll_BFs15s_BFs15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFs15s_BFu15s, BFu15ll_BFs15s_BFs15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i, BFu15ll_BFs15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i_BFs15i, BFu15ll_BFs15s_BFu15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i_BFs15ll, BFu15ll_BFs15s_BFu15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i_BFs15s, BFu15ll_BFs15s_BFu15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i_BFu15i, BFu15ll_BFs15s_BFu15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i_BFu15ll, BFu15ll_BFs15s_BFu15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15i_BFu15s, BFu15ll_BFs15s_BFu15i_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll, BFu15ll_BFs15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll_BFs15i, BFu15ll_BFs15s_BFu15ll_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll_BFs15ll, BFu15ll_BFs15s_BFu15ll_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll_BFs15s, BFu15ll_BFs15s_BFu15ll_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll_BFu15i, BFu15ll_BFs15s_BFu15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll_BFu15ll, BFu15ll_BFs15s_BFu15ll_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15ll_BFu15s, BFu15ll_BFs15s_BFu15ll_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s, BFu15ll_BFs15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s_BFs15i, BFu15ll_BFs15s_BFu15s_BFs15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s_BFs15ll, BFu15ll_BFs15s_BFu15s_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s_BFs15s, BFu15ll_BFs15s_BFu15s_BFs15s)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s_BFu15i, BFu15ll_BFs15s_BFu15s_BFu15i)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s_BFu15ll, BFu15ll_BFs15s_BFu15s_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFs15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFs15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFs15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFs15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFs15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFs15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFs15s_BFu15s_BFu15s, BFu15ll_BFs15s_BFu15s_BFu15s)
//============================================================================



static void Test_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i, BFu15ll_BFu15i)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFs15i, BFu15ll_BFu15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFs15i_BFs15i, BFu15ll_BFu15i_BFs15i_BFs15i)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFs15i_BFs15ll, BFu15ll_BFu15i_BFs15i_BFs15ll)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFs15i_BFs15s, BFu15ll_BFu15i_BFs15i_BFs15s)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFs15i_BFu15i, BFu15ll_BFu15i_BFs15i_BFu15i)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFs15i_BFu15ll, BFu15ll_BFu15i_BFs15i_BFu15ll)
//============================================================================



static void Test_BFu15ll_BFu15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFu15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFu15