// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct BFs8ll_BFs8c_BFu8ll_BFu8c { signed long long v1:8; signed char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFu8ll_BFu8i { signed long long v1:8; signed char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFu8ll_BFu8ll { signed long long v1:8; signed char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFu8ll_BFu8s { signed long long v1:8; signed char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFu8s { signed long long v1:8; signed char v2:8; unsigned short v3:8; };
struct BFs8ll_BFs8c_BFu8s_BFs8c { signed long long v1:8; signed char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFs8i { signed long long v1:8; signed char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFs8ll { signed long long v1:8; signed char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFs8s { signed long long v1:8; signed char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFu8c { signed long long v1:8; signed char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFu8i { signed long long v1:8; signed char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFu8ll { signed long long v1:8; signed char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFu8s_BFu8s { signed long long v1:8; signed char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i { signed long long v1:8; signed int v2:8; };
struct BFs8ll_BFs8i_BFs8c { signed long long v1:8; signed int v2:8; signed char v3:8; };
struct BFs8ll_BFs8i_BFs8c_BFs8c { signed long long v1:8; signed int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFs8i { signed long long v1:8; signed int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFs8ll { signed long long v1:8; signed int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFs8s { signed long long v1:8; signed int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFu8c { signed long long v1:8; signed int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFu8i { signed long long v1:8; signed int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFu8ll { signed long long v1:8; signed int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFs8c_BFu8s { signed long long v1:8; signed int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFs8i { signed long long v1:8; signed int v2:8; signed int v3:8; };
struct BFs8ll_BFs8i_BFs8i_BFs8c { signed long long v1:8; signed int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFs8i { signed long long v1:8; signed int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFs8ll { signed long long v1:8; signed int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFs8s { signed long long v1:8; signed int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFu8c { signed long long v1:8; signed int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFu8i { signed long long v1:8; signed int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFu8ll { signed long long v1:8; signed int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFs8i_BFu8s { signed long long v1:8; signed int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFs8ll { signed long long v1:8; signed int v2:8; signed long long v3:8; };
struct BFs8ll_BFs8i_BFs8ll_BFs8c { signed long long v1:8; signed int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFs8i { signed long long v1:8; signed int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFs8ll { signed long long v1:8; signed int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFs8s { signed long long v1:8; signed int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFu8c { signed long long v1:8; signed int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFu8i { signed long long v1:8; signed int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFu8ll { signed long long v1:8; signed int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFs8ll_BFu8s { signed long long v1:8; signed int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFs8s { signed long long v1:8; signed int v2:8; signed short v3:8; };
struct BFs8ll_BFs8i_BFs8s_BFs8c { signed long long v1:8; signed int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFs8i { signed long long v1:8; signed int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFs8ll { signed long long v1:8; signed int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFs8s { signed long long v1:8; signed int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFu8c { signed long long v1:8; signed int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFu8i { signed long long v1:8; signed int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFu8ll { signed long long v1:8; signed int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFs8s_BFu8s { signed long long v1:8; signed int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFu8c { signed long long v1:8; signed int v2:8; unsigned char v3:8; };
struct BFs8ll_BFs8i_BFu8c_BFs8c { signed long long v1:8; signed int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFs8i { signed long long v1:8; signed int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFs8ll { signed long long v1:8; signed int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFs8s { signed long long v1:8; signed int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFu8c { signed long long v1:8; signed int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFu8i { signed long long v1:8; signed int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFu8ll { signed long long v1:8; signed int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFu8c_BFu8s { signed long long v1:8; signed int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFu8i { signed long long v1:8; signed int v2:8; unsigned int v3:8; };
struct BFs8ll_BFs8i_BFu8i_BFs8c { signed long long v1:8; signed int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFs8i { signed long long v1:8; signed int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFs8ll { signed long long v1:8; signed int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFs8s { signed long long v1:8; signed int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFu8c { signed long long v1:8; signed int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFu8i { signed long long v1:8; signed int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFu8ll { signed long long v1:8; signed int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFu8i_BFu8s { signed long long v1:8; signed int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFu8ll { signed long long v1:8; signed int v2:8; unsigned long long v3:8; };
struct BFs8ll_BFs8i_BFu8ll_BFs8c { signed long long v1:8; signed int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFs8i { signed long long v1:8; signed int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFs8ll { signed long long v1:8; signed int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFs8s { signed long long v1:8; signed int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFu8c { signed long long v1:8; signed int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFu8i { signed long long v1:8; signed int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFu8ll { signed long long v1:8; signed int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFu8ll_BFu8s { signed long long v1:8; signed int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8i_BFu8s { signed long long v1:8; signed int v2:8; unsigned short v3:8; };
struct BFs8ll_BFs8i_BFu8s_BFs8c { signed long long v1:8; signed int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFs8i { signed long long v1:8; signed int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFs8ll { signed long long v1:8; signed int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFs8s { signed long long v1:8; signed int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFu8c { signed long long v1:8; signed int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFu8i { signed long long v1:8; signed int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFu8ll { signed long long v1:8; signed int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8i_BFu8s_BFu8s { signed long long v1:8; signed int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll { signed long long v1:8; signed long long v2:8; };
struct BFs8ll_BFs8ll_BFs8c { signed long long v1:8; signed long long v2:8; signed char v3:8; };
struct BFs8ll_BFs8ll_BFs8c_BFs8c { signed long long v1:8; signed long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFs8i { signed long long v1:8; signed long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFs8ll { signed long long v1:8; signed long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFs8s { signed long long v1:8; signed long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFu8c { signed long long v1:8; signed long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFu8i { signed long long v1:8; signed long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFu8ll { signed long long v1:8; signed long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFs8c_BFu8s { signed long long v1:8; signed long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFs8i { signed long long v1:8; signed long long v2:8; signed int v3:8; };
struct BFs8ll_BFs8ll_BFs8i_BFs8c { signed long long v1:8; signed long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFs8i { signed long long v1:8; signed long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFs8ll { signed long long v1:8; signed long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFs8s { signed long long v1:8; signed long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFu8c { signed long long v1:8; signed long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFu8i { signed long long v1:8; signed long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFu8ll { signed long long v1:8; signed long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFs8i_BFu8s { signed long long v1:8; signed long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFs8ll { signed long long v1:8; signed long long v2:8; signed long long v3:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFs8c { signed long long v1:8; signed long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFs8i { signed long long v1:8; signed long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFs8ll { signed long long v1:8; signed long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFs8s { signed long long v1:8; signed long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFu8c { signed long long v1:8; signed long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFu8i { signed long long v1:8; signed long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFu8ll { signed long long v1:8; signed long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFs8ll_BFu8s { signed long long v1:8; signed long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFs8s { signed long long v1:8; signed long long v2:8; signed short v3:8; };
struct BFs8ll_BFs8ll_BFs8s_BFs8c { signed long long v1:8; signed long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFs8i { signed long long v1:8; signed long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFs8ll { signed long long v1:8; signed long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFs8s { signed long long v1:8; signed long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFu8c { signed long long v1:8; signed long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFu8i { signed long long v1:8; signed long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFu8ll { signed long long v1:8; signed long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFs8s_BFu8s { signed long long v1:8; signed long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFu8c { signed long long v1:8; signed long long v2:8; unsigned char v3:8; };
struct BFs8ll_BFs8ll_BFu8c_BFs8c { signed long long v1:8; signed long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFs8i { signed long long v1:8; signed long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFs8ll { signed long long v1:8; signed long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFs8s { signed long long v1:8; signed long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFu8c { signed long long v1:8; signed long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFu8i { signed long long v1:8; signed long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFu8ll { signed long long v1:8; signed long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFu8c_BFu8s { signed long long v1:8; signed long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFu8i { signed long long v1:8; signed long long v2:8; unsigned int v3:8; };
struct BFs8ll_BFs8ll_BFu8i_BFs8c { signed long long v1:8; signed long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFs8i { signed long long v1:8; signed long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFs8ll { signed long long v1:8; signed long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFs8s { signed long long v1:8; signed long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFu8c { signed long long v1:8; signed long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFu8i { signed long long v1:8; signed long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFu8ll { signed long long v1:8; signed long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFu8i_BFu8s { signed long long v1:8; signed long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFu8ll { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFs8c { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFs8i { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFs8ll { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFs8s { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFu8c { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFu8i { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFu8ll { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFu8ll_BFu8s { signed long long v1:8; signed long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8ll_BFu8s { signed long long v1:8; signed long long v2:8; unsigned short v3:8; };
struct BFs8ll_BFs8ll_BFu8s_BFs8c { signed long long v1:8; signed long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFs8i { signed long long v1:8; signed long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFs8ll { signed long long v1:8; signed long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFs8s { signed long long v1:8; signed long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFu8c { signed long long v1:8; signed long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFu8i { signed long long v1:8; signed long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFu8ll { signed long long v1:8; signed long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8ll_BFu8s_BFu8s { signed long long v1:8; signed long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s { signed long long v1:8; signed short v2:8; };
struct BFs8ll_BFs8s_BFs8c { signed long long v1:8; signed short v2:8; signed char v3:8; };
struct BFs8ll_BFs8s_BFs8c_BFs8c { signed long long v1:8; signed short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFs8i { signed long long v1:8; signed short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFs8ll { signed long long v1:8; signed short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFs8s { signed long long v1:8; signed short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFu8c { signed long long v1:8; signed short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFu8i { signed long long v1:8; signed short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFu8ll { signed long long v1:8; signed short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFs8c_BFu8s { signed long long v1:8; signed short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFs8i { signed long long v1:8; signed short v2:8; signed int v3:8; };
struct BFs8ll_BFs8s_BFs8i_BFs8c { signed long long v1:8; signed short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFs8i { signed long long v1:8; signed short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFs8ll { signed long long v1:8; signed short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFs8s { signed long long v1:8; signed short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFu8c { signed long long v1:8; signed short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFu8i { signed long long v1:8; signed short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFu8ll { signed long long v1:8; signed short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFs8i_BFu8s { signed long long v1:8; signed short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFs8ll { signed long long v1:8; signed short v2:8; signed long long v3:8; };
struct BFs8ll_BFs8s_BFs8ll_BFs8c { signed long long v1:8; signed short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFs8i { signed long long v1:8; signed short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFs8ll { signed long long v1:8; signed short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFs8s { signed long long v1:8; signed short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFu8c { signed long long v1:8; signed short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFu8i { signed long long v1:8; signed short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFu8ll { signed long long v1:8; signed short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFs8ll_BFu8s { signed long long v1:8; signed short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFs8s { signed long long v1:8; signed short v2:8; signed short v3:8; };
struct BFs8ll_BFs8s_BFs8s_BFs8c { signed long long v1:8; signed short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFs8i { signed long long v1:8; signed short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFs8ll { signed long long v1:8; signed short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFs8s { signed long long v1:8; signed short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFu8c { signed long long v1:8; signed short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFu8i { signed long long v1:8; signed short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFu8ll { signed long long v1:8; signed short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFs8s_BFu8s { signed long long v1:8; signed short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFu8c { signed long long v1:8; signed short v2:8; unsigned char v3:8; };
struct BFs8ll_BFs8s_BFu8c_BFs8c { signed long long v1:8; signed short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFs8i { signed long long v1:8; signed short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFs8ll { signed long long v1:8; signed short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFs8s { signed long long v1:8; signed short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFu8c { signed long long v1:8; signed short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFu8i { signed long long v1:8; signed short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFu8ll { signed long long v1:8; signed short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFu8c_BFu8s { signed long long v1:8; signed short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFu8i { signed long long v1:8; signed short v2:8; unsigned int v3:8; };
struct BFs8ll_BFs8s_BFu8i_BFs8c { signed long long v1:8; signed short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFs8i { signed long long v1:8; signed short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFs8ll { signed long long v1:8; signed short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFs8s { signed long long v1:8; signed short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFu8c { signed long long v1:8; signed short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFu8i { signed long long v1:8; signed short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFu8ll { signed long long v1:8; signed short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFu8i_BFu8s { signed long long v1:8; signed short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFu8ll { signed long long v1:8; signed short v2:8; unsigned long long v3:8; };
struct BFs8ll_BFs8s_BFu8ll_BFs8c { signed long long v1:8; signed short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFs8i { signed long long v1:8; signed short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFs8ll { signed long long v1:8; signed short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFs8s { signed long long v1:8; signed short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFu8c { signed long long v1:8; signed short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFu8i { signed long long v1:8; signed short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFu8ll { signed long long v1:8; signed short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFu8ll_BFu8s { signed long long v1:8; signed short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8s_BFu8s { signed long long v1:8; signed short v2:8; unsigned short v3:8; };
struct BFs8ll_BFs8s_BFu8s_BFs8c { signed long long v1:8; signed short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFs8i { signed long long v1:8; signed short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFs8ll { signed long long v1:8; signed short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFs8s { signed long long v1:8; signed short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFu8c { signed long long v1:8; signed short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFu8i { signed long long v1:8; signed short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFu8ll { signed long long v1:8; signed short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8s_BFu8s_BFu8s { signed long long v1:8; signed short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c { signed long long v1:8; unsigned char v2:8; };
struct BFs8ll_BFu8c_BFs8c { signed long long v1:8; unsigned char v2:8; signed char v3:8; };
struct BFs8ll_BFu8c_BFs8c_BFs8c { signed long long v1:8; unsigned char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFs8i { signed long long v1:8; unsigned char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFs8ll { signed long long v1:8; unsigned char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFs8s { signed long long v1:8; unsigned char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFu8c { signed long long v1:8; unsigned char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFu8i { signed long long v1:8; unsigned char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFu8ll { signed long long v1:8; unsigned char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFs8c_BFu8s { signed long long v1:8; unsigned char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFs8i { signed long long v1:8; unsigned char v2:8; signed int v3:8; };
struct BFs8ll_BFu8c_BFs8i_BFs8c { signed long long v1:8; unsigned char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFs8i { signed long long v1:8; unsigned char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFs8ll { signed long long v1:8; unsigned char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFs8s { signed long long v1:8; unsigned char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFu8c { signed long long v1:8; unsigned char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFu8i { signed long long v1:8; unsigned char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFu8ll { signed long long v1:8; unsigned char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFs8i_BFu8s { signed long long v1:8; unsigned char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFs8ll { signed long long v1:8; unsigned char v2:8; signed long long v3:8; };
struct BFs8ll_BFu8c_BFs8ll_BFs8c { signed long long v1:8; unsigned char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFs8i { signed long long v1:8; unsigned char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFs8ll { signed long long v1:8; unsigned char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFs8s { signed long long v1:8; unsigned char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFu8c { signed long long v1:8; unsigned char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFu8i { signed long long v1:8; unsigned char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFu8ll { signed long long v1:8; unsigned char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFs8ll_BFu8s { signed long long v1:8; unsigned char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFs8s { signed long long v1:8; unsigned char v2:8; signed short v3:8; };
struct BFs8ll_BFu8c_BFs8s_BFs8c { signed long long v1:8; unsigned char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFs8i { signed long long v1:8; unsigned char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFs8ll { signed long long v1:8; unsigned char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFs8s { signed long long v1:8; unsigned char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFu8c { signed long long v1:8; unsigned char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFu8i { signed long long v1:8; unsigned char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFu8ll { signed long long v1:8; unsigned char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFs8s_BFu8s { signed long long v1:8; unsigned char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFu8c { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; };
struct BFs8ll_BFu8c_BFu8c_BFs8c { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFs8i { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFs8ll { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFs8s { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFu8c { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFu8i { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFu8ll { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFu8c_BFu8s { signed long long v1:8; unsigned char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFu8i { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; };
struct BFs8ll_BFu8c_BFu8i_BFs8c { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFs8i { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFs8ll { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFs8s { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFu8c { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFu8i { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFu8ll { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFu8i_BFu8s { signed long long v1:8; unsigned char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFu8ll { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; };
struct BFs8ll_BFu8c_BFu8ll_BFs8c { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFs8i { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFs8ll { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFs8s { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFu8c { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFu8i { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFu8ll { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFu8ll_BFu8s { signed long long v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8c_BFu8s { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; };
struct BFs8ll_BFu8c_BFu8s_BFs8c { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFs8i { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFs8ll { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFs8s { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFu8c { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFu8i { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFu8ll { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8c_BFu8s_BFu8s { signed long long v1:8; unsigned char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i { signed long long v1:8; unsigned int v2:8; };
struct BFs8ll_BFu8i_BFs8c { signed long long v1:8; unsigned int v2:8; signed char v3:8; };
struct BFs8ll_BFu8i_BFs8c_BFs8c { signed long long v1:8; unsigned int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFs8i { signed long long v1:8; unsigned int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFs8ll { signed long long v1:8; unsigned int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFs8s { signed long long v1:8; unsigned int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFu8c { signed long long v1:8; unsigned int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFu8i { signed long long v1:8; unsigned int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFu8ll { signed long long v1:8; unsigned int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFs8c_BFu8s { signed long long v1:8; unsigned int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFs8i { signed long long v1:8; unsigned int v2:8; signed int v3:8; };
struct BFs8ll_BFu8i_BFs8i_BFs8c { signed long long v1:8; unsigned int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFs8i { signed long long v1:8; unsigned int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFs8ll { signed long long v1:8; unsigned int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFs8s { signed long long v1:8; unsigned int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFu8c { signed long long v1:8; unsigned int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFu8i { signed long long v1:8; unsigned int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFu8ll { signed long long v1:8; unsigned int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFs8i_BFu8s { signed long long v1:8; unsigned int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFs8ll { signed long long v1:8; unsigned int v2:8; signed long long v3:8; };
struct BFs8ll_BFu8i_BFs8ll_BFs8c { signed long long v1:8; unsigned int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFs8i { signed long long v1:8; unsigned int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFs8ll { signed long long v1:8; unsigned int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFs8s { signed long long v1:8; unsigned int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFu8c { signed long long v1:8; unsigned int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFu8i { signed long long v1:8; unsigned int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFu8ll { signed long long v1:8; unsigned int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFs8ll_BFu8s { signed long long v1:8; unsigned int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFs8s { signed long long v1:8; unsigned int v2:8; signed short v3:8; };
struct BFs8ll_BFu8i_BFs8s_BFs8c { signed long long v1:8; unsigned int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFs8i { signed long long v1:8; unsigned int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFs8ll { signed long long v1:8; unsigned int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFs8s { signed long long v1:8; unsigned int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFu8c { signed long long v1:8; unsigned int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFu8i { signed long long v1:8; unsigned int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFu8ll { signed long long v1:8; unsigned int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFs8s_BFu8s { signed long long v1:8; unsigned int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFu8c { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; };
struct BFs8ll_BFu8i_BFu8c_BFs8c { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFs8i { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFs8ll { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFs8s { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFu8c { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFu8i { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFu8ll { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFu8c_BFu8s { signed long long v1:8; unsigned int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFu8i { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; };
struct BFs8ll_BFu8i_BFu8i_BFs8c { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFs8i { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFs8ll { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFs8s { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFu8c { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFu8i { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFu8ll { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFu8i_BFu8s { signed long long v1:8; unsigned int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFu8ll { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; };
struct BFs8ll_BFu8i_BFu8ll_BFs8c { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFs8i { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFs8ll { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFs8s { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFu8c { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFu8i { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFu8ll { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFu8ll_BFu8s { signed long long v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8i_BFu8s { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; };
struct BFs8ll_BFu8i_BFu8s_BFs8c { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFs8i { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFs8ll { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFs8s { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFu8c { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFu8i { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFu8ll { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8i_BFu8s_BFu8s { signed long long v1:8; unsigned int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll { signed long long v1:8; unsigned long long v2:8; };
struct BFs8ll_BFu8ll_BFs8c { signed long long v1:8; unsigned long long v2:8; signed char v3:8; };
struct BFs8ll_BFu8ll_BFs8c_BFs8c { signed long long v1:8; unsigned long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFs8i { signed long long v1:8; unsigned long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFs8ll { signed long long v1:8; unsigned long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFs8s { signed long long v1:8; unsigned long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFu8c { signed long long v1:8; unsigned long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFu8i { signed long long v1:8; unsigned long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFu8ll { signed long long v1:8; unsigned long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFs8c_BFu8s { signed long long v1:8; unsigned long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFs8i { signed long long v1:8; unsigned long long v2:8; signed int v3:8; };
struct BFs8ll_BFu8ll_BFs8i_BFs8c { signed long long v1:8; unsigned long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFs8i { signed long long v1:8; unsigned long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFs8ll { signed long long v1:8; unsigned long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFs8s { signed long long v1:8; unsigned long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFu8c { signed long long v1:8; unsigned long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFu8i { signed long long v1:8; unsigned long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFu8ll { signed long long v1:8; unsigned long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFs8i_BFu8s { signed long long v1:8; unsigned long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFs8ll { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFs8c { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFs8i { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFs8ll { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFs8s { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFu8c { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFu8i { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFu8ll { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFs8ll_BFu8s { signed long long v1:8; unsigned long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFs8s { signed long long v1:8; unsigned long long v2:8; signed short v3:8; };
struct BFs8ll_BFu8ll_BFs8s_BFs8c { signed long long v1:8; unsigned long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFs8i { signed long long v1:8; unsigned long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFs8ll { signed long long v1:8; unsigned long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFs8s { signed long long v1:8; unsigned long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFu8c { signed long long v1:8; unsigned long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFu8i { signed long long v1:8; unsigned long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFu8ll { signed long long v1:8; unsigned long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFs8s_BFu8s { signed long long v1:8; unsigned long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFu8c { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; };
struct BFs8ll_BFu8ll_BFu8c_BFs8c { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFs8i { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFs8ll { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFs8s { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFu8c { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFu8i { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFu8ll { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFu8c_BFu8s { signed long long v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFu8i { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; };
struct BFs8ll_BFu8ll_BFu8i_BFs8c { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFs8i { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFs8ll { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFs8s { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFu8c { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFu8i { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFu8ll { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFu8i_BFu8s { signed long long v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFu8ll { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFs8c { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFs8i { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFs8ll { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFs8s { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFu8c { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFu8i { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFu8ll { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFu8ll_BFu8s { signed long long v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8ll_BFu8s { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; };
struct BFs8ll_BFu8ll_BFu8s_BFs8c { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFs8i { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFs8ll { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFs8s { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFu8c { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFu8i { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFu8ll { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8ll_BFu8s_BFu8s { signed long long v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s { signed long long v1:8; unsigned short v2:8; };
struct BFs8ll_BFu8s_BFs8c { signed long long v1:8; unsigned short v2:8; signed char v3:8; };
struct BFs8ll_BFu8s_BFs8c_BFs8c { signed long long v1:8; unsigned short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFs8i { signed long long v1:8; unsigned short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFs8ll { signed long long v1:8; unsigned short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFs8s { signed long long v1:8; unsigned short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFu8c { signed long long v1:8; unsigned short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFu8i { signed long long v1:8; unsigned short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFu8ll { signed long long v1:8; unsigned short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFs8c_BFu8s { signed long long v1:8; unsigned short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFs8i { signed long long v1:8; unsigned short v2:8; signed int v3:8; };
struct BFs8ll_BFu8s_BFs8i_BFs8c { signed long long v1:8; unsigned short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFs8i { signed long long v1:8; unsigned short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFs8ll { signed long long v1:8; unsigned short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFs8s { signed long long v1:8; unsigned short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFu8c { signed long long v1:8; unsigned short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFu8i { signed long long v1:8; unsigned short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFu8ll { signed long long v1:8; unsigned short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFs8i_BFu8s { signed long long v1:8; unsigned short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFs8ll { signed long long v1:8; unsigned short v2:8; signed long long v3:8; };
struct BFs8ll_BFu8s_BFs8ll_BFs8c { signed long long v1:8; unsigned short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFs8i { signed long long v1:8; unsigned short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFs8ll { signed long long v1:8; unsigned short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFs8s { signed long long v1:8; unsigned short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFu8c { signed long long v1:8; unsigned short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFu8i { signed long long v1:8; unsigned short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFu8ll { signed long long v1:8; unsigned short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFs8ll_BFu8s { signed long long v1:8; unsigned short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFs8s { signed long long v1:8; unsigned short v2:8; signed short v3:8; };
struct BFs8ll_BFu8s_BFs8s_BFs8c { signed long long v1:8; unsigned short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFs8i { signed long long v1:8; unsigned short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFs8ll { signed long long v1:8; unsigned short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFs8s { signed long long v1:8; unsigned short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFu8c { signed long long v1:8; unsigned short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFu8i { signed long long v1:8; unsigned short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFu8ll { signed long long v1:8; unsigned short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFs8s_BFu8s { signed long long v1:8; unsigned short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFu8c { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; };
struct BFs8ll_BFu8s_BFu8c_BFs8c { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFs8i { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFs8ll { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFs8s { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFu8c { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFu8i { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFu8ll { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFu8c_BFu8s { signed long long v1:8; unsigned short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFu8i { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; };
struct BFs8ll_BFu8s_BFu8i_BFs8c { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFs8i { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFs8ll { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFs8s { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFu8c { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFu8i { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFu8ll { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFu8i_BFu8s { signed long long v1:8; unsigned short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFu8ll { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; };
struct BFs8ll_BFu8s_BFu8ll_BFs8c { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFs8i { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFs8ll { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFs8s { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFu8c { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFu8i { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFu8ll { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFu8ll_BFu8s { signed long long v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFu8s_BFu8s { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; };
struct BFs8ll_BFu8s_BFu8s_BFs8c { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFs8i { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFs8ll { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFs8s { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFu8c { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFu8i { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFu8ll { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFu8s_BFu8s_BFu8s { signed long long v1:8; unsigned short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c { signed short v1:8; signed char v2:8; };
struct BFs8s_BFs8c_BFs8c { signed short v1:8; signed char v2:8; signed char v3:8; };
struct BFs8s_BFs8c_BFs8c_BFs8c { signed short v1:8; signed char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFs8c_BFs8i { signed short v1:8; signed char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFs8c_BFs8ll { signed short v1:8; signed char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFs8c_BFs8s { signed short v1:8; signed char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFs8c_BFu8c { signed short v1:8; signed char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFs8c_BFu8i { signed short v1:8; signed char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFs8c_BFu8ll { signed short v1:8; signed char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFs8c_BFu8s { signed short v1:8; signed char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFs8i { signed short v1:8; signed char v2:8; signed int v3:8; };
struct BFs8s_BFs8c_BFs8i_BFs8c { signed short v1:8; signed char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFs8i_BFs8i { signed short v1:8; signed char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFs8i_BFs8ll { signed short v1:8; signed char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFs8i_BFs8s { signed short v1:8; signed char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFs8i_BFu8c { signed short v1:8; signed char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFs8i_BFu8i { signed short v1:8; signed char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFs8i_BFu8ll { signed short v1:8; signed char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFs8i_BFu8s { signed short v1:8; signed char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFs8ll { signed short v1:8; signed char v2:8; signed long long v3:8; };
struct BFs8s_BFs8c_BFs8ll_BFs8c { signed short v1:8; signed char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFs8i { signed short v1:8; signed char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFs8ll { signed short v1:8; signed char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFs8s { signed short v1:8; signed char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFu8c { signed short v1:8; signed char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFu8i { signed short v1:8; signed char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFu8ll { signed short v1:8; signed char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFs8ll_BFu8s { signed short v1:8; signed char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFs8s { signed short v1:8; signed char v2:8; signed short v3:8; };
struct BFs8s_BFs8c_BFs8s_BFs8c { signed short v1:8; signed char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFs8s_BFs8i { signed short v1:8; signed char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFs8s_BFs8ll { signed short v1:8; signed char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFs8s_BFs8s { signed short v1:8; signed char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFs8s_BFu8c { signed short v1:8; signed char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFs8s_BFu8i { signed short v1:8; signed char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFs8s_BFu8ll { signed short v1:8; signed char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFs8s_BFu8s { signed short v1:8; signed char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFu8c { signed short v1:8; signed char v2:8; unsigned char v3:8; };
struct BFs8s_BFs8c_BFu8c_BFs8c { signed short v1:8; signed char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFu8c_BFs8i { signed short v1:8; signed char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFu8c_BFs8ll { signed short v1:8; signed char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFu8c_BFs8s { signed short v1:8; signed char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFu8c_BFu8c { signed short v1:8; signed char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFu8c_BFu8i { signed short v1:8; signed char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFu8c_BFu8ll { signed short v1:8; signed char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFu8c_BFu8s { signed short v1:8; signed char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFu8i { signed short v1:8; signed char v2:8; unsigned int v3:8; };
struct BFs8s_BFs8c_BFu8i_BFs8c { signed short v1:8; signed char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFu8i_BFs8i { signed short v1:8; signed char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFu8i_BFs8ll { signed short v1:8; signed char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFu8i_BFs8s { signed short v1:8; signed char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFu8i_BFu8c { signed short v1:8; signed char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFu8i_BFu8i { signed short v1:8; signed char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFu8i_BFu8ll { signed short v1:8; signed char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFu8i_BFu8s { signed short v1:8; signed char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFu8ll { signed short v1:8; signed char v2:8; unsigned long long v3:8; };
struct BFs8s_BFs8c_BFu8ll_BFs8c { signed short v1:8; signed char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFs8i { signed short v1:8; signed char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFs8ll { signed short v1:8; signed char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFs8s { signed short v1:8; signed char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFu8c { signed short v1:8; signed char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFu8i { signed short v1:8; signed char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFu8ll { signed short v1:8; signed char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFu8ll_BFu8s { signed short v1:8; signed char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8c_BFu8s { signed short v1:8; signed char v2:8; unsigned short v3:8; };
struct BFs8s_BFs8c_BFu8s_BFs8c { signed short v1:8; signed char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFs8c_BFu8s_BFs8i { signed short v1:8; signed char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFs8c_BFu8s_BFs8ll { signed short v1:8; signed char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFs8c_BFu8s_BFs8s { signed short v1:8; signed char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFs8c_BFu8s_BFu8c { signed short v1:8; signed char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8c_BFu8s_BFu8i { signed short v1:8; signed char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8c_BFu8s_BFu8ll { signed short v1:8; signed char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8c_BFu8s_BFu8s { signed short v1:8; signed char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i { signed short v1:8; signed int v2:8; };
struct BFs8s_BFs8i_BFs8c { signed short v1:8; signed int v2:8; signed char v3:8; };
struct BFs8s_BFs8i_BFs8c_BFs8c { signed short v1:8; signed int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFs8c_BFs8i { signed short v1:8; signed int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFs8c_BFs8ll { signed short v1:8; signed int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFs8c_BFs8s { signed short v1:8; signed int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFs8c_BFu8c { signed short v1:8; signed int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFs8c_BFu8i { signed short v1:8; signed int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFs8c_BFu8ll { signed short v1:8; signed int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFs8c_BFu8s { signed short v1:8; signed int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFs8i { signed short v1:8; signed int v2:8; signed int v3:8; };
struct BFs8s_BFs8i_BFs8i_BFs8c { signed short v1:8; signed int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFs8i_BFs8i { signed short v1:8; signed int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFs8i_BFs8ll { signed short v1:8; signed int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFs8i_BFs8s { signed short v1:8; signed int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFs8i_BFu8c { signed short v1:8; signed int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFs8i_BFu8i { signed short v1:8; signed int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFs8i_BFu8ll { signed short v1:8; signed int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFs8i_BFu8s { signed short v1:8; signed int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFs8ll { signed short v1:8; signed int v2:8; signed long long v3:8; };
struct BFs8s_BFs8i_BFs8ll_BFs8c { signed short v1:8; signed int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFs8i { signed short v1:8; signed int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFs8ll { signed short v1:8; signed int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFs8s { signed short v1:8; signed int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFu8c { signed short v1:8; signed int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFu8i { signed short v1:8; signed int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFu8ll { signed short v1:8; signed int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFs8ll_BFu8s { signed short v1:8; signed int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFs8s { signed short v1:8; signed int v2:8; signed short v3:8; };
struct BFs8s_BFs8i_BFs8s_BFs8c { signed short v1:8; signed int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFs8s_BFs8i { signed short v1:8; signed int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFs8s_BFs8ll { signed short v1:8; signed int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFs8s_BFs8s { signed short v1:8; signed int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFs8s_BFu8c { signed short v1:8; signed int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFs8s_BFu8i { signed short v1:8; signed int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFs8s_BFu8ll { signed short v1:8; signed int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFs8s_BFu8s { signed short v1:8; signed int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFu8c { signed short v1:8; signed int v2:8; unsigned char v3:8; };
struct BFs8s_BFs8i_BFu8c_BFs8c { signed short v1:8; signed int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFu8c_BFs8i { signed short v1:8; signed int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFu8c_BFs8ll { signed short v1:8; signed int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFu8c_BFs8s { signed short v1:8; signed int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFu8c_BFu8c { signed short v1:8; signed int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFu8c_BFu8i { signed short v1:8; signed int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFu8c_BFu8ll { signed short v1:8; signed int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFu8c_BFu8s { signed short v1:8; signed int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFu8i { signed short v1:8; signed int v2:8; unsigned int v3:8; };
struct BFs8s_BFs8i_BFu8i_BFs8c { signed short v1:8; signed int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFu8i_BFs8i { signed short v1:8; signed int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFu8i_BFs8ll { signed short v1:8; signed int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFu8i_BFs8s { signed short v1:8; signed int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFu8i_BFu8c { signed short v1:8; signed int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFu8i_BFu8i { signed short v1:8; signed int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFu8i_BFu8ll { signed short v1:8; signed int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFu8i_BFu8s { signed short v1:8; signed int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFu8ll { signed short v1:8; signed int v2:8; unsigned long long v3:8; };
struct BFs8s_BFs8i_BFu8ll_BFs8c { signed short v1:8; signed int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFs8i { signed short v1:8; signed int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFs8ll { signed short v1:8; signed int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFs8s { signed short v1:8; signed int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFu8c { signed short v1:8; signed int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFu8i { signed short v1:8; signed int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFu8ll { signed short v1:8; signed int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFu8ll_BFu8s { signed short v1:8; signed int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8i_BFu8s { signed short v1:8; signed int v2:8; unsigned short v3:8; };
struct BFs8s_BFs8i_BFu8s_BFs8c { signed short v1:8; signed int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFs8i_BFu8s_BFs8i { signed short v1:8; signed int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFs8i_BFu8s_BFs8ll { signed short v1:8; signed int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFs8i_BFu8s_BFs8s { signed short v1:8; signed int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFs8i_BFu8s_BFu8c { signed short v1:8; signed int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8i_BFu8s_BFu8i { signed short v1:8; signed int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8i_BFu8s_BFu8ll { signed short v1:8; signed int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8i_BFu8s_BFu8s { signed short v1:8; signed int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll { signed short v1:8; signed long long v2:8; };
struct BFs8s_BFs8ll_BFs8c { signed short v1:8; signed long long v2:8; signed char v3:8; };
struct BFs8s_BFs8ll_BFs8c_BFs8c { signed short v1:8; signed long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFs8i { signed short v1:8; signed long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFs8ll { signed short v1:8; signed long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFs8s { signed short v1:8; signed long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFu8c { signed short v1:8; signed long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFu8i { signed short v1:8; signed long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFu8ll { signed short v1:8; signed long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFs8c_BFu8s { signed short v1:8; signed long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFs8i { signed short v1:8; signed long long v2:8; signed int v3:8; };
struct BFs8s_BFs8ll_BFs8i_BFs8c { signed short v1:8; signed long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFs8i { signed short v1:8; signed long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFs8ll { signed short v1:8; signed long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFs8s { signed short v1:8; signed long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFu8c { signed short v1:8; signed long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFu8i { signed short v1:8; signed long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFu8ll { signed short v1:8; signed long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFs8i_BFu8s { signed short v1:8; signed long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFs8ll { signed short v1:8; signed long long v2:8; signed long long v3:8; };
struct BFs8s_BFs8ll_BFs8ll_BFs8c { signed short v1:8; signed long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFs8i { signed short v1:8; signed long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFs8ll { signed short v1:8; signed long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFs8s { signed short v1:8; signed long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFu8c { signed short v1:8; signed long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFu8i { signed short v1:8; signed long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFu8ll { signed short v1:8; signed long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFs8ll_BFu8s { signed short v1:8; signed long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFs8s { signed short v1:8; signed long long v2:8; signed short v3:8; };
struct BFs8s_BFs8ll_BFs8s_BFs8c { signed short v1:8; signed long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFs8i { signed short v1:8; signed long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFs8ll { signed short v1:8; signed long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFs8s { signed short v1:8; signed long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFu8c { signed short v1:8; signed long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFu8i { signed short v1:8; signed long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFu8ll { signed short v1:8; signed long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFs8s_BFu8s { signed short v1:8; signed long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFu8c { signed short v1:8; signed long long v2:8; unsigned char v3:8; };
struct BFs8s_BFs8ll_BFu8c_BFs8c { signed short v1:8; signed long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFs8i { signed short v1:8; signed long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFs8ll { signed short v1:8; signed long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFs8s { signed short v1:8; signed long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFu8c { signed short v1:8; signed long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFu8i { signed short v1:8; signed long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFu8ll { signed short v1:8; signed long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFu8c_BFu8s { signed short v1:8; signed long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFu8i { signed short v1:8; signed long long v2:8; unsigned int v3:8; };
struct BFs8s_BFs8ll_BFu8i_BFs8c { signed short v1:8; signed long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFs8i { signed short v1:8; signed long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFs8ll { signed short v1:8; signed long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFs8s { signed short v1:8; signed long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFu8c { signed short v1:8; signed long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFu8i { signed short v1:8; signed long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFu8ll { signed short v1:8; signed long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFu8i_BFu8s { signed short v1:8; signed long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFu8ll { signed short v1:8; signed long long v2:8; unsigned long long v3:8; };
struct BFs8s_BFs8ll_BFu8ll_BFs8c { signed short v1:8; signed long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFs8i { signed short v1:8; signed long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFs8ll { signed short v1:8; signed long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFs8s { signed short v1:8; signed long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFu8c { signed short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFu8i { signed short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFu8ll { signed short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFu8ll_BFu8s { signed short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8ll_BFu8s { signed short v1:8; signed long long v2:8; unsigned short v3:8; };
struct BFs8s_BFs8ll_BFu8s_BFs8c { signed short v1:8; signed long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFs8i { signed short v1:8; signed long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFs8ll { signed short v1:8; signed long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFs8s { signed short v1:8; signed long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFu8c { signed short v1:8; signed long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFu8i { signed short v1:8; signed long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFu8ll { signed short v1:8; signed long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8ll_BFu8s_BFu8s { signed short v1:8; signed long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s { signed short v1:8; signed short v2:8; };
struct BFs8s_BFs8s_BFs8c { signed short v1:8; signed short v2:8; signed char v3:8; };
struct BFs8s_BFs8s_BFs8c_BFs8c { signed short v1:8; signed short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFs8c_BFs8i { signed short v1:8; signed short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFs8c_BFs8ll { signed short v1:8; signed short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFs8c_BFs8s { signed short v1:8; signed short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFs8c_BFu8c { signed short v1:8; signed short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFs8c_BFu8i { signed short v1:8; signed short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFs8c_BFu8ll { signed short v1:8; signed short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFs8c_BFu8s { signed short v1:8; signed short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFs8i { signed short v1:8; signed short v2:8; signed int v3:8; };
struct BFs8s_BFs8s_BFs8i_BFs8c { signed short v1:8; signed short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFs8i_BFs8i { signed short v1:8; signed short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFs8i_BFs8ll { signed short v1:8; signed short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFs8i_BFs8s { signed short v1:8; signed short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFs8i_BFu8c { signed short v1:8; signed short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFs8i_BFu8i { signed short v1:8; signed short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFs8i_BFu8ll { signed short v1:8; signed short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFs8i_BFu8s { signed short v1:8; signed short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFs8ll { signed short v1:8; signed short v2:8; signed long long v3:8; };
struct BFs8s_BFs8s_BFs8ll_BFs8c { signed short v1:8; signed short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFs8i { signed short v1:8; signed short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFs8ll { signed short v1:8; signed short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFs8s { signed short v1:8; signed short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFu8c { signed short v1:8; signed short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFu8i { signed short v1:8; signed short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFu8ll { signed short v1:8; signed short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFs8ll_BFu8s { signed short v1:8; signed short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFs8s { signed short v1:8; signed short v2:8; signed short v3:8; };
struct BFs8s_BFs8s_BFs8s_BFs8c { signed short v1:8; signed short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFs8s_BFs8i { signed short v1:8; signed short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFs8s_BFs8ll { signed short v1:8; signed short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFs8s_BFs8s { signed short v1:8; signed short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFs8s_BFu8c { signed short v1:8; signed short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFs8s_BFu8i { signed short v1:8; signed short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFs8s_BFu8ll { signed short v1:8; signed short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFs8s_BFu8s { signed short v1:8; signed short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFu8c { signed short v1:8; signed short v2:8; unsigned char v3:8; };
struct BFs8s_BFs8s_BFu8c_BFs8c { signed short v1:8; signed short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFu8c_BFs8i { signed short v1:8; signed short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFu8c_BFs8ll { signed short v1:8; signed short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFu8c_BFs8s { signed short v1:8; signed short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFu8c_BFu8c { signed short v1:8; signed short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFu8c_BFu8i { signed short v1:8; signed short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFu8c_BFu8ll { signed short v1:8; signed short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFu8c_BFu8s { signed short v1:8; signed short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFu8i { signed short v1:8; signed short v2:8; unsigned int v3:8; };
struct BFs8s_BFs8s_BFu8i_BFs8c { signed short v1:8; signed short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFu8i_BFs8i { signed short v1:8; signed short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFu8i_BFs8ll { signed short v1:8; signed short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFu8i_BFs8s { signed short v1:8; signed short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFu8i_BFu8c { signed short v1:8; signed short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFu8i_BFu8i { signed short v1:8; signed short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFu8i_BFu8ll { signed short v1:8; signed short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFu8i_BFu8s { signed short v1:8; signed short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFu8ll { signed short v1:8; signed short v2:8; unsigned long long v3:8; };
struct BFs8s_BFs8s_BFu8ll_BFs8c { signed short v1:8; signed short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFs8i { signed short v1:8; signed short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFs8ll { signed short v1:8; signed short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFs8s { signed short v1:8; signed short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFu8c { signed short v1:8; signed short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFu8i { signed short v1:8; signed short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFu8ll { signed short v1:8; signed short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFu8ll_BFu8s { signed short v1:8; signed short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFs8s_BFu8s { signed short v1:8; signed short v2:8; unsigned short v3:8; };
struct BFs8s_BFs8s_BFu8s_BFs8c { signed short v1:8; signed short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFs8s_BFu8s_BFs8i { signed short v1:8; signed short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFs8s_BFu8s_BFs8ll { signed short v1:8; signed short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFs8s_BFu8s_BFs8s { signed short v1:8; signed short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFs8s_BFu8s_BFu8c { signed short v1:8; signed short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFs8s_BFu8s_BFu8i { signed short v1:8; signed short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFs8s_BFu8s_BFu8ll { signed short v1:8; signed short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFs8s_BFu8s_BFu8s { signed short v1:8; signed short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c { signed short v1:8; unsigned char v2:8; };
struct BFs8s_BFu8c_BFs8c { signed short v1:8; unsigned char v2:8; signed char v3:8; };
struct BFs8s_BFu8c_BFs8c_BFs8c { signed short v1:8; unsigned char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFs8c_BFs8i { signed short v1:8; unsigned char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFs8c_BFs8ll { signed short v1:8; unsigned char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFs8c_BFs8s { signed short v1:8; unsigned char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFs8c_BFu8c { signed short v1:8; unsigned char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFs8c_BFu8i { signed short v1:8; unsigned char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFs8c_BFu8ll { signed short v1:8; unsigned char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFs8c_BFu8s { signed short v1:8; unsigned char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFs8i { signed short v1:8; unsigned char v2:8; signed int v3:8; };
struct BFs8s_BFu8c_BFs8i_BFs8c { signed short v1:8; unsigned char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFs8i_BFs8i { signed short v1:8; unsigned char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFs8i_BFs8ll { signed short v1:8; unsigned char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFs8i_BFs8s { signed short v1:8; unsigned char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFs8i_BFu8c { signed short v1:8; unsigned char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFs8i_BFu8i { signed short v1:8; unsigned char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFs8i_BFu8ll { signed short v1:8; unsigned char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFs8i_BFu8s { signed short v1:8; unsigned char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFs8ll { signed short v1:8; unsigned char v2:8; signed long long v3:8; };
struct BFs8s_BFu8c_BFs8ll_BFs8c { signed short v1:8; unsigned char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFs8i { signed short v1:8; unsigned char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFs8ll { signed short v1:8; unsigned char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFs8s { signed short v1:8; unsigned char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFu8c { signed short v1:8; unsigned char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFu8i { signed short v1:8; unsigned char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFu8ll { signed short v1:8; unsigned char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFs8ll_BFu8s { signed short v1:8; unsigned char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFs8s { signed short v1:8; unsigned char v2:8; signed short v3:8; };
struct BFs8s_BFu8c_BFs8s_BFs8c { signed short v1:8; unsigned char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFs8s_BFs8i { signed short v1:8; unsigned char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFs8s_BFs8ll { signed short v1:8; unsigned char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFs8s_BFs8s { signed short v1:8; unsigned char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFs8s_BFu8c { signed short v1:8; unsigned char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFs8s_BFu8i { signed short v1:8; unsigned char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFs8s_BFu8ll { signed short v1:8; unsigned char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFs8s_BFu8s { signed short v1:8; unsigned char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFu8c { signed short v1:8; unsigned char v2:8; unsigned char v3:8; };
struct BFs8s_BFu8c_BFu8c_BFs8c { signed short v1:8; unsigned char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFu8c_BFs8i { signed short v1:8; unsigned char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFu8c_BFs8ll { signed short v1:8; unsigned char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFu8c_BFs8s { signed short v1:8; unsigned char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFu8c_BFu8c { signed short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFu8c_BFu8i { signed short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFu8c_BFu8ll { signed short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFu8c_BFu8s { signed short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFu8i { signed short v1:8; unsigned char v2:8; unsigned int v3:8; };
struct BFs8s_BFu8c_BFu8i_BFs8c { signed short v1:8; unsigned char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFu8i_BFs8i { signed short v1:8; unsigned char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFu8i_BFs8ll { signed short v1:8; unsigned char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFu8i_BFs8s { signed short v1:8; unsigned char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFu8i_BFu8c { signed short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFu8i_BFu8i { signed short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFu8i_BFu8ll { signed short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFu8i_BFu8s { signed short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFu8ll { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; };
struct BFs8s_BFu8c_BFu8ll_BFs8c { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFs8i { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFs8ll { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFs8s { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFu8c { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFu8i { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFu8ll { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFu8ll_BFu8s { signed short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8c_BFu8s { signed short v1:8; unsigned char v2:8; unsigned short v3:8; };
struct BFs8s_BFu8c_BFu8s_BFs8c { signed short v1:8; unsigned char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFu8c_BFu8s_BFs8i { signed short v1:8; unsigned char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFu8c_BFu8s_BFs8ll { signed short v1:8; unsigned char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFu8c_BFu8s_BFs8s { signed short v1:8; unsigned char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFu8c_BFu8s_BFu8c { signed short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8c_BFu8s_BFu8i { signed short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8c_BFu8s_BFu8ll { signed short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8c_BFu8s_BFu8s { signed short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i { signed short v1:8; unsigned int v2:8; };
struct BFs8s_BFu8i_BFs8c { signed short v1:8; unsigned int v2:8; signed char v3:8; };
struct BFs8s_BFu8i_BFs8c_BFs8c { signed short v1:8; unsigned int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFs8c_BFs8i { signed short v1:8; unsigned int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFs8c_BFs8ll { signed short v1:8; unsigned int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFs8c_BFs8s { signed short v1:8; unsigned int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFs8c_BFu8c { signed short v1:8; unsigned int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFs8c_BFu8i { signed short v1:8; unsigned int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFs8c_BFu8ll { signed short v1:8; unsigned int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFs8c_BFu8s { signed short v1:8; unsigned int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFs8i { signed short v1:8; unsigned int v2:8; signed int v3:8; };
struct BFs8s_BFu8i_BFs8i_BFs8c { signed short v1:8; unsigned int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFs8i_BFs8i { signed short v1:8; unsigned int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFs8i_BFs8ll { signed short v1:8; unsigned int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFs8i_BFs8s { signed short v1:8; unsigned int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFs8i_BFu8c { signed short v1:8; unsigned int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFs8i_BFu8i { signed short v1:8; unsigned int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFs8i_BFu8ll { signed short v1:8; unsigned int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFs8i_BFu8s { signed short v1:8; unsigned int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFs8ll { signed short v1:8; unsigned int v2:8; signed long long v3:8; };
struct BFs8s_BFu8i_BFs8ll_BFs8c { signed short v1:8; unsigned int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFs8i { signed short v1:8; unsigned int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFs8ll { signed short v1:8; unsigned int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFs8s { signed short v1:8; unsigned int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFu8c { signed short v1:8; unsigned int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFu8i { signed short v1:8; unsigned int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFu8ll { signed short v1:8; unsigned int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFs8ll_BFu8s { signed short v1:8; unsigned int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFs8s { signed short v1:8; unsigned int v2:8; signed short v3:8; };
struct BFs8s_BFu8i_BFs8s_BFs8c { signed short v1:8; unsigned int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFs8s_BFs8i { signed short v1:8; unsigned int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFs8s_BFs8ll { signed short v1:8; unsigned int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFs8s_BFs8s { signed short v1:8; unsigned int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFs8s_BFu8c { signed short v1:8; unsigned int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFs8s_BFu8i { signed short v1:8; unsigned int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFs8s_BFu8ll { signed short v1:8; unsigned int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFs8s_BFu8s { signed short v1:8; unsigned int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFu8c { signed short v1:8; unsigned int v2:8; unsigned char v3:8; };
struct BFs8s_BFu8i_BFu8c_BFs8c { signed short v1:8; unsigned int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFu8c_BFs8i { signed short v1:8; unsigned int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFu8c_BFs8ll { signed short v1:8; unsigned int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFu8c_BFs8s { signed short v1:8; unsigned int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFu8c_BFu8c { signed short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFu8c_BFu8i { signed short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFu8c_BFu8ll { signed short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFu8c_BFu8s { signed short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFu8i { signed short v1:8; unsigned int v2:8; unsigned int v3:8; };
struct BFs8s_BFu8i_BFu8i_BFs8c { signed short v1:8; unsigned int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFu8i_BFs8i { signed short v1:8; unsigned int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFu8i_BFs8ll { signed short v1:8; unsigned int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFu8i_BFs8s { signed short v1:8; unsigned int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFu8i_BFu8c { signed short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFu8i_BFu8i { signed short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFu8i_BFu8ll { signed short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFu8i_BFu8s { signed short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFu8ll { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; };
struct BFs8s_BFu8i_BFu8ll_BFs8c { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFs8i { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFs8ll { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFs8s { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFu8c { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFu8i { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFu8ll { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFu8ll_BFu8s { signed short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8i_BFu8s { signed short v1:8; unsigned int v2:8; unsigned short v3:8; };
struct BFs8s_BFu8i_BFu8s_BFs8c { signed short v1:8; unsigned int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFu8i_BFu8s_BFs8i { signed short v1:8; unsigned int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFu8i_BFu8s_BFs8ll { signed short v1:8; unsigned int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFu8i_BFu8s_BFs8s { signed short v1:8; unsigned int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFu8i_BFu8s_BFu8c { signed short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8i_BFu8s_BFu8i { signed short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8i_BFu8s_BFu8ll { signed short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8i_BFu8s_BFu8s { signed short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll { signed short v1:8; unsigned long long v2:8; };
struct BFs8s_BFu8ll_BFs8c { signed short v1:8; unsigned long long v2:8; signed char v3:8; };
struct BFs8s_BFu8ll_BFs8c_BFs8c { signed short v1:8; unsigned long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFs8i { signed short v1:8; unsigned long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFs8ll { signed short v1:8; unsigned long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFs8s { signed short v1:8; unsigned long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFu8c { signed short v1:8; unsigned long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFu8i { signed short v1:8; unsigned long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFu8ll { signed short v1:8; unsigned long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFs8c_BFu8s { signed short v1:8; unsigned long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFs8i { signed short v1:8; unsigned long long v2:8; signed int v3:8; };
struct BFs8s_BFu8ll_BFs8i_BFs8c { signed short v1:8; unsigned long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFs8i { signed short v1:8; unsigned long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFs8ll { signed short v1:8; unsigned long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFs8s { signed short v1:8; unsigned long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFu8c { signed short v1:8; unsigned long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFu8i { signed short v1:8; unsigned long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFu8ll { signed short v1:8; unsigned long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFs8i_BFu8s { signed short v1:8; unsigned long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFs8ll { signed short v1:8; unsigned long long v2:8; signed long long v3:8; };
struct BFs8s_BFu8ll_BFs8ll_BFs8c { signed short v1:8; unsigned long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFs8i { signed short v1:8; unsigned long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFs8ll { signed short v1:8; unsigned long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFs8s { signed short v1:8; unsigned long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFu8c { signed short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFu8i { signed short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFu8ll { signed short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFs8ll_BFu8s { signed short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFs8s { signed short v1:8; unsigned long long v2:8; signed short v3:8; };
struct BFs8s_BFu8ll_BFs8s_BFs8c { signed short v1:8; unsigned long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFs8i { signed short v1:8; unsigned long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFs8ll { signed short v1:8; unsigned long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFs8s { signed short v1:8; unsigned long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFu8c { signed short v1:8; unsigned long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFu8i { signed short v1:8; unsigned long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFu8ll { signed short v1:8; unsigned long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFs8s_BFu8s { signed short v1:8; unsigned long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFu8c { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; };
struct BFs8s_BFu8ll_BFu8c_BFs8c { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFs8i { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFs8ll { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFs8s { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFu8c { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFu8i { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFu8ll { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFu8c_BFu8s { signed short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFu8i { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; };
struct BFs8s_BFu8ll_BFu8i_BFs8c { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFs8i { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFs8ll { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFs8s { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFu8c { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFu8i { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFu8ll { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFu8i_BFu8s { signed short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFu8ll { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; };
struct BFs8s_BFu8ll_BFu8ll_BFs8c { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFs8i { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFs8ll { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFs8s { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFu8c { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFu8i { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFu8ll { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFu8ll_BFu8s { signed short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8ll_BFu8s { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; };
struct BFs8s_BFu8ll_BFu8s_BFs8c { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFs8i { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFs8ll { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFs8s { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFu8c { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFu8i { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFu8ll { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8ll_BFu8s_BFu8s { signed short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s { signed short v1:8; unsigned short v2:8; };
struct BFs8s_BFu8s_BFs8c { signed short v1:8; unsigned short v2:8; signed char v3:8; };
struct BFs8s_BFu8s_BFs8c_BFs8c { signed short v1:8; unsigned short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFs8c_BFs8i { signed short v1:8; unsigned short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFs8c_BFs8ll { signed short v1:8; unsigned short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFs8c_BFs8s { signed short v1:8; unsigned short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFs8c_BFu8c { signed short v1:8; unsigned short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFs8c_BFu8i { signed short v1:8; unsigned short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFs8c_BFu8ll { signed short v1:8; unsigned short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFs8c_BFu8s { signed short v1:8; unsigned short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFs8i { signed short v1:8; unsigned short v2:8; signed int v3:8; };
struct BFs8s_BFu8s_BFs8i_BFs8c { signed short v1:8; unsigned short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFs8i_BFs8i { signed short v1:8; unsigned short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFs8i_BFs8ll { signed short v1:8; unsigned short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFs8i_BFs8s { signed short v1:8; unsigned short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFs8i_BFu8c { signed short v1:8; unsigned short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFs8i_BFu8i { signed short v1:8; unsigned short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFs8i_BFu8ll { signed short v1:8; unsigned short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFs8i_BFu8s { signed short v1:8; unsigned short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFs8ll { signed short v1:8; unsigned short v2:8; signed long long v3:8; };
struct BFs8s_BFu8s_BFs8ll_BFs8c { signed short v1:8; unsigned short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFs8i { signed short v1:8; unsigned short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFs8ll { signed short v1:8; unsigned short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFs8s { signed short v1:8; unsigned short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFu8c { signed short v1:8; unsigned short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFu8i { signed short v1:8; unsigned short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFu8ll { signed short v1:8; unsigned short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFs8ll_BFu8s { signed short v1:8; unsigned short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFs8s { signed short v1:8; unsigned short v2:8; signed short v3:8; };
struct BFs8s_BFu8s_BFs8s_BFs8c { signed short v1:8; unsigned short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFs8s_BFs8i { signed short v1:8; unsigned short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFs8s_BFs8ll { signed short v1:8; unsigned short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFs8s_BFs8s { signed short v1:8; unsigned short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFs8s_BFu8c { signed short v1:8; unsigned short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFs8s_BFu8i { signed short v1:8; unsigned short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFs8s_BFu8ll { signed short v1:8; unsigned short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFs8s_BFu8s { signed short v1:8; unsigned short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFu8c { signed short v1:8; unsigned short v2:8; unsigned char v3:8; };
struct BFs8s_BFu8s_BFu8c_BFs8c { signed short v1:8; unsigned short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFu8c_BFs8i { signed short v1:8; unsigned short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFu8c_BFs8ll { signed short v1:8; unsigned short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFu8c_BFs8s { signed short v1:8; unsigned short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFu8c_BFu8c { signed short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFu8c_BFu8i { signed short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFu8c_BFu8ll { signed short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFu8c_BFu8s { signed short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFu8i { signed short v1:8; unsigned short v2:8; unsigned int v3:8; };
struct BFs8s_BFu8s_BFu8i_BFs8c { signed short v1:8; unsigned short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFu8i_BFs8i { signed short v1:8; unsigned short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFu8i_BFs8ll { signed short v1:8; unsigned short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFu8i_BFs8s { signed short v1:8; unsigned short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFu8i_BFu8c { signed short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFu8i_BFu8i { signed short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFu8i_BFu8ll { signed short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFu8i_BFu8s { signed short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFu8ll { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; };
struct BFs8s_BFu8s_BFu8ll_BFs8c { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFs8i { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFs8ll { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFs8s { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFu8c { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFu8i { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFu8ll { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFu8ll_BFu8s { signed short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8s_BFu8s_BFu8s { signed short v1:8; unsigned short v2:8; unsigned short v3:8; };
struct BFs8s_BFu8s_BFu8s_BFs8c { signed short v1:8; unsigned short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8s_BFu8s_BFu8s_BFs8i { signed short v1:8; unsigned short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8s_BFu8s_BFu8s_BFs8ll { signed short v1:8; unsigned short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8s_BFu8s_BFu8s_BFs8s { signed short v1:8; unsigned short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8s_BFu8s_BFu8s_BFu8c { signed short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8s_BFu8s_BFu8s_BFu8i { signed short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8s_BFu8s_BFu8s_BFu8ll { signed short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8s_BFu8s_BFu8s_BFu8s { signed short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs9i_BFs9i { signed int v1:9; signed int v2:9; };
struct BFs9i_BFs9i_BFs9i { signed int v1:9; signed int v2:9; signed int v3:9; };
struct BFs9i_BFs9i_BFs9i_BFs9i { signed int v1:9; signed int v2:9; signed int v3:9; signed int v4:9; };
struct BFs9i_BFs9i_BFs9i_BFs9ll { signed int v1:9; signed int v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9i_BFs9i_BFs9i_BFs9s { signed int v1:9; signed int v2:9; signed int v3:9; signed short v4:9; };
struct BFs9i_BFs9i_BFs9i_BFu9i { signed int v1:9; signed int v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9i_BFs9i_BFs9i_BFu9ll { signed int v1:9; signed int v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9i_BFs9i_BFu9s { signed int v1:9; signed int v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9i_BFs9i_BFs9ll { signed int v1:9; signed int v2:9; signed long long v3:9; };
struct BFs9i_BFs9i_BFs9ll_BFs9i { signed int v1:9; signed int v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9i_BFs9i_BFs9ll_BFs9ll { signed int v1:9; signed int v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9i_BFs9i_BFs9ll_BFs9s { signed int v1:9; signed int v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9i_BFs9i_BFs9ll_BFu9i { signed int v1:9; signed int v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9i_BFs9i_BFs9ll_BFu9ll { signed int v1:9; signed int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9i_BFs9ll_BFu9s { signed int v1:9; signed int v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9i_BFs9i_BFs9s { signed int v1:9; signed int v2:9; signed short v3:9; };
struct BFs9i_BFs9i_BFs9s_BFs9i { signed int v1:9; signed int v2:9; signed short v3:9; signed int v4:9; };
struct BFs9i_BFs9i_BFs9s_BFs9ll { signed int v1:9; signed int v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9i_BFs9i_BFs9s_BFs9s { signed int v1:9; signed int v2:9; signed short v3:9; signed short v4:9; };
struct BFs9i_BFs9i_BFs9s_BFu9i { signed int v1:9; signed int v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9i_BFs9i_BFs9s_BFu9ll { signed int v1:9; signed int v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9i_BFs9s_BFu9s { signed int v1:9; signed int v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9i_BFs9i_BFu9i { signed int v1:9; signed int v2:9; unsigned int v3:9; };
struct BFs9i_BFs9i_BFu9i_BFs9i { signed int v1:9; signed int v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9i_BFs9i_BFu9i_BFs9ll { signed int v1:9; signed int v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9i_BFs9i_BFu9i_BFs9s { signed int v1:9; signed int v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9i_BFs9i_BFu9i_BFu9i { signed int v1:9; signed int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9i_BFs9i_BFu9i_BFu9ll { signed int v1:9; signed int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9i_BFu9i_BFu9s { signed int v1:9; signed int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9i_BFs9i_BFu9ll { signed int v1:9; signed int v2:9; unsigned long long v3:9; };
struct BFs9i_BFs9i_BFu9ll_BFs9i { signed int v1:9; signed int v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9i_BFs9i_BFu9ll_BFs9ll { signed int v1:9; signed int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9i_BFs9i_BFu9ll_BFs9s { signed int v1:9; signed int v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9i_BFs9i_BFu9ll_BFu9i { signed int v1:9; signed int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9i_BFs9i_BFu9ll_BFu9ll { signed int v1:9; signed int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9i_BFu9ll_BFu9s { signed int v1:9; signed int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9i_BFs9i_BFu9s { signed int v1:9; signed int v2:9; unsigned short v3:9; };
struct BFs9i_BFs9i_BFu9s_BFs9i { signed int v1:9; signed int v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9i_BFs9i_BFu9s_BFs9ll { signed int v1:9; signed int v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9i_BFs9i_BFu9s_BFs9s { signed int v1:9; signed int v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9i_BFs9i_BFu9s_BFu9i { signed int v1:9; signed int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9i_BFs9i_BFu9s_BFu9ll { signed int v1:9; signed int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9i_BFu9s_BFu9s { signed int v1:9; signed int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9i_BFs9ll { signed int v1:9; signed long long v2:9; };
struct BFs9i_BFs9ll_BFs9i { signed int v1:9; signed long long v2:9; signed int v3:9; };
struct BFs9i_BFs9ll_BFs9i_BFs9i { signed int v1:9; signed long long v2:9; signed int v3:9; signed int v4:9; };
struct BFs9i_BFs9ll_BFs9i_BFs9ll { signed int v1:9; signed long long v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9i_BFs9ll_BFs9i_BFs9s { signed int v1:9; signed long long v2:9; signed int v3:9; signed short v4:9; };
struct BFs9i_BFs9ll_BFs9i_BFu9i { signed int v1:9; signed long long v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9i_BFs9ll_BFs9i_BFu9ll { signed int v1:9; signed long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9ll_BFs9i_BFu9s { signed int v1:9; signed long long v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9i_BFs9ll_BFs9ll { signed int v1:9; signed long long v2:9; signed long long v3:9; };
struct BFs9i_BFs9ll_BFs9ll_BFs9i { signed int v1:9; signed long long v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9i_BFs9ll_BFs9ll_BFs9ll { signed int v1:9; signed long long v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9i_BFs9ll_BFs9ll_BFs9s { signed int v1:9; signed long long v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9i_BFs9ll_BFs9ll_BFu9i { signed int v1:9; signed long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9i_BFs9ll_BFs9ll_BFu9ll { signed int v1:9; signed long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9ll_BFs9ll_BFu9s { signed int v1:9; signed long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9i_BFs9ll_BFs9s { signed int v1:9; signed long long v2:9; signed short v3:9; };
struct BFs9i_BFs9ll_BFs9s_BFs9i { signed int v1:9; signed long long v2:9; signed short v3:9; signed int v4:9; };
struct BFs9i_BFs9ll_BFs9s_BFs9ll { signed int v1:9; signed long long v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9i_BFs9ll_BFs9s_BFs9s { signed int v1:9; signed long long v2:9; signed short v3:9; signed short v4:9; };
struct BFs9i_BFs9ll_BFs9s_BFu9i { signed int v1:9; signed long long v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9i_BFs9ll_BFs9s_BFu9ll { signed int v1:9; signed long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9ll_BFs9s_BFu9s { signed int v1:9; signed long long v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9i_BFs9ll_BFu9i { signed int v1:9; signed long long v2:9; unsigned int v3:9; };
struct BFs9i_BFs9ll_BFu9i_BFs9i { signed int v1:9; signed long long v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9i_BFs9ll_BFu9i_BFs9ll { signed int v1:9; signed long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9i_BFs9ll_BFu9i_BFs9s { signed int v1:9; signed long long v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9i_BFs9ll_BFu9i_BFu9i { signed int v1:9; signed long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9i_BFs9ll_BFu9i_BFu9ll { signed int v1:9; signed long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9ll_BFu9i_BFu9s { signed int v1:9; signed long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9i_BFs9ll_BFu9ll { signed int v1:9; signed long long v2:9; unsigned long long v3:9; };
struct BFs9i_BFs9ll_BFu9ll_BFs9i { signed int v1:9; signed long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9i_BFs9ll_BFu9ll_BFs9ll { signed int v1:9; signed long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9i_BFs9ll_BFu9ll_BFs9s { signed int v1:9; signed long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9i_BFs9ll_BFu9ll_BFu9i { signed int v1:9; signed long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9i_BFs9ll_BFu9ll_BFu9ll { signed int v1:9; signed long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9ll_BFu9ll_BFu9s { signed int v1:9; signed long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9i_BFs9ll_BFu9s { signed int v1:9; signed long long v2:9; unsigned short v3:9; };
struct BFs9i_BFs9ll_BFu9s_BFs9i { signed int v1:9; signed long long v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9i_BFs9ll_BFu9s_BFs9ll { signed int v1:9; signed long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9i_BFs9ll_BFu9s_BFs9s { signed int v1:9; signed long long v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9i_BFs9ll_BFu9s_BFu9i { signed int v1:9; signed long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9i_BFs9ll_BFu9s_BFu9ll { signed int v1:9; signed long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9ll_BFu9s_BFu9s { signed int v1:9; signed long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9i_BFs9s { signed int v1:9; signed short v2:9; };
struct BFs9i_BFs9s_BFs9i { signed int v1:9; signed short v2:9; signed int v3:9; };
struct BFs9i_BFs9s_BFs9i_BFs9i { signed int v1:9; signed short v2:9; signed int v3:9; signed int v4:9; };
struct BFs9i_BFs9s_BFs9i_BFs9ll { signed int v1:9; signed short v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9i_BFs9s_BFs9i_BFs9s { signed int v1:9; signed short v2:9; signed int v3:9; signed short v4:9; };
struct BFs9i_BFs9s_BFs9i_BFu9i { signed int v1:9; signed short v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9i_BFs9s_BFs9i_BFu9ll { signed int v1:9; signed short v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9s_BFs9i_BFu9s { signed int v1:9; signed short v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9i_BFs9s_BFs9ll { signed int v1:9; signed short v2:9; signed long long v3:9; };
struct BFs9i_BFs9s_BFs9ll_BFs9i { signed int v1:9; signed short v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9i_BFs9s_BFs9ll_BFs9ll { signed int v1:9; signed short v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9i_BFs9s_BFs9ll_BFs9s { signed int v1:9; signed short v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9i_BFs9s_BFs9ll_BFu9i { signed int v1:9; signed short v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9i_BFs9s_BFs9ll_BFu9ll { signed int v1:9; signed short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9s_BFs9ll_BFu9s { signed int v1:9; signed short v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9i_BFs9s_BFs9s { signed int v1:9; signed short v2:9; signed short v3:9; };
struct BFs9i_BFs9s_BFs9s_BFs9i { signed int v1:9; signed short v2:9; signed short v3:9; signed int v4:9; };
struct BFs9i_BFs9s_BFs9s_BFs9ll { signed int v1:9; signed short v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9i_BFs9s_BFs9s_BFs9s { signed int v1:9; signed short v2:9; signed short v3:9; signed short v4:9; };
struct BFs9i_BFs9s_BFs9s_BFu9i { signed int v1:9; signed short v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9i_BFs9s_BFs9s_BFu9ll { signed int v1:9; signed short v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9s_BFs9s_BFu9s { signed int v1:9; signed short v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9i_BFs9s_BFu9i { signed int v1:9; signed short v2:9; unsigned int v3:9; };
struct BFs9i_BFs9s_BFu9i_BFs9i { signed int v1:9; signed short v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9i_BFs9s_BFu9i_BFs9ll { signed int v1:9; signed short v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9i_BFs9s_BFu9i_BFs9s { signed int v1:9; signed short v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9i_BFs9s_BFu9i_BFu9i { signed int v1:9; signed short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9i_BFs9s_BFu9i_BFu9ll { signed int v1:9; signed short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9s_BFu9i_BFu9s { signed int v1:9; signed short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9i_BFs9s_BFu9ll { signed int v1:9; signed short v2:9; unsigned long long v3:9; };
struct BFs9i_BFs9s_BFu9ll_BFs9i { signed int v1:9; signed short v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9i_BFs9s_BFu9ll_BFs9ll { signed int v1:9; signed short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9i_BFs9s_BFu9ll_BFs9s { signed int v1:9; signed short v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9i_BFs9s_BFu9ll_BFu9i { signed int v1:9; signed short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9i_BFs9s_BFu9ll_BFu9ll { signed int v1:9; signed short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9s_BFu9ll_BFu9s { signed int v1:9; signed short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9i_BFs9s_BFu9s { signed int v1:9; signed short v2:9; unsigned short v3:9; };
struct BFs9i_BFs9s_BFu9s_BFs9i { signed int v1:9; signed short v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9i_BFs9s_BFu9s_BFs9ll { signed int v1:9; signed short v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9i_BFs9s_BFu9s_BFs9s { signed int v1:9; signed short v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9i_BFs9s_BFu9s_BFu9i { signed int v1:9; signed short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9i_BFs9s_BFu9s_BFu9ll { signed int v1:9; signed short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9i_BFs9s_BFu9s_BFu9s { signed int v1:9; signed short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9i_BFu9i { signed int v1:9; unsigned int v2:9; };
struct BFs9i_BFu9i_BFs9i { signed int v1:9; unsigned int v2:9; signed int v3:9; };
struct BFs9i_BFu9i_BFs9i_BFs9i { signed int v1:9; unsigned int v2:9; signed int v3:9; signed int v4:9; };
struct BFs9i_BFu9i_BFs9i_BFs9ll { signed int v1:9; unsigned int v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9i_BFu9i_BFs9i_BFs9s { signed int v1:9; unsigned int v2:9; signed int v3:9; signed short v4:9; };
struct BFs9i_BFu9i_BFs9i_BFu9i { signed int v1:9; unsigned int v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9i_BFu9i_BFs9i_BFu9ll { signed int v1:9; unsigned int v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9i_BFs9i_BFu9s { signed int v1:9; unsigned int v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9i_BFu9i_BFs9ll { signed int v1:9; unsigned int v2:9; signed long long v3:9; };
struct BFs9i_BFu9i_BFs9ll_BFs9i { signed int v1:9; unsigned int v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9i_BFu9i_BFs9ll_BFs9ll { signed int v1:9; unsigned int v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9i_BFu9i_BFs9ll_BFs9s { signed int v1:9; unsigned int v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9i_BFu9i_BFs9ll_BFu9i { signed int v1:9; unsigned int v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9i_BFu9i_BFs9ll_BFu9ll { signed int v1:9; unsigned int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9i_BFs9ll_BFu9s { signed int v1:9; unsigned int v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9i_BFu9i_BFs9s { signed int v1:9; unsigned int v2:9; signed short v3:9; };
struct BFs9i_BFu9i_BFs9s_BFs9i { signed int v1:9; unsigned int v2:9; signed short v3:9; signed int v4:9; };
struct BFs9i_BFu9i_BFs9s_BFs9ll { signed int v1:9; unsigned int v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9i_BFu9i_BFs9s_BFs9s { signed int v1:9; unsigned int v2:9; signed short v3:9; signed short v4:9; };
struct BFs9i_BFu9i_BFs9s_BFu9i { signed int v1:9; unsigned int v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9i_BFu9i_BFs9s_BFu9ll { signed int v1:9; unsigned int v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9i_BFs9s_BFu9s { signed int v1:9; unsigned int v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9i_BFu9i_BFu9i { signed int v1:9; unsigned int v2:9; unsigned int v3:9; };
struct BFs9i_BFu9i_BFu9i_BFs9i { signed int v1:9; unsigned int v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9i_BFu9i_BFu9i_BFs9ll { signed int v1:9; unsigned int v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9i_BFu9i_BFu9i_BFs9s { signed int v1:9; unsigned int v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9i_BFu9i_BFu9i_BFu9i { signed int v1:9; unsigned int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9i_BFu9i_BFu9i_BFu9ll { signed int v1:9; unsigned int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9i_BFu9i_BFu9s { signed int v1:9; unsigned int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9i_BFu9i_BFu9ll { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; };
struct BFs9i_BFu9i_BFu9ll_BFs9i { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9i_BFu9i_BFu9ll_BFs9ll { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9i_BFu9i_BFu9ll_BFs9s { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9i_BFu9i_BFu9ll_BFu9i { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9i_BFu9i_BFu9ll_BFu9ll { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9i_BFu9ll_BFu9s { signed int v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9i_BFu9i_BFu9s { signed int v1:9; unsigned int v2:9; unsigned short v3:9; };
struct BFs9i_BFu9i_BFu9s_BFs9i { signed int v1:9; unsigned int v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9i_BFu9i_BFu9s_BFs9ll { signed int v1:9; unsigned int v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9i_BFu9i_BFu9s_BFs9s { signed int v1:9; unsigned int v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9i_BFu9i_BFu9s_BFu9i { signed int v1:9; unsigned int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9i_BFu9i_BFu9s_BFu9ll { signed int v1:9; unsigned int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9i_BFu9s_BFu9s { signed int v1:9; unsigned int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9i_BFu9ll { signed int v1:9; unsigned long long v2:9; };
struct BFs9i_BFu9ll_BFs9i { signed int v1:9; unsigned long long v2:9; signed int v3:9; };
struct BFs9i_BFu9ll_BFs9i_BFs9i { signed int v1:9; unsigned long long v2:9; signed int v3:9; signed int v4:9; };
struct BFs9i_BFu9ll_BFs9i_BFs9ll { signed int v1:9; unsigned long long v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9i_BFu9ll_BFs9i_BFs9s { signed int v1:9; unsigned long long v2:9; signed int v3:9; signed short v4:9; };
struct BFs9i_BFu9ll_BFs9i_BFu9i { signed int v1:9; unsigned long long v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9i_BFu9ll_BFs9i_BFu9ll { signed int v1:9; unsigned long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9ll_BFs9i_BFu9s { signed int v1:9; unsigned long long v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9i_BFu9ll_BFs9ll { signed int v1:9; unsigned long long v2:9; signed long long v3:9; };
struct BFs9i_BFu9ll_BFs9ll_BFs9i { signed int v1:9; unsigned long long v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9i_BFu9ll_BFs9ll_BFs9ll { signed int v1:9; unsigned long long v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9i_BFu9ll_BFs9ll_BFs9s { signed int v1:9; unsigned long long v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9i_BFu9ll_BFs9ll_BFu9i { signed int v1:9; unsigned long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9i_BFu9ll_BFs9ll_BFu9ll { signed int v1:9; unsigned long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9ll_BFs9ll_BFu9s { signed int v1:9; unsigned long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9i_BFu9ll_BFs9s { signed int v1:9; unsigned long long v2:9; signed short v3:9; };
struct BFs9i_BFu9ll_BFs9s_BFs9i { signed int v1:9; unsigned long long v2:9; signed short v3:9; signed int v4:9; };
struct BFs9i_BFu9ll_BFs9s_BFs9ll { signed int v1:9; unsigned long long v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9i_BFu9ll_BFs9s_BFs9s { signed int v1:9; unsigned long long v2:9; signed short v3:9; signed short v4:9; };
struct BFs9i_BFu9ll_BFs9s_BFu9i { signed int v1:9; unsigned long long v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9i_BFu9ll_BFs9s_BFu9ll { signed int v1:9; unsigned long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9ll_BFs9s_BFu9s { signed int v1:9; unsigned long long v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9i_BFu9ll_BFu9i { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; };
struct BFs9i_BFu9ll_BFu9i_BFs9i { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9i_BFu9ll_BFu9i_BFs9ll { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9i_BFu9ll_BFu9i_BFs9s { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9i_BFu9ll_BFu9i_BFu9i { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9i_BFu9ll_BFu9i_BFu9ll { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9ll_BFu9i_BFu9s { signed int v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9i_BFu9ll_BFu9ll { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; };
struct BFs9i_BFu9ll_BFu9ll_BFs9i { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9i_BFu9ll_BFu9ll_BFs9ll { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9i_BFu9ll_BFu9ll_BFs9s { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9i_BFu9ll_BFu9ll_BFu9i { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9i_BFu9ll_BFu9ll_BFu9ll { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9ll_BFu9ll_BFu9s { signed int v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9i_BFu9ll_BFu9s { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; };
struct BFs9i_BFu9ll_BFu9s_BFs9i { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9i_BFu9ll_BFu9s_BFs9ll { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9i_BFu9ll_BFu9s_BFs9s { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9i_BFu9ll_BFu9s_BFu9i { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9i_BFu9ll_BFu9s_BFu9ll { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9ll_BFu9s_BFu9s { signed int v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9i_BFu9s { signed int v1:9; unsigned short v2:9; };
struct BFs9i_BFu9s_BFs9i { signed int v1:9; unsigned short v2:9; signed int v3:9; };
struct BFs9i_BFu9s_BFs9i_BFs9i { signed int v1:9; unsigned short v2:9; signed int v3:9; signed int v4:9; };
struct BFs9i_BFu9s_BFs9i_BFs9ll { signed int v1:9; unsigned short v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9i_BFu9s_BFs9i_BFs9s { signed int v1:9; unsigned short v2:9; signed int v3:9; signed short v4:9; };
struct BFs9i_BFu9s_BFs9i_BFu9i { signed int v1:9; unsigned short v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9i_BFu9s_BFs9i_BFu9ll { signed int v1:9; unsigned short v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9s_BFs9i_BFu9s { signed int v1:9; unsigned short v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9i_BFu9s_BFs9ll { signed int v1:9; unsigned short v2:9; signed long long v3:9; };
struct BFs9i_BFu9s_BFs9ll_BFs9i { signed int v1:9; unsigned short v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9i_BFu9s_BFs9ll_BFs9ll { signed int v1:9; unsigned short v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9i_BFu9s_BFs9ll_BFs9s { signed int v1:9; unsigned short v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9i_BFu9s_BFs9ll_BFu9i { signed int v1:9; unsigned short v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9i_BFu9s_BFs9ll_BFu9ll { signed int v1:9; unsigned short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9s_BFs9ll_BFu9s { signed int v1:9; unsigned short v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9i_BFu9s_BFs9s { signed int v1:9; unsigned short v2:9; signed short v3:9; };
struct BFs9i_BFu9s_BFs9s_BFs9i { signed int v1:9; unsigned short v2:9; signed short v3:9; signed int v4:9; };
struct BFs9i_BFu9s_BFs9s_BFs9ll { signed int v1:9; unsigned short v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9i_BFu9s_BFs9s_BFs9s { signed int v1:9; unsigned short v2:9; signed short v3:9; signed short v4:9; };
struct BFs9i_BFu9s_BFs9s_BFu9i { signed int v1:9; unsigned short v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9i_BFu9s_BFs9s_BFu9ll { signed int v1:9; unsigned short v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9s_BFs9s_BFu9s { signed int v1:9; unsigned short v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9i_BFu9s_BFu9i { signed int v1:9; unsigned short v2:9; unsigned int v3:9; };
struct BFs9i_BFu9s_BFu9i_BFs9i { signed int v1:9; unsigned short v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9i_BFu9s_BFu9i_BFs9ll { signed int v1:9; unsigned short v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9i_BFu9s_BFu9i_BFs9s { signed int v1:9; unsigned short v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9i_BFu9s_BFu9i_BFu9i { signed int v1:9; unsigned short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9i_BFu9s_BFu9i_BFu9ll { signed int v1:9; unsigned short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9s_BFu9i_BFu9s { signed int v1:9; unsigned short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9i_BFu9s_BFu9ll { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; };
struct BFs9i_BFu9s_BFu9ll_BFs9i { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9i_BFu9s_BFu9ll_BFs9ll { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9i_BFu9s_BFu9ll_BFs9s { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9i_BFu9s_BFu9ll_BFu9i { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9i_BFu9s_BFu9ll_BFu9ll { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9s_BFu9ll_BFu9s { signed int v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9i_BFu9s_BFu9s { signed int v1:9; unsigned short v2:9; unsigned short v3:9; };
struct BFs9i_BFu9s_BFu9s_BFs9i { signed int v1:9; unsigned short v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9i_BFu9s_BFu9s_BFs9ll { signed int v1:9; unsigned short v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9i_BFu9s_BFu9s_BFs9s { signed int v1:9; unsigned short v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9i_BFu9s_BFu9s_BFu9i { signed int v1:9; unsigned short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9i_BFu9s_BFu9s_BFu9ll { signed int v1:9; unsigned short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9i_BFu9s_BFu9s_BFu9s { signed int v1:9; unsigned short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9i { signed long long v1:9; signed int v2:9; };
struct BFs9ll_BFs9i_BFs9i { signed long long v1:9; signed int v2:9; signed int v3:9; };
struct BFs9ll_BFs9i_BFs9i_BFs9i { signed long long v1:9; signed int v2:9; signed int v3:9; signed int v4:9; };
struct BFs9ll_BFs9i_BFs9i_BFs9ll { signed long long v1:9; signed int v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9ll_BFs9i_BFs9i_BFs9s { signed long long v1:9; signed int v2:9; signed int v3:9; signed short v4:9; };
struct BFs9ll_BFs9i_BFs9i_BFu9i { signed long long v1:9; signed int v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9i_BFs9i_BFu9ll { signed long long v1:9; signed int v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9i_BFs9i_BFu9s { signed long long v1:9; signed int v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9i_BFs9ll { signed long long v1:9; signed int v2:9; signed long long v3:9; };
struct BFs9ll_BFs9i_BFs9ll_BFs9i { signed long long v1:9; signed int v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9ll_BFs9i_BFs9ll_BFs9ll { signed long long v1:9; signed int v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9ll_BFs9i_BFs9ll_BFs9s { signed long long v1:9; signed int v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9ll_BFs9i_BFs9ll_BFu9i { signed long long v1:9; signed int v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9i_BFs9ll_BFu9ll { signed long long v1:9; signed int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9i_BFs9ll_BFu9s { signed long long v1:9; signed int v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9i_BFs9s { signed long long v1:9; signed int v2:9; signed short v3:9; };
struct BFs9ll_BFs9i_BFs9s_BFs9i { signed long long v1:9; signed int v2:9; signed short v3:9; signed int v4:9; };
struct BFs9ll_BFs9i_BFs9s_BFs9ll { signed long long v1:9; signed int v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9ll_BFs9i_BFs9s_BFs9s { signed long long v1:9; signed int v2:9; signed short v3:9; signed short v4:9; };
struct BFs9ll_BFs9i_BFs9s_BFu9i { signed long long v1:9; signed int v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9i_BFs9s_BFu9ll { signed long long v1:9; signed int v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9i_BFs9s_BFu9s { signed long long v1:9; signed int v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9i_BFu9i { signed long long v1:9; signed int v2:9; unsigned int v3:9; };
struct BFs9ll_BFs9i_BFu9i_BFs9i { signed long long v1:9; signed int v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9ll_BFs9i_BFu9i_BFs9ll { signed long long v1:9; signed int v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9ll_BFs9i_BFu9i_BFs9s { signed long long v1:9; signed int v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9ll_BFs9i_BFu9i_BFu9i { signed long long v1:9; signed int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9i_BFu9i_BFu9ll { signed long long v1:9; signed int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9i_BFu9i_BFu9s { signed long long v1:9; signed int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9i_BFu9ll { signed long long v1:9; signed int v2:9; unsigned long long v3:9; };
struct BFs9ll_BFs9i_BFu9ll_BFs9i { signed long long v1:9; signed int v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9ll_BFs9i_BFu9ll_BFs9ll { signed long long v1:9; signed int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9ll_BFs9i_BFu9ll_BFs9s { signed long long v1:9; signed int v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9ll_BFs9i_BFu9ll_BFu9i { signed long long v1:9; signed int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9i_BFu9ll_BFu9ll { signed long long v1:9; signed int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9i_BFu9ll_BFu9s { signed long long v1:9; signed int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9i_BFu9s { signed long long v1:9; signed int v2:9; unsigned short v3:9; };
struct BFs9ll_BFs9i_BFu9s_BFs9i { signed long long v1:9; signed int v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9ll_BFs9i_BFu9s_BFs9ll { signed long long v1:9; signed int v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9ll_BFs9i_BFu9s_BFs9s { signed long long v1:9; signed int v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9ll_BFs9i_BFu9s_BFu9i { signed long long v1:9; signed int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9i_BFu9s_BFu9ll { signed long long v1:9; signed int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9i_BFu9s_BFu9s { signed long long v1:9; signed int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9ll { signed long long v1:9; signed long long v2:9; };
struct BFs9ll_BFs9ll_BFs9i { signed long long v1:9; signed long long v2:9; signed int v3:9; };
struct BFs9ll_BFs9ll_BFs9i_BFs9i { signed long long v1:9; signed long long v2:9; signed int v3:9; signed int v4:9; };
struct BFs9ll_BFs9ll_BFs9i_BFs9ll { signed long long v1:9; signed long long v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9ll_BFs9ll_BFs9i_BFs9s { signed long long v1:9; signed long long v2:9; signed int v3:9; signed short v4:9; };
struct BFs9ll_BFs9ll_BFs9i_BFu9i { signed long long v1:9; signed long long v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9ll_BFs9i_BFu9ll { signed long long v1:9; signed long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9ll_BFs9i_BFu9s { signed long long v1:9; signed long long v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9ll_BFs9ll { signed long long v1:9; signed long long v2:9; signed long long v3:9; };
struct BFs9ll_BFs9ll_BFs9ll_BFs9i { signed long long v1:9; signed long long v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9ll_BFs9ll_BFs9ll_BFs9ll { signed long long v1:9; signed long long v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9ll_BFs9ll_BFs9ll_BFs9s { signed long long v1:9; signed long long v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9ll_BFs9ll_BFs9ll_BFu9i { signed long long v1:9; signed long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9ll_BFs9ll_BFu9ll { signed long long v1:9; signed long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9ll_BFs9ll_BFu9s { signed long long v1:9; signed long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9ll_BFs9s { signed long long v1:9; signed long long v2:9; signed short v3:9; };
struct BFs9ll_BFs9ll_BFs9s_BFs9i { signed long long v1:9; signed long long v2:9; signed short v3:9; signed int v4:9; };
struct BFs9ll_BFs9ll_BFs9s_BFs9ll { signed long long v1:9; signed long long v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9ll_BFs9ll_BFs9s_BFs9s { signed long long v1:9; signed long long v2:9; signed short v3:9; signed short v4:9; };
struct BFs9ll_BFs9ll_BFs9s_BFu9i { signed long long v1:9; signed long long v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9ll_BFs9s_BFu9ll { signed long long v1:9; signed long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9ll_BFs9s_BFu9s { signed long long v1:9; signed long long v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9ll_BFu9i { signed long long v1:9; signed long long v2:9; unsigned int v3:9; };
struct BFs9ll_BFs9ll_BFu9i_BFs9i { signed long long v1:9; signed long long v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9ll_BFs9ll_BFu9i_BFs9ll { signed long long v1:9; signed long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9ll_BFs9ll_BFu9i_BFs9s { signed long long v1:9; signed long long v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9ll_BFs9ll_BFu9i_BFu9i { signed long long v1:9; signed long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9ll_BFu9i_BFu9ll { signed long long v1:9; signed long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9ll_BFu9i_BFu9s { signed long long v1:9; signed long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9ll_BFu9ll { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; };
struct BFs9ll_BFs9ll_BFu9ll_BFs9i { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9ll_BFs9ll_BFu9ll_BFs9ll { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9ll_BFs9ll_BFu9ll_BFs9s { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9ll_BFs9ll_BFu9ll_BFu9i { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9ll_BFu9ll_BFu9ll { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9ll_BFu9ll_BFu9s { signed long long v1:9; signed long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9ll_BFu9s { signed long long v1:9; signed long long v2:9; unsigned short v3:9; };
struct BFs9ll_BFs9ll_BFu9s_BFs9i { signed long long v1:9; signed long long v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9ll_BFs9ll_BFu9s_BFs9ll { signed long long v1:9; signed long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9ll_BFs9ll_BFu9s_BFs9s { signed long long v1:9; signed long long v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9ll_BFs9ll_BFu9s_BFu9i { signed long long v1:9; signed long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9ll_BFu9s_BFu9ll { signed long long v1:9; signed long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9ll_BFu9s_BFu9s { signed long long v1:9; signed long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9s { signed long long v1:9; signed short v2:9; };
struct BFs9ll_BFs9s_BFs9i { signed long long v1:9; signed short v2:9; signed int v3:9; };
struct BFs9ll_BFs9s_BFs9i_BFs9i { signed long long v1:9; signed short v2:9; signed int v3:9; signed int v4:9; };
struct BFs9ll_BFs9s_BFs9i_BFs9ll { signed long long v1:9; signed short v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9ll_BFs9s_BFs9i_BFs9s { signed long long v1:9; signed short v2:9; signed int v3:9; signed short v4:9; };
struct BFs9ll_BFs9s_BFs9i_BFu9i { signed long long v1:9; signed short v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9s_BFs9i_BFu9ll { signed long long v1:9; signed short v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9s_BFs9i_BFu9s { signed long long v1:9; signed short v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9s_BFs9ll { signed long long v1:9; signed short v2:9; signed long long v3:9; };
struct BFs9ll_BFs9s_BFs9ll_BFs9i { signed long long v1:9; signed short v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9ll_BFs9s_BFs9ll_BFs9ll { signed long long v1:9; signed short v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9ll_BFs9s_BFs9ll_BFs9s { signed long long v1:9; signed short v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9ll_BFs9s_BFs9ll_BFu9i { signed long long v1:9; signed short v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9s_BFs9ll_BFu9ll { signed long long v1:9; signed short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9s_BFs9ll_BFu9s { signed long long v1:9; signed short v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9s_BFs9s { signed long long v1:9; signed short v2:9; signed short v3:9; };
struct BFs9ll_BFs9s_BFs9s_BFs9i { signed long long v1:9; signed short v2:9; signed short v3:9; signed int v4:9; };
struct BFs9ll_BFs9s_BFs9s_BFs9ll { signed long long v1:9; signed short v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9ll_BFs9s_BFs9s_BFs9s { signed long long v1:9; signed short v2:9; signed short v3:9; signed short v4:9; };
struct BFs9ll_BFs9s_BFs9s_BFu9i { signed long long v1:9; signed short v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9s_BFs9s_BFu9ll { signed long long v1:9; signed short v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9s_BFs9s_BFu9s { signed long long v1:9; signed short v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9s_BFu9i { signed long long v1:9; signed short v2:9; unsigned int v3:9; };
struct BFs9ll_BFs9s_BFu9i_BFs9i { signed long long v1:9; signed short v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9ll_BFs9s_BFu9i_BFs9ll { signed long long v1:9; signed short v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9ll_BFs9s_BFu9i_BFs9s { signed long long v1:9; signed short v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9ll_BFs9s_BFu9i_BFu9i { signed long long v1:9; signed short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9s_BFu9i_BFu9ll { signed long long v1:9; signed short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9s_BFu9i_BFu9s { signed long long v1:9; signed short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9s_BFu9ll { signed long long v1:9; signed short v2:9; unsigned long long v3:9; };
struct BFs9ll_BFs9s_BFu9ll_BFs9i { signed long long v1:9; signed short v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9ll_BFs9s_BFu9ll_BFs9ll { signed long long v1:9; signed short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9ll_BFs9s_BFu9ll_BFs9s { signed long long v1:9; signed short v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9ll_BFs9s_BFu9ll_BFu9i { signed long long v1:9; signed short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9s_BFu9ll_BFu9ll { signed long long v1:9; signed short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9s_BFu9ll_BFu9s { signed long long v1:9; signed short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFs9s_BFu9s { signed long long v1:9; signed short v2:9; unsigned short v3:9; };
struct BFs9ll_BFs9s_BFu9s_BFs9i { signed long long v1:9; signed short v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9ll_BFs9s_BFu9s_BFs9ll { signed long long v1:9; signed short v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9ll_BFs9s_BFu9s_BFs9s { signed long long v1:9; signed short v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9ll_BFs9s_BFu9s_BFu9i { signed long long v1:9; signed short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9ll_BFs9s_BFu9s_BFu9ll { signed long long v1:9; signed short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFs9s_BFu9s_BFu9s { signed long long v1:9; signed short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9i { signed long long v1:9; unsigned int v2:9; };
struct BFs9ll_BFu9i_BFs9i { signed long long v1:9; unsigned int v2:9; signed int v3:9; };
struct BFs9ll_BFu9i_BFs9i_BFs9i { signed long long v1:9; unsigned int v2:9; signed int v3:9; signed int v4:9; };
struct BFs9ll_BFu9i_BFs9i_BFs9ll { signed long long v1:9; unsigned int v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9ll_BFu9i_BFs9i_BFs9s { signed long long v1:9; unsigned int v2:9; signed int v3:9; signed short v4:9; };
struct BFs9ll_BFu9i_BFs9i_BFu9i { signed long long v1:9; unsigned int v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9i_BFs9i_BFu9ll { signed long long v1:9; unsigned int v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9i_BFs9i_BFu9s { signed long long v1:9; unsigned int v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9i_BFs9ll { signed long long v1:9; unsigned int v2:9; signed long long v3:9; };
struct BFs9ll_BFu9i_BFs9ll_BFs9i { signed long long v1:9; unsigned int v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9ll_BFu9i_BFs9ll_BFs9ll { signed long long v1:9; unsigned int v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9ll_BFu9i_BFs9ll_BFs9s { signed long long v1:9; unsigned int v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9ll_BFu9i_BFs9ll_BFu9i { signed long long v1:9; unsigned int v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9i_BFs9ll_BFu9ll { signed long long v1:9; unsigned int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9i_BFs9ll_BFu9s { signed long long v1:9; unsigned int v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9i_BFs9s { signed long long v1:9; unsigned int v2:9; signed short v3:9; };
struct BFs9ll_BFu9i_BFs9s_BFs9i { signed long long v1:9; unsigned int v2:9; signed short v3:9; signed int v4:9; };
struct BFs9ll_BFu9i_BFs9s_BFs9ll { signed long long v1:9; unsigned int v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9ll_BFu9i_BFs9s_BFs9s { signed long long v1:9; unsigned int v2:9; signed short v3:9; signed short v4:9; };
struct BFs9ll_BFu9i_BFs9s_BFu9i { signed long long v1:9; unsigned int v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9i_BFs9s_BFu9ll { signed long long v1:9; unsigned int v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9i_BFs9s_BFu9s { signed long long v1:9; unsigned int v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9i_BFu9i { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; };
struct BFs9ll_BFu9i_BFu9i_BFs9i { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9ll_BFu9i_BFu9i_BFs9ll { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9ll_BFu9i_BFu9i_BFs9s { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9ll_BFu9i_BFu9i_BFu9i { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9i_BFu9i_BFu9ll { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9i_BFu9i_BFu9s { signed long long v1:9; unsigned int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9i_BFu9ll { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; };
struct BFs9ll_BFu9i_BFu9ll_BFs9i { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9ll_BFu9i_BFu9ll_BFs9ll { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9ll_BFu9i_BFu9ll_BFs9s { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9ll_BFu9i_BFu9ll_BFu9i { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9i_BFu9ll_BFu9ll { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9i_BFu9ll_BFu9s { signed long long v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9i_BFu9s { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; };
struct BFs9ll_BFu9i_BFu9s_BFs9i { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9ll_BFu9i_BFu9s_BFs9ll { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9ll_BFu9i_BFu9s_BFs9s { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9ll_BFu9i_BFu9s_BFu9i { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9i_BFu9s_BFu9ll { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9i_BFu9s_BFu9s { signed long long v1:9; unsigned int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9ll { signed long long v1:9; unsigned long long v2:9; };
struct BFs9ll_BFu9ll_BFs9i { signed long long v1:9; unsigned long long v2:9; signed int v3:9; };
struct BFs9ll_BFu9ll_BFs9i_BFs9i { signed long long v1:9; unsigned long long v2:9; signed int v3:9; signed int v4:9; };
struct BFs9ll_BFu9ll_BFs9i_BFs9ll { signed long long v1:9; unsigned long long v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9ll_BFu9ll_BFs9i_BFs9s { signed long long v1:9; unsigned long long v2:9; signed int v3:9; signed short v4:9; };
struct BFs9ll_BFu9ll_BFs9i_BFu9i { signed long long v1:9; unsigned long long v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9ll_BFs9i_BFu9ll { signed long long v1:9; unsigned long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9ll_BFs9i_BFu9s { signed long long v1:9; unsigned long long v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9ll_BFs9ll { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; };
struct BFs9ll_BFu9ll_BFs9ll_BFs9i { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9ll_BFu9ll_BFs9ll_BFs9ll { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9ll_BFu9ll_BFs9ll_BFs9s { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9ll_BFu9ll_BFs9ll_BFu9i { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9ll_BFs9ll_BFu9ll { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9ll_BFs9ll_BFu9s { signed long long v1:9; unsigned long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9ll_BFs9s { signed long long v1:9; unsigned long long v2:9; signed short v3:9; };
struct BFs9ll_BFu9ll_BFs9s_BFs9i { signed long long v1:9; unsigned long long v2:9; signed short v3:9; signed int v4:9; };
struct BFs9ll_BFu9ll_BFs9s_BFs9ll { signed long long v1:9; unsigned long long v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9ll_BFu9ll_BFs9s_BFs9s { signed long long v1:9; unsigned long long v2:9; signed short v3:9; signed short v4:9; };
struct BFs9ll_BFu9ll_BFs9s_BFu9i { signed long long v1:9; unsigned long long v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9ll_BFs9s_BFu9ll { signed long long v1:9; unsigned long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9ll_BFs9s_BFu9s { signed long long v1:9; unsigned long long v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9ll_BFu9i { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; };
struct BFs9ll_BFu9ll_BFu9i_BFs9i { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9ll_BFu9ll_BFu9i_BFs9ll { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9ll_BFu9ll_BFu9i_BFs9s { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9ll_BFu9ll_BFu9i_BFu9i { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9ll_BFu9i_BFu9ll { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9ll_BFu9i_BFu9s { signed long long v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9ll_BFu9ll { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; };
struct BFs9ll_BFu9ll_BFu9ll_BFs9i { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9ll_BFu9ll_BFu9ll_BFs9ll { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9ll_BFu9ll_BFu9ll_BFs9s { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9ll_BFu9ll_BFu9ll_BFu9i { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9ll_BFu9ll_BFu9ll { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9ll_BFu9ll_BFu9s { signed long long v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9ll_BFu9s { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; };
struct BFs9ll_BFu9ll_BFu9s_BFs9i { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9ll_BFu9ll_BFu9s_BFs9ll { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9ll_BFu9ll_BFu9s_BFs9s { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9ll_BFu9ll_BFu9s_BFu9i { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9ll_BFu9s_BFu9ll { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9ll_BFu9s_BFu9s { signed long long v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9s { signed long long v1:9; unsigned short v2:9; };
struct BFs9ll_BFu9s_BFs9i { signed long long v1:9; unsigned short v2:9; signed int v3:9; };
struct BFs9ll_BFu9s_BFs9i_BFs9i { signed long long v1:9; unsigned short v2:9; signed int v3:9; signed int v4:9; };
struct BFs9ll_BFu9s_BFs9i_BFs9ll { signed long long v1:9; unsigned short v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9ll_BFu9s_BFs9i_BFs9s { signed long long v1:9; unsigned short v2:9; signed int v3:9; signed short v4:9; };
struct BFs9ll_BFu9s_BFs9i_BFu9i { signed long long v1:9; unsigned short v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9s_BFs9i_BFu9ll { signed long long v1:9; unsigned short v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9s_BFs9i_BFu9s { signed long long v1:9; unsigned short v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9s_BFs9ll { signed long long v1:9; unsigned short v2:9; signed long long v3:9; };
struct BFs9ll_BFu9s_BFs9ll_BFs9i { signed long long v1:9; unsigned short v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9ll_BFu9s_BFs9ll_BFs9ll { signed long long v1:9; unsigned short v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9ll_BFu9s_BFs9ll_BFs9s { signed long long v1:9; unsigned short v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9ll_BFu9s_BFs9ll_BFu9i { signed long long v1:9; unsigned short v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9s_BFs9ll_BFu9ll { signed long long v1:9; unsigned short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9s_BFs9ll_BFu9s { signed long long v1:9; unsigned short v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9s_BFs9s { signed long long v1:9; unsigned short v2:9; signed short v3:9; };
struct BFs9ll_BFu9s_BFs9s_BFs9i { signed long long v1:9; unsigned short v2:9; signed short v3:9; signed int v4:9; };
struct BFs9ll_BFu9s_BFs9s_BFs9ll { signed long long v1:9; unsigned short v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9ll_BFu9s_BFs9s_BFs9s { signed long long v1:9; unsigned short v2:9; signed short v3:9; signed short v4:9; };
struct BFs9ll_BFu9s_BFs9s_BFu9i { signed long long v1:9; unsigned short v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9s_BFs9s_BFu9ll { signed long long v1:9; unsigned short v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9s_BFs9s_BFu9s { signed long long v1:9; unsigned short v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9s_BFu9i { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; };
struct BFs9ll_BFu9s_BFu9i_BFs9i { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9ll_BFu9s_BFu9i_BFs9ll { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9ll_BFu9s_BFu9i_BFs9s { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9ll_BFu9s_BFu9i_BFu9i { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9s_BFu9i_BFu9ll { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9s_BFu9i_BFu9s { signed long long v1:9; unsigned short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9s_BFu9ll { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; };
struct BFs9ll_BFu9s_BFu9ll_BFs9i { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9ll_BFu9s_BFu9ll_BFs9ll { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9ll_BFu9s_BFu9ll_BFs9s { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9ll_BFu9s_BFu9ll_BFu9i { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9s_BFu9ll_BFu9ll { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9s_BFu9ll_BFu9s { signed long long v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9ll_BFu9s_BFu9s { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; };
struct BFs9ll_BFu9s_BFu9s_BFs9i { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9ll_BFu9s_BFu9s_BFs9ll { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9ll_BFu9s_BFu9s_BFs9s { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9ll_BFu9s_BFu9s_BFu9i { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9ll_BFu9s_BFu9s_BFu9ll { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9ll_BFu9s_BFu9s_BFu9s { signed long long v1:9; unsigned short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9s_BFs9i { signed short v1:9; signed int v2:9; };
struct BFs9s_BFs9i_BFs9i { signed short v1:9; signed int v2:9; signed int v3:9; };
struct BFs9s_BFs9i_BFs9i_BFs9i { signed short v1:9; signed int v2:9; signed int v3:9; signed int v4:9; };
struct BFs9s_BFs9i_BFs9i_BFs9ll { signed short v1:9; signed int v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9s_BFs9i_BFs9i_BFs9s { signed short v1:9; signed int v2:9; signed int v3:9; signed short v4:9; };
struct BFs9s_BFs9i_BFs9i_BFu9i { signed short v1:9; signed int v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9s_BFs9i_BFs9i_BFu9ll { signed short v1:9; signed int v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9i_BFs9i_BFu9s { signed short v1:9; signed int v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9s_BFs9i_BFs9ll { signed short v1:9; signed int v2:9; signed long long v3:9; };
struct BFs9s_BFs9i_BFs9ll_BFs9i { signed short v1:9; signed int v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9s_BFs9i_BFs9ll_BFs9ll { signed short v1:9; signed int v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9s_BFs9i_BFs9ll_BFs9s { signed short v1:9; signed int v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9s_BFs9i_BFs9ll_BFu9i { signed short v1:9; signed int v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9s_BFs9i_BFs9ll_BFu9ll { signed short v1:9; signed int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9i_BFs9ll_BFu9s { signed short v1:9; signed int v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9s_BFs9i_BFs9s { signed short v1:9; signed int v2:9; signed short v3:9; };
struct BFs9s_BFs9i_BFs9s_BFs9i { signed short v1:9; signed int v2:9; signed short v3:9; signed int v4:9; };
struct BFs9s_BFs9i_BFs9s_BFs9ll { signed short v1:9; signed int v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9s_BFs9i_BFs9s_BFs9s { signed short v1:9; signed int v2:9; signed short v3:9; signed short v4:9; };
struct BFs9s_BFs9i_BFs9s_BFu9i { signed short v1:9; signed int v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9s_BFs9i_BFs9s_BFu9ll { signed short v1:9; signed int v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9i_BFs9s_BFu9s { signed short v1:9; signed int v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9s_BFs9i_BFu9i { signed short v1:9; signed int v2:9; unsigned int v3:9; };
struct BFs9s_BFs9i_BFu9i_BFs9i { signed short v1:9; signed int v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9s_BFs9i_BFu9i_BFs9ll { signed short v1:9; signed int v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9s_BFs9i_BFu9i_BFs9s { signed short v1:9; signed int v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9s_BFs9i_BFu9i_BFu9i { signed short v1:9; signed int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9s_BFs9i_BFu9i_BFu9ll { signed short v1:9; signed int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9i_BFu9i_BFu9s { signed short v1:9; signed int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9s_BFs9i_BFu9ll { signed short v1:9; signed int v2:9; unsigned long long v3:9; };
struct BFs9s_BFs9i_BFu9ll_BFs9i { signed short v1:9; signed int v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9s_BFs9i_BFu9ll_BFs9ll { signed short v1:9; signed int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9s_BFs9i_BFu9ll_BFs9s { signed short v1:9; signed int v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9s_BFs9i_BFu9ll_BFu9i { signed short v1:9; signed int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9s_BFs9i_BFu9ll_BFu9ll { signed short v1:9; signed int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9i_BFu9ll_BFu9s { signed short v1:9; signed int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9s_BFs9i_BFu9s { signed short v1:9; signed int v2:9; unsigned short v3:9; };
struct BFs9s_BFs9i_BFu9s_BFs9i { signed short v1:9; signed int v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9s_BFs9i_BFu9s_BFs9ll { signed short v1:9; signed int v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9s_BFs9i_BFu9s_BFs9s { signed short v1:9; signed int v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9s_BFs9i_BFu9s_BFu9i { signed short v1:9; signed int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9s_BFs9i_BFu9s_BFu9ll { signed short v1:9; signed int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9i_BFu9s_BFu9s { signed short v1:9; signed int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9s_BFs9ll { signed short v1:9; signed long long v2:9; };
struct BFs9s_BFs9ll_BFs9i { signed short v1:9; signed long long v2:9; signed int v3:9; };
struct BFs9s_BFs9ll_BFs9i_BFs9i { signed short v1:9; signed long long v2:9; signed int v3:9; signed int v4:9; };
struct BFs9s_BFs9ll_BFs9i_BFs9ll { signed short v1:9; signed long long v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9s_BFs9ll_BFs9i_BFs9s { signed short v1:9; signed long long v2:9; signed int v3:9; signed short v4:9; };
struct BFs9s_BFs9ll_BFs9i_BFu9i { signed short v1:9; signed long long v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9s_BFs9ll_BFs9i_BFu9ll { signed short v1:9; signed long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9ll_BFs9i_BFu9s { signed short v1:9; signed long long v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9s_BFs9ll_BFs9ll { signed short v1:9; signed long long v2:9; signed long long v3:9; };
struct BFs9s_BFs9ll_BFs9ll_BFs9i { signed short v1:9; signed long long v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9s_BFs9ll_BFs9ll_BFs9ll { signed short v1:9; signed long long v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9s_BFs9ll_BFs9ll_BFs9s { signed short v1:9; signed long long v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9s_BFs9ll_BFs9ll_BFu9i { signed short v1:9; signed long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9s_BFs9ll_BFs9ll_BFu9ll { signed short v1:9; signed long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9ll_BFs9ll_BFu9s { signed short v1:9; signed long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9s_BFs9ll_BFs9s { signed short v1:9; signed long long v2:9; signed short v3:9; };
struct BFs9s_BFs9ll_BFs9s_BFs9i { signed short v1:9; signed long long v2:9; signed short v3:9; signed int v4:9; };
struct BFs9s_BFs9ll_BFs9s_BFs9ll { signed short v1:9; signed long long v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9s_BFs9ll_BFs9s_BFs9s { signed short v1:9; signed long long v2:9; signed short v3:9; signed short v4:9; };
struct BFs9s_BFs9ll_BFs9s_BFu9i { signed short v1:9; signed long long v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9s_BFs9ll_BFs9s_BFu9ll { signed short v1:9; signed long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9ll_BFs9s_BFu9s { signed short v1:9; signed long long v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9s_BFs9ll_BFu9i { signed short v1:9; signed long long v2:9; unsigned int v3:9; };
struct BFs9s_BFs9ll_BFu9i_BFs9i { signed short v1:9; signed long long v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9s_BFs9ll_BFu9i_BFs9ll { signed short v1:9; signed long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9s_BFs9ll_BFu9i_BFs9s { signed short v1:9; signed long long v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9s_BFs9ll_BFu9i_BFu9i { signed short v1:9; signed long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9s_BFs9ll_BFu9i_BFu9ll { signed short v1:9; signed long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9ll_BFu9i_BFu9s { signed short v1:9; signed long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9s_BFs9ll_BFu9ll { signed short v1:9; signed long long v2:9; unsigned long long v3:9; };
struct BFs9s_BFs9ll_BFu9ll_BFs9i { signed short v1:9; signed long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9s_BFs9ll_BFu9ll_BFs9ll { signed short v1:9; signed long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9s_BFs9ll_BFu9ll_BFs9s { signed short v1:9; signed long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9s_BFs9ll_BFu9ll_BFu9i { signed short v1:9; signed long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9s_BFs9ll_BFu9ll_BFu9ll { signed short v1:9; signed long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9ll_BFu9ll_BFu9s { signed short v1:9; signed long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9s_BFs9ll_BFu9s { signed short v1:9; signed long long v2:9; unsigned short v3:9; };
struct BFs9s_BFs9ll_BFu9s_BFs9i { signed short v1:9; signed long long v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9s_BFs9ll_BFu9s_BFs9ll { signed short v1:9; signed long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9s_BFs9ll_BFu9s_BFs9s { signed short v1:9; signed long long v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9s_BFs9ll_BFu9s_BFu9i { signed short v1:9; signed long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9s_BFs9ll_BFu9s_BFu9ll { signed short v1:9; signed long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9ll_BFu9s_BFu9s { signed short v1:9; signed long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9s_BFs9s { signed short v1:9; signed short v2:9; };
struct BFs9s_BFs9s_BFs9i { signed short v1:9; signed short v2:9; signed int v3:9; };
struct BFs9s_BFs9s_BFs9i_BFs9i { signed short v1:9; signed short v2:9; signed int v3:9; signed int v4:9; };
struct BFs9s_BFs9s_BFs9i_BFs9ll { signed short v1:9; signed short v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9s_BFs9s_BFs9i_BFs9s { signed short v1:9; signed short v2:9; signed int v3:9; signed short v4:9; };
struct BFs9s_BFs9s_BFs9i_BFu9i { signed short v1:9; signed short v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9s_BFs9s_BFs9i_BFu9ll { signed short v1:9; signed short v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9s_BFs9i_BFu9s { signed short v1:9; signed short v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9s_BFs9s_BFs9ll { signed short v1:9; signed short v2:9; signed long long v3:9; };
struct BFs9s_BFs9s_BFs9ll_BFs9i { signed short v1:9; signed short v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9s_BFs9s_BFs9ll_BFs9ll { signed short v1:9; signed short v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9s_BFs9s_BFs9ll_BFs9s { signed short v1:9; signed short v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9s_BFs9s_BFs9ll_BFu9i { signed short v1:9; signed short v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9s_BFs9s_BFs9ll_BFu9ll { signed short v1:9; signed short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9s_BFs9ll_BFu9s { signed short v1:9; signed short v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9s_BFs9s_BFs9s { signed short v1:9; signed short v2:9; signed short v3:9; };
struct BFs9s_BFs9s_BFs9s_BFs9i { signed short v1:9; signed short v2:9; signed short v3:9; signed int v4:9; };
struct BFs9s_BFs9s_BFs9s_BFs9ll { signed short v1:9; signed short v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9s_BFs9s_BFs9s_BFs9s { signed short v1:9; signed short v2:9; signed short v3:9; signed short v4:9; };
struct BFs9s_BFs9s_BFs9s_BFu9i { signed short v1:9; signed short v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9s_BFs9s_BFs9s_BFu9ll { signed short v1:9; signed short v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9s_BFs9s_BFu9s { signed short v1:9; signed short v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9s_BFs9s_BFu9i { signed short v1:9; signed short v2:9; unsigned int v3:9; };
struct BFs9s_BFs9s_BFu9i_BFs9i { signed short v1:9; signed short v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9s_BFs9s_BFu9i_BFs9ll { signed short v1:9; signed short v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9s_BFs9s_BFu9i_BFs9s { signed short v1:9; signed short v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9s_BFs9s_BFu9i_BFu9i { signed short v1:9; signed short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9s_BFs9s_BFu9i_BFu9ll { signed short v1:9; signed short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9s_BFu9i_BFu9s { signed short v1:9; signed short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9s_BFs9s_BFu9ll { signed short v1:9; signed short v2:9; unsigned long long v3:9; };
struct BFs9s_BFs9s_BFu9ll_BFs9i { signed short v1:9; signed short v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9s_BFs9s_BFu9ll_BFs9ll { signed short v1:9; signed short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9s_BFs9s_BFu9ll_BFs9s { signed short v1:9; signed short v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9s_BFs9s_BFu9ll_BFu9i { signed short v1:9; signed short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9s_BFs9s_BFu9ll_BFu9ll { signed short v1:9; signed short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9s_BFu9ll_BFu9s { signed short v1:9; signed short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9s_BFs9s_BFu9s { signed short v1:9; signed short v2:9; unsigned short v3:9; };
struct BFs9s_BFs9s_BFu9s_BFs9i { signed short v1:9; signed short v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9s_BFs9s_BFu9s_BFs9ll { signed short v1:9; signed short v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9s_BFs9s_BFu9s_BFs9s { signed short v1:9; signed short v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9s_BFs9s_BFu9s_BFu9i { signed short v1:9; signed short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9s_BFs9s_BFu9s_BFu9ll { signed short v1:9; signed short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9s_BFs9s_BFu9s_BFu9s { signed short v1:9; signed short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9s_BFu9i { signed short v1:9; unsigned int v2:9; };
struct BFs9s_BFu9i_BFs9i { signed short v1:9; unsigned int v2:9; signed int v3:9; };
struct BFs9s_BFu9i_BFs9i_BFs9i { signed short v1:9; unsigned int v2:9; signed int v3:9; signed int v4:9; };
struct BFs9s_BFu9i_BFs9i_BFs9ll { signed short v1:9; unsigned int v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9s_BFu9i_BFs9i_BFs9s { signed short v1:9; unsigned int v2:9; signed int v3:9; signed short v4:9; };
struct BFs9s_BFu9i_BFs9i_BFu9i { signed short v1:9; unsigned int v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9s_BFu9i_BFs9i_BFu9ll { signed short v1:9; unsigned int v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9i_BFs9i_BFu9s { signed short v1:9; unsigned int v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9s_BFu9i_BFs9ll { signed short v1:9; unsigned int v2:9; signed long long v3:9; };
struct BFs9s_BFu9i_BFs9ll_BFs9i { signed short v1:9; unsigned int v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9s_BFu9i_BFs9ll_BFs9ll { signed short v1:9; unsigned int v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9s_BFu9i_BFs9ll_BFs9s { signed short v1:9; unsigned int v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9s_BFu9i_BFs9ll_BFu9i { signed short v1:9; unsigned int v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9s_BFu9i_BFs9ll_BFu9ll { signed short v1:9; unsigned int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9i_BFs9ll_BFu9s { signed short v1:9; unsigned int v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9s_BFu9i_BFs9s { signed short v1:9; unsigned int v2:9; signed short v3:9; };
struct BFs9s_BFu9i_BFs9s_BFs9i { signed short v1:9; unsigned int v2:9; signed short v3:9; signed int v4:9; };
struct BFs9s_BFu9i_BFs9s_BFs9ll { signed short v1:9; unsigned int v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9s_BFu9i_BFs9s_BFs9s { signed short v1:9; unsigned int v2:9; signed short v3:9; signed short v4:9; };
struct BFs9s_BFu9i_BFs9s_BFu9i { signed short v1:9; unsigned int v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9s_BFu9i_BFs9s_BFu9ll { signed short v1:9; unsigned int v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9i_BFs9s_BFu9s { signed short v1:9; unsigned int v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9s_BFu9i_BFu9i { signed short v1:9; unsigned int v2:9; unsigned int v3:9; };
struct BFs9s_BFu9i_BFu9i_BFs9i { signed short v1:9; unsigned int v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9s_BFu9i_BFu9i_BFs9ll { signed short v1:9; unsigned int v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9s_BFu9i_BFu9i_BFs9s { signed short v1:9; unsigned int v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9s_BFu9i_BFu9i_BFu9i { signed short v1:9; unsigned int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9s_BFu9i_BFu9i_BFu9ll { signed short v1:9; unsigned int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9i_BFu9i_BFu9s { signed short v1:9; unsigned int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9s_BFu9i_BFu9ll { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; };
struct BFs9s_BFu9i_BFu9ll_BFs9i { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9s_BFu9i_BFu9ll_BFs9ll { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9s_BFu9i_BFu9ll_BFs9s { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9s_BFu9i_BFu9ll_BFu9i { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9s_BFu9i_BFu9ll_BFu9ll { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9i_BFu9ll_BFu9s { signed short v1:9; unsigned int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9s_BFu9i_BFu9s { signed short v1:9; unsigned int v2:9; unsigned short v3:9; };
struct BFs9s_BFu9i_BFu9s_BFs9i { signed short v1:9; unsigned int v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9s_BFu9i_BFu9s_BFs9ll { signed short v1:9; unsigned int v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9s_BFu9i_BFu9s_BFs9s { signed short v1:9; unsigned int v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9s_BFu9i_BFu9s_BFu9i { signed short v1:9; unsigned int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9s_BFu9i_BFu9s_BFu9ll { signed short v1:9; unsigned int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9i_BFu9s_BFu9s { signed short v1:9; unsigned int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9s_BFu9ll { signed short v1:9; unsigned long long v2:9; };
struct BFs9s_BFu9ll_BFs9i { signed short v1:9; unsigned long long v2:9; signed int v3:9; };
struct BFs9s_BFu9ll_BFs9i_BFs9i { signed short v1:9; unsigned long long v2:9; signed int v3:9; signed int v4:9; };
struct BFs9s_BFu9ll_BFs9i_BFs9ll { signed short v1:9; unsigned long long v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9s_BFu9ll_BFs9i_BFs9s { signed short v1:9; unsigned long long v2:9; signed int v3:9; signed short v4:9; };
struct BFs9s_BFu9ll_BFs9i_BFu9i { signed short v1:9; unsigned long long v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9s_BFu9ll_BFs9i_BFu9ll { signed short v1:9; unsigned long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9ll_BFs9i_BFu9s { signed short v1:9; unsigned long long v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9s_BFu9ll_BFs9ll { signed short v1:9; unsigned long long v2:9; signed long long v3:9; };
struct BFs9s_BFu9ll_BFs9ll_BFs9i { signed short v1:9; unsigned long long v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9s_BFu9ll_BFs9ll_BFs9ll { signed short v1:9; unsigned long long v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9s_BFu9ll_BFs9ll_BFs9s { signed short v1:9; unsigned long long v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9s_BFu9ll_BFs9ll_BFu9i { signed short v1:9; unsigned long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9s_BFu9ll_BFs9ll_BFu9ll { signed short v1:9; unsigned long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9ll_BFs9ll_BFu9s { signed short v1:9; unsigned long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9s_BFu9ll_BFs9s { signed short v1:9; unsigned long long v2:9; signed short v3:9; };
struct BFs9s_BFu9ll_BFs9s_BFs9i { signed short v1:9; unsigned long long v2:9; signed short v3:9; signed int v4:9; };
struct BFs9s_BFu9ll_BFs9s_BFs9ll { signed short v1:9; unsigned long long v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9s_BFu9ll_BFs9s_BFs9s { signed short v1:9; unsigned long long v2:9; signed short v3:9; signed short v4:9; };
struct BFs9s_BFu9ll_BFs9s_BFu9i { signed short v1:9; unsigned long long v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9s_BFu9ll_BFs9s_BFu9ll { signed short v1:9; unsigned long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9ll_BFs9s_BFu9s { signed short v1:9; unsigned long long v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9s_BFu9ll_BFu9i { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; };
struct BFs9s_BFu9ll_BFu9i_BFs9i { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9s_BFu9ll_BFu9i_BFs9ll { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9s_BFu9ll_BFu9i_BFs9s { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9s_BFu9ll_BFu9i_BFu9i { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9s_BFu9ll_BFu9i_BFu9ll { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9ll_BFu9i_BFu9s { signed short v1:9; unsigned long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9s_BFu9ll_BFu9ll { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; };
struct BFs9s_BFu9ll_BFu9ll_BFs9i { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9s_BFu9ll_BFu9ll_BFs9ll { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9s_BFu9ll_BFu9ll_BFs9s { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9s_BFu9ll_BFu9ll_BFu9i { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9s_BFu9ll_BFu9ll_BFu9ll { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9ll_BFu9ll_BFu9s { signed short v1:9; unsigned long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9s_BFu9ll_BFu9s { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; };
struct BFs9s_BFu9ll_BFu9s_BFs9i { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9s_BFu9ll_BFu9s_BFs9ll { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9s_BFu9ll_BFu9s_BFs9s { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9s_BFu9ll_BFu9s_BFu9i { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9s_BFu9ll_BFu9s_BFu9ll { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9ll_BFu9s_BFu9s { signed short v1:9; unsigned long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFs9s_BFu9s { signed short v1:9; unsigned short v2:9; };
struct BFs9s_BFu9s_BFs9i { signed short v1:9; unsigned short v2:9; signed int v3:9; };
struct BFs9s_BFu9s_BFs9i_BFs9i { signed short v1:9; unsigned short v2:9; signed int v3:9; signed int v4:9; };
struct BFs9s_BFu9s_BFs9i_BFs9ll { signed short v1:9; unsigned short v2:9; signed int v3:9; signed long long v4:9; };
struct BFs9s_BFu9s_BFs9i_BFs9s { signed short v1:9; unsigned short v2:9; signed int v3:9; signed short v4:9; };
struct BFs9s_BFu9s_BFs9i_BFu9i { signed short v1:9; unsigned short v2:9; signed int v3:9; unsigned int v4:9; };
struct BFs9s_BFu9s_BFs9i_BFu9ll { signed short v1:9; unsigned short v2:9; signed int v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9s_BFs9i_BFu9s { signed short v1:9; unsigned short v2:9; signed int v3:9; unsigned short v4:9; };
struct BFs9s_BFu9s_BFs9ll { signed short v1:9; unsigned short v2:9; signed long long v3:9; };
struct BFs9s_BFu9s_BFs9ll_BFs9i { signed short v1:9; unsigned short v2:9; signed long long v3:9; signed int v4:9; };
struct BFs9s_BFu9s_BFs9ll_BFs9ll { signed short v1:9; unsigned short v2:9; signed long long v3:9; signed long long v4:9; };
struct BFs9s_BFu9s_BFs9ll_BFs9s { signed short v1:9; unsigned short v2:9; signed long long v3:9; signed short v4:9; };
struct BFs9s_BFu9s_BFs9ll_BFu9i { signed short v1:9; unsigned short v2:9; signed long long v3:9; unsigned int v4:9; };
struct BFs9s_BFu9s_BFs9ll_BFu9ll { signed short v1:9; unsigned short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9s_BFs9ll_BFu9s { signed short v1:9; unsigned short v2:9; signed long long v3:9; unsigned short v4:9; };
struct BFs9s_BFu9s_BFs9s { signed short v1:9; unsigned short v2:9; signed short v3:9; };
struct BFs9s_BFu9s_BFs9s_BFs9i { signed short v1:9; unsigned short v2:9; signed short v3:9; signed int v4:9; };
struct BFs9s_BFu9s_BFs9s_BFs9ll { signed short v1:9; unsigned short v2:9; signed short v3:9; signed long long v4:9; };
struct BFs9s_BFu9s_BFs9s_BFs9s { signed short v1:9; unsigned short v2:9; signed short v3:9; signed short v4:9; };
struct BFs9s_BFu9s_BFs9s_BFu9i { signed short v1:9; unsigned short v2:9; signed short v3:9; unsigned int v4:9; };
struct BFs9s_BFu9s_BFs9s_BFu9ll { signed short v1:9; unsigned short v2:9; signed short v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9s_BFs9s_BFu9s { signed short v1:9; unsigned short v2:9; signed short v3:9; unsigned short v4:9; };
struct BFs9s_BFu9s_BFu9i { signed short v1:9; unsigned short v2:9; unsigned int v3:9; };
struct BFs9s_BFu9s_BFu9i_BFs9i { signed short v1:9; unsigned short v2:9; unsigned int v3:9; signed int v4:9; };
struct BFs9s_BFu9s_BFu9i_BFs9ll { signed short v1:9; unsigned short v2:9; unsigned int v3:9; signed long long v4:9; };
struct BFs9s_BFu9s_BFu9i_BFs9s { signed short v1:9; unsigned short v2:9; unsigned int v3:9; signed short v4:9; };
struct BFs9s_BFu9s_BFu9i_BFu9i { signed short v1:9; unsigned short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct BFs9s_BFu9s_BFu9i_BFu9ll { signed short v1:9; unsigned short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9s_BFu9i_BFu9s { signed short v1:9; unsigned short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct BFs9s_BFu9s_BFu9ll { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; };
struct BFs9s_BFu9s_BFu9ll_BFs9i { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; signed int v4:9; };
struct BFs9s_BFu9s_BFu9ll_BFs9ll { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct BFs9s_BFu9s_BFu9ll_BFs9s { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; signed short v4:9; };
struct BFs9s_BFu9s_BFu9ll_BFu9i { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct BFs9s_BFu9s_BFu9ll_BFu9ll { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9s_BFu9ll_BFu9s { signed short v1:9; unsigned short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct BFs9s_BFu9s_BFu9s { signed short v1:9; unsigned short v2:9; unsigned short v3:9; };
struct BFs9s_BFu9s_BFu9s_BFs9i { signed short v1:9; unsigned short v2:9; unsigned short v3:9; signed int v4:9; };
struct BFs9s_BFu9s_BFu9s_BFs9ll { signed short v1:9; unsigned short v2:9; unsigned short v3:9; signed long long v4:9; };
struct BFs9s_BFu9s_BFu9s_BFs9s { signed short v1:9; unsigned short v2:9; unsigned short v3:9; signed short v4:9; };
struct BFs9s_BFu9s_BFu9s_BFu9i { signed short v1:9; unsigned short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct BFs9s_BFu9s_BFu9s_BFu9ll { signed short v1:9; unsigned short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct BFs9s_BFu9s_BFu9s_BFu9s { signed short v1:9; unsigned short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct BFu15i { unsigned int v1:15; };
struct BFu15i_BFs15i { unsigned int v1:15; signed int v2:15; };
struct BFu15i_BFs15i_BFs15i { unsigned int v1:15; signed int v2:15; signed int v3:15; };
struct BFu15i_BFs15i_BFs15i_BFs15i { unsigned int v1:15; signed int v2:15; signed int v3:15; signed int v4:15; };
struct BFu15i_BFs15i_BFs15i_BFs15ll { unsigned int v1:15; signed int v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15i_BFs15i_BFs15i_BFs15s { unsigned int v1:15; signed int v2:15; signed int v3:15; signed short v4:15; };
struct BFu15i_BFs15i_BFs15i_BFu15i { unsigned int v1:15; signed int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15i_BFs15i_BFs15i_BFu15ll { unsigned int v1:15; signed int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15i_BFs15i_BFu15s { unsigned int v1:15; signed int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15i_BFs15i_BFs15ll { unsigned int v1:15; signed int v2:15; signed long long v3:15; };
struct BFu15i_BFs15i_BFs15ll_BFs15i { unsigned int v1:15; signed int v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15i_BFs15i_BFs15ll_BFs15ll { unsigned int v1:15; signed int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15i_BFs15i_BFs15ll_BFs15s { unsigned int v1:15; signed int v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15i_BFs15i_BFs15ll_BFu15i { unsigned int v1:15; signed int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15i_BFs15i_BFs15ll_BFu15ll { unsigned int v1:15; signed int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15i_BFs15ll_BFu15s { unsigned int v1:15; signed int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15i_BFs15i_BFs15s { unsigned int v1:15; signed int v2:15; signed short v3:15; };
struct BFu15i_BFs15i_BFs15s_BFs15i { unsigned int v1:15; signed int v2:15; signed short v3:15; signed int v4:15; };
struct BFu15i_BFs15i_BFs15s_BFs15ll { unsigned int v1:15; signed int v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15i_BFs15i_BFs15s_BFs15s { unsigned int v1:15; signed int v2:15; signed short v3:15; signed short v4:15; };
struct BFu15i_BFs15i_BFs15s_BFu15i { unsigned int v1:15; signed int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15i_BFs15i_BFs15s_BFu15ll { unsigned int v1:15; signed int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15i_BFs15s_BFu15s { unsigned int v1:15; signed int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15i_BFs15i_BFu15i { unsigned int v1:15; signed int v2:15; unsigned int v3:15; };
struct BFu15i_BFs15i_BFu15i_BFs15i { unsigned int v1:15; signed int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15i_BFs15i_BFu15i_BFs15ll { unsigned int v1:15; signed int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15i_BFs15i_BFu15i_BFs15s { unsigned int v1:15; signed int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15i_BFs15i_BFu15i_BFu15i { unsigned int v1:15; signed int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15i_BFs15i_BFu15i_BFu15ll { unsigned int v1:15; signed int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15i_BFu15i_BFu15s { unsigned int v1:15; signed int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15i_BFs15i_BFu15ll { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; };
struct BFu15i_BFs15i_BFu15ll_BFs15i { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15i_BFs15i_BFu15ll_BFs15ll { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15i_BFs15i_BFu15ll_BFs15s { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15i_BFs15i_BFu15ll_BFu15i { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15i_BFs15i_BFu15ll_BFu15ll { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15i_BFu15ll_BFu15s { unsigned int v1:15; signed int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15i_BFs15i_BFu15s { unsigned int v1:15; signed int v2:15; unsigned short v3:15; };
struct BFu15i_BFs15i_BFu15s_BFs15i { unsigned int v1:15; signed int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15i_BFs15i_BFu15s_BFs15ll { unsigned int v1:15; signed int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15i_BFs15i_BFu15s_BFs15s { unsigned int v1:15; signed int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15i_BFs15i_BFu15s_BFu15i { unsigned int v1:15; signed int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15i_BFs15i_BFu15s_BFu15ll { unsigned int v1:15; signed int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15i_BFu15s_BFu15s { unsigned int v1:15; signed int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15i_BFs15ll { unsigned int v1:15; signed long long v2:15; };
struct BFu15i_BFs15ll_BFs15i { unsigned int v1:15; signed long long v2:15; signed int v3:15; };
struct BFu15i_BFs15ll_BFs15i_BFs15i { unsigned int v1:15; signed long long v2:15; signed int v3:15; signed int v4:15; };
struct BFu15i_BFs15ll_BFs15i_BFs15ll { unsigned int v1:15; signed long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15i_BFs15ll_BFs15i_BFs15s { unsigned int v1:15; signed long long v2:15; signed int v3:15; signed short v4:15; };
struct BFu15i_BFs15ll_BFs15i_BFu15i { unsigned int v1:15; signed long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15i_BFs15ll_BFs15i_BFu15ll { unsigned int v1:15; signed long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15ll_BFs15i_BFu15s { unsigned int v1:15; signed long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15i_BFs15ll_BFs15ll { unsigned int v1:15; signed long long v2:15; signed long long v3:15; };
struct BFu15i_BFs15ll_BFs15ll_BFs15i { unsigned int v1:15; signed long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15i_BFs15ll_BFs15ll_BFs15ll { unsigned int v1:15; signed long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15i_BFs15ll_BFs15ll_BFs15s { unsigned int v1:15; signed long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15i_BFs15ll_BFs15ll_BFu15i { unsigned int v1:15; signed long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15i_BFs15ll_BFs15ll_BFu15ll { unsigned int v1:15; signed long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15ll_BFs15ll_BFu15s { unsigned int v1:15; signed long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15i_BFs15ll_BFs15s { unsigned int v1:15; signed long long v2:15; signed short v3:15; };
struct BFu15i_BFs15ll_BFs15s_BFs15i { unsigned int v1:15; signed long long v2:15; signed short v3:15; signed int v4:15; };
struct BFu15i_BFs15ll_BFs15s_BFs15ll { unsigned int v1:15; signed long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15i_BFs15ll_BFs15s_BFs15s { unsigned int v1:15; signed long long v2:15; signed short v3:15; signed short v4:15; };
struct BFu15i_BFs15ll_BFs15s_BFu15i { unsigned int v1:15; signed long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15i_BFs15ll_BFs15s_BFu15ll { unsigned int v1:15; signed long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15ll_BFs15s_BFu15s { unsigned int v1:15; signed long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15i_BFs15ll_BFu15i { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; };
struct BFu15i_BFs15ll_BFu15i_BFs15i { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15i_BFs15ll_BFu15i_BFs15ll { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15i_BFs15ll_BFu15i_BFs15s { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15i_BFs15ll_BFu15i_BFu15i { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15i_BFs15ll_BFu15i_BFu15ll { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15ll_BFu15i_BFu15s { unsigned int v1:15; signed long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15i_BFs15ll_BFu15ll { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; };
struct BFu15i_BFs15ll_BFu15ll_BFs15i { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15i_BFs15ll_BFu15ll_BFs15ll { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15i_BFs15ll_BFu15ll_BFs15s { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15i_BFs15ll_BFu15ll_BFu15i { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15i_BFs15ll_BFu15ll_BFu15ll { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15ll_BFu15ll_BFu15s { unsigned int v1:15; signed long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15i_BFs15ll_BFu15s { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; };
struct BFu15i_BFs15ll_BFu15s_BFs15i { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15i_BFs15ll_BFu15s_BFs15ll { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15i_BFs15ll_BFu15s_BFs15s { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15i_BFs15ll_BFu15s_BFu15i { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15i_BFs15ll_BFu15s_BFu15ll { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15ll_BFu15s_BFu15s { unsigned int v1:15; signed long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15i_BFs15s { unsigned int v1:15; signed short v2:15; };
struct BFu15i_BFs15s_BFs15i { unsigned int v1:15; signed short v2:15; signed int v3:15; };
struct BFu15i_BFs15s_BFs15i_BFs15i { unsigned int v1:15; signed short v2:15; signed int v3:15; signed int v4:15; };
struct BFu15i_BFs15s_BFs15i_BFs15ll { unsigned int v1:15; signed short v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15i_BFs15s_BFs15i_BFs15s { unsigned int v1:15; signed short v2:15; signed int v3:15; signed short v4:15; };
struct BFu15i_BFs15s_BFs15i_BFu15i { unsigned int v1:15; signed short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15i_BFs15s_BFs15i_BFu15ll { unsigned int v1:15; signed short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15s_BFs15i_BFu15s { unsigned int v1:15; signed short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15i_BFs15s_BFs15ll { unsigned int v1:15; signed short v2:15; signed long long v3:15; };
struct BFu15i_BFs15s_BFs15ll_BFs15i { unsigned int v1:15; signed short v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15i_BFs15s_BFs15ll_BFs15ll { unsigned int v1:15; signed short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15i_BFs15s_BFs15ll_BFs15s { unsigned int v1:15; signed short v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15i_BFs15s_BFs15ll_BFu15i { unsigned int v1:15; signed short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15i_BFs15s_BFs15ll_BFu15ll { unsigned int v1:15; signed short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15s_BFs15ll_BFu15s { unsigned int v1:15; signed short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15i_BFs15s_BFs15s { unsigned int v1:15; signed short v2:15; signed short v3:15; };
struct BFu15i_BFs15s_BFs15s_BFs15i { unsigned int v1:15; signed short v2:15; signed short v3:15; signed int v4:15; };
struct BFu15i_BFs15s_BFs15s_BFs15ll { unsigned int v1:15; signed short v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15i_BFs15s_BFs15s_BFs15s { unsigned int v1:15; signed short v2:15; signed short v3:15; signed short v4:15; };
struct BFu15i_BFs15s_BFs15s_BFu15i { unsigned int v1:15; signed short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15i_BFs15s_BFs15s_BFu15ll { unsigned int v1:15; signed short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15s_BFs15s_BFu15s { unsigned int v1:15; signed short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15i_BFs15s_BFu15i { unsigned int v1:15; signed short v2:15; unsigned int v3:15; };
struct BFu15i_BFs15s_BFu15i_BFs15i { unsigned int v1:15; signed short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15i_BFs15s_BFu15i_BFs15ll { unsigned int v1:15; signed short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15i_BFs15s_BFu15i_BFs15s { unsigned int v1:15; signed short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15i_BFs15s_BFu15i_BFu15i { unsigned int v1:15; signed short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15i_BFs15s_BFu15i_BFu15ll { unsigned int v1:15; signed short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15s_BFu15i_BFu15s { unsigned int v1:15; signed short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15i_BFs15s_BFu15ll { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; };
struct BFu15i_BFs15s_BFu15ll_BFs15i { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15i_BFs15s_BFu15ll_BFs15ll { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15i_BFs15s_BFu15ll_BFs15s { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15i_BFs15s_BFu15ll_BFu15i { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15i_BFs15s_BFu15ll_BFu15ll { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15s_BFu15ll_BFu15s { unsigned int v1:15; signed short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15i_BFs15s_BFu15s { unsigned int v1:15; signed short v2:15; unsigned short v3:15; };
struct BFu15i_BFs15s_BFu15s_BFs15i { unsigned int v1:15; signed short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15i_BFs15s_BFu15s_BFs15ll { unsigned int v1:15; signed short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15i_BFs15s_BFu15s_BFs15s { unsigned int v1:15; signed short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15i_BFs15s_BFu15s_BFu15i { unsigned int v1:15; signed short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15i_BFs15s_BFu15s_BFu15ll { unsigned int v1:15; signed short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15i_BFs15s_BFu15s_BFu15s { unsigned int v1:15; signed short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i { unsigned int v1:15; unsigned int v2:15; };
struct BFu15i_BFu15i_BFs15i { unsigned int v1:15; unsigned int v2:15; signed int v3:15; };
struct BFu15i_BFu15i_BFs15i_BFs15i { unsigned int v1:15; unsigned int v2:15; signed int v3:15; signed int v4:15; };
struct BFu15i_BFu15i_BFs15i_BFs15ll { unsigned int v1:15; unsigned int v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15i_BFu15i_BFs15i_BFs15s { unsigned int v1:15; unsigned int v2:15; signed int v3:15; signed short v4:15; };
struct BFu15i_BFu15i_BFs15i_BFu15i { unsigned int v1:15; unsigned int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15i_BFu15i_BFs15i_BFu15ll { unsigned int v1:15; unsigned int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15i_BFs15i_BFu15s { unsigned int v1:15; unsigned int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i_BFs15ll { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; };
struct BFu15i_BFu15i_BFs15ll_BFs15i { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15i_BFu15i_BFs15ll_BFs15ll { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15i_BFu15i_BFs15ll_BFs15s { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15i_BFu15i_BFs15ll_BFu15i { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15i_BFu15i_BFs15ll_BFu15ll { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15i_BFs15ll_BFu15s { unsigned int v1:15; unsigned int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i_BFs15s { unsigned int v1:15; unsigned int v2:15; signed short v3:15; };
struct BFu15i_BFu15i_BFs15s_BFs15i { unsigned int v1:15; unsigned int v2:15; signed short v3:15; signed int v4:15; };
struct BFu15i_BFu15i_BFs15s_BFs15ll { unsigned int v1:15; unsigned int v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15i_BFu15i_BFs15s_BFs15s { unsigned int v1:15; unsigned int v2:15; signed short v3:15; signed short v4:15; };
struct BFu15i_BFu15i_BFs15s_BFu15i { unsigned int v1:15; unsigned int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15i_BFu15i_BFs15s_BFu15ll { unsigned int v1:15; unsigned int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15i_BFs15s_BFu15s { unsigned int v1:15; unsigned int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i_BFu15i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; };
struct BFu15i_BFu15i_BFu15i_BFs15i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15i_BFu15i_BFu15i_BFs15ll { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15i_BFu15i_BFu15i_BFs15s { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15i_BFu15i_BFu15i_BFu15i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15i_BFu15i_BFu15i_BFu15ll { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15i_BFu15i_BFu15s { unsigned int v1:15; unsigned int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i_BFu15ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; };
struct BFu15i_BFu15i_BFu15ll_BFs15i { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15i_BFu15i_BFu15ll_BFs15ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15i_BFu15i_BFu15ll_BFs15s { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15i_BFu15i_BFu15ll_BFu15i { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15i_BFu15i_BFu15ll_BFu15ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15i_BFu15ll_BFu15s { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i_BFu15s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; };
struct BFu15i_BFu15i_BFu15s_BFs15i { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15i_BFu15i_BFu15s_BFs15ll { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15i_BFu15i_BFu15s_BFs15s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15i_BFu15i_BFu15s_BFu15i { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15i_BFu15i_BFu15s_BFu15ll { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15i_BFu15s_BFu15s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15i_BFu16i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:16; };
struct BFu15i_BFu15i_BFu16ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:16; };
struct BFu15i_BFu15i_BFu16s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:16; };
struct BFu15i_BFu15i_BFu17i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:17; };
struct BFu15i_BFu15i_BFu17ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:17; };
struct BFu15i_BFu15i_BFu1c { unsigned int v1:15; unsigned int v2:15; unsigned char v3:1; };
struct BFu15i_BFu15i_BFu1i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:1; };
struct BFu15i_BFu15i_BFu1ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:1; };
struct BFu15i_BFu15i_BFu1s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:1; };
struct BFu15i_BFu15i_BFu31i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:31; };
struct BFu15i_BFu15i_BFu31ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:31; };
struct BFu15i_BFu15i_BFu32i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:32; };
struct BFu15i_BFu15i_BFu32ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:32; };
struct BFu15i_BFu15i_BFu33 { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:33; };
struct BFu15i_BFu15i_BFu7c { unsigned int v1:15; unsigned int v2:15; unsigned char v3:7; };
struct BFu15i_BFu15i_BFu7i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:7; };
struct BFu15i_BFu15i_BFu7ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:7; };
struct BFu15i_BFu15i_BFu7s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:7; };
struct BFu15i_BFu15i_BFu8c { unsigned int v1:15; unsigned int v2:15; unsigned char v3:8; };
struct BFu15i_BFu15i_BFu8i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:8; };
struct BFu15i_BFu15i_BFu8ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:8; };
struct BFu15i_BFu15i_BFu8s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:8; };
struct BFu15i_BFu15i_BFu9i { unsigned int v1:15; unsigned int v2:15; unsigned int v3:9; };
struct BFu15i_BFu15i_BFu9ll { unsigned int v1:15; unsigned int v2:15; unsigned long long v3:9; };
struct BFu15i_BFu15i_BFu9s { unsigned int v1:15; unsigned int v2:15; unsigned short v3:9; };
struct BFu15i_BFu15i_C { unsigned int v1:15; unsigned int v2:15; char v3; };
struct BFu15i_BFu15i_D { unsigned int v1:15; unsigned int v2:15; double v3; };
struct BFu15i_BFu15i_F { unsigned int v1:15; unsigned int v2:15; float v3; };
struct BFu15i_BFu15i_I { unsigned int v1:15; unsigned int v2:15; int v3; };
struct BFu15i_BFu15i_Ip { unsigned int v1:15; unsigned int v2:15; int * v3; };
struct BFu15i_BFu15i_L { unsigned int v1:15; unsigned int v2:15; long long v3; };
struct BFu15i_BFu15i_S { unsigned int v1:15; unsigned int v2:15; short v3; };
struct BFu15i_BFu15i_Uc { unsigned int v1:15; unsigned int v2:15; unsigned char v3; };
struct BFu15i_BFu15i_Ui { unsigned int v1:15; unsigned int v2:15; unsigned int v3; };
struct BFu15i_BFu15i_Ul { unsigned int v1:15; unsigned int v2:15; unsigned long long v3; };
struct BFu15i_BFu15i_Us { unsigned int v1:15; unsigned int v2:15; unsigned short v3; };
struct BFu15i_BFu15i_Vp { unsigned int v1:15; unsigned int v2:15; void * v3; };
struct BFu15i_BFu15ll { unsigned int v1:15; unsigned long long v2:15; };
struct BFu15i_BFu15ll_BFs15i { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; };
struct BFu15i_BFu15ll_BFs15i_BFs15i { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; signed int v4:15; };
struct BFu15i_BFu15ll_BFs15i_BFs15ll { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15i_BFu15ll_BFs15i_BFs15s { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; signed short v4:15; };
struct BFu15i_BFu15ll_BFs15i_BFu15i { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15i_BFu15ll_BFs15i_BFu15ll { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15ll_BFs15i_BFu15s { unsigned int v1:15; unsigned long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15i_BFu15ll_BFs15ll { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; };
struct BFu15i_BFu15ll_BFs15ll_BFs15i { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15i_BFu15ll_BFs15ll_BFs15ll { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15i_BFu15ll_BFs15ll_BFs15s { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15i_BFu15ll_BFs15ll_BFu15i { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15i_BFu15ll_BFs15ll_BFu15ll { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15ll_BFs15ll_BFu15s { unsigned int v1:15; unsigned long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15i_BFu15ll_BFs15s { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; };
struct BFu15i_BFu15ll_BFs15s_BFs15i { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; signed int v4:15; };
struct BFu15i_BFu15ll_BFs15s_BFs15ll { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15i_BFu15ll_BFs15s_BFs15s { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; signed short v4:15; };
struct BFu15i_BFu15ll_BFs15s_BFu15i { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15i_BFu15ll_BFs15s_BFu15ll { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15ll_BFs15s_BFu15s { unsigned int v1:15; unsigned long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15ll_BFu15i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; };
struct BFu15i_BFu15ll_BFu15i_BFs15i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15i_BFu15ll_BFu15i_BFs15ll { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15i_BFu15ll_BFu15i_BFs15s { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15i_BFu15ll_BFu15i_BFu15i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15i_BFu15ll_BFu15i_BFu15ll { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15ll_BFu15i_BFu15s { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15i_BFu15ll_BFu15ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; };
struct BFu15i_BFu15ll_BFu15ll_BFs15i { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15i_BFu15ll_BFu15ll_BFs15ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15i_BFu15ll_BFu15ll_BFs15s { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15i_BFu15ll_BFu15ll_BFu15i { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15i_BFu15ll_BFu15ll_BFu15ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15ll_BFu15ll_BFu15s { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15i_BFu15ll_BFu15s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; };
struct BFu15i_BFu15ll_BFu15s_BFs15i { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15i_BFu15ll_BFu15s_BFs15ll { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15i_BFu15ll_BFu15s_BFs15s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15i_BFu15ll_BFu15s_BFu15i { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15i_BFu15ll_BFu15s_BFu15ll { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15ll_BFu15s_BFu15s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15ll_BFu16i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:16; };
struct BFu15i_BFu15ll_BFu16ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:16; };
struct BFu15i_BFu15ll_BFu16s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:16; };
struct BFu15i_BFu15ll_BFu17i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:17; };
struct BFu15i_BFu15ll_BFu17ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:17; };
struct BFu15i_BFu15ll_BFu1c { unsigned int v1:15; unsigned long long v2:15; unsigned char v3:1; };
struct BFu15i_BFu15ll_BFu1i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:1; };
struct BFu15i_BFu15ll_BFu1ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:1; };
struct BFu15i_BFu15ll_BFu1s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:1; };
struct BFu15i_BFu15ll_BFu31i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:31; };
struct BFu15i_BFu15ll_BFu31ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:31; };
struct BFu15i_BFu15ll_BFu32i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:32; };
struct BFu15i_BFu15ll_BFu32ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:32; };
struct BFu15i_BFu15ll_BFu33 { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:33; };
struct BFu15i_BFu15ll_BFu7c { unsigned int v1:15; unsigned long long v2:15; unsigned char v3:7; };
struct BFu15i_BFu15ll_BFu7i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:7; };
struct BFu15i_BFu15ll_BFu7ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:7; };
struct BFu15i_BFu15ll_BFu7s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:7; };
struct BFu15i_BFu15ll_BFu8c { unsigned int v1:15; unsigned long long v2:15; unsigned char v3:8; };
struct BFu15i_BFu15ll_BFu8i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:8; };
struct BFu15i_BFu15ll_BFu8ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:8; };
struct BFu15i_BFu15ll_BFu8s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:8; };
struct BFu15i_BFu15ll_BFu9i { unsigned int v1:15; unsigned long long v2:15; unsigned int v3:9; };
struct BFu15i_BFu15ll_BFu9ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3:9; };
struct BFu15i_BFu15ll_BFu9s { unsigned int v1:15; unsigned long long v2:15; unsigned short v3:9; };
struct BFu15i_BFu15ll_C { unsigned int v1:15; unsigned long long v2:15; char v3; };
struct BFu15i_BFu15ll_D { unsigned int v1:15; unsigned long long v2:15; double v3; };
struct BFu15i_BFu15ll_F { unsigned int v1:15; unsigned long long v2:15; float v3; };
struct BFu15i_BFu15ll_I { unsigned int v1:15; unsigned long long v2:15; int v3; };
struct BFu15i_BFu15ll_Ip { unsigned int v1:15; unsigned long long v2:15; int * v3; };
struct BFu15i_BFu15ll_L { unsigned int v1:15; unsigned long long v2:15; long long v3; };
struct BFu15i_BFu15ll_S { unsigned int v1:15; unsigned long long v2:15; short v3; };
struct BFu15i_BFu15ll_Uc { unsigned int v1:15; unsigned long long v2:15; unsigned char v3; };
struct BFu15i_BFu15ll_Ui { unsigned int v1:15; unsigned long long v2:15; unsigned int v3; };
struct BFu15i_BFu15ll_Ul { unsigned int v1:15; unsigned long long v2:15; unsigned long long v3; };
struct BFu15i_BFu15ll_Us { unsigned int v1:15; unsigned long long v2:15; unsigned short v3; };
struct BFu15i_BFu15ll_Vp { unsigned int v1:15; unsigned long long v2:15; void * v3; };
struct BFu15i_BFu15s { unsigned int v1:15; unsigned short v2:15; };
struct BFu15i_BFu15s_BFs15i { unsigned int v1:15; unsigned short v2:15; signed int v3:15; };
struct BFu15i_BFu15s_BFs15i_BFs15i { unsigned int v1:15; unsigned short v2:15; signed int v3:15; signed int v4:15; };
struct BFu15i_BFu15s_BFs15i_BFs15ll { unsigned int v1:15; unsigned short v2:15; signed int v3:15; signed long long v4:15; };
struct BFu15i_BFu15s_BFs15i_BFs15s { unsigned int v1:15; unsigned short v2:15; signed int v3:15; signed short v4:15; };
struct BFu15i_BFu15s_BFs15i_BFu15i { unsigned int v1:15; unsigned short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFu15i_BFu15s_BFs15i_BFu15ll { unsigned int v1:15; unsigned short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15s_BFs15i_BFu15s { unsigned int v1:15; unsigned short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFu15i_BFu15s_BFs15ll { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; };
struct BFu15i_BFu15s_BFs15ll_BFs15i { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; signed int v4:15; };
struct BFu15i_BFu15s_BFs15ll_BFs15ll { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFu15i_BFu15s_BFs15ll_BFs15s { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; signed short v4:15; };
struct BFu15i_BFu15s_BFs15ll_BFu15i { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFu15i_BFu15s_BFs15ll_BFu15ll { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15s_BFs15ll_BFu15s { unsigned int v1:15; unsigned short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFu15i_BFu15s_BFs15s { unsigned int v1:15; unsigned short v2:15; signed short v3:15; };
struct BFu15i_BFu15s_BFs15s_BFs15i { unsigned int v1:15; unsigned short v2:15; signed short v3:15; signed int v4:15; };
struct BFu15i_BFu15s_BFs15s_BFs15ll { unsigned int v1:15; unsigned short v2:15; signed short v3:15; signed long long v4:15; };
struct BFu15i_BFu15s_BFs15s_BFs15s { unsigned int v1:15; unsigned short v2:15; signed short v3:15; signed short v4:15; };
struct BFu15i_BFu15s_BFs15s_BFu15i { unsigned int v1:15; unsigned short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFu15i_BFu15s_BFs15s_BFu15ll { unsigned int v1:15; unsigned short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15s_BFs15s_BFu15s { unsigned int v1:15; unsigned short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15s_BFu15i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; };
struct BFu15i_BFu15s_BFu15i_BFs15i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFu15i_BFu15s_BFu15i_BFs15ll { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFu15i_BFu15s_BFu15i_BFs15s { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFu15i_BFu15s_BFu15i_BFu15i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFu15i_BFu15s_BFu15i_BFu15ll { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15s_BFu15i_BFu15s { unsigned int v1:15; unsigned short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFu15i_BFu15s_BFu15ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; };
struct BFu15i_BFu15s_BFu15ll_BFs15i { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFu15i_BFu15s_BFu15ll_BFs15ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFu15i_BFu15s_BFu15ll_BFs15s { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFu15i_BFu15s_BFu15ll_BFu15i { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFu15i_BFu15s_BFu15ll_BFu15ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15s_BFu15ll_BFu15s { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFu15i_BFu15s_BFu15s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; };
struct BFu15i_BFu15s_BFu15s_BFs15i { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFu15i_BFu15s_BFu15s_BFs15ll { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFu15i_BFu15s_BFu15s_BFs15s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFu15i_BFu15s_BFu15s_BFu15i { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFu15i_BFu15s_BFu15s_BFu15ll { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFu15i_BFu15s_BFu15s_BFu15s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFu15i_BFu15s_BFu16i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:16; };
struct BFu15i_BFu15s_BFu16ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:16; };
struct BFu15i_BFu15s_BFu16s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:16; };
struct BFu15i_BFu15s_BFu17i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:17; };
struct BFu15i_BFu15s_BFu17ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:17; };
struct BFu15i_BFu15s_BFu1c { unsigned int v1:15; unsigned short v2:15; unsigned char v3:1; };
struct BFu15i_BFu15s_BFu1i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:1; };
struct BFu15i_BFu15s_BFu1ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:1; };
struct BFu15i_BFu15s_BFu1s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:1; };
struct BFu15i_BFu15s_BFu31i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:31; };
struct BFu15i_BFu15s_BFu31ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:31; };
struct BFu15i_BFu15s_BFu32i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:32; };
struct BFu15i_BFu15s_BFu32ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:32; };
struct BFu15i_BFu15s_BFu33 { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:33; };
struct BFu15i_BFu15s_BFu7c { unsigned int v1:15; unsigned short v2:15; unsigned char v3:7; };
struct BFu15i_BFu15s_BFu7i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:7; };
struct BFu15i_BFu15s_BFu7ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:7; };
struct BFu15i_BFu15s_BFu7s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:7; };
struct BFu15i_BFu15s_BFu8c { unsigned int v1:15; unsigned short v2:15; unsigned char v3:8; };
struct BFu15i_BFu15s_BFu8i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:8; };
struct BFu15i_BFu15s_BFu8ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:8; };
struct BFu15i_BFu15s_BFu8s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:8; };
struct BFu15i_BFu15s_BFu9i { unsigned int v1:15; unsigned short v2:15; unsigned int v3:9; };
struct BFu15i_BFu15s_BFu9ll { unsigned int v1:15; unsigned short v2:15; unsigned long long v3:9; };
struct BFu15i_BFu15s_BFu9s { unsigned int v1:15; unsigned short v2:15; unsigned short v3:9; };
struct BFu15i_BFu15s_C { unsigned int v1:15; unsigned short v2:15; char v3; };
struct BFu15i_BFu15s_D { unsigned int v1:15; unsigned short v2:15; double v3; };
struct BFu15i_BFu15s_F { unsigned int v1:15; unsigned short v2:15; float v3; };
struct BFu15i_BFu15s_I { unsigned int v1:15; unsigned short v2:15; int v3; };
struct BFu15i_BFu15s_Ip { unsigned int v1:15; unsigned short v2:15; int * v3; };
struct BFu15i_BFu15s_L { unsigned int v1:15; unsigned short v2:15; long long v3; };
struct BFu15i_BFu15s_S { unsigned int v1:15; unsigned short v2:15; short v3; };
struct BFu15i_BFu15s_Uc { unsigned int v1:15; unsigned short v2:15; unsigned char v3; };
struct BFu15i_BFu15s_Ui { unsigned int v1:15; unsigned short v2:15; unsigned int v3; };
struct BFu15i_BFu15s_Ul { unsigned int v1:15; unsigned short v2:15; unsigned long long v3; };
struct BFu15i_BFu15s_Us { unsigned int v1:15; unsigned short v2:15; unsigned short v3; };
struct BFu15i_BFu15s_Vp { unsigned int v1:15; unsigned short v2:15; void * v3; };
struct BFu15i_BFu16i { unsigned int v1:15; unsigned int v2:16; };
struct BFu15i_BFu16i_BFu15i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:15; };
struct BFu15i_BFu16i_BFu15ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:15; };
struct BFu15i_BFu16i_BFu15s { unsigned int v1:15; unsigned int v2:16; unsigned short v3:15; };
struct BFu15i_BFu16i_BFu16i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:16; };
struct BFu15i_BFu16i_BFu16ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:16; };
struct BFu15i_BFu16i_BFu16s { unsigned int v1:15; unsigned int v2:16; unsigned short v3:16; };
struct BFu15i_BFu16i_BFu17i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:17; };
struct BFu15i_BFu16i_BFu17ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:17; };
struct BFu15i_BFu16i_BFu1c { unsigned int v1:15; unsigned int v2:16; unsigned char v3:1; };
struct BFu15i_BFu16i_BFu1i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:1; };
struct BFu15i_BFu16i_BFu1ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:1; };
struct BFu15i_BFu16i_BFu1s { unsigned int v1:15; unsigned int v2:16; unsigned short v3:1; };
struct BFu15i_BFu16i_BFu31i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:31; };
struct BFu15i_BFu16i_BFu31ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:31; };
struct BFu15i_BFu16i_BFu32i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:32; };
struct BFu15i_BFu16i_BFu32ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:32; };
struct BFu15i_BFu16i_BFu33 { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:33; };
struct BFu15i_BFu16i_BFu7c { unsigned int v1:15; unsigned int v2:16; unsigned char v3:7; };
struct BFu15i_BFu16i_BFu7i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:7; };
struct BFu15i_BFu16i_BFu7ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:7; };
struct BFu15i_BFu16i_BFu7s { unsigned int v1:15; unsigned int v2:16; unsigned short v3:7; };
struct BFu15i_BFu16i_BFu8c { unsigned int v1:15; unsigned int v2:16; unsigned char v3:8; };
struct BFu15i_BFu16i_BFu8i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:8; };
struct BFu15i_BFu16i_BFu8ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:8; };
struct BFu15i_BFu16i_BFu8s { unsigned int v1:15; unsigned int v2:16; unsigned short v3:8; };
struct BFu15i_BFu16i_BFu9i { unsigned int v1:15; unsigned int v2:16; unsigned int v3:9; };
struct BFu15i_BFu16i_BFu9ll { unsigned int v1:15; unsigned int v2:16; unsigned long long v3:9; };
struct BFu15i_BFu16i_BFu9s { unsigned int v1:15; unsigned int v2:16; unsigned short v3:9; };
struct BFu15i_BFu16i_C { unsigned int v1:15; unsigned int v2:16; char v3; };
struct BFu15i_BFu16i_D { unsigned int v1:15; unsigned int v2:16; double v3; };
struct BFu15i_BFu16i_F { unsigned int v1:15; unsigned int v2:16; float v3; };
struct BFu15i_BFu16i_I { unsigned int v1:15; unsigned int v2:16; int v3; };
struct BFu15i_BFu16i_Ip { unsigned int v1:15; unsigned int v2:16; int * v3; };
struct BFu15i_BFu16i_L { unsigned int v1:15; unsigned int v2:16; long long v3; };
struct BFu15i_BFu16i_S { unsigned int v1:15; unsigned int v2:16; short v3; };
struct BFu15i_BFu16i_Uc { unsigned int v1:15; unsigned int v2:16; unsigned char v3; };
struct BFu15i_BFu16i_Ui { unsigned int v1:15; unsigned int v2:16; unsigned int v3; };
struct BFu15i_BFu16i_Ul { unsigned int v1:15; unsigned int v2:16; unsigned long long v3; };
struct BFu15i_BFu16i_Us { unsigned int v1:15; unsigned int v2:16; unsigned short v3; };
struct BFu15i_BFu16i_Vp { unsigned int v1:15; unsigned int v2:16; void * v3; };
struct BFu15i_BFu16ll { unsigned int v1:15; unsigned long long v2:16; };
struct BFu15i_BFu16ll_BFu15i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:15; };
struct BFu15i_BFu16ll_BFu15ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:15; };
struct BFu15i_BFu16ll_BFu15s { unsigned int v1:15; unsigned long long v2:16; unsigned short v3:15; };
struct BFu15i_BFu16ll_BFu16i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:16; };
struct BFu15i_BFu16ll_BFu16ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:16; };
struct BFu15i_BFu16ll_BFu16s { unsigned int v1:15; unsigned long long v2:16; unsigned short v3:16; };
struct BFu15i_BFu16ll_BFu17i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:17; };
struct BFu15i_BFu16ll_BFu17ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:17; };
struct BFu15i_BFu16ll_BFu1c { unsigned int v1:15; unsigned long long v2:16; unsigned char v3:1; };
struct BFu15i_BFu16ll_BFu1i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:1; };
struct BFu15i_BFu16ll_BFu1ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:1; };
struct BFu15i_BFu16ll_BFu1s { unsigned int v1:15; unsigned long long v2:16; unsigned short v3:1; };
struct BFu15i_BFu16ll_BFu31i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:31; };
struct BFu15i_BFu16ll_BFu31ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:31; };
struct BFu15i_BFu16ll_BFu32i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:32; };
struct BFu15i_BFu16ll_BFu32ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:32; };
struct BFu15i_BFu16ll_BFu33 { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:33; };
struct BFu15i_BFu16ll_BFu7c { unsigned int v1:15; unsigned long long v2:16; unsigned char v3:7; };
struct BFu15i_BFu16ll_BFu7i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:7; };
struct BFu15i_BFu16ll_BFu7ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:7; };
struct BFu15i_BFu16ll_BFu7s { unsigned int v1:15; unsigned long long v2:16; unsigned short v3:7; };
struct BFu15i_BFu16ll_BFu8c { unsigned int v1:15; unsigned long long v2:16; unsigned char v3:8; };
struct BFu15i_BFu16ll_BFu8i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:8; };
struct BFu15i_BFu16ll_BFu8ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:8; };
struct BFu15i_BFu16ll_BFu8s { unsigned int v1:15; unsigned long long v2:16; unsigned short v3:8; };
struct BFu15i_BFu16ll_BFu9i { unsigned int v1:15; unsigned long long v2:16; unsigned int v3:9; };
struct BFu15i_BFu16ll_BFu9ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3:9; };
struct BFu15i_BFu16ll_BFu9s { unsigned int v1:15; unsigned long long v2:16; unsigned short v3:9; };
struct BFu15i_BFu16ll_C { unsigned int v1:15; unsigned long long v2:16; char v3; };
struct BFu15i_BFu16ll_D { unsigned int v1:15; unsigned long long v2:16; double v3; };
struct BFu15i_BFu16ll_F { unsigned int v1:15; unsigned long long v2:16; float v3; };
struct BFu15i_BFu16ll_I { unsigned int v1:15; unsigned long long v2:16; int v3; };
struct BFu15i_BFu16ll_Ip { unsigned int v1:15; unsigned long long v2:16; int * v3; };
struct BFu15i_BFu16ll_L { unsigned int v1:15; unsigned long long v2:16; long long v3; };
struct BFu15i_BFu16ll_S { unsigned int v1:15; unsigned long long v2:16; short v3; };
struct BFu15i_BFu16ll_Uc { unsigned int v1:15; unsigned long long v2:16; unsigned char v3; };
struct BFu15i_BFu16ll_Ui { unsigned int v1:15; unsigned long long v2:16; unsigned int v3; };
struct BFu15i_BFu16ll_Ul { unsigned int v1:15; unsigned long long v2:16; unsigned long long v3; };
struct BFu15i_BFu16ll_Us { unsigned int v1:15; unsigned long long v2:16; unsigned short v3; };
struct BFu15i_BFu16ll_Vp { unsigned int v1:15; unsigned long long v2:16; void * v3; };
struct BFu15i_BFu16s { unsigned int v1:15; unsigned short v2:16; };
struct BFu15i_BFu16s_BFu15i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:15; };
struct BFu15i_BFu16s_BFu15ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:15; };
struct BFu15i_BFu16s_BFu15s { unsigned int v1:15; unsigned short v2:16; unsigned short v3:15; };
struct BFu15i_BFu16s_BFu16i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:16; };
struct BFu15i_BFu16s_BFu16ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:16; };
struct BFu15i_BFu16s_BFu16s { unsigned int v1:15; unsigned short v2:16; unsigned short v3:16; };
struct BFu15i_BFu16s_BFu17i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:17; };
struct BFu15i_BFu16s_BFu17ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:17; };
struct BFu15i_BFu16s_BFu1c { unsigned int v1:15; unsigned short v2:16; unsigned char v3:1; };
struct BFu15i_BFu16s_BFu1i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:1; };
struct BFu15i_BFu16s_BFu1ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:1; };
struct BFu15i_BFu16s_BFu1s { unsigned int v1:15; unsigned short v2:16; unsigned short v3:1; };
struct BFu15i_BFu16s_BFu31i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:31; };
struct BFu15i_BFu16s_BFu31ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:31; };
struct BFu15i_BFu16s_BFu32i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:32; };
struct BFu15i_BFu16s_BFu32ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:32; };
struct BFu15i_BFu16s_BFu33 { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:33; };
struct BFu15i_BFu16s_BFu7c { unsigned int v1:15; unsigned short v2:16; unsigned char v3:7; };
struct BFu15i_BFu16s_BFu7i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:7; };
struct BFu15i_BFu16s_BFu7ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:7; };
struct BFu15i_BFu16s_BFu7s { unsigned int v1:15; unsigned short v2:16; unsigned short v3:7; };
struct BFu15i_BFu16s_BFu8c { unsigned int v1:15; unsigned short v2:16; unsigned char v3:8; };
struct BFu15i_BFu16s_BFu8i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:8; };
struct BFu15i_BFu16s_BFu8ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:8; };
struct BFu15i_BFu16s_BFu8s { unsigned int v1:15; unsigned short v2:16; unsigned short v3:8; };
struct BFu15i_BFu16s_BFu9i { unsigned int v1:15; unsigned short v2:16; unsigned int v3:9; };
struct BFu15i_BFu16s_BFu9ll { unsigned int v1:15; unsigned short v2:16; unsigned long long v3:9; };
struct BFu15i_BFu16s_BFu9s { unsigned int v1:15; unsigned short v2:16; unsigned short v3:9; };
struct BFu15i_BFu16s_C { unsigned int v1:15; unsigned short v2:16; char v3; };
struct BFu15i_BFu16s_D { unsigned int v1:15; unsigned short v2:16; double v3; };
struct BFu15i_BFu16s_F { unsigned int v1:15; unsigned short v2:16; float v3; };
struct BFu15i_BFu16s_I { unsigned int v1:15; unsigned short v2:16; int v3; };
struct BFu15i_BFu16s_Ip { unsigned int v1:15; unsigned short v2:16; int * v3; };
struct BFu15i_BFu16s_L { unsigned int v1:15; unsigned short v2:16; long long v3; };
struct BFu15i_BFu16s_S { unsigned int v1:15; unsigned short v2:16; short v3; };
struct BFu15i_BFu16s_Uc { unsigned int v1:15; unsigned short v2:16; unsigned char v3; };
struct BFu15i_BFu16s_Ui { unsigned int v1:15; unsigned short v2:16; unsigned int v3; };
struct BFu15i_BFu16s_Ul { unsigned int v1:15; unsigned short v2:16; unsigned long long v3; };
struct BFu15i_BFu16s_Us { unsigned int v1:15; unsigned short v2:16; unsigned short v3; };
struct BFu15i_BFu16s_Vp { unsigned int v1:15; unsigned short v2:16; void * v3; };
struct BFu15i_BFu17i { unsigned int v1:15; unsigned int v2:17; };
struct BFu15i_BFu17i_BFu15i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:15; };
struct BFu15i_BFu17i_BFu15ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:15; };
struct BFu15i_BFu17i_BFu15s { unsigned int v1:15; unsigned int v2:17; unsigned short v3:15; };
struct BFu15i_BFu17i_BFu16i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:16; };
struct BFu15i_BFu17i_BFu16ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:16; };
struct BFu15i_BFu17i_BFu16s { unsigned int v1:15; unsigned int v2:17; unsigned short v3:16; };
struct BFu15i_BFu17i_BFu17i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:17; };
struct BFu15i_BFu17i_BFu17ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:17; };
struct BFu15i_BFu17i_BFu1c { unsigned int v1:15; unsigned int v2:17; unsigned char v3:1; };
struct BFu15i_BFu17i_BFu1i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:1; };
struct BFu15i_BFu17i_BFu1ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:1; };
struct BFu15i_BFu17i_BFu1s { unsigned int v1:15; unsigned int v2:17; unsigned short v3:1; };
struct BFu15i_BFu17i_BFu31i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:31; };
struct BFu15i_BFu17i_BFu31ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:31; };
struct BFu15i_BFu17i_BFu32i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:32; };
struct BFu15i_BFu17i_BFu32ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:32; };
struct BFu15i_BFu17i_BFu33 { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:33; };
struct BFu15i_BFu17i_BFu7c { unsigned int v1:15; unsigned int v2:17; unsigned char v3:7; };
struct BFu15i_BFu17i_BFu7i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:7; };
struct BFu15i_BFu17i_BFu7ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:7; };
struct BFu15i_BFu17i_BFu7s { unsigned int v1:15; unsigned int v2:17; unsigned short v3:7; };
struct BFu15i_BFu17i_BFu8c { unsigned int v1:15; unsigned int v2:17; unsigned char v3:8; };
struct BFu15i_BFu17i_BFu8i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:8; };
struct BFu15i_BFu17i_BFu8ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:8; };
struct BFu15i_BFu17i_BFu8s { unsigned int v1:15; unsigned int v2:17; unsigned short v3:8; };
struct BFu15i_BFu17i_BFu9i { unsigned int v1:15; unsigned int v2:17; unsigned int v3:9; };
struct BFu15i_BFu17i_BFu9ll { unsigned int v1:15; unsigned int v2:17; unsigned long long v3:9; };
struct BFu15i_BFu17i_BFu9s { unsigned int v1:15; unsigned int v2:17; unsigned short v3:9; };
struct BFu15i_BFu17i_C { unsigned int v1:15; unsigned int v2:17; char v3; };
struct BFu15i_BFu17i_D { unsigned int v1:15; unsigned int v2:17; double v3; };
struct BFu15i_BFu17i_F { unsigned int v1:15; unsigned int v2:17; float v3; };
struct BFu15i_BFu17i_I { unsigned int v1:15; unsigned int v2:17; int v3; };
struct BFu15i_BFu17i_Ip { unsigned int v1:15; unsigned int v2:17; int * v3; };
struct BFu15i_BFu17i_L { unsigned int v1:15; unsigned int v2:17; long long v3; };
struct BFu15i_BFu17i_S { unsigned int v1:15; unsigned int v2:17; short v3; };
struct BFu15i_BFu17i_Uc { unsigned int v1:15; unsigned int v2:17; unsigned char v3; };
struct BFu15i_BFu17i_Ui { unsigned int v1:15; unsigned int v2:17; unsigned int v3; };
struct BFu15i_BFu17i_Ul { unsigned int v1:15; unsigned int v2:17; unsigned long long v3; };
struct BFu15i_BFu17i_Us { unsigned int v1:15; unsigned int v2:17; unsigned short v3; };
struct BFu15i_BFu17i_Vp { unsigned int v1:15; unsigned int v2:17; void * v3; };
struct BFu15i_BFu17ll { unsigned int v1:15; unsigned long long v2:17; };
struct BFu15i_BFu17ll_BFu15i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:15; };
struct BFu15i_BFu17ll_BFu15ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:15; };
struct BFu15i_BFu17ll_BFu15s { unsigned int v1:15; unsigned long long v2:17; unsigned short v3:15; };
struct BFu15i_BFu17ll_BFu16i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:16; };
struct BFu15i_BFu17ll_BFu16ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:16; };
struct BFu15i_BFu17ll_BFu16s { unsigned int v1:15; unsigned long long v2:17; unsigned short v3:16; };
struct BFu15i_BFu17ll_BFu17i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:17; };
struct BFu15i_BFu17ll_BFu17ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:17; };
struct BFu15i_BFu17ll_BFu1c { unsigned int v1:15; unsigned long long v2:17; unsigned char v3:1; };
struct BFu15i_BFu17ll_BFu1i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:1; };
struct BFu15i_BFu17ll_BFu1ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:1; };
struct BFu15i_BFu17ll_BFu1s { unsigned int v1:15; unsigned long long v2:17; unsigned short v3:1; };
struct BFu15i_BFu17ll_BFu31i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:31; };
struct BFu15i_BFu17ll_BFu31ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:31; };
struct BFu15i_BFu17ll_BFu32i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:32; };
struct BFu15i_BFu17ll_BFu32ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:32; };
struct BFu15i_BFu17ll_BFu33 { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:33; };
struct BFu15i_BFu17ll_BFu7c { unsigned int v1:15; unsigned long long v2:17; unsigned char v3:7; };
struct BFu15i_BFu17ll_BFu7i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:7; };
struct BFu15i_BFu17ll_BFu7ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:7; };
struct BFu15i_BFu17ll_BFu7s { unsigned int v1:15; unsigned long long v2:17; unsigned short v3:7; };
struct BFu15i_BFu17ll_BFu8c { unsigned int v1:15; unsigned long long v2:17; unsigned char v3:8; };
struct BFu15i_BFu17ll_BFu8i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:8; };
struct BFu15i_BFu17ll_BFu8ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:8; };
struct BFu15i_BFu17ll_BFu8s { unsigned int v1:15; unsigned long long v2:17; unsigned short v3:8; };
struct BFu15i_BFu17ll_BFu9i { unsigned int v1:15; unsigned long long v2:17; unsigned int v3:9; };
struct BFu15i_BFu17ll_BFu9ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3:9; };
struct BFu15i_BFu17ll_BFu9s { unsigned int v1:15; unsigned long long v2:17; unsigned short v3:9; };
struct BFu15i_BFu17ll_C { unsigned int v1:15; unsigned long long v2:17; char v3; };
struct BFu15i_BFu17ll_D { unsigned int v1:15; unsigned long long v2:17; double v3; };
struct BFu15i_BFu17ll_F { unsigned int v1:15; unsigned long long v2:17; float v3; };
struct BFu15i_BFu17ll_I { unsigned int v1:15; unsigned long long v2:17; int v3; };
struct BFu15i_BFu17ll_Ip { unsigned int v1:15; unsigned long long v2:17; int * v3; };
struct BFu15i_BFu17ll_L { unsigned int v1:15; unsigned long long v2:17; long long v3; };
struct BFu15i_BFu17ll_S { unsigned int v1:15; unsigned long long v2:17; short v3; };
struct BFu15i_BFu17ll_Uc { unsigned int v1:15; unsigned long long v2:17; unsigned char v3; };
struct BFu15i_BFu17ll_Ui { unsigned int v1:15; unsigned long long v2:17; unsigned int v3; };
struct BFu15i_BFu17ll_Ul { unsigned int v1:15; unsigned long long v2:17; unsigned long long v3; };
struct BFu15i_BFu17ll_Us { unsigned int v1:15; unsigned long long v2:17; unsigned short v3; };
struct BFu15i_BFu17ll_Vp { unsigned int v1:15; unsigned long long v2:17; void * v3; };
struct BFu15i_BFu1c { unsigned int v1:15; unsigned char v2:1; };
struct BFu15i_BFu1c_BFu15i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:15; };
struct BFu15i_BFu1c_BFu15ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:15; };
struct BFu15i_BFu1c_BFu15s { unsigned int v1:15; unsigned char v2:1; unsigned short v3:15; };
struct BFu15i_BFu1c_BFu16i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:16; };
struct BFu15i_BFu1c_BFu16ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:16; };
struct BFu15i_BFu1c_BFu16s { unsigned int v1:15; unsigned char v2:1; unsigned short v3:16; };
struct BFu15i_BFu1c_BFu17i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:17; };
struct BFu15i_BFu1c_BFu17ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:17; };
struct BFu15i_BFu1c_BFu1c { unsigned int v1:15; unsigned char v2:1; unsigned char v3:1; };
struct BFu15i_BFu1c_BFu1i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:1; };
struct BFu15i_BFu1c_BFu1ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:1; };
struct BFu15i_BFu1c_BFu1s { unsigned int v1:15; unsigned char v2:1; unsigned short v3:1; };
struct BFu15i_BFu1c_BFu31i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:31; };
struct BFu15i_BFu1c_BFu31ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:31; };
struct BFu15i_BFu1c_BFu32i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:32; };
struct BFu15i_BFu1c_BFu32ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:32; };
struct BFu15i_BFu1c_BFu33 { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:33; };
struct BFu15i_BFu1c_BFu7c { unsigned int v1:15; unsigned char v2:1; unsigned char v3:7; };
struct BFu15i_BFu1c_BFu7i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:7; };
struct BFu15i_BFu1c_BFu7ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:7; };
struct BFu15i_BFu1c_BFu7s { unsigned int v1:15; unsigned char v2:1; unsigned short v3:7; };
struct BFu15i_BFu1c_BFu8c { unsigned int v1:15; unsigned char v2:1; unsigned char v3:8; };
struct BFu15i_BFu1c_BFu8i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:8; };
struct BFu15i_BFu1c_BFu8ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:8; };
struct BFu15i_BFu1c_BFu8s { unsigned int v1:15; unsigned char v2:1; unsigned short v3:8; };
struct BFu15i_BFu1c_BFu9i { unsigned int v1:15; unsigned char v2:1; unsigned int v3:9; };
struct BFu15i_BFu1c_BFu9ll { unsigned int v1:15; unsigned char v2:1; unsigned long long v3:9; };
struct BFu15i_BFu1c_BFu9s { unsigned int v1:15; unsigned char v2:1; unsigned short v3:9; };
struct BFu15i_BFu1c_C { unsigned int v1:15; unsigned char v2:1; char v3; };
struct BFu15i_BFu1c_D { unsigned int v1:15; unsigned char v2:1; double v3; };
struct BFu15i_BFu1c_F { unsigned int v1:15; unsigned char v2:1; float v3; };
struct BFu15i_BFu1c_I { unsigned int v1:15; unsigned char v2:1; int v3; };
struct BFu15i_BFu1c_Ip { unsigned int v1:15; unsigned char v2:1; int * v3; };
struct BFu15i_BFu1c_L { unsigned int v1:15; unsigned char v2:1; long long v3; };
struct BFu15i_BFu1c_S { unsigned int v1:15; unsigned char v2:1; short v3; };
struct BFu15i_BFu1c_Uc { unsigned int v1:15; unsigned char v2:1; unsigned char v3; };
struct BFu15i_BFu1c_Ui { unsigned int v1:15; unsigned char v2:1; unsigned int v3; };
struct BFu15i_BFu1c_Ul { unsigned int v1:15; unsigned char v2:1; unsigned long long v3; };
struct BFu15i_BFu1c_Us { unsigned int v1:15; unsigned char v2:1; unsigned short v3; };
struct BFu15i_BFu1c_Vp { unsigned int v1:15; unsigned char v2:1; void * v3; };
struct BFu15i_BFu1i { unsigned int v1:15; unsigned int v2:1; };
struct BFu15i_BFu1i_BFu15i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:15; };
struct BFu15i_BFu1i_BFu15ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:15; };
struct BFu15i_BFu1i_BFu15s { unsigned int v1:15; unsigned int v2:1; unsigned short v3:15; };
struct BFu15i_BFu1i_BFu16i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:16; };
struct BFu15i_BFu1i_BFu16ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:16; };
struct BFu15i_BFu1i_BFu16s { unsigned int v1:15; unsigned int v2:1; unsigned short v3:16; };
struct BFu15i_BFu1i_BFu17i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:17; };
struct BFu15i_BFu1i_BFu17ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:17; };
struct BFu15i_BFu1i_BFu1c { unsigned int v1:15; unsigned int v2:1; unsigned char v3:1; };
struct BFu15i_BFu1i_BFu1i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:1; };
struct BFu15i_BFu1i_BFu1ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:1; };
struct BFu15i_BFu1i_BFu1s { unsigned int v1:15; unsigned int v2:1; unsigned short v3:1; };
struct BFu15i_BFu1i_BFu31i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:31; };
struct BFu15i_BFu1i_BFu31ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:31; };
struct BFu15i_BFu1i_BFu32i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:32; };
struct BFu15i_BFu1i_BFu32ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:32; };
struct BFu15i_BFu1i_BFu33 { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:33; };
struct BFu15i_BFu1i_BFu7c { unsigned int v1:15; unsigned int v2:1; unsigned char v3:7; };
struct BFu15i_BFu1i_BFu7i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:7; };
struct BFu15i_BFu1i_BFu7ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:7; };
struct BFu15i_BFu1i_BFu7s { unsigned int v1:15; unsigned int v2:1; unsigned short v3:7; };
struct BFu15i_BFu1i_BFu8c { unsigned int v1:15; unsigned int v2:1; unsigned char v3:8; };
struct BFu15i_BFu1i_BFu8i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:8; };
struct BFu15i_BFu1i_BFu8ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:8; };
struct BFu15i_BFu1i_BFu8s { unsigned int v1:15; unsigned int v2:1; unsigned short v3:8; };
struct BFu15i_BFu1i_BFu9i { unsigned int v1:15; unsigned int v2:1; unsigned int v3:9; };
struct BFu15i_BFu1i_BFu9ll { unsigned int v1:15; unsigned int v2:1; unsigned long long v3:9; };
struct BFu15i_BFu1i_BFu9s { unsigned int v1:15; unsigned int v2:1; unsigned short v3:9; };
struct BFu15i_BFu1i_C { unsigned int v1:15; unsigned int v2:1; char v3; };
struct BFu15i_BFu1i_D { unsigned int v1:15; unsigned int v2:1; double v3; };
struct BFu15i_BFu1i_F { unsigned int v1:15; unsigned int v2:1; float v3; };
struct BFu15i_BFu1i_I { unsigned int v1:15; unsigned int v2:1; int v3; };
struct BFu15i_BFu1i_Ip { unsigned int v1:15; unsigned int v2:1; int * v3; };
struct BFu15i_BFu1i_L { unsigned int v1:15; unsigned int v2:1; long long v3; };
struct BFu15i_BFu1i_S { unsigned int v1:15; unsigned int v2:1; short v3; };
struct BFu15i_BFu1i_Uc { unsigned int v1:15; unsigned int v2:1; unsigned char v3; };
struct BFu15i_BFu1i_Ui { unsigned int v1:15; unsigned int v2:1; unsigned int v3; };
struct BFu15i_BFu1i_Ul { unsigned int v1:15; unsigned int v2:1; unsigned long long v3; };
struct BFu15i_BFu1i_Us { unsigned int v1:15; unsigned int v2:1; unsigned short v3; };
struct BFu15i_BFu1i_Vp { unsigned int v1:15; unsigned int v2:1; void * v3; };
struct BFu15i_BFu1ll { unsigned int v1:15; unsigned long long v2:1; };
struct BFu15i_BFu1ll_BFu15i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:15; };
struct BFu15i_BFu1ll_BFu15ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:15; };
struct BFu15i_BFu1ll_BFu15s { unsigned int v1:15; unsigned long long v2:1; unsigned short v3:15; };
struct BFu15i_BFu1ll_BFu16i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:16; };
struct BFu15i_BFu1ll_BFu16ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:16; };
struct BFu15i_BFu1ll_BFu16s { unsigned int v1:15; unsigned long long v2:1; unsigned short v3:16; };
struct BFu15i_BFu1ll_BFu17i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:17; };
struct BFu15i_BFu1ll_BFu17ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:17; };
struct BFu15i_BFu1ll_BFu1c { unsigned int v1:15; unsigned long long v2:1; unsigned char v3:1; };
struct BFu15i_BFu1ll_BFu1i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:1; };
struct BFu15i_BFu1ll_BFu1ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:1; };
struct BFu15i_BFu1ll_BFu1s { unsigned int v1:15; unsigned long long v2:1; unsigned short v3:1; };
struct BFu15i_BFu1ll_BFu31i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:31; };
struct BFu15i_BFu1ll_BFu31ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:31; };
struct BFu15i_BFu1ll_BFu32i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:32; };
struct BFu15i_BFu1ll_BFu32ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:32; };
struct BFu15i_BFu1ll_BFu33 { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:33; };
struct BFu15i_BFu1ll_BFu7c { unsigned int v1:15; unsigned long long v2:1; unsigned char v3:7; };
struct BFu15i_BFu1ll_BFu7i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:7; };
struct BFu15i_BFu1ll_BFu7ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:7; };
struct BFu15i_BFu1ll_BFu7s { unsigned int v1:15; unsigned long long v2:1; unsigned short v3:7; };
struct BFu15i_BFu1ll_BFu8c { unsigned int v1:15; unsigned long long v2:1; unsigned char v3:8; };
struct BFu15i_BFu1ll_BFu8i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:8; };
struct BFu15i_BFu1ll_BFu8ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:8; };
struct BFu15i_BFu1ll_BFu8s { unsigned int v1:15; unsigned long long v2:1; unsigned short v3:8; };
struct BFu15i_BFu1ll_BFu9i { unsigned int v1:15; unsigned long long v2:1; unsigned int v3:9; };
struct BFu15i_BFu1ll_BFu9ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3:9; };
struct BFu15i_BFu1ll_BFu9s { unsigned int v1:15; unsigned long long v2:1; unsigned short v3:9; };
struct BFu15i_BFu1ll_C { unsigned int v1:15; unsigned long long v2:1; char v3; };
struct BFu15i_BFu1ll_D { unsigned int v1:15; unsigned long long v2:1; double v3; };
struct BFu15i_BFu1ll_F { unsigned int v1:15; unsigned long long v2:1; float v3; };
struct BFu15i_BFu1ll_I { unsigned int v1:15; unsigned long long v2:1; int v3; };
struct BFu15i_BFu1ll_Ip { unsigned int v1:15; unsigned long long v2:1; int * v3; };
struct BFu15i_BFu1ll_L { unsigned int v1:15; unsigned long long v2:1; long long v3; };
struct BFu15i_BFu1ll_S { unsigned int v1:15; unsigned long long v2:1; short v3; };
struct BFu15i_BFu1ll_Uc { unsigned int v1:15; unsigned long long v2:1; unsigned char v3; };
struct BFu15i_BFu1ll_Ui { unsigned int v1:15; unsigned long long v2:1; unsigned int v3; };
struct BFu15i_BFu1ll_Ul { unsigned int v1:15; unsigned long long v2:1; unsigned long long v3; };
struct BFu15i_BFu1ll_Us { unsigned int v1:15; unsigned long long v2:1; unsigned short v3; };
struct BFu15i_BFu1ll_Vp { unsigned int v1:15; unsigned long long v2:1; void * v3; };
struct BFu15i_BFu1s { unsigned int v1:15; unsigned short v2:1; };
struct BFu15i_BFu1s_BFu15i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:15; };
struct BFu15i_BFu1s_BFu15ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:15; };
struct BFu15i_BFu1s_BFu15s { unsigned int v1:15; unsigned short v2:1; unsigned short v3:15; };
struct BFu15i_BFu1s_BFu16i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:16; };
struct BFu15i_BFu1s_BFu16ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:16; };
struct BFu15i_BFu1s_BFu16s { unsigned int v1:15; unsigned short v2:1; unsigned short v3:16; };
struct BFu15i_BFu1s_BFu17i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:17; };
struct BFu15i_BFu1s_BFu17ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:17; };
struct BFu15i_BFu1s_BFu1c { unsigned int v1:15; unsigned short v2:1; unsigned char v3:1; };
struct BFu15i_BFu1s_BFu1i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:1; };
struct BFu15i_BFu1s_BFu1ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:1; };
struct BFu15i_BFu1s_BFu1s { unsigned int v1:15; unsigned short v2:1; unsigned short v3:1; };
struct BFu15i_BFu1s_BFu31i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:31; };
struct BFu15i_BFu1s_BFu31ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:31; };
struct BFu15i_BFu1s_BFu32i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:32; };
struct BFu15i_BFu1s_BFu32ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:32; };
struct BFu15i_BFu1s_BFu33 { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:33; };
struct BFu15i_BFu1s_BFu7c { unsigned int v1:15; unsigned short v2:1; unsigned char v3:7; };
struct BFu15i_BFu1s_BFu7i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:7; };
struct BFu15i_BFu1s_BFu7ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:7; };
struct BFu15i_BFu1s_BFu7s { unsigned int v1:15; unsigned short v2:1; unsigned short v3:7; };
struct BFu15i_BFu1s_BFu8c { unsigned int v1:15; unsigned short v2:1; unsigned char v3:8; };
struct BFu15i_BFu1s_BFu8i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:8; };
struct BFu15i_BFu1s_BFu8ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:8; };
struct BFu15i_BFu1s_BFu8s { unsigned int v1:15; unsigned short v2:1; unsigned short v3:8; };
struct BFu15i_BFu1s_BFu9i { unsigned int v1:15; unsigned short v2:1; unsigned int v3:9; };
struct BFu15i_BFu1s_BFu9ll { unsigned int v1:15; unsigned short v2:1; unsigned long long v3:9; };
struct BFu15i_BFu1s_BFu9s { unsigned int v1:15; unsigned short v2:1; unsigned short v3:9; };
struct BFu15i_BFu1s_C { unsigned int v1:15; unsigned short v2:1; char v3; };
struct BFu15i_BFu1s_D { unsigned int v1:15; unsigned short v2:1; double v3; };
struct BFu15i_BFu1s_F { unsigned int v1:15; unsigned short v2:1; float v3; };
struct BFu15i_BFu1s_I { unsigned int v1:15; unsigned short v2:1; int v3; };
struct BFu15i_BFu1s_Ip { unsigned int v1:15; unsigned short v2:1; int * v3; };
struct BFu15i_BFu1s_L { unsigned int v1:15; unsigned short v2:1; long long v3; };
struct BFu15i_BFu1s_S { unsigned int v1:15; unsigned short v2:1; short v3; };
struct BFu15i_BFu1s_Uc { unsigned int v1:15; unsigned short v2:1; unsigned char v3; };
struct BFu15i_BFu1s_Ui { unsigned int v1:15; unsigned short v2:1; unsigned int v3; };
struct BFu15i_BFu1s_Ul { unsigned int v1:15; unsigned short v2:1; unsigned long long v3; };
struct BFu15i_BFu1s_Us { unsigned int v1:15; unsigned short v2:1; unsigned short v3; };
struct BFu15i_BFu1s_Vp { unsigned int v1:15; unsigned short v2:1; void * v3; };
struct BFu15i_BFu31i { unsigned int v1:15; unsigned int v2:31; };
struct BFu15i_BFu31i_BFu15i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:15; };
struct BFu15i_BFu31i_BFu15ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:15; };
struct BFu15i_BFu31i_BFu15s { unsigned int v1:15; unsigned int v2:31; unsigned short v3:15; };
struct BFu15i_BFu31i_BFu16i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:16; };
struct BFu15i_BFu31i_BFu16ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:16; };
struct BFu15i_BFu31i_BFu16s { unsigned int v1:15; unsigned int v2:31; unsigned short v3:16; };
struct BFu15i_BFu31i_BFu17i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:17; };
struct BFu15i_BFu31i_BFu17ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:17; };
struct BFu15i_BFu31i_BFu1c { unsigned int v1:15; unsigned int v2:31; unsigned char v3:1; };
struct BFu15i_BFu31i_BFu1i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:1; };
struct BFu15i_BFu31i_BFu1ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:1; };
struct BFu15i_BFu31i_BFu1s { unsigned int v1:15; unsigned int v2:31; unsigned short v3:1; };
struct BFu15i_BFu31i_BFu31i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:31; };
struct BFu15i_BFu31i_BFu31ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:31; };
struct BFu15i_BFu31i_BFu32i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:32; };
struct BFu15i_BFu31i_BFu32ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:32; };
struct BFu15i_BFu31i_BFu33 { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:33; };
struct BFu15i_BFu31i_BFu7c { unsigned int v1:15; unsigned int v2:31; unsigned char v3:7; };
struct BFu15i_BFu31i_BFu7i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:7; };
struct BFu15i_BFu31i_BFu7ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:7; };
struct BFu15i_BFu31i_BFu7s { unsigned int v1:15; unsigned int v2:31; unsigned short v3:7; };
struct BFu15i_BFu31i_BFu8c { unsigned int v1:15; unsigned int v2:31; unsigned char v3:8; };
struct BFu15i_BFu31i_BFu8i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:8; };
struct BFu15i_BFu31i_BFu8ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:8; };
struct BFu15i_BFu31i_BFu8s { unsigned int v1:15; unsigned int v2:31; unsigned short v3:8; };
struct BFu15i_BFu31i_BFu9i { unsigned int v1:15; unsigned int v2:31; unsigned int v3:9; };
struct BFu15i_BFu31i_BFu9ll { unsigned int v1:15; unsigned int v2:31; unsigned long long v3:9; };
struct BFu15i_BFu31i_BFu9s { unsigned int v1:15; unsigned int v2:31; unsigned short v3:9; };
struct BFu15i_BFu31i_C { unsigned int v1:15; unsigned int v2:31; char v3; };
struct BFu15i_BFu31i_D { unsigned int v1:15; unsigned int v2:31; double v3; };
struct BFu15i_BFu31i_F { unsigned int v1:15; unsigned int v2:31; float v3; };
struct BFu15i_BFu31i_I { unsigned int v1:15; unsigned int v2:31; int v3; };
struct BFu15i_BFu31i_Ip { unsigned int v1:15; unsigned int v2:31; int * v3; };
struct BFu15i_BFu31i_L { unsigned int v1:15; unsigned int v2:31; long long v3; };
struct BFu15i_BFu31i_S { unsigned int v1:15; unsigned int v2:31; short v3; };
struct BFu15i_BFu31i_Uc { unsigned int v1:15; unsigned int v2:31; unsigned char v3; };
struct BFu15i_BFu31i_Ui { unsigned int v1:15; unsigned int v2:31; unsigned int v3; };
struct BFu15i_BFu31i_Ul { unsigned int v1:15; unsigned int v2:31; unsigned long long v3; };
struct BFu15i_BFu31i_Us { unsigned int v1:15; unsigned int v2:31; unsigned short v3; };
struct BFu15i_BFu31i_Vp { unsigned int v1:15; unsigned int v2:31; void * v3; };
struct BFu15i_BFu31ll { unsigned int v1:15; unsigned long long v2:31; };
struct BFu15i_BFu31ll_BFu15i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:15; };
struct BFu15i_BFu31ll_BFu15ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:15; };
struct BFu15i_BFu31ll_BFu15s { unsigned int v1:15; unsigned long long v2:31; unsigned short v3:15; };
struct BFu15i_BFu31ll_BFu16i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:16; };
struct BFu15i_BFu31ll_BFu16ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:16; };
struct BFu15i_BFu31ll_BFu16s { unsigned int v1:15; unsigned long long v2:31; unsigned short v3:16; };
struct BFu15i_BFu31ll_BFu17i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:17; };
struct BFu15i_BFu31ll_BFu17ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:17; };
struct BFu15i_BFu31ll_BFu1c { unsigned int v1:15; unsigned long long v2:31; unsigned char v3:1; };
struct BFu15i_BFu31ll_BFu1i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:1; };
struct BFu15i_BFu31ll_BFu1ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:1; };
struct BFu15i_BFu31ll_BFu1s { unsigned int v1:15; unsigned long long v2:31; unsigned short v3:1; };
struct BFu15i_BFu31ll_BFu31i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:31; };
struct BFu15i_BFu31ll_BFu31ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:31; };
struct BFu15i_BFu31ll_BFu32i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:32; };
struct BFu15i_BFu31ll_BFu32ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:32; };
struct BFu15i_BFu31ll_BFu33 { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:33; };
struct BFu15i_BFu31ll_BFu7c { unsigned int v1:15; unsigned long long v2:31; unsigned char v3:7; };
struct BFu15i_BFu31ll_BFu7i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:7; };
struct BFu15i_BFu31ll_BFu7ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:7; };
struct BFu15i_BFu31ll_BFu7s { unsigned int v1:15; unsigned long long v2:31; unsigned short v3:7; };
struct BFu15i_BFu31ll_BFu8c { unsigned int v1:15; unsigned long long v2:31; unsigned char v3:8; };
struct BFu15i_BFu31ll_BFu8i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:8; };
struct BFu15i_BFu31ll_BFu8ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:8; };
struct BFu15i_BFu31ll_BFu8s { unsigned int v1:15; unsigned long long v2:31; unsigned short v3:8; };
struct BFu15i_BFu31ll_BFu9i { unsigned int v1:15; unsigned long long v2:31; unsigned int v3:9; };
struct BFu15i_BFu31ll_BFu9ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3:9; };
struct BFu15i_BFu31ll_BFu9s { unsigned int v1:15; unsigned long long v2:31; unsigned short v3:9; };
struct BFu15i_BFu31ll_C { unsigned int v1:15; unsigned long long v2:31; char v3; };
struct BFu15i_BFu31ll_D { unsigned int v1:15; unsigned long long v2:31; double v3; };
struct BFu15i_BFu31ll_F { unsigned int v1:15; unsigned long long v2:31; float v3; };
struct BFu15i_BFu31ll_I { unsigned int v1:15; unsigned long long v2:31; int v3; };
struct BFu15i_BFu31ll_Ip { unsigned int v1:15; unsigned long long v2:31; int * v3; };
struct BFu15i_BFu31ll_L { unsigned int v1:15; unsigned long long v2:31; long long v3; };
struct BFu15i_BFu31ll_S { unsigned int v1:15; unsigned long long v2:31; short v3; };
struct BFu15i_BFu31ll_Uc { unsigned int v1:15; unsigned long long v2:31; unsigned char v3; };
struct BFu15i_BFu31ll_Ui { unsigned int v1:15; unsigned long long v2:31; unsigned int v3; };
struct BFu15i_BFu31ll_Ul { unsigned int v1:15; unsigned long long v2:31; unsigned long long v3; };
struct BFu15i_BFu31ll_Us { unsigned int v1:15; unsigned long long v2:31; unsigned short v3; };
struct BFu15i_BFu31ll_Vp { unsigned int v1:15; unsigned long long v2:31; void * v3; };
struct BFu15i_BFu32i { unsigned int v1:15; unsigned int v2:32; };
struct BFu15i_BFu32i_BFu15i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:15; };
struct BFu15i_BFu32i_BFu15ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:15; };
struct BFu15i_BFu32i_BFu15s { unsigned int v1:15; unsigned int v2:32; unsigned short v3:15; };
struct BFu15i_BFu32i_BFu16i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:16; };
struct BFu15i_BFu32i_BFu16ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:16; };
struct BFu15i_BFu32i_BFu16s { unsigned int v1:15; unsigned int v2:32; unsigned short v3:16; };
struct BFu15i_BFu32i_BFu17i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:17; };
struct BFu15i_BFu32i_BFu17ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:17; };
struct BFu15i_BFu32i_BFu1c { unsigned int v1:15; unsigned int v2:32; unsigned char v3:1; };
struct BFu15i_BFu32i_BFu1i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:1; };
struct BFu15i_BFu32i_BFu1ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:1; };
struct BFu15i_BFu32i_BFu1s { unsigned int v1:15; unsigned int v2:32; unsigned short v3:1; };
struct BFu15i_BFu32i_BFu31i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:31; };
struct BFu15i_BFu32i_BFu31ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:31; };
struct BFu15i_BFu32i_BFu32i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:32; };
struct BFu15i_BFu32i_BFu32ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:32; };
struct BFu15i_BFu32i_BFu33 { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:33; };
struct BFu15i_BFu32i_BFu7c { unsigned int v1:15; unsigned int v2:32; unsigned char v3:7; };
struct BFu15i_BFu32i_BFu7i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:7; };
struct BFu15i_BFu32i_BFu7ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:7; };
struct BFu15i_BFu32i_BFu7s { unsigned int v1:15; unsigned int v2:32; unsigned short v3:7; };
struct BFu15i_BFu32i_BFu8c { unsigned int v1:15; unsigned int v2:32; unsigned char v3:8; };
struct BFu15i_BFu32i_BFu8i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:8; };
struct BFu15i_BFu32i_BFu8ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:8; };
struct BFu15i_BFu32i_BFu8s { unsigned int v1:15; unsigned int v2:32; unsigned short v3:8; };
struct BFu15i_BFu32i_BFu9i { unsigned int v1:15; unsigned int v2:32; unsigned int v3:9; };
struct BFu15i_BFu32i_BFu9ll { unsigned int v1:15; unsigned int v2:32; unsigned long long v3:9; };
struct BFu15i_BFu32i_BFu9s { unsigned int v1:15; unsigned int v2:32; unsigned short v3:9; };
struct BFu15i_BFu32i_C { unsigned int v1:15; unsigned int v2:32; char v3; };
struct BFu15i_BFu32i_D { unsigned int v1:15; unsigned int v2:32; double v3; };
struct BFu15i_BFu32i_F { unsigned int v1:15; unsigned int v2:32; float v3; };
struct BFu15i_BFu32i_I { unsigned int v1:15; unsigned int v2:32; int v3; };
struct BFu15i_BFu32i_Ip { unsigned int v1:15; unsigned int v2:32; int * v3; };
struct BFu15i_BFu32i_L { unsigned int v1:15; unsigned int v2:32; long long v3; };
struct BFu15i_BFu32i_S { unsigned int v1:15; unsigned int v2:32; short v3; };
struct BFu15i_BFu32i_Uc { unsigned int v1:15; unsigned int v2:32; unsigned char v3; };
struct BFu15i_BFu32i_Ui { unsigned int v1:15; unsigned int v2:32; unsigned int v3; };
struct BFu15i_BFu32i_Ul { unsigned int v1:15; unsigned int v2:32; unsigned long long v3; };
struct BFu15i_BFu32i_Us { unsigned int v1:15; unsigned int v2:32; unsigned short v3; };
struct BFu15i_BFu32i_Vp { unsigned int v1:15; unsigned int v2:32; void * v3; };
struct BFu15i_BFu32ll { unsigned int v1:15; unsigned long long v2:32; };
struct BFu15i_BFu32ll_BFu15i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:15; };
struct BFu15i_BFu32ll_BFu15ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:15; };
struct BFu15i_BFu32ll_BFu15s { unsigned int v1:15; unsigned long long v2:32; unsigned short v3:15; };
struct BFu15i_BFu32ll_BFu16i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:16; };
struct BFu15i_BFu32ll_BFu16ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:16; };
struct BFu15i_BFu32ll_BFu16s { unsigned int v1:15; unsigned long long v2:32; unsigned short v3:16; };
struct BFu15i_BFu32ll_BFu17i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:17; };
struct BFu15i_BFu32ll_BFu17ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:17; };
struct BFu15i_BFu32ll_BFu1c { unsigned int v1:15; unsigned long long v2:32; unsigned char v3:1; };
struct BFu15i_BFu32ll_BFu1i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:1; };
struct BFu15i_BFu32ll_BFu1ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:1; };
struct BFu15i_BFu32ll_BFu1s { unsigned int v1:15; unsigned long long v2:32; unsigned short v3:1; };
struct BFu15i_BFu32ll_BFu31i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:31; };
struct BFu15i_BFu32ll_BFu31ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:31; };
struct BFu15i_BFu32ll_BFu32i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:32; };
struct BFu15i_BFu32ll_BFu32ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:32; };
struct BFu15i_BFu32ll_BFu33 { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:33; };
struct BFu15i_BFu32ll_BFu7c { unsigned int v1:15; unsigned long long v2:32; unsigned char v3:7; };
struct BFu15i_BFu32ll_BFu7i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:7; };
struct BFu15i_BFu32ll_BFu7ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:7; };
struct BFu15i_BFu32ll_BFu7s { unsigned int v1:15; unsigned long long v2:32; unsigned short v3:7; };
struct BFu15i_BFu32ll_BFu8c { unsigned int v1:15; unsigned long long v2:32; unsigned char v3:8; };
struct BFu15i_BFu32ll_BFu8i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:8; };
struct BFu15i_BFu32ll_BFu8ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:8; };
struct BFu15i_BFu32ll_BFu8s { unsigned int v1:15; unsigned long long v2:32; unsigned short v3:8; };
struct BFu15i_BFu32ll_BFu9i { unsigned int v1:15; unsigned long long v2:32; unsigned int v3:9; };
struct BFu15i_BFu32ll_BFu9ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3:9; };
struct BFu15i_BFu32ll_BFu9s { unsigned int v1:15; unsigned long long v2:32; unsigned short v3:9; };
struct BFu15i_BFu32ll_C { unsigned int v1:15; unsigned long long v2:32; char v3; };
struct BFu15i_BFu32ll_D { unsigned int v1:15; unsigned long long v2:32; double v3; };
struct BFu15i_BFu32ll_F { unsigned int v1:15; unsigned long long v2:32; float v3; };
struct BFu15i_BFu32ll_I { unsigned int v1:15; unsigned long long v2:32; int v3; };
struct BFu15i_BFu32ll_Ip { unsigned int v1:15; unsigned long long v2:32; int * v3; };
struct BFu15i_BFu32ll_L { unsigned int v1:15; unsigned long long v2:32; long long v3; };
struct BFu15i_BFu32ll_S { unsigned int v1:15; unsigned long long v2:32; short v3; };
struct BFu15i_BFu32ll_Uc { unsigned int v1:15; unsigned long long v2:32; unsigned char v3; };
struct BFu15i_BFu32ll_Ui { unsigned int v1:15; unsigned long long v2:32; unsigned int v3; };
struct BFu15i_BFu32ll_Ul { unsigned int v1:15; unsigned long long v2:32; unsigned long long v3; };
struct BFu15i_BFu32ll_Us { unsigned int v1:15; unsigned long long v2:32; unsigned short v3; };
struct BFu15i_BFu32ll_Vp { unsigned int v1:15; unsigned long long v2:32; void * v3; };
struct BFu15i_BFu33 { unsigned int v1:15; unsigned long long v2:33; };
struct BFu15i_BFu33_BFu15i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:15; };
struct BFu15i_BFu33_BFu15ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:15; };
struct BFu15i_BFu33_BFu15s { unsigned int v1:15; unsigned long long v2:33; unsigned short v3:15; };
struct BFu15i_BFu33_BFu16i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:16; };
struct BFu15i_BFu33_BFu16ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:16; };
struct BFu15i_BFu33_BFu16s { unsigned int v1:15; unsigned long long v2:33; unsigned short v3:16; };
struct BFu15i_BFu33_BFu17i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:17; };
struct BFu15i_BFu33_BFu17ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:17; };
struct BFu15i_BFu33_BFu1c { unsigned int v1:15; unsigned long long v2:33; unsigned char v3:1; };
struct BFu15i_BFu33_BFu1i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:1; };
struct BFu15i_BFu33_BFu1ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:1; };
struct BFu15i_BFu33_BFu1s { unsigned int v1:15; unsigned long long v2:33; unsigned short v3:1; };
struct BFu15i_BFu33_BFu31i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:31; };
struct BFu15i_BFu33_BFu31ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:31; };
struct BFu15i_BFu33_BFu32i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:32; };
struct BFu15i_BFu33_BFu32ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:32; };
struct BFu15i_BFu33_BFu33 { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:33; };
struct BFu15i_BFu33_BFu7c { unsigned int v1:15; unsigned long long v2:33; unsigned char v3:7; };
struct BFu15i_BFu33_BFu7i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:7; };
struct BFu15i_BFu33_BFu7ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:7; };
struct BFu15i_BFu33_BFu7s { unsigned int v1:15; unsigned long long v2:33; unsigned short v3:7; };
struct BFu15i_BFu33_BFu8c { unsigned int v1:15; unsigned long long v2:33; unsigned char v3:8; };
struct BFu15i_BFu33_BFu8i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:8; };
struct BFu15i_BFu33_BFu8ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:8; };
struct BFu15i_BFu33_BFu8s { unsigned int v1:15; unsigned long long v2:33; unsigned short v3:8; };
struct BFu15i_BFu33_BFu9i { unsigned int v1:15; unsigned long long v2:33; unsigned int v3:9; };
struct BFu15i_BFu33_BFu9ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3:9; };
struct BFu15i_BFu33_BFu9s { unsigned int v1:15; unsigned long long v2:33; unsigned short v3:9; };
struct BFu15i_BFu33_C { unsigned int v1:15; unsigned long long v2:33; char v3; };
struct BFu15i_BFu33_D { unsigned int v1:15; unsigned long long v2:33; double v3; };
struct BFu15i_BFu33_F { unsigned int v1:15; unsigned long long v2:33; float v3; };
struct BFu15i_BFu33_I { unsigned int v1:15; unsigned long long v2:33; int v3; };
struct BFu15i_BFu33_Ip { unsigned int v1:15; unsigned long long v2:33; int * v3; };
struct BFu15i_BFu33_L { unsigned int v1:15; unsigned long long v2:33; long long v3; };
struct BFu15i_BFu33_S { unsigned int v1:15; unsigned long long v2:33; short v3; };
struct BFu15i_BFu33_Uc { unsigned int v1:15; unsigned long long v2:33; unsigned char v3; };
struct BFu15i_BFu33_Ui { unsigned int v1:15; unsigned long long v2:33; unsigned int v3; };
struct BFu15i_BFu33_Ul { unsigned int v1:15; unsigned long long v2:33; unsigned long long v3; };
struct BFu15i_BFu33_Us { unsigned int v1:15; unsigned long long v2:33; unsigned short v3; };
struct BFu15i_BFu33_Vp { unsigned int v1:15; unsigned long long v2:33; void * v3; };
struct BFu15i_BFu7c { unsigned int v1:15; unsigned char v2:7; };
struct BFu15i_BFu7c_BFu15i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:15; };
struct BFu15i_BFu7c_BFu15ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:15; };
struct BFu15i_BFu7c_BFu15s { unsigned int v1:15; unsigned char v2:7; unsigned short v3:15; };
struct BFu15i_BFu7c_BFu16i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:16; };
struct BFu15i_BFu7c_BFu16ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:16; };
struct BFu15i_BFu7c_BFu16s { unsigned int v1:15; unsigned char v2:7; unsigned short v3:16; };
struct BFu15i_BFu7c_BFu17i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:17; };
struct BFu15i_BFu7c_BFu17ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:17; };
struct BFu15i_BFu7c_BFu1c { unsigned int v1:15; unsigned char v2:7; unsigned char v3:1; };
struct BFu15i_BFu7c_BFu1i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:1; };
struct BFu15i_BFu7c_BFu1ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:1; };
struct BFu15i_BFu7c_BFu1s { unsigned int v1:15; unsigned char v2:7; unsigned short v3:1; };
struct BFu15i_BFu7c_BFu31i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:31; };
struct BFu15i_BFu7c_BFu31ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:31; };
struct BFu15i_BFu7c_BFu32i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:32; };
struct BFu15i_BFu7c_BFu32ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:32; };
struct BFu15i_BFu7c_BFu33 { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:33; };
struct BFu15i_BFu7c_BFu7c { unsigned int v1:15; unsigned char v2:7; unsigned char v3:7; };
struct BFu15i_BFu7c_BFu7i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:7; };
struct BFu15i_BFu7c_BFu7ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:7; };
struct BFu15i_BFu7c_BFu7s { unsigned int v1:15; unsigned char v2:7; unsigned short v3:7; };
struct BFu15i_BFu7c_BFu8c { unsigned int v1:15; unsigned char v2:7; unsigned char v3:8; };
struct BFu15i_BFu7c_BFu8i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:8; };
struct BFu15i_BFu7c_BFu8ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:8; };
struct BFu15i_BFu7c_BFu8s { unsigned int v1:15; unsigned char v2:7; unsigned short v3:8; };
struct BFu15i_BFu7c_BFu9i { unsigned int v1:15; unsigned char v2:7; unsigned int v3:9; };
struct BFu15i_BFu7c_BFu9ll { unsigned int v1:15; unsigned char v2:7; unsigned long long v3:9; };
struct BFu15i_BFu7c_BFu9s { unsigned int v1:15; unsigned char v2:7; unsigned short v3:9; };
struct BFu15i_BFu7c_C { unsigned int v1:15; unsigned char v2:7; char v3; };
struct BFu15i_BFu7c_D { unsigned int v1:15; unsigned char v2:7; double v3; };
struct BFu15i_BFu7c_F { unsigned int v1:15; unsigned char v2:7; float v3; };
struct BFu15i_BFu7c_I { unsigned int v1:15; unsigned char v2:7; int v3; };
struct BFu15i_BFu7c_Ip { unsigned int v1:15; unsigned char v2:7; int * v3; };
struct BFu15i_BFu7c_L { unsigned int v1:15; unsigned char v2:7; long long v3; };
struct BFu15i_BFu7c_S { unsigned int v1:15; unsigned char v2:7; short v3; };
struct BFu15i_BFu7c_Uc { unsigned int v1:15; unsigned char v2:7; unsigned char v3; };
struct BFu15i_BFu7c_Ui { unsigned int v1:15; unsigned char v2:7; unsigned int v3; };
struct BFu15i_BFu7c_Ul { unsigned int v1:15; unsigned char v2:7; unsigned long long v3; };
struct BFu15i_BFu7c_Us { unsigned int v1:15; unsigned char v2:7; unsigned short v3; };
struct BFu15i_BFu7c_Vp { unsigned int v1:15; unsigned char v2:7; void * v3; };
struct BFu15i_BFu7i { unsigned int v1:15; unsigned int v2:7; };
struct BFu15i_BFu7i_BFu15i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:15; };
struct BFu15i_BFu7i_BFu15ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:15; };
struct BFu15i_BFu7i_BFu15s { unsigned int v1:15; unsigned int v2:7; unsigned short v3:15; };
struct BFu15i_BFu7i_BFu16i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:16; };
struct BFu15i_BFu7i_BFu16ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:16; };
struct BFu15i_BFu7i_BFu16s { unsigned int v1:15; unsigned int v2:7; unsigned short v3:16; };
struct BFu15i_BFu7i_BFu17i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:17; };
struct BFu15i_BFu7i_BFu17ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:17; };
struct BFu15i_BFu7i_BFu1c { unsigned int v1:15; unsigned int v2:7; unsigned char v3:1; };
struct BFu15i_BFu7i_BFu1i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:1; };
struct BFu15i_BFu7i_BFu1ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:1; };
struct BFu15i_BFu7i_BFu1s { unsigned int v1:15; unsigned int v2:7; unsigned short v3:1; };
struct BFu15i_BFu7i_BFu31i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:31; };
struct BFu15i_BFu7i_BFu31ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:31; };
struct BFu15i_BFu7i_BFu32i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:32; };
struct BFu15i_BFu7i_BFu32ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:32; };
struct BFu15i_BFu7i_BFu33 { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:33; };
struct BFu15i_BFu7i_BFu7c { unsigned int v1:15; unsigned int v2:7; unsigned char v3:7; };
struct BFu15i_BFu7i_BFu7i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:7; };
struct BFu15i_BFu7i_BFu7ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:7; };
struct BFu15i_BFu7i_BFu7s { unsigned int v1:15; unsigned int v2:7; unsigned short v3:7; };
struct BFu15i_BFu7i_BFu8c { unsigned int v1:15; unsigned int v2:7; unsigned char v3:8; };
struct BFu15i_BFu7i_BFu8i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:8; };
struct BFu15i_BFu7i_BFu8ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:8; };
struct BFu15i_BFu7i_BFu8s { unsigned int v1:15; unsigned int v2:7; unsigned short v3:8; };
struct BFu15i_BFu7i_BFu9i { unsigned int v1:15; unsigned int v2:7; unsigned int v3:9; };
struct BFu15i_BFu7i_BFu9ll { unsigned int v1:15; unsigned int v2:7; unsigned long long v3:9; };
struct BFu15i_BFu7i_BFu9s { unsigned int v1:15; unsigned int v2:7; unsigned short v3:9; };
struct BFu15i_BFu7i_C { unsigned int v1:15; unsigned int v2:7; char v3; };
struct BFu15i_BFu7i_D { unsigned int v1:15; unsigned int v2:7; double v3; };
struct BFu15i_BFu7i_F { unsigned int v1:15; unsigned int v2:7; float v3; };
struct BFu15i_BFu7i_I { unsigned int v1:15; unsigned int v2:7; int v3; };
struct BFu15i_BFu7i_Ip { unsigned int v1:15; unsigned int v2:7; int * v3; };
struct BFu15i_BFu7i_L { unsigned int v1:15; unsigned int v2:7; long long v3; };
struct BFu15i_BFu7i_S { unsigned int v1:15; unsigned int v2:7; short v3; };
struct BFu15i_BFu7i_Uc { unsigned int v1:15; unsigned int v2:7; unsigned char v3; };
struct BFu15i_BFu7i_Ui { unsigned int v1:15; unsigned int v2:7; unsigned int v3; };
struct BFu15i_BFu7i_Ul { unsigned int v1:15; unsigned int v2:7; unsigned long long v3; };
struct BFu15i_BFu7i_Us { unsigned int v1:15; unsigned int v2:7; unsigned short v3; };
struct BFu15i_BFu7i_Vp { unsigned int v1:15; unsigned int v2:7; void * v3; };
struct BFu15i_BFu7ll { unsigned int v1:15; unsigned long long v2:7; };
struct BFu15i_BFu7ll_BFu15i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:15; };
struct BFu15i_BFu7ll_BFu15ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:15; };
struct BFu15i_BFu7ll_BFu15s { unsigned int v1:15; unsigned long long v2:7; unsigned short v3:15; };
struct BFu15i_BFu7ll_BFu16i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:16; };
struct BFu15i_BFu7ll_BFu16ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:16; };
struct BFu15i_BFu7ll_BFu16s { unsigned int v1:15; unsigned long long v2:7; unsigned short v3:16; };
struct BFu15i_BFu7ll_BFu17i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:17; };
struct BFu15i_BFu7ll_BFu17ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:17; };
struct BFu15i_BFu7ll_BFu1c { unsigned int v1:15; unsigned long long v2:7; unsigned char v3:1; };
struct BFu15i_BFu7ll_BFu1i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:1; };
struct BFu15i_BFu7ll_BFu1ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:1; };
struct BFu15i_BFu7ll_BFu1s { unsigned int v1:15; unsigned long long v2:7; unsigned short v3:1; };
struct BFu15i_BFu7ll_BFu31i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:31; };
struct BFu15i_BFu7ll_BFu31ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:31; };
struct BFu15i_BFu7ll_BFu32i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:32; };
struct BFu15i_BFu7ll_BFu32ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:32; };
struct BFu15i_BFu7ll_BFu33 { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:33; };
struct BFu15i_BFu7ll_BFu7c { unsigned int v1:15; unsigned long long v2:7; unsigned char v3:7; };
struct BFu15i_BFu7ll_BFu7i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:7; };
struct BFu15i_BFu7ll_BFu7ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:7; };
struct BFu15i_BFu7ll_BFu7s { unsigned int v1:15; unsigned long long v2:7; unsigned short v3:7; };
struct BFu15i_BFu7ll_BFu8c { unsigned int v1:15; unsigned long long v2:7; unsigned char v3:8; };
struct BFu15i_BFu7ll_BFu8i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:8; };
struct BFu15i_BFu7ll_BFu8ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:8; };
struct BFu15i_BFu7ll_BFu8s { unsigned int v1:15; unsigned long long v2:7; unsigned short v3:8; };
struct BFu15i_BFu7ll_BFu9i { unsigned int v1:15; unsigned long long v2:7; unsigned int v3:9; };
struct BFu15i_BFu7ll_BFu9ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3:9; };
struct BFu15i_BFu7ll_BFu9s { unsigned int v1:15; unsigned long long v2:7; unsigned short v3:9; };
struct BFu15i_BFu7ll_C { unsigned int v1:15; unsigned long long v2:7; char v3; };
struct BFu15i_BFu7ll_D { unsigned int v1:15; unsigned long long v2:7; double v3; };
struct BFu15i_BFu7ll_F { unsigned int v1:15; unsigned long long v2:7; float v3; };
struct BFu15i_BFu7ll_I { unsigned int v1:15; unsigned long long v2:7; int v3; };
struct BFu15i_BFu7ll_Ip { unsigned int v1:15; unsigned long long v2:7; int * v3; };
struct BFu15i_BFu7ll_L { unsigned int v1:15; unsigned long long v2:7; long long v3; };
struct BFu15i_BFu7ll_S { unsigned int v1:15; unsigned long long v2:7; short v3; };
struct BFu15i_BFu7ll_Uc { unsigned int v1:15; unsigned long long v2:7; unsigned char v3; };
struct BFu15i_BFu7ll_Ui { unsigned int v1:15; unsigned long long v2:7; unsigned int v3; };
struct BFu15i_BFu7ll_Ul { unsigned int v1:15; unsigned long long v2:7; unsigned long long v3; };
struct BFu15i_BFu7ll_Us { unsigned int v1:15; unsigned long long v2:7; unsigned short v3; };
struct BFu15i_BFu7ll_Vp { unsigned int v1:15; unsigned long long v2:7; void * v3; };
struct BFu15i_BFu7s { unsigned int v1:15; unsigned short v2:7; };
struct BFu15i_BFu7s_BFu15i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:15; };
struct BFu15i_BFu7s_BFu15ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:15; };
struct BFu15i_BFu7s_BFu15s { unsigned int v1:15; unsigned short v2:7; unsigned short v3:15; };
struct BFu15i_BFu7s_BFu16i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:16; };
struct BFu15i_BFu7s_BFu16ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:16; };
struct BFu15i_BFu7s_BFu16s { unsigned int v1:15; unsigned short v2:7; unsigned short v3:16; };
struct BFu15i_BFu7s_BFu17i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:17; };
struct BFu15i_BFu7s_BFu17ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:17; };
struct BFu15i_BFu7s_BFu1c { unsigned int v1:15; unsigned short v2:7; unsigned char v3:1; };
struct BFu15i_BFu7s_BFu1i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:1; };
struct BFu15i_BFu7s_BFu1ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:1; };
struct BFu15i_BFu7s_BFu1s { unsigned int v1:15; unsigned short v2:7; unsigned short v3:1; };
struct BFu15i_BFu7s_BFu31i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:31; };
struct BFu15i_BFu7s_BFu31ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:31; };
struct BFu15i_BFu7s_BFu32i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:32; };
struct BFu15i_BFu7s_BFu32ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:32; };
struct BFu15i_BFu7s_BFu33 { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:33; };
struct BFu15i_BFu7s_BFu7c { unsigned int v1:15; unsigned short v2:7; unsigned char v3:7; };
struct BFu15i_BFu7s_BFu7i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:7; };
struct BFu15i_BFu7s_BFu7ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:7; };
struct BFu15i_BFu7s_BFu7s { unsigned int v1:15; unsigned short v2:7; unsigned short v3:7; };
struct BFu15i_BFu7s_BFu8c { unsigned int v1:15; unsigned short v2:7; unsigned char v3:8; };
struct BFu15i_BFu7s_BFu8i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:8; };
struct BFu15i_BFu7s_BFu8ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:8; };
struct BFu15i_BFu7s_BFu8s { unsigned int v1:15; unsigned short v2:7; unsigned short v3:8; };
struct BFu15i_BFu7s_BFu9i { unsigned int v1:15; unsigned short v2:7; unsigned int v3:9; };
struct BFu15i_BFu7s_BFu9ll { unsigned int v1:15; unsigned short v2:7; unsigned long long v3:9; };
struct BFu15i_BFu7s_BFu9s { unsigned int v1:15; unsigned short v2:7; unsigned short v3:9; };
struct BFu15i_BFu7s_C { unsigned int v1:15; unsigned short v2:7; char v3; };
struct BFu15i_BFu7s_D { unsigned int v1:15; unsigned short v2:7; double v3; };
struct BFu15i_BFu7s_F { unsigned int v1:15; unsigned short v2:7; float v3; };
struct BFu15i_BFu7s_I { unsigned int v1:15; unsigned short v2:7; int v3; };
struct BFu15i_BFu7s_Ip { unsigned int v1:15; unsigned short v2:7; int * v3; };
struct BFu15i_BFu7s_L { unsigned int v1:15; unsigned short v2:7; long long v3; };
struct BFu15i_BFu7s_S { unsigned int v1:15; unsigned short v2:7; short v3; };
struct BFu15i_BFu7s_Uc { unsigned int v1:15; unsigned short v2:7; unsigned char v3; };
struct BFu15i_BFu7s_Ui { unsigned int v1:15; unsigned short v2:7; unsigned int v3; };
struct BFu15i_BFu7s_Ul { unsigned int v1:15; unsigned short v2:7; unsigned long long v3; };
struct BFu15i_BFu7s_Us { unsigned int v1:15; unsigned short v2:7; unsigned short v3; };
struct BFu15i_BFu7s_Vp { unsigned int v1:15; unsigned short v2:7; void * v3; };
struct BFu15i_BFu8c { unsigned int v1:15; unsigned char v2:8; };
struct BFu15i_BFu8c_BFu15i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:15; };
struct BFu15i_BFu8c_BFu15ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:15; };
struct BFu15i_BFu8c_BFu15s { unsigned int v1:15; unsigned char v2:8; unsigned short v3:15; };
struct BFu15i_BFu8c_BFu16i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:16; };
struct BFu15i_BFu8c_BFu16ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:16; };
struct BFu15i_BFu8c_BFu16s { unsigned int v1:15; unsigned char v2:8; unsigned short v3:16; };
struct BFu15i_BFu8c_BFu17i { unsigned int v1:15; unsigned char v2:8; unsigned int v3:17; };
struct BFu15i_BFu8c_BFu17ll { unsigned int v1:15; unsigned char v2:8; unsigned long long v3:17; };
struct BFu15i_BFu8c_BFu1c { unsigned int v1:15; unsigned char v2:8; unsigned char v3:1; };


static void Test_BFs8ll_BFs8c_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8ll_BFu8c, BFs8ll_BFs8c_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8ll_BFu8i, BFs8ll_BFs8c_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8ll_BFu8ll, BFs8ll_BFs8c_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8ll_BFu8s, BFs8ll_BFs8c_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s, BFs8ll_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFs8c, BFs8ll_BFs8c_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFs8i, BFs8ll_BFs8c_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFs8ll, BFs8ll_BFs8c_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFs8s, BFs8ll_BFs8c_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFu8c, BFs8ll_BFs8c_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFu8i, BFs8ll_BFs8c_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFu8ll, BFs8ll_BFs8c_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8c_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8c_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8c_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8c_BFu8s_BFu8s, BFs8ll_BFs8c_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i, BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c, BFs8ll_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFs8c, BFs8ll_BFs8i_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFs8i, BFs8ll_BFs8i_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFs8ll, BFs8ll_BFs8i_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFs8s, BFs8ll_BFs8i_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFu8c, BFs8ll_BFs8i_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFu8i, BFs8ll_BFs8i_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFu8ll, BFs8ll_BFs8i_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8c_BFu8s, BFs8ll_BFs8i_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i, BFs8ll_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFs8c, BFs8ll_BFs8i_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFs8i, BFs8ll_BFs8i_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFs8ll, BFs8ll_BFs8i_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFs8s, BFs8ll_BFs8i_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFu8c, BFs8ll_BFs8i_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFu8i, BFs8ll_BFs8i_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFu8ll, BFs8ll_BFs8i_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8i_BFu8s, BFs8ll_BFs8i_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll, BFs8ll_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFs8c, BFs8ll_BFs8i_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFs8i, BFs8ll_BFs8i_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFs8ll, BFs8ll_BFs8i_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFs8s, BFs8ll_BFs8i_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFu8c, BFs8ll_BFs8i_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFu8i, BFs8ll_BFs8i_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFu8ll, BFs8ll_BFs8i_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8ll_BFu8s, BFs8ll_BFs8i_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s, BFs8ll_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFs8c, BFs8ll_BFs8i_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFs8i, BFs8ll_BFs8i_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFs8ll, BFs8ll_BFs8i_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFs8s, BFs8ll_BFs8i_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFu8c, BFs8ll_BFs8i_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFu8i, BFs8ll_BFs8i_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFu8ll, BFs8ll_BFs8i_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFs8s_BFu8s, BFs8ll_BFs8i_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c, BFs8ll_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFs8c, BFs8ll_BFs8i_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFs8i, BFs8ll_BFs8i_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFs8ll, BFs8ll_BFs8i_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFs8s, BFs8ll_BFs8i_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFu8c, BFs8ll_BFs8i_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFu8i, BFs8ll_BFs8i_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFu8ll, BFs8ll_BFs8i_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8c_BFu8s, BFs8ll_BFs8i_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i, BFs8ll_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFs8c, BFs8ll_BFs8i_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFs8i, BFs8ll_BFs8i_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFs8ll, BFs8ll_BFs8i_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFs8s, BFs8ll_BFs8i_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFu8c, BFs8ll_BFs8i_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFu8i, BFs8ll_BFs8i_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFu8ll, BFs8ll_BFs8i_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8i_BFu8s, BFs8ll_BFs8i_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll, BFs8ll_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFs8c, BFs8ll_BFs8i_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFs8i, BFs8ll_BFs8i_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFs8ll, BFs8ll_BFs8i_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFs8s, BFs8ll_BFs8i_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFu8c, BFs8ll_BFs8i_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFu8i, BFs8ll_BFs8i_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFu8ll, BFs8ll_BFs8i_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8ll_BFu8s, BFs8ll_BFs8i_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s, BFs8ll_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFs8c, BFs8ll_BFs8i_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFs8i, BFs8ll_BFs8i_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFs8ll, BFs8ll_BFs8i_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFs8s, BFs8ll_BFs8i_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFu8c, BFs8ll_BFs8i_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFu8i, BFs8ll_BFs8i_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFu8ll, BFs8ll_BFs8i_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8i_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8i_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8i_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8i_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8i_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8i_BFu8s_BFu8s, BFs8ll_BFs8i_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll, BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c, BFs8ll_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFs8c, BFs8ll_BFs8ll_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFs8i, BFs8ll_BFs8ll_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFs8ll, BFs8ll_BFs8ll_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFs8s, BFs8ll_BFs8ll_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFu8c, BFs8ll_BFs8ll_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFu8i, BFs8ll_BFs8ll_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFu8ll, BFs8ll_BFs8ll_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8c_BFu8s, BFs8ll_BFs8ll_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i, BFs8ll_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFs8c, BFs8ll_BFs8ll_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFs8i, BFs8ll_BFs8ll_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFs8ll, BFs8ll_BFs8ll_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFs8s, BFs8ll_BFs8ll_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFu8c, BFs8ll_BFs8ll_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFu8i, BFs8ll_BFs8ll_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFu8ll, BFs8ll_BFs8ll_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8i_BFu8s, BFs8ll_BFs8ll_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll, BFs8ll_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFs8c, BFs8ll_BFs8ll_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFs8i, BFs8ll_BFs8ll_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFs8ll, BFs8ll_BFs8ll_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFs8s, BFs8ll_BFs8ll_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFu8c, BFs8ll_BFs8ll_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFu8i, BFs8ll_BFs8ll_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFu8ll, BFs8ll_BFs8ll_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8ll_BFu8s, BFs8ll_BFs8ll_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s, BFs8ll_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFs8c, BFs8ll_BFs8ll_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFs8i, BFs8ll_BFs8ll_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFs8ll, BFs8ll_BFs8ll_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFs8s, BFs8ll_BFs8ll_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFu8c, BFs8ll_BFs8ll_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFu8i, BFs8ll_BFs8ll_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFu8ll, BFs8ll_BFs8ll_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFs8s_BFu8s, BFs8ll_BFs8ll_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c, BFs8ll_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFs8c, BFs8ll_BFs8ll_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFs8i, BFs8ll_BFs8ll_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFs8ll, BFs8ll_BFs8ll_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFs8s, BFs8ll_BFs8ll_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFu8c, BFs8ll_BFs8ll_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFu8i, BFs8ll_BFs8ll_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFu8ll, BFs8ll_BFs8ll_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8c_BFu8s, BFs8ll_BFs8ll_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i, BFs8ll_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFs8c, BFs8ll_BFs8ll_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFs8i, BFs8ll_BFs8ll_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFs8ll, BFs8ll_BFs8ll_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFs8s, BFs8ll_BFs8ll_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFu8c, BFs8ll_BFs8ll_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFu8i, BFs8ll_BFs8ll_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFu8ll, BFs8ll_BFs8ll_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8i_BFu8s, BFs8ll_BFs8ll_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll, BFs8ll_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFs8c, BFs8ll_BFs8ll_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFs8i, BFs8ll_BFs8ll_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFs8ll, BFs8ll_BFs8ll_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFs8s, BFs8ll_BFs8ll_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFu8c, BFs8ll_BFs8ll_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFu8i, BFs8ll_BFs8ll_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFu8ll, BFs8ll_BFs8ll_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8ll_BFu8s, BFs8ll_BFs8ll_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s, BFs8ll_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFs8c, BFs8ll_BFs8ll_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFs8i, BFs8ll_BFs8ll_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFs8ll, BFs8ll_BFs8ll_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFs8s, BFs8ll_BFs8ll_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFu8c, BFs8ll_BFs8ll_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFu8i, BFs8ll_BFs8ll_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFu8ll, BFs8ll_BFs8ll_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8ll_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8ll_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8ll_BFu8s_BFu8s, BFs8ll_BFs8ll_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s, BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c, BFs8ll_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFs8c, BFs8ll_BFs8s_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFs8i, BFs8ll_BFs8s_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFs8ll, BFs8ll_BFs8s_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFs8s, BFs8ll_BFs8s_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFu8c, BFs8ll_BFs8s_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFu8i, BFs8ll_BFs8s_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFu8ll, BFs8ll_BFs8s_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8c_BFu8s, BFs8ll_BFs8s_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i, BFs8ll_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFs8c, BFs8ll_BFs8s_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFs8i, BFs8ll_BFs8s_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFs8ll, BFs8ll_BFs8s_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFs8s, BFs8ll_BFs8s_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFu8c, BFs8ll_BFs8s_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFu8i, BFs8ll_BFs8s_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFu8ll, BFs8ll_BFs8s_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8i_BFu8s, BFs8ll_BFs8s_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll, BFs8ll_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFs8c, BFs8ll_BFs8s_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFs8i, BFs8ll_BFs8s_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFs8ll, BFs8ll_BFs8s_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFs8s, BFs8ll_BFs8s_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFu8c, BFs8ll_BFs8s_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFu8i, BFs8ll_BFs8s_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFu8ll, BFs8ll_BFs8s_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8ll_BFu8s, BFs8ll_BFs8s_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s, BFs8ll_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFs8c, BFs8ll_BFs8s_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFs8i, BFs8ll_BFs8s_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFs8ll, BFs8ll_BFs8s_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFs8s, BFs8ll_BFs8s_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFu8c, BFs8ll_BFs8s_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFu8i, BFs8ll_BFs8s_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFu8ll, BFs8ll_BFs8s_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFs8s_BFu8s, BFs8ll_BFs8s_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c, BFs8ll_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFs8c, BFs8ll_BFs8s_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFs8i, BFs8ll_BFs8s_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFs8ll, BFs8ll_BFs8s_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFs8s, BFs8ll_BFs8s_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFu8c, BFs8ll_BFs8s_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFu8i, BFs8ll_BFs8s_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFu8ll, BFs8ll_BFs8s_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8c_BFu8s, BFs8ll_BFs8s_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i, BFs8ll_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFs8c, BFs8ll_BFs8s_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFs8i, BFs8ll_BFs8s_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFs8ll, BFs8ll_BFs8s_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFs8s, BFs8ll_BFs8s_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFu8c, BFs8ll_BFs8s_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFu8i, BFs8ll_BFs8s_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFu8ll, BFs8ll_BFs8s_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8i_BFu8s, BFs8ll_BFs8s_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll, BFs8ll_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFs8c, BFs8ll_BFs8s_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFs8i, BFs8ll_BFs8s_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFs8ll, BFs8ll_BFs8s_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFs8s, BFs8ll_BFs8s_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFu8c, BFs8ll_BFs8s_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFu8i, BFs8ll_BFs8s_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFu8ll, BFs8ll_BFs8s_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8ll_BFu8s, BFs8ll_BFs8s_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s, BFs8ll_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFs8c, BFs8ll_BFs8s_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFs8i, BFs8ll_BFs8s_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFs8ll, BFs8ll_BFs8s_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFs8s, BFs8ll_BFs8s_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFu8c, BFs8ll_BFs8s_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFu8i, BFs8ll_BFs8s_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFu8ll, BFs8ll_BFs8s_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFs8s_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFs8s_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFs8s_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFs8s_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFs8s_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFs8s_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFs8s_BFu8s_BFu8s, BFs8ll_BFs8s_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c, BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c, BFs8ll_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFs8c, BFs8ll_BFu8c_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFs8i, BFs8ll_BFu8c_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFs8ll, BFs8ll_BFu8c_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFs8s, BFs8ll_BFu8c_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFu8c, BFs8ll_BFu8c_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFu8i, BFs8ll_BFu8c_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFu8ll, BFs8ll_BFu8c_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8c_BFu8s, BFs8ll_BFu8c_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i, BFs8ll_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFs8c, BFs8ll_BFu8c_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFs8i, BFs8ll_BFu8c_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFs8ll, BFs8ll_BFu8c_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFs8s, BFs8ll_BFu8c_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFu8c, BFs8ll_BFu8c_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFu8i, BFs8ll_BFu8c_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFu8ll, BFs8ll_BFu8c_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8i_BFu8s, BFs8ll_BFu8c_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll, BFs8ll_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFs8c, BFs8ll_BFu8c_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFs8i, BFs8ll_BFu8c_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFs8ll, BFs8ll_BFu8c_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFs8s, BFs8ll_BFu8c_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFu8c, BFs8ll_BFu8c_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFu8i, BFs8ll_BFu8c_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFu8ll, BFs8ll_BFu8c_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8ll_BFu8s, BFs8ll_BFu8c_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s, BFs8ll_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFs8c, BFs8ll_BFu8c_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFs8i, BFs8ll_BFu8c_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFs8ll, BFs8ll_BFu8c_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFs8s, BFs8ll_BFu8c_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFu8c, BFs8ll_BFu8c_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFu8i, BFs8ll_BFu8c_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFu8ll, BFs8ll_BFu8c_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFs8s_BFu8s, BFs8ll_BFu8c_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c, BFs8ll_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFs8c, BFs8ll_BFu8c_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFs8i, BFs8ll_BFu8c_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFs8ll, BFs8ll_BFu8c_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFs8s, BFs8ll_BFu8c_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFu8c, BFs8ll_BFu8c_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFu8i, BFs8ll_BFu8c_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFu8ll, BFs8ll_BFu8c_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8c_BFu8s, BFs8ll_BFu8c_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i, BFs8ll_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFs8c, BFs8ll_BFu8c_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFs8i, BFs8ll_BFu8c_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFs8ll, BFs8ll_BFu8c_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFs8s, BFs8ll_BFu8c_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFu8c, BFs8ll_BFu8c_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFu8i, BFs8ll_BFu8c_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFu8ll, BFs8ll_BFu8c_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8i_BFu8s, BFs8ll_BFu8c_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll, BFs8ll_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFs8c, BFs8ll_BFu8c_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFs8i, BFs8ll_BFu8c_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFs8ll, BFs8ll_BFu8c_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFs8s, BFs8ll_BFu8c_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFu8c, BFs8ll_BFu8c_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFu8i, BFs8ll_BFu8c_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFu8ll, BFs8ll_BFu8c_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8ll_BFu8s, BFs8ll_BFu8c_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s, BFs8ll_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFs8c, BFs8ll_BFu8c_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFs8i, BFs8ll_BFu8c_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFs8ll, BFs8ll_BFu8c_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFs8s, BFs8ll_BFu8c_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFu8c, BFs8ll_BFu8c_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFu8i, BFs8ll_BFu8c_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFu8ll, BFs8ll_BFu8c_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8c_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8c_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8c_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8c_BFu8s_BFu8s, BFs8ll_BFu8c_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i, BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c, BFs8ll_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFs8c, BFs8ll_BFu8i_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFs8i, BFs8ll_BFu8i_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFs8ll, BFs8ll_BFu8i_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFs8s, BFs8ll_BFu8i_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFu8c, BFs8ll_BFu8i_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFu8i, BFs8ll_BFu8i_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFu8ll, BFs8ll_BFu8i_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8c_BFu8s, BFs8ll_BFu8i_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i, BFs8ll_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFs8c, BFs8ll_BFu8i_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFs8i, BFs8ll_BFu8i_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFs8ll, BFs8ll_BFu8i_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFs8s, BFs8ll_BFu8i_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFu8c, BFs8ll_BFu8i_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFu8i, BFs8ll_BFu8i_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFu8ll, BFs8ll_BFu8i_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8i_BFu8s, BFs8ll_BFu8i_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll, BFs8ll_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFs8c, BFs8ll_BFu8i_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFs8i, BFs8ll_BFu8i_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFs8ll, BFs8ll_BFu8i_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFs8s, BFs8ll_BFu8i_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFu8c, BFs8ll_BFu8i_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFu8i, BFs8ll_BFu8i_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFu8ll, BFs8ll_BFu8i_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8ll_BFu8s, BFs8ll_BFu8i_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s, BFs8ll_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFs8c, BFs8ll_BFu8i_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFs8i, BFs8ll_BFu8i_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFs8ll, BFs8ll_BFu8i_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFs8s, BFs8ll_BFu8i_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFu8c, BFs8ll_BFu8i_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFu8i, BFs8ll_BFu8i_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFu8ll, BFs8ll_BFu8i_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFs8s_BFu8s, BFs8ll_BFu8i_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c, BFs8ll_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFs8c, BFs8ll_BFu8i_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFs8i, BFs8ll_BFu8i_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFs8ll, BFs8ll_BFu8i_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFs8s, BFs8ll_BFu8i_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFu8c, BFs8ll_BFu8i_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFu8i, BFs8ll_BFu8i_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFu8ll, BFs8ll_BFu8i_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8c_BFu8s, BFs8ll_BFu8i_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i, BFs8ll_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFs8c, BFs8ll_BFu8i_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFs8i, BFs8ll_BFu8i_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFs8ll, BFs8ll_BFu8i_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFs8s, BFs8ll_BFu8i_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFu8c, BFs8ll_BFu8i_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFu8i, BFs8ll_BFu8i_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFu8ll, BFs8ll_BFu8i_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8i_BFu8s, BFs8ll_BFu8i_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll, BFs8ll_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFs8c, BFs8ll_BFu8i_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFs8i, BFs8ll_BFu8i_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFs8ll, BFs8ll_BFu8i_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFs8s, BFs8ll_BFu8i_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFu8c, BFs8ll_BFu8i_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFu8i, BFs8ll_BFu8i_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFu8ll, BFs8ll_BFu8i_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8ll_BFu8s, BFs8ll_BFu8i_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s, BFs8ll_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFs8c, BFs8ll_BFu8i_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFs8i, BFs8ll_BFu8i_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFs8ll, BFs8ll_BFu8i_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFs8s, BFs8ll_BFu8i_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFu8c, BFs8ll_BFu8i_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFu8i, BFs8ll_BFu8i_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFu8ll, BFs8ll_BFu8i_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8i_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8i_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8i_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8i_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8i_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8i_BFu8s_BFu8s, BFs8ll_BFu8i_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll, BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c, BFs8ll_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFs8c, BFs8ll_BFu8ll_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFs8i, BFs8ll_BFu8ll_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFs8ll, BFs8ll_BFu8ll_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFs8s, BFs8ll_BFu8ll_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFu8c, BFs8ll_BFu8ll_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFu8i, BFs8ll_BFu8ll_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFu8ll, BFs8ll_BFu8ll_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8c_BFu8s, BFs8ll_BFu8ll_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i, BFs8ll_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFs8c, BFs8ll_BFu8ll_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFs8i, BFs8ll_BFu8ll_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFs8ll, BFs8ll_BFu8ll_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFs8s, BFs8ll_BFu8ll_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFu8c, BFs8ll_BFu8ll_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFu8i, BFs8ll_BFu8ll_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFu8ll, BFs8ll_BFu8ll_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8i_BFu8s, BFs8ll_BFu8ll_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll, BFs8ll_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFs8c, BFs8ll_BFu8ll_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFs8i, BFs8ll_BFu8ll_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFs8ll, BFs8ll_BFu8ll_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFs8s, BFs8ll_BFu8ll_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFu8c, BFs8ll_BFu8ll_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFu8i, BFs8ll_BFu8ll_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFu8ll, BFs8ll_BFu8ll_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8ll_BFu8s, BFs8ll_BFu8ll_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s, BFs8ll_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFs8c, BFs8ll_BFu8ll_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFs8i, BFs8ll_BFu8ll_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFs8ll, BFs8ll_BFu8ll_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFs8s, BFs8ll_BFu8ll_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFu8c, BFs8ll_BFu8ll_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFu8i, BFs8ll_BFu8ll_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFu8ll, BFs8ll_BFu8ll_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFs8s_BFu8s, BFs8ll_BFu8ll_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c, BFs8ll_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFs8c, BFs8ll_BFu8ll_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFs8i, BFs8ll_BFu8ll_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFs8ll, BFs8ll_BFu8ll_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFs8s, BFs8ll_BFu8ll_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFu8c, BFs8ll_BFu8ll_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFu8i, BFs8ll_BFu8ll_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFu8ll, BFs8ll_BFu8ll_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8c_BFu8s, BFs8ll_BFu8ll_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i, BFs8ll_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFs8c, BFs8ll_BFu8ll_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFs8i, BFs8ll_BFu8ll_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFs8ll, BFs8ll_BFu8ll_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFs8s, BFs8ll_BFu8ll_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFu8c, BFs8ll_BFu8ll_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFu8i, BFs8ll_BFu8ll_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFu8ll, BFs8ll_BFu8ll_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8i_BFu8s, BFs8ll_BFu8ll_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll, BFs8ll_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFs8c, BFs8ll_BFu8ll_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFs8i, BFs8ll_BFu8ll_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFs8ll, BFs8ll_BFu8ll_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFs8s, BFs8ll_BFu8ll_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFu8c, BFs8ll_BFu8ll_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFu8i, BFs8ll_BFu8ll_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFu8ll, BFs8ll_BFu8ll_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8ll_BFu8s, BFs8ll_BFu8ll_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s, BFs8ll_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFs8c, BFs8ll_BFu8ll_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFs8i, BFs8ll_BFu8ll_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFs8ll, BFs8ll_BFu8ll_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFs8s, BFs8ll_BFu8ll_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFu8c, BFs8ll_BFu8ll_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFu8i, BFs8ll_BFu8ll_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFu8ll, BFs8ll_BFu8ll_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8ll_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8ll_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8ll_BFu8s_BFu8s, BFs8ll_BFu8ll_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s, BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c, BFs8ll_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFs8c, BFs8ll_BFu8s_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFs8i, BFs8ll_BFu8s_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFs8ll, BFs8ll_BFu8s_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFs8s, BFs8ll_BFu8s_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFu8c, BFs8ll_BFu8s_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFu8i, BFs8ll_BFu8s_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFu8ll, BFs8ll_BFu8s_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8c_BFu8s, BFs8ll_BFu8s_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i, BFs8ll_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFs8c, BFs8ll_BFu8s_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFs8i, BFs8ll_BFu8s_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFs8ll, BFs8ll_BFu8s_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFs8s, BFs8ll_BFu8s_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFu8c, BFs8ll_BFu8s_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFu8i, BFs8ll_BFu8s_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFu8ll, BFs8ll_BFu8s_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8i_BFu8s, BFs8ll_BFu8s_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll, BFs8ll_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFs8c, BFs8ll_BFu8s_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFs8i, BFs8ll_BFu8s_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFs8ll, BFs8ll_BFu8s_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFs8s, BFs8ll_BFu8s_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFu8c, BFs8ll_BFu8s_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFu8i, BFs8ll_BFu8s_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFu8ll, BFs8ll_BFu8s_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8ll_BFu8s, BFs8ll_BFu8s_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s, BFs8ll_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFs8c, BFs8ll_BFu8s_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFs8i, BFs8ll_BFu8s_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFs8ll, BFs8ll_BFu8s_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFs8s, BFs8ll_BFu8s_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFu8c, BFs8ll_BFu8s_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFu8i, BFs8ll_BFu8s_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFu8ll, BFs8ll_BFu8s_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFs8s_BFu8s, BFs8ll_BFu8s_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c, BFs8ll_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFs8c, BFs8ll_BFu8s_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFs8i, BFs8ll_BFu8s_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFs8ll, BFs8ll_BFu8s_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFs8s, BFs8ll_BFu8s_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFu8c, BFs8ll_BFu8s_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFu8i, BFs8ll_BFu8s_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFu8ll, BFs8ll_BFu8s_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8c_BFu8s, BFs8ll_BFu8s_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i, BFs8ll_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFs8c, BFs8ll_BFu8s_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFs8i, BFs8ll_BFu8s_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFs8ll, BFs8ll_BFu8s_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFs8s, BFs8ll_BFu8s_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFu8c, BFs8ll_BFu8s_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFu8i, BFs8ll_BFu8s_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFu8ll, BFs8ll_BFu8s_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8i_BFu8s, BFs8ll_BFu8s_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll, BFs8ll_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFs8c, BFs8ll_BFu8s_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFs8i, BFs8ll_BFu8s_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFs8ll, BFs8ll_BFu8s_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFs8s, BFs8ll_BFu8s_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFu8c, BFs8ll_BFu8s_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFu8i, BFs8ll_BFu8s_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFu8ll, BFs8ll_BFu8s_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8ll_BFu8s, BFs8ll_BFu8s_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s, BFs8ll_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFs8c, BFs8ll_BFu8s_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFs8i, BFs8ll_BFu8s_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFs8ll, BFs8ll_BFu8s_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFs8s, BFs8ll_BFu8s_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFu8c, BFs8ll_BFu8s_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFu8i, BFs8ll_BFu8s_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFu8ll, BFs8ll_BFu8s_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8ll_BFu8s_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8ll_BFu8s_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8ll_BFu8s_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8ll_BFu8s_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8ll_BFu8s_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8ll_BFu8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8ll_BFu8s_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8ll_BFu8s_BFu8s_BFu8s, BFs8ll_BFu8s_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c lv;
    check2(sizeof(lv), 2, "sizeof(BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c, BFs8s_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c, BFs8s_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFs8c, BFs8s_BFs8c_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFs8i, BFs8s_BFs8c_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFs8ll, BFs8s_BFs8c_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFs8s, BFs8s_BFs8c_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFu8c, BFs8s_BFs8c_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFu8i, BFs8s_BFs8c_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFu8ll, BFs8s_BFs8c_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8c_BFu8s, BFs8s_BFs8c_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i, BFs8s_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFs8c, BFs8s_BFs8c_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFs8i, BFs8s_BFs8c_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFs8ll, BFs8s_BFs8c_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFs8s, BFs8s_BFs8c_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFu8c, BFs8s_BFs8c_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFu8i, BFs8s_BFs8c_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFu8ll, BFs8s_BFs8c_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8i_BFu8s, BFs8s_BFs8c_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll, BFs8s_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFs8c, BFs8s_BFs8c_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFs8i, BFs8s_BFs8c_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFs8ll, BFs8s_BFs8c_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFs8s, BFs8s_BFs8c_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFu8c, BFs8s_BFs8c_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFu8i, BFs8s_BFs8c_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFu8ll, BFs8s_BFs8c_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8ll_BFu8s, BFs8s_BFs8c_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s, BFs8s_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFs8c, BFs8s_BFs8c_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFs8i, BFs8s_BFs8c_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFs8ll, BFs8s_BFs8c_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFs8s, BFs8s_BFs8c_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFu8c, BFs8s_BFs8c_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFu8i, BFs8s_BFs8c_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFu8ll, BFs8s_BFs8c_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFs8s_BFu8s, BFs8s_BFs8c_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c, BFs8s_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFs8c, BFs8s_BFs8c_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFs8i, BFs8s_BFs8c_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFs8ll, BFs8s_BFs8c_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFs8s, BFs8s_BFs8c_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFu8c, BFs8s_BFs8c_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFu8i, BFs8s_BFs8c_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFu8ll, BFs8s_BFs8c_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8c_BFu8s, BFs8s_BFs8c_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i, BFs8s_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFs8c, BFs8s_BFs8c_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFs8i, BFs8s_BFs8c_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFs8ll, BFs8s_BFs8c_BFu8i_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFs8s, BFs8s_BFs8c_BFu8i_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFu8c, BFs8s_BFs8c_BFu8i_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFu8i, BFs8s_BFs8c_BFu8i_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFu8ll, BFs8s_BFs8c_BFu8i_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8i_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8i_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8i_BFu8s, BFs8s_BFs8c_BFu8i_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll, BFs8s_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFs8c, BFs8s_BFs8c_BFu8ll_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFs8i, BFs8s_BFs8c_BFu8ll_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFs8ll, BFs8s_BFs8c_BFu8ll_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFs8s, BFs8s_BFs8c_BFu8ll_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFu8c, BFs8s_BFs8c_BFu8ll_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFu8i, BFs8s_BFs8c_BFu8ll_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFu8ll, BFs8s_BFs8c_BFu8ll_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8ll_BFu8s, BFs8s_BFs8c_BFu8ll_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s, BFs8s_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFs8c, BFs8s_BFs8c_BFu8s_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFs8i, BFs8s_BFs8c_BFu8s_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFs8ll, BFs8s_BFs8c_BFu8s_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFs8s, BFs8s_BFs8c_BFu8s_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFu8c, BFs8s_BFs8c_BFu8s_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFu8i, BFs8s_BFs8c_BFu8s_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFu8ll, BFs8s_BFs8c_BFu8s_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8c_BFu8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8c_BFu8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8c_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8c_BFu8s_BFu8s, BFs8s_BFs8c_BFu8s_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i lv;
    check2(sizeof(lv), 2, "sizeof(BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i, BFs8s_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c, BFs8s_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFs8c, BFs8s_BFs8i_BFs8c_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFs8i, BFs8s_BFs8i_BFs8c_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFs8ll, BFs8s_BFs8i_BFs8c_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFs8s, BFs8s_BFs8i_BFs8c_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFu8c, BFs8s_BFs8i_BFs8c_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFu8i, BFs8s_BFs8i_BFs8c_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFu8ll, BFs8s_BFs8i_BFs8c_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8c_BFu8s, BFs8s_BFs8i_BFs8c_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i, BFs8s_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFs8c, BFs8s_BFs8i_BFs8i_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFs8i, BFs8s_BFs8i_BFs8i_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFs8ll, BFs8s_BFs8i_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFs8s, BFs8s_BFs8i_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFu8c, BFs8s_BFs8i_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFu8i, BFs8s_BFs8i_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFu8ll, BFs8s_BFs8i_BFs8i_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8i_BFu8s, BFs8s_BFs8i_BFs8i_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll, BFs8s_BFs8i_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFs8c, BFs8s_BFs8i_BFs8ll_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFs8i, BFs8s_BFs8i_BFs8ll_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFs8ll, BFs8s_BFs8i_BFs8ll_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFs8s, BFs8s_BFs8i_BFs8ll_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFu8c, BFs8s_BFs8i_BFs8ll_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFu8i, BFs8s_BFs8i_BFs8ll_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFu8ll, BFs8s_BFs8i_BFs8ll_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8ll_BFu8s, BFs8s_BFs8i_BFs8ll_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s, BFs8s_BFs8i_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFs8c, BFs8s_BFs8i_BFs8s_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFs8i, BFs8s_BFs8i_BFs8s_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFs8ll, BFs8s_BFs8i_BFs8s_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFs8s, BFs8s_BFs8i_BFs8s_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFu8c, BFs8s_BFs8i_BFs8s_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFu8i, BFs8s_BFs8i_BFs8s_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFu8ll, BFs8s_BFs8i_BFs8s_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFs8s_BFu8s, BFs8s_BFs8i_BFs8s_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c, BFs8s_BFs8i_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFs8c, BFs8s_BFs8i_BFu8c_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFs8i, BFs8s_BFs8i_BFu8c_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFs8ll, BFs8s_BFs8i_BFu8c_BFs8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFs8s, BFs8s_BFs8i_BFu8c_BFs8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFu8c, BFs8s_BFs8i_BFu8c_BFu8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFu8i, BFs8s_BFs8i_BFu8c_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFu8ll, BFs8s_BFs8i_BFu8c_BFu8ll)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8c_BFu8s, BFs8s_BFs8i_BFu8c_BFu8s)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFs8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8i, BFs8s_BFs8i_BFu8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8i_BFs8c, BFs8s_BFs8i_BFu8i_BFs8c)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8s_BFs8i_BFu8i_BFs8i, BFs8s_BFs8i_BFu8i_BFs8i)
//============================================================================



static void Test_BFs8s_BFs8i_BFu8i_BFs8ll()
{
  {
    init_simple_test("BFs8s_BFs8i_BFu8i_BFs8ll");
    static STRUCT_IF_C BFs8s_BFs8i_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs8s_BFs8i_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8s_BFs8i_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test