// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct BFs7c_BFu7s_BFu7i_BFu7ll { signed char v1:7; unsigned short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFu7i_BFu7s { signed char v1:7; unsigned short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFu7ll { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; };
struct BFs7c_BFu7s_BFu7ll_BFs7c { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFs7i { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFs7ll { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFs7s { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFu7c { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFu7i { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFu7ll { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFu7ll_BFu7s { signed char v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFu7s { signed char v1:7; unsigned short v2:7; unsigned short v3:7; };
struct BFs7c_BFu7s_BFu7s_BFs7c { signed char v1:7; unsigned short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFu7s_BFs7i { signed char v1:7; unsigned short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFu7s_BFs7ll { signed char v1:7; unsigned short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFu7s_BFs7s { signed char v1:7; unsigned short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFu7s_BFu7c { signed char v1:7; unsigned short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFu7s_BFu7i { signed char v1:7; unsigned short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFu7s_BFu7ll { signed char v1:7; unsigned short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFu7s_BFu7s { signed char v1:7; unsigned short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c { signed int v1:7; signed char v2:7; };
struct BFs7i_BFs7c_BFs7c { signed int v1:7; signed char v2:7; signed char v3:7; };
struct BFs7i_BFs7c_BFs7c_BFs7c { signed int v1:7; signed char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFs7c_BFs7i { signed int v1:7; signed char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFs7c_BFs7ll { signed int v1:7; signed char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFs7c_BFs7s { signed int v1:7; signed char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFs7c_BFu7c { signed int v1:7; signed char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFs7c_BFu7i { signed int v1:7; signed char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFs7c_BFu7ll { signed int v1:7; signed char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFs7c_BFu7s { signed int v1:7; signed char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFs7i { signed int v1:7; signed char v2:7; signed int v3:7; };
struct BFs7i_BFs7c_BFs7i_BFs7c { signed int v1:7; signed char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFs7i_BFs7i { signed int v1:7; signed char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFs7i_BFs7ll { signed int v1:7; signed char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFs7i_BFs7s { signed int v1:7; signed char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFs7i_BFu7c { signed int v1:7; signed char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFs7i_BFu7i { signed int v1:7; signed char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFs7i_BFu7ll { signed int v1:7; signed char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFs7i_BFu7s { signed int v1:7; signed char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFs7ll { signed int v1:7; signed char v2:7; signed long long v3:7; };
struct BFs7i_BFs7c_BFs7ll_BFs7c { signed int v1:7; signed char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFs7i { signed int v1:7; signed char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFs7ll { signed int v1:7; signed char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFs7s { signed int v1:7; signed char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFu7c { signed int v1:7; signed char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFu7i { signed int v1:7; signed char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFu7ll { signed int v1:7; signed char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFs7ll_BFu7s { signed int v1:7; signed char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFs7s { signed int v1:7; signed char v2:7; signed short v3:7; };
struct BFs7i_BFs7c_BFs7s_BFs7c { signed int v1:7; signed char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFs7s_BFs7i { signed int v1:7; signed char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFs7s_BFs7ll { signed int v1:7; signed char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFs7s_BFs7s { signed int v1:7; signed char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFs7s_BFu7c { signed int v1:7; signed char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFs7s_BFu7i { signed int v1:7; signed char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFs7s_BFu7ll { signed int v1:7; signed char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFs7s_BFu7s { signed int v1:7; signed char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFu7c { signed int v1:7; signed char v2:7; unsigned char v3:7; };
struct BFs7i_BFs7c_BFu7c_BFs7c { signed int v1:7; signed char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFu7c_BFs7i { signed int v1:7; signed char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFu7c_BFs7ll { signed int v1:7; signed char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFu7c_BFs7s { signed int v1:7; signed char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFu7c_BFu7c { signed int v1:7; signed char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFu7c_BFu7i { signed int v1:7; signed char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFu7c_BFu7ll { signed int v1:7; signed char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFu7c_BFu7s { signed int v1:7; signed char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFu7i { signed int v1:7; signed char v2:7; unsigned int v3:7; };
struct BFs7i_BFs7c_BFu7i_BFs7c { signed int v1:7; signed char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFu7i_BFs7i { signed int v1:7; signed char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFu7i_BFs7ll { signed int v1:7; signed char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFu7i_BFs7s { signed int v1:7; signed char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFu7i_BFu7c { signed int v1:7; signed char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFu7i_BFu7i { signed int v1:7; signed char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFu7i_BFu7ll { signed int v1:7; signed char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFu7i_BFu7s { signed int v1:7; signed char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFu7ll { signed int v1:7; signed char v2:7; unsigned long long v3:7; };
struct BFs7i_BFs7c_BFu7ll_BFs7c { signed int v1:7; signed char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFs7i { signed int v1:7; signed char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFs7ll { signed int v1:7; signed char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFs7s { signed int v1:7; signed char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFu7c { signed int v1:7; signed char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFu7i { signed int v1:7; signed char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFu7ll { signed int v1:7; signed char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFu7ll_BFu7s { signed int v1:7; signed char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7c_BFu7s { signed int v1:7; signed char v2:7; unsigned short v3:7; };
struct BFs7i_BFs7c_BFu7s_BFs7c { signed int v1:7; signed char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFs7c_BFu7s_BFs7i { signed int v1:7; signed char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFs7c_BFu7s_BFs7ll { signed int v1:7; signed char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFs7c_BFu7s_BFs7s { signed int v1:7; signed char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFs7c_BFu7s_BFu7c { signed int v1:7; signed char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7c_BFu7s_BFu7i { signed int v1:7; signed char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7c_BFu7s_BFu7ll { signed int v1:7; signed char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7c_BFu7s_BFu7s { signed int v1:7; signed char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i { signed int v1:7; signed int v2:7; };
struct BFs7i_BFs7i_BFs7c { signed int v1:7; signed int v2:7; signed char v3:7; };
struct BFs7i_BFs7i_BFs7c_BFs7c { signed int v1:7; signed int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFs7c_BFs7i { signed int v1:7; signed int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFs7c_BFs7ll { signed int v1:7; signed int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFs7c_BFs7s { signed int v1:7; signed int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFs7c_BFu7c { signed int v1:7; signed int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFs7c_BFu7i { signed int v1:7; signed int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFs7c_BFu7ll { signed int v1:7; signed int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFs7c_BFu7s { signed int v1:7; signed int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFs7i { signed int v1:7; signed int v2:7; signed int v3:7; };
struct BFs7i_BFs7i_BFs7i_BFs7c { signed int v1:7; signed int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFs7i_BFs7i { signed int v1:7; signed int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFs7i_BFs7ll { signed int v1:7; signed int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFs7i_BFs7s { signed int v1:7; signed int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFs7i_BFu7c { signed int v1:7; signed int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFs7i_BFu7i { signed int v1:7; signed int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFs7i_BFu7ll { signed int v1:7; signed int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFs7i_BFu7s { signed int v1:7; signed int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFs7ll { signed int v1:7; signed int v2:7; signed long long v3:7; };
struct BFs7i_BFs7i_BFs7ll_BFs7c { signed int v1:7; signed int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFs7i { signed int v1:7; signed int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFs7ll { signed int v1:7; signed int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFs7s { signed int v1:7; signed int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFu7c { signed int v1:7; signed int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFu7i { signed int v1:7; signed int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFu7ll { signed int v1:7; signed int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFs7ll_BFu7s { signed int v1:7; signed int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFs7s { signed int v1:7; signed int v2:7; signed short v3:7; };
struct BFs7i_BFs7i_BFs7s_BFs7c { signed int v1:7; signed int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFs7s_BFs7i { signed int v1:7; signed int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFs7s_BFs7ll { signed int v1:7; signed int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFs7s_BFs7s { signed int v1:7; signed int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFs7s_BFu7c { signed int v1:7; signed int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFs7s_BFu7i { signed int v1:7; signed int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFs7s_BFu7ll { signed int v1:7; signed int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFs7s_BFu7s { signed int v1:7; signed int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFu7c { signed int v1:7; signed int v2:7; unsigned char v3:7; };
struct BFs7i_BFs7i_BFu7c_BFs7c { signed int v1:7; signed int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFu7c_BFs7i { signed int v1:7; signed int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFu7c_BFs7ll { signed int v1:7; signed int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFu7c_BFs7s { signed int v1:7; signed int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFu7c_BFu7c { signed int v1:7; signed int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFu7c_BFu7i { signed int v1:7; signed int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFu7c_BFu7ll { signed int v1:7; signed int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFu7c_BFu7s { signed int v1:7; signed int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFu7i { signed int v1:7; signed int v2:7; unsigned int v3:7; };
struct BFs7i_BFs7i_BFu7i_BFs7c { signed int v1:7; signed int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFu7i_BFs7i { signed int v1:7; signed int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFu7i_BFs7ll { signed int v1:7; signed int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFu7i_BFs7s { signed int v1:7; signed int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFu7i_BFu7c { signed int v1:7; signed int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFu7i_BFu7i { signed int v1:7; signed int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFu7i_BFu7ll { signed int v1:7; signed int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFu7i_BFu7s { signed int v1:7; signed int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFu7ll { signed int v1:7; signed int v2:7; unsigned long long v3:7; };
struct BFs7i_BFs7i_BFu7ll_BFs7c { signed int v1:7; signed int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFs7i { signed int v1:7; signed int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFs7ll { signed int v1:7; signed int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFs7s { signed int v1:7; signed int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFu7c { signed int v1:7; signed int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFu7i { signed int v1:7; signed int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFu7ll { signed int v1:7; signed int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFu7ll_BFu7s { signed int v1:7; signed int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7i_BFu7s { signed int v1:7; signed int v2:7; unsigned short v3:7; };
struct BFs7i_BFs7i_BFu7s_BFs7c { signed int v1:7; signed int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFs7i_BFu7s_BFs7i { signed int v1:7; signed int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFs7i_BFu7s_BFs7ll { signed int v1:7; signed int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFs7i_BFu7s_BFs7s { signed int v1:7; signed int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFs7i_BFu7s_BFu7c { signed int v1:7; signed int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7i_BFu7s_BFu7i { signed int v1:7; signed int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7i_BFu7s_BFu7ll { signed int v1:7; signed int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7i_BFu7s_BFu7s { signed int v1:7; signed int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll { signed int v1:7; signed long long v2:7; };
struct BFs7i_BFs7ll_BFs7c { signed int v1:7; signed long long v2:7; signed char v3:7; };
struct BFs7i_BFs7ll_BFs7c_BFs7c { signed int v1:7; signed long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFs7i { signed int v1:7; signed long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFs7ll { signed int v1:7; signed long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFs7s { signed int v1:7; signed long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFu7c { signed int v1:7; signed long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFu7i { signed int v1:7; signed long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFu7ll { signed int v1:7; signed long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFs7c_BFu7s { signed int v1:7; signed long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFs7i { signed int v1:7; signed long long v2:7; signed int v3:7; };
struct BFs7i_BFs7ll_BFs7i_BFs7c { signed int v1:7; signed long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFs7i { signed int v1:7; signed long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFs7ll { signed int v1:7; signed long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFs7s { signed int v1:7; signed long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFu7c { signed int v1:7; signed long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFu7i { signed int v1:7; signed long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFu7ll { signed int v1:7; signed long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFs7i_BFu7s { signed int v1:7; signed long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFs7ll { signed int v1:7; signed long long v2:7; signed long long v3:7; };
struct BFs7i_BFs7ll_BFs7ll_BFs7c { signed int v1:7; signed long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFs7i { signed int v1:7; signed long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFs7ll { signed int v1:7; signed long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFs7s { signed int v1:7; signed long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFu7c { signed int v1:7; signed long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFu7i { signed int v1:7; signed long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFu7ll { signed int v1:7; signed long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFs7ll_BFu7s { signed int v1:7; signed long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFs7s { signed int v1:7; signed long long v2:7; signed short v3:7; };
struct BFs7i_BFs7ll_BFs7s_BFs7c { signed int v1:7; signed long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFs7i { signed int v1:7; signed long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFs7ll { signed int v1:7; signed long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFs7s { signed int v1:7; signed long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFu7c { signed int v1:7; signed long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFu7i { signed int v1:7; signed long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFu7ll { signed int v1:7; signed long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFs7s_BFu7s { signed int v1:7; signed long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFu7c { signed int v1:7; signed long long v2:7; unsigned char v3:7; };
struct BFs7i_BFs7ll_BFu7c_BFs7c { signed int v1:7; signed long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFs7i { signed int v1:7; signed long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFs7ll { signed int v1:7; signed long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFs7s { signed int v1:7; signed long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFu7c { signed int v1:7; signed long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFu7i { signed int v1:7; signed long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFu7ll { signed int v1:7; signed long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFu7c_BFu7s { signed int v1:7; signed long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFu7i { signed int v1:7; signed long long v2:7; unsigned int v3:7; };
struct BFs7i_BFs7ll_BFu7i_BFs7c { signed int v1:7; signed long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFs7i { signed int v1:7; signed long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFs7ll { signed int v1:7; signed long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFs7s { signed int v1:7; signed long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFu7c { signed int v1:7; signed long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFu7i { signed int v1:7; signed long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFu7ll { signed int v1:7; signed long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFu7i_BFu7s { signed int v1:7; signed long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFu7ll { signed int v1:7; signed long long v2:7; unsigned long long v3:7; };
struct BFs7i_BFs7ll_BFu7ll_BFs7c { signed int v1:7; signed long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFs7i { signed int v1:7; signed long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFs7ll { signed int v1:7; signed long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFs7s { signed int v1:7; signed long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFu7c { signed int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFu7i { signed int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFu7ll { signed int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFu7ll_BFu7s { signed int v1:7; signed long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7ll_BFu7s { signed int v1:7; signed long long v2:7; unsigned short v3:7; };
struct BFs7i_BFs7ll_BFu7s_BFs7c { signed int v1:7; signed long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFs7i { signed int v1:7; signed long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFs7ll { signed int v1:7; signed long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFs7s { signed int v1:7; signed long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFu7c { signed int v1:7; signed long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFu7i { signed int v1:7; signed long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFu7ll { signed int v1:7; signed long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7ll_BFu7s_BFu7s { signed int v1:7; signed long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s { signed int v1:7; signed short v2:7; };
struct BFs7i_BFs7s_BFs7c { signed int v1:7; signed short v2:7; signed char v3:7; };
struct BFs7i_BFs7s_BFs7c_BFs7c { signed int v1:7; signed short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFs7c_BFs7i { signed int v1:7; signed short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFs7c_BFs7ll { signed int v1:7; signed short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFs7c_BFs7s { signed int v1:7; signed short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFs7c_BFu7c { signed int v1:7; signed short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFs7c_BFu7i { signed int v1:7; signed short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFs7c_BFu7ll { signed int v1:7; signed short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFs7c_BFu7s { signed int v1:7; signed short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFs7i { signed int v1:7; signed short v2:7; signed int v3:7; };
struct BFs7i_BFs7s_BFs7i_BFs7c { signed int v1:7; signed short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFs7i_BFs7i { signed int v1:7; signed short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFs7i_BFs7ll { signed int v1:7; signed short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFs7i_BFs7s { signed int v1:7; signed short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFs7i_BFu7c { signed int v1:7; signed short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFs7i_BFu7i { signed int v1:7; signed short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFs7i_BFu7ll { signed int v1:7; signed short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFs7i_BFu7s { signed int v1:7; signed short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFs7ll { signed int v1:7; signed short v2:7; signed long long v3:7; };
struct BFs7i_BFs7s_BFs7ll_BFs7c { signed int v1:7; signed short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFs7i { signed int v1:7; signed short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFs7ll { signed int v1:7; signed short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFs7s { signed int v1:7; signed short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFu7c { signed int v1:7; signed short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFu7i { signed int v1:7; signed short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFu7ll { signed int v1:7; signed short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFs7ll_BFu7s { signed int v1:7; signed short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFs7s { signed int v1:7; signed short v2:7; signed short v3:7; };
struct BFs7i_BFs7s_BFs7s_BFs7c { signed int v1:7; signed short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFs7s_BFs7i { signed int v1:7; signed short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFs7s_BFs7ll { signed int v1:7; signed short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFs7s_BFs7s { signed int v1:7; signed short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFs7s_BFu7c { signed int v1:7; signed short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFs7s_BFu7i { signed int v1:7; signed short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFs7s_BFu7ll { signed int v1:7; signed short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFs7s_BFu7s { signed int v1:7; signed short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFu7c { signed int v1:7; signed short v2:7; unsigned char v3:7; };
struct BFs7i_BFs7s_BFu7c_BFs7c { signed int v1:7; signed short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFu7c_BFs7i { signed int v1:7; signed short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFu7c_BFs7ll { signed int v1:7; signed short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFu7c_BFs7s { signed int v1:7; signed short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFu7c_BFu7c { signed int v1:7; signed short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFu7c_BFu7i { signed int v1:7; signed short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFu7c_BFu7ll { signed int v1:7; signed short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFu7c_BFu7s { signed int v1:7; signed short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFu7i { signed int v1:7; signed short v2:7; unsigned int v3:7; };
struct BFs7i_BFs7s_BFu7i_BFs7c { signed int v1:7; signed short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFu7i_BFs7i { signed int v1:7; signed short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFu7i_BFs7ll { signed int v1:7; signed short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFu7i_BFs7s { signed int v1:7; signed short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFu7i_BFu7c { signed int v1:7; signed short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFu7i_BFu7i { signed int v1:7; signed short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFu7i_BFu7ll { signed int v1:7; signed short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFu7i_BFu7s { signed int v1:7; signed short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFu7ll { signed int v1:7; signed short v2:7; unsigned long long v3:7; };
struct BFs7i_BFs7s_BFu7ll_BFs7c { signed int v1:7; signed short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFs7i { signed int v1:7; signed short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFs7ll { signed int v1:7; signed short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFs7s { signed int v1:7; signed short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFu7c { signed int v1:7; signed short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFu7i { signed int v1:7; signed short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFu7ll { signed int v1:7; signed short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFu7ll_BFu7s { signed int v1:7; signed short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFs7s_BFu7s { signed int v1:7; signed short v2:7; unsigned short v3:7; };
struct BFs7i_BFs7s_BFu7s_BFs7c { signed int v1:7; signed short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFs7s_BFu7s_BFs7i { signed int v1:7; signed short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFs7s_BFu7s_BFs7ll { signed int v1:7; signed short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFs7s_BFu7s_BFs7s { signed int v1:7; signed short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFs7s_BFu7s_BFu7c { signed int v1:7; signed short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFs7s_BFu7s_BFu7i { signed int v1:7; signed short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFs7s_BFu7s_BFu7ll { signed int v1:7; signed short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFs7s_BFu7s_BFu7s { signed int v1:7; signed short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c { signed int v1:7; unsigned char v2:7; };
struct BFs7i_BFu7c_BFs7c { signed int v1:7; unsigned char v2:7; signed char v3:7; };
struct BFs7i_BFu7c_BFs7c_BFs7c { signed int v1:7; unsigned char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFs7c_BFs7i { signed int v1:7; unsigned char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFs7c_BFs7ll { signed int v1:7; unsigned char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFs7c_BFs7s { signed int v1:7; unsigned char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFs7c_BFu7c { signed int v1:7; unsigned char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFs7c_BFu7i { signed int v1:7; unsigned char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFs7c_BFu7ll { signed int v1:7; unsigned char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFs7c_BFu7s { signed int v1:7; unsigned char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFs7i { signed int v1:7; unsigned char v2:7; signed int v3:7; };
struct BFs7i_BFu7c_BFs7i_BFs7c { signed int v1:7; unsigned char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFs7i_BFs7i { signed int v1:7; unsigned char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFs7i_BFs7ll { signed int v1:7; unsigned char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFs7i_BFs7s { signed int v1:7; unsigned char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFs7i_BFu7c { signed int v1:7; unsigned char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFs7i_BFu7i { signed int v1:7; unsigned char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFs7i_BFu7ll { signed int v1:7; unsigned char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFs7i_BFu7s { signed int v1:7; unsigned char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFs7ll { signed int v1:7; unsigned char v2:7; signed long long v3:7; };
struct BFs7i_BFu7c_BFs7ll_BFs7c { signed int v1:7; unsigned char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFs7i { signed int v1:7; unsigned char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFs7ll { signed int v1:7; unsigned char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFs7s { signed int v1:7; unsigned char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFu7c { signed int v1:7; unsigned char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFu7i { signed int v1:7; unsigned char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFu7ll { signed int v1:7; unsigned char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFs7ll_BFu7s { signed int v1:7; unsigned char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFs7s { signed int v1:7; unsigned char v2:7; signed short v3:7; };
struct BFs7i_BFu7c_BFs7s_BFs7c { signed int v1:7; unsigned char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFs7s_BFs7i { signed int v1:7; unsigned char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFs7s_BFs7ll { signed int v1:7; unsigned char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFs7s_BFs7s { signed int v1:7; unsigned char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFs7s_BFu7c { signed int v1:7; unsigned char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFs7s_BFu7i { signed int v1:7; unsigned char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFs7s_BFu7ll { signed int v1:7; unsigned char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFs7s_BFu7s { signed int v1:7; unsigned char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFu7c { signed int v1:7; unsigned char v2:7; unsigned char v3:7; };
struct BFs7i_BFu7c_BFu7c_BFs7c { signed int v1:7; unsigned char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFu7c_BFs7i { signed int v1:7; unsigned char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFu7c_BFs7ll { signed int v1:7; unsigned char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFu7c_BFs7s { signed int v1:7; unsigned char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFu7c_BFu7c { signed int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFu7c_BFu7i { signed int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFu7c_BFu7ll { signed int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFu7c_BFu7s { signed int v1:7; unsigned char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFu7i { signed int v1:7; unsigned char v2:7; unsigned int v3:7; };
struct BFs7i_BFu7c_BFu7i_BFs7c { signed int v1:7; unsigned char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFu7i_BFs7i { signed int v1:7; unsigned char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFu7i_BFs7ll { signed int v1:7; unsigned char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFu7i_BFs7s { signed int v1:7; unsigned char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFu7i_BFu7c { signed int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFu7i_BFu7i { signed int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFu7i_BFu7ll { signed int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFu7i_BFu7s { signed int v1:7; unsigned char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFu7ll { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; };
struct BFs7i_BFu7c_BFu7ll_BFs7c { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFs7i { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFs7ll { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFs7s { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFu7c { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFu7i { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFu7ll { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFu7ll_BFu7s { signed int v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7c_BFu7s { signed int v1:7; unsigned char v2:7; unsigned short v3:7; };
struct BFs7i_BFu7c_BFu7s_BFs7c { signed int v1:7; unsigned char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFu7c_BFu7s_BFs7i { signed int v1:7; unsigned char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFu7c_BFu7s_BFs7ll { signed int v1:7; unsigned char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFu7c_BFu7s_BFs7s { signed int v1:7; unsigned char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFu7c_BFu7s_BFu7c { signed int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7c_BFu7s_BFu7i { signed int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7c_BFu7s_BFu7ll { signed int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7c_BFu7s_BFu7s { signed int v1:7; unsigned char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i { signed int v1:7; unsigned int v2:7; };
struct BFs7i_BFu7i_BFs7c { signed int v1:7; unsigned int v2:7; signed char v3:7; };
struct BFs7i_BFu7i_BFs7c_BFs7c { signed int v1:7; unsigned int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFs7c_BFs7i { signed int v1:7; unsigned int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFs7c_BFs7ll { signed int v1:7; unsigned int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFs7c_BFs7s { signed int v1:7; unsigned int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFs7c_BFu7c { signed int v1:7; unsigned int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFs7c_BFu7i { signed int v1:7; unsigned int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFs7c_BFu7ll { signed int v1:7; unsigned int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFs7c_BFu7s { signed int v1:7; unsigned int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFs7i { signed int v1:7; unsigned int v2:7; signed int v3:7; };
struct BFs7i_BFu7i_BFs7i_BFs7c { signed int v1:7; unsigned int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFs7i_BFs7i { signed int v1:7; unsigned int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFs7i_BFs7ll { signed int v1:7; unsigned int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFs7i_BFs7s { signed int v1:7; unsigned int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFs7i_BFu7c { signed int v1:7; unsigned int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFs7i_BFu7i { signed int v1:7; unsigned int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFs7i_BFu7ll { signed int v1:7; unsigned int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFs7i_BFu7s { signed int v1:7; unsigned int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFs7ll { signed int v1:7; unsigned int v2:7; signed long long v3:7; };
struct BFs7i_BFu7i_BFs7ll_BFs7c { signed int v1:7; unsigned int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFs7i { signed int v1:7; unsigned int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFs7ll { signed int v1:7; unsigned int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFs7s { signed int v1:7; unsigned int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFu7c { signed int v1:7; unsigned int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFu7i { signed int v1:7; unsigned int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFu7ll { signed int v1:7; unsigned int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFs7ll_BFu7s { signed int v1:7; unsigned int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFs7s { signed int v1:7; unsigned int v2:7; signed short v3:7; };
struct BFs7i_BFu7i_BFs7s_BFs7c { signed int v1:7; unsigned int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFs7s_BFs7i { signed int v1:7; unsigned int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFs7s_BFs7ll { signed int v1:7; unsigned int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFs7s_BFs7s { signed int v1:7; unsigned int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFs7s_BFu7c { signed int v1:7; unsigned int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFs7s_BFu7i { signed int v1:7; unsigned int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFs7s_BFu7ll { signed int v1:7; unsigned int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFs7s_BFu7s { signed int v1:7; unsigned int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFu7c { signed int v1:7; unsigned int v2:7; unsigned char v3:7; };
struct BFs7i_BFu7i_BFu7c_BFs7c { signed int v1:7; unsigned int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFu7c_BFs7i { signed int v1:7; unsigned int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFu7c_BFs7ll { signed int v1:7; unsigned int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFu7c_BFs7s { signed int v1:7; unsigned int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFu7c_BFu7c { signed int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFu7c_BFu7i { signed int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFu7c_BFu7ll { signed int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFu7c_BFu7s { signed int v1:7; unsigned int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFu7i { signed int v1:7; unsigned int v2:7; unsigned int v3:7; };
struct BFs7i_BFu7i_BFu7i_BFs7c { signed int v1:7; unsigned int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFu7i_BFs7i { signed int v1:7; unsigned int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFu7i_BFs7ll { signed int v1:7; unsigned int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFu7i_BFs7s { signed int v1:7; unsigned int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFu7i_BFu7c { signed int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFu7i_BFu7i { signed int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFu7i_BFu7ll { signed int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFu7i_BFu7s { signed int v1:7; unsigned int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFu7ll { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; };
struct BFs7i_BFu7i_BFu7ll_BFs7c { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFs7i { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFs7ll { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFs7s { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFu7c { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFu7i { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFu7ll { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFu7ll_BFu7s { signed int v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7i_BFu7s { signed int v1:7; unsigned int v2:7; unsigned short v3:7; };
struct BFs7i_BFu7i_BFu7s_BFs7c { signed int v1:7; unsigned int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFu7i_BFu7s_BFs7i { signed int v1:7; unsigned int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFu7i_BFu7s_BFs7ll { signed int v1:7; unsigned int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFu7i_BFu7s_BFs7s { signed int v1:7; unsigned int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFu7i_BFu7s_BFu7c { signed int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7i_BFu7s_BFu7i { signed int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7i_BFu7s_BFu7ll { signed int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7i_BFu7s_BFu7s { signed int v1:7; unsigned int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll { signed int v1:7; unsigned long long v2:7; };
struct BFs7i_BFu7ll_BFs7c { signed int v1:7; unsigned long long v2:7; signed char v3:7; };
struct BFs7i_BFu7ll_BFs7c_BFs7c { signed int v1:7; unsigned long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFs7i { signed int v1:7; unsigned long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFs7ll { signed int v1:7; unsigned long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFs7s { signed int v1:7; unsigned long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFu7c { signed int v1:7; unsigned long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFu7i { signed int v1:7; unsigned long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFu7ll { signed int v1:7; unsigned long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFs7c_BFu7s { signed int v1:7; unsigned long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFs7i { signed int v1:7; unsigned long long v2:7; signed int v3:7; };
struct BFs7i_BFu7ll_BFs7i_BFs7c { signed int v1:7; unsigned long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFs7i { signed int v1:7; unsigned long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFs7ll { signed int v1:7; unsigned long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFs7s { signed int v1:7; unsigned long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFu7c { signed int v1:7; unsigned long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFu7i { signed int v1:7; unsigned long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFu7ll { signed int v1:7; unsigned long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFs7i_BFu7s { signed int v1:7; unsigned long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFs7ll { signed int v1:7; unsigned long long v2:7; signed long long v3:7; };
struct BFs7i_BFu7ll_BFs7ll_BFs7c { signed int v1:7; unsigned long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFs7i { signed int v1:7; unsigned long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFs7ll { signed int v1:7; unsigned long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFs7s { signed int v1:7; unsigned long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFu7c { signed int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFu7i { signed int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFu7ll { signed int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFs7ll_BFu7s { signed int v1:7; unsigned long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFs7s { signed int v1:7; unsigned long long v2:7; signed short v3:7; };
struct BFs7i_BFu7ll_BFs7s_BFs7c { signed int v1:7; unsigned long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFs7i { signed int v1:7; unsigned long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFs7ll { signed int v1:7; unsigned long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFs7s { signed int v1:7; unsigned long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFu7c { signed int v1:7; unsigned long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFu7i { signed int v1:7; unsigned long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFu7ll { signed int v1:7; unsigned long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFs7s_BFu7s { signed int v1:7; unsigned long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFu7c { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; };
struct BFs7i_BFu7ll_BFu7c_BFs7c { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFs7i { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFs7ll { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFs7s { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFu7c { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFu7i { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFu7ll { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFu7c_BFu7s { signed int v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFu7i { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; };
struct BFs7i_BFu7ll_BFu7i_BFs7c { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFs7i { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFs7ll { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFs7s { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFu7c { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFu7i { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFu7ll { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFu7i_BFu7s { signed int v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFu7ll { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; };
struct BFs7i_BFu7ll_BFu7ll_BFs7c { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFs7i { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFs7ll { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFs7s { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFu7c { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFu7i { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFu7ll { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFu7ll_BFu7s { signed int v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7ll_BFu7s { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; };
struct BFs7i_BFu7ll_BFu7s_BFs7c { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFs7i { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFs7ll { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFs7s { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFu7c { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFu7i { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFu7ll { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7ll_BFu7s_BFu7s { signed int v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s { signed int v1:7; unsigned short v2:7; };
struct BFs7i_BFu7s_BFs7c { signed int v1:7; unsigned short v2:7; signed char v3:7; };
struct BFs7i_BFu7s_BFs7c_BFs7c { signed int v1:7; unsigned short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFs7c_BFs7i { signed int v1:7; unsigned short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFs7c_BFs7ll { signed int v1:7; unsigned short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFs7c_BFs7s { signed int v1:7; unsigned short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFs7c_BFu7c { signed int v1:7; unsigned short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFs7c_BFu7i { signed int v1:7; unsigned short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFs7c_BFu7ll { signed int v1:7; unsigned short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFs7c_BFu7s { signed int v1:7; unsigned short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFs7i { signed int v1:7; unsigned short v2:7; signed int v3:7; };
struct BFs7i_BFu7s_BFs7i_BFs7c { signed int v1:7; unsigned short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFs7i_BFs7i { signed int v1:7; unsigned short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFs7i_BFs7ll { signed int v1:7; unsigned short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFs7i_BFs7s { signed int v1:7; unsigned short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFs7i_BFu7c { signed int v1:7; unsigned short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFs7i_BFu7i { signed int v1:7; unsigned short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFs7i_BFu7ll { signed int v1:7; unsigned short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFs7i_BFu7s { signed int v1:7; unsigned short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFs7ll { signed int v1:7; unsigned short v2:7; signed long long v3:7; };
struct BFs7i_BFu7s_BFs7ll_BFs7c { signed int v1:7; unsigned short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFs7i { signed int v1:7; unsigned short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFs7ll { signed int v1:7; unsigned short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFs7s { signed int v1:7; unsigned short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFu7c { signed int v1:7; unsigned short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFu7i { signed int v1:7; unsigned short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFu7ll { signed int v1:7; unsigned short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFs7ll_BFu7s { signed int v1:7; unsigned short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFs7s { signed int v1:7; unsigned short v2:7; signed short v3:7; };
struct BFs7i_BFu7s_BFs7s_BFs7c { signed int v1:7; unsigned short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFs7s_BFs7i { signed int v1:7; unsigned short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFs7s_BFs7ll { signed int v1:7; unsigned short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFs7s_BFs7s { signed int v1:7; unsigned short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFs7s_BFu7c { signed int v1:7; unsigned short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFs7s_BFu7i { signed int v1:7; unsigned short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFs7s_BFu7ll { signed int v1:7; unsigned short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFs7s_BFu7s { signed int v1:7; unsigned short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFu7c { signed int v1:7; unsigned short v2:7; unsigned char v3:7; };
struct BFs7i_BFu7s_BFu7c_BFs7c { signed int v1:7; unsigned short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFu7c_BFs7i { signed int v1:7; unsigned short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFu7c_BFs7ll { signed int v1:7; unsigned short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFu7c_BFs7s { signed int v1:7; unsigned short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFu7c_BFu7c { signed int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFu7c_BFu7i { signed int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFu7c_BFu7ll { signed int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFu7c_BFu7s { signed int v1:7; unsigned short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFu7i { signed int v1:7; unsigned short v2:7; unsigned int v3:7; };
struct BFs7i_BFu7s_BFu7i_BFs7c { signed int v1:7; unsigned short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFu7i_BFs7i { signed int v1:7; unsigned short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFu7i_BFs7ll { signed int v1:7; unsigned short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFu7i_BFs7s { signed int v1:7; unsigned short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFu7i_BFu7c { signed int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFu7i_BFu7i { signed int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFu7i_BFu7ll { signed int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFu7i_BFu7s { signed int v1:7; unsigned short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFu7ll { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; };
struct BFs7i_BFu7s_BFu7ll_BFs7c { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFs7i { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFs7ll { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFs7s { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFu7c { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFu7i { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFu7ll { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFu7ll_BFu7s { signed int v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7i_BFu7s_BFu7s { signed int v1:7; unsigned short v2:7; unsigned short v3:7; };
struct BFs7i_BFu7s_BFu7s_BFs7c { signed int v1:7; unsigned short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7i_BFu7s_BFu7s_BFs7i { signed int v1:7; unsigned short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7i_BFu7s_BFu7s_BFs7ll { signed int v1:7; unsigned short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7i_BFu7s_BFu7s_BFs7s { signed int v1:7; unsigned short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7i_BFu7s_BFu7s_BFu7c { signed int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7i_BFu7s_BFu7s_BFu7i { signed int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7i_BFu7s_BFu7s_BFu7ll { signed int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7i_BFu7s_BFu7s_BFu7s { signed int v1:7; unsigned short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c { signed long long v1:7; signed char v2:7; };
struct BFs7ll_BFs7c_BFs7c { signed long long v1:7; signed char v2:7; signed char v3:7; };
struct BFs7ll_BFs7c_BFs7c_BFs7c { signed long long v1:7; signed char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFs7i { signed long long v1:7; signed char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFs7ll { signed long long v1:7; signed char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFs7s { signed long long v1:7; signed char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFu7c { signed long long v1:7; signed char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFu7i { signed long long v1:7; signed char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFu7ll { signed long long v1:7; signed char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFs7c_BFu7s { signed long long v1:7; signed char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFs7i { signed long long v1:7; signed char v2:7; signed int v3:7; };
struct BFs7ll_BFs7c_BFs7i_BFs7c { signed long long v1:7; signed char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFs7i { signed long long v1:7; signed char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFs7ll { signed long long v1:7; signed char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFs7s { signed long long v1:7; signed char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFu7c { signed long long v1:7; signed char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFu7i { signed long long v1:7; signed char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFu7ll { signed long long v1:7; signed char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFs7i_BFu7s { signed long long v1:7; signed char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFs7ll { signed long long v1:7; signed char v2:7; signed long long v3:7; };
struct BFs7ll_BFs7c_BFs7ll_BFs7c { signed long long v1:7; signed char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFs7i { signed long long v1:7; signed char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFs7ll { signed long long v1:7; signed char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFs7s { signed long long v1:7; signed char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFu7c { signed long long v1:7; signed char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFu7i { signed long long v1:7; signed char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFu7ll { signed long long v1:7; signed char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFs7ll_BFu7s { signed long long v1:7; signed char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFs7s { signed long long v1:7; signed char v2:7; signed short v3:7; };
struct BFs7ll_BFs7c_BFs7s_BFs7c { signed long long v1:7; signed char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFs7i { signed long long v1:7; signed char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFs7ll { signed long long v1:7; signed char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFs7s { signed long long v1:7; signed char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFu7c { signed long long v1:7; signed char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFu7i { signed long long v1:7; signed char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFu7ll { signed long long v1:7; signed char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFs7s_BFu7s { signed long long v1:7; signed char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFu7c { signed long long v1:7; signed char v2:7; unsigned char v3:7; };
struct BFs7ll_BFs7c_BFu7c_BFs7c { signed long long v1:7; signed char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFs7i { signed long long v1:7; signed char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFs7ll { signed long long v1:7; signed char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFs7s { signed long long v1:7; signed char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFu7c { signed long long v1:7; signed char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFu7i { signed long long v1:7; signed char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFu7ll { signed long long v1:7; signed char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFu7c_BFu7s { signed long long v1:7; signed char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFu7i { signed long long v1:7; signed char v2:7; unsigned int v3:7; };
struct BFs7ll_BFs7c_BFu7i_BFs7c { signed long long v1:7; signed char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFs7i { signed long long v1:7; signed char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFs7ll { signed long long v1:7; signed char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFs7s { signed long long v1:7; signed char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFu7c { signed long long v1:7; signed char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFu7i { signed long long v1:7; signed char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFu7ll { signed long long v1:7; signed char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFu7i_BFu7s { signed long long v1:7; signed char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFu7ll { signed long long v1:7; signed char v2:7; unsigned long long v3:7; };
struct BFs7ll_BFs7c_BFu7ll_BFs7c { signed long long v1:7; signed char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFs7i { signed long long v1:7; signed char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFs7ll { signed long long v1:7; signed char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFs7s { signed long long v1:7; signed char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFu7c { signed long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFu7i { signed long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFu7ll { signed long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFu7ll_BFu7s { signed long long v1:7; signed char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7c_BFu7s { signed long long v1:7; signed char v2:7; unsigned short v3:7; };
struct BFs7ll_BFs7c_BFu7s_BFs7c { signed long long v1:7; signed char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFs7i { signed long long v1:7; signed char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFs7ll { signed long long v1:7; signed char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFs7s { signed long long v1:7; signed char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFu7c { signed long long v1:7; signed char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFu7i { signed long long v1:7; signed char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFu7ll { signed long long v1:7; signed char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7c_BFu7s_BFu7s { signed long long v1:7; signed char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i { signed long long v1:7; signed int v2:7; };
struct BFs7ll_BFs7i_BFs7c { signed long long v1:7; signed int v2:7; signed char v3:7; };
struct BFs7ll_BFs7i_BFs7c_BFs7c { signed long long v1:7; signed int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFs7i { signed long long v1:7; signed int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFs7ll { signed long long v1:7; signed int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFs7s { signed long long v1:7; signed int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFu7c { signed long long v1:7; signed int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFu7i { signed long long v1:7; signed int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFu7ll { signed long long v1:7; signed int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFs7c_BFu7s { signed long long v1:7; signed int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFs7i { signed long long v1:7; signed int v2:7; signed int v3:7; };
struct BFs7ll_BFs7i_BFs7i_BFs7c { signed long long v1:7; signed int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFs7i { signed long long v1:7; signed int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFs7ll { signed long long v1:7; signed int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFs7s { signed long long v1:7; signed int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFu7c { signed long long v1:7; signed int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFu7i { signed long long v1:7; signed int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFu7ll { signed long long v1:7; signed int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFs7i_BFu7s { signed long long v1:7; signed int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFs7ll { signed long long v1:7; signed int v2:7; signed long long v3:7; };
struct BFs7ll_BFs7i_BFs7ll_BFs7c { signed long long v1:7; signed int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFs7i { signed long long v1:7; signed int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFs7ll { signed long long v1:7; signed int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFs7s { signed long long v1:7; signed int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFu7c { signed long long v1:7; signed int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFu7i { signed long long v1:7; signed int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFu7ll { signed long long v1:7; signed int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFs7ll_BFu7s { signed long long v1:7; signed int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFs7s { signed long long v1:7; signed int v2:7; signed short v3:7; };
struct BFs7ll_BFs7i_BFs7s_BFs7c { signed long long v1:7; signed int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFs7i { signed long long v1:7; signed int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFs7ll { signed long long v1:7; signed int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFs7s { signed long long v1:7; signed int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFu7c { signed long long v1:7; signed int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFu7i { signed long long v1:7; signed int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFu7ll { signed long long v1:7; signed int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFs7s_BFu7s { signed long long v1:7; signed int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFu7c { signed long long v1:7; signed int v2:7; unsigned char v3:7; };
struct BFs7ll_BFs7i_BFu7c_BFs7c { signed long long v1:7; signed int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFs7i { signed long long v1:7; signed int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFs7ll { signed long long v1:7; signed int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFs7s { signed long long v1:7; signed int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFu7c { signed long long v1:7; signed int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFu7i { signed long long v1:7; signed int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFu7ll { signed long long v1:7; signed int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFu7c_BFu7s { signed long long v1:7; signed int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFu7i { signed long long v1:7; signed int v2:7; unsigned int v3:7; };
struct BFs7ll_BFs7i_BFu7i_BFs7c { signed long long v1:7; signed int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFs7i { signed long long v1:7; signed int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFs7ll { signed long long v1:7; signed int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFs7s { signed long long v1:7; signed int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFu7c { signed long long v1:7; signed int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFu7i { signed long long v1:7; signed int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFu7ll { signed long long v1:7; signed int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFu7i_BFu7s { signed long long v1:7; signed int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFu7ll { signed long long v1:7; signed int v2:7; unsigned long long v3:7; };
struct BFs7ll_BFs7i_BFu7ll_BFs7c { signed long long v1:7; signed int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFs7i { signed long long v1:7; signed int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFs7ll { signed long long v1:7; signed int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFs7s { signed long long v1:7; signed int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFu7c { signed long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFu7i { signed long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFu7ll { signed long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFu7ll_BFu7s { signed long long v1:7; signed int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7i_BFu7s { signed long long v1:7; signed int v2:7; unsigned short v3:7; };
struct BFs7ll_BFs7i_BFu7s_BFs7c { signed long long v1:7; signed int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFs7i { signed long long v1:7; signed int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFs7ll { signed long long v1:7; signed int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFs7s { signed long long v1:7; signed int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFu7c { signed long long v1:7; signed int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFu7i { signed long long v1:7; signed int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFu7ll { signed long long v1:7; signed int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7i_BFu7s_BFu7s { signed long long v1:7; signed int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll { signed long long v1:7; signed long long v2:7; };
struct BFs7ll_BFs7ll_BFs7c { signed long long v1:7; signed long long v2:7; signed char v3:7; };
struct BFs7ll_BFs7ll_BFs7c_BFs7c { signed long long v1:7; signed long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFs7i { signed long long v1:7; signed long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFs7ll { signed long long v1:7; signed long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFs7s { signed long long v1:7; signed long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFu7c { signed long long v1:7; signed long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFu7i { signed long long v1:7; signed long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFu7ll { signed long long v1:7; signed long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFs7c_BFu7s { signed long long v1:7; signed long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFs7i { signed long long v1:7; signed long long v2:7; signed int v3:7; };
struct BFs7ll_BFs7ll_BFs7i_BFs7c { signed long long v1:7; signed long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFs7i { signed long long v1:7; signed long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFs7ll { signed long long v1:7; signed long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFs7s { signed long long v1:7; signed long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFu7c { signed long long v1:7; signed long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFu7i { signed long long v1:7; signed long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFu7ll { signed long long v1:7; signed long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFs7i_BFu7s { signed long long v1:7; signed long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFs7ll { signed long long v1:7; signed long long v2:7; signed long long v3:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFs7c { signed long long v1:7; signed long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFs7i { signed long long v1:7; signed long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFs7ll { signed long long v1:7; signed long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFs7s { signed long long v1:7; signed long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFu7c { signed long long v1:7; signed long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFu7i { signed long long v1:7; signed long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFu7ll { signed long long v1:7; signed long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFs7ll_BFu7s { signed long long v1:7; signed long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFs7s { signed long long v1:7; signed long long v2:7; signed short v3:7; };
struct BFs7ll_BFs7ll_BFs7s_BFs7c { signed long long v1:7; signed long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFs7i { signed long long v1:7; signed long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFs7ll { signed long long v1:7; signed long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFs7s { signed long long v1:7; signed long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFu7c { signed long long v1:7; signed long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFu7i { signed long long v1:7; signed long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFu7ll { signed long long v1:7; signed long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFs7s_BFu7s { signed long long v1:7; signed long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFu7c { signed long long v1:7; signed long long v2:7; unsigned char v3:7; };
struct BFs7ll_BFs7ll_BFu7c_BFs7c { signed long long v1:7; signed long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFs7i { signed long long v1:7; signed long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFs7ll { signed long long v1:7; signed long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFs7s { signed long long v1:7; signed long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFu7c { signed long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFu7i { signed long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFu7ll { signed long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFu7c_BFu7s { signed long long v1:7; signed long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFu7i { signed long long v1:7; signed long long v2:7; unsigned int v3:7; };
struct BFs7ll_BFs7ll_BFu7i_BFs7c { signed long long v1:7; signed long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFs7i { signed long long v1:7; signed long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFs7ll { signed long long v1:7; signed long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFs7s { signed long long v1:7; signed long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFu7c { signed long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFu7i { signed long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFu7ll { signed long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFu7i_BFu7s { signed long long v1:7; signed long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFu7ll { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFs7c { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFs7i { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFs7ll { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFs7s { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFu7c { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFu7i { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFu7ll { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFu7ll_BFu7s { signed long long v1:7; signed long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7ll_BFu7s { signed long long v1:7; signed long long v2:7; unsigned short v3:7; };
struct BFs7ll_BFs7ll_BFu7s_BFs7c { signed long long v1:7; signed long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFs7i { signed long long v1:7; signed long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFs7ll { signed long long v1:7; signed long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFs7s { signed long long v1:7; signed long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFu7c { signed long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFu7i { signed long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFu7ll { signed long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7ll_BFu7s_BFu7s { signed long long v1:7; signed long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s { signed long long v1:7; signed short v2:7; };
struct BFs7ll_BFs7s_BFs7c { signed long long v1:7; signed short v2:7; signed char v3:7; };
struct BFs7ll_BFs7s_BFs7c_BFs7c { signed long long v1:7; signed short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFs7i { signed long long v1:7; signed short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFs7ll { signed long long v1:7; signed short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFs7s { signed long long v1:7; signed short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFu7c { signed long long v1:7; signed short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFu7i { signed long long v1:7; signed short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFu7ll { signed long long v1:7; signed short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFs7c_BFu7s { signed long long v1:7; signed short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFs7i { signed long long v1:7; signed short v2:7; signed int v3:7; };
struct BFs7ll_BFs7s_BFs7i_BFs7c { signed long long v1:7; signed short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFs7i { signed long long v1:7; signed short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFs7ll { signed long long v1:7; signed short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFs7s { signed long long v1:7; signed short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFu7c { signed long long v1:7; signed short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFu7i { signed long long v1:7; signed short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFu7ll { signed long long v1:7; signed short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFs7i_BFu7s { signed long long v1:7; signed short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFs7ll { signed long long v1:7; signed short v2:7; signed long long v3:7; };
struct BFs7ll_BFs7s_BFs7ll_BFs7c { signed long long v1:7; signed short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFs7i { signed long long v1:7; signed short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFs7ll { signed long long v1:7; signed short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFs7s { signed long long v1:7; signed short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFu7c { signed long long v1:7; signed short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFu7i { signed long long v1:7; signed short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFu7ll { signed long long v1:7; signed short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFs7ll_BFu7s { signed long long v1:7; signed short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFs7s { signed long long v1:7; signed short v2:7; signed short v3:7; };
struct BFs7ll_BFs7s_BFs7s_BFs7c { signed long long v1:7; signed short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFs7i { signed long long v1:7; signed short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFs7ll { signed long long v1:7; signed short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFs7s { signed long long v1:7; signed short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFu7c { signed long long v1:7; signed short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFu7i { signed long long v1:7; signed short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFu7ll { signed long long v1:7; signed short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFs7s_BFu7s { signed long long v1:7; signed short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFu7c { signed long long v1:7; signed short v2:7; unsigned char v3:7; };
struct BFs7ll_BFs7s_BFu7c_BFs7c { signed long long v1:7; signed short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFs7i { signed long long v1:7; signed short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFs7ll { signed long long v1:7; signed short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFs7s { signed long long v1:7; signed short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFu7c { signed long long v1:7; signed short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFu7i { signed long long v1:7; signed short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFu7ll { signed long long v1:7; signed short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFu7c_BFu7s { signed long long v1:7; signed short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFu7i { signed long long v1:7; signed short v2:7; unsigned int v3:7; };
struct BFs7ll_BFs7s_BFu7i_BFs7c { signed long long v1:7; signed short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFs7i { signed long long v1:7; signed short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFs7ll { signed long long v1:7; signed short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFs7s { signed long long v1:7; signed short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFu7c { signed long long v1:7; signed short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFu7i { signed long long v1:7; signed short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFu7ll { signed long long v1:7; signed short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFu7i_BFu7s { signed long long v1:7; signed short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFu7ll { signed long long v1:7; signed short v2:7; unsigned long long v3:7; };
struct BFs7ll_BFs7s_BFu7ll_BFs7c { signed long long v1:7; signed short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFs7i { signed long long v1:7; signed short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFs7ll { signed long long v1:7; signed short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFs7s { signed long long v1:7; signed short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFu7c { signed long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFu7i { signed long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFu7ll { signed long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFu7ll_BFu7s { signed long long v1:7; signed short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFs7s_BFu7s { signed long long v1:7; signed short v2:7; unsigned short v3:7; };
struct BFs7ll_BFs7s_BFu7s_BFs7c { signed long long v1:7; signed short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFs7i { signed long long v1:7; signed short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFs7ll { signed long long v1:7; signed short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFs7s { signed long long v1:7; signed short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFu7c { signed long long v1:7; signed short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFu7i { signed long long v1:7; signed short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFu7ll { signed long long v1:7; signed short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFs7s_BFu7s_BFu7s { signed long long v1:7; signed short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c { signed long long v1:7; unsigned char v2:7; };
struct BFs7ll_BFu7c_BFs7c { signed long long v1:7; unsigned char v2:7; signed char v3:7; };
struct BFs7ll_BFu7c_BFs7c_BFs7c { signed long long v1:7; unsigned char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFs7i { signed long long v1:7; unsigned char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFs7ll { signed long long v1:7; unsigned char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFs7s { signed long long v1:7; unsigned char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFu7c { signed long long v1:7; unsigned char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFu7i { signed long long v1:7; unsigned char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFu7ll { signed long long v1:7; unsigned char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFs7c_BFu7s { signed long long v1:7; unsigned char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFs7i { signed long long v1:7; unsigned char v2:7; signed int v3:7; };
struct BFs7ll_BFu7c_BFs7i_BFs7c { signed long long v1:7; unsigned char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFs7i { signed long long v1:7; unsigned char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFs7ll { signed long long v1:7; unsigned char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFs7s { signed long long v1:7; unsigned char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFu7c { signed long long v1:7; unsigned char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFu7i { signed long long v1:7; unsigned char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFu7ll { signed long long v1:7; unsigned char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFs7i_BFu7s { signed long long v1:7; unsigned char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFs7ll { signed long long v1:7; unsigned char v2:7; signed long long v3:7; };
struct BFs7ll_BFu7c_BFs7ll_BFs7c { signed long long v1:7; unsigned char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFs7i { signed long long v1:7; unsigned char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFs7ll { signed long long v1:7; unsigned char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFs7s { signed long long v1:7; unsigned char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFu7c { signed long long v1:7; unsigned char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFu7i { signed long long v1:7; unsigned char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFu7ll { signed long long v1:7; unsigned char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFs7ll_BFu7s { signed long long v1:7; unsigned char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFs7s { signed long long v1:7; unsigned char v2:7; signed short v3:7; };
struct BFs7ll_BFu7c_BFs7s_BFs7c { signed long long v1:7; unsigned char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFs7i { signed long long v1:7; unsigned char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFs7ll { signed long long v1:7; unsigned char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFs7s { signed long long v1:7; unsigned char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFu7c { signed long long v1:7; unsigned char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFu7i { signed long long v1:7; unsigned char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFu7ll { signed long long v1:7; unsigned char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFs7s_BFu7s { signed long long v1:7; unsigned char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFu7c { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; };
struct BFs7ll_BFu7c_BFu7c_BFs7c { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFs7i { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFs7ll { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFs7s { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFu7c { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFu7i { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFu7ll { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFu7c_BFu7s { signed long long v1:7; unsigned char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFu7i { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; };
struct BFs7ll_BFu7c_BFu7i_BFs7c { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFs7i { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFs7ll { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFs7s { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFu7c { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFu7i { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFu7ll { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFu7i_BFu7s { signed long long v1:7; unsigned char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFu7ll { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; };
struct BFs7ll_BFu7c_BFu7ll_BFs7c { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFs7i { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFs7ll { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFs7s { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFu7c { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFu7i { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFu7ll { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFu7ll_BFu7s { signed long long v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7c_BFu7s { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; };
struct BFs7ll_BFu7c_BFu7s_BFs7c { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFs7i { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFs7ll { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFs7s { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFu7c { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFu7i { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFu7ll { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7c_BFu7s_BFu7s { signed long long v1:7; unsigned char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i { signed long long v1:7; unsigned int v2:7; };
struct BFs7ll_BFu7i_BFs7c { signed long long v1:7; unsigned int v2:7; signed char v3:7; };
struct BFs7ll_BFu7i_BFs7c_BFs7c { signed long long v1:7; unsigned int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFs7i { signed long long v1:7; unsigned int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFs7ll { signed long long v1:7; unsigned int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFs7s { signed long long v1:7; unsigned int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFu7c { signed long long v1:7; unsigned int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFu7i { signed long long v1:7; unsigned int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFu7ll { signed long long v1:7; unsigned int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFs7c_BFu7s { signed long long v1:7; unsigned int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFs7i { signed long long v1:7; unsigned int v2:7; signed int v3:7; };
struct BFs7ll_BFu7i_BFs7i_BFs7c { signed long long v1:7; unsigned int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFs7i { signed long long v1:7; unsigned int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFs7ll { signed long long v1:7; unsigned int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFs7s { signed long long v1:7; unsigned int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFu7c { signed long long v1:7; unsigned int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFu7i { signed long long v1:7; unsigned int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFu7ll { signed long long v1:7; unsigned int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFs7i_BFu7s { signed long long v1:7; unsigned int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFs7ll { signed long long v1:7; unsigned int v2:7; signed long long v3:7; };
struct BFs7ll_BFu7i_BFs7ll_BFs7c { signed long long v1:7; unsigned int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFs7i { signed long long v1:7; unsigned int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFs7ll { signed long long v1:7; unsigned int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFs7s { signed long long v1:7; unsigned int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFu7c { signed long long v1:7; unsigned int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFu7i { signed long long v1:7; unsigned int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFu7ll { signed long long v1:7; unsigned int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFs7ll_BFu7s { signed long long v1:7; unsigned int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFs7s { signed long long v1:7; unsigned int v2:7; signed short v3:7; };
struct BFs7ll_BFu7i_BFs7s_BFs7c { signed long long v1:7; unsigned int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFs7i { signed long long v1:7; unsigned int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFs7ll { signed long long v1:7; unsigned int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFs7s { signed long long v1:7; unsigned int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFu7c { signed long long v1:7; unsigned int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFu7i { signed long long v1:7; unsigned int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFu7ll { signed long long v1:7; unsigned int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFs7s_BFu7s { signed long long v1:7; unsigned int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFu7c { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; };
struct BFs7ll_BFu7i_BFu7c_BFs7c { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFs7i { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFs7ll { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFs7s { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFu7c { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFu7i { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFu7ll { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFu7c_BFu7s { signed long long v1:7; unsigned int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFu7i { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; };
struct BFs7ll_BFu7i_BFu7i_BFs7c { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFs7i { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFs7ll { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFs7s { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFu7c { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFu7i { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFu7ll { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFu7i_BFu7s { signed long long v1:7; unsigned int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFu7ll { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; };
struct BFs7ll_BFu7i_BFu7ll_BFs7c { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFs7i { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFs7ll { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFs7s { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFu7c { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFu7i { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFu7ll { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFu7ll_BFu7s { signed long long v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7i_BFu7s { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; };
struct BFs7ll_BFu7i_BFu7s_BFs7c { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFs7i { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFs7ll { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFs7s { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFu7c { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFu7i { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFu7ll { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7i_BFu7s_BFu7s { signed long long v1:7; unsigned int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll { signed long long v1:7; unsigned long long v2:7; };
struct BFs7ll_BFu7ll_BFs7c { signed long long v1:7; unsigned long long v2:7; signed char v3:7; };
struct BFs7ll_BFu7ll_BFs7c_BFs7c { signed long long v1:7; unsigned long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFs7i { signed long long v1:7; unsigned long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFs7ll { signed long long v1:7; unsigned long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFs7s { signed long long v1:7; unsigned long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFu7c { signed long long v1:7; unsigned long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFu7i { signed long long v1:7; unsigned long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFu7ll { signed long long v1:7; unsigned long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFs7c_BFu7s { signed long long v1:7; unsigned long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFs7i { signed long long v1:7; unsigned long long v2:7; signed int v3:7; };
struct BFs7ll_BFu7ll_BFs7i_BFs7c { signed long long v1:7; unsigned long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFs7i { signed long long v1:7; unsigned long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFs7ll { signed long long v1:7; unsigned long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFs7s { signed long long v1:7; unsigned long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFu7c { signed long long v1:7; unsigned long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFu7i { signed long long v1:7; unsigned long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFu7ll { signed long long v1:7; unsigned long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFs7i_BFu7s { signed long long v1:7; unsigned long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFs7ll { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFs7c { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFs7i { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFs7ll { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFs7s { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFu7c { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFu7i { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFu7ll { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFs7ll_BFu7s { signed long long v1:7; unsigned long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFs7s { signed long long v1:7; unsigned long long v2:7; signed short v3:7; };
struct BFs7ll_BFu7ll_BFs7s_BFs7c { signed long long v1:7; unsigned long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFs7i { signed long long v1:7; unsigned long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFs7ll { signed long long v1:7; unsigned long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFs7s { signed long long v1:7; unsigned long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFu7c { signed long long v1:7; unsigned long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFu7i { signed long long v1:7; unsigned long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFu7ll { signed long long v1:7; unsigned long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFs7s_BFu7s { signed long long v1:7; unsigned long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFu7c { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; };
struct BFs7ll_BFu7ll_BFu7c_BFs7c { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFs7i { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFs7ll { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFs7s { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFu7c { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFu7i { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFu7ll { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFu7c_BFu7s { signed long long v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFu7i { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; };
struct BFs7ll_BFu7ll_BFu7i_BFs7c { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFs7i { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFs7ll { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFs7s { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFu7c { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFu7i { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFu7ll { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFu7i_BFu7s { signed long long v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFu7ll { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFs7c { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFs7i { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFs7ll { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFs7s { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFu7c { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFu7i { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFu7ll { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFu7ll_BFu7s { signed long long v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7ll_BFu7s { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; };
struct BFs7ll_BFu7ll_BFu7s_BFs7c { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFs7i { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFs7ll { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFs7s { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFu7c { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFu7i { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFu7ll { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7ll_BFu7s_BFu7s { signed long long v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s { signed long long v1:7; unsigned short v2:7; };
struct BFs7ll_BFu7s_BFs7c { signed long long v1:7; unsigned short v2:7; signed char v3:7; };
struct BFs7ll_BFu7s_BFs7c_BFs7c { signed long long v1:7; unsigned short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFs7i { signed long long v1:7; unsigned short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFs7ll { signed long long v1:7; unsigned short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFs7s { signed long long v1:7; unsigned short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFu7c { signed long long v1:7; unsigned short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFu7i { signed long long v1:7; unsigned short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFu7ll { signed long long v1:7; unsigned short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFs7c_BFu7s { signed long long v1:7; unsigned short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFs7i { signed long long v1:7; unsigned short v2:7; signed int v3:7; };
struct BFs7ll_BFu7s_BFs7i_BFs7c { signed long long v1:7; unsigned short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFs7i { signed long long v1:7; unsigned short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFs7ll { signed long long v1:7; unsigned short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFs7s { signed long long v1:7; unsigned short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFu7c { signed long long v1:7; unsigned short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFu7i { signed long long v1:7; unsigned short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFu7ll { signed long long v1:7; unsigned short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFs7i_BFu7s { signed long long v1:7; unsigned short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFs7ll { signed long long v1:7; unsigned short v2:7; signed long long v3:7; };
struct BFs7ll_BFu7s_BFs7ll_BFs7c { signed long long v1:7; unsigned short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFs7i { signed long long v1:7; unsigned short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFs7ll { signed long long v1:7; unsigned short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFs7s { signed long long v1:7; unsigned short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFu7c { signed long long v1:7; unsigned short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFu7i { signed long long v1:7; unsigned short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFu7ll { signed long long v1:7; unsigned short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFs7ll_BFu7s { signed long long v1:7; unsigned short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFs7s { signed long long v1:7; unsigned short v2:7; signed short v3:7; };
struct BFs7ll_BFu7s_BFs7s_BFs7c { signed long long v1:7; unsigned short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFs7i { signed long long v1:7; unsigned short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFs7ll { signed long long v1:7; unsigned short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFs7s { signed long long v1:7; unsigned short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFu7c { signed long long v1:7; unsigned short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFu7i { signed long long v1:7; unsigned short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFu7ll { signed long long v1:7; unsigned short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFs7s_BFu7s { signed long long v1:7; unsigned short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFu7c { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; };
struct BFs7ll_BFu7s_BFu7c_BFs7c { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFs7i { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFs7ll { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFs7s { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFu7c { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFu7i { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFu7ll { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFu7c_BFu7s { signed long long v1:7; unsigned short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFu7i { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; };
struct BFs7ll_BFu7s_BFu7i_BFs7c { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFs7i { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFs7ll { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFs7s { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFu7c { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFu7i { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFu7ll { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFu7i_BFu7s { signed long long v1:7; unsigned short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFu7ll { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; };
struct BFs7ll_BFu7s_BFu7ll_BFs7c { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFs7i { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFs7ll { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFs7s { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFu7c { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFu7i { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFu7ll { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFu7ll_BFu7s { signed long long v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7ll_BFu7s_BFu7s { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; };
struct BFs7ll_BFu7s_BFu7s_BFs7c { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFs7i { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFs7ll { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFs7s { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFu7c { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFu7i { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFu7ll { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7ll_BFu7s_BFu7s_BFu7s { signed long long v1:7; unsigned short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c { signed short v1:7; signed char v2:7; };
struct BFs7s_BFs7c_BFs7c { signed short v1:7; signed char v2:7; signed char v3:7; };
struct BFs7s_BFs7c_BFs7c_BFs7c { signed short v1:7; signed char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFs7c_BFs7i { signed short v1:7; signed char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFs7c_BFs7ll { signed short v1:7; signed char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFs7c_BFs7s { signed short v1:7; signed char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFs7c_BFu7c { signed short v1:7; signed char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFs7c_BFu7i { signed short v1:7; signed char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFs7c_BFu7ll { signed short v1:7; signed char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFs7c_BFu7s { signed short v1:7; signed char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFs7i { signed short v1:7; signed char v2:7; signed int v3:7; };
struct BFs7s_BFs7c_BFs7i_BFs7c { signed short v1:7; signed char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFs7i_BFs7i { signed short v1:7; signed char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFs7i_BFs7ll { signed short v1:7; signed char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFs7i_BFs7s { signed short v1:7; signed char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFs7i_BFu7c { signed short v1:7; signed char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFs7i_BFu7i { signed short v1:7; signed char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFs7i_BFu7ll { signed short v1:7; signed char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFs7i_BFu7s { signed short v1:7; signed char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFs7ll { signed short v1:7; signed char v2:7; signed long long v3:7; };
struct BFs7s_BFs7c_BFs7ll_BFs7c { signed short v1:7; signed char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFs7i { signed short v1:7; signed char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFs7ll { signed short v1:7; signed char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFs7s { signed short v1:7; signed char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFu7c { signed short v1:7; signed char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFu7i { signed short v1:7; signed char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFu7ll { signed short v1:7; signed char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFs7ll_BFu7s { signed short v1:7; signed char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFs7s { signed short v1:7; signed char v2:7; signed short v3:7; };
struct BFs7s_BFs7c_BFs7s_BFs7c { signed short v1:7; signed char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFs7s_BFs7i { signed short v1:7; signed char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFs7s_BFs7ll { signed short v1:7; signed char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFs7s_BFs7s { signed short v1:7; signed char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFs7s_BFu7c { signed short v1:7; signed char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFs7s_BFu7i { signed short v1:7; signed char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFs7s_BFu7ll { signed short v1:7; signed char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFs7s_BFu7s { signed short v1:7; signed char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFu7c { signed short v1:7; signed char v2:7; unsigned char v3:7; };
struct BFs7s_BFs7c_BFu7c_BFs7c { signed short v1:7; signed char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFu7c_BFs7i { signed short v1:7; signed char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFu7c_BFs7ll { signed short v1:7; signed char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFu7c_BFs7s { signed short v1:7; signed char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFu7c_BFu7c { signed short v1:7; signed char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFu7c_BFu7i { signed short v1:7; signed char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFu7c_BFu7ll { signed short v1:7; signed char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFu7c_BFu7s { signed short v1:7; signed char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFu7i { signed short v1:7; signed char v2:7; unsigned int v3:7; };
struct BFs7s_BFs7c_BFu7i_BFs7c { signed short v1:7; signed char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFu7i_BFs7i { signed short v1:7; signed char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFu7i_BFs7ll { signed short v1:7; signed char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFu7i_BFs7s { signed short v1:7; signed char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFu7i_BFu7c { signed short v1:7; signed char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFu7i_BFu7i { signed short v1:7; signed char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFu7i_BFu7ll { signed short v1:7; signed char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFu7i_BFu7s { signed short v1:7; signed char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFu7ll { signed short v1:7; signed char v2:7; unsigned long long v3:7; };
struct BFs7s_BFs7c_BFu7ll_BFs7c { signed short v1:7; signed char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFs7i { signed short v1:7; signed char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFs7ll { signed short v1:7; signed char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFs7s { signed short v1:7; signed char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFu7c { signed short v1:7; signed char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFu7i { signed short v1:7; signed char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFu7ll { signed short v1:7; signed char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFu7ll_BFu7s { signed short v1:7; signed char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7c_BFu7s { signed short v1:7; signed char v2:7; unsigned short v3:7; };
struct BFs7s_BFs7c_BFu7s_BFs7c { signed short v1:7; signed char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFs7c_BFu7s_BFs7i { signed short v1:7; signed char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFs7c_BFu7s_BFs7ll { signed short v1:7; signed char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFs7c_BFu7s_BFs7s { signed short v1:7; signed char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFs7c_BFu7s_BFu7c { signed short v1:7; signed char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7c_BFu7s_BFu7i { signed short v1:7; signed char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7c_BFu7s_BFu7ll { signed short v1:7; signed char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7c_BFu7s_BFu7s { signed short v1:7; signed char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i { signed short v1:7; signed int v2:7; };
struct BFs7s_BFs7i_BFs7c { signed short v1:7; signed int v2:7; signed char v3:7; };
struct BFs7s_BFs7i_BFs7c_BFs7c { signed short v1:7; signed int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFs7c_BFs7i { signed short v1:7; signed int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFs7c_BFs7ll { signed short v1:7; signed int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFs7c_BFs7s { signed short v1:7; signed int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFs7c_BFu7c { signed short v1:7; signed int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFs7c_BFu7i { signed short v1:7; signed int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFs7c_BFu7ll { signed short v1:7; signed int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFs7c_BFu7s { signed short v1:7; signed int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFs7i { signed short v1:7; signed int v2:7; signed int v3:7; };
struct BFs7s_BFs7i_BFs7i_BFs7c { signed short v1:7; signed int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFs7i_BFs7i { signed short v1:7; signed int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFs7i_BFs7ll { signed short v1:7; signed int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFs7i_BFs7s { signed short v1:7; signed int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFs7i_BFu7c { signed short v1:7; signed int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFs7i_BFu7i { signed short v1:7; signed int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFs7i_BFu7ll { signed short v1:7; signed int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFs7i_BFu7s { signed short v1:7; signed int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFs7ll { signed short v1:7; signed int v2:7; signed long long v3:7; };
struct BFs7s_BFs7i_BFs7ll_BFs7c { signed short v1:7; signed int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFs7i { signed short v1:7; signed int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFs7ll { signed short v1:7; signed int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFs7s { signed short v1:7; signed int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFu7c { signed short v1:7; signed int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFu7i { signed short v1:7; signed int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFu7ll { signed short v1:7; signed int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFs7ll_BFu7s { signed short v1:7; signed int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFs7s { signed short v1:7; signed int v2:7; signed short v3:7; };
struct BFs7s_BFs7i_BFs7s_BFs7c { signed short v1:7; signed int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFs7s_BFs7i { signed short v1:7; signed int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFs7s_BFs7ll { signed short v1:7; signed int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFs7s_BFs7s { signed short v1:7; signed int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFs7s_BFu7c { signed short v1:7; signed int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFs7s_BFu7i { signed short v1:7; signed int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFs7s_BFu7ll { signed short v1:7; signed int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFs7s_BFu7s { signed short v1:7; signed int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFu7c { signed short v1:7; signed int v2:7; unsigned char v3:7; };
struct BFs7s_BFs7i_BFu7c_BFs7c { signed short v1:7; signed int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFu7c_BFs7i { signed short v1:7; signed int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFu7c_BFs7ll { signed short v1:7; signed int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFu7c_BFs7s { signed short v1:7; signed int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFu7c_BFu7c { signed short v1:7; signed int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFu7c_BFu7i { signed short v1:7; signed int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFu7c_BFu7ll { signed short v1:7; signed int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFu7c_BFu7s { signed short v1:7; signed int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFu7i { signed short v1:7; signed int v2:7; unsigned int v3:7; };
struct BFs7s_BFs7i_BFu7i_BFs7c { signed short v1:7; signed int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFu7i_BFs7i { signed short v1:7; signed int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFu7i_BFs7ll { signed short v1:7; signed int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFu7i_BFs7s { signed short v1:7; signed int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFu7i_BFu7c { signed short v1:7; signed int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFu7i_BFu7i { signed short v1:7; signed int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFu7i_BFu7ll { signed short v1:7; signed int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFu7i_BFu7s { signed short v1:7; signed int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFu7ll { signed short v1:7; signed int v2:7; unsigned long long v3:7; };
struct BFs7s_BFs7i_BFu7ll_BFs7c { signed short v1:7; signed int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFs7i { signed short v1:7; signed int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFs7ll { signed short v1:7; signed int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFs7s { signed short v1:7; signed int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFu7c { signed short v1:7; signed int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFu7i { signed short v1:7; signed int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFu7ll { signed short v1:7; signed int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFu7ll_BFu7s { signed short v1:7; signed int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7i_BFu7s { signed short v1:7; signed int v2:7; unsigned short v3:7; };
struct BFs7s_BFs7i_BFu7s_BFs7c { signed short v1:7; signed int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFs7i_BFu7s_BFs7i { signed short v1:7; signed int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFs7i_BFu7s_BFs7ll { signed short v1:7; signed int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFs7i_BFu7s_BFs7s { signed short v1:7; signed int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFs7i_BFu7s_BFu7c { signed short v1:7; signed int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7i_BFu7s_BFu7i { signed short v1:7; signed int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7i_BFu7s_BFu7ll { signed short v1:7; signed int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7i_BFu7s_BFu7s { signed short v1:7; signed int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll { signed short v1:7; signed long long v2:7; };
struct BFs7s_BFs7ll_BFs7c { signed short v1:7; signed long long v2:7; signed char v3:7; };
struct BFs7s_BFs7ll_BFs7c_BFs7c { signed short v1:7; signed long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFs7i { signed short v1:7; signed long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFs7ll { signed short v1:7; signed long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFs7s { signed short v1:7; signed long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFu7c { signed short v1:7; signed long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFu7i { signed short v1:7; signed long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFu7ll { signed short v1:7; signed long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFs7c_BFu7s { signed short v1:7; signed long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFs7i { signed short v1:7; signed long long v2:7; signed int v3:7; };
struct BFs7s_BFs7ll_BFs7i_BFs7c { signed short v1:7; signed long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFs7i { signed short v1:7; signed long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFs7ll { signed short v1:7; signed long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFs7s { signed short v1:7; signed long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFu7c { signed short v1:7; signed long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFu7i { signed short v1:7; signed long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFu7ll { signed short v1:7; signed long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFs7i_BFu7s { signed short v1:7; signed long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFs7ll { signed short v1:7; signed long long v2:7; signed long long v3:7; };
struct BFs7s_BFs7ll_BFs7ll_BFs7c { signed short v1:7; signed long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFs7i { signed short v1:7; signed long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFs7ll { signed short v1:7; signed long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFs7s { signed short v1:7; signed long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFu7c { signed short v1:7; signed long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFu7i { signed short v1:7; signed long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFu7ll { signed short v1:7; signed long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFs7ll_BFu7s { signed short v1:7; signed long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFs7s { signed short v1:7; signed long long v2:7; signed short v3:7; };
struct BFs7s_BFs7ll_BFs7s_BFs7c { signed short v1:7; signed long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFs7i { signed short v1:7; signed long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFs7ll { signed short v1:7; signed long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFs7s { signed short v1:7; signed long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFu7c { signed short v1:7; signed long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFu7i { signed short v1:7; signed long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFu7ll { signed short v1:7; signed long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFs7s_BFu7s { signed short v1:7; signed long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFu7c { signed short v1:7; signed long long v2:7; unsigned char v3:7; };
struct BFs7s_BFs7ll_BFu7c_BFs7c { signed short v1:7; signed long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFs7i { signed short v1:7; signed long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFs7ll { signed short v1:7; signed long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFs7s { signed short v1:7; signed long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFu7c { signed short v1:7; signed long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFu7i { signed short v1:7; signed long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFu7ll { signed short v1:7; signed long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFu7c_BFu7s { signed short v1:7; signed long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFu7i { signed short v1:7; signed long long v2:7; unsigned int v3:7; };
struct BFs7s_BFs7ll_BFu7i_BFs7c { signed short v1:7; signed long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFs7i { signed short v1:7; signed long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFs7ll { signed short v1:7; signed long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFs7s { signed short v1:7; signed long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFu7c { signed short v1:7; signed long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFu7i { signed short v1:7; signed long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFu7ll { signed short v1:7; signed long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFu7i_BFu7s { signed short v1:7; signed long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFu7ll { signed short v1:7; signed long long v2:7; unsigned long long v3:7; };
struct BFs7s_BFs7ll_BFu7ll_BFs7c { signed short v1:7; signed long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFs7i { signed short v1:7; signed long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFs7ll { signed short v1:7; signed long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFs7s { signed short v1:7; signed long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFu7c { signed short v1:7; signed long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFu7i { signed short v1:7; signed long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFu7ll { signed short v1:7; signed long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFu7ll_BFu7s { signed short v1:7; signed long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7ll_BFu7s { signed short v1:7; signed long long v2:7; unsigned short v3:7; };
struct BFs7s_BFs7ll_BFu7s_BFs7c { signed short v1:7; signed long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFs7i { signed short v1:7; signed long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFs7ll { signed short v1:7; signed long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFs7s { signed short v1:7; signed long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFu7c { signed short v1:7; signed long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFu7i { signed short v1:7; signed long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFu7ll { signed short v1:7; signed long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7ll_BFu7s_BFu7s { signed short v1:7; signed long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s { signed short v1:7; signed short v2:7; };
struct BFs7s_BFs7s_BFs7c { signed short v1:7; signed short v2:7; signed char v3:7; };
struct BFs7s_BFs7s_BFs7c_BFs7c { signed short v1:7; signed short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFs7c_BFs7i { signed short v1:7; signed short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFs7c_BFs7ll { signed short v1:7; signed short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFs7c_BFs7s { signed short v1:7; signed short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFs7c_BFu7c { signed short v1:7; signed short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFs7c_BFu7i { signed short v1:7; signed short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFs7c_BFu7ll { signed short v1:7; signed short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFs7c_BFu7s { signed short v1:7; signed short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFs7i { signed short v1:7; signed short v2:7; signed int v3:7; };
struct BFs7s_BFs7s_BFs7i_BFs7c { signed short v1:7; signed short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFs7i_BFs7i { signed short v1:7; signed short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFs7i_BFs7ll { signed short v1:7; signed short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFs7i_BFs7s { signed short v1:7; signed short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFs7i_BFu7c { signed short v1:7; signed short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFs7i_BFu7i { signed short v1:7; signed short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFs7i_BFu7ll { signed short v1:7; signed short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFs7i_BFu7s { signed short v1:7; signed short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFs7ll { signed short v1:7; signed short v2:7; signed long long v3:7; };
struct BFs7s_BFs7s_BFs7ll_BFs7c { signed short v1:7; signed short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFs7i { signed short v1:7; signed short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFs7ll { signed short v1:7; signed short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFs7s { signed short v1:7; signed short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFu7c { signed short v1:7; signed short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFu7i { signed short v1:7; signed short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFu7ll { signed short v1:7; signed short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFs7ll_BFu7s { signed short v1:7; signed short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFs7s { signed short v1:7; signed short v2:7; signed short v3:7; };
struct BFs7s_BFs7s_BFs7s_BFs7c { signed short v1:7; signed short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFs7s_BFs7i { signed short v1:7; signed short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFs7s_BFs7ll { signed short v1:7; signed short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFs7s_BFs7s { signed short v1:7; signed short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFs7s_BFu7c { signed short v1:7; signed short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFs7s_BFu7i { signed short v1:7; signed short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFs7s_BFu7ll { signed short v1:7; signed short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFs7s_BFu7s { signed short v1:7; signed short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFu7c { signed short v1:7; signed short v2:7; unsigned char v3:7; };
struct BFs7s_BFs7s_BFu7c_BFs7c { signed short v1:7; signed short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFu7c_BFs7i { signed short v1:7; signed short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFu7c_BFs7ll { signed short v1:7; signed short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFu7c_BFs7s { signed short v1:7; signed short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFu7c_BFu7c { signed short v1:7; signed short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFu7c_BFu7i { signed short v1:7; signed short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFu7c_BFu7ll { signed short v1:7; signed short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFu7c_BFu7s { signed short v1:7; signed short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFu7i { signed short v1:7; signed short v2:7; unsigned int v3:7; };
struct BFs7s_BFs7s_BFu7i_BFs7c { signed short v1:7; signed short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFu7i_BFs7i { signed short v1:7; signed short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFu7i_BFs7ll { signed short v1:7; signed short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFu7i_BFs7s { signed short v1:7; signed short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFu7i_BFu7c { signed short v1:7; signed short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFu7i_BFu7i { signed short v1:7; signed short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFu7i_BFu7ll { signed short v1:7; signed short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFu7i_BFu7s { signed short v1:7; signed short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFu7ll { signed short v1:7; signed short v2:7; unsigned long long v3:7; };
struct BFs7s_BFs7s_BFu7ll_BFs7c { signed short v1:7; signed short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFs7i { signed short v1:7; signed short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFs7ll { signed short v1:7; signed short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFs7s { signed short v1:7; signed short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFu7c { signed short v1:7; signed short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFu7i { signed short v1:7; signed short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFu7ll { signed short v1:7; signed short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFu7ll_BFu7s { signed short v1:7; signed short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFs7s_BFu7s { signed short v1:7; signed short v2:7; unsigned short v3:7; };
struct BFs7s_BFs7s_BFu7s_BFs7c { signed short v1:7; signed short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFs7s_BFu7s_BFs7i { signed short v1:7; signed short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFs7s_BFu7s_BFs7ll { signed short v1:7; signed short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFs7s_BFu7s_BFs7s { signed short v1:7; signed short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFs7s_BFu7s_BFu7c { signed short v1:7; signed short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFs7s_BFu7s_BFu7i { signed short v1:7; signed short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFs7s_BFu7s_BFu7ll { signed short v1:7; signed short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFs7s_BFu7s_BFu7s { signed short v1:7; signed short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c { signed short v1:7; unsigned char v2:7; };
struct BFs7s_BFu7c_BFs7c { signed short v1:7; unsigned char v2:7; signed char v3:7; };
struct BFs7s_BFu7c_BFs7c_BFs7c { signed short v1:7; unsigned char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFs7c_BFs7i { signed short v1:7; unsigned char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFs7c_BFs7ll { signed short v1:7; unsigned char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFs7c_BFs7s { signed short v1:7; unsigned char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFs7c_BFu7c { signed short v1:7; unsigned char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFs7c_BFu7i { signed short v1:7; unsigned char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFs7c_BFu7ll { signed short v1:7; unsigned char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFs7c_BFu7s { signed short v1:7; unsigned char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFs7i { signed short v1:7; unsigned char v2:7; signed int v3:7; };
struct BFs7s_BFu7c_BFs7i_BFs7c { signed short v1:7; unsigned char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFs7i_BFs7i { signed short v1:7; unsigned char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFs7i_BFs7ll { signed short v1:7; unsigned char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFs7i_BFs7s { signed short v1:7; unsigned char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFs7i_BFu7c { signed short v1:7; unsigned char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFs7i_BFu7i { signed short v1:7; unsigned char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFs7i_BFu7ll { signed short v1:7; unsigned char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFs7i_BFu7s { signed short v1:7; unsigned char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFs7ll { signed short v1:7; unsigned char v2:7; signed long long v3:7; };
struct BFs7s_BFu7c_BFs7ll_BFs7c { signed short v1:7; unsigned char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFs7i { signed short v1:7; unsigned char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFs7ll { signed short v1:7; unsigned char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFs7s { signed short v1:7; unsigned char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFu7c { signed short v1:7; unsigned char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFu7i { signed short v1:7; unsigned char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFu7ll { signed short v1:7; unsigned char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFs7ll_BFu7s { signed short v1:7; unsigned char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFs7s { signed short v1:7; unsigned char v2:7; signed short v3:7; };
struct BFs7s_BFu7c_BFs7s_BFs7c { signed short v1:7; unsigned char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFs7s_BFs7i { signed short v1:7; unsigned char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFs7s_BFs7ll { signed short v1:7; unsigned char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFs7s_BFs7s { signed short v1:7; unsigned char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFs7s_BFu7c { signed short v1:7; unsigned char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFs7s_BFu7i { signed short v1:7; unsigned char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFs7s_BFu7ll { signed short v1:7; unsigned char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFs7s_BFu7s { signed short v1:7; unsigned char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFu7c { signed short v1:7; unsigned char v2:7; unsigned char v3:7; };
struct BFs7s_BFu7c_BFu7c_BFs7c { signed short v1:7; unsigned char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFu7c_BFs7i { signed short v1:7; unsigned char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFu7c_BFs7ll { signed short v1:7; unsigned char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFu7c_BFs7s { signed short v1:7; unsigned char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFu7c_BFu7c { signed short v1:7; unsigned char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFu7c_BFu7i { signed short v1:7; unsigned char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFu7c_BFu7ll { signed short v1:7; unsigned char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFu7c_BFu7s { signed short v1:7; unsigned char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFu7i { signed short v1:7; unsigned char v2:7; unsigned int v3:7; };
struct BFs7s_BFu7c_BFu7i_BFs7c { signed short v1:7; unsigned char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFu7i_BFs7i { signed short v1:7; unsigned char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFu7i_BFs7ll { signed short v1:7; unsigned char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFu7i_BFs7s { signed short v1:7; unsigned char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFu7i_BFu7c { signed short v1:7; unsigned char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFu7i_BFu7i { signed short v1:7; unsigned char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFu7i_BFu7ll { signed short v1:7; unsigned char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFu7i_BFu7s { signed short v1:7; unsigned char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFu7ll { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; };
struct BFs7s_BFu7c_BFu7ll_BFs7c { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFs7i { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFs7ll { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFs7s { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFu7c { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFu7i { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFu7ll { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFu7ll_BFu7s { signed short v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7c_BFu7s { signed short v1:7; unsigned char v2:7; unsigned short v3:7; };
struct BFs7s_BFu7c_BFu7s_BFs7c { signed short v1:7; unsigned char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFu7c_BFu7s_BFs7i { signed short v1:7; unsigned char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFu7c_BFu7s_BFs7ll { signed short v1:7; unsigned char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFu7c_BFu7s_BFs7s { signed short v1:7; unsigned char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFu7c_BFu7s_BFu7c { signed short v1:7; unsigned char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7c_BFu7s_BFu7i { signed short v1:7; unsigned char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7c_BFu7s_BFu7ll { signed short v1:7; unsigned char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7c_BFu7s_BFu7s { signed short v1:7; unsigned char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i { signed short v1:7; unsigned int v2:7; };
struct BFs7s_BFu7i_BFs7c { signed short v1:7; unsigned int v2:7; signed char v3:7; };
struct BFs7s_BFu7i_BFs7c_BFs7c { signed short v1:7; unsigned int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFs7c_BFs7i { signed short v1:7; unsigned int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFs7c_BFs7ll { signed short v1:7; unsigned int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFs7c_BFs7s { signed short v1:7; unsigned int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFs7c_BFu7c { signed short v1:7; unsigned int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFs7c_BFu7i { signed short v1:7; unsigned int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFs7c_BFu7ll { signed short v1:7; unsigned int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFs7c_BFu7s { signed short v1:7; unsigned int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFs7i { signed short v1:7; unsigned int v2:7; signed int v3:7; };
struct BFs7s_BFu7i_BFs7i_BFs7c { signed short v1:7; unsigned int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFs7i_BFs7i { signed short v1:7; unsigned int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFs7i_BFs7ll { signed short v1:7; unsigned int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFs7i_BFs7s { signed short v1:7; unsigned int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFs7i_BFu7c { signed short v1:7; unsigned int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFs7i_BFu7i { signed short v1:7; unsigned int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFs7i_BFu7ll { signed short v1:7; unsigned int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFs7i_BFu7s { signed short v1:7; unsigned int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFs7ll { signed short v1:7; unsigned int v2:7; signed long long v3:7; };
struct BFs7s_BFu7i_BFs7ll_BFs7c { signed short v1:7; unsigned int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFs7i { signed short v1:7; unsigned int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFs7ll { signed short v1:7; unsigned int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFs7s { signed short v1:7; unsigned int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFu7c { signed short v1:7; unsigned int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFu7i { signed short v1:7; unsigned int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFu7ll { signed short v1:7; unsigned int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFs7ll_BFu7s { signed short v1:7; unsigned int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFs7s { signed short v1:7; unsigned int v2:7; signed short v3:7; };
struct BFs7s_BFu7i_BFs7s_BFs7c { signed short v1:7; unsigned int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFs7s_BFs7i { signed short v1:7; unsigned int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFs7s_BFs7ll { signed short v1:7; unsigned int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFs7s_BFs7s { signed short v1:7; unsigned int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFs7s_BFu7c { signed short v1:7; unsigned int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFs7s_BFu7i { signed short v1:7; unsigned int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFs7s_BFu7ll { signed short v1:7; unsigned int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFs7s_BFu7s { signed short v1:7; unsigned int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFu7c { signed short v1:7; unsigned int v2:7; unsigned char v3:7; };
struct BFs7s_BFu7i_BFu7c_BFs7c { signed short v1:7; unsigned int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFu7c_BFs7i { signed short v1:7; unsigned int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFu7c_BFs7ll { signed short v1:7; unsigned int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFu7c_BFs7s { signed short v1:7; unsigned int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFu7c_BFu7c { signed short v1:7; unsigned int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFu7c_BFu7i { signed short v1:7; unsigned int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFu7c_BFu7ll { signed short v1:7; unsigned int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFu7c_BFu7s { signed short v1:7; unsigned int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFu7i { signed short v1:7; unsigned int v2:7; unsigned int v3:7; };
struct BFs7s_BFu7i_BFu7i_BFs7c { signed short v1:7; unsigned int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFu7i_BFs7i { signed short v1:7; unsigned int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFu7i_BFs7ll { signed short v1:7; unsigned int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFu7i_BFs7s { signed short v1:7; unsigned int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFu7i_BFu7c { signed short v1:7; unsigned int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFu7i_BFu7i { signed short v1:7; unsigned int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFu7i_BFu7ll { signed short v1:7; unsigned int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFu7i_BFu7s { signed short v1:7; unsigned int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFu7ll { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; };
struct BFs7s_BFu7i_BFu7ll_BFs7c { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFs7i { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFs7ll { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFs7s { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFu7c { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFu7i { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFu7ll { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFu7ll_BFu7s { signed short v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7i_BFu7s { signed short v1:7; unsigned int v2:7; unsigned short v3:7; };
struct BFs7s_BFu7i_BFu7s_BFs7c { signed short v1:7; unsigned int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFu7i_BFu7s_BFs7i { signed short v1:7; unsigned int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFu7i_BFu7s_BFs7ll { signed short v1:7; unsigned int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFu7i_BFu7s_BFs7s { signed short v1:7; unsigned int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFu7i_BFu7s_BFu7c { signed short v1:7; unsigned int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7i_BFu7s_BFu7i { signed short v1:7; unsigned int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7i_BFu7s_BFu7ll { signed short v1:7; unsigned int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7i_BFu7s_BFu7s { signed short v1:7; unsigned int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll { signed short v1:7; unsigned long long v2:7; };
struct BFs7s_BFu7ll_BFs7c { signed short v1:7; unsigned long long v2:7; signed char v3:7; };
struct BFs7s_BFu7ll_BFs7c_BFs7c { signed short v1:7; unsigned long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFs7i { signed short v1:7; unsigned long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFs7ll { signed short v1:7; unsigned long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFs7s { signed short v1:7; unsigned long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFu7c { signed short v1:7; unsigned long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFu7i { signed short v1:7; unsigned long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFu7ll { signed short v1:7; unsigned long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFs7c_BFu7s { signed short v1:7; unsigned long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFs7i { signed short v1:7; unsigned long long v2:7; signed int v3:7; };
struct BFs7s_BFu7ll_BFs7i_BFs7c { signed short v1:7; unsigned long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFs7i { signed short v1:7; unsigned long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFs7ll { signed short v1:7; unsigned long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFs7s { signed short v1:7; unsigned long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFu7c { signed short v1:7; unsigned long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFu7i { signed short v1:7; unsigned long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFu7ll { signed short v1:7; unsigned long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFs7i_BFu7s { signed short v1:7; unsigned long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFs7ll { signed short v1:7; unsigned long long v2:7; signed long long v3:7; };
struct BFs7s_BFu7ll_BFs7ll_BFs7c { signed short v1:7; unsigned long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFs7i { signed short v1:7; unsigned long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFs7ll { signed short v1:7; unsigned long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFs7s { signed short v1:7; unsigned long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFu7c { signed short v1:7; unsigned long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFu7i { signed short v1:7; unsigned long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFu7ll { signed short v1:7; unsigned long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFs7ll_BFu7s { signed short v1:7; unsigned long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFs7s { signed short v1:7; unsigned long long v2:7; signed short v3:7; };
struct BFs7s_BFu7ll_BFs7s_BFs7c { signed short v1:7; unsigned long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFs7i { signed short v1:7; unsigned long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFs7ll { signed short v1:7; unsigned long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFs7s { signed short v1:7; unsigned long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFu7c { signed short v1:7; unsigned long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFu7i { signed short v1:7; unsigned long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFu7ll { signed short v1:7; unsigned long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFs7s_BFu7s { signed short v1:7; unsigned long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFu7c { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; };
struct BFs7s_BFu7ll_BFu7c_BFs7c { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFs7i { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFs7ll { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFs7s { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFu7c { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFu7i { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFu7ll { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFu7c_BFu7s { signed short v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFu7i { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; };
struct BFs7s_BFu7ll_BFu7i_BFs7c { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFs7i { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFs7ll { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFs7s { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFu7c { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFu7i { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFu7ll { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFu7i_BFu7s { signed short v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFu7ll { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; };
struct BFs7s_BFu7ll_BFu7ll_BFs7c { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFs7i { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFs7ll { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFs7s { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFu7c { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFu7i { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFu7ll { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFu7ll_BFu7s { signed short v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7ll_BFu7s { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; };
struct BFs7s_BFu7ll_BFu7s_BFs7c { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFs7i { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFs7ll { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFs7s { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFu7c { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFu7i { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFu7ll { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7ll_BFu7s_BFu7s { signed short v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s { signed short v1:7; unsigned short v2:7; };
struct BFs7s_BFu7s_BFs7c { signed short v1:7; unsigned short v2:7; signed char v3:7; };
struct BFs7s_BFu7s_BFs7c_BFs7c { signed short v1:7; unsigned short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFs7c_BFs7i { signed short v1:7; unsigned short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFs7c_BFs7ll { signed short v1:7; unsigned short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFs7c_BFs7s { signed short v1:7; unsigned short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFs7c_BFu7c { signed short v1:7; unsigned short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFs7c_BFu7i { signed short v1:7; unsigned short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFs7c_BFu7ll { signed short v1:7; unsigned short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFs7c_BFu7s { signed short v1:7; unsigned short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFs7i { signed short v1:7; unsigned short v2:7; signed int v3:7; };
struct BFs7s_BFu7s_BFs7i_BFs7c { signed short v1:7; unsigned short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFs7i_BFs7i { signed short v1:7; unsigned short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFs7i_BFs7ll { signed short v1:7; unsigned short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFs7i_BFs7s { signed short v1:7; unsigned short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFs7i_BFu7c { signed short v1:7; unsigned short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFs7i_BFu7i { signed short v1:7; unsigned short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFs7i_BFu7ll { signed short v1:7; unsigned short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFs7i_BFu7s { signed short v1:7; unsigned short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFs7ll { signed short v1:7; unsigned short v2:7; signed long long v3:7; };
struct BFs7s_BFu7s_BFs7ll_BFs7c { signed short v1:7; unsigned short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFs7i { signed short v1:7; unsigned short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFs7ll { signed short v1:7; unsigned short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFs7s { signed short v1:7; unsigned short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFu7c { signed short v1:7; unsigned short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFu7i { signed short v1:7; unsigned short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFu7ll { signed short v1:7; unsigned short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFs7ll_BFu7s { signed short v1:7; unsigned short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFs7s { signed short v1:7; unsigned short v2:7; signed short v3:7; };
struct BFs7s_BFu7s_BFs7s_BFs7c { signed short v1:7; unsigned short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFs7s_BFs7i { signed short v1:7; unsigned short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFs7s_BFs7ll { signed short v1:7; unsigned short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFs7s_BFs7s { signed short v1:7; unsigned short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFs7s_BFu7c { signed short v1:7; unsigned short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFs7s_BFu7i { signed short v1:7; unsigned short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFs7s_BFu7ll { signed short v1:7; unsigned short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFs7s_BFu7s { signed short v1:7; unsigned short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFu7c { signed short v1:7; unsigned short v2:7; unsigned char v3:7; };
struct BFs7s_BFu7s_BFu7c_BFs7c { signed short v1:7; unsigned short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFu7c_BFs7i { signed short v1:7; unsigned short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFu7c_BFs7ll { signed short v1:7; unsigned short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFu7c_BFs7s { signed short v1:7; unsigned short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFu7c_BFu7c { signed short v1:7; unsigned short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFu7c_BFu7i { signed short v1:7; unsigned short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFu7c_BFu7ll { signed short v1:7; unsigned short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFu7c_BFu7s { signed short v1:7; unsigned short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFu7i { signed short v1:7; unsigned short v2:7; unsigned int v3:7; };
struct BFs7s_BFu7s_BFu7i_BFs7c { signed short v1:7; unsigned short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFu7i_BFs7i { signed short v1:7; unsigned short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFu7i_BFs7ll { signed short v1:7; unsigned short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFu7i_BFs7s { signed short v1:7; unsigned short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFu7i_BFu7c { signed short v1:7; unsigned short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFu7i_BFu7i { signed short v1:7; unsigned short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFu7i_BFu7ll { signed short v1:7; unsigned short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFu7i_BFu7s { signed short v1:7; unsigned short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFu7ll { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; };
struct BFs7s_BFu7s_BFu7ll_BFs7c { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFs7i { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFs7ll { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFs7s { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFu7c { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFu7i { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFu7ll { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFu7ll_BFu7s { signed short v1:7; unsigned short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7s_BFu7s_BFu7s { signed short v1:7; unsigned short v2:7; unsigned short v3:7; };
struct BFs7s_BFu7s_BFu7s_BFs7c { signed short v1:7; unsigned short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7s_BFu7s_BFu7s_BFs7i { signed short v1:7; unsigned short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7s_BFu7s_BFu7s_BFs7ll { signed short v1:7; unsigned short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7s_BFu7s_BFu7s_BFs7s { signed short v1:7; unsigned short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7s_BFu7s_BFu7s_BFu7c { signed short v1:7; unsigned short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7s_BFu7s_BFu7s_BFu7i { signed short v1:7; unsigned short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7s_BFu7s_BFu7s_BFu7ll { signed short v1:7; unsigned short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7s_BFu7s_BFu7s_BFu7s { signed short v1:7; unsigned short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs8c_BFs8c { signed char v1:8; signed char v2:8; };
struct BFs8c_BFs8c_BFs8c { signed char v1:8; signed char v2:8; signed char v3:8; };
struct BFs8c_BFs8c_BFs8c_BFs8c { signed char v1:8; signed char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFs8c_BFs8i { signed char v1:8; signed char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFs8c_BFs8ll { signed char v1:8; signed char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFs8c_BFs8s { signed char v1:8; signed char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFs8c_BFu8c { signed char v1:8; signed char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFs8c_BFu8i { signed char v1:8; signed char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFs8c_BFu8ll { signed char v1:8; signed char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFs8c_BFu8s { signed char v1:8; signed char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFs8i { signed char v1:8; signed char v2:8; signed int v3:8; };
struct BFs8c_BFs8c_BFs8i_BFs8c { signed char v1:8; signed char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFs8i_BFs8i { signed char v1:8; signed char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFs8i_BFs8ll { signed char v1:8; signed char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFs8i_BFs8s { signed char v1:8; signed char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFs8i_BFu8c { signed char v1:8; signed char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFs8i_BFu8i { signed char v1:8; signed char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFs8i_BFu8ll { signed char v1:8; signed char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFs8i_BFu8s { signed char v1:8; signed char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFs8ll { signed char v1:8; signed char v2:8; signed long long v3:8; };
struct BFs8c_BFs8c_BFs8ll_BFs8c { signed char v1:8; signed char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFs8i { signed char v1:8; signed char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFs8ll { signed char v1:8; signed char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFs8s { signed char v1:8; signed char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFu8c { signed char v1:8; signed char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFu8i { signed char v1:8; signed char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFu8ll { signed char v1:8; signed char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFs8ll_BFu8s { signed char v1:8; signed char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFs8s { signed char v1:8; signed char v2:8; signed short v3:8; };
struct BFs8c_BFs8c_BFs8s_BFs8c { signed char v1:8; signed char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFs8s_BFs8i { signed char v1:8; signed char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFs8s_BFs8ll { signed char v1:8; signed char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFs8s_BFs8s { signed char v1:8; signed char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFs8s_BFu8c { signed char v1:8; signed char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFs8s_BFu8i { signed char v1:8; signed char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFs8s_BFu8ll { signed char v1:8; signed char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFs8s_BFu8s { signed char v1:8; signed char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFu8c { signed char v1:8; signed char v2:8; unsigned char v3:8; };
struct BFs8c_BFs8c_BFu8c_BFs8c { signed char v1:8; signed char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFu8c_BFs8i { signed char v1:8; signed char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFu8c_BFs8ll { signed char v1:8; signed char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFu8c_BFs8s { signed char v1:8; signed char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFu8c_BFu8c { signed char v1:8; signed char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFu8c_BFu8i { signed char v1:8; signed char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFu8c_BFu8ll { signed char v1:8; signed char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFu8c_BFu8s { signed char v1:8; signed char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFu8i { signed char v1:8; signed char v2:8; unsigned int v3:8; };
struct BFs8c_BFs8c_BFu8i_BFs8c { signed char v1:8; signed char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFu8i_BFs8i { signed char v1:8; signed char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFu8i_BFs8ll { signed char v1:8; signed char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFu8i_BFs8s { signed char v1:8; signed char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFu8i_BFu8c { signed char v1:8; signed char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFu8i_BFu8i { signed char v1:8; signed char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFu8i_BFu8ll { signed char v1:8; signed char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFu8i_BFu8s { signed char v1:8; signed char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFu8ll { signed char v1:8; signed char v2:8; unsigned long long v3:8; };
struct BFs8c_BFs8c_BFu8ll_BFs8c { signed char v1:8; signed char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFs8i { signed char v1:8; signed char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFs8ll { signed char v1:8; signed char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFs8s { signed char v1:8; signed char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFu8c { signed char v1:8; signed char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFu8i { signed char v1:8; signed char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFu8ll { signed char v1:8; signed char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFu8ll_BFu8s { signed char v1:8; signed char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8c_BFu8s { signed char v1:8; signed char v2:8; unsigned short v3:8; };
struct BFs8c_BFs8c_BFu8s_BFs8c { signed char v1:8; signed char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFs8c_BFu8s_BFs8i { signed char v1:8; signed char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFs8c_BFu8s_BFs8ll { signed char v1:8; signed char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFs8c_BFu8s_BFs8s { signed char v1:8; signed char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFs8c_BFu8s_BFu8c { signed char v1:8; signed char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8c_BFu8s_BFu8i { signed char v1:8; signed char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8c_BFu8s_BFu8ll { signed char v1:8; signed char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8c_BFu8s_BFu8s { signed char v1:8; signed char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i { signed char v1:8; signed int v2:8; };
struct BFs8c_BFs8i_BFs8c { signed char v1:8; signed int v2:8; signed char v3:8; };
struct BFs8c_BFs8i_BFs8c_BFs8c { signed char v1:8; signed int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFs8c_BFs8i { signed char v1:8; signed int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFs8c_BFs8ll { signed char v1:8; signed int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFs8c_BFs8s { signed char v1:8; signed int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFs8c_BFu8c { signed char v1:8; signed int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFs8c_BFu8i { signed char v1:8; signed int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFs8c_BFu8ll { signed char v1:8; signed int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFs8c_BFu8s { signed char v1:8; signed int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFs8i { signed char v1:8; signed int v2:8; signed int v3:8; };
struct BFs8c_BFs8i_BFs8i_BFs8c { signed char v1:8; signed int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFs8i_BFs8i { signed char v1:8; signed int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFs8i_BFs8ll { signed char v1:8; signed int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFs8i_BFs8s { signed char v1:8; signed int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFs8i_BFu8c { signed char v1:8; signed int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFs8i_BFu8i { signed char v1:8; signed int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFs8i_BFu8ll { signed char v1:8; signed int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFs8i_BFu8s { signed char v1:8; signed int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFs8ll { signed char v1:8; signed int v2:8; signed long long v3:8; };
struct BFs8c_BFs8i_BFs8ll_BFs8c { signed char v1:8; signed int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFs8i { signed char v1:8; signed int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFs8ll { signed char v1:8; signed int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFs8s { signed char v1:8; signed int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFu8c { signed char v1:8; signed int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFu8i { signed char v1:8; signed int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFu8ll { signed char v1:8; signed int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFs8ll_BFu8s { signed char v1:8; signed int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFs8s { signed char v1:8; signed int v2:8; signed short v3:8; };
struct BFs8c_BFs8i_BFs8s_BFs8c { signed char v1:8; signed int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFs8s_BFs8i { signed char v1:8; signed int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFs8s_BFs8ll { signed char v1:8; signed int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFs8s_BFs8s { signed char v1:8; signed int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFs8s_BFu8c { signed char v1:8; signed int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFs8s_BFu8i { signed char v1:8; signed int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFs8s_BFu8ll { signed char v1:8; signed int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFs8s_BFu8s { signed char v1:8; signed int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFu8c { signed char v1:8; signed int v2:8; unsigned char v3:8; };
struct BFs8c_BFs8i_BFu8c_BFs8c { signed char v1:8; signed int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFu8c_BFs8i { signed char v1:8; signed int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFu8c_BFs8ll { signed char v1:8; signed int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFu8c_BFs8s { signed char v1:8; signed int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFu8c_BFu8c { signed char v1:8; signed int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFu8c_BFu8i { signed char v1:8; signed int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFu8c_BFu8ll { signed char v1:8; signed int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFu8c_BFu8s { signed char v1:8; signed int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFu8i { signed char v1:8; signed int v2:8; unsigned int v3:8; };
struct BFs8c_BFs8i_BFu8i_BFs8c { signed char v1:8; signed int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFu8i_BFs8i { signed char v1:8; signed int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFu8i_BFs8ll { signed char v1:8; signed int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFu8i_BFs8s { signed char v1:8; signed int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFu8i_BFu8c { signed char v1:8; signed int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFu8i_BFu8i { signed char v1:8; signed int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFu8i_BFu8ll { signed char v1:8; signed int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFu8i_BFu8s { signed char v1:8; signed int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFu8ll { signed char v1:8; signed int v2:8; unsigned long long v3:8; };
struct BFs8c_BFs8i_BFu8ll_BFs8c { signed char v1:8; signed int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFs8i { signed char v1:8; signed int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFs8ll { signed char v1:8; signed int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFs8s { signed char v1:8; signed int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFu8c { signed char v1:8; signed int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFu8i { signed char v1:8; signed int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFu8ll { signed char v1:8; signed int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFu8ll_BFu8s { signed char v1:8; signed int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8i_BFu8s { signed char v1:8; signed int v2:8; unsigned short v3:8; };
struct BFs8c_BFs8i_BFu8s_BFs8c { signed char v1:8; signed int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFs8i_BFu8s_BFs8i { signed char v1:8; signed int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFs8i_BFu8s_BFs8ll { signed char v1:8; signed int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFs8i_BFu8s_BFs8s { signed char v1:8; signed int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFs8i_BFu8s_BFu8c { signed char v1:8; signed int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8i_BFu8s_BFu8i { signed char v1:8; signed int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8i_BFu8s_BFu8ll { signed char v1:8; signed int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8i_BFu8s_BFu8s { signed char v1:8; signed int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll { signed char v1:8; signed long long v2:8; };
struct BFs8c_BFs8ll_BFs8c { signed char v1:8; signed long long v2:8; signed char v3:8; };
struct BFs8c_BFs8ll_BFs8c_BFs8c { signed char v1:8; signed long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFs8i { signed char v1:8; signed long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFs8ll { signed char v1:8; signed long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFs8s { signed char v1:8; signed long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFu8c { signed char v1:8; signed long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFu8i { signed char v1:8; signed long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFu8ll { signed char v1:8; signed long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFs8c_BFu8s { signed char v1:8; signed long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFs8i { signed char v1:8; signed long long v2:8; signed int v3:8; };
struct BFs8c_BFs8ll_BFs8i_BFs8c { signed char v1:8; signed long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFs8i { signed char v1:8; signed long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFs8ll { signed char v1:8; signed long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFs8s { signed char v1:8; signed long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFu8c { signed char v1:8; signed long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFu8i { signed char v1:8; signed long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFu8ll { signed char v1:8; signed long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFs8i_BFu8s { signed char v1:8; signed long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFs8ll { signed char v1:8; signed long long v2:8; signed long long v3:8; };
struct BFs8c_BFs8ll_BFs8ll_BFs8c { signed char v1:8; signed long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFs8i { signed char v1:8; signed long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFs8ll { signed char v1:8; signed long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFs8s { signed char v1:8; signed long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFu8c { signed char v1:8; signed long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFu8i { signed char v1:8; signed long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFu8ll { signed char v1:8; signed long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFs8ll_BFu8s { signed char v1:8; signed long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFs8s { signed char v1:8; signed long long v2:8; signed short v3:8; };
struct BFs8c_BFs8ll_BFs8s_BFs8c { signed char v1:8; signed long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFs8i { signed char v1:8; signed long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFs8ll { signed char v1:8; signed long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFs8s { signed char v1:8; signed long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFu8c { signed char v1:8; signed long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFu8i { signed char v1:8; signed long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFu8ll { signed char v1:8; signed long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFs8s_BFu8s { signed char v1:8; signed long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFu8c { signed char v1:8; signed long long v2:8; unsigned char v3:8; };
struct BFs8c_BFs8ll_BFu8c_BFs8c { signed char v1:8; signed long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFs8i { signed char v1:8; signed long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFs8ll { signed char v1:8; signed long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFs8s { signed char v1:8; signed long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFu8c { signed char v1:8; signed long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFu8i { signed char v1:8; signed long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFu8ll { signed char v1:8; signed long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFu8c_BFu8s { signed char v1:8; signed long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFu8i { signed char v1:8; signed long long v2:8; unsigned int v3:8; };
struct BFs8c_BFs8ll_BFu8i_BFs8c { signed char v1:8; signed long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFs8i { signed char v1:8; signed long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFs8ll { signed char v1:8; signed long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFs8s { signed char v1:8; signed long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFu8c { signed char v1:8; signed long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFu8i { signed char v1:8; signed long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFu8ll { signed char v1:8; signed long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFu8i_BFu8s { signed char v1:8; signed long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFu8ll { signed char v1:8; signed long long v2:8; unsigned long long v3:8; };
struct BFs8c_BFs8ll_BFu8ll_BFs8c { signed char v1:8; signed long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFs8i { signed char v1:8; signed long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFs8ll { signed char v1:8; signed long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFs8s { signed char v1:8; signed long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFu8c { signed char v1:8; signed long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFu8i { signed char v1:8; signed long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFu8ll { signed char v1:8; signed long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFu8ll_BFu8s { signed char v1:8; signed long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8ll_BFu8s { signed char v1:8; signed long long v2:8; unsigned short v3:8; };
struct BFs8c_BFs8ll_BFu8s_BFs8c { signed char v1:8; signed long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFs8i { signed char v1:8; signed long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFs8ll { signed char v1:8; signed long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFs8s { signed char v1:8; signed long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFu8c { signed char v1:8; signed long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFu8i { signed char v1:8; signed long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFu8ll { signed char v1:8; signed long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8ll_BFu8s_BFu8s { signed char v1:8; signed long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s { signed char v1:8; signed short v2:8; };
struct BFs8c_BFs8s_BFs8c { signed char v1:8; signed short v2:8; signed char v3:8; };
struct BFs8c_BFs8s_BFs8c_BFs8c { signed char v1:8; signed short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFs8c_BFs8i { signed char v1:8; signed short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFs8c_BFs8ll { signed char v1:8; signed short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFs8c_BFs8s { signed char v1:8; signed short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFs8c_BFu8c { signed char v1:8; signed short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFs8c_BFu8i { signed char v1:8; signed short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFs8c_BFu8ll { signed char v1:8; signed short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFs8c_BFu8s { signed char v1:8; signed short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFs8i { signed char v1:8; signed short v2:8; signed int v3:8; };
struct BFs8c_BFs8s_BFs8i_BFs8c { signed char v1:8; signed short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFs8i_BFs8i { signed char v1:8; signed short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFs8i_BFs8ll { signed char v1:8; signed short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFs8i_BFs8s { signed char v1:8; signed short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFs8i_BFu8c { signed char v1:8; signed short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFs8i_BFu8i { signed char v1:8; signed short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFs8i_BFu8ll { signed char v1:8; signed short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFs8i_BFu8s { signed char v1:8; signed short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFs8ll { signed char v1:8; signed short v2:8; signed long long v3:8; };
struct BFs8c_BFs8s_BFs8ll_BFs8c { signed char v1:8; signed short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFs8i { signed char v1:8; signed short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFs8ll { signed char v1:8; signed short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFs8s { signed char v1:8; signed short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFu8c { signed char v1:8; signed short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFu8i { signed char v1:8; signed short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFu8ll { signed char v1:8; signed short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFs8ll_BFu8s { signed char v1:8; signed short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFs8s { signed char v1:8; signed short v2:8; signed short v3:8; };
struct BFs8c_BFs8s_BFs8s_BFs8c { signed char v1:8; signed short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFs8s_BFs8i { signed char v1:8; signed short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFs8s_BFs8ll { signed char v1:8; signed short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFs8s_BFs8s { signed char v1:8; signed short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFs8s_BFu8c { signed char v1:8; signed short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFs8s_BFu8i { signed char v1:8; signed short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFs8s_BFu8ll { signed char v1:8; signed short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFs8s_BFu8s { signed char v1:8; signed short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFu8c { signed char v1:8; signed short v2:8; unsigned char v3:8; };
struct BFs8c_BFs8s_BFu8c_BFs8c { signed char v1:8; signed short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFu8c_BFs8i { signed char v1:8; signed short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFu8c_BFs8ll { signed char v1:8; signed short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFu8c_BFs8s { signed char v1:8; signed short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFu8c_BFu8c { signed char v1:8; signed short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFu8c_BFu8i { signed char v1:8; signed short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFu8c_BFu8ll { signed char v1:8; signed short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFu8c_BFu8s { signed char v1:8; signed short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFu8i { signed char v1:8; signed short v2:8; unsigned int v3:8; };
struct BFs8c_BFs8s_BFu8i_BFs8c { signed char v1:8; signed short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFu8i_BFs8i { signed char v1:8; signed short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFu8i_BFs8ll { signed char v1:8; signed short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFu8i_BFs8s { signed char v1:8; signed short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFu8i_BFu8c { signed char v1:8; signed short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFu8i_BFu8i { signed char v1:8; signed short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFu8i_BFu8ll { signed char v1:8; signed short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFu8i_BFu8s { signed char v1:8; signed short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFu8ll { signed char v1:8; signed short v2:8; unsigned long long v3:8; };
struct BFs8c_BFs8s_BFu8ll_BFs8c { signed char v1:8; signed short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFs8i { signed char v1:8; signed short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFs8ll { signed char v1:8; signed short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFs8s { signed char v1:8; signed short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFu8c { signed char v1:8; signed short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFu8i { signed char v1:8; signed short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFu8ll { signed char v1:8; signed short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFu8ll_BFu8s { signed char v1:8; signed short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFs8s_BFu8s { signed char v1:8; signed short v2:8; unsigned short v3:8; };
struct BFs8c_BFs8s_BFu8s_BFs8c { signed char v1:8; signed short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFs8s_BFu8s_BFs8i { signed char v1:8; signed short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFs8s_BFu8s_BFs8ll { signed char v1:8; signed short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFs8s_BFu8s_BFs8s { signed char v1:8; signed short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFs8s_BFu8s_BFu8c { signed char v1:8; signed short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFs8s_BFu8s_BFu8i { signed char v1:8; signed short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFs8s_BFu8s_BFu8ll { signed char v1:8; signed short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFs8s_BFu8s_BFu8s { signed char v1:8; signed short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c { signed char v1:8; unsigned char v2:8; };
struct BFs8c_BFu8c_BFs8c { signed char v1:8; unsigned char v2:8; signed char v3:8; };
struct BFs8c_BFu8c_BFs8c_BFs8c { signed char v1:8; unsigned char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFs8c_BFs8i { signed char v1:8; unsigned char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFs8c_BFs8ll { signed char v1:8; unsigned char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFs8c_BFs8s { signed char v1:8; unsigned char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFs8c_BFu8c { signed char v1:8; unsigned char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFs8c_BFu8i { signed char v1:8; unsigned char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFs8c_BFu8ll { signed char v1:8; unsigned char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFs8c_BFu8s { signed char v1:8; unsigned char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFs8i { signed char v1:8; unsigned char v2:8; signed int v3:8; };
struct BFs8c_BFu8c_BFs8i_BFs8c { signed char v1:8; unsigned char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFs8i_BFs8i { signed char v1:8; unsigned char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFs8i_BFs8ll { signed char v1:8; unsigned char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFs8i_BFs8s { signed char v1:8; unsigned char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFs8i_BFu8c { signed char v1:8; unsigned char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFs8i_BFu8i { signed char v1:8; unsigned char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFs8i_BFu8ll { signed char v1:8; unsigned char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFs8i_BFu8s { signed char v1:8; unsigned char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFs8ll { signed char v1:8; unsigned char v2:8; signed long long v3:8; };
struct BFs8c_BFu8c_BFs8ll_BFs8c { signed char v1:8; unsigned char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFs8i { signed char v1:8; unsigned char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFs8ll { signed char v1:8; unsigned char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFs8s { signed char v1:8; unsigned char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFu8c { signed char v1:8; unsigned char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFu8i { signed char v1:8; unsigned char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFu8ll { signed char v1:8; unsigned char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFs8ll_BFu8s { signed char v1:8; unsigned char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFs8s { signed char v1:8; unsigned char v2:8; signed short v3:8; };
struct BFs8c_BFu8c_BFs8s_BFs8c { signed char v1:8; unsigned char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFs8s_BFs8i { signed char v1:8; unsigned char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFs8s_BFs8ll { signed char v1:8; unsigned char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFs8s_BFs8s { signed char v1:8; unsigned char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFs8s_BFu8c { signed char v1:8; unsigned char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFs8s_BFu8i { signed char v1:8; unsigned char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFs8s_BFu8ll { signed char v1:8; unsigned char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFs8s_BFu8s { signed char v1:8; unsigned char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFu8c { signed char v1:8; unsigned char v2:8; unsigned char v3:8; };
struct BFs8c_BFu8c_BFu8c_BFs8c { signed char v1:8; unsigned char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFu8c_BFs8i { signed char v1:8; unsigned char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFu8c_BFs8ll { signed char v1:8; unsigned char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFu8c_BFs8s { signed char v1:8; unsigned char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFu8c_BFu8c { signed char v1:8; unsigned char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFu8c_BFu8i { signed char v1:8; unsigned char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFu8c_BFu8ll { signed char v1:8; unsigned char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFu8c_BFu8s { signed char v1:8; unsigned char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFu8i { signed char v1:8; unsigned char v2:8; unsigned int v3:8; };
struct BFs8c_BFu8c_BFu8i_BFs8c { signed char v1:8; unsigned char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFu8i_BFs8i { signed char v1:8; unsigned char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFu8i_BFs8ll { signed char v1:8; unsigned char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFu8i_BFs8s { signed char v1:8; unsigned char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFu8i_BFu8c { signed char v1:8; unsigned char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFu8i_BFu8i { signed char v1:8; unsigned char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFu8i_BFu8ll { signed char v1:8; unsigned char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFu8i_BFu8s { signed char v1:8; unsigned char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFu8ll { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; };
struct BFs8c_BFu8c_BFu8ll_BFs8c { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFs8i { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFs8ll { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFs8s { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFu8c { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFu8i { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFu8ll { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFu8ll_BFu8s { signed char v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8c_BFu8s { signed char v1:8; unsigned char v2:8; unsigned short v3:8; };
struct BFs8c_BFu8c_BFu8s_BFs8c { signed char v1:8; unsigned char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFu8c_BFu8s_BFs8i { signed char v1:8; unsigned char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFu8c_BFu8s_BFs8ll { signed char v1:8; unsigned char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFu8c_BFu8s_BFs8s { signed char v1:8; unsigned char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFu8c_BFu8s_BFu8c { signed char v1:8; unsigned char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8c_BFu8s_BFu8i { signed char v1:8; unsigned char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8c_BFu8s_BFu8ll { signed char v1:8; unsigned char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8c_BFu8s_BFu8s { signed char v1:8; unsigned char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i { signed char v1:8; unsigned int v2:8; };
struct BFs8c_BFu8i_BFs8c { signed char v1:8; unsigned int v2:8; signed char v3:8; };
struct BFs8c_BFu8i_BFs8c_BFs8c { signed char v1:8; unsigned int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFs8c_BFs8i { signed char v1:8; unsigned int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFs8c_BFs8ll { signed char v1:8; unsigned int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFs8c_BFs8s { signed char v1:8; unsigned int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFs8c_BFu8c { signed char v1:8; unsigned int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFs8c_BFu8i { signed char v1:8; unsigned int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFs8c_BFu8ll { signed char v1:8; unsigned int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFs8c_BFu8s { signed char v1:8; unsigned int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFs8i { signed char v1:8; unsigned int v2:8; signed int v3:8; };
struct BFs8c_BFu8i_BFs8i_BFs8c { signed char v1:8; unsigned int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFs8i_BFs8i { signed char v1:8; unsigned int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFs8i_BFs8ll { signed char v1:8; unsigned int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFs8i_BFs8s { signed char v1:8; unsigned int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFs8i_BFu8c { signed char v1:8; unsigned int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFs8i_BFu8i { signed char v1:8; unsigned int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFs8i_BFu8ll { signed char v1:8; unsigned int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFs8i_BFu8s { signed char v1:8; unsigned int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFs8ll { signed char v1:8; unsigned int v2:8; signed long long v3:8; };
struct BFs8c_BFu8i_BFs8ll_BFs8c { signed char v1:8; unsigned int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFs8i { signed char v1:8; unsigned int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFs8ll { signed char v1:8; unsigned int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFs8s { signed char v1:8; unsigned int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFu8c { signed char v1:8; unsigned int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFu8i { signed char v1:8; unsigned int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFu8ll { signed char v1:8; unsigned int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFs8ll_BFu8s { signed char v1:8; unsigned int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFs8s { signed char v1:8; unsigned int v2:8; signed short v3:8; };
struct BFs8c_BFu8i_BFs8s_BFs8c { signed char v1:8; unsigned int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFs8s_BFs8i { signed char v1:8; unsigned int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFs8s_BFs8ll { signed char v1:8; unsigned int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFs8s_BFs8s { signed char v1:8; unsigned int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFs8s_BFu8c { signed char v1:8; unsigned int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFs8s_BFu8i { signed char v1:8; unsigned int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFs8s_BFu8ll { signed char v1:8; unsigned int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFs8s_BFu8s { signed char v1:8; unsigned int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFu8c { signed char v1:8; unsigned int v2:8; unsigned char v3:8; };
struct BFs8c_BFu8i_BFu8c_BFs8c { signed char v1:8; unsigned int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFu8c_BFs8i { signed char v1:8; unsigned int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFu8c_BFs8ll { signed char v1:8; unsigned int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFu8c_BFs8s { signed char v1:8; unsigned int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFu8c_BFu8c { signed char v1:8; unsigned int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFu8c_BFu8i { signed char v1:8; unsigned int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFu8c_BFu8ll { signed char v1:8; unsigned int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFu8c_BFu8s { signed char v1:8; unsigned int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFu8i { signed char v1:8; unsigned int v2:8; unsigned int v3:8; };
struct BFs8c_BFu8i_BFu8i_BFs8c { signed char v1:8; unsigned int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFu8i_BFs8i { signed char v1:8; unsigned int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFu8i_BFs8ll { signed char v1:8; unsigned int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFu8i_BFs8s { signed char v1:8; unsigned int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFu8i_BFu8c { signed char v1:8; unsigned int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFu8i_BFu8i { signed char v1:8; unsigned int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFu8i_BFu8ll { signed char v1:8; unsigned int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFu8i_BFu8s { signed char v1:8; unsigned int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFu8ll { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; };
struct BFs8c_BFu8i_BFu8ll_BFs8c { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFs8i { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFs8ll { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFs8s { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFu8c { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFu8i { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFu8ll { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFu8ll_BFu8s { signed char v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8i_BFu8s { signed char v1:8; unsigned int v2:8; unsigned short v3:8; };
struct BFs8c_BFu8i_BFu8s_BFs8c { signed char v1:8; unsigned int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFu8i_BFu8s_BFs8i { signed char v1:8; unsigned int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFu8i_BFu8s_BFs8ll { signed char v1:8; unsigned int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFu8i_BFu8s_BFs8s { signed char v1:8; unsigned int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFu8i_BFu8s_BFu8c { signed char v1:8; unsigned int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8i_BFu8s_BFu8i { signed char v1:8; unsigned int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8i_BFu8s_BFu8ll { signed char v1:8; unsigned int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8i_BFu8s_BFu8s { signed char v1:8; unsigned int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll { signed char v1:8; unsigned long long v2:8; };
struct BFs8c_BFu8ll_BFs8c { signed char v1:8; unsigned long long v2:8; signed char v3:8; };
struct BFs8c_BFu8ll_BFs8c_BFs8c { signed char v1:8; unsigned long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFs8i { signed char v1:8; unsigned long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFs8ll { signed char v1:8; unsigned long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFs8s { signed char v1:8; unsigned long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFu8c { signed char v1:8; unsigned long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFu8i { signed char v1:8; unsigned long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFu8ll { signed char v1:8; unsigned long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFs8c_BFu8s { signed char v1:8; unsigned long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFs8i { signed char v1:8; unsigned long long v2:8; signed int v3:8; };
struct BFs8c_BFu8ll_BFs8i_BFs8c { signed char v1:8; unsigned long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFs8i { signed char v1:8; unsigned long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFs8ll { signed char v1:8; unsigned long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFs8s { signed char v1:8; unsigned long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFu8c { signed char v1:8; unsigned long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFu8i { signed char v1:8; unsigned long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFu8ll { signed char v1:8; unsigned long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFs8i_BFu8s { signed char v1:8; unsigned long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFs8ll { signed char v1:8; unsigned long long v2:8; signed long long v3:8; };
struct BFs8c_BFu8ll_BFs8ll_BFs8c { signed char v1:8; unsigned long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFs8i { signed char v1:8; unsigned long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFs8ll { signed char v1:8; unsigned long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFs8s { signed char v1:8; unsigned long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFu8c { signed char v1:8; unsigned long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFu8i { signed char v1:8; unsigned long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFu8ll { signed char v1:8; unsigned long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFs8ll_BFu8s { signed char v1:8; unsigned long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFs8s { signed char v1:8; unsigned long long v2:8; signed short v3:8; };
struct BFs8c_BFu8ll_BFs8s_BFs8c { signed char v1:8; unsigned long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFs8i { signed char v1:8; unsigned long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFs8ll { signed char v1:8; unsigned long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFs8s { signed char v1:8; unsigned long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFu8c { signed char v1:8; unsigned long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFu8i { signed char v1:8; unsigned long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFu8ll { signed char v1:8; unsigned long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFs8s_BFu8s { signed char v1:8; unsigned long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFu8c { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; };
struct BFs8c_BFu8ll_BFu8c_BFs8c { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFs8i { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFs8ll { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFs8s { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFu8c { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFu8i { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFu8ll { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFu8c_BFu8s { signed char v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFu8i { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; };
struct BFs8c_BFu8ll_BFu8i_BFs8c { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFs8i { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFs8ll { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFs8s { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFu8c { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFu8i { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFu8ll { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFu8i_BFu8s { signed char v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFu8ll { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; };
struct BFs8c_BFu8ll_BFu8ll_BFs8c { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFs8i { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFs8ll { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFs8s { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFu8c { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFu8i { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFu8ll { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFu8ll_BFu8s { signed char v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8ll_BFu8s { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; };
struct BFs8c_BFu8ll_BFu8s_BFs8c { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFs8i { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFs8ll { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFs8s { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFu8c { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFu8i { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFu8ll { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8ll_BFu8s_BFu8s { signed char v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s { signed char v1:8; unsigned short v2:8; };
struct BFs8c_BFu8s_BFs8c { signed char v1:8; unsigned short v2:8; signed char v3:8; };
struct BFs8c_BFu8s_BFs8c_BFs8c { signed char v1:8; unsigned short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFs8c_BFs8i { signed char v1:8; unsigned short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFs8c_BFs8ll { signed char v1:8; unsigned short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFs8c_BFs8s { signed char v1:8; unsigned short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFs8c_BFu8c { signed char v1:8; unsigned short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFs8c_BFu8i { signed char v1:8; unsigned short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFs8c_BFu8ll { signed char v1:8; unsigned short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFs8c_BFu8s { signed char v1:8; unsigned short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFs8i { signed char v1:8; unsigned short v2:8; signed int v3:8; };
struct BFs8c_BFu8s_BFs8i_BFs8c { signed char v1:8; unsigned short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFs8i_BFs8i { signed char v1:8; unsigned short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFs8i_BFs8ll { signed char v1:8; unsigned short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFs8i_BFs8s { signed char v1:8; unsigned short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFs8i_BFu8c { signed char v1:8; unsigned short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFs8i_BFu8i { signed char v1:8; unsigned short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFs8i_BFu8ll { signed char v1:8; unsigned short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFs8i_BFu8s { signed char v1:8; unsigned short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFs8ll { signed char v1:8; unsigned short v2:8; signed long long v3:8; };
struct BFs8c_BFu8s_BFs8ll_BFs8c { signed char v1:8; unsigned short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFs8i { signed char v1:8; unsigned short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFs8ll { signed char v1:8; unsigned short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFs8s { signed char v1:8; unsigned short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFu8c { signed char v1:8; unsigned short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFu8i { signed char v1:8; unsigned short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFu8ll { signed char v1:8; unsigned short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFs8ll_BFu8s { signed char v1:8; unsigned short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFs8s { signed char v1:8; unsigned short v2:8; signed short v3:8; };
struct BFs8c_BFu8s_BFs8s_BFs8c { signed char v1:8; unsigned short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFs8s_BFs8i { signed char v1:8; unsigned short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFs8s_BFs8ll { signed char v1:8; unsigned short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFs8s_BFs8s { signed char v1:8; unsigned short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFs8s_BFu8c { signed char v1:8; unsigned short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFs8s_BFu8i { signed char v1:8; unsigned short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFs8s_BFu8ll { signed char v1:8; unsigned short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFs8s_BFu8s { signed char v1:8; unsigned short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFu8c { signed char v1:8; unsigned short v2:8; unsigned char v3:8; };
struct BFs8c_BFu8s_BFu8c_BFs8c { signed char v1:8; unsigned short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFu8c_BFs8i { signed char v1:8; unsigned short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFu8c_BFs8ll { signed char v1:8; unsigned short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFu8c_BFs8s { signed char v1:8; unsigned short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFu8c_BFu8c { signed char v1:8; unsigned short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFu8c_BFu8i { signed char v1:8; unsigned short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFu8c_BFu8ll { signed char v1:8; unsigned short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFu8c_BFu8s { signed char v1:8; unsigned short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFu8i { signed char v1:8; unsigned short v2:8; unsigned int v3:8; };
struct BFs8c_BFu8s_BFu8i_BFs8c { signed char v1:8; unsigned short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFu8i_BFs8i { signed char v1:8; unsigned short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFu8i_BFs8ll { signed char v1:8; unsigned short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFu8i_BFs8s { signed char v1:8; unsigned short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFu8i_BFu8c { signed char v1:8; unsigned short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFu8i_BFu8i { signed char v1:8; unsigned short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFu8i_BFu8ll { signed char v1:8; unsigned short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFu8i_BFu8s { signed char v1:8; unsigned short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFu8ll { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; };
struct BFs8c_BFu8s_BFu8ll_BFs8c { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFs8i { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFs8ll { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFs8s { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFu8c { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFu8i { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFu8ll { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFu8ll_BFu8s { signed char v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8c_BFu8s_BFu8s { signed char v1:8; unsigned short v2:8; unsigned short v3:8; };
struct BFs8c_BFu8s_BFu8s_BFs8c { signed char v1:8; unsigned short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8c_BFu8s_BFu8s_BFs8i { signed char v1:8; unsigned short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8c_BFu8s_BFu8s_BFs8ll { signed char v1:8; unsigned short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8c_BFu8s_BFu8s_BFs8s { signed char v1:8; unsigned short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8c_BFu8s_BFu8s_BFu8c { signed char v1:8; unsigned short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8c_BFu8s_BFu8s_BFu8i { signed char v1:8; unsigned short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8c_BFu8s_BFu8s_BFu8ll { signed char v1:8; unsigned short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8c_BFu8s_BFu8s_BFu8s { signed char v1:8; unsigned short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c { signed int v1:8; signed char v2:8; };
struct BFs8i_BFs8c_BFs8c { signed int v1:8; signed char v2:8; signed char v3:8; };
struct BFs8i_BFs8c_BFs8c_BFs8c { signed int v1:8; signed char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFs8c_BFs8i { signed int v1:8; signed char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFs8c_BFs8ll { signed int v1:8; signed char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFs8c_BFs8s { signed int v1:8; signed char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFs8c_BFu8c { signed int v1:8; signed char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFs8c_BFu8i { signed int v1:8; signed char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFs8c_BFu8ll { signed int v1:8; signed char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFs8c_BFu8s { signed int v1:8; signed char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFs8i { signed int v1:8; signed char v2:8; signed int v3:8; };
struct BFs8i_BFs8c_BFs8i_BFs8c { signed int v1:8; signed char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFs8i_BFs8i { signed int v1:8; signed char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFs8i_BFs8ll { signed int v1:8; signed char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFs8i_BFs8s { signed int v1:8; signed char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFs8i_BFu8c { signed int v1:8; signed char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFs8i_BFu8i { signed int v1:8; signed char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFs8i_BFu8ll { signed int v1:8; signed char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFs8i_BFu8s { signed int v1:8; signed char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFs8ll { signed int v1:8; signed char v2:8; signed long long v3:8; };
struct BFs8i_BFs8c_BFs8ll_BFs8c { signed int v1:8; signed char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFs8i { signed int v1:8; signed char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFs8ll { signed int v1:8; signed char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFs8s { signed int v1:8; signed char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFu8c { signed int v1:8; signed char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFu8i { signed int v1:8; signed char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFu8ll { signed int v1:8; signed char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFs8ll_BFu8s { signed int v1:8; signed char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFs8s { signed int v1:8; signed char v2:8; signed short v3:8; };
struct BFs8i_BFs8c_BFs8s_BFs8c { signed int v1:8; signed char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFs8s_BFs8i { signed int v1:8; signed char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFs8s_BFs8ll { signed int v1:8; signed char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFs8s_BFs8s { signed int v1:8; signed char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFs8s_BFu8c { signed int v1:8; signed char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFs8s_BFu8i { signed int v1:8; signed char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFs8s_BFu8ll { signed int v1:8; signed char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFs8s_BFu8s { signed int v1:8; signed char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFu8c { signed int v1:8; signed char v2:8; unsigned char v3:8; };
struct BFs8i_BFs8c_BFu8c_BFs8c { signed int v1:8; signed char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFu8c_BFs8i { signed int v1:8; signed char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFu8c_BFs8ll { signed int v1:8; signed char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFu8c_BFs8s { signed int v1:8; signed char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFu8c_BFu8c { signed int v1:8; signed char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFu8c_BFu8i { signed int v1:8; signed char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFu8c_BFu8ll { signed int v1:8; signed char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFu8c_BFu8s { signed int v1:8; signed char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFu8i { signed int v1:8; signed char v2:8; unsigned int v3:8; };
struct BFs8i_BFs8c_BFu8i_BFs8c { signed int v1:8; signed char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFu8i_BFs8i { signed int v1:8; signed char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFu8i_BFs8ll { signed int v1:8; signed char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFu8i_BFs8s { signed int v1:8; signed char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFu8i_BFu8c { signed int v1:8; signed char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFu8i_BFu8i { signed int v1:8; signed char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFu8i_BFu8ll { signed int v1:8; signed char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFu8i_BFu8s { signed int v1:8; signed char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFu8ll { signed int v1:8; signed char v2:8; unsigned long long v3:8; };
struct BFs8i_BFs8c_BFu8ll_BFs8c { signed int v1:8; signed char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFs8i { signed int v1:8; signed char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFs8ll { signed int v1:8; signed char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFs8s { signed int v1:8; signed char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFu8c { signed int v1:8; signed char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFu8i { signed int v1:8; signed char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFu8ll { signed int v1:8; signed char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFu8ll_BFu8s { signed int v1:8; signed char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8c_BFu8s { signed int v1:8; signed char v2:8; unsigned short v3:8; };
struct BFs8i_BFs8c_BFu8s_BFs8c { signed int v1:8; signed char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFs8c_BFu8s_BFs8i { signed int v1:8; signed char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFs8c_BFu8s_BFs8ll { signed int v1:8; signed char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFs8c_BFu8s_BFs8s { signed int v1:8; signed char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFs8c_BFu8s_BFu8c { signed int v1:8; signed char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8c_BFu8s_BFu8i { signed int v1:8; signed char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8c_BFu8s_BFu8ll { signed int v1:8; signed char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8c_BFu8s_BFu8s { signed int v1:8; signed char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i { signed int v1:8; signed int v2:8; };
struct BFs8i_BFs8i_BFs8c { signed int v1:8; signed int v2:8; signed char v3:8; };
struct BFs8i_BFs8i_BFs8c_BFs8c { signed int v1:8; signed int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFs8c_BFs8i { signed int v1:8; signed int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFs8c_BFs8ll { signed int v1:8; signed int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFs8c_BFs8s { signed int v1:8; signed int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFs8c_BFu8c { signed int v1:8; signed int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFs8c_BFu8i { signed int v1:8; signed int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFs8c_BFu8ll { signed int v1:8; signed int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFs8c_BFu8s { signed int v1:8; signed int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFs8i { signed int v1:8; signed int v2:8; signed int v3:8; };
struct BFs8i_BFs8i_BFs8i_BFs8c { signed int v1:8; signed int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFs8i_BFs8i { signed int v1:8; signed int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFs8i_BFs8ll { signed int v1:8; signed int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFs8i_BFs8s { signed int v1:8; signed int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFs8i_BFu8c { signed int v1:8; signed int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFs8i_BFu8i { signed int v1:8; signed int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFs8i_BFu8ll { signed int v1:8; signed int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFs8i_BFu8s { signed int v1:8; signed int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFs8ll { signed int v1:8; signed int v2:8; signed long long v3:8; };
struct BFs8i_BFs8i_BFs8ll_BFs8c { signed int v1:8; signed int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFs8i { signed int v1:8; signed int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFs8ll { signed int v1:8; signed int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFs8s { signed int v1:8; signed int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFu8c { signed int v1:8; signed int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFu8i { signed int v1:8; signed int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFu8ll { signed int v1:8; signed int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFs8ll_BFu8s { signed int v1:8; signed int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFs8s { signed int v1:8; signed int v2:8; signed short v3:8; };
struct BFs8i_BFs8i_BFs8s_BFs8c { signed int v1:8; signed int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFs8s_BFs8i { signed int v1:8; signed int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFs8s_BFs8ll { signed int v1:8; signed int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFs8s_BFs8s { signed int v1:8; signed int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFs8s_BFu8c { signed int v1:8; signed int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFs8s_BFu8i { signed int v1:8; signed int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFs8s_BFu8ll { signed int v1:8; signed int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFs8s_BFu8s { signed int v1:8; signed int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFu8c { signed int v1:8; signed int v2:8; unsigned char v3:8; };
struct BFs8i_BFs8i_BFu8c_BFs8c { signed int v1:8; signed int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFu8c_BFs8i { signed int v1:8; signed int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFu8c_BFs8ll { signed int v1:8; signed int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFu8c_BFs8s { signed int v1:8; signed int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFu8c_BFu8c { signed int v1:8; signed int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFu8c_BFu8i { signed int v1:8; signed int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFu8c_BFu8ll { signed int v1:8; signed int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFu8c_BFu8s { signed int v1:8; signed int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFu8i { signed int v1:8; signed int v2:8; unsigned int v3:8; };
struct BFs8i_BFs8i_BFu8i_BFs8c { signed int v1:8; signed int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFu8i_BFs8i { signed int v1:8; signed int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFu8i_BFs8ll { signed int v1:8; signed int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFu8i_BFs8s { signed int v1:8; signed int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFu8i_BFu8c { signed int v1:8; signed int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFu8i_BFu8i { signed int v1:8; signed int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFu8i_BFu8ll { signed int v1:8; signed int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFu8i_BFu8s { signed int v1:8; signed int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFu8ll { signed int v1:8; signed int v2:8; unsigned long long v3:8; };
struct BFs8i_BFs8i_BFu8ll_BFs8c { signed int v1:8; signed int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFs8i { signed int v1:8; signed int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFs8ll { signed int v1:8; signed int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFs8s { signed int v1:8; signed int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFu8c { signed int v1:8; signed int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFu8i { signed int v1:8; signed int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFu8ll { signed int v1:8; signed int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFu8ll_BFu8s { signed int v1:8; signed int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8i_BFu8s { signed int v1:8; signed int v2:8; unsigned short v3:8; };
struct BFs8i_BFs8i_BFu8s_BFs8c { signed int v1:8; signed int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFs8i_BFu8s_BFs8i { signed int v1:8; signed int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFs8i_BFu8s_BFs8ll { signed int v1:8; signed int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFs8i_BFu8s_BFs8s { signed int v1:8; signed int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFs8i_BFu8s_BFu8c { signed int v1:8; signed int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8i_BFu8s_BFu8i { signed int v1:8; signed int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8i_BFu8s_BFu8ll { signed int v1:8; signed int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8i_BFu8s_BFu8s { signed int v1:8; signed int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll { signed int v1:8; signed long long v2:8; };
struct BFs8i_BFs8ll_BFs8c { signed int v1:8; signed long long v2:8; signed char v3:8; };
struct BFs8i_BFs8ll_BFs8c_BFs8c { signed int v1:8; signed long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFs8i { signed int v1:8; signed long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFs8ll { signed int v1:8; signed long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFs8s { signed int v1:8; signed long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFu8c { signed int v1:8; signed long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFu8i { signed int v1:8; signed long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFu8ll { signed int v1:8; signed long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFs8c_BFu8s { signed int v1:8; signed long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFs8i { signed int v1:8; signed long long v2:8; signed int v3:8; };
struct BFs8i_BFs8ll_BFs8i_BFs8c { signed int v1:8; signed long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFs8i { signed int v1:8; signed long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFs8ll { signed int v1:8; signed long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFs8s { signed int v1:8; signed long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFu8c { signed int v1:8; signed long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFu8i { signed int v1:8; signed long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFu8ll { signed int v1:8; signed long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFs8i_BFu8s { signed int v1:8; signed long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFs8ll { signed int v1:8; signed long long v2:8; signed long long v3:8; };
struct BFs8i_BFs8ll_BFs8ll_BFs8c { signed int v1:8; signed long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFs8i { signed int v1:8; signed long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFs8ll { signed int v1:8; signed long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFs8s { signed int v1:8; signed long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFu8c { signed int v1:8; signed long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFu8i { signed int v1:8; signed long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFu8ll { signed int v1:8; signed long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFs8ll_BFu8s { signed int v1:8; signed long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFs8s { signed int v1:8; signed long long v2:8; signed short v3:8; };
struct BFs8i_BFs8ll_BFs8s_BFs8c { signed int v1:8; signed long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFs8i { signed int v1:8; signed long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFs8ll { signed int v1:8; signed long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFs8s { signed int v1:8; signed long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFu8c { signed int v1:8; signed long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFu8i { signed int v1:8; signed long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFu8ll { signed int v1:8; signed long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFs8s_BFu8s { signed int v1:8; signed long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFu8c { signed int v1:8; signed long long v2:8; unsigned char v3:8; };
struct BFs8i_BFs8ll_BFu8c_BFs8c { signed int v1:8; signed long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFs8i { signed int v1:8; signed long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFs8ll { signed int v1:8; signed long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFs8s { signed int v1:8; signed long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFu8c { signed int v1:8; signed long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFu8i { signed int v1:8; signed long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFu8ll { signed int v1:8; signed long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFu8c_BFu8s { signed int v1:8; signed long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFu8i { signed int v1:8; signed long long v2:8; unsigned int v3:8; };
struct BFs8i_BFs8ll_BFu8i_BFs8c { signed int v1:8; signed long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFs8i { signed int v1:8; signed long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFs8ll { signed int v1:8; signed long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFs8s { signed int v1:8; signed long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFu8c { signed int v1:8; signed long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFu8i { signed int v1:8; signed long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFu8ll { signed int v1:8; signed long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFu8i_BFu8s { signed int v1:8; signed long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFu8ll { signed int v1:8; signed long long v2:8; unsigned long long v3:8; };
struct BFs8i_BFs8ll_BFu8ll_BFs8c { signed int v1:8; signed long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFs8i { signed int v1:8; signed long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFs8ll { signed int v1:8; signed long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFs8s { signed int v1:8; signed long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFu8c { signed int v1:8; signed long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFu8i { signed int v1:8; signed long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFu8ll { signed int v1:8; signed long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFu8ll_BFu8s { signed int v1:8; signed long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8ll_BFu8s { signed int v1:8; signed long long v2:8; unsigned short v3:8; };
struct BFs8i_BFs8ll_BFu8s_BFs8c { signed int v1:8; signed long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFs8i { signed int v1:8; signed long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFs8ll { signed int v1:8; signed long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFs8s { signed int v1:8; signed long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFu8c { signed int v1:8; signed long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFu8i { signed int v1:8; signed long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFu8ll { signed int v1:8; signed long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8ll_BFu8s_BFu8s { signed int v1:8; signed long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s { signed int v1:8; signed short v2:8; };
struct BFs8i_BFs8s_BFs8c { signed int v1:8; signed short v2:8; signed char v3:8; };
struct BFs8i_BFs8s_BFs8c_BFs8c { signed int v1:8; signed short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFs8c_BFs8i { signed int v1:8; signed short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFs8c_BFs8ll { signed int v1:8; signed short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFs8c_BFs8s { signed int v1:8; signed short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFs8c_BFu8c { signed int v1:8; signed short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFs8c_BFu8i { signed int v1:8; signed short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFs8c_BFu8ll { signed int v1:8; signed short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFs8c_BFu8s { signed int v1:8; signed short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFs8i { signed int v1:8; signed short v2:8; signed int v3:8; };
struct BFs8i_BFs8s_BFs8i_BFs8c { signed int v1:8; signed short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFs8i_BFs8i { signed int v1:8; signed short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFs8i_BFs8ll { signed int v1:8; signed short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFs8i_BFs8s { signed int v1:8; signed short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFs8i_BFu8c { signed int v1:8; signed short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFs8i_BFu8i { signed int v1:8; signed short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFs8i_BFu8ll { signed int v1:8; signed short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFs8i_BFu8s { signed int v1:8; signed short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFs8ll { signed int v1:8; signed short v2:8; signed long long v3:8; };
struct BFs8i_BFs8s_BFs8ll_BFs8c { signed int v1:8; signed short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFs8i { signed int v1:8; signed short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFs8ll { signed int v1:8; signed short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFs8s { signed int v1:8; signed short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFu8c { signed int v1:8; signed short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFu8i { signed int v1:8; signed short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFu8ll { signed int v1:8; signed short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFs8ll_BFu8s { signed int v1:8; signed short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFs8s { signed int v1:8; signed short v2:8; signed short v3:8; };
struct BFs8i_BFs8s_BFs8s_BFs8c { signed int v1:8; signed short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFs8s_BFs8i { signed int v1:8; signed short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFs8s_BFs8ll { signed int v1:8; signed short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFs8s_BFs8s { signed int v1:8; signed short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFs8s_BFu8c { signed int v1:8; signed short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFs8s_BFu8i { signed int v1:8; signed short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFs8s_BFu8ll { signed int v1:8; signed short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFs8s_BFu8s { signed int v1:8; signed short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFu8c { signed int v1:8; signed short v2:8; unsigned char v3:8; };
struct BFs8i_BFs8s_BFu8c_BFs8c { signed int v1:8; signed short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFu8c_BFs8i { signed int v1:8; signed short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFu8c_BFs8ll { signed int v1:8; signed short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFu8c_BFs8s { signed int v1:8; signed short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFu8c_BFu8c { signed int v1:8; signed short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFu8c_BFu8i { signed int v1:8; signed short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFu8c_BFu8ll { signed int v1:8; signed short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFu8c_BFu8s { signed int v1:8; signed short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFu8i { signed int v1:8; signed short v2:8; unsigned int v3:8; };
struct BFs8i_BFs8s_BFu8i_BFs8c { signed int v1:8; signed short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFu8i_BFs8i { signed int v1:8; signed short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFu8i_BFs8ll { signed int v1:8; signed short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFu8i_BFs8s { signed int v1:8; signed short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFu8i_BFu8c { signed int v1:8; signed short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFu8i_BFu8i { signed int v1:8; signed short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFu8i_BFu8ll { signed int v1:8; signed short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFu8i_BFu8s { signed int v1:8; signed short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFu8ll { signed int v1:8; signed short v2:8; unsigned long long v3:8; };
struct BFs8i_BFs8s_BFu8ll_BFs8c { signed int v1:8; signed short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFs8i { signed int v1:8; signed short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFs8ll { signed int v1:8; signed short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFs8s { signed int v1:8; signed short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFu8c { signed int v1:8; signed short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFu8i { signed int v1:8; signed short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFu8ll { signed int v1:8; signed short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFu8ll_BFu8s { signed int v1:8; signed short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFs8s_BFu8s { signed int v1:8; signed short v2:8; unsigned short v3:8; };
struct BFs8i_BFs8s_BFu8s_BFs8c { signed int v1:8; signed short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFs8s_BFu8s_BFs8i { signed int v1:8; signed short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFs8s_BFu8s_BFs8ll { signed int v1:8; signed short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFs8s_BFu8s_BFs8s { signed int v1:8; signed short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFs8s_BFu8s_BFu8c { signed int v1:8; signed short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFs8s_BFu8s_BFu8i { signed int v1:8; signed short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFs8s_BFu8s_BFu8ll { signed int v1:8; signed short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFs8s_BFu8s_BFu8s { signed int v1:8; signed short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c { signed int v1:8; unsigned char v2:8; };
struct BFs8i_BFu8c_BFs8c { signed int v1:8; unsigned char v2:8; signed char v3:8; };
struct BFs8i_BFu8c_BFs8c_BFs8c { signed int v1:8; unsigned char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFs8c_BFs8i { signed int v1:8; unsigned char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFs8c_BFs8ll { signed int v1:8; unsigned char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFs8c_BFs8s { signed int v1:8; unsigned char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFs8c_BFu8c { signed int v1:8; unsigned char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFs8c_BFu8i { signed int v1:8; unsigned char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFs8c_BFu8ll { signed int v1:8; unsigned char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFs8c_BFu8s { signed int v1:8; unsigned char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFs8i { signed int v1:8; unsigned char v2:8; signed int v3:8; };
struct BFs8i_BFu8c_BFs8i_BFs8c { signed int v1:8; unsigned char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFs8i_BFs8i { signed int v1:8; unsigned char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFs8i_BFs8ll { signed int v1:8; unsigned char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFs8i_BFs8s { signed int v1:8; unsigned char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFs8i_BFu8c { signed int v1:8; unsigned char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFs8i_BFu8i { signed int v1:8; unsigned char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFs8i_BFu8ll { signed int v1:8; unsigned char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFs8i_BFu8s { signed int v1:8; unsigned char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFs8ll { signed int v1:8; unsigned char v2:8; signed long long v3:8; };
struct BFs8i_BFu8c_BFs8ll_BFs8c { signed int v1:8; unsigned char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFs8i { signed int v1:8; unsigned char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFs8ll { signed int v1:8; unsigned char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFs8s { signed int v1:8; unsigned char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFu8c { signed int v1:8; unsigned char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFu8i { signed int v1:8; unsigned char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFu8ll { signed int v1:8; unsigned char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFs8ll_BFu8s { signed int v1:8; unsigned char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFs8s { signed int v1:8; unsigned char v2:8; signed short v3:8; };
struct BFs8i_BFu8c_BFs8s_BFs8c { signed int v1:8; unsigned char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFs8s_BFs8i { signed int v1:8; unsigned char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFs8s_BFs8ll { signed int v1:8; unsigned char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFs8s_BFs8s { signed int v1:8; unsigned char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFs8s_BFu8c { signed int v1:8; unsigned char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFs8s_BFu8i { signed int v1:8; unsigned char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFs8s_BFu8ll { signed int v1:8; unsigned char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFs8s_BFu8s { signed int v1:8; unsigned char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFu8c { signed int v1:8; unsigned char v2:8; unsigned char v3:8; };
struct BFs8i_BFu8c_BFu8c_BFs8c { signed int v1:8; unsigned char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFu8c_BFs8i { signed int v1:8; unsigned char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFu8c_BFs8ll { signed int v1:8; unsigned char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFu8c_BFs8s { signed int v1:8; unsigned char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFu8c_BFu8c { signed int v1:8; unsigned char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFu8c_BFu8i { signed int v1:8; unsigned char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFu8c_BFu8ll { signed int v1:8; unsigned char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFu8c_BFu8s { signed int v1:8; unsigned char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFu8i { signed int v1:8; unsigned char v2:8; unsigned int v3:8; };
struct BFs8i_BFu8c_BFu8i_BFs8c { signed int v1:8; unsigned char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFu8i_BFs8i { signed int v1:8; unsigned char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFu8i_BFs8ll { signed int v1:8; unsigned char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFu8i_BFs8s { signed int v1:8; unsigned char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFu8i_BFu8c { signed int v1:8; unsigned char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFu8i_BFu8i { signed int v1:8; unsigned char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFu8i_BFu8ll { signed int v1:8; unsigned char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFu8i_BFu8s { signed int v1:8; unsigned char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFu8ll { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; };
struct BFs8i_BFu8c_BFu8ll_BFs8c { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFs8i { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFs8ll { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFs8s { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFu8c { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFu8i { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFu8ll { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFu8ll_BFu8s { signed int v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8c_BFu8s { signed int v1:8; unsigned char v2:8; unsigned short v3:8; };
struct BFs8i_BFu8c_BFu8s_BFs8c { signed int v1:8; unsigned char v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFu8c_BFu8s_BFs8i { signed int v1:8; unsigned char v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFu8c_BFu8s_BFs8ll { signed int v1:8; unsigned char v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFu8c_BFu8s_BFs8s { signed int v1:8; unsigned char v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFu8c_BFu8s_BFu8c { signed int v1:8; unsigned char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8c_BFu8s_BFu8i { signed int v1:8; unsigned char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8c_BFu8s_BFu8ll { signed int v1:8; unsigned char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8c_BFu8s_BFu8s { signed int v1:8; unsigned char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i { signed int v1:8; unsigned int v2:8; };
struct BFs8i_BFu8i_BFs8c { signed int v1:8; unsigned int v2:8; signed char v3:8; };
struct BFs8i_BFu8i_BFs8c_BFs8c { signed int v1:8; unsigned int v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFs8c_BFs8i { signed int v1:8; unsigned int v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFs8c_BFs8ll { signed int v1:8; unsigned int v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFs8c_BFs8s { signed int v1:8; unsigned int v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFs8c_BFu8c { signed int v1:8; unsigned int v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFs8c_BFu8i { signed int v1:8; unsigned int v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFs8c_BFu8ll { signed int v1:8; unsigned int v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFs8c_BFu8s { signed int v1:8; unsigned int v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFs8i { signed int v1:8; unsigned int v2:8; signed int v3:8; };
struct BFs8i_BFu8i_BFs8i_BFs8c { signed int v1:8; unsigned int v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFs8i_BFs8i { signed int v1:8; unsigned int v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFs8i_BFs8ll { signed int v1:8; unsigned int v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFs8i_BFs8s { signed int v1:8; unsigned int v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFs8i_BFu8c { signed int v1:8; unsigned int v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFs8i_BFu8i { signed int v1:8; unsigned int v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFs8i_BFu8ll { signed int v1:8; unsigned int v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFs8i_BFu8s { signed int v1:8; unsigned int v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFs8ll { signed int v1:8; unsigned int v2:8; signed long long v3:8; };
struct BFs8i_BFu8i_BFs8ll_BFs8c { signed int v1:8; unsigned int v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFs8i { signed int v1:8; unsigned int v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFs8ll { signed int v1:8; unsigned int v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFs8s { signed int v1:8; unsigned int v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFu8c { signed int v1:8; unsigned int v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFu8i { signed int v1:8; unsigned int v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFu8ll { signed int v1:8; unsigned int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFs8ll_BFu8s { signed int v1:8; unsigned int v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFs8s { signed int v1:8; unsigned int v2:8; signed short v3:8; };
struct BFs8i_BFu8i_BFs8s_BFs8c { signed int v1:8; unsigned int v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFs8s_BFs8i { signed int v1:8; unsigned int v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFs8s_BFs8ll { signed int v1:8; unsigned int v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFs8s_BFs8s { signed int v1:8; unsigned int v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFs8s_BFu8c { signed int v1:8; unsigned int v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFs8s_BFu8i { signed int v1:8; unsigned int v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFs8s_BFu8ll { signed int v1:8; unsigned int v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFs8s_BFu8s { signed int v1:8; unsigned int v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFu8c { signed int v1:8; unsigned int v2:8; unsigned char v3:8; };
struct BFs8i_BFu8i_BFu8c_BFs8c { signed int v1:8; unsigned int v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFu8c_BFs8i { signed int v1:8; unsigned int v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFu8c_BFs8ll { signed int v1:8; unsigned int v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFu8c_BFs8s { signed int v1:8; unsigned int v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFu8c_BFu8c { signed int v1:8; unsigned int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFu8c_BFu8i { signed int v1:8; unsigned int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFu8c_BFu8ll { signed int v1:8; unsigned int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFu8c_BFu8s { signed int v1:8; unsigned int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFu8i { signed int v1:8; unsigned int v2:8; unsigned int v3:8; };
struct BFs8i_BFu8i_BFu8i_BFs8c { signed int v1:8; unsigned int v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFu8i_BFs8i { signed int v1:8; unsigned int v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFu8i_BFs8ll { signed int v1:8; unsigned int v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFu8i_BFs8s { signed int v1:8; unsigned int v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFu8i_BFu8c { signed int v1:8; unsigned int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFu8i_BFu8i { signed int v1:8; unsigned int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFu8i_BFu8ll { signed int v1:8; unsigned int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFu8i_BFu8s { signed int v1:8; unsigned int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFu8ll { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; };
struct BFs8i_BFu8i_BFu8ll_BFs8c { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFs8i { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFs8ll { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFs8s { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFu8c { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFu8i { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFu8ll { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFu8ll_BFu8s { signed int v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8i_BFu8s { signed int v1:8; unsigned int v2:8; unsigned short v3:8; };
struct BFs8i_BFu8i_BFu8s_BFs8c { signed int v1:8; unsigned int v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFu8i_BFu8s_BFs8i { signed int v1:8; unsigned int v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFu8i_BFu8s_BFs8ll { signed int v1:8; unsigned int v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFu8i_BFu8s_BFs8s { signed int v1:8; unsigned int v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFu8i_BFu8s_BFu8c { signed int v1:8; unsigned int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8i_BFu8s_BFu8i { signed int v1:8; unsigned int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8i_BFu8s_BFu8ll { signed int v1:8; unsigned int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8i_BFu8s_BFu8s { signed int v1:8; unsigned int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll { signed int v1:8; unsigned long long v2:8; };
struct BFs8i_BFu8ll_BFs8c { signed int v1:8; unsigned long long v2:8; signed char v3:8; };
struct BFs8i_BFu8ll_BFs8c_BFs8c { signed int v1:8; unsigned long long v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFs8i { signed int v1:8; unsigned long long v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFs8ll { signed int v1:8; unsigned long long v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFs8s { signed int v1:8; unsigned long long v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFu8c { signed int v1:8; unsigned long long v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFu8i { signed int v1:8; unsigned long long v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFu8ll { signed int v1:8; unsigned long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFs8c_BFu8s { signed int v1:8; unsigned long long v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFs8i { signed int v1:8; unsigned long long v2:8; signed int v3:8; };
struct BFs8i_BFu8ll_BFs8i_BFs8c { signed int v1:8; unsigned long long v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFs8i { signed int v1:8; unsigned long long v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFs8ll { signed int v1:8; unsigned long long v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFs8s { signed int v1:8; unsigned long long v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFu8c { signed int v1:8; unsigned long long v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFu8i { signed int v1:8; unsigned long long v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFu8ll { signed int v1:8; unsigned long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFs8i_BFu8s { signed int v1:8; unsigned long long v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFs8ll { signed int v1:8; unsigned long long v2:8; signed long long v3:8; };
struct BFs8i_BFu8ll_BFs8ll_BFs8c { signed int v1:8; unsigned long long v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFs8i { signed int v1:8; unsigned long long v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFs8ll { signed int v1:8; unsigned long long v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFs8s { signed int v1:8; unsigned long long v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFu8c { signed int v1:8; unsigned long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFu8i { signed int v1:8; unsigned long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFu8ll { signed int v1:8; unsigned long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFs8ll_BFu8s { signed int v1:8; unsigned long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFs8s { signed int v1:8; unsigned long long v2:8; signed short v3:8; };
struct BFs8i_BFu8ll_BFs8s_BFs8c { signed int v1:8; unsigned long long v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFs8i { signed int v1:8; unsigned long long v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFs8ll { signed int v1:8; unsigned long long v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFs8s { signed int v1:8; unsigned long long v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFu8c { signed int v1:8; unsigned long long v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFu8i { signed int v1:8; unsigned long long v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFu8ll { signed int v1:8; unsigned long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFs8s_BFu8s { signed int v1:8; unsigned long long v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFu8c { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; };
struct BFs8i_BFu8ll_BFu8c_BFs8c { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFs8i { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFs8ll { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFs8s { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFu8c { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFu8i { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFu8ll { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFu8c_BFu8s { signed int v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFu8i { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; };
struct BFs8i_BFu8ll_BFu8i_BFs8c { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFs8i { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFs8ll { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFs8s { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFu8c { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFu8i { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFu8ll { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFu8i_BFu8s { signed int v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFu8ll { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; };
struct BFs8i_BFu8ll_BFu8ll_BFs8c { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFs8i { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFs8ll { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFs8s { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFu8c { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFu8i { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFu8ll { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFu8ll_BFu8s { signed int v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8ll_BFu8s { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; };
struct BFs8i_BFu8ll_BFu8s_BFs8c { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFs8i { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFs8ll { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFs8s { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFu8c { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFu8i { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFu8ll { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8ll_BFu8s_BFu8s { signed int v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s { signed int v1:8; unsigned short v2:8; };
struct BFs8i_BFu8s_BFs8c { signed int v1:8; unsigned short v2:8; signed char v3:8; };
struct BFs8i_BFu8s_BFs8c_BFs8c { signed int v1:8; unsigned short v2:8; signed char v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFs8c_BFs8i { signed int v1:8; unsigned short v2:8; signed char v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFs8c_BFs8ll { signed int v1:8; unsigned short v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFs8c_BFs8s { signed int v1:8; unsigned short v2:8; signed char v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFs8c_BFu8c { signed int v1:8; unsigned short v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFs8c_BFu8i { signed int v1:8; unsigned short v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFs8c_BFu8ll { signed int v1:8; unsigned short v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFs8c_BFu8s { signed int v1:8; unsigned short v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFs8i { signed int v1:8; unsigned short v2:8; signed int v3:8; };
struct BFs8i_BFu8s_BFs8i_BFs8c { signed int v1:8; unsigned short v2:8; signed int v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFs8i_BFs8i { signed int v1:8; unsigned short v2:8; signed int v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFs8i_BFs8ll { signed int v1:8; unsigned short v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFs8i_BFs8s { signed int v1:8; unsigned short v2:8; signed int v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFs8i_BFu8c { signed int v1:8; unsigned short v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFs8i_BFu8i { signed int v1:8; unsigned short v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFs8i_BFu8ll { signed int v1:8; unsigned short v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFs8i_BFu8s { signed int v1:8; unsigned short v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFs8ll { signed int v1:8; unsigned short v2:8; signed long long v3:8; };
struct BFs8i_BFu8s_BFs8ll_BFs8c { signed int v1:8; unsigned short v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFs8i { signed int v1:8; unsigned short v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFs8ll { signed int v1:8; unsigned short v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFs8s { signed int v1:8; unsigned short v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFu8c { signed int v1:8; unsigned short v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFu8i { signed int v1:8; unsigned short v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFu8ll { signed int v1:8; unsigned short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFs8ll_BFu8s { signed int v1:8; unsigned short v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFs8s { signed int v1:8; unsigned short v2:8; signed short v3:8; };
struct BFs8i_BFu8s_BFs8s_BFs8c { signed int v1:8; unsigned short v2:8; signed short v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFs8s_BFs8i { signed int v1:8; unsigned short v2:8; signed short v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFs8s_BFs8ll { signed int v1:8; unsigned short v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFs8s_BFs8s { signed int v1:8; unsigned short v2:8; signed short v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFs8s_BFu8c { signed int v1:8; unsigned short v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFs8s_BFu8i { signed int v1:8; unsigned short v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFs8s_BFu8ll { signed int v1:8; unsigned short v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFs8s_BFu8s { signed int v1:8; unsigned short v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFu8c { signed int v1:8; unsigned short v2:8; unsigned char v3:8; };
struct BFs8i_BFu8s_BFu8c_BFs8c { signed int v1:8; unsigned short v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFu8c_BFs8i { signed int v1:8; unsigned short v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFu8c_BFs8ll { signed int v1:8; unsigned short v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFu8c_BFs8s { signed int v1:8; unsigned short v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFu8c_BFu8c { signed int v1:8; unsigned short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFu8c_BFu8i { signed int v1:8; unsigned short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFu8c_BFu8ll { signed int v1:8; unsigned short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFu8c_BFu8s { signed int v1:8; unsigned short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFu8i { signed int v1:8; unsigned short v2:8; unsigned int v3:8; };
struct BFs8i_BFu8s_BFu8i_BFs8c { signed int v1:8; unsigned short v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFu8i_BFs8i { signed int v1:8; unsigned short v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFu8i_BFs8ll { signed int v1:8; unsigned short v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFu8i_BFs8s { signed int v1:8; unsigned short v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFu8i_BFu8c { signed int v1:8; unsigned short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFu8i_BFu8i { signed int v1:8; unsigned short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFu8i_BFu8ll { signed int v1:8; unsigned short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFu8i_BFu8s { signed int v1:8; unsigned short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFu8ll { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; };
struct BFs8i_BFu8s_BFu8ll_BFs8c { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFs8i { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFs8ll { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFs8s { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFu8c { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFu8i { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFu8ll { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFu8ll_BFu8s { signed int v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct BFs8i_BFu8s_BFu8s { signed int v1:8; unsigned short v2:8; unsigned short v3:8; };
struct BFs8i_BFu8s_BFu8s_BFs8c { signed int v1:8; unsigned short v2:8; unsigned short v3:8; signed char v4:8; };
struct BFs8i_BFu8s_BFu8s_BFs8i { signed int v1:8; unsigned short v2:8; unsigned short v3:8; signed int v4:8; };
struct BFs8i_BFu8s_BFu8s_BFs8ll { signed int v1:8; unsigned short v2:8; unsigned short v3:8; signed long long v4:8; };
struct BFs8i_BFu8s_BFu8s_BFs8s { signed int v1:8; unsigned short v2:8; unsigned short v3:8; signed short v4:8; };
struct BFs8i_BFu8s_BFu8s_BFu8c { signed int v1:8; unsigned short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct BFs8i_BFu8s_BFu8s_BFu8i { signed int v1:8; unsigned short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct BFs8i_BFu8s_BFu8s_BFu8ll { signed int v1:8; unsigned short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct BFs8i_BFu8s_BFu8s_BFu8s { signed int v1:8; unsigned short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c { signed long long v1:8; signed char v2:8; };
struct BFs8ll_BFs8c_BFs8c { signed long long v1:8; signed char v2:8; signed char v3:8; };
struct BFs8ll_BFs8c_BFs8c_BFs8c { signed long long v1:8; signed char v2:8; signed char v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFs8i { signed long long v1:8; signed char v2:8; signed char v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFs8ll { signed long long v1:8; signed char v2:8; signed char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFs8s { signed long long v1:8; signed char v2:8; signed char v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFu8c { signed long long v1:8; signed char v2:8; signed char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFu8i { signed long long v1:8; signed char v2:8; signed char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFu8ll { signed long long v1:8; signed char v2:8; signed char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFs8c_BFu8s { signed long long v1:8; signed char v2:8; signed char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFs8i { signed long long v1:8; signed char v2:8; signed int v3:8; };
struct BFs8ll_BFs8c_BFs8i_BFs8c { signed long long v1:8; signed char v2:8; signed int v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFs8i { signed long long v1:8; signed char v2:8; signed int v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFs8ll { signed long long v1:8; signed char v2:8; signed int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFs8s { signed long long v1:8; signed char v2:8; signed int v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFu8c { signed long long v1:8; signed char v2:8; signed int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFu8i { signed long long v1:8; signed char v2:8; signed int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFu8ll { signed long long v1:8; signed char v2:8; signed int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFs8i_BFu8s { signed long long v1:8; signed char v2:8; signed int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFs8ll { signed long long v1:8; signed char v2:8; signed long long v3:8; };
struct BFs8ll_BFs8c_BFs8ll_BFs8c { signed long long v1:8; signed char v2:8; signed long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFs8i { signed long long v1:8; signed char v2:8; signed long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFs8ll { signed long long v1:8; signed char v2:8; signed long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFs8s { signed long long v1:8; signed char v2:8; signed long long v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFu8c { signed long long v1:8; signed char v2:8; signed long long v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFu8i { signed long long v1:8; signed char v2:8; signed long long v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFu8ll { signed long long v1:8; signed char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFs8ll_BFu8s { signed long long v1:8; signed char v2:8; signed long long v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFs8s { signed long long v1:8; signed char v2:8; signed short v3:8; };
struct BFs8ll_BFs8c_BFs8s_BFs8c { signed long long v1:8; signed char v2:8; signed short v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFs8i { signed long long v1:8; signed char v2:8; signed short v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFs8ll { signed long long v1:8; signed char v2:8; signed short v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFs8s { signed long long v1:8; signed char v2:8; signed short v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFu8c { signed long long v1:8; signed char v2:8; signed short v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFu8i { signed long long v1:8; signed char v2:8; signed short v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFu8ll { signed long long v1:8; signed char v2:8; signed short v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFs8s_BFu8s { signed long long v1:8; signed char v2:8; signed short v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFu8c { signed long long v1:8; signed char v2:8; unsigned char v3:8; };
struct BFs8ll_BFs8c_BFu8c_BFs8c { signed long long v1:8; signed char v2:8; unsigned char v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFs8i { signed long long v1:8; signed char v2:8; unsigned char v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFs8ll { signed long long v1:8; signed char v2:8; unsigned char v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFs8s { signed long long v1:8; signed char v2:8; unsigned char v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFu8c { signed long long v1:8; signed char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFu8i { signed long long v1:8; signed char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFu8ll { signed long long v1:8; signed char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFu8c_BFu8s { signed long long v1:8; signed char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFu8i { signed long long v1:8; signed char v2:8; unsigned int v3:8; };
struct BFs8ll_BFs8c_BFu8i_BFs8c { signed long long v1:8; signed char v2:8; unsigned int v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFs8i { signed long long v1:8; signed char v2:8; unsigned int v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFs8ll { signed long long v1:8; signed char v2:8; unsigned int v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFs8s { signed long long v1:8; signed char v2:8; unsigned int v3:8; signed short v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFu8c { signed long long v1:8; signed char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFu8i { signed long long v1:8; signed char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFu8ll { signed long long v1:8; signed char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct BFs8ll_BFs8c_BFu8i_BFu8s { signed long long v1:8; signed char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct BFs8ll_BFs8c_BFu8ll { signed long long v1:8; signed char v2:8; unsigned long long v3:8; };
struct BFs8ll_BFs8c_BFu8ll_BFs8c { signed long long v1:8; signed char v2:8; unsigned long long v3:8; signed char v4:8; };
struct BFs8ll_BFs8c_BFu8ll_BFs8i { signed long long v1:8; signed char v2:8; unsigned long long v3:8; signed int v4:8; };
struct BFs8ll_BFs8c_BFu8ll_BFs8ll { signed long long v1:8; signed char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct BFs8ll_BFs8c_BFu8ll_BFs8s { signed long long v1:8; signed char v2:8; unsigned long long v3:8; signed short v4:8; };


static void Test_BFs7c_BFu7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7i_BFu7ll, BFs7c_BFu7s_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7i_BFu7s, BFs7c_BFu7s_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll, BFs7c_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFs7c, BFs7c_BFu7s_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFs7i, BFs7c_BFu7s_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFs7ll, BFs7c_BFu7s_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFs7s, BFs7c_BFu7s_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFu7c, BFs7c_BFu7s_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFu7i, BFs7c_BFu7s_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFu7ll, BFs7c_BFu7s_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7ll_BFu7s, BFs7c_BFu7s_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s, BFs7c_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFs7c, BFs7c_BFu7s_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFs7i, BFs7c_BFu7s_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFs7ll, BFs7c_BFu7s_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFs7s, BFs7c_BFu7s_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFu7c, BFs7c_BFu7s_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFu7i, BFs7c_BFu7s_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFu7ll, BFs7c_BFu7s_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7c_BFu7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7c_BFu7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7c_BFu7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7c_BFu7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7c_BFu7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7c_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7c_BFu7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7c_BFu7s_BFu7s_BFu7s, BFs7c_BFu7s_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c, BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c, BFs7i_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFs7c, BFs7i_BFs7c_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFs7i, BFs7i_BFs7c_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFs7ll, BFs7i_BFs7c_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFs7s, BFs7i_BFs7c_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFu7c, BFs7i_BFs7c_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFu7i, BFs7i_BFs7c_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFu7ll, BFs7i_BFs7c_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7c_BFu7s, BFs7i_BFs7c_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i, BFs7i_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFs7c, BFs7i_BFs7c_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFs7i, BFs7i_BFs7c_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFs7ll, BFs7i_BFs7c_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFs7s, BFs7i_BFs7c_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFu7c, BFs7i_BFs7c_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFu7i, BFs7i_BFs7c_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFu7ll, BFs7i_BFs7c_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7i_BFu7s, BFs7i_BFs7c_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll, BFs7i_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFs7c, BFs7i_BFs7c_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFs7i, BFs7i_BFs7c_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFs7ll, BFs7i_BFs7c_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFs7s, BFs7i_BFs7c_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFu7c, BFs7i_BFs7c_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFu7i, BFs7i_BFs7c_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFu7ll, BFs7i_BFs7c_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7ll_BFu7s, BFs7i_BFs7c_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s, BFs7i_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFs7c, BFs7i_BFs7c_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFs7i, BFs7i_BFs7c_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFs7ll, BFs7i_BFs7c_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFs7s, BFs7i_BFs7c_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFu7c, BFs7i_BFs7c_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFu7i, BFs7i_BFs7c_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFu7ll, BFs7i_BFs7c_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFs7s_BFu7s, BFs7i_BFs7c_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c, BFs7i_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFs7c, BFs7i_BFs7c_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFs7i, BFs7i_BFs7c_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFs7ll, BFs7i_BFs7c_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFs7s, BFs7i_BFs7c_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFu7c, BFs7i_BFs7c_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFu7i, BFs7i_BFs7c_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFu7ll, BFs7i_BFs7c_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7c_BFu7s, BFs7i_BFs7c_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i, BFs7i_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFs7c, BFs7i_BFs7c_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFs7i, BFs7i_BFs7c_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFs7ll, BFs7i_BFs7c_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFs7s, BFs7i_BFs7c_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFu7c, BFs7i_BFs7c_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFu7i, BFs7i_BFs7c_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFu7ll, BFs7i_BFs7c_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7i_BFu7s, BFs7i_BFs7c_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll, BFs7i_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFs7c, BFs7i_BFs7c_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFs7i, BFs7i_BFs7c_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFs7ll, BFs7i_BFs7c_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFs7s, BFs7i_BFs7c_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFu7c, BFs7i_BFs7c_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFu7i, BFs7i_BFs7c_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFu7ll, BFs7i_BFs7c_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7ll_BFu7s, BFs7i_BFs7c_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s, BFs7i_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFs7c, BFs7i_BFs7c_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFs7i, BFs7i_BFs7c_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFs7ll, BFs7i_BFs7c_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFs7s, BFs7i_BFs7c_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFu7c, BFs7i_BFs7c_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFu7i, BFs7i_BFs7c_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFu7ll, BFs7i_BFs7c_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7c_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7c_BFu7s_BFu7s, BFs7i_BFs7c_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i, BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c, BFs7i_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFs7c, BFs7i_BFs7i_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFs7i, BFs7i_BFs7i_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFs7ll, BFs7i_BFs7i_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFs7s, BFs7i_BFs7i_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFu7c, BFs7i_BFs7i_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFu7i, BFs7i_BFs7i_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFu7ll, BFs7i_BFs7i_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7c_BFu7s, BFs7i_BFs7i_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i, BFs7i_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFs7c, BFs7i_BFs7i_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFs7i, BFs7i_BFs7i_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFs7ll, BFs7i_BFs7i_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFs7s, BFs7i_BFs7i_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFu7c, BFs7i_BFs7i_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFu7i, BFs7i_BFs7i_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFu7ll, BFs7i_BFs7i_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7i_BFu7s, BFs7i_BFs7i_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll, BFs7i_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFs7c, BFs7i_BFs7i_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFs7i, BFs7i_BFs7i_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFs7ll, BFs7i_BFs7i_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFs7s, BFs7i_BFs7i_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFu7c, BFs7i_BFs7i_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFu7i, BFs7i_BFs7i_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFu7ll, BFs7i_BFs7i_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7ll_BFu7s, BFs7i_BFs7i_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s, BFs7i_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFs7c, BFs7i_BFs7i_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFs7i, BFs7i_BFs7i_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFs7ll, BFs7i_BFs7i_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFs7s, BFs7i_BFs7i_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFu7c, BFs7i_BFs7i_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFu7i, BFs7i_BFs7i_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFu7ll, BFs7i_BFs7i_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFs7s_BFu7s, BFs7i_BFs7i_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c, BFs7i_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFs7c, BFs7i_BFs7i_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFs7i, BFs7i_BFs7i_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFs7ll, BFs7i_BFs7i_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFs7s, BFs7i_BFs7i_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFu7c, BFs7i_BFs7i_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFu7i, BFs7i_BFs7i_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFu7ll, BFs7i_BFs7i_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7c_BFu7s, BFs7i_BFs7i_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i, BFs7i_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFs7c, BFs7i_BFs7i_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFs7i, BFs7i_BFs7i_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFs7ll, BFs7i_BFs7i_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFs7s, BFs7i_BFs7i_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFu7c, BFs7i_BFs7i_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFu7i, BFs7i_BFs7i_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFu7ll, BFs7i_BFs7i_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7i_BFu7s, BFs7i_BFs7i_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll, BFs7i_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFs7c, BFs7i_BFs7i_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFs7i, BFs7i_BFs7i_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFs7ll, BFs7i_BFs7i_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFs7s, BFs7i_BFs7i_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFu7c, BFs7i_BFs7i_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFu7i, BFs7i_BFs7i_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFu7ll, BFs7i_BFs7i_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7ll_BFu7s, BFs7i_BFs7i_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s, BFs7i_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFs7c, BFs7i_BFs7i_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFs7i, BFs7i_BFs7i_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFs7ll, BFs7i_BFs7i_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFs7s, BFs7i_BFs7i_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFu7c, BFs7i_BFs7i_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFu7i, BFs7i_BFs7i_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFu7ll, BFs7i_BFs7i_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7i_BFu7s_BFu7s, BFs7i_BFs7i_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll, BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c, BFs7i_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFs7c, BFs7i_BFs7ll_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFs7i, BFs7i_BFs7ll_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFs7ll, BFs7i_BFs7ll_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFs7s, BFs7i_BFs7ll_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFu7c, BFs7i_BFs7ll_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFu7i, BFs7i_BFs7ll_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFu7ll, BFs7i_BFs7ll_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7c_BFu7s, BFs7i_BFs7ll_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i, BFs7i_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFs7c, BFs7i_BFs7ll_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFs7i, BFs7i_BFs7ll_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFs7ll, BFs7i_BFs7ll_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFs7s, BFs7i_BFs7ll_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFu7c, BFs7i_BFs7ll_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFu7i, BFs7i_BFs7ll_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFu7ll, BFs7i_BFs7ll_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7i_BFu7s, BFs7i_BFs7ll_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll, BFs7i_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFs7c, BFs7i_BFs7ll_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFs7i, BFs7i_BFs7ll_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFs7ll, BFs7i_BFs7ll_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFs7s, BFs7i_BFs7ll_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFu7c, BFs7i_BFs7ll_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFu7i, BFs7i_BFs7ll_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFu7ll, BFs7i_BFs7ll_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7ll_BFu7s, BFs7i_BFs7ll_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s, BFs7i_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFs7c, BFs7i_BFs7ll_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFs7i, BFs7i_BFs7ll_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFs7ll, BFs7i_BFs7ll_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFs7s, BFs7i_BFs7ll_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFu7c, BFs7i_BFs7ll_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFu7i, BFs7i_BFs7ll_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFu7ll, BFs7i_BFs7ll_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFs7s_BFu7s, BFs7i_BFs7ll_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c, BFs7i_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFs7c, BFs7i_BFs7ll_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFs7i, BFs7i_BFs7ll_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFs7ll, BFs7i_BFs7ll_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFs7s, BFs7i_BFs7ll_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFu7c, BFs7i_BFs7ll_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFu7i, BFs7i_BFs7ll_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFu7ll, BFs7i_BFs7ll_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7c_BFu7s, BFs7i_BFs7ll_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i, BFs7i_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFs7c, BFs7i_BFs7ll_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFs7i, BFs7i_BFs7ll_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFs7ll, BFs7i_BFs7ll_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFs7s, BFs7i_BFs7ll_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFu7c, BFs7i_BFs7ll_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFu7i, BFs7i_BFs7ll_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFu7ll, BFs7i_BFs7ll_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7i_BFu7s, BFs7i_BFs7ll_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll, BFs7i_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFs7c, BFs7i_BFs7ll_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFs7i, BFs7i_BFs7ll_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFs7ll, BFs7i_BFs7ll_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFs7s, BFs7i_BFs7ll_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFu7c, BFs7i_BFs7ll_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFu7i, BFs7i_BFs7ll_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFu7ll, BFs7i_BFs7ll_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7ll_BFu7s, BFs7i_BFs7ll_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s, BFs7i_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFs7c, BFs7i_BFs7ll_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFs7i, BFs7i_BFs7ll_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFs7ll, BFs7i_BFs7ll_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFs7s, BFs7i_BFs7ll_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFu7c, BFs7i_BFs7ll_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFu7i, BFs7i_BFs7ll_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFu7ll, BFs7i_BFs7ll_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7ll_BFu7s_BFu7s, BFs7i_BFs7ll_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s, BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c, BFs7i_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFs7c, BFs7i_BFs7s_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFs7i, BFs7i_BFs7s_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFs7ll, BFs7i_BFs7s_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFs7s, BFs7i_BFs7s_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFu7c, BFs7i_BFs7s_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFu7i, BFs7i_BFs7s_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFu7ll, BFs7i_BFs7s_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7c_BFu7s, BFs7i_BFs7s_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i, BFs7i_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFs7c, BFs7i_BFs7s_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFs7i, BFs7i_BFs7s_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFs7ll, BFs7i_BFs7s_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFs7s, BFs7i_BFs7s_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFu7c, BFs7i_BFs7s_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFu7i, BFs7i_BFs7s_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFu7ll, BFs7i_BFs7s_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7i_BFu7s, BFs7i_BFs7s_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll, BFs7i_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFs7c, BFs7i_BFs7s_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFs7i, BFs7i_BFs7s_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFs7ll, BFs7i_BFs7s_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFs7s, BFs7i_BFs7s_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFu7c, BFs7i_BFs7s_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFu7i, BFs7i_BFs7s_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFu7ll, BFs7i_BFs7s_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7ll_BFu7s, BFs7i_BFs7s_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s, BFs7i_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFs7c, BFs7i_BFs7s_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFs7i, BFs7i_BFs7s_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFs7ll, BFs7i_BFs7s_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFs7s, BFs7i_BFs7s_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFu7c, BFs7i_BFs7s_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFu7i, BFs7i_BFs7s_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFu7ll, BFs7i_BFs7s_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFs7s_BFu7s, BFs7i_BFs7s_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c, BFs7i_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFs7c, BFs7i_BFs7s_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFs7i, BFs7i_BFs7s_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFs7ll, BFs7i_BFs7s_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFs7s, BFs7i_BFs7s_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFu7c, BFs7i_BFs7s_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFu7i, BFs7i_BFs7s_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFu7ll, BFs7i_BFs7s_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7c_BFu7s, BFs7i_BFs7s_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i, BFs7i_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFs7c, BFs7i_BFs7s_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFs7i, BFs7i_BFs7s_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFs7ll, BFs7i_BFs7s_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFs7s, BFs7i_BFs7s_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFu7c, BFs7i_BFs7s_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFu7i, BFs7i_BFs7s_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFu7ll, BFs7i_BFs7s_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7i_BFu7s, BFs7i_BFs7s_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll, BFs7i_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFs7c, BFs7i_BFs7s_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFs7i, BFs7i_BFs7s_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFs7ll, BFs7i_BFs7s_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFs7s, BFs7i_BFs7s_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFu7c, BFs7i_BFs7s_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFu7i, BFs7i_BFs7s_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFu7ll, BFs7i_BFs7s_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7ll_BFu7s, BFs7i_BFs7s_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s, BFs7i_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFs7c, BFs7i_BFs7s_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFs7i, BFs7i_BFs7s_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFs7ll, BFs7i_BFs7s_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFs7s, BFs7i_BFs7s_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFu7c, BFs7i_BFs7s_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFu7i, BFs7i_BFs7s_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFu7ll, BFs7i_BFs7s_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFs7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFs7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFs7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFs7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFs7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFs7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFs7s_BFu7s_BFu7s, BFs7i_BFs7s_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c, BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c, BFs7i_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFs7c, BFs7i_BFu7c_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFs7i, BFs7i_BFu7c_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFs7ll, BFs7i_BFu7c_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFs7s, BFs7i_BFu7c_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFu7c, BFs7i_BFu7c_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFu7i, BFs7i_BFu7c_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFu7ll, BFs7i_BFu7c_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7c_BFu7s, BFs7i_BFu7c_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i, BFs7i_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFs7c, BFs7i_BFu7c_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFs7i, BFs7i_BFu7c_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFs7ll, BFs7i_BFu7c_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFs7s, BFs7i_BFu7c_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFu7c, BFs7i_BFu7c_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFu7i, BFs7i_BFu7c_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFu7ll, BFs7i_BFu7c_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7i_BFu7s, BFs7i_BFu7c_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll, BFs7i_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFs7c, BFs7i_BFu7c_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFs7i, BFs7i_BFu7c_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFs7ll, BFs7i_BFu7c_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFs7s, BFs7i_BFu7c_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFu7c, BFs7i_BFu7c_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFu7i, BFs7i_BFu7c_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFu7ll, BFs7i_BFu7c_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7ll_BFu7s, BFs7i_BFu7c_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s, BFs7i_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFs7c, BFs7i_BFu7c_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFs7i, BFs7i_BFu7c_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFs7ll, BFs7i_BFu7c_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFs7s, BFs7i_BFu7c_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFu7c, BFs7i_BFu7c_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFu7i, BFs7i_BFu7c_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFu7ll, BFs7i_BFu7c_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFs7s_BFu7s, BFs7i_BFu7c_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c, BFs7i_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFs7c, BFs7i_BFu7c_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFs7i, BFs7i_BFu7c_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFs7ll, BFs7i_BFu7c_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFs7s, BFs7i_BFu7c_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFu7c, BFs7i_BFu7c_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFu7i, BFs7i_BFu7c_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFu7ll, BFs7i_BFu7c_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7c_BFu7s, BFs7i_BFu7c_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i, BFs7i_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFs7c, BFs7i_BFu7c_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFs7i, BFs7i_BFu7c_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFs7ll, BFs7i_BFu7c_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFs7s, BFs7i_BFu7c_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFu7c, BFs7i_BFu7c_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFu7i, BFs7i_BFu7c_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFu7ll, BFs7i_BFu7c_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7i_BFu7s, BFs7i_BFu7c_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll, BFs7i_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFs7c, BFs7i_BFu7c_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFs7i, BFs7i_BFu7c_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFs7ll, BFs7i_BFu7c_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFs7s, BFs7i_BFu7c_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFu7c, BFs7i_BFu7c_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFu7i, BFs7i_BFu7c_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFu7ll, BFs7i_BFu7c_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7ll_BFu7s, BFs7i_BFu7c_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s, BFs7i_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFs7c, BFs7i_BFu7c_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFs7i, BFs7i_BFu7c_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFs7ll, BFs7i_BFu7c_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFs7s, BFs7i_BFu7c_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFu7c, BFs7i_BFu7c_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFu7i, BFs7i_BFu7c_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFu7ll, BFs7i_BFu7c_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7c_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7c_BFu7s_BFu7s, BFs7i_BFu7c_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i, BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c, BFs7i_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFs7c, BFs7i_BFu7i_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFs7i, BFs7i_BFu7i_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFs7ll, BFs7i_BFu7i_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFs7s, BFs7i_BFu7i_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFu7c, BFs7i_BFu7i_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFu7i, BFs7i_BFu7i_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFu7ll, BFs7i_BFu7i_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7c_BFu7s, BFs7i_BFu7i_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i, BFs7i_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFs7c, BFs7i_BFu7i_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFs7i, BFs7i_BFu7i_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFs7ll, BFs7i_BFu7i_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFs7s, BFs7i_BFu7i_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFu7c, BFs7i_BFu7i_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFu7i, BFs7i_BFu7i_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFu7ll, BFs7i_BFu7i_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7i_BFu7s, BFs7i_BFu7i_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll, BFs7i_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFs7c, BFs7i_BFu7i_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFs7i, BFs7i_BFu7i_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFs7ll, BFs7i_BFu7i_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFs7s, BFs7i_BFu7i_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFu7c, BFs7i_BFu7i_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFu7i, BFs7i_BFu7i_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFu7ll, BFs7i_BFu7i_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7ll_BFu7s, BFs7i_BFu7i_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s, BFs7i_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFs7c, BFs7i_BFu7i_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFs7i, BFs7i_BFu7i_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFs7ll, BFs7i_BFu7i_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFs7s, BFs7i_BFu7i_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFu7c, BFs7i_BFu7i_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFu7i, BFs7i_BFu7i_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFu7ll, BFs7i_BFu7i_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFs7s_BFu7s, BFs7i_BFu7i_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c, BFs7i_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFs7c, BFs7i_BFu7i_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFs7i, BFs7i_BFu7i_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFs7ll, BFs7i_BFu7i_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFs7s, BFs7i_BFu7i_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFu7c, BFs7i_BFu7i_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFu7i, BFs7i_BFu7i_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFu7ll, BFs7i_BFu7i_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7c_BFu7s, BFs7i_BFu7i_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i, BFs7i_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFs7c, BFs7i_BFu7i_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFs7i, BFs7i_BFu7i_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFs7ll, BFs7i_BFu7i_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFs7s, BFs7i_BFu7i_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFu7c, BFs7i_BFu7i_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFu7i, BFs7i_BFu7i_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFu7ll, BFs7i_BFu7i_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7i_BFu7s, BFs7i_BFu7i_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll, BFs7i_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFs7c, BFs7i_BFu7i_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFs7i, BFs7i_BFu7i_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFs7ll, BFs7i_BFu7i_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFs7s, BFs7i_BFu7i_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFu7c, BFs7i_BFu7i_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFu7i, BFs7i_BFu7i_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFu7ll, BFs7i_BFu7i_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7ll_BFu7s, BFs7i_BFu7i_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s, BFs7i_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFs7c, BFs7i_BFu7i_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFs7i, BFs7i_BFu7i_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFs7ll, BFs7i_BFu7i_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFs7s, BFs7i_BFu7i_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFu7c, BFs7i_BFu7i_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFu7i, BFs7i_BFu7i_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFu7ll, BFs7i_BFu7i_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7i_BFu7s_BFu7s, BFs7i_BFu7i_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll, BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c, BFs7i_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFs7c, BFs7i_BFu7ll_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFs7i, BFs7i_BFu7ll_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFs7ll, BFs7i_BFu7ll_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFs7s, BFs7i_BFu7ll_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFu7c, BFs7i_BFu7ll_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFu7i, BFs7i_BFu7ll_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFu7ll, BFs7i_BFu7ll_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7c_BFu7s, BFs7i_BFu7ll_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i, BFs7i_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFs7c, BFs7i_BFu7ll_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFs7i, BFs7i_BFu7ll_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFs7ll, BFs7i_BFu7ll_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFs7s, BFs7i_BFu7ll_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFu7c, BFs7i_BFu7ll_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFu7i, BFs7i_BFu7ll_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFu7ll, BFs7i_BFu7ll_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7i_BFu7s, BFs7i_BFu7ll_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll, BFs7i_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFs7c, BFs7i_BFu7ll_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFs7i, BFs7i_BFu7ll_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFs7ll, BFs7i_BFu7ll_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFs7s, BFs7i_BFu7ll_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFu7c, BFs7i_BFu7ll_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFu7i, BFs7i_BFu7ll_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFu7ll, BFs7i_BFu7ll_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7ll_BFu7s, BFs7i_BFu7ll_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s, BFs7i_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFs7c, BFs7i_BFu7ll_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFs7i, BFs7i_BFu7ll_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFs7ll, BFs7i_BFu7ll_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFs7s, BFs7i_BFu7ll_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFu7c, BFs7i_BFu7ll_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFu7i, BFs7i_BFu7ll_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFu7ll, BFs7i_BFu7ll_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFs7s_BFu7s, BFs7i_BFu7ll_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c, BFs7i_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFs7c, BFs7i_BFu7ll_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFs7i, BFs7i_BFu7ll_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFs7ll, BFs7i_BFu7ll_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFs7s, BFs7i_BFu7ll_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFu7c, BFs7i_BFu7ll_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFu7i, BFs7i_BFu7ll_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFu7ll, BFs7i_BFu7ll_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7c_BFu7s, BFs7i_BFu7ll_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i, BFs7i_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFs7c, BFs7i_BFu7ll_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFs7i, BFs7i_BFu7ll_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFs7ll, BFs7i_BFu7ll_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFs7s, BFs7i_BFu7ll_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFu7c, BFs7i_BFu7ll_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFu7i, BFs7i_BFu7ll_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFu7ll, BFs7i_BFu7ll_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7i_BFu7s, BFs7i_BFu7ll_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll, BFs7i_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFs7c, BFs7i_BFu7ll_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFs7i, BFs7i_BFu7ll_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFs7ll, BFs7i_BFu7ll_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFs7s, BFs7i_BFu7ll_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFu7c, BFs7i_BFu7ll_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFu7i, BFs7i_BFu7ll_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFu7ll, BFs7i_BFu7ll_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7ll_BFu7s, BFs7i_BFu7ll_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s, BFs7i_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFs7c, BFs7i_BFu7ll_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFs7i, BFs7i_BFu7ll_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFs7ll, BFs7i_BFu7ll_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFs7s, BFs7i_BFu7ll_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFu7c, BFs7i_BFu7ll_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFu7i, BFs7i_BFu7ll_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFu7ll, BFs7i_BFu7ll_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7ll_BFu7s_BFu7s, BFs7i_BFu7ll_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s, BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c, BFs7i_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFs7c, BFs7i_BFu7s_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFs7i, BFs7i_BFu7s_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFs7ll, BFs7i_BFu7s_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFs7s, BFs7i_BFu7s_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFu7c, BFs7i_BFu7s_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFu7i, BFs7i_BFu7s_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFu7ll, BFs7i_BFu7s_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7c_BFu7s, BFs7i_BFu7s_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i, BFs7i_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFs7c, BFs7i_BFu7s_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFs7i, BFs7i_BFu7s_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFs7ll, BFs7i_BFu7s_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFs7s, BFs7i_BFu7s_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFu7c, BFs7i_BFu7s_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFu7i, BFs7i_BFu7s_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFu7ll, BFs7i_BFu7s_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7i_BFu7s, BFs7i_BFu7s_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll, BFs7i_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFs7c, BFs7i_BFu7s_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFs7i, BFs7i_BFu7s_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFs7ll, BFs7i_BFu7s_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFs7s, BFs7i_BFu7s_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFu7c, BFs7i_BFu7s_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFu7i, BFs7i_BFu7s_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFu7ll, BFs7i_BFu7s_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7ll_BFu7s, BFs7i_BFu7s_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s, BFs7i_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFs7c, BFs7i_BFu7s_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFs7i, BFs7i_BFu7s_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFs7ll, BFs7i_BFu7s_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFs7s, BFs7i_BFu7s_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFu7c, BFs7i_BFu7s_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFu7i, BFs7i_BFu7s_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFu7ll, BFs7i_BFu7s_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFs7s_BFu7s, BFs7i_BFu7s_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c, BFs7i_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFs7c, BFs7i_BFu7s_BFu7c_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFs7i, BFs7i_BFu7s_BFu7c_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFs7ll, BFs7i_BFu7s_BFu7c_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFs7s, BFs7i_BFu7s_BFu7c_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFu7c, BFs7i_BFu7s_BFu7c_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFu7i, BFs7i_BFu7s_BFu7c_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFu7ll, BFs7i_BFu7s_BFu7c_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7c_BFu7s, BFs7i_BFu7s_BFu7c_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i, BFs7i_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFs7c, BFs7i_BFu7s_BFu7i_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFs7i, BFs7i_BFu7s_BFu7i_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFs7ll, BFs7i_BFu7s_BFu7i_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFs7s, BFs7i_BFu7s_BFu7i_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFu7c, BFs7i_BFu7s_BFu7i_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFu7i, BFs7i_BFu7s_BFu7i_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFu7ll, BFs7i_BFu7s_BFu7i_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7i_BFu7s, BFs7i_BFu7s_BFu7i_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll, BFs7i_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFs7c, BFs7i_BFu7s_BFu7ll_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFs7i, BFs7i_BFu7s_BFu7ll_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFs7ll, BFs7i_BFu7s_BFu7ll_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFs7s, BFs7i_BFu7s_BFu7ll_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFu7c, BFs7i_BFu7s_BFu7ll_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFu7i, BFs7i_BFu7s_BFu7ll_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFu7ll, BFs7i_BFu7s_BFu7ll_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7ll_BFu7s, BFs7i_BFu7s_BFu7ll_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s, BFs7i_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFs7c, BFs7i_BFu7s_BFu7s_BFs7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFs7i, BFs7i_BFu7s_BFu7s_BFs7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFs7ll, BFs7i_BFu7s_BFu7s_BFs7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFs7s, BFs7i_BFu7s_BFu7s_BFs7s)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFu7c, BFs7i_BFu7s_BFu7s_BFu7c)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFu7i, BFs7i_BFu7s_BFu7s_BFu7i)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFu7ll, BFs7i_BFu7s_BFu7s_BFu7ll)
//============================================================================



static void Test_BFs7i_BFu7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7i_BFu7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7i_BFu7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7i_BFu7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7i_BFu7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7i_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7i_BFu7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7i_BFu7s_BFu7s_BFu7s, BFs7i_BFu7s_BFu7s_BFu7s)
//============================================================================



static void Test_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFs7c lv;
    check2(sizeof(lv), 2, "sizeof(BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c, BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c, BFs7ll_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFs7c, BFs7ll_BFs7c_BFs7c_BFs7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFs7i, BFs7ll_BFs7c_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFs7ll, BFs7ll_BFs7c_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFs7s, BFs7ll_BFs7c_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFu7c, BFs7ll_BFs7c_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFu7i, BFs7ll_BFs7c_BFs7c_BFu7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFu7ll, BFs7ll_BFs7c_BFs7c_BFu7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7c_BFu7s, BFs7ll_BFs7c_BFs7c_BFu7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), 3, "sizeof(BFs7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i, BFs7ll_BFs7c_BFs7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFs7c, BFs7ll_BFs7c_BFs7i_BFs7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFs7i, BFs7ll_BFs7c_BFs7i_BFs7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFs7ll, BFs7ll_BFs7c_BFs7i_BFs7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFs7s, BFs7ll_BFs7c_BFs7i_BFs7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFu7c, BFs7ll_BFs7c_BFs7i_BFu7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFu7i, BFs7ll_BFs7c_BFs7i_BFu7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFu7ll, BFs7ll_BFs7c_BFs7i_BFu7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7i_BFu7s, BFs7ll_BFs7c_BFs7i_BFu7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFs7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll, BFs7ll_BFs7c_BFs7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFs7c, BFs7ll_BFs7c_BFs7ll_BFs7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFs7i, BFs7ll_BFs7c_BFs7ll_BFs7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFs7ll, BFs7ll_BFs7c_BFs7ll_BFs7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFs7s, BFs7ll_BFs7c_BFs7ll_BFs7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFu7c, BFs7ll_BFs7c_BFs7ll_BFu7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFu7i, BFs7ll_BFs7c_BFs7ll_BFu7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFu7ll, BFs7ll_BFs7c_BFs7ll_BFu7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7ll_BFu7s, BFs7ll_BFs7c_BFs7ll_BFu7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), 3, "sizeof(BFs7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s, BFs7ll_BFs7c_BFs7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFs7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFs7c, BFs7ll_BFs7c_BFs7s_BFs7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFs7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFs7i, BFs7ll_BFs7c_BFs7s_BFs7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFs7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFs7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFs7ll, BFs7ll_BFs7c_BFs7s_BFs7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFs7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFs7s, BFs7ll_BFs7c_BFs7s_BFs7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFu7c, BFs7ll_BFs7c_BFs7s_BFu7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFu7i, BFs7ll_BFs7c_BFs7s_BFu7i)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFu7ll, BFs7ll_BFs7c_BFs7s_BFu7ll)
//============================================================================



static void Test_BFs7ll_BFs7c_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFs7c_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7ll_BFs7c_BFs7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFs7s_BFu7s, BFs7ll_BFs7c_BFs7s_BFu7s)
//============================================================================



static void Test_BFs7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFs7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFs7c_BFu7c, BFs7ll_BFs7c_BFu7c)
//============================================================================



static void Test_BFs7ll_BFs7c_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFs7c_BFu7c_BFs7c");
    static STRUCT_IF_C